(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    364299,       6717]
NotebookOptionsPosition[    359461,       6647]
NotebookOutlinePosition[    359858,       6663]
CellTagsIndexPosition[    359815,       6660]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Pendulum swing up, robust feedforward vs. feedback (Section 9.1.2)\
\>", "Section",
 CellChangeTimes->{{3.698811497715045*^9, 3.698811509022469*^9}, {
  3.69885144307857*^9, 3.698851462312389*^9}, {3.709636905485622*^9, 
  3.709636910921179*^9}, {3.715342867107555*^9, 3.715342872342836*^9}, {
  3.7153432690028687`*^9, 3.715343287448956*^9}, {3.716532618830523*^9, 
  3.7165326217793283`*^9}, {3.716570684194786*^9, 3.716570736464383*^9}, {
  3.716613642404841*^9, 3.716613649251136*^9}, {3.7166173099843607`*^9, 
  3.716617315405965*^9}, {3.7167170388199997`*^9, 3.7167170401560717`*^9}, {
  3.716725771532446*^9, 3.716725778338876*^9}, {3.720265971235908*^9, 
  3.720265985561623*^9}, {3.720420512209653*^9, 3.72042052042764*^9}, {
  3.7938457356798553`*^9, 
  3.793845738375126*^9}},ExpressionUUID->"a1bb5411-324a-4c50-ac13-\
5ee0d82f7ab6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]nom", "=", "1"}], ";", 
  RowBox[{"n", "=", "500"}], ";", "  ", 
  RowBox[{"\[Tau]", "=", "5"}], ";", 
  RowBox[{"\[Tau]1", "=", "8"}], ";"}]}], "Input",
 CellLabel->
  "In[3498]:=",ExpressionUUID->"d5a1adf2-c763-40f1-bb40-9ad6ba5b46c7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ffNom", "[", 
    RowBox[{"n_", ",", "\[Tau]_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "f", ",", "x1", ",", "x2", ",", "\[Lambda]2", ",", "\[Lambda]1", ",", 
       "t", ",", "\[CapitalDelta]t", ",", "bcs", ",", "eqns", ",", "sv", ",", 
       "froot", ",", "x1ff0", ",", "x2ff0", ",", "uff0", ",", "x1ff", ",", 
       "x2ff", ",", "uff"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalDelta]t", "=", 
       FractionBox["\[Tau]", "n"]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"{", 
         RowBox[{"x1_", ",", "x2_", ",", "\[Lambda]1_", ",", "\[Lambda]2_"}], 
         "}"}], "]"}], " ", ":=", " ", 
       RowBox[{"{", 
        RowBox[{"x2", ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sin", "[", "x1", "]"}]}], "-", "\[Lambda]2"}], ",", 
         RowBox[{
          RowBox[{"Cos", "[", "x1", "]"}], "\[Lambda]2"}], ",", 
         RowBox[{"-", "\[Lambda]1"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"bcs", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["x1", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x2", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x1", "n"], "\[Equal]", "\[Pi]"}], ",", 
         RowBox[{
          SubscriptBox["x2", "n"], "\[Equal]", "0"}]}], "}"}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"hard", " ", "final", " ", "constraint"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"eqns", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"bcs", ",", "\[IndentingNewLine]", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Thread", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                SubscriptBox["x1", "i"], ",", 
                SubscriptBox["x2", "i"], ",", 
                SubscriptBox["\[Lambda]1", "i"], ",", 
                SubscriptBox["\[Lambda]2", "i"]}], "}"}], "\[Equal]", " ", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 SubscriptBox["x1", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["x2", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]1", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]2", 
                  RowBox[{"i", "-", "1"}]]}], "}"}], "\[IndentingNewLine]", 
               "+", 
               RowBox[{
                FractionBox["\[CapitalDelta]t", 
                 RowBox[{"2", " "}]], 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"f", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["x1", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["x2", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]1", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]2", 
                    RowBox[{"i", "-", "1"}]]}], "}"}], "]"}], "+", 
                  RowBox[{"f", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["x1", "i"], ",", 
                    SubscriptBox["x2", "i"], ",", 
                    SubscriptBox["\[Lambda]1", "i"], ",", 
                    SubscriptBox["\[Lambda]2", "i"]}], "}"}], "]"}]}], 
                 ")"}]}]}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sv", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["x1", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["x2", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]1", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]2", "i"], ",", "0"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "1"}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"initial", " ", "guesses"}], " ", "=", " ", "0"}], ",", " ", 
        
        RowBox[{"very", " ", 
         RowBox[{"naive", "!"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"froot", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{"eqns", ",", "sv"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"x1ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["x1", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"x2ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["x2", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"uff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"-", 
             SubscriptBox["\[Lambda]2", "i"]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"x1ff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x1ff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "\[Pi]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"x2ff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x2ff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"uff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"uff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"x1ff", ",", "x2ff", ",", "uff"}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]nom", ",", "\[Theta]dotnom", ",", "unom"}], "}"}], "=", 
   RowBox[{"ffNom", "[", 
    RowBox[{"n", ",", "\[Tau]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{3.7204206211573544`*^9},
 CellLabel->
  "In[3500]:=",ExpressionUUID->"a6237697-baf9-422a-9ddf-93319940d50c"],

Cell["\<\
Test the approximate solution on ff for different frequencies \[Omega].  Add \
local linear feedback.\
\>", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.720266088381096*^9, 3.720266105260668*^9}, {
  3.720425382126309*^9, 3.720425399674821*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"7c5aeaa9-1287-449d-ab72-47b84e0bc07e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SwingUpFB", "[", 
   RowBox[{
   "\[Tau]_", ",", "\[Tau]1_", ",", "\[Theta]ff_", ",", "\[Theta]dotff_", ",",
     "uff_", ",", "\[Omega]_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "eq", ",", "init", ",", "\[Theta]", ",", "\[Theta]dot", ",", "\[Theta]s",
       ",", "\[Theta]dots", ",", "us", ",", "t", ",", "J\[Tau]", ",", 
      "\[Kappa]1", ",", "\[Kappa]2", ",", "ufb", ",", "u"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Kappa]1", "=", 
      RowBox[{"\[Kappa]2", "=", 
       RowBox[{"(", 
        RowBox[{
         SqrtBox["2"], "+", "1"}], ")"}]}]}], ";", "  ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"lqr", " ", "for", " ", "q"}], "=", 
       RowBox[{"r", " ", "for", " ", "balancing", " ", "pendulum"}]}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ufb", "[", "t_", "]"}], ":=", 
      RowBox[{
       RowBox[{"\[Kappa]1", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
          RowBox[{"\[Theta]", "[", "t", "]"}]}], ")"}]}], "+", 
       RowBox[{"\[Kappa]2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
          RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ")"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"u", "[", "t_", "]"}], ":=", 
      RowBox[{
       RowBox[{"uff", "[", "t", "]"}], "+", 
       RowBox[{"ufb", "[", "t", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"eq", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"\[Theta]", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Theta]dot", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["\[Omega]", "2"]}], 
           RowBox[{"Sin", "[", 
            RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}], "+", 
          RowBox[{"u", "[", "t", "]"}]}]}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"init", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Theta]", "[", "0", "]"}], "\[Equal]", 
        RowBox[{"\[Theta]dot", "[", "0", "]"}], "\[Equal]", "0"}], "}"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Theta]s", ",", "\[Theta]dots"}], "}"}], "=", 
      RowBox[{"NDSolveValue", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"eq", ",", "init"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", "\[Theta]dot"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"us", "[", "t_", "]"}], ":=", 
      RowBox[{
       RowBox[{"uff", "[", "t", "]"}], "+", 
       RowBox[{"\[Kappa]1", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
          RowBox[{"\[Theta]s", "[", "t", "]"}]}], ")"}]}], "+", 
       RowBox[{"\[Kappa]2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
          RowBox[{"\[Theta]dots", "[", "t", "]"}]}], ")"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"J\[Tau]", "=", 
      RowBox[{
       FractionBox["1", "2"], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Theta]s", "[", "\[Tau]", "]"}], "-", "\[Pi]"}], ")"}], 
          "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Theta]dots", "[", "\[Tau]", "]"}], "2"]}], ")"}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\[Theta]s", ",", "us", ",", "J\[Tau]"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.720425406333407*^9, 3.720425468783058*^9}, {
  3.720425504912958*^9, 3.720425507589197*^9}, {3.720425583610262*^9, 
  3.720425613996662*^9}, {3.720425654261866*^9, 3.720425680781352*^9}},
 CellLabel->
  "In[3502]:=",ExpressionUUID->"f6de5fec-4c3c-4766-a4ce-149d3311d7e6"],

Cell[TextData[{
 "Design ",
 StyleBox["robust",
  FontColor->RGBColor[1, 0, 0]],
 " feedforward for nominal \[Omega] = 1"
}], "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.720266088381096*^9, 3.720266105260668*^9}, {
  3.7202662876706133`*^9, 3.720266313301858*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"4ca37b1a-baa5-46da-9c78-1b31789ed584"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ffRob", "[", 
    RowBox[{"n_", ",", "\[Tau]_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "f", ",", "x1", ",", "x2", ",", "x\[Omega]1", ",", "x\[Omega]2", ",", 
       "\[Lambda]1", ",", "\[Lambda]2", ",", "\[Lambda]\[Omega]1", ",", 
       "\[Lambda]\[Omega]2", ",", "t", ",", "\[CapitalDelta]t", ",", "bcs", 
       ",", "eqns", ",", "sv", ",", "froot", ",", "x1ff0", ",", "x2ff0", ",", 
       "uff0", ",", "x\[Omega]1ff0", ",", "x\[Omega]2ff0", ",", "x1ff", ",", 
       "x2ff", ",", "uff"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalDelta]t", "=", 
       FractionBox["\[Tau]", "n"]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"{", 
         RowBox[{
         "x1_", ",", "x2_", ",", "x\[Omega]1_", ",", "x\[Omega]2_", ",", 
          "\[Lambda]1_", ",", "\[Lambda]2_", ",", "\[Lambda]\[Omega]1_", ",", 
          "\[Lambda]\[Omega]2_"}], "}"}], "]"}], " ", ":=", " ", 
       RowBox[{"{", 
        RowBox[{"x2", ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sin", "[", "x1", "]"}]}], "-", "\[Lambda]2"}], ",", 
         "x\[Omega]2", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], 
           RowBox[{"Sin", "[", "x1", "]"}]}], "-", 
          RowBox[{
           RowBox[{"Cos", "[", "x1", "]"}], "x\[Omega]1"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Cos", "[", "x1", "]"}], "\[Lambda]2"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", 
              RowBox[{"Cos", "[", "x1", "]"}]}], "-", 
             RowBox[{
              RowBox[{"Sin", "[", "x1", "]"}], "x\[Omega]1"}]}], ")"}], 
           "\[Lambda]\[Omega]2"}]}], ",", 
         RowBox[{"-", "\[Lambda]1"}], ",", 
         RowBox[{
          RowBox[{"Cos", "[", "x1", "]"}], "\[Lambda]\[Omega]2"}], ",", 
         RowBox[{"-", "\[Lambda]\[Omega]1"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "  ", 
       RowBox[{"GOT", " ", "THIS", " ", 
        RowBox[{"FAR", "!!"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"bcs", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["x1", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x2", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x\[Omega]1", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x\[Omega]2", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x1", "n"], "\[Equal]", "\[Pi]"}], ",", 
         RowBox[{
          SubscriptBox["x2", "n"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x\[Omega]1", "n"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x\[Omega]2", "n"], "\[Equal]", "0"}]}], "}"}]}], ";", 
      " ", 
      RowBox[{"(*", " ", 
       RowBox[{"hard", " ", "final", " ", "constraint"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"eqns", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"bcs", ",", "\[IndentingNewLine]", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Thread", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                SubscriptBox["x1", "i"], ",", 
                SubscriptBox["x2", "i"], ",", 
                SubscriptBox["x\[Omega]1", "i"], ",", 
                SubscriptBox["x\[Omega]2", "i"], ",", 
                SubscriptBox["\[Lambda]1", "i"], ",", 
                SubscriptBox["\[Lambda]2", "i"], ",", 
                SubscriptBox["\[Lambda]\[Omega]1", "i"], ",", 
                SubscriptBox["\[Lambda]\[Omega]2", "i"]}], "}"}], "\[Equal]", 
              " ", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 SubscriptBox["x1", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["x2", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["x\[Omega]1", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["x\[Omega]2", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]1", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]2", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]\[Omega]1", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]\[Omega]2", 
                  RowBox[{"i", "-", "1"}]]}], "}"}], "\[IndentingNewLine]", 
               "+", 
               RowBox[{
                FractionBox["\[CapitalDelta]t", 
                 RowBox[{"2", " "}]], 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"f", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["x1", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["x2", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["x\[Omega]1", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["x\[Omega]2", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]1", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]2", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]\[Omega]1", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]\[Omega]2", 
                    RowBox[{"i", "-", "1"}]]}], "}"}], "]"}], "+", 
                  RowBox[{"f", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["x1", "i"], ",", 
                    SubscriptBox["x2", "i"], ",", 
                    SubscriptBox["x\[Omega]1", "i"], ",", 
                    SubscriptBox["x\[Omega]2", "i"], ",", 
                    SubscriptBox["\[Lambda]1", "i"], ",", 
                    SubscriptBox["\[Lambda]2", "i"], ",", 
                    SubscriptBox["\[Lambda]\[Omega]1", "i"], ",", 
                    SubscriptBox["\[Lambda]\[Omega]2", "i"]}], "}"}], "]"}]}],
                  ")"}]}]}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sv", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["x1", "i"], ",", 
               RowBox[{"0", "i", " ", "\[CapitalDelta]t"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["x2", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["x\[Omega]1", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["x\[Omega]2", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]1", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]2", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]\[Omega]1", "i"], ",", "0"}], "}"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]\[Omega]2", "i"], ",", "0"}], "}"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "1"}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"initial", " ", "guesses"}], " ", "=", " ", "0"}], ",", " ", 
        
        RowBox[{"very", " ", 
         RowBox[{"naive", "!"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"froot", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{"eqns", ",", "sv"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"x1ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["x1", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"x2ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["x2", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"uff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"-", 
             SubscriptBox["\[Lambda]2", "i"]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"x\[Omega]1ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["x\[Omega]1", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"x\[Omega]2ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["x\[Omega]2", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"x1ff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x1ff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "\[Pi]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"x2ff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x2ff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"uff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"uff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
       "x1ff", ",", "x2ff", ",", "uff", ",", "x\[Omega]1ff0", ",", 
        "x\[Omega]2ff0"}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\[Theta]rob", ",", "\[Theta]dotrob", ",", "urob", ",", "x\[Omega]1rob", 
     ",", "x\[Omega]2rob"}], "}"}], "=", 
   RowBox[{"ffRob", "[", 
    RowBox[{"n", ",", "\[Tau]"}], "]"}]}], ";"}]}], "Input",
 CellLabel->
  "In[3503]:=",ExpressionUUID->"6cd31715-6a82-493e-a472-e538d00a951a"],

Cell["\<\
Evaluate nominal & robust feedforward controls u(t) for different frequencies \
\[Omega]\
\>", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}, {3.7202659495166073`*^9, 
  3.720265950298832*^9}, {3.7202747979755707`*^9, 3.720274806107464*^9}, {
  3.720274948616645*^9, 3.720274960711134*^9}, {3.720276330642107*^9, 
  3.720276350511654*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"b623d4bb-d420-4aee-85d7-06a0748df8b8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]1", ",", "u1", ",", "J1"}], "}"}], "=", 
   RowBox[{"SwingUpFB", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "\[Theta]nom", ",", "\[Theta]dotnom", ",", 
     "unom", ",", "\[Omega]nom"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]1a", ",", "u1a", ",", "J1a"}], "}"}], "=", 
   RowBox[{"SwingUpFB", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "\[Theta]nom", ",", "\[Theta]dotnom", ",", 
     "unom", ",", 
     RowBox[{"\[Omega]nom", "-", "\[Epsilon]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Theta]1b", ",", "u1b", ",", "J1b"}], "}"}], "=", 
    RowBox[{"SwingUpFB", "[", 
     RowBox[{
     "\[Tau]", ",", "\[Tau]1", ",", "\[Theta]nom", ",", "\[Theta]dotnom", ",",
       "unom", ",", 
      RowBox[{"\[Omega]nom", "+", "\[Epsilon]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]2", ",", "u2", ",", "J2"}], "}"}], "=", 
   RowBox[{"SwingUpFB", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "\[Theta]rob", ",", "\[Theta]dotrob", ",", 
     "urob", ",", "\[Omega]nom"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]2a", ",", "u2a", ",", "J2a"}], "}"}], "=", 
   RowBox[{"SwingUpFB", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "\[Theta]rob", ",", "\[Theta]dotrob", ",", 
     "urob", ",", 
     RowBox[{"\[Omega]nom", "-", "\[Epsilon]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]2b", ",", "u2b", ",", "J2b"}], "}"}], "=", 
   RowBox[{"SwingUpFB", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "\[Theta]rob", ",", "\[Theta]dotrob", ",", 
     "urob", ",", 
     RowBox[{"\[Omega]nom", "+", "\[Epsilon]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.720425730687096*^9, 3.720425775826027*^9}, {
  3.720425822177505*^9, 3.720425834219445*^9}, {3.7204265159287233`*^9, 
  3.720426616086698*^9}, {3.720432121594632*^9, 3.7204321407678003`*^9}},
 CellLabel->
  "In[3505]:=",ExpressionUUID->"12605c02-6d7a-411d-95ec-0839ac4136b3"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.00126549937517`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3506, 285, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229814028029*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"8fdd263c-2ed1-48c2-b543-1471a9226828"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.00126549937517`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3506, 286, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232298140374193`*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"27957dc7-09f8-421e-9723-224d22c55e15"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.00126549937517`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3506, 287, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229814041402*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"4a5c688a-b6ac-4963-bcce-3ae72de7d07b"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 3506, 288, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.82322981404529*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"37f7ba45-466f-4cde-8269-83f0b51f7100"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.012675918328149`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3507, 289, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229814049369*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"19fdf806-5e4d-42c0-844b-dd4a1c15815c"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.012675918328149`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3507, 290, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232298140531807`*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"977c15f9-bbd0-485c-af76-77b80d24962b"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.012675918328149`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3507, 291, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229814056801*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"f9850852-2cef-4ca1-971a-7f2136bd1c57"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 3507, 292, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229814060349*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"1dddab5e-fd68-41f9-8c08-b153da0906a8"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.013396741599489`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3508, 293, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232298140637627`*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"0d169221-bfdb-4925-8d8a-322776fa3069"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.013396741599489`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3508, 294, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229814066883*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"a6efba2c-6cf7-4825-bd95-5ca577bd32d6"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.013396741599489`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3508, 295, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229814070112*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"de647e03-31e0-4ec4-95ce-8ae9b10e6b47"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 3508, 296, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229814073361*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"a6de2033-5162-4478-b4b8-fdf9d5bdce7a"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.020196959902291`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3509, 297, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229814076872*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"84a88c75-83c6-4e1e-8489-628399e91848"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.020196959902291`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3509, 298, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232298140800447`*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"af22c570-d8d4-48d5-8b08-4aef4e9de77d"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.020196959902291`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3509, 299, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232298140832453`*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"8780a7d3-edf5-4a05-855c-fe9569cd6a99"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 3509, 300, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229814086444*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"91241488-b4c0-4f85-bc04-20b0d2b2c92f"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.032615511803473`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3510, 301, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232298140908403`*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"4edc1406-25ff-4ab3-9894-ca967945f895"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.032615511803473`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3510, 302, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232298140940037`*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"315d13c1-637d-4ab9-9d8f-a5a2a71f96cf"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.032615511803473`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3510, 303, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229814097288*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"09f55049-4cd0-4e5a-863e-c26edccab7da"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 3510, 304, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232298141004066`*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"d43d2056-65fa-4bc9-a99a-47a207ae10ca"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.047373002872562`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3511, 305, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229814103574*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"611ae81b-9927-4c0c-b316-c24abbec1616"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.047373002872562`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3511, 306, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232298141065693`*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"7155be5b-92e0-4a53-9ee7-24b6ec7e46ea"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.047373002872562`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3511, 307, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.82322981410955*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"4e79bb1d-8685-49f2-a27d-f08d8b3d2314"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 3511, 308, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229814112213*^9},
 CellLabel->
  "During evaluation of \
In[3505]:=",ExpressionUUID->"96aab984-ef82-4209-9d92-0ea9ac2ad163"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Plotit", "[", 
    RowBox[{"\[Theta]_", ",", "u_", ",", "\[Tau]_"}], "]"}], ":=", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]", "[", "t", "]"}], ",", 
       RowBox[{"u", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4"}], ",", "4"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p1", "=", 
    RowBox[{"Plotit", "[", 
     RowBox[{"\[Theta]1", ",", "u1", ",", "\[Tau]1"}], "]"}]}], ";"}], "   ", 
  
  RowBox[{"(*", " ", 
   RowBox[{"nominal", " ", "algorithm"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p1a", "=", 
    RowBox[{"Plotit", "[", 
     RowBox[{"\[Theta]1a", ",", "u1a", ",", "\[Tau]1"}], "]"}]}], ";", 
   RowBox[{"p1b", "=", 
    RowBox[{"Plotit", "[", 
     RowBox[{"\[Theta]1b", ",", "u1b", ",", "\[Tau]1"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p2", "=", 
    RowBox[{"Plotit", "[", 
     RowBox[{"\[Theta]2", ",", "u2", ",", "\[Tau]1"}], "]"}]}], ";"}], "   ", 
  
  RowBox[{"(*", " ", 
   RowBox[{"robust", " ", "algorithm"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p2a", "=", 
    RowBox[{"Plotit", "[", 
     RowBox[{"\[Theta]2a", ",", "u2a", ",", "\[Tau]1"}], "]"}]}], ";", 
   RowBox[{"p2b", "=", 
    RowBox[{"Plotit", "[", 
     RowBox[{"\[Theta]2b", ",", "u2b", ",", "\[Tau]1"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "p1a", ",", "p1b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p2", ",", "p2a", ",", "p2b"}], "}"}]}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "4"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"600", ",", "300"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.720425893471184*^9, 3.7204259119168453`*^9}},
 CellLabel->
  "In[3512]:=",ExpressionUUID->"bdee4149-6813-4459-b98d-def2a01ac7f5"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmnk8VF/cx1XSkGwztrFlaSEkSYvyPcVPZSuh3a5NUUmLiqjskhJFyhrZ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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{
              PolygonBox[{{581, 730, 728, 291, 292, 293, 294, 295, 296, 297, 
               599, 525, 460, 405, 360, 329, 626, 552, 487, 432, 387, 298, 
               600, 526, 461, 406, 361, 637, 563, 498, 443, 649, 575, 510, 
               330, 627, 553, 663, 488, 655}}], PolygonBox[CompressedData["
1:eJwV0stXzGEAx+EZ/4Bccr9kay6VUMpsbEfJ5B6V3C81cqdVnULn2HZSGYrE
qnNUbPkLXEJRYS3asrHoeRfPmc/7PTO/OWfe2dSYzTQvikQiUUZIiRnDLDle
Ot/1muK/7qBNl/JXvyHGYefFvNM9nCdNnCP2PN7rB1xgN1dtm/mlR+kkQa1t
CR90LxepJMlR+1I+6j6aqKKQY/ZlTOh+mtlDEXX25XzSD8lSTTH19nw+6xyX
2MsWGuwr+KIf0UKGEo7bVzKpH3OZGrbSaF/FlB7gCvu4Zosxp8e4wzZO2Fbz
VQ+G34b9bOekfQ3f9JPwDA5w3Rbntx4P90Qpp2xrmdZPw/s4SBmn7euY0UPc
4BA7OGNfH+5eP+NmuFfKOWvfwHc9zK1wr+HztgR/9CvuUcE520Z+6OfcDvfK
zvDfsBfwU7+gNdxr+D5bknn9mi7ancv4p99yX+8iSjdpBlgAEeNSQw==
               
               "]]}]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV0ttPDnAYwPG3cqjkUM6nKNRlMWxoSRE1xxzuUiq5EHGJ5BSzjlRrouna
sUsxbKSc/oHcUbhEkw3N9PldfPZ8n2fv3nNKWXXR8ehIJBJFPwnig8MgqTqF
pSwhmcUsYiELmM885rKNI7TzngTPcYA5eiuVtPGOKe77ma0v0sNX0t1Okq8P
08pb4t32MUs/5xdr7ee5oB/yhTT7CbboJ4ywyl5Dhf7Del3Hdf2GOL2XmeFL
MDfRwLPwvsPjGNWd5hrOhde13zYLaGPMftPM4goP7F3mZpr5bO8wV1Ad7vZu
s5B2/tlvmdlc5bE937zGD33DXMkZysN3bbbyW68zL4XH6jyzidc61iwiSf8n
R9fzVP9kta4Nn0f/ZYO+zH09zHId/hx5upfvZNpPU6ZbGGCyfQ+JupZ7DLHM
7Ri5+hHfyLCf4pBupp9J9t3M0Ge5yydS3arC76FLaeIVE912MV3XcIeP4b/q
dpQcXUIjfUxw28k0vZGDNPCSGPcdTNXZFFPPC6LdtzMObIdZrw==
              
              "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl01W0FmUYgNGfIyEdUpIeSpHuLpWQUkCkpTsO3Z2CNNKpooB0o4B0h5LS
3d1dexYXe571ztWs750vvEFE5TaRQqFQTI+gZ1hOFMMwfcP/RDc30Kf8SzTz
n/qBntKvuM8OfiGS9ye0Ny85zBJycZ0NTKQ9zznAAqrymL38wUDCOMsKfqIh
JXnATn6lD7m5wUYm0YHvg2/kHCsZTiNKkYebbGIyHalGZM6zihE0pjR5ucVm
ptCJ6sFZcYHVjKQJZchHVC6yhlE05WvyB2fIh8HZEiPYAbGITRziEo/4JOAj
EpKIxCQhKR+TjORc4i9G04yyFCAFl/mbMTSnHAW5zRam0pkapOQKaxlLC8pT
iDtsZRpdqEkqrrKOcbSkAg/ZxW/0pTB32cZ0uvKCgyykFk/YxxwG8ZqjLCM1
11jPz7zlGK14xn/MpyKP2M1swvyPJ7UfrzgSnL13S4N96+nQ+ztQRO+xPdid
eYYGF+N4sCPtpodYRG32M5fBfMI/jKc137CH3+lPUWbSncXUYR5DCKcN3zKA
YvxAGipRnB7U5UfSEkFlSjCLntQjHRNoSxW+ID0Z+JTPyMjnZCIzWchKNrKT
g3Z8x5f0oj5Dyck7FKOBjg==
              "]]},
            Annotation[#, "Charting`Private`Tag$1999430#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV0jVsVXEUwOFLcWiLu75SZcFJkFQo1UBbii5Y8QAtMuFFg1MoFA3MUGzD
SXDfGXEIA06CBPn+w5fzO6fNS+59L1ZRVV7ZIIqi98SLMXFRFMcNvZ2pZJLA
WPeG3NQ7mEYWiZS4N+KW3sl0slnoFuOZPslqWlHq1pjbehczyGGRWxLP9SnW
0Joytybc0buZyQp7Pz7oC4xisb0PL3Q9a2nDOLem3NV7qGClvT8f9UVyqbQn
81KfZrMewS+9LnyeHsxXfTW8I53NP92Wct2Me+G5zFxq9EZzGD/0PrOQWXqV
OYBDfLLXmPlc0lvNTI7yx77fLOYEo+1VZgp1vArvJdw5xhn7FnMkR/htrzWL
OE51eB5zCIf5Zt9rFnAtfL9mDhHt7OPN5twP/8cmPZyfenb4XvVAPuvL5LHE
nsprfZb1VNuH8l1fpz0T7C14EN4Nc8hnqVsab/Q5NtCBiW4teRieibkU0JFJ
7vE8Cu+LeRTSic50oSvd6E4PetKL3sRI4mn4HZnJpJBKGulkMNnfE3isDzCf
Ipa5pfNWnw/fO32Z4pbIE13HgvDbtg/ii77CNp3FX13Mcp3BQd6F362Zx3+1
kWkY
              "]], LineBox[CompressedData["
1:eJwV0slXjXEAx+G3/oESRRO11YBKg9i0zdggMlaGRG6hSSuOonPaOmhQhtTC
Rmirv8BQiFKthS2bFp7f4jn3837vdO79vdmNsaqrcVEUvWQ0PopeubjrcR/r
+g63dAl/9TtyOO46gff6AS1Ukku9PZEP+iGX2c8N23Z+6mn6yOOEbQMf9SOu
cIB8TtqT+KSHaOUgOzhl38icHib8kEPs5LR9E/N6hBiH2cUZezKf9ShtHKGA
s/YUvujHtFNFIQ32zXzVY1yjmiIa7VtY0ONcp4YOWw5r+jX97KbJlso3/ST8
N9RSzDl7Gt/10/AZHKXTlssv/SacEyWct6WzqJ+F11FHKRfsGSzp53RxjDIu
2jP5oSfoDufKHprtW1nWL+gJ5xreb8vjt37LPcq5ZNvGip7kZjhX9oZ7w57F
qp6iN5xr+D5bPn/0DAPcdl3KPz3LoK4gjvtUMh7uT8/9B9LMUIQ=
              "]]},
            Annotation[#, "Charting`Private`Tag$1999430#2"]& ], 
           TagBox[
            {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{676, 726, 677, 678, 679, 680, 681, 682, 683, 684, 685, 
              686, 687, 688, 689, 690, 691, 692, 693, 694, 695, 696, 697, 698,
               699, 700, 701, 702, 703, 704, 705, 706, 707, 708, 709, 710, 
              711, 712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 722, 723,
               724, 727, 725}]},
            Annotation[#, "Charting`Private`Tag$1999430#3"]& ], 
           {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
            LineBox[{674, 675, 673}]}}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Background->GrayLevel[0.97],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{7.989795918367345, 1.4999999999999432`}, {7.5, 
        6.500000000000014}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 7.999999836734694}, {-4, 4}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {182, -113.24611797498106}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}], InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdu3k01d8X/y8KVzJd8zVHIUmJRvYpkrHMc3KlQSFjaRBCKdKEEBEyZS7S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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{
              PolygonBox[{{666, 856, 854, 317, 318, 319, 320, 321, 322, 323, 
               324, 325, 326, 689, 587, 501, 433, 384, 357, 712, 610, 524, 
               456, 407, 327, 690, 588, 502, 434, 385, 732, 630, 544, 476, 
               758, 656, 570, 358, 713, 611, 783, 525, 768}}], 
              PolygonBox[CompressedData["
1:eJwVyTlOglEYhtFf7R0bW1t694AioFhhScCfKboFo6ImbsB5E6LAEmTcBT2V
KJBwbnFy3+e7e4XL3MVqFEUrnJFf87LLj+PE5yP7POmx94oEY53k007zGzbX
xHTdiqzT1c8c0NQZpmFzQ5meW4kNevqFQ750lr+wuaVC3+2cTfr6lRTf+pj/
sGlQZeAWs8VAv3FES58wC5s7agzdymwz1O+kaesc87C5p87IrcIOI/1Bho4+
ZRE2DywBAlk0EQ==
               "]]}]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwV0blOVQEUBdArGMZYYAKFQQ0VIigojoiFOICWFFCICk9qTZxwhAoTLSSC
QEyMMcaESYGKD2D8BZASqUBmCwqj6xQre+9zw3tcKErdr7+XliTJHiYoURrT
k6SBav0CVZznHGc5w2lOUUkrHYyzww0fOM5J/S7tjLHNdfcxTuh9zJFrtzBH
yl7ksP6YRV7Zo2xRZ49SoS9TonewTG/8TvItG8zaObI5enxHvIfs4g8/7U8y
zbseko/ixkv3LzLDvULul6/lKj88K7D79b9s2vvs2nhGuV1of9Nz5EWZL3vk
Lr88P2B/1vfKIzJPtsczPnj+VWa5Vco3rDPj/lH+I5s7cYt3i/+LfMcOC/ZB
+TA6L+xy2ckK3+0NrkXnuL5EcfydWaLHniZLv810fJ89H++mP2Ce5/YI61y1
RzimdzNFpn2Lqfgc+xnDrHHFbZgy/T2TZNhNTMbP2U8Z4jeX3YYo1ZtoY5BV
atwHOarf5AkDrHDJfYD/6kBcdg==
               "]], PolygonBox[CompressedData["
1:eJwV0ktLlGEYBuBvnCSiiCA7TNHCyjZlUItcJNU/KM3D6OxaZmVqUZqbDmAn
7YBFEJE6NT9CLbVf4CldqenGDGphi6JCu57Fxf3cz8t88H7flF5orr5SlCRJ
ik80pJMkR6PFPllwuEWekS/5xzdnR+W9mCnos+w1tzDLdf0pYxTrOcZo0LPU
U8c1njDKBueNjFKrv2eGPfpVZmjTlzhk7mSJHn2EdDyfEWr00/IFf1nRy+Xd
mHmnV8hufvJZfy1T7pqRzbGj1T4vN9lXyhL5XP5m0VlGf2NOyzK5Td6Ks3h2
vBO937xRHpfb5X35g4/Od+mvzGsUsVXPxhnn4x3IzXanZC9/+Gr/VhbbH5F3
Ykfe/oR8zCrT+m4ZH3g6vo1+Uj7jF1/0g7Ij5vidfkx28Z0PekrWx0y1vsxh
822WGdCn4h7my0zFt9IXOGBuZ4FH+nD8ycx1DFOl9zPJTv0Sk/Hu9Xn2m28y
z0N9iHVq9SHOmfuYYIfexETcV5+j1HyDOR7og6xRow9yNt4j45ToFxmPe+j/
Aa1aZpY=
               
               "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV1He4jmUcwPFzyDiVIiR1ZFZmRkhGiGRU9h7J3gcNIdllZGSvMtIwy9ag
IsoeKaPM0KCQUTLq8/vjc77385znes59fvd7vbnbpNTrkZiQkFDAj+hpPiKH
i6F6l/6oefU5vVW/01z6gd6jx7UqidZb9R2yWh/RftxhvV8X8Qh/8yWT6Mnt
fv+9LqAhaV3v0ncZSCp+4WOG0Zon477ntuls+lOSf/iKyfSiEan5lWUM53mq
UYqrbGAKvWnMLfzGcl6nDU9Rmn/ZyFReoAlp+J0VvEFbqvNo/C+cYSUjaEcN
ypCO9CTFXLktZkGGmBl3kpFMcQ5kJkvMlrvJFvMnO/dyllWMpD01eYz7+IPV
jKIDtSjLNb5mGi/SlGT+ZA2j6cjTlOM6m5jOSzQjB+dYy5t04pmYu/PZrnN4
lfLcYDMzeJnmMQfP7db5DOJ+zvMJY+jMs3EuntuhcxlABW7yDTPpE7PzzA+6
kBYxX9d79L2Yl/UxHRxztT6oS2I+1ic1Jxf4NPbg3tiYuf6k+bRLnJHu09z6
YcxeT+iDWjs+C7oz3qXz4pz0qD6gr8WZ6gHNo4vj3PRnfUgf1//4lllx1u4d
jr34AL+iLcnFX3zGOLpSh4qxp3gveWO/8TdjX/Fu8lOAghSiMEV4mIt8zni6
UZdKFOUS63iL7tSjMsW4zHom0IP6PEFxrvAFE0mhAVWIL5kt8jZ9aUWSe3v1
fYaQyfUhXUqy9anYv5bQ/wHChYTc
              "]]},
            Annotation[#, "Charting`Private`Tag$1999482#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV0ElvTQEYBuCjxNwICQsxrqippUVbY2fTysJGB26xJDHU2JYFCQtT0RAR
EUlrqOkndPYPOsWm7aqlRdvEQni+xZP3fb+zOOfe1akzh09PS5LkGxlKU1qS
FDASnRqOso5m90JGo3ORctbzxr2I79G5RAWtbuXMpNV+wAbe2sX8iM5lKmlz
q2AWbfZDNvLOLmEsOlfosc+yjB67ina9ktm02w0M6rWsYdDexHu9lPHojOg3
yeSq3SvPsZxee0LeJZdjdoesYg7/eEqH+5i8TXZ8w/QkeSUfuQ/JOha6rZUz
5Au5VA55/kdvYLG9S86Vr+O3yUzPW/Qy0u2f9l+9kSV2iz2q32KRnRX/t3wp
r3nWJ8+zgjT357LPfVLeI4/jdmf8tng3nfa4vEMOj+1hWU8Gw3YWH/R9/IpO
Lf32BVbSb6foincwjy77CZv5aO/nd3TqqGYLn9wPMBGdek6QTQ5b2cZ2cskj
nx3s5Ej8l3I3e9hLAYUUUUwJpXz2noNMRuc6J+l2SzGfbruRMr7Yh5iKzg0G
7BpWMWBPyfvkc8r+KqtZ4LvSZSKfyf+KBG7v
              "]], 
             LineBox[CompressedData["
1:eJwV0slTznEcB/CnYoxh7FuMQ7aDbYYZHBgcbYVI4mbQhqxjPVBRJNtgkITw
D9gp1VFFWp0oHdpmmMFBZHt9D6/n/Xl/vjXPPN/fL25LVuKuqEgkEutjXEwk
8lp+jY5ECpjHNb1DHmc6HfoyHprj+RFmskml2m4rQ6jWr7OcR3oCvWEmhzRq
7LYxlBr9Bit4rK/mZ5jJJZ1au+0Mo1YvYiVP9DX8CjMnyeCNXSrDeaPfZBVP
9bX0hZlTZPLWLo0RvNWLieeZnsjvMJPHDurs0hlJnX6LBJ7r6/gTZvJJcb87
5Tv7DEbxTi9hNS/09fwNM6f5oB8kjg96eFj15kxGU6/fZg0v9ST+hZkzfNQP
MYmPehYN5h2MoUG/w1rK9A1EKNMLaDUfZjKt+m4azTsZS6N+l07zCWbQqSdS
bk4minL9s8xjDmf1NnmEKbTpP+RFFrJHb5K7GEeT/i38H/Mp1btkNjPp725L
ZJf9L3mZxQyyvx+ehf0ruTG8m3bR4Z7D+x1+h/7K+RdzfniW+lw5QN6RE2Sh
80/mo+Hd06fKGFksY+Un573mS+G56ovkQFkq9zprllnhb8N92BfJZvvvspAF
3NO7ZQ6z6Nb75BWWhHdDr5Ap4bup0M/Rbj7GNNr1fbSYdzOeFv0+SVTqm+hH
pX6e/WwgmY3hPaXK+eZwr1TpFzjA+/Bswp3wXn9AjzmX2fTov+VVljLYb30g
J8pNzv4DnyaW1g==
              "]]},
            Annotation[#, "Charting`Private`Tag$1999482#2"]& ], 
           TagBox[
            {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{802, 852, 803, 804, 805, 806, 807, 808, 809, 810, 811, 
              812, 813, 814, 815, 816, 817, 818, 819, 820, 821, 822, 823, 824,
               825, 826, 827, 828, 829, 830, 831, 832, 833, 834, 835, 836, 
              837, 838, 839, 840, 841, 842, 843, 844, 845, 846, 847, 848, 849,
               850, 853, 851}]},
            Annotation[#, "Charting`Private`Tag$1999482#3"]& ], 
           {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
            LineBox[{800, 801, 799}]}}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Background->GrayLevel[0.97],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{7.989795918367345, 1.4999999999999432`}, {7.5, 
        6.500000000000014}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 7.999999836734694}, {-4, 4}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {546, -113.24611797498106}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}], InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmnk4lF/89yVxa7HNqIgmoUWSJKL0OURICqEIWSqi1ZI9FFIpFaFQyb5m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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[
             PolygonBox[{{461, 594, 592, 260, 261, 262, 263, 479, 422, 375, 
              338, 311, 294, 493, 436, 389, 352, 325, 264, 480, 423, 376, 339,
               312, 500, 443, 396, 359, 512, 455, 408, 295, 494, 437, 527, 
              390, 518}}]]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwVzT1bwWEUwOF/mSgvpVKabKgvIFlZTFFZWevSXGm2arH4AlSzVYul2Reg
zK1ZXN2G+/o95wznybQertrbQRBsUSVpqFHn1DKlM43qQL8Ied/rK5+sqNCi
y5hfzinR4IUPlqQ54XhznyMOOSDJPnskiBPb/M8Zl9zS4Z0fdslT5IZn3vhm
hxwXXPPEiAURshSo88iQOWHu6DHhjzJ9pqxp8g8pyB/Q
               "]], 
              PolygonBox[CompressedData["
1:eJwl0VtMjmEAwPHvS4Y0w3AlRC6JlEsUF8qp3Dm2VUxtlQqXTnVBDRuaZeXc
JYULh8VGZoxFLJFy6VAhdKATv3cufvu/z+F9vu/5vtiswo0FEaFQKEwjnWSY
SGeMyQjC4f8b/sooIwwzxCB/+M0A/fQx3/6lZLCPWj7Qa22VZlLGTbqJI4l0
9nKFDn7Zv1K3U8oNupjHTiq4G+wjkVM8ZIgN7OEy7fx01ll9GtzL/fL0JRM8
n9D7DJDCKyaar9RHjLCN54w1f1gn6XXtZC4zjF9rtJ7Rqfo4+N3YwTTjJh2n
5TpZ7wTfiyVMN27WKD2pU/SBDrKeZ0SaK9FLvOeHO1Xpk+B/sparLxjv+bje
o59kTtPIMFs5RD1fiCWHo9wOziWBdRRzkTZ6fN4uPUYDfaxgCwep4zNzyOYI
t4L3WMxairjAO747b7lu5gDX+MRsFrGG3ZznLd/sX6ab2M9VPjKLeNIo5Byt
fLU/RheSSgE1vKHbWhczPS9gNflU08I/vmdtSw==
               
               "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV0mN7FgAAheE3u7XsWi3b5tLW0rJrWVu2vdaybdu2bdv1K7r34b6e7+c6
IdGxUTFJAoHAPxJ7iVX8YhRfOcsfOvCe4/xmCT+4QH1ecIA4vnGOoXziFMup
xH22M50+fOQky2jBG46QwHCScpnVjKYjDXjJQRYwjMo8YAcz6EtLknGFNYyh
Ew2pwkN2MpN+tCI5V1nLWDoTRlUesYtZ9Kc1KbjGOsbRhUZUIyXXWc94utKY
6qQiNWlISzrSk4GMBJGJYDKThaxkIzs5yEkucpOHG2xgAt1oQg3ycpONTKQ7
TanJY3YzmwG0IR+32MQketCMWjxhD3MYSBT5uc1mJtOTcF5xiHhiqM1T9jKX
QbTlLUdZxAgKcIctTKEXHzjBUiJ4zWEW8p3zxPKZ06ygDs/Yx7zEvZxpsLaj
IHfZylR605y6hFCIwoRShKIUozglKEkpSlOGspSjPBW4xzamEU0k9XjOfuYz
hPa84xiLGckXzrCSn1zkLxX5Dy9DbTU=
              "]]},
            Annotation[#, "Charting`Private`Tag$1999534#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV0ldsT1EAwOHbqpppS/Bk1eoTWvvJltijnmxRtRJq82QTW2LEiE15sokt
MWLEJvZ8saqt3epS33n48rvn3HPvufd//8ljstKnxERR9IEcnhhsZzI9aU5d
vjqXy1PHOwgX9aIF9chz7pnuJIvetKQ+HznEPIbQkXzrn+suptKHVBrwicPM
Zyid+Gb9C93NNPqSxndOs5wMGvKZIyxgGJ35wwXWMCFc534vdQ/T6UcrfnCG
FYwlmS8cZSHDKeUqG+lCARdZS+XYKLqvE4lxfFO3hvva75XuZQZxzt3W/hRz
mRrm1mtVfai1tbX+5CxJxiu1kt7TWpqp5VynpvFmra6PtY420hyOkWC8SCvq
HR1BGdfYRDXzj7QrhVxiHVXMP9BJxDq+pdvCc3mn17qPmQyghCtsoA2/OMcq
xtE4/Jc4zmJG0i2sc683up9ZDKQtTcjlBEsYRXd+W/9Ws5nNINrRNHxr5woo
5C9FFFNCKWX8o5wofKfwXlQI+3q/uPAbER9+a95xgDmk055m5HGSpYymR/j+
vOcgcxlMh/C8nGc144nsc0O3kEI+p0g0vyzsrXf1PydafI8=
              "]], 
             LineBox[{531, 353, 510, 453, 406, 326, 504, 447, 400, 363, 265, 
              481, 424, 377, 340, 313, 296, 266, 482, 425, 378, 341, 314, 297,
               267, 483, 426, 379, 342, 315, 298, 268, 484, 427, 380, 343, 
              316, 299, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279,
               280, 281, 282, 485, 428, 381, 344, 317, 300, 495, 438, 391, 
              354, 327, 505, 448, 401, 364, 515, 458, 411, 525, 468, 535, 
              283}]},
            Annotation[#, "Charting`Private`Tag$1999534#2"]& ], 
           TagBox[
            {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{540, 590, 541, 542, 543, 544, 545, 546, 547, 548, 549, 
              550, 551, 552, 553, 554, 555, 556, 557, 558, 559, 560, 561, 562,
               563, 564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574, 
              575, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587,
               588, 591, 589}]},
            Annotation[#, "Charting`Private`Tag$1999534#3"]& ], 
           {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
            LineBox[{538, 539, 537}]}}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Background->GrayLevel[0.97],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{7.989795918367345, 1.4999999999999432`}, {7.5, 
        6.500000000000014}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 7.999999836734694}, {-4, 4}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {910, -113.24611797498106}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}]}, {InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxd3Hc81f//P/5jnWFmNMgWUZJXaMrjIZK9oihkp5JKSEa0NEgqlBHKCikl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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{
              PolygonBox[{{933, 1136, 1134, 531, 532, 533, 965, 851, 755, 677,
                616, 575, 534, 966, 852, 756, 678, 617, 576, 1000, 886, 790, 
               712, 651, 535, 967, 853, 757, 679, 618, 577, 1001, 887, 791, 
               713, 652, 536, 968, 854, 758, 680, 619, 1015, 901, 805, 727, 
               1037, 923, 827, 578, 1002, 888, 1062, 792, 1047}}], 
              PolygonBox[CompressedData["
1:eJwV0UtLlFEABuBv1FqMOYEQhHRRCE2IHNOkoF1q2rJVaRq0TB1/Qd5RVwpd
vS2CIkKRVmmZt35B6srEUvFSubFcVQvzOYuH933PGef71Lz7zbdSaVEUxXhF
U0YUNXLg4F16FF1n0weecpsiVp09IM603cp/n5+wy9myn3GHJF+dNZDJjN0W
HsikXcG2/pwa9uyHnOazXcw3vZFjzNoZ3u+Rfol2+4/sJp9lO8Z7vZIdfSA8
z8/02ReptX/JFs5w0t1rueA8rg/oVzirj4fnOF+TTWRxwvlLOef8iP5YL5Ql
4b3lmEzKDvd/9R4K7AKZI9/IIvnFfUKO2BfkNZkn38oSmeb+g36Dc/Z3O1u+
sAfD76n3h+/ilD4q7zr/LVvD+7NoZ7ob1K+G77XXZYoE8/ZR90/0Ujrtf7KX
86zY6UzpVfzQh6hj324jlyW7lA29meN8srvC/4uPdjU/9WHquRz+fkw7v8mu
PsI9ysJ7cQgFIE2w
               "]], PolygonBox[CompressedData["
1:eJwV0stWjXEcx+F310aGDTsqFYoatVZDAx0lHVgLoXMY6EjR3rmDkJGhcZSK
It2BjpIiA10ANZWkPHvwrP/v8x3tvdab2dJV1xkXBEGIEU6LnnAQ9FLAnD7q
fR4fBEU81vveIc7wQyfx0X2F3+4R7nKOZObsV9lxv6SDYn7aBkhiXj8hhXl9
jT/uV8R+YAmpLNjr2XWP0kUpaSzar/PXPUY3ZaSzZL/Bnvt17D9SzjGW7Tf5
5x6nlwoy+GRvYN89wT3Ok8mKvZED9yT3qeQ4n+1NBLzRfVwgi1VbMyHe6n6q
yOaLrYU4pvQDLpLDmq2VeKb1Q6o5wbqtjTDv9AA1nOSrrZ1DvNcRavmlIySz
oJ9yim/6FoeZ0VHqyGXDdpsjfNCDXGJLR0lhUQ+Tx3d9hwRm9SMus60HSWVJ
P+Mg9n2Rz6ZO9N29cJ8lyz3pLfT+B+RsVMU=
               "]]}]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{
              PolygonBox[{{506, 1135, 1132, 638, 699, 777, 873, 987, 558, 599,
                660, 738, 834, 948, 509, 557, 598, 659, 737, 833, 947, 508, 
               507, 556, 597, 658, 736, 832, 946}}], 
              PolygonBox[CompressedData["
1:eJwV0ctKVHEABvCTE3irvIwGEkTeoBQhg6zGmhfQ0nwCtYurNK0eILU03dQi
F8KMTQ2EENILdBstH8DLRt1o5cJraW4y6HcWP77v+//hcOZMeWdPW3dWEARH
SHPvaBB0U+wwThdpftMWCYIZivRr3OUNv7jpfJpCfYRZSu1HrHPVXqRKH+SA
O/Zrdmm1MxToK9Tqo/zjmf2NEv0hP2m0F6jUB/jDbbteviDiN6TC5+sl+o7e
on/hhP5eVjiPy2T43vqy80n9lF4jz8oRechw+Gz7nX5aNsgaOSZz5Ff3dTJt
n5RRWS0fyB/E3F+wp/QzMiZr5bg8Jufdv9XL9ArZzz63nJ+Xz8ly98pO6VF9
W7+hf+Z4+J/IRPgN3S3Z58Jvx1+G7IvyJdnuZ+xivY/vXLHnKNcfs0enPcEW
1+1P4bvqT5mmyO5ljct2B0k2aXb2kXz9CRkK7fuscsluJ8EGTc4+kKfnkkM2
/wHuY04y
               
               "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl1WWYVVUYBeAZWhrplKGku1O6O6UZWkpCUjEAWxRQLCwEVJRQDLq7u0FM
FAUsVOz3e/zxzlrfPnfmOWfvcyEpeUyn0YkJCQk3/Yi8148sfMlq8yE5hB+Z
bF4j23OF383n5Xja6Etknfhd/aQcxSJ9p+xNaqqYn5UlOaLPYZPelX/0wazU
m3JNX04K7jNnZY0+hbZU5TlrpTiqz2UIKZluLRtr9am0oxqpSM39rt3KOn0a
7anOfGulOabPYyhpeMBadtbHHtGBGjxvrQzH47kYRloetJaDDXHvdOQtc12+
0hdTkxfMZTkRz8JmvRv/6sN5X2/GdX0Fe/X+3EI680MyJxv1w3Io0/W1sgM3
9QtyAp30t2U9vuFr8ykZL8ANlph3yT5cJQ2XmBRnTS3XX5Tl4nc5aT4m7+Jn
5pu3yO58Hy8TnzIxPmP8QDbnB/2sHMtKfZ8cQPp4LvMMmYtNcU6s0zvyh96Z
d/T6XI49pTYvmctzKs6EEawyt4h3N/aR9Mw052ZznCldqMPL1ipwOs6EkWRg
lrU8bIkzpSt1yUgmMpOFh30mL1vjTOhGPRZYq8iZ2DtGkZVHrOVjWzwv3Vlq
bhBnE+dEfV4xV+JsPCOj+dDckp9iT8nGo+b8bI9nZH2cN3/qPXhXv4NvY/9o
wKvmypyL52er3oNExpg/kq3ibPVzchyr9P0yOc6RDHzB1Pg+ufaYLBDvODvM
R+SwuFdmmTfIznzHX+aL8h5+407ze7Jh3CdXzKfjXviVpebdsi/XSMtnTI5n
c+01WYXz+nE5ggX6tvjbpOBu88eyNb/EXnJAH0hGspsflwXZGedKT5aZG8V9
x17SkNfNVbkQ58RYcvCEtULsinOmF414w1o1LsbeM46cPGntNnbHOdKbxuTi
KeuF2RN7Sx+akJs85CUf+Zntc0nsjWegL00pwNPWi7Av7o9+NGOhterxPY39
YzwFecZaUfbH/dGf5rxprQaX4vmZQCHmWCvGgbhnBrDc3Dj+LYhzpQWLzDXj
3GI/2K73JGW8B+ZPZBtuxPvHQX0QmWKPzHNlcQ7qR+VwZusbZRf+1pNZoTfh
qn4mzp1l+h7Zj+uk43OmJP7//19L1xfLWlyOa+YTcmS8Kyw075C9SMVE82rZ
Nt7PeK8ozDxzCQ7FvjOQViRRhKIUozgluJ2SlKI0ZShLOcpTgYpUis/6u4fj
fBhEa2rHdzDOhkm0i+9T7CWD9cxMo7L5P+WX/L0=
              "]]},
            Annotation[#, "Charting`Private`Tag$1999586#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV1FWYVWUUBuDNANJdA6KIAYikhHSqoKgopYSCoCI1hIDeCEhJPaB0dynl
Y9GdXillENKpSKcY77p4Wd+3/pkz+5y9D8U79myWli5Jkin+ucfX6ZOkHsdT
kmQ8LSnD387u842z+pywm0AryvKPs2/tG3BSn8jrlOOwXReysF4fQPcMSfKv
3/nOriGn7CbxBuU5YteVrGzQB/Kfn/9ef5bT+mRaU4Gjdt3IxkZ9EAmr9ec4
I0+hDZf1j3mIH/WK/C53Jzub9Ayub7z8NJ/od8zhlOBXPR1r5Oc5K0+Nv+d3
xurlaKtfMQfwMKnOFps/2WeVp8rVKCaviL9jf8zsQQ4K2C8wN9tnlCfIT5qV
4rrNZWYFc7Dzu/KnlNRLmkXMpWZ58zfnOc2ZehmzllncXGVWMlOcr5Ub8bh+
Ts9rztWnxfuUx8VrUVT+0mxnf9UcGNfPXj2bs2ly9Xhd/biZRk626A84nyhX
Zoh+zxxBKQ7p6VknN+a8PJ03uaYP4hH26ZU5IfckF1v1oXG/WK+/wAV5Bm9R
JT4/Nti/yEV5Ju2pGtdFD9eWycxMlrg/bPSzTfhDnkUHnuGkXS9ys00fFu+d
TfpL/CnP5m2qccquN3nYrg8nO5v1l7kkz6Ej1+NZi/vDfr06p+U+5GWHnsm1
TpKrxD2P76U5Mp4NDuu5nM+Sa8dzpG8xX+EvOZ+zefJcOUX+LJ4hOuk3zME8
SmFnS8wDca3ydPkps0bcB3NlPK/RnZ+RP+AJPZ9Z0FxoljV3xmdqTtZLm1Xj
u2AuNyuaI5zfl0fFc6CXNh80vzCPOMstz5brxHXJX8XzZL/VbMplOb/9fHle
PEPy5/HavKPfjGeNxzio1+Ss3Jf87NJHxv9d8uh4jxyNz5Bt8qtckefzLrf0
ofE94We9FufkfvF9Zbc+Kq6b7fprXJUX8B61ycMO+2ZckxfSmTrxvSMtPsd4
XxRgp59rznV5Ee9Tl4Lssm/BDXkxXajHebv+cS/Yo4+mELv1ltyUl9CV+lyw
+5BC/KCPIZU9eituyUvpxm19WNxvftFzuN4Zck0a6BfNjyhhnxqvaS4y/wch
gsJL
              "]], LineBox[CompressedData["
1:eJwV0kk3kGEcxuHH0GDZ0pQkc6yc07JFA6EI56hQCLUoms3fANWqpaVTMqvk
GxgbTNWiPkCyTcYui+s8/9/9bt/k+pay5ogQwgC50SHMRoYQ430VFcIZevWe
t4fT/NSxzLgr+et+zT3OEces/Rqb7jfc5zy/be3EMqf7iGdOX+efe5BmLpDA
vP0GW+63tHCRRBbsVWy7h3hAPsdZtFez4x7mIQUk8clew657hEdc4gSf7TfZ
c4/ymEKS+WK/xb57jCcUcZKv9loC4/opxaSwZKsjggn9jMucYtlWTySTupUr
pLJiu00U73QbJaSxamsgmve6nVLSWbM1cogPuoOrrOsO4pjXz8ngm27iMFO6
kzIy+W67wxE+6i7K+aM7iWdBvyCLH/ouR5nW3VSwobtIYFG/ZP/g/yKHX/qY
/67ffZYU95g3z5vt238oIVPW
              "]]},
            Annotation[#, "Charting`Private`Tag$1999586#2"]& ], 
           TagBox[
            {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{1080, 1130, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 
              1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 
              1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 
              1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1117, 
              1118, 1119, 1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 
              1128, 1131, 1129}]},
            Annotation[#, "Charting`Private`Tag$1999586#3"]& ], 
           {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
            LineBox[{1078, 1079, 1077}]}}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Background->GrayLevel[0.97],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{7.989795918367345, 1.4999999999999432`}, {7.5, 
        6.500000000000014}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 7.999999836734694}, {-4, 4}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {182, -339.73835392494317}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}], InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxE2nc8Vu//OHAZt/tG9t5SQkilaLleVhGKrIZklkRJWlaoRKElIUSRokKU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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{
              PolygonBox[{{1105, 1356, 1354, 605, 606, 1143, 995, 870, 770, 
               693, 650, 607, 1144, 996, 871, 771, 694, 651, 1179, 1031, 906, 
               806, 729, 608, 1145, 997, 872, 772, 695, 652, 1180, 1032, 907, 
               807, 730, 609, 1146, 998, 873, 773, 696, 653, 1181, 1033, 908, 
               808, 731, 610, 1147, 999, 874, 774, 697, 1208, 1060, 935, 835, 
               1240, 1092, 967, 654, 1182, 1034, 1274, 909, 1253}}], 
              PolygonBox[CompressedData["
1:eJwV0rlSk2EYhuEPwREkBBLwACxRMCq2HgIpPATAlYQAKjYqCqhUJkAg0XHG
BRRtLVlkPwB7WQTcAHcPgMvimnmf+/vL/2hL5lzHgRBCCU9oPhhCknLqS0N4
XxbCWebdH3y45E7w1k7Sqt20v7rbOcSUlqWNW96+aSnKmdZyPNUreagdY1U7
z21tx05TwYw2xDM9QlY7zpp2gV5t1+7gMLPaMM/1KnJaA+vaRe5oe3aGSt5p
I7zQowxpjWxol7irfbc7iTCn5RnXqxnWTvBRu0yf9sPuoop5bZQJvYYRLcGm
doV+7afdTZQFbYyXeoy8dpItrZ0B7Zd9lWoWtQKv9Dij2im2tRT3tN/2NWpY
0opM6rWMaaf5pKW5r/2xrxNjWXvEa72OgtbEZ+3/j/NA+2v3EGdFe8wb/QhF
7QxftAyD2j/7BrXsA4u8Ua0=
               "]], PolygonBox[CompressedData["
1:eJwV0UlLlVEABuDjtJDAH5CmuCyXtUlLyE33OlNkOSyiRWZprUtzyB+gVnsz
0kZFC3STulGSSCvHoo3QIgiCckghs56zeDjv+57vwr3fzb9048z11BBCCgMk
M0JI8M6Y4HJ6CItpIZzjl/6Im/TY/9jaOci8LUmjfUmvYUMf5Ba99j1bB9ks
2Eq5Yl/Wz7OpDzFqy6HfVkSrrU//K3eSw3vbpO0wL/QEZbYmfUW+wJb+Rj/K
uP5YH5MP8UA/wYp8ihm5zf1deV/u4qtcFZ+Pv895nODdvNZ/yg0c0D/43JR8
JH5Hht1/d9aQ6T6pf5FPk6a/jd9NvkiWXu7zV+VV+46z1rnuLCfD/bb7OfkY
E+5+xGd4Yn/pzGXA/s15lpPyqrOEWfm25+7J/+Q75Mb3rxcyKX90Py0XMKKX
UmG7pq/JdfzWn/LKlsdDW3H8/23343uhW89j0VZJs+2TXh9/l/6MDqpocffZ
3sCu/pxOqvkPHh1afg==
               "]]}]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{
              PolygonBox[{{580, 1355, 1352, 793, 893, 1018, 1166, 632, 675, 
               752, 852, 977, 1125, 583, 631, 674, 751, 851, 976, 1124, 582, 
               581, 630, 673, 750, 850, 975, 1123}}], 
              PolygonBox[CompressedData["
1:eJwV0TlPVGEAheFPtsJGCmXRygKlBBJFKICCJdHo6CQkJBREfoAiQsL2B9hK
CpgRKHUQKMBCpGEbcMECaKDAxIIIaigMoAkJPrd4c95zvntz75252fo8/iwj
hHAJI3iYHUIMncZc2ZoVwim+ZobwQH7DE/4OZTyN365d0Wv4Dir5OG7wWUw6
b5F/8NFeL/fQwBvlIab4uSzGIj6757LnN/NjfHB+Ie/hCwr0HOeP+Hf06X/l
PzksO9x/xflTfoJNe5Z+n+/jsd4kf2Gel8q1qLtvWa/m26jgcXmAV/y6nMGE
6zb0Or6Lep7C7ehd8cn5gl4efQvyeW/0jhjSXzqP8TmU6Kv4aVvSq/hW9K08
iUI+jXHndfob3NIXot/Tlqf34AyDtnbbEcr1BApsb6P3t9Xqr1Gkv8eG7Zre
jVMM2F7YDnFXH0N+9P8gaVvHVVsXTtBvb7P9wB19FHm2FBK2NP4DrxJUlw==

               "]], PolygonBox[CompressedData["
1:eJwV0DlPVFEABeA7LNLAf2BAO7DDBhNEG1lMlFUHAUVpQdYeBIQfgCItamKi
jCwKNIAWJooJJC4QZDUWJCYm0iGLfq/4cs85d14y78WbWitaUkIIMZ5Tkh5C
KTeNQ0wTSw2hmR90p4VQZxtkKnrQdpddutwlbGuc0Yc4ZRvlge2i/oxcfYZJ
2z/u2HbotN3Qr8gTnNXfsWo7rQ+Srj9mwFasPyVHf8OEbU4/J3/kRG/St+nQ
r+uf5BJ5k3K51vmLV/KJM5+3fPPbTN+hXv7DgvuYfl5eIVfP0K/KP6P30w+c
aYzQ7/ks9w3yPu/dp+iXovfhgl7l3OOJfOiM8zr6L55NOH8z667A+YHj6Ns4
d7lt36JdrrUvyZflDcrkJHnyIl/dz+uF8jI58gCp8iP63BfpY2Tr0yRtR9yy
bdJmq9G/ENf7o/exPeS+bZxDGu0b3LNX65/J1vui72cbptf2kr802L/Taq/S
e3jBAfX2dVrcVeoVXOM/PhpcAA==
               
               "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl1mfczmUYBuBX2cqelfFaGWVFk5S9KxSJ7FBJ2mSWPbL3qsieadp77xFK
RaGMIitbx/Xrw+E8r/t+PTz3f5DYokPdN5IkJCRUvCMhIXKmX4pQ0LzJnFoO
Mj8ie5jP6W9R3Jxe5pAT5DP2DsmXuKpntD5SX6Tfkj3IxUPmdbIKx/SJ/Kt3
IhuvmY/LNiRjudlHJczSi7JZ78mzlGa9taoc1yfxOncy29oDbNE/4jnKkJRk
zLH3IFv1j6nLw2ywVo0T+mTak5y51oqxTe9FPR5ho7Xq/KFP4Q1SMC/OiO16
b+rzo7kx1/QveZRN5hr8qX/KFb0z2elgPiHbkpwV8d0cRm89HynN82UJduhp
7A3W++j/yLfJwD3WJ8rnrf8km8RZWrtuziRHmRfrt2XPuEbWcsvc8jP5lHzM
/ma9JoXNJ83p5DDzY/Fz5qv6h5Q055A55RT5pHzT/h96uzh3cwqZVY6VK+O6
6H30/OTVp8lU1hfE57FT78t5/R0y8oL5sHyZG/pXPM4Wcy1O6Z/TkT/Nr8aZ
sSruaxbqpdil96MBP5ubclP/mifYaq7NaX0qb8VZsyjOit16fxpSlrvi+lov
zR59AC9SjrtJG2fHYvtl2KsPpBFPss1aHc7o03ib9PH9rD3MPn0QL/GLuRm3
9G8oz/Z4HvlL/4J3OBnPVpwpq80Z4vvFc81+fTCN+dXcnNv6tzzFDvOz/K1P
55reJe4r3jWfkq+TOp5h126cXBPPmd5XLxD3q/5FXLf4e8pHud/aD3Fe8pNY
izRfiM+N+9qcSd4rJ8lyson9I3qLeL7jxSAzy9HyCfldwv8vjI/i/GUemUd+
Lp+2tVM+x9k4U+vD9Rn6ddk1/izeM5+W7UnD2ngH+Nl+ekEyxdnEfc8BfQgX
4/fF3yXuR/NR2ZIkfG+uwC69Luf0mbxPZr6z9jgH9aE0pSK7rdXjH30WH5CF
7+O7ckgfRjMqkZUl1svyoz6c5lQmG9nJwT3cy9I4U37SR9CCKtzHsnhuOayP
pCVV2WOtPuf12XQiJ8utlednfRStqMbeeO9wQZ9DZ3KxIt4r/KKPpjW/mVtx
B0vM1dkXzzkX9bnc0LtxX7xrzGdk/AN2F+vMKVyn/nFvkdu8Mq47v8azZ2+I
Pka/JN8nC6+Yf5etuTPW/NwYuTRuL/3jeE5lokyUU+MzZQ37+/UGFDFfiudK
jojrKeeZb+rd4z1jzilzyU/jrGQX+3/pHShmvltml+PjGsr19lPKAfHcy0Iy
v5wuK8S9bX9VdAqZj8S7RQ41j9Uvyw/IGudlfbJsY/1YfGeSsiweF3u99LzU
NP8gG3JZn09X/ja/SVo2mBNZrVfkqD6OttTigLUX+VdfQDfyssZaJX7Tx9OO
2uQjPwUoyP0UojBFKMoDPEgxilOCkqz1eZX5XZ/Aq9ThoLVGXNEX0p2z5o6k
Y6M5le89UC9MAX1Gkv//H1TK3n+kWgt2
              "]]},
            Annotation[#, "Charting`Private`Tag$1999638#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV1GdwFQUUhuFNw4r/VQRCsesfy4yCSlMSioEkBAlJCKGjgqKgAkrvxd4r
hGKhRSAJMwLKoCiihBa6goA4MoqNFprP+fHe833v2Ttzd+/uZpYNzR2SkiRJ
uY92qUnSJz1JNqclSS7+1OdgBB7EQ+hrX2OXh+P6XDyD9uhnt4XPx196OZ7F
bL6Oex5XIysjSTbxWehvt5Xrhr/1eXgOL/JnuRdwDX7gsjGA36YX4B99Pkbi
Jf4cNwbX4keuAwby2/Xu+FdfgGVcA3zItcAo7mX9vDwWDbCZW83dhEXxm9GR
G6TvkB/Bf/oG/Q5U6gv1Cvk6fKS3xA65NdbLo+1fkS/I43BIzonj4/zMe5C4
Nl/E9ZOLcIVe43tr5JvjN2Kx/e9mAS6zz9b3yu2Rpm+M3yaX4iq9k+8Plmv5
U2YP84DZCRn2J+y/le9Eld0fcQw+5j83G2IOf9TMw31yrdkGX8f/6rhX5Yvy
eDSM66/fi9XyFvu18i1YondAZ+5RfadciJP6J1jONcJc7v74/7nX4rpggt4I
W7mH8Ri3S+8Z56V/ijHIweN2u/kinNY/w1h0ifvIOXc1c5GHIY7d47hinNEX
YRzyMdRuL1+COn0xxuN1PgUT+cbYxnXDE9w+vRfO6kswAW/wqZjEZ2I7V4An
uf16Kc7pS7GCa4xy7gFM5N6M/xaT9SZxf8otsCbuMfsv5VuxNO5T7JOz8H3c
+/bD5J/k3jgod457if/OvAvV8bybhVjGrzQz4xnEPLvfzHy0kneabeN8XMdv
4jmUS1Bfn+S7b8npOIMp9ofNLrjEvqleI7eM66evjedeLsaVeq3vfyXfFs9J
/Bb7Y2b3uF/l/WY2NsUz6Nin5J/lMlzQN+p3Y5VeoVfKTTBfb43J3Ntx32Oq
3izOh1un346KuDfRg3taPyD3wcV4FlDFNcUCrg2mcO/o9TBNb45dXCGGcwf1
vkiwnJuKnvFOtfuF64cUrOCmoSjeW65DsVkS71bHHbLvj1Ss5KajV7xb7Q5z
A5CGSm4G3o1rjenc9djNlcZ7lTuiD0Q6qriZeI+/FDO4G7CH6x3vVe5XfRAy
UM3Nwvvx3sFM7sZ493BlGMUd1QejHlZx1VwzLNTbxrWR22GDPNv+A/ly1GEW
d8Tsiv8BeCPh1Q==
              "]], LineBox[CompressedData["
1:eJwV01VMlWEYwPHPDlQEUYwrL2zFzs24MDadubm5eeHEDkDs7m4JFQzsjs24
EGwUMTfjRme3KHZubvr7Ln68z/N/z7ezcc6pGZ/UL7FIEARx/pQuEQT1igXB
7eJB0J7z5odFgyDX3Jhj9l4M0Wba35rHUIpsbQ1DmeXunTaW0uRoa8nSI1it
1eeRNozZWoE9gTKc1taxTS/HGq0Bj7XhzNHe2xMpyxkthe16edZqDXmijWCu
9sGeRARntVR26BVYpzXiqTaSeVqhfRzlOKelsVOPJEWL45k2ivnaR3sy5Tmv
pbNLr0iq1pjn2mgWaJ/s46nABW09u/Uo0rQmvNDGsFD7bJ9AJBe1DezRo0nX
mvJSG8si7Yt9IhXJ1TayV6/Eeq0Zr7QEFmtf7ZOI4pKWwT49hg1ac15riSzR
vtknE81lLZP9emU2ai14oyWxVPtun0Ilevqe5embOOCuChl6S95q41im/bBP
JYYr2mYO6rFkaq14pyWzXPtpn0Zl8rVTWi322TuzRTtkr8ome2sKtPGs0H7Z
p1OFq1q2Vpv99i5s1Q7bq7HZ3oY75g5cML93f8nchOP23uFnpq20/zbPIJbr
9tZkm6+5zzHX4YC9K/fNXcg3Z7k/Yq7OlvAzcPajrfmusyMXzR+87rK5KSfC
3TmAPuHvxtmd4v7vN+0/zIPD77J9oudWmf/ov50zw++psxcl3Ve13zC34R85
9k/OgZR1f93zp811+cvB8DNx9qeb+YGzK1fN35yD2OaZo84abNXbcc/ciVxz
ofs8czNO2vuGv2VzD26Zfzrjw9+W95/ktf8BGmOikQ==
              "]]},
            Annotation[#, "Charting`Private`Tag$1999638#2"]& ], 
           TagBox[
            {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{1300, 1350, 1301, 1302, 1303, 1304, 1305, 1306, 1307, 
              1308, 1309, 1310, 1311, 1312, 1313, 1314, 1315, 1316, 1317, 
              1318, 1319, 1320, 1321, 1322, 1323, 1324, 1325, 1326, 1327, 
              1328, 1329, 1330, 1331, 1332, 1333, 1334, 1335, 1336, 1337, 
              1338, 1339, 1340, 1341, 1342, 1343, 1344, 1345, 1346, 1347, 
              1348, 1351, 1349}]},
            Annotation[#, "Charting`Private`Tag$1999638#3"]& ], 
           {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
            LineBox[{1298, 1299, 1297}]}}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Background->GrayLevel[0.97],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{7.989795918367345, 1.4999999999999432`}, {7.5, 
        6.500000000000014}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 7.999999836734694}, {-4, 4}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {546, -339.73835392494317}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}], InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxd3Hk0Vd/7B3Djvdcc9xIyVEolSTI02k9RKUPSSCWZmkuIBmVMyhCREEVk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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{
              PolygonBox[{{982, 1174, 1172, 624, 625, 1013, 910, 823, 754, 
               702, 667, 626, 1014, 911, 824, 755, 703, 668, 1042, 939, 852, 
               783, 731, 627, 1015, 912, 825, 756, 704, 669, 1043, 940, 853, 
               784, 732, 628, 1016, 913, 826, 757, 705, 1054, 951, 864, 795, 
               1077, 974, 887, 670, 1044, 941, 1099, 854, 1085}}], 
              PolygonBox[CompressedData["
1:eJwVz0tLlGEAhuGvnGY8LLOpQLNZaR6CWggRREiIpgYVRDnlYVwZNLOohatK
q5VWHn5AObn2MBlUq4JqUYvREkQiAtMZR/sRXt/i5n6e533n8CZSmWvpg0EQ
HEAWM5EgmEavcbssCB6iHpv6PMYRdf7K1oEy5G1JFORHaMA/fQETiLn/2taJ
CFZst1GUH+MUtvRFxN1d0G/iMJ7bym2z8mUcQpP+he9h1Xmd/l4eRA3u2HZ4
FI3Y1uvd+SQPY0k/qi/Kt3BBXudqnJG/831ckv/wC/cr5Gz4Bu7i87zG1znK
zfyVr3Ca2/h3+A7+6fMn+YPezSm+yBt8g2u5lfN8lUe4nf9yn8+WeCx8N86F
38cFe4P8Wb6LnH5MX5J7cQRn9R/8AC+dV+pvwv+AGFr0b5zBL+cJ/aM8hBPo
t+3yk/B9KOpvcdy9nJ5EHJO2Ktuc3INyrNkGsCc/DX8LO/oypjCI/7ZnOI2S
/g7TSGEf8XdPIA==
               "]]}]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{
              PolygonBox[{{598, 1173, 1170, 718, 770, 839, 926, 1029, 650, 
               685, 737, 806, 893, 996, 601, 649, 684, 736, 805, 892, 995, 
               600, 599, 648, 683, 735, 804, 891, 994}}], 
              PolygonBox[CompressedData["
1:eJwVz8cuhFEYBuB/yg2QuACEtaVEr7GWiMTShhWJxGD0vldHi14XLoFEH2Xh
AkjcBKbhsXjynff9zkn+v7Czt7UnHARBiBht0SBYJcG8RYf5EQmCFjNuvlLu
XGx2c0mp/O5uvnM75xToznQvhORmtojq53SzzDDNFJNMcMrz/we528QmEW/G
dSc88UujfoOw3Zh8zCM/NOjXCdmNykckyVGvXyOwG5EPeSBLnT7BL8PyAfdk
qNWt8kNc3ueONDW6FXIMyXvckqJat0yWQXmXG76p0i2RYUDe4ZovKnWLpInJ
21zxSYVugRT9cpHZxQUl/utN1+ecpEzOM/8AZg1EcQ==
               "]], 
              PolygonBox[CompressedData["
1:eJwV0ktLVGEAxvHjZZPNaK200TCtjS00G0sIQSIiCLxkQQRlkKNWo04tFPwC
3ayVZepaLd1qdlE3tahFQSCj0yDR2vKWfgB/Z/Hn/zzPe94zDDMVd1JtfblB
EORgAsP5QfASKWN4MI4l7OBsXhC8wB569TEsYhtnbM+xix49i0L5KmZw2DtH
bTH5NuZx1LZg20KdPoT/SOoV3IUlnPDcL9tD+Rtq9Ci3YRqH9NfOB+QfqNOP
cDveoUz/5LxH/oKT+qa+LJ+T4/wMO7hv/8OX7IPhZ/BPrudjfJ2zfJ47uYkX
+Thn3L3Ba/oFfsAt/JWrOcLXOM0NfIUv81su4hH3f8sX5X5u5e8c5xLOoFG+
xXMolT+6k5Q/o0rf0E/LT7GNe3o5J7CASs+s2g6G78cbFNpe2Yrlm5hFzPbB
9g+1+hNs4a6+goLwu2EK0fA/Y3uPvzhle4xNdOtpHJCbMYmI54dt81hHje0R
NsLfXO9EAh3YB77oUvU=
               
               "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl1nfYj2UYBuDPyogQssqMrITsQlYIlZlVykoSymhZZRaSvclsWBlJ9soq
iorK3juzZXbeR3+cXdf9PIfD7x3Pq9ytOtfvlCghIaFR4oSEyCX+U5Sy5u3m
zHKkuZZ833xD70Fl872yoJwln7V3Qr7ITT2X9Un6Uj2VPkDPzaPmH2VtTunT
SGy/lzkrr5kvy46kYF3ss1R/hO/0ftSjJLus1eG0/gmdSMJX1orxvd6f+pQi
KclYZq84O/QBNKA0u63V5Yw+nc7cxdfWSrBTH0hDyvCTtac5q8+gC8lZHtfK
D/qguL+cNL/Erfh9lOVn8zOc02fGb3exvc3ZeN18Je4JKcln7xO53no6fYj+
UNwn8zeyJD/qWeyN0gfrN+WbVLGWQRaSs+M3y8b2T+mtqGC+bc4tJ8c9lcvM
d8uB5uoyT9wzOU/Wk+Xs/xLPnvLm8+b75TjzrLjXeh89e7xT+ufyDetXZbx0
qchvfbrcYD29PlQvENdrXiFLsUv/gFv6W2TkOfNp2Zo78Xwoz574bVzQZ9M1
3j9WWivNbv1DmvAYe63V5w99Dt3imlllrQw/6UNoyuOkJg33sDrOCT/rQ2lG
BdKyxno5ftGH0ZyK/GqtARf1T+kez5K1cQ/Zo39EC86Y28ShZLmoxG96Qy7p
n9GDa+bO3M3GuI+s0x9jrz6c2/rbZOJ581nZlkR8E9fl3g/S8/KE+XfZiMv6
A/bG65/H2dH76vfHedS/iPfL+p+yS/xZa6njvZQz5CZ79+rD9JqyYDxT+WVc
R3xD7K/XH4/7Zf7VnFWONj8lPzbf0d+hqvk+WVjOiXMjX7B/Tm9HRXNimUdO
kSviWemD9Qfj/OrzZWXr+2RjruhfxBm39575gXjHzH/F+SMN35ozsCHOCb/p
I2jJefPLJGGluQr74/3kqj6Xt8nIxviN/K6P5EWqcsBaE67p83iHTGyyVol9
+iheohr38W3ca/bro2lFdTLH+Y97SDayszmumQP6GFrzZJxVtsS3gYP6WNpQ
g4PWmvKnPp934z1gazwHDunjaEtNDllrxl/6AnqSg23WqnFYH087Lpjbk5RV
5loc1pvzt76Q5PHvjTkHvcx/x7eDe9gcz8P+R3ohcpq3y+ocieu2N0afoMc/
Hu/qmSmifxrPy/If8hWSxTtvfapcHeda/0B/UuaTj8oF8Y2QT9k/oreIs2X+
J65RTjDXjnfanEL2i99Eb/M/sitpKWBvptwS74M+PN5lSuuLZC7r38XfzdF4
dtbH6hPjE6D3jHsps8iH5WfyWdne/kW9Q7wv5rvifZfTZF25Jr5J8kNzDZlf
lpQLZQNZ2/7R+C7EOTT/a84pJ5oX6Sn1/vH7KKbPlX2s/yu7kY6t8c7GeY37
TG7z9/H3cUyfxCtcMr9Kctaa63BMf4Hr+mL6kocd8c3guD6ZDtQlLzut1+KE
PoVXeZoHyUd+HqIABSlEYYrwMEV5hGIU54f43nBSn0pHnuG4tZbc0JfwHtfN
3UnPtjiPrntEPBPK6IsT/f//UyXs/QczixEN
              "]]},
            Annotation[#, "Charting`Private`Tag$1999690#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV03e8V3Mcx/HT3kt7d4mmIrMyCgkllbpNjdsg6l5p4JFRIu1EaFCIhvbe
FBUPpaG909679Kfn54/XfX3e7/M953fPOd+TkpbRPD1TkiTj/EnNnCTHsiTJ
AFTEEXkWhqIVWuO4/j3cjaPybAxDG5zQvY978K88B8ORLWuSTNY1RGZs0X2u
a8sn5Q9QCcfkuRiB7I5P0T2HLNiqa4dT5g9RGcfleRiJHNZ/p3seWbFN1x6n
zQNRBSfk+Shm7Ty5NQpjlC6n7nvzC8iGavJ67oXtjpeXl5s7owxe0Z3hQaiK
k3Ila9aae2CBXFyeb26DJ8x7uAjuN//FffCM+RCPtj6X+Ye4B27EdXknv8zZ
uTpv4Caczk/xgbgP/sf5FXiF3JjTuB7v41Quyw/zVm7G7/CzfIQ7OPcsfxT3
jdpxPT6lr2xeZ34dC+US8gJzWxRFLXkT98UYx3PLU+N/QA7cK2/kDOxwPEVe
ae6CcuioO8eD4/5wWl6EktYtlNuhGD7T5dH9aH4RObFT1wnnzR/Hb+GMvBhj
0RkXdJ+gBs7KS2LvIQ1fuF4X7opu6I6L1g1BTZyTl8Y65LX2p3j2yIVduldx
yfwp7sN5eRnGIZ/103QvITd2617DZfPQ2AO4IC9HKWsXye1RHF/q8uumm5si
D/bo7tStMndF+dhnuis8LN4DLspVrPnN/AZWyKXlxbFf8aR5L5fAA+bNcX3u
xw34MH/lnALmGfEtcDN+jHdxC84bz5L/iHvjN/lpPhj7PK7v/Lt4dbwn7sb1
eT+34gr8CG/j5vwuN+Sjscece5WHx/+HOvodfElf1fy7uSdWymXkJbF3URIP
yn9zf3zteEF5ZvwG8sX7lP/k3tjneEV5jbk7UuJ56a7xiLgWLsurUNa6pbFP
UQrjdYV0P8d3ifzYr+uJ6+aReAhX5NWYgF64oRsV3yCuymswEenIiD0Tz5J7
46Y1o+M54Zr8CybhLdyK7wyP4rr8K77BHc6fFe8IBXBA1wf/xbcT3zRuyGvx
LQpbP1vXEgVxUNcXt81j49njprwO5axdJndC6bg/eQu/jcmOF5HnmBtxKj/O
u/l/BADJeA==
              "]], LineBox[CompressedData["
1:eJwNzzdKRGEUBeB/ZtyAggtQ0dpSMEesBREsbbRSEOOYc2+OmGPhEhTMsXAB
Cm7CNMmv+Lj3nPu/4uW1dTV1RkIIPTRnhZAdC6HYfDS7eY+GUChf2NvJp1f3
a85Typd8xTZ9/OkWKONbvmaHfhK6Rcr5kW/YZYCkbokKfuVb9hgkpVumkj/5
jn3ipHUrVJGQ7zlgiIxulWqS8gOHDBP815q+hpT8yBEjRNzW9bWk5SeOGSXq
tqGvIyM/c8IYMbdNfT2BF90p40wwyRTTzDBLlm+2vG0gwqvujFz9udxCDh+6
It2lvYMCSuQ3M06j/dNsNee8/Qd7KUM2
              "]]},
            Annotation[#, "Charting`Private`Tag$1999690#2"]& ], 
           TagBox[
            {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{1118, 1168, 1119, 1120, 1121, 1122, 1123, 1124, 1125, 
              1126, 1127, 1128, 1129, 1130, 1131, 1132, 1133, 1134, 1135, 
              1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 
              1146, 1147, 1148, 1149, 1150, 1151, 1152, 1153, 1154, 1155, 
              1156, 1157, 1158, 1159, 1160, 1161, 1162, 1163, 1164, 1165, 
              1166, 1169, 1167}]},
            Annotation[#, "Charting`Private`Tag$1999690#3"]& ], 
           {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
            LineBox[{1116, 1117, 1115}]}}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Background->GrayLevel[0.97],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{7.989795918367345, 1.4999999999999432`}, {7.5, 
        6.500000000000014}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 7.999999836734694}, {-4, 4}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {910, -339.73835392494317}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}]}}, {}},
  ImageSize->{600, 300},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.72042069485854*^9, 3.7204207023356447`*^9}, 
   3.720425789138547*^9, 3.7204258428769093`*^9, 3.720425917770496*^9, {
   3.720426601675127*^9, 3.7204266235911694`*^9}, 3.7204274387180767`*^9, 
   3.720432161028912*^9, 3.720432234193396*^9, 3.7204331563485928`*^9, 
   3.720433321410993*^9, 3.793845694403015*^9, 3.793908892808818*^9, 
   3.823229814589802*^9},
 CellLabel->
  "Out[3517]=",ExpressionUUID->"8b5475ee-7787-41a0-97c3-55cbb0ffa2b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Theta]1", "[", "t", "]"}], ",", 
         RowBox[{"\[Theta]1a", "[", "t", "]"}], ",", 
         RowBox[{"\[Theta]1b", "[", "t", "]"}], ",", 
         RowBox[{"unom", "[", "t", "]"}], ",", 
         RowBox[{"u1a", "[", "t", "]"}], ",", 
         RowBox[{"u1b", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Theta]2", "[", "t", "]"}], ",", 
         RowBox[{"\[Theta]2a", "[", "t", "]"}], ",", 
         RowBox[{"\[Theta]2b", "[", "t", "]"}], ",", 
         RowBox[{"urob", "[", "t", "]"}], ",", 
         RowBox[{"u2a", "[", "t", "]"}], ",", 
         RowBox[{"u2b", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7204261225062*^9, 3.7204263030519867`*^9}, {
  3.720426395111978*^9, 3.720426460403962*^9}, {3.720433148025023*^9, 
  3.720433150928851*^9}},
 CellLabel->
  "In[3518]:=",ExpressionUUID->"5390756f-c76d-4327-ab92-5e4ec8706228"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwd1Hk0VWsUAPBbpHMp3Huua8iQ8ZUplTSyd/FSSWWoSESU6kVIaSRKhqSB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           "]]},
         Annotation[#, "Charting`Private`Tag$1999930#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwd1nk4Vd33AHBR3KMM9x4R4WaMkjTQyFpFmTNWpgwR1Rsy9E1KKCqR6iVK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           "]]},
         Annotation[#, "Charting`Private`Tag$1999930#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwd1Hc81t/7B3CjeItw3+9bIrqzSpKEKMV1lSShrGRnFBmVVdKSoknjY5aR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           "]]},
         Annotation[#, "Charting`Private`Tag$1999930#3"]& ], 
        TagBox[
         {RGBColor[0.922526, 0.385626, 0.209179], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV1Wk4FnsDBnBbJTsPytKu5UiWsoS4R5ZE2nBEcWRJEikSlUpKCW20KApJ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           "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCwAGIQ/fCpyJ45TCIODFBwdo3YiSJmBD8n7nG9JhuCzy2w
wfwBB4LvWey53JcPwT9qWdOmIYngp7z2sLsvjeAzzxX9NlUOwXdkWJ/KrILg
7z320OWeHoK/NdideYoLgt/hvaNVxh3Bj3HW5FjqieAzGXPzbvND8P2Ezovd
iEDwX1wI05LJRfCl/NICl0xF8Os9WudveYbgK971urG4VRTOtzJvmSJpJIaw
X+78T8bLCP7XU72PChrF4fwZLHElQSoScL7wva2LmI4g+Ky1jSGWhZJwPsPK
uPWPhKTg/KJZ63uFDiH4e7U7OATzpOF8Qa8inSY+GTj/ju6Fy5V7EPwN8+xV
nsTJwvmx680EZf8h+A2tCxvvrJKD89e+kJ3N5yMP53fMbU2454fgpwS9VV0X
iODL7NmzwTccwe/qjz7Wk4TgZ5jN/MhVieArtYh4sC9D8P9Z1PBeX4Hg33z7
+NKy1Qj+hPDNsW4bEfz/WkHFrXsQ/DsX++cxX0bwd7R9T758FcGfYh2vufgG
gu+9VG+L0z0Ef1fF2ZONLxH8abqm/YFvEPzCR3NCFN8j+Bo+OfcPfEHwWRiv
LJnwHcF/sNU6K+EXgr8na7G+wV8Ef7o899f//xF8AFdjtM8=
           "]]},
         Annotation[#, "Charting`Private`Tag$1999930#4"]& ], 
        TagBox[
         {RGBColor[0.528488, 0.470624, 0.701351], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV1nc8lf/7B3CpjMg6dqmU6psd0eS6MzNKUYmQMkqyIpUSMrKaRsjmI0RW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           "]], LineBox[CompressedData["
1:eJwVlXk8lN8Xx8dSREjGMPOMxlpDlBIt5N4i2bONNZpnQpK9lMqWpbQQQmhE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           "]]},
         Annotation[#, "Charting`Private`Tag$1999930#5"]& ], 
        TagBox[
         {RGBColor[0.772079, 0.431554, 0.102387], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV13k4FfsfB3AKSWU7lIOclOqGUFdE8Rk7oSxZQ5aUiJRdJC0uESVXhJA9
paxlHdsvKmvZtxPZsp1zZs5BSL+5f8wzz+uPeWb5vj/vmZF0vm7muoWNjW2S
2P7bn3Gd7a7/+UDdNFN7bNNpAji0RL2p5EtQMxtYuug3AX+nJ6WWkn1hi4Fz
RmfUBBi295ekke/DuKNSfGjxBFhdWqmNJyeAZAOHQjjbDxiV/0frETkbJKyE
ivan/YAM4XMRD8llIJDhupHfNQnh3KWHo8jN4FKdE5ZJmQFrm8y3dEYPaKs9
UnmbPw+04fM8L0V7oSNDpcLswzxEOHC7mmv1wn0PfvWFlnkodbkuWpHQC8LV
8jbsM/PA66X24JZyH5hzsk6WSi3A/+4O2nKF9kNnkP7CsRcLcPy1AJc49xC8
rfNrvBu1CDv+hNvpSVChpiNIOxuhQdJVKwdZXSrc+9tOzsOYBlI9so4CXlQw
TfcoPGxLA/WCfpfhWipIzi+ZhvvQoLIgsfy93Hf47bmfVpFDg0XzhRrDju+Q
SYmWEuKgg0X+sy8+uyZg6MEFnihnOqTa3zW6LDkBl1yCBzTd6DAh6NlufWIC
OvOTtVY86XA9VLNTzX4C3rBOzJ8LokOU2eLXbW8mQEaq91x9HB1qNzSHUox+
wF4aGplaTYeDpkuzTdGTcCu03Og0HwNEw/RUr2ROAs1HorpMiAH8bzKied5P
gkkdPe+QKAPWuM3lTCcm4fGp12vLUgzoqn/vM3ZyCvLCXa4bqDIgWCF8c3Vq
CjQTxbvLXBjQwSckJIfMwJYbUcNpxQxoUvN07baYAW+3PQbaFQz44PGxwtdj
Bv6kru2ZrGJAVkugTXXiDKyRG/r4mhkQGDb6Qn9xBoRTI5r39DFgPy33iMvz
WUjLoZTOrjIgoEMFkpg/oUTR8uhDFQx45cqnPnHPgaVpoZ+oGgbZjxRi1sXn
4JSX2Fw2gkG30eFBB505KDnIYZmvh4HMFyGfg4lzMGjwW+GqBQbUFlpuifI8
kMi51V+vY+B/2MN40nAebhbx5nH6YLDzn2lc2HEeLvC/rD7uj4GK7igSFDkP
O9X5HW+FYPC0+fMQDM5D3K7ihI+RGOg15PC2By+AjMax19oZGIztkyzfjF2A
pCCBv0SzMPC9k3pBIWsBZHtt2n/mYJAJT/OfflmAk3czEgIKMVivvaNpK74I
26SzxI0rMHhbdcF/pnYRZG/0n/7+GQNd0X5x8tdF+Lmx5bJ1OwYjQWZNZ6YX
If/KaPXnTgy2qxjwF/EuQVE0hZbWg4HLe6VXvheX4NiznaGboxjsKRMYY2en
wWrFsxf5NAzsYtbPT+6mQWkjM5fOwODlpakvH2VpsPJFaPwYEwNZ4crKaGsa
mNDaF9JXMdD0d/xX+B0N/LgcvaTZcVBKtcpNkKfDhqT6u1/8ONhEto0/UKVD
9c0KiV5BHEJ8NfYG6NBBM4vjS4EQDg1GMgk2F+ggp2M1ri6Cg9HvzXCJf+jg
3dL6lwgFByeHXPv8MTpoQ4tSpAwO98+IJSf/pINorBDvqiwOuUqPex4y6fDJ
NkvRSQ6HBd5gQ08eBqw+Z9ykHMPBHzVWOa7EgOLumGFDJRySCxt9D2gw4AlF
+lyEMg41z5TfCRkxgDxUJl51Egd2b8nDK05Ejvkc23adwiFmH0uo5hEDYh3G
SlwBh6Kd7iZvkohcXio/4oHg0L06Fv0iiwHNhnHb3TVw2N3duiW8kgFKT+7z
nNfCQaVWTf0mkeNr7yKPgjYOdgUlQS6dDDDr6Ko9oINDZngqXWeKAUM3xmUH
dXFo9hSQVaYzYNl4ftcrPRymbSKu/LXOgCr1ZCdffRxkj3uP8Qhg4MyycWMZ
4FAxodXWeRoDQUs/SoERDn364YxHRK4rz1r+0jTGYbmobreRGQZOUs8f9xFW
vqXi1HoFA4nteX/mzuJgPe4fEXETA+4CrmGPczgE6pUVaodi0JYbHjJN+ANJ
frk+HoNdzuJin0xwGAi6JhaWhgE/niJ+zBSHVWoBopaPwUVt1aV4wiK6M67r
JRiI2XvHLxE++VoqurIWg733+Xm0zYjzCTq/C2jFIO7wWcunhAMD03tPfMPA
ang6cIRw0tjIGk7ksk1AyYdijkOltui+klkMGld26doRHnplpeONY0BJOovH
E17j/9ddbhMDjTszIU2ERQO+xi1w46D6O3JykbDqKF/5KxIO7WWKMoLncbDV
Mh5yk8DBmD3EXIFwcMHDP4eO4GCWE3ZRn/Bzvlapqb9xGP100tSWcJUf55ks
dRyY3pzSlwkPDWtedyKee9sY+6IH4TWNOwkUYl9X/Cj1P4vm11aOOuDwLb1b
1ZXwKd71sZSrOGwJGv1kTdjO9ySHrS8OI++4jXUJhwz5HREJw8FAY1fLUcKp
SOnZvigc5IK0VfkI1+TSfRISiDn47V8wR9zPyE65ZLN0HNyMTojUE9646VHH
/wqHJ37/RsURFh/M/9FRhoNO2kE2G8JqMM39CCXuf59ymDhhh5wDcoafibmk
zHIPEc/79g4n8+29xPVyv3nxhHBd/3DagzkcPA+w4f+t35gauUmLhQNHTH95
AuHNLMtZdjYmnG7MiFYkrO7dffy2MBNeWHL4OxP5cOjjtT69jwlJuRNxdCI/
t08bha5JM4FTbbU5kDDK3dLijzChzPJMVACRv+9eHIuKhky4OuUpsUTkk61X
QxC3YIKpSP6AA2Eks8buugcTxmwDW+SIfDtuWws/6s+EcZtnW2INcbjjqZw3
f4dJvMeMvWbO4FCvUsK4ksgE7luqU5HEOn1Pp+0+lMkEcmvKShcxP2xcR09P
FjJB+FCNHomwxte8CMcGJnSoZRdHEPPX6J4mZrPAhIbCSPYjxPyW/vTwcFhm
AlrssmqmiUO2m2q1CxsLcophM4CY9weX+229hFhwUHwTKSX6Qd9Z4Pm90yww
KxbsWyL6Q2Wc+jNSlwXGepl3GKo4SDsWqcSasKDBJOsMTQWHnQ6Gg0mXWPCN
65zBCNFHnTYPRIpiiOPPuZ8MIXJYP2DuVprIgn3dl2Wtj+Pwzmr/hw8ZLKh0
+GAhT/RbvAVq1VTGgimZYMtOov8sTX8lDoywYK7t4bU+Itcj+p7CW48uwx+m
rexWok/bW065cisvA8WvoeXpXmK9dXnKd2ksw7DHznqKOA7p2nnnRSyWof3G
k64jZByckfGnR0OXYV/zjWouYo5mlS0ErduXIbX9w4lpThxYh9T43niuwJEf
MbJmxJyqT2i2PAxcAUNdWuNf0xhEpOmHud1bgbOu+ufWfmCwW+g87UDyCvzU
+2MRS8VAid2j83nzCvxo/RMT3IdB4HBSXKTYKlC/aztcacJgI47Jd+nTKth9
F0x8l4yBtuFai0bPKuQ0D9YuJmIQw8V2h0JdhRB8l82hBKJnQnfQh5irQBYI
3IiKJa7HfX+X6b5f8HKq0EfsHgZh2iaPIeAXJJYHP/DwwGDLr0J+sYNr0F9J
9x85SfRWO7HI8mvw3vlLcesJDBQzB3svqazBNftb14qPY+BqsC2lyHgNdPw2
rwfKYtCa7HxQ038NFk2qpEcpRK+pklWvtqyBXN37OQ4uDMRDIlzeX12HopQm
th9E7yv9cawwL9qA18uqO17aMqDtvmLHR+k/YDqa3zdkRQfK4/lfBUtsCGpu
ct4dWYL5FepYr8IWRG7TjxRDfFdkz1V/5o3disTu2Rs1r/ATePfm0SYnOZCt
8m6/rBOnIeZq+eUMKS5Ek++5/cTxSVhGCifdwrYhIjrwUaZwHHyPN5ftbuJG
TCxua61WjQG1qDm6W5IHSeKaaOUaGIR1956UI8E7kPPuuaSje3uJ75Ztm5er
dyJlaPZFh/ddoPdS8krxHl6EHOxImu1sgYC9F/eP2/EhwfHy12c0a0F2wWJH
vzE/omPWWyCpnwMkPjp38xo/conLI9SMnINyoClvD6QKIBbXZvuyYlHUQ7F6
cLuhILJ9I7y6gbMNLST+C+qWBRGWTQmlPK4HVZSVVIdfgsiSgk69cUEPWsf7
fRhdF0RkOXtiaI09aNc3+z0NbCTEIo7edXa5B2Xa28Q28ZCQy/s194Xa96Lq
N01CWiVIiGOMaXj60T6067m69VddEjISwzQV7u1HbUJ/s8wMSEhw/ZNQKq0f
nbhY8/SbIQkRDB54WMozgDKlVDt7TEhI+k29q0HIAEp+e0K335aEROlcXA95
PYA6N8kqjniREIlGw2z3iEGUNS/KP51IQl4yvB8f0BxGE9JmWlKTSQhzUqPq
ueMw+ve5sjDzVBIivfi7SiJsGL1RYkyrzyQhKUievXHNMLoYeKcj5TUJCTjx
uEJHeQSd4pyOMW0kIWShrgf58qPo/fcl2tz/IyHFJdzS9LOj6IGrYRt1LSQk
W7ODrOM1ijq1iVyTbSchB2/bc+x5M4qOxhsabhsgIWpQKWknM4aGaItsrRsi
IU71ZG0+wzFUbHmyyneUhLzpu8DT5T6G2tjclp6YICHTPQ0lwa/G0F5K8fba
RRLSHG8/7idNRX27Qxt86CTk1UHNmGdnqCjp3pkgaZw4X7eXfos7FS1R3HNs
nEVCbm3SpTijqajp9I/ZZ6skJG93n4JpIRWlP3uXcXadhAzflblV+IWKUkTn
tVx+kxB5Xw3pe5NU9P9USC6L
           "]], LineBox[CompressedData["
1:eJwVkHs0lAkchsdQOWuzjG+mCN+qcSKXdVKjdpz9/ZRtBtExxrbEECorl5hu
ZswJ21hJKNfcNreJWZeZcevU6KLrspVQjRKlpjWqbXVcKpW1f7znPc8/73PO
axORwNtFpVAo3gv5v59pCXU5lUBFbE1gzIwKbjcybiXpE/iIXx8Z904FsYLn
R+wXE+gZP9iVrlWBkYnC7akhgZ993l+s1qjAS+h11teYwF7JxGnqJRVc35iS
YWdO4HP/4iDMVkHUK+4PoysIfFPi299wRAX6FfSZQmsC/15MNFoJVeBBadml
zyTQpnSQxwxWQdeNZ54jzgTeG+GvarRTQXsAR7/Ak8CpAC5ZflMJmT7npJYc
Ar+4HOtJVCshZLO9YZ0XgZGPJia3KZVAdTVa2uFHoG1oZ5FtmRL8aHcZmp8J
TDYp3rM+QQnjfT+tsYwj0En2T93T5Uqw8NvtX1tIoMBTs941SQFHuNLf214S
2MbZuabkYDP0C6JDXHQElv6VHL0vqhmYB3zMG18t/NHhfz6Q1ww9Vab5Nf8S
yD94dS/HuRmIuYqMUx8JRM6Om9dfNkF9U0fcPmM6Us3ezzCDm6CPNs52ZNGx
Wy2+t9K7EWyeeGtqpHQMT8AI3VY5ZHWzWwIz6fgp6LVJjLsc3p11zFhynI5n
wqJdZx3k0J1kvG5vHh0Fw0cbWEZyiDLsz11bRsfXCe5rvXoaoN41iHNFQceJ
S18faPVuAOesPR0jj+mY92rPBR6/Hr53O1pgvpaBOaG0rNRMGTyIMGdVrGOg
dequoU6xDIQ5zQ+/dWOgYf/iodl4GTRqNRZ27gvMHew9GSgD6wKnKtYWBjrv
/aR0XCUD6uSDpoBgBo4+yTN7f6kOeuX2N0+kM7A6ZnVh+3wthFjf/aA3wMDU
Bva22KIamO45MbYvbRlq00OWHNKegRIDwX4ecznywkSXC49VgNlIezX12nKs
/+bsrwPTp2GRJI2/MdEcN3CPX79TVQSUBkHLGM0C0wMDHcKm8yGptOUErdsC
mZmPddn7T0KXQ6ahafwKjGoVRlfKc8DUO8kx3dgSU1yEifpux2HYqW8gWW2J
NPuS9jOTv4GiEpgvBFaYVyq97/qjFEJbWKZWX6zQfWbT0IepdEiVVqUNy63R
wv3qdu3FVGgatyoz3kpiSkRpIeeRBDIrpOEjfiQ6nguv0+uVQBTvjW2zP4mK
XzJGr16QgKVarfDdTuLhjZMXwyskkJW740Z2BIltbr6Vc+ESiGadnvwqmcR1
XcWnlLoUWHmU4C6Rkagu7lw2T0mBLxtSlj6sJ7G2NDay/Z0Yht4875f9QSLL
1oMrfCGGvO2toVuUJObkj/UuuiWG+TU8oVS94A9le0hzxTB8L7dSf2Bh31NH
nyDFcC5jNnLgPom7o8p1y2hiKGCH2ddoSAxmPzDxNRCDT51z26YREq2vHOLe
HhfB+cO3/0zTkcjXysaYKhEUOa3P9X9NYsjqa5rsWhEkjpXzbd6S2Kcqm58r
EoHd1tjRy1MkcqPN7rwVi8BAb7A2b5ZEAwklbn+8CJ62s2PCP5JoV+3hQNkp
AnVMzXcun0mk+UoM8gNEUEwaTc/Pk/hiNmjKcYsI/gPiNQ8O
           "]]},
         Annotation[#, "Charting`Private`Tag$1999930#6"]& ], 
        {Dashing[{Small, Small}], 
         LineBox[{{4.997448979591836, -0.5727764055710939}, {
          5., -0.2863882027855683}, {5.002551020408164, 0.}}], 
         LineBox[{{4.997448979591836, -0.6023721655782063}, {
          5., -0.31582873796752514`}, {
          5.002551020408164, -0.02928531035680107}}], 
         LineBox[{{4.997448979591836, -0.49832228781253013`}, {
          5., -0.2121248938358068}, {5.002551020408164, 
          0.07407250014095967}}]}}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{1.8673469387755084`, 1.4999999999998863`}, {1.5, 0.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {159.64762732109978, -97.02130261321227},
      ImageScaled[{0.5, 0.5}], {299.1479746964498, 184.80248116802338}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwd1nk8Fe/3AHDrvRdlu1JkJ5VE34iSnCMq+xZZkuwlUkmRFD6JFqVFKlRk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           "]]},
         Annotation[#, "Charting`Private`Tag$1999987#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwd13k8VG8XAHBZxgxlm6GQLRJ+0qaQck5FZKksJRUhWpQslRZkKVJZWqRk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           "]]},
         Annotation[#, "Charting`Private`Tag$1999987#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwd13k8VF8bAHDbjLFkmRlCmEr8JEnWKM4TirJUkqISWdpUtlDJEknZI1uE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           "]]},
         Annotation[#, "Charting`Private`Tag$1999987#3"]& ], 
        TagBox[
         {RGBColor[0.922526, 0.385626, 0.209179], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVl3k8lc8Xx23Xfe7FDVdlKyltklaJaA4phK8k2SJR0kZJUlGWQpa0KESW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           "]], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGCwAGIQ/fCpyJ45TCIODFBwdo3YiSJmBD8n7nG9JhuCzy2w
wfwBB4LvWey53JcPwT9qWdOmIYngp7z2sLsvjeAzzxX9NlUOwXdkWJ/KrILg
7z320OWeHoK/NdideYoLgt/hvaNVxh3Bj3HW5FjqieAzGXPzbvND8P2Ezovd
iEDwX1wI05LJRfCl/NICl0xF8Os9WudveYbgK971urG4VRTOtzJvmSJpJIaw
X+78T8bLCP7XU72PChrF4fwZLHElQSoScL7wva2LmI4g+Ky1jSGWhZJwPsPK
uPWPhKTg/KJZ63uFDiH4e7U7OATzpOF8Qa8inSY+GTj/ju6Fy5V7EPwN8+xV
nsTJwvmx680EZf8h+A2tCxvvrJKD89e+kJ3N5yMP53fMbU2454fgpwS9VV0X
iODL7NmzwTccwe/qjz7Wk4TgZ5jN/MhVieArtYh4sC9D8P9Z1PBeX4Hg33z7
+NKy1Qj+hPDNsW4bEfz/WkHFrXsQ/DsX++cxX0bwd7R9T758FcGfYh2vufgG
gu+9VG+L0z0Ef1fF2ZONLxH8abqm/YFvEPzCR3NCFN8j+Bo+OfcPfEHwWRiv
LJnwHcF/sNU6K+EXgr8na7G+wV8Ef7o899f//xF8AFdjtM8=
           "]]},
         Annotation[#, "Charting`Private`Tag$1999987#4"]& ], 
        TagBox[
         {RGBColor[0.528488, 0.470624, 0.701351], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVl3lYTV8Xxxvvvefe220iqVRkViGRqfZqQBooSYSkkqkSQjQokaLwU1JJ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           "]], 
          LineBox[CompressedData["
1:eJwVlnk4ld3Xx0+IqEwdZ8I5SIVMTSg97SUUkRA3mTOURMYiM0VIJSEJIVMU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           "]]},
         Annotation[#, "Charting`Private`Tag$1999987#5"]& ], 
        TagBox[
         {RGBColor[0.772079, 0.431554, 0.102387], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVlnk4VW0Xxg1ndpxwVEiplEqSZIjiWaYoQyiFSjKUlJRECUkSGSJeUSpS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           "]], 
          LineBox[CompressedData["
1:eJwVjHs41Ikehxm1WTbt6DczvxnDL2ULIZVU6+T7XfXkkksuldalNmptVyFd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           "]]},
         Annotation[#, "Charting`Private`Tag$1999987#6"]& ], 
        {Dashing[{Small, Small}], 
         LineBox[{{4.997448979591836, -3.8427478809853066`}, {
          5., -1.921373940492796}, {5.002551020408164, 0.}}], 
         LineBox[{{4.997448979591836, -3.9434436369950427`}, {
          5., -2.021662525499326}, {
          5.002551020408164, -0.09988141400332191}}], 
         LineBox[{{4.997448979591836, -3.714915502199623}, {
          5., -1.7939430946275419`}, {5.002551020408164, 
          0.12702931294482847`}}]}}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{7.989795918367346, 1.5}, {1.5, 0.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {482.0041064530953, -97.02130261321227},
      ImageScaled[{0.5, 0.5}], {305.2704236760418, 184.80248116802338}]}, {}},
  
  ImageSize->600,
  PlotRange->{{0, 644.712958263991}, {-194.04260522642454`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.7204261435162783`*^9, {3.720426177267337*^9, 3.720426209344198*^9}, 
   3.720426245981265*^9, 3.720426304769196*^9, {3.720426405161957*^9, 
   3.72042646240878*^9}, {3.720426602052952*^9, 3.720426624159672*^9}, 
   3.720427439099402*^9, 3.720432161396286*^9, 3.720432234565764*^9, 
   3.720433156800642*^9, 3.720433321710783*^9, 3.7938456946105022`*^9, 
   3.7939088930710793`*^9, 3.823229814921324*^9},
 CellLabel->
  "Out[3518]=",ExpressionUUID->"4088d074-da52-43ea-b673-3bccd427ebba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GetJu", "[", 
    RowBox[{"u_", ",", "\[Tau]_"}], "]"}], ":=", 
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"u", "[", "t", "]"}], "2"], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}]}], "]"}]}]}], ";", 
  RowBox[{"Ju1", "=", 
   RowBox[{"GetJu", "[", 
    RowBox[{"u1", ",", "\[Tau]1"}], "]"}]}], ";", 
  RowBox[{"Ju1a", "=", 
   RowBox[{"GetJu", "[", 
    RowBox[{"u1a", ",", "\[Tau]1"}], "]"}]}], ";", 
  RowBox[{"Ju1b", "=", 
   RowBox[{"GetJu", "[", 
    RowBox[{"u1b", ",", "\[Tau]1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ju2", "=", 
   RowBox[{"GetJu", "[", 
    RowBox[{"u2", ",", "\[Tau]1"}], "]"}]}], ";", " ", 
  RowBox[{"Ju2a", "=", 
   RowBox[{"GetJu", "[", 
    RowBox[{"u2a", ",", "\[Tau]1"}], "]"}]}], ";", " ", 
  RowBox[{"Ju2b", "=", 
   RowBox[{"GetJu", "[", 
    RowBox[{"u2b", ",", "\[Tau]1"}], "]"}]}], ";", 
  RowBox[{"{", 
   RowBox[{
   "Ju1", ",", "Ju1a", ",", "Ju1b", ",", "Ju2", ",", "Ju2a", ",", "Ju2b"}], 
   "}"}]}]}], "Input",
 CellChangeTimes->{{3.720426629216976*^9, 3.720426638299938*^9}, {
  3.720432130887108*^9, 3.720432149141017*^9}, {3.720432202978743*^9, 
  3.7204322163333673`*^9}, {3.720432564147153*^9, 3.720432628629085*^9}},
 CellLabel->
  "In[3519]:=",ExpressionUUID->"968bc829-910a-427e-aead-bfe97b17d86c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.2125911815986838`", ",", "1.0345602250033297`", ",", 
   "1.513868220394273`", ",", "9.875358543435727`", ",", "10.56839543942233`",
    ",", "9.14643504384498`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.720426638996644*^9, 3.720427439213414*^9, {3.7204321529712877`*^9, 
   3.72043216161878*^9}, {3.720432205168503*^9, 3.720432249463997*^9}, 
   3.7204325495724277`*^9, {3.720432580149762*^9, 3.720432597980301*^9}, 
   3.7204326449467087`*^9, 3.720433171683576*^9, 3.7204333362231283`*^9, 
   3.793845706613916*^9, 3.7939089052909613`*^9, 3.823229827260117*^9},
 CellLabel->
  "Out[3520]=",ExpressionUUID->"71603eed-f23c-40d8-902b-a4dd33381a20"]
}, Open  ]],

Cell["Reality check:  what happens when you just use feedback?", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}, {3.7202659495166073`*^9, 
  3.720265950298832*^9}, {3.7202747979755707`*^9, 3.720274806107464*^9}, {
  3.720274948616645*^9, 3.720274960711134*^9}, {3.720276330642107*^9, 
  3.720276350511654*^9}, {3.7204270245988913`*^9, 3.720427032983596*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"5e826de8-e026-4f42-9ba6-9fc359c5b0fa"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Theta]none", "[", "t_", "]"}], ":=", "\[Pi]"}], ";", " ", 
   RowBox[{
    RowBox[{"\[Theta]dotnone", "[", "t_", "]"}], ":=", "0"}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"setpoint", " ", "=", " ", 
    RowBox[{"vertical", " ", "equilibrium"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"unone", "[", "t_", "]"}], ":=", "0"}], ";"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"no", " ", 
    RowBox[{"feedforward", ".", "  ", "Use"}], " ", "zero", " ", "function"}],
    " ", "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]0", ",", "u0", ",", "J0"}], "}"}], "=", 
   RowBox[{"SwingUpFB", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "\[Theta]none", ",", "\[Theta]dotnone", 
     ",", "unone", ",", "\[Omega]nom"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]0a", ",", "u0a", ",", "J0a"}], "}"}], "=", 
   RowBox[{"SwingUpFB", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "\[Theta]none", ",", "\[Theta]dotnone", 
     ",", "unone", ",", 
     RowBox[{"\[Omega]nom", "-", "\[Epsilon]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]0b", ",", "u0b", ",", "J0b"}], "}"}], "=", 
   RowBox[{"SwingUpFB", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "\[Theta]none", ",", "\[Theta]dotnone", 
     ",", "unone", ",", 
     RowBox[{"\[Omega]nom", "+", "\[Epsilon]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Ju0", "=", 
    RowBox[{"GetJu", "[", 
     RowBox[{"u0", ",", "\[Tau]1"}], "]"}]}], ";", 
   RowBox[{"Ju0a", "=", 
    RowBox[{"GetJu", "[", 
     RowBox[{"u0a", ",", "\[Tau]1"}], "]"}]}], ";", 
   RowBox[{"Ju0b", "=", 
    RowBox[{"GetJu", "[", 
     RowBox[{"u0b", ",", "\[Tau]1"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Theta]0a", "[", "t", "]"}], ",", 
     RowBox[{"\[Theta]0b", "[", "t", "]"}], ",", 
     RowBox[{"u0a", "[", "t", "]"}], ",", 
     RowBox[{"u0b", "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.720427061485778*^9, 3.720427146034127*^9}, {
   3.720427208584774*^9, 3.7204273599542847`*^9}, {3.7204275119126253`*^9, 
   3.720427537686323*^9}, {3.720427574184925*^9, 3.720427594850327*^9}, 
   3.7204276350933933`*^9, 3.720432263532716*^9, {3.72043230202147*^9, 
   3.720432398248705*^9}},
 CellLabel->
  "In[3521]:=",ExpressionUUID->"cc442d82-f22c-4246-9095-5b5850387b4b"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd13k8VN0bAHD73EGWGTODaCpLlJDQhvO8tFgSiaxRSNKGCNGLilDRoiJL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       "]]},
     Annotation[#, "Charting`Private`Tag$2004770#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV03k01IsXAPDZzajsZETfFqQsqURI96aUiLJVoilbRYU2rSoxLdZ6ZMkQ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       "]]},
     Annotation[#, "Charting`Private`Tag$2004770#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVl3k4lG8Xx4cUlcbOjJ1SCElCytx3KGtlDz9bkkSJSEiForKUIknWKGQt
krIcWVsQIku2mWQpsg5Cep/3r+f6XOec71nu5XpuKefzZqdYSSTSKAuJ9P+v
4amxturxMFpCgdPqNStxzKYj7DVIdUFc04JasbLieE9qQlIx1Rd1L2Qc/7ws
ho2au14mU28guY8zm2pSxfBxl8XK+9Q4FGT3eznmlyju33VTJ5qaiea9Wj62
RojgNIFj4RHUEtQ0P9mTP0rBl5sf1lm9LUFP/zxsaauiYKuwIdat/71CM0GL
bWLxFMzJ9L5WnlSKnmlZDikeomD/jjj/CYk3qETmrojiUyFsGtvrfnR7FXpV
vuabelYQh3AU77hNrUORiVLF7FR+LK9379ZLrzr0w/6un8AsH24POz/+rbEO
HZTZk2PyiQ9vW6eQq+RXjzL+OFKPXeXDDX8zlTraG1CisYyZ+wgv5pyL3ysR
9QEZ+1NebAIenNAfqPNqrQWJbVjk6JLmwgdFbTIHLD8jSuytug1DZPzTVn09
R/5nNFv4OjgqmYzFJwJO5iu2Itp5Q6NHVDI+f0ZNhtTXiir76/4rFtiCeV0K
s59qtKOvpYuUGrHN2NomvXB6pgNZQqDmHw92PPXNYtMT4U6Uo3rmPwN1dhzu
wHHKXKcTLSyoaAyysuPik+eFS+M6UWZ1UcC3xA2Y7KkVdln9K8Kr4M7Tsh7X
h/bYbrjShd73cmkdOciGVfJ4Nohy9KJta0ZtjTYs+INSvVOzci+SXzsaEqDI
gp1e+JdftelFdybKtT1YWHB06aAX/XkvanesUic/J+Gx6vxvz458Q0NOT9Qf
rf5DKZ0GL3bH9qG41vh8llN/0eZ/IXZ64oMos8Jld3fMEko4c9xB4fAg6thw
xGFafwlt61Bw4vEcRDeKquASyxKi5XSd/FY5iLJjLVLbfRbRm5z4V6+VhpDy
e56NBfYLaNJ8osKoZQiVcNTLPz00jyyzH37y2cJAq9zf64ZOTqMk+1BjVykG
OnuA015SbhoxeM81W+9lIO6B/bfD+qfQ+Svan7XsGSj4FyfdbuE3um022c6e
z0D6FQGhCrsnUeWqdu9j4++I407L69SP40jG9PdYbeQwuhUtoGpx8zsSvqan
eTp9GCmnVf3eJPUdceenRW56PYy4NWxvRpUz0DKHuZIpYxhV0wr+m5ilo9bq
1z4DGj9Q9aOCNlaPIRSoHLK29OMHKlL0mrf514vOO/QeS1r5gUjZxyz2GvUi
l6g96YhnBJFcaW/DE3rQsbEfOuEHRpDJr7Gs6+rdaFua4W2+2BHEvT/IujC8
E7Vw8fMr4VEUE//ETMytFdVqnTvVZjmKnGxZyINxn1GZR0OprwfBIcYXd9u1
oIxGf5vy+FGEWxWbWmc/If9r/Sn6k4TdbzElGjUi6alncicTxxBJ0nLSI6sC
XWrZhxLmxxHJbo7jyJ5IICu9+vGB4ycipe76URAaB5nRylErogRHfDfHdo+h
zXhHj8Mhgv2MePK9MmHnJ34fmfifKLiXuhbYXASDjVPPXqr/QtW5pPqtepXg
t8PjyLDRL4Q1esXVG6qA8+bInIDTL+TEYuH2XbIa9h3uxwG3fiHS62JnjYfv
ILbuYy/qIeKf7+nVPl8Heu+ekpsDJxApc7VL9fMHGJCUerV2ZwJVV143Hvb5
CL7BSf8pZ0wgJ/UXvauCnyAdxWbHfppAQzeoOj7WTbBSGaxtKzqJSAfG9pe/
b4HCt//5jVYS3Emv9ylqg8PCXaLU9knktcXzwPOFNugLMKs1HJlEacbBWnIH
2mHjPgPuAvJvFJyRNrC+vh1OvlZ77uv4G3Wf8Dxi1/IFhEp4BlhYptBQcgt/
cHUn2EWtWAwLTiENHOtaSfoKT1x+fGpQIOybx7X34a+gIPDmTaT1FFqykz45
W/EVtP2cHggUTaGxR7Vl9/O7QC3p+LO4XdOIm0d+rflsD9jcaqKHaU6jpTtv
RlPTeyDI96DYpUPTqDroYklDZw+8M94ZZ/Mf4b/XiEI50AvGf9dCxG9Oo7E5
m6lJ0jc44fDMPntgGiVcP7kp7Gwf3DAUefRonIgPFyahh33wTC2mI2J+Gk0r
Otk5v+uDCXKg0blNM4ibcsj1J18/+MGRfSpqM6haM6VN8mU/PMqt8d16cAaV
0YYz9br7oeKhehG/8QxyYr7aQ//bDyxeUjsWT8wg2WFJFm+9AYiSZPJXRM8g
t2y+RumOASjgdDfJT5hBlK2ljDXmALQtDUSmZMygJWnFEiuhQRBse88a8mYG
DYlUMq9YD0J6SNL0oR8zqLv9pOPHjkEoZeg0fT4wi7jf33si+98QfNUPmYnW
m0X+7a8a/pwegoWCKkFjs1lkgROOxfoOgfrlfSfen55F2zIqTklFD0EZ366F
6vuzSJccerW0fAi6A86KXEueRW6VDzO6GoZgaTAHa2XPIt/bJT11bUOgkbct
8k3lLOLo3HFs/egQvNEVlnw5RuSvndu3k4sOvc+PH/Kam0VRDFzzhkKHZe4H
7kprs4j/aD47RZoOmv1cr57zzaGi3/qXDqnS4e3F9YYZtDkku3lm3NOKiP+m
ff6EwRzKTrJIDHcg4g8Gx0lYzCHVx1p7vV3psJ+8MvD4zBzyHy6sqL5Ih4pn
0z5xcXOI+1MYt8V9OvRxKj0yS51DGmM3+MiP6LB6waOK+/kcCg6Sk0lJpYMW
GuGIhjnkwuWzQTuPDlVd35LDfs6hMRZ/yKilw4AWtVaHOYcUVnjVqB/osJZh
NcZCmkdlHWt9p1voQPNqU7kqMI9Uf18WvN9NB+BobPTD86hJPy586y86DHmy
TaoazSONG9R+jyk6kDoP8s5ZzqPu1nZyzBwdcHqF3XmPeWRx3tD63AodnNiX
QxT95hG3vJbwjn90CD6nnvUreB5VNDZtrmJlQPW+lzOn4+dR1JWd7Tc2MmAo
dUpwezrBa0qmrzgZQNqgeGA4l8inqmFRx8WAg+1Z4U7v5pHy3TrNawIMcNb4
kSveNI9cxILe76QwIDRFuq3v6zxa3f1EqUyYATXuySI2E/OIrfpJt7cEA4rH
PTwcFubR/CM3dFmKAZlumuUnSUy0TVnow5mtDIgb5dh8ZhMTaYzGFmrJMCDM
tcvWk5+J8sLbFBa3M8Dvx9PnPuJMNNxZExgvywBXF99lf1kmsk6y/SIizwB9
Z57E6wcI/zz9qB4FBuyjD47fOsxETmE3nHiVGCDvVLDvjgkTkeZ271DZxQCR
waDbsbZMxFapI7xPmQGcDkY9CS5M1Pc8z2fHbgb87aPKpXgyUfd1x3N/Cf79
35h/hj8TRXEdO1iuwoCB3tL32aFEfgFPuRN7GPDZJoxSEMVESXaFjlMEV3eb
uxXHM1FH3npxV1UGFB2XLitLYyLf5pMp9QSnf51mr3pO6IdVCJP3MuC+JRyv
LWGiG8mszYjg6x3RWe+rmKj1m+yULcG+5naLze+ZSIFDutyR4FPt8npf2plI
9OeQ+1GCrUz/xHf3MdG8vrXGDoL1WhtH+keYSHki0P4nkU/jWLza92kmylbf
y59AsGyLS/jYMhPF5Ny8r0ww9cier5NsC6jCvIyjhKh/UxPL9jnyAsIJf59J
E7xs2HpxibKA7Hqik4OI/n99SKn/K72AlANSRWuI+fTpnxNYp7iAlnrcLOaI
eTY37j/Fob6AWu0lL3ITXHV406stBxfQvOtqAZWYf0F9Nxuf0QKKOr5HhYtY
n1TdLAuKJeF/b0Vphli/mNqLmWKOC6jjUmQn7GRAsLbuvPSZBdTtQbW6TKy3
M6bHKl5ZQMEbNj57s4MB5lD4XeUmoefd1XmA2C+6tKt7NO4R9ftcScvfxgCZ
AyJftJ8uIN9auUZrYv+NqVvyWjcvoGnzhdReKgN6Src623ctILfdvhOfhRjw
ce/sC2f6AuJ4HWRZQuz33D13Tc8xCf2mp/uNeBjguetDTKjYIuqIzv3xip0B
jgUPh27uWEQcIuZtsusZYKLoqhy9exF1Wz3dHkWcN5Wd61ofHiL4TXD+tr90
YG7X4so/t4iwUWx4+gxx/hnajRH+i6jiZqOK7W86hCfrX3O7voisdU6sZyXO
vyC/xdTWR4uor79+TGKYDmosHp8T6xYRSd56b2InHfy/Jdy9JbKEWh3p0SWv
6FAdn6Lnun0J9d19N+D3gg4cZpn/dHYvobpIhuHOfDo8el94/t/hJaSaaCDi
kUncl68ajvldWELBSw5yRsR9t3p3nsvlwxJqn9ZyeuFBB12j5caDHUvIZLB8
OJu4L6M2kIIlBpdQkut68Qcn6CB2ZfN07zyhJ7ThqPFxoh936VZTyT+oqOWO
6z5tOlzTNYlBl/6glnXzFAVBOrD+yeUWkVlGarumDB1fD4FIs/Yc2rWM8nhM
JhJeDIFqek+ny75lJL3+zMGm3CE4ZcD+uODIMrpf/9VRMm0I3j9yltH2W0ay
+3f2B98agruaVM0zjcvI1pPNSs16CESDwk++PrOCfB98btwyNghq/5xKzQtW
Ud+JpRkj7QFouqHa0iD/D2XuXs/hM9wLEjG//uT8JmHRQOXuOOMu+LU4ONCp
zIprtN+2zcp3QObP8o/kO+uwu3DyMJPSBmSxrKnhYTbccOdqN2WwCaLOvHJN
27YBv486vl07/D0s4Nxht2vsuGBjVVWxVx34qtSVCNZy4Lfzalrj8u9gsKAu
sk1qE5YMtVN8aFgBK+4dj+UCN+PdkpHK7oavYedB9jXXck6MSB7P522Koeh5
7o7uak583CFd8bBhMajym5gaNHDiGKdE/gzNYjgwmpC5s40TCzO4Z6+KFMPR
aHmj6RFO3Nn0Wraq/yVc6DmSEMBLvIt6FC5YuLyEN95xKlFntuBvGbuGCgNe
gN4TqdMvhMh4pCVO0PxmIagmkLc3iJKxccNv/UXPQpC8szLcK0XGcSxynnlW
hbAc0OnMpkDGsRI7TxtsL4R809sOxzEZV/9VnzRuKAA+lhnLv25kvIVT5ar3
xgIYdKzWNXhLxjK6NK+Jx3lwScxRmm7Hhcs/98bcnsoBZxNlq74TXNi+8mni
9W85cPQ6S0SXKxfOEStJiWzMge3jGTPNXlz40Jd3PvWpOdBRMlb99gYXPhlY
6DJokgPKxhcc4/K4cO+nw8uZr7JhLDAsSW+VCzs58lbvv50FChOWm7uOcON9
UZePtVk9hTILY4gw4cYiI3K/k3Sfgk6ltg/NnBv/9DNO9VN5CrZ3dn17as2N
hY20+SzIT+G28sZc35PcOFpJS7O0IRNGfCsMeQO48QLty2EuzUxI+ysdcSST
Gz95aRfcLp8BfFzTHHXL3Bh4M0ueqKRDe2XETYO/3Njiornq823pcP+szIbP
/7hxnslrlgrBdOD9aLuul40Hcxa0uK8tpwFvWP3fKTIPjml+/PZvbRpwryTO
imzlwd2v8n2GjqcB5+ihPh8jHrzDTOwoFzkV2OBx4dYkHuzgaP5gljUJeg/o
6g+m8GDBGuGzbeOPif/xiaHEdB6sV7ZQVdf6GGxLtXh5s3jwcujt5LGUx/Ai
f9CX9JIH1z10Tdl64DE4JG3V7G/kwYHjDi9sAhOhLCC3Ln6OB7+uv53ouP4R
eKiW92w04sW9H5QYDWbxUN3amVd2hBdzTRZ8LqbFg8C56WunTXixECRtfSEf
D/BUZnu9JS+O0b7U3McaD3xCMReCnXjxnfutrQvFD6D8j8vmxYu8+BZv6MGd
1AewGchaw2m8OE30xIDuVCzkGjinVS3w4vtyPaO1jfdAVUGKhv7w4uGf6oO3
yu5BFXnoG6zwYmZxUIFNzj1o/WIv9I7Eh7uNOorFI+/BvL3NndpNfDiYcdVn
77F7QLtgEvRenA8fDu6Lu9MTA62JNOv2w3xYf5bGf3byLjB/CXOPxPPh7CXn
dPMnURCXPNqY9IgP165XdVS+GQV7jpVcM0/iw1eOXnHbdjYKvF8emapO58N6
7KwUM7UomPQPbnmcx4fb7ePZaj5Fwo/1I1GmNXx48/wqfXg5AjolXmysnOTD
5I0W4pVnbsMrc711cbr8OPkHWy0pPBxuGZWFierx43VGNmeTvcPBTkeO46kB
Pw6IzK83tA8H1j2bt5Qe5cehToWWXarhcJT3s2C3NT8urIm6VTocBmOtVvKi
5/ixu0PO9lC9MBA+6mqa+YAfdx09HrxMuQHX9MNSS0b4scy6rP1zYyHQ7uBm
pzzOj90qsi1edofAtotG1Lxf/FiIle311fch8DGdJzZjmh+/7I7ejbJDgH8l
Ofz+Mj8O22c/a+8WAtn5pee8yALYPsvh8KZfwdDKO7ZfQU0AuzMFs0rnroFU
v2F3RpgAdnMvGyj0C4KImv2FlrcEsHTm7bck2yCYzVIIZ48UwEubzcM9tIKg
5gJZ1SNGAPtMJ8bfYQsCF472uyqPBfBGo4fqHHGXIXuPjd67IgFsTU4PKn0d
CEoRp0sHvglg1w4uP2+eANBUvxFHVRHEhVlaX0Q2+cFXZ6pasqogljQrzWqd
vwg+dwq6JNUFcVTdqY6Hgxch70e3sOwBQVzZ+mHF7tVFEI9TTFc7LIjDJ43G
qk9cBNaZr/nmtoL4V3lCGqPSFz49l2uMDhXEG7asPFO67gN24p//sHwRxEdk
d2mzIm8gUy+8Ku8UxK8HWX0vKHjDOz4B74vdgjgr46vlPNUbtm/8b2ysXxDT
2r/9VGB6wdTcyNfPY4L4WXtNxvk8Lwj9sFacvCaIF/7pUpXEvSDbV8lzn7wQ
vml4nWkh6gnMj9EMrxAh3KTIf0dY0x36Nne6rV4Xws8vmF4YEHeHGmPRqZvh
Qvjrrfod5evcIabl+UpKpBDW2bavuKr5DMi3N/I3PxDCdrOpGyacz4BDD4ue
3HMh3BHxx7v5nhs0jF7MpbcL4cHeL2ziLKchgc3B12wbBTMeR+dOS7nA2kmh
vW3bKbijqepxBacLuNS2Mo/JUTBr6sWhx4snQTlU59IRJQquSjm0Na75JLz/
Jxuor0HBTZOHPp8JPAmLy3PXaMYUfCPTYC2pyxmsZm5HyvtSsDSvHW9F6gmo
MNExzvGjYGcRt0udUSdAumiVUzaAgh9YfbUkBZ6A357n78hcpWAvqpJuhMUJ
CJuwuCd5i4J1H4gYn9t0AkpGJR4KJlFwHuXinpMBTsA38OoJax0FB7zLajdt
dIA7nFeuvG6g4ORY5bftTxxg035d67MfKHgpMjvN/6oDsCa0b/naQsHbak6N
q6g5wKzplH9ODwVDm+B3+yx7aK2XPWYyRcGLS3bIO8YOovIfryQLU7Eyo/Zb
bpAtcPQ5fzUTo+KURB2ZO3a2cGOT/At2SSoefFl86t4BW7h8uszVW4aK39ud
MlxetQF3qc42XWUqDuwtkzW7ZgP6D8jZvw5RsXj7ijpLhDWsvxJisc+bijX1
5CITS62gZGbiD/hQcevE+C3dJCtwcbVOPexHxVN0YzmOUCuoO7brp/llKl6T
bVv8dsQKbkj3X/MMo+Irx0osikcsge29Rm7GIyr+rTNvsUXMElj5plnINVQc
6ah69stjc3h587+suDoq3pHzYST8hjk4rzYYizRSsZC+vo3pOXOo+ZH8ULaJ
il1Qbrc8MofQMiNFna+EvnHR1t/fzYDFIcva/ycV96rP/cvcbQakHIdCBq8w
zv958LJxvwk0THR5pgoI4y02ejUsjSYQpWyqZEcRxrbh7XKfi0xAqEwnv1NM
GA/3cy29uGECSo2yue9lhfFrl9C2OEUTsPsx+6yAJoyXBj0UfNiPwRupmymB
7sJYrXLjW3qIMVw9RXJQPyeMlXUsDf7aGoNuToDY/HlhnJJPqtZRNYZW5bNJ
5y4K48DMoFqTUSMYQ6aJTsHC2PinfK3rMSMQdBCJPxwvjJ38fZ857jCEC4mF
0bw1wjipzXL9OaYevF5NvFlTJ4x1UW743g49WHUID7nQKIyD7eCedLEe3Nxq
f7G9SRhzbKzOP+OtB0l5m+zvdwljTZeTPVlTh6G+6pQC7yTRbwCm18weAsp3
kU88FBHMFkj1vMSrC/aH2OvfCYtg8cwU9kimDjzJmq3yFhPBDmmdv6u6dUDh
7IeXbdIi+GqU9p6bqTpwkOmXeE+RiP/s7xmvpAPu7O1neHQIdrEOiTfThsqd
tzh4PEXwMmOmyPwFBrUOoeb7XiLYrX/57+gjDEVBWff4fUSw9ot0vQehGJ40
NwhT/EWwmaW9j6YFhlvn1ytKhIrgs0nKWjYzCMyKQ00V40Vwt9rfbPUoGoxq
Xkk0qBLBwwVaoWw/9oPTd07HT9UiOIp/by1PxX7ojUzaeqRWBJdEZm83it0P
TX3leSbvRXCCn2LiQe398PLqctXxdhGs7FdjpvFEE4JqLn0/NSKCNVpXRxXc
9wGP4QWFULIonr65aKFJVYe0d1ybNXlEsW9yOgqZVQPlffnjM3yimBR+5MnC
JzU4Kjv27ARVlNif1cJnr6lBxAYHqYPbRLHbwac/gsb2AlutgSBJk2AxDhNy
rSos7JciXT0lijVyN/YVJ6hAWHHVwF43UXyjVkbmwiUV4N9pVznpLor9vSdo
NlYqsEf4YaC9lyhuErizK51fBbyWOJkHLoviKMlSXr7Y3TBesjS+EiOKY3r2
HDn+UBn6FFu/BFSIYuWfNStO/oqQ+ovnyjoQxdx1m3bs0lEE5xzz7dHvRLEs
Py1hP1kRxrd1+ac1iOJbecc8yU8VYEFkQKyxldDjCPr6oHMn8GyaOM3/g+jX
dZRl5aA8HB5hXy3YIoYpEmGiiYd3wMZMg6ca3GJ4yPCfdz1lBzSdiDxawyuG
9VnzRGV/bQfzfnJ6p5AY9u+9Hns/Zjs4dQgcXpUSw0UGUfPMfhm4XLM1xkBN
DHdHzP2uD90GRSlo27ADoVcWIbphTgrmAufYT5wQw8GGTax+TVKgdjzrV/9J
MeL9c+gs/zMpKOfiKu5yE8NLMamL32ykoCF44OCnC2LY63aeekytJHxzvuL4
MlwMV/dHzDbRJGDDjvLE4AKCL61JeE0Jg8G681f/FolhE/XeNP18YYgalHYO
LBbDTuakFh8PYeBJiJDzLSO4UHu+eowKohtty07XEPVoGjMURymg8mup8+hX
MRyjU9i2ZU4Q7AvVeMTWCD2u5tM1unxQartEbiWJ4yHJ85fvsfMBecNbzuvr
xDFetrAs/cgL1XZaHOMcBL+1avpnygvSm3T/lfCJ41bn/p5wFx4YcTGdNJYT
x8EWtjyiKlzgKXz2Q5AFwTt/isUFckBDvWLjruPi2Kl4/xcZfg6Q8J6qY9gQ
9ndGOUYF7NDaeKFa31EcS+4VO206vAFULga85ncn6tEqYaoeXw+Ln8Of5l0T
x2lcDtW9x1khOCw9pO+5OCZ5rNstG/KnassldsMT+UR9be0q5xhLVYlu53hH
CglmY12N1V2qKjbalzFVQuTjTJO6vnmxaoSnrY4VCPvdxFPNGfNVRikkDrkv
hF74kMPV5akqwdeOdy6uEPzgFGmzan9VRna91fJfgv0Kpd9If6tSTtwpcY0k
gUmWhzf48fdUGVxZLLy1nmCDqfVbWDqrgnTutj3mIrgoWyF69UMV43MVf81W
grcVia+2ZtDyx8Qek40lcHBQWZO9wSDtVnKY08BRCVy9kGPckzBEczGblCkw
lcB4wwzJJpJOE62oKDpynOCwXfFOHt9pEXf/a4hyJri1Uu+j0CjNTe3RzKYA
Qm8Ph9vXrb9p0jf49dmfSWDJ9I4XEZFM2ppG0JaubAnsdHjKa2KCSeuZ/N7+
LJfIJ7ginnBkgRZzvNj+8AsJnGY1Aa2ci7R/8mY+YRWE/vVRu8HQJVpf292U
dV8I/2pnbdWjK7Sy8MWTXzoJ+zoyKTlzhRa331Euo5uIN02Ksl9eoRk9VSrR
HpDAQ2STiPGMVdpb/+YPIeNEPaYrjoem/tLiFffeNZ0g2OtG3w28RvNmJFlI
TRFcNiy09d4aTdb47GD1PBEfI6ZzTfkfjY2lIzNmkWD7+d+0a/9oQ6/2uzst
E/lSM9qcmv/RKtwzdin/Jea7++7whS0k9FBiM/PfP4KFim1G95DQ/wCXtfTN

       "]]},
     Annotation[#, "Charting`Private`Tag$2004770#3"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVl3k81F8Xx8c6Q7ITwmjRT0IqS9ZzW5SKZMuSNJVSJEMSKUZFClEkWxKS
LduMkOXL0KZEEbJnCWXfosRzn7/m9X59zj3n3HPPuXO/6065W5zhJJFIxRwk
0v9/D54Z/lw1EmQYm0tbCjgqj7j3yNB7pJ3AUOa6YZSSPNrxJDaRKe0FNMWI
kw1/5NCh+tbCx9K3oHJ60ob9RA7ZOP2ueCAdDad5Qo5F/ZJFXVtv7wmXToOz
ec3u/XfXomQJs+C70ix4fzbihMGwFPKrf1R79BULrrZuaL5ISKGjQb2cG44V
QXS31Ib3MVJIYM4joCzxJVAErqAFIynk0xztM0othfmk0xSUvgaZR7W7HN5U
CZJcfuYeFyVRIIX53x3pWsgv4OFWlRNHyvvvhxTSayHjomXMxXkx9CXIfaTj
bS18HBlV7GkQQxu5VLLVvF/DsEGXgOlNMfTmX5pa85c3YLcz+Zn9qCgSmInR
pIa9B7XKAiP1tyIotuvqnqLlT3CsK6/uuaEQ2iVrl9Zt3QAV4VYVeUuC6Ke9
Ng/lRQNESlqFipQJIvlR39MvVBtBkZcq17dTELmf11IkdTbCieMH6gp3rkai
TnkZz3Z+AeKS6epR41XI1u5p3uRUM4xPmD73zSKjiQ4r/hSZr7Apt/Qq/xUy
CnaknLHc8xVeLcmHDewhI+Zpd5mX0V+Bv2k3cambFwleNAjy026BrKwAYlGS
F72+8c2e93or/Jlesb/2kBttzxHhlaW0g0bpLjORtxzovdprWr16OzQKTnyi
J3IgWoFPmb9dO1i8lEgU8+RA4S976N+z2oH997LFenkONFz1oiPdtAMenBGL
c/QloaSvBwq2RXXCgppj8gGfZVi1EuiwX74HpLTimpv7FiH2vI2jyr4eoJmm
qM8kLcLGZhWayMUeuNa/uSPo2CIYZrae7qjAzAg5z9uyAKWZMUXFar1gssUs
7FzjbxizHC0/9KkXHOadh83b50CDr9XAsK8X0o4q6d14PAdXK6sr1ecxvyJ4
FU7OAXnzoyoJ+e/AMAzcnzIyC+uWd9X2uH0HOn+eUtHKDFhnPPpwaXUfONmz
NAphGhKP3zA5u64PuLMDfIL4pqFP1K3eVrMPKBL56kTTFLhf391gcLwPEp30
tjudn4I7FmNfyC/6wMROb8U5bhIqlna3J5j0QxXj69DgmnFQNB8frgkdAJ+7
T3zH3YdBJmC/rvPTAaBElS0fFR8G4RfJofzFA3DkMt/cvdIh+EOxVDPvGwDh
5e6Mc7xD0FhVfKl75yAwtGWsUzMH4ap64PLC4CDE7t5ovlOiH9wd280S/w5C
2z/6KuE3eB9hO56CyA9oM1ql+uxKH5gND+4J1v8BttyrVLi6vsPG5IN3xKJ+
wM75c+yL+b3wSUhcXA0NAV3gHF1yuhNqDNzOfLYeAkb14A9nl04ocX3z0ssV
5yHe2C080AGpb33symKGoFfJJZXW0Q4+AV1JxmNDMEnexnz1rQ3WT6RvPh0/
DJM/T1d7iX2FK590IHZ2BBQKUooz2z6CoFrR4HvKT2Ao+5TUb/gIaeHqYX9l
f4LCu229TfQP8Nnkv2+ORj+hNyymz1e4DrZ8EL+kGPMTqij8zk1n3kLP24n0
Qu1fQLL9Lj19hg3e/7maDhz6Bb2y6fKv6qtB4PaPGQnaL6gSCS3epl0NOvu6
kG/IL2A0HCE2CFVBVG1dO3zD67kkWAHPymB/9TPB+qujQGo9luNnwoRuhXVF
y/cwPzLT1TArBC9G4jH11FFAD8mlo1YF8BSiMqI+YL2pvDz0Sy78rWDstpcd
A0bP+30r559D3qtj3kMVY0D6t8PewCwK9sm0ykp/wSx8qpQQioROX4uagz8w
s6rl3xTdAT6dA8K5guNAyvG+37L7Kpwu1sryOoE5H4rtqN7EGpZINwfHBDBM
97PkOxMIh7C/VgOSmK9EdRgwk4gUp8EPb1Qwx0deLiSSCRWJ0tJQ2wkgaai+
i/FLJXZ70x5K5GP9pJ1xLjODCDl8UGDh9QQg44pDxbOZRP0mjZvtHVj/Gy/8
XD2byPl1s6SBaxKQEd3oQtwLQivRJj166yQwti0sTq8pIOxCPn4P0p3E9WqJ
rkgrIK557ZK7YjSJ++HfrPLWQqLaZEu03bFJoEWYVXIZMAmTf8uB8rexfs8i
yMigiDjpmH48oxuvj+Z3rmsuIW4dXBsXN4LjyXbzmRqWEulakc13Z/H6Payj
75+VEqOCVw+58U9Br/Pfp7UXXxHehKnOdq0pYFDq8ixGyoi4bLbXhl1TgEw2
ndy2p5wof6SdL24yBTSbT8rbEsoJDvq6/36fxPb8OT3pRhVEmMKceHn4FCjU
G5WP36okcgVcjryInQKSdoasfWMl8XmhOzQpFdvPZu0TkCEIyc/vOANLMefp
NdpkEMTTwMRJo8EpOEKRbrptW0XUuomoaE9OQeSowJP4K1XED7tgZ6W/ON8h
qYD+h1WEynZ6N7/INOR/G3tAbawiXvbt+digPw30Rf47vnrVRItx4FT4/mlA
TQW3Oa2qifncSkkTi2mIHHC42OZaTWj76Zx85zwNk6q/Yzzjqgnb797BwZ7T
0LjpRpZuXjXhs5+Vvfc6Xt9mfMCmtpooEds6X/UA2w9WfXg4Wk20+V5YG/AY
23MKBpatVBMLPZnIIGMaGHafnAxE2cTOnI2hpRU4H81e++OabKJ0r4xC4fA0
KGgM8+/xYhPtWTZG9BmsG/Pl+99gE3+EH7qoLWNe0urfGMkmdLuEirLEZgBV
qroUZ7IJ+z2m7efkZ4BxZ9tiehGbuJp5d2XTZqy7F4eRq9nEq8s8B1MNZ6CK
m9Be34L9d+x2P3lgBkiefnd7erD/XYxoqtUMRHpttRUfYRMyGRWlXY4zIOzq
Y8ieYhN6gn+7E85je9ZM+89FNuHgtZPb3msG6LmGHyI4aohr7Zc3SwXMQGPJ
fE4hpYYoT5+8FB2NdZ8NZT4SNUSngFqcxRPs79eX9dS1NcSSp2ulcBbOd9hp
+oBCDSH7LaP/E2sGaA3eb/9srCEM4AclnMD+BL0Md2yuIRyfbVA7VDcD6qkh
n2dVagj/VSct+b7OwJHxiXakXkMkeST5vO3B8exjWFI7aojK1o7HQT9noPfI
uZLrmjVEt4F0zZ457E/PAnlo1xDLqUeHOUizMHkLpc/urCHk+aNXV/HPgkIM
dS+fbg1hSP+83V9iFkjfOi7lY3ZsEbTVV5iF/OKTEb8w++ubXP+jPAtVCY8n
yzAnpdxJKdGcBfUJv6n1mAnK27feCOtrR36t06khei9yj2kcmoUjoZ91XuH4
pK+7RGesZyHy+TrNMZyfgl6AdgFtFhjtr7XLcf7oabmDu+ssNIZnJShtqyFo
5D+Bqt6zQNtS/mqHWg3BcNN+/ouB85cdGu9WriGSm7w+ZoZi/eOaB1v+qyGq
dAqnnGNmITlVd1lmA47/ZEJy01McX0A/PFcex+dV1R/Ixnq8TeSQdA2x68vz
YFo1jh9aGXRYqIY4tXMwW/4j3o9XG9Ofr4a4kbT+c2cL1u0GW2y5agi2y+O1
dqNYVxu4JDTPJpgjrq6O83i/lrfPuU6wibRzumWnSXOgUKlowRhmE0FnW+0v
is8Brb0zre0bmzA+JRJ/U38OhAMmsh1K2YTO956RkH1zUCWtlBOXzyaUabk6
947MwZFfF/pinrMJAcdD32Kd5gBlp97/Gs0mGuyCpHLD5qA30s7x+gU2UdVm
eY4Zg/lII+3rSTaRb7O+pCR5DpLrWEmzR9nEA2vCpoY1B41nWTWhiE0cNV+M
aevE+T0XuLRNhE10GrtJcKnOQyNN3JWUWU3Uv9U7Q9Geh8hdeuKKCdVE5T7+
otW75qHqQ1CzbHg18WTvcysp63lQt710P4ReTZxC36NUr8+DguRK/hnNamJY
21rUtn4eeu+Sqt8XVxFzmwyEXrj9BrRU69K+jyAM+3a/vevzGxQMx29bUgki
+LFxwLmbv4GmdF/5/u9KQlLcamJDHLb/+L7b8XklocXh2hBfi9kwT+osdyXh
0xEbEbJ2AdCaBwEaReXEUsSskNP7BUj+5b3p32IpwbmYLbxW8Q8Ip6wE9xmx
CK0V2kvL3CVI9hfoDHqUSpiYVt0wKsG81ZztcSCVOJ1ANdNmL0Hv1MCNkL8p
RKR295BMyxKQ3OKmtWkpxIj7Mem+f0v4fonenLHlKZHYa32NbvoPqs6GVmvG
PCY42Ad3h4/+AwSKAvrHowkp4SzBgHnM3y2EROqjCDVHvg46aRkYSyvPDxtE
EfZ/3l6yEl+GquRRWR7qA4K13ejZWv1lIEVqWzd9iiDOpgIlKxTz4TNcH6Vu
Ex9vaXx6o7wCJIuGMVHT84Su0AfO+5qY/Ycdd3x3IjLiTmofQ//nnqYgXxpx
M/de8oQ15jZzOdmOw4Ru27CnVCDmjyZeO3ZaQsaWx2tcWjG/PLaZp+wy7B65
kc+7m4QYto2D2Ut3wVftU53rfhIiLdpHX58LhfxL0oONJlgX17ykPxYG8st5
0gk2WL9/tSXw2z1YFO26sdWNhNC6nu8PLe5Dvr62tW0sZjnnKAb3Q6BG/lrM
HCehKqLB/zdHIlSeDMgsnMF66ffjm84mguMOMbuyBexfLgJ63ydCYotuyUdO
DsTo3HhnLuIxSMnd9Z6QxOwsnZUp+QREs5RmNIAD9Y7cWFEmPwWe2jOjRAT+
bsjPruBtToW0h4sJ76Ix05rN5pdTYa9z+KHPcRyItM1UN3dzGtzgL8rqS+VA
CgbX/a/4p8HyEe7zPCX/58UIT8VnsNCVMniwlwOhRVWxDefT4dfvnu6v6pwo
+dr6GeN3GfDSOYJ9UIsT0eTfd92cyABGq2E6oYf1kl3fAiUzQbL4sVvmPk5E
pzWkvj2dCbu9jy1dc+BECofvLvj/zYT42RbpjSGciNHm2cqmZoPxVL2VZw8n
itwoxteq/wLETl7fOTSA9eAtyu8cXkB3o4qsw09O1Luu/1vgtRfglR/abzSH
/Z2PeWJW9gKeuB/wlF7FhWgvXrbaaeXC/FhtRJUWF0r223LefH0epP0sqxO8
x4WkTm7eG3I+Hy4+MtvgEsWFFpp56H8v54P23n6/17FcSGHL/RdHb+RD3WN+
1WupXIgkNsd6HZ8PU0fsIkZKuJBSf5FNSF0+GBbPW9b2c6G2NfpcTMUCoDjd
zaGOcCH19bE3C9QL4IuwPI/fOBeyPfXMM06vAM64GL3ctoj9SYvPKpoXQJhc
tNQTQW5E9+Qd2uFXAN9ubuvy1eFGUgLUSK0PBZCi/lrzqyE3ihVvUmppLoAL
Xbb31PdyI3XWTAituwC/mxgwdJgb9fprzmpOFcCmn5+eWjlxo4XnLW8HJfD7
+ciFs1sjsO7lMup6rBAE5Z5PDAxwo4zRvMpnrYWAjt7s6h/hRsb+Ohkm3YXg
GXHiQ984ZusdJ/oHCqGFQ+p57wI3YrAHvHunCiHpR4hjpwAPqlLQWbN2FRPU
8l3qmzR40DnFa67Jukygjewr+6LDgzIon1oOISY8WL8h87MhDzIe3SMxbMSE
+eiOWw3GPIih2Gsyc4QJlb4m+h8ceFDJ2nGHo2eZYLpHLZt9iwdRbDjcHO4x
wf8af1z1HR6U//eerWwUE/KLfgRX3eNBjc55gp8eMUFc6cmpylgeRDtDkiI/
ZUKngLDMqxwepBB/wORzIRMutEyFFDTzoEi+3PSmJiYkCX3yzv+G41sXuha3
MqHROMspr5sHISJgMryDCRplp9CLYR40bDbtKdbPhKUnTb8zlniQzyj3SOAU
E8LOF51N3siL2vZYURZXseAnehGySpkXRUp71poLsWC/1LMs76286N3Spt8J
oizgfBs9bqLLi3wk2ig80izw3ejlvWjGi2xLfrRtUWRBy1/XWCdrXqSwzsRI
VIkFGk2nXzXY8yLaL5PSn8osmAy0XH52hhclN6SQPNVZcLZne7CFH/Z3aRel
U5cFtS+VMyoYOP7GqiwrAxasv7e+TikY+1fa0EcAC7r0RQVXInmR8MV484t7
WWAVP/UwOx3r7a4cqqYsKPQYKZbMwfH5t0jrm7FA6MD3b4EFvIgu1XrA0JwF
db8b5WzLsb3EH21Zaxbsss5/xv2FF+X73ZFADixIUsl4696K19+uZ48cZ8ES
V/JIeycvIi3xrr59ggUlhRGqBUO8SMrF8VXiKRZI3r1tJjvGi2KD/A0lnFhw
6WSAx+1pXqRkHvs08AwL1ITdi47/40XD+hX7tM6xIGzobOs7TjKyZdRl+p/H
9a50XNxBISPh0q+qZS4seOZ22IBfjIwUzH+2C7vhehvtO3FZioykmuY2Kl9k
AU3WMLBXjowYkVxftN1ZIPtB9fVLJTKi5UCMugcLrqYoDq1TI6PeA18/rPVk
QauvHF/4DsxPBVP+YtYwl9iysJOMhnmy/mu8xIIHSqtNTxvieO/OuMZ54fNZ
4Xb/tIeMInVJ12wus+Bw61KkzgEyKsnVPsfvzQK+4NFmISsySh70FjS7gs/v
+MD8VTsyMjb5O9iLuVajU+qHIxnRlySanX3w+Qk065o7kdE746ChfsyM/g8O
5efx/m+St1r7sqD7VY3/f+54/T/70jLMeg/Kkh94kdERPsOHa66yIPY8k/3P
F+e7cPHzOczzKHvgXAAZhcjnXMvDXJ72K+HKLVwP3oX5Icw3KCqWwXfIKEz+
gfUaPxYYX7jA//AeGen7XUkzwCzYmFOdGoX3p/5swh5z844xn8JYMqqykNrj
jjn+kap69WMcf74+6ypm2l+3oYYUMkJba7Zfx7zpRG5S93N8HqJzP7wxj7LH
rcdyyEiWSWtyxly4aevqpQJsv4mL+whmn7vutfzFZCTO+HZrK2bD8Tw/6XJc
j+bek7yYuS0mtytVk1HOTsnnzTj/uiL1n1pvyGiJ8KbFY46U9nhq9IGMTAJW
4mwwH71eYGvVSEY77744IYBZ9vuU0OmvZKTi615RguvXt3f7W492XF9Jx0oH
zBkZnv6MHjJqOyHmtoDrf1GAqRkxgPPxU2kOxaxBnxl9PIL3H7ZvWRLzn6Yd
aTnjZGT1ankuDp9ncAJLtG6BjMqXKnxu4/M3WZl93/aPjByOrUhN4/4QPa0Z
OMRJQQwXywIrzEnKLye4V1NQiErGLAfuJ6d78+liohQUvbmfZYL7TXlay3H9
GgqScn32KAL3Y1Fp8UdYR0G2ZhoT/+i4f+UWbh7eREEa+nq+mzGjwJ16x7dQ
UCSH4RFT3O8fjUszr2pSkFJWtpA/no+B1lfBRQcoaDTQ5t8tPE9Zen8Nag9T
0LVdblJeeN7oT/TmvlhSEInz3Ndjzniez5afnjxOQWht4AkJPJ/i8xVoiycF
CZR5dG2jsaDdbvm3zhWc34Me9SFHFiRXGOYZX6Ogkgdr/R7i+0AliJA7G4zt
TzjLd9mzYK949Z/keAoSl59mSuP7xGt7LUuyBu//99Z9R4zxfGgoJN9/R0H0
x4vxXvtYYKt1LVTgEwUZM3xo9/H9paercYrzGwW1BfO4sRCe991pQuPjFNRs
e77t6U4WRJjfcnktw4f05SttN/6H58ey1xop8KGcvLH9XzeywNNaf1eZIh9S
SYs8E7Ae94fd7JoCdT4kbph8jJDD/XHS6XXiPj507bT35QkxXB/6XgUvTz4U
JvM9QnqFCYmeyasmrmD7Fu+7p5aYEO61NH/+Oh/KoPk4Pltk4u9cVv2JED5U
3r+2XGqWCdqMjX6HkvgQ9xN39+JhJtRGcLesr+NDISNP2V2NTOjJrQ39vI4f
+ZA8D0g8xv9HY9yj2//jRyQ33VUVcUyoUjEyiVbhRyGSfIK0GCYkZ70WsNHm
R22WqQuPIphwKv1NeKcJPwr7vN2sMZAJPx6/ixi6grls4YLLGSaMhX2M+lfP
j5o5Gsf9NzPhr0tzwuarq1CIyIx0Q3ohbNlFXj5bJoAWMhNy98cUwP6Udc4F
awSRSVnA/XHrfLgid2L9dwchJNV4i6G6NxdURq1XtZoKo5ITrJPFv7JBTGiS
UvtHGF1Q0FFr9swEbiIhb0OiCH7P3jk4a/gcXDXKvvEdEkU/c/TVLq2kQfaB
U8mV86JoNpDHkTydAnO/ZIR/xIghrZeum8NUnkKR5X6u6L3iaEFJc1n+cxIE
GAc9Yf0QR5NyPLWz9QmwrutgW2qQBOLW76JIrY0DXe1b0dLbJRHpRIeDvmcM
OMg3LHI0SSL6MrXk0I5omKsL76MHrkFeKUbHvpAeQCy3o5fFRinUzuvOK68U
CWLdRSmctVIo7bLBI79V4cBzPdBKx0MaLXDFZjR33AFSpmNen6gMyrGN3M6/
7TZ4xueFi7JlkK7WHY5T8begYksIReTiWnTwmPEqo6M3QOSgp8oNQVnE+JH9
vdKDAZ2qjU2+5bKo8e7l86+0r0N+EmwccJRDWQ5f8kWUrsLxPC0RuWU5JMNn
GV7ofQUYQU8DO7PkkcBmhYOC7V7wYlguQdCEipT3/Pv0I8cTQh4H0boPU5FX
UEXry1RPcLIYU8w1pyL7dCuH0HhPkC0vzze1oSLRI3yNu0I84W7EsTdhp6hI
JU55w8BpTzinFTfF70tFavViGUtrPWH9LXFjcjoVaSzKL1+M8IDlnddWt2ZQ
0ZvHwj51wR7wbaz/S3o2Fd0w5FdR9veASBvm8X0FVPRS86/O/AUPWFG2uBRU
TkXtinJFVQc9oPNzRBJXExXlKGaekiN7QEnw79NNX6lI4A/f3bJlOkTrndic
2kZFZ3X4Pxyfp8OhZ2qs3d1U9Kfy0/3cQTq88ql/HzhCRUimYJFRS4cYVc0I
81EqGlY6WgTldPDoS7RaN0FFA3Znr3Ky6KBkcqGnapaKUqZfSEWn0oGbozkt
8jcVNR9qGzuVQIfeIj0X2h8q6kywrNWMokO5S+pW9X9UlHtKOl4glA6PqKvm
Vlao6J3IBrehG3T4H+AxFJU=
       "]]},
     Annotation[#, "Charting`Private`Tag$2004770#4"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.720427390870769*^9, 3.720427440273419*^9, 3.7204275381710577`*^9, 
   3.720427596883791*^9, 3.7204276367922487`*^9, 3.720432161811356*^9, {
   3.720432254462366*^9, 3.720432268837665*^9}, {3.720432382868024*^9, 
   3.7204324000375423`*^9}, 3.7204331727363367`*^9, 3.720433337256846*^9, 
   3.793845707644765*^9, 3.7939089063245687`*^9, 3.8232298282197*^9},
 CellLabel->
  "Out[3527]=",ExpressionUUID->"168dd53f-56ff-46a2-9f53-d990414ac356"]
}, Open  ]],

Cell[TextData[{
 "Here:  the actuator is so strong that linear feedback still works.  It \
would be more realistic to limit the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["u", "max"], TraditionalForm]],ExpressionUUID->
  "91cdb32f-9806-43ec-8795-0dbebc2fdcc0"],
 " so that direct torque is not enough (on a static pendulum).  This would \
make the linear controller fail."
}], "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}, {3.7202659495166073`*^9, 
  3.720265950298832*^9}, {3.7202747979755707`*^9, 3.720274806107464*^9}, {
  3.720274948616645*^9, 3.720274960711134*^9}, {3.720276330642107*^9, 
  3.720276350511654*^9}, {3.7204270245988913`*^9, 3.720427032983596*^9}, {
  3.720427696800769*^9, 3.720427751909362*^9}, {3.720432035091502*^9, 
  3.720432075947226*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"838a100b-c72e-4a91-91d1-b45835084255"],

Cell["Export data", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}, {3.72033837444219*^9, 
  3.7203383773780823`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"dcf9643b-4043-4706-be2e-e7b469535440"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dt", "=", "0.05"}], ";", 
    RowBox[{"dat", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Through", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "\[Theta]1", ",", "\[Theta]1a", ",", "\[Theta]1b", ",", "u1", ",", 
            "u1a", ",", "u1b", ",", "\[Theta]2", ",", "\[Theta]2a", ",", 
            "\[Theta]2b", ",", "u2", ",", "u2a", ",", "u2b"}], "}"}], "[", 
          "t", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "\[Tau]1", ",", "dt"}], "}"}]}], "]"}], "//",
       "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Export", "[", 
      RowBox[{"\"\<pendFFvFB.dat\>\"", ",", " ", "dat"}], "]"}], ";"}], " ", 
    "\[IndentingNewLine]", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.720433128393359*^9, 3.720433130951447*^9}, {
  3.7204331888371763`*^9, 3.720433229267655*^9}, {3.720434234724616*^9, 
  3.72043423674949*^9}, {3.7938456690016212`*^9, 3.7938456884838037`*^9}, {
  3.79390888498757*^9, 3.793908885198913*^9}},
 CellLabel->
  "In[3528]:=",ExpressionUUID->"caae4b6d-cbb2-4614-835e-81e666280bd9"]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 273}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"fba9f931-078e-4759-a9da-25445a4a885c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 854, 14, 105, "Section",ExpressionUUID->"a1bb5411-324a-4c50-ac13-5ee0d82f7ab6"],
Cell[1437, 38, 376, 10, 52, "Input",ExpressionUUID->"d5a1adf2-c763-40f1-bb40-9ad6ba5b46c7"],
Cell[1816, 50, 8107, 212, 551, "Input",ExpressionUUID->"a6237697-baf9-422a-9ddf-93319940d50c"],
Cell[9926, 264, 491, 10, 52, "Text",ExpressionUUID->"7c5aeaa9-1287-449d-ab72-47b84e0bc07e"],
Cell[10420, 276, 4228, 115, 280, "Input",ExpressionUUID->"f6de5fec-4c3c-4766-a4ce-149d3311d7e6"],
Cell[14651, 393, 501, 12, 52, "Text",ExpressionUUID->"4ca37b1a-baa5-46da-9c78-1b31789ed584"],
Cell[15155, 407, 12442, 316, 768, "Input",ExpressionUUID->"6cd31715-6a82-493e-a472-e538d00a951a"],
Cell[27600, 725, 676, 13, 52, "Text",ExpressionUUID->"b623d4bb-d420-4aee-85d7-06a0748df8b8"],
Cell[CellGroupData[{
Cell[28301, 742, 2391, 64, 199, "Input",ExpressionUUID->"12605c02-6d7a-411d-95ec-0839ac4136b3"],
Cell[30695, 808, 487, 10, 39, "Message",ExpressionUUID->"8fdd263c-2ed1-48c2-b543-1471a9226828"],
Cell[31185, 820, 489, 10, 39, "Message",ExpressionUUID->"27957dc7-09f8-421e-9723-224d22c55e15"],
Cell[31677, 832, 487, 10, 39, "Message",ExpressionUUID->"4a5c688a-b6ac-4963-bcce-3ae72de7d07b"],
Cell[32167, 844, 471, 10, 24, "Message",ExpressionUUID->"37f7ba45-466f-4cde-8269-83f0b51f7100"],
Cell[32641, 856, 488, 10, 39, "Message",ExpressionUUID->"19fdf806-5e4d-42c0-844b-dd4a1c15815c"],
Cell[33132, 868, 490, 10, 39, "Message",ExpressionUUID->"977c15f9-bbd0-485c-af76-77b80d24962b"],
Cell[33625, 880, 488, 10, 39, "Message",ExpressionUUID->"f9850852-2cef-4ca1-971a-7f2136bd1c57"],
Cell[34116, 892, 472, 10, 24, "Message",ExpressionUUID->"1dddab5e-fd68-41f9-8c08-b153da0906a8"],
Cell[34591, 904, 490, 10, 24, "Message",ExpressionUUID->"0d169221-bfdb-4925-8d8a-322776fa3069"],
Cell[35084, 916, 488, 10, 24, "Message",ExpressionUUID->"a6efba2c-6cf7-4825-bd95-5ca577bd32d6"],
Cell[35575, 928, 488, 10, 24, "Message",ExpressionUUID->"de647e03-31e0-4ec4-95ce-8ae9b10e6b47"],
Cell[36066, 940, 472, 10, 24, "Message",ExpressionUUID->"a6de2033-5162-4478-b4b8-fdf9d5bdce7a"],
Cell[36541, 952, 488, 10, 24, "Message",ExpressionUUID->"84a88c75-83c6-4e1e-8489-628399e91848"],
Cell[37032, 964, 490, 10, 24, "Message",ExpressionUUID->"af22c570-d8d4-48d5-8b08-4aef4e9de77d"],
Cell[37525, 976, 490, 10, 24, "Message",ExpressionUUID->"8780a7d3-edf5-4a05-855c-fe9569cd6a99"],
Cell[38018, 988, 472, 10, 24, "Message",ExpressionUUID->"91241488-b4c0-4f85-bc04-20b0d2b2c92f"],
Cell[38493, 1000, 490, 10, 39, "Message",ExpressionUUID->"4edc1406-25ff-4ab3-9894-ca967945f895"],
Cell[38986, 1012, 490, 10, 39, "Message",ExpressionUUID->"315d13c1-637d-4ab9-9d8f-a5a2a71f96cf"],
Cell[39479, 1024, 488, 10, 39, "Message",ExpressionUUID->"09f55049-4cd0-4e5a-863e-c26edccab7da"],
Cell[39970, 1036, 474, 10, 24, "Message",ExpressionUUID->"d43d2056-65fa-4bc9-a99a-47a207ae10ca"],
Cell[40447, 1048, 488, 10, 39, "Message",ExpressionUUID->"611ae81b-9927-4c0c-b316-c24abbec1616"],
Cell[40938, 1060, 490, 10, 39, "Message",ExpressionUUID->"7155be5b-92e0-4a53-9ee7-24b6ec7e46ea"],
Cell[41431, 1072, 487, 10, 39, "Message",ExpressionUUID->"4e79bb1d-8685-49f2-a27d-f08d8b3d2314"],
Cell[41921, 1084, 472, 10, 24, "Message",ExpressionUUID->"96aab984-ef82-4209-9d92-0ea9ac2ad163"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42430, 1099, 2617, 76, 241, "Input",ExpressionUUID->"bdee4149-6813-4459-b98d-def2a01ac7f5"],
Cell[45050, 1177, 153380, 2637, 317, "Output",ExpressionUUID->"8b5475ee-7787-41a0-97c3-55cbb0ffa2b6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[198467, 3819, 1372, 34, 73, "Input",ExpressionUUID->"5390756f-c76d-4327-ab92-5e4ec8706228"],
Cell[199842, 3855, 116039, 1965, 203, "Output",ExpressionUUID->"4088d074-da52-43ea-b673-3bccd427ebba"]
}, Open  ]],
Cell[CellGroupData[{
Cell[315918, 5825, 1438, 40, 153, "Input",ExpressionUUID->"968bc829-910a-427e-aead-bfe97b17d86c"],
Cell[317359, 5867, 695, 13, 34, "Output",ExpressionUUID->"71603eed-f23c-40d8-902b-a4dd33381a20"]
}, Open  ]],
Cell[318069, 5883, 684, 10, 52, "Text",ExpressionUUID->"5e826de8-e026-4f42-9ba6-9fc359c5b0fa"],
Cell[CellGroupData[{
Cell[318778, 5897, 2770, 76, 199, "Input",ExpressionUUID->"cc442d82-f22c-4246-9095-5b5850387b4b"],
Cell[321551, 5975, 34944, 600, 245, "Output",ExpressionUUID->"168dd53f-56ff-46a2-9f53-d990414ac356"]
}, Open  ]],
Cell[356510, 6578, 1096, 21, 100, "Text",ExpressionUUID->"838a100b-c72e-4a91-91d1-b45835084255"],
Cell[357609, 6601, 444, 8, 52, "Text",ExpressionUUID->"dcf9643b-4043-4706-be2e-e7b469535440"],
Cell[358056, 6611, 1389, 33, 233, "Input",ExpressionUUID->"caae4b6d-cbb2-4614-835e-81e666280bd9"]
}, Open  ]]
}
]
*)

