(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    225439,       4361]
NotebookOptionsPosition[    219316,       4252]
NotebookOutlinePosition[    219708,       4268]
CellTagsIndexPosition[    219665,       4265]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["1d optimal control, unstable case (Problem 9.8)", "Section",
 CellChangeTimes->{{3.51389296222151*^9, 3.5138929763455257`*^9}, 
   3.707422625143325*^9, {3.70825332807104*^9, 3.708253331795342*^9}, {
   3.793843317928846*^9, 
   3.793843323873178*^9}},ExpressionUUID->"0c678526-7571-4f72-988c-\
4e297b88b373"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.739275726601492*^9, 3.7392757286985292`*^9}},
 CellLabel->
  "In[373]:=",ExpressionUUID->"10839865-d360-4970-8592-a4e792fe2b32"],

Cell[TextData[StyleBox["nominal optimal control problem (with the variable a \
known exactly)",
 FontSize->16]], "Text",
 CellChangeTimes->{{3.707347555181609*^9, 3.707347582594514*^9}, {
  3.707442063493147*^9, 3.707442072299552*^9}, {3.7075124401671667`*^9, 
  3.707512443443941*^9}, {3.7075150626652737`*^9, 3.707515067495439*^9}, {
  3.738688170771207*^9, 3.7386881739103823`*^9}, {3.738696568492777*^9, 
  3.738696575810809*^9}, {3.739202738341859*^9, 3.739202777726156*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"3635dcc2-8c6f-4308-90ef-0db6627aa92c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqs", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", 
       RowBox[{"u", "[", "t", "]"}]}], ",", 
      RowBox[{
       RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"-", "k"}], " ", 
        RowBox[{"x", "[", "t", "]"}]}]}]}], "}"}]}], ";", 
   RowBox[{"init", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"xs", ",", "us"}], "}"}], "=", 
  RowBox[{"DSolveValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"eqs", ",", "init"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], ",", 
      RowBox[{"u", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.709139885317635*^9, 3.738691135871646*^9, {3.739029489556562*^9, 
   3.739029498076292*^9}, {3.739134930176834*^9, 3.739134931762774*^9}, {
   3.7420694897459087`*^9, 3.742069524853056*^9}, {3.742069555633182*^9, 
   3.742069565080217*^9}, {3.742069671529387*^9, 3.7420696832069883`*^9}, {
   3.742069744881503*^9, 3.742069745269767*^9}, {3.7420697824084806`*^9, 
   3.7420697861819353`*^9}, 3.742069905926178*^9, {3.742069984186489*^9, 
   3.742070001727455*^9}, {3.742070427162684*^9, 3.74207052295934*^9}, {
   3.742070554638876*^9, 3.7420707638616*^9}, {3.7420707960848303`*^9, 
   3.742070843666211*^9}},
 CellLabel->
  "In[374]:=",ExpressionUUID->"e94cb34e-a602-4292-bf20-8441d52e7610"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "k"}], ")"}], " ", "t"}]], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", "k"}], ")"}], " ", "t"}]]}], " ", "k"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.742070446197999*^9, 3.742070523933083*^9}, {
   3.742070564312347*^9, 3.7420707663695803`*^9}, {3.742070821196188*^9, 
   3.742070844922884*^9}, 3.7420708753660173`*^9, 3.7938434490221767`*^9},
 CellLabel->
  "Out[375]=",ExpressionUUID->"1226b677-dba8-4dd5-bb59-53503291ed50"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"J", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["xs", "2"], "+", 
       SuperscriptBox["us", "2"]}], ")"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Infinity]"}], "}"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"k", ">", "a", ">", "0"}]}]}], "]"}], " ", "//", 
   "Factor"}]}]], "Input",
 CellChangeTimes->{{3.70825335767706*^9, 3.708253362818994*^9}, {
   3.70913989363244*^9, 3.709139902449538*^9}, 3.738691144454947*^9, 
   3.7391349456206923`*^9, 3.7420692711691303`*^9},
 CellLabel->
  "In[376]:=",ExpressionUUID->"3e3f5d21-7db6-45cd-9a95-a4bb7ae34813"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"1", "+", 
    SuperscriptBox["k", "2"]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "k"}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.708253354748096*^9, 3.7082533639021053`*^9}, 
   3.7083756481578407`*^9, 3.709139912876421*^9, 3.738610248936923*^9, 
   3.7386829476652308`*^9, 3.738688135938773*^9, {3.738688369881712*^9, 
   3.738688389527754*^9}, 3.7386884680389643`*^9, 3.738688711750258*^9, 
   3.738691145740097*^9, 3.73869231181982*^9, {3.7386989406950197`*^9, 
   3.738698950487529*^9}, 3.738718344140843*^9, 3.739018989729496*^9, {
   3.7390251715726233`*^9, 3.739025192668598*^9}, 3.739025919699586*^9, {
   3.7390295045467854`*^9, 3.739029509261347*^9}, 3.739036257806075*^9, 
   3.739052263838434*^9, 3.739052392427558*^9, 3.739123243611929*^9, 
   3.739134946917718*^9, 3.7391356747358503`*^9, 3.7391364487507963`*^9, {
   3.739192934388364*^9, 3.739192959663879*^9}, 3.739202031956005*^9, 
   3.73920611472535*^9, 3.739210377382745*^9, 3.739211755503655*^9, {
   3.7392118252258587`*^9, 3.739211842932145*^9}, 3.7392157409515247`*^9, 
   3.7392158654229307`*^9, 3.7392191361355658`*^9, 3.7392757344559793`*^9, 
   3.7392786929974947`*^9, 3.739307894177318*^9, 3.739503526268404*^9, 
   3.7403354626589947`*^9, 3.742069221564536*^9, 3.7420692831185293`*^9, {
   3.742070832931038*^9, 3.742070875537879*^9}, 3.793843449471488*^9},
 CellLabel->
  "Out[376]=",ExpressionUUID->"50b07619-48e2-44db-8440-0264bb9d16b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k0", "=", 
    RowBox[{"k", "/.", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["\[PartialD]", "k"], "J"}], "\[Equal]", "0"}], ",", 
        "k"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"k00", "=", 
    RowBox[{"k0", "/.", 
     RowBox[{"a", "\[Rule]", "1"}]}]}], ",", 
   RowBox[{"k00", "//", "N"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.7083770901491537`*^9, 3.7083770949312*^9}, 
   3.7091399197070417`*^9, 3.738610266238842*^9, 3.738683211593131*^9, {
   3.738683256981542*^9, 3.7386832592830143`*^9}, {3.738691152030394*^9, 
   3.738691173269662*^9}, {3.739134965238594*^9, 3.739134981057103*^9}, {
   3.739135695461186*^9, 3.739135702762217*^9}, {3.739202872929987*^9, 
   3.7392028753146152`*^9}},
 CellLabel->
  "In[377]:=",ExpressionUUID->"2dab23cd-efa0-4f4f-b31a-ef460f11071e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox["a", "2"]}]]}], ",", 
   RowBox[{"1", "+", 
    SqrtBox["2"]}], ",", "2.414213562373095`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7082533748269377`*^9, 3.708375648215966*^9, 3.708377096487281*^9, 
   3.709139925009893*^9, {3.7386102490428677`*^9, 3.738610267667057*^9}, 
   3.738682947755769*^9, 3.7386832126774063`*^9, 3.738683260162538*^9, 
   3.738688137857438*^9, {3.738688369981565*^9, 3.738688389603134*^9}, 
   3.738688468127096*^9, 3.738688712027734*^9, {3.738691157638296*^9, 
   3.738691201828122*^9}, 3.738692313728911*^9, {3.738698940891856*^9, 
   3.738698950712036*^9}, 3.738718347764017*^9, 3.7390189899980793`*^9, {
   3.7390251717614803`*^9, 3.739025192936626*^9}, 3.739025919942594*^9, 
   3.739029509531333*^9, 3.7390362581364098`*^9, 3.7390522641700487`*^9, 
   3.739052392747394*^9, 3.739123243838209*^9, {3.739134960056418*^9, 
   3.73913498193021*^9}, {3.739135678426704*^9, 3.73913570334085*^9}, 
   3.739136452410799*^9, {3.739192934511269*^9, 3.739192959814868*^9}, 
   3.739202032043215*^9, 3.739202875904377*^9, 3.739206114870482*^9, 
   3.7392103774961853`*^9, 3.7392117606799297`*^9, {3.739211825330536*^9, 
   3.7392118430785007`*^9}, 3.7392157411012983`*^9, 3.7392158655389137`*^9, 
   3.739219136272278*^9, 3.7392757460565443`*^9, 3.7392786931361094`*^9, 
   3.7393078943596287`*^9, 3.7395035264355917`*^9, 3.740335462957294*^9, 
   3.742069221799284*^9, 3.74206928543507*^9, {3.742070853382818*^9, 
   3.742070875633547*^9}, 3.793843449500162*^9},
 CellLabel->
  "Out[377]=",ExpressionUUID->"d905319e-65d3-4f4f-aa7e-60399f5c867b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"J0", "=", 
     RowBox[{"J", "/.", 
      RowBox[{"k", "\[Rule]", "k0"}]}]}], ",", 
    RowBox[{"J00", "=", 
     RowBox[{"J0", "/.", 
      RowBox[{"a", "\[Rule]", "1"}]}]}], ",", 
    RowBox[{"J00", "//", "N"}]}], "}"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.73920291457592*^9, 3.7392029237057133`*^9}},
 CellLabel->
  "In[378]:=",ExpressionUUID->"239ddb15-37a9-4e56-b374-020e63ad5df1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox["a", "2"]}]]}], ",", 
   RowBox[{"1", "+", 
    SqrtBox["2"]}], ",", "2.414213562373095`"}], "}"}]], "Output",
 CellChangeTimes->{{3.7392029114337883`*^9, 3.739202924097375*^9}, 
   3.7392061150044003`*^9, 3.739210377620831*^9, 3.739211763508029*^9, {
   3.73921182546005*^9, 3.739211843212483*^9}, 3.7392157412333193`*^9, 
   3.739215865667939*^9, 3.7392191364067593`*^9, 3.739275751140091*^9, 
   3.73927869336248*^9, 3.739307894616707*^9, 3.739503526585587*^9, 
   3.7403354630542717`*^9, 3.742069221900587*^9, {3.742069288559271*^9, 
   3.742069295720181*^9}, {3.7420708561221933`*^9, 3.742070875734034*^9}, 
   3.793843449540536*^9},
 CellLabel->
  "Out[378]=",ExpressionUUID->"a4bce152-7c48-4e44-b17c-207c3670a2f3"]
}, Open  ]],

Cell[TextData[StyleBox["lognormal distribution for a",
 FontSize->16]], "Text",
 CellChangeTimes->{{3.707347555181609*^9, 3.707347582594514*^9}, {
  3.707442063493147*^9, 3.707442072299552*^9}, {3.7075124401671667`*^9, 
  3.707512443443941*^9}, {3.7075150626652737`*^9, 3.707515067495439*^9}, {
  3.738688170771207*^9, 3.7386881739103823`*^9}, {3.738696568492777*^9, 
  3.738696575810809*^9}, {3.739202738341859*^9, 3.739202739713395*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"c64e4ee2-78e2-43ba-9f4b-7d9d188a2283"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Mu]", "=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[Epsilon]", "2"]}], "]"}]}]}], ";", " ", 
   RowBox[{"\[Sigma]", "=", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "2"}], "\[Mu]"}]]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"adist", "=", 
   RowBox[{"LogNormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}]}], ";", " ", 
  RowBox[{"pa", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{"adist", ",", "a"}], "]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", ">", "0"}], ",", 
        RowBox[{"\[Epsilon]", ">", "0"}]}], "}"}]}]}], "]"}]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Mean", "[", "adist", "]"}], ",", 
    RowBox[{"Variance", "[", "adist", "]"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.73869203662407*^9, 3.738692082022849*^9}, {
   3.7386929419272623`*^9, 3.738692943987998*^9}, 3.738693709607493*^9, {
   3.738696068778055*^9, 3.738696085465523*^9}, 3.738696607098299*^9, {
   3.738718450346401*^9, 3.738718463355825*^9}, {3.7390198770270576`*^9, 
   3.7390199869414387`*^9}, {3.739021437380102*^9, 3.739021439033208*^9}, {
   3.739135853415125*^9, 3.739135874145462*^9}, {3.7392103126262703`*^9, 
   3.739210350170382*^9}},
 CellLabel->
  "In[379]:=",ExpressionUUID->"25f0bf31-1ef2-44e9-beb6-d936ad918a37"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   SuperscriptBox["\[Epsilon]", "2"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.738692051031067*^9, 3.7386920826212606`*^9, 3.738692329061078*^9, 
   3.738692945306321*^9, {3.738696082100026*^9, 3.7386960860295553`*^9}, 
   3.738696609020075*^9, {3.738698941175426*^9, 3.738698951062274*^9}, 
   3.7387184646419888`*^9, 3.739018990801241*^9, {3.7390198834810038`*^9, 
   3.7390199000621853`*^9}, {3.739019942539401*^9, 3.739019988106409*^9}, 
   3.7390214407928457`*^9, {3.73902517245851*^9, 3.739025193806096*^9}, 
   3.7390259207150593`*^9, 3.739029510647072*^9, 3.739036259095182*^9, 
   3.739052265147232*^9, 3.73905239346521*^9, 3.7391232444240437`*^9, 
   3.7391350899077873`*^9, 3.739135735326124*^9, 3.73913587480376*^9, 
   3.739136462358288*^9, {3.739192935214876*^9, 3.739192960477597*^9}, 
   3.739202032412436*^9, 3.739206115136916*^9, {3.739210354621458*^9, 
   3.7392103777548437`*^9}, 3.739211765539136*^9, {3.7392118255917263`*^9, 
   3.739211843345491*^9}, 3.739215741390849*^9, 3.739215865801095*^9, 
   3.739219136540201*^9, 3.7392750243713703`*^9, 3.739275778573002*^9, 
   3.739278693731864*^9, 3.739307894776593*^9, 3.7395035267506313`*^9, 
   3.740335463141568*^9, 3.7420692219994*^9, 3.742070875834063*^9, 
   3.79384344957347*^9},
 CellLabel->
  "Out[380]=",ExpressionUUID->"50c3c899-ca39-4dab-a77b-8fcb1650298a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"amax", "[", 
   RowBox[{"\[Alpha]_", ",", "\[Epsilon]0_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"InverseSurvivalFunction", "[", 
    RowBox[{"adist", ",", "\[Alpha]"}], "]"}], "/.", 
   RowBox[{
   "\[Epsilon]", "\[Rule]", "\[Epsilon]0"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"amax", "[", 
  RowBox[{"0.01", ",", "0.5"}], "]"}]}], "Input",
 CellChangeTimes->{{3.739199691446599*^9, 3.739199729923699*^9}, {
  3.739275008115221*^9, 3.739275018975748*^9}},
 CellLabel->
  "In[381]:=",ExpressionUUID->"19ec6624-d4a9-4750-a526-0c0062320bb3"],

Cell[BoxData["2.6841124764715443`"], "Output",
 CellChangeTimes->{{3.73927502092203*^9, 3.7392750259896927`*^9}, 
   3.739275780469961*^9, 3.739278694547072*^9, 3.739307894926724*^9, 
   3.73950352702684*^9, 3.740335463224944*^9, 3.742069222097731*^9, 
   3.742070875934163*^9, 3.793843449578589*^9},
 CellLabel->
  "Out[382]=",ExpressionUUID->"71bbee86-2e4c-4117-abe7-4ee684ca934e"]
}, Open  ]],

Cell[TextData[StyleBox["Optimize feedback gain k over the restricted system \
range of (0, amax)",
 FontSize->16]], "Text",
 CellChangeTimes->{{3.707347555181609*^9, 3.707347582594514*^9}, {
  3.707442063493147*^9, 3.707442072299552*^9}, {3.7075124401671667`*^9, 
  3.707512443443941*^9}, {3.7075150626652737`*^9, 3.707515067495439*^9}, {
  3.738688170771207*^9, 3.7386881739103823`*^9}, {3.738696568492777*^9, 
  3.738696575810809*^9}, {3.739025766420356*^9, 3.739025770504059*^9}, {
  3.73903907397663*^9, 3.739039083030118*^9}, {3.7392025554160957`*^9, 
  3.739202570213138*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"33f04ab5-4ec8-45ca-ac8f-c35d50c224aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"pa", ",", 
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"LogNormalDistribution", "[", 
      RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "a"}], "]"}], ",", 
   "J"}], "}"}]], "Input",
 CellChangeTimes->{{3.739540527056553*^9, 3.7395405668452177`*^9}},
 CellLabel->
  "In[383]:=",ExpressionUUID->"ca45bd7d-fb9e-4894-a1ce-e09e9290bdf4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"Log", "[", "a", "]"}]}], "+", 
          RowBox[{"Log", "[", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[Epsilon]", "2"]}], "]"}]}], ")"}], "2"], 
       RowBox[{"8", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[Epsilon]", "2"]}], "]"}]}]]}]], 
    RowBox[{"a", " ", 
     SqrtBox[
      RowBox[{"2", " ", "\[Pi]"}]], " ", 
     SqrtBox[
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[Epsilon]", "2"]}], "]"}]]}]], ",", 
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {
          FractionBox[
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Log", "[", "a", "]"}], "+", 
                 RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"Log", "[", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["\[Epsilon]", "2"]}], "]"}]}]}], ")"}], 
               "2"], 
              RowBox[{"2", " ", 
               RowBox[{"Log", "[", 
                RowBox[{"1", "+", 
                 SuperscriptBox["\[Epsilon]", "2"]}], "]"}]}]]}]], 
           RowBox[{"a", " ", 
            SqrtBox[
             RowBox[{"2", " ", "\[Pi]"}]], " ", 
            SqrtBox[
             RowBox[{"Log", "[", 
              RowBox[{"1", "+", 
               SuperscriptBox["\[Epsilon]", "2"]}], "]"}]]}]], 
          RowBox[{"a", ">", "0"}]},
         {"0", 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"1", "+", 
      SuperscriptBox["k", "2"]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "k"}], ")"}]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.73954052795408*^9, 3.7395405672541733`*^9}, 
   3.740335463326055*^9, 3.7420692221973352`*^9, 3.742070876035226*^9, 
   3.7938434496086283`*^9},
 CellLabel->
  "Out[383]=",ExpressionUUID->"f97cd952-828d-490b-a207-5ce2a8d1382d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"paJ", "[", 
    RowBox[{"k0_", ",", "a0_", ",", "\[Epsilon]0_"}], "]"}], ":=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"pa", " ", "J"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"k", "\[Rule]", "k0"}], ",", 
        RowBox[{"a", "\[Rule]", "a0"}], ",", 
        RowBox[{"\[Epsilon]", "\[Rule]", "\[Epsilon]0"}]}], "}"}]}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"k", ">", "a", ">", "0"}], ",", 
        RowBox[{"\[Epsilon]", ">", "0"}]}], "}"}]}]}], "]"}]}], ";", 
  RowBox[{"paJ", "[", 
   RowBox[{"k", ",", "a", ",", "\[Epsilon]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.739121419959199*^9, 3.7391215320963907`*^9}, {
   3.739123007310513*^9, 3.7391230234677677`*^9}, {3.7391231953001013`*^9, 
   3.7391231956953697`*^9}, 3.739138487752946*^9, {3.739139407045414*^9, 
   3.739139416257662*^9}},
 CellLabel->
  "In[384]:=",ExpressionUUID->"f4fc37ab-96dd-4337-b0f7-f0b9d3396897"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"Log", "[", "a", "]"}]}], "+", 
          RowBox[{"Log", "[", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[Epsilon]", "2"]}], "]"}]}], ")"}], "2"], 
       RowBox[{"8", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[Epsilon]", "2"]}], "]"}]}]]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["k", "2"]}], ")"}]}], 
   RowBox[{"2", " ", "a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "k"}], ")"}], " ", 
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]], " ", 
    SqrtBox[
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[Epsilon]", "2"]}], "]"}]]}]]}]], "Output",
 CellChangeTimes->{{3.739139409498474*^9, 3.7391394172701063`*^9}, {
   3.739192936917716*^9, 3.739192962848771*^9}, 3.739202036507399*^9, 
   3.73920611537376*^9, 3.7392103781382113`*^9, 3.739211775224484*^9, {
   3.7392118258375473`*^9, 3.739211843730637*^9}, 3.739215741794918*^9, 
   3.739215866194395*^9, 3.739219136924465*^9, {3.739275766527623*^9, 
   3.739275784255516*^9}, 3.739278694699909*^9, 3.7393078952208548`*^9, 
   3.73950352716702*^9, 3.740335463444343*^9, 3.7420692222965918`*^9, 
   3.742070876134223*^9, 3.7938434496458178`*^9},
 CellLabel->
  "Out[384]=",ExpressionUUID->"2fd3799c-6291-4a24-89bf-748073becdac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Jgood", "[", 
    RowBox[{"k_", ",", "\[Alpha]_", ",", "\[Epsilon]_"}], "]"}], ":=", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"paJ", "[", 
      RowBox[{"k", ",", "a", ",", "\[Epsilon]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", 
       RowBox[{"amax", "[", 
        RowBox[{"\[Alpha]", ",", "\[Epsilon]"}], "]"}]}], "}"}]}], "]"}]}], 
  ";", " ", 
  RowBox[{"Jgood", "[", 
   RowBox[{"2", ",", "0.01", ",", "0.2"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7392157883880568`*^9, 3.739215822336482*^9}, {
  3.7392158565722637`*^9, 3.7392158598889236`*^9}},
 CellLabel->
  "In[385]:=",ExpressionUUID->"1e0e03f0-b7fa-4e25-8de2-f36e62dc7a3b"],

Cell[BoxData["2.5632124514197465`"], "Output",
 CellChangeTimes->{{3.73921580926721*^9, 3.739215866341187*^9}, 
   3.739219137193831*^9, {3.739275771841943*^9, 3.7392757882083063`*^9}, 
   3.739278694868786*^9, 3.7393078953667383`*^9, 3.739503527319066*^9, 
   3.7403354635411463`*^9, 3.742069222396899*^9, 3.7420708762390633`*^9, 
   3.7938434496845427`*^9},
 CellLabel->
  "Out[385]=",ExpressionUUID->"72eabb73-4950-4112-8010-c204c9a94e0d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"JgoodMin", "[", 
   RowBox[{"\[Alpha]_", ",", "\[Epsilon]_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"amaxVal", "=", 
       RowBox[{"amax", "[", 
        RowBox[{"\[Alpha]", ",", "\[Epsilon]"}], "]"}]}], ",", "JminVal", ",",
       "ks"}], "}"}], ",", 
    RowBox[{
     RowBox[{"JminVal", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"FindMinimum", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Jgood", "[", 
             RowBox[{"k", ",", "\[Alpha]", ",", "\[Epsilon]"}], "]"}], ",", 
            RowBox[{"k", ">", 
             RowBox[{"amax", "[", 
              RowBox[{"\[Alpha]", ",", "\[Epsilon]"}], "]"}]}]}], "}"}], ",", 
          
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{
             RowBox[{"amax", "[", 
              RowBox[{"\[Alpha]", ",", "\[Epsilon]"}], "]"}], "+", "0.2"}]}], 
           "}"}]}], "]"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Alpha]", "\[Rule]", "0.01"}], ",", 
          RowBox[{"\[Epsilon]", "\[Rule]", "0.5"}]}], "}"}]}], "//", 
       "Quiet"}]}], ";", 
     RowBox[{"{", 
      RowBox[{"ks", "=", 
       RowBox[{"k", "/.", 
        RowBox[{"JminVal", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ";", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"JminVal", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "ks"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.739199220387438*^9, 3.739199345089718*^9}, 
   3.739199602259028*^9, 3.73919988464865*^9, {3.739199943949811*^9, 
   3.7391999783967533`*^9}, {3.73920001577783*^9, 3.739200044898354*^9}, {
   3.739200103914358*^9, 3.739200183238235*^9}, {3.739200319651376*^9, 
   3.739200362774575*^9}, 3.739200554717085*^9, 3.739202003507814*^9, {
   3.7392039866939297`*^9, 3.7392039908877163`*^9}, {3.7392040327991734`*^9, 
   3.739204051783864*^9}, {3.739211799225919*^9, 3.739211821949027*^9}, {
   3.739219085478425*^9, 3.739219089182456*^9}, 3.739219121387692*^9, {
   3.739275760240391*^9, 3.739275763505617*^9}, {3.7392757967353373`*^9, 
   3.739275963627677*^9}},
 CellLabel->
  "In[386]:=",ExpressionUUID->"31fd05f3-d84b-4a5e-8c3c-80e6ba12a1d5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JgoodMin", "[", 
  RowBox[{"0.01", ",", "0.5"}], "]"}]], "Input",
 CellChangeTimes->{{3.7392759658340197`*^9, 3.739275976543972*^9}},
 CellLabel->
  "In[387]:=",ExpressionUUID->"a747ecc0-dcf2-4527-a210-8472c42affad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.6569746482609657`", ",", "3.073853501113732`"}], "}"}]], "Output",\

 CellChangeTimes->{3.739275977717226*^9, 3.7392761945007877`*^9, 
  3.739278695926499*^9, 3.7393078962407084`*^9, 3.739503528305488*^9, 
  3.740335464880663*^9, 3.742069223517057*^9, 3.7420708771927013`*^9, 
  3.793843451280792*^9},
 CellLabel->
  "Out[387]=",ExpressionUUID->"91ffe297-5f75-48d9-96a7-42db1c962ca8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Jmin", ",", "kstar"}], "}"}], "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"JgoodMin", "[", 
       RowBox[{"0.01", ",", "\[Epsilon]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Epsilon]", ",", "0.1", ",", "1", ",", "0.1"}], "}"}]}], 
     "]"}], "\[Transpose]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.739199497068375*^9, 3.739199500282064*^9}, {
   3.739200190016305*^9, 3.739200259642041*^9}, {3.73920037375559*^9, 
   3.739200376430328*^9}, {3.739200597685083*^9, 3.739200655135434*^9}, 
   3.73920201220356*^9, 3.7392024176968813`*^9, {3.7392024590960503`*^9, 
   3.7392024622094927`*^9}, {3.7392191089058657`*^9, 3.739219110568302*^9}, {
   3.739276012446786*^9, 3.739276017379673*^9}, {3.739276047411603*^9, 
   3.739276074748369*^9}},
 CellLabel->
  "In[388]:=",ExpressionUUID->"7efad79a-0207-4f13-84ed-f2b34767a93a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"p1", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Jmin", ",", "kstar"}], "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"DataRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0.1", ",", "1"}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "plot", " ", "exact", " ", "minimized", " ", "Jgood", " ", "and", " ", 
    "kstar", "   ", "optimized", " ", "over", " ", 
    RowBox[{"(", 
     RowBox[{"0", ",", "amax"}], ")"}]}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.7392002655205097`*^9, 3.739200294192971*^9}, 
   3.739200387770562*^9, {3.739200860218761*^9, 3.739200877089676*^9}, {
   3.739200958680522*^9, 3.739200959159862*^9}, 3.73920151791039*^9, {
   3.739206654283023*^9, 3.739206729013896*^9}, 3.739276105504608*^9, {
   3.739276140657462*^9, 3.739276187934256*^9}, {3.739278517367878*^9, 
   3.7392785288885202`*^9}},
 CellLabel->
  "In[389]:=",ExpressionUUID->"45b49e6d-f66f-40e9-bc10-27467a1f5492"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQPWsmCOy0Z5i01fW/FrMDhH8Sg5/L2tUUlMTsYAwG
lzH4s7XKte+fgKm/icHfwfhkk0UaiwMDGDzA4N9YvuRNtSMr1LzHGPxAFvU8
tyg2hzQweIbB15D/sNJ+GbsD2LqZLzH4v99yzYgQ43Q4AwZvMPjcR7P6zeZw
OfwHg/cY/HNSlodddXgcAAAsh8E=
       "]]}, 
     {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQPWsmCOy05/O8tqijmNkBwj+JwS+Q7rli84XZwRgM
LmPwZR1q2zmfsUDV38Tg+8eJv9qeyebAAAYPMPi3j8o1OkzngJr3GIO/Ouqz
t3Ust0MaGDzD4N+XSvOf28nnALZu5ksM/jXD/RMqvgk4nAGDNxj8u9IRpp6b
hRz+g8F7DD6P25Wz2wpEHABp5YvL
       "]]}}, {
     {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6]}, 
     {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6]}}, {
     {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6]}, 
     {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6]}, {}, {}, {}}, {
     {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6]}, 
     {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6]}, {}, {}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.08125000000000024, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0.08125000000000024, 0.9999999999999999}, {
    0, 5.110072341996339}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.7392762281778927`*^9, 3.7392783400693274`*^9, 
  3.739278529879883*^9, 3.7392787048047*^9, 3.739307905295107*^9, 
  3.739503539694264*^9, 3.740335474199449*^9, 3.742069233051478*^9, 
  3.742070884505451*^9, 3.7938434666979523`*^9},
 CellLabel->
  "Out[389]=",ExpressionUUID->"a1c148ea-1586-446e-a772-9cd3c3e92fae"]
}, Open  ]],

Cell["\<\
Perturbative calculation  (dimensional version; simple enough not to scale)\
\>", "Text",
 CellChangeTimes->{{3.707347555181609*^9, 3.707347582594514*^9}, {
  3.7077445651667347`*^9, 3.707744674574999*^9}, {3.707765307804101*^9, 
  3.707765329640802*^9}, {3.708968298464109*^9, 3.7089683022062263`*^9}, {
  3.7386989228912697`*^9, 3.738698932160952*^9}, {3.7387164395996857`*^9, 
  3.7387164408451357`*^9}, {3.73871864203189*^9, 3.738718653515542*^9}, {
  3.739201679986412*^9, 3.7392016861099663`*^9}, {3.7392065292249203`*^9, 
  3.739206543638369*^9}, {3.739276212188179*^9, 3.7392762135629396`*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"960364dc-d5d0-497f-a5be-cf0935dd0a10"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Beta]star", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], 
     FractionBox["1", "k00"], 
     RowBox[{"(", 
      FractionBox[
       RowBox[{
        SubscriptBox["\[PartialD]", 
         RowBox[{"a", ",", "a", ",", "k"}]], "J"}], 
       RowBox[{
        SubscriptBox["\[PartialD]", 
         RowBox[{"k", ",", "k"}]], "J"}]], ")"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "\[Rule]", "k00"}], ",", 
      RowBox[{"a", "\[Rule]", "1"}]}], "}"}]}], "//", "Simplify", " ", 
   RowBox[{"(*", " ", 
    RowBox[{"perturbation", " ", "formula"}], " ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.708253411533321*^9, 3.7082534165561*^9}, {
   3.7091399709160633`*^9, 3.709139972300145*^9}, {3.738698934574401*^9, 
   3.7386989350647173`*^9}, 3.738716004287339*^9, {3.738716255167042*^9, 
   3.738716256306963*^9}, {3.7387164227326527`*^9, 3.7387164316364813`*^9}, {
   3.738725982212183*^9, 3.738725982409729*^9}, {3.739135047858982*^9, 
   3.739135067261046*^9}, 3.739206606798169*^9},
 CellLabel->
  "In[390]:=",ExpressionUUID->"2e5b3a31-397f-40ca-aecc-428328ae046f"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.708375648475461*^9, 3.709139973626647*^9, 3.7386102493602467`*^9, 
   3.738682948179926*^9, 3.7386833187488747`*^9, 3.738684511149064*^9, 
   3.738688158637257*^9, {3.738688370280818*^9, 3.738688389860882*^9}, 
   3.738688468378973*^9, 3.738688712325425*^9, 3.7386912863981657`*^9, 
   3.738692326185429*^9, 3.738696542420084*^9, {3.7386989369652042`*^9, 
   3.738698954587243*^9}, 3.738716005345553*^9, 3.738716225813404*^9, 
   3.738716258364544*^9, 3.7387163240303926`*^9, {3.738716415065222*^9, 
   3.738716432409885*^9}, 3.738718359833108*^9, 3.738725985525338*^9, 
   3.73901899064174*^9, {3.7390251722626343`*^9, 3.739025193624876*^9}, 
   3.7390259205174513`*^9, 3.739029510249161*^9, 3.739036258902232*^9, 
   3.739052264954535*^9, 3.739052393349751*^9, 3.739123244257277*^9, {
   3.739135056636244*^9, 3.7391350677722063`*^9}, {3.739135729842231*^9, 
   3.739135731530897*^9}, 3.739136458226911*^9, {3.739192934913424*^9, 
   3.739192960248612*^9}, 3.7392020609471903`*^9, 3.739206136189087*^9, 
   3.73920660920643*^9, 3.739206736360362*^9, 3.739210401087771*^9, {
   3.73921183531208*^9, 3.7392118593930597`*^9}, 3.739215756843507*^9, 
   3.739215881791202*^9, 3.739219151621737*^9, 3.7392769568607407`*^9, 
   3.73927870492542*^9, 3.7393079054622803`*^9, 3.739503539875803*^9, 
   3.740335474275607*^9, 3.742069233168453*^9, 3.742070884581017*^9, 
   3.793843466715818*^9},
 CellLabel->
  "Out[390]=",ExpressionUUID->"094af5ed-a1d4-4ea7-ac5c-c333d4dcd06d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"kpert", "=", 
    RowBox[{"k00", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"\[Beta]star", " ", 
        SuperscriptBox["\[Epsilon]", "2"]}]}], ")"}]}]}], ";"}], "    ", 
  RowBox[{"(*", " ", 
   RowBox[{"perturbative", " ", "result"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.7387183668106956`*^9, 3.7387183853168707`*^9}, {
   3.739135080041766*^9, 3.7391350831603394`*^9}, 3.739192883145208*^9, {
   3.739206625245225*^9, 3.739206637184805*^9}, {3.73927690602353*^9, 
   3.7392769114817963`*^9}, {3.7392769533666487`*^9, 3.739276954092107*^9}},
 CellLabel->
  "In[391]:=",ExpressionUUID->"1ca59dfe-066d-457a-b249-a12a5604f4f8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Epsilon]max", "=", 
  RowBox[{"\[Epsilon]", "/.", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"amax", "[", 
       RowBox[{"0.01", ",", "\[Epsilon]"}], "]"}], "==", "kpert"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Epsilon]", ",", "0.7"}], "}"}]}], "]"}], "  ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "max", " ", "allowed", " ", "\[Epsilon]", " ", "for", " ", "pert", " ", 
     "soln"}], " ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.73927738339005*^9, 3.739277393973926*^9}},
 CellLabel->
  "In[392]:=",ExpressionUUID->"bbabafe4-edc1-4cfa-8cc8-ccbe7dd14fc4"],

Cell[BoxData["0.7364085183709558`"], "Output",
 CellChangeTimes->{3.739277397808469*^9, 3.73927870509131*^9, 
  3.739307905600522*^9, 3.739503540069417*^9, 3.740335474405044*^9, 
  3.7420692332987967`*^9, 3.742070884712813*^9, 3.79384346675408*^9},
 CellLabel->
  "Out[392]=",ExpressionUUID->"3e815f4e-4bd3-4ef4-a2b2-d3496381dcdd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"amax", "[", 
    RowBox[{"0.01", ",", "\[Epsilon]max"}], "]"}], ",", 
   RowBox[{"JgoodMin", "[", 
    RowBox[{"0.01", ",", "\[Epsilon]max"}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.7395436620640574`*^9, 3.739543675090062*^9}, {
  3.739543747037092*^9, 3.739543753547327*^9}},
 CellLabel->
  "In[393]:=",ExpressionUUID->"e9d14b4e-377d-49c4-a3cd-0a74ea17b583"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.7234355560287313`", ",", 
   RowBox[{"{", 
    RowBox[{"3.0199661635831587`", ",", "3.9692678597038187`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.739543675574065*^9, 3.739543755316618*^9, 
  3.7403354752450314`*^9, 3.742069234134181*^9, 3.742070885463533*^9, 
  3.7938434682821836`*^9},
 CellLabel->
  "Out[393]=",ExpressionUUID->"5a0068be-a45d-470e-ab5b-aba0b9de915a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p0", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"amax", "[", 
       RowBox[{"0.01", ",", "\[Epsilon]"}], "]"}], ",", "kpert"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Epsilon]", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"GridLines", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "\[Epsilon]max", "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}]}]}], "]"}], " "}]], "Input",
 CellChangeTimes->{{3.739199707130183*^9, 3.739199711412396*^9}, {
   3.739199751274165*^9, 3.7391997681457243`*^9}, {3.7392007824089108`*^9, 
   3.739200783180263*^9}, {3.7392025370919228`*^9, 3.739202547983446*^9}, 
   3.739206099136484*^9, {3.739277252216567*^9, 3.7392772531188726`*^9}, 
   3.739277284791657*^9, {3.739277328110401*^9, 3.739277339496771*^9}, 
   3.739277619484908*^9, {3.739278330728613*^9, 3.739278331756549*^9}, {
   3.739503586890667*^9, 3.739503607185711*^9}},
 CellLabel->
  "In[394]:=",ExpressionUUID->"db8ab008-36ce-4608-aee3-03f98f5036b3"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVjms0lAkYgGcGi9QwPtHQVMIiKotEqvctNjWU43akLVlRonLdWpVtx7pV
bpVqconcWjm55HK0dDnDTptrGha7QsxOg+EbDSZsZtsfz3nO8+8xDAz3DKZR
KJSDX/jf7GBx98txn92B42arKBQpKDvpRwwzbWFfkulpCU0KNvnc3BqmM3Tr
LNkOqEjBtaPvSR7TGw7xPurXakjBN0j+7CYzCEJOczeE60nh3dZkpzRmDLAK
3HUXt0ihYLV70jVmAozlm7464S8FjlqN6VVmFlTbn6MnP5fCYb8HldKZYqhc
WCuh3Z4BDQXnqMu6SiD/2EHnB30EE49pcfP1WtDv4XM522VwodMBuLNPobHK
svGz0Szo1TKGqNQXYDcx27ZabQ7qR53au3byoOAw2rBV54EXmmfgJ2mBipdW
kvfqcpj7epfm47OvgN5AT7emfQLaQrmWgUkriKcc7q7RWwA7RUC9V0U7mK6J
lhdvWIT2BNtO/qYuUGS/ux5psQTrMycXyqbfwPbmpLtU739hUj481Gv1FrQo
cf424Z+heKKxlZ4ugNBT41UqZctAZz0khcIe8PMyEHSMKSD1dN3JAuM/YdLr
jcqNZArOY7kw5EofcPLFr8SWVIyxbqnVbe6HAYsR1sfXVByuaLnebfgXMKT1
dRPnabgU2pNjfvFv2CXLpocbKaHFHtXlk42DcMyM96KEr4QuhYanqvWGgN18
oHA6VhkvsI5vfH90GJ5M54X5G6mgpcRHo+/gCNTXZDs6takgoSlVa1kcAUP+
8CX85StUfpFTaZT7HozutVFSrVQxzLZxQN11FB5q6JTLplSx/EBgwfP5UZBl
xssOl6nh3KS+lujOGJQ8ymhg+6ljnZeLUpazECaej/G3MVfglf2J+bUiIVw2
iZzd17ECDd+x+4sS/wHexexbKT9p4I7tCVlMaxF0tad9yISVeHRd1wJVIIK6
UuMY69mVONeaNhrB+QC9YTOimIZVyFX2j/E0FoMsjaupEkFHYqiukNYiBqdv
Xu83N9ZElTiOt0PkODgzZAYlHzSRUuZfOao9AedP8Xlq7loYlV2Zps370vZr
PbqqtfCZRYoa49wk2H/vS3mkzUAGO8oyni6BElQYDp5h4ODmN4LYJglkNGkb
RXUysOo+GAv9p8AnYEuCu7k2Hqu0Y7CWp4AWOJK0IV4bf058wBl8NA02bt7G
ZqPa+FjMyqG7kaDUEJMR5khgSl5iwNAhEn5wHfBZ2ElgkOeUSYUHCa7yJZ3k
3QSubWqqOuhLgjo7Mq5wD4HXMr7jpwaS8O2IYL7fhcAQu3szK2JJiHd2vOrs
TeDGBJ39qqUkpMe16eueJXDZ/vKqvl9JCL5Bmy08R+DA1Njb0nISqopKf98a
QWCmb82xfdUkeHZZeB6IJlCxyTM6sYkE20ah5uVYAge7M+4rCUjok4oMRhIJ
bEiSnxD0ktD6tOXimWQCsxyPmxf1k+BLEXd/SiHQtWRL7d4hEtx2z4UwUgn8
7ceO15xxEpItRQ57bxJ4Z/O2DA8JCcdTy4903iIwcjTX25AkoXeyMPrIbQLN
3M4Mv5z98idnpUdxCVSm9hRnyknob8/NWL5H4EidY2jAIglmMqer13IIbAot
2mr1mYRaCuOSbh6Bd9drzCkUJLikUoML7xP4HzukS/Y=
       "]]},
     Annotation[#, "Charting`Private`Tag$138640#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Hk41OsXAHD5kqGyjW4hubKkGnMlW9s9700lS/a1mGi02GKK0qZkiVAq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       "]]},
     Annotation[#, "Charting`Private`Tag$138640#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 1.0000000490241168`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{{0.7364085183709558}, {}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {1.0000000490241168`, 4.904916361064415}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.739277340500061*^9, {3.739277621048224*^9, 3.7392776317042837`*^9}, 
   3.739278334129788*^9, 3.7392787052736387`*^9, 3.7393079057730207`*^9, 
   3.7395035403079*^9, {3.739503587818268*^9, 3.739503608104281*^9}, 
   3.740335475555908*^9, 3.742069234455781*^9, 3.742070885690918*^9, 
   3.793843468344551*^9},
 CellLabel->
  "Out[394]=",ExpressionUUID->"4e73c34e-6792-4ad6-bfad-3c47c45ea67e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Jpert", "[", "\[Epsilon]0_", "]"}], ":=", 
  RowBox[{"Jgood", "[", 
   RowBox[{
    RowBox[{"kpert", "/.", 
     RowBox[{"\[Epsilon]", "\[Rule]", "\[Epsilon]0"}]}], ",", "0.01", ",", 
    "\[Epsilon]0"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Jpert", "[", "0.2", "]"}]}], "Input",
 CellChangeTimes->{{3.739277103034608*^9, 3.739277109066144*^9}, {
  3.739277165805294*^9, 3.739277181805744*^9}},
 CellLabel->
  "In[395]:=",ExpressionUUID->"63523638-d53b-444d-aaac-d0b4bcf8f125"],

Cell[BoxData["2.4231059564050237`"], "Output",
 CellChangeTimes->{{3.7392771826044703`*^9, 3.739277187940145*^9}, 
   3.73927870540373*^9, 3.739307905841017*^9, 3.739503540453577*^9, 
   3.740335475596781*^9, 3.7420692345543327`*^9, 3.742070885728339*^9, 
   3.7938434683604193`*^9},
 CellLabel->
  "Out[396]=",ExpressionUUID->"b76c5ea2-d7ea-48fa-aa63-e4bba4f9f0df"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p3", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Jpert", "[", "\[Epsilon]", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Epsilon]", ",", "0.01", ",", "\[Epsilon]max"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Dashed"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.739278497983872*^9, 3.7392785026484833`*^9}, 
   3.739278602609213*^9},
 CellLabel->
  "In[397]:=",ExpressionUUID->"10fe4c64-ca5f-4092-8ae2-99482c423fbd"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
      Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwV1nk4VV0XAHC6hnuvMYqXIoQkU5OiWJvXUIpIxqjIEL2hkDmFQmSep9AN
STKHJsWnkGSIkiHTPTKHyhC+ff84z3l+f5x91l5r7fVscVvX0/abmJiYlvDD
eBvs59Ie8Q2B9r5V1l2iJORd8MC4dDYEtOx2HpbEzhFRtQ20uw2ZJHtvcexF
dsfAbQZ3QFDpwM7t2Gl9dTXG4mFA+vVTnA+7wcjsvXhSGCxNfG3gwZ5unO6e
pYaDoXmPJxc2KhVejFgMB7IZ7yYKNv22h0LDuwiwVb9cz4TNu0pVizsaCdpa
s93rIiSk4pZz4kJpJJw2DFn6ix1p+fHS37R7oGM4aL+MXdVm59XMEwVvlGil
f7AHtVZvp4REQd6cF8dv7H2KMg8OuETD57njP+axz9JelW4aiQZb6+NXfmK/
jZS9ML4nBnRFjTZmsaeY37hUZcfANpNw/WnsW0c5r4t8iwFSZBVlClvAyywg
ZGssGATMdE5gw9R0xOm7scAd4h83jt0lrRJf0xALzPHtdwjsSzYhaWIbsSBr
oBhOx15Lb8sJVYmDaMXE1DHsuG7hRzPuceBUsql6FHvXZocSk+I4aDruNTqC
/eJE6bMX43HQ5zkvyvBYnW7jXet44PFfeTmE7bsa1/ozOR6sre5IMMytPNBl
3hEPUgMCid+xH7jt7nvNmQAyesVbGT782GNEWjcBpDp1aYPYrWOvJ+7dSgCm
2lHEsK0Yx/zi8wSQDw2ZHMD+bWm6fPZ3AozXS9MYjkjMYapXSgTWlWZnhsU+
TbHLXk4EiQo3YLiCepgn9mEiJAQISjB8XDtYYGkwEUyGX/ExPBD4UeS8cBKI
ujpsZti9Vkiq8UwS6JdyiTJM/mUnJx+dBGyHKg4znKFYsj+hKQmEoi1sGN7r
vKq6SkqGtWNryQw30nQ0bdWT4dtiVh/DloOxx5u8kyFvp7oiYz+zQv2GSuXJ
MOHQG81wyBkZ8+TpZBg1dF9nWCja/fz6rhRI8iD7MfJT3PTKwd42BXLtU1kZ
+dRkobp8yEgBi2qpLIZ71E089/ekQDPzE61hRr27JARCBFJBYZSJwqhPh/Nc
VZdJKqjsftvP8CemV2ZSiangrTX3llHfj0kRS55dqWBYereaUf8Pchapjfxp
4DET84rRH01vpVUFjdPAsmW5i9E/DTNv/Krb06DRQmo/o9/ehkRvp2xOh/Ga
z76T2K+FrV9aGKZD38XZDkZ/1uosra98TIe8TKsKRj+XZCkEqX3IgEbRzUcZ
56H4wF+JKI5MeKWyzraE/bi5qX5ALxOK3hsOM85T3m871ptNmSDpJNm8xsi/
QXrY28Ys4FzyPsfGOO+jl3bzs90H89mQIjJ2sq9y80Xt+6BeN0/lwI7La+dg
bbgPW/bPLzHOv9ZG8LsHF7JB29UjVRj73+YJwZM3syHgxh1nEWzNRKNLi/ez
oT9s7oQYNuzZQdEezIbC6VGQxlY1q9WjW+fAYN/uqX3YKhLi6VEBOXDDUhwp
Yx+eDp1UzsyBFAUPmgr2wWCTyNC+HFi3kM1C2EpP51plzuZC3JWPJqewFX3N
RNt9c8H/WJKcMbaC9isXn7RcWIiu4jfD3vMtgqf5ay50rK/znceWZt9ldNn8
ARx4/vCzK7bIeeuuJyY0MKrfcE7Avv48a6uaOw1al/cupmB/FPxu+iGGBiYP
syMysW9+sv060UKDREf5sTzsUY1LA7s0HwJnFuXfWuwiSffxHIU8sLqc/WgE
m/VWxe69J/PAdOCawA/sc/2/nOuc8kDoZkDsDGM+JnlPD9DywOu2atkytjv7
jflt2/Lh8j6DLN4dOF8TYX8T2QuglrtcTAM7XqdZTUqqADI45t10sadyOQIr
NAsg1dyhTR8762wUc2dAAXzUmKmyxGZujWfjXSyAUi4vJU/s90+zeO9+fwTc
vidbi7DNPCskb9Q8hp9aMk+kxUhIJvnaL+/ux1AlxZ2ugL1SrdTovvAYQq1S
kpSxM/4WOTrJF0HrndQqHezvwQ8Lz+QUwUCtVJoj9qW4JKU94U9APd5p7jG2
71Pvo1/Mn4L8DrkedXESOtGuzNXp+RRObAT5HMPevrDY3xr3FKRn/Hefxn6t
fDWw/sNTKFy0KLPH3jR4wMZMrARmH1c73sPWcZCnaSaUQGYL1WYQu81DVFbI
vxT4ZxSi7kngft0+sPQpohTe0VK+pWKfach8F5ZeCtV2PCp52L38IvZLtaVA
M5GUfI09VrYtu2e5FAZ9Z2p/Yq/O/SOQ5FUG+keEJy124vl9hX8Tv3s5vLj7
yFRZkoQC7cm9nM6VcK2/9+IOaRKaMTkoXu1dCcvnTLMUsM/p2F66GFoJZRe6
6WrY6rte/K6hVYJ23WiOFfb6uCu/42AlcPJo1KVh+//Xc/LNmSr4e182S2gX
Cfm45732hGcwEnrtu7gM7odbWg8HttTA/oW1e1ayJPSK3HG6QbIGxLgn+t2w
yTHnmQoP1ECJm436beyMLN+znmdqQOZ/C0rF2A3PSzZzJtSA3FBZH9MeEtry
e/sNFf5a+GnNf+oRdoXzL9OEzc+BLHcjl00e3weM88h63C9hriNObEER/8/5
05N43zpgkbwk5a5MQpJvfttdPfkWCvTs7a6o4Xk4rziert0AEw9+0Jh0SEhU
lc/noEgj+Of19/wxIKG5L3XMYZPvwGUwq+axOY7XOMh011ATqEbzjxy1w/Nv
eKr6YGUL2HbFCbC5Yes7EzElraCzpUaCCMD15q3gepjbBlvCHCYKI0lI2aNT
LKHmE8zsu7bkk47vI/rdYv6V7eDt8eFyWREJeZY9yU/P7oDW5IWloZcklB0S
lWBzvxOETbq2v24noXtBJmvBqV1Q28ppEk4nIT2On1P9QZ8h8wqn7/ZVPD+Z
kzQHAruB2HpP7SUfC+oP4tkh8F8PCCwqNPDJsqBPiq5ehcZfQIzw5ZbXZEGO
el8Ojhl8hZnue4UvrFlQ2+xWPzOVXrBusSvv8GZBvZuspd0OfYNfhOj9Z8ks
KF/jrv6YUh9Y1NGh4BkL0uKIXI0V6oeIttzDc90s6LZmMs/Y1gEwCv0zHbnC
gpJZvApdmQdBqODAkWsirMh5/ugb0/FBYE0uZNXRYEVz0mw7rl39Dhe/NT/l
cmZFW4S/ZJ+hfwfNRLmOv7GsiNJQbEK1HwJBe59Cr9esyLF8tvXstyF4GX+3
eucUK8qr3hly9tQw6AY6npITZkNVHlZXFFqHIaG0rvOrARtSvL4hlKk5AoTf
N4PhIDbko5C/PPBmBAZ+3Xr3+RUbov3VEGxTH4VrhWWlE2ts6DCv7pJl+Sgk
2IwGn1FjR5m9hpy1e8fgo1O9gnMYO7o80TBSkT8Gz120jwV1s6NNocJhwY/G
gHPiyOq7HnaUstNN7vTjMQizGLfg/sqOGq22ec4Wj8Fn4WnRzG/sSKztKpts
1RicUJMcf/udHXWXi+6+3zAGpfTwO0qT7EgzwNslfGgMHvr7HslkIiNhXrll
6210oA4VV29VIKPI1/oTxiJ0yF0N0C5TJKN1F9dvx3fQ4b384HbDvWQ03Fr2
8uBOOhxxulIdfYCMCiNUgrj20EH+6AnmHUfISJVdl+OlKh3yI6PWbx4jI8t1
G5HtlnRoCFUGVzsy+vAkmJvPig56ZqTsow5kpG79cIP9HB0mJy27OC6RkcSL
8aEFGzpUe/p8fHqZjCZ8XPNanOiQXu5UzO1ORr6//BX9fOgQeLOkXD6IjNKm
kjV6U+jw38ohOalc/L32u5ziNDrsb5TpEaCR0aPM38zBGThe2fVf1DwyqjYw
ebsnmw4qCQvlK4/IqKeE79+AfDq4gbracikZbfG8pyVWRYdnDQlFfm/JKKP1
BW3xGR24C5QtUxvIaKf0FEtTDR3YtWRkaxvJaF+P3v+uvqTDyoNUB9YWMjJS
IevUN9Ch7dd6X30nGUWtBek6dNLBeNzPaWaMjARMy/JVP9NhKljHWHucjDKL
h9h5eugQlBhunz1BRkXn0ftnvXT443fH9OIsGbW8WTtGGaZDqsnzTtFlMiLf
8dYrmqNDOZPR7C0uCooZyC+8OU+HG3aCydK8FPTPoR6qySLOt94XjnY+Cto1
frBl7Q8dAl4t0w/9Q0E6egsnTm3QQXNf9nWjnRQUzO2iP89FQOipptCvqhT0
34Kf9BoPAbEHe2L11CnozJfwDXY+Aip7ZLwaNShIOvdhqYgAAZQrW9W+H6Og
5oP9W4+LEjA8lJabZ0ZB5cKTM8ZiBPwYqDX3OUtBGRtL785JEOAt9EHT8jwF
XWna4ushTYBCWX/XMUcK4rU+OXBfgQAj5/6SH14UtKxh+axQiYDddmzp6v4U
NCx9KaZyHwFPLvNN5t3E688Fa7YoE9DXviZfGU5BpiHP836rE9BluOvLSAYF
gVNTILMGAaaFf47M5lCQjEGPOee/BNyS/lkrkI/XF1ygSugSUCcgJ1ZXiuN7
LOuqf4oA2n2/T8XvKeh2zOFj5kYEpLPRXnz4SEEunjriF40J+NzYwSX4Ga8P
tp3eZgTYGp5XUBvG60u6FQVbEJC9aWllxw+8H8qN21FnCVBKa0Bqczj+jtRD
tPMExJvc2ay6QUEtz/J5n9oQkFg7HyrJTkUVGZU/ai4ScGzmRch5Hiq67dCe
3uZIQNGGIQ9djIpcTgx69DoREOdQtVlLlopMlab1xy4T0P1Mhe2fA1Qks0Jm
WnUlIGYlaLPlcSraPCjwlfUaAaesX/JMnqGilXrJMl4PApDthp6KDRUNF+yL
2HadAP8pp+YLLlTUcg/ZSXsTkMbfZBTij+O5ZqC215eAi6tLtW0RVJRhZiVw
1J+AoJVyF78MHN9R51mdGwTIpymXtxfj+MS93xvdJGD5pJ3ooXoqMmO7k2MV
hPeTJVF+uJeKqgXPTnwKJuA7/w8eyjQV/R+qNeX1
       "]]},
     Annotation[#, "Charting`Private`Tag$139000#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 2.389583717287578},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.01, 0.7364085183709558}, {2.389583717287578, 
   3.3657399409298563`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.739277681208867*^9, 3.739278413861095*^9, 
  3.739278505415681*^9, 3.739278607675658*^9, 3.739278709409416*^9, 
  3.73930790981105*^9, 3.739503545166154*^9, 3.740335479448247*^9, 
  3.742069238458543*^9, 3.7420708893338137`*^9, 3.79384347035037*^9},
 CellLabel->
  "Out[397]=",ExpressionUUID->"26ab5077-1d61-4719-bb89-7a5fa868af88"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"JpertExtra", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Jpert", "[", "\[Epsilon]", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Epsilon]", ",", 
        RowBox[{"\[Epsilon]max", "-", 
         SuperscriptBox["10", 
          RowBox[{"-", "3"}]]}], ",", "\[Epsilon]max", ",", 
        SuperscriptBox["10", 
         RowBox[{"-", "5"}]]}], "}"}]}], "]"}], "//", "Quiet"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.739544247274086*^9, 3.739544420412773*^9}, {
  3.740335628552537*^9, 3.740335630435933*^9}},
 CellLabel->
  "In[398]:=",ExpressionUUID->"e8d4d2e8-9d3a-4304-9002-5fbc36d3ba60"],

Cell[BoxData[
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"kpert", ",", 
     RowBox[{"{", 
      RowBox[{"\[Epsilon]", ",", "0", ",", "\[Epsilon]max"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Dashed"}], "}"}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "\[Epsilon]max", "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.739201756097291*^9, 3.739201763907995*^9}, {
   3.739201861067704*^9, 3.739201867313242*^9}, 3.739202019466172*^9, {
   3.7392041803766737`*^9, 3.739204209992321*^9}, {3.739276976753565*^9, 
   3.739276978356244*^9}, {3.73927711603813*^9, 3.7392771181106043`*^9}, 
   3.739277473340261*^9, {3.739277771843059*^9, 3.7392777741373987`*^9}, {
   3.739278254190668*^9, 3.7392782792444353`*^9}, {3.739278441046857*^9, 
   3.739278444958899*^9}, {3.739278550990782*^9, 3.7392785604303217`*^9}},
 CellLabel->
  "In[399]:=",ExpressionUUID->"1215d6bc-4389-49e3-981f-909f600aa680"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p2", ",", "p1", ",", "p3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.739200716727742*^9, 3.7392007489317837`*^9}, {
   3.7392007915771837`*^9, 3.739200831636273*^9}, {3.739200883473585*^9, 
   3.739200977678441*^9}, {3.73920111762849*^9, 3.739201118527075*^9}, {
   3.739201234070861*^9, 3.739201261785595*^9}, {3.739201737906929*^9, 
   3.739201739156754*^9}, 3.73921911691784*^9, 3.739276112576886*^9, {
   3.7392783140536127`*^9, 3.739278315333433*^9}, {3.739278378363398*^9, 
   3.739278391017899*^9}, {3.7392784553228903`*^9, 3.739278462642935*^9}},
 CellLabel->
  "In[400]:=",ExpressionUUID->"bd86c3a1-8744-4a59-b2fc-da9789e18c77"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
       Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwV0nk01VsbB/D4mfmV6S1zGkRKg3N15OLZqasrnc4xlKKDSLgZjqEkboZk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        "]]},
      Annotation[#, 
       "Charting`Private`Tag$153310#1"]& ]}, {}}, {{}, {{{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
       1.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQPWsmCOy0Z5i01fW/FrMDhH8Sg5/L2tUUlMTsYAwG
lzH4s7XKte+fgKm/icHfwfhkk0UaiwMDGDzA4N9YvuRNtSMr1LzHGPxAFvU8
tyg2hzQweIbB15D/sNJ+GbsD2LqZLzH4v99yzYgQ43Q4AwZvMPjcR7P6zeZw
OfwHg/cY/HNSlodddXgcAAAsh8E=
        "]]}, 
      {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
       1.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQPWsmCOy05/O8tqijmNkBwj+JwS+Q7rli84XZwRgM
LmPwZR1q2zmfsUDV38Tg+8eJv9qeyebAAAYPMPi3j8o1OkzngJr3GIO/Ouqz
t3Ust0MaGDzD4N+XSvOf28nnALZu5ksM/jXD/RMqvgk4nAGDNxj8u9IRpp6b
hRz+g8F7DD6P25Wz2wpEHABp5YvL
        "]]}}, {
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
       1.6]}, 
      {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
       1.6]}}, {
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
       1.6]}, 
      {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
       1.6]}, {}, {}, {}}, {
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
       1.6]}, 
      {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
       1.6]}, {}, {}, {}}}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwV1nk4VV0XAHC6hnuvMYqXIoQkU5OiWJvXUIpIxqjIEL2hkDmFQmSep9AN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        "]]},
      Annotation[#, "Charting`Private`Tag$139000#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 2.4142135623730954`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{{0.7364085183709558}, {}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.739200914974262*^9, 3.739200978406546*^9}, 
   3.739201119625442*^9, {3.7392012421539907`*^9, 3.739201262416582*^9}, 
   3.7392018886450567`*^9, 3.739202064465392*^9, 3.739204218904196*^9, 
   3.739206139361514*^9, 3.739210404397585*^9, {3.7392118368723097`*^9, 
   3.7392118610331173`*^9}, 3.7392157585797977`*^9, 3.739215883593998*^9, 
   3.739219153692103*^9, 3.739278463968617*^9, 3.739278563914304*^9, 
   3.739278613341408*^9, 3.7392787096859922`*^9, 3.739307909973155*^9, 
   3.739503545570394*^9, 3.740335481705864*^9, 3.7420692404718647`*^9, 
   3.7420708911487627`*^9, 3.793843471311347*^9},
 CellLabel->
  "Out[400]=",ExpressionUUID->"280b40da-39dd-4965-98e3-e69d2d12c9c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"paJ", "[", 
        RowBox[{
         RowBox[{"kstar", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", "a", ",", 
         RowBox[{"0.1", "i"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "0", ",", 
         RowBox[{"amax", "[", 
          RowBox[{"0.01", ",", 
           RowBox[{"0.1", "i"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "5"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}], "//", "Quiet"}]], "Input",\

 CellChangeTimes->{{3.739207534570385*^9, 3.739207635888357*^9}, {
   3.739207729524736*^9, 3.739207803835868*^9}, {3.739207838530656*^9, 
   3.739207842216202*^9}, {3.739207886680677*^9, 3.739207941573135*^9}, {
   3.7392079733128767`*^9, 3.739207978383051*^9}, 3.739219118230122*^9, {
   3.739277880396282*^9, 3.739277880938826*^9}, 3.739277931372656*^9, {
   3.739278658614831*^9, 3.7392786844892597`*^9}},
 CellLabel->
  "In[401]:=",ExpressionUUID->"ae7c2a9f-66f8-4572-a22c-2a8001c0c2f6"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV13k8VG8XAHDbyDJmxkyp0B6pbClS5BwRpSJZW5RKSSlbJFFRtCNL9n1J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        "]]},
      Annotation[#, "Charting`Private`Tag$153363#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV13c81d8fB3Dca9973asSpaJUREYK0df73bIqkVKhRMiqZJUthZKUyCjK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        "]]},
      Annotation[#, "Charting`Private`Tag$153417#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVl3k4lO8XxpmsM2OGQsgeipSiJMl5LEVZs+/ZFZW9FEmllJAQX0tkzVoR
KpR9a8a+73vKliVLiN/7+2uuz/Vc88x5z7nv+7wjZOuq54CjoaHZoaWh+f/n
qlarl9qGt+JNXvEjznoT4nud+yOkDxmAN3m80TigWsE9QCOF4ZA9tKxUHvao
8jnXTxHf8pS/CUEWfp7Mz3rPJRPoshfFvOCwzUgDatuvaHTC0+jt8Tvwe5+3
LO2FC4p443Gclbw/WP2JfHmq0lnxyrdMY3zKA3gxx5VJXAhSPHN5NG9KLBA6
Tu1efmaRrMg+uZ+uMucJ/CjlXDkRXqS4cEvHLOH4M+Cu7Jktq6pXbGAO+nC7
6DkoG9aICbX1KKYkfGPQlw+D8PJc2318PxS/7fc9FnMlHGIKu9DmhRXFI2PR
fXQpL8F9b0QNzfiu4n/ZBYEekxHQz8bBkSzLDPRezVKjYlFAGyRamHl8H3ic
m+nXuvYKZi9mTDkp88IoA8OT0pxokD0i6TEhKwJarUInxBdiQC2jVOnOCUko
iT03GH08Fnx9Tx7iPCMDh+xMg+g84+DjqPLI9fwzECXpLe1RFA/nImNWzYcQ
0K6FD42sJ8B9LvnfrQ3n4WZ57lMt+UTQrfDs5yjVgIGnDTKlfknwlG89vN35
MoiIe7hGXXkDOrLxbG9eG0I/C815Ck0yjMnzfh4KMoOXy6E8uJRk4NvYqV3m
swb1ngOLciopoPso6aeMox3slGbVuk6mQLHgnX3iYk5Q+OZ0fMbjVLCQZK8w
d3IBl8e1bkNiaaDIffziO243EHbWv8DekAYsQiqnBxs9oFd77IDGtXRQMrnL
td7gDS9kXJce4DNglf/T04IDd+AC17+6zzkZYK57diC/zg+2t4MTfmu+BZuU
iR0lpwD4OMblIbbwFs50h/e3xD8EwZyTfFHHs8Aw32EnICkIul9ULX9vywKC
sDdPq0cwhHrpNtB6ZsNWFwMb9/1QUDUdfi3HngP/nueoCtuFw+a5656uRTnw
U+tc8j7RCPggvKmeYZQLpyX90hFDFDgxPuUfWs8Fk9eNuf6M0dDZmtp4Sf4d
fPx4SEvzRhwEF51IejDwDmSzjUR1OhJAKa7c67Pfe7APLD170SIJevLnyZFX
PkCiqjJd3fUUkE4rvHvswweQGJSDW9OpEBbtO9VIkw9fy7TGv3ilg6ovcylN
Sj7g1PdGdNZnQtKNVtGE5Xzo1yg6jw/Lhs0rMeGnVQrgTXRId7hTLuSrijre
nCyAK/sTRJ5JfAB+khLboFghcMZEnxQPKwTtAdsz4F8IBQddTm/2FYF/ZqBN
SlchbOip/HI78QmGlRvyrwYWQbH1iXDFPSWQeFtHb3WsGM6w3jVL46qAZlX3
uyZnPsEyx5dr6XMVsMMWmVIa/gkqrj6oOV9XCVa53csP4DN4TeQtyARXA/+Y
ZSTp9Rc4d0r7hYJ+PWi/u1/q/ucLbBpY6xfrNYC/b/JEp0YJ4EL0io2MG2GY
Y0omfrMEDtTf46hwpUDipeudh0zK4MMfygbdQAvwFd7lUNpXDrfj7YtEazpB
80HCuTTncvg3fKBL/GoX+Gl/c2CsKoceh/IUVlI33PxDM+AoVwGFn1o9DK/0
QHOY6pGj0xXApkEk23P2Q1g1hfJFtQpy/H5OdlJGgHS0n9ixWwMJPvBWk+YH
WE9w2iQdroV1uagXUlY/ID9Wv8jlci0oq4qGqZT9AAOGJku61Fpwipx7v+Az
DfEj5e9OXaiDBe/M7ImVn3A4Il33v5B68P/g+ZdhfhaU192iLLm/A4dS7bGH
M4sQlZf3U1z5O9xZ2HEQ5F6CKbsZhTXn76A9e3MgVW0JnrbaTYWVfQcfF7YB
w7QlaMkykq24QgElUhCtmsUyWFgo9ApnUMFEsMPap3YFblUy8v6UbgFGYUbX
fbfXwKlt8cW0WQs8K3oZ8ylpDUzG+vZMP2wBhgDNrMMNa3CGNnd2qr0Fgktm
Ul251sFfMHPI/UwrfOXzDg0sXgdla808175WaJi1+OHxcwMaRqI0XbjbYWqc
psdAaAsqnJ4xuBxtByot9/555S348vtehbNSO7i8UfG6aL8F2buOJ52vtYOV
tI6YdsYWhAic4b32pR3o5KXUHx/aBp0rQ7OOph1g0vJa7Q3/P+geFn1uG9sJ
rgK8aTEjOxDI536S/X0nGBtO8w1t7cAJi7KhWmzu3/bg6gf370JIn95x8cVO
2CIOKhB0dkGl837X7wtdIOFxS0S8ZBc+NPYJ3PvTBckBop4NSjTIikm08Ri+
Gx7Y2c3WadEggpqbx6hAN3BQP6+lmtIgxxqGWhWNbijXMZTfdKNBvOUyzviU
bkiYZCnhSaRBzwpDC2N0egCS2I+rLdMg2ZVey4sOPSDvbWB4bpsGTZ4QYdy6
2wMfd7lJ7Ay0CL0vMbXK6AEJy/46O25atJY1vSPyrwfuSvCeC1ekRbZJShcL
snvBZGKf2rlHtIh1OGTZrqIXyOS7aVrPadFX3t54ju5eiKOYTaBIWsQVd3PB
h7YPOPbcT2pNoUUtUfGRYNIHpIg1rdgKWqQQvDpEpe8HjTqTr0trtKjug9E0
gacf/Bb4HXu2adHlnk+Ll471w5b/cls6DoccRe7uaTTqh7/uo57/WHAo/NvO
4dq3/WD17N61+IM4xDN1RZqurB+WRMQ+fj+MQ+mEyrMqrf0Q4WRRNXEUh0pM
HmlXbvSDvGNBQcdpHJpYZvT6enEAVoo2bN9dwqGb3NfubVsOQLk/wUZKB4c2
4PuTsx4DYHasUCxeH4eIoSGxX+IGYOLRpWcyFjgke4itvGh2AMi3NyRdruNQ
hZZHw5/dAeh8a/XrvBsOaXh1tMmwD8LYssYNohcOWVe+msxXGITCIw2XLH1x
KNicB/8udBC6+gzb2Z7hEPtD333zyYPwJMdaSTsEh5IyB3kliwcB8r28br/A
ocLVRKns4UGIrShMDX+FQ0MvDhpmSA2BEtul0LE3OHS1ONBqSmUI5pRaHwWl
4tDy4JSTiMkQvLA1kT2QgUMMEpl3UwKGwN5g+CIxB4eO10i+SWwbApcHY/5c
hVh/ZkKzhqaGQG/saLZUMQ6dZ/tdwLs5BBrTDIGnPuOQmVV+bZzwMAyeGS5h
KcOhycC9LX2yw2AQYak/+hWHXHM8e7k0hiGUzYUtpRyHAjdOzUZ7DkNxG5fX
ShUOkQRi/nQFYdzgov+oBodiz2/8Y08YBs7m/CZcHQ69iyhhjawZhhhaY8a2
BhyS+3KAp713GLLOR9AIfsehqhG/g2zzwxCr68N0hYJDPZIg+4JjBEYvNxXn
NeEQJ379WMCRERCUGU7raMYho+l3h9yVRmC3StF2ugWHomscBW2NR2BOuWvv
r1Yc6k7m59a/MQKKxtb9vW3Y9+93s6k+GgHG+luDxe04ZGgRhj8VOwKfFYMU
HnXgUNSZC3vE3o/AE45ePsVOHOrk3NnirB2BeI6g1GmM2f8U/WEcGIGhC88W
73fhkH7bjfmNxREwLcs+xNiNQxd79q547RkFefswl3sY/6q96XqDNAqa/XnD
4xg/Lfw+68A9ClQF09TTPTh0OFXsqpXIKNTv+TTgi3HDy4eTRlKjkNNfnfUe
46sBw9Y68qOg6Kcn1YExk6v8kNr5UfgUTgj7gXGmZbQp0h0F7rAb078wVtdc
7pIzH4WsOKrFEMbT8tp6JxxH4a67HrkS4yfi2c3i7qPAeHFH4BXGYlwMGsJ+
o/C9NO29KcZ1DLb1PEGjUFvwe5iEsePqV5V9EaOwfdmquRCrn2GSu4LwehRK
fqgmamCc0e6tQJeJcQ/1ZgfWjwuVbZ+3C0ZhX8yfK5oY/3h/9NTq11HofvXi
ZTHWvyeJz/LnG0bB+cyFg3sxFgudOvqjYxQi2l+dvIL138H5tVjPL6z+aD79
ZmxedKZ/U1r+jIJ2pU/iIjbPNDVDgYbdUVjqK5iiw3hShIXrC8cYdO+VGt+D
6SFw37WofMExeDMj37lAxSERXC1r9pEx2Dz45SwV05P9iB9zvBJ2nlo7btWI
3d/c+zhScww6kmos2TE9ppWdxIUYj4GBz/7aMkyvE7Fzm343xoC+vqLpRzUO
2RpYzFnFjoH/pbXFFMwPOJXPV43TxuDx4ei/y6U4lHKCfUrn/RgYPYBO2RIc
GiNRh1DtGBxnsXKNw/xm3Xi2RXhpDNZldZQ63+EQzecYjQPbY0A4PTNSm4tD
bzJW6vcxjsNtSD6Sm41Do49yKuj4xuGpaNNJY8zfVxQPFPxQH4cFj/F58dfY
fFRs13L0x4HrqJ9QSxyWb+pZ8u5W4xDIFS3j/B8O+eudrt7yHAfrMV79h5E4
lOCo38mahN0/Ps9xDsuj3rDna/Kr46BwW3di0QP7vch2eRqaCRjsrZ7dccX0
8x/3/Vr8BMxmEpXobuDQWspbRl3BCWD+nHd41RGHOD5VczloTMBJSaTsYYZD
eiNb8i+SJ4AmhmNgFrA8mVS+b5A7AfJINMRHAYdsfj2r5v40AfgYtc5/cjjk
trJfM406AYl/424vn8ChF4wnLb+sT0AmH4PIEyzvqVLX709oTYJmQZenEz2W
VwGD1ac3J2FB8q5ZWA22X+4c+6xCNwUTU1r6cdi+kfYIyNUhTQFfk3Jlchkt
4rcXeeUkPAXel3mkUguxfad23THm0hSoez1/755GizLI20zrcVNQsr0ypYbt
O4akA9rFZ39AvKoLTgLbh3VfzXpP3psGzdYpT2IODZpre9/jKjsD+naaTxuz
diBvrLLPqHIOhBzon4/xbYPN89huV/gNKo8yWx/l/4UhepErE38X4VG9tqiY
3Dr0Vpt2Tiosw43H7byrnKsgOr+pSB+/AvDYs1Lg3zJcn9jJ+Lb8BwRaX/No
Ci9BgLENq7bMGjTfuzXLK/4bpmWlXLfD1uFjGpulu+gcHIgybwno2IDOxxur
F1N/QYrFioiIzCak59SIiMpNw8Hl+dvWIVvQ+CwvNY9vCtzp1agezduwNyr2
apjVBOwNJHCmHdmBWblzTBcx3QYEHLPJcd+F0Qdnp7QujsIfkf7OdBMaNP+v
001KYBgul7d70mPvEQcmbO6UVQzAq//u7mt9S4s4mZ4fmGjog4eHeo9KGONQ
Vwx9JdNED8zxTtfp7tmDZKNm6D0UuuHc5XTr8dQ96JPmm86moU44fZbbe48e
HXLHb1RdDOkALnuF4Bd/6FBkyxz/G+92uLXCyv8zkh4ZKOl6Jz5qg3ty8ZKt
iAGJ5DioSb9uBZeyzrMHxxkQ7azD6aKaFtC7s107PMmAhBz+q+j41gJysiK6
cdMYgwFx7XML0H3wtGebZ0BI5+LP83ktkJi6N3R3nQH5rMUl7I1ugdZg3eEB
FkY0Z/RN+8rVFpA1pQZEnWFE4v2pQxXkFsCtVdfSv2REezxDTz241gyTrgtb
EZGM6Gu6GfuIfTPU/eKSFoxmREy393Eh62YIHrqRKB/PiJw6+kIIxs2wt3b/
bdd0RiQ8tyLUoNoMwlEuh/u+MCLvxZb3PYLNoCS973nuOCOyEzdF2gNNEHDT
Vlf/JBOacTIRDzFtgu28oM8dskxos9LwTo1hE/jM5woanGFC4ynRlbuXm8Dt
+vqigSITOlGaJn//UhNccQ55aaTOhPUjoCn5bBMoOha3m1owoazC4Jve/E3w
zxJvaB3IhE6tLScZ/aCCz2upr6NPmFCAdu/i/DgV/gwaiNo8Y0KBAhbyT0eo
MGeetGoTxoRKt15/qu2lwqDpyWi7/5jQ0/wZS3sKFcoMrXocc5nQrbElr+P5
VLirVWB6o5MJKYoyzNPdpwLVrmr3YA8Tkti/OfnFlwoCd9vT+/uYkPwnM1sP
HyrUZCwvqY0wofK9JQvz7lQg0cgEC88wocPJjcZkByqkFnws6dllQgpuURVb
Gth9+4sOKB9hRscMJen9eanAf6y2cuMoM3rWLuqTxk0Fd9Uup/fHmdHGnNL9
Zk4qcLqvfuSVZUbe5y9pHmWjgvX3U5rriBmZda0uczBQYdWv2C/XiBmFJUjQ
Ry1SgH/80xDnQ2bUJyqurd5AgetF36WSApkRT6zgDUIdBUqeDj04FMSMsqSo
39qqKWAktUdMLoQZ9ejJ/HMqp8ALP+2bptHM6IG/+VZJMQVo9k/txGczo19z
Sblb6RSY0NgrKNTBjITp7Jvnn1BAWkDUI6uLGa08ONfH9ZgCAcuna070MiNJ
vKu02iMK8MZaXlUeYkaZixMdefcpYPAj84PdNDMqfjH0O8WHAnUBoJSxxYzI
IHf3qAsFMouu2x4RwaM+exUqRY8CTVecl3+J4dFjdd/PqpcpsMx89WGmOB5V
GcsWVOpQ4KyVXYqoFB6lPNvurNekQDOD2biAPB6pabAy0atRYNVYzZZdF4+2
vZ98VFWgAA/u/HK7Hh6dfG+usStPAcVc5YcvDfEosSaO5dsZCjylUUwhmeMR
qVKAW/00Vn/WyXEmR+xctehRmDQFlDeFbP/54pGbyaTbD3EKOKUJLJf649Fk
zmzy5GEKhGjzPbz7AI/sPPz5pw9RoCuFK2X9CR6dCTu6568oBa5qkMeXXuKR
8jpLia4wBUJXiR4fovCo63LuE3chChQk4XGuMXi0Wy6YHy1Ige0VeuG5BOz5
n7OIL/Bj80nYtvnxFo8OFMb9bDtAgcILm0tp2Xh0Sc5lmgPj3sX1B3Z5eLQl
9Z+xFQ8FhM+vJI8W4JEwn2T0NhcF1H4vnkgqwqMTTwqu6WF8PXah0vIzVp9F
5+fc/RQonv811v8VjyTr7DpvclJgIGbaPbYCj8yjDmR0c2B6UJ6iNanGIy7j
PTvKGF+MHhXqasCjQisZDXF2Cgwq9ti0dGD92qbNlNxLgfh3LQcfdOPRfvoz
zKVsFDDjb5iS7sOjscmDg1oY9/z7fC16GI8ab2+PBbBSIPpG/hH1MTwiuLvw
CGFsMJQ1/3cCj1TGwltqyRRoL4tzt/yFR/hbiqW8GL+UjJQhz2H9V/FabyZR
QDfh+WrFAh65/y4tfYwxiRj4yWMJj9T9NvFKGDf5+t0R+YNHA7k8P2kwDpn1
Otu9hkd1RBajWhYKXDK/8S/oLx5d3qo3DsOYmeJQfmYbj9aK1BbNMW6Qt3ow
u4NHrHZhwscwDso2UnlNS0B5vGlLdBhf4NGh16EjINOtaOtRIgXogtXqaRgJ
iEfI16MC4+q/8KyAmYCCapwl0jF+eE1Ow55IQPQKT56HYYz6jrNwkglomOnP
f34Y76qLt9SzEVDP+KihK8bfPgu9vMNOQOHV92sdMb53mEf/yH4CEllmnrXF
WOG/vRxD3AQ0SypvtMN4k5HQE8ZLQHICU/bXMP5ye08sEiAgjdiGck+Mfaa3
zJaFCMjBrWzoIcayxn9400QIaF6Qpyoa49W6uWHDQwT0sUzJ7T3GhbJTbxgl
COjyeuwsFWPPjCHbL5LYuXT46d8YS3N2i7hIEVDu8/+MObF+LD5u/sErTUC1
P47qKGP8frUus/kkAbH9axPyxPimQ7lzwGkCErvG0pGJsWTXJ0lpeQI6V+jq
OIFxdmHmh1dAQML0eGUnbF7XRJI91JQJyF0x8OUHjA9HxZ78q0pAHb1ZbTsY
p3sGf7a4REBSV75LZ2P6sJ94eJekRUB2rErmjJiehPV9FSp0CMig0ezRNYzf
SF+vOGhIQCHEijEFTI9XUuwfdhlj9X6oEniHMf9eS9UgMwIazeu+LvJ/PS9p
NcxcIaC66D8qgvswPdtcCE6wxc5rl7vSMeZqU9TUdiCgteWZJ8cxP0R/kGrN
d8b6sZ/JyBDzi6Hg4Qi7GwSkYmft9xtj9nBBAw43AnL04m4Pw/wW4crW6+NN
QPdCb/AOYX4MPbYyAgEEtPdVVupnzM/q5gta1Q8JqL33kYMr5nfc01+lFx4T
0G8hlgYJXgrcGhuJ0QomoATy63vv+ShgHUXVMY8iIPF3cmxLWJ7wVNZ/HY4m
oOyVCcUmLG8656uO2MYS0CWJJol3WB5dVPvCeC3x//1M0fQXwea5mV5+K5OA
vhr+FDHB8m1OLPnoZjYBMW6NfDDD8u+tfkL8vTys3js2PLYSWF7mRdwOLCCg
ndUT0fclKUBvfV8qooyApPW2U1ePY/lUa5KU14rVx8/Q2Iblb8SyPsuJDsw/
LcwHRbB81hLQ8S3sIiDz+u5E33MUqPI5b1zaj+mXbo1FHlEg54g0uXGSgN7i
1DRWz1PA/yXh/uQG5qfVTMdr2L6Q+8Yw77SF1d9Gx8pqQIGVGVrz2X8EZK9f
d6jMEMtf1Q3ZZRwRBdSMFouYUuDy+uTCLpGI2O0sJk9bU0DE8pvVASEiOuYu
IeLiSoEi6zR810Ei0rjUGxvtjvnbPrg4TIyIKnIYexs8sftcjEg4SSKSPnuS
ooTts9w7C19/yhKRmR235ZMHFDgZzc9XrElEpx4cnrJ+RYHaWLpGVx0ikv/2
1X07Btu/r2e8xPWIKPc9v0pSHObHtGJqgjERbdPGdW0mUaCsQNvvkS0RaWu/
y8DnUEC1xX9A14eIBssKEqOqsP3Sbh+E98XO2QMeZ9ZSwLH7kkzNPSK6F1Om
WIPt/6dDnM9PPyIi06JQ7X0tFKDOvpPnDyOi3Xsmy6yDWL4yjcTOphLRowNm
DJHrFHBQApMnLUQ0s1oytH2SCsu0hz+wtRMR4/XTL3rlqOBfxcr0upOIAkNp
UZkCFf5TGf/0sY+IBmL4G+JVqfD9/OP9YxNEJND4PLLMgArHLlG6z24Q0dUE
46tht6hQgi88Vr9JRJLTP3cW7lJBjZLwRO8fEUUKWiuZYO9b1po3Za/hWFBs
pMWG6lMqRGqzRUcTWZBy0Eufp3FU2NAzNlwSZEFejkedqiqoELgP5fkdZEEl
iWetP9ZSga3zMD2TGAuq7Lj1Pe87FSQMNwv5j7AgV7vnh8o7qWBp/Jpd8xQL
Svt9wd/wFxWqzCc6Mi6yoFcNoh0W7E0QYu+qZ+HBgliFxG8pejRBwYzeYL8X
C+IeqpIw82mCPjdZR9PbLOiXukBdgH8TiN37d8fIjwVVlPutLAQ3QcWr58m6
T1jQaGgZ7eW0Jiw/3y6qxrGgBNFM2bN9TWAlPhp2tAp7nmtmXEc0myHwfTVX
bg0LSk0W763Tb4acU29TJOpZ0M93HBOu5s2woXSz+BCVBbX/viEz49wMEWbb
Q0LdLCh+1UT+YXAz1D/nOso5w4LYPRXvG1Cb4fiCLmWHjYSyj+gGyZi3wFEN
gciP7CRUMdqVdcuhBSQy582u7ieh6yPVak2uLSBqGzzTxktCNAEWEUWBLcDT
Xc2cfoiEZkOXqm69x/5/fJNV1zhHQowyN1nc6FqB9gA9Kw0iIXKYicBpfCvs
3O7oKVQmId9wcRVm1lb4e8LNiV+dhH6z2fG3HGiFhfSsJ0t6JKSy8K96QqYV
ekJ5a2OuktCjhoG6C46t0DkzE6LpQkK3rBLDv19vhXa1Lwa0N0nI2nST3tyz
Fai0RpPOniS0z4jNISWgFSq8X+xR9CehdIrPweb4Vsi2xClPRpLQ1rMprcLO
VvA/+vPb8XISEmdeOZJxuQ1uq32R/lRJQlRvbe+bpm3gZhOcca6GhJxZtZ6d
t2kDm1eSYZcaSUjXZCpe0L0NVP+5Wdp3kJBikJRO2Ms2IDT93YqZJiEbomXk
1a42oJv+7so/Q0JM1fvKjg23wTZNwkTaHAnFKM+wMky3wcJJRUr+EgmlPNT7
9XOjDdoTHsZRtkjo83IOXyBfO/x3nXBml0xGX3LNuuSc2+Hlk8Hcx3vJ6LiT
94qYVzsEv8kTJHKQkS8n7zFx/3bw7dRh4uYhI593cVTniHawUojqkRYhoz3b
Osk/S9tBlMh3y1GOjNoENIdo9nVAQc6xj03WZLQorktr39EByTvFhkl2ZPSy
4ZN681gHhF+GDTdHMtp1kGWyWOyAm+s659ivk1GGqXPDBEsniKu415vdxuqJ
ZPmYf6kT3vR/HJgOJSPzDd7uL5ROeHFUwf9LOBlt51a8jxnsBP+AGsHnkWT0
5/eSe/J8J5iLdTkciyWjfxJvDp1l7QJOj7XfXmlkVHnnmnqscReEMp+hw5WS
kYXJ5oe4313gZ1GZ0fGVjDrH+ZuC9nSD8/uLF9MryChc1vNU7v5uUDc0C1Ov
I6P0A9YXE1E30CX7cr1oI6OWuVk29Kob7sp9k+T9SUYh5LYB7Us9cO35hZb5
GTKS6KJrErDtAZPhZvfyeTJSL8tqPH23B2QDR4ptV8ho3HI2USmnB5ZaaJSy
dshox8hQZ4S1F9xe1rh/pWFF0W8X6QlHemG6hElFDMeK3thU/gk63wvdLC+n
1ulYkcZ67kFf317QPt1VbM3AiizmbbT+RPdCrTX300ZGVmTAT/uopqAXFIIt
TaWZsfuEq3Tmm3uh8GOyRDyeFSnP6Ki7zfbC/wAnLsNi
        "]]},
      Annotation[#, "Charting`Private`Tag$153471#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV13k8VG8XAPAZZcyMKUsiSSqyZavs4TzJlpBdQkmJLCWEbKlQshQRIYRU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        "]]},
      Annotation[#, "Charting`Private`Tag$153525#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV13c8ld8fAHDXeO5NpGT7RkukEpJK3M9RSGQmIXtkpGSLCBmFjBJCsjeJ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        "]]},
      Annotation[#, "Charting`Private`Tag$153579#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV13c8le8bB3BnIRkhiooUSVaEzHPdSoVEi6Q0zBAhSviWlFVCkpmyMjKy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        "]]},
      Annotation[#, "Charting`Private`Tag$153633#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwt13c8Ve8fAHCue0uUUaKsMpKI7H3P56BUkpVQpESk7IQo2UREkb1FRjIz
svd2bdkr4167hITf/b5ev/PHOa/36zzP5znj83yec7ge2mg/wlBQUNCTd/8d
2VooOYyWHyMU/9/uImV3c8ZU4Puo1przOaKILnb/9csxXXgT8oDTJ6pcXGc+
4b3JmBnUNDG4d+QoS/UOrbHpjTnC4R6RvhgaD5kPWlGTmmO+4PNIYpcu1F7u
V9By7c2xj2BcOb541eW0gkosyymZsAgw9Dksc+WLgEJkpqIV941I4F8P9BLi
l1dAmsJZtkqiYNEy5dnho3cV/CkQy8SwWAgmRlzM0n6vMEz3uCbgRhxIjqVt
hGwlKAhxvGd+jokHvWrJjwTzLAV3wfKn90vj4UIo3bo3e7FCj+xc9XXbBBi+
7+UmIFKncJyXmjb6RCIQjRoqvU27FBQE4yTpbRJh5oON/JbWD4VHYmIPvFsT
oTnthqQx36xCsGxTwM65JNA0HxMszVhVKEYNi6w9ksA3PvT+5Q/bCpNX1ydm
RpPgR94QyXgYg6fR8KW5I5MMyfReflwxR/HiumySnR+Swf22teOQ80m84b3c
+8qryXDRUOGa4sIZvK/plYAS1RTgV3yctfLiPP7r0+FCobQU2H4d65HOLoof
sreZSKZMhTnJXq3fJTJ4jAuW5tS9VNDRk/3wrlARL+gRJRFUkgrGj2+M2PBd
x+v4C9/HMH2CjdDy+NclWni3d3VvnGw+AY3EkNFMkz4+/aN+4VLrJ3jF/W30
QMwYT4hbHjfmS4O7KQKW9oXm+L+pnkcGPdKARzyp66asLZ4nm0VCbSwNdnFx
2+H0jnhqCYVaezQdzEJiTFfeueGXvj/QjEpJh2LOF+WPsT54grLPeNWhz4Bf
DI3PKnyLL2zLsJyz+Axqwuf2Jp0/4CNvdf492vEZCi6w1whDNP7VyIa/uEgG
pEQ/SpMMS8I/NGFhufshA9ridSjbzdPxKiT5T+5/MiDqScuNB7s5eIFnD8TT
72QCL9tI2k+TQjz9rndNR3kmNKxOqj/NK8P/9szQ+H0mC4KCnNu1jWvwQzSd
Y6xeWSAfpHXDx7sRX/5+46niXBZk5r+0zzjcgU9iZflrfj0b+t9EsEcm9OB9
k+X9g7OzgZAezlzRPIh/IvCAuYj+CxDjsjdO4Mfx6vneqSP2X6D+tMeQK88M
XlwuQwwz8AWsWiN6as4s4E/VdlTzy+YAk+C9T8HXVvD/rm+oa8TmQICWKXvE
ygZ+spt57PlBDtg47onphW3hG+7IP419+BXoWP2lphT38JlT93dqG77C5dqO
n6UnMUiTRG2dA1MucFkNeUhcPYSUOffRUKvkwpGvH7VU79Ai2eVzWjFOuTDx
8kfYrzIGJJ5iJ1I4Ixc6W3UOkcyYkJDLtJM1w7mwVZ1kNdp+CvH05zh/+2ge
WC9cdgk+xok4tF+yXsDngZbCkeGn57kRMwalIlebPDDjIE3xjp9D7ujo/KNL
ygNlBceCLWUBRC3STDm5Jw92Oqw03j2/hCCjzgGS2HyQS9sRGWoRQ0TOBnY3
S+ZDdNlK0KixFMJtGnfK0Dwfeh+tTDNHyiFMn7/eX43MB6kjUh4Z3oAcWqpJ
82zNB+nHhV+fJykh25f6lk/+ywdsb4709PYVhPhsTiJDqABw3OrCR4avI6PF
264K9wvA/xfCHaivjnTu0tR1hRSA+NPoA7kGLaQaOGhMagtgfh87q1SvgxR4
XdL686sA6JOrDCSl9ZG0JsXIN+cKgSL+aVCAkCESSaszwa5XCP53sF2Khg+Q
AA0zvlz/QjgnQWGVtfkQefnB2Uq5rBBeS35L+Lr8CLEeDCgcIJF9Bdt+XtMC
ecAWt2vBUQRNnIIZEgJWiPb9r0p76kWw8DKhR6jBFrmSUvMmxL0IOEXYhW6h
zxCZ+V4CT34RPLGzZH5I74gICM6xFM8Uga6OOwuLwguE3WbbSPXkN9jMKvnK
1/0SoSugSRtT+QYcR3SG+K3cEYot9mVb529wctjdDp/viWzIXZLAZn4DwiQj
5QTig8y6KbpGjHwDpfTpY/Ws/shg7a1agWPFsJeRl6uvHoi0HjI7UokUAz9b
oEL7dDBSruqsqWVbDCa8kwP0dqFITnBAxGxSMbjKcz+LzvqAJPbEjjv1FkOy
H/f9Vb6PiHkjD2ctZQmsueqe0CyJRITLMu8dFSmBvV/zPhZBMcjmF9E4XaMS
uPMs31gzOx4pTyoZTXxbAuOMx/qajiUhXuHATiorgX7bizss68mI6ptGA8nF
EuAs++s5QfUJYXx1M+Y1SylEnRKZEFRNR4Zs+4ZbrpSCzHAv3+3mDCTB1ICV
yaEU9nRZnmK8shEz/ek7RsmloJGSeEn49VdESM0i6jOhFIqVIt6cNM5DfsPa
0MZ+KVx0K7/Vx1+AfBd3OoUXKgNah3CF0dNFiOf5fT0/gzLo53uUaiFdjDDS
Hx1kKymDJJrm9lOHypEhzAdmszmyl+mEOysrkcQ/p3Vzmb5DpBkNR8yPasSc
mBj+V+k7eJsEb48+q0WEx8/3X7b7DqR3sYNeIvXIZncO07uE77DjLwC0xxuR
8gZJnR8d36EusaSGia0ZUf2i3GslUA4tJxxu7uW0I4xJrcdL9MtBTbSGtAxd
yFCYljbGrxwkbnR2KmO6kQT/oVC1onLoEr+/wO3eg5i9vN/9caYcWMWw356w
9SFCtnMMU4wV8J2Ly4F2oB/5bWKlKYhWQLxPiDxD/iDiecO1qyq2Alip7sHB
wAhyHTD0NG0VUCxbQB/CO44wiL9R19mpgMc2SpJP1CeRQT6G4PjzlcD74tpT
6aQpJJ41omPhdiVgf2tOMR6dQR7RcR4T966EC0Vhj6xCZpGLmE9qr/IrQXPe
mYpwaQ75vpjfxkhfBVfT1YhcjYuI55gsrSG+Cg4fF/V1qyYhqt3VqmlPq2CP
qkalcnQZYWy4GrAWVQWclLZaZnRryFBJZ4tccxWcd56svK24jiRk3z7i86cK
6EPTNmT9NxBxTetU8+PVsBpDtBCc/YX8Vd6cyUOroebTL6mBiT/IeEUJ1aBe
NUj0CPcdeGwjNdIvef5ZVwNzeALDKeQv4i9IZaISVw28E7s+gUf2EctPjZ5P
C6vhIZep5swxCtA4E5Ac0lYN079CXIf4KIH5BOP08E41AFDQuwVSwd+3fZQU
jDUgibu3MzqEhbFDkVzn+GvAv0ljy1b2EKT+5TS20a0BS49Z01/SR8DfYdo9
zKoGTnyJoRgYpIGnK58SS73J59PV3QaCj4LY9MVJqoIasHrVOYXyMADL25KG
wpYawCSnvfI/wwj/JC9nPZqsgck7EyJMF45DwxsDx6ZjteDgcYfnphkTZIrP
Gzjz1sK6hUqCaMxJCB6zV7wgXwvVxQGzzRPMoC8acDTwcS0M1CexlkSfBvzI
yQ3517WQHzG4aHecDbh9kgaXwmvhxLUS5+RYdiANlSSr19XCdput3hPSGSB4
XvY/+FELTS8GJ5qHzkLhRYJV7lotUNfLXPjcyAVu7vMyxznrYOXzSwfXeh4w
EXjGWSdRB20mBTaa/bxwrW+fyuFGHZy+M0VfsHEOGPmZu/qd68D2hUjo4dv8
8Kc7qdD3XR1kfb92YTP6Agy7CkVLp9WBOQ/nuvmqAKR2XX4U1VsHddZp+rsN
QuD/gqCqSqyD2Dc8chLXL4EVj6HILkU9KMtlPw+1FgEpp2e7hsL1UNvc0VjB
LgYtnMmhZ9/Uw8NuJctCoiTkNAs5dSfUA51MckDtlhS8ty819PxWD3fjP42V
0MuAYSPh/OxMPUzb+da0GcsBamt4LPxvPfBeYHNLjZWHc6wLG1cYG4DJKbx3
bEYBVqwOKtKRBiAp/K7ARAH0sgSm6N9uAMKdzRPjXiiU1DC/OWLZALyZvmsy
SorgcVJY52lUAwT3DgbU9SkBU4UhUfh3Ayy5TC2Y6anAjtlC1wRNIyg4cnnO
q12FcQaHohCuRpDiN1mVvXEN0k0D3TfUG4Gedkj4tokqvKVjMUt51AiTPlrh
Sa9ugG1J8g2dl41wbZ5hrzFJDeSOljF/y2iEeVoNYh61Bpz5duWfWXUjHDeK
i8LwaQL2QfcUy2AjtLLLevN1aEJHwUL2C2wTlJ0YZra/qA0PDFiU8febIKz5
1EcN8dvg8NPXY9ipCfpZqq4fZ9EFP5s/VU4hTeDB5H24EqMHOV79Cvk1TTBz
++vbzA19qD12xVVjuAk2F83T7m7dgf6IwtKljSbYO/ho24M1gH9ZH6TO8zaD
g7WYKEb+HjBIUT2vV2iGyJPKp0VNjYCn2r7A+HYzjO5KfTwZcR9U+7REYn2b
Ib86a8r1mDFE/qMXYFxshhPN23SM3SaQ7fv6cQ5lC3QAcvzfO1OoYlhNu8Ha
Avcvnp9q1HkEc7ydPL43WuBRjkCI35oZSNx8y7H7pQXS9+k2kxyewLXBXYPI
xhYIEUwucDB7CgbGT6MlJ1rASeA2+437luD5XJXFlqEVMgZa1uPMrIEQR834
074VrNqGUk4/toPZ884anoGtgM8MbZc/sIOtvPmgM6mtYBzEteQebQ+cjY00
d/tbwSVF6EjL2DOwXPHGdkm3QUJWvUJulCO4O/9WstRsg8zPsQdXdZzgA8bU
44hFG1xSH/fKP+EMZczK+8rRbaBjNjdrkPQCqIFyu+RfG/Rh77mG/H0J7C22
Uron2yHz0pT4zfFXcOnWpMMvoXbIstO6Ed3kBrrmVetC99th7egn7tTb7pD6
7hUpuaYdiKUMnkOGnlByevkCOtwO843+DrpzntCWYvh4bKMdJKzdqyifecFG
sfxPFt4OyMBp5TF99AbFyZ3xt74d4Bnrw5CA9QOkNiXKJ64DKkZPtv+M8wOF
1Js6boUdQH/U/9JNOX+QeZzUYjPdAerVyYGZL9+AyNq1Qm2kE9ztX1OM8L8F
4Z4N6xu3O0Hchn/HePQtXCyMvXDZshMaHz6QN/0QBPzOa/GS0Z3gwdI+TX30
HZyliHxz6k8nUL7/FvGWKRQ4pxUvMx7rggfdUlcnX4YCez1p/wgv2V4v7c/O
h8Ipf3DY1eoCdeFIarea90DPMG80/qULJHjZym8Hh8EBPRtrjxgBruFVBqqC
ImGfwtZJHSFAl148fGGJgn/r9X2t1wlgeszr73xKFPzttX5X94AA7NFfNu/V
RcOfiFpsUTABAj2FkW3OONj0Z3koGk0AntHnJv++x8HvF5ZVXz4RgML7gPm1
QTxsGDC7pJUTQM5whXAqOQFWzjxZjSASYHTqEe2580mwzFClxvSHAEsfjaK2
XifBEiVTZghlN9yuv0vPPZwExJkK0zenumFnwnwn4H0yzKUzDruodIMkkcoF
w5QKY5dK6+8ld0PvXmC4qGE6/GZwVyfkdAMp7oDzXn860GyoDCl97wanevq2
25qfQaqwj3S+rxsYQ8uTK25kQIjM2vENXA+YBBlcIuhngZLieWNfix544qcV
LNf1FfS5V4jbz3vgpBze1UU8F2yoihyeevZA75qvp4F7LsQ2KPlrxvTA3pr3
IRGOPNi8bvSVtaMHxinszt0yyYfP2uF7OSK9wP9IKnOHuwgqxQ39uPC9wKW9
rjrxugj6mXgYw673As5+RXlmrAgwg7m8Lx72Qo49Yq4W9w0MDNpvKIf1guOf
+uKOCyVAZ0oVPbjVC/jKSMdul+/w7LmdFEVVHwhS9lAzetVAgDV7ikxbHxTd
cv0cWFcDieZN9HaDfcB63I4hFVsLnXc4FqdW+6DTXJYh178WBJCWmLqz/bA9
rs6vGFkH04e4KP08+0Ela9Yyub8Bdg7arKqC+4GGPemL4NlGYNhxHN6K7gdu
xaVf+k8bASG1Fzwu6IeF3qWmRKomiO5yNlOd7YdRvJPrsnwzaEcS2o6pDIDg
hf2FvLZWsAh1lVHRHoAUjwrv6LNt4B7A98nNaADULE92Czi2Qc7Ll26rjgPA
qBB7RJmnHWiM+UW70wcgMzxV5bZPB9RccP8YdmQQJPMGr7yRIIDI90vGbB2D
IGutreas1wsKk1uBHkODMGzF2jju3wvXcNXf5mcGYdcvdymorBceaGgeLfw7
COHvrNYaOPsgdMa2WI1/CMQfullGE/tggzb/mJvXEChJqY1WvhuAIkOJsknZ
HxBnKUTBSD8McvsyJ9LShmGXR/71FGkSjE48e4IpGAYvFQbLCfop8OD/UmNU
NQwb7zN3KSSmoFmby5ZlaBioS1Wu5LycAt30Ix3+R0Zg/269VDb9NDzTHPZ9
ajkCMYYxlUcUZiA72fWviNgo2LPEFw9k/wSOq5VT3yvGoKiyx+nnFBHSVJpi
zmpOQqisZSVj3gZ0W4ilnCmbgtsp0juyO1uw+G5EZlZpBhr5lPN0zffgZSsq
EH9tBm4N+Di+dtkDOlwam776DHS5zBvFB+2BhIvtftudGZjm1NCtLNgDd1Nc
fYHtDETGtR33OdiDU7KXNLziZ6BvbbT4TPg+XJv2fMT9dwYobs9eOFNyAOkS
Au8f5M3CwXxYyPllClTFvDkqvHgWMvK5xjc3KdDZKLOk1opZ6Lx1yLp8nwLl
PkjOlWidhY/mMgpiDJRobAtbF/XMLIw57i1WiVGi742OHc1j+gmhmTU+Ro6U
6Ev/NR9K558gu/RO23uLEmX7Hhwk5Ua2z6s7mgeUaNnyxfCn3j+B0i2Wgukw
Bt3StkjtD/kJU7ldZzyZMag9x3RtRsZPEAqxl9mRwKDm+b0HWiM/YVHCr0LD
FoNqj357kYzMQXzOzz7/SQy6ztpkX3Z5DpLb6fl45jFoyJ3Bpz2qc/BsTYy2
aBmDdg5s3cPozYEKm1pA1V8Mqtoto/TQZg5iHksJ2TBRoUqNZTTciXPwSne9
UlqFChXNrYxJopwH3wyXRLMUKpSw0hlWengeDOuPYNc/U6HWQhNB3cfmwfhF
4qh9DhWanXnwmpJ1HkS0Hi0ZllKh/J9QU2OxeSiXcPJp7aRCz0bXXuQymQen
zjOVtNtUKIN3Y0Vi/TwsvGr4fOEyFs3U/xmu0ToPpIIVA91rWFRZCGu93zUP
+9q+ua5qWNRxQJHTcGQeTmeyK+XqYNFR/go3lo15kDS5da7GFItmdBRA8JkF
EGUb3fL0wqJKyT0s+HMLUCL5XU3Oj9zecX2VJLAA8VODusQALMpw9lLidakF
WFwpDZF4T45vn0mBu7kAv8zFG+0Syf1ZkmpcXRZgOrUyLeQ7uT+pKkrAfQEU
Z9Lp+yqx6PPqcbsfPguwVBxzjaEWi362YOeWDl0A6V5ZsWfNWJSuPMJzI30B
eHtaWGf6sOjIg2Bli/4F2NZcprZawqIOkl/YTo0sQC5900Nkldyepv1X4+QC
nL9S+4V6gzx+wZFU3qUFOEYvfNZ/ixwf54OdxCzCHZxfsRgGhzpkujboiiyC
j+b1JhlmHHraqbfAXWoRdAtXgjtO4dBKZcHkTIVF4CvrkrrLhkOPjA277V9b
hAxPHwmDszg0nl5OJs14Ecz79678u4BDlUdD+Qjmi8A5EGSleRGHLnxeZPpr
tQgj034hscI4VFwpav2myyLIebQPsIvj0GaH7czN94vAkv28uUIeh1opakad
iVqEC7jDl3rwOPQ43We/6wmLcDiw6cs44NB76XqmcVmLkDmTiZlUxqEbP75x
XKlfBEtD+mfeN3AoOzwPCdtchC5e1Ra9Ozi0hrbDrXJ3EfLem7mu3sWhZkO8
VguURKBwfeP12hCH5tn1XVegI8JzO4Y0//s4VCVVnGqWjwhYdoc0eIRDSbaB
68eEiGCqsOESbYZDQ/AzE9LiRJB4odG4bI5DRwbelwcCEfINLHtePcGhtkc2
novrE2E+5K3UZRscenLguuk9IyJwnUVlTGxxaFlykrafKRGEOLp6XOxwKE5B
69KILRECNTtnPjzDoZnUGRw4JyLkCaw9DHfAoZr9FEcvvSKCeqLm23fPcWi0
de6C5xsiFKgbrlo54VBUnnow+x0RPmQOiWo749Cfhx80DIST3SkpcukFDhVJ
ok8WSCZCioCRfa8LDm3otTboKSPCFkfDm4ZXONRUqp//QzURdtPxVI/ccCg2
Sv7PrUYiTHmgV/fJvmxEHdrfTYTEiGI8pzsOna22Nvo4SIR3qjFbqWR78/QL
6o0RwVJgIeCcBw6tX0hqHFoggiZHsRqTJzn+DeqwqBUiiK9+9/QkG5tjbXz3
NxEW7l5KIpKdytAvzPaXCF89h7LUvMj580z+38gBEXKa3NM+kz3dn9QSiyNB
Ys2vsH2yPWWoI+7RkiBM6sBF3RuHcsdYm3IykiDv+DPDSLJr9/pEJ5hJQPuA
Cz9KNvmz8iCBnQSOyPhZVh8ciqlLan/ATQL7kde02mQnn6OO5uInAeOTcQpv
spX8rc2nhUiwytqHzSV7mtgnkSJOAgkmPNsA2Z435TGmsiSIs9i6+ods7tyk
Ll4gQSjTTDCDLznfjlPH/bxMApmlqV+8ZD94bv0kTZUEWXGDLuJkUwz1SZtr
koA1NeO8AtmJcvI4fl0SMCnCPkI2GpfUs2BAgmIHD8x/5ycPDidmGJPg6J+7
Mv/1d39obfXEnAR3BEtS/ot/tqFPTtCKBN7cftf+G7/6vDz1kj0Jnr8pFvjv
+h4EJPVnO5PgXZqc+n/XT7F8OMXKjQRCWlTF/91fooa1rbA3Cc4TcRY+ZKP5
ffjVNyR4rCPzWIfsSSZ52tx3JHBYDi3hINvdKWnINpwEF3xpjabIz/fs8OE0
0RgSqBkkGCaQXaVg/WwjkQSGdNdL9Mg2SuhDC9JIoBCPe05D9j6lPJ1DNon8
X9r7sZj8PpGmwxmbxSRo0Eo+TUn2+AVrx28VJAiOTvOMI+eH29s+Zac6EjTK
1D6QILtSK2l8u5MEhw7deqtFzjejwsPZpX0kSJ/pmxok5+M+s/ULl2ESUJn5
leuTjYzKMf37SYKC6RRG1dfk+EjSVDmJBGbKPGFl5Px2Szr89dU6CTYO72ed
I7vCrO/6wT/y/QXsZpFe4lDDFjmWaswSZL6Vj1Uh+59g0qw79RI8sWEUi3XF
oQrrVq8xTEtAkKszkibPr3LXw0U4wSXQY1YTFibPz8cDaZGKouT2NM4CNx1x
6AlRlZevpJeA1VoVa0aez0/mvJU3lZdAm6PwkQ95/p/SwvTMGi5Bi7OvnSu5
ftRnJRWdNVkCKffWJQtrHGpzSDHK0GIJvBysbLStcGjj99cP+p4vweTZsgTG
pzj0Od/eSl3wEmz2/kauk+vVWY/YnoOwJWBuzfOjJtez9hH5b/IxS6CT8ZWy
1gSH8oa6vCpIX4K/KebxPMY4tGd3izalegmkLbOPJRvgUOHuDX7PjSU4qq5r
EKKBQ4cF3x+t3F6CoNkfQps3caiPr+jazv4SNElG++io4dBRedtiO9plMC4n
/MBcx6EBactXjHmXgbhK/ZlTCYfOuy48RHWXQVn5rr0euf4n8o3H7pcuw9Xm
GMMNRhyqFrRqx1G9DP7DV33K6XHo9i+KqwqNy+DaNXDI8xi5HtbwrL/oWYZU
ein+A2ocemBgcWWTuAzMk+uWtQdY1Cj09zKJbQXYH3Yp2ZHXR/Z/NPDj1Qqo
HtKmfk9eX5sfsjNte63AAC9TMaGKvH62CC0yB6zAva9379BWYNH2j5ofdD6u
AH2bbaBDMRZ1Ff0435WzAhGTNwVYsrHosBlXSOPECkgEY+2TwrBoRLf0VIHi
KixcDGkjPsSiSKdeuMXVVRi57+65cB+LzrY6XT9zcxXkcH4SM4ZYVKS+OC9A
fxV2bwVFduli0dZv0p7GNqvgGs/d5K2KRfdjpHno41Zhdi5xxUQUi5qZST96
sr0KYW+bPtLtUaHRr2IcQvTWoHT97ZMfb6nQiRNlVRkc65BSJRT98xUGdbLI
WoofWAfdg0Uk2oISPQXjVzcCN8B2VMleSIMCFWEWefJZ8xdUv13SlhTbh5hs
HWs56t8gmH9Tku3PLry8HCl7qes3MJnNzqXH7oC5IYe45/tNON6H3xOw2IJP
4s/p8q79AcFXX08EO2/CnaNLuUp0W7DLzMFc7/4LjFMlJXMbt+CXVF9iYPs6
2JdXz7u6bsO9i5757IprsNP/xDgTduDXhE8Z1mYZ+nLmywv/7ABLh2jMAoEI
5954TXBV/IUwpOQDgl+AFu6NmSeOu+BltNSmxTAHTgrJzMcv/oNRmtv39rlm
IUbPjoF9/R9cp2easINpOC52YokyYw/6FqaYArMmgYKuL1jVdh86/V4vvbk2
DlsWA/fXxQ9AZjBCmDd+BBR9so47EA9A1WqkNNn8B1B2azRe1KdAuxLcY8Wu
DgItiDsEFVKg6rLjvvR+/cBqJS3LQU+JSoiS1HOo+mCWrc3YyI4STTVo/mgW
3gP6Atdcj3VQorzCtKVSNt3QQG8/ntZJiQ6c+j714kk3iG3GKKIESrS1xM6+
+lE30FavHn7WS4kWWRBa9Ay7ofJ2RNjQD0p0i7Nc8ev1bjjnMfclZY4SzWHd
m6M41w0bg96TshQYdE0i5afgOAHuV+Qo91Ji0OQhCr6RHwRoTx5Ks6TCoK0R
AdVB/QT4ZHXRKuEQBr01M4bZayeAPlXfDvYYBi1pPVpIVU6ASmGeE4TTGNQ9
jj4wL5oAgkw3HS3YMOg/vuNqHz8SIHLH8QeGA0P+7qI1cXtPALv61gTJsxjU
5RPre/0AAvDetb8Yw4dBc+/ErEq4ECAUYt9J8GPQVFs5AwlHAuzzNm50XMCg
027P2KTtCTC0erqUQgiDXj1zMUrlCQGu9CuzRwtj0FW8le4tMwLkl1m9FhfB
oC/t28xNHhKAMzFiul0Ugwp3XOxwNCJAoE/NFTNxDLrr/sI36C4B/getSY+z

        "]]},
      Annotation[#, "Charting`Private`Tag$153687#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwtl3c41v/3x5F522SmT1I0SBSy7vd5J4RUSKiQETJL2UqIbCHZGdmi7Jm9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        "]]},
      Annotation[#, "Charting`Private`Tag$153741#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwtl3c81W/Yx6mUvY6dmZFUCImc7/f6GpFRRoqMrChSolBEqIyM7OzNryQr
RUoke+957L3OQXbRc57n9Zw/vuf1ft3zuu7PdV33LWTtZGB7iIKCYoP8+d9/
/ow49e1jVijF//+qw9f9RlCAr/yU/8cWbuw28agunCpL9AuKM6ORXBC75o5a
wJEm07Td6BZcTIaUth3qBLTvY00HNoT4NP/J1pujz2GHD0n9bmwmmnlW/tVN
9A307Nuvt/M/O9OhduG2EZoKctXRq5WhvjKzo0Aw0yiEquyDOB26/AvPv0Wf
fyZVBsJOPW4qo78V4xpbDs+RKuEU6X2ERs51Jdk7ctXKZ2rgZ7DHwmqmGX5o
euLDb6UaoJvfj3nlYon3s34Tk61dA53UY+rt49b4DvPFuzT3aiBYMwAJ77qL
f2CYxtT5vgZuF+7W+mm74nOV6c0tT9bCzzvxipsPwvAGlV/VWS/Ugv3Vqi+0
VyPwu/g70jXqtSBzG1E6+iEKf1mh+rC4XS3gL1qzjJjF42ckn+SSsmqB6UKD
RcdaFj4kTzQ6vaQWlkJtxiY+/4eXk+j2ulZTC0+26T3ed+fi/UQl9UunakGv
5lt6hEgRXiJz+KL971oILXeoUTb/hO8UDBI5frgO5Az03NIIn/GCvNPb3ifq
IPZalMlB5ze8Eyc0TyrXQZhExCuK3J/4H6wJKepWdXBGdOqyvXUdnp5x0znX
pw5K9Byne6+24E1p9C4xptUB25tQyn1CJ/5QwL5kVUEdWFF65fky9OBzj3zg
cqmsg33bVwTC8z68vp/xIZH2OphLDOZ+pDSI3/lHtdw7Wgfjug7PH10m4NO8
PvUGEOug7qa38XLBGF7jj2Wl4kEdXCz+M7haMYEnPmF8v8RQD5Hs+6yfhqfw
sVvfIpP56kEws3bN5MIsHn1s/0z3bD3wcioq5PbP42fWOOwokXq4MjMfwlGz
hA9xqtH9pFMPspfD0OEjJLzcirOirVk9WBxnN/bXX8MTHASEOR3rAbUPa7xh
+Bv/Yr6FvtGzHnJTmulswjfxEnYeWx7B9WDCFpL6g24H3zV1cvxMYj3sPObC
eFr38B5WvY2jufUQ762/3TW8jxca8/sUXk5uN6rSoEyjQBrMpJNVmuqhp9Gk
6rLvIeTh0Ij/xmA9nIxYxmfHHkE4jYMf5izUg4o8R4/7zFHkR6+CifFuPVC8
0F9794gGsbs2q0pL0wBE2u+rJRr0CENn1NnvXA1g11fV9/UuE5LBkePx41QD
UG+vtNrGsiDyZmX1VRcbYFvk6Z2iAhzSnN7E9ku7AR5MGAlqHeVALOcIVrVm
DcAd/Yx+OI0L2TxDyq+/3wAS77nLK/2PI69dKP82ejcATiLUnb2KHxEow2m2
vGmAcI0ErjkJIaRkXzS2La0BNj3lX02KCyOaqgpTHUUN0Cu2cs/BQhQZDdSS
7q5ugDMijAZPek4iLm1mXr3dDeBKXXA+NUwCOcbm1NQ/3QAv9Ab4eWLOIkk3
fTmHNhvAUGr3YMVdGpFOjbpNONoIgoffP+24JoPUTmcXjXI2wnev7TAKGznE
RKLsYFy8ES7odQRW58ojJKcm7SnFRhhlGaEblVZEXn4mxM1oNQKev0Yq948S
wvWHODNn2gjpVP6ZPKyAfMQoZRcdG+Hax77dWUQZUfHH+Sx7NcKd8a6XYYKq
SF+zaCsxrBGcnuQcxJy/hNxjUeBZS20EY7u+Uwe+GgiFkdad34WNEHJ2xgaj
00JiksxKNn82wnULrVs3+3UQickHlDtdjZDrm/69Z1kXqTzpe3VvqhHofLd6
HN/rI4b3oxL/bjSCeCcNPinwGrJQnD1/QNUEjpJMBfi464j3Tul5Ss4m+P1f
/PktghHCijb5HRZvgsL3y9YjpibIfy8I7VSKTQCWZu+e8Zgj+EYiL7VWEwwF
bcg6MVkiHYyUDrSmTWCu/HOxudQKsTXEldI7NoElk7TpYpANshcveoTJqwke
J7geKw6yRd6MXdBnCWuCs3GO89bf7iAiolopuNQmKPsm3JYk7IB8dTBbYi9s
ApXrO9fu1DsiVwsfKHD9bIKthi2Xi3lOyNSmzyueLnL/pZ3Rw47OyBOlqC7e
qSZwsa0+lSH+CKH3zRYQ2GiC/q++jU+ZXJH0ulJHIapmyOM/rn9TxB2Rp2/6
KszRDEQ/Q3vre0+RJn3CUbGTzSA1K+LJvOCJWLwlXhNXaAZvN/ohyPBGNggU
6RKazbCHFH7jafNBgk7giGdMmsGS/Uj0tQd+CP9dUSWpe80gTm+lOin3Ein+
eCHw3LNm8G3sQwVF/RGN35q9sqHNEEeF/fyoEogQFMxOyKc0A9Xn6svuEa+R
h94PnBQKmqE5T9TjG3sokkATRYN0NkPnlMXP0rsRiJRu9g2YbIb8ssNYPE0U
UhNdmqn8uxnM3vJ+i2yPRm4ONa6qHmmBsnUOitqKWIQoQEDU2VvA/2VFTHh/
HPLClvj6slgLGIVleicIJiJcHygGtC60QJjeHb3OpGREWV7URfdmC+x9GHSj
TktHFFSEbhxyaIHqM653Q6QzEemrfBc/e7QA+1u0engyCxE34ea/G9wCz+lu
1rz/moMI2rEfOp7UAvwGiT9GSt8hXC4ss615LRDx+kFF7HguwuzN0ORT0QLp
uOePpS58RChiqSJnR1vg4v5neSO0CNlJp3SLJ7WAAPIqq/VrMbL6cf+mDkUr
XK4ucwDDEmT+6y7yj5nMmIM4C/MXZKx2U6hYqBUuTf2m6SGVIn2da1S2Mq0w
KqjWeXnrK9I2srLAqdoKv6U1mWzEviM/NmeKvG63gsP6ez+5wCrkC+VkjLRr
K/CaKi3nzf9E8hlGn069aoXrX51OUdr+QnK4h8xjY1vhs5b23qV/NUiyaJ+y
5n+t4LfkE/z5ax0Sfa5L9G9pK6wXOS8VxTYgIUgbTUFDK1xjcM+uj2tCnl2v
62RbbAWdmn3/G5ztyGOr6s/1e62gYJ/hvtTSgTje/xHvQdcGVH/qWqrFupDb
T8u9zvK2wfc/lYo7Cd2I6asvVuNn2uD6Uvxb59O9iEFE8aUopA0ut9nHnh/q
Q7SS80+pX22D7GH39vvvB5CLn3PWPji1wdxugkRyMQGR+ZnRe8unDewT6u7l
ro0iEq0pX1ki2uDkn+9x+R/HkRODCck16W3A51cfbbw7gXDPxPq6F7fBdrIQ
k4P5FMK8Fmkr8asNVtjwL6KHpxHq/TDNke42SFblS892nUV22AJYVDfbQDxv
fU+TahFZFXyxuUnVDl9qTD3Z/y0h82eeD77jaIfvTL+58HxEZFzBs8L0ZDsE
94uy85xbRQbU3NMZFdphWMr00NW7a0iH3qNXPy+3Axul6pmUz+vk+uVk//hm
O1Te5zJ6xbOBlD6+c27Iox3evvvV6nluG8n3sWEPDW4HTxXa+b+zO0hOiMUu
JLVDd2tT8p/yPSQlznRkPa8dKBkFNtwL/iKxWUY/syvawXSz2iyi7gAJK7yW
bdzWDozTapiaLwXq/103iG6sHfgtl8PHiylRpcXMdwoUHeC3Z/xJ8MYRVH41
nSeSugN496/JBzVRoTJbqSFLzB3gKufPw298DJX8m3ygxt0B2k4ma08oaFCJ
Q0kPU4Q64BrRMkW7lhYVo06Y3D7VAStVR/Kt3tGjJxjjDPVlOiA/I6wi/QMj
ysMTrXBEtQNOeedq2YayoDMq84fatDpgs9XallTAihbew7e+NeiARdbTfBem
cahHdPhbK5MOUHbp3sROs6OXKqatTlt3ADNTsq2APwfKPKtwZtO+A9xkRf1/
b3KiQ4yhWz+cO+DshxutK57c6EPL88EGvh3wz8KE6m47L6oUFHSdN6gDDg/+
zUlK5UePFo8IzIZ3AFOaNFZ0SRBNOuxf8jSNvD9FsbIV8xPonTND3qrvOuC1
rXsByVcYlbkuqclQ2AHTx7Dj9KUiaH1O30haZQe8MaWusDY+iUa2S7xzqO8A
FU+iX2adOGq24+0i194BJ0VFGBi0JNB1zZPHGkY7gH9nKfEg+ixa4eLZGTFL
3j9Dwa2DW1JoYGJ7oimxA+yO1k0Hp0uj/OSiTdrvANK154IpBTLoAnvLXhlV
J+QuDZkLt8qiJahgrR9DJ/x3Qqno854cqhnecJODrxPY495a3Q+6gLJ95RUZ
F+kEYVn9CJtlBXR04iHx/ZlOeMYQ6UpjcxF9LMv9AsF3gjn1NBLwBkHB7P6V
Y2qdECtN+y5cA1DaVz85O7U7QazH8U9fMIam9tnn3TbthBWzwFfhfiqow78K
N0mbTtB79fNdaKQqKifOqrzj0AlnOhgWFYvU0Kan5b3BHp3gUqXvkcqngcZk
MKZd9+uECnGeCyTHy6hls7WDwOtOSJT8WHK8TRPd4qX7VxzfCf+slkszG3XQ
n5csGp+ld0K9jJLurO1VNOTBpyj1953w4Qj3zUU6PVSoylR8qIxsX/ltSd9x
fXR5vmA9s6oTQlOjl1VHDNAvLEcq7jd0wqj7Z23huWuojk2ePuVAJ3SR1I43
itxAOUMoeJvHOuFzw9e0xZtG6GSJ4Wz0XCc8LC8OGUsxRp8c3fcQ3+6EoISJ
Nn1TU1RVSv/S+kEnSI60rN7rMUMZjbOZvh/tAkxYqSbK8haa+f5Kli5HF3zc
r0/pG7JEH3SlP+Dm74Lx5kh9tSorVOHPpsKUaBfs3Vc6IlxkjbbppLS6ne8C
s68WTjdLb6Phg1mN80gXMHmznSPN2KL6dh9qTdS7YC2soL9Y5A7a87ysAjXq
AkfkXjpVnz0aS1/5tdCiC7gzRz9d0bqHGsXXfj5xtwsad5eN5Lsc0aHiro9H
n3bBydfOc3bMD9EkGHz/xLcLugcUIms3HqLmLWPZi0FdYMuU8vzwjDM6PrOc
3JbQBSkqytsPlh6hGS6/47HMLpjDN1L2HXJFbf7txhR/6ILbM9sDb8Td0Fmu
Y2Gx37sg3Phze0X6E/RdNsNr6touiLvffjln6ylqL8Pm79HaBdf6m8eazDzR
ZW0h71ujXcAhHa7FYOmN5g+c9OiY7YLPzjXy0wfPUSdbSTcVUhd80XyLOz/o
g657Kz0Qo+iGENo588KPfmgJnYpDHHU3XDluoHn//QvUNe6yHS1LN4jF3tAP
LnqJ7hRdv0UU6gYd/682Mgv+aDlqZmIp0Q0ZpFvRRO5A1LPZ+kaXTDf8pqrJ
crkZhB5MO139otoNUsrO4r7HQtAqZzctcZ1uYEzOL3/sHor6HjxTTzDsBsru
3LVDu2HoEa7XqLcteT6lS8W0PBFoXVb4xdX73SA9PBGTth2BBpx7K2/t1g1y
x9czP4xForTaWZLqAd3w8RqT1G5HNNrSnytR9qYbtiPPuMoOx6Cht4vEJOK6
4a4Foa1rLRZl9v7Bz/iePJ8zL81d9Xi0i7aWx6eoG76bPz75/FUCGvW2mWP9
aze49+leQLsTUY6iAca+pm5wXHb8KJ+cgg4gY7SXu7vh+OcFN0uGNDS+aeZo
+XA37DG+TG/qSUN5p9cPkpe7oTH1aMbh5xno6MPdPabNbpB4R38m1joTTd3/
t+W73w2VutJ3rutloSc4GUi2jD3QlrOrR6eTg05n4pb6OXrArsdsatrkPzRb
mmdOU6AHeET95Ypc36HiWifHzkr3wJNOi0rOzlxUyku5fVO/B77/erVK5ChE
q86kCA/c7AFG2Tq9Nw2FqB5hz73cqgfslbIWdHyL0IdKJYLPnXvg2Q5iIknz
CaVYYna1etoDMnI94mMDn9CIhPuNqr49QBNpjNUXlqDFu2Iu1BHk8T9W3zl7
fEFV3r+oW4wjr38HF9TjWIp2G4/ztKb1wGVL/62Cu2XoRmn8r4jCHqgrDr4k
5V2OyrvRsx/v6AEB/7PnXktUonWi9vb7/T3wOQ6KHBWrUKPe2oqxsR54Qz/l
2jdVhT6Re26XReoBw3UOTQOdapR6erjcf7sHVunPfRqk/YXGRSkw2f8jrzdH
4g7r+IV+XV8rPcvUC8dczht7udSiWhlX6Zk5e+FL3+YCXrcOHdL/YLnO3wu6
p2apZeXq0b3C2zSlkuT+z1oCpjgbUbxTvwl2tRfKDXqlyq62oi38cgUnbvTC
YSqPKz6ubah5W/hhqlu9MKExUvE3px31PquV13i/F9JsZHyr2DtRxpEcijzX
XrAxf/Qos7ITTQk5fD3MqxdkLvQVpTh1oZVL3/cNQnuhr9uJIm+yG9VL5DY4
H9MLRna+3eI5Pei4llsOZ3IvWP14EhL1sBelyJXSJeT1Qpe6ch338X5U5W5G
mm1LL3CtevoktA6hXZz/NjR6eqHQ+23GmfZh1KbeVFOC0AtKTz+9fDdIQF+K
sa8Tl3pBjEZI7DntGMrW56ze+bsXNFKOLZRyjaPZr9oSPv3phZ7LHlxKReNo
3XSA6hO6PmCbXfpxeH0CvRE9/dYE1wejInnTSQmT6Jyq8jL+eB9cdDTVnb88
hVJn7kVTnu4D4/tuV7VKp1FNq/uzr7X6YKbgUbvT+BxKu4H6XzLog+ymbg/b
0nm0xZ9ZjMKkD54X9Dy/GrOA6uV9snW174Nv7wmVLXZLKCu8opJ27oNPdW+e
t5ksoz2dN7IXn/TBEYXjxUk3VlDj7d1pi8A+MIyOVQ+wI6E8r5tf8oT3AV6i
YjEUWUUJvMkivW/7gHGeI12+ZRW1VMFua/3XByUqbSdFttfQu6H+U3J1ZPvC
CF+FAzZQCUHjF6TWPhA6QXWSWWETXS4+JZzb2wfX3eh/uhA30YcDLdYCM33A
tB7udcFxG5W5l3JoaLkPWCAnbFF2B93Yd8qI3uiDV41aJZ8pd1F3YdwkzZF+
WFY/h1cu3EMVvkz71tD1gzez0U+TiD/o3uUvQs9x/TBuTZ+HPv2Lej+4abVx
oh9kfx5iFLl1gPp/TR0fVe4HTZoHCisYJVzWcfaJ1+yHyYjpJybtlEA7piJo
qN8PzqP+n/esDkHYkVmLRst+CGndXlGPPgwxumfGPj3vB5fzuatG0kfhxuS+
94OAfnD8li+ZMXUUuFzb+U+96Qf1kg9MnEnHICnB5VZKSj/kH1lwo+WjgayZ
spHAin6oniwwpbahB7snr71Ua/uBJLCwE6nKAOJ0ZnwHLf1w/NDgj4cSjJAn
/c/sEaEfGLfe8cxQMUOJ5yWC+Z9+OEM5+b6bmRXcGDmfcR0eAOyOUe+3JFZQ
SJ8/3k07AJ/nKBS9z+Dge12w6WWeAXBaOW3024gNfrF0DckoDsCTIN3bdyc4
4Bn1jbwY5QFoQJ/HjyZzgty/Qa8dzQHwWLuv1G/BBTnLE4I/TAbg72W+qqkN
bgisX7PTfDYAioPegtl3+AD74aqQ93IA9mUsXG8b8sNuyS4NU+gATF+9UjSt
IQAOGZQfe5IHQNNMX2Y5XRB0vFh+W1QOgGnwz3TtphNw5HFMTXX9AIw8PUSS
viUMFQ7csaIdA9DLXyMvtyUMksZCikvjA9CY+chpX0YUWGTPPXc7NAgnXYiC
bydPQtOpz3qDtIMQUj8raJsgDn6CiifwuEE4kXjV65zRKdhgUK6lFBmEMvWY
OWxcAvrm9ehCLw3C7PvhzkpZSQgb6yGQrgxC+qxYBSWnFGj0Gecb3BgEtCpH
VJRCGsp+Wepz3RmE5iQcvmpdGhJTHr7NDByEs91WOP1/MmAYs3H3aMQguP20
+sgTLAv0IU8u2scPgpnUwUM/HjnwfuozIpk7CDOWf1R81c6DpWG4cHnzIAQj
j8az6i8AlzbbJm/PIESHUnbVuihAp3Jc3XPCIPCbiz5TPKEIKlJp9pdWBqFI
qyPGM+wiiNIWFnQwDgHlMQ65C6kIjFLI+cpyDsGRs++ESp1QiN0uNYgVGII1
0vhV00sA1DOVm6bSQ5CTG6Ci7IPBYmW70pz+EFyIJJ2tMVMBl8H3tuU3h6C8
ZNAvs0sFdtdfvAm1GoKrj1vx4tqqQC2mMCXrPARB6vUnjdTUQCwk7bVP+BC0
3FvibTFWh/xsj5JrcUPwj+2S9Y0ZdThfaTgqljYEv8LL7bYea4DaOrVMawF5
PV8BxZLky2Bt7DzI3T4ExQ/uWxM4tGHRWfvwSt8QGJS7mTdUaINzsOjZqtEh
uMOyG6Z5Vwd8fgz62BGHYCpwjF+v4QqkiKiIf2IYhgQlWXVJUz0YXmV119EZ
BmKDB/edj9fAmnYlTcBwGFZKaWi7hQxhUbi+ad10GOze/i3JiDOEvRue/PH3
hqFbWyUzLvQ6cFVM1c68Jrcr+UdwxhpBWl8FqSxyGA5uCWwM8BvDydW33CEJ
w1AdpHzsZq4xyAvr3JfJHQbWmoHe2sabYBhUwva8cRgMtjh+FJw2A0JGGGrQ
OQyTSlfEfjWbgc33u3dFB4fBtt1kbu+BObiQeL83zw9D2Q5lFkPlLQi//sqG
i5oAvl8oOzN+WUKL0I3iInUCjOdcKrWdtAGt1EmGs7oESG0bfS1qfBsaeJ3s
3xkRYFmSn0a74zbUcgYKpt4lwJLNr/C1elv4wVAeFvKaACYXoxpGe+8APlh9
8VgUAVQbgoh/Le5COXX3pReJBJAIf/RhcPkulB5e/vs0jwBujUXoAaMDFO7y
3bvTRoDuN5oEDTdHkHTPrZvsI0B/3NHyj5z3IW9D/sStMQLU3bNfl/t+H96T
dAcNVwkge8prZpjRCTJmfDVUWEfgZt6qyCHiQ4jqnBHmuzECGnkXjtGwPAZW
XZfncbdGQFBN1O2o92MIbzkYwt0Zgd8vEu8eW3lMjmPOSNonI3D8TuIH2U5X
eFmhSbETPwIU7dO53J/c4ZBSn+mjjBG4dVYuiuPcE/Apsy4l5o5AkbkE582i
J+D1yfPBzLcRyDhf0NZZ9hTc3n8kdI2MAN9TL5/gaU/YELuocHV2BNyYNvny
XZ+BS1ZdVCNxBPpyfNNu0XiBU+qYVtW/ESguNrd8o+ANd2NYvn4UGoWCopdL
qaY+YOLrGhNoOwpChF0pE4EXQDvphifcHwWR2Khe4rMXUK7yZErKbRT6dwKy
GQgvgPuI57l+/1F4cYR66yDlJQz4+7SKvhuFyuNyERoK/hA45/v4aeEoNGUP
2dVk+IPC5RfHW8tG4T5tncA2YwC8pfG3f9w4CvKJEmwxywFwIySY6tfiKEil
fZi9XhEER1dC8jh+j8JHu1hjEfnX8OVK2DWHP6OwLPD9R3/ha2BnikhnoR8D
1+gTv6nygqEnIhaxPDsGMf4GHZLloaD/Nt1132kMKIPPaX7giwCKnQxe/Sdj
IGfV877MIQIKjbN+ZfmQx7vzVS+XRQAzz38sOhFjUN9CL9BvHAltSXkfE4rH
QIgXQbn+iwKdjNKZC5tjQD+rxO7rEwt/D30NCd4fA9vCLv2PE7HQd24knnRo
HE439cYqqb0F/8hRTJVuHPIFs6jDGOJg5tpE2OLxcZitq/vpURQPWX2zEorI
OHgPlefTqySDTVykxHHlcSBQVQnTfkqGEyaoxL7aOPwqj2RxFU2B9JGYUz91
xsGytCAunTEVUqbVxDXNxoE1av6E+dM0iF/PEL3pOQ4SSwseEX4ZYFxyVVTp
+Tg066epGdVnAJfbngjfi3H4rObkvUafCbG7+iITr8fhnORp2g8JmRBNQSls
n0De76cLAfZVWRDGaCH49Os43Bo79qxH/j+40kEraFoxDtvcLXPtQf8BfeQX
AeTnOCz18FFVjfwHweyMApSN42CGnCv3D3wHgbwVfEED4/BO3chkYeE9vJA4
fjx+exwS1cXsZkbyQGW5jsfzzzj5Pm2ddUb5IxzKd+Ex/zcOR+VSzgdnfwSf
c03cQscm4O/NLvW3zvngrfCU6z3HBKRQl4vH0BXCE/V+9q/nJyBW+jMDf2sR
yF40kyQpTgAtnVXVMYZiIJ6dUBdFJ2Dpop/HhyvFYMO+5B6hPgEF5n/oT3YW
w9Xpg0F7owmg/PVclHviEwj7iaXwPCXP7zL0CxP7AqOuH77oeU0A97UaVT+X
LxBnL93u7zsBUW0LD2IrvwCj/kWK30ETIH4T2BCzUtgRuGrdnDABmt70SwWp
ZdBW4Sr27PsE1M/lU0XofYPAoj20uGoCvt+5Qf899xuoZj83mq+ZgMpv+Qbd
VN+hLCQo0LB1AoISGHhbf3yHTNPkxTOjE9D074jUcfwPeLJbkz/ybwJIVMkZ
9cVVIHye7QKoTsK0/eClD1AD6hdrPM9qTALuk6nTwZMauAuPq45rT0JS9GvD
9uIayNPs0dwxmIRt05z95ZO1IHcr2qzIehI45wTdJLjqQC2AzU/YbxJOcp4d
VGFpALuQmjoW/0kY0Cx589OgAQIjHtNRvJ6EzFDRlIboBmhJ7IkmREwCwqVo
7cLTCNcLo/+LSZ+EL/p7XepnmsBukK312M9J8BAPzHzp0AKBozUsWzWTIGL9
YayvpAVypx7fmG6YBH+L4aZv/1qAuNIzVtUxCdKl9+Wxt63gfihm/ek4uf2P
E8Wl1jYIPM3OtfyPbK8W0jOd2wG5Xuw2HegUTJbV5Hs96IaGkpQqVtUpeDZS
K3MzvRtmlk7yX9eYggDJSzyxPd0gaHJxcFB3ChbpiZ7n8T0QK2+hO2U5BZS1
jKpszL3gR3qntOU3Be2LNEXJTX1w0wrPxls/BT7Z7Ma8oUPgFlfrfKt5CpK2
ni7UtQxBdPvV9rT2Kfh7YmWSQD8MbYjVa9GBKZAP0+PTCRsGNR5/CqmFKWju
ql9GYwkg3d2+rEw3DR8dPJg+lo8C9SWb2ju601CS1P4y4cME/FjJuRx7bRoO
v7B8mds5AY9jF5trjKbhxipH8Nr2BEzMOXcJWU7DU/OxTZFLk1D+2mds+OE0
mD3j5xOenATHjuRd3chp+LRUuBkkNg3tpgNnFXqnIXvwqqz+4Cz4H+Etshuc
hr6e1semR+cA/9FCLmZkGrTFD1OlyM7Bu4PZi+sz05C5M8PREjYHPumbGnlb
08CdX3+0RWMeZOZYrQW5ZoBlh8/lZs0CxLpciaU2nYG8WHB6PrcMJWe+XyLd
moEpwkIpHdcKdM1KbPZaz0DpqzT5hssrwGBKbZjpMANqMrSpnbkr8FL1Fwvq
MQP9mTk+Is5EcGZTDH0UPwORBlk8tw6vgs4XkZej/TNQrD2UGp27BpR7f5xL
DGeByZiXOQ6/CTyzqhdJxrNgHzB9msV8E+S6gg9JmM8CeuFTQIbXJtjlHo9K
tZ2FUP2pKIbKTWgyUSp57TYLF6oa9ylVtyDym8eWZdwsrF68Iaituw0nvHY9
GAizkMm2cjLwyS6oUGy/sLOZA1ne4xI8Rw/A0vJLmrDlPKxxlYRUhx7G8sVY
zywaLYCtVkzrugA11n2vfOXL7UW43dA+c2GIHtPjX9bJuLsIsoep+UmL9FhL
B19eqOMi5DSZf0v+Q4/VnPd1uP14EaYFdgjjvAxYyT+NOZaXi6CQfbfm7y0G
LDqqd9wxcxFcCKFJnhMMmOG31e4Tk4tQ3XI9nXeMEeu4f0KWcXYRTLufpKQQ
GTEdQcPI3YVF0EIkRtgPGDG1V6V6HWuLkNfyeGyKlwmT0/Vu9aJcAkmjF8jf
m0wY2xRd/YDgEtwONmhj7mLCemhPlodZLMH1Ct57hWbMmA7pnEybzRIMVJCQ
K7eZsV/d+FyGu0sQZe37YfIeM1acZJAQ8nAJEHy/3LYHM/ZG0tvjte8SWF80
Yq+LY8a0DHov+mcuwZWzM3O/u5ixqvgX37zmlsDBZqDzpjILpuAdJluxtARf
q2bS9zRYsALr+A9/SUuQFDfCHXWVBUs5XZDoubMENqeM53JNWTDPiiHPpzTL
8KA1Ws3VlQWTnziHdz29DMV57ilO/7FgeeLj3x2dlkHuyuvRriOs2HfvbJO4
R8sgOH7OQpWWFWvpcdj55b5MfreInPrAxIot+2zKHvdZBmuLqQBLHlbs7CDt
h8bwZbjuvfbXSooVyw86Hy9WvAyFh2hvfjdixX6M7ckbfFkGLkujN6lmrFjb
+aoer/JloM5q6HxqxYoRJ7SYe6uXyXlt5j7uHismddEy4EX3Mtzipc8d8mLF
Chdfu45vLENDIkvSl3RWrArTw9HvLoNOuYs4TQ4r1hHLXnRhfxlIH3iiDHJZ
sVWVtOUwqhXY4BrabSxmxc4lfrZBOFZA4XZKm9YvVqxYe1w/4cIKXByM6Iqc
ZMVK8s5LGnqsQFBMocI5Hhx2hk1s54L3Csggh/pF+XBYpidH9XG/FeA61GLC
KojDIrW2r08FrZDrPTtLtygOezhf5uUSvwJOLbuSv6Vx2FkRfGt42Qr4JKYe
zb+Ew7KCz7x9/H0F7HnixwQv4zDe37xWxlUrYEvDnBSshcPoq/c3BBpWgCfX
tuqyLg5btKjkLehfAVlBz0orYxyWk6ji2Lq1AuwhNP8Y7XEY/2FZ+aK9FagT
olKmuIfDYhyEKWIOVsDjS++DBUcc9lLxSLTZUSJs3LCPyHyIw2z6a78tsRPB
dz6bvtQdhw2hX161cxPhV49u/Z2nOMwgJ0f3Ex8Rhr8WuzJ74jAV14ApD1Ei
MCbpFGt64zBBnCYd7XkiIAcvW01f4rA4D8XeFQUiyJbcudzyCocxTZ5K7cQT
4Wyx9k+5ABx2UEgrG69GhHupK8UrQTiMcLXFRNyQCNt8T6r+heEwwy/fReiN
iRCXe+iGdDgOa+b7SCSZEmFV5dSWcQQOK18O9Su1IUK3s5p5ZBQOi3+tm6v+
iAgBfp672W/J/hLhDvV2JwJvTTrHhzgc5l0x6fTFkwgaOXYLOfE47Paq63mx
l0QYvC1Y7peIw/qDgOtWIBF0TplXWCfhMC1hmj8xIURoxBp8FJNxmPSNpCqq
GCL5PqJ0rTmFfN4k20wknghH4xfu+KfiMI4gKX/XZCJ0BbNeVkjDYUEndu9+
TCfCCcOcrXEy//1WrT2TTQT+6DQ3n3Qc5nQ9RJIvl7zeLepmjgwcNkm8znI9
n+w/sdWtTDI3CC301XwhguKx6omMTBym9K34699yIuRZ0/zHloXD8g2fJclV
EqFfKFjPi8xCxEvPHX8RYeZLxASBzNEBTNZZ9URwjHMxl83GYceEBtUIzUTo
PRdW70Nmj/KMk2wdRPjWrStcS+bla460Oj1EkMk6+5giB4dZrJxfeTFABO43
7ypkyNzl/6/9G4EIl+R1DpuRWU2wsfj3OBGaJ/IvPyNz6dfImNMzRGB46BwR
RWaJa2ZPbBaIQLwEE+lkTl4WNU1cIe8XbVP6j8zM/iSke43sr6TRrEwyvxD4
Kki3RQTvnYuCb8m8VeZ3WHWPCLhzZUW+ZLY30Jn1OCDCdbPz5jZkJiyxNxYf
IoH7l0QxPJl1X419WDxKAorIURZ6Mlfzvw87QUeC9xp/TnST7Ttf5uJswkQC
CbFd8wgyv9PHG0biSEBnvVCnTubjS1QXmjhJYEM1Z/Wb7L+wl+3ch3hJEDfG
IfuWzJT88X8VBUlw3PU/VIbMj0utx5xFSMBC6gisIZ/PnN6Z6vfiJKCk62W/
SmaTxc2siTPk/dH+W2gjn2fri8oA7nMkyM3IpNEgM8YX5KB/ngT0y4JPv5D1
IKrHK/0TIcGAr85NT7Je4hZmWHeVSRBoOtPVQdYX7YuCTWl1EmyOnc7nI/Pq
Z5VvaVdJ8Ozcn8Rksj5tdOlTBgxIYIkrLe0g67dvvteH2YgEQe/8Nf6Q9f39
uL26jwUJ+O+L98kn4DCpzzKnymxI0Hfy8agGOR4yrv6lW71DgvPBdff1yPES
6Pum0+IhCXbHOuQux5Ljce6zGfiS4Ixq2EoXOf4kI3PvSb0iwcKlE0afyfFJ
g6R6CASR/c3d5BP+Bof9iAyM+xdOgpXYMZFzoTjsJGraU5lG5qNKoryBOOzQ
gu5UQRYJfuaaHqn1J59nlNp66juyvSVQa0fOF+ELZ5l9Ckng8DpuP9oPh+1F
U+hgVeT+a1+qk57hsB7YNJGuIUHosY1TDOR8VLC4YC/YQILMIdZYN3K+uo11
B1B0kMDov+UwOTey/5eyf1WNkeCk546vuRMOS1PRVlL+RwJNSi/XO5Y4rGJL
IDuOchXy/R/pOdwi61cnIS+cfE8yvOPmYWeGw6i2w775HFsFmvjeNi1yvi3X
eTJoybQK8vfsKGrI+Vh4R4tdSGAV3P9L63iGkPV7dTUkHV2FTyHD2qfZyPlj
ROO/Nxh5/Ph8tRMLWc/3Un96qaxCgdOiXT4j2f6Aq1s31Vdhr75Ek4eGrN+q
PAvWq6tgJul89OM+K/ZGxl7mhfkqOJbN11bPsGLiHJP9t5+tgnfoyOnuIlbM
Oktx3cB7FfAFZVx38lmxRJkIemWfVfCoyuvbJNc7Rl1Mme/lKrQ/XB86nMWK
bQSk5PYGk3m8J24yhhX7uWvipZ64CoIWXGEFT1gxk5HuE+LlqyDNN1+bd5EV
izgSp4l9XwVbX1qxK/KsWMNps4fGP1YhbW/q/Pw5VuyCx3RFYPUqqJ2y82E8
xYqxcW4aLzStgpjqUz9eTnI91+N4kzu8Cp2qT7XV1lkwlRrjP2f2V8FLOijg
dxYLdurDSPc5bA0qxGSzDfeZsblsTVrlijV4+DbAdxBjwpjHh0271dYhWOFs
JBcdPXZSo0Pm3q91YK3Cd6VsUWM3Jlh/BsBvuDIcXer9lwpbK/d0OFn3G95H
Kdv9mTuEefxUj29R3QDuQ3Lro3gK7MExhamN5g340cZnn6f0Bzx83KfT9TfB
QojQw/5xC1zFuO8Ztm3CNGPEpcWNdRimm6B/fX0L/khNDMWR85QUP51cbfcW
SPCmeV98tABq/17KlvRugcNgpfMtiwUwGT+Qyezfgl8lrH5vtBfAP2P9nO/w
Fuw9X5/iElkAgtiQFDK1BRzJqUwNvfPwWur96c/rW2Bn7M8dpTQPM5iGcDbL
NnCenlQuYZ6DRJsXrK/I9+gjzBXPJ8amIX/Enj9FfxsyH9oeKWmdhmojPYnS
a9uwRljTiP42DfPafCoLRtvQKLi54vV2GuTlSp2vWG6DZbHOzAb5XdR5ZKmD
3Xkb0vwYDxx+TcGxHIM3OZHbEGb8t0q1ZBIezQvRN/Ruw9vNcR7q7+NwcYlP
sqJ/G4o1KuqY8sfhEJFbr3hwG/zjctqE0sYh/DdLdNLINmhxEYduvxyHvANK
XueZbXC0+wB2V8Zhmm3yNM/mNghquwtmVI/BDeUMbUe2HRCrdPFQEhoFxYQT
wczXdmBj/BNnCucwoPwqm3B9B5QFnwd07A+BWoaVhZPRDkyuykpxTw/B1dw0
2TbTHeBSMZxfLhyC2+X8hODbO2DD8EgvSXsIwod4zh5z2wHuyIt+DK8GYZ4H
174ftwMrqy7TbccGgJgio3g2kTzewbcgd7Uffp8wyDRL3oFG6sOtCYP9cCAR
4f4tfQd69JVqSj/0A5sSk+DT3B2o3Bk8OqXXD5gpnfPGtx3YeXCEfj2lD9TH
JIaFf+xAKMMAL31QH2jbaF26VrUDzrEWsYqP+uDGvSDu4podmCdtB7Vp9IGj
57Fqp9YdYBL/PDG61gsu/8TOpLbvgOsP65xIQi+4v1CPbevcAVslDaub9eT3
c/Arh7N9OyA5veYjkNwLAUzZPWYDO6BIsmvkD+yFkKgaNGRoBy7lPGyXftQL
kZzT774RyPMtbr28fqsX3iYexi2N7sCJC/PDIZq98D/rTwQd
        "]]},
      Annotation[#, "Charting`Private`Tag$153795#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJw9enc0lu8fv9GQksyI7JUiJJHnvt9WlBEZGRHZ9UF2kmyhYWUlZK+s0pDs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        "]], LineBox[CompressedData["
1:eJwdUX1Q03Uc3sbmmAhuioCFGjFQOrKUS3SKz5cXV4wXA0LiRTsNDy0Q4kVQ
RIwX8Y3DRhwEh4jJSEAyU3kpAkpe4sATDE8RGMpGIBDj953AgGGrz93nPvf5
43m557E5FO1/mMNisdwN+981dnnBXtc9Ddb/Y06a3Ab1U3wGykFIItxFpM3j
99IsAYO7Oewi8fsi8kCq2LPBhEHF6v26cWsR6Zcdy/Y1Y6B5a+lVwYyQ6PyX
rG+aMzhVv7c3qkJItn6+ftcXNgw8dy/eFZkLyfX0AydVEgaSKPPmIKUpybo/
OPMkisF4eGrorTwB2e4gyT8SzaB+j1JWniAgo9l5znMxBr1CrmVNoIDIgryT
LOMN/LmFsTYWArLiZZ0u8CSDRw3uB98uMCbylXmLPWcZdFXoTg5c5ZMrIV6c
rhIGSR78x5EtPLK3UXEtrJRB9UT4Hzk/8AhLzHGfuMZgVbdzZOdFHjk4WZtu
ojDobT48L/fnEfEZe56syuB/wcst8DmX3ChjG7fVMki97Zr+oxGX3NHUmDZ3
MxjqfKy6F8ohUpp2NfYRA8XXx93U4JCnr3ycxL0MxFuFrVvEHLI0P/xp1hMG
2S12m+wm2eRDnvC6j5JBxwfN5fFn2KRv7RFJ3wSDENbMrltVLMJyt4qgfArJ
ib7aO9uWIN8zrLsuoLgcX47kZUuw+6j60j4Tiri0ubvJj/WQ+XjcrjOj8F1e
YfxOoh65QTH61DUUoi3DgTt+WYR9ZHvuCluKL5V1AwLfBfjkJTXZ7TbguzK+
Kyqew0T/b5/Ug8JzU3mZfeIcLol5Y76uFC5Wzk1DH8+h8+dvREkeFDWhOZXP
uXPw7qk41CGjuGJ7cd3q6Fl4rxzgRgdR3FeGTK/1noHXeVfP2hiKh/lyj2cb
tXj5MGvAO5ZiWUJ+wAq+FhesHnz1PI5i6JHLqSMjFB3lIYXLEykypM65pWUU
sta48bAUim8dHm5YbW/4jRTZ7AsUPSnnFb2bDb2kLO+RfU/xnm2AZviABj2O
7XFmBlzH4otjr6FBWH/mmh4FRbXfKwcvGw1idrKDgysoYBT4prp9CgW6WWXE
TxRRRztsZp/+g78T1JMZjRT2o1vt80wnkXmsSdD4jMI5s75ttmYMZutPV6YN
UJRsVK9NzhxDQddOH6mSQno50s8/YAxVjjWXu15QJGbtVc5PjeKvlzct+8co
ihtM0hzeHYVtRJGdbpail3sip+zeCKosgtt+1Rn6mS45uP38CLa1Whw9s0Cx
zd9HaRU2ApmdvIr/muJUIuPfzBlB7PA5J4tlWrBai0PLAtRYlEt7nxpyTHnD
5c/CTWqcdeMmFgu02H+pobtPr0JhaWq92FSLbJ315h03VBD7uYSNmmkRnNze
uC9VhWrWgr5SqMVp1VREQ6AK22/VlkSv0mLQc6Il0lGF5s+OuzqZa5HqJD0R
bqTCv+A0EN8=
        "]]},
      Annotation[#, "Charting`Private`Tag$153849#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 4.904916350765519}, {0, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7392076398911867`*^9, 3.739207773929953*^9, 3.739207807975438*^9, 
   3.739207848217264*^9, 3.739207947813278*^9, 3.7392079819846573`*^9, 
   3.7392104080223618`*^9, {3.739211839570471*^9, 3.739211865214695*^9}, 
   3.739215762137718*^9, 3.739215887561675*^9, 3.739219157322237*^9, 
   3.7392778870851307`*^9, 3.739277937940257*^9, {3.739278673051176*^9, 
   3.739278713531186*^9}, 3.73930791368672*^9, 3.739503550403927*^9, 
   3.740335484526828*^9, 3.742069243505865*^9, 3.742070894021089*^9, 
   3.79384347338067*^9},
 CellLabel->
  "Out[401]=",ExpressionUUID->"48eb6a62-ae9b-4b63-a6c9-81e216023364"]
}, Open  ]],

Cell[TextData[StyleBox["Explore adaptive approach",
 FontSize->16]], "Text",
 CellChangeTimes->{{3.707347555181609*^9, 3.707347582594514*^9}, {
   3.707442063493147*^9, 3.707442072299552*^9}, {3.7075124401671667`*^9, 
   3.707512443443941*^9}, {3.7075150626652737`*^9, 3.707515067495439*^9}, {
   3.738688170771207*^9, 3.7386881739103823`*^9}, {3.738696568492777*^9, 
   3.738696575810809*^9}, {3.739025766420356*^9, 3.739025770504059*^9}, 
   3.7392778485601177`*^9, {3.7403356021968203`*^9, 3.740335608578992*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"a4b7e463-b7ec-47eb-a1d8-e72f8845f0e2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmax", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqs1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "-", 
       RowBox[{"a", " ", 
        RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", 
      RowBox[{"u", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"k", "[", "t", "]"}]}], " ", 
       RowBox[{"x", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"k", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"\[Gamma]", 
       SuperscriptBox[
        RowBox[{"(", " ", 
         RowBox[{"x", "[", "t", "]"}], ")"}], "2"]}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"k", "[", "0", "]"}], "\[Equal]", "2"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xs1", ",", "us1", ",", "ks1"}], "}"}], "=", 
   RowBox[{"NDSolveValue", "[", 
    RowBox[{
     RowBox[{"eqs1", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "1"}], ",", 
        RowBox[{"\[Gamma]", "\[Rule]", "1"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"u", "[", "t", "]"}], ",", 
       RowBox[{"k", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xs1", ",", "us1", ",", "ks1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "u", ",", "k"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.740335649093483*^9, 3.740335732436965*^9}, {
  3.74033576325631*^9, 3.740335778533731*^9}, {3.740337240301402*^9, 
  3.740337287935329*^9}, {3.740337391939878*^9, 3.740337505952931*^9}, {
  3.740337538914236*^9, 3.7403377148639812`*^9}, {3.7420712622404413`*^9, 
  3.742071364728339*^9}},
 CellLabel->
  "In[402]:=",ExpressionUUID->"24a3961e-c0e1-4a4d-908b-8bb76c4ad71a"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVz3881HcAx3Gi1bSdrh+4mjxOzko/JxW6vCmpkTZSVKJJNP1u9kg1DyOa
cEM8sPyIonVZ9D1HPyjGxRJxfnSu/Dym4+6ccM5J91n74/V4/v1iBpzxPDZL
R0fH/VP/63pMKqwaOuZgA6NhQpTQ377kbA/DGR0eiNVMK7HhZkZWCcMLIvq4
5bhKCbdGES+bEQhuwUTwoEwJ70D10+uMUDjbqz9rFCnRte637RxGNEpEy8wy
i5XIXfzd1ThGKrqq15k4+CsRObfk62uMfDi4uEc/fjYCnwN5xaPv+Qhabpea
FKjAPBLpu3NZJabk4jAmSw6Wx4i0Jl6ATN0l9qOjw7jwyg4ZEy9wcoNaJ5Y7
BGM+vVtXtwlmJwrPhkdIUSbZ3tDEbsHzzabJOTveoToke+kBeRuk7jWDp5YO
QmW51fD+KRFu0tS1d2j/YpamcP5S1hs4JlpL6lT92ESOlO0t6kSd+s2hMo0E
DdE2r2qtevDKwW639RcSmCXJNNyRXhwV5UjYi/sgU/d0t6+XQGQ2Z32LbS/y
h8vrab/3w1iqT9vP7QbN9E/lwMAAHmT42lRpO5HwY2lQrsUg+Bu0lXFX3mLS
sXDgeMQ7mAyVXdadESPUWsA3qpHCVssxjM3tQE+RIF7IHEZR4DWOwl6EDyFt
mSsvyeDEu/uZ00g7VjnN0QaVy8Gd8u8vqWvDzlvMYMp4BM2dxqFdGa24YOpv
3uerBHVvl9VUQgtWy/fNE7mPQuKlzipIEWKh4ehcwfQoDOkrNEEpzdCvzCxe
nvUeZ2TpKQYBTThhUy7+3G0MowaW7YLkRhR+G5D7bHIMwoGD3wf3v4RKtmT+
YNo4JryMUpKC61G6d6deqvMEHHf4n5np+wcRu2Ju8gcn8AjCVnZcHZhdrh23
Y1Qw8rMxmXathf3m6FSG9SR8ri5U+Os9h++yJo1u6yTkr9mLL0lqoKrnSM5G
qsHqwFD6k2pk6PuFelpMITDRLpoq/RsLu0tvzRJModYnJzW5pgqzwyO97M5p
oG8QFdaWVgkdrl+xZME0srKvKQ71PcX5G8WcBdXTuK53+F09swJPV8XOpZ/+
gHSHqLePrjwB3fX86ijaDPa99BsRGT1G55rm1osVM3DMPGXBznuIBzmwGPD7
iBTHHWziXYbDxZvoptqP8Ek1L0m2LMWvMXmRnfe0oJ8M6eYoSnBfappJ201w
/ef7KwRiHmKzY4507yHYvGrMxLidh0BPBavIgyDN2e+bE808fFVR8cDdm8BW
J15sVMdDXOKh2oQAArmVG7nM5+H4pj/eG1wkkDYY/BCeyIN59KJdc+4QGPDk
UQddeNDa/vKl6C4Bi6MnFzrxIFb0t9wpJHCVuoS6buUhybvksAtFEL6H3edg
wwOx8vwppoJg/8ptrI3mPHQKE3P0WglMEitMvLUUHl1VH21tJwibrdzbq6GQ
usV/5e0OgjXlY9wQFQW3grX8bd0Epxd5F0TJKTwJa3wROUQwu3FcWPmGQtqa
jYkecgJxwvxOj9cUzkmyvJhKgr9kzdoBIYUVu0/2VE0QGJexOLQXFPR12/KT
1AQ3Hq+dyhdQ6C3dEnJk+tN/vOASu4pCRcjtdes/EuhfzFvUXk4h3WyeihCC
1w0Rz08/pPAfaZuDWg==
          "]]}, 
        Annotation[#, "Charting`Private`Tag$153943#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwllH081HccwD2GKUWtHKk51ErUerCZ8VmdUmLNQ7Na1JAiayqvxJTOKCmp
ptKDkFINd9SxFvUp/M7DyjkPu+jc6RwuT3e4c5z41l774/16//H+/20d/Kvv
Xh0tLS3vj/xnz70y/vN3e92iFhurCCGox7CIEtPc4f6sieHfpgiuyc68+Yjm
D6gXGDKmIbj1leBhFi0UwoqFl3pUBANC1U8v0aIhpkbPhdNPsGPlaUYaLQnW
s4aT9AUEcz7ddiqVlgG6a4y6TxUSZBo+WnqGdgdSy5taXPwI/rgjl60Y5oCX
Y8EaecI0GhPmLo9FCPO32wesuj+Fdj5Dsqqz1aDv3vd6gvseYxqcIVNZB83t
o3lGNZO4gGMq0tbmgUCTszOsUYNlEsZL3jdNEPfQ7mIdTmBlRJbljoEW8Kq9
Ny+tZBxVS1xnF/0iAOPmFNb3pWrUmSiYY2nXDuEnxA7Zd8fQiewp82MJ4fRi
A3PXAhW+TFrbwF0uBvdXBnpGT5S4+EL/xIOhTphBz0lwfDKK/WqxqHWVBET/
rH/4gj+Cd/rK603Od8G1ImZtWMcwmljdk0ulUigx6Oz5S6XAc+GlYTm2PWBE
7+B72ylw7NsC6f6EXugVhscVXh3C6NXVnPlVMjh/+drMmWaDKGZVn+Vb90Hg
UcgtO96PkxEtN5bF9YPr5aOJHJ0+tF9vMB1WPgCmY22F6mIZety23leyYAj4
McdCn/r1YozVbvrbXXJwXBL3h7NVD64Y2G4s8FbAeJ9F8KRGinNnKwyrNQrw
exMpP87rQj28wba5OQxabtOVKkqCB9aWtxltHYF92xndPM5bLNgSnPNsbARm
1S+gd5Z1oqrfYk7PlVGoaOiWhhaKsdTPQzfDXQnpVb1mCaIOTNicnM3pUUKI
jrP8s01CtO7wfJ2XrAJLOW+TU307fv1lUgZt9RiISsyLqhhtuGsRb0K7eQws
/i74Qd0nQFV9miSKqYYa2QuH0DP/YqZeULSv7Tg8Y30xsNGnFeeKSm/rVI+D
c5uZU8DKFtQ/zvR3PjQBt3WLugb1m1HrQRBbYqaBmkUm7RcJHw9fZ6eZVWqA
MaOvTD3SiE/tUwxND05CSsrUiywlD009D69INHkP2bGt123cGlDo0NgcW/Ee
ipy25Y3Gv8TiW2ArDZoCqf+9RrmiHgPZTqZW01Mf++b4SGYdnkzOZQr/nAZ6
h0dDvmEtFsmsbph4EfD3mEm7UsHFlKzkPaLvCEgO+qUry7gY6jtox/IhIB9M
2e9fwsWFFRXF3gEEOoXhG8zzuZia/hP3XDCBkz3s1OJ0Lu53ujb8SSyBY/1s
uk0IF+lJ8zYb5BMQx0Vamhhzcfqr+FmC+wR+rnT2zNTnYttgV1N+AYE0Mx++
jRYXLwQ8CtxUQuCAYG6vm4pCstz3SHIFgdWu0qXJYgqF/PRbus0EfGoTy3w4
FD4+pQ5pbiVgK9jIGGZRmOGye1neawId5vY2lx5QuPWuI2eDiMBFMHsjuEXh
k2Ov6pjvCHSHeNOPnKHwisO6dJ8BAny/hWCVROEhyU1/azmB6rOxhbUnKPzc
K1L8XEnAXZQRYxNNoZ52y50LagK06aKWpoMUdpa6ROzREEiMMmb+Hk5hRUTe
ylVTBGwe74xfF0rh1f+/BbkBW7iyIAo/AJMnsSw=
          "]]}, 
        Annotation[#, "Charting`Private`Tag$153943#2"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVznk01WkcBvDf/b2abpyEzDiX1BAZIqZ1lPH91hXZmnCbdBKS9aZGy4w4
bRraZJjGVLYQylLdylIhFU7FIaGo5uYWBuVmyRbJO+/88ZznfP55zmPg94t7
AM9xnCvL/+0U0NN4/12ArXFY5DRGVBHrhilEdpDcsjFotYDDJennUwtFEgie
MRZ0lOfQub71ZprIHxquhK4i0zjc5D9294xoH7gOGppxqhy+tjwujhNFQ1lp
7pLu2RxmfP3TsVOiRBDfcw+RmnAYJSw0OSnKBu2QUh1HVw49N2fKBgaL4Hbd
gRRM5lCNRnk5zL0H5uYj9jPkHBq79fVUxVbD/DtLTBfoCDD8iTWcH66BXXsl
7y+4CVCnSLNNIGiAktwjXTa/C7CkXVzXYNMExf/aOQqKBFgpTdPbrHwGberV
CcsUAhxZ8OOsqztbIStQNlxAeOTHCzT0jF/BzA33E3xMeFxOfUs8rskhXa/7
QdBaHuuilz55aKYAbUfrnV/58jgvoXc8r+8NdPVsjpseyWPvmKLtuVU7dKZk
7WiJ5zH7fVmt+h8dIKo9+nRmDo/q+pf7Ozs7QfWx3WT+LR5PhxQHZhh1waE/
lVG2j3gcxYLO4MPdQGpK8/xaeNy3uLrom6oeSAqyLBN28Ki4Vh3baPAe3pyb
VefYz+Nn6bMU08he2F716DdugseFq6dPBZYpQeEaoTXIE3S4aBB0Q6cPnjjM
PpOsRjBc38fwrVc/KGOtC5u0CJorN6q1ug5AYgUpWSgiOHvWgLB6YgBq9PO1
POYRVLmXIpufOghct37IXiOCO5aWvZzh/BF21bebBZsSLHD0y6gY/Qi9nk7C
MguCI726Gl1nh2CbZdM/ku8JFns4kES7YahYlPb26VKCh9fFpBd1DUPoq1SL
WysIGrx2epEVMwLdJ311xSsJrlwRnShaPAq3GjwyS20Ies1tGBc0j0LSsRHT
x7ZsvzauPSxqDIZsXSarkOB5Fe997kafIHrlVw7SNex/W/FFvvoTdNhrv5SL
CU47GCWx3j0OevmHvMVrCXJ53rJ2rQmQH8yI22lPcE+yLE6rcgK6Jf2ecQ4E
7y48IdTc9Rl0vX/WOLGOoKbTHvOj6pOgU9ua4elIUG7xtDmifBLWXN5tZehE
8PoFMOr0/gLZG6sqa5i3ypZr6k99gdo5uXVezgSPxGRGyfOnQFzQotPLfLVH
P0XdhUJ8fXDoNheCJ9JifNvWUxiyifDZzuzv/sH4mhuFnG/PuAUwzykvv+66
iUKQuWJxCPOp+C0PT/tR+DVv6F0Yc/DypEHVCArbXoWZHWE2jNZeN/0ShXBe
41Ma89QPB2a25lKQbtCtT2d++aGj6VIBhWGhTWYmc8Kmwq32NyhkHHhkn8NM
zdz3xpRTMKlUPX6FWd4Yf4E0UxD758hLmW8fG9ve/JxChNWWrHLmxFU+plkv
KPy9xzKkgtk5Z1HRmjYKEr1lHx8wl+6vr4l6R6HU/cH4Y+azFsvi3ZQU+gzC
79Qy725PlRj0U7iuXL+/jvk7l1DF/WEKN1cEDjUwqwieZSeMUfBKuiRrZH5T
vErqO0Eh+I7qjmbmcmmWpdUXCrHCv4yfM5+bpzZCKYXIMVC0MP8HDcwvSg==

          "]]}, Annotation[#, "Charting`Private`Tag$153943#3"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"x", "u", "k"}, "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.740335718625823*^9, 3.7403357331348553`*^9}, {
   3.740335764120707*^9, 3.740335780897204*^9}, 3.740335839044951*^9, {
   3.740337275017591*^9, 3.740337288364552*^9}, {3.740337393153433*^9, 
   3.7403375066258783`*^9}, {3.740337539615746*^9, 3.740337627277361*^9}, {
   3.740337663562518*^9, 3.74033771557026*^9}, 3.742069243911243*^9, 
   3.74207089422234*^9, {3.742071259218342*^9, 3.742071365313921*^9}, 
   3.793843473534165*^9},
 CellLabel->
  "Out[405]=",ExpressionUUID->"3fc3ee30-bf5a-41b2-ad8b-3d7e013a5734"]
}, Open  ]],

Cell[TextData[StyleBox["Export data",
 FontSize->16]], "Text",
 CellChangeTimes->{{3.707347555181609*^9, 3.707347582594514*^9}, {
   3.707442063493147*^9, 3.707442072299552*^9}, {3.7075124401671667`*^9, 
   3.707512443443941*^9}, {3.7075150626652737`*^9, 3.707515067495439*^9}, {
   3.738688170771207*^9, 3.7386881739103823`*^9}, {3.738696568492777*^9, 
   3.738696575810809*^9}, {3.739025766420356*^9, 3.739025770504059*^9}, 
   3.7392778485601177`*^9, {3.793843412071097*^9, 3.793843414390931*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"baf84cca-3ca3-4678-a37b-988c0a2fbc69"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dt", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"amax", "[", 
      RowBox[{"dt", ",", "\[Epsilon]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Epsilon]", ",", "dt", ",", "1", ",", "dt"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"JpertPoints", "=", 
    RowBox[{
     RowBox[{"Cases", "[", 
      RowBox[{"p3", ",", 
       RowBox[{
        RowBox[{"Line", "[", "data_", "]"}], " ", "\[RuleDelayed]", " ", 
        "data"}], ",", 
       RowBox[{"-", "4"}], ",", "1"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<firstOrderUnstable_dat1.dat\>\"", ",", " ", "dat1"}], "]"}],
     ";", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<firstOrderUnstable_dat2.dat\>\"", ",", " ", "JpertPoints"}],
      "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<firstOrderUnstable_dat2a.dat\>\"", ",", " ", "JpertExtra"}],
      "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<firstOrderUnstable_dat3.dat\>\"", ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Jmin", ",", "kstar"}], "}"}], "\[Transpose]"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.739027247765677*^9, 3.7390274278585367`*^9}, {
   3.739027845825184*^9, 3.739027847697414*^9}, {3.739202722559286*^9, 
   3.7392027250183372`*^9}, {3.739541471250705*^9, 3.7395415494811172`*^9}, {
   3.739541941433079*^9, 3.73954194505169*^9}, {3.73954215925177*^9, 
   3.739542259738515*^9}, {3.7395429093684797`*^9, 3.739542993800324*^9}, {
   3.739544429459248*^9, 3.7395444486939096`*^9}, {3.73954662224107*^9, 
   3.739546624361843*^9}, {3.793843352524991*^9, 3.793843438344205*^9}, 
   3.793990290195533*^9},ExpressionUUID->"de5f3c9f-8d10-47a1-9a37-\
8cd0b44059e5"]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{5, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (March 13, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"ae69a627-8a38-4c9b-a817-2caceb274e95"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 315, 5, 67, "Section",ExpressionUUID->"0c678526-7571-4f72-988c-4e297b88b373"],
Cell[898, 29, 242, 5, 30, "Input",ExpressionUUID->"10839865-d360-4970-8592-a4e792fe2b32"],
Cell[1143, 36, 568, 9, 52, "Text",ExpressionUUID->"3635dcc2-8c6f-4308-90ef-0db6627aa92c"],
Cell[CellGroupData[{
Cell[1736, 49, 1719, 45, 73, "Input",ExpressionUUID->"e94cb34e-a602-4292-bf20-8441d52e7610"],
Cell[3458, 96, 661, 18, 38, "Output",ExpressionUUID->"1226b677-dba8-4dd5-bb59-53503291ed50"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4156, 119, 700, 18, 33, "Input",ExpressionUUID->"3e3f5d21-7db6-45cd-9a95-a4bb7ae34813"],
Cell[4859, 139, 1506, 26, 55, "Output",ExpressionUUID->"50b07619-48e2-44db-8440-0264bb9d16b5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6402, 170, 976, 25, 30, "Input",ExpressionUUID->"2dab23cd-efa0-4f4f-b31a-ef460f11071e"],
Cell[7381, 197, 1689, 30, 42, "Output",ExpressionUUID->"d905319e-65d3-4f4f-aa7e-60399f5c867b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9107, 232, 471, 13, 30, "Input",ExpressionUUID->"239ddb15-37a9-4e56-b374-020e63ad5df1"],
Cell[9581, 247, 841, 18, 42, "Output",ExpressionUUID->"a4bce152-7c48-4e44-b17c-207c3670a2f3"]
}, Open  ]],
Cell[10437, 268, 527, 8, 52, "Text",ExpressionUUID->"c64e4ee2-78e2-43ba-9f4b-7d9d188a2283"],
Cell[CellGroupData[{
Cell[10989, 280, 1524, 40, 111, "Input",ExpressionUUID->"25f0bf31-1ef2-44e9-beb6-d936ad918a37"],
Cell[12516, 322, 1391, 23, 37, "Output",ExpressionUUID->"50c3c899-ca39-4dab-a77b-8fcb1650298a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13944, 350, 574, 14, 52, "Input",ExpressionUUID->"19ec6624-d4a9-4750-a526-0c0062320bb3"],
Cell[14521, 366, 383, 6, 34, "Output",ExpressionUUID->"71bbee86-2e4c-4117-abe7-4ee684ca934e"]
}, Open  ]],
Cell[14919, 375, 670, 11, 52, "Text",ExpressionUUID->"33f04ab5-4ec8-45ca-ac8f-c35d50c224aa"],
Cell[CellGroupData[{
Cell[15614, 390, 383, 10, 30, "Input",ExpressionUUID->"ca45bd7d-fb9e-4894-a1ce-e09e9290bdf4"],
Cell[16000, 402, 3387, 99, 101, "Output",ExpressionUUID->"f97cd952-828d-490b-a207-5ce2a8d1382d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19424, 506, 1037, 26, 73, "Input",ExpressionUUID->"f4fc37ab-96dd-4337-b0f7-f0b9d3396897"],
Cell[20464, 534, 1555, 40, 88, "Output",ExpressionUUID->"2fd3799c-6291-4a24-89bf-748073becdac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22056, 579, 729, 19, 52, "Input",ExpressionUUID->"1e0e03f0-b7fa-4e25-8de2-f36e62dc7a3b"],
Cell[22788, 600, 442, 7, 34, "Output",ExpressionUUID->"72eabb73-4950-4112-8010-c204c9a94e0d"]
}, Open  ]],
Cell[23245, 610, 2284, 58, 115, "Input",ExpressionUUID->"31fd05f3-d84b-4a5e-8c3c-80e6ba12a1d5"],
Cell[CellGroupData[{
Cell[25554, 672, 240, 5, 30, "Input",ExpressionUUID->"a747ecc0-dcf2-4527-a210-8472c42affad"],
Cell[25797, 679, 426, 9, 34, "Output",ExpressionUUID->"91ffe297-5f75-48d9-96a7-42db1c962ca8"]
}, Open  ]],
Cell[26238, 691, 931, 21, 30, "Input",ExpressionUUID->"7efad79a-0207-4f13-84ed-f2b34767a93a"],
Cell[CellGroupData[{
Cell[27194, 716, 1157, 27, 52, "Input",ExpressionUUID->"45b49e6d-f66f-40e9-bc10-27467a1f5492"],
Cell[28354, 745, 2670, 64, 251, "Output",ExpressionUUID->"a1c148ea-1586-446e-a772-9cd3c3e92fae"]
}, Open  ]],
Cell[31039, 812, 700, 11, 51, "Text",ExpressionUUID->"960364dc-d5d0-497f-a5be-cf0935dd0a10"],
Cell[CellGroupData[{
Cell[31764, 827, 1157, 29, 53, "Input",ExpressionUUID->"2e5b3a31-397f-40ca-aecc-428328ae046f"],
Cell[32924, 858, 1522, 23, 34, "Output",ExpressionUUID->"094af5ed-a1d4-4ea7-ac5c-c333d4dcd06d"]
}, Open  ]],
Cell[34461, 884, 701, 16, 33, "Input",ExpressionUUID->"1ca59dfe-066d-457a-b249-a12a5604f4f8"],
Cell[CellGroupData[{
Cell[35187, 904, 621, 16, 30, "Input",ExpressionUUID->"bbabafe4-edc1-4cfa-8cc8-ccbe7dd14fc4"],
Cell[35811, 922, 331, 5, 34, "Output",ExpressionUUID->"3e815f4e-4bd3-4ef4-a2b2-d3496381dcdd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36179, 932, 420, 10, 30, "Input",ExpressionUUID->"e9d14b4e-377d-49c4-a3cd-0a74ea17b583"],
Cell[36602, 944, 424, 10, 34, "Output",ExpressionUUID->"5a0068be-a45d-470e-ab5b-aba0b9de915a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37063, 959, 1044, 23, 30, "Input",ExpressionUUID->"db8ab008-36ce-4608-aee3-03f98f5036b3"],
Cell[38110, 984, 7209, 140, 244, "Output",ExpressionUUID->"4e73c34e-6792-4ad6-bfad-3c47c45ea67e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45356, 1129, 519, 12, 52, "Input",ExpressionUUID->"63523638-d53b-444d-aaac-d0b4bcf8f125"],
Cell[45878, 1143, 366, 6, 34, "Output",ExpressionUUID->"b76c5ea2-d7ea-48fa-aa63-e4bba4f9f0df"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46281, 1154, 519, 13, 30, "Input",ExpressionUUID->"10fe4c64-ca5f-4092-8ae2-99482c423fbd"],
Cell[46803, 1169, 7016, 134, 238, "Output",ExpressionUUID->"26ab5077-1d61-4719-bb89-7a5fa868af88"]
}, Open  ]],
Cell[53834, 1306, 662, 18, 33, "Input",ExpressionUUID->"e8d4d2e8-9d3a-4304-9002-5fbc36d3ba60"],
Cell[54499, 1326, 1119, 24, 30, "Input",ExpressionUUID->"1215d6bc-4389-49e3-981f-909f600aa680"],
Cell[CellGroupData[{
Cell[55643, 1354, 773, 14, 30, "Input",ExpressionUUID->"bd86c3a1-8744-4a59-b2fc-da9789e18c77"],
Cell[56419, 1370, 12080, 223, 237, "Output",ExpressionUUID->"280b40da-39dd-4965-98e3-e69d2d12c9c8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68536, 1598, 1246, 31, 52, "Input",ExpressionUUID->"ae7c2a9f-66f8-4572-a22c-2a8001c0c2f6"],
Cell[69785, 1631, 122342, 2042, 260, "Output",ExpressionUUID->"48eb6a62-ae9b-4b63-a6c9-81e216023364"]
}, Open  ]],
Cell[192142, 3676, 604, 9, 52, "Text",ExpressionUUID->"a4b7e463-b7ec-47eb-a1d8-e72f8845f0e2"],
Cell[CellGroupData[{
Cell[192771, 3689, 2327, 67, 96, "Input",ExpressionUUID->"24a3961e-c0e1-4a4d-908b-8bb76c4ad71a"],
Cell[195101, 3758, 21401, 426, 238, "Output",ExpressionUUID->"3fc3ee30-bf5a-41b2-ad8b-3d7e013a5734"]
}, Open  ]],
Cell[216517, 4187, 588, 9, 52, "Text",ExpressionUUID->"baf84cca-3ca3-4678-a37b-988c0a2fbc69"],
Cell[217108, 4198, 2192, 51, 262, "Input",ExpressionUUID->"de5f3c9f-8d10-47a1-9a37-8cd0b44059e5"]
}, Open  ]]
}
]
*)

