(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    223832,       4298]
NotebookOptionsPosition[    219148,       4218]
NotebookOutlinePosition[    219545,       4234]
CellTagsIndexPosition[    219502,       4231]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Oscillator disturbance rejection for uncertain frequency using optimal PD \
control  (Problem 9.4)\
\>", "Section",
 CellChangeTimes->{{3.51414593360565*^9, 3.5141459440499573`*^9}, {
  3.706196596632979*^9, 3.70619659814931*^9}, {3.7067260017656097`*^9, 
  3.706726022515807*^9}, {3.7068300493109093`*^9, 3.706830050973321*^9}, {
  3.707347293672677*^9, 3.707347316092437*^9}, {3.708029242547611*^9, 
  3.708029245115203*^9}, {3.708125634822151*^9, 3.7081256353468657`*^9}, {
  3.793845067536078*^9, 
  3.7938450709892597`*^9}},ExpressionUUID->"1ad7a69b-0b66-40ee-bfd9-\
1fd1e5091f36"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[3351]:=",ExpressionUUID->"f25dd9e2-712c-49ce-a33e-9aa7a9ce26c5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
       RowBox[{
        SuperscriptBox["\[Omega]", "2"], 
        RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", 
      RowBox[{"u", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "Kp"}], " ", 
        RowBox[{"x", "[", "t", "]"}]}], "-", 
       RowBox[{"Kd", " ", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}]}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xs", ",", "us"}], "}"}], "=", 
   RowBox[{
    RowBox[{"DSolveValue", "[", 
     RowBox[{"eqs", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], ",", 
        RowBox[{"u", "[", "t", "]"}]}], "}"}], ",", "t", ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Kd", ">", "0"}], ",", 
         RowBox[{"Kp", ">", "0"}], ",", 
         RowBox[{"\[Omega]", ">", "0"}], ",", 
         RowBox[{
          RowBox[{
           SuperscriptBox["Kd", "2"], "-", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{"Kp", "+", 
              SuperscriptBox["\[Omega]", "2"]}], ")"}]}]}], "<", "0"}]}], 
        "}"}]}]}], "]"}], "//", "FullSimplify"}]}], " ", ";", "  ", 
  RowBox[{"TraditionalForm", "[", 
   RowBox[{"{", 
    RowBox[{"xs", ",", "us"}], "}"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.70899897573654*^9, 3.708999019387033*^9}, {
   3.719208656765266*^9, 3.719208663443777*^9}, {3.719208709004644*^9, 
   3.719208765177524*^9}, {3.7192090228301363`*^9, 3.719209025039281*^9}, {
   3.719209263522663*^9, 3.719209269743526*^9}, 3.719510427255804*^9},
 CellLabel->
  "In[3352]:=",ExpressionUUID->"d800d717-3dcd-455f-b846-c3f04f14e4a7"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"Kd", " ", "t"}], "2"]}]], " ", 
      RowBox[{"sin", "(", 
       RowBox[{
        FractionBox["1", "2"], " ", "t", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{"Kp", "+", 
             SuperscriptBox["\[Omega]", "2"]}], ")"}]}], "-", 
          SuperscriptBox["Kd", "2"]}]]}], ")"}]}], 
     SqrtBox[
      RowBox[{
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"Kp", "+", 
          SuperscriptBox["\[Omega]", "2"]}], ")"}]}], "-", 
       SuperscriptBox["Kd", "2"]}]]], ",", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Kd", " ", "t"}], "2"]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["Kd", "2"], "-", 
           RowBox[{"2", " ", "Kp"}]}], ")"}], " ", 
         RowBox[{"sin", "(", 
          RowBox[{
           FractionBox["1", "2"], " ", "t", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"4", " ", 
              RowBox[{"(", 
               RowBox[{"Kp", "+", 
                SuperscriptBox["\[Omega]", "2"]}], ")"}]}], "-", 
             SuperscriptBox["Kd", "2"]}]]}], ")"}]}], 
        SqrtBox[
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{"Kp", "+", 
             SuperscriptBox["\[Omega]", "2"]}], ")"}]}], "-", 
          SuperscriptBox["Kd", "2"]}]]], "-", 
       RowBox[{"Kd", " ", 
        RowBox[{"cos", "(", 
         RowBox[{
          FractionBox["1", "2"], " ", "t", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{"Kp", "+", 
               SuperscriptBox["\[Omega]", "2"]}], ")"}]}], "-", 
            SuperscriptBox["Kd", "2"]}]]}], ")"}]}]}], ")"}]}]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.708998948340701*^9, 3.70899902535888*^9, 3.7192086738927383`*^9, {
   3.7192087750927753`*^9, 3.719208786081956*^9}, {3.719209270918392*^9, 
   3.719209273710705*^9}, 3.7938451089905443`*^9, 3.823229641062549*^9},
 CellLabel->
  "Out[3353]//TraditionalForm=",ExpressionUUID->"5246ef0a-6470-4b22-ad22-\
3bd477135005"]
}, Open  ]],

Cell[TextData[{
 "Both over- and underdamped responses give same functional form for cost \
function j, so the form given here applies to be both cases, with Cos \[Rule] \
Cosh, etc. for the overdamped case.\n\nAlso:  time has been scaled so that ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Omega]", "0"], "=", "1."}]],
  CellChangeTimes->{{3.7074511749848957`*^9, 3.7074511749989758`*^9}, {
   3.707512413582973*^9, 3.7075124297688007`*^9}, {3.707513664070827*^9, 
   3.707513670192202*^9}},ExpressionUUID->
  "67f809a5-acf7-4e69-b5eb-ef3a1f3a61c7"]
}], "Text",
 CellChangeTimes->{{3.707347555181609*^9, 3.707347582594514*^9}, {
  3.7077445651667347`*^9, 3.707744674574999*^9}, {3.707765307804101*^9, 
  3.707765329640802*^9}, {3.708029769057939*^9, 3.70802977507415*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"356da822-c1c7-4220-8523-3550a19b11f4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"J", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["xs", "2"], "+", " ", 
        SuperscriptBox["us", "2"]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Omega]", ">", "0"}], ",", 
        RowBox[{"Kd", ">", "0"}], ",", 
        RowBox[{"Kp", ">", "0"}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["Kd", "2"], "-", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{"Kp", "+", 
             SuperscriptBox["\[Omega]", "2"]}], ")"}]}]}], "<", "0"}]}], 
       "}"}]}]}], "]"}], "//", "Simplify", "  "}]}]], "Input",
 CellChangeTimes->{{3.707341846521599*^9, 3.707341855081637*^9}, {
   3.7073418852081127`*^9, 3.707341890174963*^9}, {3.7073421659745617`*^9, 
   3.707342186724824*^9}, {3.707342286101461*^9, 3.707342295293129*^9}, {
   3.70735156820334*^9, 3.7073515711140547`*^9}, 3.7073516300176973`*^9, {
   3.707744729799514*^9, 3.707744741438797*^9}, {3.7080293141793337`*^9, 
   3.7080293164994907`*^9}, {3.708029647271324*^9, 3.7080296565086117`*^9}, {
   3.708029793876317*^9, 3.708029803986548*^9}, {3.708999060935377*^9, 
   3.708999067255313*^9}, {3.7192092856790037`*^9, 3.71920929276838*^9}},
 CellLabel->
  "In[3354]:=",ExpressionUUID->"d82c6715-e511-44fa-91a0-b1dc0dd6078d"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["Kd", "2"], "+", 
   FractionBox[
    RowBox[{"1", "+", 
     SuperscriptBox["Kp", "2"]}], 
    RowBox[{"Kp", "+", 
     SuperscriptBox["\[Omega]", "2"]}]]}], 
  RowBox[{"4", " ", "Kd"}]]], "Output",
 CellChangeTimes->{
  3.7073421936003838`*^9, 3.707342320761639*^9, 3.70734290642386*^9, 
   3.7073474401565332`*^9, 3.707351565418179*^9, {3.707351612324882*^9, 
   3.707351632274508*^9}, 3.707442046904463*^9, 3.707443665268239*^9, 
   3.7074511014707813`*^9, 3.707476903950626*^9, 3.707477056230034*^9, 
   3.707518471671357*^9, 3.707744721916348*^9, 3.707744814549406*^9, 
   3.708023161517009*^9, 3.7080232306493998`*^9, 3.708025662399551*^9, 
   3.708029338512516*^9, 3.708029427419305*^9, 3.708029846116081*^9, 
   3.708122899033781*^9, 3.708251618373055*^9, 3.708269326751933*^9, 
   3.708279148884211*^9, 3.708284295073801*^9, 3.70830287830835*^9, 
   3.7083605278211927`*^9, 3.708366101482759*^9, 3.708999110341226*^9, {
   3.7192092839362717`*^9, 3.7192092999523153`*^9}, 3.793845112569014*^9, 
   3.823229650418331*^9},
 CellLabel->
  "Out[3354]=",ExpressionUUID->"92f5dda6-ff3c-45ca-b02f-d6fc6d679240"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"J", "/.", 
    RowBox[{"{", 
     RowBox[{"\[Omega]", "\[Rule]", "1"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"Kd", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Kp", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.707341945706374*^9, 3.7073420720919113`*^9}, {
   3.707342224301342*^9, 3.707342243741317*^9}, {3.707342353297611*^9, 
   3.707342359361309*^9}, {3.707512795442445*^9, 3.707512852568358*^9}, {
   3.707744823732853*^9, 3.707744971488409*^9}, {3.707745133349111*^9, 
   3.7077451945458517`*^9}, {3.707745227161552*^9, 3.707745234154202*^9}, {
   3.7080298675763597`*^9, 3.708029922333807*^9}, {3.708030055114539*^9, 
   3.708030074678879*^9}, 3.7089991218486423`*^9, 3.71920930646278*^9},
 CellLabel->
  "In[3355]:=",ExpressionUUID->"538cce0c-b70f-4cbf-acfa-281eb7868ba8"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJyEvQV0lcfzPxy7SZBixaXFijvBZR7cneLuFHeHoMXdiiY4BHe3CBES4q43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    "], {{
      {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlk1slFUUhm/boZ1+znzT6cwgAVsYJGlJHIaVborRlX8RExetbN31h7pQ
d6Bu1ZhqsF1DpJuatCsV3JjQDbRWMKkhjkYS6IRQ13Rn9H08b6OL23vnu+f3
Pe85t82333lzvjeldFOrT2tHf/oKKQ3r3CmmNJml9Kv2u/o9pfMx7atZnI/q
PKL9cfaf3kZv6PId3arOV4d0PpBSsZ7S54MpLWhtpZDnjA72tlPY72jdkL1T
6PaktGZf3w+kdE2rq7sd6d0fCLlrtZR+0H67GjaGbWdGetNacpv+kI812Tqt
c6EQdrac01u2/53tYO8rreuSebKS0qvllH4XBpv1wIJc8fNpKaXXdL6Qh51V
50BO5Dmhu0vSuSKdL7X/pPja/fKrvSidvxXHrUZKc7LTkt7z2pdk44H89inW
ZeMGfuRJvtQhUzwLur8om5OVwHi6FPmd0bmtdehg5FzLo47EnXR/XNucfDS1
n9c+nwUmKz3xm/vuYOC7Lp8j5ajBJ/L1hfMCt4ey/Y397faFLHUD1+vG9pFk
x7KoIz7P21fTNao51jl//ysP/KkDNskdu4fz8NVSLAcUx5hyGVN+zynnonx9
WwsO7mXBjQ3J/CaZVyT/cy10zzYCB76D15+KbXcw7katC2c5X7IdeAJHqfeV
nogNLp04GDJTwv5QJXh5tRbyj617JA+MnsojbvwQy2Xtm72RO1ihg/zNgeAG
d280Qhcb4A7+o7Ixl0cNPtD9+4WQAX/4e84cbvWHLewsmtt33bP0ERyoy849
3T9sBNfgHNxCFh24d6ER/J3Ng3vYOGVfU7Z5Uvt4Flyk1tSSeI4q1mV9y6S7
WYsz32bysIntj7PoE363nDfYvKS7bZ3LeXCnY7+3a8HRE+Xg0Zy5uu2ZBZ+I
fcnxk8+i44Qjz/THnNnzvKLWxMAd39ueGXATzt0wn9fc12A76/g/bITdY47t
9XL4/LoUeOK75fkzm0X++CAGcgSzk85twb8nUuQ77u/YgefY7VInerIR92OW
x+4vvYHDcB79Tt/fqQaGpTzyQxffzOOO+T9pDJgL9AH9gM2hPHC+U4sZwCwg
l4lS+NrS91vVsPegEXOx49lC3juWH7V9fBEH8VBbZhY5PyHMNqqufTX0iYV6
LtbDFz733JP0CDVvu0bEDOfgG9yhP+mp44Xg9v6sZ297PuLmWe0fNWKOXWzE
HAHnp8vxVjQ9l1bdK/vvSfN/b8qy5yj86ZpDS+4dMIDXzI0tz3TwWK6Eftuc
4b5gGfhY8JyZ95xccdzkiPyG+4NYmCW7zh272H/BbxHYTlhv1zU96/eCdwOM
R/xer/sdhev99Zi5Ryrh47LxhL8zfkN5x8AKbvIbvGrGZtr9CPbMpjN+B8GI
2LvuN/rn5aF4+4qe95yxd87zCs4fLkdNf6zGnMLui6XgEfOQfnzPbxNvFHEg
vx/XjOMZcF7kt14NjHi36Wt0k7kO3swYeLfi+sIrZvK/cXiOMc/g1D3P3ncL
0Xen/T8G/ON+vBx3n1WiXx+5Fv8AlUMz2A==
          "]], PolygonBox[CompressedData["
1:eJwlk8tvTHEUx8+odh7mzp0xd6ZSUkETmihWSHRBYuFZiUXF1pJmLLDz3NkI
UvZKGwlrgo1FN53qlAWbEhZjEP4Eafh8812c3HN+5/U933PulnMXT7fWRMQB
ZC2ytxxR4/u5ELGYRZxIIjZjny1FpM2IQaSF/iwXUa1EHE0cu4K0iZ9oRLzA
95Oip9CLxPAc/yh+pBoxSn6P/PG+iPP4lusR3XzEGDFT9G4hW4n9Sv56/Lew
O/heE/OE2JS3PWEMwiJMwtZHz5NgeUCzmYJrqna74d5v6bdK7mHqjZP/pxjx
C99I4lk+0e8huZsqxn6FnF34DpaNrUf8D+JvNIz9HvZN9GsN6/eRKXKbKbH4
p8E0AraXYCjkPbNmH0w9yyvkMb4mbxdK5khcvYP8sYGIR2BaQF8Hhrvox6k5
j/287Fm3M2N/5hjF7iSnXXNN1X6DbEi9E+3mC3KMWu9r5mKGnCHsHDHz2JP9
EXNVz6hZ9SbftsS9xOl0Zk7EzTc4ysD7nfhu0TPuA9tf7OGSb2iS/Nm6sYgT
cfOUmKD3LHKZWqvEj5Y84wR2iZpzOXMibq43zK1uQLdwG1kJ5yh3OHGtj+D5
UPNOtVvd4JD4zDy7eqp3veLbusQMO8gtZJ79N/jy6J26b0EYltD3k7OQ904W
qd9Bdg/4Tb47qWvpJnWbVyvelW5Mt5ZUjE3/kP6lbsO7Emc99ENlc6mb1+2f
SX074lBcLtW8K/VcRt+YGqs4EBf/AbsOfqI=
          "]]}]}, 
      {RGBColor[0.27572497046125716`, 0.4006062196509211, 0.6569859598566412],
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmMVtUZxu83A/PtC8y9WHGpClgW2QYjKnVrIREEbNWKyx9F3BokIojp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          "]], PolygonBox[CompressedData["
1:eJwtlllsVVUUhndvoffeeqf23iMzRgooEgHB6ANQQWNE5vgAGh4Ah6CFABJM
HBijmDCVRFCgRh+gGI0kgnZAY4wCKm1BQHxhMKEUylCHOAVbGfx+fx92stZZ
89pr/fvc/uSixxbGQgg7ON04L2dCqEmGsJ2zJgqh160hLC0NYX9RCIOQ9eU0
QE9Ctw/0K5y30a3lVKPfkg/hbDyEVs5h6J7YL8a+Ev1ydNelQjgTHON19Cfl
QugB/zV8C/zNjOmDnGb4UvgjJLgtEcJtaXLBfj6yBZwnkLeVhXAB+e/kNA35
vXx7CNkL6C8qwON/LoWdIMYo6B/I6RL6jeifgK4px1+xffQi1sZsCKeg9yC/
E3/78HEIX4fgT6L/GXwTfBP8KfgENodjznEC/vth82xJCP3hl0I3kc/+pHWk
m4evgN8KX6b60JmA/m/4mwp9JO/eVZDvGGotQmcxshw2MejZ5DcY26nw4+Df
Jf9O+Cr4mfDLONXQ3+KjingF+IHwV6mxK+WYiq1vEfQW6jmP7gfE2Ay9kVOT
8J1sgB6DzmR0r9HDh6lvOjluRncEd3oTWT7jXumOddcfq9/d3fNO4rVwP0Op
j0+hGbqYfI+TSx9yWIKvMuo5DT8U+xv468u3Zfjrj34V9rvxN6u7daS7F34O
fCd8EbozIteuO2ok3w+xGYDvX/ExBflo5F/EXMNY6Ac4U5L+JtkjnBnwC9FP
UUsgxjfwSngisVbibwN0b848+DXIq7q5B+qFZkKzoZl8PPJMajY1I5+Sz3PY
z8O2EpsZ2J6JvCuaudO6G2LOC94x7VoF3z4nt1rOFfz3yXo2huCvBH+74Nfh
6yTySnz/jP5V3bfmFV/38a0p5piKvYX8dsfdc/X+Qb61Iq/AxyLoPzlzihwz
aLfRicdtsxnbf4iZSPpOuqBj5LQaejX5jCf2fGxK4545zd575Le+m3v0GvQv
fOtKusbpxLqDGr8q9R11x9/ltGt9H/0BkTFH2CNMEbYIA4QF/90J/q5wB6OL
nWMjuV5POxftvHY/RP/vCjnWI+tIe9ZUo2qtpabZ9KYdHz2z7qF6qR1YAN2B
/R/YP42rSfANee+SsPF+2RO/BF8Hsd8F/RY5PlPsmlfBj0tZpjvSXbUUjAUd
2ExMewe1i9oR7UqPrHMZjv5OYmVzzv0y33I5z7hmXTNbSW7P4+/vYu/EEuht
GWNfitOI72Xw7cT7kXzXwx9l50awfy3UsA//c4hXHzOGCEuEqcJWYbawezk+
1yaMScKmn4j5F7Fn4W8y/o6hczFujMwJz9HfmjDmCfvOod+adI6LkTWi3xw3
Bl7PGJOFzdJpRXdFzrmrhytznnHN+l2cOHSvrHuhnT8lbOPboGCM2gRdlDEW
vgr/IvxIcjiQMMb3y7hm1a4clEue+Xuq1Jhah245py34znX3j6Z9V9qhZvxV
ZPz2qQfqxfnIs3AO/gL0KE5DzD29hu1xYlwmVh053A2fzhiLhDHCmpWcN5Le
Ge3OtJRnTTusXR7BGQtdh79h0EMyfmu0Q9ol7ax29yzyCNlR4rXHfSe6m5lZ
Y41mfCC1bqOG2oR7thW6K23fyvke/CUK7rVmWrO9IvIsjqXnCzJ+4/XWzyX+
NGTLI8tUwyrod8qNPXqD9BaNT/mtv4T8IvKpkW3VE/VGGCosreasSvlN0dui
moejuzNn7P2SGDeIXZH22yTMEHaop+qtZrx3xpgt7B7J/B1j1ndST33CGCes
0xult0p3vAn+MDrDSrwTvfG1p+DZ3o/NXuiOnHMTxghr2iLftd6wJmwHYrMj
4Z6r95+k/VZppjRbt8APLvEOaZdeKng2hZnFyDZlfXejsKnOukfqlf6pCtTy
fd7/JqqhFtvtBevqDmu0+wX/ywiTO6E/Kjh3zbxmvyVrLNU/RnlkDBAWKKcD
5N8/7V5pZ7W7R8r8Nqsn35X5n0P/HqrxzYLfZL3N+mdbi+xfoHZkDA==
          "]]}]}, 
      {RGBColor[
       0.44396417955930256`, 0.45973182029240667`, 0.5580849551472471], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgm0ldV1x797331wvzu/e78Pg2ITVEBN44CCiEZBGq1aF6igppHoqtog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          "]], PolygonBox[CompressedData["
1:eJwtl21wlNUVx59skmUX99ndbHaDIFh5FyogQV5FJEVHAR0QDVA7iqOltXSo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          "]]}]}, 
      {RGBColor[0.6122033886573482, 0.5188574209338923, 0.4591839504378528], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxVmgvYllO6x5++4/u+3/cevvfwoWJHKpmQmSEdGFJNw46dcdgMGqHD0GH2
jCRqbzOllKFy2JLDXMxIYYYOdufBDNGBqK+iyDYMBhVhpoT5//rfXbP3db3v
tdaznnW4173uw/++13P44FHnjKxKkuSL6iTRL2kqJsn36pKkZzZJXlBDSf+H
1V6rskH/Wapf2JgkN6m8O58kG1slSVrtM/W8u+L6RXr/WcX9L1H9S5V7Y657
NCancpDaj2xKkiW1SXKQ+q7VmhNFSH/N847qSTyfWZMkk1Q2aJ0xaY+9V68f
zCVJ1/okeUP0/qpkWus095vq16z6o+rzC41tG/XhKqv0/1D1DerDZieqaNvs
+rGab4XoWaj6HtWP1v9avbpGdG7SOi31Hn+M2tdp/DateZ6eH9K/g57/XvG6
l6v/23o+VPWnNH5PxfUr1b5GZWv9F6h9TuI6vP2Z3n2q+bdozsGqP6C2+7SX
nRnTOkPPn1d53atVv77GNPNui8q5em5R0ykNSXKy/ukG0/Y3vX9X7X20r43i
c1+VPfXudbXfp/a1ZfcZqLP+oZ5Xqn6Oyrz67VU9L96O17ivVB+v9uNF43yt
1Vm0lDLm9f1qX1I0Dddonj0p7TflMe9pnlbq++9qb6u2HqrvU/sNqldp3v8R
jZ8WkuQO1XernK05V+j9II4/Y9mapPp3cqb5NM1zifj5tejYLl51U72vZOIE
ldObLDMZnWdb7bGN/iP1roPo2lnlvY1T/TPV16r+I72bLzre0PMYtX9Q5bUp
FwcffqGzmC7aPi54jueCtsUa93b049w+j3fdqi0/l6s+u8r7O1/1ozR/nerT
NfYvonuq5vxAcw5R+2S1H6Y+Q/R8iNqHaB87tY8RnJ/m+G/1L6pfF8nDlBqv
sUbzfFfPt2rcRvX/lfZSL5qmafyxoueX6nOa/pPV/8iQw8fVZ6iep1Vbl7vq
P03tMzXme6qfon9njb1BZfeQKdqRqyXi/7/pXUq0XCye3K22G0Rv1yrvkz2W
QsexD5ToPP1qNc83qg9Rn03a10PIAGda6z6loGdv9F+jc1+t/yfaz+Cy+1+u
con2OVf15Sr7iYbz1PcI0XCy+NBOa/TKex3Wu0D92mitFSof1H91nceybh+N
WaF++7Sn9RqzRW2TNd+/as32tebP8cEf6NlRZ11Cx8+tMX8OVb2v+DEh6p9p
zv6q7xB/btccfao97/nVHosOfqx3JY15RrrSXm1H6P+02ndKdlepXiNa7hdN
31Kf19TnYK07R+1ntzJvaoO3tM2N9lXRzjkuTDwntuU9veug+jPsN23aTlXb
jRXT9nOtM0vPl4Y9PFy8PlrrDYp9D4o5z6q3fPbW/1zxaKOe/6B9LBevLok+
w5rMh6tUDq71WXwZsosMf6GyrPlL+l+g5x55rztTNFRJV4eqvrTRdmhY8Iox
tI9WfXzBc3LO42p9xpw9Nh07Ow8elmyXtqjPAtFxiPaysMkyBL9aa77XZDs6
iBfN4sE2rVelPjPV57y8ZeNTvd/daLl5Su1vS+Z2a/yfVY5O23ZgN97RuzPU
512VH4XtwG7MyNuGDqzYL+IfL65Y77HX2OqvNVdOc32j8gdqu7rKtnSYeHGE
5jy82b4CvUVnv4p+C0XXCXp/lfp21TxLM/aL+MRtyHuN321X+4Aa6+WGWs9/
vPqcrL29pL2s1Hz7ym6fq7Y7RUu+3jIB/5AT6Hm12rYGO7Oo6PqZWZ/JLTU+
lzl5189R+3zN+ZzmX1C2fcfOF1UWZIPz+g8JurAV0Hat9jNbc1yq8rKc9a2n
5rtX/XaInksT1/EHH+v5qsQlvm9QxWOZA1u+M95T7oj67UXzqa3oWSa6VqR8
Nt3Ew6dVP1LlY2W3dxX9zza57XG1/TjoeaLocxiftg2dUOWz2H9eadsFbEI/
jW0Rr7cHbuoee8d/48cvC1wAFkFm96bsI+HROq33luovqSwUPXaS6Lmy4nWv
UNkomThbfGho9lzM+VzZ+AM8sDVwCPSgQ7NyPid0CznFl6CLVSnjJ7BToWL7
Ml+031D02SwWP5dlLFuT1Pf7ejdC4+7U+5H636H6JtF2Tc528o9qGybdbKP6
YtVXNtk3DdX74Wo/TO1j1DZG9S6qT4V2zTFT/4tE57V6bi8anlGfzWqbg58U
bdtUf0z1E1UvSXY26PkRPd8pml7Bnqu+SHNeoTmfUvlqtLUGM+l5oNrvV7lF
7Y+rvbPaf4INUftx4tvtOfue6wv2h9tCd6orPuNlWfv2BRrbJ7EeYk8XqTy2
xnaVZ3xtt/D1U7T/xzTms6xlvYf2NbSVMc5z6rOrynZrYiv7wXNr7YOWV1sm
kT1sG3xfXOt+YAR81wTVr0sZA1+repca2whs3+vawwT121qwzZ7dyjZ5VsXY
Ii16/lNyeIXqKdWPq3c7eOPhsnHMnLIx7I+qLM/4W/rjK7Hr+Dx83N8aTfsi
ydvkss9jCnofuAv89RNspdo7aP0lWu9xtQ8o2qfCa/DKPWqfqvZD1Oc41Zer
/6Mat0l7uF572axyV9HrjhDto/O2by9q/dtSxuFgyy/zjhVOV/8zKsZzZ6qc
pj5TU44dhsbZsu6dWmug6gcX3MacPOPT8Ef4w1Wa8wX2rbU6YffQcZUdJYcd
MvbfnCP4Ah90SMHzQOMuzf8dbIVoWJEx7sW3Xl+03XtT7w/Wu3tU36b6ioLl
6YZG45SH4qynao6T0ta3YoNlHxm+M28fdFfeetItsY40NfgZ+Yd/yBG0Qee4
kCXkFSywKHACdbDH7LJ1rWM2MH6tbVde5frAKEtTxsLowksF69S6grE/9gz8
36D+qyO2mRs6syj8M3V8dKX2n/hifZ2xMXzZEdgc+3xYs+O13jnLNfQQd+B7
8EF3SfbuL1s3j1ZbXdH60r7J8cyjsdac2CdY6JH/s+8nUt4HfGMf8BDeJuLh
NxnTDn4HD6DXrdU+Vu1j1T40b5/7ba35G7V9U+91Poq4AZ+FDcWWdtQ5v1Dw
2a1S+VbadgkssrLa+o/ur4x4Av6in+hdu4r92AG/hw6gC59o3ee1943aw5/K
1m10+ca8Y4/9vlH/cyvmabuc56CNd1/VO9YEQ9aI/uqMedY1MCRY92HkNmWe
/V50XyI6SxHjE98TixEzU58R2J4+6MOGlGVhRmD7wYHv16Y8Dh4SuxPH4YPG
aa3rMvZhT2s/6/DTZeMlsBKxEj4SuUQmFxaMObvnHUcjc8gbsQ6+hngHXzos
4t4nUz5vzvh48aIW3dAcv6wY90ysWMYbay0nX4o/e+u9P9ahP7a0Jc5qeivL
3YmhC+DqCYHfkGVsPXae9atrjWHP1no1qp9VcP6BOjmEs6K9oewxF0QMBf4D
Bz7dZJt0SeBzYg5iQ+KyB7SXh7X2DNE/SvsbmbLtvrrJvnhY+EbOhfO5u2T+
4JOf1Nh5GnsXPChFvFnweU6M8z0j8ALxPzgIvUVGdgWW/XbO5zMxzrqlydh0
g8rZevdbzT8dO1dxzDlb5SaNu1DztFTbdqB7nbK2r11j7/B+bNCALCA31yWm
nRwH5zuiyTHpqJxjKOwUNmpJle09/rFBOptpMJZCvtBf5P9W7Tel/j1z1tdz
Ql/+WrEOH5ZzPN8n9BHciO3rm9i2MRb9wSYQB6CbzEX7TM2dDrl8WfNdqfZb
iBlUv7BgOi9S+XLRMeHNOWOWxrDb8GWj/tnEOIi2Azb+qLBR7SKuJBbDL2D3
2yS2L9iZIzT4/EbHhMSUWwMf9sj6nMH0yA/v62qt89gkYkns0mOBv5Bv4oih
GWOa6WXTdLjm+ajgs8xqr78uGycdpL0sKzmPsrzks6UO7TPLxnY59elS73Mk
n0D8gR0kNmFd+rB2rtm4qCZrndoVsrGs7BzLgEaPWx5j8fPUwQGUK6LO+RAb
cEbYRsYiA6NFR1Z0LNU5vNJkbLmk5P2BI+F7p3rzitgH2VofMTW6DzaFP/eV
XW/KOd+GvhATDW7y2AbxZ3O15+eMOB/wKOeYEs0zav3+5rLXbcgZ3y0JGf6P
JvMqlzcGXBHYAJkBAzeGzDAH8yM3yA/t0PJF0NO62XzoqPm3ZXzW4Iolqi/O
GFd2Fw2z1NajbHtNrI0v6B44BLx+R6Pzd/vEq5822tf1b7TduifOqG/kXnvl
HC+BbcAd+HMwK1hgfNG+f4LKW8mTap6ORcfi7B0etC8YM1flnTMYFjkEfBq5
PHxmtmK6Nmjjg0XjktT/z9+hv/gG9BadRa+RVXQbmncFfmMu8nrYgd7h576b
s09YE+eOfr8Q85ALJic8UOW7dc5TL4n5nou8BH5jVeRGBhY8tlZzn1NxvEnc
SZyAbtXmfG4tcY6t4xypH1N27mW5+nxese88CT+Wsf/Gj+6JfBX4Fn8+I/DY
oCb7jMfUf1STfeRCbHPG2AUsQN4NLMC+iN171jlumZGz38Hf9qtYVneqviFt
vqAPYLq5gbVaKn63CZuj8vW08z7gFDDBzDiLOYHH2kbs8mjgtfuCZvaKjcO+
/aLiOnEbtqohMEqrBmM1MMqcjPEKOOybwDLQg+8dGjKzMLDgAQz4SNDdSeex
XXS+VXE+BpuCTSL/QWxLrowc+r7AHq82WX+XlhzLEi8RcxO/Eqehm/glcqnY
t2cCb7Lm1JzzXjcWrBfvBSauipgD/45PYF7mxD4xD/lY+A7/dxSs69SxKeSk
8afY4k0hP9gA8sSbon5Zwb775xXHIsMDS5AjI9fzWt72DTqfTuxbbg/+k/vA
95ObIadPLnhWyWtujvWOzDiOIoYa3+i4ifiJ3C084Rk8QgzJXsjxM/+WkHFk
HXt1at758dPyjpvILRLHTio7J7lKvP+y5LM4L2t8ROwNPif+po6tvqls+9hG
fe7PGhN9Xva5tAl+EltNSzv/kI67ktFhM6mDeZCvXhEPgCNOifuUntEOdj05
2ul/k2RxYNq5EnQLHbsn8b7JEbMumIv6gbxxv2jfW3R9vvj8w0bHOr/LW7d7
xlrQQR35Pr3itaoiB3NRvfV/WsVxLDladJ07AGJ8yuOizn0N+kj+iHJj1Ik1
7o08G/4Mv/ZA2byG51NEz8Elr3VQyfE/eYB7S84Pnx3z15dcX5yzTv4m+PBV
1NFD7oGQxfebjAnw+/eGnTsr5sEX4hNnqJ28wrSI5ZEJZAO7yl7Kcf/UW+U8
/YfXuY137Gtcyn4OH0c+mHwXOXP8Hu34PO4eF0edvBf5L86xv9a+WON2NDrm
Wxrt4CXa8aPQdUvKccG/5OyfiL1agrfYPWRjWeTTiC/aZ4xzsSPYkxcLxh/o
dN+KbTTnNzLv+xZ4gj5OlpxsFv1dmo2xwFcvRzwET9Br8NqwwGwdM85XoJuU
HSN3wX0YNODD5kUf+EZ5ZPRHp6mTP8X/gxvADOTCB2WMR7h3RbbA5Nz3tsR+
yfWS8wXTQ08hcr/vZ53f4D4HzJ+PPryjDg7A54FpD2Bf6p2jLEb9lMD26B1l
Q9TJp4BDxohv+byxExgKzLI3cq3898S9ZCpvbHBbyXECc2Hne4WeH9D9dLTP
UL952u90lVuzlhdwE3mhqgbzsFf4JnR2X9gXbMvusm0RNmm/74o+xK/MCR3k
HIklT6z47pkcxMKifRW04Nc2Zo15wD778wRp5+jwhcxL38a88Sc49I3gCTmn
tvp3Uf82FZ8T+g9WeLbsXDo59VtTtiH4JO40wFVgKXQZP4vvBMMfE+e+QP1/
nHZ81C7kf6bWf6Zsvb+0YtoYyxpbix7765zPp0vMQyxLHb/JfMsj5gKPkGcn
J8kcc2KeNWnfx+M/O+WMb8G5z+psNnO/VvIdzg/Sxs09Kq53V3mS/v25f8na
N3AuD2Q9H2Oxv+QXN0Wde+bfBl7iPoX7b+J91m4JXh2XS/bfxfMdwe9ztvvc
iSFnLTHP2yXn3/+oNd8s2mY0Zt3WKvDM9xsdhxKPdgibhh4uDdkgP/2S/i+K
/nUVY9knglf07R39OXPyq+dHfos+xCyZsjHAB02O1YnZ7yj6juzNtGNA8N3L
aWPfC8NWc4df3+z5a1V2zjoWIg/H/Qp24tVG6wF3SehCc9b2emLZOIv5wQOn
5Yz/yPNhz/4rZezUrtn1Meo/IOO7WLAt+WNK8C1xA98NEBcSF4AzwVVXBtYF
814TWBfMy5pvxb7Ao/QHE24U715VfUPFtnNF2E+wb8+40+kfMczlgWm3xVpv
pP18YL6t0U7uh3MhBgD/rAk7yfcFT0YOivmxd9g64gHiAr5bAaNx/0puNF30
+7+ID69UfBbrVR6m51P5rqLsXAL0g8PJWSAzp+SdK+X+CXu1uWK6wJ7Y7TVx
n04ui3mInflOhXupfnnLy5SQGehdEHL1ZsV7P1R9uuWMw/muZ17W/pA7oo71
5gs86ZB1PE9e+VsVx5DHVJzrQm/RG+w9a7FPYjx4trZinzY/eIXvgFfcoTwR
PIQecOXq4O2wyFHQh73Rjozha/HX3I3in/HT4IitcVeyomQ/ho1gnpUhA8gr
361gB9Fr2lZGHn9Eyrjz8tDp26IP/W8Ln9JTez5f9Q8bLcvEBsg2uJ52Yga+
aamP71rGxP3X2Irz9NwBkavnPf24PyYHRp2cGH4ZnUUXjg3MRIwIVqyJ+Aes
DGZ+XmWPtHEPmAd7Dy4izkIfwELciSNz9J8duZRpqX/aJso/aZ5dEW+Sj22X
da6EnBB5xx6hL9w7dIs7LOiojrUYVxtjmWdn5J23NFnXTtB8a+rMX3hLDIad
xcaCm8BPIwKP9A5Mgj3APoB7ib+5G+V820c7sRvflhEvEzf/uc42hXFgwcUh
G3yjBnY5Pe/c0dTY+zr1vz7lPAxnMjnlc4GWSVFfHHd1zMP7m6L9gkbnSHdF
bpa7MOQTugYEbfBtVLTDv5FRhwb0E93EL9EOb/lua0O0/73kbym2VAK71poG
8Cx4F1wC7eOC/gO0DjmAe6P/VXFPx30d2Jq99w/MfF2MJRdzXewRu459J3bj
nnl42jl2cGsp8pB827M5ZJ57MJ7BJ+C+TdHOd1mj0s7P7as3JiaPfHrOd5p8
K8e3OmtC10bmHL+R98XH7ov+YFiw7IF8PeWkiGGhFTr51oNvCvfnA+t8ruyL
u53VMT97XxvtD0esQpwytmgatmRN7+igGcy1OvY1rug5X886LiavR2z8SGAy
8Bj2cn0qvttJjKV4v0ljjyLuyvl7ILD5Rzrbt0rGTmAocAf4g2e+yzo64kfy
6+QoiXmvKVqP88QdWeN07up5z/zke8lhk8vmfg2sAeYAfy6P9r7BP/hJ/n1K
zvkIctVgyU4xz/slf2P2XmAZ9ggeI/6mfU3gJXjIftn311Ffprlyqv8svnPh
ezXG8c0N58G3XWNzzr/wLRUx6fMp5xnJ4e+/K0qc11saeylFXIDs8S0XuV/y
x8Qc+AXiiw9Ljmm4+wXLkickF8gd3faIlboEFvkk6/2PjbVOyNk+8E3r3LLH
PlJ2biadMl7d3zf6k2unTp65b9DZJ3zZ9qBnYdn7OjFrfSqFrKLTlZS/fdpb
cn2PygEV39FzVw/eAPeAYfhGhLjlA75X4Q6Ub7dU/rVk2j6I79ByET8Sw9IH
nd5StCzdl/N85Vj361J8t1lyTnRVyrlz/Nuh4e+eKrt9Udl52VKMPTlnLME3
sMSLb2Tsd/D/1IkjiZm3RfuDZWOMLll/p9k27lTQa2wC8enVwV9y+O+S/1f/
d1R2idwv8dDvyv6e5/is71umxr056+L/WGu5+qxRn15ZfyvKvR12+KdZ687/
lm0zmB/sCj37730Dh4FTyFXzHQ1YB5xzUqxFHql1fGsK/eSx342cMN9bcY+F
bOyOfC/fidwc+vV+3vtjPHtk39DJ3sHT+Lq6Zo8HB0DP8LJ9x2dlfxtF3gYd
4T5uZ/hZdIg94kPxff1ivzOKfp5e9Hdp4Is/lO2PGUs8OCTnnBrf8mAP2gQf
8AvETfgX/BjzMCdn2z34zJ7xx9hUzuek4M/Govm2oeh9wBPWhq6+QRvr7wr6
+0Q7MQ/YZ230B8OCZR8MuUf+b8o6D4V/qy06/z87eAL+BxeCCc+r2GcdkXOs
0DlsKTkv+pP/Rx87hk5iV0rx7cX+/EnE+PiCtvFdMbQw/wEZosQeE/dis8c0
GtuB8fjWCV5tC12oif3Ce7737Bw2lvmZGxn4BznLNgs=
          "]], 
         PolygonBox[CompressedData["
1:eJwtmHd0lfUZx98k3Jub5K7ce98oRSjIcgQQlSLBwRa1VFGRooIUmUcRXFET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          "]]}]}, 
      {RGBColor[0.7804425977553939, 0.5779830215753781, 0.36028294572845854`],
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmUldWRx7/e+73ut3+v6Y4IQlBQMXEUchxRMUFwiyEaE2Myc0ZZk1HB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          "]], 
         PolygonBox[CompressedData["
1:eJwtmHdw1VUWx38vySMv4bXfKwEVCdhAxdHV4OpGZBUIbYG1IqgjCQRsFJWq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          "]]}]}, 
      {RGBColor[0.9077766464622107, 0.6394416161555267, 0.3141076040328532], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWWl0VdUVvuSNSd59995zbwBlMtQBtK0iMtklQbBFkLqywCWphSWTsCJW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          "]], PolygonBox[CompressedData["
1:eJw1mHmwzecZx3/3Xvccyz3L73fOIbYpmsSStA1CSCckIk2JuWMwoaojuYgh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          "]]}]}, 
      {RGBColor[0.9346519194810678, 0.7066297987026697, 0.3974209503913104], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtWGtwVdUVPiT33gR77j3n7H0TIL4CpVJNaXlTJLTFtqAIFJKgVYK82qGM
BSTgVNsyIoSUdzBFEEHAjiIJ4SFKmUElhQkIgqEBR1AeaiGAGKAOD6k87PfN
t3+cu9bZd+21916Pb6192o6ZVDQxw/O8Ey08LxPUWM97MOZ5b/meVwYa4c9N
GI8nPK9D3PMWQWgL6KAM/dcd8gb/rYs8rxfkx+J/i/FSjBnwPvjNLT3vsZjm
piH/2yzPywF9J+V5xeCTVnQonvJM0SI8MezpEGSmgL8fMiWh5+3F/1mB57XF
+yiM54NewNofYk+9QR8CrcJayyC3E3PngkaQ+Rz8NuxjS47nTcX71xhvDz3l
0DELz2t4H2bF/weyj4GfA/4U+MIs8Qdhh76glXimQX6UFd8MmQWg89w46Xw8
d0J+hBV/JqV9cD87wD9ldc6WoK/lyEavg9bg2QJ+XY5sxjPSbrtgz02w5Qt4
bhj4BufcB3sM4P94WsBWvpXdtkF/E88O/nGMjcE5p2Pe9iRsAz2Hsz3vOOT/
Anv9GeOd0p73HvRdx7iH945YrwfoX/F6MK0xgzUPg2+A3MVIOo44PbT9GfDV
oP2g/yHIt8H4avBDcIYpeB8SiRaDtokkU4n9dAbfj7EE3S+mFD/zcfbauMYv
YPlF0LMQTwbe34G+Ysh0A38Ic5qw7kegZ50PnsB5z4FfCH4k+NvxfAtdFVin
Gs88zNuDdcckFL952OePILMEOg9g3hqc84+Q3w7bTsc4TOd9gJ8RmHMWa32M
td7GHk5AviBDscx8oV9XQefKhM75VVr2nIN558HfAN+c1pl59ruwzrMJjffF
u8V/u7FuN+xxqFU8Hsd+apyvP8B+NuApBb8+1DvH94NOgM7W0PG6kY/p60PY
c2forMXeGgLlLudy3/vc3FuQP4U8j7CPGqzbwiqexoLmQsfqmHK5ATorQftj
Xls8TRjPBz3uCxeWYm493idC55dGtqMNd4LuDKRnB2gj6Jcx+aAL50CmK+h/
I8UV44sxT/0VkCmE7qO0CXw0KS79zKka6O2LsY+hswv42eAT2OMKJ78E7+0x
/gh0TIHMH3z5sSvoZSv/HcVATVzrFrSQD0/GZLtGyO3H+P3YV2G24psyA26D
7/B8ivfWWdLDGGBcnHFycWfDDNCPErIDfVMW6GyjYZ86lxPMsUXgJ2cp1/6d
UhwyHsdi7BliFNbthfcy4o/DQsoT3zpjfAL4TqC/jotfivErRjh1ibFshaPr
cabRVlhxPiXdXGMo6BiM3wdajPE6jFXhKfCEl+UO98ZbYfMWyHQI5cd7QGus
8K4U9IyRjxgLGZHyNA56d7bytxl6bsIODZh7C7Q+KT8vg8wPQp31Q+wzjf+2
QuerVlhATFicEq5PdWdnXHL8qid7lDkb3m2Fl3sgfzNSnl8HvQX9LxPjGMOB
zrkOsh2crduDbsSzE/wm0LWhdD8K+nagHO0IPT8zwsp7I2HbKpfvfJj79Glm
rvh3cZZ3ccZN4Iswr4cRbo2HvigSXh4DfQ56FieEpbmRamZr0CUxYR9xj/6j
H3uFkq1y8g9CZw0x12js7wlhJrGzyvErY6qb1PsTI5k12FeZUV2ZAroO75Pw
fxbWHY73IvCTsc/hKdWDYRivxPMd9vwE/i914z2ZX1Yx8zvQaRhvBb4eMmvx
XIP+oRi7Fgp7Llnl0VcJ5fUyI/4l0BFG+fR76JwRV//AM9a6vcVC9RWXXW/B
WKP+H2bKx/T1d5H0NTv921zPsBvrLvUVg/dhnRuYuzmhczIu8rKEF2eN9A12
9ZO1n+83jXKkJKV4W+R6jKtGNX9DSjaiTWibapdjD2Nsj5HuZTjHKfA9MX8t
/n8lLp45OAT7ex78IKva1dfVdPYCjDPm9bRIfcv3A+U7xx6GzCxfOVqBuX2s
cqS3la+IU7RptS99l7F+CeYXso6CjoINRuKZBdlhRjb5F2tWUvg1E2M/x2Mx
dzt0DA6EZz1h1/4Yr4ZMP9A9MfHsJ2a5swy2ik3WII6/gTP3wPhJyO/Dcxf4
/aD/TOp/9iPsK3u5urMgR/xqX5hL7GUcDIz03hNz/2aFUSW0m1GPdC2p2prv
ehL2FsyHPNYmYnm2zsM4Yu4xljqHmjsBsvmReoPxSdVB7oVYcNEoHpqN4n2H
61fXWNWlK7DNVfAR9F9hnxsKo9jXzHY1/QR4EygXmBPsZRmfjFPG/KdZ2g9j
g3q+8HQWYihjtyIhm9BO7CN812vRNswrxjzjf4CrU5zH+cQv1jRiymjwR4g5
jl+ao9hgjBQYYfW99Cn2fAz72WuFC7Q9c3Gh2w911ubIlnW+bDbI9VSLcxST
jM21OcL2/b72y/NyzzzrSmf/3e5OQVuzZh5KqGYXut6APcIMo/Fm7KEH7HgJ
/KtGmM34Y2708VW7xmHPk/FfPWSeAu0DmhdTb8DY5zh76bmRsKAUMh2tZAa7
eON5idddXf/wG6s+KIqp55iYFn4SRw8mpe9N6NtgFRvtAt2Nlrg87QL5QbDb
Yeg74fCfdeBJ1xPRRuzFGt07z83+g73H+77s+g9XP1k3iSnd08pzYjPrKMeX
R+p5B2erT+qWFt81rf1xnwuY13Hth70r+6ZfZit+2qXFt2UupIVjZYjPXHcH
oQ2IMazH9D0xjjKUZQ9U7fqlfKwxg7HCvsD1bOzdtsJWn2FuOlTfwP7hDdAV
kc7GHuEOzHkOc2OopW9a+Xcx5h2NlAe5RvWJ+J1nhd+cS5swZiviureuCJTj
ywPpos7bjfCCuDEH1CYVF92s+jb2by/lqD8d5bAx3+UR156eUj+93GofHGNt
eSaUn88HqoXEiCeJgYH6gplYZ1xSetn/PpJQD0pb9Ta6LxWCLvNVt1sZ+YWx
y/0tj6tWERM4j3ckyj3rCzu+wPp1KfnVWuEvcfh50KZQNjnNfjmUzPRIPR/r
WjXWMpH0piPh9Ctura2OZ53abDWX67SzsgPtcTVQ3l038hP9NQB8Q0q16seQ
bRmqR6sOdE+c4e6KrIv0G3t23il/5Xqbbr5yrVOo+xtjejboe+6Ow3vtLl9Y
UgyZcUa5FCWVw8zlHoGwiXHKOsbcKoirN22FOZ/jPTfU9wvmai3z0WEIseRk
IBssAL/K17ePtpF8Q9u/7KsvJBYWgGYYfTdpgz3MxNwHiHOQyUoKM3hfaQp0
j+1u1E/Q/jF+owh19s9cPvEsxIRbkXKfGMDekZi0KlTd5lqMc2Ih44mxRBxm
L8Tx9q6/rUY8N6bUsxRa3QlZlw8EDhczFWNXI/VY30S6I/GOcwx0jsPJeZHu
FexPvjHCbGI393dnqDvUHaFqJGvli1i3PCEZYjtzaaTbWy+jPpn9Mr838Q6W
F+ouxVwjjtwIFfc3Qf/k8ot5NjKp834dqWdinBdZfU/hd5WJVvhNO9NeiUg8
bV/s+p+pWH9mSnF9j1XPRFxbjz0/HSpOpoaqk08n3HeQTOEJ45PjAxOqoewH
+e2J9mX/S0ym72mzW45n7WcPUI51FkQanx/Jl9zjDJzp8aT6/aWh6iX9z7sR
+0reG4kj7Af7u/6PfW6h63WvuzvOXqN7GnuTSVY1g/7Z7esezvt4faAejr0c
vx8wZxhvTawLGP8f+F+Afi9Ur+CHihHmMn1QFWoPL/CendT510Hn3FD95rSk
fM08Z37yO81AZ8PTvnTQn+yb2T9XW+UM43l+IGwjVvdztqBNhuP/9616hrpA
viDPnoJ7Mw4neT7GHOONPWaj+2a00PVB1EWfsRciT9/yTse9sTdkj8j3B7Du
t5C5mFReEmPp93O+auFG+G69++7wU6PvI6yNB9ydj3hV5HCffuvAu57r4dnL
E0vYzzGHWEu5LnGqJJKvz9FHSfn3k0h3Et5FLmCtI77qKesqv8VVOVvx7kT7
0w9vBTrj5kC+oY9uC+UHxi7PuykQvxF0faB9PJrUPZP3zVpfdWOWq6e7Qn2L
2R1qf9znBqPelz3wafCVRvahnT7xFfvEwnqnh/Hwf/mm7kQ=
          "]], 
         PolygonBox[CompressedData["
1:eJwtmAlwldUVxz9Ckhf05eVbXijEDSgjSkaFym6sg1pcqhQCohWQrSNSFBDo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          "]], 
         PolygonBox[{{3933, 3932, 3512, 1248, 4119}, {3921, 3920, 3567, 1274, 
          4161}, {4117, 1247, 3511, 3932, 3933}, {4160, 1273, 3566, 3920, 
          3921}}]}]}, 
      {RGBColor[0.9615271924999249, 0.7738179812498124, 0.4807342967497673], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHewV9URxy/we0X9lVt+j4gZWzQqgoCRYhBEOioBHogFfNhiBBREjCKO
xjHESRgnhSjtUQQigoFHCaJiRGoYo6gRJyaY0MwTNRQLApERks+X78kfd3bv
3t09e/ZsO/fc2+8dPLZpFEWbm0RRM2DnOIoO56LoX4Uo+jgfRf2hT4RWz8dy
ZRTN4P1IEkWtgQvSKGoB/Q7oMUqOJ8a/AS7ieYpv84G90LUH/rPhry2xBvqv
ii0vPbOgfVodRdchW4meer4PDfjuchQNAz+EnhnQh4DfAf1DbJsMbIKeOuR7
8K0GvJLv1Ty90Ts7MT4L+M+KKNrJ0wH6mkrzDUX+G+CuQB9RhQ8CfQf6e0Eb
h87xWRRN59tEYIY9HbB1C9/bobc3vG2A01l/PXpqkNmZ9/pPIntd4nWHAP+B
7Dvgu4A7KmyT1m2oMF2+GFsTRa3w2w3FKPohtnRkrf6s8UTO617b1OtcUu21
5BvJSods3MzzC+QfxtYqvq/Elrngq6HPAV5cYXwPPLPx253oW8T5lEumRdoT
9j0H3hM4tGh7ZNdB8AbwG6HvLppnCDp3gS8EvxL6b9nzBmw9WLL9sl2xsazG
9m7AnlHgLeEfjNwUbMkqrHckup7i/S5gJ3QNYo8dyz4T4TqP83nvBX5e8GXX
avutRdlxcQX2dwAfCP0D1pqQ2R9rWWtkzvRJ8L2eOXb3Yu848Gmsey/wvoAf
gn85+PdxyVH28ofMvj0f/HH03NXUMa3YkT06x57Bb3uQnR/iSvkyCbmBFfbR
xpLP8Df4fCR+iNHVEtrhSuuVTScS++6/iXNJOfVn1n8Xvf3Q0xk8B211zj4p
F7zOldA7Qnu00nE5Ezgf/kb2sKbkvOoLz6bY/q9FX23iWBwMrFN8w9MZv42p
MX4Jcn+HbyJ76JE5DxVzXwHnse7NrHMR+iJy+U7oTYDjddbItkX2l8i2Rf+7
0L+L/M3QJ8iW2D7pi89apLb5dOAKvl2Bzp+jew7PMPAL4E0T14fPgN9BZht6
mkG/v8JrKUYPJq4P7/O9NrPfBwPrK80vW5fA/0jwz5ms9zmmz2a/TU/B/5V+
V17OAe+keEoNR2PXq9jzmGxjneFlx+0IbLgI+LJiCxsa4LkPngHwvJC5zsxI
fA6yQzacguwC8NdYtxa534E/AL1n6hxZD70f+HnQJqBvIPgyeAYA38gZlx2S
kR756y/Y8SBrbAOOgm8d9PtVn08xfox9vRt4rk4dv9qvYviVEBszY8el4rM9
Nk8pOH/n870p73OR3Ypsq5LjVvFbHfb2duozky0toS0ueI1uieuL6kwb7Y8n
B74fH7xPbMzBZ73w04sl1/cd2LASfCp4HvxTeJbAMwD+ITxLwfdB28vze/Cr
y46vdjzDVZuQ7YbsphrbOy/E/5i8c7lb3nGkOFB/2Qb/cvjfAy7OW/YWnVti
2Qrgj0P9X5G5F6onrgCWCq4p1TU+Y511PXBW3nGk+JL/VlW4Br6Uc6woTv4U
clC5ODRzLuxgT2cn5p+DjhL0oaz7iOo379cgP6/GtUw17VHoz1Y6hhQLtfii
M7KT0HlCNZjndei3ZqY3IPdybNrFwH3seT08+4Hdy7ZBeXl3iJ+RwAGhX3eP
Xad07quw4ZkK+1e+3V3y3o7H9ov88wW0FuxlOTynJ+5X6lvreL4uOY5z6JlW
MD44da9VPWsI84ZqnXRpf9eAz2rmnqreuivvGOlf4RhSnVK9WovOnuz3Yfy2
HHwncDQ8r0aua+LZEjvGRd+LrnuwYQH0zSXXJtWoU5F9KnHvma7ag32PI7MB
3r7wtIPnFXi2hFp3KbSGxDPSMtXt2Od8LHZvlh8UExny98B/Ofq+nfM+Vbt/
lrfO1egbnPe3TsqJ2HE6ArmPYudrI/ChSvtSuTSsYF+czJvYvno6dv2VbbLx
VtVT8NdKjqnrqzwfXIiv7gS/IMwGwjW36WzPrHL9fbzovZxAdgR4G/DLwScn
9sl6dDdPvM+jwDdSyz6hHlrp/FK9Un9Qf1Mu/LrofD01cZ88HmbLbpl9KF/W
hbXqwN9MbYt6wlup66j6j76JR3YNCnNeF75/EurG8MyzpOZL+XFoqCGqJf/B
z6NZczT8mwqeCx6DvqXg2fJL5UTReaqZRT1EtV1r/7Vs36uejQUfj/4xZeec
cOk9UPYZtcKuronnFc2AigX1G8XDuoJ9qPiqK1indP+7aDu/TB0vO8Laz/J+
hP30Kdqfh4NPxXMvPp8B3ok9jwPvmLk2jgt0zajKC+XLIL79VHMJsENm2faZ
81v0k7NKqCuq6Y0h9jTLp5njZwM23FDleFI9+ijU5H3YeG7m3FEOaXZVvinX
lK+yQzYo/7QX0bvD/xB6/oaOruAPgHfJ3K+OVboXLkmN36R1wL8Gfx64iOeo
Zk3NpAFfmLo/i0ezwYQq65+Mz/eU3K9/xZ6Wcq4vchYNwPeKzsfLM9ce2aCa
o9yaEGQ1B00IPpwf7jhvIrcY+RfQ83yN8+yDnHueeppyVefalvUO8L4GWN3c
8ZQDn5p4npsGfLHKtVSz+Pac5TXX9gv1T/VQ9qom6l3zvfK4S+xeq57bHdjI
OR2B5wrobxe8bjvwLon1aV5Wz98e9GsWkKxiUvPIgjCTSO5E6COat2SzbO9f
Mr/6fH90Jeq/fN+rGovsUs0Aqek/KNqn8u22ovO7PuxFc5Li+tyyY/yWEOeD
UteOWmBVjXufeuAe1vtK9TO2n+Vjzf+aLYQ/V/DMpHhpHjs3NFcrdnVX0Xz+
YdFzsPav2Wek5l3s3Ah/j8T8c9UHEufAZyXXKt1rOoUZUvPjyXoSZjL1MdUa
1ZyP0X975rvNHaH+1Ac/K3amhvjXvUIzSZ/Udyfl3FXArQXPbaex77vznnG3
YlufgnNlE3Lty66rml+GF32PXaZaVOVaoHx/JnM8zctcZ7WHfKiX2pfyelns
e8TOku9+irvDmecp7VcyRzPPeJr1/ljy3nX3vSr1/NEd2CN1rWuduG5ODnf0
jug/hJ7d2H5l6rjS/PsJtLqc+c4o+x63E3g2/I3Qz1L/Sn2fqc/7u85bZ617
vu77S6H/JMxImpW+l3n/l2WebxSzVfhmS9F3+7MyzzGaZ/QfoneYEzQvLMx7
Rh6XesZSvP0Ing01ngk1V24u+N/BbfDclpmumXE7z3H2/iR77xZbj/TVwfcS
/CNS2yF72sTOS9mvGFXeKn9XwN83db3TnK57su4CuhM0ljxnTcn77qFeelnZ
caB46ItdSwq+73WAv2XsPHqY72uhfwh+BrQLY/v8oZLnEvV09XbVYdVnzUjr
w5krznVPkv913uekrhFnpY4fxY7qoWqe5iXVwZUF33u7pv5vobqv+Vf1QH1I
MfmtcHb6ZyN/qF+qV6rvqv9uRMelsenvFFw7VEOGZT43xZL8uzH0nizcKT8J
sdQ6tj719rmJ67zqvc5Hs7p6rc5E5zsp3Ou01ynI3Zi45g0Hzsw7z8uJ81/5
sjx1b1OPayy6xncMNUjzuub28/j+Qsk9brhmPeybip1jM/830X+OYcAviqaP
gX5T5tlPM6DmIM1+moXU+zUD7NfcXmMezZ66C6nODCo7frXWyf9OJefyo6zb
JPNaB5A9krmnaE6XjxQDmqXuC3O+7osPhjuO/nX9/3+TYutz5J/WDJ35rqW9
X1v2PUq164HM8SSdb0GbVPQcOT9zHVccal7SfXp9qJ/6N6TackDzbcH/21Zl
vrfonnID+u+PrWexZvDE940c8PrU56i7VyGxTt1jdO9Xr1SfHV+yznP0/yaz
PzVTnxY7ZpeXnBuy7Z285wDFyWPoHJV5v3dnzg/Rdd/Q3Um2jch8R9Vaq9Hx
PyxlxHY=
          "]], PolygonBox[CompressedData["
1:eJwtl3uQl2UVx99dfvtbyt/tfd/fT0QrJfBCIGqyrLIgl+FiSi67uJAskEok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          "]], 
         PolygonBox[{{3438, 3437, 4773, 1783, 4775}, {4970, 1940, 4969, 3765, 
          3766}, {4965, 4964, 4971, 1940, 3824}, {3827, 1942, 4976, 4873, 
          4874}, {3125, 3124, 4144, 1261, 4143}, {4287, 4286, 4290, 1389, 
          4289}, {3246, 3245, 4153, 1269, 4154}, {3939, 3938, 3518, 1252, 
          4127}, {4152, 1268, 4151, 3437, 3438}, {3766, 3765, 4975, 1942, 
          4977}, {3823, 1939, 4968, 4964, 4965}, {4874, 4873, 4974, 1941, 
          3825}, {4973, 1941, 4972, 3245, 3246}, {3660, 1783, 4774, 4286, 
          4287}, {4123, 1250, 3517, 3938, 3939}}]}]}, 
      {RGBColor[0.9884024655187821, 0.8410061637969551, 0.5640476431082243], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHmQVdURxi8w82YG3rtvvQ9jFCIEDLIFKIEoOwImoAiJKIwSREQKhIga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          "]], PolygonBox[CompressedData["
1:eJwtl3m01nMex7/uvc997uX5Lc/yw6AampJKCadCqyhOjaVDJJUsaZKMfQkl
hDMpWTpZ7tUtlXNQN/s6U5OMg0uWMYOUxDTooAVxbK/3eT9/fM/5fH+f/fP9
bL/9z75o5NSaEMKXnDrOuCiE+wFOyIWwIA1hXiGEUkMIz/PtsySE3uUQRteG
MDEfQh/gd6C5EtrufFsH3LMYwmru0+pDmI2sGyoh3LcbcpBxI/AAeK6Adyry
KuD77ok8DKhtDGEb+I84W6H9mtMfWY9xHqg1z0B474hD6IX8zXzLsGdmxbKb
uf8fW7dXLGtvzivI/3dsfvGI98rE+s5FXifk3ZqF0NRo/26Afif4tQoE+PHQ
T+Q+F/5WaBZC+zd8PBpZefzbgL5d2Hcc8iLOefC/Bs/Z8EbgF4PbCE1jvXnE
u4n7MOJR4FtfbG0q+y76ZuD10EyHdgZnA/B8ZAzK2YZ7gDvBcyz+bubbOO6T
sK9HjXV2hH8U+k/lTMXWizivx/ZV+lqgj7BxHvr2wp/GzD7KV+mU7o3gt+P/
V5xuqXnEm3CWAV+dOpYZ9y348ianM/LOR0ZX9B/Bex6Irdcj/3zk70D+Cu79
4LkYfAMyTql1Tv3AvRX+oej6gdMP2eOg/63e/o2Ftj3fDqwxTQfgoeD/CP8s
7g+VQjgHe/eo8Rt8B/0bsW1RfnZB/o6i8d+g7xNi9zY8HfPO4duhnc59GCFY
ic4ZwLclzk3lzHvgVyP/iXrjTwG/MfXbzIdnDLbnofmlGq+u4JJqfMUzCvo1
sd9vDvLWAneB5kto3+UshHYFMXqGWD0Ifgj2ToJnDvaugv8C4I+r+TCQb09j
29DU+rZyXle+Rdatb8Ldm7p2FyLveeiv4cyusc6DwKXE4NAG1+gxyO+Q2TfZ
3B54ceLYRuBHQT8s8r2FswbcA/jcB3gGPO3gfwKb1xLPNr4tgHYB8d5e629P
ghsROx8Wg18G/c3cR6pXcH+N+8mcq3J+45OAR8fuJY+Af4T7AGzYVWf8NNVz
anq92V+xpW9q2c3gN4HvkTo2iofepmvmWCqmB2X2Qb7cpHhBP7lk/MXEZBfy
zqjq3xP8pdAvkk7gDZwysldDM7LOb7Yc/IX4OKTOOb4N3vEV57ru44BXIP9X
5Pcmvt8k7gmq9ZizBHgOPAcQq0XwNHK/JXN81JNuA54dO1dFsw5ZA6FZp/yD
/2FsW5vYf8V4OLRHpY7dQvz9DPzPid9Gb9IJeLxqLHWPUK9oztxbVqJvMXBb
Yn7F4HTwbypH8q5Z1e7/Iteq6nECtLcja0jOPUi9qAPnBeg/4dtp0Pflvl+d
a1q1XVd0r5WPtcC3Iq9fjXmWEMtuqoFqfcr3u4j3luA3iKGfkjj+V8DzOLzD
oL8273p8TrHg2/vgLwPfCnw8+OvzrocPkde/5PoWfiX4w8ruFephhwK/qBwH
X088vuf9WjL3fsVIsVrJmQ79XtC3Ag8u2Vf5MKjknqXepTcfi74zuG/K+f1n
KlbQLK23D8ql7kXX9hLNCHC7Z55dmlGaVVdX61f2qdeuKphWMiRrPjKH59w/
vgD3seZhvXveeuDpkd9GbzQH2rbItXAU+guZc0i5pJoeoVlC/z6vwTk8K3VN
qDZUU925d1QNQ7+deDeBW1NwLNRT1FtGFh3/S9BxMnAdOrJG1+uPyB/Dt09z
jtnpwPtktkX1+2nkGlGsRHMm+OfQORGYT6En8B5VevnwRuQcVC6qR2zR7KrO
G9Xkq9Aejj/La+3TWOz7IHasFH/lknqYetlydNyPLz2q+8s/OYcA90rMv0r7
BPLuyvy+2mnuBB5YcK/QDnQhcAGeh3Ku592BmwuOVQV7/4ysKRXHUz1nCrrf
LTiXtXPsSDxj1I8Vs3/gz+bItSx/jsT/FZFzVzmsWfVoyb1RPfEx4BOq80z3
E4H/Ds254Bs4Z8HbqvrPeYZrlv+EjRPQ9zj3dpqVRduumrsT2zZWPDu1k2k3
G1DtPwO471txjestleOjgc+q2F71kAkVz0TNJ73hs8AHV/uzYqBY3J26dl7m
2z3arcrOZ+1z/+WtWhL3auXcPOzfmji3ZN9XiXdM7Zqq2Ze4H1CyL4r5/sCT
Mu8i6o/dwO+m+II/WAml2o2ce8qp3rKl4rt6an/gjhXHWzn9J+CdReeK6ku7
xVvV/Uc1qlnbkHm30jzVLnAM/kzL26f3Y8dMsXub+yD422V+W8Xsc+g3VLz7
6s32AT6k5N1SMe8F/FTiXqedQLuBclS5qp39BXAh9WxVf70JfXuX/PbK6T8A
11aci53RUQe8tOhZpB10Lry9K95VtLP0AZ5cdi9QDXyLvNnV/Vc7bRO8Dxe9
G4r/UnDNiWP7DjRHF91D1UvVk7qjv3PiWSQZPanNXOpdSPH7nFjeV/RuLRrt
EtrJNS80f25B/+XYsyDvmlPtLS96F9W+pn+FwxLjRLMz9k6letcbHAvcUrDv
2mm062ima7brfTU72pc9LxWDV2LvaLJPM7AN+7clzlXVkGqpqVrfyqkO6B9c
tO96L83qk5BxIucvvPPkzP8oym3lg3r3pMi5oBpULWqn1Pteh77jyt7hNLs0
4zTrNEPUH/UP0JnYfpv4X0g1pFn6UWxe0Q+F/uXYvsgn7QKLMs96va920y7V
+aeZ2xa7Z6n+tSPP5b4s8/6vebQ0s0zJ1kxdD/5M7BmT2kf5OrxsezUjRwD/
K3PvVP6oF8+K/ZaKqd5eNaxaVs+M0P2f2PHRzjBYssrelzTDHgT+HVqK8NU=

          "]], PolygonBox[CompressedData["
1:eJwtk8lOVUEQhksU8CaHwyWcA2uWmgg+AIIyiAxOVxkuEDGEGERmEkHmAGvX
CnF4BEUZ5TIKiTvewKCJiXECgrDlq1Qvvvx9qrv+7q6uk9PcFetMEpFcSIaK
QKQcKuHBeZGb6KsMkUiKyGt0L13kG3z3UDgTFdk9RyL6JBQZj4h0oJdYk+vQ
cYJYgrkV9J9n3lV4N5DXCB+JLzH/1RcpIF4Iqy7nJ7FbfN+GbmITxHrRPHwv
w3X1wa8ULYYS+M0ecWLXGE/jPwMDmSIvU0X60QSeq1DDfDPrqtF7cB/iUAf1
0MJcI3rE2hfkPiW3F/pgCs9JqHUeB57to/uVuTP98cxTvX/pnpx9PbQaai2f
s7aYwn9h7iLfF+CDq8UsmgxZjFPRObzmYRbeQz65J9T+CvqZ+TXW/fXt7HqH
tdD220Dr8I3DOPEx2Ewz35TQ6qr1vQMPOXMMnSf+iflFtIy8GxDlzukwDNPU
4pi99j3LuRtYLbQmulZzlsldwWMJPfSslg3aV6xpitp59Fxb7uybob2Jvs0I
e8ywxxg65PYbzLR76/313fX9d8hZJ3c7tNpojd4yfkfsDXrim8+oO7veocT1
yZ5vd1xgXRd0Qq1v/dXDOALZjLfSrGZau304S+wwsP7X/0B7VXv2amA9VxRY
f2ifPHM99x/fR/iNktsa2jvre7cxfgwx3/6ddq27q9sP3/5F/SdPASxEgnU=

          "]]}]}, 
      {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlmlsVUUUxwcohTL33ff6+l5UCFREUAoUkA9gImhMg4A0slloKZRFCkJl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          "]], PolygonBox[CompressedData["
1:eJwtlnuQz1UYxo/9WeF89/rbr+lKaI3IZcsMXRjTqCRKaoxddsslNZjUHxWp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          "]], 
         PolygonBox[CompressedData["
1:eJwlk81LlGEUxY/lR9Mz82oyMwsho2WYlUklZW3aSK40IggaK1LJhRXVQgoq
RCvQhZsgpEWKRaCgiRQtSo3xqwYT6x+IRslNo1kSVvR7vIvD3HPe+/Xce2fn
hcu1zZsk7QY5oDxfGtws9TrpOdgP745Id7Gzw9JwSHoak7aDUuxV9AGQwK8I
rQRtBd4PatGOE1OFPQpaKHAFnkF/ly2NoFWD0riUVyC9xB4DffgF26iNPgdf
A4fIu4v8Pejj8FlQs0WqiEr78JuAz/g+cqV6+i1Hm4f/cNbTF7RKfE8T88nZ
tw0f6r7B7gTrxA4USgfRF+A/nb0xTexFcJbvU85q+ZoHwFfsNGggb4L8DfR4
L0u6ivYbNMIz6FVop+DfwTI8yQyGsOuc9XQU7RxoxF50Vt/34WfoZ5kBRfQS
Jl9ALzfgv8AetGK0SnyLme1D/xb2lwykCH6d5FtC++ZnGLc9+X3l4jtG7BSx
kyAHfh29gz6T8M8Ftq+3zubj55Qi9gV2k7M+z9NvC1qCXQ6itYFpau6IWV8P
4O/BSWb6LGa389jZ/vwee/BNcHxdznbvb+AIPebTSwBO0Eua39vEzzH7D85u
yd/UGd7XSr5/8D/gMHGpiM1oGf4RlKH1F9peU/Bb4CY+x6jzCnsYPKH+YsTu
3N/7X2d5r9FvB35dzLIb7RHYG7db9Tcbooeyrfxh4vY+/877zvq8A6+L2k1c
QnsN2sm1EtjM88J2N/5+/gMaeX+9
          "]]}]}}, {{}, 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV01toj3Ecx/GfnFpsZswFsRCx2eZsDkMOC7NoNMxh5rhYTG5oF5tDDjWH
KDcL2TI35JBIjtkWw6RwgbGQw4qYc3Lh9Vy8/5/f9/P9PL/v73me/9N3xcbc
DW1CCIP9NMeGkBIfwj2aRe/TVFrcHQkhJCfKYXiPEIahUb+zOrdLCD3pG/UI
/gT5TNTzs+NCGMtbq78GybwL9CImyUzBp84hVJrzmWapp+Gy/iXMkL9Cr2IW
Pwdf5JbIz7X3On4x1iNN9hq9gTlyufgqu1O2leap5+OW/k0skr9N66I1fwm+
yRXI59l7I38TSjBUtp7ewUj3s1Q2je6SLbBehlHqb667K7NMvjd955mM5i/X
L0Qjf6HMOF4+3Rw9T94I/IjqbiH8pFvoDVpGf9N4+ouW0gvOmGnue3sXuu4D
nagupae9pzN4rH6KEtmpKOOVYx6SzOyDOPkxzhFLY9TlzteBto+evWuO0xM4
hmpUodYZ6jHBdXX0n/kDkKkeSNNphblHu/o/qBtk9qmLrPs7+z11td5J1OCA
3muzMsyuUp8yowaVzpRhr9boHeKtTJDd6frd+nuxB9vkdvP6Re+Ctpd5Jzte
3aC31dyH6mSzH+gPoo00hVbQR57Hfhpjdicckm1xzWEap+5ovyr7dKPV9BwS
7H2W7pV74tr+6qf0IBJ5QZ2Kr9Z75E6alWS9wH6LkI/t9hvovgZE/x31Yfdy
CIny23g7sB0fneOIbAuNteczM4qjbyh6Z+rH/O/RfwcFek2yr9CMxXozzH7B
z6JNdCZ9TrPpbMzCeXPPRd+B/HTPo5bGR9+hdbqzVZh1Pfq28Is/hJ+Kl9ZN
WKn/Uy7B+g9drR7qbKsilRuGifxe+pNpvF6R3l/r3uiDfjJ9cczsHHPW6beV
b4cTvGpennv6Dytvo4s=
          "]]},
        "1.3`"],
       Annotation[#, 1.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV1Htoz2EUx/FnUdZsxpA7aZS5XzLC7MaWLGyMMZaImEwI0fCHKIQUcjdZ
UTLkEpPLrKbcSSgxY5HIMIX/vL5/vPd5zjmfc57ze37bei9YUVAWE0JI82Nk
fAhD2oZwHdfQH63ahDCYDsRf9dKkEJZhCR4mhNC6YwiV8qnq78VTE0NooKPF
ZfQ0X54Zt8U1GKC+RE8KvUTr1cZ3CCEDmTjMk0snIhsN6tf4cvmr6SfxJPnJ
yEMx/1S5pWoFdDkdxHuTfhFP4ZmGfGzhnUULMR1f1Wv4ivhr6XdxkfycaC5K
+AvlytRm0VV0CG8dHUab5Ba1D+EHLaVX6UraTOPoz2gfWuV9xpj10XsU62uk
Y8Vr6VnvM5vvqfg5lvOmY42+tViF9ViHm3wb6SYkohwbcJF/nN4LtBtd6I5e
tCfK3THNHfl4Eb0VnYJ/PC19jtvqM8Q1dCZNpLHytXSzN7hLW4mvmF1BF+u7
Z4+3dH+7EA5gu7mjeFOxT1yn3tNeB/Veopejs/xhvDNnJ389PS5uMGe3eDPv
SrqJnuCvQKX6cXoMq9XOiE/jJB64o2/0Lvrj7FWn75f7P5gbw3tUfN/n2coX
w98CLdHIv5fnj95Y8WOeR6jg76cvBRt4nvAkOW9zHs47AikYhVTsMveZvj3R
d21OPBLwlf8bqqK/BXE+ChBrVh/7JWOm+KJ6mv4OdLx56TgnX4XP7l4ffZ/4
adav6K2d92GZc4a+TBTxFmMumuTPy82zzzxxCR0tV2hWptmvxBn0Nc2iL+kE
OhHZOO8Nq1DDn23OHRpv1yzngebtsOdV897a4QpNiP5P0Fy91fSQ+CBK+G6I
h+oZjC76O2OyXBv1+eq3nLua/Q5pPG9oPd6jWfwbnXDEDj30HqV5es7oTZfP
RFb0uyF3Sj0gBt3leuEYf7J4L/9JnhxaG+1KK+VzfPYbdrlv9/+1iKxP
          "]]},
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV00lsT1EUgPFrJsbOaoFKVURMUTG0pkQMixpaXWjVUMRcNSS1sZBKGixM
iYayIFFFa7ajqJkirSAkREQRFJEgMf/e4ut3z3nnnHvf+9+mFK7OLmoRQhjq
z8rOIVzrGsIV1GGHOD0mhLj4EG50CuGQ3E3+K/cPv/AHv3E7LoRbeNMthCa8
xkT9vWJD6I2e2C5OVtsdifiB7zjkWYXZ+3FEzSBxJQ/mffZL4r0crzYWn/HE
mb5wJpKtM/gTHlsX6H3ECfo+cjMGeDYQ5+yR73m58+XxaXEn6444aX0KZfL9
1Y7V30Fvrb3HWV/i6oQQapDhXccgEw1dQhjND3kkN/IozlY/wrw54lzz8vmE
Oe/lZolzMCN6B7kMLJff6Ry78Mm6GRusS/Am2lvtcQw3Ox1xzjlSXw1Pk09x
1j5opb59YgitudqzdlEfD1fbZGZbcRu0RL3cXRzwPE19P2xQc89+fa3rucr7
HkWqPfshDaXe5SDHqw3mfLP+jpfiP/p+4yc2qfsb5aLfV10F9uKa/RbYd618
b30p2C1fjuf2LNZbgxN4oWaj+q3Wi60L9M2N7lP0LbzvM/Wl8k95m9wWXFaf
q2YPZ/MFLpMfpj4djeofola+kC9yD/PPmhHrLFecO4brOI4v8RlOVbueT+Ek
fognmT8ZDfqn8hSUmJcoTkKBmoTotzB7VPRevFJvETqgGKtx3h7LeAUWYSmW
RPdM/QrU672DY+YfRY76Qs8XogWaxQu4Su08fi/+Gv0P8HxxDc/ld5zPb7mA
R6u/Ye51XMVM+Sp9WZzneRN/EL/m2eLN6s+7Dy/FOeJX0f3m5zwzuvfIwgxM
xzD1S1Fndi0qzTqMVb7RCPE032dCtC+P53E4HN0BNWuwDOuiu4Iiv90qDFXz
QP9kvs9DOF3Pf7AvrQo=
          "]]},
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV1FtMznEcx/GfnIZCqTZkKm3IqbKFLl06NKNh02bMmJvM6cIMySlWXMho
LrA5PU/DYpM5jIsobM5zGMKQMzPJ+fD6X7z7fA+f3/d32L8na+6iqWUdQgiD
/emSFEJB7xC60tW9QjiWHMLbxBC2pYTwXW0rrUa9+i35MvE0vhJ8lE+hn+h4
MxbRdfof6AX5e1ohv8JT3ieEtSjGBqxHS88QKulmlGATNkZ9+9ekhbAD763/
hI8o5n9N36DR/Fe0FV/NP2jdIZQijhiO8rfrf8OXyIc2xMzfafYuJPB1Rqfo
DPx/9P/iqvm/6S+0m1+nn0Xn02x6lDbwJ9EztAc9TRPpMfNTrW9w/1LeU/Q6
vYb81BDysNJ7nlSfYH4NrbdukP4q9TUoR6UZ98wq4F8vT+NJxTy+DL0BUV98
F3FxGe7zV/JuRH/eflisP8s+pdiiXoVq/FRvVFvl3Fvlq+kjtYdos+4LvpuZ
It8tLtfPps10ID3g/fbjqj0z+bKwjHcpcsS17tVs/uXoHeV/Uc37XP+52iFz
/qkdpi/kFXSJPNN9JzpPTP5SPdmcBbSZxtTjeGFOQrQflqPVzAr9PeKF4kL+
MZjEu4vWoot5D+Rj+CbTsbSQt9isEe5zXX84vUFH0ms0j+ZjFOrcNY5z/EXm
naUd00MYJx5s3jrz4ubF0M05uqNOPF19u3gGPSLP5R2CzfJ37ppi/S16B7fR
qjcORbhpj+PWnMAB/qG8w5CLnXrp9CHfP+d7RJPRgsfYp1foDp/Fs63tE31D
0Xeh3sm5M2i/6H3tma/eRJvxRPzUeZ9hhT3m4Lz9m+xxKfrOo9+L6DeATsNF
/dHWFGCBfX7Q+bSKpy9NsMdCmqmehT38OWp7abX3rHHGquj/nc6M3in6JvAf
q9mu8w==
          "]]},
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3168, 5622, 3641, 3908, 3192, 5061, 5060, 4576, 3395, 4322, 
          4323, 3647, 5661, 3646, 3999, 4000, 3653, 5474, 3652, 3195, 3174, 
          4577, 4578, 4327, 4328, 3658, 5663, 3657}], LineBox[CompressedData["

1:eJwV01tMz3EcxvFvbBhKKDlkuKAcLmyEK26Jq5hobPwrjSiWQ5nDHJqpmLEx
xiqHmMOGLpzVMscbtTnfyGnMWVtp2fD6Xbx7vp/n93ye3/dXa1SsOKsoLoQw
0o8TfUMojA8hblAIx51T+4WQlBRCMgahLjGE0+jN70oOoUCm0TmPfhgYwnu8
QywhhFy5cXpidFj/EIaiUnaw/ixeCn2p8xUC4tANe/jf6V76g8Zom92l9IW5
QscVXEUlL56XgH44zGtyl6/y3/AZi2S+0DvuVT0ghInuVkNn8BP50+krmsQb
iIP2M/Wc5E/jp+gdjPO8Zs+m8KaimdeCx+hjr79v7UvT6U67H/mforvx4jGP
t893z6VndNXSHuZ2utvzDlpBN9mpor/NlVGf33Marnl3hnyV7+jyDZX0D63l
1eCv5/nyy5CL+/bzaGa0532TzZnuPYk+p93tHoq+F7PMk+kkjHEejV7OPaMe
/LPfqqeGX427OmL8RPqW1umayR/h7sXustX8hn+K/jafpK3m13qq9LS5ewf/
Hu8uDunJsJ/tvAA5WIhHskd9+zEMsTMcqSjTd4Qm6mvX89P5F56Yn2KD5zv0
radNelbKbDdvwxY08hPki2Vnez4HG/mb8Mw7O/m3eLdxE41oQKl7Fuoqoy0y
ZfJP5XfxntBS8wZc0H0eB+T+2QvOq/nj/X4mYIn8WnMJ1qDefbrL5OjslL9o
LuKPlR2HcvkV5uUowEi5M/L79X+WPyu/hJ8mm47F8nnm3Oj/Buc8/xb9ne1V
2Os0N/CXyRbgqPwN83VcxQ6Z7SjRv9NeOa7w82Xbfec9PR30AV3nb/OQ5kfv
xGo7l+Xro++I7uBdl5zf0fk6FyAbLXKr+M20mG7W8R+Tvqcp
          "]]},
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV03loz3Ecx/GPYcZmh2P4g1xD8Q9/OkrNVURohRRbjjm2CZtjtiJ3uSZy
+0P5Q65CbTky1yjHmG0Ymz8wmms2hSiP7x/PvT7v9/v1fr8/v+/3u35ZeTNy
24QQ0vyZmBjCnOQQZqOqewjP8Qw1qMZY9Ur6FE/QMSmEDN69XUPYhz2Ikyuh
o3h301jxLtqeTucdKV9I99NLdLT8GBQ5b8DcBL3iTPWLXUKYT1fblal2SO1e
SggV2NIthM1I7RzCoNQQPsrNcm6ks+kn2kk9HlP1TkNbc2+6Szlu4bx4ppnX
nevUX+ElRulPsXtrNEf/FposHmpPEk0y+z3e4Zi4Cs/Rx7w37tqb1tONZu10
/1rnF/hlz2/8QSPPR+xQf6J3O93JU6CnKXoG9g6RP2n3T+cTtIW2YgnSeJfS
ZWint7u7taetfNv1tUTPhafUrA3ienEhLUYR/slPsesRz2M8RIz7DJDrjwnq
tbQmwu8crv+8XedwS1xI1yPGznS9B8ycKH+Gb4TzYrPmRe8P++RL8NrMEnEd
jXffBHTCXrW7KDbvDk0wo56vARPEveX7IMddxovHIR2n7H5pzwt880y/opVn
rfxtvfm0h1xPpOKoex7BJv4UvgfuscK5l3NPHLC3ie8vz+foOzHjC93GV8nX
wvMDzVhl9lX1lTSOp4zG0lLagd7Xk6vnsjjPXfNRgCXRd6yeqLZSnEQPi/Pt
LjMvjz9HPpeWirP5l4uXIRsX5Jvlc/R9p2fF8+QXYlFE9DvMi1fPip4lPSie
bP6V6L3w34h89LL4N70uvoYy/ODL0HPa/Qd6Dt/FW/ma6TDvaptzgXfR17mc
fw3P2ui7xSe7P9hVrLci+p+mb+UHOzfQIfQEz3F8VZtkToF5NWbn0mq6nm+h
O62jC+h/KvSu+Q==
          "]], LineBox[CompressedData["
1:eJwV0DkvBFAUxfGrN5ZYIpHYGgVCQSMUZmJiiYJoiMag0JDQiYpPQEOjoLO0
JHaFtUBoSPgIloQCnd8U/5x3zz33vpdXnZkemMqJiEnU50esFEUk6FtBxDsW
ciM26SL9oJ9Il0R0Yl/2oTCiJhFxxb/GDQ74j/xa/q36Dvc44h+i12wP6vTX
i91LN2hZXsQ2bVRv0Sa6Qwdk+7HkXcuokhtUV9IZ7+rGrtwenux/xiyvD4e8
VnteeK9oMFNe6k56oteud0zPcIoRe1fdMWT2y7lZLqlOYZj3zWvJeubO5S9x
gVH+mkxG5se5TaZTncYY75fXnvXMJWmFN3TQOb0J/Omn1F36484TGEMXb17/
OPt/+AffGj2k
          "]]},
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV02lMD2AcwPEHlTt3OZoJMVeGpMyMsfGmrcy1WRheYHM0EnlBzsxm5Rxd
NOcrk7KJOd/iBVKO3PcbGWZIfP4vvn2f3/k8/3+VuGTNrNWtQggpfqR3CmF3
zxAKsQv9OoewhzvGhlDMA8RFnMj7OVa+lJPEJTyEy7ibfAUPE5fzcD7O8fIZ
vUI47XwGp3AOZ5EpX9QlhBne8Nm5v97J4hzxTFTrSbWnrkcIjzBUvW+cO/mQ
vsMY4bzA7HDONZOFq+YmmWs08xyj1RLMJfMRM/P0NJkZK54inor5cl/lxslN
NXtMbpHcD7k0ucX82q7bdt/CInGe+kIk2f1K7SVuqi1U2yCfzS/kptg3wY7v
4mz5zK4hzOUv4ij3jFHLlyvmak6Xm4j94r16Zuu9bs81tOAvDkW+M3cd5Gbx
H8xxT6G53TiDWeKjdrT2vlp9GXZf4bvm7uEOsvTMccdAfSXd/Z65oVsI4+Wr
1C+ig3x7vHfeZ36I81Ak4Zi+PuYbuTc/4w3uzsV59/XgGr6Ezc4/zdd4aymi
zcdgkPsGI978U/Pp7pmINPE/8Trn9cjX+0S8iR9znPofO6fZPR3N3h7rs0ap
VYqjucXcPzRH/u7Ef7naG2qd25i/wqk8AePRIi62vwg7vemyOMM5xT0PxXV4
gINyB5Bg3337YtzbFtGR++Xfyb+NvNn8dnt3oADrvXEbr/S+0erJGIWr8kfl
2+svcNcJ8TN7KrmRc/gpH+cnXBH5/9R/R+9n3+UnNNm5Vr5WfRX/5ir+xRf4
sP6t+hvEZeJ6LufHvIIfcSnXcQkX6T+p/6PdH7BZvFw+0We84TtY7t0b9TZ4
cx7X8xb97XiA3o+8RM9SLIv8TuXS8c33dcl8DV7Lv0GO3leca08XPV1RpX4R
1filPkJuFEbiobgzP+BYTkA//AddJLGI
          "]]},
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0stvjGEUgPF3dIt2pjNNRlhUSdi4tN1IURoSpUkbErcNsZFYGBriGh2J
NqHMSNq0NQmbigUS6jb4E3RXJDpssKrBSsJ0aP2+xZPnnPOe95xvvm8aj2R2
H4+FEN6jb2EIR+tCyHKZv6GYCOEFhupDGEaNuHdRCMvjIVwWl8W/9IfFIZxO
srwp5S438kzUy5O1ISS4HnGkkMSsu0/sqfBFPa3iFgzI/5hXwW9UMYt59aVm
HuM2PBXXN4TwjKvymJkLEPBc7b5arXl1WGL+tHqaSzyhFtOzWdyONmzCRmx3
tpbXYU30nPrW81/zWiLLm7nKh807hC3ymPdw1nOeQ42zjuh5eCufUUt61n/y
VnlG/pm/4IT4JHrxwO6HiJs55+yqnSXxNR6Qn7ejny9wjvP4hI8oqBV8lzR/
9Y267aqYNaU2plY045K8D6NRziOc5Xt2XEE/etybj2brz4pvcoLLarvEg+50
8w/5KvEGZx/MuG3PHexT34ui3/MS0/47++Wn3DnAr9Reo6R+UL7ajJ/c43zY
/hXytHe1ktvlTfzdeZfzIfke8WP3J/AIzfYv0zMTfTs978x9iyncdT6ODvUM
Uvq69DVw3qwcOuW39BQwgjGMYod6jvMYxA1cx7boPfi9kzxvzpvoP2fOTrVO
jGNO/T+aXHnv
          "]]},
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwl0bkuhVEUhuGlMA/HeIgxQoKCEoUIicQQQ6Kg1xlCozN3QlS4AUMUevQa
xzFeg/EeROI5Ubx591r723vt/H/z3Mr0clZErGGkNCKvJCJVFfHL1xURN3gu
i6gtjnjgJzyityjintO4Qwpvzn3gHT32r5ztSEYsuGtdb5G3eBsbWFJv8o7s
qWx1IuKEa/iMk9zq/Cz/yM3wvGx3ZnZlxKg3pXiM03yhv2rdgD11I794V5E5
w84X87hewp0TfCmfLdemblEfWh/hyewle/04N3OAP53Psj73jc4y30kuFzmo
09+V+ZWZdE8BNvQL+db8fXvrZg/xt0ytdae9V3Mm1VOo06tHl34lf+kNyi+j
XF3jjRXcbv/AvIR1tV4pv2T+EVrtHZvb58yj+gFpNGXeJJeUzy/5/89/o2E+
Ow==
          "]]},
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], {}, {}}}], {}},
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotRange->{{0, 3}, {0, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7075128277395277`*^9, 3.707512853802136*^9}, 
   3.707518479354604*^9, {3.7077448345481863`*^9, 3.707744972153647*^9}, {
   3.7077451346301193`*^9, 3.7077451952824163`*^9}, {3.7077452279647913`*^9, 
   3.707745234958761*^9}, 3.708023243269985*^9, 3.708025662939242*^9, {
   3.7080298864479313`*^9, 3.708029923069954*^9}, {3.708030058986475*^9, 
   3.7080300754518423`*^9}, 3.708122899445099*^9, 3.708251619025188*^9, 
   3.708269327179734*^9, 3.708279149314932*^9, 3.708284300143374*^9, 
   3.708302878714542*^9, 3.70836052826725*^9, 3.7083661019911537`*^9, 
   3.7089991228341837`*^9, 3.71920930956399*^9, 3.79384511279031*^9, 
   3.823229650703519*^9},
 CellLabel->
  "Out[3355]=",ExpressionUUID->"6b2f641a-ebd4-4cee-98a7-40b146de4bdf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Kd0", ",", "Kp0"}], "}"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Kd", ",", "Kp"}], "}"}], "/.", 
       RowBox[{
        RowBox[{"Solve", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              SubscriptBox["\[PartialD]", "Kd"], "J"}], "\[Equal]", "0"}], 
            ",", 
            RowBox[{
             RowBox[{
              SubscriptBox["\[PartialD]", "Kp"], "J"}], "\[Equal]", "0"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Kd", ",", "Kp"}], "}"}]}], "]"}], "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "/.", 
      RowBox[{"\[Omega]", "\[Rule]", "1"}]}], "//", "Simplify"}]}], ",", " ", 
   
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Kd0", ",", "Kp0", ",", 
      RowBox[{"J", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Omega]", "\[Rule]", "1"}], ",", 
         RowBox[{"Kd", "\[Rule]", "Kd0"}], ",", 
         RowBox[{"Kp", "\[Rule]", "Kp0"}]}], "}"}]}]}], "}"}], "//", "N"}]}], 
  "}"}]], "Input",
 CellChangeTimes->{{3.7080299405737534`*^9, 3.70802998205451*^9}, {
  3.708284340063931*^9, 3.708284344011715*^9}, {3.708999132249243*^9, 
  3.708999147599283*^9}, {3.7192093141580687`*^9, 3.719209336382187*^9}},
 CellLabel->
  "In[3356]:=",ExpressionUUID->"557e3b8b-c46d-4587-a58f-d72eea16ce1f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SqrtBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox["2"]}], ")"}]}]], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9101797211244548`", ",", "0.41421356237309515`", ",", 
     "0.45508986056222733`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.708030015370644*^9, 3.708122899590818*^9, 3.708251619149344*^9, 
   3.7082693273016977`*^9, 3.708279149447503*^9, 3.708284303464769*^9, {
   3.708284344444607*^9, 3.708284366222878*^9}, 3.708286207426045*^9, 
   3.708302878837575*^9, 3.708360528453187*^9, 3.708366102152585*^9, 
   3.708999152462461*^9, {3.719209330717359*^9, 3.719209337128324*^9}, 
   3.793845112843321*^9, 3.8232296507646837`*^9},
 CellLabel->
  "Out[3356]=",ExpressionUUID->"2b83d9fd-fc3c-4bc9-a86d-b60f68d8c1f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"J0", "=", 
  RowBox[{
   RowBox[{"J", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Omega]", "\[Rule]", "1"}], ",", 
      RowBox[{"Kd", "\[Rule]", "Kd0"}], ",", 
      RowBox[{"Kp", "\[Rule]", "Kp0"}]}], "}"}]}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.708030228930242*^9, 3.708030263630135*^9}, {
  3.708999156815114*^9, 3.708999160263069*^9}, {3.708999206906021*^9, 
  3.7089992156970053`*^9}, {3.719209341451952*^9, 3.719209343059743*^9}},
 CellLabel->
  "In[3357]:=",ExpressionUUID->"48c040dc-51fa-4fc5-9e01-2ba36a0a0ea8"],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], "+", 
   FractionBox["1", 
    SqrtBox["2"]]}]]], "Output",
 CellChangeTimes->{{3.708030226618579*^9, 3.708030264629312*^9}, 
   3.7081229002142477`*^9, 3.708251619671855*^9, 3.708269327888527*^9, 
   3.708279149571186*^9, 3.7082862095370283`*^9, 3.708302879306799*^9, 
   3.7083605285010557`*^9, 3.7083661022173033`*^9, 3.708999161302525*^9, 
   3.719209344895133*^9, 3.7938451128532343`*^9, 3.82322965081817*^9},
 CellLabel->
  "Out[3357]=",ExpressionUUID->"73cc36fc-c173-4475-9144-ed1baf88ac2a"]
}, Open  ]],

Cell["Introduce scaled quantities", "Text",
 CellChangeTimes->{{3.707347555181609*^9, 3.707347582594514*^9}, {
  3.7077445651667347`*^9, 3.707744674574999*^9}, {3.707765307804101*^9, 
  3.707765329640802*^9}, {3.708968298464109*^9, 3.7089683022062263`*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"2b4b147c-a035-43d7-a6d6-b084a39cb59a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"j", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        FractionBox["1", "J0"], "J"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Kd", "\[Rule]", 
          RowBox[{"kd", " ", "Kd0"}]}], ",", 
         RowBox[{"Kp", "\[Rule]", 
          RowBox[{"kp", " ", "Kp0"}]}]}], "}"}]}], "//", "FullSimplify"}]}], 
    ",", 
    RowBox[{"j", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Omega]", "\[Rule]", "1"}], ",", 
       RowBox[{"kd", "\[Rule]", "1"}], ",", 
       RowBox[{"kp", "\[Rule]", "1"}]}], "}"}]}]}], "}"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.707748730227459*^9, 3.707748774844473*^9}, {
  3.707748850491117*^9, 3.707748851963303*^9}, {3.708030269734478*^9, 
  3.708030280902513*^9}, {3.7080303185201473`*^9, 3.708030321046076*^9}, {
  3.7089991667282*^9, 3.708999173191142*^9}, {3.7089992183356533`*^9, 
  3.708999254487769*^9}, {3.708999971353649*^9, 3.708999976493249*^9}, {
  3.709000522617498*^9, 3.7090005265315723`*^9}, {3.719209347939794*^9, 
  3.7192093554512463`*^9}},
 CellLabel->
  "In[3358]:=",ExpressionUUID->"823775c2-2a77-4b23-8fe1-4360b731f93b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox["2"]}], ")"}], " ", 
        SuperscriptBox["kd", "2"]}], "+", 
       FractionBox[
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "-", 
            RowBox[{"2", " ", 
             SqrtBox["2"]}]}], ")"}], " ", 
          SuperscriptBox["kp", "2"]}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}], " ", "kp"}], "+", 
         SuperscriptBox["\[Omega]", "2"]}]]}], ")"}]}], 
    RowBox[{"4", " ", "kd"}]], ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{
  3.707748751915053*^9, 3.707748852499922*^9, 3.708023254587407*^9, 
   3.708025663621766*^9, 3.708030323952179*^9, 3.708122900999236*^9, 
   3.708251620572921*^9, 3.7082693286816187`*^9, 3.7082791503309927`*^9, {
   3.708286212602324*^9, 3.7082862199001703`*^9}, 3.708302880100005*^9, 
   3.708360529184844*^9, 3.708366103132337*^9, 3.7089991801527576`*^9, {
   3.708999222221789*^9, 3.7089992549016943`*^9}, {3.708999972576118*^9, 
   3.708999976901578*^9}, 3.709000527110528*^9, 3.719209357628901*^9, 
   3.7938451132889843`*^9, 3.823229651248667*^9},
 CellLabel->
  "Out[3358]=",ExpressionUUID->"d7ccbcc5-d6d4-4824-a86a-206843df8e54"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"j", ",", "kd", ",", "Simplify"}], "]"}]], "Input",
 CellChangeTimes->{{3.709001133258998*^9, 3.7090011742296257`*^9}, 
   3.719209361499034*^9},
 CellLabel->
  "In[3359]:=",ExpressionUUID->"046f5b3b-bb01-431c-957c-8b06d34c4f2c"],

Cell[BoxData[
 RowBox[{
  FractionBox["kd", "2"], "+", 
  FractionBox[
   RowBox[{"1", "+", 
    SqrtBox["2"], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"]}], ")"}], " ", 
     SuperscriptBox["kp", "2"]}]}], 
   RowBox[{"4", " ", "kd", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox["2"]}], ")"}], " ", "kp"}], "+", 
      SuperscriptBox["\[Omega]", "2"]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.7090011383297777`*^9, 3.709001174700644*^9}, 
   3.719209361997807*^9, 3.793845113331162*^9, 3.823229651303555*^9},
 CellLabel->
  "Out[3359]=",ExpressionUUID->"ebbbec74-3b95-427d-a81b-b9fab0e66bd2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"bvec", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Grad", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[PartialD]", 
          RowBox[{"\[Omega]", ",", " ", "\[Omega]"}]], "j"}], ",", 
        RowBox[{"{", 
         RowBox[{"kd", ",", "kp"}], "}"}]}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Omega]", "\[Rule]", "1"}], ",", 
        RowBox[{"kd", "\[Rule]", "1"}], ",", 
        RowBox[{"kp", "\[Rule]", "1"}]}], "}"}]}], "//", "Simplify"}]}], 
   ";"}], "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ahess", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"j", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"kd", ",", "kp"}], "}"}], ",", "2"}], "}"}]}], "]"}], "/.", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Omega]", "\[Rule]", "1"}], ",", 
       RowBox[{"kd", "\[Rule]", "1"}], ",", 
       RowBox[{"kp", "\[Rule]", "1"}]}], "}"}]}], "//", "Simplify"}]}], ";", 
  RowBox[{"MatrixForm", " ", "/@", " ", 
   RowBox[{"{", 
    RowBox[{"bvec", ",", "ahess"}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.709000019270987*^9, 3.709000032573626*^9}, {
  3.7192093650513973`*^9, 3.7192093716906853`*^9}},
 CellLabel->
  "In[3360]:=",ExpressionUUID->"6215ce0f-8999-416b-a742-a993324fb603"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          FractionBox["1", 
           SqrtBox["2"]]}]},
        {
         RowBox[{
          RowBox[{"-", 
           FractionBox["9", "2"]}], "+", 
          FractionBox["5", 
           SqrtBox["2"]]}]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"0", 
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"2", "-", 
           SqrtBox["2"]}], ")"}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{{3.7090000156915627`*^9, 3.709000033044269*^9}, 
   3.7090005307050343`*^9, 3.7192093728069*^9, 3.793845113382409*^9, 
   3.823229651354952*^9},
 CellLabel->
  "Out[3361]=",ExpressionUUID->"2cac1ba2-4023-41aa-b7a9-8156ddb58a49"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"dkvec", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], 
       RowBox[{
        RowBox[{"Inverse", "[", "ahess", "]"}], ".", "bvec"}]}], "//", 
      "Simplify"}]}], ";", "  ", 
    RowBox[{"dkvec", "//", "MatrixForm"}]}], ",", 
   RowBox[{"dkvec", "//", "N"}]}], "}"}]], "Input",
 CellLabel->
  "In[3362]:=",ExpressionUUID->"c305ec7e-da8a-4e9e-ab14-9086c3e8138f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"1", "-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SqrtBox["2"]}]]}]},
        {
         RowBox[{"4", "-", 
          FractionBox["1", 
           SqrtBox["2"]]}]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   RowBox[{"{", 
    RowBox[{"0.6464466094067263`", ",", "3.2928932188134525`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.709000049915421*^9, 3.709000532231016*^9, 
  3.7192093778304787`*^9, 3.793845113431143*^9, 3.823229651405012*^9},
 CellLabel->
  "Out[3362]=",ExpressionUUID->"43492125-0a4d-452a-a238-3c881dd3b4db"]
}, Open  ]],

Cell["Series expansions", "Text",
 CellChangeTimes->{{3.707347555181609*^9, 3.707347582594514*^9}, {
  3.707442063493147*^9, 3.707442072299552*^9}, {3.7075124401671667`*^9, 
  3.707512443443941*^9}, {3.709000116868573*^9, 3.709000120066852*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"0fc6b40e-54fc-4440-83a4-88ec69b8d19c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"js", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"j", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Omega]", "\[Rule]", 
          RowBox[{"1", "+", "\[Epsilon]"}]}], ",", " ", 
         RowBox[{"kd", "\[Rule]", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"dkvec", "[", 
             RowBox[{"[", "1", "]"}], "]"}], " ", 
            SuperscriptBox["\[Epsilon]", "2"]}]}]}], ",", 
         RowBox[{"kp", "\[Rule]", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"dkvec", "[", 
             RowBox[{"[", "2", "]"}], "]"}], 
            SuperscriptBox["\[Epsilon]", "2"]}]}]}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Epsilon]", ",", "0", ",", "4"}], "}"}]}], "]"}], "//", 
    "Simplify"}], "//", "Normal"}]}]], "Input",
 CellChangeTimes->{{3.7073436232242727`*^9, 3.707343661553348*^9}, {
   3.7073437049423656`*^9, 3.7073437231358423`*^9}, {3.707343757915928*^9, 
   3.707343803778859*^9}, {3.707343914550576*^9, 3.707343949868187*^9}, {
   3.707344002932548*^9, 3.707344043076199*^9}, {3.707344228097225*^9, 
   3.70734422979143*^9}, {3.707344750466304*^9, 3.707344811714304*^9}, 
   3.707745427121407*^9, {3.707748475384252*^9, 3.707748636875351*^9}, {
   3.707748826671061*^9, 3.707748835510241*^9}, {3.708030401328898*^9, 
   3.7080304025920486`*^9}, {3.709000165652467*^9, 3.709000238401012*^9}, {
   3.709000555949113*^9, 3.709000556475841*^9}, 3.719209381557076*^9},
 CellLabel->
  "In[3363]:=",ExpressionUUID->"a505b94f-815e-4c5a-ba96-caedde21cc98"],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox["\[Epsilon]", 
   SqrtBox["2"]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     FractionBox["1", 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]]}], ")"}], " ", 
   SuperscriptBox["\[Epsilon]", "2"]}], "+", 
  RowBox[{
   FractionBox["7", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["2"]}], ")"}], " ", 
   SuperscriptBox["\[Epsilon]", "3"]}], "+", 
  RowBox[{
   FractionBox["1", "16"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "55"}], "+", 
     RowBox[{"29", " ", 
      SqrtBox["2"]}]}], ")"}], " ", 
   SuperscriptBox["\[Epsilon]", "4"]}]}]], "Output",
 CellChangeTimes->{{3.707748523908746*^9, 3.707748637916882*^9}, {
   3.70774883053321*^9, 3.707748835919265*^9}, 3.708023256616065*^9, 
   3.708025663740004*^9, {3.708030386880765*^9, 3.7080304030380583`*^9}, 
   3.708122901148939*^9, 3.70825162073287*^9, 3.708269328825782*^9, 
   3.7082791504815063`*^9, 3.708286225689332*^9, 3.7083028802395782`*^9, 
   3.708360529256022*^9, 3.708366103237978*^9, {3.709000181077099*^9, 
   3.709000184689191*^9}, 3.7090002398527203`*^9, {3.709000534975322*^9, 
   3.709000556925084*^9}, 3.719209384461504*^9, 3.793845113489689*^9, 
   3.823229651455638*^9},
 CellLabel->
  "Out[3363]=",ExpressionUUID->"1d43e87d-6c39-4f8b-9891-465e7a06302b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"js1", "=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["1", 
        RowBox[{"2", " ", 
         SqrtBox["2"]}]]}], ")"}], " ", 
     SuperscriptBox["\[Epsilon]", "2"]}], "+", 
    RowBox[{
     FractionBox["1", "16"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "55"}], "+", 
       RowBox[{"29", " ", 
        SqrtBox["2"]}]}], ")"}], " ", 
     SuperscriptBox["\[Epsilon]", "4"]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.707344071547361*^9, 3.707344089295265*^9}, {
  3.707344319631371*^9, 3.7073443400792522`*^9}, {3.707344462971377*^9, 
  3.707344465306673*^9}, {3.7073448320949383`*^9, 3.707344834156107*^9}, {
  3.707512685982238*^9, 3.70751270281814*^9}, {3.707748896923613*^9, 
  3.707748900177417*^9}, {3.708030414372753*^9, 3.7080304241609364`*^9}, {
  3.7090005448880253`*^9, 3.709000575499566*^9}},
 CellLabel->
  "In[3364]:=",ExpressionUUID->"4d25ae6e-c3d0-4996-879c-6312995e1ed3"],

Cell[TextData[StyleBox["check by numerical evaluation of j with lognormal a",
 FontSize->16]], "Text",
 CellChangeTimes->{{3.707347555181609*^9, 3.707347582594514*^9}, {
   3.707442063493147*^9, 3.707442072299552*^9}, {3.7075124401671667`*^9, 
   3.707512443443941*^9}, {3.7082724302034197`*^9, 3.708272434754117*^9}, 
   3.708279078542573*^9},
 Background->GrayLevel[
  0.85],ExpressionUUID->"3775443e-6a57-44d1-8f6e-c005e452eb78"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Mu]", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"-", "1"}], "2"], 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[Epsilon]", "2"]}], "]"}]}]}], ";", 
  RowBox[{"\[Sigma]", "=", 
   SqrtBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[Epsilon]", "2"]}], "]"}]]}], ";", 
  RowBox[{
   RowBox[{"Jexp", "[", 
    RowBox[{"e_", ",", "KKd_", ",", "KKp_"}], "]"}], " ", ":=", 
   RowBox[{"NExpectation", "[", 
    RowBox[{
     RowBox[{"J", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Kd", "\[Rule]", "KKd"}], ",", 
        RowBox[{"Kp", "\[Rule]", "KKp"}]}], "}"}]}], ",", 
     RowBox[{"\[Omega]", "\[Distributed]", 
      RowBox[{"LogNormalDistribution", "[", 
       RowBox[{
        RowBox[{"\[Mu]", "/.", 
         RowBox[{"\[Epsilon]", "\[Rule]", "e"}]}], ",", 
        RowBox[{"\[Sigma]", "/.", 
         RowBox[{"\[Epsilon]", "\[Rule]", "e"}]}]}], "]"}]}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.708272464875404*^9, 3.708272494956209*^9}, 
   3.708272606032447*^9, {3.708272935396118*^9, 3.7082729539371243`*^9}, {
   3.708279046765492*^9, 3.7082790562519407`*^9}, {3.7082793039256477`*^9, 
   3.708279332663868*^9}, {3.709000604809126*^9, 3.709000636929126*^9}, {
   3.709000694976577*^9, 3.709000697781658*^9}, {3.719209406760601*^9, 
   3.719209411542543*^9}},
 CellLabel->
  "In[3365]:=",ExpressionUUID->"39f013da-8857-4849-9ace-383750bf42ae"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"de", "=", "0.04"}], ";"}], "      ", 
  RowBox[{"(*", " ", 
   RowBox[{"increment", " ", "for", " ", "computing", " ", "data"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"JKmin", "[", "\[Epsilon]_", "]"}], ":=", 
   RowBox[{"FindMinimum", "[", 
    RowBox[{
     RowBox[{"Jexp", "[", 
      RowBox[{"\[Epsilon]", ",", "Kd", ",", "Kp"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Kd", ",", "Kd0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Kp", ",", "Kp0"}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"JKstar", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Epsilon]", ",", 
        RowBox[{"JKmin", "[", "\[Epsilon]", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Epsilon]", ",", "0.01", ",", "1", ",", "de"}], "}"}]}], 
     "]"}], "//", "Flatten"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]star", "=", 
   RowBox[{"JKstar", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", ";;", "4"}], "]"}], "]"}]}], ";", 
  RowBox[{"Jstar", "=", 
   RowBox[{"JKstar", "[", 
    RowBox[{"[", 
     RowBox[{"2", ";;", ";;", "4"}], "]"}], "]"}]}], ";", " ", 
  RowBox[{"Kstar", "=", 
   RowBox[{
    RowBox[{"JKstar", "[", 
     RowBox[{"[", 
      RowBox[{"3", ";;", ";;", "4"}], "]"}], "]"}], " ", "/.", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"_", "\[Rule]", "e_"}], ")"}], "\[Rule]", "e"}]}]}], ";", " ", 
  RowBox[{"Kpstar", "=", 
   RowBox[{
    RowBox[{"JKstar", "[", 
     RowBox[{"[", 
      RowBox[{"4", ";;", ";;", "4"}], "]"}], "]"}], " ", "/.", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"_", "\[Rule]", "e_"}], ")"}], "\[Rule]", "e"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Jnaive", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Jexp", "[", 
      RowBox[{"\[Epsilon]", ",", "Kd0", ",", "Kp0"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Epsilon]", ",", "0.01", ",", "1", ",", "de"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Jpert", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Jexp", "[", 
       RowBox[{"\[Epsilon]", ",", "Kd1", ",", "Kp1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Epsilon]", ",", "0.01", ",", "1", ",", "de"}], "}"}]}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Jlist", "=", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"\[Alpha]star", ",", "Jstar"}], "}"}], "]"}]}], ";", " ", 
   RowBox[{"Klist", "=", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"\[Alpha]star", ",", "Kstar"}], "}"}], "]"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Kplist", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]star", ",", "Kpstar"}], "}"}], "]"}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.7082863414960546`*^9, 3.7082863748558702`*^9}, {
   3.708289384919161*^9, 3.708289391759679*^9}, {3.7082895248727007`*^9, 
   3.708289525018817*^9}, {3.7083657924386187`*^9, 3.7083658462382097`*^9}, {
   3.708365924059993*^9, 3.708365962851864*^9}, {3.708366016692997*^9, 
   3.7083660467733517`*^9}, {3.70836658050408*^9, 3.708366581988514*^9}, {
   3.708367479240264*^9, 3.7083674947025023`*^9}, {3.708368038524269*^9, 
   3.70836811513328*^9}, 3.7083684094468317`*^9, {3.709000656255762*^9, 
   3.7090007554334517`*^9}, {3.719209447489916*^9, 3.719209463264716*^9}},
 CellLabel->
  "In[3366]:=",ExpressionUUID->"975b1aa4-6161-4fe3-81c9-a87065f9b7a4"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "izero", 
   "\"Integral and error estimates are 0 on all integration subregions. Try \
increasing the value of the MinRecursion option. If value of integral may be \
0, specify a finite value for the AccuracyGoal option.\"", 2, 3368, 278, 
   24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.709000803049465*^9, 3.7090008394747*^9, {3.719209422230411*^9, 
   3.719209445794187*^9}, 3.719209477006505*^9, 3.7938451135560217`*^9, 
   3.8232296516144*^9},
 CellLabel->
  "During evaluation of \
In[3366]:=",ExpressionUUID->"793a6246-e5c7-4d41-99af-90e087805888"],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "fmgz", 
   "\"Encountered a gradient that is effectively zero. The result returned \
may not be a minimum; it may be a maximum or a saddle point.\"", 2, 3368, 279,
    24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.709000803049465*^9, 3.7090008394747*^9, {3.719209422230411*^9, 
   3.719209445794187*^9}, 3.719209477006505*^9, 3.7938451135560217`*^9, 
   3.8232296516221046`*^9},
 CellLabel->
  "During evaluation of \
In[3366]:=",ExpressionUUID->"d960858e-1735-435a-b7cd-888af26edc71"],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 3368, 280, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.709000803049465*^9, 3.7090008394747*^9, {3.719209422230411*^9, 
   3.719209445794187*^9}, 3.719209477006505*^9, 3.7938451135560217`*^9, 
   3.8232296552794857`*^9},
 CellLabel->
  "During evaluation of \
In[3366]:=",ExpressionUUID->"a54ba412-e67b-470e-889a-0a144f9ea672"],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 3368, 281, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.709000803049465*^9, 3.7090008394747*^9, {3.719209422230411*^9, 
   3.719209445794187*^9}, 3.719209477006505*^9, 3.7938451135560217`*^9, 
   3.823229658221422*^9},
 CellLabel->
  "During evaluation of \
In[3366]:=",ExpressionUUID->"fb3eb430-61c5-4968-9b24-ade9fdeda753"],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 3368, 282, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.709000803049465*^9, 3.7090008394747*^9, {3.719209422230411*^9, 
   3.719209445794187*^9}, 3.719209477006505*^9, 3.7938451135560217`*^9, 
   3.8232296594201593`*^9},
 CellLabel->
  "During evaluation of \
In[3366]:=",ExpressionUUID->"6d68e288-a8c8-46a8-a42e-dd104302b722"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"FindMinimum\\\", \\\"::\
\\\", \\\"lstol\\\"}], \\\"MessageName\\\"]\\) will be suppressed during this \
calculation.\"", 2, 3368, 283, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.709000803049465*^9, 3.7090008394747*^9, {3.719209422230411*^9, 
   3.719209445794187*^9}, 3.719209477006505*^9, 3.7938451135560217`*^9, 
   3.8232296594237137`*^9},
 CellLabel->
  "During evaluation of \
In[3366]:=",ExpressionUUID->"36c8be6a-0103-4dea-b0bd-46acf5334d36"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "izero", 
   "\"Integral and error estimates are 0 on all integration subregions. Try \
increasing the value of the MinRecursion option. If value of integral may be \
0, specify a finite value for the AccuracyGoal option.\"", 2, 3371, 284, 
   24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.709000803049465*^9, 3.7090008394747*^9, {3.719209422230411*^9, 
   3.719209445794187*^9}, 3.719209477006505*^9, 3.7938451135560217`*^9, 
   3.823229676692808*^9},
 CellLabel->
  "During evaluation of \
In[3366]:=",ExpressionUUID->"41d82282-e574-4397-85f2-a8e8dd2b8482"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Kd1", "=", 
   RowBox[{"Kd0", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"dkvec", "[", 
        RowBox[{"[", "1", "]"}], "]"}], 
       SuperscriptBox["\[Epsilon]", "2"]}]}], ")"}]}]}], ";", 
  RowBox[{"Kp1", "=", 
   RowBox[{"Kp0", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"dkvec", "[", 
        RowBox[{"[", "2", "]"}], "]"}], 
       SuperscriptBox["\[Epsilon]", "2"]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p0", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Jexp", "[", 
        RowBox[{"\[Epsilon]", ",", "Kd0", ",", "Kp0"}], "]"}], ",", 
       RowBox[{"Jexp", "[", 
        RowBox[{"\[Epsilon]", ",", "Kd1", ",", "Kp1"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Epsilon]", ",", "0.01", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.708280377237122*^9, 3.708280510073094*^9}, {
  3.7082807051281347`*^9, 3.70828071111565*^9}, {3.708283028977076*^9, 
  3.7082830451787777`*^9}, {3.7090007661433*^9, 3.709000790878756*^9}, {
  3.709000888212268*^9, 3.709000894425399*^9}, {3.719209483063239*^9, 
  3.7192094901507063`*^9}},
 CellLabel->
  "In[3374]:=",ExpressionUUID->"dd5a5c30-a3e0-49b4-a6ec-ffb93cc1e969"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"ListPlot", "[", "Klist", "]"}], ",", 
       RowBox[{"Plot", "[", 
        RowBox[{"Kd1", ",", 
         RowBox[{"{", 
          RowBox[{"\[Epsilon]", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "]"}],
      ",", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"ListPlot", "[", "Kplist", "]"}], ",", 
       RowBox[{"Plot", "[", 
        RowBox[{"Kp1", ",", 
         RowBox[{"{", 
          RowBox[{"\[Epsilon]", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "]"}],
      ",", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"ListPlot", "[", "Jlist", "]"}], ",", "p0"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"650", ",", "150"}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.708280551174739*^9, 3.7082805917097588`*^9}, {
   3.708280658924842*^9, 3.708280678323721*^9}, {3.708289500585091*^9, 
   3.7082895160414953`*^9}, {3.709000794655707*^9, 3.709000796554019*^9}, 
   3.7192094938305264`*^9},
 CellLabel->
  "In[3376]:=",ExpressionUUID->"a4e529ad-e61d-4e66-9859-771017df1622"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {{}, {}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
          0.012833333333333334`], AbsoluteThickness[1.6], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGAwBGIQXS2yzv1hVYu95olvFoYKb+1nzQSBlRj8goY4Dg2d
t/Zc1xcX2HJtx+Trrpof4fbWfgmQd33xAUz+sw2vH+a+tT/8VSOm/9BRDH4i
j+zdGwve2j+qAjnoFAafVfCDGfPdt/YMYHABg7/CbK2ahMI7+wmHQAZewuAz
3VvV9CX9nb186+vAHXJXMfgT1qx237PpnT0oNETWXcfgr3BZc/X5v3f2dmAP
38Lg30r7xOni/d7+7BkQuIPBz5//Z82Lae/tgZ4FOug+Bj/1yOZ5Og/f238D
BcfXBxj85wW/554R+QC17xEG39FHafF78w/2YO+0Psbgr8jii3gW+QHqnicY
/KfGqf6Lqz7Yi4I9/AyD76zZc19h1geoe59j8MuDsxfF7/gAje8XGPzLH9nt
Uq5+sH8Dcs7rlxj83KlHEs0+frA3BoPXGPwr+e577nN/tIek1zcY/D8rD9ll
q36Epqe3GHzWyFuzn9h+hKbX9xh8+SMN98JDP9oDAJG2loE=
           
           "]]}}, {{}, {}}}, {{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
           1.], LineBox[CompressedData["
1:eJwV1Gk4llkYB3DSlElZm2kYkiypkH0r/bOUBjGWZMsylqKmKClKIpoKaTGv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            "]]},
          Annotation[#, "Charting`Private`Tag$1769756#1"]& ]}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0.9005599416492155},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{15.13265306122449, 1.4999999999999432`}, {
       12.692681486569597`, 4.828624548655782}},
      Method->{
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 0.97}, {0.9005599416492155, 1.083335751678767}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {111.6014484337373, -71.20987709668091},
      ImageScaled[{0.5, 0.5}], {207.74925384919328, 135.63786113653507}], 
    InsetBox[
     GraphicsBox[{{{}, {{}, {}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
          0.012833333333333334`], AbsoluteThickness[1.6], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGAwBGIQXS2yzv1hVYu9yfs/MyubbtnPmgkCKzH4zycmPHm+
85Y91/XFBbZc2zH496XfRHw0um2/BMi7vvgABn9mw5nWdS9u2x/+qhHTf+go
Br/h+onTpy7csX9UBXLQKQw+75Krwuz379ozgMEFDL6u6LfNJ9nu2084BDLw
EgZfQdRY0knugb186+vAHXJXMfhh210LfXY/sAeFhsi66xh857bDt66GPbS3
A3v4FgZfaHnRPcd3D+3PngGBOxh8fffQppv1j+yBngU66D4G37rz7+npXI/t
v4GC4+sDDL6Vh2nez97HUPseYfB1/t8Rv8b5xB7sndbHGPxnb7ZNcap7AnXP
Ewz+veNXnlW9fmIvCvbwMwz+87Vb31wKfAp173MMftHB+NLVG59C4/sFBp+n
cmp2Nvcz+zcg57x+icGvE4qdXxX/zN4YDF5j8OUYth2xW/fMHpJe32Dwpduj
6yV/PIOmp7cY/MXx73LSbZ9D0+t7DP6Mjwz+9XXP7QHVpJnP
           
           "]]}}, {{}, {}}}, {{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
           1.], LineBox[CompressedData["
1:eJwV03k4lYkXB3DbRESIaYhUthIyyjImvk0qkmosKWOJElmylqKJyLULQ5SE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            "]]},
          Annotation[#, "Charting`Private`Tag$1769847#1"]& ]}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0.3964370066799382},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{15.13265306122449, 1.4999999999999432`}, {
       12.692681486569597`, 4.828624548655782}},
      Method->{
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 0.97}, {0.3964370066799382, 0.7341915648499251}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {334.8043453012119, -71.20987709668091},
      ImageScaled[{0.5, 0.5}], {207.74925384919328, 135.63786113653507}], 
    InsetBox[
     GraphicsBox[{{{}, {{}, {}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
          0.012833333333333334`], AbsoluteThickness[1.6], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGAwBGIQXS2yzv1hVYs9AxTMmgkCKzH4GQmxrBo6d+25ri8u
sOXajsH3qutZFuF2134JkHd98QEMft0DnzcPc+/aH/6qEdN/6CgGXyHq550b
C+7aP6oCOegUBv+ciJMt8927UHddwOCb/JyiKqFwz37CIZCBlzD4VzbtbvuS
fs9evvV14A65qxj8ss1+dns23bMHhYbIuusY/Fz5u7ef/7tnbwf28C0M/oco
e04X7/v2Z8+AwB0MvnV6/OoX0+7bAz0LdNB9DL7EbIslOg/v238DBcfXBxj8
QP+MZWdEHkDte4TB39DGOfu9+QN7sHdaH2PwA4+tT3gW+QDqnicY/Motk70X
Vz2wFwV7+BkG30zK+rHCrAdQ9z7H4P/5uG5h/I4H0Ph+gcE/P9XfLuXqA/s3
IOe8fonBv8+9McXs4wN7YzB4jcFPF63Zf5/7oT0kvb7B4AdfKXPIVn0ITU9v
Mfjz97+f9cT2ITS9vsfgp4Vuuh8e+tAeACILilI=
           
           "]]}}, {{}, {}}}, {{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
           1.], LineBox[CompressedData["
1:eJwV0nk4lfsWB/B9k85tpMglZZ6VyhBKviJOJHVSmhyVUirtrXIUSZHZQTrk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            "]]},
          Annotation[#, "Charting`Private`Tag$1753017#1"]& ], 
         TagBox[
          {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
           1.], LineBox[CompressedData["
1:eJwV0Xk0lQsXBvBThsr1URkSmTWo7iEdU5fzlCIhfQ1EgyJKyVB0uuJSMoQy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            "]]},
          Annotation[#, "Charting`Private`Tag$1753017#2"]& ]}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{10.03061224489796, 1.5}, {12.692681486569597`, 
       4.828624548655782}},
      Method->{
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 0.97}, {0, 0.5416678780626796}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {555.4562217605232, -71.20987709668091},
      ImageScaled[{0.5, 0.5}], {202.6472130328668, 135.63786113653507}]}, {}},
  
  AspectRatio->Full,
  ImageSize->{650, 150},
  PlotRange->{{0, 664.5066497860973}, {-142.41975419336183`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.708280597315613*^9, {3.70828066362142*^9, 3.708280679084889*^9}, 
   3.708283057073812*^9, 3.708289517566065*^9, 3.7082896021985197`*^9, 
   3.7083029140493793`*^9, 3.708360563542729*^9, 3.708366142642837*^9, 
   3.708366599068878*^9, 3.708367542486845*^9, 3.7083682079340687`*^9, 
   3.708368458986082*^9, 3.709000983400535*^9, 3.7192095142079477`*^9, 
   3.719209568268094*^9, 3.7938451404192753`*^9, 3.823229683473607*^9},
 CellLabel->
  "Out[3376]=",ExpressionUUID->"d95d6f84-8d18-4e22-8643-3ee37d1fdf31"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.793845092338594*^9, 3.793845095329863*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"109040cf-8159-4545-8ebc-47c5c4faaa12"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
       "\[Alpha]star", ",", "Jstar", ",", "Jnaive", ",", "Jpert", ",", 
        "Kstar", ",", "Kpstar"}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Export", "[", 
      RowBox[{"\"\<oscKshiftPD.dat\>\"", ",", "dat"}], "]"}], ";"}], " ", 
    "\[IndentingNewLine]", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.708360643954328*^9, 3.7083606801122923`*^9}, {
  3.708360795993246*^9, 3.708360820929138*^9}, {3.708361160496216*^9, 
  3.708361162838238*^9}, {3.708362786238716*^9, 3.70836279172651*^9}, {
  3.708363020732679*^9, 3.708363032786327*^9}, {3.70836316247377*^9, 
  3.708363167903455*^9}, {3.7083633972500896`*^9, 3.708363430053249*^9}, {
  3.708363476158848*^9, 3.70836347821843*^9}, {3.708365978115561*^9, 
  3.708365991226235*^9}, {3.708366608958349*^9, 3.708366625549254*^9}, {
  3.7090000890129023`*^9, 3.709000091595455*^9}, {3.793845078075495*^9, 
  3.793845089787294*^9}},
 CellLabel->
  "In[3377]:=",ExpressionUUID->"c19a5ec2-7127-4d72-bc3f-013f386cf399"]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 104}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"03941283-8fd7-4d8d-9e5b-fa7fb4b47403"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 596, 11, 105, "Section",ExpressionUUID->"1ad7a69b-0b66-40ee-bfd9-1fd1e5091f36"],
Cell[1179, 35, 175, 4, 30, "Input",ExpressionUUID->"f25dd9e2-712c-49ce-a33e-9aa7a9ce26c5"],
Cell[CellGroupData[{
Cell[1379, 43, 2163, 62, 121, "Input",ExpressionUUID->"d800d717-3dcd-455f-b846-c3f04f14e4a7"],
Cell[3545, 107, 2464, 75, 150, "Output",ExpressionUUID->"5246ef0a-6470-4b22-ad22-3bd477135005"]
}, Open  ]],
Cell[6024, 185, 865, 16, 120, "Text",ExpressionUUID->"356da822-c1c7-4220-8523-3550a19b11f4"],
Cell[CellGroupData[{
Cell[6914, 205, 1525, 36, 96, "Input",ExpressionUUID->"d82c6715-e511-44fa-91a0-b1dc0dd6078d"],
Cell[8442, 243, 1171, 24, 65, "Output",ExpressionUUID->"92f5dda6-ff3c-45ca-b02f-d6fc6d679240"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9650, 272, 899, 18, 30, "Input",ExpressionUUID->"538cce0c-b70f-4cbf-acfa-281eb7868ba8"],
Cell[10552, 292, 157288, 2653, 376, "Output",ExpressionUUID->"6b2f641a-ebd4-4cee-98a7-40b146de4bdf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167877, 2950, 1464, 43, 56, "Input",ExpressionUUID->"557e3b8b-c46d-4587-a58f-d72eea16ce1f"],
Cell[169344, 2995, 964, 26, 43, "Output",ExpressionUUID->"2b83d9fd-fc3c-4bc9-a86d-b60f68d8c1f1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[170345, 3026, 579, 14, 30, "Input",ExpressionUUID->"48c040dc-51fa-4fc5-9e01-2ba36a0a0ea8"],
Cell[170927, 3042, 579, 13, 58, "Output",ExpressionUUID->"73cc36fc-c173-4475-9144-ed1baf88ac2a"]
}, Open  ]],
Cell[171521, 3058, 345, 5, 51, "Text",ExpressionUUID->"2b4b147c-a035-43d7-a6d6-b084a39cb59a"],
Cell[CellGroupData[{
Cell[171891, 3067, 1195, 31, 71, "Input",ExpressionUUID->"823775c2-2a77-4b23-8fe1-4360b731f93b"],
Cell[173089, 3100, 1550, 42, 68, "Output",ExpressionUUID->"d7ccbcc5-d6d4-4824-a86a-206843df8e54"]
}, Open  ]],
Cell[CellGroupData[{
Cell[174676, 3147, 279, 6, 30, "Input",ExpressionUUID->"046f5b3b-bb01-431c-957c-8b06d34c4f2c"],
Cell[174958, 3155, 759, 24, 64, "Output",ExpressionUUID->"ebbbec74-3b95-427d-a81b-b9fab0e66bd2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[175754, 3184, 1367, 41, 75, "Input",ExpressionUUID->"6215ce0f-8999-416b-a742-a993324fb603"],
Cell[177124, 3227, 1714, 53, 69, "Output",ExpressionUUID->"2cac1ba2-4023-41aa-b7a9-8156ddb58a49"]
}, Open  ]],
Cell[CellGroupData[{
Cell[178875, 3285, 471, 15, 47, "Input",ExpressionUUID->"c305ec7e-da8a-4e9e-ab14-9086c3e8138f"],
Cell[179349, 3302, 1101, 33, 69, "Output",ExpressionUUID->"43492125-0a4d-452a-a238-3c881dd3b4db"]
}, Open  ]],
Cell[180465, 3338, 333, 5, 51, "Text",ExpressionUUID->"0fc6b40e-54fc-4440-83a4-88ec69b8d19c"],
Cell[CellGroupData[{
Cell[180823, 3347, 1606, 36, 54, "Input",ExpressionUUID->"a505b94f-815e-4c5a-ba96-caedde21cc98"],
Cell[182432, 3385, 1355, 36, 55, "Output",ExpressionUUID->"1d43e87d-6c39-4f8b-9891-465e7a06302b"]
}, Open  ]],
Cell[183802, 3424, 1005, 26, 55, "Input",ExpressionUUID->"4d25ae6e-c3d0-4996-879c-6312995e1ed3"],
Cell[184810, 3452, 432, 7, 52, "Text",ExpressionUUID->"3775443e-6a57-44d1-8f6e-c005e452eb78"],
Cell[185245, 3461, 1474, 39, 121, "Input",ExpressionUUID->"39f013da-8857-4849-9ace-383750bf42ae"],
Cell[CellGroupData[{
Cell[186744, 3504, 3688, 103, 241, "Input",ExpressionUUID->"975b1aa4-6161-4fe3-81c9-a87065f9b7a4"],
Cell[190435, 3609, 653, 14, 39, "Message",ExpressionUUID->"793a6246-e5c7-4d41-99af-90e087805888"],
Cell[191091, 3625, 583, 13, 39, "Message",ExpressionUUID->"d960858e-1735-435a-b7cd-888af26edc71"],
Cell[191677, 3640, 750, 15, 56, "Message",ExpressionUUID->"a54ba412-e67b-470e-889a-0a144f9ea672"],
Cell[192430, 3657, 748, 15, 56, "Message",ExpressionUUID->"fb3eb430-61c5-4968-9b24-ade9fdeda753"],
Cell[193181, 3674, 750, 15, 56, "Message",ExpressionUUID->"6d68e288-a8c8-46a8-a42e-dd104302b722"],
Cell[193934, 3691, 609, 13, 24, "Message",ExpressionUUID->"36c8be6a-0103-4dea-b0bd-46acf5334d36"],
Cell[194546, 3706, 655, 14, 39, "Message",ExpressionUUID->"41d82282-e574-4397-85f2-a8e8dd2b8482"]
}, Open  ]],
Cell[195216, 3723, 1333, 38, 54, "Input",ExpressionUUID->"dd5a5c30-a3e0-49b4-a6ec-ffb93cc1e969"],
Cell[CellGroupData[{
Cell[196574, 3765, 1247, 34, 73, "Input",ExpressionUUID->"a4e529ad-e61d-4e66-9859-771017df1622"],
Cell[197824, 3801, 19748, 377, 167, "Output",ExpressionUUID->"d95d6f84-8d18-4e22-8643-3ee37d1fdf31"]
}, Open  ]],
Cell[217587, 4181, 181, 3, 51, "Text",ExpressionUUID->"109040cf-8159-4545-8ebc-47c5c4faaa12"],
Cell[217771, 4186, 1361, 29, 157, "Input",ExpressionUUID->"c19a5ec2-7127-4d72-bc3f-013f386cf399"]
}, Open  ]]
}
]
*)

