(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    414895,       7714]
NotebookOptionsPosition[    407702,       7615]
NotebookOutlinePosition[    408095,       7631]
CellTagsIndexPosition[    408052,       7628]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Pendulum swing up, robust to \[Omega] perturbations  (Problem 9.2 and Section \
9.1.2)\
\>", "Section",
 CellChangeTimes->{{3.698811497715045*^9, 3.698811509022469*^9}, {
  3.69885144307857*^9, 3.698851462312389*^9}, {3.709636905485622*^9, 
  3.709636910921179*^9}, {3.715342867107555*^9, 3.715342872342836*^9}, {
  3.7153432690028687`*^9, 3.715343287448956*^9}, {3.716532618830523*^9, 
  3.7165326217793283`*^9}, {3.716570684194786*^9, 3.716570736464383*^9}, {
  3.716613642404841*^9, 3.716613649251136*^9}, {3.7166173099843607`*^9, 
  3.716617315405965*^9}, {3.7167170388199997`*^9, 3.7167170401560717`*^9}, {
  3.716725771532446*^9, 3.716725778338876*^9}, {3.720265971235908*^9, 
  3.720265985561623*^9}, {3.793845847510063*^9, 3.793845855140319*^9}, {
  3.7938458995921993`*^9, 
  3.793845902198265*^9}},ExpressionUUID->"c2f1811f-5d39-4870-bd7a-\
071084aa3a3d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]nom", "=", "1"}], ";", 
  RowBox[{"n", "=", "500"}], ";", "  ", 
  RowBox[{"\[Tau]", "=", "5"}], ";", 
  RowBox[{"\[Tau]1", "=", "8"}], ";"}]}], "Input",
 CellChangeTimes->{{3.720272435157402*^9, 3.720272452314745*^9}, {
   3.7202724990549*^9, 3.720272500924903*^9}, {3.7202728790190287`*^9, 
   3.720272879619027*^9}, {3.720272929089497*^9, 3.720272929400971*^9}, 
   3.7202733391951647`*^9, {3.720276517439974*^9, 3.720276533329103*^9}, 
   3.720276577834138*^9},
 CellLabel->
  "In[769]:=",ExpressionUUID->"6dd0b628-064e-4934-9f4c-d8f363683be6"],

Cell["\<\
Design feedforward for nominal \[Omega] = 1  (slightly modified from version \
in Opt. Cont. chapter)
  -- notation changed to use x1=\[Theta], x2= \[Theta]dot, \[Lambda]1=\
\[Lambda]dot, \[Lambda]2=\[Lambda]\
\>", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.720266038518532*^9, 3.720266049580326*^9}, {
  3.720266302702504*^9, 3.720266305742021*^9}, {3.72026683611945*^9, 
  3.72026685656385*^9}, {3.720267194778137*^9, 3.7202672361341248`*^9}, {
  3.7202680712161703`*^9, 3.720268077917232*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"a2954139-f871-4e4f-8a02-8f07608ba4e8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ffNom", "[", 
    RowBox[{"n_", ",", "\[Tau]_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "f", ",", "x1", ",", "x2", ",", "\[Lambda]2", ",", "\[Lambda]1", ",", 
       "t", ",", "\[CapitalDelta]t", ",", "bcs", ",", "eqns", ",", "sv", ",", 
       "froot", ",", "x1ff0", ",", "x2ff0", ",", "uff0", ",", "x1ff", ",", 
       "x2ff", ",", "uff"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalDelta]t", "=", 
       FractionBox["\[Tau]", "n"]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"{", 
         RowBox[{"x1_", ",", "x2_", ",", "\[Lambda]1_", ",", "\[Lambda]2_"}], 
         "}"}], "]"}], " ", ":=", " ", 
       RowBox[{"{", 
        RowBox[{"x2", ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sin", "[", "x1", "]"}]}], "-", "\[Lambda]2"}], ",", 
         RowBox[{
          RowBox[{"Cos", "[", "x1", "]"}], "\[Lambda]2"}], ",", 
         RowBox[{"-", "\[Lambda]1"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"bcs", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["x1", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x2", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x1", "n"], "\[Equal]", "\[Pi]"}], ",", 
         RowBox[{
          SubscriptBox["x2", "n"], "\[Equal]", "0"}]}], "}"}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"hard", " ", "final", " ", "constraint"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"eqns", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"bcs", ",", "\[IndentingNewLine]", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Thread", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                SubscriptBox["x1", "i"], ",", 
                SubscriptBox["x2", "i"], ",", 
                SubscriptBox["\[Lambda]1", "i"], ",", 
                SubscriptBox["\[Lambda]2", "i"]}], "}"}], "\[Equal]", " ", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 SubscriptBox["x1", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["x2", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]1", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]2", 
                  RowBox[{"i", "-", "1"}]]}], "}"}], "\[IndentingNewLine]", 
               "+", 
               RowBox[{
                FractionBox["\[CapitalDelta]t", 
                 RowBox[{"2", " "}]], 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"f", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["x1", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["x2", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]1", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]2", 
                    RowBox[{"i", "-", "1"}]]}], "}"}], "]"}], "+", 
                  RowBox[{"f", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["x1", "i"], ",", 
                    SubscriptBox["x2", "i"], ",", 
                    SubscriptBox["\[Lambda]1", "i"], ",", 
                    SubscriptBox["\[Lambda]2", "i"]}], "}"}], "]"}]}], 
                 ")"}]}]}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sv", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["x1", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["x2", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]1", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]2", "i"], ",", "0"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "1"}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"initial", " ", "guesses"}], " ", "=", " ", "0"}], ",", " ", 
        
        RowBox[{"very", " ", 
         RowBox[{"naive", "!"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"froot", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{"eqns", ",", "sv"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"x1ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["x1", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"x2ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["x2", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"uff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"-", 
             SubscriptBox["\[Lambda]2", "i"]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"x1ff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x1ff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "\[Pi]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"x2ff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x2ff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"uff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"uff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"x1ff", ",", "x2ff", ",", "uff"}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]nom", ",", "\[Theta]dotnom", ",", "unom"}], "}"}], "=", 
   RowBox[{"ffNom", "[", 
    RowBox[{"n", ",", "\[Tau]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.716725835516573*^9, 3.716725835885325*^9}, {
   3.716726014532469*^9, 3.71672602766113*^9}, {3.716726231523755*^9, 
   3.7167262420957603`*^9}, {3.716726307201371*^9, 3.71672640862053*^9}, 
   3.716727073320963*^9, 3.7167365399686203`*^9, {3.720266053644985*^9, 
   3.7202660598010273`*^9}, {3.720266248173965*^9, 3.720266251491622*^9}, {
   3.7202672518902493`*^9, 3.720267491879376*^9}, {3.720267526081183*^9, 
   3.7202676089224567`*^9}, {3.72026773848741*^9, 3.720267859796011*^9}, {
   3.7202679163695602`*^9, 3.7202679886093082`*^9}, {3.72026803461469*^9, 
   3.720268060107025*^9}, {3.720272538079322*^9, 3.7202725394297743`*^9}, {
   3.720272658625621*^9, 3.720272730454205*^9}, {3.7202731099408627`*^9, 
   3.72027311017083*^9}, {3.7202765102201567`*^9, 3.720276514178471*^9}, {
   3.7203308972391167`*^9, 3.720330904547763*^9}},
 CellLabel->
  "In[771]:=",ExpressionUUID->"6e42687c-bd84-429b-9901-9da7fec5d545"],

Cell["\<\
Test the approximate solution on open-loop dynamics for different frequency \
\[Omega]\
\>", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.720266088381096*^9, 3.720266105260668*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"291c1013-9723-4bbf-bdf6-0ec48ff3a54f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SwingUp", "[", 
   RowBox[{"\[Tau]_", ",", "\[Tau]1_", ",", "uff_", ",", "\[Omega]_"}], "]"}],
   ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "eq", ",", "init", ",", "\[Theta]", ",", "\[Theta]dot", ",", "\[Theta]s",
       ",", "\[Theta]dots", ",", "us", ",", "t", ",", "J\[Tau]"}], "}"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eq", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"\[Theta]", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Theta]dot", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["\[Omega]", "2"]}], 
           RowBox[{"Sin", "[", 
            RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}], "+", 
          RowBox[{"uff", "[", "t", "]"}]}]}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"init", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Theta]", "[", "0", "]"}], "\[Equal]", 
        RowBox[{"\[Theta]dot", "[", "0", "]"}], "\[Equal]", "0"}], "}"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Theta]s", ",", "\[Theta]dots"}], "}"}], "=", 
      RowBox[{"NDSolveValue", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"eq", ",", "init"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", "\[Theta]dot"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"J\[Tau]", "=", 
      RowBox[{
       FractionBox["1", "2"], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Theta]s", "[", "\[Tau]", "]"}], "-", "\[Pi]"}], ")"}], 
          "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Theta]dots", "[", "\[Tau]", "]"}], "2"]}], ")"}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\[Theta]s", ",", "J\[Tau]"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.716726475850806*^9, 3.716726483729012*^9}, {
   3.716726540265172*^9, 3.71672655675944*^9}, {3.7167265922123337`*^9, 
   3.716726624099812*^9}, {3.716726827404985*^9, 3.71672683813792*^9}, 
   3.716727075758045*^9, {3.716736385196327*^9, 3.71673639877942*^9}, {
   3.720266108686565*^9, 3.720266198581168*^9}, 3.7202662574892273`*^9, 
   3.7202723959055233`*^9, 3.720272459838751*^9, 3.720272566413596*^9, 
   3.7202749811621323`*^9, {3.7202771279791603`*^9, 3.720277271210779*^9}, {
   3.720277441972392*^9, 3.7202774422340317`*^9}, {3.720277481850514*^9, 
   3.720277486216041*^9}, {3.720278026457005*^9, 3.720278038784877*^9}, {
   3.7202782015035553`*^9, 3.7202782111076727`*^9}, {3.720278675037801*^9, 
   3.72027870972211*^9}, {3.720278775273959*^9, 3.720278809896521*^9}, {
   3.7203323985294867`*^9, 3.720332420926206*^9}, {3.720332487550437*^9, 
   3.7203324954617863`*^9}, {3.720333244315941*^9, 3.720333328391945*^9}, {
   3.720333473729618*^9, 3.720333485638172*^9}, {3.720333775592161*^9, 
   3.7203337832371798`*^9}},
 CellLabel->
  "In[773]:=",ExpressionUUID->"03e0d4f6-e531-4b5f-ab2e-1a3e95fe7d1f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GetJ", "[", 
   RowBox[{"\[Tau]_", ",", "\[Tau]1_", ",", "u_", ",", "\[Omega]_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"SwingUp", "[", 
    RowBox[{"\[Tau]", ",", "\[Tau]1", ",", "u", ",", "\[Omega]"}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellLabel->
  "In[774]:=",ExpressionUUID->"060644a0-5fff-49ec-8387-7b60cc83f0d0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GetJu", "[", 
   RowBox[{"u_", ",", "\[Tau]_"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"u", "[", "t", "]"}], "2"], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7203337254761333`*^9, 3.720333763768368*^9}},
 CellLabel->
  "In[775]:=",ExpressionUUID->"223db326-2d76-44f6-b59e-0cc7f18ad22d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GetJuNom", "[", "\[Tau]_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Theta]nom", ",", "\[Theta]dotnom", ",", "unom", ",", "n"}], 
     "}"}], ",", 
    RowBox[{
     RowBox[{"n", "=", "500"}], ";", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Theta]nom", ",", "\[Theta]dotnom", ",", "unom"}], "}"}], 
      "=", 
      RowBox[{"ffNom", "[", 
       RowBox[{"n", ",", "\[Tau]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"unom", "[", "t", "]"}], "2"], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}]}], "]"}]}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.720334439558255*^9, 3.720334465933465*^9}, {
  3.7203345037096243`*^9, 3.720334558618387*^9}, {3.7203346112747183`*^9, 
  3.720334612841322*^9}, {3.720334680142332*^9, 3.7203346856119223`*^9}, {
  3.7203347234395237`*^9, 3.7203347236314898`*^9}},
 CellLabel->
  "In[776]:=",ExpressionUUID->"dffb34d4-838a-467a-a2a0-8d216c912383"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GetJuRob", "[", "\[Tau]_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Theta]rob", ",", "\[Theta]dotrob", ",", "urob", ",", "x\[Omega]1rob", 
      ",", "x\[Omega]2rob", ",", "n"}], "}"}], ",", 
    RowBox[{
     RowBox[{"n", "=", "500"}], ";", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\[Theta]rob", ",", "\[Theta]dotrob", ",", "urob", ",", 
        "x\[Omega]1rob", ",", "x\[Omega]2rob"}], "}"}], "=", 
      RowBox[{"ffRob", "[", 
       RowBox[{"n", ",", "\[Tau]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"urob", "[", "t", "]"}], "2"], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}]}], "]"}]}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.720335164823402*^9, 3.7203352144471703`*^9}},
 CellLabel->
  "In[777]:=",ExpressionUUID->"3b11d574-696d-4c33-a7b3-3ab445463959"],

Cell[TextData[{
 "Design ",
 StyleBox["robust",
  FontColor->RGBColor[1, 0, 0]],
 " feedforward for nominal \[Omega] = 1"
}], "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.720266088381096*^9, 3.720266105260668*^9}, {
  3.7202662876706133`*^9, 3.720266313301858*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"48036b2a-7a95-4b13-89ce-fac57bcb3597"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ffRob", "[", 
    RowBox[{"n_", ",", "\[Tau]_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "f", ",", "x1", ",", "x2", ",", "x\[Omega]1", ",", "x\[Omega]2", ",", 
       "\[Lambda]1", ",", "\[Lambda]2", ",", "\[Lambda]\[Omega]1", ",", 
       "\[Lambda]\[Omega]2", ",", "t", ",", "\[CapitalDelta]t", ",", "bcs", 
       ",", "eqns", ",", "sv", ",", "froot", ",", "x1ff0", ",", "x2ff0", ",", 
       "uff0", ",", "x\[Omega]1ff0", ",", "x\[Omega]2ff0", ",", "x1ff", ",", 
       "x2ff", ",", "uff"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalDelta]t", "=", 
       FractionBox["\[Tau]", "n"]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"{", 
         RowBox[{
         "x1_", ",", "x2_", ",", "x\[Omega]1_", ",", "x\[Omega]2_", ",", 
          "\[Lambda]1_", ",", "\[Lambda]2_", ",", "\[Lambda]\[Omega]1_", ",", 
          "\[Lambda]\[Omega]2_"}], "}"}], "]"}], " ", ":=", " ", 
       RowBox[{"{", 
        RowBox[{"x2", ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sin", "[", "x1", "]"}]}], "-", "\[Lambda]2"}], ",", 
         "x\[Omega]2", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], 
           RowBox[{"Sin", "[", "x1", "]"}]}], "-", 
          RowBox[{
           RowBox[{"Cos", "[", "x1", "]"}], "x\[Omega]1"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Cos", "[", "x1", "]"}], "\[Lambda]2"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", 
              RowBox[{"Cos", "[", "x1", "]"}]}], "-", 
             RowBox[{
              RowBox[{"Sin", "[", "x1", "]"}], "x\[Omega]1"}]}], ")"}], 
           "\[Lambda]\[Omega]2"}]}], ",", 
         RowBox[{"-", "\[Lambda]1"}], ",", 
         RowBox[{
          RowBox[{"Cos", "[", "x1", "]"}], "\[Lambda]\[Omega]2"}], ",", 
         RowBox[{"-", "\[Lambda]\[Omega]1"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "  ", 
       RowBox[{"GOT", " ", "THIS", " ", 
        RowBox[{"FAR", "!!"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"bcs", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["x1", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x2", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x\[Omega]1", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x\[Omega]2", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x1", "n"], "\[Equal]", "\[Pi]"}], ",", 
         RowBox[{
          SubscriptBox["x2", "n"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x\[Omega]1", "n"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["x\[Omega]2", "n"], "\[Equal]", "0"}]}], "}"}]}], ";", 
      " ", 
      RowBox[{"(*", " ", 
       RowBox[{"hard", " ", "final", " ", "constraint"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"eqns", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"bcs", ",", "\[IndentingNewLine]", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Thread", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                SubscriptBox["x1", "i"], ",", 
                SubscriptBox["x2", "i"], ",", 
                SubscriptBox["x\[Omega]1", "i"], ",", 
                SubscriptBox["x\[Omega]2", "i"], ",", 
                SubscriptBox["\[Lambda]1", "i"], ",", 
                SubscriptBox["\[Lambda]2", "i"], ",", 
                SubscriptBox["\[Lambda]\[Omega]1", "i"], ",", 
                SubscriptBox["\[Lambda]\[Omega]2", "i"]}], "}"}], "\[Equal]", 
              " ", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 SubscriptBox["x1", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["x2", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["x\[Omega]1", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["x\[Omega]2", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]1", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]2", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]\[Omega]1", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]\[Omega]2", 
                  RowBox[{"i", "-", "1"}]]}], "}"}], "\[IndentingNewLine]", 
               "+", 
               RowBox[{
                FractionBox["\[CapitalDelta]t", 
                 RowBox[{"2", " "}]], 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"f", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["x1", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["x2", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["x\[Omega]1", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["x\[Omega]2", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]1", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]2", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]\[Omega]1", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]\[Omega]2", 
                    RowBox[{"i", "-", "1"}]]}], "}"}], "]"}], "+", 
                  RowBox[{"f", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["x1", "i"], ",", 
                    SubscriptBox["x2", "i"], ",", 
                    SubscriptBox["x\[Omega]1", "i"], ",", 
                    SubscriptBox["x\[Omega]2", "i"], ",", 
                    SubscriptBox["\[Lambda]1", "i"], ",", 
                    SubscriptBox["\[Lambda]2", "i"], ",", 
                    SubscriptBox["\[Lambda]\[Omega]1", "i"], ",", 
                    SubscriptBox["\[Lambda]\[Omega]2", "i"]}], "}"}], "]"}]}],
                  ")"}]}]}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sv", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["x1", "i"], ",", 
               RowBox[{"0", "i", " ", "\[CapitalDelta]t"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["x2", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["x\[Omega]1", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["x\[Omega]2", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]1", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]2", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]\[Omega]1", "i"], ",", "0"}], "}"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]\[Omega]2", "i"], ",", "0"}], "}"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "1"}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"initial", " ", "guesses"}], " ", "=", " ", "0"}], ",", " ", 
        
        RowBox[{"very", " ", 
         RowBox[{"naive", "!"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"froot", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{"eqns", ",", "sv"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"x1ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["x1", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"x2ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["x2", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"uff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"-", 
             SubscriptBox["\[Lambda]2", "i"]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"x\[Omega]1ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["x\[Omega]1", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"x\[Omega]2ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["x\[Omega]2", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"x1ff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x1ff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "\[Pi]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"x2ff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x2ff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"uff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"uff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
       "x1ff", ",", "x2ff", ",", "uff", ",", "x\[Omega]1ff0", ",", 
        "x\[Omega]2ff0"}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\[Theta]rob", ",", "\[Theta]dotrob", ",", "urob", ",", "x\[Omega]1rob", 
     ",", "x\[Omega]2rob"}], "}"}], "=", 
   RowBox[{"ffRob", "[", 
    RowBox[{"n", ",", "\[Tau]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.720266283451872*^9, 3.720266284145136*^9}, {
   3.720266461722629*^9, 3.720266506241988*^9}, {3.720266570744213*^9, 
   3.720266576069737*^9}, {3.720266865517473*^9, 3.720266883215114*^9}, {
   3.720268015058704*^9, 3.720268017647579*^9}, {3.720268093726226*^9, 
   3.7202681176537333`*^9}, {3.720268959687498*^9, 3.720269059821245*^9}, {
   3.720269095529255*^9, 3.7202691277668343`*^9}, {3.720269244501638*^9, 
   3.7202693177631083`*^9}, {3.720269358123495*^9, 3.7202693638122*^9}, {
   3.7202709902066936`*^9, 3.720271122596094*^9}, {3.720271174864293*^9, 
   3.720271198100562*^9}, {3.72027124827626*^9, 3.7202712740547457`*^9}, 
   3.720271328485354*^9, 3.7202713597939577`*^9, {3.7202713951449003`*^9, 
   3.7202714745486794`*^9}, {3.7202717909450703`*^9, 3.720271862284606*^9}, {
   3.720271959105249*^9, 3.7202719681520576`*^9}, {3.720272062454547*^9, 
   3.7202720886616488`*^9}, 3.7202722184690943`*^9, {3.720272517775794*^9, 
   3.720272528663718*^9}, {3.720272763177741*^9, 3.720272807234152*^9}, {
   3.7202765238223143`*^9, 3.720276525084467*^9}, {3.7203309117916203`*^9, 
   3.7203309196761208`*^9}},
 CellLabel->
  "In[778]:=",ExpressionUUID->"ec6d3868-25d2-4cc8-92bb-c6edf124ec54"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p\[Omega]", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x\[Omega]1rob", "[", "t", "]"}], ",", 
      RowBox[{"x\[Omega]2rob", "[", "t", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.720272107551152*^9, 3.7202721409910507`*^9}, {
  3.720272225316671*^9, 3.7202722294933987`*^9}, {3.720272798257598*^9, 
  3.720272801129292*^9}, {3.7202734148122272`*^9, 3.720273419378525*^9}},
 CellLabel->
  "In[780]:=",ExpressionUUID->"c892da7e-3cbf-4a5c-b3b0-26ca0629edd5"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVl3k4lO8Xxi0zKsSYadO3UCqFFpKEeh4kQiqFEspOZGmRNRWSLUuSUCEk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       "]]},
     Annotation[#, "Charting`Private`Tag$651545#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVl3k4lN8bxpFkGdsM2kTKF1lCRITnECoJZUmSLNkjlBJKRSRrkkRCyZJk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       "]]},
     Annotation[#, "Charting`Private`Tag$651545#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.72027341554393*^9, 3.720273420107218*^9}, 
   3.720274689732903*^9, 3.72027501387684*^9, 3.7202751743685083`*^9, {
   3.720276203789646*^9, 3.72027622569466*^9}, 3.720276361304146*^9, {
   3.720276400682474*^9, 3.720276452737154*^9}, 3.720276484462422*^9, 
   3.720276538134604*^9, 3.720276582506448*^9, 3.720277000569147*^9, 
   3.720277358680681*^9, 3.720277450100746*^9, 3.720277492641358*^9, 
   3.720277842909823*^9, 3.720277934559641*^9, 3.7202780732025213`*^9, 
   3.720278128334938*^9, 3.720278217533556*^9, 3.7202784528634777`*^9, 
   3.720278749082973*^9, 3.7202787810007343`*^9, 3.720278816327222*^9, {
   3.720278848110276*^9, 3.720278938530472*^9}, 3.720278993551249*^9, 
   3.7203309323613586`*^9, 3.720331175890861*^9, 3.7203324606218863`*^9, 
   3.720332508754465*^9, 3.720332620929152*^9, 3.72033360463892*^9, 
   3.720333886354591*^9, 3.720334357326133*^9, 3.793845936003621*^9},
 CellLabel->
  "Out[780]=",ExpressionUUID->"d7b25705-e301-4194-aabf-a1ab28d833fd"]
}, Open  ]],

Cell["\<\
Evaluate nominal & robust feedforward controls u(t) for different frequencies \
\[Omega]\
\>", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}, {3.7202659495166073`*^9, 
  3.720265950298832*^9}, {3.7202747979755707`*^9, 3.720274806107464*^9}, {
  3.720274948616645*^9, 3.720274960711134*^9}, {3.720276330642107*^9, 
  3.720276350511654*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"ab2c3ba2-7995-4570-831f-4b8550a86355"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]1", ",", "J1"}], "}"}], "=", 
   RowBox[{"SwingUp", "[", 
    RowBox[{"\[Tau]", ",", "\[Tau]1", ",", "unom", ",", "\[Omega]nom"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]1a", ",", "J1a"}], "}"}], "=", 
   RowBox[{"SwingUp", "[", 
    RowBox[{"\[Tau]", ",", "\[Tau]1", ",", "unom", ",", 
     RowBox[{"\[Omega]nom", "-", "\[Epsilon]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]1b", ",", "J1b"}], "}"}], "=", 
   RowBox[{"SwingUp", "[", 
    RowBox[{"\[Tau]", ",", "\[Tau]1", ",", "unom", ",", 
     RowBox[{"\[Omega]nom", "+", "\[Epsilon]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Ju1", "=", 
    RowBox[{"GetJu", "[", 
     RowBox[{"unom", ",", "\[Tau]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]2", ",", "J2"}], "}"}], "=", 
   RowBox[{"SwingUp", "[", 
    RowBox[{"\[Tau]", ",", "\[Tau]1", ",", "urob", ",", "\[Omega]nom"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]2a", ",", "J2a"}], "}"}], "=", 
   RowBox[{"SwingUp", "[", 
    RowBox[{"\[Tau]", ",", "\[Tau]1", ",", "urob", ",", 
     RowBox[{"\[Omega]nom", "-", "\[Epsilon]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]2b", ",", "J2b"}], "}"}], "=", 
   RowBox[{"SwingUp", "[", 
    RowBox[{"\[Tau]", ",", "\[Tau]1", ",", "urob", ",", 
     RowBox[{"\[Omega]nom", "+", "\[Epsilon]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ju2", "=", 
   RowBox[{"GetJu", "[", 
    RowBox[{"urob", ",", "\[Tau]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.720274987197515*^9, 3.720275036600731*^9}, {
   3.720275178303823*^9, 3.7202751813976*^9}, {3.720275260341876*^9, 
   3.720275309875108*^9}, {3.72027536813484*^9, 3.720275404549261*^9}, {
   3.7202757204920053`*^9, 3.7202757215378447`*^9}, 3.720276200175948*^9, {
   3.720276304948122*^9, 3.720276310737747*^9}, {3.7202763742323523`*^9, 
   3.720276481064307*^9}, 3.720276995825726*^9, {3.72027728265005*^9, 
   3.720277351311008*^9}, {3.720331087685644*^9, 3.7203311171079617`*^9}, {
   3.720333521797768*^9, 3.720333546804351*^9}, {3.720333794324725*^9, 
   3.7203338514898853`*^9}},
 CellLabel->
  "In[781]:=",ExpressionUUID->"c9c99de9-620f-4db0-9aa5-3ae25257e88b"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.0598093190978135`\\\", \\\
\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 782, 49, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845936026239*^9},
 CellLabel->
  "During evaluation of \
In[781]:=",ExpressionUUID->"5434f872-934c-4435-b42a-1da8fd46b900"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.0598093190978135`\\\", \\\
\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 782, 50, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845936033965*^9},
 CellLabel->
  "During evaluation of \
In[781]:=",ExpressionUUID->"54934346-07ac-4630-9ecb-f164dff8b511"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.013492686032104`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 783, 51, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7938459360385447`*^9},
 CellLabel->
  "During evaluation of \
In[781]:=",ExpressionUUID->"47dca7c7-7184-4c0f-a572-acbb9c048175"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.013492686032104`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 783, 52, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.79384593604309*^9},
 CellLabel->
  "During evaluation of \
In[781]:=",ExpressionUUID->"7acb19af-ba40-497d-8b44-19883ca3f0c7"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.064392952122605`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 784, 53, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845936048623*^9},
 CellLabel->
  "During evaluation of \
In[781]:=",ExpressionUUID->"681e6f1f-e801-4e96-98fa-10da6f6abd20"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.064392952122605`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 784, 54, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7938459360533447`*^9},
 CellLabel->
  "During evaluation of \
In[781]:=",ExpressionUUID->"8529bab0-7514-47f9-b3ae-456c0b1d47cc"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.050421479027688`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 784, 55, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7938459360576487`*^9},
 CellLabel->
  "During evaluation of \
In[781]:=",ExpressionUUID->"17c97913-9dc0-4ef5-8798-a90fd04ae49c"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 784, 56, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845936061851*^9},
 CellLabel->
  "During evaluation of \
In[781]:=",ExpressionUUID->"aea61c0f-6f51-4557-91a1-04f4771923ef"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.0380916062662395`\\\", \\\
\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 786, 57, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845936331759*^9},
 CellLabel->
  "During evaluation of \
In[781]:=",ExpressionUUID->"865664c3-8f00-42f1-b569-518a865f0fd2"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.0380916062662395`\\\", \\\
\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 786, 58, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845936336434*^9},
 CellLabel->
  "During evaluation of \
In[781]:=",ExpressionUUID->"b9393d6d-4094-4e4f-a176-abae0f30e417"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.022223301846071`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 787, 59, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845936340207*^9},
 CellLabel->
  "During evaluation of \
In[781]:=",ExpressionUUID->"f2d0bf87-9975-44bd-8fb1-f414ade2a807"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.022223301846071`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 787, 60, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7938459363439703`*^9},
 CellLabel->
  "During evaluation of \
In[781]:=",ExpressionUUID->"e9b1efd3-17e8-42a7-aced-23acf5bf8b36"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.043630129236597`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 788, 61, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845936347641*^9},
 CellLabel->
  "During evaluation of \
In[781]:=",ExpressionUUID->"617e20e4-f550-4cc2-858a-e53781c4b303"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.043630129236597`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 788, 62, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7938459363519*^9},
 CellLabel->
  "During evaluation of \
In[781]:=",ExpressionUUID->"98208251-14b3-42fb-a96e-fb1a3c761544"]
}, Open  ]],

Cell["Data for energy plots; E(\[Tau]) at end of protocol", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}, {3.7202659495166073`*^9, 
  3.720265950298832*^9}, {3.7202747979755707`*^9, 3.720274806107464*^9}, {
  3.720274948616645*^9, 3.720274960711134*^9}, {3.720276330642107*^9, 
  3.720276350511654*^9}, {3.7202770918605757`*^9, 3.720277100834415*^9}, {
  3.720278388170575*^9, 3.720278405889784*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"46b14497-02dc-4e0f-91b9-58f8b0e8b439"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"JdatNom", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"GetJ", "[", 
      RowBox[{"\[Tau]", ",", "\[Tau]1", ",", "unom", ",", "\[Omega]"}], "]"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"\[Omega]", ",", "0.5", ",", "1.5", ",", "0.01"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"JdatRob", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"GetJ", "[", 
      RowBox[{"\[Tau]", ",", "\[Tau]1", ",", "urob", ",", "\[Omega]"}], "]"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"\[Omega]", ",", "0.5", ",", "1.5", ",", "0.01"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"JdatNom", ",", "JdatRob"}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.5", ",", "1.5"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.720338662182324*^9, 3.720338758820654*^9}, {
  3.720338844325382*^9, 3.720338913208997*^9}},
 CellLabel->
  "In[790]:=",ExpressionUUID->"84a52d07-1bb4-4190-b539-9407c0710a8a"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.024655635781514`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 790, 63, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845936638665*^9},
 CellLabel->
  "During evaluation of \
In[790]:=",ExpressionUUID->"d62d635d-025a-49d4-a1c7-77d46b7063c2"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.024655635781514`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 790, 64, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845936646614*^9},
 CellLabel->
  "During evaluation of \
In[790]:=",ExpressionUUID->"e8d817cd-3b2b-4f68-9ffc-f6676d58f32e"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.010919328920978`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 790, 65, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845936651331*^9},
 CellLabel->
  "During evaluation of \
In[790]:=",ExpressionUUID->"ccd7d54d-7daf-4b39-80bc-28d2953d8b09"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 790, 66, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845936655064*^9},
 CellLabel->
  "During evaluation of \
In[790]:=",ExpressionUUID->"adadad60-e100-424a-9ea7-99db84df881a"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.051604620001535`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 791, 67, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7938459369803057`*^9},
 CellLabel->
  "During evaluation of \
In[790]:=",ExpressionUUID->"23d5c98d-6f94-4224-9ba8-1934789c6551"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.051604620001535`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 791, 68, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.79384593698488*^9},
 CellLabel->
  "During evaluation of \
In[790]:=",ExpressionUUID->"df55ce0f-8d41-4a92-9f17-98326e4ee77c"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.057751287242146`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 791, 69, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845936988666*^9},
 CellLabel->
  "During evaluation of \
In[790]:=",ExpressionUUID->"f6492687-543c-4580-8457-b0f3cf765eb5"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 791, 70, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7938459369926577`*^9},
 CellLabel->
  "During evaluation of \
In[790]:=",ExpressionUUID->"6e92e038-cac0-4ee5-849f-8706ee1a27da"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQXS2yzv1h1Rt7BjAQcYDxeaMEA/pWCzucPQMCmPzK
9R6c/9cIOsi3vg7cIfcWgy91bG56vDa/Q4Et1/XFBZh8gVOb++Uvcjkc+qoR
038Ikz/r1P68ieFsDmDniLzD4P/b3b323mVGhzQwwOQzLSmfNvnML/sdciAH
YfL/mS0tjSz/ZA9yjS3Xewx+7c4I4fkmz+yBjgG6CJN/I609Vvj5FXuwc9Zh
8ku2v/4m9GQrNFw/YPD9qk+4vy0Ls9MEG4jJVwtMNT32Y5t9ENjBmHyB+M+K
ERzX7SHxhck/ffT+L+6JL+2XgAMck6/m0/E/SPSbPSQ+MfnXlKZOv97O4PAN
FB1fMflz5vs8fNDGBo3vjxj8E+HpJz9s43HwAAWHOya/d3HwJq0sQWh6wOTD
0iMAwJZHSw==
       "]]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxl1XlQ1GUcx/FlMaKVZqiBMQ8kxpHB0cQCBAn2IVPEJpcWuZIrdsTxaGIL
IQIcMoQaHARGC1ApIiHjPuKSkpFjoYXACGEDRZZ7OZJzOVwo9rff/z7PzM7O
67/vPM/zfn4WklCPED6Px/tj46f9160B5nU7ZaH9JN/Fo3pn/KQYXeT3g12R
u57LHamzoOcn9JW7vg5JH/Bc1Fb+yfWL6EH54fR7hevMTRllUnRMCS4bsYzf
IdOwmxnahb5+f7Ruy+QqmxJrB0IPxHTsjjFbYcKNaaTOg2BZvnvQK4FLbGOY
jYnQb4eVd6YWLjLdOOhxU0tVvtECs+HWENi3za1pPXqObWzWxkDohM39qtc0
M0w7jaAHXdwjm5rc9ozt0W6X1TC4Pv60evWjKRatHScKbSj+bVqvVcX+bNMu
tDziYlT4h2PMnBtoBOykXGnIMBphn2qPU4o29VzcdHl4kHHbVY92yn8eK1AO
MG4ck1GwNPTVvAb9fnaGW+i0r8UO+km9jLtu1ehZg1uiEP8exh2nYAzMj/ul
yEzaxbjt8kfnaJIzBbK/GDdOEXpK4jAcUdXOdD2Mg42X3fzG/OVM1wP68LkO
o88jZEzXA9o8spDXsVbPdD2gbQozwuIVddSDCqwpZyut4feoB/TZjoWDJ5oq
qAc0U69dqq8upR4mwG+OqL1/jytgKdyBovP+DmnenJPLBrke0FXFc3l1NT8y
W66HSXDcKd6khegW9YB26662/yL3BvWArgy+1ro97Rr1MAUOmI4JCd+ZQD2g
D0iuzg1ujaUe0JKM9cBjluHUwzRY8Fhea5J9gXHHKUXPxlnzFPuDqQd0jZfg
SZqJJ/XwLzhyrf2rxDtHqQe0ZJPG0XvclnpADw3E7m1ztaAenoEbs/6xvhxu
QD2gJT6P689LhoS6HtBOnpH8pY+LhLoeZsCG9kuujtZhQt15oNOLT6UYCYuF
ul7QexouzK14Dgl154W+27X7uWjiBeoJHf2wha9Iep3OE+1Xfr79eIUN9Ya2
jK7NurjlCJ33LNgm/tGNsiAP6hG9Pq841KkfRPcBbW6coFLfPku9orepTNTn
bn5G9wWtyBL7HDaMpp7RIrPcgZP8OLpPc+Avr7sd6eQnUu9o/3m7gFRJKt03
tM0Zn8uFsu/oPUB/c9TIUeCRSfcR7dE78lL6t9n0XqB7d/nESp1/pvs6D3Yw
bA59sbKA3hP0QsB7AwuJpXSf0RGj5oG+jhX03qDVBfdTo8Jr6HuATrHytd57
/D69R+jtgQFNYuUD+l4sgCdKNGstS430XqFtg1SVvNAW+p6gty4nm1qK2ug9
Qwu9+krfFT2kHtBR8vIGeUkn9YAOfePQYLDHI+oB3dBSppYdVFAPi2Bv9/3O
pcF91AM6sE5S29rdTz2gqx8sNXW/r6Qe0PuaJVVj3kPUA7rfNWb1nasj1AP6
ivLXhIjJMepBDTYw9i5bjZygHtAHGi27zOymqQd0W8ScY4LxDPWALhG/3Pf0
+1nqAS38JOeJnus89YB+S9O1y85gkXpYAu/LzGvMfqqmHtBmNQ2XfDqXqQe0
04MchX3/KvWAninXyzLUX6Me0MbpSaLTLv9RD+geRdYJpZznouthGbyDPzxm
r8d3+R+mK1Vh
       "]]}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6]}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6]}, {}, {}, {}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6]}, {}, {}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.4791666666666669, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0.4791666666666669, 1.5}, {0, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7203388490410633`*^9, 3.720338915080204*^9}, 
   3.79384593736309*^9},
 CellLabel->
  "Out[792]=",ExpressionUUID->"5b023863-7d78-46a7-9515-bce26f3950f1"]
}, Open  ]],

Cell["Graphics", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}, {3.7202659495166073`*^9, 
  3.720265950298832*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"163832a6-c73e-453c-b8ad-6d3c64c61ecd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Plotit", "[", 
    RowBox[{"\[Theta]_", ",", "u_", ",", "\[Tau]_"}], "]"}], ":=", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]", "[", "t", "]"}], ",", 
       RowBox[{"u", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4"}], ",", "4"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p1", "=", 
    RowBox[{"Plotit", "[", 
     RowBox[{"\[Theta]1", ",", "unom", ",", "\[Tau]1"}], "]"}]}], ";"}], 
  "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"nominal", " ", "algorithm"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p1a", "=", 
    RowBox[{"Plotit", "[", 
     RowBox[{"\[Theta]1a", ",", "unom", ",", "\[Tau]1"}], "]"}]}], ";", 
   RowBox[{"p1b", "=", 
    RowBox[{"Plotit", "[", 
     RowBox[{"\[Theta]1b", ",", "unom", ",", "\[Tau]1"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p2", "=", 
    RowBox[{"Plotit", "[", 
     RowBox[{"\[Theta]2", ",", "urob", ",", "\[Tau]1"}], "]"}]}], ";"}], 
  "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"robust", " ", "algorithm"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p2a", "=", 
    RowBox[{"Plotit", "[", 
     RowBox[{"\[Theta]2a", ",", "urob", ",", "\[Tau]1"}], "]"}]}], ";", 
   RowBox[{"p2b", "=", 
    RowBox[{"Plotit", "[", 
     RowBox[{"\[Theta]2b", ",", "urob", ",", "\[Tau]1"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "p1a", ",", "p1b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p2", ",", "p2a", ",", "p2b"}], "}"}]}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "4"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"600", ",", "300"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.716727082904867*^9, 3.7167271126452913`*^9}, 
   3.7202659548193007`*^9, {3.7202722335552197`*^9, 3.720272295811294*^9}, {
   3.7202723472481623`*^9, 3.720272376132085*^9}, {3.7202724073658237`*^9, 
   3.720272412805228*^9}, {3.7202725498643427`*^9, 3.720272569918579*^9}, {
   3.720272607086248*^9, 3.720272616587919*^9}, {3.720272810935894*^9, 
   3.720273088477004*^9}, {3.720273125218905*^9, 3.7202731473874273`*^9}, {
   3.720273210745981*^9, 3.720273294636841*^9}, {3.720273356207459*^9, 
   3.720273365014103*^9}, {3.720274770188941*^9, 3.720274779105403*^9}, {
   3.7202750431553907`*^9, 3.720275044834313*^9}, {3.720275574146798*^9, 
   3.720275804307884*^9}, {3.72033110898525*^9, 3.7203311211433353`*^9}, {
   3.7203341010920258`*^9, 3.720334252281534*^9}, {3.7203343067251263`*^9, 
   3.720334318737483*^9}},
 CellLabel->
  "In[793]:=",ExpressionUUID->"8d2f4767-77dd-4e07-af88-03d0096681b6"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmnk8lF/494UyY4sZlK3JmkqopKJcR7YQlSVRZK1QEhKtFLK1EiktloiS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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[
             PolygonBox[{{474, 603, 601, 280, 281, 282, 283, 284, 285, 286, 
              492, 438, 393, 358, 333, 318, 503, 449, 404, 369, 344, 287, 493,
               439, 394, 359, 334, 510, 456, 411, 376, 522, 468, 423, 319, 
              504, 450, 536, 405, 528}}]]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV0clTz2EcwPFfkcrWIhpi8DdQWS9oo4tsY43KxVIO1GDGvl2U5aAamaGm
YezhQuRQGsxYxtTUEGMp4WI/WIbXc3jN+/P9PvOd+T7PM7GorKA0OhKJRNEW
aljmxVJSzaMYSQojSCaJRBIYzjCGMpN81nKIG3xiCDOYRwkHuc5HBrOETRzn
Lj+ZzlyKOcA1PhDPdk7xkCj/uVjLOEYLP5hGBbW085c8zvCYGN8V6X6a6CeO
c3SG/Vjfpi/Cns11OkYfhIPSRTpeX4az0QZN06caq6U6TrvDOelRTdU7+p2p
TPD8KpyvNupYfRb2qOX6PJy1uUZH6z39Qy494T68O62PGGheo13hTsz79Crv
w/9wlo5wF9a26knu84+F1POEQdY36hFu840pbKGaNn6Tw2r2coW+8C0L2EAV
zXwlk82coJVfZFPIHi7TG+6EAtZTyS2+kEEWq9jNJd6FPTOfdRzmJp9JZw4r
2cVF3jKAycxmBTu5wBuimcQslrOD87zmP7tOXn0=
              
              "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwd0wO7EAYABdBe9mq1rFdty7bNLbzselkv21y2tlpari23bNu2bfvU/e75
7i+4gcFtgkICQknA94baz1Te0ZFnbOcTVbnLOj4wjtfsoRBXWc4wXrKLVjxi
M5PJyhkW0I+G3GcDE/idm6xmFG0JzQGm0YlqFOYaKxhOa7JxloX0pxHlCMNB
/qYz1SlCds6xiAE0pjxhOcR0ulCDouTgPIsZSBMqEI7DzKArNSlGTsJzhJl0
oxbFyUUEIhKJyEQhKtGIzg/EICY/EovY/EQc4hKP+CQgIUeZRXdqU4LcJOIY
s+lBHUqShwssYRBNqUhijvMPPalLKfJykX8ZTDOCSMIJ5tCLepTmOisZQQj5
uMR//EFzHrCRiVTiFmsYTTuesJU/ScpJ5tKb5+ygPvdYz3jKcINVjOQVu2nD
Y7bwkSm8YS9fyM9llvKeIbxgJ59pwUM2MYnK3OZ/xtCeZJxiHn1oQFkKEEhy
UpCSn/mFX0lFatKQlnSkJwMZyURmTjOfvgTzGwW5wjKG0pIq3GEtY+nAU7bx
F2/Zx7fjZzFfAStqgTY=
              "]]},
            Annotation[#, "Charting`Private`Tag$659053#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV0WWLlGEUgOGZNdbuWFt/g91gN7g29lpgrYIt2A22YgsGBnaDrdiCgYEt
tq4KtmJf58PF/cy8DPM+51TKyEwfmkwkElkkHZ6wjQl0pQGVSeEp25lINxpS
hWw8YweT6E4jqvKBw8xlIG3JznN2MpkeNKYaHznCPAaRTg5esIsp9KQJPznD
MkZQnU8cZT6DaUdOXrKbqfSiKb84y3JGUoPPHGMBQ+K3KYnENd1Ae/5xkdWM
Ja/nt3QLqbxiD9Mo4Nkd7R13dr6i6yjq/FCb8ZtzlPLdCi2s93UUuZ1vaFnd
pMX1sVbUmvqF45T0eaEW1LtaTmOpqXpdy+hGLaaPtIJ2iKXrJS2ta7SIPtBx
5HO+rVvJxWv2Mp2M2InnV3U9zfnDeVYymlp85QSLyKQjSb+7rGsZH3fkDfuY
QR9aUJtvnGQxw+hEHrLYz0z60pI6sQvecoBZ9KMVdeM+5I+dxJwoFLOOO8c+
YjYxX0rEPOniPdNiLzGfmGHsIWZLed5xkNn0pzX1+M4pljCczjFv3nOIOQyg
DX+5wCrGxN38503dTH1+cJo03y+Nd9Z7+h/JZnBL
              "]], 
             LineBox[{542, 370, 520, 466, 421, 345, 514, 460, 415, 380, 288, 
              494, 440, 395, 360, 335, 320, 289, 290, 291, 292, 293, 294, 295,
               296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 495, 441, 
              396, 361, 336, 321, 505, 451, 406, 371, 346, 515, 461, 416, 381,
               525, 471, 426, 534, 480, 545, 306}]},
            Annotation[#, "Charting`Private`Tag$659053#2"]& ], 
           TagBox[
            {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{549, 599, 550, 551, 552, 553, 554, 555, 556, 557, 558, 
              559, 560, 561, 562, 563, 564, 565, 566, 567, 568, 569, 570, 571,
               572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 
              584, 585, 586, 587, 588, 589, 590, 591, 592, 593, 594, 595, 596,
               597, 600, 598}]},
            Annotation[#, "Charting`Private`Tag$659053#3"]& ], 
           {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
            LineBox[{547, 548, 
             546}]}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{7.989795918367345, 1.4999999999999432`}, {7.5, 
        6.500000000000014}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 7.999999836734694}, {-4, 4}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {182, -113.24611797498106}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}], InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmHk8VO/bx62l7AZlT6RNQ2UJcZ1CRJQtqfgSkmSXqFSEZElFSWmzFWUt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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[
             PolygonBox[{{333, 28, 26, 139, 140, 141, 142, 143, 144, 145, 351,
               297, 252, 217, 192, 177, 362, 308, 263, 228, 203, 146, 352, 
              298, 253, 218, 193, 369, 315, 270, 235, 381, 327, 282, 178, 363,
               309, 395, 264, 387}}]]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwt0slTjnEAB/C3xCEZzFBDhjbLRaKDZWhGjGGYoklZO9gdKkP2aNGmURn9
D7JzsReXQh0sWS+JOpBRM2R36fMMh898v9/fb9533neeJ35LYVZBeCgUCqON
ImKZSC0nqaGaKiqp4ATllFFKCde4zxv+MsOX5nFcv8o9XvOH6c43c0zvoJcR
diq7uWK38IrfTHO2iWJ9gLF6GkW02z0M1+ewi8v2J0bpC9hDsz1epnOIl/Yv
puobOapPkisood/OlJWMoY5F7OORuzNyDdXEUM9SjvDe/Wm5inIiqGU2O7nk
vlFmUcMEGlgW/Ef63GfICqI4xXwKuetutaxiHIs5yAvnK2UZP/UkuSH4PcEz
lcuDZ8Fne7RcyF4e2tFyCYd5Zw+TKezgov2Rkfo8CrhjP+cHifb64LP6A7oJ
t2exnQv2ByL1ueRz2+7kOwn2uuCZ/H8H3wbvo53MNs7bt3jGN+Kd5Qb/WW+l
K/TvBZ7JVs6ZN3nKIHHOcjigN3GDJ3xlivO17NfPcp3HfGGy82yGALCoYiQ=

              
              "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwt0cVSggEAhdHf7u6NioXd3R2Ahd2KXWC8pg/lccbFmW91VzeUSMWTaUEQ
fPDXS6J8MkWSM77p5ZVjvlj/313QwhMHrJDinHHeOSVCPXfsssAwb5ywQScv
HLHGJOlcEWOaPlp55pBVJmjgnjiLjNBFBtdsMkM/bTTywB5LjNJNJjdsMcsA
YUI8ss8yY/SQRYJt5hiknSayuWWHeYbooJkccskjnwIKKaKYEkopo5wKKqmi
mhpqqePHeb//3hyR
              "]]},
            Annotation[#, "Charting`Private`Tag$659101#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl0vVrlVEABuB7bcwJBk5Rp84CW7EFA4OZw27sQGfH7LVr5/9gN9gNtmA3
2IIt2A0+B394eN/3fFw+Dt+Nm5SUODcaiUTesIihRm0+6lfYzyYWM8x5HT7p
VznAZpYw3HldPuvXOMgWJjtrFl7AQ3GGpYyw4/iiX+cQW5nirDlRHtlnWcZI
ux5f9RscZo7dnrK8tLcxVW9BMR7b51jOKLs+3/SbHCFcvAPleGVvZ5rekuI8
Cb+VPanGeXuB7EIl3tmrZV9qkmyPlg34rq+TCdwKd5bdqUIGgznqPEl2JJfy
pDGQ156tlL0poAZZJLKRHZ5Pl63IpgQp9KeQp54ny17kU51MhlDEBc8Xyq7k
EUM6g3jv2RrZj1qssMfIeH7ot8M30XtQlWP2PNmJCtH//6WdzNBbU5Jn9sXw
H9O7UZkP4Y6M1RvyU7/DcXYx01kbSvHcvsQqxtmN+KXf5QS7w7dgvPPG/Nbv
cZI94T6sDd+EFFJJI50MMsliPdnEkkMueeRTQCEbmOAdTfij3+cUe5nlrC2l
eWFfpoiJdlP+6g84zXy7MxV5G+4m+xDLPnu2bEcOZUhlAP8AHct1Lw==
              "]], 
             LineBox[{401, 229, 379, 325, 280, 204, 373, 319, 274, 239, 147, 
              353, 299, 254, 219, 194, 179, 148, 149, 150, 151, 152, 153, 154,
               155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 354, 300, 
              255, 220, 195, 180, 364, 310, 265, 230, 205, 374, 320, 275, 240,
               384, 330, 285, 393, 339, 404, 165}]},
            Annotation[#, "Charting`Private`Tag$659101#2"]& ], 
           TagBox[
            {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{408, 458, 409, 410, 411, 412, 413, 414, 415, 416, 417, 
              418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430,
               431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 
              443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455,
               456, 459, 457}]},
            Annotation[#, "Charting`Private`Tag$659101#3"]& ], 
           {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
            LineBox[{406, 407, 
             405}]}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{7.989795918367345, 1.4999999999999432`}, {7.5, 
        6.500000000000014}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 7.999999836734694}, {-4, 4}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {546, -113.24611797498106}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}], InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlm3k0VP8f/4cZ29i37DORSrJVlpK83iGRCNlDlpRKEhJKpZAsqSgllSKi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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[
             PolygonBox[{{721, 851, 849, 527, 528, 529, 530, 531, 532, 533, 
              739, 685, 640, 605, 580, 565, 750, 696, 651, 616, 591, 534, 740,
               686, 641, 606, 581, 757, 703, 658, 623, 769, 715, 670, 566, 
              751, 697, 783, 652, 775}}]]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV0UlQj2EcwPG3ohIaS8PZ1RLFRZYsF9lm/JW1S9kOLWgm+3JBcbBMzIQx
DCFxseUQDWaiMQyTZezSJYVDGGX3eQ6f+b7rvO/veYYVro6VxkdRFEcTPQ5i
CVE0j1Q3+tOPvqTQh2SSSKQ3vUhgHNPJZzsXaCOesUxjKds4z3vimMsq9nCN
z2QylSVspY7W8KOUcYjb9DCHleymnk9kEAY7QCPfmMJh7vCbxWzhHO/4Z/YT
+iDMY/61+jjM7PigDtRb2s1shjh/GtZGj+ogbda/rCDN+aOwTlqpqXpVPzKG
oc6fhfXVYzpY74UZtURbwlo73q8D9IZ+JZsnYT9cq9YmfrGIh2FPXN+stbwN
/2Ou43o/7IV7a7SKm3xnFke4yx+WU8EVOhlNMfu4zhcms5BNnOVNeNd3Zuoy
dnGZDtIpYi8NdDGJBWzkDK/Dnng/RwvZySU+MIqJ5LGB07wKM3t+hhawg4u0
M5IJ5LKeGl7y0/MjNIv5rOMUL/jh3nAdT4xyTvKc/4ARZkk=
              
              "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV1WWAVVUUBtChu7sZulHp7gaFoVFqaESGUDoNMAA7AVtsCUUB6e5uBBGw
sFBBsNC1f6zZ395veOfcc+9lEpNTkkanSkhIuOFH1Bl+FOBrNuuPqKO4wmz9
BrUXl0nDWSbQ2WdL1bb8Lp9Ux7JC3q0OIjs19AvVmnwpv8xWuS8ZuUe/Su3C
P/LnpGamviBb5PvpwjJ9O67KH1OTRfpanJdfYTRpmGVWiK3yAyRRi8VmtflK
fpUU0jLbrDDb5AfpSu3Yr1kdLsivMYZ0sSezImyXH6IbdUgf65kXZYc8h+7U
JQMZyURmspCVbGQnBzljff+2GDvlufSgHrliLfPi7JIfpif149rN6nJRfp2x
5I71zUqwW36EXjSIazerxyX5DcaRJ9YzK8ke+VF60zCu3ax+PCfym4wnb+zB
LJG98mP0Ybm+PdfkT2gUe9I34Bv5LbbJ/cjEvfrVahL/ymvZLw8jN/li72op
9slH47lhnrxR7U1azjGRO81XqB34jj/0p9Rx8ayyUr9HHcxP5IjngSnxuzSO
M1Ebxn75Vn9cTeFXlui3q/35gczxbDOJ+3y2Ru3KTflMXB/r5APqcPKQP85X
Lc1+eT6b5D6k4654xtWOXJc/pUmcvb5RXJf8NhPindF34z95PQXiXujLcEBe
QN+4F/pO3JA/o2nci7hevpffYSIFmWdWloPy4/SjGUvMmnBZfpdJFIr9m5Xj
kPwE/WkeezRrGuckv8dkCseezMpzWH6SAbSgSKxnXoEj8lMMpCVF47vNK3JU
fppkWlGM4pSI/fgPoKSaSClKU4aylKM8FWJd31OJY/IzDKI1FWNd88ocl59l
MG2oFOuaV+GE/BxDaEvl+B7zqpyUn2co7eJszZrxo/w+U6gS321WjVPyCwyj
fZytWfN4PuUPmErVWM+sOqflFxlOhzhbsxb8LH/INKrFHsxu4Yz8EiPoGHsw
a8kv8kdMp3rswexWvpAXMpKV+tv5U15Fp9iTvhVX5KXskAeQhRn6tWp34o/M
BuWgOoK8sZ/Yu3obZ+VFbI73lvTcHc+7egd/yafV8ayW96pD4jrJyQWmxv7i
utXW8b7Ge6o/oY7hN5bpd6oD4x6QlfNM5hozfb5O7RHvAqniDOJ95iobfX5I
HRlnRj4uMi3OK85WrcE5+Zgaf2QXy1viXSYDo+K9Uzvzt7yGffJQcsX1xr1Q
28Se5eXskpPJxiz9erUnqdmkPxznRX4uMZ3rcbY++x/apvrl
              "]]},
            Annotation[#, "Charting`Private`Tag$659149#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV0VVoV2EYwOH/Nrtme+2t3WA32OLsBGeCuqlgN9iKLRgY2A22YgsGBrbY
Deos7Nk+78XD7yTnfO9XOj0zLSMpkUhkke3gTnIisY4RpFGTMvxw766uZyTt
qUVZfrp3Tzcwig7Uphwv2c1UetOMX56/rxsZTUfqUJ5X7GEa6TTnt+cf6CbG
0Im6fOQI8xhEBV6zl+n0oQV/vP9QNzOWztTjE0eZz2AqksU+ZtA33uUcK2jJ
N06ymKEkpyQSl3QNf33nkW5hHDndu6JdYs2cYRn5XL+p9fnMMQq7tkDz6HUd
QsLxBS2mq7SA3tZSWknfsJ9CzmdqLr2qxbVf/A/nKep8pebXW1pSW+l3TlHE
+RLNqzd0GCmOL+ta/lnXY93KeLrGnnCW5TTgC8dZSAaVecsBZtGf1mRzmqUM
jzXyhG1MoBsNqcI7DjKbAbQhiadsZyLdaUTV2AuesYNJ9KAx1WI95Ig9iTmR
O2Yda479iNnEfCkY86Sd9afGvsR8YoaxDzFbSvCcnUymJ02oznsOMYeBtI15
84JdTKEXTfnKCRaRGWvzzYu6mhp84DCprs+Nf9Zr+h8mpHbu
              "]], 
             LineBox[{789, 617, 767, 713, 668, 592, 761, 707, 662, 627, 535, 
              741, 687, 642, 607, 582, 567, 536, 537, 538, 539, 540, 541, 542,
               543, 544, 545, 546, 547, 548, 549, 550, 551, 552, 742, 688, 
              643, 608, 583, 568, 752, 698, 653, 618, 593, 762, 708, 663, 628,
               772, 718, 673, 781, 727, 792, 553}]},
            Annotation[#, "Charting`Private`Tag$659149#2"]& ], 
           TagBox[
            {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{797, 847, 798, 799, 800, 801, 802, 803, 804, 805, 806, 
              807, 808, 809, 810, 811, 812, 813, 814, 815, 816, 817, 818, 819,
               820, 821, 822, 823, 824, 825, 826, 827, 828, 829, 830, 831, 
              832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 842, 843, 844,
               845, 848, 846}]},
            Annotation[#, "Charting`Private`Tag$659149#3"]& ], 
           {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
            LineBox[{795, 796, 
             794}]}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{7.989795918367345, 1.4999999999999432`}, {7.5, 
        6.500000000000014}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 7.999999836734694}, {-4, 4}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {910, -113.24611797498106}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}]}, {InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxd3Hk0VdH/P37TnUzhShFJpEnSgEj2K5EyZC4yJJoHDRpUKgqpSIOKEhXR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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{
              PolygonBox[{{847, 1031, 1029, 537, 538, 539, 879, 784, 707, 648,
                606, 581, 540, 880, 785, 708, 649, 607, 582, 898, 803, 726, 
               667, 625, 541, 881, 786, 709, 650, 608, 583, 899, 804, 727, 
               668, 626, 542, 882, 787, 710, 651, 609, 910, 815, 738, 679, 
               932, 837, 760, 584, 900, 805, 957, 728, 942}}], 
              PolygonBox[CompressedData["
1:eJwV0j1I1GEcwPG/3p3Xi7tZLk2lkwlZ2umg4BBUvpxIk3qplUNtaS/aZjXZ
GxRU+EKCJ0KEep0GIQgKmrWbTdpUUA0GbX6e4cPv+3vg7n//hzueudl6ozCK
ogLeEo9HUYy4w86YA+b0IBc5zS1nJazrUXpJ0OWsgHl9m0tUM+DsCBv6MX0U
0e2skAV9h2ZG7CfY0mOcCc+2l/JZP+GVTvFbXw2/QVeyo6dJkrHHyOm7vNBn
+albeKBP8k2/M5sZ1xNmA3s6Z3aEz4X3MY+yqWfNCzzVr806lvljnzfbWeNa
eF/zFJ/Ytb83W1kla58ym1jhvz1vXg53ywH7FTPORz7Ys+Z57umXZg2/9JyZ
Dt+tH5rlbIf3YVI38k/XhLvWx/iin/FG1/NXXw93rKv4oWc4SI89QV4P0cYj
ewXfwzOoDXdtL+Orfk4/h8J/xFkRi3qYNOc4HP4PzpMs6fu0k6KYfZqGTtU=

               "]]}]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{
              PolygonBox[{{512, 1030, 1027, 612, 654, 713, 790, 885, 564, 589,
                631, 690, 767, 862, 515, 563, 588, 630, 689, 766, 861, 514, 
               513, 562, 587, 629, 688, 765, 860}}], 
              PolygonBox[CompressedData["
1:eJwV0rtL1WEYwPFfdYTUNDNvi5WtmYu6FOXtgEISWKBmurRU3v+ALlpeoHTx
rkMO3sASIogILSsadCvT1WqpFhtsEHTp8w4fnu/zcobznvPm3eq41n44iqJD
zBKLRVECOQ7jNNHPJ44fiaJ2snUFjfTxkVTnbWTpTqbY4qyzbsr1PD8psA9y
U/fygRR7K5l6iT8U20fo0JNskmfvokzP8YPz9gEa9F8u6il6dLX5nFV9zGwh
QzeYbznQVeYCL/R18xW/9apZxHC4t33NrOU1/8K9zVKmmbB/Nq+yxDf7inmG
h+Fz9nWznjfshd/UjDPDrL3GfMl3nW8+5Ybe4YKe5LG+Yi7yXiebzZzU+1Tq
+XBn/YtCPRT+G71LiX7GuN7gtH5AiZ5hm3P2J+G76ke8I8l+l3TdyhhfOeXs
Ppd1Hd3h3iQ6u8MJ3cIoX8h1do9LupYuljnq7DZp4Z2F9xTeBP8BiNdQaw==

               
               "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl1WW0VVUUBlAapJFOeXR3pzTSDdIdUhKSioktSoiFhYSiKIgo3d3djSIG
2Cgq4FzDH/N939r3jjvOOXuf8RL6jmw3InGiRInu+BP5sD8Z+I4V5sNyIDeY
YF4jW/MTf5kvyDG00D+UNflaPyWHM0/fKbuTnIrmV2UxDurT2aR35LY+gM/1
RlzXPyUJj5gzslKfSEsqMdtacQ7pMxhIUqZYy8QqfRKtqEwykvOoz+5mtT6Z
1lThNWslOKzPZBApeMxaZtbEM6INVXndWkmO6LMYTEoet5aFtXHttOUjcy2+
0edTjTfMpTgaz4XNeifu6ENYpjeO561/xl69N3eRyvyEzMo6/YgcxBR9rWzD
Tf2iHEs7fZGszTWumE/LOAB/s8C8S/bgV1LEXjKeW1T3+ZuyND9wzHxcPhBn
gdnmLbIzv8Rh4jLj4jvGL2QTftbPyVEs0ffJPqSO+zI/KbOxPvaJdXrbuEa9
PR/rdfhWX0gN3jKX4XjsIUNZbm4a16IvJTVPmbOzIfaUDtRkjrWynIg9ZRhp
mGotBxtjT+lILdKSjvRk4Gnfycmm2BM6UZu3rZXjZOw1w8nIM9ZysTnul858
Yq7L1XiXqMM75vKcimfPCL403xd7FO8KmXjWnJstcY+sj/3mH70Li/V7472O
c0hd3jVX4HQ8P7bqXUjMSPNXshm/6eflaJbp+2Vf/iBN7AOT4n3y2XMyD9+z
1XxUDuZPppo3yPZxBvjXfEk+FJ37432X9bgev2E+E9cS98Ei827ZM66JlPEu
MSHuzWfvyYqc0U/IoczRt8Vvk4QHzStkc36PM8kBvR9pyWx+XuZlW+wrXePd
M9ePcx/nj3q8b67E2dhnRpGFF6zlY3vsM92oz1xrlTkX+8posvKitXvYEftI
dxqQjZes52dnPFt60JDs5CAnucjNNN9LYFfcAz1pRB5etl6A3XF99KIxH1ir
wvk4D4whL69YK8ieuD5604R51qpyIZ43Y8nHdGuF2BvXTB+WmBvwY5xtmjLf
XI2L8fzYrnclaZwD80rZIs6WvpyDen/SxTMyz5CF2acfk0OYpm+UHbil92Wp
3pBr+tnYdxbre2Sv2HtScYWJ3I53yucLZPW4Zi6ZT8ph3GSueYfsRjLGmVfJ
ltyI95L8zDQXYX88d/rRjAQKUJBCFKYIRSlGcUpQklKUpgxlKUd5ZvndohyI
PaI/zVlorQaXY08Zz2pzq3j34l3mkD6A9FxlcuL//+9X8Nl/mi8Cww==
              "]]},
            Annotation[#, "Charting`Private`Tag$659197#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV1HWwVVUcBeDzim6UBsUYG5VQaaRHukMaA+shzoiFCSIYqBigYIKBoiKN
hQVid4xdqDOKOfYY3/rje2v99rvv3nv22ee1njZzeGVJURRL8qO0KCaUFcU/
cg1nMoC2lFDKRL//Vz7MbAbSjjIm+d1/ci1nMYj2eR/rjXheX8RxeX15UZTL
ydYL1ulnM5gOeW9rjXlBv5rjqWCKtRLW6+cwhCPyedaa8KJ+DSdQhanWStmg
n8tQ5pv34339No7MZ5ub8pJ+Lcv0Lvygn5jvoB/GF/q9VGWauYyN+nks0Y/i
W30Yl+n784H+kBzK7fodsie/6hvlmPxdrkc242V9tRzEYn257MqT/GheL0fx
HDNyvfJwnuDL3Bs5nO2sMt8l+/IMf5o3y3HZW6qZp8tyHmWTeZU8hjn6UtmR
7/R1cmTeW18gD+DDXA936r34Te+Yvdab84p+Hbfo3fhJPyl7rLdlp34f1XMu
zBVs1s9nBAvNB/JRPoNO2WtzC17Vr+dkauSMWKvCFv0CRtKZmjkP1qvyiH4h
o+hCLcqdxdqyDnWpl3uevcme6Bcxmq7MsdaS1/QbOIX6zLBWncf0ixlDt1yH
tVa8rt/IqTTIHlirweP6JYzlcvNBfKyvoHuuw7wHb+R8cavenZ/101ist+Mr
/X7u1vvxl94we6PXzNnIPssBzNVvkp3YpY/jCv1gPtHXyGGszPeQvXma382b
5Ng8y/TIXso9c928aX5ADuZZlub5yut4il/MG+RodlCZsyHbs5WvzWvlCFbr
98j+/K1vkePZLXsua+Vvcs1yIPP0m2VnvtfHc6V+CJ/mGeDo3Etza97KHjAz
Z8jcgW/y/dk998lcO8+cfinHcpW5DZ9ln+mZe23ei7fz+ZxOo9wba3Vy3fp8
JtCLxlRar5s9zf8IJtKbJlQ4i01lM5rn+3ldvTy7eeaYRB9a5LOs189e5zlh
Mn1znqztzTv6MmbRMmmtAdty1phCP+Za24d39eWcQauktYb5P5LzwVQWmQ/l
89wfVup9+EPvzzx935xr3jM/KIfwP5iFv8s=
              "]], 
             LineBox[{965, 669, 928, 833, 756, 627, 917, 822, 745, 686, 543, 
              883, 788, 711, 652, 610, 585, 544, 545, 546, 547, 548, 549, 550,
               551, 552, 553, 554, 555, 556, 557, 558, 559, 560, 884, 789, 
              712, 653, 611, 586, 901, 806, 729, 670, 628, 918, 823, 746, 687,
               936, 841, 764, 954, 859, 971, 561}]},
            Annotation[#, "Charting`Private`Tag$659197#2"]& ], 
           TagBox[
            {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{975, 1025, 976, 977, 978, 979, 980, 981, 982, 983, 984, 
              985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 995, 996, 997,
               998, 999, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008,
               1009, 1010, 1011, 1012, 1013, 1014, 1015, 1016, 1017, 1018, 
              1019, 1020, 1021, 1022, 1023, 1026, 1024}]},
            Annotation[#, "Charting`Private`Tag$659197#3"]& ], 
           {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
            LineBox[{973, 974, 
             972}]}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{7.989795918367345, 1.4999999999999432`}, {7.5, 
        6.500000000000014}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 7.999999836734694}, {-4, 4}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {182, -339.73835392494317}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}], InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxd2nk4VV/YN3DTGQ2ZKkQqUkmaE6l1GxqEpChDpJQ0FyqVihQypEEhMkSE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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{
              PolygonBox[{{829, 147, 102, 519, 520, 521, 861, 766, 689, 630, 
               588, 563, 522, 862, 767, 690, 631, 589, 564, 880, 785, 708, 
               649, 607, 523, 863, 768, 691, 632, 590, 565, 881, 786, 709, 
               650, 608, 524, 864, 769, 692, 633, 591, 892, 797, 720, 661, 
               914, 819, 742, 566, 882, 787, 939, 710, 924}}], 
              PolygonBox[CompressedData["
1:eJwV0T1IlVEcB+BXQy13tcmKNPXakOAQaDe7F3FJzY+0WUztw1z6mCoVFFQs
IdAQIjRLBQmChNLcs6ZyMiiHAjerq5Y59Zzh4fc7//e+H+fcY209jTfSoyhK
Y4bzlJEyqD0QRVsuTtFBJcdpN8/gjX6XJrb9vs7spz5NJ2co4LJ5Jm/1ezSz
4/f1Zr/0Z3QR56ZZDu/1UQrDu62zWNLvM6TH+KpfDN+g5/NJH2fXsy9Y/9Zn
uMKA9QnW9bPc0nNZ1Z/IOA/0h/IU38O9sjrcF/YjD7KsT8oKevVhWcpLvoW9
yySLtIT9yiMs8Nn6qaziNRPWj2Q5r9i0fiFrwtnyxz4aZMp8Xj6XE/I0V/VB
WcSX8B/JRHi2flvm8SHshzG9jB96UThr/RDv9D5G9JNs6K3hjPWjrOmP+es7
Gq23w/dxjXPcMTvMx/AOisNZW2ezovdziT33N5nt6LNcJ0EJ/1xrdm1Xn6Ob
JDH2XfsPQdNUzg==
               "]]}]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{
              PolygonBox[{{494, 121, 49, 594, 636, 695, 772, 867, 546, 571, 
               613, 672, 749, 844, 497, 545, 570, 612, 671, 748, 843, 496, 
               495, 544, 569, 611, 670, 747, 842}}], 
              PolygonBox[CompressedData["
1:eJwV0j1PU2EAhuEDFRYRXEWX4iKBojTBRGNiTCqiOJmIAsWBwUGh9TNRWAT5
GmBAIUGbGBMlRBEhDLABwgq6qIsMMpDAHxCRglxnuPLc79sOPW2jzelrqdwg
CHJ4z1Vuk+8yTi2PmWKXZCQI8mwlV3jEJFkavXbA3qKPJQ67S3NKD/GNY87t
XNYP+cwODe4iNsNPjjt30qR7WaTIOcVJ/ZKvHHVuo0avUqr7eKDP2ldM6H/U
61xbY8fY1KftMK/1BfuWH3rCltBB0nnGJnjHWvjctoIBepyn7TkyfHH+aAtp
Dd/nPGurGWU9/E5tnEFeOJ+3b1jRxfYpl/QvTuhe7uszdoRPepubOsduUKWH
wmfW34nqZzTq38R0P916gUO6hZgeZJkjzk/Cz6rvMc5fbrgLwt+JLuYpcHeX
cn2RdPjcbFHn/r8/Vr1+zhwH3d2hTCcI/3wf+MN193vev0uWHfYBT9pSmw==

               
               "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl1WV4l2UUB+CNlgbpHt2gtKR0KDEayQFSwkBSVBAwUGkFxQAMwkBRlO7u
VmwRMQEVW0H0Ppcf7p3fOX+u7d3znmckpaQmj0pMSEj41peoY33Jykds1O9T
+/E1k/VvqW05xx/6U+oIbpeXqHW4IB9RB7NC3qZ2Jx019LPUMpySn2S93JF/
5CG8Ijflx/h5pGGcPhub5HtpT01mm5XltLyQoaRlvFl2Nsv30YFapCM9E3yW
gy3y/XSkNnPMynFGXsQwMjDRLCdb5Sl0og5zzcrznvwUw8nIJLNcbJOnksxS
fV2+kldSl3n6CrwvP80GuRPX5RG8KjfjJ/ltMnGPPjfb5QdiLrfjT7kzy+R6
8c7ko+qdrJK3qz1IH89LvPh65vPVinzCWf1BNSXx/51YrN+oJnOef/Vn1JFc
5i79a2pzPueK/oQ6jIus1e9We8fvzQ18wJjIPpus3sgOeb/an2nyWvU2/pK7
8IJ8C9/EfrBD7kmGmOsXqJXie8vPMJLX9S34WX6HzLE7+jzslKfTlRf19eP3
jfOmPk/oK/Oh/CyjyBK7ZJaXXfIMutGArLFH5vnYLT9IdxqSjezkiN3xeX72
yA/Rg0ZxD8yqxL2TnyOVnLE7ZgXYKz9MT17SN+C7OHsax+7rq/Kx/DyjWa1v
yS/yu+SKfdEXZJ/8SJxL3F3+lnvxstyQ7+P8aBL3QF8t9kNewia5M/EHY4zy
htqKX+WT6nDWyXvUPmSOc+Tu2FvzaWqheFb26w+oA+LdMjOeVW3PF1zVn449
4xJ36Jerjfgsdkx/TB0Sz8xq/U61F1+SMe4Wqdwad1StzqfyIXUgS+XNahcS
4zn1b6qt+U1ez165L1liX2N31MIckB+lNyv0jeM540xoGndaf1M8a9xLxpIn
dsesCAflx+hDMxab3Rx3KXaeceSNfTIryiH5cfrSnHyxR+bFOCzPoh8tyE8B
ClKIwrFD/l1xjsiz6U9LisQ+mJfgqDyHAbSK+2RWg3NxVxhPUWaaJXFMnksK
reO+mNWM9xe7ygSKxTmZleS4PI+BrNQ34XKcOW1i//W1OB/7yBa5K2mYqF+j
tuF3eQPF4wz1pTghz2ed3IFr8iBWxfvnB/m4OpQ18q7YKS6QibOMpm3cI7V2
7Erskv6wOijuHcv1W9VupGWSvkS8G7k0J+UFDKYdSZSkFKUpQ1nKUZ4KVKQS
lalCVapRnSv+U/sPkufwCQ==
              "]]},
            Annotation[#, "Charting`Private`Tag$659245#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV1HmUT2UcB+A71hlLWg6pVIbKGEvGdrLvS9bMmEklOhGhyNYiFSqhhbSM
LUsZyk67bBGHFFI5p406FXWUXXZ6vn888/m87733d+99772Tfv+Q7MEpSZLk
+3OIDoWT5GChJJlNHxpQkcO2HaGj7f8Yz6EvDUnnqG2dbPtXn8sDNKJS/I75
InysjyabLOc85pjO5g8Zz6Mfjakcv22+KJ/oT5HDcft3MXdYf5v+NOGmOJ/5
YnyqP013Tti/q7kj+js8SFNGmCvLVv1lbo5zGxdntf4ME/VMftFz4xr0G/hG
f5OTfvsO46P6fAbwvPEt/KA3Y6Rejm36W7Ipr+iTZS1+j2Nlmzgu7kem8pk+
QzZijD5JVmMZe+PeZSs+JC/uV97IEnbHs5HN+YB849dkXVZywHiBbBdry3/u
o5s8Zv49WSDz5W0M1MfLKvwYz0i2jN/WH5VX82XcD1P0LP7Qq8Ra62ms0cfy
ol6dffqdscZ6Rb7Vp3HKdWQbH4/rYxAteMxcebbHOciItTYuwVp9HD047fgc
cyf0hTxES6pyxrbutp3U3+VhWpHJ2XhvvYvn5HkucJHcWJtYEwbTmmoMNF+S
dfqz3MUl++eZO6UvYghtqB73Yb4U6/XnuJsk1sDcabmYR2jL4+au4Sv9VWrE
fRiXZkO8X7yk1+BX/R7G6Ol8p0/ndb0ef+kpsTb6Gbkk1llvwFD9BZnBT3o7
ntCv5Wt9tmzG1LgOWZsV/GlcINvGt0zNWEt5GYv43HimbMwqxsf3FfuxnN/i
O5St+Yie8W7ISizle+O5sgUz9Ddkff6OZyrbUyjWXJ6VS+Oe9YYM0yfIqvys
t2eUfh074hvg1niWxmXYGGvAvfEOGVdmT1w/heM5GZ+TyxjO7TxprgI7Y52p
Fc/a+HI2xfnpRZF4NubOy+WMoANZFKWnbRfkivgfQUdqU4x+Xo/iMpW0uD77
XpQr45ujE3UoEeey7ZJcFd8Jnakb75P5K/hCn0hvSkaaS3g/3jW6UI+h5q5k
sz6J+ygVaS4l/o/E+0FXRhtfz654PkzV67Bfr88w/SoWs8V4lmzC/0b7yAo=

              "]], 
             LineBox[{947, 651, 910, 815, 738, 609, 899, 804, 727, 668, 525, 
              865, 770, 693, 634, 592, 567, 526, 527, 528, 529, 530, 531, 532,
               533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 866, 771, 
              694, 635, 593, 568, 883, 788, 711, 652, 610, 900, 805, 728, 669,
               918, 823, 746, 936, 841, 953, 543}]},
            Annotation[#, "Charting`Private`Tag$659245#2"]& ], 
           TagBox[
            {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{957, 1007, 958, 959, 960, 961, 962, 963, 964, 965, 966, 
              967, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 979,
               980, 981, 982, 983, 984, 985, 986, 987, 988, 989, 990, 991, 
              992, 993, 994, 995, 996, 997, 998, 999, 1000, 1001, 1002, 1003, 
              1004, 1005, 1008, 1006}]},
            Annotation[#, "Charting`Private`Tag$659245#3"]& ], 
           {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
            LineBox[{955, 956, 
             954}]}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{7.989795918367345, 1.4999999999999432`}, {7.5, 
        6.500000000000014}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 7.999999836734694}, {-4, 4}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {546, -339.73835392494317}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}], InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmnk4Vd8bt01nRjjmIcmQJCkZKrWekCFUplAokeZEKg0qlIRSUpEhUgmV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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{
              PolygonBox[{{884, 122, 49, 574, 575, 576, 916, 821, 744, 685, 
               643, 618, 577, 917, 822, 745, 686, 644, 619, 935, 840, 763, 
               704, 662, 578, 918, 823, 746, 687, 645, 620, 936, 841, 764, 
               705, 663, 579, 919, 824, 747, 688, 646, 947, 852, 775, 716, 
               969, 874, 797, 621, 937, 842, 994, 765, 979}}], 
              PolygonBox[CompressedData["
1:eJwV0klLVQEYBuCjbbSVQrZICFqU87RXq70lCCY45NDCQEjIoZRoVQ6V+QOa
TN2VrjQLFFJSQVAJIrQsgwgEg6zc1/MtHt73+849955z7jnV1llzLTVJkhQm
KaWEPMs7R5LkNFv6E7qo55FdOb/0Ge6Rz127M2zrT+mmgcd2FRzos9yngAG7
HD7pz+jhhbmKf/o7GuO3zZX81l/xVm/lGA/iGmQtaaybCxnUc/msjzGvN5FB
r/mlvEDCB3pYtl+R7ZyIc7kV58X9yLP80d/L68zpi7KNH2TFvdPPT0bifuUl
vpPOR26wz4bja7KDPU7yhdvxbClyfEjm8Y0d84bs5Lm+IC+TGf8RffHd9lPy
IimsmFflVbLj8/Gs5Tn+6q9Z0q9wnIfxjGUdR9k0FzOs58f16ePcZNpcTSqr
5uZ41vp5DvU3jFIS74hdAV/1CfpooTTeB/tCdvVJ+mmljP9UsVid
               "]]}]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{
              PolygonBox[{{549, 86, 47, 649, 691, 750, 827, 922, 601, 626, 
               668, 727, 804, 899, 552, 600, 625, 667, 726, 803, 898, 551, 
               550, 599, 624, 666, 725, 802, 897}}], 
              PolygonBox[CompressedData["
1:eJwV0s8v13EcB/CPvumSLnXQoU39Aer7JfqBi6KrdMGF6RcblbWZze/O/fgq
/gDlNxt1oV8cchBtZDNbsxbCOnCr1MnjfXjs+Xy+Pmw+8zlTfb/03qEoilLo
I06CAsdaHjHGDudjUfSCfL2GTkbZJtv9OXl6DzP855rbAHf1BY7oN3hDhz3C
Fll2F5f1ZY7pFbyl257mH8V2P3f0eVL1Ul7Tbp+QVcwwbDfIJX7qCZnkkt4u
v3Oaer7w1b1JrpIWfodypsJ7e7Yrm/nGSba5zSwfPf8lH7LMvr0ui+gLP2fv
yVbWOMUOtczx2fNGucJhrjNBm/txWck0Q/YDucimHpfPuKhnyDoWwjvbR2UZ
k+F/Y6fLW3zig/2Xq/qrcNfniOkljIe/1R5kg3P2Uy7oXbznD1fcXnJTb2Eg
vDdn3Z6Qqyd5x28K3Xqp1pvp5weZbo/JCd9Z+J7CN8EBtWVaMw==
               
               "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl1WWYVWUYBdAZUunuRmmwKEmlMWiUkJYG6ZJQQglpCQnpDgUVle7u7u4u
6XJ9Dz8We7/vYebemXO+OxkbtqnyTWRERET6KBERIaf4510SmA+Yn+uDSWse
Yr6sdyG5ObV8Q/4iv3TtoGzMm0SxHynX2f8n+5GND8zrZVUe6Yu4qfckI93N
Z2RbkrDT7FtFTNXf46A+lBrkZYNdNR7ri+lBVKbZvc8hfRg1yUc0ojM9vBcO
68OpRX422lXnif4HPYnBDLu8HNFHUJtD5ibEYr25AJv0L3iq/0kvYjLTLh9H
9ZFc0buShq/Mh2VTYrPBXJDN4ffKM/0vbum9yMR35rOyHUmJ4Zc0Ru6yfyIH
kpt49pPCfbKfJfOT0O6Y+YU+hHTmn81X9W6kMKcN91GOC68n67h+RG8W7os5
jowavi7cN7nR9Qf6D6QyZ5dx5ET5oWtbZA2e66/kMJbot8PPQma+N5+T7UnG
bvNTOYg84f2YZ8sCHNdHUZej5ubEZZO5EFv1mrzQ/6Y3sZhjV5AT+mjqUZht
drV4qf9DH2IzN7x/TupjqE8R4hCXeMxzvRCn9LE0oCjxmW9fmNP6LzSkGNvt
avNK/5e+JGCBXRHO6ONoxDFzi3Av2Wwuzo7w3IQDy1LRj/N6h3A22WNOyEK9
KGf18VzTvw33nK/Nx2VL4rPF/FD+SA4+Mu+UdYiMfH0Qh8tl6p1wv3grPLP2
E8K9t78gO4b7Z5dCxpRj5V7XnsmfwjNv9054TTk5fA+ZyPXf9GIkMp8zv9SH
Rr7+bJpgvq53J6U5fTh3cnx4dmRj10/orcJ5MCeQ0eQoudW1R7I/OfnYvEvW
JQrLzXdlb94OP7/5ouwUXot95sT8rhfnvD6RJpw0tw5nim3mEuzW64XzwQpz
f5KwKPxOuaD/SlNKsseufni/rDQPICmLw3vloj6JZpQiWfhssi/BJX0yzSlN
clKQklSkDp9D/l9JLutTaEEZ0oTPFftSXNGn0pKy7LVrQHRWmQeSliXm0lzV
p9GKcuyza0gMVpsHkS6cPXMZrunTac0pc/ijk4jt5vLs1xuF54U15nuyD1nC
M2O+JDuTiv3m9OGc6mW5rs/ght6DDOH7m0/LNiQOP4dnYbTcYf9YDiC1XS4Z
V/4qP3HtQDgX4Wvs3gjPvRwRvqdc6/p9vS9ZGWzOEM6vXo4b+kza8CkZWWpf
npv6LNryGZlYFl6TW/ps2vE5mVlu/ym39Tm0pwJvscL+M+7oc+lARd5mpf3n
3NXn0ZFKZGGVfQXu6fPpRGWystq+Ivf1BXSmCtlYY1+J//SFdKEq2VlrX5kH
4fzSlWrkYJ19FR6Gs0M3qpOTXOQmT3gNf5T/B+wjA2I=
              "]]},
            Annotation[#, "Charting`Private`Tag$659293#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV1Hf0lXMcB/BbERnnhKSTldFOe6A9zGNmNIzqV9pp005TqFDoHDtCKTNk
ZaatRaKsIiIyymg4er3/eN3P+/N5nnuf+3yf772nFfVve3OxQqEwy0vF4oXC
uBKFwulslB9kAO2oRGXGO3YGn8kPMZD2VGGC+Zlskh9mEB3yOWaN2SUv5A5q
uWZVdaJ5RT6XH2EwHfPZZk34TX6FO6nGJLNKfCE/yhCuy/XMmvK7/Cp3UZ3J
ZpXZLD/GUObrL+F/eQnX59r6Zvwhv8Z7chfKMDXfQb2Gw/lYX4Pb5SpskR/n
bfkGSnOLfoF6KQU+ZSgfmS9Ve1A+72VU3pf7UZvzp7xeHcQi+X21iO0cn3tn
BL8wLferXst3lMqz4VZ2ssbxlWofdnAKXzEma8tZjk9Rq/ItX+rXqP2ZLS9W
b+SYPCOG57PNn1MvoxhL9cvUnpyY87PWagt2y6/zgdyVskzPGqvtOIK1+prZ
F3K1fD/5CYbxvP5yirNM3ylrLbdkj/wGd2c/ZY+YVedr+UmG05na2Q/mNfhG
nsMIulAnxz2iumo96tOAqVmbrIn8FCMpYrZZK/6S3+QeGjLNrCZb5acZRdfc
h1lr/pbf4l4aMd2sFtvkZxjNC/orKMFyfbfch9yGf7K/+FDuxgnM0C9S23Mk
6/Sr1L6cytlZG7V29oa8Vh3AXPkdtRPHZi/oX1Sv5BA2Zv+ywny52osfOSn7
g9Hs4qaspXpe7pt/9RvUwfzE4vy+ch4/UI7NjORXZmZvqB34nqPYxDDWO7Za
7UeFPFPGck7WXK2T98jr1IHMk99VO3NcztW/pLblUFbqu+dZyuezN2vAfdlD
+o4czQb9uXlOcl22y89yGy/rr6Ikq/Q98qzlC9iX63M/jZlhVi/3nf8bxtGT
Jsw0r581zX8E4+lF0+xHe7GZ2pwW+X7Oa8CO/OaYQG9a5lrmDbPW+Z0wkT7Z
T2YXsj//YzxAq1SzRvycvcYk+jLX7CIO5L+GWbROzR5iZ/YHk1mov5rDWK1f
ofbm5Dwr/Tz14uxr/tN/og7hIFtX2cg=
              "]], 
             LineBox[{1002, 706, 965, 870, 793, 664, 954, 859, 782, 723, 580, 
              920, 825, 748, 689, 647, 622, 581, 582, 583, 584, 585, 586, 587,
               588, 589, 590, 591, 592, 593, 594, 595, 596, 597, 921, 826, 
              749, 690, 648, 623, 938, 843, 766, 707, 665, 955, 860, 783, 724,
               973, 878, 801, 991, 896, 1008, 598}]},
            Annotation[#, "Charting`Private`Tag$659293#2"]& ], 
           TagBox[
            {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{1012, 1062, 1013, 1014, 1015, 1016, 1017, 1018, 1019, 
              1020, 1021, 1022, 1023, 1024, 1025, 1026, 1027, 1028, 1029, 
              1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 
              1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 
              1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 
              1060, 1063, 1061}]},
            Annotation[#, "Charting`Private`Tag$659293#3"]& ], 
           {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
            LineBox[{1010, 1011, 
             1009}]}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{7.989795918367345, 1.4999999999999432`}, {7.5, 
        6.500000000000014}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 7.999999836734694}, {-4, 4}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {910, -339.73835392494317}, 
      ImageScaled[{0.5, 0.5}], {360, 222.49223594996212}]}}, {}},
  ImageSize->{600, 300},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.716727092354904*^9, 3.716727113068643*^9}, {
   3.716727144844589*^9, 3.716727174700303*^9}, 3.716736277392425*^9, 
   3.716736415432905*^9, 3.716736543387568*^9, 3.716738316487472*^9, 
   3.7167383560316*^9, 3.7167384104184437`*^9, 3.716738468730589*^9, 
   3.716738516685821*^9, {3.7167385896338367`*^9, 3.716738649690236*^9}, {
   3.716738724448832*^9, 3.716738759351584*^9}, 3.7167388062508583`*^9, 
   3.716738941956616*^9, {3.7167389859758*^9, 3.716739022729508*^9}, {
   3.71673907797547*^9, 3.7167390929620523`*^9}, {3.7167392831067553`*^9, 
   3.7167393314339867`*^9}, 3.716739363461955*^9, 3.716739571425946*^9, 
   3.716739664980091*^9, 3.7171785554594173`*^9, {3.7171799890325317`*^9, 
   3.717180016677939*^9}, {3.719219559394701*^9, 3.7192195655161343`*^9}, {
   3.7192196510590353`*^9, 3.719219657173204*^9}, {3.719219706887891*^9, 
   3.7192197995231743`*^9}, {3.719219866999611*^9, 3.719219877932971*^9}, {
   3.71921996188056*^9, 3.7192199719009047`*^9}, 3.720265959719366*^9, {
   3.720266014702208*^9, 3.720266021579898*^9}, 3.720266064298045*^9, 
   3.720266098341382*^9, {3.720266876060837*^9, 3.7202668868263083`*^9}, {
   3.720267346398007*^9, 3.720267353193406*^9}, 3.720267497837612*^9, 
   3.720267620565652*^9, 3.720267807375223*^9, 3.720267869838238*^9, {
   3.720268000022551*^9, 3.7202680216662416`*^9}, 3.720268063718261*^9, 
   3.7202712062228518`*^9, 3.720272049417081*^9, 3.7202722372955017`*^9, {
   3.7202722742727213`*^9, 3.720272320655723*^9}, {3.7202723608413687`*^9, 
   3.7202724133250628`*^9}, 3.720272468689581*^9, {3.720273074789666*^9, 
   3.72027314346486*^9}, {3.720273276906127*^9, 3.7202732999664593`*^9}, {
   3.720273366894054*^9, 3.720273373693318*^9}, 3.720274690325465*^9, 
   3.720275014344183*^9, 3.7202750471741657`*^9, {3.720275174844777*^9, 
   3.720275184120682*^9}, 3.720275595618452*^9, 3.720275724200449*^9, {
   3.7202757549317617`*^9, 3.7202758050457363`*^9}, {3.720276204251873*^9, 
   3.7202762263113728`*^9}, {3.720276361770357*^9, 3.7202764533532257`*^9}, 
   3.720276484953886*^9, 3.720276539279367*^9, 3.720276583054062*^9, 
   3.720277001026289*^9, 3.7202773591344337`*^9, 3.7202774505399523`*^9, 
   3.720277493071691*^9, 3.720277850118176*^9, 3.720277940673861*^9, 
   3.720278078296158*^9, 3.7202781357509336`*^9, 3.720278223307621*^9, 
   3.7202784586568403`*^9, 3.720278749747459*^9, 3.7202787815685587`*^9, {
   3.7202788554161367`*^9, 3.720278865259988*^9}, {3.720278919090526*^9, 
   3.720278944214826*^9}, 3.720278999206168*^9, 3.720330937934454*^9, 
   3.7203311814720793`*^9, 3.7203325153383503`*^9, 3.720332628069018*^9, 
   3.720333678202715*^9, 3.7203338943752327`*^9, 3.7203342982942257`*^9, 
   3.720334365986559*^9, 3.79384593773635*^9},
 CellLabel->
  "Out[798]=",ExpressionUUID->"bcffe956-5e8c-4d7a-ac9e-79cbccff3529"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pnom", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]1", "[", "t", "]"}], ",", 
       RowBox[{"\[Theta]1a", "[", "t", "]"}], ",", 
       RowBox[{"\[Theta]1b", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "4"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prob", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]2", "[", "t", "]"}], ",", 
       RowBox[{"\[Theta]2a", "[", "t", "]"}], ",", 
       RowBox[{"\[Theta]2b", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "4"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GraphicsRow", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pnom", ",", "prob"}], "}"}], ",", 
     RowBox[{"Spacings", "\[Rule]", "4"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], ",", "Ju1", ",", 
   "Ju2"}], "}"}]}], "Input",
 CellChangeTimes->{{3.720275826704232*^9, 3.720275854064123*^9}, {
  3.720275979177361*^9, 3.720276164132737*^9}, {3.720331137782969*^9, 
  3.720331141213623*^9}, {3.720333586204318*^9, 3.720333595450593*^9}, {
  3.720337888614249*^9, 3.720337891548551*^9}},
 CellLabel->
  "In[799]:=",ExpressionUUID->"fa509ed0-e81b-4128-8d7a-cd1230683d28"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {InsetBox[
       GraphicsBox[{{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV0nc8lu0XAPAnlPtBeJ5bw3wyoyRvNN6GcwrJzogoUrRUCBWpUDaVSmSV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             "]]},
           Annotation[#, "Charting`Private`Tag$659527#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwdknk01IsDxafpWSqhLCGTJ4xXeUOi7Rf3m8lT6ZWtomXiGcSztqA6hDdC
VIpQVMJg0pBlRpKljDXL8MhWlkllp5f4kXh+v3vOPfecz1/3nnPV//CyciKT
SCTvJf8vDzoNNpcPhRqTSAa2o/9RN/qJruLdq8zEnDdZ6eXuEuNtjxKS8pUv
wPbPyVJC473xgKpmsB81ELWCS2kazpPG5g3teQ+UWXhLmdaP1P1hrBlFYS+q
RWA/z1bbt1Uc8wcd4x2oN2Gb66B/46IshlmtAoe426ghFxwSeiriOHOm5I5y
LIhbaw7PHqNAQFcprEiKQ7j5VHRg/EboaRg9m1K7B2Pu33aD36lIIttztFIT
MS7F8DPo3AJJUUjKMepDMEzZOePxenjR19JQYZMMF43MClrQNnhbMA+einuM
dL2YvHj2drzXDaPfUE6DUujiys5MI8Q+UirXOsnGYsxg8t0KAgdlnuwpTUrH
/SeyDvXNJuCP1xtOqHFQlfXsdKe5GdwZjLwwhye4l7C1f7jwADY2TtB+Ts2C
XNNf8UH0Q7jJXfuLJTUbZdLH77a/s4ApJS1tyCUHHYlmGXutrBBYdV/2lc0z
iAk5ypx2axhs17lhF5eLliPRRllrjyNZ4ci168oFGNbdL5I1Z+BKQ7zg2IsC
uLyMOrfwsz2OhfaRNU7yoLmeMvRU0wFS33yuFifxcfLbLVHTPkf4t8b6j6oV
gckp0Z4edIF11Hv+8/IiXI+pPD9DdQVtH/Uby+EF9LiqOa4ebhjIL/ShpBaD
uufN/ZdyHrCM6XI7TC1FZN7bEU9HH+iYa3BUqkuRLuWwLlbzHCSXu3/+5FKG
hidMy9XD53CmaCG3zKYcnns3YEXIBShsiqbZxr2CzJy2POuTH4Il87UjlAW4
pG1k7cW6is1mt8PzvAX4rNizz9kyCC2hXkPd1QIoZj8m4UMQNJfrZNF8K+GS
2SeYlg5B1Y80WmtLFeaKPcf511iQ+hpnqBZVi50dVjsMZyPA23oxbv+HWmj6
j7t+zb8Ohrf1jM/uOjzPDXa94hOJnDGZIsFgHcjyH3+fnIqC1WD4HjfTeiQp
PC9vko5GwvvLdN5CI2RZge3CKzHYq2qX1nO0CbOxud+HJmIwfGKHmCS3CZN8
hyO+TrHYMHrJkfurEDKZNLlRm7vwct2uRXonhLDz1BjTNB5rmTmZ7J0tuNdQ
VmLmkQhbu8c5k19aobw4+WCTVwomum1Wpqi0gUxPzigtTsE1hqSTNb0NZ80D
QkgrUpHv6KXCj22DYsIZQSQ7FdKeRqFXdrxFFZuiVfMpDZUhnSfEA9rR/Zxe
onA9A/pP14irSnYt7beg9B/lopZWad+g14VY+WqP2Odc2Of6FwfadaHGPpw3
vz4bN/i93v1PuvAP+Zzc2EA2Bsu53em/d2NU40AeB8/wsO1A7taYd5i7dFbB
YCQXqxaDT5lt6MVcu7ljSBgPCa7HGTq/9SI6xJi9pWLph6069ms8e2HR8lcH
bZEHY067Y3dJL7jbSN50fz6KOHG8QlofIohlmzM8CzFmPfrSvLEP1KjwRCf3
IhzNjH9zfrUI/keZi5pPS5B0OuSQs7oIU1tVHm3+WgLRWo8GW0MRtsSYSkft
LoVXgEmT0WkRaM6/+P5RV4oIq7EWCa4IY6e7NzHGy1Ayb9KVeOgD+sO8wt5o
vIKW5fhgReQAFHtuqT56VAGVq2a7XR4PQJ+kqeZSXwFZbnLkysIBBKw3uec0
W4E5SWuapWgAYroSX8RsBBCWF57v2fkRMkx15dZVlbisF7zw348fUfh27iE7
tAqNMvLyNOIzxCqzg9el1MKvcRcSpoagw+qo4xoLIU3jfayVHIZ7//wPkZ0Q
aTf0or6rDiNabNpZ96IQzYe0OxmmwwgMf12z+qkQW97In9eKG0bAazOLPpVm
9FZPpOftGEGXNSWmY74ZZq/Y0g2XR5f6M+2mmv/GuoI1PcuWTcCnMKggoKwd
fBG9vmnPP2jxmyxTyu/Da7cH6+1Gp5Bc4+XupfoJ36hGMlyPGexZUJDlpo+A
PJslu15rDqwT0cxUiS/YvmjPt86eR5NGtXCf1hTqWQaNVZsXob7s5OBTkxmo
RY/McsZJxC7Fyev+GXMYmentadMjE0LaHX7Smx9IGy6uk765nJC66rTB/Q6J
kKZkTAwM/ETIseVraDQyEeXKc07WFCcq6V0JO9KXE9NE1sDZqxJEnXxK7sJ2
MeKCvqBAsUKSMD2+okmJI070Zgsim9VXEvvXPrzZtkuS+O7Wmrjp8iqCoRtk
2VG9gtiyV2LBuViKOPFrD09i3yrCLEXdJXedNDGTrVh7ckKK8KOc2dh/SoY4
TPwo9r29xHu2tTwzlCVI/5cs8S8gDVbO
             "]]},
           Annotation[#, "Charting`Private`Tag$659527#2"]& ], 
          TagBox[
           {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwd13k8Ff/3B/DJ7l6ua0ukZG0hqSwlnBMKIbtQ1nYfSSihsiRLtmQXUpG9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             "]]},
           Annotation[#, "Charting`Private`Tag$659527#3"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7ZX64uKBl612ErouIb8VOR0WiPq3dUlusYfxGzk2
q3dKHoHzIyIXrv/w8Qqcz/2/McZd7j6crxr47sXh7idwfvk5S/sZX17C+eJb
BO8xMr6H87c9cj5z3uYTnH8oa6505JsvcP5XNVv+tbnf4Xymn6sFpFV/wflm
/xO2Ba/7A+efaTE5d0zrP5wvP+H1z5XvGBxg/Nff79+7asAE5y95tfsUXx8z
nM8nu/z9kycscH5P5ta0BSpscP43h9VPMurZ4fwSoyNbxA5zwPn31x3pvqjI
Bef/zroyW7OKG87XdmT/l7abB853X6SYvlGcD84vl41XehjDD+frvAnlvu4r
AOcL83/gOPILwWfZP3u98hxBOD/bZPdNTm8hOH+1Z9KCfd8Q/K+vpQSeTROG
87cGuzNPcRGB8+s9WudveYbgK971urG4VRTOtzJvmSJpJAbnx8id/8l4GcH/
eqr3UUGjOJw/gyWuJEhFAuH+e1sXMR1B8FlrG0MsCyXhfIaVcesfCUnB+UWz
1vcKHULw92p3cAjmScP5gl5FOk18MnD+Hd0Llyv3IPgb5tmrPImThfNj15sJ
yv5D8BtaFzbeWSUH5699ITubz0cezldqEfFgX4bgT5fn/vr/P4IPAOk/LUk=

             "]]},
           Annotation[#, "Charting`Private`Tag$659527#4"]& ]}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImagePadding->{{7.989795918367346, 1.5}, {7.500000000000028, 
         6.499999999999986}},
        Method->{
         "DefaultBoundaryStyle" -> Automatic, 
          "DefaultGraphicsInteraction" -> {
           "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
            "Effects" -> {
             "Highlight" -> {"ratio" -> 2}, 
              "HighlightPoint" -> {"ratio" -> 2}, 
              "Droplines" -> {
               "freeformCursorMode" -> True, 
                "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
          "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
          None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& )}},
        PlotRange->{{0., 7.999999836734694}, {-1, 4}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {0, 0}},
        Ticks->{Automatic, Automatic}], {147.48035907835967, -98.6782633137421},
        ImageScaled[{0.5, 0.5}], {290.96071815671934, 187.95859678808017}], 
      InsetBox[
       GraphicsBox[{{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV13c4le8bAHDrLEo4KKtjJUXyjSiV+66MQrIaSpLRoJSoFIVCKqMhSaQy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             "]]},
           Annotation[#, "Charting`Private`Tag$659576#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwdlnk4Ve/XxoUzIdNByFAZkqSSUpK1RCPSgFISJZrL0KAUUiik4ltEoaQy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             "]]},
           Annotation[#, "Charting`Private`Tag$659576#2"]& ], 
          TagBox[
           {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwdlnk8VP/3x20zZpGYsQ5KWVKEIqRyTsiSSKEolLL0aROptIgkCdEipSIi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             "]]},
           Annotation[#, "Charting`Private`Tag$659576#3"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7ZX64uKBl612ErouIb8VOR0WiPq3dUlusYfxGzk2
q3dKHoHzIyIXrv/w8Qqcz/2/McZd7j6crxr47sXh7idwfvk5S/sZX17C+eJb
BO8xMr6H87c9cj5z3uYTnH8oa6505JsvcP5XNVv+tbnf4Xymn6sFpFV/wflm
/xO2Ba/7A+efaTE5d0zrP5wvP+H1z5XvGBxg/Nff79+7asAE5y95tfsUXx8z
nM8nu/z9kycscH5P5ta0BSpscP43h9VPMurZ4fwSoyNbxA5zwPn31x3pvqjI
Bef/zroyW7OKG87XdmT/l7abB853X6SYvlGcD84vl41XehjDD+frvAnlvu4r
AOcL83/gOPILwWfZP3u98hxBOD/bZPdNTm8hOH+1Z9KCfd8Q/K+vpQSeTROG
87cGuzNPcRGB8+s9WudveYbgK971urG4VRTOtzJvmSJpJAbnx8id/8l4GcH/
eqr3UUGjOJw/gyWuJEhFAuH+e1sXMR1B8FlrG0MsCyXhfIaVcesfCUnB+UWz
1vcKHULw92p3cAjmScP5gl5FOk18MnD+Hd0Llyv3IPgb5tmrPImThfNj15sJ
yv5D8BtaFzbeWSUH5699ITubz0cezldqEfFgX4bgT5fn/vr/P4IPAOk/LUk=

             "]]},
           Annotation[#, "Charting`Private`Tag$659576#4"]& ]}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImagePadding->{{7.989795918367346, 1.5}, {7.500000000000028, 
         6.499999999999986}},
        Method->{
         "DefaultBoundaryStyle" -> Automatic, 
          "DefaultGraphicsInteraction" -> {
           "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
            "Effects" -> {
             "Highlight" -> {"ratio" -> 2}, 
              "HighlightPoint" -> {"ratio" -> 2}, 
              "Droplines" -> {
               "freeformCursorMode" -> True, 
                "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
          "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
          None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& )}},
        PlotRange->{{0., 7.999999836734694}, {-1, 4}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {0, 0}},
        Ticks->{Automatic, Automatic}], {442.441077235079, -98.6782633137421},
        ImageScaled[{0.5, 0.5}], {290.96071815671934, 187.95859678808017}]}, \
{}},
    ImageSize->600,
    PlotRange->{{0, 589.9214363134387}, {-197.3565266274842, 0}},
    PlotRangePadding->{6, 5}], ",", "1.2126056716434994`", ",", 
   "9.875813017294456`"}], "}"}]], "Output",
 CellChangeTimes->{{3.720276084935211*^9, 3.7202761649458447`*^9}, {
   3.720276204453774*^9, 3.72027622651727*^9}, {3.7202763619786053`*^9, 
   3.7202764535632477`*^9}, 3.720276485153318*^9, 3.720276539605111*^9, 
   3.720276583449856*^9, 3.720277001199926*^9, 3.720277359323015*^9, 
   3.72027745072923*^9, 3.720277493257433*^9, 3.7202778502535477`*^9, 
   3.720277940865529*^9, 3.72027807847731*^9, 3.720278135881226*^9, 
   3.7202782234921217`*^9, 3.720278458783259*^9, 3.7202787498593063`*^9, 
   3.7202787816800222`*^9, {3.720278855552013*^9, 3.720278865384345*^9}, {
   3.720278919219366*^9, 3.7202789443953333`*^9}, 3.720278999395275*^9, 
   3.720330938116983*^9, 3.7203311817522383`*^9, 3.720332515460905*^9, 
   3.7203326282477913`*^9, 3.720333598559786*^9, 3.720333683240123*^9, 
   3.720333894563304*^9, 3.720334366180068*^9, 3.793845937872723*^9},
 CellLabel->
  "Out[801]=",ExpressionUUID->"e22afe46-30fc-41aa-9b5c-4c28a9ad3f28"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"min", "=", "3"}], ";", " ", 
  RowBox[{"max", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"JudatNom", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"GetJuNom", "[", "\[Tau]", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Tau]", ",", "min", ",", "max"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"JudatRob", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"GetJuRob", "[", "\[Tau]", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Tau]", ",", "min", ",", "max"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.720334573101775*^9, 3.720334578689003*^9}, 
   3.7203346273685513`*^9, {3.720334736359582*^9, 3.720334750885952*^9}, {
   3.720334816364995*^9, 3.720334852131298*^9}, {3.720334903969157*^9, 
   3.720334996262151*^9}, {3.72033504723324*^9, 3.72033508426302*^9}, {
   3.720335116456571*^9, 3.720335146334271*^9}, {3.720335246077619*^9, 
   3.7203352743366547`*^9}, {3.7203353829996977`*^9, 3.720335400236702*^9}, {
   3.7203354305225782`*^9, 3.720335559912818*^9}, {3.720335608211179*^9, 
   3.7203356110238132`*^9}, {3.720335838362542*^9, 3.7203358825095882`*^9}, {
   3.720339150919155*^9, 3.720339263539083*^9}, {3.720339346449629*^9, 
   3.720339353492661*^9}},
 CellLabel->
  "In[802]:=",ExpressionUUID->"4b9c652c-bcce-4098-b54f-2c83155ea36b"],

Cell[BoxData[
 TemplateBox[{
  "FindRoot", "lstol", 
   "\"The line search decreased the step size to within tolerance specified \
by AccuracyGoal and PrecisionGoal but was unable to find a sufficient \
decrease in the merit function. You may need more than \
\\!\\(\\*RowBox[{\\\"MachinePrecision\\\"}]\\) digits of working precision to \
meet these tolerances.\"", 2, 804, 71, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845950900189*^9},
 CellLabel->
  "During evaluation of \
In[802]:=",ExpressionUUID->"2b7058fd-36d7-405f-9066-597c80b96957"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"JudatNom", ",", "JudatRob"}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "100"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7203391224514303`*^9, 3.720339131546545*^9}, {
  3.72033928081665*^9, 3.7203392847077017`*^9}, {3.720339395533732*^9, 
  3.7203395134441347`*^9}},
 CellLabel->
  "In[805]:=",ExpressionUUID->"41e0e72c-4680-407b-97cb-fe00633422a8"],

Cell[BoxData[
 GraphicsBox[{{}, GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQDQEcDqFXjC3+OL+3h/AFHApyWb8rJN+G8kUcJOtX
Vu1ZcwLKl3Do/P8v7vK/Q1C+jEP1L6WzkyuO7YfwFRx29Bf7Tpp6E8pXcriq
/qlV+Nd9KF/FwVT7s+O81If7Yfaf9WQxvrZMwAFm/8n10pdPCHI6wOx/5/Tp
r2QQkwPM/pkHG2Vy+37B7d9x3tftwIYv9jD7Dyx8axfm88keZv8/SV79WRqf
7WH2X+2/Nestxxv7ke5/AEfClZg=
    "], {{{}, {}, 
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6], 
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8}]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6], 
       LineBox[{9, 10, 11, 12, 13, 14, 15, 16}]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6]}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6], 
       PointBox[{1, 2, 3, 4, 5, 6, 7, 8}]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6], 
       PointBox[{9, 10, 11, 12, 13, 14, 15, 16}]}, {}, {}, {}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       0.012833333333333334`], AbsoluteThickness[
       1.6]}, {}, {}, {}}}], {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.854166666666667, -0.916290731874155},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->NCache[{{2.854166666666667, 10.}, {-0.916290731874155, 
      Log[100]}}, {{2.854166666666667, 10.}, {-0.916290731874155, 
    4.605170185988092}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->FrontEndValueCache[{Automatic, 
     Charting`ScaledTicks[{Log, Exp}]}, {Automatic, {{-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.5\"", 0.5, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
       FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.4011973816621555`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.6888794541139363`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.0943445622221, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.248495242049359, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.382026634673881, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.499809670330265, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.298317366548036, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.703782474656201, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.991464547107982, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.214608098422191, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.309918278226516, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.396929655216146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.476972362889683, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}}]]], "Output",
 CellChangeTimes->{{3.720339124942081*^9, 3.7203391339133177`*^9}, {
   3.72033928139977*^9, 3.720339285083642*^9}, {3.720339392562089*^9, 
   3.720339513869192*^9}, 3.793845952894415*^9},
 CellLabel->
  "Out[805]=",ExpressionUUID->"80d5b3e6-0f5a-4794-932a-b3a8e18d8b77"]
}, Open  ]],

Cell["Repeat for longer \[Tau]", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}, {3.7203308642211*^9, 
  3.720330867768689*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"179652c8-dd8a-4a9d-a0f9-e57824dedd11"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Tau]long", "=", "10"}], ";", " ", 
  RowBox[{"\[Tau]1long", "=", 
   RowBox[{"1.5", "\[Tau]long"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Theta]rob1", ",", "\[Theta]dotrob1", ",", "urob1", ",", 
      "x\[Omega]1rob1", ",", "x\[Omega]2rob1"}], "}"}], "=", 
    RowBox[{"ffRob", "[", 
     RowBox[{"n", ",", "\[Tau]long"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Epsilon]1", "=", "0.05"}], ";", 
  RowBox[{"Ju3", "=", 
   RowBox[{"GetJu", "[", 
    RowBox[{"urob1", ",", "\[Tau]long"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]3", ",", "J3"}], "}"}], "=", 
   RowBox[{"SwingUp", "[", 
    RowBox[{
    "\[Tau]long", ",", "\[Tau]1long", ",", "urob1", ",", "\[Omega]nom"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]3a", ",", "J3a"}], "}"}], "=", 
   RowBox[{"SwingUp", "[", 
    RowBox[{"\[Tau]long", ",", "\[Tau]1long", ",", "urob1", ",", 
     RowBox[{"\[Omega]nom", "-", "\[Epsilon]1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Theta]3b", ",", "J3b"}], "}"}], "=", 
    RowBox[{"SwingUp", "[", 
     RowBox[{"\[Tau]long", ",", "\[Tau]1long", ",", "urob1", ",", 
      RowBox[{"\[Omega]nom", "+", "\[Epsilon]1"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p3", "=", 
    RowBox[{"Plotit", "[", 
     RowBox[{"\[Theta]3", ",", "urob1", ",", "\[Tau]1long"}], "]"}]}], ";"}], 
  "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"robust", " ", "algorithm"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3a", "=", 
   RowBox[{"Plotit", "[", 
    RowBox[{"\[Theta]3a", ",", "urob1", ",", "\[Tau]1long"}], "]"}]}], ";", 
  RowBox[{"p3b", "=", 
   RowBox[{"Plotit", "[", 
    RowBox[{"\[Theta]3b", ",", "urob1", ",", "\[Tau]1long"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p3c", "=", 
    RowBox[{"Plot", "[", " ", 
     RowBox[{
      RowBox[{"GetJ", "[", 
       RowBox[{
       "\[Tau]long", ",", "\[Tau]1long", ",", "urob1", ",", "\[Omega]"}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Omega]", ",", "0.8", ",", "1.2"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GraphicsRow", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Show", "[", 
        RowBox[{"p3", ",", "p3a", ",", "p3b"}], "]"}], ",", "p3c"}], "}"}], 
     ",", 
     RowBox[{"Spacings", "\[Rule]", "4"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], ",", "Ju3"}], 
  "}"}]}], "Input",
 CellChangeTimes->{{3.720331035544732*^9, 3.7203310714690647`*^9}, {
   3.720331193262847*^9, 3.720331195643317*^9}, {3.720331225740974*^9, 
   3.720331490372555*^9}, {3.7203315678704643`*^9, 3.720331603485632*^9}, {
   3.720331652593066*^9, 3.720331685854157*^9}, {3.720331730749127*^9, 
   3.720331798281282*^9}, {3.720331833156501*^9, 3.720331856056624*^9}, {
   3.720332448777392*^9, 3.720332455432267*^9}, {3.720332716593306*^9, 
   3.720332716709425*^9}, 3.720332759555141*^9, {3.720332824018005*^9, 
   3.7203328732304688`*^9}, {3.720333557925568*^9, 3.720333577219433*^9}, {
   3.720333870011853*^9, 3.720333873377652*^9}, {3.7203339671779747`*^9, 
   3.7203339752883472`*^9}, 3.7203378999179897`*^9, {3.720338319208435*^9, 
   3.72033832722766*^9}},
 CellLabel->
  "In[806]:=",ExpressionUUID->"75282c41-0878-4407-87fe-e544d21b31b9"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"10.07983189152362`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 809, 72, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7938459541780443`*^9},
 CellLabel->
  "During evaluation of \
In[806]:=",ExpressionUUID->"bc9adfa1-fbf3-41dc-9172-8657e814b311"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"10.07983189152362`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 809, 73, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845954182489*^9},
 CellLabel->
  "During evaluation of \
In[806]:=",ExpressionUUID->"35aa9374-25bb-43e1-b15d-ddf6a3383425"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"10.06043252981515`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 809, 74, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845954186314*^9},
 CellLabel->
  "During evaluation of \
In[806]:=",ExpressionUUID->"565ea7f3-c02c-4146-b2b3-082c19900543"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 809, 75, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845954189946*^9},
 CellLabel->
  "During evaluation of \
In[806]:=",ExpressionUUID->"4ea95c05-53f7-4d3f-a404-3f7697debc8c"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"10.069964153098299`\\\", \\\
\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 810, 76, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7938459541939907`*^9},
 CellLabel->
  "During evaluation of \
In[806]:=",ExpressionUUID->"c971fa8e-b2cf-4752-9dde-00b9807bbeba"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"10.069964153098299`\\\", \\\
\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 810, 77, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7938459541977663`*^9},
 CellLabel->
  "During evaluation of \
In[806]:=",ExpressionUUID->"47c0a8e5-21c6-45db-929a-4b8685c418e1"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"10.077910250786147`\\\", \\\
\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 811, 78, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845954201713*^9},
 CellLabel->
  "During evaluation of \
In[806]:=",ExpressionUUID->"6c759208-ab24-4678-b8ae-8791ee26ea5b"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"10.077910250786147`\\\", \\\
\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 811, 79, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845954205325*^9},
 CellLabel->
  "During evaluation of \
In[806]:=",ExpressionUUID->"2fef500d-fb58-40d1-a268-9726bd517134"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"10.059387451237352`\\\", \\\
\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 811, 80, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7938459542626743`*^9},
 CellLabel->
  "During evaluation of \
In[806]:=",ExpressionUUID->"e6319dab-2295-4043-9e5e-62cfc40ace21"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 811, 81, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7938459543187037`*^9},
 CellLabel->
  "During evaluation of \
In[806]:=",ExpressionUUID->"1ada464d-88e6-41ad-96b4-3ae38c472cb3"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"10.04473200891741`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 814, 82, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845954424941*^9},
 CellLabel->
  "During evaluation of \
In[806]:=",ExpressionUUID->"1c8d6a6f-53c1-4bf1-90cb-bdcfbf928b26"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"10.04473200891741`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 814, 83, 24566843885982714760, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793845954452127*^9},
 CellLabel->
  "During evaluation of \
In[806]:=",ExpressionUUID->"d3d21975-9f63-4a6c-911e-d18ad99f27a1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {InsetBox[
       GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJw8m3c81f/7/22OvTfFsUckGZHnRUhIRYPqnShtQlJKJVmVJBWlISUjKqMy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           "], {{{}, {}, 
             {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
              None], GraphicsGroupBox[{
                PolygonBox[{{1429, 1433, 801, 1229, 1107, 1009, 934, 881, 
                 1282, 1160, 1062, 987, 851, 1259, 1137, 1039, 964, 911, 802, 
                 1230, 1108, 1010, 935, 882, 852, 803, 804, 805, 1231, 1109, 
                 1011, 936, 883, 853, 1260, 1138, 1040, 965, 912, 806, 1232, 
                 1110, 1012, 937, 884, 854, 1261, 1139, 1041}}], 
                PolygonBox[{{1096, 1434, 1432, 830, 1253, 1131, 1033, 958, 
                 905, 875, 831, 1254, 1132, 1034, 959, 906, 876, 1278, 1156, 
                 1058, 983, 930, 832, 1255, 1133, 1035, 960, 907, 877, 1279, 
                 1157, 1059, 984, 931, 833, 1256, 1134, 1036, 961, 908, 1292, 
                 1170, 1072, 997, 878, 1280, 1158, 1060, 1333, 1211, 985, 
                 1316, 1194, 1359}}], PolygonBox[CompressedData["
1:eJwV0b1LFHAcBvCfaeVYQWnekkvDaWpeJQhaYBJIKAnhcHe+XHutnS/pH6Bt
eZcu5VCLlJYKDkEQOFimi6WpaGO2mRm9qH1u+PA8z/d3g96Vpu613j0SQshj
jMzREIY5XRDCfH4Ijyhj2Y7zW39BmjjlfHJP8Ed/STcJdtzuc4b39jAX+Gwn
+atP0EOSH25pivhgZ6hgxW7nnz5JL8f8jYNuUTbtdnb1bopZsM/5zDP9Oln7
RO5/0y/xzY7aE3ozlfaq7GBfr/I2o7/SS/Qn+k1ZL+vkO9km+7wfl0N2kyyT
NfKNvC23vJ+X4/Yt2SQb5Hzu+5Qd3n/qPdywz8qYnJUfvZXqz/VGrulz8rH7
ST2jX6ZWfyu3c7+VPqm3UGV/kZ0c6K+JeH9qX+WBXWg/1Mv5aneyp/dSwqI9
wimfy9pX+G5fZE3v4lCfop8ufrn1EWHJHqWadTtFYNoeIEWMDbc75DFj/wd3
lVRD
                 "]]}]}, 
             {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
              None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwVzzsvQ2EAh/EX7YgEAwsxCLWISiSSiqQSSRMSYehl9AEYUL4CJtoaWVhc
J4lBIpG4dHQZMWJyGVxGvzM8eZ7/++acnNM5Mzc1WxtCqME8KvEQNrEUC+EL
hboQlnGIPxScPaBXv2FAV9DombJdRYtdxCfy9jMSeg3x6N32sN5Gm31g/yJv
3yOhJ/g4avev9rke0kkuo0GXnOf40h7hUZ7gXe7gG/fTfGonuZnHeJE/kIv+
x67qNGd4kve5i5/cn+lB3cMZXuUYF91d6JRO8RZao2edn+g+/RN9n75Djx7n
o6jdvdj9uoR6e8NO6x2029d2k17AO7L2I7r1Cuqi/7D38I2ss1t063Vc4R8F
GzmU
                 "]], PolygonBox[CompressedData["
1:eJwVz7tPU3EYBuBDL4o4oltBKgOLlZhUWhQJTQyaNCHQGCYmAW+D/gdgwQsb
OoF30UUGFhgUUBMTEwYmBR0B247qDF4Snt/w5H3f8530QPryrdLNWBRFdcwy
k5Sci0dRFzeY4gP1CZsaZ+05vpO2J/nPdfs+7zkYNlXO2L/p1J9w1Dde2t9o
sSf4xzW7Rrv+kMPeu2cX9Nc02av2gfAuFTrtAblExv2X/Sn8jXpePuaI/sLz
Nb2gX5B9cl62yk23S3LFzspj8qIsy79cdR+y1/XzsihLckG2yar7oPxo5+VJ
WZQPZIO86/5Z79Z75CtS4Xuev9VP6cnwHX6E3/C8Xy5ywu2nndMf0Wg/t3v1
Nxy3N+xm/TZ/uGJXyOjTHPLOHXuZRLizQ85+xlea7HH2GLUneUc8bLbpsJ/y
hZQ9xi4j9kT4X4iFzRan7SzDlNkH53tK/g==
                 
                 "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
             TagBox[
              {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6],
                Opacity[1.], LineBox[CompressedData["
1:eJwl13e8zmUcxvHjGElWZvbeeytkNey9Z4kWEm0qyiYzyii0s/feZO+9VSot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                "]]},
              Annotation[#, "Charting`Private`Tag$669351#1"]& ], 
             TagBox[
              {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6],
                Opacity[1.], LineBox[CompressedData["
1:eJwV1GWYlFUABeChUxqlYQHpTmkQlTLp7i4fSklJkVJCGiWVbqRbQQSkW7pR
QukG3/vjfc4595udndmZb6Oaf169c7RIJJIoeiQSFSMS2RczEqnBXX0uXYge
KxIZ5iwbp+0a3NS7kJgd9mgys9+uyT19Hl2pSRay8jYHXK/FfX0+3ajFLWdd
ScJOewzZOGjX5oG+gO7U5razbiRlgtf4u7OxZOeQszo81BfSgxgeM9xZds7Y
dbijdycZu+wMHvOT/i7j7Dfs7/WCXLNz2Ev1D8lhH5Z1eaTnd221vkhPpU/X
Swf6r/IL5zH1EXoVmUMWk5vk2fC30Rfpn8oq4TXI3bK+rOv6v3oPPrCTy0Jy
Xfi85B+uZ5Q/2x/JirKc3BleX3gPrieS48PPUULfKq87z6kvCz9HTvuIrMdj
fTGpXZ9hl+FLO5Y9MjyWc3Y9/gvvjxTstseT2OMm2IW5YefiaHg/PNGX0JP6
3A3PzUQ/k1LucTaB3ByzG/BUX0ovGpCH484b8kxfRm8acs9ZT95krz2RvJyw
G/FcX04fGnHfWS/e4k97Evk4aTfmhb6CvsT2Gkc5y8V5uzEP9N6kYp+dyWPm
6u8x2U5iT9SL8Hf4W9jL9Y/Jb5+STXipF3Btjb5ST6PPDN83WTZ8BvK38N2W
/VyPI7+1q8rcsrjcHO4veSHcP3Kx/ZmsKivKPeHvKZu4/lDvQyU7dfis5Hq5
37UofZ7+PuXD/SWnOE+qT9KLUlLfJv8Jn5W+Qv+EAvZfsimv9FWkdX1W+F7y
lR3X/k7Pw0W7KY/0vqThgD2VZB43Odwr3LQLclpvxmv9F/rTjMfO+pGWg/Y0
CnHGbk6E1fYAmlOYs85aEI014bP3+wbKFhShKOdca0l01tqDaMmT8F5IxyH7
B4px3m5FDNbZg2nFU7s/6Tls/0hxLtiticl6ewjxvI7Rdl4u2a15pg8gA0fs
zB4zP/xPYLqd3J4SvgfcCveIvTL8T+Ed+6JsQywKurZWbnCeTp8dPmfK6jvk
187j62P0ajJfeA65RdaWl8P/WrnEri6rhe+73BvuSdnG9ef6QCrbGcP3X26Q
NeVR17PIBeE+kJVkBblLznAthT41/E5K6dvl7XAf66vCd5oS9iXZlthstNO7
Pic8F0PtBPbYcJ9xxW7LC30QmThmzySlx00Lz8kduySX9XbEYZP9De14aQ8m
iuP2LEpxxW5PXDbbw2hPacowOdzH8qrrHYjHFns4HSjHNWcdic9WewQdeWUP
ITMn7NmU57rdiQRss0fSidfhMyQLJ+05VOCG3ZmEbLdHkdDrGhfuW67anYk4
G2pnDfe6vlGecp5VXxjuc1lZ/g+5mgR9
                "]], 
               LineBox[{1224, 1369, 932, 1302, 1180, 1082, 1007, 834, 1257, 
                1135, 1037, 962, 909, 879, 835, 836, 837, 838, 839, 840, 841, 
                842, 843, 844, 845, 846, 847, 848, 849, 1258, 1136, 1038, 963,
                 910, 880, 1281, 1159, 1061, 986, 933, 1303, 1181, 1083, 1008,
                 1326, 1204, 1106, 1349, 1228, 1373, 850}]},
              Annotation[#, "Charting`Private`Tag$669351#2"]& ], 
             TagBox[
              {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
               Dashing[{Small, Small}], 
               LineBox[{1377, 1427, 1378, 1379, 1380, 1381, 1382, 1383, 1384, 
                1385, 1386, 1387, 1388, 1389, 1390, 1391, 1392, 1393, 1394, 
                1395, 1396, 1397, 1398, 1399, 1400, 1401, 1402, 1403, 1404, 
                1405, 1406, 1407, 1408, 1409, 1410, 1411, 1412, 1413, 1414, 
                1415, 1416, 1417, 1418, 1419, 1420, 1421, 1422, 1423, 1424, 
                1425, 1428, 1426}]},
              Annotation[#, "Charting`Private`Tag$669351#3"]& ], 
             {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
              LineBox[{1375, 1376, 
               1374}]}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxd23k8ld8XN3zzPM/HmLkyJqUoe5FSiAaJkqREQqJUUgmhkkoDqWgQRYTK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           "], {{{}, {}, 
             {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
              None], GraphicsGroupBox[{
                PolygonBox[{{39, 43, 619, 1047, 925, 827, 752, 699, 1100, 978,
                  880, 805, 669, 1077, 955, 857, 782, 729, 620, 1048, 926, 
                 828, 753, 700, 670, 621, 622, 623, 1049, 927, 829, 754, 701, 
                 671, 1078, 956, 858, 783, 730, 624, 1050, 928, 830, 755, 702,
                  672, 1079, 957, 859}}], 
                PolygonBox[{{914, 44, 42, 648, 1071, 949, 851, 776, 723, 693, 
                 649, 1072, 950, 852, 777, 724, 694, 1096, 974, 876, 801, 748,
                  650, 1073, 951, 853, 778, 725, 695, 1097, 975, 877, 802, 
                 749, 651, 1074, 952, 854, 779, 726, 1110, 988, 890, 815, 696,
                  1098, 976, 878, 1151, 1029, 803, 1134, 1012, 1177}}], 
                PolygonBox[CompressedData["
1:eJwV0EtL1GEcBeC3DIRAcGHXjaldvCzNXWmSltWmXJZgmbMpSBeN5mXUQFCD
CkGkaBEFM04z05dovNUHSHfpVJvc6CbyUvb8Fw/nd87rMDgVXT3tjw6GEA7w
nhqq6SwKoYxvHuOUHwohqV/mj54nSR+nvKXsLWzr86S4YP9ku8sR1mz9VNjn
9FZ29AXmuGjP2+5xlHXbEyrtaf0Ku/oiN21f9cfUkLY12ubdXRzjgb4pX1Dw
fltfc49QH31W35GvGPBepX9wX2XQHdizd8tftlk5KSdkCe9Y8n5LrthnZFw+
lcW8pVbvlb/lGzkjn8uy6PeMvs/nm+SCfVrelwlZxHH3Q7klX/LMXcp3n7kj
122jjLsPc94dl7vydfQ/+LvTesbdxl89pm+4p1jW2/VVdx91ZGyXbIvubk7w
w9ZhK7jHaGDIdsaWdV/jn/6ZLM3R72KLcZKftmHO2nP6dfb1L+RIcM7bR/sN
Av8BalRWKA==
                 "]]}]}, 
             {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
              None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwVzzsvg2EchvHHIRKJxKGjQ2LRjpgcBocdiQUJhlpYNG0tgkQiIZJKJE00
kRh6+By0vgImWisLi+PE7x2uXPd9P+9/eAeTqcXt5hBCE7KII4FaSwiTrSFU
PN7iG7O2CgbsO/qofIBnrNgatpi8jiombGVbQs7iAQu2mu1EfsWG/qXPyGX0
61m9IP9Gd/oIt/MR9uUGluW670rciVOc2Qv8zlvcw1fcHN1hTT/nGx7nkvsK
x5BD3n7Jn5ziOLfxITJynu95nqtuO/g4wvaCZHRr/5N35WkuoS+6t1/IP8jo
w7yHOpb0J+85+Q2bejev4hpjetH7kJzGHeai/7B9YEovoteW1h/Rpf8D0jU9
Aw==
                 "]], PolygonBox[CompressedData["
1:eJwV0LtPU3EYBuBTWtSEhISBCRHZaG07qjOCLCBYcRQTBy5e4yIYkkItCqGJ
QROSRohxcqMthT9CbQvKpo5eUVlwcNHE5wxP3u97f+eW033tTuZ2UxAEEYrE
SbCofMQ2exyNBkGGbdKxIHio+8lJ+w0aDOi3dO84Yr/IFin9gu6sOc8Xrup+
6LrM16lzXlfVpc33+chl3VtdwXzAhL1ZjlAlac87XzP/Y9p+RraE38gD82fG
zPuua5MFnuiK8re8JU/I5zJGlin7U1mT/XLTvS9lO49Z1a/LP/KuTMkX8lj4
Tmbsq/KDHJW77m+VSyzrfjEevk9G5CzD5k1Ohc9w/TPzX+7ZT8scn7hi/+58
xXzITXunnOQNffaK82T4P3jPJd2OLmq+QIWELqf7xvHw3/Kac/qyrkGTfYgy
cf287isd4ffzil59SVcnYh+kRI9+Tpdlgxr/Ab7tTgU=
                 
                 "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
             TagBox[
              {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6],
                Opacity[1.], LineBox[CompressedData["
1:eJwl1Xfc11MYxvEn7UF7aFBpau+0NBSVaFFCS3tSVKhEUdHQoFJpUKJo2dpT
2lN7atFGtL3vlz8+z3Vd9znPd5xzn+8vT9uejXskSkhIaH9XQkLoZn/qopF8
WK5Iv5bb0Pfk3HSK3IKWonXoKvqksZT823x2PMz/RNerF+e/iBqKyxdoF9zh
56Gg8U/kinhRziqP4wthtywmbOHr4Qg/Ag2RysA7ajnws1wCF/mu8SL4kryE
xNgq18dRfiQaoSSSICm2GXscx/hRaIxSuKTWDYnwldwLybBdboDj/Gg0QWlc
VuuOuzBf7o3k2CE/gRP8+2iK1J5/qFpObJDL4AofG5IYC+RC5nzKP4SX5Wzy
eL4wavHL6Z64N/9V1OI+/C80hfrO2Bs0VvtNfoh+I4/h8/BT+WdpafooXZ3o
/154yngaOkx+muai1ekS2i6uH+tN58otafVYX7qedqJljf/J90QTOQmtQr+n
C40V5mfxlfCKfK/8Af8gfo21kOfzjyClvIs2xEl+LPIa/1guE88n3y0P5+/D
Rrkc/op+QlIskvtEz2B39DdO8ePQDOXxt9pLSIbFct/YI+yJ9cNpfjyao0Ks
T9wXv8Y74gz/AZ6Jc4Orar2QHF/L/XAP9spNcZb/EC1iX/CPWu/YN3wjv4q0
2Cc/hd/5CXg2ruN931W7H5vkSvg3eiTWC9/KD5ozm6+M1+Ts8od8EeyVy8oL
+NpIJ++PtcQfcT1j3/IT+Qf4aXxZPBfPFN8CPjdq8Evp5jhP/Dy+Fa0R54n+
TDvTysavxV7Hu8upaFX6A21LvzNehH4W96BVaF26lnagrxvPQSfIzWnR6A26
gu6L/eYX8nWi3/mNNL36AdoM5/hJyGdsulwOz8vp5BF8HmyRq+A63wep8b3c
HznNmygXw345Aw7Gs+A8/xFaoioy4pD6M7jAT0YrVMMNtb5Igx/kAciEw3IL
XOSnoDXSu+dItbzYKj+Mm3w/3I0f5aLmzIm1xEA5lzyJL44D0dfyojjbyCwf
ifOOS3zlWHd+Kp+fn8GXx2P8Gtom3pMfFWtIH6A16TK6Lb6P/Jd8a1qTNqAb
aJf4Hhi/xb8avSvfQ6vRH+kL8dtgvBj9PPaBVqP16Drakb5h/D76UawjLRF9
SlfSg3H++MXxrPFd4DfRLOpHo39wmf8YBYzNlCtEn8XeyKP5fNgu18DtOB9I
iyXyINxv3mS5JA7JWXEsnhVX+Gl4IfbOvPfV8mOHXBN3+NfjTGGp/GZ8t3Fc
bok/+eloh1rx7cOJODf4i5+B9ngkzmz0ffRf7C1+i/XG3/xMdEDtWCucjD3D
Vf4TdEQdxA9o/zgPWCa+Fe+HU7Em+If/FJ3wKBKZP0A9A5bLg5Ebp2Pv8C8/
C52R2dwxagWwU34sbqc2UM6IFfIQ5MEZuR2u8bPRBVnMHatWELvkukgc+y9n
wkp5jh/pt2lenFVrj+v8Z+iKekjifwZFj2OV/E58t/B7fD9wI66DbqiPpOa/
GT2D1fLQ+Dbgj+g/3OQ/R3c8jmTmv6WeFWvkYXFmcE7uhFv8F+iBBkhu/mD1
bFgrD49exHm5M27zc9ETTyCF+UPU78U6+d3oZe/9HyQUGZE=
                "]]},
              Annotation[#, "Charting`Private`Tag$669399#1"]& ], 
             TagBox[
              {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6],
                Opacity[1.], LineBox[CompressedData["
1:eJwV1XfYlmMch/GnvWiotFPR3tGgPVVKO5poUNoooYm20LJbmtrax0GlqS0t
GjQUSVHakXx+f5zH9/c9r/t+nvce1/Pm79Snee8kiUQifdJEogeyJU8kpiZL
JCrjkv4VGnH79b4oiKlcee4rcxukxxGuJ7Lz0/QquKx/jWnohd7ogxyOmW69
Kv7W12E6KvBfc22RAUe5vsjJz9Cr4Yq+HjNQkV/HtUNh15BRHuP7IZe1mXp1
XNU3oDF3QO+HQpjJVeLWm9sjE7rpf8p3cNz6U/pP5jdQBi/pN+UHMVvPrX9u
roHXzHflNb6T+Zx5ZGC+B9/wT8qD3CT5khwmU6KwuY+8Jj+Rk+JvkJkxO77D
uY/KDfz7soMcJJPG88J9enf5l/xQjpdjZIY4N67B+U/Ln+M8vGVOg7Lml+Wt
OC9mx+XRZ5lr4rreWf/dPAob9Sb6oTgWRTCLeyyuz9wRmfEz14Y7YR6McniF
yxvXY66FG/omzEZlfmN8nuf4jMyCE3x/PGBtjl4bN/XNmIMByGdtLl8Ht/Qt
mIsq/CbuWWTFSe5V5Ofn6XVxW9+KeajKb+aew/04xQ1EAX6+Xg//6NvQlDsc
14OimM9V47aYOyEbXtQvyXdx2npb/aR5CB6Oc/Xb8qN4b6w/qH9hfhyvmxP4
l+8iz8f7JkfHM5D3xruNb603kz/wk2V/OVymiv2FYrFn5XX5qZwsx8sscT/j
+5xfXW7lJ8jO8axkMmQ395CX5XsYa86IX5zTTp7ihuJtc1o8Yu4v/5EfxzU4
7iF9gbk+7uhd9T/ivcR2vbn+o3kAimMBV4PbZu6CHDjDtedOx15B+diLXEFu
obkB/tN3YCFqxn3huiInznKDUIhfpDfEXX0nFmEwCltbzD+BRDxTsYtfjCEY
iiKOWWKtEZJgN7cEtfjt+vPIhV+5YSjKL9UbIyn2cEtRm9+hv4Dc+I0bjmL8
Mv1JJMNergV3xPwqSmAZV4fbae6GPOip/x2/CThnvUM8o3gPUCHubbxH8ZuC
N60X1780N4n7aE6C5PH3ywvxnDHanB7fOb6lPMpNkQPjM2Tq+D1GSb2fvCE/
k1PifZdZY0/G9zi/rtzFT5Td4/2P74v/Ecir95JXYh/ICXKczBS/N87tKM/E
d2KEOR0qxv2Qd+KdxluOK6EvNzdFiri3+sX4LOyz3ko/FvsMpbCcq8ftjn2K
B3Cee4Y7G5+JSvFucyW5FeZmSInvuRV4nN8TewT58Ac3AqX4lXpzpMJ+biVG
YlQ8Z+/WaFnacaust0BqHOBWYQzKWFvNtUQaHORWoz6/N5458uMCNxZl+TV6
K6TFIW4NGsQzjHuMArjIjUM5fq3eGulwmGvNHY99i9JYyzXk9pl7x143p8CD
0eXV2Odyovwf1toNFg==
                "]], 
               LineBox[{1042, 1187, 750, 1120, 998, 900, 825, 652, 1075, 953, 
                855, 780, 727, 697, 653, 654, 655, 656, 657, 658, 659, 660, 
                661, 662, 663, 664, 665, 666, 667, 1076, 954, 856, 781, 728, 
                698, 1099, 977, 879, 804, 751, 1121, 999, 901, 826, 1144, 
                1022, 924, 1167, 1046, 1191, 668}]},
              Annotation[#, "Charting`Private`Tag$669399#2"]& ], 
             TagBox[
              {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
               Dashing[{Small, Small}], 
               LineBox[{1196, 1246, 1197, 1198, 1199, 1200, 1201, 1202, 1203, 
                1204, 1205, 1206, 1207, 1208, 1209, 1210, 1211, 1212, 1213, 
                1214, 1215, 1216, 1217, 1218, 1219, 1220, 1221, 1222, 1223, 
                1224, 1225, 1226, 1227, 1228, 1229, 1230, 1231, 1232, 1233, 
                1234, 1235, 1236, 1237, 1238, 1239, 1240, 1241, 1242, 1243, 
                1244, 1247, 1245}]},
              Annotation[#, "Charting`Private`Tag$669399#3"]& ], 
             {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
              LineBox[{1194, 1195, 
               1193}]}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxd3Hc81l/8N3B7b8Jlb5lJRRHnnbQQDUSbUlqSJNIQQiURpVQ0jFREykgc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           "], {{{}, {}, 
             {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
              None], GraphicsGroupBox[{
                PolygonBox[{{40, 44, 639, 1067, 945, 847, 772, 719, 1120, 998,
                  900, 825, 689, 1097, 975, 877, 802, 749, 640, 1068, 946, 
                 848, 773, 720, 690, 641, 642, 643, 1069, 947, 849, 774, 721, 
                 691, 1098, 976, 878, 803, 750, 644, 1070, 948, 850, 775, 722,
                  692, 1099, 977, 879}}], 
                PolygonBox[{{934, 45, 43, 668, 1091, 969, 871, 796, 743, 713, 
                 669, 1092, 970, 872, 797, 744, 714, 1116, 994, 896, 821, 768,
                  670, 1093, 971, 873, 798, 745, 715, 1117, 995, 897, 822, 
                 769, 671, 1094, 972, 874, 799, 746, 1130, 1008, 910, 835, 
                 716, 1118, 996, 898, 1171, 1049, 823, 1154, 1032, 1197}}], 
                PolygonBox[CompressedData["
1:eJwV0DtPUwEYBuCjlsVoASVhIDEhYWirsKAgEHRUN0SMN5SEqCMlAbwssDDQ
qiAKiYmXxBqSxmgciEOhFvwT9uLlB4AbF2UBnjM8ed/vPT1p2sbBZO/QwSAI
DpAhQZyRQ0EQY8PDFK2RIMi5r3GEoi1HmtOeLdmuc5SSbYke+w/3KHE2bU84
Y1923yBK2bbMZXvRPUaCLdtT2ux5902qqdju2tb0KbrJ23ptJf0BJxl3R8jo
254P6Zv6Cy6E77qjfNKfed6uf9NvMa3XUaM/krvyo3wjX8tGvvLTe/fkuj0r
U3JeNrDIOfekPMwXsu73Mhb+n+H3ef+KLNsX5EM5K+s5pU/IKj7o72QT/7yT
lFu2l7zST3BRT8lqPoe/wefO6gW9n1oeu/fkW355ft/9V09znoKtz1YJfzfN
/LcN27b1OS4xY+uwrei3OcZv2wpXw/8l/C5a2LE9p9O+6r7Dcf7YVpmly7Pv
tgHq2AfBrVW3
                 "]]}]}, 
             {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
              None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwVz0srhGEYBuDXjIXjSlkoRQ7DymGJJVYO5bQ3ls4UG1YaYyOUUqRGqSlT
ymIOv4MZfwErjC3l+hZX9/3c37yL6Uxuzm3EQgg17NJHP5V4CLO1IZR8fKXR
vUSJYfuJbVK/4Id1W9WW0HcoM2Mr2sb0NB+s2Cq2G/2PfXeDXKTIkDvte05v
jjoTeru84lyvsqZ/+11BdnHLnT0n4xzS636SrdE7tt338kVOy4L3JZkgQ9b+
KOs5YtTdJi851rPyXSZl2dsOeR2x/bIXvZUt8pQFvcBg9N7vH/SmqDOun/HN
qvvL94we0w/o0bd4Zsqd931ET/HGcvQ/bHX6PHkGbCnbJ93uf7aTO+M=
                 "]],
                 PolygonBox[CompressedData["
1:eJwVzrtPk3EYBeAfanRwkaF4gcRIwqAOeBu5tB2VyUFAFgUUXDDq1oLA4EIh
JEUuKqEJARISg4YwuQkt9I9QCwpswigggk+HJ+e85+vX9krr8/tdJ0IIJUxw
jet8ML4nzzblJ0N4Sp74qRDe2Y654+5lgxb7mm2LS+4nrBGzT9ga9HH2eWU7
st3WX7POQ9uqLa4Pscsz26Yto5foSS7q7awSdY97/kkv1VPc0y8X/yNj+h4v
9X8+VyUzzNo+yjP0c8u9KC+Qpsc9JwuyWea8+0VeZZp5+2d5ljfE3Euyovib
DLrn5Y7slL+8XyknmbIFmSj+nh6Rw7TpOeqL3+HzC/o5fYC7+ih/eOE+9HxG
P633cVPv5gdN7qznUT3FbzpsP23n9Vay1NlGbX+54U7ynUb7im2DMvdjVqi1
v7UdUO1O8I0H9mXbOhH3I5apsY/Y0nylwH8fjFLG
                 
                 "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
             TagBox[
              {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6],
                Opacity[1.], LineBox[CompressedData["
1:eJwl1nfcTnUcxvHHllWUkS0iyUo2UUZGNmVURlmRlZGZooyiSdmjaBhlpuy9
dwvZmzKyler9ffXHx3V9vuf33M99zvmd88jTpmvDLokSEhL6Jk5IiDzonyZo
x0/yunI97yVH85JyNu8iK8jn5F7ZwLFs+of6A/EZ+ja51byqvlSvjaI8gffR
U+BbWpEv1KviVf4wn6YXx/7/lycc0p/BKf09NER2Bz4yy4ttvBgSmb3GU2Ie
74kkOMyfxWn9fTRCcSRFMhxxrCnO6B+gMR6N3+3z+prfhfm8F5LjKG+Gs/qH
aIIc1n5slg/beYn43Wb9eCos4L1RyGw6fxQHeAoc05vjnP4RSlkzh1eM8+Y5
+Rj9wXB9u9xhXk1fpj+N1vqv8rE4L72/3lGmlg3lZrnQscf1RXpXWU2+IH+S
/eK+OP6I/Ix3kiXiPOUu2Uf+5nhtuYb3kA3li3K/HChTOn5cb4H2/DyvJzfw
j/XS+lz98bgfPBcfq+fHTl6dL9froGTcGz5AT4NFvBJfrFfHa7ww/zzOGQf5
XTgR+xK/62PQFLmt+8SsAHbF9Y37aDaQp8XieAaQCif58/hDH4tm8b2RGmlw
Kq4ZLuifoDnKxH30eYPM0+E73g9pcZq3xEX9U7RAWaS0/nXzu7GE90c6nOGt
cEkfh+eQx9pPzR7Cbl4uztVsML8H3/PK/Dv9KQzgRfiMuI44xO/G2dgnuKyP
j+9tzTe8Upwzf4CP0wvG/dF3yD3mT+kr9Lpoo++T5eN66W/oL8v0spHcInvL
Hxx/Qi7h3WSNuA7yZ9k/rr3jReVM3lmWimdA7o57Kw87/rRcG+8F2Ui+JA/E
OTt2Lr4L/tTrm2/UJ8S11b/VK8d94nn5eP1h7OU1+Eq9HirEfeVv6hmwlA+K
d4nZF7w0jvD0OB97HVf0iWgZ767YE9YOMb8Xy/jryIDf4/viqj4JreLZw734
w7wtrumT0Tr2duwXnzXU/D4s54NxHy7wdriuT0Eb5LN2glkh/Bj3P/aP2Vs8
I1bwN+I9Z/YlL4OjPCMuxvOJG/rU2E/WzONPxDnyB/lE/RH8xGvyVXr9WBN7
ib+tZ0Jjfatcaf6k/r3eXdaMfSx/if0Y1zjeqfIr/oosG+8JuSfR/39/jjle
R67jPWXjuEbxzpGDZCbHL+kdAn6TN5Cb+DS9vD5ffzL2sv5jXH/z/PokvTCa
6jvlz+a19NV6g/gZfg8fpmfGKl4l9rBeC0Pifc6/1svhOM+My3pH3NKnoy0K
WDfZrAh+ic+J/WM2nGfBaj4UWfBnPDu4rX+GdqiK+3HFvBP+0j9He1RDVmRD
dlyNZwd/6zPQAdWRA9fiOuOOPhMd4zlGTlw3jz/8/+hf4OV4LmLf+p4jzO/H
Gv4WcuEG74p/9S/RKfZE7GXrR5pnxVr+NnLjZjzziP9UfCU64yFrp/Ci+DWu
f+xts3d4Nqzjw/CY2ax4v+AEz4NbsaeQCF/zCtYs0KvEOfKCfKpeDPt47djn
Zu/y7FjPl/ljPzzecbht1gOJMYt3iXcNMvmZUWY5sIGPiPcH/op3EJJgNu8a
ezX2gPWjzXJiIx8ZzyX+jj2MpJjDu6Fu3HPr3zPLhU38nXjWcIf3QjLM5d1R
L/aB9e+b5cZm/m7sZ/zDeyM5vuE9UD/2hvUfmOXBFj4q9iP+jfeQ8/8Pcrwj
CA==
                "]]},
              Annotation[#, "Charting`Private`Tag$669447#1"]& ], 
             TagBox[
              {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6],
                Opacity[1.], LineBox[CompressedData["
1:eJwV1Xf4jmUYxvHXlpmIMrNCZUTI3sooI4SQTcOuNMhWRmUme2SlaWWWmX0c
SGZmySojIUr0uf74Hud5fe/n+T2ecb/ytu/RuHuSRCKRIWkiMQCPJk8kFidL
JBogOXZzbbkz+lCUw2KuDrdb74Z8uMgNxGP8EnNDpMAebgkGYTCGoKhjllpr
hJTYyy1FXX6PuTvy4xI3FMX4ZebGSIUfuWWox+8190Bh91BAXuaHobi15ebn
kBr7uHbcWX0YymM5V5/7Ue+JguhnTopZ+hXrr+h/6h+hJoab02FRdOsl9G/1
JvhAz4x79DfkbTkl0B/CT45vL89xC+RwOUFmRwV9SJyLr7DAPEsWwsq4hnOf
kfv4ubKXHCOzxvvCw+b+Mhk+x2zzdJk/zo17cP6r8mqch0l6LtTS35Pp47zo
jntcX6E3RRr0Nf8np2K/9Q7m83EsKmIF92zcn94bhXCV68b9pY9FbbzPlYz7
0ZshLQ5wK9GA328u4j32ifeJv/gRKGVtlfl5pMNBbhVG4glrq7nmSI9D3Go0
5A+YX4u/iWvcKJTm15hbIAMOc2vQiD9ofh2P4Do3GmX4teaWyIgjXEfuQtwP
KmEt15g7FO8dj+Jdc3LM0W9Y765f08fhqTjXnAFfxHdjvaz+nf4CPtSz4F79
TXlHLpLT4h3IvPFt42fndZK/8wvlCDlR5oj9hcqxZ2UafI2F5tmycDzPuJ7z
n5OH+Xmyb7wrmQ2P6QNkCnyqz5AF8Ldzesjr3Hh8oufG0/oImRFfxj047kn9
e70VMuEt8934LnHUemfzH/pIVMH3XBPuSNw3iuIm15O7EXsFdWIvcuW4dXpr
3Idj3Do0jecS10Ix3OLGoDy/3twGmXGcW4+xqGBtA/cissT79w2e4DdgHMaj
omM2WmuL+3GS24hm/FHz2yiOf7gJqMRvMrdDVpziNuF5/pj5HZTAv9xEVOY3
m9sjG37hunAX9VGois1cc+643g+PY6A5Jebqt633incU3wHqxrON7yh+U/SP
rVfRf9A7xHPU78cD8e+XCczQp8l8+NXxXeUl7jM5Ov6GzBm/x6hmHibT4ht8
Zp4ji8SejOs4v4U8wc+X/eP7j+thCUqaB8lUsQ8wzzxTFozfG+f2ljfjmpis
50G9eB4yU3zT+iTHVdW36B3xYDxbcxLM1E9bf0m/HPsM1bGFa8mdjH2KUrjD
9eFuxd9E/fi2uWrcVr0TsuM3bite4E/FHsETuMtNRnV+m7kzcuAMtw1TMDX+
f/WYp8kajttuvQty4iy3HdNR09oOrity4Ry3A634X+KdozQSsS/5WvxO/SXk
xnluJ1rHO4xnjDJIEs+Xr83v0l9GHlzgXuauxL5FDezi2nCn9cGx1/UHUTZm
mTr2Oeab/weMXBEH
                "]], 
               LineBox[{1062, 1207, 770, 1140, 1018, 920, 845, 672, 1095, 973,
                 875, 800, 747, 717, 673, 674, 675, 676, 677, 678, 679, 680, 
                681, 682, 683, 684, 685, 686, 687, 1096, 974, 876, 801, 748, 
                718, 1119, 997, 899, 824, 771, 1141, 1019, 921, 846, 1164, 
                1042, 944, 1187, 1066, 1211, 688}]},
              Annotation[#, "Charting`Private`Tag$669447#2"]& ], 
             TagBox[
              {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
               Dashing[{Small, Small}], 
               LineBox[{1216, 1266, 1217, 1218, 1219, 1220, 1221, 1222, 1223, 
                1224, 1225, 1226, 1227, 1228, 1229, 1230, 1231, 1232, 1233, 
                1234, 1235, 1236, 1237, 1238, 1239, 1240, 1241, 1242, 1243, 
                1244, 1245, 1246, 1247, 1248, 1249, 1250, 1251, 1252, 1253, 
                1254, 1255, 1256, 1257, 1258, 1259, 1260, 1261, 1262, 1263, 
                1264, 1267, 1265}]},
              Annotation[#, "Charting`Private`Tag$669447#3"]& ], 
             {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
              LineBox[{1214, 1215, 
               1213}]}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}}], {}}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImagePadding->{{7.989795918367349, 1.5}, {7.499999999999972, 
         6.500000000000014}},
        Method->{
         "DefaultBoundaryStyle" -> Automatic, 
          "DefaultGraphicsInteraction" -> {
           "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
            "Effects" -> {
             "Highlight" -> {"ratio" -> 2}, 
              "HighlightPoint" -> {"ratio" -> 2}, 
              "Droplines" -> {
               "freeformCursorMode" -> True, 
                "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
          "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
          None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& )}, "AxesInFront" -> True},
        PlotRange->{{0., 14.999999693877552`}, {-4, 4}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {0, 0}},
        Ticks->{Automatic, Automatic}], {147.96799443267588, -98.99470729797976},
        ImageScaled[{0.5, 0.5}], {291.93598886535176, 188.56134723424717}], 
      InsetBox[
       GraphicsBox[{{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwVl3k8VO8Xx1MpCQkJKVkSkiSh6H6GqKxFpbJXSJJCC6nIliQk2UJZilRC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             "]]},
           Annotation[#, "Charting`Private`Tag$669522#1"]& ]}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0.8, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImagePadding->{{1.8673469387755404`, 1.5000000000000568`}, {
         7.499999999999972, 6.500000000000014}},
        Method->{
         "DefaultBoundaryStyle" -> Automatic, 
          "DefaultGraphicsInteraction" -> {
           "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
            "Effects" -> {
             "Highlight" -> {"ratio" -> 2}, 
              "HighlightPoint" -> {"ratio" -> 2}, 
              "Droplines" -> {
               "freeformCursorMode" -> True, 
                "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
          "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
          None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& )}},
        PlotRange->{{0.8, 1.2}, {0., 6.7468973124070395`}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.05], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}], {440.84275880823174, -98.99470729797976},
        ImageScaled[{0.5, 0.5}], {285.81353988576, 188.56134723424717}]}, {}},
    
    ImageSize->600,
    PlotRange->{{0, 585.7495287511117}, {-197.98941459595952`, 0}},
    PlotRangePadding->{6, 5}], ",", "2.4014911606263443`"}], "}"}]], "Output",\

 CellChangeTimes->{{3.720331362129237*^9, 3.720331408111971*^9}, {
   3.720331453266436*^9, 3.7203314926189003`*^9}, {3.720331573269372*^9, 
   3.720331605454184*^9}, {3.720331654801332*^9, 3.720331688044458*^9}, 
   3.720331806527504*^9, {3.720331840265367*^9, 3.7203318630769167`*^9}, 
   3.720332522547069*^9, 3.720332634176014*^9, 3.720332727251525*^9, 
   3.720332777905098*^9, 3.720332837647497*^9, 3.720332881477193*^9, 
   3.7203337101743927`*^9, 3.7203339017952957`*^9, 3.720333983579186*^9, 
   3.720334374375059*^9, 3.7203383394944677`*^9, 3.793845957256558*^9},
 CellLabel->
  "Out[815]=",ExpressionUUID->"788912cd-0f5b-4481-80ed-046bd7cc0c0c"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}, {3.72033837444219*^9, 
  3.7203383773780823`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"8656cdca-d40a-412a-b04a-e6272521e665"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dat1", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Through", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "\[Theta]1", ",", "\[Theta]1a", ",", "\[Theta]1b", ",", "\[Theta]2", 
          ",", "\[Theta]2a", ",", "\[Theta]2b", ",", "unom", ",", "urob"}], 
         "}"}], "[", "t", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Tau]1", ",", "0.05"}], "}"}]}], "]"}], "//",
     "N"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat2", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Through", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x\[Omega]1rob", ",", "x\[Omega]2rob"}], "}"}], "[", "t", 
        "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Tau]", ",", "0.05"}], "}"}]}], "]"}], "//",
     "N"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datJs", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"JdatNom", ",", "JdatRob"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datJu", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"JudatNom", ",", "JudatRob"}], "}"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7167394002782793`*^9, 3.7167394007756653`*^9}, {
   3.716739480630252*^9, 3.716739620038939*^9}, {3.720274546340539*^9, 
   3.720274559162821*^9}, {3.720278959233184*^9, 3.720278980717373*^9}, 
   3.7203379381654043`*^9, {3.7203380037787848`*^9, 3.720338010393297*^9}, {
   3.720338085562695*^9, 3.720338174648615*^9}, 3.7203382138691177`*^9, {
   3.72033836813146*^9, 3.7203383688647337`*^9}, {3.720338939400527*^9, 
   3.720338941217545*^9}, {3.720338972552539*^9, 3.720339016445763*^9}, {
   3.720339059116745*^9, 3.720339081076498*^9}, {3.720339533195633*^9, 
   3.720339537096932*^9}, {3.7203398461164827`*^9, 3.720339847286676*^9}, {
   3.793845912217942*^9, 3.793845930282545*^9}},
 CellLabel->
  "In[816]:=",ExpressionUUID->"c8960ba3-09c6-4bb6-826b-0e5b38360370"],

Cell[BoxData[
 RowBox[{"(*", " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<pendulumPertRobust1.dat\>\"", ",", " ", "dat1"}], "]"}], ";",
    "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<pendulumPertRobust2.dat\>\"", ",", " ", "dat2"}], "]"}], ";",
    "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<pendulumPertRobustJs.dat\>\"", ",", " ", "datJs"}], "]"}], 
   ";", "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<pendulumPertRobustJu.dat\>\"", ",", " ", "datJu"}], "]"}], 
   ";"}], " ", "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.716739644526311*^9, 3.716739658994514*^9}, {
  3.720339566397582*^9, 3.720339628023535*^9}, {3.720340162275209*^9, 
  3.720340165952477*^9}, {3.793845915476151*^9, 3.793845921642458*^9}},
 CellLabel->
  "In[820]:=",ExpressionUUID->"094a09ba-b465-4a40-b4dd-3a0dd5266c1f"]
}, Open  ]]
},
WindowSize->{800, 851},
WindowMargins->{{Automatic, 33}, {Automatic, 0}},
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (March 13, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"38023b8d-0a7f-475d-9944-7f45cdfaff4a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 875, 15, 105, "Section",ExpressionUUID->"c2f1811f-5d39-4870-bd7a-071084aa3a3d"],
Cell[1458, 39, 687, 15, 52, "Input",ExpressionUUID->"6dd0b628-064e-4934-9f4c-d8f363683be6"],
Cell[2148, 56, 744, 14, 76, "Text",ExpressionUUID->"a2954139-f871-4e4f-8a02-8f07608ba4e8"],
Cell[2895, 72, 8949, 224, 572, "Input",ExpressionUUID->"6e42687c-bd84-429b-9901-9da7fec5d545"],
Cell[11847, 298, 427, 9, 52, "Text",ExpressionUUID->"291c1013-9723-4bbf-bdf6-0ec48ff3a54f"],
Cell[12277, 309, 3348, 80, 168, "Input",ExpressionUUID->"03e0d4f6-e531-4b5f-ab2e-1a3e95fe7d1f"],
Cell[15628, 391, 380, 9, 30, "Input",ExpressionUUID->"060644a0-5fff-49ec-8387-7b60cc83f0d0"],
Cell[16011, 402, 494, 14, 47, "Input",ExpressionUUID->"223db326-2d76-44f6-b59e-0cc7f18ad22d"],
Cell[16508, 418, 1143, 30, 96, "Input",ExpressionUUID->"dffb34d4-838a-467a-a2a0-8d216c912383"],
Cell[17654, 450, 1047, 29, 96, "Input",ExpressionUUID->"3b11d574-696d-4c33-a7b3-3ab445463959"],
Cell[18704, 481, 501, 12, 52, "Text",ExpressionUUID->"48036b2a-7a95-4b13-89ce-fac57bcb3597"],
Cell[19208, 495, 13606, 333, 789, "Input",ExpressionUUID->"ec6d3868-25d2-4cc8-92bb-c6edf124ec54"],
Cell[CellGroupData[{
Cell[32839, 832, 667, 15, 30, "Input",ExpressionUUID->"c892da7e-3cbf-4a5c-b3b0-26ca0629edd5"],
Cell[33509, 849, 29562, 505, 231, "Output",ExpressionUUID->"d7b25705-e301-4194-aabf-a1ab28d833fd"]
}, Open  ]],
Cell[63086, 1357, 676, 13, 52, "Text",ExpressionUUID->"ab2c3ba2-7995-4570-831f-4b8550a86355"],
Cell[CellGroupData[{
Cell[63787, 1374, 2635, 69, 220, "Input",ExpressionUUID->"c9c99de9-620f-4db0-9aa5-3ae25257e88b"],
Cell[66425, 1445, 486, 10, 42, "Message",ExpressionUUID->"5434f872-934c-4435-b42a-1da8fd46b900"],
Cell[66914, 1457, 486, 10, 42, "Message",ExpressionUUID->"54934346-07ac-4630-9ecb-f164dff8b511"],
Cell[67403, 1469, 487, 10, 42, "Message",ExpressionUUID->"47dca7c7-7184-4c0f-a572-acbb9c048175"],
Cell[67893, 1481, 484, 10, 42, "Message",ExpressionUUID->"7acb19af-ba40-497d-8b44-19883ca3f0c7"],
Cell[68380, 1493, 485, 10, 42, "Message",ExpressionUUID->"681e6f1f-e801-4e96-98fa-10da6f6abd20"],
Cell[68868, 1505, 487, 10, 42, "Message",ExpressionUUID->"8529bab0-7514-47f9-b3ae-456c0b1d47cc"],
Cell[69358, 1517, 487, 10, 42, "Message",ExpressionUUID->"17c97913-9dc0-4ef5-8798-a90fd04ae49c"],
Cell[69848, 1529, 469, 10, 24, "Message",ExpressionUUID->"aea61c0f-6f51-4557-91a1-04f4771923ef"],
Cell[70320, 1541, 486, 10, 42, "Message",ExpressionUUID->"865664c3-8f00-42f1-b569-518a865f0fd2"],
Cell[70809, 1553, 486, 10, 42, "Message",ExpressionUUID->"b9393d6d-4094-4e4f-a176-abae0f30e417"],
Cell[71298, 1565, 485, 10, 42, "Message",ExpressionUUID->"f2d0bf87-9975-44bd-8fb1-f414ade2a807"],
Cell[71786, 1577, 487, 10, 42, "Message",ExpressionUUID->"e9b1efd3-17e8-42a7-aced-23acf5bf8b36"],
Cell[72276, 1589, 485, 10, 42, "Message",ExpressionUUID->"617e20e4-f550-4cc2-858a-e53781c4b303"],
Cell[72764, 1601, 483, 10, 42, "Message",ExpressionUUID->"98208251-14b3-42fb-a96e-fb1a3c761544"]
}, Open  ]],
Cell[73262, 1614, 728, 11, 52, "Text",ExpressionUUID->"46b14497-02dc-4e0f-91b9-58f8b0e8b439"],
Cell[CellGroupData[{
Cell[74015, 1629, 1275, 36, 94, "Input",ExpressionUUID->"84a52d07-1bb4-4190-b539-9407c0710a8a"],
Cell[75293, 1667, 485, 10, 42, "Message",ExpressionUUID->"d62d635d-025a-49d4-a1c7-77d46b7063c2"],
Cell[75781, 1679, 485, 10, 42, "Message",ExpressionUUID->"e8d817cd-3b2b-4f68-9ffc-f6676d58f32e"],
Cell[76269, 1691, 485, 10, 42, "Message",ExpressionUUID->"ccd7d54d-7daf-4b39-80bc-28d2953d8b09"],
Cell[76757, 1703, 469, 10, 24, "Message",ExpressionUUID->"adadad60-e100-424a-9ea7-99db84df881a"],
Cell[77229, 1715, 487, 10, 42, "Message",ExpressionUUID->"23d5c98d-6f94-4224-9ba8-1934789c6551"],
Cell[77719, 1727, 484, 10, 42, "Message",ExpressionUUID->"df55ce0f-8d41-4a92-9f17-98326e4ee77c"],
Cell[78206, 1739, 485, 10, 42, "Message",ExpressionUUID->"f6492687-543c-4580-8457-b0f3cf765eb5"],
Cell[78694, 1751, 471, 10, 24, "Message",ExpressionUUID->"6e92e038-cac0-4ee5-849f-8706ee1a27da"],
Cell[79168, 1763, 4274, 87, 261, "Output",ExpressionUUID->"5b023863-7d78-46a7-9515-bce26f3950f1"]
}, Open  ]],
Cell[83457, 1853, 442, 8, 52, "Text",ExpressionUUID->"163832a6-c73e-453c-b8ad-6d3c64c61ecd"],
Cell[CellGroupData[{
Cell[83924, 1865, 3399, 87, 241, "Input",ExpressionUUID->"8d2f4767-77dd-4e07-af88-03d0096681b6"],
Cell[87326, 1954, 131308, 2250, 317, "Output",ExpressionUUID->"bcffe956-5e8c-4d7a-ac9e-79cbccff3529"]
}, Open  ]],
Cell[CellGroupData[{
Cell[218671, 4209, 2128, 59, 115, "Input",ExpressionUUID->"fa509ed0-e81b-4128-8d7a-cd1230683d28"],
Cell[220802, 4270, 54270, 930, 268, "Output",ExpressionUUID->"e22afe46-30fc-41aa-9b5c-4c28a9ad3f28"]
}, Open  ]],
Cell[CellGroupData[{
Cell[275109, 5205, 1383, 31, 73, "Input",ExpressionUUID->"4b9c652c-bcce-4098-b54f-2c83155ea36b"],
Cell[276495, 5238, 599, 12, 59, "Message",ExpressionUUID->"2b7058fd-36d7-405f-9066-597c80b96957"]
}, Open  ]],
Cell[CellGroupData[{
Cell[277131, 5255, 691, 17, 52, "Input",ExpressionUUID->"41e0e72c-4680-407b-97cb-fe00633422a8"],
Cell[277825, 5274, 6523, 150, 254, "Output",ExpressionUUID->"80d5b3e6-0f5a-4794-932a-b3a8e18d8b77"]
}, Open  ]],
Cell[284363, 5427, 454, 8, 52, "Text",ExpressionUUID->"179652c8-dd8a-4a9d-a0f9-e57824dedd11"],
Cell[CellGroupData[{
Cell[284842, 5439, 3674, 98, 283, "Input",ExpressionUUID->"75282c41-0878-4407-87fe-e544d21b31b9"],
Cell[288519, 5539, 487, 10, 42, "Message",ExpressionUUID->"bc9adfa1-fbf3-41dc-9172-8657e814b311"],
Cell[289009, 5551, 485, 10, 42, "Message",ExpressionUUID->"35aa9374-25bb-43e1-b15d-ddf6a3383425"],
Cell[289497, 5563, 485, 10, 42, "Message",ExpressionUUID->"565ea7f3-c02c-4146-b2b3-082c19900543"],
Cell[289985, 5575, 469, 10, 24, "Message",ExpressionUUID->"4ea95c05-53f7-4d3f-a404-3f7697debc8c"],
Cell[290457, 5587, 488, 10, 24, "Message",ExpressionUUID->"c971fa8e-b2cf-4752-9dde-00b9807bbeba"],
Cell[290948, 5599, 488, 10, 24, "Message",ExpressionUUID->"47c0a8e5-21c6-45db-929a-4b8685c418e1"],
Cell[291439, 5611, 486, 10, 42, "Message",ExpressionUUID->"6c759208-ab24-4678-b8ae-8791ee26ea5b"],
Cell[291928, 5623, 486, 10, 42, "Message",ExpressionUUID->"2fef500d-fb58-40d1-a268-9726bd517134"],
Cell[292417, 5635, 488, 10, 42, "Message",ExpressionUUID->"e6319dab-2295-4043-9e5e-62cfc40ace21"],
Cell[292908, 5647, 471, 10, 24, "Message",ExpressionUUID->"1ada464d-88e6-41ad-96b4-3ae38c472cb3"],
Cell[293382, 5659, 485, 10, 42, "Message",ExpressionUUID->"1c8d6a6f-53c1-4bf1-90cb-bdcfbf928b26"],
Cell[293870, 5671, 485, 10, 42, "Message",ExpressionUUID->"d3d21975-9f63-4a6c-911e-d18ad99f27a1"],
Cell[294358, 5683, 109772, 1842, 270, "Output",ExpressionUUID->"788912cd-0f5b-4481-80ed-046bd7cc0c0c"]
}, Open  ]],
Cell[404145, 7528, 444, 8, 52, "Text",ExpressionUUID->"8656cdca-d40a-412a-b04a-e6272521e665"],
Cell[404592, 7538, 2075, 51, 94, "Input",ExpressionUUID->"c8960ba3-09c6-4bb6-826b-0e5b38360370"],
Cell[406670, 7591, 1016, 21, 187, "Input",ExpressionUUID->"094a09ba-b465-4a40-b4dd-3a0dd5266c1f"]
}, Open  ]]
}
]
*)

