(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    298269,       5805]
NotebookOptionsPosition[    289223,       5646]
NotebookOutlinePosition[    289619,       5662]
CellTagsIndexPosition[    289576,       5659]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Input shaping (robust version)  (Problem 9.1)", "Section",
 CellChangeTimes->{{3.51234253975478*^9, 3.5123425658747683`*^9}, {
  3.512685624487522*^9, 3.512685629884605*^9}, {3.512896614611411*^9, 
  3.51289661590652*^9}, {3.513459889964919*^9, 3.5134599091446543`*^9}, {
  3.513460046826726*^9, 3.513460067738385*^9}, {3.6759570352690153`*^9, 
  3.675957049326749*^9}, {3.676140589038329*^9, 3.676140600100687*^9}, {
  3.7938437704502287`*^9, 
  3.793843775663385*^9}},ExpressionUUID->"923c81a9-255c-429c-b29f-\
5431a92dc26d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[3244]:=",ExpressionUUID->"1768999d-baa5-46ab-9695-c02d626d69d2"],

Cell["ZV shaper  (zero vibration)", "Text",
 CellChangeTimes->{{3.676147586319213*^9, 3.676147620687036*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"7666c335-cc71-4990-b8c5-a9a5e115f813"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v1", "=", 
  RowBox[{
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"A1", "+", 
        RowBox[{"A2", " ", 
         RowBox[{"Cos", "[", " ", 
          RowBox[{"\[Omega]", " ", "\[Tau]"}], "]"}]}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"A2", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[Omega]", " ", "\[Tau]"}], "]"}]}], ")"}], "2"]}]], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{
  3.676140624957479*^9, {3.67614066264419*^9, 3.6761406660915823`*^9}, {
   3.6761475085953693`*^9, 3.676147525394774*^9}, {3.676161708405198*^9, 
   3.676161733436693*^9}},
 CellLabel->
  "In[3245]:=",ExpressionUUID->"06a52413-30e1-4ee5-af55-f895a7172ba5"],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox["A1", "2"], "+", 
   SuperscriptBox["A2", "2"], "+", 
   RowBox[{"2", " ", "A1", " ", "A2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"\[Tau]", " ", "\[Omega]"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{{3.67616172650463*^9, 3.676161734059531*^9}, 
   3.676167266144075*^9, 3.6761681618028393`*^9, 3.676207044463565*^9, 
   3.688048271770549*^9, {3.688048324759356*^9, 3.688048344164002*^9}, 
   3.688049127134843*^9, 3.688051193343454*^9, 3.688055338186619*^9, 
   3.688058420581367*^9, 3.688059336584408*^9, 3.6880599893942432`*^9, 
   3.688069617971043*^9, 3.6880698583880453`*^9, 3.6881023528092813`*^9, 
   3.688102494203638*^9, 3.688596640862811*^9, 3.720550183232752*^9, 
   3.7938438048265543`*^9, 3.7938439183526573`*^9, 3.793844020493557*^9, 
   3.8232295669764137`*^9},
 CellLabel->
  "Out[3245]=",ExpressionUUID->"a01dbca9-af59-4875-93e7-0b7bf92ef165"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v1", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"A2", "\[Rule]", "A1"}], ",", 
     RowBox[{"\[Tau]", "\[Rule]", "\[Pi]"}]}], "}"}]}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.688069643727477*^9, 3.688069668377392*^9}},
 CellLabel->
  "In[3246]:=",ExpressionUUID->"1f54e28d-acbe-4eec-ad16-74534409ba7d"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox[
   RowBox[{
    SuperscriptBox["A1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      FractionBox[
       RowBox[{"\[Pi]", " ", "\[Omega]"}], "2"], "]"}], "2"]}]]}]], "Output",
 CellChangeTimes->{3.688069669258799*^9, 3.688069858419684*^9, 
  3.688102352856889*^9, 3.688102494234428*^9, 3.6885966409283543`*^9, 
  3.720550183316813*^9, 3.793843804852914*^9, 3.7938439183636293`*^9, 
  3.793844020523633*^9, 3.823229567006322*^9},
 CellLabel->
  "Out[3246]=",ExpressionUUID->"098a6432-5c15-4f14-8908-b834a41d0c62"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v1a", "=", 
  RowBox[{"v1", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"A1", "\[Rule]", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"A2", "\[Rule]", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"\[Tau]", "\[Rule]", "\[Pi]"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.688048383465136*^9, 3.68804839360217*^9}, {
   3.6880508706419897`*^9, 3.68805089875978*^9}, 3.688051015403001*^9, 
   3.688051051481223*^9, {3.688051089990884*^9, 3.688051126337017*^9}},
 CellLabel->
  "In[3247]:=",ExpressionUUID->"86545af4-c7e7-43c2-afbe-315b4c8136e5"],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   FractionBox["1", "2"], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"\[Pi]", " ", "\[Omega]"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{{3.68805110447994*^9, 3.6880511267941236`*^9}, 
   3.6880511933762007`*^9, 3.688055338253277*^9, 3.688058420633741*^9, 
   3.688059336616879*^9, 3.688059989456209*^9, 3.688069618011003*^9, 
   3.688069858473693*^9, 3.688102352905375*^9, 3.688102494293062*^9, 
   3.688596640991746*^9, 3.720550183400578*^9, 3.793843804858616*^9, 
   3.793843918389358*^9, 3.793844020532476*^9, 3.823229567011855*^9},
 CellLabel->
  "Out[3247]=",ExpressionUUID->"1fb0cfb8-93d2-4bc0-a021-b30a58be1d60"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v1s", "=", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"v1a", ",", 
       RowBox[{"{", 
        RowBox[{"\[Omega]", ",", "1", ",", "1"}], "}"}]}], "]"}], "]"}], "//",
     "Normal"}]}], ";", " ", 
  RowBox[{"TraditionalForm", "[", "v1s", "]"}]}]], "Input",
 CellChangeTimes->{{3.676140967843855*^9, 3.676141029952489*^9}, {
   3.676147086432132*^9, 3.676147108418765*^9}, {3.676147724812842*^9, 
   3.676147770586726*^9}, 3.676162511525816*^9, 3.6761634214986267`*^9, {
   3.688048285919772*^9, 3.688048288746655*^9}, {3.688048403881366*^9, 
   3.688048418208322*^9}, 3.688048619963785*^9, {3.688050691838173*^9, 
   3.688050703308188*^9}, {3.688050914185256*^9, 3.688050926113172*^9}, 
   3.6880509736917467`*^9, {3.688051055015532*^9, 3.688051065040485*^9}, {
   3.6880511084583673`*^9, 3.688051144766637*^9}},
 CellLabel->
  "In[3248]:=",ExpressionUUID->"453a3edf-9f79-47d1-a77e-796a59e3f64d"],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"\[Pi]", " ", 
    TemplateBox[{
      RowBox[{"\[Omega]", "-", "1"}]},
     "Abs"]}], "2"], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.688050926823387*^9, {3.688050965306326*^9, 3.6880509742981567`*^9}, 
   3.6880510554649773`*^9, {3.688051112092354*^9, 3.688051115682659*^9}, {
   3.688051146941766*^9, 3.6880511608619957`*^9}, 3.6880511934383373`*^9, 
   3.6880553382996264`*^9, 3.688058420685533*^9, 3.6880593366745253`*^9, 
   3.6880599895060368`*^9, 3.6880696180603867`*^9, 3.6880698585235786`*^9, 
   3.6881023529506903`*^9, 3.6881024943429413`*^9, 3.688596641058794*^9, 
   3.720550183511569*^9, 3.793843804899852*^9, 3.79384391842176*^9, 
   3.793844020561379*^9, 3.8232295670447693`*^9},
 CellLabel->
  "Out[3248]//TraditionalForm=",ExpressionUUID->"c134453a-f1fa-4846-b12e-\
734c15f2ff65"]
}, Open  ]],

Cell["\<\
ZVD shaper (zero vibration + zero derivative wrt \[Omega]), for robustness\
\>", "Text",
 CellChangeTimes->{{3.676147586319213*^9, 3.676147638502285*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"13250df8-894b-44da-b8c6-3fd6e2a776c5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v2", "=", 
  RowBox[{
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"A1", "+", 
        RowBox[{"A2", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"\[Pi]", " ", "\[Omega]"}], "]"}]}], "+", 
        RowBox[{"A3", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", "\[Pi]", " ", "\[Omega]"}], "]"}]}]}], ")"}], "2"], 
     "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"A2", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"\[Pi]", " ", "\[Omega]"}], "]"}]}], "+", 
        RowBox[{"A3", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "\[Pi]", " ", "\[Omega]"}], "]"}]}]}], ")"}], "2"]}]], 
   "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{
  3.688049214829095*^9, {3.688049305182576*^9, 3.6880493125343018`*^9}, 
   3.688049428510386*^9},
 CellLabel->
  "In[3249]:=",ExpressionUUID->"10569752-dff8-464b-add2-d80accedf0b2"],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"A1", "+", 
      RowBox[{"A2", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"\[Pi]", " ", "\[Omega]"}], "]"}]}], "+", 
      RowBox[{"A3", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "\[Pi]", " ", "\[Omega]"}], "]"}]}]}], ")"}], "2"], 
   "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"A2", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"\[Pi]", " ", "\[Omega]"}], "]"}]}], "+", 
      RowBox[{"A3", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "\[Pi]", " ", "\[Omega]"}], "]"}]}]}], ")"}], 
    "2"]}]]], "Output",
 CellChangeTimes->{3.688049215614086*^9, 3.6880493131790323`*^9, 
  3.6880494290266733`*^9, 3.688051193505542*^9, 3.688055338346116*^9, 
  3.688058420732387*^9, 3.6880593367235413`*^9, 3.6880599895553493`*^9, 
  3.688069618106575*^9, 3.688069858570464*^9, 3.68810235299463*^9, 
  3.6881024943905*^9, 3.688596641110808*^9, 3.7205501835818167`*^9, 
  3.793843804929716*^9, 3.793843918454689*^9, 3.793844020587755*^9, 
  3.823229567074232*^9},
 CellLabel->
  "Out[3249]=",ExpressionUUID->"fe252f06-7b3e-4191-80b0-6d797c0ceb28"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v2a", "=", 
  RowBox[{
   RowBox[{"v2", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"A3", "\[Rule]", "A1"}], ",", 
      RowBox[{"A2", "\[Rule]", 
       RowBox[{"1", "-", 
        RowBox[{"2", "A1"}]}]}]}], "}"}]}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.688070196587385*^9, 3.688070225972982*^9}, {
  3.68807059002028*^9, 3.688070638107114*^9}},
 CellLabel->
  "In[3250]:=",ExpressionUUID->"0367ee78-5e08-42d3-8b16-3c90a1c4f6b7"],

Cell[BoxData[
 SqrtBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"2", " ", "A1"}], "+", 
     RowBox[{"2", " ", "A1", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"\[Pi]", " ", "\[Omega]"}], "]"}]}]}], ")"}], "2"]]], "Output",\

 CellChangeTimes->{{3.688070206864921*^9, 3.688070226586975*^9}, {
   3.688070591148066*^9, 3.688070638563842*^9}, 3.6881023544997063`*^9, 
   3.688102494443314*^9, 3.6885966411412992`*^9, 3.720550183649745*^9, 
   3.79384380495846*^9, 3.793843918487194*^9, 3.7938440206118603`*^9, 
   3.8232295671009693`*^9},
 CellLabel->
  "Out[3250]=",ExpressionUUID->"c7634ce6-9cb3-4153-b48f-94053fd37f14"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"dv2d\[Omega]", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      SuperscriptBox["v2a", "2"], ",", "\[Omega]"}], "]"}], "//", 
    "Simplify"}]}], ";", "  ", 
  RowBox[{"TraditionalForm", "[", "dv2d\[Omega]", "]"}]}]], "Input",
 CellChangeTimes->{{3.688049227437203*^9, 3.68804925199006*^9}, {
   3.688049370524055*^9, 3.688049386699366*^9}, {3.6880494804179173`*^9, 
   3.688049494453809*^9}, {3.688051797702793*^9, 3.688051807848082*^9}, {
   3.6880518544999638`*^9, 3.6880518572026463`*^9}, 3.68805309976299*^9, {
   3.688102412693612*^9, 3.688102415136804*^9}},
 CellLabel->
  "In[3251]:=",ExpressionUUID->"145b31ea-c47d-47de-b787-d505e9b1b2c7"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "4"}], " ", "\[Pi]", " ", "A1", " ", 
   RowBox[{"sin", "(", 
    RowBox[{"\[Pi]", " ", "\[Omega]"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "A1", " ", 
      RowBox[{"cos", "(", 
       RowBox[{"\[Pi]", " ", "\[Omega]"}], ")"}]}], "-", 
     RowBox[{"2", " ", "A1"}], "+", "1"}], ")"}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.688049235792128*^9, 3.688049252484254*^9}, 
   3.6880493164921093`*^9, {3.6880493768681192`*^9, 3.688049387305111*^9}, 
   3.688049431172336*^9, {3.688049480938692*^9, 3.6880494948849897`*^9}, 
   3.688051193596857*^9, 3.688051808268561*^9, 3.688051857725402*^9, 
   3.688053100534375*^9, 3.688055338402095*^9, 3.6880584207814827`*^9, 
   3.688059336774035*^9, 3.68805998960427*^9, 3.6880696181515903`*^9, 
   3.6880698586203012`*^9, 3.688102354587332*^9, 3.6881024182513323`*^9, 
   3.6881024944931383`*^9, 3.6885966411913443`*^9, 3.720550183717314*^9, 
   3.793843804991344*^9, 3.793843918495021*^9, 3.793844020631608*^9, 
   3.823229567108448*^9},
 CellLabel->
  "Out[3251]//TraditionalForm=",ExpressionUUID->"11aa207c-a1de-4301-8270-\
7c6630c49fc7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v2a", " ", "=", " ", 
   RowBox[{"v2", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"A1", "\[Rule]", 
       FractionBox["1", "4"]}], ",", 
      RowBox[{"A2", "\[Rule]", 
       FractionBox["1", "2"]}], ",", 
      RowBox[{"A3", "\[Rule]", 
       FractionBox["1", "4"]}]}], "}"}]}]}], ";", "  ", 
  RowBox[{"v2as", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"v2a", ",", 
     RowBox[{"\[Omega]", ">", "0"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.676147642936962*^9, 3.676147702443799*^9}, {
  3.676163342109544*^9, 3.676163348220573*^9}, {3.688048552538342*^9, 
  3.688048587752603*^9}, {3.688049209034008*^9, 3.6880492117081223`*^9}, {
  3.688050780534417*^9, 3.68805081724434*^9}},
 CellLabel->
  "In[3252]:=",ExpressionUUID->"983fa6a7-939c-4593-888d-892a9eaec00e"],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"Cos", "[", 
   FractionBox[
    RowBox[{"\[Pi]", " ", "\[Omega]"}], "2"], "]"}], "2"]], "Output",
 CellChangeTimes->{
  3.676163348917491*^9, 3.6761672663395844`*^9, 3.676168161996122*^9, 
   3.676207044609446*^9, 3.6880482719343033`*^9, 3.688048324942637*^9, {
   3.688048570999875*^9, 3.68804858866676*^9}, 3.688049127323325*^9, 
   3.688050782468772*^9, 3.688050818291691*^9, 3.6880511936885147`*^9, 
   3.688055338470683*^9, 3.688058420846463*^9, 3.6880593368250647`*^9, 
   3.688059989657275*^9, 3.6880696182153893`*^9, 3.68806985867369*^9, 
   3.688102354638689*^9, 3.688102494543578*^9, 3.688596641240603*^9, 
   3.720550183802576*^9, 3.793843805026196*^9, 3.793843918521825*^9, 
   3.793844020644486*^9, 3.823229567133913*^9},
 CellLabel->
  "Out[3252]=",ExpressionUUID->"9b21f5ff-0bdf-4fed-8759-59a904f65910"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"v2", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"A3", "\[Rule]", "A1"}], ",", 
      RowBox[{"A2", "\[Rule]", 
       RowBox[{"1", "-", 
        RowBox[{"2", "A1"}]}]}]}], "}"}]}], "//", "FullSimplify"}]}]], "Input",\

 CellChangeTimes->{{3.6880704882359447`*^9, 3.688070525425778*^9}},
 CellLabel->
  "In[3253]:=",ExpressionUUID->"31457738-061b-4d9b-bfb3-fae8325ddc82"],

Cell[BoxData[
 SqrtBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"2", " ", "A1"}], "+", 
     RowBox[{"2", " ", "A1", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"\[Pi]", " ", "\[Omega]"}], "]"}]}]}], ")"}], "2"]]], "Output",\

 CellChangeTimes->{{3.688070520118951*^9, 3.6880705259225073`*^9}, 
   3.688102354734572*^9, 3.6881024946052647`*^9, 3.688596641309354*^9, 
   3.7205501839157047`*^9, 3.7938438050658503`*^9, 3.793843918561858*^9, 
   3.7938440206796417`*^9, 3.8232295671737823`*^9},
 CellLabel->
  "Out[3253]=",ExpressionUUID->"de55e81b-3af9-4a06-b1a9-bd51f85a3164"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v2s", "=", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{"v2as", ",", 
      RowBox[{"{", 
       RowBox[{"\[Omega]", ",", "1", ",", "2"}], "}"}]}], "]"}], "//", 
    "Normal"}]}], ";", "   ", 
  RowBox[{"TraditionalForm", "[", "v2s", "]"}]}]], "Input",
 CellChangeTimes->{{3.688048594929178*^9, 3.68804860920907*^9}, 
   3.688050825021987*^9, {3.688051171477578*^9, 3.688051178742037*^9}},
 CellLabel->
  "In[3254]:=",ExpressionUUID->"de76bd5c-bb7d-43d7-a537-0aaf1da6011f"],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox["\[Pi]", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"\[Omega]", "-", "1"}], ")"}], "2"]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.688048601292056*^9, 3.6880486096234617`*^9}, 
   3.688049127376617*^9, 3.6880508257939663`*^9, {3.6880511792284946`*^9, 
   3.688051193754842*^9}, 3.688055338536735*^9, 3.688058420883535*^9, 
   3.688059336874364*^9, 3.68805998970781*^9, 3.6880696182645397`*^9, 
   3.688069858720126*^9, 3.6881023547674103`*^9, 3.688102494634952*^9, 
   3.688596641356773*^9, 3.720550183984084*^9, 3.793843805071068*^9, 
   3.7938439185680103`*^9, 3.793844020685947*^9, 3.82322956717865*^9},
 CellLabel->
  "Out[3254]//TraditionalForm=",ExpressionUUID->"e3e917d0-7df1-4264-9393-\
d952115791bf"]
}, Open  ]],

Cell["ZVDD shaper (zero vibe + zero 1st and 2nd derivatives wrt \[Omega])", \
"Text",
 CellChangeTimes->{{3.676147586319213*^9, 3.676147638502285*^9}, {
  3.676147980893701*^9, 3.676147992419711*^9}, {3.676163170667118*^9, 
  3.6761631736642036`*^9}, {3.6762069559869423`*^9, 3.6762070101503353`*^9}, {
  3.688053285683731*^9, 3.68805330417483*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"583195cb-1d20-4a7f-83bc-a00e342d4a04"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v4", "=", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"A1", "+", 
         RowBox[{"A2", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"\[Pi]", " ", "\[Omega]"}], "]"}]}], "+", 
         RowBox[{"A3", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", "\[Pi]", " ", "\[Omega]"}], "]"}]}], "+", 
         RowBox[{"A4", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"3", "\[Pi]", " ", "\[Omega]"}], "]"}]}]}], ")"}], "2"], 
      "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"A2", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"\[Pi]", " ", "\[Omega]"}], "]"}]}], "+", 
         RowBox[{"A3", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", "\[Pi]", " ", "\[Omega]"}], "]"}]}], "+", 
         RowBox[{"A4", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"3", "\[Pi]", " ", "\[Omega]"}], "]"}]}]}], ")"}], "2"]}]],
     "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"A4", "\[Rule]", "A1"}], ",", 
      RowBox[{"A3", "\[Rule]", "A2"}]}], "}"}]}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.68805330845961*^9, 3.688053341261039*^9}, {
  3.688053524093576*^9, 3.68805361708456*^9}},
 CellLabel->
  "In[3255]:=",ExpressionUUID->"da8b0209-b769-4439-b4f6-6cc4f4a2ea9d"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      FractionBox[
       RowBox[{"\[Pi]", " ", "\[Omega]"}], "2"], "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "A1"}], "+", "A2", "+", 
       RowBox[{"2", " ", "A1", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"\[Pi]", " ", "\[Omega]"}], "]"}]}]}], ")"}], 
     "2"]}]]}]], "Output",
 CellChangeTimes->{
  3.688053343065906*^9, {3.6880535459891787`*^9, 3.688053561655279*^9}, {
   3.688053597447771*^9, 3.68805361742887*^9}, 3.6880553385972967`*^9, 
   3.6880584209363747`*^9, 3.688059336939803*^9, 3.688059989772913*^9, 
   3.688069618318239*^9, 3.688069858774762*^9, 3.688102354824902*^9, 
   3.688102494687789*^9, 3.688596641409506*^9, 3.7205501841295567`*^9, 
   3.7938438051049967`*^9, 3.793843918595245*^9, 3.793844020711721*^9, 
   3.823229567208971*^9},
 CellLabel->
  "Out[3255]=",ExpressionUUID->"7a7f6116-d00f-430c-835e-f42369008e98"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v4d", " ", "=", " ", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     SuperscriptBox["v4", "2"], ",", "\[Omega]"}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.688053642452408*^9, 3.688053671373495*^9}},
 CellLabel->
  "In[3256]:=",ExpressionUUID->"4b8f2eb7-4021-4a09-8409-8b032c113380"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", "\[Pi]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "A1"}], "+", "A2", "+", 
    RowBox[{"2", " ", "A1", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Pi]", " ", "\[Omega]"}], "]"}]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", "A1"}], "+", "A2", "+", 
    RowBox[{"6", " ", "A1", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Pi]", " ", "\[Omega]"}], "]"}]}]}], ")"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"\[Pi]", " ", "\[Omega]"}], "]"}]}]], "Output",
 CellChangeTimes->{3.688053671998164*^9, 3.688055338667296*^9, 
  3.688058420980524*^9, 3.688059336987731*^9, 3.688059989819165*^9, 
  3.688069618359952*^9, 3.688069858836955*^9, 3.68810235487449*^9, 
  3.688102494739585*^9, 3.688596641458064*^9, 3.720550184202753*^9, 
  3.793843805144168*^9, 3.793843918621274*^9, 3.793844020732164*^9, 
  3.823229567235323*^9},
 CellLabel->
  "Out[3256]=",ExpressionUUID->"6353c665-9cd9-4cff-9410-4cfa055309e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v4dd", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"v4d", ",", "\[Omega]"}], "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.6880536818757133`*^9, 3.6880536924072104`*^9}},
 CellLabel->
  "In[3257]:=",ExpressionUUID->"bc1cbc2c-5714-4921-94f1-281e1cb23204"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  SuperscriptBox["\[Pi]", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"A2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "A1"}], "+", "A2"}], ")"}], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Pi]", " ", "\[Omega]"}], "]"}]}], "+", 
    RowBox[{"A1", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"8", " ", "A2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "\[Pi]", " ", "\[Omega]"}], "]"}]}], "+", 
       RowBox[{"9", " ", "A1", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"3", " ", "\[Pi]", " ", "\[Omega]"}], "]"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.688053692994576*^9, 3.688055338733839*^9, 
  3.688058421045126*^9, 3.688059337052628*^9, 3.6880599898845882`*^9, 
  3.688069618426543*^9, 3.6880698589046803`*^9, 3.68810235494128*^9, 
  3.688102494805052*^9, 3.688596641526462*^9, 3.72055018428693*^9, 
  3.793843805179636*^9, 3.793843918664712*^9, 3.793844020768116*^9, 
  3.823229567276883*^9},
 CellLabel->
  "Out[3257]=",ExpressionUUID->"4ddfa4b9-a6da-452d-b81e-7a0e4e737bee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v4dd1", "=", 
  RowBox[{"v4dd", "/.", 
   RowBox[{"\[Omega]", "\[Rule]", "1"}]}]}]], "Input",
 CellChangeTimes->{{3.6880537793471518`*^9, 3.688053784992792*^9}},
 CellLabel->
  "In[3258]:=",ExpressionUUID->"de9af7fc-c970-46cf-983d-00d1f3e2e76b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "A2"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "A1"}], "+", "A2"}], ")"}]}], "+", 
    RowBox[{"A1", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "9"}], " ", "A1"}], "+", 
       RowBox[{"8", " ", "A2"}]}], ")"}]}]}], ")"}], " ", 
  SuperscriptBox["\[Pi]", "2"]}]], "Output",
 CellChangeTimes->{3.68805378552841*^9, 3.688054251713924*^9, 
  3.688055338764874*^9, 3.688058421081555*^9, 3.688059337108083*^9, 
  3.688059989913743*^9, 3.688069618478107*^9, 3.688069858953906*^9, 
  3.688102354972621*^9, 3.688102494857102*^9, 3.6885966415743017`*^9, 
  3.720550184369491*^9, 3.7938438051850443`*^9, 3.793843918670567*^9, 
  3.793844020773952*^9, 3.8232295672828703`*^9},
 CellLabel->
  "Out[3258]=",ExpressionUUID->"8fd6ab8d-386c-45c6-8eb8-75667e0c2f5f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"v4dd1", "\[Equal]", "0"}], ",", "A1"}], "]"}]], "Input",
 CellChangeTimes->{{3.688053803906773*^9, 3.6880538122974243`*^9}, {
  3.6880542383379107`*^9, 3.688054257296219*^9}},
 CellLabel->
  "In[3259]:=",ExpressionUUID->"199005b4-be87-4577-bdd1-c60850db7225"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"A1", "\[Rule]", 
     FractionBox["A2", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"A1", "\[Rule]", 
     FractionBox["A2", "3"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.688053812772146*^9, {3.688054239170512*^9, 3.688054258206002*^9}, 
   3.68805533881598*^9, 3.688058421132125*^9, 3.688059337175281*^9, 
   3.688059989973898*^9, 3.6880696185295763`*^9, 3.6880698590032663`*^9, 
   3.688102355023419*^9, 3.688102494905706*^9, 3.688596641624837*^9, 
   3.72055018445337*^9, 3.7938438052187567`*^9, 3.7938439186959057`*^9, 
   3.79384402079596*^9, 3.823229567309827*^9},
 CellLabel->
  "Out[3259]=",ExpressionUUID->"945be0c1-5f1c-44de-b3ec-a7c94cadebc5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v4s", "=", 
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"v4", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"A1", "\[Rule]", 
           FractionBox["1", "8"]}], ",", 
          RowBox[{"A2", "\[Rule]", 
           FractionBox["3", "8"]}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Omega]", ",", "1", ",", "4"}], "}"}]}], "]"}], "//", 
     "Normal"}], "]"}]}], ";", "   ", 
  RowBox[{"TraditionalForm", "[", "v4s", "]"}]}]], "Input",
 CellChangeTimes->{{3.688056314186666*^9, 3.688056386958033*^9}},
 CellLabel->
  "In[3260]:=",ExpressionUUID->"35773e25-bf7c-4f6c-b667-5ab9f14c8b3b"],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "8"], " ", 
   SuperscriptBox["\[Pi]", "3"], " ", 
   SuperscriptBox[
    TemplateBox[{
      RowBox[{"\[Omega]", "-", "1"}]},
     "Abs"], "3"]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.688056349737945*^9, 3.688056387485455*^9}, 
   3.6880584211819887`*^9, 3.688059337241081*^9, 3.6880599900395813`*^9, 
   3.6880696185786943`*^9, 3.688069859052525*^9, 3.6881023550748587`*^9, 
   3.6881024949569674`*^9, 3.688596641674191*^9, 3.720550184608405*^9, 
   3.7938438052830677`*^9, 3.79384391876667*^9, 3.7938440208605623`*^9, 
   3.823229567380435*^9},
 CellLabel->
  "Out[3260]//TraditionalForm=",ExpressionUUID->"e976e547-618a-4990-95d5-\
e113386dad4c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"v4", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"A1", "\[Rule]", 
       FractionBox["1", "8"]}], ",", 
      RowBox[{"A2", "\[Rule]", 
       FractionBox["3", "8"]}]}], "}"}]}], ",", 
   RowBox[{"\[Omega]", ">", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6881031884421873`*^9, 3.688103214930773*^9}},
 CellLabel->
  "In[3261]:=",ExpressionUUID->"40fd6b3d-91bd-4ec1-8023-164660ea6fa7"],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"Abs", "[", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"\[Pi]", " ", "\[Omega]"}], "2"], "]"}], "]"}], "3"]], "Output",
 CellChangeTimes->{{3.688103205130248*^9, 3.6881032155322742`*^9}, 
   3.688596641721651*^9, 3.7205501846886*^9, 3.79384380531586*^9, 
   3.7938439187922297`*^9, 3.7938440208807096`*^9, 3.823229567405168*^9},
 CellLabel->
  "Out[3261]=",ExpressionUUID->"e952be94-40b4-4e19-881f-96c69c7baff1"]
}, Open  ]],

Cell["\<\
Graphical summary of residual amplitudes as a function of frequency about \
\[Omega]=1\
\>", "Text",
 CellChangeTimes->{{3.676147586319213*^9, 3.676147638502285*^9}, {
  3.676147927704694*^9, 3.6761479413907433`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"8a21faa1-7e14-4f12-8184-ce26787756c5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"v1", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"A1", "\[Rule]", 
         FractionBox["1", "2"]}], ",", 
        RowBox[{"A2", "\[Rule]", 
         FractionBox["1", "2"]}], ",", 
        RowBox[{"\[Tau]", "\[Rule]", "\[Pi]"}]}], "}"}]}], ",", 
     RowBox[{"v2", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"A1", "\[Rule]", 
         FractionBox["1", "4"]}], ",", 
        RowBox[{"A2", "\[Rule]", 
         FractionBox["1", "2"]}], ",", 
        RowBox[{"A3", "\[Rule]", 
         FractionBox["1", "4"]}]}], "}"}]}], ",", 
     RowBox[{"v4", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"A1", "\[Rule]", 
         FractionBox["1", "8"]}], ",", 
        RowBox[{"A2", "\[Rule]", 
         FractionBox["3", "8"]}]}], "}"}]}], ",", "0.01"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", "0.8", ",", "1.2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0.05"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{",", ",", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Gray", ",", "Thin"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.720617344734542*^9, 3.7206173731655083`*^9}},
 CellLabel->
  "In[3262]:=",ExpressionUUID->"8e8571ac-1b5a-4492-9131-79cc901cebfd"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw903tME3YQB3BeOlAHbUi3ZhMEjDjn5NFRUIJ8i3RQMBTtJi1QWIVJu4VZ
dIznBEYHBSW4UiQUCnS4oaukWnktTleDj5A47JQ6sqECw8RhdL8f27Dadmz1
n11yuXxyyV1yyYUWKEUHvDw8PGLd+aJmLoSmhzj/QJfuRXyLAtbV7w6yCdYk
pNZ6XxjAdt5NjklCkBLuva2q2ICdT3aYsnoJulwKMvKWFoa9H9py+ghqYqSm
k8/b4DXa6cg3ELACd+zXXG/DRI09Rd5PcHY++mSxrA0ixshs+QDB3LCpO6xd
g6K3o5g6E0Fdme4p234crZXhpTM/EKisZ83m9mbQe/u6Zi0Ed6TM00cjmvHu
robLC5cJWuSK1sKJJrDXPlj3eJxAK3BuZbnU6Nd/9Y3rOoE4+ba5vLARY5b1
00FWgsXD3NB4jgpzqwLjZbMEuXnGweK+SgQwSvjvzxHMqwRjwdMVSHxtUpg/
T7A3zXz+J/8K6CPUhdIFgqnOySMxNWXIFjtbJA8JHi12HXZKP8Ht0wuzewiB
5NgZlT/3I3gO8R5lUoK4ldhNh75WIOpSz9/CJfc8/eDYVKAcrbfEfhl/EWwU
bBnq/LMQux03OGl2AvWvdYl8WS6qfLbsFDwj6Fg9c80XEhj9G1NTnxNQWV7i
ZNA++G7kSd9xElwRrWYNjmYgbltPEd9F8KbVfiWmNBVFcY6S5H/c/fqjH1yK
TsKJJHH1rhX3/YI4y8fuc3F193BD0r8EJ8KebY4fCoPD6CsI8aC4lWLuaM3x
AzMqbrLP7Sz/rSWfyyLxxsgB0QZPiuSmNm0kNwG8+PbpXrflyXMRAXl8SCzj
0mAviiVaq27sS4eSvzTf4zZzw+8PV0r2oFcofKz3phDoghllQ1kYnfrs0Hof
irTz731ptmVjUnLmabfbjoSLHk+WpXAV+Hp2r3LvG4i9E63fj9zycZbuJYoC
3r3lU/flsE0YFZoAinpzU0V8aQUo467ldQbFbzljteqMSqzLfvnVAbfPnTOW
2sKrwF9UXrvApFA7izcd/KUaw37csAeBFK8oeRpDYi206ZaZWDbF90zNF3U+
Koh+nBLeDaEQb19k/3yzGVarK2YzhyLyiDWt36yFrqWh+WMRxcWUG5kdEQZU
r7HkKz6lsDt46uNrT2HJu92mrKf//9N/lRSkhg==
       "]]},
     Annotation[#, "Charting`Private`Tag$1324322#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw913k0F+37B3AppaIoS5aSJaG+lh5bYt7ITrIl2Sm7ZEvWpJAkLbImS8mT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       "]]},
     Annotation[#, "Charting`Private`Tag$1324322#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt2Xk0Vd/bAHANhsicIZQMyZwps/0YQpnKPE+RZAqJTCkkUYaQCKHhK2QK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       "]]},
     Annotation[#, "Charting`Private`Tag$1324322#3"]& ], 
    TagBox[
     {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/b3n99yZM1/aV4usc39Y1WIf5m1bfmgngr+Vsz7g
9U0EfxFHCssy+Vdwvm7xthMHExD82wFFM6YtQPB3bujPvPIUwTepkfIuVnsN
5987yaZXnYPgr+mKkbHZiOCLb5eXjvuI4G9KdZF+afYGzn9Vf037ajmC78Z7
yb1qO4J/UUY/teMPgv9r+s9J323ewvlBU1UPnW9C8M+y7v6TcBzBf/Zwr3sw
+zs4X89Baco6HwRfhOvLh6xeBF8zTN1/wmUEP0n0yI48ifdwvoXDOaN1EQi+
7VvLdWHzEPwHrMJWCfcR/CsnVmVM5P8A558//8dE3QjBn9nT2pkbhOBXc+2P
yyhF8N87rt25fzqCb6h/ac7x7Qh+993lDC23EPwtjlvefPiF4OfFl8btkvoI
5zvYPQ+wsEXwH17qP50Wi+DP0nh5zLMBwVc0qfS6uwDBt/q5N/jsAQQ/u37z
3cLHCH7W7vvvjzF/gvMbd+xpuqCG4Gvl+80280TwF90Ws/HNRPANOSfESvQg
+P1v7NmnrEHw6zuXmOWcQfDbnu989uMdgh/zm1XejP8znF8gxbLCRBHBb7Fk
MjQ2RvABu6KWow==
       "]]},
     Annotation[#, "Charting`Private`Tag$1324322#4"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.8000000081632653, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.8000000081632653, 1.1999999918367346`}, {0, 0.05}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.688055188686957*^9, 3.688055338902667*^9, 3.688058421425581*^9, 
   3.688059337330185*^9, 3.6880599901275473`*^9, 3.68806961884466*^9, 
   3.688069859141591*^9, 3.68810235534212*^9, 3.688102495047978*^9, 
   3.68859664180727*^9, 3.720550184952105*^9, {3.7206173475210533`*^9, 
   3.720617373676455*^9}, 3.7938438053631983`*^9, 3.793843918830928*^9, 
   3.7938440209177837`*^9, 3.823229567467573*^9},
 CellLabel->
  "Out[3262]=",ExpressionUUID->"914397f6-683f-442d-883b-e12226e9d841"]
}, Open  ]],

Cell[TextData[{
 "A note on statistics:  assume that \[Omega] is a Gaussian random variable \
with mean 1 and variance ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Sigma]", "2"], TraditionalForm]],ExpressionUUID->
  "2813a322-7d48-4db6-9ebe-929a5fd7240f"],
 "\ncan transpose to \[Delta]\[Omega], which is Gaussian about 0.  Need \
moments:"
}], "Text",
 CellChangeTimes->{{3.676147586319213*^9, 3.676147638502285*^9}, {
  3.676147927704694*^9, 3.6761479413907433`*^9}, {3.688056654692391*^9, 
  3.688056724834689*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"eedf8250-f2ac-4840-880f-221c4692d1dc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expectation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       FractionBox["\[Pi]", "2"], ")"}], 
      RowBox[{"Abs", "[", "x", "]"}]}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["\[Pi]", "2"], ")"}], "2"], 
      SuperscriptBox["x", "2"]}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["\[Pi]", "2"], ")"}], "3"], 
      SuperscriptBox["x", "2"], 
      RowBox[{"Abs", "[", "x", "]"}]}]}], "}"}], ",", 
   RowBox[{"x", "\[Distributed]", 
    RowBox[{"NormalDistribution", "[", 
     RowBox[{"0", ",", "\[Sigma]"}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.688056730740279*^9, 3.688056811772448*^9}, {
  3.688056881809506*^9, 3.688056905512719*^9}},
 CellLabel->
  "In[3263]:=",ExpressionUUID->"fb0b3838-b393-4ecb-b637-4ea54edc8b61"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox[
     FractionBox["\[Pi]", "2"]], " ", "\[Sigma]"}], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["\[Sigma]", "2"]}], "4"], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", 
      RowBox[{"5", "/", "2"}]], " ", 
     SuperscriptBox["\[Sigma]", "3"]}], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.688056772667304*^9, 3.688056813801971*^9}, 
   3.688056906302964*^9, 3.68805842277367*^9, 3.688059337523039*^9, 
   3.6880599903171787`*^9, 3.688069620250969*^9, 3.68806985932495*^9, 
   3.688102356593298*^9, 3.688102495374848*^9, 3.688596642263517*^9, 
   3.720550185391696*^9, 3.7938438056402817`*^9, 3.793843919033325*^9, 
   3.793844021118203*^9, 3.823229567734479*^9},
 CellLabel->
  "Out[3263]=",ExpressionUUID->"0d7d8e95-a523-4f5c-83fd-133d71fc6ed0"]
}, Open  ]],

Cell["\<\
Simulate dynamics assuming \[Omega]=1 but actually \[Omega]=1.15 using naive, \
ZV, ZVD, and ZVDD\
\>", "Text",
 CellChangeTimes->{{3.676147586319213*^9, 3.676147638502285*^9}, {
   3.676147927704694*^9, 3.6761479413907433`*^9}, {3.688056654692391*^9, 
   3.688056724834689*^9}, {3.688058432724813*^9, 3.688058497919837*^9}, {
   3.6880585827149897`*^9, 3.688058584234901*^9}, 3.688059095568413*^9, 
   3.6885969813482428`*^9},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"c31e7ed1-f095-46d6-837b-c21f4de14059"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmax", "=", "30"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Gtf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"s", "/", "\[Omega]0"}], ")"}], "2"]}]], "/.", 
      RowBox[{"\[Omega]0", "\[Rule]", "1.15"}]}], ",", "s"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uNaive", " ", "=", " ", 
    RowBox[{"UnitStep", "[", "t", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yNaive", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Gtf", ",", "uNaive", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"uZV", "=", 
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"UnitStep", "[", "t", "]"}], "+", 
      RowBox[{"UnitStep", "[", 
       RowBox[{"t", "-", "\[Pi]"}], "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yZV", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Gtf", ",", "uZV", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"uZVD", "=", 
   RowBox[{
    FractionBox["1", "4"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"UnitStep", "[", "t", "]"}], "+", 
      RowBox[{"2", 
       RowBox[{"UnitStep", "[", 
        RowBox[{"t", "-", "\[Pi]"}], "]"}]}], "+", 
      RowBox[{"UnitStep", "[", 
       RowBox[{"t", "-", 
        RowBox[{"2", "\[Pi]"}]}], "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yZVD", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Gtf", ",", "uZVD", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"uZVDD", "=", 
   RowBox[{
    FractionBox["1", "8"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"UnitStep", "[", "t", "]"}], "+", 
      RowBox[{"3", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"UnitStep", "[", 
          RowBox[{"t", "-", "\[Pi]"}], "]"}], "+", 
         RowBox[{"UnitStep", "[", 
          RowBox[{"t", "-", 
           RowBox[{"2", "\[Pi]"}]}], "]"}]}], ")"}]}], "+", 
      RowBox[{"UnitStep", "[", 
       RowBox[{"t", "-", 
        RowBox[{"3", "\[Pi]"}]}], "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yZVDD", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Gtf", ",", "uZVDD", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"yZV", ",", "yZVD", ",", "yZVDD", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1.25"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{",", ",", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Blue", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.688058529957645*^9, 3.688058808272681*^9}, {
   3.688058839049675*^9, 3.688059077586488*^9}, {3.688059887637912*^9, 
   3.68805995475959*^9}, {3.720617298713381*^9, 3.7206173062297983`*^9}, 
   3.720617337541553*^9},
 CellLabel->
  "In[3264]:=",ExpressionUUID->"290cd922-4c64-48fe-9f9b-c05e29057478"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwUmnc8le8bx+0VsrL33vNwaF0XaaFoEFKKtCg0NFSEbCIpFKnMlGigzG9K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       "]]},
     Annotation[#, "Charting`Private`Tag$1326749#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwUmnc81V8Yx8smlOy9R+blclFynsySJCtJklAh+yczklK2zBQathIqskWU
mZXIjBTKvbcyG/xOf/V6v7j3nvM8zznfzztX3MnLwoVm27Zta3Tbtv37d3Wy
45VUbJ7uQzGeG6Yex/YP5fAFHRiJRKp5vtzu55d0gfutE9/ILdT84d2Q2Ck2
xDPGwbzL4C4ySvbr+B0phgLMS97TjjxA0i672p1OKKEzT7tKtuIL0fHmKRH2
JRIy5VkK+63/CO0gLJcoXgF0Vye66HdoOQLvKjfJACPEQea9tfG+Eh2guSB0
wPoIup5bFLKm9hz5HFFulUu0QH/MtV1W4qtRX27w/sR5G+RL02n2c74G9YR5
VT2rOonmn9ppfdevR7/49cJrQh2Rg8tXcUpOI7K2S6k+ZnsWue1ovLYa2owE
+9vzdnq6oql6M6/l9y2I74Xe6VzjiyiLm9fZj/4VCjzZ55dzzRtZeU7Z/lBr
Q589uJKPRPmiTlFvPWr8a+TSs5i7ayQAXQvU0vSqe4MsJJtu0SkFIejfpkie
70AdTS7PbueEoKrIZO5v+t3o4PigZ5l7BPIeO8Hi7tODDmY9P6L29gpSUJfY
WsjpRVuBS77TcBX1+Z5Y/hnah7Kq53ISza4jI6nFie/vB9D3AxeMNjniUZ65
mW2F5yAy87g/ljKXgLaHVQ540w+hNM9bQkFnk1D9u+DXFLV3yOCRuuuFE7eQ
avSOiqX49+hyvML7nvR0lPDUS+Gx1Ai6c/lG/XJVBvo2NZjvUTeCHLiTvFsn
MlGB1t2sr/Oj6FGj2lESuoOEFhWjFvTHkVfQY84DcvdQME/yZtGHcVQ3GuEW
PHAPvddbCTzvM4F+qAsfnQ2/j27dabj4JWcSyXivxKl8eoCiZApLf4ROo7DJ
FimpgXy08V4zjfp+Bn3cGlMt032EXqgxORbumUX01xuOzio8RgHxI/IOIbOo
m/lMrYdQGfqhF9TcJfIJ8TVmZjymLUeLj2u/FrjMIR6/lL7J7ZVo/Op+vVM/
v6AdEZU5ocZVqFlFn9LBvoSIhSkjF4ab0OUYztoIxyWkqd3O9EKnGenMzUZp
Vi6hwZqLf1oSmlFNVpRAvjUZjZXL+biov0SV9O2GEXcpyC8jJzjxWgsauChl
Jsj9HUH0ptCyThtq1S/M63/wE3UdPzCDvnYiQsKThbU3P5Ec164dywe6UM5I
tbII5Sf6ontvuCuzCwVefPPCbd8ymt54Kjpu1I2UMxa6aYeWkWuj71/NvB6U
taiwokG/imrumZLeEvqQd3K5Yda5dSTa/j4waXEATY69iGmOX0eK0Scci7gH
0WGZl28/P11HTAvZrMUwiGTq+k8Qt22gJ/Ct8nT6IBr79ONid+YGonWPuBgO
Q8hISyN9s+MXIihnH/NNeIeEpmo+Oyn+RVzd32wKmUbQtp8+mR3H/iKBZZ+9
9Uoj6BODvAnh0l+UwUbakW4xgh4rZz3++/Iv+tgzczL1zgjSvRzsn3l8Ewnf
ymPLlR9Fp4X30fRGbqH9F8pPMOt8QAaqP5+qF22hhgNxdT/tPyA5w1KXOz1b
yNbrkUlK2AcUWBXvrM66DVqCE4zJDR8QTP59vf34NoiRKxH8tXcM9StNJtz9
tg1+lB+1eSA9jl5p1n45urUNAg0P/fY/MI6qDqQD7e7tcG/UQopiP46yrM1+
XNDcDpSsrxPDt8aRU1ijtWbkdsiQLief+jWOrKKzyhZTt8PJIK4WG84JfE8F
MOYUbodtc1k03xUmkHy+cg1dz3ZYa9nQYbTHc9ydIzTASwPvB3yeFVVPoE/D
wf9dk6eBzyIn2O/0TKDhaZterf00sLBtb82e2QlUu8weketEA8OGQ378bJPo
qlD4rMdjGgjf7/meYD+JAmRO6og104AfMf7MsuckOk/QTBscoIF4hee5R69M
IlMDitHedRogsRw/2pU3ibg8Tpcw6tNCyKiTSOfnSSTP+LDd/DgtCKft239j
bRLBg88zt91p4UpEG+9rxinkMXJRUDGVFoJLmZNeyUyhSL8Kzf+KaCHgZy5t
pMYUymRfsWyspwW7JUXaRv0p9MogNM58jhbiU414yx2m0IeppqLbG7RQteuM
s4v7FKIG07bNsNFB6Hh8WcalKSRUEfPXn0QHSdv2lvokTCE1017+RhM6qJM1
Tue7PYUOfuEgMZ6mA02dSMreh1PIX/i25+1oOhjtzD5FfT6FYl6Mx8zcoQMm
FtbSyMYpdM9SrFChnA6shWQ+JrRPoSry2Vb/V3TwkCu7m6t3CnXfLJxqGKGD
j14kA653U2hG6utvhiU62CqpFokfm0LrTcp85tvp4aveZ7Xwj1OI/aSv+m1u
ekh9Fn188fMUklp9bj6zhx4WQ8+c7f06hfYmb3go6NLDGJ+2kgJ1Cpkr7r/p
b0EPtvRDsduWp5Dr64j8Bld6ONq0Zm22NoVCnV69ZAihh7LWC05cv6bQrb+M
k0cT6cElkRJt8WcKFWUe/pX5kB6cc82ymTanUCMxkWemmh5+k3eEk7am0GDv
gJpCNz3oJnSqjGOev8Bz1H+aHhQPlr/cwLxJZ+fesEwP6u5ko0TMXPeyoxmY
GaDRsKr/Ln4/+X0fHx4VZgBNGW1/ib9TCIalmjNVGYD5ZBGI/Z5CNj7nxz8a
MkC2msah9HXcf9ZH6/J2DOD0e9e9qBXc/0IKl78nA7ykvXj863fcfz2iakMk
A0hlBV/pXJpCZRMBRxgyGGCd1Z0gsYDnIbD2wtFSBigo8Qr4MYvngXPzWmYT
A7B0F7jsm8TzUHbgwcdBBuDe+Ubx7/spxGByrVF+ngGu9/EIavXjeYhgXavf
xQgKwvRPBFrwPAiaczJIM0LR2xsrLTVTyKEqReWoNiMIHqXJnyvH8/BN4PzH
M4wQTJsbcScbz0O0Q5R8ACM8Ol1wRCUFz4PEg3t+MYxw/r17m+4N3H/bPaP0
TxmB+fzGar837v9PjxWz14ygWZR/zMYZ9z+xnCNzjBG6ucYyjx/H/W7TNJGn
YwKD1S+zA/tw/1SN6sysmSDygKR23eYkUhk7Ybz/PBPE/30WY0mZRN1RFwcV
QphANLFRO2xqEjGMpH5lus8ELnXcftcbJ1HI5VnB1m9M4JvhV3j50iTik1sr
rNhiAols26wnzpOoqp9F/d5uZpgT1f/537FJRJVSMw3TYoYx56pgD/lJ5NwV
EaoZxQzBr+nnfnycQNv/S2WSyWCGRrmSMon+CZQjUpTKVcIMvlPlwqPNE2jE
5+2j72+Zwf67+9DY/Qn0n+Cs1vQMM/yq+cS2J2UC7W5bfdW7wgxHrCaaN6Mm
0BE+kYlSQRZ4xpEvZOg2gRZfql7IUmaBkOOCMVWnJtANd8OVGwdY4NVDp18V
xyZQS6MHm+s5FpjcfsPq4L4JdPp8xG2rYBY44358dJYwgf5wpErrx7PAN6p6
AYvsBCK51O0Xe8oCq5uv4DfXBBpkf9vB3s4CAubD99pYJ5D3ixnrvyMssPvL
OQch+gnE5rT68etXFohbIpVu/R1HJTtYPD9ssoAz5+oLr7VxZPxc+Ncbjh1w
icm2xuP7OPrkoHq9WmoH3A/dObn6dRxFMhnuLtDcAf9tcB5n/zKORCttc1JN
doCAloHh05lxVH/SQ/7qqR0gG1/1cm5yHNnRR1T5eO+Ail7vufyxcbRWlqLn
eHUH9AwEdvwcGUeptoW9Zuk7INlr6Prb4XGkSlNnt78Yv/8JRg3td+Oot7T3
s0L9Dshx7RwnDI0jd+sZX4G3O+BqpP/lqsFxxLS1ssk0swNSRQ0EOjHnFzHH
ri3vAL3yS+Xu+Pf1LIR5PzOywvbCIwfu4Peb+k14OCTACoZKloO278dRaL6B
SqsSK9Qerj+fNzqO+I/a1lUAK2SZKE2FjePn2bq78T1LVtD9emL33NQ4snwQ
Ppjgygp0lJWJ0dlxRD2ccjosiBWMeZ8L28+Po/iVgq/ucaxwRvrwY/elcSSf
W3vJLpcVHn9wP8/0cxy9PthLe6iSFW6sd8qrbYwj5x8fEzXbWMEMhPrmt8bR
9rsrgjIjrHDcj1NdkRHPnyFzEddXvH5LZ7U/7BNoNJPQ/H0XG6TZihEPiE2g
rMHSnQHSbOBe75Z0XX4C2bHLnv6lzQZiDckvvDQmcP4S3qQ5ywb5hY8aFY5M
oOzGzCPRl9igRkDn9d8TE8hhgzN7RxwbqOyfovicm0DTniw6XM/Z4OWDjFVd
PL/3i6/FZnawgaTXwa10PN9On7aNCU2ygf6Di/6JD/Hz98RakDQjO1hRapVO
t02geYNP1aQT7OBWeqX+3K5JVBx+mrHuIjtcFH1lVSE1idxqP9igSHYolX9A
SteeRN9U+leMS9mh3vU4qLjg8ynQSDzxlx26hHOrb7ZOogpr7asTHDthxq9T
5Pb4JPJNejZwRmYnnFPIiNi/OomW6Ut93I7uhINnAuoOKOD7h5rxJOT+Ttif
jJ6I3p1CNQqcW1vPd0I5r+/BRnzfBbsmmEV17gRXoSWfRXxf/hmLWor7uRN6
EgtSf7JMo4jZF9xvJXbBdz0rZnnTaRTVm2857b8L5D6PH9o+No0+uZ8NkQjf
BV2Cm+a/lqaRIbP4Q+ebu6DkMscAYftHxGBw98d89i6wVYurtZT7iG7U3Er+
3r4LxCVVWh2CPqLYvPC3NPwcYPH4WMii9AwyUb+wm1uSA9wupQRu7ZtBTK8s
rGWVOEBRpH3AwGIGRc1Kjx0+wAHX7326fSp8BoVKdH9OvcAB5/qsbCrHZpDn
Pb5NmVoOiDaq/Kx7dxYdu1uhePjkbrip5Uw10pxDvKmzN1OyOaHRf2zrT948
4lN4HrVewAmU+qaNt43zSKDlevipck7osXh/JXtkHolQ9/wn28oJpasu5tKs
C0ja1Nuxbp4TyEznfQZ9FxCR7i9plsgFT3bJCTLoLqKj/jyf1Dq5IGgv6U5D
+1dkvmN+MmOQC5J41NRCJ78iiwc1o3/GuSDwYF2ayOpXZNNn/7adwgXxJmW7
WaW/oVOKD2vtuLkhiOMh96Ur35D7J5XkSEdu8KwLvr1BXELRVod0B1a5YXtP
kZptCBkJPOsVoNnOA2+Y6zm+JZJRGafVmuoOHrDKSSk2ziOj4QGH8mRRHuBv
ACXLbjKSOuYvcewgD1TsSkgq4qegF+UbmxEWPGA+f0z/nCIFme4KHyu35wF1
P57geV3sFW9vpu7y4YFXNqHbCGcpqOVILkPfbR54CVUmLUUUZPNYanbrIQ/o
KweuXa2hoEXWkiaVMh4481L9EG0nBXF0PwtMbOGBwyZbfVqLFORo0rlo9pUH
Rj8dePKCk4qWi4++vrzCA6Et1QzMglQUzfzuYdkWD+QkZCqSJKio7M2UPTsX
L9A7aM9IE6jor9FKb48OL6QJvtttZUJFSQXBpX+NeMFF3oM/ypyKpBi23VA6
xgvvXC+KJ9pQkWkby4F4F16IG1r00XCiommpJOEGL17o33fNtu8cFflFcf/6
FsQLFTrtoYYXqShLX+ypaQIvwKXA2oZLVKT8MD8xNJMXyJ8ZfZtDqaiFRsHj
0QNeINoHP7x7hYoWXmpIs1bzwrJrWPN0DBVpweGMrile4JI+SUi9Q0XduX1+
vxd4IdgmPc8hl4oct6zNFZZ5oVxPOGT7Q7zfRkfmWCY+YJVh7nlbTEUCIp/n
anfzgX+MO+PvR3j/Ye4ti0J8oBrFJbH5hIqGdQJCTFT5QNJ/JDj2ORW53f19
PHgfH7xOmovlfoHr8ztCvcSQD0xDuMUu1eL6nGTg+HCUD7hC3sqW1+P61MUu
MdvxweX3wSnNjVT0QoCjU9uZDxbfX7Ysasb1Ck4vuODJB7WterbnWnC9RgWv
3g7kA7MZpVt/W3G9tO+f7ojkA4aQwu9ubVRkco99+XAcH7gKKwjfaaciCcbQ
G71pfGAXmJtS+JqKNi4uCB3L5QNaWquDSW+oqG/IpmKwiA8ePF9Stu6goqJ9
rwxtKvmA1+rrgVXM4Q9UP4zU8UFUp0akXycV2TDnep5sw/VQXqF2Y1b2ZqWd
7MWcdiyRpouK6N8HZTiO8MFObj8HLszj+78ozH7kg/6WK6f//fxZnlWzy1c+
MH6Wn/Lv9bE7Wqzml/ng7ybDH1/MTr4qC26bfBD+ouf2Cv78vaN3w5YY+eH4
qrinFWYOYNntzcEPXL0KwYl4/fMFlwp+CPADWHM2FeD9NbHN7f1Pih9kvzLo
/dt/ur/F2zUlfjh192X7FVwfQz2l9T/ADzHcWrH7cf0eTMwcYjzHD5yl41Rv
XH97LrMlwaf80HDyt/bbp1REDKm7klPPD5m7alacKqmIZUaOR7ydH1zaEkK/
l1NRzRNaJDPKDx+OW/FuPaYinsM1SYQtfghFjM8mCnF9r0ipGx4WgMcP72dX
ZlGRAeVXsOesAPj5jzhxhVFR0MFU+ZffBKDhayO3ZAier/tKHzhXBUC0v8JS
OYiK+KwctWuYBGG/slXJ3v+o6NuLtjVaZUE4Kl9mrYjPR0pkkv/tQEEwtzW0
iLCnohluGc9XbEJwKjDM0Fqbiq7oHDsjoCUMPtvfTLtPUtBBh5wfmnrCMDC1
3ntqlILYI75etTYVhofcr2iPDVHQ3dZrBUmOwuA/4vFtH74vXpjUfmW4KQxX
2Vw95KooiGorGfBzVBjYh6PXIxIoyOG/lZjuEBHwTmixtNSjIOkMPaHFayKw
VXFTqmk/Ba838TFjkgj8XZM9o6pNQcF/9vTp5YlArV1H/R4CBaVddeCu6RaB
2O9EKU8RCupOfp2bLywKq/Va/7n8IaOUp1yqrbKi0E0dCju0TkZ27860TKuK
gjrzsC5pmYzm+f58EjQShU2r/4Llv5ER7T2C/C1PUaCrkQ+4Mk5Ge8tuP7vc
JAoeJedV6JvIyOB971/yG1GwUJbraqojI7NtdManB0RBqfdMw9UXZHTWwnMU
zYnC91NPWeQqycgoRDw8gl4M7qUxP/+UT0ZdO+sfarGIwe0+mpvfHpCReZ7N
Gyq7GDw2u+e8mUtGJ3tiOc7wiYFJgF00ZJGRt+jqwwMKYhAl0d0J+Hmw8jTp
zYaKGHhKzyvciSOj4IMKSxXqYvBKpWf/thgyuubjSJLQFYPVjejXi1FklNXa
+YbmmBiwm2fb6+Pni6ity1KttRicHzY6uBJIRnnftjj87MTg10cbn8oAMnrC
rXFy9qwYyHrINpr5ktGrc7lLrQFi8DpzmZPDjYwO/dHeHRoihn3Fvk7kPBn1
Jg2R1CPEIK0kXUzLlYxGa5gj8m6KgVUQp02CExk5mOXl2SeIwRiIoi5HMvo0
o9vBlSIGf6wTeblOkxF5h//ua3fFIDZZ+U3HSTLyu8euuf++GGh2y9SQ7Mho
Xb345Eo+Xl8od9cTW9wfh8k8lydiYHzh/NV2azLiKz+oadQiBtl5zleizcko
22D25Ga7GIjYhlfYHCUjidGwiKouMWDKe3lMzYyMlGiedsi8EwOxrhianaZk
VJl+hDw5KgYWN9cldh0mIy2F+d0Zk2KwnH9yUNiEjPSshO0Z5/H+mt/Snj5I
Rq/nqyOavolB+v3XKbeMycg0zCL/0ncxIPmRBwaMyGiAY6lDZVUM5+e7baKY
jxdEk7/8EoMND4JXkCEZje+V4Ly3JQYHZBkGpwzIyOltvaYtnTiw24YsW2D+
cva4/S5mcUjQXhoe0Ccjj/XvEW/YxIFKXxN2GvNeH1eez7vFodX25ieqHhkx
LX4opeUTh824IctkzMNORw+IC4uD+vXZt4A5f6x1WFdCHFZlt+y3DpCRv5WW
h72sOHyw9t7qxqzX82h7sKI43GhiqyvGvMtIPCNDVRwyb9MlpWGebExTfE4S
B9FzVaFJmB9psrQM7BMHqcgr4VmYg8svH6eCOJQavEp/ivngnp/f2IzE4QXT
RPMYZp4H5yIVDovDMTn5P7vxej4JjPMeMheHkL/MxicwV6aYP3a1Foe9Mx9y
yzBHsLbpRdmJQzLhNx0n3u/Ra9oj90+Lw029Dv/rmEU2H19schaHV54Plphw
vb4FSNBOXBCHBS1HjyzMtZT0zF+e4mAWuntxL673jfM7lPn8xcFQUv30Imab
j+GtGkHiIMwHr4pwf6Tslm0tL4uDvGEFRwDuZ/PhiasJN8RB+nuZ8f5DZJTw
6hj/o3hxeGagKq6J58F+f3tZxy1xaAyia0N4XjaUn4zSZYvDFdWbR8KOkNGb
QkkviQfiQB/PKFmJ5y1dLJMOCsWh5lP4/RU8j2q7r6iEVOD1yN5wLrIgo22x
K68yq8TBkTEugdcKnydaN7uqOnGYfBatmIbn233F4tr3Nrx/J7PEOjz/eSNS
Y+c+iIOOr3foU3x+fI/d9r42JQ4/Lr/qTz1DRtDJxvDwkzj47i1WiDpLRhN1
q4RJsjjwH/t1P+4c7kfum+tWtBLQi1Ji9LxxP3j3C/kySYDdXYPVZHzeK5Mq
KhLZJMCPX62P7I/rH5k13skrAVfVE6/2BeF6unioHVCUgHiDtymq+H7ZUNg1
qWQtAWoNjuHWd8hoNVvgCtFOAmTcHxc65ZDR8k5pKe3TEsDd2GIdch+f95/a
bgYXJMBHJm64t5CMZurOrtqFScCfjhCf38/IqPNwNfuNfAn4+7yTz7If31/u
DmhmRQL6l584S3NQUMbE+ZkvvySg4c/YRTduCko96ndtaUsCiLdUBatx/k0g
3uhaZ5aEF/HRva4SFBT5u+L4ThFJeD8pHi+oTkHusfTeOkaSYNBVy1lrS0E6
pY/upadLwqoX88eGfAoaEyvNNbwjCT2xUSm2Jfh5k16cs5wrCWrx0c9Xyiio
+krBXYtiSYieKmwkvaAgNdt7mez1krCv2kipDz/v9tCnJl3/KAm0mYr9elQK
4jkdEhGgKAUdhpZtd4Wp6PlQULi0qhTYysgqUEWpyMok8PKQhhR8u1NarIfz
8S2N/0LVkBQME7Qef5KhIjZWr0DyMSko8ghbEcB5ma7Gydv1khRMZxRMHdCj
ou+7TRxtWqSg5JTUA0YXKhrxkOhzey0FH2YNjh7Gebi5/RcK75YCIYXs2NgL
OD8Gl4oWDUtBgT/Due2eVESYYZ3aWJSChL2ku80BVORZ8fZUNqc0GBmt3g2N
xnltR1FPBZ80hHqnBUfcpCJdl4j97cLSkPNUpCU8Fq+PX1WYIisNk6uBZt6J
VPQo4tY46EhDYxL7bd4MKlo8an3yk7M0RLC9HfPOp6KBYqWu9QvS8DihvUMS
55taWoZ9bF7SYHC8S6y/iIpuVlcJkIKkwZvx0nsBnJflRPk+RMdLw8lZAYYL
OD/tCqIeuntLGgpyhMaWcL5aH3hTU56BX7+o/cwD5+c314Nuj96XBv0Fc7DF
+fkc+YOtQpU0jF575jDXQEVmB5++QXV4f602P7WaqIj0IFbLqlkasjdlZa/j
vMxgo8MX1ikNfdIftdlwvitoyH7fOykNXofiertxPkzgDTCencWvv5wo/g3n
xwAfs+q1eWnY91u0lQ7nT0PprXSxn9LQxNfQJ95NRZ/iHG18GWWAQn2uxNKH
67uoKEFglYGGYvvmWcxrxhtLS7tkIK5oxaC6H+dD2lvXLgjIQNl/9Mymg1SU
6uhwTFZUBupatvayDVGRcKO88JykDBha/tR/g5kQ1PrMUUkGDuj0NCkM43oO
J0aIqMnAfUVN6SHM+ur2puMkGUi4+Ng44D3uJ2V59jjIwFdZUnXhCPYB05dP
uA1lwO/z9U3SKPaPkviQwUMy+PnKvNaEOcxFhvOopQywGIlRGz/g+rT+mGS1
lYHdcz8W1cfwPIk1lXTay0DWgF9sHmaBy7EBN87IgIpqSy/bOBXljR3XM3KV
gVOSfyu8MStrS7HTuctAZZe+Wg/m6nTq6EsvGagxfW4qOUFFsFyfH+4vA9s7
vDd9MXceu+mzP0gGuM+mGdRjtnpivf93mAxc3a8ntIV5glWCuSZSBkaC0yP3
TVKRqxt5KCBaBnL3V/j7YKa+rr2nHicD54oqKPcwB0tHe/xIwvWcqKJ2YKa9
aqlVniYDctum/b9hjpsWpfPMkoHskkdBTFM4j+t+e6uQKwOM2kpbwpjv3Xlx
Z+GhDLQlXWVQwrxnI+pcYRHeX+hAkgbmSptjRJfHMnC8XSdXE7POM+EtiUoZ
2Ks9p0bE3M6x2DldJQNJuWRTOczmXlXpOXUyMNkaQubB/KE70sm+WQYeeT/h
28LrOSt/VFmgTQYivR91T2P+Fi34632HDMzHp+2oxxww96UtrVcGnFPih5Mw
b9N/lmw5KAPhh6uVT2OOuRdximNEBpojNLhlMXNtmu55O47n66987DyuX/ZJ
/pW4jzLQH1eb/BCzTM1cs8lnGShfZ5C3xVzOUxnH9FUGhnYQrRkw7/W/bNtO
kYHWpDNcZbh/rf0mUlHLMsBg8fz8UczDcbN1W3/xfK6ce3cZz4Pj4pPoBhpZ
aC/8+50V84JxqGUIoyyoHeQoS8Xz9IeG++vqLllIKNjJn4zn7brjx6pn3LJw
in3PAD3mnY2PI30FZOF9tTDyx/MqEWQkQJaUhUTJ1YO6eJ4PUS4dmiPJwpEi
akk0Pg9CqiLXmXRkQZgcElqLzw/Z91WLwgFZGDMI4f88gM/T6i4d38OysPau
8a0sPm+Tf4uVt07Lgrt91Yx1D94vMneXcJEFkYLstqP4/F69slpo6CYLz8di
SvWwf8rR64vH+cuC73Olx5zYJ31Zxzn5b8qCboRX89lX2M/MIs11EmTh2j2P
ZRl8f/AmycWfTpEFm1NDUbMvqaie8z+GgmxZSJNN+3IQ3z8MguwbapWycPtk
1VJbDRVl7YFJ0zFZ7PcJP25hH/Rw/yzgPS0LkxKj1t9LqQg9jjueMicL3g6n
Jw6V4PuFMNo3SpEFJ2ScvlCAz5eWb6srnRxEXbx/ci4X98coryhCSQ5aj5xL
G0vC83OWye9ZuBys9dd5aXrh+uQYNDRFyYF9lJEFHfZBymgEY9dNObjK7ZzT
40ZFP45u3PmYIgdO+xdqrF3xfbVv8RV7kRzMq1wV0z1FRTRc3TwX+uRgOi2l
J8KEivhfJdYKi++Bc9dVOU9IUpGRFC9NdMseOLLC4vsKP18XnIyL9r3eA3M+
0CBzn4Li7l8yo3btgSdf3Bpj71LQoMhI1ol3eyB9R90FhxQKcuS/TVSc3wOB
daPc8lcoKIhd0KWfTR6gbLPx0ikKerQu8kbwhDzEn9aS6MXP/6OaRz37TsmD
XNanS+04H/z4L5zrmpM8BKndjGjD+UH755Qj2V0eNuYshUeYKah96d5G82V5
yNYRKLT4RUZTMxIKrnnysJp0afg59r9Icct+gWJ5MNgSvy8zSkYyjlcvvX0s
D6o1cyO573A+n5ht1aqWh7N01mulvdhX3ufZ7+iUh33L66+UXpLR7h6ZhHIK
Xh9T7cY3nHc2KYT8zmV5uH5gRa88j4wWd++r/7QhD9vLQTsc56MW26OLfHQK
oPjs8T3Aecrv0yWjK3wKUFJ/RscK+58jY+SpO8IKsFdHYeIS9j9T+Tj/5xIK
MDApsFF4E+dZ73sPFhQxezLRKeN8NvT7zeaxA/j9GF/sHML5rVlkkNvDSAEY
P+9QcriE8/yBCcXrhxVguu5K2ArOe9eiv9vVWivANaVUelOcD0mcAtUSbgpg
dzRrIAvnRwmSVK+OlwJ8ZTUoTnIhI/YTynM2/grgdjXZLBXnzc85epyxlxXA
3bHctA3n0wx5d6+ftxSAroDv0VucX6OO/HedLVMBMmZFSjWOY7/1Ds+WzVaA
dv1nlGKcdw9WpXSdLFSAA8tikQ04H6uPZs/890gBKm/ofbM/RkZifwo3EisU
4LD0+SEW7HvrB+plX9UpwLt11UO3cP7+5NyuO9msABpbLF/csd/1RfdZr7cp
wMN8sqwVzuv1JR88dncpwPg7N67DOM8X93y6qtinAHeD2J6b47yfTiVnGb1T
gAfBzrtdsO9Fcm5UOH5QgNKWv+o3sB/YnWCbTv2kAM96lb/9wj5hFMq7Vrag
AKquM8kmmNVyxdk7yLheqYoixdhHRFoUpGd/4vd3H0vlwcwyp6Hzdx3X41v5
+i3sM6uMYMm7qQBc3F6mIphn5E3cVGkV4eDn97deYB/qPWJ15TCTIoieftx7
BnOdt0OmC5si8IdX0AhgLko5/yR8tyI8NyxQ/Yh9K7XKt/02ryL4VB5xqMYc
MRo68VRIEbpeXYi9i9njz/XlHnFFMAitr/vnc7aiyTvmZRQhxHXjewpmA707
EjSKirDrqr9yAWaCS762kKoixM2Ye77GLHTjiTmJpAifBAPL1jCXlD1u3dir
CCZSovpqeD1a70pJDUgR5Lbrfw7C3P67uDjCQBGSzjim9WK2kigSMjikCKnL
P48Q/u33YEEio5kiGF0IZsvF7O2VR9NloQhVnt79Arhem2kP/ks4rghrTy0y
HmKOq783f8xeEQTms+21cb0FZnNOcp9RhOGCbpFxzEXM2b0jLorAzLI6Gov9
jkS4c+CumyKwbYfog7h/r2xuPzvtpQhzJd6iu3F/LcIyZCX9FSFdxuzOPObp
h2lZnwMVQSol52cXnoff1OSIi5GKMF9bLlSD5+cGb9JPQrQiyD7bnGzB88Wj
m+C6HKsINgIjjqN4/tRiY0xD0hQhpdjwuiKez+aKG026WYpQsstV8AKeX7OR
62o0uYrgUNpiUYnn2036Kt/NIkVoTnwZ6obnf/3wlVjTx4rQ69N2fNSGjK77
hm/urFSE4pushVb4/DxoCvmUXqcI54Sk/bxPktGHE/7leb2KkMffFrDPiYzO
R/hKnh/EvCJbzOqM56vAO11hRBEuteh/X8DndfeyR2jlR0WwpiTefHOBjEwS
XA42LyvCRrErDxf2v5FnZ+uubijC29YafQN8H7iOnVE23lSE87u+MkYE4PMg
58DVy6gEdC9kuARCyKimxWZ6TEAJQtpNfIbxfWO0YGWZK6oE1nttrp6JxvfP
Tst2JykliOYJzFnD9xPV/uijBSUlCC2byjHA95ncmnHgGihB96JT0uksMspU
0N7FeU4JgscddKIrycj6cE9So7sSjGet/C16jtfvfobDzVsJLKnJLEMvyCi2
5Obul0FKEBHVUGDYREaX93zg8opTgqdHdtqmdpORs2wIf1eFElhto93eNU9G
qpINElf/KMFSIfHSFxkKIusde6i8XRnK3lxZ265AQSVOc5If6JWhm1MsVEKF
gqQesEmr7lSGjzxSAv9pUhCfuIPslLgyjPhy7Dt1kII2RbYU9hkrg0GzdKWw
OwV1ChzQ+JmsDGf5rryOfEpBfSJPZOgylOG/mWrja9gXhyWE+bjvKsMtZT/p
mAYK+ii/8YtUoAzpBdNHs15T0PreiubgWmWIvxnY8HaMgmROipvSzCpDqtKn
JnUaKoq8s/0sh7oKrHPeD0iTp6IbuV5WEtoqwHVKk4VTCfvJwwlDoq4KVNi2
iiaqUNHt0ho564Mq8Hs3R1ikOs43dT7kTHsVKDcYqrLUxfln7GOQ2DUVGFpP
/xB/DOc7oZYklWEVoAmnFR76j4pmJKUmFz6ogGVnT9u7S9jPFK4r5E2pQCzp
1+pgEPbNvSbtfAsq8PPR99q2MCq6dGLg9/Y/KmBSnmcQdo2K7A77EBd3ESCR
4bw2IRXnk6MSdsacBMg65v75ZxrOD5aDEXncBIgqqdj/FPtisZ1Gr4MAAZLT
Yp5K3cF+d2Hj/KAkAWh1As7036ei9BtXcupJBEhrF3ljXIZ9JU6tjV+bAKpX
Jryan2A/TZr9GrCPALGjI/TqFVQ0l2GorQoEmNRc7d3xjIrUC5mH8g8RoCal
PiMU5y2m0tpfNKYEWNy2FdBVS0XjZe7ijmYEeEbLQOWqx/mvqsdTwJIAjyKa
4zMasb+2JTMn2hNAzuZynN0/P+zQI3xzIICKZ6hZGM5/wT0/bQ6dIcDKjT+u
WW1UJP7OOo/WlQCWYR+DWrE/en/iR4FeBLA+/W5fH86TBvOdLu98CGAXG9z+
CudNvm8hcWr+BNCXPe38FOfRpp8To98CCXDyIqq7/JaK2Gkf+J+JJIDaBRLq
wXmWYaPJ8nsUAd5oTizex3l3kzyhdiWaAIU50+5eOA9TPvB/vxdHwPeZ2tDy
Oyqa79PsIyQSoPLtnbJH2A+n262fNCcT4AJNhsEpnKf7KpMvTqcTgFQUeLMI
5+03RU9MvW8TYF9nkII+zuPNOT0K2+4S4DDoeQ1jfpH6lSUphwDjZ06bOeE8
XxHDvCh6nwDnrzu0fMZcEiHb8eQhrn/+4KuzOP8/CDAsQgUEsOfdMh/FfMvp
iuvpUgKwbUptPsb+EGOba0h5TIBBkcOCbNg3Is0apMLLcT36DGudMQcbjNHu
fEoAmXn50WeY/fZuzOQ8J4Chzq6Av5g9CLwtyi/wfh7sSNTFvuMso3G/sZYA
J6hqEoGY7YUsI8waCDD9+45SCWar3T6nJ5sI8DrL/skQZlOmRF3PFgK8exCT
v4bZYPOR8OYrAgwt7GPn/Odzy51/4l8TIN7w+hcZzBqL82PCnQToiA1X+ed3
ytMMdY+7CWB+a/+nf/4nMyyVtf8tAb4qD9P+80ORbr2gnn4CLFw6Fyf/zy9b
HG1PDeGfG/aF8WFmf3FZc2mYAAnK8R828eczlN3lCRslAIf3sfwJzJsPa1dY
x/F8HuybfoZ57fbI0N1JAjxfrU+M+ue7iatPFT8SwOpF5zNTzPPXuFLqZwnQ
3/XIgg3zdIiar+lnAnh48Xi043qN+JgfG58ngNPHWtpAzH3nPAkeX/H8nj4i
JIH5zam4nX+WCHB2z5UXr3B/mi1LyLFUvN4Q5rHTmGsOvekR/EmAnrTb13/i
flaiz49KVwhw6PmnhnDMJRp0cfvWCZDNl3OVDnOWOJic/EuA3odybWt4fm7x
Ouz5uoX7M3HeyBVzDFsoUwiNKgiSq5168PyFbFS3ZzGqwlxy041reD79Ke/y
5VlU4Zf55L1hPL8ecz+jallVQTOgyFsMs32/iv4HDlXQP7zDKgfPv9XrIxJu
XKogIssSMIDPh2mD+/ZfPKqg/TLCYwufn/3FhU38Qqpw6Mb9n/rYB0WuiOqc
kFGFsE5j9UB8/sr8mCQm5FRhr2ZNaiA+n7qu3xnPKKiCm+FFfV98fk8dbh08
T1AFLWObkmPYB+9yn3MP3KsKxhv3W17i+0CRyfzYHx3MXV9y4vF9UfdLSzMC
qUKLbjSfZQv2/SkW2hsGqrD8u5W1C/sgf0lZVoaZKgQnd/N64/uo6G5GhOAx
VXAKM95kxveVVmKEa66lKtxP1H6fXU1Ftv4WaoW2qnAgaSTlKb7f0nVXO6qc
VGHj4/HcTHw/cg3u33gXoAp15M9GVvj+zGuTmToRpArE3xvnU7AfEl/sbJsI
UYXPBvlWPdlUZJH9MWkuQhXq3zm1qWZRUfK5a3IrMapg9a7nWeMtPJ9/uo9z
5aqCa+r2U6uRVMQsbV9l8Rq/fmCiydIR38f8yKS0QxXCn1hLEB2oqJNNYpK2
WxWmr+i932lPRXGrX+if96lCU4HTfy+P4/d742fN+0EVGgJFNRmPUvHzPXZ5
7JsqvElXX5Hfj32+olbNZbca/A1e/GPIR0Wh+dntDVxqcD8sbBuFm4ombkfY
8fCqAU3DUecMTirKiTSKfC2oBka2Ssmf2alIzGqgf4+0Gsh9euoQQU9F0msL
3mRNNfB5IHTlzBwFKe/nf3LplBpwPfx4fD2Lgp5KXvhN46gGXUojHdvTKUiL
pcY4wUkNAuxi29mTKUjvve103jk10B15xqQeTUE2PpkcAz5q0C74/XC5HwWF
5/P6K15XgwdytnapRyiILu5cc/UNNViSOcOyiPNCjG81q36sGrxPKR8xNKCg
VHQ8/0SSGpT9uOu9ax8FFY2mD1/PUoPtf9m+rsjh/MDGo/2xTA2MB1lPSDJQ
kPWyyzWPCjWoZPMQWtpOQR8+PO9fe6oG5BNGZ5r+Yv8ptHZjr1GDKf2+32Er
//wo7c6+VjWY5lZRPjdHRuIBXJtp79UgTe6OMeNrMiqwdzYR/6AGJrNM/Bda
yUhR/1n6o3H8+6t84e9wniLtslJp/agG8aXuV3px3jIpSXGkflWDsMmvRQal
ZOQ7ubvVZBsRXjp29NjdIqM37fYNJTREqF4PScrD+U7kSUE1Cz0R4p/Es21g
X+0M3/uok5kIYvmzN1twPpQQd0oz4SRCtEZf82gYGQUyP0os4SbCebbKqBCc
L3u/r9xk4SOC22ur23LYX4Nbbl7uFCJC18OitTycT/vPVpwzkSECj6mQvZwH
9nPT32dK5IjwJzIjSMaNjELVDe1ZFIgwdenCRcJ5nDfpR807VYhgaja3+zzO
x5eXJA7LqxGh/2zMRBrOz0PvPAxj1IlgX6n59K0j9qeCbXtNtImwYL5Sfu4U
GQ0nmKiX7COCZHfJ9zacvxUvpSqz6BKhZ7jSk2CH87OxnGSnHhFmqXRH5bHf
EhaOspqYEuGe5avNSpz/r/ffZigxI8LpV6w+/tgPxmtmt7EcI8K8hFuA3lHs
FzGXVjqsiYBIRifosE9M+r6k7LElQqgqyWgd+4f6yR2LN+2I4FIoPLeO/XVa
IXfy0Gki8Cc9Py6GfYXEtTBSfIYINofe7zXGPhP3R22Q2ZkIIiyD5GDsPzOf
QnsuuBKh5L8zIXXYj7R62l93nCcC+6X7X5gwJzzf1bLHnQiBjMmaZ7FPfcq2
q795kQgrM/Kendi/9l7Pq1rwIsLTwgsJupiTPMnlh3yJMP3T+E4T9rfPNlql
xf5EKHZpzjiCWQdF5jNfIoLOnZ7r89j/bsl2514IIsJrNTf3JMzzO3myOkLw
53UmHTTErLt+OnXPZSKEbNMRZ8ScOl2ccDOCCFu+ruvvsG8uvvl5YyGSCOrN
LP0VmKFi/9VD14jwm1es7N/fI9NvR4cVR+N5+sqd/M9vv13pv8Qcg/uh6hX4
z2/13AR9L8QRgTbTzukh5kwLF4+OBCJMdjIcacZM3vvEdU8yEc5eekBa/OfD
khuON1OIcMPEXlgcrydrh/7JhTQi6H132nLGTPkZZ30okwgRfHMfnmMeH7lv
k51FhDud255z4P13NlQd/36XCEGvMmmDMVc/6LI1zCWCXeHqKzLmvOjpE7fv
E+EKl/OaF67nLY8Vu6WHRDBz7L39F3P4MRb7AwVE8NA0epSB+2EnqO6wUEKE
0tVyhu+4Xwe3HTq9/zER3nGvoXLcX425U47JT4jwTPlddwju/64n0U7az4iQ
W7fV+u/vl39T7p6Nr8L9c80VlcPztBhY4fzxBRFigsIqpLDPtumNud5sIEKi
wR07PTMyqpSlnptoIkIrUfnsWTyf91jpL6i2EKFjPT8qCc9v8LCy+2g7ESx9
F5fZLbF/1ul7KHXgeTjFouFohf3tnu3FK11EOBz/3LsB+y3BLdJrTx8ROqWt
Gu5gnxU5muEdNoD7Kx3fKITPzw71Rz79Q0SQnwrLKMbn6/Pfd35Bo0Qwug23
PzuQ0Z3kPYEdM0RwJbqf+IZ99kaAbpDwHD4/S5fTOs+RUcBJy2CfL0SQ623e
+wz7rbl0WCj/N7wfz5ibxRfJiKGmL+LCCt6PhvVzAeyzy9lzVxrWiPBX6le1
RSAZfYz8FcnxiwhWvAbP04LJqN5U6lrNJhEOfbp4XiecjHymL91kZlKHX7w3
hlmwzzq0xcWcYlGH+CGamcxYMjItuR9bwaoOQep7T6gm4PvIvyv+BIc6cKv9
3nclBc8Ho+itYgF1eOYZV5KVQ0bGKu1Zh5TUwYv1v4UHVWRky3DQqk9FHa7G
O8xz1pKR20QH23E1dWDkv1GS2IDPZ2xPhLOmOphMfNgoeIXvoy9DruEH8Hp+
7ztybBD77r1ZtefW6qB/d5A16Af2dY7tXWKX1eE/mu4pBeyvqfORUYUR6rDW
Jxz4HD9vCprodJWvqsNTTlKsIWB/vchUse+GOkg9m4kPPERBHJ07M2xuqUPs
Y7lKaXsKuhcpcjauQB3WmbKZgyIpqPHnvt9rvepw6HzE08/9FHS/u9rJsl8d
vhze+TtrmIKi8omdZYPqIChh5muOffbQcYXbLiPq4OPM7dr4iYKGagU0Bz+q
A9XPIefBGgUtXtnwLVtWh/ucvstV+PnNs6t60VlAA/QtxV+yY3/dmFezaBbS
AGp2/Sk7Eva1l2U1gqIaEL9k7Z6nRUX3/QpuDEhqQOa2m+lEnB8U36fJgJIG
/HwhbKtjREV6Of5OgqABnGK2q/M4f3gqqn3od9GAq+fTenSxz/63JvDr9HkN
CNyavnQ2BOeNFloBspsGpLp93LiK/TbW9t0JFm8NsLNV2PfiCs5nUYGjesEa
cH6NpezrTezL440jTxM0wEywkep5m4oWCgvXDyRrwEuGzaaD2Gepvkl8fSka
QDA/YimM89YWk5Ptt0wNyOCZiKq6h/OOBv2I1EMN2G7Hf6ywkIps4g+/T6vW
gMQfLNsDcL47Zau+JlmrAV5P6ulWnmO/kRTmrazXAKuvDZ8u4jzoV0O26X2p
AenOvTRH/n1fcC55mKFbA5y9/VybcL7MKA9eTe3VgO7bYT92vMR5KeQsj2S/
BkyYGP09hvPoYw4NGzSsAeHqxWc7cX7t3D/y7tK0BiTU9Oq743zbz/RyhX5W
A/48/ZwW2Yn9YbCYO3VOA4YVzHel4Dz85UKIdfmiBtQsnD2Vi/MzWd35P90l
DYjtKhe700tFq1umad0UXD/eb98Ssc/SpYu8m1/WADFpvyvOOH/vOMO4ErCm
ASpXz+w1wPl8tyKVi/6XBnhcvTohhPO7WMtLK/EtDch7UNj6Auf7/WTnoRPM
JHxerbSzsB/w1Bk/qN9Bgv+0zxVrYH8gR8t7i7KTYHsqa0Mn5hxx6o653SQY
Eh9t/oh9I4A8MGrMTYLBb3PFZ7GvmtU9LyzhJcFTUXO5KcybViH63kIkuP6N
8X0L9pdhcQeOQRESqIvs26aA/aeMDFMa4iQgfUkvj8N8vU7ycaYkCc5zJnz6
gtnhBkPIb2kSFHqmZOpgnyJZLxx0kCPBwCv+jhjM7BLdPC/lSdA/Oe07gPkz
ueyTpBIJDhT5pXJiX2uqS668rkKC1mV6JTPMmTf8IxZU8XqHu/ZFYva2Pm5m
qk4CsuNG0xPMByX2Cj0hkSA5v+XFMGYxitAihzYJ9laflP7ns+t1W9X++0jg
UrROx4F9s+/GzLX3+0mQGNtjI4W5yLrNci+QQMOPXUAVc4REkXi2Hq6XD+XI
P5+1pcRQtgxIsHA77zsJM6H+YoOTMQl+/D1DR8DMdNM8tu0QCdzLT16TwDxt
TTwhZ0rCvjHox475hQSPbKwZCfJDHPp+4vUkUdaXl8xJQLc+d3cA8/n6sRZz
SxKUZDqP/fPzAzcbk55a4/1dG4oPxSxgc9+Bx5YEyvMqVcaYf0hEKQbZkaD5
i7cNK+ZOiuuvMXsSbHuc7N2J6/mg/tAb3dMkOOgYxxD57/8Pbiqm3z9DAuqe
kwJEzBY2O53pnElgqbb+eAL3i4Y6tNVxngRP7l2zF8X8ob66R9GdBKeOu4VU
/fPbm1l3Ei+S4AMfg4QxZidJR01rX7z+vju7rfG87KXq0b/wJ8HjhjKXATxf
uxukBwUukWCVfsb8EOZWm6+e0yEkkLsVTCOF5/GuZK+O/mUSUA4fHIj+57fU
cpaCCBLsNmU8Mod9ViomoMD9GgmUdsjbxL+joj82J/x7o/HnwerSezz/Q5I6
eqoxJPhZEKUvhDmqYfvkagIJxldf7L2Fz499zKfSE8kkqKhbnmvF50v9+Oug
+hQSdFdVn6X0UdEnahx3ZCYJnmlxLxPxeTSU4jvC9gDX77uQhv+/79sutYk7
5+H9fIw9GozPu1S132ptAQk8S5krg/F9QGfyNvd8KQnCDN+4ub2mohav6z9a
n5Gg3EbuIgP2XTVt9dcC1fj8/G6Mm8L3zX2amTs+NXi+/qshPG3G85W231C0
kQQX3j+UN2nEfl23nBH8Gs/PwuAXTey7ZVEPPPo78Pl6za74Gd9vwmbmB+S6
8efZHdBNrML1mC5dfNdHgtfJx7/3P6WiWoaz+1U/kEDgXcdtAey/JIv+mS/f
SGA2OOTTgv23QDC8WpdCAu1+fRcJfN9yzynGpX3HvPK9PyyHipYv3dDQXyWB
j/weA1l8X1dmoxs5WyQwJKj1G6ZSkcrCYyXr3ZpQ86qNueEaFclFxAS2aGrC
6AW7Qz9cqKh+Xz696V5NeHC7ZM/js1RkvtZ0652OJrzZ01PrfIaKAj1XHs0f
0AQvXef9ndiH39g7fmQ31QSabcOfvC3x/GuTTE46agJ9nD5lP1BR8Y+Pgss3
NOHHwiG+89h/dcv+FIXFaoKV1Vmjaey/Axd4SYwJmpAkp197HPvvr2lTc4EU
TTA2fN9hgJ+fJm+royBbEy70js7x01HRYmn8UlwF/vlfod/XpihI3kW7SfqD
JggPdUQfTaSgRAmzX1fHNaGsYuvlixgKWp5y0piZ1AQzM+uz0tfx894urjRn
VhNUrZnOMYdRkIX5VAbvkiboN9fxbnOnoKB917yZt2lBpmpAwStjCppcv116
jkYLvkYaTfvpY3+uKvvcRqcF7NfyEuUQBbGqjthHMmvBxD6f/gcknC9kFA79
3q0FNKfsfSalKegNR7/4krQWLH8/ORRHT0FKb+fsD8tpQSjhN/0D7L+34n5l
FMtrgQld161G7L/2jFLsripa8Gp/nBr7Ks7nfwJ+TWppQVvV1VqWL2TEMy80
2HdYC07snu5M7iSjkHxVdhUzLZhZOrG2B/vwtJPRoXhzLej+eovQhX24ZMKr
6ZC1Fhw++FF+D85fuoMtpS0OWpBsc3DRupyMXBrPRz3z0QK+PvOF6EzsDxcX
Lxn6awG/d9ZoRBr2WWEP9+EALQjR8xC/jv04JtTLYj1EC0i7G7iqsA+X7w0Q
07muBevnHnKXXcF+tbjG2XNDC1LyG4+w4rzZejuI0SFWC6T2x2ZcCsV5bz2U
HJ6kBd/ZjjT8d4mM/lRdrW/N0oLnQDux2xP7pSt9uVW2FoTbaiuPu5PRTp7o
h3O5WuBTbHr4Kc7DEv/FxDDma0GfuI5GLM7PpVKslzMLtYBpMlsk7iz2y6F4
nz0lWuBy+d3uO2dwPiUm2x5+ogVkXn/LWey/fTO7TccrtODgl4o6IXvsI7dS
0cVnWiBj7OfqjPO7x/cMmcQaLehyVq4Twf5760nO8kCrFhj2Gn4B7L9Cp8Xm
z7ZrwZGR0wtL2Cfy2R+MLb/RgrQu2+xi7BsvLua38PRqARJIsziCfeSAsGxV
YZ8WDBx+4qWBfaWzu6hYa1ALFpUOByhin5lQeJRkN6IF6Xudz/7zXdcxpaiv
H7TgZji/hTv2IWrMk0uhE1qQhCogB/tS0F5Vd7ZpLShZ20acxj5Fs1jpkDOj
BSNSk4qqmONuq1uozOH+GYioJWP/4j5UZdj8RQs8B9KNtmHOWdfUPraoBe9M
hT0vY3+TK6pRnPmmBUcJ0Y92YK48vk/Mj6IFkxvF9EXYB/cxNnDS/dCCMJmT
YZaYX1XpMqYtawGB6M3LjtnMtfmX9JoWrN5tfP8e++YItx65akML3k4LtpRj
PtPW+tH4jxbUhpz6kPnPf/0N341sakH1oq3UP7/1l3r95sJ2bXhdMvswHfPm
4MH6X7TasKA1aP8Ic/TVziexDNrgSp216P/3/V6i6UMhZm1AhIJr9P98dqYn
/fEObRB4w0I5iFny1tEYXXZt+CqRfeOO3r/vB/SHvd2lDUWl84f/YiZ9t/Bx
5NQG/Z5ANU+836Z7Q87fubXh2Y8RjX8+O20qfjqATxvmBJ2Sg3G9tm1cPPFb
QBvaDIp9uHF9xfNrLSOEtUEm+VZfI2a9Y4xm9GLaMChFUxSA+3P2r+XBGAlt
uCM5/l0H9y+q+J7eTmltMK2gK+LA/W3fvleTX14b8pkG4PMhMvry+LpqjiLe
Lz/i/YzngcluUEFSRRvMDsUeWMbzcqjSQ0xJXRtqko8F7cPz5eZQI1BJ0gb7
HynB/nj+YlgYuDW1taE2Sr+6Dvtst1Mu8wFdbchITqjxxz67xP6Nth20wXPP
iONn7LPsdVqbJvra8O33OKurDfZLzoEfVge1gXlyu0biCTIabKUbP2+hDeO+
gpzRjtgvvY4NL1lpA1v9faVzTmTEJZTT53tcG9TtqvqsnMnIxl+zLdReG9Il
/H1tz5PRBym3siRXbahvyvPZ8iaj331VRdwXtKEzbpuIiR8+P2G0D7PctUG0
o2H4/n9kdOrd3Yw8b20IjBGUDsS+On3tbcSLYG1YWaLJbYjC9fmsbjmdoA2H
m7OW0u/g+qRcOeKSjDnj6e1C7J9yqNd4MUUb3GiCR1vv4/pknNNZztSG1R3/
V2zm8VCtfxyXUhSSVJJkS5YKSX4zzznOl2oU13pvC5WfFErScqVo0y1CSGFI
V2kskRLKkqQpVKRkbZLKEm3MnBYlhfudP9+vmXNezzzn+3zP5z3POak3tHKw
n9mlzpfP4MBBvQSjDcX4e3LGfpiWcsDqpJqotVH6fw8vPeoWBwpKTD3dWrF+
J8Su6rnNgW6DP3yei8TMbS+Nc3whB8pUQuOH36CPqltyR2o5MHfENl4gxnqM
9D9U18GBBcFtCd5KEmahX6uMjywXTtFGmc+dJcyW+XkKqY5cSHRV/ru6S8KE
1nj6G7hwYd+yNpvXfRIm3kf1cZEbF8ivP94PfZIwFVkhMY/XcSHPQU3J7LuE
UTNYNXVkMxe62uL3ucixzAODXjWvYC7w2fEON2azjLHhPG2Di1zY/e045Niw
DDxqCiu6xIXHQ54b1Vegf22L6LLO5EL9pTjTCPTH4zkDgnW5XGAvWOR6OKB/
GlbMj7rBhQl7o7Pf/sUycUbuJv0PuVD0tLLL349lPhsnLCtiuaC25m1LKfqh
qB5WTv/KhYshnXv4p1hGGCj+M2iQCx2dn4Z2x+LxRav3LBvmQrOeavzsMzg+
rszV8vEEHGU1d1mlYN5cvVOnaiYB6633/p+axTKrP2mY6c8mMFp2aK85+qJZ
7CPr8DkEBO7egqoc9JdnehvttAkY61uavMhjmfPr2/mPjQgY+RSff1iI+dHP
TrGFIvBkWa99TgXL3FYY1LBkCGyKmTj06Q7m5zyBEd+GAE9haJYx+uNuyQhv
PY/A2a+WUUmY55T23zzW4Uxg77wHJoYPMD+pe8fTbgS0p8cHWGMe7CifevHC
XwT26F5rd3rEMldG/Su83Akc0WyZ54l5kheh8+OtN4FqzpEgS/TDRYYNcjwf
AtmPonmamEfV6g6pXfbD8b4LkR9B7lYSmW8PIMCZOmnlVcyztdfDoS6QgH+j
z81QzLsFrhbOJnsI6IjGftuiLx5NigsY2EcgQN9v/D3Mx75W1EGnAwTSdQeL
gzFPO734EHU9lMClNsbEAPO25tyVl/ccJWDfGGO3F/P4+LtfipuOEXis7NKj
jHn9o1d6tcUJAiXkjUkWclnmr67BSAJnlmsVV2K+X7Y86If9KQJNVn/6M+gD
xV39iumxBP6pNRm9hbw0zEd38DSBwGnBOxdLfULrtZX9WQJbDWWK/0U2u7PW
8WIigSULUhonoH9c39Dg/Y1PIMdAUeiLfDVFGHvhPAFhtFBOHf3F2IqT8TWN
wJh22lo/5NzWwrJV6Xg9XHMDCpANg4yfpgkI0FXmvK/I2aoZPV8yCeTm2XSb
oi/pF875aXeZQJBML+OLnOGcqJyWS8C9dIEnH1lXrKj/JY/ArAczKCFyekw4
xy4f51v3tqgHWctk1OnfAgJT7+tZjEO/S6sN3vq5iEBN6gZ76X6m5jZJCK8Y
60cQONcIOXXittPnSwm4Pd2WJ90vVc/qzGRvEchSW/tV6pfJy93LV1YQGPG3
/SbdL53Z3diQWkkgydHxmvR528Qw+16JkMDrmCateciq86qGV1QRCD+w2H4y
8pk7RCW1hsCkmmozCY5PZePN+ZKHBHoNfjY/QY4bXkhW1BG46GZqmY2sdC7L
5Vw9gRu/69ZI94djrLR8xU9x/bwwtVqBPLmNf3B5I4H+tHvtCshRQVPPpDQT
UBntsanF+ZSfHpk90EogLn94p9QvIwplKmxFBPq2bPeyRJZzCWlMbieQ3JSg
0Y3X74T4c19/B4F2pc60SKlvxvr/tnlDIGz3kX5D5GMmPdOSuwhstpCZXIX1
cGRbC2XTR+CZWZjwrfR52YmObvz3BF7y33kFIB/MqvH79JGAxs0Jbwaw/g50
l5xNkhAw37Hk+Gusz70bz73/MEQgYaFmczDWNzs8bdT6F17Pa58fPcH633Uu
enriCK6HyrByLeSAtoPW1rIUiGaHXM7H9ePr4pl4dgoF7uF+zielvihuy32n
RIF2xriH+bget8Q636VUKBDLxm1/huvXqw4+9qlRIMlYbSf7hGU8VugB0aIg
KT5bSQd9caRFXrlKmwINd++f47EfpPuIX9rrUcAbBbtO7B99Ebf2exhScOri
lSXh1Tj+WufrIUsouH9CYfsx7D8zPCwPj7OkwCekJMJM+r7rRw2HKCsKrtQr
ub/A/jU6pa8vhaIgo3R4pXo5y0Q7HdIq41FweMA99Y+b2F/ebO5nVlPQsEYr
t66IZZ7tsit/6EBBhPLEBlvshzPPqK597kLBZH5Sgg76o6A5J/a7BwXyZ6P9
UqXvK6xv/b10FwVgzYsLP8cymz6U11XsoWCG+oODecksIxOanrIiiIK4h9lb
65Owv53fsfSvEAoM9LO2jmE/b3o1LuDv4xSkzGroMInGfuK9+GVhMgU5CiXv
roWwzJydJ28tFlIwUfV5RdMarNcxX8tT9ynYl+/28xL6oexZXuG7apyvewNP
Al3x+BK53PRaCvzLNx0d54jjkzmRotpMwQYNk/uKeP/ySAzb/72Xgsjj+ba1
5iyTcjvEsnIKDRPezz3tqsgyik7uhRrKNFRe6l34TQF9vPN/i/ar0DDpy9pj
/Enoo3JD+mYzaHC3+5nQLssyVs7BagItGr6U6Z6p/iJh2rr3fg03p2HzhWCf
0XoJM2NyQKHjOvx+t8urZ/9ImMzlh0NZdxpmhE9eIERfXHI4bnnCRhp2WuzQ
vnlAwjixBa2izTR8VBl5dSVQwkS0Df7cEkCDh/Own8hDwgwJjtqGHqNh2Vjp
fY+l+HlH/JS5J2jIbGnWvWKK9/eZgpa7ETS8aRKNyZhIGLOoal+5GBpWDszu
qdGRMNt3KZyK59OwrqGgrWCqhGknCc3ZeTRMc7ZwXTwgZrbty/x3dT4Ng8ad
lfIfxMz3/GKf/gIauvXEZgNvxYyqruiHeQkN45YeuNfSIWYc5Odq3hHS4DC9
XqD7RMxUtGRvbW6lYU5QpOvz62LGXrlsUbAIz/95f6v3Vel+YO139Zc0vEiU
jxvGPPWt/FOkZycN7WvjtZwFYmbRJbNrHz7SsKVvtOU0+mJFu01wzACN6/sy
Jwx90V7tT8aUpaGjoavs8Gn0m5P7GoMGaQjsjgpOj8LzCSNSZw3RcIQp7a+J
wHw1nLylfJgGlYWD/UPHMV8tzV24aYSG3u16CRz0yws7ywfHxmi4Xa7z6+QR
MfMfqSklEw==
       "]]},
     Annotation[#, "Charting`Private`Tag$1326749#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwU3Hc4lW8YB3DZO2SvjGPvYxxJnjtKoShFFJEoUkaDSJFRIisilJSdEirK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       "]]},
     Annotation[#, "Charting`Private`Tag$1326749#3"]& ], 
    TagBox[
     {RGBColor[0, 0, 1], Thickness[Tiny], Opacity[1.], 
      Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/e3eySMq3UvsGMDgg72byqu7H69fsofxf143n/rh
+iM4/7Dz8iUXF32G82Xu73yWpPMXzhfJiV/F7szsAONPMnTb7RfKAeffnGFw
4KMAL5zfvaT+PJOkIJwvPuVx5+S5wnB+e4in3aVvonB+seXC+JNNEnC+y/tf
VXmPpeD8RpvARCkLWTjfat3MLXX75eH8nB8fG07wKsL5P7UF7umGKsH5NqvX
LJg2TRnO/yjklRB2SAXOf9KTEFbErgbne74v93xqpg7nv0nmKN5SrwHnu6mI
M7Uf0oTzhc6q9W14rwXny3SsDzAz04HzZ2hbCgin68L5p6QcTT9P1EP4R+bQ
BP1r+nA+H/OiksQmAzhfrlHeJlLNEM7nVI3ZFnQcwdezlVxfHmsE5xfdEzrs
xWAM57//3BPqOQPBd9c/NstT1wTO3/fZ+vf3cwh+no7RrYuppnC+7buUK5Gc
ZnC+q4qEL+8iBF+joavikLk5nK+Varlf9RaCn7ovo2VLoQWcv3/BlZSPopZw
/pcV/7/rb0fwk1VXc87ytYLzP2pNNtv0AcHfseT3w68d1nB+lIuyg7WcDZwv
ndu+U+8Agi/KlbPRN9wWzr9lPfnystUI/rzcXV///0fwARhx8T4=
       "]]},
     Annotation[#, "Charting`Private`Tag$1326749#4"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 29.999999387755103`}, {0, 1.25}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6880589834880323`*^9, {3.688059014804427*^9, 3.688059044990197*^9}, 
   3.6880590786502457`*^9, 3.688059337778199*^9, {3.6880598955443783`*^9, 
   3.688059955434869*^9}, 3.688059990581812*^9, 3.688069620898686*^9, 
   3.6880698595842943`*^9, 3.68810235716721*^9, 3.6881024956865387`*^9, 
   3.688596642609024*^9, 3.720550185806202*^9, 3.720617307051909*^9, 
   3.720617338932418*^9, 3.7938438057543716`*^9, 3.793843919144621*^9, 
   3.79384402124623*^9, 3.8232295678611307`*^9},
 CellLabel->
  "Out[3274]=",ExpressionUUID->"af76131c-9399-4c03-a8e7-75d259c4042b"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.676147586319213*^9, 3.676147638502285*^9}, {
   3.676147927704694*^9, 3.6761479413907433`*^9}, {3.688056654692391*^9, 
   3.688056724834689*^9}, {3.688058432724813*^9, 3.688058497919837*^9}, {
   3.6880585827149897`*^9, 3.688058584234901*^9}, 3.688059095568413*^9, {
   3.68859669829935*^9, 3.688596700410144*^9}, 3.688596978245199*^9, {
   3.793843899739554*^9, 3.793843901130598*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"3cfa3ad7-a907-4c6c-8112-12aa7be00c88"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dat", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"yZV", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"yZVD", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"yZVDD", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax", ",", "0.01"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6880591910751047`*^9, 3.688059245541511*^9}, {
  3.7938439116511908`*^9, 3.79384391198116*^9}},
 CellLabel->
  "In[3275]:=",ExpressionUUID->"7b34a594-7fca-4dcc-bccc-83561b8c78c5"],

Cell[BoxData[
 RowBox[{"(*", " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<inputShaping.dat\>\"", ",", " ", "dat"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.688059265597649*^9, 3.688059322811384*^9}, {
   3.6880599837590637`*^9, 3.688059986102754*^9}, {3.688060028060472*^9, 
   3.688060030377183*^9}, 3.6880620949615*^9, {3.793843883757133*^9, 
   3.79384389164685*^9}},
 CellLabel->
  "In[3276]:=",ExpressionUUID->"b5676bd1-ce32-47be-ab1b-974583a6ecd3"],

Cell["\<\
Simulate dynamics assuming \[Omega]=1 but actually \[Omega]=1.15 using \
adiabatic ramp\
\>", "Text",
 CellChangeTimes->{{3.676147586319213*^9, 3.676147638502285*^9}, {
   3.676147927704694*^9, 3.6761479413907433`*^9}, {3.688056654692391*^9, 
   3.688056724834689*^9}, {3.688058432724813*^9, 3.688058497919837*^9}, {
   3.6880585827149897`*^9, 3.688058584234901*^9}, 3.688059095568413*^9, {
   3.68859669829935*^9, 3.688596700410144*^9}, 3.688596978245199*^9},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"836d00c6-6e0b-4dd1-b9eb-0a2308a06b80"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tad", "=", "100"}], ";", 
  RowBox[{"uad", "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"t", "/", "tad"}], ",", 
        RowBox[{"t", "<", "tad"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"t", "\[GreaterEqual]", " ", "tad"}]}], "}"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yad", " ", "=", " ", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Gtf", ",", "uad", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"1.5", "tad"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"yad", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"1.5", "tad"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1.25"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6885967062677717`*^9, 3.688596871712344*^9}, {
  3.688596917125903*^9, 3.688597037310011*^9}},
 CellLabel->
  "In[3277]:=",ExpressionUUID->"968b94fd-359c-418c-8f21-c85a763d1e5d"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwU1nc81d8fB3BJkkpWSPbMJnu+3/bmNowUpTJT9iih0qBIWakQ0bALRZHK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       "]]},
     Annotation[#, "Charting`Private`Tag$1327176#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 149.99999693877552`}, {0, 1.25}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.688596775422327*^9, {3.688596854087206*^9, 3.688596873414822*^9}, {
   3.688596925119948*^9, 3.688597038095343*^9}, 3.7205501860511*^9, 
   3.793843805942313*^9, 3.793843919227558*^9, 3.7938440213180027`*^9, 
   3.823229568154388*^9},
 CellLabel->
  "Out[3279]=",ExpressionUUID->"be4b64ff-7b81-4e6c-828a-64332e8fe4e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"uad0", "=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t", "/", "Tr"}], ",", 
       RowBox[{"t", "<", "Tr"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"t", "\[GreaterEqual]", " ", "Tr"}]}], "}"}]}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ysol", "=", 
  RowBox[{
   RowBox[{"DSolveValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"y", "''"}], "[", "t", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Omega]", "2"], 
          RowBox[{"y", "[", "t", "]"}]}]}], "\[Equal]", 
        RowBox[{
         SuperscriptBox["\[Omega]", "2"], 
         FractionBox["t", "Tr"]}]}], ",", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"y", "[", "t", "]"}], ",", "t", ",", 
     RowBox[{"Assumptions", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Tr", ">", "0"}], ",", 
        RowBox[{"\[Omega]", ">", "0"}]}], "}"}]}]}], "]"}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.6885972684940557`*^9, 3.688597347976966*^9}, {
   3.688597448610074*^9, 3.688597448897312*^9}, {3.688597536980007*^9, 
   3.68859760340336*^9}, 3.688597662035228*^9, {3.688597725666404*^9, 
   3.68859777795604*^9}, {3.6885978228047123`*^9, 3.688597825051381*^9}, 
   3.6885980876634073`*^9, {3.688598222763056*^9, 3.688598224983959*^9}, {
   3.6885983415473223`*^9, 3.688598345863604*^9}, {3.688599961932712*^9, 
   3.688599962531019*^9}, {3.6886001136011143`*^9, 3.688600114734888*^9}},
 CellLabel->
  "In[3280]:=",ExpressionUUID->"5710a3fa-7b93-4ff9-a9a5-8c4c632ccc1a"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {
        FractionBox["t", "Tr"], 
        RowBox[{"t", "<", "Tr"}]},
       {"1", 
        RowBox[{"t", "\[GreaterEqual]", "Tr"}]},
       {"0", 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}},
      Selectable->True]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False,
  StripWrapperBoxes->True]], "Output",
 CellChangeTimes->{3.688599972514751*^9, 3.688600115205209*^9, 
  3.720550186127524*^9, 3.7938438059511642`*^9, 3.793843919236671*^9, 
  3.793844021326516*^9, 3.823229568165009*^9},
 CellLabel->
  "Out[3280]=",ExpressionUUID->"e412421b-b588-4904-8012-13915b255d50"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"t", " ", "\[Omega]"}], "-", 
   RowBox[{"Sin", "[", 
    RowBox[{"t", " ", "\[Omega]"}], "]"}]}], 
  RowBox[{"Tr", " ", "\[Omega]"}]]], "Output",
 CellChangeTimes->{3.688599972514751*^9, 3.688600115205209*^9, 
  3.720550186127524*^9, 3.7938438059511642`*^9, 3.793843919236671*^9, 
  3.793844021326516*^9, 3.823229568193946*^9},
 CellLabel->
  "Out[3281]=",ExpressionUUID->"6e74cf3e-1e97-4211-8978-79c46fb742fd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{"ysol", ",", "t"}], "]"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.688600118163143*^9, 3.688600136369111*^9}},
 CellLabel->
  "In[3282]:=",ExpressionUUID->"2f0f4dac-1187-4812-8ac0-937bcb7e3717"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   RowBox[{"Cos", "[", 
    RowBox[{"t", " ", "\[Omega]"}], "]"}]}], "Tr"]], "Output",
 CellChangeTimes->{{3.688600120679302*^9, 3.688600136738696*^9}, 
   3.7205501862104063`*^9, 3.793843805972546*^9, 3.7938439192706203`*^9, 
   3.793844021349828*^9, 3.8232295682003317`*^9},
 CellLabel->
  "Out[3282]=",ExpressionUUID->"a3df1c03-2e5c-4015-8085-7d0b2d896c54"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"t", " ", "\[Omega]"}], "-", 
      RowBox[{"Sin", "[", 
       RowBox[{"t", " ", "\[Omega]"}], "]"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "t"}], "+", "Tr"}], ")"}], " ", "\[Omega]"}], "+", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"t", "-", "Tr"}], ")"}], " ", "\[Omega]"}], "]"}]}], 
        ")"}], " ", 
       RowBox[{"UnitStep", "[", 
        RowBox[{"t", "-", "Tr"}], "]"}]}]}], 
     RowBox[{"Tr", " ", "\[Omega]"}]], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Omega]", "\[Rule]", "1.15"}], ",", 
      RowBox[{"Tr", "\[Rule]", "100"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "150"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.688598096115904*^9, 3.688598130027882*^9}, 
   3.688598239707897*^9},
 CellLabel->
  "In[3283]:=",ExpressionUUID->"9b423f06-5838-4e14-bd38-59f405e9f0ac"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwU13c81d8fB3ChSLIyssree+/3295cKQoNhSRlJGngGyokiUhlhsqKVCgj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       "]]},
     Annotation[#, "Charting`Private`Tag$1327234#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.688598131328342*^9, 3.6885982412249193`*^9, 
  3.720550186394018*^9, 3.793843806073275*^9, 3.79384391935918*^9, 
  3.793844021434123*^9, 3.823229568304682*^9},
 CellLabel->
  "Out[3283]=",ExpressionUUID->"32b81d27-6719-405c-b898-47a7126aac82"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "\[Theta]"], ")"}], "2"], "+", 
    " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"1", "-", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "\[Theta]"], ")"}], "2"]}], "//",
    "Expand"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.688601330847464*^9, 3.688601415789434*^9}, {
   3.688601458593465*^9, 3.688601458736006*^9}, {3.68860155313316*^9, 
   3.6886015629736633`*^9}, 3.6886016946139107`*^9},
 CellLabel->
  "In[3284]:=",ExpressionUUID->"20f08c2d-905b-452d-b6ce-f4cf45fe776a"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", "-", 
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], 
  SuperscriptBox["\[Theta]", "2"]]], "Output",
 CellChangeTimes->{{3.6886013777484503`*^9, 3.688601417168927*^9}, 
   3.688601459693516*^9, 3.68860156409468*^9, 3.688601695571048*^9, 
   3.720550186541979*^9, 3.793843806091564*^9, 3.793843919430093*^9, 
   3.793844021475999*^9, 3.823229568329041*^9},
 CellLabel->
  "Out[3284]=",ExpressionUUID->"52f9f0e4-4bb8-4444-ad50-f1984e8b9866"]
}, Open  ]],

Cell["\<\
EVD shaper kills two frequencies, for robustness.  Method:  keep \[Tau] and 2\
\[Tau] same; keep A1=A3 by symmetry;  use additional freedom to set \
V(\[Omega]=1) = 0.05.
[omit:  this is lousy if expected value of \[Omega] has no bias!]\
\>", "Text",
 CellChangeTimes->{{3.676147586319213*^9, 3.676147638502285*^9}, {
  3.676147980893701*^9, 3.676147992419711*^9}, {3.676163170667118*^9, 
  3.6761631736642036`*^9}, {3.6762069559869423`*^9, 3.6762070101503353`*^9}, {
  3.688054514452976*^9, 3.688054534619801*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"382aab5a-e519-478c-829f-3e157442cb67"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"A1", "+", 
        RowBox[{"A2", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"\[Omega]", " ", "\[Tau]"}], "]"}]}], "+", 
        RowBox[{"A3", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", "\[Omega]", " ", "\[Tau]"}], "]"}]}]}], ")"}], "2"], 
     "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"A2", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"\[Omega]", " ", "\[Tau]"}], "]"}]}], "+", 
        RowBox[{"A3", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "\[Omega]", " ", "\[Tau]"}], "]"}]}]}], ")"}], "2"]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"v3a", "=", 
  RowBox[{
   RowBox[{"v3", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"A3", "\[Rule]", "A1"}], ",", 
      RowBox[{"A2", "\[Rule]", 
       RowBox[{"1", "-", 
        RowBox[{"2", "A1"}]}]}]}], "}"}]}], "//", "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.676163252128042*^9, 3.676163323333868*^9}, {
  3.676163539998784*^9, 3.6761635701832533`*^9}, {3.676163726400702*^9, 
  3.676163745897029*^9}, {3.676163882888815*^9, 3.676164066269436*^9}, {
  3.676164230288553*^9, 3.6761642321497087`*^9}, {3.6761675365380096`*^9, 
  3.676167636251896*^9}, {3.676167749201679*^9, 3.676167753919622*^9}},
 CellLabel->
  "In[3285]:=",ExpressionUUID->"422e2b37-1c69-4bdc-83b8-eb95e448d7af"],

Cell[BoxData[
 SqrtBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"2", " ", "A1"}], "+", 
     RowBox[{"2", " ", "A1", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"\[Tau]", " ", "\[Omega]"}], "]"}]}]}], ")"}], "2"]]], "Output",\

 CellChangeTimes->{3.688055244152417*^9, 3.688055338939211*^9, 
  3.688058423055378*^9, 3.6880593379362383`*^9, 3.688059990877325*^9, 
  3.688069621037702*^9, 3.6880698597362757`*^9, 3.688102357315948*^9, 
  3.688102495813943*^9, 3.688596642783516*^9, 3.7205501866097937`*^9, 
  3.7938438061255493`*^9, 3.79384391946185*^9, 3.793844021502164*^9, 
  3.823229568353422*^9},
 CellLabel->
  "Out[3286]=",ExpressionUUID->"10830735-3e87-4816-bc1c-bff409a42e5e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v3b", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"v3a", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Tau]", "\[Rule]", "\[Pi]"}], ",", 
       RowBox[{"\[Omega]", "\[Rule]", "1"}]}], "}"}]}], ",", 
    RowBox[{"A1", ">", "0"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.688049783904817*^9, 3.688049799385083*^9}, {
  3.688055105635706*^9, 3.6880551257664623`*^9}},
 CellLabel->
  "In[3287]:=",ExpressionUUID->"dd8640ad-c5d1-4b65-98da-851c851187c3"],

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"1", "-", 
   RowBox[{"4", " ", "A1"}]}], "]"}]], "Output",
 CellChangeTimes->{3.6880552504506817`*^9, 3.688055338970889*^9, 
  3.68805842313896*^9, 3.688059337990781*^9, 3.688059990925761*^9, 
  3.688069621079339*^9, 3.688069859787303*^9, 3.688102357373765*^9, 
  3.6881024958433857`*^9, 3.6885966428428593`*^9, 3.720550186675234*^9, 
  3.79384380615965*^9, 3.793843919468948*^9, 3.793844021509479*^9, 
  3.823229568381366*^9},
 CellLabel->
  "Out[3287]=",ExpressionUUID->"d75f5f2f-cc3f-4623-a5bf-52700acfc327"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "0.05"}], ")"}], "/", "4"}], "//", "N", "    ", 
  RowBox[{"(*", " ", 
   RowBox[{"solve", " ", "for", " ", "A1"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.676168601237927*^9, 3.676168657473365*^9}, {
  3.688049051180541*^9, 3.688049076266836*^9}},
 CellLabel->
  "In[3288]:=",ExpressionUUID->"333e34ac-f333-41d6-b064-d84cc6c99254"],

Cell[BoxData["0.2625`"], "Output",
 CellChangeTimes->{3.688055276289672*^9, 3.6880553390332537`*^9, 
  3.688058423222231*^9, 3.688059338041203*^9, 3.688059990976182*^9, 
  3.688069621128159*^9, 3.688069859853943*^9, 3.688102357440351*^9, 
  3.688102495889751*^9, 3.68859664298669*^9, 3.720550186744236*^9, 
  3.793843806165263*^9, 3.793843919497778*^9, 3.793844021531528*^9, 
  3.82322956838717*^9},
 CellLabel->
  "Out[3288]=",ExpressionUUID->"8edc78de-0cbf-41e1-ab14-8711dc4f3ba2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"v1", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"A1", "\[Rule]", 
         FractionBox["1", "2"]}], ",", 
        RowBox[{"A2", "\[Rule]", 
         FractionBox["1", "2"]}], ",", 
        RowBox[{"\[Tau]", "\[Rule]", "\[Pi]"}]}], "}"}]}], ",", 
     RowBox[{"v2", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"A1", "\[Rule]", 
         FractionBox["1", "4"]}], ",", 
        RowBox[{"A2", "\[Rule]", 
         FractionBox["1", "2"]}], ",", 
        RowBox[{"A3", "\[Rule]", 
         FractionBox["1", "4"]}]}], "}"}]}], ",", 
     RowBox[{"v3a", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"A1", "\[Rule]", "0.2625"}], ",", 
        RowBox[{"\[Tau]", "\[Rule]", "\[Pi]"}]}], "}"}]}], ",", "0.05"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", "0.7", ",", "1.3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0.2"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{",", ",", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Blue", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6761478815737553`*^9, 3.6761479016992607`*^9}, {
  3.676167250762189*^9, 3.676167461922894*^9}, {3.6761680342569447`*^9, 
  3.6761681029667253`*^9}, {3.6761683335818777`*^9, 3.676168341423923*^9}, {
  3.688049095894367*^9, 3.6880491158366833`*^9}, {3.720617231914441*^9, 
  3.720617281667107*^9}},
 CellLabel->
  "In[3289]:=",ExpressionUUID->"fc52c996-c944-456c-bc91-d1b1d960f505"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw9lH001XcAxi9317y/JC8ZKSPTKrsRJTw18lbc0OJIcZFF3u9KInGv0HAZ
dr3khjiLWMtsVNfe7iwvs+4i65zCwq68f39X8to6u/2z55znPOdzzvPX88ez
NSze77QijUZzkfttCopmSoakM6iseKseKITurbN3nYVQveNMn38XRLmGqTpN
s1C+u03q+qQTo/1VM69V55BikT8p5onhE2ozwuDM4XLDQdOtKz/BUisuasvj
OUQsjvINHEVwVxCdD3Sah87X3zWpGbbBeMs2va/q5+HuXdjbrtKCU6F7jjAY
BIwfbVRP1jbgxfhxBjeW4GlbGjNHXIWLa0Jn5XgClfAFbepcFTR1pMn8BIKk
E8KuQKsq2Dlzpis5BIu+Xh1WRdeQXV4oaU0hyFRXlPScrIS5d3eF9ArBEcHy
quJqGcLa9u3yvE7QrJ8WGWxdgqW+jE8l1QT6OkcVfhkrxufjXTWf1BI8KtiQ
aSEoRov2cd2wegJ/RyPm/OsvQDubtHLxFkHBU7uQ9N4iVJs2iZvbCGxLE2/a
/p6PoVzjAG0JgQb7Xaccex7MDBsm+H8S3Fjm3vau5SLqps15jX6C598cU9qo
xsXSb15fqg4S/MO2i6kZyYAOPWXgnWcE9RIrVoLaJbhdGmStThB0Hq57v/sm
BwXq7L+TJwn4h9glfqlJeHxtNm5piuDB941TQz6JYN+n81/OyvvGdTVjM7FI
W2b2zS3I97POitydGwFx9g8nYhYJKq4wVdysw6Ci7zkz/UreD6y3aG0OgcA2
VHVyhSDlQruE5nkcw7/OVESuEewmKRzLMl+Y+ydbSdcJ9vBob671eiJ6TPFe
+L8EHGGWbDLyAFoS+R5jbwgObn6174n6DqTRNGI+olGYDB6STdN1Ydrd30rk
/GEjR4udaw9xYfn6bQUKbdbLNeOWhxAZcMolTpFC1TFtoSDPByqm5nk76RQW
vfPb65f90Twx1T8r554hTUZ6YyBenjsXdpZB4f6zJ5vKldgQOO2/tV2JQtkY
4WWFhMOBobAwJWfersCBhLunkVGan3lGmcKGjdv1PKOjodlaV3NajYLUxFy6
PpEIl500kyADCnsTP5szC+AiZlNvtZUhhUeueR3vrXEhYJSarco5gD4Ss1HI
w/Sw5QflRhToWfqxjPEsFPNZNn+ZUDDLm3sojcvBKLnu6WdOQfUog1mdnY/L
3zqd92JS2O0rqlwKKoHIPlXicJhC48PbDiNXhZjy8/CpT6VgG73EErg2QFS4
mW98h4JKusDpD7cWvBjjCarHKbB2OnGv+rahx23/2SZdGRzNc5zj6SKw+tZp
D9xliIg4Waun/jPywjTDoy7IMHgj+3l7lBhmWncKDBpkYCnplQze60TwcFDK
42cyeOwIrvZ36MKRjgCmkfoCRAMZMZKCHnxspzugpbHw/z/8B7oDBGE=
       "]]},
     Annotation[#, "Charting`Private`Tag$1327346#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw9mHk0V8//x70rS9YU8aFsaaGIlK26T1REyla2NlsSIkuEUihLhBSiEpGs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       "]]},
     Annotation[#, "Charting`Private`Tag$1327346#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwtmHk4ld3Xx49CkiFFpGROPBmSHkNYksiQoRSFSOaZzJlCMoUkQ0lkOOeO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       "]]},
     Annotation[#, "Charting`Private`Tag$1327346#3"]& ], 
    TagBox[
     {RGBColor[0, 0, 1], Thickness[Tiny], Opacity[1.], 
      Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQXRT8Myct7Zn9rJkgsNKe4ePtTYunIfj9fft+PDiG
4H/mmcZWqf8czj+yRnCt0kQE36ty9ZOHHxB88c7wefsiXsD5AbuWf1izE8G/
oMd1dIfSSzif9UKX1q1OBH/5pPUavK8Q/Akznq2IDXoF5z/df/Dg/s0I/nvh
3dnmwq/hfIfVx6afqULw/yaXxRTfRvAZEywWm7u8gfN3d0hUC65G8B9emvP6
D9dbON8vwfgeazGCr86fl6lwBcF3Z9xdFmH7Ds6XUVATXbYEwY9LMPVhZX0P
5z9/HMbalIvg3+mQCRc4j+A76zLIRol/QLjPvPq8lTeC/zLIw29JNZJ8v1yf
zAYE//mj5mnzHyP4J92ss1cLf4Tz/c/8ZjjmjuB3J/ElZ1Yg+Er8G3rFVyD4
MXejKq/cRvB99oQbSvF8gvMf7IldleeA4Gud2/reuxDBP/91zl/jhQi+uH3v
Ga2rCL7ozPPpq1g/w/nbRaSPWFgh+JuXfX1xMRfBT/VUuvV5LoK/mzeiR+US
gn/80X2ue0xf4Hy9c98CFxkh+Ba3xaJK0xD8Hz869C5OQ/AXqLP9ObcRwXcP
az555gyCDwC67cNS
       "]]},
     Annotation[#, "Charting`Private`Tag$1327346#4"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.7000000122448979, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.7000000122448979, 1.299999987755102}, {0, 0.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.676167346230878*^9, 3.6761674630874233`*^9}, {
   3.676168038202511*^9, 3.676168103610561*^9}, 3.676168162232832*^9, {
   3.6761683342794113`*^9, 3.676168342709488*^9}, 3.676207044818871*^9, 
   3.688048272154298*^9, 3.688048325194643*^9, {3.6880490974948*^9, 
   3.688049127680625*^9}, 3.688051194098095*^9, 3.6880553391153603`*^9, 
   3.6880584233444023`*^9, 3.688059338120545*^9, 3.6880599910514174`*^9, 
   3.688069621206312*^9, 3.688069859932604*^9, 3.688102357537681*^9, 
   3.688102495970216*^9, 3.688596643071254*^9, 3.72055018685455*^9, {
   3.720617237903246*^9, 3.7206172823549232`*^9}, 3.793843806223611*^9, 
   3.7938439195502357`*^9, 3.793844021568252*^9, 3.8232295684304733`*^9},
 CellLabel->
  "Out[3289]=",ExpressionUUID->"ebc8044b-aa11-46dd-9011-024547e3cf8f"]
}, Open  ]],

Cell["Robust minmax solution for two impulses", "Text",
 CellChangeTimes->{{3.676147586319213*^9, 3.676147638502285*^9}, {
  3.676147980893701*^9, 3.676147992419711*^9}, {3.676163170667118*^9, 
  3.6761631736642036`*^9}, {3.6762069559869423`*^9, 3.6762070101503353`*^9}, {
  3.688054514452976*^9, 3.688054534619801*^9}, {3.720551255406342*^9, 
  3.7205512749398823`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"184cbb7b-bdcb-4826-8f39-131a3b6af2b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"j", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a0", "+", 
        RowBox[{"a1", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"\[Omega]", " ", "t1"}], "]"}]}], "+", 
        RowBox[{"a2", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"\[Omega]", " ", "t2"}], "]"}]}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a1", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"\[Omega]", " ", "t1"}], "]"}]}], "+", 
        RowBox[{"a2", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"\[Omega]", " ", "t2"}], "]"}]}]}], ")"}], "2"]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a2", "\[Rule]", "a0"}], ",", 
      RowBox[{"a1", "\[Rule]", 
       RowBox[{"1", "-", 
        RowBox[{"2", "a0"}]}]}], ",", 
      RowBox[{"t2", "\[Rule]", 
       RowBox[{"2", " ", "t1"}]}]}], "}"}]}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.720551276349134*^9, 3.720551342194063*^9}, {
  3.7205513799810047`*^9, 3.720551409019944*^9}, {3.7205515506750193`*^9, 
  3.7205515918745193`*^9}, {3.720551624541114*^9, 3.720551637308655*^9}},
 CellLabel->
  "In[3290]:=",ExpressionUUID->"9033b492-ec80-43db-a563-af3084402f57"],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"2", " ", "a0"}], "+", 
    RowBox[{"2", " ", "a0", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"t1", " ", "\[Omega]"}], "]"}]}]}], ")"}], "2"]], "Output",
 CellChangeTimes->{{3.720551384233364*^9, 3.720551409521298*^9}, 
   3.720551552329628*^9, {3.7205515826628237`*^9, 3.720551593605608*^9}, {
   3.7205516311284723`*^9, 3.7205516379110603`*^9}, 3.7938438062467747`*^9, 
   3.793843919572967*^9, 3.7938440215939617`*^9, 3.823229568458192*^9},
 CellLabel->
  "Out[3290]=",ExpressionUUID->"a66cdbb0-641e-4c2e-b914-cad59f3826c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"j1", "=", 
   RowBox[{"Abs", "[", 
    RowBox[{"1", "-", 
     RowBox[{"2", " ", "a0"}], "+", 
     RowBox[{"2", " ", "a0", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"t1", " ", "\[Omega]"}], "]"}]}]}], "]"}]}], ";", " ", 
  RowBox[{"j1max", "=", 
   RowBox[{"j1", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a0", "\[Rule]", 
       FractionBox["1", 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox[
            RowBox[{"Cos", "[", 
             RowBox[{
              FractionBox["\[Pi]", "2"], "\[Epsilon]"}], "]"}], "2"]}], 
          ")"}]}]]}], ",", 
      RowBox[{"t1", "\[Rule]", "\[Pi]"}], ",", 
      RowBox[{"\[Epsilon]", "\[Rule]", "0.2"}], ",", 
      RowBox[{"\[Omega]", "\[Rule]", "1"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"j1", "//.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a0", "\[Rule]", 
         FractionBox["1", 
          RowBox[{"2", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox[
              RowBox[{"Cos", "[", 
               RowBox[{
                FractionBox["\[Pi]", "2"], "\[Epsilon]"}], "]"}], "2"]}], 
            ")"}]}]]}], ",", 
        RowBox[{"t1", "\[Rule]", "\[Pi]"}], ",", 
        RowBox[{"\[Epsilon]", "\[Rule]", "0.2"}]}], "}"}]}], ",", "j1max"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", "0.7", ",", "1.3"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Blue", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.720551859171225*^9, 3.720551877895689*^9}, {
  3.720552668060094*^9, 3.72055267214869*^9}, {3.720555948540452*^9, 
  3.720555960075053*^9}, {3.7206170261526937`*^9, 3.720617168288059*^9}, {
  3.7206172174712973`*^9, 3.720617221853568*^9}, {3.720617275239571*^9, 
  3.720617275570513*^9}},
 CellLabel->
  "In[3291]:=",ExpressionUUID->"f1804941-9824-4152-ab33-db912feaf7cd"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt2Hc41e0bAPCjIokkpDJDRHZKvLiRiBTJqiTZZe8tVCLCK7Nkc87XKBJl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       "]]},
     Annotation[#, "Charting`Private`Tag$1327468#1"]& ], 
    TagBox[
     {RGBColor[0, 0, 1], Thickness[Tiny], Opacity[1.], 
      Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQXRT8Myct7Zn9g9/alS9Xr7Rn+Hh70+JpCH5/374f
D44h+J95prFV6j+H84+sEVyrNBHB96pc/eThBwRfvDN83r6IF3B+wK7lH9bs
RPAv6HEd3aH0Es5nvdCldasTwV8+ab0G7ysEf8KMZytig17B+U/3Hzy4fzOC
/154d7a58Gs432H1selnqhD8v8llMcW3EXzGBIvF5i5v4PzdHRLVgqsR/IeX
5rz+w/UWzvdLML7HWozgq/PnZSpcQfDdGXeXRdi+g/NlFNREly1B8OMSTH1Y
Wd/D+c8fh7E25SL4dzpkwgXOI/jOugyyUeIfEO4zrz5v5Y3gvwzy8FtSjSTf
L9cnswHBf/6oedr8xwj+STfr7NXCH+F8/zO/GY65I/jdSXzJmRUIvhL/hl7x
FQh+zN2oyiu3EXyfPeGGUjyf4PwHe2JX5Tkg+Frntr73LkTwz3+d89d4IYIv
bt97Rusqgi8683z6KtbPcP52EekjFlYI/uZlX19czEXwUz2Vbn2ei+Dv5o3o
UbmE4B9/dJ/rHtMXOF/v3LfARUYIvsVtsajSNAT/x48OvYvTEPwF6mx/zm1E
8N3Dmk+eOYPgAwCEVNyC
       "]]},
     Annotation[#, "Charting`Private`Tag$1327468#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.7000000122448979, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.720551879688414*^9, 3.7205526729067087`*^9, {3.7205559512149353`*^9, 
   3.720555960529722*^9}, 3.720617037285331*^9, 3.720617087723785*^9, {
   3.720617163859206*^9, 3.720617169443009*^9}, 3.72061722249949*^9, 
   3.720617275975931*^9, 3.793843806299554*^9, 3.793843919619451*^9, 
   3.793844021641732*^9, 3.8232295685122843`*^9},
 CellLabel->
  "Out[3292]=",ExpressionUUID->"d2e219a3-c81b-47d0-ba19-e8ebc07251ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"j1", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a0", "\[Rule]", 
       FractionBox["1", 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox[
            RowBox[{"Cos", "[", 
             RowBox[{
              FractionBox["\[Pi]", "2"], "\[Epsilon]"}], "]"}], "2"]}], 
          ")"}]}]]}], ",", 
      RowBox[{"t1", "\[Rule]", "\[Pi]"}], ",", 
      RowBox[{"\[Epsilon]", "\[Rule]", "0.2"}], ",", 
      RowBox[{"\[Omega]", "\[Rule]", "1"}]}], "}"}]}], ",", 
   RowBox[{"j1", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a0", "\[Rule]", 
       FractionBox["1", 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox[
            RowBox[{"Cos", "[", 
             RowBox[{
              FractionBox["\[Pi]", "2"], "\[Epsilon]"}], "]"}], "2"]}], 
          ")"}]}]]}], ",", 
      RowBox[{"t1", "\[Rule]", "\[Pi]"}], ",", 
      RowBox[{"\[Epsilon]", "\[Rule]", "0.2"}], ",", 
      RowBox[{"\[Omega]", "\[Rule]", 
       RowBox[{"1", "-", "\[Epsilon]"}]}]}], "}"}]}], ",", 
   RowBox[{"j1", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a0", "\[Rule]", 
       FractionBox["1", 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox[
            RowBox[{"Cos", "[", 
             RowBox[{
              FractionBox["\[Pi]", "2"], "\[Epsilon]"}], "]"}], "2"]}], 
          ")"}]}]]}], ",", 
      RowBox[{"t1", "\[Rule]", "\[Pi]"}], ",", 
      RowBox[{"\[Epsilon]", "\[Rule]", "0.2"}], ",", 
      RowBox[{"\[Omega]", "\[Rule]", 
       RowBox[{"1", "+", "\[Epsilon]"}]}]}], "}"}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.7205531250526533`*^9, 3.720553242936597*^9}, {
  3.720553701331307*^9, 3.720553739909631*^9}, {3.7205542310319233`*^9, 
  3.720554239070928*^9}, {3.72055427918259*^9, 3.720554296387239*^9}, {
  3.72055437668608*^9, 3.7205543968202457`*^9}, {3.72055599755062*^9, 
  3.720556027732357*^9}},
 CellLabel->
  "In[3293]:=",ExpressionUUID->"fd8d9467-a344-4d70-a4af-2bb73db75f78"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.05013970951221558`", ",", "0.05013970951221575`", ",", 
   "0.05013970951221569`"}], "}"}]], "Output",
 CellChangeTimes->{{3.720553728694861*^9, 3.7205537404120817`*^9}, 
   3.720554239946085*^9, 3.720554297084484*^9, {3.720554378711193*^9, 
   3.720554400444274*^9}, 3.7205560284311857`*^9, 3.7938438063064423`*^9, 
   3.793843919627035*^9, 3.793844021649426*^9, 3.823229568520041*^9},
 CellLabel->
  "Out[3293]=",ExpressionUUID->"d742c2eb-6216-475a-92a4-2836ae0b719c"]
}, Open  ]],

Cell["\<\
The three values are equal.  (They are at the intersection of the horizontal \
dashed line above with the curve.)\
\>", "Text",
 CellChangeTimes->{{3.7938439707275867`*^9, 3.793844006178759*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"7070d09f-2f45-4b05-b88d-9a898b0a6965"]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 72}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"fccc2af9-cf03-4988-b907-ece8530ed390"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 533, 8, 67, "Section",ExpressionUUID->"923c81a9-255c-429c-b29f-5431a92dc26d"],
Cell[1116, 32, 175, 4, 30, "Input",ExpressionUUID->"1768999d-baa5-46ab-9695-c02d626d69d2"],
Cell[1294, 38, 212, 4, 52, "Text",ExpressionUUID->"7666c335-cc71-4990-b8c5-a9a5e115f813"],
Cell[CellGroupData[{
Cell[1531, 46, 760, 22, 36, "Input",ExpressionUUID->"06a52413-30e1-4ee5-af55-f895a7172ba5"],
Cell[2294, 70, 921, 18, 36, "Output",ExpressionUUID->"a01dbca9-af59-4875-93e7-0b7bf92ef165"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3252, 93, 359, 10, 30, "Input",ExpressionUUID->"1f54e28d-acbe-4eec-ad16-74534409ba7d"],
Cell[3614, 105, 573, 14, 50, "Output",ExpressionUUID->"098a6432-5c15-4f14-8908-b834a41d0c62"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4224, 124, 586, 14, 47, "Input",ExpressionUUID->"86545af4-c7e7-43c2-afbe-315b4c8136e5"],
Cell[4813, 140, 703, 15, 53, "Output",ExpressionUUID->"1fb0cfb8-93d2-4bc0-a021-b30a58be1d60"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5553, 160, 969, 20, 30, "Input",ExpressionUUID->"453a3edf-9f79-47d1-a77e-796a59e3f64d"],
Cell[6525, 182, 860, 18, 61, "Output",ExpressionUUID->"c134453a-f1fa-4846-b12e-734c15f2ff65"]
}, Open  ]],
Cell[7400, 203, 267, 6, 52, "Text",ExpressionUUID->"13250df8-894b-44da-b8c6-3fd6e2a776c5"],
Cell[CellGroupData[{
Cell[7692, 213, 953, 29, 36, "Input",ExpressionUUID->"10569752-dff8-464b-add2-d80accedf0b2"],
Cell[8648, 244, 1191, 31, 37, "Output",ExpressionUUID->"fe252f06-7b3e-4191-80b0-6d797c0ceb28"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9876, 280, 479, 13, 30, "Input",ExpressionUUID->"0367ee78-5e08-42d3-8b16-3c90a1c4f6b7"],
Cell[10358, 295, 656, 16, 37, "Output",ExpressionUUID->"c7634ce6-9cb3-4153-b48f-94053fd37f14"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11051, 316, 694, 15, 33, "Input",ExpressionUUID->"145b31ea-c47d-47de-b787-d505e9b1b2c7"],
Cell[11748, 333, 1175, 25, 41, "Output",ExpressionUUID->"11aa207c-a1de-4301-8270-7c6630c49fc7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12960, 363, 823, 21, 47, "Input",ExpressionUUID->"983fa6a7-939c-4593-888d-892a9eaec00e"],
Cell[13786, 386, 860, 16, 46, "Output",ExpressionUUID->"9b21f5ff-0bdf-4fed-8759-59a904f65910"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14683, 407, 432, 13, 30, "Input",ExpressionUUID->"31457738-061b-4d9b-bfb3-fae8325ddc82"],
Cell[15118, 422, 611, 15, 37, "Output",ExpressionUUID->"de55e81b-3af9-4a06-b1a9-bd51f85a3164"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15766, 442, 517, 13, 30, "Input",ExpressionUUID->"de76bd5c-bb7d-43d7-a537-0aaf1da6011f"],
Cell[16286, 457, 827, 18, 61, "Output",ExpressionUUID->"e3e917d0-7df1-4264-9393-d952115791bf"]
}, Open  ]],
Cell[17128, 478, 452, 8, 52, "Text",ExpressionUUID->"583195cb-1d20-4a7f-83bc-a00e342d4a04"],
Cell[CellGroupData[{
Cell[17605, 490, 1373, 40, 79, "Input",ExpressionUUID->"da8b0209-b769-4439-b4f6-6cc4f4a2ea9d"],
Cell[18981, 532, 1007, 25, 50, "Output",ExpressionUUID->"7a7f6116-d00f-430c-835e-f42369008e98"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20025, 562, 335, 9, 33, "Input",ExpressionUUID->"4b8f2eb7-4021-4a09-8409-8b032c113380"],
Cell[20363, 573, 992, 24, 34, "Output",ExpressionUUID->"6353c665-9cd9-4cff-9410-4cfa055309e5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21392, 602, 300, 7, 30, "Input",ExpressionUUID->"bc1cbc2c-5714-4921-94f1-281e1cb23204"],
Cell[21695, 611, 1129, 29, 34, "Output",ExpressionUUID->"4ddfa4b9-a6da-452d-b81e-7a0e4e737bee"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22861, 645, 269, 6, 30, "Input",ExpressionUUID->"de9af7fc-c970-46cf-983d-00d1f3e2e76b"],
Cell[23133, 653, 920, 24, 34, "Output",ExpressionUUID->"8fd6ab8d-386c-45c6-8eb8-75667e0c2f5f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24090, 682, 320, 7, 30, "Input",ExpressionUUID->"199005b4-be87-4577-bdd1-c60850db7225"],
Cell[24413, 691, 743, 17, 51, "Output",ExpressionUUID->"945be0c1-5f1c-44de-b3ec-a7c94cadebc5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25193, 713, 705, 20, 71, "Input",ExpressionUUID->"35773e25-bf7c-4f6c-b667-5ab9f14c8b3b"],
Cell[25901, 735, 719, 17, 61, "Output",ExpressionUUID->"e976e547-618a-4990-95d5-e113386dad4c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26657, 757, 464, 13, 48, "Input",ExpressionUUID->"40fd6b3d-91bd-4ec1-8023-164660ea6fa7"],
Cell[27124, 772, 465, 10, 46, "Output",ExpressionUUID->"e952be94-40b4-4e19-881f-96c69c7baff1"]
}, Open  ]],
Cell[27604, 785, 330, 8, 52, "Text",ExpressionUUID->"8a21faa1-7e14-4f12-8184-ce26787756c5"],
Cell[CellGroupData[{
Cell[27959, 797, 1415, 41, 76, "Input",ExpressionUUID->"8e8571ac-1b5a-4492-9131-79cc901cebfd"],
Cell[29377, 840, 18457, 327, 253, "Output",ExpressionUUID->"914397f6-683f-442d-883b-e12226e9d841"]
}, Open  ]],
Cell[47849, 1170, 626, 15, 76, "Text",ExpressionUUID->"eedf8250-f2ac-4840-880f-221c4692d1dc"],
Cell[CellGroupData[{
Cell[48500, 1189, 885, 26, 44, "Input",ExpressionUUID->"fb0b3838-b393-4ecb-b637-4ea54edc8b61"],
Cell[49388, 1217, 927, 24, 57, "Output",ExpressionUUID->"0d7d8e95-a523-4f5c-83fd-133d71fc6ed0"]
}, Open  ]],
Cell[50330, 1244, 540, 11, 52, "Text",ExpressionUUID->"c31e7ed1-f095-46d6-837b-c21f4de14059"],
Cell[CellGroupData[{
Cell[50895, 1259, 3591, 111, 360, "Input",ExpressionUUID->"290cd922-4c64-48fe-9f9b-c05e29057478"],
Cell[54489, 1372, 82987, 1386, 250, "Output",ExpressionUUID->"af76131c-9399-4c03-a8e7-75d259c4042b"]
}, Open  ]],
Cell[137491, 2761, 539, 9, 52, "Text",ExpressionUUID->"3cfa3ad7-a907-4c6c-8112-12aa7be00c88"],
Cell[138033, 2772, 674, 19, 30, "Input",ExpressionUUID->"7b34a594-7fca-4dcc-bccc-83561b8c78c5"],
Cell[138710, 2793, 651, 14, 94, "Input",ExpressionUUID->"b5676bd1-ce32-47be-ab1b-974583a6ecd3"],
Cell[139364, 2809, 573, 11, 52, "Text",ExpressionUUID->"836d00c6-6e0b-4dd1-b9eb-0a2308a06b80"],
Cell[CellGroupData[{
Cell[139962, 2824, 1147, 34, 73, "Input",ExpressionUUID->"968b94fd-359c-418c-8f21-c85a763d1e5d"],
Cell[141112, 2860, 49958, 838, 250, "Output",ExpressionUUID->"be4b64ff-7b81-4e6c-828a-64332e8fe4e2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[191107, 3703, 1863, 49, 95, "Input",ExpressionUUID->"5710a3fa-7b93-4ff9-a9a5-8c4c632ccc1a"],
Cell[192973, 3754, 1551, 45, 75, "Output",ExpressionUUID->"e412421b-b588-4904-8012-13915b255d50"],
Cell[194527, 3801, 462, 11, 52, "Output",ExpressionUUID->"6e74cf3e-1e97-4211-8978-79c46fb742fd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[195026, 3817, 262, 6, 30, "Input",ExpressionUUID->"2f0f4dac-1187-4812-8ac0-937bcb7e3717"],
Cell[195291, 3825, 409, 9, 50, "Output",ExpressionUUID->"a3df1c03-2e5c-4015-8085-7d0b2d896c54"]
}, Open  ]],
Cell[CellGroupData[{
Cell[195737, 3839, 1101, 33, 77, "Input",ExpressionUUID->"9b423f06-5838-4e14-bd38-59f405e9f0ac"],
Cell[196841, 3874, 49878, 838, 239, "Output",ExpressionUUID->"32b81d27-6719-405c-b898-47a7126aac82"]
}, Open  ]],
Cell[CellGroupData[{
Cell[246756, 4717, 684, 19, 49, "Input",ExpressionUUID->"20f08c2d-905b-452d-b6ce-f4cf45fe776a"],
Cell[247443, 4738, 504, 11, 52, "Output",ExpressionUUID->"52f9f0e4-4bb8-4444-ad50-f1984e8b9866"]
}, Open  ]],
Cell[247962, 4752, 628, 12, 100, "Text",ExpressionUUID->"382aab5a-e519-478c-829f-3e157442cb67"],
Cell[CellGroupData[{
Cell[248615, 4768, 1489, 40, 54, "Input",ExpressionUUID->"422e2b37-1c69-4bdc-83b8-eb95e448d7af"],
Cell[250107, 4810, 718, 17, 37, "Output",ExpressionUUID->"10830735-3e87-4816-bc1c-bff409a42e5e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[250862, 4832, 502, 13, 30, "Input",ExpressionUUID->"dd8640ad-c5d1-4b65-98da-851c851187c3"],
Cell[251367, 4847, 558, 11, 34, "Output",ExpressionUUID->"d75f5f2f-cc3f-4623-a5bf-52700acfc327"]
}, Open  ]],
Cell[CellGroupData[{
Cell[251962, 4863, 413, 10, 30, "Input",ExpressionUUID->"333e34ac-f333-41d6-b064-d84cc6c99254"],
Cell[252378, 4875, 483, 8, 34, "Output",ExpressionUUID->"8edc78de-0cbf-41e1-ab14-8711dc4f3ba2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[252898, 4888, 1647, 45, 103, "Input",ExpressionUUID->"fc52c996-c944-456c-bc91-d1b1d960f505"],
Cell[254548, 4935, 17415, 308, 253, "Output",ExpressionUUID->"ebc8044b-aa11-46dd-9011-024547e3cf8f"]
}, Open  ]],
Cell[271978, 5246, 474, 8, 52, "Text",ExpressionUUID->"184cbb7b-bdcb-4826-8f39-131a3b6af2b6"],
Cell[CellGroupData[{
Cell[272477, 5258, 1283, 36, 52, "Input",ExpressionUUID->"9033b492-ec80-43db-a563-af3084402f57"],
Cell[273763, 5296, 612, 13, 34, "Output",ExpressionUUID->"a66cdbb0-641e-4c2e-b914-cad59f3826c8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[274412, 5314, 2133, 61, 165, "Input",ExpressionUUID->"f1804941-9824-4152-ab33-db912feaf7cd"],
Cell[276548, 5377, 9672, 181, 236, "Output",ExpressionUUID->"d2e219a3-c81b-47d0-ba19-e8ebc07251ab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[286257, 5563, 2123, 59, 164, "Input",ExpressionUUID->"fd8d9467-a344-4d70-a4af-2bb73db75f78"],
Cell[288383, 5624, 515, 10, 34, "Output",ExpressionUUID->"d742c2eb-6216-475a-92a4-2836ae0b719c"]
}, Open  ]],
Cell[288913, 5637, 294, 6, 35, "Text",ExpressionUUID->"7070d09f-2f45-4b05-b88d-9a898b0a6965"]
}, Open  ]]
}
]
*)

