(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    409503,       7288]
NotebookOptionsPosition[    404826,       7201]
NotebookOutlinePosition[    405223,       7217]
CellTagsIndexPosition[    405180,       7214]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["First-order system with uncertain delay (Problem 9.13)", "Section",
 CellChangeTimes->{{3.598129551443716*^9, 3.598129565727316*^9}, {
  3.793843092290638*^9, 
  3.793843096777795*^9}},ExpressionUUID->"c22289c3-d84e-45f2-89f7-\
8af888a173f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[3468]:=",ExpressionUUID->"ba18ade7-c756-46d1-9f77-14f5ec570912"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"w", "=", 
   FractionBox[
    RowBox[{"2.1", "s", " ", 
     SubscriptBox["t", "max"]}], 
    RowBox[{"1", "+", 
     RowBox[{"s", " ", 
      SubscriptBox["t", "max"]}]}]]}], ";", " ", 
  RowBox[{"g", " ", "=", " ", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", 
      RowBox[{"s", " ", "\[Tau]", " "}]}]], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"s", " ", 
        SubscriptBox["t", "max"]}], "2"]}]]}]}], ";", " ", 
  RowBox[{"t0", "=", 
   FractionBox[
    RowBox[{" ", 
     RowBox[{"g", " ", "k"}]}], 
    RowBox[{"1", "+", 
     RowBox[{"g", " ", "k"}]}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", " ", "=", " ", 
   RowBox[{
    RowBox[{"w", " ", "t0"}], " ", "/.", 
    RowBox[{"s", "\[Rule]", 
     RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]}]}]}], ";", " ", 
  RowBox[{"magf0", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"ComplexExpand", "[", 
      RowBox[{"Abs", "[", "f", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Tau]", ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["t", "max"], ">", "0"}], ",", 
       RowBox[{"k", ">", "0"}], ",", 
       RowBox[{"\[Omega]", ">", "0"}]}], "}"}]}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.673318605940222*^9, 3.673318817205516*^9}, {
   3.67331885660378*^9, 3.673318908776506*^9}, {3.673318961545616*^9, 
   3.673319005983625*^9}, 3.673319241621044*^9, {3.673320061341494*^9, 
   3.6733201227719707`*^9}, {3.673564423856251*^9, 3.673564452277302*^9}, 
   3.6735723393609858`*^9, {3.673664568054369*^9, 3.6736645773658333`*^9}, {
   3.673664703096181*^9, 3.67366472001744*^9}},
 CellLabel->
  "In[3469]:=",ExpressionUUID->"217703fd-81cc-4893-bb7d-89ba2395965c"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2.1`", " ", "k", " ", "\[Omega]", " ", 
   SubscriptBox["t", "max"]}], 
  SqrtBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["k", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Tau]", "2"], " ", 
       SuperscriptBox["\[Omega]", "2"]}], "+", 
      RowBox[{"2", " ", "k", " ", 
       RowBox[{"Cos", "[", 
        FractionBox[
         RowBox[{"\[Omega]", " ", 
          SubscriptBox["t", "max"]}], "2"], "]"}]}], "-", 
      RowBox[{"2", " ", "k", " ", "\[Tau]", " ", "\[Omega]", " ", 
       RowBox[{"Sin", "[", 
        FractionBox[
         RowBox[{"\[Omega]", " ", 
          SubscriptBox["t", "max"]}], "2"], "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["\[Omega]", "2"], " ", 
       SubsuperscriptBox["t", "max", "2"]}]}], ")"}]}]]]], "Output",
 CellChangeTimes->{3.673726067845419*^9, 3.675731875426216*^9, 
  3.793843117150854*^9, 3.793843268221834*^9, 3.823229793909441*^9},
 CellLabel->
  "Out[3470]=",ExpressionUUID->"a279b242-04ce-4c84-9d47-c6c25c4f6a5f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t0", "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.673665739287558*^9, 3.673665746620307*^9}},
 CellLabel->
  "In[3471]:=",ExpressionUUID->"b37fb442-05b7-4e9f-b12a-b8be80fa212e"],

Cell[BoxData[
 FractionBox["k", 
  RowBox[{"k", "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     FractionBox[
      RowBox[{"s", " ", 
       SubscriptBox["t", "max"]}], "2"]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"s", " ", "\[Tau]"}]}], ")"}]}]}]]], "Output",
 CellChangeTimes->{{3.673320123368907*^9, 3.673320127752084*^9}, 
   3.673537580776618*^9, {3.6735644074249268`*^9, 3.673564455175911*^9}, 
   3.6735700894695053`*^9, 3.6735722954296513`*^9, 3.6735723414983883`*^9, 
   3.673582926444515*^9, 3.673583443858083*^9, 3.673583999135632*^9, 
   3.673584148899268*^9, {3.673664564497054*^9, 3.673664581928516*^9}, 
   3.673664721674363*^9, 3.673664759227631*^9, 3.673665442557646*^9, 
   3.6736654790389977`*^9, {3.673665741242002*^9, 3.673665747179233*^9}, 
   3.6737260679337063`*^9, 3.6757318754883947`*^9, 3.7938431171735783`*^9, 
   3.793843268250381*^9, 3.823229793936953*^9},
 CellLabel->
  "Out[3471]=",ExpressionUUID->"7f4f6333-7f38-42d1-a815-1c10581568f9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", "magf0", "]"}]], "Input",
 CellChangeTimes->{{3.67366462006362*^9, 3.673664664763688*^9}, {
  3.673664938321836*^9, 3.6736649798624287`*^9}},
 CellLabel->
  "In[3472]:=",ExpressionUUID->"7fb7ff62-0769-4965-a84d-5eb7490cac8e"],

Cell["\<\
\\frac{2.1 k \\omega  t_{\\max }}{\\sqrt{\\left(\\omega ^2 t_{\\max \
}^2+1\\right) \\left(k^2-2 k \\tau 
   \\omega  \\sin \\left(\\frac{\\omega  t_{\\max }}{2}\\right)+2 k \\cos \
\\left(\\frac{\\omega  t_{\\max
   }}{2}\\right)+\\tau ^2 \\omega ^2+1\\right)}}\
\>", "Output",
 CellChangeTimes->{{3.6736646294211483`*^9, 3.673664669330652*^9}, 
   3.673664725940341*^9, 3.673664759287897*^9, {3.6736649388266907`*^9, 
   3.673664981630974*^9}, 3.673665442614057*^9, 3.673665479103182*^9, 
   3.673726068009241*^9, 3.675731875539484*^9, 3.7938431172126904`*^9, 
   3.793843268282696*^9, 3.8232297939633207`*^9},
 CellLabel->
  "Out[3472]//TeXForm=",ExpressionUUID->"ecee79e5-acc7-4bdf-9757-\
7c5f8f86139a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"magf", "=", 
  RowBox[{"magf0", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Tau]", "\[Rule]", "1"}], ",", 
     RowBox[{
      SubscriptBox["t", "max"], "\[Rule]", "0.1"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.673319013053083*^9, 3.673319041152306*^9}, {
   3.673319246180567*^9, 3.67331924781109*^9}, 3.673664731745199*^9},
 CellLabel->
  "In[3473]:=",ExpressionUUID->"397fc16a-646e-423b-afd1-97475add7237"],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.21000000000000002`", " ", "k", " ", "\[Omega]"}], 
  SqrtBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"0.010000000000000002`", " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["k", "2"], "+", 
      SuperscriptBox["\[Omega]", "2"], "+", 
      RowBox[{"2", " ", "k", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"0.05`", " ", "\[Omega]"}], "]"}]}], "-", 
      RowBox[{"2", " ", "k", " ", "\[Omega]", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"0.05`", " ", "\[Omega]"}], "]"}]}]}], ")"}]}]]]], "Output",
 CellChangeTimes->{
  3.673319042193227*^9, 3.673319248504931*^9, 3.6733200915982924`*^9, 
   3.673320127802363*^9, 3.673537580829708*^9, {3.673564407456685*^9, 
   3.673564455223975*^9}, 3.673570089522599*^9, 3.673572295464038*^9, 
   3.673582926472589*^9, 3.673583443922105*^9, 3.673583999193695*^9, 
   3.673584148972492*^9, 3.6736645645508757`*^9, 3.673664759360037*^9, 
   3.673665442665221*^9, 3.673665479153885*^9, 3.6737260680739117`*^9, 
   3.675731875586817*^9, 3.793843117217691*^9, 3.793843268288905*^9, 
   3.823229793968823*^9},
 CellLabel->
  "Out[3473]=",ExpressionUUID->"57626ebf-e085-4c7f-8f42-a286db8ee8c5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dmagf", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"magf", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Tau]", "\[Rule]", "1"}], ",", 
        RowBox[{
         SubscriptBox["t", "max"], "\[Rule]", "0.1"}]}], "}"}]}], ",", 
     "\[Omega]"}], "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.6733191585330057`*^9, 3.6733191803834057`*^9}, {
   3.673319214383305*^9, 3.6733192321102247`*^9}, 3.673664733577099*^9},
 CellLabel->
  "In[3474]:=",ExpressionUUID->"7a82e015-c2fd-4251-8998-17c22fb0c91c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"k", " ", 
    RowBox[{"(", 
     RowBox[{"21.`", "\[VeryThinSpace]", "+", 
      RowBox[{"21.`", " ", 
       SuperscriptBox["k", "2"]}], "-", 
      RowBox[{"0.21000000000000005`", " ", 
       SuperscriptBox["\[Omega]", "4"]}], "+", 
      RowBox[{"k", " ", 
       RowBox[{"(", 
        RowBox[{"42.`", "\[VeryThinSpace]", "+", 
         RowBox[{"1.0500000000000003`", " ", 
          SuperscriptBox["\[Omega]", "2"]}], "+", 
         RowBox[{"0.010500000000000002`", " ", 
          SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"0.05`", " ", "\[Omega]"}], "]"}]}], "+", 
      RowBox[{"k", " ", "\[Omega]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "19.95`"}], "+", 
         RowBox[{"0.22050000000000006`", " ", 
          SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"0.05`", " ", "\[Omega]"}], "]"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"99.99999999999999`", "\[VeryThinSpace]", "+", 
      RowBox[{"1.`", " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"0.010000000000000002`", " ", 
         SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["k", "2"], "+", 
        SuperscriptBox["\[Omega]", "2"], "+", 
        RowBox[{"2", " ", "k", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"0.05`", " ", "\[Omega]"}], "]"}]}], "-", 
        RowBox[{"2", " ", "k", " ", "\[Omega]", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"0.05`", " ", "\[Omega]"}], "]"}]}]}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1.`", "\[VeryThinSpace]", "+", 
      SuperscriptBox["k", "2"], "+", 
      SuperscriptBox["\[Omega]", "2"], "+", 
      RowBox[{"2.`", " ", "k", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"0.05`", " ", "\[Omega]"}], "]"}]}], "-", 
      RowBox[{"2.`", " ", "k", " ", "\[Omega]", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"0.05`", " ", "\[Omega]"}], "]"}]}]}], ")"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{{3.673319165735465*^9, 3.673319180823167*^9}, {
   3.673319223305271*^9, 3.673319233922008*^9}, 3.6733200946921253`*^9, 
   3.67332012791568*^9, 3.6735375809455748`*^9, {3.673564407580964*^9, 
   3.6735644553444967`*^9}, 3.6735700896596947`*^9, 3.673572295602871*^9, 
   3.6735829265936747`*^9, 3.673583444041357*^9, 3.673583999306246*^9, 
   3.67358414909204*^9, 3.67366456467453*^9, 3.673664759480235*^9, 
   3.673665442782929*^9, 3.673665479330125*^9, 3.6737260681988983`*^9, 
   3.6757318757017813`*^9, 3.793843117275947*^9, 3.7938432683475437`*^9, 
   3.823229794039171*^9},
 CellLabel->
  "Out[3474]=",ExpressionUUID->"28e77042-cf15-490f-bab7-ecd8269f820b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kwsol", "=", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"magf", "\[Equal]", "1"}], ",", 
      RowBox[{"dmagf", "\[Equal]", "0"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"k", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Omega]", ",", "10"}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.673319188372645*^9, 3.673319202420866*^9}, {
  3.67331925307583*^9, 3.673319285627947*^9}, {3.6733193340060377`*^9, 
  3.673319334908555*^9}, {3.673320186986596*^9, 3.673320187359371*^9}},
 CellLabel->
  "In[3475]:=",ExpressionUUID->"bd29a562-e1fc-4da9-ad8c-062da1cc29f6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k", "\[Rule]", "6.445703948517553`"}], ",", 
   RowBox[{"\[Omega]", "\[Rule]", "10.677930162247426`"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.673319271664824*^9, 3.673319289062114*^9}, 
   3.673319336026547*^9, {3.673320099928049*^9, 3.673320127969561*^9}, 
   3.673320187825756*^9, 3.673537580972357*^9, {3.673564407612452*^9, 
   3.673564455374897*^9}, 3.673570089721424*^9, 3.673572295663155*^9, 
   3.673582926623282*^9, 3.673583444099505*^9, 3.673583999356666*^9, 
   3.673584149128149*^9, 3.6736645647304277`*^9, 3.673664759539445*^9, 
   3.673665442847967*^9, 3.673665479367352*^9, 3.673726068256949*^9, 
   3.675731875758195*^9, 3.793843117310157*^9, 3.79384326837433*^9, 
   3.823229794064122*^9},
 CellLabel->
  "Out[3475]=",ExpressionUUID->"68ab35b9-b441-457d-b70b-97acd7a7a3d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"magf", "/.", 
    RowBox[{"k", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6.445703948517554`", ",", "8"}], "}"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", "0", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.673319339882071*^9, 3.673319379778727*^9}, {
  3.673320200176711*^9, 3.673320203654984*^9}, {3.6735544853820963`*^9, 
  3.67355451023129*^9}},
 CellLabel->
  "In[3476]:=",ExpressionUUID->"c6747734-fbda-4b8f-a445-b5333e4ef58a"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV1Xk4VO8XAPBRtkJJssUwM0yory1SonMSmYhSkmwp2bJEqEhZIxKhRSUi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       "]], LineBox[CompressedData["
1:eJwV13c8Vu8bB3CUyChJSPYzeFTGFw3SdWXk+aJES0Sy94oiI6VIESGUkSKj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       "]], 
      LineBox[CompressedData["
1:eJwV1nk4VV0XAHApU/JWMifDNdzBJSrJ1F7JcCMylDElKleIKHNRKkKEQiUh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       "]]},
     Annotation[#, "Charting`Private`Tag$1995604#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.673319380563547*^9, 3.673320128014926*^9, {3.673320200821465*^9, 
   3.673320204157125*^9}, 3.6735375810283012`*^9, {3.673554496202766*^9, 
   3.67355451065224*^9}, {3.673564407704689*^9, 3.673564455458037*^9}, 
   3.673570089825981*^9, 3.6735722958088913`*^9, 3.673582926711437*^9, 
   3.6735834442797003`*^9, 3.673583999447865*^9, 3.673584149219306*^9, 
   3.673664564850853*^9, 3.673664759634342*^9, 3.673665442931261*^9, 
   3.673665479457487*^9, 3.6737260684623404`*^9, 3.6757318759625187`*^9, 
   3.7938431173514357`*^9, 3.793843268448633*^9, 3.823229794111066*^9},
 CellLabel->
  "Out[3476]=",ExpressionUUID->"8a6604bf-cdd2-4579-9f00-0e95827d9f4b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"l", "=", 
     RowBox[{
      RowBox[{"g", " ", "k"}], " ", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox["t", "max"], "\[Rule]", "0.1"}], ",", 
        RowBox[{"\[Tau]", "\[Rule]", "1"}], ",", 
        RowBox[{"s", "\[Rule]", 
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]}]}], "}"}]}]}], ";", " ", 
    
    RowBox[{"r", "=", 
     RowBox[{
      RowBox[{"w", " ", "l"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox["t", "max"], "\[Rule]", "0.1"}], ",", 
        RowBox[{"\[Tau]", "\[Rule]", "1"}], ",", 
        RowBox[{"s", "\[Rule]", 
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Neg1", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.025", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pall", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Re", "[", "l", "]"}], "+", 
              RowBox[{
               RowBox[{"Abs", "[", "r", "]"}], 
               RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
             RowBox[{
              RowBox[{"Im", "[", "l", "]"}], "+", 
              RowBox[{
               RowBox[{"Abs", "[", "r", "]"}], 
               RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], "}"}], "}"}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "\[Rule]", "6.45"}], ",", 
            RowBox[{"\[Omega]", "\[Rule]", " ", "i"}]}], "}"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "0", ",", 
           RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2"}], ",", "7"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "5"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "LightGray"}], ",", 
         RowBox[{"MaxRecursion", "\[Rule]", "7"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"{", 
          RowBox[{
          "0.02", ",", "0.05", ",", "0.1", ",", "0.2", ",", "0.4", ",", "0.8",
            ",", "1.6", ",", "5", ",", "20", ",", "30", ",", "40", ",", 
           "60"}], "}"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"psol", "=", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"Re", "[", "l", "]"}], "+", 
            RowBox[{
             RowBox[{"Abs", "[", "r", "]"}], 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
           RowBox[{
            RowBox[{"Im", "[", "l", "]"}], "+", 
            RowBox[{
             RowBox[{"Abs", "[", "r", "]"}], 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], "}"}], "}"}], "/.", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{"k", "\[Rule]", "6.45"}], ",", 
          RowBox[{"\[Omega]", "\[Rule]", " ", "10.67"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "0", ",", 
         RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "7"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", "Black", "}"}]}], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "7"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotAll", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"pall", ",", "psol", ",", "Neg1", ",", 
      RowBox[{"Background", "\[Rule]", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0.95", ",", "0.95", ",", "0.95"}], "]"}]}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Re L\>\"", ",", "\"\<Im L\>\""}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", "None"}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"GrayLevel", "[", "0", "]"}], "}"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontFamily", "\[Rule]", "\"\<Gill Sans\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "14"}]}], "}"}]}], ",", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ","}], "}"}], ",", "2", ",", 
           RowBox[{"{", 
            RowBox[{"3", ","}], "}"}], ",", "4", ",", 
           RowBox[{"{", 
            RowBox[{"5", ","}], "}"}], ",", "6", ",", 
           RowBox[{"{", 
            RowBox[{"7", ","}], " ", "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "4"}], ","}], " ", "}"}], ",", 
           RowBox[{"-", "3"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "2"}], ","}], " ", "}"}], ",", 
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.673546228645162*^9, 3.67354626185676*^9}, {
   3.673546623299601*^9, 3.6735466405369883`*^9}, {3.673546676303841*^9, 
   3.6735467060775213`*^9}, {3.6735467555184917`*^9, 3.673546831355968*^9}, {
   3.673546935844124*^9, 3.673546955643811*^9}, {3.673547203032679*^9, 
   3.673547237588078*^9}, 3.673547453209248*^9, {3.67354750883864*^9, 
   3.6735476017317123`*^9}, {3.6735477256475067`*^9, 3.673547764534172*^9}, {
   3.6735478320735817`*^9, 3.6735479315562057`*^9}, {3.673552585451861*^9, 
   3.673552623904572*^9}, {3.673552842994287*^9, 3.673552949175709*^9}, {
   3.673552992202465*^9, 3.673553016273163*^9}, {3.673553048030843*^9, 
   3.673553107618586*^9}, {3.673553158696542*^9, 3.673553246724422*^9}, {
   3.673553295586814*^9, 3.673553468940345*^9}, {3.673554176285386*^9, 
   3.6735541860929193`*^9}, {3.6735542162390537`*^9, 3.673554291321497*^9}, {
   3.6735544333724117`*^9, 3.673554450055607*^9}, {3.673566864287908*^9, 
   3.67356695049772*^9}, {3.673583633745637*^9, 3.673583637509511*^9}, {
   3.673583673458507*^9, 3.6735836890824003`*^9}, {3.673583723046226*^9, 
   3.673583969706106*^9}, {3.673584130408465*^9, 3.6735841367581797`*^9}, {
   3.673664746137392*^9, 3.673664748024922*^9}, {3.673726060598579*^9, 
   3.673726063269302*^9}},
 CellLabel->
  "In[3477]:=",ExpressionUUID->"e66978f5-6fbb-4605-a069-50f19e186a1e"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {GrayLevel[0.85], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJxd3Hc8ld8fAHBKRSWUbGmSiFD2JrKSyIqUmZHZkIyMlBVFMiopJRpkl3vv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        "]]},
      Annotation[#, "Charting`Private`Tag$1995649#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0.85], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJxd3Hc8le/7AHDKJqmMjgbKSEuDQsVJkYpClBEZWRVFSIWUTRvJaNgiHytS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        "]]},
      Annotation[#, "Charting`Private`Tag$1995679#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0.85], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJxd3Gk4Ve3XAHBTJZlTbJmKIimPJkplSwglGs2ZMxVSkiIyU0ilqChTRRqU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        "]]},
      Annotation[#, "Charting`Private`Tag$1995709#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0.85], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJxd3Hc8le/7AHCkJCvEeU5KKfWRykoqRU8ZaYiQdqQdoUFKi9KQSoWQmZFk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        "]]},
      Annotation[#, "Charting`Private`Tag$1995739#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0.85], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJxd3Hk8VN/7APCZOwvKbuYOlaVSKkuSPepoJUtIVEREhWxJpKwtlkSLRBE+
CQlZIy1z2qSsUYpCKKSijWwzvs/8/vz91ev94p57luc85zmv6i5087P1ICgU
ygE6hSL483Cz8ZrXUrKIT4irfSwicJb7ZVWBjx9YYtJdSGDFJekzLeCOtRb2
n24T+JWMbbHA49MXvPsKCOyuU4UELpViRn2+ReC08/XlzeDPv6tSBvIJPKOe
JCTwAemqwqE8AjNlCaMm8Nx+6afDuQRe4Khs0wjOeNfZ8f0mgU8zxjc3CJ53
U/g1kkPgoyrB8vWCn//7LvzrBjzflvfmJThS2H7hn/8IbLAg9lAdWF/Y03As
m8DjsrJfasGenjp2/7IILN7rsPY5+Nb1V76TmQSebzR48TE4aNu5XF4GgfWF
9RK54JE7HU9n0wlMkdbzegi2Llbro4I7PUyfVYNnLJUXMa8S2GZi1/q74Mq2
wQ3CaQRet2tBdjl4JR7dPyeVwEitglIM9r88p1Q8BfozFke9DWa4Gb2XvExg
L2Op/jzwlNNPikwygZ+I6Jhmg//LWeDAuUjgI3vfXb0I/tCvK6uUSODp1rXZ
iYL+JaywXHQO+hu2KzYe/G9k/inlBALPHrs1EQWWyNaZWBZP4Asx9139wEqi
Y1OrzhB4o/wzHy9wVMMZE+3TBD6jEL3bA1xUdyFe9xSBm7IV23eD5VfbKK+J
hv7Ufd2xERzOXxKyMZzA/a9yD6wFuzWserM5DNobmL9bH7x5m9ZqsxMEru1f
2asK3qe+bcoylMD+j0VCpMAtNvnFDkcJXBLdW9cuKYvs6x0eevsSODbQeqAJ
vNtgeJuvD4GdN4d/rgW7rDg44H+IwM/OyJ68C15p4q541Avel7jDLBl8fkD0
aeR+Aiu1HZwyAyvuSe9OcSawfDRdGYHtLitVpe2B+H1yQEMXHNZ7JjndicDp
+2O+LAQvsNZz/m83gUNvGXX9k5BFD4rbNYrtCezWJPknA2xwK6a11orALwMP
L78INk92p7yyJHA0ykVnwNrv5bQbLQj8XC9Gyhf8d3RrUdtWAg86bzA2Al/+
GTT0aTPMX6v1w1ZxWbQixi1pZi2BT3457TEkBvFSMX+uwUoCn9p2x/0dWL3K
4pOKBoHtzLavqwXfO5r5iFQncEi7RMwNsIjFRMrfFQSu2Ba+1wm8mXa1umQp
gVezbYxeiMqiT4zSlhUKEM/xu7Kj5sqiPV3/fVwqRuCbqQekD4Errd9Ok6IE
1o1c4GIPLluQtlRoriC+o86uAG8PX5Q5KEzg+/aumq/nwHoEOyncohM48Prg
bQ5Y95vXfo0ZKq5c3BUUJyyL2k6W5Kz/RsW3Nk05+4F3Hcp11B6m4hWjfxfv
AC+cSlNa+pWKWU7xJkrgom0v3ogMUvGi5171FUKyqLzUYeh1HxV3xJbPf8eU
RRaeWo3unVQ87/WxBxQG5IebJayUl1RcHPozeIgii/rNlZtW5FNx1/HKBy/A
BpSd67TyqDj+SmBfLli5/Rs2yKXiGzb9Le7g9K6AMdMcKn5945VBzywH3e3N
X3Iwi4qHi88ZN/E5KCLOvORWKhVLkb/nX57hoNw3AZ0GcVT82XiorPYfBy2O
leq54EXFcvuttlwHm6dn9GZ4UnFo37qHQeA9/+2duHWQiu+MNVkqg7fb17k9
2U/F9x5/pkaOw/NvX6j9dYP2hVZWrxrjIOfqpv8cHan4t/l/fuG/Ocid8TfS
0IKKn0na3nj4nYPYA6PWazSo+Pnbh1mJ4BMP/E7bqFPx07BzUS7gVcFTLQfU
qLj96b4fFPDO9INFySuoWCFnje/6bxwU570ybHQpFSdqzuPgrxzEqMo6dUuR
itVH/snlDnCQllNy8kopKnbl/E2Q/8RBFTdF8Jm/FHxzS0HoYA8HpQZnK9/4
Aw48Y1EK/k3cu8H9TcHEw4fpG8GyDRm/Jn5SIP+dHPXs5qDIY/cbD/2g4Dtz
zV3vfOSgfTFql3YNUPBg0aJzSzo4SHtvTemW9xQ8VM+u5b7moLfbqzRgZfGr
DemFYeBeQ/aPuPsUvIfhGrgGvGFJStPVGgq2Zldn323hoPOHN04/qIb2yhWj
bzdzUKnnCh5RScGfro7vSGrkoDcHmksvF1Gw97ZN3utectC8+5e3t1+n4DM9
d13WYw4SXusgVxdFwdiSf3yCy0FrRTMW90VSsNpmfKwYrPffsh0zERTsWFUn
Nw9s8sdGY1U4BbevC/8++pCD+BplNemhFJwpK9t7+T4HXRerMzseSMFvonaq
1d/loAeuRaX2HhQc43T2xMdCGE+1xKJ4Mwo+zrpz/jx46a26RQ9NKTgu0vfs
RrD9v2VmP7dQsN7iNu3C2xyUxpMScthMwbNFdx1CC6C9vV9Ml26gYI16ep9U
PgcF2MeM1htR8N/PvOUaNzhoOPCborYmBc954J+yII2DRvp4j0I5FJxmjoJf
pXJQuaPS2SqSghP8+9aFgC2yZyL+sin4aHFZbNsVDtIJlf7sy4L2qyUnY1M4
aNFy4oqHFMxvvc6u0UscNOXtUrZ7LgU7BwqtKUjkIPqcicV1/FmurPvt/I6T
HDQnbIvQ9+ZZLv4QuyUU/Ipl2uTYNMsNLY6vnwcu8m2crm+Y5br9IU86RnPQ
2fsd8UUvZ7mvt8qUfojkoKQ9CieCns5yK6mF4u/COEj1+KFnslWz3DU5ptSa
YA6qbNcvL7o+y7XYfN9Gy5uDUmyTl3P8ZrmUlwsDGrw4KEud9M/2meVetz8S
vB8s/oZUVjs0y51Hmda/6slByzQob9d7znKLRp3OUw5yULvIvj1B+2a5ARu/
p9S5cxBlqElx1GGW+yvZWW+zM4zfo05Z12SWu7fu9KFJaw7Ca0R7OexZ7jY5
ZmgSWDzX479nMrPch4HqAUvAutKxbQHSs1z208QFNts4KFnxzOlGiVluRrLX
wTxLDvLKm1gRP2eW67Kb+LBtK/QnZcV5Wcos1yumy+X8Bg56Gsr1iP/G55aV
nU18rQPxwUlf/eIpn2vwoxW5gQcPlV47/4TP1fiY0/1bm4PK/mof2/2Yz5Vq
FeqSAdu2fEwefcTnNm258cVOi4OcDojYKNbwuR6WfLU2DQ46VBw7mlzC556r
4b3CKhy0YA99V0cGn4vVvfiuchxU/azDtf4Yn3vCqihrTBb2h9xQ9vMQPlc5
64NWHPi10VULHMznHpZhqZRwOKhQZXnf3SA+t3hB4TYem4O6LxZI3Argc69M
GuYlS8N8vBiJyvbkc4Uoster5nKQhghe2b+Lz72zhlBq4ZEozlWdV7iGz53n
aPvLBbzwTazzE0M+t7dNv2J0hkTFLqYa7w343JSpfnEJ8Ii7mhxDn8+tPxQg
azlFooPLZBTctWH8a5yja8dJpJ2Z8VNXnc+1pzn0Fo+SKFnBXk5Tkc/1DDC2
dOgl0ZELtw4G0vncEEbWZMcnEnlacT0u0fjcD3GcK07gI0JJQ+UEn/tK0vOm
aw88P3ktYpzC55aKn5f07iKR07WlY1E8Hld0HC873kEi++DKuWXjPO5FZnjm
+dckmncnxDb4K48buUE16+JjEqGvxOm0Fh5Xp7fgvRTY36z4wIdmHhcpRtMv
YBJV73rcJg9WU3bSTeKSaKO/nWlOI4/rOo9LO/uQRDvTbuZUveJxfb6aWUbe
I1F4Z4LOxDMe9/TO4Q+updC/F6tleu/xuBdevP5BZJPos9WdQLubPK4bp5Ee
m0Wijg3P3Z7mwPtKnkmLgb9HbmnQApcavJDhZJIo9WaFuMwNHtdXa7RgRQaJ
xO+ssO3I4nFncIi2dRqJGqN1PpxI53Hta/hfky+QSCq6YpVSMo+b+sxmVBb8
IUU+4volHleIlvI9/TzMD0EzlQcnfZRszkkiUVuPm8WCizzuJ+c87YpzJJKW
3aGkdJ7HHVRixb2OIxE9sGt6bQKPW1v9NYEZTaKgEzV3O07xuDuP22TGRZHo
V/b16APgPKfsAlGwdNLPV2Mnof1g2ULpSBLVD0+2yIAt5xo7KoTD+xbuL98R
Bf2ZWhagHUqiE4y8dz/DeFyX/d9LHQ9DfPiZNpwK5nE3yrn97AogUaXahNYi
cPGV6mV7wchsiMRHeVxnFZUYd38SGX/LtucFgSc/Tx/yJZGt1uK7YUd43Nfv
qupPeJHolWnM1OUAHrexzn9NqhuJXPixWPkQjztdIbF+Adje6UFomzeP+672
wYYsVxKdcp8uiga3Djrr5+8l0ZaiOxF9XjzuefrFwSpnEk0rHW3J8+RxWS9U
3dt3k0htMF7V7ACPe4ylrLgbHPGwIGR2P8RHR9bbrl0kGu1RXHcX/P7AJp0v
O0nUfGS+/hJw3YQI/mNPIuc1LZ3CHjzuSNOMiOR2Eg17fBgYcONxR3MqIy/Z
kujlf+b1OeDcWM8/JNjy0vbl+8A+Kp8a5G1IVKdqaNvryuMuufTeWnUbidy/
Nzr07+Vxu7yCbmwyJ1HK4R06fGcel97nnhe8gURR45dtkxwhPqU+355aTyLD
cFqAE/iHqkVRGHjpq2CRFeDM4b+5J01ItKAgMr92N4/7Qu7Y0aR1JGK98chk
gNcpv07IXUMi9XUTh6/u5HGv/nbatxycGLRitR+4/LOpXqEhiWKlz/tsBLOF
Xd6VGpBIv2DW+qcDjzuhuGPygR68r7uy1RLMLxt91bqaRB97Lj5VtIfx9M+E
7gBf3yG/bGYHj/vlSu+y91owHwkUoQ6wxqFt4V2rSCR8pWN1Mnjy9TnJoZWw
H4bEt0qChfSXlXiBg7xSo37a8bife95a/tCA+M+MX/0aPPQ29uRvdRKZXyhh
JoMtYxQ6ZlQhnqk6XorgdSrKXhHgLw90g2jgxMaQSSrYaOudqcHtPO4pKXUZ
oRUkEnGdG1QGXlxzcbXUMhJZx11TsQSfa+6tuqRCoqusSKYOeMfd+4YkOPLR
oIs8WKdH3Wj+UsgPIpujR2153MCxjxpLlCEeld1Pp4HDe/Nm0heTKFPZ+9RJ
cGUO8ZIFHvaulvEFz345t4e+CNbnpWr/RjAv/PWSEwshfp/YLV4Fnlau//5H
CfLxy5d/5MGvm5jB/YokCtmdsWnSBsY74mjoCFY+yq8dBEvanptpVYD2n5W8
bwenKtwOeyJPouhSsaK7YMVd3YHZ80nkEftCLgxcpLJwpRx41abX8v7gmsKE
r+fnkcg3TbtsH/gWi+4UKUciydC5CRbgTtZi1oQs5IfcyNcm4KXMC/V+4Af5
tnl6YMN/EfouHBINUCXpS8CVLNZIO0kiIm8mfgG42Fn+hpXA2PQ/FljW/aZD
LRvyaedfMzHwaHnl3LXg2OPUaCZYt8sB2iBRwXy/rRTwlO/lw+rg4RVrb0xZ
87hWE8FLbsqQqFbcL2EMvFVY5P0CcPoigvkLLKFhG58sDc9X/ZP4AeZOOBmJ
gsXZ1gVfwaf+aY2clILng+e+HQDH3+vKnJaE81B6xfnPYErTfptA8Enxwg99
YM6zd8Q3CRL1xV2o6gUTqoYVbmDTtM7FAv+7cMWjUxzma0uMksDLYydJW/DR
S1eKBG5M96x7KUaiy0fm1gvaI11+HTMBH2zvCxG8T9f5quo9URI1XJWvEvTH
ablvlyY4JO3+aUF/K7YdTcqfS6I5WQ8+fwcf3PvARAk8EaD05if42rDZ3ytz
YL/VDWwXzMehsGV5EmDd7RLugvkaz3PdHSMC59XdNLpgPs0n+WKzwnDeJZ7W
Ecx3CGXOk6NginfruCg4yiLh6IgQiWTbIkwF67XvUJLqfrDzhnMrBOt5eN/a
KzuY0P7M80x18MGdPMtGBol2z/2pJYiHWqd9jE3gpjvB9oJ4aWnaelSbDvHV
nm7lAP6yq2dlIQ3yb5P+YkG86a00GV4Mdt68MtYP3PD7oqsMAefp6mW0eDCT
f1nhLBXyS+MyuVSw17mEjwT40KpIbi54KCDU8fcsG61ZufLhc3BA/6kFXmBW
ximWYD9QpG919/LZCB9XmxkAG3W773/NYyPfp74n5sD+undFQs0MLH2HyRbs
t65NU7/xDBu9kvxurAl+dbfyVMk0Gx1qSEM7wS3uLdVJk2y0SWiXyB1wlfGZ
OCHw5kZt5Vrw0qN1jhETbLRIw7a5CyxrIMvw+8dGKdLm7eKQP7Z6/vS2GmOj
3770vGCw84Lui2K/2Kg37ruNO+SrC3fbIk//ZKNtRXT/U+AuvxF/3igbTSis
U7gJbvO65/BjBJ6vklIdAvNyS1DjdzbS5nxjBEH+zH5zIvbcEBu5yOo/ugX5
OIs0zmCAbWfMu1rBLyTvV4QNspFu7c6EGXC8JfndZwBsbXPVBvJ58UO7MKvP
bPTfgGcQAfm/LWCLluQnNrI2D1oSsQvWL3FXwoUemL93Rf1FYMMntl+lwUPz
ZBS7wEG75ArZ3WykpLdTzBjOm2zcvGP+R/j5otAXBJxPS2JzkMp7NvqX73vn
phOP233qRUP+OzYa/SS07iNYz8DSaQX4PZluLrOHx9UqyDyt3s6Gci//QzTY
p16f0H7DRpVdP9oPwPm4c/PMLZMWNnqeI6tnBudnTuWQ39NmNnpZ+jA5Bjxr
Wm6wCfzEVdmvFix5h9ph2sRGUmYqVzfB+WuyynGLdQMbyXy6XGcG53M1/dFX
lzo2ik+4eNLTncc9oSh/PBrD+w/tsWNC/bDwSlU9HVzWtXq9Hfit1dKFMVw2
Wu+xvvA/8P6VmZ1nH7HRhvi/fxHUH97H38ZefsBGC9Yu2XkS6hOpAJGOW9Vs
FErd66roC+dHi0p4ewkbPZ3/bXdFII+7ft7wGZNsNqowEr9jHQn9SYjprMmC
9a8kbtWC1QwldbXB3hNGq42hHpP6KsJQyWSj4Zd7J1SjYX2/FdLEMqA/f45s
lIT67uqGRQmdqWwkLLPs458YHvcO1hQ7cR7id7Xrq6VQL95x7vUfT4L2/Bvu
F4ObVEu7/MFBNruM9C7wuN/y3rR6JLJRTV3JsBnUm6tt9dSsE9hottlkOgjq
VfbFVzeWxkK83lfuH0rlcSN6eUOdEWx0en/qaYP/eNzoGNmT9mAj7ZAtbeDS
spMqreFsZO6rdsUH6uPUSwFJL8PY6O6bLz03oH6u0qr8WH2cjWRH9rE5eZBP
mCpBacFsNMPJZ8oWQn2T9qXHzY+NIpSkS0/e5XF3+5fclnVhIy3nXaGzDVC/
HgiITnNmo32kT3c11Pta5fs95oEXaRnWHW6CfOgrZb1gDxs9U2xUG4L7QaDj
nntKjmwUfd1bv6MV9rv18X5VBza6aDDf6s17HndYn95mvo2NPGX62BpfoN60
mmJUrGOjy31DYj6zsP/ygzX0wWv+rA/aAvcZgwY7jwdrYb4i3zkvovK57res
+c+M2SghLLC6A+4/D5eu7W5fA/Mz1nDSisnn6iw6uIenx0ZH5FN9rMXgPrc6
OnmHJht1U8yVKufzuS03ix9pL4R4k38Zyof7mv1Kj3fPlNhI9E6F+BDc5/xE
A/h24B3znCVb4b63If9GcJAixK96mVOeMbz/jCanSp6NNma0cRxM+Fwa9YWk
8Tw2uvIodm69Kby/99YCOxk22nq44SR9J58rccB7TgkD2n/7PrQG7qNC5d3f
N4CVfq2dy4X76gNs1fOODvHaUcB4BvfZkwrr/s7S2Khl/Q795uN8bmga2WNN
sJGi75pLwxF8brS4+aMxPgtdV/CX0onlc8MzhpvNJ1jozdzNXNk0Pjfq9tOb
K76x0N/LTls5D/jcOsXfo/eGWehourSS1UM+d3VTs5UZ+HxVns9puH9rVlVv
PfiVhXbN5fiPYT73cbCiUd4gCw36ZEp8eM7nLm5YJbr8MwtRzn65+aAZnt+f
k2rUxULrpykX3/fzuUfuZnBuNrPQ3elvbr5is1yq9v56A3D3vZywJ+Kz3NrJ
5stNTSyksevYHI7kLHek7KbvRCML1b5hhz6WnuUGvlFfZdkA7a8MLp4vO8uN
szanTNexkGRcuv2XRbPcsccG0weesJBWW/tEg/4sd+5vXyKukoWUWEbiQx6z
3O8u8rtXgA+t9z+w7sAs95mQwov6Chai7ktTuHJwlvvETr1XHNxaHZS7xXuW
K1m7lEwpYyGGMn1ekf8s9yO+Ept/h4WWH20Jizs+y42e/6Sq6xYL5dIeZcdc
mOXKTlmExV9nofSyuZeTH81yy0yv2K8CH74v/JjAs1ydLdc3v89gIQP96E0B
j2e5nlsmvJaCi9XOO2x7NstdURz0/Ok1Fvq5/HqGxKtZLn2DUy2RxkIOI9kZ
WW9nueevc+UvXmKhszuXN9J+zHI3Jrpb/otloc/r+7+5i1Ow6XvRuRngUzaN
w7oSFKyw5N/n9eDHpuvmiUhSsHXX7R+JMSyUTIbPKZai4KpR8+3LzrCgnnmg
McWi4CZ5qaC9J1ko4UVnyLX5FDyhc2XdQBgLBS3qyqMup+BvnDFrs0AWeq/x
VGjXRgo+yVO1GT8M8SRdUqy7iYKT+Tp+N8CiZ4yiWZsp+LbVBzo/gIX29P4p
btlCwYcTpa9U+LOQ3/J58ubmFLyo+ICTii8LCXktW2tqS8G1qh8uLfZkoas6
eOG+vRTc+3HpRLALC91z2/ieE0bBAXXTk+rg6xeivk2DhS/8kvvszEI7XBqW
fAqn4M/b7SqswS1LzSVuRVLwPfcz21X3sNCnKY0Ko1PQn2EZNLCbhW5EXdLz
PkvBGxYojh22Z6GC364Vn9Mo2O+XWd+QJcTj5zlTm6ooWG7y/KVc8E3iP5vV
1RR87dMqd3fwqZV6DUr3KNjj2aV9nyxgvQPkVszUULBi2s4PHeYsFK3240zF
IwrWYH8pazVjoTkGm++q1lLwlpr4hR83sZC6/ODR1W8puNu66ZfVWhaKUI18
nfOHgn2yg07LgvlnY7/G/aVgwyIHnT5jFgoIc1zgN0bBqks6vgaBSzyXtxr8
o+BjJ9RzrxvBfvTqOdEyRcHn7Md8xwxZiNsZ/oQgqFi0OtChWg/2d3RiYagk
FQf4imolr4L4Ozw2UKFOxRceoB/uYL1MiQ1ZGlT8dUXQcx2wQ7bP3bMrqbij
42vDO00WEvt3v89tFRVvM7DVlwePO0hZS+tQsf9kyskiDRZK62AHBBlR8Yao
7bP9qrAeYmMHLMyp+MyLj0q3lrKQVagKxdCTikf/Tb8NAwsP6xLrvKh4QcBk
kS34ooXz/I3eVNybcK12ZgkLfd9bcNHKh4pDhVuv2oIHCtQvuQdQseLbwtd0
ZRbKuxRfn3yMin+9enDu5EJ4vik1hRFPxYPrD+U4gUc6fRzEzlLxw3sO3Trg
sViaOjuBij+V/bg/pMRC844tIZckUjG92E3BGtyvpN296SIV73Bqjl6iyELX
oqe1z16lYurLxR+HF7DQ3JSeEOXbVDxTHO5SB94fpVWkUUjFIWs8mbng8Zah
P/pFVOwo8++RKzgsbXW15R0qPo4NPnTOZ6Ev/urzQsqpeLz28JO2eZAvhOau
brlPxVlXvzl+koX9cvG31rkG6H/ATm0PNgsZE5VrdEeo+PfXO3sswbq5609r
jVKx5KHwXB2wUXZhp8ZPKl4XeCaFCe583Z6v8hv6t9f75y0W9M+roUVunIqL
h+oSxmVYiDhzwoTCp2KvpT4BedIs1LWnQe+tGIHHcxwTLoHF/Xy6W8UJfCTl
e20E2GPln8QWCQI/vz91dSe4It1HrEGKwHW04UdzwdML3cOfsglcUC7/L1gK
+ptzelGFPIETDt7XPCgJ8fp9mJ6uTuCyxdrrd4J//It+eVWDwKUfDgeagqOS
GSlpKwmsu3KzznLwJbmzm6+sIvBJfxfd7xKwv90/0C7pEHge0lgZAo6avtN7
1pjAS4+GGHuBPWej5M+uJXBs8BVvJ/ABjPbGryPw7a0OKibg7383TsWaEHj6
xdgCUbC53+3wM5sILGXuTs0Xh5/HidyPtiTwyrnOYulg9ri2c7QVgfW9DAzO
g0W7rISitxE46e+VnyFgkzBx7ygbArc7CHebg1MyZ49G7iCw4hPrin9iLLRZ
7OHFiD0Ebthf/egHuKx/97kIZwJvihb92g9emTyUEOFCYDLxREYL+GnzpasR
rgT2zkg4fRt8uMp7JMKDwHl632wPgOtjNb2ifAhsUyd7ygUckSiUc8KXwFbh
vDYH8PGk/N5gPwLLrxxpNgUb+oge9A0gsJzEMX018JJfdzMdgwhsvv6QyxLw
rKrBuP1RAj9mzbupAPbSFLO2DYb5XpWXIAVWPeYrZnYM4kHuYsOEKAvp6wYU
6YYROHexx9ff4K7hjwu0wgn8p2VM+Qf41opFSeoRBM4JspnoBcst5x1XjiKw
yfxpiUaBl1oHSZ8m8IXoZ4vqwB8N+ifFzsB6L7Cyewo+nPQuUiSGwCNzbsjU
gFPe512mxBF4ma8j7Rb4aq1Jx0gCgSXENERvgjsbDfyGzxF4978nq7PBUc/m
CQ0kQnxd0e5JAx+1czTqOk/gnw+l9qWAH7xL73h/gcATEmWMS2AHhbMhby5C
vNCM8xIErlt1vz6ZwOeYy3LjwAOsBucXlwlsO9H+9AxY/l877WkKgd/YRzlG
gfstCduaVALbk2Fvw8HDBfTpyjQCL/Qy9j0BTvRdc7P0KoE/uojOBINbJkV4
+ekE7tg0/1cQePutkwU5GQQ2MB2lHwGbJI3tzLpO4AOnYvUOg90zrYXTMwm4
+g7G+oNPNJ6uvpJF4Epy7qQv2EDsjOelbAIfv/43xkfwvO36+Un/Edjl6Q2d
Q2C187cb428QOD1NlvAGx9WURZ7JIXDy6u0/PME9z0y1o2/CeLK3/zsIvv2f
81BYLoEl/8gpCbxvy5f0Y3kw/9q5Bw6Ag3IbbYLyCbzYf6JxP3hrubBQwC0C
a5ZIbhd4s2vMg0MFBL41PTLuAX51w/DwwdvQ3s5L9wTW8pVZ5l4I6/eSd1Xg
9+VEt0sRgU9Ya1wTWPbg5CXHYgLbjSjXCLwlfMjM4Q6BH2T1/hP48Vc8a1tC
YJq7u53gfZ8yAiutSgmcrVXULDAl8ZfX1jLYr4wHnoL+nixSVdpcTuCLrecX
CcZTPyr91qQCfj9JdUrgDaapccaVBI5amfBTMB87CwqNDe4SOORGGUMwX1Ei
Jr+0qwj8t/O6gWA+1+zanKNZTeCzT60TBPMteq7IXu0egXmmdTzBepxMPSC8
rIbAqEXIWLB+7fRUT8UHsB5ZzXME6ytk+VN2/kPYL7ec/gnWP3GNywvyEYHf
/3quFgp+07lxoTgmMHc0O0gQP46BGQ0iUCFuzl3fJYivp1EtRxlPCLwo/7Xw
KUE8tMS9mHkK85XDbRDEp+LkL5+JZwTurwm4I4hfs4MT0n+fw/hPLXydBK75
dmPntxcErjIpOJ0h2A+bW1o66mE935avE+yfB26nvd42EJgzEiEr2F/Yay/x
upHAxk+dlxaBz8hYqNU1E5ggNcsfgc9n2h2420ZgGf7mfYL96//70s/SN5CP
XRW0BPt7oCsyuOgtgRX8xdRawU4OKuE57wg8qfn5/CBY6hXV5+IHAl8LG9cV
5A/rduG+cx8JLPa8dlqQX65qbrKL6yKwQ29mLx8sWbRQM7KHwH6rVyjIQn66
0PPsqU8/7JcdprutwUUp5yxNvxGYsbn/wk7wgTdhn3Z+h3zUnfNjL/jdEWE/
zx+QD2+nSR0G26pkhcePErglVX9uCvjNfuzR8AfyQ3HNs8/gNaL89dtm4Hyb
Dlw7Cr76+MoZFx6BD9mbfZwE85amPfPjQ77R2XRKAvK/kNuZlecpNOwmdei0
EXirze9HLXQaDrzw2DwDfEBvW7m1GA3rxX5kFoCjJL2S94rT8KqDzIG74Arz
Gl9/CRp+YXJS8jW41r1Y/LwUDfu7CJFCcF753micbGLT8GJp175jYNk5GofM
FWjYo0LmWCicl68P4zVrV9Jw+VG5irNg6VtRCpaaNHzSWFQmA6y0gj3huIqG
w3+XG2Gwz+v9ScdW0/DChV/XCsN5LbUm06JCj4aNo+p518FifTU/VRANn7f4
4zgI5/v550G7hWxoeNJ3jjQPLFmS9ZtlS8OtyX3fpKGecNxnHLFoOw13PG6e
sw48vTkyyHgHDeeOBYylgtFiuTeHd9Fwn4r/ie1Qj2hMEGYfXGn4HHFjUz/U
K3HKG879d5iGQ0bESqbBj0yJ/PRAGp5uPWTAIuF+YHLjbsoRGjaKpNzaBDbe
b3kn/igN40676Vvg/dmXRQ+H0nBOi713CIeF3E5c8FwbTcNK3md81ORYaO2A
0frGCzT8esy13BSc73j5/vOLNGxYyuN4gMvbBpY+ukTDpU98ja+DE4b02oov
0/DyRcxJKajPfmcORSal0fBfndBVs+AHM7qLrbJp2HZe6tWfUN99C7KQwyU0
fN1mvEJSHuZfbGfF3VIa3nmw44cmWGFT8LqiMhreZrH0fgA4Y0XFkqsVNLx6
5Y2nf8FSjCjNwGoadtjiEU+BetNhjrbWIkzDapKxnzSgXr1nmXEisJmGN4XI
6QwI6mGloS89P2i45a+fthTUy2MqGbsHRmh4fHrS3gic4qpb/X2UhpcYpTMu
gd/2v1Sf/CX4/cfC61VYKOmZO0VqnIZrIxtv5C6D/Hf6u5YRn4atrQ3JeKjX
Ff6VmUWK0/FcfrvGPaj/sziHVe5r0LF4DdH7Hby174rJ/ZV0bBYeU6mkxUKW
+v/W3dek4wzNc89jwcltsl9rtOhYRFUpavdqqEfsPg9X69LxdIvMProO5IOE
mPQ7a+lYJVa1KkCfhZ7teqoXY0XHlx72cUvXwf2oY8X2Dz50/PDmUPN3MN/f
3a3Zl44130hSliGod86E2D71o+PPyVX4Ojgx9PubggA6TlX89uScCcTf6hWu
IUF0zO3e/CJgAwuZhhvEioXRsVw9KrPZAufVKso1xQQ6XtUYLe+/DeqfDfvV
e27RMX+9E6scHLbMY/RVAfS/fd2KcfCyNezEu7fpuLNcuvyENdT3sVtczxXR
8XiQu/5ZG7ifF6nuMSil40WbrooVb2ehdUdL0+Or6TjY8ieesxPyMWPVS6kX
dDw0tNNA0RXuP9jG7k4/HYff3/nCHVwuXBcb/ZmO788x9SsAJwvNvbbjCx2n
WXwW1XVjoTadZzunB+jYbmNGuNU+uG8uztTbNEzHlbKO+qc84PfPfwxu/UnH
SQcYg4QXCwWaiBe08ui4LYy/xgLu51d+Sssd4DBwz5fni1PBxlse7Fkly8C/
L+5T/gxGL2TCpsEBrhL+J47AfepYunnSPAZuoeRrFgexUPZ/3KWV8gx8efi1
LRnCQnVbC19NLmbgf54uUxMnWOgr58KR/ZoMrN29oYEZA/eZ53fLX5ky8NCv
plIXsFrSizPXzBi4Qm1ZebXATw+vOLSVgfe1qIp4x7KQ/ao9/aIWDLzHr5b6
Og7yq81nOYtt8PuXqhT/S4D4VHif8HgHA+4rV3p3XoT68fH3xbFuDLy6zE2C
cx3u58YfRyKPM/CbR6GVR8H5IeTRTScYmHB7GNQOto22fSUSxsBXDfM2pmSy
0MyW1I4L4QxsFGg1n5PNQve3vb2QGcXAygMjN+VzWOh557hTaQwDL72oS1lb
wELakTm8oksMrC71Bb26y0KjN9cECt9m4NuLXwQsr4L6aISWWQ7eu2G0KhZ8
ts3nmnMhzB85dXJLNbS/bIZRUcTAIzV282rvwX089UOWUwkDW5Kjhi8esNB8
+pHPOZUMHPF6ZmHHExYKps/bLYUZOCzNR8ewGe57U1GPHd4wcHNqaux1cISs
xbNxcJvbmVGihYVeHFtx+fJbBr4RfmGiHnz14UxWazu8L7dq3LkV+kf94rK1
g4HR1qaM2LcQ/y5GhzW7GThJ1tB7+APMt5LnzfZBBt5v9zpzYAjq8Wil1XFT
DKx7dkGW5VfIN7HvE2WnYf78uksrwJf5ttV54MJHRSInh1norqbPkeczDHyr
oClO6TvUC8vMzvP5DCzJr6p1HoX7N89o2wEaEx8R/yI0NAb7++f1O9KiTKwf
YLJVjcZG3pXJms0LmPiVjF3wFXByfMt9G3kmFnexrCDobKQsWiv9BnzOr3NP
B9hiHnfxewUmrn9y2zeGyUYNBlKvu5SYWPjwxagBETa6ERxu26PMxEq6x9aV
SLKRT+nB+zVqTJxoPlXirwDtB62Meb2GibUDX5Ffwe/WX3lobcTEYfJe51wV
2Wh53eaKZnD6uvFCWyU2OnRkV1+DMRMPuuyo0FnERp6ZO9CzdUzs7FP3kb+E
jV6YT03nbmBi6jrJXRnqbFT6+6COkTkTB49/VxQxZqPUQIsPN3Yx8c2OiKOn
wcrXTn2S3s3Eyk0PP1DXslH0ttEbUWApjmzrFNjM1djD2ZGJ3Rfb+vxAbLTV
+HMLaw8Tl+Tp27/dyEb11ws3Be1l4tNj4RV3LNhowiLNn36AiV/2r61McGIj
G5Ey3d2BTHzhZHofbQ8bceRerC0DV7xqm3cc7L6eLjrnCBP/h8puezqz0fGI
3rFqcKDJPqste9mo/eFFJusoE2ct0btAd2ejv1+0OdwQJl6z4ULHGW82Wluy
6/VQGBOvvObUmR/KRnWJEslxMUxsSI0/teg4Gx2M3fGoFfzR7L5eOtipNK5w
fiwT93TMvZd0go1ozQVvCsEiepeXBofD/Ny1294QB/O16mXulmg2mrssmElJ
YOJDD9KFRuPYiN+tu9TwPBPn9p7I35HGRmJ7azwnrjDx44qPjz6AFddmWeil
MvHO5Owu16vw8z+PB4PAhhLa2r7X2OjqRO7m32CjEd+NMRmCv/84njuYxsSF
eq1DNdlstGXP8eFn15g4w+ATT6WAjXj+e/ebZTKxQvAa8Tvgk1lBphHgaKcX
S3Rvs9HkKpO+CrCE71avjYVsNG/pdyPFLCZ2ujeyxbWYjTqVVRJ/gvdU6lqm
l7FRs8iv9NP/MXHz7Kc1nPtsNKXda3vsJhPnrY1XzATvSalSzgWXl6qLqAj+
fiq1ragVfHCL0YjuQza6i5u/rMhl4prrB/j2XDZyzI38/g78QzRAI/UpG6l0
sW2V85mY/13NR+kZGzkItaVYgE/LbynNBxeuvXnxCFjW08/s3nM2itsfducp
WNkjvLrzBRvN3i8Kc77FxNfOz4lTaGAjuYJ8zzMFTKz5hSOXB25L8FIoALM3
DhatbGSjPwvJ+EbwEHHzC2piI+4GpTMyt2H9suIT9rWwEaOoRjIdvFPF986t
N2z0O/KbT2YhE885Q2cYdMF+zfHW9yuG8R9dxLwHLtWZYMSC7W/umGPQzUYb
OxIuZYFlnn+Yb9DDRu8N60ZawNlGMW4GvWxkGLLnpsYdiI9Bx2DDL2zUcZwr
1Q2+YiGeWwOmMRR6foODp3e8MxyA90/6HBIqYWLT1adN1gxC/hDpql0J/vI9
erXRVzZSbXwTGgYmOFNn1v5go5mTSt2ipbAeXujDIzDtEr1AHhw0fG3VuhE2
St//QkcD3OV6+PO6UTZqMv6SYAVWa3vgavKLjXY98DBIAK9SbXj+GDz/82L6
NfCxSyWq639DvPCqE2+B80+9n1n/h42Qh3v/c7DR4WflG8fYKDQzL34a3PP2
2pLn4CO1dDvhMsgfS4XTNo2zUfFcrS4WWOpExKnN/9hw3kxqqINPHxT2MZ1k
o3vey1t2g2fzcofrwAnHf1/xAK+4neZpNgXr++60oj945cAe763T8P43wr6n
wH3nwsMseGwUftxXuADssrWP3gjGriFNZeCX13afs+Sz0aPHW+zug/M/H8y2
moV4bdXOrAcnN4+oNYPlwm3c28B7dD3vbaOQSOzaqq+d4Po9899aU0mkbW6o
9RXsI7XB/TVYdsp1fBQ8tHTdXxuCRLtszEPHwc1OyeR2GokCnVwfE+VM3OjX
ld8GZlmcOyUMbnjZucaOTqIbjseExMFH9Fr37WCQSC/8vIUs2N74wcRb8Pwf
NeLy4EJfw0R7JokKVuecXwgOfbZR+R34g4hF6xLwQ722GgchEuWqlrUtBx98
3GXzHiyyqz1ZHbx/t9PXncIkIuyr2avAXzMuy+0WIVFtX4W9HnixISrrBF8X
byYNwQterjV3nEOiZetzU4zA2RviPn8AH95h2L4WfOw/TrjTXBIlKp99iwTv
6+7ldIHPJ6Umrwev/NlTukeUREmhbjIbwXEtIhbd4NzGIZtNYM0QhwFnMRL9
PqJqvRnc1YMje8DJe1eIbwFvpKydv1ecRMWnvpwVeH5rbeUnsFeH00uB2Vbb
rV0lSDSy+3ytwIOHPgz3gj1FIk/+3/MqDqfdJEk056sqReDeoEeK/WAakWwk
eF+gjUjNPikSJeyt1hf0p7xspd1n8EdW2t8NYKeLy0fcpUmkuVrXXzCe5V9H
Yr6AX7Ql3RaMt/NO8ML9MiTqk87NFcyHTs/9mgFwneQxV8F8UfzLtx9gkQj/
Ev5oABZxtP8+CGZ37yAF870oLf3UQTaJSGKvpDZYeXH4gq9gVqLKK03w91+/
yz1JErndLdwgWD9vk6O9XhwSWT/+GSRYb1rFkeBv4FylEg1BPChvGxA9JPj3
VGyNvAVghX5C10eOROUD+99JgxWbMl7+ALu5LEoSA/97ftbJdx6JDuVlMAXx
OIpRpN98aH/uW+0ZiN9uFY1HAfIkkqq3SewFfyrzqB0F5+abeQr2g3LAvUYf
BVj/X9FMwX4p2HKlw1ORRN2J92Oegm9k7/ziuhB+38z2ZjZYd+71Lz1g0Rq3
i6lgyRVPP+9ZRCLluGqTJPAbs8SeXYtJFHZSd/A4eLGHXa3NEhLdD0mwtAUL
NTx90AwutHtvsQV81re91HIpibh+vuJGYHnVF1fMVEjUKXfivbJgvw8StibL
SWQxd1XsH8hHFwc2H9NUh/X9c9v+NLhwvYt9Mdji9d/Qo+CKf9mr1DRIlBqU
7HoA7K8X26eyEvbj3Q9BpmDFLLq64ioS8ZxzaoTAleKLnMV0SMQvnKkMhfyb
xt8x7yw4pG4p5SB4MHLNG2FdEpV9qRLdAS6W4CG6HoniK2V8NMBGi2J4U/ok
yvFq3SrI/wZT8jODRhAPZuHHtcCP2H1JHsYkej/n1vf54BSlHqV+8OH7VkoM
ML3Xw7B7LYkqPCSb2+F8ua/YtvUNIlEzK3lrMBhxL3dyN5Lo8e2+msIiyIdz
XdcabyJRRMpBu4vg/U3fr9eA1cWjSoLBqdkq9pWbSfRD1L/EBHy+zyG9wJRE
Mb8Dm1vh/EsqEI9KtoD1qEs4+xXOx+VijkVSliR6607bVg9ekjX6NhEc/0Hl
bSFYybJtfpwViSSKopb7gSlxZcfCrEnkPVP4+yecv+tC1wV72EH+M0oS/grn
9+HLnE1aTiRSKCqwvp0H8eZ7PPQemC3sphMN1glyL0B7oD/vUOtOcNWHzEkr
ZxJR4yK1GeDZbyV23nthPJsdr+2G+mKu2ee//7mT6JKZyti/HCbetH3wqpgP
jN/k0OhMNtQ/daHiyeBXV+R7XoGHG92Oz/Ml0dayPTGp4AVX5pio+JHoqH8q
dTWYFX0nFAVAfLQ5ZbhDfXR8Py0zIIhE9k0OQTXXmThS5pJnUxiJJC+2PdaE
esxzzHlseziJDn7KfjV2lYnvFFsf6wCTfqEJNeCQPxGenyNItFfMcc0GsO8U
Y3gyikRnb1pvtoH6ziY8cN/iMyTy921h7YV6MVtEYtwvkUT7qevLTS9B/UBf
nPjjOol8PpnMbo5nYlWavuzBTBJlSiomzEI9KrPJJ60PTHml97EKHOo/L+pd
Fuz/cPVaFfC3lMLP+D8S2ZjlPqZDPasaMX/8Qi7s35MPdpefhnrLJV1MvRjO
u39VOv2RTPyuu+vQpock6lg9nZ4I9fWIq9iph+A9yc3y+uBz1yLO6zyCePxE
7usNgvi7LR63hAvnV4rMmtXgsjvCE/THML5Sx4VvoJ4fl52qffyMRM5XPtfP
CYD1incf02og0Vd+DNfcm4nbu3Snf3WSSJcX5CbvwsQt3unj/h/gfAr6UXrH
GepjS9Q/ClZau/yhCXiTq8L5Hx9JVBUjJuQB9w1/r9V6Q92wf+IPeubDfSTJ
53FZZx+JgnuO+C3aCfc32QLFimESDZ6zqOm3ZmK3K1vadacg3vYtXpphwsT7
9F90lIK/OG7PVwD/57yhQW0a1m+D11AmYmJmtVj4ohkSZYQH/JcN96mKbb9l
xPgQ34sH+dlw39IsMaL2UDnoydl41xQD2M8Ll+QEiXDQRcUzElarmLhufGzh
IVkOsjQ9oDatCOspV3/0E9ihcEDMD5xjqHTPTo6Dho8Il/XBfVF9/gqm8TwO
KrHYvf4l3CdPiXVi0QUc1F5hdurSfCa+/Ti9NF+Rg8qtpy4v4MB5kRtt2rqU
g2LyUnWp4kyMS3sSh7U5aL3ulgIS7r9tP1vou3U4aOF/lFPH4b787cnm/S/B
Ct9GFn2aZGAPhexvebocNOp4uSR/goG1xvVm9+lzkPZFA1G9cQY+wVPb8H4N
B0Wc8G4y/cXA1OXBwqXrOWhj1e16BPfxPxuO9Sy05qCnrJNKp1sZOMHpbucp
cGdrOG3wNQP7Hz3+ZBC8Mru20hQcX33aociGg6Ib9sbObWFgF+qfFL3tHGSS
3DCQ2MjAal8mPEztYbzrxs4n1MF9vVxrvqMTBxVs4Xbve8TAJoTL1Q0HOegT
Z+fZU7cY2MxGKy4b/Ei0MrEzn4GjHnD2zYJHr3Tu0wQnqBLvazzBxfknP+Qy
8P6ku881vTnokOrhqytzGPhLVcFtWV9Yn/5G9ebrDKyg4xv6PpCD/o6/1f5+
iYHdc6R/kBHw/rnJZFYYA2eFEMNHwYs/LUv5cIKB68vuNrSDG6Li+kiw4xyb
DSmRHIT1B3oTQhnYIC7xr0w0B8VeTjlxNJiB1zONXeec5iC1PyoaKICBC3Us
tfvjOYiSHvClyJ2Bl/YXWG1I4aCr5d71Y1sZ+EP7oth08I9jZ0eUwTar7t0c
A/+6LtO33YyBa+6pnMu7wkFbL6calm5h4Nt9u0XnpHGQah9Z7rmRgVMCUmpf
XuMgVhSv6bUxA4uVl/FXZ3OQoefA/AhNBq7syltadpuD9r1P3GvDZmCp/IFn
fLD2WceqkywGVoo+ZWYu+P9xK6hDlTIMvP3AK8Zn8F7TOe/kpGE8e6bMWMUc
RLMK/dEjzsCLfetn/EogHo/MFfIQZuBd4vHfZCo5yGu30Zbt03Tscjrmh+gj
DvpaWvL2ySc6dh5dNmsLrhqtF/7eQ8cDKszxVLBdC02ODdbKc7ukzOWg9x38
lv1ddLy9eEWCIYb5XpKaJdxJx+FtWoddn3BQ6SGJV5va6PjS5O7fV2s5yKxl
bU7uczp2+GPVeb8J5uf6Nx9GAR2P11V9mAR/XFtTueIWHc/7fPCJXjMHzfPZ
1LMtn451VS6vKwdHFz5/l5ZLx009xRP5LRy0rPSDi9oNOn5sU+GW1MpBu6Pb
3pmn0/HxRc9ntrRzEP3hzJMjiXSs7mNw6kAXjOe6/qGAw3Qs8ijn/nVw/Ufy
bFIAHd8qCXn3Fkz5SCQV+dOxn73lgw3dHDRf1HDzV186HuVbGir0wP6RzAx0
8abjGPpbetMnDrJt47Rvdof5qL34UPYzB6X8rZIl7OmY1SAiuXsY+hPjcEHd
gI5P/FHYmwj+ob8+Z5U+Heuvfp34BBylfuKajh4dN+/gx6z4xkEHC5X1jHXo
uHAh++sE+ChTf4n5Kjp+4Ci6L+kHB73JHvnmupyOddbvkr/xk4Oub9fKOi5H
x6ndP7+7j8P82bxK3DdJwxlzftWdB288yVrvOkHDn7zvRj8ARygs73b+R8MH
Yk8lyfyD8ahMtewao2GxuvdiGPxxXO+G1S8aZho/uio9CfvZau4c7a80nBvT
9yljmoOOP761d+Q9De9fUhJlQZFF4VeiVi+ppuGA9VedfcDU2QizlVU0LE9f
IJ8ILt67aZvBXRqWCupe2wzeYuS6wrKChmsCVdjWVFn0/E600pESGjbTkplr
QciiZclX5bj58HMRvrg6XRZ5ZeF8szQapjYozt8K3nvnzRubVBq+9ihd+AC4
v/3i711XaPj44uyYLHCs5Faa12UafvHhP7Y0QxZ9e25xPO4CDWsUCfmPgufV
Drc+j6PhVTdzpS8JyaJTe37Fa4fS8I4zXzYXgpUC74qsOUbD49lbnZ6Dl5qI
njAJoWHWwagV/8BvJfLWWB2F5yuP2u0SlkVP+zcuO3CYhj1LtLo4IrJoh3bE
sxQvGlbbMVAVNkcW5eURR37spmE/b1nxS+ClSmHRv3dB/2w2bMoHe04HnPm3
k4Y37Q23bwXLGQv7UR1ouO+WB33JXFlEe578jLWdhi/t+JTwDCxbdj3RwJyG
JxhLTL+LyqKukflzTqyh4c6BJDwLXkBOX3AzhPU1XigtIyaLWjctkTAzoGED
71JkANY4W/KVrUfDYZYu9SfBuoenF97RouEvRNVlKXFZVH1AtaxnOQ3HcHoy
F4E977xKfb6Mhq1DOCdXg/+dFT16W4WGq6bL39iBGyhNrOAlNPzgYUjOZXDZ
9+wvYgthfs4qjUlIyKJ1N/YOGsjS8FTIvSQFsJvV2vWKHBp+F7mNpg72fU1e
ppM0vCbUN8gMfPyM+OJmGRp2ntp1OhJ84VNg3z4JGs5UoWwfBDM+/KImMGnY
ivxx4g84sjVlwJ9Bw5+/1EbMgl2ikp7toNNwepSxJEdSFglZtx5SJGh4zgt5
p43gOe8n/ct4gu9n/Lh+BfxxV/nud38JvLsLOWSDg2JLu+//IXCKxpGhAjDZ
4rQn6zeBVzUfvfwQPF9aytzzJ4GrHd/L9YKlLS2Hp74ReNCBnfYV/FZNanPP
MIEvHFH79Uvw/lmNjKdfCWwWM6BKSMmi/SNNxgmDBF5OPVavBBbX5W2V7yew
wocgqWXgqv4fJ6l9BJaQMdVcCe4J/FL95ROBdxzxmjACP7q3jlPcTeCKmNQy
e7CFMz9vbSeBe1+s4jqB3bNOPl3UQeA4t/QcN7Bv3YMPzPcEXtPdP+kj+B6F
TTbR/JbA8hzNpmhwAvWCmstrAi9aa5odA2ZpyGhuaCGwxnENywSB7cY1VZoJ
3N+4b+VlsO08XdXRBgJv1C3zSAP/pj5SbqsnsOLuxiMZ4MYA3vyqVzD+qwfl
b4J/hU7SIuoIXLtw6G4+mLqn96/bCwKXGqxeXgh+v/Nd/+ZaAj+WUk0tA7NX
bXwg/ozAXnbvkivBgQ4DN38/IXCLmpWX4Hshkao/zrU/JvC9Z1czBd8ToR2O
2HWdS+CbCv6zgu+NHFypaxz9CMazQUL/CdhFM19x/0MCdzFDzJ6BM+d9o2x9
QOAIk4LVgu+ZzFxi9arfJ3BJ483xF2DH9YZYqobA0nFeFwXfQ7lbH3B9rJrA
W+wmmILvpcxvbzneUUXgb9Lb7ATfU7kp5LPz4V0Cp932DRV8byWa6aSdXQnx
IORwTPA9lqGQconTFTAelrCN4Hst8oy44YPlBC7HUVTB9138bX4/sygjsNXs
03iB9eiMTM1SAtc9b/oucNPT9hBWCYHzRf9TEXw/5qpumO1EMYH///dl/gdL
KHRW
        "]]},
      Annotation[#, "Charting`Private`Tag$1995769#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0.85], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJxd3Hk8VO/3AHBlmJk7M3cWS0mWEJWK9kXqaEPZkjakUMpWtvogCtkSEcqS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        "]]},
      Annotation[#, "Charting`Private`Tag$1995799#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0.85], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJwU3Hc8lV8YAPA73WvfSoUWhZAiI4qcN4SinxIiM4UyQ0NCViorZWaFhLKT
Mso9ISkRkVTX3jPbvcb1O/3l8/289z3vec55znj+IWrrZmhHwOFwDiQc7t/f
zNXTn2m5ZCzkeLrXVW0qLAzPDvznDA2OEAUtKtx5LLeAHzlrW2T04jEqbJew
OMWH7J1nnl4OqND0bIUVD/Ja86NCn6NUWD7wsY8Tmc/ubBVQpcI8/J1fHMh+
WjWNhMNU6PNrUIOIvEWP1PXxEBVyZy7vXH9JxqKNDv+9r4jaT3/vsoycpnYX
ry9PhfPbZGUXkP90cW3ml6NCgUsGF/8if90yKfV9P2qvbSfXKPIw/T8sdh8V
8jWn7OlDvl9qaGoqRYVa1V8LfyPPfd/msW0vFQZfVBP5gvx85n5u+m4q9BXw
I31A7snxaLgkQoVrdHfzt8if5vIm9+6kQuIV9wsZyKTC1MMFQlR4LN+PFo98
oC3povtWKrxxC5MPQ85avBaluJkKa2MHGt2RTyVpz1XQqPC8e73OJeTx5mAp
Pz4q7Bu/qGiCXOwoffEYDxWeVfhop4JsKavc+4lChT/26EktviBj+4sleH6w
KXDqO/nwALLHe7cLCasUeH/8TmULsvDMoUrzZQr82vtGMBfZZF+DT98CBf6+
c0bxHHL0pd+q0xMUyMGQ/I0h90sMlJWMUaDW48+zUshnqgNVb45QoE+Os89y
DurvT05Ddj8FlqXYzsQgC73gq+f5Q4G7i/L3eyPz2Edeb+6gQB6FJoYV8s6E
cqmYdgqsU4mLlkDWykjJ2vadAotGPS4WZpMxY3GnRenPFNilhovMyiJjT/c8
4tF7S4FfIn2YgcizkUJK/KUU2Dc18cMKGTP2tm99RYE38l+NCiC3CZ8eMC+g
wMRvG657Pydj84HCp12eU2CblMqOfZlkbDo7geNxNAVuWeAvYz8jY5s057+a
PKJAMp5Y14KsE2uUuu0hBea0Hle9gfzHusD2eSiKf0NEWFkGGRtxib5eHkCB
kddLPu5OJ2Pygvf7+t0ocFA2MXoyjYy5frl55YULBbb/bWh7i6w0EL/m6kSB
91J2FJ9E7tg1f2rZngLPn//ZcuUpGQvXHHm8wYoC1ej5byJSyFjpT8GvGvoU
mGY0u9f5CRnzWVGZKpKkQMkTss67kDEhiXBdCQqUDkzi/p5Axi5JFaj37EHv
/91qoYQs6QD6+HdRYMV9da35ODImPqMseXUzBW5bOnfobAwZG1qitisSKJDr
xrevsZFk7FnPpslvfzgg1fNRoCKy8eNnno6/OGDrw5Mx3yPImNS5UwLknxzQ
QrmqgQc55UFq5pHvHLBN0SPsVhgZi1MgcmTXc0CxjU5GivfJmJuxzGxwKQeU
VmQekw1A6/3UyQyThxxQ3nvj3XJ/lM+7Z+B8OAd0ei4sroksWSq1/jiUA04+
3uJjdIeM/XeD/fvbXQ54IjcvxM2XjFm8XRbQ8+GAcOPS5nu3yBhjybRM5woH
PBT4yELNnYxFfCBNntfkgN8DzuZ9sEL97/e/P7tEhjZShMX9yAEFzPwPC2Qo
mJJb8sSSjJlVXmRGzZFh3timMDcLMvbQ6emq7F8yNN0IcgXOk7Eaqzt1bkNk
mNakWa5ljPqf7uS32EaG597NGKjpkbH3wvUeoq/I0J4j91mYEuq//gRxwZkM
145aHvmhSMZ+HJy+2eRIhl8kUnV2ItNwj4RyLpMh92vWxwJ5MsYZLT9kfokM
xxXNzn6WRftVcmnOR3MyjHraWzEgRcZ2bXw1nX6SDIOqttBKd6D4/6Td9pMk
QxGH8ZAqIhmzuXd0ommABMs6gmzGCGg8yW4X6H0kePLxetlm5POLqVxFPSQY
3dk65IgjY04PvViPGCQYeM9EmX+NhDVmhuibtpHgcYFNb8EiCavYktk/VUOC
CV+uRWAjJOzyxGix1jMStPhi+bD2CwnT+EHMfGJLgrsfkMKaP5Mw+uUk/gQb
EjT1W6Yy6knYA/bamzgrEswr4AufqSNh11WelsecJ8EH6teKttQgny54FG1I
gpJ39t85UUnChu+2ZydrkOAIKy/lTC4J69I+qdG5mwQV4dyxvw9IWNll3dad
A0TYbZKzUHufhBkmFi4Q+ohwKItHOPEeCTvkYu0w3E2ETp9USjXukrCYnQcP
F/8hQp1IN+UIfxJ2LKw2UbeVCCsurPpSbpKwtf6fN0KqiXBTTMPLRxdJ2JdH
w4kgnQgFFEst8aokTHCz6odCayIk6mWPlhwmYQFXKzpzLIlw/j/GuJ0KCTt/
46dhhjkRJp53OVuvRML2V/roxJ0jwr0nPhSHyJEwqrWHVaABEeaEsOmj4iQs
nzZs6wSI8Hu0SsMJGuqvcFRNwC4inJQyXr/RT8TU4i5XfuohwC+fF6xF+ohY
XmDwPlYXAZ6/uX7qcw8R24aPn5buJECTExnfhbqImIDqBu+Hvwjwtsd1/9IO
InZF7lqExXcCbJUc8v/ZSMRu6hU2cdQS4ElOQm7dWyImkfT+TnI2Adb/Z+5k
EkrE3O4WFn13I8Dks3HN/feJmL7SkyPCrgT43Ly0/uo9Iha87iBi60yAounL
7g+CiZjMsghu7jIBfn4pmlvqR8TiJ+c2CtkSIOfQfAPLg4itGWel3DAiwPsD
z68cNCdiiwbGBK/DyGzXIxelidg9mYSmJyQC7CrFGl5LEjGrtXWtdgIBnorr
7CPvJWLdERtkN+EJUH3/QlbWHiLWzvnaKnIND9W2kkL6thMxWcsg2dBFPKwL
wlVq8hOxD/bxJfEjeChYfKgzb46ABWOHJbgb8dCjO58kWknANJzdU8/H46FK
QaCGcTkBM1sTXn4di4dDQvv4H7wlYM0mp1r4Y/CwKPa28d8SArb65+NsXRQe
toZUPXmTR8AEwkzIqqF4yHeAsFMulYBxs8yDjvji4bp7O67Zn4CxhU++jr+I
h7MXXDK/aBGwojR7k5aDeGhw3SB4QoOAKUs8TzCUw8PB5HPrvMcIGLMVb9Z2
AA8nMetPBkcJmPT4HaNf+/BQl3cmo0mJgEXOXDs8Ko6HUoLWz8slCNiOWqPv
IsIo3uffq49TCZjk1oLFvwQ8nFr91nL0Cx6T8HiQsakdB//0RdzVqcdjX3xn
lEvbcHA4jsk4XYfH4va3nznXioN2yjY3bavxmPb7G5tSmnHwhq2+VUAFHht3
r2w+0ICDG8JObSp4icc6Apx0nSAOEiqHabWheGzv6WOturk46Kx1VWLsBPre
bK9rUiAOKo5+2obXxWO52Td3XQvAQdZCeP1WbTx2+aql7il/HNQs/qGrpYHH
SGE2RLwfDgbdfzr85AgeU791SMT1Fg4OfdtQprwPfW80lmR9FQcjylSvq/Og
9jl1Z5OscPCrzs95v0Yc1jHnLByihoMFjqbFwQ047O1Mk72vKg5uetkkE/oZ
h+Gd38leP4Ke0zZfiPmIw7a/u6Vsr4KDcaaXqp+/x2HCV1VF/lPEQRGv6cB3
+ThsJKzwkpIMDuLOZrVWROAwuOQmYbsdB6sThO/gT+GwM7kL5W6r63SWp8RY
w0kc5i8Uo3FjeZ0+dbl7Q5wuDlPcN8P0Za7Tf6ax4qW0cJhx8o2/UfPr9HFT
5aBTqjjsblks5ePEOr1jZi/rvhQO+262hWjfuU5XKTH0+0bGYZwvMeFw+jrd
OiyuSOf2OshpoGy7em+dHhy8aPH+xjoQ3cAhUnN3na5buzVe3mMdPO3kN98a
vE5/9nekdNuVdSD7gu5Z479O/5PemjVisg5u3u2Sl/Zep2tsM0x1kV8HNTla
BHmXdfqAY6OUxCgbBMUGvtpntE7/3HBl+aIxGxiZat9oFF+nm/F8ecp3hg3S
hqxFQ8TW6cC/ca5Mnw0Ust/0gD3r9KF9LTk8WmzAG+2c/EZknX6o2fC/Ink2
UBeV4Sretk538H1QM8LPBiJyhs2/NqzTJ8oFjoh8WQPahOuRK2w2PeiE/+EP
H9eA4dGtw+1rbHpyysHpCx/WwJUwC5OSVTZ9Yuft4IyyNZCfKHjLbRntjWeO
nRbJXgNOZ/Vb5hfY9Dwzh2K+YPR+51aGwiSbnvLwYkDZ0TVw56Z1axCDTQ//
cmL69OE1kHtAaHfgHzZd7qL0rlHFNeBfG/cg4DebLmYy+15QZg0cFt7xLKiD
TZ+r0KRcF14DTwP4CbFtbPqFNRmO3UurILJY2HfiK5v+Naj/qUHRKkiXedXs
WsWmA6vW2J7cVVBywME46j2bLswfaOSevQq+qlfOv3rHpstcU9r/OHUVxJvf
DFqpYNPrQrPPtoSvgheelX1P3qLnbZavjl9ZBYfnBV9zF7PpqXX9mdTdq+D4
0aqVmkw2/VALoejFjlWQr9qXwINskuofeVJoFQTW7tUxecamP5d7VhdGWwU7
fmr8nEhn0z8mfZPmWV8BYPtgncRTNn2jotQaibECahLIk41P2HQbd2/LZz9X
gPqyUvpe5BkLk9hjrSvgJfcBh8AENr0qqjzc9wt6PyJZUjWeTS/e75s+V7YC
TDICA8tj2PRni34pHbEr4NbRisTRh2z6qdDW2GuPVoCHQLebEfKsSO8VWsQK
yHC/cA5GsulPjyhk6QSvgGBmumVSBJu+0sRx87XHCmg+TNa1CmPTH33hf33P
YAWoTLxJ2nqPTVfJVHDfwrkC5Dr8bpjeYdOvCD+yLSCh/l+RzR70Y9MZXlwq
2rgV8GKHyrgnsuRHy6jrS8tg66JzfrQvm0780bP2fXAZXN+yc1vPbTbdv0mW
8qB6GUQ/U0rP82LTnVSbzXZVLYMjQe5cesia6TCmtHwZCKs53hu7yaaPPEyt
7S1aBo8kX7yTQa78lrvp8NNlENvJEqi6zqb/HF980X97GQwbJwQIeKJ805JI
97q5DJQ+yUrVerDpyrQ/wbyeyyDcvGPgGvKzB30blR2XgTV0S/jlzqbXUutP
PzBdBh+zlGcKr7LpZ+cCSnYYLYNn3zoOX0beFMAgvTJYBn83F8aJIj+TD7j2
W3sZ2NO5I+Ld2PSMzpFIaaVl4Ku/5Bzlyqavfqa4Vsmh/iWWnDuDvPtr31FD
mWXg2F9rsgmZ0Pm76NaeZSC/beFRogub3jGtMP5pwzLIDfy7WurMptdoxZwz
510Gp2+9Db2DrGX+9c0UdRl4Sk/LnEReLW35bzMOvX8RFvQ5sel/Yx9PXJhi
AWvxgzkiyLkMenbMKAtYhtTh/zqieFRnjT8NsIDJo+G0KuQD2+nhMn9YIFPk
d+EF5Bt8HFus21kgWerVLiXkOubL6EctLNA6uPsHJ/LXVAeXxU8sIBTym/b2
Cpu+s2XfF8kaFtilsjf+IXLmSNZ28yoWMDgsePEKctI74Uz6axYY/TzTIIIs
1uqgfT+dBdgP6ntTL6P2SIbnK5JZQLXSNzYAWXjrc/uJeBY4sm8s0g7Zfajr
yulIFjgVMW14EHm3lMeFwAcssF8qcocQcsW5T4avg1nA7tzYfgJy732amOBt
FthXM7Crw4FNTxAoJp28wQLVc3fxH5FvpTr33HZngdrkcckS5DWnJ2/znVkg
jr0lLgN5tjoitNuBBT5pcJ6IRnYffWq24SIL8PnUHLuL3CEuIa5pxQLHs7T9
vZA/Vt2YvGbGAlezokkuyBtXhl9lGbFAxcncJlvketHm6x0GLOB5MrLLDHm3
991DXHossEn7qKIhsr+e1YKqNgsc/lT2TQ/5YmfRK5djLJCL4Yu1kR1vtro+
VWOBs3xbOzSQtS9sl25RZgGd68taGHJFX+8AQYEFqp7lLqkjP9T0fqp4AM1P
sfT0P8c1qJ63l2KBrpSbB/79PrHaZ3OCGOrf2cev/rVneTW65fMuFgh67u3z
73uPt7dHrgizgLyBXPi//nTwJZ3avwXN38Kr3jPIJZEqfNYbWGB6L8H3XzxB
/aSWKB4WKLXYYfUv3hAjk7hqCgt8myfedUb+JBlkNU9ggeXDpTM3/8Wf3Ssl
wWYCQWu5zGBklS31zHMsJlDwv5b8+F+878IbHswzgV+G/+905B/ddzMq/zLB
6ddnrV4hn6zj9JscYwLJiIm9tcgLM1xaZ3qZIP+OY/g48vYPirJBDCbY0a6/
F4/yQcJBQ6T0JxMIu/ylCCJb6dhuFmpigtnfroknkOWoosJ6n5mgUVlX/xLy
rvztEr61TKDY+1vTH3l/7h7j3gomsJYWI737l18hf7w2vWGCS0/av/75l796
Us+PFzPBjbnDf1aRcVHdgi+zmYDAw/VZA+U7d8S8DSMDud89xwG53pX5ii+V
Cba3+zdGIFu3id/wjGECV+0HI53Il5tXhp8/RO2J+3ZR0HrzThey6whlAtUB
HmEF5Psv7wYeDWACh89zFyKQNfwjzlJdmSC7IFjxDFrvLWdoUqpXmOBj9prJ
XeSY4nAe10tM8Iu+VFWBnDn0hd16ngneHrGxlkL7x9itL0/SdJhgvDO6dzPa
f1rUjy6oiaL2eT4N70P72Sufqu9XtzPBu2grm2vIXbNJNZlbmUAgUW5nFfIG
Sm0PDx8T/GfpdsUY7YeiLIWNXctL4NDZD0ej0X5q5T2cHNy2BC60l3XoXUP5
vvV+R/m3JRDywywjB9lVdUjm75cl8HvgZxEH2r+j5RVEz39YApkVp5PrkG0O
eR07WLAEDBdu5Bmj/Z6uPp47cG8JpAeY5hZ5o/bfeMe4BC0BYc9TYsLoPBET
OBq/6LcEmIKlb4ORp1+4T1BvLAH25er9lj5seitLtfPApSWgmyVssg2dT/k+
lpv9sSVQaV/66GsAm34stOkDl9oSaCU8K9AJZNPdTJvCY5WXgLpI9GANctVU
1J3cA0vA6KZFOj2ITc9Jh90d25eA2mqFQe1dNr0hr+zTYdYiKNny0p8QyqY3
n630rZtfBDNr3EceIh8ryzI5O70IrFameHag87Vt+pSHy/Ai4ArevK4azqab
7btl+uzHItAXmtp0D53PXa2bdmx5tQiOmncvnYlG+8vDyy5CTovA2abRriIF
7e8twpRc+0WgIql+1DGVTffYffGrmu0iMMxhyWxD94unM19+25ih7z0QN/ZP
Y9N/1T7gy9VZBOqCOz+dQ/eT9wcM+HTFFoFPfO1e1Rfo/rJYYZjVuQDePV96
0FrKputdFSESzyyAgw0PuHS/o/O8vNJHU38B2BTuB4atbHq7avPRYJ0FkCZq
UW6J7mNyOR/iOdQXwNN2bj+vdjZ9mfe/13z7FsBRz3jt9+g+52mqypAhL4BL
7sI1Qf1sep9Llc6z8nnQf6vnN3ER7V8bOMwmX8+DI2YDTw4tsemmVzPeKRfN
g4pH3UmOTDb9oJGCT2PWPNgYffFyO7pvHhCWHlqNngd2lw+Kvl9n013Wlouc
XOeB5YoAu44T3W9v2/iG7ZkHJeTaDw071+mZZVb+PTvnAalkd4kEug+ff3y9
R0l4Hgz+vD8QKLpO1x7RLO+lzYNDdykUgO7T3diH9qPsOcB3lle3TmqdrnhZ
iIf6aw6wcoee0ZTW6Xw5OaVDkXNA+Y0fd4z+On3jxpr47pVZcO30XIzBnXX6
5IWt3ReXZsEKp8XwDLrv13JGx4zMzoJOvkCH2EBUX7w4qjc3Ogu+dj+a7kb1
QvIt7mnejlkQYvhwd1D4Or3N+YuF6etZsP5ZfgKfuE6/+ezYuKbLLBgfvKjZ
U7pOzzJrJN3rmQEclD97hWbW6f4GKcekGDPAIWZ1iTyH4sNL477+nAFZYszJ
OVTf3H9UQNz0bQaYJc2fbEX1j/mhHzLZ72cArj6tzwCHgxIWeL2RxBkQp+nW
pEzFQQeCSvM34xkgFdEwfU0QB4VlJV9qNU4DXKiRXRqq1yyvJGYbfp4Gkl0c
E9monpNkOUpc+DgNlnY+mCpE9d6rEaEXd95Pgy7Ge/sP6ji4vHb6c3X+NCgY
lNo9poGDXlNCLy9EToNNebi3hnqonj0vHk08PQ0WHeuH7ljgYBL38MEvL/6C
y9efvNVG9ej2nYsR0hl/AfwTXuSM6tXBiylc4Yl/wRz/TtFoVM8ezHvgYBj2
F0RxtF7uDcbB80Yv3k04/wXsxNiooAc46FGlf8RU7i/IOfnrYNdjHMw+XF3M
WzYFIv5Wq008x0HfC1oN3A2ToHhc+LJDIw4ewi0pCdUghzgK1jXhYPNeni2S
lZNA9NOSgTiqv1P1U1RO5k6C+AYHo8HvONjxnn9rWtgkePG9v9CpA9WrrsFv
HutPgvMbLJIe9eMgmZJ5Kf7bBBAaZTw+toyDumav9Y7+HgeE8RozGSk8FBEP
ccz7Pg6a1pr486Tx8PrWX6I7GsbBR8t4bRkZPNzPFLcgvhsHARpzSgdk8bCI
/z++/pRxYGTAEFRRwsNsfe6evxfGQbzS7Z8Xj+Hh7EjrhMb4GNj18PQN4fPo
fbH8oXHCGPgRKU9jh+NhZsZeebA6CpL3KboFROLhJ84gdvTCKOguPqRCjsLD
O+cDtmmMjIInv7sofNF4OKkv6FHUOAqWGrcniT3BwyRnzckfCaNA3lXTx+45
6n/3sTltuVGAS35wR6kKD2tzCnN/XhwBhk9c93LO4GFuUZZFpOUIeChgoZ01
i4f2j3lztM+NAFXHnZ815/Hww+63/O9OjgDX/ErWnSU8/JN9Yn/FwRFw/GYE
aW0NDztsEpeIuBFgukf0JSc3ARYc2XG9OWUYKHZe8HcWJ8CIAHsR264h4J1i
kWZoToBWRhdaSB1DQEb35U0ZSwLER1zzf9EyBO4+v/WOw5oAhwQqfzNrh8B5
SYHId7YEqJCXFl6YOwT+s7t+ar8jAe4v3qzve2sIHEl+u3PPLQJUkwCXUrYM
gayGrYLW8QTo8z3jO/XcIDAznimh/SBAtDoeHTgzCHou3Ogg/STAB9o6jiZ6
g2BiJPcCq4MA+ct3ueSBQUD2jU/vZxDgD5fxD+6Sg0Cmxqv13QABKuM6ybbL
A8BXNbw7YJ4A3z+M6vrzdAAE7ahOMBYgQg2xE+F6M/3g9PSLG9uMiXB0Ibtr
00Q/iBy7IbTzHBFaS/af7hrqBwXttgKiZkRITrWNu8XoBxVNlI2SlkS4A/+i
8POnfiAyFSd5xI4IheymnZpT+8FtR9VnrteJUHvK6773f/0g8MFE89Y4Itwy
4V9p9LoPuK4ReC92EGE0ReRzdmEfKNBgJHj/JsKAlnyetZd9oK3upedjBhFy
ZPQdKkjvAxnEx5treojQcKxWZN/DPhBn684hOUqEv1vuPX7o2AcuO2bcxi0T
YU9/lQR5Tx+wUZfMG9tGgtKtrkavE3tB9RPDn0k2JEjoNh/tjOsFXuJxdWm2
JBg+0nmbM7oXPIo+Nfv8EgluHI1MtA/rBX2+ieyiyyT4+96ujyo+vUDyodrw
56skWPbemXDUqheo/dncyRFAguzMvld1e3rB9RSCX146Cb4mkA+Mv+4BAqO3
0572k+AhTHA0trgHJAaplLwaJMH2d7mFGgU94Cn3teWPwyQoRtltk5HdA9K6
hsQnx0nw8vzYWe/EHoCVKUwenSfBZVO/knD/HnBXTFR0lESGcu1pRWr/9QAf
H2tVOwkyLPqWYJjT3Q0E3igITl4hw1XlEJOIX91ga8ZjriPOZDhip3/8Zms3
2HWD9+A9VzIUublr0OxTNxjNKhDa7UmGpsFzh88XdgPJDWTj8z5kePVlbbyO
fzcYVxI3aIskw/sVW3k7xLsBWHkoNVlChrUvytTMRbrBx8SiU9gbMpR8euVS
v3A3wLdkpkWXkSGpPTSFQOsGgfxW34+8J8MyyfQPPstdQNnHxSasjgyNXuVI
2DR3Ae+IarzSLzKU+fJtbfBOF/hKKD7wgk2GMUeEx6i3u8BpVulvPJ4D+ndj
v+VudAH6T5Wi80QOmHwx+NND5y50vvD85KFyQGbU7e4HZl1gj4Iav+cGDlhk
/Pa0m2IXePREnKQjxgFf/54NwE91grCwme/cJzkgpuB91OhqJ5B8v+PxeiwH
JIl8fbLk3An2TKy2qyRwQJ7zgvZPr3QCMfunhzwSOeDE7WsGq7adgBqednww
lQNedlxzHDfuBHVeJalfsznguxu3ZlPVOoHf6c0708o5YNtUc4oFbye4Ha5h
ZtaJ3vfXNI/k6gS0/V+LY7s5YHD8t8haSid4kZ4j8r2XA+bkDJqqEzrB1tgG
TG+IA26XafV1WGIAP9W2EPW/HNBrXlAuqo8BTL9DLik8BTJVew3V3jGAZtNx
Jo84BV67Li22Vs4ABxc2tOvtpcBpEHW1+i0DKI9XfAyVosAiDXD7fAkDRCoI
/KYeQL/3XTGHL1F7AcvfycoUqOUWcvliIgPsm9EaIpxAbkhbcUpggOrWrS0a
ehS4qjPFfSuOAQLrQhsCT1FgQmBqZtpjBtB98GGKYEiB+h7Z5eJhDNBFuTdG
NKdA0iGecIovAzxhb0ygulDg5SJdnOltBrBXFHI+4UaBplb35vJuMUBidcCp
UHcKjDp9/dylGwyQaz6mzHMD9bdudCvnVQYY85bJpt2hwPr8lSjpSwxgnsfZ
vO0RBdbGyeNrbBlAVe/CFctoCvSSmZuxvsAAyaUM3qexFNiByoZsKwaYkC28
uTuRAgf2BEk4mzGAtmPbF6lnFJhnpE1sMmCA72dyDY6UovjurO96/R8DGGFX
Zd3fUiDke/Yo9RQDqPV+2JpTjuK7Pu7pr8cA+c+D8FuqUP8qjx3y0mGAm7xf
lWbr0Hzspa36azOAhMMxE6nPFDjipb018jgD3D6q6GfTQIG0FLH/SjUZwOod
10DTNwqUVN1PV8YYoP/qR2JeBwWKjVYfvAgYoFbE3aL/N+q/w/7lx+oM0Lcc
WincSYFfbV6Fr6sxwKJPQPiDXgpM86sv5znCAJuaaq47jFGgDzRknD/MALQR
aXbqBAU6S/IZ56swgNaH6bD2KQpUyTl2wlqZAWwXaG+Pz1HgpUf5R5cUGaBF
dlJHbJUCk9ltGy8jH9wQs2TOpkBFg1vqnQoMoCIfmhuNo8LXYWZP2uQZQNGV
sYtIpkK1k8/rTZB5sua7j1Co0OZRxH+dBxngzLm2Zx6cVKgffNpqSY4BLC1t
D/XxUqH/X5WRUORDjV9JwjQq3G77q343cvbEjfYzG6lwAm8eaS2L8tmVEPRh
CxVq/dHxJCHPjz61ZAlS4WkBUmH+AQY4qbtw5OA29P0969K8yNu7wFraLiqc
f6TjVLOfAZr2z/R2iFIh6bEHwQ85Oep7PU2MCttOBE+rIeturC7WlaBCoxR/
JRyyV1VKsr8kFfIccGr5JMMAr9I0H5RJU6GguU5tNPKl2kc3p2WoUOaYIN8l
5B5FewdJWSoMr+gpUEG2XUs1tTlIhTTrZ1kbkPmlhPUSFKhQJNh2YWofA6xU
l6o3K1FhrZpIUjPy3nYDBaoKFd4364p/g3zXpU4SO0KFUZdTx9OQl6OXdnqp
UWFy6YW4h8gXjD5sLlKnwukTUgmByOHleN4RjAqvTixM30LWaIojiWii/ojW
p11HPpFitXruOBr/fWnZ/3zpoPL8Qx0qxDj9yN7IZ2LZ459OUGGM14WKf+21
tj7uX9dD8c+fqPv3vaKllt/K/6H5KDkklf7P3IktbqepUKxAov9ff58Lf/6U
bYjmL05w/l88V2SPvu82Qr9ncFn8Re4zaiveeg7FX7wivBGNBz7O+bmBGZof
9ojcYeTPa/3x98zR86vNKf/G81S84AO6JZov58ILMcglLiNeS9ZUGLw1yKce
WTn8oIOsLRWO1K68OYrmi92Urf7UHuVT7ZP2f/OrxPVo78/LqH9uO0/VIt+s
dOLjd6JC56Ev6hYoP04Vuvzwc6PCyymj5QXI3znPlL5xR/PZxggjo/zS5kp9
POVJhYqV+xQhsv+BSS0rL9S+hg+XGMpPD6dcoThvKsxbClUORy721xtv9EH5
R/8cewXlu+vlF8FHA6jQgsxna4rWy7Ms8fDtoWi++aInu5Bv71TTMgqnwqID
Kd+u/FtvDDFmWCRaTyq74sOVGODG5UHDlcdU6JXaK8+B1qu0k3PzryQqTDBO
cC9EflNrdXFDKhoPj1AOS7S+J/s2zeimUSFz65L8R7T+N75SX32bSYUDYvSY
z0cZ4EVkT2NsPlo/U7uCY9H+0cGWV2gsRPnSduGzHdpfJj6qPCa9osL6QRPj
TcdQPDntap5vqLBj5xP3DC0G0OfIwk7TUf//UyuM0meAa/lDA9QWKlTJ8DUr
R/uhp9HJabdWFP/Y0PZhtF+e2F490/6DCiEPY+rMGQbwXsDaM3+j/Lo5/O6S
CQOo60ARbAB97y7PpB/an68Wj8deW0LtYbRdLLR/+5BPTv1mUWGO1PvLXmh/
N3WjHjm2ita7fpZGiAPKz1TmS148J5QTyOPtdkH5YDox+ZyLE24f5xoORudJ
Qf7Z7607kB8phpxG542Gg4f+YRFOGD4ooyp6hwGo/OpvU3dzQpoHx1BLIMqf
QFmrK3s5ofPKK9WroQwgVFg9sSbHCdU8r9WnofOv68r40B4tTqhSOmbTXIXi
y48StXVEz3kzPNU/oPNvttryozMnvO9iE19cwwDWmuCupBsnfO1wbEN2Pdqf
yI6xU56ckHHw5eem7wyQeqKt9JYvJ6w3TRLbMPJvvdq2hEVxwoQ5FxmbLZ2A
uG9OO/UN6v+eNOJVoU4Al+WfsMs4oUB+5mDw9k7w7pN1i1Ul6o+T9uf3u9H9
RfrH7E7ICVf/1lCdZTvBWYWAhZTPqH1DlUMVJzrBtfvX2+IYyDKszG2BnSDi
7HSjB4ELytEP7oq42wk6fg6JZ5O4YFveyCLhQSfIDblr+4eDC84rMN+vPOwE
3oIHH2hyc0GbAymZoqmdQMP81v2NAlwwU1PwmXplJ3C4HieXK84F9c2SvlUy
O4H/8zSlOl0uWO+tHVa22gm0hmD34kkuiLu/O6Uc1wVijI447j3FBae73avr
qV0gzqRw1/0zXDBv1Zdnm1AXyMnqoeqeR9/LnbZ7eAQ9z7N488GJCxpF3rYs
9e8CneUckUmRXDD5ubON2t0uMH5vCFcfxQXTdh0s/vQA3R91OwzmH3PBjtYt
quOPu0CpzpUA/XguqJbuNWL3vAuU6d6TXXmK+lfSekWqoQvYEcefnCnmgq8T
qCtDQt1gn/a98t5WLnh1k8H2fbXdwMg89f09QW44T5Z0V/3SDeK2Gc3/FOaG
cnXd7043d4OsY4OLe3dwQ5E5aeVQRjfgMPhr9UmUG6r8bH+pstANvA4ulxL3
ccOXCzqxHzb1AInC0vMeR7khvJOQN6jTA+QfDxhL2HLD85/c/4S87QGbTlz5
1f2SG4Y+dOOWqewBgW+HykXzuaGH8bXs1qoeEDDw1vxiITcc0ru7W7quB8Qd
KOwbLOGG9moWO+bbesBPN3vW8Dtu6N3OMbYy2wOmeQrEe5q44f1Sr6UOuV4w
+lrX9OksN2x7oLCpvKQXmL54In36MA/EOKKO9r/tBSWfC7tuqPLAyNerufzv
ekG0mp9+ylEeWLbeedatthfct841Gj3GAz3mEj+d+NELuGOEN/md5IFVpQZr
jku9gFW8KpFozgO7wEqYxdE+oPHeOD3Jlwfu40zjGP/WB/wFTZ9XQh7Iqz7d
+qytD6gJrKd8q+aBrHMPW6x+9YHMmGXt/loeGEd2tPjT1wdEnpq/4PzMA12M
zmVPLfSBLZ5VuYYtPDBkpfqT7/Z+kLq3K+RHLw8s1vLtUHXqBxzO9nEpBF54
N798ZA//ANBquC8jq8kLh3b+8eIWGEDtGVRxH+eFdtOSnfOCA+i8HyOMaPPC
XoqwaOPuAbBrVDrz6UleiJNiR0QfGgC0Q4Wa3Ia88OvX72U3rQbA7rPlna02
vHD49QalpMIBUHra7I2UHy+sTq28cxTV5+86aht73/LCvOSwkniLQeDYrKP0
spwXWj8pyZ67MAhOKsTqelTyQmE1+K3IeRD4i4l64Om8cBvzzWYscBAoKa82
bqvjhbXWgnKv8gfB6+WaKKyNFypUCJ/pIw+BkzHfgk5M80J/Oyt/68ohUJZf
fOTsXj4o9pdXOfPDEGhqvOwiLcUHE6+/7B/7NASUjPYr4ffxwdvSfdv92oZA
5IxpUP4BPuih/YXwbnIIuGbHbMEf4oMv/FjKsSLD4Piv+yvRWnzoPuy9veLe
MJDYb9DhcIEPKti04V6bj4B3Cyeq4BM+qLndMtHDdgT4x++S90nig6MCR3kU
rqDnxoPyyil8sIWx9Wb5jRFQfrnmd24aH+w5/9Gc8Qg99zaHD7P5YMKxpflb
9SNgQ0vGp2OlfHBXUuY6TXkUME/5TJ5q5oOT1zS/PxYaAy+ENEfXSfxQ4QNz
7wmRMeAckSAeyMEPteVK1nB7xwA1k3uJSOWH0t0Re68rjoG9+uOmHNz8EL9P
/oqbwRiQXlnYzLGBHyYZZWnn3h0Dm1W8bWa288P38hNeR+fGwPbG7Mc3FPlh
WMedgZLv4+DHEYrlIVt+aL00P1T3axyccd8mlXKRHw6mivz3p2ccXOYNCyba
8UM17j+61L/jwK5tz2iTAz+U3RnT78E9Aba8aba3ceGHzy9H6IVqTYAD/j9F
XL344S/rjq9VbyeAcD9lSSGSH/Ixne6LZ0wCw+OFfpfK+OE5Kbvfl19MAlfz
zazscn44FJPskF80CX4p7CSMV/DDxFxu+SP0SeB5qYHu9p4f2pQ2etsyJsHp
r7eHPav54d9dld6TW6aA5p6wn/Zf+WHCfo29Y+FTYLbi9pvFbn4YM/7hoZ3P
XzB9zkmhk0CD36Wr1OeD/gJMOOT2VSINOr+t4QkO+wv6S7PuE0k02GK/k5Sd
+BcohrTPSJJp8M5er7PLZX/BwstV9lUKDW6bL+VvX/gLDkZ+W13gpsGwWNMr
sirT4IZW/slWARpM3fRu6dTrabCwp9P8lzgNTpGWMsPLpoG6fkPvZQkaHNGc
GG14Nw1YBT92MZEfgR+H9T9Og138W2s3S9Jg9aTe6Nn2afChRjHvlDQN9r5Y
17zDRO//kpstPECD7OqVb5pHZ8Dp0wyaujINmjqOWXjWzwDHFbV7fjo0KOY8
k/jj6wyoFgmoX0FueWZhqdIyA5aZ9+heujRoZC7uuv5rBlxrqGhyP0GDLtcG
30SPz4BHlh+u2ujRoGfUgbQ2vlmQdr2uUtaABgOmfHJKjWdBVuol+TgTFP+G
rZL9A8hTXzv8L9HgsZBjLVtGZ8GmVgvpAeQEw/OMk5OzQPfig8M6djTYVXh6
6+uFWSDokBbFY0+De67sEQrjmAMq6ztEYxxQ/KMDG/Uk50B6m1hdnCMNDv+q
37DBeQ44WqUvXblKg5feg+qs+TnwLKCcrn2bBodowt3TzDmQbB+k9wR5vsLw
lOraHPBuvBc9jrzBqnV7C3keVG6VMX3oQ4Nxf6r8cVvnQebxcyWtvjQo+TBO
1PXwPPj1fSzPwJ8Gt7J5ZgL95kHRgxthAndRvKHyHMGcC8BTX2OpOYIG12oy
NNT5FkBB54mxrZE0uPzm5xfmxgWgkWcWboUMBZTeu25fAOVffTvHkMsfHROx
kl0ASVN6JesPafAPVhh90ngBuFoXSwo/psG8bLVv59IXgJCTtdDGOBo8ODvz
RzhrAQh2bBz4D5nhGy7V9XIBcM0oW4YhF4kKhNi9XgDLvz+eJ8bToIFQz5Gb
nxbAnRqvwL/Id/r/amdNLgB22UP/sic0qOsmHyx3ZBGEUiy28aag8bfZTFpR
XwQzZYZ5APnn3fHyj5qLoLhbddwduVhgY535qUWgL/vT4wfy6rY8k1CbReAd
2ZSTkEqD4eoSPDMhi0DZqDyPP40G+TOp1VVhi4DrruK2o8hPVaxzwqMWQbKl
k7Ij8r4iKlkqcRFEiax71SC/t305fzF/EXTM2Il4pNPg4H4um77WRWB9xGeN
noHySbl37lXHIninoqo9gjww++JVUOci2LAQrEZ7RoPmnoWF4sOLoEg1/6A1
slhIX4rT8iL4fI6gzkKurUhdY4ssgatDFowdz2nw7Eqo9THXJbA7ZXmHVDZa
f36Jr2s9lkBV+zOh48gsP19x3ZtLwMRHtNEGWdYpxczAfwnsE482j0e2/2FD
tH68BC6liGzB59DgjehvO4LeLIECDy/cJ+QRS00+auUSwNVkeHUhd1RTtkTQ
l0D/9L2cBeRXLhcc4+uXQNIuX9k9L1B8nu47838vgUOW47+8kQVEPl9jsJeA
e8PLp9tf0uDMJ4cyWyITbBHpfiyLDEu+841SmKBDu/yoBrLz5onZBRoTDNqd
r7BHjl/QjKLtYQIDOzmDPOTn5ea28XuZwDvLc/0dsqLomtZOGSZ4PHjWoRFZ
5kblERklJvjvxLDlJPIUUOvR1WGCU1vUh6RyadBd9u2BZj0meBZ36qwK8ky3
V9i500wweWH2pjZyP67Q1d6MCaqNmcMXkG39VlqDnZjAeUuXbSxy1tsP4TxX
meCNvH94OvK5uLAzMdeY4DS12CUfWSqbyn7mywQPJipNapFdn7/7XfOQCThn
bWumkHlTX4/rxTCB0EaHF0zk0GlnjrYEJtC6Pa9NyKPBhenVcwPpTECvy8kR
QHas1Yx0zmKCk0FNzjuQP6pJNc6/ZAL7o7dHxJElLhRcJL9mgtAoB45DyOYH
3ldElDHB+t6snKPIo326QlveM0FX+RXCceSdoHRcoo4JfFZ8GYbIgES2LvzC
BL8bGy3MkF+OF3Yof2OCvu60GGvkb+cWOnU7mIB1+Ju0E3LTIvtyCwP9vl7q
wVXktxPHWGa9TMAjzvH0OvLXj9cj+wZRf9cuOnsj8/AZSjqNMcEPkuaMH7LU
mci6uSkm8JjL2B+EHCXcd9lnDvlukOg95GzngrKIVSZwSfooG4m8yBVntwXP
AlkFEicfIXef99z8lMwClUGU7THIeUNrn/ZysUDSpMPzOOT7KpM+RXzoeY3O
UALytd9MhcObWECwL6srEdnApGPiw1YWOCR1NzIZuUtJM/vkdhbY5de3kIJc
Q5ixbRVhAdsvVQJPkeO1n+yyEGcBoVWh8X/uD51jDEixQC953isNWdDsbaLL
ARbo7tKv+ueiI8mmi/IsUBUoVvnP28rNttxRZoFXM95u/9xkmd1KUWOBa3Kn
//xrT+eVWlQUxgIaupnsVGQOrEVP6DgLDGrf/PWvP8+itnNknGCBF+qfnf71
t3l/e5X0fyxwUTux9F88Ouml10sMWcD11tibf/H+veYhrXaOBV4ulbv9G48G
+VpGrTkLBAxSe6KRKXa24adsWKDP6Sfl33iuxJIOt19C3y8TH474l0+nbfus
rrBA6uqcbyiy1k6F+8MuLODlpvE1BPlU2AHpqx4s8Edvw/dAZKpb0IWA2yxA
0DpI+jffo6t6i5z+LHB7IlDuXz5wm+4IeRzMAkNbTQT+5UtpdlnsswgWqNYI
JNghM0pnBGQes8D2uT88//ItsXZD5Os4FlC9X9Zk+i9ftw06f3zKAlbzK156
yOI6E21DxSzA+P3WYT9yJ/+ghekbFpDC7zf9tx4yPv9gfK5A8zPOJPxbL4e5
I2vyaliAvjH+Hve/+YR9Yh4/UHz5K/qDaP0JUsXs+n+h9nuVaH+QPbVUk4y6
WCDuv4aIZuQXOb+HDw2zgIk1V1kF8miy/coykwXSOSfqw5BlyL19TmssYJa0
0foOsnQEfxUDvww4hp8UeiAf3uX1XxXXMhipbLxjinzcEd/sv30ZCJb0MESQ
ozR1hYnYMriqfS00E+1XIZd5dnhqLQO1Wa5P0cjfE47x9+suA9xtWlUg8u0b
U7D6zDIwVnf+Y42szOg8E3BxGRyQD27dgjwYdm1qOWQZVBfKVdxE+++Cpmn9
lbBlkL6gkmqLfGbGMaLj4TLYerla7RRywDeejtKEZVDAtHwhijxr1uzg9nIZ
WFYysH/7/2PqZ6WuxmXwheuAIxn56nJJht73ZZAsM7E4js4PQ+6IxbL2ZbB3
8Zj6d+SYENaZ6O5lQCiuWE1BfrtLv1l7ZhmoE3kPyyOnLFkV5gisgIMFmUWn
stD5XfSfk4DQCtBIfjosi1wnP8npv2MFmP7U/7UBeWhZYspEYgX4u32caEPn
HbFGRI+osgIU8m3bziGPJXzdZmK+Aj7ILGWfzqRBs7SOPrr1CjB2ZYYeQG7s
Mr4vdWkF1H/5IsmDXNUd47LqvAKkhcZj6tB5SvOrfJLmtwK2txvJqiAzXOyP
9qUjwyJXPnQ+q1v5d+iOrIBwz6C9954ic95U4J1cAfoVy3WmyCUHmRYtMytg
Tv3iZmnkd07HhM1WVoC58mZ6A7pPDFoHK9rzrYK2xPPa3Mj5+DvJNxRXgWm6
097byTSY7p3R4+K/CkoV2vV3ovuM58ET9vvurgJrLp2WwQQaFNr8vnDkwSrI
y99Bzkd2+Fgabhu9CkiOPLePIL91jrA7m7UKVuwvpJ1B96MXmiwdqa+roCDo
QdvVWLS/VTXcerZ1DZCGV3Gej2hwveNmq+n2NSB26ry3HPJUk9YQr+gaONiS
82wyigZPECeVbkqvgSZBGQ4H5KhkqWvaR9fAWekz3Cbofjfavir603YNjLPP
Couj+2KPvuNMVf4a0Ewzc713nwaPdMYNxGqwQfrtKiErP3Q/FTcdGtZmg7Rs
O19eZDVTfMJhPTa4/8k3+R26nw7cX+FknGUD168CvMLI+Isiojvs2GCLimNZ
C7rf8g/X9Ty8xwZ2rbvVFG/R4L0pxwalr2xwN1lqe50nDV5+lxR5zWgdcCiq
u+28jPJ3w74bRabrYKMts+Mdum9vEfy6Om6xDoxbA9fPI3uXqAxdsFsHd2JF
guLQ/fxov+fuEzfWQaCQlB0Xur/n9mhykBPWQVzxpyeDF2hw13PhXLk/68Dg
Tff0FXO0fr/e8hOTw2Gm3rQPuado0As/FHZBHod9tJLGySHnbakwSVXEYSEz
urMl+mg+3eb3bD2Mw3zX3v6tQPXG8UaZBLIGDssaMjv9EdUjgQ3RNT/O4rCW
8bSihuNofFu8OTRu4jDSvbX9T4+i9gssDI69x2HGq1TFizI0KL8qc82ZjsO6
71v6te1D9UKSkn78Bxz2+eYuv+PIMeEGmyc+4rD9LQKpEqieOp91nPK4CYd5
TQ3bDO6lwYc+ujrfunGYnpHxitEetJ+XYqJ8BDxm8u1R46oQOn/dG5NjjuOx
8gQpPXcOlF9+KU/SdfBYbMgdpVZUH2okTmsUnMBjPOlPfisiN0xEJNadwmO7
vbSNl1B9GdqebTZnjMd6Ast4b+HReBQFLqnZ4zH2Ly+pbiY/dBE3f/0wBI+p
lV6MMRzgh9U/Ms7vq8NjBx4VlTxD9bBMsIPF7no8NvRrV+pxVC9LmbzHC33B
Y7o6g8ThN/zwy42oQ+Qm9D2VtmOSr1G9/4hw/NcPPGbMP/0gswDV0y8T290G
UXv5L22Cn/HDd02bfxuTCBj1mF17bzg/dOSZ6F/DCNjLm4EeQlb8MAVzjXmn
QcAm6IN5ry34YY+VwKS3FgFbXr14y8CcH9IP28Qt6hCw+WHK5yBTfhj4mlA3
+h8Bk1/SPz5syA9/5A8F0C0IGOtKZ+0THX7Ic3GwaK8XAav0WbuVL8cPB5zu
7xnMJ2CrzR1pMXh+6PotkjuikIBRtEJpm3H8cLBONFaxmICFzcxujWXzwb6O
kHD0DSyeS2cqeoUPbk7x5xSuJGBCqyGV4Qt8ELe3S1y5noB5l/dMOI7yQQv1
xkNSfQRMsU349O9mPqi6XejYsAAR++/LpHFoKrLWJbeELUTsHXZ9pimZD8r9
0N97QpCITSx6CG1K4oOhi94KL7YRMVyiAX9iPB985jZVfnE3EeNqIMVlRPHB
8GaHS9WyRCz2oPy+1EA+WJpPMxc/ScS23esywuz54A44rX3bl4hpRS5+UJbh
g22T5//y3iFig6Hbb9lI88Fk4VmhNH8iNorrrr0vyQftxxQXqoOIWCWdLtwh
xgencyYgIZSI1eOf1rjv4IMt5loxjnFETOHMhb2P+PigdrSL3e8CItbzdUgs
YJoXhtd7ZCl2EbGLfzrv7C/hhZ9/dThGdhOxDq/Iq5bFvPDIqbjK4R4ilmMq
icaZF+59/gH/pJ+ImciHqY/n8sKx10E7F0eImP97pfRnmbxQ5qfQvcQ5InZT
yNONFMcLq9UOBIRRSdi0x8mVEC9e+KNlIpbzIAkLz9MEcWq8cPzzWsNxeRKm
3Z4QVXyEF47QNR8EKJAwkzXF6K8qvFBLV+TJkhIJI5RU5OGVeGFIL5O76wgJ
5b+O4uX9vNAiRWp/jBYJ6x37VSixkxeSR0R+Zp4jYV591vsd13lg5d1thWd9
SJjEit/Chg88MDwjLcDJl4R19M25itF5YM3a4z+BfiQsSmlX5qH3PHC40Ue8
yJ+Emc/zaZwv54Hv1qL5yXdJWFVmuEFqMQ/Eh184kBBBwiR9GF+EMnggqdVH
7GIqCdPa5buxO5AHVjuXet+vImGXq/iuvtDkgYavxl4E0ElY0Vzyh9xjPHB2
PsnCG5KwqfeW7fmAB2aKKOs7VpMwnerpE8WqPLDD55WhVh0Je7qv2KJUgQfW
8o/+7WkkYT/P6Ou92sMDWQxVjncMEvYmTWaPP5EHzjP0Hy8ySZiZ7Jy3RzU3
TCuYyupjkTAyrpLjCOSGX30HxZqWSRgWRTHCV3HDCdZDi2erJOxRUZPCw3Ju
eGmdu1wbR8YO7L/Gk1PEDTdXWgu6U8iYlJzY8aZUbtg49xRntJmMVc6oTE56
c8MTOn3bDGTJGDCumQqU54ZXnxhwbZYjYwXP+gXV5LjhqUxNq9/IZVLP+Rb2
c8OFgPuHLsqTMYvMQkt7KW7oykvKdlEiY3FxlpHaItywPurPbTtVMnbwEtFq
jZcbfrLckNCjTca+ZNq0Hx/lgtMm6e14CzJmaNirpPeUC1pmLIjFIV/wvW0o
ksIFEw7SxqQsUXvPvU8uJHLBsXXPDgMrMuZRINuYGscF9d1XtGJtyJi03T7R
6QguGNh3ypjDjoxpl0qIhvtwQf9kxpYAFzK2tHzP7aUZF5ztFt5PciVjQVje
kdvnuGB1DF95CPJ6xs1BPWMuaOuyeDDUjYy1hYf/njjNBT2ujmWFupMxXpKL
9n5dLmijEBPnfp2MnTBf18g5xAV9bGRNf/qQsRj3IPq9TVyQ9kd3ywlfMsaW
m/tgtIELWtVJnqhAVt9ilCPKzwU1dEV4k/zI2Bi3p2glFxcsOH6A18SfjCVt
GaufwHNBuYCB4eIgMtZaOcilN80JVXKdf+NCyVjhapH+/FdOqH49SuwCctRt
YVrVF04YU5nfB5HryHWV9+o5oY75+wq/MDSfdJevwrWccEDw4a+5cDJ2uORz
O6jkhPWqXI01D9H3AikFd19wwu29kXbLMWSMxyTADB/CCZsXwjUNY1F8fA2q
IUGc0O+AiscL5ArmOJk7gBPS7t3+YBxHxvLXrhkK+HDCNyLrElnx6PfWf1vE
PVD/5K5SJRLJWDh1JEbLihNWZ2JTHshfw0256805oePh82J05Npr2c56Zpww
IO5MgHESGSPfzJg+Y8QJp9uK124lk7HIb+ZEq5OcsBjvuJKeivJF1tjP4xAn
HFuS6+9Hnmc5lc8rcMJylzFh8adkLHDhSt+Ng5zwIFnU+zny0FAn21uGEzrz
bV5KSSNjJz8v2gfu5oQm4+Rhlwwyhr93a2ckHyeUmHjfkIn8bWvTf/w8nPC3
0i7cH+TnVIGrUZycUEOm8dzxZ2j84aGQxyROKHzavnpDJhkrrZXmiFumwvmh
QwEPnpOx4GuOdxKHqFBSq9iqFPnd05wfwgNUuLr7SVgP8pk7/buSeqnQ6mRm
q2IWGRM/u/FREoMKCz0Ntv9A3qL1YjzpOxXqlzCurSCbEHYPb2tG7SVXbRfN
JmMl3js6khqpUHjt2nlHZPs866SkeioMX7SKmEf2+GCfl1hFhVe3a9lszkHr
hXnSTPgdFeZevRyohFy5W2XtSTkVRg5deu2JzO09Lf3kNRXSGsabhpFj78ju
iX9Jhdfq728jvkDxxxRHbMmhQrmfhm93/Pt/FPia6djnVCgmbP//7gQA+Xry
4QunLOA4sOFQ8J11QP5Rq9kbJ07jOGBVqbzoCJBfe+3dU4EpHAeimwS33wTy
NwdFiEyYyHGAQ9fpHOMqVgcnK4OEvh6OA7MONF4QAfIrfBnqeLs4Dlzouqmo
DuS/nLByWk87x4FS6zMbPUHnd/zx2tnVxHHgQH3Kh0gg//v5JYc5GzgOpGzj
r8sE8ls0Z5/sqOU4sMNrVlsbkC9/UuFkWwUwvIrKGacA+Q/3CB5mLeM4YCOf
fHoBkG8+KWlnSzHHgTyjJJ8dQL6xw/PZTXkcB3jPFTMfBvL3nqjpYMzhONAW
NYHzLJC/ZJJpUUMmx4FQke1x14D8nDKnyP9pwPB2fc50H8i/6nPFti4FGH+u
Ct+egc4neSet8DeR48DVikSLd0B+uKkXQ008x4GKoFUnvwD5p3/23/sVw3FA
MujXStB5Km2icrsrozgOSLMG3gSdt8KfpDrtRzjHgRi2deEsq4H5c+e1/PJQ
jgPm/wRUOYB8yy9JHt+COA40LKp05AbyC9/+ki8N4DjQte35Gl4gf0bd+W+f
fTkOKHFHp4POh1naKHi2yJvjwJS6ywWg82PmXPi46KMHxwHY+TLt0PNlAPxV
mYU=
        "]]},
      Annotation[#, "Charting`Private`Tag$1995829#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0.85], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJwU23c8lV8YAPDLtRpGRFIyoj0USSVHKSMV+lWiQsoISbKKZI9CEhJZoSRk
Z/a8Rih7z+w973WvvX6nv/p8e9/ee8bzPOc5fySi//iaASOJRDJiIpH+/Wku
3sTpRqWi3r6LT7ik6SD5qtreFbvm2QMpvWN0cC3MBWfsWb7K+e+H6PBg6EOH
I/Yr4lfe+l46dImb1TzHznYIdVLbTYfln8fCrLEjNN4pRu6iQznjuNxjbJWL
i+zT2+mgdT0k1wg7+S5vixwvHWDfaQ5d7G9REp/8uOjAw1p36gb2Mk/g465N
dHjsdffsJWyZAi90hJUOFM0efjnshmhNbkdGOmQd166UwN5SpjJStUqDweEK
TVFs5uPxhYKLNIi+JZ3Hje03nBfxiE4DQ9XFDRQKFWVe2GvAPk6D36P/zXZi
/6Vzqd0dooGZw7fscuzPpMazSb00kH9xs+wjNvepjQevtNLg7/tEbnfsAVPO
A+ENNAhaZ5I2w05g4T46WU0DpaYippPY/g6Sl31/0YB4eTBFAJumPfDgL0ED
NcpHydVpKqr4kuV2OJ8GpfrRRT+xs/3626vSaDAsbcQghf3MTXuUI4oGfWcv
P+LAvlnJraAbRgPZu5dSh6eoKOuZ1OfvwTS49CCsMBj7zlyLt7ovDWzXmsnD
k1T0ayq0OuA5DbZl/pHIxt7d9cG+35oGATcnTnhhP2K+JCX1hAbXt/8qF8M+
0tr7u8mIBnblolvUJ6jogemY7/YbNNB36Vjfhs268ijKRJ0GLs86SrvG8fge
jhF5qjSw2gV/jbF/h1MP6ZynwYZD9kcfj1GRzxvJnJijNCj7JGF4YYSKXof/
13dsIw3yNfZ0LA5TUfPouzlXZhrE6sXsS8b+mHJbsJlEgzs7Fa/wYDtJxMU8
n5+Bm2bpBTWDVFR1mT+sZGAGXB69Q1v6qUgk4Kz1HZgBeT41lNGH119nZ+P3
3Bn4fmZg203sElGuS+SsGXi1kPpfcC8VZRRpOSQkzgDrJqc5th4qUjA2ZVz6
MAMz60pTWZ04HkMkG8OtZkB6t6WjEna4j2PpzOMZGG9sG27uoKIUX5NGJdMZ
YLrzQnGmnYoIN+ULM/dmIOFom+SONiqqdeN0UFabgfdP5ZtONFHRm+m7r5f2
zwCnkM5Dv0oq4qGcFrftpkKDdkrCZAUVGTwoHjNtp4KEAgSoYpez23ToNVHB
5s05TfIfvF4XKhD+ewjIEE3XL6Oi8adXdon+oIIO/yrRU0hFuS1Grq1+VCCi
1d60Z1IR//5lSxM5KihrvCI4sAf3PVQ3OEWFwltioecyqOgtr/sDPSkqdJ5I
VYxJo6KNMtLHNQ9QYYxe7XHzO86vG96PlPiokGr9JMUhnoqmVBQyjk9RYMV6
y/byDzieVBLJJyMoIJPjaFUXQkWr+32NT32gwLqi+vO291RkucmfUzaQAreV
jdwHg3A87X8ofv4VBZgNbodNvqWiFXGD5xo2FMg4pNdc4E1F1b03t7+4SoE3
PivsunZUlO+hq8G7Ng2NhudX4jWoSMzqWq140RTE8W7yfapORUuB+xkXsqeA
wcd5QVaNihwFaqv/fJ+CAzd+6VZepiIboabTluFTYMFQ8eSvEv4918JH5XZT
oDwtlFl+lorEWbdBwNEp+JEtrVSyD4//MWKPCZ+EuaExxevLFLShwkik3n4C
Jjmk9jYvUlBoBc25xnICbuq+Hb65QEFPn4VGVz2cANFdI2w3ZimoodVGuFJz
AmKcvtQqTFNQ/ajIoXrJCahnz/Ae76MgD6JigXFiHE6W9Kg9+E1BetJnNJbv
jENTW1sT6R0FuewR3m14bgwa89ofXnhLQU+ueg4Wy4zBqMz9aY83FHRn3y9n
UYkxONphXcPmQ0Gl1s0qfbvGQPjg26F1NwpKOla2x2xlFPL01b3ybCjoVPxT
z68/RmExuFj7oRYFZQdVvqg+MgrgXGATt4OCrG16u/8KjUDrKr/K5+0UFLAy
LmKzbQRusezd+nkbBc0cf67DyTkCtm+bAj/xUFCVmPjvC2vDcKWpQ+HNJgq6
uP7bMq9zGB4UWw+bz02j950lnq0fhmGAVj/lmT6N/nqTTzVtHQbhio4rX/dO
o3B0xJvOPgS3Cqs9ykSnkSHv0tddzENwlUPDqF9wGomGzPBdWhmEI6sPhLdu
nUYiwsMtsWODIBPr4KBFmkZxtkqsJmWDIK/gfcCqdQrNB/V+lnQeBC+hry3j
HlOoStFGtnx2ANRNPSsWOicR02Im2/b+fpi6JZvr2jKJjMPfbA5r74drezuN
NtdPIg6F76676vsh+JQRw7aySXRfWrx6f2E/KHa9lNmSOomUHD4PaET2g5zH
IHuo2yRK7X4RPnK7Hya4BLeRDkwis+tkA6nmPkiWNZOUMp9AJQ+09hjW9ELU
46AfIcYTSKRqbm9jWS8cP/z59rL+BBJ46uOrQPSC6ItupjzNCfRK0MFjT2ov
mPynN7j73AS6Hv9QdjWgFz7dsDz0kWcCvTu7Q3jqZi8cygpQ2v9jHAlMy6z3
dPeA7LWkrN8LY4juNHBAZaIb/DYZrGXPjCErbk7drr/dkKC05PB5Ygz1RaAg
m5puqD5/RtihZwyN3JfdlJLWDXT0ZgN3+Rji09WRVnrWDT2joXkjwWOIxGpz
lZW1G3LT6xQuSI4hPauUuEaxLvhp4//0t+EoMs9qvtr4sBP4NCS5fuqOovMz
R9M33+6E83VMqSm3RpHTr+we5cudsFIiy+B/aRQlm4eFVR7pBDEPpTHpI6Mo
VMggmYHeARm6dhp7ZkeQz7j4id0vO0C2XHLLG+cRtG81W0Q1pB2q/8tLiwsc
RgL22TrGza1wRFD/qZDvMNqVn3whrLwVvKy6td67DyOzG79P1Oe2gsCJV6HO
NsMo+LHB2cuRrVCu2rWIbg0j+ZXVVQvjVsit7Et4sGMYWfH0iDgut4Ad5VaK
RtQQ4iNMqpPEWuDVmXn3tthBdPruEf8Q1ybwUh64xhI+iAaeL5htsW0C4d3K
z44FDaKIdh8TP5Mm2NMb3ejiPoj+lPtVBGo0gZVKf+MWw0F0frf82QahJkio
OWjTu2cQZdcmRm0raAQreUk+1S8DaIJr+/2SpQbglnNcMYzpR4Yvu/M6Xerh
c+y6y5GwfpT82Mb6gW09mFWleNAD+lHRNml3imk9lItOsDq49KOVAJ0E3hv1
wDRcy/DsXj/SMfIRCdxbDz2ZS/8dFOpHU4O7rPSr6kD25nMH6w99aJftReFL
O+sgwCrMi/DuRZSQSK8evxpoJil8AOdelNLb6fjavgZ2TnQ8K3jWi4yLDW7I
GdeA7GpdYubDXhRlwByfd64GdDruD79XwV7kYOKdrYbnk6SdYht6kUyUeqjC
3WrQCR2e1PHsQerDr+RCJKvgxLSmN43UjUifDpTfXfgDG5DK7XuULmThWZmx
YfgPeF+S3lzV3YX0Ej6XFzT9Ad0vLJwRP7uQv/dxE7n0P3DsYHjGHocuZHe4
KTXa/A+c4pvRa5j7i9QzN56hDv2G7gxdteixTmR85ppW3t9y4FJtfKpc2Y5C
NvEpSA6UQkTSmMyvnHbExaRf/KWhFDzEun+jL+2o572g2J7iUsg1+XL9iAs2
V9Br+U+lYN0YfZx6sh1FPZDhmdArhb0bxWQ4Y9qQMeUDm1DPL0hIeZOSaduK
SM0k55XBEiBH/d08L9CMjH9mrdZzFkP+vsJzVNZmVJ73zqCcoRiWO1bfj9Kb
EOnDI1oZrQhOD0wkNVY3ITYyj/tgSxH017+JC3RpQhT/trDQqCIQm/lNyx9t
RHoT4ZaTkkXAzd/yNjurAckEnnwmq18Ikxp5JvGqdYhE0tAwzAN43LrF3+lU
HaKI5sUsxGFv8dDT3FuH5/tuU7g/wE8rZVYGch3yf9csvNMQYIsvvL6QW4uI
7XYetC0Avb6cj3z31SIuzRo9tkc/oVT2Cv0OWzWqVdx+qEGiAC6xnjfM769C
TtrCXxIEC0DMpMpmO1Qhf6ZfuoEbC6AzusCh0roKCXtH+0UM5ENWYsxtvv5K
FEVzIvt9yIeRG2v6ZwoqEKE0fbmdJR9cGAVetz/+jQi5tDMS07mQ2Mt9aubS
b0S5qxGp0ZULm2MDq1n3/EYSR2QeuFflgpyEds6hznJEWmXmE0vMBYfDbNV3
lcuRnqyLtJxJLrTFSszqCJchYQO5q0OjOZCccFJ1sroEUY61Zm2ez4ajlLzb
pV9LkER66TGHkWwwMJAPD3crQYQJ/+G1tmx4mOiUr3i6BHHJOcSfKsgGMdcH
ia5xxYjyQqzCzy0b5kHhZoJ9ESJpHnRN48uGWJ5zK7l7CET03A4bVP4ByfvP
1wowEihqt6HSgOwPiHgSdGcmF5D6ZFkjXeIHPBjWEr2/D1CPwMNg1e0/IIP9
m44o+ScSvlVWXjOWBfxZc2Y7svNwPEe6Sr7NgldWZP1k8zzkxC8cou6RBWLH
2FLlxPOQhVlryEv7LDjy4Zm5ZkAuUo93vcdjmAUcb9x6H5rlIBLttQi3bBbo
26458An/QML3dg2bjWfCHlLHLufmLNRzW2Dj195MEJ4n9EZ9shDpruDu+ZZM
8Ph2vDltMRPV/vE49bskE5x0bRkPNGQg/5oa1ouRmbDUo3IyyT0NpSwuxYVp
ZoLeE9YI1fpvyELzmV95UwaUbtAY+iD3DUkcY3e4UJ0BKUdLPAcSEpD8MqdF
fWkGGFO1Fs1dvyLSy72PxLIzgG8gzVdL6guSn/9VFhWWAYlMF4/6Bn1ClArb
O8sGGaDM++pAHMMnJDzW3v9eNwPkf3Vsyn0UjZzqL9gpamVA5fuBmPaLUUhP
K+l32+UMeGD6WZ4yHoZ6jLdtb5PCzxl7GG99C0A9RxezT7NlAP+2yLVDrm+R
E8eHMwuMGcC152PPirY/4lIpqS1bTQdj899ndvD6IAnVBclwWjrIBEW2jNa7
IHXP00PCPelA3DvFqejihH8/ivlxRzo4RevdPn7fAemZTZ6qaU6HnojeWyrC
T5Hem2t9v6rSgeTD47j7xG4koQGnfPLTQd7IQDpaWB1Id+pZTbPTQS+iyJjn
+j2QyO6duJ2Bvxe6VXd58gmkTIyvPE1Mh0bt2ydVzriAROzRMy/C08GicIZs
7uMGtaLJZRMf0mGgxiPjw18PIK0umpkHp4NskKoUs9NrIFVXMca/SQcvBT3j
QP0ASCmd1aO7pAPfHv5Au9h34NQwfiXjZTp0Pp4W1xsKBEpB1Ctvh3RIDkkW
OWXyHiwE99Of2qSDy9bHOgcSQ6C2+qGI99N0UJYifdk19QEsmhUi0y3SgSKl
wMBl+RGcpn19lU3TYetqxeDmjHCgKOmupRmnQ/DpBvvNcxEg7+ZDHDdMhx33
mVI3FERBbUniKct76cDDfKdm17kYcHr0hky9lQ5J/eYVe/piQN2gicyimQ5r
dmO/jrrGQm1Ixk2JG+lwinva68KvOLCYJeglGung87b3tLrhZ6C4HJQ/qp4O
c8D58w7rF0jZmtCVfDUd+J9TN9qpxEPPhyu8U6rpULuJ46fHGPZSTFLSJfxc
W4Y3+PVXIJ158sFFJR3yfosxfz6UALX//Wk1U8brkeHpklWVABQoMjVTSge6
Ca9Lmfk3kLA3u+asmA42ki4LrZyJoM7Y6vPtYjrAZZf2sZREcPpv647xC+nQ
NPl756pGEkRNHllF2EuK7BmctCQg1UlKJiikwwsXUpBoYDIQjocL9mM7/tLM
OHHiO8gvioX9PI/jTaKMRaX5O1CKRaqMsbMtnOWTz6SAXv/+//ZhL9h1b5Lx
SQHhv+cOr55Lh2sFLd2FnSlQ+8Ps9jD2Y5WSLNXDqSC8/O3vEHbEvvVXTS9S
gZSynr6MrWPYd1O3OhXk9Qy7xPH3xjnKt47uSoMevr93DLCNjm4Ey8dpQNHV
PZqLfbOZUX0F0iBKefiGGB4v49bNRe5cOM51H9XGYPcuveTkxPvqlDYSIYPn
Ox+ZfTwkFbvhamEf9rkdXHtEcN5ZNLw7+QmvF79XT//XaxnQcyGBwRavZwCz
m+HxGPz8jKvQPbze1Kzr8bm0DCBd5nirh/djrTgx5vyFTFD3OXXTGu+XrdbQ
tT+BmWDxjmoeifezaNwwq/VEFli0pIVKXkmHGzr6urq4bvaU+SaF43jwvhgf
N9icBfJDITyCOF7GPjvQKLY/QCKqvvX2fzjfq2HauvwHOC2UntyB4+3iryzL
Jf5sIC3YjE7fxPHQsn+OIReb5nahTRu/P6A97rYxB5wyPk5O3kmH+Jiv6qy3
c0Dva//INl28/94bb2xcyYEURf2mb/fT4flM3ciry7lA/FQq5cX5EB0g0rwx
PBdSNmSzBeF8IdmXfGaTywOni27ODY/SwV2/ytHDLw+4uFx+BOB86yF+fyB3
54HwvatyRjgfV7+zuSy/zAenVvez6s/S4c7GoBe9hQUgIeW6IuKRDoEMR2tu
cf8E9ULu9NfeuD64BUnX6P+EWvuU7I2+OF/+npDIIQPUDm1PUQ5MB5bi+yGE
KAHEiLFySUw6XDpecsb8QSFEnZbsySnF+fbHWj7apxC4oumGdhXpsEt18lND
BnakmMzlWjwf7WFraeYiUJe2ypZsTwerjzuY6XFFEMW0uIdxOh38vl7WuDxc
DE4DE0Yfd2bAvn1Hep5yloCFc/rD76IZcCCAiAw9WQIp/X++t+zLgNiSjLhB
zxKovSTBanwiA8wOszg+2fcLag31mj3VMsDhSefo3Yel0BNe5lvsmQGimqbX
yv1KoZZcJfbNLwP2eFh2H8soBS7dq6figjLg4ofSu4zr+PkHzrZaHGdPnQK+
hQSWQY+R5jBzYQa0c6v5hEA5pOR+ahtaywA/hnsH6APlIBFcyz3HkgmmHAbl
Vzf+Bgse0aJtnJlwjSy2TLrxG/wNjjsHCGXCvHbs8q2x3+D0sN3S4FwmyNru
NGnaWgEpkeLfnbwyIZWlcFbodAX4Vzlv/vE2EwwP9t55qIuf//BqWQ/NhLpx
u4yFrxVAEdLIKE/KBIMLqiobUCWQ2uLsTjZmwvODPZsoxlVgscv+i5dYFtzS
m9pUklcDXPw5Z2brs0By/kTkYE8NqFNthOy6siB+OrqPkVwLXPv97rDj/kI6
R71HeF8t+N+mdZsz/IBcITuB65a1IPHVbZ792A+4ZaroE8xSByRj6195735A
jwqvveuRepC4Y/ay1jAbXltv1/pp3wh6rIJt3xVygb3pO0vMm0ag1KwJC97I
BV6zei+PmEYQ7vHJjjTMhXpJVuZLFdgTcXUD3rnQ6SufWSTQBClJcl7mdbng
Vv4r81lOExBjkYOOD/IgUF37PH22GYgH+cyvQvPB54Upzo0WkO94kRWRnA9y
Ya/7TQVbgCRQ8rq8KB+qpNR2dF1ogR6BrRG3x/Nh534lkbR3+H2LXpmXZwvA
6JLRpW3HWkFeRnI5d7AAFJdFjleatIF8vw556SIAX2JPo7ZjG+i97tdKuQNQ
xRBIHX7bBlG6GTH2TwEy9GTfrWa3QY9N8kaNaAB72+vqfKztIJHYMT+3CmA5
TrZb+dQObCSrieC7BOyRM85629YB2Wl/2sNFC+G1/5EdAee6gD/v1rOciiLg
8DiZqX29C/aVOxWatBWBYnuBs4hRF0QdYh8THy4CzStbkr76dAEbv0drDmMx
PNrnvC+2pQviWWW4bp0uhqvn7/rLP+qGlLN3uB99KwZj6dLNnqo9IPOAZj8T
WAIyx2v5tC17wT/HyvGYeylMxTyOfmnfCzK3Ts1fCyoFG3ulnbFuveA1o8Lh
GFcKjILbe0aDsROauKm/SkEyIMjPOK8XegaEbl5iLQOPqfzFY0x9kM0fUlb+
ugyGHrDGUAL7QKJO+MJkWDkYZsRfX0rrB0rVk/G3rX9APyZFXC4PeyehWj/6
B+Rzsoadivuh5/Z6qcDyH7iaTsiSG/uBv23vxhLBChgYHtq5TO8Hi9bhONv7
FWDx6pXiD+kBkC8vVtKnVIDVyIaKuzkDsI/xGXGWqwpy5fyOKucNQs+T+iu1
RjVwSUrh3oXiQRA+dXmCA99Xsy6nPEAVg8C2bqB7A99nc13Luo51DIIXe/PP
xYwaMNd0DGBbHgSnso0i6gw4L4QnfBxOD8FlpcWvqWq1YCLmZWefPQRzxpVJ
d6ZrQVo09mduyjA42AsESpyuh9aab7XsOcNgNZMu+u1iPegNhd3WLRwG7ljv
XQc06iG0or1ttW4YSkPitU8Y1wPbvK7RPtowWFp0VDkF18O+/5QUJE+MwALr
hZExGv6el+rYjuwRuMp/eRdLWgMw+Umn8ueMgiHLNr79Z5rgzwrdjLlwFJRP
VmplKzVBa2u9A6V8FD4+UWhUvd4EU7e+Bxe2jgLl68jDl4+agDFcIUZtYRRC
ubnX+aOaYM+NtU8CJ8fA6gcLGy9LM3SpHb9jnD4Gouf2yB1oaoYEzbhtJZ/H
QfiZ6rugl60QOva+sTBpHFL4j7go+LQCZcV4rSBjHH4+VRulh7RCZ99kcGoR
NvdhQf20Vri08rzGvWsc+lZ1mA0HWyH5U9ZaL+8ECDMr7OW5jPOs88VtQ9cJ
0E8W2L26ox3yq476e2pNQk93ckffrw5Y8JqSENSbBP2OZj/jhg5Q9irdnWo4
CcJx7h7Ung7gUtm91vB0EqxkROTZVzrA5rbsc2a/SUiQGCkxPd4JCfrxJ7YV
TYJ6csWtkshO6GwpmpjZNwW5KnuJvw5/oT0vU82aOgUXfrGFOst3Q5oH6hda
mIJqeb/tTOrdcEjMSa98bQr4VxKPvNLthqWPMnw8m6dBPewkb7RjN2x+yH3v
zZ5pyO9ZSV/M7wbSotKG3ben4fm2uPADgj1gOZ16Lb1oGo7TKwqaw3rgAv1e
b/JFCvznayCqEdELPJ+qvEAZ208x0OlzLwh3XOCrUaWApDA5MTW5F06ceNo3
pkEBnobvf/ihF9Qmo07x6lAgrEE6Y6m7F1RLOdKkbChwrDggbbNoHyQFdV8M
j6MA5S3vQYMvfRA03cW9gYEKO39tEyrN6odJ2ddBJWQqrotjKsehH+TW7y87
slDhR870YGRZP1C3tz6mbKKC0Oipxy9b+yHN1X7uFx8VcryvZqkt9UPxU1v1
M4eoYHrvfICU3ADkbIgevXKTCvXOT7Q3lQ3A0YI2d7YvVHie5B9T0TkIHu9K
9Oy/UkEnhtnkzeAgPC24zDP5jQra4yr216cGocHHY60yhQoXaFX2feuDsC7e
PeKYSwU2o/B+9t1DYJWsN5xQRYWt5I6S6IdD8GWw8p4ojYrvCTIvcuaHYE1H
8bzH6Rn4k6m94L5tBHh4rxZ7yc6A38n4kmWhEZBisTn1Sm4G6mZk/Sz34bxa
+sr06vwMGHcd3nb/1Ah8e3CW58WlGVhNLKWq3R4BheMicxLaM+Bx3fTmrcgR
kLD4tlZtNwNuqeJIeN8o2GxeTP6bNgPF991NH8uOQZHUvM/HDPzvN6lZCV8c
g9hnFbe0s2ZgIX2DVv2VMbi3/1VOfc4MRD89kSGjOwZzNuYfs4gZsOwM+8Tp
MgZdUg61l6pnIMRQdHSwbAyiRQxOx47MwOKRu4YS18fBsu1yAK8ADa7JWp0X
ejwBsanibck7aCB8QqakyG4CMsJuNysK0kBU7aqwkcsEuCmZ0CyFacB7PuVB
WtAENAaMZuTtoQGXPHnTf/kTwD7zRJZTkgZI2koyf8MkmOm+DS24RIMpnb6d
++MmQTLMzObwZRr8PecQMJQ8CQdXjjB/vEKD1meKlbHZkxASQzpjrU6Dqv4Y
792Vk5A+S2Lmv0kDRwtW/gO0Sdgowbmy6x4NQjtNhrXPTcGkPXf5MRsa7DyV
9EixawpWPlNrbG1pwP7FnHPHyBTwCEZ75tvRgBbBokvBedivsZXlvD0NSAHj
TOHM03CIVi571okGjKE9mmuHpsH67acXdG8afFxnfdFjPw3bzIvSDT7i+Xw+
Ps7BToHrmfI2VwtoYBqXFHIgEedJ5NWGoz9psKb8S7ghhQLvxYdYuAD7xmSP
fSYFdK48p1YSNIj/e5Gt+icFMnkz62VKaHBadmnMqo4CTB+jc1r/0CCn5QlU
zlHA28Pnp0wLDeyUVsM+naNCseTRBjp2JpNQsIYiFaQFCvO/t9Jg3ZIJSKpU
mBZ14xBtp4HRynSY7nWcJ3sUvy100iD3hvBzISMq3No/DY/6aDDo+Nbjiw8V
LJbUN9lO0CA7xaWxuYUKTc758eyTNPhAu8P3upMKoipl22Own/p8eoF6qRDy
PMjmzxQNNDdfyIsfo0Jc5laBTVS8H+1JYw6rVHiq2kW6PovXf4NL68HdM2Ao
tqmxBfsPffJK394Z6Dmv+lx7jgY1BrwDIYdmIKlnAN2Zp4HxB5MnLNIzMP81
IlljkQbnRRZY+5VnYOi0JQ/TKg0+7xvpizafAUaBw1utsS03tslrP50B6xXn
4QHsjPcNudw4b35t7GIuXKMBw1o2g5vzDLSIRgubkujQF7apwShwBjrtI8s9
yHRILlk/J5WLXd8zPYB9xePS2amfM/Az4cboOSY6kG6Pq8UX4/FXFV1bwI4S
YczdWTUDD1+zr99koUMkl/IHlh6cZ7Qf2R1sdPjPWP18FzMNJrm3e4tvoMPv
ns2lzhtpcGd8+0lzbPcbabfFOWmgYDt6cAU75sjHPDN+GkgEXbLbuIkOYef2
Kq4coAElXPKEKnbLRSONqKM4rl3Cal5hR4rcMrsgRYPNea0fWTbTgXZaotbn
LA2SMj6FULDnga60C+fJ8+kd5/ax08H12lx50XUavHOaL9XB7rhtoWmkRYOV
xHKTcmyPgNSwFH2cV0ccuP046MD16VOOgjUNgj6lxOVj9zJ+ihh5hvMaHeUb
wz6s2Ovn64jjVpz05hwnHcJ3kv1bPHFcdsV392GXvGRnNwulQep/Q3fYuOi4
jl28sCWSBhY7tX8cwi50dXPLiqGBJFsn2RI74evyLoYkGnizDM0GYJu6x9l9
TqXBBs5dv9Kw92w73a6aRYNHGVzLU9jMYywZwTiPCn6U3du0hQ6llJSDsjhv
uALi4vb8s8z+hN5yGnRo1pRoYYvyGOceqsd1RYo/6gl2p1GUan0zDWYrnG95
YQe7vOqz7aBByZ9UvTTsoVeawsUDNBD/bp3yC3uXTGKp8SjeD8Ubf1uwPx8I
fsKB455urzY8gh10rlo4Y4YGBir3qxewS26zN2rhOO7MexPAyk2HKs3Nr9eX
cZ5QGyR5sbm3ul2Mw3Eovf1omgj2T/PDZFVmOshbRbEfxq64WFhMwXHx6fpe
xZPYG2wXPILxuo8KFt+Wx97Z8/qyLA8dNl58elUZ21NHamvfNjroqZ/cpYad
WJPw13MnHeJbOCquY9dwxccfFqEDk9vidS1s0fUBqwZxOqxxzufdwSZsBc4/
O0AHZyVWki52uiYDl9BROnSzHhDRwyY5XOsqkcTfQbpC/xxTWJpoIkMH8+nP
SzrY75i32XOdpcOpfQzp/75XLbainHWODnzs5sr/fk9z5QjfHUU6XKufzP03
nlMPjfsYVOnwocBp47/xvlW+l/RFDf/Onr0n/83njW29zZXreHxPe+X/zdeu
wUqOdosOViIpe/+tx/dTDEwf7uL1yXk3fgg7y1OiTE4fx1mbj8+/9ZQKy/Mc
MKTDviMfN/5b7zmN2xdfmdJhxbbI4N9+LHqXrx+1oANFTjP93/7Fz009tH+G
1/dtWdy//VUb2b5dxJEOj9yvWf/b/9NNs8WlLnTgz8n/Fo7tLBi7iduHDme0
I7j/xc/EyZEvP/zp0HM38ua/+MqpIOTuBuG8ZGe2kcdm6eW+HR9BB8fPZhr/
4vOA2Fr3lRgcJ88WN/yLX9KDezq0L/hPY2/uOhzfMveeKsql0uHjjQxnNexq
wbW8hmJcF2RtFf/lTwtnH9OzcjpYapiPsGKTtzNf3FWFn5czlOTh/JNinfhq
3EyHRt71Nl7st29s1lZG8HwFYr1GcRyFPvVZjJ6kQ+4H/63/8jstIX5UcQbn
Af1SyV3siryWL/7LdOBxDHJ9h+uDp9SlwN0cs5BzonTnv/px37byaDn3LPy3
6ea7vdhnn+78abZtFn4ciuL/geuPkOaGtEzhWXjccdatHNerb4oa04qSs+Do
0tiXgeM64baFs+GtWRhl7JA0whYvZpsyvzsLKWd2HeXHZvJovWirPwsrB5+I
2eB6Ou6UnulpNgsZ0WMbRVnpIHjjkc8Xp1m4HOhZeQrX44i1uNK++FngN9lf
0ozrt+yCTP5o0iwYSJoZWmKXvNN6T0mbBY0FSkIcIx2EX7atrObPwm5akdQK
zsOVk5PPt9XNQmqa1LWH+PzQPydJv7A4C1qFD+cpKzQ4EnOc/9LaLNSS85Vs
sWt/b9upRp6DvQ7toy9xXh/M2V90i30ObvbSpZzxeZU75vXCRGQOunXCphTw
efesSFTfU2UOOpZspf6M0+A4U55J7Ic5uN+eq7YX+6aQZWdsxBwc1rq9zXWM
BslPSkXjYuZgv3v/N2lcdyYNug7GJc3BOWbtcd8hGrD2UMVjCudA0eZZ9UoP
Pu/2DJgEj85BneqJl52N+Jyw9C3SPDUP81w6cpzYifcjt1+Tm4cYG7dv8g24
rklxn76sMA8tukz+kXW4zralN6Er80B2feR6pZoG0LjdXOzePJyu3S5iUkYD
5iTupj6veQhv0Pn8ORv7SPSG463z8En3cSP8oMEXNzX52s55aArv+duC67Sy
YtZZ89554N61y5UpE/cTN16//jo2D+PB7/nVcV2nPjM2FVydh0fPrjmkfKWB
wJXolUWRBeArJ78N/kCDYrP7pm6mC3Azl1P5dQgNyj5yTQpYLEDQgEGn43sa
XI16fCjVagEGCo6H6wfRwPq/3f2dLxZgzVLIeedbvJ4JrvuO+S/ATBFLr5YX
DR7kKzVWZiwA5RvxfBmfa5U7c3OqVxdg67NLKxVWNGg67W14h3ERzl9Quxv2
FPezTTzloyyLsOq/9af0E7zef8/Gk7kW4T/W8BVdMxqoNvA1SYouwvQTTUcH
fG5avbX75K64CEFsUYJduF/dYN62fdJvEfrYAq8qi9Cg+5rdUt6uJSCxdtel
CtFAnnz7XeDuJajgu8cmsIsGHqaMYLZvCfwnXr4Zwv02p9bpqh3Hl0DixIMN
Fltp0MDvm2d1cQkYG2i/LrDSQGqs4u0WsyWofGMnMzc+A43vyrPo2UvAwKFO
dkrF/fya6psrGsswdD/h0vvvM+A7FC3EdnMZ7DyvXElKmoEdr5MOFWkvw/H7
y25NX2eALck7T+rBMrzKaS7k+zQDAn9rP/HYLoN4ZZ//nYAZYI4JVs3+uAza
E5Wuc09w3yXR+SV0eBl4iBQms8MzkJG9Iy/FfgW8hb58OXtwBhzsWnSOO63A
L5VGAY79M5BopPU43W0FGrXNLb+JzcCp/sdN6b4roOk/ONayYwYGZvcnJUWu
QPQlxd0LG2ag99OGi+7FK/BR+Mrvm4NUGNhyY6xw4yoU10WNBYVQwemsXJXu
+1XoDFNq3xlMhVY9RcncsFXgLHoR++kd7mO3P5zhiVqFq9LKvxP8qNCl8Pv5
r/hVsMk5oJXkhvvadtdvwrmr8F84V469BRW+/Oeq8qNzFdrIbRlySlR42Sei
e19kDaLF13KMqPh+a3Hk+uf4NQht1T/UPEWBum/nvvkkroH1k/dfFSYo8C37
m55lyhps0+H8tWOYAhFP3g2eyV6DkchgN6KTAgKZghplZWuQs2WbSmcZ7uMf
Rj2HoTU4re5O1gmnQLCto7Wk2Do84dmq+g7fz/U35u4UDF+H7G8/03+dp0CX
fNyJtqh1UMoJOzaPKNATtS8iMHYd5rJDH2mepsAh+S13NySugy6T+fjmoxTo
ZdrlM5a7DtYTcWKX+SnAsX3U4XXrOr6Hn3E71TgN9myVm2M2kIjjIeOLwnzT
cPfV7IyyAom4lqK2359zGmQ+nnKUvkgiMo4vXlplmwb5FLsPu5VIhIvxkmHd
8hQwDt1+uXKJRGTr1HDc652CUbsBpq/XSISw9ybPXYlTIMvo1Tpxj0TsC44y
5ZWfwv0/R8ouJxIhlZa4iUN/Erhq3ifsziMRU4a2/qvak3gdRPfQ80lEuaXb
nvH/JsGDZd/+kp8kwiLLyIu4OAmMd0V+6ReRCJ3PD49d3z8J66GSGqG/ScQf
H1dvIcoEHOw5Fj7TQiJYCIs+FYcJCD8vI6JEJxGM/DEHNr4Zh9F2pQ67gwyE
nEqIJqPXOBSKfDdmP8xA9B28NrPgNA4mZqIe0UcYiJGKOstey3FY4/9tUX6M
gZi7Jp0YeXMcxD/fYdwiw0BMeAXq1wmOg+COPpLvBQaiduD7zOZvY/BxkAGO
3mUgbv6RDlklRkHoQhRNwJeByNJWSw/MGYXtv+OLA/wYCJ+80lsH0kbh54FM
wY3+DMT5lC8XNGJGYSnJ4fF8AAPBWMCZ5Os+ClOWcp6VIQyEhFXy3kKVUTgw
r/9UL5aBqOZyZeSrG4F9evoRR/IYiAV+ltdvO4bBLfeIlu4wAyHsu23zXMMw
bDkCB9JGGIiS4PnzWpXDYLw9wJ1pjIHgaJpp2FEwDHsmkpu/TDAQlRIeb95G
DEPErncDI1Q8nsneenRvGLja34ZfX2EgQhYe5ycMDoEsJ1qq42IkrP47P9ow
NghO3W/E9GQYiRkx3eejfYMQRx1MDDzFSJDGmrpW2wdhX9r3nPLTjMRp6/Td
uysGoZn1ht7Rs4xEsOu9BN1vg3BcbKR77hwjcVzhNm+06SAEII0Qc1X8vHIi
XXl8AGKZ8y1IOoxEp6/k34vD/aDXVTbx1ZmRmHqq/OReVz84XHUJanZhJOK/
upXZN/VD85eYL4xujIRULiU/sbgfWoTKWLU8GInGC5v/rkf2w+sspcy1V4yE
9BByNL3VDyU5LOmHAxmJXbIe8XfK++Bzon7C9s+MxPV6D4Y/sb1QIVd5XLyc
kXA69HRrWFgvUA5FBx/8zUjYebBxmwb0wqthis6xP3g9CogaVqdeWHT9sfNM
JfbGR0ZSt/H7bP2XlGoZibRY0RDtLb3Q5DVw73wrI/GcdNWj26EHuChaa0XD
jMR98Tv8PdFdYF5lIjnGRCZCRfKMLvp3QYYJ7/lcZjLhx16186tjFwibJP3y
ZiET++yu55ve7oKfzE8P7mUjE2r6jNN/t3YBqYz++PYmMuH8K5XH1vMvuJOn
675uIRMNJVuGXE07gd/vXuxfQTKRVPif1oWj7SDwQZceIUUmBv3i3qsKtkPr
57M9qifIxO2PHM4am9rB5+BuuQXsRm4vLa3hNuCJbldTO0kmWI6WI63INsj9
r+X33CkywX5MrkWAsw2qVpg4DyIyESUmNpA42QIJAn3v96mQCYuWtouXvjSB
XX+ur/VtMjHcNk7Yv2uCvaedjmy8g+fn+nrt28smMOeJF4/AptwXLmO71QSJ
i3S+krtk4tPDu5npbE1QQbnLxKZHJuz7b1yofdgIN68aMVg8IBM9lSdFjxxs
gK3SSXKEGZlQFz+RcnpbA7xl2heCHpEJd7arRxTJDTA19lvxJ3aAtzdJu6Me
Mop1YnLMycTlB4fFrV/XQ3hq3a14CzKhuCX4+/PxOvjIcTjJwIpM7Irlr61M
qIUb9EJC155MUG3f780NroVFrefJv7FPB7OHf3apBQstNcpxBzy+xMhhB+1a
EGA/ZkF+QSbKgyJ2C22shXpVst5HRzJRWp0wY1NfDSUZrxeTnMkE3bsuRzqh
Gtw1osTZXciEcAV9jO5cDdK5OnGm2A522cFmx6rBdrwgco8rmbChTD9Q8a+C
LQaqLwPdyAQ5+6Z+3pVKuD4336/mSSZ+kh7svi9eCZ2mIUqx2FH1IQ4bVitA
WNphbR478jkr+VpiBcR2zBqEe5EJfZX+lPqNFVDyafOOHm8cf2qn+IPKfkOg
4x/+iz7Ygmqax+XLwDBY7KyvP5nw2Tdx555AGcgsjXWUYUv+1Hn2hl4Kf9ud
+xne4vcvSZNG40vBJIL7sBX2D8Vqz7dbSqFty92vGgFkYjvHnze5fSXARYQp
UN6RCUa+Y7s680vArLvikUggmTDsOj26ElwCsjPBpGvYH4u+ycmqloB7O1U3
FTtkTGZ/Wnox6IkYMz8MIhNj9c0cL9yKQHa8ZyQvmEzo1pxyfadTBKocD8P6
sc/T+bW/yhTBGIde1sb3ZELCtVimYaIQLKb8xTWxlW9xrwjdKIQcofyREWzb
+YjSY0cLYd+QXdemEDLRpRzCorChEIw2BcgewTaZUaHcLyCgcqj22BNs5Z+L
iZHiBHwWVSJRsNnE7P5orwOUdCXKcHwgE53BearW6QDVrTptB7Ef5Vm++7ID
YOeBqP8MsC2F1fMZJgrgZqXhwTrsB3/tTvJFFYAMsRI3hu3mpTK6/3oByB6t
8yKH4vw/2UpWy88HBY2jnpLYscYPPvj75MGG5+8NfbA/Z7hfjZTPA+O2edFo
7F3SZ/SS6LlgpfZaKRPbpVIrsexOLtxzVvzdgW1sKUdp4MqFjibTPVPYTBbJ
Md0lOSBlCePr2H2Le81mD+XA3I7JZJEwPB/dpFfrPdnwh/1X4jFsx5rMgxuC
suEmVxn3OewrrUpsO1Z/QJLdxW062IreV67sTv0BORxEpil2xdPqvQcNfsAK
7718O+x3FqdTTlVlAV2eh/Et9qPaaCN55ywo6BE99xHblfyiTPFEFkyM3hj5
jH0DvWq8PJoJ8mnf5lOw4ws8310LzwR6yO7Huf/+fYHkhlsamZDLUnC1GPug
y+XTd5kzoeSRbXAFtuWLgl7DRxlQKXRFpx37lVrAPVORDAhwNOrqwT67s+o7
7kzh0FpU6RD29tOH6p56p8Nx+UW+CewgBvM/tmfTIXv6cQ0Fe75KPcqemgaX
C5kodOyclQDNl3FpsGj5w24BmzYxQ3fRSoMLlZ4Pl/99n3T0hQd7GhyJsC5a
xY4MYZ71LkyF48VOruvYe7afuOdrnQqXhL4mkj7i9R2yL/XfnwpDkVNnGbA7
H4TsD/ybAnNnNE7+89CC8pv3b1NggFYb8u99XtbLK6EXUyCo7pH+v+8pD8GY
LO07GI/sDfz3e/3nPNYUbn+HMzfWD/8bT/2A0VnV4mR4IEc/+m+8yL835drB
ZMhsYAn9N596soW+9rskcLx60uzffF8tvrmtv5wIHlT3z+PYnnt/xpncTwSe
DTTlf+vVLmd76WnFNxgac/zv33reHDv5n4PkN5CZ21/ahn291uG3e1gCEO/o
UfX/9t+vKOsNOQHSTnT3/8HWy3MXCzX9CtmaY35F2B7BNl9SzsSD8OkHgv/2
+6NSeE1+zBdQEGkk/YsHjUeSEb83fYH1JsPLYdhuyZHXBzvigENnfocbdvVz
czW6QhwsxcxF2mJrC0TwMSXGQsbHHT4m2IbJXBJ7HGKAjd728Sr2W4bmEOud
0WBuei6KE5ufofiGh2cUMO98WrCG8yFLoARJDEbC2lCW8iQ23WVs7cXbcDBh
fva1HPtPp0rlibEQ6OlmCbTD5lP4zm5CvIeR6BGR+9grUxYLUcHBENs4KHgF
u/WSy5ZtCoGQ8/eknhC2hJmyz2WZN7Ax5h5HAc7/8lEj3/4BHxCtv8geg93Y
uGPd6e0rcFtQf+6FLd+xt7hmzB2IwL4IDWxhO14z5zPP4HyrCPdfXI9I5VZ9
heNGyCAh5lMrrm+EHodecZgFkq/47ZaJ7T81ZBN4zholOEk1vcWOKuZ+yeDr
iKLO9xDK2K3MikEv33ohilxN8XdcT9nyOyLqA4IQ6Qv/c31cf90mjV6s5gWj
KfGP56SxK2VcR0QH36MLQa9sN2D73+EVvHsyFM2xpx9JxvV782nHzb4dEeh0
9cs//+p/7kXBLIMtsSjYyD9XG58PJQqP7lTExaIQb34TceytX6xzD5+OQyIZ
p72m8XlyR4/7+Yj+Z3RJQJvLBdtJ5DTHiYx4xNV6Tz0Kn0cRnwcJ0ZtJSEXo
fUChH5nw6sjLUhtLQpfbbh52xQ7MmWyyc0xGxo9GpC9gVy42msHn7+iuin9w
iS+ZaD446uy3nIJYfup4/cTnn9vvQ2zequkoKtTy1PtXZOKWX2W2Y1A60tbb
V6yGrX9xw0nL7nTU6knJY8Wegw+vrj3NQOFXfy9Z4/N062T3loXQTKTevy1Z
FZ+311zyoX70B7Kb2jXd4Y77HZOdwV/c89HB6Esrb5zIxMT+v+h1Uz7SSxNv
OoJ9yOFnoql4Aerkl2SqekkmEqyu54j+KkCn3pIMWLGLxmbXjZkA6b08cNwK
9xsdX18n7Csk0LZdTAxHnuN8bGLsyjhbjOqX/ONEn+L4PZ9t8cigGAVQ168l
WpIJLgPSJjHfYiT1MEjzBHZE3xbV153F6JfTDcOLT8jEwJXChHP2Jaj3KX/Y
3ce4/3vJYq2a/QtlvDv30NyUTDwXfPcJJMqR+eNrLVvu4/dvleVJ3ipHgb4/
n3vo4/UTF3KNe1mO6MzWNkv3cD9H4tviUl2OosNGbHpwP1c9eKxzl9lvJMbO
GB6rQyakfWWIgc9/kL9Jnwe7Ns4HlnMafgJV6MbmEQF9dTJx7w5Hd9dKLfqv
bdcP/jO4HxlNS1/gqENs34XbHp/G592nXzJbROpQXaGraSnuT58LFanJXaxD
tdff9z6RIRM6YbS3Xr516ISAwNYi3N9qLOqadwrWo1d67WFKEvi8T1oteXa2
AeXRrF2GxchErY+G0BW7JuRSq3fgxWY8/xftWhtfNaGhihv5KbjffsqutPYr
rAltm31d2L+RTExamzvJQBNKuTglrrwBn8/pT1U3sjSjtNlJzY24fz9pHsSm
964ZTX3gMLNaZyQ4bR56VCa2oImKcyndVEaiLHC7yKP2NmT0ci2St4mRuKd7
Y/bIZBtiNNW+x93ISERd9gmbWm9Dem6WzhwNjITeWedbRuLtaPGuaBdTHSPh
zBtvLmfRjp6yvt00hu8jKtZWf52ZO5Dv/v+UgksYCaPPnVrXj3Qisj/3H5t0
RiLSSJ/0164LmX330L3zhpH4kW9Qwva6C/kZc5se82Mk9j7byHw8vAt9OmHY
zuzLSLhfXZxzKOxCTFH5A4n4PvU+4acdfUM3en7GPYHmzki8OLm1xji0G92J
S2Z/4IDvT1bMTcl3epBMxHxVrTG+/6Qujby37UX+WoEnuxEjYRH9yvKoUy+6
+LSOPVCOkeiyVY/45dWLZFuZ/1PG90W5/u3tkx96UdJ4yoHv+D5J0p6sO5zf
i24qfNhic4KRoAdInTUl9SFtrp31IwcYCYHPKp0tnn2oSkKhWJ+XkQiMbdHV
DOhHJEGn1CR8H/ZiqKkLCO1HAy+LGBC+Ly9JuxCVn/79/xWusppBBoIYrtsi
m96PEtGJ1Ok+BsLPcqsVW2M/EiyyYNn/l4Hoa3/8Q5N3AM3NogrnOgbio5HZ
ucrgAVTdlWdVmcNApBg+XJ0MHEQPjyKBSi8Gwuytrf3Zj4OoM+DCw5ueDITT
LxPv1zGDKBmOXOxxZyA8lM78tzttENFFN8fOuDAQtzz3BJyrGUTR141I3C8Y
iPyTjtoyG4aQwbUQpTNPsOeDmTY7DKGqOb5UGS0Ggqmw2k3y7jB6neHDNbCX
gajneeW3+8EwOvvjo9q1PQyEHtl3M7fpMKINPhEhxBiI+O68+2N2w6gcVb0I
FWEgJv4yPPUKHEbW0bQdl3bg8fhH/XhWMYwkPlqSgzgYCKvr36mHZUZQzOXD
h9rpJIKrsP9s6eZRtNXE+t5egkTIlW7d/ZdnFAV7MM7d/EkidCwV+WcERhGH
1OstHvkkQv3JFwm+/aMoIZunqy+bRCTHqGxSujiKpr0/1QankgixI7Xzl16M
omM2nTIjn0jEgsIFydbxURSR+JV03J1EdDYYNk0UjaFru+16jJVJxMitxlbX
32Po+2MmOXtFEpEYtq2KvxY/t+E96HuBRDS7IQ/Zv2Mo2+5axnd5EtGusnbY
dH4Mqb/g8ZyWwd97uTb24OA4erIWe1l7P4kgWbP2lr4dRyVX5TX+biARbp5j
JgdvTaBbg3eUzr9bh+sBb3ka706gjWfmxWzerEPnm7iW5/cnUOCvU1e/vl6H
tEtJKUXmE+g+51c3drd10P9m8fGM+wQKYKz2rLJaB4p33eb61Am0U+n8zkM3
14FJzXPYb8MkGjoUsc+Afx1KT7wIP5E+iSinWFQaQ9eA5Of+RD97EnWeO0Lr
DF6DjzO2qr4Fk+h3jdnCQMAaCPvVc/4tm0SL5ft5aa/WwPGbad2DzknkYf86
gtV+DbIaFilbmacQ72uNfdy31+Czk4H57PUp5N7B25QssAb6oluOf56aQhod
V8K3hqyCS1e1/2naFMp1WCE2Bq5CynX9ucr5KSTcE36D5L8KPhdpjeOkaVT7
53v9qOcqRCWLtG7hmUalgvWiWbaroPjkZO6a9DQ6NnFGQ0pzFQJ4Mzm1X0wj
gV2ZH8p5V0Fm5NcZJkYKOn4z1kfn7QrIxITKcjBR0KiyXOtx3xVYXnsvs42F
giI5n8WyeK/AJk1/kT0bKYhgroVEpxXQFOfNOMlNQaWZq2y0xytwSeUNsV8U
v992TtD46gr4a9nHKJ+jIMsWeY65jStwoMt+j6kDBcn2P5f47rIMl76upms5
UlCus/1dNsdl+MTbzazkREGJbiGs954tg4um9JygGwXJ37Np5LJYBhrJkrng
NQXd4BvTMrm7DEebzhMQSkGHzm69yyyzDDtYyAXNPyjoU4LO278TS/A98/gf
hSkK8stwOrH/xhIseKyb9U1TEL8n6fwD9SVoYJWsfEmlIBuJip4I1SXYwKMN
WXQKGhIKaeY+vwRpYs7WvMsUZFv2NHH2yBK0+V9gC2alouvlBpe/sC3Bdu42
phghKvLV08zOz1sE3kvib4ZUqWhcdE6iWHgRxJ5XyQpeoaIDoWvlMjsX4djZ
tT/XrlKR7plbW5O3LcKT1iSvXHUqotzdUfqeYxGiCk96Otygogct8eFGKwtw
grPY6Y8OFSVcO3x7sWUBzrnnDvtaUNFjwSPkYb8FsLHb5Rr1hIrqzz5589+r
BXjyrGYl1ZKKpg5RW8B9AVgam17VWVGREHtpxHuHBTi5LZaT/IyKLjeGbrpg
sgDH9BmTjzpTUUNhZpT/xQWISlOsSfanIucXCd+XlueB102ON/wtFY28ibmq
Oz8PjVl+J18FUBFPfFNa8cw8LF5b47oXSEVbHjFXvh6dB/laL16GECoqiLdV
2d4yDx4lC7c2RlIRo07T9/1p81C1fNfkXCIVxTSGiYkaz8NNm1jhTUlU9MIw
a+7l/XnoXAhKbcCeCtz6/q/OPFwQULl/7zsVTVILFEJuzAN7+0emx2lU5PQi
4/omBTyeN+FS/2Xj8W/JCRwRnAfuY1VLcsVU9OjQvLdzwxyUCCptnsfO99XZ
olY9ByZqz5OTSvB4fuw33Pl7Dq7SG2P5SqloH9XpWdbPOXD07NRsKaeixF+X
ro18nYNtNaEVPNVUJCXKJ67gNAcLNnp9GdgFPspp7PZzkNHN7n29hoo+x0vz
tFrPQabRtPubWiriM+nUMDOdA6uol7L0eiryJJtVBdycgzFUHGDXQkVEeBBf
66E5+B7r94mxlYrG3h/kjNo7B7UaPudeY5/3ae01Ep2D+VX6oZA2KhqM5Ng2
v20OvLfoZkd1UJFaNkclD3kOnJk4Pph14/lVOecots1Ctqr2+25s+nFF182N
s3DMAYlp9FDR+58vD9dXz0L59rTRo71UZHh4TOxuySwszl4W7eyjIo8D/9dw
tyFNRlEAx7d8S5eC9SlKkeZcybCUKJvaM1PLnGTWGqhIJig6nS/gzBfKXK7Z
ltVyYjNaI2Y0lVlaTU08YCK2LMuMVFRQ8q3M+ci9ZuWsO6iPvy+HyzlfL/++
psJWDCJWSpRtlqZCWMM5dQoMSmEGVzhH9h3XlZt0BcMGX61rJDZHlYh8yjEE
tXvtFc/TVO97z3FjAYYvTvzvjQs01dBpHWhLweCEMiPXiJm+N1jFYgypynJ2
zCJNTcSIQo8kYsgxRWmmiHsUmkQ4jsFZbt7O+EZTtaalGmswBoO0+FM08SLD
m1fDw+BrX+dUE+fclloSuBg8DDsLPJbIPYKy6kd2Y3goFDy2E//UapSTbhjG
5s6OHnL0KYYaGx5swcA5uFGXR7xth7/+gh3BMedfnWPE9rYfF2dXEfjL+Ub9
Mk2F1wfKlyYRbF2RCwaJ2fE9bPMoAhkvUrJO/I6z3JH/EYHC4p0Zb6Op0ayX
sDqAgGXwCS0i9s3ghDx7hWBKdae+gRg39+lkPQjefGjenCGWxIbHrbc7/tXE
ubqs0FT14enaTjOC9PIT9zjEAUbRSJkJgYqfKE0n7j8gCLPrEZgUSU2XiRds
Vek9OgSMay+KdI4eiCRYXqFFkHY386mVePlzcgtTRd7/9Tl7mpibZ7T0ViHg
FpxhrxHnutm6r1Yg2KfhP3Gnacq6ZuiOLkNgGcq17nL4lp/FRYag2zpfyCMW
Boy09OeT+RFNj8KIr3vt0SslCNz/tGWdJObeL1DHZiBIdWJ2OHoqLtwAmXsa
gsjkWm0a8SmmKcWajGB8f/ZmNrG08jylPoegZrASFxJvbrT6xZ9G8Fs7UVpC
PPaawfAUInD1KFVfIqYjOibfxiAYHhAHOvow4tbwrpsCBKCSiR39mKNFqC4h
DMH/vszMv77MX/H9h4U=
        "]]},
      Annotation[#, "Charting`Private`Tag$1995859#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0.85], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJwU13c8lV8YAHBJQkqJEiqyZUUhqUNJpZJEJKnMkoiU0TBSCBlFZWdE9ibk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        "]]},
      Annotation[#, "Charting`Private`Tag$1995889#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0.85], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJwU2Hc4lW0YAHAZCUlGSgpZlT4kpFSeZJaRkh2RUZRVScrekpkR2Tt7Zrvt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        "]]},
      Annotation[#, "Charting`Private`Tag$1995919#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0.85], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJwU2Xc8lW8UAHBKUSGlX6SSURGalJIcpELDSBqEZBVlFFGSlZVQRkpDVvbe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        "]]},
      Annotation[#, "Charting`Private`Tag$1995949#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0.85], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJwc13k8lU8XAHApylKpJGkXKSF7JTqIiiTZkqRIClmiyJIkRMmSfcm+k313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        "]]},
      Annotation[#, "Charting`Private`Tag$1995979#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
       0.3]], LineBox[CompressedData["
1:eJwc2Hk8VF8bAHBJJVtCSEISCqWylOiQJdmyhWxJklREJUkUJVSyJ1oUpWTL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        "]]},
      Annotation[#, "Charting`Private`Tag$1996009#1"]& ]}, {}}, 
   {PointSize[0.025], PointBox[{-1, 0}]}},
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"Re L\"", TraditionalForm], 
    FormBox["\"Im L\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  Background->RGBColor[0.95, 0.95, 0.95],
  BaseStyle->{FontFamily -> "Gill Sans", FontSize -> 14},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->{
    GrayLevel[0]},
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None},
  PlotLabel->None,
  PlotRange->{{-2, 7}, {-5, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{{{-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {1, ""}, {2, 
      FormBox["2", TraditionalForm]}, {3, ""}, {4, 
      FormBox["4", TraditionalForm]}, {5, ""}, {6, 
      FormBox["6", TraditionalForm]}, {7, ""}}, {{-5, 
      FormBox[
       RowBox[{"-", "5"}], TraditionalForm]}, {-4, ""}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, ""}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.673554253931176*^9, 3.673554293371852*^9}, {
   3.6735544361969967`*^9, 3.673554452878427*^9}, {3.673564410491248*^9, 
   3.6735644580821867`*^9}, 3.673566869464757*^9, {3.673566913255621*^9, 
   3.673566953347035*^9}, 3.673570092169779*^9, 3.673572298434238*^9, 
   3.673582929411977*^9, 3.673583446662382*^9, 3.673583646811037*^9, {
   3.673583679035789*^9, 3.673583692016286*^9}, {3.673583730388134*^9, 
   3.6735837481519737`*^9}, 3.673583810501549*^9, {3.673583851894165*^9, 
   3.6735839269858503`*^9}, {3.6735839604523373`*^9, 3.673584001921579*^9}, 
   3.673584151542906*^9, 3.673664567569066*^9, 3.673664762084269*^9, 
   3.673665445422632*^9, 3.673665481976508*^9, 3.673726070868679*^9, 
   3.6757318785304813`*^9, 3.7938431185362663`*^9, 3.793843269631983*^9, 
   3.823229795414414*^9},
 CellLabel->
  "Out[3481]=",ExpressionUUID->"1bcb1886-b069-41fa-aa5f-864e4d8f6605"]
}, Open  ]],

Cell["Export data.", "Text",
 CellChangeTimes->{{3.673555010205069*^9, 3.673555027514174*^9}, {
  3.673572957665414*^9, 3.673572968054578*^9}, {3.793843187069776*^9, 
  3.7938431885572987`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"311c8c65-e067-41f8-930d-b951ad414e25"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<firstOrderUncertainDelay1.pdf\>\"", ",", "plotAll", ",", 
      "\"\<PDF\>\""}], "]"}], ";"}], " ", "\[IndentingNewLine]", "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.673584110543948*^9, 3.6735841429521027`*^9}, {
  3.673659435256353*^9, 3.673659438289852*^9}, {3.6737260439338303`*^9, 
  3.67372604849303*^9}, {3.675731867458809*^9, 3.675731869762493*^9}, {
  3.79384317066406*^9, 3.793843179447585*^9}},
 CellLabel->
  "In[3482]:=",ExpressionUUID->"8acc12c7-4bbe-4fd8-bf42-ba4bc93a29bb"],

Cell["Find maximum gain for a known fixed time delay.", "Text",
 CellChangeTimes->{{3.673555010205069*^9, 3.673555027514174*^9}, {
  3.673572957665414*^9, 3.673572968054578*^9}, {3.79384325231355*^9, 
  3.793843261381453*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"33f1c7f3-76d0-4705-9451-f9ed9b43c34b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"kstar", "=", 
   SqrtBox[
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Omega]", " ", "\[Tau]"}], ")"}], "2"]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Tan", "[", 
         FractionBox[
          RowBox[{"\[Omega]", " ", 
           SubscriptBox["t", "max"]}], "2"], "]"}], "+", 
        RowBox[{"\[Omega]", " ", "\[Tau]"}]}], "\[Equal]", "0"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox["t", "max"], "\[Rule]", "0.1"}], ",", 
        RowBox[{"\[Tau]", "\[Rule]", "1"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Omega]", ",", "32"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.673570098790743*^9, 3.6735703030147333`*^9}, {
  3.673570580169901*^9, 3.6735705826159487`*^9}, {3.673570637225788*^9, 
  3.673570666933172*^9}, {3.673570749227146*^9, 3.673570749905622*^9}, {
  3.673571048592833*^9, 3.673571049982833*^9}, {3.673572813891088*^9, 
  3.673572888676702*^9}, {3.6735743128860283`*^9, 3.673574318644696*^9}, {
  3.673664749680347*^9, 3.673664750743638*^9}},
 CellLabel->
  "In[3483]:=",ExpressionUUID->"588b491e-2e4c-4cc4-a83e-b899ac64ae44"],

Cell[BoxData[
 RowBox[{"\[Omega]", "\[Rule]", "32.039944765208304`"}]], "Output",
 CellChangeTimes->{{3.673570553986166*^9, 3.673570591762567*^9}, {
   3.673570639063458*^9, 3.6735706674808483`*^9}, 3.6735707507995243`*^9, 
   3.6735710539298687`*^9, 3.673572298563465*^9, {3.673572822792974*^9, 
   3.6735728892194557`*^9}, {3.6735743143280373`*^9, 3.673574319149629*^9}, 
   3.673582929542266*^9, 3.673583446941749*^9, 3.673584002003839*^9, 
   3.673584152073024*^9, 3.673664567676527*^9, 3.673664762211821*^9, 
   3.673665445652461*^9, 3.6736654821235647`*^9, 3.673726071528552*^9, 
   3.6757318787487392`*^9, 3.793843118648457*^9, 3.7938432696714363`*^9, 
   3.823229795549604*^9},
 CellLabel->
  "Out[3484]=",ExpressionUUID->"9a8c9670-51a8-4624-a954-84a3b86cc8e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kmax", "=", 
  RowBox[{"N", "[", 
   RowBox[{"kstar", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Tau]", "\[Rule]", "1"}], ",", "sol"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.673570672467958*^9, 3.6735707125472107`*^9}, {
  3.673570754377459*^9, 3.673570778688843*^9}},
 CellLabel->
  "In[3485]:=",ExpressionUUID->"a6dbd9fd-41ca-4710-938a-8526d1d840cf"],

Cell[BoxData["32.05554648664719`"], "Output",
 CellChangeTimes->{{3.673570758876254*^9, 3.673570784827973*^9}, 
   3.673571057535214*^9, 3.673572298630364*^9, 3.673574323510798*^9, 
   3.6735829296077223`*^9, 3.673583446976074*^9, 3.6735840020699797`*^9, 
   3.6735841521390333`*^9, 3.673664567748465*^9, 3.673664762275359*^9, 
   3.673665445728015*^9, 3.6736654822007113`*^9, 3.673726071591563*^9, 
   3.675731878801176*^9, 3.793843118678914*^9, 3.793843269678453*^9, 
   3.8232297955560493`*^9},
 CellLabel->
  "Out[3485]=",ExpressionUUID->"c93ba2ea-970d-4603-8154-c3c3215afae8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{
    RowBox[{"TransferFunctionModel", "[", 
     RowBox[{"t0", ",", "s"}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ysol", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{
     RowBox[{"sys", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox["t", "max"], "\[Rule]", "0.1"}], ",", 
        RowBox[{"\[Tau]", "\[Rule]", "1"}], ",", 
        RowBox[{"k", "\[Rule]", "kmax"}]}], "}"}]}], ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"ysol", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "3"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.673570797769162*^9, 3.673570947716584*^9}, 
   3.67357098677033*^9, {3.673572284019228*^9, 3.673572287505184*^9}, {
   3.673572365603546*^9, 3.673572368967828*^9}, {3.673572403927539*^9, 
   3.673572558547455*^9}, {3.673572636102426*^9, 3.6735727124890347`*^9}, {
   3.673573748203878*^9, 3.673573753842849*^9}, {3.673573974271983*^9, 
   3.6735739984356728`*^9}, {3.673574335456753*^9, 3.673574420977027*^9}, 
   3.673664752104253*^9},
 CellLabel->
  "In[3486]:=",ExpressionUUID->"86db71b8-cab1-4c99-a1d0-57a140c6819b"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJxEunc81f///28lpWSliEpRKkmlRHI7IqOsolJJSEulpT1okhFJZSWj7Hls
4mlG9t7jWOfYI7Kd831+Lpff7/X2j8v18jzP++N+vz8ez3PuV4ek5a0TlzjY
2NgecbGx/d/vo5f6qrL7T6qy/X8/XOpitztEFfD/897vXn4Johr/8bGyBuo3
UeP/+LTVdKaHqNV/3LbLQd1V1PY/Dlht8M5J9M1//JInYet7Uc//eLvWR0fq
7f9x9dtb/S2F/2MpTtlIuQef/+Pfiz/kaqu//McrJr7s2+Di/R97tT1RT2L6
/8dq4md+tJ/8/h8PnFVcwhP9P14/9Phi9M6A//jWtf3SbK3/Y0Gr2LCfB4L+
Y5MzgbFj4z/+49EW4+VBYj//43dmPJeM1P/HCRdviSV7/o/5bA69faoY8h8X
vGo6y/089D82XeKalPLzf/zXgcJ/rfx/vNE1tKBkQ9h//OzrffmPuf9jIbFt
zocH/8cRfq29E0Lh/3FDoLrvqUv/Yxup6X9LP/yPuUIjDNOSwxERpttZs+M5
fLeZRVp3hGNmNb9B3ZOP2BMlwC3OEwH+0DNR9HBf/JErMC+Tj0DayBpH4aEg
mMc/ynhxJgJupjqHyjnC4JrccbszIgJLvAivt2vi0Zcd3RKiF4nr53wDTqpl
wL9OJ373pyg81F1rGlxQCF7WS1Ot9bHYtyDybBOzDl7XTpvJasZCXtLIneJX
D6laWXMBm1h8zdAxPKHcANXwhostmbEItK1tMHzQiLTwL0kpcnFI/WsplT7c
jGGjoV/HyuNgPvM0UrW5AyfDvpbcW0nFjydy3rx1PZA+PtKX55yIynxf4+8e
IxCz01K+EpgI9kXTuTT6CPijA5yXpyRikvrqTZnyKOZ4jOSOdyVCJPC8dkfX
KCqzU+61H0jCKw3PilPeY3gi/5I505uEZ/KRPE/7xlG+SlhYjpKCaOHN6yXe
TCLv0M1LVSdToCYeqJsWPYnU67+Tba+nIM2pf+p4wySCCx+dyfiSgnhj9uxH
2//hkV2bv/ZwCgaOfJf1q/yHTaMh2y76pIKTsY2qLD6Nh+VK8JpMw5d1NZPF
UbPgk0vq/cOTjkJDHZcDVbP44SrvMi+eDmY119ZD/2ZRpbu1yexIOuqbHUJ5
Veawo0T4nvSXdHyP+v6NyJ9DR+FoCFUxA8ry/wI+5s7jwdbrej3HMiBxuoX/
IW0eKxzoE6vNMzDw+pnj5OI8lDTbKI8dMxDV/6ciRXEBn/KLm9GUgSVl4m8s
QhaglfOTr+zJL7BFN4Yb3F5E+0bJJOaHX4gyX78j02ERtvZ+5+SDf6GdoCbn
+S8iEJ/CPpX8Qn2L7E6/kkXMZ9ofPiueCWfngjPPNjLhIbHQ5yyfCbMbQ6MJ
CkzIPH/olqmRiVnRRf632kycVLFp3XgzEw2u3AqTNkzEpp97wMjMhI+qXNbS
FCY0xRrERaszwfdb7cbKIiZaH5/IO0rPxHuqsXR0IxPLlHT4Y/iyMGhkPpM+
w8TFlP0RtheyEGQ+TRNQYGFOhGoYci8LCToLP/vVWHB/sHO6wSELvhbf/p0z
YCFzn5TGwbgsmN09Zct/jYU1iQLt7OwE7jZnRaV/ZcHUZd64R4TAq4Mrq7SD
WQiy6i35LUug4PCPi+YxLMiuTktzNiEQqGEmJZvHwt3hIHkbGwJXrWue0EpZ
SClwCTV8QyDVZZ/7+noWDj8w/7w6jsCfKX3tAwwWHPWPrpgpIGDYbyUkPMpC
2RaF180tBBasl448nmJBkCUx92ucgHao4dC1RRaiBl+nVnBmg5dfVuAvOxul
vGFmIpsvGw2nRE9McrFRxvNu7qKKZsMUs7kZS9kownFd1sFS2djkUnNTezkb
Zb/f6RDPXdnoiYgx9VnBRjnjWNr5VjkbLolu3vF8bJRntmoSD49kQ/nmE7kP
/GwUf/Nkk6uG2aBo3JGWF2Sj5Oju8DxzLhsbjO87fhVio/QcCKg4ejkbbpbv
LPKF2Sjc0qt5Ve5k4wEtKD15NRtlm4CT5s5n2RjrL/xmI8JG0V1kvlzvkA1t
zXHhIZJt+u9lrvLIBvOK6PZda9goH+v6Zti+ZSP/hhJDkeTEnPMKf0Oz8UxC
5xQ3yfXR1be6qdlQGVF96UPeP+utFVmbmQ095qq7k+R64u9+0QuKsrF9bdwe
YZJV7+7elFKTDft4gbJZMl8Ls5DzYe3Z2DkofewnWc+bo+u8vfuzof6xNVlE
gI0Sst+91mkyG0vXSYnpr2Kj/Nm0hP8ZKxujEf0vjq1kowzxPTl2c3kOgvlE
R/l42Sh88yPvzFbngJnlZ+vFw0bZzbiYa7AxB3y086J9S9goDwg9pT37czCb
eqMygcWCd2Su7Wa1HHTH7tGdmWHh11fFOGHdHHzgCTr5Z5wF9tuSW6ctctC4
+oO5QBcLUqZfLPtu5KAo0+W9YxMLmtq8/k0Pc9BZoOLmUsmCy8Z/wr9cc7D4
Z9buYCYLMSusDaO9csBx77UHncpC1Uy7s38wGV+0pHJ9GAsiVUUcL9Ny0Pr1
2gbFjywoZR5SvZufA5Gl0qfXvCXPezj18cWKHPwOurLs7SMWAl/6jR3pzUGe
4G7ZZWYs5N8UkFUcy0HVwWX5GwxZoJ95d0VmnoynzCudTz5fsntuty8XyEVC
n/DH5M0sJHepl1ao5IL3zp39Gl1M1Gu/HHfVygV3wrVaiSompmKyRHRP5MJl
QHTiPcGE4lMli6IrueBSe74g6stEqtCuqWwP8nqWnsY6PSYaH99YZ/ctF4v5
c0NOB5iY6QinHArLRQtrSYTrZiYOREk5p2XmYlqIHqE7s4g0DbGN1L5cFMvw
l1D9FtEccfrI7YlcHJ7hEMt8s4g5/s/WcsxcGM7e4z93YxHKbauSIoTyoK6y
99AJ5UWk319yNFg1D2VhU467qhbwK2TsnqdnHrp8xHN0B+fRukLO+8T3PLxT
DA+rKp3Hwt3rWfwReSgqD3WZjp7HIdB5XIk8TPAVX9xxax5ZDS3f3g7k4eC2
2bFTw3MgeAoLH1Dy4d/2xa+paRa51t/WnRnKR07wG5/zz6aR0H/9utlUPrj5
vNdIn57Gj6vKGRfZCmCkwVv7a/c03l5uOGsjXAAFtnI+C/oUtC0FfF6rFODF
OgFvL70pVJx5uzbGpQBV30d+Bgv/Q6v2zdWcO38j81FfppjLX/zbcmhV9M1C
GNhGC0bFDEC163Ch06NCRAvpF/YYD+DdN227q68LEaVreYAy3w8RYePRzd6F
0AmRmb6q3Y/97NcrfPILYXSP40xBDwOPWrzcHNcVYXbd6NO8rb1YcJtcZfWn
CB7vGnM5KzqgcWyuUK22CFd91LKv7OyACzeb/YaOIhjeXXch3KUdEs95x5on
i8DfrKXQqNcGVetNlcc3/oHua9H2yy3NsNMwdMfDP3j25rTSma314JiN5F8n
XYzWtvO58kdKsK7s8AR2FeMUe5p79LliKAQ21VkpFaMn9uT6H7Z/cElnqW+M
XjHqJleMisQUosjbUvrwg2I0PHhTmoZ8dN6cXXrFvhgnN2/0irTOw5ya+4Cz
UzGs7PWrjnjlQnYgM7bOvxjXjvlS3s+T73vKosrXCotBjxzTzSrIQBhfnPiH
qmJ8bJLfYKiVjuwuTRa1pRi/uDQk35an4q+Tbf7CaDGMvx/5xhxOwqmWCn33
tSUIHJXW2HU3DuLP3l1MuVaC0e4HDzrP+WCfoYRm670SLFynME+0fIa+VKIM
+4sSfC9yvWFx7yPsSjuHj3qUIP3gLd7XLS/RJX7oUXt6CV7wNUg8+/2UmB+r
OctZUIITzZ8r2o3fEsIF1odkKkpgueXx4+RPLoTmTS+Ou90lYO5z55NT+UyE
Z064LFlRCteL8tZqUwFE7kenW9tFSvGCm8N06noQ0XxJ8oTBxlJ83dtsFVEb
TKzgM1jjrVCK+1uUwkZehBDSXb2zmaqliN4XsP1WdiihmvystUu7FA4FWqcq
JsOI22YRgbLnS6EXfr5OcH8k8X6P2pvjV0rR8vI4X//hKCKIu/HygzulWPDm
+fXmcDSR3myj4/u0FLN3jCVpCjFETcwS2ey3pTBcXFX7TzSWGHrlx9frVgrp
bUsys8djCa7Te8eX+ZTi+e5+3vVmccR+lnmyUUwpqvY+Pe0tHE/o6mW/OpJa
it2TbrePWsUTF303GCjmlkLKu831Q3Q88aT/xbptpSSrp++2Gosn3BXbGWL1
pah578hVLEslQt4eSlxBK0XsueLaLEsq8avGz57ZXwrLNQlf1DyoRLXkgu7Y
RCn2SWtbHc+gEv23zol2LZbCmW7yfLiNSrBlpffWLC3Dt5q7WqvnqITICjFq
gUAZBL3r9IpWJRCyZx+/SFlXhqZ9V9S4NyQQh8Maj4ZLlyFvbdhM+dYEwmRK
cY3vrjKoqobe2rQ9gbil8bXbRakMPPpThWxbEoh3HlOxL9TL0Jb6Tdt6XQLh
Rzv57LZeGZTq+c0uLE8gqHJJ2pany8Bi3+RD+0slip4Jrza2KINc+lTCSC2V
aC++13nkehkm5nY7OsVRiX9ra6IV75eB3Y9LNOktlVhxZc+TbXZlOMf20PWW
MZXYlPRRc937MmS/TN6dIU4lDnCOC678VAZzkZUPvdvjCf3jhh1MvzK4BdRN
8PrEE1bfYyPHQspgrHr7orBBPPF0mO9RV1wZZrz2hyQuxhEeB200atPL4KRw
O2fkZxwR9r6M/3d+GX4Rmh35WnFEVoNsW0p5GTkP2n67+zuWqJV2CQ9vJFlS
dum3sRiCPffoYdehMvJJznUsWR9NrOWP4LObIvNTp7c3b4oi5MyWtdxmK0fR
+xiVw2KRxNm5wnvGwuWwVTZI2NNNnk/trRTN9eV4fqjc6E9iKOHw5d2KAzLl
8FsWx1vzOIRI3HPk5zqVcuwPXv73fHswUWz/485KzXK0cZiMjDwPImjlnKos
g3I4xbz6JigQSKy8nlvfdbEcJc8f+lyT8iMuB4MnwrkcS7Yv3/ON8wPxbNy/
1vdzOQ5eZZtTnnlHfAIzwPV7OS6791CiH9kR2S2/lO4klIPn4sr1ZQ/2E6LC
ytcPtJTDw3rhcqevG+QtvRW395bDPnT5wHYhT2jGzXCKj5Lrf86u7Lvlhbu6
KX4sjgr8+Gq/Ly8lAKVvFMp/b6/AOhOfQ1KHI6C8qoTj474KlJ++oL5zJgph
3haK5ygVGOffEeKQEYvXMR8CRk9WILFUgj6WSIVyY9/dtS/J+zn2xDyMT0XY
jm9rrBsqcGPOUqh2KBciyXt1FboqMOegbbyuLA9vKMX2zKEK2MXXqp+Py0dc
xLytDnslpHs5XqTY/YYzIdPeJlKJwd/+iyvUinG4/1Uc9+FK/L20Vme1VBUe
y5UXX9eqBKfJBef7EVWIuyfaW6lbiU/w9RDbU431zFhR39OViNNg7N98pAaz
gm2vdt2sROSRzALicR3iVBRPmnhV4oyucfVH0WZscB+cDR+pRMXGD9wBy7uQ
ZWEXTp2oxDcTPaqNSRfM9gqdyZiphO/x3YOuIV3wq1dOLeWoQvZ3KYVk9W6s
lXB6MCpSBcGY6xwPX/ZAMEJmQgFVeNgjzzPPw8CS/EtDhFsVPLuWqLUqDeHH
51nfIs8qWLn4GDe6DkHjiuuxKu8qSOmnT3R3DuHV8qSIruAqiPry2ks6DYNp
yHVtSWoVSu0GHs03j2CmLaj3KK0KawQP9e7IGsPgdEd7nXw1wk+mcH86PYHk
K265R/eTXLDm5L/XE7BvUA0hDlaDb0thkVLcBERSvt0M16zGvgqDhYs8k6R/
nFt4ZloNqyVCpaIpk/CZrBeVcqyGbvmE3NiKKVyyerfo5VqNq4ylCa37pyBf
u69z5adqtKuUaH01n8LvBM+w6W/V6B5J/nMnYQrjd08oliRUw2LdFxefU9PQ
Hi8zvttRjZ7nspoJH2cgZPH8AKOnGrG7Wt3+psygvVJW3HSgGmJbv6kOt83A
Ns65+8i/apgHbb7Av20W32/p3BXlrYFjWtbW0YxZTA3nu2Xvr4Hvv2UhkjVz
yDlve2+fSg3sfal9Xybn4FK2+XSEWg0OqM42JK+ex6boV+s9dWvguUy34++p
eejdoERfsayBc4KRkFrdPH4MZBTzfagB69PN39bZC7D5arDZ+lMNHs7muvu2
LEBRo/tpgVcNLhxIvHRjagHF35bvfBZcg2OhUbKD2xcxbnjGrT+1Btvpsyna
buR8uDjE0MiqQV/WAb1LoYt4E2FPCcirQdkNurw4sYi1XGHjp8prYJ1jqnJq
eBGqKVNG+d01eDPafqlfgwkeK6eoDf01uKLjaP77DBPV/OuXPB2pwZkaevAB
0ocvWR9J3j1Lrv9+JL35MxMuEp5rv/PVYofR18olNCZOFW+9MydUizudR4Ke
jzOx4WHGn5OitegTnX/0joMFamXXkxVStdAdTtLXIefxpte72x4r1UJsemL2
3QXSZ+UL9tWp1mJ/9uShJzdZuNFm8kFeoxYjcV9555+wwKZoD4Z+LYb+rskL
9mShuFvI67BxLXjGMyaLA1j45B469u0MeV3FEy+iWNgyUB5obFWLB5eNah1y
WRj7YjkXe41c33aLfRvpw+nqUyd4b9UiLnj5sizSh/W+SXDlPq7Fvqs6Puv7
ST85Gm8qYVdL1sm1wZ/0IdqURtKjN7VQGfvyOHSWBVvDG5d3udVi5kXh5R2k
76ousrKcPGtRIj8j94L03aURn9bQvWux65Lg48+k71ae2npb7Xstvjhx7rpD
+psPZ0aR349aCCleVhEg/dYqTl9yJrwW5sGvPtwnfVDufNdjo9haJIsaCPuT
Pjuz7EF1TCJZj8ntLCfSN3OSl+1Ynl6LsD4lu4Nr2ShOF7+9vkTUIiIs8mic
KBvFmH93a3Z+LZS2XxXpF2OjrM/MVxAvrkXvrz9NvevYKH3XTFwfVtTilVyL
a4g4G4UqMtRbXVsL7UOndu6QYKM8zbNTlWuuxZ4vwYn3SNa4LfT1fUctYn83
S9qTzCcROtrTU4sYyVxbQ5Ipp163dffXYlHFuW6YjHfX7UJJ10gtElupE6dI
/lF0MK1zohZFesxqZ3L9eva1obSZWrwUevTIhcyP5+CkZ8diLU6H3xowIfNX
tq181c5RB0eVx/LjpG/fiI663ba0DlbnbxqdJOv3pzuata6oQ8z9m+ffkv2p
3HBJt0WgDgcPCp99SfaP44yacrNIHe50S57SIfur4CEh07SuDq+euVxoI/t/
uWR2dePGOlRVur49RPqzF1c9Z4N0HTimgxqvkf5cfIg6Xre9DkLNztaWpD/L
xVmX1SjUYfywlvydRRbM+zUzqpXq0JqkmCE7xYLHps3hVap1aA79a/1yhIUp
z5Y3Fdp1KDd7MD/VxoJMecrdcr068OZVqa+tY+HsUk/zshN1kBYRs68pYSHr
sa5KiWkdHuR2Z61NJc8rVWZ7sUUdKvOKVYKjWdg0xLX2z+U6zCZd/lkUxMI7
s8yJ37frcC3jg3avM3l+1eUic9/U4WU8o/XmGRZePFvunfO+Dj3550MajrEQ
l0R/l/2BrG/kYVb7IRaEZb5bZnmR/cy3Vf69kUX6I79YehTZby6ld1ykH/Np
Di1Niyf7t9Kz0ZL0Y4pd0b+U5Dpwiwo+tMhm4se4fVVSdh0sAzrV1b4xcaN+
3DG+tg4/KCv1v55gwn9V+YO4pjqER5/dxAUmKrUjrGLb69Avf6ZOeAcTChmW
lOi+OtQk5pVs5mBi4XvNdNhCHQaX/ZXmjlqEy7WkywFS9aB6NkieHF3AACXa
kXd7PQYVuvrW1S5Aa+3PiAe76rE2c02GfeoCOAo9R3SV6/Ha0jB2q/0CHkvZ
Ppg1qMfHxIJUdt4FXO7Y8+7E03rs0bmkELJqHmon435yVdfD+fI+z30tM/CX
DSu81VAPzh/PUx4nzWCBM6C/ubUeW92i9j5xm0Eq1W1nPKMezOuaXxMPz0CO
/1bS+cV6qOQWrpULmYZ4yc6CZJkGBCgLqu+xnMIUJbLnql0DViqt781LnsCv
H4O+D980YGd92hThOoFXPLJG7943gLlBfkuQ1QT4KqNygj81oCMzb1FccAJb
LsT4t4c2oKvG33nZjb849TzexLiyAU2SQ5Gh4uNISksphWQjSqt99aPHhvBE
Yua1/pZGFPOc2X/QbwiUlwcOnt/RiGSuzh+NWkMo1U4Lf7KvETUPa5yPfh9E
T0P6uySdRpyQ1/E6YjAA4alMyo67jZDb3F5pk8SA7Z78RJG8Rhi5lHxcHt6F
ywobAz4WNaLe4aget3EXTPY/c15RTjLHYIgFqxMHlRUsOZoa4ZzyS0rtdCc4
Dv9YNTLSCLEfNxX6eGlwO/7GukCsCU4dqwcZq1tgb0Q7SdnYhHfKI3FiT5px
96SKWoZ0E3YbXDE409GEU2cm18TLN4GNOx0rohshbmFV4KfZhNODbuq/T9Yj
4rbGRtu7TbjTuoHvLDmX+N0N4B192IRbVWMtZ05XwdV2Yera8yaktBoeiaio
xO1HiWUXHJuQTPBGeDtWQNFe6ukx/yZkbu7ctuJZCfLduOo3FZOvt3MM3zic
h+SP5jnfKppQUycVk8eTh7BPv6LW1jVB0mcu4fnWXDh/tX3NR2vCd4XCbcdt
snHie4/83L8mGF+UjzuhkY6OmHznKslmGC/Nsov7HoXKYa6hPVubMaoTkq01
FI5s2SO6nrLN2NJctX+fZigCIgpWnFZsRveYKOXCpiBYhvx2bdVtxrGKSOvu
eXec6OUeOXSiGZbGG0sXWh2hLqWl//10M9RuuUV8mLCDVFAhn6VlMxy6Hw6Y
6h8m6N+K3BgPm6E47/1L38ydqG/lGdN+3ozkhMgK7uWeROE6HcOIV82QFPvb
wOP9lQjz/sN/07UZHjd1T7wx9ye8GpfdKfdohuFS5tHLpQHE+zVHq3Z5NUNq
SbES80wQYf25+OPfIDI/7pgmU52fxNna5X+NwprJ90e9w3yRIcQxoWMnkqKb
UfjoM4OHGUrIfiwRfJTajBeaQaMJDyMI8Uree02ZzbjtxHvxhH8ksWKVbo1y
XjN4nk4qiCRHEcMupZ8Wy5pRftEufSQ1hmgvWTFpVkPWR02hTQbHEuXL9Yyz
G5vBmevwk51C+piOa6JkezOyzga3vw+JI2Icy4Rfd5PxvTfLui+JJ/wLV97v
6WuGXs7nVoHz8YQbt37dkZFmlE5k3F9B+rb9kQ/7QieawSHDSHj+L564/ab8
M89sM/x/cjhd3E8lzPP4pq4xm5H/4Jvkr1tU4jiHwakSzhbEFo83vw2kEofV
3JJll7WAqj6gS5RQiT32FSIf+FqQt136yJUR0k+JVQ9HhVrg8epf4bNlCYQQ
06DBULQFqpMW/CzxBILrkLsidX0L1rhLug/LJBCTTyu/Ckm1wMH0y6jWzgSi
J51/xnZbCxSiC1bykb5dN2toUi/Xgu8q+mwU0s9/H/iYqqjQgiscpkLtKxKI
5IdVa72VWmCd7f2nj/TrkGSBx3OqLSigbGw1r6ISX/8dbzqn0QJRXFTWCqMS
jgoeSpk6ZPzpdcu/PaQSj+5Ve683aMFOo92hF0ElrlIF5+yMWxBxwzfajxVP
nBk/cbbzTAt4lQo4jqbGE0flP6UfvtCCb/s5Ym5eiyeUb9WI/bBqwf4/IkPL
hOKJ7TFCT5dYtyC5wVheMimOEBs2arl8i+zPt7dSyQZxxLx1re+2Jy2IKtIN
/dMaQxjvP/9Rzo7kW3+ZG6eiiSh2+ru9b1rQvFAp+YwjmjDzmr5z6EMLDCSi
Np2ajCBSLtpfOfypBborpmY6m8IJ/l3Lzmt5tUDya5STMzWMyCkQ0z4e1AJt
eTXdk4dCCLGPwYdOhbbgctDT+TejP4i7prJ7z0W1YHLLBatxz2BCauLQ+kvJ
LdjV+Ks6KC2AcNhoMfmouAXXcwwP1NV7ErTB/v7nFS3QlLmhyH7nI3Eg5W7H
q9oWZNg+5H7V40wM6L0pdmlvwcEmlQCj8CeE3tPQgIC/LXitxFBXF32FEE35
Lz+nWyDCf1/ui40TmAJpzhELLZCYsdi24clHxIUVP0jkbsWqpbrjzVo+EKof
1i0Sa8VHH+NTR+xDcCPwweGyDa3gTfhlnTEZhvwbLMVqqVacfnd4sdo2Eg84
BTa3ypH3q4761hyLQ5O8wuzo4Vb8flQhtyIhCd+dn/xcc70VcYoCxokF2Zg5
xekrfrsVlGqfyVNuOTDc5OIueb8V44IfH/qcywVH2renO+zI+D/zhkfn83CJ
nn0cn1ox8YrlqH6uEDvUljIvZ7Ti5cyJwkq3ctKvI7c2ZreC66LhrhufK6Ag
bHhc5zfJsv2HWvQrocLw+rGjqhX+5Quvxc9VQd91+7Exeiv2/DXUWfm6Bneb
9LweC7bhYpVw4LqVjUi747nH5VobqjmXHuz+R4NWkOSV+DXt8HOU2OLZOwgF
L74tv8Xb4cL55Ymm8hA2fpjvaZZsx601DRPL3YYw97jOkku2HQHuF3JzDgwj
+vh7s9OUdmzYm58R4TICIfbxk4tX26FlP/1Qw2cMHReyNXTS2/HILjwjXXkC
pSejOc2Idjx0s/i9ify8Tj3mk3s3vx2MlVez7pCf5x6KthS/8nYYlA/pZHdM
4MgqGZXRrnYo6I5kcryeRGSW297PvB14t/HoasW8f3gocWFTp2kHLmzx3Gq2
eQaWhvKnWi06EGTy6dKM5gz0X7M7NVzugOMQbaup9Qy29AePl93uQPmPK8XP
4mZQm9iXnf6mA4vVl4qXK89CXvfuBc+oDkwtPfoiQG0O4nbqn9ziO6C/pnbQ
xmIOS6nChU7JHejNlP8zaz+H9jUpci+zO9At9zBfjSD9tXt+8WZtBxSaUqlv
D8yj78lbP62FDlg4uRUrS5Dz16kdVwPZaDjy9eqSRwcWYD4mxLGBkwaVcxmq
l40WcGxz7z4xHhruR0byGzkuYNN7h2/8gjTsUP96xnRkAV6bbit+EKYhUr4m
aNXSRfD9MqniXUOD3/iTXpsNi5gd2bZkqTgNh3Vn5uUMFlFpXHpjUZqGWr8T
pj8jFqE5ksj9VIaGjsgho7DsRfxy+BYws50GT6sdeSfqFxGablM7sYsGpffV
o75sTLzYKKAyoEQDkbFPf9yQicm02borKjRk9FlnS1oxYW3UdatXlYZ1Mj/j
/z1g4uS7hGCaOg3tB5fhnS8TskMneRv0aHh/LbDgEOm3qca6hJMhDY4CXA+a
Sb9Vzzx8T9WIBoXqP8rcnOQ8/2FXy08TGq6fpK9cJsUCfUra7cw5GiSuV2zv
2MvC3Qvi6ivNaDhZLvH4sDoL7+WXRdpeJPNzyByIMSfncW+WmcxlGjazpe5P
sWEhgH1KsPUqDeulby859oyF1OquJ+o2NIyFTAcIfSHj2/46KviYhuVKGwvW
55Px26jMgqc0JJ1+y/W4nIXFI+HUxy9ooC1ULjNtJOOv+SLW+ZrMb3qFdsYA
Gd/OpdzzHdn/f/Zz+ydYkO179Ur7PQ0xL+iXlOdZUE+7NRD7gYYrv6WzB0m/
LZe87H/xI5n/XynLA6QfnXUyPbHGk4YX0t/ua5P+RP97grvkC3ldZ0PPOj7S
/87ppL/wJuM/nPaikv7FzIPNHj8avL8pvlwhxEZ5L7t/E92fhkzdHOdtq9ko
wp9l670DabC3Xh++jPS9gMVNTno/aChy/VwSRfqt7GVRVfZQGqQ/7WAIkr6Y
Ur7qb2I4DYnjweMHSZ88rMgdcjWKhjmOl11bSd8s/75wRjyWhoBDXAn1JJ/l
mVhZGU+D+EU5M23SV+m3+3NeJ9KwK4CgPSP5blPHfcUUGrQDFJVsSV5Uq982
mEZDyKe6K3IkO0aUtvn/osFCxssmkownLJT38QRBg8yDQ8cHyfUDnqYd4c6l
obr18OoRMj/ZntjZtHzy/rqenATSZ1N1Q6JvFtJgnbLeXIWsRz3Jz0KymIZN
NyPmHEifLZf4tLqulAbXDWz+X0ifPfvu/R/HChqOVp00uUr6LH3E7rlKNQ3Z
w/5Ki6vYKHdOP9g9VkvWV+xsdJL02QXiRm9wAw2i4u/Tbi8n85W56H26mYa0
c4S9wf99//7xjB5vGw3xuwWzxznZKN9nDdiJDhoMjsu7n2ZjoyQXq1zb0ktD
iwDFr3WMhcN790o0M2gI64obVO1jocx3W5XrAA236i5rbOtgoeeGiNK/URoW
XnFs+Er66+26FcNhf8nzYiglvy6HhYVDnIGm5Ps0VY11VSaZBaFVYzz5czTw
fi743OHPQnWmk4POIg1rziaVmH8i/fmGNHcFizzv3oM/nzqwIFh8lrOZqxPu
GyYe2ZHPg+DbgsVRvk6IVMa9LlIk799r/uy+QCeEkncnbthG3t81Nzcn1Alf
+w1yQmIsCFDkZ5aIdkKgzci+co4J/nmfv+s2d8Ij3D85NoX00fB9dwKlO8nn
MUdp8icT7iaVo1tkOuHPbn608RMTq5KXDO/e2QnK0o099jakD9+5zdBS7IRE
0sVdFhuYWME40nrvWCfpQ9r2FbcWUfqZdnZWrxODphDTNiH9VeNp0wtDMr7F
dferlEXwBsXVvz/ZCdaxA7bBqxax/Py6qu8XOmGRlqopGLEAnpqxgpJ7nXhe
0WNjVTEPLsI3drNfJz59ktlQSJtFs4qGdod/J36PhLVk/ppFbPoQzSewE9s7
GgWues3ibPIhQcHQTjiqee1s0Z9FfHSHLRu1E/rj32+cTZ2Bmd9m5bbCTjQ7
rN+a/GIaqY8j879MdEJ0bdXHlZ2TuK6Q0bTsWBcaft5b7/pmBNmVdVGpel2Q
YG91Ldg+gtU3x+yuGHahNzZEmatqGMRP6S0FJ7swk5Ft7S8xDKE17nftzbsQ
Y97FcEkZRMasFe/0fdIb/Xf+fDfWB16C71BPQBcScWKXqWM3zM9t4/8U3IVd
p5uuKyh0I2lavVstpAsW24LZLWlduCD/+P33SPI3+3D4b6UuJAR2151N7sLj
gOn702M0nHuTalNV0gXO88lvJntbEaljGZA11YUrKjy+E+E1UJCVVMVsF8oa
QqYnZGqQxUdrIea7cNXpfjh7eDUqa86vyWHrBt+aPo/jUVWYPH/mQ97yboS4
fTfba18B1buGz4rWdyM6yfZeyaEiFBqvEtOR7Ibi3ZVBOuaFMFQsT/mzuRva
GX76lLe/YblwbKJYphtj4l2vo+rz4fBOy7psTzfY1lTQBL1yUOmjalKt2Y1d
qor1Q3tScOb54r8TOt14OuJwIaMkCV0Xfn2qOdaN9H4bxzXWiZiUUq6oNeyG
cBKHlm9KPERj92k2nO3GpVX8R+/vDEfQx8nu0+e7ETho9SU3LQSytgkvGy90
41Nf2paY4z+gqrQ7s8mqG8svu784oPMdlnmyCq023fhgKRv008IZgz8Hq0zv
dGNBx4vCWvEato4Rt9rudUPisEretqr7cNCTiWx/1I3yl9t0OQ5eJKIaNm/q
fNUNTdvCrQKz7sS+9C7C4m03stgvbS++4Elk+QWe73LoRsQO1pPw6K9EpcUG
726XbhxVF4lwZH4j/g2K8dO/dMOjYue7k2k/CM9vjEI/b7K/9w9cG94cQuw1
SLQz8iPr0SqAu10ocYeqN5od2A27FQ/WViyLIPitxEIf/uhGUTVx2uRAJBG7
mmEmF9oNf5rJksLTpC8+si/3jerGK+FdQ3uvxRAu2/XenYjthtbRjNZN52KJ
Ha2iqsuo3fi7Ve/k0Po4otiV/o9I7IZrUZBVqGMccQ0J0Q9SyPjK1z4QA3EE
z7jdpZ3pZH+cD3DtORJPhAbpSvT86sYvzdqdC1/jCU1j0TofohsdHzaGreuO
J3qX0F2O53bDm99H+8MWKvEmharBU9CN7MeXJE5YUonN1+wWsgq74a5+/ual
L1QiV0w38X5xN6pKJFJ/51IJi9K1N2TLuqH3a1WyLYNKsL3o3dxd0Q0/4raJ
DVcC8X0XtcW7uhvbXp39QxVNIFQ7X3wyrCPXYxZeV9uaQLR5HDu2tJHsl7B3
iyjpi8801nJmNZP9vuo5fHBHArFuqifdtq0bNq5XYkMlE4j00Pi7O2jd4Lf9
eeU8fwJx5syL7V1d3TiwOe/z+WkqMbP8WJdXbzdoiYJ/w+pJX/y1xsegrxtC
3r9uUmKoxH6bnuPcg90wkkjZI/2CStRtiF+WOdyNKcVfwSaaVMK26nnOvbFu
xH85ZNrKTSWEXh99vH2CPC+jp+SpRDxBVVizu/NfN7g+Z8m23o4njtO7+77O
dOOrduIXU7F4YuxrXID+fDc2nBgZ3PcrjnDTeW6yhNmNl7VvuqxPxRFlUSJF
dzl7cLNqhwGDEUPcMOu228bdg0c9Wjx+I9EEL3+cIo2nB2ZeF+U20aMInXs6
oXp8Pch9uz8xJzSC6JMSucAl0APu6cAfg3fCCYf6LpEMoR5oec5u4tkZRhQo
PXsnI9qDz52VVNUHPwmrQW3VjnU9aKooL7vB9YPg/LZ66vP6HpzQ2PA+6XUQ
ocYWe4lTqgcvnmibOUT6E5m/OzXa5XpwboPSe20Pd8L0UcyC5+4eCNv8Dml4
+56Y3/Y08ZhCD9q8l15dF/2SUHIVlkpT6oHutjPBKn0aRJKRFqenRg8s7VfU
K/B9hOOx1LfiWj0wdte8pn/nM0zVt/H81OlBzaL7k+ohb3Ds5V2ZrE/ma3dI
wOhLIPQFK0QaTXoQ6AYfkcuR6Ks8tV38Zg+elKpc/+ybioyiwqgft3rg6dBi
ZiiYjg/ZB3btvNuDHrbr8QEfMqAQJ6ag+rAH87NSq1u+ZuGlW/sh85c94NOp
Vqu6nwsx/cvHf3zugaR6AT1B6w+GjzTUyHr14K6EU4nJzmJkH9I+leRD9n9R
ve7e6hJc3rn93O/vZP2l438nh0qRsGLEqi+8B3u+ta5VNa2Ebsn9R7JZPbiR
8m+1mFkt7LTffk+k98Aj1PzTMinS+8yumsr396BuwwmP9UltkLp/TDRqsAe3
Kwjfec12FAcKfAoe68GRJA0q60YHhOe/vfOYI+PN7BSi08g5Jjr55m2+XlSc
kCr4caQblYJ9B2X39+JSYm9zjVofJNuONga/7cWYQ9n7gWPjcMo9GHvSsRcb
9ET60h+N42+o7Lulzr3gYz+47PnPceTe5VO47t6LD2ean1Uxx2HFU+22x7cX
iZuXR32N+4uwvWe0cuJ6oXxk+/yLVZOQc7qS3N7Si+yvMrcFqVP4csvE1b29
F3nH8l3jm6fAMtaxOtzZC2KLI2Ud5zQqN+wQDKH3IrL8WrmO0TTuJI3cvDne
i6Io3dyJsWkk0u5LL3DTcUD30JFXG2ehrPjGU3QPHbcOW3RJ68yj3lJ0/zcF
OgIS5bxpl+dx70NMw0ZFOtbmHWYavJlHVG+jmIwKHRyRSwd1suax3nNn4H5N
Ok5JD134IrcAjvH6aKOzdLBJTIXNsBbgL37DoMGUjnK1ecHItYs4qM0+fvYC
Hc+ML9ks3b0I2+87FCyt6Fh9h8cjw3wRdD379Ns2dOgtvNnD/msRJRHbCl1f
0ZG17KzmOwsmrtZnXRV4S8fknvL9nrZMcHEYL//sQIfyqs3P1B2YUD3zQs/P
hQ71P9JybyKZiFtaUxPxhY7uzPbKl6NM6O69el/Om45z/qdmXVlM9JstilB9
6Vjf0bzkwCoWNiVvPZsWQEfwQwrFaieL9MRntMIIOg7lJ04LXmJB3l3g1bFo
Oo7JtA5x3iXn24yQzRWxdJhMqIy5vWCBW6jqcn0iHdKX3zIekr4VpHqZ52wK
HXmNazVqAlmA9Xx4Wxodpgdf2hdFsfAoR3q4J4uOxSDft3bk/Cs8nP7hag4d
YeHLSyjkfBy/1lB+KI8O0YaSfp9aFgZuPbk3UUQHu1FR0Vo6i3TOVasfltDx
e6usmMoIC5sLfyTPlZH1t+27Mv2PBdP1FbPsNXQIyF3zFuNgo/CJ3k3KqKOj
dSDM4PsSNkqO0Oo79xvpsBE7+5RO+pktX6rsrhY6dHkEucZIP9uy7FxfXxsd
TYHyNRmknzVyMoODaHRMCXXW6AiwUZyYARdMu+l4fFZswpv0M5VZ9XUidDpc
cr5viCL9bHSCXl/RR0eJCftRe9LPgkbee7wfpGOziZ+VyP9939gvq68+Qse1
B74XbUj/4e6pWLY4Rsf73dMqjqQfpbbfLUieoJPPyYO+i6Q/WTetfnl7io4t
IVEX2Em/kqhNVdk+S4fgpZX+5iRXlp+b6Z6nYyn/v4CXJL/6w0z4xqRjp/jt
K1YkK+QH3jrNzsAywuQvD8mMLI0dAlwMhH0y0bhFxvdJY9CLuRnY/7rP4iu5
vm6iU9CbZQxEfjc8/pLMjxmz00x1BQMJY6FiO8n848IrRWf4GAjfU1voQ9Zn
+eNeXbwAA7kO762KyfpXfxf5eF2YgePrjjIzyP4UeafpSq9hYEvKpR+3yP49
8TTl6RBlYOmx2Su9ZH9l3Vh5XuIMHLk8ck5iBRul/X2Q3YkNDFwKnvNcs4yN
4v7myMEVmxhoX/J9Wy25f+p2fVMFUgwM62zdY0Tub5itnI3SdgbUOJYK7iH3
/+ytqm0TsgwoyWRIZg+xsNLatjdqFwPCK3VZNd3/9/eFdNON+xjYNai4+0Ml
C1Jnz69tVmTAe3jJ6n2/Wag3Zqv9pMxAo5lHr2UGCwePah5bSmHgYOQHD+Mf
LIxo9HPnHGbAjK1DTNSLhQC45D45wkAJzzvGJWcWuPZVK40cZcDON6jE+zYL
5RvMZOpOMuB588b4/X0s2Iux93wwYeDogEGygzQLe1f/+K59joHgLVnC0qtZ
8Fo+IPLLnAHGWOx7rgkmLP/dXxJ8nYEGBzF7q3AmhMfW5pjaMNCdmiTd+ZmJ
woGMZyJ3GPhu4OMx/JIJWRr75PsHDFyb+L0m1YSJf8WuXbdfMsC6sqNFip2J
Vt66qwuvGaBu/rM9bXARubriow7vGLjNHzQ+WrcI9/KIeX9nBkQMzkhohS9i
e3WhcNlnBtw+n5iLPLYIsyZ2rW0RDIyeXExtsFuAhphOWWIUA/oi7c3NVgvY
cc7diBLLQJ7FSjMnnQXMtK43P53IwJrCZoNxgQV40A4+fptF7v/tN8V//efx
m3E/srOaAWde+xXWEXOIksncfbOOgcAtfW1OTnP4dI0rdaaBgWdy59daWc/B
fNAjf1UbAzs/aK9U3zaHuZHYtkMMsj66vUpx8Cx2TfWv8pln4PpBgfuZLjPw
4jKzPSHVh7qslGYHhSkwL67ZV7WlD29XnkyX45uCVV7lP4NtfeB56vInivEP
8q/UH+rJ9cHkq6DSHp9/KGLJPNE+QF6fDOt8tjiJ6bkJO1XdPuw1F7bsy5zA
qfH3zttt+zDY6vprSnYcQu1JQRz5ffCIzSr2mmHgw4rnz1N+9+HpXpGBrQEM
LD+oYXLjTx+WlhLXh7UY4PCqXllf3gc7vbIEaS86/h4ffRTe1Adl747Cjwd7
UVkgY2A42of+9Bd737p3QXdydNuSv31wwlmhEJUuFG1K4Uqf7MNZ7hyGVH8n
CLsj6Zvn+vDqYgibpnonYpQspae5+uEyohEdN9MBl2jf+W9i/djVL2viurQF
PK2W9Sck+vHn8UMX4mYz3izfHr90Yz8Gnc7dmK5twtMrqZfvSPeDNU+NeR/S
CGvJuioN+X68uCe5PP5UPbQ/84UNHunHpfUelckjVcjPq3sVoN2Pilf+gpQr
VaD89Tt/8lg/VBxztAQ6K6FosEOIMOwHdbazcl98BbYs037hca4fbDLDI1dj
S7Dk+UtjpTv90LEdkzi9Jx+J40OzxL1+mBtNjLWY5cHqssl3zQf92Hh8Tz3T
NRf5BrsGjJ72I0X2QMjeyWy82dRmZ/OW5HP0z+U55Hz2VVv6n0M/bnz5JV1/
JB09vInFT536cXONp9e1ilRo/HNa/d6tHwKLpjfPTCSBq+hAZLB3P/4Rp9rO
2MUhUeWH4Xa/flzH9IrnFjGwil81FedP5q9v1TFYEYl8HzolK7gfxnMfrs5X
hOD1Tc/6xuh+hCS9WaqY6YM9XaynF+L6Uf+4PNSL8gVdp65L0qn9eCs67Hew
9SMOUw7fmEjpB93glqt12itwCI2x8+X2I/7JhP6dgccE1eFcqGd+P9jHR+zs
rN4Qlgu/ddcVkvvl9cHjR6Azkdv77atMaT/M3n1NuJrrSdw9u+xQbHk/aN8D
tlBWexGbKmy79lX1ozKloSVa35d4lXpsp3p9P7TQJfA8PYDYszOl+k9jP5w1
jKMa5YOIrsBNjwxb+qEa9Gy5iU8wcdh5Nvc8rR+nEh0U/TVDiL8sq6s9Xf04
6hNMN3ofSgTZVq683kvWz64pxkuEEexmoSaPBsj949Y9d4EzkoirFmQyh/qR
0LmKMSwQRZhrvQh+O9oPN88n3BZC0QT/r37tFX/7cae64xh1aQyRLX9yxGOy
HyLWVn4tIzHE7Z/Zn0Sn+7FF0mR3Q1EssVFMVilgth96ITtLK47GEfacnG+i
mf3o+JxhmsMZT8g/stmmwD4AG4NSsaOn4gnaUFN5OucAZmp4ueSD4gl3iyO2
atwDWKu7bO8dRjxBqY8TLeIZgK5owxAv6aNjR8UJfd4B5J8SCWSepxIBhINV
3coBKOuzD2i5UQlDhYllpvwDsKTZutDTSP8MN4vtEhxABW3mYVMblfg91GDz
ffUAxPdsNziySCVc5I/Lma4dQBA3kdMknECcsC0eXrtuAIYOveu/SCUQa1LV
o+skBpD7MW/ssWwC0Tr/64bHxgHILH268IbkIOyXNdg8AL/LsodTyNdffR07
yLuFrIc6vcC/OoGQK5SJLJIZwFTwfJAHud7k8iDrtzsG4LjJqFelnUqk66/b
flhuAA78AnH8KVTC3sOznyk/gCbeyG2rHKnEkfqV4Rl7B2AsUxWndJxKLBdz
uPpoP1lvwNrOj4JUovI8m8w+pQEInD74UbQ0nvgS+JgxfnAAaUbB1dXP4wnT
3r8hMaoDeOFydpzYGk9s2nbj8nW1AdwfnLnX/SeO6LvRKy2jQV53cl9HsYoj
YuLMens0BxCoJ18YPxxL3Jts+BGoMwBVr1BOS85Y4sCB41ZmugPwv/Gw9Ouy
GIL5tHjzOgOy3/W598+yRRNOnJlBnsYDeJA4u/iTiCAMtfZbHj89AI5pgSI4
hhMizrGSfGcHIFj/RNtRLYwIEgwKcLgwgDb1GgXddz+JNEkH/yfWA8gTp9i6
J/gTLy6xmSneHMBhppD43HFfQiP8scTkrQF8EBx5eK/6K1Epf8Pv5v0BnKx9
rsR67E704biPuf0Ariodjfn8Q4mIeV18RuL1ABq9smKiDt6CbaG6aPNbMp5f
/1Xun/Zg6e/3MnIm91P9+eg2u48QMVv3RfPLAMw38D6+8jUIrYGeJzm9B2DL
K8zuI/8TQb0rV2f7DqDj9Y3OrIZQ7LzJ5qkUOAB7kzhXN4NoaDzr/SgbNYBN
03/cXt1JxF2fWFfB3AHESu0UsAnMRsqCj0Nu/gBe/1w6MvIoBwtm717eLRyA
XXHT4j2jXDhsPn+/unQArSr6fXcE8uEXtfy8R8MAHh376eEUV4iCrEuygsPk
efO8On/6fgXWdq8rEVg7CGvx4xkG9xpx/sjSghyxQZh13d3iwdOEoNC/WXck
BvHS/GkUzb8Jsjf+UKs2DeL4mzS2j+XNUPv3wOfjzkGsOND0t0CpDdZLq68J
qA+Cq5YnvUqiE5k7HHkEbAbxyja358VlOvbXrinzuD2IX6HCtHDSI+KehX4U
vjeI2uwvh5aRc2lQ2W+xtY8G8aJLb915cu5wvLVk54ZXgxj5+5tT8l8fTiS8
Or7zyyCangkrG7kOgqH83EcnaxB8JzNsuC6Nwbx7xYWS7EH8/hbaT/8whmZn
v816eYMQ6tStyU0dQ2lrRpRh0SCiiLwayxXjoL6YyzpdPYiH+8/lbEkYx7Pc
h92X6IOYeynJ0bT4FwJH78q+4htC/Q9z7xr7fwjIWcWrLDAEjddU6f2R5Dyh
FN0/LjSE1Ohd66/X/YO+TF+IhegQeLSK72htm4ITt5mkmtQQnq9cWRBaPgWu
PB0RNuUhXHjEfmKRbwbkLDqZojKEgxXxOtP7ZrCJ+qbmFoZw55hTU5zpDCiB
hHuHBvn61+e1zcJn8NxuHy9hMASF15+fv8Yspg5Ksr24NIQjUS3l3GZzeJuQ
1b7v6hD2qH86+Mh+DsI7TDOHrYdwdE+OtlfQHPaKfX1y/vYQeiZ6jGi9c7g9
s+KfytMhWAzSNty/Oo/+xJn+efchaHWGH+80XcAj2S9FCZ+GoKQzHF/yeAE8
P/aGXv8yBLvLe4ROfVnAlk82Vi2+Q1C+Z+WqVb4Ayzs97ekhQ5B2LR1+p7SI
1p2VNY9/DUHbl/1m2cIivg8KPOckhnBvoH22XYCcf8ONtrjmDEE929LdYwvp
r1INjwJ+D+H1ta2/2/SZmFrXLlFYOQRW7Q29KR8m0ps2FBrWkK8/k7tqeTQT
z79a3G6uG8K35cv/ZmSR/izUmzvcPITWIysNZ2hMCCwfuiLcOwTb/Hb3wo0s
1BbuFPBnDCFI4J159i5yHn97K33rwBD65Ry4jFVZWM8+seLg6BD2X540OnqW
ha4sheT88SHcf9d9NOoKCz+fPbigPzkEtRj26FBbFmRnZuMtZocwLrDx8jVX
FkaTDp4bnB9CoLGBxC5vFqj3nnPdZw4hPIKXzZX0C6VRttOOnMOYbtOU5k9n
YSHqMJsg9zCcE3taFfJZyLZ+E+7LMwz5ccOIsTIWNOlLF2JWDkNuWaurLI2F
ZT90fh7gH0ZRGeSi+lgotXDWzxUcBrcXcyZnjAX3DWXTx1YP44pKV9rNGRaM
2vgC69YMY9lOc8SyWBDxNTx6QWwYFw30dqpzslGaTTwm+sSHEVUWd+sxNxvF
vHa15oLkMLr2bcw5QvqalMfp0bdSZPzlCREtpM8xDLy9Vm0dhmKhGPMg6XsR
K1vUvLcN40H2TORl0gdtSsQHN8kOwy1AK+Qc6Yu735t5RskNIz/2HE2M9MlJ
zYBD+3cPI3pVt/6PtaQPc3XRib3D2DPcy5gm/fNp7mZ3nf3DuCNQGrSa9FVV
+0tKNQeGEajw+dEiyRyqoV2mB4cxdvXxxVjSbwvm+5zph4ZRI7tg9n//r+uY
tn3fbQpZz+7FK3dI1n14o3328DD+2KQ++z9/XrUvxuH1kWG82/Hb7xzJ1X9H
5VdqD+MV27o/LDLel7jdzV+ODqOtYimXDclnbO693qg3jK+JSsdDyPXFZZNk
IwyG8a8vLSmM9Gda/1Td3hPDmAseVrxP5h8cesAu03gYA8OfO3jJ+i5feiKj
dXoYddcrkm6IsFG2b/5VVXlmGEqbBAu+CrNRhmmLT86aDiNCbreoqyDp3/6Q
6jEbxpNHZwldfjbKxJOJpRYW5P6JZUV1r2Sj7D8dOth2cRiFFqs3avGyUR7t
PVdx9vIw/H5+2vaQh42SsWpVQsPVYVSuiWy+R/o0czD3i/H1YYidXqF5iPRp
StGDJ1U3h6E2fIwVssjCb/t2tZK7w+jPa79cNsICz3kPae37wxBnnE0ppLNw
TElzWcHDYXR6vDA1bWehcjy6MuvZMA4srn90spSFFsvnF6jvhuGqcVDLNZh8
frBbfdf7YfCoPn9u/v8aLvevpO8ADLsossxcl7WdZeN4qaYOMyurU/ae1BVL
a9Gx7IKT1BapY2PdVtpVJW0WbqQldpuoFXnJeW/MlJnoPF7RMlIpLcrZ9/tR
M6gIGP/B88P7Puc8tn7mz32+oOBXCptV7+i2NCv0mhA6L51C86aZeUm2/4wE
OR/LklFoKBS2boStl13a+XOuULiZ4bfGYbEVh8yJQdJrFDbsiojZ62qFqXzY
4VwuhQrV6T1mhhXMhX/JThZR+C28Z59CZcE3jB+Pm+9QuL6xz1tQYkGazjXy
aKltb9c9G9XXbD64dNbjQBWFWSObFwnjLXCesrNqr4qC1IMTGu1tge/w2+5N
Dyhoi5ii3YlmHFQXVDf3UOgMCJEfiDOjSs6/wnlMIauJfXbxVjP8eY3RAU8o
XJvgV62Ybwan5eLrZf9RSF3v+FKh+oDwYr8Z8ywUcr1qkmMpEyp2vp3ebkfb
PJEz8KHVhOnMu9MSGTSeT5QcXnrHhFqev/2QPY2M3TvaskQmuE4NspbNonHu
aWvstpH30EdzqRAPGsUZy02C/ncQfh7XlBBKI7Ig32RINKLhPlu9KIyG11r+
tz48I1giUj+wg4Z2MWe7z1Ij2tU/13IiaAxyNHNTBw3wPXikcnYMje/HPOv+
hgHGNnFewQkaZtkxp1VkHCeT/zjVq6Bxq3DeMGPJGBwPT96wu5DG6W1LmvlT
xiAT/DBTX0zDhZkpL9SNojR4pZyU0eCaeJFz00ahn9FRP+GejcfN7B39bATB
V+3sPTQ0mJ8xfT0WEsypjDh/0ERjyOB+KfnFEOQ37297b6ZxUcheyLkwBB+Z
F+uEHUGweF0Ue62tO44Zi1MmEXjtd3QXZL9EQqCkI9uJ4ISIz+vhvsBAW81s
lRvBo96Hl+Man6Hw5bzs6SEEiiB+aU2XDilXkvn9mwgyz4g9t7N1iN5CzS/i
EjCymXv14n44K5V3NoYRuP0pq3+zug9nJbsa0iIJJr6aJBCWayHwyxqdeoSg
KPjjsC96uxE0bFepjSfY81NXFG9dN1jXBQmK4wSXQq8W9ZV04cGUFZM3JNl4
/PeEKdM0+LrvgXOqhCAmQ7hAsKUDrkmzOZPzCb6qv4H0gH9hWZHg+PAmgUVZ
9mlGYBMeUYOd+bcJ8p00glvrG5EeVhq+roTAv3i1hLWjAVbPLfuTlQQz7Ft8
5+SooNVVr9h6j+DIdzl1sco6VFxwsbirCA7FykTTtLUQWkZS6tUEYuloUOaa
GvR2SK4yNAT/PB54bcitRJXYGKXpJjA8w1i7UwUurIrwkPcQ6Pd/cvT2qTIE
53mXBfQTvJO+WC09WoK7v7Q0nRoieHpL1jyadAOZ7GUS7isCibTTidOSC9HA
5VAXQsBqtq7c7p6DL0PidLXjBFwVy23cnIWJH3XlphsJZoW/mrZvUgaelK+K
4b8nOO+lejjumQ5ljHyRj5mgVb38dXyfGBdZDm+sVoLs5b8P3giMx/8BDr42

       "]]},
     Annotation[#, "Charting`Private`Tag$1996556#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 0.9999999795918367}, {-1, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.67357255901108*^9, {3.6735726372909803`*^9, 3.673572713605756*^9}, {
   3.673573750581397*^9, 3.673573754379722*^9}, {3.67357397574266*^9, 
   3.673573999517926*^9}, {3.673574337823106*^9, 3.673574421444909*^9}, 
   3.673582929757193*^9, 3.673583447194014*^9, 3.6735840022330723`*^9, 
   3.673584152283605*^9, 3.673664567941546*^9, 3.6736647624263287`*^9, 
   3.6736654458782663`*^9, 3.673665482399437*^9, 3.673726071844159*^9, 
   3.675731879042428*^9, 3.79384311881861*^9, 3.793843269777669*^9, 
   3.8232297957219963`*^9},
 CellLabel->
  "Out[3488]=",ExpressionUUID->"17900a44-1723-49ae-b2b8-c0d71d5ac0cd"]
}, Open  ]],

Cell["Repeat for maximum possible time delay", "Text",
 CellChangeTimes->{{3.673555010205069*^9, 3.673555027514174*^9}, {
  3.673572957665414*^9, 3.673572968054578*^9}, {3.673574803097384*^9, 
  3.673574810240097*^9}, {3.7938431072734547`*^9, 3.793843108334221*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"677bae03-2673-42b2-b94e-fc83042392b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol2", "=", 
  RowBox[{
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Tan", "[", 
         FractionBox[
          RowBox[{"\[Omega]", " ", 
           SubscriptBox["t", "max"]}], "2"], "]"}], "+", 
        RowBox[{"\[Omega]", " ", "\[Tau]"}]}], "\[Equal]", "0"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox["t", "max"], "\[Rule]", "0.2"}], ",", 
        RowBox[{"\[Tau]", "\[Rule]", "1"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Omega]", ",", "16"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.673574823216652*^9, 3.6735748384150457`*^9}, {
  3.673664753431912*^9, 3.6736647546237183`*^9}},
 CellLabel->
  "In[3489]:=",ExpressionUUID->"164b8b2d-d383-41dd-ab05-5e5316c9f395"],

Cell[BoxData[
 RowBox[{"\[Omega]", "\[Rule]", "16.319945272148`"}]], "Output",
 CellChangeTimes->{{3.673574831341302*^9, 3.6735748388304043`*^9}, 
   3.6735829297993393`*^9, 3.673583447229179*^9, 3.6735840022537727`*^9, 
   3.673584152342985*^9, 3.673664567970454*^9, 3.673664762493411*^9, 
   3.67366544591918*^9, 3.673665482440634*^9, 3.673726071863778*^9, 
   3.675731879101808*^9, 3.793843118825705*^9, 3.7938432697845984`*^9, 
   3.8232297957430058`*^9},
 CellLabel->
  "Out[3489]=",ExpressionUUID->"29da8c06-9c0a-4482-93c3-2a5e4f565aa8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kmax", "=", 
  RowBox[{"N", "[", 
   RowBox[{"kstar", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Tau]", "\[Rule]", "1"}], ",", "sol2"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{3.673574850256297*^9},
 CellLabel->
  "In[3490]:=",ExpressionUUID->"d307f820-60e3-44fd-b1a9-c85e36cfaac8"],

Cell[BoxData["16.350553925965503`"], "Output",
 CellChangeTimes->{{3.6735748468778*^9, 3.673574850640148*^9}, 
   3.673582929874539*^9, 3.673583447259251*^9, 3.673584002302809*^9, 
   3.673584152388321*^9, 3.6736645680110607`*^9, 3.6736647625553303`*^9, 
   3.6736654459957647`*^9, 3.67366548251703*^9, 3.6737260719238777`*^9, 
   3.675731879149362*^9, 3.7938431188612547`*^9, 3.793843269814221*^9, 
   3.8232297957486057`*^9},
 CellLabel->
  "Out[3490]=",ExpressionUUID->"17428dad-0bf7-4550-b7d4-9743c59f1b77"]
}, Open  ]],

Cell[TextData[{
 "Plot T (closed-loop transfer function) and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["W", 
    RowBox[{"-", "1"}]], TraditionalForm]],ExpressionUUID->
  "6ad3f878-92b5-40b1-95c0-528b127c8959"]
}], "Text",
 CellChangeTimes->{{3.673555010205069*^9, 3.673555027514174*^9}, {
  3.673572957665414*^9, 3.673572968054578*^9}, {3.673574803097384*^9, 
  3.673574810240097*^9}, {3.675731952129817*^9, 3.675731966431712*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"841d0a21-11b4-4989-b698-3689c104ce80"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"winvtf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", "w"], "/.", " ", 
      RowBox[{
       SubscriptBox["t", "max"], "\[Rule]", "0.1"}]}], ",", "s"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T0", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"g", " ", "k"}], 
     RowBox[{"1", "+", 
      RowBox[{"g", " ", "k"}]}]], " ", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["t", "max"], "\[Rule]", "0.1"}], ",", 
      RowBox[{"\[Tau]", "\[Rule]", "1"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ttf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     RowBox[{"T0", "/.", 
      RowBox[{"k", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6.45", ",", "8"}], "}"}]}]}], ",", "s"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"BodePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Ttf", ",", "winvtf"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "100"}], "}"}], ",", 
   RowBox[{"PlotLayout", "\[Rule]", "\"\<Magnitude\>\""}]}], "]"}]}], "Input",\

 CellChangeTimes->{{3.675731988908354*^9, 3.6757320580389977`*^9}, {
   3.675732157857641*^9, 3.675732163272648*^9}, {3.67573220369203*^9, 
   3.675732443536314*^9}, 3.675732496639111*^9, {3.675732567572967*^9, 
   3.675732584685997*^9}, {3.675732660332377*^9, 3.675732742865141*^9}, {
   3.675733196885215*^9, 3.675733197299705*^9}, {3.675733287726679*^9, 
   3.675733331397204*^9}, {3.675733957643907*^9, 3.675734016690667*^9}},
 CellLabel->
  "In[3491]:=",ExpressionUUID->"200c1785-732f-40f5-aafd-788b8ffa1a03"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVj2lYzG0fhqfl0eJplaikRfRqU6HMRD8kRZYnDWkxWoYo0mZLKC3SIk+S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       "]]},
     Annotation[#, "Charting`Private`Tag$1997962#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Xk0lXsXB3DkRpSSIcfQRCVzwjlp2IU6hJvxSiLRgG5UXKXcWyfDVZQG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       "]]},
     Annotation[#, "Charting`Private`Tag$1997962#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Xk01dsXAHBzopSxiIdMDTK7omEXlUzJFJWnMlT0RGhQemUMmYpkfhEq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       "]]},
     Annotation[#, "Charting`Private`Tag$1997962#3"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV03k0lesXB3Bj5MiQ6X1IdSTTqbh+t9Olst+iCTcR0TWEKMkQDVw3oRzK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       "]]},
     Annotation[#, "Charting`Private`Tag$1997962#4"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, -26.429691187780474`},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
      Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
      Part[#, 2]}& )},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{{{-30., 
       FormBox[
        RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
       FormBox[
        RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
       FormBox[
        RowBox[{"-", "10"}], TraditionalForm]}, {0., 
       FormBox["0", TraditionalForm]}, {10., 
       FormBox["10", TraditionalForm]}, {20., 
       FormBox["20", TraditionalForm]}, {-30., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-28., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-26., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-24., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-22., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-18., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-16., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-14., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-12., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-10., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-10., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-8., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-6., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {12., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {14., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {16., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {18., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {20., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, {{-30., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-20., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-10., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {10., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {20., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-30., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-28., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-26., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-24., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-22., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-18., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-16., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-14., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-12., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-10., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-10., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-8., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-6., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {12., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {14., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {16., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {18., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {20., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}, {{{0., 
       FormBox["1", TraditionalForm]}, {1., 
       FormBox["10", TraditionalForm]}, {2., 
       FormBox["100", TraditionalForm]}, {0.3010299956639812, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.47712125471966244`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6020599913279624, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6989700043360189, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.7781512503836436, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.8450980400142568, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.9030899869919435, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.9542425094393249, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3010299956639813`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.4771212547196624`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6020599913279623`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6989700043360187`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.7781512503836436`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.845098040014257, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9030899869919435`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.954242509439325, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
      0.3010299956639812, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.47712125471966244`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6020599913279624, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6989700043360189, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.7781512503836436, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.8450980400142568, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.9030899869919435, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.9542425094393249, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3010299956639813`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.4771212547196624`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6020599913279623`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6989700043360187`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.7781512503836436`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.845098040014257, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9030899869919435`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.954242509439325, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{0, 2}, {-26.429691187780474`, 13.598827034903954`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{{{0., 
      FormBox["1", TraditionalForm]}, {1., 
      FormBox["10", TraditionalForm]}, {2., 
      FormBox["100", TraditionalForm]}, {0.3010299956639812, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.47712125471966244`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6020599913279624, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6989700043360189, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.7781512503836436, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.8450980400142568, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.9030899869919435, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.9542425094393249, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.3010299956639813`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.4771212547196624`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.6020599913279623`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.6989700043360187`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.7781512503836436`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.845098040014257, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.9030899869919435`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.954242509439325, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}, {{-30., 
      FormBox[
       RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
      FormBox[
       RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
      FormBox[
       RowBox[{"-", "10"}], TraditionalForm]}, {0., 
      FormBox["0", TraditionalForm]}, {10., 
      FormBox["10", TraditionalForm]}, {20., 
      FormBox["20", TraditionalForm]}, {-30., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-28., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-26., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-24., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-22., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-20., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-20., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-18., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-16., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-14., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-12., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-10., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-10., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-8., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-6., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-4., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-2., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {0., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {0., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {2., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {4., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {6., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {8., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {10., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {10., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {12., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {14., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {16., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {18., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {20., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}}}]], "Output",
 CellChangeTimes->{{3.675733305643423*^9, 3.675733333252699*^9}, 
   3.675733959074793*^9, {3.6757340021897593`*^9, 3.675734018274425*^9}, 
   3.793843119834415*^9, 3.793843270578239*^9, 3.8232297966626177`*^9},
 CellLabel->
  "Out[3494]=",ExpressionUUID->"45dfebcd-c581-43bf-ad2f-0179f97e39fa"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.675733299846225*^9, 3.675733300614605*^9}},
 CellLabel->
  "In[3495]:=",ExpressionUUID->"9ebfaa69-fbe9-4cd5-886a-8db5139a7ccc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"g", " ", "k"}], 
   RowBox[{"1", "+", 
    RowBox[{"g", " ", "k"}]}]], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.675732945383523*^9, 3.6757329573525677`*^9}, {
  3.675733072432849*^9, 3.675733085461533*^9}},
 CellLabel->
  "In[3496]:=",ExpressionUUID->"79e2c957-18f5-47e2-9287-0a9aa0202c28"],

Cell[BoxData[
 FractionBox["k", 
  RowBox[{"k", "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     FractionBox[
      RowBox[{"s", " ", 
       SubscriptBox["t", "max"]}], "2"]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"s", " ", "\[Tau]"}]}], ")"}]}]}]]], "Output",
 CellChangeTimes->{3.675733085841083*^9, 3.793843119988844*^9, 
  3.793843270630434*^9, 3.823229796815884*^9},
 CellLabel->
  "Out[3496]=",ExpressionUUID->"d450a427-b735-470e-b0dd-8712eea6764d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["w"], "Input",
 CellChangeTimes->{3.675734033653946*^9},
 CellLabel->
  "In[3497]:=",ExpressionUUID->"6791b1c2-2b9f-46c0-8d9a-2d8e1cc7380a"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2.1`", " ", "s", " ", 
   SubscriptBox["t", "max"]}], 
  RowBox[{"1", "+", 
   RowBox[{"s", " ", 
    SubscriptBox["t", "max"]}]}]]], "Output",
 CellChangeTimes->{3.675734034013081*^9, 3.793843119994701*^9, 
  3.793843270635635*^9, 3.823229796822715*^9},
 CellLabel->
  "Out[3497]=",ExpressionUUID->"e3d05cb0-acf9-424a-96b1-615d978bae4d"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{848, 751},
WindowMargins->{{Automatic, 128}, {Automatic, 1}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"70e641a7-d744-4148-9ec5-72d55144b22c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 248, 4, 67, "Section",ExpressionUUID->"c22289c3-d84e-45f2-89f7-8af888a173f1"],
Cell[831, 28, 175, 4, 30, "Input",ExpressionUUID->"ba18ade7-c756-46d1-9f77-14f5ec570912"],
Cell[CellGroupData[{
Cell[1031, 36, 1800, 50, 74, "Input",ExpressionUUID->"217703fd-81cc-4893-bb7d-89ba2395965c"],
Cell[2834, 88, 1106, 30, 65, "Output",ExpressionUUID->"a279b242-04ce-4c84-9d47-c6c25c4f6a5f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3977, 123, 208, 4, 30, "Input",ExpressionUUID->"b37fb442-05b7-4e9f-b12a-b8be80fa212e"],
Cell[4188, 129, 1008, 21, 62, "Output",ExpressionUUID->"7f4f6333-7f38-42d1-a815-1c10581568f9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5233, 155, 264, 5, 30, "Input",ExpressionUUID->"7fb7ff62-0769-4965-a84d-5eb7490cac8e"],
Cell[5500, 162, 717, 14, 81, "Output",ExpressionUUID->"ecee79e5-acc7-4bdf-9757-7c5f8f86139a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6254, 181, 449, 11, 30, "Input",ExpressionUUID->"397fc16a-646e-423b-afd1-97475add7237"],
Cell[6706, 194, 1289, 29, 61, "Output",ExpressionUUID->"57626ebf-e085-4c7f-8f42-a286db8ee8c5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8032, 228, 572, 15, 30, "Input",ExpressionUUID->"7a82e015-c2fd-4251-8998-17c22fb0c91c"],
Cell[8607, 245, 2919, 70, 120, "Output",ExpressionUUID->"28e77042-cf15-490f-bab7-ecd8269f820b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11563, 320, 702, 18, 30, "Input",ExpressionUUID->"bd29a562-e1fc-4da9-ad8c-062da1cc29f6"],
Cell[12268, 340, 848, 16, 34, "Output",ExpressionUUID->"68ab35b9-b441-457d-b70b-97acd7a7a3d9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13153, 361, 535, 13, 30, "Input",ExpressionUUID->"c6747734-fbda-4b8f-a445-b5333e4ef58a"],
Cell[13691, 376, 18557, 326, 239, "Output",ExpressionUUID->"8a6604bf-cdd2-4579-9f00-0e95827d9f4b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32285, 707, 7221, 184, 262, "Input",ExpressionUUID->"e66978f5-6fbb-4605-a069-50f19e186a1e"],
Cell[39509, 893, 293471, 4852, 261, "Output",ExpressionUUID->"1bcb1886-b069-41fa-aa5f-864e4d8f6605"]
}, Open  ]],
Cell[332995, 5748, 297, 6, 52, "Text",ExpressionUUID->"311c8c65-e067-41f8-930d-b951ad414e25"],
Cell[333295, 5756, 767, 17, 115, "Input",ExpressionUUID->"8acc12c7-4bbe-4fd8-bf42-ba4bc93a29bb"],
Cell[334065, 5775, 329, 6, 52, "Text",ExpressionUUID->"33f1c7f3-76d0-4705-9451-f9ed9b43c34b"],
Cell[CellGroupData[{
Cell[334419, 5785, 1378, 36, 95, "Input",ExpressionUUID->"588b491e-2e4c-4cc4-a83e-b899ac64ae44"],
Cell[335800, 5823, 769, 12, 34, "Output",ExpressionUUID->"9a8c9670-51a8-4624-a954-84a3b86cc8e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[336606, 5840, 405, 11, 30, "Input",ExpressionUUID->"a6dbd9fd-41ca-4710-938a-8526d1d840cf"],
Cell[337014, 5853, 581, 9, 34, "Output",ExpressionUUID->"c93ba2ea-970d-4603-8154-c3c3215afae8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[337632, 5867, 1482, 38, 73, "Input",ExpressionUUID->"86db71b8-cab1-4c99-a1d0-57a140c6819b"],
Cell[339117, 5907, 25611, 439, 248, "Output",ExpressionUUID->"17900a44-1723-49ae-b2b8-c0d71d5ac0cd"]
}, Open  ]],
Cell[364743, 6349, 369, 6, 52, "Text",ExpressionUUID->"677bae03-2673-42b2-b94e-fc83042392b9"],
Cell[CellGroupData[{
Cell[365137, 6359, 857, 24, 46, "Input",ExpressionUUID->"164b8b2d-d383-41dd-ab05-5e5316c9f395"],
Cell[365997, 6385, 543, 9, 34, "Output",ExpressionUUID->"29da8c06-9c0a-4482-93c3-2a5e4f565aa8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[366577, 6399, 331, 10, 30, "Input",ExpressionUUID->"d307f820-60e3-44fd-b1a9-c85e36cfaac8"],
Cell[366911, 6411, 511, 8, 34, "Output",ExpressionUUID->"17428dad-0bf7-4550-b7d4-9743c59f1b77"]
}, Open  ]],
Cell[367437, 6422, 540, 13, 52, "Text",ExpressionUUID->"841d0a21-11b4-4989-b698-3689c104ce80"],
Cell[CellGroupData[{
Cell[368002, 6439, 1681, 47, 134, "Input",ExpressionUUID->"200c1785-732f-40f5-aafd-788b8ffa1a03"],
Cell[369686, 6488, 33478, 654, 245, "Output",ExpressionUUID->"45dfebcd-c581-43bf-ad2f-0179f97e39fa"]
}, Open  ]],
Cell[403179, 7145, 176, 3, 30, "Input",ExpressionUUID->"9ebfaa69-fbe9-4cd5-886a-8db5139a7ccc"],
Cell[CellGroupData[{
Cell[403380, 7152, 352, 9, 51, "Input",ExpressionUUID->"79e2c957-18f5-47e2-9287-0a9aa0202c28"],
Cell[403735, 7163, 493, 14, 62, "Output",ExpressionUUID->"d450a427-b735-470e-b0dd-8712eea6764d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[404265, 7182, 153, 3, 30, "Input",ExpressionUUID->"6791b1c2-2b9f-46c0-8d9a-2d8e1cc7380a"],
Cell[404421, 7187, 377, 10, 101, "Output",ExpressionUUID->"e3d05cb0-acf9-424a-96b1-615d978bae4d"]
}, Open  ]]
}, Open  ]]
}
]
*)

