(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    152642,       2992]
NotebookOptionsPosition[    150346,       2946]
NotebookOutlinePosition[    150743,       2962]
CellTagsIndexPosition[    150700,       2959]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Tracking a ramp  (Problem 9.11)", "Section",
 CellChangeTimes->{{3.793843534698876*^9, 
  3.793843564841447*^9}},ExpressionUUID->"4e1fd316-267c-423a-a071-\
ff518d5ae5ac"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[3450]:=",ExpressionUUID->"0f810280-2c22-497f-92ad-f3ae5e70e725"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"g", "=", 
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "s"}], ")"}], "2"]]}], ";", " ", 
   RowBox[{"q", "=", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "s"}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"s", " ", "\[Tau]"}]}], ")"}], "3"]]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"g", " ", "is", " ", "the", " ", "system"}], ",", " ", 
    RowBox[{"q", " ", "is", " ", "the", " ", "IMC", " ", "controller"}]}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"T", "=", 
  RowBox[{"q", " ", "g", "  "}]}]}], "Input",
 CellChangeTimes->{{3.673834733530055*^9, 3.6738348101863003`*^9}, 
   3.673834934629868*^9, {3.673841279382874*^9, 3.673841304616238*^9}, {
   3.6739016816940193`*^9, 3.673901706868148*^9}},
 CellLabel->
  "In[3451]:=",ExpressionUUID->"c407f64c-d30a-41c2-bf16-3cf239acbc54"],

Cell[BoxData[
 FractionBox[
  RowBox[{"a", "+", 
   RowBox[{"b", " ", "s"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"s", " ", "\[Tau]"}]}], ")"}], "3"]]], "Output",
 CellChangeTimes->{{3.6738347963321867`*^9, 3.673834810698777*^9}, 
   3.673834935862588*^9, 3.673835551269017*^9, 3.673836852455716*^9, 
   3.673838076073738*^9, {3.673841284454185*^9, 3.6738413056745*^9}, 
   3.673842027672536*^9, 3.673842060558675*^9, 3.6738421221008244`*^9, 
   3.673869592618918*^9, 3.673869752424025*^9, {3.673897807946431*^9, 
   3.673897828433009*^9}, 3.673901213725966*^9, 3.673901635040636*^9, 
   3.673901708291585*^9, 3.673902688846414*^9, 3.79384361586443*^9, 
   3.7938436693843813`*^9, 3.8232297811768713`*^9},
 CellLabel->
  "Out[3452]=",ExpressionUUID->"a33d101f-dbbc-45a2-9523-0aabc105fa9a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "=", 
  RowBox[{
   RowBox[{"1", "-", "T"}], "//", "Together"}]}]], "Input",
 CellChangeTimes->{{3.6738348135341377`*^9, 3.673834844576434*^9}, 
   3.673834886401806*^9, 3.673841315768553*^9},
 CellLabel->
  "In[3453]:=",ExpressionUUID->"fcbac1e7-313d-4be7-8f7e-0db21fb7e571"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", "a", "-", 
   RowBox[{"b", " ", "s"}], "+", 
   RowBox[{"3", " ", "s", " ", "\[Tau]"}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["s", "2"], " ", 
    SuperscriptBox["\[Tau]", "2"]}], "+", 
   RowBox[{
    SuperscriptBox["s", "3"], " ", 
    SuperscriptBox["\[Tau]", "3"]}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"s", " ", "\[Tau]"}]}], ")"}], "3"]]], "Output",
 CellChangeTimes->{{3.673834822602806*^9, 3.673834845126223*^9}, 
   3.673834886859414*^9, 3.6738349385612793`*^9, 3.6738355513188877`*^9, 
   3.673836852506983*^9, 3.673838076125523*^9, 3.6738413166829357`*^9, 
   3.673842027731332*^9, 3.673842060617944*^9, 3.6738421221626587`*^9, 
   3.673869592694663*^9, 3.673869752499916*^9, {3.673897808024037*^9, 
   3.673897828507778*^9}, 3.673901213801791*^9, 3.673901635171686*^9, 
   3.673902688906074*^9, 3.793843615870646*^9, 3.793843669392496*^9, 
   3.823229781182909*^9},
 CellLabel->
  "Out[3453]=",ExpressionUUID->"6950831c-9c9c-405b-82d8-0ab523411a7d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S0", "=", 
  RowBox[{"S", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "1"}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"3", "\[Tau]"}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.673841342296422*^9, 3.6738413436630793`*^9}},
 CellLabel->
  "In[3454]:=",ExpressionUUID->"f77be348-0b7a-47f5-b6ae-b3935c77dcac"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"3", " ", 
    SuperscriptBox["s", "2"], " ", 
    SuperscriptBox["\[Tau]", "2"]}], "+", 
   RowBox[{
    SuperscriptBox["s", "3"], " ", 
    SuperscriptBox["\[Tau]", "3"]}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"s", " ", "\[Tau]"}]}], ")"}], "3"]]], "Output",
 CellChangeTimes->{
  3.6738413451728477`*^9, 3.673842027783965*^9, 3.673842060688079*^9, 
   3.673842122213091*^9, 3.6738695927617397`*^9, 3.673869752570931*^9, {
   3.67389780810771*^9, 3.673897828592599*^9}, 3.673901213869355*^9, 
   3.673901635248065*^9, 3.673902688972855*^9, 3.793843615899003*^9, 
   3.793843669428893*^9, 3.823229781189209*^9},
 CellLabel->
  "Out[3454]=",ExpressionUUID->"a7197706-c099-4c95-ae16-996c76fd4e75"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "=", 
  RowBox[{
   RowBox[{"q", "/", "S0"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "1"}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"3", "\[Tau]"}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.673834952890665*^9, 3.673834957108325*^9}, {
  3.673841358206649*^9, 3.67384136764913*^9}},
 CellLabel->
  "In[3455]:=",ExpressionUUID->"430d829b-0c88-4442-9cc3-623037780829"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "s"}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"3", " ", "s", " ", "\[Tau]"}]}], ")"}]}], 
  RowBox[{
   RowBox[{"3", " ", 
    SuperscriptBox["s", "2"], " ", 
    SuperscriptBox["\[Tau]", "2"]}], "+", 
   RowBox[{
    SuperscriptBox["s", "3"], " ", 
    SuperscriptBox["\[Tau]", "3"]}]}]]], "Output",
 CellChangeTimes->{
  3.6738349595540867`*^9, 3.6738355513683453`*^9, 3.673836852558268*^9, 
   3.6738380761763897`*^9, {3.673841359244061*^9, 3.673841368341899*^9}, 
   3.673842027834421*^9, 3.67384206075522*^9, 3.673842122262589*^9, 
   3.673869592828795*^9, 3.673869752636306*^9, {3.673897808193829*^9, 
   3.673897828679036*^9}, 3.673901213938405*^9, 3.673901635331066*^9, 
   3.673902689040539*^9, 3.7938436159045258`*^9, 3.793843669435463*^9, 
   3.8232297812151823`*^9},
 CellLabel->
  "Out[3455]=",ExpressionUUID->"36d295cf-daff-4f9f-a55b-ba575d85be2e"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"gtf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"g", ",", "s"}], "]"}]}], ";", 
  RowBox[{"Ttf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     RowBox[{"T", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "1"}], ",", 
        RowBox[{"b", "\[Rule]", 
         RowBox[{"3", "\[Tau]"}]}]}], "}"}]}], ",", "s"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"utf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     RowBox[{"k", " ", "S0"}], ",", "s"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.673834996376019*^9, 3.673835029172271*^9}, {
   3.673835612178214*^9, 3.673835623888163*^9}, {3.673838615856608*^9, 
   3.673838638143847*^9}, 3.673841457901993*^9, {3.67384199638238*^9, 
   3.673841997965519*^9}},
 CellLabel->
  "In[3456]:=",ExpressionUUID->"49bf6539-e6d7-4505-a204-d813dc03a227"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"UnitStep", "[", "t", "]"}]}], ";", 
  RowBox[{"tmax", "=", "3"}], ";", 
  RowBox[{"u", "=", "t"}], ";", 
  RowBox[{"\[Tau]", "=", 
   FractionBox["1", "3"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yout", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Ttf", ",", "u", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";", " ", 
  RowBox[{"gout", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"gtf", ",", "u", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"uout", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"utf", ",", "u", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gout", ",", "yout", ",", "uout", ",", "u"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gout", ",", "yout", ",", "u"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{"p1", ",", "p2"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.673835045277884*^9, 3.673835199053227*^9}, {
   3.673835318324244*^9, 3.673835375368404*^9}, {3.673835560533099*^9, 
   3.6738355921700287`*^9}, {3.673835627056468*^9, 3.673835711862342*^9}, {
   3.67383578893856*^9, 3.673835880216304*^9}, {3.6738367678150177`*^9, 
   3.673836772756791*^9}, {3.6738414764762697`*^9, 3.673841555467814*^9}, {
   3.6738417670271177`*^9, 3.673841769001541*^9}, {3.673841826777176*^9, 
   3.673841859454154*^9}, {3.67384200708637*^9, 3.673842074024105*^9}, {
   3.673842105069062*^9, 3.67384215824085*^9}, {3.673869647281425*^9, 
   3.6738697483555717`*^9}, {3.673897813041842*^9, 3.673897825609639*^9}, {
   3.673901201551837*^9, 3.673901201668436*^9}, 3.673901495542952*^9},
 CellLabel->
  "In[3458]:=",ExpressionUUID->"f66157fa-fecf-4cae-8613-190e47952e37"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVlmc81gsDhq16pEFllDqUdYyKVMYp//svUpQQUVYeKysriaQiys7IyH6y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           "]]},
         Annotation[#, "Charting`Private`Tag$1990747#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVlHc01/sfx79WHzcaEhr2yki0kK7v852ouLlZIUkIlYTk2jJC1ldGUvla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           "]]},
         Annotation[#, "Charting`Private`Tag$1990747#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV13c81d8bAPAbca97r4wrIQlJykg2v+o5pAhFJSQkK1kpW2Yh2YVIZISo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           "]]},
         Annotation[#, "Charting`Private`Tag$1990747#3"]& ], 
        TagBox[
         {RGBColor[0.922526, 0.385626, 0.209179], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJxFxWlMknEcAODXE+cyczNWXvN8M12jVZbUvJtOy7Sa4BUFCpIRkivPNI+w
MmAqtWXm9cGp07WlS6flQSm+zaQ1Wc4VmqQVWHlgXoRUH/z9Pzx73FgZ59im
GIZF//P/9VP82tgMQeD2Zan7vN/hZ4K2H/s1my7GGfBiZ5iIh/PhErLOKRkv
hEdHoubO4xI4oyHrTQxeB8tEohfR+FPYwjKTpEkfgCNvMYXPaSNwdy5b1fRe
AU8mXqFkZo/DdhFijix4At6lZHccS/oIe7jyWoWsadhfdXU0pGoGlm0WnVbW
fIG5AwTRXzIHV6c0O+y+9A0+ED+zusXWwFO6GEVw5Dy8PL33IDnuJ1zRlpdG
py/AuK1VdE7NItwlKGqT1C/BSi8p6WzVMuxZOu59oVoHU2Onj9TXrMAqgTBQ
LPoNd1ATbIYrV2EybWSyRbgGB6mxylfX1+FqMtcGz9mAS+ou3/FL34RrFY/k
EoEeLuBLF50z/8DzTO89CSwDfN+gNZ/ibMG9PyIWdiYa4Q9e/urjnljw9tz9
KRRpE1pGS8oPcTGBD8drW+0b0bzS8IkAR1P4Lsdq00SK7nNmGrX2ZnDPVpmZ
jwSt6AzTiu3M4WFXjlxUhb7dHdc4Y20BJ7t/YiSJ0fouiqMvyRK+aaZ5+7AQ
TfakMr0wEpzNp61Y56KdjqYSeD560HDtSWgB2losPplXjK5rG3qguYeWfz/k
RzxG26fYZglfont8nKMa+9GMZR+XvkF0S3G4fGUIfaKhgJw6hmap5rtCp9Ck
po1yxmd0O490MU+NXtW7kzq+ossdEuluC2iKOs03YAmtbL1hjNehXaiVzRVr
6NdYfX77BppLtMcQevSOil6PWQP6GZ1YMxrRfwHMnDDX
           "]]},
         Annotation[#, "Charting`Private`Tag$1990747#4"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{1.8673469387755093`, 1.5000000000000568`}, {
       6.231703716424022, 0.5000000000000426}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {157.66435175953634, -98.27817431383762},
      ImageScaled[{0.5, 0.5}], {295.36555750831434, 187.19652250254785}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVlmc81gsDhq16pEFllDqUdYyKVMYp//svUpQQUVYeKysriaQiys7IyH6y
jxEyImRmZoSsrCcNlPVoqOg974f7d32+vly/e6+50zkrFiYmpk//7f/8cdox
SdvJmWBiSmWOf3/o2D3Lv8W7xM5i34tY7aoz75VezU3ZhYqZ4plT6iYhk21E
Ls9I6lCiNW5Kx9BCdh0gFp6qhDiIOaKn+Ggrf7MywS/x5vmfAVeczRnfr2Gu
Qyh5BB1sTXRH+cEyy3MbTQmzZiIrknoDF4jFc58GLxO+vIzdxmK34Mje4e7Z
5kK8LtZtjfx6B6dHHUS8dDwJy+H9ft8HfHHSSXyO38iH+MrMDuNKP1QJXGwq
5b1P3JOgr9Qm3sNC3opm+ddQgk+nqkT0dgBagzLTJTZEEdkeMU5B1CDUVkeM
OjXEEv+kOkvOq4RgwtBTt1s+iWhv1nivKxaG1Cctm2sraETB9W3axmzhMGP9
LB2rnEFcD76dH/Y1HNovRUWbFHMIMuUzR92HCJC813xp2fkE+9OLNoyBSHgE
OMwpaxQR3S9fNom2RuGHbfbUJHMJ8Wj4kPCFyofIrrniaLxWRpjPpd4Jyo0G
yXNMf/R4JSHJsmWsKjEGhb8jrcNfVxNLPF5H50Nj8Yl5pUR7sJZ4LvEpbu/t
ODQaO/AILNQTfkrnv+k6P8IF/XeKarJNxBmdet171HhwlyVRLqU2EzxW0kXP
ziXARmXEYu1oGzHmkbhlViURtU0jhyrXvyKcUt1btcSSQbPYZj4f20MolLwT
8+VLQZade1bFqV6CyVL8uCFbKjZ6HV1U4u4nWq9Hp4R8TcWomo1x6togUcB8
plPUkYaKVk4LbsERIjKYZbXmAw3dU7EKjiajhGGKk+HiwGNoVViG3t41SRAS
YoFB2mkw17+4/oMtnRB6+rZcuDUNbJS10/0t74jZl+o8+pXpsLOLFZqq+EB0
azOpzstmYIppX2bnmU9EyXCZa0BuBp7lGGQPLE4TN+eEuysTM1GScTWi5eoX
wsxjeE2XJwtxVVR5J515QpUlYv+X0CyUrNeevkhbIDbzrgUJ3s7G2c8Ch9oK
l4illJKKZ9+zcaslPux7M4N4I2H/Scc5B5F/9NOKp5eJZKXBE37Uf2FeJV4e
rvmd8G0Oc/tr+F/wU4N4tof/IC7rnEgrO5eLguTG2cnRFULGqphpWiUPhkJG
NcKJv4m6kJDnmmIFKFvb/Uhejxk1M0MdG3MKsD7VXlVMngVVp/4ea5V6guLN
75US9rLCiIXKlLajEHnubqkRm9fhfM0vIUGBIugktDWznNgAvSuPpW5dKkLU
88MB7pc5cG63+uHR1CIYrDDTLCI3QvtGzIkE4WL4MtZChFm2QEPuoA2fxFOY
pEwcITK34tT7AWd3u6eQKxB8uGa4DScf3vLsz30KZX6VaWfu7VBdag+KOlAC
74s32tKjuUEUWOdzHi7FMM0ne/g1H46ZbC5zvFaKK82Vq88LduDoppKaV2Wl
sJs2nat7sBMKdszdwYplOOAqtexG3YVDYolLFJTjSGNeD/sJQcj2H/9lfacc
e7w59naL7oGM3zTry7pyLFnJe37M3YMDdDkeP9Vn6DuVVBxduxfiyT3yTBoV
2D3jN/1skwjEND3IS8EV0PJIVJHMEoHobwH1mo4KjElxmKaqikLI0MHwplYl
lrYVdZUGiGE3L8X7h95zjE0QrsflJMDflO9vEPMcSbZRj2OmJbDTTS+sbOA5
LI54+oumSoL3NS3FzbAKVi6hRlv49oEr7Fj9wqVqKHjNcLfuk8a69a6UabsX
aLS7Gza1JotP6rc5GVkvwBZVKSnucAhtoSF8q1MvsPL25yrLyCE0B/VGBUjX
4rHletXA6sMI3jaXlphTC3L2IF0kRg7cQsKNjUl1OGeywDoV+w/WNUq0qFfV
YXlV7vew4FF8s5Lp6ByuQyTtlFJUzlEM5ij1DfLV40Deq1md+mNIOnhh6nNE
Pfo+WihobwDElEPZeO41gGNiGa3flcH3Loo9Pr0Btw57ddtqHAe7f/wmwYYG
nLhtk/Mn6ThmWrK4JZgawXLew4TrlAqeaNeLKN1oxA+1+oLPWapQMPuuauXY
hLstHQcyY09C/TbVv1S/GW30b/xGOAvZB3VqNLdmlOlVdb4oPIvdKXvZQyOb
cSqP4+IRYS0s1EwGWXY242B4XWHuOm3ErFHDt6u1wFCvX+L0sjamvM0TXI60
QvJsgOjv2XPoDK03NtFtxZSZb/P1/bp4liQkoO7SCr8tKqV+TroIrqan7slv
xZ1GhTy9r7qQXTXP7BJpQyR1KPwt5Tzu3LQo2s/djkL/RA92dQPYhTS47pRt
x4Jkje5IlAH0EoUPr9NuR+4WTflT4wb4u+pd2dvgdhxkBHEuXb+Azl8WVcGs
HdB769IeVXgRu70sm6eXOlAZopztDWOUe1qNZvR04tK/6hcKZs2QSdgP8C91
4s2enXJKglTEsLr0PNjWhbnYylVpXSrcQ282eep2Id2DNeR4FRVytKh8zf4u
zMYlOolEmcNoaqLmhkM3Kn/a/LtXzxLDGzkfCDn3wD5nbqeMqA3OzW3dZHKn
B/q3nBTfWNmgrZs7MDa8B/mBjvPTmTaojOa/u6moB/VXo44ZSdoiXlDs+rfF
Hpz5sF/qipwdDA8pXWq7+hon27UGQiwcMGRoL+16vRcf32nmDQQ6I4h+0iH2
Xi/S1A4nZRQ44x87kZyq6F40zrSKZ/U6I9FzVIhS0osCZgG/EwIuMIvT4k1c
6EWl3yXbpVIXfOw/tNpk24coc2khkXlXfNX+3bbTuB9n/CQVkwOvIXNwkAL7
fsicuWW/vfQa9M1KVS1v9CPSkn7/xcS1/36EY01BXD/2c1E/Vim442bYRJFK
fz8Kt4/v1pp1B2tHY9yVs2/g3Lcdnww9sPVkqHUdOYBsDkEKzdILqjlVkNIZ
wPilyGjzBC94bPy8I5o6AK51wto2r70w0aXRbuM7AE6NxFpS+SYKL7DLcDUO
wG3DfJe4kDe07e6umJ4cRGApX+H8wi2Eh3qG/NYcgiypavSQ6oPG+Wwra9Mh
zN8/Vabn44MfOoNEt+MQ3nXpsCjSfGDGK7+Y9mAIhldtH1+Z9IFMyvL50z1D
YKGlXQuw8EV3oZNgvN4wfhr++PPA8S64+qyK5Y1GkHC5laqS6g/yi/KMnv0I
dPty7y42+MN5vYCQq9cIqLkO9IaP/uhReBORlzCCa1efBPRL30NkkprL3rcj
YLI5PpBfdw88l/+W2WjyFqNydGulz/fB//NT/pjpKFbPVuyUMAmC8B6HHH/z
ceQmiJenFj5AyNheWqjLOKR1Ft88GX6Ab4kDcdF3xiF1ntvdmSUcLTtVAjKS
x1HCpBncty8cDtv5LzcNj+OPVIOIrW84jFgtI30lJvBK/EVws0wEMr5t1a6n
TaDManDaLT4SCqNX2pUjJ0E/linr9DgaBRKuPDbxk9A9Yxq4Uh0NEXf3S2GP
J+HxYs9S3FA0uDhvM4aLJyGUoMjBtzUG02T4LrfeSbx/8rmZyycG8enF9pnc
dOiHTW1bs4zFb/vvGzfG0rG2w/vp22OPUPfzzpm+hHegH6H6hu9Pgs2LlpYa
3/doGW3u2vf8MR5ZZPHzmH2Ef5bwySHLLOy/MPltzWoa9aGhcbtF8zHG0Ook
1WfBeSf6g2hMEZbGd8rwnv+CzgXRAmGFUoTn3rhsYDAP90dc75LFKyDGya7p
kbDwX68OuJdJVqPM+U5uWMoitJa1RT0WatEnGkXRiVxCVmB62AatBojc7RU3
ecTAcz4uA3/Ol1DUHj+ckrCMYJ73QjeXWjDq7E+EhnzF8PKAc9yrdhQrXtzc
FPENyxXhJX9t7wKvfvNQtv933EwZVIZoD0Bniqh3+wGr9Ebh6fbXeMRrs1nM
YwUWFixshrl98E22vX/E7id8+FRXV7zfIKkz7mWY8y9wE5qykiGD8HaMWvjL
9Teq7p8d+pI+jFmq+I6L5qtgGcxMFsp9i+DVGbYx6zW4GyVSqubHUPn55PwW
wz94fSUm2/jBBN6IKtD/EWEi9WVWhHfkTMJGwkI6KoOJfCLMXSX/jo46fSMv
ZQFmsiTCPfgr5xQOXZjJ4aYxk+c13thxmb6Hw121AaVdLOSmkIGdlkkfEGDN
/pM5ioUsOKLZKTD6EdV/Uf/McLOSgT2tvsKYRsXaPVbJMFaygLA/wBM+g86n
KjOhW9lIy8NNp3jZPqNpj/XLkEg2csGrJZzF4wv8ys/TJjnWkRROY77ywTkY
C701NQpdRyYeszgRf2ABv8qkd0lR1pPXe/jx5MMCbrJOd0TfWk+mKtsWJSUt
gldEkSrKRCEfmmXQa6yXcN1Rf5nDk0IGym8x6RVhYLecZYuYF4VUFLhxVEKc
gdpVl8Tj3hSy9J6a2m0pBjhCQ1Vv+FDI5JP0CSlZBpJzGx9OB1LIYlctiftg
4OUn2SMt8RTybKUWk5ohA9wWnO7+VRTyhat5xNQDBiok/9Kg1VDIfZJbviCK
AdMlSYHqWgrpUS7qlhDDQLaP2svlRgopVePJppvEwNFUb17LVxQyxGp8X+O/
DJiPzpYdH6OQZTYL0QVNDFAyVoJMJygkVhrSN7UykOdAuXSDTiHzNwSO2XUw
8O2XEKX4A4Ws5m59/XcvA0H8hgZ75//zq9aoTptgQJp+WUppkULekusTYp1i
oC/n2p8LDAqZx7btqflHBgQUI7LCv1NIdY4QXaE5BhqYUrzyVijkj2/PLHwX
GbBpydNq+UUht6d5JdOXGdgUXik8tUohFWw7WFV+MFBk0PL9zx8KuSk9LSrt
FwP/A1Kh5/4=
           "]]},
         Annotation[#, "Charting`Private`Tag$1990799#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVlHc01/sfx79WHzcaEhr2yki0kK7v852ouLlZIUkIlYTk2jJC1ldGUvla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           "]]},
         Annotation[#, "Charting`Private`Tag$1990799#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJxFxWlMknEcAODXE+cyczNWXvN8M12jVZbUvJtOy7Sa4BUFCpIRkivPNI+w
MmAqtWXm9cGp07WlS6flQSm+zaQ1Wc4VmqQVWHlgXoRUH/z9Pzx73FgZ59im
GIZF//P/9VP82tgMQeD2Zan7vN/hZ4K2H/s1my7GGfBiZ5iIh/PhErLOKRkv
hEdHoubO4xI4oyHrTQxeB8tEohfR+FPYwjKTpEkfgCNvMYXPaSNwdy5b1fRe
AU8mXqFkZo/DdhFijix4At6lZHccS/oIe7jyWoWsadhfdXU0pGoGlm0WnVbW
fIG5AwTRXzIHV6c0O+y+9A0+ED+zusXWwFO6GEVw5Dy8PL33IDnuJ1zRlpdG
py/AuK1VdE7NItwlKGqT1C/BSi8p6WzVMuxZOu59oVoHU2Onj9TXrMAqgTBQ
LPoNd1ATbIYrV2EybWSyRbgGB6mxylfX1+FqMtcGz9mAS+ou3/FL34RrFY/k
EoEeLuBLF50z/8DzTO89CSwDfN+gNZ/ibMG9PyIWdiYa4Q9e/urjnljw9tz9
KRRpE1pGS8oPcTGBD8drW+0b0bzS8IkAR1P4Lsdq00SK7nNmGrX2ZnDPVpmZ
jwSt6AzTiu3M4WFXjlxUhb7dHdc4Y20BJ7t/YiSJ0fouiqMvyRK+aaZ5+7AQ
TfakMr0wEpzNp61Y56KdjqYSeD560HDtSWgB2losPplXjK5rG3qguYeWfz/k
RzxG26fYZglfont8nKMa+9GMZR+XvkF0S3G4fGUIfaKhgJw6hmap5rtCp9Ck
po1yxmd0O490MU+NXtW7kzq+ossdEuluC2iKOs03YAmtbL1hjNehXaiVzRVr
6NdYfX77BppLtMcQevSOil6PWQP6GZ1YMxrRfwHMnDDX
           "]]},
         Annotation[#, "Charting`Private`Tag$1990799#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{10.03061224489796, 1.5000000000000568`}, {
       6.231703716424022, 0.5000000000000426}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {477.07468793167027, -98.27817431383762},
      ImageScaled[{0.5, 0.5}], {303.5288228144368, 187.19652250254785}]}, {}},
  
  ImageSize->{
    UpTo[600], 
    UpTo[223]},
  PlotRange->{{0, 638.8206723442679}, {-196.55634862767525`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.673842027976285*^9, 3.673842074725449*^9}, {
   3.673842117741027*^9, 3.673842158823618*^9}, 3.6738695930449467`*^9, {
   3.6738696480420856`*^9, 3.673869664245459*^9}, {3.673869708904854*^9, 
   3.6738697541673117`*^9}, {3.673897809712616*^9, 3.6738978302999487`*^9}, {
   3.673901208307514*^9, 3.6739012155190353`*^9}, 3.67390149780925*^9, 
   3.6739016368837*^9, 3.6739026905942717`*^9, 3.7938436160871553`*^9, 
   3.793843669623097*^9, 3.823229781434642*^9},
 CellLabel->
  "Out[3463]=",ExpressionUUID->"4351d538-0381-4b1a-b0c2-30c65e7b4397"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"kold", "=", 
    RowBox[{"TransferFunctionModel", "[", 
     RowBox[{
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], "2"], 
       RowBox[{"\[Tau]", " ", "s", 
        RowBox[{"(", 
         RowBox[{"2", "+", 
          RowBox[{"\[Tau]", " ", "s"}]}], ")"}]}]], ",", "s"}], "]"}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"for", " ", "tracking", " ", "step", " ", "only"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.673869468897634*^9, 3.673869525219407*^9}, {
   3.673869556674594*^9, 3.673869570071579*^9}, 3.6738697499535723`*^9, 
   3.673897805068623*^9},
 CellLabel->
  "In[3464]:=",ExpressionUUID->"5afa7a53-d2f9-40b8-947f-bffc59402c89"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BodePlot", "[", 
   RowBox[{"{", 
    RowBox[{"k", ",", "kold"}], "}"}], "]"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "compare", " ", "the", " ", "controllers", " ", "for", " ", "tracking", 
      " ", "step"}], " ", "&"}], " ", "ramp"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.673842170620171*^9, 3.6738421762572327`*^9}, {
   3.67384229257551*^9, 3.6738423345865593`*^9}, 3.673842369076045*^9, {
   3.673842401690982*^9, 3.673842422567264*^9}, {3.673842496550152*^9, 
   3.673842523108716*^9}, {3.673869530307889*^9, 3.6738695329072857`*^9}, {
   3.6738695730715513`*^9, 3.673869587519154*^9}},
 CellLabel->
  "In[3465]:=",ExpressionUUID->"4de98ff3-1a8e-4108-80b4-d5392560bb34"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV13k4VF8fAPAZkggtVFJJSj9lnSHLzOV8lWwJiRQRpbJU1gotpJIkItEm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           "]]},
         Annotation[#, "Charting`Private`Tag$1993760#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1nc81d8fB/B7FSJpaKAS917cbJd8M89bKTM0qIyGUUYRyWhKpVAqI0Vl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           "]]},
         Annotation[#, "Charting`Private`Tag$1993760#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-3., 9.42008441305086},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{0., 
           FormBox["0", TraditionalForm]}, {25., 
           FormBox["25", TraditionalForm]}, {50., 
           FormBox["50", TraditionalForm]}, {75., 
           FormBox["75", TraditionalForm]}, {100., 
           FormBox["100", TraditionalForm]}, {125., 
           FormBox["125", TraditionalForm]}, {150., 
           FormBox["150", TraditionalForm]}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {65., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {85., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {90., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {95., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {105., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {110., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {115., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {120., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {125., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {125., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {130., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {135., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {140., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {145., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {150., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {69.48125909632175, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {75., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {125., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {65., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {70., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {85., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {90., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {95., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {105., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {110., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {115., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {120., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {125., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {125., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {130., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {135., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {140., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {145., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-3., 
           FormBox["0.001`", TraditionalForm]}, {-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-3., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-2.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-3., 2.255272505103306}, {9.42008441305086, 
       129.54243377959264`}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-3., 
          FormBox["0.001`", TraditionalForm]}, {-2., 
          FormBox["0.01`", TraditionalForm]}, {-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {-2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.5228787452803374`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.221848749616356, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0969100130080562`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0457574905606752`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.5228787452803376`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.2218487496163564`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.0969100130080565`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.045757490560675, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{0., 
          FormBox["0", TraditionalForm]}, {25., 
          FormBox["25", TraditionalForm]}, {50., 
          FormBox["50", TraditionalForm]}, {75., 
          FormBox["75", TraditionalForm]}, {100., 
          FormBox["100", TraditionalForm]}, {125., 
          FormBox["125", TraditionalForm]}, {150., 
          FormBox["150", TraditionalForm]}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {65., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {85., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {90., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {95., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {105., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {110., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {115., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {120., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {125., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {125., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {130., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {135., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {140., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {145., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {150., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {69.48125909632175, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1nc8ld8fAPBr3UsIEZJkhaLcyr5yjlJGRmn5qmTce5OMjDLKiCQlSaSl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           "]]},
         Annotation[#, "Charting`Private`Tag$1994349#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV13c81P8fAPCzJRkZyVeykmySdZf3W1bDCHeXlIysyCqVqAhFUiRKg1DZ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           "]]},
         Annotation[#, "Charting`Private`Tag$1994349#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-3., -179.83447887557801`},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-200., 
           FormBox[
            RowBox[{"-", "200"}], TraditionalForm]}, {-150., 
           FormBox[
            RowBox[{"-", "150"}], TraditionalForm]}, {-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {-50., 
           FormBox[
            RowBox[{"-", "50"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {50., 
           FormBox["50", TraditionalForm]}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-190., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-170., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-130., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-110., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-75.79652779369508, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-190., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-170., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-130., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-110., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-3., 
           FormBox["0.001`", TraditionalForm]}, {-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-3., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-2.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-3., 2.255272505103306}, {-179.83447887557801`, 
       28.241423288187875`}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-3., 
          FormBox["0.001`", TraditionalForm]}, {-2., 
          FormBox["0.01`", TraditionalForm]}, {-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {-2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.5228787452803374`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.221848749616356, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0969100130080562`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0457574905606752`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.5228787452803376`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.2218487496163564`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.0969100130080565`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.045757490560675, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-200., 
          FormBox[
           RowBox[{"-", "200"}], TraditionalForm]}, {-150., 
          FormBox[
           RowBox[{"-", "150"}], TraditionalForm]}, {-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {-50., 
          FormBox[
           RowBox[{"-", "50"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {50., 
          FormBox["50", TraditionalForm]}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-190., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-180., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-170., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-160., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-150., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-150., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-140., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-130., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-120., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-110., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-90., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-75.79652779369508, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.6738421780112457`*^9, {3.673842299508231*^9, 3.6738423359037323`*^9}, 
   3.673842370728266*^9, {3.673842404636586*^9, 3.673842423292481*^9}, {
   3.673842505574526*^9, 3.673842523758746*^9}, {3.673869533609248*^9, 
   3.6738695400325613`*^9}, 3.673869593528687*^9, 3.673869755017742*^9, {
   3.673897810278515*^9, 3.673897830845646*^9}, 3.673901216031362*^9, 
   3.673901637577129*^9, 3.6739026912435083`*^9, 3.793843616530719*^9, 
   3.793843670114442*^9, 3.823229781917107*^9},
 CellLabel->
  "Out[3465]=",ExpressionUUID->"96a2c573-b272-4d98-81e4-1b272ee09521"]
}, Open  ]],

Cell["Export data.", "Text",
 CellChangeTimes->{{3.66992287369807*^9, 3.669922881340234*^9}, {
  3.66999623590873*^9, 3.669996246227051*^9}, {3.6700050664140587`*^9, 
  3.6700050757246113`*^9}, {3.6700951338704367`*^9, 3.670095144757069*^9}, {
  3.673901663124858*^9, 3.673901664331604*^9}, {3.793843696633079*^9, 
  3.793843697080699*^9}},
 FontSize->18,
 Background->GrayLevel[
  0.85],ExpressionUUID->"0021c800-4daf-47c0-a292-e7b83fbf7ef6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dt", "=", "0.01"}], ";", 
  RowBox[{"dat", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"yout", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"uout", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"gout", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax", ",", "dt"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6739015622368813`*^9, 3.673901600702044*^9}, {
  3.673902670536315*^9, 3.673902680055038*^9}, {3.7938435988630877`*^9, 
  3.793843608532384*^9}},
 CellLabel->
  "In[3466]:=",ExpressionUUID->"f0b03ba4-915e-4056-8657-c82611de1f38"],

Cell[BoxData[
 RowBox[{"(*", "  ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<IMCramp1.dat\>\"", ",", " ", "dat"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.673901616573801*^9, 3.6739016472842712`*^9}, {
  3.673901983344018*^9, 3.673901986213756*^9}, {3.673902682382867*^9, 
  3.673902698316909*^9}, {3.673902799573565*^9, 3.6739028021632967`*^9}, {
  3.674137645990871*^9, 3.674137648440385*^9}, {3.7938435778168716`*^9, 
  3.793843592075171*^9}, {3.79384366127221*^9, 3.7938436653718*^9}},
 CellLabel->
  "In[3467]:=",ExpressionUUID->"c1f5e98d-3a8a-40cf-b797-c1cd789bc1bc"]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 131}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"c62d62e1-7c95-4259-b6ce-552a8e87d47b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 176, 3, 67, "Section",ExpressionUUID->"4e1fd316-267c-423a-a071-ff518d5ae5ac"],
Cell[759, 27, 175, 4, 30, "Input",ExpressionUUID->"0f810280-2c22-497f-92ad-f3ae5e70e725"],
Cell[CellGroupData[{
Cell[959, 35, 1116, 32, 78, "Input",ExpressionUUID->"c407f64c-d30a-41c2-bf16-3cf239acbc54"],
Cell[2078, 69, 826, 17, 55, "Output",ExpressionUUID->"a33d101f-dbbc-45a2-9523-0aabc105fa9a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2941, 91, 304, 7, 30, "Input",ExpressionUUID->"fcbac1e7-313d-4be7-8f7e-0db21fb7e571"],
Cell[3248, 100, 1056, 24, 57, "Output",ExpressionUUID->"6950831c-9c9c-405b-82d8-0ab523411a7d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4341, 129, 366, 10, 30, "Input",ExpressionUUID->"f77be348-0b7a-47f5-b6ae-b3935c77dcac"],
Cell[4710, 141, 783, 20, 57, "Output",ExpressionUUID->"a7197706-c099-4c95-ae16-996c76fd4e75"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5530, 166, 436, 12, 30, "Input",ExpressionUUID->"430d829b-0c88-4442-9cc3-623037780829"],
Cell[5969, 180, 994, 25, 55, "Output",ExpressionUUID->"36d295cf-daff-4f9f-a55b-ba575d85be2e"]
}, Open  ]],
Cell[6978, 208, 931, 25, 73, "Input",ExpressionUUID->"49bf6539-e6d7-4505-a204-d813dc03a227"],
Cell[CellGroupData[{
Cell[7934, 237, 2430, 61, 155, "Input",ExpressionUUID->"f66157fa-fecf-4cae-8613-190e47952e37"],
Cell[10367, 300, 34346, 609, 207, "Output",ExpressionUUID->"4351d538-0381-4b1a-b0c2-30c65e7b4397"]
}, Open  ]],
Cell[44728, 912, 768, 22, 52, "Input",ExpressionUUID->"5afa7a53-d2f9-40b8-947f-bffc59402c89"],
Cell[CellGroupData[{
Cell[45521, 938, 758, 17, 30, "Input",ExpressionUUID->"4de98ff3-1a8e-4108-80b4-d5392560bb34"],
Cell[46282, 957, 102047, 1935, 253, "Output",ExpressionUUID->"96a2c573-b272-4d98-81e4-1b272ee09521"]
}, Open  ]],
Cell[148344, 2895, 443, 8, 54, "Text",ExpressionUUID->"0021c800-4daf-47c0-a292-e7b83fbf7ef6"],
Cell[148790, 2905, 769, 21, 30, "Input",ExpressionUUID->"f0b03ba4-915e-4056-8657-c82611de1f38"],
Cell[149562, 2928, 768, 15, 124, "Input",ExpressionUUID->"c1f5e98d-3a8a-40cf-b797-c1cd789bc1bc"]
}, Open  ]]
}
]
*)

