(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     88504,       2100]
NotebookOptionsPosition[     83188,       2001]
NotebookOutlinePosition[     83584,       2017]
CellTagsIndexPosition[     83541,       2014]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Calculations for 2 and \[Infinity] norms  (Problem 9.10)", "Section",
 CellChangeTimes->{{3.6730182614303503`*^9, 3.673018277264526*^9}, {
  3.793844056590824*^9, 
  3.7938440637953043`*^9}},ExpressionUUID->"96f83ec2-9a6e-4eb3-94e4-\
dc607d7e9f05"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[3428]:=",ExpressionUUID->"b79f195c-f649-471b-ad39-6b95a2c7a9cb"],

Cell["For 2nd-order system", "Text",
 CellChangeTimes->{{3.673034524254158*^9, 3.673034536938068*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"acb6167d-1692-4a46-9718-76ddfc7071a7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "\[Zeta]", " ", "s"}], " ", "+", " ", 
     SuperscriptBox["s", "2"]}]]}], ";", " ", 
  RowBox[{"gtf", " ", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"g", ",", "s"}], "]"}]}], ";", " ", 
  RowBox[{"gss", "=", 
   RowBox[{"StateSpaceModel", "[", "gtf", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pinf", "=", 
   RowBox[{"ControllabilityGramian", "[", "gss", "]"}]}], ";", " ", 
  RowBox[{"TraditionalForm", "[", "pinf", "]"}]}]}], "Input",
 CellChangeTimes->{{3.6730179786129007`*^9, 3.67301815782975*^9}, {
  3.673018802359273*^9, 3.673018826003306*^9}},
 CellLabel->
  "In[3429]:=",ExpressionUUID->"d9379375-8a51-4924-83a5-49c62418c665"],

Cell[BoxData[
 TemplateBox[{"0", "1", "0", 
   RowBox[{"-", "1"}], 
   RowBox[{
     RowBox[{"-", "2"}], " ", "\[Zeta]"}], "1", "1", "0", "0", 
   InterpretationBox["\[InvisibleSpace]", None], {
   StateSpaceModel, {
    False, False, {
     False, False}}, {$CellContext`stname1, $CellContext`stname2}, {{
     Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, Identity, 
    Automatic, 1, 1, 2, 1, {}, {False, False}, False, Automatic, None, 
    Automatic}, {}},
  "StateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{#, #2, #3}, {#4, #5, #6}, {#7, #8, #9}}, 
        AllowedDimensions -> {3, 3}, 
        GridBoxDividers -> {"Rows" -> {False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}, "Columns" -> {False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
        "SystemsModelGrid00"], ")"}], #10, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalS]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None], MultilineFunction -> None], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{1, 2}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{4, 5}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{3, 3}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{6, 6}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{7, 8}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{9, 9}, ","], "}"}], "}"}], "}"}], ",", 
     "SamplingPeriod", "->", 
     RowBox[{#10}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
  Tooltip->StateSpaceModel]], "Output",
 CellChangeTimes->{
  3.6730180438786993`*^9, {3.673018115069681*^9, 3.673018124806072*^9}, 
   3.673018158912016*^9, 3.673018826645314*^9, 3.6730346201049643`*^9, 
   3.673037043654047*^9, 3.673038237950368*^9, 3.673041543627508*^9, 
   3.673093078456978*^9, 3.673123114634706*^9, 3.7938440763898067`*^9, 
   3.793844851160781*^9, 3.8232297698487997`*^9},
 CellLabel->
  "Out[3429]=",ExpressionUUID->"b9d47c0b-f1c8-4e52-bfce-9e39feb73f49"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["1", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          TemplateBox[{"\[Zeta]"},
           "Conjugate"], "+", "\[Zeta]"}], ")"}]}]], "0"},
     {"0", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          TemplateBox[{"\[Zeta]"},
           "Conjugate"], "+", "\[Zeta]"}], ")"}]}]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.6730180438786993`*^9, {3.673018115069681*^9, 3.673018124806072*^9}, 
   3.673018158912016*^9, 3.673018826645314*^9, 3.6730346201049643`*^9, 
   3.673037043654047*^9, 3.673038237950368*^9, 3.673041543627508*^9, 
   3.673093078456978*^9, 3.673123114634706*^9, 3.7938440763898067`*^9, 
   3.793844851160781*^9, 3.823229769854294*^9},
 CellLabel->
  "Out[3430]//TraditionalForm=",ExpressionUUID->"d9ac336f-40e0-4756-a3e9-\
273aebab922c"]
}, Open  ]],

Cell["Solve Lyapunov equation by \[OpenCurlyDoubleQuote]hand\
\[CloseCurlyDoubleQuote]:", "Text",
 CellChangeTimes->{{3.673034524254158*^9, 3.673034536938068*^9}, {
  3.673036211943266*^9, 3.6730362188215857`*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"79b1fb9c-a834-4310-90d0-3554b66d2d4d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"p1", "p12"},
      {"p12", "p2"}
     }], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"a", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "1"},
      {
       RowBox[{"-", "1"}], 
       RowBox[{
        RowBox[{"-", "2"}], "\[Zeta]"}]}
     }], "\[NoBreak]", ")"}]}], ";", " ", 
  RowBox[{"b", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0"},
      {"1"}
     }], "\[NoBreak]", ")"}]}], ";", " ", 
  RowBox[{"lyap", "=", 
   RowBox[{
    RowBox[{"a", ".", "p"}], "+", 
    RowBox[{"p", ".", 
     RowBox[{"a", "\[Transpose]"}]}], "+", 
    RowBox[{"b", ".", 
     RowBox[{"b", "\[Transpose]"}]}]}]}], ";", 
  RowBox[{"TraditionalForm", "[", "lyap", "]"}]}]], "Input",
 CellChangeTimes->{{3.673036223022255*^9, 3.673036286508917*^9}, {
  3.6730365379772453`*^9, 3.673036581632876*^9}, {3.6730367010114937`*^9, 
  3.6730367372886457`*^9}, {3.673036874098792*^9, 3.6730368751996193`*^9}, {
  3.673036967525198*^9, 3.673036967612265*^9}, {3.673037034205276*^9, 
  3.6730370343086367`*^9}},
 CellLabel->
  "In[3431]:=",ExpressionUUID->"e90af786-4992-4834-89b7-6b1c168060af"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"2", " ", "p12"}], 
      RowBox[{
       RowBox[{"-", "p1"}], "-", 
       RowBox[{"2", " ", "\[Zeta]", " ", "p12"}], "+", "p2"}]},
     {
      RowBox[{
       RowBox[{"-", "p1"}], "-", 
       RowBox[{"2", " ", "\[Zeta]", " ", "p12"}], "+", "p2"}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"2", " ", "p12"}]}], "-", 
       RowBox[{"4", " ", "\[Zeta]", " ", "p2"}], "+", "1"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.673036281428461*^9, 3.673036287029728*^9}, 
   3.67303658445396*^9, {3.673036709056389*^9, 3.6730367385753593`*^9}, 
   3.673036877041857*^9, 3.673036969560822*^9, 3.673037043734838*^9, 
   3.6730382380205708`*^9, 3.673041543694374*^9, 3.673093078574318*^9, 
   3.673123114704*^9, 3.7938440764498053`*^9, 3.7938448512156553`*^9, 
   3.823229769909566*^9},
 CellLabel->
  "Out[3431]//TraditionalForm=",ExpressionUUID->"2a239462-f467-40b0-a2f9-\
90806cf864cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"lyap", "==", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0"},
       {"0", "0"}
      }], "\[NoBreak]", ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p12"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6730367404211493`*^9, 3.6730367628556623`*^9}, {
  3.6730369748290043`*^9, 3.673036975828517*^9}, {3.673037040028858*^9, 
  3.67303704071509*^9}},
 CellLabel->
  "In[3432]:=",ExpressionUUID->"0e6cc0b5-dd84-4ebf-96ca-49a5bb7ae1a7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p1", "\[Rule]", 
     FractionBox["1", 
      RowBox[{"4", " ", "\[Zeta]"}]]}], ",", 
    RowBox[{"p2", "\[Rule]", 
     FractionBox["1", 
      RowBox[{"4", " ", "\[Zeta]"}]]}], ",", 
    RowBox[{"p12", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.673036763322843*^9, 3.6730368804932127`*^9, 
  3.673036976468053*^9, 3.673037043804335*^9, 3.67303823806916*^9, 
  3.673041543745349*^9, 3.673093078641223*^9, 3.673123114769692*^9, 
  3.793844076455378*^9, 3.793844851222019*^9, 3.823229769915586*^9},
 CellLabel->
  "Out[3432]=",ExpressionUUID->"a80757f4-3ff9-4730-ae92-4cf8fa822044"]
}, Open  ]],

Cell["Solve using Mathematica\[CloseCurlyQuote]s built-in routine:", "Text",
 CellChangeTimes->{{3.673034524254158*^9, 3.673034536938068*^9}, {
  3.673036211943266*^9, 3.6730362188215857`*^9}, {3.673036471789358*^9, 
  3.67303647896347*^9}, {3.793844698590385*^9, 3.793844700114687*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"b097d944-f8c6-4eac-8ade-a0a7aa92ba2b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LyapunovSolve", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", 
      RowBox[{"b", ".", 
       RowBox[{"b", "\[Transpose]"}]}]}]}], "]"}], "//", "FullSimplify"}], "//",
   "TraditionalForm"}]], "Input",
 CellChangeTimes->{{3.6730364811577682`*^9, 3.673036524274411*^9}, {
  3.6730365908939962`*^9, 3.673036598134823*^9}, {3.673036636829764*^9, 
  3.6730366648911667`*^9}, {3.793844777715399*^9, 3.793844831784678*^9}},
 CellLabel->
  "In[3433]:=",ExpressionUUID->"65dc8975-6e50-49d0-ac9b-eebcf6e18578"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["1", 
       RowBox[{"4", " ", 
        RowBox[{"Re", "(", "\[Zeta]", ")"}]}]], "0"},
     {"0", 
      FractionBox["1", 
       RowBox[{"4", " ", 
        RowBox[{"Re", "(", "\[Zeta]", ")"}]}]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.79384481684017*^9, 3.793844851241064*^9}, 
   3.82322976993511*^9},
 CellLabel->
  "Out[3433]//TraditionalForm=",ExpressionUUID->"a800f436-4e05-4839-a7d5-\
09366745f85d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"gmag", "=", 
   FractionBox["1", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["\[Omega]", "2"]}], ")"}], "2"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[Zeta]", "2"], 
       SuperscriptBox["\[Omega]", "2"]}]}]]]}], ";"}]], "Input",
 CellChangeTimes->{{3.6730415275440817`*^9, 3.673041541193202*^9}},
 CellLabel->
  "In[3434]:=",ExpressionUUID->"50bc33e8-3d97-4793-9c9d-41e4cf74c5c7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"dmag", "=", 
   RowBox[{"D", "[", 
    RowBox[{"gmag", ",", "\[Omega]"}], "]"}]}], ";", "  ", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"dmag", "\[Equal]", "0"}], ",", "\[Omega]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.67304164146911*^9, 3.6730416672142363`*^9}},
 CellLabel->
  "In[3435]:=",ExpressionUUID->"38b5903d-4287-47e7-8000-e0c177d36fe9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Omega]", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[Zeta]", "2"]}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", "\[Rule]", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[Zeta]", "2"]}]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.673041649485218*^9, 3.673041667760248*^9}, 
   3.673093078756104*^9, 3.673123114909679*^9, 3.793844076492751*^9, 
   3.7938448512626123`*^9, 3.8232297699569798`*^9},
 CellLabel->
  "Out[3435]=",ExpressionUUID->"b48848a4-fea9-4416-a917-c24fdeff7f3b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["dmag"], "Input",
 CellChangeTimes->{{3.673043597944519*^9, 3.673043599193018*^9}},
 CellLabel->
  "In[3436]:=",ExpressionUUID->"57c96661-98e4-49e7-aa90-993252fc42dd"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"8", " ", 
     SuperscriptBox["\[Zeta]", "2"], " ", "\[Omega]"}], "-", 
    RowBox[{"4", " ", "\[Omega]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Omega]", "2"]}], ")"}]}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["\[Zeta]", "2"], " ", 
        SuperscriptBox["\[Omega]", "2"]}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Omega]", "2"]}], ")"}], "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]]}]], "Output",
 CellChangeTimes->{3.6730435999362183`*^9, 3.673093078807766*^9, 
  3.673123114940535*^9, 3.793844076520287*^9, 3.793844851268998*^9, 
  3.8232297699627132`*^9},
 CellLabel->
  "Out[3436]=",ExpressionUUID->"70c6c34c-c5de-42e5-9177-0e12ffb4dd21"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"dmag", ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.673041951231491*^9, 3.673041978657392*^9}},
 CellLabel->
  "In[3437]:=",ExpressionUUID->"9d385f66-0c19-4861-a9f9-73a32ca638d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[Zeta]", "2"]}]}], ")"}], " ", "\[Omega]"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Omega]", "]"}], "3"],
    SeriesData[$CellContext`\[Omega], 0, {}, 1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Omega], 0, {(-2) (-1 + 2 $CellContext`\[Zeta]^2)},
    1, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.673041979067833*^9, 3.673093078855323*^9, 
  3.6731231150035677`*^9, 3.793844076548922*^9, 3.793844851291439*^9, 
  3.8232297699812737`*^9},
 CellLabel->
  "Out[3437]=",ExpressionUUID->"b15c1419-86a5-46cd-8ec5-85bc4076073d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gmagmax", "=", 
  RowBox[{
   RowBox[{"gmag", "/.", 
    RowBox[{"\[Omega]", "\[Rule]", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[Zeta]", "2"]}]}]]}]}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.673041685281747*^9, 3.6730417001193323`*^9}, {
  3.6730417446233673`*^9, 3.673041747134014*^9}},
 CellLabel->
  "In[3438]:=",ExpressionUUID->"660762ad-2681-4410-b8c5-30cca4bc6b5f"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["\[Zeta]", "2"], "-", 
     SuperscriptBox["\[Zeta]", "4"]}]]}]]], "Output",
 CellChangeTimes->{{3.67304169581513*^9, 3.673041700582233*^9}, 
   3.673041748053513*^9, 3.673093078909505*^9, 3.673123115069139*^9, 
   3.793844076557466*^9, 3.793844851310317*^9, 3.823229769990102*^9},
 CellLabel->
  "Out[3438]=",ExpressionUUID->"1e30c75f-6d4d-49ec-a9ce-182e6d717b67"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gmagmax", "/.", 
  RowBox[{"\[Zeta]", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"0.1", ",", "0.2", ",", "0.5", ",", "0.9"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.673041750481938*^9, 3.67304176263181*^9}, {
  3.673041802565608*^9, 3.673041803163499*^9}},
 CellLabel->
  "In[3439]:=",ExpressionUUID->"30b4e095-8b35-4f89-8e5b-8ba8720a2e35"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.02518907629606`", ",", "2.5515518153991437`", ",", "1.1547005383792517`",
    ",", "1.2745318548364546`"}], "}"}]], "Output",
 CellChangeTimes->{3.673041763259186*^9, 3.673041803661046*^9, 
  3.6730930789584093`*^9, 3.673123115136187*^9, 3.7938440765736103`*^9, 
  3.793844851317005*^9, 3.823229770008979*^9},
 CellLabel->
  "Out[3439]=",ExpressionUUID->"823d29ec-411e-462c-bcf8-b75ed6624435"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{"gmag", "/.", 
    RowBox[{"\[Zeta]", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0.1", ",", "0.2", ",", "0.5", ",", "0.9"}], "}"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", "0.1", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.673040894884152*^9, 3.673040991934514*^9}, {
  3.673041537820908*^9, 3.673041573895917*^9}, {3.673041610809956*^9, 
  3.673041615960037*^9}, {3.673041786654338*^9, 3.673041839995186*^9}, {
  3.6730422501393538`*^9, 3.673042265262743*^9}},
 CellLabel->
  "In[3440]:=",ExpressionUUID->"c478bc1f-333f-40df-9efe-e16e21282775"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwlWHk01Y/TvvdWQiRCUZbQZivqawnNTQuyRFIoUSFSWVJJJbImZElFRNm3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       "]], LineBox[CompressedData["
1:eJwlWHc41Y/3v/fKSEpEpcyoRFTSpXluQkr2SNKgSNl9GggJyUpIEZGRjMie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       "]], LineBox[CompressedData["
1:eJwlmHc41u37x+/7Nsqe9UgSEkKSiko67ySUhj1KiKzKqCRURigqIzNST5HM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       "]], LineBox[CompressedData["
1:eJwllvk/FPjjx2fG0WFds2qJnCEpW7alkmYqRCJHQroUIudKMtJQWolEjoiQ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       "]]},
     Annotation[#, "Charting`Private`Tag$1986438#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-2.3025849990109806`, -4.611381259190807},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 
       6}]]& }, {{{-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.1\"", ShowStringCharacters -> False], 0.1, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 
       0.}}, {-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}}, {-2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.4011973816621555`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.6888794541139363`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}, {{-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.01\"", ShowStringCharacters -> False], 0.01, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.995732273553991, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.05\"", ShowStringCharacters -> False], 0.05, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.10\"", ShowStringCharacters -> False], 0.1, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
       0.}}, {-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.50\"", ShowStringCharacters -> False], 0.5, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}}, {-5.298317366548036, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.115995809754082, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.961845129926823, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.8283137373023015`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.710530701645918, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.302585092994046, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.70805020110221, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}}]]], "Output",
 CellChangeTimes->{{3.67304096339732*^9, 3.6730409926620207`*^9}, {
   3.673041543928582*^9, 3.673041574473914*^9}, {3.673041611781887*^9, 
   3.6730416163937798`*^9}, {3.6730417876985693`*^9, 3.673041821184156*^9}, 
   3.673041856835148*^9, {3.673042252488413*^9, 3.673042265764732*^9}, 
   3.673093079147615*^9, 3.6731231153049917`*^9, 3.793844076648281*^9, 
   3.793844851360652*^9, 3.823229770062644*^9},
 CellLabel->
  "Out[3440]=",ExpressionUUID->"c96c909a-e113-4606-b9d9-2de6f836e636"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", " ", 
       SqrtBox["\[Zeta]"]}]], ",", 
     RowBox[{"Piecewise", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          FractionBox["1", 
           RowBox[{"2", "\[Zeta]", 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["\[Zeta]", "2"]}]]}]], ",", 
          RowBox[{"\[Zeta]", "<", 
           FractionBox["1", 
            SqrtBox["2"]]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"\[Zeta]", "\[GreaterEqual]", 
           FractionBox["1", 
            SqrtBox["2"]]}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Zeta]", ",", "0.1", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.673018830521023*^9, 3.673018987196794*^9}, {
  3.673042041185454*^9, 3.67304205261615*^9}, {3.673042133693474*^9, 
  3.673042135423407*^9}, {3.673042399561431*^9, 3.673042499650847*^9}, {
  3.673043671412372*^9, 3.673043707921998*^9}},
 CellLabel->
  "In[3441]:=",ExpressionUUID->"39e53f76-e37c-46a2-9b41-d4ffbdb98991"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVlHs01HkAxadiKSb0lGSbpKSsTdLm0U3keHQkrHDO9Ni8doXORFnjeYio
yUYi2VLqKOxK22tMrJFSGpFoiinfmTGPDH4qM0Mva/+4557Pn/eecy/jl/iA
iJk0Gi1sWv/76jspynPnuKjtHZgfsmMSLvX1khs1XFxls8sPuk8ioFYuamvk
It60k5PvNImUy/7P1WIu/Ont0RLrSXSfWtmwy6YB1y98dqZ9N4m0KMGJ2bwG
bH9UckvOn0Cvqbnd7yIehsq+rp7EBLLYvMSQ75vwRxgJjQnQwlEaODFu3wSj
rMYsoY8WSp/h5NOeTaBtvmjg666Fn9myjPbYJvwW/07Xy0ELM25avsv9JgS7
cpmli7S4oXG7uDz0X2w9G333uEiD0Z/CwxO8m+FkHiZjxmpgdmuI45LFR1VQ
fGVHhRqLfHMSw0/y8ZDOSLU+r4aJhME8WcxHd+rS5txiNfSNQ9eJqvhI6NaN
CcxXQxPT1s4W8BHtXn/HIkGNbssreryFLVjo4xec4aXGiSJm5uZrLeBIVXa+
4+P4wupKcOx4gBU33hpqg8exbEtMS73BI1QP1QQJPT9CWX7Y/G3yY/jVdNoZ
+X6Aa2vQnITmdlw7VqESpL+HS3qlDs+xAxdeMCNI0xiSPasisi514miW08SL
xWNgqNz+CnvfhamHy5ldphT6vshtd9h0ozQq38tbfxSvWElJLL8X+LOA+aSU
MQJ1XPiR1wd74LqS5s4OGIbCIfdTaWUvBIrRErtsFSz2nvXiPHyJTuexuNbu
IdgEisz7poRoPV5n1L18CMEdKVeiHF6jjr/0xmjaO7TVzNasCepDf07p/YUf
lKAHdXR4nOxHY5Evb90BJUr3pcafqRPBJHfj6cVyBSYcw0tcVG/Qv96vvT5S
gaNFV1lWjAEkvI1V0t/LYVH97gSDQdBh5/rDz3lyxFDnL4kaCaqOVtuLLOTo
i/Qwt/cXQ2C/kFfSLEMoo2ysakAM9pFKnbJoGVq2Guj7sCVIvBpvcJsug18h
KzvHUIra9LRVwvuDaPVSu1PXpdgWtueW7a+D8NlmxUzyGETgcEHFI7NBfIj1
7T/fM4h0h8fCxh4pjn07Wa46JMOCsnr+6AkpnPitLb0z5Xgq9De55yPF1KPr
28hpOUKzXyo20KUQOKdHXqiQY/erawfM9KSoW1+tu9hWgW/nH8z4IpAg81mF
rbJRAdZwJG9HkQRbum6WysKUYA5smjDcLcEyHV506ogSq/cXlHUul8CQfahw
Y+o7FMedco4ZEUMW7Da1ZMkQ6j1jtxfcFUMcrv+8tHpoek93A7Q5YrQJh2Tu
Xirc9Jot1wsSo5GTHGQkVUE3s6Ku1lKM3kSadeLhYdxzNsnTaAletVzaomc8
AjZ3fP6sdoKvbpsbNlwegY3e30ujKgjsddIKMtaPQkb+cX2QRBCw9m3VpGAU
rYfCmj/7EZzJdrCi76EQct9Ta7qGYHxr0tiZfRRy3hiuYFkTBH7l8cwPUDBz
o+1/uppg3hH3gHXRFAI5e5amrSIoiApI92VR2FmTmzloSZDvc+h1Xg4Fhccs
49sWBJnGtZzv6igQdvGSiAUERECFnKqnULZrc0vzfIKteRtWLrpFISgjP818
mr/N4DVYcSn86Ghl32NCkPLxicLjAYWuPc+yPYwIkl4q3LKEFCaMc3qs50zn
L1xLN+ijwHpqc+fYbIJNO+NfFYooDBZuqZHoE2jaNHGXxRSy+ys7y/UIDnN1
y/kqCt5Fk7R5ugTdid5R3qMULo9Up8brTPdlz7F/PkYh7GwtvWMWwVj1gidE
TUGUezrq+EwC/6iQM9ETFFpsY9fLZxDUWZbvHftEwU2UN9djmueSAZukrxQ4
rdJvl2gEceWWmqkpCjLTo9P3TPAfdc7lTQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$1986829#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd0wk41UsbAHDZ96WkW5ZLNyK6iRJ16v3HsS91QxGn5MqWEEL2wlEckmxl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       "]], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQLVr4w+nHomf2DGDwwT70Cqe0+1IEn+G2ZfuvdQj+
6oeZn9fuQPAZ3588LXIGwQ//o7mk+j6Czyz+KsST7Tmcv95wFau4LoIv0bB0
Zn0pgt94boHui70Ivt2FTTOeRr2A82VZdmfUvkXweaoLJpnWvoTzn4Y5/peU
fAXnP0zhuDhjFYJ//Pqrp84er+H8vb1VIfyPEfyrpQwapcVv4PwbhxbasQu8
hfP/OlruMl6E4Bux1PU3GL6D84O07y3/eQbBn9Jiosob9x7hP4E1vWzrEfy8
Ocrf/v9H8AHnpIYT
       "]]},
     Annotation[#, "Charting`Private`Tag$1986829#2"]& ], 
    {Dashing[{Small, Small}], 
     LineBox[{{0.706819791390629, 1.0000003293190347`}, {0.7071067811865475, 
      1.0000001646595174`}, {0.7073937709824657, 1.}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.673042500967565*^9, {3.673043674259471*^9, 3.673043708308745*^9}, 
   3.673093079508233*^9, 3.673123115504148*^9, 3.793844076724022*^9, 
   3.793844851439405*^9, 3.8232297701517982`*^9},
 CellLabel->
  "Out[3441]=",ExpressionUUID->"34ac114c-b4da-4003-800c-24d06f024277"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a2", ",", "b2", ",", "c2", ",", "d2"}], "}"}], "=", 
   RowBox[{"Normal", "[", "gss", "]"}]}], ";", " ", 
  RowBox[{"h2", "=", 
   RowBox[{"ArrayFlatten", "[", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"a2", 
        RowBox[{"b2", ".", 
         RowBox[{"b2", "\[Transpose]"}]}]},
       {
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[Gamma]", 
           RowBox[{"-", "2"}]]}], " ", 
         RowBox[{
          RowBox[{"c2", "\[Transpose]"}], ".", "c2"}]}], 
        RowBox[{"-", 
         RowBox[{"a2", "\[Transpose]"}]}]}
      }], "\[NoBreak]", ")"}], "]"}]}], ";", " ", 
  RowBox[{"TraditionalForm", "[", "h2", "]"}]}]], "Input",
 CellChangeTimes->{{3.673092984469573*^9, 3.673093030124504*^9}, {
   3.6730930651218567`*^9, 3.6730930725683413`*^9}, {3.673093210910555*^9, 
   3.673093404877562*^9}, {3.673120521896023*^9, 3.673120546095595*^9}, {
   3.673121518540291*^9, 3.673121520463389*^9}, {3.673122766750497*^9, 
   3.67312277699222*^9}, {3.67312286673532*^9, 3.673122886008247*^9}, {
   3.6731230659336357`*^9, 3.673123087042782*^9}, 3.6731448242801228`*^9},
 CellLabel->
  "In[3442]:=",ExpressionUUID->"cadd6833-0627-4b31-93a9-95e943df5404"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "1", "0", "0"},
     {
      RowBox[{"-", "1"}], 
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[Zeta]"}], "0", "1"},
     {
      RowBox[{"-", 
       FractionBox["1", 
        SuperscriptBox["\[Gamma]", "2"]]}], "0", "0", "1"},
     {"0", "0", 
      RowBox[{"-", "1"}], 
      RowBox[{"2", " ", "\[Zeta]"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.673093213623118*^9, {3.673093297508232*^9, 3.6730934058533497`*^9}, {
   3.673120528504238*^9, 3.6731205469360867`*^9}, 3.673121523179637*^9, 
   3.67312277849162*^9, {3.673122868465371*^9, 3.673122888052795*^9}, 
   3.673123115536903*^9, 3.673144825478245*^9, 3.79384407673598*^9, 
   3.793844851457809*^9, 3.8232297701676073`*^9},
 CellLabel->
  "Out[3442]//TraditionalForm=",ExpressionUUID->"802de869-eef0-4641-bd02-\
94d826658083"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eigs", "=", 
   RowBox[{"Eigenvalues", "[", " ", "h2", "]"}]}], ";", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"eigs", ",", 
    RowBox[{"\[Gamma]", ">", "0"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6730934227071457`*^9, 3.6730934270877647`*^9}, {
  3.673093471790798*^9, 3.6730934726133842`*^9}, {3.6731223267378893`*^9, 
  3.673122327326823*^9}, {3.6731231063233137`*^9, 3.673123110865572*^9}, {
  3.673144830765829*^9, 3.673144832060279*^9}, {3.673144887421994*^9, 
  3.6731449041553793`*^9}},
 CellLabel->
  "In[3443]:=",ExpressionUUID->"d3e75fa5-d3da-4d64-83cd-44a5ce875361"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SqrtBox[
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[Gamma]", "3"]}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Gamma]", "-", 
         RowBox[{"2", " ", "\[Gamma]", " ", 
          SuperscriptBox["\[Zeta]", "2"]}], "+", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["\[Gamma]", "2"], " ", 
            SuperscriptBox["\[Zeta]", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[Zeta]", "2"]}], ")"}]}]}]]}], ")"}]}]], 
     SuperscriptBox["\[Gamma]", "2"]]}], ",", 
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Gamma]", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[Zeta]", "2"]}]}], ")"}]}], "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["\[Gamma]", "6"], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[Gamma]", "8"], " ", 
         SuperscriptBox["\[Zeta]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[Zeta]", "2"]}], ")"}]}]}]]}]], 
    SuperscriptBox["\[Gamma]", "2"]], ",", 
   RowBox[{"-", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Zeta]", "2"]}], "+", 
      FractionBox[
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["\[Gamma]", "2"], " ", 
          SuperscriptBox["\[Zeta]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[Zeta]", "2"]}], ")"}]}]}]], "\[Gamma]"]}]]}], 
   ",", 
   SqrtBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Zeta]", "2"]}], "+", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[Gamma]", "2"], " ", 
         SuperscriptBox["\[Zeta]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[Zeta]", "2"]}], ")"}]}]}]], "\[Gamma]"]}]]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.673093428219635*^9, 3.67309347432717*^9, 3.6731215265468397`*^9, 
   3.673122327758172*^9, 3.673122781683044*^9, {3.6731228704201727`*^9, 
   3.673122890189788*^9}, 3.6731231156301622`*^9, {3.6731448280712223`*^9, 
   3.673144832602324*^9}, {3.6731449001114883`*^9, 3.673144905722365*^9}, 
   3.793844077217456*^9, 3.793844851927822*^9, 3.823229770695531*^9},
 CellLabel->
  "Out[3443]=",ExpressionUUID->"77789f0a-d8cb-4e00-86fa-e2af128fec5f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"e2", "=", 
   SuperscriptBox["eigs", "2"]}], ";", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"e2", ",", 
    RowBox[{"\[Gamma]", ">", "0"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.673122329359367*^9, 3.673122374330647*^9}, {
  3.6731224724681587`*^9, 3.673122475147583*^9}, {3.673122506287422*^9, 
  3.6731225241733294`*^9}, {3.673144926568285*^9, 3.673144957741823*^9}},
 CellLabel->
  "In[3444]:=",ExpressionUUID->"18240bc3-602b-450a-97d8-4ef1a82deeb5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["\[Zeta]", "2"]}], "-", 
    FractionBox[
     RowBox[{"\[Gamma]", "+", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[Gamma]", "2"], " ", 
         SuperscriptBox["\[Zeta]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[Zeta]", "2"]}], ")"}]}]}]]}], "\[Gamma]"]}], ",", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["\[Zeta]", "2"]}], "-", 
    FractionBox[
     RowBox[{"\[Gamma]", "+", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[Gamma]", "2"], " ", 
         SuperscriptBox["\[Zeta]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[Zeta]", "2"]}], ")"}]}]}]]}], "\[Gamma]"]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["\[Zeta]", "2"]}], "+", 
    FractionBox[
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["\[Gamma]", "2"], " ", 
        SuperscriptBox["\[Zeta]", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Zeta]", "2"]}], ")"}]}]}]], "\[Gamma]"]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["\[Zeta]", "2"]}], "+", 
    FractionBox[
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["\[Gamma]", "2"], " ", 
        SuperscriptBox["\[Zeta]", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Zeta]", "2"]}], ")"}]}]}]], "\[Gamma]"]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.673122332515764*^9, 3.673122374786467*^9, 3.6731224758840113`*^9, {
   3.673122513360409*^9, 3.673122525458425*^9}, 3.673122798938623*^9, 
   3.673122891753046*^9, 3.6731231157134743`*^9, 3.673144835666388*^9, {
   3.6731449196672573`*^9, 3.673144958762121*^9}, 3.793844077469208*^9, 
   3.793844852179229*^9, 3.823229771076317*^9},
 CellLabel->
  "Out[3444]=",ExpressionUUID->"f82325de-f402-4f05-ab76-9e735366d01c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"e2", "/.", 
    RowBox[{"\[Zeta]", "\[Rule]", "0.5"}]}], ",", 
   RowBox[{"\[Gamma]", ">", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.673145471774042*^9, 3.67314550495164*^9}, {
  3.67314554444477*^9, 3.673145617412121*^9}},
 CellLabel->
  "In[3445]:=",ExpressionUUID->"95e8f028-87f7-4b41-8013-eb3cbf916635"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.5`"}], "-", 
    FractionBox[
     RowBox[{"1.`", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["\[Gamma]", "6"], "-", 
        RowBox[{"0.75`", " ", 
         SuperscriptBox["\[Gamma]", "8"]}]}]]}], 
     SuperscriptBox["\[Gamma]", "4"]]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "-", 
    FractionBox[
     RowBox[{"1.`", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["\[Gamma]", "6"], "-", 
        RowBox[{"0.75`", " ", 
         SuperscriptBox["\[Gamma]", "8"]}]}]]}], 
     SuperscriptBox["\[Gamma]", "4"]]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "+", 
    FractionBox[
     SqrtBox[
      RowBox[{
       SuperscriptBox["\[Gamma]", "6"], "-", 
       RowBox[{"0.75`", " ", 
        SuperscriptBox["\[Gamma]", "8"]}]}]], 
     SuperscriptBox["\[Gamma]", "4"]]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "+", 
    FractionBox[
     SqrtBox[
      RowBox[{
       SuperscriptBox["\[Gamma]", "6"], "-", 
       RowBox[{"0.75`", " ", 
        SuperscriptBox["\[Gamma]", "8"]}]}]], 
     SuperscriptBox["\[Gamma]", "4"]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6731454790384417`*^9, 3.673145505498081*^9}, {
   3.67314555531756*^9, 3.673145618698227*^9}, 3.793844077553112*^9, 
   3.793844852223536*^9, 3.823229771096793*^9},
 CellLabel->
  "Out[3445]=",ExpressionUUID->"10233d4b-4a6b-4b04-bd36-e52472d9a5c3"]
}, Open  ]],

Cell["For 1st-order system", "Text",
 CellChangeTimes->{{3.673034524254158*^9, 3.673034553425497*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"e9e8fbca-e192-4cff-a135-101571365e68"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g1", "=", 
   FractionBox["1", 
    RowBox[{"1", "+", " ", 
     RowBox[{"\[Tau]", " ", "s"}]}]]}], ";", " ", 
  RowBox[{"g1tf", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"g1", ",", "s"}], "]"}]}], ";", " ", 
  RowBox[{"g1ss", "=", 
   RowBox[{"StateSpaceModel", "[", "g1tf", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.673034567294408*^9, 3.673034616960188*^9}},
 CellLabel->
  "In[3446]:=",ExpressionUUID->"126832a1-b46e-45da-8de0-62b7f35b05ca"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", 
     FractionBox["1", "\[Tau]"]}], "1", 
   FractionBox["1", "\[Tau]"], "0", 
   InterpretationBox["\[InvisibleSpace]", None], {
   StateSpaceModel, {
    False, False, {False, False}}, {$CellContext`stname1}, {{
     Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$}}, Identity, Automatic, 1, 1, 1, 1, {}, {
    False, False}, False, Automatic, None, Automatic}, {}},
  "StateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{#, #2}, {#3, #4}}, AllowedDimensions -> {2, 2}, 
        GridBoxDividers -> {"Rows" -> {False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}, "Columns" -> {False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
        "SystemsModelGrid00"], ")"}], #5, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalS]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None], MultilineFunction -> None], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{2, 2}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{3, 3}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{4, 4}, ","], "}"}], "}"}], "}"}], ",", 
     "SamplingPeriod", "->", 
     RowBox[{#5}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
  Tooltip->StateSpaceModel]], "Output",
 CellChangeTimes->{{3.673034592793274*^9, 3.673034620327608*^9}, 
   3.673037044066351*^9, 3.6730382382970047`*^9, 3.6730415441592283`*^9, 
   3.673093079719927*^9, 3.6731231158131313`*^9, 3.7938440776201*^9, 
   3.793844852285865*^9, 3.823229771162088*^9},
 CellLabel->
  "Out[3446]=",ExpressionUUID->"80fc0e7c-85c9-4153-aa7a-74f76da2a8e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"p1inf", "=", 
   RowBox[{"ControllabilityGramian", "[", "g1ss", "]"}]}], ";", " ", 
  RowBox[{"TraditionalForm", "[", "p1inf", "]"}]}]], "Input",
 CellChangeTimes->{{3.673034605128953*^9, 3.673034608584861*^9}},
 CellLabel->
  "In[3447]:=",ExpressionUUID->"a5e9c4fd-19ce-4e21-8e16-99eb220deb38"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{"\[Tau]", " ", 
        TemplateBox[{"\[Tau]"},
         "Conjugate"]}], 
       RowBox[{
        TemplateBox[{"\[Tau]"},
         "Conjugate"], "+", "\[Tau]"}]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.673034610299554*^9, 3.673034620381147*^9}, 
   3.6730370441281*^9, 3.673038238349348*^9, 3.673041544225399*^9, 
   3.6730930797755136`*^9, 3.67312311586974*^9, 3.793844077659429*^9, 
   3.793844852323111*^9, 3.823229771198148*^9},
 CellLabel->
  "Out[3447]//TraditionalForm=",ExpressionUUID->"88254764-3939-4bee-b554-\
ac4eff50a912"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a1", ",", "b1", ",", "c1", ",", "d1"}], "}"}], "=", 
   RowBox[{"Normal", "[", "g1ss", "]"}]}], ";", " ", 
  RowBox[{"h1", "=", 
   RowBox[{"ArrayFlatten", "[", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"a1", 
        RowBox[{"b1", ".", 
         RowBox[{"b1", "\[Transpose]"}]}]},
       {
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[Gamma]", 
           RowBox[{"-", "2"}]]}], " ", 
         RowBox[{
          RowBox[{"c1", "\[Transpose]"}], ".", "c1"}]}], 
        RowBox[{"-", 
         RowBox[{"a1", "\[Transpose]"}]}]}
      }], "\[NoBreak]", ")"}], "]"}]}], ";", " ", 
  RowBox[{"TraditionalForm", "[", 
   RowBox[{"{", 
    RowBox[{"a1", ",", "b1", ",", "c1", ",", "d1", ",", "h1"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.6731230401485777`*^9, 3.6731230605007133`*^9}, {
  3.673144385652279*^9, 3.673144390840496*^9}, {3.673144525369752*^9, 
  3.673144549855178*^9}},
 CellLabel->
  "In[3448]:=",ExpressionUUID->"b237778b-c6b6-4a28-b6a8-e0d49d13a3e2"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox["1", "\[Tau]"]}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", "\[Tau]"]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}], ",", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox["1", "\[Tau]"]}], "1"},
       {
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{
           SuperscriptBox["\[Gamma]", "2"], " ", 
           SuperscriptBox["\[Tau]", "2"]}]]}], 
        FractionBox["1", "\[Tau]"]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.673123115936597*^9, 3.673144391238737*^9, {3.6731445271877604`*^9, 
   3.673144552029344*^9}, 3.793844077666141*^9, 3.793844852329953*^9, 
   3.823229771206829*^9},
 CellLabel->
  "Out[3448]//TraditionalForm=",ExpressionUUID->"39f2e854-acb5-491a-93a1-\
6fa2691f7459"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eigs1", "=", 
   RowBox[{"Eigenvalues", "[", " ", "h1", "]"}]}], ";", 
  RowBox[{"Simplify", "[", 
   RowBox[{"eigs1", ",", 
    RowBox[{"\[Gamma]", ">", "0"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.673123183253069*^9, 3.673123195848556*^9}, {
  3.6731447025381727`*^9, 3.673144721015637*^9}, {3.673145036035556*^9, 
  3.6731450624918756`*^9}},
 CellLabel->
  "In[3449]:=",ExpressionUUID->"606125ed-bdea-4220-97fa-d77b125af406"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[Gamma]", "2"]}]], 
     RowBox[{"\[Gamma]", " ", "\[Tau]"}]]}], ",", 
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[Gamma]", "2"]}]], 
    RowBox[{"\[Gamma]", " ", "\[Tau]"}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.673123193920089*^9, 3.673123196295168*^9}, {
   3.67314453056467*^9, 3.673144554707768*^9}, {3.6731447044866667`*^9, 
   3.673144721587586*^9}, {3.673145044745859*^9, 3.6731450630991096`*^9}, 
   3.7938440776961823`*^9, 3.793844852349801*^9, 3.8232297712291603`*^9},
 CellLabel->
  "Out[3449]=",ExpressionUUID->"6ecc4e29-2f5f-4522-8735-8739b75416e0"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 63}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"4e4abee3-3fab-47ab-9d88-1320fe9636bb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 254, 4, 67, "Section",ExpressionUUID->"96f83ec2-9a6e-4eb3-94e4-dc607d7e9f05"],
Cell[837, 28, 175, 4, 30, "Input",ExpressionUUID->"b79f195c-f649-471b-ad39-6b95a2c7a9cb"],
Cell[1015, 34, 190, 3, 51, "Text",ExpressionUUID->"acb6167d-1692-4a46-9718-76ddfc7071a7"],
Cell[CellGroupData[{
Cell[1230, 41, 787, 19, 95, "Input",ExpressionUUID->"d9379375-8a51-4924-83a5-49c62418c665"],
Cell[2020, 62, 3038, 70, 73, "Output",ExpressionUUID->"b9d47c0b-f1c8-4e52-bfce-9e39feb73f49"],
Cell[5061, 134, 1254, 34, 85, "Output",ExpressionUUID->"d9ac336f-40e0-4756-a3e9-273aebab922c"]
}, Open  ]],
Cell[6330, 171, 302, 5, 51, "Text",ExpressionUUID->"79b1fb9c-a834-4310-90d0-3554b66d2d4d"],
Cell[CellGroupData[{
Cell[6657, 180, 1179, 34, 107, "Input",ExpressionUUID->"e90af786-4992-4834-89b7-6b1c168060af"],
Cell[7839, 216, 1310, 33, 59, "Output",ExpressionUUID->"2a239462-f467-40b0-a2f9-90806cf864cd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9186, 254, 530, 14, 45, "Input",ExpressionUUID->"0e6cc0b5-dd84-4ebf-96ca-49a5bb7ae1a7"],
Cell[9719, 270, 674, 16, 52, "Output",ExpressionUUID->"a80757f4-3ff9-4730-ae92-4cf8fa822044"]
}, Open  ]],
Cell[10408, 289, 375, 5, 51, "Text",ExpressionUUID->"b097d944-f8c6-4eac-8ade-a0a7aa92ba2b"],
Cell[CellGroupData[{
Cell[10808, 298, 550, 13, 30, "Input",ExpressionUUID->"65dc8975-6e50-49d0-ac9b-eebcf6e18578"],
Cell[11361, 313, 829, 24, 83, "Output",ExpressionUUID->"a800f436-4e05-4839-a7d5-09366745f85d"]
}, Open  ]],
Cell[12205, 340, 510, 15, 60, "Input",ExpressionUUID->"50bc33e8-3d97-4793-9c9d-41e4cf74c5c7"],
Cell[CellGroupData[{
Cell[12740, 359, 394, 10, 30, "Input",ExpressionUUID->"38b5903d-4287-47e7-8000-e0c177d36fe9"],
Cell[13137, 371, 778, 22, 42, "Output",ExpressionUUID->"b48848a4-fea9-4416-a917-c24fdeff7f3b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13952, 398, 180, 3, 30, "Input",ExpressionUUID->"57c96661-98e4-49e7-aa90-993252fc42dd"],
Cell[14135, 403, 909, 26, 62, "Output",ExpressionUUID->"70c6c34c-c5de-42e5-9177-0e12ffb4dd21"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15081, 434, 301, 7, 30, "Input",ExpressionUUID->"9d385f66-0c19-4861-a9f9-73a32ca638d1"],
Cell[15385, 443, 794, 22, 37, "Output",ExpressionUUID->"b15c1419-86a5-46cd-8ec5-85bc4076073d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16216, 470, 465, 13, 35, "Input",ExpressionUUID->"660762ad-2681-4410-b8c5-30cca4bc6b5f"],
Cell[16684, 485, 464, 11, 56, "Output",ExpressionUUID->"1e30c75f-6d4d-49ec-a9ce-182e6d717b67"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17185, 501, 366, 8, 30, "Input",ExpressionUUID->"30b4e095-8b35-4f89-8e5b-8ba8720a2e35"],
Cell[17554, 511, 438, 9, 34, "Output",ExpressionUUID->"823d29ec-411e-462c-bcf8-b75ed6624435"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18029, 525, 696, 15, 30, "Input",ExpressionUUID->"c478bc1f-333f-40df-9efe-e16e21282775"],
Cell[18728, 542, 34459, 655, 236, "Output",ExpressionUUID->"c96c909a-e113-4606-b9d9-2de6f836e636"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53224, 1202, 1390, 40, 86, "Input",ExpressionUUID->"39e53f76-e37c-46a2-9b41-d4ffbdb98991"],
Cell[54617, 1244, 8038, 154, 252, "Output",ExpressionUUID->"34ac114c-b4da-4003-800c-24d06f024277"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62692, 1403, 1251, 30, 72, "Input",ExpressionUUID->"cadd6833-0627-4b31-93a9-95e943df5404"],
Cell[63946, 1435, 1200, 32, 107, "Output",ExpressionUUID->"802de869-eef0-4641-bd02-94d826658083"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65183, 1472, 622, 13, 30, "Input",ExpressionUUID->"d3e75fa5-d3da-4d64-83cd-44a5ce875361"],
Cell[65808, 1487, 2811, 84, 122, "Output",ExpressionUUID->"77789f0a-d8cb-4e00-86fa-e2af128fec5f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68656, 1576, 495, 11, 30, "Input",ExpressionUUID->"18240bc3-602b-450a-97d8-4ef1a82deeb5"],
Cell[69154, 1589, 2273, 67, 110, "Output",ExpressionUUID->"f82325de-f402-4f05-ab76-9e735366d01c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71464, 1661, 377, 9, 30, "Input",ExpressionUUID->"95e8f028-87f7-4b41-8013-eb3cbf916635"],
Cell[71844, 1672, 1434, 45, 58, "Output",ExpressionUUID->"10233d4b-4a6b-4b04-bd36-e52472d9a5c3"]
}, Open  ]],
Cell[73293, 1720, 190, 3, 51, "Text",ExpressionUUID->"e9e8fbca-e192-4cff-a135-101571365e68"],
Cell[CellGroupData[{
Cell[73508, 1727, 504, 13, 71, "Input",ExpressionUUID->"126832a1-b46e-45da-8de0-62b7f35b05ca"],
Cell[74015, 1742, 2647, 61, 94, "Output",ExpressionUUID->"80fc0e7c-85c9-4153-aa7a-74f76da2a8e6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76699, 1808, 330, 7, 30, "Input",ExpressionUUID->"a5e9c4fd-19ce-4e21-8e16-99eb220deb38"],
Cell[77032, 1817, 975, 26, 53, "Output",ExpressionUUID->"88254764-3939-4bee-b554-ac4eff50a912"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78044, 1848, 1071, 30, 72, "Input",ExpressionUUID->"b237778b-c6b6-4a28-b6a8-e0d49d13a3e2"],
Cell[79118, 1880, 2751, 78, 83, "Output",ExpressionUUID->"39f2e854-acb5-491a-93a1-6fa2691f7459"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81906, 1963, 468, 11, 30, "Input",ExpressionUUID->"606125ed-bdea-4220-97fa-d77b125af406"],
Cell[82377, 1976, 783, 21, 80, "Output",ExpressionUUID->"6ecc4e29-2f5f-4522-8735-8739b75416e0"]
}, Open  ]]
}, Open  ]]
}
]
*)

