(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15945,        391]
NotebookOptionsPosition[     14480,        357]
NotebookOutlinePosition[     14877,        373]
CellTagsIndexPosition[     14834,        370]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Delayed choice problem (Kappen 2005)  Prob. 8.8 / Ex. 8.5", "Section",
 CellChangeTimes->{{3.644450207434885*^9, 3.644450247858924*^9}, {
  3.644451151868689*^9, 3.644451152522646*^9}, {3.64462794465035*^9, 
  3.6446279586484003`*^9}, {3.6476269424548197`*^9, 3.647626961243258*^9}, {
  3.6478106821594*^9, 3.647810700612385*^9}, {3.6478112429076347`*^9, 
  3.6478112447288218`*^9}, {3.64781164888902*^9, 3.647811650818988*^9}, {
  3.647828835231162*^9, 3.647828868988184*^9}, {3.648417651777041*^9, 
  3.648417665295038*^9}, {3.793586209597431*^9, 
  3.793586231009747*^9}},ExpressionUUID->"cd38454f-780c-45eb-afcd-\
289a78aae829"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[3590]:=",ExpressionUUID->"0e398db2-e5b2-4dc8-8824-6871f1be310d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"j", "[", 
   RowBox[{"x_", ",", "\[Tau]_"}], "]"}], ":=", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"2", "\[Tau]"}]], "-", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"Cosh", "[", 
     FractionBox["x", "\[Tau]"], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.648237293627243*^9, 3.648237362346689*^9}, {
   3.648260171787174*^9, 3.648260195145094*^9}, {3.64841167828928*^9, 
   3.6484116790871*^9}, {3.648414926589612*^9, 3.648414947763846*^9}, {
   3.648415137382139*^9, 3.6484152541064243`*^9}, 3.648415641827405*^9, {
   3.6484173176157417`*^9, 3.648417330111102*^9}, 3.648417385148426*^9},
 CellLabel->
  "In[3591]:=",ExpressionUUID->"045811de-7049-4d21-bbde-21a11ff370b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"j", "[", 
       RowBox[{"x", ",", "\[Tau]"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{"\[Tau]", "\[Rule]", "t0"}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "1"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t0", ",", "1"}], "}"}], ",", "0.001", ",", "2", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.64823736482512*^9, 3.648237469560443*^9}, {
   3.6484149538362083`*^9, 3.648414959347659*^9}, {3.6484149953438377`*^9, 
   3.648415010126912*^9}, {3.6484152618426933`*^9, 3.648415264211561*^9}, {
   3.6484156497061987`*^9, 3.648415649777286*^9}, {3.648417339441378*^9, 
   3.6484173986127043`*^9}, {3.648417713934757*^9, 3.6484177154944563`*^9}, 
   3.7564386715987873`*^9},
 CellLabel->
  "In[3592]:=",ExpressionUUID->"cdca69c3-5c32-4364-9435-8a59683942ba"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t0$$ = 1.318, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t0$$], 1}, 0.001, 2}}, Typeset`size$$ = {
    360., {115., 120.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t0$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[
         $CellContext`j[$CellContext`x, $CellContext`\[Tau]], {$CellContext`\
\[Tau] -> $CellContext`t0$$}], {$CellContext`x, -2, 2}, PlotRange -> {-3, 1}],
       "Specifications" :> {{{$CellContext`t0$$, 1}, 0.001, 2, Appearance -> 
         "Labeled"}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{405., {160., 166.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.6482373701022167`*^9, 3.648237470368794*^9}, 
   3.648414963292137*^9, {3.648414996653287*^9, 3.648415010983322*^9}, 
   3.6484152646687193`*^9, 3.648415650227676*^9, {3.648417366011939*^9, 
   3.648417399211481*^9}, 3.6484176811513033`*^9, 3.6484177160947313`*^9, 
   3.6484178740562572`*^9, 3.64841797158589*^9, {3.756438666119632*^9, 
   3.756438672569436*^9}, 3.7935862440080967`*^9, 3.793586291054133*^9, 
   3.7939086568125153`*^9, 3.823229896667878*^9},
 CellLabel->
  "Out[3592]=",ExpressionUUID->"7e76e476-1a84-4427-9bdd-a69d5766aade"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"j", "[", 
       RowBox[{"x", ",", "\[Tau]"}], "]"}], ",", "x"}], "]"}]}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.648237660109851*^9, 3.648237712509068*^9}, {
  3.6482377552696447`*^9, 3.648237777532034*^9}, {3.64841532484762*^9, 
  3.648415326901443*^9}, {3.648417427612248*^9, 3.648417437915859*^9}, {
  3.648417507002372*^9, 3.6484175073608303`*^9}},
 CellLabel->
  "In[3593]:=",ExpressionUUID->"4d788947-1001-446e-aaa0-b250f2e12431"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "x"}], "+", 
   RowBox[{"Tanh", "[", 
    FractionBox["x", "\[Tau]"], "]"}]}], "\[Tau]"]], "Output",
 CellChangeTimes->{{3.648237707943054*^9, 3.648237715557762*^9}, {
   3.648237761123187*^9, 3.648237780294753*^9}, 3.648237982626039*^9, {
   3.648411688872776*^9, 3.6484116979697647`*^9}, 3.648415337067485*^9, {
   3.6484174325732727`*^9, 3.6484174382802763`*^9}, 3.6484175085124397`*^9, 
   3.648417681204801*^9, 3.648417874182047*^9, 3.648417971696238*^9, 
   3.756438666203265*^9, 3.79358624409202*^9, 3.7935862911915703`*^9, 
   3.793908656911261*^9, 3.8232298967484818`*^9},
 CellLabel->
  "Out[3593]=",ExpressionUUID->"565ec971-853e-405f-8d71-7182dc454939"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"u", "/.", 
      RowBox[{"{", 
       RowBox[{"\[Tau]", "\[Rule]", "t0"}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t0", ",", "1"}], "}"}], ",", "0.001", ",", "2", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.6482378153661423`*^9, {3.648237873408761*^9, 3.6482379116540403`*^9}, {
   3.648237987254225*^9, 3.648238041739416*^9}, {3.648415341981537*^9, 
   3.648415359548883*^9}, {3.648417453165807*^9, 3.648417465991181*^9}, {
   3.648417704952454*^9, 3.6484177068624983`*^9}, 3.7564386827472878`*^9},
 CellLabel->
  "In[3594]:=",ExpressionUUID->"9858dc36-f9d3-42fd-9d92-15f34911b5f0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t0$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t0$$], 1}, 0.001, 2}}, Typeset`size$$ = {
    360., {115., 120.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t0$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[$CellContext`u, {$CellContext`\[Tau] -> \
$CellContext`t0$$}], {$CellContext`x, -2, 2}, PlotRange -> {-1.5, 1.5}], 
      "Specifications" :> {{{$CellContext`t0$$, 1}, 0.001, 2, Appearance -> 
         "Labeled"}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{405., {160., 166.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.648237816051454*^9, {3.648237874466968*^9, 3.64823791396856*^9}, {
   3.6482379915252867`*^9, 3.648238042530074*^9}, {3.648415348071069*^9, 
   3.648415360629884*^9}, 3.648417468944323*^9, 3.648417511111216*^9, {
   3.648417681251013*^9, 3.6484177074126167`*^9}, 3.648417874248139*^9, 
   3.648417971762808*^9, {3.75643866628905*^9, 3.756438683782736*^9}, 
   3.793586244099691*^9, 3.7935862912317266`*^9, 3.793908656919417*^9, 
   3.823229896779468*^9},
 CellLabel->
  "Out[3594]=",ExpressionUUID->"3bdd7f6e-c7c4-4696-a8e6-405686aa1caf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"x_", ",", "\[Tau]_"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", "2"], 
   FractionBox["1", 
    SqrtBox[
     RowBox[{"2", "\[Pi]", " ", "\[Nu]", " ", "\[Tau]"}]]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Exp", "[", 
      FractionBox[
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "2"]}], 
       RowBox[{"2", "\[Nu]", " ", "\[Tau]"}]], "]"}], "+", 
     RowBox[{"Exp", "[", 
      FractionBox[
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "+", "1"}], ")"}], "2"]}], 
       RowBox[{"2", "\[Nu]", " ", "\[Tau]"}]], "]"}]}], 
    ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "t"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Nu]", "\[Rule]", "1"}], ",", 
        RowBox[{"T", "\[Rule]", "2"}], ",", 
        RowBox[{"t", "\[Rule]", "t0"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t0", ",", "1"}], "}"}], ",", "0.04", ",", "2", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.648237896864047*^9, 3.648237900015235*^9}, {
   3.648237933897003*^9, 3.648237953436955*^9}, {3.648262649031995*^9, 
   3.648262994660351*^9}, {3.648263027485178*^9, 3.648263045307077*^9}, {
   3.648412847877943*^9, 3.648413023736575*^9}, {3.648417733474306*^9, 
   3.648417865972021*^9}, 3.756438691098768*^9},
 CellLabel->
  "In[3595]:=",ExpressionUUID->"5e574873-6057-4a79-b56a-61ba14d8c6ac"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t0$$ = 0.934, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t0$$], 1}, 0.04, 2}}, Typeset`size$$ = {
    360., {120., 124.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t0$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[
         $CellContext`\[Psi][$CellContext`x, $CellContext`t], {$CellContext`\
\[Nu] -> 1, $CellContext`T -> 
          2, $CellContext`t -> $CellContext`t0$$}], {$CellContext`x, -10, 10},
         PlotRange -> {0, 1}], 
      "Specifications" :> {{{$CellContext`t0$$, 1}, 0.04, 2, Appearance -> 
         "Labeled"}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{405., {165., 171.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.6482379369234037`*^9, 3.648237953983252*^9}, {
   3.648262757844275*^9, 3.648262995107682*^9}, {3.648263028298849*^9, 
   3.648263045853448*^9}, {3.6484128591424313`*^9, 3.6484128967064447`*^9}, {
   3.648412949018055*^9, 3.648413024211282*^9}, 3.648417681536456*^9, {
   3.6484177422367897`*^9, 3.648417770306645*^9}, {3.648417816035129*^9, 
   3.64841787438181*^9}, 3.64841797189557*^9, {3.756438666580546*^9, 
   3.75643869185592*^9}, 3.793586244184702*^9, 3.79358629131284*^9, 
   3.793908657023748*^9, 3.823229896863098*^9},
 CellLabel->
  "Out[3596]=",ExpressionUUID->"7b30b1b6-93f4-40df-89c5-d7d1eaba3bbc"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 167}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"1446406b-3adc-4927-9d0c-226d21d199fa"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 638, 9, 67, "Section",ExpressionUUID->"cd38454f-780c-45eb-afcd-289a78aae829"],
Cell[1221, 33, 175, 4, 30, "Input",ExpressionUUID->"0e398db2-e5b2-4dc8-8824-6871f1be310d"],
Cell[1399, 39, 744, 17, 51, "Input",ExpressionUUID->"045811de-7049-4d21-bbde-21a11ff370b9"],
Cell[CellGroupData[{
Cell[2168, 60, 1206, 30, 73, "Input",ExpressionUUID->"cdca69c3-5c32-4364-9435-8a59683942ba"],
Cell[3377, 92, 2202, 42, 345, "Output",ExpressionUUID->"7e76e476-1a84-4427-9bdd-a69d5766aade"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5616, 139, 570, 14, 30, "Input",ExpressionUUID->"4d788947-1001-446e-aaa0-b250f2e12431"],
Cell[6189, 155, 720, 14, 58, "Output",ExpressionUUID->"565ec971-853e-405f-8d71-7182dc454939"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6946, 174, 1042, 27, 52, "Input",ExpressionUUID->"9858dc36-f9d3-42fd-9d92-15f34911b5f0"],
Cell[7991, 203, 2151, 42, 345, "Output",ExpressionUUID->"3bdd7f6e-c7c4-4696-a8e6-405686aa1caf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10179, 250, 1939, 56, 101, "Input",ExpressionUUID->"5e574873-6057-4a79-b56a-61ba14d8c6ac"],
Cell[12121, 308, 2331, 45, 378, "Output",ExpressionUUID->"7b30b1b6-93f4-40df-89c5-d7d1eaba3bbc"]
}, Open  ]]
}, Open  ]]
}
]
*)

