(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    363359,       6520]
NotebookOptionsPosition[    360155,       6455]
NotebookOutlinePosition[    360552,       6471]
CellTagsIndexPosition[    360509,       6468]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Optimal control of harmonic oscillator (rest-to-rest transition)
Problem 7.4\
\>", "Section",
 CellChangeTimes->{{3.5664182955889463`*^9, 3.5664183113078833`*^9}, {
  3.720246525327486*^9, 3.720246539317191*^9}, {3.793502395491543*^9, 
  3.793502398586719*^9}},ExpressionUUID->"c507134f-dc37-4726-94c3-\
a01b745a8c3d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqs", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
        RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", 
       RowBox[{"-", 
        RowBox[{"\[Lambda]", "[", "t", "]"}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"\[Lambda]", "''"}], "[", "t", "]"}], "+", 
        RowBox[{"\[Lambda]", "[", "t", "]"}]}], "\[Equal]", "0"}]}], "}"}]}], 
   ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"alternatively", ",", " ", 
    RowBox[{
     RowBox[{"four", " ", "1", "st"}], "-", 
     RowBox[{"order", " ", "eqs"}]}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"init", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"x", "'"}], "[", "\[Tau]", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "\[Tau]", "]"}], "\[Equal]", "1"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xs", ",", "\[Lambda]s"}], "}"}], "=", 
   RowBox[{
    RowBox[{"DSolveValue", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eqs", ",", "init"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], ",", 
        RowBox[{"\[Lambda]", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}], "//",
     "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Es", "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["xs", "2"], "+", 
       SuperscriptBox[
        RowBox[{"D", "[", 
         RowBox[{"xs", ",", "t"}], "]"}], "2"]}], ")"}]}], "//", 
    "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Js", "=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      SuperscriptBox["\[Lambda]s", "2"], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}]}], "]"}], "//", 
    "Simplify"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7202455135343533`*^9, 3.720245643948266*^9}, {
  3.720245731532351*^9, 3.720245761593033*^9}, {3.7202458965922537`*^9, 
  3.720245907685034*^9}, {3.720245998395907*^9, 3.7202460609373503`*^9}, {
  3.720246178343601*^9, 3.7202462244733877`*^9}, {3.720246257223839*^9, 
  3.72024625955899*^9}, {3.793502444982901*^9, 3.793502483466254*^9}},
 CellLabel->
  "In[2942]:=",ExpressionUUID->"8cce65d6-1954-4fe9-875f-fc1712f6449b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{"{", 
   RowBox[{"xs", ",", "\[Lambda]s", ",", "Es", ",", "Js"}], "}"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7202462341239567`*^9, 3.720246250344343*^9}},
 CellLabel->
  "In[2948]:=",ExpressionUUID->"024cf798-07c1-422d-b728-debaed5a33ea"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"t", " ", 
         RowBox[{"cos", "(", "t", ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "(", "\[Tau]", ")"}], "+", 
           RowBox[{"\[Tau]", " ", 
            RowBox[{"cos", "(", "\[Tau]", ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"sin", "(", "t", ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"t", " ", "\[Tau]", " ", 
             RowBox[{"sin", "(", "\[Tau]", ")"}]}]}], "+", 
           RowBox[{"sin", "(", "\[Tau]", ")"}], "+", 
           RowBox[{"\[Tau]", " ", 
            RowBox[{"cos", "(", "\[Tau]", ")"}]}]}], ")"}]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["\[Tau]", "2"]}], "+", 
      RowBox[{"cos", "(", 
       RowBox[{"2", " ", "\[Tau]"}], ")"}], "-", "1"}]], ",", 
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Tau]", " ", 
         RowBox[{"sin", "(", "t", ")"}], " ", 
         RowBox[{"cos", "(", "\[Tau]", ")"}]}], "+", 
        RowBox[{
         RowBox[{"sin", "(", "\[Tau]", ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "(", "t", ")"}], "-", 
           RowBox[{"\[Tau]", " ", 
            RowBox[{"cos", "(", "t", ")"}]}]}], ")"}]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["\[Tau]", "2"]}], "+", 
      RowBox[{"cos", "(", 
       RowBox[{"2", " ", "\[Tau]"}], ")"}], "-", "1"}]], ",", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"t", " ", "\[Tau]", " ", 
            RowBox[{"sin", "(", "t", ")"}], " ", 
            RowBox[{"cos", "(", "\[Tau]", ")"}]}], "-", 
           RowBox[{
            RowBox[{"sin", "(", "\[Tau]", ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Tau]", "-", "t"}], ")"}], " ", 
               RowBox[{"sin", "(", "t", ")"}]}], "+", 
              RowBox[{"t", " ", "\[Tau]", " ", 
               RowBox[{"cos", "(", "t", ")"}]}]}], ")"}]}]}], ")"}], "2"], 
        "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"t", " ", 
            RowBox[{"cos", "(", "t", ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"sin", "(", "\[Tau]", ")"}], "+", 
              RowBox[{"\[Tau]", " ", 
               RowBox[{"cos", "(", "\[Tau]", ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"sin", "(", "t", ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"t", " ", "\[Tau]", " ", 
                RowBox[{"sin", "(", "\[Tau]", ")"}]}]}], "+", 
              RowBox[{"sin", "(", "\[Tau]", ")"}], "+", 
              RowBox[{"\[Tau]", " ", 
               RowBox[{"cos", "(", "\[Tau]", ")"}]}]}], ")"}]}]}], ")"}], 
         "2"]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["\[Tau]", "2"]}], "+", 
        RowBox[{"cos", "(", 
         RowBox[{"2", " ", "\[Tau]"}], ")"}], "-", "1"}], ")"}], "2"]], ",", 
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"\[Tau]", "+", 
        RowBox[{
         RowBox[{"sin", "(", "\[Tau]", ")"}], " ", 
         RowBox[{"cos", "(", "\[Tau]", ")"}]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["\[Tau]", "2"]}], "+", 
      RowBox[{"cos", "(", 
       RowBox[{"2", " ", "\[Tau]"}], ")"}], "-", "1"}]]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.7202462509043093`*^9, 3.7202462664769297`*^9}, 
   3.7202666365578613`*^9, 3.793502507302478*^9, 3.793502564206026*^9, 
   3.793502600397197*^9, 3.793908401237871*^9, 3.8232293123707237`*^9},
 CellLabel->
  "Out[2948]//TraditionalForm=",ExpressionUUID->"ec47cbea-6ad0-4bff-a40c-\
08b2bcc2c9ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"xdots", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"xs", ",", "t"}], "]"}], "//", "FullSimplify"}]}], ";", 
  RowBox[{"TraditionalForm", "[", "xdots", "]"}]}]], "Input",
 CellChangeTimes->{{3.720250795899788*^9, 3.720250813873839*^9}, {
  3.720250878844757*^9, 3.7202508843066397`*^9}, {3.7935025429789953`*^9, 
  3.793502579604291*^9}},
 CellLabel->
  "In[2949]:=",ExpressionUUID->"75308833-e72c-4d32-8b65-3cc617844d08"],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"sin", "(", "\[Tau]", ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Tau]", "-", "t"}], ")"}], " ", 
        RowBox[{"sin", "(", "t", ")"}]}], "+", 
       RowBox[{"t", " ", "\[Tau]", " ", 
        RowBox[{"cos", "(", "t", ")"}]}]}], ")"}]}], "-", 
    RowBox[{"2", " ", "t", " ", "\[Tau]", " ", 
     RowBox[{"sin", "(", "t", ")"}], " ", 
     RowBox[{"cos", "(", "\[Tau]", ")"}]}]}], 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["\[Tau]", "2"]}], "+", 
    RowBox[{"cos", "(", 
     RowBox[{"2", " ", "\[Tau]"}], ")"}], "-", "1"}]], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.793502580788739*^9, 3.793502600637374*^9}, 
   3.793908401466341*^9, 3.823229312596019*^9},
 CellLabel->
  "Out[2949]//TraditionalForm=",ExpressionUUID->"a03698a2-0cde-4c72-811b-\
49b5a9c108ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xs", ",", "xdots", ",", "Es"}], "}"}], "/.", 
   RowBox[{"t", "\[Rule]", "\[Tau]"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.720253525423861*^9, 3.72025360523886*^9}},
 CellLabel->
  "In[2950]:=",ExpressionUUID->"8d841a92-91f8-4e18-b534-f7fccc1d65b1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", 
   FractionBox["1", "2"]}], "}"}]], "Output",
 CellChangeTimes->{{3.720253527263504*^9, 3.720253605860326*^9}, 
   3.720266636975174*^9, 3.793502507592127*^9, {3.793502564285172*^9, 
   3.7935026006857357`*^9}, 3.793908401492908*^9, 3.823229312616866*^9},
 CellLabel->
  "Out[2950]=",ExpressionUUID->"3a5ef3a8-a53c-464d-8d78-496f9db95e87"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Plotit", "[", "\[Tau]0_", "]"}], ":=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xs", "/.", 
        RowBox[{"\[Tau]", "\[Rule]", "\[Tau]0"}]}], ",", 
       RowBox[{
        RowBox[{"-", "\[Lambda]s"}], "/.", 
        RowBox[{"\[Tau]", "\[Rule]", "\[Tau]0"}]}], ",", 
       RowBox[{"Es", "/.", 
        RowBox[{"\[Tau]", "\[Rule]", "\[Tau]0"}]}], ",", "0.5", ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]0"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Green", ",", "Dashed", ",", "Thin"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Blue", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p0", "=", 
   RowBox[{"Plotit", "[", "1", "]"}]}], ";", 
  RowBox[{"p1", "=", 
   RowBox[{"Plotit", "[", "2", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plotit", "[", "\[Pi]", "]"}]}], ";", 
  RowBox[{"p3", "=", 
   RowBox[{"Plotit", "[", 
    RowBox[{"2", "\[Pi]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p4", "=", 
   RowBox[{"Plotit", "[", 
    RowBox[{"3", "\[Pi]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p5", "=", 
   RowBox[{"Plotit", "[", 
    RowBox[{"10", "\[Pi]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p0", ",", "p1", ",", "p2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p3", ",", "p4", ",", "p5"}], "}"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"600", ",", "200"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.720245646230986*^9, 3.720245701756651*^9}, {
  3.720246049513378*^9, 3.720246050159526*^9}, {3.720246572994261*^9, 
  3.72024675761604*^9}, {3.7202467886767197`*^9, 3.720246817297009*^9}, {
  3.720246847954503*^9, 3.720246961573188*^9}, {3.7202472442963448`*^9, 
  3.720247326110471*^9}, {3.720247949440447*^9, 3.7202481959861*^9}, {
  3.7202482307270327`*^9, 3.720248233291959*^9}, {3.720266619310403*^9, 
  3.7202666201245613`*^9}},
 CellLabel->
  "In[2951]:=",ExpressionUUID->"60cb0b5c-79b9-4dbe-a996-ffdad42a93f5"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmXk4Vd37/02JhESKlBIiQyia3RWhDJkykzmpCAnJVAiZQoZIFBUpMhNR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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[
             PolygonBox[{{245, 231, 229, 238, 239, 240, 241, 242, 243, 244, 
              742}}]]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[
             PolygonBox[{{228, 230, 229, 237, 236, 235, 234, 233, 232, 
              741}}]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}}, {{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], 
             LineBox[{1, 181, 141, 221, 108, 214, 174, 225, 82, 207, 167, 223,
               134, 218, 178, 63, 200, 160, 127, 216, 176, 101, 211, 171, 138,
               51, 193, 153, 120, 94, 209, 169, 136, 75, 204, 164, 131, 105, 
              2, 182, 142, 109, 83, 64, 201, 161, 128, 102, 52, 194, 154, 121,
               95, 76, 3, 183, 143, 110, 84, 65, 53, 195, 155, 122, 96, 77, 4,
               184, 144, 111, 85, 66, 54, 5, 185, 145, 112, 86, 67, 55, 6, 
              186, 146, 113, 87, 68, 56, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 
              17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
              33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 187, 147, 114, 
              88, 69, 57, 45, 188, 148, 115, 89, 70, 58, 46, 189, 149, 116, 
              90, 71, 59, 196, 156, 123, 97, 78, 47, 190, 150, 117, 91, 72, 
              60, 197, 157, 124, 98, 79, 48, 191, 151, 118, 92, 73, 202, 162, 
              129, 103, 61, 198, 158, 125, 99, 80, 205, 165, 132, 106, 49, 
              192, 152, 119, 93, 208, 168, 135, 74, 203, 163, 130, 104, 212, 
              172, 139, 62, 199, 159, 126, 215, 175, 100, 210, 170, 137, 219, 
              179, 81, 206, 166, 222, 133, 217, 177, 226, 107, 213, 173, 224, 
              140, 220, 180, 227, 50}]},
            Annotation[#, "Charting`Private`Tag$1219042#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], 
             LineBox[{741, 232, 233, 234, 235, 236, 237, 229, 238, 239, 240, 
              241, 242, 243, 244, 742}]},
            Annotation[#, "Charting`Private`Tag$1219042#2"]& ], 
           TagBox[
            {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl1HV81WUUB+C7UaNhdDM2NhARJKRLRRAQCRUQBJwKiko3KHZioZIqEoqK
XZQgoSKolJ10h0E3z/n4x7PvOee3e3fv+57P0rIHdRmYlEgkHvXjmKyUnEhs
UA+Uz8o+sgij6KPvJJMYxgp9f1mapurL5WH5Ebeoi/OAuofMx1p1Neqqd8i5
DOM6fS6+jPennfq0XMITHPe5KpttVD9HX5pxhdkR+TEPUp16ZjvlawynMye8
Ps18k3oSN9Oci6hvvku+zgi6cNLvVzH/Xv082bSgBqc8S/fsB/UL8T1pycWc
9uwMZznHeRLmSSSTg5zkIjd5SCEv+chPhvf+Ub7IrbSiJgWo6tlPcjK3xXlz
CZeZ75bzGElXCpJp/rOcQr84L2rRwHyPfINRcf4UIsv8Fzk17pUrqU1D873y
TUZzPYXjLs1/ldO4ndbxGrOj8hMe4lIame2TbzEmXq/PzVfqG2ivPiM/40mK
xF2a/Sanc0fcoz6Zleqr4m+pj8lP45zUJXhYfaPMzzfqO2V56qgby/1ysJwf
OyBTGRufQeZhOKvj78my8Yxu+g7yrBwil8bZy5KMZqL+JlmIEazT3yUrMI6i
sWfydzlIzoj9jTkDYt9kDlbFGcoytInvKI/LBTxCT30BvlXXpYn6gHybcXTT
p/C1ujvXqM/JZTxFauyv2R/ypTgb2tLG7IRcmPT//4B6NDU7KN9hPD0oFjtu
/qd8Ob4jV1OfZuaH5LvcE3dA8dhb87/kK9xNu9hVSsTeerZZziT+AbWPvaQk
pShNGcpSjvJUoCKVqEwaVUiPvfZ+W+Srcc5xZ7G3NDf/W77HvXGOZMRem2+V
s2In4rxiT2lh/o98nwn0omrssfk2OTv2gI5xfmYn5SIeix2jpdm/8gPui92I
3zU7Lz/naTKpY7ZdzmEoXfU5+UJ9bZyt+pRczOPxOfQF+S7unlbq/+SHZKuL
cX/cvczLGvUAWY7e8Z4ywVCW6/vJUozhGX1vWZiRrI/7khUZT5b+Aph8q8U=

              "]]},
            Annotation[#, "Charting`Private`Tag$1219042#3"]& ], 
           TagBox[
            {RGBColor[0, 1, 0], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{637, 687, 638, 639, 640, 641, 642, 643, 644, 645, 646, 
              647, 648, 649, 650, 651, 652, 653, 654, 655, 656, 657, 658, 659,
               660, 661, 662, 663, 664, 665, 666, 667, 668, 669, 670, 671, 
              672, 673, 674, 675, 676, 677, 678, 679, 680, 681, 682, 683, 684,
               685, 688, 686}]},
            Annotation[#, "Charting`Private`Tag$1219042#4"]& ], 
           TagBox[
            {RGBColor[0, 0, 1], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{689, 739, 690, 691, 692, 693, 694, 695, 696, 697, 698, 
              699, 700, 701, 702, 703, 704, 705, 706, 707, 708, 709, 710, 711,
               712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 722, 723, 
              724, 725, 726, 727, 728, 729, 730, 731, 732, 733, 734, 735, 736,
               737, 740, 738}]},
            Annotation[#, "Charting`Private`Tag$1219042#5"]& ]}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Background->GrayLevel[0.97],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{16.1530612244898, 1.5}, {7.500000000000028, 6.5}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 0.9999999795918367}, {-1.5, 1.5}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {193.5, -118.66252583997979}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdm3k0Ve/3xxGRjCUZowwRCQ2a2GTKUClC5kyVSGlSpBRRCUkqUyqkMiVD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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[
             PolygonBox[{{282, 844, 842, 271, 272, 273, 274, 275, 276, 277, 
              278, 279, 280, 281, 339, 326, 314, 303, 294, 288, 342, 329, 317,
               306, 297, 344, 331, 319, 308, 345, 332, 320, 346, 333, 
              347}}]]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwlzNlKglEYhtH9a5YNdgNNmEnSRBFlUgSVoRhUiuG5F6DXXZk2mpVaCzpY
PLDfzZdutmutWAghos49V/EQKsx7TDHHLDNMk2SKSRJMECdGFP0f+5UxI4b8
8M0XAz7p88E7b7zywjM9uqy4lWWHApfUeLIt6xrbHFGkSse2pBm2yHPBLY+2
nO5xQpk7Flllk0POueHB/3Xd5ZgSdRbY55QKDdJscMAZ1/wBJj4itA==
              
              "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}}, {{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], 
             LineBox[{1, 185, 144, 226, 110, 219, 178, 230, 83, 212, 171, 228,
               137, 223, 182, 63, 205, 164, 130, 221, 180, 103, 216, 175, 141,
               51, 197, 156, 122, 95, 214, 173, 139, 75, 209, 168, 134, 107, 
              2, 186, 145, 111, 84, 64, 206, 165, 131, 104, 52, 198, 157, 123,
               96, 76, 3, 187, 146, 112, 85, 65, 53, 199, 158, 124, 97, 77, 4,
               188, 147, 113, 86, 66, 54, 200, 159, 125, 98, 78, 5, 189, 148, 
              114, 87, 67, 55, 6, 190, 149, 115, 88, 68, 56, 7, 8, 9, 10, 11, 
              12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 
              28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 
              44, 191, 150, 116, 89, 69, 57, 45, 192, 151, 117, 90, 70, 58, 
              46, 193, 152, 118, 91, 71, 59, 201, 160, 126, 99, 79, 47, 194, 
              153, 119, 92, 72, 60, 202, 161, 127, 100, 80, 48, 195, 154, 120,
               93, 73, 207, 166, 132, 105, 61, 203, 162, 128, 101, 81, 210, 
              169, 135, 108, 49, 196, 155, 121, 94, 213, 172, 138, 74, 208, 
              167, 133, 106, 217, 176, 142, 62, 204, 163, 129, 220, 179, 102, 
              215, 174, 140, 224, 183, 82, 211, 170, 227, 136, 222, 181, 231, 
              109, 218, 177, 229, 143, 225, 184, 232, 50}]},
            Annotation[#, "Charting`Private`Tag$1219098#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV0MVSREEQBMC3LO7utri7u7suDjc+AC78NO6uySGjYqK659CR49PoSSgI
gjPOWfOYpJcmIuyxxBjdlLDNPMN0UM+F/XU5RR/NVFHKDguM0EkDl+Y35DT9
tFBNGVe6TTnDAK3UUM61LipnGaSNWiq40d1yxz0PPPLEMy+88sY7H3zyxTc/
/BL4K0QMYWKJI54EEkkimRRSSSP9/1bhIMiQmWSRTQ655JFPAYUUscUcQ7RT
RyW7LDJKF43ss8w4PRywwgSHrHJEMX8/RCkX
              "]]},
            Annotation[#, "Charting`Private`Tag$1219098#2"]& ], 
           TagBox[
            {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl1He4zmUcBvD3aGgp7UVFidKkUrQHDQ2UVOax57H3ni1KG00rLTRp0rBH
g0qpRNHWQNr1ua/++Jzv936e9zrv7/eMt0JxSf0uRYVCYbQ/jRldqlA4ndX8
Ji9U+/IJC+W5agfWcCwrGcoUc4+pN3AoSxnIN8bnq92pxjh5kno5ZVgrv6J2
4QTmyk+rLTmSn+UmjNGfwe/6RUzlcbkx5fhWvo379VewZ55ZfpGm3CjX5A/9
YqZxOw8Yu5K9+FR+iWbcJNfiT/0SpjOe5txs/Ez+0i/lUe6gBbcYP4u/9cuY
wZ0U05JWtKYNbWlHezrQkU50JptSQle60Z0e9KQXvelDX/rRnwHc6rvP5h/9
8uwJdzGQscbP4V/9iqwfd/Ogsasoy2fyywxinHwuheyz/AT38JBcj71Zl/1j
cNZfPo8i3paf5F4eluuzD5/LrzIk6y+fTynekZ/Kd+ibUJ7v5Pt4RN+AfVkv
v8Yz+lYcxS/y0OyP/gJ24F15Zp5B35TD+F6ewGT91ezHhjyPWsKJzJOfVVtT
iS3ym2ovTmVY9lq9kB1ZRD/ey1lTO1I175/PMivvpTbjAw5nGYOy1vxg/nW1
Bx9TPf+LkVkrJpqfol7D++zPYvrnvPJF1kPtykeclLVkOPPNPae24WiWM5it
xt9Se3NaPpszql7ETqzKPVA7cRyzs5Zqc45gc+5w7qC+IQfwZd6D5/Vtqcw2
eUTOn742O7M69zv3NHdQvpYD2Si/wcicSbkOpfPO2evcU0bl/Bm7mF2yntmr
nN+i/3+/xuSe5+7m3Jm/hF35MOuQc5u7mzNl7FJ2Y02eOWc0d1xuxEFsyr7n
PufMyJexe9ZYfoFZ+hZU4Mec0fwO6K/jYL7KGuez+nZU4dfcTybq67JH9jz3
Te3M8cyRZ6vFVOSnrIvak1OYnN8U9XoOYQkD+Nr4PLUbJ+f8M4IFxueo7bMO
HMMKhrCO7eYXqH1YS43sP6NYz1jz/wHsRdca
              "]]},
            Annotation[#, "Charting`Private`Tag$1219098#3"]& ], 
           TagBox[
            {RGBColor[0, 1, 0], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{738, 788, 739, 740, 741, 742, 743, 744, 745, 746, 747, 
              748, 749, 750, 751, 752, 753, 754, 755, 756, 757, 758, 759, 760,
               761, 762, 763, 764, 765, 766, 767, 768, 769, 770, 771, 772, 
              773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 783, 784, 785,
               786, 789, 787}]},
            Annotation[#, "Charting`Private`Tag$1219098#4"]& ], 
           TagBox[
            {RGBColor[0, 0, 1], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{790, 840, 791, 792, 793, 794, 795, 796, 797, 798, 799, 
              800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812,
               813, 814, 815, 816, 817, 818, 819, 820, 821, 822, 823, 824, 
              825, 826, 827, 828, 829, 830, 831, 832, 833, 834, 835, 836, 837,
               838, 841, 839}]},
            Annotation[#, "Charting`Private`Tag$1219098#5"]& ]}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Background->GrayLevel[0.97],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{16.1530612244898, 1.5}, {7.500000000000028, 6.5}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 1.9999999591836735`}, {-1.5, 1.5}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {580.5, -118.66252583997979}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdm3k4VO///+0GrYiEFImQECUxr5NUlhIpKkslkiVFlrJLthbZo6wtQiF7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         "], {{{}, {}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV0mV4lQUYgOEz3ChpCWlGKN0gwmikERkp7ahRG6F0d0l3SUu3tAFIo3Q3
oqR0KXnvx32e932/6zrfj3NCI6LDo2IFAoEgQnwUp01wIBBJe3OYhyEU5rT9
DbnNa/RPnpHVPl5/ZC//ks6tpw5nLj9zg4/c22lbImPeRWta0ZIWRPANzWlG
U5rQmEY05Gsa0INhzGEHf5HMO+prd4Yym+1cJ6ln9XQcS9jDPdK6d9MhzGIb
10jiXlfHspjfuUsa9+90MDPZylUSu9fR1fzBU7K4fa+L2M0dUrt9qys4yCMy
uQ3So7zgE/sM3cIVEtlr6ylek8u+SoM0P4fNT8hsHqMfaEGOmz/T/zS7LtTP
9Z3m1V1aRG/rx9pVS2gwhThhL6b/aw5dHvM/ifnTkI8D9qL6UDPqQI2lBThi
fk4283R9Sx7zZr1MQnO4nuQVOe0r9RCPCbWP1mO85FP7At3JLVLZu+gy9vOA
DG4DdBqbuEQCt1o6ivn8xk1SunfWpezjPund+utUfuIiH7p9pSOZx6/8Qwr3
TtqPKWzkAvHda+oIfuAX/ia5e7T2ZTIbOE889y81ij5MYj3niOtZDe1Ibyay
jrPE8ay6VqMqVahMJSryBRUoTznKUobSlKIkYTG/Nx3oxQTWcobYvv89MIWE
BA==
              
              "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}}, {{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl1HecD2QcwPETQhEZWRmX7Tp3mYkko2SvSGUro1BJyIzKbKlk77IqIyNS
9mzYoygaVkYKGWm8v6/+eN/neZ57Xnev1/f53SV26Nm0R5qEhITKvkT/YBkp
Ni9rET2uFbSN5tFDWlbna2k9q3drTc2iOzVVp2kJ/VUraj8tqD9qOV2kyXo+
9txgvUnfoZj1Se1Bfusf9COSrM9pM3JY79f3KWl9WgeTaP2LfhI/kwss5xWK
+t4JbUte68O6gFrcYr9Lp/Mihex/0sWUJ639Zn2Xntxuf0Q/pjk57Q/oBwyJ
+1xkBa/SjtpkdW+3zqB/zJZ0zrboOJ7hYXI5O6hzeCnucIlPGU57HiCbe3t0
JgNi1qR3tlXf41laxBl/spIRdOBBKnGj+9t0PM/RMs64zCpG0pE68dZkcH+7
TqAXj8QZV/iMUXTiofhskdH9L3Uiz9MqzrjKakbzBHW5h0xc43PG8CT1qMJN
/MUXvEZn6lOVm7nOGl6nCw24l8xkiXeON4i5cSvZyRHvFzPnNnKTJz4j5CN/
vDcFKBifDQqTyB0UoSjFKE4JSlKK0iRxJ8n8zVreoCsNqUYZ/mEdb9KNRtwX
8zC/r3QSvXmUFP5lPW/xFI2pHjNy/2udzAs8RirxR75BxvI0TWIGzvbqLAZy
f8zR2Tc6hT48HnNx9q3OZSh3xY9ztlHfpnvMyv57/ZCmMVv7fTqbQTEz+591
CTXiTex36NSYm/Up7Rtztj6qC2Nu1r9p63gX6+/id+u8mK+e0Uo6LN5Cj2l5
XRoz1d8T/v//Vlb/A7aYiB0=
              "]]},
            Annotation[#, "Charting`Private`Tag$1219154#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwVznO41nccx+HnZNfCMk5bbsu2l+0tnLTslm3btu1aW7aWbWvZuPvjPq/v
5/27rnNOcEjrSq2CAoFAaD9yEy5UIHBOVzOGrrQgD3nJR34KUJBCFKYIRSlG
cUrwGyUpRWnKEN7vP69rGEs3WlKWCL5d0LWMozvf/7lyRPTtoq5jPD1oTWz7
Hd3BLAZTnkj2S7qeCfSkDXHsd/UfZjOECkS2X9YNTKQXiW1PdT+LacuPtnv6
L3MYSkWi2K/oRibRmyS2Z3qAJbQjru2+7mQuqdzv9CTDCHa/0MMsJ637o56m
ElHdV3UTv3h/0cmk8H6jx8nkHYo+3kn1f82uBzWDBsjNUnca/aA59ZRm0TDk
ob07nj7QbLpLf9WvmkvnaWp9rzn0P82soRnunVxf6hEyegexwjudftIzVCaa
+5puZgop3W/1BH1J5n6uh1hGB+LbHupu5jOCn2yv9CgrqUJ023XdwlT60ZEE
9ke6hwWMpCox7Dd0K9PoTycS2h/rXhYyimr8YL+p25jOAP6iOjF9u6XbmcFA
OlODmtSiNr/zB3WoSz3qE0IDGtKIxjThT5rSjFj+xm39m5kMoguJ7E90H4sY
zc+213qMVaR3f9azZPUOS16au78BTRmDKQ==
              "]]},
            Annotation[#, "Charting`Private`Tag$1219154#2"]& ], 
           TagBox[
            {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV1GWYVmUUBdCPUkQUMVAwCMUWDMRApLuHbhg6HKS7u1FBlLZpUMEmpbu7
DUDEAIOGdX6sOWe/d565X+w7OZPbJaWkSiQSK/0omDqReCtNIpGPPzgtHzL7
coEF8kYzhfM8zElGcJkhrn9n1udv7uQEg7nIPtd3m934j2f4jdFcpZ3rM81y
/EmCowxgjWvbzI78w+OcYiRTXVtltuABfmFY3Nv5PrMnz/I7Y3nd+dvmi3F/
+2GzHwvtm+J18AhD5e/NBtzFT/Ee2e98j9mdPLwpzzLLk4pjDGSt8+1mJ55g
mrzabMmD8ffk/WYvnqOQ/I6ZnzP2z9kcf5/c8Z7kH8yG3M0BuT2z7RVIzTp5
h9mZJ5kurzFb8RA/y4UZb38pPhP7FwxnidyIezgod2COvSJpWC/PYK29Ndnj
s5aLMMH+MmftXzKCpXJjsnBI7shceyXSskH+gKK8K78SvbMvYiTL5GTu5bDc
iXn2yqRjo/whxZgovxq9sS9mFJ2Z76wKN7FJ/ojivCcX4C/7V4ymCwucJXEz
m+WPKcH78mvRa/vXjKErC51VJT1b5E8oySS5IOfs3zCWbvGdOqvGLWyVP6UU
k6OXnLd/yzi6U5op0Y3ofTxf8YzSgzJMdV6Yf6Or0Wt6UpZpzovEsxa9iW7R
i3KUpwIVqURlqpBEVapRnRrUpBa1qUNd6lGfBjSkEY1JpglNacZ09y/K/9Gv
6B29aR5dcl6MC9GV6BB9oo/OqpOBbfJntIiuyMW5GN2IztA3+uasBreyXZ5J
y+iGXIJL9uXREfpFv5zVJCM75Fm0im7IJblsXxEdoX/0yVktbmOnPJvW0Q25
FFfsK6MjcR+5CfdxRB4Q/bLX5nZ2yXNoE12RS3PV/mN0Ju4rNyUrR+WB0Td7
HTKxW57LOnsbcvCr3Da6ZC/DNfsqttjb8yiT4zWazcjGMXlQdNNelzvYI+80
u/AU8+T1ZltyclI+YPbmed6I78Ysy3X7EbM/q+1bzQ48xpR4f2Zz7o//QQzl
uPO9Zg/ycoYxDI5nwKwXzyeZ43cZxF7Xdpldo/M8zWlGxffAfNc3xGuLZ49c
8fkwPHrAKdcPmn2ik7zAWcbF50aK6zcAEYr91Q==
              "]]},
            Annotation[#, "Charting`Private`Tag$1219154#3"]& ], 
           TagBox[
            {RGBColor[0, 1, 0], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{1023, 1073, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 
              1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 
              1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 
              1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 
              1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 
              1071, 1074, 1072}]},
            Annotation[#, "Charting`Private`Tag$1219154#4"]& ], 
           TagBox[
            {RGBColor[0, 0, 1], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{1075, 1125, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 
              1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 
              1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 
              1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 
              1113, 1114, 1115, 1116, 1117, 1118, 1119, 1120, 1121, 1122, 
              1123, 1126, 1124}]},
            Annotation[#, "Charting`Private`Tag$1219154#5"]& ]}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Background->GrayLevel[0.97],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{16.1530612244898, 1.5}, {7.500000000000028, 6.5}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 3.1415925894756573`}, {-1.5, 1.5}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {967.5, -118.66252583997979}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}, {InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxEm3c8le8f8G3H5tgNq0GaMlLhc+WLoqKslJmkQoqkrHahJCuhQUpJ2ckq
F0JIwjkZGUcySvbenvt5Xr/7PP3T634d3Nd93ddnvd7nLe94zvQkGwsLSw4X
C8v//Z8d89b+Vr+uk9rgLBXPebwwfMwmOzoCw9PqIpY7/Cvw7nIjXt0LdfCE
EvvwgtlBfN7X+Hj2+WZwuZQvyPXzFD6bdzKUbU0nhHgoqr7Z4Ifpfwx5Xjt2
Q2GyGJ/89F18d+sUy4ejf0CT3X+rUVQ09thY+bA4aQA2v/wg4DfzHM+dcE1r
dx+BQU8ZXuPzKdjxk+WhMOcxYPHydpUXyMInRunFxUETEJVdC9OQh0O25Z57
dWcKKgYN/ln3FmG24twdt3xn4LyZqn+O2Gcsory/lhEzB5l7nv3KP/4F74vX
fTESsQBemVdHK1O+YsnhGoOruUsQff0+m75uHY77UsDKfoYFdds4GydkNGCt
1XuW5ZxY0ThV8GflGB1v7BTuDvBiQyxtnyK2mTXh1GTq6RxPdlTVk7JQeaYF
+3fY0jbe4UDrm16ejvRuxR5amvufRXEiCWu8a+e2djwXr+f4L4wL9Yp87nX2
7cB15+McLiVyo0MFUS6XvRl4516FpfbnFHTYVfvCthEGrtLfmYye8CCaWI6W
5igDJ2XG7ux6y4sShJ6dqnRkYPE1m1zs3vChDp9D0YPGHbiBlXJD+iM/erfb
6mX99TacQ7nwqq5KAEXr3SufFP+JN4kLuziWC6KRtF9N33Wa8HDolJhqoxDi
vMFZ8+geDa8JDNx6zkUYbfxnYnuT+h13HWv9qdsnjFb6C0UU61TgfT202Rx3
EbRve3RnjmMuvux58rTEoAgyfqko83v4Gjb+8NhIwpuK7sh99Csw+wBDCy7+
7FNUpDN5xe+LwBd43nT9vfsFUTROmfA8EFAPc6e1HXzmRZEJJeN+zHITrF4M
t/bwFUPtdwRFdVg7oHfvvWoKhzhSuB7+SkOpCz6vrwGZe+JoRen3hhqJHnCh
vOKQ55FA7QlXBx4/64PchLXan8MlkPO+/z6eFuuH2t1a5aYikkhA+ivLXcEB
mHF5bOYQKomWd6d9FH01CJWH4i0EJKSQU4pa/N+RIXDcqfX6dZQU+puUZ66T
PQwqu9/sn5eXRjnL//ffMJi6Sf+MiUiHSx/GPZXE+osYrAq5fUcqYfuYyG9X
+g7cGF+TM+dBh0+XVxkE8tvgpEl+sLFug4jZkrXuQZ44oa7pK123CxIgU+P6
3Zt4K7/c7S12vfAl5ZxkwptwfGWz/f7Cq/0Q1lqoU1X5BGf5mMx+KhmCn3rP
HaymknCa8PHlDy6j8OWk9UtfwXTsLbBf6KQAJxps370n1bYNa7gXNZZRuZC7
V847uc52fDLo3PFMaW4UcpZ1XpObgTls7NKVFShojc6Rv+0lDHy9YrOZkCwP
ellZ1r64zMC5fn/Pi6zlRQ/2Vhsc/MTAtv1dhxOU+VD+NkW1W/0d2Iu6Yqpw
Oz9qrZVyLgxox3q3tcUmdQUQ453gg9cOrXgkdE9Q7F5BZBBkPq35sRkLmt7E
1QeF0EqzcyYXfH5gXfdtrPfqJZCFmPCM8qp/cILmGtJiIoni5a/HTfYMQKft
U7pGgyRasIidzTo2BOLlZ68cs5BCAfo6H9wdhsGowNPncKsUugt9KkkDw/DD
PkLxaUQ8qMe9fLlCoqAoSvt0UKxwGTx5p8rNm6eMg7L4HJ55NsAHo42ZnS/N
MW/e5jpu55/g33Ra4Mv8WXynTCb13/ZfsEXQdOqf4zV8Y07ti4tDD/SoHFh1
ajoU30pTfpXn9hfU5O/HpIXF4oiGe3tx9iAIikes4/vzApvv6rWsHhgBofo9
vemZ7/DsRXOPyioOBG6XHt8faMXmFvNhmTROdEuij1F2tx1vE/t53PgHF/Kq
F2Y5XtaBXZwXuA93cSPfk3PeOfEM3M6VnOzdSUE8bJY7GucZuNghnH9DJw9a
d2HnVbY2BmY1LtLf848XiSiEPebcyMBlK9ZsExjiQxFO1Zov/7Xje58V9gcu
E/GvebP77FQrbth/TDKHIoh2q5+kRJ5twU+zq6KieYTQ2s86veh4I/YPVJZ9
nSmBeGiTM+1x/RDDTVeK3iaJss7VvxILGAA3p1VR+zMkkdPhWxLSHEMwdJer
P1tdCu3yfsurumkYGn2OhC3kSqEVx86YJNKHwZauFjaamgsTzbyFh5c4sXJF
a496fA3cXP/vF8PyP7zm/n2+Ix6NcOaZicSXG44YqQ6kZhzqgD+aZ4L8o7xx
QVtY/yfT39A8tPyrUygQt63m+2/Mug9YXNIP53NF4cvvIkc+RfyDdSKadgMy
CVgq8Pqq5sNcKNpw84Totg4ct8BxXMyOG+k9OtH5VpeBnx0utuRwpKBkvQq1
EmL/1t3JXnxty4OkzjofuLbAwGnRe37MnuJFixoqLSNRDJx/h9tu+QwfwuO9
kZufd+A1vCIfXS7xo/VGVSVrONvxlnj2kVXnJJGSUFIfm+EgmB+REVeYkEQb
3Ap1st4MgdYyncp6UQoZJwk+9r8/DEVz9x1fLUmhVtpu67Xzw/DT4FZpUsQD
uCIWx3gjcbfI3ZrPY2ygBLYePssbL7QGd+3eqD7iWQ/q3lxZVP/DWFu6KMbW
tQXmA0fH/L65YF+d0tXTKZ1gturn56FfAfitB/wJ+tUN/MWrxpf/hWDuc2Fm
O37/AY+rv6dW8MVgtuU3Q3jTIMSMPubzGEjEit+T2eipI5AvdzY04v5bvEv5
qMLcaw5kzpmspZjVirsqpYcU33MiMdfbF+Xt2rH4MaGuVdlc6FR97vR/CR34
qet+NadSbjR51cR16h4D8ymeNFMuoaB+ydiHI1MMrGd28qdaEQ+KcNyUU93H
wLTltzj8Ky/isWs2XdzLwAPPFL/lfOVDgoM/Ch/LdOA0x4fOde38SNT365Cr
dhvWS+nt0P0rgKSCzg/+Lm3BTt1uV/37BNGMDuPv4fpGvCJKcUvOcwnkZsB1
QN+qH7LlKZcm5CSRv2E747rBAGT1tY5bxEuiawalNJbGQWgdbIjvXCeFDLgD
Fs4KDcOTlqqVpq+k0Adu1a0ryofhv/KEpWeF2WBybvDUPu/ZIo7uK7WhftWg
n3vTdTZZB/tLpHYme/yAVQq8SgeUHbBnlL83l2U7SFA3plcFeOFUSzXrquou
aLijKqS+5zbmeijuJNzeCyInvFpVGiLwvNvsUy2ef+BUXTMY7/cMv56L9zHe
zoW0uoJ+V1M68DXdXb+6dnMj8weGW3+vY+B6S6GbkroUtBVf2rS7joHNXp1P
ttbhQQ5jL1ZqEPl5e7D4C04DXnRL19bCMoWB72lONpkY8aGmUNe2iYoOfCBU
/KioBT8SOSQIFbrteF/+Dh0/e0l0aNu04U6pQYj72e616bck8lGv/650cwiU
HJ9Xbj4phY625x1uvzQMt46xDM0PSKEDqUn7JSeHQcZ49MN46mvgPNRAnWRt
LCqQLY9HahUAGxZfr5HajrduGLh7wJMGE2NHLtcrWeFmy6fcWQ6tsNfUIcgr
+zw2qn356+o0F0rQf+Cb09uBdxxPbdVmo6CNqQyL9EwGTu/tXyxdpqDnyS+M
2pYYWMv9k85qNl6kWa1j//MbA299Uvd1hJcPrciuVO3gY2A2pV1qgfpSyGIm
KFFt7zAIr+jheF0lhepogTINv4bh0u9Keb2EQnCTWbljwUsEH0rWXGwrrYX0
q0aO/y3uxW4HPJRHr1PQxevd212I8zl9csp0wp8HxVov/miaZmDll2e5h4J5
0bmhGROpAAY2eUKxpd+SQqf4Ohv2PR+GmbiVTYeEpZE0VehK5dIw9IidnvkQ
cRVCDt9hH5c4VmTdb9Mj01oMcdWhQbvfy+JQlkJZ6fE6WPM3u9uRcgg3GnIF
UIaa4fhez093DpzBXvOijQvOnWB7N/jRmWv+GKWWzUgmdoN0+91T5UP38D6T
/1K8n/2B/EZW9vaDj/Au8Z266O8A5OzYcuCGRyIOk77bbBU6AoohWy3El1Kw
9a3WOeojDvRu9fzZG1GtOIXtzaoTLzmR8WvlqxZ72zFlcYMCRyIXYmTy9IXc
78AaQ57VZ7O40XfRNT3u1xlYIfez0q1MClJ3uX/j6zgD3zlgUrIrlQc5cxj4
1Aww8MfmxIX8Ql40W7kJki0YmOXXm5V3C/gQm3D6DukdHRhlGU9M1PCjB04z
X0ft27B/y7vS4BYBxPNWpub9QAuu9C/yOtcoiFi6Gr1PUJrw6RWv1D/GSqDj
5v9WXdXoh+ItCs/WSEuiqjvy2lnKA2DxpnBNa7Qkcs1+ek2vaBBMZfPnplZL
obPvD3qdYBmGqzw3f/k/lUJHnqx09/44DB8+NeZcLM2EKZsffHZhY0VjnnW6
hWeqQHWqsWrDit14Q6vW1/pROqh/SfcvXGOH+cvLjmU2t0FmxEodlqsX8CvR
O6Lf73RBj4XVkW7HWziuLs4r/mkv1HodanPTisBaB99N+JX1g2DosWCjhKfY
XW1rcrACF4qdXRPwfKIde/aYy1crc6P85OLSKgkGdmnRkJbfTkGuWbvE9lYR
1xrfA3K28KBy23sXmoh49rqxHMynzkuU4jMWsu+Ja5EBscu7iH7essKWvaUD
O9Q9et33Hz+q8w87Ge3Qji0rDp9MOSKJXv9442iwPADaTz69zPwpiWLE6iQ2
nhuCZ5GBa/RspdCZl5Bp7zYMp+7mZ6/vlkL/usUSlEeHgQNs1z0vfAFqXraR
mj5VRa/TJMTOKpTDo2jVjLU7tuK2Qb+LF8caYKjI+bCytSX2COz5Z/P7J6ze
yOfw9M05rO2B5U/1cqHu9lONZT+I+eU33WPvGDcKSgpy/5fMwBXehrRVIxS0
pzzsxsNFBr5y6vW6NaM8KC7mYtGuHwwsdfELRXqeF63RXCmQt5KBLx+Ve/BU
Wwq90Wy9M7BzGMYNn1XXF0shLkZd0O3WYehvXWpe8Tof8n/8qT0xyYe1d9z1
4Mn8BltoKkCP0sec32OK5zwo6MqlxYzDXQwsOGWuZHyWB12zu5vmMsfAbk+P
DI1f5kVOfn5aZsHE+r4N5fb7S6FD30TMnz4ahtZq+hM/bmnkYxJT8d/iMDzf
48Ixk/oI6mTrff6wvSq6XpO/UL5UCqHzEvPd79bjiWiuK3V1FLROTogSP0vk
o2N+41u+8yCVjAq97cT9898IWyqmSyHxjXysG74NQ12Ny97K9zlAL7MqsB9l
wZIWm4853v8K1y78nf63Zw/WpPcNCJhS0LeWyIv5jUT+k6DSWI15UJ/yEkgT
+fC58l6l+kkpdCt9IttlZhg0bW/vM0h4CydWDWz6c/lXUU3YhY1iBl8gYcJ7
BNPVcIxliNIZIR6kXq059oY4X5v7N4J/gxQ6PvT4VmAf8f7/Rbicjf0E5zpe
bcq5JI4bqgyj+sIpKNXpDwcvEd+dPx4FxIXwoPg+LbUvEwws5uoosl5aGiWu
C+fPIuafuYytTi0R5yB0Zd6UiaRyUUPmbVl102IYu2O/rbByFe7uYnu4ObsO
cjIy+gbfGeM1jsrDtunNEHm2rc8v/DQeadHKWtbrBB39D6LZND/Mu5/7uv2N
brCPYVHb43kPn8FPLCT8/8Dvvvthz0aisWUCi9u1LwPA4ajRWKKWiMuLfP97
fGUEbGNXTc99SMFumatOxYdyoO+B72Wjbrfi0PiR7GtPOJHI2QNW9bvb8XXj
HaWXYrlQTPHjbO5bHfhm+p2HnincyKa1zIfVn4G3LHuKZr6hoMsNkhn8Ywys
ZFj2/tNL4rzu0BYWH2bgbfoyK2uzeVFBlleSoQ0D87L9053I5EPKqUm3pf7r
wDzHNu4OLONHlz4EX5o634alRh+opdYLIIP6i3tPsf7Ec/tODf/5Jogey/Ka
pa1pwmG2J/PxQwkkKmfUG7CuH/aqp6vsFpdEtqrmim9WDcD6u28Ln0ZIImF1
x4RdWYMgoLlJiW0FEc+NP13ezwzB+ef2etRYKRSj87drIHcYRvI9RH6VZ4CW
1q9bp/cOF53eNetf31kJ0UdWhVi578TXPt1CvZl0iHj8wXFSzBZbtf+p4Ypr
g8O4WCWL7QJeM5Y2XO/UBYk+T1ZPTd7ETu7tC70BvWDXL/rl9Vg4tv3EmbAy
sR9otLI3QmpPsWm9N7xewYXENDZMuPa34wENxxJtBW4kJ9+4U1iImB/jjLrX
KVPQnUP64s/LGdj7ypXTXeuJ/TzYvzBLnEeJq14BoZt4Ue3M7VdVeQz8J+CU
ash2PiQVLuvz4xcxD4021x7ezY/kzZz36pxrx201HTMlZpJI5OCpjDdjAyAY
kKrl1SiJWjoMDJechuDYu7lDJkelUFWZ1aOLzsNgpRAt8ZEhhcqrlWfnhoh+
YEdk26XS57DWtItvVURpkYw3GN+MLQOVT79P5/7ZhLfXfe4PzmoADZ0giTUB
Frgonscu6+VPCHd/cO1LnTv+UFpT8rOdC60OeIXkv3Xg1Ul/tA70c6PqysBk
u5cM3FA088nwDwX91PT4XUbME7JOq6Rf/eFBexVuJmc2M3DIL13FzeO8yP59
+5HzaxhY1TPyY/JOYr0J7wdWqw5D9y/fzac+SqHArXm565uHYW1zrNqdlDw4
e+qOu0MrBb9fynorq/QN1r5bMks8r4dNw97dWz5DQdVCJc4xDAZeocMh6neS
BxVvoK28TcyLAnE1v7zP8yLne+veqT8g5vve4z2Tl4m/f/Huo8cRw1DjmLks
zC6NzCNn7PcuDEPg9kbPpMJIoLZQtNl9Y4tmIrs02i6WgoOUe3pf3VrMwsg5
vVhJQb/KV6RazjDwC8uR3swKHuTiK28r0sPAKXsG8z6mEPMO1RrUqoaBt4rz
hWree9iTt4JHz2exKHSVZdRljq8wHvo3xNoA4VsP53OpRhT0LjNBIpjGwPvs
Sj5tMeBBjQcfKeYS+S6idM0951EpJCa0Zht9ahjeWhQur3r9BnR+hl77Ptda
9J/Vk5PKnypAhG1SFLmr4pfPdotGc/OgR157DpgS50vmBiVRpJaIjwsbinH3
MOj0ba5ofvIRLHZVb81wEsWy92ztB4KJecVYWbvqLzGPrN57+sstHiR3QWqv
PTG/cLGDV6GYNPpimJh5iMh3r5Rs4lnSAsF58az5LnbvIolzYjpH8ilIX/7f
D7dJBvYv2X2MF2cBdeclhRH6ZJHdkGxkkAYPagvJ3xJNrMd7rO1Q+B8p9M7u
gITa+DCEGyi6V79PgoMyXz4UjtcVFWyJ+zM8TUFqugyWfcTzZzBOBKS/KABK
E9foF2MhzJaWpC1/kQfdT70/to2oN/3bZ3b28kmjoYHt16SJ/rPw0NJDo4TH
sL2m6nS/T2bRH+MjkS+aKSitaFtEFVH/ouu+/7PJ/ACehW1KX63Z8bZaxz90
Cx50nPO4qQ1RnzMiXMp3z0kh3a+Xv/ycHYZyJ5Pwc7GpIFP5/ZZ2QE9RiGC7
tpYkEb9x6zf8Jp5HgXY7LWy1NLJxSL82QOzPur9Fu2Ui7UFGcTh4QXLu033x
OK1igWJoWstf+N1pJRamv/q+I7IODkVfculbOoiN3LWSKWHN8MjKs8NY/TTe
YnhYjlWtE5Iu72u2uuKHh2OV9G96doPaFo8Pt9TuYd9Lhht7Xf6AsOGJDUdK
o3H3ye5rCR8G4GTPTXggkYgdRMYvf/Qegf37ttKiI1PwxF7tpyfvcqB/ttOC
EldaMYt71NUHMZzoaM39Cm6NdqwzrR2h8pAL3f+sWrTragdWDhOe93rFjX6b
iJxEPgys9qI66EsSBTXNpGgrjBL9yZcrW64m8CD6pKvpxhGif5u3Vm5O50Ua
AdrH7tszcFjEPcs3qXzI34jVgmLYgYdSY+0OFfMji43x2md82nCv//XBom8C
6LTNSa5svp9YNL3wXVKVIHrye80ePZUmvHZZz68kUgLRvyrUTq7qh7t5F+cN
RCXR76Cv5k/EB+CB7wvuq2GSaETG5Zvyu0FwKesp4paSQiJ2Wv4NE0NwZvDb
ZFu0FHpGXdwVlzMM/JqAo/dmgKKtXv/z2IGitc8E4myeVMK92t6XG+M18ds0
Jb+RcDr8LBe8PPHABl/5O3c707cNulumlEzKPbHj8c+2NLMuEHq16Tl/8U1s
9GmpmNe9F1Kfqx7krw3H7hezLv4L64f/jIaGDi49wWXxK/g+SHChJakALsOe
dpzMOB0+vZobXbOQNlEi5jU7P7qh0noK2txyfs3nz0S8KDS2zyjwoBp+zZJl
4jw5L26ZNlHiRWARuV+4kDhfakm60Vv4ED2WQ1eFmBeHr/t0ce3gR8BTuOWG
dzuWO5RU+u2wJGq99CzMdGAALp1NCrKgS6IOV73zbfZDkKf5vs/8iBTSTswv
unhiGA67c1TeaZdCfc0hzfTBYchU3aL5uzwBqJ/fZFGMcFFLi5mroEUZyKok
dL6v2YhtS06ti4pogMykB55Gwha4++1KSdvbP+Gs/X2pbyfd8QVXWnhUCzHP
msZml1V24LLbnonGvdxIQuXNY4FEBm52PKTq0E1BFc/LDh4m6sH5rsaIU908
iNOW7YfdT6L/fHRNY8cwL1pv1XYUFInzs3TALG2HFHou/Zr93dZhaN/8t0Ol
QAoJfDyqfqZxGJDlqa7dm/Igd0hZ//hJbnzO8Utlyu8aSOB6I+fd9R+eOa8x
yupMQRmRB4K3dTCwXJd1UPhxHrTpZEQcF3F/O6lAa003XtS5s2+DVAQDd3iu
9J/3lkLXxB2KhcKIeE+TzWxlkUbpV89mFMwT/Z0yv7J/aThETzg5PIqIKMqe
njI7pVIKdnuvL84MrMFcNwU6RMspiH/LqyOviXl5gp7icKGUBwExq3j2EvXh
vrVLYDLRb2oPMjZ+GYb1e2mH/u58D5w+Yax6rvNFhtdcMtmLq2FL7FCDRwxg
Ze/bq8UNKOiqUkB9Tz0DG7NJq+rr8qCme71X5oh8eE8wQktlWAoJDi4GzU0S
9fKwpXVQSjIc3JNT8YPRXLRUmHEj53IFdG1/4rOxZDtO0Y0MesfOgyj8GeIr
ifMlWett1vZVCsX9+vfm4O9hOHZy/kKozEdovjhz8uppKq5w7Ssbuk1B5vdH
rjz9w8BjJc/a268R8W4+EiBLPN+yceq6O1RpJPGU4ilC5LsQ6UqBtMKbcDvg
FNXM90zRKlG37LM5FOR24kx7PNEvxwIPpRhlgf05/Y02ihNFThGXKPHbedDV
8KI3BcR63HX2s9n0SqHaYiMFtbFhqNYtrVLPewnxGml32QK+FRU3jNpyTVBQ
kYNg4BiRn7/Zqmw8ua4AnjB28LHHCWCK6WLWDg8elKJxvbCeqAddV5z/ZfBI
o+iRMZ9sYn7ZYqh2UP51LGRpXWvXWHhbNDSWRimgU9BSYABFk6gH2cZPY6mq
H0Bl3PRXniwb1vAssP13mAfZOEm8LSLul9zR7M01I4WCP+aFKBL1YMmhf+Dn
k3egvtVY2ebM76KILLVsU1EeNDtWblNNPM9K2Ql765XSaFjXei2d2J/MKfgh
knYJXvQWVV9mNyg6/3P9+FdlHpQ37xs6QPy8zu6Za/w4EQRvJmjtaCovqlnx
fJ/qAAWd8+qY3Ebcny7xn7EBpzRKeTt/qproT8R2JRTWvn8I0ZF14dYTCUW6
BWf2SRnxIP/LTqJuxPnwPCr3MvNFCiwac7ebWjCKns39fnqVjwdZ1/z5d524
n0BuXemIhDT6pUDdfYdYX/GOkW1mCfdg8Bjjv52+14usjCpXe+7iQTtk17C4
ED9vZRRCtc98BTO7rqZ8tKMVvb+re6FlnoLmN94ffEjcb7Q3OGiloDR6/uBG
00Wi/u6zquy4EPsU9qf5Tb++klN0x+V25bqVPMioZ8x8gvh7yoGSi+Wy0kj7
6HfZeeL+JF/defJPffHfk0UkX3WO5LS+xv+SyVfjYwbZpHLfM/lqh5URErYr
YvLVhBWyFW/SPzP5qkI+63E1rUomX7W+XTnRI1XD5Ktl2mtEnL9+Z/LVW8FN
nOLn6pl8ddV0jL1pTAOTr8YPZfDqB9OYfLXv0vUzcivoTL5aqnU2n36MzuSr
5pFPwMaQzuSrNarZRdx9NCZfVU6qDK5aS2Py1edpIZAp/P/56uUXGjXrvtQx
+erJN59PLajUMvnqPP+aDt/IaiZfTX2e8qtZpYLJV6Ozzl5PvlbC5Ks3F96/
vp+Vz+Srl/7s2Wl+JI3JV3nLWyy9HKKYfLVsJNvym2ckkHx1xFN4WUYxHUi+
6tOcrjFpng8kX40y29m+q7AESL7Kdc6fR/pkBZB8dfCFx4u7J6uB5KuMNSdH
x/bVAslXQVvtGOTWAclXY9mOWc2xNgDJV5dsngqarqQByVc3cesK/KDTgOSr
E+r87i8M6Ey+6mB30UHZls7kq96yuSa2a+lMvqp04Q3F+wGNyVftaRkyX983
MPnqrNdxoXGveiZfTe585c3b8p3JV+3WnlBq969h8tWgyX+Fi9aVTL5aZl2f
R19VxuSrK+Uqr4waYSZf1RQ8O7NeLIfJV/c25Jv8dX3F5Kuc/qENRDzokHz1
r0pC816JKCb//OefqJCaXcfkn4kxHj3u/A3YselhUPKlceA8oy+UspKGZ4QN
YrIDJ+G8vEXL3VYa3ns51+zhtWkwUs+yV9CjY96LrOxZwbMg0vHB+5YtHb/r
rtD883Aevgs8rudSoONtX7gndyQtgnSa6gOFcBpeD/JJpWXLoPxE5w1/UgN2
HQtgiehlQU6o6tEhr3piPkv2MBlgRc9XZzVqjH3HB0+x2pYpCyPt3UV9N/59
BzYPFc6WZGG0zn3F019O9SCecMRlQVkEMbZY/ROMbYDOt6tUelNFEMuoRFLU
dRqciLp2NFqFioot67V0pOnw7OjN3/wfqKjhV6K0iA0d9rl4S+WriSKOZK/4
a0Z0ME6w5/XKFUXcxxU11/XQgD+7z3ZylxjSmRdVDd1IgxuJgqLaWAzFCp9w
tZRtAPPcjbcj94qjMoHtTXwFdUye6nNd4vATn2gmTxXqVwz7KHWLyTttZVhu
TxjXMXnnVputiX2YyB9G3m6rhsdAQqmVJ7WtAW+5fn/TLsok5CSMmLe8p2EX
89xfT9mnYX9DiX6wCh3fibNZvZJtFoJ4gYViT8d23MHsTpLz0Db15NEGTTrW
Ul13QGzVImz1+uTcX0TDMpLTk3I6y+C8O90wqK8Bs9muul79mgX5ZofPviir
xzMCFzU1k1lRmkA6l6djHXY8UjQ+xCuMLj/YsFdM5jtQ/W1WvAwWRkIZv3Ml
hevBPyA2UZZHBDVdS/0idqgBovZdFjcOFUEekya0b4do4M4+7mApREWWGglt
PbM0mAoUeiQSTUX+Gz6O/zajw+Ps80Z24qLo3/APZGBJh5nC8/YeD0XRidkT
Gg+56cAeSrXfsVIMCec8WNFtT4M6k0M7mp6IoQX/gul8twZ4erVVsXadOLIS
P97ZKV3P5Ke3HyU9HGhMAEpf6+sXf0bhoGDB/hhz4nw75bxUY5mAgJnXt3ZY
0HBpwhL7Zu4p2FGwsGyySMNrn+SWhyxOQ8nor319h+k41OTVn30ic1AxGhRs
ZEnHcyUc7m5iC3C667bFLBcdr7Xuf2q9ZQm2W1GtP9nS8NhJrhGBSmG0faX/
r6CcekgrFd/eckAE7equs6C3NcAmoZIDV76JINZ1G57HpdLAap2gaaMZFXl8
HlX9sZ0OBhunt1Iaqeiv/8ofSvZ0mJDz7xU1F0Vb5R6ZtO2kw8tbxjneLaLo
UclpQclPNBBr/miTfUwMHc1JUbk+1sDko4ZxrcAfcIfJR2+z+YXZSXsx+WV3
2A/x3yvqmPzSF3mHcMXU466bznaNKWOw3tR4t3JhA963M9M7oHIChG3+dqXE
07Cfbq6SQvkUYNa7Ae7r6Vhv890Uk6IZGKMkbU4i4j9Pqv+PfPMcPNpVt/P4
HjrW/Zt96UbTAvgMJq5Np9HwCnZHmbq5JaCXhBys56Jh4wjXEucgFuSweeyu
2r96HCfe+njTHVY0KsQv5viwDv98tvMKZUoIfbZ4lOX9vhbiWMde8vgS+f7F
L75N3XWw1a1AR2VGGJlxqeulbGiAIYlX3DeuiCDfta/KkzRoML7rnZPGkghS
dKztEv1DA4X4HyOid6io5/qt4Z6DdNBrPvs7g1MUbZq0STQ/Rocaw1me87dE
0czGQ1/TJOhwZf61vRWfGKo9JmxmcJkG3us9DF/eE0Ob1LS2uIc3QOkJVZ9/
YuKI2sQYYd9Xz+ShV7K8XJUTX0Cr3zOz1DdEfi0Z9hBWacBdT5OihwrHQemq
7lfZnTTcbqVgfP7LJHC7ZdzmG6Rhjbu5/CJ4Gh47Vj+M30/HB7poFwO+zUKc
Zqn6M6I/MKOdNFP+MQ9rL3zjXi1Ox8oiPlVVfxfhVqRtkcJlGvb999j3Qp4w
8mlbW1Nwvx4cMzVq+3eLIIqmyPnYwga40z6kk/VJBOXu8j6/LYYGHTZfLD7o
UhF4pDqVrqeDp+6nYN4KKlpMf5UHdkS+1Pe56qxH7M8Nd7FqXTr4UJvsL1aK
Io2G3dr19TQI0ze1pRuJofJUto9PhWhM3pmXei4lpy0MRKvOdE3tnQSRwGTh
75U0bOWcGyetOw1pgd+lzu+m40rurWG9+rPwSeCo1KIdHXNOKcq8spyH25IS
f3M20/GfrzttveWoyE1a+r0hLx2qzxtqC72iorSI4RVPregwFnohk2+dKNKt
2uK7fIgOa7b8ee/5ShRRvrU8F5mmwes/P/P/GkzB4KC4wRF+OhZNy71C0ZqB
A4PbpWeJeK77eNlazGIO2ozzcfAhOqYNmhtPOVGRqJb5t4vadFghptLI2UtF
Rm0XHGqI/TBauHKw5IQo4mOV+Jm7lc7kl+L8Z0UHA7yZ/NKyxPp1mLQTky9m
ntdLdmepY/LF5XbOjPSb9Tgxwe5IdtAYrKGyV/5504AtxT+vjE+eAF65um/P
omj41s4dB7qTpmBZILv+rBwdv5iSGz3zZAZ4DLYkudjQsdPzuNZreXNggW5a
3dGnY309v/s7cxbAPX+aP7idhqV8HmUptiyBWZrpq2lxGp7YFPnr/WUWlC5g
fFt8qR67Sod+W3+RFdn0Pc4+k1aHuyViqlb3CqGwN4zNo1dqwa5My0XLUxh9
UHd88+NbHQT9ruYvGBZG/Squ3+fEG2Dl0keWJ94i6HyspL78Bhp8aAxyfjUp
glRWCS8976BBXkreavErVMQT/mbHWaK+xroMbP25SEXiliyxvdZ0+BCmbT/s
J4qsXidezV5NB62sMcZpdjF0J9jvIcctGlSHX2/gvSmGuPLf5O190QB0C4a8
L784amwa2JZoV8/kleuexipocyeBXsXVDdvvjoL0vtmiLpkGnFjw9MHX2HH4
4pUUEqZMw/1qauPhryche3vHS89uGta5vmMbLX4aSu+decm9j47fvnX5+Ojt
LCTUXOUGYn9ZbCQMgnPmwWMrXSN/JR1vdkOMa18WIaTkhPf3W8Tvp/XCqwxh
VDZo7XHOpx4+Ku19ckFVBMVWeM4HpDRAdhmnZk2OCLKsup5MuU+DhJkXR9bv
oqLD0pNuW+ToQDFO+MBXREXhMaWSh4l+c7xp+usDLVG0LoTdsIboR52OrsyZ
wKJoz9vHksmtRL+68KS9W1cMpX7sfFi4msbkkeaR4WNWbyNBLskvUEppEp5V
NtrOE/X+uO2OolaFadDfUrPjhQYdK9aXN7KsnQXDnA1624h+IetKszDnjnno
TZfXlFQlnv+UhH2vJBWdr+FL0Gejg4P/JhfhZ1T09Zei0hmiPhvIjy2qrRZF
22Zv91QR9Vvw4ibesaeiKMKBI+7aMg3elw3Y8SlOQWjgoNU8Bx2vStqRWL1q
Bn6Jvx6LNqfjrXeEEreozoFY7+XSR2Z0HB2scsjZhoq455TpZpp0yJAVY+fu
oKJsGuXgGqL+xYcuxvZbi6Kmyme/RtToTL54IYH9tnLHNfDcv4PToXsK1t5f
Y6mwiY57ToyfUO+cgf1fDh68ReQTvrCdU6XTc/B13YfxAS06Dokc+0wNpaLZ
PUWBAofpMKI/HB0oQMTz74gbXkQ+2Ry5469xxzQUHJJf329Mx4NS2ltPDM9C
5GwNJdGKjleW9JsZ7KeiRqFGzrlNdGjT+GnDU0tFikUPZ9qI/GCYPbdd+4Ao
whdXiPjq0OGMToxhzalZ+FacFeBOrEftpLOwYBoVxfAafL5K1JunCxNOXZtE
UddYIE8fUY94c3dYG1jPgN7Wc9kCR+n4/PgvsTnvOYiWZ3kgd5COb1GM33AM
UZFrV67wWuJ+JE+k8/kwtlxxZvLE3EtpRzOkzZm8r3LtA3fV3u9M3nftSMZ3
F596zJb+k/b80hjEzPtsVnregG3YDwylx0xAIKtm/HwoDVPUp231o6dAaeFt
9qHVdGxq7SZ26d4MKFQar3xrTccFxFyekTwHl1XnVP320nHFqJ2U+MsFsFt2
/W7WReQftSx/s8ol6M9rUXZdTcwPc69GW8+zICONUUE37gZs/vhU7ws3VmTx
9fuO+oI63G+695xShxB6pGEkzepUC8Xrumos3IVRzQi3b0RpHajL0i5c+SeM
zobGpXHwN0CWx77FZE8R9Fprz6KuAg0erb10ym5UBCntc+6uaKHBzW3K78V9
qSjpiZJXxD46lGVvbByapaIbJyd1I4j+f9N7Bk/6JVF0bFG2QlSe6EcFpOQ8
lon311L/ryKYBl5feCSLroghlbum6mLvGqDdWN17D0UcBU3FmNLP1DP54R9W
5UsJ+Ung43o+yst3FG7MRkdkihP9dZU0f0HQOLh3xqooraHhUYVP5YmPJqEq
UjeO0kn0n/7Te9TCpkF2MvytjAEdHxP+wHgZNwuVAvUbB4n8Y5ngjvOS5kHu
z6HmvzJ0nCa91sXmwyKUPdTfxXGPhhOEQhLxO2EkKHe/ftu5ejjtZMKuuZXI
v1YLv+qeN4CRZrhaS6YIGoy5tNEqkJhfDCKsOtSJfNy+2FKyig40mshB/gIq
8u4T0Ssk9kNGfofnS01R1KP5b1sGsV8t/p/s3xeKItsg2i+PThqkHildPagj
ht6tCjBJW0tj8kGtA3M+gdSHoBjJcWyD1CSssUqRn8in4V6r6e9aotMgH57L
kFWj40Z1kTkB0VlYXKUcpkjkH8rnbXfVFOchM0d8b4o6EZ85HA7PRKlIKa1H
RX6JBhvZnrGIxFHRTY77Odss6HDeReWlobQouhZf+0OEuL4ZU/s+M1YU/di/
rB7NTofCrIsqqySnQAcLxmxlpeOEhOnsjQIzsP5T6Ld9RL7p6D9WvlthDq7q
6IYuEPnoUpPsYRkrKmq+dEoyQZ0Ofkm3Y7l/UlG351ttIj9CdZMWWj4iikL3
sR08v4PO5H1OXwSPv069CVMG0xIl9Cmo3vac03QDHUdV6gTqfp8BTrtWZTki
3h3p4efG+uagtz5hbhvQ8RFpp2Oid6mo9atz500Tor94sEX7CY8o6ru/7Yj7
UTpkhU7PpddOQ/6X3rvGRLw/CQgyPd8xC2ufbLj7lsgHC4It5ksGVCR4qafk
7wY6vP64f5ynmooeFf67FUPkA6+FnS2H94miLw5xX98iOki9+O3WYjkLW3eW
apYQ61nub3olmEJFx6T/xsQQ96vUV+ObVhJFs2trWQOI9YRmTbu93j8De1oc
pASIfCdntVmT23kOHEO3hXQS+dAkFANnPxVJHGl2ukHcj+R72427gkM6zsNE
+I9vNqkzEFOlZilKzAPu8qnB5ayi6MryrhOKRL1fMJCNvftxFhRu3OH1JfKH
duUWOb5SKrp2UDaqgah/l918s8fVZuGEkNoqBeJ8PJwqoAklUtHjFHOj+0fo
EPPmUtiZTTNwKGDgQ70Fke9jE924uqhoYwhiZyPel8bya6Q0OgMn/tyLqiee
VyTzdAWlgYrWWjmIChCfF7QcWI8vz0K0T2AfB/H5GcaEj0AWEQ/XZGNNifXd
Kbxk2OMyA9xHz/ydI/Y7/0YblWOMit58OO+USayP5HVJKTJXTa9YMnmdss2x
+A5pPSZP2+nourm++TuTp+VlmHPretXj7R+kqNLnxsBbyXwAP2nADr5hR/LC
JiBMzqpEIYSGq7c39V4MnQKuyf7xAqLfSBGgvlq8MQMLdJNyXWK/ernjRSoT
5uBA1W9Vd6JfCaysa7/xeAEmNGueZxD9TEw4Pv4XL8GTzYHLq+RpeKQzw2fY
jQWJcA43CPMT85wN3dPxNCu696atc7G4Dg+MyJRu/imEbIfEKwIsa8GzUe2K
o5swWnHwel//xzrg1z7y2uGvMLr+14uHjbsBAjaG+qWfF0EdirY/a2RoELR/
6NSuYRE0f25D3aEmGpwed1wWv0zU7zMmPk/30uGo1f4Ns9NUxB998HMnkV96
y7cxQi+KonirMsdCBaKfLlRGFxdF0bzLl18JITTY13Uw/5G/GBrI5Lf1zGgA
x/0Ocuu4xNEOcwcZZyK/kXzOSCMIVVJfgVjRn6qHnqOgl3LflSrSgLfXHTFS
uTYOPH/qml1liX43lnXr2weTIKhvsq2G6Idv+TZVOwVNA8eenmEFol/OKrX2
2BgxC7Jx/u92E+f1eukK/7qn87DfZXO1L9Fvnxt5uLU6dRFaRPlVJYh6eLi4
w6wmRRjFle435HOpB50bNI0Vm0XQo2fZ1z2fNoD4WGMWI10E1T+VqrpM9K+e
Z3mOFqhS0eXL7gNsK+mQF20Uw59HRRE8yfmnif3ILrcsT9MQRQ+5LjfFGdIh
KlRQPSpfFInc+G5d20UDG84f2qNaYii95+ITOSUak79VvRjSEK94CMq8hp9V
hCdhX4zg5jO5NJxs2WR1lm8axqvr5xq30/GWPx/uRfHOwl7njBcriHhS7Wkz
OCA7D92uxqcGiH4woM3PwVeEis71t5zgWqCBcHnjfpEYYt7ivdQRYk7Et9Dh
aTNJURTlJOCfRuRbnRTZu+GPRBFDazA4hpMORRsK4tYKTUG/QrqB7jINOz5r
0rLhnIHt+hKX4kzpWOMpy5FS6TkIGxNwfkXE6+ml6MNzFlTUYnborjbRzzmc
LurmbqYi6dpgsa1EfNr720TyWIoik80hhclEP0jytKoHg1y24rchT68pfrRm
CjZE2iR3KdLxgG+3VFXFDBSkhAX2EO/v/pT2Jt7OOVh6ZBq5H9GxVtuTJNEg
Yv9fCHjkGtMhXdU47BW3KJLdxD70m8h/XiFNNzsrpmEqws/P5wAdT2zd0j31
YxYyeIoLFIl5e1D9kMVPPSqy2b5zykqJDiFXb+nwVlJR7u2mN0Q/BzzPj26y
MRBFzd3H7D7tIeqTRfCSvfEsVNxi5egi8kt3qvCYYDIVofRDTquJ+9n2m9mx
KooiehU1DRHz6qGMpsmm/2agiqZ9+/YROr7MS6u6bzsHV0z2LeeaEP3i4Zm7
nH+oaPB74eAb4n4kP9MfcK6FtAtwQM/P/vfLGQgVb2kuIfoFjoqatu/LRH14
G3IumMhn5rNlyiLvZyFnlNeJQeQPhXunXPmKqaiNtdshishndTJy+r6bZqFt
XSrfJuJ8+OaPywgnUNE+bPd5kej3j70+Ih23dgbmLaeLNYj3V23TmsvVSayn
eq+qOPG+QjMPNqT9mYFNzkdrUonnnbrwXISnjoomPFeETxPrpYaM5eqfn4X/
qmbvaxGfGyduLhfIoCKF5rq8f0T/uy//SIP4iRnQPLa68A6Rb5/pi9txjFBR
uleE/iCxPpKHzU8+eZ7W4QBzyRU3RiJnwLH+QKEA8bxsdsLGMi9m4a1O9UQM
cT0k3MLK/5GKpjq+5lGI379y0/V04MpZCAtNLt9CPF901wFj7jYqkpS/doh4
XtCSiJ0sbCL2P91L0oJYX+ksNZmnhor625sNPxHrLx7RbjW1nwU+u5cf4ojP
Xb7emeAYIH7/MK2c+Hmw4pyi85ZR0Z5xp0w+4lqugC5/VnsWju8uuUgl7sfS
dEaeq5uYb7qmP/4lPu84wJb+fHYG9PVak4aJv7dpaKsfhU5F+YKOV1cT63FU
fB2leX0W9ri73v1CnGeSdx0Zlyu+fsWAybuudXfk59vU7yR5V57sew50tVKH
5F0HwHHLjQf8QPIuTbWM7jAJFSB5l4bQ7+YX1oZA8q7FWNFath32QPIu1QRL
qaEH7kDyroxX1pH/NfkBybuetfOFdpXdAZJ3uZrZR+k0hgHJu0RPlitu0I4B
knehdU2y8ToJQPKuZ7S5H8ebXgLJu04wvEs+mqQAybtei/25uyU7HUjeZfJr
In93XRaQvGtx3xXXvy9zgORdDZGyG41W5gHJu0JeBgtf9i0AknfZvbHpfGvx
EUje5ZVdtm+09xOQvCtPXPCB4VwRkLxrw5slbZkYDCTvmt5jsvNIPwaSd/Vm
pAdvWMZA8q7S78oL9izFTN6VOOyh1cRfzORd7BEHlDt3FjN5V53qdNXb5GIm
77okVGOz162Eybvu7U/wC7lRyuRdJTFrjngoljF5l26IYdldxQom76qpH+XM
u1/J5F1fVlLzrj77yuRd+hskjBmttUze9VgsWf2vVT2Td6U03RYo06Ixede8
oPlLZ7kfTN71mtIRyrb+//uEprarfc3Gmpm8y9p6Ptmr8CeTd+n5F2h/+K+N
ybuO87cZ5VxsZ/IuiV9rhcN9O5i8S6a+Inv1RgaTd3GgfonXTxlM3qWUJT+m
3cVg8q4vF0ayb88zmLzr/+mEywymT3inrjFx+4MgHdInXMOlMyykNapD+oTq
/Kt3Pe2VA9InfHFBILX/mQ6QPmHl9gup37zNgfQJWw47ubOpOwPpEwqpvZjg
HPACkqfJxHda3l68DiRPk/kcPuvTfQ9Invb2bRzlolUUkDwtYJOUY4n6EyB5
1y2//WrHLPPBrUzkVew4G3os92RR1KsQov7Le3p+gR1Zv3MQjNr8CUg/0XBc
3kriahGQfuJc74kWC3MMpJ8o8kxcWuErBtJPrLY7buo5i4H0E+PfWBL7hYH0
E6vWZV2NYC8G0k+cyhnT61tdDKSf6OSxMfT5qWIg/URP2wwPk6ViIP1Eqdho
v4H+EiD9xNk9ZuI0vc9A8rs1vm7Bf6XKmfzuudfFrPkDX5j8LOTBpzrrwFaI
ltyZKFstjr60jice7W6DMPMeOc+DEsgls3L1LdYOIH3H99vyJ0t+djB9xz1N
0xbbXRlM3/GcAPd6mwoG03fkvNo4GDbGYPK58lcPpM8R54Xkc8eXRXy0Ivfp
kL5jg+LgeEwvQ4f0He3/fv/496oEkL6jgZJGqJLCDiB9R/u5ig5DrUNA+o4d
m49NPMx2BNJ35K31EF4Y8wCS/1HKx7TnP14Fkv8NO1d++AbBQPK/h5fVn/27
GwEk/2vbLvvfga1xQPK5y40RstcL8+CAqUg533s2NGVjV7F5rgDkvHvYInPZ
0XCGjPep8o9A+pPXXt+NytAoAtKfVAjt19uhjIH0J/36raas3mMg/cm5RCEt
i3EMpD95naYq8Zs4L6Q/OZx1KsGVtRhIf3JtF9vLzWLFQPqTi4srGPeMi4H0
J1M/h0s+rSPy3//8yWQ7Htao5BIg/cl+20b1XEYpkLyxxZ61MfhJGZM3Dp8s
s679UMHkfatjZ7j11rTCpni20Wcp4miTkz+j92EbBKSVRxhulEAHnyVqjn9q
B9LH5IsMPPPuXQfTx4xZZWg2cIDB9DF/r1CSLcxmMH3MkF1Fdy/8YzB5or6X
f4T0EoPpY85rGD/6zp+uQ/qYE7VpPZ0uLED6mO5Kv30euikB6WPWKZmvfcr4
D0gf8+fS1w6pc0eB9DHtHigfpa93AdLH7NSpnfmncRlocqJvP34fBsGBpuYp
w1sQokENVFRlR5dorAen+wqBInJP03gPB9oVdOjnitBPMPFyTyrrYU4ksP/b
I63iIiB9zpp9y8q/LmMgfc7RboP0iTYMpM+ZWxX1Tm0RA+lzSvwIEucj6hnp
c+p/j4zV5i4G0uf04jcHa+ViIH3O3KgfW+7eLibme6t2xzsCaHzuNp/UdiIf
NCjNBtwRRN4VCj23VEvhyohW/1K4EFrRrdvNlfUZWMLOmSX8FUdR3re9Z7e0
w8s5jvS4cxJI+qgb5QTqAIqFxm/3UQlkwi4j+IuDAaQvenTqmrXQHQbTFzWc
KpH78oPB9EX1aPd5GqcZTB66UfBRzSAR7yQPtfbc4WMZRdEhfdH2grfr54/Q
dUhf9Lk3q5Y2HxVIX1S/cONew1FVIH1RtUhThQMlB4D0RfVv5rY1rDgOpC9a
j/bnz0SeB5K3empvDQEcACRv/Y+Dv1txMRBI3tp6WeLapdRwIHnrQXFP3WTV
WCB5qH5AqjCfWx5oSYfT9aLYkHV2lDVPYQE4C/mrr33IjoTWqrzyCf0IpH9a
t+26wSehIiD901THjvRFKgbSP72yu5F79BUG0j+Nqj/qsWsYA+mfSm2XoL4g
4p30T3WNzHsrifNA+qc3FksCdgsXA+mfZsnudE//jzgv//NPXR871Y4WEvXi
f/6pIDd6mR5cAqR/+tzm/Ln1GaVA8t0Ed2kQP17G5Ltn63/8Z+xeweSrUk/S
zeuGf8KM46mYjjhxJF4v1KB3tg28WnP2q6+QQBtvDx05E9cOpM96Yf9Jbbmo
DqbPukG7tO+SFoPps9YEvZBc84bB9FktjlknyfYxmPx2Y+73isUFBtNnLeHb
ob92+qkO6bOK2JclB62Y0SF9Vsflb8Fyp9cC6bOemfWpzvbbA6TP+nG0Q2b1
T0sgfdblGvrJc7KngfRZO9dPXGQL9Abdgyqmn/YNg2OR6ael1TfBfzE82kGU
HclXbRqqTCsE4xR5V4YMB+Jmuyj/ze4TqB81sFPdyonGnPYaP0goAtKH1dCo
rzM8hYH0Yft2q4gk0jGQPmzfj6GN0fMYSB/2XQtlGyvxfkkfdppW2ruNk8jf
//NhJ1w3BJetKQbSh6228eafvFgMcr3VM2+dBFDP5mP1rpIlcHVbTjHfKUEk
0vcm4axgKRjId9K7zwmhS2mqXad8P8NXM/oco0UcVSdLiK3jbYc4xclTd+wk
UM8Bp55g+Q5IOq465v9LAs3s27rJZKQDSN82MdHuB58Pg+nbKlGiT3jVMpi+
rdG5uVMukwwmf177tDC3lIh30rfVfPSVQ1XqnA7p21rfZHhydPfpkL6teV7q
5df5K4H0bTU2uQ8apu+CSCM/rc6CXxC9USRpWNcUyn+1qe4e50Q/EhMHFgAD
6eM+3D1q4lSMgfRxs86GpOZOYSB93NU6x9rniXgifdyH8zwKFmzFQPq4le92
x+ZJFcOTaJlIJ2F+dDyJtfnGsWI4vTZjq468ABL5r/t9Xm8xXBmM/7kDSSLT
VTN3rtgwYP0vG7U9JZKo9FnOYe9PDCB93sd/NS33DDOYPm+o0YrCHqJ+kT7v
yvvy6ziKPuqQPq+h0E3B8nZOqGZ31+D0aIK8o7LZj5Y3gUCDdc+x/QxQnYk1
8iPmz2DRE/i4Bxd61uJVvzYYQ86H753617hRUK6xzMZuDKQPXPa2INt+CQPp
A/+37fwpReJ8kT6wU5bbv3KeYuijS3enBfMhXzlj9Q8qxSBIt8uR5JRCYRbt
xTZtDCB9YY+bMnptswwmbz+qpZu3SLxfkrebr/jU+TWqUpv0hdnfyT0qpX3X
IX3h254qIqFiwkD6woo93HeCfLYD6Qt/TfJYCubYD6QvPFafZ8Rr5QCkLzz5
fOktNJ0Dkuc7hNnqPaj0B5LnCxa7GxbYBwLJ8++NCF4R3RMOJM+/wtGi+Dk3
BkjeHjj7SYn2Xx68Xzhkc/wWG9LnHWwdjCsAXpsvtQM32VHCZwU/Y8+PQPrH
KWPdlyLmPwHpH2+t5bWgcWEg/eMxwd2tOfEYSP94IvoCo2sAA+kf55k+i3cn
zh/pHxdevM4ZSrwP0j9WNZEzuSxYDKR/fM0sffGVTjGQ/vGqKOkmhaxiIP3j
uebaczW+JUD6x04LNrMrYkuB/P6A+OLYAR69Mub3B04rraC/N6pg8vttGa4r
8Y+f0FEm7bYUIY5yhI/2xlm1wfDoZqW3IhIok9v5mlpQO5A+8/6k9JU+gR1M
n/m8F3zqU2Uwfeaj5W6cN14wmD4zfVXuUnE3g/n9gGtDdoLGRD4nfeYuT5Ur
B1MidUifuXKA0nLMa0KH9JmpfO5hHx4pAOkzNy2cM6PZISB95k/T5eEnEi2A
9JlzO87mvV5/CkifOUYqv3rww0XwPVGcpM05DGIKHcfMQ27AROdhmQB2drTP
0Xn4WXghjE65cSQLcKAP/84NnDX4BJbZlRoHZDhR3pr3kfxhRUD60Fdfpo/O
22IgfegYC8kaSh3Rr//Ph758mJMjeo64/p8PrbR0fCUL8X5JHzo442iROQdx
/T8f2uqMsjOWKwbSh/bwde554V4MWeq37tSZCaBbl9v3vuMtgTx7v5emRwSJ
Tszuje9CCaTkq1Q32RH9uu/TCzb2nyEj507tcr04OpH8foXddBuI65zVW7CQ
QCKiEY/eiXTARF/m7M0WCWRwY0IhuacDSN9a0rpo5S5PBtO3PnFf7PL1agbT
t+5KOfaPb4LB/H7Dn5W6tc+IeCd966EbzzZ8XbLVIX1rP5cX6vLxv3VI3xoE
Vrsx2KSB9K03LEj9+9amCSHc3yZ6vH/BdtWq7dK7DkPISjdH79+c6KxEyfp9
6hhIH9v3cK9hcAEGpo8tNeGzahID6WM/58I7x4l4In1szpaE3EZiHiJ97J6W
rZb2EsXwf7o683iqtriNcwznHEKSKa6QSiLV1SDstZIyVIbIvQ03mohSGpQM
KWSKSqEi4mpOiVIqOYeUaEBCEYdchLARZcq7zvvxO+/nPf3363PO2muvvZ81
8Dxf9z+lNi0dl8YrjK0Xb3fiouGDHs+3TZbBN8c2GwSQeerU8BNR96XKOCj2
sG+FEw+V/Gu641WuMh5tPlX/IJeHIM9d8VfQI88uniDP7a1d/j6CzOeQ576p
urh0u2sOBXnugAX3szXHGejw6zHNeb3V6POtsL3h6XroOuNqicT7BrQ50CLM
d/ZKZL+2r+vyVknsonugUf8EB93c0KFpsI+JdVZPdsxu5CDIg5fHmQTWkPMB
5MEzEk2dlMj7BXlw59p63/0sLiq/O1mr5qg0zihihPUYcFFWPNVyeVQZ7ze2
lp7zmYcgL/4o/btNyy+ewM+xQ1ve/hd5vpAXbx6cgTTVDCnIi0c0D3uuSv9M
LTqSZFPcV4E2BxwrM5o3FYm3z0jZ+IGJ60VGWlx6OQjy5HOqdLVLyPOBPPlY
f8qyKeT5dMzKCfaok8Kr/0ueqT2Fi3bkfbcoNVDB/hee1mxs5yHIm9sMxu5J
GOMJ8uZPyX+pdl+jIG/+1b7zTvmSUarc4Y/BoN4qFOlQvGnlhlko5sr0tJE1
TBx6d2i05xMHQR692LJj5NAoWf8n8uiDFgf2i5Pxo8/MzRt3lsJxFp/SdCWJ
/uY/81L2UsGcwy+87g6S8ZjIq1s7mx77QsYH8uraJ1LNN7wNoCCvXsU2vHWu
4juV0nBypdEUFmb4z/6u+4uDIL/uc9TPmf/znuFDlX8pK0hhRuPkkG9k/wF5
diN3pR8L+PqayLOrvrjm6dpdSG1XbYu4/7EM6SSetlOcxEaQb1fv33i5jKzv
kG9fG9cShcj9fLsdovktUQrHXEtPNpXmok+e2oz8aBU8o2iMnTfME/hVTAr6
H/F/Xgd+lR4TR6ZlfIQZ5N/fJP5yujjyhoL8u66llrH2OlkE+fcC3g6/oJcL
EOTfT81pm37VwAZB/j2luc5lvNcFQf5dbfB4556F+xD4YdTeVp8zswtA4Id5
mClaPSIfjsAP4zaqO+OIdCwCP0xm9Jsba/wuIvCrPFK3yb5omIu8u+en7gtg
YG+f6Pn5UU/RZoaXmoO/GH6Bl06ZtCMPQZ6+NV8y0773OYI8fbj2wd2JIhwE
eXo3t6s5A0kcBHl6iUipe+mdHAR5+qdyvWtsyfODPL2OamyQDxlvyNMHGmhc
TJfhIsjTh0Q7+5uYchHk6UOZnR6b75L5aSJPbxGUNP/YwQIEefoDGf/OLoop
ROC/eS9aWXVvUZHAfyO/sPeLvPErgf9lkWXFaOrrWlQ+0Lde9owixnt0mg1t
vyD9MQ8lNxklbHXKbN7vY/UI8vm6LgGLZE40CPL59+J/DEca8gT5/I+dNjVJ
qTxBPl/7tM7U0GaewF+zdvlS2a4RniCfr/V2245Hq89QkM/fa76BxX7TR0E+
P0Ot0Mj5mRaCfP7K4rqRH7cRgnz+SotdqSrS6xHk87tn/xXSl+GGIJ/fF3nS
sMreByV0h5cFNncjh9xTD2MtgtH9Dwu2nRphYOuGLZEtwc+QefIUh0kS4vjM
uJjd5GXPkVsjO/2TogRe8Tav+0p4PoJ8f5X+2rE/N3AQ5Ps7Iucuv/KOgyDf
b7PNnMMi6zfk+3lOZ0X56zfk+2U67ANoMaKviXy/tL/Um7XTuQjy/a3bY4ZU
dnORf73ru22rZfDVV9WJ+8ULkNORLUqH7WQxM/uQxI3+AvTlZK2Fg7Mcvn8l
K4q57gVKb3XJlXuviBcemhLV3PUFrbO+tfCxgxIO9hHnprEbkNrc/YHhVUo4
/kXIgGljAwJ+QNQFcbHne3kCfkDwM4a+z2uegB+gc9tYZl0/T+APavd4Eh5B
9A78gI926eZb7zlSwA841mSRwHzcRAE/4FFX6yOFZ8oI+AFbwkV40aNLELt1
oPybUxPSrNgmX/XEHnnnPhg6XyeBzb9ct3xjyEHAF2APFLT5P+Yg4AsU+zkH
Uj84CPgCEQs0zL4TPQFfYF92UV0KWR+AL+CT+y51uSIXPR1qYqUPSuN6p4qk
vQ5cVKi2SnyAKYNnazWyRau5aIqoZfwxI2X8LciRbrEn59MQ/dGIh8p4yX+h
ztQjcm6a4BO0SLcuP/idJ+ATcLmOcY5k/QY+wawMJ4vLq7Ip4BPQRp4yzAxR
9Pb2ygTzrGpkndYdFxwyB/VPe22y6UwDWnlX53zGCQtk1GF88ukGSfz3Pd1Y
+UAO0rrzk5vqxsRG+uRZNXAQ8A1yP2dFR5L1G/gGcf+Mykwm7xfwDbomn42t
ZHKRxbRo1LlfGqv1qMydrs9FwYfnBbr8UsaBGT+7Amt4CPgHMy4dLnIl6zf4
oc5SRW/7yfMF/kFJ8IjsWxENCvgHoweuazs3VlPRG5o5ddkVyICjJ8pWVkD2
t5d4uJQyceTdeDtHmoOAj2CVM7PwMXk+wEf4qLP4Zifp75bz89MCK6Vwf/qD
NXryXKRZ5XKgao4KjrX+lLz8Gw8BP0FfvvvrGrJ+Az/BjWwPwxf9SwE/oUz1
clC26jA1y2jn7risKlS84VhO6OaZSLJXf/k+Cyb+Y8dJ+w/VHAR8BRdGZBKb
rN/AV9jR9eEIg/QnNjo1M9hWCuu5bFlyS4KLvKznJWl7qOBZtaNWcmT9Bv6C
6WBeUTkZH+AvtBtwiuM9fCjgL/zGqotzLDqojiuXJhtLsfA/DnUePj85CHgM
m72yVX+T8Ujab7U6UUoKo9YDqpfJ+g18hngP5Y8ypH3gM7hfzYxIjuBStY1y
L16tLkMSl42S0zyZCHgNhaWF0Ylk/QZeQ9F6p5CF5H4ib/xS2H1OCjeoFDcF
SHFRXEi8YUkE0a++/KgtWb/B7yVjd4nNX7+B5zD42GaOmHqP2X/aRndYOwrQ
jIDqs62SHyjgO9ga/l0SRfrfYlf77nEOG+9fZlVwi1zv9P7rx9rSVLDC5Z8t
N8n5DPgPS42rm8Z3XaT879xgXesrQVfinUR0jAcpDZUZturLWNitycxt2ggH
AR+ii+V+kD9fAh/iUHGvVjbpH/AhNlXaWdf/2EnNb+v67HznJTrw7doZ/7st
FPAiqi3tnX+R/tV7LlyYOsTG1SvNdymQ8WVkF7ibvlTB9zzMfJ4QvQJP4qW1
djyjLpfKlTk5MHCUheUytYo1yHgCX2KabbycBukP8CUuiIREj5D+AF/C4vxG
PF5mSgFfImGbon8Nuf7WfyRFMmrYmHnRpcKUzEfAm6hcFoXOL7hNAW/iUdnD
FUzSPvAmTu2+qdpK2gfexMG1dbWLhoIp4E3Es6fz+Ps/03V2X1qryXmiXddu
Hfl8afdPWUZCPlLjDL7zi3tJhbEWl3y9xMIpSUyDcXI/H2O+nfOKY+PLrc3X
bMn1wP+2Vbt+kP/8wf/2cbTWSyvBygx4FU/rr/bZLyylgFfBnkY52O+VQcCr
cG+r3uTmtQABr6JP08mFVWSNgFfxoLXKRyPOBQGvYpR1elVz414E/jqHbueH
igoBCPx1mm+DYjd2hiHw1+26NrL1PX0Wgb+OJ2kZen/TRQT+N+q9X9fBmbnI
tk2z8LAvAy+OMupKDn6KQqs4y8WOkPN57rws3uY8BPwLufa6TJ3vzxHwL279
PWXs0Fg+Av6F15/ubZMSOQj4F50Hfkwf7+Ag4F8EhXwONCXjD/wLY2WuqycZ
T+BfSKZe2GpKxg34Fz6y7HJpEy4C/oX4H9rbRe9wEfAvmk9Pq+PtK0DAv7Dp
OLxXJ6IQgZ9vYHX9keh5RQI/39Auz482818J/HT7Vg5dmFRYi2xO82yUYhSx
YdjX5h9WX9AbRkTMCmkl/NDZRnazXz0CnoaPyKheRWCDgKeBHr++ud6AJ+Bp
3AibvHrGFZ6Ap1F5smvu1688gV9v3fZ9hk/J/g14Gss1fW87vjpFAU/jntQ0
ZUeRPgp4Gp3meueY9loIeBpNvj4n1XUQAp5GSlZpznmuEwKexpO/oycVersh
4GmElMaFWGj4IJ2Hu/9L/tCNhllPXv7QDEan32iFnvvJwKE1z18F+T9Du713
HskXEcdPS5IZ1X8+R92H9T6nyEuQ81Zm4ZaQfAQ8DhO99Q+Kncn5eILHceJr
tc72t2T+meBx/HdcLzt/iIOAx3FojZgIfz4CHodrcnoul+zfgMdxL2eq7iUN
LgIeR68cq2ajBxe5Liij51rKYNORjb7/iBYgbTH7svDVsnhp3buUVT0FaKBz
HkN2nRzONE4191j9AqkHrbmr/FYRq/s+P67Z/gX12hbfirNTwhflF1rFSzSg
e2/tUWSlEnYx8/c+Ud+AgPehnarqOrSHJ+B99K8yN/cs5gl4H9gj372vjyfw
G7461Lw0gOgdeB+9VdKBwQ52FPA+zlm1tz4rb6SA96FmMJLeo6aMgPcxI9M8
I/X0EmS1Xgp1rGhC+jMS2nL97NHXsL9e/lsjgd/MD9IXN+Ag4IEM0bd0unI4
CHggrorbrd/0cxDwQJh55/rbiJ6AB8K6bH03lMyXwAPxTpbb+2gqF6GoYPW/
+6Sx4gJZiRE7Lrq+7+HsfDEZvOKXjcGaSi5aHyrjErWQvM//bGrpsOUhsUM6
Vp7Zypj955MDvx/yEPBETrETvX908gQ8kU0LwgyXkPUAeCIdk3KmF9Tdp4An
0jyVvCxsUfQrqb18TWw1wndqmN8HddG02bU/JLwbkIlf7fR58y3Q9dx6+5L1
kvjCBguxUT8OanD8fXbjNia2e33rTkc9BwGPhJGhOe5C9m/AI2GeCfCU4e+H
Jngky9TGE8PJ/u1YeYntgJc0/sFj3DaZy0WdbrNK8KAyLswPGk+v5iHglbx/
8tBQnezfwF85PeXmOM0/j0/wSqQvRIsdyVSggFdyp1DVVzq+inpsEz7ccq4C
xUSclsg7MwUNRhW83/qKiXfJ7/N63cNBwDNZmXTn013yfIBnkqvvXf6Z9Pei
9d774WVS+Jfro1dZk0l/t6qy62ar4Mnxzs+y2ngIeCcZRxylZpH9G/BONlYP
iPtGplLAOxmms9TXKQ1RDjPZ11Niq9CIWyBt3aSDXlz6U34OZuLuiz7heVVk
Pp7goWw5oNBRTvYLwEM5+EGDy/9911epTXMsbKSw1i1dwz1k/1Za1bZA110F
Xz+qnv18gIeAlzKpRXRSKRkf4KVYKp841bT2AAW8lCTp2eU/Zdups8dnHDaR
ZOHKGP0aZbJ/A35KqbG+5hgZj+89jJebJKWwzZWCviNkfwE8Ffu6n9bD5H0C
nkqzN0dE9XM+FW+h0+jALEOWN2rX3kmTRMBXWagl3xBI1mfgq9Dh7k/1yf3U
znwQo39aCusfWeGgSfZvfXJ2r96HkftRDf9LiezfwD96ruqj729yP8BfEe3e
qOon2mCWGmb1+vz0AhRP3Qib2ldOAY9lZJn6okDS/8Xv4yyPZrGxW/vBo0nk
emHPp87PvqKCj0dqmQaQ/RvwWiIlXTdO6Y2nFsvlzZx/rwSN3PrHlXIcoIp+
ZTzQWMzCvvaKaz+T8y7wXLbbLTXjz5fAc9nKm1V5k78/meC5lMov33592Tbq
uw3jZ5PbS2TGevnAPe0/CvguNW3bxgdI/+a1f7+zdYCNmw8pHPhB5oPhMUNV
5gsVfPG7Q1YaGV/gv6Qm6C3Tkn9MbemW3fTLh4X9Fbz7Roi+gAcjPVomMo3/
fgAP5tkLhWHSH+DBhGUrePTsXkQBD+a4Y8/tcnL97DruUa9KNu6WXMyYTa4P
fJhA2XyRzLEbFPBhisYnP5cg7QMf5onT5ugm0j7wYRrH1E19Yo9TwIcxP34h
g79/M0p5HpP1UQX/XjGcYE4+37bnZd5j5XzUV6lqo2FcROm3c+a1xLOwaNxX
uW/k/ahdgFmhZ9lYW9KvchW5Hvhpu9P0m/j7N+DL7Dt2k3VKPdNMd5NaSuJd
sl9Z9HV8C7leTSnbZPQmGzfIi7uc4P/+3+Tq9rkWWejF7SGNqediKeDRXB5W
ZvOfn2v17J29TeS843l9Uhz/PDLBp/mWsj4mbe/fFPBptJhKoz2k/amJGck7
PMh8xusWVyDfB17NBpMbywbJ94FX867dpiJ5cCY1vGxLf+tbFr7pnlTDJd/v
slk6ELg4B1XF/F5lInqVAp7NuaqRTWKkvcTDOZ+T+lVw6LeEb9WkPeDb3N0Z
GBnZ6ksB30Zxj2Ml/3zVerSn734EG1sMzS1eyj8fT/Bu7DS37OePF/BuGN2a
JqyKUTPg3STszivk3z/wbkrPDkq5L/OkgHejl1prOUzaH2XbvpY6ysY7H/md
1CafB/7NlamKBaOkfeDfrLdqzR8YMae+3h7/I+YLC+Orr5Lqyff19KQP5m9g
Y6sgUyk2+f7jVaMK+0dV8JSYj/odfD3verhIPOEeCtN7g26nnaSAn1P+Z9RP
/vsDfuIZUXW/+fcDfmKR//3XiMBPDDX4iaEGPzHU4CeGGvzEUIOfGGrwE0MN
fmKoBX+fZKIGPzHU4CeGGvzEUIOfGGrwE0MNfmKowU8MNfiJoRb8fZKJGvzE
UIOfWHB/E35iwf1N+ImhBj8x1OAnhhr8xFCDnxhq8BNDDX5iqMFPDDX4iaEG
PzHU4CeGGvzEgvGb8BNDDX5iqMFPDDX4iaEGP7FgPCb8xFCDnxhq8BNDDX5i
qMFPDDX4iaEGPzHU4CeGGvzEUIOfGGrwE0MNfmKowT8K9f/XDy2kH1pIP7SQ
fmgh/dBC+qGF9EML6YcW0g8tpB9aSD+0kH5oIf3QQvqhhfRDC+mHFtIPLaQf
Wkg/tJB+aCH90EL6oYX0QwvphxbSDy2kH1pIP7SQfmgh/dBC+qGF9EML6YcW
0g8tpB9aSD+0kH5oIf3QQvqhhfRDC+mHFtIPLaQfWkg/tJB+aCH90EL6oYX0
QwvphxbSDy2kH1pIP7SQfmg0Nali57AWPK//+3tZUP//9kRE/gfoz5E2
         
         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV0slLVWEcBuBjE5hDahISQV1nzb3ZuGzWsqigFmVWhKSkUpQEdrs2/gOV
6bp00wQV1CIoaNZqYYPlkNo8WJtqU8+3eHjf7/ede+45372xmobq+glRFCXR
y5UpUXSVPoPZE6Pons1WlhMjmRf2XvKK1/TzhrfM8Zn7rjnMCnKZyoC9mL0H
epyV5JFCufmgPM02Khh0fa75Q/0Iq8gnlXnmQ/IMNcxnyPV55o/0BKspYKnZ
D3mevaSF+5sNy7NsZwFVZr/lRQ4w7H75Zo/1NirZYP1PXqOQZdbj8gKNpIdn
MXsn26lls/UkbuoLWaP/kZfYo8/gYHgOmcodvUnOCvfxDAXyidk+eVTukhlU
6RtlRAvXrRtkDnGKwm8mf4b3kV2yTmbTSpP1VpnMIW6H85EzSTAtnIsckfvl
OblbZrFD3yInc0tfxFr9r7xMS3h36zTu6iPeo1Dv0Y+FM2CTdRI39OLwX9F/
yW6ayQjnZTYqO9jJYkbdq8i8Vz8evpcSMsNzmI/JznBOLGHM9cXmT/UTVFNK
Fu/tldh7pp9kHXOZzgd7pfae66dYTxnZfLT3ic984Svf+M5/yeFmOA==
              
              "]]]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV0slTj3EcB/CnohpmmMaEpHDO1iJOtDNjOUQILZphUqnGCGNSY4yb7MvR
zsVySA6awWSGf8C+HjrY9xakeH0Pr3m/v5/n+T7b7zejpqm0MTaKohh66YyP
oi4SDffHRVE6LTywHi83067fZIQy6yWymct8pcRsulxANad4Q655goxnNKOI
I5YYpjGfKk7ymnn2RDI97KeSE7wix7F/Hnyx3sQlvlBsnhb2UsFxXpJtPuL8
Ej289EU+U2Q+Ve7iOoOsMMuRGzjGC7LMhu1v07sYZpVZsbxLol7FVv0Cnyi0
TpX3GKvXsFO/xgDLrbNld/gW+jrW60mylqP6czL1v+6dJrdz36xNjmMTe6z3
ykk0csN6d9gjV8oiuU+m0Mwd69bwe1BJg3W7nEAd58P3kB9lgZwiU+U2evQx
ciM79OSwn6t6P8v0LHkr/LZ6eXgv/QjPmGs95F1a9U6GKDUrlLfD/0OvoF4/
xwfyw7PLFq7Qx1KzTFnOYZ4yx+yPaxfodZzlPXnmk8O9WcshnjDb/Lfz8/Ut
nOEdi8K3DNdjDQd5zCzzX87P02s5zVsWmk8M12M1HTxipvmg85PDXso4wEMy
HBtwrJ8+fvKD73zjPyd+bXs=
              
              "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}}, {{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl1WWYVVUYBeAZuruUHLpLujulhm4YQCwcLBrpMMEAFSwQECVE6e4QkRAF
DAzsAgUDFOP9Hn+8s9a3hzn33H32eUhKSU2+KzEhIeGMH5HD/UjLQTaY18tk
TjDWvEQ24yi/mHfKAbzHzeZ5siqH+dS8RfbmFEvNq2QHjvGXeZ8cyk36ZFmE
d/SNsgfz9RWyNb/ru+UgRuiLZH2+17fJvqzRX5ed+VdPwwg9HRv1cSzVm3NZ
78R8vRqf6S+zWu/Idb0WD+hFOa4/zit6G/7Qb2Gx3oAf9LWkjXVzejbp4+kc
f2uuzuf6MmozxVws9ld/gpGki7SWgc36BLrE7801uKAvpw5TzcU5qT/JraSP
tJaRLfpEulKXadZKxPPQn+I2MkRay8RWfRLdqMd0a0m8qy/gdjJGWsvMtnhu
JFOfGdZKclpfyB1kirSWhe2xn3SnAZm503pWdsR+0IOGZCEr2chODnKSi9zk
IS/5yM8o18jGztgXetKIAsQhz86u2AN60ZiZ1krF+dWfjnuhIKnWcrA79oDe
sb/mmnwRZ5ImzDKX5n39mbgHCjHaWk72xJ7QJ/Y7zjlfxhmiKbPNZTijP8tK
vS1X4555Tm/Ij3GuWad3iReVG8TdMhd79Q2yOzPjHMsWXNF3yYHxfsQzlLU4
wlfmrbJPPF9WmtfEexzvIH+b98uU+H7x3pvnyLIc4qx5k+wZ549F5ldlO97m
mnmPHEyq/rxsxE/6dtmPdfobsiuJ3Gi+R+ZmX+xvvCt6S37V+8W50mvzdXwe
zZlrLsc5fXHsPy+YG3MxPoPC3GvOw/7Ye/rHczfX4Rv9NVrwoLk8H8QziH2m
CPdZy8uB2AsG0JKHrFXgw/ie8R0oyv3W8nEw7pGBtKIYY6znj72Mz2MQrSnO
WOsFOBzXZjBtKEESJSlFacpQlnKUpwIVqURlqjDOtQrGc9cfZghtqcp464V4
S3+EobSLf2etIh/FXsbeUY0JcfY4qj9KCu3jb61V4mP9xdgrqjMxnmucCf0x
hsW7Yq7Lt/oqOsS1zJU5r78UexfXMTfhkv4mNZhkLswxfR7L9Vb8pg+P90iv
x3f6atbqnfhH7xj3oFfhE32z7MWSePayPX/qe+UQxsS9yKaxP/xs3iH7c5r1
cV+yG8dJE2eDYYn//59a0+//A2+i3L8=
              "]]},
            Annotation[#, "Charting`Private`Tag$1219210#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV1HeAj3UcB/Dn7jiZ2SPz7L2LUlrKppRKJK7QwFVKMs+KaNizRXsrWlTa
tNOyZ/bMXhmvzx8v7/f384x71k9GZlan/ilJkizwz0rKpyXJ8tQkyaY1GeRm
lW2rWcNa1rGeDVRwzA/2GUkbKpKHjbZl2PajPoq2VCIvTcw3yVn05FI22b+i
+U/6aNpRmXw0Nd8sZ5PJZWy2fyXzn/UxtKcKLc3+k6/zIPnj/GZb5Bzuohkd
zU7IBTzGFuerbPaLPpYO3GJ9Tn5MVVpZH5Rv8BAF4lrM/pVzuZuu1jn4TL+c
G/ST8n366cUZHNch8/GtPkCWifO4hiryV7OB8nHZRxako36rTBjCJ9ZZsiSj
qBbvTB6K+5FvyvtlUbIZYN1D5mYYX8XzkRcxhgvjucit8lH5rLxXFqaX3k3m
5HP9Cm7UT8kPGBL3bp2f7/St7qOq/ps+Lp4Bt1mn8KlePb4V/bB8i4cpGM/L
bJt8jt40Z5tzVTP/XR8ff5caFIrrMN8un4/nxJVst3918xX6E3SiJoXZYVsN
2/7QJ3ATtSjCTttq2vanPpGbqU1Rdtm2mz3sZR/7OcDCdN+bPMghDnOEoxyj
lnP+5RxP0pk6FOO4bbVt+1t/Kr416lI87tt8h3yBe7iKE/avY/6P/nR8C9Sj
RNy3+U75Yrwzruak/euar9SfiedPfUrG+cx3yXncxzWcsn8981X6JLrQgLZm
R+TbPEKpOL/Zbjk/vjHusE7nC/3aeOb6abmQoZx27vpmq/XJ3B7nt05lsd6Q
dvpR+Q599WIM1HvKPHwdvzlZOr7ZuGa5Rw6SL8V9yCKMoK91d5mLoSy1fkCW
YjQt4t3L/+VguUj2lyUYGb8P616yAMP5Pr5RWTaOcS8N5BqzKfF+9EJ0jfuS
aSzRG9FePybfjd8UmdZ5+UYvHc9K3ytfph93Wl/Al/p18Q3qZ+SHDOeMv93Q
bK0+lW40poPZcflePA/K0MJsn3wl7o3rOev4Rubr9Gnx3riYsvH3zPfLV8mi
Jefs39h8vT49nimXUI4kjrVtg5wR104TypNCKmnkICfp5IrjHbNRzqQHTakQ
12d+QL4W74pWdDY7Kz9iBL3j/ymWxbcoyzE2npn1eUXPzss=
              "]]},
            Annotation[#, "Charting`Private`Tag$1219210#2"]& ], 
           TagBox[
            {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV1Xcc1lMcxfGnSQmFSlEkUqFBRkZFyC5JNi1CFNl7Jxr2aNGmEO1ptqfM
9k5UQlHZvM8fn9f3nHPvfX7rfu9TrV2Xlp2LFAqFmUULhW7FCoXnShQKvxYv
FI4qWSjco+6ldpE1UivzP9ItcDz/NV9VfZw/U11h/SL6WNTnJxgvr97HN1Gv
4P+l2+FkfhN/uNqdP0edZP0YugLq8H2Nl1Xv5E+jd6pX4ETZKr6a+hT/r3Vr
1KaYLa8sf5i+mS5O30j/SB9J96CfNv959TfZvSgjv40/iN6mXoxv6JXmfU4f
h4l8BfPup6+k/1Pb43t6snlj6Yrox5cz7668M3pX5mN11pi3Nu8Kc/hOKGHu
Tfw2urvxF+id9H04GD/xLfEtvcr4YroBJvFXYYpsHH8g+vONsZu+CmvoAtbR
Z2EufQueseZFfhd9P6pgteyLfFdM5q/GVNl4vhIG8E1QBOv5szGPvhXPmvcS
v5t+IHsCa2Rfyk7AFP4aTJNN4CvjDf50FEUP+cuy3+kHcQjWyj7ExHwXvCk7
A8XQU/6K7A/6IRyaZ5R9hEnygzFQ1jTfH73kr8r+pB/OvskzyD7GZHkVDJKd
me+B3vLXZH/Rj+AwbJB9kv7A68b+lj2K6tgo+zR7Cn2M/SN7LHsb38k+y3fN
O897yrPm/nNPuQ76Zg+b+ziOwCbZ9FwH/Yz9J3sCNfC9bAamyKtisOwslEQf
eX9ZAU9mv+MH2UxMlR2CIbKzsQf6ygfIiuApviY2y2ZhmuxQDJU1w57oJ39D
VhTd+FrYIvsqPYmp/LWYnW/HV8Mw/hyUyjvkm2E+3Rn9zXuTL5ae5Gtjq+xr
/iRM46/DnHxb/jAM58/F7/TVWEuXzjfIGYIFdBcMsGYgXxzdc57hZ/oSLMk5
ZvwbuiE+5NukV/RiB/4Hem72B10db/H7GbubPo/+Q70G63I+5hvT52IhfZB5
j9C35ZvQN9M/5d3SPbPv/e4gtQSOlj1jbG/19nj6F7VV+ka2NL2gPpH+VbdZ
+23Ozpyx/EfGK6oP8KerbdOf6vX8Kerm7KdcI/enzssepg9HXf5t4/vnnOcb
q+fzf9LX5v3z67P31W7pd7VM9mbeQc5EflHOKPVR/ow8Q/aV2ok/Vf05e0Tt
lf517cFqSRwje9bYPmrXeHq7eimWpZ/lT+a9WbMkz4KP5QfKH6Tb5dygb6C3
0PPTf/QRGMFfgL/o67Ah7zd9Q5+Pz+mu2c/W38L/Qg+0fgi9B3rwdbCDbo3l
2TfGl+aZ8AnfHgvS13wNjOQvzPOk3/gLsJi+A4PMG8rviZ583Xxj2TL+NHzK
d8DC9Dx/JN7hL8K+GCwfJiuFXny9vCvZcr4RPuOvx6KcC3xNvMs3R1kMkQ+X
lUZvvn6eLf9rORdktfCerAXKYaj8LdleeI4/Fr/mfyfngqw2RskuTk9gmPxt
WRk8zx+H3/JfkutihHxvvCBvgJ35X8g1si7jGIl38C7ewyi8n9y6ffCidcdj
V84afJD58n3xkvwE7M65gdmyo/C+rGX2N0bnt2Vl8TJ/Ys6P9D/mpO/wgewS
HIAxuQ9ZObzCn5SeT+9hbvYrRstaoTzG5p5l++FVvmH6SLYifYXp/A1YIpvH
18EY/lJUwLg8r2x/vMafnP0rW8k3wQy+I5bK5qd3MZZvnf7HZv5CfEHfifF5
R/wBeJ0/Jd+Qvgwr6L+Nr8qZgZn8jVgmW8DXwzj+ssyj22Bjeg9b6IvwJX0X
SumhW/nt9ATrR9Pl0Sd719gd6ZnsB/VyrKT/MW91zgvM4iuZ9xB9E12M7khv
pWvkjEj/mb9QrZ97k43PN1LvzW/m99S2aCj7jq+uPs03UyvxW+nmaMB/xVdR
H+Ob5jznS6ud04vqDr622jtnnDrRtf8Hk1F1Qg==
              "]]},
            Annotation[#, "Charting`Private`Tag$1219210#3"]& ], 
           TagBox[
            {RGBColor[0, 1, 0], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{1611, 1661, 1612, 1613, 1614, 1615, 1616, 1617, 1618, 
              1619, 1620, 1621, 1622, 1623, 1624, 1625, 1626, 1627, 1628, 
              1629, 1630, 1631, 1632, 1633, 1634, 1635, 1636, 1637, 1638, 
              1639, 1640, 1641, 1642, 1643, 1644, 1645, 1646, 1647, 1648, 
              1649, 1650, 1651, 1652, 1653, 1654, 1655, 1656, 1657, 1658, 
              1659, 1662, 1660}]},
            Annotation[#, "Charting`Private`Tag$1219210#4"]& ], 
           TagBox[
            {RGBColor[0, 0, 1], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{1663, 1713, 1664, 1665, 1666, 1667, 1668, 1669, 1670, 
              1671, 1672, 1673, 1674, 1675, 1676, 1677, 1678, 1679, 1680, 
              1681, 1682, 1683, 1684, 1685, 1686, 1687, 1688, 1689, 1690, 
              1691, 1692, 1693, 1694, 1695, 1696, 1697, 1698, 1699, 1700, 
              1701, 1702, 1703, 1704, 1705, 1706, 1707, 1708, 1709, 1710, 
              1711, 1714, 1712}]},
            Annotation[#, "Charting`Private`Tag$1219210#5"]& ]}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Background->GrayLevel[0.97],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{16.1530612244898, 1.5}, {7.500000000000028, 6.5}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 6.283185178951315}, {-1.5, 1.5}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {193.5, -355.98757751993935}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJw82nc41f/7B3DZe69jO4o0NEWR+6WszMyQD9pDSkLJDtFQMoqyIsoMZSS8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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwVz7tLlXEcBvCfGiKCBEGpNdnFvIzZlllCll1Iz5gN5SWwIYc8gprHS5oK
5VCBOtjQ4CVv9C9UXkobK0e1DGrRxUUt/bzDh+f7PO95Obw51Q2xR8khhCTe
E08LoZEWYytPaCPnUAhjKSFcYUefY5QL9g+2exxl1ZbgpH1cL2NXn2eMYvtH
232OsWZr55R9Qr/Knr7Abds3/TF5jNsu2j65q8lk3dbBafs7/Rr/9EUqbN/1
RvKZsJXY5tw1ZFGvb8oX/PT8jr7qTnAuelffkUN0en5Gn3SX0+zel//tNe4/
7t6IO4PP9kr5w/ZaxmWHTOUNBXqD3JbD8pV8Lo/wNvoe71+S8/aXsla2yRRG
yNYfyi05KAdkvzzML+9WyTVbO93udIrccbkb/SddfperT7mvs6/X6n/dfXzR
Y/qKu4lCJm2XbQvuOo6zYbtrW4++kfM8tZ21TbtvEFiyTVFqX9QfcILftm7y
7DP6TZJYtk3TQ75ns7ZbJPPVNsMzeumjnwOFUV52
              "]]]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwV0jlPlGEYBdAX1EQToyDEXdBEpUUTREHEhU6hsHGHSOMKg4CKQUNhpEET
lwQTZRkc8EfILv4Bl8YFKLFREBChMZy3OLnPvd/MhAF2VSdO16aHENIY45py
Z3UIjdxzN3E3bvTxgSXKVoTwlp0rQ7it9zLGIifsfeR61qhPkq1XMUqxPWV7
zz+O23rJsTfoE2TplYxQZH9jy3PX84UK26htgWN6ih22ev2le4kGfb98wCTn
9HHPH7t/c1XfINPlfS65hznk7vG6TNnGc9s8te69cpVs4Zb7hfwsy+WI9yTl
Wloje7v8KavlX8875H+9SR6VT+N3k9vj53meklk8od3+Si7G7y33yTXyYfx5
3ROcdf/wvjb3L67omTJNNnPRPcRBd9LrnrnnqNH3yDo+cUof9vyRe4rL+rxe
6u5hm16n57ubGeeM7bstw32BQQpt3bbd7gQfOWkbss1xRE+y1ZbQv7FeP88A
B+xdtkFmKbF1s8Ue/1G/si7+LemnwN5pG+APh21dbLbXxN83/cxQbO9kk2c3
9Rtc5zXvmKbI8w42es0yJmZmiw==
               "]], PolygonBox[CompressedData["
1:eJwV0slTznEcB/CvetRDGAdutrilzTKWsyUcUNkuljEjezgQHcykzChb0ZPU
wZjhrE2L/8DWk33rRkQxw4ELM17fw2ven8/7+/s9v2fL3XusrDIjhDCBNCeT
IVTRprybCGEmV2nPDOEfVeaVso7P7LH/cO0CcyVDbNAN6N4y1b6DByzV39S1
coN+3jDF2XYGWOKaFl0fr8nRbaOfxc5Suu/Mtx8lzXp9r+4Vk+1b6WORvlk3
Tq79CIOs09/XFZmrGY7P0L3UTTJvoZdi3XXdCnMtI+zWjekazb/ia9rnycM8
pcTe4zxl/sMJe6FMynOcMX+I79H8wnXT5AUadONUmJMyyGrKzU3x/coiec09
d+QMrtCmb5d/5Sm5XN6SOZyPz7Sn5Ce5S35z/205PT4z/rb6VvkzfgY5Vybk
WQ6Zn7DW3O2+ZvNvjtsLZLas4bT5ffzezM9dV28eY589W5bRQ6G9yfkycw0f
2an7qptjPshj1ui6dPnx/8Y7ynXPdFnmUrop0DXqRpltP8AjVus7dUNMtG+m
i/z4eXVfmGXfz0NW6Tt0aRL2TXSyMH7HunsMkqnbSAd5zi7rLnGRBv4DOaNr
RA==
               
               "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}}, {{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl1nfcjnUYhvEXKRSyd5nZW2RnhbKVSMiWBqVkJmWHbFmZZVQqIxRCVlZ2
GWVFISqrrPS9Pv1xvOdxXr/78T73+N3eXO26NXk5UUJCQpfECQmR2/yohYb6
Eb2M/ExvLd/Vs8qJejNZWNaQa2UH2dR6YtlfbyLTyYryS/mc/NZ6QTlPbyEr
yLpyoyxt7ZzsiJu8nPkS/jHPxafzUvHd+DrZw/z++E48F6rwVXKPeXG+iD8K
mrBdPoajfCSyGU7Si+BJPYn+Jk+PjXoh/cP47iijn5edcIt/gtzWZ8R3xmt6
Gn0kz4298e9hB6+Nn/goPIW7HDfALAM26Q/jd94Zt/mneD2Ow06zOviZj0Yz
JPX5t8wyYrNeFhd4F/zLF6NnHIddcW1xjL+Hp+Oa4qLZ87jDP8MbuBvfmz2O
43wMmuMR/GHWNR4MfC564R7s1p/ACT4WLVAeybDHvB5O8nF4BhWQHClwL+5D
Sux1XH2c4uPREhWRCvvMG+AXPgHPohL+NHsBifCF3hupsT+eW5zmE9Eqzs01
G2iWCVv0yviLvxjPBpbofeJZwgG9Ec7wSWgd5+rzb5tlxla9Ci7xl5AES/U8
jvkgnhX01dPqo3geVOVfyX3mJfjHvFpcH75FpjE/KBvj13gmzD/nk3l2Ppk/
LYvKmvKb2COyTVxr+Y7eVGaRleQK2VZ+Z72w/Eh/RlaK+ys3xfMmq1q/zGPz
N9Lvko/IpXKZtbx8Jn849g5fL/uZp+Ojed7YX/xrud+8JP+EV0da/Yd4B+A3
/j5yWH9fLxbvgngW9EE8K7bpj+IK74akWK73R3rHvafnw4H4/fgxzhln+RS0
RTVcNeuOu/Gl/mZ8Hodin+Mcn4p2qI5rZq/gHqzQByADDutP4TyfhvaogYw4
Yt4Mv/Pp6ICayITMyIKsyBb3L84bR+Me4gKfgY6ohQfwk3lzXOQfoBMew99m
ryIZVupv4UH8rLfAH3wmOqM2/jHrgeRYpQ9EThyL+48/+Sx0iT3omg42y4bt
eh1cj3cZUuArPZ9jZvGyeDuuiz6GP4SDei4c5y3xF58d5+OYKXrxeMfEPteH
8OyozFfKHeZF+Pz4rKwc7xG5Wda1dkO+HvvB7F5ZXi6TbeJZs/6QnB3XTJaT
teUG2Sn2QtwjOTbut8wfe02ulu3kD9ZLyU/1Z2WNePfIrTK3tRMxxyVe1vwL
PieuO5/KS6BrvLv0oTwHdupF9QW8Suwx/absifuwWs9vfU7sLwyKZ0Ufxwvg
x3h/4CRvhct8Ll5ASscNM3sAu/QncIu/gZRYow+OvYpTemtc4fPwIurhtlkv
pMJafUjcW/wS1xRX+Yd4CfXj+uJ07FFc4x/hZTSI80ABFESheL/EvYzzRzGc
iXcP/ubz0Q0N8a9Zb6TGN/pQFMevcV/wD1+A7miEO2Z9cD/W6cNQAr/p7XGd
L8QrSOUaDTd7EN/rjRH/6ffV02C9Ojz2ptl4vSAO6SVxlnfADb4o9otjpukl
Y+/pqfURPCd2xznqC3lVNNET6f14WlTgy+WGuEZ8bjy7qBN/98gR8W7gE+Ld
IgvJ6nJNnJM8bL20XBzPgawpG8R7PNH/f5uVsv4fIC0YUw==
              "]]},
            Annotation[#, "Charting`Private`Tag$1219266#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV1XfcjWUcx/Fjyy6RlR3Ze1dWMkpZWUVCy5bdQLIq2bRIGaEimzKKMjKj
7E1WZioRpffvj8/r+/t+rvs6z33Ouc795GvfvUm3JIlEonrSROIlZE2eSExJ
lkhUxWX9G3yETuiMLrjHNVOtV8MVfSWmoCuyWfuYfwC/66swFRX4lVwrZMB+
rhuy89P0B3FVX42PUZFfxbVGRhzguiMH/4n+EP7Q1+BRbqfeHQUxjavErTY/
hUw4yLXgDptfRWn04HJyn5qr40/9Wf2MeRi+1R/Td8W1uA9d9T/kOHxivbK+
xvx0vK45Ce40vyAvyndwyHUt9SPm1/Cm+Q6UMb8sr8sP5WT5rsyMGehpXy45
nR8ra8j+8j85Rf5lvb08q0+Ww+VwmS4+I3xnvaH8mZ8QrycHyRQoZO4m/5Tj
4z7jvuOzsKeK/JZrE/drToq7zC/KS3IUDruulX7U/DrKopd+Q74X78v6vfE+
zDVxTV+Lx7lfYh2FMZ2rGvdqbovMOML1Qm5+pl4Lf+vrMAPV+LXcM7gbR7ne
yMPP0mvjuv49ZqIP8lr7jH8YN/QfMAt90Q/9MSBeJ3Ui8Yp8Fa/hdeSzd7Z9
dfCPvh6f4QF+HdcOWXCMG4j8/Bz9EdzUN2A2HuS/555FVhznBqEAP1evi1v6
RjzB7Y7PFPdjDvcQ94O5Pe7BCW4wCvKf6/Xwr74Jjbg9em8UwVyuOrfe3AHZ
8JJ+Oc4cTlpvrR8zD0S52Kv/I9/HG9bv078w18cA8235H9/BfM48IjCnx498
Y7mXmyj7yMEyZTwfUDR+r3GG5QdyQpyrOGdx3uP92F9DbojzKTvGOZPJ4tmD
7HoneSXOmxwt35IZ8au9T8njcd4x1JwG5c195M34mxjiukL6l+YGuK131H8z
j8RmvYm+z9wXxfAFV5PbaH4OOXCKe5o7Ee8RFeI3zhXm5pkfRQJbuC9Ri9+k
P4+cOM0Nxf38fP0xJMFWbh6GoYi1r7iGSIpt3HwMxwiMxFtx1p3ft+U7GIV3
UdTeBfY8jmTYzn2F0ShmbSH3BJJjB7cAteM71F9ALpzhxqA4v0hvhBT4iVuI
h/nN8YzAvTjLjUUJfrHeGCmxk2vK7Tf3Q3Es4upwW+JMIjfOcW24k3H2UBHj
uJLcEnMTpIrvQD8f3z12WW+mHzD3j33mVChh7iGvxVnEYtc9om+NMxTn3Zwc
ecyd5e9x5uUY+bbMFM/FOBf2tY3zxU+SQ+QwmTb+h6FSnBN5S34kP5Sj5d3x
HMN4+0vJpfFeZFP5ikwgdZwHeSH+Zpw/c4Z4dtvzpDwYv7k4s3EtSpp7yr/j
XrDEdXX1bfEekBdd9KtyLM5bf0Y/FWcTlTGBK80tMzfDHfiFa84dintDKSzl
6nHb4zWRDxe4iSjDL9efRBrs5pahPr9D74r8uMhNQll+hd4cabGHW47JKGft
a64F0mEvtwLv4X18gPKu+cZaS6THPu5rNOB/0ruhAC5x7bjT8ftHlThv+r/x
3WCMOUv8v4jvybX/A+qDKO4=
              "]]},
            Annotation[#, "Charting`Private`Tag$1219266#2"]& ], 
           TagBox[
            {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV1Xf8T1Ucx/GvvQoZUTaVGZFk770pe5VKg9DQXmijpYTsvffeM9mjQchM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              "]]},
            Annotation[#, "Charting`Private`Tag$1219266#3"]& ], 
           TagBox[
            {RGBColor[0, 1, 0], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{2060, 2110, 2061, 2062, 2063, 2064, 2065, 2066, 2067, 
              2068, 2069, 2070, 2071, 2072, 2073, 2074, 2075, 2076, 2077, 
              2078, 2079, 2080, 2081, 2082, 2083, 2084, 2085, 2086, 2087, 
              2088, 2089, 2090, 2091, 2092, 2093, 2094, 2095, 2096, 2097, 
              2098, 2099, 2100, 2101, 2102, 2103, 2104, 2105, 2106, 2107, 
              2108, 2111, 2109}]},
            Annotation[#, "Charting`Private`Tag$1219266#4"]& ], 
           TagBox[
            {RGBColor[0, 0, 1], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{2112, 2162, 2113, 2114, 2115, 2116, 2117, 2118, 2119, 
              2120, 2121, 2122, 2123, 2124, 2125, 2126, 2127, 2128, 2129, 
              2130, 2131, 2132, 2133, 2134, 2135, 2136, 2137, 2138, 2139, 
              2140, 2141, 2142, 2143, 2144, 2145, 2146, 2147, 2148, 2149, 
              2150, 2151, 2152, 2153, 2154, 2155, 2156, 2157, 2158, 2159, 
              2160, 2163, 2161}]},
            Annotation[#, "Charting`Private`Tag$1219266#5"]& ]}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Background->GrayLevel[0.97],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{16.1530612244898, 1.5}, {7.500000000000028, 6.5}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 9.424777768426972}, {-1.5, 1.5}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {580.5, -355.98757751993935}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJwUl2c8lm8bgJG9R2REVvbe4+E6y0iSJFlJoTKiVCL/kCRZZauQpFBIske5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         "], {{{}, {}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwVzTcvhnEUhvFD1E1sWngZdLGZhE1LlJdFmcRkYMCAL6AlLCx8ATEY9YVB
nVhZkEhsEoPOz3DnnOu6z/95EsPjybHUiEiRKWnOiWiS07SIvKyIt4yIYplL
j6iSd76VL8+M6OR3uH454/P5d65E5rlqmeCSbqe5e/zhro2r4Lq4Xe4Qr+Nj
PICX8RhexVnZEU/2H/6WP7Df8+V8Bj73vQLzg6vnEubzv3e34M2mfc7eotvW
5ZoveNSs0U/qe3EjntH/4Ds8gh/0V3gLJ/G1PmEGN2F++ne7vVLfgLv1r/gG
73l7ZN+wn/CDeAWP4zX8i+/wIX7AF75ViD/tpbKor5Uprs/NLPeIv9x1cFVc
D7fPDcklX8R/cWWyxNXJN/8HsxtCcw==
               "]], 
              PolygonBox[CompressedData["
1:eJwVzrsv3XEcxvEPUZfJQRSTc/AvmCSNSziECkfnDkaCSNukk1vSLiy18BcQ
CXFZ6OA2SUxsFbdJYnI4EgONeBmefJ/3+/l+8/ulBscyo/kRkSc/5VMiIi27
BRGlxRF3hRGVMvEhIilZvpmvLYro4Ne5ftnjE3yW+yiTXEpGuB53v3EX+N69
Fi7JpbkNbgcv4D2cwbN4CP/Bz/gf3sZXeN/7MnyvV8mtfmSbcm9J/6W3l0Ss
2hLOLK6zjdo+603cd9t/fI4H8aX9GK/gPnxir3W+4nHng2+22lO4EXfac/gU
f8Wb3v/Fi7gb77//m/MJD9jmbMP6PF/I3+gv/Bm/o1/zB75Rjh/0apm2L+Pf
9jVcj8dwL/6Br3DOmzaujuvitrgvcshX8DmuRma4Bnnk3wCf4UOP
               "]], 
              PolygonBox[CompressedData["
1:eJwVzzkvhGEYheGXjC0RprIlCoVSbYstdhKF+AEihsTa2KJAgwIVPQqDnoaO
hIYoMIlEZx2JRIFCFC7FyXPu+3wz30xJ33j3WGoIIUVmpSUaQrO0poWQJ/2Z
ITRmhDCUHsI1npSnSAjlfB5fw8e5Nlnk+rkV7hPnS4xr4oa5G3yGd/AFnsKb
eA7v4Bx5wCc4qT97TwXOx7V41/MHeB0f4Xa8hGN4FUeyfF7/4hP8od7D3dtK
3Qg34RbYB/RmeyUesf/gO9yLb+3nOI678KW92P3F4+60fcs+jxtx/P+3u+84
V3+0nepvehmfjV/8l0q3gK/jP/Qrfc93Heob+jHfgZfxAF7D37hQBrkWbpRL
4BnZ5ha4XS4qr95RxRVy9XjfM51SJElbta3I1mD7AzZ0QV8=
               "]], 
              PolygonBox[CompressedData["
1:eJwV0L9LFGAcx/Fv91ObHFoaRU3OFOrSahPdHNWgu6PFUzcpUBFURJtz6k5B
HfQP0Iba9c4ghyAp72anwJO2QBx9OXz4ft7v78PDw9NZ/jDxPhERD2RNRjsi
RuQkHTElv1MRXW0RiWxELhPxmRuUZa7ArXNXOCnj3DPuLVfDZalw89wOl5A/
7uvmklwfrjhziD/hr3gIr+Ai3sAt/Asf4QZO4Qn8HBfwjd7U63xN39d/8I/b
I271ab7KL+jD3K7dQ7OFk/ql3fH9m7m/OGe2cUvmhbf26Cn7PH5q/w//xO9w
1d1HeBOP4W/2j8z/eM58ab9qX8If7YK71K/5c/6L3uTTeBLncRGf4jo+wGd4
Bm/hRbx3/wfS8LYnXJrrx1vOvJKMvOFf8CX+O56VpvO9fIYf4Le515KVO/tA
Pck=
               "]], PolygonBox[CompressedData["
1:eJwV0DtPVFEUhuHlBLllBqayoSKWBJCAGhCFAUoqO0FwuCQUCrRCM1iIJbbc
nCH8AYYCWgobuTRaiAExVBYkQENCqHhO8WV977t29sk+jeOzr2dSEfFACjKQ
jeiX9MOIoeqIzqqIfGXED/xeTioimvk0386vca+kwI1yn7lLnJFhrosb4/bx
B1nmPnJFrlpO3dfCZbgOvO7MFl7CO7gHL+B3eBGnaiLO9Sv+J1/Wj/nHfArX
8W/NF/w4f6v/1g/47/qmPujsvl2DeYenzWn7Ffs5nMMl+7R5gafMGnxuv4ff
4P+4yaxN3mP+9Y7W5PvJO/DT5D/gI/zN3WX9q77LP7K/0Xv5T3xe/8Jf4194
G//B9XgEd+MJfIhnZJWb5za4Wjnz7SdcPfcMF53JSVZG+Zf8JH+EZ+Wf8218
ln/Ol7g+uQfP5UAK
               "]]}]}, 
           {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
            None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwVzjkv5WEYhvFnxDh0JLZYJgSH+QKqCY0lsWSQDGoqifVEhn4sFQ0Nn0AU
GkuCxjIzmUQ1SiRoJDqJ5SiczPwUd977uu73v1QPTfSNZ0XEB5mWpvyIZnnN
jvj8MWJRPuVEpKU0N+I3P8jtSTeXTES082n+lpvlerkU14AXpJJ7kRLu1/s9
/cCdS5yxr+IxvIwHcFovzYs45tf1Q36XP9cf9S6+0V6H2/CLd6bwP1zl/Pv+
D85NfGa/8ewwvsIZPGP/gnvwFK63j+AHXODcsrc5F/GGfd7+R7/XK2zPUqz/
9N0bfd92gd/cu9MTnl3hR/Ulvp8/wmv4AO/gTlyLW/Gz91xz37mv3CSXxHNS
zj1JEXfq3jduWzq4Gndb+Ce+jvshZfyjFPIn/H+p0EKz
               "]], 
              PolygonBox[CompressedData["
1:eJwVzrsv5FEYxvH3J27TbaJ3C2sSd3qh24K1mWEUYolEJWE1KOz2JNjR0Ng/
AAW1W2MbMUtCrXJLdJsoGR/Fk/f9fp9zTk7d5GxmpiQiElmU3k8RfZIrj2iv
iPhWGVFSFtEteUnzCV/PX5VGTHAnMsy38YN8gh/lFzfCLXJd+Lc0ccHVcZfu
J3hL5rgNbtyZv/gPPsXH+Mb+Yh/iW+1f7cEnZn0q4prPmnu6Avegm8K3uIh/
6ntwDi/gTv00/o+rzAP9F3MF7+rX9aP4HD/jz/pOXDRr8T//rjDT3B2XM4+d
vf34F36yp7hN+w97nv/uzTO8jU/wEc7iFjyAi96855a4YW6e68D7eBnv4DXc
iN+kBhfcGeMOJcM1O9fPv/Ht3Ko08K9SzV/w71e8PTk=
               "]], 
              PolygonBox[CompressedData["
1:eJwV0Lkv5WEYhuHXMpggsZ1umkmUKltsscygm0apwRFbY+8cDQp01EwyzvEP
jClGOcVUk9hCIjQcCsUkgko0rlM8ed/7fr58v+VzcmZgOj8i8iQlvRURfbL/
IaKjKCJRHNFcEnFfGLHInckU/4Uf5RO4XzLSztfwTfyd8+U4I8vcd27BmVOZ
5Hq4JFeDr/EvfIFf8CYexWu4Dx/ibXyA0/jI/mhv46vtjfas55WadR8jHvhB
848uy5XhSfwfl5vp3PubKbyrn3fnNH7Dn8x/+m9mBv/Vn+iH8CV+xRP6FtyN
R3C1vsCs5a50B/w5fuaz9gJ+g0/aV/le/jfewj/xHm7FVbgB3+a+Be/JErfD
zTlzLONcFzfMVeEnWedGuBXuK/4hLVwlV8/duG82999kjO/kh/hK/A4dCkAy

               "]], PolygonBox[CompressedData["
1:eJwVzjlPlFEUgOEzhNmYxoaGjo4tiAvImhDpLElYzDCSUKBYQCXTsCRAqyXD
IiT4AxgKqElwARMLaACpqCyU6UwMnc8UJ/c877358jVOzQ3P1kREwiyb5w8i
hsxAMmLbPE5F5NIRbZmIm9qIt9qZmdS79Zd6jvvNlnmk1+mt+k/v07xritqG
NuPNd/7En/mUX/EzHuc6vuIDvuAK39oT2Yg1vWBf0vv0v/Z6/Uh/4fzAZXeb
7gr8gyvc4f4JZ7mFr/1XsWp7i/OX+3HnsftbLcXT/Jtzzh0edM5zyf0b37+3
N2hn7vbsJ/o3/dL+z17Qu+xj9my1c5nP+Y5XeYIXuZcP+T3v8wY/5Aw385X/
TfJH805b115789VMaJ3aqJbhP2ZFy2sLWg+XTLuW1pq0S9+b1r6YvP5UH9H/
A/PqQE8=
               "]], PolygonBox[CompressedData["
1:eJwV0T1PkwEYheEHQ1UGUMStUMPCiLsBTKQifmANiT8AF1ohbSVhEHXwIxEd
1EV+AGrEVh3rIhsSXNStUOOGkFDahEmNMeFyOHnOfZ++b9q091phPH8gIlrk
oYwcjRiVZmvEzbaIjsMRJ93GwYjVQxHb+Lhelgf4Fb6TiPguM9xFbpo7ga/I
eznLp/jTfMN7u3BJ7nMvuds+U5Mb3AVuikvhP/KMy3GPuQxexgv4A36H07gH
D+Fd7253+33fXf4Tv4WP6U39CP9GT7v38AvbLe8o4n845X61Z9wl/Nm+YZ/A
NfwXF+2n8Hl8HffYZ3FC73N/2K+6FXuV+23f1BPcU1tWf8Rf5j/i57iC3+Jv
+p4+zHfrg3rdb6rjFfwTd+pLchcv4jnPfcGv8RpexwU8inO4G/+SJ9wkN8+N
4bKc4ZLcALfz///mqpLnz/FZPokvSUn2AVyjSwQ=
               
               "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}}, {{}, {}, 
           TagBox[
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl2Af4jmUbx/F/RqFIGqhkKyujzEKhoiJ7791AKFT2nlHZe68os+yZkS0j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              "]]},
            Annotation[#, "Charting`Private`Tag$1219322#1"]& ], 
           TagBox[
            {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwl2GXYVlUTQOGHBlEpCWmQ7i4J6Q5RDFBQRBGkRUWxCOnuFJQSE+kQQbpR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              "]]},
            Annotation[#, "Charting`Private`Tag$1219322#2"]& ], 
           TagBox[
            {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJwV13f8TmUYx/GHimyJZIfMNOy90lBGRKVoUSRlj4xENFR22SOyQ8iM7JkR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              "]]},
            Annotation[#, "Charting`Private`Tag$1219322#3"]& ], 
           TagBox[
            {RGBColor[0, 1, 0], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{4054, 4104, 4055, 4056, 4057, 4058, 4059, 4060, 4061, 
              4062, 4063, 4064, 4065, 4066, 4067, 4068, 4069, 4070, 4071, 
              4072, 4073, 4074, 4075, 4076, 4077, 4078, 4079, 4080, 4081, 
              4082, 4083, 4084, 4085, 4086, 4087, 4088, 4089, 4090, 4091, 
              4092, 4093, 4094, 4095, 4096, 4097, 4098, 4099, 4100, 4101, 
              4102, 4105, 4103}]},
            Annotation[#, "Charting`Private`Tag$1219322#4"]& ], 
           TagBox[
            {RGBColor[0, 0, 1], Thickness[Tiny], Opacity[1.], 
             Dashing[{Small, Small}], 
             LineBox[{4106, 4156, 4107, 4108, 4109, 4110, 4111, 4112, 4113, 
              4114, 4115, 4116, 4117, 4118, 4119, 4120, 4121, 4122, 4123, 
              4124, 4125, 4126, 4127, 4128, 4129, 4130, 4131, 4132, 4133, 
              4134, 4135, 4136, 4137, 4138, 4139, 4140, 4141, 4142, 4143, 
              4144, 4145, 4146, 4147, 4148, 4149, 4150, 4151, 4152, 4153, 
              4154, 4157, 4155}]},
            Annotation[#, "Charting`Private`Tag$1219322#5"]& ]}}], {}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{0, 0},
       Background->GrayLevel[0.97],
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       ImagePadding->{{16.1530612244898, 1.5}, {7.500000000000028, 6.5}},
       Method->{
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}, "AxesInFront" -> True},
       PlotRange->{{0., 31.415925894756572`}, {-1.5, 1.5}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {967.5, -355.98757751993935}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}}, {}},
  ImageSize->{600, 200},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.720248119455225*^9, 3.720248197287636*^9}, 
   3.720248234661758*^9, 3.7202666381331472`*^9, 3.793502508369884*^9, 
   3.7935025650183897`*^9, 3.793502601432674*^9, 3.7939084021784267`*^9, 
   3.8232293133911552`*^9},
 CellLabel->
  "Out[2956]=",ExpressionUUID->"1b0a83e9-b073-451a-ad50-0b9d1155d00f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Jlogplot", "=", 
   RowBox[{"LogLogPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Js", ",", 
       FractionBox["12", 
        SuperscriptBox["\[Tau]", "3"]], ",", 
       FractionBox["2", "\[Tau]"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Tau]", ",", "0.1", ",", "100"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0.01", ",", "1000"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Jlinplot", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Js", ",", 
       FractionBox["2", "\[Pi]"], ",", 
       FractionBox["1", "\[Pi]"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Tau]", ",", "0", ",", "15"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Jlogplot", ",", "Jlinplot"}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"600", ",", "200"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.720246276848366*^9, 3.720246307557917*^9}, {
   3.7202464326416817`*^9, 3.7202464847825413`*^9}, {3.720247820704083*^9, 
   3.72024791832719*^9}, 3.720248268329108*^9, {3.720260713198587*^9, 
   3.7202608486687*^9}},
 CellLabel->
  "In[2957]:=",ExpressionUUID->"c5e872b7-a65d-4f39-a993-09c78332d628"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV13k8VN8bB/CZMQtmkCURSkKRyBIVOaciElKhTUKFii9FiyJkSUKWylIk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           "]]},
         Annotation[#, "Charting`Private`Tag$1219568#1"]& ], 
        TagBox[
         {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAALesypKmW97+g/4+ZiqEbQEVceAC1
dPe/chTEHhOIG0B3udAvAxj1v1haRsKNwhlAoW8iiFjG8r/3ooPETQUYQDND
ciqUnPC/pYE/fvplFkC3zWNnMYjsv2M8L+WdoxRA2U/fDQcn6L8wjZ0DLv8S
QOqDTQbr2+O/tuDGgANjEUBRsDaZwWbev5ogSFafRw9Abc7KTUa11b/mq/8Z
EQUMQMlZPDzdkci/Uu8eOHB8CEDUebeSnEWovzM4tBNaBAVAPGPfRblftj8w
rUZeHcgBQPvADjPZ5s0/nLSBBpyL/D+Mcp65Ua/XPxFncC6w/vU/HyL7ngmT
4D+ZE10WPsvtPwlZNA9cOOU/st1ii4223z8jVXHr4Y3pP0nU04ep1bY/ELHO
+dVA7j90Mjv0TXzWvxbpF7r+UfE/kvxAaZ1n6L+tIE9Oi3jzPw4lRnF0p/K/
LYiW+87N9T+MWxx5P6f5v0XS314s+/c/6xx80asXAMBGTDnbQFf6P+1TAozK
oQPAT22ZLk6o/D95hRKJXhsHwPBw+zd10f4/7IolFxlZCsA+0jatqZQAQD3Y
0Erm3A3AUN1wmaWsAUC6fL8HbZIQwOY7LvEdvwJAm4pbiyEuEsDiwhS8KOgC
QBVVtbuxaxLAmo/rRg==
           "]]},
         Annotation[#, "Charting`Private`Tag$1219568#2"]& ], 
        TagBox[
         {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVymlQU1cYgOEkQMJi7yXXEdQBRaqySNEAFauW80kJuIEGR4hUZZWduisq
xU61SlvEsowlgoAhMLEGSaIIpNRz1KLADAgIaEQWR0G2IuBgAsG09sc7z593
WdTB4AMcFosV+Kn/TTjTKFclcciARUa8r44HdlK/obA4DslfYyIfneJBSwN2
Mo3mkK2h6W/zxnngYXO3PCSMQ27JjsW+HeDBnFIqM2zmkFQUGZPZwYOswTMl
wpUcYnl8fUSXigdqkXu+tp9N3PvHQhOTP/1OuRfZIWxy8q4oIOcVF67WdWin
nVnEZluu5MIdM9BiV6lmqRHHjz+1/q7AFE6El9X+pjdgb59sO+1FE3B5QtdU
Smcw/8SjgqG9HBDuTWVVHdPhorpZNCpkw8na1tUmC6ex92h5aI4tC64fdMwQ
P5rCksxi3umej8jzmyOueYUTeFXEuxtVtw2oujk6TpAxhp+arPZc/+0M0u7o
+4znNITf/J3MLXPVoZFzgdzR7td4rLeUY2s2jUTKtZL7sb3YqrFpoE05hVJa
mgL9qzpxbus75uj5CdS4Z+PGnuwGHLnTIkgTPIY6TlXnFArlOFO1oqFQ/RZt
jO4T1obfRRmBPl3bol4jA6E8tYPNKGp+SsyihB6UeaSoVlT5DInYIX5eFR1o
qaOhyCK3H0H43NmB5EfIYo8XvXfdAOq1q9P31BWhz3cfHn11aRiVaGuidXMa
bK1qmemEcQTj8ukVK1qxzbCtxiiaRGfWJI0cG32OKxx2BP2a+h4l8WTXnj7o
x19kXDG0NE+jpC4PfVjKABa29+13M+hQQWL9vQUNw9h/+1fdEDqLru1Prfb5
YRzvSJG4B8nnkHinXaVb9iSeOGTwPt5mRDO70mt2ad5jn/a1FTfyWHD+4sQL
AfMB7+w5JClTsEF+Lea2i68eD25wn7THHOgM64taHDeLD6uPdk4OmcBIQOKq
B5o5vHmxJq/daAr5trob5waNeP7VjH7KjQu/WzU5pJewiKuVmCcW8uBWmiTg
cS2b1D/5Q2K/xxy2bBrTZjZzyG7FTzU+5y1Aa/9YX6E3IYLTkerkAkuoGpVO
ddNmhBNRv+5DoxVcaOOeOuDDJaEShevc1DzothxPTIrjEf3DPB1lTkHal13e
6Wnm5BLXTPS9Fw38VP/sMbkF8bb/0zdtpTVM3ayuj7tvSYYjqhh9pTWEeCoO
hHdYkSvK9/JlQj4o251z1MZ5ZDhVrRC18iEkulzCLKBIuaLBDbfzobWpXfLP
IorE9Pcq3Dr5sN3jX0nDEor0BlhV8F7wAdjiq+nOFOmwian46zUf3IotCkY2
UOTenQW3XHR8YHUnFz6IokjeRGolewkDimDP4iNKigQvv7z6oAMDzprw4sAq
itDissqXjgxIl2UWO2so8gtuq6x2YiB/4k1x70OKnM1yVaYIGPgx60rJ1mcU
SXR7qdT6MSBumrnuaKSIc8TUmoAABjoEK6UfOTQZyDVX3dnCQJAkWPqcR5MI
g5fqchADfvE3pVl8muxuuqQSihlw5+4rnV1OE8ZYKrgdxoA85efSTheatAo0
Kod9DCzvrCpVutNkq2RQZYhkYKGMksWuo4l585wgIYaBPKsNsk1f06SeNV/d
FcsAdTROZudLkx+9XDz8EhjIeJEr0/nTBOKRWpXEgKkvkbVvo8l/FjlYIQ==

           "]]},
         Annotation[#, "Charting`Private`Tag$1219568#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-2.302584952019448, -4.605170185988091},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({
          Exp[
           Part[#, 1]], 
          Exp[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          Exp[
           Part[#, 1]], 
          Exp[
           Part[#, 2]]}& )},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Quiet[
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
         Charting`ScaledFrameTicks[{Log, Exp}]}, {Quiet[
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
         Charting`ScaledFrameTicks[{Log, Exp}]}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{18.218750138392863`, 2.7187567812501356`}, {17., 
       6.500000000000057}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None},
      PlotRange->
       NCache[{{-2.302584952019448, 4.6051700450134945`}, {-4.605170185988091, 
          Log[1000]}}, {{-2.302584952019448, 
        4.6051700450134945`}, {-4.605170185988091, 6.907755278982137}}],
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->FrontEndValueCache[{Quiet[
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Quiet[
          
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 
           6}]]& }, {{{-2.3025850929940455`, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"0.1\"", ShowStringCharacters -> False], 0.1, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 
           0.}}, {-0.6931471805599453, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
          0., 
           FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
           FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
           FormBox["10", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
           FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
           FormBox["100", TraditionalForm], {0.01, 0.}}, {-2.995732273553991, 
           
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-2.8134107167600364`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-2.659260036932778, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-2.5257286443082556`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-2.4079456086518722`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-1.6094379124341003`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-1.2039728043259361`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.916290731874155, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.5108256237659907, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.35667494393873245`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.2231435513142097, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.10536051565782628`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {0.6931471805599453, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.0986122886681098`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.3862943611198906`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.791759469228055, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.9459101490553132`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.0794415416798357`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.1972245773362196`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.995732273553991, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {3.4011973816621555`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {3.6888794541139363`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.0943445622221, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.248495242049359, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.382026634673881, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.499809670330265, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.298317366548036, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.703782474656201, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.991464547107982, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.214608098422191, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.396929655216146, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.551080335043404, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}}, {{-4.605170185988091, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"0.01\"", ShowStringCharacters -> False], 0.01, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
           0.}}, {-2.3025850929940455`, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"0.10\"", ShowStringCharacters -> False], 0.1, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}}, {
          0., 
           FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
           FormBox["10", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
           FormBox["100", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
           FormBox["1000", TraditionalForm], {0.01, 0.}}, {-3.912023005428146, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-3.506557897319982, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-3.2188758248682006`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-2.995732273553991, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-2.8134107167600364`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-2.659260036932778, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-2.5257286443082556`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-2.4079456086518722`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-1.6094379124341003`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-1.2039728043259361`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.916290731874155, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.6931471805599453, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.5108256237659907, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.35667494393873245`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.2231435513142097, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.10536051565782628`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {0.6931471805599453, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.0986122886681098`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.3862943611198906`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.6094379124341003`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.791759469228055, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.9459101490553132`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.0794415416798357`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.1972245773362196`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.995732273553991, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {3.4011973816621555`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {3.6888794541139363`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {3.912023005428146, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.0943445622221, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.248495242049359, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.382026634673881, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.499809670330265, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.298317366548036, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.703782474656201, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.991464547107982, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.214608098422191, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.396929655216146, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.551080335043404, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.684611727667927, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.802394763324311, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {7.600902459542082, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {8.006367567650246, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}}}]], {154.40412866712808, -99.57528725977542}, 
     ImageScaled[{0.5, 0.5}], {289.8017067094509, 189.66721382814367}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwd13c81d8bAHBkr5A9yr3XuNcKiYycx8oqo5AkISvJjtKwlRkto0hDVoPK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           "]]},
         Annotation[#, "Charting`Private`Tag$1219622#1"]& ], 
        TagBox[
         {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/e3eySMq3VPsmk+czDWIf2LvpvLq7sfrh+xh/J/X
zad+uH4Jzj/svHzJxUWP4XyZ+zufJem8hfNFcuJXsTt/hvMnGbrt9gv9Aeff
nGFw4KPAXzi/e0n9eSZJRgcYX3zK487Jc5nh/PYQT7tL31jh/GLLhfEnmzjg
fJf3v6ryHnPB+Y02gYlSFrxwvtW6mVvq9vPD+Tk/Pjac4BWE839qC9zTDRWC
821Wr1kwbZownP9RyCsh7JAInP+kJyGsiF0Mzvd8X+751Ewczn+TzFG8pV7C
ARGe4kzthyThfKGzan0b3kvB+TId6wPMzGTg/BnalgLC6bJw/ikpR9PPE+UQ
/pE5NEH/mjycz8e8qCSxSQHOl2uUt4lUU4TzOVVjtgUdR/D1bCXXl8cqwflF
94QOezEow/nvP/eEes5A8N31j83y1FWB8/d9tv79/RyCn6djdOtiqiqcb/su
5Uokpxqc76oi4cu7CMHXaOiqOGSuDudrpVruV72F4Kfuy2jZUqgB5+9fcCXl
o6gmnP9lxf/v+tsR/GTV1ZyzfLUQ8aU12WzTBwR/x5LfD792aMP5US7KDtZy
OnC+dG77Tr0DCL4oV85G33BdOP+W9eTLy1Yj+PNyd339/x/BBwD61o3a
           "]]},
         Annotation[#, "Charting`Private`Tag$1219622#2"]& ], 
        TagBox[
         {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/e3eySMq3VPsmk+czDWIv2LvpvLq7sfrh+xh/J/X
zad+uH4Jzj/svHzJxUWP4XyZ+zufJem8hfNFcuJXsTt/hvMnGbrt9gv9Aeff
nGFw4KPAXzi/e0n9eSZJRgcYX3zK487Jc5nh/PYQT7tL31jh/GLLhfEnmzjg
fJf3v6ryHnPB+Y02gYlSFrxwvtW6mVvq9vPD+Tk/Pjac4BWE839qC9zTDRWC
821Wr1kwbZownP9RyCsh7JAInP+kJyGsiF0Mzvd8X+751Ewczn+TzFG8pV7C
ARGe4kzthyThfKGzan0b3kvB+TId6wPMzGTg/BnalgLC6bJw/ikpR9PPE+UQ
/pE5NEH/mjycz8e8qCSxSQHOl2uUt4lUU4TzOVVjtgUdR/D1bCXXl8cqwflF
94QOezEow/nvP/eEes5A8N31j83y1FWB8/d9tv79/RyCn6djdOtiqiqcb/su
5Uokpxqc76oi4cu7CMHXaOiqOGSuDudrpVruV72F4Kfuy2jZUqgB5+9fcCXl
o6gmnP9lxf/v+tsR/GTV1ZyzfLUQ8aU12WzTBwR/x5LfD792aMP5US7KDtZy
OnC+dG77Tr0DCL4oV85G33BdOP+W9eTLy1Yj+PNyd339/x/BBwDGC4qa
           "]]},
         Annotation[#, "Charting`Private`Tag$1219622#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{10.030612244897956`, 1.5}, {17., 6.500000000000057}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 14.999999693877552`}, {0, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], {458.50893866401174, -99.57528725977542},
      ImageScaled[{0.5, 0.5}], {280.39481203470586, 189.66721382814367}]}, {}},
  ImageSize->{600, 200},
  PlotRange->{{0, 608.2096199937673}, {-199.15057451955084`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.720260771078908*^9, 3.720260783582456*^9}, {
   3.720260831029131*^9, 3.720260850990531*^9}, 3.720266638495277*^9, 
   3.793502508790092*^9, 3.793502565340597*^9, 3.7935026018544283`*^9, 
   3.79390840268649*^9, 3.823229313812402*^9},
 CellLabel->
  "Out[2959]=",ExpressionUUID->"1b0249a6-9a17-46d2-8a29-3b8e0f9745ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"Js", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Tau]", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.720246503416857*^9, 3.7202465075106087`*^9}},
 CellLabel->
  "In[2960]:=",ExpressionUUID->"7c7fb8bb-b9ad-4bc2-b2b4-24a498de5be7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["12", 
    SuperscriptBox["\[Tau]", "3"]], "-", 
   FractionBox["12", 
    RowBox[{"5", " ", "\[Tau]"}]], "+", 
   FractionBox[
    RowBox[{"64", " ", "\[Tau]"}], "175"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Tau]", "]"}], "2"],
    SeriesData[$CellContext`\[Tau], 0, {}, -3, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Tau], 0, {12, 0, 
    Rational[-12, 5], 0, 
    Rational[64, 175]}, -3, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.720246508150342*^9, 3.720266638746139*^9, 
  3.793502508931423*^9, 3.793502565565937*^9, 3.793502601984357*^9, 
  3.7939084028100567`*^9, 3.8232293139096746`*^9},
 CellLabel->
  "Out[2960]=",ExpressionUUID->"8f510596-de49-4e45-aea9-671aee1ce0c5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["\[Tau]", "2"]}], "+", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "\[Tau]"}], "]"}], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Tau]", ",", " ", "0", ",", " ", "8"}], "}"}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.720249367157295*^9, 3.720249396683296*^9}},
 CellLabel->
  "In[2961]:=",ExpressionUUID->"2b3629ba-7a7d-4b30-ad4f-c519cc21bdee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[Tau]", "4"]}], "3"], "-", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["\[Tau]", "6"]}], "45"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[Tau]", "8"]}], "315"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Tau]", "]"}], "9"],
    SeriesData[$CellContext`\[Tau], 0, {}, 4, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Tau], 0, {
    Rational[2, 3], 0, 
    Rational[-4, 45], 0, 
    Rational[2, 315]}, 4, 9, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.720249379637294*^9, 3.720249397098613*^9}, 
   3.720266638874918*^9, 3.793502508938979*^9, 3.7935025655734663`*^9, 
   3.793502601991878*^9, 3.793908402816103*^9, 3.823229313915584*^9},
 CellLabel->
  "Out[2961]=",ExpressionUUID->"78bfb13b-1322-481f-9dd3-c2da271f711e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dj", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"Js", ",", "\[Tau]"}], "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.7202596728139763`*^9, 3.720259694894103*^9}},
 CellLabel->
  "In[2962]:=",ExpressionUUID->"c85e2114-2dd7-4979-b9c9-74499a6ffcdd"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"16", " ", 
    SuperscriptBox["\[Tau]", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "\[Tau]", "]"}], "2"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Tau]", "2"]}], "+", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "\[Tau]"}], "]"}]}], ")"}], "2"]]}]], "Output",
 CellChangeTimes->{{3.720259673534479*^9, 3.7202596958866167`*^9}, 
   3.720266638995441*^9, 3.793502508987761*^9, 3.7935025656214657`*^9, 
   3.793502602038225*^9, 3.79390840285682*^9, 3.823229313947455*^9},
 CellLabel->
  "Out[2962]=",ExpressionUUID->"b8f379f7-bd0c-4b0c-b0bd-acd0a8040153"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"Dj", ",", 
   RowBox[{"{", 
    RowBox[{"\[Tau]", ",", "0", ",", "20"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.3"}], ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7202596851566467`*^9, 3.720259708469282*^9}, {
  3.72026062764804*^9, 3.720260678210763*^9}},
 CellLabel->
  "In[2963]:=",ExpressionUUID->"1bc0ff3e-3f4c-4f95-b4ae-7e22ddfb3ea7"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwcV3c81e/7VkZWmVnZ41iHc46kkk9uIxIyQrZshYiGVcjee4SMKEqEqIzc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       "]]},
     Annotation[#, "Charting`Private`Tag$1220981#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 19.999999591836733`}, {-0.3, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.72025970883121*^9, {3.720260637984383*^9, 3.720260678599626*^9}, 
   3.720266639133197*^9, 3.7935025090371532`*^9, 3.793502565698127*^9, 
   3.793502602089242*^9, 3.793908402921611*^9, 3.823229314010496*^9},
 CellLabel->
  "Out[2963]=",ExpressionUUID->"11401c0a-c320-43b2-8319-d1bfd1abcc09"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Dj", "\[Equal]", "0"}], ",", "\[Tau]"}], "]"}]], "Input",
 CellChangeTimes->{{3.720259721860528*^9, 3.720259727694047*^9}},
 CellLabel->
  "In[2964]:=",ExpressionUUID->"73bdca26-c5e7-48cf-980c-f577dd11df36"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Tau]", "\[Rule]", 
     TemplateBox[{
       RowBox[{"2", " ", "\[Pi]", " ", 
         TemplateBox[{"1"}, "C"]}], 
       RowBox[{
         TemplateBox[{"1"}, "C"], "\[Element]", 
         TemplateBox[{}, "Integers"]}]},
      "ConditionalExpression"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Tau]", "\[Rule]", 
     TemplateBox[{
       RowBox[{"\[Pi]", "+", 
         RowBox[{"2", " ", "\[Pi]", " ", 
           TemplateBox[{"1"}, "C"]}]}], 
       RowBox[{
         TemplateBox[{"1"}, "C"], "\[Element]", 
         TemplateBox[{}, "Integers"]}]},
      "ConditionalExpression"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.72025972840516*^9, 3.720266639584413*^9, 
  3.7935025092034082`*^9, 3.793502565862329*^9, 3.793502602245565*^9, 
  3.793908403082838*^9, 3.8232293141821413`*^9},
 CellLabel->
  "Out[2964]=",ExpressionUUID->"4946c5a0-54f7-43d6-ac16-2160f2a79243"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dj", "/.", 
  RowBox[{"\[Tau]", "\[Rule]", 
   RowBox[{"3", "\[Pi]"}]}]}]], "Input",
 CellChangeTimes->{{3.720259742660387*^9, 3.720259752708853*^9}},
 CellLabel->
  "In[2965]:=",ExpressionUUID->"b4fe1bfe-0d69-4cce-8c63-50de14881d0a"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.7202597480605793`*^9, 3.720259753100238*^9}, 
   3.7202666397707148`*^9, 3.79350250921154*^9, 3.793502565870145*^9, 
   3.793502602253413*^9, 3.7939084030919523`*^9, 3.823229314189684*^9},
 CellLabel->
  "Out[2965]=",ExpressionUUID->"c3464523-4400-4262-9853-396baa20918c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Js", "/.", 
    RowBox[{"\[Tau]", "\[Rule]", 
     RowBox[{"n", " ", "\[Pi]"}]}]}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"n", "\[Element]", "Integers"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.720259938759749*^9, 3.720259993112844*^9}},
 CellLabel->
  "In[2966]:=",ExpressionUUID->"b7eb0279-9d0f-489f-9c27-a3871d3ab572"],

Cell[BoxData[
 FractionBox["2", 
  RowBox[{"n", " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{3.720259949475852*^9, 3.72025999367946*^9, 
  3.720266639863328*^9, 3.7935025092606363`*^9, 3.7935025659181623`*^9, 
  3.7935026023017178`*^9, 3.793908403133115*^9, 3.823229314214776*^9},
 CellLabel->
  "Out[2966]=",ExpressionUUID->"eadf4e8f-6e3f-47d1-bb78-a353b5e2b127"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 119}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e80b3227-3a65-47fd-bfeb-6e1ed5c9bc20"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 328, 7, 105, "Section",ExpressionUUID->"c507134f-dc37-4726-94c3-a01b745a8c3d"],
Cell[911, 31, 2702, 82, 177, "Input",ExpressionUUID->"8cce65d6-1954-4fe9-875f-fc1712f6449b"],
Cell[CellGroupData[{
Cell[3638, 117, 302, 7, 30, "Input",ExpressionUUID->"024cf798-07c1-422d-b728-debaed5a33ea"],
Cell[3943, 126, 4149, 116, 159, "Output",ExpressionUUID->"ec47cbea-6ad0-4bff-a40c-08b2bcc2c9ae"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8129, 247, 467, 11, 30, "Input",ExpressionUUID->"75308833-e72c-4d32-8b65-3cc617844d08"],
Cell[8599, 260, 939, 27, 65, "Output",ExpressionUUID->"a03698a2-0cde-4c72-811b-49b5a9c108ee"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9575, 292, 330, 8, 30, "Input",ExpressionUUID->"8d841a92-91f8-4e18-b534-f7fccc1d65b1"],
Cell[9908, 302, 399, 8, 50, "Output",ExpressionUUID->"3a5ef3a8-a53c-464d-8d78-496f9db95e87"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10344, 315, 2675, 71, 178, "Input",ExpressionUUID->"60cb0b5c-79b9-4dbe-a996-ffdad42a93f5"],
Cell[13022, 388, 251084, 4228, 217, "Output",ExpressionUUID->"1b0a83e9-b073-451a-ad50-0b9d1155d00f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[264143, 4621, 2105, 57, 190, "Input",ExpressionUUID->"c5e872b7-a65d-4f39-a993-09c78332d628"],
Cell[266251, 4680, 60578, 1103, 217, "Output",ExpressionUUID->"1b0249a6-9a17-46d2-8a29-3b8e0f9745ab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[326866, 5788, 316, 8, 30, "Input",ExpressionUUID->"7c7fb8bb-b9ad-4bc2-b2b4-24a498de5be7"],
Cell[327185, 5798, 808, 22, 52, "Output",ExpressionUUID->"8f510596-de49-4e45-aea9-671aee1ce0c5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[328030, 5825, 462, 13, 33, "Input",ExpressionUUID->"2b3629ba-7a7d-4b30-ad4f-c519cc21bdee"],
Cell[328495, 5840, 924, 26, 54, "Output",ExpressionUUID->"78bfb13b-1322-481f-9dd3-c2da271f711e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[329456, 5871, 293, 7, 30, "Input",ExpressionUUID->"c85e2114-2dd7-4979-b9c9-74499a6ffcdd"],
Cell[329752, 5880, 725, 19, 60, "Output",ExpressionUUID->"b8f379f7-bd0c-4b0c-b0bd-acd0a8040153"]
}, Open  ]],
Cell[CellGroupData[{
Cell[330514, 5904, 469, 12, 30, "Input",ExpressionUUID->"1bc0ff3e-3f4c-4f95-b4ae-7e22ddfb3ea7"],
Cell[330986, 5918, 26438, 452, 239, "Output",ExpressionUUID->"11401c0a-c320-43b2-8319-d1bfd1abcc09"]
}, Open  ]],
Cell[CellGroupData[{
Cell[357461, 6375, 268, 6, 30, "Input",ExpressionUUID->"73bdca26-c5e7-48cf-980c-f577dd11df36"],
Cell[357732, 6383, 956, 26, 46, "Output",ExpressionUUID->"4946c5a0-54f7-43d6-ac16-2160f2a79243"]
}, Open  ]],
Cell[CellGroupData[{
Cell[358725, 6414, 258, 6, 30, "Input",ExpressionUUID->"b4fe1bfe-0d69-4cce-8c63-50de14881d0a"],
Cell[358986, 6422, 323, 5, 34, "Output",ExpressionUUID->"c3464523-4400-4262-9853-396baa20918c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[359346, 6432, 412, 10, 30, "Input",ExpressionUUID->"b7eb0279-9d0f-489f-9c27-a3871d3ab572"],
Cell[359761, 6444, 366, 7, 74, "Output",ExpressionUUID->"eadf4e8f-6e3f-47d1-bb78-a353b5e2b127"]
}, Open  ]]
}, Open  ]]
}
]
*)

