(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    387210,       7337]
NotebookOptionsPosition[    381595,       7246]
NotebookOutlinePosition[    381992,       7262]
CellTagsIndexPosition[    381949,       7259]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Pendulum swing up & balance, with local linear feedback.
Test 3 ways to choose feedback gains  (Problem 7.19)\
\>", "Section",
 CellChangeTimes->{{3.698811497715045*^9, 3.698811509022469*^9}, {
  3.69885144307857*^9, 3.698851462312389*^9}, {3.709636905485622*^9, 
  3.709636910921179*^9}, {3.715342867107555*^9, 3.715342872342836*^9}, {
  3.7153432690028687`*^9, 3.715343287448956*^9}, {3.716532618830523*^9, 
  3.7165326217793283`*^9}, {3.716570684194786*^9, 3.716570736464383*^9}, {
  3.716613642404841*^9, 3.716613649251136*^9}, {3.7166173099843607`*^9, 
  3.716617315405965*^9}, {3.7167170388199997`*^9, 3.7167170401560717`*^9}, {
  3.716725771532446*^9, 3.716725778338876*^9}, {3.717221319267695*^9, 
  3.717221332903965*^9}, {3.793502782741811*^9, 
  3.793502806661611*^9}},ExpressionUUID->"c2f1811f-5d39-4870-bd7a-\
071084aa3a3d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ffCalc", "[", 
    RowBox[{"n_", ",", "\[Tau]_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "f", ",", "\[Theta]", ",", "\[Theta]dot", ",", "\[Lambda]", ",", 
       "\[Lambda]dot", ",", "t", ",", "\[CapitalDelta]t", ",", "bcs", ",", 
       "eqns", ",", "sv", ",", "froot", ",", "\[Theta]ff0", ",", 
       "\[Theta]dotff0", ",", "uff0", ",", "\[Theta]ff", ",", "\[Theta]dotff",
        ",", "uff"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalDelta]t", "=", 
       FractionBox["\[Tau]", "n"]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"{", 
         RowBox[{
         "\[Theta]_", ",", "\[Theta]dot_", ",", "\[Lambda]_", ",", 
          "\[Lambda]dot_"}], "}"}], "]"}], " ", ":=", " ", 
       RowBox[{"{", 
        RowBox[{"\[Theta]dot", ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "-", "\[Lambda]"}], ",", 
         "\[Lambda]dot", ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "\[Lambda]"}]}], "}"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"bcs", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[Theta]", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["\[Theta]dot", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["\[Theta]", "n"], "\[Equal]", "\[Pi]"}], ",", 
         RowBox[{
          SubscriptBox["\[Theta]dot", "n"], "\[Equal]", "0"}]}], "}"}]}], ";",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{"hard", " ", "final", " ", "constraint"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"eqns", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"bcs", ",", "\[IndentingNewLine]", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Thread", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                SubscriptBox["\[Theta]", "i"], ",", 
                SubscriptBox["\[Theta]dot", "i"], ",", 
                SubscriptBox["\[Lambda]", "i"], ",", 
                SubscriptBox["\[Lambda]dot", "i"]}], "}"}], "\[Equal]", " ", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 SubscriptBox["\[Theta]", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Theta]dot", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]dot", 
                  RowBox[{"i", "-", "1"}]]}], "}"}], "\[IndentingNewLine]", 
               "+", 
               RowBox[{
                FractionBox["\[CapitalDelta]t", 
                 RowBox[{"2", " "}]], 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"f", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["\[Theta]", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Theta]dot", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]dot", 
                    RowBox[{"i", "-", "1"}]]}], "}"}], "]"}], "+", 
                  RowBox[{"f", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["\[Theta]", "i"], ",", 
                    SubscriptBox["\[Theta]dot", "i"], ",", 
                    SubscriptBox["\[Lambda]", "i"], ",", 
                    SubscriptBox["\[Lambda]dot", "i"]}], "}"}], "]"}]}], 
                 ")"}]}]}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sv", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Theta]", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Theta]dot", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]dot", "i"], ",", "0"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "1"}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"initial", " ", "guesses"}], " ", "=", " ", "0"}], ",", " ", 
        
        RowBox[{"very", " ", 
         RowBox[{"naive", "!"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"froot", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{"eqns", ",", "sv"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Theta]ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["\[Theta]", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Theta]dotff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["\[Theta]dot", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"uff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"-", 
             SubscriptBox["\[Lambda]", "i"]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Theta]ff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Theta]ff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "\[Pi]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"\[Theta]dotff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Theta]dotff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"uff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"uff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"\[Theta]ff", ",", "\[Theta]dotff", ",", "uff"}], "}"}]}]}], 
    "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "500"}], ";", "  ", 
  RowBox[{"\[Tau]", "=", "5"}], ";", 
  RowBox[{"\[Tau]1", "=", 
   RowBox[{"3", "\[Tau]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]0", ",", "\[Theta]dot0", ",", "u0"}], "}"}], "=", 
   RowBox[{"ffCalc", "[", 
    RowBox[{"n", ",", "\[Tau]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p0", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]0", "[", "t", "]"}], ",", 
       RowBox[{"u0", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "4"}], "}"}]}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.716725835516573*^9, 3.716725835885325*^9}, {
   3.716726014532469*^9, 3.71672602766113*^9}, {3.716726231523755*^9, 
   3.7167262420957603`*^9}, {3.716726307201371*^9, 3.71672640862053*^9}, 
   3.716727073320963*^9, 3.7167365399686203`*^9},
 CellLabel->
  "In[3124]:=",ExpressionUUID->"6e42687c-bd84-429b-9901-9da7fec5d545"],

Cell["\<\
Test the approximate solution on the open-loop\[LineSeparator] dynamics \
(integrated at a fine time step)\
\>", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"291c1013-9723-4bbf-bdf6-0ec48ff3a54f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TestSwingUp", "[", 
    RowBox[{"\[Tau]1_", ",", "uff_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "eq", ",", "init", ",", "\[Theta]", ",", "\[Theta]dot", ",", 
       "\[Theta]s", ",", "\[Theta]dots", ",", "us", ",", "t"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"eq", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"\[Theta]", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Theta]dot", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Sin", "[", 
             RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}], "+", 
           RowBox[{"uff", "[", "t", "]"}]}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"init", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Theta]", "[", "0", "]"}], "\[Equal]", 
         RowBox[{"\[Theta]dot", "[", "0", "]"}], "\[Equal]", "0"}], "}"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]s", ",", "\[Theta]dots"}], "}"}], "=", 
       RowBox[{"NDSolveValue", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"eq", ",", "init"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "\[Theta]dot"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[Theta]s"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]1", "=", 
   RowBox[{"TestSwingUp", "[", 
    RowBox[{"\[Tau]1", ",", "u0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]1", "[", "t", "]"}], ",", 
       RowBox[{"u0", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.716726475850806*^9, 3.716726483729012*^9}, {
   3.716726540265172*^9, 3.71672655675944*^9}, {3.7167265922123337`*^9, 
   3.716726624099812*^9}, {3.716726827404985*^9, 3.71672683813792*^9}, 
   3.716727075758045*^9, {3.716736385196327*^9, 3.71673639877942*^9}},
 CellLabel->
  "In[3129]:=",ExpressionUUID->"03e0d4f6-e531-4b5f-ab2e-1a3e95fe7d1f"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.059809302964006`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3130, 237, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229446604166*^9},
 CellLabel->
  "During evaluation of \
In[3129]:=",ExpressionUUID->"0cce3e3e-f61c-484f-9c56-451cb5b79116"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.059809302964006`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3130, 238, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229446652267*^9},
 CellLabel->
  "During evaluation of \
In[3129]:=",ExpressionUUID->"6df43078-3e59-4cc4-aac3-8429fb4e5d38"]
}, Open  ]],

Cell["\<\
Show that linear feedback can stabilize against various perturbations.  Use \
LQR for balance state for everywhere.\
\>", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.716726797650621*^9, 3.716726800769066*^9}, {3.7172213459197063`*^9, 
  3.717221356055809*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"cef80cf4-d7d3-4045-a5b9-b38502d93e2f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TestSwingUpFB", "[", 
    RowBox[{
    "\[Tau]_", ",", "\[Tau]1_", ",", "d_", ",", "\[Theta]ff_", ",", 
     "\[Theta]dotff_", ",", "uff_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "eq", ",", "init", ",", "\[Theta]", ",", "\[Theta]dot", ",", "t", ",", 
       "\[Kappa]1", ",", "\[Kappa]2", ",", "ufb", ",", "u", ",", "\[Theta]s", 
       ",", "\[Theta]dots", ",", "us"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Kappa]1", "=", 
       RowBox[{"\[Kappa]2", "=", 
        RowBox[{
         SqrtBox["2"], "+", "1"}]}]}], ";", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"lqr", " ", "for", " ", "q"}], "=", 
        RowBox[{"r", " ", "for", " ", "balancing", " ", "pendulum"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ufb", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"\[Kappa]1", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
                RowBox[{"\[Theta]", "[", "t", "]"}]}], ")"}]}], "+", 
             RowBox[{"\[Kappa]2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
                RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ")"}]}]}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "12.99"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"u", "[", "t_", "]"}], ":=", 
       RowBox[{
        RowBox[{"uff", "[", "t", "]"}], "+", 
        RowBox[{"ufb", "[", "t", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"eq", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"\[Theta]", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Theta]dot", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Sin", "[", 
             RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}], "+", 
           RowBox[{"u", "[", "t", "]"}]}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"init", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Theta]", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"\[Theta]dot", "[", "0", "]"}], "\[Equal]", "d"}]}], 
        "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]s", ",", "\[Theta]dots"}], "}"}], "=", 
       RowBox[{"NDSolveValue", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"eq", ",", "init"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "\[Theta]dot"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"us", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"uff", "[", "t", "]"}], "+", 
             RowBox[{"\[Kappa]1", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
                RowBox[{"\[Theta]s", "[", "t", "]"}]}], ")"}]}], "+", 
             RowBox[{"\[Kappa]2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
                RowBox[{"\[Theta]dots", "[", "t", "]"}]}], ")"}]}]}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "12.99"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"\[Theta]s", ",", "us"}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", "0.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]2", ",", "u2"}], "}"}], "=", 
   RowBox[{"TestSwingUpFB", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "d", ",", "\[Theta]0", ",", "\[Theta]dot0",
      ",", "u0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]2", "[", "t", "]"}], ",", 
       RowBox[{"u2", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.716726812667987*^9, 3.716726883531363*^9}, {
   3.71672696136793*^9, 3.716727079150625*^9}, {3.7167271306788473`*^9, 
   3.7167271716690073`*^9}, 3.7167383122717752`*^9, {3.7167383517180233`*^9, 
   3.7167383524198914`*^9}, {3.716738394564283*^9, 3.716738407792145*^9}, {
   3.716738452123864*^9, 3.716738453915711*^9}, {3.716738489877406*^9, 
   3.7167385083938313`*^9}, {3.7167385651893682`*^9, 3.716738646187314*^9}, {
   3.716738708050569*^9, 3.716738756860454*^9}, {3.71673880160703*^9, 
   3.716738803694364*^9}, {3.716738839979808*^9, 3.7167388785547457`*^9}, 
   3.716738937718771*^9, {3.716738967881958*^9, 3.7167390202687263`*^9}, {
   3.716739074798856*^9, 3.716739090078024*^9}, {3.716739269912098*^9, 
   3.716739326035336*^9}, 3.716739360688181*^9, 3.717178550725272*^9, 
   3.717179758870756*^9, 3.717179794157363*^9, {3.7171799200719233`*^9, 
   3.7171799375311337`*^9}, 3.71722671021833*^9, {3.717226821989459*^9, 
   3.7172268485981207`*^9}, {3.717231321619536*^9, 3.717231333237545*^9}, {
   3.717231399024392*^9, 3.717231399384038*^9}},
 CellLabel->
  "In[3132]:=",ExpressionUUID->"9feaa965-6c5e-433b-9cc7-a1ba3b998866"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.021722506032414`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3134, 239, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229446702138*^9},
 CellLabel->
  "During evaluation of \
In[3132]:=",ExpressionUUID->"37ddb520-40a3-47b8-a890-27d6ad96512c"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.021722506032414`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3134, 240, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232294467070923`*^9},
 CellLabel->
  "During evaluation of \
In[3132]:=",ExpressionUUID->"3be97d66-660d-4455-9a37-9d26fe550369"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.021722506032414`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3134, 241, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229446710298*^9},
 CellLabel->
  "During evaluation of \
In[3132]:=",ExpressionUUID->"b8324f45-ce78-4dc3-8bb7-30446307f02a"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 3134, 242, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229446767147*^9},
 CellLabel->
  "During evaluation of \
In[3132]:=",ExpressionUUID->"6d5462be-6358-4f53-b73c-1ef741a1c373"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"p0", ",", "p1", ",", "p2"}], "}"}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.717179660721051*^9, 3.717179669399199*^9}},
 CellLabel->
  "In[3136]:=",ExpressionUUID->"c2be2ada-e7b4-4fc2-9efd-840145fc75af"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJzt2vk/VO//+HFZZ4SYERKVSEUolSg8rywpShKFLGWJylYUSVmKpKwJIVK2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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{419, 538, 536, 243, 244, 432, 385, 347, 319, 299, 
             287, 245, 433, 386, 348, 320, 300, 288, 442, 395, 357, 329, 309, 
             246, 434, 387, 349, 321, 455, 408, 370, 301, 449, 402, 474, 364, 
             466}}]]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwNz80vF2AAwPGf/goKm62Ek9RB3k55OZBliZwiBy8jDWNeyok4iGUZTVND
89rJ2wGN1WSsWhgr3MpbL/oL+hw++z57XvdEFD3IqTwXCASC6OEHISaC+Wd8
xl/+8JtfhNscQwoFtPCWU2thGk0yd3nMFCfWrmkGxXQwTyjZlNPNO6J4SC8f
SCKfR0xy7K56fckGOQzxlUp6WOEqI2xRwzf6+Ug6e7ziM/fZoZ05LnDAG7ap
5TsvWOMm+7zmC2Xs0sUSlxlmkyqe855EBvlEHs1McORPdTrAOreo4BnLxFFN
H6ukUcQTZjlPFqU8ZZFIErhDE+MceueKplJIGzOEkEkJnSxwievk0sgYP52P
1Rvco5VpgrlIPLdpYJT/i+RQxA==
             
             "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], 
            LineBox[{1, 182, 143, 221, 110, 214, 175, 225, 85, 207, 168, 223, 
             135, 219, 180, 65, 201, 162, 129, 216, 177, 104, 212, 173, 140, 
             51, 194, 155, 122, 97, 210, 171, 138, 77, 205, 166, 133, 108, 2, 
             183, 144, 111, 86, 208, 169, 136, 66, 202, 163, 130, 105, 52, 
             195, 156, 123, 98, 78, 3, 184, 145, 112, 87, 67, 53, 196, 157, 
             124, 99, 79, 4, 185, 146, 113, 88, 68, 54, 5, 186, 147, 114, 89, 
             69, 55, 6, 7, 8, 9, 10, 11, 187, 148, 115, 90, 70, 56, 12, 188, 
             149, 116, 91, 71, 57, 13, 189, 150, 117, 92, 72, 58, 197, 158, 
             125, 100, 80, 14, 190, 151, 118, 93, 73, 59, 198, 159, 126, 101, 
             81, 15, 191, 152, 119, 94, 74, 60, 199, 160, 127, 102, 82, 16, 
             192, 153, 120, 95, 75, 203, 164, 131, 106, 61, 200, 161, 128, 
             103, 211, 172, 139, 83, 206, 167, 134, 218, 179, 109, 213, 174, 
             142, 17, 193, 154, 121, 215, 176, 96, 209, 170, 224, 137, 220, 
             181, 226, 76, 204, 165, 222, 132, 217, 178}], 
            LineBox[{107, 141, 62, 84, 18, 63, 19, 20, 21, 22, 23, 24, 25, 26,
              27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 
             43, 44, 45, 46, 47, 48, 49, 64, 50}]},
           Annotation[#, "Charting`Private`Tag$1252520#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV0etPSHEYwPHDXxEpbKJUm9DmTptKW2U1d9oUtnJNMU3ktlXYSIwwVi6Z
ULKVy1aSuS5zi4nwjgjJpdc+Xnz23dnz/M7Z2W9kzobM9YOCIGjmExc9bGUe
kxhFCE2UspzZjOOz/TotZj6TiaCFA+SSyhCaKSObROLocf6SbmMBUxhNKwfJ
I42hXKecHJJ4yHEKGU87h1lHBh2cYgtffOeybmchT6lmKvc4Sj6dnGcMt6mg
i9U85wwfSOcxJ+lmM6+5wEdCucFe3rCCZ9TwnmQecYJ3bOIVtUzgLkf4fzEv
OUcmTzhNEV/90xUtYRHTuM8xNhJJG4dYw1yGcZN9rGQOE+n1rnrdwWKmE0UY
38wadCdLmMFYwvlu9oM+ftLPL0IGB8Fv/cNVe7tYykyiGc5fs0bdzTJmEcMI
brGfVaQQz4D9a7qHLBJ4QBUFxHKHSt6ylhec5R8NCWLx
             "]], 
            LineBox[{336, 459, 412, 374, 289, 443, 396, 358, 330, 310, 247, 
             435, 388, 350, 322, 302, 290, 248, 249, 250, 251, 252, 253, 254, 
             255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 
             268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 436, 389, 
             351, 323, 303, 291, 444, 397, 359, 331, 311, 452, 405, 367, 339, 
             462, 415, 377, 471, 424, 480, 279}]},
           Annotation[#, "Charting`Private`Tag$1252520#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{484, 534, 485, 486, 487, 488, 489, 490, 491, 492, 493, 
             494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 
             507, 508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 
             520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532, 
             535, 533}]},
           Annotation[#, "Charting`Private`Tag$1252520#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{228, 229, 227}], 
           LineBox[{482, 483, 481}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdm3k4ld8X9sl0zjE7Ms/zVEqFTHulZCylFEqKhMpQiYhCiELRYCpNRJQi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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{728, 48, 46, 552, 553, 741, 694, 656, 628, 608, 596, 
             554, 742, 695, 657, 629, 609, 597, 751, 704, 666, 638, 618, 555, 
             743, 696, 658, 630, 764, 717, 679, 610, 758, 711, 783, 673, 
             775}}]]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV0s8v13EcwPHPF5kfY1G3Cl8/cqu/pOTbqR+y2YhDCSf9OJTGKFyiOoTV
amWMkpNfh8qyLJZh0iQ6IYcwjaUeDo89X6/X+/oOF5VHrkYFQRDiAUcsJ/UE
uebj5JBNFpmcpZAqmunnJ2EiXKKSJt6yTAZl3OIxI6yTz106GGWLAl4wzi4V
NNLHEul0M0VUdBDU6Rxx5mc6xh9KmSfB/ZUe1And4yap9hk9oI80SYf1F2c4
bP+midqpKTqp/6jhkH1WY7Vdk/WDbnKRr8S7PddP7HCNaWLc7+sbfpBGF18I
eavVp3xkm8u85DN/ucFDhlgjjzu08Z4NLlDOPV6zyDFKuE4rg6xymts84R2/
Oc/+52igl+8cpZhqWhhghVOc4wr19LDAf6EoUtU=
             
             "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwl1WWUVmUUgNGhJKSkuzsMlO7ubqURkO5uKUmlu0G6uzsFpKW7uzvcd/Fj
zznP+31r4t47M8kbtK7UKlRISEjc0CEhwVzlQyVi6Tc6irlYxzP/1uHMOTqO
WcqMYa4wf/baZ3MaRYjmfKn5zHkk+wJ7ebLo82Y3knFER/D6PHtZftdh9Cx7
CV5pGbLaXpm39nl85XCuLs0vIV/eNN1elOfyRy7Yu5Ocf3W/4HOzRlfhnX0+
tfiJi856kIKjuj9hWaur8t6+gNpkDa4F65xX44N9IXXIFnx/hA9+NiIG14Cv
We+91floX0RdshOZDc5r8Mm+mHrkCO4BG53X5LN9CfXJySVnPUnJMT2AqGwK
7klwQ1lqNCAXl3UvUnFcDyQam4PrSCiW6Ybk5oruTWpO6EFEZ4uuRWiW61+D
L+UezNDFeKHzcNXehzScDK6F98y3l+OP4Prq2faSfGNfbr4Orod9kb1icK63
mrUJQ1SvLTFXBNc4eC5DfXl+y5gxzZVmArNR8FiYM3Vss7gZ3VxmxjdfBvfE
XKgrkFdfM/uSllN6MDHYpusQlpW6Mfm4HjyzpOO0HkJMtuu6hGOVbkJ+buh+
pOc/PZRY7ND1+IrV+jcKcFP3JwNn9DBis1PXJzxrdFMKcksPICNn9XDisEs3
IAJrdTMKcVsPJBPn9IjgbwG7dUMisk43pzB39CAyc17/STz26F+JxHrdgiLc
De4z33JB/0V89upGfM0G3ZKi3NOD+Y6LeiQJ2KcbE5mNuhXFuK+H8D2X9CgS
sl83IQqbdGuK80AP5Qcu69Ek4oD+LXi22KzbUIKHehhZuKLHkJiDuinR2KLb
UpJHejg/clWPJQn/6GbB88dW3Y5SPNYj+IlrehxJOaSbB88+23R7SvNE/0lW
ruvxJOOwbkEMtusOlOGp/ots3NATSM4R3TL4fWGH7khZnumRZOemnkgK/tXB
P4pY7NSdKMdzPYoc3NKTSMlR3Tr4vWOX7kx5XujR5OS2nkwqjuk2xGG37kIF
Xuox5OKOnkJqjuu2xGWP7kpFXumx5OaunkoaTuh2xGOv7kYlXutx5OGenkZa
Tur2xGef7k5l3ujx5OW+nk46TukOJGC/7kEV3uoJ5OOBnkF6TuuOJOSA7klV
3umJ5OehnkkG/tOdSMRB3YtqvNeTKMAjPYuMnNGdScw/ujfV+aAnU5DHejaZ
OKu7kIRDug81+KinUIgneg6ZOae7kpTDui81+aSnUpinem7wXPmn+z+/LgMD

             "]]},
           Annotation[#, "Charting`Private`Tag$1252611#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwN0ulPyHEcwPFfhxKj0LNcUbk2/4lS8iAU2qJsSsjm3DpWU47YKtrcozTN
WWyuthyZcxq5FiK2hM3ZEno9eO39/Xy+z777xmcXpOWHBEHQSlxoEHRzmu2s
JoN59HGZGjaSw0Rec4ZK8lnEN9o5QDHJfOIKtWxiBZN4w1mqKGAx37nBQUpI
oZ+r1LGZvzygkZX8poOjlBMSFgSP9RSTecs5dhDu7omuYZC7HCfK/oUu4Qc3
GWt3SCO0Sydoqf7nEePMTTpaX2msztfPXGOMeZ+O0Kc6XrfoPx4SYz6po/Sl
5jLAHY4x0v65VhDq3KnNTKGH8+ykkD/c4wSZ/OQWhykjlS9cZz9byWMq77jA
LtaSRRrxvKeF3axjKQuYxnQSSCSJGcz1l2bqLHpppZr1LCOd2XzgInsoYjkL
+Uob9WxjFXP4yCX2soEh7tNANr+4TbR3OqKR+kyHATx8ZlY=
             "]], 
            LineBox[{645, 768, 721, 683, 598, 752, 705, 667, 639, 619, 556, 
             744, 697, 659, 631, 611, 599, 557, 558, 559, 560, 561, 562, 563, 
             564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574, 575, 576, 
             577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 745, 698, 
             660, 632, 612, 600, 753, 706, 668, 640, 620, 761, 714, 676, 648, 
             771, 724, 686, 780, 733, 789, 588}]},
           Annotation[#, "Charting`Private`Tag$1252611#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{793, 843, 794, 795, 796, 797, 798, 799, 800, 801, 802, 
             803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814, 815, 
             816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 826, 827, 828, 
             829, 830, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 
             844, 842}]},
           Annotation[#, "Charting`Private`Tag$1252611#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
           LineBox[{791, 792, 790}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlunk4Vfv7gL1Dhso8z/M8FhFqfZ5QiUKiUCGlVFJKUUqbkEpFyVRKRWlS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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{765, 970, 520, 1148, 680, 608, 570, 1008, 900, 803, 
              718, 646, 521, 971, 863, 766, 681}}], 
             PolygonBox[{{962, 1149, 862, 533, 534, 977, 869, 772, 687, 615, 
              577, 535, 978, 870, 773, 688, 616, 578, 1014, 906, 809, 724, 
              652, 536, 979, 871, 774, 689, 1057, 949, 852, 617, 1046, 938, 
              1080, 841, 1070}}]}]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwV0VkrpmEABuDXcmRfT4YysofCiOxOLCcoiikSn+WQX2EvP8O+TFEoQtkO
zNj+iLWMEtd3cHXf9/M8J+/3ZYcmuycigyCIYJFPYzAqCNJkKikkk0QizYyz
RZR3o9ySYC/wQKE9xxtN9gvt+irp0UEwZm8SaY9wQ7w9II8o8ubD7tL/kGnP
2xd6hd4n98nV752f6CV6gaySs/KVRneN9qX+S/6WtfJA5sln9/Xy1C6VbbJa
roS/X466b5DndrnskTVyV/6UG+6P9WI9Qob4R5zzK1npvF8eUqj/d36ml+md
cpsMfc55r75Hjn1n5+szvNBgP9GqL5PqzYjdre+QZa+H/0R9mL/E2u906Fv8
CP8u9i159jTP1NuPtOhLpHgXstf4YsjZNTH6DDfk2lM8UWcP8w2bPEJs
              "]], 
             PolygonBox[CompressedData["
1:eJwV1EVYVVEUgNGH2KLYiNgtomJ3dyuKPXKkGIithDW0O8EeqQNbsbumKgp2
Ys1srHUHi3P+zf744L13qT0pOWFGoVAoFEaCL19ERuFQaDHjw0OhTs6zzobO
77531b25+2DnYaLdl5snup+kjr6ra7kv5TMt9QE+01PvI9LeRL2MO9Q0W8In
WugJLOU2NcwW85F4XcBw9yNU93P260/00HspE/zu+huD9CGqmC3Rt6iuM/gQ
/C16Hx/prvdQ2u44/ZWB+iBRwWuib1JNp/OeZnovH+imdxNhd2zwOnKDGLM0
8mmq9/CernoXpeyP0elcp6pZKu+I07vJp4vOoqT90TqNa0SbLeItTfQu3tFZ
Z1LCfqJODd4/qpgt5A2xOou3dNI7KW5/lF7EFaLMFvCaxjqTN3TUOyhmf6Re
yGUqm83nFY30Tl7TQW+nqP0EvYBLVDKbx8vgc6Z38Ir2ehtF7I/Q87lIRbO5
vKCB3s5L2umtFLY/XM/jAhXM5vCc+nobL2irtxBuf5iey3nKm83mGfX0Vp7T
Rm+mkP2heg7nKGc2i6fU1Vt4Rmu9iTD7Q/RszlLWLIUnwfOiN/OUVnojoeD5
0rPIJtJsJo+prTfxhJZ6A/8YpFM4QxmdTB619EYe00Kv5y8D9UxOU1rPIJea
egN5xOt1/GGATuYUEXo6j6ih15NLc72W3/TXwT+Wk5TS03gYPK96HY9optdQ
QD89nROU1FPJoZpey0Oa6tX8oq+exnFK6CQeEKPXkEOcXsVP+uipHKO4nsJ9
qurVPKCJXskPeuskjlJMT+Ye0XoV94nVK/hOLz3OmR18Jr1//wGh/KZ+
              
              "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwl1WWUVVUYgOGhO6S7Q1KlS+lOQQWku7u7pEu6GyUUaenu7u7u7vY5yx/P
fPvd59y5s/aZu27K+m0qtw4VEhISMXRISDBX+FGLCCzXdcjOOT2QbFzSw/GS
kJW6NhFZoeuSgzCssleHSKzU9cjJeT2I7FzWIwjLal2XyKzS9clFOP61V48o
rNYNyE14IgR/P5GITBTWuK8+UflXNyQPUVlrrwHRWKMbkZdorLPXkOis1Y3J
xwU9mBxc0SOJznrdiBis003Iz0U9hJxc1aOIwQbdmJis100pwCU9lFxc06OJ
yUbdhK/YoJvxznoBvxCG7+1dNoeRm+v6k/kXv/K7/mAuohqhPbhlZji+sISa
wXu4b5PZlFih/n/A/5gbLT+ai4PX2KsevK+5PPg/MZu7/t56IWF1VTOUudQM
b4Y1P/M3NfjB/VfM4eThhh5DLDbrZsRmk25BQWKzxV5z4rBZt6QQV/UI8nJT
jyUOW3UL4rJFt6Iw1/RI8nFLjyMu23RL4rFVt6YI1/Uo8nNbjyce23Ur4rNN
t6EoN/RoCnBHTyA+O3TwYUvAdt2WYtwMnlHwHLmrJ5KAnboNCdmh21GcW3pM
cI7c05NIyC7dlkTs1O0pwW09loLc15NJxG7djsTs0h0oyR09jkI80FNIzB7d
niTs1h0pxV09nsI81FNJwl7dgaTs0Z0ozT09gSI80tNIyj7dkWTs1Z0pw309
kaI81tNJxn7dieTs010oywM9iWI80TNIzgHdmRTs110px0M9meI81TNJwUHd
hZQc0N0ozyM9hRI807NIySHdlVQc1N2pwGM9lZI817NJxWHdjdQc0j2oyBM9
jVK80HNIzRHdnTQc1j2pxFM9ndK81HNJw1Hdg7Qc0b34kWd6BmV4peeRlmO6
J+k4qntTmed6JmV5reeTjuO6F+k5pvtQhRd6FuV4o/8gPSd0b77muO7LT7zU
synPW/0nX3NS9yEDJ3Q/fuaVnkMF3ukFZOCU7ktGTur+/MJrPZeKvNcLychp
3Y9MnNIDqMobPY9KfNCLyMQZ3Z/MnNa/UdgXVzXzrb35/MhHvZjMnNUDyMIZ
PZDqwZnoynyy/osswe/TWTlrPYhfg7PQVfhs/TdZ+UafMwdTIzhD/cVcElzj
W33eHELN4Mx08OX+T3CN76wvmEOpFVzSS4N9LjKM2oS2v8wMb2Yz/wNvhQI+

             "]]},
           Annotation[#, "Charting`Private`Tag$1252729#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV0dlKVVEABuDlUKBlg2lFCilqKVY0UWlqKjR4kcIpSlBMTw51ky/gZakN
z2HOAxYVJJY0CJbzgzhUpNDw7YuP///XXnDY++TGO2OPEkII03Qlh9CfGEIz
pawlhfCYPObtblKYs+/xVx/gDy1cZt35E/JZsHtI5ZvdzD99kDjpfq/P2VXW
7DI29G4KWLR7OeLeqH2T3/YuvustBIbso+5M6jHu2wfsl/o11u1yNvUejrFk
57nzRr/DUzvLHtNrOa1/klvOC/X3egPn9Vm52/m8jJNAsfNpOew8R3+ll8hb
8oz8LMtlq+cZ0Xe2L8rr8qT8KMvkhucF8p1dKuvlOflVVsgKz3/ovVywj8sT
8oNc9ixff6vf5az+RT5znq2P63Vs20X2lN5Imr0QfTcSGbHbyHRnwL7Bpn2F
n9G3opAV+zl7WLRbSWLUbqeSvexjf/R/R/9L9P40uZcpD7Kkt5HMmN1BFYdY
dtbODsbtB1TzK3ovili1X3CYFbuDnUzYud7htX6bh9Hv2YP6JVkjT8kZ+R+c
Y1jg
             "]], LineBox[CompressedData["
1:eJwV1EVYVGEUgOFri4WtKAh2gN3dXdi5cmWCBXYvTQxARDBX6sLubt3aAbaI
uLP7ncU7//+d5zyzuXem9pTEkQmFgiCI9/G5cBA0KBoEZ4oEwQR662/OtTTh
vl5PBPf0VEpwRE+nD9/1OmJ5oDdQg/t6GiU5qmfQlx96PXE81BupyQM9nTCO
6Zn046feQFMe6U1E8lDPoBTH9Sz680tvpBmPdQpRPNIzKc0JncAAfutNNOeJ
3kwtHutZlOGkTmQgf3QKLXiqtxDNE51AWU7p2Qzir95MS57prcTwVCdSjtN6
DoP5p7fQiud6G7V5pmcTzhk9lyEEnt9Ws9bk6FTq8FzPoTxn9TyGUsj+NrM2
5Oo06pKj51KBc3o+wyhsP9WsLS90OvXI1fOoyHmdxHCK2E8za8dLvZ36vNDz
qcQFnUw8Re2nm7Xnlc4IvZO81ElU5qJewAiK2d9u1oHXegcNeaWTqcIlvZCR
FLefYdaRNzqTRrzWC6jKZb2IUZSwv8OsE2/1ThrzRi+kGlf0YkZT0n6mWWfe
6Sya8FYvojpX9RLGEGZ/p1kX3utsYnmnFxPBNb2UsZSyn2XWlTy9izje6yXU
4LpexjhK288268YHvZum5Oml1OSGXs54ytjfZdadfL2HZnzQy4jkpl5BNbsH
9CC+6AmUNdute/BR76U5+Xo5UdzSK6lu96AezFc9kXJme3RPCvS+0O/V7LCO
55duwUf3FdTitl7FJFpSYLaSaO7o1Uwm3PfsNevFJ72fVnzSq4jhbuj3Yu+E
+xjW6Ah9yH1I6H/B/arzW+g9cz8betbOic7/jlOldQ==
             "]], 
            LineBox[{1087, 605, 1040, 932, 835, 750, 678, 563, 1006, 898, 801,
              716, 644, 606, 564, 565, 566, 567, 568, 1007, 899, 802, 717, 
             645, 607, 1041, 933, 836, 751, 679, 1054, 946, 849, 764, 1066, 
             958, 861, 1077, 969, 1088, 569}]},
           Annotation[#, "Charting`Private`Tag$1252729#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{1096, 1146, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 
             1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114,
              1115, 1116, 1117, 1118, 1119, 1120, 1121, 1122, 1123, 1124, 
             1125, 1126, 1127, 1128, 1129, 1130, 1131, 1132, 1133, 1134, 1135,
              1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1147, 
             1145}]},
           Annotation[#, "Charting`Private`Tag$1252729#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{1091, 1095, 1090}], 
           LineBox[{1093, 1094, 1092}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{4}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.717179662001368*^9, 3.717179669885983*^9}, 
   3.717179711404866*^9, {3.717179743012516*^9, 3.717179763159971*^9}, 
   3.717179798933648*^9, 3.7171810436264067`*^9, 3.717181087908266*^9, 
   3.71721229774891*^9, 3.717224324487462*^9, 3.71722435834477*^9, 
   3.717225057026936*^9, 3.7172251140119457`*^9, 3.7172253831205807`*^9, 
   3.717225718208309*^9, 3.717226047903894*^9, 3.717226713535191*^9, 
   3.7172268765442467`*^9, 3.717231289494946*^9, 3.717231350066669*^9, 
   3.717231421079175*^9, 3.7172350349233713`*^9, 3.738609753348216*^9, 
   3.793502842580624*^9, 3.7935040475964737`*^9, 3.793904844360237*^9, 
   3.823229446831623*^9},
 CellLabel->
  "Out[3136]=",ExpressionUUID->"d562a01b-d6ce-4946-9e3d-64348144cf00"]
}, Open  ]],

Cell["Linear feedback:  Quasistationary approximation (Q=R=1)", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.716726797650621*^9, 3.716726800769066*^9}, {3.71717868879108*^9, 
  3.717178722021283*^9}, {3.717222554881587*^9, 3.7172225567778807`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"b346cb89-2ad2-41d6-a092-befc09aae36c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "1"},
      {
       RowBox[{"-", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "0"}
     }], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0"},
      {"1"}
     }], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"s", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"s11", "s12"},
      {"s12", "s22"}
     }], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"q", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"Q", "0"},
      {"0", "Q"}
     }], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"r", "=", 
   RowBox[{"{", 
    RowBox[{"{", "R", "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ric", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "\[Transpose]"}], ".", "s"}], "+", 
    RowBox[{"s", ".", "a"}], "-", 
    RowBox[{"s", ".", "b", ".", 
     RowBox[{"Inverse", "[", "r", "]"}], ".", 
     RowBox[{"b", "\[Transpose]"}], ".", "s"}], "+", "q"}]}], ";", 
  RowBox[{"MatrixForm", "[", "ric", "]"}]}]}], "Input",
 CellChangeTimes->{{3.7171788964540787`*^9, 3.7171789008709507`*^9}},
 CellLabel->
  "In[3137]:=",ExpressionUUID->"d092d732-dee0-474b-a760-f9e210498dce"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"Q", "-", 
       FractionBox[
        SuperscriptBox["s12", "2"], "R"], "-", 
       RowBox[{"2", " ", "s12", " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], 
      RowBox[{"s11", "-", 
       FractionBox[
        RowBox[{"s12", " ", "s22"}], "R"], "-", 
       RowBox[{"s22", " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}]},
     {
      RowBox[{"s11", "-", 
       FractionBox[
        RowBox[{"s12", " ", "s22"}], "R"], "-", 
       RowBox[{"s22", " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], 
      RowBox[{"Q", "+", 
       RowBox[{"2", " ", "s12"}], "-", 
       FractionBox[
        SuperscriptBox["s22", "2"], "R"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.717178904945633*^9, 3.7171797114949417`*^9, {3.717179743112667*^9, 
   3.717179763265003*^9}, 3.7171810437304497`*^9, 3.7171810880210323`*^9, 
   3.717212297855709*^9, 3.717224324612315*^9, 3.7172243584685793`*^9, 
   3.717225057148975*^9, 3.717225114143673*^9, 3.717225383254302*^9, 
   3.717225718344301*^9, 3.7172260480335493`*^9, 3.7172267137106247`*^9, 
   3.717226876688633*^9, 3.7172312897284*^9, 3.7172313502033567`*^9, 
   3.717231421166551*^9, 3.717235035020108*^9, 3.738609753470704*^9, 
   3.793502842597746*^9, 3.793504047610132*^9, 3.7939048443752413`*^9, 
   3.823229446844965*^9},
 CellLabel->
  "Out[3138]//MatrixForm=",ExpressionUUID->"b8aa1273-e148-461d-8bdd-\
45a4b796cf4c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"r11", "=", 
   RowBox[{
    RowBox[{"ric", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1"}], "]"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Q", "\[Rule]", "1"}], ",", 
      RowBox[{"R", "\[Rule]", "1"}]}], "}"}]}]}], ";", 
  RowBox[{"r12", "=", 
   RowBox[{
    RowBox[{"ric", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Q", "\[Rule]", "1"}], ",", 
      RowBox[{"R", "\[Rule]", "1"}]}], "}"}]}]}], ";", 
  RowBox[{"r22", "=", 
   RowBox[{
    RowBox[{"ric", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "2"}], "]"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Q", "\[Rule]", "1"}], ",", 
      RowBox[{"R", "\[Rule]", "1"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r11", "\[Equal]", "0"}], ",", 
       RowBox[{"r12", "\[Equal]", "0"}], ",", 
       RowBox[{"r22", "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"s12", ",", "s22", ",", "s11"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "4", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.7172118246547213`*^9, 3.717222533109516*^9, {3.717222575050982*^9, 
   3.717222650879713*^9}, {3.717222695577505*^9, 3.7172227002313957`*^9}, {
   3.717223661534431*^9, 3.7172237021112022`*^9}, {3.7172237334555893`*^9, 
   3.717223734317487*^9}, {3.738609760781158*^9, 3.73860976364935*^9}},
 CellLabel->
  "In[3139]:=",ExpressionUUID->"d1ba565f-25de-46fa-a69d-fa7793e703ec"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"s12", "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]]}]}], ",", 
   RowBox[{"s22", "\[Rule]", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]]}]}]]}], ",", 
   RowBox[{"s11", "\[Rule]", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]], " ", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"1", "+", 
          SuperscriptBox[
           RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]]}]}]]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.717222533739141*^9, 3.717222578334928*^9, {3.717222612696575*^9, 
   3.717222651422372*^9}, 3.717222700694817*^9, 3.71722370369394*^9, {
   3.717223734829414*^9, 3.717223742857461*^9}, 3.717224324728549*^9, 
   3.717224358566234*^9, 3.7172250572667007`*^9, 3.717225114260357*^9, 
   3.717225383372221*^9, 3.717225718478265*^9, 3.717226048167101*^9, 
   3.717226713832931*^9, 3.717226876821093*^9, 3.717231289936194*^9, 
   3.717231350337583*^9, 3.717231421253091*^9, 3.717235035102578*^9, {
   3.738609753582808*^9, 3.7386097673886833`*^9}, 3.79350284263556*^9, 
   3.793504047647773*^9, 3.7939048444220943`*^9, 3.823229446891245*^9},
 CellLabel->
  "Out[3140]=",ExpressionUUID->"42b273cd-9319-41df-b4f2-143622e04792"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"\[Kappa]1a", ",", "\[Kappa]2a"}], "}"}], "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s12", ",", "s22"}], "}"}], "/.", "sol"}]}]], "Input",
 CellChangeTimes->{{3.717179288001001*^9, 3.717179317705001*^9}, {
   3.717179348845187*^9, 3.7171794626422567`*^9}, {3.7172118530466127`*^9, 
   3.717211888197872*^9}, {3.717222664377265*^9, 3.717222702407914*^9}, 
   3.717223739607169*^9},
 CellLabel->
  "In[3141]:=",ExpressionUUID->"2fcb23c4-2498-46fe-ab81-b6f2873be3eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]]}], ",", 
   SqrtBox[
    RowBox[{"1", "-", 
     RowBox[{"2", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]]}]}]]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.717179301572695*^9, 3.71717931845965*^9}, {
   3.717179355949151*^9, 3.7171793739424887`*^9}, {3.7171794075572243`*^9, 
   3.717179432848517*^9}, 3.717179463744042*^9, 3.71717971185148*^9, {
   3.71717974348453*^9, 3.717179763748829*^9}, 3.717181044099288*^9, 
   3.717181088384487*^9, {3.717211837950832*^9, 3.717211889692996*^9}, 
   3.7172122981421947`*^9, {3.7172226748294086`*^9, 3.717222709831543*^9}, {
   3.717223740123571*^9, 3.7172237445160847`*^9}, 3.717224324845587*^9, 
   3.717224358667638*^9, 3.717225057383956*^9, 3.7172251143933687`*^9, 
   3.7172253834885273`*^9, 3.717225718627243*^9, 3.717226048299127*^9, 
   3.7172267139495583`*^9, 3.717226876954525*^9, 3.717231290158572*^9, 
   3.717231350470663*^9, 3.717231421316781*^9, 3.71723503520306*^9, 
   3.7386097537023478`*^9, 3.793502842642775*^9, 3.793504047654912*^9, 
   3.793904844427849*^9, 3.8232294468964443`*^9},
 CellLabel->
  "Out[3141]=",ExpressionUUID->"4d53edac-da16-4529-9e7d-bac40bca0e2e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Kappa]1a", ",", "\[Kappa]2a", ",", 
          RowBox[{
           SqrtBox["2"], "+", "1"}], ",", 
          RowBox[{
           SqrtBox["2"], "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2.5"}], "}"}]}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{",", ",", 
           RowBox[{"Directive", "[", 
            RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}], ",", 
           RowBox[{"Directive", "[", 
            RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Kappa]1a", "/.", 
           RowBox[{"\[Theta]", "\[Rule]", 
            RowBox[{"\[Theta]0", "[", "t", "]"}]}]}], ",", 
          RowBox[{"\[Kappa]2a", "/.", 
           RowBox[{"\[Theta]", "\[Rule]", 
            RowBox[{"\[Theta]0", "[", "t", "]"}]}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}]}], "]"}]}], "}"}], 
    "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.717178962481121*^9, 3.717179085416415*^9}, 
   3.717179467747013*^9, {3.717211893638874*^9, 3.717211896710474*^9}, {
   3.7172119636711082`*^9, 3.717211970933936*^9}, {3.71722448833496*^9, 
   3.71722453085445*^9}, 3.717224629139132*^9},
 CellLabel->
  "In[3142]:=",ExpressionUUID->"2688b364-c339-4045-9531-9610abd9cafd"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1Hk0lVsbAHDOq3Peo3Q1UHJDpGSohJBTz5OEUqGimyGiQbopQ8YTKTIm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           "]]},
         Annotation[#, "Charting`Private`Tag$1252803#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1HlUjdsbB/A6L+e8R/iJikqDSjcNQkWj52kg1UWDJEqJBrmaUPdySKK6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           "]]},
         Annotation[#, "Charting`Private`Tag$1252803#2"]& ], 
        TagBox[
         {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQzbyf69xj00K7Z3Ptjf0DmB2CciRvzZg03x7Gn/gp
ZvO0SevhfOujXlxOxQfg/IIqv8TNBSfg/NwdqX1Myhfg/CsvPDmXJ12B87v0
vzFsi7wB5xdqn5h6YOkdOP9Xcva6u3kP4PykvWEBE9IewfnJH68cONDxBM7v
Mdiev6ztGZzPdGC7eUvVCzhfUMv73P0Zr+B8j/lOiz9MegPni78/41a//R2c
P+v4LkbmzA9wvo2s43+FlI9wvvYDgSe1JZ/g/LUrhDK2Fn2G82vuxV7WbvuC
8J+Nhfe8KV8R/pvvkvR6wjc4/0LBrITyRd/hfEt3pX93F/6A80+6Wq5wmPMT
zl+6cablo9W/4HxRZZ2suJW/4fxLjBxNknv+wPlbOYqXXTj5F87XERXISjr6
D85/3/dNxPjafzhfub1dPz+LwQHGfxR1+5bTcwTf4+nln1vzGOH8iqLUDLG3
CL7fttleYmVMcP67P1k1zN8Q/IXXG7fkFTPD+b8ybBMqfyP4sn8nRhdWscD5
z9y7T3GwsML5h9XO2Mt1I/hZHMtYFDnZ4PztC1RsD09E8M9Z2xwNEmSH839k
zQ5O6EPwTwTMD+UV44Dzkyxtli+fguB77SqqDLyN4Btar/T+rcgJ5wMAkd1Y
JQ==
           "]]},
         Annotation[#, "Charting`Private`Tag$1252803#3"]& ], 
        TagBox[
         {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQzbyf69xj00I7k/d/ZlY23bIPypG8NWPSfHsYf+Kn
mM3TJq2H862PenE5FR+A8wuq/BI3F5yA83N3pPYxKV+A86+88ORcnnQFzu/S
/8awLfIGnF+ofWLqgaV34Pxfydnr7uY9gPOT9oYFTEh7BOcnf7xy4EDHEzi/
x2B7/rK2Z3A+04Ht5i1VL+B8QS3vc/dnvILzPeY7Lf4w6Q2cL/7+jFv99ndw
/qzjuxiZMz/A+Tayjv8VUj7C+doPBJ7UlnyC89euEMrYWvQZzq+5F3tZu+0L
wn82Ft7zpnxF+G++S9LrCd/g/AsFsxLKF32H8y3dlf7dXfgDzj/parnCYc5P
OH/pxpmWj1b/gvNFlXWy4lb+hvMvMXI0Se75A+dv5SheduHkXzhfR1QgK+no
Pzj/fd83EeNr/+F85fZ2/fwsBgcY/1HU7VtOzxF8j6eXf27NY4TzK4pSM8Te
Ivh+22Z7iZUxwfnv/mTVMH9D8Bdeb9ySV8wM5//KsE2o/I3gy/6dGF1YxQLn
P3PvPsXBwgrnH1Y7Yy/XjeBncSxjUeRkg/O3L1CxPTwRwT9nbXM0SJAdzv+R
NTs4oQ/BPxEwP5RXjAPOT7K0Wb58CoLvtauoMvA2gm9ovdL7tyInnA8ABN29
6Q==
           "]]},
         Annotation[#, "Charting`Private`Tag$1252803#4"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 3.1415925894756573`}, {0, 2.5}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwd1nc8Vf8fB3DuLQ3r3nuayoiikKRo4f2xyooSKqFSGRXRFKJsRUl9hTJD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           "]]},
         Annotation[#, "Charting`Private`Tag$1252854#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwd13k8lF8XAHBm2mSbmQfRYomyFS0qlTpXtlAUUckSyVJRKSWUigpRisqS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           "]]},
         Annotation[#, "Charting`Private`Tag$1252854#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0.41421356237309515`},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{4}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.717179033851159*^9, {3.7171790652756844`*^9, 3.717179085960745*^9}, 
   3.7171794752563868`*^9, 3.717179711962817*^9, {3.717179743615103*^9, 
   3.7171797638737707`*^9}, 3.717181044219812*^9, 3.7171810885010147`*^9, 
   3.7172118977463818`*^9, {3.717211965426773*^9, 3.7172119714065447`*^9}, 
   3.7172122982632008`*^9, 3.717224324973205*^9, 3.717224358784422*^9, {
   3.7172245042699413`*^9, 3.71722453183823*^9}, 3.717224630142774*^9, 
   3.717225057574504*^9, 3.71722511459408*^9, 3.717225383689946*^9, 
   3.717225718829658*^9, 3.717226048507535*^9, 3.717226714142476*^9, 
   3.717226877162706*^9, 3.717231290641699*^9, 3.717231350675565*^9, 
   3.717231421482024*^9, 3.717235035375712*^9, 3.738609753919271*^9, 
   3.793502842736746*^9, 3.793504047783485*^9, 3.793904844533474*^9, 
   3.823229446987715*^9},
 CellLabel->
  "Out[3142]=",ExpressionUUID->"c38af4e5-881e-4025-87da-7b4309b96e8f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"TestSwingUpFBqs", "[", 
   RowBox[{
   "\[Tau]_", ",", "\[Tau]1_", ",", "d_", ",", "\[Theta]ff_", ",", 
    "\[Theta]dotff_", ",", "uff_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "eq", ",", "init", ",", "\[Theta]", ",", "\[Theta]dot", ",", "t", ",", 
      "ufb", ",", "u", ",", "\[Kappa]1", ",", "\[Kappa]2", ",", "\[Theta]s", 
      ",", "\[Theta]dots", ",", "us", ",", "ufbs"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Kappa]1", "[", "t_", "]"}], ":=", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
        SqrtBox[
         RowBox[{"1", "+", 
          SuperscriptBox[
           RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]]}], "/.", 
       RowBox[{"\[Theta]", "\[Rule]", 
        RowBox[{"\[Theta]ff", "[", "t", "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Kappa]2", "[", "t_", "]"}], ":=", 
      RowBox[{
       SqrtBox[
        RowBox[{"1", "-", 
         RowBox[{"2", " ", 
          RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"1", "+", 
            SuperscriptBox[
             RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]]}]}]], "/.", 
       RowBox[{"\[Theta]", "\[Rule]", 
        RowBox[{"\[Theta]ff", "[", "t", "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ufb", "[", "t_", "]"}], ":=", 
      RowBox[{"Piecewise", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"\[Kappa]1", "[", "t", "]"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
               RowBox[{"\[Theta]", "[", "t", "]"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"\[Kappa]2", "[", "t", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
               RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ")"}]}]}], ",", 
           RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "12.99"}]}], 
          "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"u", "[", "t_", "]"}], ":=", 
      RowBox[{
       RowBox[{"uff", "[", "t", "]"}], "+", 
       RowBox[{"ufb", "[", "t", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"eq", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"\[Theta]", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Theta]dot", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sin", "[", 
            RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}], "+", 
          RowBox[{"u", "[", "t", "]"}]}]}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"init", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Theta]", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"\[Theta]dot", "[", "0", "]"}], "\[Equal]", "d"}]}], "}"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Theta]s", ",", "\[Theta]dots"}], "}"}], "=", 
      RowBox[{"NDSolveValue", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"eq", ",", "init"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", "\[Theta]dot"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ufbs", "[", "t_", "]"}], ":=", 
      RowBox[{"Piecewise", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"\[Kappa]1", "[", "t", "]"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
               RowBox[{"\[Theta]s", "[", "t", "]"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"\[Kappa]2", "[", "t", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
               RowBox[{"\[Theta]dots", "[", "t", "]"}]}], ")"}]}]}], ",", 
           RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "12.99"}]}], 
          "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"us", "[", "t_", "]"}], ":=", 
      RowBox[{
       RowBox[{"uff", "[", "t", "]"}], "+", 
       RowBox[{"ufbs", "[", "t", "]"}]}]}], ";", 
     RowBox[{"{", 
      RowBox[{"\[Theta]s", ",", "us"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", "0.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]3", ",", "u3"}], "}"}], "=", 
   RowBox[{"TestSwingUpFBqs", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "d", ",", "\[Theta]0", ",", "\[Theta]dot0",
      ",", "u0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]3", "[", "t", "]"}], ",", 
       RowBox[{"u3", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p4", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Theta]3", "[", "t", "]"}], "-", 
        RowBox[{"\[Theta]2", "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{"u3", "[", "t", "]"}], "-", 
        RowBox[{"u2", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"p2", ",", "p3", ",", "p4"}], "}"}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "4"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.717178735137196*^9, 3.717178756368307*^9}, {
   3.717178796496066*^9, 3.717178797927217*^9}, {3.717179517275275*^9, 
   3.717179521923316*^9}, {3.717179587413188*^9, 3.71717960532754*^9}, {
   3.717179728690877*^9, 3.717179729034823*^9}, {3.717179950523847*^9, 
   3.7171799623151197`*^9}, {3.7171800327038403`*^9, 3.717180118309691*^9}, {
   3.7171801628847847`*^9, 3.717180208403758*^9}, {3.717180302095316*^9, 
   3.7171803157485247`*^9}, {3.7171803471933317`*^9, 3.717180364070889*^9}, {
   3.717180653437889*^9, 3.7171806695452223`*^9}, {3.71718085726085*^9, 
   3.7171809004385233`*^9}, 3.717181022961149*^9, {3.71718105557362*^9, 
   3.71718107938892*^9}, {3.7171811335295067`*^9, 3.717181135353099*^9}, {
   3.717212318054606*^9, 3.7172123643382473`*^9}, {3.71721240556768*^9, 
   3.717212418654786*^9}, {3.717212450785758*^9, 3.7172124522421494`*^9}, {
   3.7172125029971237`*^9, 3.71721253753196*^9}, {3.717212572055203*^9, 
   3.7172127292612886`*^9}, {3.7172256141317177`*^9, 3.71722582624921*^9}, {
   3.71722588075552*^9, 3.717226023335924*^9}, {3.7172264419754457`*^9, 
   3.7172264451649933`*^9}, {3.7172264974465437`*^9, 3.717226499382354*^9}, 
   3.71722668902172*^9, 3.717226863148219*^9, 3.717231339748611*^9, {
   3.7172314067929296`*^9, 3.717231407063953*^9}},
 CellLabel->
  "In[3143]:=",ExpressionUUID->"af7b3276-2a0d-4886-abb6-ec8eea8ac5ba"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.0220153739240105`\\\", \\\
\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3145, 243, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229447017212*^9},
 CellLabel->
  "During evaluation of \
In[3143]:=",ExpressionUUID->"95c98fc4-5c4a-43f4-944b-99d5dc9de64b"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.0220153739240105`\\\", \\\
\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3145, 244, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229447021224*^9},
 CellLabel->
  "During evaluation of \
In[3143]:=",ExpressionUUID->"97b98f31-c7e0-477b-ba4f-72600ec78448"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.0220153739240105`\\\", \\\
\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3145, 245, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229447024317*^9},
 CellLabel->
  "During evaluation of \
In[3143]:=",ExpressionUUID->"68a9f9bb-241e-41e7-8f17-4ef37c589890"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 3145, 246, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229447027277*^9},
 CellLabel->
  "During evaluation of \
In[3143]:=",ExpressionUUID->"330746ba-1886-4cda-b3ec-c7872e85c55d"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlunk4Vfv7gL1Dhso8z/M8FhFqfZ5QiUKiUCGlVFJKUUqbkEpFyVRKRWlS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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{765, 970, 520, 1148, 680, 608, 570, 1008, 900, 803, 
              718, 646, 521, 971, 863, 766, 681}}], 
             PolygonBox[{{962, 1149, 862, 533, 534, 977, 869, 772, 687, 615, 
              577, 535, 978, 870, 773, 688, 616, 578, 1014, 906, 809, 724, 
              652, 536, 979, 871, 774, 689, 1057, 949, 852, 617, 1046, 938, 
              1080, 841, 1070}}]}]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwV0VkrpmEABuDXcmRfT4YysofCiOxOLCcoiikSn+WQX2EvP8O+TFEoQtkO
zNj+iLWMEtd3cHXf9/M8J+/3ZYcmuycigyCIYJFPYzAqCNJkKikkk0QizYyz
RZR3o9ySYC/wQKE9xxtN9gvt+irp0UEwZm8SaY9wQ7w9II8o8ubD7tL/kGnP
2xd6hd4n98nV752f6CV6gaySs/KVRneN9qX+S/6WtfJA5sln9/Xy1C6VbbJa
roS/X466b5DndrnskTVyV/6UG+6P9WI9Qob4R5zzK1npvF8eUqj/d36ml+md
cpsMfc55r75Hjn1n5+szvNBgP9GqL5PqzYjdre+QZa+H/0R9mL/E2u906Fv8
CP8u9i159jTP1NuPtOhLpHgXstf4YsjZNTH6DDfk2lM8UWcP8w2bPEJs
              "]], 
             PolygonBox[CompressedData["
1:eJwV1EVYVVEUgNGH2KLYiNgtomJ3dyuKPXKkGIithDW0O8EeqQNbsbumKgp2
Ys1srHUHi3P+zf744L13qT0pOWFGoVAoFEaCL19ERuFQaDHjw0OhTs6zzobO
77531b25+2DnYaLdl5snup+kjr6ra7kv5TMt9QE+01PvI9LeRL2MO9Q0W8In
WugJLOU2NcwW85F4XcBw9yNU93P260/00HspE/zu+huD9CGqmC3Rt6iuM/gQ
/C16Hx/prvdQ2u44/ZWB+iBRwWuib1JNp/OeZnovH+imdxNhd2zwOnKDGLM0
8mmq9/CernoXpeyP0elcp6pZKu+I07vJp4vOoqT90TqNa0SbLeItTfQu3tFZ
Z1LCfqJODd4/qpgt5A2xOou3dNI7KW5/lF7EFaLMFvCaxjqTN3TUOyhmf6Re
yGUqm83nFY30Tl7TQW+nqP0EvYBLVDKbx8vgc6Z38Ir2ehtF7I/Q87lIRbO5
vKCB3s5L2umtFLY/XM/jAhXM5vCc+nobL2irtxBuf5iey3nKm83mGfX0Vp7T
Rm+mkP2heg7nKGc2i6fU1Vt4Rmu9iTD7Q/RszlLWLIUnwfOiN/OUVnojoeD5
0rPIJtJsJo+prTfxhJZ6A/8YpFM4QxmdTB619EYe00Kv5y8D9UxOU1rPIJea
egN5xOt1/GGATuYUEXo6j6ih15NLc72W3/TXwT+Wk5TS03gYPK96HY9optdQ
QD89nROU1FPJoZpey0Oa6tX8oq+exnFK6CQeEKPXkEOcXsVP+uipHKO4nsJ9
qurVPKCJXskPeuskjlJMT+Ye0XoV94nVK/hOLz3OmR18Jr1//wGh/KZ+
              
              "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwl1WWUVVUYgOGhO6S7Q1KlS+lOQQWku7u7pEu6GyUUaenu7u7u7vY5yx/P
fPvd59y5s/aZu27K+m0qtw4VEhISMXRISDBX+FGLCCzXdcjOOT2QbFzSw/GS
kJW6NhFZoeuSgzCssleHSKzU9cjJeT2I7FzWIwjLal2XyKzS9clFOP61V48o
rNYNyE14IgR/P5GITBTWuK8+UflXNyQPUVlrrwHRWKMbkZdorLPXkOis1Y3J
xwU9mBxc0SOJznrdiBis003Iz0U9hJxc1aOIwQbdmJis100pwCU9lFxc06OJ
yUbdhK/YoJvxznoBvxCG7+1dNoeRm+v6k/kXv/K7/mAuohqhPbhlZji+sISa
wXu4b5PZlFih/n/A/5gbLT+ai4PX2KsevK+5PPg/MZu7/t56IWF1VTOUudQM
b4Y1P/M3NfjB/VfM4eThhh5DLDbrZsRmk25BQWKzxV5z4rBZt6QQV/UI8nJT
jyUOW3UL4rJFt6Iw1/RI8nFLjyMu23RL4rFVt6YI1/Uo8nNbjyce23Ur4rNN
t6EoN/RoCnBHTyA+O3TwYUvAdt2WYtwMnlHwHLmrJ5KAnboNCdmh21GcW3pM
cI7c05NIyC7dlkTs1O0pwW09loLc15NJxG7djsTs0h0oyR09jkI80FNIzB7d
niTs1h0pxV09nsI81FNJwl7dgaTs0Z0ozT09gSI80tNIyj7dkWTs1Z0pw309
kaI81tNJxn7dieTs010oywM9iWI80TNIzgHdmRTs110px0M9meI81TNJwUHd
hZQc0N0ozyM9hRI807NIySHdlVQc1N2pwGM9lZI817NJxWHdjdQc0j2oyBM9
jVK80HNIzRHdnTQc1j2pxFM9ndK81HNJw1Hdg7Qc0b34kWd6BmV4peeRlmO6
J+k4qntTmed6JmV5reeTjuO6F+k5pvtQhRd6FuV4o/8gPSd0b77muO7LT7zU
synPW/0nX3NS9yEDJ3Q/fuaVnkMF3ukFZOCU7ktGTur+/MJrPZeKvNcLychp
3Y9MnNIDqMobPY9KfNCLyMQZ3Z/MnNa/UdgXVzXzrb35/MhHvZjMnNUDyMIZ
PZDqwZnoynyy/osswe/TWTlrPYhfg7PQVfhs/TdZ+UafMwdTIzhD/cVcElzj
W33eHELN4Mx08OX+T3CN76wvmEOpFVzSS4N9LjKM2oS2v8wMb2Yz/wNvhQI+

             "]]},
           Annotation[#, "Charting`Private`Tag$1252729#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV0dlKVVEABuDlUKBlg2lFCilqKVY0UWlqKjR4kcIpSlBMTw51ky/gZakN
z2HOAxYVJJY0CJbzgzhUpNDw7YuP///XXnDY++TGO2OPEkII03Qlh9CfGEIz
pawlhfCYPObtblKYs+/xVx/gDy1cZt35E/JZsHtI5ZvdzD99kDjpfq/P2VXW
7DI29G4KWLR7OeLeqH2T3/YuvustBIbso+5M6jHu2wfsl/o11u1yNvUejrFk
57nzRr/DUzvLHtNrOa1/klvOC/X3egPn9Vm52/m8jJNAsfNpOew8R3+ll8hb
8oz8LMtlq+cZ0Xe2L8rr8qT8KMvkhucF8p1dKuvlOflVVsgKz3/ovVywj8sT
8oNc9ixff6vf5az+RT5znq2P63Vs20X2lN5Imr0QfTcSGbHbyHRnwL7Bpn2F
n9G3opAV+zl7WLRbSWLUbqeSvexjf/R/R/9L9P40uZcpD7Kkt5HMmN1BFYdY
dtbODsbtB1TzK3ovili1X3CYFbuDnUzYud7htX6bh9Hv2YP6JVkjT8kZ+R+c
Y1jg
             "]], LineBox[CompressedData["
1:eJwV1EVYVGEUgOFri4WtKAh2gN3dXdi5cmWCBXYvTQxARDBX6sLubt3aAbaI
uLP7ncU7//+d5zyzuXem9pTEkQmFgiCI9/G5cBA0KBoEZ4oEwQR662/OtTTh
vl5PBPf0VEpwRE+nD9/1OmJ5oDdQg/t6GiU5qmfQlx96PXE81BupyQM9nTCO
6Zn046feQFMe6U1E8lDPoBTH9Sz680tvpBmPdQpRPNIzKc0JncAAfutNNOeJ
3kwtHutZlOGkTmQgf3QKLXiqtxDNE51AWU7p2Qzir95MS57prcTwVCdSjtN6
DoP5p7fQiud6G7V5pmcTzhk9lyEEnt9Ws9bk6FTq8FzPoTxn9TyGUsj+NrM2
5Oo06pKj51KBc3o+wyhsP9WsLS90OvXI1fOoyHmdxHCK2E8za8dLvZ36vNDz
qcQFnUw8Re2nm7Xnlc4IvZO81ElU5qJewAiK2d9u1oHXegcNeaWTqcIlvZCR
FLefYdaRNzqTRrzWC6jKZb2IUZSwv8OsE2/1ThrzRi+kGlf0YkZT0n6mWWfe
6Sya8FYvojpX9RLGEGZ/p1kX3utsYnmnFxPBNb2UsZSyn2XWlTy9izje6yXU
4LpexjhK288268YHvZum5Oml1OSGXs54ytjfZdadfL2HZnzQy4jkpl5BNbsH
9CC+6AmUNdute/BR76U5+Xo5UdzSK6lu96AezFc9kXJme3RPCvS+0O/V7LCO
55duwUf3FdTitl7FJFpSYLaSaO7o1Uwm3PfsNevFJ72fVnzSq4jhbuj3Yu+E
+xjW6Ah9yH1I6H/B/arzW+g9cz8betbOic7/jlOldQ==
             "]], 
            LineBox[{1087, 605, 1040, 932, 835, 750, 678, 563, 1006, 898, 801,
              716, 644, 606, 564, 565, 566, 567, 568, 1007, 899, 802, 717, 
             645, 607, 1041, 933, 836, 751, 679, 1054, 946, 849, 764, 1066, 
             958, 861, 1077, 969, 1088, 569}]},
           Annotation[#, "Charting`Private`Tag$1252729#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{1096, 1146, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 
             1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114,
              1115, 1116, 1117, 1118, 1119, 1120, 1121, 1122, 1123, 1124, 
             1125, 1126, 1127, 1128, 1129, 1130, 1131, 1132, 1133, 1134, 1135,
              1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1147, 
             1145}]},
           Annotation[#, "Charting`Private`Tag$1252729#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{1091, 1095, 1090}], 
           LineBox[{1093, 1094, 1092}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxl3Hk4Vev/P/5lpiRsZJ7nscFQxHpRKUpJaI4UEQlJUbKJDEkqZSpJKaWE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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{1164, 1166, 524, 985, 877, 779, 692, 615, 574, 1026,
               918, 820, 733}}], 
             PolygonBox[{{978, 1167, 1165, 537, 538, 995, 887, 789, 702, 625, 
              584, 1032, 924, 826, 739, 662, 539, 996, 888, 790, 703, 626, 
              585, 1033, 925, 827, 740, 663, 540, 997, 889, 791, 704, 1073, 
              965, 867, 627, 1066, 958, 1095, 860, 1086}}], 
             PolygonBox[CompressedData["
1:eJwV1DVYVQEcxuFrDnaLLSqCiYmL3YqAAnbHoIsuJhZ2B7rYBSqggpijj92J
vZvYjf2e4eWe3//5FnjuIXzCtMSpRUOhUBFi/ZhSLBTaWDwUSqOE5xif13xO
pr9hKb3Lc0ee6S3U4blOIYyzejqxlLbf7daJ53ordXmh51KDc3oGAyhjv8et
My/0NurxUs+jJuf1TOIoa7/XrQsv9Xbq80rPpxYX9CziKWe/z60rr/QOwnmt
F1Cbi3o2CZS3T3frxmu9kwYU6IXU4ZKew0Aq2Ge4dadA76Ihb3QqdbmsUxhE
Rfv9bj14o3fTiLd6EfW4oueSSCX7A249eav3EME7vZj6XNXzSKKy/UG3XrzT
e2nMe72EcK7p+SRTxT7TrTfv9T4i+aCX0oDregGDqWqf5daHDzqdKD7qZTTk
hl7IEKrZZ7v15aPOoAmf9HIacVOnMpTq9ofc+vFJ76cpn/UKIrilFzGMMPvD
wXeVz/oAzfiiV9KY23oxw6lhf8Qtli/6IM35qlcRyR29hBHUtM9xG8BXnUkL
vunVRHFXL2Uktexz3eL4prNoyXe9hibc08sYRW37o27xfNfZRPNDr6Up+Xo5
o4N3zz7PLYEf+hCtKNTraMZ9vYIxwbtnf8xtIIX6MK35qdfTnAd6JWODd8/+
uNsgfuojtOGX3kALHupVjAvePfsTbon80jm05Xfwf4WWPNKrGR+8e/Yn3ZL4
rXNpxx+dRjSP9RomBO+e/Sm3ZP7oo7Tnr95EK57otUwM3j37026D+avziOGf
3kxrnga/k90lz5OCv1vwndFnPI8O/rd4zvdZkg6erwffL5//Ac0zqoU=
              "]]}]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwVzltL03EcBvD/3GoGntP0tptS0AhyNlFph2ZF5kVXqWAxqDxuWuqrMOhg
VHrXe+jkJlQEFSQWaIGH6fZK+njx4fk+z/838Ww2fztXFQRBiLcsR4LgCW3G
Vq4xxwbN4SBYosIZfZA8RU7bFinTomc4/sMFmmwLHNF8/JarzLJOo/0xhzTp
L6nQq68R9f+k9Yh7jA06bDO2TzTojyjRqE/LTXq9OSW3Sbjvya9ccK9499ed
cj+QP+h2l+035W+9X8ZlRq7KkzLl+7D8p6flQ3lD/pQxGZZD8o8ckKNyUBZl
u5z2+1tyR0/KrLwuv8mL8qPvW+4+d72c54AG+5T8Rdy3anmXL3TpL3y/7/7O
Jf1Iv+x+wwk9qVe5Ryhw3jZl+0CdPsc+9XpUjvOZTu+e2w7p0V8TsSX0kPsO
65yzTdreU6vn2aNOf0aJmP6KsLdX9AneUWPLsUut/pT/yGJGSg==
             
             "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwl1WXUFAUUgOGPblC6Q7q7pKS7U7q7UxoEVLobCQnpFqW7O5Tu7u7QZ44/
nr33nTm7Z3dm92yKpp2qdQwVEhISNXRISDBXeqjKB/ti6pETp0PCEJZwhCcC
EYlEZKKwynOr8dG+hPrkCl6f1Y5X55N9KQ3ITTTWOF6Dz/ZlNCQPfzvWm284
oYcQnbW6Jl/sy2lEXv5xrA8pOamHEoN1uhb/2lfQmPd6NqV5rfNx1t6XVJzS
w/iK9bp2cIFYaTThg30OZXij83PO3o/UnNZfzAVU5Cf9yZxHOcK4qEvNdyH/
X+BF9sqEsy83v3b4D7MO4YP7Y4YyF5uRzFXOf7bPJ6KuYIY1l5lRzKbOf7TP
JYIua4Y2l5iRzbfO/2tfSCW+1efN/qThjP6ZmGzQ3wfPZ7VuRgEu6AGk5W/9
C7H4U9cNPiNrdHMKclEPJB3/6OHE5i9dL3j/rNUtKMQlPYj0nNUjiMNGXT+4
VqzTLSnMZT2YDJzTI4nLJt0guI6s160owhX9Ixk5r0cRj826YXDd+EO35juu
6iFk4oIeTXy26EbBfWCDbkNRrumhZOaiHkMCturGwX3kT92WYlzXw8jCJT2W
hGzTTYL7xl+6HcW5EXyvyMplPY5EbNdNg+8BG3V7SnBT/0w2rujxJGaHbkZU
NukOlOSW/oXsXNUTSMJO3ZxobNYdKcVtPZwcXNMTScou3YLobNGdKM0dPYKc
XNeTSMZu3ZIYbNWdKcNdPZJc3NCTSc4e3Yqv2Ka7UJZ7ehS5uamnkIK9unXw
G2O77ko57uvR5OGWnso37NNtiMkO3Y3yPNBjyMttPY2U7NdticVO3Z0KPNRj
yccdPZ1UHNDtiM0u3YOKPNLjyM9dPYPUHNTticNu3ZNKPNbjg98y9/RM0nBI
dyAue3QvKvNET6AA9/Us0nJYB38M8dirf6AKT/VECvJA/0o6juhOxGef7k1V
nulJFOKhnk16jurOJGC/7kM1nuvJFOaRnkMGjukuJOSA7kt1XugpFOGxnktG
juuuJOKg7he8H39eNcyXjk3lO57oeWTihO5GYg7p/tTklZ5GUZ7q38jMSd2d
JBzWA6jFaz2dYjzT88nCKd2DpBzRA6nNGz2D4jzXC8jKad2TZBzVg6jDWz2T
ErzQC8nGGd2L5BzTg/med3oWJXmpF5E9uKc6BcftP1I3uJ+6FK/svwef1V6e
90GbVVhBDv0f+scCgA==
             "]]},
           Annotation[#, "Charting`Private`Tag$1253032#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV0cdOlGEUBuCPmVEgAirVtnFjixiNqNhQUVpEF64sBAxGUZAZwH4PmljB
ehdWmmg0aqKxRDQWOt6Hz7d48p73/GeYwvLWzKF0VghhlLxECL+SIXQyj8d6
G1UkUiH02lUwpl/Vr8t8ftulyeOJfppdJN302W1iXL9BAX/0DPk81c+wwm2/
fpgsdtul7O6aNzOh32St3YjeTDbz7f7KLgp4prez0t2AfoQEe+zm2N0zb2FS
36i/M5/kll6uvzK3kEOl/lG2s8DzMdkd35Ptnn2Wz+3Xm9+Y62VrfC85Kg/I
Ds9XyUG9Vh6VO+VX2SiT8feRH2SDbJN75U95UFZ7/Vx5X6+RlXKH/CL3yynP
K+R7/RTV5h/ytv0682vz8fh7mr/LXLaaP8kOFroblz3xO/JCP8tqN0P6MVLx
M9ll2z2Ir2dav0MhE/q5+Lfo1zvZRxHFTNqfp5ABPU0NJUzZXaCIQT1DLaVM
212kmCG9izrKWMQ1n2exXMKMm0uUMKx3U0+Om4d225jRe1nKrH6ZUl7qPTSQ
6/5R/P8yq/exjH/6FcoY0Te4e2s+Eb+7vkYfNtfJJlklv8n/zrJc8A==
             "]], 
            LineBox[CompressedData["
1:eJwV1DVUVgEcxuFrDnaLBaKiAoJiLnYnKmKLgQ666GJ3IGHHYnd3O3rs7nYX
A7sL9bnDw3d///MucL5LdPqElPEFgiDo5keRQkHQvHAQXPM5lu4Fg6CY3uS5
Jc/1GmqQq6cTwVk9kR4Ut9/s1opcvZZIXugZVOGcnkRPSthvcWvNC72OKF7q
mVTlvJ5ML0rab3Vrw0u9npq80rOoxgU9hWRK2W9za8srvYFoXuvZVOeinkpv
Sttvd2vHa72RWuTpOdTgkp5GH8rY73BrT57eRG3e6LlEcllPpy9l7Xe6deCN
3kwd3up5RHFFzyCFcva73DryVm8hhnd6PjW5qmfSj/L2u9068U5vpS7v9QKi
uaZnkUoF+z1unXmvt1GPDzqDWlzXs+lPRfu9bl34oLdTn496IbW5oecwgEr2
+9y68lHvIJZPOpM63NRzGUhl+/1u3fikdxLHZ51FDLf0PAYRYX8g/K7yWe8i
ni86m7rc1vMZTBX7g249+KJ304CvOod63NELGEJV+0NuPfmq95DAN72I+tzV
GQylmv1ht15803tJ5LteTCz39EKGUd3+iFsy3/U+GvJDLyGO+zqTtPDdsz/q
1psfej+N+KmXEs8DncXw8N2zP+bWh5/6AEn80stowEOdzYjw3bM/7taXX/og
jfmtl5PAI53DyPDdsz/hlsJvfYgm/NErSOSxXsSo8N2zP+nWjz/6ME3J1ytp
yBO9mPTw3bM/5ZZKvj5CM/7qVTTiqV7C6PDdsz/t1p+/+ijN+adXk8Sz8Hey
u+R5TPh3C78z+ozntPB/i+f7PovSwvP18Pvlc5zP/xcoqVg=
             "]], 
            LineBox[{1103, 612, 1060, 952, 854, 767, 690, 567, 1024, 916, 818,
              731, 654, 613, 568, 569, 570, 571, 572, 1025, 917, 819, 732, 
             655, 614, 1061, 953, 855, 768, 691, 1071, 963, 865, 778, 1082, 
             974, 876, 1092, 984, 1104, 573}]},
           Annotation[#, "Charting`Private`Tag$1253032#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{1112, 1162, 1113, 1114, 1115, 1116, 1117, 1118, 1119, 
             1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 1128, 1129, 1130,
              1131, 1132, 1133, 1134, 1135, 1136, 1137, 1138, 1139, 1140, 
             1141, 1142, 1143, 1144, 1145, 1146, 1147, 1148, 1149, 1150, 1151,
              1152, 1153, 1154, 1155, 1156, 1157, 1158, 1159, 1160, 1163, 
             1161}]},
           Annotation[#, "Charting`Private`Tag$1253032#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{1107, 1111, 1106}], 
           LineBox[{1109, 1110, 1108}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxl3Hs8lNv7P/4hp1JIEpIkSSiScuxed0SiUFSSIlHKOeeoJlGShORQyiiJ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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwV08dSFVEUheEWZCKKRB37EJKTPoIPoIIBEBVTWWqZFVCSgk7M2bmAYHZk
TnNDmbOAlCCY/fbgr73Wf/rcPt333hnVDXOWpyRJMgEjSE9LkmxkYu7EJBlI
TZLd6HbROT0fN/QqfJIb8FdOx0t5MUblTmyzp1GfhAP6TLyT6/FTfm79sTwP
g3oLBuXVSEGP9W6zADetjZjrUS1/Nlfgn/zD3IzJ8iuzBt/lMXMjuuRhcy0m
eK408xe2Ik3f7j5Ncjr+4KDrv5nr4hzW8/X38tK4X+zVx81NSLX+wv4n8vx4
FxiyPmpuQKs8ZK6Ja+O5sQW99vSYhbjlmgX4Iq9Egin6a7MWY/I+7LCnOZ4T
h/SCeOfcefRyRbjNLUQGdvK74rNwWC+M98M91avwVW9DX3yGXow7+iIMyKvi
fWGq/sasw7i8H4327NYzcEQvwgd5GX7H2a0/i+8Kw3o7+rk+vQR39cXIRBPf
EvfBUb047sddQD9XintcDbLQzLdymTiml+AtdzGeF218Fo7zpfGb4y7FedHO
Z+MEXxbfK3c57o8OPgcn+fJ4Hu5KnIMrw32uFtlo5fdwuTilV+AjdzXOwZXj
AVeHnHjP/F4uD6f1yvj/cNfibFwFHnJLkBvvi+/kpuGMPit+89z1OC9XiUdc
PfLQwXdx03FWnx2/J+4/9m+J2A==
              "]], PolygonBox[CompressedData["
1:eJwV1EVbVWEYhtEton9ALwsLExXrJ9iKioodI2Om2N01tQNUDATB7lbAbkUB
u9uBhd2ub7DO2c99ncE7OTt+8MiU1JgoisqQ7CM2NooqlIuiihzz3IrCslE0
nEos9OOlWhVy7Da81Qo4rrXmujaCyizSl2lVybXb8k47QZ7WhhtaKlVYrC/X
qrHZbsd77ST5WluKtJFUZYm+Qotji92eD9qpcJPWjmJtFNVYqq/UqrPV7sBH
7XS4SWtPiTaaOJbpaVoNttkdKdXOhJu0DtzUxlCd5Xq6VpPtdic+aWfDTVpH
bmljqcEKfZVWix12Ep+1c+EmrRO3tXHUZKW+WqvNTrszX7Tz4SYtiTvaeGqR
pq/R4tlld+GrdiHcpHXmrjaB2qTrGVoddttd+aZdDDdpXbinTSSeVfparS57
7GS+a5fCTVpX7muTqMNqfZ1Wj712N35ol8NNWjIPtMnUZY2+XqvPPrs7P7Ur
4SatGw+1KdQjQ9+gNWC/3YNf2tVwk9adR9pU6rNWz9QacsBO4bd2Ldyk9eCx
No0GrNM3agkctHvyRysMN2kpPNGm05D1epbWiEN2L/5q18NNWk+eajNIYIOe
rTXmsN2bf9qNcJPWi2faTBqRqW/SmnDE7kNEUbhJ681zexaN2ajnaIkctftS
huJwk9aHF/ZsmpCl52pNOWb3I4aH9hBKPS+gJNxo9+WlPYdEsvXNWjOO2/0p
yyN7KJ/CO4Wbfldk9+OVPZembNK3aM3JswcQyy29WOvPa3sezcjRt2otyLcH
Uo7beok2gDf2fJqTq2/TWlJgD+KN51T+eC7PY8/D+Bz+O76nsii8Z3yPJ/Ku
/A/z9rpr
              "]]}]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{638, 1297, 1296, 1241, 734, 820, 920, 1033, 1156, 
             640, 778, 864, 964, 1077, 1200, 689, 904, 1004, 1117, 1240, 733, 
             819, 919, 1032, 1155, 639, 777, 863, 963, 1076, 1199, 688, 732, 
             818, 918, 1031, 1154}}]]}, {}, {}, {}, {}, {}, {}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
            1.], LineBox[CompressedData["
1:eJwV1mW4VWUUReGLpHQonSog3SCC0ipKN0h3h4h0pxIWISihgJRB2Nh0KqGU
gtIIBh0C+q4fg/nNsfe5zz17rXMu+Tr2a9Q3UUJCwuh7EhIi//XPBDynZ5Nd
5d9yiPzM9dbylD5IDpN95DXZwbVGzkec+6On82WZLq45/yFHo4z7CulrnZ/E
af1lNOd+i5+L+6Am3JYTkR2f6x1RFolxh5uEHPhC74RyKOyF67incEZ/BUlw
V5+MnFivd0Zj9/6iD0B6lOeKcB8518ZZ/VW04H7XX8D9SMr9J6cgF77U27jn
tPNwdNGb6L/Gc0QGdNTPyzGo4HpR/WPnp9Hd+aI8x7dzPus8Eq/pLfXjzoPR
2/mqzIzOzn+Gl+PimcubcoRM5nXxAF/UB8rcspv8Rw6VX7ncVp6J9yRHyL7y
evz+sqvrTeVR/Xk5UPaSV+QwmVF2khfkWPRzviEf8bpizp84P4MezpfkH3x7
53POo/C63ko/EXuFLEjOJeJecs6Dr/VuaMYdi98DmVCRK8596lwH5/WZSBFv
mZ/K5cU3enc8inuREqmQOvbHfdPckw/f6j1QCWliV1ybzj+A7/SeqIy0SOra
DP5BfK/3wmNIh2Suvcw/hA16bzyOEvG54erigj4L6ZGcf4XLj416H1RBSf5z
rh7+1GcjQ7w//lWuADbpfeM9WcSqspRrX/D18Zc+BxnjffOvcQWxWe+HaijN
r+ca4G/9DWSKn8e/zj2MLXp/VEcZ/kuuIf7R5+K+eJ78TK4QtuoDUCM+o7Fj
XCNc1Ofh/nj2/CyuMLbpz6FmfG75r7nGuKS/icwxD342VwTb9YGohfL8N1wT
XNbfQpaYET+HK4od+vN4AhX4b7mmuKLPR9aYG/8GVww79UF4Eo/w33HNcFVf
gGwxN34uVxy79BfwFCry33PNcU1fiOwxN34eVwK79cGoHTvJb+Ba4Lq+CDli
ZvybXEn8oA/B07Gb/EauJW7obyNnzIx/iyuFH/WheCb2ld/EtcJN/R3kipnx
87nS2KMPQ53YYX4z9yxu6YuRO2bGL+DKYK8+HHVjr/ktXGv8qy9BnpgZv5Ar
i336CNSLvea3cm1wW1+KvDEzfhFXDvv1kaiPqvw2ri3u6O8iX8yMf5srj5/0
UWgQO81v59rhrr4MD8TM+He4CvhZH42GsdP8Dq49/tOX48GYGb84vsdwQB+D
RrHT/E6uA+KP5ArxUMyMXxLfSTioj0Xj2Gl+F9cRibCSyx8z45fqj+KQPg5N
Yqf53fGdinuwiisQM+Pf1SvhsD4eTWOn+R+4zkiM97iCMTN+mV4ZR/QJaBY7
zf/IdUESvM89HDPjl+uP4Rd9IprHTvN7uK5Iig+4QjEzfoX+OH7VJ6FF7DS/
l+uGZPiQKxwz41fqVXBUn4yWsdP8Pq47kmM1VyRmxq/Sq+KYPgXJfce1ir12
bT/fAymwhisac+Pf06vhN/1FPBt7zf/E9cS9WMsVi7nx7+vV8bv+ElrHXvM/
c72QEuu44jE3/gO9Bo7rU9Em9po/wPVGKnzElYi58R/qNXFCn4a2sdf8Qa4P
UuNjrmTMjV+t18JJfTraxV7zh7j4z1kafMKVirnxa/QncEqfgfax1/xhrh/S
4tN4DtxJ56HIGvPX/5LjMcD5lhwpS7v3f6nNIh4=
             "]]},
           Annotation[#, "Charting`Private`Tag$1253083#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
            1.], LineBox[CompressedData["
1:eJwV01lXT1EYx/ETWoYIDVx7C6QoCi/BvSk0yMyysMyVkFAs8zzdmmV2YZ5v
DWWeZVpEZp/n4tvz/L777LP32f9dn+IpwyenJEnSy58F7ZJkSYck6Yj17ZOk
L5q4gzjA5eACNwqdsZCv5Dphg9wPzdxdeQRa5GU4FO+Q++OiPBpdsIiv4jpj
o5yDh9w9uUdqkoxU33PLcZg/JOfikjwGb/VT8Fefhif6ErTq67HYnGq5CzbJ
/fFSX4Gf+kfG7+tH4YO8Ah/0M9AOR4wfVvNw2dhXdQ6K9e/Uqfin/6EuQFf9
U7UU3/Tf1Xlo0H9WZyHFd6Wqv7AIqfIS6yzVp+EPNnv+izo79mE8V36lnxjr
xVy5TZ2P9sYfm/9APzrOAh+Nt6pzUav/qM6MZ+O7sRBHzTmiDsAVz4xFi34a
EnSTn6ll+K5fi0pzauI7sUXOizPnjuEoNxBXuXFIRxW/LN6FrfKAOB+uSR6D
T/JKHI93yPm4Jo/He/30OC90l5+r5WjTr0O1OcvldGyTB+K1fhJ+x96NN8dv
hc9yHRq543IBrssl6IGl/IpYB9vl/FiPO4FGbhBucKXoiRq+Nu4odsgFeMGd
jO/FSr4ndvKD4s5xp2K/qOMzsIsfHL8rdzrWxyo+E7v5wvge7kzsgxuMm1wZ
MlDLr+aysEcuwhvubOyDK8QtrhyZcc78Gi4be+Uh8f/DnYu9cUW4zU1AVpwX
X8/1wj55aNx57nzslxuCO1wFsrGKb+B6Y788LO4Tl+Z+/gdrWppn
             "]], 
            LineBox[CompressedData["
1:eJwV1EVbVWEYhtGN9RPsQsUW9SeoWICFIqCOjJliYndM7W5Ryu7G7lbC7mRg
YbfrG6yz93NfZ/BOzokdODwlMyaKomQfRytFUTtuVIyioVRlXoUoWqRVJ8/u
wFvtBIVae25qw6jGfH2xVoN8O4F32kmOaR24pWVSnQX6Eq0mBXZH3munOK4l
UKQNpwYL9aVaLTbbnfignQ43aR0p1kZQk0X6Mq02W+zOfNTOhJu0TpRoI6nF
Yn25VoetdhfKtbPhJq0zpdooarNEX6HVZZvdlU/auXCT1oXb2mjqsFRfqdVj
u53IZ+18uEnryh1tDHVZpq/S6rPDTuKLdiHcpCVyV8uiHsv11VosO+1kvmoX
w01aEve0sdRnhb5Ga8AuuxvftEvhJi2Z+9o4Ylmpr9UastvuznftcrhJ68YD
bTwNWKWv0xqxx+7BD+1KuEnrzkNtAg1Zra/X4thr9+SndjXcpPXgkTaRRqzR
N2iN2Wf34pd2Ldyk9eSxNok41urZWhP22yn81q6Hm7RePNEm05h1+katKQfs
3vzRboSbtBSealNownp9k9aMg3Yf/mo3w01ab55pU2nKBj1Ha84hO5V/2q1w
k9aH59o0mpGt52otOGz3JaIo3KSl8sKeTnM26nlaS47YacRQHG7S+vLSnkEL
Nun5WiuO2ulU4JE9iHLvcykJN9ppvLJn0pIcvUCLp9DOoCKP7cF8Cv8plPpe
kZ3Oa3sWrcjVN2utOWb3oxK39WItgzf2bOLJ07dobThu96cyd/QSrR9l9hxa
k69v1dpywh5AmfdM/nivwhPvQ/gcfjuek5gf/mc8s4gqu8nzP4DOujY=
             "]], 
            LineBox[{1284, 729, 1238, 1115, 1002, 902, 816, 681, 1197, 1074, 
             961, 861, 775, 730, 682, 683, 684, 685, 686, 1198, 1075, 962, 
             862, 776, 731, 1239, 1116, 1003, 903, 817, 1253, 1130, 1017, 917,
              1266, 1143, 1030, 1276, 1153, 1286, 687}]},
           Annotation[#, "Charting`Private`Tag$1253083#2"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{1289, 1295, 1288}], 
           LineBox[{1293, 1294, 1292}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{4}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.717212365878057*^9, {3.7172124145505247`*^9, 3.717212420006885*^9}, {
   3.7172125056856213`*^9, 3.7172125388184032`*^9}, {3.7172125739297333`*^9, 
   3.717212618737115*^9}, {3.7172126548342333`*^9, 3.7172127307910624`*^9}, 
   3.717224325485999*^9, 3.7172243592503967`*^9, 3.717225058020063*^9, 
   3.717225115057851*^9, 3.7172253841493196`*^9, {3.717225719120618*^9, 
   3.7172257837833033`*^9}, {3.7172258275797567`*^9, 3.717225854304784*^9}, 
   3.7172259237556973`*^9, {3.71722595628121*^9, 3.717226049040565*^9}, 
   3.717226446065174*^9, 3.717226500402849*^9, 3.717226714717638*^9, 
   3.7172268776822166`*^9, 3.717231291183717*^9, 3.7172313510291843`*^9, 
   3.717231421856057*^9, 3.7172350357118473`*^9, 3.7386097542718287`*^9, 
   3.793502842902734*^9, 3.793504047958351*^9, 3.79390484471509*^9, 
   3.8232294471714897`*^9},
 CellLabel->
  "Out[3148]=",ExpressionUUID->"6c0c6ea8-d0cf-4b32-ad78-f9e10968efbb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["\[Kappa]1a"], "Input",
 CellChangeTimes->{{3.717225800614024*^9, 3.717225802031041*^9}},
 CellLabel->
  "In[3149]:=",ExpressionUUID->"b5a96ea6-7ade-4a93-95ca-7b787f166ecb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
  SqrtBox[
   RowBox[{"1", "+", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}]]}]], "Output",
 CellChangeTimes->{3.717225802515153*^9, 3.717226049295611*^9, 
  3.717226714866542*^9, 3.717226878205574*^9, 3.717231291518252*^9, 
  3.7172313512829523`*^9, 3.717231422199883*^9, 3.7172350358487787`*^9, 
  3.7386097545273*^9, 3.79350284291595*^9, 3.793504047971176*^9, 
  3.793904844727149*^9, 3.823229447181148*^9},
 CellLabel->
  "Out[3149]=",ExpressionUUID->"13e231d6-4bae-428d-92d1-978a1ce5544b"]
}, Open  ]],

Cell["\<\
Linear feedback:  solve the Riccati equations exactly (for Q=R=1).  Start by \
solving Riccati eq.\
\>", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}, {3.717221375465053*^9, 
  3.7172213853594923`*^9}, {3.71722207701024*^9, 3.717222084248974*^9}, {
  3.717222390125558*^9, 3.717222397148446*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"dd3856e6-c205-4ab4-a6d5-859106db8b08"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"\[Kappa]1b", ",", "\[Kappa]2b"}], "}"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Kappa]1a", ",", "\[Kappa]2a"}], "}"}], "/.", 
    RowBox[{"\[Theta]", "\[Rule]", "\[Pi]"}]}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.717222214865674*^9, 3.717222277656933*^9}},
 CellLabel->
  "In[3150]:=",ExpressionUUID->"c1f775ab-4d59-4797-9419-aef8385f3a6d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    SqrtBox["2"]}], ",", 
   RowBox[{"1", "+", 
    SqrtBox["2"]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.717222253970789*^9, 3.7172222783245697`*^9}, 
   3.71722432569965*^9, 3.71722435945076*^9, 3.71722505827194*^9, 
   3.717225115338531*^9, 3.717225384416546*^9, 3.717225719234673*^9, 
   3.717226049416936*^9, 3.7172267150113773`*^9, 3.717226878304782*^9, 
   3.7172312918358727`*^9, 3.717231351421501*^9, 3.717231422300404*^9, 
   3.7172350359369297`*^9, 3.7386097546584663`*^9, 3.793502842940126*^9, 
   3.793504048002635*^9, 3.7939048447474937`*^9, 3.823229447200513*^9},
 CellLabel->
  "Out[3150]=",ExpressionUUID->"c5fe5b52-02bf-49ed-91b7-3e63118eb370"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"s11end", ",", "s12end", ",", "s22end"}], "}"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s11", ",", "s12", ",", "s22"}], "}"}], "/.", "sol"}], "/.", 
    RowBox[{"\[Theta]", "\[Rule]", "\[Pi]"}]}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.7172227226592627`*^9, 3.717222819103325*^9}, 
   3.717224352488349*^9},
 CellLabel->
  "In[3151]:=",ExpressionUUID->"907e0de8-41fc-428a-984d-486dd436451b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", 
    SqrtBox["2"]}], ",", 
   RowBox[{"1", "+", 
    SqrtBox["2"]}], ",", 
   RowBox[{"1", "+", 
    SqrtBox["2"]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.717222724013961*^9, 3.717222730005362*^9}, {
   3.7172227699449263`*^9, 3.717222779830505*^9}, {3.717222811943076*^9, 
   3.717222819723222*^9}, {3.717224325833379*^9, 3.7172243595724163`*^9}, 
   3.717225058388612*^9, 3.717225115476988*^9, 3.717225384543373*^9, 
   3.717225719345985*^9, 3.717226049550585*^9, 3.7172267151441*^9, 
   3.717226878420336*^9, 3.717231291966323*^9, 3.7172313515544567`*^9, 
   3.7172314223986597`*^9, 3.7172350360375347`*^9, 3.73860975479146*^9, 
   3.793502842970483*^9, 3.793504048009746*^9, 3.793904844754764*^9, 
   3.823229447214284*^9},
 CellLabel->
  "Out[3151]=",ExpressionUUID->"accba4a6-46d0-4c37-a63e-a6335ffe337d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"s11", "'"}], "[", "t", "]"}], "+", "1", "-", 
       SuperscriptBox[
        RowBox[{"s12", "[", "t", "]"}], "2"], "-", 
       RowBox[{"2", " ", 
        RowBox[{"s12", "[", "t", "]"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"\[Theta]0", "[", "t", "]"}], "]"}]}]}], "\[Equal]", "0"}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"s12", "'"}], "[", "t", "]"}], "+", "1", "+", 
       RowBox[{"s11", "[", "t", "]"}], "-", 
       RowBox[{
        RowBox[{"s12", "[", "t", "]"}], " ", 
        RowBox[{"s22", "[", "t", "]"}]}], "-", 
       RowBox[{
        RowBox[{"s22", "[", "t", "]"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"\[Theta]0", "[", "t", "]"}], "]"}]}]}], "\[Equal]", "0"}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"s22", "'"}], "[", "t", "]"}], "+", "1", "+", 
       RowBox[{"2", " ", 
        RowBox[{"s12", "[", "t", "]"}]}], "-", 
       SuperscriptBox[
        RowBox[{"s22", "[", "t", "]"}], "2"]}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"initr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"s11", "[", "\[Tau]", "]"}], "\[Equal]", "s11end"}], ",", 
     RowBox[{
      RowBox[{"s12", "[", "\[Tau]", "]"}], "\[Equal]", "s12end"}], ",", 
     RowBox[{
      RowBox[{"s22", "[", "\[Tau]", "]"}], "\[Equal]", "s22end"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s11s", ",", "s12s", ",", "s22s"}], "}"}], "=", 
   RowBox[{"NDSolveValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"eqr", ",", "initr"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"s11", ",", "s12", ",", "s22"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "\[Tau]", ",", "0"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Kappa]opt1", "[", "t_", "]"}], ":=", 
    RowBox[{"s12s", "[", "t", "]"}]}], ";", 
   RowBox[{
    RowBox[{"\[Kappa]opt2", "[", "t_", "]"}], ":=", 
    RowBox[{"s22s", "[", "t", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Kappa]opt1a", "[", "t_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Kappa]opt1", "[", "t", "]"}], ",", 
       RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], "}"}], 
     "}"}], ",", "\[Kappa]1b"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Kappa]opt2a", "[", "t_", "]"}], ":=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Kappa]opt2", "[", "t", "]"}], ",", 
        RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], "}"}],
       "}"}], ",", "\[Kappa]2b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Kappa]opt1a", "[", "t", "]"}], ",", 
          RowBox[{"\[Kappa]opt2a", "[", "t", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2.8"}], "}"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Kappa]1a", "/.", 
           RowBox[{"\[Theta]", "\[Rule]", 
            RowBox[{"\[Theta]0", "[", "t", "]"}]}]}], ",", 
          RowBox[{"\[Kappa]2a", "/.", 
           RowBox[{"\[Theta]", "\[Rule]", 
            RowBox[{"\[Theta]0", "[", "t", "]"}]}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2.8"}], "}"}]}]}], "]"}]}], "}"}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "4"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.717222343263974*^9, 3.717222359406526*^9}, {
   3.717222837494134*^9, 3.717222877315568*^9}, {3.717224038714993*^9, 
   3.717224078726529*^9}, {3.717224305606297*^9, 3.717224310870537*^9}, {
   3.717224552356038*^9, 3.717224553714946*^9}, {3.717224613404366*^9, 
   3.717224614681821*^9}, {3.71722464523015*^9, 3.717224707245659*^9}, {
   3.7172248838324213`*^9, 3.717224930253559*^9}, {3.717224981834964*^9, 
   3.717225049112413*^9}, 3.717225089308015*^9, {3.717225376662912*^9, 
   3.71722540921082*^9}},
 CellLabel->
  "In[3152]:=",ExpressionUUID->"bd7e6200-f42c-4462-ac3e-73529be95840"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*FractionBox[\\\"8.900295434028806`*^-308\\\", \\\"7\\\"]\\) is \
too small to represent as a normalized machine number; precision may be lost.\
\"", 2, 3154, 247, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232294472352943`*^9},
 CellLabel->
  "During evaluation of \
In[3152]:=",ExpressionUUID->"092bcf4f-c3c5-477e-bd60-123fe48ce741"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*FractionBox[\\\"8.900295434028806`*^-308\\\", \\\"6\\\"]\\) is \
too small to represent as a normalized machine number; precision may be lost.\
\"", 2, 3154, 248, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229447291857*^9},
 CellLabel->
  "During evaluation of \
In[3152]:=",ExpressionUUID->"75621739-4e1f-4eb3-96f7-598d51f65be6"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*FractionBox[\\\"8.900295434028806`*^-308\\\", \\\"5\\\"]\\) is \
too small to represent as a normalized machine number; precision may be lost.\
\"", 2, 3154, 249, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229447346109*^9},
 CellLabel->
  "During evaluation of \
In[3152]:=",ExpressionUUID->"4965f9b3-8e7a-4cc0-80cb-64b9e6285b5a"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"General\\\", \
\\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 3154, 250, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229447400753*^9},
 CellLabel->
  "During evaluation of \
In[3152]:=",ExpressionUUID->"c01ec6e0-52b7-4ca3-8232-c1c261d2aed9"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVlnc8lu8Xx3mGVXhGSUoa8i0zMtJwTtKihGjYlZTKCFlJdkpWkdFeNCij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           "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQB2IQzaq//MFTFhGHZ3Ptjf0DmB1mdzS27JJE8MXiqxvK
dBB8lp1JBWnlCP5HIa+EsEMI/iv/0OgnKaJw/pOehLAidjE43/N9uedTM3E4
/00yR/GWegk4301FnKn9kCScL3RWrW/Deyk4X6ZjfYCZmQycP0PbUkA4XRbO
PyXlaPp5ohycbyVzaIL+NXk4n495UUlikwKcL9cobxOppgjnc6rGbAs6juDr
2UquL49VgvOL7gkd9mJQhvPff+4J9ZyB4LvrH5vlqasC5+/7bP37+zkEP0/H
6NbFVFU43/ZdypVITjU431VFwpd3EYKv0dBVcchcHc7XSrXcr3oLwU/dl9Gy
pVADzt+/4ErKR1FNOP/Liv/f9bcj+Mmqqzln+Woh4k9rstmmDwj+jiW/H37t
0Ibzo1yUHazldOB86dz2nXoHEHxRrpyNvuG6cP4t68mXl61G8Ofl7vr6/z+C
DwA/huuW
           "]]},
         Annotation[#, "Charting`Private`Tag$1253213#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV1nc8Ve8fAPB777HXXURKRWgYqczW80FUVsgmlEjJqCihSJQyQokQKlT2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           "]], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGBQB2IQzaq//MFTFhGHZ3Ptjf0DmB1mdzS27JJE8MXiqxvK
dBB8lp1JBWnlCP5HIa+EsEMI/iv/0OgnKaJw/pOehLAidjE43/N9uedTM3E4
/00yR/GWegk4301FnKn9kCScL3RWrW/Deyk4X6ZjfYCZmQycP0PbUkA4XRbO
PyXlaPp5ohycbyVzaIL+NXk4n495UUlikwKcL9cobxOppgjnc6rGbAs6juDr
2UquL49VgvOL7gkd9mJQhvPff+4J9ZyB4LvrH5vlqasC5+/7bP37+zkEP0/H
6NbFVFU43/ZdypVITjU431VFwpd3EYKv0dBVcchcHc7XSrXcr3oLwU/dl9Gy
pVADzt+/4ErKR1FNOP/Liv/f9bcj+Mmqqzln+Woh4k9rstmmDwj+jiW/H37t
0Ibzo1yUHazldOB86dz2nXoHEHxRrpyNvuG6cP4t68mXl61G8Ofl7vr6/z+C
DwA/huuW
           "]]},
         Annotation[#, "Charting`Private`Tag$1253213#2"]& ], 
        {Dashing[{Small, Small}], 
         LineBox[{{4.995216836734694, 2.418969057548383}, {5., 
          2.4165913099607392`}, {5.004783163265306, 2.414213562373095}}], 
         LineBox[{{4.995216836734694, 2.414236223821765}, {5., 
          2.4142248930974297`}, {5.004783163265306, 
          2.414213562373095}}]}}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 14.999999693877552`}, {0, 2.8}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJxF1Xc4Vv//B3Du297u2wophQrZGRmvV6hPZlK0paEpIS0kRMkKUQgpkqQy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           "]]},
         Annotation[#, "Charting`Private`Tag$1253262#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJxF1nc81d8fB3Dutfe919aQjGQVsnXeWZGEvilpUNG2SiUUKSUiShkhySgr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           "]]},
         Annotation[#, "Charting`Private`Tag$1253262#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 14.999999693877552`}, {0, 2.8}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{4}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.717222879843102*^9, 3.717223755619073*^9, 3.717224080737587*^9, 
   3.717224133454921*^9, {3.717224313743458*^9, 3.7172243596866903`*^9}, 
   3.717224556374271*^9, 3.717224615617154*^9, {3.7172246582405663`*^9, 
   3.717224707757881*^9}, {3.717225009338669*^9, 3.717225058571363*^9}, 
   3.717225115774963*^9, {3.7172253848459167`*^9, 3.717225410199019*^9}, 
   3.717225719551483*^9, 3.71722604973919*^9, 3.717226715726511*^9, 
   3.7172268785923347`*^9, 3.7172312921697903`*^9, 3.717231351754858*^9, 
   3.717231422568667*^9, 3.717235036199759*^9, 3.738609755020125*^9, 
   3.7935028430817633`*^9, 3.793504048105657*^9, 3.793904844851856*^9, 
   3.823229447482765*^9},
 CellLabel->
  "Out[3158]=",ExpressionUUID->"4e5e1838-cfd8-4f7f-b2df-42ab67e1ca05"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"TestSwingUpFBopt", "[", 
   RowBox[{
   "\[Tau]_", ",", "\[Tau]1_", ",", "d_", ",", "\[Theta]ff_", ",", 
    "\[Theta]dotff_", ",", "uff_", ",", "\[Kappa]1_", ",", "\[Kappa]2_"}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "eq", ",", "init", ",", "\[Theta]", ",", "\[Theta]dot", ",", "t", ",", 
      "ufb", ",", "u", ",", "\[Theta]s", ",", "\[Theta]dots", ",", "us", ",", 
      "ufbs"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"lqr", " ", "for", " ", "q"}], "=", "r"}], ",", " ", 
      RowBox[{"quasistationary", " ", "approximation"}]}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"ufb", "[", "t_", "]"}], ":=", 
      RowBox[{"Piecewise", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"\[Kappa]1", "[", "t", "]"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
               RowBox[{"\[Theta]", "[", "t", "]"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"\[Kappa]2", "[", "t", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
               RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ")"}]}]}], ",", 
           RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "12.99"}]}], 
          "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"u", "[", "t_", "]"}], ":=", 
      RowBox[{
       RowBox[{"uff", "[", "t", "]"}], "+", 
       RowBox[{"ufb", "[", "t", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"eq", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"\[Theta]", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Theta]dot", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sin", "[", 
            RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}], "+", 
          RowBox[{"u", "[", "t", "]"}]}]}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"init", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Theta]", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"\[Theta]dot", "[", "0", "]"}], "\[Equal]", "d"}]}], "}"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Theta]s", ",", "\[Theta]dots"}], "}"}], "=", 
      RowBox[{"NDSolveValue", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"eq", ",", "init"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", "\[Theta]dot"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ufbs", "[", "t_", "]"}], ":=", 
      RowBox[{"Piecewise", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"\[Kappa]1", "[", "t", "]"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
               RowBox[{"\[Theta]s", "[", "t", "]"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"\[Kappa]2", "[", "t", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
               RowBox[{"\[Theta]dots", "[", "t", "]"}]}], ")"}]}]}], ",", 
           RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "12.99"}]}], 
          "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"us", "[", "t_", "]"}], ":=", 
      RowBox[{
       RowBox[{"uff", "[", "t", "]"}], "+", 
       RowBox[{"ufbs", "[", "t", "]"}]}]}], ";", 
     RowBox[{"{", 
      RowBox[{"\[Theta]s", ",", "us"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", "0.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]4", ",", "u4"}], "}"}], "=", 
   RowBox[{"TestSwingUpFBopt", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "d", ",", "\[Theta]0", ",", "\[Theta]dot0",
      ",", "u0", ",", "\[Kappa]opt1a", ",", "\[Kappa]opt2a"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p5", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]4", "[", "t", "]"}], ",", 
       RowBox[{"u4", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p6", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Theta]4", "[", "t", "]"}], "-", 
        RowBox[{"\[Theta]3", "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{"u4", "[", "t", "]"}], "-", 
        RowBox[{"u3", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"p2", ",", "p5", ",", "p6"}], "}"}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "4"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.717222010196205*^9, 3.717222060813529*^9}, {
   3.717224737231241*^9, 3.7172248427157173`*^9}, {3.717225080602165*^9, 
   3.717225081866411*^9}, {3.717225463911592*^9, 3.717225491301178*^9}, {
   3.7172265166389427`*^9, 3.717226543221943*^9}, 3.717226695906413*^9, 
   3.7172268727952843`*^9, 3.717231345162293*^9, {3.717231415976781*^9, 
   3.717231416559705*^9}, {3.717231477239808*^9, 3.717231479144586*^9}},
 CellLabel->
  "In[3159]:=",ExpressionUUID->"c272b759-6f4a-4dcf-a725-e87e6311c27b"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.06971009029856`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3161, 251, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229447615505*^9},
 CellLabel->
  "During evaluation of \
In[3159]:=",ExpressionUUID->"e880fb6a-3c43-4c6e-9f4f-4e5a4caa2f75"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.06971009029856`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3161, 252, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229447619985*^9},
 CellLabel->
  "During evaluation of \
In[3159]:=",ExpressionUUID->"197ce58f-9e7d-4f02-9901-6d8d96b67a59"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.06971009029856`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3161, 253, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229447680766*^9},
 CellLabel->
  "During evaluation of \
In[3159]:=",ExpressionUUID->"be5dec08-e3f9-4db7-81fc-e1760f1cd881"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 3161, 254, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229447736862*^9},
 CellLabel->
  "During evaluation of \
In[3159]:=",ExpressionUUID->"8c791a22-5f21-4096-814c-b2f7cab313b0"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlunk4Vfv7gL1Dhso8z/M8FhFqfZ5QiUKiUCGlVFJKUUqbkEpFyVRKRWlS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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{765, 970, 520, 1148, 680, 608, 570, 1008, 900, 803, 
              718, 646, 521, 971, 863, 766, 681}}], 
             PolygonBox[{{962, 1149, 862, 533, 534, 977, 869, 772, 687, 615, 
              577, 535, 978, 870, 773, 688, 616, 578, 1014, 906, 809, 724, 
              652, 536, 979, 871, 774, 689, 1057, 949, 852, 617, 1046, 938, 
              1080, 841, 1070}}]}]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwV0VkrpmEABuDXcmRfT4YysofCiOxOLCcoiikSn+WQX2EvP8O+TFEoQtkO
zNj+iLWMEtd3cHXf9/M8J+/3ZYcmuycigyCIYJFPYzAqCNJkKikkk0QizYyz
RZR3o9ySYC/wQKE9xxtN9gvt+irp0UEwZm8SaY9wQ7w9II8o8ubD7tL/kGnP
2xd6hd4n98nV752f6CV6gaySs/KVRneN9qX+S/6WtfJA5sln9/Xy1C6VbbJa
roS/X466b5DndrnskTVyV/6UG+6P9WI9Qob4R5zzK1npvF8eUqj/d36ml+md
cpsMfc55r75Hjn1n5+szvNBgP9GqL5PqzYjdre+QZa+H/0R9mL/E2u906Fv8
CP8u9i159jTP1NuPtOhLpHgXstf4YsjZNTH6DDfk2lM8UWcP8w2bPEJs
              "]], 
             PolygonBox[CompressedData["
1:eJwV1EVYVVEUgNGH2KLYiNgtomJ3dyuKPXKkGIithDW0O8EeqQNbsbumKgp2
Ys1srHUHi3P+zf744L13qT0pOWFGoVAoFEaCL19ERuFQaDHjw0OhTs6zzobO
77531b25+2DnYaLdl5snup+kjr6ra7kv5TMt9QE+01PvI9LeRL2MO9Q0W8In
WugJLOU2NcwW85F4XcBw9yNU93P260/00HspE/zu+huD9CGqmC3Rt6iuM/gQ
/C16Hx/prvdQ2u44/ZWB+iBRwWuib1JNp/OeZnovH+imdxNhd2zwOnKDGLM0
8mmq9/CernoXpeyP0elcp6pZKu+I07vJp4vOoqT90TqNa0SbLeItTfQu3tFZ
Z1LCfqJODd4/qpgt5A2xOou3dNI7KW5/lF7EFaLMFvCaxjqTN3TUOyhmf6Re
yGUqm83nFY30Tl7TQW+nqP0EvYBLVDKbx8vgc6Z38Ir2ehtF7I/Q87lIRbO5
vKCB3s5L2umtFLY/XM/jAhXM5vCc+nobL2irtxBuf5iey3nKm83mGfX0Vp7T
Rm+mkP2heg7nKGc2i6fU1Vt4Rmu9iTD7Q/RszlLWLIUnwfOiN/OUVnojoeD5
0rPIJtJsJo+prTfxhJZ6A/8YpFM4QxmdTB619EYe00Kv5y8D9UxOU1rPIJea
egN5xOt1/GGATuYUEXo6j6ih15NLc72W3/TXwT+Wk5TS03gYPK96HY9optdQ
QD89nROU1FPJoZpey0Oa6tX8oq+exnFK6CQeEKPXkEOcXsVP+uipHKO4nsJ9
qurVPKCJXskPeuskjlJMT+Ye0XoV94nVK/hOLz3OmR18Jr1//wGh/KZ+
              
              "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwl1WWUVVUYgOGhO6S7Q1KlS+lOQQWku7u7pEu6GyUUaenu7u7u7vY5yx/P
fPvd59y5s/aZu27K+m0qtw4VEhISMXRISDBX+FGLCCzXdcjOOT2QbFzSw/GS
kJW6NhFZoeuSgzCssleHSKzU9cjJeT2I7FzWIwjLal2XyKzS9clFOP61V48o
rNYNyE14IgR/P5GITBTWuK8+UflXNyQPUVlrrwHRWKMbkZdorLPXkOis1Y3J
xwU9mBxc0SOJznrdiBis003Iz0U9hJxc1aOIwQbdmJis100pwCU9lFxc06OJ
yUbdhK/YoJvxznoBvxCG7+1dNoeRm+v6k/kXv/K7/mAuohqhPbhlZji+sISa
wXu4b5PZlFih/n/A/5gbLT+ai4PX2KsevK+5PPg/MZu7/t56IWF1VTOUudQM
b4Y1P/M3NfjB/VfM4eThhh5DLDbrZsRmk25BQWKzxV5z4rBZt6QQV/UI8nJT
jyUOW3UL4rJFt6Iw1/RI8nFLjyMu23RL4rFVt6YI1/Uo8nNbjyce23Ur4rNN
t6EoN/RoCnBHTyA+O3TwYUvAdt2WYtwMnlHwHLmrJ5KAnboNCdmh21GcW3pM
cI7c05NIyC7dlkTs1O0pwW09loLc15NJxG7djsTs0h0oyR09jkI80FNIzB7d
niTs1h0pxV09nsI81FNJwl7dgaTs0Z0ozT09gSI80tNIyj7dkWTs1Z0pw309
kaI81tNJxn7dieTs010oywM9iWI80TNIzgHdmRTs110px0M9meI81TNJwUHd
hZQc0N0ozyM9hRI807NIySHdlVQc1N2pwGM9lZI817NJxWHdjdQc0j2oyBM9
jVK80HNIzRHdnTQc1j2pxFM9ndK81HNJw1Hdg7Qc0b34kWd6BmV4peeRlmO6
J+k4qntTmed6JmV5reeTjuO6F+k5pvtQhRd6FuV4o/8gPSd0b77muO7LT7zU
synPW/0nX3NS9yEDJ3Q/fuaVnkMF3ukFZOCU7ktGTur+/MJrPZeKvNcLychp
3Y9MnNIDqMobPY9KfNCLyMQZ3Z/MnNa/UdgXVzXzrb35/MhHvZjMnNUDyMIZ
PZDqwZnoynyy/osswe/TWTlrPYhfg7PQVfhs/TdZ+UafMwdTIzhD/cVcElzj
W33eHELN4Mx08OX+T3CN76wvmEOpFVzSS4N9LjKM2oS2v8wMb2Yz/wNvhQI+

             "]]},
           Annotation[#, "Charting`Private`Tag$1252729#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV0dlKVVEABuDlUKBlg2lFCilqKVY0UWlqKjR4kcIpSlBMTw51ky/gZakN
z2HOAxYVJJY0CJbzgzhUpNDw7YuP///XXnDY++TGO2OPEkII03Qlh9CfGEIz
pawlhfCYPObtblKYs+/xVx/gDy1cZt35E/JZsHtI5ZvdzD99kDjpfq/P2VXW
7DI29G4KWLR7OeLeqH2T3/YuvustBIbso+5M6jHu2wfsl/o11u1yNvUejrFk
57nzRr/DUzvLHtNrOa1/klvOC/X3egPn9Vm52/m8jJNAsfNpOew8R3+ll8hb
8oz8LMtlq+cZ0Xe2L8rr8qT8KMvkhucF8p1dKuvlOflVVsgKz3/ovVywj8sT
8oNc9ixff6vf5az+RT5znq2P63Vs20X2lN5Imr0QfTcSGbHbyHRnwL7Bpn2F
n9G3opAV+zl7WLRbSWLUbqeSvexjf/R/R/9L9P40uZcpD7Kkt5HMmN1BFYdY
dtbODsbtB1TzK3ovili1X3CYFbuDnUzYud7htX6bh9Hv2YP6JVkjT8kZ+R+c
Y1jg
             "]], LineBox[CompressedData["
1:eJwV1EVYVGEUgOFri4WtKAh2gN3dXdi5cmWCBXYvTQxARDBX6sLubt3aAbaI
uLP7ncU7//+d5zyzuXem9pTEkQmFgiCI9/G5cBA0KBoEZ4oEwQR662/OtTTh
vl5PBPf0VEpwRE+nD9/1OmJ5oDdQg/t6GiU5qmfQlx96PXE81BupyQM9nTCO
6Zn046feQFMe6U1E8lDPoBTH9Sz680tvpBmPdQpRPNIzKc0JncAAfutNNOeJ
3kwtHutZlOGkTmQgf3QKLXiqtxDNE51AWU7p2Qzir95MS57prcTwVCdSjtN6
DoP5p7fQiud6G7V5pmcTzhk9lyEEnt9Ws9bk6FTq8FzPoTxn9TyGUsj+NrM2
5Oo06pKj51KBc3o+wyhsP9WsLS90OvXI1fOoyHmdxHCK2E8za8dLvZ36vNDz
qcQFnUw8Re2nm7Xnlc4IvZO81ElU5qJewAiK2d9u1oHXegcNeaWTqcIlvZCR
FLefYdaRNzqTRrzWC6jKZb2IUZSwv8OsE2/1ThrzRi+kGlf0YkZT0n6mWWfe
6Sya8FYvojpX9RLGEGZ/p1kX3utsYnmnFxPBNb2UsZSyn2XWlTy9izje6yXU
4LpexjhK288268YHvZum5Oml1OSGXs54ytjfZdadfL2HZnzQy4jkpl5BNbsH
9CC+6AmUNdute/BR76U5+Xo5UdzSK6lu96AezFc9kXJme3RPCvS+0O/V7LCO
55duwUf3FdTitl7FJFpSYLaSaO7o1Uwm3PfsNevFJ72fVnzSq4jhbuj3Yu+E
+xjW6Ah9yH1I6H/B/arzW+g9cz8betbOic7/jlOldQ==
             "]], 
            LineBox[{1087, 605, 1040, 932, 835, 750, 678, 563, 1006, 898, 801,
              716, 644, 606, 564, 565, 566, 567, 568, 1007, 899, 802, 717, 
             645, 607, 1041, 933, 836, 751, 679, 1054, 946, 849, 764, 1066, 
             958, 861, 1077, 969, 1088, 569}]},
           Annotation[#, "Charting`Private`Tag$1252729#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{1096, 1146, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 
             1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114,
              1115, 1116, 1117, 1118, 1119, 1120, 1121, 1122, 1123, 1124, 
             1125, 1126, 1127, 1128, 1129, 1130, 1131, 1132, 1133, 1134, 1135,
              1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1147, 
             1145}]},
           Annotation[#, "Charting`Private`Tag$1252729#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{1091, 1095, 1090}], 
           LineBox[{1093, 1094, 1092}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlvHk0Ve3//3+Uucwyz/NYqKhoX68GFSoqhCaRMqeSMTlkqihEhjIkylDS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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{1120, 1122, 500, 944, 839, 744, 661, 588, 550, 982, 
              877}}], PolygonBox[{{937, 1123, 1121, 513, 514, 951, 846, 751, 
              668, 595, 557, 515, 952, 847, 752, 669, 596, 558, 988, 883, 788,
               705, 632, 516, 953, 848, 753, 670, 1029, 924, 829, 597, 1021, 
              916, 1052, 821, 1042}}]}]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwV0VtLE2AABuBvbpBBtplZVCitG0u7SYUUgwoSPHT0F6g/wJmd/kYqbmuD
FJQUtMDjTQf7F6VBB0ihtO5My9V6dvHwvu/37bxkf6pnoCyEEGGM3lgIfQSH
RYf/+EuBfc477yHPT25EQ1jhj7tH9luq7CE+0GB/oVkfpcAdO8cPrtvL/Pb8
djlFhfffdNeqZ4nYD+0r+jjl9qo9rSf0I/KkvCvXqXd3xn6uH5NXZa2ckAfl
Z/en5YxdKZvkKTki97ntPmnP6dXykqyReRmTT9w/0+P6tn5CdttL7PkeL+Rx
Z9fkJIf0DY+b1Y/qLTJD0B84v6w/5YD9xq7UB1njnP2JRn249Dtzy26TOaKe
k7W36LIX2fUZvtoX9TRF7tuvSegp3nPW/sgF/XHpP+CmneE7nfYCv7zePfsV
cXuAd9SV/n/SfKPD2Tw7Hj9kv+Sw/R/c80w9
              "]], 
             PolygonBox[CompressedData["
1:eJwV1EVslFEUgNEBSnGnuBV3d4diCSvcpaXFZYO70+KQsCS4uxPc3V2Cu7vr
+Rdn3v3uLCZv8s9Exgxo3j9xKBRKRFMvD0VsWCgUR1SSUCivc7EzlfOR91ab
M5krO+fxlwH2tZ3zCffeTp3K3JvL5NFzuU1pPYOvNNHBh+8gpe7FJXLrOdyi
lJ7OFxrrfmwnhe7JRXLp2dykpJ7GZxrpvmwjue7BBXLqWdyghJ7KJxrqPmwl
me7OeXLomVynuE7gIw10b7YQruM4R3Y9g2sU0/F8IEr3YjNJdSxnyaanc5Wi
egrvqa97sokw3Y0zZNXTuEIRPZl31NM92EgSHcNpsuipXKawnsRb6urubCCx
juYUETqBSxTSE3lDHR3HehLprpwks47nIgX1BF5TO3iWWBc8YLoLJ4LnR0/h
AgX0eF5RS3djLf/obHecjObJnCe/HsdLauoY1vCXTnbHyGCexDki9VheUENH
B88wf+hod5T05omcJZ8ew3Oq666s4jcd7I6QzjyBM+TVo3lGNd2Flfyivd1h
0prHc5o8ehRPqRrckRX8pJ3dIdKYx3GK3HokT6gS3JHl/KCt3UFSm8dyklx6
BI+pHNyRZXynjd2B4LdsHsMJcurhPKJScEeW8o3WdvtJaR7NcXLoYTykYnBH
lvCVVnb7SGEexTGy66E8oEJwRxbzhZZ2e0luHslRsukh3Kd8cEcW8ZkWdntI
Zh7BEbLqwdyjXHBHFvKJ5na7CTcP5zBZ9CDuUja4Iwv4SDO7XSQ1D+MQEXog
dyij6zsXBd+J/7n/O0KmoQ==
              
              "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV1WO0XVcUgNE0tm2bjdUYjW00ZmPbTtrYTpkitm3bNorUnPvHvGt9+477
3hvnnDtehrY96/V4L0KECO+8hLnMSzV+sX9GMwoSkUhEJgpRiUZ0YhCTWMRm
uc9X51f75zSnEHFY4bwGv9m/oAWF2e+sJ6k5pUcTl5W6Jr/bv6QlRTjgrBdp
OK3HEI9VuhZ/2L+iFff1TMrygy7KQXtv0nJGjyU+q3Vt/rR/TWse6FmU40dd
jEP2PqTjrH5izqMy4/Qjcw4VeMlifnb+zFxAVV6zlATO15h1eMNf+rm5MPw+
1urH5tzw91OJVywJP5OPvP/QnM1byvOCRfwUeP+pOZ8qFNeHzb6k55weT8Jw
z3Vd/rZ/QxtKcMRZPzJwXk8gUbi/uh7/2L+lLSU56qw/GbmgJ5I43HNdn3/t
39GOUhxzNoBMXNSTSBLuuW7Af/bvaU9pjjsbSGYu6ckkDfdcNwwPMuuMDnzA
CT2ILFzWU0gW7rFuFJ591uuOlOGkHkxWruipJGetbkxENuhOlOWUHkI2rupp
pAjXUDchEht1Z8pxWg8lO9f0dFKGa6ibEplNugvlOaOHkYPregapwjXUzYjC
Zt2VCpzVw8nJDf0JqcM11M2JyhbdjYqc0yPIxU39KWlYp1sQja26O5U4r0eS
m1t6JmlZr1sSnW36YypzQY8iD7f1LNKxQbciBtt1D6pwUY8mL3f0bNKzUbcm
Jjt0T6pySY8hH3f1HDKwKXw/iMVO3YsPuazHkp97ei4Z2azbEJtdujfVuKLH
UYD7eh6Z2KLbEofdug/VuarH8z4P9Hwys1W3Iy57dF9qcE1PoCAP9QKysE23
Jx57dT9qcl1PpBCP9EKysl13ID77dH9qcUNPojCP9SKysUN3JAH79QBqc1NP
pghP9GKys1N3IiEH9EDqcEtPoShP9RJysEt3JhEH9SDqcltPpRjP9FJyslt3
ITGH9GDqcUdPozjP9TJysUd3JQmH9ZBw3fyTqm/edTadErzQy8nNXt2NpBzR
Q2nAPT2DkrzUK8jDPt2dZBzVw2gYvlO6FK/sK8kbnnednGP24TQK3yVdmtf2
VeQLz7lOwXH7CBqTn5TOTpgjacIH+o25mgKk0ifNUTSljH5rrqGi/V14vsNz
Z/4P7BT3FA==
             "]]},
           Annotation[#, "Charting`Private`Tag$1253383#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV0utPjmEABvD7rSw2pJzm1OSDyGFDhmGyMUVnfK++K8rpz1BRqcTGxByW
5DTH/gkRozbMMdkKUfK7P/x2Xdf9vE/v875vWVU15dWJEEIvI0pXcgh7+JgU
whkKWc5zZ4eoSAlhpnzorJZR99yy8/lkN1FENn3OqknjkV3HT6/vtgv4bDdT
zJh9inW8sVfwQq9hFo/to0zqTWzinf3L37ut7+WL3UKyZ2y1t1Ji/5H1rOet
vZKX+mHSeWKnuqdD38ExO9jN+mbm6Nfke+fT9Yv6LubrN+Vvz9Aj97HA2Vev
S5OX7bN6it6mL5Hb5Fx5XWbJUtf/6g0ssjfEZ5JX5FI54Po0ecHOlDvlPHlD
LpM5rvfrR1hoZ8TvS3bKp65N1c/reRy3E3aLvoUP9gz7kr6bMZ/jjizkm2ut
lDFuN5LLoL2KV3ots3lmn4jfs/vv2kUM2W2Uszp+RtfGmeAfk/Gfznml90/I
JO65r5jvejv7WRN/T+7H35Jh/RwHWMtrZ3XxN6LXPhm/bx7YpfzQO5jifdrt
7Ry0J+RpFjvfKDPkVfkfUHhhKA==
             "]], LineBox[CompressedData["
1:eJwV1EVQlWEYhuHfQrEVu7u7u3Npo2BhYOLG7g6wZ1w6dmG3Y3cnto7d3Z0X
i+t8z/2eHTOHglGDWsckCYKgpY+HSYMgdfIgWJIsCBpRXt/xDiYrh/UIUrBb
t+KjvYj2VOCu2xCycUSPJIQ9ujWf7MV0oCL33IaSnaN6FCnZq9vw2V5COJW4
7zaMHBzTo0nFPt2WL/ZSOlKZB27DyclxPYZQ9ut2fLWX0YkqPHQbQS5O6LGJ
fxMO6PZ8s5cTQVUeuY0kNyf1ONJwUHfgu72CSKrx2G0UeTilx5OWQzqcH/ZK
OlOdJ26jyctpPYF0HNYd+Wmvogs1eOo2hnyc0RNJzxHdiV/2arpSk2duY8nP
WT2JDBzVEfy219CNWjx3G0cBzunJZOSYjuSPHU93avPCbTwFOa+nkInjujN/
7bVEUYeXbhMoxAU9lcyc0F34Z6+jB3V55TaRwlzU0wjjpO5KwHrdk3q81pMo
wiU9nSyc0t1Iwgbdi/q80ZMpSoKeQVZO6+4kZaPuTQPe6ikU47KOJRtndBTJ
2KSjacg7PZXiXNFxZOes7kFyNus+NOK9nkYJruqZ5OCc7kkKtui+NOaDnk5J
rulZ5OS87kUIW3U/mvBRz6AU1/VscnFB9yYl23R/mvJJx1KaG3oOubmoo0nF
dj2AZnzWcZThpp5LHi7pPoSyQw+kOV/0TMpyS88jLwm6L6nZqWNowVc9i3Lc
1vPJx2XdjzTs0iH+zy206zFI//UuoBphvov3Pkr8LdtLE38f3sbe/50vpcw=

             "]], 
            LineBox[{1059, 585, 1015, 910, 815, 732, 659, 543, 980, 875, 780, 
             697, 624, 586, 544, 545, 546, 547, 548, 981, 876, 781, 698, 625, 
             587, 1016, 911, 816, 733, 660, 1026, 921, 826, 743, 1038, 933, 
             838, 1048, 943, 1060, 549}]},
           Annotation[#, "Charting`Private`Tag$1253383#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{1068, 1118, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 
             1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086,
              1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 
             1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107,
              1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1119, 
             1117}]},
           Annotation[#, "Charting`Private`Tag$1253383#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{1063, 1067, 1062}], 
           LineBox[{1065, 1066, 1064}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxM2nk8Fe37B/BTqWhBtoQkoSKhRbTMPYoWChWFkCRU1nhskcNBkmTJvguJ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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV0LkuBGAYheGfQWe7AVuJ0tBICIVdYS8kQiJRWGINCYML4ApsDUo6FYmx
FmKikAxGZetttUfx5j3n/N/MJFM8NNExnh5CSMM81jNDWMOp8SUjhE4kIyFM
oQCf9mzvS/Z0bNgaEbe/6l140KdRiKjbXVspzvUvdzm2mB7Bpq1NP5br0KTX
6AdyBYble76198pXcivG5Gc+831v3I1J26O7fr7RF3lGb+AjfY6reYSTvMxF
3it5T5/mMh7kO47xhfcOjusL3MCjnOJvv50rL8sZGJATvOUz7fKJXI9mvVY/
lKNI6H36tdz2/7/4nnfuwZO3WRSjys2+rRyX+o+7PNuKnoltWwsu7B96L1L6
HErwa893v2rPwo7tD2DgPzg=
             "]]]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{702, 1423, 1421, 753, 797, 881, 983, 1106, 1250, 
              704, 703, 752, 796, 880, 982, 1105, 1249}}], 
             PolygonBox[CompressedData["
1:eJwV0MlLVXEchvFfE80bs2EbzUVlLUotGzW0zLFFWpoYFBYohKFls02r6F9o
HqyFDdCwKClySrFrFBVpI9jcLtOKPmfx8L7Pe7/nHjgTSyvyygeGEAYghhND
QjiJzsEhbJbzZaW8KlPkrEEhHJQv+Ta5TFbLu3KN3O/3dr1Y/6iX6D/R7iXd
ssKeLVtQqD9181zfqifLm0jT8+2r9Abk8gt8tH4cE/g//9dqm8evYLFtJl+q
38Fqvo9/wCb+A22e6eRJ+g2kusnj5zGKH8N42193LbYEXodFthl8L96j2PYd
j93l8nMYyY9inNs/9um2PXiHIvs3tNpz+FmM4Ecw1n2/fZqtBm+x0f41+kb2
Pky17cYbbLB/QbM9xhP161gZfVeept9HDj/Dh+uHEc9/eyZDf4h1vNnvMb1U
nysvI1mfYj8gX/AyuURWydsyQ+6KvoVs40Wym++Qhfwzmrynlnfp5TJL1kTv
kwXyiftn+hZ9odwpr8kV0a3fXunb9VR5D9n6aXuHXqIPk7UYo/d6V7r+APm8
yd0c/RKS+GSeot9COq/mXSjgn9Do+Q6+QK/Hcjdr+SkM5YcQZ/vlrtE2m19E
om0Sr8JrrLf14JG7TP4fya9w9w==
              "]], PolygonBox[CompressedData["
1:eJwV0UVQVQEYhuFD2YqNDSh2d7du1JUjdiI2druyO0HFrpXd3S50pWNhd3d3
4uPiuee83/1n7jDEJgxtOyQ0CIIQWvs4GxYEiyKCIJnW4UEwwfOMZ3vPc75L
857ovbrndhp5b2lv6v0obfRync4EnUU/9wOD9SlK2zZQzV5At2AZfxlvz2x/
5j5Jn6SUbT1V7VG6Oan8YZw9k/2p+0H6BCVt66hiz6+bsZTfjLVntD9xP1Af
J862lsr2fP//DpbwizH2DPbH7gfoY5SwraGSPa9uwmJ+MtoeYX/kvr8+SnHb
aira8+jGpPCDUfZw+0P3/fQRYm2rqGDPrRuRzHdG2sPsD9z31YeJsa2kvD2X
bvj//8c3RthD7ffd99GHiLatoJw9p27AQr4y3B5iv+c+UR+kmG05Ze2Ruj4L
+MIwe2C/6763PkBR2zLK2HPoesznM0Pt6dxxn6D3U0SnUtp9dl2XeXxiiP0v
t9330vsorJdSyn02XYe5fGSw/Q+33PfUeymkl1DSfVZdmzl8IMn+m5vue+g9
FNSLiXOfRddiNu8ZZP/FDffd9W4K6BRKuM+sazKLdwy0/+S6+256F1E6meLu
M+kazOQtA+w/uOa+q95Jfr2IWPcZdXVm8Ib+9u9cdd9F7yCfXkiM+wy6GtN5
TT/7N66476y3k1cvINp9hK7KNF7R1/6VNPed9Dby6PkUcx+uqzCVl/Sxf+Gy
+456K7n1PIq6D9OVmcILEu2fueS+g95CLj2XIu5DdSUm85ze9k9cdN9ebyan
nkNh9yG6IpN4RoL9Ixfcx+tNROrZFHIf6ApM5Cm97B84776d3kgOPYuC7tPt
rbyfJl7/A/stoPE=
              "]]}]}, {}, {}, {}, {}, {}, {}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
            1.], LineBox[CompressedData["
1:eJwd1ne8zmUYB+BjZWZn7713SFZUIntTyt7ZLWRnq2Rl771LGoiG2aAooyij
EKEdKl13f1zu+/v9vcfH8Z7neU/+zv2b90uUkJCwO3FCQsx85kzLBjOnOde8
m+286fl485Z+qznaXG5mpaNnT5uXdQNYZM9IKvt0MxlT7RW9rpH9ffsjnJOn
yglMkKdZR9h/sT9PpkT/P0rI749Z9lxslztRicb6D3T1OS+/RBIK6GfrcvOW
3Jl7aaL/UNeAC/LLJKWgfo4uD2/LXXhG96M8kNRU1jXVfWR/lO/lVxip+1Ue
SmaS6QrpXrPn5R15gnzbPoau8rPyFfsgFtszkcb+qnkX0+xrzFxU8fpm5l5d
QxbY0/ODflq8b7zORM9WmTl4l+mejzJ/028xh5lLzXt4J6Y8y0wZ7y2vyOvM
POyMf4evL2zO1W8085nzzLTx93s20fxbN5YV9mx00z9nXtUN5m5myMl5yV7V
8+b2ffZGXIz3TE7MpPj+5dH23+3DyUJyXRHdPHt+dsjduY8W+v26xlySZ5CC
ovr5ugLslHtQjZQU82yBviC75J7cT0v9AV0TLsszSUVx/UJdId6Te/G87id5
CGmprmulO2hvyo/yLFJTQr9IV5jdcm+G6q7JT5OOGrrWukP2ZlyRZzNG94f8
AllJoyupW2wvwh55kvyPfRx95GHydfszpKemro3uY3tzrsbPvZyEyfIceaz9
T/sIsjE7zm78DMV76Hkp+xJ7Uebb08UZ1k82/9W9yEp7dvrqh5s3dJvNZ80l
ZmbeJoM800zBNl6W15q52UEtX9/W/ES/yWxhLoyv4634f49zZyblDaZ4vjru
qzhzno0z/9KNZJk9S/y74vs0U/NqvGdeV9q+1F6MD+Qp8h37eJ6SX5B/tj9H
Rmrr2uk+tbfkmjyXdJTRL9MV50O5Hw+QngxxVlwKGc1MZKas1y/32hJ8JPen
DvdQzrMV+pLslQdQlyyU92ylvhT75IE8SFYqeLZKX5r98iAeor3+M10rrsvz
yEZF/WpdGQ7Ig3mYx/SHda25Ic8ne9y3+jW6shyUh1CPx/VHdG34WV5Ajrhv
9Wt15TgUnw88Qgf957q2/CIvJCeV9et05fk47l/q84T+C107fpUXkYsq+vW6
CnwSdyoNeFJ/VNee3+TF5KaqfoOuIp/GPcWjdNQf0z3G7/IS8sT9ot+oq8Rn
ceZpSCf9l7rH+UNeSt64X/SbdPdyOM44jeis/0rXgT/lZeSLO0e/WVeZI3Fu
aUwX/XHdE/wlLyc/1fVbdFX4PM4YTeiqP6F7kpvyCgpQQ79VV5Uv4ueZpnTT
n9R15Ja8koLUjM8R3X0clUfQjO76U7pO3JZXUYhacf501Tgmj6Q5PfRf6zrz
t7yawtSO8667ny/lUbSgp/4bXRf+kddQJM5PfC7F3cpX8mha0kt/WteVf+W1
FI3zo98edynH5TG0orf+jK4bd+R1FIszFfdJ3I+ckMfSmj76b3XdiV+K1hvF
45zF/SXX4qQ8jjb01X+n60EiNuhKxNmLz9m4Nzglv0hbntKf1fUkMRt1JePs
xeeq/ABfy+Pja9wb7cx+np3T9yJJ3Iu6UnH+4s6U6/CNPCHOO/3153W9SRr3
sK50nL/4bJfrclqeGOedAfoLuj4kY4uuTJw//S75Qc7Ik+K8M1D/va4vd7FV
VzbOn/49+SG+lSfHeWeQ/oe4V0nO67pycf70u+WH+U6eEuedwfqLuvjlNAVv
6MrH+dPvketxVp4a550h+ku6/qRkW/zf6W7aR5GD1+Q0zIj31Mwb3xsVvPY/
mupLOg==
             "]]},
           Annotation[#, "Charting`Private`Tag$1253434#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
            1.], LineBox[CompressedData["
1:eJwV1Pd3T3ccx/FrtRQ1W36w1apVjj1jBNEIYsRucWjtvSVi+4W/wKgZq6eL
g/aUkBCJ2K1Na+/Vmi2Ox+eHZ17j/b735tzvvbfysAmJ4/NEUZTkz968UXQ1
fxT1xJl8UTQR5fBEvw/puGaWiLP6SSiPp/rlBaJoP71u1gvn9JNRAf/oi5on
6/Nipa4LDuhvyL1xXp6Cimhsd6Puc2TK/9r7WJci58MqXTf5d7494uS28g98
I4zg/6TH9El8Fh+PcfxlmuF8N2kfTNJdsDeI5spz6VS5M90lT6et6Lf0HJ1H
K5k3oZvkKbQ2HUpP0hR60DyRHpBn0c50LL1En7l2MX4enx9f8cfpasck8Hv5
Dugqx8g/8o1xXO4nH+a7hfviPLdoX1w0m4bKaGonTVcHh+Tn9orrUuUCWKP7
Egf1t+UkXJKnowpe6EvYn6//AN/pVsjx9JDZHV0/XJZnoCqamW/W1UWW/NJe
Sd0C+UOsDb8X2ul+kpvghJxl7y7fH1fkmeG5sLNbbo3P5ObyFr4eDsu95Ay+
C145vpS8kC+Ir/kTdJ297vw+viPG8Bdpgr49/zM/jTalI+kZetKsP5/Nz6EJ
dDy9QheG++5a9/gBmCz/ZX8wPSon01lyHN0jz6Bt6Ch6nqbSauYt6Fa5Pobx
p2i2vjefGZ5jvHad0vIivhDWm/eQ0/lYdJc7yL/wzXBKznbMfX4g/pZnozr+
0+fggX4QrurmoAb+13/iPIv1H2FDuA6O6B/Kg3FNnouaeKP/1P4SfWFs1PVE
rv6RPATX5WTUQku723RfIEd+a6+MbqlcBJvCO4KOuh1yc5yWj9p7HN4L3JBT
0NXOr3Lb8E2QW8nb+QY4Ir9zTFndMrko0sL/Fr5HfKfwPZJj5Z18C3zDn6V/
6AfwOeG+YkL4XcN3w/mehOcJN+0M0R8L7354d/jf+Jk0ho4O3w86P3wHzFvT
7+WptCEdTk/T95dmtdQ=
             "]], LineBox[CompressedData["
1:eJwV1DVwFQEYhdGNETS4a3B3dy2QisGd4O5a4RYS3J0Kd3cKqGBwd3d352xx
8va7+SdFZvbFJwxpOTgiCIKmfpyJCoLWMUFwKjoImvEvMghy6pme49jg9604
Z/+gu/NUT6A0Abncz7KnZ2P49zjv/qNO4JmeSBkiyO0+0Z6BTboNF9x/0j14
ridRlkjyuJ9tz8hm3ZaL7j/rnrzQkylHFHndJ9kzsUW345L7L7oXL/UUyhNN
PvfJ9sxs1e257P6r7s0rPZUKxJDf/Rx7FrbpDlxx/0334bWeRkVSUMD9XHtW
tuuOXHX/XffljZ5OJWKJdz/Pno0duhPX3P/Q/XirZ1CZlBR0P9+enZ26M9fd
/9T9eadnUoVUFHK/wJ6DXboLN9z/0gN4r2dRldQUdr/QnpPduis33f/WA/mg
E6lGGoq4X2TPxR7djVvu/+hBfNSzqU5airpfbM/NXt2d2+7/6sF80knUIB3F
3C+x52GfTuCO+396CJ91MjWJo7j7pfa87Nc9uOs+sA+1fdFzqEV6StiX2fNx
QPfknvsI+zDbVz2X2mSgpH25PT8HdS/uu4+0D7d90/OoQ0ZK2VfYC3BI9+aB
+yj7CNt3PZ+6ZArfM/tKezyHdR8euo+2j7T90AuoR+bwPbOvshfkiO7LI/cx
9lG2n3oh9ckSvmf21fZCHNX9eOw+hX207ZdeRAOyhu+ZfY29MMd0f564j7WP
sf3Wi2lItvA9s6+1F+G4HsBT9yntY21/9BIakT18z+zr7EU5oQfyzH0q+zjb
X72UxuQI3zP7ensxTupBPHef2j4+/E7Ty2ihj+gGNAn/v3qb50rh94jnyz7P
2tt4Pu15vM/mPv8DMEyfwA==
             "]], 
            LineBox[{1410, 793, 1331, 1187, 1064, 962, 878, 745, 1291, 1147, 
             1024, 922, 838, 794, 746, 747, 748, 749, 750, 1292, 1148, 1025, 
             923, 839, 795, 1332, 1188, 1065, 963, 879, 1350, 1206, 1083, 981,
              1371, 1227, 1104, 1392, 1248, 1412, 751}]},
           Annotation[#, "Charting`Private`Tag$1253434#2"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{1415, 1420, 1414}], 
           LineBox[{1418, 1419, 1417}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{4}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.7172220618602667`*^9, 3.717224326594858*^9, 3.717224360145022*^9, 
   3.717224792618148*^9, {3.7172248282275763`*^9, 3.717224844313326*^9}, 
   3.717225059258835*^9, 3.7172251162434607`*^9, 3.717225385193626*^9, {
   3.717225466774629*^9, 3.7172254923840322`*^9}, 3.7172257197586317`*^9, 
   3.717226050221052*^9, {3.717226520809215*^9, 3.7172265440303173`*^9}, 
   3.717226716234664*^9, 3.717226879000009*^9, 3.717231292497889*^9, 
   3.7172313521607122`*^9, 3.717231422932979*^9, 3.717231480111175*^9, 
   3.7172350365070877`*^9, 3.7386097553933496`*^9, 3.793502843253357*^9, 
   3.79350404828423*^9, 3.793904845015793*^9, 3.8232294478799877`*^9},
 CellLabel->
  "Out[3164]=",ExpressionUUID->"b81ff410-a80d-4bb2-8692-73d3cdc1fce4"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"8656cdca-d40a-412a-b04a-e6272521e665"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dt", "=", "0.05"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datkappa", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Kappa]1a", "/.", 
           RowBox[{"\[Theta]", "\[Rule]", 
            RowBox[{"\[Theta]0", "[", "t", "]"}]}]}], ",", 
          RowBox[{"\[Kappa]2a", "/.", 
           RowBox[{"\[Theta]", "\[Rule]", 
            RowBox[{"\[Theta]0", "[", "t", "]"}]}]}], ",", 
          RowBox[{"\[Kappa]opt1a", "[", "t", "]"}], ",", 
          RowBox[{"\[Kappa]opt2a", "[", "t", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "\[Tau]1", ",", "dt"}], "}"}]}], "]"}], "//",
       "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dat", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Through", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "\[Theta]0", ",", "u0", ",", "\[Theta]1", ",", "\[Theta]2", ",", 
            "u2", ",", "\[Theta]3", ",", "u3", ",", "\[Theta]4", ",", "u4"}], 
           "}"}], "[", "t", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "\[Tau]1", ",", "dt"}], "}"}]}], "]"}], "//",
       "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Export", "[", 
      RowBox[{"\"\<pendulumFBk.dat\>\"", ",", " ", "datkappa"}], "]"}], ";", 
     RowBox[{"Export", "[", 
      RowBox[{"\"\<pendulumFB.dat\>\"", ",", " ", "dat"}], "]"}], ";"}], " ", 
    "\[IndentingNewLine]", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.7167394002782793`*^9, 3.7167394007756653`*^9}, {
   3.716739480630252*^9, 3.716739620038939*^9}, {3.717235078875971*^9, 
   3.717235110858979*^9}, {3.717235145756361*^9, 3.717235260101819*^9}, {
   3.717235290174872*^9, 3.7172352963810987`*^9}, 3.793502814277506*^9, {
   3.7935040545937757`*^9, 3.793504064857766*^9}, {3.793904837765193*^9, 
   3.7939048380386868`*^9}},
 CellLabel->
  "In[3165]:=",ExpressionUUID->"c8960ba3-09c6-4bb6-826b-0e5b38360370"]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 194}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"aa462fb8-69b6-4376-adca-2304e3c3e908"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 847, 14, 105, "Section",ExpressionUUID->"c2f1811f-5d39-4870-bd7a-071084aa3a3d"],
Cell[1430, 38, 9726, 252, 656, "Input",ExpressionUUID->"6e42687c-bd84-429b-9901-9da7fec5d545"],
Cell[11159, 292, 401, 9, 76, "Text",ExpressionUUID->"291c1013-9723-4bbf-bdf6-0ec48ff3a54f"],
Cell[CellGroupData[{
Cell[11585, 305, 2999, 81, 199, "Input",ExpressionUUID->"03e0d4f6-e531-4b5f-ab2e-1a3e95fe7d1f"],
Cell[14587, 388, 488, 10, 39, "Message",ExpressionUUID->"0cce3e3e-f61c-484f-9c56-451cb5b79116"],
Cell[15078, 400, 488, 10, 39, "Message",ExpressionUUID->"6df43078-3e59-4cc4-aac3-8429fb4e5d38"]
}, Open  ]],
Cell[15581, 413, 556, 11, 76, "Text",ExpressionUUID->"cef80cf4-d7d3-4045-a5b9-b38502d93e2f"],
Cell[CellGroupData[{
Cell[16162, 428, 6439, 159, 362, "Input",ExpressionUUID->"9feaa965-6c5e-433b-9cc7-a1ba3b998866"],
Cell[22604, 589, 488, 10, 39, "Message",ExpressionUUID->"37ddb520-40a3-47b8-a890-27d6ad96512c"],
Cell[23095, 601, 490, 10, 39, "Message",ExpressionUUID->"3be97d66-660d-4455-9a37-9d26fe550369"],
Cell[23588, 613, 488, 10, 39, "Message",ExpressionUUID->"b8324f45-ce78-4dc3-8bb7-30446307f02a"],
Cell[24079, 625, 472, 10, 24, "Message",ExpressionUUID->"6d5462be-6358-4f53-b73c-1ef741a1c373"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24588, 640, 355, 9, 30, "Input",ExpressionUUID->"c2be2ada-e7b4-4fc2-9efd-840145fc75af"],
Cell[24946, 651, 63206, 1092, 137, "Output",ExpressionUUID->"d562a01b-d6ce-4946-9e3d-64348144cf00"]
}, Open  ]],
Cell[88167, 1746, 533, 8, 52, "Text",ExpressionUUID->"b346cb89-2ad2-41d6-a092-befc09aae36c"],
Cell[CellGroupData[{
Cell[88725, 1758, 1236, 39, 91, "Input",ExpressionUUID->"d092d732-dee0-474b-a760-f9e210498dce"],
Cell[89964, 1799, 1846, 47, 84, "Output",ExpressionUUID->"b8aa1273-e148-461d-8bdd-45a4b796cf4c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91847, 1851, 1630, 48, 94, "Input",ExpressionUUID->"d1ba565f-25de-46fa-a69d-fa7793e703ec"],
Cell[93480, 1901, 1810, 48, 75, "Output",ExpressionUUID->"42b273cd-9319-41df-b4f2-143622e04792"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95327, 1954, 519, 12, 30, "Input",ExpressionUUID->"2fcb23c4-2498-46fe-ab81-b6f2873be3eb"],
Cell[95849, 1968, 1525, 34, 44, "Output",ExpressionUUID->"4d53edac-da16-4529-9e7d-bac40bca0e2e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97411, 2007, 1814, 46, 122, "Input",ExpressionUUID->"2688b364-c339-4045-9531-9610abd9cafd"],
Cell[99228, 2055, 38475, 676, 145, "Output",ExpressionUUID->"c38af4e5-881e-4025-87da-7b4309b96e8f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137740, 2736, 8271, 214, 442, "Input",ExpressionUUID->"af7b3276-2a0d-4886-abb6-ec8eea8ac5ba"],
Cell[146014, 2952, 489, 10, 39, "Message",ExpressionUUID->"95c98fc4-5c4a-43f4-944b-99d5dc9de64b"],
Cell[146506, 2964, 489, 10, 39, "Message",ExpressionUUID->"97b98f31-c7e0-477b-ba4f-72600ec78448"],
Cell[146998, 2976, 489, 10, 39, "Message",ExpressionUUID->"68a9f9bb-241e-41e7-8f17-4ef37c589890"],
Cell[147490, 2988, 472, 10, 24, "Message",ExpressionUUID->"330746ba-1886-4cda-b3ec-c7872e85c55d"],
Cell[147965, 3000, 86806, 1487, 137, "Output",ExpressionUUID->"6c0c6ea8-d0cf-4b32-ad78-f9e10968efbb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[234808, 4492, 186, 3, 30, "Input",ExpressionUUID->"b5a96ea6-7ade-4a93-95ca-7b787f166ecb"],
Cell[234997, 4497, 611, 14, 37, "Output",ExpressionUUID->"13e231d6-4bae-428d-92d1-978a1ce5544b"]
}, Open  ]],
Cell[235623, 4514, 634, 12, 52, "Text",ExpressionUUID->"dd3856e6-c205-4ab4-a6d5-859106db8b08"],
Cell[CellGroupData[{
Cell[236282, 4530, 439, 12, 30, "Input",ExpressionUUID->"c1f775ab-4d59-4797-9419-aef8385f3a6d"],
Cell[236724, 4544, 728, 15, 38, "Output",ExpressionUUID->"c5fe5b52-02bf-49ed-91b7-3e63118eb370"]
}, Open  ]],
Cell[CellGroupData[{
Cell[237489, 4564, 502, 14, 30, "Input",ExpressionUUID->"907e0de8-41fc-428a-984d-486dd436451b"],
Cell[237994, 4580, 876, 19, 38, "Output",ExpressionUUID->"accba4a6-46d0-4c37-a63e-a6335ffe337d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[238907, 4604, 4850, 135, 266, "Input",ExpressionUUID->"bd7e6200-f42c-4462-ac3e-73529be95840"],
Cell[243760, 4741, 453, 10, 43, "Message",ExpressionUUID->"092bcf4f-c3c5-477e-bd60-123fe48ce741"],
Cell[244216, 4753, 451, 10, 44, "Message",ExpressionUUID->"75621739-4e1f-4eb3-96f7-598d51f65be6"],
Cell[244670, 4765, 451, 10, 44, "Message",ExpressionUUID->"4965f9b3-8e7a-4cc0-80cb-64b9e6285b5a"],
Cell[245124, 4777, 458, 10, 24, "Message",ExpressionUUID->"c01ec6e0-52b7-4ca3-8232-c1c261d2aed9"],
Cell[245585, 4789, 35769, 628, 139, "Output",ExpressionUUID->"4e5e1838-cfd8-4f7f-b2df-42ab67e1ca05"]
}, Open  ]],
Cell[CellGroupData[{
Cell[281391, 5422, 6718, 181, 388, "Input",ExpressionUUID->"c272b759-6f4a-4dcf-a725-e87e6311c27b"],
Cell[288112, 5605, 487, 10, 39, "Message",ExpressionUUID->"e880fb6a-3c43-4c6e-9f4f-4e5a4caa2f75"],
Cell[288602, 5617, 487, 10, 39, "Message",ExpressionUUID->"197ce58f-9e7d-4f02-9901-6d8d96b67a59"],
Cell[289092, 5629, 487, 10, 39, "Message",ExpressionUUID->"be5dec08-e3f9-4db7-81fc-e1760f1cd881"],
Cell[289582, 5641, 472, 10, 24, "Message",ExpressionUUID->"8c791a22-5f21-4096-814c-b2f7cab313b0"],
Cell[290057, 5653, 88803, 1523, 137, "Output",ExpressionUUID->"b81ff410-a80d-4bb2-8692-73d3cdc1fce4"]
}, Open  ]],
Cell[378875, 7179, 394, 7, 52, "Text",ExpressionUUID->"8656cdca-d40a-412a-b04a-e6272521e665"],
Cell[379272, 7188, 2307, 55, 254, "Input",ExpressionUUID->"c8960ba3-09c6-4bb6-826b-0e5b38360370"]
}, Open  ]]
}
]
*)

