(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    248080,       4657]
NotebookOptionsPosition[    244538,       4602]
NotebookOutlinePosition[    244988,       4620]
CellTagsIndexPosition[    244945,       4617]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Pendulum swing up, as a boundary-value problem.", "Section",
 CellChangeTimes->{{3.698811497715045*^9, 3.698811509022469*^9}, {
  3.69885144307857*^9, 3.698851462312389*^9}, {3.709636905485622*^9, 
  3.709636910921179*^9}, {3.715342867107555*^9, 3.715342872342836*^9}, {
  3.7153432690028687`*^9, 3.715343287448956*^9}, {3.716532618830523*^9, 
  3.7165326217793283`*^9}, {3.716570684194786*^9, 3.716570736464383*^9}, {
  3.716613642404841*^9, 3.716613649251136*^9}, {3.7166173099843607`*^9, 
  3.716617315405965*^9}},ExpressionUUID->"f5006cf0-1224-4794-8ac0-\
e829719a3280"],

Cell["\<\
based on Mathematica example for FindRoot (thanks for help from Paul Tupper, \
SFU Mathematics)\
\>", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.716635650557143*^9, 3.716635673813285*^9}, {3.793904900379339*^9, 
  3.793904916165039*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"6cd6c261-f6f9-4a8d-a21b-a0f03a9acb28"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ffCalc", "[", 
   RowBox[{"n_", ",", "\[Tau]_", ",", "\[Tau]1_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "f", ",", "\[Theta]", ",", "\[Theta]dot", ",", "\[Lambda]", ",", 
      "\[Lambda]dot", ",", "t", ",", "\[CapitalDelta]t", ",", "bcs", ",", 
      "eqns", ",", "sv", ",", "froot", ",", "\[Theta]ff0", ",", 
      "\[Theta]dotff0", ",", "uff0", ",", "\[Theta]ff", ",", "\[Theta]dotff", 
      ",", "uff"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[CapitalDelta]t", "=", 
      FractionBox["\[Tau]", "n"]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"{", 
        RowBox[{
        "\[Theta]_", ",", "\[Theta]dot_", ",", "\[Lambda]_", ",", 
         "\[Lambda]dot_"}], "}"}], "]"}], " ", ":=", " ", 
      RowBox[{"{", 
       RowBox[{"\[Theta]dot", ",", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "-", "\[Lambda]"}], ",", 
        "\[Lambda]dot", ",", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "\[Lambda]"}]}], "}"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"bcs", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[Theta]", "0"], "\[Equal]", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Theta]dot", "0"], "\[Equal]", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Theta]", "n"], "\[Equal]", "\[Pi]"}], ",", 
        RowBox[{
         SubscriptBox["\[Theta]dot", "n"], "\[Equal]", "0"}]}], "}"}]}], ";", 
     " ", 
     RowBox[{"(*", " ", 
      RowBox[{"hard", " ", "final", " ", "constraint"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"eqns", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Join", "[", 
        RowBox[{"bcs", ",", "\[IndentingNewLine]", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Thread", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Theta]", "i"], ",", 
               SubscriptBox["\[Theta]dot", "i"], ",", 
               SubscriptBox["\[Lambda]", "i"], ",", 
               SubscriptBox["\[Lambda]dot", "i"]}], "}"}], "\[Equal]", " ", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                SubscriptBox["\[Theta]", 
                 RowBox[{"i", "-", "1"}]], ",", 
                SubscriptBox["\[Theta]dot", 
                 RowBox[{"i", "-", "1"}]], ",", 
                SubscriptBox["\[Lambda]", 
                 RowBox[{"i", "-", "1"}]], ",", 
                SubscriptBox["\[Lambda]dot", 
                 RowBox[{"i", "-", "1"}]]}], "}"}], "\[IndentingNewLine]", 
              "+", 
              RowBox[{
               FractionBox["\[CapitalDelta]t", 
                RowBox[{"2", " "}]], 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"f", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    SubscriptBox["\[Theta]", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Theta]dot", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]dot", 
                    RowBox[{"i", "-", "1"}]]}], "}"}], "]"}], "+", 
                 RowBox[{"f", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    SubscriptBox["\[Theta]", "i"], ",", 
                    SubscriptBox["\[Theta]dot", "i"], ",", 
                    SubscriptBox["\[Lambda]", "i"], ",", 
                    SubscriptBox["\[Lambda]dot", "i"]}], "}"}], "]"}]}], 
                ")"}]}]}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"sv", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              SubscriptBox["\[Theta]", "i"], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              SubscriptBox["\[Theta]dot", "i"], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              SubscriptBox["\[Lambda]", "i"], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              SubscriptBox["\[Lambda]dot", "i"], ",", "0"}], "}"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "1"}], 
       "]"}]}], ";", "\[IndentingNewLine]", "\t", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"initial", " ", "guesses"}], " ", "=", " ", "0"}], ",", " ", 
       RowBox[{"very", " ", 
        RowBox[{"naive", "!"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"froot", "=", 
      RowBox[{"FindRoot", "[", 
       RowBox[{"eqns", ",", "sv"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"\[Theta]ff0", "=", 
      RowBox[{"ListInterpolation", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           SubscriptBox["\[Theta]", "i"], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
         "froot"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Tau]"}], "}"}], ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[Theta]dotff0", "=", 
      RowBox[{"ListInterpolation", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           SubscriptBox["\[Theta]dot", "i"], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
         "froot"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Tau]"}], "}"}], ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"uff0", "=", 
      RowBox[{"ListInterpolation", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["\[Lambda]", "i"]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
         "froot"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Tau]"}], "}"}], ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Theta]ff", "[", "t_", "]"}], ":=", 
      RowBox[{"Piecewise", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Theta]ff0", "[", "t", "]"}], ",", 
           RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
          "}"}], "}"}], ",", "\[Pi]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Theta]dotff", "[", "t_", "]"}], ":=", 
      RowBox[{"Piecewise", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Theta]dotff0", "[", "t", "]"}], ",", 
           RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
          "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"uff", "[", "t_", "]"}], ":=", 
      RowBox[{"Piecewise", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"uff0", "[", "t", "]"}], ",", 
           RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
          "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\[Theta]ff", ",", "\[Theta]dotff", ",", "uff"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Tau]", "=", "5"}], ";", 
  RowBox[{"\[Tau]1", "=", 
   RowBox[{"3", "\[Tau]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "399"}], ";", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]1a", ",", "\[Theta]dot1a", ",", "u1a"}], "}"}], "=", 
   RowBox[{"ffCalc", "[", 
    RowBox[{"n", ",", "\[Tau]", ",", "\[Tau]1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p1a", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Theta]1a", "[", "t", "]"}], ",", 
        RowBox[{"u1a", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{",", ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Filling", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", 
       RowBox[{"HoldForm", "[", 
        RowBox[{"n", "=", "400"}], "]"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "39"}], ";", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]2a", ",", "\[Theta]dot2a", ",", "u2a"}], "}"}], "=", 
   RowBox[{"ffCalc", "[", 
    RowBox[{"n", ",", "\[Tau]", ",", "\[Tau]1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p2a", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Theta]2a", "[", "t", "]"}], ",", 
        RowBox[{"u2a", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{",", ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Filling", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", 
       RowBox[{"HoldForm", "[", 
        RowBox[{"n", "=", "40"}], "]"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "3"}], ";", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]3a", ",", "\[Theta]dot3a", ",", "u3a"}], "}"}], "=", 
   RowBox[{"ffCalc", "[", 
    RowBox[{"n", ",", "\[Tau]", ",", "\[Tau]1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3a", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]3a", "[", "t", "]"}], ",", 
       RowBox[{"u3a", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"HoldForm", "[", 
       RowBox[{"n", "=", "4"}], "]"}]}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.716614292162437*^9, 3.716614675402801*^9}, {
   3.716614733462763*^9, 3.71661475553444*^9}, {3.7166147878306103`*^9, 
   3.7166148080761003`*^9}, {3.716615049387476*^9, 3.716615052160734*^9}, {
   3.7166150874331913`*^9, 3.716615195479767*^9}, 3.716615227807933*^9, {
   3.716615819025228*^9, 3.716615853454791*^9}, {3.716615900967373*^9, 
   3.71661604623131*^9}, {3.71661608707449*^9, 3.716616106945179*^9}, {
   3.71661641854959*^9, 3.716616443449791*^9}, {3.7166165978217688`*^9, 
   3.71661669500036*^9}, {3.716616726139389*^9, 3.716616733079867*^9}, {
   3.716616782109913*^9, 3.7166169106569757`*^9}, {3.716617079500738*^9, 
   3.7166170990893927`*^9}, {3.716617185954321*^9, 3.7166171961061697`*^9}, {
   3.716617246521448*^9, 3.716617248199464*^9}, {3.716617293955492*^9, 
   3.716617297519842*^9}, {3.71661756021132*^9, 3.716617626985359*^9}, {
   3.716617806014511*^9, 3.716617862250918*^9}, {3.716618624635622*^9, 
   3.7166186366337147`*^9}, {3.716619120515398*^9, 3.716619165061843*^9}, {
   3.716619210709831*^9, 3.7166192699892597`*^9}, 3.7166193062935333`*^9, {
   3.7166193393736486`*^9, 3.716619469900126*^9}, {3.716619504205076*^9, 
   3.716619516798851*^9}, {3.716625377990052*^9, 3.7166255374272747`*^9}, {
   3.7166258994938726`*^9, 3.7166261497992353`*^9}, {3.716626217669443*^9, 
   3.716626278297389*^9}, {3.716626495827385*^9, 3.716626571570623*^9}, 
   3.716626611088903*^9, {3.716626805430599*^9, 3.7166268876528187`*^9}, 
   3.716627336613241*^9, {3.716630449361739*^9, 3.716630452785083*^9}, {
   3.716631162185403*^9, 3.7166311693906384`*^9}, {3.7166345985408783`*^9, 
   3.7166346522838573`*^9}, {3.7166350789937887`*^9, 3.716635095527959*^9}, 
   3.716635153132303*^9, 3.716635197242509*^9, {3.716635243873657*^9, 
   3.716635273461979*^9}, {3.716635363388506*^9, 3.7166353702686453`*^9}, {
   3.716635603237688*^9, 3.716635605964967*^9}, {3.716635706350313*^9, 
   3.716635707163306*^9}, {3.716635775838624*^9, 3.716635776675448*^9}, {
   3.716636122220488*^9, 3.716636174549855*^9}, {3.716636688309556*^9, 
   3.716636694219042*^9}, {3.716638564251593*^9, 3.716638752204845*^9}, {
   3.716639188733282*^9, 3.716639199593244*^9}, 3.7166549371715508`*^9, 
   3.716655017015032*^9, {3.7166590803322077`*^9, 3.716659099171986*^9}, {
   3.7167169366553183`*^9, 3.716716936883856*^9}, 3.7167170491123867`*^9, {
   3.716717086568377*^9, 3.7167171006938334`*^9}, 3.717175298268944*^9, 
   3.71717533169123*^9, 3.717175387491527*^9, 3.717175450618146*^9, {
   3.717175491001737*^9, 3.717175494188819*^9}, {3.717175580329627*^9, 
   3.7171755863590517`*^9}},
 CellLabel->
  "In[3098]:=",ExpressionUUID->"16cd26ea-7171-44f0-884e-4487fde9f9b1"],

Cell["\<\
Test the approximate solution on the open-loop\[LineSeparator] dynamics \
(integrated at a fine time step)\
\>", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"62379b6d-8e80-423f-9046-5e21f705f9ef"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TestSwingUp", "[", 
    RowBox[{"\[Tau]_", ",", "\[Tau]1_", ",", "uff0_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "eq", ",", "init", ",", "\[Theta]", ",", "\[Theta]dot", ",", 
       "\[Theta]s", ",", "\[Theta]dots", ",", "us", ",", "uff", ",", "t"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"uff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"uff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"eq", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"\[Theta]", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Theta]dot", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Sin", "[", 
             RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}], "+", 
           RowBox[{"uff", "[", "t", "]"}]}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"init", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Theta]", "[", "0", "]"}], "\[Equal]", 
         RowBox[{"\[Theta]dot", "[", "0", "]"}], "\[Equal]", "0"}], "}"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]s", ",", "\[Theta]dots"}], "}"}], "=", 
       RowBox[{"NDSolveValue", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"eq", ",", "init"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "\[Theta]dot"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"\[Theta]s", ",", "uff"}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]1b", ",", "u1b"}], "}"}], "=", 
   RowBox[{"TestSwingUp", "[", 
    RowBox[{"\[Tau]", ",", "\[Tau]1", ",", "u1a"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p1b", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Theta]1b", "[", "t", "]"}], ",", 
        RowBox[{"u1b", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{",", ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
      RowBox[{"Filling", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]2b", ",", "u2b"}], "}"}], "=", 
   RowBox[{"TestSwingUp", "[", 
    RowBox[{"\[Tau]", ",", "\[Tau]1", ",", "u2a"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p2b", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Theta]2b", "[", "t", "]"}], ",", 
        RowBox[{"u2b", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{",", ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
      RowBox[{"Filling", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]3b", ",", "u3b"}], "}"}], "=", 
   RowBox[{"TestSwingUp", "[", 
    RowBox[{"\[Tau]", ",", "\[Tau]1", ",", "u3a"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3b", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]3b", "[", "t", "]"}], ",", 
       RowBox[{"u3b", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.71661866491695*^9, 3.716618916536735*^9}, {
   3.716618947498246*^9, 3.716619043623947*^9}, {3.7166190949238377`*^9, 
   3.716619112538106*^9}, {3.716619181422105*^9, 3.716619200957466*^9}, {
   3.716619286508587*^9, 3.716619293931712*^9}, {3.716626533461444*^9, 
   3.716626533551689*^9}, {3.716626578299551*^9, 3.716626621289028*^9}, {
   3.716626671879198*^9, 3.716626695390613*^9}, {3.716626897748212*^9, 
   3.716626931941341*^9}, {3.7166272175997543`*^9, 3.7166272625830307`*^9}, {
   3.7166272944390497`*^9, 3.716627298230723*^9}, 3.7166273424394608`*^9, {
   3.716627456205452*^9, 3.716627458563867*^9}, {3.7166300279801693`*^9, 
   3.716630045430882*^9}, {3.716630112214102*^9, 3.716630123135203*^9}, {
   3.71663015934345*^9, 3.716630212072694*^9}, {3.716630406933373*^9, 
   3.716630427849061*^9}, 3.716633546256823*^9, {3.716633687149859*^9, 
   3.716633856304482*^9}, 3.7166339896874647`*^9, {3.716634199877594*^9, 
   3.716634213050828*^9}, {3.71663424959363*^9, 3.716634262173643*^9}, {
   3.716634657603953*^9, 3.716634673600719*^9}, {3.716635296416689*^9, 
   3.716635326171628*^9}, 3.716635391776827*^9, {3.716635549099649*^9, 
   3.71663555509902*^9}, {3.716638708256002*^9, 3.716638710595378*^9}, 
   3.716639205884931*^9, 3.716659108495624*^9},
 CellLabel->
  "In[3107]:=",ExpressionUUID->"694597bb-8cc9-4634-8d24-5df3c6aba934"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.062868692543473`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3108, 217, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229413950021*^9},
 CellLabel->
  "During evaluation of \
In[3107]:=",ExpressionUUID->"60ac230d-bebd-4d09-8ad6-05996c97ea05"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.062868692543473`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3108, 218, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229414010489*^9},
 CellLabel->
  "During evaluation of \
In[3107]:=",ExpressionUUID->"6307d0f4-938e-4632-84c0-51440039884c"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.029524770264035`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3108, 219, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232294140635223`*^9},
 CellLabel->
  "During evaluation of \
In[3107]:=",ExpressionUUID->"c290c2f0-74e2-4626-990b-501ad0d2391c"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 3108, 220, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229414119801*^9},
 CellLabel->
  "During evaluation of \
In[3107]:=",ExpressionUUID->"a2b22876-f72b-48d0-aecf-f961aa974f32"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.032395818743345`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3110, 221, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232294141866827`*^9},
 CellLabel->
  "During evaluation of \
In[3107]:=",ExpressionUUID->"27dc6cd9-7c34-4b09-a359-32391750f441"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.032395818743345`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3110, 222, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229414190226*^9},
 CellLabel->
  "During evaluation of \
In[3107]:=",ExpressionUUID->"108320d7-ba73-4c68-a983-3157a0d19b6e"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.042691753811759`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3112, 223, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229414231176*^9},
 CellLabel->
  "During evaluation of \
In[3107]:=",ExpressionUUID->"7ca614d4-9801-4f7c-8acf-e7893b502aa5"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.042691753811759`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3112, 224, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229414234676*^9},
 CellLabel->
  "During evaluation of \
In[3107]:=",ExpressionUUID->"e89cca54-42fb-49f5-a7a8-194ce5612025"]
}, Open  ]],

Cell["\<\
Show that linear feedback can stabilize against \[OpenCurlyDoubleQuote]bad\
\[CloseCurlyDoubleQuote] numerics\
\>", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"4cfc58ae-9d62-4420-870c-d4d4cde97b31"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TestSwingUpFB", "[", 
    RowBox[{
    "\[Tau]_", ",", "\[Tau]1_", ",", "\[Theta]ff0_", ",", "\[Theta]dotff0_", 
     ",", "uff0_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "eq", ",", "init", ",", "\[Theta]", ",", "\[Theta]dot", ",", 
       "\[Theta]ff", ",", "\[Theta]dotff", ",", "uff", ",", "t", ",", 
       "\[Kappa]1", ",", "\[Kappa]2", ",", "ufb", ",", "u", ",", "\[Theta]s", 
       ",", "\[Theta]dots", ",", "us"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Kappa]1", "=", 
       RowBox[{"\[Kappa]2", "=", 
        RowBox[{
         SqrtBox["2"], "+", "1"}]}]}], ";", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"lqr", " ", "for", " ", "q"}], "=", 
        RowBox[{"r", " ", "for", " ", "balancing", " ", "pendulum"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Theta]ff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Theta]ff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "\[Pi]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"\[Theta]dotff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Theta]dotff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"uff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"uff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ufb", "[", "t_", "]"}], ":=", 
       RowBox[{
        RowBox[{"\[Kappa]1", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
           RowBox[{"\[Theta]", "[", "t", "]"}]}], ")"}]}], "+", 
        RowBox[{"\[Kappa]2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
           RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"u", "[", "t_", "]"}], ":=", 
       RowBox[{
        RowBox[{"uff", "[", "t", "]"}], "+", 
        RowBox[{"ufb", "[", "t", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"eq", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"\[Theta]", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Theta]dot", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Sin", "[", 
             RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}], "+", 
           RowBox[{"u", "[", "t", "]"}]}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"init", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Theta]", "[", "0", "]"}], "\[Equal]", 
         RowBox[{"\[Theta]dot", "[", "0", "]"}], "\[Equal]", "0"}], "}"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]s", ",", "\[Theta]dots"}], "}"}], "=", 
       RowBox[{"NDSolveValue", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"eq", ",", "init"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "\[Theta]dot"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"us", "[", "t_", "]"}], ":=", 
       RowBox[{
        RowBox[{"uff", "[", "t", "]"}], "+", 
        RowBox[{"\[Kappa]1", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
           RowBox[{"\[Theta]s", "[", "t", "]"}]}], ")"}]}], "+", 
        RowBox[{"\[Kappa]2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
           RowBox[{"\[Theta]dots", "[", "t", "]"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"\[Theta]s", ",", "us"}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7166274668845177`*^9, 3.7166274672114887`*^9}, {
  3.716627522808957*^9, 3.716627618600381*^9}, {3.7166292435476313`*^9, 
  3.716629268839957*^9}, {3.7166305528248167`*^9, 3.7166307060782347`*^9}, {
  3.716630749158601*^9, 3.716630751588089*^9}, {3.716631469593801*^9, 
  3.716631525463723*^9}, {3.7166315947994127`*^9, 3.716631609034924*^9}, {
  3.716631680270759*^9, 3.7166316936103687`*^9}, {3.7166317304575853`*^9, 
  3.7166317454886217`*^9}, {3.716632669073279*^9, 3.716632692229643*^9}, {
  3.716633423077694*^9, 3.7166334994098253`*^9}, {3.716634426309063*^9, 
  3.716634529364629*^9}, {3.7166347822172527`*^9, 3.71663487893288*^9}, {
  3.71663921834173*^9, 3.716639222878071*^9}, {3.7166591200486517`*^9, 
  3.716659127513075*^9}},
 CellLabel->
  "In[3114]:=",ExpressionUUID->"a87f29c8-c971-4e70-b4eb-519560d5613b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]1c", ",", "u1c"}], "}"}], "=", 
   RowBox[{"TestSwingUpFB", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "\[Theta]1a", ",", "\[Theta]dot1a", ",", 
     "u1a"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p1c", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Theta]1c", "[", "t", "]"}], ",", 
        RowBox[{"u1c", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{",", ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
      RowBox[{"Filling", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]2c", ",", "u2c"}], "}"}], "=", 
   RowBox[{"TestSwingUpFB", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "\[Theta]2a", ",", "\[Theta]dot2a", ",", 
     "u2a"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p2c", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Theta]2c", "[", "t", "]"}], ",", 
        RowBox[{"u2c", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{",", ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
      RowBox[{"Filling", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]3c", ",", "u3c"}], "}"}], "=", 
   RowBox[{"TestSwingUpFB", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "\[Theta]3a", ",", "\[Theta]dot3a", ",", 
     "u3a"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3c", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]3c", "[", "t", "]"}], ",", 
       RowBox[{"u3c", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7166307264524517`*^9, 3.716630756566729*^9}, {
  3.7166317765533257`*^9, 3.7166318028391857`*^9}, {3.716631835809661*^9, 
  3.716631878191729*^9}, {3.716634693075864*^9, 3.716634705753868*^9}, {
  3.716635472962838*^9, 3.7166355160149307`*^9}},
 CellLabel->
  "In[3115]:=",ExpressionUUID->"f1537525-cadf-4359-a24c-6e72fbaad310"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.012022311289419`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3115, 225, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232294143538237`*^9},
 CellLabel->
  "During evaluation of \
In[3115]:=",ExpressionUUID->"4827e436-e02c-46ed-8901-03c198d36b67"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.012022311289419`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3115, 226, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232294143577423`*^9},
 CellLabel->
  "During evaluation of \
In[3115]:=",ExpressionUUID->"1e45aa17-8634-47af-a4a4-e076380f5848"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.012022311289419`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3115, 227, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229414360877*^9},
 CellLabel->
  "During evaluation of \
In[3115]:=",ExpressionUUID->"03ad4c20-9496-4aab-b84c-6a18037c9c1c"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 3115, 228, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232294144205847`*^9},
 CellLabel->
  "During evaluation of \
In[3115]:=",ExpressionUUID->"7e0df1e0-cafa-4bba-85be-e46a6f043173"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.001281739565005`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3117, 229, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232294145382843`*^9},
 CellLabel->
  "During evaluation of \
In[3115]:=",ExpressionUUID->"9bf0c974-e1a0-435a-8031-1e035cfe5056"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.001281739565005`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3117, 230, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229414541687*^9},
 CellLabel->
  "During evaluation of \
In[3115]:=",ExpressionUUID->"41283a6d-97c2-4652-ba14-06805a690178"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.001281739565005`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3117, 231, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229414544512*^9},
 CellLabel->
  "During evaluation of \
In[3115]:=",ExpressionUUID->"e7b6dd5c-ad1b-406a-ab0f-51b3673de38b"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 3117, 232, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229414547475*^9},
 CellLabel->
  "During evaluation of \
In[3115]:=",ExpressionUUID->"f407991e-2aa3-4292-b78f-2c9fcf56d37a"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.07966082971324`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3119, 233, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229414606719*^9},
 CellLabel->
  "During evaluation of \
In[3115]:=",ExpressionUUID->"33cbb948-64d7-4b11-9634-7056bd316d8f"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.07966082971324`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3119, 234, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229414610063*^9},
 CellLabel->
  "During evaluation of \
In[3115]:=",ExpressionUUID->"72753c9d-ff67-4cf2-8431-e5686894cb0f"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.07966082971324`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 3119, 235, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229414612912*^9},
 CellLabel->
  "During evaluation of \
In[3115]:=",ExpressionUUID->"39288747-cd2c-4d32-869b-a4751288300c"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 3119, 236, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229414615806*^9},
 CellLabel->
  "During evaluation of \
In[3115]:=",ExpressionUUID->"719cb965-7929-49c9-9c45-0cf58e8cae9e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1a", ",", "p1b", ",", "p1c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p2a", ",", "p2b", ",", "p2c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p3a", ",", "p3b", ",", "p3c"}], "}"}]}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.716626737927223*^9, 3.716626761662538*^9}, {
  3.716626940212812*^9, 3.716626946700778*^9}, {3.716627029078232*^9, 
  3.716627046049563*^9}, {3.716631188580411*^9, 3.7166312314180803`*^9}, {
  3.716631818357041*^9, 3.7166318195502157`*^9}, {3.7166318814734297`*^9, 
  3.716631886480524*^9}},
 CellLabel->
  "In[3121]:=",ExpressionUUID->"51f49d87-cbfc-4c38-ac37-5fcd28423fed"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJzt2vlfTO/fwPG0zkjbTJJURIVWJSrS+9KihIQs9UkhES2KiEQLKRGtSpJI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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{419, 538, 536, 243, 244, 432, 385, 347, 319, 299, 
             287, 245, 433, 386, 348, 320, 300, 288, 442, 395, 357, 329, 309, 
             246, 434, 387, 349, 321, 455, 408, 370, 301, 449, 402, 474, 364, 
             466}}]]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwNz80vF2AAwPGf/goKm62Ek9RB3k55OZBliZwiBy8jDWNeyok4iGUZTVND
89rJ2wGN1WSsWhgr3MpbL/oL+hw++z57XvdEFD3IqTwXCASC6OEHISaC+Wd8
xl/+8JtfhNscQwoFtPCWU2thGk0yd3nMFCfWrmkGxXQwTyjZlNPNO6J4SC8f
SCKfR0xy7K56fckGOQzxlUp6WOEqI2xRwzf6+Ug6e7ziM/fZoZ05LnDAG7ap
5TsvWOMm+7zmC2Xs0sUSlxlmkyqe855EBvlEHs1McORPdTrAOreo4BnLxFFN
H6ukUcQTZjlPFqU8ZZFIErhDE+MceueKplJIGzOEkEkJnSxwievk0sgYP52P
1Rvco5VpgrlIPLdpYJT/i+RQxA==
             
             "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], 
            LineBox[{1, 182, 143, 221, 110, 214, 175, 225, 85, 207, 168, 223, 
             135, 219, 180, 65, 201, 162, 129, 216, 177, 104, 212, 173, 140, 
             51, 194, 155, 122, 97, 210, 171, 138, 77, 205, 166, 133, 108, 2, 
             183, 144, 111, 86, 208, 169, 136, 66, 202, 163, 130, 105, 52, 
             195, 156, 123, 98, 78, 3, 184, 145, 112, 87, 67, 53, 196, 157, 
             124, 99, 79, 4, 185, 146, 113, 88, 68, 54, 5, 186, 147, 114, 89, 
             69, 55, 6, 7, 8, 9, 10, 11, 187, 148, 115, 90, 70, 56, 12, 188, 
             149, 116, 91, 71, 57, 13, 189, 150, 117, 92, 72, 58, 197, 158, 
             125, 100, 80, 14, 190, 151, 118, 93, 73, 59, 198, 159, 126, 101, 
             81, 15, 191, 152, 119, 94, 74, 60, 199, 160, 127, 102, 82, 16, 
             192, 153, 120, 95, 75, 203, 164, 131, 106, 61, 200, 161, 128, 
             103, 211, 172, 139, 83, 206, 167, 134, 218, 179, 109, 213, 174, 
             142, 17, 193, 154, 121, 215, 176, 96, 209, 170, 224, 137, 220, 
             181, 226, 76, 204, 165, 222, 132, 217, 178}], 
            LineBox[{107, 141, 62, 84, 18, 63, 19, 20, 21, 22, 23, 24, 25, 26,
              27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 
             43, 44, 45, 46, 47, 48, 49, 64, 50}]},
           Annotation[#, "Charting`Private`Tag$1251446#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV0etPSHEYwPHDXxEpbKJUm9DmTptKW2U1d9oUtnJNMU3ktlXYSIwwVi6Z
ULKVy1aSuS5zi4nwjgjJpdc+Xnz23dnz/M7Z2W9kzobM9YOCIGjmExc9bGUe
kxhFCE2UspzZjOOz/TotZj6TiaCFA+SSyhCaKSObROLocf6SbmMBUxhNKwfJ
I42hXKecHJJ4yHEKGU87h1lHBh2cYgtffOeybmchT6lmKvc4Sj6dnGcMt6mg
i9U85wwfSOcxJ+lmM6+5wEdCucFe3rCCZ9TwnmQecYJ3bOIVtUzgLkf4fzEv
OUcmTzhNEV/90xUtYRHTuM8xNhJJG4dYw1yGcZN9rGQOE+n1rnrdwWKmE0UY
38wadCdLmMFYwvlu9oM+ftLPL0IGB8Fv/cNVe7tYykyiGc5fs0bdzTJmEcMI
brGfVaQQz4D9a7qHLBJ4QBUFxHKHSt6ylhec5R8NCWLx
             "]], 
            LineBox[{336, 459, 412, 374, 289, 443, 396, 358, 330, 310, 247, 
             435, 388, 350, 322, 302, 290, 248, 249, 250, 251, 252, 253, 254, 
             255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 
             268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 436, 389, 
             351, 323, 303, 291, 444, 397, 359, 331, 311, 452, 405, 367, 339, 
             462, 415, 377, 471, 424, 480, 279}]},
           Annotation[#, "Charting`Private`Tag$1251446#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{484, 534, 485, 486, 487, 488, 489, 490, 491, 492, 493, 
             494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 
             507, 508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 
             520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532, 
             535, 533}]},
           Annotation[#, "Charting`Private`Tag$1251446#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{228, 229, 227}], 
           LineBox[{482, 483, 481}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotLabel->FormBox[
        TagBox[
         RowBox[{"n", "=", "400"}], HoldForm], TraditionalForm],
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdm3k4ld8X9kU4xzzP8zyWJJmyV5JCISQ0KCGl0ERJmSVDoUEkVESDCmWK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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{762, 138, 49, 586, 587, 775, 728, 690, 662, 642, 630,
              588, 776, 729, 691, 663, 643, 631, 785, 738, 700, 672, 652, 589,
              777, 730, 692, 664, 798, 751, 713, 644, 792, 745, 817, 707, 
             809}}]]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV0s0v0HEcwPGfx5PkQJZlGMOU9UBupAfF1R/g0B+AolNSnYQDFSfUIVlG
Hk49OKBlWowROqkcPIwxWlZG5uXw2vvz+Xyv35TbFaXloUEQhNBCvqVML1Ji
LuYWNyniBvd4TCuDfCcyLAiuazWPaGGABSK8XdNGXjLEEjHuVdrFJ9aId3uo
X9gi0f5c+5kn3H5Vp9klzd6t+2SZx3SDBHOD/ueceUIv6Y4m6wvN1X+aoR/1
vP7Sk3pX8/RQs3VSc/S3puhrvax7mqmjekFX9ZTW6gFnzeO6yRnzM/1LurlP
5wgzF+oUf0i1v9HPrHPaXq9f2SbJ3qEf+Em0/Y52MsIKcW4P9Clv+Uao2xV9
Qjvv+cEJ90p9xTDLxLrVaDO9zBLiVqB1tPGORaLcK/Q+TfQwc/yp3I8A+S5P
gg==
             
             "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwl1mWUVVUYgOEZWqSRBmHoLqVRuks6BKVbQDqlS1A6FRRplJCUbkTpUFJS
wiCUbp+9/PG4z/vdb7FmvGeLUS271ukSGRERUSxaREQ4j/hHewrrOM58zv3O
4s7vfZ7NuUMXdTZ3vu085PzQZ1GeN3luQgHPPzujkdvzXmcb3rL31DklPHNe
5/T5bs+tGKez6G2ePyBW+DPMjjo78BqrdXbDnZ5b0Fxn1Js9v0/08HOZPXNO
Dc/8pscTnWO6I3FZo1tQiOd6GoW4oD8jBsd1J15nrW5JYWJywqwz8VinW1GE
WMQmDq8Rl9c5ae8j4rNet6Yo8fjFLHwZCdig24Tvhfj8ataVhPyg21KcF3p6
+L64qD8nAad0NxKxUbejBC/1DIpwSU8gIaf1xyRmk25PSV7pmeH75rKeSCLO
6O4kYbPuQCbfwRbdlBi8Yxa+vFmei3FF5tJ7PLdmks6qt4f3J7wPng86Y5PX
84/OduFnsnfW2YOk5PfZT84t5jk874r8//1tGb4752FnSWdHn2d2bg2/r7OZ
s6DzgLOEM6Yzj3Ofsy3v2o/Us8P7zlU9mSSc0z15g626E6XCr2f/i/Dn8bue
QlLO614kY5vuTOnw/tn/Mvx8XNNTeYPfdG+Ss11/RJnw/tmfE/5dcl1PIxkX
dB9SsEN3oWx4J+3PDb8LN/R0knNR9yUlO3VXyoX31P5XZqW4qWeQgku6H6nY
pbtRPrzT9r82K80feiYpuaz7k5rd+mMqhPff/jyzMvypZ5GKK3oAadiju1Mx
3BX735iV5S89m9Rc1QNJy17dg0rhXtmfb1aOv/UXpOF3PYh07NM9qRzuoP0F
ZuW5pb8kLdf0J7zJj7oXVcK9tL/QrAK39RzScV0PJj37dW+qhrtqf5FZRe7o
ubzJDT2EDPyk+1At3FX7i80qcVd/RXpu6qFE8bPuS/VwV+0vMavMP/prMvCH
HkZGDuh+1Ah31f5Ssyr8q+cRxZ96OJk4qPtTk8T2l5lV5Z7+hoz8pUeQmUN6
ALXC3bD/rVk17uv54b8D/K1HkoXDeiDvhbth/zuz6jzQC8Id5ZYeRVaO6EHU
DnfD/nKzGjzUC8nCbT2abBzVn1An3A37K8xq8kgvIit39Biyc0wPpm64G/ZX
mtXisV5MNu7qseTguB5CvXA37K8ye48negnZ+Ud/Sk5O6KHUD3cj/L1pVpun
eik5+FePIxcn9TAahLthf7VZHZ7pZeTknh5Pbn7Rw2kY7ob9NWZ1ea6/JRf3
9Wfk4Vc9gkbhbthfa1aPF/o7cvNAf05eTumRNA53w/46s/q81MvJw0M9gXyc
1qNoEu6G/fVmDXilV5CXR3oi+TmjR/N+uBv2N5g1JPwPyEpHPh57nkQBzuox
NA13w/4PZo2IZJVZfp54nkxBzumxNAt3w/5Gs8Z09Zf/f4pgCMU=
             "]]},
           Annotation[#, "Charting`Private`Tag$1251653#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV0ttPjwEYwPG3QtoktnJoocZItBDdRc45dONP8AeokC6IHDYdbETS5rgV
ywo5jMKmyCSNOSabQzYpRmXMufm4+Lzf53ne/fa7eRPWZq9ZFxIEwWXSQz3C
guCh1rKXzWQzwv2lXuEwu5lPiPsjrWMfW4h2e6c3qCKHSLdX2sARilhAqPtj
PUMZBcS4dWsT1eQy0u21NnKUSfZ+baOY8fYP2kINk+1f9T4ZhNmf6Fmmmr/r
fuLMn/QOM8x/dCtjzO91ljZrov7UeXpSE/SLpmq7Juugpul6jdI3mqJXdZr+
0Ll6TON1QOfoPZ2pf7WEWPNHvU2S+beeZor5mz5gIUPsT/UcB5hg/6ytbGOs
vUdvcooNjHLr0mscp5RFDHV/pvWUU8hGFjPMuw49z0G2k8cSlrKM5WSygtk+
o5W6inC/fa4XqGAHm1jNcO869SKH2Ek+o93f6nVOsIcsItxf6CUqmWjv07vs
Ypy99///6y2drr/0H0D0YYA=
             "]], 
            LineBox[{679, 802, 755, 717, 632, 786, 739, 701, 673, 653, 590, 
             778, 731, 693, 665, 645, 633, 591, 592, 593, 594, 595, 596, 597, 
             598, 599, 600, 601, 602, 603, 604, 605, 606, 607, 608, 609, 610, 
             611, 612, 613, 614, 615, 616, 617, 618, 619, 620, 621, 779, 732, 
             694, 666, 646, 634, 787, 740, 702, 674, 654, 795, 748, 710, 682, 
             805, 758, 720, 814, 767, 823, 622}]},
           Annotation[#, "Charting`Private`Tag$1251653#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{827, 877, 828, 829, 830, 831, 832, 833, 834, 835, 836, 
             837, 838, 839, 840, 841, 842, 843, 844, 845, 846, 847, 848, 849, 
             850, 851, 852, 853, 854, 855, 856, 857, 858, 859, 860, 861, 862, 
             863, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 874, 875, 
             878, 876}]},
           Annotation[#, "Charting`Private`Tag$1251653#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
           LineBox[{825, 826, 824}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJw8W3k4VG8bVrJm3/fG2HdJ2d/zJtkqxFiTEJJkichSSfbwsxUpkigqQiWU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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{970, 1283, 1281, 388, 389, 1006, 813, 663, 552, 474,
               432, 390, 1007, 814, 664, 553, 475, 433, 1046, 853, 703, 592, 
              514, 391, 1008, 815, 665, 554, 1112, 919, 769, 476, 1081, 888, 
              1195, 738, 1162}}], PolygonBox[CompressedData["
1:eJwV0L8rxHEcx/EP7itMjJgw43+4UxjdymRwiDsjRX4MFBJZFIUb3KJwFjfI
ZaCQScimbIwoLB7f4dXz+Xp/3u/v8G0ZzKWzlSGEChmVKAohIT+GyzKZCOGs
KoRW2bVUo3fzE2+z/IIneT/f5pF82kvq8/zd27Tk9CO9UW68t+tj/NHbIr/i
GT7ED3h9vKv36ev8l2/yB77Cp3iJl7AN8/iGe75dy3t4AYt257Csn2NKH8Ad
vYjVuIUveIlf7lO4oB/ih/01vNfLOKNP4LHeFP8T/oq37jr4OH+ys8Sv+TDP
8AJviG/0tL7B//iq7LutM+s1O9W75NvsTjrNs+bPZiPSLHnzf1OBOhc=
              "]]}]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwVzbsv3XEcxvEvrZBQhBHVJux1+RPcr4m2Yw2mKqXYSHDiEotLOEsHFsrp
RlN1myQdGIpKKnFpOrVbsWnd4mV48ryf9+d7fudpU3tDW3wIIU6ikpAQQqLE
iO2HIfx5EMKcztcbekP36HE/OsBRfIuj+CV+gjPxR2m27z/+U7rsYnvfdyP2
uQxz5dw1V2WvST2Xzi1wufZbOZFOvoj/zl9JJbcqdXwaP889tlvlWDr4Qn6P
z8afpNPud9vDE/gMD+EyfOndMX6Pk/SMNOIKbzZxBK/gmK61U/UHv9nSv+1Z
nafX9bru1mPe/8A3etGewi90jv1V/7KndYZe1jH9Wre4b+ERfITf4QK86/+y
8JJ02H1uu3gcn+JBXIr/e5d4/215ZZe7fZEa+5E95z5qX8sk95zLxm/kUNq5
Z9yOd732XxngSrh/XJm9LNVcCjfLfZMLKeU/S5VbstsdO41R3Q==
              "]], 
             PolygonBox[CompressedData["
1:eJwV0LtPk2EAhfFP0AE3EEdIUKQKrgh/AjdRgeiocXSgoiByh5ZEu1GxJDAo
K1Vg0DCgQmLi4EgAqwnhMimgAzJz+b3Dk3PO875f+7VlD+Mt7XlRFJ3BJLqV
vHM2knoCIxjGEAYxj1+IeXAC1/Oj6B8GuDn8RAWfQRX/F/3cqH2IlN1w1nfo
t7CENu4iN+veE3sH3Vwtlwsvp0/gnn3F2WtU2vvoc14qP6LTedLZip7W/+uz
8qVdLyN7Q5/Sz8sPclo+kM3hXeRXOyG/2DOy1S6W733PN7ltv5HFckFm5SPZ
4f6y/G6nwj07K5/ZNfKH53N6Rj8J/49+Vy/XP4f/SB/Xr+l76HW/JLwjnjpL
ODvAC7sufIbzAv0t7ts3w+egxb5gv3P+2N5CF3eDW+cu269wldtFD3eMJu4T
7nBF4XdxcXsTnVw1t8ZdstOIcX/wnDtCI7eI21yhuzPcKsq4MVTwv3EKUAlS
Ag==
              "]], PolygonBox[CompressedData["
1:eJwV1FdwVWUUhuFNchKUakNihdgVUHpJSMNyo1iwggWSUFQELxSQqjOKhm6n
JJRQbBQbCioioQWwg87ABSiEbqVKUeFZF2/W9717ncz8e+9zskue7DYwLUmS
Wqj05yklMyNJUpiUniR3ppIki2soz0Mfva/+M/rrzfX1Pjdc34/nuCLuEFek
f4BbuNrcDK6x3gc/4XG+Gb+OP4hC7n3czGfy07nz9d7YhMf46/hq/gAKuEW4
ic/gK7i1GMbtw7N8If83l68vxI1ciivnsuUlGKKPce0YJup36I3kBvJc9NZL
9TXyaHmj/Kh8rbzG/8mSF2GgPtS1b+UJ8l55lFwg/2VvizxZTpkfmtPMHmae
veXyKHmB/JbZRU+PHZ+rNmv0SrOpudT81BxslsW9kf+Je6dPkG83z9NXmdv0
CrO+udicY5aaJa6vll+Qf5T7ydfIq+MZyQsxQH/GtW/k8fIeeaScL/9pr8rc
rL9ppptT0dnOMv1LeaQ5X59nFulp5tR4RuYOfZbZJJ6B+Yk5yHzJ/kb5Vflo
PF9zvN7VPFffKpfL9czZKJGL46zy8/IPcl/5anlVvD/yAjyhD3Hta3mcvFse
IefJf9hLk6egu57r2nso1GvpU1x/UT+Ccdxt3Dly3XgmKNZ76d/Hu61fpa/0
mcH6LgyP+8L9zuXo76KAS7jJ3Gj9MMZyt3Jnyz3xXbz73JVclb1B+k4M43K5
37hO+jvI507Fs+BWYD868m8jj/8fb3Bn6Y/EO4pS7gr/5yv+ab0GQ7kcbh/X
Id5FdOb+w+tcQ/3heCdQwl1udzm/F+3jWSOX/xevcQ30h+K+o5i7LN4Nfg/a
cXORw5+MZ87V1x/EBvTisu0v43ejLTcHnfgTeIWrp/fA+rhnXFP7X/C70Iab
jY78cbzM1dW7Y13cB66J/c/5nWjNVaIDfwyTuDr6A6iOc3OX2v+Mr0Erbhba
x/cPE7kz9fuxNs7NXWJ/Kb8DLbmZaMcfjd8I7gz9vvhtiXNzF9tfwm/HDdwM
tOWPxHeQq63fG9/dODd3UfwW8L/iem462vCH4z3nMvV74vsR5+YujO8a/wta
cBVozR/CWC5Dvxsr49zcBfYX89vQnCtHK/4gxnApvRuq4txclv2P+a1oxk1D
S/4Ayrh0/S6siHNzje1/xDeS56O/fhqyd9SE
              
              "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwl03e4znUYBvBjc4yy9zjIzCEyiwjRsI4d2VHKXsnK3mVEGUXTKKtokD2K
hvayNdAwCmUUn+fyx+e97+/zXuec6/f9PSepW7+UvqkSEhKG+oi808dV2V9u
lY/IygxmmnMnWYqBnHGOH65JR72NLMyvem9ZlQ16D1mBf/QqNNGz853+Kl31
svytD6ODXpzf9U2kprbzf3Ib0+nsXJqz+kO01YtwQn+H22nqnIPv9dd4gjTU
MftfbmdGPBNVaWaekx/01xlOWu4yuyZ3MDP+NtVIR924NHaKp+lCddKTgYxk
IpHM1It7Zpf+TDw7NcjC3eap2a3Pohs1yUp98zTs0WfTnVo0N8vFj/oyniQb
DczS8qE+J94Bd9DCLDcH9OWM4CYamqXjI30uD8cukGKWh4P6CkZyM/eYpWev
/iw9aedclJP6u/HOaOmcl0P6yngmvRzn9VF01Evwh/64rM4H8ftkRS7p2Wmk
Z2Cf/qiswry4b1mGQZxz7idrpbqxz72c28tiDOCU82OyGkN4L55TJvNv7AWt
9Hwc1t+Ie9bLc0EfHbuml+RPvY+swWa9l6zE5bjn2Lt49/Lj2EU5X/4V/0+8
HzvFEd7kVt9flGO4RT8tt3CbfkXmpLGeiU/05+IOeNA5id/0jbGLtHbOz1F9
FU+Ri3vNEvlUf57esYvkJg95uc/3mflMXxB3FTtJPu43z8J+fWG8q9hJ8vOA
eVY+1xfFvcT+USB20fwLuZi+sWcxNzsmVzOWgrGDZl/KF+Idxn7F3Oy4XMM4
CsXumX0lX6R/7EXMzX6SaxlPYb5mCQPi7viZdUygCN+wlIFxN/zCW0ykKN/y
EoPiXnibSRTjZQbHnbCeySTxCkPiPphCcYbShKmUoCkl4z3TjFI0pzQtKEMK
ZWlJOVpRPt5t7AptqEBbkmlHRdpTKfYidocOVOY6PGKdjw==
             "]]},
           Annotation[#, "Charting`Private`Tag$1251945#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV0MtTTnEcx/HfEy2yK2lXM0lXYuX2Hyi3hNhpWlooiZJ7IVkJT6kFtj2V
y9S0qDDTjAW7RolqUjYoEtaV11m85/P9vL+/3zlnTnZVdfmZWAhhGPWGb+tC
yMO9pBCy8YHrRur6EMr4IW4/VrgGfOfy0cZtxji309k6blavRoJL445ww/oB
rHIX8YMrwH0uBxPcLmfPc1/0GvRwG7lybkQ/iFP6Ez0Fa/b79BbzH7smnNP7
9Uw02i/IQjywu2w3Yt5irjDHo2eY4+ZJ80fnd5svmBNyzq5VvtPfyLP6aZnQ
B2W6fBydk29lr/vp8qjeLV9F3yRH9dfykF4pn+r9coPskjMy2JWY75j75F+9
TY7pzeY684A5C5e8Z1EW4aFdLk7Yt0fPwaT9Hr3ePG9Xiz5uE3cs+hb9MGIo
5Vq5f+ab0T9y7qe+FXE9D5+4Z7iCX/w2tPP5+Mw9x1Vcw3XcQBOaEUv2XHkL
S+4Vo8O9AkxxL3Abv/nteMQXYpp7iQzfdzz6/1wZktDCL3M70KkX4aRzHXoM
M/Z79QZzj/xqf1e+1/8Dk9VkDQ==
             "]], LineBox[CompressedData["
1:eJwl1Xe8zXUcx/HDvUbZKmQrTdmkkD1aKHvHpSii0qBkZIZcpKJQRkabskeX
sjIqRUrIJip7U8/Poz9ej8/7/fp9zzn3nt/v+z3FUno27pEukUi8lz6R6IVu
yYnEx0mJxA2Y50Jevbmc5tqjSMJw/gRXBu/qJbCT+xL5rG/Br+QaIxmv8ye5
skn/f85d2MV9hRutb8mv4pogA0bwp7hymKSXxG5uPvJb34r/hmuKjBjJn+bK
Y7JeCn9wC1DA+tb8t1wzZMIo/gxXAVP00tjDLURB69vwq7nmyIw3+LNcRbyv
l8FebhEKWd+WX8O1wDUYzZ/j7sYHelns4xajsPXt+LVcS1yLVP48VwlT9XLY
zy1BEevb8+u4VsiCMfwF7h5M08vjALcURa1/jF/PtUZWjOUvcvdiul4BB7ll
KGZ9B/47rg2yYRx/iauMGXpFHOKW4ybrO/IbuLbIjjf5y1wVfKjfjcPcCtxs
fQq/kWuHHBjPX+GqYqZeCUe4ytb24fbpz+NrrjjXidukt0dOvMVf5e7DLP0e
/Mml4W38y1fDbP5eHOWqeJ+Xuf36C1jJ3cJ15jbrjyEXHuJGcKflIXgnNgdX
nZujV8Yxrir3CndAfxGruFu5x7nv9Q7oqE/VsyC3/rA+Uj4jD8UEr0nH1eA+
0qvEPdYn6Onxl+v36X3lg/Gcyxvkl+Tu8idyntgL1t2mPyH/4Nog+Ru5o5wi
T5Ozxt6Td5rX8Q3kUfJn5tm45+YWfVh8P/J8eaFZJJ5hc2884+ZEn5XerBn3
Os4K6181l+vLzKr6RDkJb+vb4yww//a6auar+qHYg/JGubf8tPypnDf2qXW3
613kH10bLH8rp8id5OnyV2a2OBvMXfH/m9e73tB8Q//cPKf/JA+P+6MvkBeZ
RWOPmftiD5rv+rwks1Y8i/GdWt/PXBHPV+yhWCPPNZPNd8xfzX+8rrrcTz4c
Z4S8Se4j95A/k/PFOWLdHXpXeUs8U/JquZPcWZ4hZ4/zVm+kj5bPx5mJl/SF
erG4d94nWa8tf+paNRznanD9uSP6y1jDTUIGvk7cX646TnBrcSf/JP9TfD7y
YDKfka8b351eAye5dSjBP8X/zD2OvJjCZ+Lr8V/oNXGKq8kN4P7UX8F67i6u
G7dVfyLeQ/9QzxHfj/6InionZ3CmxdmP3twi7qY4b71HZr1+3APX+stfy7Xi
vJLfkzPEfrWulj5QPupaX/TUP9dvjPPN9ZJ6d3lb7D95jdwl/i55ppwz1uqP
6mPki3G2yT/LI+U+8mJ5sXlznL3m/tgf3vsa+f44j8x51g4w0/Tlcc/irDQn
6fPMjOYE8zdzlXnG62ubr+mfmMfiN8TcrKfFntGfMb/Q88d3Iu+JM9jrSslP
y79YM0xeK3eVu8iz5FzxGr2xPla+FHsPU732Wu4B7ku9Ds5yG1Ga78Fv555E
AUyLZ8o9yuLag7EHubo4x2/CdGR17SHX5vP1cJ6rww2Ksyz2FTZzZbie3K/6
UyiIJtw47nLsJcywLhv3MLdArx+/H/pkPRMuuF5XHyz/7Vqq/L3cX35WnisX
iLPYurL6M/Jvrg2X18nd5K7y7Ph7zdzmZHN3nEFmIdebmm/GM25e0bfKo2Of
6UvkJWZxc7p5wFwXz7bPy2420GfH/rV+oLlSvz9+w+QpcmZMlHfEc+Y19eQh
ca5YM0b+QR4gPxfPk1wwznbryunPyjviNwCFMZPPwTeMM05/AJe4H1Gef47/
Pc5ZFMEsPiffKJ5l/UFc5upzQ7nj8TdjC1eB68XtjHMtngd9TvyGoKjeTB8v
X5XHy9vk1Nj/8lJ5qXmLOcM8aK6P79z7/geem1vs
             "]]},
           Annotation[#, "Charting`Private`Tag$1251945#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{1229, 1279, 1230, 1231, 1232, 1233, 1234, 1235, 1236, 
             1237, 1238, 1239, 1240, 1241, 1242, 1243, 1244, 1245, 1246, 1247,
              1248, 1249, 1250, 1251, 1252, 1253, 1254, 1255, 1256, 1257, 
             1258, 1259, 1260, 1261, 1262, 1263, 1264, 1265, 1266, 1267, 1268,
              1269, 1270, 1271, 1272, 1273, 1274, 1275, 1276, 1277, 1280, 
             1278}]},
           Annotation[#, "Charting`Private`Tag$1251945#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
           LineBox[{1227, 1228, 1226}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}]},
    {
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJztmvk/1O3798k2o4gZIWS7irIViZQ6zhDispUKLRSJsiYqKktEmyyVrexL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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{455, 584, 582, 274, 275, 470, 418, 378, 350, 330, 
             318, 276, 471, 419, 379, 351, 331, 319, 480, 428, 388, 360, 340, 
             277, 472, 420, 380, 352, 494, 442, 402, 332, 486, 434, 517, 394, 
             507}}]]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV0dsvl3EcwPGfQ0QRf0J/RSJXyeGKdKGim5QuKIyKK9JFGiZTrZZDrYtO
FzGaWmVZanJYR1edLmS0WDJGrdPre/Ha+3mePZ/vvs/32XqwsvBYdCQSieI6
G1zkeJBNqusUtpBMEpvJJI8D1HONaTaxg1xKeMoadcRY76q+I5Fq2rjHV/Zw
nnjvPdIljvCMn5zmDp/J4Chn6Wc27Dnszey4/qWDByxSzEl6eUsClxlhlaqw
d7Mv9A+txLkf1HkK6eQh3ymjidt8Ip3JcIBmLupGHdZlKsL3un+uv2imjy9k
c477LLCfE/TwJqwTztzslEbppbB3faIrVDLGb1oYYI7dHGaUdU4Ra+6WfmQ7
E/zjAo/5QTlnuMsMu2hniG/s4zjdvA7/igIO0chNPpBGFnuppYtX4UzJp5QG
bvCebeykiBqu8JL/zAFYsQ==
             
             "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwl0sVSkAEAhdEfuzAegWewc2EHFurYhV2AYqIoYnc7FoqNYotYGKjY3d3d
hViox2Fx5tvexQ2LjI6ICgmC4Db/e5olxNKa56Qzi5rcZwuT+EQm/XhLBrks
IIcTlOUG60mgO6/Zxzya8oSdTOcrx4K8MTHynoMsIh9nWMpg2vCC3czmG8ep
xQO28ovJfOYI/SnHTVIYSw+a8ZQ0ZjCQ/JxlGUNoS20eso0pDKA8t9hAIj1p
TgHOkcRQ2lGHChTkPMsZRnvqUpFCFKYIRSnGBVYwnA7UoxLFuUgyI+hIfSpT
gkusJI5ONKAKoVxmFSPpTEOqBnlf2Mg4ehFBSa6wmlF0oRHVuEMq4+lNC0px
lTXE05VwqnOXTUygDy0pzTXWMpqPHOYvkbxkD3NozCO2M5Uo3nGAhXznJCE+
VEPvsZmfTKQvb9jPfFrxjF3MJJssBvGBQ/xhMT84RRmus44xdOMVe5lLEx6z
g99M4wtH+Qf+X3uT
             "]], 
            LineBox[{111, 151, 63, 86, 18, 64, 19, 20, 21, 22, 23, 24, 25, 26,
              27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 
             43, 44, 45, 46, 47, 48, 49, 65, 50}]},
           Annotation[#, "Charting`Private`Tag$1251499#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV0flPiHEcwPEnSjlSrj+gvwLl+CGRY0Ns7pgrW1Et5Nqcm7O5jbllo9gQ
5syy5Db3sbnaUCwUy5zh9f3htffz3Z7P83yf75MyOT9rVkwURTXEubjLTooY
RTrdec4hFjOFobThHruYzWj60YMXHGYJUxlGPPfZzRzG0MAZ1pPBG46xkly+
UMlW/nGLnrykjNhWUbRUf3CFaQynnpOs5Q/XyaeZKtqa264xekcTNUEfsIe5
jOUjZ9lAf95ynFX84irtzObpVy6RYL0tHKre1lReUc4yptPIBTaTxXtOhTM1
s05buEF76wL9xmV2hL3zkL0UM45PnGMjf7lJB7MD9B0nWM1M0njNEZbzkxpy
aOJi+Fdmt+gIPnCaEgrD9/KIfbR23zz9TjXjyaRX2DuP2c98JjCQ3mFv4czp
SBLJdApn7HmdtQtPOMACshlEH7rylFIWMpHB9KWWo6xgBiPpxjMOsohJfOY8
mxhCHRXEef8a/c01/gMzpmpD
             "]], 
            LineBox[{366, 499, 447, 407, 320, 481, 429, 389, 361, 341, 278, 
             473, 421, 381, 353, 333, 321, 279, 280, 281, 282, 283, 284, 285, 
             286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 
             299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 474, 422, 
             382, 354, 334, 322, 482, 430, 390, 362, 342, 490, 438, 398, 370, 
             502, 450, 410, 514, 462, 526, 310}]},
           Annotation[#, "Charting`Private`Tag$1251499#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{530, 580, 531, 532, 533, 534, 535, 536, 537, 538, 539, 
             540, 541, 542, 543, 544, 545, 546, 547, 548, 549, 550, 551, 552, 
             553, 554, 555, 556, 557, 558, 559, 560, 561, 562, 563, 564, 565, 
             566, 567, 568, 569, 570, 571, 572, 573, 574, 575, 576, 577, 578, 
             581, 579}]},
           Annotation[#, "Charting`Private`Tag$1251499#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{259, 260, 258}], 
           LineBox[{528, 529, 527}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotLabel->FormBox[
        TagBox[
         RowBox[{"n", "=", "40"}], HoldForm], TraditionalForm],
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmnk4VW3bxsm4tnme56HMIURyX0kJRYlCSqVEhmhAJdNDKGmSsaSMUSpF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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{600, 37, 35, 419, 420, 615, 563, 523, 495, 475, 463, 
             421, 616, 564, 524, 496, 476, 464, 625, 573, 533, 505, 485, 422, 
             617, 565, 525, 497, 639, 587, 547, 477, 631, 579, 662, 539, 
             652}}]]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV0d0v11EcB/DfzyrVVeGiLNYPsZoeuCq5qIbRlGVolVrp4Qo/FzKZmodl
xehhPSJ6+GeEuirhqnBRKVeSC1mvc/Ha+7zPZ9/vzs6J1cUrGxMikUiUdzyz
yJKZvLV+w2tGGeEVH5llia0+zucGw/oHZvhNlb17bOEJeVxnyCxBplNCGwv2
9sgXnKKTVXs1spcUCmli0v46qdYnaGE6nE1e4AEZnOQOv8w2y0NcY1DfJyvp
IRrOznkGSOM5xdxiPtyJLKeDv3qyPEqcCf2ifEQOL6mgm39mQ/IsfezkODf5
YhaTZdxmUU+UB7ka/hPuXF7iMXvD2TnD3fBonKOfXRTRypzvVqi2vk8STykg
PPa4Wa18SDan6WLN/g55jGam9N2ylHZ+6pvkAerCW+nf+MN2/QgNvNc/84ON
+n6uhDvVv7LMNv0w9Yzpn/jOBj2Xy/wHjmNN/g==
             
             "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwl1He41gMcBfDb3nvvbqK9995FRmQkEoqQkRUlmSHRLrtsZQsZIZuMyi6z
jKJkZoXwOY8/Pvd7znlvz+19f/e5heMmjTytSEFBwQJfcgf7ssud6650Z7p9
WMhU/SK3C/P5SZ/tDmSwfJ7bjm/lWW4/HpQvc3vym9yMY+WavCNfw6Vyd37J
a1wgd+IH+RGKMkT/030sP4eL9a78nNeYJrdnh/wQzRmn1+Jd+dp0ijHU9pf7
eP5dOi0Yb6/Ne/J16RRnmO1v9wnOT6clJdjba7vdJ5meTitKUorSlKEs5djH
9//jrsr7TKc15RnutX/dp7gwnTZUYN88HJ7OM0inLcfZ6vC+fH06Fdkvz5Nn
8lml047jbXX5QL4hnUrsbyvKavmSdNozwVaPDfKN6VTmAFsxns3zS89no3fg
O3kFHThBr89G+SZmyD34Na/lfcqd+VG+2h3Ao/IVbm/+kKswQi7Oc/KVbl9m
5P/qdivy/+/vTn2OO4jFjMgzcTsyj+/1q9z+LOJh/XK3F7/LHTlRbsCH8pJ0
qnKgrQTP5/c5nU6cZGvIR/LSdKpxkK0kL+RnpNOZibZGfCzfnE51RtpK8WLe
ezpdONnWmE/kW9KpwcG20rwkz0ynK6fYCvlUvjWdmhxiK8PL+fzS6captiZ8
Jt+WTi0OtZXlFXlWOt3JH4s92CTfnk5tDrOV49V8xun0YJKtKZvlO9Kpwyhb
edbkuafTk9Nte/K5fGc6dTncVoHX5Nnp9OIM2158Id+VTj1G2yryen4n0unN
mbZmfCkvS6c+R9gq8YY8N50+nGVrzlfy8nQacKStMm/K89Lpy9m2FmyR706n
IWNsVVgrz0+nH5NtLdkq35NOI46yVWWdvCCd/pxja8XX8r3pNGasrRrr5YXp
DOBcW2u+ke9Lp5CjbdV5S16UzkCm2NqwTb4/nSYcY6vB2/LidAYx1daW7fID
bPDH+j8ahq5L
             "]]},
           Annotation[#, "Charting`Private`Tag$1251745#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV0ftPzXEAx+FvTchlc2vLdZIYEyU2oi0qc800lyJGhDYVm9xGUmO5X0aF
ikj/ic2dH5REW25bibC5bjLP+eHZ+/v6fM45O2cnJq84qygsCIK7VHnYHB4E
0+hDp37OPXbpOQzhu+6gmi06ngi6dDP3KdRzGcoP/YYa8vR0+vJRH7aLGU+L
3mtTieavLreZTOICuTxwXmSTucIwTrKGn+7ecsBzOmM4Sw4Bx1nFNaZwiU3U
c9X7ttoZ9KNbH7FLiOGFLrELGMlp1nGdXncVdmXoc5jMRTby0F2xncdwfuky
u5yJvNMHbQbVjOUc66kljBNkMTX03b1+m02gP590qV3KBM6zgTpa3e2zCxnF
P/2I3Z7nM4JTrOW382N2BTXE8d7ZIbuIcYSHfq+zfJvIZSKpZDWf3b3kMbVs
dzaTAfToNp5QRz03uEkDt4j1N922jezwniQG8kW/4il32OlsFoP4ql/zjD06
hSj+6A80UaBnM5hv+qhdRizter9No4rRnCGb/8FZX5w=
             "]], 
            LineBox[{511, 644, 592, 552, 465, 626, 574, 534, 506, 486, 423, 
             618, 566, 526, 498, 478, 466, 424, 425, 426, 427, 428, 429, 430, 
             431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 
             444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 619, 567, 
             527, 499, 479, 467, 627, 575, 535, 507, 487, 635, 583, 543, 515, 
             647, 595, 555, 659, 607, 671, 455}]},
           Annotation[#, "Charting`Private`Tag$1251745#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{675, 725, 676, 677, 678, 679, 680, 681, 682, 683, 684, 
             685, 686, 687, 688, 689, 690, 691, 692, 693, 694, 695, 696, 697, 
             698, 699, 700, 701, 702, 703, 704, 705, 706, 707, 708, 709, 710, 
             711, 712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 722, 723, 
             726, 724}]},
           Annotation[#, "Charting`Private`Tag$1251745#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
           LineBox[{673, 674, 672}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxd3Hk4Vd0bN/BT5kTmeZ7HQplKay0iUSGVKEWKkIQkU4UmDYRImZIhmiSV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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{1093, 1321, 1319, 578, 579, 1112, 972, 849, 747, 
             1212, 1072, 949, 1237, 1097, 1259, 664, 622, 1153, 1013, 890, 
             788, 705, 580, 1113, 973, 850, 1229, 1089, 1254, 748, 1213, 1073,
              950, 665, 1194, 1054, 931, 829, 1222, 1082, 959, 1242, 1102, 
             1262, 623, 1154, 1014, 891, 789, 706, 581, 1114, 974, 851, 749, 
             1214, 1074, 951, 666, 1195, 1055, 1248, 932, 1233}}]]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwV0klvTXEYB+C/aWvcoCwsqMS0oMOttuaSUqWG7m0UpRtjjF/BvDLGzEJL
orSlWqVFShAlgqDVVojxA3jexZP393vPOffcc+6dsK6mYsvAlNIAOslRJg9J
KZt58lzmUEwRhWzmON9YMSilJ1QOTmm23swofRf/OGBfbffDLOMtd+0zZhuF
8lnGy5c55tyb+gy5gf74DuZTyu3fm4/NtWaBY61ycewoka+RLd/gnuNLzS7u
2H8xc7jPSL3XXMAzdup/2S9vcl2TnC8/iOeSzzBOvsTReHZzCa/iXo5Nj3vQ
59hyvYM1ekZvkYvkDhbJ/eZiXnJV/2ROoi7ejfO/m6W85rbjn81ZNDNCn292
skP+YP4x95kbXbvMfEOjXbeZR2u8K73PXMhzTutZ5kWOuK5Onxb3o1cv09tZ
refr5ea7eHd2PfG70R6fp5eYL7giTzRraXJNvT4zfgeGy9v5zV59g+MZ+RRj
9QsctqvVp8r1fI3n0R+xKp5Fb2SYvo1f7LGvsmuQc+WW+L7yST7KYzjPIedc
t5si36In/hv6Qyr03PgMhupb+clu+/V2efIJRuvnOGjXTaldGyvt/gOMynHF

              "]], PolygonBox[CompressedData["
1:eJwV1FWQVwUYxuGzRWMLtiygEnbdOCPGjGAr0tuFTbd0d/cuLaWwi4J55Ywo
KirdS9sBNg0+38Wze97f7sXO95+zmYWdW3ZKTZIkhbW+PJiWJE0ykqQpHf3g
eHqSPEcl6/2sme8bedxzRfyu5/c56nfvt8uoay9hsvaovZKG9ho+1mrb3TlG
P61EO8J9dil1tMVM0j6iltaN3+mrF2uHudeey5XaIiZqH1JT68pv9NGLtBae
y2lsv8ch7R57DlfYC5mgPWKvoIFdwQdaDbsLv9JbK9Sae15NI3sdB7W77dlc
bi9gvPawvZz6dnncSqtud+YXemkF2gHusmdxmTafcdpD9jIy7dXxt2vV7E78
TE8tX9vPnfZMLtXmMVZbR1XtdX6ih56nVXKHPYNLtDLGaGupor3Gj/E56bna
Pm63p3OxVspo7V0ytFf5IT4nPUfby232NC7S5jJKe4d07RW+j89Jz9b2cKs9
ldraHEZqa0jTXua7+Bz0LG03Te0p1NJmM0KrIFV7iaNxZ72Dtosm9mRqarMY
rpWTor3Ikbir3l7bSWN7EjW0mQzTmtlLqWevis8kXh67I4fjzlo7bQeN7IlU
12YwVFvFBUr0Q3Fnva29nVvsCVTTpjNEe5vzFOsH4856G3sbN9vjqapNY7D2
Fuco0g/EnfXW9lZussdRRZvKIG0lZynU98ed9Vb2FhraY8nQpjBQW8EZCvTK
uLP+gr2ZBvYY0uPdZ4C2nNPk6/viznpLexP17dGkxbtOf20Zp8jT98Zd9eft
b8m0R5Ea7zpvaEs5Sa6+h5L4f2V/Qz17JCnxbtNPe5MT5Oi7Kdaftb/mRnsE
Sby79NWW8B/Z+i6K9GfsjdxgD+dC3FXvoy3mX7K0nRTqT9tfcb09jPNxV723
toh/6KDtoEB/yv6S6+yhnIu76r20hfxNe207+fqT9hdcaw/hbNxV76kt4C/a
advI05+wN3CNPZgzcVe9hzafP2mrbSU3/tfbn3O1PYjTcVe9uzaPP2ijbSFH
b2F/xlX2QE7FXfVuWhnHaa1tJltvbq+nrj2Ak3FXvatWyjFaaZvI0h+zP6WO
3Z8TcVe9i/aJ5wc8b+B/pKji2Q==
              
              "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwl1WWYVlUUgNEZGmkB6RiQFCRUuhtFGkklpLsbFAWkVEoRVLokJKSRLulG
Qbo7lE7Xefyx2Pu9dwbmxjdENetUs2NkRETEu9EiIsLc6o9GZNMvdSpzhc5j
/qLjmXP1W2ZVM5O5wfzYuUj7ZHs50tnXmPcdT2pfbP+Id/QVcxBZOKwTOb/A
XpOvdGw90/4+T7WM2Bb+DV7Z5xE//Dy6Gp+Er9FT7OV5EK6Hq/YvyMoRPYzo
bA/fEy6W+UZj3uOa/jJcO0f1cGKwQzcmkgW6CQWIyR+ONSEaC3VTChIrXAdx
iMtr4d6x09c1JTq/6mYUCtfDLseaEYNF+lMKk4Ddjn1KTBbr5hThuh5Mdo7p
ESRkj25OLJboFhTlhh5CDv7UI8P9Z69uQWyW6pYU46YeSk7+0qNIzD7dkjj8
pluFe+sZTNUVeKiLcys80/C+cDx8r69ZaK/F1+H+6Fn2D8hoX2c+c/wN+2/2
+iTR+81WxCW1cyvNZeHe2OfZc5nVzczmRjO/2To8P3NauF6zopneXGvmNR85
n8xcoutSQt82h4W/jxM6ifO/2mvzTXiWera9ClH29eZzx1PYl9kbhPfNvsV8
3fEDZmteI43jq8zl4RnZ59tzmzXMN81N4fNhtgnvljk93HezkpnB/N3MZz52
Prm5VL9t1gufJXNz5P+f45LO37EPD++Fzm2mNVebfzv3un2RvQ7fhndTz7F/
yAudUi+3NySpPmi2IR4rdNvwfvuaGboyT3Qp7tpHhJ+Jk3p0uL8c0m2Jz0rd
jtLhGsJzDveOw861IwGrdHvKhJ+FI461JyGrdQfKht9NHHWsA4lYoztSjtQc
cyz8ckvMWt2J8tzTI8nDKT2GNPypO4X3jd91Zyrwjx4V3hlO67Gk5S/dOTxn
1ukuVOTf8G6HZ8UZPY50HNddwj1lve5KJe6Hdyu8s5zV40nPCd2VZGzQ3ajM
g/DcwrvCOf0dGfhbdyM5G3V33uehHh3eDc7r78nISd2dN9ike/ABj/QY3uOC
nkAUp3QPUrBZ96QKj/VYCnBR/0AmTuuepGSL7sWHPNHjKMglPZHMnNG9SMVW
3ZuqPNXjKcRlPYk3Oat7k5ptug/VeKa/ozBX9I9k4ZzuEz6HbNd9qc5z/T1F
uKp/Iivndd/w2WGH7kcNXugJFOWa/plsXND9SMcfuj81eal/oBjX9WSyc1H3
Jz079QBq8UpPpDg39BRycEkPIAO79EBqE/6DnORYCW7KqeTksh5IRnbrz6gT
7ocuyS37NN4K53QUe+yf81G4D7oUt+3TyRXO6UzstQ+ibrh+XZo79hnkDs9T
7zO/oB5l9F1zJm+H56f3m19Sn7L6njmLPBxgMA3C54/Z5OUgQ2gYPmfMIR+H
GEoj5pKf/wDNswfF
             "]]},
           Annotation[#, "Charting`Private`Tag$1252053#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV00VTVmEYBuBjrZyxnbEdF+rCDkAkDMCgFLCXbmzZ2Nj/wI4ZG9uFgEpj
oAgI2D22gopda6+zuHju+3nPYYb3++g3PztzeYsgCNr6EdEyCDJaB8GNVkGQ
zHt9G7l23ThgF8UCuxz9u7yCdpTaRZJpX6Wn8EEv1AdxXt+uH5e784qDdmO4
JkdSKi/0zHr5h7yS9pTZRZFlf1NPpVEv0geTp+/QT8g9OKRHs8hug/5TXkUH
LuujKJLLnefJ/Tmj3zMnkShXm7F84Kr+3JzGGO/MMKvt0mjSi/Uh5Os79ZNy
Tw7rd8Lfx0fG6pVmFO8p05+YqSz23kbzl91Lc7XZYE6ko3zFHM1bivVHZjJf
qPBuvjmAN5x1ft+czCeS9Bozjmvh3Xh+plwjp/NRL9GHUqA/MKfwmV3OTpm9
OOIshuvhPVAuL3G+Sf4tr+G2nEATnfSrZgTvKNEfmylc9l6BOZBz9pOoleOp
lMc6nyXXyi/CuzfrzPHh3+Ss1BzGBfvd+mm5N0f1WG7I0eHdyE/NNL6y1LOb
zT/2a+kc3q1dDLPtb+nT+azvYRmxxBHPOMYzgYFtfD5mAnO8W+e9DJr1Mn04
F/WH5lSa2etsOVvkv87W0SW8J7tE5trX65nUyxNoDD9nZ+XmCC4526efkftw
TI+jKvyOhXcrPzPT+Ua2Z7ea/+xz6Br+z9klMc++Qc/iq16hj6RQ36+flfvy
mly7u+H3if/LxZPY
             "]], LineBox[CompressedData["
1:eJwV1FV00HUYx+H/ggYRA1RUGKACFhjceA4Y50hYiHQzYPQ2UkW6YRuMTjEp
dRsoYFx5jthBd4OFKFhIg8978cD/+zlwwWG/NyMzp1V2SpIk6/zSOC1JvkxP
kkf41HduapJM9H3W9yiq8pn2JJ30zXZrTtlLGcwk/Zw2mmps0prSWd9it+G0
vYwhTNbPa2O4ic+1ZnTRt9pt+dN+laFM0S9oY7mZL7TmdNW32e34y17OMKbq
F7Vx3BL/Pq0F3fTtdnv+tl9jONP0S9p4qvOV9hTd9R12B/6xX2cE0/XL2gRu
5WvtaXroO+2O/Gu/wYvM0K9oE7mNb7RnyNR32Z04Y7/JS+TpV7VJ3M632rP0
1HfbnfnPfouXydcTJus1+E57jl7aHrsLZ+23GUmBnsIUvSbfay3pre21u3LO
XsErzNRTmapn8IP2PFnaPrsb5+2VjGKWnsY0vRabtVb00fbb3blgr2I0hXo6
0/XabNFeoK92wO7BRXs1Y5itl2KGXoetWmv6aQftTC7ZaxjLHL00efodbNPa
0F87ZPfksv0O45irlyFfv5PtWlsGaIftXlyx32U88/SyFOh3sUNrx0DtiN2b
q/Z7TGC+Xo6Zel12au0ZpB21s0goir+j1WSF3SR+hrQFdnlm2fXYpXUgWztm
9yGF4nibLNQrUKjVZ7fWkRztuN2XVEribbJIr8hs7W72xNsnV/vR7kcaa+Nt
slivxBztHvbG24/boP1k9yeddfE2WaJfw1ztXvbF24/boP1sD6AU78fbjDuj
V2aedh/74+3HbdB+sQdSmg/ibcad0a9lvnY/B+Ltx23QfrUHUYb18TbjzuhV
WKA14GC8/bgN2gk7m7Js0Iq0DFbaj5IXd8e+joV2Qw7FLYhbof1m51COjVqx
VotV9mPkxx2yr2eR/QCHtfV2XYrspvEzHbfEPuk7l/J8qJVotVltP05B3Cn7
BhbbD3JE22DXo9huFj/zcWvs330PpgIfxVuPu6XfyBLtIY7GLYlbo/1hD6Ei
H8dbj7ulV2Wp9jDH4pbErdFO2UOpxCfaWq0Oa+wnKIw7Zldjmd2I49pGuz4l
dvO4gb6bsCn+P/3ektNk+bP/A6lS4nY=
             "]]},
           Annotation[#, "Charting`Private`Tag$1252053#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{1267, 1317, 1268, 1269, 1270, 1271, 1272, 1273, 1274, 
             1275, 1276, 1277, 1278, 1279, 1280, 1281, 1282, 1283, 1284, 1285,
              1286, 1287, 1288, 1289, 1290, 1291, 1292, 1293, 1294, 1295, 
             1296, 1297, 1298, 1299, 1300, 1301, 1302, 1303, 1304, 1305, 1306,
              1307, 1308, 1309, 1310, 1311, 1312, 1313, 1314, 1315, 1318, 
             1316}]},
           Annotation[#, "Charting`Private`Tag$1252053#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
           LineBox[{1265, 1266, 1264}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}]},
    {
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJzt2fk/lHv/wPGZkcxMlhhFiNIgilZbcT6fLJW2kVSUSBEhbaS0WOrgSFEp
kf0olaJFCHW5VVp0ohCHMMaa0iyWLKfcfb/3eV/XeZz7vv+D2y8erwfe8xlj
Zp7vy8wdex08GTQaLZlOo/3f56GWl0+5p+N/otFCFRQVw34aqTe9KKp/h1bu
IdxYPAI9sc7OepvZjky2jT1UsK9GGq0Pu3bM7UO2+Fmut0UDUvZzuylj3Y+6
HgaJjtL46PyC5SXrNg6j+Z9aHFimHej3y/PLxJO/oadav981ut2LTmeFVDGm
0bFtpROeNVeCVOLbf7mQIoWdltptn/5pCEU62v30bkgan3qatGav0xg6aJ7h
9jKciZ+6NHFzlWjYRjga7N/OxgVbBzeVmjFwmMV6dzUzORx0a0O+5UEpvCQ3
Mf8EoYCtbpfrHX0xAfsNi0NfyCniQH+2QvvEiXhkzuQWw41K+F7rDlmZ7TLY
IudW+qVLHGzqvt616R4Ti5VWbd9UroxVDW0cx2aycEfM9k0HZKaSbScMsus0
USH7807mwfwQVbKXc1UYkeXTyFb6TffsHaEa2RpRefYmJhpkX55jPpnjNZ3s
V2rLjPvPaZK9RKM8bt57LbLlpTID3MNnkK0ZpmXhrDuTbJaOS4HDc6qNLKfl
BW3TJvtAi9KTVbRZZAv7YzbaXaZ6xbyKJDtDLtmP+5eOfX1Dtf/chY1vPXXI
tvziUevM0iXblqu6Vi6T6tmh0YfLTfXINvA0J3QaqfZ87H0qf/9sson0Wg/x
FH2yB66Pf51XSPVOnRxW0loDssUGF0zuiaguyhprG4yaQ/YWm1l4qeZcstX3
RD40KqN6Ctvv7trNhmSn7ikeHB83/Mvj2dssri9HOLYtbBIvD9W8ebdwzutB
dNohJ6NcXYBMPEssZ9wfRWb2pk2Wpl1oWJSQdzRjHM3eaptYHC5ELsrr+tTv
s/Dq9CWbQxbQsWCKrv9TOVk89VSW9Lc6Bk7ydUWCQSUcMGOL8X4WE091Oxp6
aC7199fL27i1w2MK2Y1LL9Rcy6HO11q6bu9A/T00o0anQoGXhgKmJ/onRg4g
8whFOy35NuRRGXrM9NQIun6yenruwk7UY9NRaOL8HR2yjL06oNKHeq4FXZOo
sXDUd/bjqZk0fCE8LiDx8CTcJVyT6xLJwK9WF8pHXVXCyqEtM0rzZbC+dHxc
RBsH31vwRKGJzsILQ2W/lk7+ipo1bUc99dsRc3zwO1Mwhr6bRi03OdCDqsO4
i21Xs7GClY+ou4yOfU9L77NYzsHvy+rsdF2ZeMLDHft2BVH3V/GLyvmR+kxE
25q7TpUXi57aHIux7+xHk9OfJq+N5KOjJ9rVn3weRn6Fm4ua8jsQ359tofzg
G0o2ys85J/iEjPbJSrW8YeJrhgf379hCw5+Lnn2VMpqE3+hkhMtuZ2BByc6h
LceVcHte+iX3aBm80Cn9snwpBwfYsU23NjJxeLZQOcB/COWbDa+NzxQgrXtO
qfGrxpDa09bJxY7daOrqh3Hzx1nYcP+7XxcdoePwsbubFTQ5OEuUQFQuYuK1
qprNOeqjqJNndzL0TieSnpfN75xA3b/ooth65wQ2FikxLJOZDHzI/ma9VMN5
FOpDuOnzQpBfwx71ufH9aGxuakWHNR9NbIj/xMwYRuvWX/lZEtiBPpyc/p2x
8xsyyq4w4q/4hKprN92tuc7Ei231VkeZ0LCq43bzh8xJuBxX+nmsYeAv/eY+
NruVcOXzsPWLA2VwYdi1ZIcbHLyx7vaqKxVMbLC07Vfe9CGU9uxt0Bw3Abo5
ie3f+H0UzY6eNDT2rAs9zJNCur+zcGlUxHHnjXR8dlFU5TCLg2OYR4JTNZm4
YX/VLXHVCKr4GGOfsL8TZTWdibEa4ODqq1p/JE358Xua3vgzbz8bhxoUTC3v
oONco6T4V284+MKjXbPUvzDxwS5/wRIdNk511nwll0LH5Y/95HZ5jSKpAumC
3cJOdCUq7FTxNOr3173BVt/jERvn1nsvz+MyMJ5StUO1IRzRfmkLW83bi3Bm
lyDRtx/t64/eOl+bj16f2lMz5+gwQpqWn49v6kBb5PXcRs2/ocPtvH2Ro71I
W+ZY1JuLTPyHPd3sCpeGczMMGzlDbGyxju8eZ8XAAwo6XHM3JUxskOSm+Mjg
4Es3UgfSOHjFlRDHklIm/j5hi++jgUE0JeaxbJClAO0rEmz81jCK5u/J6Ek+
0YXYgtlTZ1aw8Mn47T5+1nQczzv4c9+4Eg6N/1gvo8zEqZrX45VvjqDCAqNC
bYdOtEsUd7ajl4PLfMXSJZNY+ARv3GWVKxuvMImTqntHx/usUy75PePgUyfN
DJd2/HhfVI1/aKzExp6ewwUzTtNxlK/tYNSyUTQQnq0xWNWJzCJ8aG432Xi2
zGz7X9QYeKzaSUttjIO1J7BOvNVg4Q+9+bmOp9i4SPODft4QHf+hGK9jfWYU
KX3cyWuR70KXZs5w2F3Nxvem5b15YMTAtamqR5Y1HEC0FzoVsTw3ZCDza4X9
5n6Us4muu0mRj+Y1Oa+w9B5GRRPOpj1Z3oGSanIUDul8Q+lhyopNNb1oVbr8
wOoYJuZv8s/NUqfhIyvjDf7xmY2Ha31crlky8FCKWtiiLUq4KPHmNgdPGdw0
IyfN9goHoxPezpWFTNyzeyovgD+IeMLF9clzBahGvuqlfMUoynf97N63pQst
OloSllrKwl5Jv/EDl9BxQrO3oHtUCQc3ZkSUyjMxPTCeqZswguanhPh4W3Wi
F8HnY427OLh4XSO7ciILZ/ece/HckY3nWHw70vKSjt/+lprwqIyDj+2auXB1
KxP33dXVuc9kYztfT0ODcDru/ceC3UlGo8hv93DVkrJO5K71zfdDOhvLyl2s
OK/IwNbrY06Lhzm4odzka/SP19kJp1aovQtm42SuXXpRHx27eYcmOgaPouiq
fAZ3vBM9Lr73qKuCje8Mn46+p8/A0rtiz1wQcvCLKCY9ZzILT+6rj2+7z8a3
CmwZt7QYOLEk++6C9FGUyOAkX9bs+rfXm78/3rT//1DGKZd1d+/SYmHwn+hM
y0CbXgsC/62queib8l1A+g/HCZ6mW3aT/ntxce7KK4s/kf47HxHWektFSPpv
fMOJvOhsMek/tc2pS9PyxKT/6KJFL7kuQtJ/cgcmu1b4fiL9x8xmuRoS3aT/
ek2O2C990o7Af8fsbPRv6rci8J9Zz7YrFQ6vEfivyHACb8+suwT4L/qx9QGN
kDoC/Nd7xj7nJqeDAP+p9+r3qFv0EeA/2p8f4D9o8B80+A8a/AcN/oMG/0GD
/6DBf9DgP2jwHzT4Dxr8Bw3+gwb/QYP/oMF/0OA/aPAfNPgPGvwHDf6DBv9B
g/+gwX/Q4D9o8B80+A8a/AcN/oMG/0GD/6DBf9Dgv5lnGItWsNpI/2WdTou9
kygi/ec+/fHO2GQJ6b8zehrVDbki0n/rndA4t7sNgf+qU4+URNx4j8B/40sf
2bVn9xDgP7h98B80+A8a/CfXWzQ1WZ5P+i9I707IEyUR6T/kfjvrkI6E9J8j
apa2mCcm/Zey4oPe/DoBAv9xB1wPXP7YiMB/wx0RoxXbugjw36UERmSRq5Dw
v1u1LYVDnW84M8QqOIw6H/jwrfBsWsoMMelDyyW5PBVdCelD6d2Z76eN8BH4
UO5C/+VxcS8BPoR5pbXXPGrqqPngxYkLZiue0W4lvVjWu0+YmCokvZjWOOVm
aJeY9KJp5aP0PXvFpBetCINS4zXtCLz4OvXt2gxWMwIvBj789K7IrJMAL9bi
S6Y+a78Q8wWyrSO91Pki3g+O7PSjzgeeLLFMUNFrFpGerJpT4LzBXUJ6Mocv
8tHa14bAk+FeTvvFrz8ScrJ7D39ZT81fzZyu8aiMmg/ebO22SfPzkKDMZoGd
jBcLf606c8HAVUC+H8D3gz/dxBuslMP5yDBj/u2PvdQ88Giwm9RJ06stpEev
mx3xmrVVSHqUp/LqlvRzMelRfUUj/4hYMelRlbH1EUWR7Qg8yh2ILrk6rQWB
R/NnaRILrnUQ4NHDU/gKT572EXHBOVrX31PnXSe6U9fgTp0PvJrncaXGt0RE
evUyt9hVfEJCevWEhqpxZk4bAq+WvY3e5rPkI3HeOPDYQkTNV9Ju+LqggJoP
no3ljmSIbSTI1spw+A/8Yy+f9GDb7UQB6dv+8qJct24hAb5daHhUNuERHw0U
f4py5VPzwLvmfmvcFN9/IcC7DVkv05MXtyHw7rycuOTukxLSu/Dz4N04bu33
c1p8tCsy8G3AIDUf/Js/JCqJ2dVC+jfF7fgsb3Mh6d9sY67RykIx6V/txV21
59PEpH9piZ6fjlxtR+Df6lQvSXZGCwL/vnMyNf7i0kGAf38bn3Bsb2gfUfbD
XiGvqfMuPH7W+oILdT7wsf7hlAVnb4pIH/8xw8K97IyE9LF38ZyknS/bEPiY
PzGrRlfcQziuOnyi1piaP5T7wPPznb+8Xv/p526rDbMWG0vQpQCHqq+GLJx/
40W5f6GA9PSy281qsr8KCfC0RuXZ/U5NfNSw4uWQahM1D3wduWl/5aNzXwjw
dblVs7SrQxsCX0e+7J1uECBBrimnIlwmU+cDbwdtwM0OHny0SnkDmiei5oPH
/lUiAvy9MtYruy6Nj8Df9TEm6lcvSEh/r7Q7xPHKb0Xhowk7i0epeeBxh3Iv
J9MVLaTHVQ6GhEXPFpIer7F567/7h7/A46m2VszEHz4Djw95CVO25Lcj8Dh3
oE7uRmcLAo9v7bfet8asgwCPDwSo3LN17SMa/LSrfZ5T9z/L+niwyJk6H3i9
Kyx1u1amiPS6kdZxgd5FCel1l18erLFpaEPg9b0Zd+R/ft1DPKg9EqKzgJrv
HZiVbJdLzQfPcxxoHhsNJYiQ61wSyGXh64cdAnkVAtL3e7VF9oJQIQG+V0xS
5Zr3/nh85IsMDzVQ88D7uZUn6fF7vxDg/UJFr6Kf3NsQeP9+Q4Lrar8ft6cX
EXl7EnU+8L+v9qvYRQf5qLRx2aGYPmp+fKiXg5a+AtmwD/zkKnYuyOUj2Aek
ktu3VpyWkPuAmV1s1LORVjRQFpGkMkzNg/1Azayyw/iZkNCZ4hwW5DiKthZb
NjOPSRDsC+FZ282XWfER7As5x39pPHnlx9cX35i77dtf5v3t/eLvf6//+qyM
8c6L8lmyfAL2B9g3YH+Ahv2BvP755/4ADfsDNOwP0LA/QMP+AA37AzTsD9Cw
P0DD/gAN+wN5vfXP/QEa9gfy/v25P0DD/kBej/zf9eP/XT/+D9eP/9v1W4/A
g3WZX6nn1/fi8Pcz//J8o/4/85+ejzTaPwHYQzNw
        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{312, 412, 344, 174, 175, 176, 323, 291, 264, 243, 
             227, 217, 330, 298, 271, 250, 234, 177, 324, 292, 265, 244, 338, 
             306, 279, 228, 335, 303, 349, 276, 409}}]]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwlz8kuQ3EUwOHb1rDBQtOk0hS1waKNpCKhUWqjFkQQMSQ0HoAHsjLU7GmM
G+MGC+NGLTS+xuLLOb97kpv8U2sbM+vhIAhClNhiUyxwar/mkS8afetijBOd
M5dJsMoA86H/nw2ySIw+pnlxiptZZvnRLWYvE1zpKlF7hike9CcN9hQFjvUR
hxxwyT0f1Lt3Msq+fqZCs+6hyEXtreYQS7SxQj9z/Lq3mmkmudPv1Nk7GGFP
P/FNk+5mnHN9yxsR3U6est5lh23OuOGVsHuSYf4AJ9Etbg==
             
             "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], 
            LineBox[{1, 132, 109, 89, 74, 61, 51, 2, 3, 4, 5, 133, 110, 90, 
             75, 62, 52, 140, 117, 97, 82, 69, 6, 134, 111, 91, 76, 63, 144, 
             121, 101, 86, 149, 126, 106, 153, 130, 157, 53, 141, 118, 98, 83,
              70, 7, 135, 112, 92, 77, 64, 54, 8, 9, 10, 11, 136, 113, 93, 78,
              65, 55, 142, 119, 99, 84, 148, 125, 105, 71, 146, 123, 103, 152,
              129, 88, 150, 127, 156, 108, 154, 131, 12, 137, 114, 94, 79, 66,
              56, 13, 14, 15, 16, 138, 115, 95, 80, 67, 57, 143, 120, 100, 85,
              72, 17, 139, 116, 96, 81, 147, 124, 104, 68, 145, 122, 155, 102,
              151, 128}], 
            LineBox[{87, 107, 58, 73, 18, 59, 19, 20, 21, 22, 23, 24, 25, 26, 
             27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 
             43, 44, 45, 46, 47, 48, 49, 60, 50}]},
           Annotation[#, "Charting`Private`Tag$1251552#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV0FkrpnEcx+HHbspSlpAsD8pSg5BCdmUpS0iWzExeAC/AK3FoZzDDa7Ef
2JWl7MpS5HJw9f1/7t/ZHRyb6B0PCQQCk0xTKzII5UYfsMkMs8wxT517JmHc
6kO2aNX5xPCiL1igXmcRzp0+otP7Jwl86H5bwS/SGKaaP2y7t9kCYnnVlyzS
oLOJ4F4fs8MSy/xlhUb3IJE86BO6vItJ5FPv0u5dSBxvus+Wk8qV7rGlJDNE
1fcPZIBKfpPOCDWsOjfZHKJ41Kfsscagb//sf9Zp1rlE86TP2KdDFxHPu75m
gxadxw+eda8tI4Vz3W1LGCWJKb4AfmU5qg==
             "]], 
            LineBox[{255, 341, 309, 282, 218, 331, 299, 272, 251, 235, 178, 
             325, 293, 266, 245, 229, 219, 179, 180, 181, 182, 183, 184, 185, 
             186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 
             199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 326, 294, 
             267, 246, 230, 220, 332, 300, 273, 252, 236, 337, 305, 278, 257, 
             343, 311, 284, 348, 316, 353, 210}]},
           Annotation[#, "Charting`Private`Tag$1251552#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{357, 407, 358, 359, 360, 361, 362, 363, 364, 365, 366, 
             367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 
             380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 
             393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 
             408, 406}]},
           Annotation[#, "Charting`Private`Tag$1251552#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{159, 160, 158}], 
           LineBox[{410, 356, 354}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotLabel->FormBox[
        TagBox[
         RowBox[{"n", "=", "4"}], HoldForm], TraditionalForm],
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmHk4lG37gJXEjBnb2JIlQskSighddyjRQlIha5ESIiWhQkJCm2yJSBGl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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{311, 23, 21, 173, 174, 175, 322, 290, 263, 242, 226, 
             216, 329, 297, 270, 249, 233, 176, 323, 291, 264, 243, 337, 305, 
             278, 227, 334, 302, 347, 275, 409}}]]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV0MkuQ3EUwOGr6AYLYorU0A1dVJpoJG1TxaYsiKQiSBDpA/BKhpo9jXFj
3GBRQzdqoeHr4ss5v3vu6h8tbhe2QkEQNLDJDt10cc4tz1QI+ynKNGc6Y67S
xzrjLPHnljKX6STBAm++95hjFPjRbWaMWW50jQ77KPM86S+a7UNMcapPOOaI
ax75pMl9kEkO9StVWvUIM1zpDTPNCr2skWSRX/d2M84cD/qDRvsAOQ70C9+0
6GHyXOp73gnpfiYo6X322OWCO8r1t3ePkOUf7HktPw==
             
             "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwt0Vk3FQAUBeAbCamUvISEZkSmRDRoUInqGhrMUqjMMiQUQpGhpEj1V313
LQ/f2uu87XV2altvsGdPIBD4Syg/8XL3fsAWk/znEr8Y5x9tbPORk6wzSjN/
mOIem0zQzjGW6OMJN/jNB16QxQbvaaWCMKZ5RSWFnOInY7RwnwS+0c9Tysgm
nBk6qOIyp0lkmQGecZOL7GWWTh5SxBmSiOAzXTyimLMcZx+RRBHNfmI4wEEO
Ecscr3nMFc6RzAqDPOcWORxmnjcEKeE8J1hliHpuk8sRFnhLNaWkh35k3BS5
xjsauEMecXyhmxqukkEq3xmmkXLyOcpXeqjlGpmk8YMRmrhLAfEs0ksd17kQ
2l2nHf0kNKE=
             "]]},
           Annotation[#, "Charting`Private`Tag$1251837#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwNylkrpnEcx+Hnsdeg7JLtoSw1CClkV5ayhISYOZgXwAvwSpzZl8GM12I/
sCtL2ZWliOvg6vv/3L879GeifzwYCAQmmaZOZBLkRh+wyQyzzDFPvXsWYdzq
Q7Zo0wX84EVfsECDziacO31El/dPEvjQA7aSMdIZpobfbLu320JiedWXLNKo
c4jgXh+zwxLLrPCXJvdcInnQJ3R7l5DIp96lw7uION50v60gjSvda8tIZohq
vnwftFX8IoMRall1a7YhonjUp+yxRgrr/OM/Lf7JI5onfcY+nbqYeN71NRu0
6nxieNZ9tpxUznWPLWWUJKb4BpIfOeU=
             "]], 
            LineBox[{254, 340, 308, 281, 217, 330, 298, 271, 250, 234, 177, 
             324, 292, 265, 244, 228, 218, 178, 179, 180, 181, 182, 183, 184, 
             185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 
             198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 325, 293, 
             266, 245, 229, 219, 331, 299, 272, 251, 235, 336, 304, 277, 256, 
             342, 310, 283, 346, 315, 351, 209}]},
           Annotation[#, "Charting`Private`Tag$1251837#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{356, 406, 357, 358, 359, 360, 361, 362, 363, 364, 365, 
             366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 
             379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 
             392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 
             407, 405}]},
           Annotation[#, "Charting`Private`Tag$1251837#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
           LineBox[{410, 355, 353}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxE23k4lO/3B/DJNmPNvu/7HioKzX2oVPSxlD1JokKERJY0KVIkSsiWRIoS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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwVz78v3HEcx/FP3fkx3DHU0ETCaToqg5JQURImm+APqJ8T7Vj8A2burlM5
Ovlxx8jQMtBfU4Mb6jdT06bKJtHUw/DM6/V8vT/fXK765Vj3aEEI4QGmEC8M
oa8ohB4cOEzz7WgIlXgXCWHR1m9L8j98FDFkbLu2GizzN97V2wb5B96KLD/l
TTh0n+E7ehVm3ZdsA7YUv+RjWOe/eAfifJ7v6U+xwr/yW70X475/xof0j27f
9Qhe6Dl5Zm/GkXdJ/klP4Icew5x3m/LaVuz/d93/R57AI77su0E9bb+Rf73P
yxLE3V/xDf23e5R3yp+8AuW81H1B37f/l7XyTD5E1u2b/Gfrw7X+BBN+s0EO
2za9acMqP+fPceye4p/1amTcV2xDtrf8ir9GGd7b8rY65Pikd422Eb7F27HG
L3gLTtzT/It+Kx/LA3kHc8RNPg==
             "]]]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwV1PmXzXUcx/HvrMyMI8Qwtg7KXpoppRDpnKRz2qSTfRkVQrSpPyH7mn1L
MZb8YBfGXmgRUiFLhzHGZCzn2Mohj/cPz/ta3p/P/d773RoVjur+QWqSJCmY
6WOE8FZmkvRAx7QkKcY76UlSkJEkn5vlyCNRgRn6Qv0K/QK5gbwX03QndB10
2zBYl6/7TNeEXkMPXbZj3KEH5FXW1aB/o5XuCBbz2foX+HJslkfIlzBdHiQv
953z5fryHkzVHde1489gtdzefCsK5cflMeZv8v9hv7zSrDo9g5a6w1jEZ+nr
0jJ00V3EJn64vhL9Hf/wt+k0s4G0yHfX9r8e4ivwsj5TvkZ3yPOsf0DOid+J
evo7dDedQo/ZX8M8ly/B0/pEPk2/lZ+1P5UewhZ+kL4N/6l93fl/sS+uiVkL
/hAWypXl5/kybJTfl8sxVR4gL7N/bvxfeRcm6/7UPaP7DgN1j+k+0VWSh+Ei
puj765fq/4jzrtuMAfpH9R/rMuWhKMNkfT/9N/pu/FVsl+eY5fE7MSnOrflT
/CmsivNgnkJ/xSb+Bu1v1pp+ZG1d56gxfxVv6LPk2/SHuEfi+srV+NNorr8X
30UX0AzzB83z+AvorE+TL9AN8hDzTHo05vwtOsmsL/3asXOtbchfwkv6Kyjm
Z1tbJ647Jsb++E+6jeina6X7UFckN5MPYr4uXX4PpZio66NbYt0suXacL0zQ
/aZry5/ESrmt+Qb0lVvKo81f52/h+7jGce/RU2iq+wXz+LT4nbQUnXSp/k8p
XS+/a1ZFzojj4bx8k04w702/coxa5g3iWUBXfYZ8mW6TZ1pfVc6Oexu58dzR
YjqeHon99Bye1P2FFeHtS+hBrOf76Fvwo6x/jb8Z75q478we4X/GXDk13lco
wXhdL91ie76Ua8VvwjjdYV1NehZP6E5geXjrcvze/+P8yOvk67S33JzGyzLP
vBF/Ba/qK8s34v0T97X11eSq/Ek8rL9Lf6JzaEpcwziPeE6XYu15uk4ebJYe
5yTOBz9O35Nf5Jj1aTle1FVgKz/Dmqx4TlEzOoyNd4P1BfxxFMkF1q1FL7mZ
PNL8Ff46dsc9bNaE/xGz5UTuyJdgrVwon8VY+W15of3T45mRt+CLeJZ0+fwx
LJPzzdegp9xUvg/zBNS6
              "]], PolygonBox[CompressedData["
1:eJwV1Fe8z3Ucx/GfmZUQUbKKMiruSkVl73GMIxXpxj7H3mcve0WyKgqp7C2U
vQ6lJZuKUlqOPQ7P78XrnN/nef7/q/d5/Kq8Ex8TlzeKojya5cfCfFEUWzCK
umi+P5T3u1qBKMpRbP4oylW255U+V8fzUS1y13FPVyn3JmWxw75/Tz34OY3l
nfk8Vts9TSXZRmXyQzxXb/OzyuKd+Fz2nHuqSrANyuDZ/K668zPK5B35HPas
e4oeYuuVzg/yO+rGTyuDd+Cz2TPuySrO1imNH+C39RY/pXQew99ntdyT9CBb
q1S+n9/Sm/yk0nh7PovVdE9UMbZGKXwfv6k3+Aml8nb8PVbDPUFF2Wol8738
hrry40rhbflMVt09XkXYKiXxPfy6XufHlMzb8Bnsafc4FWYrlch382vqwn9W
Em/N32VPhf1UiK1QAt/FryqWH1Uib8Wns2phPz3AlmsM38mvqDP/SQm8JZ/G
qob9VJAt02i+g+eoE/9RY3gLPpU9GfZTAfaFRvHt/LI68h80mjfnU9gTYT/l
Z59rJP+a/68O/HuN4s34ZFYl7Kd87DON4F/x/xTDv9NI3pRPYpXDfsrLlmo4
38b/VXt+RCN4Ez6RVQr7KQ/7VMP4Vv6P2vFvNZw35hNYxbCfIrZEQ/kW/rfa
8m80jDfi41mFsJ/uaTEfwr/kl9SGHdZQ3pCPY4+H/ZSrRXww38z/Umt2SEN4
Az42vBfCfrqrT/ggvon/qVYsW4P5azyLPRb20x19zAfyjfyiWrKDGsRf5Zns
0bCfbmshH8A38D/Ugh3QQP4Kz2Dlwn66pQU8nq/nv6s5268BvD5PZ2XDfrqp
j3gcX8cvqBnbp3hej6exR8J+uqEPeX++lp9XU7ZXcfxlnsrKhP10XR/wfnwN
/01N2B715y/xFFY67Kdrms/78tX8VzVmu9WPv8iT2cNhP13VPN6Hr+K/qBHb
pb68Lk9ipcJ+uqK5vHd4h/Nzash2qg9/gSeykmE/5WgO78VX8LNqwHaoN3+e
J7ASYT9d1mzeky8P/wuec7TdfR8F3N3A
              
              "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV1XegjnUYh/FjkzIikr0qeyV7hGxZWUVWUWSvEClCZBYNZKSt7LKzV8Mo
IlvZI5WZ1ef+4/K9r+/zO973PPfzvid3hx5NuidKSEh4OXFCQuQR/zyPZ/gt
Xkv+GJ38hD8uV/K2sqlsLPfKZ10rYP7GXBP1zbvkX/oq5o3m1ijFU/C3zfnw
Ey/Pvze3wHBenC81N8BVThOOml/AbfOnaI2CLszX1cIl/hhS6sbx/PiZj0AS
HOOdcMf8GdqgNFI5P17/MHbwN5EUx3ln3DV/jufid0cyJI/fIV4rfh73IDXu
xR9+5sW4kfhCtEUZ3Ic/dS8hEb7k7VA2ft57mKB7BDv5SKTBCd4FifEVb49y
8VrOT9Q9il18FNLiJO+KJJjHO6CQswt4bfwd9zrep24SL4DdvAJfa26J0bwE
/9b8FK7xdDhlfhlJ8XX8Ts6sMj+NjrwwX2iuE3sz75b/6KuaN5nboJn5d1kh
7od5cjw3sqCsK3fEjuUvrleU63h72Uo2lfvi/sm3XC8pv+PPyYayofw1diav
u15dbo33JtvFsyUPyvSunZbdkCzui/4n+U3swrw63mc877wIXxTvDdks/V/d
E7rN8bqoGHvi75gL4Vdeia+Pzw/G8FJ8mblRYN4jb+hrmLfF7xf33XxI3q8/
I+MDmTzupf5nOT/2bl5jbiebyybyt3jW5AuuF5WL4z7LerG7uI/xzMvLrleT
W3gH2VY2lwfi+ZKV4vmR78ZnVBaW9eROuce1yuYNsavYt3m/HBufN/Py+A7A
f/xJvj1eAxn4WdkDKbCAd0IxZ5bE9wOuxP8dz5duCi+CvfxtZMQ53hMpsZB3
ju8SPIBMyIzzrvVCKiziL8YzhwdxQdcb92Axfyn2hyy4qOuD1FjCu8Q9wkP4
S9cX92Ip7xrPE9J7n1N1RfEbH4esuMT74T58G9+lsV/c7/x7umLYx8cjG/7m
/ZEG3/Fuce+Qwfn3dcWxn09AdvzDByAtlvHuqBn3yPkPdCXwO5+IHPiXv4J0
WM57oFbcN+c/1JXEAT4JOXGZD4zPBlbwnqgd99j5abpSOMgnIxeu8EHxvGIl
74U6sQ/np+sewyH+DnLjKh8czwRW8d6oGztyfoauNA7zd5EH1/iryIjVvA/q
xd6c/0j3OI7wKciL63wIHsAa3hf1Y5fOz9SVwVE+Fflwgw9FJnzP+6FB7NL5
WbqyOMbfQ378x19DZqzl/fFU7NL52bpyOM7fx8O4yYfhQazjA9Awdun8HF15
/ME/wCO4xV9HFqznr6BR7NL5j3UV8Cf/EI/iNn8DD2EDH4jGsUvn5+oq4gSf
hgK4w4cjKzbyQWgSu4y/6bpKOMmnoyDu8hHIhk18MJrGLp3/VFcZp/gMFEL8
gX5Tlx2b6at4Onap/0xXBaf5RyiMRPqRuhzYwoegWexS/7muKs7wmSgS/71+
lC4ntvKhaB671H+hewJn+SwURRL9aF0ubOOvoUXsUv+lrhrO8dkohqTxN0WX
G9v5MLSMXeq/0lXHeT4HxZFMP0aXBz/w19Eqdqmfp6uBC/xjlEBy/VhdXvzI
38AzsUv917oncZHPRWndCt4EN3lN/oO5I1qZD8uusqRr/wOB1xm9
             "]]},
           Annotation[#, "Charting`Private`Tag$1252161#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV1OW3FlUYxuEXOHSpgISkIB3SXXYsC1HpOISolJ1/gHR3S7d0d4N0d3ez
CCnxej781h3P3mfOzDuzCyV3adA5RSKRyJsykeiIoqkTiUZJicScVIlEeUyS
D8nlsdP8T3kpnw0DzEfrvtB1k8/IyZgrn5NrIyEPlbfyhTFeXivf5T9AJ/uL
yY35uWYVMFk+LFfALvNu8jI+Ow7y6THQumX0uu4tXOHzYoz1jWh33Vlr9vBJ
aMPPo+f1KdIkEnXoeTknUpgNo9t0T2kReoxmwXPWTjBfx9/Tp5M/pDflQsgt
d3bN4nwT/V06z/rt9Jmc0byiPEU+IleM58Rnx277utPluhwYZN1YXWNdD/mc
3BYpMVz3j+4VTJTXy/f5j9DFnhJyU36+2Q4+gUr8VHpUXymeB58De6zvQVfo
HtEX6SGaIe7Z/zvYvuX8DX1q+W16Vc4X++Vx9jfhe+rvxzO1fi9NjUzm7eT5
/AXzlHJdekHOhVRmI+h2XVEc57Nikn4DfaD7GF1do6TcjF9gVhnT5GNyZew1
7ymv5HNiiPlfuqa6XnE9uT2SMFK3Q1cMk+VvrSulay4vlKtgn66XbpUuF4bq
Vsg3+Xdwjc8fz8r9jLe2Gd9b/4BejP00Db7kF0RnlsraevRivCfIJqc2H8Xv
1P9Hi9MT8Z7hefMp5hv5f/Xp5U/oLfll5JG/c+3SfAv9PbrI+p3xDqMqP50e
N6uC/db2llfzuTHMfKV8i38XE8yby334S2YdkAbf68voW+oXy9VwQDcRLfR9
9Zd1XyEtftCX1bfSL5Gr46Cuj26NLg+Gx1mia6nrF9+r/DUWypfk+vFtxXki
7+JLYKq8SX7IN8CP9peTW/NLzXbxKVGDn0FPxHnjGVWNbyd+K7wgH7KvL79W
/5i+RA/TjPHumY+wfxV/W59Gfo9elwvE+SBPtr8V31//L71q/X6aFt/wi+hl
s9fiOcbvFGeUfkx847qSOBm/L6bpN9NHuk/xk7/9qpzMLzOriZnySbla/J/m
/eR1fF6MjLNE11o3IN5LuSMWy1fk15EhzpH4zvlSOBXPAdP1W+jjWOO+GtLb
cmH87G+Wj3NSt9y6Wjii669br8uHUXGe6JLj/I1nJHdCRvyir6Bvq18h10ZD
1ziqH6DfoM+P0fEd69roBsk35M7IhHG6vbrSmCH/al1FXTt5pVwHs+RTcvU4
o80Hyhv5AhgT77+urW5wnNFyFyyJ30x+A5njnJD38WUwU94qP+E/w2/2V5Lb
86vMdseZhbr8bHpaXyPOLesGyZv4gjgSZx/GWrea3tGldf/vxz3KBeP8k2fY
144fon8Y32J8WzQdMpt3lZfy18yT5DfjW4t3FtnlLObj+f36Z7QsPR1nC2aZ
baNPdZ/jDl8Ev7tm5TibdKutqYe/5TNyzTh/zAfLm/lCGBfvoK69bmi8I3Fm
Iism6A7oymG2/Id1VXQd5DVyfcyRz8q14r03HyJv4Z/EOUaPxr3ifwigHjw=

             "]], LineBox[CompressedData["
1:eJwV1Ge4SHUAx/FjFyojKpQkUiTvSiWyx7WurSLeZN7L3XsvexQyiowS4dpk
Za9Lg5JREQ2r4trj6nNffM/z/33Oc979n1NncHhoWIkgCKZ5zC8VBNvLBEFh
6SAI0fKSQfCBPdP5qncRqqRk/iofynfYLXWardAQPosXskhVVgp/jQ/jO+1W
OsPyNZTP5tdYlKoolTflw/kuu7V+Zys1jM/h11m0qiqNv85H8N12G51lqzSc
f8JvsBg9rnT+Bh/J99htdY6t1gj+Kb/JYlVNGfxNHsb32u30B1ujkXwuv8Xi
VF2ZvBkP5/vs9vqTrVUYn8dvs3g9oSz+Fh/F99sd9Bdbp3D+Gb/DEvSksnlz
PpofsDvqb7Zeo/h8fpcl6inl8BY8gh+0O+k826DRfAG/x5JUQ7n8bR7JC+wQ
XWAbFcEX8vvF90A1lcdb8ih+yO6si+xrRfJFvKj4HqiWxvBWPJoftrvoEtuk
KP45f1B8D/S0xvLWPIZ/a3fVZbZZ0fwLHiiNP6NxvA2PZd/Z3fQP26IYvpiX
UDqvrfG8LY9j39vd9S/bqlj+JS+pDP6sJvB2PJ79YIfqP7ZNcXwJL6VMXkcT
eXuewI7YPXSFfaN4vpSXVhZ/TpN4B57Ijto9dZVtVwL/ipdRNq+rybwjT2I/
2r1UyHYokS/jZZXDn9cU3okns5/s3rrGdiqJL+fllMvraSoP4SnsmN1H19ku
JfMV/CHl8fr6kHfmqexnu69usN1K4fn8YY3hL+gj3oWnseN2P91ke5TKV/Ly
GssbaBrvytPZCbu/brG9SuOreAWN4y9qOu/GM9hJ+x3dZvuUzlfzihrPX9IM
3p1nslP2u7rD9iuDr+GPaAJvqI95KM9iv9jv6S47oEy+lj+qibyRZvIePJv9
ag/QPXZQWXwdf0yT+MuaxXvyHPabPVD3WYGy+XpeSZN5Y83mvXguO22/ryJ2
SDl8A6+sKfwVzeG9eR47Yw/SA3ZYuXwjr6KpvIkWsWN2E+XbBXaRc5/i/75z
PdUs67/r+/8BX1LdAQ==
             "]]},
           Annotation[#, "Charting`Private`Tag$1252161#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{1568, 1618, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 
             1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586,
              1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1595, 1596, 
             1597, 1598, 1599, 1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607,
              1608, 1609, 1610, 1611, 1612, 1613, 1614, 1615, 1616, 1619, 
             1617}]},
           Annotation[#, "Charting`Private`Tag$1252161#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
           LineBox[{1566, 1567, 1565}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{4}}, "Rows" -> {{3}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.716626743656364*^9, 3.716626808611267*^9}, 
   3.7166269476410646`*^9, 3.71662704663275*^9, 3.7166273078726788`*^9, {
   3.716630050112769*^9, 3.716630064891651*^9}, 3.716630217404928*^9, {
   3.716630412987892*^9, 3.716630431445198*^9}, 3.716630462762364*^9, {
   3.716631176005014*^9, 3.71663123190425*^9}, 3.716631820376644*^9, 
   3.71663189244998*^9, 3.716631972056011*^9, {3.716632680884293*^9, 
   3.716632705594145*^9}, {3.716633480801176*^9, 3.71663350536832*^9}, 
   3.71663355826431*^9, 3.71663388154924*^9, 3.7166340030925627`*^9, 
   3.716634307008522*^9, 3.716634714782069*^9, 3.716634856185184*^9, 
   3.716634886185363*^9, 3.7166351061860456`*^9, 3.716635159277287*^9, 
   3.716635206363532*^9, {3.71663528014221*^9, 3.71663533293329*^9}, {
   3.716635376307576*^9, 3.716635395663877*^9}, 3.716635481067729*^9, 
   3.7166355196885366`*^9, 3.716635561482033*^9, 3.716635612743945*^9, 
   3.7166356789346447`*^9, 3.7166357140647793`*^9, 3.716635790139824*^9, 
   3.7166361831616087`*^9, 3.7166366990418463`*^9, 3.716638766103705*^9, 
   3.716639082924501*^9, 3.716639256532716*^9, {3.716654926621581*^9, 
   3.716654943406619*^9}, 3.716655063029464*^9, 3.716659152217225*^9, 
   3.716716942909182*^9, 3.7167170543060627`*^9, 3.716717119769256*^9, {
   3.71717521663517*^9, 3.717175236863985*^9}, 3.717175303074882*^9, 
   3.7171753432781477`*^9, 3.717175391469858*^9, 3.717175501836512*^9, 
   3.717175593166593*^9, 3.7171756397165956`*^9, 3.7171763882877617`*^9, 
   3.717178380649037*^9, 3.759450284027527*^9, {3.793504345873345*^9, 
   3.793504366948001*^9}, 3.793904890130986*^9, {3.793904926982964*^9, 
   3.793904941687089*^9}, 3.823229414707664*^9},
 CellLabel->
  "Out[3121]=",ExpressionUUID->"1fdbf9af-0402-47b3-8415-618593df5346"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"a640a29d-2ea3-4fc9-94d7-6650dc18b70b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Through", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
         "\[Theta]1a", ",", "u1a", ",", "\[Theta]2a", ",", "u2a", ",", 
          "\[Theta]3a", ",", "u3a", ",", "\[IndentingNewLine]", "\[Theta]1b", 
          ",", "u1b", ",", "\[Theta]2b", ",", "u2b", ",", "\[Theta]3b", ",", 
          "u3b", ",", "\[IndentingNewLine]", "\[Theta]1c", ",", "u1c", ",", 
          "\[Theta]2c", ",", "u2c", ",", "\[Theta]3c", ",", "u3c"}], "}"}], 
        "\[IndentingNewLine]", "[", "t", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Tau]1", ",", "0.05"}], "}"}]}], "]"}], "//",
     "N"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat1", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Through", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
         "\[Theta]3a", ",", "u3a", ",", "\[IndentingNewLine]", "\[Theta]3b", 
          ",", "u3b", ",", "\[IndentingNewLine]", "\[Theta]3c", ",", "u3c"}], 
         "}"}], "\[IndentingNewLine]", "[", "t", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Tau]1", ",", 
        FractionBox["\[Tau]", "3"]}], "}"}]}], "]"}], "//", "N"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<swingUpBV.dat\>\"", ",", " ", "dat"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<swingUpBV1.dat\>\"", ",", " ", "dat1"}], "]"}]}], " ", 
   "\[IndentingNewLine]", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.716638777860729*^9, 3.7166388449853487`*^9}, {
  3.7166388772797194`*^9, 3.716638943226046*^9}, {3.716639149450975*^9, 
  3.716639178433305*^9}, {3.716639266902446*^9, 3.716639314003745*^9}, {
  3.793504307641161*^9, 3.793504336516189*^9}, {3.79390486966494*^9, 
  3.7939048701294527`*^9}},
 CellLabel->
  "In[3122]:=",ExpressionUUID->"0d862bb5-f84b-41fb-baa8-b588e865ed51"]
}, Open  ]]
},
WindowSize->{820, 686},
WindowMargins->{{Automatic, 66}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e983c05e-4644-4b1a-83a5-f40fd8bc854d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 580, 8, 67, "Section",ExpressionUUID->"f5006cf0-1224-4794-8ac0-e829719a3280"],
Cell[1163, 32, 386, 9, 52, "Text",ExpressionUUID->"6cd6c261-f6f9-4a8d-a21b-a0f03a9acb28"],
Cell[1552, 43, 14603, 358, 824, "Input",ExpressionUUID->"16cd26ea-7171-44f0-884e-4487fde9f9b1"],
Cell[16158, 403, 401, 9, 76, "Text",ExpressionUUID->"62379b6d-8e80-423f-9046-5e21f705f9ef"],
Cell[CellGroupData[{
Cell[16584, 416, 6686, 172, 409, "Input",ExpressionUUID->"694597bb-8cc9-4634-8d24-5df3c6aba934"],
Cell[23273, 590, 488, 10, 24, "Message",ExpressionUUID->"60ac230d-bebd-4d09-8ad6-05996c97ea05"],
Cell[23764, 602, 488, 10, 24, "Message",ExpressionUUID->"6307d0f4-938e-4632-84c0-51440039884c"],
Cell[24255, 614, 490, 10, 24, "Message",ExpressionUUID->"c290c2f0-74e2-4626-990b-501ad0d2391c"],
Cell[24748, 626, 472, 10, 24, "Message",ExpressionUUID->"a2b22876-f72b-48d0-aecf-f961aa974f32"],
Cell[25223, 638, 490, 10, 24, "Message",ExpressionUUID->"27dc6cd9-7c34-4b09-a359-32391750f441"],
Cell[25716, 650, 488, 10, 24, "Message",ExpressionUUID->"108320d7-ba73-4c68-a983-3157a0d19b6e"],
Cell[26207, 662, 488, 10, 24, "Message",ExpressionUUID->"7ca614d4-9801-4f7c-8acf-e7893b502aa5"],
Cell[26698, 674, 488, 10, 24, "Message",ExpressionUUID->"e89cca54-42fb-49f5-a7a8-194ce5612025"]
}, Open  ]],
Cell[27201, 687, 450, 9, 52, "Text",ExpressionUUID->"4cfc58ae-9d62-4420-870c-d4d4cde97b31"],
Cell[27654, 698, 5596, 139, 320, "Input",ExpressionUUID->"a87f29c8-c971-4e70-b4eb-519560d5613b"],
Cell[CellGroupData[{
Cell[33275, 841, 3648, 102, 262, "Input",ExpressionUUID->"f1537525-cadf-4359-a24c-6e72fbaad310"],
Cell[36926, 945, 490, 10, 24, "Message",ExpressionUUID->"4827e436-e02c-46ed-8901-03c198d36b67"],
Cell[37419, 957, 490, 10, 24, "Message",ExpressionUUID->"1e45aa17-8634-47af-a4a4-e076380f5848"],
Cell[37912, 969, 488, 10, 24, "Message",ExpressionUUID->"03ad4c20-9496-4aab-b84c-6a18037c9c1c"],
Cell[38403, 981, 474, 10, 24, "Message",ExpressionUUID->"7e0df1e0-cafa-4bba-85be-e46a6f043173"],
Cell[38880, 993, 490, 10, 24, "Message",ExpressionUUID->"9bf0c974-e1a0-435a-8031-1e035cfe5056"],
Cell[39373, 1005, 488, 10, 24, "Message",ExpressionUUID->"41283a6d-97c2-4652-ba14-06805a690178"],
Cell[39864, 1017, 488, 10, 24, "Message",ExpressionUUID->"e7b6dd5c-ad1b-406a-ab0f-51b3673de38b"],
Cell[40355, 1029, 472, 10, 24, "Message",ExpressionUUID->"f407991e-2aa3-4292-b78f-2c9fcf56d37a"],
Cell[40830, 1041, 487, 10, 24, "Message",ExpressionUUID->"33cbb948-64d7-4b11-9634-7056bd316d8f"],
Cell[41320, 1053, 487, 10, 24, "Message",ExpressionUUID->"72753c9d-ff67-4cf2-8431-e5686894cb0f"],
Cell[41810, 1065, 487, 10, 24, "Message",ExpressionUUID->"39288747-cd2c-4d32-869b-a4751288300c"],
Cell[42300, 1077, 472, 10, 24, "Message",ExpressionUUID->"719cb965-7929-49c9-9c45-0cf58e8cae9e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42809, 1092, 832, 20, 30, "Input",ExpressionUUID->"51f49d87-cbfc-4c38-ac37-5fcd28423fed"],
Cell[43644, 1114, 198206, 3420, 491, "Output",ExpressionUUID->"1fdbf9af-0402-47b3-8415-618593df5346"]
}, Open  ]],
Cell[241865, 4537, 394, 7, 52, "Text",ExpressionUUID->"a640a29d-2ea3-4fc9-94d7-6650dc18b70b"],
Cell[242262, 4546, 2260, 53, 402, "Input",ExpressionUUID->"0d862bb5-f84b-41fb-baa8-b588e865ed51"]
}, Open  ]]
}
]
*)

