(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    220014,       4092]
NotebookOptionsPosition[    217463,       4047]
NotebookOutlinePosition[    217860,       4063]
CellTagsIndexPosition[    217817,       4060]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Pendulum swing up with angle only (observer needed)
Example 7.9\
\>", "Section",
 CellChangeTimes->{{3.698811497715045*^9, 3.698811509022469*^9}, {
   3.69885144307857*^9, 3.698851462312389*^9}, {3.709636905485622*^9, 
   3.709636910921179*^9}, {3.715342867107555*^9, 3.715342872342836*^9}, {
   3.7153432690028687`*^9, 3.715343287448956*^9}, {3.716532618830523*^9, 
   3.7165326217793283`*^9}, 3.716570691299556*^9, {3.793504228101844*^9, 
   3.79350423009087*^9}},ExpressionUUID->"60b09a07-4679-4cd9-9875-\
aece6d4e38a2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"R", "=", "1"}], ";", " ", 
   RowBox[{"d0", "=", "0"}], ";", "  ", 
   RowBox[{"q", "=", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"0", "1"}
      }], "\[NoBreak]", ")"}]}], ";", " ", 
   RowBox[{"r", "=", 
    RowBox[{"{", 
     RowBox[{"{", "R", "}"}], "}"}]}], ";", 
   RowBox[{"polpos", "=", "1"}], ";"}]}]}], "Input",
 CellChangeTimes->{{3.715406158547789*^9, 3.715406175566045*^9}, {
   3.71540843722126*^9, 3.715408438621107*^9}, {3.715409943475955*^9, 
   3.71540994465714*^9}, 3.715409989843553*^9, {3.715415894548387*^9, 
   3.715415909408836*^9}, {3.7154172382682753`*^9, 3.715417301572735*^9}, 
   3.715417800524371*^9, {3.71541926281385*^9, 3.7154192630835114`*^9}, 
   3.715419349702868*^9, {3.715420492165409*^9, 3.715420514259961*^9}, 
   3.7154210952309628`*^9, {3.7154211326358223`*^9, 3.715421132835579*^9}, 
   3.7154212462375813`*^9, 3.715421758878799*^9, {3.715421929133116*^9, 
   3.7154219295316153`*^9}, {3.715422121675604*^9, 3.715422122113842*^9}, 
   3.7154231731172743`*^9, {3.715423211723938*^9, 3.7154232119620533`*^9}, 
   3.715424678949617*^9, {3.715426576617014*^9, 3.71542661827649*^9}, 
   3.7154293353602877`*^9, {3.715429578712113*^9, 3.71542960422958*^9}, {
   3.715430112092979*^9, 3.715430166612854*^9}, {3.7154303026095543`*^9, 
   3.71543033371656*^9}, 3.716474912521641*^9, {3.716474974537917*^9, 
   3.716474975406767*^9}, {3.7164750105504293`*^9, 3.716475030094474*^9}, 
   3.716488253848009*^9, {3.716533494053945*^9, 3.716533494165113*^9}, 
   3.716536030148308*^9, {3.716541452506319*^9, 3.716541453313567*^9}, 
   3.71654231412919*^9, 3.71654244871754*^9, {3.716543599987232*^9, 
   3.71654360070708*^9}, {3.716543876598792*^9, 3.716543886964719*^9}, {
   3.716544889593813*^9, 3.716544937249255*^9}, 3.716549413016314*^9, {
   3.716550568136039*^9, 3.7165505841203537`*^9}, {3.716749506137392*^9, 
   3.716749568551359*^9}, {3.716750581129053*^9, 3.716750582401269*^9}},
 CellLabel->
  "In[2888]:=",ExpressionUUID->"3413512a-057a-4181-97cf-e9214504c8ed"],

Cell["\<\
Calculate feedforward swing-up for 0 < t < \[Tau] and balance for \[Tau] < t \
< \[Tau]1,  based on nominal model; \
\>", "Text",
 CellChangeTimes->{{3.644509136027421*^9, 3.644509201738372*^9}, 
   3.644509766090928*^9, {3.714237280802227*^9, 3.7142373247256536`*^9}, {
   3.714326070104105*^9, 3.7143261090526667`*^9}, {3.715181320555006*^9, 
   3.715181324473104*^9}, {3.7153433317700977`*^9, 3.715343341080782*^9}, {
   3.715403051966159*^9, 3.715403053002616*^9}, {3.715405333515641*^9, 
   3.7154053735139523`*^9}, {3.715405416124236*^9, 3.715405424644391*^9}, {
   3.7154094087709923`*^9, 3.715409421306808*^9}, {3.715416705601328*^9, 
   3.715416750530801*^9}, 3.7154217240762587`*^9, {3.715422616682157*^9, 
   3.715422617066246*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"fa7774ec-e0dd-4507-bceb-9a6b63479623"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ffCalc", "[", 
    RowBox[{"n_", ",", "\[Tau]_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "f", ",", "\[Theta]", ",", "\[Theta]dot", ",", "\[Lambda]", ",", 
       "\[Lambda]dot", ",", "t", ",", "\[CapitalDelta]t", ",", "bcs", ",", 
       "eqns", ",", "sv", ",", "froot", ",", "\[Theta]ff0", ",", 
       "\[Theta]dotff0", ",", "uff0", ",", "\[Theta]ff", ",", "\[Theta]dotff",
        ",", "uff"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalDelta]t", "=", 
       FractionBox["\[Tau]", "n"]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"{", 
         RowBox[{
         "\[Theta]_", ",", "\[Theta]dot_", ",", "\[Lambda]_", ",", 
          "\[Lambda]dot_"}], "}"}], "]"}], " ", ":=", " ", 
       RowBox[{"{", 
        RowBox[{"\[Theta]dot", ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "-", "\[Lambda]"}], ",", 
         "\[Lambda]dot", ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "\[Lambda]"}]}], "}"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"bcs", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[Theta]", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["\[Theta]dot", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["\[Theta]", "n"], "\[Equal]", "\[Pi]"}], ",", 
         RowBox[{
          SubscriptBox["\[Theta]dot", "n"], "\[Equal]", "0"}]}], "}"}]}], ";",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{"hard", " ", "final", " ", "constraint"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"eqns", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"bcs", ",", "\[IndentingNewLine]", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Thread", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                SubscriptBox["\[Theta]", "i"], ",", 
                SubscriptBox["\[Theta]dot", "i"], ",", 
                SubscriptBox["\[Lambda]", "i"], ",", 
                SubscriptBox["\[Lambda]dot", "i"]}], "}"}], "\[Equal]", " ", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 SubscriptBox["\[Theta]", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Theta]dot", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]dot", 
                  RowBox[{"i", "-", "1"}]]}], "}"}], "\[IndentingNewLine]", 
               "+", 
               RowBox[{
                FractionBox["\[CapitalDelta]t", 
                 RowBox[{"2", " "}]], 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"f", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["\[Theta]", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Theta]dot", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]dot", 
                    RowBox[{"i", "-", "1"}]]}], "}"}], "]"}], "+", 
                  RowBox[{"f", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["\[Theta]", "i"], ",", 
                    SubscriptBox["\[Theta]dot", "i"], ",", 
                    SubscriptBox["\[Lambda]", "i"], ",", 
                    SubscriptBox["\[Lambda]dot", "i"]}], "}"}], "]"}]}], 
                 ")"}]}]}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sv", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Theta]", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Theta]dot", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]dot", "i"], ",", "0"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "1"}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"initial", " ", "guesses"}], " ", "=", " ", "0"}], ",", " ", 
        
        RowBox[{"very", " ", 
         RowBox[{"naive", "!"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"froot", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{"eqns", ",", "sv"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Theta]ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["\[Theta]", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Theta]dotff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["\[Theta]dot", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"uff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"-", 
             SubscriptBox["\[Lambda]", "i"]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Theta]ff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Theta]ff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "\[Pi]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"\[Theta]dotff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Theta]dotff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"uff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"uff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"\[Theta]ff", ",", "\[Theta]dotff", ",", "uff"}], "}"}]}]}], 
    "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "500"}], ";", "  ", 
  RowBox[{"\[Tau]", "=", "5"}], ";", 
  RowBox[{"\[Tau]1", "=", 
   RowBox[{"4", "\[Tau]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]0", ",", "\[Theta]dot0", ",", "u0"}], "}"}], "=", 
   RowBox[{"ffCalc", "[", 
    RowBox[{"n", ",", "\[Tau]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"p0", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Theta]0", "[", "t", "]"}], ",", 
      RowBox[{"u0", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{",", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"Filling", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "4"}], "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.715403097492919*^9, 3.7154032546975822`*^9}, 
   3.715404497698846*^9, {3.7154045455375147`*^9, 3.715404571894266*^9}, {
   3.7154047023449497`*^9, 3.71540476411584*^9}, {3.715405458598667*^9, 
   3.7154055177654123`*^9}, {3.715405561032172*^9, 3.715405572278759*^9}, {
   3.715405602959152*^9, 3.71540564390028*^9}, {3.715405829625499*^9, 
   3.715405853849559*^9}, {3.715405912636992*^9, 3.7154059350319433`*^9}, {
   3.715405988579615*^9, 3.715406022208359*^9}, {3.715406067637855*^9, 
   3.7154060855813627`*^9}, {3.715406180381226*^9, 3.71540619078692*^9}, {
   3.7154068880462646`*^9, 3.7154068888987722`*^9}, {3.715408942842237*^9, 
   3.715409075177989*^9}, {3.715409657620895*^9, 3.715409699242692*^9}, {
   3.71540999388354*^9, 3.7154099941626587`*^9}, {3.71541011942309*^9, 
   3.715410124469306*^9}, 3.715410171423666*^9, {3.715418124497086*^9, 
   3.715418173824822*^9}, {3.715419484391259*^9, 3.715419550465959*^9}, {
   3.715420190886202*^9, 3.715420335136791*^9}, {3.715420368626495*^9, 
   3.71542037620964*^9}, {3.715420460032181*^9, 3.715420479701907*^9}, {
   3.7154209111996613`*^9, 3.7154209189690104`*^9}, {3.715420987217272*^9, 
   3.7154210223025923`*^9}, {3.715421740610075*^9, 3.715421769983019*^9}, {
   3.715422620652648*^9, 3.71542264689213*^9}, {3.715422687133594*^9, 
   3.715422717619708*^9}, 3.715424024383325*^9, 3.716474865651372*^9, {
   3.716474996520253*^9, 3.716474998351397*^9}, {3.7164750383757677`*^9, 
   3.716475079387665*^9}, 3.716475114276225*^9, {3.716478823423841*^9, 
   3.716478862290114*^9}, 3.716479065249919*^9, {3.71648772989774*^9, 
   3.716487735969658*^9}, {3.7164879579897738`*^9, 3.716488016995331*^9}, {
   3.716532004827055*^9, 3.716532011714119*^9}, {3.716532409791326*^9, 
   3.7165324235477448`*^9}, 3.7165327720650597`*^9, {3.716532900024932*^9, 
   3.716532912653796*^9}, {3.716532978675971*^9, 3.716532992113749*^9}, {
   3.716533071364506*^9, 3.7165331007260933`*^9}, {3.716533135976235*^9, 
   3.716533341042645*^9}, {3.7165763744414463`*^9, 3.716576489549341*^9}, {
   3.71657652268517*^9, 3.716576524778981*^9}, {3.716576603146682*^9, 
   3.716576633131246*^9}, 3.71674948349813*^9, {3.716749515111826*^9, 
   3.716749519903962*^9}, 3.716749558232575*^9, 3.716750866677023*^9},
 CellLabel->
  "In[2890]:=",ExpressionUUID->"6e609bb9-6103-45b7-9599-6a78d6c71957"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJzt2nk4lG3fwHEZxgzZZiJKtojspdxp8TujBWmzlqRIlpQQSiqSkjtEUVSk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    "], {{{}, {}, 
      {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
       GraphicsGroupBox[
        PolygonBox[{{471, 536, 534, 240, 430, 383, 346, 319, 299, 287, 439, 
         392, 355, 328, 308, 241, 431, 384, 347, 320, 300, 288, 440, 393, 356,
          329, 309, 242, 432, 385, 348, 321, 452, 405, 368, 465, 418, 301, 
         446, 399}}]]}, 
      {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[None], 
       GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwNz0kvHlAUBuCPH2EmkahpZdhQw4p2U2IeVoZN2xCiDdHSrigLpA1BCCKI
eUW7qaYNQQiN0EgpW6VV/kKfxZP35L7JObmx9c0lTcGBQCCIXq4I9RDCvfmO
GGUyuVTzllX+6aJlEjlU8YYVbnV/iTInkk0lnSzzR5cuH1NPD5+IpJDnDPCF
BJoZYossKuhgiRu75uQP2hhnn2KmOaKRn3zgG2lcMMMxLzhjhB0e8YtJDqnj
lHd8JIJLZjnhJeeMsksBU3znGf1sEE8Tg2zykAkOKOc1i1z7U6scY48iGnjP
V1JpYZht8qmlm3XCecJT+vjMAzIp4xUL/HYnReZRQxdrhBFHBqW0M89/8SFI
6Q==
         
         "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, \
{}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], 
        LineBox[{1, 181, 141, 220, 109, 213, 173, 225, 84, 206, 166, 223, 133,
          217, 178, 64, 200, 160, 128, 215, 175, 103, 211, 171, 138, 51, 192, 
         152, 120, 95, 209, 169, 136, 75, 204, 164, 131, 107, 2, 182, 142, 
         110, 85, 207, 167, 134, 65, 201, 161, 129, 104, 52, 193, 153, 121, 
         96, 76, 3, 183, 143, 111, 86, 66, 53, 194, 154, 122, 97, 77, 4, 184, 
         144, 112, 87, 67, 54, 5, 6, 7, 185, 145, 113, 88, 68, 55, 8, 186, 
         146, 114, 89, 69, 56, 195, 155, 123, 98, 78, 9, 187, 147, 115, 90, 
         70, 57, 196, 156, 124, 99, 79, 10, 188, 148, 116, 91, 71, 58, 197, 
         157, 125, 100, 80, 11, 189, 149, 117, 92, 72, 59, 198, 158, 126, 101,
          81, 12, 190, 150, 118, 93, 73, 202, 162, 130, 105, 60, 199, 159, 
         127, 102, 210, 170, 137, 82, 205, 165, 132, 216, 177, 108, 212, 172, 
         140, 219, 180, 13, 191, 151, 221, 119, 214, 174, 94, 208, 168, 224, 
         135, 218, 179, 226, 74, 203, 163, 222}], 
        LineBox[{176, 106, 139, 61, 83, 14, 62, 15, 16, 17, 18, 19, 20, 21, 
         22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
         39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 63, 50}]},
       Annotation[#, "Charting`Private`Tag$1212192#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwV0WdL0FEUB+C/fQhp2YCy0gQrhXKUQWlBRWVZqeAKLJKsxHDkCKwMmtii
sGihppnQErKBLYqSrGj7Nkeu/AQ+vnj43XvP4V4Od3Zu4ea9IUEQ3OUvDTYl
pLKUOUzmPjVksYpoevU3ylK2sIy5POEE+axjCg84Qjarec0F9rOI55xhDxt5
x2WK6fNOkyxjKx+oJ45O6pgYIpwOTrKLLq6xnrdc4hdFfOEWPUzlIUf5Rg4f
ucpvknnDRX5ygM/c5A+LecFZflDAJ66zifdc4SBfuU2/me7IctKI5yXnKGQe
TznFbjYwjUccI5cUljDgrmZ5iG0kMJ/p/FMbpMW6gu0ksoAwhib+Xlayg+VE
MINhtRFCJwXBqGx1VkU6K4hkJo+pJY81xPBf/z1ZTQZJLGQW7RxnJ2uJZUx/
mzxMJit5xXn20c0NonjGab4zDsjwW6s=
         "]], LineBox[CompressedData["
1:eJwNyytPggEABdAPX6DIQ1TIYMeGHRqMudE1uGlwUwobHRo0GhvBRMemzcZG
IFn9EyIgonLC2b3b3c3e1GuPoSAIqtwrU564ZEyfBlle6HBLmQKffiPZ4ooi
eXLMbF/MWbDkmxU/rPnlj38CnxBbbLPDLnuEibDPAVEOiREnQZIjUhxzwilp
nmlzTYlzznilyx0VLnijxwM1Jgxo8s6QDzJsAFGtIwA=
         "]]},
       Annotation[#, "Charting`Private`Tag$1212192#2"]& ], 
      TagBox[
       {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], Dashing[{Small, Small}],
         LineBox[{482, 532, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 
         493, 494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506,
          507, 508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 
         520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 533, 531}]},
       Annotation[#, "Charting`Private`Tag$1212192#3"]& ], 
      {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{228, 229, 227}], 
       LineBox[{480, 481, 479}]}}}], {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}, "AxesInFront" -> True},
  PlotRange->{{0., 19.999999591836733`}, {-1, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.716750869034854*^9, 3.7167509096335506`*^9, 3.7167509690506353`*^9, {
   3.716751064450375*^9, 3.7167510901565247`*^9}, 3.716751199697551*^9, 
   3.7167513272117167`*^9, 3.716781396987712*^9, 3.716781429772122*^9, {
   3.716781526666499*^9, 3.716781567325123*^9}, 3.7594475341238194`*^9, 
   3.793504189107086*^9, 3.793908470000812*^9, 3.823229279184153*^9},
 CellLabel->
  "Out[2893]=",ExpressionUUID->"f728fd10-912d-4585-9ad1-bd66d8f98175"]
}, Open  ]],

Cell[" Observer & Controller gain calculations", "Text",
 CellChangeTimes->{{3.644509136027421*^9, 3.644509201738372*^9}, 
   3.644509766090928*^9, {3.714237280802227*^9, 3.7142373247256536`*^9}, {
   3.714326070104105*^9, 3.7143261090526667`*^9}, {3.715181320555006*^9, 
   3.715181324473104*^9}, {3.7153433317700977`*^9, 3.715343341080782*^9}, {
   3.715403051966159*^9, 3.715403053002616*^9}, {3.715405347978138*^9, 
   3.7154053680098457`*^9}, {3.7154226004537983`*^9, 3.71542260084273*^9}, {
   3.716543194256989*^9, 3.716543205441093*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"40e91600-d0a7-4104-bb5c-58f5d859fdfd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"l", ",", "\[Kappa]"}], "}"}], "=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "a", ",", "b", ",", "c", ",", "sys", ",", "poles", ",", "\[Theta]", ",", 
      "polpos", ",", "l", ",", "\[Kappa]"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"a", "=", 
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", "1"},
         {
          RowBox[{"-", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "0"}
        }], "\[NoBreak]", ")"}]}], ";", " ", 
     RowBox[{"b", "=", 
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0"},
         {"1"}
        }], "\[NoBreak]", ")"}]}], ";", " ", 
     RowBox[{"c", "=", 
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"1", "0"}
        }], "\[NoBreak]", ")"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"sys", "=", 
      RowBox[{"StateSpaceModel", "[", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]}], ";", 
     RowBox[{"poles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "polpos"}], ",", 
        RowBox[{"-", "polpos"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"l", "=", 
      RowBox[{"EstimatorGains", "[", 
       RowBox[{"sys", ",", "poles"}], "]"}]}], " ", 
     RowBox[{"(*", " ", 
      RowBox[{"observer", " ", "gains"}], " ", "*)"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]", "=", 
      RowBox[{"LQRegulatorGains", "[", 
       RowBox[{
        RowBox[{"sys", "/.", 
         RowBox[{"\[Theta]", "\[Rule]", "\[Pi]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"q", ",", "r"}], "}"}]}], "]"}]}], "  ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "optimal", " ", "feedback", " ", "gains", " ", "for", " ", 
        "\[Theta]"}], "=", "\[Pi]"}], " ", "*)"}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"l", "\[Transpose]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"\[Kappa]", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7154290131752*^9, 3.715429042464889*^9}, {
   3.715429074286199*^9, 3.7154291236680326`*^9}, {3.715429162322948*^9, 
   3.71542918630935*^9}, {3.7154442920557327`*^9, 3.7154443009597473`*^9}, {
   3.716533369445305*^9, 3.7165333875741653`*^9}, 3.7165346101307096`*^9, {
   3.716541435942927*^9, 3.71654144837109*^9}, {3.7165414890220633`*^9, 
   3.716541492789939*^9}, {3.716541595812174*^9, 3.7165416582857847`*^9}, {
   3.716541717444405*^9, 3.71654173035534*^9}, {3.7165431072372828`*^9, 
   3.7165431524110317`*^9}, {3.716543520124902*^9, 3.7165435544829397`*^9}, {
   3.716543634196678*^9, 3.716543800950252*^9}, {3.7165438379190197`*^9, 
   3.716543841462079*^9}, {3.7165471145734158`*^9, 3.716547130499467*^9}, {
   3.716749762361579*^9, 3.716749767016185*^9}, {3.716750500209999*^9, 
   3.716750537292602*^9}},
 CellLabel->
  "In[2894]:=",ExpressionUUID->"5898e310-4d3d-4f2a-8e74-7a80b324df76"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "polpos$1212224"}], ",", 
     RowBox[{
      SuperscriptBox["polpos$1212224", "2"], "-", 
      RowBox[{"Cos", "[", "\[Theta]$1212224", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"]}]], ",", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.715444301491962*^9, 3.715444306072044*^9}, 
   3.716474824060771*^9, 3.7164748724893103`*^9, 3.716474915857812*^9, 
   3.7164883885454493`*^9, 3.716533390276485*^9, 3.7165334985698347`*^9, 
   3.716533980561521*^9, 3.716535383274768*^9, 3.716535452983481*^9, 
   3.7165360840098543`*^9, 3.7165399556720047`*^9, 3.716540513497974*^9, {
   3.716540579489903*^9, 3.716540603628182*^9}, {3.716540660103302*^9, 
   3.716540684942074*^9}, 3.716541006509663*^9, {3.7165414677963047`*^9, 
   3.716541501923888*^9}, 3.716541532651943*^9, 3.716541564536549*^9, {
   3.716541604729851*^9, 3.7165416272013206`*^9}, {3.716541659129836*^9, 
   3.716541663068531*^9}, {3.716541724167197*^9, 3.716541730867838*^9}, 
   3.716541791789146*^9, 3.716542055464199*^9, 3.716542109687389*^9, {
   3.716542279919713*^9, 3.716542317079134*^9}, 3.716542354263301*^9, {
   3.716542386608923*^9, 3.716542402925709*^9}, {3.7165424530494204`*^9, 
   3.716542467815727*^9}, 3.7165425019368668`*^9, 3.716542700002348*^9, {
   3.716542827760181*^9, 3.71654285026335*^9}, 3.7165429266734037`*^9, 
   3.7165429859836893`*^9, 3.716543033575382*^9, 3.716543428456841*^9, 
   3.716543472160975*^9, {3.7165435259671917`*^9, 3.716543545113057*^9}, 
   3.716543607319323*^9, {3.7165436382268887`*^9, 3.716543801494331*^9}, {
   3.716543842068434*^9, 3.716543890068824*^9}, 3.7165445179721603`*^9, 
   3.71654458149356*^9, 3.716544629651285*^9, {3.716545011712059*^9, 
   3.716545041184267*^9}, 3.716545591558112*^9, 3.716546864729685*^9, {
   3.7165471192602386`*^9, 3.716547146765419*^9}, 3.716548880824627*^9, 
   3.716549418114641*^9, 3.716549565119375*^9, 3.716549919247715*^9, 
   3.716550117875197*^9, 3.7165501682334223`*^9, 3.7165502092442923`*^9, 
   3.716550425075774*^9, {3.716550480919158*^9, 3.716550510686619*^9}, {
   3.7165505717499657`*^9, 3.71655058975243*^9}, 3.716576362768396*^9, 
   3.7165764945172033`*^9, 3.7165765371428223`*^9, {3.7165766100457087`*^9, 
   3.716576646964798*^9}, 3.716749200404031*^9, 3.716749678457301*^9, 
   3.716749773129644*^9, {3.716750518530662*^9, 3.7167505408738127`*^9}, 
   3.7167507431135597`*^9, 3.71675091002319*^9, 3.716750969249951*^9, {
   3.716751064582747*^9, 3.716751090237598*^9}, 3.71675119996332*^9, 
   3.7167513273426247`*^9, 3.716781397113608*^9, 3.716781429884597*^9, {
   3.716781526800908*^9, 3.716781567457151*^9}, 3.759447534312476*^9, 
   3.793504189143374*^9, 3.793908470020617*^9, 3.823229279205966*^9},
 CellLabel->
  "Out[2894]=",ExpressionUUID->"07e0fd34-911d-4d5e-85d9-20826d1f4b9f"]
}, Open  ]],

Cell["Nonlinear observer ", "Text",
 CellChangeTimes->{{3.644509136027421*^9, 3.644509201738372*^9}, 
   3.644509766090928*^9, {3.714237280802227*^9, 3.7142373247256536`*^9}, {
   3.714326070104105*^9, 3.7143261090526667`*^9}, {3.715181320555006*^9, 
   3.715181324473104*^9}, {3.7153433317700977`*^9, 3.715343341080782*^9}, {
   3.715403051966159*^9, 3.715403053002616*^9}, {3.715405347978138*^9, 
   3.7154053680098457`*^9}, {3.7154226004537983`*^9, 3.71542260084273*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"9e00ec17-5956-4720-a149-80cee95897b6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Observer", "[", 
    RowBox[{"p_", ",", "\[Tau]1_", ",", "uff_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "eq1", ",", "eq2", ",", "init", ",", "initError", ",", "x1", ",", "x2", 
       ",", "xh1", ",", "xh2", ",", "xs1", ",", "xs2", ",", "xhs1", ",", 
       "xhs2", ",", "L1", ",", "L2", ",", "t"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"L1", "=", 
       RowBox[{"2", "p"}]}], ";", 
      RowBox[{"L2", "=", 
       RowBox[{
        SuperscriptBox["p", "2"], "-", 
        RowBox[{"Cos", "[", 
         RowBox[{"xh1", "[", "t", "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"initError", "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"eq1", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{"x2", "[", "t", "]"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Sin", "[", 
             RowBox[{"x1", "[", "t", "]"}], "]"}]}], "+", 
           RowBox[{"uff", "[", "t", "]"}]}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"eq2", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"xh1", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"xh2", "[", "t", "]"}], "+", " ", 
           RowBox[{"L1", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"x1", "[", "t", "]"}], "-", 
              RowBox[{"xh1", "[", "t", "]"}]}], ")"}]}]}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"xh2", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Sin", "[", 
             RowBox[{"xh1", "[", "t", "]"}], "]"}]}], "+", 
           RowBox[{"uff", "[", "t", "]"}], "+", " ", 
           RowBox[{"L2", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"x1", "[", "t", "]"}], "-", 
              RowBox[{"xh1", "[", "t", "]"}]}], ")"}]}]}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"init", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"x1", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"x2", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"xh1", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"xh2", "[", "0", "]"}], "\[Equal]", "initError"}]}], 
        "}"}]}], ";", "  ", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xs1", ",", "xs2", ",", "xhs1", ",", "xhs2"}], "}"}], "=", 
       RowBox[{"NDSolveValue", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"eq1", ",", " ", "eq2", ",", "init"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x1", ",", "x2", ",", "xh1", ",", "xh2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"xs1", ",", "xs2", ",", "xhs1", ",", "xhs2"}], "}"}]}]}], 
    "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x1a", ",", "x2a", ",", "xh1a", ",", "xh2a"}], "}"}], "=", 
    RowBox[{"Observer", "[", 
     RowBox[{"polpos", ",", "\[Tau]1", ",", "u0"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1a", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x1a", "[", "t", "]"}], ",", 
       RowBox[{"xh1a", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5"}], ",", "4.5"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2a", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x2a", "[", "t", "]"}], ",", 
       RowBox[{"xh2a", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2.2"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3a", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"u0", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4.3"}], ",", "2"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"p1a", ",", "p2a", ",", "p3a"}], "}"}], "}"}], ",", 
     RowBox[{"Spacings", "\[Rule]", "2"}]}], "]"}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.715406734132765*^9, 3.715406744774261*^9}, {
   3.715406782325108*^9, 3.715406835276479*^9}, 3.715407112017367*^9, {
   3.715407374689527*^9, 3.7154073777127*^9}, {3.7154074190699167`*^9, 
   3.7154074207093678`*^9}, {3.7154074976210737`*^9, 3.715407513955448*^9}, 
   3.715407579511817*^9, {3.715407673714438*^9, 3.715407733115691*^9}, {
   3.715407804322137*^9, 3.7154078293136253`*^9}, {3.7154080286525784`*^9, 
   3.7154080395476418`*^9}, {3.7154174900737667`*^9, 3.715417582022348*^9}, {
   3.7154176140980883`*^9, 3.715417679474736*^9}, {3.715419370930073*^9, 
   3.715419388687793*^9}, {3.715421800166952*^9, 3.715421857597227*^9}, {
   3.7154219908288193`*^9, 3.715422046428975*^9}, {3.715423938263987*^9, 
   3.715423975664124*^9}, {3.715426633040348*^9, 3.715426641837757*^9}, 
   3.715426931897644*^9, {3.715429273949491*^9, 3.715429317874916*^9}, {
   3.71653341875397*^9, 3.716533429961694*^9}, {3.716534497584931*^9, 
   3.716534520020554*^9}, {3.71653512680759*^9, 3.716535173168091*^9}, {
   3.716535246694193*^9, 3.716535267225065*^9}, {3.716535355825932*^9, 
   3.716535361904455*^9}, 3.71653542867342*^9, {3.7165355117026443`*^9, 
   3.716535537017294*^9}, {3.716535689728977*^9, 3.7165357089280777`*^9}, {
   3.716541750683488*^9, 3.716541773324586*^9}, {3.7165418356360073`*^9, 
   3.7165419269172907`*^9}, 3.716542378990018*^9, 3.7165434166154537`*^9, {
   3.716544531209174*^9, 3.716544567136035*^9}, {3.7165446931996107`*^9, 
   3.716544694413496*^9}, {3.716544730467367*^9, 3.716544736130924*^9}, {
   3.716544949995573*^9, 3.716544981794434*^9}, {3.716545072217031*^9, 
   3.716545127698751*^9}, {3.716546761228835*^9, 3.716546770293354*^9}, {
   3.716546927530363*^9, 3.716546940537372*^9}, {3.7165490121529903`*^9, 
   3.71654901525601*^9}, {3.716549326159457*^9, 3.7165493304934673`*^9}, {
   3.716550049801257*^9, 3.71655007427669*^9}, 3.716550114732929*^9, {
   3.7165501598108253`*^9, 3.7165501635208406`*^9}, {3.716550476125799*^9, 
   3.716550476385048*^9}, 3.716550507347591*^9, {3.716750570797208*^9, 
   3.716750590094883*^9}, {3.716750761001999*^9, 3.716750761130846*^9}, {
   3.71675089735034*^9, 3.716750927353642*^9}, {3.716750964435986*^9, 
   3.7167509647947893`*^9}, {3.716751018269395*^9, 3.7167510497730427`*^9}, {
   3.7167510864322357`*^9, 3.716751086600184*^9}},
 CellLabel->
  "In[2895]:=",ExpressionUUID->"a6e63832-b982-4623-8d7f-fa1c97fceb51"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.027922846324325`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 2896, 186, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232292792280703`*^9},
 CellLabel->
  "During evaluation of \
In[2895]:=",ExpressionUUID->"030f431f-7c0c-4441-b339-2ee905abf763"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.027922846324325`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 2896, 187, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229279289933*^9},
 CellLabel->
  "During evaluation of \
In[2895]:=",ExpressionUUID->"f350a56b-14d7-438f-b680-337b09c99913"]
}, Open  ]],

Cell["Nonlinear observer & linear feedback, combined", "Text",
 CellChangeTimes->{{3.644509136027421*^9, 3.644509201738372*^9}, 
   3.644509766090928*^9, {3.714237280802227*^9, 3.7142373247256536`*^9}, {
   3.714326070104105*^9, 3.7143261090526667`*^9}, {3.715181320555006*^9, 
   3.715181324473104*^9}, {3.7153433317700977`*^9, 3.715343341080782*^9}, {
   3.715403051966159*^9, 3.715403053002616*^9}, {3.7154081029771976`*^9, 
   3.715408117255252*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"d64cc3d7-7d88-45fb-a632-9366c463e19b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ObserverController", "[", 
    RowBox[{
    "p_", ",", "\[Kappa]_", ",", "\[Tau]1_", ",", "\[Theta]ff_", ",", 
     "\[Theta]dotff_", ",", "uff_", ",", "d_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "eq1", ",", "eq2", ",", "init", ",", "x1", ",", "x2", ",", "xh1", ",", 
       "xh2", ",", "xs1", ",", "xs2", ",", "xhs1", ",", "xhs2", ",", "us", 
       ",", "ufbs", ",", "L1", ",", "L2", ",", "\[Kappa]1", ",", "\[Kappa]2", 
       ",", "ufb", ",", "u", ",", "t", ",", "initError", ",", "clipval"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"L1", "=", 
       RowBox[{"2", "p"}]}], ";", 
      RowBox[{"L2", "=", 
       RowBox[{
        SuperscriptBox["p", "2"], "-", 
        RowBox[{"Cos", "[", 
         RowBox[{"xh1", "[", "t", "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Kappa]1", "=", 
       RowBox[{"\[Kappa]", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
      RowBox[{"\[Kappa]2", "=", 
       RowBox[{"\[Kappa]", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"initError", "=", "1"}], ";", 
      RowBox[{"clipval", "=", "10"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ufb", "[", "t_", "]"}], ":=", 
       RowBox[{
        RowBox[{"\[Kappa]1", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
           RowBox[{"xh1", "[", "t", "]"}]}], ")"}]}], "+", 
        RowBox[{"\[Kappa]2", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
           RowBox[{"xh2", "[", "t", "]"}]}], ")"}]}]}]}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"u", "=", 
       RowBox[{"Clip", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"uff", "[", "t", "]"}], "+", 
          RowBox[{"ufb", "[", "t", "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "clipval"}], ",", "clipval"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"eq1", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{"x2", "[", "t", "]"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Sin", "[", 
             RowBox[{"x1", "[", "t", "]"}], "]"}]}], "+", "u"}]}]}], "}"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"eq2", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"xh1", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"xh2", "[", "t", "]"}], "+", " ", 
           RowBox[{"L1", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"x1", "[", "t", "]"}], "-", 
              RowBox[{"xh1", "[", "t", "]"}]}], ")"}]}]}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"xh2", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Sin", "[", 
             RowBox[{"xh1", "[", "t", "]"}], "]"}]}], "+", "u", "+", " ", 
           RowBox[{"L2", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"x1", "[", "t", "]"}], "-", 
              RowBox[{"xh1", "[", "t", "]"}]}], ")"}]}]}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"init", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"x1", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"x2", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"xh1", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"xh2", "[", "0", "]"}], "\[Equal]", "initError"}]}], 
        "}"}]}], ";", "  ", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xs1", ",", "xs2", ",", "xhs1", ",", "xhs2"}], "}"}], "=", 
       RowBox[{"NDSolveValue", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"eq1", ",", " ", "eq2", ",", "init", ",", 
           RowBox[{"WhenEvent", "[", 
            RowBox[{
             RowBox[{"t", "\[Equal]", "8"}], ",", 
             RowBox[{
              RowBox[{"x2", "[", "t", "]"}], "\[Rule]", " ", 
              RowBox[{
               RowBox[{"x2", "[", "t", "]"}], "+", "d"}]}]}], "]"}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"x1", ",", "x2", ",", "xh1", ",", "xh2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"ufbs", "=", 
         RowBox[{"FunctionInterpolation", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"\[Kappa]1", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
               RowBox[{"xhs1", "[", "t", "]"}]}], ")"}]}], "+", 
            RowBox[{"\[Kappa]2", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
               RowBox[{"xhs2", "[", "t", "]"}]}], ")"}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}]}], ";"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ufbs", "[", "t_", "]"}], ":=", 
       RowBox[{"Clip", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Kappa]1", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
             RowBox[{"xhs1", "[", "t", "]"}]}], ")"}]}], "+", 
          RowBox[{"\[Kappa]2", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
             RowBox[{"xhs2", "[", "t", "]"}]}], ")"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "clipval"}], ",", "clipval"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"xs1", ",", "xs2", ",", "xhs1", ",", "xhs2", ",", "ufbs"}], 
       "}"}]}]}], "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x1b", ",", "x2b", ",", "xh1b", ",", "xh2b", ",", "uf1b"}], 
     "}"}], "=", 
    RowBox[{"ObserverController", "[", 
     RowBox[{
     "polpos", ",", "\[Kappa]", ",", "\[Tau]1", ",", "\[Theta]0", ",", 
      "\[Theta]dot0", ",", "u0", ",", "1"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1b", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x1b", "[", "t", "]"}], ",", 
       RowBox[{"xh1b", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5"}], ",", "4.5"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2b", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x2b", "[", "t", "]"}], ",", 
       RowBox[{"xh2b", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2.2"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3b", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"u0", "[", "t", "]"}], "+", 
      RowBox[{"uf1b", "[", "t", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4.3"}], ",", "2"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1a", ",", "p2a", ",", "p3a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p1b", ",", "p2b", ",", "p3b"}], "}"}]}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "2"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.715408125026971*^9, 3.71540812619878*^9}, {
   3.715408313999366*^9, 3.7154083843756332`*^9}, {3.715408414496892*^9, 
   3.715408421304978*^9}, {3.715408828532257*^9, 3.715408853514132*^9}, {
   3.715410194535137*^9, 3.715410276267551*^9}, {3.7154155920084553`*^9, 
   3.7154157917663383`*^9}, {3.7154159789005537`*^9, 3.715415995814804*^9}, {
   3.715417620380183*^9, 3.715417651604826*^9}, 3.715417686260311*^9, {
   3.7154177568873987`*^9, 3.7154177606855297`*^9}, {3.7154234200841837`*^9, 
   3.715423470007514*^9}, {3.715423566800828*^9, 3.715423582913973*^9}, {
   3.7154239877534037`*^9, 3.715424014154937*^9}, {3.7154243334067907`*^9, 
   3.715424401993849*^9}, {3.715424491471834*^9, 3.7154244990546*^9}, {
   3.715426646224544*^9, 3.715426656983152*^9}, {3.7154268793469048`*^9, 
   3.71542689282726*^9}, {3.715429356131858*^9, 3.715429370620407*^9}, {
   3.715429810322958*^9, 3.7154298116986513`*^9}, {3.715429856881*^9, 
   3.715429864751383*^9}, {3.715429913607733*^9, 3.715429999131081*^9}, {
   3.715430036558599*^9, 3.715430040709264*^9}, {3.716533909233019*^9, 
   3.716533958366082*^9}, {3.716534025352406*^9, 3.71653402984627*^9}, 
   3.7165342146416473`*^9, {3.716534297239097*^9, 3.716534301541668*^9}, {
   3.716535371234104*^9, 3.716535372369589*^9}, {3.71653543422675*^9, 
   3.716535439226437*^9}, {3.7165357235807734`*^9, 3.716535731204767*^9}, {
   3.716536049099372*^9, 3.716536065274941*^9}, {3.71654034747052*^9, 
   3.716540372558056*^9}, {3.7165405227113*^9, 3.716540535519013*^9}, {
   3.716540568927331*^9, 3.7165405957149677`*^9}, {3.716540626349402*^9, 
   3.716540655136744*^9}, {3.7165407174024773`*^9, 3.716540730633688*^9}, {
   3.71654084162675*^9, 3.716540890434216*^9}, {3.7165409581094513`*^9, 
   3.7165409834116583`*^9}, 3.71654210424298*^9, {3.716542234192753*^9, 
   3.716542246183567*^9}, {3.7165424963793097`*^9, 3.7165424988493*^9}, {
   3.7165426894832153`*^9, 3.716542696544734*^9}, {3.716542872556327*^9, 
   3.716542922195545*^9}, {3.716543026081913*^9, 3.716543029256843*^9}, {
   3.716545020682325*^9, 3.71654502691652*^9}, {3.716545440295148*^9, 
   3.716545504908304*^9}, {3.7165455588509617`*^9, 3.71654558711263*^9}, {
   3.716545623850769*^9, 3.716545629370763*^9}, {3.716545670284601*^9, 
   3.716545690237801*^9}, {3.71654576158939*^9, 3.716545770611781*^9}, {
   3.7165466400751047`*^9, 3.716546713602098*^9}, {3.716546774981526*^9, 
   3.716546787581471*^9}, 3.716546844823834*^9, {3.716546899674231*^9, 
   3.7165469491296473`*^9}, {3.716546988734976*^9, 3.716546993924346*^9}, {
   3.716547477484304*^9, 3.716547480490478*^9}, {3.7165475280733232`*^9, 
   3.716547630032983*^9}, {3.716547695740608*^9, 3.716547734607649*^9}, {
   3.716547804731329*^9, 3.7165478360266743`*^9}, {3.716548765778623*^9, 
   3.716548790700748*^9}, {3.716548849058435*^9, 3.716548979918179*^9}, {
   3.716549023289177*^9, 3.716549026224554*^9}, {3.716549065931797*^9, 
   3.716549078729125*^9}, {3.71654916166925*^9, 3.716549175524531*^9}, {
   3.716549283637671*^9, 3.716549284893202*^9}, 3.716549358088188*^9, {
   3.716549536391911*^9, 3.716549549062097*^9}, {3.716549950398773*^9, 
   3.716549964253269*^9}, {3.716549997211982*^9, 3.7165499981295443`*^9}, {
   3.716550029416683*^9, 3.716550033221789*^9}, {3.716550081561674*^9, 
   3.716550134350255*^9}, {3.716550456046445*^9, 3.7165505010924263`*^9}, 
   3.71675060437671*^9, {3.7167507788687983`*^9, 3.7167507935741987`*^9}, 
   3.716750845953454*^9, {3.716750956182276*^9, 3.716750956571*^9}, 
   3.7167510127370787`*^9, {3.7167510586182337`*^9, 3.716751080648197*^9}, {
   3.716751182695302*^9, 3.71675119333185*^9}, {3.7167813590659723`*^9, 
   3.716781425299107*^9}, {3.716781480651764*^9, 3.7167815637571*^9}},
 CellLabel->
  "In[2900]:=",ExpressionUUID->"c4273a82-126b-4e65-8280-0d685c721ed3"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.06551803609155`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 2901, 188, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229279410458*^9},
 CellLabel->
  "During evaluation of \
In[2900]:=",ExpressionUUID->"f4104eab-842b-46c6-ab14-a7f6c56a8611"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.06551803609155`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 2901, 189, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229279415271*^9},
 CellLabel->
  "During evaluation of \
In[2900]:=",ExpressionUUID->"0a2ec413-98b4-4193-8d6f-ab7d1f15d5c4"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"5.06551803609155`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 2901, 190, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229279473094*^9},
 CellLabel->
  "During evaluation of \
In[2900]:=",ExpressionUUID->"a475f7fa-57a7-43ff-89a2-19d79469862f"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 2901, 191, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229279528789*^9},
 CellLabel->
  "During evaluation of \
In[2900]:=",ExpressionUUID->"673f4d7e-f70b-4d2f-b5f4-fd8220c6dde1"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwd13k4VF8fAHC7mbHP2LexjBlbkqRInS+VECrZkkpD1qwllKQoFQrJlq1I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           "]]},
         Annotation[#, "Charting`Private`Tag$1212313#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwd13c81V8fAHAr3Gu73GvvTUKydT4SRaKBJGRLMhqym8pKZhlFVL/SMlJE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           "]]},
         Annotation[#, "Charting`Private`Tag$1212313#2"]& ], 
        TagBox[
         {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQPbcuic0wZbadhK5LyG9FTgf224/U38qftIfxF56a
X/ha/iacv2595+0cvVdwfrr9xZlvij7D+XlPNR9vWfcTzudSbFG/b8HgAOP3
CZzWWpjADOcn3Q7Zz3yGDc4vPNqSlK/OBedvLOAJlvDkhfMXVme/MggXgPOb
5v8J/PJGEM5nuPzAYU+VMJyvVpJWEaIlCuc/+To9jHuvGJzv9TSrdlKhBJzv
92SCtpycFJz/6nBSw4m10nC+nuA1Wed4WTify/5r4p3PcnC++9uo70qhCnD+
jUMpjFE6inD+1o4jcQpfEfw01tIH584pwfnJRdVbeWYpw/n66drnfBJV4Pzz
QjrcpZaqcP7udU2zdZjV4PxqRq2AM3cRfK47VR55W9Th/KfLFKfMr9GA86do
SLLsDNWE8yfMSjueqKAF50dNiT3H8xzB/+Gy9Of8fdpw/uOnThWH2nXg/EW2
htJnE3Xh/LWtpYLpunpwfntosjfzVwTf9M7Cle1n9eH8GZqz1571NoDz6w/0
zvDeieD7SocuPaViCOc75h2PFuxE8OfLJKmc+YrgqxxePs0v2gjhP91DWpf2
Ifhpn1kuntQyRqTHjZ8UOvsR/AmXeHqPHEfw931W+/n/P4IPACYEKYo=
           "]]},
         Annotation[#, "Charting`Private`Tag$1212313#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 19.999999591836733`}, {-0.5, 4.5}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVV3c8lf8XN0qRyh7Ze1+uK6tyjoqQhhWVFBVCSJRKfYUkJbIjyioyM0JJ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           "]]},
         Annotation[#, "Charting`Private`Tag$1212363#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVl3c81d8fx43yjWST7L1dMxrq/W4Q0kDSECUrRIgklZBQhKxIdillZVTG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           "]]},
         Annotation[#, "Charting`Private`Tag$1212363#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 19.999999591836733`}, {-1, 2.2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdlwdUE9kax9EIUgQTIkpv0juKCrLyjeCqFFEp4iJSooCVJiDFDgisoKCo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        "], {{
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{242, 255, 253, 11, 201, 154, 117, 90, 70, 58, 210, 
             163, 126, 99, 79, 12, 202, 155, 118, 91, 71, 59, 211, 164, 127, 
             100, 80, 13, 203, 156, 119, 92, 223, 176, 139, 236, 189, 72, 217,
              170}}]]}, 
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{1, 254, 253, 10, 9, 57, 69, 89, 116, 153, 200, 8, 56,
              68, 88, 115, 152, 199, 7, 6, 55, 67, 87, 114, 151, 198, 5, 78, 
             98, 125, 162, 209, 54, 105, 132, 169, 216, 66, 138, 175, 222, 86,
              113, 150, 197, 4, 192, 239, 145, 182, 229, 108, 188, 235, 135, 
             243, 172, 219, 77, 247, 190, 237, 141, 244, 178, 225, 97, 246, 
             185, 232, 124, 241, 161, 208, 53, 248, 191, 238, 142, 245, 179, 
             226, 104, 186, 233, 131, 168, 215, 65, 137, 174, 221, 85, 184, 
             231, 112, 149, 196, 3, 144, 181, 228, 107, 134, 171, 218, 76, 
             140, 177, 224, 96, 123, 160, 207, 52, 103, 130, 167, 214, 64, 84,
              111, 148, 195, 2, 75, 95, 122, 159, 206, 51, 63, 83, 110, 147, 
             194}}]]}, {}, {}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
            1.], LineBox[{1, 194, 147, 110, 83, 63, 51, 206, 159, 122, 95, 75,
              2, 195, 148, 111, 84, 64, 214, 167, 130, 103, 52, 207, 160, 123,
              96, 224, 177, 140, 76, 218, 171, 134, 107, 228, 181, 144, 3, 
             196, 149, 112, 231, 184, 85, 221, 174, 137, 65, 215, 168, 131, 
             233, 186, 104, 226, 179, 245, 142, 238, 191, 248, 53, 208, 161, 
             241, 124, 232, 185, 246, 97, 225, 178, 244, 141, 237, 190, 247, 
             77, 219, 172, 243, 135, 235, 188, 108, 229, 182, 145, 239, 192, 
             4, 197, 150, 113, 86, 222, 175, 138, 66, 216, 169, 132, 105, 54, 
             209, 162, 125, 98, 78, 5, 198, 151, 114, 87, 67, 55, 6, 7, 199, 
             152, 115, 88, 68, 56, 8, 200, 153, 116, 89, 69, 57, 9, 10, 253, 
             11, 201, 154, 117, 90, 70, 58, 210, 163, 126, 99, 79, 12, 202, 
             155, 118, 91, 71, 59, 211, 164, 127, 100, 80, 13, 203, 156, 119, 
             92, 223, 176, 139, 236, 189, 72, 217, 170, 242}], 
            LineBox[{133, 234, 187, 106, 227, 180, 143, 60, 212, 165, 128, 
             101, 81, 14, 204, 157, 120, 93, 73, 61, 15, 16, 17, 18, 19, 20, 
             21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
             37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 205, 158, 
             121, 94, 74, 62, 213, 166, 129, 102, 82, 220, 173, 136, 109, 230,
              183, 146, 240, 193, 249, 50}]},
           Annotation[#, "Charting`Private`Tag$1212410#1"]& ], 
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], 
           LineBox[{251, 252, 250}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 19.999999591836733`}, {-4.3, 2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV13c81d8bAHDbvde61yZZ9xqZF0UqfZ4SUZIdJStlFNG0Gl8ayEqSyEiU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           "]]},
         Annotation[#, "Charting`Private`Tag$1212533#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV13k8VN8bB3BZ545t7DvDjH2fUUrpPJHKUspSklTaLIVKSlRCQokkWUoS
JSol+mbfs+9LiFR2kV1I+Z3fPzOv9+t1Z86553zOc+8j7+RhdZKVhYXlI/74
//fja06cuicSttrt+UpfW5tCFW1UiwNUH6Swjf2OXsMUWvtUFEilhqK/9zWO
28dNoccl4XIc1Dj0O26hJV5rCp0xvHj2t9xL1Gk7+fDb7l+o7Y9z9LRcLnIz
4oWCUxOI68sP5Um5GuTamrTXbcMo6iopvDgxWoM+1O67Ojc9gtKfx5b/fFeL
GnXFjh7IGEF7zu85Mm5cj9i1t/yulhtBMURezMjpJpTf8X73DNcwEnxUzTrz
uRVl214qXOgeQE9rn5z7KdeN5jbElvwx60fzsTlq/Xe60Z+C4aMni7+iHafr
BlqXu9HTxvORjXpf0QTbb9u8th7UfGxZq0yhD2003GMQeqsXbXb5OszD8wU1
Z66yKk/1o5VtCzN+kp+RICIcebW+IYMijuXTyZ1os1K0wa0T31Ayv65guXon
ujv/cu5KyzcUcMfj6jejDqR3r+OkU8Z31Lquo9A4sA1dr9Uw0z0ygB720ibL
9zajtHf/KWU8GEBabKoz4wNNqDXWiE2xfgCVachTC1WbEP20XYH4pkH0nwLV
7FNxA6plC9JiERpCuYnfmbyidWh+nI/7iukQ2hmw2fy2Vy2SaY0bmbs+hBoH
nVVSO2uQZ1Jm0sjEELqa6GZSkFqNRA2/CDZ9GkafPnkEjHp8QkA/NbXr7zCS
zO+8m/2zErlwz9SVMUfQ96vbFA3cKlFBN+fND0kjCCRfCPterEDDJfeO6Xwe
QbGmg2sGLBWIP016azrvKBqYfRlXeLccOXkzfj++MoqaHK3/Cv1Xhu4cLmwT
ezeK2rUSNCf2lqGc7bve3hsZRcG75Urv/ipFJCFHl5s2Y+jD3Kzf+vWliLEy
arIWNoY06A09Bl9L0KHvFxR8SsdQv90yJ+/tEvQmM/TLGa1x1Lgtz1XvWzEa
Fxy/Y3ZsHB3SfOs1d7AYKXubbVWJHkdvgr8G7O8pQie606c4qsbRpV1LwQ7H
ilDSFu6nA8vj6P5ygDD7VCHqfeJmVarxE71/JVRsHliIJNjq2Z4c+YmCvZAk
Q7YQRdXcOWVf+RNJhhfodJwuQI0ak2Ibl34iYNsoFCFagLgjd9eIqE+goa7k
+e91+WjX3Osrc4cnkMq7eKv6W/koaD+fRkvkBNJA+/zMzfJRSa5735vyCeQT
5D15SCgf/ZVuuntncQLZzGvIrvzIQwb+2uCqOolYWR8GK+TmIe+BiJmdDpOo
mvo5seVBHsraMZ2sGDGJRsv5+9l88tDUy702bGWTKM3xeHGOUx7S4H3H8X1+
ElmcmP9vwCoPOXsK/Fek/AulnSNDmGkeSmk75/zI/hdac9HbkrojD33f0Cpx
JfwXyo/f7qFtlodk4xl1B0p+oaXFm340mzxk/zfKb/3cL9R0zpjL70Qeijk6
pymkNIUc/lVlMX3zUFu5df+03RTKi3BUMInNQxTl7MjG21OIXcJqOT0/D1mE
CRu9KppC1uGTPUeG8lDIpNdc6MwUKuv3dXUUyUdOaa6tTMFpVKdpJP/UPB+x
9EhmJKtPow+b3nrIh+SjJ9x1gQIm0+hNucXJrtp8tNXQ18HfcRpN9bQLFAsV
oF539fVTl6bRf3c5bjY6FaArSV94He9NI/NfCY1r/xUg8dbbw/Xp02iMZPvP
XKgQfWDbUry5Yhq1Tk7SXnkVIpv1Ew/T+6bRzlc0S4neQnQv1sI0hDKD2Pd6
Gf4rKEI6tavyv1VnUI5+mcqpDcWo8c+rlZPGM8iSksRekFOMyEd4Xxl7zyCb
5/YbScdLUKBiI9/alxmk/c9LySCmFCkcuDZydmEGBZwJ7NIdL0UlIVolvXyz
aOO/nVX/oAyt/rx7Lm/bLPrVlh/B8bsMXcyybL/4YhYF6rYaGgdVIOHBtVeD
JbNo1Fpw57FfFShL5O1N655Z5Ob0YkbrUCX6dZmir8s7hxr4YwUqt3xCp1FL
3MT5OTT76Ee7uVw1YklezPtyew4ZqUUcbEuoRrHs0r21KXPoYsOEbbVkDaqu
OSX7snMO+VZkbByRq0UqNqvJJw3m0eC9jxGuO+rRqLPyq6/rFlCJt8KuP9eb
kX+dRUOD5AIi7CJGvZubkbjW+V8FzAXEMfHx6pp8C85/gU7CyQVUz0mJ0ahu
QS+vWuUcqFlAz1k9Jl9S25Br1NWi5shFtDdePbZyrQOxLiT3F79cRHdehPtU
HulE8QeqWTLLFtFvzf96U0s6Ua20kHH4/CICAZ6+1aDPSP1FWpWp3W+U9rRs
Q7ZYN5rIb2suk1tCj55Npdc79SL3IdWB7DfLuO7ry/0q/I6+OXaTSmuWkWlI
VYnRv+/IuitEq2FwGb07+MF1eOsPtLFuxGdIcgV5ym6bFSr9gdjepVJEb60g
vZNRYl3VAyjWT37rpSN/UBaD2hEyOIRKhSTiNlH+It/o5D9q28YRWT5IuX8j
C9TpvJiqTpxBdyl1ak+PssFz5t8r79OWUa6+TM4edzYIdjvUy8TzGHT0QKu+
bCAtHpCQMLaMNr8WsjnwkA2i2m49oqqtoFFTh6u8jWwQsXMoafXlCjIOnGzy
2cwOY/U+BgMpf9DSAv9FK1EOuHQ/VLsl+C+iyTitrdE4gNX2ayk55S/asz07
9LUuB6xtUKaplv5FqVF2iaTdHKAyZasn/OcvstJ+WlUUyAEb2FMYz87+Q6+d
GZLqMxzA5F2WTtm9hpy+2BSz1XOC2xXrrBQ/FiAnfD97rpsT5CYiLK1DWSDL
3l26f5gTrm4UElx4wAJsPbd88tZxwZnGIapgJgukdOUxz+lzgXrLJan331hg
uIOa9jWZC2bSnh2J2bYOXJsnInN9SPCrtCxbfGUdCEb6IOVbJLhn+J5hwMEK
eZacv6KjSRCx3NFmSWEF7iY5c89MEiTNV6UeUGKFVw1WHMpDJGg9thjVs48V
ftV+9IneS4CSdyX/h+escK4yyMlDmQz9X/tsiF1sIDu4g3ORSYacUjsLqX1s
UMdKpPsBGX5Zbuag27OBIoTPhB4kQ/h4zReJM2zQnffAP+U2GW778bHERrDB
trfPE7unyCB8a0J/qJ0NBBKqe4w/csPHFMOXK3bsUJQbdq22ghtua1zbOn+U
Hdy6LBT2tXDDWurJiCFndqgUaXFxHOeGHfdq/DMvs4NPZPfSZWkeyN22w/X7
Q3b4fnNc9I0/D0ygV2Hl7ezwzpPHWtyUF8K5xO5m7uKA+nghn9f7eUF6FK5s
38sBwxWST4xO8IKtlXlK8wEOkJRQ/XnmOi9cusfb3HiKA4JKTQJLc3jh29Fg
y+NBHLBf8Pp7VwU+ML55PXS2kANW3s8IFf7hg8LInJ42NU4Q/rq0yYrgh8ow
2lsHXU7QIrEcHRHlh1y9b359+pxw3IHvlQCDH+d1N7lqOyfUs6tvP+XMD68v
de83cOSERNsTXvwd/DDRW1WREsEJT33dxnUOUCD7n1Z5wgQn6JQQS7cOU6C3
/D5L3QwnlLCncfQfp4Biw4lrc4uc8C18kBruie0ytVkH50g26fCBsVAKWM1S
y+1EuCC+wrLiaQEFIocqSae2cEEUr16ioIIAbB/evt31JhcoWLVmuKgIgHlf
4OmSUC54F+OZW6IlAHejlVP473JBs9zrdvfNApDO63o4LoYL+BhK3HU2AnA5
0+vKwRdcELZf/HLgLQHgcwoNCK3igoAnq/vmJwRg+W2AZQgrCfbqfDynPicA
x0/QAkc5SCBbeuGe07IAyEpF3NhGkCDvx3hzM4cgNG7qLe/jJ8GsYrfla1lB
UGjqe1okTQKnVzm7T+0VBAe4UC21ngQ6hufOPt4vCJM/0lw5NpLgX4NGeLuD
IJjsHTg6YkCC+Kln9UYugnDvWaxiNOCcM6LM5QIE4WzncZFIcxJsy3U37Xov
CFESbK+JoyTgM1Nz4c8TBK4Etd1eTiTo7RkK2VEiiHO++qLzBAkurzpUZ9fj
/2NfPhLgQoK3yHznvSFBsLMYiPM6T4JrzZynq38KQpDv96YELxJYHCsLXpsR
hNQIo5N53iQYDdj06ew/QRAbDvXvu0IC6idlEzMxIfDsitDLC8DneP/AiRsy
QhBxpkgqIYgEBSOJQR9pQhDcpPTvfDAJ7AjRCiUdIaDMCfpxhZEg0oLdmM1U
CNbtsm8ujSSBY1+xk4GlEBwct+M4GEUCDXffgHO2QpBheLZi+D4JqiNmS/uP
CYH56Pa0oRgSsLR9g4IrQqDSeMrH4xEJgsaKnl65IQSHQ/rZOx6TgGB5zLop
RAgufMrt03pCAkHNgxU5D4Qg7EC+XPFTEjw01lf0eiQEjKlFh4VkEkjbiwQz
ngkBR3RBhFwKCRRvtezMfCsEl+/yXbN8ToL0x5lpZ/8TgiKVTF7bFyTQyg4n
NIqE4MpB1s170kjwvtbNdbxCCNaMBKcNXpJg43fTurQ6IXjKNSYqlY7X47ey
xulWIXhXExn3C3sbH2e4YrcQBGYIOeVkkMBsc9me5GEh4Do6e0z6NQka9yVl
Hp0UAmJx38kCbGvnaxS5eSH43dluavmGBF3XHM71rQjBVd2ni+3YDg8MWhPW
CcP6d81Zu3Gd/JYhzrQnCcPcXX3rMuyTZYv3xfmFQaBG/smGtyRwn8qyfSAt
DM8G4jfLviPB/WfPHEKshGFrr97LzGwSiOfdKNxxUBjCP7M5UXNI8Kj5iCzH
UWEAz4PVkdjP/0p9u3FWGFZPcSR6fiDBxwPRx31DhEFq/RVPjY84f9w3Xd2L
hOHJ48nq6HwSKHmdumyjJgJcvyvmVcpIoGnQb/1ERwSMsr9mh2Drsdhpj28Q
gc8SHdqj2EZ3TIevG4sAZTZ5//NynI8UDZsMBxEY681xkaskQUz7rDZrhAjE
3TDLYa8mAcf66yOZcyJQkDh35FEDCQYXHu7nLhSFtXC6OHsXCZK3MS/0lYuC
SklpyUHsI+GNEZm1ojBxpUomE7uHzlFj3SUKrb1+C3bdJGixPr/50ZwosEQ/
lX3ZQ4KidxZUTTUxeBryzHNzH87P2XXjex6KwWHnhWGVHySwyX3EKZ8oBs7O
SbYXsQU5NtLmUsRATPKGXyn23UfuDg+zxEBf2GXObgDnte5LY3+DGDyY9gkN
GiSBp+qH957s4iD+3+qFxmGchyHXq1HnxKGz5M1GrZ8k2HGV9mr7ZXGoue+b
7YltJNLbs3hNHEIsDk5lYRuY7N546I44SKDPyRsmSKCWqj1HeyEO7p117Jsn
ScB9ct45p1ccMs342/WnSFA/eNWma6cEzBVdTmadw+fLb0Ng2B4JABOjnYbY
FcJT77bYSoD53qLMS9gF24/yP3WSAG5n1/qf2K9SjGpdrkoAn/aXjS3zJAg/
wQV/siRA+MFxlnuLJNgzGKkuKysJ7kknDg8t4/HUB9sd6JLwNuChpcgKCcwv
6F9LUJOE4eGnAibYu1i/NovrS8ITg2KOFGwjqrq30F5J6LdJf3fkDwnWO1SW
kAIk4bXfhF7jKj6v7cu2c0OSMFWm3xSyhuul1O413QlJ6PvR+ScLW+J4Uprn
rCQoiDqv9mKLzu74M/lPEh4YDfrosBBAoUQnjYpJwe3gXpcObDYLrZ99plKw
vP++gRgrAePlTv7Vr6WAOF4d5MtOgNy9Lte72VIgSF658wzbxnGPrU2+FLgE
aZyqwy5a2qT2rVoKUg0N7khyEBClKdD+ewC7JCjjA/bmh8XKypLSkNhWaj/M
ScAdV+mmm8HScPyfRBydIKBUPyrXPFwatm1ppezEXmQnpQhES0NVz1NHF+yj
T+YuP34qDbnf6VdfY+u11yrkFEhD5huilkkmoM/Qx3twVhpestRVbuQmQEug
U8b4iAy8Gpc+oMhLwHD4cMCDkzLA6FAbAezH5N8jI24ycNzt534HbB528aw7
l2XA5uRaRxT2+OLBHZ33ZMBDotH2H3Zqb5+7S4UMqD6q927iI0A6bag4QlUW
tv0W5j1EIaCdvkj/oS0L6z8lNJzHvv2UM0xvgyz4bQ47F4a9Eq9s020kCwey
BU/kYneFu4wqOMjC3k2ziyICBNy/MEn5cFcWaBS2iRpsMlo41jsnC+cV/Npk
hAi4vE2F9GFFFupSqseY2MPGh95ErJMD019hP0yxy3aVrhjxy4H96qzvRewr
VuH3X6rJgQzPt3112D9PKlZ6H5ODab3nz88JE2DvbOe211kO9kZFzN3Erna9
LaDmIQdWu3/T47FTPGYO9/nJwZd1FevLsB18CheNY+Xg7cZeQQERAurv2KoI
NOHxLsx3vMQ2iAhpHO+Qg6Gbfj4F2Gn38r0qeuVg5+g5tiZs0ehfkokDcuA5
OXvhO3ZQjHzppXE8/qhM3Rz2bKzN6X0zcvBZXYDgFMX7nXCLV31JDhbJPzXF
sRsf571nX5ODR101m9SwZZsXNaZYqRBUW3RoN7btPgqLAycVhLZ/vpeIfadV
ta2aoMIfWy92WTECyq2Nn6/npUJz+K4jddgr7Q4+yRQqdN5I3v1cnADd/d4W
/MJUeCHT6fNGggDnzxFyfmJUCIixvz0gScATu5ezo5JUcPdRVDWRJqCzu6zS
VpYKjyw7l1tlCOA91BtbJk+F9YX/Pb0jR8D23gU3bUUq3LA3rzgnT4DvYX70
SIUKF9k62QNoBGR9VREkNKiwkvuIvVCRgLEjRkMXtalgX75yXEGFAOr3Qx9/
MKjw6p92+Ts1Au4O3HUs2ESF6cutKxY6BFSeSNNVNaTCbJoPnx2TgNWhUvYY
oEJWsmPs7Q0EuI7Op3vspMJ2XRVfV0MCdk7a/1awpUIh27rDqxYEJAoHtl23
o4KZQVy9+j4C5jdnZPYeooLwsVfK120JSAr7czrGiQqsD+0EIh3xeik/6iI8
qTBia1tseZ6AvZYV2acuUIH9un3M/UsEPPeeiCz3psLfl9PMJT8CrCu3mF69
SoWvgzvVFEIIeOXUlzsdRoVRbp62yScEsIZxxOy+SwW3gZDXGs8JsHuneT79
HhWA/4Rk6CsCOFiuqZ2IpYJFWxdfXC4Bjo9lEz6nUiH/+gNpcgeuX11H/IpK
qHDki2V6J4UMp9Zu2UlVUMEreN3xInEyFCi91btcRYXcvTe2FVLJ4HKRZVK3
kQo5eynd/3TIUCb49HDqFyp0s162DbYig9fuH1vvLFKB8G57tieODF1lJ9bZ
a8jDwMzPYyJMbpje1iN5VVseesgyLV5buIGr1FIviSEPG6oXOvpMuGFDscHp
4Y3ycPtQx6U6O26Izqc0nDeRB8vpC5t4r3ODZXZB7G1HeTjz7fDcz3pu+JQq
rFMYKQ9tq0WM9Wd4ICekwpG6IA/PVga8LDJ4Ic2sTvzWkjw4qvT2fMV9TDxP
a+vkH3lgPnuc4FrCC/6R/TvyWRXAZJQEZzt4wSJ2RWs/RQF6Bo1fiK/xwo8X
Omu31RUg/Ya/RNdePuCrevTk9zEF8B65VBc/wQfrQp8ddDypAKur0XWzC3ww
b5YuVOmsAPvZq3i3rvFBd+N/t6I8FODBvdrc1wL8kNLZ6qF5VQEE634/nFzP
Dwb4GX08VgF4Oe38W3354RTHxW+NjQpwpcRO7vgqP0jK1Xz+06IA2dXxoe/X
UaBxo0yTSocCfHgv56HFQYENZyoLA77g64ea+/h4KMDZJpKwYRRfH/Lwko8E
BVKTPtgmrqPBLQ6n+9MMCtjlkXfXsdMgL3DL1n/rKcDT7rh9iYsG4Yx13uyb
KODFxcW04qNB1eiu6ytbKbDd/QCFU4oGYRes0u6YUWBw81LtWT0aFDtZ9+44
SoFYW4uyeH0aOHucYO91ooCFR1JulQENRs9zRbucxH1b8q40+W00+KfPHDnr
SoEgIu5mx24axL/2NJXyogD98yYwPE2DfLtP46RgCnRNh+u7utLgxv0Mb3oI
Be6Qf2g9PEsDk5oHHhvDKDBvGCYzc4EGO/r8X5vepUBFSs9Kij8NTDNM7gnE
UOD4ed8cnngaHBF9f2xTCl4fxtcc1cc0yBZIyWxPpQB5Fj7sSKLBjAzrd+cX
FHh7jvM//+c0SNSyXPVNp8Cq572P81k0iDaLCN39lgJNOvMfBT7Q4M2bM05v
31EgeXp/rlYuDZTvJSOe9xQw9ZTOcy6mweSXHonMHArEeLzI762jwc91sd1P
8yjgok0uWG6kgXXWOceGfApsmTpTINpKA1mfq/yzuA8dcGcU7u2igcb9ch7l
YgrouBcWVQzi+ThtEYJyCrBpUYu/j9BAyjIxdn0FBTonA4r/jdPAq8boMr2S
An5nd5VsnKFB8Lj3kV+fKFBzpq301V8a/I2KusqspcAjjQ1lNSx0mAoPvDmP
7TkRWzbMRocMmyXJzDoKiJ5xLKeS6ZDDlU4INFBgTL203JCXDrK2Nz0/Yhf8
pFXYU+hwS0fe/2AjBZzcxiqiRelgxsrICWmiwHp1i8p3EnR4+nPdmGgzBUg/
31Q2StOhy5HjRyJ2pqvXJxKNDs853sOjFgoEqH3+pKhEh1izgWyBVgrsH99U
ZaRKh97oA9w3sFdd1qr8tOnQY8e4ursNr7+qU3Ucgw7Lip9epGMnj1VUf1hP
hwIYbF3XTgHvl8o1bRvpUC6iwmmNbeoSVjO9mQ7XD+8zTcSWVp2s4UV0sLmv
njKAPT1qWatmRAcNZoAsrYMC5WlZtTtN6OCnJF/igB3jLFJ3YhcdYgpHIiOx
XVQu190wpwPXj6bYIuwtoz11iXvo8PNYR/8wNn+aYX3+PjrYc8+fJTop8ON0
Un2XDR32TKibK2HnKLM1LBygQwAz9rohdsjIyQbBQ3Qouu8oZInt8KK6QduR
Dq3lKXyHsLVPqzdaHKOD7stIn2PYX13kPF6foENmepqWE/adM0IUPmc6eCWl
ujlgG3hwvXN3o8NNKenNe7HHzv3Z1+ROh4Q3SS/+P16s19Ss9nn8+6rmfDr2
jksD9yMv0oH80SmAA3ve57PezGW8P9wCnN/w/Tzzq+vY50eHa3ti9mVjW10v
9s66TgfRU+88ArBZAt6LCQXS4Vv2ejcz7DdBLz5eCMb7d351Dw/24VsJB9tD
6ZDe+VWxGq83T1jEil44Hb6KfFi5ip13JzDhQSQdxE1cujSxxaLc+vY/pMOj
a5t6fPH+foo+cu2/eDqUahgJS2J7PbSWE0+kg8DLvwFZOB8tjzYf606hQ/u5
c2qtOE/+T7RZDdLoIJO0wecgtlYy7Vl8Bh2+KxWofMH5u/2Ce+hQFh1G6IzO
BpxXg/S1mwU5dHgToT++FXv01ZySTC4dWhLUbqfjfJtkfXH+WkwHsVrFpHM4
/2sFGRNHG+jw2mKnRQk+P2+Kn4SXNtPhPaT95cR2KLuvpdBOh5fmV6N31VAg
t8rXc6CHDkfoGYkFVRS40Go+f3KUDnzfZexd8PlV6EAPPv2kg14915kQfL6b
PzM3KE/RQVMhID+5jAKafVKXRxfo8COYDdWUUGBk5OcfVzZFCHjuQ+7H9SJm
vP9RHaciJGmyb+7G9WT7ZJuhBlkR6qOsWJpwvXk6m399kqIIRP1Dr9cfKXDo
7202T1lFMNQ+rqOfjc+ToAb3xU2KoP+mZ8ctXO+2nj07lrBFEYz1qJW2L/H9
Vb2pKkOKILXh1F9qGgXu+ukGUXYowjbZo4Wvcf20GN7wN8NKEUTvaZx8mkSB
2txtUz/cFKHYN/HW0gMKVB490LY3URGGrMa4E69RQC8/9t2lp4ogWybnJ3SV
AikiPRGJKYpQ/vnzs2Bf/DyodbCYSFeEo/1vN5y6TAEjPafKW/8pgkHxNj3u
8xQo4Tr7X1GzIvxXw/w8e4IC+W8CEjTYlODcBLrlbIqfdxa2kg85laASFLf7
7aTAvjHluHVkJXhhMrb3rgleP1pDTCdFCaxbBnxeb6OAUJxYlL+sEgzGsfd1
4eedW+CrkPZN+PdvO+zHVSkgZdd50c9TCQz0vrqqEhTwXae2t75PCaTqP8eP
hPEDuffKLvdsZUimTmfPXeeDoefy0U/8VPB7nEd2YwwvRKtIsOfaqkKHwY3A
gA88EBl/quoYVQ3O7jv3gMbGA5e8Ay740dTANfzD78csPOBolSj3UEkN6Pzi
ApL/uEGD3HmpXkMNTn+/d1psmRtqfExU9DepwZa3fLFKU9zAepAeymOlBkaW
m17EfOGGi2I/zP4LVIMlXSUiL4cb7KMPN/KMqIGV/uzmKXdukH5PlnIbVwN/
48ag1DPc0N/y3+maSTU43LmWdtiVG07wC64LnleDvrNk/7aT3OAe9om5tk4d
OCTE9nU4cEOAv3bcjLQ6vBfKytcx54aXZ9ad6LRSB1M2lWugyg1L21OXnxSp
wx3D4/TIcTL45T8JrChVh2fD/F87RsnAwojnHatQB0ETYJUZIQOXXIQ8o04d
rF+tBWcOkEF0+bJpxWd1+DhR6jbUSwbma4u40Wl1oFyOn77fRAZ3kfmNujQN
UBqstlvMIcPAkNHlslsasLWKwp4STAajJ43Jarc14IMmtzD1JhmS7Owbou5q
wAMbWtTjQDI41p1TOP5AA/T5k9of+ZOh521SPdszDXAX/7D/1RUytPr+o5oU
aYB0taMHnwd+nxXIq6ma14DlUomFz3ZkkK8zmdde0oD2V4td1w+QwT+oRTb2
jwasUKW5VfeTYevv0QvOrJrwyNRm/3VrMuT1iskSFE04JcV2dvMeMmS9uHje
TF0TEicXi6eNyZBsqCvVcEwTCi9ybDX9//vzHnLgnxOa4BFRqaipTYYfRwbG
VZ01oXhGQVRQiwy0gAd5we6acK38HW+/OhlSPi0fBF9NeKnNYXxTmQyplmWx
76M14V9dpgyrHBnSjlmLxldpwtL+17s/8pGh+rzGtepaTRj0mmnL5yXDaCDH
8GKDJoxOT5iV8JBB5fl/OdbtmiAZo0iqJ5Ph5biULe93Tdgb55jxi5MM6RcG
7/uvaMKNlN+zR9YIeH3zosBpTS2wjBIMmJwmYGLL4YCbOlqwfOyAtCC2xvz2
uWdMLVCg6oToTxGQ7iTc8W2TFhx7x9YaNIn7WfQ+1n6HFmSprkmpjuP+eHla
bs8RLZBOrvj9cICA+LNntNbf04LzCbMnyJ8J6KHbPLGO1oLkEIeFnZ0ESPRu
ppx/qAW3DzONg3H/EmvGPfvmsRYcrcsU5mgn4IFyeo5Kuha8d390lbuFgMjv
I1uky7VAKjT9m0EdAbdsj5uzLWiBYsFou1wJAcmWvQ4nl7SgidZ//GQxAQWm
tu5Vf7Tgb49nfkYR7qcNd967zaoNxedulxoU4v5dSf2zEEUbuk3XiTrlEcD4
PetEV9eGVxRR445sAr7GBlwxOaYN8vZKNbvSCViO+nP7xQltSPcppjx/SYBw
uNdjwlkbxHh6yezYpjdOlTS4a4NkxJpQ2QsCsl3MOPf7aYOsXuTpHakEhBkI
Rp16qA2zGt3+HkkErO99+vJWgzb862Bf2voQ929azkuZzdoQsetfQV4M3o/r
Wju72rTh6HQLtz52Ci1/UKVHG1he85roPsDju7XL1Q5rA8elNTGN+7gf9WMz
52TRARM9gRaDCAK6uTeU7pLQgf1/fm3IvUXAJ7240V5JHeDcWLjTBDv78Cr/
OWkdMHQyb2sJxuubWeYYJ6cDex267CZuErDL2nJ1TFEHYmbJAspBBHyMd9a/
zdABPcPA5ix/vF+qCa8bzHVAxu7WdeoV3C/P7UgN3K0DLaEcMVk+BFgWzT7a
ZKkDm6a8NEywOa3N7qRa6UBtBN9nt8sEXPRbdr16UAeulV0XLvYmwKrpgIrm
aR1QjmbP97tAAM9F4Wd3AnTAii9x876zBDijknijIB1oiq+1mT1DQDlxJmrp
pg648wp+vY99JbH8xolQHfjbT0ZdbgSMVZ0/uiVSB9o6bTRPueL7l2yRmXis
A3xRvftiThNwvSQ81jxXB5zqtNO2OxEw3lcSvZynA9abjh6dP0bgdZuLfFGg
A4ICc94p2Bob7EPZSnSgef5JIQd2V4bSlfxPOsCz+0Nq/RGcn4fFh9TbdWD6
385Qt8MEDJ+dkeWe0oHi+57cP+0I2HebLpU7jdfzS1JrKnZB2gGx07M6oNuv
P3EU+/5AIX/5gg7o1NBEug4QAAfDWHxXdWDPxnlm7X58nrbTfowTuvBkdtC+
0IaA3VK2qbV0XTiw1v67dy/ej0GtkkNKujDBvdUpFXvwNenLhLIuPLijyO2O
7QcFFH51XQi+5izGgv3qJM3PWlcXzNPuCypbEkB+O2PVa6gLkpRLDv67Caja
fpfl135dKEdGdx3NCBDkc5a6bvd/c1tqYTt+3raBYq8L3xRf7PhnSsCiy4Ib
47Au7Odz707EVopw+Ox9XBecH3cE/9hFQFC32ps1D1245B/edGEnAdvcqw4J
hOrCeRvHmILtOL9dYzsqwnRhruISRGBnG/MwLt3B87n1W8EJW0liH6kvQhfm
1bUjSdg8FT3ZaTG6MKjyjN3OGO+HxC9eSNGF45eLZdcZEeBZKVziXqwLyktd
R68gAtR09DPkS3UhIXh3ojX2QPzBmPYyXdhmd5pHE3u/Z+IZg0+64KOY7fNt
KwFbpFQkOBt0YZxojzLFJp3bfP5xjy748hpE0g0JeCLtRK9f0IXQaC5YNSDA
gKmu5fRbF8ZY9x7qw243nddfWtKFg7tVE4qwSZeCzemr+H5b+m/dwPZsST/v
x8qAN4YvKAQ2BM+VaPAzQPPipiLZTQT8mAo6HK7CAHJcT/Bxfbx/nHtO09QY
QGo6OLYLW1RG7FyuOgPyK964aWGbmb0MGtJiwKLijqblDQRkpTRkGK5nQM9W
Kl8UduBB0ZXJbQw4L6BlVr2eAHr5i5g9hxiwQdOszkyPgEaNpZReBwY0qB84
oId9OWbXe1dHBghZT/+Vwa5zGWsKPsYA4u6++BkmAecp6kTxaQZIdcbyxGMX
H37jq+3FgIWswMIpBgH2S9lHKeEMsGGVCHqtSwC7E4dH4l0G7l8NVeOx39TZ
XtWIZMCc6emhYOx1Txbjdt1nQP2108lHsdNMNrb5xzHgG89pDRHshah8k5lU
BrgZV7gG6OB6pVmm1lrEgJWjbINntPH1Gw8RASUMkMnybrbHLjaeH9Etw/Nt
PNy+C/vXQaXUe5UMiL5IKChimweHye2rZ8CntYqWr1q4PvVbCTd3MyDEKM1t
P7Zv5MDfhnkGXD470WSrSUBUgl/v1UUGBIUd9N6Bnf5cJF9ziQFxZ77r6GN3
Fey8HP6HAa0Zn7+LY28Yy5i1YGWCjpmPTp8GAdPbvEbq+JlgWuDk6oJ9ao69
pUaNCSfj5N5FqOPzlL690UGDCTamRmGB2PuPBdVNaTJhzN/2/CXsHU1sn0R0
mXDfk9PjCLZSBmv+MX0mhIoXietgDzmxpC4bM2GOY1y2XY2AE61/LqseZgKt
OfyGErZD6GbvAkcmrHTbi0tj24DvBcujTHj+k7tAAHv7m5WzF48zwVn/q+pf
VZyPsGWnUhcmfBt+8rgde2Dbb4uD3kwQsvPtuont9G6WGhrBhIOz/XozKgSc
CbBeNbvHBI0vMsYj2Betsz/z3GeC+HntI33YIQsX70bGMOFnT0BJDfabTct/
Hj5mguvkV8Vn2Mula53PM5ggDGZudtiRrTzhFVVMuG5q61KvjOvfs7POwTVM
2Gedxl+B/cyr0XhXHRPiNj4rzcf+IBq5UtfIhJq/trsysHvthZzbOpiww0Kk
PwxbeUDC+McAE55+UlW0wNbJviKbMsSEpiLp69uxDW5+WT45woQjzIaBLdgW
yo/fjo0zYWRZvUET+7wbVXZmhglqnTtkKdh+W24sZ80xQfD27XoS9k3eH+1e
C0xovyN+cx12bOaz20tLTKD2NwvPKeH3E3/203krTKge+PrzJ3bGvpNGfqtM
uPl4pX4QO1vhk8zWf0w4dUrkYx920ZzS8toaE67EUl93Yv8Pl3XY2g==
           "]]},
         Annotation[#, "Charting`Private`Tag$1212533#2"]& ], 
        TagBox[
         {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQPbcuic0wZbadhK5LyG9FTgf224/U38qftIfxF56a
X/ha/iacv2595+0cvVdwfrr9xZlvij7D+XlPNR9vWfcTzudSbFG/b8HgAOP3
CZzWWpjADOcn3Q7Zz3yGDc4vPNqSlK/OBedvLOAJlvDkhfMXVme/MggXgPOb
5v8J/PJGEM5nuPzAYU+VMJyvVpJWEaIlCuc/+To9jHuvGJzv9TSrdlKhBJzv
92SCtpycFJz/6nBSw4m10nC+nuA1Wed4WTify/5r4p3PcnC++9uo70qhCnD+
jUMpjFE6inD+1o4jcQpfEfw01tIH584pwfnJRdVbeWYpw/n66drnfBJV4Pzz
QjrcpZaqcP7udU2zdZjV4PxqRq2AM3cRfK47VR55W9Th/KfLFKfMr9GA86do
SLLsDNWE8yfMSjueqKAF50dNiT3H8xzB/+Gy9Of8fdpw/uOnThWH2nXg/EW2
htJnE3Xh/LWtpYLpunpwfntosjfzVwTf9M7Cle1n9eH8GZqz1571NoDz6w/0
zvDeieD7SocuPaViCOc75h2PFuxE8OfLJKmc+YrgqxxePs0v2gjhP91DWpf2
Ifhpn1kuntQyRqTHjZ8UOvsR/AmXeHqPHEfw931W+/n/P4IPACYEKYo=
           "]]},
         Annotation[#, "Charting`Private`Tag$1212533#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 19.999999591836733`}, {-0.5, 4.5}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVl3c8Vf8fx40iJFuSca1LNrdkVJ+3SCpfiTSQIhlZaVgZFUX2jERkFKIQ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           "]]},
         Annotation[#, "Charting`Private`Tag$1212583#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVl3c8lt8bx41SaNgt43nwUPYopHJdKirkW0YhkZFRdpGKpBSRGSVlhTKK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           "]]},
         Annotation[#, "Charting`Private`Tag$1212583#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 19.999999591836733`}, {-1, 2.2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmnk0Vl/0/02VSMbM8XgemWcqaThbgzKWDEkIKZIQkqKSIUNIMiVT5ikZ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        "], {{
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{749, 751, 1, 575, 425, 295, 186, 98, 663, 513, 383, 
              274, 51, 622, 472, 342, 233, 689, 539, 409, 145, 674, 524, 
              394}}], PolygonBox[{{729, 752, 750, 349, 240, 152, 11, 584, 434,
               304, 195, 107, 60, 630, 480, 350, 241, 153, 12, 585, 435, 305, 
              196, 108, 61, 631, 481, 351, 242, 154, 13, 586, 436, 306, 197, 
              686, 536, 406, 717, 567, 109, 668, 518}}], 
             PolygonBox[CompressedData["
1:eJwl1WmUiFUYwPGZKXuJSmUGM4OZhpRy6hwh7WVfBqXFklR2SSN7u6XI2vIB
LcSgomQ7ZIZsWbONIkS2yBJFZev3HB9+7n3+73CO+973THqHntk9khISEhKZ
4I8a1tPCn1Rgd9LlvtF6N4f5zM9Ms5ZmJ6M8X2O9k4r2S6xZTLUv42ez7Rfb
12K9OYdJWlGGaGV5RHvNfMS+E+fMk7mBFvp3Wm02mPvwsVaMoVoyj2qvm4/a
d+a8eQq52rWM1ipxo9bSvMS+Tvy/zLPMZfnQ/Ir5E/viDDOnsMg+g8n29Tx/
w/4P+y5cMM81pzLR/Ll5uv11jDGvtd5FZfs8axWm2W+x3sNNfr6VNU8riGZd
Zq3GPn70fLY1mV18FGdgrckh+nr+qbUEOxju+WprDQ5QzrzYmskeppg3WWtT
399903pM68oK++pc1OdZ05ikTzXPsL+eseaMeGfaY+Z8+7rxb5r70YC39ONa
Ny7FXSGZFB73bKl+L5vN/WlIOVp7tky/L87HPIBGvK2f0LonXr6ouZbyPKF/
b76freaBNKYCT3q2XH+AbeZBNCGVpzxboT8YZ24eTFPSeNqzlfpDbDe/SjPS
aePZKv1hfor7SnOG6Ce1HiQyXatIW3113G1+jvsZ3wJD4/vSepLEDK0S7fQf
4i6zI+5Z3H2G6ae0F7mCmVpl2utr4k6yM95l3G2G66e1XlzJF1oGz+hrzfX5
Jd5T3D3e0f/SXqIQX2qZdNDXmRuwK95DvHPe1f/WelOYr7SbeVZfb27I7jiX
eN+M0M9oL1OEWVoWHfUN5kbsiXOJO8BI/ayWQ1Fma1V4Tt9obsyvcS5xB3hP
/0frQzG+1qryfHw/5ibsjXOJe8Eo/d/41inON9otvKBvMjdlX5xL3BVG6/9p
fSnBHK0anfTN5mb8FucS94cx+jmtH1fxrXYrnfUt5ubsj3OJO8VY/bzWn6uZ
q91GF32rOZsDcS5xpxinX9AGUJJ5WnW66tvMLTgY5xJ3ivHxTWsDuYb52u10
0wvMLTkU5xJ3ivf1S9ogSrFAu4Pu+nZzKw7HucSd4oP4BcJgvTQLjTPNZRhn
ziTfviq58a1a6/I7/wOL39FX
              "]]}]}, 
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwt0LkyQ2Ech+FDo0MwQ2uozRh7Y09FbFdAbF1iK+xp5CqI7RpsidaIrdeL
tbQvlceM4pnv/3tPdyqj8aFYfhAEecRYc7wIz+zxo+W8NZww6fu198mb8IZ9
33VXuzNUuJMUuFPM+X5Fi3bMoFZm7/DNhPbIqt5tz3JJs5ZhQC+1t/liXHtg
Re+yZ7igSUvTr5fYW3wypt2zrHfa05zTqB3Rp4fsTT4Y1e5Y0jvsKc5o0A6J
6MV2inei2i2LersdJ0u9dkCvXmRv8MaIlmNBb/v/56fUafv06IX2Oq8MazfM
661//81d5U5T7q71ZvkFbiI7fw==
              "]], PolygonBox[CompressedData["
1:eJwV0jlPlFEUBuBhFUhQEmBsABkbQBRIlEWlABfobUSwckMoxLVXKEUL3KGA
RKVgUZYCEkC2xMTEgpCYKItiQijY/As+t3hyzvvefJO530zsWtulO/GRSCSO
fvaEff4oHplnda0sUKobpV6fJp+hhXlK9CPUOUuVU3jDP67qf/PQ2Wn5NnOc
0H3mov6AHLM/J0Pu57VunybdOg90VXLU3kGS3EOzbpbjuk9c0CXL+fZnHJI/
8ircj0bdGvd1lXK2vZ1EuZtbui8U64Y5r0uSX7LLFd0q9/QV8k1mOKYb4pw+
UT5i7+Sg/IEXuh451z7Ojtwgr3BXLg/v1FyiT3fUnCTLvmmW8ZUn8k8zgXfc
8NxW+C58D/cM9zMPM8y0879mMfMUOf9hDpq14XOcV5vL4T3pNswCZsiTT5rf
eGpPN9/T5ZluOcc+xnb4Pc1FLut/0WY/pe+1x+wTZNofE29/y/XwXuWofYgp
uVAeoEYO/81c+393K06Q
              "]]}]}, {}, {}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
            1.], LineBox[CompressedData["
1:eJwV0tdLlmEYB+BXU1uaYWVB8+vESi3LUjOjaVaHHjQtwfbSdoetsxZUaqlB
URlUaqlB0d4gFEQQtAdU0B5/gddzcHnfv9/D9+H3vk+soqq0Mi6Koi+EOSU+
is5bMrguV3BMF8dOXRq5ukr5pX0e3+RWeSB18mH5tD2ZffIvc7BpRFP9uWAf
wQ25SU6nWl4mH7fHs0vuw1V7jJP28c6r7K/s83lgz+a7vs0cRL3+iHzGnsJ+
ucPMZYj9lpnBRxrl52YRXXxmmnlR98Icad4zM/nETefNZn/eUuP8iZnHV5Y7
rwvfE54Lu50/NnP4TF/5mjmcU/ZnZiETfG6j+Vq3gB9ye3heNMhH5bP2XhyQ
h5Kgmy432UeF3ySvII9N+je6hfyUq0lkhr5Zl8lteSX1ugT26PqRr9scfp99
UXhvcg2NulQO6oaRpJspt9izuCOvokGXyF5dOgW6LfI7+2J+y7Wc0/XmkC5G
V12xfMmezV15NRPZqn+vK+NPuIt0ozuznF3Wjw7vSl5DIT0ocdaqH8N9eS2T
2Kb/EP4Xc4n5N9w5ejJb16bLCXdLXkcR28N90S3lX3jPJDNH364by0N5PZPZ
Ee6Mrpz/4TmTwlz9Fd04Hskt8gBq5admPhv0J8ykcM/pBGCjbDk=
             "]], 
            LineBox[CompressedData["
1:eJwl1He8z3UUx/HrNqzCNTKzrntDIkWRshs2F+1h7726ZstsWa3HI5SIi4rK
JiR7ZhehbO2yQ3qeR3+8Hue8X5/vHb/P95xfiTY903pkSkhIyJyYkDBcs16t
iPz6JWoypuqreyZdf0TfCmfk95EDDfgF3N1YJ/dADQzkj3KtcVaehJxoyC/k
KsXfk3uiJgbxx7g2OCdPRi404hdxlbFB7oVaGMwf59rivDwFSWjML+buwUa5
N2pjCH+Ca4cL8gfIjSb8Eu5ebJL7oA6G8ie59rgof4g8aMov5apgs9wXdTGM
P8V1wCV5KvKiGb+Mq4otcr/4bIn/3/kIrgCW6kvhI/2Dzl/Qn9bvUzuqa9Ty
cZ/4x/l89S8UxSFM8sx2tWr8D/F7PDNTTcIBjI3PplZCSf0KtTRm6PN5Nk2/
XH8ftsr94z65LBjJFcRD3Ivyz/pOuCxPwy1ozn/FVcM2eUDcL5cVo7hCeJh7
Sf5F3xlX5OnI4HJjHJeM/FwLeYX+/vhc8ly5IN6Vn493oc+G0XJhLNOnYJr+
Eecv63/Vd8FVeYFcDJPlj+VZ+jwYH+9QrRz3r1+plsFM/S71ARTwfEt1Jbc3
nLpaLRf7gG+dz1ML4SDeiztQq8T8ID1mQc2O/RgTc6zeFfOLIvJyNRWHMV3e
oVZDPT/7ivob1xVr9RXwL79QLY4p/Ax5tj4vJsgp8c64R+VVsb/xO2MnUR/D
+d+5brgWs4JCKIzHnH3N18DO2MvYcRTB485W8zXjfmIHY58xgv+D6x5fJshQ
bsUT/DdyLeyOHYx9RlE86WwNXxt7Yt9id1EMTzlby9eJO4/dij1FcTztbB1f
N/YjdiV2EiXwjLP1sUP4LuY19g8j+T+5+LLLhFlcSTzLb4jZxvcxn7ELGBX7
xfVEImZzyXiO3xizjP0xZzH7GM3/zfXCdZjDlUIrflPMJA7Eu4zZxhj+DNcb
1+MTLgWt+c1yPfwQ7ylmD6/yZ7k+uAGfcqlow2+R6+NgvId453iNP8f1xY34
jLsNbfmtcgMcinuJ943X+fNcP2TGXK402vHb5IY4HPcSM4A3+Atcf2TBPK4M
2vPb5Ub4Me4lZgBv8he5AciKz7my6BD7IzfGT3EvMRcYy1+KXUc2fMHdjo78
DrkJjsS9xKxgXHwvcunIji+5cujE75Sb4mjcS8wPxvOXuYG4CfO5O9CZ3yU3
w7G4l5gpTOCvcINwMxZw5dGF3y2n4XjcS8wUJvJXucHIgYVcBXTl98jNcSLu
JWYKb8VOc0OQE4u4O9GN3yu3wMm4l5gpvM1f44YiFxZzFdGd3ye3xKm4l5gp
vMMnYBifhCXiHDkfJsqpWKUvi4zYVbU6Tsf3lGf/A7k7B08=
             "]]},
           Annotation[#, "Charting`Private`Tag$1212630#1"]& ], 
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], 
           LineBox[{747, 748, 746}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 19.999999591836733`}, {-4.3, 2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{2}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.7165495462366123`*^9, 3.716549565721538*^9}, 
   3.716549919858232*^9, {3.716549951519142*^9, 3.71654996713827*^9}, 
   3.7165499987245913`*^9, 3.716550035373856*^9, {3.716550106804826*^9, 
   3.716550135450452*^9}, 3.716550168929225*^9, 3.716550209749441*^9, 
   3.716550425586097*^9, {3.716550457936707*^9, 3.716550511147169*^9}, {
   3.7165505724280777`*^9, 3.716550590282028*^9}, 3.716576363158704*^9, 
   3.716576495534512*^9, 3.71657653829676*^9, {3.716576610814971*^9, 
   3.716576647491843*^9}, 3.716749200886367*^9, 3.71675074418911*^9, {
   3.716750787409017*^9, 3.716750794385354*^9}, 3.7167508493423347`*^9, {
   3.716750910790704*^9, 3.716750969936206*^9}, {3.716751065599144*^9, 
   3.716751091201434*^9}, 3.716751200331757*^9, 3.716751327830246*^9, 
   3.716781397852318*^9, 3.716781430456499*^9, {3.716781527421125*^9, 
   3.716781567990053*^9}, 3.75944753525454*^9, 3.793504189397251*^9, 
   3.793908470280088*^9, 3.8232292796664762`*^9},
 CellLabel->
  "Out[2905]=",ExpressionUUID->"9636a449-f9ac-4a06-879b-9f067f4226af"]
}, Open  ]],

Cell["\<\
Top:  observer only, with bad initial conditions.  No control
Bottom:  add linear feedback control & disturbance at t = 10.

Thus, we see that the observer-controller can handle both bad initial \
conditions and an impulse disturbance (of force).  The undesirable spike near \
t=0 results from a quite inaccurate initial condition.  Limiting the control \
to say \[PlusMinus]2 does not change the response significantly.\
\>", "Text",
 CellChangeTimes->{{3.716549440008771*^9, 3.716549496570567*^9}, {
  3.716549903807413*^9, 3.716549908468196*^9}, {3.716550174480042*^9, 
  3.716550204455696*^9}, {3.716781297798024*^9, 3.716781340691071*^9}, {
  3.716781455935663*^9, 3.7167814707277193`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"8cfca207-ff3c-4a3b-a4f6-a1b4262ad028"],

Cell["Export data", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"e6b9dd7c-94a1-4d07-95fa-dd789682b70c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dt", "=", "0.05"}], ";", 
  RowBox[{"dat", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Through", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "x1a", ",", "x2a", ",", "xh1a", ",", "xh2a", ",", "u0", ",", "uf1b", 
          ",", "x1b", ",", "x2b", ",", "xh1b", ",", "xh2b"}], "}"}], "[", "t",
         "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Tau]1", ",", "dt"}], "}"}]}], "]"}], "//",
     "N"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<pendulumSwingUpObs.dat\>\"", ",", " ", "dat"}], "]"}], 
    ";"}], "\[IndentingNewLine]", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.716751253134076*^9, 3.716751273791581*^9}, {
  3.716751789086158*^9, 3.716751806010297*^9}, {3.79350411912638*^9, 
  3.793504126547068*^9}, {3.7939084626934023`*^9, 3.793908462875792*^9}},
 CellLabel->
  "In[2906]:=",ExpressionUUID->"05bb38aa-d066-4d1e-b834-508c6cd73534"]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 120}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"ea299f4e-abcb-46cf-af6b-6eedbd10f46f"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 533, 10, 105, "Section",ExpressionUUID->"60b09a07-4679-4cd9-9875-aece6d4e38a2"],
Cell[1116, 34, 2180, 40, 66, "Input",ExpressionUUID->"3413512a-057a-4181-97cf-e9214504c8ed"],
Cell[3299, 76, 856, 15, 52, "Text",ExpressionUUID->"fa7774ec-e0dd-4507-bceb-9a6b63479623"],
Cell[CellGroupData[{
Cell[4180, 95, 11560, 273, 614, "Input",ExpressionUUID->"6e609bb9-6103-45b7-9599-6a78d6c71957"],
Cell[15743, 370, 13774, 244, 248, "Output",ExpressionUUID->"f728fd10-912d-4585-9ad1-bd66d8f98175"]
}, Open  ]],
Cell[29532, 617, 648, 10, 52, "Text",ExpressionUUID->"40e91600-d0a7-4104-bb5c-58f5d859fdfd"],
Cell[CellGroupData[{
Cell[30205, 631, 3044, 75, 166, "Input",ExpressionUUID->"5898e310-4d3d-4f2a-8e74-7a80b324df76"],
Cell[33252, 708, 3053, 54, 54, "Output",ExpressionUUID->"07e0fd34-911d-4d5e-85d9-20826d1f4b9f"]
}, Open  ]],
Cell[36320, 765, 577, 9, 52, "Text",ExpressionUUID->"9e00ec17-5956-4720-a149-80cee95897b6"],
Cell[CellGroupData[{
Cell[36922, 778, 7969, 192, 392, "Input",ExpressionUUID->"a6e63832-b982-4623-8d7f-fa1c97fceb51"],
Cell[44894, 972, 490, 10, 39, "Message",ExpressionUUID->"030f431f-7c0c-4441-b339-2ee905abf763"],
Cell[45387, 984, 488, 10, 39, "Message",ExpressionUUID->"f350a56b-14d7-438f-b680-337b09c99913"]
}, Open  ]],
Cell[45890, 997, 557, 9, 52, "Text",ExpressionUUID->"d64cc3d7-7d88-45fb-a632-9366c463e19b"],
Cell[CellGroupData[{
Cell[46472, 1010, 12593, 295, 623, "Input",ExpressionUUID->"c4273a82-126b-4e65-8280-0d685c721ed3"],
Cell[59068, 1307, 487, 10, 39, "Message",ExpressionUUID->"f4104eab-842b-46c6-ab14-a7f6c56a8611"],
Cell[59558, 1319, 487, 10, 39, "Message",ExpressionUUID->"0a2ec413-98b4-4193-8d6f-ab7d1f15d5c4"],
Cell[60048, 1331, 487, 10, 39, "Message",ExpressionUUID->"a475f7fa-57a7-43ff-89a2-19d79469862f"],
Cell[60538, 1343, 472, 10, 24, "Message",ExpressionUUID->"673f4d7e-f70b-4d2f-b5f4-fd8220c6dde1"],
Cell[61013, 1355, 154014, 2630, 273, "Output",ExpressionUUID->"9636a449-f9ac-4a06-879b-9f067f4226af"]
}, Open  ]],
Cell[215042, 3988, 808, 15, 172, "Text",ExpressionUUID->"8cfca207-ff3c-4a3b-a4f6-a1b4262ad028"],
Cell[215853, 4005, 394, 7, 52, "Text",ExpressionUUID->"e6b9dd7c-94a1-4d07-95fa-dd789682b70c"],
Cell[216250, 4014, 1197, 30, 212, "Input",ExpressionUUID->"05bb38aa-d066-4d1e-b834-508c6cd73534"]
}, Open  ]]
}
]
*)

