(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     93266,       1812]
NotebookOptionsPosition[     91986,       1785]
NotebookOutlinePosition[     92382,       1801]
CellTagsIndexPosition[     92339,       1798]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Pendulum swing up & balance, with local linear feedback (Example 7.7)\
\>", "Section",
 CellChangeTimes->{{3.698811497715045*^9, 3.698811509022469*^9}, {
  3.69885144307857*^9, 3.698851462312389*^9}, {3.709636905485622*^9, 
  3.709636910921179*^9}, {3.715342867107555*^9, 3.715342872342836*^9}, {
  3.7153432690028687`*^9, 3.715343287448956*^9}, {3.716532618830523*^9, 
  3.7165326217793283`*^9}, {3.716570684194786*^9, 3.716570736464383*^9}, {
  3.716613642404841*^9, 3.716613649251136*^9}, {3.7166173099843607`*^9, 
  3.716617315405965*^9}, {3.7167170388199997`*^9, 3.7167170401560717`*^9}, {
  3.716725771532446*^9, 3.716725778338876*^9}, {3.793503062639168*^9, 
  3.793503066380783*^9}},ExpressionUUID->"c2f1811f-5d39-4870-bd7a-\
071084aa3a3d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ffCalc", "[", 
    RowBox[{"n_", ",", "\[Tau]_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "f", ",", "\[Theta]", ",", "\[Theta]dot", ",", "\[Lambda]", ",", 
       "\[Lambda]dot", ",", "t", ",", "\[CapitalDelta]t", ",", "bcs", ",", 
       "eqns", ",", "sv", ",", "froot", ",", "\[Theta]ff0", ",", 
       "\[Theta]dotff0", ",", "uff0", ",", "\[Theta]ff", ",", "\[Theta]dotff",
        ",", "uff"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalDelta]t", "=", 
       FractionBox["\[Tau]", "n"]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"{", 
         RowBox[{
         "\[Theta]_", ",", "\[Theta]dot_", ",", "\[Lambda]_", ",", 
          "\[Lambda]dot_"}], "}"}], "]"}], " ", ":=", " ", 
       RowBox[{"{", 
        RowBox[{"\[Theta]dot", ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "-", "\[Lambda]"}], ",", 
         "\[Lambda]dot", ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "\[Lambda]"}]}], "}"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"bcs", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[Theta]", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["\[Theta]dot", "0"], "\[Equal]", "0"}], ",", 
         RowBox[{
          SubscriptBox["\[Theta]", "n"], "\[Equal]", "\[Pi]"}], ",", 
         RowBox[{
          SubscriptBox["\[Theta]dot", "n"], "\[Equal]", "0"}]}], "}"}]}], ";",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{"hard", " ", "final", " ", "constraint"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"eqns", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"bcs", ",", "\[IndentingNewLine]", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Thread", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                SubscriptBox["\[Theta]", "i"], ",", 
                SubscriptBox["\[Theta]dot", "i"], ",", 
                SubscriptBox["\[Lambda]", "i"], ",", 
                SubscriptBox["\[Lambda]dot", "i"]}], "}"}], "\[Equal]", " ", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 SubscriptBox["\[Theta]", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Theta]dot", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["\[Lambda]dot", 
                  RowBox[{"i", "-", "1"}]]}], "}"}], "\[IndentingNewLine]", 
               "+", 
               RowBox[{
                FractionBox["\[CapitalDelta]t", 
                 RowBox[{"2", " "}]], 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"f", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["\[Theta]", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Theta]dot", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]", 
                    RowBox[{"i", "-", "1"}]], ",", 
                    SubscriptBox["\[Lambda]dot", 
                    RowBox[{"i", "-", "1"}]]}], "}"}], "]"}], "+", 
                  RowBox[{"f", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    SubscriptBox["\[Theta]", "i"], ",", 
                    SubscriptBox["\[Theta]dot", "i"], ",", 
                    SubscriptBox["\[Lambda]", "i"], ",", 
                    SubscriptBox["\[Lambda]dot", "i"]}], "}"}], "]"}]}], 
                 ")"}]}]}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sv", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Theta]", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Theta]dot", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]", "i"], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox["\[Lambda]dot", "i"], ",", "0"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "1"}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\t", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"initial", " ", "guesses"}], " ", "=", " ", "0"}], ",", " ", 
        
        RowBox[{"very", " ", 
         RowBox[{"naive", "!"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"froot", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{"eqns", ",", "sv"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Theta]ff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["\[Theta]", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Theta]dotff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            SubscriptBox["\[Theta]dot", "i"], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"uff0", "=", 
       RowBox[{"ListInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"-", 
             SubscriptBox["\[Lambda]", "i"]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", 
          "froot"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Theta]ff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Theta]ff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "\[Pi]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"\[Theta]dotff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Theta]dotff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"uff", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"uff0", "[", "t", "]"}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "\[Tau]"}]}], 
           "}"}], "}"}], ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"\[Theta]ff", ",", "\[Theta]dotff", ",", "uff"}], "}"}]}]}], 
    "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "500"}], ";", "  ", 
  RowBox[{"\[Tau]", "=", "5"}], ";", 
  RowBox[{"\[Tau]1", "=", 
   RowBox[{"3", "\[Tau]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]0", ",", "\[Theta]dot0", ",", "u0"}], "}"}], "=", 
   RowBox[{"ffCalc", "[", 
    RowBox[{"n", ",", "\[Tau]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p0", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]0", "[", "t", "]"}], ",", 
       RowBox[{"u0", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "4"}], "}"}]}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.716725835516573*^9, 3.716725835885325*^9}, {
   3.716726014532469*^9, 3.71672602766113*^9}, {3.716726231523755*^9, 
   3.7167262420957603`*^9}, {3.716726307201371*^9, 3.71672640862053*^9}, 
   3.716727073320963*^9, 3.7167365399686203`*^9},
 CellLabel->
  "In[2865]:=",ExpressionUUID->"6e42687c-bd84-429b-9901-9da7fec5d545"],

Cell["\<\
Test the approximate solution on the open-loop dynamics (integrated at a fine \
time step)\
\>", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.7594359074577227`*^9, 3.759435912134766*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"291c1013-9723-4bbf-bdf6-0ec48ff3a54f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TestSwingUp", "[", 
    RowBox[{"\[Tau]1_", ",", "uff_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "eq", ",", "init", ",", "\[Theta]", ",", "\[Theta]dot", ",", 
       "\[Theta]s", ",", "\[Theta]dots", ",", "us", ",", "t"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"eq", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"\[Theta]", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Theta]dot", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Sin", "[", 
             RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}], "+", 
           RowBox[{"uff", "[", "t", "]"}]}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"init", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Theta]", "[", "0", "]"}], "\[Equal]", 
         RowBox[{"\[Theta]dot", "[", "0", "]"}], "\[Equal]", "0"}], "}"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]s", ",", "\[Theta]dots"}], "}"}], "=", 
       RowBox[{
        RowBox[{"NDSolveValue", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"eq", ",", "init"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Theta]", ",", "\[Theta]dot"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}], "//", 
        "Quiet"}]}], ";", "\[IndentingNewLine]", "\[Theta]s"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]1", "=", 
   RowBox[{"TestSwingUp", "[", 
    RowBox[{"\[Tau]1", ",", "u0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]1", "[", "t", "]"}], ",", 
       RowBox[{"u0", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.716726475850806*^9, 3.716726483729012*^9}, {
   3.716726540265172*^9, 3.71672655675944*^9}, {3.7167265922123337`*^9, 
   3.716726624099812*^9}, {3.716726827404985*^9, 3.71672683813792*^9}, 
   3.716727075758045*^9, {3.716736385196327*^9, 3.71673639877942*^9}, {
   3.759439450188809*^9, 3.759439451670306*^9}},
 CellLabel->
  "In[2870]:=",ExpressionUUID->"03e0d4f6-e531-4b5f-ab2e-1a3e95fe7d1f"],

Cell["\<\
Show that linear feedback can stabilize against various perturbations\
\>", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.716726797650621*^9, 3.716726800769066*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"cef80cf4-d7d3-4045-a5b9-b38502d93e2f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TestSwingUpFB", "[", 
    RowBox[{
    "\[Tau]_", ",", "\[Tau]1_", ",", "d_", ",", "\[Theta]ff_", ",", 
     "\[Theta]dotff_", ",", "uff_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "eq", ",", "init", ",", "\[Theta]", ",", "\[Theta]dot", ",", "t", ",", 
       "\[Kappa]1", ",", "\[Kappa]2", ",", "ufb", ",", "u", ",", "td1", ",", 
       "td2", ",", "td3"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Kappa]1", "=", 
       RowBox[{"\[Kappa]2", "=", 
        RowBox[{
         SqrtBox["2"], "+", "1"}]}]}], ";", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"lqr", " ", "for", " ", "q"}], "=", 
        RowBox[{"r", " ", "for", " ", "balancing", " ", "pendulum"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"td1", "=", "3"}], ";", 
      RowBox[{"td2", "=", "8"}], ";", 
      RowBox[{"td3", "=", "13"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ufb", "[", "t_", "]"}], ":=", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"\[Kappa]1", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
                RowBox[{"\[Theta]", "[", "t", "]"}]}], ")"}]}], "+", 
             RowBox[{"\[Kappa]2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
                RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ")"}]}]}], ",", 
            RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", 
             RowBox[{"td3", "-", "0.1"}]}]}], "}"}], "}"}], ",", "0"}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"eq", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"\[Theta]", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{"\[Theta]dot", "[", "t", "]"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Theta]dot", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Sin", "[", 
             RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}], "+", 
           RowBox[{"u", "[", "t", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"uff", "[", "t", "]"}], "+", 
           RowBox[{"ufb", "[", "t", "]"}]}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"init", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Theta]", "[", "0", "]"}], "\[Equal]", 
         RowBox[{"\[Theta]dot", "[", "0", "]"}], "\[Equal]", "0"}], "}"}]}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"NDSolveValue", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"eq", ",", "init", ",", 
           RowBox[{"WhenEvent", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"t", "\[Equal]", "td1"}], ",", 
               RowBox[{"t", "\[Equal]", "td2"}], ",", 
               RowBox[{"t", "\[Equal]", "td3"}]}], "}"}], ",", 
             RowBox[{
              RowBox[{"\[Theta]dot", "[", "t", "]"}], "\[Rule]", " ", 
              RowBox[{
               RowBox[{"\[Theta]dot", "[", "t", "]"}], "-", "d"}]}]}], 
            "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "\[Theta]dot", ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}]}], "]"}], "//", 
       "Quiet"}]}]}], "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", "0.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]2", ",", "\[Theta]dot2", ",", "u2"}], "}"}], "=", 
   RowBox[{"TestSwingUpFB", "[", 
    RowBox[{
    "\[Tau]", ",", "\[Tau]1", ",", "d", ",", "\[Theta]0", ",", "\[Theta]dot0",
      ",", "u0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]2", "[", "t", "]"}], ",", 
       RowBox[{"u2", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.716726812667987*^9, 3.716726883531363*^9}, {
   3.71672696136793*^9, 3.716727079150625*^9}, {3.7167271306788473`*^9, 
   3.7167271716690073`*^9}, 3.7167383122717752`*^9, {3.7167383517180233`*^9, 
   3.7167383524198914`*^9}, {3.716738394564283*^9, 3.716738407792145*^9}, {
   3.716738452123864*^9, 3.716738453915711*^9}, {3.716738489877406*^9, 
   3.7167385083938313`*^9}, {3.7167385651893682`*^9, 3.716738646187314*^9}, {
   3.716738708050569*^9, 3.716738756860454*^9}, {3.71673880160703*^9, 
   3.716738803694364*^9}, {3.716738839979808*^9, 3.7167388785547457`*^9}, 
   3.716738937718771*^9, {3.716738967881958*^9, 3.7167390202687263`*^9}, {
   3.716739074798856*^9, 3.716739090078024*^9}, {3.716739269912098*^9, 
   3.716739326035336*^9}, 3.716739360688181*^9, 3.717178550725272*^9, {
   3.717179996299794*^9, 3.717180005418765*^9}, {3.719219580933455*^9, 
   3.719219633426746*^9}, 3.719219673090198*^9, {3.7192197169720697`*^9, 
   3.719219795711013*^9}, {3.719219832146811*^9, 3.719219875007923*^9}, {
   3.7192199632992973`*^9, 3.719219968538327*^9}, 3.759439464912045*^9},
 CellLabel->
  "In[2873]:=",ExpressionUUID->"9feaa965-6c5e-433b-9cc7-a1ba3b998866"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"p0", ",", "p1", ",", "p2"}], "}"}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.716727082904867*^9, 3.7167271126452913`*^9}},
 CellLabel->
  "In[2877]:=",ExpressionUUID->"8d2f4767-77dd-4e07-af88-03d0096681b6"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJzt2vk/VO//+HFZZ4SYERKVSEUolSg8rywpShKFLGWJylYUSVmKpKwJIVK2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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{419, 538, 536, 243, 244, 432, 385, 347, 319, 299, 
             287, 245, 433, 386, 348, 320, 300, 288, 442, 395, 357, 329, 309, 
             246, 434, 387, 349, 321, 455, 408, 370, 301, 449, 402, 474, 364, 
             466}}]]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwNz80vF2AAwPGf/goKm62Ek9RB3k55OZBliZwiBy8jDWNeyok4iGUZTVND
89rJ2wGN1WSsWhgr3MpbL/oL+hw++z57XvdEFD3IqTwXCASC6OEHISaC+Wd8
xl/+8JtfhNscQwoFtPCWU2thGk0yd3nMFCfWrmkGxXQwTyjZlNPNO6J4SC8f
SCKfR0xy7K56fckGOQzxlUp6WOEqI2xRwzf6+Ug6e7ziM/fZoZ05LnDAG7ap
5TsvWOMm+7zmC2Xs0sUSlxlmkyqe855EBvlEHs1McORPdTrAOreo4BnLxFFN
H6ukUcQTZjlPFqU8ZZFIErhDE+MceueKplJIGzOEkEkJnSxwievk0sgYP52P
1Rvco5VpgrlIPLdpYJT/i+RQxA==
             
             "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], 
            LineBox[{1, 182, 143, 221, 110, 214, 175, 225, 85, 207, 168, 223, 
             135, 219, 180, 65, 201, 162, 129, 216, 177, 104, 212, 173, 140, 
             51, 194, 155, 122, 97, 210, 171, 138, 77, 205, 166, 133, 108, 2, 
             183, 144, 111, 86, 208, 169, 136, 66, 202, 163, 130, 105, 52, 
             195, 156, 123, 98, 78, 3, 184, 145, 112, 87, 67, 53, 196, 157, 
             124, 99, 79, 4, 185, 146, 113, 88, 68, 54, 5, 186, 147, 114, 89, 
             69, 55, 6, 7, 8, 9, 10, 11, 187, 148, 115, 90, 70, 56, 12, 188, 
             149, 116, 91, 71, 57, 13, 189, 150, 117, 92, 72, 58, 197, 158, 
             125, 100, 80, 14, 190, 151, 118, 93, 73, 59, 198, 159, 126, 101, 
             81, 15, 191, 152, 119, 94, 74, 60, 199, 160, 127, 102, 82, 16, 
             192, 153, 120, 95, 75, 203, 164, 131, 106, 61, 200, 161, 128, 
             103, 211, 172, 139, 83, 206, 167, 134, 218, 179, 109, 213, 174, 
             142, 17, 193, 154, 121, 215, 176, 96, 209, 170, 224, 137, 220, 
             181, 226, 76, 204, 165, 222, 132, 217, 178}], 
            LineBox[{107, 141, 62, 84, 18, 63, 19, 20, 21, 22, 23, 24, 25, 26,
              27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 
             43, 44, 45, 46, 47, 48, 49, 64, 50}]},
           Annotation[#, "Charting`Private`Tag$1211128#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV0etPSHEYwPHDXxEpbKJUm9DmTptKW2U1d9oUtnJNMU3ktlXYSIwwVi6Z
ULKVy1aSuS5zi4nwjgjJpdc+Xnz23dnz/M7Z2W9kzobM9YOCIGjmExc9bGUe
kxhFCE2UspzZjOOz/TotZj6TiaCFA+SSyhCaKSObROLocf6SbmMBUxhNKwfJ
I42hXKecHJJ4yHEKGU87h1lHBh2cYgtffOeybmchT6lmKvc4Sj6dnGcMt6mg
i9U85wwfSOcxJ+lmM6+5wEdCucFe3rCCZ9TwnmQecYJ3bOIVtUzgLkf4fzEv
OUcmTzhNEV/90xUtYRHTuM8xNhJJG4dYw1yGcZN9rGQOE+n1rnrdwWKmE0UY
38wadCdLmMFYwvlu9oM+ftLPL0IGB8Fv/cNVe7tYykyiGc5fs0bdzTJmEcMI
brGfVaQQz4D9a7qHLBJ4QBUFxHKHSt6ylhec5R8NCWLx
             "]], 
            LineBox[{336, 459, 412, 374, 289, 443, 396, 358, 330, 310, 247, 
             435, 388, 350, 322, 302, 290, 248, 249, 250, 251, 252, 253, 254, 
             255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 
             268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 436, 389, 
             351, 323, 303, 291, 444, 397, 359, 331, 311, 452, 405, 367, 339, 
             462, 415, 377, 471, 424, 480, 279}]},
           Annotation[#, "Charting`Private`Tag$1211128#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{484, 534, 485, 486, 487, 488, 489, 490, 491, 492, 493, 
             494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 
             507, 508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 
             520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532, 
             535, 533}]},
           Annotation[#, "Charting`Private`Tag$1211128#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{228, 229, 227}], 
           LineBox[{482, 483, 481}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdm3k4ld8X9sl0zjE7Ms/zVEqFTHulZCylFEqKhMpQiYhCiELRYCpNRJQi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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{728, 48, 46, 552, 553, 741, 694, 656, 628, 608, 596, 
             554, 742, 695, 657, 629, 609, 597, 751, 704, 666, 638, 618, 555, 
             743, 696, 658, 630, 764, 717, 679, 610, 758, 711, 783, 673, 
             775}}]]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV0s8v13EcwPHPF5kfY1G3Cl8/cqu/pOTbqR+y2YhDCSf9OJTGKFyiOoTV
amWMkpNfh8qyLJZh0iQ6IYcwjaUeDo89X6/X+/oOF5VHrkYFQRDiAUcsJ/UE
uebj5JBNFpmcpZAqmunnJ2EiXKKSJt6yTAZl3OIxI6yTz106GGWLAl4wzi4V
NNLHEul0M0VUdBDU6Rxx5mc6xh9KmSfB/ZUe1And4yap9hk9oI80SYf1F2c4
bP+midqpKTqp/6jhkH1WY7Vdk/WDbnKRr8S7PddP7HCNaWLc7+sbfpBGF18I
eavVp3xkm8u85DN/ucFDhlgjjzu08Z4NLlDOPV6zyDFKuE4rg6xymts84R2/
Oc/+52igl+8cpZhqWhhghVOc4wr19LDAf6EoUtU=
             
             "]]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwl1WWUVmUUgNGhJKSkuzsMlO7ubqURkO5uKUmlu0G6uzsFpKW7uzvcd/Fj
zznP+31r4t47M8kbtK7UKlRISEjc0CEhwVzlQyVi6Tc6irlYxzP/1uHMOTqO
WcqMYa4wf/baZ3MaRYjmfKn5zHkk+wJ7ebLo82Y3knFER/D6PHtZftdh9Cx7
CV5pGbLaXpm39nl85XCuLs0vIV/eNN1elOfyRy7Yu5Ocf3W/4HOzRlfhnX0+
tfiJi856kIKjuj9hWaur8t6+gNpkDa4F65xX44N9IXXIFnx/hA9+NiIG14Cv
We+91floX0RdshOZDc5r8Mm+mHrkCO4BG53X5LN9CfXJySVnPUnJMT2AqGwK
7klwQ1lqNCAXl3UvUnFcDyQam4PrSCiW6Ybk5oruTWpO6EFEZ4uuRWiW61+D
L+UezNDFeKHzcNXehzScDK6F98y3l+OP4Prq2faSfGNfbr4Orod9kb1icK63
mrUJQ1SvLTFXBNc4eC5DfXl+y5gxzZVmArNR8FiYM3Vss7gZ3VxmxjdfBvfE
XKgrkFdfM/uSllN6MDHYpusQlpW6Mfm4HjyzpOO0HkJMtuu6hGOVbkJ+buh+
pOc/PZRY7ND1+IrV+jcKcFP3JwNn9DBis1PXJzxrdFMKcksPICNn9XDisEs3
IAJrdTMKcVsPJBPn9IjgbwG7dUMisk43pzB39CAyc17/STz26F+JxHrdgiLc
De4z33JB/0V89upGfM0G3ZKi3NOD+Y6LeiQJ2KcbE5mNuhXFuK+H8D2X9CgS
sl83IQqbdGuK80AP5Qcu69Ek4oD+LXi22KzbUIKHehhZuKLHkJiDuinR2KLb
UpJHejg/clWPJQn/6GbB88dW3Y5SPNYj+IlrehxJOaSbB88+23R7SvNE/0lW
ruvxJOOwbkEMtusOlOGp/ots3NATSM4R3TL4fWGH7khZnumRZOemnkgK/tXB
P4pY7NSdKMdzPYoc3NKTSMlR3Tr4vWOX7kx5XujR5OS2nkwqjuk2xGG37kIF
Xuox5OKOnkJqjuu2xGWP7kpFXumx5OaunkoaTuh2xGOv7kYlXutx5OGenkZa
Tur2xGef7k5l3ujx5OW+nk46TukOJGC/7kEV3uoJ5OOBnkF6TuuOJOSA7klV
3umJ5OehnkkG/tOdSMRB3YtqvNeTKMAjPYuMnNGdScw/ujfV+aAnU5DHejaZ
OKu7kIRDug81+KinUIgneg6ZOae7kpTDui81+aSnUpinem7wXPmn+z+/LgMD

             "]]},
           Annotation[#, "Charting`Private`Tag$1211211#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwN0ulPyHEcwPFfhxKj0LNcUbk2/4lS8iAU2qJsSsjm3DpWU47YKtrcozTN
WWyuthyZcxq5FiK2hM3ZEno9eO39/Xy+z777xmcXpOWHBEHQSlxoEHRzmu2s
JoN59HGZGjaSw0Rec4ZK8lnEN9o5QDHJfOIKtWxiBZN4w1mqKGAx37nBQUpI
oZ+r1LGZvzygkZX8poOjlBMSFgSP9RSTecs5dhDu7omuYZC7HCfK/oUu4Qc3
GWt3SCO0Sydoqf7nEePMTTpaX2msztfPXGOMeZ+O0Kc6XrfoPx4SYz6po/Sl
5jLAHY4x0v65VhDq3KnNTKGH8+ykkD/c4wSZ/OQWhykjlS9cZz9byWMq77jA
LtaSRRrxvKeF3axjKQuYxnQSSCSJGcz1l2bqLHpppZr1LCOd2XzgInsoYjkL
+Uob9WxjFXP4yCX2soEh7tNANr+4TbR3OqKR+kyHATx8ZlY=
             "]], 
            LineBox[{645, 768, 721, 683, 598, 752, 705, 667, 639, 619, 556, 
             744, 697, 659, 631, 611, 599, 557, 558, 559, 560, 561, 562, 563, 
             564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574, 575, 576, 
             577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 745, 698, 
             660, 632, 612, 600, 753, 706, 668, 640, 620, 761, 714, 676, 648, 
             771, 724, 686, 780, 733, 789, 588}]},
           Annotation[#, "Charting`Private`Tag$1211211#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{793, 843, 794, 795, 796, 797, 798, 799, 800, 801, 802, 
             803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814, 815, 
             816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 826, 827, 828, 
             829, 830, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 
             844, 842}]},
           Annotation[#, "Charting`Private`Tag$1211211#3"]& ], 
          {Hue[0.67, 0.6, 0.6], Opacity[0.2], 
           LineBox[{791, 792, 790}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxE2nc8le3/AHD7HA1lZGUdK7NUUjQ+n5YiDSqlRIWIQhGlZVNRaCghSRJF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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[
            PolygonBox[{{1366, 1365, 664, 1177, 1047, 934, 837, 755, 712, 
             1217, 1087, 974, 877, 795, 665, 1178, 1048, 935, 838, 1263, 1133,
              1020, 756, 1251, 1121, 1297, 1008, 1282, 1152}}]]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwV0mlvjFEYxvFnTFvR2roNKiQ+BLpbP4FEvLEFbW2xRZBICJHQVqvW2nef
wU7RxfoVbC8U7bRUNVSE3/3in+u+/meeM8+cM7PWbF2yZUySJCn0olFZlpsk
S9Fu7sEQFqeT5BYyOUlyFme4Mn0z3qCW60A3/x2LuJso5dpxmpumb8Jr1HCP
0cV/w0LuBkpib5zipuob8QrV3CN08oNYwF1HceyNk9xYuQej4awdlDl+x4i5
SDboXzBFn6EfMefLlNyBYWyw9hJV5od4Zt9WfRCr9Y8Y4Obr12LfeFec4DL6
erxAJfcAT/ks5nFXURjviuNcG56gH7XWrmBy7IVjXAf6UMNfxqR4Dq1cqd6A
56jg7sd58i36AFbpH/CV+xP3FO+NavMlTDS3ocV6ntyN3/FbrB2Qaefy01xv
/owS82E5jk9kqdwuf6DeWpm+z5zInnhXWa7fi3vzHTP1RnOBTMuM3ClHcNTn
p+v7zSmZjXOQK/X3cWeePyTzuNH4D5mzqDLvlX9x0Twhzi328/lcuQu/4ryt
DaPO3Iti8z9sMw+hztyNuea7ce+eb9b7sUJ/F2fAVeoXMD7uAM1ckb4OXZjD
3Yl755v0PizX38b3chX6eRTEuaOJK9TXohOzudtxl/wnlHPnkB+/Cf8BMgF6
lg==
              "]], PolygonBox[CompressedData["
1:eJwV00VwVmcUBuBLIDhsWOASLLizx92CF2kZ2MAmgVLcfYYNsIEZWiguIbi0
xaHF3YMEt4ENMANBC89ZPPm+953z55+ce5M2PKt3ZkqSJAUY6Uf/1CTJKpQk
bxlWMEnKy9Pcv3NMbubcw24fWiZ/ZJT8mpbuC3jJT/JdHpsrJf/CUZrGZ9ml
byHP5wUDdXd4pC8p/8wRmsQsO/XN5Xk8Z4DuNg/1JeShHKZxzLJD30yeyzP6
63J5oC8uD+EQjWKW7fqm8hye0k93i/v6YvJgDtIwZtmmbyLP5gl9dTfJ0xeV
B3GABjHLVn1jeRaP6aO7wT19kdgX+6kfs+ToG8kzeURv3fXYqb5w7It/qBez
bNE3lGfwkAzdtdipPjX2xd/UjVmy9Q3k6Tygl+5q7FRfKPbFX9SJWTbr68vT
uE9P3ZXYqb5g7It9pMcsm/T15Knk0UN3OXaqT4l9sZfaMctGfV15CvforrsU
O9UXiH2xh1oxywZ9HXkyd+mmuxg7jZc59sVuasYs6/Xp8iTu0FV3IXaq/06G
bhc1YpZ1utryRG7TRXc+dqpfIr9jhPyM/3XznEX8r3zTl3Fmym/oJZeTp8Zc
vJtyabl6fAdrfbaqvNC9pLOos6xzkvMLS+OddKbq8t1Hur+ilnuKcyzvmSDn
0tn9XDxLv3ex/Jbh8lO+6XrKO0iL72aNrqY8nlt00p2NZ6v/Sg/ddqrFLKt1
NeRx3KSj7kw8W/0Xuuu2UTVmWaWrLv/GDTroTsez1X+mm24rVWKWP3Vp8liu
0153Kp6t/hNddTlUjllW6qrJv3KNdrqT8Wz1H+mi20KlmGVF7Fsew1Xa6k7E
s9Xn01mXTcWY5Q9dFXk0V2ij+y92rP9AJ91mKsQsv+sqy1lcprXu39ip/j0d
dZsoH7Ms11WSM7lEK93x2Gn8HzrHkc+i+Bu8Az8AXNPFKg==
              
              "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwl1nf8jmUYhvEfysreZRMhMkpWdlYyQ5GSLbKaZO+RPUrZZWVWNIxCNi2R
EbIzisoshb7Xxx+H8zrO++F93+d57vsjb5vujbslSkhIGJk4ISHyD390xqv8
X/68PMgHyvd5bbmJ95ZN4lp5Wj5n7RHzCnMVtDMflWf0zcy7zW3wML+XTzEX
wDe8Ef8m/g2M4FX4WvOTuMxpwp/mLvjP/AHqKDfzpniel+YfmavibHwX3Keb
ygvi2/iNSIK/+Eu4aZ6HVvH3kd31b+sfwHd8FO7CJd4Vt8zz8QIexd24rI8b
eNu8AK1RBkmRDMmRAldc0z1uMBaKNiiLHD7zHV0hfM9HIyWu8h5IhEW8bXym
az/m1XCOl0NO3TReGD/wxvzbuCfxG81n5Fv6quZ15jdkPdlRnpBD5BXrzeVe
3k+2j8+Wv8l7rF2TPZEYrfQ/yw/1T5i3mJvF847fzT8xV8d5Xh65dO/yItjN
xyAVrvOXkQSLeXtUQGqkwd/6V3AXlvAOeAxp8U+8n7gbS3lHVERun/We7kH8
yMciHW7w15AUy3inuPeuXckfx2+8EvLopvOi2MPHoZruS14fV3l6/Gt+Hcmw
nNd1zVbz03gxngtfZa6B33ll5NXN4MWwl49HBvwXzwTJsYJ3jvcfGXFT1wsp
8BHvEs8RmXAr9iBS4mP+UnxX5PM5M3UP4Sc+AZlxm78ZzxOf8K6ojvyun6Ur
jn18IrIk3Nl0fXSpsJJ2w+O4Xz9bVwL7+SRkjdda31eXGqt4d9RAAf0cXUkc
4JORLf55fT9dGnzKe6AmCurn6krhIJ8S50XsW31/XVp8xnuiFh6IcynOFfzM
p8a+j32rH6BLh8/5y/E+6j7lNXGB10Yh3Qf8ERziT/Hv4j3H23GP+FfmBuhk
Pimv6VuYfzL3lx1if8jf4/yS2eNskAPjvZPp5QvykBwkv7D+pNwWz0Q+E2eb
/DXe+dgH5s/MtXCR10Fh3TxeGof5O/E8dOt5Q1yPsyTOHd0gngGreT2+3dw8
9kzsIf65uTb+iD2MIrr5/FEc4U349/GdMS2eI99gboS/+bN8X5whyBnnHB9s
zojW5sNyjb6+eYe5RdyH2KPx28110N58TP6pf9r8o7ktupnPybr6B80LYq/J
MrEuf5GDI603lT/wPrK17CrPymFx5sT7JDfGHpKNY2/KU3Ko/Md6S7mfD5Cd
4jySF2Qua8nNQ8yZ0MZ8RK7VNzDvND8b3yvODb7a/AT+iueKorqFvCyO8vfi
bEIK/VBdZqzjb8TziXMnzofYu7EfkdJ1w1yTBV/yXnEvY+/hHmvD9VnxFe8d
3yn2GVJZG6HPhvX8TTSMPYXU1kbq78UG3geNUEy/SFcOx/j02FNIox+luw8b
eV80xkP6D3XlcZzPiD2EtPrRuuz4mveLvYTi+sW6CjjBZ8a7jHT6t3Q5sIn3
j/cOJfRLdI/hJJ8V7yfS68fE+4bNfEA8f5TUL9VVxCk+O94bZNCPjWeJLXEf
+C5zSwzklfmaeM/QwXxcXtI/Y95j7ivbye7yvBwum1kvJZfxSjjN58TzRkb9
OF1ubOWD4r2O+4tM1sbr82AbHxyfE/cSma1N0OfFdj4EzeO+IYu1ifp82MGH
xrkT9whZrU3S58dOPiz2ZdwPZLM2WX8/dvHh8a7jYf1yXWX8yueilu5r/hRu
8Of4gdgrcRaZLya683/DUtb+BxjNJ8M=
             "]]},
           Annotation[#, "Charting`Private`Tag$1211414#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwl1nf4TnUYx/Hn54coKqUkmyaZhRQKWS2lbFlFyUoSSSlpELL33nvv7F0U
2XvPKKOiIXrdV3+8r/v+vL/nOc95vvc553pyNWpVtWVSIpEYkiKR6IruKROJ
mzE4OZF4HKe4b7GQK4q13OvIgG58D+4WDJFL4DR3SK6Lc3EMlnKL5GJYJ7+B
O/A135NLh6HyEzjDHZZfw/k4Bsu4xXJxrJcb47L+HdzQ3xnfq2+M3/V98af+
faRCd5//Rk2PYdb+VT/Ek/pf1Gb4W586VSLRRX/W8UfUerid+8VaktpJzqJ2
l6/o38PdcnLsgdpVza4u9/kl+sdxm7zB8Qn1Y/letYn8m7417pITalr1SzVj
7IHaBH/ok/lP9f30f6ntkBo9fEcv9VYMt1YSv+qb4x/9z9aP6uvjV7kHVsQs
5RLYKL+Ju9CT7x3XihFyKZzjVsa+oU/sA0bypXGeWxXfH59DX2sZMMraU7Gn
3Gos5Z7Ad9xbuBt9+H7cHRgtPx3XzR2TG+BCXA/WcMtiRvheborf9e8iKe5R
+/KVmk3NZO2s/s04r3xFTql2lvvr/1bb4yb0dd7+6p0YY60MLnBrsZwriU3c
27gH/fgBMReMlcviIrcOK7hS2Mw1Q2b05wfGXDFOLodL3PrYT640fuCa414M
4AfFfYTx8jNxb3Mb4jyo5ncMUgdbz4QJ1svH/cNtjDlwT+FHrgWyYDA/hLsH
E+UK8Rv1LXAt9tH6cX3DmJvzX+RSqJ/I1dWs+Ia7KrdFyphhzFR9GlustUTW
5P/fG0O5zJgkV8Qf3PdYw5XBVq4VsmEoPyyeA0yWK8WzxG2KGXBl8RP3DrJj
GD88njtMkSvHdXGbYwZcOWzjWiMHhvMjuKyYKj8b7wLuh5gB9wy2c+8iJ0bw
I+M+wjT5uXjOuB9jBlx57ODaIBdG8qPiOcd0+fm4v7gtMQ+uAnZy7yE3RvGj
uRyYIb+Af7it+I6riF1cW+TBaH4MlxMz5Rdxjfsp9pSrhN3c+7gPY/ixXC7M
kqvE+407ITfCJbkXtsUey5WxR24Xc9K3QQrcH+8M9S1c1adyD3ymHxDXq34Q
9x+XRk2ndovfpI513nH63PEukmc7/rq+Y9x/8kvxvOhbxjMn/yvfpH4uX/fZ
k+rruMz3xvaYrfws9srt8QDG8eO5PJgjv4wb3I6YLfcc9nEf4EGM5ydw92Gu
XDXewdgZs+Wex365Ax7CBH5i7APmya8gCbtittwLOCB/iIcxkZ/EPYD58qvx
DGF3zJZ7EQfljsiLSfxk7kEskKshGXtitlwVHJI/Qj5M5qdwD2GhXD3eadjL
b+NewmH5YzyCKfxU7mEskmvEDLGP3869jCNyJ+THVH4alxeL5ZpIjf2xp1xV
HJU/QQFM46dz+bBErhVzxAF+J/cKjsmfoiCm8zO4R/CtXBtpcJDfxb2K43Jn
FMIMfiaXH0vlOkiLQ/xurhpOyJ+hMGbys7gCWCbXxc04zO+J9xhOyl1QBLP4
2VxBLJdfwy04wu/lauCU/DkexWx+DlcIK+R6SIej/D6uJk7LX+AxzOHncoWx
Uq6P9DjG7+dq4Yz8JYrinNwUf+oHYq7j5slFsCrubfWjeK96VhrIl/StkFG+
HnupfhHPnP6U+gZ+0/fBcec6INfGWfkrFMM8fj73KFbLDXEbToTHgvifF//V
4v9WZMc9hjWOaYTbcZI/yNXBz3JXFMd5+W38pR+Ea/oOSIv0rvXreKepS3z+
P64bZ9M=
             "]]},
           Annotation[#, "Charting`Private`Tag$1211414#2"]& ], 
          TagBox[
           {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
            Dashing[{Small, Small}], 
            LineBox[{1313, 1363, 1314, 1315, 1316, 1317, 1318, 1319, 1320, 
             1321, 1322, 1323, 1324, 1325, 1326, 1327, 1328, 1329, 1330, 1331,
              1332, 1333, 1334, 1335, 1336, 1337, 1338, 1339, 1340, 1341, 
             1342, 1343, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352,
              1353, 1354, 1355, 1356, 1357, 1358, 1359, 1360, 1361, 1364, 
             1362}]},
           Annotation[#, "Charting`Private`Tag$1211414#3"]& ]}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 14.999999693877552`}, {-1, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{4}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.716727092354904*^9, 3.716727113068643*^9}, {
   3.716727144844589*^9, 3.716727174700303*^9}, 3.716736277392425*^9, 
   3.716736415432905*^9, 3.716736543387568*^9, 3.716738316487472*^9, 
   3.7167383560316*^9, 3.7167384104184437`*^9, 3.716738468730589*^9, 
   3.716738516685821*^9, {3.7167385896338367`*^9, 3.716738649690236*^9}, {
   3.716738724448832*^9, 3.716738759351584*^9}, 3.7167388062508583`*^9, 
   3.716738941956616*^9, {3.7167389859758*^9, 3.716739022729508*^9}, {
   3.71673907797547*^9, 3.7167390929620523`*^9}, {3.7167392831067553`*^9, 
   3.7167393314339867`*^9}, 3.716739363461955*^9, 3.716739571425946*^9, 
   3.716739664980091*^9, 3.7171785554594173`*^9, {3.7171799890325317`*^9, 
   3.717180016677939*^9}, {3.719219559394701*^9, 3.7192195655161343`*^9}, {
   3.7192196510590353`*^9, 3.719219657173204*^9}, {3.719219706887891*^9, 
   3.7192197995231743`*^9}, {3.719219866999611*^9, 3.719219877932971*^9}, {
   3.71921996188056*^9, 3.7192199719009047`*^9}, {3.759439231993437*^9, 
   3.759439238848637*^9}, 3.7594394703569736`*^9, 3.793503101057959*^9, 
   3.7939085493765497`*^9, 3.823229253096253*^9},
 CellLabel->
  "Out[2877]=",ExpressionUUID->"b10611e5-cfc4-4577-9f38-899007de278d"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"8656cdca-d40a-412a-b04a-e6272521e665"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dt", "=", "0.05"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Through", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "\[Theta]0", ",", "u0", ",", "\[Theta]1", ",", "\[Theta]2", ",", 
          "u2"}], "}"}], "[", "t", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Tau]1", ",", "dt"}], "}"}]}], "]"}], "//",
     "N"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<pendulumPert.dat\>\"", ",", " ", "dat"}], "]"}]}], " ", 
   "\[IndentingNewLine]", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.7167394002782793`*^9, 3.7167394007756653`*^9}, {
  3.716739480630252*^9, 3.716739620038939*^9}, {3.793503090269162*^9, 
  3.793503097345668*^9}, {3.793908534545573*^9, 3.7939085437625713`*^9}},
 CellLabel->
  "In[2878]:=",ExpressionUUID->"c8960ba3-09c6-4bb6-826b-0e5b38360370"]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 79}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"2d0bee6f-5d53-48c8-bf0b-cb9dc7e2d394"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 758, 12, 105, "Section",ExpressionUUID->"c2f1811f-5d39-4870-bd7a-071084aa3a3d"],
Cell[1341, 36, 9726, 252, 656, "Input",ExpressionUUID->"6e42687c-bd84-429b-9901-9da7fec5d545"],
Cell[11070, 290, 433, 9, 52, "Text",ExpressionUUID->"291c1013-9723-4bbf-bdf6-0ec48ff3a54f"],
Cell[11506, 301, 3092, 83, 199, "Input",ExpressionUUID->"03e0d4f6-e531-4b5f-ab2e-1a3e95fe7d1f"],
Cell[14601, 386, 459, 9, 52, "Text",ExpressionUUID->"cef80cf4-d7d3-4045-a5b9-b38502d93e2f"],
Cell[15063, 397, 6113, 147, 383, "Input",ExpressionUUID->"9feaa965-6c5e-433b-9cc7-a1ba3b998866"],
Cell[CellGroupData[{
Cell[21201, 548, 357, 9, 30, "Input",ExpressionUUID->"8d2f4767-77dd-4e07-af88-03d0096681b6"],
Cell[21561, 559, 68824, 1181, 137, "Output",ExpressionUUID->"b10611e5-cfc4-4577-9f38-899007de278d"]
}, Open  ]],
Cell[90400, 1743, 394, 7, 52, "Text",ExpressionUUID->"8656cdca-d40a-412a-b04a-e6272521e665"],
Cell[90797, 1752, 1173, 30, 191, "Input",ExpressionUUID->"c8960ba3-09c6-4bb6-826b-0e5b38360370"]
}, Open  ]]
}
]
*)

