(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     63296,       1156]
NotebookOptionsPosition[     61964,       1125]
NotebookOutlinePosition[     62361,       1141]
CellTagsIndexPosition[     62318,       1138]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Time-dependent optimal control, Example 7.3", "Section",
 CellChangeTimes->{{3.51389296222151*^9, 3.5138929763455257`*^9}, {
  3.717328102704728*^9, 3.717328106287125*^9}, {3.7934155082946157`*^9, 
  3.7934155199520197`*^9}, {3.793415862871744*^9, 3.7934158701214848`*^9}, {
  3.793416463750485*^9, 
  3.793416469509811*^9}},ExpressionUUID->"2cd498d2-6874-4421-b6cc-\
73e7d6c4c2c1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[2860]:=",ExpressionUUID->"93423cd8-7d85-40c5-8adb-946a584b91b1"],

Cell["Solve the Riccati equation:", "Text",
 CellChangeTimes->{{3.793416478792966*^9, 3.793416506742683*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"e73a58b1-1dbe-4396-ac3c-6c42809576a6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Ssol1", "=", 
   RowBox[{"NDSolveValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"s", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", 
          RowBox[{"s", "[", "t", "]"}]}], "+", 
         SuperscriptBox[
          RowBox[{"s", "[", "t", "]"}], "2"]}]}], ",", 
       RowBox[{
        RowBox[{"s", "[", "3", "]"}], "\[Equal]", "0"}]}], "}"}], ",", "s", 
     ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "3", ",", "0"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Ssol2", "=", 
  RowBox[{
   RowBox[{"DSolveValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"s", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", 
          RowBox[{"s", "[", "t", "]"}]}], "+", 
         SuperscriptBox[
          RowBox[{"s", "[", "t", "]"}], "2"]}]}], ",", 
       RowBox[{
        RowBox[{"s", "[", "3", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"s", "[", "t", "]"}], ",", "t"}], "]"}], "//", 
   "FullSimplify"}]}]}], "Input",
 CellChangeTimes->{{3.793416098138132*^9, 3.79341617491604*^9}, {
   3.7934162125871058`*^9, 3.7934162195598173`*^9}, 3.793416285155623*^9, {
   3.793416542552033*^9, 3.793416554612673*^9}},
 CellLabel->
  "In[2861]:=",ExpressionUUID->"cb6a9caa-c62c-49fb-9e48-2029dfdb685c"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "-", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Coth", "[", 
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "t"}], ")"}]}], "]"}]}]}]]], "Output",
 CellChangeTimes->{{3.793416558169936*^9, 3.793416566183079*^9}, 
   3.793908573088032*^9, 3.823229239739354*^9},
 CellLabel->
  "Out[2862]=",ExpressionUUID->"82570719-a062-4523-8d22-9ebf5817279f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Ssol2", ",", " ", 
     RowBox[{
      SuperscriptBox["10", "6"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Ssol1", "[", "t", "]"}], "-", "Ssol2"}], ")"}]}], ",", 
     RowBox[{
      SqrtBox["2"], "-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{",", ",", 
      RowBox[{"{", 
       RowBox[{"Thin", ",", "Black"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.79341623173263*^9, 3.793416251945972*^9}, {
  3.793416297982039*^9, 3.793416429302943*^9}, {3.7934167059193153`*^9, 
  3.793416732555792*^9}},
 CellLabel->
  "In[2863]:=",ExpressionUUID->"6bb56ac2-8abd-4e6f-a17f-ee8b1c1f054b"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Xk01OsbAPAp8e1KmJIlmkSG2yQttml73lDakMpSStnGkpiUfW1RiZEl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       "]]},
     Annotation[#, "Charting`Private`Tag$1210864#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwc3Hc8ld8fAHBJQiWJkiIrWUlIEj43kVH23nvvvbn25tp7hoySRClbFBIS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       "]]},
     Annotation[#, "Charting`Private`Tag$1210864#2"]& ], 
    TagBox[
     {GrayLevel[0], Thickness[Tiny], Opacity[1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/cM7b25AfoGdyfs/MyubbtnnLyg76a82zx7GP9jT
s9tXbR2cz8pWxP4yaz+c71mf2Lo17Dicv70y9e7Si+fg/JtR2fpF5ZfhfEH3
3rSDDtfhfIErqZvMo2/D+coKOStbk+7D+RZ3c087TnqIcM+vBp8rsx/D+Rn7
T5zY1/QUzp+ZvFxKNOE5nK8b8fDbv9SXcP69z/7nHDxfw/mf7ksaiIW+hfMn
rK5KDw9/D+er8XP4Vsz+AOdvK2hY3Tf/I5x/RXUye+CkT3C+SvNljdiZn+F8
y4D7JvNnf4Hz7xa02vX2fIXzN1lG8h6d+A3OFws7fnNF63c43/4Rw8RDJT8Q
/hPL4FWr+AnnN83LbDfN+gXnzz0341hfwW84vzZv8gfZoj9w/utEDYnIpL9w
fvffVyz30v7B+bveuL/ni/oP519TtXhkpcLgAA9vzWT9yUsR/INh0dWOcoxw
vnHEq5UiCxH8nGa367bSTHB+RxrHL8bJCP5e2cT/r0SY4fyd/9qYtfoQ/HOb
nV/1CrLA+UcV0o71TELwW7aHLnzIxQrnxyjdiYvuRfB/b9OX1mZng/NrmF+e
mVqH4IupWCaqMrDD+eV5YV+4KhF8kWT+stY9CP7G8BPf//9H8AER27pY
       "]]},
     Annotation[#, "Charting`Private`Tag$1210864#3"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.79341624551234*^9, 3.7934162524070787`*^9}, {
   3.793416307271697*^9, 3.7934164298305407`*^9}, 3.793416533415709*^9, 
   3.793416566270385*^9, {3.793416714373041*^9, 3.7934167329889793`*^9}, 
   3.793908573192725*^9, 3.823229239837933*^9},
 CellLabel->
  "Out[2863]=",ExpressionUUID->"bd007952-b9be-452f-a9bb-3e8ac3c1ac04"]
}, Open  ]],

Cell[TextData[{
 "The numerical and analytic solutions agree!  Note, too, that although the \
solution \[OpenCurlyDoubleQuote]asymptotes\[CloseCurlyDoubleQuote] to ",
 Cell[BoxData[
  RowBox[{
   SqrtBox["2"], "-", "1"}]],
  CellChangeTimes->{{3.79341623173263*^9, 3.793416251945972*^9}, {
   3.793416297982039*^9, 3.793416429302943*^9}, {3.7934167059193153`*^9, 
   3.793416732555792*^9}},ExpressionUUID->
  "2ccd8a45-fd30-4041-8b40-8841cfca33fa"],
 ", it has not quite reached this value at a time 3 before the end."
}], "Text",
 CellChangeTimes->{{3.793416478792966*^9, 3.793416527291799*^9}, {
  3.793416738743355*^9, 3.79341677922642*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"3addd91a-8b9f-47f5-afc1-b99220de0fa0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Ssol2", "/.", 
     RowBox[{"t", "\[Rule]", "0"}]}], ",", 
    RowBox[{
     SqrtBox["2"], "-", "1"}]}], "}"}], " ", "//", "N"}]], "Input",
 CellChangeTimes->{{3.793416795860978*^9, 3.793416820309545*^9}},
 CellLabel->
  "In[2864]:=",ExpressionUUID->"ed7d334d-ff31-4e32-90c1-4b1dc6440e8c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.41411336245673913`", ",", "0.41421356237309515`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.793416798777586*^9, 3.793416820527267*^9}, 
   3.793908573199215*^9, 3.823229239846114*^9},
 CellLabel->
  "Out[2864]=",ExpressionUUID->"a7cab5aa-dc9b-4338-978b-bfe2213e8fe0"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 652},
WindowMargins->{{Automatic, 136}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"ee5fc7e8-b646-44c2-a7f4-2b1b07365cc9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 388, 6, 67, "Section",ExpressionUUID->"2cd498d2-6874-4421-b6cc-73e7d6c4c2c1"],
Cell[970, 30, 175, 4, 30, "Input",ExpressionUUID->"93423cd8-7d85-40c5-8adb-946a584b91b1"],
Cell[1148, 36, 197, 3, 51, "Text",ExpressionUUID->"e73a58b1-1dbe-4396-ac3c-6c42809576a6"],
Cell[CellGroupData[{
Cell[1370, 43, 1519, 45, 56, "Input",ExpressionUUID->"cb6a9caa-c62c-49fb-9e48-2029dfdb685c"],
Cell[2892, 90, 461, 14, 57, "Output",ExpressionUUID->"82570719-a062-4523-8d22-9ebf5817279f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3390, 109, 806, 23, 66, "Input",ExpressionUUID->"6bb56ac2-8abd-4e6f-a17f-ee8b1c1f054b"],
Cell[4199, 134, 56296, 946, 234, "Output",ExpressionUUID->"bd007952-b9be-452f-a9bb-3e8ac3c1ac04"]
}, Open  ]],
Cell[60510, 1083, 732, 15, 75, "Text",ExpressionUUID->"3addd91a-8b9f-47f5-afc1-b99220de0fa0"],
Cell[CellGroupData[{
Cell[61267, 1102, 354, 10, 38, "Input",ExpressionUUID->"ed7d334d-ff31-4e32-90c1-4b1dc6440e8c"],
Cell[61624, 1114, 312, 7, 57, "Output",ExpressionUUID->"a7cab5aa-dc9b-4338-978b-bfe2213e8fe0"]
}, Open  ]]
}, Open  ]]
}
]
*)

