(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    381667,       6993]
NotebookOptionsPosition[    377649,       6930]
NotebookOutlinePosition[    378046,       6946]
CellTagsIndexPosition[    378003,       6943]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Pendulum swing-up, event triggered; 
horizontal forcing; observe full state  (Example 7.12)\
\>", "Section",
 CellChangeTimes->{{3.698811497715045*^9, 3.698811509022469*^9}, {
   3.69885144307857*^9, 3.698851462312389*^9}, {3.709636905485622*^9, 
   3.709636910921179*^9}, {3.715342867107555*^9, 3.715342872342836*^9}, {
   3.7153432690028687`*^9, 3.715343287448956*^9}, {3.715431319533587*^9, 
   3.7154313280357513`*^9}, {3.7154890610058317`*^9, 3.7154890724184837`*^9}, 
   3.715516976782558*^9, {3.716793956608181*^9, 3.716793961182888*^9}, {
   3.793502662176474*^9, 
   3.7935026654535513`*^9}},ExpressionUUID->"60b09a07-4679-4cd9-9875-\
aece6d4e38a2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tff", "=", "3"}], ";", " ", 
  RowBox[{"tff1", "=", 
   RowBox[{"tff", "+", "2"}]}], ";", " ", 
  RowBox[{"tend", "=", "10"}], ";", " ", 
  RowBox[{"clip", "=", "100"}], ";"}]}], "Input",
 CellChangeTimes->{{3.715406158547789*^9, 3.715406175566045*^9}, {
   3.71540843722126*^9, 3.715408438621107*^9}, {3.715409943475955*^9, 
   3.71540994465714*^9}, 3.715409989843553*^9, {3.715415894548387*^9, 
   3.715415909408836*^9}, {3.7154172382682753`*^9, 3.715417301572735*^9}, 
   3.715417800524371*^9, {3.71541926281385*^9, 3.7154192630835114`*^9}, 
   3.715419349702868*^9, {3.715420492165409*^9, 3.715420514259961*^9}, 
   3.7154210952309628`*^9, {3.7154211326358223`*^9, 3.715421132835579*^9}, 
   3.7154212462375813`*^9, 3.715421758878799*^9, {3.715421929133116*^9, 
   3.7154219295316153`*^9}, {3.715422121675604*^9, 3.715422122113842*^9}, 
   3.7154231731172743`*^9, {3.715423211723938*^9, 3.7154232119620533`*^9}, 
   3.715424678949617*^9, {3.715426576617014*^9, 3.71542661827649*^9}, 
   3.7154293353602877`*^9, {3.715429578712113*^9, 3.71542960422958*^9}, {
   3.715430112092979*^9, 3.715430166612854*^9}, {3.7154303026095543`*^9, 
   3.71543033371656*^9}, 3.715442891394354*^9, {3.715443018323834*^9, 
   3.715443018626274*^9}, {3.715443104907838*^9, 3.715443108826543*^9}, 
   3.715443352167818*^9, {3.715443399752399*^9, 3.71544341163592*^9}, {
   3.715443600729*^9, 3.7154436253700237`*^9}, {3.715443750993537*^9, 
   3.715443763957262*^9}, 3.715443797177553*^9, {3.7154438386995287`*^9, 
   3.715443859372739*^9}, {3.7154446984988413`*^9, 3.715444701441489*^9}, {
   3.715445927977106*^9, 3.715445928128879*^9}, 3.715445970071061*^9, {
   3.715446223423128*^9, 3.7154462235706882`*^9}, {3.7154462549439907`*^9, 
   3.715446260023777*^9}, {3.715446360974742*^9, 3.7154463613143387`*^9}, {
   3.7154464155617857`*^9, 3.715446447176072*^9}, {3.715446486995096*^9, 
   3.715446487095846*^9}, 3.715446631553604*^9, {3.715447414486355*^9, 
   3.71544741458856*^9}, {3.715447461292494*^9, 3.715447461330633*^9}, {
   3.715447500798365*^9, 3.7154475170297823`*^9}, 3.715448414480301*^9, 
   3.715448653700943*^9, {3.715448787327384*^9, 3.7154487896708403`*^9}, {
   3.715448996081805*^9, 3.715448996513276*^9}, 3.7154900523635693`*^9, {
   3.715490140772846*^9, 3.715490151796681*^9}, {3.715491203255636*^9, 
   3.715491203468788*^9}, 3.715491289903615*^9, {3.7154918255315638`*^9, 
   3.715491873202526*^9}, 3.7154991468624783`*^9, {3.715502048047628*^9, 
   3.715502051396757*^9}, {3.715502100422069*^9, 3.71550210567625*^9}, {
   3.715502462794042*^9, 3.715502472121476*^9}, {3.715502755499515*^9, 
   3.715502761290895*^9}, {3.71551547914124*^9, 3.715515483331171*^9}, {
   3.71551620356702*^9, 3.715516246166274*^9}, 3.71551628158996*^9, {
   3.715517285360319*^9, 3.715517286062148*^9}, {3.715517481101202*^9, 
   3.71551751010923*^9}, 3.715534508619999*^9, 3.715534631059514*^9, {
   3.71553467024957*^9, 3.715534681027006*^9}, {3.715536531754458*^9, 
   3.7155365423764677`*^9}, {3.715536798924958*^9, 3.7155368124991503`*^9}, {
   3.715537037836912*^9, 3.715537038276505*^9}, 3.7155883881794977`*^9, {
   3.7155922323346243`*^9, 3.715592237742083*^9}, 3.715592303584075*^9, 
   3.715592539753024*^9, {3.715592615965454*^9, 3.715592616045033*^9}, 
   3.7155926530931463`*^9, {3.715596463420767*^9, 3.715596483090469*^9}, 
   3.715596543118292*^9, {3.7155968703558493`*^9, 3.715596881825965*^9}, {
   3.7156002028599043`*^9, 3.715600226603374*^9}, {3.7156003196282787`*^9, 
   3.715600320323851*^9}, 3.715602340199395*^9, 3.715787666285557*^9, 
   3.71578796364832*^9, 3.7157880380165586`*^9, {3.715788106596697*^9, 
   3.7157881192186813`*^9}, {3.715788253692687*^9, 3.715788253835689*^9}, {
   3.715788376833469*^9, 3.715788402492198*^9}, {3.7157884628813257`*^9, 
   3.715788464103034*^9}, 3.715788908032853*^9, 3.715788976632848*^9, 
   3.7157890558460073`*^9, {3.715789087017023*^9, 3.715789087119049*^9}, {
   3.715789200340605*^9, 3.715789227705172*^9}, {3.7157894373020983`*^9, 
   3.715789464578651*^9}, {3.715789497497781*^9, 3.715789521263372*^9}, 
   3.715789563579904*^9, {3.715789600403964*^9, 3.7157896008995333`*^9}, 
   3.7157934082835283`*^9, {3.7157934624844913`*^9, 3.715793479820012*^9}, {
   3.7157944755663633`*^9, 3.715794476178911*^9}, {3.715794508115266*^9, 
   3.715794531975974*^9}, {3.715794637041751*^9, 3.715794656311337*^9}, {
   3.715794721766762*^9, 3.71579472423024*^9}, {3.715794817494688*^9, 
   3.715794839870083*^9}, {3.716792742298078*^9, 3.7167927429305897`*^9}},
 CellLabel->
  "In[2907]:=",ExpressionUUID->"3413512a-057a-4181-97cf-e9214504c8ed"],

Cell["\<\
Calculate feedforward swing-up for 0 < t < \[Tau] and balance for \[Tau] < t \
< \[Tau]1,  based on nominal model; \
\>", "Text",
 CellChangeTimes->{{3.644509136027421*^9, 3.644509201738372*^9}, 
   3.644509766090928*^9, {3.714237280802227*^9, 3.7142373247256536`*^9}, {
   3.714326070104105*^9, 3.7143261090526667`*^9}, {3.715181320555006*^9, 
   3.715181324473104*^9}, {3.7153433317700977`*^9, 3.715343341080782*^9}, {
   3.715403051966159*^9, 3.715403053002616*^9}, {3.715405333515641*^9, 
   3.7154053735139523`*^9}, {3.715405416124236*^9, 3.715405424644391*^9}, {
   3.7154094087709923`*^9, 3.715409421306808*^9}, {3.715416705601328*^9, 
   3.715416750530801*^9}, 3.7154217240762587`*^9, {3.715422616682157*^9, 
   3.715422617066246*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"fa7774ec-e0dd-4507-bceb-9a6b63479623"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SwingupCalc0", "[", 
    RowBox[{"tff_", ",", "t0_", ",", "x0_", ",", "xdot0_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "eq", ",", "bcs", ",", "x1", ",", "x2", ",", "\[Lambda]1", ",", 
       "\[Lambda]2", ",", "x1s", ",", "x2s", ",", "\[Lambda]1s", ",", 
       "\[Lambda]2s", ",", "us", ",", "Es", ",", "\[Theta]dots", ",", "t1", 
       ",", "t"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"t1", "=", 
       RowBox[{"t0", "+", "tff"}]}], ";", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "final", " ", "time", " ", "for", " ", "feedforward", " ", 
        "integration"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"eq", "=", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{"x2", "[", "t", "]"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Sin", "[", 
             RowBox[{"x1", "[", "t", "]"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"\[Lambda]2", "[", "t", "]"}], 
            SuperscriptBox[
             RowBox[{"Cos", "[", 
              RowBox[{"x1", "[", "t", "]"}], "]"}], "2"]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Lambda]1", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"x1", "[", "t", "]"}], "]"}], 
           RowBox[{"\[Lambda]2", "[", "t", "]"}], 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{"Sin", "[", 
               RowBox[{"x1", "[", "t", "]"}], "]"}], 
              RowBox[{"\[Lambda]2", "[", "t", "]"}]}]}], ")"}]}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Lambda]2", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{"-", 
           RowBox[{"\[Lambda]1", "[", "t", "]"}]}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"bcs", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"x1", "[", "t0", "]"}], "\[Equal]", "x0"}], ",", 
         RowBox[{
          RowBox[{"x2", "[", "t0", "]"}], "\[Equal]", "xdot0"}], ",", 
         RowBox[{
          RowBox[{"x1", "[", "t1", "]"}], "\[Equal]", "\[Pi]"}], ",", 
         RowBox[{
          RowBox[{"x2", "[", "t1", "]"}], "\[Equal]", "0"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1s", ",", "x2s", ",", "\[Lambda]1s", ",", "\[Lambda]2s"}], 
        "}"}], "=", 
       RowBox[{"NDSolveValue", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"eq", ",", "bcs"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x1", ",", "x2", ",", "\[Lambda]1", ",", "\[Lambda]2"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "t0", ",", "t1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"us", "=", 
       RowBox[{"FunctionInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"\[Lambda]2s", "[", "t", "]"}]}], 
          RowBox[{"Cos", "[", 
           RowBox[{"x1s", "[", "t", "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "t0", ",", "t1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Es", "=", 
       RowBox[{"FunctionInterpolation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           FractionBox["1", "2"], 
           SuperscriptBox[
            RowBox[{"x2s", "[", "t", "]"}], "2"]}], "+", "1", "-", 
          RowBox[{"Cos", "[", 
           RowBox[{"x1s", "[", "t", "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "t0", ",", "t1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"x1s", ",", "x2s", ",", "us", ",", "Es"}], "}"}]}]}], "  ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"Return", " ", "\[Theta]"}], ",", " ", 
      OverscriptBox["\[Theta]", "."], ",", " ", "u", ",", " ", "E"}], " ", 
     "*)"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SwingupCalc", "[", 
   RowBox[{
   "tff_", ",", "t0_", ",", "tend_", ",", "x0_", ",", "xdot0_", ",", 
    "\[Theta]old_", ",", "\[Theta]dotold_", ",", "uold_", ",", "Eold_"}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Theta]ff0", ",", "\[Theta]dotff0", ",", "uff0", ",", "Eff0", ",", 
      "\[Theta]ff", ",", "\[Theta]dotff", ",", "uff", ",", "Eff", ",", "t1"}],
      "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"t1", "=", 
      RowBox[{"t0", "+", "tff"}]}], ";", "  ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "final", " ", "time", " ", "for", " ", "feedforward", " ", 
       "integration"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\[Theta]ff0", ",", "\[Theta]dotff0", ",", "uff0", ",", "Eff0"}], 
       "}"}], "=", 
      RowBox[{"SwingupCalc0", "[", 
       RowBox[{"tff", ",", "t0", ",", "x0", ",", "xdot0"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Theta]ff", "[", "t_", "]"}], ":=", 
      RowBox[{"Piecewise", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Theta]old", "[", "t", "]"}], ",", 
            RowBox[{"t", "<", "t0"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Theta]ff0", "[", "t", "]"}], ",", 
            RowBox[{"t0", "\[LessEqual]", "t", "<", "t1"}]}], "}"}]}], "}"}], 
        ",", "\[Pi]"}], "]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"extend", " ", "ff", " ", "to", " ", "balance"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Theta]dotff", "[", "t_", "]"}], ":=", 
      RowBox[{"Piecewise", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Theta]dotold", "[", "t", "]"}], ",", 
           RowBox[{"t", "<", "t0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Theta]dotff0", "[", "t", "]"}], ",", 
           RowBox[{"t0", "<", "t", "<", "t1"}]}], "}"}]}], "}"}], "]"}]}], 
     ";", " ", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"uff", "[", "t_", "]"}], ":=", 
      RowBox[{"Piecewise", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"uold", "[", "t", "]"}], ",", 
           RowBox[{"t", "<", "t0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"uff0", "[", "t", "]"}], ",", 
           RowBox[{"t0", "\[LessEqual]", "t", "<", "t1"}]}], "}"}]}], "}"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Eff", "[", "t_", "]"}], ":=", 
      RowBox[{"Piecewise", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Eold", "[", "t", "]"}], ",", 
            RowBox[{"t", "<", "t0"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Eff0", "[", "t", "]"}], ",", 
            RowBox[{"t0", "\[LessEqual]", "t", "<", "t1"}]}], "}"}]}], "}"}], 
        ",", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\[Theta]ff", ",", "\[Theta]dotff", ",", "uff", ",", "Eff"}], 
      "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.715403097492919*^9, 3.7154032546975822`*^9}, 
   3.715404497698846*^9, {3.7154045455375147`*^9, 3.715404571894266*^9}, {
   3.7154047023449497`*^9, 3.71540476411584*^9}, {3.715405458598667*^9, 
   3.7154055177654123`*^9}, {3.715405561032172*^9, 3.715405572278759*^9}, {
   3.715405602959152*^9, 3.71540564390028*^9}, {3.715405829625499*^9, 
   3.715405853849559*^9}, {3.715405912636992*^9, 3.7154059350319433`*^9}, {
   3.715405988579615*^9, 3.715406022208359*^9}, {3.715406067637855*^9, 
   3.7154060855813627`*^9}, {3.715406180381226*^9, 3.71540619078692*^9}, {
   3.7154068880462646`*^9, 3.7154068888987722`*^9}, {3.715408942842237*^9, 
   3.715409075177989*^9}, {3.715409657620895*^9, 3.715409699242692*^9}, {
   3.71540999388354*^9, 3.7154099941626587`*^9}, {3.71541011942309*^9, 
   3.715410124469306*^9}, 3.715410171423666*^9, {3.715418124497086*^9, 
   3.715418173824822*^9}, {3.715419484391259*^9, 3.715419550465959*^9}, {
   3.715420190886202*^9, 3.715420335136791*^9}, {3.715420368626495*^9, 
   3.71542037620964*^9}, {3.715420460032181*^9, 3.715420479701907*^9}, {
   3.7154209111996613`*^9, 3.7154209189690104`*^9}, {3.715420987217272*^9, 
   3.7154210223025923`*^9}, {3.715421740610075*^9, 3.715421769983019*^9}, {
   3.715422620652648*^9, 3.71542264689213*^9}, {3.715422687133594*^9, 
   3.715422717619708*^9}, 3.715424024383325*^9, {3.715432001551733*^9, 
   3.715432015325877*^9}, {3.715442772874483*^9, 3.715442788169415*^9}, 
   3.715442836351082*^9, {3.715450465692828*^9, 3.715450489243083*^9}, {
   3.715453777974785*^9, 3.715453850218891*^9}, {3.715490468384716*^9, 
   3.7154904741331043`*^9}, {3.715490741207777*^9, 3.715490774900343*^9}, {
   3.715493179857154*^9, 3.715493186045617*^9}, {3.7154932313240423`*^9, 
   3.7154932867467318`*^9}, {3.715495653141203*^9, 3.715495655100268*^9}, 
   3.715505165388174*^9, 3.715505240137094*^9, {3.715505298207872*^9, 
   3.715505304350357*^9}, {3.715516133068623*^9, 3.7155161437908983`*^9}, {
   3.715535672007607*^9, 3.715535677471319*^9}, {3.71553641431061*^9, 
   3.7155364145150957`*^9}, 3.715536862590907*^9, {3.715536901716363*^9, 
   3.7155369046025257`*^9}, {3.7155369404988728`*^9, 3.715536970354594*^9}, 
   3.7155370052149343`*^9, 3.7155371330925417`*^9, {3.715597498962448*^9, 
   3.71559750384065*^9}, {3.7155975338877277`*^9, 3.7155975990057573`*^9}, {
   3.715597675605389*^9, 3.715597676083837*^9}, {3.7155977244066677`*^9, 
   3.7155977606942368`*^9}, 3.71559780760874*^9, {3.7155978412582483`*^9, 
   3.715597938400322*^9}, {3.7155980800447083`*^9, 3.715598108770071*^9}, {
   3.715598154843671*^9, 3.7155982023051863`*^9}, 3.715598259347087*^9, {
   3.715600009712563*^9, 3.715600011992344*^9}, {3.7156000469747868`*^9, 
   3.7156000784836884`*^9}, {3.715600240570168*^9, 3.715600288839736*^9}, {
   3.7156003831520357`*^9, 3.7156003863655663`*^9}, {3.715600443901298*^9, 
   3.715600471565959*^9}, {3.7156005463734837`*^9, 3.71560054796364*^9}, {
   3.715600981621254*^9, 3.715600982076654*^9}, {3.7156011769200974`*^9, 
   3.715601205512813*^9}, {3.715601269403844*^9, 3.715601277982389*^9}, {
   3.715747207364183*^9, 3.715747211429002*^9}, {3.71574748818921*^9, 
   3.7157475468448067`*^9}, {3.715747580463192*^9, 3.7157476202432537`*^9}, {
   3.7157477011088943`*^9, 3.715747711713871*^9}, {3.715753721015471*^9, 
   3.7157537230502043`*^9}, {3.715753791088578*^9, 3.715753812648028*^9}, {
   3.715753998165443*^9, 3.7157540119927073`*^9}, 3.715754982648149*^9, {
   3.715755358458127*^9, 3.7157553586042223`*^9}, {3.716792632465383*^9, 
   3.716792657732327*^9}},
 CellLabel->
  "In[2909]:=",ExpressionUUID->"6e609bb9-6103-45b7-9599-6a78d6c71957"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Theta]old", "[", "t_", "]"}], ":=", "0"}], ";", " ", 
   RowBox[{
    RowBox[{"\[Theta]dotold", "[", "t_", "]"}], ":=", "0"}], ";", " ", 
   RowBox[{
    RowBox[{"uold", "[", "t_", "]"}], ":=", "0"}], ";", " ", 
   RowBox[{
    RowBox[{"Eold", "[", "t_", "]"}], ":=", "0"}], ";"}], " ", 
  RowBox[{"(*", " ", "initialize", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]ff", ",", "\[Theta]dotff", ",", "uff", ",", "Eff"}], 
    "}"}], "=", 
   RowBox[{"SwingupCalc", "[", 
    RowBox[{
    "tff", ",", "0", ",", "tend", ",", "0", ",", "0", ",", "\[Theta]old", ",",
      "\[Theta]dotold", ",", "uold", ",", "Eold"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pff1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]ff", "[", "t", "]"}], ",", 
       RowBox[{"Eff", "[", "t", "]"}], ",", "\[Pi]", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tff1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Blue", ",", "Dashed", ",", "Thin"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Orange", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], 
     ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pff2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"\[Theta]dotff", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tff1"}], "}"}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pff3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"uff", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tff1"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "Axis"}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pff1", ",", "pff2", ",", "pff3"}], "}"}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "2"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7154032654741898`*^9, 3.71540329605331*^9}, {
   3.7154033386571703`*^9, 3.7154034422078743`*^9}, {3.71540354812117*^9, 
   3.7154035501610394`*^9}, {3.715403779074885*^9, 3.715403793428789*^9}, {
   3.715403913391137*^9, 3.715403914260713*^9}, {3.715404260548197*^9, 
   3.7154043088206043`*^9}, {3.71540443529322*^9, 3.715404439034534*^9}, {
   3.715405218055787*^9, 3.71540521926193*^9}, {3.715405280050046*^9, 
   3.715405307369578*^9}, 3.7154055315005817`*^9, 3.715405651091745*^9, {
   3.715406094894169*^9, 3.715406098293552*^9}, 3.715406155533924*^9, 
   3.7154062461204767`*^9, 3.715406894501525*^9, {3.715409002262582*^9, 
   3.715409006474676*^9}, {3.715409085959116*^9, 3.715409092799171*^9}, {
   3.7154091594657927`*^9, 3.715409223535796*^9}, {3.7154092574676247`*^9, 
   3.715409257824802*^9}, 3.7154093154537487`*^9, {3.715409482453671*^9, 
   3.71540958549034*^9}, {3.7154101335364113`*^9, 3.715410133869876*^9}, {
   3.715416807521604*^9, 3.7154168133900347`*^9}, {3.715416955604548*^9, 
   3.715417114807713*^9}, {3.715417216472106*^9, 3.7154172329630127`*^9}, {
   3.715420498070921*^9, 3.715420499078401*^9}, {3.715422934750373*^9, 
   3.715423044840274*^9}, {3.715424072739019*^9, 3.715424083545331*^9}, {
   3.715446421643828*^9, 3.715446460017893*^9}, {3.71545050416352*^9, 
   3.715450542523975*^9}, 3.715450702826703*^9, {3.715453860610903*^9, 
   3.715453882796441*^9}, {3.7154906517145557`*^9, 3.71549065218559*^9}, {
   3.715490839304447*^9, 3.715490869758931*^9}, {3.71549329218673*^9, 
   3.715493292616385*^9}, {3.7154933725995493`*^9, 3.715493411232626*^9}, {
   3.71553470817945*^9, 3.715534711993335*^9}, {3.715535468355618*^9, 
   3.715535471483387*^9}, {3.715535681902048*^9, 3.715535746164405*^9}, {
   3.715536417218508*^9, 3.715536439593422*^9}, {3.715592326705991*^9, 
   3.715592355953691*^9}, {3.715596554111174*^9, 3.715596570384902*^9}, {
   3.7155966111402817`*^9, 3.71559664358469*^9}, {3.715596699484886*^9, 
   3.7155967817988453`*^9}, {3.715597967879739*^9, 3.715597983006157*^9}, {
   3.715598026780319*^9, 3.715598027755056*^9}, {3.715598321550703*^9, 
   3.715598394782523*^9}, {3.715600301845685*^9, 3.715600340959388*^9}, {
   3.715747410814004*^9, 3.7157474580764427`*^9}, {3.715747652261579*^9, 
   3.71574768437995*^9}, {3.7157740908663063`*^9, 3.715774094823812*^9}, {
   3.716792749834811*^9, 3.716792750155065*^9}},
 CellLabel->
  "In[2911]:=",ExpressionUUID->"b9d7de3f-9cd5-4fc2-bd4a-2773d16006a6"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1Hk0VesbB/CDc87epwEhV8qQMkXoNiE8TySRhOiq60YydkqGipAmiRI5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           "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQHSkv9dqZmcNBQtcl5Lcip0OFo9+7NgkEX++LueNk
LwT/6TLFKfNrEPw96bI+Oi8R/Ckakiw7Qznh/Amz0o4nKnDB+VFTYs/xPEfw
f7gs/Tl/Hzec//ipU8Whdh44f5GtofTZRF44f21rqWC6Lh+c3x6a7M38FcE3
vbNwZftZfjh/hubstWe9BeD8+gO9M7x3Ivi+0qFLT6kIwvmOecejBTsR/Pky
SSpnviL4KoeXT/OLFkL4T/eQ1qV9CH7aZ5aLJ7WE4fykjZ8UOvsR/AmXeHqP
HEfw931W+/n/P4IPADo1jDo=
           "]]},
         Annotation[#, "Charting`Private`Tag$1213128#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV13k4VN8bAPB7Z2KSSiEpZYlsSbZvIfUe/CglyZaKFmsKWZISJS2UfZct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           "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQHSkv9dqZmcOBAQIc5lmmijzmQPBPXZl8k5kHwVfk
/pjsKoTgVzj6vWuTQPD1vpg7TvZC8J8uU5wyvwbB35Mu66PzEsGfoiHJsjOU
E86fMCvteKICF5wfNSX2HM9zBP+Hy9Kf8/dxw/mPnzpVHGrngfMX2RpKn03k
hfPXtpYKpuvywfntocnezF8RfNM7C1e2n+WH82dozl571lsAzq8/0DvDeyeC
7ysduvSUiiCc75h3PFqwE8GfL5OkcuYrgq9yePk0v2ghhP90D2ld2ofgp31m
uXhSSxjOT9r4SaGzH8GfcImn98hxBH/fZ7Wf//8j+ACP+WLO
           "]]},
         Annotation[#, "Charting`Private`Tag$1213128#2"]& ], 
        TagBox[
         {RGBColor[0, 0, 1], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQPbcuic0wpdpOQtcl5LcipwP77Ufqb+VX2sP4C0/N
L3wtvxPOX7e+83aO3ik4P93+4sw3RZfh/Lynmo+3rLsJ53Mptqjft3gA5/cJ
nNZamPAYzk+6HbKf+cwzOL/waEtSvvorOH9jAU+whOdbhHuqs18ZhH+A85vm
/wn88uYjnM9w+YHDnqrPcL5aSVpFiNZXOP/J1+lh3Hu/wfleT7NqJxX+gPP9
nkzQlpP7Bee/OpzUcGLtbzhfT/CarHP8X4T/7L8m3vn8D853fxv1XSmUwQHG
v3EohTFKhxHO39pxJE7hK4Kfxlr64Nw5Jjg/uah6K88sZjhfP137nE8iC5x/
XkiHu9SSFc7fva5ptg4zG5xfzagVcOYugs91p8ojbws7nP90meKU+TUccP4U
DUmWnaGccP6EWWnHExW44PyoKbHneJ4j+D9clv6cv48bzn/81KniUDsPnL/I
1lD6bCIvnL+2tVQwXZcPzm8PTfZm/orgm95ZuLL9LD+cP0Nz9tqz3gJwfv2B
3hneOxF8X+nQpadUBOF8x7zj0YKdCP58mSSVM18RfJXDy6f5RQsh/Kd7SOvS
PgQ/7TPLxZNawnB+0sZPCp39CP6ESzy9R44j+Ps+q/38/x/BBwCcVDH7
           "]]},
         Annotation[#, "Charting`Private`Tag$1213128#3"]& ], 
        TagBox[
         {RGBColor[1, 0.5, 0], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQPbcuic0wpdqOAQIc2G8/Un8rv9Iexl94an7ha/md
cP669Z23c/ROwfnp9hdnvim6DOfnPdV8vGXdTTifS7FF/b7FAzi/T+C01sKE
x3B+0u2Q/cxnnsH5hUdbkvLVX8H5Gwt4giU83yLcU539yiD8A5zfNP9P4Jc3
H+F8hssPHPZUfYbz1UrSKkK0vsL5T75OD+Pe+w3O93qaVTup8Aec7/dkgrac
3C84/9XhpIYTa3/D+XqC12Sd4/8i/Gf/NfHO539wvvvbqO9KoUB3QPk3DqUw
RukwwvlbO47EKXxF8NNYSx+cO8cE5ycXVW/lmcUM5+una5/zSWSB888L6XCX
WrLC+bvXNc3WYWaD86sZtQLO3EXwue5UeeRtYYfzny5TnDK/hgPOn6IhybIz
lBPOnzAr7XiiAhecHzUl9hzPcwT/h8vSn/P3ccP5j586VRxq54HzF9kaSp9N
5IXz17aWCqbr8sH57aHJ3sxfEXzTOwtXtp/lh/NnaM5ee9ZbAM6vP9A7w3sn
gu8rHbr0lIognO+YdzxasBPBny+TpHLmK4Kvcnj5NL9oIYT/dA9pXdqH4Kd9
Zrl4UksYzk/a+Emhsx/Bn3CJp/fIcQR/32e1n///I/gAOdzJhA==
           "]]},
         Annotation[#, "Charting`Private`Tag$1213128#4"]& ], {}}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVlXk4Vtv7xs1vcpKQ1DE3KMkQKlH3llJChkSnE4p+hkSUBlGJIiQqMqYM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           "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCwAmIQHSkv9dqZmcOBAQrmWaaKPOZA8E9dmXyTmQfB/5Z/
aJ4KP4KvyP0x2VUIwa9w9HvXJoHgL7lTs3m5NIJ/vnx1xQk5BF9tHQczlyqC
f1nqsHivIYKv98XccbIXgv90meKU+TUI/puWhz+ZGxD8T0kL4zOaEXwGeUVt
wy4EX2q6wqFD0xH8gHb5D083Ifh70mV9dF4i+FM0JFl2hnLC+RNmpR1PVOCC
86OmxJ7jeY7g/3BZ+nP+Pm44//FTp4pD7Txw/iJbQ+mzibxw/trWUsF0XT44
vz002Zv5K4Jvemfhyvaz/HD+DM3Za896C8D59Qd6Z3jvRPB9pUOXnlIRhPMd
845HC3Yi+PNlklTOfEXwVQ4vn+YXLYTwn+4hrUv7EPy0zywXT2oJw/lJGz8p
dPYj+DlNwX+8JiL4pcFbrvNMRvA7vpb2TZiG4K+z/Pl7+lwE/+fB/9eWrUbw
J1zi6T1yHMGftTg3o+0kgr+45Jyzx2kEf5vYhF+nzyH4d6KEMy5fRfDVH0s6
P3qM4BtsqZJb8hTBt2q9/TP1OYLvoz53w8tXCH5RtoLcx48Ifo1N489NnxH8
Vt5HV0q+Ivgz1i/u/vEDwV/UwJK+6xeCvzow1anmD4K/RemYrN0/BH/fZ7Wf
//8j+ABR8sd+
           "]]},
         Annotation[#, "Charting`Private`Tag$1213177#1"]& ], {}}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmXk4lNHf/4cxM0KFFKksZctWSrbkc4gk2kSpVCJKi6WSrZQSUqKytSC0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        "], {{
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV0TlPlGEUBtCBCmQTYaRRE7EAEi1IDMRiWDT+AMBRa4OKFGw2bGKhJBBw
jQlgjAzG2CAoWGipgp1igxRaiAkU/gAQpOHc4uR57v2WeWfm+JXO5o7sRCKR
xXM+KO9p1Qtp0rfkHL00k6LVPoeP+hhXKYrrdttynj5a6LIr5as+QV3cb87l
kz7OHb2C3/q1+Cz9CKv6NAfjXeZ/8g39DJnL+alfoFtP8k2fZEQ/yYZeH+/V
D/BZfyRruKfflZWs69fj3PpRfsR7ZIpMnFNWM8tfc0aeZ5HiOIPckS/kW/lA
nuY1A+bb8gSv+GWeknVxL2lzjzzMS1bMT+QZpvRReYpN/ZlspCHOK/NY0h/L
Wu7rw7KKP3pb/F76Mdb0GQ6RNu/KBQa5yE27Mr7rT2mM5835LMd34gYlcb/d
f7nILS5xNq7bF/BFf0g7pXHdbk++i/+Oy5wjyT795UzA
             "]]]}, 
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{440, 442, 155, 430, 314, 405, 208, 280, 372, 90, 
              220, 292, 384, 128, 181, 253, 345, 30, 107, 145, 198, 270, 362, 
              68, 89, 127, 180, 252, 344, 29, 28, 27, 26, 25, 24, 23, 22}}], 
             PolygonBox[CompressedData["
1:eJwt0jlPVFEYBuARWcSlUCulgUILLTRBEYEEE0gEWVxqQRlqZ9yABgoBVxJD
AmiiLIW4IjFWKKDWaKU2UEChhSRugPwAni9SPPO+3zkz9945uQXJ9JlURiKR
2MD0er71McEd/QM5ejNl+mnaeMkqp6xvk83c5j3Z1pKUxj6tjPGPk9a3yi1s
JpeSWKeFF6xQ73ubZJJbvCPLWhNHY5+rPGeZOus5slKOsBjXkgfpYdhcJu/z
Vc+TbXE9fYG9eic3188hUz9Psf6d/bHHPf0TO/U0dfocBXoHV/RCeZdn+hK1
erasiOfgRzy3PBBnzJD5VZxXXJ8v5sdyN63xHObXspwHzJufyj1c44Z5XB6m
lynzI7mRcxwxH5MP+abvi98woBfLPj7qO2SKWn2WfL2dy3E//lJjzpKDfGaX
uSXuo19nkgxzI0V6PzNsN1+gRr/EE/5wwlqmbKQ73r14B601xP+JfS7GefCb
6vhfsoEu3iT+v7RnORT7pBnlF1XW4/0ujE4qzoafHLe3BskuVYU=
              
              "]]}]}, {}, {}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
            1.], LineBox[CompressedData["
1:eJwV03nQVmMcBuCvVTtatDciadFgWrQnZRRt0qLGUknEVChCZa1oUWlBe2nf
FUaKyNJMkTWGKAqDKUu2oppx3X9c333/nue85z3nvN+pPWhEz+GFCgoKxviT
vMqfI3IZw+lEYwqn2zsqlzOCzjThhnyQreJxbqRI9q39IldwF1fTNPv5Ll7V
x3MTRbNv7Ve5kru5hmHWzma3PptmOd5cmG36BG7mXnNVPtYXUCyfN/8mV3EP
Y83n8oXeJfenl2ePPks2Z44+UTbgsD5fXs5l+R5ZhGVsN8+QTdnARPOj8gJW
ccA8T7ZjMwPM98lqrOAT8zOyFZtYaJ4sL2YNP5oXyQ4Uz/XK3+VqpumNGamP
k7X5Uu+a30WvwHs5P0/oDflOb84AvSivZY/H9Loc1AcyWq/Op/qzsjWL9Cny
Etbyk3mx7MgZ+V55TK5hFN1okfNZL8br+pMMokT2rf0h1+Z3ozstKUkpSlMm
6477U67Ls6MHrXKePBN26JO4hbLZt/aXXJ/74FpaZz/XyRt5xryiD5blcoz+
t9zA/fSkDYOtl+DN3Du3cmb2rf0jN/IA1+V/21pF3s8zo22ON5dkpz4174V+
Id/oQ/Jdeg325VlyVs5lPi438SAPmc9jv94r74Reib36c3mm+kV8r7fLefVS
vKU/LZvxVN4xWY9v9dty3XpNPst5ZBuW5DrlpazjZ/MSeSVb8g7mGuQJ+bx8
QU6XTVjPGPPD8nxW8pV5rmybY+mdd1Cew3I+yPssWzA3v6NsxA95f2X7vHe5
Xlmat/WZeQ+Zpk+Q9Tmk357npdfic30p5elt/lduZix9GGmtMh/m/aR9Pm8u
wzu5J4ZSIcdb+09uyXtGX67IvvWyvKvP4A4qZt/aSflifjuupwOV2Jp7l5Wp
QlWqUZ0a1MzxjjklX8qzpB8dc37r5diV35U7qZV9a6flyzwS5jp8rfdnlF6F
j/Q5siUbmW/+H83xrGk=
             "]], 
            LineBox[{302, 424, 230, 413, 322, 69, 363, 271, 199, 146, 108, 31,
              346, 254, 182, 129, 91, 70, 32, 33, 34, 35, 36, 37, 38, 39, 40, 
             41, 42, 43, 44, 45, 46, 47, 48, 49, 347, 255, 183, 130, 92, 71, 
             364, 272, 200, 147, 109, 379, 287, 215, 162, 397, 306, 234, 417, 
             326, 435, 50}]},
           Annotation[#, "Charting`Private`Tag$1213223#1"]& ], 
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], 
           LineBox[{437, 438, 436}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{2}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.7155923327355556`*^9, 3.715592359315136*^9}, 
   3.715592408063903*^9, 3.715592542535316*^9, 3.7155926192647057`*^9, 
   3.715592656158531*^9, 3.715596356443706*^9, 3.7155964671007566`*^9, 
   3.7155964972801323`*^9, {3.715596546183404*^9, 3.7155965834860077`*^9}, {
   3.715596614051445*^9, 3.715596646217915*^9}, {3.715596705652734*^9, 
   3.7155967829564133`*^9}, {3.715596847270459*^9, 3.715596884530699*^9}, 
   3.715597257854344*^9, {3.7155973125100727`*^9, 3.7155973332656927`*^9}, 
   3.7155973903533173`*^9, 3.7155980026225443`*^9, 3.715598033186541*^9, 
   3.7155981295804043`*^9, 3.7155982067593737`*^9, 3.715598262157608*^9, 
   3.715598324334697*^9, {3.715598358407539*^9, 3.715598395434812*^9}, 
   3.715599415392838*^9, 3.715600350234614*^9, 3.715600460575417*^9, 
   3.715600552222497*^9, 3.7156007695886803`*^9, {3.715600802851837*^9, 
   3.715600822791832*^9}, 3.715600883255598*^9, 3.715601210456231*^9, {
   3.715601281182852*^9, 3.715601291254884*^9}, {3.715601483427197*^9, 
   3.7156015079799757`*^9}, 3.7156015520443497`*^9, 3.715601663090399*^9, 
   3.715602296284087*^9, 3.715602342748115*^9, 3.7157051640063334`*^9, 
   3.715747115058242*^9, 3.715747155916904*^9, 3.715747216809038*^9, 
   3.715747461565351*^9, {3.715747533443674*^9, 3.715747554831307*^9}, 
   3.7157477308733273`*^9, 3.715753735618565*^9, {3.7157538181408*^9, 
   3.715753825721203*^9}, 3.715754016654475*^9, 3.715755286517456*^9, 
   3.7157553631413813`*^9, 3.715755542919251*^9, 3.715774054180089*^9, 
   3.715774098233717*^9, 3.715774142885*^9, 3.715774209151733*^9, 
   3.7157742668316927`*^9, 3.7157743028977757`*^9, 3.715775749826054*^9, 
   3.715776048596924*^9, 3.715776291704445*^9, 3.715776330850305*^9, 
   3.715776408974732*^9, {3.7157764972970667`*^9, 3.7157765200321903`*^9}, 
   3.7157765516585627`*^9, 3.715776583266375*^9, 3.715786870670833*^9, 
   3.715787069917246*^9, 3.715787134502898*^9, 3.715787308313905*^9, {
   3.7157876201932507`*^9, 3.715787672870772*^9}, 3.7157878061804523`*^9, 
   3.715787966865213*^9, {3.715788015156501*^9, 3.715788041444934*^9}, {
   3.715788110298469*^9, 3.71578812498135*^9}, 3.715788257282028*^9, 
   3.7157882934359503`*^9, {3.715788381833712*^9, 3.715788407708467*^9}, {
   3.7157884684410543`*^9, 3.715788514126388*^9}, 3.715788583884224*^9, 
   3.715788619119979*^9, 3.715788690647928*^9, {3.715788754830267*^9, 
   3.715788772325157*^9}, 3.715788844514637*^9, {3.715788912063423*^9, 
   3.71578893827245*^9}, 3.7157889814206657`*^9, 3.715789058517877*^9, 
   3.715789090323113*^9, {3.7157892034418077`*^9, 3.715789233403748*^9}, {
   3.7157894408661213`*^9, 3.7157894680523853`*^9}, {3.71578950626573*^9, 
   3.715789524390197*^9}, 3.715789566785799*^9, 3.715789603731373*^9, 
   3.7157896562414303`*^9, 3.7157897928449993`*^9, {3.71578984028473*^9, 
   3.7157898581672564`*^9}, 3.7157932898761597`*^9, 3.7157933734127407`*^9, 
   3.715793411155961*^9, {3.715793467174005*^9, 3.715793482768105*^9}, 
   3.7157935325594053`*^9, 3.715793611551775*^9, 3.715793786636508*^9, 
   3.715794480779204*^9, {3.715794519175226*^9, 3.715794535411248*^9}, {
   3.715794641390082*^9, 3.71579465972644*^9}, {3.7157947281852503`*^9, 
   3.715794843076919*^9}, {3.7157948802120457`*^9, 3.715794908228272*^9}, 
   3.7157949943603153`*^9, {3.715966342372004*^9, 3.715966370027046*^9}, {
   3.716531789714727*^9, 3.716531812280101*^9}, 3.716532038608162*^9, 
   3.716533793669847*^9, 3.716533850422455*^9, 3.7167927795017033`*^9, 
   3.716793980594551*^9, {3.719212061189584*^9, 3.719212071055196*^9}, 
   3.7316920920776167`*^9, 3.759449452126051*^9, 3.759449492492454*^9, {
   3.793502690910962*^9, 3.7935027204160547`*^9}, 3.793908435857044*^9, 
   3.823229295911435*^9},
 CellLabel->
  "Out[2916]=",ExpressionUUID->"4f1ca8b8-d22f-4dd1-933c-4b670d80cbee"]
}, Open  ]],

Cell["Feedforward & linear feedback, combined", "Text",
 CellChangeTimes->{{3.644509136027421*^9, 3.644509201738372*^9}, 
   3.644509766090928*^9, {3.714237280802227*^9, 3.7142373247256536`*^9}, {
   3.714326070104105*^9, 3.7143261090526667`*^9}, {3.715181320555006*^9, 
   3.715181324473104*^9}, {3.7153433317700977`*^9, 3.715343341080782*^9}, {
   3.715403051966159*^9, 3.715403053002616*^9}, {3.7154081029771976`*^9, 
   3.715408117255252*^9}, {3.7154891124836693`*^9, 3.71548911476182*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"d64cc3d7-7d88-45fb-a632-9366c463e19b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", "1"}
     }], "\[NoBreak]", ")"}]}], ";", "   ", 
  RowBox[{"r", "=", 
   RowBox[{"{", 
    RowBox[{"{", "1", "}"}], "}"}]}], ";", 
  RowBox[{
   RowBox[{"OptimalFeedbackGain", "[", 
    RowBox[{"x1_", ",", "u1_", ",", "q_", ",", "r_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "sys"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "1"},
          {
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Cos", "[", "x1", "]"}]}], "-", 
            RowBox[{"u1", " ", 
             RowBox[{"Sin", "[", "x1", "]"}]}]}], "0"}
         }], "\[NoBreak]", ")"}]}], ";", " ", 
      RowBox[{"b", "=", 
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0"},
          {
           RowBox[{"Cos", "[", "x1", "]"}]}
         }], "\[NoBreak]", ")"}]}], ";", " ", 
      RowBox[{"c", "=", 
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "0"}
         }], "\[NoBreak]", ")"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sys", "=", 
       RowBox[{"StateSpaceModel", "[", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"LQRegulatorGains", "[", 
       RowBox[{"sys", ",", 
        RowBox[{"{", 
         RowBox[{"q", ",", "r"}], "}"}]}], "]"}]}]}], "  ", 
    RowBox[{"(*", " ", 
     RowBox[{"optimal", " ", "feedback", " ", "gains"}], " ", "*)"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7154254144950027`*^9, 3.715425450329002*^9}, {
   3.715425533000616*^9, 3.715425594824761*^9}, {3.715425681537672*^9, 
   3.715425778734705*^9}, {3.71542782112668*^9, 3.715427886507927*^9}, 
   3.7154279359281178`*^9, {3.7154280036995783`*^9, 3.715428012057412*^9}, {
   3.715429639925681*^9, 3.715429700535592*^9}, 3.7154301054370613`*^9, {
   3.7154301799899063`*^9, 3.7154301879812813`*^9}, {3.715445205420576*^9, 
   3.7154452221955338`*^9}, {3.715445785062737*^9, 3.715445787583098*^9}, 
   3.715491856486842*^9, {3.7157053388867273`*^9, 3.7157053534813023`*^9}, {
   3.715755441992457*^9, 3.7157554425987453`*^9}, {3.7167927600596237`*^9, 
   3.716792765049588*^9}},
 CellLabel->
  "In[2917]:=",ExpressionUUID->"7b052de1-9b9f-4dc9-a35d-03aa3cf02d55"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Kappa]", "=", 
  RowBox[{
   RowBox[{"OptimalFeedbackGain", "[", 
    RowBox[{"\[Pi]", ",", "0", ",", "q", ",", "r"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "sign", " ", "is", " ", "changed", " ", "because", " ", "of", " ", 
    RowBox[{"hor", ".", " ", "forcing"}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.715705522599049*^9, 3.715705551911356*^9}, {
  3.7157060805411673`*^9, 3.71570614852211*^9}, {3.715747151641507*^9, 
  3.715747152078985*^9}, {3.716792767801939*^9, 3.716792768745894*^9}, {
  3.7167940410064373`*^9, 3.716794054781838*^9}},
 CellLabel->
  "In[2918]:=",ExpressionUUID->"97dea820-dc82-4ba3-b551-7a877dfb00e7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["2"]}]]}], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["2"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7157055525609417`*^9, {3.715706081729095*^9, 3.715706149573473*^9}, 
   3.715747115247651*^9, {3.7157471530185337`*^9, 3.715747156133647*^9}, 
   3.7157472170986853`*^9, 3.715747461694098*^9, {3.715747533572165*^9, 
   3.71574755495885*^9}, 3.715747731010203*^9, 3.715753735826467*^9, {
   3.7157538182752943`*^9, 3.715753825888797*^9}, 3.715754016827985*^9, 
   3.715755286698701*^9, 3.715755446639904*^9, 3.715755543091341*^9, 
   3.7157740543816338`*^9, 3.7157740983832073`*^9, 3.7157741430546513`*^9, 
   3.715774209348344*^9, 3.7157742670072317`*^9, 3.71577430308002*^9, 
   3.715775749990056*^9, 3.715776048754249*^9, 3.7157762918598127`*^9, 
   3.715776331032971*^9, 3.715776409145813*^9, {3.715776497475996*^9, 
   3.715776520213573*^9}, 3.715776551835079*^9, 3.71577658344057*^9, 
   3.71578687083947*^9, 3.715787070076421*^9, 3.715787134636012*^9, 
   3.7157873084965754`*^9, {3.7157876203638783`*^9, 3.715787673109391*^9}, 
   3.715787806344079*^9, 3.715787966999457*^9, {3.715788015299416*^9, 
   3.7157880415896063`*^9}, {3.7157881104768753`*^9, 3.7157881285924263`*^9}, 
   3.715788257567753*^9, 3.715788293610263*^9, {3.715788381968772*^9, 
   3.715788407898005*^9}, {3.71578846872052*^9, 3.715788514313222*^9}, 
   3.715788584075856*^9, 3.715788619297608*^9, 3.715788690842985*^9, {
   3.7157887550214987`*^9, 3.715788772489675*^9}, 3.715788844683519*^9, {
   3.715788912289394*^9, 3.715788938474538*^9}, 3.715788981691378*^9, 
   3.715789058710609*^9, 3.71578909049454*^9, {3.715789203959386*^9, 
   3.715789233714229*^9}, {3.715789441149774*^9, 3.7157894681844788`*^9}, {
   3.71578950652911*^9, 3.715789524570738*^9}, 3.715789566932454*^9, 
   3.715789604041527*^9, 3.715789656419407*^9, 3.715789793026957*^9, {
   3.715789840468503*^9, 3.715789858338376*^9}, 3.71579329002791*^9, 
   3.715793373593759*^9, 3.7157934114175673`*^9, {3.7157934674228907`*^9, 
   3.7157934829504967`*^9}, 3.715793532735971*^9, 3.715793611698367*^9, 
   3.7157937868121862`*^9, 3.7157944810522614`*^9, {3.715794519333785*^9, 
   3.715794535768701*^9}, {3.715794641642811*^9, 3.7157946599912653`*^9}, {
   3.715794728336687*^9, 3.7157947916093397`*^9}, {3.71579482169451*^9, 
   3.7157948432416983`*^9}, {3.715794880394821*^9, 3.7157949084155397`*^9}, 
   3.715794994499192*^9, {3.715966342659502*^9, 3.7159663701817217`*^9}, {
   3.71653178987878*^9, 3.716531812422741*^9}, 3.7165320387826347`*^9, 
   3.716533793829328*^9, 3.716533850554264*^9, 3.716792779623293*^9, 
   3.716793980844495*^9, {3.71921206136968*^9, 3.719212071141404*^9}, 
   3.731692092256165*^9, 3.759449452287953*^9, 3.7594494926941566`*^9, {
   3.793502690956252*^9, 3.793502720456251*^9}, 3.793908435890514*^9, 
   3.823229295943359*^9},
 CellLabel->
  "Out[2918]=",ExpressionUUID->"5f3a9ba5-9302-4a8d-8ec4-76bb1ae97c4f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"OptimalFeedbackGain", "[", 
      RowBox[{"\[Theta]", ",", "0", ",", "q", ",", "r"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "5"}], "}"}]}]}], "]"}], " ", "*)"}]], "Input",\

 CellChangeTimes->{{3.7157055677758512`*^9, 3.715705646194023*^9}, {
  3.715788134580727*^9, 3.715788138673937*^9}, {3.716792773082077*^9, 
  3.71679277332227*^9}},
 CellLabel->
  "In[2919]:=",ExpressionUUID->"497b2ae8-1685-4acd-b01c-db0d0149e461"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Controller", "[", 
   RowBox[{
   "\[Kappa]_", ",", "t0_", ",", "tend_", ",", "clip_", ",", "\[Theta]ff_", 
    ",", "\[Theta]dotff_", ",", "uff_", ",", "x0_", ",", "xdot0_", ",", "td_",
     ",", "d_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "eq", ",", "init", ",", "x1", ",", "x2", ",", "x1s", ",", "x2s", ",", 
      "us", ",", "Es", ",", "\[Kappa]1", ",", "\[Kappa]2", ",", "ufb", ",", 
      "u", ",", "t"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Kappa]1", "=", 
      RowBox[{"\[Kappa]", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
     RowBox[{"\[Kappa]2", "=", 
      RowBox[{"\[Kappa]", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ufb", "[", "t_", "]"}], ":=", 
      RowBox[{
       RowBox[{"\[Kappa]1", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
          RowBox[{"x1", "[", "t", "]"}]}], ")"}]}], "+", 
       RowBox[{"\[Kappa]2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
          RowBox[{"x2", "[", "t", "]"}]}], ")"}]}]}]}], ";", 
     RowBox[{
      RowBox[{"u", "[", "t_", "]"}], ":=", 
      RowBox[{"Clip", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"uff", "[", "t", "]"}], "+", 
         RowBox[{"ufb", "[", "t", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "clip"}], ",", "clip"}], "}"}]}], "]"}]}], ";", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"eq", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"x2", "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sin", "[", 
            RowBox[{"x1", "[", "t", "]"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"u", "[", "t", "]"}], 
           RowBox[{"Cos", "[", 
            RowBox[{"x1", "[", "t", "]"}], "]"}]}]}]}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"init", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"x1", "[", "0", "]"}], "\[Equal]", "x0"}], ",", 
        RowBox[{
         RowBox[{"x2", "[", "0", "]"}], "\[Equal]", "xdot0"}]}], "}"}]}], ";",
      "  ", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1s", ",", "x2s"}], "}"}], "=", 
      RowBox[{"NDSolveValue", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"eq", ",", "init", ",", " ", 
          RowBox[{"WhenEvent", "[", 
           RowBox[{
            RowBox[{"t", "\[Equal]", "td"}], ",", 
            RowBox[{
             RowBox[{"x2", "[", "t", "]"}], "\[Rule]", " ", 
             RowBox[{
              RowBox[{"x2", "[", "t", "]"}], "+", "d"}]}]}], "]"}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"x1", ",", "x2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "t0", ",", "tend"}], "}"}]}], "]"}]}], ";", " ", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"us", "[", "t_", "]"}], ":=", 
      RowBox[{"Clip", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"uff", "[", "t", "]"}], "+", 
         RowBox[{"\[Kappa]1", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
            RowBox[{"x1s", "[", "t", "]"}]}], ")"}]}], "+", 
         RowBox[{"\[Kappa]2", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
            RowBox[{"x2s", "[", "t", "]"}]}], ")"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "clip"}], ",", "clip"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Es", "[", "t_", "]"}], ":=", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], 
        SuperscriptBox[
         RowBox[{"x2s", "[", "t", "]"}], "2"]}], "+", "1", "-", 
       RowBox[{"Cos", "[", 
        RowBox[{"x1s", "[", "t", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"x1s", ",", "x2s", ",", "us", ",", "Es"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.715408125026971*^9, 3.71540812619878*^9}, {
   3.715408313999366*^9, 3.7154083843756332`*^9}, {3.715408414496892*^9, 
   3.715408421304978*^9}, {3.715408828532257*^9, 3.715408853514132*^9}, {
   3.715410194535137*^9, 3.715410276267551*^9}, {3.7154155920084553`*^9, 
   3.7154157917663383`*^9}, {3.7154159789005537`*^9, 3.715415995814804*^9}, {
   3.715417620380183*^9, 3.715417651604826*^9}, 3.715417686260311*^9, {
   3.7154177568873987`*^9, 3.7154177606855297`*^9}, {3.7154234200841837`*^9, 
   3.715423470007514*^9}, {3.715423566800828*^9, 3.715423582913973*^9}, {
   3.7154239877534037`*^9, 3.715424014154937*^9}, {3.7154243334067907`*^9, 
   3.715424401993849*^9}, {3.715424491471834*^9, 3.7154244990546*^9}, {
   3.715426646224544*^9, 3.715426656983152*^9}, {3.7154268793469048`*^9, 
   3.71542689282726*^9}, {3.715429356131858*^9, 3.715429370620407*^9}, {
   3.715429810322958*^9, 3.7154298116986513`*^9}, {3.715429856881*^9, 
   3.715429864751383*^9}, {3.715429913607733*^9, 3.715429999131081*^9}, {
   3.715430036558599*^9, 3.715430040709264*^9}, 3.7154443727067413`*^9, 
   3.71544441691308*^9, {3.715444765606553*^9, 3.715444820451685*^9}, {
   3.715444949248281*^9, 3.7154449527667828`*^9}, {3.71544545150313*^9, 
   3.7154454587425833`*^9}, 3.7154457788446417`*^9, {3.71544799170507*^9, 
   3.715448045132998*^9}, {3.715448279478948*^9, 3.7154483081493177`*^9}, {
   3.7154483571379433`*^9, 3.7154483747602043`*^9}, 3.715489152717387*^9, {
   3.7154891980794783`*^9, 3.715489353065384*^9}, {3.715489465134429*^9, 
   3.7154895047566137`*^9}, {3.715489603553973*^9, 3.715489657425516*^9}, {
   3.715489694479401*^9, 3.715489715247518*^9}, {3.715490286358159*^9, 
   3.715490323324194*^9}, {3.715491803285964*^9, 3.715491804133254*^9}, {
   3.715495160675928*^9, 3.7154951960756474`*^9}, {3.715495257918372*^9, 
   3.715495260747923*^9}, {3.715495468947431*^9, 3.7154955349375973`*^9}, {
   3.7154955674354267`*^9, 3.7154955862423553`*^9}, {3.7154956881322107`*^9, 
   3.715495692067802*^9}, {3.715502067098425*^9, 3.715502117113434*^9}, {
   3.715517004788307*^9, 3.715517023151116*^9}, {3.7155173956974707`*^9, 
   3.715517405473043*^9}, 3.715517464408703*^9, {3.71551763487652*^9, 
   3.71551763748314*^9}, {3.715517821399762*^9, 3.71551788840167*^9}, {
   3.715521177881995*^9, 3.715521190640737*^9}, {3.715521261775321*^9, 
   3.71552126219709*^9}, {3.715521311013361*^9, 3.715521314075995*^9}, 
   3.715521355646138*^9, {3.715533209181505*^9, 3.715533211284021*^9}, {
   3.715534328433711*^9, 3.7155343413874826`*^9}, 3.7155345601500893`*^9, {
   3.71553676340298*^9, 3.715536774210832*^9}, 3.715536832582013*^9, {
   3.7155368717434072`*^9, 3.71553689641894*^9}, {3.715536947274858*^9, 
   3.715536978778372*^9}, {3.715537019423297*^9, 3.71553701987873*^9}, 
   3.7155371425627737`*^9, {3.715537310752305*^9, 3.715537314574959*^9}, {
   3.715592187491884*^9, 3.715592187896867*^9}, {3.715592218904297*^9, 
   3.715592220416366*^9}, {3.715592422794795*^9, 3.715592441407748*^9}, 
   3.715592511187026*^9, {3.715601332999474*^9, 3.715601385932575*^9}, {
   3.715706203385066*^9, 3.715706236051333*^9}, 3.715706267526925*^9, {
   3.715754993683855*^9, 3.715755046137843*^9}, {3.7157551388924637`*^9, 
   3.715755155020493*^9}, {3.715755492088285*^9, 3.715755539183395*^9}, {
   3.7157555996806183`*^9, 3.7157556071369133`*^9}, {3.715774232048378*^9, 
   3.715774236071269*^9}, {3.7157742877798*^9, 3.715774292777092*^9}, 
   3.716792670548806*^9, 3.716792716908819*^9},
 CellLabel->
  "In[2920]:=",ExpressionUUID->"c4273a82-126b-4e65-8280-0d685c721ed3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1a", ",", "x2a", ",", "ua", ",", "Ea"}], "}"}], "=", 
   RowBox[{"Controller", "[", 
    RowBox[{
    "\[Kappa]", ",", "0", ",", "tend", ",", "clip", ",", "\[Theta]ff", ",", 
     "\[Theta]dotff", ",", "uff", ",", "0", ",", "0", ",", 
     RowBox[{"tff", "+", "2"}], ",", "2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1a", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x1a", "[", "t", "]"}], ",", 
       RowBox[{"Ea", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "7"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2a", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"x2a", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "10"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p3a", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"ua", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
      RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", "10"}], "}"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], ";"}], " ", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d0", "=", "2.95"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1b", ",", "x2b", ",", "ub", ",", "Eb"}], "}"}], "=", 
   RowBox[{"Controller", "[", 
    RowBox[{
    "\[Kappa]", ",", "0", ",", "tend", ",", "clip", ",", "\[Theta]ff", ",", 
     "\[Theta]dotff", ",", "uff", ",", "0", ",", "0", ",", 
     RowBox[{"tff", "+", "2"}], ",", "d0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1b", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x1b", "[", "t", "]"}], ",", 
       RowBox[{"Eb", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], ",", 
     " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "7"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2b", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"x2b", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "10"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p3b", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"ub", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
      RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", "10"}], "}"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], ";"}], " ", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1a", ",", "p2a", ",", "p3a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p1b", ",", "p2b", ",", "p3b"}], "}"}]}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "2"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.715408400566908*^9, 3.715408409336266*^9}, {
   3.715408453742902*^9, 3.715408458494282*^9}, 3.7154088643711843`*^9, {
   3.715415532116996*^9, 3.715415536992824*^9}, {3.715415796047092*^9, 
   3.715415861514296*^9}, {3.715415920091902*^9, 3.715415945897788*^9}, {
   3.715416014534782*^9, 3.715416072049623*^9}, {3.715417693922266*^9, 
   3.715417694255521*^9}, {3.715417770317621*^9, 3.715417779609592*^9}, {
   3.7154178351226587`*^9, 3.715417836512556*^9}, {3.715418020905336*^9, 
   3.715418025422249*^9}, {3.7154180710409107`*^9, 3.715418087816863*^9}, {
   3.71542352687084*^9, 3.7154235303716784`*^9}, {3.7154235955932627`*^9, 
   3.7154236295668907`*^9}, {3.7154245339324417`*^9, 3.715424535753639*^9}, {
   3.71542457599332*^9, 3.715424603770658*^9}, {3.715424807632621*^9, 
   3.7154248357813473`*^9}, {3.715424917083337*^9, 3.715424923932987*^9}, {
   3.715424961070039*^9, 3.715425015323148*^9}, {3.715425075635648*^9, 
   3.7154250869716463`*^9}, {3.7154251482305098`*^9, 3.715425167846542*^9}, {
   3.715425201997978*^9, 3.7154252447753983`*^9}, {3.715425292549438*^9, 
   3.71542533212505*^9}, {3.715426601642729*^9, 3.715426610541184*^9}, {
   3.7154267186639767`*^9, 3.715426723318039*^9}, {3.7154294422698593`*^9, 
   3.715429470683934*^9}, {3.715430030798407*^9, 3.7154300310996637`*^9}, {
   3.715430391601503*^9, 3.7154303992557*^9}, {3.7154304440879908`*^9, 
   3.7154304463258877`*^9}, {3.715430541993574*^9, 3.715430773995997*^9}, {
   3.715445287410528*^9, 3.715445298561607*^9}, 3.715445349660375*^9, {
   3.71544585355606*^9, 3.715445896887588*^9}, {3.7154476661588573`*^9, 
   3.715447671118936*^9}, {3.715447941391364*^9, 3.7154479478219023`*^9}, {
   3.715448068202559*^9, 3.715448072912689*^9}, {3.7154481053884706`*^9, 
   3.715448108461584*^9}, 3.715448138486013*^9, 3.7154482175518837`*^9, {
   3.715448495365253*^9, 3.7154486164517508`*^9}, {3.715448701949065*^9, 
   3.715448725362626*^9}, {3.715448758678041*^9, 3.715448764350299*^9}, {
   3.7154488020654993`*^9, 3.715448973451532*^9}, 3.715450381487074*^9, {
   3.715453559224518*^9, 3.71545356838279*^9}, 3.7154891575230722`*^9, {
   3.715489302474141*^9, 3.7154893563684597`*^9}, {3.7154893898620768`*^9, 
   3.715489406839554*^9}, {3.715489524549451*^9, 3.715489559475552*^9}, {
   3.715489759737432*^9, 3.715489774320938*^9}, {3.71548982010568*^9, 
   3.7154899255611963`*^9}, {3.715489959862953*^9, 3.715489960372889*^9}, {
   3.7154900808797913`*^9, 3.7154900845583963`*^9}, 3.7154902843422832`*^9, {
   3.715490318116404*^9, 3.715490319957201*^9}, {3.715490381529632*^9, 
   3.71549038791953*^9}, {3.715490988873217*^9, 3.715491104207265*^9}, {
   3.715491810429391*^9, 3.715491813771888*^9}, {3.715494422971704*^9, 
   3.715494472603664*^9}, {3.7155021868465548`*^9, 3.715502187411687*^9}, {
   3.715502228435923*^9, 3.715502230593957*^9}, {3.7155023779999733`*^9, 
   3.715502419500092*^9}, 3.715502634654777*^9, 3.715505341696509*^9, 
   3.715505400360587*^9, 3.7155153593718023`*^9, {3.715515539757807*^9, 
   3.7155155532472687`*^9}, {3.71551631018419*^9, 3.715516368545938*^9}, 
   3.7155164227817097`*^9, {3.7155164700119123`*^9, 3.715516477893094*^9}, {
   3.715517130046157*^9, 3.7155171616129293`*^9}, {3.715517308081664*^9, 
   3.715517312374634*^9}, {3.715521103836862*^9, 3.715521107594685*^9}, 
   3.715533175200778*^9, 3.7155332407564774`*^9, {3.7155345977231703`*^9, 
   3.7155346139951267`*^9}, 3.715536611092264*^9, {3.715592226392959*^9, 
   3.7155922428305283`*^9}, {3.7155923977284327`*^9, 3.715592404422224*^9}, {
   3.715592445609953*^9, 3.715592456015098*^9}, 3.7155925271140537`*^9, {
   3.715592559482765*^9, 3.715592604411653*^9}, {3.7155926652395897`*^9, 
   3.715592720451304*^9}, {3.7156014091564302`*^9, 3.715601444652398*^9}, {
   3.715601499407305*^9, 3.715601499885113*^9}, {3.715755053507565*^9, 
   3.715755054808126*^9}, {3.7157551672820387`*^9, 3.7157551677197638`*^9}, {
   3.715755200048044*^9, 3.71575520037528*^9}, {3.7157552685636177`*^9, 
   3.715755283072043*^9}, {3.71575547186476*^9, 3.7157554746218348`*^9}, {
   3.715755622710246*^9, 3.71575564151838*^9}, {3.715755673076888*^9, 
   3.7157556859164762`*^9}, {3.715774125566051*^9, 3.715774138082049*^9}, {
   3.715774192514546*^9, 3.715774225292877*^9}, {3.7157758609437933`*^9, 
   3.7157758733735313`*^9}, {3.715788153323996*^9, 3.715788167956072*^9}, {
   3.715788218510262*^9, 3.715788226070809*^9}, {3.71578847902302*^9, 
   3.7157884794934072`*^9}, 3.715788510956688*^9, {3.715788677592815*^9, 
   3.715788687857025*^9}, {3.715788748568405*^9, 3.715788768769308*^9}, {
   3.715788825153809*^9, 3.715788841514049*^9}, {3.715789650066052*^9, 
   3.715789652736919*^9}, {3.71579336240254*^9, 3.715793370105431*^9}, 
   3.715793520055407*^9, {3.7157935607500896`*^9, 3.715793595516663*^9}, {
   3.7157947513759327`*^9, 3.715794809400436*^9}, {3.715794876281261*^9, 
   3.7157949754342213`*^9}, {3.716533802619089*^9, 3.71653381112845*^9}, 
   3.71653384298221*^9, {3.716792679027091*^9, 3.716792685162898*^9}},
 CellLabel->
  "In[2921]:=",ExpressionUUID->"d5755d32-7f54-4cde-8146-a6000297e229"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"3.016134904445327`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 2921, 192, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232292959987783`*^9},
 CellLabel->
  "During evaluation of \
In[2921]:=",ExpressionUUID->"957ca2bd-3088-4806-bd34-d87ef000acee"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"3.016134904445327`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 2921, 193, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232292960050488`*^9},
 CellLabel->
  "During evaluation of \
In[2921]:=",ExpressionUUID->"25398235-d72b-4cfd-b511-e2bcaf085b68"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"3.016134904445327`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 2921, 194, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229296061129*^9},
 CellLabel->
  "During evaluation of \
In[2921]:=",ExpressionUUID->"2755e0d6-03b0-4176-ab95-221d69843940"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 2921, 195, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229296116721*^9},
 CellLabel->
  "During evaluation of \
In[2921]:=",ExpressionUUID->"b1a00bb4-dee5-42ca-9a76-cc56292330fb"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"3.016134904445327`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 2926, 196, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229296294015*^9},
 CellLabel->
  "During evaluation of \
In[2921]:=",ExpressionUUID->"dbedb31a-ddba-4527-b047-39c6c17ca5d1"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"3.016134904445327`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 2926, 197, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229296297447*^9},
 CellLabel->
  "During evaluation of \
In[2921]:=",ExpressionUUID->"093a3c34-3093-4b65-83bb-360e9ee5c08a"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"3.016134904445327`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 2926, 198, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.82322929630063*^9},
 CellLabel->
  "During evaluation of \
In[2921]:=",ExpressionUUID->"838b84e3-0454-4fcb-b83c-989acbdcbc1d"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 2926, 199, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229296303443*^9},
 CellLabel->
  "During evaluation of \
In[2921]:=",ExpressionUUID->"0b32d624-92e8-4347-8346-e1397ccdda3e"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV13c8ld8fAHDrbveWde+lzCsh0VChdD6FjCizZUVmMlIitBAKiYTI1jQa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           "]]},
         Annotation[#, "Charting`Private`Tag$1213343#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV2Xk81E0YAPDdlftm3deyQgiVVDrmkSsllSsK5ShnQpJEhG5yJKRCkpAj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           "]]},
         Annotation[#, "Charting`Private`Tag$1213343#2"]& ], 
        TagBox[
         {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQPbcuic0wpdtOQtcl5LcipwP77Ufqb+V32sP4C0/N
L3wtfxLOX7e+83aO3i04P93+4sw3RY/h/Lynmo+3rHsJ53Mptqjft/gA5/cJ
nNZamPAZzk+6HbKf+cw3OL/waEtSvvovOH9jAU+whOdfhHuqs18ZhDM4wPhN
8/8EfnnDCOczXH7gsKeKGc5XK0mrCNFihfOffJ0exr2XDc73eppVO6mQA873
ezJBW06OC85/dTip4cRabjhfT/CarHM8L5zPZf818c5nPjjf/W3Ud6VQATj/
xqEUxigdQTh/a8eROIWvCH4aa+mDc+eE4PzkouqtPLOE4Xz9dO1zPokicP55
IR3uUktROH/3uqbZOsxicH41o1bAmbsIPtedKo+8LeJw/tNlilPm10jA+VM0
JFl2hkrC+RNmpR1PVJCC86OmxJ7jeY7g/3BZ+nP+Pmk4//FTp4pD7TJw/iJb
Q+mzibJw/trWUsF0XTk4vz002Zv5K4Jvemfhyvaz8nD+DM3Za896K8D59Qd6
Z3jvRPB9pUOXnlJRhPMd845HC3Yi+PNlklTOfEXwVQ4vn+YXrYTwn+4hrUv7
EPy0zywXT2opw/lJGz8pdPYj+BMu8fQeOY7g7/us9vP/fwQfAGxfK0U=
           "]]},
         Annotation[#, "Charting`Private`Tag$1213343#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 9.999999795918367}, {0, 7}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVl3c81f8Xx41ssue9VldpENKwck5LkihRKkVmhPItWbdlFFJUZsMKkZWk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           "]]},
         Annotation[#, "Charting`Private`Tag$1213391#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 9.999999795918367}, {-1, 10}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlmnk4lF/4/61jyTIYlCxjCSFJktb7bpMtSUgSEqEoKaVSyZpdIkKoVEIq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        "], {{
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwVz8sqhGEAxvExJeZQcthYMYOLcLgCDHIJNg6LGadyjIwcQqlhGCVZyUIW
ZONQhlvB2GBDsSC/b/HveZ7/+371vYmBTH86HAqFyjCDonGPJyKNCFr5VOD1
TjzbOcxyb/YUalDJJbm83oBre8n+1BcwaI/bz3oGBT2GqL4hf+Ua2tzrsYt6
F3b1CrzwK/Kby+JYr8UOPyffuTM5LQ9lFa6CO/a2DOMCW/aJrMcNIr5vknv8
qWyUOVmOy+CO86z84s/lojyS1RhyNhH8GzeKAz0evEvflH9yHe3u9doPejdK
9qr9oy8Hb7Tn7Q99BnWIcs3cvp7ArT2MSa5kjyGODq6Pe9RTeLXziKGFL3BJ
3Nkj+AfrsTyW
              "]], PolygonBox[CompressedData["
1:eJwVykcyg3Ecx+FwAKMlWFqoSZQb6GVHpGFnr5eFGTsbM/ZKJNEuYaeERL2H
0TkAj8Uz/9/3876NM/OxufJAIFDGJgXjmh33hvfTh3WCVGqtWsbdxLk9Sw8T
+o02xou9SxVt+oHWzIU9Ry9xvaiN82rvUU27ntVauLTn6SOhl7QYb/Y+NYT1
nNbKlb1AP0n9Vpvg3c5QS0TPa20U7EUGSOl3WpwP+4AgUf1Qa+faXmKQtH6v
Jfi0s4To0I+0MDf2MkNM6g9aki87Rx2d+rEWoWivMMyU/qil+Lbz1NOln2hR
SvYqI0zrT1qaH/uQBrr1U62DW3vtn/ZsL1PBtv3r3eLEHeKMUf/+AXDJQE0=

              "]]}]}, 
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{705, 707, 695, 532, 673, 388, 687, 506, 647, 234, 
              520, 661, 335, 453, 594, 63, 269, 370, 488, 629, 108, 191, 292, 
              410, 551, 15, 150, 233, 334, 452, 593, 62, 107, 190, 291, 409, 
              550, 14, 13, 12, 61}}], PolygonBox[CompressedData["
1:eJwt0ktLlGEYBuCZ8UhgHkAc89T8hjL7A+qMuvIXqJmb1Ekw00UwoggpHkcQ
ChFEFyKCklp5xl+iTSt1J9TGhdcbLS7u57m/OXzvN5PoSXcOxiKRSJTs/7xU
XDBEn/0n9S4sk9AV2cvNI9wxplvU/SZlP6dD99r+lh/U6bI81xfam+jlO7X6
JRpcK7AvkCOpO6Nd/8pebB4gx3vdG90hNfZF6nX59iMZZ5MZ/Z6MMkeZ/an8
ygfzLaPmee+rkGuM6/4yaf6lL5RZWnVb8lS2ycZwNlnJOlP6XfkgP4fnJPfl
E1bot2+Hz5Rp2RPuP9wTq3zS78h7mZEHrueHZ8sz3QJ15jx9ldxgOvxgcpZS
c4n8wrD5ho/h3F6SMf9hwn5tbzGfkLK/DGc0v+Oa8Ifo1u1TbZ+nNvbvayKz
XNGsOyapfGHv4htx3Rw1+kfOhkNA
              "]], PolygonBox[CompressedData["
1:eJwl07dPVWEAxuEr6ODgqokde6cqIEpXE7vY6QL2NlpAsIstcXK3AIpIsxtH
42ADEemo/4LG3p8Th4fvvL9zh48biCjam7UnLBQKDWCIH4+NJ8TYj5zDqeG8
d+HOCwzzXMZHKuxmnx3keQfv2a0VaOd4R6b2kEV6tN3EQHs779il52tneUuG
9oCFepTdSLi9jbfs1PO0M/STrt1ngR5pNxBmb6U/uJeeq52mjzTtHpn6LLs+
+P3tLfQF99JztEp6SdXukqHPtG+G/n9hm+kN7qVnS6foIUW7Q7o+w67jLyVa
T3AvfaN9km6Stduk6dPtG/yhWOsO7qVvsE/QxXztFqn6NLuW3xRpXcG99PX2
cTqZpzWTok+1r/OLTVonJfo6+xgdJGlNJOtT7Gv8pFDroFhfax/lDXO1Rubr
k+0aflCgvaFIX2MfoZ1ErYF5+iS7mu/ka+1s0lfbh3lNglZPkj7RruIbedpr
CvUsu4I24rWbzNUn2Kso5xVz9DoSvRtvr+QQrczWb5Dg3Th7BWW0EKfXEu9d
hD2WMSynlJfEen+dOT4z2l7GQV4Qo19jtnej7Kt8JVdro0Bfah/gOdFaDXH6
SPsKX8jRXpGvL7H384worZpYfYR9mc9ka63k6YvtfTwlUqsiJvgft4d6LuUD
5dql4O/N808q7U/2YOfF4G83+C6cLc5c5z9++4Re
              
              "]]}]}, {}, {}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
            1.], LineBox[CompressedData["
1:eJwl1OdXjnEAxvGnkFLZjigj87Vj71doSPgL7FVE9tYQCi0V2Q4Ox96rIuP/
sPd4YTs4Pr/jxfe5rut733c99/PclTorb/qSqEgkMshLyOToSGS3koQr9gwM
Rhp/h5uAx/YuUJEUL+VcN1y1Z2IJ98TOQQyGcOlcgz4RT+wi+5u+Bbvt1fZb
fQXq9US003dF//9Fpfpx2RUtqB6yguuOSr0lrvFb5GfunNwoD8r2uI5ZjufJ
p/wZmSvrZBtcRWt7h/wtL8oSeUx2wU0MdX2GbORPy0myWsaEn+lYsfzOFeCw
3jF8Nvwa+Y5bif162/Cewn3LKFxCmX1CJuF2uB/X9ZSVfDKu27OxlHtmL0Ys
hnGZXJOehmd2BVqhF1/FpeCGPQfDEYPejlXzPXDTnosRmMzf5dLx3K7EWu69
vQod0JpL5fboPXHLnodl3D0858JDFYeRfFbwegZe2FVYx32wV6NjuBeuD1ej
98Jtu8D+om/CfDvffqHnYa8eH747vVT+kdswynlT7GY9E3vC94qX/Fb5gyvE
Eb1T+Az49fIjd1aukQfCsxeep3COXS6jcRk77ZOyW/h7QJzr+8pa/pTsLatk
K1wJ5zheKL/y5+VmeUh2wALHlof3xi3FPj0h3JdeJv/K7RjtvGz7vj4Zr+wS
+6deFO7R3mB/0teiM9pw/bg6PRUN9kKs4F7Zy5CAMdxU7oGehdd2DeLRn9/L
9UGjvQjN3FiZgES0xQBun3P6osnOwThM4x9yU/DGrkU7DOTruX64a+diJffa
zkcixnPTuUd6Nmr02PA/gt8mf3EXZLE8KjvjBv4B6vOMuQ==
             "]], 
            LineBox[CompressedData["
1:eJwV1Hl8z3UAx/Gf4Y/+6RExtXSQa45hhmHYZbpjbjswt3KuENK5pNSjvyrn
zLCZWwf16I/Ksc1t2Ngc/dujciu3np8/nr7f9+v7+2sPn0+LvJmZM+pFIpEv
/fON57tRkcgV7wtoymNaO22l99b8ak8nmSH6AW0Qf9nf0ohYfZXWht/sGaQw
VC/XBvO3vZzGtNdXa2353Z5JKsP0Ci2Tf+wVPE4HfY3Wjr32LNIYrldqQ7hk
r6QJHfVCLZZ99mzSGaEf1IZy2V5FUzrpa7X27LfnMICR+iFtGFfs1UQTpxdp
HThg55PBKP2wNpyr9hqa0Vlfp3Wk3H6LgYzWj2gjuGYX8gRd9GKtExX227xA
ln5UG8l1ey1P0lVfr8VRac8NtD/tfB5lmf3QcynF3qP5iRf9dp9nNsd8K/Mc
5fm15yPc8P1Tz7taAUX2Yvuq94VEE6PFaxu8d+agPY+XyNGPa6O5aa/jKbrp
G7UuHLLn8zK5+gkti3/tYpqToJdoXTlsv8MrjNGrtGz+s9fzNN31Ui2eI/YC
XuUZevi2Se/GUXshr/Esz9GCnn5T5nsCx+xFvE5LEn3brHfneDhDDOJ5evm2
Re/BifC3YjCt6O3bVr0nVfZ7ZDJWP6nlcMveQGv66Nu0RE7a74czyDj9lJbL
bXsjbUjSt2u9OGV/EM4gefppbQx37BLa0lffofXmtP1hOIOM16u1sdy1S8Od
QD99p9aHavujcAaZoNdo47hnbwp3Av31XVoSNfbH4QwyUT+j5XHfLgt3Asn6
d1pfztgF4QwyST+rjeeBvTncCaTo32v9OGt/Es4gk/VabQIP7S3hTiBV/0Hr
T629JJxBpuh12sRwMbI13Amk6T/aydSFcxDOIFP1c9ok6rEt3Amk67vtFM7Z
S8lmmn5em0wU28OdwAB9j53KefuzcF54Q7+gTaE+O8KdQEY4s3YaF+zPw3nh
Tf2iNpUG7Ax3AgP1n+10LtrLwnlhuv6HNo2G7Ar/F7Vr3hfRjK/s+nzhvcQz
hl+I99v/AX4QwJs=
             "]]},
           Annotation[#, "Charting`Private`Tag$1213437#1"]& ], 
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], 
           LineBox[{702, 703, 701}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 9.999999795918367}, {-1.5, 10}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwd13dcTv/7B/DmPdr3aKt7lKRphEjOCxVFU1ktJRKVSimVlVSUkGigQogW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           "]]},
         Annotation[#, "Charting`Private`Tag$1213549#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwd23c81d8bAPB7r733Fu4lhJCkoZzHiJSWKEXKKKuESpTii4qipEISEkJG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           "]]},
         Annotation[#, "Charting`Private`Tag$1213549#2"]& ], 
        TagBox[
         {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQPbcuic0wpdtOQtcl5LcipwP77Ufqb+V32sP4C0/N
L3wtfxLOX7e+83aO3i04P93+4sw3RY/h/Lynmo+3rHsJ53Mptqjft/gA5/cJ
nNZamPAZzk+6HbKf+cw3OL/waEtSvvovOH9jAU+whOdfhHuqs18ZhDM4wPhN
8/8EfnnDCOczXH7gsKeKGc5XK0mrCNFihfOffJ0exr2XDc73eppVO6mQA873
ezJBW06OC85/dTip4cRabjhfT/CarHM8L5zPZf818c5nPjjf/W3Ud6VQATj/
xqEUxigdQTh/a8eROIWvCH4aa+mDc+eE4PzkouqtPLOE4Xz9dO1zPokicP55
IR3uUktROH/3uqbZOsxicH41o1bAmbsIPtedKo+8LeJw/tNlilPm10jA+VM0
JFl2hkrC+RNmpR1PVJCC86OmxJ7jeY7g/3BZ+nP+Pmk4//FTp4pD7TJw/iJb
Q+mzibJw/trWUsF0XTk4vz002Zv5K4Jvemfhyvaz8nD+DM3Za896K8D59Qd6
Z3jvRPB9pUOXnlJRhPMd845HC3Yi+PNlklTOfEXwVQ4vn+YXrYTwn+4hrUv7
EPy0zywXT2opw/lJGz8pdPYj+BMu8fQeOY7g7/us9vP/fwQfAGxfK0U=
           "]]},
         Annotation[#, "Charting`Private`Tag$1213549#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 9.999999795918367}, {0, 7}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVV3c81e8XN7Ipe17cISNSIilyTlEJUUqLZK8ikqzbQgqJJKviSykR1UX2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           "]]},
         Annotation[#, "Charting`Private`Tag$1213597#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 9.999999795918367}, {-1, 10}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlm3k0VfH7700H55gOjukcwzFkLCRJUp8npcwhUxKSDJGkJCUpU0IkU1JU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        "], {{
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwV0TsvQ2EAxvGDRYlElIWSEIt2IIhE1cLEIiGxMIjSxH1z+Qwuk8vqNrIw
sbhNWt8BoyIkqMXgd4Z/nuf/vO+7nNM4uTS8WBwEQRHW0IZW1BnXjVXo5vv8
S08jz7fxaGvHoa0FpbZlfh++wTV/4Smc8Bl+r8ewEd4vCYIxPaoX5AAu9KR7
B/q3PoUS90b5q/1D9uHMHrVn9B37k+xAk+3IWYWc4K0yzv/0IcT5Fa+VC7xL
Rrxf0bP2GE+GH0OO2BLyhub1XjTzU+eVMs1nnWVlPTbtEfu4Xq3/ykFc6j3u
Heo/+jTe+Cfvxznf5c96J455AmW2VZ4L3+OWzyFna8CWrQYp2xEv6Bm88z2U
h//U/hDewR2fxz/N1jmh
              "]], PolygonBox[CompressedData["
1:eJwV0bc2RFEAhtHBC4gzdPRKamHEpfME6MSRKeTQa+WwlhxeQC8zMrUnkHPa
U+x1z/+d252smkhlU3wgEIhjhCqqGefORS6LLrNJ1HrsqHMeO3aEfJb0D62W
e3uCJHr1Uy2fXbuZApb1T62OB3uSZPr0M62APbuFQlb0L62eR3uKFPr1c62Q
fbuVMKv6t9bAkz1NKgP6hRbmwG6jiDX9R2vk2Z4hjUH9Uivi0G6nmHX9V2vi
xZ4lyJB+pRVzZHdQwob+p0V4tecIMaxfayUc252Ushl7FJr1N8d50mNvpN1o
pZzYXZSxpcfRor/bC2Qwqt1qZUTtbo61TMa0UOx/5wq2nYMJ3tA5x7fcv/8/
50jP
              "]]}]}, 
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{48, 95, 818, 615, 788, 436, 806, 580, 753, 239, 599,
               772, 360, 504, 677, 63, 278, 399, 543, 716, 110, 197, 318, 462,
               635, 15, 152, 238, 359, 503, 676, 62, 109, 196, 317, 461, 634, 
              14, 13, 12, 61}}], PolygonBox[CompressedData["
1:eJwt0TlLXAEYheHrRGOhYBQCjoUogsZC3DLjgI12abQQbCwcHVdQ3P0P0cat
dJlYp9EucQX3H6Hp4lK4go0WyXPR4uWc835zB+ZOaWq0bSQSBEEGlt6zFtU4
cxiU+0g4nGGay7a/6Ouotf9E3p69QYp7QppL2APYQwN3iin+Y7jRj13E+RNM
umXZi7hGN/eINT5u5+uzKLJP0cftIMYdY4LLDPeHIBjWo3KPr5St9isq7KTM
5X7oNfoFFjzXJwv4Tb5Zv8MV3y4jfBdfLB/kKhdzq7cH9c/yF18hv9nP+GRX
2R3hO5MzdomM2ifo9XyNndLz5E/3MtloX2PbvU3+w1e3I4zrPhIMyUJll2vR
X1Cud8ocPq1X6+eY9/kNu0m/xaWdtO+xEn63nad/R6F9jB5uK/x93CHGwndg
z+EvOrk7LJP14f+O36jjDjDK/wenyUSR
              "]], PolygonBox[CompressedData["
1:eJwl1ElQ12UcgPE/q4KKWrmkArKJKFB6aPFQJ2tSQDYXVJpqOnXIGS1LBQXB
FdS01Kz0UoJSyiJqC5VW53IvwB3UCrtUlxapzzseHr7f5/kBM/x531/aS8tK
X42ORCJRqPXlBXM7ZmJWTCQyQ2vBLN90B5/qSXwTxvHv8LyWxQ8gn/dim9aP
Su03vKfl85MYwTdirPYtKrVMvh95vAeNWh+WanexT8vjJzCcb8AY7Rss1TL4
B8jl3WjQbmKJNoB3tVx+HMN4PR7STmOJthU3sFj/FXv16bwTibwOD2qnsFjb
guuo0H/BHn0aP4YEvh4PaF+jQtuMa1ik/4zdeg7vwNCo+5/9aO0rLNI24SoW
6nfwjj6Vt2MIr8Eo7Uss1DbiChbot/G2ns3bEM/XYaTWhQXaBlzGfP0WdulT
eCvi+FokaV9gvlaPXpTr/dipZ/GjiOXVGKF9jnItnb+P6fwn1Gk9KNP68JaW
yY8ghldhuPYZyrS0cGYwjf+I9Vo3SrWb2KFl8NP2EvsgHrUfxpP22/gknDf+
rP1PRNsrzHjneo19WDjPKPV9r5jj9C59qlnA/8LkcKZ5pT3R3MfTzBx+CbV+
dgZ/2T7abPU8y3ya3w1/u+e5vNweZZZ4nmzeMLdr6Z6HCzhRO6UV2+/hEfuL
ZpJ+yP6E/RY+DneAP2P/I/xO+2ok2k+ixPPUcN7D38Evoib8n/hT9oHwefJi
fh3beBrPtzfjcd6Plsj9l8IqJPATKJZSwt1ANr+AddolzNOuoTF8Zvww/sOb
2lDtOObx5HBXMIWfx1rtIoq0q2jQUvkhDOINbYjWiSI+Kdyd8Bnzc6jWLqBQ
u4KtWgpvxj2s1OK1YyjkE8NdQiY/iyrtPAq0y9iiJfMm/IvXtTitAwV8Qrhb
yOBnsEY7h7laLzZrk/hB/IPXtFitHXP5w+GuIZ3/gNXaWczResJ7NZwF/hH+
xgotRmvDHD4+3L1wBvn3WKWdwXNad3ivahN4nr0Jj/E+fBjefXy2/fdwtsO7
yIxzvpbrqWY0b8X/zXG4mw==
              "]]}]}, {}, {}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
            1.], LineBox[CompressedData["
1:eJwV1NdvzWEAxvFjjxo109YeQYko1Zq1L5AgqSBBjFMdVmvPf8CuTWKvKyTW
hRYtreow/gLzwtaqUQQJn/fie57n+/ze3znpOaenRzQvPbdeJBIZ7CFkXv1I
pEQZggIeRTKO2WtsC/Ca58MUWeWh1JaMQp6BMlscttlaY6jtOP+sL8QbXs3H
4Qrfy5/qg3CKxzTwOnof/bechjt6nH25LiKr5f3w3Pinp+OW/Z0chV4OXQyv
L6M8SS5x/YEej+58u+tN5Fw+UMbyOn0y+vKbvIPM4ckyxf0n9Fp7V75I1pez
bG9dq5HjcdXe1p6p77M/C6+P0/YW9oXh+fU/cjoSbUU8Xq7gKbKh+9boZfYU
3OaZKLclYIetDVJtJ/kXfTHe8f1ohLX2B+EM7vAsDENjrHOt3D4MRTwbw3HK
/tUWxXt+AM9tg3HG1i+8Z7b1vEIfjmKeg4rwGcpOcmd4DzCCn+bf9Ax84Afx
wjYEZ22JaGrbwCvDPbjL3/PRuMSX8kq9M3aF896jeXo7/YecggJ9pHNn9O/6
EjRwbjb/aP8sJ+CavZ09Sz9kfxk+X/S0nXOtZfhsw98i+/O/+gz058U8Qa7k
qbKZ+zfqVfbOfGT4J5IzbQPkPfpBT0Nvftn1WJnBl7lWJbtgt72Zfb7eXv8p
p6JQH+XcWb1Oz8QnXssn4jo/zF/pQ3GeD0Bz2yb+MNyPEr4cD21dsSd8tzHa
do7/0LNQzY8gBpvtj8IZlPIVSEIaWqAlWmGLc4+dScN9vhJjcN7+05aNGn4U
rbHV/sQ2BmU8F49s3ZBv64ixtgv8l56Dht6bOeE3xP5FTgq/D7YbrrWX2eH7
JP8DIJ2M7Q==
             "]], LineBox[CompressedData["
1:eJwl1FWQlXUcx+HdpVOWRnKBpVllxuRCugQVkEYcdbwRle5e0paGXcKku1FQ
QR2bzt0ll1LBGcWkfX568cz7/37OCwPnnPekPNe/c7/EhISExKSEhAzXXNf7
WSI2oIQ2xt7n3ISv7P40Zal+TXuBX+1Mkhmr79ea8rU9gGYs069rffnNXkBJ
xukHtGZ8Yw+kOcv1G9qLXLUXUorx+kGtOd/ag2jBCv2m9hK/24sozQT9kNaC
7+zBtGSlfkt7mT/sxZQhXT+steR7ewitWKXf1uIN+9N+h7JM1I9orfjBHkpr
Vut3tP78Zb9LOSbpR7XW7LGH0YY1egID9L8d36M8k7VjWhv22sNpy9qk/z+3
gfo/9vtUYIp2XGvLPnsEe7RqTNfKxf3O7dnhXDaPz9D5Ptd27n2GdXYSVbVB
7snn2iM+b69ddW3FFv0D+5zzAyy1G3K3NtXOcm7Hfnske7UUZmjleVRbb+dh
sH3d/pCKTNOy4x4O2KPYp1VnplaB9toGOy9D7Bv2EirxipYT93DQHs1+rQaz
4t9IB22jnY+h9s34TlOZV7UTcQ+H4hnggFaT2VpFHtM22fkZZt+K7zhVeE07
GfdwOJ4JDmqpzNEq8bi22S7AcPt2fOepyuvaqbiHI/GMcEirxVytMk9oW+yC
jLDvxDNANd7QTsc9HI1nhsNabeZpVeiobbULMfK/HwHPhMt5+0GW2WmkaG/a
Z+LPcMy+bD/CWnuCfcS5DvPtqnTSttmFGWUnxjPp3Jqtzqu8fsH5IZbbxX2/
nnW+J95H147sivdZ7xefu/vfcj0b/3etU/ydrl20Bq7HvX7FuUm8x/Y6rye7
Pm83ck33+lHnuvEdtDO8Xti1j53mWs2+5twh/h/2znhOXPvanf3Z7a5FGK3n
13vG8xG/G65t2Oa82n0XnR9mhX1vfKbOndjtXMPrbzvnOncmK347OKbVIzPe
a57UPrKLMsbOwxqtJtO1c3EP2fFbwnGtPgu06nTRPraLMdbOy1otlRna+biH
nPhtoSs79OKMi2eddVotZmoX7K6ciN8WurFTv4vx8X6wXqvNLO2i3Y2T8TtA
dz7RSzBBL8AGrQ6ztUt2d07Fc08PPtWTSdcLslGryxztR7sHp+M5pyef6SWZ
qBdik1aPudpPdk/OxHNNL3bppZgU3wM2a/WZp/1s9+JsPMf0Zrdemsl6EbZo
DZivXbZ7kxvPLVnxnWRhfOY8pX1ul2GKXZStWkMytCtxD+fiuSVba8girSZ9
tC/ssky1i7FNSyNT+yXu4Xw8p+TEd5rFWipPa1/a5ZgWzxrbtUt2Y1bajWjs
e/0va3z9Lg==
             "]]},
           Annotation[#, "Charting`Private`Tag$1213643#1"]& ], 
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], 
           LineBox[{824, 825, 823}]}}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 9.999999795918367}, {-1.5, 10}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{2}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.71578877344985*^9, 3.715788845575098*^9, {3.715788913805491*^9, 
   3.715788939598832*^9}, 3.715788982562909*^9, 3.7157890605043297`*^9, 
   3.715789091347096*^9, {3.71578920572408*^9, 3.715789235664782*^9}, {
   3.715789442566348*^9, 3.7157894689686403`*^9}, {3.715789507523329*^9, 
   3.715789525515822*^9}, 3.7157895685930767`*^9, 3.7157896058166647`*^9, 
   3.715789657239324*^9, 3.715789793847146*^9, {3.71578984129636*^9, 
   3.715789859178413*^9}, 3.715793290809713*^9, 3.715793374415201*^9, 
   3.71579341281793*^9, {3.715793468919959*^9, 3.715793483696495*^9}, {
   3.71579352591817*^9, 3.7157935335197363`*^9}, 3.7157936124331713`*^9, 
   3.71579378756525*^9, 3.71579448209077*^9, {3.715794520103456*^9, 
   3.71579453845358*^9}, {3.715794642223977*^9, 3.715794660999984*^9}, {
   3.715794729611887*^9, 3.7157947924042788`*^9}, {3.715794822505611*^9, 
   3.7157948448816013`*^9}, {3.715794881263673*^9, 3.7157949092291594`*^9}, 
   3.71579499525585*^9, {3.7159663445205*^9, 3.7159663709250183`*^9}, {
   3.716531791113164*^9, 3.716531813200452*^9}, 3.716532039510915*^9, {
   3.7165337946045227`*^9, 3.716533819316881*^9}, 3.716533851294146*^9, 
   3.716792780403328*^9, 3.716793982103332*^9, {3.719212062078395*^9, 
   3.71921207180729*^9}, 3.731692093595704*^9, 3.7594494536326323`*^9, 
   3.759449494038158*^9, {3.7935026912905493`*^9, 3.7935027208008957`*^9}, 
   3.793908436247747*^9, 3.82322929647859*^9},
 CellLabel->
  "Out[2930]=",ExpressionUUID->"70ed67ee-755b-4f5d-a2cc-f9840925a628"]
}, Open  ]],

Cell[TextData[{
 "Feedforward & linear feedback & event triggering.\n\nFind time ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "0"], TraditionalForm]],ExpressionUUID->
  "f219c188-d6c8-4076-b9da-d0316b888212"],
 " when \[Theta](",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "0"], TraditionalForm]],ExpressionUUID->
  "85a4a3ac-402b-45ff-902a-2a322923927e"],
 ") = \[Pi]+1 and ",
 Cell[BoxData[
  FormBox["extract", TraditionalForm]],ExpressionUUID->
  "36674d97-049c-45b4-8e46-45a817d9e356"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["\[Theta]", "."], "(", 
     SubscriptBox["t", "0"], ")"}], "."}], TraditionalForm]],ExpressionUUID->
  "c0ce0e37-e7b3-4d43-8d85-69b052feb3b4"],
 "  Then recalculate the feedforward from ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "0"], TraditionalForm]],ExpressionUUID->
  "6db60afd-1151-4808-bb67-8b787f41de98"],
 "."
}], "Text",
 CellChangeTimes->{{3.644509136027421*^9, 3.644509201738372*^9}, 
   3.644509766090928*^9, {3.714237280802227*^9, 3.7142373247256536`*^9}, {
   3.714326070104105*^9, 3.7143261090526667`*^9}, {3.715181320555006*^9, 
   3.715181324473104*^9}, {3.7153433317700977`*^9, 3.715343341080782*^9}, {
   3.715403051966159*^9, 3.715403053002616*^9}, {3.7154081029771976`*^9, 
   3.715408117255252*^9}, {3.715449130710772*^9, 3.715449137477172*^9}, {
   3.7154891308101892`*^9, 3.715489132841901*^9}, {3.715502555045814*^9, 
   3.715502588308298*^9}, {3.71559908841926*^9, 3.715599160128927*^9}, {
   3.715793704855727*^9, 3.715793781090328*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"9f1f533c-fcc3-4384-ac21-10147021c9b4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ControllerEventTriggered0", "[", 
    RowBox[{
    "\[Kappa]_", ",", "tend_", ",", "clip_", ",", "\[Theta]ff_", ",", 
     "\[Theta]dotff_", ",", "uff_", ",", "td_", ",", "d_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "eq", ",", "init", ",", "x1", ",", "x2", ",", "x1s", ",", "x2s", ",", 
       "us", ",", "Es", ",", "\[Kappa]1", ",", "\[Kappa]2", ",", "ufb", ",", 
       "u", ",", "t"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Kappa]1", "=", 
       RowBox[{"\[Kappa]", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
      RowBox[{"\[Kappa]2", "=", 
       RowBox[{"\[Kappa]", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ufb", "[", "t_", "]"}], ":=", 
       RowBox[{
        RowBox[{"\[Kappa]1", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
           RowBox[{"x1", "[", "t", "]"}]}], ")"}]}], "+", 
        RowBox[{"\[Kappa]2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
           RowBox[{"x2", "[", "t", "]"}]}], ")"}]}]}]}], ";", 
      RowBox[{
       RowBox[{"u", "[", "t_", "]"}], ":=", 
       RowBox[{"Clip", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"uff", "[", "t", "]"}], "+", 
          RowBox[{"ufb", "[", "t", "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "clip"}], ",", "clip"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"eq", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{"x2", "[", "t", "]"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Sin", "[", 
             RowBox[{"x1", "[", "t", "]"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"u", "[", "t", "]"}], 
            RowBox[{"Cos", "[", 
             RowBox[{"x1", "[", "t", "]"}], "]"}]}]}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"init", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x1", "[", "0", "]"}], "\[Equal]", 
         RowBox[{"x2", "[", "0", "]"}], "\[Equal]", "0"}], "}"}]}], ";", "  ",
       "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1s", ",", "x2s"}], "}"}], "=", 
       RowBox[{"NDSolveValue", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"eq", ",", "init", ",", " ", 
           RowBox[{"WhenEvent", "[", 
            RowBox[{
             RowBox[{"t", "\[Equal]", "td"}], ",", 
             RowBox[{
              RowBox[{"x2", "[", "t", "]"}], "\[Rule]", " ", 
              RowBox[{
               RowBox[{"x2", "[", "t", "]"}], "+", "d"}]}]}], "]"}], ",", 
           RowBox[{"WhenEvent", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"x1", "[", "t", "]"}], "\[Equal]", 
              RowBox[{"\[Pi]", "+", "1"}]}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Print", "[", 
                RowBox[{
                "\"\<pass threshold at \>\"", ",", "t", ",", 
                 "\"\<,  \!\(\*OverscriptBox[\(\[Theta]\), \(.\)]\) = \>\"", 
                 ",", 
                 RowBox[{"x2", "[", "t", "]"}]}], "]"}], ",", 
               RowBox[{"t0", "=", "t"}], ",", 
               RowBox[{"\[Theta]dot0", "=", 
                RowBox[{"x2", "[", "t", "]"}]}], ",", 
               "\"\<StopIntegration\>\""}], "}"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x1", ",", "x2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "tend"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"us", "[", "t_", "]"}], ":=", 
       RowBox[{"Clip", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"uff", "[", "t", "]"}], "+", 
          RowBox[{"\[Kappa]1", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Theta]ff", "[", "t", "]"}], "-", 
             RowBox[{"x1s", "[", "t", "]"}]}], ")"}]}], "+", 
          RowBox[{"\[Kappa]2", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Theta]dotff", "[", "t", "]"}], "-", 
             RowBox[{"x2s", "[", "t", "]"}]}], ")"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "clip"}], ",", "clip"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Es", "[", "t_", "]"}], ":=", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         SuperscriptBox[
          RowBox[{"x2s", "[", "t", "]"}], "2"]}], "+", "1", "-", 
        RowBox[{"Cos", "[", 
         RowBox[{"x1s", "[", "t", "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"x1s", ",", "x2s", ",", "us", ",", "Es"}], "}"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.715598826533165*^9, 3.715598845667857*^9}, {
  3.71559892246747*^9, 3.7155989342177258`*^9}, {3.7155989914490433`*^9, 
  3.715599018014835*^9}, {3.715601573470241*^9, 3.715601578585264*^9}, {
  3.715601609680811*^9, 3.7156016306805677`*^9}, {3.715787774718314*^9, 
  3.715787792446134*^9}, {3.715788572991316*^9, 3.715788579654952*^9}, {
  3.7157897789676657`*^9, 3.715789845144174*^9}, {3.71679269242918*^9, 
  3.716792711357082*^9}, {3.759449466851182*^9, 3.7594494856246433`*^9}},
 CellLabel->
  "In[2931]:=",ExpressionUUID->"1ae5ff92-7ba6-4403-a0d9-3760f6b53e7c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1c", ",", "x2c", ",", "uc", ",", "Ec"}], "}"}], "=", 
   RowBox[{"ControllerEventTriggered0", "[", 
    RowBox[{
    "\[Kappa]", ",", "tend", ",", "clip", ",", "\[Theta]ff", ",", 
     "\[Theta]dotff", ",", "uff", ",", 
     RowBox[{"tff", "+", "2"}], ",", "d0"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.715598867496921*^9, {3.715598942464858*^9, 3.7155989482424107`*^9}, {
   3.715601639640037*^9, 3.7156017041659737`*^9}, 3.7157882850142393`*^9, {
   3.7157886106458473`*^9, 3.7157886163114443`*^9}, {3.715789851966666*^9, 
   3.71578985486924*^9}, {3.7157949268075533`*^9, 3.715794927390291*^9}, 
   3.715794990289544*^9, 3.716792704018694*^9},
 CellLabel->
  "In[2932]:=",ExpressionUUID->"9a36d829-8be6-4b05-970b-5c6e24f241bc"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"3.016134904445327`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 2932, 200, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229296538352*^9},
 CellLabel->
  "During evaluation of \
In[2932]:=",ExpressionUUID->"834411de-6c0e-4fa2-abb1-5f93848ce04b"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"3.016134904445327`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 2932, 201, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232292965417233`*^9},
 CellLabel->
  "During evaluation of \
In[2932]:=",ExpressionUUID->"9c17354d-d48d-430c-8462-b20ca30bcb25"],

Cell[BoxData[
 TemplateBox[{
  "InterpolatingFunction", "dmval", 
   "\"Input value \\!\\(\\*RowBox[{\\\"{\\\", \\\"3.016134904445327`\\\", \
\\\"}\\\"}]\\) lies outside the range of data in the interpolating function. \
Extrapolation will be used.\"", 2, 2932, 202, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8232292965445147`*^9},
 CellLabel->
  "During evaluation of \
In[2932]:=",ExpressionUUID->"c0ffa68e-94ae-4fd3-9fde-ecac3a183311"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"InterpolatingFunction\\\
\", \\\"::\\\", \\\"dmval\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 2932, 203, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.823229296547283*^9},
 CellLabel->
  "During evaluation of \
In[2932]:=",ExpressionUUID->"a53b0a45-17fa-4cc8-9ff2-22da764de42e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pass threshold at \"\>", "\[InvisibleSpace]", 
   "5.717011802020621`", 
   "\[InvisibleSpace]", "\<\",  \\!\\(\\*OverscriptBox[\\(\[Theta]\\), \
\\(.\\)]\\) = \"\>", "\[InvisibleSpace]", "0.5457916804085461`"}],
  SequenceForm[
  "pass threshold at ", 5.717011802020621, 
   ",  \!\(\*OverscriptBox[\(\[Theta]\), \(.\)]\) = ", 0.5457916804085461],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7157882950525303`*^9, {3.715788383140953*^9, 3.7157884092796307`*^9}, {
   3.715788470346328*^9, 3.715788515472332*^9}, 3.7157885854549913`*^9, 
   3.715788620525052*^9, 3.715788692018165*^9, {3.715788755584639*^9, 
   3.715788773708675*^9}, 3.715788845829385*^9, {3.7157889143665667`*^9, 
   3.715788940225079*^9}, 3.715788982836802*^9, 3.7157890611155357`*^9, 
   3.7157890916918917`*^9, {3.715789206167378*^9, 3.715789235914906*^9}, {
   3.715789443308707*^9, 3.715789469145492*^9}, {3.7157895076983147`*^9, 
   3.7157895259770107`*^9}, 3.715789568849544*^9, 3.715789606074493*^9, 
   3.715789657494897*^9, 3.715789794143681*^9, {3.715789841666045*^9, 
   3.71578985953227*^9}, 3.715793291126972*^9, 3.715793374667191*^9, 
   3.715793413086301*^9, {3.715793469195417*^9, 3.715793484077303*^9}, 
   3.715793533824836*^9, 3.715793612751347*^9, 3.7157937878627377`*^9, 
   3.715794482281708*^9, {3.7157945204321203`*^9, 3.715794538791453*^9}, {
   3.7157946424263477`*^9, 3.7157946612562523`*^9}, {3.715794730556242*^9, 
   3.715794792645007*^9}, {3.7157948230316668`*^9, 3.715794845187394*^9}, {
   3.715794881532124*^9, 3.715794909486367*^9}, 3.7157949955359507`*^9, {
   3.7159663448487177`*^9, 3.7159663711556587`*^9}, {3.716531791578785*^9, 
   3.716531813432748*^9}, 3.716532039829281*^9, 3.716533794896873*^9, 
   3.716533851542365*^9, 3.716792780720389*^9, 3.716793982838397*^9, {
   3.7192120623640347`*^9, 3.719212071971714*^9}, 3.7316920939256773`*^9, 
   3.759449454017942*^9, {3.759449491813158*^9, 3.7594494944134808`*^9}, {
   3.7935026913380938`*^9, 3.793502720848782*^9}, 3.793908436314842*^9, 
   3.823229296551566*^9},
 CellLabel->
  "During evaluation of \
In[2932]:=",ExpressionUUID->"4ccbc47b-56d7-4f6e-a562-a6e7ba5e881d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]old", "=", "x1c"}], ";", " ", 
   RowBox[{"\[Theta]dotold", "=", "x2c"}], ";", 
   RowBox[{"uold", "=", "uc"}], ";", 
   RowBox[{"Eold", "=", "Ec"}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]ff", ",", "\[Theta]dotff", ",", "uff", ",", "Eff"}], 
    "}"}], "=", 
   RowBox[{"SwingupCalc", "[", 
    RowBox[{"tff", ",", "t0", ",", "tend", ",", 
     RowBox[{"\[Pi]", "+", "1"}], ",", "\[Theta]dot0", ",", "\[Theta]old", 
     ",", "\[Theta]dotold", ",", "uold", ",", "Eold"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pff1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]ff", "[", "t", "]"}], ",", 
       RowBox[{"Eff", "[", "t", "]"}], ",", "\[Pi]", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Blue", ",", "Dashed", ",", "Thin"}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Orange", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], 
     ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "7"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pff2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"\[Theta]dotff", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pff3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"uff", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "Axis"}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "10"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pff1", ",", "pff2", ",", "pff3"}], "}"}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "2"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7156017293554173`*^9, 3.7156017717623672`*^9}, {
  3.715601811454719*^9, 3.715601852773734*^9}, {3.715776016638773*^9, 
  3.715776147664441*^9}, {3.715776277492277*^9, 3.715776456331561*^9}, {
  3.715776491289627*^9, 3.7157764939803658`*^9}, {3.715776543393073*^9, 
  3.715776580288432*^9}, {3.715776666851063*^9, 3.715776686302436*^9}, {
  3.71578779978259*^9, 3.715787801260087*^9}, {3.7157878465598392`*^9, 
  3.7157878689025173`*^9}, {3.715788007763288*^9, 3.715788011199992*^9}, {
  3.715789632632449*^9, 3.7157896352054234`*^9}, {3.7157932819669867`*^9, 
  3.715793284512349*^9}, {3.715793351717051*^9, 3.7157933519210043`*^9}, {
  3.715793606935278*^9, 3.715793608484182*^9}, {3.716792735868079*^9, 
  3.716792736314712*^9}},
 CellLabel->
  "In[2933]:=",ExpressionUUID->"45054d45-4e3b-43d6-8222-dc3b2ae5c2d9"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1nc81e/7B3DrnPf7OBycc5zUp4ysMhsqI+6roiKU1SIiOcleEVoIRcqK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           "]], 
          LineBox[CompressedData["
1:eJwV1Xk8F3kYB3AbteaHTK3M/BAz6UAqR862+hAlR6REyJkjKqpFobQq16ZD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           "]], 
          LineBox[{{8.720200577530825, 3.141592653589793}, {8.743229060566538,
            3.141592653589793}, {8.767710559935155, 3.141592653589793}, {
           8.873891832862427, 3.141592653589793}, {8.980073105789698, 
           3.141592653589793}, {9.178333957651894, 3.141592653589793}, {
           9.372697197154395, 3.141592653589793}, {9.583570987562506, 
           3.141592653589793}, {9.78034308397827, 3.141592653589793}, {
           9.890171439948318, 3.141592653589793}, {9.999999795918367, 
           3.141592653589793}}]},
         Annotation[#, "Charting`Private`Tag$1214680#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV13c8lV8YAPD3vcY1si8JlZmiUElDOY+IlFRGqVCkrBKSKEX4FUVJQpKd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           "]], LineBox[CompressedData["
1:eJwV1nk4VV0XAPBdNMiY5J5w7zk3s6TBkJT2qiRjZIyQyFBCKemVUrypN2UI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           "]], 
          LineBox[{{8.720200577530825, 2.}, {8.743229060566538, 2.}, {
           8.767710559935155, 2.}, {8.873891832862427, 2.}, {
           8.980073105789698, 2.}, {9.178333957651894, 2.}, {
           9.372697197154395, 2.}, {9.583570987562506, 2.}, {9.78034308397827,
            2.}, {9.890171439948318, 2.}, {9.999999795918367, 2.}}]},
         Annotation[#, "Charting`Private`Tag$1214680#2"]& ], 
        TagBox[
         {RGBColor[0, 0, 1], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQPbcuic0wpdtOQtcl5LcipwP77Ufqb+V32sP4C0/N
L3wtfxLOX7e+83aO3i04P93+4sw3RY/h/Lynmo+3rHsJ53Mptqjft/gA5/cJ
nNZamPAZzk+6HbKf+cw3OL/waEtSvvovOH9jAU+whOdfhHuqs18ZhDM4wPhN
8/8EfnnDCOczXH7gsKeKGc5XK0mrCNFihfOffJ0exr2XDc73eppVO6mQA873
ezJBW06OC85/dTip4cRabjhfT/CarHM8L5zPZf818c5nPjjf/W3Ud6VQATj/
xqEUxigdQTh/a8eROIWvCH4aa+mDc+eE4PzkouqtPLOE4Xz9dO1zPokicP55
IR3uUktROH/3uqbZOsxicH41o1bAmbsIPtedKo+8LeJw/tNlilPm10jA+VM0
JFl2hkrC+RNmpR1PVJCC86OmxJ7jeY7g/3BZ+nP+Pmk4//FTp4pD7TJw/iJb
Q+mzibJw/trWUsF0XTk4vz002Zv5K4Jvemfhyvaz8nD+DM3Za896K8D59Qd6
Z3jvRPB9pUOXnlJRhPMd845HC3Yi+PNlklTOfEXwVQ4vn+YXrYTwn+4hrUv7
EPy0zywXT2opw/lJGz8pdPYj+BMu8fQeOY7g7/us9vP/fwQfAGxfK0U=
           "]]},
         Annotation[#, "Charting`Private`Tag$1214680#3"]& ], 
        TagBox[
         {RGBColor[1, 0.5, 0], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQPbcuic0wpduOAQIc2G8/Un8rv9Mexl94an7ha/mT
cP669Z23c/Ruwfnp9hdnvil6DOfnPdV8vGXdSzifS7FF/b7FBzi/T+C01sKE
z3B+0u2Q/cxnvsH5hUdbkvLVf8H5Gwt4giU8/yLcU539yiCcwQHGb5r/J/DL
G0Y4n+HyA4c9VcxwvlpJWkWIFiuc/+Tr9DDuvWxwvtfTrNpJhRxwvt+TCdpy
clxw/qvDSQ0n1nLD+XqC12Sd43nhfC77r4l3PvPB+e5vo74rhQrA+TcOpTBG
6QjC+Vs7jsQpfEXw01hLH5w7JwTnJxdVb+WZJQzn66drn/NJFIHzzwvpcJda
isL5u9c1zdZhFoPzqxm1As7cRfC57lR55G0Rh/OfLlOcMr9GAs6foiHJsjNU
Es6fMCvteKKCFJwfNSX2HM9zBP+Hy9Kf8/dJw/mPnzpVHGqXgfMX2RpKn02U
hfPXtpYKpuvKwfntocnezF8RfNM7C1e2n5WH82dozl571lsBzq8/0DvDeyeC
7ysduvSUiiKc75h3PFqwE8GfL5OkcuYrgq9yePk0v2glhP90D2ld2ofgp31m
uXhSSxnOT9r4SaGzH8GfcImn98hxBH/fZ7Wf//8j+AAJ58LO
           "]]},
         Annotation[#, "Charting`Private`Tag$1214680#4"]& ], {}}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 9.999999795918367}, {0, 7}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVl3c4le8fx20H2ccJmVEUGRUJ+dypEFIZUSF7z3xlHSkrSpERUkql7MxC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           "]], LineBox[CompressedData["
1:eJwVlnk4VesXx924DVIqcg7O2XsfU2aFpNtwFlGRUqQiRKWkqETGBiQi5ZYb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           "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7SLjp7ivQNGBAQpkcu49VixG8Df/myjpUobgP1L+
2dJRg+A75h2PFuxE8H/deOl2pAvB3+LMY1Teg+CrSQZy3O1H8HmO3NqyYhqC
f0PyHa/DEgS/4KjIgbz9CP58mSSVM18RfJXDy6f5RSvB+RN0D2ld2ofgp31m
uXhSSxnOT9r4SaGzH8HPaQr+4zURwS8N3nKdZzKC3/G1tG/CNAR/neXP39Pn
Ivg/D/6/tmw1gj/hEk/vkeMI/qzFuRltJxH8xSXnnD1OI/jbxCb8On0Owb8T
JZxx+SqCr/5Y0vnRYwTfYEuV3JKnCL5V6+2fqc8RfB/1uRtevkLwi7IV5D5+
RPBrbBp/bvqM4LfyPrpS8hXBn7F+cfePHwj+ogaW9F2/EPzVgalONX8Q/C1K
x2Tt/iH4+z6r/fz/H8EHAIHxjpM=
           "]]},
         Annotation[#, "Charting`Private`Tag$1214729#1"]& ], {}}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxNenk01GH7vm3GzmCMNUvJEqFCWp+7hayFbElI1ixJSYSULclSEUmiVJIU
KWsea4XIli3bWMtW9jW+857ze1+/zx/zOdeZc+Y8576u+76v68wjaXvByJ6B
jo7uBe3jP+/HAbbEHXYRB8cmvaYMdOggtebJxTHxarQmJtRnXcoIWW/Df7oq
dqLE6wQVCokIjqjx4bjnADrmHYZOeRHAfUhuIDfrN7pfVtg2600HbJLBMr3q
f5EpanlebTWFoki121JtZtCBqIFIj6dfkO1PY8z4bR6lzB9aIma34YtVwbYX
ZJaR1O6swxmxVJztwXFSUPsf4n9mnfOIpxunXnMZVTajgwWtnSWG6DO++WTV
cHacHsyp/fqvGaoRXXMfFPsygny0oszEpwEkfdnhqvE2AhgOCAxTiqfQ4Fy8
KfsnIqTPrKp4PltCOkPn/e9dZIGMsI4AOeswfHwwRl5MjA1mtbuKUm1v4NEK
28Cvb9ghMNJtMs7WFyvytG46Ys0JasVb9DSjL2E2NHe2a4YLxhlHPiTFueFj
ExYLm01IoLLrl4PxT3vcXm5Hb6HAA/kXr+9J22+DP9yqtJKY44F2jyjWLUnm
2IHg1VdfzwuiVREBuupG+JzntQ8ciXygvG9HXGCILlZylK/XO0sGbX5Rz9x5
QfjOq8DutYcf0r3NFu1u8UFR1s1HCowUyCXOBd7IIsE1+m0G37opIMghlizT
xQlsXb5a7rkCsH1r0EvrIV4YeiEZ+8RPEMJLiqI9FNkgVlaIqcBECK6N3pP8
68oEMYkOX85KCIPhQ/lVzsd0YBF7pp5jRBhkz3zY//PLClo8+nzpSYkIxNx8
uX2lbR4NDB2+Wh4mCnLK6O7I02n09MAOkbqzm0Dnx6NJAftx9CbEi8dxuxgY
TjhcDqYOoDCTc7qMc2Lw4EE4/32hVqTalfoqrE4c0m84xR44lIQS5B69qdOV
AG7DV40vTzXh66WRCboFElBBLslnfT+I9UVMntdISYL4q6DJbz5/8SH3L6d5
wiWB7v89T0Rtpb7NbWCpipcPjp/e/D8cs718W1PJBnaYYWqs3rblf9g2e1oi
PHoDl8xIL62vb2Dmn/0yE+IFqIhpV7ClEANcr1HQ2WHdjE77fbRsVSbAE/ba
IB6NPsR3baxvhzIRzt/zL2mIGUZqz/gd1UwZoYxP6OEe0gT6rZsfQUlYQt8S
ZORKv02hs42ZOC9iAC3OcXsZUeYQOcDAWuhxGT7fMB5T4LOILs6q3FtQ7cM8
j752HslfQQMM6XqRP/rw8vspvk8ra2j2dSI95cwPfI9TJZl3Mz1IVTJPT14x
RwTV6yNvZwjww9lWkvHJHIp3ox89Hs8Mln0sfj3Sa+jboL9x+zFWuLzl5aeT
ssFYtGXJZGaIDb6pkJX/aQfgO+dFv4eEcsBmjxDWt3lXsGj6EI6W44IYBZlr
Vxgu4m93TGR5vnODwYePmoVuzpjUbu1XUkoCuxMVt5+22uLPz8nKn2J44NdV
OxEODUvM9SXpycJZXmCK+J7TpWCCB/ct1rip8IGERTaB9/UJXO3aXJb5jw9Y
hs0fta4cw+vFr8dt6sjgN/ZUX72LH6pszJoNkvlBTC5fv/oXD4iYt3r5eVAg
4B4qs7LkhnJ3I71N2gLQfY2X6T6DIFw9dHwyVFAQ/HxMZwumuaDYcZOewm9B
UPw4XnSjggj3qNies0gIWsqfiZ8zYAAvgX6dvCBh6N8/yxrvtoZeudLbtRqJ
gPkFhk05qkto2G1KjP2PBBz4ZffVLXsUfzkaRTdpKgmHgt2dUdgM9qgil7rj
Df3FNHFEVn7Z0E/zilPsX/FXSFroY22SCj00vF1lkPnzHem8a2lyDWOCKwPR
U8csu5Fmis23xd1E+OUkk9lDP4S0zVboqm4wQYKf5EFv6zF0o17oS4TtPzTW
ZZL+nWEKRQf9PPeBYwwdCZr47rNvFg1qdpn084aj4R8S6T1PF1C+teDNS0Nd
+NC7F8kdf5aRzfOjg2tuVGzKe/39+c1raEp828ivux04sfJEZWoxHZR9Lzea
v/sRP2iZVmKIJoAXb7mr9asZVJKtJ7F9GzMwirvwhPSuIHb7WacPXSwwnpIQ
eTs3BKtaVpWy3GSD9M9bOcb3BOJ98VhGRpgDZN+634y7dhU/7+p2d67khPzP
GTa+BzzxmP3WqitnucGuxSU63M0FZ9p2F/y9TQIQ88xK0bHDJ3KLEyKseEDw
RIhKkJ4V7n+pvB4hzwsGMRH2/5pN8fOUjybJ9HyQv7IUqbpqgB9ceFnUVcsH
7wzdf4lka2OBey7dpvFkOPVa7cOx4wJQU3DoT78LP9hUJxuuv+IFl6DMWy17
KMBU/0N4XYoEYuoH6y/zCUCu3sz703tEoCzK7pHvsADcMHeUY2HjAYMw8b9D
OYJguNu37Z4WC/CFjKucuyUEMw+O1d49wQgMp6TCOYyEoYgvhMOmeh3dDFR6
OCUqAsLTlO49V5bRznh8Wr5FAhrqhRY1MkYw27spo64DkuDPXMektDqF24Um
OSFtQz9LZeutL15v6Ic36SvDVFs5cuAmqCjNMgDlwE/e759bkVLhk9WxDwQI
2lrPtf6TiqL/drI5zhJgvKi5oVz8F3pkf7Px2zI9vDFeevXuwTR6xRwQr1va
jt447RSWn5pDL4Q3Z7EvNODJmnyfWIMlxHfGePTyLiqmhoxSsgJXUZOQrkN4
Zi9ONrG7zP1jHfXPhvszhjbgy3HsT86YE0GvcejsctIC8pD7+N6DiQVufkDy
F3eF40g7ZljJYQXzBIb3lvk3MaOe4li3Njv8ffxkgkvDD3cf8LkyOM0B7xi7
C03JXvj+pQnSxygukI2xIF8tuIBbO8qrTMRIYHnOXW3vfUd8Wb//4J15Evjt
zh874n8WH4x3/TJZzgPK1+UvW9pY4L3DLHAugRdce5YnrNNOYqm2PXDAkQ9k
j45tzQrRx6vO61/8lMjwKS86QOOtMIyMjK2cZ+SHgJeXOyWSyFDK7JZX0sAP
T8eIetXAA7UKdOekXlKghPlGQSrtXA7PHWqqAgRg/KJ8hhbiB8XZ3Yfu6wiC
b9i5+0amNJ1riaR7igtBPJNExvHbBOA5eP9B3oQQHMx67HLThR4Sj27pH2WV
BL2RyYdh1RM4uGNb1vqFDb5lBoSO9A9s8O16wMttQfwhKhnq9x7GdKB+4Pje
8LBvaO3ugKqyDBPcq77jYFH1E31fOb6SI0cEWePVp/Z7B9FSx+4vrIwEYMx+
TqKEjaLZ1klnuR3raHlt3LHt8V90+0fR60vUSfRL29Kfs34G9e8gyX7wyUdp
7YW7Lu5eQFfiBbsKvTtxR2FcYFrEMvqe65+8L4aKg8s0gso+/EM+t4Vf3XP+
icVSzpj9DqeDnjXOJYvuUmyVpmD82pIAk9LDVm+yp1HjSc99STNE6HrwpXFz
6TLa9lxpZstLFkgZO1/3OyQUH5aQv8JnwAYGHSXTebWB+N52npaFAXbwaOQf
DDvvg0fnT2m23uWEvmNktgsDntjXKPL+q23coBKoQWfh54qXZZLaWT1IQH6m
9/gQtz2OLSLVeWrwQMK2aBs+K2usl7CsaEriBfWmiYCv780wsZn/kdovXvi2
RHfyWrwhXvW4mz+bwwfqMLCoGa+Dn/nV/jD0I4Od3HxGkIgg6A2r/XttxA9K
GvfHj/HzAd9DgXuBYhRYfc/Qr+5Igm+iKtEpizR9NBVdU2fcBA4f/ly8XCcA
Td7xPD8neEA4XqK8PF4QqjR/qAkpskJL601RrgtC8DV3ZGh/JyNU+2jI7t4j
DCoXZ417D9KB++3Pu9bpRSCR93d2rugKan8t7Vv0WQL2rBnVFSoM40z7LX4n
d0jCJhuR9sk9U5ijsjM3/cGGfrL2LK3EP97QzwPWwgcjjhiFPxRi1L/FADWM
wYp0fD9QwXtxR9OrBLiboKd9i0RFtmn+P7iEiCD/Mv2LtvkI0u+w85x/wwDF
V2Kc83dMo3rlSJXsxl5kpJT6pSRoDpXw+76UkKzBmXVGBJmhRaS9PmjIVd2H
fWI6Fq+KrqK1r9LTfLZ9+BuT/FEHp3Xka/JT4jlTM95vr1FBlCbCz8wjltNJ
8yi49md9bx0z/GqrSBQ+sY4y0w7XOPuzwvnKf1FTrkGYRIpN+SXADsbL+yZJ
R/yxSkvN5g/FHGBnXzDO3++F2yOdf2225IL6FupvZjcPLNYwr/CHgQRaXV5n
Vq854XLe1DPPf5Kg4US0VIm0Lb6ZXLry4xUPkHy0gm4eP43TWpsubPfnhVta
T33+2BnjYNaHIT/0+SBh7F9j1P3j2Nbld2UshQzfTKnu7kkicKlJd9b+Fxme
xqXxHlXjh8MqtlVhefxw5o3vye67PHDpsItrQwQFPlqoFDVNcQH5tmXE1DkB
eOau2yV+nwLNwhUCkTsE4d6S0tpkLCdMm4n6nmASgs4r/yyKxIjQFC0XYNsi
BLFJ3ZIjnfQAp27TXVuVgAzef6x6+8axdLRl25VzkjATZnp4m8Es7rLgc2r+
scG3yt0f9ravG5H+n7Vp6GMCi3/3/FRnetC26PEIo71EeOVv9MGsegh5W6t5
BkwzQnJxwObh9Fk08oWw6U3FOyzbHCqqx7WIhMmfZVWmevCr53nFXMYr6Eib
caCBEhXLnssf4IteQ9wxl/7M32nDGdwyhBIbZih8auFUQP8PKbt/Kqkc5APS
lpCUj01aOOIl+9DpHDJwbN26nBVFAa1IPapQCD9oy3M00WnyQoXboeuyJhSY
1A/p7K3nBo+TWpzaigLQsGxWNhQlBKJOHZWB6wLgvPWPcZ86CUK9xcRY6wVp
/an3BF1jBqdlLGevIwneH8lViaXT2PbKzoXHvu0oyjnEq+oXzbfknGjxetmP
crPfkIvLCJC803Y0fWUa1cweiFeYaEQsTytc463mUXKnx8WJGy1Y+avYJH3x
EgrNM9L7eoWKta+tqAwMriLWx6Q3nq49+ExYTAL9PhbYWXjZfuDoLfzAib/W
TosMxC7+Htk6IdgiEHfqajkFjIJcvQ7u5ILbdZnnH54ThOTe39fbVNihf8tS
8C2/jX71dJEQm5ra4O9xaaQ4QSIcKQc1+iiH0NFy5YJJYXMN2uYzZh85ywgp
+9lTB5Y6UdSfqDkNml6+VjuIvWodQJ4Bxl/EDhJAvXbEZ0h4FDE26POZstIB
Q0z+sdMuf5HKi1EBD8e/aN8bPmOz+BnEWRoXbtRehhg7w3wK6RdQ4gK3zjXx
DrwVIqfCTy2jIDzCe/gBFQsLyY25Xv+HJm89FXp3pAv3RQ5KRHrQwcj8aWJf
bAU+fEd7+PoRAqhFKEolq02jTilC9cl2ItTUNuZ47VhGezX01U/fYQG1DPv1
W1OhWIuhp0FwNxtklry0DKXcwCWLe7b1fWWHYTMzIYchH8zBJJhz5yonFEtO
zySqX8LlWmXLh7m5IcHg2b8XzG445faK4wNbEtiYO183v2yP1fBex2F1HpDw
/KJ6edQaB8b0ahYx8AKpTu9Kj7Q5VnOt+nTzJy84lcg2K44Y4ncXiXmBL/gg
XWTm9BlOXfz74orhd3cy3Gi9XGURJghRfjuCSZr8EJITs9BEmwMjW+oetJIo
0OCiWqZC86VS3G8vqI1RIMUs+K7R7CbI11I9M1VK6++nqp8ojrxAJy4pv+O2
IGxTmhouzWCF3HX9mHO2QiDToVocuZkJFNhavb8pCEO+l7rbBTc6sOPmpQ+d
FYYU7yz5zIsrSEHNIpyxVALyxzZzOl8Ywn5QTOKWl4QV5tk/iR1/sbSQIUt3
9IZ+bs15RcU82NDPcc/j1qNHipFGcIfsdkMGkHI0Lxbc04Leu5y0+WxCAMGm
iOFvGX2o65L4Hy3aHK4R5TsSOTuMGpd/RwQzMkIls6X2/vUpxMvqVWaQR0XP
75kns+jPIULqixX6+SrM/l1c1+PtIhJI0szOCe7DVfyNzlajK8i1O9t8KrkP
n7PkyuTZuY7yldu/V6u2YAl9W5OfHLT9f/L33vxN8ygqyd0yPocZnMUyDsYX
rqHiozbcqbascNVcq6WyOghTpjVXJtbYgG6LX4ldlT+2eTJz9XEqBwTsu1fS
r3sFLyfKGHcc5gIjvYdUgTwPHPxAssx7lJY/f4eFfpxxws5edBM76kkwfnno
fK+/LZZ6Ohqn/ZgHPPbTa378ehp31OeF3bvACyr2ygVzX4xx7lOtdMlDfGDj
4e5GETuBKa5WFRJsZLjU7jjUShGFgi/XPAY6yXDcRSM7P4wfgmss9cYzaPPL
+/mRu8U8cKxO4qJ0AAXW5HrFpKS5wcWvzSXMVABEH/vlGR4TAOksFka2rTRd
BcW31CEuaOsVHfg0LwiX5/Wu/nYnQk7+7FTeFyHY/cP5cieZAe4PfOKumJOA
vY6aes1eY3jeec5l5xlJ6P+ntddlbAZ/pMQs19Zv8B01+2rGt7EBqRHfWzfm
MoGTB09eiUwPOh1pIJZJm/daM8XKj+yHENeVRImmfUzwV1xtSclzFl1P16uo
WH6Ew1pO2sa1L6Cp65pCfcvdeG7b2+2zkisI9kZekDCiYlz4SBebr6Eu0tzb
mdh2nNtXcM9LgxnIMqPyRzxW0YD7zk8G7Xyw2MJfMgvauDFp39mONDJ8YJ8X
qR+nQPiWY04BV/mBM2a/rLg3L8QvzgcFHKNAX0uiYDqBBF80KiZ6JATA4NI/
IS0bYXBfEXv3b1oAoq4Zayo9IYHLuliYd6kgxF959p6jlxn2/DAvkTgqCbGW
Vx6LWU3j4g5iyMeUNnTho/qZTw0EWB2Lulh4qB/dIorUdXQR4EXF9hqF6mn0
tftSj+HxH8iCcO0IVWYeFdQEPZr+0oSjq8d26YYuIc296ptGTlFxHN3M8685
q+i46N+Xxty92MF8i3SBOAtMtuzPZiu6hbWdb1f/3UeGVCZwqd4vDAupOlb1
uRQQpRqlJ1tzQZfNtAnFTBD86lezecrZ4f3aXaGjVzb6VU/m8bvfoxv8BZty
KTTGdKH3bv7yOjuJoNE2MSHjtoCcgvL9Cwt+4kjVZG78aRkpv9AzL7tJxV7b
CrLYiAIgcUmFUVtYFDxS3qaMjP9As5bC6S4JBGCz5sw8coWKJr1ygy+xEEH/
WwjuFl5CO519rA8wUvF29v6w+8dXUcium3slxfuw77LWIdnftIy2093dfXAd
vT1/+TPLFjJsDUr1D5USAZPcisNFzpKw+/kL+YAPs1jvNvlwZkkvYrCRFexU
I0J1Y0Erw9FFpOI81m1a0IvPSJTqyoWuIPkXqqeKCFTs56ZVqj5Fy1+Jz5pP
OWhhFj4r5xDjDiTfd+j12D9aTrhK2r2DcwAZk6NT1p4SoOGzYXr+1BI6Je2Q
pn+bik/c6TXe3EAB9wGqwEUiFyS8fRaxuLhRv/XPJUESEj5orpi5rcqRDjQd
awealqoROnjwzAuav5a5onNQNrYTMecdlw4RIEICk2hXTdoASn45JbLHggAn
228p1g3+RgYVL06MAx2Emifv3mT0F2lc4P3DMfAXDVpdQKvXZpCn5skd4XmV
KMfCXbR3eB4JqLOaMru041oG1gw/WEaFbQsRrrR9OVwp/OSw3T+UfaksVTmz
C5cypRN6z9H2cNzkUPlYJVahM1caVSNAErnRS3tpCllH1ke/rSGCIlpqsRpd
Qof5uzrnA1jA16LaQlA2DOte2h3waBsb7H9Vw39+/w1sbHXcxLiIHQSPJgm/
3+KLH7MtjIy4cIJw/YEDpecu4eEjp7Oi6bnhllLduu5xNzy77/XbrtMksHO6
q/3wpT1mLjuhkrKTBxp2B6Z+EbTBiRxNTRMrPGBg6rRv71lzXK++6bvsD16w
mZ5+GM1thNmm4aNmyn/83IsaBW1dfMeVj8TlRIaxzzXK8SWCkPUl60s5LQff
4Hdc6DjPB4a/ZR7Ss1Hg2LNaReUkEhjcGre+MUiBnotP9q1eEIOzvO1NbwsF
IOuikX/8c16Ytk21dgoShJ1DjwJzxlhBKnaXDpelEJSXxVVeO8YEVkbJ4vHS
wvBes3lFhOaHehvzHKsnhGH29pv5R0kryHRlJuZlMW1fKvCZifAM4cE3LD/H
ZSRpLoag/+zVX5x7hGOn952N/vM6mdvGcX9DPxkvEirGsgtRkKNJ1SlVBmhK
OMy49VszusM8kpVA8zVd7vKqf7z70MDE1egX8kRINPtK97Z8GHl9mNyxbzsj
aDUc2rM2NIXM/mpzNqT0o+NHc8Pf7JhDHwy9So59r8CFJ4iTsbGL6HfAYf40
qz7s0q632bBxBV3w4tNhK+rDiix0NiOUdVSVEVf8tqYF85Z5JGvQEcH8+HEp
/Z45xEtQ3zKTxgzSF3q6Uj3WUCX5T/Z+E1aQcLY+3rIYhIXOpaR7TLOBcv5i
mSNzAJ5nYknjieUA4WcM9rduXMERqcTbKmpcQNGtX07q8sDpd4suV3ZxQ1K9
Ubi7sjMuln6ncvULCURTa3Q4Mmzx3LN1W8Z4HvhaV66XRLTEszoZfFVOvCCx
SyxMYdkY611IKfiylw+cPAOYNOxOYI/xhPJhRjLYjpG/jRuLgmX5fcXNLWTo
Cc8visvmhzT+zujkNH6o2UPsu9bEA9n3rl0y9KbAzZefhBgPccODObJl0wkB
oLnUX5xpAvDd+/XVr2KCcINhUOJgAhfUbHksMPeHNk95soSeJRBhs37na9sy
IZg3CpZ22UnLp+lmAo7TEkBHybML4BvDVm2H1EgWkqBg9oBwpGAGP7tcf0Sr
doPvfdKxe8PsGtDlpGley2Qm+PPKwJixvBuZNIVM5+whgqCi52TxriF0Q+lO
1h5rJkhsvDvYYjqLMtdrfMiPrmM1k72Ewk8LqNg/aXDGsxs/mtg2PMyygozt
rl//a0PFtx0i12MP0PJRzmxPM7kD79EOOtW4mxmCvzsZ1Mmsov1/XIspTXxQ
GjTyoeaqNr4cf1JcMJkMQxxBj8Q2CUCGe+VrZU9+CHzN9s8khhfoSwxDXwEF
1HxNGZX4STBdQtcjJywACs+jdnfUCoNgVdnW4nEBGNpx2ZWlhQRWR54UZRUI
Qo78siMfHws8Pfz81hpIwgvWwVP826exM/tUbfmuNsQbM62eWUGA0luKpV1c
/ejwQPFNnt8E2HaHr3Dy7TQqY89+pkVoQ0x5rYqhHPPo2giLtGV/Iz6o09R6
wWUJuUXuDxg4RsX7Ktytih6uok85er3m1r14rHR8nMzLAlHyz6zm5m/hp78r
v35UJUM2Z+rhN17CcNbxuc3SGwoE8vB+H73CBSHb4mpbDARB+dmZnfrsHCDq
2jMgeWmjX/eG/FyyH9ngjz1Gv5pfvgvNRuh4WCgSYdasJUbPaAG5PjzgGSTy
E+9aFPqanbaMnufZofO0/ZHybD7ZZJ0CpDfcM58iRWFT08ORmes/0EwaiSPn
FgHqVzKX7Y9QUdRhCTNFHiKs6rnaMtAtoef1HsxOI324ue4MhKquos+OxWEW
h/rwui0vS/BPZshwmRbPeLiOWMayqupFySCueKxWxkYESiRJnA8dJIGopxpY
dnMWN1ec7P1r3ou2ktYOr6gT4apRio+M3CLqFHtn8c+sFzMO7GMSdVtBY992
5Z8WoeLWiZt4bZQPAsmlEXpJWvjDUa13d0faUVmanfPHGQLk8L8LOdnZj0iZ
n7SbcggQeExdt7t1CVmkU/Te36DiAsO9ZvrVND96a/WMtCitvpz9LZfnNuon
xPiN8Yn1T8SQ08dnKkWE6/48e+I9l5GcbA+LciwVL8ZdvD42RYHyQ/mvP/lu
AmPV8fiM7j50jVYcAQkiWB7fk65bs4iEal6dlkvvw6wqz+P2lTLDa5aBvZhp
HRWPbam0IJHhmIaqpUmHCEStpqca20jCO6ev+/M3zWKqWpOQb2QPypkx4uun
+dP2k27YY2YBvaAOc+z278EnnHZ50e9bQY/2MS7dP0TF3OmiBzM421HkZyZB
0W5avj3xZ3PC5X5kIOs38+k7Afq0CHelU5cQb4acQ6gzFf8T/R51Z74LuQr8
K7+uSoQRz81m31qXUbniCXNNHyrWLHc7I/mKisw4fGy71giQrPtEtEB1CQmc
rvkXK0rFc3ev+36bZ4bIHW/JuQK0/K3pfbXbVRKmg8Z9bH7NYtv08027ePsQ
1+0OholdtHk0wVnmucAHKSuZgd3KWvg09dJmn7IOdE4YT59lJsK2Lo9fXDCA
DI74rK5FE0BC04UQy7GMdry5Uvs4hoqHPgcbLbRSQFy7qEZ0ihNeG9of9lvd
4KuyWULPTMIZcba9uMp5ig5mEz5s671TjdbUyluj6hhhlHf0js7ZTlQ0kKk1
wEcEuqfzhT8jBlB4/5PXvxxp9bHqYCmr/o0qUpQe3bSkg6/77yoFaPxFgnsz
OkYkplDB7k0fjrvPoIbzfw6Gyn9GbI+obhc75tGfHK7MfK52LDaoSZzftYwY
xq6dqo6j4m+JfD5vTP8h2Rg3Z+3eLqxcyroYdoYOKj3zvszFVeHte3tPPlEm
gNb3D79ed06hp4d2XequIMJKHRkGPtN8tv+WzKNXWYC87pAUcyQMf5MfbLGU
YgOnDHWbayduYPG77eejctlhZ2tPDs8RXzwcOXwzzp4T0qTPbPL2uYSvHpJl
+bjMBZkfWL71XHTDyeSg5uvmJFCJLPBzLLPHfw91Cvsr8QB5WIYuc5sNTtep
FQxbpPkbuj1jSQHmWFi8um2lkRf6bpqI9G8xwmo7ez7IPeaDvh52Xk1HXdzj
LH7hjR0ZbI4/+xjeKQgH3dx+P9rPD6J3bjRH+fDR+tpEOJ5IAQWBgjX95yQY
PsreLk2lQIdbk3tilhioeb/ijM4TgKm6G+eMqnhhPJi6xBgoCC1xLEZtHGxg
aSX9csBcCOr4L7FutWAC7ys3L/ltEQbltFBljrt0IPqeTcRlVBi0W1djduSs
oNHu0tilQgk4Vi/Fyd4/iBMGFUtPS0vCA8+Ixfd3/+Ll9t+albc35qXrzZOr
Onc39NNe+slr/FcB4jhqv99GhgHSs/OkX8c1Iw29gkHtvQQ4eOCaZaBVH7ov
aGhDpM1ThrmnvfjVMGpUyfFrOMQIt3NVdlh3TCErnydcgpQBtGWT7fr6ljlU
erT1T3JeOeaN8UEyYYvo9CE8marTh0sKbgfUVK6gnSs2/QFf+zC5Z3GPEes6
qvz+5/wu8g/MsbJQvrxEAOHw/fRpJXPIuCCJKJnMDIVNN+YKdNfQVz+1oNvH
WSH2auJ8CCkYJ4ror+8YZwMttiiBFNkAXLb7XoFuJAcM0oeERCRdwS1S81L9
SlygaSG/+fofD7w3+lb96A9uaA+2+0l/whk7rIeZi1SS4OuHXco6pba4R+q2
dt99HkjfWTZcvtUS04c/O2Vlzwt6l3SsvPhMcIKJXnniblo/35FKjQ87gZMU
1Mqr6ciwYPVdcftlUcjCTyLLGshQw6otU/+ZH1SKErK9U/lBy25Y/EE3DzjM
pc8OX6IAXTBSSj3ODQo5u1q89QSgtHOGWaBZANK6/N6/FBEEaX8Xyt4qLqjQ
6M6OGRcEZpEDWybeEMFCoI5FvUQITrZsFbE4xACGEVIiBX8lQKn7VJxb/yjm
5XISuW4uCQd2Vr3cnzKDE5+5OYVW/3//DyJWK07FBvTngpLvzD0myNH8+3Rr
dDfK9FbpnqDtn8Bavbo64SEUF1Io8ciDCdwzkIWM9iySKBjzdFC0RVFxb0z1
3i2gnNFxmWGFbjxZ73TYZnUZOe2P2ffOkYo99od2rCutIYMLUxb5Jzuw37+R
/evKzFDBKRT8jHEVOSuxFS/V84HHLsv2gVht/DnWOiAvkQwWSz4L8aoCsJcc
VMd6gR8K+1+piT7mhY8S15nRAQpst+Bo4txEglvXxE2/UwTAJnZt8TSDCIzL
3bd59FsAjrW6qg1MksDMvtdE56MgCF7os3m2nQVMfWrd3JAk+B3obnlMnsYg
5fBH618retLB/ZVaTIDNZgEjbnNUtLg107V9kgCuHsScE8+m0dRHdind/jbU
Hh2c1r42h7z5XjK6uDXiB7c1ZBmsllDbYcGlpQNUHJWWWagSuYruGZnp64X2
YkUvw4bD7CzQ8IpNUpI/HH+Xs/36cCcZIsor6c/dEwZKTRM1KoMC6R95avNv
coFFtAMxV18Q7kwFbHmgzAENT5mqYy5u9Ktyrq9Y2tAGf/UKEwLqiz/Rj6yo
0E0KRNBLONbfc3QB+dfoIcOaThzaYSYln7CMhN8Vq0VFUrGaDb/AygoFYjPP
7dr7VRRmR7nYfbV/oNtFBzUSAgmgXLMquSBHRU+9XUv38BPBOLL3fez0Ihpp
0ZO5096Hpd8+SlqXXUVqnAdjRgz78GEB77HsFmbImTxXf/ryOlKV16vKFiLD
cnl6iVqACHiaq00z20uC5ccRtYvOs/iBzcx2Pule1DP2nbGU5p8b7vHVFogs
Iun0Xs9jW3uxaaWPTZzNCmLSthiN2ErFjIoSmDpC87/A/8gzTwvfOfOpWSC7
HTGcl9hhQuOHPLieOVjajwKyrHXsCgnQHvY66UL1EhozEdK65UfF7rmO7f1V
FDD+SJzeKsMFfvtvLOXMbNSv64mLUZnCT7Q2//6InSQRmqxOxJEcllHwnhPv
vGj7K8ooZiFmkuaPzq62auRtgo+M+/G+yj4U807qmc4WIuRGZS51Fy+iKcvt
qaUP+rDeL1Yf5wJmUD8g05PWu4Z+y5dVHOAkg9zNyu2MiyJweNf30AorSShd
8RWLZJrFac0XnZIselBgE1NaL83fKMf2kRiHFxBr42O9kv09+Kn2xUZfxRW0
ZljvyqNDxcOld88qt7WhgM6VPYxtBEjchHTkTvcjlwb2IKdWmt8Jv9qff38J
3RM36GawpeLSAvfurIouJKZuYbtK8x97jW3ea9Qso+ujhRUHAqg4PeZTcE40
FTGZyD2qYCTCfASvu67sEnrZzxKmTqJidc3BM8t/mMHgOa/ONBMdpPg/PqPn
Igk/BoUfjdbP4lsTl2fCp3pRS9iwgj/NP53Y/rrUZJYPEipXxu/oauGdy780
1m93oNOuYf0lDES4k1HKnSI9gAS3375WnEiAq6E9ptLrS8hc4PGDEpo+E+Vy
mu80U6AEf/xTuMIJTwOZHAuXN/i6Klmrz6i/jMYfP46JfUDFhbV1Iz9HKGDB
JeE/uEMMfFN+clrd7UNWR1m28coR4UjmSjkjMxlyznfi76qioMCZTaDOdiP2
XaM1x2j1Hma1Dum+uoTufEKaOw2pWGvmje/MmS507Md7F2dlIvRRulzUs5cR
ZZnDoSGUiouz3kiZ9jNDuGrLMwJeR2xjv2W2OUnCSuiIlEjSLCbJ5MbUR/Qi
9aIVFiba/DQ4ZmNVPtOP+L2zGgivCSDLXLWkM7iE4rx7t+rQfk8hqblr0/Vl
xBRPqr54j4rFEnfWmpX2IMX+0C3vaee7xXIPxWYtISOKY7ynBxXvDVSC83Ld
6MakIF2LGhFyuoXjk/8xw50dKNVvGx2okwzvu7tLwq3Sivpe+jlM1yn8+ql8
H2IqSTOR20njN9OjLHqZD+h+fL6gS9HCXzkly/xPDaCUvHKTupsE+EpYfE8v
vIzmM5V4x2nnUbYzazzbSYEGuX63B8OckLv586aDaxt8NG7/HKSqN4v+i2d1
D4rbStD/73tRmR2bHZhY/odLdze2/ue+1n/x8U3sjBq94v/D/71P+l/8f8AR
TNc=
        "], {{
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{152, 677, 41, 42, 538, 396, 281, 186, 119, 83, 570, 
              428, 313, 218, 151, 43, 539, 397, 282, 187, 120, 588, 446, 331, 
              236, 84, 571, 429, 314, 628, 486, 219, 611, 469, 657, 354, 640, 
              498, 666}}], PolygonBox[CompressedData["
1:eJwl0Lsug3Ech/EeDA5XQVv34JDQugBtN5U4RSUMRFAhIg6RWMSimCQtV+Bw
A1omBhYGQ+lCIlIWq88bw5Pn+/ze9D+0fWIuOxsJhUJhrKAsSjh36EPNrQsx
t6LuQEVvIO12rQfR0M3BO24L4f8HS5TTd/YQRnRSX9j9KNjv/Oqet5/sSXTr
uD60Y5i361x1H7Ufgrewbjd40z1jV+w9TvMqf/IRf/s+wy/6gKd5h3/5hFt8
j/Ci3uUwB39KjYtc9n2Y7/U+53iNv3jUt5R9aSexbH/wm/uU/Wzn0aMT+siO
40aP6cfgDWzprK7aGfzoVkTdlnQEp8FvMOB2pVOo6150uh3rBG71NtrQ5F5w
i+JMj+MP5XA8xw==
              "]], PolygonBox[CompressedData["
1:eJwV0Uc2Q2EAhuEwIFESvQzNtAg7UKJN2YFDdMZ6OXrbgOjO0cvMCgx0hhZg
BSzAk8Fz/v977+Seeyt6xrvG0gOBQBpLnBonLLt3Ox896OLXziNTm7AzOLN7
aaRK39UqebJXyCeoT2qZnNt9NFGtJ7Uqnu1VCgjpU1qQCztBMzX6nlbNi71G
IVn6tBbi0u6nhVp9X6vh1V6niGx9Rsviyh4gTlQ/0Gp5szcoJkef1bK5tgdp
pU4/1KK825uUkKvPaTnc2EO0EdOPtDo+7C1KCevzWi639jDt1OvHWoxPe5sy
IvqCFubOHqGDhtR/0+r5sncoT/0zfVGLcG+Ppt5fe7Dj/KS+mf3tnmDR/c+Z
dHZ69g9V+DVt
              "]]}]}, 
          {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{674, 675, 665, 497, 639, 352, 656, 467, 609, 200, 
              484, 626, 295, 410, 552, 63, 228, 323, 438, 580, 99, 166, 261, 
              376, 518, 15, 132, 199, 294, 409, 551, 62, 98, 165, 260, 375, 
              517, 14, 13, 12, 61}}], PolygonBox[CompressedData["
1:eJwt0ckqhlEAxvHPfBWGzy0YF6YLMJSN2QKFMpciU2IlyZRktrHFDZi2Fqws
CGWjCAtRZr8ji3//53lOnd7TG23oLO+IjUQiMZj795ZhE0Wo0zfwg55waEui
J5TqhyizjehHiOrzSLfl6rVYxze67T9IlHNQgzV8ocv+jQR5GIdI0+cQdVe2
fo0CfReFtmp9FZ/otH0hPmzOXuVxbgl38AW38qPze7lfLuEDlMpD4U3yUHgz
n6JePrDfyF1yKk/wLKdxlrNlftZHuZFn+Yyb+Mr5At/qvZzPk7zDBVzlfJEf
9AGu5Ck+5ipeCW+W2+UPuUP+RJz8wmP2Zj5HS7jHfif3ycW8jxJ5MPwH+QR1
+r6eIs8gVc/UL5GnbyM/fEt4G97RbvuI+fv1kQHsIVmfRooxQ6/AEt7QZn/H
L81LUDU=
              "]], PolygonBox[CompressedData["
1:eJwV0rlSk2EYhuHgERiWJCigERRbSdgOgKyuCDTYmFJmCIJ6AiICFoIKrU3i
RoUiBJdWqCgQRQsKCjZtlaHkSnHN+93PDwUzRHP57sETgUCggiIFUeSidzMX
OE8TjXTzgGUifukJtX7+nL7BfUqE7ZNEfIvqWX7TYZuj035d32OJkG2CsP2s
nuEX7bZ3dNiv6b9k9FeythG9SI0eJ2Q7ow/p1av02V7oTdr0W9ptV/Uf0voL
Gduw/ki1fkyNrUE/5yettje02a/oA1L6M2nbXd3vvcYtvaC3vfPeVeW/0R1z
q9163166R3rMveNuMeD937ce7xV69TP9g7h+Tavtst4nqT+Rsg3pD1TqR1TZ
6vQ0G8Rsr4jbs3qPhF4macvr9wT1KJW203qK77TYisTsGb1Lly6RsA3qeU7q
hwRtp/Q/bupv9Nie6tveG+T0ut7xHvG+VP6/cgtui3sM7ulMOw==
              
              "]]}]}, {}, {}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
            1.], LineBox[CompressedData["
1:eJwl1ne4j3UYx/EjCkVmS9axFdlbQiGVdVR2ZopC9sree++9NaymnZ1R0aAI
EVpmRpt63Vd/vH3u9+f5nXP9zvO9n+eS2KpTUsdkCQkJy25LSIj8yz+v4k/z
bDRACWR3faI+G7byvlAl/M074C/zHDTEoy6s0VXECV4SOXSTeHZ8xJvxg+am
eJ3X4h+Zn0Ev8y/yov5l8zHzSxhiviGT6/+R8cX/NnfQf2eea25kPmAeLxvK
vvKinCkbuV5JruVj5aOyu/xRTpcnXW8jj/DJsrUcJK/JObKU6znlZD5a5pCv
ye/lNtdeMB8yN0M/8+VIfW3zNnMt9Dafl5f07czfmqfIl+VQ+ZucJ1O4ftPc
Cf+Y56ExHnNtna4SvuOlkaibwnNiO++P23Ervh9umuejCcrgDvyr74xb5gVo
irLI5XdN1SdiBx+AOrrtvDYu85QJ/x9+F/6vcWGcJyrrFuEd/WM4pSuH3Lpp
PBd28oGoq9vB6+AKT4Vkuq6xhFgUfy//xNwIL/Aq/F1zZfQw/yRP6180f21u
g/I8D59uzh1/o/mM3KVvbv48fhf6m6/E+errmXeax8m6so+8IGfIX11vL4/z
qbKdHCZ/l/Nl6rgVshsfGc9Q7KU8JafJxXHf5ad8gmwc+y4vyeauVTW/Z66C
nuaf5ff6tuZvzC+iAs/LZ5jzYDdvwb+I34HBPInvMtfDVX4nkuu689uwJH4G
j+ve51VxhldEPt1Mnhd7+BDchRT6HvG8YSlvicXx3Mg0SIu7Y9d0PX0mBZbx
VvGcIb9+li4fPuZDkS72T99LdzuW89Z4QvcBfxxnY89RQDeb50cX81m5N76H
+UvzRNlCDohzkrPkEgzzmfpyty4J13j62Ftdb34HVsSzHjuLgvo5ugLYx4cj
Q+ykvo8uJVbGnsUO4iH9XF1B7OcjkBGp9X11qfBGnGGcLx7Wz9M9hAN8JDLF
Gelf16XGm/ylOB8U0s/XPYxP+ChkjjPR99Pdibfi3Rj3DYX1C3SF8CkfjXvi
jPT9dXfh7XjfoBoe0S/UFcZnfAzujfPUD9ClwarYe1RHkXiudY/gIB+L++Ls
9QN1abGav4IaKBp7ryuCQ3wc7o+z1w/S3Y01/FU8iWJxbrqi+JyPxwNxZvrB
unRYyzvE99d9yJ/Aubhn/Ki5bTwH5utyrqzp2lJZHEt1Y2Qx2VWek1/Enpq/
MreMZ5M/y/eY6+M6zxJ7oBvC02Md7xj3RLeeV8MP/CmU0C3jxfEln4gHYy/0
Q3UZ8A7vFPdIt4FXx4/8aZTULecl8BWfhKyxJ7HPuox4l78W90y3kdfAT/wZ
lNKt4CVxmE/Gc7qP+bO4EefDT5jbY7j5D7lAZov9ksP5KJlJdpKn5XuuNTV/
Zm6Czrwm32R+Ej/zWiitW8lL4Qifguyxh/oRusx4n3eJ+6XbzGviF14bZXRv
8NL4mk/F87q9/Dn8xnPEnupG8nvwAe8a90+3hT+F87wOyure5GXwDZ+GnLG3
+lG6e/Eh74a6KKd/S1cWR/l0JMbe6kfr7sN63h31kCt21LUx+vuxgfdAEnIj
D/IiH/KjQML//8cqGO+P2C3zWD/3ADbynqiP8vq3deVwjM+I90fskn6cLgs2
8V5x7rqt/GlciP1FBd0qXh7dzD/Ib/WtzYfNk2QrOVBelbPj3e96A7mPP4/f
4x0U+6cbzx/EZt47direN/EOifdCPOvx/CKbz07wuazYwvvE+aGifrWuAo7z
WWio288b4I94D/CT5lcwwvynXBjPrmv/ATubOTU=
             "]]},
           Annotation[#, "Charting`Private`Tag$1214775#1"]& ]}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 9.999999795918367}, {-1.5, 10}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{2}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.715601856366344*^9, 3.7156022982008467`*^9, 3.715602345099948*^9, 
   3.715705166572626*^9, 3.715747118214752*^9, 3.715747159674344*^9, 
   3.7157472212454567`*^9, 3.715747466220125*^9, 3.715747535419922*^9, 
   3.715747584778027*^9, 3.715753739345914*^9, {3.7157538214112473`*^9, 
   3.715753828288327*^9}, 3.715754019172305*^9, 3.715755288869688*^9, 
   3.715755545274603*^9, 3.715774056365465*^9, 3.7157741002102947`*^9, 
   3.7157741455796013`*^9, 3.715774212035223*^9, 3.715774269712295*^9, 
   3.7157743058566*^9, 3.7157757526992064`*^9, {3.7157760521777554`*^9, 
   3.715776074466118*^9}, {3.7157761251309977`*^9, 3.7157761525135*^9}, {
   3.715776287082164*^9, 3.715776334455381*^9}, 3.715776412624879*^9, {
   3.715776476213819*^9, 3.7157765239747877`*^9}, 3.715776555684985*^9, 
   3.715776587247704*^9, {3.71577667079432*^9, 3.715776687755858*^9}, 
   3.7157868760892153`*^9, 3.715787073621859*^9, 3.715787138108942*^9, 
   3.715787312154723*^9, {3.715787623986063*^9, 3.7157876789053373`*^9}, 
   3.715787818675095*^9, 3.7157878806714277`*^9, 3.715787971501802*^9, 
   3.715788018878227*^9, 3.715788049053656*^9, 3.715788114267426*^9, 
   3.7157882604561987`*^9, 3.715788297150263*^9, {3.715788385402213*^9, 
   3.715788411309478*^9}, {3.71578847170497*^9, 3.715788516841024*^9}, 
   3.715788587031474*^9, 3.7157886219092913`*^9, 3.715788693326482*^9, {
   3.715788757147644*^9, 3.71578877505263*^9}, 3.715788847124312*^9, {
   3.7157889177563543`*^9, 3.715788943797742*^9}, 3.715788989716714*^9, 
   3.715789061987494*^9, 3.715789092555381*^9, {3.715789209532073*^9, 
   3.715789239220558*^9}, {3.715789448719273*^9, 3.715789475493207*^9}, {
   3.715789511150105*^9, 3.715789529437141*^9}, 3.715789572132822*^9, 
   3.715789609460155*^9, 3.715789660739601*^9, 3.7157897973545628`*^9, {
   3.715789844877437*^9, 3.715789862641721*^9}, 3.715793293803604*^9, {
   3.715793355524437*^9, 3.715793377436203*^9}, 3.715793415943969*^9, {
   3.7157934721992073`*^9, 3.7157934872657433`*^9}, 3.715793536878498*^9, 
   3.715793615569149*^9, 3.715793790617766*^9, 3.71579448558622*^9, {
   3.715794523407333*^9, 3.7157945503052063`*^9}, {3.7157946461249523`*^9, 
   3.715794665965169*^9}, {3.7157947336284857`*^9, 3.71579479585646*^9}, {
   3.7157948262554092`*^9, 3.715794848545108*^9}, {3.7157948847218723`*^9, 
   3.71579491279972*^9}, 3.7157949979869213`*^9, {3.715966347201789*^9, 
   3.715966373554133*^9}, {3.7165317938591423`*^9, 3.716531815777729*^9}, 
   3.716532042112836*^9, 3.7165337971873093`*^9, 3.7165338539129267`*^9, 
   3.716792783153351*^9, 3.716793985529195*^9, {3.719212065237934*^9, 
   3.7192120746623383`*^9}, 3.731692097606476*^9, 3.7594494571264353`*^9, 
   3.7594494994834137`*^9, {3.793502692926983*^9, 3.79350272242518*^9}, 
   3.7939084379424887`*^9, 3.823229298424061*^9},
 CellLabel->
  "Out[2938]=",ExpressionUUID->"1e474453-4a6e-479e-afe2-d12cc27c6ba2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x1b", "[", "t", "]"}], ",", 
          RowBox[{"\[Theta]ff", "[", "t", "]"}], ",", "\[Pi]"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{",", ",", 
           RowBox[{"Directive", "[", 
            RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "]"}]}], "}"}]}], 
        ",", " ", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "5"}], "}"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ub", "[", "t", "]"}], ",", 
          RowBox[{"uff", "[", "t", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.5"}], ",", "7.5"}], "}"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "200"}], ",", 
        RowBox[{"Filling", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"2", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.716793220219673*^9, 3.7167932795595083`*^9}, {
  3.716793322020108*^9, 3.716793357393353*^9}, {3.7167934145229063`*^9, 
  3.7167934232169437`*^9}, {3.7167936069804363`*^9, 3.716793793645729*^9}},
 CellLabel->
  "In[2939]:=",ExpressionUUID->"0e64f7c5-ac2a-4ebc-871f-050850d929f8"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwd13c8V//3AHDzPcz3snkPK5kNSaHXSVRERighkYyMEBFaiEREssqoVCqj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           "]]},
         Annotation[#, "Charting`Private`Tag$1214826#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1nc81e/7B3DrnPf7OBycc5zUp4ysMhsqI+6roiKU1SIiOcleEVoIRcqK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           "]], 
          LineBox[CompressedData["
1:eJwV1Xk8F3kYB3AbteaHTK3M/BAz6UAqR862+hAlR6REyJkjKqpFobQq16ZD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           "]], 
          LineBox[{{8.720200577530825, 3.141592653589793}, {8.743229060566538,
            3.141592653589793}, {8.767710559935155, 3.141592653589793}, {
           8.873891832862427, 3.141592653589793}, {8.980073105789698, 
           3.141592653589793}, {9.178333957651894, 3.141592653589793}, {
           9.372697197154395, 3.141592653589793}, {9.583570987562506, 
           3.141592653589793}, {9.78034308397827, 3.141592653589793}, {
           9.890171439948318, 3.141592653589793}, {9.999999795918367, 
           3.141592653589793}}]},
         Annotation[#, "Charting`Private`Tag$1214826#2"]& ], 
        TagBox[
         {GrayLevel[0.5], Thickness[Tiny], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQPbcuic0wpdtOQtcl5LcipwP77Ufqb+V32sP4C0/N
L3wtfxLOX7e+83aO3i04P93+4sw3RY/h/Lynmo+3rHsJ53Mptqjft/gA5/cJ
nNZamPAZzk+6HbKf+cw3OL/waEtSvvovOH9jAU+whOdfhHuqs18ZhDM4wPhN
8/8EfnnDCOczXH7gsKeKGc5XK0mrCNFihfOffJ0exr2XDc73eppVO6mQA873
ezJBW06OC85/dTip4cRabjhfT/CarHM8L5zPZf818c5nPjjf/W3Ud6VQATj/
xqEUxigdQTh/a8eROIWvCH4aa+mDc+eE4PzkouqtPLOE4Xz9dO1zPokicP55
IR3uUktROH/3uqbZOsxicH41o1bAmbsIPtedKo+8LeJw/tNlilPm10jA+VM0
JFl2hkrC+RNmpR1PVJCC86OmxJ7jeY7g/3BZ+nP+Pmk4//FTp4pD7TJw/iJb
Q+mzibJw/trWUsF0XTk4vz002Zv5K4Jvemfhyvaz8nD+DM3Za896K8D59Qd6
Z3jvRPB9pUOXnlJRhPMd845HC3Yi+PNlklTOfEXwVQ4vn+YXrYTwn+4hrUv7
EPy0zywXT2opw/lJGz8pdPYj+BMu8fQeOY7g7/us9vP/fwQfAGxfK0U=
           "]]},
         Annotation[#, "Charting`Private`Tag$1214826#3"]& ], {}}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 9.999999795918367}, {0, 5}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJztu2dQVO2y/o3kGdKQBpghDSJRARUREb1bFCUrSBIREVFAgogioohIVIkq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        "], {{{}, {}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{956, 95, 845, 846, 1340, 1199, 1085, 990, 923, 887, 
              1372, 1231, 1117, 1022, 955, 847, 1341, 1200, 1086, 991, 924, 
              1390, 1249, 1135, 1040, 888, 1373, 1232, 1118, 1430, 1289, 1023,
               1413, 1272, 1458, 1158, 1442, 1301, 1467}}], 
             PolygonBox[CompressedData["
1:eJwVzzkvRGEAheHPMhQkIpZCJxk0GH/CzGj1lthKEkshMRIzBAmJRGFGRBSY
RCEaYilUlj9g+QPWhoKGgmeKN+8557v35ruNA2Pdo8UhhCJMowMx3JWGMIhS
9JSE0BkJ4VSO40XfxbjtSZ9ALVptUduGHMWVPqN/yCmk9UH9Xh5CVq5ARF7k
H15Cr+fi+pmcwLpchlf7HH8VvoUduQZ79gl+th3yJG9xVeHOqNNX+I+PeZXz
3IBLtHm/ibP2A27iNS7BCa6dp/jTfsSzvM3VyDgb4gfbMHJyZeG+hX/hX15G
n+cS+rmcxJue1r/lDPb1Sf1FnkI92m3NtpzcjBt9HsO2R30E5ei3JW0Xchfe
9TxiaLFv2lpwqy/gH3qcPqs=
              "]], PolygonBox[CompressedData["
1:eJwV0Dc2JVAAx+HLUFjBq6eVnxxXwMN71ApHZqhYgUIOCzAjnyOHXg6NGQwq
K9DIdAqf4jv3/n/nVvdnU2+iJzmEkMQAjURZ/hFCX2oI9ykh9BOhQEvXpt3T
ObcHaaZK39OqebBXKCRD/61l8NceooVqfV+L8WivUkSm/kfL5J89TCsx/UCr
4cleo5gsfUbL4sIeoY0a/VCr5dlep4RsfVbL5tIepZ1a/Uir48XeoJQcfU7L
4coeo4M6/ViL82pvUkauPq/l8t8ep5O4fqIleLO3KCeqL2hRru0Jukjop1o9
7/Y2FeTpi1oeN/Yk3dTrZ1oDH/YOleTrS1o+t/bU9/9od3Y7aQzZn85hFtwj
7PLL2y/G+0VO
              "]]}]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.2], EdgeForm[
           None], GraphicsGroupBox[{
             PolygonBox[{{48, 49, 1466, 1300, 1441, 1156, 1457, 1270, 1411, 
              1004, 1287, 1428, 1099, 1213, 1354, 867, 1032, 1127, 1241, 1382,
               903, 970, 1065, 1180, 1321, 819, 936, 1003, 1098, 1212, 1353, 
              866, 902, 969, 1064, 1179, 1320, 818, 817, 816, 865}}], 
             PolygonBox[CompressedData["
1:eJwV0b1Ok2EchvGHQhcSCZTE4EBLaQTRgVMQqCfgAiIJpQdgW9YK1EUTIFE+
1ERCqhJZCHEAJSYG/DoC4Qja4sggk4PG3zNcuf731TTp+zZbLN19kAghtGED
19tDKPAoiskQHtk/kOsI4QVy2i271z2PFirajvYLd+wj5LUZu4bvGNSeY1C/
ad/HEr4hq28i67MR+y3Okdc+YkKfttvdRZxhTlvUvmLA3sCAdsM+5mvYxap+
yP94hVPcxVuouJsou9/4Xorr8Zm1S9TcLT3J65jQ9vgDj/M9n33mq/H58UQ/
4D/8mBPxXXAnXmLO3udTLvCC73/ibmzjof6eL7jKX3ye4KfIaOvIuIf1Pn6H
Fe0vlt09fIVfoexuoOR+Hf8H928s2U17PL4XjNlTdlv8TfiJ2fhbtBOk7TWk
tSG7jgbG4rPitj5pV+N7R7/2DP36f8WUSDg=
              "]], 
             PolygonBox[CompressedData["
1:eJwV0rdP1GEAx+GXYkIouiJM/g/Ug4CKoIgTkXoGEybrgUrRBRcdNUHANpsA
Ci52JhJMwMamdHBFJxcBwYTnHZ68v+/n7nctd6SzqzGVHkJI4xkdnOdMRggN
nKaeU5ykj6esUZkZwksqDoRQZ/fyhFUq9EkSHqu1p/jPOW2epN5jP2aFhDZB
uX7C/sAeSe0b7foN+5DrFD+5qj3Slim3X1Cm1dgFrm/xm5vae22Xdvsrbdp1
+2B8HTa4oj3Uliizn1OqHbff8Y827Qut+jU7L97HOpe1Ee226z8M2It2pnOQ
Uu2jc4Zj+rSzkDHueyw473E4fmZ+0W+/9dwdWu3PtGjddm58T9a4pA1rC5TY
45RoR+03bNOifaJZ77Jz4n2sclEb0n5QbI9RrFXbr9miWZujSU/Z2fE+Vrig
PdC+U2SPUqRV2fnxe7BJn/ZKu+t6izv2Xzsr/nY0xf+Bc9Z51rkPlKNXIw==

              "]]}]}, {}, {}, {}, {}, {}, {}}, {{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
            1.], LineBox[CompressedData["
1:eJwl1nfcjuUfxvHH3sneq0RmQ6JBNu1ShGjQ0t67aE8qlXZpU/aKjOzsrYhC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             "]]},
           Annotation[#, "Charting`Private`Tag$1214876#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
            1.], LineBox[CompressedData["
1:eJwV1HWQVQUYhvFLCQImSOhId7etdOcSi0U3SoczAtK9sJQ0S3fKgg1SEjZp
/gMCggpIiNi/b2eeeb/3OefunHvOd27hLv2T+mVI+MuYSBTPlEg8miWRSM0s
sUd/Hcmoye/kauGsnoYSKMDP4gpgrz4CHbnjeidkQHuuFpduro1z+hv6dfNo
LNf762fNA7DIfA8eME+V/8hpWGPOh5LOLyhncwUx05wRH8X1yivcNjlCLpX3
412MdLyTPMFvkZ3lfJkdb8f/0CfKO3KnnCRXyTz4AM/7fG25i98k68jZMgt+
dGy0vMGNQZr5QazgB8hz3EAsNt8bx+I7yX9lupwu18r82INSPldIzuELYZ8+
Cp25k3oXZMILXB1ut7kuzusrURqF+blcYeyPe44XUQZFHJvHF8GBuHa8hLpx
L7h6uKCvwsD4fvog5EJZrij3prkoDupj0IWraJVOcV2RGS/z9fh3zPVxUV+N
Qdx5fTByoxxXjJtvLoZDsUv6VfNIjNW76qfN3bDAnCPuvXmS/FNORgfn1Y/n
bW6AOea78FNco7wZ/yt2zpwLa/jB8gK3VQ6RS+R9cc14SJ8u/5O7ZIpcJx/G
XpT3+eJyAb9RFpepMlM8E3zs+Eh5jd8uR8llsdsY51g3eYbrjoXmnHG98V3k
X3IKOjqvgf6euSEu6WP1W+ZxsTf6EP2ieSjyoEK8n9xCcwkc1sejO/e13gNZ
4x3lGnLvmxvhsr4OFVGSX8SVxBF9Aip5vp0jURlVUMp5i51TCkf1ibELaBTv
DdcYP+vrUTV2k1/ClcYxfRJ6cN/oPZEt9odrzH1oboK55qz4hR8nf+d2yPFy
hcwd9weVXd8G5wyNZ+7YMORFtdh7bqm5DD7RJ8f9R5N457im+FXfiOooyy+L
fcen+pS4f2gaz55rhiv6JtRAOT4tdhmf6VPje6FZ/DZxzXFV34zHUJ5fzpXH
5/o09ERzfh/XAtf0LXgcFeL3JJ4tvtCnoxda8Pu5lvhN34on4hnyK7mK+FJP
QW+05A9wrXBd34Yn45nyq7hK+EqfgT5oxR/kknBD346n4vnzq7nKOK7PRF8k
8Ye41rip78DTsSvxvnFVcEJPxStoHe8J1wa39LfwTOwKv5aripP6rLg/3Ld6
L9wd74f+t5yK1ea8sTN41bkd7EIb82HHNsu2cp7MFvsT74O8zU3ATn2Yfsk8
HPnwLFeNWxf7g1P67Ljn3Hd6b2RHP64td8TcDrf1dDwXe8Sv56rjtD4nngH3
vd4HOdCfa8cdNSfjD30XasZe8Ru4Gjijz41nwv2g90VODOCSuWPm9rij78Zw
7rL+GvIjRU9ghnm9fCT2ErWce0D+Dy4QAF0=
             "]], LineBox[CompressedData["
1:eJwV0DlPlGEYhtF3IhQWCg2N0vgr2GYxiAoqIAMSBhhIaIUhCshiopWUGgpA
NgtDo7IojQtakNiJW8eiLDVY0BFE4VCcvM998U3DhbbOZCYSQpjmc3YIBVkh
DHmzWDkVwgPvnvaQYfu2veFu5wx3tAbtizvFgf2WUgr0l1ohq/YI7dqm3cFZ
7mopbdndyF/7HX3ajt3POS5phdordxFr9igd2padIYcurVH76m7i0H5PGUX6
jFbMuv2Ubpr0b1oz/+wPXKZYn9VK+GWP0cMVSvxtTo/y2x7nHlcpp4JrXOcG
rf6/ld4qon4773cxNuwJemnWv2tp/tuLVBPTX2txNu1JMtq23UkufVpa++Fu
YcR9miP9kXdfW/AOep9781jko7/3e3f1Ac5zU4trb9wJtuypk++oIUktddwi
4dsF311k237GAC36T62VwKeTrv1x3yefx3aEJ+4X3nyWqPftMWH2VoA=
             "]]},
           Annotation[#, "Charting`Private`Tag$1214876#2"]& ]}}], {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}, "AxesInFront" -> True},
      PlotRange->{{0., 9.999999795918367}, {-1.5, 7.5}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{4}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.7167931688684177`*^9, {3.716793230530203*^9, 3.7167932806869717`*^9}, {
   3.716793332954266*^9, 3.716793358371407*^9}, {3.716793420356483*^9, 
   3.71679342403858*^9}, {3.716793608336195*^9, 3.7167937976529016`*^9}, 
   3.716793986001507*^9, {3.719212065950532*^9, 3.71921207508488*^9}, 
   3.7316920981531343`*^9, 3.7594494577126703`*^9, 3.759449500042569*^9, {
   3.793502693403651*^9, 3.793502722850163*^9}, 3.793908438357046*^9, 
   3.8232292988248653`*^9},
 CellLabel->
  "Out[2939]=",ExpressionUUID->"94a0820e-4249-4f8b-a208-b34f47a6e483"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.716613652345023*^9, 3.716613661762876*^9}, {
  3.7166171500953703`*^9, 3.716617173133562*^9}, {3.716626783084096*^9, 
  3.7166267858131742`*^9}, {3.716631401415011*^9, 3.716631413565827*^9}, {
  3.71663828988164*^9, 3.7166382916885777`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"3851ab90-1e87-46bf-9003-c3f5227a2a54"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dt", "=", "0.05"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Through", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x1b", ",", "\[Theta]ff", ",", "ub", ",", "uff"}], "}"}], 
        "[", "t", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend", ",", "dt"}], "}"}]}], "]"}], "//", 
    "N"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<pendulumEventTrig.dat\>\"", ",", " ", "dat"}], "]"}]}], " ",
    "\[IndentingNewLine]", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.7167938263139887`*^9, 3.71679387035244*^9}, {
  3.793502677901886*^9, 3.793502712999629*^9}, {3.7939084276104927`*^9, 
  3.793908430941606*^9}},
 CellLabel->
  "In[2940]:=",ExpressionUUID->"b507d632-00d8-4a88-b66f-d8354c364996"]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 175}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"06c29787-4046-490c-9b8c-908e8661fa48"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 668, 12, 105, "Section",ExpressionUUID->"60b09a07-4679-4cd9-9875-aece6d4e38a2"],
Cell[1251, 36, 4727, 70, 52, "Input",ExpressionUUID->"3413512a-057a-4181-97cf-e9214504c8ed"],
Cell[5981, 108, 856, 15, 52, "Text",ExpressionUUID->"fa7774ec-e0dd-4507-bceb-9a6b63479623"],
Cell[6840, 125, 11353, 258, 486, "Input",ExpressionUUID->"6e609bb9-6103-45b7-9599-6a78d6c71957"],
Cell[CellGroupData[{
Cell[18218, 387, 4963, 104, 178, "Input",ExpressionUUID->"b9d7de3f-9cd5-4fc2-bd4a-2773d16006a6"],
Cell[23184, 493, 44557, 789, 145, "Output",ExpressionUUID->"4f1ca8b8-d22f-4dd1-933c-4b670d80cbee"]
}, Open  ]],
Cell[67756, 1285, 597, 9, 52, "Text",ExpressionUUID->"d64cc3d7-7d88-45fb-a632-9366c463e19b"],
Cell[68356, 1296, 2450, 62, 160, "Input",ExpressionUUID->"7b052de1-9b9f-4dc9-a35d-03aa3cf02d55"],
Cell[CellGroupData[{
Cell[70831, 1362, 719, 15, 30, "Input",ExpressionUUID->"97dea820-dc82-4ba3-b551-7a877dfb00e7"],
Cell[71553, 1379, 3101, 53, 54, "Output",ExpressionUUID->"5f3a9ba5-9302-4a8d-8ec4-76bb1ae97c4f"]
}, Open  ]],
Cell[74669, 1435, 723, 19, 30, "Input",ExpressionUUID->"497b2ae8-1685-4acd-b01c-db0d0149e461"],
Cell[75395, 1456, 7942, 173, 292, "Input",ExpressionUUID->"c4273a82-126b-4e65-8280-0d685c721ed3"],
Cell[CellGroupData[{
Cell[83362, 1633, 9492, 199, 304, "Input",ExpressionUUID->"d5755d32-7f54-4cde-8146-a6000297e229"],
Cell[92857, 1834, 490, 10, 39, "Message",ExpressionUUID->"957ca2bd-3088-4806-bd34-d87ef000acee"],
Cell[93350, 1846, 490, 10, 39, "Message",ExpressionUUID->"25398235-d72b-4cfd-b511-e2bcaf085b68"],
Cell[93843, 1858, 488, 10, 39, "Message",ExpressionUUID->"2755e0d6-03b0-4176-ab95-221d69843940"],
Cell[94334, 1870, 472, 10, 24, "Message",ExpressionUUID->"b1a00bb4-dee5-42ca-9a76-cc56292330fb"],
Cell[94809, 1882, 488, 10, 39, "Message",ExpressionUUID->"dbedb31a-ddba-4527-b047-39c6c17ca5d1"],
Cell[95300, 1894, 488, 10, 39, "Message",ExpressionUUID->"093a3c34-3093-4b65-83bb-360e9ee5c08a"],
Cell[95791, 1906, 487, 10, 39, "Message",ExpressionUUID->"838b84e3-0454-4fcb-b83c-989acbdcbc1d"],
Cell[96281, 1918, 472, 10, 24, "Message",ExpressionUUID->"0b32d624-92e8-4347-8346-e1397ccdda3e"],
Cell[96756, 1930, 139931, 2410, 309, "Output",ExpressionUUID->"70ed67ee-755b-4f5d-a2cc-f9840925a628"]
}, Open  ]],
Cell[236702, 4343, 1652, 41, 100, "Text",ExpressionUUID->"9f1f533c-fcc3-4384-ac21-10147021c9b4"],
Cell[238357, 4386, 5738, 147, 341, "Input",ExpressionUUID->"1ae5ff92-7ba6-4403-a0d9-3760f6b53e7c"],
Cell[CellGroupData[{
Cell[244120, 4537, 808, 17, 30, "Input",ExpressionUUID->"9a36d829-8be6-4b05-970b-5c6e24f241bc"],
Cell[244931, 4556, 488, 10, 39, "Message",ExpressionUUID->"834411de-6c0e-4fa2-abb1-5f93848ce04b"],
Cell[245422, 4568, 490, 10, 39, "Message",ExpressionUUID->"9c17354d-d48d-430c-8462-b20ca30bcb25"],
Cell[245915, 4580, 490, 10, 39, "Message",ExpressionUUID->"c0ffa68e-94ae-4fd3-9fde-ecac3a183311"],
Cell[246408, 4592, 472, 10, 24, "Message",ExpressionUUID->"a53b0a45-17fa-4cc8-9ff2-22da764de42e"],
Cell[246883, 4604, 2196, 36, 24, "Print",ExpressionUUID->"4ccbc47b-56d7-4f6e-a562-a6e7ba5e881d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[249116, 4645, 3308, 82, 220, "Input",ExpressionUUID->"45054d45-4e3b-43d6-8222-dc3b2ae5c2d9"],
Cell[252427, 4729, 70911, 1222, 161, "Output",ExpressionUUID->"1e474453-4a6e-479e-afe2-d12cc27c6ba2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[323375, 5956, 1830, 47, 136, "Input",ExpressionUUID->"0e64f7c5-ac2a-4ebc-871f-050850d929f8"],
Cell[325208, 6005, 50921, 881, 161, "Output",ExpressionUUID->"94a0820e-4249-4f8b-a208-b34f47a6e483"]
}, Open  ]],
Cell[376144, 6889, 394, 7, 52, "Text",ExpressionUUID->"3851ab90-1e87-46bf-9003-c3f5227a2a54"],
Cell[376541, 6898, 1092, 29, 136, "Input",ExpressionUUID->"b507d632-00d8-4a88-b66f-d8354c364996"]
}, Open  ]]
}
]
*)

