(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     14740,        406]
NotebookOptionsPosition[     13407,        375]
NotebookOutlinePosition[     13805,        391]
CellTagsIndexPosition[     13762,        388]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Misc. calcs for mag, phase independence (for large SNR)
see Problem 6.9 (Amplitude and phase noise)\
\>", "Section",
 CellChangeTimes->{{3.5700441605520697`*^9, 3.570044174368116*^9}, {
  3.793412075070809*^9, 
  3.793412092772356*^9}},ExpressionUUID->"0e29efe3-6ed7-42af-a1d9-\
519391180b68"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.7934121131513557`*^9, 3.7934121148342113`*^9}},
 CellLabel->
  "In[3640]:=",ExpressionUUID->"9bb21d0e-b70d-432f-ad30-d6791430edc1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"x0", "+", "dx"}]}], ";", "  ", 
  RowBox[{"y", "=", 
   RowBox[{"y0", "+", "dy"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]", "=", 
    RowBox[{"ArcTan", "[", 
     FractionBox["y", "x"], "]"}]}], ";", 
   RowBox[{"r", "=", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}]]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]0", "=", 
   RowBox[{"ArcTan", "[", 
    FractionBox["y0", "x0"], "]"}]}], ";", 
  RowBox[{"r0", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["x0", "2"], "+", 
     SuperscriptBox["y0", "2"]}]]}], ";"}]}], "Input",
 CellChangeTimes->{{3.546549236448061*^9, 3.546549273641591*^9}, {
   3.5465521462817087`*^9, 3.546552185604806*^9}, {3.546552336666765*^9, 
   3.5465523910946283`*^9}, 3.570044116196447*^9, 3.5700442202409277`*^9, {
   3.57004442867146*^9, 3.5700444463198433`*^9}},
 CellLabel->
  "In[3641]:=",ExpressionUUID->"ae841fbb-aa1c-4c77-9432-e04c3780b38a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Theta]s", " ", "=", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"\[Theta]", "-", "\[Theta]0"}], ",", 
     RowBox[{"{", 
      RowBox[{"dx", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"dy", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"y0", ">", "0"}], " ", "&&", " ", 
       RowBox[{"x0", ">", "0"}]}]}]}], "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.546549275915065*^9, 3.546549288898285*^9}, {
  3.5465493341595163`*^9, 3.546549342862472*^9}, {3.5465493848122997`*^9, 
  3.546549394314097*^9}, {3.546552193772213*^9, 3.54655220984486*^9}, {
  3.5465522540185213`*^9, 3.546552257712474*^9}, {3.5465524131931753`*^9, 
  3.5465524180573063`*^9}, {3.570044279719183*^9, 3.570044283874007*^9}, {
  3.570044331770153*^9, 3.570044332385003*^9}, {3.570044454399193*^9, 
  3.5700444545864487`*^9}},
 CellLabel->
  "In[3644]:=",ExpressionUUID->"bbf076ed-2c48-4159-a399-38868958a89c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       RowBox[{"x0", " ", "dy"}], 
       RowBox[{
        SuperscriptBox["x0", "2"], "+", 
        SuperscriptBox["y0", "2"]}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", "dy", "]"}], "2"],
       SeriesData[$CellContext`dy, 0, {}, 1, 2, 1],
       Editable->False]}],
     SeriesData[$CellContext`dy, 
      0, {$CellContext`x0/($CellContext`x0^2 + $CellContext`y0^2)}, 1, 2, 1],
     Editable->False], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{
       RowBox[{"-", 
        FractionBox["y0", 
         RowBox[{
          SuperscriptBox["x0", "2"], "+", 
          SuperscriptBox["y0", "2"]}]]}], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["x0", "2"]}], "+", 
           SuperscriptBox["y0", "2"]}], ")"}], " ", "dy"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x0", "2"], "+", 
           SuperscriptBox["y0", "2"]}], ")"}], "2"]], "+", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", "dy", "]"}], "2"],
        SeriesData[$CellContext`dy, 0, {}, 0, 2, 1],
        Editable->False]}],
      SeriesData[$CellContext`dy, 
       0, {-$CellContext`y0/($CellContext`x0^2 + $CellContext`y0^2), \
(-$CellContext`x0^2 + $CellContext`y0^2) ($CellContext`x0^2 + \
$CellContext`y0^2)^(-2)}, 0, 2, 1],
      Editable->False], ")"}], " ", "dx"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "dx", "]"}], "2"],
    SeriesData[$CellContext`dx, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`dx, 0, {
    SeriesData[$CellContext`dy, 
     0, {$CellContext`x0/($CellContext`x0^2 + $CellContext`y0^2)}, 1, 2, 1], 
    SeriesData[$CellContext`dy, 
     0, {-$CellContext`y0/($CellContext`x0^2 + $CellContext`y0^2), \
(-$CellContext`x0^2 + $CellContext`y0^2) ($CellContext`x0^2 + \
$CellContext`y0^2)^(-2)}, 0, 2, 1]}, 0, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.546549289320051*^9, {3.546549343617085*^9, 3.546549351625388*^9}, {
   3.546549388334386*^9, 3.5465493955538054`*^9}, {3.546552199780006*^9, 
   3.546552210571528*^9}, 3.5465522594983683`*^9, {3.546552372541342*^9, 
   3.546552418451562*^9}, 3.546637751978747*^9, 3.570044139418597*^9, 
   3.570044180409037*^9, 3.570044223951964*^9, 3.570044284784605*^9, 
   3.5700443343670683`*^9, 3.5700444553530483`*^9, 3.793411010626113*^9, 
   3.793412118178228*^9, 3.7934130297620487`*^9, 3.793904769535507*^9, 
   3.823229948082182*^9},
 CellLabel->
  "Out[3644]=",ExpressionUUID->"7820a9d0-be43-48f5-b926-0380f8fecc0d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rs", "=", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"r", "-", "r0"}], ",", 
     RowBox[{"{", 
      RowBox[{"dx", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"dy", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"y0", ">", "0"}], " ", "&&", " ", 
       RowBox[{"x0", ">", "0"}]}]}]}], "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.546552220025332*^9, 3.5465522632325373`*^9}, {
  3.546552322314204*^9, 3.546552330098404*^9}, {3.546637762901115*^9, 
  3.546637777282407*^9}, {3.570044125938777*^9, 3.570044128371162*^9}, {
  3.570044252502448*^9, 3.570044263963757*^9}, {3.5700443369310923`*^9, 
  3.570044337305344*^9}, {3.570044458786001*^9, 3.570044459119895*^9}},
 CellLabel->
  "In[3645]:=",ExpressionUUID->"4bbbd2b1-c0d3-4a58-acb5-7d62c950ff66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       RowBox[{"y0", " ", "dy"}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x0", "2"], "+", 
         SuperscriptBox["y0", "2"]}]]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", "dy", "]"}], "2"],
       SeriesData[$CellContext`dy, 0, {}, 1, 2, 1],
       Editable->False]}],
     SeriesData[$CellContext`dy, 
      0, {$CellContext`y0 ($CellContext`x0^2 + $CellContext`y0^2)^
        Rational[-1, 2]}, 1, 2, 1],
     Editable->False], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{
       FractionBox["x0", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["x0", "2"], "+", 
          SuperscriptBox["y0", "2"]}]]], "-", 
       FractionBox[
        RowBox[{"x0", " ", "y0", " ", "dy"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x0", "2"], "+", 
           SuperscriptBox["y0", "2"]}], ")"}], 
         RowBox[{"3", "/", "2"}]]], "+", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", "dy", "]"}], "2"],
        SeriesData[$CellContext`dy, 0, {}, 0, 2, 1],
        Editable->False]}],
      SeriesData[$CellContext`dy, 
       0, {$CellContext`x0 ($CellContext`x0^2 + $CellContext`y0^2)^
         Rational[-1, 
           2], -$CellContext`x0 $CellContext`y0 ($CellContext`x0^2 + \
$CellContext`y0^2)^Rational[-3, 2]}, 0, 2, 1],
      Editable->False], ")"}], " ", "dx"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "dx", "]"}], "2"],
    SeriesData[$CellContext`dx, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`dx, 0, {
    SeriesData[$CellContext`dy, 
     0, {$CellContext`y0 ($CellContext`x0^2 + $CellContext`y0^2)^
       Rational[-1, 2]}, 1, 2, 1], 
    SeriesData[$CellContext`dy, 
     0, {$CellContext`x0 ($CellContext`x0^2 + $CellContext`y0^2)^
       Rational[-1, 
         2], -$CellContext`x0 $CellContext`y0 ($CellContext`x0^2 + \
$CellContext`y0^2)^Rational[-3, 2]}, 0, 2, 1]}, 0, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5465522414900618`*^9, 3.546552263658437*^9}, 
   3.546552330622458*^9, {3.5465523725917473`*^9, 3.54655239641173*^9}, {
   3.5466377520672703`*^9, 3.546637777822652*^9}, 3.5700441394480667`*^9, 
   3.57004418043917*^9, 3.570044224014674*^9, {3.570044255592608*^9, 
   3.5700442652622833`*^9}, 3.570044338101053*^9, 3.570044460087676*^9, 
   3.79341101066556*^9, 3.793412118213561*^9, 3.793413029796775*^9, 
   3.793904769574057*^9, 3.823229948121567*^9},
 CellLabel->
  "Out[3645]=",ExpressionUUID->"ffc00468-9a54-472b-aa59-40f353e45461"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"rs", " ", "\[Theta]s"}], " ", "//", " ", "Simplify"}]], "Input",
 CellChangeTimes->{{3.546552267546609*^9, 3.5465523001067657`*^9}, {
   3.546552423704536*^9, 3.546552454594392*^9}, 3.570044134274919*^9, {
   3.570044289977614*^9, 3.5700442918637133`*^9}},
 CellLabel->
  "In[3646]:=",ExpressionUUID->"874f539e-09ba-4327-8fc3-d06919cbc763"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       RowBox[{"x0", " ", "y0", " ", 
        SuperscriptBox["dy", "2"]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x0", "2"], "+", 
          SuperscriptBox["y0", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", "dy", "]"}], "3"],
       SeriesData[$CellContext`dy, 0, {}, 2, 3, 1],
       Editable->False]}],
     SeriesData[$CellContext`dy, 
      0, {$CellContext`x0 $CellContext`y0 ($CellContext`x0^2 + \
$CellContext`y0^2)^Rational[-3, 2]}, 2, 3, 1],
     Editable->False], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x0", "2"], "-", 
           SuperscriptBox["y0", "2"]}], ")"}], " ", "dy"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x0", "2"], "+", 
           SuperscriptBox["y0", "2"]}], ")"}], 
         RowBox[{"3", "/", "2"}]]], "+", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", "dy", "]"}], "2"],
        SeriesData[$CellContext`dy, 0, {}, 1, 2, 1],
        Editable->False]}],
      SeriesData[$CellContext`dy, 
       0, {($CellContext`x0^2 - $CellContext`y0^2) ($CellContext`x0^2 + \
$CellContext`y0^2)^Rational[-3, 2]}, 1, 2, 1],
      Editable->False], ")"}], " ", "dx"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "dx", "]"}], "2"],
    SeriesData[$CellContext`dx, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`dx, 0, {
    SeriesData[$CellContext`dy, 
     0, {$CellContext`x0 $CellContext`y0 ($CellContext`x0^2 + \
$CellContext`y0^2)^Rational[-3, 2]}, 2, 3, 1], 
    SeriesData[$CellContext`dy, 
     0, {($CellContext`x0^2 - $CellContext`y0^2) ($CellContext`x0^2 + \
$CellContext`y0^2)^Rational[-3, 2]}, 1, 2, 1]}, 0, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.546552275410149*^9, 3.54655230047711*^9}, {
   3.546552372641227*^9, 3.5465523964612827`*^9}, {3.546552446463979*^9, 
   3.546552455186133*^9}, 3.546637752323134*^9, 3.5700441394792833`*^9, 
   3.5700441804709063`*^9, 3.570044224072876*^9, 3.570044293803679*^9, 
   3.570044340535593*^9, 3.570044462154818*^9, 3.793411010697136*^9, 
   3.793412118221375*^9, 3.793413029804748*^9, 3.793904769600985*^9, 
   3.8232299481424837`*^9},
 CellLabel->
  "Out[3646]=",ExpressionUUID->"a28b90c2-7dca-4c34-bd4c-889c50a54017"]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Sigma]", "2"], "=", " ", 
    RowBox[{
     RowBox[{"<", 
      SuperscriptBox["dx", "2"], ">"}], " ", "=", " ", 
     RowBox[{"<", 
      SuperscriptBox["dy", "2"], ">"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "002c08bc-045e-413a-9c45-51907935470c"],
 ",  these results are quoted in the soution to Part (a)."
}], "Text",
 CellChangeTimes->{{3.79341294821948*^9, 3.793413025447713*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"0d596da8-f59b-4f0c-b9cb-6181b2575a23"]
}, Open  ]]
},
WindowSize->{740, 652},
WindowMargins->{{Automatic, 216}, {Automatic, 89}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"7a3d1bc9-a79a-4bc2-b8cb-d9d35f2ff4de"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 303, 7, 105, "Section",ExpressionUUID->"0e29efe3-6ed7-42af-a1d9-519391180b68"],
Cell[885, 31, 245, 5, 30, "Input",ExpressionUUID->"9bb21d0e-b70d-432f-ad30-d6791430edc1"],
Cell[1133, 38, 1057, 30, 134, "Input",ExpressionUUID->"ae841fbb-aa1c-4c77-9432-e04c3780b38a"],
Cell[CellGroupData[{
Cell[2215, 72, 1026, 22, 52, "Input",ExpressionUUID->"bbf076ed-2c48-4159-a399-38868958a89c"],
Cell[3244, 96, 2798, 73, 62, "Output",ExpressionUUID->"7820a9d0-be43-48f5-b926-0380f8fecc0d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6079, 174, 895, 20, 30, "Input",ExpressionUUID->"4bbbd2b1-c0d3-4a58-acb5-7d62c950ff66"],
Cell[6977, 196, 2742, 72, 61, "Output",ExpressionUUID->"ffc00468-9a54-472b-aa59-40f353e45461"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9756, 273, 375, 7, 30, "Input",ExpressionUUID->"874f539e-09ba-4327-8fc3-d06919cbc763"],
Cell[10134, 282, 2645, 70, 62, "Output",ExpressionUUID->"a28b90c2-7dca-4c34-bd4c-889c50a54017"]
}, Open  ]],
Cell[12794, 355, 597, 17, 51, "Text",ExpressionUUID->"0d596da8-f59b-4f0c-b9cb-6181b2575a23"]
}, Open  ]]
}
]
*)

