(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    293783,       6112]
NotebookOptionsPosition[    288886,       6018]
NotebookOutlinePosition[    289284,       6034]
CellTagsIndexPosition[    289241,       6031]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Miscellaneous explorations of model reduction.  
Section 6.5.2 (Balanced coordinates)  Figure 6.7\
\>", "Section",
 CellChangeTimes->{{3.5486211101221657`*^9, 3.548621138099083*^9}, {
  3.54871471086439*^9, 3.548714712677958*^9}, {3.793410732945086*^9, 
  3.793410756859724*^9}, {3.793904734337235*^9, 3.793904737379025*^9}},
 FontSize->24,
 Background->GrayLevel[
  0.85],ExpressionUUID->"e36dc579-bb69-469f-a318-4560cd98cdfb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Plot", ",", 
    RowBox[{"PlotRange", " ", "\[Rule]", " ", "All"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5486872501174307`*^9, 3.548687250962327*^9}, {
  3.548709584056287*^9, 3.548709584263084*^9}},
 CellLabel->
  "In[3597]:=",ExpressionUUID->"c784ee3f-5bd4-412e-b6b7-d8db167a091b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A1", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", "1"}], "0"},
      {"0", 
       RowBox[{"-", "2"}]}
     }], "\[NoBreak]", ")"}]}], ";", " ", 
  RowBox[{"B1", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1"},
      {"1"}
     }], "\[NoBreak]", ")"}]}], ";", " ", 
  RowBox[{"C1", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "2"}
     }], "\[NoBreak]", ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Gss1", "=", 
  RowBox[{"StateSpaceModel", "[", 
   RowBox[{"{", 
    RowBox[{"A1", ",", "B1", ",", "C1"}], "}"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.548687345117556*^9, 3.548687436701153*^9}, {
   3.548688170778054*^9, 3.5486882021536493`*^9}, {3.548688328720627*^9, 
   3.5486883440221663`*^9}, 3.548688400318252*^9, {3.548688748919262*^9, 
   3.548688749014839*^9}, {3.5486887845452757`*^9, 3.548688784639099*^9}, {
   3.548689252870139*^9, 3.548689252948153*^9}, {3.548689374093288*^9, 
   3.548689511407959*^9}, {3.548689602809373*^9, 3.548689634425415*^9}, {
   3.548689681689068*^9, 3.548689703222918*^9}, {3.5487007789750547`*^9, 
   3.5487007790529127`*^9}, {3.5487008832204*^9, 3.5487008833943377`*^9}, {
   3.548701335630929*^9, 3.54870134770043*^9}, {3.54870147456639*^9, 
   3.548701482405424*^9}, {3.548706094541288*^9, 3.548706104039855*^9}, {
   3.548707052629654*^9, 3.548707055435354*^9}, {3.548707123326071*^9, 
   3.5487071264685087`*^9}, {3.548707470074204*^9, 3.5487074824234858`*^9}, {
   3.548707577846587*^9, 3.5487075901728287`*^9}, {3.5487076469161043`*^9, 
   3.5487076537289057`*^9}, {3.5487081359339647`*^9, 
   3.5487081478937693`*^9}, {3.548714048778051*^9, 3.5487140511364317`*^9}, {
   3.5487140950776854`*^9, 3.548714132203668*^9}, {3.5487142698199377`*^9, 
   3.548714296739809*^9}, {3.548714347308353*^9, 3.5487143562998953`*^9}, {
   3.5487150279536877`*^9, 3.54871508281709*^9}, {3.5494197025736847`*^9, 
   3.549419708387474*^9}},
 CellLabel->
  "In[3599]:=",ExpressionUUID->"772c0fb0-c674-483e-a0fb-9c6a9ea5b064"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "1"}], "0", "1", "0", 
   RowBox[{"-", "2"}], "1", "1", "2", "0", 
   InterpretationBox["\[InvisibleSpace]", None], {
   StateSpaceModel, {
    False, False, {
     False, False}}, {$CellContext`stname1, $CellContext`stname2}, {{
     Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, Identity, 
    Automatic, 1, 1, 2, 1, {}, {False, False}, False, Automatic, None, 
    Automatic}, {}},
  "StateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{#, #2, #3}, {#4, #5, #6}, {#7, #8, #9}}, 
        AllowedDimensions -> {3, 3}, 
        GridBoxDividers -> {"Rows" -> {False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}, "Columns" -> {False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
        "SystemsModelGrid00"], ")"}], #10, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalS]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None], MultilineFunction -> None], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{1, 2}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{4, 5}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{3, 3}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{6, 6}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{7, 8}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{9, 9}, ","], "}"}], "}"}], "}"}], ",", 
     "SamplingPeriod", "->", 
     RowBox[{#10}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
  Tooltip->StateSpaceModel]], "Output",
 CellChangeTimes->{
  3.548707093652738*^9, 3.548707130907548*^9, 3.548707503259123*^9, {
   3.5487075361358547`*^9, 3.5487075438199387`*^9}, 3.548707594070187*^9, 
   3.5487076598570433`*^9, {3.5487080988166933`*^9, 3.5487081106911783`*^9}, 
   3.5487081520030003`*^9, 3.548709089741502*^9, 3.548709592277033*^9, 
   3.548709627806407*^9, 3.548710575762867*^9, 3.548710723993745*^9, 
   3.548710891049581*^9, 3.5487116083493013`*^9, 3.5487118200260878`*^9, 
   3.5487119671141367`*^9, 3.5487124763570347`*^9, 3.548712682313459*^9, 
   3.5487128086545467`*^9, 3.5487135173155613`*^9, {3.548713968693955*^9, 
   3.548713981227977*^9}, 3.548714014515793*^9, 3.548714054706141*^9, 
   3.5487141027129183`*^9, 3.5487141357708883`*^9, 3.548714168950193*^9, 
   3.548714218732627*^9, {3.548714276904441*^9, 3.548714359606689*^9}, 
   3.54871469526665*^9, 3.548715034017192*^9, {3.548715067648275*^9, 
   3.548715086520705*^9}, 3.5489685687828827`*^9, 3.549225149539969*^9, 
   3.549389256241357*^9, {3.549419689266037*^9, 3.5494197124324417`*^9}, 
   3.54941997226974*^9, 3.549420144140476*^9, 3.549421568304085*^9, 
   3.549465591872015*^9, 3.54946574899118*^9, 3.568647012533489*^9, 
   3.738609376946576*^9, 3.765484634006359*^9, 3.765485259700982*^9, 
   3.7934107649631023`*^9, 3.79390466004074*^9, 3.823229931450899*^9},
 CellLabel->
  "Out[3600]=",ExpressionUUID->"97d5747d-0d06-4176-b0ba-e497d1a3aeaf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TransferFunctionModel", "[", 
  RowBox[{"Gss1", ",", "s"}], "]"}]], "Input",
 CellChangeTimes->{{3.5494790788881702`*^9, 3.549479108399922*^9}},
 CellLabel->
  "In[3601]:=",ExpressionUUID->"48c5019d-2c61-470a-b87b-5ccd77d23788"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox[
     RowBox[{"4", "+", 
       RowBox[{"3", " ", "s"}]}], 
     RowBox[{"2", "+", 
       RowBox[{"3", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{4 + 3 $CellContext`s}}, 2 + 
        3 $CellContext`s + $CellContext`s^2}, $CellContext`s], AutoDelete -> 
      True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{4 + 3 $CellContext`s}}, 2 + 
        3 $CellContext`s + $CellContext`s^2}, $CellContext`s]], 1, {}, {
     False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{4 + 3 $CellContext`s}}, 2 + 
    3 $CellContext`s + $CellContext`s^2}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{3.549479086252095*^9, 3.568647012557989*^9, 
  3.738609377093994*^9, 3.765484634353305*^9, 3.765485259852412*^9, 
  3.793410765075481*^9, 3.7939046601424217`*^9, 3.823229931540187*^9},
 CellLabel->
  "Out[3601]=",ExpressionUUID->"8341903a-95c9-405b-9295-9f1f29dbe92d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", GridBox[{
    {
     FractionBox[
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "s"}]}], 
      RowBox[{"2", "+", 
       RowBox[{"3", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]]}
   },
   AllowScriptLevelChange->False,
   BaseStyle->{Deployed -> False},
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemStyle->{
    "ItemsIndexed" -> {{{1, 1}, {}} -> {
        Deployed -> True, ShowStringCharacters -> False}, {{}, {1, 1}} -> {
        Deployed -> True, ShowStringCharacters -> False}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}], "]"}]], "Input",
 CellChangeTimes->{{3.54947911050393*^9, 3.549479115986226*^9}},
 CellLabel->
  "In[3602]:=",ExpressionUUID->"835d2f11-9edc-4395-bf26-6e7209741b0a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", "s"}]], "+", 
    FractionBox["2", 
     RowBox[{"2", "+", "s"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.549479116510976*^9, 3.568647012589757*^9, 
  3.738609377179727*^9, 3.765484634436994*^9, 3.765485259958143*^9, 
  3.793410765094006*^9, 3.793904660198566*^9, 3.8232299315894003`*^9},
 CellLabel->
  "Out[3602]=",ExpressionUUID->"897c589b-78af-4cde-b394-1b5f72fae46a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"atr", "=", 
     RowBox[{"DiagonalMatrix", "[", 
      RowBox[{"{", 
       RowBox[{"A1", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"btr", "=", 
     RowBox[{"DiagonalMatrix", "[", 
      RowBox[{"B1", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"ctr", "=", 
     RowBox[{"DiagonalMatrix", "[", 
      RowBox[{"{", 
       RowBox[{"C1", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Gsstr1", "=", 
    RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
      RowBox[{"atr", ",", "btr", ",", "ctr"}], "}"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.548711652342434*^9, 3.548711816890757*^9}, 
   3.548711938998466*^9, {3.548712628554912*^9, 3.5487126483946133`*^9}, {
   3.7386093920649357`*^9, 3.738609397529261*^9}},
 CellLabel->
  "In[3603]:=",ExpressionUUID->"f52fce6c-5393-4733-abf6-6999f9ed3ddf"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "1"}], "1", "1", "0", 
   InterpretationBox["\[InvisibleSpace]", None], {
   StateSpaceModel, {
    False, False, {False, False}}, {$CellContext`stname1}, {{
     Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$}}, Identity, Automatic, 1, 1, 1, 1, {}, {
    False, False}, False, Automatic, None, Automatic}, {}},
  "StateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{#, #2}, {#3, #4}}, AllowedDimensions -> {2, 2}, 
        GridBoxDividers -> {"Rows" -> {False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}, "Columns" -> {False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
        "SystemsModelGrid00"], ")"}], #5, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalS]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None], MultilineFunction -> None], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{2, 2}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{3, 3}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{4, 4}, ","], "}"}], "}"}], "}"}], ",", 
     "SamplingPeriod", "->", 
     RowBox[{#5}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
  Tooltip->StateSpaceModel]], "Output",
 CellChangeTimes->{{3.548711714152266*^9, 3.548711749324888*^9}, {
   3.5487117996785994`*^9, 3.548711820078609*^9}, 3.548711967162176*^9, 
   3.548712476407505*^9, 3.548712682364398*^9, 3.5487128087195787`*^9, 
   3.5487135173641863`*^9, {3.548713968742647*^9, 3.548713981310092*^9}, 
   3.5487140145691442`*^9, 3.548714054755495*^9, 3.548714102763283*^9, 
   3.548714135818872*^9, 3.548714169163842*^9, 3.5487142189455757`*^9, {
   3.548714277112771*^9, 3.548714359657001*^9}, 3.548714695316983*^9, 
   3.548715034068056*^9, {3.54871506775294*^9, 3.548715086585136*^9}, 
   3.548968568833036*^9, 3.549225149608341*^9, 3.549389256298522*^9, 
   3.549419689315765*^9, 3.549419722481105*^9, 3.549419972352901*^9, 
   3.549420144230389*^9, 3.5494215683545723`*^9, 3.5494655919080677`*^9, 
   3.5494657490385227`*^9, 3.568647012624403*^9, {3.7386093773421926`*^9, 
   3.738609403817079*^9}, 3.765484634546063*^9, 3.7654852601305656`*^9, 
   3.7934107652324266`*^9, 3.793904660291506*^9, 3.823229931634747*^9},
 CellLabel->
  "Out[3606]=",ExpressionUUID->"04893096-6bb3-499a-ac17-cbb7b3cd9884"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dres", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"C1", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "/", 
      RowBox[{"A1", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "*", 
     RowBox[{"B1", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Gssres1", "=", 
  RowBox[{"StateSpaceModel", "[", 
   RowBox[{"{", 
    RowBox[{"atr", ",", "btr", ",", "ctr", ",", "dres"}], "}"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.548712299817747*^9, 3.548712300642605*^9}, {
   3.5487123531882563`*^9, 3.548712362061244*^9}, {3.548712403166885*^9, 
   3.548712404366906*^9}, {3.548712437823955*^9, 3.5487124665816517`*^9}, {
   3.5487125151607447`*^9, 3.548712578753798*^9}, 3.54871276540718*^9, {
   3.7386094068007803`*^9, 3.738609408137115*^9}},
 CellLabel->
  "In[3607]:=",ExpressionUUID->"62483cd0-f923-4d21-b800-4f9f5175a42f"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "1"}], "1", "1", "1", 
   InterpretationBox["\[InvisibleSpace]", None], {
   StateSpaceModel, {
    False, False, {False, False}}, {$CellContext`stname1}, {{
     Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$}}, Identity, Automatic, 1, 1, 1, 1, {}, {
    False, False}, False, Automatic, None, Automatic}, {}},
  "StateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{#, #2}, {#3, #4}}, AllowedDimensions -> {2, 2}, 
        GridBoxDividers -> {"Rows" -> {False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}, "Columns" -> {False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
        "SystemsModelGrid00"], ")"}], #5, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalS]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None], MultilineFunction -> None], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{2, 2}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{3, 3}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{4, 4}, ","], "}"}], "}"}], "}"}], ",", 
     "SamplingPeriod", "->", 
     RowBox[{#5}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
  Tooltip->StateSpaceModel]], "Output",
 CellChangeTimes->{{3.54871235758457*^9, 3.548712362499262*^9}, {
   3.548712438666624*^9, 3.548712476459244*^9}, {3.54871255797729*^9, 
   3.548712579358719*^9}, 3.5487126824133673`*^9, 3.548712808768289*^9, 
   3.548713517416315*^9, {3.548713968794386*^9, 3.5487139815226192`*^9}, 
   3.548714014616791*^9, 3.548714054806632*^9, 3.548714102813621*^9, 
   3.548714135869622*^9, 3.548714169251808*^9, 3.548714219034724*^9, {
   3.548714277206284*^9, 3.5487143597070923`*^9}, 3.548714695366831*^9, 
   3.5487150341188803`*^9, {3.5487150678841047`*^9, 3.548715086651864*^9}, 
   3.548968568885635*^9, 3.549225149753667*^9, 3.54938925634478*^9, 
   3.549419689368497*^9, 3.5494199725483522`*^9, 3.549420144313493*^9, 
   3.549421568404543*^9, 3.5494655919438677`*^9, 3.549465749088358*^9, 
   3.568647012656332*^9, 3.738609377496991*^9, 3.765484634679914*^9, 
   3.765485260275502*^9, 3.793410765328478*^9, 3.793904660365597*^9, 
   3.823229931706689*^9},
 CellLabel->
  "Out[3608]=",ExpressionUUID->"7d28edb1-0644-408c-afd8-f44f68cf80d0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ControllabilityGramian", "[", "Gss1", "]"}]}], ";", 
  RowBox[{"q1", "=", 
   RowBox[{"ObservabilityGramian", "[", "Gss1", "]"}]}], ";", 
  RowBox[{"TraditionalForm", "/@", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "q1"}], "}"}], "        "}]}]], "Input",
 CellChangeTimes->{{3.548687623917445*^9, 3.548687722041394*^9}, {
  3.5486897108893757`*^9, 3.548689728762167*^9}, {3.549419740433817*^9, 
  3.549419793207534*^9}},
 CellLabel->
  "In[3609]:=",ExpressionUUID->"b10441e8-1079-4280-9221-d0d970cd8af7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    FormBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FractionBox["1", "2"], 
         FractionBox["1", "3"]},
        {
         FractionBox["1", "3"], 
         FractionBox["1", "4"]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}], "\[NoBreak]", ")"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FractionBox["1", "2"], 
         FractionBox["2", "3"]},
        {
         FractionBox["2", "3"], "1"}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}], "\[NoBreak]", ")"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True]}], "}"}]], "Output",
 CellChangeTimes->{{3.5486877117454987`*^9, 3.5486877228259*^9}, {
   3.548687765445236*^9, 3.5486877758629513`*^9}, 3.548688176100623*^9, 
   3.548688207152563*^9, 3.548688350174881*^9, 3.548688404789649*^9, {
   3.54868876285816*^9, 3.548688788638144*^9}, {3.548688921029364*^9, 
   3.548688940622118*^9}, 3.5486892562749434`*^9, {3.5486893558733788`*^9, 
   3.548689516092924*^9}, {3.5486896125066643`*^9, 3.548689637933132*^9}, 
   3.548689747157044*^9, 3.548689796084743*^9, {3.5486898377322807`*^9, 
   3.5486898509993963`*^9}, {3.5486899233424187`*^9, 3.5486899406375437`*^9}, 
   3.548689976196454*^9, {3.548690073111355*^9, 3.548690093706411*^9}, 
   3.548700784181231*^9, 3.5487008869664307`*^9, 3.5487009363438873`*^9, 
   3.548701011877915*^9, 3.548701051714731*^9, 3.548701355463457*^9, 
   3.54870148623013*^9, 3.548701721192317*^9, 3.548706107867083*^9, 
   3.548706178719365*^9, 3.548706830498704*^9, 3.548706931673314*^9, 
   3.548707060981958*^9, 3.5487070937362957`*^9, 3.548707130959928*^9, 
   3.5487075033118687`*^9, {3.5487075361856728`*^9, 3.548707543868445*^9}, 
   3.5487075941211863`*^9, 3.54870765988807*^9, {3.548708098865366*^9, 
   3.548708110741102*^9}, 3.548708152053075*^9, 3.5487090897894697`*^9, 
   3.5487095923301783`*^9, 3.5487096278731213`*^9, 3.5487105758153343`*^9, 
   3.548710724061363*^9, 3.548710891101899*^9, 3.548711608382567*^9, 
   3.54871182012722*^9, 3.548711967213401*^9, 3.548712476558782*^9, 
   3.548712682466036*^9, 3.548712808819845*^9, 3.548713517465393*^9, {
   3.5487139688446302`*^9, 3.548713981611816*^9}, 3.548714014668714*^9, 
   3.5487140548563547`*^9, 3.548714102862442*^9, 3.548714135919199*^9, 
   3.548714169336607*^9, 3.548714219120474*^9, {3.548714277289854*^9, 
   3.54871435975707*^9}, 3.548714695418075*^9, 3.548715034169323*^9, {
   3.548715068017355*^9, 3.5487150869556313`*^9}, 3.548968568935875*^9, 
   3.549225149826618*^9, 3.5493892563921623`*^9, 3.5494196894171352`*^9, {
   3.549419782787603*^9, 3.5494197954026537`*^9}, 3.549419972635775*^9, 
   3.5494201443968143`*^9, 3.549421568455813*^9, 3.54946559197296*^9, 
   3.549465749141131*^9, 3.568647012700996*^9, 3.738609377594675*^9, 
   3.765484634948968*^9, 3.7654852603774157`*^9, 3.793410765346898*^9, 
   3.793904660420961*^9, 3.823229931745326*^9},
 CellLabel->
  "Out[3609]=",ExpressionUUID->"f7ae039e-130d-4c4e-ac99-8295cace6968"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tbal1", ",", "Gssbal1"}], "}"}], "=", 
   RowBox[{
    RowBox[{"InternallyBalancedDecomposition", "[", "Gss1", "]"}], "//", 
    "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TraditionalForm", " ", "/@", " ", 
  RowBox[{"{", 
   RowBox[{"tbal1", ",", "Gssbal1"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.548688817163611*^9, 3.5486888292980947`*^9}, {
   3.54870621574509*^9, 3.548706234094401*^9}, 3.548707491395032*^9, {
   3.54870753158809*^9, 3.548707541013708*^9}, {3.549419821172666*^9, 
   3.549419854365831*^9}},
 CellLabel->
  "In[3610]:=",ExpressionUUID->"bd354c7a-1b0d-41e7-857f-0ad2a5e8b13a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    FormBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FractionBox["1", 
          SqrtBox["2"]], 
         RowBox[{"-", 
          FractionBox["1", 
           SqrtBox["2"]]}]},
        {
         FractionBox["1", "2"], 
         FractionBox["1", "2"]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}], "\[NoBreak]", ")"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     TemplateBox[{
       FormBox[
        RowBox[{"-", 
          FractionBox["3", "2"]}], TraditionalForm], 
       FormBox[
        RowBox[{"-", 
          FractionBox["1", "2"]}], TraditionalForm], 
       FormBox[
        RowBox[{"1", "+", 
          FractionBox["1", 
           SqrtBox["2"]]}], TraditionalForm], 
       FormBox[
        RowBox[{"-", 
          FractionBox["1", "2"]}], TraditionalForm], 
       FormBox[
        RowBox[{"-", 
          FractionBox["3", "2"]}], TraditionalForm], 
       FormBox[
        RowBox[{"1", "-", 
          FractionBox["1", 
           SqrtBox["2"]]}], TraditionalForm], 
       FormBox[
        RowBox[{"1", "+", 
          FractionBox["1", 
           SqrtBox["2"]]}], TraditionalForm], 
       FormBox[
        RowBox[{"1", "-", 
          FractionBox["1", 
           SqrtBox["2"]]}], TraditionalForm], 
       FormBox["0", TraditionalForm], 
       InterpretationBox["\[InvisibleSpace]", None], {
       StateSpaceModel, {
        False, False, {
         False, False}}, {$CellContext`stname1, $CellContext`stname2}, {{
         Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}, {
         Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, Identity, 
        Automatic, 1, 1, 2, 1, {}, {False, False}, False, Automatic, None, 
        Automatic}, {}},
      "StateSpaceModelFull",
      BaseStyle->{NumberMarks -> False},
      DisplayFunction->(TagBox[
        SubsuperscriptBox[
         RowBox[{"(", 
           
           GridBox[{{#, #2, #3}, {#4, #5, #6}, {#7, #8, #9}}, 
            AllowedDimensions -> {3, 3}, 
            GridBoxDividers -> {"Rows" -> {False, False, 
                Directive[
                 GrayLevel[0], 
                 GrayLevel[0.6]], {False}, False}, "Columns" -> {False, False, 
                Directive[
                 GrayLevel[0], 
                 GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
            "SystemsModelGrid00"], ")"}], #10, 
         ButtonBox[
          GraphicsBox[{
            
            RectangleBox[{0, 0}, DefaultBaseStyle -> 
             "SystemsModelSuperscript"], 
            InsetBox[
             StyleBox[
             "\[ScriptCapitalS]", DefaultBaseStyle -> 
              "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
          ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
            ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
          None], MultilineFunction -> None], 
        EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
              FrontEnd`Value[
               FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
          True}]]& ),
      InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
         RowBox[{"{", 
           RowBox[{"{", 
             RowBox[{"{", 
               TemplateSlotSequence[{1, 2}, ","], "}"}], ",", 
             RowBox[{"{", 
               TemplateSlotSequence[{4, 5}, ","], "}"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{"{", 
               TemplateSlotSequence[{3, 3}, ","], "}"}], ",", 
             RowBox[{"{", 
               TemplateSlotSequence[{6, 6}, ","], "}"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{"{", 
               TemplateSlotSequence[{7, 8}, ","], "}"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{"{", 
               TemplateSlotSequence[{9, 9}, ","], "}"}], "}"}], "}"}], ",", 
         "SamplingPeriod", "->", 
         RowBox[{#10}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
      Tooltip->StateSpaceModel],
     TraditionalForm],
    TraditionalForm,
    Editable->True]}], "}"}]], "Output",
 CellChangeTimes->{{3.548688822278283*^9, 3.5486888297923822`*^9}, {
   3.5486889210792847`*^9, 3.548688940672694*^9}, 3.548689256435231*^9, {
   3.548689355926578*^9, 3.54868951614501*^9}, {3.5486896125727577`*^9, 
   3.548689638328891*^9}, 3.5486897472632427`*^9, {3.548689837889019*^9, 
   3.548689851459519*^9}, {3.5486899241787663`*^9, 3.5486899414211473`*^9}, 
   3.5486899764702587`*^9, {3.54869007338478*^9, 3.54869009398383*^9}, 
   3.548700784724906*^9, 3.548700887349333*^9, 3.548700936712491*^9, 
   3.54870101215635*^9, 3.548701054608206*^9, 3.548701355997347*^9, 
   3.5487014867557287`*^9, 3.5487017217169867`*^9, 3.548706108310823*^9, 
   3.548706178883958*^9, 3.5487062352270193`*^9, 3.548706830659493*^9, 
   3.54870693184042*^9, 3.548707062430853*^9, 3.548707094059626*^9, 
   3.548707131302061*^9, {3.5487075226625767`*^9, 3.548707544010878*^9}, 
   3.548707594267249*^9, 3.5487076600383673`*^9, {3.548708099269455*^9, 
   3.5487081110501204`*^9}, 3.5487081523096857`*^9, 3.54870908993025*^9, 
   3.54870959247059*^9, 3.5487096280337048`*^9, 3.5487105759620447`*^9, 
   3.5487107243189898`*^9, 3.548710891262712*^9, 3.548711608489038*^9, 
   3.548711820268345*^9, 3.54871196735515*^9, 3.548712476785158*^9, 
   3.5487126826037703`*^9, 3.548712809071944*^9, 3.548713517610577*^9, {
   3.548713968986466*^9, 3.548713981936276*^9}, 3.548714015058824*^9, 
   3.548714054997755*^9, 3.54871410302177*^9, 3.548714136169895*^9, 
   3.548714169546733*^9, 3.5487142193307657`*^9, {3.548714277624*^9, 
   3.548714360156188*^9}, 3.548714695563653*^9, 3.54871503471062*^9, {
   3.5487150683162603`*^9, 3.548715087241933*^9}, 3.548968569067573*^9, 
   3.549225150037215*^9, 3.54938925704165*^9, 3.549419689557835*^9, {
   3.549419808526437*^9, 3.549419823430797*^9}, 3.549419855714744*^9, 
   3.5494199727206097`*^9, 3.549420144482354*^9, 3.5494215685041924`*^9, 
   3.5494655930151377`*^9, 3.549465749189568*^9, 3.568647013578478*^9, 
   3.738609379279869*^9, 3.765484636942874*^9, 3.76548526146708*^9, 
   3.79341076602365*^9, 3.7939046611045847`*^9, 3.823229932486154*^9},
 CellLabel->
  "Out[3611]=",ExpressionUUID->"b1e59f04-821d-49a1-918a-10ba5701c7ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"abal1", ",", "bbal1", ",", "cbal1", ",", "dbal1"}], "}"}], "=", 
  RowBox[{"Normal", "[", "Gssbal1", "]"}]}]], "Input",
 CellChangeTimes->{{3.5487111684078407`*^9, 3.548711181991383*^9}, {
  3.548711429742374*^9, 3.5487114313802023`*^9}},
 CellLabel->
  "In[3612]:=",ExpressionUUID->"dea38d95-56eb-413e-b835-fcd586531ff9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["3", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["3", "2"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        SqrtBox["2"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", "-", 
       FractionBox["1", 
        SqrtBox["2"]]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "+", 
       FractionBox["1", 
        SqrtBox["2"]]}], ",", 
      RowBox[{"1", "-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "0", "}"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.54871119998077*^9, 3.548711432045994*^9, 3.548711608516247*^9, 
   3.5487118203090343`*^9, 3.548711967510322*^9, 3.548712476827368*^9, 
   3.548712682731093*^9, 3.548712809122447*^9, 3.548713517763267*^9, {
   3.548713969127116*^9, 3.548713982015945*^9}, 3.548714015175301*^9, 
   3.5487140550398293`*^9, 3.548714103160823*^9, 3.548714136210298*^9, 
   3.5487141696401*^9, 3.548714219420148*^9, {3.548714277709227*^9, 
   3.5487143603301163`*^9}, 3.548714695684856*^9, 3.548715034752759*^9, {
   3.548715068352903*^9, 3.5487150874066133`*^9}, 3.5489685691032124`*^9, 
   3.549225150110612*^9, 3.549389257162957*^9, 3.549419689600713*^9, 
   3.549419863828808*^9, 3.549419972804256*^9, 3.549420144650732*^9, 
   3.549421568554769*^9, 3.5494655931292953`*^9, 3.549465749241068*^9, 
   3.568647013660239*^9, 3.7386093795162687`*^9, 3.765484637352969*^9, 
   3.765485261665431*^9, 3.7934107662105427`*^9, 3.793904661262464*^9, 
   3.823229932660433*^9},
 CellLabel->
  "Out[3612]=",ExpressionUUID->"e4e3d76f-7ce6-4285-82d4-d42128108484"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"atr1", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{"abal1", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"btr1", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"bbal1", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ctr1", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{"cbal1", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Gssbaltr1", "=", 
  RowBox[{"StateSpaceModel", "[", 
   RowBox[{"{", 
    RowBox[{"atr1", ",", "btr1", ",", "ctr1"}], "}"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.548708234694572*^9, 3.548708464404187*^9}, {
   3.548708509112927*^9, 3.5487085301122007`*^9}, {3.548708637246015*^9, 
   3.548708710088222*^9}, {3.548708768585642*^9, 3.548708816595726*^9}, {
   3.5487089950495377`*^9, 3.548709006317492*^9}, 3.548709078568112*^9, 
   3.5487114870424967`*^9, {3.548711527130274*^9, 3.548711542202251*^9}, {
   3.548711592540764*^9, 3.548711599882044*^9}, {3.548711948270685*^9, 
   3.5487119493660593`*^9}, {3.7386094106188087`*^9, 3.738609412744823*^9}},
 CellLabel->
  "In[3613]:=",ExpressionUUID->"23daa7d2-2e64-4c9f-a308-3b7713470f14"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", 
     FractionBox["3", "2"]}], 
   RowBox[{"1", "+", 
     FractionBox["1", 
      SqrtBox["2"]]}], 
   RowBox[{"1", "+", 
     FractionBox["1", 
      SqrtBox["2"]]}], "0", 
   InterpretationBox["\[InvisibleSpace]", None], {
   StateSpaceModel, {
    False, False, {False, False}}, {$CellContext`stname1}, {{
     Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$}}, Identity, Automatic, 1, 1, 1, 1, {}, {
    False, False}, False, Automatic, None, Automatic}, {}},
  "StateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{#, #2}, {#3, #4}}, AllowedDimensions -> {2, 2}, 
        GridBoxDividers -> {"Rows" -> {False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}, "Columns" -> {False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
        "SystemsModelGrid00"], ")"}], #5, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalS]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None], MultilineFunction -> None], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{2, 2}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{3, 3}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{4, 4}, ","], "}"}], "}"}], "}"}], ",", 
     "SamplingPeriod", "->", 
     RowBox[{#5}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
  Tooltip->StateSpaceModel]], "Output",
 CellChangeTimes->{{3.5487089997996798`*^9, 3.5487090068785267`*^9}, 
   3.548709089975779*^9, 3.548709592512452*^9, 3.5487096282040243`*^9, 
   3.54871057611594*^9, 3.5487107244734793`*^9, 3.5487108914328403`*^9, 
   3.5487114886050577`*^9, {3.548711528173481*^9, 3.54871154310144*^9}, 
   3.548711608549699*^9, 3.5487118203620043`*^9, 3.548711967566008*^9, 
   3.548712476877973*^9, 3.548712682784251*^9, 3.5487128091727667`*^9, 
   3.548713517814693*^9, {3.548713969183481*^9, 3.548713982099903*^9}, 
   3.54871401524321*^9, 3.548714055190359*^9, 3.5487141032137823`*^9, 
   3.5487141362559013`*^9, 3.548714169724217*^9, 3.54871421950651*^9, {
   3.548714277792688*^9, 3.548714360418056*^9}, 3.5487146957386017`*^9, 
   3.5487150348581877`*^9, {3.548715068398922*^9, 3.548715087491344*^9}, 
   3.5489685692183228`*^9, 3.549225150179529*^9, 3.5493892572171783`*^9, 
   3.5494196897354937`*^9, 3.54941986995153*^9, 3.549419972890018*^9, 
   3.549420144816285*^9, 3.54942156860423*^9, 3.5494655931665373`*^9, 
   3.5494657492916393`*^9, 3.568647013694147*^9, 3.73860937972845*^9, 
   3.738609414059988*^9, 3.765484637468541*^9, 3.765485261781557*^9, 
   3.793410766254547*^9, 3.793904661335875*^9, 3.823229932720628*^9},
 CellLabel->
  "Out[3616]=",ExpressionUUID->"759a7810-9ce4-47ed-87a1-72d423dd8e08"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ares1", "=", 
   RowBox[{
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"abal1", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{
         RowBox[{"abal1", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/", 
         RowBox[{"abal1", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "*", 
        RowBox[{"abal1", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}]}]}], "}"}], "]"}], "//", 
    "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bres1", "=", 
   RowBox[{
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"bbal1", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{
         RowBox[{"abal1", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/", 
         RowBox[{"abal1", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "*", 
        RowBox[{"bbal1", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}]}]}], "}"}], "]"}], "//", 
    "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cres1", "=", 
   RowBox[{
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"cbal1", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{
         RowBox[{"cbal1", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "/", 
         RowBox[{"abal1", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "*", 
        RowBox[{"abal1", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}]}]}], "}"}], "]"}], "//", 
    "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dres1", "=", 
   RowBox[{
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"cbal1", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "/", 
        RowBox[{"abal1", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "*", 
       RowBox[{"bbal1", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "}"}], "]"}], "//", 
    "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Gssbalres1", "=", 
  RowBox[{"StateSpaceModel", "[", 
   RowBox[{"{", 
    RowBox[{"ares1", ",", "bres1", ",", "cres1", ",", "dres1"}], "}"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.548712954437813*^9, 3.548713037447703*^9}, {
  3.548713108423177*^9, 3.54871328338659*^9}, {3.548713314747561*^9, 
  3.548713473083127*^9}, {3.549419891040719*^9, 3.549419909008288*^9}, {
  3.73860942082404*^9, 3.738609443352549*^9}},
 CellLabel->
  "In[3617]:=",ExpressionUUID->"d301924d-167d-4153-b8b1-622fd5e41646"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", 
     FractionBox["4", "3"]}], 
   RowBox[{
     FractionBox["2", "3"], " ", 
     RowBox[{"(", 
       RowBox[{"1", "+", 
         SqrtBox["2"]}], ")"}]}], 
   RowBox[{
     FractionBox["2", "3"], " ", 
     RowBox[{"(", 
       RowBox[{"1", "+", 
         SqrtBox["2"]}], ")"}]}], 
   RowBox[{"1", "-", 
     FractionBox[
      RowBox[{"2", " ", 
        SqrtBox["2"]}], "3"]}], 
   InterpretationBox["\[InvisibleSpace]", None], {
   StateSpaceModel, {
    False, False, {False, False}}, {$CellContext`stname1}, {{
     Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$}}, Identity, Automatic, 1, 1, 1, 1, {}, {
    False, False}, False, Automatic, None, Automatic}, {}},
  "StateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{#, #2}, {#3, #4}}, AllowedDimensions -> {2, 2}, 
        GridBoxDividers -> {"Rows" -> {False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}, "Columns" -> {False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
        "SystemsModelGrid00"], ")"}], #5, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalS]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None], MultilineFunction -> None], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{2, 2}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{3, 3}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{4, 4}, ","], "}"}], "}"}], "}"}], ",", 
     "SamplingPeriod", "->", 
     RowBox[{#5}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
  Tooltip->StateSpaceModel]], "Output",
 CellChangeTimes->{{3.548713464577064*^9, 3.548713477156331*^9}, 
   3.5487135178631897`*^9, {3.548713969228557*^9, 3.54871398218157*^9}, 
   3.5487140153269653`*^9, 3.5487140552416973`*^9, 3.5487141032643223`*^9, 
   3.548714136306429*^9, 3.548714169805359*^9, 3.548714219590185*^9, {
   3.548714277876786*^9, 3.548714360500227*^9}, 3.54871469578911*^9, 
   3.548715034975593*^9, {3.548715068448793*^9, 3.548715087574889*^9}, 
   3.548968569269045*^9, 3.5492251502467003`*^9, 3.549389257267548*^9, 
   3.549419689786129*^9, 3.549419875186249*^9, 3.549419911063944*^9, 
   3.5494199729719553`*^9, 3.549420144900198*^9, 3.549421568654738*^9, 
   3.549465593232428*^9, 3.54946574934242*^9, 3.568647013738965*^9, 
   3.738609379890073*^9, 3.738609454437675*^9, 3.7654846376150017`*^9, 
   3.765485261995995*^9, 3.793410766363881*^9, 3.7939046614519167`*^9, 
   3.823229932802834*^9},
 CellLabel->
  "Out[3621]=",ExpressionUUID->"65b497d9-0d70-4c04-9af7-288bf0c3301c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TransferFunctionModel", " ", "/@", " ", 
  RowBox[{"{", 
   RowBox[{
   "Gss1", ",", "Gsstr1", ",", "Gssres1", ",", "Gssbaltr1", ",", 
    "Gssbalres1"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.54870902425651*^9, 3.5487090849964848`*^9}, {
   3.548709186505382*^9, 3.548709187614213*^9}, {3.5487108476962357`*^9, 
   3.54871085501578*^9}, {3.548711916085752*^9, 3.54871192280389*^9}, {
   3.5487119563158493`*^9, 3.548711960508318*^9}, 3.548712667915134*^9, {
   3.5487127757015467`*^9, 3.548712776172081*^9}, {3.5487134814726267`*^9, 
   3.548713487746738*^9}, {3.549225165688044*^9, 3.549225172694982*^9}},
 CellLabel->
  "In[3622]:=",ExpressionUUID->"b26c9a5b-dffd-476b-884e-a591c2b43575"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    TemplateBox[{
      FractionBox[
       RowBox[{"4", "+", 
         RowBox[{"3", " ", "\[FormalS]"}]}], 
       RowBox[{"2", "+", 
         RowBox[{"3", " ", "\[FormalS]"}], "+", 
         SuperscriptBox["\[FormalS]", "2"]}]], 
      InterpretationBox["\[InvisibleSpace]", None], {
      TransferFunctionModel, {
       False, False, {False, False}}, $Failed, {{
        Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}}, 
       InterpretationBox[#, 
        TransferFunctionModel[{{{4 + 3 \[FormalS]}}, 2 + 
          3 \[FormalS] + \[FormalS]^2}, \[FormalS]], AutoDelete -> True, 
        Editable -> True, BaseStyle -> 
        "TransferFunctionModelMinimal"]& , \[FormalS], 1, 1, 
       Control`CountStates[
        TransferFunctionModel[{{{4 + 3 \[FormalS]}}, 2 + 
          3 \[FormalS] + \[FormalS]^2}, \[FormalS]]], 1, {}, {False, False}, 
       False, Automatic, None, Automatic}, {}},
     "TransferFunctionModelFull",
     BaseStyle->{NumberMarks -> False},
     DisplayFunction->(TagBox[
       SubsuperscriptBox[
        RowBox[{"(", 
          
          GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
           GridBoxDividers -> {
            "Rows" -> {False, {False}, False}, 
             "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
           "SystemsModelGrid00"], ")"}], #2, 
        ButtonBox[
         GraphicsBox[{
           
           RectangleBox[{0, 0}, DefaultBaseStyle -> 
            "SystemsModelSuperscript"], 
           InsetBox[
            StyleBox[
            "\[ScriptCapitalT]", DefaultBaseStyle -> 
             "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
         ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
           ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
         None], MultilineFunction -> None], 
       EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
             FrontEnd`Value[
              FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
         True}]]& ),
     InterpretationFunction->(
      RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
        RowBox[{"{", 
          RowBox[{"{", 
            TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", 
        "\[FormalS]", ",", "SamplingPeriod", "->", 
        RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
     Tooltip->TransferFunctionModel],
    TransferFunctionModel[{{{4 + 3 \[FormalS]}}, 2 + 
      3 \[FormalS] + \[FormalS]^2}, \[FormalS]],
    AutoDelete->True,
    BaseStyle->"TransferFunctionModelMinimal",
    Editable->True], ",", 
   InterpretationBox[
    TemplateBox[{
      RowBox[{"-", 
        FractionBox["1", 
         RowBox[{
           RowBox[{"-", "1"}], "-", "\[FormalS]"}]]}], 
      InterpretationBox["\[InvisibleSpace]", None], {
      TransferFunctionModel, {
       False, False, {False, False}}, $Failed, {{
        Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}}, 
       InterpretationBox[#, 
        TransferFunctionModel[{{{-1}}, -1 - \[FormalS]}, \[FormalS]], 
        AutoDelete -> True, Editable -> True, BaseStyle -> 
        "TransferFunctionModelMinimal"]& , \[FormalS], 1, 1, 
       Control`CountStates[
        TransferFunctionModel[{{{-1}}, -1 - \[FormalS]}, \[FormalS]]], 
       1, {}, {False, False}, False, Automatic, None, Automatic}, {}},
     "TransferFunctionModelFull",
     BaseStyle->{NumberMarks -> False},
     DisplayFunction->(TagBox[
       SubsuperscriptBox[
        RowBox[{"(", 
          
          GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
           GridBoxDividers -> {
            "Rows" -> {False, {False}, False}, 
             "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
           "SystemsModelGrid00"], ")"}], #2, 
        ButtonBox[
         GraphicsBox[{
           
           RectangleBox[{0, 0}, DefaultBaseStyle -> 
            "SystemsModelSuperscript"], 
           InsetBox[
            StyleBox[
            "\[ScriptCapitalT]", DefaultBaseStyle -> 
             "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
         ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
           ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
         None], MultilineFunction -> None], 
       EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
             FrontEnd`Value[
              FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
         True}]]& ),
     InterpretationFunction->(
      RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
        RowBox[{"{", 
          RowBox[{"{", 
            TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", 
        "\[FormalS]", ",", "SamplingPeriod", "->", 
        RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
     Tooltip->TransferFunctionModel],
    TransferFunctionModel[{{{-1}}, -1 - \[FormalS]}, \[FormalS]],
    AutoDelete->True,
    BaseStyle->"TransferFunctionModelMinimal",
    Editable->True], ",", 
   InterpretationBox[
    TemplateBox[{
      FractionBox[
       RowBox[{
         RowBox[{"-", "2"}], "-", "\[FormalS]"}], 
       RowBox[{
         RowBox[{"-", "1"}], "-", "\[FormalS]"}]], 
      InterpretationBox["\[InvisibleSpace]", None], {
      TransferFunctionModel, {
       False, False, {False, False}}, $Failed, {{
        Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}}, 
       InterpretationBox[#, 
        TransferFunctionModel[{{{-2 - \[FormalS]}}, -1 - \[FormalS]}, \
\[FormalS]], AutoDelete -> True, Editable -> True, BaseStyle -> 
        "TransferFunctionModelMinimal"]& , \[FormalS], 1, 1, 
       Control`CountStates[
        TransferFunctionModel[{{{-2 - \[FormalS]}}, -1 - \[FormalS]}, \
\[FormalS]]], 1, {}, {False, False}, False, Automatic, None, Automatic}, {}},
     "TransferFunctionModelFull",
     BaseStyle->{NumberMarks -> False},
     DisplayFunction->(TagBox[
       SubsuperscriptBox[
        RowBox[{"(", 
          
          GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
           GridBoxDividers -> {
            "Rows" -> {False, {False}, False}, 
             "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
           "SystemsModelGrid00"], ")"}], #2, 
        ButtonBox[
         GraphicsBox[{
           
           RectangleBox[{0, 0}, DefaultBaseStyle -> 
            "SystemsModelSuperscript"], 
           InsetBox[
            StyleBox[
            "\[ScriptCapitalT]", DefaultBaseStyle -> 
             "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
         ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
           ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
         None], MultilineFunction -> None], 
       EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
             FrontEnd`Value[
              FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
         True}]]& ),
     InterpretationFunction->(
      RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
        RowBox[{"{", 
          RowBox[{"{", 
            TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", 
        "\[FormalS]", ",", "SamplingPeriod", "->", 
        RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
     Tooltip->TransferFunctionModel],
    TransferFunctionModel[{{{-2 - \[FormalS]}}, -1 - \[FormalS]}, \[FormalS]],
    
    AutoDelete->True,
    BaseStyle->"TransferFunctionModelMinimal",
    Editable->True], ",", 
   InterpretationBox[
    TemplateBox[{
      RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"1", "+", 
              FractionBox["1", 
               SqrtBox["2"]]}], ")"}], "2"], 
         RowBox[{
           RowBox[{"-", 
             FractionBox["3", "2"]}], "-", "\[FormalS]"}]]}], 
      InterpretationBox["\[InvisibleSpace]", None], {
      TransferFunctionModel, {
       False, False, {False, False}}, $Failed, {{
        Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}}, 
       InterpretationBox[#, 
        TransferFunctionModel[{{{-(1 + 2^Rational[-1, 2])^2}}, 
          Rational[-3, 2] - \[FormalS]}, \[FormalS]], AutoDelete -> True, 
        Editable -> True, BaseStyle -> 
        "TransferFunctionModelMinimal"]& , \[FormalS], 1, 1, 
       Control`CountStates[
        TransferFunctionModel[{{{-(1 + 2^Rational[-1, 2])^2}}, 
          Rational[-3, 2] - \[FormalS]}, \[FormalS]]], 1, {}, {False, False}, 
       False, Automatic, None, Automatic}, {}},
     "TransferFunctionModelFull",
     BaseStyle->{NumberMarks -> False},
     DisplayFunction->(TagBox[
       SubsuperscriptBox[
        RowBox[{"(", 
          
          GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
           GridBoxDividers -> {
            "Rows" -> {False, {False}, False}, 
             "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
           "SystemsModelGrid00"], ")"}], #2, 
        ButtonBox[
         GraphicsBox[{
           
           RectangleBox[{0, 0}, DefaultBaseStyle -> 
            "SystemsModelSuperscript"], 
           InsetBox[
            StyleBox[
            "\[ScriptCapitalT]", DefaultBaseStyle -> 
             "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
         ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
           ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
         None], MultilineFunction -> None], 
       EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
             FrontEnd`Value[
              FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
         True}]]& ),
     InterpretationFunction->(
      RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
        RowBox[{"{", 
          RowBox[{"{", 
            TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", 
        "\[FormalS]", ",", "SamplingPeriod", "->", 
        RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
     Tooltip->TransferFunctionModel],
    TransferFunctionModel[{{{-(1 + 2^Rational[-1, 2])^2}}, 
      Rational[-3, 2] - \[FormalS]}, \[FormalS]],
    AutoDelete->True,
    BaseStyle->"TransferFunctionModelMinimal",
    Editable->True], ",", 
   InterpretationBox[
    TemplateBox[{
      FractionBox[
       RowBox[{
         RowBox[{
           RowBox[{"-", 
             FractionBox["4", "3"]}], " ", 
           RowBox[{"(", 
             RowBox[{"1", "-", 
               FractionBox[
                RowBox[{"2", " ", 
                  SqrtBox["2"]}], "3"]}], ")"}]}], "-", 
         RowBox[{
           FractionBox["4", "9"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "+", 
                SqrtBox["2"]}], ")"}], "2"]}], "+", 
         RowBox[{
           RowBox[{"(", 
             RowBox[{
               RowBox[{"-", "1"}], "+", 
               FractionBox[
                RowBox[{"2", " ", 
                  SqrtBox["2"]}], "3"]}], ")"}], " ", "\[FormalS]"}]}], 
       RowBox[{
         RowBox[{"-", 
           FractionBox["4", "3"]}], "-", "\[FormalS]"}]], 
      InterpretationBox["\[InvisibleSpace]", None], {
      TransferFunctionModel, {
       False, False, {False, False}}, $Failed, {{
        Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}}, 
       InterpretationBox[#, 
        TransferFunctionModel[{{{
           Rational[-4, 3] (1 + Rational[-2, 3] 2^Rational[1, 2]) + 
            Rational[-4, 9] (1 + 2^Rational[1, 2])^2 + (-1 + 
              Rational[2, 3] 2^Rational[1, 2]) \[FormalS]}}, 
          Rational[-4, 3] - \[FormalS]}, \[FormalS]], AutoDelete -> True, 
        Editable -> True, BaseStyle -> 
        "TransferFunctionModelMinimal"]& , \[FormalS], 1, 1, 
       Control`CountStates[
        TransferFunctionModel[{{{
           Rational[-4, 3] (1 + Rational[-2, 3] 2^Rational[1, 2]) + 
            Rational[-4, 9] (1 + 2^Rational[1, 2])^2 + (-1 + 
              Rational[2, 3] 2^Rational[1, 2]) \[FormalS]}}, 
          Rational[-4, 3] - \[FormalS]}, \[FormalS]]], 1, {}, {False, False}, 
       False, Automatic, None, Automatic}, {}},
     "TransferFunctionModelMinimal",
     BaseStyle->{NumberMarks -> False},
     DisplayFunction->(TagBox[
       SubsuperscriptBox[
        RowBox[{"(", 
          GridBox[{{
             TooltipBox[
              StyleBox[
               StyleBox[
               "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #]}}, 
           AllowedDimensions -> {1, 1}, 
           GridBoxDividers -> {
            "Rows" -> {False, {False}, False}, 
             "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
           "SystemsModelGrid00"], ")"}], #2, 
        ButtonBox[
         GraphicsBox[{
           
           RectangleBox[{0, 0}, DefaultBaseStyle -> 
            "SystemsModelSuperscript"], 
           InsetBox[
            StyleBox[
            "\[ScriptCapitalT]", DefaultBaseStyle -> 
             "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
         ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
           ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
         None], MultilineFunction -> None], 
       EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
             FrontEnd`Value[
              FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
         True}]]& ),
     InterpretationFunction->(
      RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
        RowBox[{"{", 
          RowBox[{"{", 
            TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", 
        "\[FormalS]", ",", "SamplingPeriod", "->", 
        RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
     Tooltip->TransferFunctionModel],
    TransferFunctionModel[{{{
       Rational[-4, 3] (1 + Rational[-2, 3] 2^Rational[1, 2]) + 
        Rational[-4, 9] (1 + 2^Rational[1, 2])^2 + (-1 + 
          Rational[2, 3] 2^Rational[1, 2]) \[FormalS]}}, 
      Rational[-4, 3] - \[FormalS]}, \[FormalS]],
    AutoDelete->True,
    BaseStyle->"TransferFunctionModelMinimal",
    Editable->True]}], "}"}]], "Output",
 CellChangeTimes->{
  3.548709035426384*^9, 3.5487090900263453`*^9, 3.5487091892567453`*^9, 
   3.54870959256242*^9, 3.5487096282545137`*^9, 3.5487105761716127`*^9, 
   3.548710724531361*^9, 3.548710891489653*^9, 3.548711608585966*^9, 
   3.548711820510227*^9, 3.5487119676180067`*^9, 3.548712476929483*^9, 
   3.5487126828361588`*^9, 3.548712809226693*^9, 3.5487135179223747`*^9, {
   3.548713969284316*^9, 3.548713982267091*^9}, 3.548714015398156*^9, 
   3.548714055293508*^9, 3.548714103314896*^9, 3.548714136361067*^9, 
   3.548714169890821*^9, 3.548714219675873*^9, {3.54871427796028*^9, 
   3.548714360588097*^9}, 3.5487146958448887`*^9, 3.548715035046453*^9, {
   3.548715068501274*^9, 3.548715087660842*^9}, 3.5489685693217*^9, {
   3.549225150318687*^9, 3.5492251753308897`*^9}, 3.549389257317184*^9, 
   3.54941968984098*^9, 3.5494199208448763`*^9, 3.549419973057399*^9, 
   3.549420144988656*^9, 3.5494215686971283`*^9, 3.54946559327283*^9, 
   3.549465749392064*^9, 3.568647013788857*^9, 3.738609380418315*^9, 
   3.765484638135598*^9, 3.765485262494542*^9, 3.7934107667515707`*^9, 
   3.793904661741659*^9, 3.8232299331060743`*^9},
 CellLabel->
  "Out[3622]=",ExpressionUUID->"139a2b46-1955-40ae-8a49-d2a0dbfbf7f2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BodePlot", "[", 
    RowBox[{"{", 
     RowBox[{"Gss1", ",", "Gsstr1", ",", "Gssres1"}], "}"}], "]"}], ",", 
   RowBox[{"BodePlot", "[", 
    RowBox[{"{", 
     RowBox[{"Gss1", ",", "Gssbaltr1", ",", "Gssbalres1"}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellChangeTimes->{{3.548709111205864*^9, 3.548709126388239*^9}, {
   3.54870919285456*^9, 3.548709193926077*^9}, 3.5487108630665903`*^9, {
   3.548712025734366*^9, 3.548712033685768*^9}, 3.5487126730753*^9, {
   3.548712779781293*^9, 3.548712780043934*^9}, {3.548713492218501*^9, 
   3.548713492536783*^9}, {3.548713678559803*^9, 3.548713756870195*^9}},
 CellLabel->
  "In[3623]:=",ExpressionUUID->"c56072ef-bff3-4ab4-a5df-62eefefbf47e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {
       GraphicsBox[{{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV1Xk8VdvbAHBDZErGs4+iMuWmEm6mhruXufqpZOgWKWNRhm5caZJUbpTC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             "]]},
           Annotation[#, "Charting`Private`Tag$2020191#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwVl3k01Iv/xgeRcLXZrqQsbYhUotx87PS92lwUJRQlKUlJikqlSCJLlCyF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             "]]},
           Annotation[#, "Charting`Private`Tag$2020191#2"]& ], 
          TagBox[
           {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV1nc8ld8fAHAjQiXzPkYDaYiUQkJ9HrOlQTSoEIqKfCWVECplVMiMMkKi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             "]]},
           Annotation[#, "Charting`Private`Tag$2020191#3"]& ]}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{-1.3010299956639813`, -32.04391213499843},
        CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
            Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
            Part[#, 2]}& )},
        DisplayFunction->Identity,
        Frame->{{True, True}, {True, True}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{{{-40., 
             FormBox[
              RowBox[{"-", "40"}], TraditionalForm]}, {-30., 
             FormBox[
              RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
             FormBox[
              RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
             FormBox[
              RowBox[{"-", "10"}], TraditionalForm]}, {0., 
             FormBox["0", TraditionalForm]}, {10., 
             FormBox["10", TraditionalForm]}, {-40., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-38., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-36., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-34., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-32., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-30., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-30., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-28., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-26., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-24., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-22., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-18., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-16., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-14., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-12., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-10., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-10., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-8., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-6., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-4., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-2., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {0., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {0., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {2., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {4., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {6., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {8., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {10., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-13.015383276652027`, 
             FormBox[
              StyleBox[
              "\"9999\"", ShowContents -> False, StripOnInput -> False], 
              TraditionalForm], 0}}, {{-40., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-30., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-20., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-10., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {10., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-40., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-38., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-36., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-34., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-32., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-30., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-30., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-28., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-26., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-24., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-22., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-18., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-16., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-14., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-12., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-10., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-10., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-8., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-6., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-4., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-2., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {0., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {0., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {2., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {4., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {6., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {8., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {10., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}}}, {{{-1., 
             FormBox["0.1`", TraditionalForm]}, {0., 
             FormBox["1", TraditionalForm]}, {1., 
             FormBox["10", TraditionalForm]}, {2., 
             FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.5228787452803375, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.3979400086720376, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.3010299956639812, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.2218487496163563, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.1549019599857432, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.09691001300805639, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.04575749056067506, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.3010299956639812, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.47712125471966244`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.6020599913279624, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.6989700043360189, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.7781512503836436, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.8450980400142568, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.9030899869919435, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.9542425094393249, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.3010299956639813`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.4771212547196624`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.6020599913279623`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.6989700043360187`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.7781512503836436`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.845098040014257, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.9030899869919435`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.954242509439325, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}}, {{-1., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], 
              TraditionalForm]}, {-0.6989700043360187, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.5228787452803375, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.3979400086720376, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.3010299956639812, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.2218487496163563, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.1549019599857432, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.09691001300805639, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.04575749056067506, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.3010299956639812, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.47712125471966244`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.6020599913279624, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.6989700043360189, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.7781512503836436, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.8450980400142568, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.9030899869919435, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.9542425094393249, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.3010299956639813`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.4771212547196624`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.6020599913279623`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.6989700043360187`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.7781512503836436`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.845098040014257, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.9030899869919435`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.954242509439325, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}}}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImagePadding->All,
        Method->{"ScalingFunctions" -> None},
        PlotRange->{{-1.3010299956639813`, 
         1.6020599913279623`}, {-32.04391213499843, 6.013145581694376}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.02]}},
        Ticks->{{{-1., 
            FormBox["0.1`", TraditionalForm]}, {0., 
            FormBox["1", TraditionalForm]}, {1., 
            FormBox["10", TraditionalForm]}, {2., 
            FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.5228787452803375, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3979400086720376, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.2218487496163563, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.1549019599857432, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.09691001300805639, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.04575749056067506, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.47712125471966244`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6020599913279624, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6989700043360189, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.7781512503836436, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.8450980400142568, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9030899869919435, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9542425094393249, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.3010299956639813`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.4771212547196624`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6020599913279623`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6989700043360187`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.7781512503836436`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.845098040014257, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.9030899869919435`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.954242509439325, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}}, {{-40., 
            FormBox[
             RowBox[{"-", "40"}], TraditionalForm]}, {-30., 
            FormBox[
             RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
            FormBox[
             RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
            FormBox[
             RowBox[{"-", "10"}], TraditionalForm]}, {0., 
            FormBox["0", TraditionalForm]}, {10., 
            FormBox["10", TraditionalForm]}, {-40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-38., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-36., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-34., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-32., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-28., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-26., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-24., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-22., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-18., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-16., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-14., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-12., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-8., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-6., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-4., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-2., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {2., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {4., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {6., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {8., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-13.015383276652027`, 
            FormBox[
             StyleBox[
             "\"9999\"", ShowContents -> False, StripOnInput -> False], 
             TraditionalForm], 0}}}]},
      {
       GraphicsBox[{{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwVyXdQ03ccxnFSlV2EQ3AEKwGDyjCWAi0a+BIDGkc4SfJDr4q4EFQEigwJ
WlEPqrgHCoKWYawCVmrFIpj7fggK0hQMQ0CMEUIMXGQnQH5YQ9M/nnvf6x7a
nnhe1FcmJiZc4/7vUErQi9ktOtx26WKC0pMCHHdEj2zSYenP17tVvhQofh+Q
9axRh3lN96Y/BVJgW/AaTpxEh/3Snuw3D6OAxM7vn84/dbgxed53wmQK5JZ7
tJfe0OGZv/Uv2ZgCa5WOqi07dHi4PGNnRvhXcJM7NOt2vxaPzHd7z7g+C6ze
UUOuacax0sD2irtsCjnbY5mhhjH8mGZoC5RYQEPUg4dljmO4n3ARHOJ/DXVu
Mc7R1FEscXqYTOmxhdLKK1ebdw/jliX789Yz7WHvufD+7KhBPO9JdJjvCkc4
lKRjnE/U4CafcesLSQvhV3aHyrFoAM9N76qN1DlBdEZNQcR9Nb5+rclPVewM
20tU4NWiwim2wgTnIRe481bdtXZWH4ZM0wppEh2Sjw9q7W16cU1d3zHvC8th
zCZ2Up6kwOerpMNdUg+gGeZYWZ7oxuWBD1wl1QwYseeZ1eZ3YP4pQYjnbG9w
mKTLsz+3YvpGC84Vfx9o2E+Jy1vYjLuLlIvHOvzAXljfvlZSj7VzIlemCv1h
zy/el6ryxTjBQjR5+SwT3A+ylrlNl+G6srM/OFUhUAgDqnvu70HtPdZM+gEW
ODuvMKvdXYFGN6Z9iHVjg7nr7nsjNIwU6THqlbJgeB4Sw/8srUc7FzVa+Kau
gxL21Qabu83oWWvo409sDhwWhIcYpltRQ2rNMe3wBugpkzsfH+9A+b9Hb55b
uQkq5RXzEju7UXpn6MjWfVzwZn1hCNIUiBHfubFNFQrsqCKXDz69aIO7XeSU
3xaoZZvUZlv1oQFm3pmq3i0wapN1aKxLhbRp/oxNx8LgXKy5fUGTGnFZV9+w
HXgw3bcuVFw4gAL+WK0OuMGD9qGTWS75GmTxXGadb8+HU3ZpPMORQaTZbkmX
p/Ohl3bTPYc9jGiakJ6RDj6EK7tmvl88iqyqN1zkrxTAvaDgJz1mY+iR6VbZ
tykC8BzwivYwHUeiWyYRd6oFYGnqUdg2M47WLSDEnAkBtK4ydf1rQIvOnKHW
racTILsbeZf5UYe4zJmQtzwCqug347/IJlCZJXPK7CgBpJMSqFWTqH7QEubm
EhAfUWYrfzyFwitKPFOeEvC6lFfaWaBHd6jbHANfEyCkWCUOFuoRRyq9IDJ6
6bY6f4pIj/Q07StrGQFH5/g0uj/UI6u9/dndRrvschg4LtYjUYQn60grASkO
XfSlCj06waLm5L0h4JuMiKKEJSSaEW2ur35HwKsOhwOZriRitExMLJITcMSr
edWtZSSStZ8eEhr9qjsQ6hgkelDz2mf1ewISfZ0/OAaRqDS5fNlTBQEvNUon
8S4SBaccrC7pJSCBla9q2UeikqB9qSZKAhbl8svVMSRyWh5k2GF0XMiLNbY/
kUjhSz3o0EfAgkLRj3tPkkjb8kJ8WkWAZDLC5Wgmiewy/ZoURh/mOmrOnyXR
uV2nfvP/aPyns9KeXiFRPddVPGx0bBhiSXNItPpapZ6jJmD+/SnznjwSnY4p
mCk2WmJ4JNPdJlEVc7LlX6NjiZhci2ISqQ73xof3E/AfFRiNrg==
             "]]},
           Annotation[#, "Charting`Private`Tag$2021006#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwVzHs01HkYBnBRQzk7JUyp1JhxCVmlMqdVvsYwrM3EmPmV5Ag7kZBIRWtX
7cku2lqEahRyyaXUbpe1lb4vqqGkRrkkuTVpjoQZ05iftrHTH+95zuc8z3mt
IvbzRfp6enr+uvuaHw95PJgrVWEZO3J0wwgFfB2QTdhTFZbGnKlkKSlw6c2W
jH9bVdjdeXGNh5YCO7zcfOObVNh/cipPRDOEJhPXtu4bKqyfUsf7zDWEs1cc
X9YUqLCLfpBHcLUheA7TZAG7VHj8lFG8OtEICv0/Glx4P4UzpKyAQ8sWgPHr
5d55o0rsYMCiu5pTIT8kdjNPq8DpxfXMCkcTkIiqr9bSFFgUVvzK6aQpNNtG
06OWT2LF+pyczp9pUHMrJ7c9fBy/Yx03UJdZQGQ28T5LNIbv8zl3CzMtYd9B
lfPJxFHcscnHIlBNh2JOl4xWKseHp8YFmX5MiEq/WxRaNYJns6vEXfa2EFIm
AyepDE8/tG6x32gPF1+N9HgavMUigaI6MGcNJKeNTZlSh/Cmfbb5q4i1oKDG
qvsO9mPH7/Xfy4+6gJV2nvGCX3rxayaPmW+2ESZM+YaN4i5cyloUoZSzwFxt
05f1uQNzDseIy9u+A8meOfHnLNrxdGdD6vA6dzBNffTSs+kRtpPEX9I+9oCI
31xO14sb8H+zmsy2O57gEMO2s52pxSYTR+d33/CC/tQtdwarIlAmbzbZLY8L
dLq9YWP4deRXcHlu6HlfMGKGV05YYRTDufj0crIf3POODvr85BFyjE72CWBt
hTJOroRa3o4cVgav1qPwIE5AeGtnOlDSEc/wpHPbYLC2j56m7ELHIj2fsQsC
4FbfdbPE7l40bm33ZbFfILiwvzgLUvpRwhXe0O2hQOCIShkDG4YQ9/LeYNdk
PjRy9BqzjN+idvKbuoEJPkxSM/YpemSoxSK9iBoSBNmxRqZFT0dQ3BvfHrIx
CGbecnkNJXK0Oy79TDFNAC8/HstgiEdR7ox1hk+UAI6bpPC1SWNoqsD19A/V
AhiyKnTI54yjQHaWg++wAIjhnlmW5SS6HzKyMGGpECo9vG4OGiqQtDX2WZmX
ENbInaIcKUoUWfIEUuOFsIDiWPJiVom2qLgy51whdKylMP+RT6GFvdTt/teE
8Lw8rHzzOxX6EFyXNvBYCPU2hfu/PP+E1p8aWx80JARyxTAsr1ejivabXmUq
IewPrV3U9/c0iqRIOUoKAc9q+DXdRRrkJuH+8tqcgNQ5xoljJRp0U+Vz14JG
gPWO5k1zKjSo07KrY7vOR+ZtaHW4qkEDB8bPvNCZsdtcntagQZJXYVGtSwg4
ZN5jY92v+5dctr3OgoCV6aGlCatI9BfXRh1qSUBLl/neE0wSHfzTrK1Q5ySn
9rXn7UikCWOkS7/2ve7Q7Eyin+rkx71WEpC4kT5A8yBR3i6fT6tXEfBwdHhF
w24SbRVEXPxAJyCBLZZJfyTRHk1UGNOKgGVng66MRJNIcrh5dqfO8d4P3BYd
INGvwpb+Vp2XllTsjDxGIpm75dJKBgFN6lDGkRMkUt5719mnc5w/bfRkJomI
XHGSKVPXz2Sk3M4h0bp1y7al6xwbiNhP8kl0ijD647bOS6qmjQbPkcgs+9va
sa977bXnqgskqgsvrmZY6/bC6LPzL5EoLSLu9x06/w/iznxX
             "]]},
           Annotation[#, "Charting`Private`Tag$2021006#2"]& ], 
          TagBox[
           {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwt13k0Vd/bAHDzXJEokTFKhrgnqajHGA0UMpShkJLMmSMqJCmllKFEKENK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             "]]},
           Annotation[#, "Charting`Private`Tag$2021006#3"]& ]}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{-1.3010299956639813`, -88.56790362054922},
        CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
            Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
            Part[#, 2]}& )},
        DisplayFunction->Identity,
        Frame->{{True, True}, {True, True}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{{{-100., 
             FormBox[
              RowBox[{"-", "100"}], TraditionalForm]}, {-80., 
             FormBox[
              RowBox[{"-", "80"}], TraditionalForm]}, {-60., 
             FormBox[
              RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
             FormBox[
              RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
             FormBox[
              RowBox[{"-", "20"}], TraditionalForm]}, {0., 
             FormBox["0", TraditionalForm]}, {-100., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-95., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-90., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-85., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-80., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-80., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-75., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-70., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-65., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-60., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-60., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-55., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-50., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-45., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-40., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-40., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-35., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-30., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-25., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-15., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-10., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-5., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {0., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-44.28395181027461, 
             FormBox[
              StyleBox[
              "\"9999\"", ShowContents -> False, StripOnInput -> False], 
              TraditionalForm], 0}}, {{-100., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-80., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-60., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-40., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-20., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-100., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-95., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-90., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-85., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-80., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-80., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-75., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-70., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-65., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-60., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-60., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-55., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-50., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-45., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-40., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-40., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-35., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-30., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-25., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-15., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-10., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-5., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {0., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}}}, {{{-1., 
             FormBox["0.1`", TraditionalForm]}, {0., 
             FormBox["1", TraditionalForm]}, {1., 
             FormBox["10", TraditionalForm]}, {2., 
             FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.5228787452803375, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.3979400086720376, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.3010299956639812, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.2218487496163563, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.1549019599857432, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.09691001300805639, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.04575749056067506, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.3010299956639812, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.47712125471966244`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.6020599913279624, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.6989700043360189, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.7781512503836436, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.8450980400142568, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.9030899869919435, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.9542425094393249, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.3010299956639813`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.4771212547196624`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.6020599913279623`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.6989700043360187`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.7781512503836436`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.845098040014257, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.9030899869919435`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.954242509439325, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}}, {{-1., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], 
              TraditionalForm]}, {-0.6989700043360187, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.5228787452803375, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.3979400086720376, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.3010299956639812, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.2218487496163563, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.1549019599857432, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.09691001300805639, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.04575749056067506, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.3010299956639812, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.47712125471966244`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.6020599913279624, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.6989700043360189, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.7781512503836436, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.8450980400142568, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.9030899869919435, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.9542425094393249, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.3010299956639813`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.4771212547196624`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.6020599913279623`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.6989700043360187`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.7781512503836436`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.845098040014257, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.9030899869919435`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.954242509439325, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}}}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImagePadding->All,
        Method->{"ScalingFunctions" -> None},
        PlotRange->{{-1.3010299956639813`, 
         1.6020599913279623`}, {-88.56790362054922, 0.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.02]}},
        Ticks->{{{-1., 
            FormBox["0.1`", TraditionalForm]}, {0., 
            FormBox["1", TraditionalForm]}, {1., 
            FormBox["10", TraditionalForm]}, {2., 
            FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.5228787452803375, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3979400086720376, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.2218487496163563, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.1549019599857432, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.09691001300805639, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.04575749056067506, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.47712125471966244`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6020599913279624, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6989700043360189, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.7781512503836436, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.8450980400142568, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9030899869919435, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9542425094393249, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.3010299956639813`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.4771212547196624`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6020599913279623`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6989700043360187`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.7781512503836436`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.845098040014257, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.9030899869919435`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.954242509439325, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}}, {{-100., 
            FormBox[
             RowBox[{"-", "100"}], TraditionalForm]}, {-80., 
            FormBox[
             RowBox[{"-", "80"}], TraditionalForm]}, {-60., 
            FormBox[
             RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
            FormBox[
             RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
            FormBox[
             RowBox[{"-", "20"}], TraditionalForm]}, {0., 
            FormBox["0", TraditionalForm]}, {-100., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-95., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-90., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-85., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-80., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-80., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-75., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-70., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-65., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-60., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-60., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-55., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-50., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-45., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-35., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-25., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-15., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-5., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-44.28395181027461, 
            FormBox[
             StyleBox[
             "\"9999\"", ShowContents -> False, StripOnInput -> False], 
             TraditionalForm], 0}}}]}
     },
     AutoDelete->False,
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Grid"], ",", 
   TagBox[GridBox[{
      {
       GraphicsBox[{{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV1nk0lV0XAHCZrpTZvQ+KUIa8lAxl7NklumkeKEKE6q0M9VZUilKRkEpS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             "]]},
           Annotation[#, "Charting`Private`Tag$2024112#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV1Xk4VdsbB3CEY4gM5+wTUYiSUIYMUfsVmZLc0qQy9WsuQ91KuGiQiFAk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             "]]},
           Annotation[#, "Charting`Private`Tag$2024112#2"]& ], 
          TagBox[
           {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV1nk8FV8UAPDH87woZX0PqVAoJQrvjcicdiklJftaqYjQZiuUkCJKlBZL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             "]]},
           Annotation[#, "Charting`Private`Tag$2024112#3"]& ]}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{-1.3010299956639813`, -50.10300905956531},
        CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
            Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
            Part[#, 2]}& )},
        DisplayFunction->Identity,
        Frame->{{True, True}, {True, True}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{{{-60., 
             FormBox[
              RowBox[{"-", "60"}], TraditionalForm]}, {-50., 
             FormBox[
              RowBox[{"-", "50"}], TraditionalForm]}, {-40., 
             FormBox[
              RowBox[{"-", "40"}], TraditionalForm]}, {-30., 
             FormBox[
              RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
             FormBox[
              RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
             FormBox[
              RowBox[{"-", "10"}], TraditionalForm]}, {0., 
             FormBox["0", TraditionalForm]}, {10., 
             FormBox["10", TraditionalForm]}, {-60., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-58., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-56., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-54., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-52., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-50., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-50., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-48., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-46., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-44., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-42., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-40., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-40., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-38., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-36., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-34., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-32., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-30., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-30., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-28., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-26., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-24., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-22., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-18., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-16., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-14., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-12., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-10., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-10., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-8., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-6., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-4., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-2., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {0., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {0., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {2., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {4., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {6., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {8., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {10., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-22.044253565407963`, 
             FormBox[
              StyleBox[
              "\"9999\"", ShowContents -> False, StripOnInput -> False], 
              TraditionalForm], 0}}, {{-60., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-50., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-40., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-30., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-20., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-10., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {10., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-60., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-58., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-56., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-54., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-52., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-50., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-50., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-48., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-46., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-44., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-42., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-40., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-40., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-38., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-36., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-34., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-32., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-30., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-30., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-28., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-26., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-24., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-22., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-18., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-16., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-14., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-12., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-10., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-10., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-8., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-6., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-4., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-2., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {0., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {0., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {2., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {4., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {6., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {8., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {10., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}}}, {{{-1., 
             FormBox["0.1`", TraditionalForm]}, {0., 
             FormBox["1", TraditionalForm]}, {1., 
             FormBox["10", TraditionalForm]}, {2., 
             FormBox["100", TraditionalForm]}, {3., 
             FormBox["1000", TraditionalForm]}, {-0.6989700043360187, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.5228787452803375, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.3979400086720376, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.3010299956639812, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.2218487496163563, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.1549019599857432, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.09691001300805639, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.04575749056067506, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.3010299956639812, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.47712125471966244`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.6020599913279624, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.6989700043360189, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.7781512503836436, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.8450980400142568, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.9030899869919435, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.9542425094393249, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.3010299956639813`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.4771212547196624`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.6020599913279623`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.6989700043360187`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.7781512503836436`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.845098040014257, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.9030899869919435`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.954242509439325, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.3010299956639813`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.4771212547196626`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.6020599913279625`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.6989700043360187`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.7781512503836434`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.845098040014257, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.9030899869919438`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.9542425094393248`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}}, {{-1., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {3., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], 
              TraditionalForm]}, {-0.6989700043360187, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.5228787452803375, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.3979400086720376, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.3010299956639812, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.2218487496163563, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.1549019599857432, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.09691001300805639, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.04575749056067506, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.3010299956639812, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.47712125471966244`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.6020599913279624, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.6989700043360189, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.7781512503836436, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.8450980400142568, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.9030899869919435, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.9542425094393249, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.3010299956639813`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.4771212547196624`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.6020599913279623`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.6989700043360187`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.7781512503836436`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.845098040014257, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.9030899869919435`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.954242509439325, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.3010299956639813`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.4771212547196626`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.6020599913279625`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.6989700043360187`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.7781512503836434`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.845098040014257, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.9030899869919438`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.9542425094393248`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}}}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImagePadding->All,
        Method->{"ScalingFunctions" -> None},
        PlotRange->{{-1.3010299956639813`, 
         2.9696713533316514`}, {-50.10300905956531, 6.0145019287493815`}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.02]}},
        Ticks->{{{-1., 
            FormBox["0.1`", TraditionalForm]}, {0., 
            FormBox["1", TraditionalForm]}, {1., 
            FormBox["10", TraditionalForm]}, {2., 
            FormBox["100", TraditionalForm]}, {3., 
            FormBox["1000", TraditionalForm]}, {-0.6989700043360187, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.5228787452803375, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3979400086720376, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.2218487496163563, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.1549019599857432, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.09691001300805639, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.04575749056067506, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.47712125471966244`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6020599913279624, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6989700043360189, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.7781512503836436, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.8450980400142568, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9030899869919435, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9542425094393249, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.3010299956639813`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.4771212547196624`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6020599913279623`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6989700043360187`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.7781512503836436`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.845098040014257, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.9030899869919435`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.954242509439325, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.3010299956639813`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.4771212547196626`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.6020599913279625`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.6989700043360187`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.7781512503836434`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.845098040014257, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.9030899869919438`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.9542425094393248`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}}, {{-60., 
            FormBox[
             RowBox[{"-", "60"}], TraditionalForm]}, {-50., 
            FormBox[
             RowBox[{"-", "50"}], TraditionalForm]}, {-40., 
            FormBox[
             RowBox[{"-", "40"}], TraditionalForm]}, {-30., 
            FormBox[
             RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
            FormBox[
             RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
            FormBox[
             RowBox[{"-", "10"}], TraditionalForm]}, {0., 
            FormBox["0", TraditionalForm]}, {10., 
            FormBox["10", TraditionalForm]}, {-60., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-58., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-56., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-54., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-52., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-50., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-50., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-48., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-46., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-44., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-42., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-38., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-36., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-34., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-32., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-28., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-26., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-24., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-22., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-18., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-16., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-14., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-12., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-8., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-6., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-4., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-2., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {2., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {4., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {6., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {8., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-22.044253565407963`, 
            FormBox[
             StyleBox[
             "\"9999\"", ShowContents -> False, StripOnInput -> False], 
             TraditionalForm], 0}}}]},
      {
       GraphicsBox[{{{}, {}, 
          TagBox[
           {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV1Hk0lV0XAPCLe91MyRARcckYUSkpdU5RhiZx70PJkDIUFaEijYbSoEmR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             "]]},
           Annotation[#, "Charting`Private`Tag$2024612#1"]& ], 
          TagBox[
           {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV1Hk0VW8XB/BrvMYyT5EQlTITop5TVJQQ9x4hkkqpiAYZSkp4lVDJVMYM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             "]]},
           Annotation[#, "Charting`Private`Tag$2024612#2"]& ], 
          TagBox[
           {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
            Opacity[1.], LineBox[CompressedData["
1:eJwV1nc8Vf8fB3D7GonsmZHMSKIpn1Mk2z1mKSOVQmSvBmWLUskqJUqS7NU8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             "]]},
           Annotation[#, "Charting`Private`Tag$2024612#3"]& ]}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{-1.3010299956639813`, -89.9078400456949},
        CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
            Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
            Part[#, 2]}& )},
        DisplayFunction->Identity,
        Frame->{{True, True}, {True, True}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{{{-100., 
             FormBox[
              RowBox[{"-", "100"}], TraditionalForm]}, {-80., 
             FormBox[
              RowBox[{"-", "80"}], TraditionalForm]}, {-60., 
             FormBox[
              RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
             FormBox[
              RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
             FormBox[
              RowBox[{"-", "20"}], TraditionalForm]}, {0., 
             FormBox["0", TraditionalForm]}, {-100., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-95., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-90., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-85., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-80., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-80., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-75., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-70., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-65., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-60., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-60., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-55., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-50., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-45., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-40., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-40., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-35., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-30., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-25., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-15., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-10., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-5., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {0., 
             FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
              AbsoluteThickness[0.1]}}, {-44.95392002284745, 
             FormBox[
              StyleBox[
              "\"9999\"", ShowContents -> False, StripOnInput -> False], 
              TraditionalForm], 0}}, {{-100., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-80., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-60., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-40., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-20., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-100., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-95., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-90., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-85., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-80., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-80., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-75., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-70., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-65., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-60., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-60., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-55., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-50., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-45., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-40., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-40., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-35., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-30., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-25., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-20., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-15., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-10., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {-5., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}, {0., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
             
              AbsoluteThickness[0.1]}}}}, {{{-1., 
             FormBox["0.1`", TraditionalForm]}, {0., 
             FormBox["1", TraditionalForm]}, {1., 
             FormBox["10", TraditionalForm]}, {2., 
             FormBox["100", TraditionalForm]}, {3., 
             FormBox["1000", TraditionalForm]}, {-0.6989700043360187, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.5228787452803375, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.3979400086720376, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.3010299956639812, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.2218487496163563, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.1549019599857432, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.09691001300805639, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {-0.04575749056067506, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.3010299956639812, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.47712125471966244`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.6020599913279624, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.6989700043360189, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.7781512503836436, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.8450980400142568, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.9030899869919435, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {0.9542425094393249, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.3010299956639813`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.4771212547196624`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.6020599913279623`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.6989700043360187`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.7781512503836436`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.845098040014257, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.9030899869919435`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {1.954242509439325, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.3010299956639813`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.4771212547196626`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.6020599913279625`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.6989700043360187`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.7781512503836434`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.845098040014257, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.9030899869919438`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}, {2.9542425094393248`, 
             FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
              Thickness[0.001]}}}, {{-1., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {3., 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], 
              TraditionalForm]}, {-0.6989700043360187, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.5228787452803375, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.3979400086720376, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.3010299956639812, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.2218487496163563, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.1549019599857432, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.09691001300805639, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {-0.04575749056067506, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.3010299956639812, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.47712125471966244`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.6020599913279624, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.6989700043360189, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.7781512503836436, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.8450980400142568, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.9030899869919435, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {0.9542425094393249, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.3010299956639813`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.4771212547196624`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.6020599913279623`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.6989700043360187`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.7781512503836436`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.845098040014257, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.9030899869919435`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {1.954242509439325, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.3010299956639813`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.4771212547196626`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.6020599913279625`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.6989700043360187`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.7781512503836434`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.845098040014257, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.9030899869919438`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}, {2.9542425094393248`, 
             FormBox[
              TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 
             0.}, {
              Thickness[0.001]}}}}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImagePadding->All,
        Method->{"ScalingFunctions" -> None},
        PlotRange->{{-1.3010299956639813`, 
         2.9696713533316514`}, {-89.9078400456949, 0.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.02]}},
        Ticks->{{{-1., 
            FormBox["0.1`", TraditionalForm]}, {0., 
            FormBox["1", TraditionalForm]}, {1., 
            FormBox["10", TraditionalForm]}, {2., 
            FormBox["100", TraditionalForm]}, {3., 
            FormBox["1000", TraditionalForm]}, {-0.6989700043360187, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.5228787452803375, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3979400086720376, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.2218487496163563, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.1549019599857432, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.09691001300805639, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {-0.04575749056067506, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.3010299956639812, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.47712125471966244`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6020599913279624, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.6989700043360189, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.7781512503836436, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.8450980400142568, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9030899869919435, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {0.9542425094393249, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.3010299956639813`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.4771212547196624`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6020599913279623`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.6989700043360187`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.7781512503836436`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.845098040014257, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.9030899869919435`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {1.954242509439325, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.3010299956639813`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.4771212547196626`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.6020599913279625`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.6989700043360187`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.7781512503836434`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.845098040014257, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.9030899869919438`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}, {2.9542425094393248`, 
            FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
             Thickness[0.001]}}}, {{-100., 
            FormBox[
             RowBox[{"-", "100"}], TraditionalForm]}, {-80., 
            FormBox[
             RowBox[{"-", "80"}], TraditionalForm]}, {-60., 
            FormBox[
             RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
            FormBox[
             RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
            FormBox[
             RowBox[{"-", "20"}], TraditionalForm]}, {0., 
            FormBox["0", TraditionalForm]}, {-100., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-95., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-90., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-85., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-80., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-80., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-75., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-70., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-65., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-60., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-60., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-55., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-50., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-45., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-40., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-35., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-30., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-25., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-20., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-15., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-10., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-5., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {0., 
            FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
             AbsoluteThickness[0.1]}}, {-44.95392002284745, 
            FormBox[
             StyleBox[
             "\"9999\"", ShowContents -> False, StripOnInput -> False], 
             TraditionalForm], 0}}}]}
     },
     AutoDelete->False,
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Grid"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.548713758595652*^9, {3.5487139702902327`*^9, 3.5487139832794313`*^9}, 
   3.548714016133766*^9, 3.548714056340549*^9, 3.54871410410076*^9, 
   3.5487141374010077`*^9, 3.548714170882071*^9, 3.548714220652513*^9, {
   3.54871427910915*^9, 3.5487143615630713`*^9}, 3.548714696610632*^9, 
   3.548715036121442*^9, {3.548715069243973*^9, 3.5487150888000193`*^9}, 
   3.548968570042948*^9, 3.5492251510919113`*^9, 3.54938925811008*^9, 
   3.549419690564866*^9, 3.549419937100377*^9, 3.54941997410992*^9, 
   3.549420146030171*^9, 3.549421569741845*^9, 3.54946559450173*^9, 
   3.549465750189204*^9, 3.568647014688712*^9, 3.7386093821440268`*^9, 
   3.7654846397804623`*^9, 3.76548526387796*^9, 3.793410767390329*^9, 
   3.79390466250321*^9, 3.82322993379178*^9},
 CellLabel->
  "Out[3623]=",ExpressionUUID->"6a020471-188a-4ef7-a3cc-28e62bd2638e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"y1", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Gss1", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y2", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Gsstr1", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y3", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Gssres1", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y4", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Gssbaltr1", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y5", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Gssbalres1", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y1", ",", "y2", ",", "y3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y1", ",", "y4", ",", "y5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "5"}], "}"}]}], "]"}]}], "}"}]}], "Input",
 CellChangeTimes->{{3.5487094772947474`*^9, 3.548709562302648*^9}, 
   3.548709612930182*^9, {3.548709642953538*^9, 3.548709655874093*^9}, {
   3.548710473300984*^9, 3.5487105265955887`*^9}, {3.548710589522872*^9, 
   3.548710630489401*^9}, {3.548710740777034*^9, 3.548710768593237*^9}, {
   3.548710868276235*^9, 3.5487108870253973`*^9}, {3.548711971709775*^9, 
   3.548711972453451*^9}, {3.548712058495162*^9, 3.5487120679171267`*^9}, 
   3.548712676045354*^9, {3.548712783630024*^9, 3.5487128047184553`*^9}, {
   3.548713498020712*^9, 3.5487135130359097`*^9}, {3.5487138357705107`*^9, 
   3.548713893269702*^9}},
 CellLabel->
  "In[3624]:=",ExpressionUUID->"f3efc52e-3856-4f59-a9c2-596af1848bee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwV0X0w1HkcB/CVp1rrYf3UaKrdtbe11yap08hNfL6hS6iI7WF7OBZLKsrZ
plDJRUzHrXLJGrOHi4yQbruSp9ocLdrz1Fa36jZSk3BqbSx2v/e7Pz7zntc/
75n3fFyEibtjFlAolB3k/Z8l54RW66NTfSZQWSXncoFPWz8reC9rP4yxOwqd
+5IAt7f8yGIdgehGRaOyKwNKHuYyLVlnoFzhFpLUegWOeYuPTzNzQBJnrbSo
LIP+ubiCSWYR7Dn9sunRqTtgrRnijjOroFrZpxY4K6C0U3byI7MBJvaEy6RR
vVBbl6M55tYJudk0n5YqLcRCb9FYUj+INzaHtOrfQcLI6mF57UvoUy8+HLF5
DKguF7n/bNIC4Vmh68ibhDyHLl5pxDAg4w+B8emfQagJbzXvfgfnntiqW3dM
wck/LwoTuaPgdr7HO7RHD/UnaGHO28fhItvjzqTVNJSmHh113zsJyUG7826t
noEM2Xzo1NgnSN/gp/vOyQCUfi1qStGBgFF37vmgAVYli06H8/Tgetc92V86
C2/1hXtsmr9AoRPfbrfHHASOxJ+9cnIGtjzyXMxqn4OdbyVrGIxZQEmiUo3v
PIw+FqY/qZmDWc2/Touq5sGNrl7h970RhMET3llUI1BBHzmoMwG7oo5eITDC
tnHBNJtPQdFL/Ae+qTTCC0W0mcDVDG1fcwL4H4xwN7vtMEtvhpyYY1cx0wQi
S7FWpVqAFhbvV+aHmyAqKfUuTWqOFBnSIpd0E6yLXaMKjrRAbdNhKQEVJvjL
0dVG7GWJPjdTK127TNBYm1Hsam6F2LYH8l9/MEGqGS+k+5UV2le3K+EnawzU
wZSABLk1Utt0TpxxwTBS4VIgS1uIll81rWd6Yij4eqlFA38RMhbr5V8FY5BI
RR2RLCo6G9v1u/wQBkHBIRXtPRUZdtG0G49jmPG/YZC12KAHi6mnQtMwDI/4
nlZcoqHXu2q8DNkYyrzXL3saaYtmG8t+DfwFQ02mmB671g7Fe3CbS2QYLvGj
gsz1dshxiddI600MGwdLqy49tUdp1QlfquoxXF9dXPM0yAGJVlJurWzAcP5h
7vWgBgdUxI+qOfEQw45l/BudHDraQP2bN9iOYUtCxwF6Dh35y9dd2NKNQbZc
yOnW05GDFachqxcD53HltZ0HHNHUSkPP1DNy31oFr6/FEako9NqhlxhEOote
JY9AS29vW974CoOw/jMr52cCNWau3TqtxXAsI2w+MJ9Avh4xJos3GMRh8ue0
qwRqMU+vdySdrRfnSa4R6Il9vKUb6Vovw1xhCYFmNAejo0kbHmF1RTWB9jm7
mPWQlvTRcts6CBTST1GWDWGQlh+Py1ISyO3eq8d1pMuTVX4BXQQqvqm730T6
jyWS2S4VgTyYz/LVpAcFRFz/MwK1Wt4zLRrGwB1e6jc0TKAjjE0diaTd5SmM
30YIlDiuEaWR/jZTY4h5T6DXH99QckgHc0tufxglkN01BqeMdNJRFuPTJwJ9
8SzlDpBO23zBcEdHoCZ2iVRLOtN2aCBZT6Ceg/YLx0lfryu/PDNDoBf3I/os
35L/TreIfTBL9g/4r3MkXR0a45s2T6Aoj6osBmk5u32Fj4lABaGSFzzSLbpV
BowJdOrGPMeT9H/RG2Nh
         "]]},
       Annotation[#, "Charting`Private`Tag$2027062#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwVzns0lHkYB/Bxzc4Ma7yntnbCaNXkklRbtpLnh9AiG9NsjU7FyGCjtpgt
RkIKuy5jV3LJOohKqHani62dalwmZMp1dah1m2SYeRNvDMq++8dzvudznuc5
z2PFPx4QqkuhUHaT9X8WJ/ANNxwRuawOY+KOZDZ0snz3sXgQcs7IK4LJg8Um
6TkWKwIYPYUaj2URUPw409KAFQuJTW89ufRYiNwhjJqxTIfkarGwejYNOufD
c99ZFsB0/L1r1e35sKRviK22vA4mopah6ynXoLSl5MS4ZR1k8AmHw5p7UHsz
vS/SoQW+2HyXENTIIQzaCyZOdkIqJXwmo/EFHFPaDEtqX0KA5kZGMbsbqFYp
7H+/GYBZ1gfdwOiXkGXaalsaNAyjj3rXLDJeAb9v7yO9Z29g0Jm90dJvAE40
pvCPs1Ww5UprrNfrQbj9I52z/Fs1TPI2d6WtH4ZS0VGV4753kLdpyWpF7Agk
lyz4T09MQkbAMldjsRIonQPoYdwUyKMtnnBT38CaGMHpvbYEZJt94HXEjsII
cel72t8fYI/0to+N51vwVv5w5tcTs5C5XPDnlyZj4DcitrOwmIOh+5H596Rj
oKrnJz6tmYeL7/dLcjkqcGD0mLsf/ghxZf4Vx5UqoAIR3D/1CbrEaIQTNA5e
6sCZVVwK8vS8PxfbOw69siM6gfY6KC/Bu1HsNgF30hoOsQgdlMMMMtcWTYDA
QDigUOii0jwDfuLUBIScFN2hF+ohk3fThPMONawPs1P4Buuj+Z+pBbIENTw3
s6cJtxogbdOuqo9SNTyoTS6y1zNETgZVjuaEGkQ6tnuevTJEvi6H95nYaoDa
H7frmGQJ0p3hBbzYrwFlpVVuSbwR4hhzaFsTNZC7doV+Hfcz1EXUPemo1IC4
UCAPZlGRa6XVpv1yDQTmHlTQR6lI1FPVCSMamN1ZoS2R0lCS00FeAQWHYaXb
aVkqHXnWXTxwZjkOZTs2MNuCjVGIvyv+ej0ONeeFjLB1Jsgjdx2W445DKjfE
R48wQYOuX7825eKwub/0emrb50i2XXdhiwCHfJuimjYfUzTDLKNVxeBw9nFm
vk+dKTJIBmhNxmE3k1vRYs1AW5Y2R3tk4+B6TH6Akc5AtN+dEpoLcChZybd+
RjBQdrXqp6VXcLCuv5rnd8AMPeyzsZNV4yBeJ7PtkJohRGRVnJLgIJjSb2+2
xdDY41OXDR/iwL/9npWejaHvIm59FSrDITKZs+Cdg6FepxUOiaSFHMk/9N8w
lHSh3L6IdBohzBLnYaj+9AbDdtK1W7Xzl4oxZKTTYOdcj4P2yWJP5Q1yvsbT
w7SBvN9Bz2yQY4iiOdJ9sxGHwvKo8AvNGBIbq6KaSZfHKNx3tZL/GG2aHyJ9
d5l4rlVB9r2tp5c24dAfiIV3dpP7F4yDRKTZwyvch4YxxNuIrHfKcXCUxFlc
UWLIx8KPdpD0tvN92tBRDEW3Ro0KSfuyi2+NqTDklU8kXCV98ijLYnISQyWK
ajvqUxzinZO0f0xhqKBC8WAV6fPGQ10xBIaooWtdt5POv1n+y+wshtzS8+wi
SZcl6of9NYeh54ck4hTSN/xD3eIXMCT4tHL8MmnJqiZzl08YcmF2b7tDWjq1
Rru4iKEzgsGzbaT/A3dNVZU=
         "]]},
       Annotation[#, "Charting`Private`Tag$2027062#2"]& ], 
      TagBox[
       {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwVz3s01GkYB/BxGzWNavxWm4RxiUbTRbvb2bZ43k1rJ7dNGm1T7WYml+jG
MadCkkzYlrQ7x3UZl9UVSbKHhLCISYfZZKOImbWJY9Bkbubd3/7xnO/5/PGc
5/s48E/vCzWmUCj+5PyfhYl8qvuxeM+ZLcdsKBQltMuYfgeYB8GhNfCVN1UJ
uKPpMpN5HKL8Fxyv0pVQ2JJhb8Y8Dx3/enPp1ko44SE8uWCfDgcd3n8/664E
mS5CrLTPgw+vS2u8BUowHxpznba/DYNBq75b166Ekm5J9Hv7emAFz8wpEmeh
6l760IlN3VDWUfemQjUH4dCXNxUjA0fKKw+B+wc4pWCN11b9DWKdm2Bijwpo
DimuI1+Ogmfa46SBwx8hc2WPW8nRcdBurnt6cfcC8If2N5tI/4EzRUTeClc1
RP+Zwj/tOgk2/YpGpxk13D9DD1q9ZxrUFWsi23M0UBIfNbnlgBJ68i5bTuzU
QrJEH/hhaha8WVeLqV1aoMhGUWPcPMi3Xxu946UDl9iwc/vdVMBZqmO/a9SB
XJUTvOzxR1g/Mlj+iZMefBSRF36JVoM3/cFBi1Q9BMizNtjZaSH68DbpoRE9
TLbxk7oqdeBzns3rZi3CJsaArdePi+DRd6v/j5hFoIEqZHjeAJEc5hyrehG+
neYtOHIpyMnp8OLOqUUYbD1mxGMbIV8o53McDPAwrf0HpsoIdVlUZ+r9DRBm
Jhzt7TVGe3uM3VvOG0AQE/+Qnm+CzM9p44qKDLA5fEOvX4gpSvxG5BfSbIDn
luxlwu1mKEHg/CJxxACPqpIL2CZU9JsxNzdTa4B4I7e90tdU5CK5t8HcCgNt
OI5zqtYcXdKxWRFsDIobDmJJwhJ058pt0VqEQbze2rSeuxRNaoePHg/CkJUf
1hnCpCGmLMu6QoCBJz7SS5+gIc+oF+/sYzCod5drJE3LUEtBVYVfEoZxxa5z
ral0VDbcXen5M4ZSD3ebZyEWqOZW8dmZHAyVIiEjfONy5Nidnd5VgiGVK/A1
US1HSuaa02l3MHwxXHI79dkK9NbWKNHmAYZcVkHlM9+VSG/RZ8ZtwHCxJSPX
t34lMn4ikYQ+weBvwy3vdmaggp/k9aWdGL4+1XmIkc5A1Oc2zXIpBslavrNU
xUCcYOEjWj8G57ab2QGHLNGbabFVyAD538ZWt/4mS1Qc19m/4xWGsHnTvqdu
BIod3RFg8gYD//4cM/0agW59Pnh961sMJ5KD9D7XCTRVQP8UkRYG1b6k/0og
1BaY7U86TSXMzMomEL9x9eUI0lXbNbqcQgKlUMasikhrnuCBG3cJ1BJc5rhk
jLzfT89o7yQQ5WzN5EvS+WUnI648JVAXVVUnJ10W2+vF6SH7pORdmCVdtypL
29NLIM46Sy1tHMMwj4iQvSD326jVHqRdx629xsYJxLZmWpaS3lIbZ/e7gkAu
K26Kqkh/JRrShE4QqEFRN99A2s+1sPrdJIGcpXHNMtIxUUy72VkC7Q0fsDKT
Y0jYeUlTM08g6b6JIwzSIouxv2JVBBJtFRfbks69V3ZVrSZQye4eq22kS5NM
wxu0BIrYzOPsIn03MHRXgp5An13MFAaQrnXssPU0EEiSEVnII90076LBmECe
D5TNYaT/A+XQZBs=
         "]]},
       Annotation[#, "Charting`Private`Tag$2027062#3"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    Background->GrayLevel[0.97],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwV0X0w1HkcB/CVp1rrYf3UaKrdtbe11yap08hNfL6hS6iI7WF7OBZLKsrZ
plDJRUzHrXLJGrOHi4yQbruSp9ocLdrz1Fa36jZSk3BqbSx2v/e7Pz7zntc/
75n3fFyEibtjFlAolB3k/Z8l54RW66NTfSZQWSXncoFPWz8reC9rP4yxOwqd
+5IAt7f8yGIdgehGRaOyKwNKHuYyLVlnoFzhFpLUegWOeYuPTzNzQBJnrbSo
LIP+ubiCSWYR7Dn9sunRqTtgrRnijjOroFrZpxY4K6C0U3byI7MBJvaEy6RR
vVBbl6M55tYJudk0n5YqLcRCb9FYUj+INzaHtOrfQcLI6mF57UvoUy8+HLF5
DKguF7n/bNIC4Vmh68ibhDyHLl5pxDAg4w+B8emfQagJbzXvfgfnntiqW3dM
wck/LwoTuaPgdr7HO7RHD/UnaGHO28fhItvjzqTVNJSmHh113zsJyUG7826t
noEM2Xzo1NgnSN/gp/vOyQCUfi1qStGBgFF37vmgAVYli06H8/Tgetc92V86
C2/1hXtsmr9AoRPfbrfHHASOxJ+9cnIGtjzyXMxqn4OdbyVrGIxZQEmiUo3v
PIw+FqY/qZmDWc2/Touq5sGNrl7h970RhMET3llUI1BBHzmoMwG7oo5eITDC
tnHBNJtPQdFL/Ae+qTTCC0W0mcDVDG1fcwL4H4xwN7vtMEtvhpyYY1cx0wQi
S7FWpVqAFhbvV+aHmyAqKfUuTWqOFBnSIpd0E6yLXaMKjrRAbdNhKQEVJvjL
0dVG7GWJPjdTK127TNBYm1Hsam6F2LYH8l9/MEGqGS+k+5UV2le3K+EnawzU
wZSABLk1Utt0TpxxwTBS4VIgS1uIll81rWd6Yij4eqlFA38RMhbr5V8FY5BI
RR2RLCo6G9v1u/wQBkHBIRXtPRUZdtG0G49jmPG/YZC12KAHi6mnQtMwDI/4
nlZcoqHXu2q8DNkYyrzXL3saaYtmG8t+DfwFQ02mmB671g7Fe3CbS2QYLvGj
gsz1dshxiddI600MGwdLqy49tUdp1QlfquoxXF9dXPM0yAGJVlJurWzAcP5h
7vWgBgdUxI+qOfEQw45l/BudHDraQP2bN9iOYUtCxwF6Dh35y9dd2NKNQbZc
yOnW05GDFachqxcD53HltZ0HHNHUSkPP1DNy31oFr6/FEako9NqhlxhEOote
JY9AS29vW974CoOw/jMr52cCNWau3TqtxXAsI2w+MJ9Avh4xJos3GMRh8ue0
qwRqMU+vdySdrRfnSa4R6Il9vKUb6Vovw1xhCYFmNAejo0kbHmF1RTWB9jm7
mPWQlvTRcts6CBTST1GWDWGQlh+Py1ISyO3eq8d1pMuTVX4BXQQqvqm730T6
jyWS2S4VgTyYz/LVpAcFRFz/MwK1Wt4zLRrGwB1e6jc0TKAjjE0diaTd5SmM
30YIlDiuEaWR/jZTY4h5T6DXH99QckgHc0tufxglkN01BqeMdNJRFuPTJwJ9
8SzlDpBO23zBcEdHoCZ2iVRLOtN2aCBZT6Ceg/YLx0lfryu/PDNDoBf3I/os
35L/TreIfTBL9g/4r3MkXR0a45s2T6Aoj6osBmk5u32Fj4lABaGSFzzSLbpV
BowJdOrGPMeT9H/RG2Nh
         "]]},
       Annotation[#, "Charting`Private`Tag$2027113#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwV0H841AccB3A/jtp1yfVdv6Y4rSV36PeWLT6fXE8JaZR+nFk5nTsriroe
Rc2UpKIrlB+ZBxOWH6mrsUbdEUmuci0rjN1FT8oijjvuvt9998f7eT+vP97/
vB2FBwJFFmZmZpvp/N95J4TWy/fGee5cmilRjKZ7Nqo5fjs4uyAtvHdswDsG
qKb6kxxOBFzd9Oa0kJ8IefdTHaw4R+HExOWO9DWXYL+HNHLcIQV8ItOvuH5e
COpJScaQQzY08bNItb4apnRqnAYdykCq311WXayAgkf50e8caoFnW1C71+oZ
VFaldO53ewRRkrMlNpG9IIZn2e9j1NAQeYvxnbIfovqctfLKl1DMe+F2b8F7
YDqecupZ0wvt8jrFndQhSLNt5Rbs0YJCvCGYl/oRhJ3b7lk+7geLGUOrQiSj
EP3glPCA0wD85h4YFTKmg+qDrK1zNw3C9ppDmhWrx6Egbt/Ash1DoPGQdP4b
oofEfGPA6PthyO1SHZD4GsBM3Yt/HBuBPn65ueDTCVh8ODx2G1cHSaUuxqon
E/Bad2X7tLoxqHoptJOLJsGn74fjl6L1kH424VeX4Unwfy3j2dtPgBHCIqaG
G2GgQZjwsGIS2tZkzbveYAQ39osF/N0mOOmj7vz7MxMwQRfaNUJCcoi8tHyP
CTYOCsYXBpnh6u5z2oQCE/yl3GsucDHH4aSHPS0dJrh9pvF7js4cv5FuNK23
JCHcStqrUlngV0XWohoeCWExcbdZOZa4il1/YbYfCUvFPJVfKAO75zgfihWT
8GSmyzSpuxUGaHqMxgQS7lYm5rpYWmP5lrXifZkkxJlzv33cbY3bempXSkpJ
YHYd846ST8FzJYLxLTUk9F1zzMiPn4pelQ1zbR6QkLFkHqM26BOM977WM/CU
BFlOeHMoh4kBkteSiFckCDJCVKw3TAx09NkRoyFBv77YkF8/DetOBUuH3pKg
7fOKVSazcJDrkT30gYRCj+V2baHT8Wlb9/wkHQkVSVK22NUGS92UFkYD/VNQ
mK+lzgYFRa4lShMJq7sKypLbZqC7naPdRnMKspxzK9p8bfHorP7xOQwKfryf
muVba4sumdTPt60p2GwXVPxoERuXuGsO9k+lYF1UczA7hY3t2XcrS5gU5M8X
LnqsYyOVXFiziUXBooaSy/7BM1HiWrcuazoFMlclt71+Jn7ZzPO/ZUNB+Ajj
WQuXwJYK1y/uzqBAWP2Rk3KBwOBZiog0Wwr2J241+lwk8Gb0rOcXaUu3yjtY
6QT+GMZdm0n7jE6aJrtMoP9wrtVV2pXuhskreQRS2qbjZbQNCurFtev0PiqR
0Uhb1s5KbWwmsDVPJh2nnVMUKTndQuCRbmXOBO2iwyq+dyuBnBXaOhPtO7Nl
E60qAs+fHzFZsinoEhAS9Z8Exn6MFdnSdtLO42u0BI6RXuoltJfJj9n/0kdg
22x9B4/210mdBtEbAncV33jlRtvPKe/G2wECI/Ysf7WKdsw+jv3wMIGhtzIV
SDt+7U+GmyMEdr87e4dPO2m65vlhHYGn9allG2hnVRWd0+sJ/FCuTPGjXZjA
EP8+QaDmn7EjW2hfDxB5xRsJFFl5CgNpyxc2LfAkCRwNzvYNol0/sthAUQR6
OjNX7qT9HzigXRQ=
         "]]},
       Annotation[#, "Charting`Private`Tag$2027113#2"]& ], 
      TagBox[
       {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwVz3tU0ncYBnBMLEMr4bdZrUI0F4u0UdbWzd5v6kxLu5nZbLWBKWVK6ZGm
4rJMMzMML8dbx8xIujg1TbouVuZ0pVLJcjZt4QUtUw+KJHjhu9/+eM9zPv88
53kd+Ud3hU6jUCj+5P2fRSf401ccFG/8clWxmeNTDnVqll8Q63swN27e6L+j
EnC98jSLdRiWB39WW1l2C4oeSxysWHHAzc1yXVZVDRHuosgxhzSQR/TsVSnu
gHriUI7OoQDmsd4ft5QrYUZ7F3vQ4Qb8kN6ePJ3RACXPi6M+OtyHNZrwu7s+
tEBFZVp7xPLnwNR1no4t04AAXhUMRKuh7fa3FxTnekGoXdpdU/EGqpKGFB55
H4HmmMx+t0YDZjtrPwpXBxl2jZySn7rh4KIVRLXTCPDbd/9u2dQLPpn7GVbj
eoj6I5l/lN0Pl4IexL9IN0DVMduAeb6DIK7Ju+qi/gQl4iP93CAdhLolCufM
NEJS8eTO0YFh2Dzoz95rZQKKWoN+i9cD58CGtj3/mmBJTFjsbo4BoEOxjvh1
HHoMeXtsHn0C3Y2BQnnABGzRhv+SFWWEoHDqgMPIBGzrkS5jMsdBko7PeMZN
Qv9T/sk/yydAUCbrDembhOX01kWeP06BVY/A/fb2KaCBgdehN8P1n4XWsqtT
5I7gMadAClq4SvKic3QK2moPWgS7WCCPhlGe91ozKM7WHWAZLJDgnuPn5mNm
CLMSaVSqaWhuadnKu6VmCIkWK2wLLdEFJ4rrlZdm+FqwTOXHo6KV65nCcwYz
vGC42IjWWiEvsdg+ZR6GhxVJF10spyMGt2LCYjUGsQVnR9Nb0sxTbrrtGGgd
8T7CmhnofG4BvTcMg1bumFOcYI28biXGXozDkPPVfOr9wJlI+vrSN7vSMUgL
wxp4LBoqMn7wUxZgCM7Zr7Lto6HLAghcIsdg9Co1FStt0Ot6a+/+KgzdWo/Y
2lRbdO3e5QeJDzFccV+xoJk3Cx3RD4qkdRjKU0R0getsJGsdOjDciCE1MGSr
pWE2kkguhfu2YFjdUXIjtXkOsmdl0/zaMOQvvVjevNUOLZ5VOsV9iyHxsSR/
6307NFceafGqE4P/gsDS58501HeK61WrxbBJ2LCPnkZHM9Qv04zvMRQv5Ds3
GejoSa9307QBDM5Pr+Vu28dA0sXX9ycMkf+51nJalAw0hGZ+V6TDEKanvnrG
IdBUZaa6ZAQDv2qElXaBQNtSsyXeoxgikgImt2QSaKXu5mF/0qKAmr9tswnk
2KPctJv0WYMoQ5pLIN5LrZZHumKtaSKviEAM5yhzAmnTE9wqLyNQZ0ZydDVp
aYutpK6BQKvvZhz/woChUBZ56Mwzst/mZiuLtCxG5enTSKD6GJobm/Qde+l4
o4pA4CHTuJHuCCYOqV8TSJMZNcefNLt7vmdXN4Fa1oQ8OkGaWxPPvKol0CBV
3ZVMel1Kuym0j0C+625S00n7sYtufegn0Jhvnnse6egjLObwMIFWFciTK0kn
bDhlqtYT6F3AeYmCdMqsrr9iDAQScvqzHpLOr5SlG40EEkTaZzeQvnKSKngw
TqDusfeSZtJlO0M9EiYJdOyf9Slq0jVO9Ys2mglk50iPe0NaqV9iwphABa3h
h9+R/g/AiGqh
         "]]},
       Annotation[#, "Charting`Private`Tag$2027113#3"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    Background->GrayLevel[0.97],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.548713894660321*^9, {3.548713970922802*^9, 3.548713983726673*^9}, 
   3.548714016901279*^9, 3.548714056754998*^9, 3.548714105045651*^9, 
   3.548714137780221*^9, 3.548714171262149*^9, 3.548714221051503*^9, {
   3.5487142794746857`*^9, 3.548714361924263*^9}, 3.548714697163734*^9, 
   3.548715036532215*^9, {3.5487150698355103`*^9, 3.548715089081621*^9}, 
   3.548968570668357*^9, 3.549225152000814*^9, 3.5493892594369173`*^9, 
   3.549419691264099*^9, 3.549419974603229*^9, 3.549420146427923*^9, 
   3.549421570139866*^9, 3.5494655956319523`*^9, 3.549465750772716*^9, 
   3.568647015207267*^9, 3.738609382514629*^9, 3.765484640815563*^9, 
   3.765485264641395*^9, 3.793410767824292*^9, 3.793904662988768*^9, 
   3.823229934291559*^9},
 CellLabel->
  "Out[3629]=",ExpressionUUID->"d51321eb-5b8f-4388-adcf-c496e8e0b1b8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1bal", "=", 
   RowBox[{"ControllabilityGramian", "[", "Gssbal1", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q1bal", "=", 
   RowBox[{"ObservabilityGramian", "[", "Gssbal1", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"TraditionalForm", " ", "/@", " ", 
  RowBox[{"{", 
   RowBox[{"p1bal", ",", "q1bal"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.5486892912247667`*^9, 3.548689352443598*^9}, {
  3.549419982233919*^9, 3.549419992888982*^9}},
 CellLabel->
  "In[3630]:=",ExpressionUUID->"9da19413-4faf-444f-a33b-8304fbac9775"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    FormBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         RowBox[{
          FractionBox["1", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", 
             SqrtBox["2"]}]}], ")"}]}], "0"},
        {"0", 
         RowBox[{
          FractionBox["1", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "-", 
            RowBox[{"2", " ", 
             SqrtBox["2"]}]}], ")"}]}]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}], "\[NoBreak]", ")"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         RowBox[{
          FractionBox["1", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", 
             SqrtBox["2"]}]}], ")"}]}], "0"},
        {"0", 
         RowBox[{
          FractionBox["1", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "-", 
            RowBox[{"2", " ", 
             SqrtBox["2"]}]}], ")"}]}]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}], "\[NoBreak]", ")"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True]}], "}"}]], "Output",
 CellChangeTimes->{{3.548689308722517*^9, 3.5486893162693377`*^9}, {
   3.548689356024996*^9, 3.5486895162253313`*^9}, {3.548689612769814*^9, 
   3.5486896385190372`*^9}, 3.548689747343932*^9, {3.54868983797083*^9, 
   3.5486898515509663`*^9}, {3.54868992426632*^9, 3.548689941508811*^9}, 
   3.5486899766645*^9, {3.548690073578641*^9, 3.5486900941742373`*^9}, 
   3.548700784814801*^9, 3.548700887449037*^9, 3.548700936797117*^9, 
   3.5487010123461018`*^9, 3.548701054798562*^9, 3.548701356184054*^9, 
   3.548701486949078*^9, 3.5487017218961763`*^9, 3.5487061084871817`*^9, 
   3.548706178967196*^9, 3.5487068306997337`*^9, 3.548706931878467*^9, 
   3.548707062555068*^9, 3.5487070941737947`*^9, 3.548707131424444*^9, {
   3.5487075363890753`*^9, 3.5487075440516863`*^9}, 3.5487075943073683`*^9, 
   3.548707660107135*^9, {3.548708099386608*^9, 3.5487081111595*^9}, 
   3.548708152435831*^9, 3.548709090240573*^9, 3.548709593283025*^9, 
   3.548709629046976*^9, 3.548710577008215*^9, 3.548710725282373*^9, 
   3.548710892191278*^9, 3.5487116094080257`*^9, 3.548711821168201*^9, 
   3.5487119687509604`*^9, 3.548712477549265*^9, 3.548712683471036*^9, 
   3.5487128100373497`*^9, 3.5487135189536953`*^9, {3.548713970994802*^9, 
   3.5487139838103037`*^9}, 3.548714017002368*^9, 3.548714056838687*^9, 
   3.5487141052303*^9, 3.548714137886478*^9, 3.54871417134897*^9, 
   3.548714221133037*^9, {3.548714279552599*^9, 3.5487143620248528`*^9}, 
   3.548714697217342*^9, 3.5487150366194553`*^9, {3.548715069877936*^9, 
   3.54871508917089*^9}, 3.548968570717435*^9, 3.549225152107119*^9, 
   3.549389259635103*^9, 3.549419691349737*^9, {3.549419974683043*^9, 
   3.549419993785953*^9}, 3.549420146512432*^9, 3.549421570221188*^9, 
   3.54946559568011*^9, 3.5494657508230343`*^9, 3.568647015252635*^9, 
   3.738609382663623*^9, 3.7654846409032907`*^9, 3.765485264736766*^9, 
   3.793410767877877*^9, 3.793904663039507*^9, 3.823229934327923*^9},
 CellLabel->
  "Out[3632]=",ExpressionUUID->"d3b1b81b-2a12-421b-8270-737bc8f65eac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"Gssbal1", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.5486895301790953`*^9, 3.548689573425228*^9}, 
   3.738609447795073*^9},
 CellLabel->
  "In[3633]:=",ExpressionUUID->"917b8cd4-100f-4a89-a666-a83004cbaa92"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.548689549968123*^9, 3.548689573937805*^9}, {
   3.548689612818882*^9, 3.5486896385676727`*^9}, 3.548689747390504*^9, {
   3.5486898380980167`*^9, 3.5486898516012793`*^9}, {3.5486899243144007`*^9, 
   3.548689941557493*^9}, 3.548689976711532*^9, {3.548690073626768*^9, 
   3.5486900942241297`*^9}, 3.5487007848624573`*^9, 3.548700887499955*^9, 
   3.5487009368471527`*^9, 3.548701012394339*^9, 3.548701054847068*^9, 
   3.548701356234972*^9, 3.548701487002301*^9, 3.548701721942995*^9, 
   3.548706108537237*^9, 3.548706179018117*^9, 3.548706830732361*^9, 
   3.548706931925529*^9, 3.548707062610568*^9, 3.5487070942053223`*^9, 
   3.5487071314802713`*^9, {3.548707536438025*^9, 3.5487075441032953`*^9}, 
   3.5487075943603563`*^9, 3.548707660178083*^9, {3.548708099438753*^9, 
   3.548708111208775*^9}, 3.548708152492363*^9, 3.548709090278818*^9, 
   3.548709593332605*^9, 3.548709629230431*^9, 3.548710577135523*^9, 
   3.548710725330847*^9, 3.548710892237294*^9, 3.5487116094399233`*^9, 
   3.5487118212159986`*^9, 3.54871196882407*^9, 3.5487124775970697`*^9, 
   3.548712683507115*^9, 3.548712810092267*^9, 3.548713519006996*^9, {
   3.548713971060108*^9, 3.5487139838940973`*^9}, 3.548714017086014*^9, 
   3.5487140569227552`*^9, 3.5487141053127327`*^9, 3.548714137970084*^9, 
   3.548714171432589*^9, 3.548714221216723*^9, {3.548714279637801*^9, 
   3.548714362108678*^9}, 3.54871469726138*^9, 3.548715036701356*^9, {
   3.54871506992583*^9, 3.548715089251544*^9}, 3.548968570762207*^9, 
   3.549225152191077*^9, 3.549389259680036*^9, 3.549419691433816*^9, {
   3.549419974768528*^9, 3.549419999823677*^9}, 3.5494201465942507`*^9, 
   3.5494215703018084`*^9, 3.549465595712852*^9, 3.5494657508687153`*^9, 
   3.5686470152993183`*^9, 3.738609382814958*^9, 3.738609449183934*^9, 
   3.765484640921295*^9, 3.765485264812354*^9, 3.793410767884803*^9, 
   3.793904663045578*^9, 3.8232299343332863`*^9},
 CellLabel->
  "Out[3633]=",ExpressionUUID->"2b31d57a-961c-4042-9b2a-1fc8c5b7d7a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", " ", "/@", 
  RowBox[{"{", 
   RowBox[{"y1", ",", "y2", ",", "y3", ",", "y4", ",", "y5"}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.765484672478827*^9, 3.765484681499281*^9}},
 CellLabel->
  "In[3634]:=",ExpressionUUID->"ce81ca96-f60f-438d-9642-a7094d9779ec"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "t"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"Cosh", "[", "t", "]"}], "+", 
       RowBox[{"3", " ", 
        RowBox[{"Sinh", "[", "t", "]"}]}]}], ")"}], " ", 
     RowBox[{"UnitStep", "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"Cosh", "[", "t", "]"}], "+", 
       RowBox[{"Sinh", "[", "t", "]"}]}], ")"}], " ", 
     RowBox[{"UnitStep", "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"Cosh", "[", "t", "]"}], "+", 
       RowBox[{"Sinh", "[", "t", "]"}]}], ")"}], " ", 
     RowBox[{"UnitStep", "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]}], ")"}], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", "t"}], "/", "2"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"3", " ", "t"}], "/", "2"}]]}], ")"}], " ", 
     RowBox[{"UnitStep", "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"6", "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"2", " ", 
           SqrtBox["2"]}]}], ")"}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", "t"}], "/", "3"}]]}]}], ")"}], " ", 
     RowBox[{"UnitStep", "[", "t", "]"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.7654846836571608`*^9, 3.765485265674809*^9, 
  3.793410768354658*^9, 3.793904663486421*^9, 3.82322993479179*^9},
 CellLabel->
  "Out[3634]=",ExpressionUUID->"98452559-6f4e-4289-a9f0-44a0942090e4"]
}, Open  ]],

Cell["Look at 1d optimal Hankel approximant (computed in Scilab)", "Text",
 CellChangeTimes->{{3.549465343689934*^9, 3.549465350268951*^9}},
 FontSize->18,
 Background->GrayLevel[
  0.85],ExpressionUUID->"7fe5ca57-c6e1-44b7-a13a-961fc1d5fc69"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ah", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"-", 
      SqrtBox["2"]}], "}"}], "}"}]}], ";", " ", 
  RowBox[{"bh", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", "+", 
      FractionBox["1", 
       SqrtBox["2"]]}], "}"}], "}"}]}], ";", " ", 
  RowBox[{"ch", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["2", "3"], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["2"]}], ")"}]}], "}"}], "}"}]}], ";", 
  RowBox[{"dh", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       SqrtBox["2"], "3"]}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Gssh", "=", 
  RowBox[{"StateSpaceModel", "[", 
   RowBox[{"{", 
    RowBox[{"ah", ",", "bh", ",", "ch", ",", "dh"}], "}"}], "]"}]}]}], "Input",\

 CellChangeTimes->{{3.549466173981147*^9, 3.549466199390373*^9}},
 CellLabel->
  "In[3635]:=",ExpressionUUID->"6e971f3a-6661-4e18-b188-1384f39cb0b5"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", 
     SqrtBox["2"]}], 
   RowBox[{"1", "+", 
     FractionBox["1", 
      SqrtBox["2"]]}], 
   RowBox[{
     FractionBox["2", "3"], " ", 
     RowBox[{"(", 
       RowBox[{"1", "+", 
         SqrtBox["2"]}], ")"}]}], 
   RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox[
      SqrtBox["2"], "3"]}], 
   InterpretationBox["\[InvisibleSpace]", None], {
   StateSpaceModel, {
    False, False, {False, False}}, {$CellContext`stname1}, {{
     Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$}}, Identity, Automatic, 1, 1, 1, 1, {}, {
    False, False}, False, Automatic, None, Automatic}, {}},
  "StateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{#, #2}, {#3, #4}}, AllowedDimensions -> {2, 2}, 
        GridBoxDividers -> {"Rows" -> {False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}, "Columns" -> {False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
        "SystemsModelGrid00"], ")"}], #5, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalS]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None], MultilineFunction -> None], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{2, 2}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{3, 3}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{4, 4}, ","], "}"}], "}"}], "}"}], ",", 
     "SamplingPeriod", "->", 
     RowBox[{#5}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
  Tooltip->StateSpaceModel]], "Output",
 CellChangeTimes->{3.549465335095331*^9, 3.5494655968936996`*^9, 
  3.54946575204698*^9, 3.549466200021286*^9, 3.568647016016581*^9, 
  3.738609384164723*^9, 3.765484642163927*^9, 3.765485265855988*^9, 
  3.7934107684269667`*^9, 3.7939046635522623`*^9, 3.823229934843869*^9},
 CellLabel->
  "Out[3636]=",ExpressionUUID->"0fad483d-3331-4298-885d-108c600499cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"y6", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Gssh", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y1", ",", "y6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.1", ",", "5"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.549465551373652*^9, 3.549465720302402*^9}},
 CellLabel->
  "In[3637]:=",ExpressionUUID->"240ba51b-482d-432f-b951-5ebd6e5d4de8"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV0Xk4lHsbB3Cmw8le1KkkFaLFqxKlLDeDGq3EOWUvWSMK6RSRrJWTeEtm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       "]]},
     Annotation[#, "Charting`Private`Tag$2029117#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV0nk0ldsbB/CcNJCKqFsZIirhqhSpzvVwoigqQzeZyRhyTUdFhcpUN5QM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       "]]},
     Annotation[#, "Charting`Private`Tag$2029117#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-2.3025850929940455`, -1.2857909651340786`},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->NCache[{{-2.3025850929940455`, 
      Log[5]}, {-1.2857909651340786`, 
     0.6897497409649814}}, {{-2.3025850929940455`, 
    1.6094379124341003`}, {-1.2857909651340786`, 0.6897497409649814}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 
       6}]]& }, {{{-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.1\"", ShowStringCharacters -> False], 0.1, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.2\"", ShowStringCharacters -> False], 0.2, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 
       0.}}, {-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {0.6931471805599453, 
       FormBox["2", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}}, {-1.8971199848858813`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.4054651081081644, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.302585092994046, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}, {{-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, AutoDelete -> 
          True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {0.6931471805599453, 
       FormBox["2", TraditionalForm], {0.01, 0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.4054651081081644, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}}]]], "Output",
 CellChangeTimes->{{3.549465643292473*^9, 3.5494657522127247`*^9}, 
   3.549466202850268*^9, 3.568647016134428*^9, 3.738609384311985*^9, 
   3.76548464239227*^9, 3.765485266012746*^9, 3.7934107685358753`*^9, 
   3.7939046636418543`*^9, 3.823229934948234*^9},
 CellLabel->
  "Out[3638]=",ExpressionUUID->"2183c607-e247-4ca0-b595-e69fa0b09ab0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y6", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{
  3.549465661889164*^9, {3.5494657260523987`*^9, 3.549465729381858*^9}},
 CellLabel->
  "In[3639]:=",ExpressionUUID->"cd266190-fa8a-467b-95dd-ea27079d36e5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"(", 
    RowBox[{"9", "+", 
     RowBox[{"2", " ", 
      SqrtBox["2"]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"2", " ", 
         SqrtBox["2"]}]}], ")"}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         SqrtBox["2"]}], " ", "t"}]]}]}], ")"}], " ", 
   RowBox[{"UnitStep", "[", "t", "]"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.549465730035838*^9, 3.549465752495966*^9}, 
   3.549466208047435*^9, 3.5686470165731697`*^9, 3.738609385137692*^9, 
   3.765484643174728*^9, 3.7654852667341423`*^9, 3.793410768903043*^9, 
   3.793904663992812*^9, 3.8232299354205303`*^9},
 CellLabel->
  "Out[3639]=",ExpressionUUID->"ce9cb39b-66ae-4ace-8999-471fbd37dc86"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 652},
WindowMargins->{{Automatic, 171}, {Automatic, 62}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"309d5122-8414-4672-a142-536b168a27bc"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 438, 9, 99, "Section",ExpressionUUID->"e36dc579-bb69-469f-a318-4560cd98cdfb"],
Cell[1020, 33, 483, 12, 73, "Input",ExpressionUUID->"c784ee3f-5bd4-412e-b6b7-d8db167a091b"],
Cell[CellGroupData[{
Cell[1528, 49, 2053, 42, 68, "Input",ExpressionUUID->"772c0fb0-c674-483e-a0fb-9c6a9ea5b064"],
Cell[3584, 93, 3970, 82, 73, "Output",ExpressionUUID->"97d5747d-0d06-4176-b0ba-e497d1a3aeaf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7591, 180, 252, 5, 30, "Input",ExpressionUUID->"48c5019d-2c61-470a-b87b-5ccd77d23788"],
Cell[7846, 187, 2821, 63, 59, "Output",ExpressionUUID->"8341903a-95c9-405b-9295-9f1f29dbe92d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10704, 255, 1059, 28, 51, "Input",ExpressionUUID->"835d2f11-9edc-4395-bf26-6e7209741b0a"],
Cell[11766, 285, 483, 12, 51, "Output",ExpressionUUID->"897c589b-78af-4cde-b394-1b5f72fae46a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12286, 302, 1160, 33, 115, "Input",ExpressionUUID->"f52fce6c-5393-4733-abf6-6999f9ed3ddf"],
Cell[13449, 337, 3340, 69, 56, "Output",ExpressionUUID->"04893096-6bb3-499a-ac17-cbb7b3cd9884"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16826, 411, 1034, 26, 52, "Input",ExpressionUUID->"62483cd0-f923-4d21-b800-4f9f5175a42f"],
Cell[17863, 439, 3286, 69, 56, "Output",ExpressionUUID->"7d28edb1-0644-408c-afd8-f44f68cf80d0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21186, 513, 562, 13, 73, "Input",ExpressionUUID->"b10441e8-1079-4280-9221-d0d970cd8af7"],
Cell[21751, 528, 3675, 77, 65, "Output",ExpressionUUID->"f7ae039e-130d-4c4e-ac99-8295cace6968"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25463, 610, 686, 16, 52, "Input",ExpressionUUID->"bd354c7a-1b0d-41e7-857f-0ad2a5e8b13a"],
Cell[26152, 628, 6632, 153, 142, "Output",ExpressionUUID->"b1e59f04-821d-49a1-918a-10ba5701c7ec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32821, 786, 374, 8, 30, "Input",ExpressionUUID->"dea38d95-56eb-413e-b835-fcd586531ff9"],
Cell[33198, 796, 2015, 54, 54, "Output",ExpressionUUID->"e4e3d76f-7ce6-4285-82d4-d42128108484"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35250, 855, 1400, 34, 94, "Input",ExpressionUUID->"23daa7d2-2e64-4c9f-a308-3b7713470f14"],
Cell[36653, 891, 3706, 79, 102, "Output",ExpressionUUID->"759a7810-9ce4-47ed-87a1-72d423dd8e08"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40396, 975, 3085, 92, 262, "Input",ExpressionUUID->"d301924d-167d-4153-b8b1-622fd5e41646"],
Cell[43484, 1069, 3573, 83, 98, "Output",ExpressionUUID->"65b497d9-0d70-4c04-9af7-288bf0c3301c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47094, 1157, 718, 13, 30, "Input",ExpressionUUID->"b26c9a5b-dffd-476b-884e-a591c2b43575"],
Cell[47815, 1172, 15539, 355, 78, "Output",ExpressionUUID->"139a2b46-1955-40ae-8a49-d2a0dbfbf7f2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63391, 1532, 742, 16, 30, "Input",ExpressionUUID->"c56072ef-bff3-4ab4-a5df-62eefefbf47e"],
Cell[64136, 1550, 178532, 3410, 253, "Output",ExpressionUUID->"6a020471-188a-4ef7-a3cc-28e62bd2638e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[242705, 4965, 2112, 55, 136, "Input",ExpressionUUID->"f3efc52e-3856-4f59-a9c2-596af1848bee"],
Cell[244820, 5022, 15100, 296, 134, "Output",ExpressionUUID->"d51321eb-5b8f-4388-adcf-c496e8e0b1b8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[259957, 5323, 592, 15, 73, "Input",ExpressionUUID->"9da19413-4faf-444f-a33b-8304fbac9775"],
Cell[260552, 5340, 3844, 89, 67, "Output",ExpressionUUID->"d3b1b81b-2a12-421b-8270-737bc8f65eac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[264433, 5434, 325, 8, 30, "Input",ExpressionUUID->"917b8cd4-100f-4a89-a666-a83004cbaa92"],
Cell[264761, 5444, 2120, 33, 34, "Output",ExpressionUUID->"2b31d57a-961c-4042-9b2a-1fc8c5b7d7a2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[266918, 5482, 302, 7, 30, "Input",ExpressionUUID->"ce81ca96-f60f-438d-9642-a7094d9779ec"],
Cell[267223, 5491, 2095, 64, 118, "Output",ExpressionUUID->"98452559-6f4e-4289-a9f0-44a0942090e4"]
}, Open  ]],
Cell[269333, 5558, 243, 4, 54, "Text",ExpressionUUID->"7fe5ca57-c6e1-44b7-a13a-961fc1d5fc69"],
Cell[CellGroupData[{
Cell[269601, 5566, 1015, 35, 123, "Input",ExpressionUUID->"6e971f3a-6661-4e18-b188-1384f39cb0b5"],
Cell[270619, 5603, 2897, 72, 102, "Output",ExpressionUUID->"0fad483d-3331-4298-885d-108c600499cb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[273553, 5680, 540, 15, 52, "Input",ExpressionUUID->"240ba51b-482d-432f-b951-5ebd6e5d4de8"],
Cell[274096, 5697, 13645, 282, 239, "Output",ExpressionUUID->"2183c607-e247-4ca0-b595-e69fa0b09ab0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[287778, 5984, 239, 5, 30, "Input",ExpressionUUID->"cd266190-fa8a-467b-95dd-ea27079d36e5"],
Cell[288020, 5991, 838, 23, 74, "Output",ExpressionUUID->"ce9cb39b-66ae-4ace-8999-471fbd37dc86"]
}, Open  ]]
}, Open  ]]
}
]
*)

