(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     32558,        834]
NotebookOptionsPosition[     29550,        777]
NotebookOutlinePosition[     29947,        793]
CellTagsIndexPosition[     29904,        790]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Test different dithering distributions   (Problem 5.2)", "Section",
 CellChangeTimes->{{3.509373545980529*^9, 3.509373554722555*^9}, {
  3.758824199017335*^9, 3.758824205925455*^9}, {3.7933296225561323`*^9, 
  3.793329626147242*^9}},
 FontSize->24,ExpressionUUID->"9aecc511-0b4d-4c38-90d1-b95709567970"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{3.758819786434408*^9},
 FontSize->12,
 CellLabel->
  "In[698]:=",ExpressionUUID->"58ec39dc-ca72-4cd6-a9b4-a4985c503349"],

Cell["Uniform dither", "Text",
 CellChangeTimes->{{3.509373786951104*^9, 3.5093737917525167`*^9}, 
   3.758824267567628*^9},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"046a2859-e179-4b90-82de-93a371862b88"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Round", "[", 
    RowBox[{"x0", "+", "\[Xi]"}], "]"}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"\[Xi]", ",", 
     FractionBox[
      RowBox[{"-", "1"}], "2"], ",", 
     FractionBox["1", "2"]}], "}"}], ",", " ", 
   RowBox[{"Assumptions", " ", "\[Rule]", " ", 
    RowBox[{"0", "<", "x0", "<", "1"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5093735963408337`*^9, 3.509373608264618*^9}, {
  3.509375453145286*^9, 3.509375479055066*^9}},
 FontSize->12,
 CellLabel->
  "In[699]:=",ExpressionUUID->"d515e9a8-80b8-4b64-a346-6e1fddb76e48"],

Cell[BoxData["x0"], "Output",
 CellChangeTimes->{
  3.5093736160343533`*^9, 3.509374966890895*^9, {3.509375455592106*^9, 
   3.509375479651865*^9}, 3.530070539919938*^9, 3.758823961322661*^9, 
   3.758824110128139*^9, 3.758824284832652*^9, 3.758824346445003*^9, 
   3.758824419846259*^9, {3.758824514928594*^9, 3.758824532115369*^9}, 
   3.75882457014172*^9, 3.7588250359182262`*^9, 3.758825196975154*^9, 
   3.793329633308146*^9, 3.7933297621318407`*^9, 3.793892722108535*^9, 
   3.823224669380739*^9},
 FontSize->12,
 CellLabel->
  "Out[699]=",ExpressionUUID->"e259721d-19c1-4177-8554-4ddedd7c00d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{"x0", "+", "\[Xi]"}], "]"}], "-", "x0"}], ")"}], "2"], ",", 
   RowBox[{"{", 
    RowBox[{"\[Xi]", ",", 
     FractionBox[
      RowBox[{"-", "1"}], "2"], ",", 
     FractionBox["1", "2"]}], "}"}], ",", " ", 
   RowBox[{"Assumptions", " ", "\[Rule]", " ", 
    RowBox[{"0", "<", "x0", "<", "1"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.509373632553523*^9, 3.509373642173561*^9}, {
  3.5093754654683113`*^9, 3.509375473688017*^9}, {3.758824122242381*^9, 
  3.758824124326407*^9}},
 FontSize->12,
 CellLabel->
  "In[700]:=",ExpressionUUID->"1d219bba-9739-4142-9c52-7a07af4311ea"],

Cell[BoxData[
 RowBox[{"x0", "-", 
  SuperscriptBox["x0", "2"]}]], "Output",
 CellChangeTimes->{
  3.50937364330949*^9, 3.509374966936348*^9, {3.5093754678724117`*^9, 
   3.5093754743553257`*^9}, 3.5300705399614267`*^9, 3.7588239614240026`*^9, {
   3.758824110223002*^9, 3.758824131049672*^9}, 3.758824284913595*^9, 
   3.7588243465008917`*^9, 3.7588244199489737`*^9, {3.758824515027857*^9, 
   3.758824532222702*^9}, 3.758824570233595*^9, 3.758825035989978*^9, 
   3.75882519705311*^9, 3.793329633349544*^9, 3.793329762184516*^9, 
   3.793892722136496*^9, 3.82322466940771*^9},
 FontSize->12,
 CellLabel->
  "Out[700]=",ExpressionUUID->"2b2454e2-63cd-4f62-bb50-f0161283a2a8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"for", " ", "uniform", " ", "noise"}], ",", " ", 
   RowBox[{
    RowBox[{"<", "x", ">"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"x0", " ", 
      RowBox[{"(", 
       RowBox[{"no", " ", "bias"}], ")"}], " ", "but", " ", "Var"}], " ", "=",
      " ", 
     RowBox[{
      RowBox[{"x0", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x0"}], ")"}]}], " ", "\[Rule]", " ", 
      RowBox[{"depends", " ", "on", " ", "x0"}]}]}]}], ",", " ", 
   RowBox[{"which", " ", "is", " ", "no", " ", "good"}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.509373682599504*^9, 3.5093737401517887`*^9}, {
   3.509375013048538*^9, 3.509375015095606*^9}, {3.758824153978016*^9, 
   3.758824158143311*^9}, 3.758824543831931*^9},
 FontSize->12,
 CellLabel->
  "In[701]:=",ExpressionUUID->"8814e421-c54f-4df1-ba5c-a70e8057d2e7"],

Cell["Triangular dither", "Text",
 CellChangeTimes->{{3.509373773348391*^9, 3.509373778661447*^9}, {
  3.7588242628307447`*^9, 3.758824264874845*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"d1809062-fdf3-4546-862f-97d7ada152fd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Round", "[", 
     RowBox[{"x0", "+", "\[Xi]"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Abs", "[", "\[Xi]", "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Xi]", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", " ", "\[Rule]", " ", 
    RowBox[{"0", "<", "x0", "<", "1"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.509372824693529*^9, 3.509372859192575*^9}, {
  3.5093729159182034`*^9, 3.509372916936331*^9}, {3.509372981050613*^9, 
  3.5093729883672333`*^9}, {3.5093730420959463`*^9, 3.509373061113295*^9}, {
  3.509373367706677*^9, 3.509373402586947*^9}, {3.509373455071245*^9, 
  3.509373520521524*^9}},
 FontSize->12,
 CellLabel->
  "In[702]:=",ExpressionUUID->"86f46959-26d3-4b5a-a97d-6db2c731ded0"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {"x0", 
        RowBox[{
         RowBox[{"0", "<", "x0", "<", 
          FractionBox["1", "2"]}], "||", 
         RowBox[{
          FractionBox["1", "2"], "<", "x0", "<", "1"}]}]},
       {
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"4", " ", "x0"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["x0", "2"]}]}], ")"}]}], 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}},
      Selectable->True]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False,
  StripWrapperBoxes->True]], "Output",
 CellChangeTimes->{{3.509372976589983*^9, 3.509372993705441*^9}, {
   3.50937304343847*^9, 3.509373062488161*^9}, 3.509373388945524*^9, {
   3.509373448915457*^9, 3.509373522156363*^9}, 3.5093749651023083`*^9, 
   3.5300705379454536`*^9, 3.7588239574042587`*^9, 3.758824106396394*^9, 
   3.758824281090164*^9, 3.758824342798236*^9, 3.758824420414133*^9, {
   3.7588245154986134`*^9, 3.758824532687104*^9}, 3.758824570694324*^9, 
   3.758825036442466*^9, 3.758825197566247*^9, 3.7933296336613407`*^9, 
   3.793329762486535*^9, 3.793892723054385*^9, 3.8232246704369173`*^9},
 FontSize->12,
 CellLabel->
  "Out[702]=",ExpressionUUID->"14d3942b-f6e6-4b1f-8784-fb1d73ef5d4e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Round", "[", 
        RowBox[{"x0", "+", "\[Xi]"}], "]"}], "-", "x0"}], ")"}], "2"], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Abs", "[", "\[Xi]", "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Xi]", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", " ", "\[Rule]", " ", 
    RowBox[{"0", "<", "x0", "<", "1"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5093730724347982`*^9, 3.509373111856235*^9}, {
  3.509373249534177*^9, 3.5093732576275463`*^9}, {3.509373289448428*^9, 
  3.509373303558756*^9}, {3.5093741534947853`*^9, 3.509374241339954*^9}, {
  3.5093743394575777`*^9, 3.509374371549057*^9}, {3.7588239115265427`*^9, 
  3.758823915162117*^9}},
 FontSize->12,
 CellLabel->
  "In[703]:=",ExpressionUUID->"7f9dc048-975a-4ccd-9380-bef57f7f4ce5"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {
        FractionBox["1", "4"], 
        RowBox[{
         RowBox[{"0", "<", "x0", "<", 
          FractionBox["1", "2"]}], "||", 
         RowBox[{
          FractionBox["1", "2"], "<", "x0", "<", "1"}]}]},
       {
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"2", " ", "x0"}], "-", 
           RowBox[{"7", " ", 
            SuperscriptBox["x0", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["x0", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["x0", "4"]}]}], ")"}]}], 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}},
      Selectable->True]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False,
  StripWrapperBoxes->True]], "Output",
 CellChangeTimes->{
  3.509373115363689*^9, {3.509373251299128*^9, 3.509373261368436*^9}, {
   3.509373291519663*^9, 3.5093733060206127`*^9}, 3.509374155398283*^9, {
   3.509374186396592*^9, 3.50937424372862*^9}, {3.509374342287847*^9, 
   3.509374373812818*^9}, 3.509374966788268*^9, 3.530070539820745*^9, 
   3.7588239609678783`*^9, 3.758824109947227*^9, 3.7588242846737337`*^9, 
   3.758824346341011*^9, 3.7588244239662657`*^9, {3.7588245190747843`*^9, 
   3.7588245364115334`*^9}, 3.75882457428605*^9, 3.758825040016889*^9, 
   3.758825201131824*^9, 3.793329636501246*^9, 3.793329765304586*^9, 
   3.7938927346729383`*^9, 3.823224682532275*^9},
 FontSize->12,
 CellLabel->
  "Out[703]=",ExpressionUUID->"1d7004fe-19af-4d34-a77d-04c60b99892d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"for", " ", "triangular", " ", "noise"}], " ", "<", "x", ">"}], 
    " ", "=", " ", 
    RowBox[{
     RowBox[{"x0", " ", 
      RowBox[{"(", 
       RowBox[{"no", " ", "bias"}], ")"}], " ", "and", " ", "Var"}], " ", "=",
      " ", 
     FractionBox["1", "4"]}]}], ",", 
   RowBox[{"independent", " ", "of", " ", "x0"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.5093736539391117`*^9, 3.509373679694751*^9}, {
  3.79332971740156*^9, 3.793329718146927*^9}, {3.7938927323008003`*^9, 
  3.793892754327014*^9}},
 FontSize->12,
 CellLabel->
  "In[704]:=",ExpressionUUID->"9ce853c3-56a9-419d-b171-8ed0dd4ad788"],

Cell["Gaussian Noise (normal distribution)", "Text",
 CellChangeTimes->{{3.509375749498886*^9, 3.5093757527499332`*^9}, {
  3.509375800259933*^9, 3.50937581156752*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"d0e2cdc4-7c6c-4f47-90b5-b4766d196a91"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"DiscretePlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{"x0", "+", "\[Xi]"}], "]"}], " ", 
         RowBox[{"PDF", "[", 
          RowBox[{
           RowBox[{"NormalDistribution", "[", 
            RowBox[{"0", ",", 
             FractionBox["1", "2"]}], "]"}], ",", "\[Xi]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Xi]", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"AccuracyGoal", "\[Rule]", "8"}]}], "]"}], "-", "x0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x0", ",", "0", ",", "1", ",", "0.05"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "None"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"DiscretePlot", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Round", "[", 
            RowBox[{"x0", "+", "\[Xi]"}], "]"}], "-", "x0"}], ")"}], "2"], 
        " ", 
        RowBox[{"PDF", "[", 
         RowBox[{
          RowBox[{"NormalDistribution", "[", 
           RowBox[{"0", ",", 
            FractionBox["1", "2"]}], "]"}], ",", "\[Xi]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Xi]", ",", 
         RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x0", ",", "0", ",", "1", ",", "0.05"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0.3", ",", "0.35"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", "None"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.509375830658495*^9, 3.509375869027734*^9}, {
   3.509376004338901*^9, 3.509376062634735*^9}, {3.509376253636737*^9, 
   3.509376286058304*^9}, {3.5093763216760817`*^9, 3.509376346032428*^9}, {
   3.509376431853403*^9, 3.5093764427901506`*^9}, {3.509376523930718*^9, 
   3.509376543861459*^9}, {3.509376579379451*^9, 3.509376598577839*^9}, 
   3.509376675391919*^9, {3.530071778844289*^9, 3.530071822980055*^9}, {
   3.758824093370235*^9, 3.758824093816309*^9}, {3.758824466762519*^9, 
   3.758824482648018*^9}, {3.758824519942765*^9, 3.758824524453066*^9}, {
   3.758824655428885*^9, 3.758824666768796*^9}, {3.7588247638480043`*^9, 
   3.758824814926663*^9}, {3.758824913626513*^9, 3.758824914655179*^9}, {
   3.7588250018566933`*^9, 3.758825008030479*^9}, {3.793892783457902*^9, 
   3.793892863778872*^9}},
 FontSize->12,
 CellLabel->
  "In[705]:=",ExpressionUUID->"811beede-fe85-4636-9ff9-427239d2d51a"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{
        {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
         0.011000000000000001`], AbsoluteThickness[1.6], 
         TagBox[{},
          Annotation[#, "Charting`Private`Tag$464168#1"]& ]}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
          0.011000000000000001`], AbsoluteThickness[1.6], 
          LineBox[CompressedData["
1:eJxTTMoPSmVmYGBgBGJRIGZiQAMNfTazZoLASvuG+L4FNnru+yH8nfYNLvfr
TnOH7TcxBoHD9g1mi6exRMRB5U/aO3BKur+9mrgfYtAFewYJmZJnB5Kg6i/b
N5gfmAyST08DgWv2DMLhs1nh+m/aM6TvXXkGaP7ZMyBwx57hkfE1O6D9EPMe
2IMI3s8C+yDqH9oz5BTMtNJzt4eY/9ieYVV09ynuMHuI/if2DEFfa5gj4uwh
9j2zZwjrb3lzNdEeYt4Lewaz1ylPDyTZQ8x7ac+g/MIcJA8x77U9Q5pjBRNQ
P8S8N/YMZbUJJ4HmQ8x7Z8+w51SyBdB+iHkfQPQF3s8K+wBSc4mq
           "]], {}, {}},
         Annotation[#, "Charting`Private`Tag$464168#1"]& ]}, {}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{27.377551020408156`, 1.5000000000000568`}, {17., 
       0.5000000000000284}},
      Method->{
       "MessagesHead" -> DiscretePlot, "AxisPadding" -> Scaled[0.02], 
        "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
          Directive[
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.528488, 0.470624, 0.701351], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.772079, 0.431554, 0.102387], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.363898, 0.618501, 0.782349], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[1, 0.75, 0], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.647624, 0.37816, 0.614037], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.571589, 0.586483, 0.], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.915, 0.3325, 0.2125], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[
           0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
           AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
        "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
        Scaled[0.05]},
      PlotRange->{{0., 1.}, {-0.0022892476125688788`, 0.0022892456393950322`}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {154.43228008701894, -93.8949012258426},
      ImageScaled[{0.5, 0.5}], {289.943178224385, 178.84743090636687}], 
    InsetBox[
     GraphicsBox[{{
        {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
         0.011000000000000001`], AbsoluteThickness[1.6], 
         TagBox[{},
          Annotation[#, "Charting`Private`Tag$467516#1"]& ]}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
          0.011000000000000001`], AbsoluteThickness[1.6], 
          LineBox[CompressedData["
1:eJxTTMoPSmVmYGBgBGJRIGZiQIDHVlq/+i9fsZ81EwRW2gfHX//w8iaMv9M+
5OOz1RFvrtibGIPAYXthixMufJxXofIn7Qt/ffa11r1qDzHtgr279gu70NCr
UPWX7S+r3zbIr71qn54GAtfs7bZ02sxZCNN/036JvPaNwH1X7c+eAYE79rcv
tU45cAFm3gN7naeRnVLXYeofwuUh5j9G0/8Ebj7Evmf2l6D2Q8x7Ye8BdR/E
vJf2BVD3Q8x7bS8E9R/EvDdw/0PMe2cfAg0fiHkf7GHhBwBIf6C4
           "]], {}, {}},
         Annotation[#, "Charting`Private`Tag$467516#1"]& ]}, {}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0.3},
      DisplayFunction->Identity,
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{15.132653061224488`, 1.5}, {17., 0.5000000000000284}},
      Method->{
       "MessagesHead" -> DiscretePlot, "AxisPadding" -> Scaled[0.02], 
        "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
          Directive[
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.528488, 0.470624, 0.701351], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.772079, 0.431554, 0.102387], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.363898, 0.618501, 0.782349], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[1, 0.75, 0], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.647624, 0.37816, 0.614037], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.571589, 0.586483, 0.], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.915, 0.3325, 0.2125], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[
           0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
           AbsoluteThickness[1.6]], 
          Directive[
           RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
           AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
        "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
        Scaled[0.05]},
      PlotRange->{{0, 1.}, {0.3, 0.35}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], {457.174391281465, -93.8949012258426}, 
     ImageScaled[{0.5, 0.5}], {277.69828026520133, 178.84743090636687}]}, {}},
  
  ImageSize->Large,
  PlotRange->{{0, 605.484222388892}, {-187.7898024516852, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.509376255782688*^9, 3.5093762947987137`*^9}, 
   3.5093763778313026`*^9, 3.5093764434828463`*^9, {3.5093765914094467`*^9, 
   3.509376606545269*^9}, 3.509376677600197*^9, 3.530070542936026*^9, {
   3.530071784292088*^9, 3.53007182528069*^9}, 3.758823964037549*^9, 
   3.758824018309802*^9, {3.758824096516396*^9, 3.758824112497458*^9}, 
   3.758824287066608*^9, 3.758824348737129*^9, 3.758824426437668*^9, 
   3.7588244852126713`*^9, {3.758824521259569*^9, 3.75882453862551*^9}, 
   3.758824576444749*^9, 3.7588246712886257`*^9, {3.758824768730831*^9, 
   3.7588248176976233`*^9}, 3.758824917540991*^9, 3.758825010559514*^9, 
   3.758825042159264*^9, 3.758825203301113*^9, 3.793329638242465*^9, 
   3.793329766980938*^9, 3.793892736606423*^9, 3.7938928246139174`*^9, {
   3.793892855125671*^9, 3.7938928661442957`*^9}, 3.823224684463756*^9},
 FontSize->12,
 CellLabel->
  "Out[707]=",ExpressionUUID->"6d448062-dbe5-4829-bf29-5f54c7189963"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Adding", " ", "Gaussian", " ", "noise", " ", "gives", " ", 
   RowBox[{"mean", " ", "~", "x0"}], " ", "and", " ", "variance", " ", 
   "roughly", " ", "independent", " ", "of", " ", 
   RowBox[{"x0", " ", "--"}], " ", "but", " ", "not", " ", "quite"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.50937668852157*^9, 3.509376727982595*^9}, {
  3.75882455252907*^9, 3.758824563850127*^9}, {3.7933296603385153`*^9, 
  3.793329667488122*^9}},
 FontSize->12,
 CellLabel->
  "In[708]:=",ExpressionUUID->"2ddeb1a4-7069-46c2-b55b-cb635dd4ec5d"],

Cell["Subtractive dither (with uniform noise)", "Text",
 CellChangeTimes->{{3.509374769732476*^9, 3.509374794378688*^9}, 
   3.758824271133576*^9},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"73464da8-0ad7-4fb3-aefa-5b25c8af157e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Round", "[", 
     RowBox[{"x0", "+", "\[Xi]"}], "]"}], " ", "-", "\[Xi]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Xi]", ",", 
     FractionBox[
      RowBox[{"-", "1"}], "2"], ",", 
     FractionBox["1", "2"]}], "}"}], ",", " ", 
   RowBox[{"Assumptions", " ", "\[Rule]", " ", 
    RowBox[{"0", "<", "x0", "<", "1"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.509374882186553*^9, 3.509374884031949*^9}, {
  3.509375483026252*^9, 3.509375494448306*^9}},
 FontSize->12,
 CellLabel->
  "In[709]:=",ExpressionUUID->"5249189c-0635-4b1f-b5b2-844b3c543e73"],

Cell[BoxData["x0"], "Output",
 CellChangeTimes->{
  3.5093748863715*^9, 3.5093749673063374`*^9, {3.5093754872901487`*^9, 
   3.50937549535437*^9}, 3.5300705404306097`*^9, 3.758823961560542*^9, 
   3.7588241103479023`*^9, 3.758824285021064*^9, 3.7588243465798893`*^9, 
   3.758824424135701*^9, {3.758824521390279*^9, 3.758824538725191*^9}, 
   3.758824577052466*^9, 3.7588250423017473`*^9, 3.758825203433968*^9, 
   3.793329638475247*^9, 3.7933297671574287`*^9, 3.793892736769065*^9, 
   3.8232246845980673`*^9},
 FontSize->12,
 CellLabel->
  "Out[709]=",ExpressionUUID->"18ead941-7856-4a1f-bd24-1840d4635000"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{"x0", "+", "\[Xi]"}], "]"}], "-", "\[Xi]", "-", "x0"}], ")"}], 
    "2"], ",", 
   RowBox[{"{", 
    RowBox[{"\[Xi]", ",", 
     FractionBox[
      RowBox[{"-", "1"}], "2"], ",", 
     FractionBox["1", "2"]}], "}"}], ",", " ", 
   RowBox[{"Assumptions", " ", "\[Rule]", " ", 
    RowBox[{"0", "<", "x0", "<", "1"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5093749019445887`*^9, 3.509374903810792*^9}, {
  3.758824003593027*^9, 3.7588240058444433`*^9}},
 FontSize->12,
 CellLabel->
  "In[710]:=",ExpressionUUID->"6555893b-2cff-4564-b0bb-bdb72d5ccbe2"],

Cell[BoxData[
 FractionBox["1", "12"]], "Output",
 CellChangeTimes->{
  3.509374910673665*^9, 3.509374967594681*^9, 3.53007054079922*^9, 
   3.758823962534646*^9, 3.7588240075054607`*^9, 3.758824111311398*^9, 
   3.758824285976791*^9, 3.758824347578001*^9, 3.758824425152953*^9, {
   3.758824522446411*^9, 3.7588245397794724`*^9}, 3.758824578129519*^9, 
   3.758825043278339*^9, 3.758825204419301*^9, 3.793329639164065*^9, 
   3.793329767868689*^9, 3.793892739133972*^9, 3.823224687061809*^9},
 FontSize->12,
 CellLabel->
  "Out[710]=",ExpressionUUID->"aa9f1bdd-3280-4492-972d-23777fabe9d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", "%", "]"}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.50937493513065*^9, 3.509374954645693*^9}},
 FontSize->12,
 CellLabel->
  "In[711]:=",ExpressionUUID->"afee84e3-5c5c-4d09-a248-113a6bace663"],

Cell[BoxData["0.2886751345948129`"], "Output",
 CellChangeTimes->{{3.509374943968234*^9, 3.509374967631301*^9}, 
   3.530070540845525*^9, 3.758823962788765*^9, 3.758824010097348*^9, 
   3.758824111427196*^9, 3.758824286044063*^9, 3.758824347701047*^9, 
   3.758824425434957*^9, {3.758824522643746*^9, 3.758824539908812*^9}, 
   3.758824578258986*^9, 3.7588250433933973`*^9, 3.758825204544252*^9, 
   3.793329639170602*^9, 3.793329767875085*^9, 3.793892739209421*^9, 
   3.82322468712614*^9},
 FontSize->12,
 CellLabel->
  "Out[711]=",ExpressionUUID->"6cd1cdd3-7848-4563-bfa9-1bdfdd03f6d1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "Subtractive", " ", "dither", " ", "is", " ", "best", " ", "but", " ", 
   "harder", " ", "to", " ", "implement"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.5093749715405197`*^9, 3.509374997132414*^9}, {
  3.7938926848038*^9, 3.793892715838492*^9}},
 FontSize->12,
 CellLabel->
  "In[712]:=",ExpressionUUID->"5d7a7fb9-8db3-4ec8-9f9e-316e48571ff4"]
}, Open  ]]
},
WindowSize->{740, 652},
WindowMargins->{{Automatic, 161}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"c9d132ef-130a-4b57-8d3b-76be3cae3249"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 309, 4, 62, "Section",ExpressionUUID->"9aecc511-0b4d-4c38-90d1-b95709567970"],
Cell[891, 28, 231, 6, 29, "Input",ExpressionUUID->"58ec39dc-ca72-4cd6-a9b4-a4985c503349"],
Cell[1125, 36, 227, 5, 52, "Text",ExpressionUUID->"046a2859-e179-4b90-82de-93a371862b88"],
Cell[CellGroupData[{
Cell[1377, 45, 602, 16, 45, "Input",ExpressionUUID->"d515e9a8-80b8-4b64-a346-6e1fddb76e48"],
Cell[1982, 63, 601, 11, 33, "Output",ExpressionUUID->"e259721d-19c1-4177-8554-4ddedd7c00d1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2620, 79, 729, 20, 45, "Input",ExpressionUUID->"1d219bba-9739-4142-9c52-7a07af4311ea"],
Cell[3352, 101, 676, 13, 34, "Output",ExpressionUUID->"2b2454e2-63cd-4f62-bb50-f0161283a2a8"]
}, Open  ]],
Cell[4043, 117, 872, 23, 49, "Input",ExpressionUUID->"8814e421-c54f-4df1-ba5c-a70e8057d2e7"],
Cell[4918, 142, 253, 5, 52, "Text",ExpressionUUID->"d1809062-fdf3-4546-862f-97d7ada152fd"],
Cell[CellGroupData[{
Cell[5196, 151, 860, 21, 29, "Input",ExpressionUUID->"86f46959-26d3-4b5a-a97d-6db2c731ded0"],
Cell[6059, 174, 2234, 59, 65, "Output",ExpressionUUID->"14d3942b-f6e6-4b1f-8784-fb1d73ef5d4e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8330, 238, 945, 24, 32, "Input",ExpressionUUID->"7f9dc048-975a-4ccd-9380-bef57f7f4ce5"],
Cell[9278, 264, 2490, 66, 65, "Output",ExpressionUUID->"1d7004fe-19af-4d34-a77d-04c60b99892d"]
}, Open  ]],
Cell[11783, 333, 695, 19, 54, "Input",ExpressionUUID->"9ce853c3-56a9-419d-b171-8ed0dd4ad788"],
Cell[12481, 354, 271, 5, 52, "Text",ExpressionUUID->"d0e2cdc4-7c6c-4f47-90b5-b4766d196a91"],
Cell[CellGroupData[{
Cell[12777, 363, 2953, 73, 199, "Input",ExpressionUUID->"811beede-fe85-4636-9ff9-427239d2d51a"],
Cell[15733, 438, 9061, 207, 202, "Output",ExpressionUUID->"6d448062-dbe5-4829-bf29-5f54c7189963"]
}, Open  ]],
Cell[24809, 648, 586, 12, 49, "Input",ExpressionUUID->"2ddeb1a4-7069-46c2-b55b-cb635dd4ec5d"],
Cell[25398, 662, 250, 5, 52, "Text",ExpressionUUID->"73464da8-0ad7-4fb3-aefa-5b25c8af157e"],
Cell[CellGroupData[{
Cell[25673, 671, 630, 17, 45, "Input",ExpressionUUID->"5249189c-0635-4b1f-b5b2-844b3c543e73"],
Cell[26306, 690, 609, 11, 33, "Output",ExpressionUUID->"18ead941-7856-4a1f-bd24-1840d4635000"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26952, 706, 701, 20, 45, "Input",ExpressionUUID->"6555893b-2cff-4564-b0bb-bdb72d5ccbe2"],
Cell[27656, 728, 591, 11, 49, "Output",ExpressionUUID->"aa9f1bdd-3280-4492-972d-23777fabe9d6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28284, 744, 244, 6, 29, "Input",ExpressionUUID->"afee84e3-5c5c-4d09-a248-113a6bace663"],
Cell[28531, 752, 589, 10, 33, "Output",ExpressionUUID->"6cd1cdd3-7848-4563-bfa9-1bdfdd03f6d1"]
}, Open  ]],
Cell[29135, 765, 399, 9, 59, "Input",ExpressionUUID->"5d7a7fb9-8db3-4ec8-9f9e-316e48571ff4"]
}, Open  ]]
}
]
*)

