(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[    292470,       5991]
NotebookOptionsPosition[    285250,       5861]
NotebookOutlinePosition[    285648,       5877]
CellTagsIndexPosition[    285605,       5874]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 Cell[BoxData[
  InterpretationBox[Cell[
   "A general formula for analog low-pass Butterworth filters:",
    ExpressionUUID->"f2089ded-ee7b-4ac0-aa50-ca4de5876e0e"],
   TextCell["A general formula for analog low-pass Butterworth filters:"]]],
  CellChangeTimes->{{3.5029896553404503`*^9, 3.502989657648684*^9}},
  ExpressionUUID->"f1155760-9a98-46d8-b1b2-b30a08a5b156"],
 "\nProblem 5.1"
}], "Section",
 CellChangeTimes->{{3.50299006280584*^9, 3.5029900694040213`*^9}, {
  3.7933290236610518`*^9, 3.7933290270527983`*^9}},
 FontSize->18,ExpressionUUID->"a33e541d-973a-451a-b479-e7399703c180"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";", 
  RowBox[{
   RowBox[{"butterworth", "[", 
    RowBox[{"\[Omega]_", ",", 
     RowBox[{"n_", "?", "OddQ"}]}], "]"}], ":=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     RowBox[{
      FractionBox["\[Omega]", 
       RowBox[{"s", "+", "\[Omega]"}]], 
      RowBox[{
       UnderoverscriptBox["\[Product]", 
        RowBox[{"i", "=", "1"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}], "/", "2"}]], 
       FractionBox[
        SuperscriptBox["\[Omega]", "2"], 
        RowBox[{
         SuperscriptBox["s", "2"], "+", 
         RowBox[{"2", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{"\[Pi]", " ", "i"}], "n"], "]"}], "\[Omega]", " ", "s"}], 
         "+", 
         SuperscriptBox["\[Omega]", "2"]}]]}]}], ",", "s"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"butterworth", "[", 
   RowBox[{"\[Omega]_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"TransferFunctionModel", "[", 
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"i", "=", "1"}], 
      RowBox[{"n", "/", "2"}]], 
     FractionBox[
      SuperscriptBox["\[Omega]", "2"], 
      RowBox[{
       SuperscriptBox["s", "2"], "+", 
       RowBox[{"2", 
        RowBox[{"Cos", "[", 
         FractionBox[
          RowBox[{"\[Pi]", " ", 
           RowBox[{"(", 
            RowBox[{"i", "-", 
             RowBox[{"1", "/", "2"}]}], ")"}]}], "n"], "]"}], "\[Omega]", " ",
         "s"}], "+", 
       SuperscriptBox["\[Omega]", "2"]}]]}], ",", "s"}], "]"}]}]}], "Input",
 CellChangeTimes->{3.524798946762723*^9},
 FontSize->12,
 CellLabel->
  "In[662]:=",ExpressionUUID->"25e8f12b-dce3-4d8f-b528-397508dda42e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"butterworth", "[", 
  RowBox[{
   SubscriptBox["\[Omega]", "N"], ",", "2"}], "]"}]], "Input",
 CellChangeTimes->{3.5029902188015738`*^9},
 FontSize->12,
 CellLabel->
  "In[664]:=",ExpressionUUID->"118e6897-c569-4503-89d5-2a1ed4dcca44"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox[
     SubsuperscriptBox["\[Omega]", "N", "2"], 
     RowBox[{
       SuperscriptBox["s", "2"], "+", 
       RowBox[{
         SqrtBox["2"], " ", "s", " ", 
         SubscriptBox["\[Omega]", "N"]}], "+", 
       SubsuperscriptBox["\[Omega]", "N", "2"]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{
         Subscript[$CellContext`\[Omega], N]^2}}, $CellContext`s^2 + 
        2^Rational[1, 2] $CellContext`s Subscript[$CellContext`\[Omega], N] + 
        Subscript[$CellContext`\[Omega], N]^2}, $CellContext`s], AutoDelete -> 
      True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{
         Subscript[$CellContext`\[Omega], N]^2}}, $CellContext`s^2 + 
        2^Rational[1, 2] $CellContext`s Subscript[$CellContext`\[Omega], N] + 
        Subscript[$CellContext`\[Omega], N]^2}, $CellContext`s]], 1, {}, {
     False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{
     Subscript[$CellContext`\[Omega], N]^2}}, $CellContext`s^2 + 
    2^Rational[1, 2] $CellContext`s Subscript[$CellContext`\[Omega], N] + 
    Subscript[$CellContext`\[Omega], N]^2}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{3.502990219944792*^9, 3.5083608172492313`*^9, 
  3.5083609417384*^9, 3.524798880547265*^9, 3.52479892099367*^9, 
  3.524798951192135*^9, 3.524799079720276*^9, 3.525574619049531*^9, 
  3.793329047149003*^9, 3.793329155226406*^9, 3.793329265934369*^9, 
  3.7938930113362913`*^9, 3.823224624605585*^9},
 FontSize->12,
 CellLabel->
  "Out[664]=",ExpressionUUID->"6b4591a7-ad4e-4bbc-ad9a-cb1b8e0d7a1b"]
}, Open  ]],

Cell[TextData[{
 StyleBox["A third-order ",
  FontSize->16],
 StyleBox["Butterworth",
  FontSize->16,
  FontColor->RGBColor[1, 0, 0]],
 StyleBox[" filter :",
  FontSize->16]
}], "Text",
 CellChangeTimes->{{3.502990240489703*^9, 3.5029902545621243`*^9}, {
  3.502991188212632*^9, 3.502991189554459*^9}, {3.5083607570474586`*^9, 
  3.508360757725975*^9}},
 FontSize->14,
 Background->GrayLevel[
  0.85],ExpressionUUID->"b753f9f7-e0b9-4b83-9c06-5ab786317ea5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Butter3", " ", "=", 
  RowBox[{"butterworth", "[", 
   RowBox[{"1", ",", "3"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.502990799698523*^9, 3.502990802576891*^9}, {
  3.502990843906918*^9, 3.502990873504901*^9}},
 FontSize->12,
 CellLabel->
  "In[665]:=",ExpressionUUID->"8ff01cfa-8e11-4e6d-a396-d47cab2c47dc"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox["1", 
     RowBox[{
       RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
         RowBox[{"1", "+", "s", "+", 
           SuperscriptBox["s", "2"]}], ")"}]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{
        1}}, (1 + $CellContext`s) (
         1 + $CellContext`s + $CellContext`s^2)}, $CellContext`s], AutoDelete -> 
      True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{
        1}}, (1 + $CellContext`s) (
         1 + $CellContext`s + $CellContext`s^2)}, $CellContext`s]], 1, {}, {
     False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{
    1}}, (1 + $CellContext`s) (
     1 + $CellContext`s + $CellContext`s^2)}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{3.50299018266109*^9, 3.502990804704027*^9, 
  3.502990874076069*^9, 3.508360817298251*^9, 3.508360941776943*^9, 
  3.524798880599783*^9, 3.5247989210499697`*^9, 3.5247989512401648`*^9, 
  3.524799079768586*^9, 3.5255746190910892`*^9, 3.793329047266165*^9, 
  3.793329155341063*^9, 3.793329266049789*^9, 3.793893011429894*^9, 
  3.8232246246947107`*^9},
 FontSize->12,
 CellLabel->
  "Out[665]=",ExpressionUUID->"9e22afc4-2d1e-44fe-981d-81d792ff6b0b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Butter3Out", " ", "=", " ", 
  RowBox[{"OutputResponse", "[", 
   RowBox[{"Butter3", ",", 
    RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.502990938501734*^9, 3.502990946195153*^9}},
 FontSize->12,
 CellLabel->
  "In[666]:=",ExpressionUUID->"e43fc46d-1d10-4e2c-9529-654f4977ac60"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "t"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["\[ExponentialE]", "t"]}], "-", 
     RowBox[{"2", " ", 
      SqrtBox["3"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"t", "/", "2"}]], " ", 
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{
         SqrtBox["3"], " ", "t"}], "2"], "]"}]}]}], ")"}], " ", 
   RowBox[{"UnitStep", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["3"], " ", "t"}], "2"], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{3.502990951309538*^9, 3.5083608185439873`*^9, 
  3.508360942776127*^9, 3.524798882048181*^9, 3.52479892209937*^9, 
  3.524798952257559*^9, 3.524799080783305*^9, 3.525574625080885*^9, 
  3.793329049534247*^9, 3.793329155510662*^9, 3.793329268322144*^9, 
  3.793893013490899*^9, 3.823224627132825*^9},
 FontSize->12,
 CellLabel->
  "Out[666]=",ExpressionUUID->"9a0f01f2-5ecf-4fc5-b11e-3ddfb57db52a"]
}, Open  ]],

Cell[TextData[{
 "A third-order ",
 StyleBox["Bessel",
  FontColor->RGBColor[1, 0, 0]],
 " filter :"
}], "Text",
 CellChangeTimes->{{3.502990240489703*^9, 3.5029902545621243`*^9}, {
  3.5083607931213093`*^9, 3.508360793822405*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"a9296aa9-eb66-4547-a183-2be6b2b66c8b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Bessel3", " ", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     FractionBox["15", 
      RowBox[{" ", 
       RowBox[{
        SuperscriptBox["s", "3"], "+", 
        RowBox[{"6.", 
         SuperscriptBox["s", "2"]}], "+", 
        RowBox[{"15", " ", "s"}], "+", "15"}]}]], ",", "s"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.502990274229354*^9, 3.502990277665941*^9}, 
   3.7933290919725*^9, 3.7933291293402557`*^9},
 FontSize->12,
 CellLabel->
  "In[667]:=",ExpressionUUID->"514c8a06-b014-4430-834b-ced0fc563594"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Bessel3Out", " ", "=", " ", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Bessel3", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.502990437706863*^9, 3.5029904389084177`*^9}, {
  3.50299048858988*^9, 3.50299051624568*^9}, {3.502990612209475*^9, 
  3.50299061698949*^9}, {3.5029907188540163`*^9, 3.502990729939242*^9}, {
  3.50836083466714*^9, 3.508360848387517*^9}, {3.7933291384915857`*^9, 
  3.793329147762137*^9}},
 FontSize->12,
 CellLabel->
  "In[668]:=",ExpressionUUID->"4056db4c-9b03-49fc-9dc3-6094df1c901a"],

Cell["Graph the frequency and step responses:", "Text",
 CellChangeTimes->{{3.502990240489703*^9, 3.5029902545621243`*^9}, {
  3.502991222863015*^9, 3.5029912285476627`*^9}},
 FontSize->12,ExpressionUUID->"864c9687-6051-4a9d-9641-1ab603dd43a7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BodePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Butter3", ",", "Bessel3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{".1", ",", "1.1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5029910937775908`*^9, 3.502991109101882*^9}, {
  3.502992029082258*^9, 3.5029920675901203`*^9}},
 FontSize->12,
 CellLabel->
  "In[669]:=",ExpressionUUID->"5b88da9e-845d-4ee9-84d3-c1fc1e33327d"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVl3k01V8XxiUkpfoJEQnJlCljUZGhUElooBAJEUVEkaQIISIyhKIkhYiI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           "]]},
         Annotation[#, "Charting`Private`Tag$409222#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVkms0lAkAhodla1GtotuUXZI6xyU2t6P0tShpDovBqi1RLFpEiS6SmVya
sHJbDuUyQ7YMMhG18ZKSezMSUdagcZvRN19FRbLtj+c8P56/j/bRE65+ijQa
zfEr/5unnPV+cZEE1VGnFdLOwlyjsu7RBRL3K9t+3tTNgmt0OPPRHAnlKlfZ
wAsWaB9cBJdnSAyXF790GWPh0IRaqLqUhE6f3i4vBTY02tlSnV4Sjck2U5QF
G3FXQ0b28EkUd0VVqJaw4U/fK0z0JMEON+PvTr6EuHcjzxV4b3D6oYIVURKH
tpGZ3IufprE2ULNCIEqAvc7nHGfmNIJWaX+/fssVaOnKm1TzZUhrdjLjUEmg
Wx8s65qVwlgywXgnTMHJtYKG87uloAdJfJwLUqFgt6AWlTyFl5+VjA5Ep6Mm
vn5d7NgkluvVXu8NzMSTxGDnCJNJXOnO+XC7OgtfStLsQy9PoObv6BnHVTkI
1iiNrBsZx4ylXUJF/jWY21aK3huNYzJsPElWmg89jqFse8IYOk0z1/n7FyI0
Ncv4sEgCT9fd/jx7Ht5Ovi/r15IgyZAUR7sUI/dAi/TwmddwMtWLHwkswfVE
DrOjaRQiQseWI72J5p6G8zb0UVwxSFoZGMOHg1jSyfUdQWgW46ppVgWUdn7x
9KgchppF1dWMs5UYK08qUlcZBnNyeMfs9jvQeb10fY2bGMLacQ/mnmqo+szm
t3gMgX3ucv96/xrY5DReaFX5Fwb82q7wO/dg6BlQkcd9BS8Hw3vJpx7Az27e
55LrS0QsZ0oe7wNcqgMDdo7147TD1mMsj0aUNdeLc2Ne4NxvC/P1Rk349Vva
gMr2Piz7wrWs1XiM6rYNW5xan2NmKjmQf/AJfOo2zxRE9iCDLzstFbQiylnT
LMfgGRboBireVh1gBIhb/B+LMEiLcqTZPEVAedagXYQQitbqsXXGIoS9dUuS
aXbBoaPbj1zxDOWvXY+EnGjH3Ys3dOmLPWhbo7XaurcFQ/Eb3HVW98HJrSC8
SqkZJz1SVRay+hEyPdez/1gTVH9YckRj2yvMpqgNcjgN8FVizfswhnB/rDdV
/9w/COpW9QzwHEbD73uCWT/fhWy+mJGybhSZn7Szt2bfhmbG+Ri+mQS2iV7J
9LwbGF0eZBTtN45qx0PvfmJn44ADyfF9NAkNVp5jgb43hBfiTMO+fpreYiJy
nU0jjrpbW1VlkhA4cMRKbulEdmGZtJBHQtgmJu9WphOvJE5Kf1WSUOtMWU4P
ziC6LCsiUztJxIqmGaOjmcRT/YShKUU5wgduNp8SZRMl34Uy2nfI4SHTfpDB
zyPcE/bPL7n9tQefbd+rkk8oy229A2rkSH8jHPjon09MeWUadNTLEfARUeXq
BURDn1whr1OOormQ3JWdBYTU+c+u41I5Nix2vBiw5RK+G72O39pCoRRnxHdO
comqFuYKm20UrGJ0J5IKuYR+XIv5oDkFT4WoD7sWuUSpYI2G1l4KGd/or+bd
5xG3LAYs23wpbHrUuzFqkkdUpf6iEx1EQRDL3uy+togw1je4ZhZOQag8YLok
oohQsfhxX8UlCkea43aKi4oI78gHF8ISKbyJN7G796yIWJXRut8inUK0/SAj
TbGYuGauVknLpbBsKYf5h0kx8VDuIOjkUvgP+Vev9Q==
           "]]},
         Annotation[#, "Charting`Private`Tag$409222#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-1., -1.2386298520332422`},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-1.25, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"-1.25\"", ShowStringCharacters -> False], -1.25, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 2}]& ], TraditionalForm]}, {-1., 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"-1.00\"", ShowStringCharacters -> False], -1., 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 2}]& ], TraditionalForm]}, {-0.75, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"-0.75\"", ShowStringCharacters -> False], -0.75, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 2}]& ], TraditionalForm]}, {-0.5, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"-0.50\"", ShowStringCharacters -> False], -0.5, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 2}]& ], TraditionalForm]}, {-0.25, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"-0.25\"", ShowStringCharacters -> False], -0.25, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 2}]& ], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-1.25, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.2, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.1, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.05, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.95, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.9, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.85, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.8, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.75, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.75, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.7, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.65, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.55, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.45, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.4, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.35, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.25, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.25, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.2, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.1, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.05, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6193149260166211, 
           FormBox[
            StyleBox[
            "\"99999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-1.25, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-0.75, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-0.5, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-0.25, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1.25, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.2, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.1, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.05, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.95, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.9, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.85, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.8, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.75, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.75, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.7, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.65, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.55, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.45, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.4, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.35, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.25, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.25, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.2, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.1, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.05, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-1., 0.04139268515822508}, {-1.2386298520332422`, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-1.25, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"-1.25\"", ShowStringCharacters -> False], -1.25, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 2}]& ], TraditionalForm]}, {-1., 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"-1.00\"", ShowStringCharacters -> False], -1., 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 2}]& ], TraditionalForm]}, {-0.75, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"-0.75\"", ShowStringCharacters -> False], -0.75, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 2}]& ], TraditionalForm]}, {-0.5, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"-0.50\"", ShowStringCharacters -> False], -0.5, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 2}]& ], TraditionalForm]}, {-0.25, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"-0.25\"", ShowStringCharacters -> False], -0.25, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 2}]& ], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-1.25, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.2, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.1, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.05, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.95, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.9, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.85, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.8, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.75, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.75, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.7, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.65, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.6, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.55, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.5, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.5, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.45, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.4, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.35, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.3, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.25, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.25, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.2, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.1, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.05, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.6193149260166211, 
          FormBox[
           StyleBox[
           "\"99999\"", ShowContents -> False, StripOnInput -> False], 
           TraditionalForm], 0}}}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVxXk01AkcAPCxmXaS3besK6RlHUkqpLU5fkJJ7hkGIc2vS22DjUdlUmnI
PKlcEa8hM2OzorKpXW2+39JO7sxzhMjklmNsjByL3f3j8z76ZCT92BcUCsXz
P/8voObMrq7K4Pqu9tKlWWNcfEE1JJdlINIo9KYvGCM9IYbxalEGOtQaccmy
MVI++1akyGUQzKjcHrzWBENGlaNUxmXwML5h+rWmCao1JI4bdMhAW6uTUbfb
BJNuRvTvvS+DpVRFPH3ZBE/o7GtJDZTBJtsiFqGyGZNm+tsVBFPgw5z8Rtvf
FOv75fkXFybBr1XsvpSxBV0N/snzYUyCcGu+w1CXGeoZTtesL5iAWDf1wote
5qhjf7CseW4cFBsWd6w824ZntCow3nEcTnnTohy27UAFl2VlTtpHaFzHfJNB
tcCnydUbuMNjEKyZrVrWaYGvU9k+sRZjkKJh7htWZ4krv2S4RqWMwrMZg+Dn
lVbIViuNe94/AuYzop6leztxl/Mjyey2EbiuLt+UVG2NxjzzCaurw2DoMa02
37wLo9JzdoRKhuCGS4JpJ9UGP43NlnXpDUFa1P2tD11/xPyg2vHQs4NAMIzu
3rqyG++k8hiNNQPQPD3keXrCFsVtGO+kMwB9DaHH/b3t0U061FR0tB/Ou7PZ
g4MOqGi3Esh89AHcBFKVdhdHHC6/JlRR+gCcQZHWu2/3oMEgTfupnxT0uC8D
WilOuJ41V1DL7APdgBQ+/6MTOuW9uFCn9B4CD2Y3He1xRvPA8Af8oh6wpsjW
vfzbBY+5LLGu0N9B3XDCuHjNPvStPBluN9wFJZaTvnkOrlgmrpbmX+qEMccn
QvOr+zFgLaVbyeot9Ka3pl5odMPKel0Tr7p2KKbtX5vu7I6s50bywrg2UPN9
zDn+uwdyfNSt87a2QvHVWA8Fey90D5fWnvhLAjSRPEOy4o3h5Tm9LrEtEGnn
Krrd54M/f/K7NqHeDJ6W8VYlA75YPkgPi4hsgDKb9OKWETrWa+pp2HfUQvt1
P92geQZ6+RXGPFYUA7e0Tdqx0x8jJhfbDhypAfKBXNIdxcS5G8q9PB6C6pTx
p7T3AVg13JFudv4ZDBid/s46NAjx+F725T1PQHXNx0Bux0HMXtDP3Zz7EAzl
o409V0LQOfVQmg6/GGrfZjreMzyElZ4hM5aJuSDY+EDfqTYM1S7zPQvNDoPp
Jl7NlobDmFlrIaHPZRD0LtW4DQIWVrjxpIp+mcSBUAq1u5iFLfVS2ZNHmYTX
Z5/Deb+yULnpxtc67Cwim8aK165gIVcy6T4wkE3cHrUx1XrBwpjuEnG0JJeY
PzWXRetjIXNC/8+s+3ximT/s8VSbxBj2uYZ9SgVEdcJrjNQjMXOqpXv+RAGx
XWP9kIkBieHzwClXKSTMeLa2OaYkChcj8lWbCgnT1lHqGRsSdVcbO7udi4jK
7FsMTSaJpXBW+tuZImLknPxYfRCJuy8Zjl67W0QoGq9qXwglMVCB89lhtYj4
waLq5IejJGatMdMQVAkIzs3kRFE0id+/6tjIGRMQS3VTGf5xJFZwE438tYSE
YzCLoMaT2ELt3vllrJA41al/8kgiiWHiJDupUEjc5b8ZVEkmcSrZwuWPViER
He26ADwSE1x73TO+EBF3FqpE7DQSv6LxGD9ZiIhebsiYdjqJ/wJgdJM/
           "]]},
         Annotation[#, "Charting`Private`Tag$409715#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAAowWX9P//778OmxWOFusWwPrBBSRi
/e+/jW1jjmfvFsBSfnRTxPrvv4ygzl658xbAAPdRsoj17788+JlwX/wWwFzo
DHAR6++/f71PXLUNF8AUy4LrItbvvzxkqnaIMBfAhZBu4kWs77++0jjMzHYX
wGcbRtCLWO+/JLJBvNYFGMCF8+LVAaPuv++tC53JRxnAyuL1m3/57b/pqiOQ
mYMawEci/JpQU+2/bNyOTizIG8AeJPDDC5/sv2r06k/UOR3AGz1arc7267/+
x2YUIaQewHIYssB7QOu/9rwBZEwgIMABRP0MfI3qv6+apjdR9SDAt4a+GYTm
6b//MjOg6sUhwMeLbVB2Mem/ZAJlinSzIsD+p5JHcIjov7zZD+1jnCPAbRSr
d73i578Yl7qpvYskwDZDsdH0Lue/I/Q3u1ycJcAmiS3sM4fmv8eKbWN4pybA
cJGXMF3R5b+MuxJal9cnwPLp9K3ZHuW/98KnxqgRKcCbWcjrXXjkvyZ/4uob
RSrAnYuJU8zD478TtsBdPqMrwMbUwHtCG+O/87fh13r6LMBJ4OXNomTiv7Ge
aiE5gS7ABDz+WFax4b8Gf94abwowwOaujKQRCuG/mnf2BRzQMMAi5Agat1Tg
v2v2XUIysTHAC2H2n8hW37+rsPoX940ywEKawX3JCt6/ts1pYNdwM8AtWGiv
nqLcv6dNzCw9czTAZUT7YYNS279wUjU8dnA1wFG1aWg85tm/aaq8z8GQNsCt
xr7gm4DYvwQtwruDujfAVwYA2goz179JkUY8Dt44wLXKHCdOydW/2wCKKg0q
OsBhvSX1oHfUv2xsEpORbzvAfFAVNZos0796u2mJBb48wEto4MhnxdG/g8Cx
ovg6PsBorpfdRHbQv8wOmPUosD/AcfJUjOwVzr+t00LBh6xAwK7kUl9ub8u/
bL3TAPB8QcDKFx4WPdbIv3ey4IwfU0LATlSgdLQExr+4mt/ECEdDwG7t+tRK
Y8O/PiCzixU2RMD2jwzdiYnAv4qwjc8wRkXAuubWkSt6u78PLPTbNF9GwMBm
RW2BQba/DrpZS1hyR8CV+SGYKJiwv4SMByCLq0jAQ4tejRuepr8YQafDj95J
wLVNXPMygpi/AxkprOAZS8AUgZ5NoCtgv6kXtHjAgEzAk8gx0VL2kj+l/CrJ
DuBNwLJJieAEVJM/ji5MgFTmTcDQyuDvtrGTPz9bPIGb7E3ADM2PDhttlD+R
fHFhLflNwITR7Uvj45U/+yqFoWASTsB02qnGc9GYP6jd+lIFRU7AVuwhvJSs
nj8LmbAPSatOwHRtectGCp8/wuPAcLixTsCT7tDa+GefPzBg2CIpuE7AaPi/
fK4RoD/X1wJ7DsVOwKT6bpsSzaA//P+NAeneTsAc/8zY2kOiP/D/rJndEk/A
q7944LNyoj9iehYmYhlPwDqAJOiMoaI/z0UcB+gfT8BYAXz3Pv+iP7RD4cf3
LE/AlAMrFqO6oz/8ko5KJ0dPwCPE1h186aM/aHkYgrZNT8CyhIIlVRikP/Ho
BhBHVE/A0AXaNAd2pD8Y+vQvbGFPwF/GhTzgpKQ/q1RmwgBoT8DuhjFEudOk
Px+qH6yWbk/AfkfdS5ICpT8cxFntLXVPwA0IiVNrMaU/oWRNhsZ7T8DGk45M

           "]]},
         Annotation[#, "Charting`Private`Tag$409715#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-1., -148.53453510351292`},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-150., 
           FormBox[
            RowBox[{"-", "150"}], TraditionalForm]}, {-125., 
           FormBox[
            RowBox[{"-", "125"}], TraditionalForm]}, {-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {-75., 
           FormBox[
            RowBox[{"-", "75"}], TraditionalForm]}, {-50., 
           FormBox[
            RowBox[{"-", "50"}], TraditionalForm]}, {-25., 
           FormBox[
            RowBox[{"-", "25"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-150., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-145., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-135., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-130., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-125., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-125., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-115., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-110., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-105., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-95., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-85., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-65., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-74.26726755175646, 
           FormBox[
            StyleBox[
            "\"99999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-125., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-75., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-145., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-135., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-130., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-125., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-125., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-115., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-110., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-105., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-95., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-85., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-75., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-65., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-1., 0.04139268515822508}, {-148.53453510351292`, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-150., 
          FormBox[
           RowBox[{"-", "150"}], TraditionalForm]}, {-125., 
          FormBox[
           RowBox[{"-", "125"}], TraditionalForm]}, {-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {-75., 
          FormBox[
           RowBox[{"-", "75"}], TraditionalForm]}, {-50., 
          FormBox[
           RowBox[{"-", "50"}], TraditionalForm]}, {-25., 
          FormBox[
           RowBox[{"-", "25"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-150., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-145., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-140., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-135., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-130., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-125., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-125., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-120., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-115., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-110., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-105., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-95., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-90., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-85., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-65., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-74.26726755175646, 
          FormBox[
           StyleBox[
           "\"99999\"", ShowContents -> False, StripOnInput -> False], 
           TraditionalForm], 0}}}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.502991095972776*^9, 3.502991110920946*^9}, {
   3.502992032767774*^9, 3.5029920703715973`*^9}, 3.5083608197763357`*^9, 
   3.50836094352848*^9, 3.5247988840493507`*^9, 3.524798922737689*^9, 
   3.524798952924171*^9, 3.524799081454308*^9, 3.525574628511736*^9, {
   3.793329151596654*^9, 3.793329155989506*^9}, 3.793329276092121*^9, 
   3.793893020492833*^9, 3.823224635184312*^9},
 FontSize->12,
 CellLabel->
  "Out[669]=",ExpressionUUID->"92fc119c-f399-41c3-bdeb-323b6d2b8be1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Butter3Out", ",", "Bessel3Out"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "15"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.502991029421686*^9, 3.502991045548217*^9}},
 FontSize->12,
 CellLabel->
  "In[670]:=",ExpressionUUID->"4619cefd-6587-4c67-9f90-f6fd08d0a692"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd13k8lF8XAHCRLbsZ+zYjzMiuJC3uoeUXSoiSSrJFslSyVxKSncqWLSFR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       "]]},
     Annotation[#, "Charting`Private`Tag$410424#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1nk4VF8YB3BjFvuYsUcUSclSVGTJeZMkRBSVPaJIVFQShSRSIsqSLVFC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       "]], LineBox[CompressedData["
1:eJwd1Hs01GkYB/CJEbkMafi9v99vUyOXUJkjJGPzZMscsrltF61aTVvHRoV0
0y5TkssWa221IbulTnOKXCpZl5BCdHEpaxKpsLmUW21kZX/P/PGe93z+ed/3
PM/3eUWyPX7b1Xg8noxbuP9CJ9YZX6MgU73lgi5v2HUmK5iwK6Tg1Qq3WvSV
suy85iIKDpfaDKE1XxyOlpdTEGjQaqHHObqLl5dZRYGB5ogU7WN6eaCihoKL
xWwYOt0KOr3aKRjQz1YXcA4N6WXCuiiwTvc3R7vmntiQ1kOBJL5mNbpbrGxU
DlGwulMjFl0UEaM39Z4CQWD7H+jEG+ae8z9R4PN9XCl6iVNE9Q4+gRnK4CE0
L4rwkmYRWDv7qqY+55bS2y65AgJ1IS0m6IOuOkVjhEBM6T8e6DVHCkaNTQi4
2D/fjDap3mDrvIDA/NbaMHS1+0WFfDGBZKdTaejTCZ492XYEZtnHZKOD64dF
tcsIxD4KK0RLdM9s6XchUCPYXYkWrP0yQ8+NwLHRqIforpTXf4ulBGS7M5To
602Jwm+8CHze1dKNPj5H7HvAl0Bbi8UQeuO61pPp6wlEHDo7jrY+82N9+bcE
XG1tZxhwnmoz1XwZROBm2YAWupG5/xV/BwFJV7M++kLgHrllCIHV3m+M0JFZ
RuWeYQSgyJZFS7tKJ3btI5BXnDMPzZjKHFOjCBiPyBagB7dp7b0RQ0A4ss4C
/S5rVXnFMQL8AvlC9JBSrtmQSKBq8oMVelhY7tuaTKCX/GWNHvWeyHiZRqBZ
+lDlsSSH3sHfufsqHFR+fy9cPH6OgDzvg+q8f3nXotSzCVArDCzRHyX9dwUK
AouTEszQ4/st9JlcAoFXtorQnwpkAeaFBCxzs+aiJwezssW3uPeddaPR/1m2
v5WUEfgu1EeI/iyjnKRVBArmNgjQ0+f8j/rVcP3IuKmqn5rwgfEPjQTo5J5P
WG++t9bWyKcEworFY2iNpFVXY54RaKc/9qO1eOWup7sJSE/zVP3Ulkwknu8j
oLPQ4zFaZ7/Dk5x3BEI7qXuqPAzmBlePEyjy9ctDG1j2Fz6aIvBMWq3K02yZ
xZRSjYYFT++eQQvbslKHdWnwfxIbjabvppTMFdFwP9NRimamG/hWFjR0FIc7
ob9w1vK2t6HBuc/HSpXnfPlrTwcaoISvjTbLDNc96EHD8Ji8FudFHOm/pTmc
BtudV+3Rdnkpio79NPjZLRahl/Y3jL45TINxfqQe2jFoVfx0HA1KaWAPzrfE
yyF/UToNz55X/op2N6PU4u/QcC5G1oP/RZ9MqpDU0lAsSmtEnzh/YO1wA3ff
UUUpusWkLT3gKQ3z/I+nooPos0sXvaEhWGjrgj4kYLc36THgIFqSrMM5Z9yk
jg1gwOZyq402Z+9l3rsbNzMgMFQYoUf3xQjjZAzIbX6ansV5+diLoHchDLj5
OLSga97+OVEZzUDT2HAU+sUrU5sdFxkwv275QIuz4UOL5PwhBtT2xh3SxLwM
iS/Vv2fg1SnXbeh+Q0lZ9wQDXb8Zfo2+s9G7n/BZGNPQEKH3dh9wP0I4Gy2s
n8n5yWTdZ9+VLITVV4jQlSYtRqHuLCg8luuhc1Z2LDq+hoWdJU3jGpzj4kc2
laxjISE1qBHtOIe5ZbqTBY2QKTna1NHskcseFiI69+1CCwKW9KyPZKHYTX8T
ujfLbc7P0SwkX7u0FN1c5WV9KZaFXJI9H327e/3KigQWHjvd0UNf0dy6UXmS
hRRn9Uk+547zir6cVBYGfLTfov8HDCh5VA==
       "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQfSNZUJtbQcHBebrgwX//39v/yPyZcVlZwWH/WpHD
IP60jsZ5e8wUHJbwvjkL4ttNePy6zFrBoeL1hQsg/tPprpaGDgoOctOPXQbx
TZZzXlnqqeBwpvXBTRD/0tGJnP0xCg693lufgfh8zItKEpsUHDyzNZn+A/n/
3t01amxXcMifwsAG4r+/JflxQY+CA2/pHU4Q/8KmibkPpik4PLSeLwjiT0pq
TItfreAQmWKjCOI3+e1Vqd8A5M9TUQXxi61+Ppq3VcHB5TO3JogfIlQYf2+/
gkP7pKsGIL7LvzWy/44oOMTt3WYC4pu+enFb9pSCw6vDUyxA/Ciuq8x/zik4
tLyytQHxzZ5JrVtzUcFhnr2THYgPABPJpXo=
       "]], 
      LineBox[{{9.986595992622147, 1.0000000185262776`}, {10.088452183430162`,
        1.0000000159696383`}, {10.120030534868281`, 1.0000000151486335`}}], 
      LineBox[{{0.20242066430404754`, 0.015261531476574353`}, {
       0.20633105758710119`, 0.016066953191905032`}, {0.2116215896759384, 
       0.017195272242672355`}, {0.21507193669039748`, 0.017955194390623954`}, 
       {0.22266270012220735`, 0.01969430292502368}, {0.22542297773377468`, 
       0.020349749472916602`}, {0.22841327847963924`, 
       0.021073741701611873`}}]},
     Annotation[#, "Charting`Private`Tag$410424#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.5029910618801737`*^9, 3.508360826447226*^9, 
  3.508360943762467*^9, 3.5247988842209597`*^9, 3.524798922911203*^9, 
  3.524798953090415*^9, 3.524799081625546*^9, 3.52557462885182*^9, 
  3.793329156260208*^9, 3.793329276254553*^9, 3.793893020625743*^9, 
  3.823224635300599*^9},
 FontSize->12,
 CellLabel->
  "Out[670]=",ExpressionUUID->"f72c1d9a-dd04-490f-9518-83e4293060db"]
}, Open  ]],

Cell["Repeat for n=2:", "Text",
 CellChangeTimes->{{3.502990240489703*^9, 3.5029902545621243`*^9}, {
  3.502991222863015*^9, 3.5029912285476627`*^9}, {3.5029913333487167`*^9, 
  3.502991336619069*^9}},
 FontSize->14,
 Background->GrayLevel[
  0.85],ExpressionUUID->"ad973ef1-6e75-442d-9935-e1afc9988c26"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Butter2", " ", "=", 
  RowBox[{"butterworth", "[", 
   RowBox[{"1", ",", "2"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.502991355222001*^9, 3.502991356948678*^9}},
 FontSize->12,
 CellLabel->
  "In[671]:=",ExpressionUUID->"d68ce8b6-1f6a-4091-b005-23e38c68d3c2"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox["1", 
     RowBox[{"1", "+", 
       RowBox[{
         SqrtBox["2"], " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{1}}, 1 + 
        2^Rational[1, 2] $CellContext`s + $CellContext`s^2}, $CellContext`s], 
      AutoDelete -> True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{1}}, 1 + 
        2^Rational[1, 2] $CellContext`s + $CellContext`s^2}, $CellContext`s]],
      1, {}, {False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{1}}, 1 + 
    2^Rational[1, 2] $CellContext`s + $CellContext`s^2}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{3.508360826731574*^9, 3.5083609438178377`*^9, 
  3.524798884344561*^9, 3.524798922943323*^9, 3.524798953118163*^9, 
  3.524799081683538*^9, 3.525574628961562*^9, 3.7933291563341312`*^9, 
  3.793329233872472*^9, 3.793329276329171*^9, 3.7938930206935587`*^9, 
  3.8232246354086723`*^9},
 FontSize->12,
 CellLabel->
  "Out[671]=",ExpressionUUID->"18121d02-a180-472e-8712-90d2745ecc0b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Bessel2", " ", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["s", "2"], "+", 
       RowBox[{
        SqrtBox["3"], "s"}], "+", "1"}]], ",", "s"}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.502991565527624*^9, 3.5029915677547007`*^9}, {
   3.5029915986687593`*^9, 3.502991637469295*^9}, 3.793329244522018*^9},
 FontSize->12,
 CellLabel->
  "In[672]:=",ExpressionUUID->"045c14e9-7d2e-41fd-a529-2a508d205cf9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Butter2Out", " ", "=", " ", 
  RowBox[{
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Butter2", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}], " ", "//", " ", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.5029916583571577`*^9, 3.502991661420063*^9}, {
  3.508360811457596*^9, 3.508360813168613*^9}},
 FontSize->12,
 CellLabel->
  "In[673]:=",ExpressionUUID->"1152f610-3ed5-4325-bc73-59d15f344f44"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", "2"], "+", 
     FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", "t"}], 
        SqrtBox["2"]]}]], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], " ", "t"}], 
         SqrtBox["2"]]}]]}]}], ")"}], " ", 
   RowBox[{"UnitStep", "[", "t", "]"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.502991663529303*^9, 3.508360827583447*^9, 3.508360944605739*^9, 
   3.524798885129889*^9, 3.524798923669971*^9, 3.52479895384459*^9, 
   3.524799082437335*^9, 3.525574629891491*^9, 3.79332915714145*^9, {
   3.793329252192964*^9, 3.7933292768181963`*^9}, 3.7938930211941223`*^9, 
   3.8232246359345837`*^9},
 FontSize->12,
 CellLabel->
  "Out[673]=",ExpressionUUID->"5901d4db-072a-4094-9fbf-4f7ae81e9263"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Bessel2Out", " ", "=", " ", 
  RowBox[{
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Bessel2", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}], " ", "//", " ", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.502991672739831*^9, 3.5029916773242188`*^9}, {
  3.508360865155759*^9, 3.508360867554281*^9}},
 FontSize->12,
 CellLabel->
  "In[674]:=",ExpressionUUID->"f377c08c-b810-469b-9e39-aea7e53726dd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], " ", 
     RowBox[{"(", 
      RowBox[{"\[ImaginaryI]", "+", 
       SqrtBox["3"]}], ")"}], " ", "t"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["3"]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", "+", 
        SqrtBox["3"]}], ")"}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "t"}]]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"\[ImaginaryI]", "+", 
          SqrtBox["3"]}], ")"}], " ", "t"}]]}]}], ")"}], " ", 
   RowBox[{"UnitStep", "[", "t", "]"}]}], "}"}]], "Output",
 CellChangeTimes->{3.502991679111682*^9, 3.50836082814573*^9, 
  3.508360868767783*^9, 3.508360945489554*^9, 3.524798886027109*^9, 
  3.524798924572625*^9, 3.524798954813676*^9, 3.5247990834325027`*^9, 
  3.5255746308767242`*^9, 3.7933291582279053`*^9, 3.7933292777914057`*^9, 
  3.7938930220115223`*^9, 3.82322463688026*^9},
 FontSize->12,
 CellLabel->
  "Out[674]=",ExpressionUUID->"90a008cb-5833-4c93-b28c-324c8b37978d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"naive2", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], "2"]], ",", "s"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"naive2out", "=", 
  RowBox[{
   RowBox[{"OutputResponse", "[", 
    RowBox[{"naive2", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}], " ", "//", " ", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.525574540422874*^9, 3.5255745960569468`*^9}},
 FontSize->12,
 CellLabel->
  "In[675]:=",ExpressionUUID->"9475559a-8c77-4835-a3db-4c77bae4aa75"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "t"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", "t"], "-", "t"}], ")"}], " ", 
   RowBox[{"UnitStep", "[", "t", "]"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5255745989036694`*^9, 3.5255746309594603`*^9, 
  3.793329158380497*^9, 3.793329277835876*^9, 3.793893022146534*^9, 
  3.823224636937224*^9},
 FontSize->12,
 CellLabel->
  "Out[676]=",ExpressionUUID->"9c91672c-0567-417a-8931-c8f2d7759548"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"gen2", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "+", 
       RowBox[{"2", "\[Zeta]", " ", "s"}], " ", "+", " ", 
       SuperscriptBox["s", "2"]}]], ",", "s"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gen2out", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"gen2", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{"gen2out", ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", " ", 
    RowBox[{"0", "<", "\[Zeta]", "<", "1"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.525575875042116*^9, 3.525575908054627*^9}, {
  3.525575959997312*^9, 3.5255760112898207`*^9}},
 FontSize->12,
 CellLabel->
  "In[677]:=",ExpressionUUID->"f04d4e6c-addb-4372-80c7-4b244e2a0ae9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[Zeta]", "2"]}], ")"}]}]], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "t"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Zeta]", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["\[Zeta]", "2"]}]]}]}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[Zeta]", "2"], "+", 
      RowBox[{"\[ImaginaryI]", " ", "\[Zeta]", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["\[Zeta]", "2"]}]]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"t", " ", 
         RowBox[{"(", 
          RowBox[{"\[Zeta]", "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["\[Zeta]", "2"]}]]}]}], ")"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[Zeta]", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "t", " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["\[Zeta]", "2"]}]]}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["\[Zeta]", "2"], "-", 
         RowBox[{"\[ImaginaryI]", " ", "\[Zeta]", " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["\[Zeta]", "2"]}]]}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"UnitStep", "[", "t", "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.525575983807706*^9, 3.525576015000739*^9, 
  3.7933291611304493`*^9, 3.7933292805004997`*^9, 3.793893024483247*^9, 
  3.823224639431123*^9},
 FontSize->12,
 CellLabel->
  "Out[679]=",ExpressionUUID->"07d5c2ab-02b7-44d8-8507-b11101173143"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BodePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Butter2", ",", "Bessel2", ",", "naive2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{".1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5029916966221952`*^9, 3.5029916985778847`*^9}, {
  3.5029921259740753`*^9, 3.502992135380254*^9}, {3.5255746655563917`*^9, 
  3.5255746668440027`*^9}},
 FontSize->12,
 CellLabel->
  "In[680]:=",ExpressionUUID->"be300e3b-82b6-4358-818a-c6092be4d2c9"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwtmHkw1Y/3xikkSlKKqPCxpVKo7K4toqj0saSsKUJCSCGyVSiyFQllyZay
lCV53iT7eu1bLi6u7d5KltQn334zv7/OH+c1z8yZOTPPc46w7XWjy+uYmJhO
MjMx/V+VJu2YWVtjQGiXEgfVUwXXf/5z/+cqAyoT5QNSKSp4WyQjvrDIwBam
tHuv61UgK2lgOznLQEe2BdleUBXyW4MHmnsZqOgRbCirVYX6+LfGhDcM6DeW
tQlLkGB0ryVXzooBju0jQg2bNBCjMah30JwBfr4PFkFiGuj6RZsSN/6rp/DJ
y0ZNAyauLKK7TjIQMpK6OcxVAxfOKycxyTPwekbqcXSPBuz2Z0e0cDFAf/2A
+W22Jm62BV+zr6SDL+GnX8Y1bUTMevX+KKVjqXPj8OeH2ni54apGYBEdlnn7
q/jytdFMMuB9nkXHytEBE1OGNkTe8n4kR9Ohuzwequ5xHK1RmZvU7OmwPcS2
g/O+DsSN6nO3c//Vk/HeO9x/Aiou5bwvOejQboyb/sakh7Nhef6HWOl4ILlR
UltSD77VUef0V+fx9TtzyMubeiDLnv/lT51HjIKw11l+ffhtm9GfLZ3HrO7D
2TaHk+jq4pypspnHvargjdLKhrhr964y9+I8Eo47VEfaG0L6h2VMnOk8dMTt
X8jGGuL+tkKVqwbzMB9+d0aVbghVI7NIbsV5pJxx3+SWcRqZbelHrLjnkXr1
rO6/UWfg3ajq/7tyDrLvZHzjxI0gZj51brJsDuJ7/h1X0jACeTpKsr34b1/m
tP2Gi0Y4sJHakZYzh/Sy8twd0UYY1Q0TPRk/h6e8poHbmc5B/3NPQ8K1ORzQ
FrSpGj+H3cT17fKCc2BEsWyKbjJGM89RD6Wdc6B6FdUzZoxx+/JqpyrPHEQI
t1e3OUzQwxESo80+B9HIfW18+iaIMk7kMfoxCxbe6yt+TSZYP1vDfa15FkJH
tt8Q7zXFNO+uzWm+s6Beqzw/sM0cTx1GnDNvzuJF1rifjaI5dD6kN2e7z6Jc
YC11j5U5XlofinjrMIt7GQcFVHLNcTFXm7Py31lc2x9+a5POBbSpX9/Yf2AW
anEG4nqhF/HOqYZ1y/AMmHqe1PjKWUFByEUms3cGdzwrVY/YWaG8a6eFKnkG
k4dUPsnHWYFQdSp2qptBqv+zVtEVKzRu4blUXzADRYv4DWRra1CKrIi7oTO4
9/OYR4eMDTh+r97+cWgGtwwSl2IWbPHwbXpmuNQMGv+oVUptvQTuy4ZkEbEZ
ZC0rvGNIXwJv64t9Z3fNIO1E+1lWp0sQSj3R95plBgz6B037iUs4qh1/1L5/
GnzO367ojtvBOkLma3/gNC5kSFxMYrXH7eLo0Ba/aeQJfibEJOwRN7QgWOU9
jcd8Y79GTtij8cB7vSyXv/zSKR5ahD3kWpTSvMyn8d0oMMVwpwPYuLRNtslO
I8rzcsy7o1eRF2lScWqUBkpsJj/LMyfUlpQYqQ/RcEB/VFLpkxNGR/im5Xpp
6M+n1eTMOmHH4UFegRYalmnxKyqqzvBvt7o+XUpDPo9qpfS4M4y2XhUJjaJh
5EofJVbJBSvRPvdB+ss3VL1ZjnDFlGDVjI4SDdIlFQf5X7miJ5PNoPUIDVVf
rWmXqlxRVP546/A+GoKJXXxeS65wGXuVuLqNBpVVjiextm4Yl+nKO0qbwt5a
Tv5FTXe0th/oyI2awswm6QpZcQ9UmLvLyYVPYUipcoRZxwO51JK48pApHCeb
yK2/4oH7K5rmDbenEHvS79XzTA9oCZ0fn7SbQjkLywMlKU+UXg9ZFFacQpxe
7Z8Lyl5I4/rC/3R0EtX7OY2e3PNG9AXSBsWhSZhk1SknvvZGYFbqj/6eSbBt
FFzX1+kNW81LbQLNk1iXJP2YVfgWRLxowSnvJxESZNAuW3kLL4e/MzLDJ7Hj
gv5lSRYfpOZtqH13dBIJd0+KylX5IeqnQ5HJ4Ulwy2/hNWD4IUCnMXVZahKv
cjjt8nffgTUlwkdRaBLelaE9J3zuYO92HpmPHJNwdmzVnVb0R7KPYFLNyATk
AyqOJNsGIElfxr3zwQRy5MPjSjkDIcqp39gePIGd/LL5jWKByG2yFWn1n4CC
DLP9OvVAlJ+KJdd7TiBLXTJ63CMQ/YbLspU2E+CoFG1zpwRix7mPC1mKE4hk
V5pfrAxC5AU9zzvT1L98JE3iWQh2CNq2+FCpqMqdEbUoD0Hy0G2xWyNUnPFu
vYL+EORb5HXf6Kai1bz4Dyd/KJqtthy7WkVFdQ5rXnNCKNjtupfOJVBxmK84
STz9HgKdbbz36VEhNEL8J/blAb48skwq16KCSaJlLpstDEoFF4iTalS4UlcV
rh0Kw/dFY3YXOSq83cI9iu6GwcZf/2nhbiqkB2ac9faFQz1arlT5+zgyylU3
LgZH4E8J64rBs3Hk5elGK7pFwnxgneBI3DjcW96/9XgZife/10iuUeNI5NSu
+t0ZCReN1XvRIePwUrRtXhWIwnAjfWfv9XEc01N813Q3ChXDvfLW2uOQ7FSS
ZDF+DJ/1OTfd58eQmmyQHS8QA5cESzZr2hgOrEtOCJCP+etD2+IMxscwW++v
FHMuBvoXfAsl+8fQXB50Wy4iBnxFhvNfasZQzMtz58paDIptF2xPJo3BMfg9
S/N8LOhVKoaiJ8egorJzy7m5eIyZfhvaqjOGUaZt0s2bn6B7PsNpTX0MHMU2
m70OPUEF/5YHA8fGIEUek7C48QThbqOfokTGIP5eLCXgvyeQFA5V/O/nKK6r
7Au4KJAAm4A20Z6sUYz+4Tjn5/8MJv0pasNpoxCdF3zZlfkM+rKuZtTkUXRL
bt9s1/oMR6jcEd9jR9FZdszzwJ4ksJ8wWuC6OwqzQzYXnYkk5G/prtI9Pwqe
jcedv25Jxq/kAcuyjaNIOUW7/tYlFV+Xc7wJllFwP3YjHQpNBfWMT3TdGgXK
Sb9D256nonWdYG33IgXT75OVPVtS8fKKxcHvoxRQZ1W9zaVf4IQ05ZdUOQWZ
ngqsJUsvEPdx4mmSIwUBocETgmlpsPROvCN/mYK9KjdXIqvSICl32o5sRUGs
xONNspQ0lGeVHmI3pqBRWdeMZU86vsSE194gUXD0XLfn9LN0SDjK/NDfTgHT
COfiUmoG3A+uJn/3GcH2z2mDJPIrsKRdcpR0G8H4Psdp8eVXiOdrOWp5ZQSN
TzvIOoJZ+LA+tbnhzAgm8hNjZO2zwDJwfDVVbAT53IL2n9ayEB/62Ph02xd4
sUf38qnkoHxEclOeyBdMlDsviVDz4KvC/DqR7wvY7llF9W5+DdWEfoMHXF8w
pmHxs07+NQijsMgrq8NQmPEMt4h4jbrPszzC5GE8UE7huqyQj67cfP74u8NY
Kj7PKZv0BvSbRyQCKEMQlN3tmqpfgLddm+pdeoawtyJB9dGlArjJTDhYNA9h
Q9CtohTfAvyYictRKh2CDf81G+k3BfhlsXxwMXII57a4/8u0oxDs2uVHHElD
0PznOD1tphD/cKtr/ps8iEMPDZ0uFRTj0eHR244xgyje9HTbm45irJwJLAq4
P4igeztyDnwvRvPjGtHX7oMwrWXpqJR7B49tehvYdAf/7o24o27ZO9TuMGou
YQwgWFHTVLr1PRx325kIaAwgRLzePlK4DF2qrJEyxwbwe3O/fPGJMqhZZtbp
7h/ATn1DQ17XMmxLoSl48A6A/U1Y2UOUoULomkDLdD9cX3TE2NiUg0vUi3In
uh+eceaWU28/oFDqvuPYeB/aOSfv7gysxN4O67L9/X3gWeKwS31biYibiuye
rX24bL9B5/pIJS7XzGRsKOuD+nHLNIoqwGdpMHrgUR8s5Qx37v4D+D3mMbup
0If0e+55B2oJnFhJOr7pYS9OnRmJdnWrxrtkz1jjwF4oN0288HtYDZHjhuPJ
N3vBtpiaXpxdjV+P1wJkbHtxN2Hy5ouxauTvt60wke+FxIoph5/JJ2y3kpB7
MdqDPT8Wo911ajDyuUDo2LEerPJ8PLJHrxa+535qKxzoQd64s8hzh1rwjapf
VRLpQQVl9rXu/Vqc+d1WoMbVg/JWuVCh+loQsnRN3cluZMmdfDmlV4fUFKnL
ZvHdmPjgkb5mXA/bW2nZt5e6UB5uGMUW3Yg/bLMtvnNdaOUcIbuUNCIxVvb7
nbEuJGid9uUYbgT5TZVSUGsXvg4kcw9LNkFrcqQpPLML2coN2UvVTRA9J0hP
MukCX4TEijxzCyYOxMnifSe0vV6bT75qg9SdDDottxMfj7Uf29DXBpe2dzk8
LzpRU2wUK8/SjhW3HpEr4Z2YEXOZ4zjaDo6Snds2W3fi+9HhHLun7Tiskbhg
vrETwXE5rdxXOuBjnFK8dIGMhjKZ7A97OkFkvnEVOkvGiNHZghfKnWBZ+RuF
dMjgMXafLDDrxKNESvrzw2TkFF+uOBvTidQR4ThtVjJusk1djuPoQu3VdM/o
/A5YbO1atWLuxtY72cekmTsQ9Yv8O3trL0LfS9ZzL7dDQL14/0+ZXqzSX51f
mGtHPS3rww2jXoxZZfqW9rXjmfiDztmYXhRqpFVrvm2HY0EE5vn6YMT63NDU
qh18Tj+2O+zvhwS/cAuTTxuiWROKP94YBHfY3q+fr7RhNqOIMp4wiJXV3dvC
jdpQumjqpUIMon5o13leqTbQCseaQzYPwSF1+8S+/lawslFK/XOGkCPB/p+R
fCtG+p9+Pk4fxoFjjAMZC80QVwy7b3+agivS/v5lw82g3HX5UGlPQYr4FnJL
XTMq6n1EFQIo4Nl56ObSs2a47NPQiC6gYHnZpUpXuxlSMwY6NN5RVJfRjWdi
mzC3LL2oPvHXF1Tpdw4da8S9bn+f3pRxRB+906El1IiQTOGrDRXjaDrIJWrG
0YhCFk2u8f5xqO2Rbgj40oAQpjj5R9up+Gft2jZyaAMq7HT4G8KpoBPzrzx6
67HDLJl79e4EgrTn28u867D+moR9/KMpVJ+YO33kUh1k3ZkLld5OgclgtjXf
oA671FzYOclT8DWebk4TqcPHkuiYwzto8LoyUf+wuRZSscUnYlNpcLg/TNgI
1UJjZDV56uM0TjW3vN1YX4Pd+rHGm//eSWHtzYeCC2ugpnrfMlJrDvVdTfl/
kmpAiOve0HKaw/HhhrwFtxo4JhwO1vwwBzX656xhgRpwrDm/fGExj8PclakF
1z8hz3Z+kiuPDt5/86PO76yGimwM1b/0KwrFw8uPr6/Gz7xZI5bWrzjz054q
w6hCU1e8/IvxrwhLFlbgqKtCekJQseiWb/hDix0p96pCYEzP23/tv2HSz0da
sIfAHwOX046C3+Fy+vHTj/sAZcNWn5WEBWT90J+LYwbuN9UlFBYuYCyBRd2l
vxKF/bvy7zUtwIR6c2rPg0o02D1nD/pvAaRblscCaB9xSVE9l7D9Ae60/V2a
rypwIyMVDrKLKFz6vKVetBzx1pECC5NLeJTzslrtZxm8AtgbY1iX4WTp7/mu
pQxPbj35z0R0GaK1CoMvvcqgsofD6LjtMuLjcjP96kux81OWWs3IMm4feawq
51yCc1wwsxpdgab7RafkomIsM1e/eLW2iozBiYfTwflYWnq0uO31GgZ8d6Q8
l8uHg1m/8HnyGrj26L49O/YaT5xL+4jlNXhZZ5HLSK/hY1S62VeYidCZcNwZ
tpqLRhOfgqBrTASNzkiVcs1G+vAllgF2ZkJq3WqR04V0fE3cPdh0ah1hcVaw
ePBSLLwdk8K6OViJuYVFRc+aGJhuWbHwF2YlfOPbwCUWgxXuXTQlBVYiaTCw
SWPyMZ6+9Ns3dZmVKG4ifz7d8Qiq390Tt1ezEm9+OP9DGwhG5deiuho/NiKg
S7JL4JMqGJ3C0kHr2IkyDp/uas8Yks9qzsEgDU7i6Bjznrtmb0gUDppvd/JW
4p+vH34qVZeRzO9bCAVReQm9tP4WQ7NqUtRJziJtTgHiuAHP+sV3dST9JdPN
77WFiEir3oDDJc0kavM6rrxfIkSd4e7NZ3g6SPYhu7IrN4sT88K8d8iJnaQ/
z904+NftIzw99ttE7ughCcVyC08v7Sd6h7iNrtT3kRaqor/dUDhEWN9Smdpw
apCUwdZQIS0mQ3zaLx/2ifULSUfJwfsEWZYQ31hBSz9BIe0vVeJjvnyE2F3h
dJz1/ijpslOOneS3owTT6rps97Ex0twRJoeJFHli+exHy89iVJJS+W72WFlF
YvCIlYBY8ASp8EZ0+I0pJcLVlHuryNAkSWGd5K13sSoEfyzVjGU3jeQj0FFv
JqZG5F9IfbXgPU3yKllomeklEaaq/ifqP86QxAom2obfqxMFltdElH7Pkma/
KIV0+GkQKxxa68uM50kGAy91Co01CaMO5WO7n9JJq3dj4iT2ahEcypxVFc/p
JHbl+X25IlpEVfrAyYtpdNJ9jzuV0uJaxGHvWzbP8ukkk/U6tKMHtQiuvSUR
/J/ppBWalZq2shbR4Cw7zvudTpqzv/HD2lSLUGffF8V1ikHSiOgPSYzUIlbc
Vnbln2WQzpwLENoTo0W8GazLMDBlkDjc/v3wIl6L2PPmyocIWwbJOSLoW9Zz
LeK3cfokxy0GScB60aokV4soSduruiGTQXo6PK3dVadFuGxm1GXmMkgXa7TH
TJu0CPGblUY6BQySXUa9/2CrFhGrb+EQUsEgqRnqfxjr1iLcvyXGrO9kkIJ3
SR/5Nq5FSF1w3JPWxyARbxrIHlNaxGiNYrbmFwZpRTHCbWVGizjztK/y7jSD
5Cgb8mbtmxbBvi5LT5jBIImKfjAMWtQi4HSzi/jBIH3ZupPO9lOL8OrWsbJe
/Ttf5dOHYb+1iP//T5IS5kgHuZi0if8ByMNXPA==
           "]]},
         Annotation[#, "Charting`Private`Tag$418181#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwtl2k4lIvjhi0JLRJCpwgppLIrwosRZasU6TiNJTmlkrRQZIvSSqFFacNk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           "]]},
         Annotation[#, "Charting`Private`Tag$418181#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwtlnk01HsfxyUu2ZdLFInkqTjW7PSVoRBORruyhZRS12USLVfXLZVKlucZ
S6UsESlLdj5f60hjZ+xqhhlmmPll6+Kqnp5znj/e53Vef7z+f2v6XyYHCgsJ
Cd37uf9RHynzfvwg4Kn6QIna9nK4vLojbnWNAMrrUwoyhuXwrtRIZ3GZABHx
zZ8l7MrBeJebP2eWAC+vNxwd33Iwl48doQ8S4LQwFsvNLAe7yfn21LcEtA/4
2WRqVwD5bkeBiQ8B1zSFYmRMK+FqV+ylc/UCuHixyGU4uhriZymDS5UCiGyW
XY9NqIaXYuf33y4VQOgjfrldTjXQkZvS0zwBHE4iR810VoPWO6W63kQB2Emb
JK5p1UBnQq7UvnMCaPvdc8WkswZ0yG0Fv8oJ4JFV0bajRnXQ3y/Ja/Djw05/
vahnyhhiAt7XF5zmQ+0Vu2lPLQz6S95JKcf5kKC58EFeH0OcYonNeTc+bHRw
Fn/liMGWfOKxnCUf1EZCFCwiMOR2Ze/1keNDuyilYnUAQ2S77a31+jkwlHZa
13nWAOr48q/manPg9tY3M8WlCegKpuFWm+fg5icZzSMnmiAqcK3PVmEOXpiX
HFMLagKGxF9JDuJz0Gvc8c+HmCZIOJqmQF6ahRs9wrNpVU2wcbZZ7hJ9Fvbs
p59U1W0GrtIW6azrs1D7Qsu9SqkF3oc0i8qO86Dd983AVkkaWGwPNcod5IGv
QXjNpBoNqvs3n7Ht5QHnnopplT4NsG1IWQiNB1u5qVIPyTRol1U421bMA+NS
yoXhNBp8LvXBMXd44Pjahyut3wYS62tRSwY8SLiyWGng8wF8442+DN/mwvLd
oJU6wUeIKku803GDC8ErhpldwnRIGVtUa4jkwvl9Q7GEMh3a9cqd80K5oLGu
qXcK0cGkwyqLcooLbYF0sbEEOvwi43BM0ZgLPAmNkjSzDih8fKzWlTkDI9/S
NA897ISVxOg4QDOQXcqInyrrhmm1Bt4Bqxk4zTv7aaKhGxi5v7h17p2Bg0l8
jcnObiitfiI/vnsGAviX4zZxuyGU9SptTXEGmkWyWjvVe2DSqL/QdGYaoN0m
dv+9Hujs1uspSJiGuosBUd/O9UKWzIQqlcmBB08kc+IP9EOiFxKzHOOALNU7
+OvRfridl7k0zOBAgkJMYUhgP/jbn+3aSufA3m8HhyJj+0GLMhP7vJwDTKnU
3G1N/fByfIHIfcAB/SRjynP7AcgsFGt9b8oBbQ/rlmIXBmS4GIX13WNDWsd3
YcmYIdCWdGnvjmWDyLu42ZOJQ1Dw0V+r8xYbpgqX28qyhqDaNbm3LYINGo1i
tx+1DsGw+9/G9X5soFHX2nulhkHZs24xz5INd6miFTnpw/DYyzniJncKktcN
uG8aR+D2Rb/I3c5T8NKsyFzDYhwmHnlnVJOmIM3w8mqw+zhYFXvhQ/umgFwY
6twUMA4Ly0fFQ01++uWyxvwn4+B3y4Vaoj4FDudr/dDcONglmlRaL0xC0Y7o
7P9kT8D3CtEVt/RJiLpQu2uX/GeI3vj6ahifBdQn2Xlur5kQmur9i+8MCxhH
5vS6y5ngb6CY4jbJAoFZsKNXExNcvK6X7BpmgUX1qtODMSaolLrzJ5pZoPlR
xdRTlgVl/ov+hzJY0BpDu3WX8rNrsHHXPsSCI9djfss/NAl+f3RpM/KYMDYo
HqSqwIaUOjY148JnML2/tOWGCBeqP+2SKtSaAPl5ojZeRQA75OzsjzwbBXvz
H+lTw/NQsifuAmtyCG7922RS/8oyfGop3m5mxgB6MYeqnLoKbL0UYyjvg0pT
oRTK9u8gfzPfTH9DD5y1Hlaxmd2A9cwIvZxFOtisd/QFCYniPx343VWRNDAN
Yu1cGhTHSkeKEk5uboS9b89eG94jjUu+tsi2aVdDGdOt23FcDueMsh9yY4vA
3ag3eDBLEZ/xUCsbPZsMqaF+IVl3lHGVRPRAY0QSIvvaUztfqmJT1oZtMSfe
ojc9e/kbPNXxji81q1aNVSigJoBqcnc7ds4a7nA/0YietJ5MESvTwo5uChuX
39PQNtkcxX3r2vixz+AfhhV09EOxRjja5l+Y5q4ufVihB2kuhNkO0ndjvqbS
zd60PlRkq/gt2FUPR4Tr+j1WZqBCGDQTYejjwTE5clDbECJ3bUmrYhhi32s2
02Kuoyitq7E6yMQYN+ma328SnUCVZQUbrMtNsM6m2plsp88ocDFs/IWOKVav
DXEUjWMiBWpHRkaKGRZaE84PY7HQV7FLGta7LfDfHnXeLTunkHLO+XTfXEs8
utdn685YNhIv7pOPOWiNrxyXk9ca4yC/8GnKn1M2WDV56oSI+gzSZd4wCAze
h4u8Ml8tRnJRw/0HoUVidvi47S2ntjoeonhe7ZPttMPF3pe0rNZn0e+bOHUH
n+zHKxKkjVVH+WgtXEy4NdAek3uszdSpAnR9l8fNVD0SlrCWbKh9KkCtKh+P
KxiScEP2yKHTWQK0RXfe8oEJCRtGXvNLLxKgK746KjesSFhGoyJetUWAzoxT
rP2cSPjDReNJpQUB0snv2qwbQMJ24rsTZFwJNNQXvNqcTsIrv61sKfIg0Df2
/dF9z0n47Sgtx+04gaZ041oqX5LwtrdBNfH+BLKI+eddYT4Jrx/N5khcI9D1
Fyrs5AoSrsjSsBXLJVBZI6M2qI+EQ6UJWm4BgdY8OlSZDBLWuVpPPlBMoNEF
25teIySc7HIm+K9aAn1pijhzmEnCYfNpSRv7CCSlnh5uRZDwHq8L27KGCBSZ
WCf1foGEmc2W+fYTBJp30C00+ErCh6lD9TFcAuW59gjt/EbC4sJ5zpoEgUa0
vr9/LuSAIeRqP14ikLCFT9gWEQdMGTjg47tGoJpBgWmKmAP+//9AUuRXQnKS
Dvi/EAatEQ==
           "]]},
         Annotation[#, "Charting`Private`Tag$418181#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-1., -40.08642585916468},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-50., 
           FormBox[
            RowBox[{"-", "50"}], TraditionalForm]}, {-40., 
           FormBox[
            RowBox[{"-", "40"}], TraditionalForm]}, {-30., 
           FormBox[
            RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
           FormBox[
            RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
           FormBox[
            RowBox[{"-", "10"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-48., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-46., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-44., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-42., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-38., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-36., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-34., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-32., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-28., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-26., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-24., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-22., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-18., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-16., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-14., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-12., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-8., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-6., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-4., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20.04321292958234, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-48., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-46., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-44., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-42., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-38., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-36., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-34., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-32., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-28., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-26., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-24., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-22., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-18., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-16., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-14., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-12., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-8., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-6., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-4., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-1., 1}, {-40.08642585916468, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-50., 
          FormBox[
           RowBox[{"-", "50"}], TraditionalForm]}, {-40., 
          FormBox[
           RowBox[{"-", "40"}], TraditionalForm]}, {-30., 
          FormBox[
           RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
          FormBox[
           RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
          FormBox[
           RowBox[{"-", "10"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-48., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-46., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-44., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-42., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-38., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-36., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-34., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-32., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-28., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-26., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-24., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-22., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-18., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-16., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-14., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-12., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-8., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-6., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-4., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20.04321292958234, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwt1Hs01GkcBnAZTu0UYaVsybimkhoV5dIrJJc4brOUGDPml0pRU8LabE0q
aiy6unU5LlHaEVssDe+X0mjTkVxGueQ6uezM61KbnLZ29pz94znP+fz1/PcY
cWP8KVUVFRVvZf5rK6Q3/u0bwanX9B0jnRkQ89kk5fMcwbd4uVsC3Bnw4Hem
+cxHgjML/SK2+zDA2sKbK5sgOGmmwsN0DwNstZPfNksJnhDDUTU+A5yGpv7M
LiO4M31ywiqfAf7nX5ZuZBMsTs0WWKsZQVxL8uHIOgXO7V3sYNZiBO3tC8fr
OXK8V9tuoKXEBAwgRtd2xV84SidI7p1hBo+inqov7h3HlXZuF4xurIJwIXPy
jWAMQxerNkdrDcxeSkzBaBRvWbXt9bNrllCg2aefNSDDXokuM7/lrYc8Tya/
LXUEX28V13UfY4LgECd+tccwni4atbpnvhESaffi+PJBXOb2vFmPuRk4p1pM
O0sGMB6ZyfnZxxau1o5k5R3sx1pTavxX2Vuh5p3FovvGfdhlrPdFdJgDmGg5
OQfe7Mb0hgqeIUJQsSbl4OBQFz4yteJiaOh2eNdYzrCx6cRmXWMaeu4uMGJ5
1RpXtmF13R+XNbrtAO2kuzZW81pxgazMNP/BTrC0IZZFM83YXjT0IsjaE864
yl9Vx0swbSBItHqTNywJFGXsXtqAO9cm0kq3+kLF342Lm0xrcEe6k21ejx8U
dY+kjSWL8FP/wpOv6wIg1G/Fw+6IK1guqzyceIkF1fTEjobYy4gEl8Y/5AbB
5sF5K08Hl6GkeqHDWMBuMJl8/NmuoRpNPDsy2KQTAh4Fb176BDegqsy0T7Vv
98IObx3ax0cS5JV7UjM1LgzS2dJTG6qakb7xhNciKRskPgYavjqt6EtgzMW+
6+EgN1qS9DqnDT2/538syoIDscfXctL1OtFXtkXDbDEHpD1a/vuaulD+95rr
5plyITzB4f38Xd1IkDZtn3+RC0/W2l54ot6HHMZZJa6TXDD/Tjxa6N6P+o9L
NU66RoCBOGqHesoA4orXw4dfI0BlTvUuf3AQfaif2i+SRsAnv9qwRrNhdNNS
NtShy4PuTezlZskjyCAwrTjblwdHgrS0jXtkSLDnSeaBszzQvzIcrGYwiq69
YG1TqeCBKOR28Uz8GBLO75yT9PIgyPEX96baceQpWb+uWZWC8rDDxnZfJlDC
0nX27SYUzNJdaNUsObrFLRWyXSnwb7W3MchSoPYs0JpmU0C3X1gvvqFAyyzV
YyPDKagvfOu1t0CBztEqS3qU3hCfwMkVKZBjwIOkZxwKNA2rhPqNCkTX9X1/
PYKC54esh5ZMK1BwVHgtM5ICpwWrMzR3EWSzc3ihc7Ry/+jsDyI/gvqaM8+W
K13WLSnyDiKo4pxtKyOGgpVl+x4LuQS5XK7p+6r0F1ahjJ5A0HJ5Y/sfRymo
KjB0nH+HoDNM+jbTWAqiNYjkTilBt8MO9GcobR5X5+9WTtDo6VnWP0pf8Qzd
f1ZM0FzITE3HCQr4UzmXaW0EXXLkRyfHU7Am5ODKgi6CpHb77xOlB55uvevc
R9DSYvO6PQkU+GZ11Z0eIyiV7R664ScKFqiWeBgRggzZreM5SuOouHb4QJBg
U/Qu9UQKTnS4scPnCGIXMAUxSv//Xyhrn5XwjdL/ApXZhPA=
           "]]},
         Annotation[#, "Charting`Private`Tag$418519#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwt1Hs01GkcBnAlW1FulVIhBqvJqShj3XonW5KGzCxLFzNmzE/tKETlVi6Z
zqokoU1UZ9uR0sWkkkZ4v0iTlmUiZEoIocxbWbkcbTt7zv7xnOd8zvP/Yy6I
4FAzNTQ0vNX5r1cjo+Fv3wheQup3fO6gQcQkLW1yiuDuecV/rOimwZ17dtaj
YwS77o0Ws9/RwN7GWzDwXr1nCowejdHA0UDc2dBOcOxZesZtQ0tgvv307IKU
YH/K9Yq+tyVwfm28uY5HcEoM7bu2WkuIaRLv31OlwvmlvdE5MitobdUZruaP
4FSR8uzyL9+DCUQsdFz+ATd1CvZUb6RDadhjLb3Xw/hFyXR8+ENbCE63+/jy
2BCWk3P6p66tgYmshDSMBrG3XbWTzM8OJLpdxrk9A1h28qHU1mwdXPSyi2o5
0Y+lpo0nluk5wLF9/NiVW/vwmqG+Zxe0HSFB80ZM1EgvRs+CrqeGOgE/ucmy
7XoPbuphZf2gcIFzlf25F0Xd2DKD8qzdswHK39jMu2XRha3DotN9KplA02e6
+11W4rCWY2ue+7jDXXqaqPdtB7Z4kxniT98Eb+pKVjAYbTj7vK803sYD+m3P
2eMHLXjMSmdbs60nGCQWMVbPUOCv9x6eFp70AlsGsb062oB53MvjWcMsSN00
0iyLleMFDZKk6RvbYZFfceaOxTU4r/H4quRNbLj7pU7vqWU5Lki9GOdwkwNX
lf2nh8TF2HmBe6/SzQ+C2MvvK0Ny8PnKIvOpSn+QaSe8qDmUjUq9xfdXOwWA
Q+8M05RAKfrnTj33iiIQaB8fTTrXyNB4tqvVY4+dsFXystEnsAbZVImK3Bp3
wWZvQ82xUjlSnL2ns9M5CM7w2pPXljUgR6OcE5pHuCD3MZnva6hAFguTFmfV
8GDEfFHi87wWVLil/YAqPBgOHVzFP2PUhkQR3IMyEgztr/Q5oU870BlTg5bU
SD4Ex7m+m81Soop4ObOjiw+1qxxP1mp1oUieA9rJEoD13IrBAs9udOvuqarq
IgGYVIRt1krrQclbjppKvgpAY2pmUVRvL9IplLJv+4bAOLuSW2fVh+qF0V/Z
50NAuZ63zErcj/7a8c5r7usQiAzQN7B4NYC2JWbMpS8TgnFOX+Ask0Fkn9G5
dHK7EIp3/X5tNHYINRyeYpiKhRDgluT5tHIYuZf9Vi66I4QS7n4L5+n3SP+I
Q/OSDiFMaP+oKfMfQTbGfaXsb0LgKFwYJrkqxCQfvkhWUKDtolNdcUmFeI0D
GvbmFFQXdG7bLVGhn2YcUWC118bG8fOLVej9SOuTTgsKdM3K0o3rVCh/35NZ
ulYU1O+zf7voswp5iR/0/LKSAuaclZm6LIIMUwVV43YUTByYWFrMJihv97A8
0Z4CqVJ+1TuAoMN+3Xla6ygwlYY+ShcQZHYl/JLhegqm/QsGtOMI0muOX0xn
UFAmMXObXUiQwQD12ceZgvD5RF54k6DR6vmXnqttHVPF8SghyKgpyfBnFwpy
vIL2Hq8g6AZnCXe3KwVRn/KyNVsIKh87EB+6gQL6LpGppIOg/Iyao4Nq9zx2
KnLvIsjLKo0lQhT45nZUpQwRxNWXs/YzKZgz8/pWc0JQWYkoUaU2Dotphb8J
+nO4PSFiIwWHX3jwgqcI+tRA2/xR7f//C+nyQzoj3Sn4F04QgtE=
           "]]},
         Annotation[#, "Charting`Private`Tag$418519#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwt1Hs403scB/BlddQcbF2cVHJtLPKwYiX6CgkhVhpFs9kkVkqXkaJYh4ou
0pM6XU4NpXLtZCl8PxZHdXjkKJcmctlyafuRlG7HcZ7n/PF+3s/rr/d/b1N+
LFuoRSKR/KbyX9sig6HJSQIvqyN15bXRIfaLefqXrwT2pD0pU3TToeS+PX1s
nMD6Kwf3zB2gA9PKj68aJvDOrZzC0xN0YNEkrxvaCNxqkuaWb2gJrn2jzy8V
EziNeqqKH2oJ7LTGu8u5BM7MtCPN77cEcZNk145qDWaITCfvfbeCly91hmp4
asxJ+aS75oQ1GEHsXNai91i75nCSxxJbeBBTO0P/zRAO6WHLfoq3g/AM+5GO
lEF8ro/yj4EJEyayEtMxGsCNrKNv2l4sB6lel2FOjwp3kp+dPtLsAFd87ONa
TihxoWlS5sEJFqSIePEM735s8qjQkmHlBInkO+I4dS+WCj369lQ6A+9ok0Xr
7R78TX7oM20rggtVypwr0W9xVKcL97z+WnjUbfXzPbMurCGbdxkUu4E51dVt
8zUFvuK6QdYQ4AFlS9Oje/va8ZaOKHNTlid015WaODq24uZeVVu3oxcobS4w
cXkLvhiuTTnD9AFaUoGj7bRmHNk0sE+c4As2joRN3lgDNttpl7e23B9SPdQv
KuLrcVilRK/uegDM21x0NuQXObY6rRqiDwdC2ac6/acWj3DmYTPpWcYmyFMo
MwclRVhmZJe8/uRmCAtc9IciIhtza/UuadqCoIKS+Ep+4DxSRl41izLhgEPv
tMXHgouRy0LEX5kaDOYjj784ySuQ+KL0+JznIeAt7Wj0D5Yjv4y8qgqLbbDO
bzZ5/EE9smG3VxTvDoUz3LajdrIGJIr+dmzZxTCo9zfSDZjdjEpO2KcWPN8O
atN5SX9fbkEjOwxC/BVcOLDfmnfGoBUxjcurrUXh0NZJZUc+bUfXUjh/uqrD
ITzB+Z22rwI5aFczNGE8eGLNOvlkRhfaOP6r7v0mHtBnVQ7ker1FEqMVIsTk
g1FlzLoZ6T0o4c4hzsApPpC+ahXE9fYi9xwfL5mSD58Dq7bXLelHJQwJ9x0z
AhQruAuXSJToR/4RMSRHwB4OlWbWqUIhKes5tbURYJjdHzzdaADFxuSfa5iM
gKJtv98aix9EN2odvCOdBMBxSfZ6WjWERtdY7I8SCaB0+y4zp+/D6FSnODXs
kgAmKO7kiiA1WrrB+eZonQDYzasdjXI06OGPqptDwwKgrNapqbyqQVn/6JRm
vBdATe7rDaFSDXo9f2eyrVoAdvEJvN+KNEizryR0r0YAesayDMM6DXIzpC36
OCKAZyJm37wPGjTm/V6uHheA60zGWT1fApW5z91SNjm1v3diQVEgge640LN9
SUIoVtTn+XEI9EzNuqCa8uLiyMcZfALFZJW/NdQSwvegXBUlgUAPnXOvH5ku
BJnU2EU7n0A1Qe7Nq2YJYbcuUZ9/l0CzeLo+L6ZMF1ezPUsJ1BTokRZJEUK2
T1jU8UoCKZZt2pilI4S40cvnyS0E0lodM/+drhCWboteLG0n0GPqHFminhB6
alcVuHURyOGGYgFVXwgBOe3VxwYJ1BhoxVxJFcJMrdvepgSB2Podyr+mjGPE
L+EjgXbIyVwuTQgHX3lyw78SKPFW9dUPU/7/v1DhmPHN47OF8C+82nwx
           "]]},
         Annotation[#, "Charting`Private`Tag$418519#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-1., -171.8703061014428},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-200., 
           FormBox[
            RowBox[{"-", "200"}], TraditionalForm]}, {-150., 
           FormBox[
            RowBox[{"-", "150"}], TraditionalForm]}, {-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {-50., 
           FormBox[
            RowBox[{"-", "50"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-190., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-170., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-130., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-110., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-85.9351530507214, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-190., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-170., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-130., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-110., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-1., 1}, {-171.8703061014428, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-200., 
          FormBox[
           RowBox[{"-", "200"}], TraditionalForm]}, {-150., 
          FormBox[
           RowBox[{"-", "150"}], TraditionalForm]}, {-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {-50., 
          FormBox[
           RowBox[{"-", "50"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-190., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-180., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-170., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-160., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-150., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-150., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-140., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-130., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-120., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-110., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-90., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-85.9351530507214, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.502991700203302*^9, {3.502992127094397*^9, 3.50299213640134*^9}, 
   3.508360828425239*^9, 3.5083609457990313`*^9, 3.5247988863595543`*^9, 
   3.5247989248395977`*^9, 3.52479895508948*^9, 3.524799083706849*^9, 
   3.525574631305825*^9, 3.525574667963468*^9, 3.793329161447901*^9, 
   3.793329280812688*^9, 3.793893024785701*^9, 3.8232246397085257`*^9},
 FontSize->12,
 CellLabel->
  "Out[680]=",ExpressionUUID->"98cfab8d-d5bd-46ca-b831-4ce472aaef38"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Butter2Out", ",", "Bessel2Out", ",", "naive2out"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "15"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.502991718927526*^9, 3.502991723498419*^9}, {
  3.525574650191134*^9, 3.525574655716284*^9}},
 FontSize->12,
 CellLabel->
  "In[681]:=",ExpressionUUID->"a0fb379f-7230-41f4-a24b-c43c1325f180"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd13k8VF8UAHBbIYWZkN3MYJixZCnZco+ILC1Ei5AWUWRLJSoSUkmSkCKE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       "]]},
     Annotation[#, "Charting`Private`Tag$419083#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd13c81d8bAHB7k+1eK/O6FzdSyOo8ZlFRirSRFSWVEIpkJ0lllVEhEqGy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       "]]},
     Annotation[#, "Charting`Private`Tag$419083#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd13c81d8bAHB7VPbe49r3KiSFch6KjCSiSCFFUmZDpIwQGV9UNiGkJSPK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       "]]},
     Annotation[#, "Charting`Private`Tag$419083#3"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.5029917253954973`*^9, 3.508360828758581*^9, 3.508360946038371*^9, 
   3.524798886529125*^9, 3.524798925039544*^9, 3.524798955341073*^9, 
   3.5247990839620256`*^9, {3.525574631473287*^9, 3.52557465696596*^9}, 
   3.793329161599615*^9, 3.793329280964898*^9, 3.793893024941558*^9, 
   3.8232246398263817`*^9},
 FontSize->12,
 CellLabel->
  "Out[681]=",ExpressionUUID->"fc0ee837-ff6a-48d6-95b3-ef78ac6442ac"]
}, Open  ]],

Cell["Repeat for n=4:", "Text",
 CellChangeTimes->{{3.502990240489703*^9, 3.5029902545621243`*^9}, {
  3.502991222863015*^9, 3.5029912285476627`*^9}, {3.5029913333487167`*^9, 
  3.502991336619069*^9}, {3.502992198909535*^9, 3.5029922026443996`*^9}},
 FontSize->14,
 Background->GrayLevel[
  0.85],ExpressionUUID->"2e7c0727-9654-4e53-a75f-93f3bf75abb2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Butter4", " ", "=", 
  RowBox[{
   RowBox[{"butterworth", "[", 
    RowBox[{"1", ",", "4"}], "]"}], " ", "//", " ", "N"}]}]], "Input",
 CellChangeTimes->{{3.502992215078011*^9, 3.502992233341052*^9}},
 FontSize->12,
 CellLabel->
  "In[682]:=",ExpressionUUID->"9cd19836-55b7-45c0-b07d-923671a2f34f"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox["1.`", 
     RowBox[{
       RowBox[{"(", 
         RowBox[{
           RowBox[{"1.`", "\[VeryThinSpace]"}], "+", 
           RowBox[{"0.7653668647301796`", " ", "s"}], "+", 
           SuperscriptBox["s", "2"]}], ")"}], " ", 
       RowBox[{"(", 
         RowBox[{
           RowBox[{"1.`", "\[VeryThinSpace]"}], "+", 
           RowBox[{"1.8477590650225735`", " ", "s"}], "+", 
           SuperscriptBox["s", "2"]}], ")"}]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{
        1.}}, (1. + 0.7653668647301796 $CellContext`s + $CellContext`s^2) (1. + 
         1.8477590650225735` $CellContext`s + $CellContext`s^2)}, \
$CellContext`s], AutoDelete -> True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{
        1.}}, (1. + 0.7653668647301796 $CellContext`s + $CellContext`s^2) (1. + 
         1.8477590650225735` $CellContext`s + $CellContext`s^2)}, \
$CellContext`s]], 1, {}, {False, False}, False, Automatic, None, 
     Automatic}, {}},
   "TransferFunctionModelMinimal",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{
           TooltipBox[
            StyleBox[
             StyleBox[
             "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #]}}, 
         AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{
    1.}}, (1. + 0.7653668647301796 $CellContext`s + $CellContext`s^2) (1. + 
     1.8477590650225735` $CellContext`s + $CellContext`s^2)}, $CellContext`s],
  
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{{3.50299221810562*^9, 3.502992233920047*^9}, 
   3.508360828801647*^9, 3.508360946106069*^9, 3.524798886648245*^9, 
   3.524798925069499*^9, 3.524798955365996*^9, 3.5247990840128193`*^9, 
   3.525574631502705*^9, 3.79332916167479*^9, 3.7933292810413218`*^9, 
   3.793893025009358*^9, 3.823224639888723*^9},
 FontSize->12,
 CellLabel->
  "Out[682]=",ExpressionUUID->"97b85e24-1092-4e81-97a1-5bba94e35b2f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Bessel4", " ", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     FractionBox["105", 
      RowBox[{
       SuperscriptBox["s", "4"], "+", 
       RowBox[{"10.", " ", 
        SuperscriptBox["s", "3"]}], "+", 
       RowBox[{"45", " ", 
        SuperscriptBox["s", "2"]}], "+", 
       RowBox[{"105", " ", "s"}], "+", "105"}]], ",", "s"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.502992254623559*^9, 3.5029923144707623`*^9}, {
  3.793329172760832*^9, 3.793329175092237*^9}},
 FontSize->12,
 CellLabel->
  "In[683]:=",ExpressionUUID->"9eeb3bb0-cfb4-47ab-bb81-5e7d8cb43a9d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Bessel4Out", " ", "=", " ", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Bessel4", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.502992360554488*^9, 3.502992366472005*^9}, {
  3.508360917011651*^9, 3.50836091825996*^9}, {3.793329197832933*^9, 
  3.79332919819899*^9}},
 FontSize->12,
 CellLabel->
  "In[684]:=",ExpressionUUID->"ec4839ff-c3b0-4342-b7ef-4a9b4ce71ae5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BodePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Butter4", ",", "Bessel4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{".1", ",", "1.2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.502992389063055*^9, 3.5029924009019127`*^9}},
 FontSize->12,
 CellLabel->
  "In[685]:=",ExpressionUUID->"1b462078-f0c5-4f08-9616-a71a7c1c4230"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVV3c0Fv4XpvoiqYySSiVZRbTIaCBJRQkNooSsrIhQylaKiFBoSIVKZlY+
j7333ryv12t7JbPIr99f9zznPPfce8/dO41stW6uYGJiWmJmYvq/fMO6d3p5
mQEv8xhbuqYZqdN1bD69xIBzxzUFM0czsuJL7veQ3wwUJTUd2PnKjJhonnMR
nWHANzW6W4lmRsRe2v49N8LAzwlfb8V75iRlTwrb6yYGpotc7ninWZAijcPb
jsQzEFtWuL/mkhWZefPwr89HBv4kFklKeFkRkanS3tr3DET8zfap/WZFHoVd
iTF+zYClwn2/odXWRKPXRfRJCAMPXj9ps8m3Ji12P/Z3uDGQQX/6TOqYLRkK
UVJ11mJAq47Nr0f2NrGfry/yO8/ASu40u62XbpMlfaMT4eoMdFsdXO/vcJtw
i3gpfldloKrzpcNS4m1yNLNIflqegW1+fs9VxezJ865TUna7GEhYIxmQKORA
jgif4zOfnsAqf6VLV085kpLHPWF3f05gNZuL+r1bjuTChM1Gv4kJbG92et/2
zJGYZjzj/jg0AUsnWqt6uyMJPl3PQeuawKdzBpaitk6Ebq3DbFg8gaO4b7Py
010S/F1v5HLYBFZMTdndOeNKJmInVV+GTIAp7tyuHXdcyZkQ3/cdQRMwLa35
vea1K1lll6Jv8GQCylbjF75OuRKn3ey1Ru4TaKsreLXlzT2iF5WVam05gSZj
7di/q9yIoCefm9exCZTFj1uvWuVOHtglthcpTODpt0Ed023upPOaigyL3ASc
26+4TMq4k1AFO8ajgxM4N8Nk98DSnbDMlN4IFJtAwszmfY8a3cmI2V3Vl9wT
2MMjmPL0qwdJ0WhZ/40+DpO8nwrHvbxIplr3ob/94yhiTdob9M6LkBM0XQ3K
OPbc/6DKmedFKuWm3o92jiOAybjp9ZIXoQmvkxWrH8elJ45tS67ehPfvScN3
OeN4tFaYmeWhD3FNTE8KCRrHw7UcwZaJfsQ9/kczNWAckuZdQdKNfsQ3tvD3
/ifjELkuny0370dCXtWr1PmMQ+/juoEJ5Ufki+94G8e9cQQ2l7zj7XxEeq4J
M/veHEfE97TdX3j9yYn1Ly44y4+Dd87r0fPcpySGn8YTcHgcDXl36/6beEpW
7DnY8u7QOG5a+BVXbA8gBSr1epWS/+zHGw+f9Qggyq5rTbbvGscGMikhfyaQ
KA74OBWtGYdTvthelbFn5EiOUyRn9xiE/D5VvsgOJlFlxQbCHWMQM3lJcW4L
JovNGwTkW8dwyWD0cuBsMMmZTIk1rh/DjvVnCy8cfE7kRRhfvxeP4QRf4siJ
b8+JbLBZnn7iGL6fqpsUTA4hh8yuDMQ9HEPxtdSEi70viOnfLz6M+2M4UKrB
m8scRsJfMIvIuI4hYGVOtJ5QGPldmGBaeGcMNXYh+nKWYSRfYGmw22IMSeLz
i4HzYeRcx7sRbp0xzP28Jzy0I4KYa4wy7ouNgf50+H575CvyinY8qFB4DFoH
pfjTil+Rynuh+9h3jUHtpPXzOsYrIplw9Hb4tjHIyCi8rlOJJDMsQVPJ3GMI
LHdKnv8ZSTzzDs3QF0cxYvE8U1U3mkQffPBbs34UC6sb2O5KvSVi3VtkDWpG
4dGfNLb+7FuS5pvhaFE5Crrl3u5W07ekon1y0qN4FEf+q9kz+/otmX1oPJiS
NQqK+5i+I9c7olml1rQhZhRsrw4eKl1+R1bc5Elssx+FEy12745VsSRgXdIo
zXYUrKNaYooisYQvU333T6tRzD76eiFSLZZIrvGNXW02Cn9d42LmwFhyNXn+
lfzVUXC51Mu+2vqBpC11+0WdGEW4e1qYtvJHYhoWd8Nwwygib8Wp9uXFkUj1
72auXKMosko3Pj8SR+pWFFmHrhtFTxJz28oN8UTetteljG0U2rLan46Zx5O1
arzP9y2NwIBR8o1tQwJJW/AqYKKPYN/cDfYrLp/JCoPru95ljGCz4oeSqw8S
yWEe6905aSNo9t38yjQ5kViVu0o1J49ApPpybwktkbRIhyms/jKCbZ6/Zh6r
fyPx66q1b78dwe6fcvwbOZOIZp68t9LjEZx6IBO5ZyyJvNnFO0DRG4GVnKqF
RlkK+Wi8u3zvlRHoOpmefzOQQr68P/LV5eIIdPp/L2xfmUqydxk7cmmOgLY9
NDfuWCpp2ZX0n9LJEVBoi7TxjFTCIXRG5K3Uv3gEfj55mJpGnIUemF1bNYI4
jxjD3rrv5KFJ8NkE5hE0iOqJuE1//9e/sVKzf4exZTLDW4svg4QIVc4FLAwj
xoDZ4oNhBkkU4nuUOzEMb6Xd1jO/MghNKCWOv30YG90+igUIZxFNYfpwx9dh
UE4/lpHKyCFJd5VujSUM421GqBU/PYdwVkSNLX0ahpH0u026G3+QehtthkDM
MKRY+QYK7vwgWpl506Zhw1h56Zq62eFconM2cnnqwTDeHWiusK4i5MptzY1r
NIfROWv1NYc/n2QWfg7j1xjG+sG0kTS5fMLHy8oneWYYPTU2Mr2X8kl7du6W
CyrDSFptrloWnE/0VokLhMsOY2kd18OZ1QVEP/w/8V07h9EXFzPHuqqQ3MjN
VlSYGkJaWGbTo53FJPTl1rcPGEMQsar1GVcuJiWO95fzx4Yg2KK56GtSTPZI
HiNqg0OQjfnjpxtXTKZe5ytc6hpCmaOJru+BEuLtXiZzu2QIMQt6r89cKCUf
T7RIfHo1hHSbY2rz2eWkbcfhpyPhQ/i6vP3ru/5ywr4YPrr3xRB2ru/WfsJR
QWzSdBPSng1BgswsCVyvIIeFu0ULvIcwHqXAeoO1kpSx0AS7bYZg6rNeNMik
ioyU/+TjOTGEmwIBF77p1JKSlEJFE8Uh6LDvOy/rU0tiIl+Ypx8dQq750H2O
77VEz1ou87LsEP6uX7dNnaOOlHN6XI7aOwT1Xf/xfLCrI3GXOcOE+YZQPy6T
ladYT0wHJHlkxweRf5bfQJepkSjXMCk8HhnEpp3xdWXbGsn2jAajjsFBfDo9
1n1ToZG0PHJKuU8dRFX0gd7ddxvJSQlyIb91EEZ657Uok41EyEEj6EzBIOwj
xrjOjTcRKpPVWoPwQcwa0KIOc7QSvkWfBofQQRyeu680d6CVaMy9CfcPHsTB
9g1r5nVbSeZ4487MJ/8w9U8RiWslAR0KMjzug7CybfltdbqNyKatuV5uPohV
zs3bk8LbSaDZ5yRp+UFsNLLYv+lWFykyKnZUPzyIxniqZs+rLrJg0CtvfGgQ
2fONhTMVXcREh6c4SHIQxc/+y98k0U3klO61jwoOQiXhw8bDU92EtuXsipg1
gzCJXsN5LbCXKNSMaK/rpuNmH6uCuA+FKGuzz13qoCM8YUPmh7cUcqZt96s3
rXRMb9x87uwPCrlCNe/b10CHtINwI980hTjN0q20S+moXkrMK7pJJUnb+30i
kv/xh4Z9oi/0EyHbzgxBXzrSL4vn6WgMEPHp33q3vOhYH38gOddmgBxw2fI3
1Z0OnZ0JbFeDBoiSl67KyXt0aHp+OnioaYBcC2+tM7Ojw0jTKtziGp1EoHH4
ix4dnA7M+8TdBgkHZ9XWw1L0f/dC/ntX+jCx/nRQ/6QEHTU7tTp9uEdIzbHI
KO3ddFQJq893Hhshz6wtt9ntokOy041iGTFCuCvZdsRvokO11Dl05/lRwud7
UnArEx1hPjyOppVjRGiRiC3XDeDpkdT8QOZJ4hMiYrG2ZgA/5/TTSvgnCX1P
YPzWygFsj94wKSE7ST7pGuyRLR7Ag1nxBz62k2RPxh/x21kDiMgzT7btmyT7
7GWl+t8NILV6aIdd5U9ydChZutR+AC/z5an3yn4Rtaf+x/ptB3Ba9f0Wz+Ff
RGuf8allqwHkHM12APs0MXfeoHvYbAB3l+vm+zSmyXO2u/c/XR3Au0Jln/KW
aUIXO1LopzIAAaU5I+9fMyTQokRTjXcAyvJR5YZX50nE2je6JjwDEFJhiVjt
PU/eJ981cuccgMqevydnv8yTzAWxO5nsA5ANMWWJXp4n1MdPwsWWaRjv9Psi
EbdAZBI0e9iGaPDZEvkhh+UP6RnpuFWeRcPzt7FPfy8ukWy+LK1NGTQIvv7+
/JP4XxKuGi53M42G/ocCx6P1/hLNGG1W5m80/E5rPG+S9Zfk61bFyMbS4Jdv
2mHtukxiy3LbPwXSEFg5HWHpwwTLj29P+RrToFjEISp2aAVUmx5INhnS4CRh
EeSmuQK7VhhsFLxGA2uIC8+y1Qp0GWzuz71CQ9HLeBe/jyugsfH5gxkNGtrG
ko3St67EPm+vdBNZGpS1en8WrluF2Rumu06spWE37VNS+mYWSMQ8/XSJnYaq
Qb7jrMdZYERNEbdkpcHTwqM+3IQFNUbLB4OZaUgMD/5yN4kFH4wjVHpn+sFz
3nHNsbOs0LlZcfNeTz+ubFh7WjWADSnmknGp3/ohyOEr6KC6BkNxOhKlX/rh
Y7b1jcedNdg+7JrUEd+PTM/+vu6YNfC3KM1kju0H2wvOAg8mDtywNCw/H9GP
WMXiQB9wgNPq+cioez9UxK91Tauvg63trISQVj8++jbGf2vihJOc4DOL8/0I
NFRkk2Zw4sHKcz8T1fuhuo66j7aaC4HhH9LlTv3zp9B3KO84FxKhc+z8kX5w
ZrQfu/eVC2PrU8+7ivRj9+A1Talgbpgn2drX/abCfJ330uN7G2DnGtm0cZ6K
CTZVm7rIDXBWKZW5OkOFTJdu9ukfG+DXtv3PAIOK+ocPhFuWNuAjU43XHxoV
7rMZe657bQRNU+KFSC0V/OePprhG8MLw51DG/fdUXI/KvSo3zof8av0Mv7dU
uG01jazctBmCCXXfn0dTYXcs4NlH5c0YMMpMjwunIoHR7iv7cjMsm/xSm55Q
8VHzvmvH6S24kyHyTeIOFYPRyf5+WVvxyM3kY5cKFVflXJ4fbdmOYd22D4NK
VByKWaoZZN+BMzLqH6aOUcFL+bk4enwH1jIOxrLJUcFz1yd01ecdeG64MubQ
XirqTPf0FSoLIOpETPTTjVRY6YjN7RPZieTVfaFH6BQoMI/KLHPvwo+pIv2L
/RRspr/Q/H1gF8o644Vs+iiIk5thE9fehZ6vDmlvOiiYfrmcKxm6C+xarE0r
aikQHso+WM4nBKNXkjzlGRQkF4dvi5IQBre4W/DFxxRUKRa6W3iIYtsGI10b
XwouF/CHNcSJQmxJdaefFwUOD38RtzpRHKvlTM50o2BensESJSAGS4fYuq32
FFhenM5ZVSSGgpzK9VQ9CiYz6P6jm/bAXn1LoI0EBVMsv9iuzUngPFYdytpN
wTNXk/0JQnshcYDRvlKUAjUWB6mjWntB31Qk/HInBX6Gu8zlEvdCt986t5CX
AvY3izzhFpJQdM0f42Om4C2nTM/ZCSmsizM/W9jchwM3Hn61f7kfo1u0f65t
7ENOjuSJ+bT9KAs4Gn6lrg9zt65Q4+r2w9OBu3+84h+OzDnzlO0AZo79cOXL
64OT4h85Y9cD6Gpen2Cd0IeSwLaPgaYHkbAyg43vYR/4Zx7rdxpJo+/R8Fmx
+33gdLogLuAnjU3r+J/JuvQhVDniXsxnaXjzeWzUdeiDZPAj5Rsz0jDYe1bw
lVkf3qotLTU8kQHn5V4Ffs0+iKqcEqAXHYZTAqutwM4+sBhVvxi2lMcXKfmU
fdv70BS5J+17uDz606xmFLf2YZ/9SGVtkTw0UX/vxsZ/+lzZo4M7FLC7KfJR
zOo+nNhXKkfaFZD557rKaVovmlbn6TrrH4VPTFLCBd9eXIk/dP+vpiLC8gTG
m9170cDHWdBgqYiPPUFSevd6IaX0baTWWxGlW26nGdn14vN558GTWYpYHbKf
OOj1YrbB5YeokBICvFLqX0j2IjZCLnyJWRkvTNLm21t6YKgnF9DTewIfPYUU
rtX3QOnI6zid5RP4/jbUjVrZg5XmJUGL21XQ2nVnxWheDyKZhVb2X1PB5ovS
HIsJPWBUVu7loagg+uT3Hdsf9mCS1UNCjXESH0QyVY1Ee/B5Y/V7fWk1rL7G
vmWFYA+yL7skj+upwfqF/vg7/h6w971YneWuBulVzKEUrh5s/mm6kqlaDcWU
0xTDxW4I7pYW0jU/jYGoznvX67uxjZ8h5p9wBsI8y0n697pxJoDvYth1DTw+
c8F70bEb5pGty3sCNDDu8f5ylF037O+VGrPkaCB98tTfzpvdoFNy14VsOoeT
NUFnr2p2Q0+SfStn0zncfCxI1xXuhsHovPqDvZr4sHxy6+XaLpw+rWM4WX8B
P66K7fYs78KiKdvET8YFNGWwH/5a2IWa3CAmkXVaWGFXq7Uyswvs12rZRM9q
4VrfFf9vb7vQpKHHG1aqBd78Wwus9l3wCWjxd6zQhq9ncGvmhi5oZAVYF/2+
iOgeh4H+dV246PsjpWTHJaTJX/q1bnUXlPk5VVlPXgJ1asv6m0ud4AhR/aMS
dAnHjGNVueidyJCLO0F2X8bsiYx0i4xOXBLv/sFqcQWm/3WHbNHrhKXt+mA+
/qvY6VhhEK/Ticb/9hQnql5FFy1DVPZ8J+qMj3f53b6KC0XPcy6qdELyI/uV
VWVXccRLrT9IshNDPHLiB5z1wc2cdoB1ZSdsiXxI3oAByKJ//a/PHdBsV/Qy
vm8IFyvnSM+PHVB4sshxOswQh7pu3uR61wFHm/3Kl5MMEZ+juCAZ1oGdC6WJ
EzRDhLrOCli6d4BJeS6WU/MGLOdv2PXpdKBbdmBeT9IIvNOy66uX2kFLMsmd
4DCB96PvPINz7TAQH9DhkTLBFP8hPuapdsy+ZeGwv2CC6pNSO6Xp7XB+YXKz
N+wfP1z4YHRNO251bIC30E1MyXNftn7Tjir/gM06Z01R4zH6eq1SO+r6fqf8
LjfHEV6L96IK7RCJ+Hxg37Q5EhLon5Sk2zE5lu3/dbsFfBopSY6727FQFvLV
444Fjgi3FXRztYP5uvL56F2WSCgron+ltmFS0vwUV9At+K1/LXnOuw0ra2qq
Qj7YQC13qdDrQRtE3rNNV7XZgP2WgW6Wcxv6dbZ9u8phi6cl/N5C1m2As9i2
+3ds8dwtsv33xTYY96bpWgnZIWo0wvuTaBtm7YQNlZhvI6k0pIOpshWhX2p2
M3rscdvxl61McSuqH3rXOv+1x4Fd2v9ZoRWnPi8IHt7ugPQH3PtaU1sh7n/m
oPY1B2RLB/t8jWrFqj9t2dwUBxS9D9ynZ9OK+KoEg+XJO2h7+Ng3lasVicsf
qyWP3sVRpelWdY5WyJiby968cRcxK67vprO0Im3QlLXJ5y6sfA5V8S22wNLQ
Zr9+7V0wPenlekBvgZBXt43ATWeIhUlHq+W0gDsqWbAs0gXOXyip3SYtyMNE
rqTsfXRbq/9393oL9madMhAxuQ9lqYxLnHotmC/XtTUKug+OlKcLyudbsO5S
54v44fv//vDDx+PkWmD6ciHj4Rs3lBUEVNiva8H113faPvM9BF+7HIU1sxla
FvXUjYIe2IdD1hIpzeh7rG64+rgH1D5ILWh+aUYQVT13r74HnG8Lc7162wz1
d8XX2cM90LaaS0nicTO0fxta8q/3RIT80FtNvWbofHjoO8HmBb6oMMOXi00o
UKv/lifsg32ewWO5s00Ytu9543raB2rmT52pk01YZ3itzc7aB86HPIPEB5qw
6KuSxfPdB21V1nm51U24EzvvduyMLyKWVASor5swe+aZpfcDP2y+/qt3j1IT
fgeWt7Zv9kfTlQXRVIUm6NAEV/5V9keQ1rKtgkwTroysZBhZ+YNNdQ2TungT
phYs30zCH3MSuwSsN/7jb1//ScTyCZp/axl+G25ExflNj3UrnyI4LKXv4PNG
yK7ZO9FT+AzqQZliP542IjY1NHhs5hnY/Imdil8jWqa/3BXaEAR3twqmi/cb
4c+xkzanGgRbE6qAk2kj/rNtrvFIDILGAe4bmfKNmFjZQ9f1CcbqmtuUI/0N
uHDclMHQDgEfRTe7r7sBp8YfB5feDoHYtFKId1sDflsb7q1+FgLVLdwnq6ob
8CMlxsq4KgSepilxVzMbENvj0lF4KhSLf6dsXQMakKJYbxx66gUmpe78zTjc
AIE1RWueWIdjWVm/9eqBBqym8S2mBIf/qxOVpGWJBpxbPfec+3s49t7fYHRK
sAGHKl+udl0Oh2VZWnELRwOSrAee/AqNAM1w5ukMpR41jKSdPRUv0RbstPXg
03oECGiHbroZhVflE5JGvvX44ija9jY0CvrMZsrB7vVg2dpl41IUBYrdZQvG
nXoYPS98v0U4GiPnZTM+G9TDNf1ngfhINBbX/tYSkqoHZTrAlMn7DQT83fw3
NtSBg59qLuX2DtT8mWiVqjrs9zPbdfvVO8QuWCc7lNRhqvtGdH/GO+y2uNZW
n10HVi1Pbv1f73BA7bhI4Ps6PNKn/nxvFQMVFuYCFsc6hOz/lN9m/h4Wnt4L
c5vqsCCVIH7U/wNqq1nL/bnrENmydWvD5w+Q3vwkYtvaOtwX/LkrsvoDmJOC
D59YUYfR8/oFFVwfcSDn6Ch/ey36zCs546M+4vlt+/7TnrUwljZzS/jxCVo9
nY3vm2rgUhLLuUMsAdsdqfbl5TWYVVDN7tRMwMiaYS4GqcHE7gOOrS4J8JSb
PS8fX4OmkEvvAqoSkBLKWVXnVoNzzI5ey3c+g/vsyaIlkRrIq5u1ajZ8QX1G
Ytpll2pM9fEoe+d/w6qI5rIQ62qoLjxI5Zn7Bhnnxa7aG9UI62W1fMCbhFey
Z/5TO1ONOxdz5BjqSTDKGrgou7UaVQNvK+ZykjCVzT/Hl1uFsy93DA3GJIOb
+Mt1MFWBM+n6k7thqVB5nazBO1OJF3xSI/YZqXB60HZDa7gS3684aH9oS0XH
MRH/ivpK8LN/S0zamoYY5Hdkx1RCXjXw0a3YNBzIn78XqVIJyoVvXwrz0qFd
ZEr0H1VgyFMo+7NoJqoq358xdKvA36MJokEamVBt7Gsxtq9Ac3Ty9W8OmZCj
6jEs9SvQHe0e+iYvEzuYzgu47KuAZwrflKZBFkYVDnu+aCtHzWFRabWYbHil
sqrWiJWjufHK3T0GuVjMVmmo31aOYnbRHTue5MKpwONaM3c52MU3Er2sXFjU
/3HqWizDsY+XnsbxEpxnMD6N1JUhdjpfNqGJYKt422pWlzIsJARs15bKQ2pM
XPXx8lL8vjN/q6ElH01d8fdcSSmKbLarbJvKxzTv593pqaX4snl0X/DaAhx6
8tVnz+tS5GVNHp5RKcB3h5SjGx1KEeuc9TItvQDZKj++jvCXIuxYZYLqm0IU
0GsDXtiVYET31TmX0GJQBeoV6m6WQOmEaL9hejFWXm0YZr9aAn0TsXiXlmKo
1DaddD9ZgsxURdrxzSUoyWhfstxSgs0ZYnSRdyWoeNRvrVhUDN4s+bLX2aVo
2DOnMbqpGGpSycdP8VbgSiLf7SMcxUh6e+yzslIFevfLhwYwFUMpk+eol1UF
xmTdOqSGizCvaHmvubACLKdWmt3JLkKTl87mCsd/eTZe776kXwRmVaqt9mAV
3keKpqyPKQRHruBfpn99s2fH6WbDsELcVD8ue5S/DkkxlvPJ/v+wXcbB9zJ1
IPFfj+k4FML2UZf5+K06tGUcrIxQKcSdZ6/SPNr+zYGm47SdgwVw8BoSpGbV
4w7HFd5DEgUI7D3EuPimEcoZz5LVdxYg6NlpN5HcRnAalarf5C1Ax7a9EOxs
xJcMGa8wpgIs2HaefbOpCTSjjZPzTflQVyjc+O35vz2Q1VCe65aP0ZJ9364F
N+OQqYbbqdo8qH63WUhPacUKLh8+w6I8rAjkWeHY0oq6nB+pzll5yPpj9tns
dyusuCRG4t/ngSGezRhSbkPsD/bLHM55WGvtlmPU0oYNPGX76gXyIPbtsZgd
awfoD33K0mkEzq4Vy/SQLpwzlx7mqSYw3TTVLVvQhe+aA6vt0wkGF9Pn6ye7
4Lvz5FlJX4KWX26Wnee6IVK4quajKAEXYy3zpXU9MGPxbgy3zEXMKM9Jpche
DD317HGZzEHFiDRz710KNB0PLLe25UAy6ld1dwgFmQbUHTL5OZC+rvyVJYmC
R5LKN6aCc7B3TvVB6xAFYnXMNMuDOVAxT7C5p0+FBY/H8FWnbJyePaO4dLYf
Iy8fTh9dzISHfaXsXY0BvB3MuMI+kAnlzxuG/WwGcEl68kdLdSbSe03WlD0b
QEGdoY/tm0zQBSoetTYM4BWrMu875UysF2R+J3eVjrOOq2RXPc7A594cvyOO
g/ii+fhexcbv+FLnH9NcOwyj1/m9YX/TYb+qr1Blbhh8YwsnjAfTYejkFzey
fQTefpYci5np8Gja8bXTZgT65Gz0Xv10OESEKelyjYJDYh2CYtKQc927as5w
DNasISsuS6WCO+hCgq0EAynv5y6lbE5FV6J2J+sVBmaP639euyoVF//uMGjx
YsDdWVinqC0FnLqd/Ju6GNghesKTPzsFtMN8L/PWTuJ/ZrG01w==
           "]]},
         Annotation[#, "Charting`Private`Tag$420967#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVxXk01AkAB3DESo0kXq62FYWVFaUXkV8X6b1xdpDKYu1IB3I9ZE2FpPMx
lSdnIZKjmWFMYb6yo0xyVqKmJMbxm5kGKccOdvePz/usCwzz+lNJQUHB9T//
n6/629TiogzlnFbvpJNx6DwS/Xb/vAyxtPjz4VFxUCpv4DDmZAgW8NMCEuMQ
5OEWZ/pdhkQrh73uGXEwywpbcCNlKH3tnHTkaRxY5qyleW9kGPzF+bz58njw
Xbf97PBQhmdlx/YLquIxytjlHOslQ+/QXY6XSgLSOb6k952vUGC2m5VsoIPl
2qNRNSyF/271kcdWF7BH47Zn7HYpwvUEKobjF2ET7CMqpUuwqtLPQFstBblb
Euc8usR4JZ5uqNuSCtqd0gB/bTHsJ2qI1LY05BuvFg34kggV6gifFV6Dx4bh
sfcVYwipu+epmH4TAQ1Pd9pPjsIvoaN/3ZV0kIIJXa09ozD67ieY8mXgi8Jp
9eOZI6BbblQ57Hkb9u3kgRUfh1H05ULC9vJMUFa+Mti2aRh6lVMv6/XvYsco
c+uLCBF8KGOm8yq5+ES+PyV4MgSfK3ytUP0C/AigGe9RH4JLCWU8h3cPYWE/
LNZ7DcL6VbZsnFMI/4nR2oTCL8iP1dJb21gMptrnWw7DA9ivaNX0zroUEVT9
G6EWA5iaqjHNF5ahbEntUl36Z5QGz3b451Yg5f7jMs9L/aDOaxzlRj9GsQnX
OdD0E7bKM785bWSheNHJwLtDiHO3U6hBytWgqXxk6Pt+gNA8ddLbgYPVU7Ya
bfN9CDGinjVM5SJVI8/SLbkXn4t2NjTtq0MvPe0SW/MddL63qOe58KDbZzeg
yn2LhUhFWwqzEXq/f+s33/UGP0mkq+KvN0Gt/eyAw2A35gzr/e3i+ehNjzHY
cq0L2W4X3TVvPkfIxeTZaZ1OnG+JoC6sEKCrtrLaO64N4cq+XMuiVhzg03jH
Lr8EdZddSjavHez7pW2E4AXMXDKsiuY60W0+7SrWacaIyVd7WW03oig+q20s
mnB4YW+IbscbDNNTWmqGeFDIee30fqYHZBZ9aoeci+c5NEprRh/OqDKUvDex
YTd7dXPzSSEOWUdt87n2CDuUPaxyjvbjSaSOtqwgH/YzgSFNEQMINjVvtQ9P
wkGj489CXQZRJde40J+cSphdrXxQ6SSCiZEaQ+3yPYLnIBepPxrBo/kHm/4I
LieqD2ed0zQlIUwQ0WSZ5cSNrnYWNpOgyI3zzrWUE9fdE3dHOpI4PVdAufVr
BdG9PSuaPETCcvruGF9cQSyQFpF6KSRY4zcKTcKrCHdGs1bCEImPZ+uWRzsw
ieCorVG0EjFimL6mdQeZxNgpbjefLcaKidndimeYBGtp1yezRjEcw23jr+cy
iWadF8uU+sTID60ZLV5gEvLXNoszyyQIOFXV3NPIInzNwl/+EybBXJnbwJo+
FlHW2OvOSZAgg5TKAydYhGDjraqYNAmaQixsZOvYxJLeYDW1QgmMTzy8r5rE
JmLCMmOieiSoL3HhuWazieH2grV+gxIcHBnpY7DZxF/j0lrXcQmSaSaahkNs
ojJ5TOC4TIo1D5otaHI20TlGc9mpI0W1KMilXLuaUJpp/nvfeimoG5SDJi2q
iQ96k46HrKUQBRXSbZ2qiRb33voTjlL8C7LcrqY=
           "]]},
         Annotation[#, "Charting`Private`Tag$420967#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-1., -1.0033575039155886`},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-1.2, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"-1.2\"", ShowStringCharacters -> False], -1.2, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-1., 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"-1.0\"", ShowStringCharacters -> False], -1., 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-0.8, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"-0.8\"", ShowStringCharacters -> False], -0.8, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-0.6, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"-0.6\"", ShowStringCharacters -> False], -0.6, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-0.4, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"-0.4\"", ShowStringCharacters -> False], -0.4, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-0.2, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"-0.2\"", ShowStringCharacters -> False], -0.2, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-1.2, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.1, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.05, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.95, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.9, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.85, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.8, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.8, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.75, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.7, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.65, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.55, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.45, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.4, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.4, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.35, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.25, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.2, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.2, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.1, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.05, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5016787519577943, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-1.2, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-0.8, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-0.6, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-0.4, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-0.2, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1.2, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.1, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.05, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.95, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.9, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.85, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.8, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.8, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.75, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.7, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.65, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.55, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.45, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.4, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.4, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.35, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.25, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.2, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.2, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.1, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.05, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-1., 0.07918124604762482}, {-1.0033575039155886`, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-1.2, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"-1.2\"", ShowStringCharacters -> False], -1.2, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-1., 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"-1.0\"", ShowStringCharacters -> False], -1., 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-0.8, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"-0.8\"", ShowStringCharacters -> False], -0.8, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-0.6, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"-0.6\"", ShowStringCharacters -> False], -0.6, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-0.4, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"-0.4\"", ShowStringCharacters -> False], -0.4, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-0.2, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"-0.2\"", ShowStringCharacters -> False], -0.2, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-1.2, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.1, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.05, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.95, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.9, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.85, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.8, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.8, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.75, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.7, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.65, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.6, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.6, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.55, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.5, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.45, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.4, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.4, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.35, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.3, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.25, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.2, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.2, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.1, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.05, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.5016787519577943, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAAnwct9P//77//VyhpXvwtwNBZddVJ
/e+/o8K81jwCLsACrL22k/rvv8hSB2wcCC7AZFBOeSf1779GrqsO3xMuwCiZ
b/5O6u+/p5WtOnIrLsCyKrIIntTvv983oWHQWi7AxE03HTyp77+jeDOObbou
wOiTQUZ4Uu+/JKgOozh9L8CRtlrqV5buv9Rmyjo1mjDAsk3WD6/m7b/kbQCa
HnIxwEMPlVF4Ou2/GtzIhYZQMsA0Z1jlqH/sv9rmnD5vTjPAnTN++lDR678C
f4pE6Uc0wGaWqGFgFOu/BocgT6tkNcCfIxbl4VrqvxjEvK+bizbAUCXm6dqt
6b9WvQRPOK03wGG9ukA78ui/HdhLNfX3OMDqyfEYE0Povxrqm/pCPTrA4gBs
DV2X578imd+7h4w7wDvO6lMO3ea/uASIgKULPcAMEMwbNy/mv1DInW9OhD7A
PeixNcdy5b8rLblxXRlAwN7q2mvJueS/azHVMIH4QMD2YWYjQw3kv/Bwc8/U
00HAb2/2LCRS47+S/jygs85CwGDx6Ld8o+K/P8xtiMnFQ8CxCeCUPObhv4BF
vhyC4ETAckwajm4s4b8K/1WfOQZGwKoDtwgYf+C/39/UQJsnR8CForCqUYbf
v/DY5+9Ac0jApSa4RmIn3r8EfcgW27pJwKX/RRtXz9y/PQkdlgkOS8BmBd2T
GlrbvyVDzMChk0zAFvQ4D8392b94Wd8CCRVOwIcPni5OhNi/gpFfN3rQT8DY
f4mGsxHXv5oMLQcK0FDAGNk54Qe41b89jcaE+7VRwBlf898qQdS/NULvPby/
UsAJznHhPOPSvw41KFmxyFPA2JF2GzOM0b+LUoHb3N1UwGmChPn3F9C/+oaj
IzogVsDRt660V3nNv/fd9dqHY1fAU8RmvlyIyr/5/WsIft1YwLOiqM0/yce/
8TKJ3ERbWsDSKvdN6xfFvwk7KPK171vAdAxYFjQswr9xlWZ2wMtdwOZ/hci1
5L6/Si779T6uX8DqmX/0Pfy4vyHO84Sr8mDAbQeTAlcvs7/nxS6Sth9iwFUx
dDdYjKu/W+QfgY1LY8C5cxcU76CfvzmocebWoWTAZycqyztwg79I30PVB+xl
wK/8D4HfhIc/blyjbvgyZ8AmIgmTCYihP5ZtDE4nkWjAq/2mL2NnrD9MUr6g
w8xpwNx85Wbvl6w/O14S7yPSacAM/COee8isP8H9HP6C12nAbPqgDJQprT9I
XAhZPeJpwC73munE660/dXPM3aL3acCy8I6jJnCvP4cOOwowImrA3XG7C3U8
sT8h3gDQSnZqwHaxWie7VLE/O3sM4IB7asAO8flCAW2xPw6nd4y1gGrAPnA4
eo2dsT+Fk7S2GotqwJ9uteil/rE//ARsN9SfasBha6/F1sCyP2yG5ygDyWrA
+qpO4RzZsj9UX6mVIs5qwJLq7fxi8bI/Sa5KkUDTasDCaSw07yGzPxA6NDJ4
3WrAI2ipogeDsz/sW4IG1vFqwLynSL5Nm7M/9I0K1un2asBU5+fZk7OzP7bj
zi78+2rAhGYmESDksz+Q/XB5HAZrwBymxSxm/LM/D1sIaioLa8C05WRIrBS0
PxQJT+E2EGvATCUEZPIstD+U3qjeQRVrwOVko384RbQ/6n18YUsaa8AjhYvd

           "]]},
         Annotation[#, "Charting`Private`Tag$421460#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAAnwct9P//77/WyQKPFusWwNBZddVJ
/e+/YYj7q4/vFsACrL22k/rvv/nWc6gJ9BbAZFBOeSf17787qZFAAP0WwCiZ
b/5O6u+/KaFJ8vcOF8CyKrIIntTvvw7fAoIRMxfAxE03HTyp778rHx2H7nsX
wOiTQUZ4Uu+/XTly6FkQGMCRtlrqV5buv7E8NGndXhnAsk3WD6/m7b9LZ9ob
l6cawEMPlVF4Ou2/9Qs0eAP6G8A0Z1jlqH/sv2ckbi0gfB3AnTN++lDR67+c
smsLOvcewGaWqGFgFOu/uBzAIMxTIMCfIxbl4Vrqv4ZjJm2BMyHAUCXm6dqt
6b8HTviB9Q4iwGG9ukA78ui/SWSQTk0JI8DqyfEYE0Povw7sqUg7/yPA4gBs
DV2X57+yzgu9XfwkwDvO6lMO3ea/wMCpRzIdJsAMEMwbNy/mv76hNO+vOCfA
PeixNcdy5b/eHJqaCXwowN7q2mvJueS/Uw6295PKKcD2YWYjQw3kv1ckaCql
EivAb2/2LCRS47+x8nMC7IgswGDx6Ld8o+K/bl78aXr4LcCxCeCUPObhv6ZZ
KYWomy/Ackwajm4s4b91P8tLvaYwwKoDtwgYf+C/nwJxiJF7McCForCqUYbf
v5l8ZoxXbjLApSa4RmIn3r/1QTBr4lwzwKX/RRtXz9y/9UfYFXJSNMBmBd2T
Glrbv2vteI6eajXAFvQ4D8392b8KB8moq302wIcPni5OhNi/l7rs6WC3N8DY
f4mGsxHXv2A9KD37+zjAGNk54Qe41b/SlFWcXjo6wBlf898qQdS/4MKJsZWl
O8AJznHhPOPSvzo3yfNZCj3A2JF2GzOM0b8WEbjPink+wGmChPn3F9C/Yx3E
X0MOQMDRt660V3nNv8uGkSvb20DAU8RmvlyIyr8j/Hf7XMZBwLOiqM0/yce/
kAOyjdSsQsDSKvdN6xfFvypKqnsbmkPAdAxYFjQswr/eE8J10KhEwOZ/hci1
5L6/1RlIP6CyRcDqmX/0Pfy4v+AYCY/H4UbAbQeTAlcvs7/vwpUdfxtIwFUx
dDdYjKu/rdt700RPScC5cxcU76Cfv4H2oNJZrkrAZycqyztwg79eGWeuQwdM
wK/8D4HfhIc/V8+dX0pqTcAmIgmTCYihPyjo2kxb/07Aq/2mL2NnrD9/acrM
eEZQwNx85Wbvl6w/qBz5rwZKUMAM/COee8isP+cIlFmVTVDAbPqgDJQprT/G
kbkAtVRQwC73munE660/g1Zyo/1iUMCy8I6jJnCvP91ELWC0f1DA3XG7C3U8
sT+a8A3luLlQwHaxWie7VLE//ec16V+9UMAO8flCAW2xP7L0MbkHwVDAPnA4
eo2dsT9bcFW9WchQwJ9uteil/rE/0asVWwfXUMBha6/F1sCyP0Xp8xKJ9FDA
+qpO4RzZsj8gL/ToPPhQwJLq7fxi8bI//ciIjfH7UMDCaSw07yGzP1EmIENd
A1HAI2ipogeDsz+ijuFkPhJRwLynSL5Nm7M/sEJetPgVUcBU5+fZk7OzP5h5
0tOzGVHAhGYmESDksz/aoVODLCFRwBymxSxm/LM/c8C5E+okUcC05WRIrBS0
P2G8yXSoKFHATCUEZPIstD+IQLCmZyxRwOVko384RbQ/5v+ZqScwUcB8e4lL

           "]]},
         Annotation[#, "Charting`Private`Tag$421460#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-1., -216.821701758526},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-250., 
           FormBox[
            RowBox[{"-", "250"}], TraditionalForm]}, {-200., 
           FormBox[
            RowBox[{"-", "200"}], TraditionalForm]}, {-150., 
           FormBox[
            RowBox[{"-", "150"}], TraditionalForm]}, {-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {-50., 
           FormBox[
            RowBox[{"-", "50"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-250., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-230., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-210., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-190., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-170., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-130., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-110., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-108.410850879263, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-250., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-250., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-230., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-210., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-190., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-170., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-130., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-110., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-1., 0.07918124604762482}, {-216.821701758526, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-250., 
          FormBox[
           RowBox[{"-", "250"}], TraditionalForm]}, {-200., 
          FormBox[
           RowBox[{"-", "200"}], TraditionalForm]}, {-150., 
          FormBox[
           RowBox[{"-", "150"}], TraditionalForm]}, {-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {-50., 
          FormBox[
           RowBox[{"-", "50"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-250., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-240., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-230., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-220., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-210., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-190., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-180., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-170., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-160., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-150., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-150., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-140., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-130., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-120., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-110., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-90., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-108.410850879263, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.5029923925710363`*^9, 3.502992401936179*^9}, 
   3.50836083138957*^9, 3.5083609482494183`*^9, 3.524798889750822*^9, 
   3.524798927074012*^9, 3.524798957419135*^9, 3.524799086236628*^9, 
   3.525574634480154*^9, 3.793329209804204*^9, 3.7933292945480947`*^9, 
   3.793893028792045*^9, 3.8232246439551764`*^9},
 FontSize->12,
 CellLabel->
  "Out[685]=",ExpressionUUID->"2de58417-eb4c-4c16-b533-3060decf4f04"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Butter4Out", ",", "Bessel4Out"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "15"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5029925935959883`*^9, 3.502992596460896*^9}},
 FontSize->12,
 CellLabel->
  "In[686]:=",ExpressionUUID->"4255a647-974c-4711-9613-e0879a747922"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, {}, 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVjH1YywkAx39l1dSJtMJYXsup2w0RUff95QlHKEWKK6+9IkV5qdT04grn
JUnkJYWVHEJZEnnG7iKlerhIVLpaWvv9tK2trW3X/fF5Ps/nn8/UbXt8Q4wJ
gtgwzP9eF76lh5Uqh7C8vNKmqAvZpr+IeOfkOCAM+/qnqAsp+0oXxBXJEezB
K/7S1oVqt5fa51Vy7E0vc+4junGneGG0WYMcubZdiyo53XjhmXjC5185zm+Y
X/phcTdiOReiLvyuwPxgIdPFXoJjwk/HOvIUeOwWWB7pIUG+3xSB0z0FZggc
X4QFSVCbKfhS1axAS8Z918fZEswYKPPpmKXEirDJokqiB011jXOdapVY9Sx/
F6uuB5IIW+/YNiXWCrvrqrp6oGds3FmlUOJEd10119ADx8Xthd6cAfAGw923
8r4hRUCxYqMGkLrwU6btH98wl/+D6skYFVaF3BM+d+/FrxN9rE3tVShxqoh9
79uL4PKzPG9XFUwiXhy8H9aLY1J2ePtWFXabsZuqT/eiI2DWB5MHKuhFG84t
autF1pxllWvWqyF705okjpWC1xK43D1cjZv5/a9d0qWoTdvd5JSgxhRx6ZiD
56Qwbc7uZV5TQy294B5VJkVC0teJIqka8bL0jJ/lUux4zU9ckDaIjeKdq7mh
fTCKy2Y6nB9EACNoxct9fbhiV5TNujWIn7iMgjlH+tAcU3/7e/0gOvu3bM3I
68Pq8XatJRM1cKnMY86v64NLSKX7lAcahNtKBC+cZGiyrK+xFGsQvTS/s9pF
hmhhx3pdswY5PvOKz3nIcMvCPOqjXoNVeaLuGn8ZJt8PuJK9UotTFXumhSTL
8GTTLsfUIC3ydPdSuJkybDThl8dEa1GedOve2ywZsgMEdWtytAj/TF4tuiED
06DUMzu0OG+Sp75ZI8ONopHHVQotnvZrlasbZVjiyxnXZTaEq84F7MaPMiTe
8OSJuEPYt+KI+b5eGWivs5sPHxrCk7Wy9skWFD7kzq7+PkaH1MviknBPCheb
Skbvt9dhv+FOXJYXhY2WMzdrXHVwSOzW5fpS+JTK0Rtv1+F1vP6t+xYKbVHm
bqwyHR40l875fojCteL047k1OizeFHnFgk9hWyfRMumzDqWszHcmRyl0BqoO
2ZvpccfioX3eGQoSz85HLoF62AlWNfkJKBQnbzar3K2Hb+F09oHbFCIff/RH
ih4ne20dD5dSkPIalMtL9LA26O2cKynQ7KfOgTo9CgpzLvm8oVC63jW11cqA
1oteUdkNFPaefti41cEAUl7fX/WOgsKkJCbS2wBZ094jolYKavr83YRrBsxs
HZlbIKVQ4WRtMJQZ4FRg3cWhKcSHnlyT9sqAoy9dyo7IKQy1pPWdkBuwKPHS
PIaGQrAF/wqTQZDaU4eypusoPCtyF6+0JEj7tT6htgQN/lehTf00gkxfmmFj
MKbRxt/vbsUlyBM5XonbGTQ87OaF+C0gyM/iPfFVJjSMA+8+/MeLIPl/Kzp8
mTTS6m74tcUSZOdlxy9mo2h07tyeMC2ZINcR3MMcSxpLR04t3JE5/B9iqGaN
pmHqealfcpkgB6/ms3+0ohHaHsh2KiJIqbLeij2Wxl9J45bsvk+QK1klySOs
aWRUZJ35LibI+M+P/KtYNCT+PhXODQR55ovI/KQNjRWKUe1xLQQpCeK99rel
Yc7LnK2hCPJlDEY0jKMRWbsswE1DkP43OaKU8TReRTD4SQwjcuj9m8ncCTSO
X0+uN55gRCbO3eW2i01j5byIsTbTjUjTQPkF/XA3XrdCEdeIVOt+452ZSEPs
55brusCIFHpZFo+eRMPBo4dTAyPSN2fNQMJw/wcW0cHl
       "]], 
      LineBox[{{5.789949754826773, 0.9999922770068128}, {5.794348506210602, 
       0.9999923132947566}, {5.803609035439714, 0.9999923931211943}, {
       5.808626266091121, 0.9999924382396308}, {5.813643496742527, 
       0.9999924846195698}, {5.816402973600804, 0.9999925106516083}, {
       5.817857970489715, 0.9999925245240562}}]},
     Annotation[#, "Charting`Private`Tag$422157#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{1.219502364756882, 0.7080181757243826},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.5029926068850183`*^9, 3.50836084064821*^9, 
  3.508360948488077*^9, 3.524798889904416*^9, 3.524798927263874*^9, 
  3.524798957620653*^9, 3.524799086491716*^9, 3.525574634716208*^9, 
  3.793329212455284*^9, 3.793329294671101*^9, 3.793893028908463*^9, 
  3.8232246440488443`*^9},
 FontSize->12,
 CellLabel->
  "Out[686]=",ExpressionUUID->"19d80a58-abae-4261-8a4e-2ac90e19b2aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Butter2Mag", " ", "=", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["s", "2"], "+", 
     RowBox[{"2", " ", "\[Zeta]", " ", "s"}], "+", "1"}]], " ", "/.", " ", 
   RowBox[{"s", "\[Rule]", 
    RowBox[{"I", " ", "\[Omega]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.502994896113306*^9, 3.502995003393244*^9}, {
  3.502995096917544*^9, 3.502995134388039*^9}, {3.5029954192985487`*^9, 
  3.5029954236059017`*^9}, {3.5029981378202343`*^9, 3.502998163087336*^9}},
 FontSize->12,
 CellLabel->
  "In[687]:=",ExpressionUUID->"48edb513-d32d-4969-aa50-0125399c7d94"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Zeta]", " ", "\[Omega]"}], "-", 
   
   SuperscriptBox["\[Omega]", "2"]}]]], "Output",
 CellChangeTimes->{3.502998177206274*^9, 3.5083608407094707`*^9, 
  3.508360948530468*^9, 3.524798889950417*^9, 3.524798927319868*^9, 
  3.524798957724679*^9, 3.524799086525259*^9, 3.5255746348137627`*^9, 
  3.7933292946794558`*^9, 3.793893028916938*^9, 3.82322464405527*^9},
 FontSize->12,
 CellLabel->
  "Out[687]=",ExpressionUUID->"0a3633b5-f2b5-48a6-8d1c-39f3503c3774"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", "Butter2Mag", "]"}]], "Input",
 CellChangeTimes->{{3.502995428995322*^9, 3.502995432918105*^9}, {
  3.502995519641938*^9, 3.502995538182222*^9}, {3.5029957099837112`*^9, 
  3.502995717489552*^9}, {3.5029957570442867`*^9, 3.502995757569848*^9}},
 FontSize->12,
 CellLabel->
  "In[688]:=",ExpressionUUID->"19ebd51f-1688-4953-98a5-1eeb909408d5"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "-", 
   SuperscriptBox[
    RowBox[{"Conjugate", "[", "\[Omega]", "]"}], "2"], "-", 
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    RowBox[{"Conjugate", "[", 
     RowBox[{"\[Zeta]", " ", "\[Omega]"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{
  3.502995433408882*^9, {3.502995529485968*^9, 3.502995540140896*^9}, 
   3.5029957181034203`*^9, 3.502995758456501*^9, 3.502998141547906*^9, 
   3.502998185242597*^9, 3.5083608407484007`*^9, 3.50836094858539*^9, 
   3.5247988899972982`*^9, 3.524798927351169*^9, 3.524798957781192*^9, 
   3.524799086583153*^9, 3.525574634859975*^9, 3.7933292947166777`*^9, 
   3.793893028941431*^9, 3.823224644076643*^9},
 FontSize->12,
 CellLabel->
  "Out[688]=",ExpressionUUID->"80fa4aae-f42c-4640-a55c-d79e2b6f36ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Butter2Mag", ".", 
    RowBox[{"Conjugate", "[", "Butter2Mag", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", " ", "0", ",", " ", "3"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5029950335929117`*^9, 3.502995046030653*^9}, {
  3.5029956858289013`*^9, 3.502995687577115*^9}, {3.5029982120452557`*^9, 
  3.502998219722732*^9}},
 FontSize->12,
 CellLabel->
  "In[689]:=",ExpressionUUID->"4e5fe18f-8e2c-44fe-b1f3-49bd56e8cf0c"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Zeta]", " ", "\[Omega]"}], "-", 
    SuperscriptBox["\[Omega]", "2"]}]], ".", 
  FractionBox["1", 
   RowBox[{"1", "-", 
    SuperscriptBox[
     RowBox[{"Conjugate", "[", "\[Omega]", "]"}], "2"], "-", 
    RowBox[{"2", " ", "\[ImaginaryI]", " ", 
     RowBox[{"Conjugate", "[", 
      RowBox[{"\[Zeta]", " ", "\[Omega]"}], "]"}]}]}]]}]], "Output",
 CellChangeTimes->{
  3.5029948492904263`*^9, 3.502995055189662*^9, {3.502995666536297*^9, 
   3.5029956881113787`*^9}, 3.502998189785562*^9, 3.502998220815596*^9, 
   3.5083608407791862`*^9, 3.5083609486370583`*^9, 3.5247988900534687`*^9, 
   3.524798927405189*^9, 3.524798957829373*^9, 3.524799086629126*^9, 
   3.5255746350464993`*^9, 3.7933292947244997`*^9, 3.793893028947321*^9, 
   3.8232246440817947`*^9},
 FontSize->12,
 CellLabel->
  "Out[689]=",ExpressionUUID->"f9864cf4-f746-4172-a0fc-be4046dbef3c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Phi", " ", "=", " ", 
  RowBox[{"ArcTan", "[", 
   FractionBox[
    RowBox[{"2", "\[Zeta]", " ", "\[Omega]"}], 
    RowBox[{"1", "-", 
     SuperscriptBox["\[Omega]", "2"]}]], "]"}]}]], "Input",
 CellChangeTimes->{{3.502997065145252*^9, 3.502997125043335*^9}, 
   3.502997163640861*^9, {3.502997639841628*^9, 3.502997640566581*^9}},
 FontSize->12,
 CellLabel->
  "In[690]:=",ExpressionUUID->"09d81394-ca6d-4bbd-b61a-cc043b09bb79"],

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  FractionBox[
   RowBox[{"2", " ", "\[Zeta]", " ", "\[Omega]"}], 
   RowBox[{"1", "-", 
    SuperscriptBox["\[Omega]", "2"]}]], "]"}]], "Output",
 CellChangeTimes->{{3.502997164930357*^9, 3.502997172896999*^9}, {
   3.5029976417613087`*^9, 3.502997659888645*^9}, 3.508360840816002*^9, 
   3.5083609486827307`*^9, 3.524798890086597*^9, 3.52479892743918*^9, 
   3.5247989578841143`*^9, 3.524799086679327*^9, 3.5255746351327887`*^9, 
   3.793329294760928*^9, 3.793893028970655*^9, 3.823224644102665*^9},
 FontSize->12,
 CellLabel->
  "Out[690]=",ExpressionUUID->"0946ad29-9605-4198-b618-6cf2db10ad30"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"Phi", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", " ", "0", ",", " ", "3"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.502997182641415*^9, 3.502997192925313*^9}, {
  3.502997406070262*^9, 3.502997436417787*^9}, {3.5029975157772913`*^9, 
  3.502997592208424*^9}, {3.502997676902705*^9, 3.50299767945471*^9}},
 FontSize->12,
 CellLabel->
  "In[691]:=",ExpressionUUID->"0ce1d304-7a9a-4627-96e4-9bf7f381f5f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"2", " ", "\[Zeta]", " ", "\[Omega]"}], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "\[Zeta]"}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["\[Zeta]", "3"]}]}], ")"}], " ", 
    SuperscriptBox["\[Omega]", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Omega]", "]"}], "4"],
    SeriesData[$CellContext`\[Omega], 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Omega], 0, {
   2 $CellContext`\[Zeta], 0, 
    Rational[1, 3] (6 $CellContext`\[Zeta] - 8 $CellContext`\[Zeta]^3)}, 1, 4,
    1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.5029971939146976`*^9, {3.502997420199225*^9, 3.502997438264065*^9}, {
   3.502997518388627*^9, 3.5029975242598267`*^9}, {3.502997579460285*^9, 
   3.502997594052987*^9}, {3.502997645697153*^9, 3.5029976805007343`*^9}, 
   3.5083608408865843`*^9, 3.5083609487199087`*^9, 3.524798890155657*^9, 
   3.524798927489666*^9, 3.5247989579274817`*^9, 3.5247990867276773`*^9, 
   3.525574635214251*^9, 3.793329294797637*^9, 3.793893028977426*^9, 
   3.8232246441095247`*^9},
 FontSize->12,
 CellLabel->
  "Out[691]=",ExpressionUUID->"496703e4-9a21-4af1-81a5-6a09dbc4900c"]
}, Open  ]],

Cell["Better way to look at group delay ", "Text",
 CellChangeTimes->{{3.508515654242038*^9, 3.508515668326888*^9}, 
   3.793893003192875*^9},
 FontSize->14,
 Background->GrayLevel[
  0.85],ExpressionUUID->"dcfea65a-49d5-4b48-880d-bb44910b994f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n0", " ", "=", " ", "3"}], ";", " ", 
  RowBox[{"b3a", " ", "=", 
   FractionBox[
    RowBox[{"b", "[", 
     RowBox[{"n0", ",", "0"}], "]"}], 
    RowBox[{
     SubsuperscriptBox["\[Sum]", 
      RowBox[{"i", "=", "0"}], "n0"], 
     RowBox[{
      RowBox[{"b", "[", 
       RowBox[{"n0", ",", "i"}], "]"}], 
      SuperscriptBox["s", "i"]}]}]], "   ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"transfer", " ", "function", " ", 
      RowBox[{"(", 
       RowBox[{"not", " ", "formal"}], ")"}], " ", "n"}], "=", 
     RowBox[{"3", " ", "Bessel"}]}], " ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.508515685163622*^9, 3.50851570265031*^9}},
 FontSize->12,
 CellLabel->
  "In[692]:=",ExpressionUUID->"5adf5766-0191-4e36-8b90-a69ecdddf07f"],

Cell[BoxData[
 FractionBox[
  RowBox[{"b", "[", 
   RowBox[{"3", ",", "0"}], "]"}], 
  RowBox[{
   RowBox[{"b", "[", 
    RowBox[{"3", ",", "0"}], "]"}], "+", 
   RowBox[{"s", " ", 
    RowBox[{"b", "[", 
     RowBox[{"3", ",", "1"}], "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["s", "2"], " ", 
    RowBox[{"b", "[", 
     RowBox[{"3", ",", "2"}], "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["s", "3"], " ", 
    RowBox[{"b", "[", 
     RowBox[{"3", ",", "3"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{3.5085157034515543`*^9, 3.5247988901877213`*^9, 
  3.524798927540441*^9, 3.5247989579829617`*^9, 3.5247990867833357`*^9, 
  3.525574635393341*^9, 3.793329294806602*^9, 3.793893028982934*^9, 
  3.823224644115656*^9},
 FontSize->12,
 CellLabel->
  "Out[692]=",ExpressionUUID->"07281373-68da-4bc5-bc22-e7293c5ea3a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b3", " ", "=", " ", 
  RowBox[{"b3a", " ", "/.", " ", 
   RowBox[{"s", "\[Rule]", " ", 
    RowBox[{"I", " ", "\[Omega]", "   ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"substitute", " ", "s"}], "=", 
       RowBox[{"i\[Omega]", " ", "for", " ", "frequency", " ", "response"}]}],
       " ", "*)"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.508515711465953*^9, 3.508515730809792*^9}},
 FontSize->12,
 CellLabel->
  "In[693]:=",ExpressionUUID->"badce37f-f844-4f87-8cbe-eab2193605a7"],

Cell[BoxData[
 FractionBox[
  RowBox[{"b", "[", 
   RowBox[{"3", ",", "0"}], "]"}], 
  RowBox[{
   RowBox[{"b", "[", 
    RowBox[{"3", ",", "0"}], "]"}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
    RowBox[{"b", "[", 
     RowBox[{"3", ",", "1"}], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["\[Omega]", "2"], " ", 
    RowBox[{"b", "[", 
     RowBox[{"3", ",", "2"}], "]"}]}], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[Omega]", "3"], " ", 
    RowBox[{"b", "[", 
     RowBox[{"3", ",", "3"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{3.508515731371147*^9, 3.5247988902164993`*^9, 
  3.5247989275884523`*^9, 3.5247989580308933`*^9, 3.524799086829994*^9, 
  3.525574635451004*^9, 3.7933292948436937`*^9, 3.7938930289884644`*^9, 
  3.823224644120617*^9},
 FontSize->12,
 CellLabel->
  "Out[693]=",ExpressionUUID->"8012754a-c6c1-44d3-96ff-0fa7a697ed08"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Phi]3", " ", "=", 
   RowBox[{
    RowBox[{"ArcTan", "[", " ", 
     FractionBox[
      RowBox[{
       RowBox[{"Refine", "[", 
        RowBox[{
         RowBox[{"Im", "[", " ", 
          RowBox[{"ComplexExpand", "[", "b3", "]"}], "]"}], ",", 
         RowBox[{"Element", "[", 
          RowBox[{"\[Omega]", ",", "Reals"}], "]"}]}], "]"}], " "}], 
      RowBox[{"Refine", "[", 
       RowBox[{
        RowBox[{"Re", "[", " ", 
         RowBox[{"ComplexExpand", "[", "b3", "]"}], "]"}], ",", 
        RowBox[{"Element", "[", 
         RowBox[{"\[Omega]", ",", "Reals"}], "]"}]}], "]"}]], "]"}], "//", 
    " ", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"to", " ", "get", " ", "Im", " ", "and", " ", 
       RowBox[{"Re", " ", "--"}]}], ">", " ", 
      RowBox[{
      "have", " ", "to", " ", "tell", " ", "Mathematica", " ", "\[Omega]", 
       " ", "is", " ", "real"}]}], "..."}], "."}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.5085157496295757`*^9, 3.5085157729462757`*^9}, {
  3.7933293119050837`*^9, 3.793329329470784*^9}},
 FontSize->12,
 CellLabel->
  "In[694]:=",ExpressionUUID->"edfddc3b-96de-4c56-a15c-9a980318f44f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"d3", " ", "=", " ", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"D", "[", 
       RowBox[{"\[Phi]3", ",", "\[Omega]"}], "]"}]}], "  ", "//", " ", 
     "Simplify"}]}], ";"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"this", " ", "is", " ", "the", " ", "group", " ", "delay"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.508515780713026*^9, 3.5085157898096733`*^9}, 
   3.793329335300467*^9},
 FontSize->12,
 CellLabel->
  "In[695]:=",ExpressionUUID->"9d89fd23-6336-447e-b451-8caaf8078e12"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Tau]3", " ", "=", " ", 
    RowBox[{"Series", "[", 
     RowBox[{"d3", ",", 
      RowBox[{"{", 
       RowBox[{"\[Omega]", ",", "0", ",", "9"}], "}"}]}], "]"}]}], "  ", 
   ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
   "now", " ", "expand", " ", "to", " ", "lowest", " ", "order", " ", "to", 
    " ", "see", " ", "\"\<flat\>\"", " ", "property"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.508515800195737*^9, 3.5085158143789263`*^9}, {
  3.7933293501200027`*^9, 3.793329351116191*^9}},
 FontSize->12,
 CellLabel->
  "In[696]:=",ExpressionUUID->"9662eb3f-653a-4741-9ca1-82bb37beac27"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n0", " ", "=", " ", "3"}], ";", " ", 
  RowBox[{"b3a", " ", "=", 
   FractionBox[
    RowBox[{"b", "[", 
     RowBox[{"n0", ",", "0"}], "]"}], 
    RowBox[{
     SubsuperscriptBox["\[Sum]", 
      RowBox[{"i", "=", "0"}], "n0"], 
     RowBox[{
      RowBox[{"b", "[", 
       RowBox[{"n0", ",", "i"}], "]"}], 
      SuperscriptBox["s", "i"]}]}]]}]}]], "Input",
 FontSize->12,
 CellLabel->
  "In[697]:=",ExpressionUUID->"93daa6aa-1774-45ef-b7b1-213677cb425d"],

Cell[BoxData[
 FractionBox[
  RowBox[{"b", "[", 
   RowBox[{"3", ",", "0"}], "]"}], 
  RowBox[{
   RowBox[{"b", "[", 
    RowBox[{"3", ",", "0"}], "]"}], "+", 
   RowBox[{"s", " ", 
    RowBox[{"b", "[", 
     RowBox[{"3", ",", "1"}], "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["s", "2"], " ", 
    RowBox[{"b", "[", 
     RowBox[{"3", ",", "2"}], "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["s", "3"], " ", 
    RowBox[{"b", "[", 
     RowBox[{"3", ",", "3"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{{3.5247990683443937`*^9, 3.524799087665264*^9}, 
   3.5255746395029783`*^9, 3.7933292958542833`*^9, 3.793893029821343*^9, 
   3.823224644939427*^9},
 FontSize->12,
 CellLabel->
  "Out[697]=",ExpressionUUID->"0cf573cf-c553-42cf-9053-74213e1f6c36"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 652},
WindowMargins->{{Automatic, 223}, {Automatic, 58}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"4a128b4b-ee8f-48ad-9384-f21eacf214bb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[422, 15, 609, 12, 81, "Section",ExpressionUUID->"a33e541d-973a-451a-b479-e7399703c180"],
Cell[1034, 29, 1778, 54, 136, "Input",ExpressionUUID->"25e8f12b-dce3-4d8f-b528-397508dda42e"],
Cell[CellGroupData[{
Cell[2837, 87, 259, 7, 29, "Input",ExpressionUUID->"118e6897-c569-4503-89d5-2a1ed4dcca44"],
Cell[3099, 96, 3408, 74, 65, "Output",ExpressionUUID->"6b4591a7-ad4e-4bbc-ad9a-cb1b8e0d7a1b"]
}, Open  ]],
Cell[6522, 173, 456, 14, 52, "Text",ExpressionUUID->"b753f9f7-e0b9-4b83-9c06-5ab786317ea5"],
Cell[CellGroupData[{
Cell[7003, 191, 335, 8, 29, "Input",ExpressionUUID->"8ff01cfa-8e11-4e6d-a396-d47cab2c47dc"],
Cell[7341, 201, 3073, 71, 61, "Output",ExpressionUUID->"9e22afc4-2d1e-44fe-981d-81d792ff6b0b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10451, 277, 350, 8, 29, "Input",ExpressionUUID->"e43fc46d-1d10-4e2c-9529-654f4977ac60"],
Cell[10804, 287, 1080, 30, 56, "Output",ExpressionUUID->"9a0f01f2-5ecf-4fc5-b11e-3ddfb57db52a"]
}, Open  ]],
Cell[11899, 320, 334, 10, 52, "Text",ExpressionUUID->"a9296aa9-eb66-4547-a183-2be6b2b66c8b"],
Cell[12236, 332, 584, 17, 45, "Input",ExpressionUUID->"514c8a06-b014-4430-834b-ced0fc563594"],
Cell[12823, 351, 617, 14, 29, "Input",ExpressionUUID->"4056db4c-9b03-49fc-9dc3-6094df1c901a"],
Cell[13443, 367, 244, 3, 31, "Text",ExpressionUUID->"864c9687-6051-4a9d-9641-1ab603dd43a7"],
Cell[CellGroupData[{
Cell[13712, 374, 414, 11, 29, "Input",ExpressionUUID->"5b88da9e-845d-4ee9-84d3-c1fc1e33327d"],
Cell[14129, 387, 55374, 1084, 247, "Output",ExpressionUUID->"92fc119c-f399-41c3-bdeb-323b6d2b8be1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69540, 1476, 421, 11, 29, "Input",ExpressionUUID->"4619cefd-6587-4c67-9f90-f6fd08d0a692"],
Cell[69964, 1489, 26584, 459, 239, "Output",ExpressionUUID->"f72c1d9a-dd04-490f-9518-83e4293060db"]
}, Open  ]],
Cell[96563, 1951, 304, 6, 49, "Text",ExpressionUUID->"ad973ef1-6e75-442d-9935-e1afc9988c26"],
Cell[CellGroupData[{
Cell[96892, 1961, 286, 7, 29, "Input",ExpressionUUID->"d68ce8b6-1f6a-4091-b005-23e38c68d3c2"],
Cell[97181, 1970, 2888, 65, 60, "Output",ExpressionUUID->"18121d02-a180-472e-8712-90d2745ecc0b"]
}, Open  ]],
Cell[100084, 2038, 530, 15, 51, "Input",ExpressionUUID->"045c14e9-7d2e-41fd-a529-2a508d205cf9"],
Cell[CellGroupData[{
Cell[100639, 2057, 449, 11, 29, "Input",ExpressionUUID->"1152f610-3ed5-4325-bc73-59d15f344f44"],
Cell[101091, 2070, 1244, 35, 56, "Output",ExpressionUUID->"5901d4db-072a-4094-9fbf-4f7ae81e9263"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102372, 2110, 449, 11, 29, "Input",ExpressionUUID->"f377c08c-b810-469b-9e39-aea7e53726dd"],
Cell[102824, 2123, 1360, 37, 52, "Output",ExpressionUUID->"90a008cb-5833-4c93-b28c-324c8b37978d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[104221, 2165, 654, 19, 69, "Input",ExpressionUUID->"9475559a-8c77-4835-a3db-4c77bae4aa75"],
Cell[104878, 2186, 559, 15, 36, "Output",ExpressionUUID->"9c91672c-0567-417a-8931-c8f2d7759548"]
}, Open  ]],
Cell[CellGroupData[{
Cell[105474, 2206, 894, 24, 87, "Input",ExpressionUUID->"f04d4e6c-addb-4372-80c7-4b244e2a0ae9"],
Cell[106371, 2232, 2000, 58, 97, "Output",ExpressionUUID->"07d5c2ab-02b7-44d8-8507-b11101173143"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108408, 2295, 483, 12, 29, "Input",ExpressionUUID->"be300e3b-82b6-4358-818a-c6092be4d2c9"],
Cell[108894, 2309, 59172, 1148, 253, "Output",ExpressionUUID->"98cfab8d-d5bd-46ca-b831-4ce472aaef38"]
}, Open  ]],
Cell[CellGroupData[{
Cell[168103, 3462, 488, 12, 29, "Input",ExpressionUUID->"a0fb379f-7230-41f4-a24b-c43c1325f180"],
Cell[168594, 3476, 38627, 659, 239, "Output",ExpressionUUID->"fc0ee837-ff6a-48d6-95b3-ef78ac6442ac"]
}, Open  ]],
Cell[207236, 4138, 352, 6, 49, "Text",ExpressionUUID->"2e7c0727-9654-4e53-a75f-93f3bf75abb2"],
Cell[CellGroupData[{
Cell[207613, 4148, 322, 8, 29, "Input",ExpressionUUID->"9cd19836-55b7-45c0-b07d-923671a2f34f"],
Cell[207938, 4158, 3595, 82, 48, "Output",ExpressionUUID->"97b85e24-1092-4e81-97a1-5bba94e35b2f"]
}, Open  ]],
Cell[211548, 4243, 638, 18, 45, "Input",ExpressionUUID->"9eeb3bb0-cfb4-47ab-bb81-5e7d8cb43a9d"],
Cell[212189, 4263, 469, 12, 29, "Input",ExpressionUUID->"ec4839ff-c3b0-4342-b7ef-4a9b4ce71ae5"],
Cell[CellGroupData[{
Cell[212683, 4279, 363, 10, 29, "Input",ExpressionUUID->"1b462078-f0c5-4f08-9616-a71a7c1c4230"],
Cell[213049, 4291, 53488, 1047, 253, "Output",ExpressionUUID->"2de58417-eb4c-4c16-b533-3060decf4f04"]
}, Open  ]],
Cell[CellGroupData[{
Cell[266574, 5343, 423, 11, 29, "Input",ExpressionUUID->"4255a647-974c-4711-9613-e0879a747922"],
Cell[267000, 5356, 4242, 89, 236, "Output",ExpressionUUID->"19d80a58-abae-4261-8a4e-2ac90e19b2aa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[271279, 5450, 599, 14, 47, "Input",ExpressionUUID->"48edb513-d32d-4969-aa50-0125399c7d94"],
Cell[271881, 5466, 560, 12, 52, "Output",ExpressionUUID->"0a3633b5-f2b5-48a6-8d1c-39f3503c3774"]
}, Open  ]],
Cell[CellGroupData[{
Cell[272478, 5483, 383, 7, 29, "Input",ExpressionUUID->"19ebd51f-1688-4953-98a5-1eeb909408d5"],
Cell[272864, 5492, 798, 17, 53, "Output",ExpressionUUID->"80fa4aae-f42c-4640-a55c-d79e2b6f36ae"]
}, Open  ]],
Cell[CellGroupData[{
Cell[273699, 5514, 514, 13, 29, "Input",ExpressionUUID->"4e5fe18f-8e2c-44fe-b1f3-49bd56e8cf0c"],
Cell[274216, 5529, 972, 22, 53, "Output",ExpressionUUID->"f9864cf4-f746-4172-a0fc-be4046dbef3c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[275225, 5556, 454, 11, 46, "Input",ExpressionUUID->"09d81394-ca6d-4bbd-b61a-cc043b09bb79"],
Cell[275682, 5569, 638, 13, 51, "Output",ExpressionUUID->"0946ad29-9605-4198-b618-6cf2db10ad30"]
}, Open  ]],
Cell[CellGroupData[{
Cell[276357, 5587, 477, 11, 29, "Input",ExpressionUUID->"0ce1d304-7a9a-4627-96e4-9bf7f381f5f5"],
Cell[276837, 5600, 1293, 32, 49, "Output",ExpressionUUID->"496703e4-9a21-4af1-81a5-6a09dbc4900c"]
}, Open  ]],
Cell[278145, 5635, 245, 5, 49, "Text",ExpressionUUID->"dcfea65a-49d5-4b48-880d-bb44910b994f"],
Cell[CellGroupData[{
Cell[278415, 5644, 784, 23, 51, "Input",ExpressionUUID->"5adf5766-0191-4e36-8b90-a69ecdddf07f"],
Cell[279202, 5669, 822, 24, 54, "Output",ExpressionUUID->"07281373-68da-4bc5-bc22-e7293c5ea3a7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[280061, 5698, 521, 13, 29, "Input",ExpressionUUID->"badce37f-f844-4f87-8cbe-eab2193605a7"],
Cell[280585, 5713, 889, 24, 54, "Output",ExpressionUUID->"8012754a-c6c1-44d3-96ff-0fa7a697ed08"]
}, Open  ]],
Cell[281489, 5740, 1261, 34, 69, "Input",ExpressionUUID->"edfddc3b-96de-4c56-a15c-9a980318f44f"],
Cell[282753, 5776, 547, 16, 29, "Input",ExpressionUUID->"9d89fd23-6336-447e-b451-8caaf8078e12"],
Cell[283303, 5794, 643, 18, 49, "Input",ExpressionUUID->"9662eb3f-653a-4741-9ca1-82bb37beac27"],
Cell[CellGroupData[{
Cell[283971, 5816, 493, 16, 51, "Input",ExpressionUUID->"93daa6aa-1774-45ef-b7b1-213677cb425d"],
Cell[284467, 5834, 755, 23, 77, "Output",ExpressionUUID->"0cf573cf-c553-42cf-9053-74213e1f6c36"]
}, Open  ]]
}, Open  ]]
}
]
*)

