(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    343473,       6963]
NotebookOptionsPosition[    333502,       6785]
NotebookOutlinePosition[    333899,       6801]
CellTagsIndexPosition[    333856,       6798]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["Explore properties of Bessel Filters  (for Figure \
5.4)",
 FontSize->24]], "Section",
 CellChangeTimes->{{3.508333919295644*^9, 3.508333937087164*^9}, {
  3.793328685878509*^9, 3.793328690293405*^9}},
 FontSize->12,ExpressionUUID->"a28d16a0-0e28-4482-b7f5-1546cb963462"],

Cell[TextData[StyleBox["poles of a 10th-order Bessel filter",
 FontSize->16]], "Text",
 CellChangeTimes->{{3.5083339928315287`*^9, 3.508334013343824*^9}},
 FontSize->12,ExpressionUUID->"fca7d474-662d-412b-8629-ced54de83070"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[615]:=",ExpressionUUID->"8d7bb64d-867e-4a95-ad92-0ef563acc9d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"b", "[", 
     RowBox[{"n_", ",", "k_"}], "]"}], ":=", " ", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "n"}], "-", "k"}], ")"}], "!"}], 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"(", 
        RowBox[{"n", "-", "k"}], ")"}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "k"}], ")"}], "!"}], " ", 
      RowBox[{"k", "!"}]}]]}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"see", " ", "Wikipedia"}], ",", " ", 
    RowBox[{"Bessel", " ", "filter"}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.508335636154365*^9, 3.508335660838882*^9}},
 FontSize->12,
 CellLabel->
  "In[616]:=",ExpressionUUID->"c8000e26-e379-4193-b2fc-2843a5598e36"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n0", " ", "=", " ", "10"}], ";", " ", 
  RowBox[{"b10tf", " ", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"b", "[", 
       RowBox[{"n0", ",", "0"}], "]"}], 
      RowBox[{
       SubsuperscriptBox["\[Sum]", 
        RowBox[{"i", "=", "0"}], "n0"], 
       RowBox[{
        RowBox[{"b", "[", 
         RowBox[{"n0", ",", "i"}], "]"}], 
        SuperscriptBox["s", "i"]}]}]], ",", "s"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.508335859591607*^9, 3.508335862197611*^9}, {
  3.508337372222361*^9, 3.508337378823803*^9}},
 FontSize->12,
 CellLabel->
  "In[617]:=",ExpressionUUID->"20a60d6e-5086-42d3-8556-f32f00b1ff9e"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox["654729075", 
     RowBox[{"654729075", "+", 
       RowBox[{"654729075", " ", "s"}], "+", 
       RowBox[{"310134825", " ", 
         SuperscriptBox["s", "2"]}], "+", 
       RowBox[{"91891800", " ", 
         SuperscriptBox["s", "3"]}], "+", 
       RowBox[{"18918900", " ", 
         SuperscriptBox["s", "4"]}], "+", 
       RowBox[{"2837835", " ", 
         SuperscriptBox["s", "5"]}], "+", 
       RowBox[{"315315", " ", 
         SuperscriptBox["s", "6"]}], "+", 
       RowBox[{"25740", " ", 
         SuperscriptBox["s", "7"]}], "+", 
       RowBox[{"1485", " ", 
         SuperscriptBox["s", "8"]}], "+", 
       RowBox[{"55", " ", 
         SuperscriptBox["s", "9"]}], "+", 
       SuperscriptBox["s", "10"]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{654729075}}, 654729075 + 
        654729075 $CellContext`s + 310134825 $CellContext`s^2 + 
        91891800 $CellContext`s^3 + 18918900 $CellContext`s^4 + 
        2837835 $CellContext`s^5 + 315315 $CellContext`s^6 + 
        25740 $CellContext`s^7 + 1485 $CellContext`s^8 + 
        55 $CellContext`s^9 + $CellContext`s^10}, $CellContext`s], AutoDelete -> 
      True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{654729075}}, 654729075 + 
        654729075 $CellContext`s + 310134825 $CellContext`s^2 + 
        91891800 $CellContext`s^3 + 18918900 $CellContext`s^4 + 
        2837835 $CellContext`s^5 + 315315 $CellContext`s^6 + 
        25740 $CellContext`s^7 + 1485 $CellContext`s^8 + 
        55 $CellContext`s^9 + $CellContext`s^10}, $CellContext`s]], 1, {}, {
     False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelMinimal",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{
           TooltipBox[
            StyleBox[
             StyleBox[
             "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #]}}, 
         AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{654729075}}, 654729075 + 654729075 $CellContext`s + 
    310134825 $CellContext`s^2 + 91891800 $CellContext`s^3 + 
    18918900 $CellContext`s^4 + 2837835 $CellContext`s^5 + 
    315315 $CellContext`s^6 + 25740 $CellContext`s^7 + 1485 $CellContext`s^8 + 
    55 $CellContext`s^9 + $CellContext`s^10}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{{3.508334385007781*^9, 3.50833440159676*^9}, 
   3.508334816044179*^9, 3.508334847594035*^9, {3.508334880939158*^9, 
   3.508334931242231*^9}, {3.508335863466214*^9, 3.5083358694693832`*^9}, 
   3.508336063633321*^9, 3.50833616677135*^9, 3.508337347508325*^9, 
   3.5083373819923553`*^9, {3.5083374462351837`*^9, 3.5083374691936903`*^9}, 
   3.508338689913265*^9, 3.508364936441028*^9, 3.50851247833221*^9, 
   3.508519270973558*^9, 3.7538983765836287`*^9, 3.753898926006033*^9, 
   3.793328701237095*^9, {3.793328824966692*^9, 3.793328852254607*^9}, 
   3.793893150090724*^9, 3.793893303491036*^9, {3.793893407232465*^9, 
   3.793893420759616*^9}, 3.793893688092227*^9, 3.823224521311914*^9},
 FontSize->12,
 CellLabel->
  "Out[617]=",ExpressionUUID->"eba68342-109f-41c4-95e2-ac2f3de4fa68"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"b10poles", "=", 
   RowBox[{
    RowBox[{"TransferFunctionPoles", "[", "b10tf", "]"}], "//", "N"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.508334018054957*^9, 3.508334056564637*^9}, {
   3.508334156857225*^9, 3.508334167340769*^9}, {3.5083343190055227`*^9, 
   3.508334393979677*^9}, 3.508336280950371*^9},
 FontSize->12,
 CellLabel->
  "In[618]:=",ExpressionUUID->"c648b837-c940-4129-a783-e7b7dbd95a19"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n0", " ", "=", " ", "2"}], ";", " ", 
  RowBox[{"b2tf", " ", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"b", "[", 
       RowBox[{"n0", ",", "0"}], "]"}], 
      RowBox[{
       SubsuperscriptBox["\[Sum]", 
        RowBox[{"i", "=", "0"}], "n0"], 
       RowBox[{
        RowBox[{"b", "[", 
         RowBox[{"n0", ",", "i"}], "]"}], 
        SuperscriptBox["s", "i"]}]}]], ",", "s"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.508335799641779*^9, 3.50833583820881*^9}},
 FontSize->12,
 CellLabel->
  "In[619]:=",ExpressionUUID->"282c598c-3796-4b01-b7fc-528edca7e0ca"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox["3", 
     RowBox[{"3", "+", 
       RowBox[{"3", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{3}}, 3 + 
        3 $CellContext`s + $CellContext`s^2}, $CellContext`s], AutoDelete -> 
      True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{3}}, 3 + 
        3 $CellContext`s + $CellContext`s^2}, $CellContext`s]], 1, {}, {
     False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{3}}, 3 + 
    3 $CellContext`s + $CellContext`s^2}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{{3.508335841408043*^9, 3.5083358695402317`*^9}, 
   3.5083360637352133`*^9, 3.5083361668757544`*^9, 3.508337347572934*^9, 
   3.5083373820591307`*^9, {3.508337446299979*^9, 3.508337469277495*^9}, 
   3.508338690013451*^9, 3.508364936504512*^9, 3.5085124784163513`*^9, 
   3.5085192710550127`*^9, 3.753898376827796*^9, 3.7538989261897287`*^9, 
   3.793328701353155*^9, {3.7933288251007853`*^9, 3.7933288523663273`*^9}, 
   3.7938931501935863`*^9, 3.7938933036091003`*^9, {3.793893407342787*^9, 
   3.793893420876226*^9}, 3.793893688179427*^9, 3.823224521426358*^9},
 FontSize->12,
 CellLabel->
  "Out[619]=",ExpressionUUID->"e95a3f43-6c9b-426f-b560-126521d0abfd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b2poles", " ", "=", " ", 
  RowBox[{"TransferFunctionPoles", "[", "b2tf", "]"}]}]], "Input",
 CellChangeTimes->{{3.508335886221784*^9, 3.508335945567399*^9}},
 FontSize->12,
 CellLabel->
  "In[620]:=",ExpressionUUID->"0059955d-2333-4b39-8696-76c9da340e49"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}]}], "}"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.508335942000038*^9, 3.5083359461723824`*^9}, 
   3.508336063791294*^9, 3.5083361669278584`*^9, 3.508337347627632*^9, 
   3.508337382113722*^9, {3.508337446333194*^9, 3.508337469333078*^9}, 
   3.508338690085724*^9, 3.508364936538764*^9, 3.5085124784714518`*^9, 
   3.5085192710931463`*^9, 3.753898376895043*^9, 3.7538989263003187`*^9, 
   3.793328701423468*^9, {3.79332882517747*^9, 3.7933288523850183`*^9}, 
   3.793893150238098*^9, 3.7938933036450357`*^9, {3.793893407392538*^9, 
   3.7938934209076967`*^9}, 3.793893688210594*^9, 3.8232245214727993`*^9},
 FontSize->12,
 CellLabel->
  "Out[620]=",ExpressionUUID->"ffcbcb91-af0e-4fb3-81b9-10a2d3893854"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n0", " ", "=", " ", "4"}], ";", " ", 
  RowBox[{"b4tf", " ", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"b", "[", 
       RowBox[{"n0", ",", "0"}], "]"}], 
      RowBox[{
       SubsuperscriptBox["\[Sum]", 
        RowBox[{"i", "=", "0"}], "n0"], 
       RowBox[{
        RowBox[{"b", "[", 
         RowBox[{"n0", ",", "i"}], "]"}], 
        SuperscriptBox["s", "i"]}]}]], ",", "s"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.508336302883677*^9, 3.508336306457411*^9}},
 FontSize->12,
 CellLabel->
  "In[621]:=",ExpressionUUID->"8a507f3e-c200-4066-b0d1-4f57ca514ae7"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox["105", 
     RowBox[{"105", "+", 
       RowBox[{"105", " ", "s"}], "+", 
       RowBox[{"45", " ", 
         SuperscriptBox["s", "2"]}], "+", 
       RowBox[{"10", " ", 
         SuperscriptBox["s", "3"]}], "+", 
       SuperscriptBox["s", "4"]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{105}}, 105 + 105 $CellContext`s + 
        45 $CellContext`s^2 + 
        10 $CellContext`s^3 + $CellContext`s^4}, $CellContext`s], AutoDelete -> 
      True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{105}}, 105 + 105 $CellContext`s + 
        45 $CellContext`s^2 + 
        10 $CellContext`s^3 + $CellContext`s^4}, $CellContext`s]], 1, {}, {
     False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{105}}, 105 + 105 $CellContext`s + 
    45 $CellContext`s^2 + 
    10 $CellContext`s^3 + $CellContext`s^4}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{
  3.5083363090107937`*^9, 3.50833734767892*^9, 3.508337382147318*^9, {
   3.508337446389619*^9, 3.508337469382802*^9}, 3.508338690152952*^9, 
   3.508364936598575*^9, 3.508512478517441*^9, 3.5085192711428003`*^9, 
   3.753898377021557*^9, 3.753898926463231*^9, 3.793328701549533*^9, {
   3.7933288252221603`*^9, 3.793328852478664*^9}, 3.7938931503077106`*^9, 
   3.7938933037140837`*^9, {3.793893407478602*^9, 3.793893420974251*^9}, 
   3.793893688273695*^9, 3.8232245215482388`*^9},
 FontSize->12,
 CellLabel->
  "Out[621]=",ExpressionUUID->"81691e12-df44-4bee-9912-ca6423a5e018"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"b4poles", " ", "=", " ", 
   RowBox[{
    RowBox[{"TransferFunctionPoles", "[", "b4tf", "]"}], " ", "//", " ", 
    "N"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.508336327914824*^9, 3.508336348224559*^9}},
 FontSize->12,
 CellLabel->
  "In[622]:=",ExpressionUUID->"e3deab33-b50e-4c6b-9823-8b49e87160b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n0", " ", "=", " ", "5"}], ";", " ", 
  RowBox[{"b5tf", " ", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"b", "[", 
       RowBox[{"n0", ",", "0"}], "]"}], 
      RowBox[{
       SubsuperscriptBox["\[Sum]", 
        RowBox[{"i", "=", "0"}], "n0"], 
       RowBox[{
        RowBox[{"b", "[", 
         RowBox[{"n0", ",", "i"}], "]"}], 
        SuperscriptBox["s", "i"]}]}]], ",", "s"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5083386321562347`*^9, 3.5083386343893642`*^9}},
 FontSize->12,
 CellLabel->
  "In[623]:=",ExpressionUUID->"6c07d6a6-a6e8-415f-9f89-afd68adc1da6"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox["945", 
     RowBox[{"945", "+", 
       RowBox[{"945", " ", "s"}], "+", 
       RowBox[{"420", " ", 
         SuperscriptBox["s", "2"]}], "+", 
       RowBox[{"105", " ", 
         SuperscriptBox["s", "3"]}], "+", 
       RowBox[{"15", " ", 
         SuperscriptBox["s", "4"]}], "+", 
       SuperscriptBox["s", "5"]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{945}}, 945 + 945 $CellContext`s + 
        420 $CellContext`s^2 + 105 $CellContext`s^3 + 
        15 $CellContext`s^4 + $CellContext`s^5}, $CellContext`s], AutoDelete -> 
      True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{945}}, 945 + 945 $CellContext`s + 
        420 $CellContext`s^2 + 105 $CellContext`s^3 + 
        15 $CellContext`s^4 + $CellContext`s^5}, $CellContext`s]], 1, {}, {
     False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{945}}, 945 + 945 $CellContext`s + 
    420 $CellContext`s^2 + 105 $CellContext`s^3 + 
    15 $CellContext`s^4 + $CellContext`s^5}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{
  3.508338635000469*^9, 3.5083386902480173`*^9, 3.5083649366730833`*^9, 
   3.508512478601334*^9, 3.508519271223501*^9, 3.7538983771785727`*^9, 
   3.7538989266369753`*^9, 3.793328701695903*^9, {3.793328825337407*^9, 
   3.793328852586742*^9}, 3.793893150398477*^9, 3.793893303810709*^9, {
   3.793893407563498*^9, 3.793893421070264*^9}, 3.7938936883569317`*^9, 
   3.823224521660698*^9},
 FontSize->12,
 CellLabel->
  "Out[623]=",ExpressionUUID->"8e3c8912-7325-4b64-bfe0-5f42a9def6b6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"b5poles", " ", "=", " ", 
   RowBox[{
    RowBox[{"TransferFunctionPoles", "[", "b5tf", "]"}], " ", "//", " ", 
    "N"}]}], ";"}]], "Input",
 FontSize->12,
 CellLabel->
  "In[624]:=",ExpressionUUID->"69507958-ace4-4107-9cdb-e21a088f50db"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n0", " ", "=", " ", "6"}], ";", " ", 
  RowBox[{"b6tf", " ", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"b", "[", 
       RowBox[{"n0", ",", "0"}], "]"}], 
      RowBox[{
       SubsuperscriptBox["\[Sum]", 
        RowBox[{"i", "=", "0"}], "n0"], 
       RowBox[{
        RowBox[{"b", "[", 
         RowBox[{"n0", ",", "i"}], "]"}], 
        SuperscriptBox["s", "i"]}]}]], ",", "s"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.508336120029236*^9, 3.508336125280829*^9}},
 FontSize->12,
 CellLabel->
  "In[625]:=",ExpressionUUID->"673300ce-e032-461f-8d59-352c6ea4a0f3"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox["10395", 
     RowBox[{"10395", "+", 
       RowBox[{"10395", " ", "s"}], "+", 
       RowBox[{"4725", " ", 
         SuperscriptBox["s", "2"]}], "+", 
       RowBox[{"1260", " ", 
         SuperscriptBox["s", "3"]}], "+", 
       RowBox[{"210", " ", 
         SuperscriptBox["s", "4"]}], "+", 
       RowBox[{"21", " ", 
         SuperscriptBox["s", "5"]}], "+", 
       SuperscriptBox["s", "6"]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{10395}}, 10395 + 10395 $CellContext`s + 
        4725 $CellContext`s^2 + 1260 $CellContext`s^3 + 210 $CellContext`s^4 + 
        21 $CellContext`s^5 + $CellContext`s^6}, $CellContext`s], AutoDelete -> 
      True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{10395}}, 10395 + 10395 $CellContext`s + 
        4725 $CellContext`s^2 + 1260 $CellContext`s^3 + 210 $CellContext`s^4 + 
        21 $CellContext`s^5 + $CellContext`s^6}, $CellContext`s]], 1, {}, {
     False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelMinimal",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{
           TooltipBox[
            StyleBox[
             StyleBox[
             "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #]}}, 
         AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{10395}}, 10395 + 10395 $CellContext`s + 
    4725 $CellContext`s^2 + 1260 $CellContext`s^3 + 210 $CellContext`s^4 + 
    21 $CellContext`s^5 + $CellContext`s^6}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{
  3.508336125864719*^9, 3.508336166974516*^9, 3.508337347757753*^9, 
   3.508337382226192*^9, {3.508337446534577*^9, 3.508337469461135*^9}, 
   3.508338690348564*^9, 3.508364936738302*^9, 3.508512478684292*^9, 
   3.508519271308194*^9, 3.753898377412698*^9, 3.7538989268173637`*^9, 
   3.793328701820282*^9, {3.793328825452104*^9, 3.7933288527019987`*^9}, 
   3.793893150502572*^9, 3.793893303894699*^9, {3.793893407655892*^9, 
   3.793893421161663*^9}, 3.793893688440687*^9, 3.823224521746956*^9},
 FontSize->12,
 CellLabel->
  "Out[625]=",ExpressionUUID->"1c37741b-b03d-4c11-88a0-a9de52c3fbb2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"b6poles", " ", "=", " ", 
   RowBox[{
    RowBox[{"TransferFunctionPoles", "[", "b6tf", "]"}], "//", "N"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.508336253286467*^9, 3.508336276598509*^9}},
 FontSize->12,
 CellLabel->
  "In[626]:=",ExpressionUUID->"c92f4630-1f54-492f-9e7c-398c16500939"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n0", " ", "=", " ", "8"}], ";", " ", 
  RowBox[{"b8tf", " ", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"b", "[", 
       RowBox[{"n0", ",", "0"}], "]"}], 
      RowBox[{
       SubsuperscriptBox["\[Sum]", 
        RowBox[{"i", "=", "0"}], "n0"], 
       RowBox[{
        RowBox[{"b", "[", 
         RowBox[{"n0", ",", "i"}], "]"}], 
        SuperscriptBox["s", "i"]}]}]], ",", "s"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.508337327381918*^9, 3.50833734109651*^9}},
 FontSize->12,
 CellLabel->
  "In[627]:=",ExpressionUUID->"5e9ddda4-81f5-4a13-bbb7-7b75d7fe92c2"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox["2027025", 
     RowBox[{"2027025", "+", 
       RowBox[{"2027025", " ", "s"}], "+", 
       RowBox[{"945945", " ", 
         SuperscriptBox["s", "2"]}], "+", 
       RowBox[{"270270", " ", 
         SuperscriptBox["s", "3"]}], "+", 
       RowBox[{"51975", " ", 
         SuperscriptBox["s", "4"]}], "+", 
       RowBox[{"6930", " ", 
         SuperscriptBox["s", "5"]}], "+", 
       RowBox[{"630", " ", 
         SuperscriptBox["s", "6"]}], "+", 
       RowBox[{"36", " ", 
         SuperscriptBox["s", "7"]}], "+", 
       SuperscriptBox["s", "8"]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{2027025}}, 2027025 + 2027025 $CellContext`s + 
        945945 $CellContext`s^2 + 270270 $CellContext`s^3 + 
        51975 $CellContext`s^4 + 6930 $CellContext`s^5 + 630 $CellContext`s^6 + 
        36 $CellContext`s^7 + $CellContext`s^8}, $CellContext`s], AutoDelete -> 
      True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{2027025}}, 2027025 + 2027025 $CellContext`s + 
        945945 $CellContext`s^2 + 270270 $CellContext`s^3 + 
        51975 $CellContext`s^4 + 6930 $CellContext`s^5 + 630 $CellContext`s^6 + 
        36 $CellContext`s^7 + $CellContext`s^8}, $CellContext`s]], 1, {}, {
     False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelMinimal",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{
           TooltipBox[
            StyleBox[
             StyleBox[
             "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #]}}, 
         AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{2027025}}, 2027025 + 2027025 $CellContext`s + 
    945945 $CellContext`s^2 + 270270 $CellContext`s^3 + 
    51975 $CellContext`s^4 + 6930 $CellContext`s^5 + 630 $CellContext`s^6 + 
    36 $CellContext`s^7 + $CellContext`s^8}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{{3.508337331171179*^9, 3.508337347841436*^9}, 
   3.508337382291054*^9, {3.508337446617077*^9, 3.508337469544821*^9}, 
   3.508338690449552*^9, 3.508364936821463*^9, 3.508512478793277*^9, 
   3.508519271375258*^9, 3.7538983775996943`*^9, 3.7538989270244627`*^9, 
   3.793328701940075*^9, {3.7933288255679493`*^9, 3.7933288528192863`*^9}, 
   3.793893150583857*^9, 3.793893303993634*^9, {3.793893407749805*^9, 
   3.7938934212374897`*^9}, 3.793893688527516*^9, 3.823224521830633*^9},
 FontSize->12,
 CellLabel->
  "Out[627]=",ExpressionUUID->"8704bb02-0c27-413a-b6cb-0137637a8b4f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"b8poles", " ", "=", " ", 
   RowBox[{
    RowBox[{"TransferFunctionPoles", "[", "b8tf", "]"}], "//", "N"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.508337409039562*^9, 3.508337412998818*^9}},
 FontSize->12,
 CellLabel->
  "In[628]:=",ExpressionUUID->"4df32ad1-c6de-47b3-bd36-40882208d85f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Flatten", "[", "b10poles", "]"}], "/.", 
      RowBox[{
       RowBox[{"Complex", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}]}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<X\>\"", ",", "Small"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "2"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", " ", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.508334092199999*^9, 3.508334093622006*^9}, {
  3.508335956862606*^9, 3.508335977643708*^9}, {3.508336641093631*^9, 
  3.50833666185135*^9}, {3.508336697068993*^9, 3.5083367319999*^9}},
 FontSize->12,
 CellLabel->
  "In[629]:=",ExpressionUUID->"c3583d82-7338-4edb-b07d-862b625de889"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQve6bRpfOBukDxRGnzrw8/Ho/Ab79kp87rvKVSWHw
L3Lf3FH7hOUAAb5D7WeW/fvviWPwdY/3zNDvEjxAgO+g9CFJpbZbGIPfoak6
I+mZxAECfIdZpjmV/Pc5MPjenLpJKuUKBwjwHQAkupaW
       "]]}}, 
    {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
     1.6], GeometricTransformationBox[InsetBox[
       StyleBox["\<\"X\"\>",
        StripOnInput->False,
        FontSize->
         10], {0., 0.}], {{{-6.922044905424327, -0.8676651954472291}}, \
{{-6.922044905424327, 
      0.8676651954472291}}, {{-6.615290965476024, -2.611567920802806}}, \
{{-6.615290965476024, 
      2.611567920802806}}, {{-5.967528328587716, -4.384947188942346}}, \
{{-5.967528328587716, 
      4.384947188942346}}, {{-4.886219566858957, -6.224985482471659}}, \
{{-4.886219566858957, 
      6.224985482471659}}, {{-3.108916233649052, -8.232699459073634}}, \
{{-3.108916233649052, 8.232699459073634}}}]}}, {{}, {}}},
  AspectRatio->2,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.5083341003181257`*^9, 3.5083341700818663`*^9, 3.508334401667651*^9, 
   3.50833481614559*^9, 3.508334847696237*^9, {3.50833488101445*^9, 
   3.508334931343799*^9}, 3.508335869586351*^9, {3.508335962104826*^9, 
   3.508335978188073*^9}, 3.508336063836792*^9, 3.508336167029602*^9, {
   3.508336641941147*^9, 3.5083366622982073`*^9}, {3.5083366983117332`*^9, 
   3.508336732767673*^9}, 3.5083373484558773`*^9, 3.508337382327588*^9, {
   3.508337446684824*^9, 3.508337469630597*^9}, 3.5083386905518637`*^9, 
   3.508364936906046*^9, 3.508512478869843*^9, 3.508519271454286*^9, 
   3.7538983778669558`*^9, 3.7538989271473837`*^9, 3.793328702058426*^9, {
   3.79332882565924*^9, 3.7933288529138393`*^9}, 3.793893150654564*^9, 
   3.79389330404659*^9, {3.793893407824815*^9, 3.793893421310515*^9}, 
   3.793893688608308*^9, 3.8232245218755074`*^9},
 FontSize->12,
 CellLabel->
  "Out[629]=",ExpressionUUID->"e2a5f8f9-009a-4795-a16b-3ab0b5782f8d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BodePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b2tf", ",", "b4tf", ",", "b6tf", ",", "b8tf"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.01", ",", "1000"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.508334406036675*^9, 3.508334419995142*^9}, {
  3.508335983151821*^9, 3.508335989912456*^9}, {3.508336136742621*^9, 
  3.508336138918707*^9}, {3.508336356960387*^9, 3.50833636504382*^9}, {
  3.5083374185770187`*^9, 3.508337419749892*^9}, {3.508337465729136*^9, 
  3.508337504466111*^9}, {3.5083386639085007`*^9, 3.508338665472535*^9}, {
  3.50833872164287*^9, 3.508338722179514*^9}},
 FontSize->12,
 CellLabel->
  "In[630]:=",ExpressionUUID->"90cf9079-f257-4d50-a532-2030deba9e9d"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVV3c01o8bNXszCtEXDbtSmlZIPm9GKBEZRUYlUSohSVEiKURFmUVFMiJJ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           "]]},
         Annotation[#, "Charting`Private`Tag$389901#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVV2c41Y8ftWcKKSNKVEQhIhLfS/aeKYRk3JBkZieFIhRZUSjKlqysz9de
4dqja+/N5drj//u/Os95c86b8zznnIuWz/SsyUhISL6QkpD8H/faP08dHx+D
z0WX9Oi7jPB3+9pCye4xPCml9Tv7iBGSuKtWn20cg5OGwUibHyNgnMf2RmeO
QUD1RtVIGSMEnbnMhLYdw31n4YYocSZgMs2Vefn5GPSHub9/E2cG/nk0huTW
MRBX/8wqPWaBPSa9xFKRY1iKDmRUCGGB1tuTKU4Cx2DFv2jwOocFHMMoc8a4
jmFZ4SkbbocFCoXValGKY2CIIGdO/XgGMO7dqy+7jkB2Q3PnS/dZMCKfUSF1
PAKBrJkv6eHs4JxuwCBqewSSdCcpVlF2CFOt7bS0OIL8latGCRvsUBORbFyn
dwT8Nve6OY05QIjTxCH41hHg0w3+zgieAwpxXAQD6RE46Fqwy01ywoUBWQPZ
vUMQ9ZonnuXkgtveOWzPNg5hVaPmu6khFzyrfpeCmz6EZmfhxdvNXDCkqfg7
quUQOMV0Y0yKz8Mvm7I+9uhDqH55ws9bnxv+0l79rPb+EPhye1wTXLhhJjvW
3DvoEH4VUXzZieIGzg3XOfyLQxj5N+7p2ssNIf7Ce18f/uefjV5/YXIRzOK+
c13hO4Sc3+UuF115gL4l3Eq07AAGJifkq/9dgu+Vlrl9vw8glUfFkJHsMtz5
JbHjlXMAa41htWn8l8EhbiS0NvkAZsrC/qS5X4Z2G6HfBsEHQG9ph6U5ewU+
kreTehgcwHH3R3y7JR+wyTB8LV/Zh2Qj5kUFSQHIFxmfM5/bh1bn000OWAFQ
vVQkSjGxD327VWeX4wTAi/5hg0bvPoz2HETt7gkAfjB7ebh8HySX9DgNagXh
q7vGHZK3+zBpsNvwzfo6XMkPHVTg3QeL/hWFZi8ReGkkz0TLtQ+7pK30bnEi
MHS0o9J2dh+0FjJk7xWLQLimTakh3T7c4x56UkYQga0FTKzN+h7MN/AEsTje
gIbLWwYhsAcYbstk22eiYPPZAtdqsgcDC5VTT7/eBFSelSbScA+KG6oMI+pu
AsdCG2KgvQf9A5wpG/M3oV1SOg8vvwebM3czgsTFQaLvTPjy1T0I65EfnewQ
ByqmVvVTO7tQIxxTNcd0C9KCxBv1onfh5ewKeXm7FKj8bK6MeL8L+IUG1Suk
t2Gp+WHh36BdOP/1FuOm2G0QZQhKUfLchbFkLp6yhNuARvV53zbbhZXJr7WU
T6VhKNlDhId/Fxh7jRXUL8uAXw09n/nFXRgw12e5YyYDF6e+ciVy7IJQWB5P
YqwMYPma6M4y7ELd1OdHOfSyQMxhm6Yl7IBg32rMtV1ZYCz/E79evgOLtQRP
UTcMFOI1I4WKdoA2KT7lwScMGB2NB9nn7oDUW90EKMLAFzk61+nkHQg2aVtQ
3caAYJOx1uCbHTByKcqz9pUDpd59smrtHXDJ7xATiJEH71UZh8jJbTiZMPjn
66ECJD66NYcZ3gbzpsGZCV5FqOgWsVrv2wbLG2Td9mqKcFTCa6rXsg2HfxVn
dOIU4dVLWg2WX9tQc5bI7n5LCd4x9QrG+W2DtecHXHKgMiSIOSx+Zd+Gwkx4
pW6kBuVp1rY6p7fh1jV9W+1gNcCzmk+SMGyDIY9FV2aJGpw/0P33iGQbnj5G
yu3Y1SG17lYr7+wWRJXFRXGPq0OGIXnWj8It0BDSYt4K0IRSjwS7PO0tMDn/
m5k+WAd4rJ6nDahsgVLZQNPvHzrwXkdljFR+C1xtfWiSmnTA8uqWocHNLSAY
mfOK0esC/T9duV22LbiUzLjrHaULZrK0bHcniIBre0JFzNeDJoExPYd/RIAl
Q72pXj0QZS15/6mHCHK++ATOfT2gXrMin2sgwpZo42M7JX3IT0FXwrKIsG1g
NPFuTB/IKV/U97kSIYulpuYxryE4rmuRkDgSYXFObpNf0xAGhi9LX7UlwtOY
4nyMhyFkF3fnez8ggmmo7H27v4ZwDyucyC1LhPDAy29Lve7Bz9YZZztqIqBX
1td7Z41A66Mh91H8JvjhvwfT0JqAl+gpVeWoTVCWEkj0kjGB9K6m55Fhm1CW
Pe6o52wCR8x3ann8NwGfv2MtMWwCOVE8NspWm5Bb9ityusQUTnxazYoU2gQt
DF/8pwAzkBTP6Bnk24Q/RcvOtRVmYNVrechzcRN+RmDOWe2YQcWZPq2i05vQ
bCtuQPrcHOxjKtYHdzaAnCOVdULMAlpi397ird2AQPPf6DmJR7B1666FQ8UG
BBHEpf2NHgHPwEFIUdEGZN5d8ub1fARebE5Dyj83YOHBZ2WRykdwNf6er8P7
DXi8cI/8iYolhCTw1hYZbUA9N+3FFvvHoJxUqaWyRAA1bHMl+4I1rL3HH1DM
EICBrWqviskGEvz2M6tHCaCR3L+eJWUDS+ZS1NLdBPC79Pas+Tsb+MhTBNfL
CICtO50uKWwLIz+yRU6HEKCO+c4D4WAsuBd8Zh7hJQBvtngTs6s9cH8rQxO4
CPA8rNazMs0emqMGHY1YCUDgTqOu6bcHTjfWVhwdAfKHt+/+u+MANbeiAmvX
1+GuRIOOBf1TOFn5bvMnrEPkA8XrqmWOkN7o2edisg7XkhCMjOhziBd1v5th
sA6/lRDGA/3nEJbknD+iuQ5Wvk4ch27PwdnF/p0qZh3oAmxnGsueg8yFh7IX
Lq+D7PJKd7iyM/S4Y9JbVtZAuLKE+4GjCzSO3zlNMrcGNz68Rb2iXaBMQ+ql
+PgaSA18lZgtc4FkHlHj5O41+PLPlJBK4wr27bwn3UvXwO8nFWnxD1cgu0Lt
fvHVGojIq7J0broBMZJ88p73Gui4xPvMXnCHuf1j7TDXNZjErLjpqbtDe+fO
1W2bNWAcOCzk/+YO8b4Lw3/V14CLlmRk7p4HiPS2Kb44swZatNtb2h0voILm
quAX3VWI8DiOqqHxgST/pVNrCqtwlDL6+9wdH/DbytuUk1wFI8Pgqa5nPoCZ
kqiaPr8KRXYLAmYDPlAHCrrXl1ZAovGv636OL/x1t/CoCFqBIEMDpxV7f8BP
xdYOlS8Dk51D1cbnAKg0Mfl5LW8ZfmQtb9ysCIAvXeff+6UuAyOLqNwvfABY
oGn3eN4uA6UQRa/p+Vcw9fn3/JN7y/Ar58Ni6PdXsKTXcWp3bQmKu5VqsisC
YR+lMmW9sgS1EaWOdy4EgcXXCM4M9iVoGxUNJCoFQZ0v2/BthiUoVBNfIzoG
QdhtATOzzUWoeBbe2w5BwFmoaZFWswhL7YEnVq2C4c6PaCsx80V4YxIgZFYZ
Ar7veZ5qxy3ATZI+ua7MUJiwz7o+HroAXUNuIgH4UFBSu7ni7L8A5GR3zd6e
DIOT1ErPYmwWgIPxxt4PlzD48vLJ8+Gb//GJt1Qi8u+hyiXfzb5zHo4Q+6HD
tXA4fiDrF0w3Dx+7/P7c0PwAW9deVdAdzgH/wGzjguMHWDqu33u/OgcvPOdi
pyM/wFCapkd0zxy8897wS+39AMXrpk4pX+bgQpJWvrLlR3B4621ZLjoH05br
AkUhUfDYFJJlL8/BaupgVlNuFBgLk49Ws87BzLbx0yu9UaDc+86k6WAWmKsO
tmp4ooHnYoJBb8MsfKo9VoisjobB0lKlVeNZCFlwCSc5GQO40IPXzpqzkHtJ
/PWRZAw0mGFqicgs5Efy6+tYxUAhRRNycGkWbnr+OkEoj4FInX5J2tUZGCOK
XcY8iwWlOaIAb+AMkMz7jiXOxMFvVrFTRlnT4JBipa7NlQjpoXL3q79Mg3zs
zKqTTiLEHWunCH6chnfKVSmrgYngM+sgRuI5DRTBUz1US4mgUJJulKE0DXax
b3Tz0CTouceRvD8+Bb5uAf6BPl9h8xPpjWS2KaDBCZNmpqTADC2jF92JKaDy
olepqE6BAd/zta7Hk8Ctb7VOM5ECFdbShqozk/Apjv+sPm8qvBZ38yT8noQ/
2Ty+xT9T4UzvXLWC9iRopDcdcMA3kGDB6c2/mfivb4j5EVzpUO4Tz674YgIK
lfVURFTTATNtOZZsNwF3LT9S8bmlg2ox8el97Qk4SbKTyt6eDqb3z71tZJsA
hZdZBlde/4DARBtIyxqHCan9CU/SDKChFAki/TIOrQnsLR2iGRD2dFfjYeQ4
tM37Xgq2yoAY2bAhFrdxkE0wluRqzoDMsV/EQNlx+FjSZXgQkwm4S4eClp1j
QLfcoHJLKRsM3zcQKmvH4DqZmyiZXzYMESP+sBePwWbk+QfSxdkw2cCj3Jkw
BjYLGU37fDmwhVWxxFiNwQ/95/5tjLkgZcx3Q2ZlFN50BL3x2cmDLjsDumKp
EeCIZW0zPF0AE3TO2svnR4At4qu9qUQBEDIjoi9RjIDll3dUPx4UANNiy/mo
9mEI/XNTgS6lAHTs5cScHg8DPrM2gVXsN7TbC5kKvMfDtcBXFI1WhTBCr5Hy
yBkPGGnfas2wQljJejITZ4QHufVS5GJhITAsfXei5sGDS1x8fz5FEWg4nHsz
VfwPTu4anwvMKIIWB5rcL2NDMGHmTudLVgJDJ65s9NYPwbad5Ec24RJYyL4r
yZA1BAIWwnV0piVAu+xX4+02BDXmfn+JxSWg8pTYd59uCNKFHmB2nUqh4enE
MfPNQdAvGMjS2foD1Y4VusHB/eDfjn/8WL0SmnSeZYc59gMvp0eF2ctKaBfl
of5o2A98mhmCZUWVMLQVXJHI2w/RB+wnoi9WAcFPn68A+kDCWFNn9rAKLkUs
HOC3e0EnI4uszwqFkDy2n6LYHpiy5TfzflAD4R9aySS1e6CeL+jyL68aiHbx
eygj0QPDV6dkeBNrIOXWFLMKRQ9c+lN7rmq0Bsogz/dhcjec8+fDDT2phaUO
Jf2QgS4Qw2Wvs7yrA+0116NhlU6of64tNnbYAF7lSQYN1zvh4AJD8ynBRkgP
asjMZe6EiuBTH+PuN8IRJ5uRPx4Hky6cQaWFjZCjWp7H7YQDrWofUHzeBGeU
yGsahDqAJ4nwVvKgGRzwBo6xO+1whkSsVVe4Beqc0zmwNe0w+6+BDmfZAs5f
VV1o77XDnTiDnKOWFsDtRFzS8G0DFas64u3kVgjL4gzubG0F68zE0jmzNpiS
cxRL/dQK9LdqaQrj2kB6AEadzVuhj56/fL2rDRYoHkuybLT8t9tW8Y0q7aBi
ljF/j6MFHJgY4nakOoCcSUIDj20CSl3pS1/jceDlrs00S1kPzAVqdoJ1XVAV
2Tqn310HyLVP+7kzXUCepYyiyXXA3jUS4EzbDWGjyLME6Tqoi1vRLtfuhiQV
kTbN57XQX8Jp9Gi0G1AOpreF+Gp4mvfd8Cl9L5zwSyOlsK0EHek2X8GEfvhU
kJQ/TPpfDqol6jPq++H87CfzksQKoKG12H+x3g/COkGVdl3l8Fnt4PMJtQHQ
47H17JQpAxPcQDP78QDENfCvf2EpgYw5FO57DsHlU9ljUjX50CAVGc3yexgU
5rx9vxrkQ5i4UNL7lWGofxV7k649D8aiauT9BUYAM9v3I5k1FxJoj/Vx30ZA
It8wvC0zE1aw2lGKiaPAI69vwtf5DYIy9igLusbAYpMQTSCmgm0Ysd5pcwyS
0j+2V3KkAj7rmoTr2XFgo++SM7BKho4I3yfqJuPA9TNFh2w1Hg7bZUXV58Zh
KVaq194jBN4IIbpnGCdhwqK0PI7uDfQNnnpnLTEJA1dvpdYnBUDsH5MzFA8n
4a3HkxHZEDcQYcZVCGVNAht5QLGtpxFSLwg9GupTUDAwWFNvGI4wzeOtFT9P
g4FeeV+lShrycnTJSsX/v97jqx/bvJCO7L6UnfqXNwfuh+0LgtvpSEaP5Frn
2BzE/5w4ik/7iQjFGW3P3Z2HkSNaPneybETi7FnhoZMLUGiYLc1q9gsJN2LA
hJYugg/mF1rQ/AuJ8jp/J3d1ERQFixW1xAuQJ9Wr3XJ8S9BHgmq/OfEb6T/w
TquKXYLdrO7HG2WFCJGtZvuq3zLIku2HdrCWIlGB9Nifj1aBavmY0T6wFHkZ
/0hGI3kVOvopYqhWSxHDvppjp9FVsMg5mSzT8Ae53xqNTxZeg8D7PIVZruWI
6aJLa0TBGjTlquKDO6uQKEWLsCf165BxXeNscn0N4mBre8eNdxO4L3zP6dyu
QZQDfpxTVd2EOMYDBXKBWkT0StmBzbNNCNrIcrEJr0VoPISkAis2weoPfec1
ozpEJiSdW9uYCOcVW0P/zNUjSxIKk/XftyBGgpd3kaMBSVJzLw/q2AIGfu8y
Ts0G5HHnImfi3hYc0AnO+/9qQGY4du816m7DIO6dkpJXI3KLtJT2JsUORJuq
kXbTNyOM0Vpup7x24YRWahyFbDNywdTAwDlzFwKRPWEJp2YkpajjSPzfLjjz
ZJrF9zQjjt7BdJMye6A9R1thntSCyG41wSL1PtC5NrsvCf1FhJZeVfnkHcDL
UJUlSr0OpBAZTf9ylQTNziwMex7SgeT4iJ63VCdBB5u5rw9XdSAW63/LnJ6S
oOyvDySGzuCQ6UwqZecCEtS5psfj1ysc8kqBRPMchhTlRd7smpt2Ig/kykLz
7cjQMq3y5k8enYjHay7SgA9kqI7Zenzrx04k4KMSQ0YpGerj+/D2reZOxICF
XouchhztKRf3PinRhTCXiKbvZJKjQZIzBxWnupEdGU2fPDJKlFOFs40g0I0U
By7EPBamRAuM9JL4lbqRWBjt9TWlREfdq2SifboRfKxowVwJJSpZFONnP9+N
1JVfOPztQoXO31Am4ajtQXQEBlloSWhQDcGf5B7ufYhBaNeolQs9urSjUjUS
0YeYZHs672bSo2EN8y+UMvqQk3J/hagm6dHWR4IrZ/B9iCO1sVSYwQlULS53
oFCuHxEirLjYyjCgypRFOYQTA0gXUhKsyHcKnekyxBpfGUA2/TEtgzan0KDk
LZ4aZAA5wtGwbaefQhukJeM+OA8gAza4OCwLI6rgXP5KZGAAuf4HR/khnhGV
H602cvw2iJz21+iM+cWETmRbMvdVDCKD9zX1FnuZ0Fde5G0yfYPIuygt4fd7
TGj1GUV5BtohhGwVI1GuwIxiNJquZTsOId0Jg0cdeGZU9k876YLUP2Rq8e6g
EScLKhX1L8sah0dKH5s4JuPPol0f1nM15/GIcQIjM9Cxog6R1AXiZMPIzAjl
DUkpVjT5vVgp5c1hpG6U8Fk6lhWlCgmtS4sdRi78CCd8NGJDu3ykh6fNRpDt
+YBq/Dw76mDz+aTN8ijyOf2M510jLjSwYICGj3wMaRrHKtp+4EJxvx7TfT41
hsitvxtebeVCn+R7MgTyjyGogAOviPx5NDEn7bS+8RiyQeuk81zsAkr28/DC
RuUYEs34oS04mhvtSMyRFHszjnBULl31yudB3/3wrSj6OI74AcWplT4eVKFA
EyOZPI702Hc7JB3yoKWNy8oy5eNIW7zZhVx1XjSZcN1IeX0cOZyP7Yxa4EWd
VHLdTB5OIAUCBQxaYpdRxs3cgkDxSSSLf/jg9Cofqquef61negqxSdeUMCYR
QhmLitKeEaaQs3H/KmxFhND28+Xn6Y+nENWQm83xFkKoBqGeUZ5tGgm75Khq
Vy2EqsT/28xTm0aWa9LqCl8Lo7KzVJWhedOI8SoFtj9EBBUIfKh513MGMW8J
wiVeFEUpyukcC07MIWRKYx5jXuIoNdVPzA2PRSRG/dpIpJQMqui0ePFP5wpy
9EiKfC5OHh3SvMuP7K4hq7/zY35bK6FSuqI0zlkE5Nx8xPaND2roDfG28FrM
JvI4/g7lUx8ttJG/PJG9nYjcmCguxgnqopTv1DYQ323kEc6c5peCPvqv9c3a
61O7CENkwJt7tw3RB96WEgm1e4hxKlPvN2Mj1Il+kafd+AARI79MLWT0AOXN
aoihWjhE+BxfdC+omqD+pXf1T30+RmgK6FLIbR+it/UlTD7HkmAYH0oXs1qY
ozQB527EOpNiNJpD2iqq/3uvEplqn1TJMGAm5u/a/ggNx4eX8DCTY568JuIu
Nlui6lJ1KnGL5Bg7vh0HwsBj1CBI+3pSMQVGQIrresl/g++ayWvD776UGBUx
rKJ/hzU6MEObGmVIhaF+H4J7MmyD4iyn5ZgvUGNWDJurlQdt0UmKHzufeKgx
IhT01tnDtuhWOjaP/Qo1ppVVm4ZpwhY9t7jIefE6NabGZERraMEWtXEhbAtL
U2PWOtnwDge26H7gcY6mETXm+7PdrQ8XsOiVNHaOtxHUmDt06kJ4aywqpfwP
dyKKGrNdhuvE2GFRjfnE4MgYasyR8n23NEcs+vw6NzE26T+9WYcKRw8sWlF0
BZeeRY3RHchSI32LRfUaxILqGqkx8w98ba9kY1FrLPGOSis1xofrAn1oPhZ9
QVey0dpOjWl4XZO7WohFk7RuP+rupcbo3Di5VVqJRef6MHcmJqkxRj9KX6t3
YNG9F2Qb1rPUmKjrtvz53ViU4VxdxvwCNaZDhvUvywAWFTVXZl1fp8bMrHqf
HhnDooqktO2uRGpMSqhIifw0Fr3/reX1zg41hiNtxvjHPBa1UwyT9jmgxmhK
fTmiX8GivrOahONjaoy8olGqEwGL/g9mOPrU
           "]]},
         Annotation[#, "Charting`Private`Tag$389901#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVV3c01o8XtiIko0RWvBKREULW56XMjOwyS1aZL6KyChmZkVVm38gmW+h+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           "]]},
         Annotation[#, "Charting`Private`Tag$389901#3"]& ], 
        TagBox[
         {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVl2c81n8fxe3LlpCRsrKSkZCV76XsWXZGSZJQISulISshyd4qKnukyPj8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           "]]},
         Annotation[#, "Charting`Private`Tag$389901#4"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-2., -353.86295792435044`},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-400., 
           FormBox[
            RowBox[{"-", "400"}], TraditionalForm]}, {-300., 
           FormBox[
            RowBox[{"-", "300"}], TraditionalForm]}, {-200., 
           FormBox[
            RowBox[{"-", "200"}], TraditionalForm]}, {-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-400., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-380., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-360., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-340., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-320., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-280., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-260., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-176.93147896217522`, 
           FormBox[
            StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False]
            , TraditionalForm], 0}}, {{-400., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-400., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-380., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-360., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-340., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-320., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-280., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-260., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {3., 
           FormBox["1000", TraditionalForm]}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {3., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-2., 3}, {-353.86295792435044`, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-2., 
          FormBox["0.01`", TraditionalForm]}, {-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {3., 
          FormBox["1000", TraditionalForm]}, {-1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.5228787452803376`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.2218487496163564`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.0969100130080565`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.045757490560675, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.4771212547196626`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6020599913279625`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.7781512503836434`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9030899869919438`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9542425094393248`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-400., 
          FormBox[
           RowBox[{"-", "400"}], TraditionalForm]}, {-300., 
          FormBox[
           RowBox[{"-", "300"}], TraditionalForm]}, {-200., 
          FormBox[
           RowBox[{"-", "200"}], TraditionalForm]}, {-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-400., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-380., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-360., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-340., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-320., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-300., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-300., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-280., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-260., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-240., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-220., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-180., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-160., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-140., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-120., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-176.93147896217522`, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1Xk4lN8XAPCxTmSPUJKkIpGIkup9RZaQkrVkn6nkSyQqFW20WAolZatI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           "]]},
         Annotation[#, "Charting`Private`Tag$390496#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1nk41F8XAPCxTtGCbJVsbSQKIZH7lbKLZEtIkkp+1plRKmlD2SoUSVRo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           "]]},
         Annotation[#, "Charting`Private`Tag$390496#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV13c41t//B/DbbdyVlD1KMho0CBGh8zYyKpTMspJU8qWPvd0lozIqhCJS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           "]]},
         Annotation[#, "Charting`Private`Tag$390496#3"]& ], 
        TagBox[
         {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV03c81d8bAPDrutyIskdJqERGISJ0PpWsQsnIjkolX0oyUva9ym4oQmlo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           "]]},
         Annotation[#, "Charting`Private`Tag$390496#4"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-2., -717.9373401081552},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-800., 
           FormBox[
            RowBox[{"-", "800"}], TraditionalForm]}, {-600., 
           FormBox[
            RowBox[{"-", "600"}], TraditionalForm]}, {-400., 
           FormBox[
            RowBox[{"-", "400"}], TraditionalForm]}, {-200., 
           FormBox[
            RowBox[{"-", "200"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-800., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-750., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-700., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-650., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-600., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-600., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-550., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-500., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-450., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-400., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-400., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-350., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-250., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-358.9686700540776, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-800., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-600., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-400., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-800., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-750., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-700., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-650., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-600., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-600., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-550., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-500., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-450., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-400., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-400., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-350., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-250., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {3., 
           FormBox["1000", TraditionalForm]}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {3., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-2., 3}, {-717.9373401081552, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-2., 
          FormBox["0.01`", TraditionalForm]}, {-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {3., 
          FormBox["1000", TraditionalForm]}, {-1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.5228787452803376`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.2218487496163564`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.0969100130080565`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.045757490560675, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.4771212547196626`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6020599913279625`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.7781512503836434`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9030899869919438`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9542425094393248`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-800., 
          FormBox[
           RowBox[{"-", "800"}], TraditionalForm]}, {-600., 
          FormBox[
           RowBox[{"-", "600"}], TraditionalForm]}, {-400., 
          FormBox[
           RowBox[{"-", "400"}], TraditionalForm]}, {-200., 
          FormBox[
           RowBox[{"-", "200"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-800., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-750., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-700., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-650., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-600., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-600., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-550., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-500., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-450., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-400., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-400., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-350., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-300., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-250., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-150., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-358.9686700540776, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.5083344209083023`*^9, 3.5083348164229097`*^9, 3.508334848126631*^9, {
   3.508334881444807*^9, 3.5083349315963173`*^9}, 3.5083358698430758`*^9, 
   3.50833599115868*^9, 3.5083360644163218`*^9, {3.508336141115041*^9, 
   3.508336167631567*^9}, 3.508336366594329*^9, 3.508337349091877*^9, 
   3.5083373827726507`*^9, {3.508337447193748*^9, 3.508337506191229*^9}, 
   3.5083386910958443`*^9, 3.508338723833703*^9, 3.5083649374662457`*^9, 
   3.508512479400319*^9, 3.508519272093215*^9, 3.75389837876118*^9, 
   3.75389892787531*^9, 3.793328702385065*^9, {3.7933288257018337`*^9, 
   3.793328853340795*^9}, 3.793893151113752*^9, 3.793893304535305*^9, {
   3.7938934084246063`*^9, 3.793893421795879*^9}, 3.793893689141202*^9, 
   3.8232245224052343`*^9},
 FontSize->12,
 CellLabel->
  "Out[630]=",ExpressionUUID->"11b78a80-2852-48a5-ba44-1d03db6c47e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmax", " ", "=", " ", "10"}], ";", 
  RowBox[{"u0", " ", "=", " ", 
   RowBox[{
    RowBox[{"UnitStep", "[", 
     RowBox[{"t", "-", "1"}], "]"}], "-", " ", 
    RowBox[{"UnitStep", "[", 
     RowBox[{"t", "-", "5"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y2", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"b2tf", ",", "u0", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y4", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"b4tf", ",", "u0", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"y5", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"b5tf", ",", "u0", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"y6", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"b6tf", ",", "u0", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"y8", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"b8tf", ",", "u0", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"y10", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"b10tf", ",", "u0", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "u0", ",", "y2", ",", "y4", ",", "y5", ",", "y6", ",", "y8", ",", 
      "y10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "4"}], "}"}], ",", 
    RowBox[{"Exclusions", "\[Rule]", "None"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.508334512245377*^9, 3.508334516068138*^9}, {
  3.508334790500945*^9, 3.50833483944488*^9}, {3.5083348734552507`*^9, 
  3.508334927294482*^9}, {3.508336059457315*^9, 3.508336059528625*^9}, {
  3.793893285909834*^9, 3.7938932897658577`*^9}, {3.793893567362577*^9, 
  3.793893657527699*^9}},
 FontSize->12,
 CellLabel->
  "In[631]:=",ExpressionUUID->"eb6b0ec4-b0b7-49c6-9927-0f987701e995"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxNzgss1AEcB/C7Q05XdyiPPzum6EWPCTdNnciOi7XkFqVLQqVV16WZVtPp
9LpIZnWFnOjhecpRm4q4VZOopWRx6naTx+EoJ9RdtfH7+W2//fbZvvvu5xJ7
LDyeQiKRIv/t/8uN73vf0H9yE2lmTAMdBD1EBHvW6wukedVEHHjr245H+UQS
eGfcxLNsQgzuXnshMIPIActstp2/TBSDRdTq5ZcIBTgyqlCuG1WCaUZRNMep
Dey2fbivSdIOTm71ZUt/doLtFFYqMrkHXKsObGnzU4MbE/Mdo7Qa8PiyjYyK
I9/BlMkyS0e3AbCPMaZ2R6UWHBrWkBb0BL0/13kbqxGdxVJ9d/iE7j+2m1D/
Qed95Z0WhA2ByY3cgAwt2t6ylJ6qR6/hW3wRkIbBu6ZenYhYjFZ4Bt119EMn
FLGppRJ0i9ir9eWqEfAGxhvKNW/0g5v7WLv90ecqM2UjvDn5z31Ce9GcfGzq
fbUEbTtk01V+HT1KDgzaXI7mX+lMoT1Gt9gKKj++mNPnnm+X2DGnr3Z9qJca
LfZvPmvQoseaY2peT6CrSqeTQsi6GevYTt7ZJYsWoCX1K1TdtuiEdh5H6IEO
6E+rmheArvJj8SKlaOeswcmSYbSZMl5bf3UUPDjRo/q4bgxcPFDXTM/8AaYz
749oND/BVw7VJMhc9WC9f5nmYOoEOMlTqbBt+gXuqVRK3rtMgacT23NXnpoG
u282NyTU/QZz7rgceGhnACcz9y75Fm0Ee2h5tI4wkv+sFzF0VOUU2rQ+V740
jww+7FXXabGVAi4LiZU916PHBx0se6+bgGt2cExytpiCU4PTCxS9aJdu7uei
dDPwBpY4h/CcB452apskf0CPN2eoBSJzsNSUnxTuSsX/VTV3KEq02RlRhO9x
CzCphC9XW88HC2/JM6wb0c/cL1KtjtLAVlyhRxp9Abhr9bsPKU/RVbfZrhr+
QvAeuY8V04A+m14o6iqlgyv6mLn0UAZ4iXhxsPk99A1n2rjRiP4LlDSE9w==

       "]]},
     Annotation[#, "Charting`Private`Tag$395192#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxN1Qk01dsaAHBTnMsZDCVH6CmhQWkiim8brjllKHUzlyGVJDdjt0yRjOXJ
WKaKcJCpZQ5JLiIileNeZDz8/8csxfu/td473b3WXnv91vr2Xt+317f2lnW8
au7Ew8XFlU/M/65GTuNd9RO/a3L9b/DpSHoM0i3h/z74ODG1hH6BY+P2vhdp
dC+OrS4s1dynh3A8sC9MJ4oez3H6phN3IujZHAeSShTu0ks5PnM2oxBnN3Es
tB5orS/zjuMdZjPjjfd6OPbuUIPE+X6ON5eKMLm5BzkuH9Jpe3dsiOMGt7Qt
Z1kjHC/Ia9AKroxxzLOSJ7xlxyTHKuv25RYMFsdtIYc6mndhHKvT/uSJO/zT
OUkOqufQTwczotOxU/+I/zjuKRH4j/jdaZvd+n5avPygyaGhnw5BrbfXWD89
22pf1rL000XPV70MuXHYIjARcpwZrDmG6cUw+HE4rc4c3lXRqSlz+H6uGBmH
FvGdk/K6U5qWfgONPiI4zPJdFtl867vmvTpF5oA4DlGLtRcZdiRo4PNa1pbC
oYtxxOncQ1FYNqwTzZHFYShMvXjeUhL2xQgqURRwyBybzc0qkQXnnlP6nntw
aBN4fzFgVB7S6BkOfftxCFutsbVq2AM9tiz/Y6o4tD5LadPJ2g9C2aoJGcdw
6O4SzVRWOwzaE0FF/No4NAmPOKduUwPfvR2tl/RxkOY/abnfTgOKrtO/dprg
sOgy891kCYHMWiE9xQqH93c/aBjy6MEpndWDXDY4zAk6ahx7bQCR4XqmTo44
zIsW+GBFxrAiOhC07woOuCeVvsRlBspnFNPiPXFoCNVQu1piDs5p1ytWvHGY
tBnLmPG1hB4FQVZjEA6iHV/DS7TPQNEx1VNnEnGQsnqQ+8DeHsYCg67WpOHQ
7OPI+BDuADJv2u9uy8LB41Lugz8rHSHS7EItqwCHD9+qpPOOOoGrc5xCYCMO
fjr1PNuK3OBx3het0RYcit0lmVNyl6EXV7A27sBBuF++l551BXT9a2M39eOg
1KUmXWPjAVtjp1ZyZ3BQabLsTi64DrUOt3JfzOHguid9+/RNL7A9KHa2apnI
/8DWhIPmv0Nqr/rLNh42tC3cYUTye4OEdMQNTJwNRaef6K2l+YHoc8W5Q8AG
s09WAru1A6HYvzpTQ5cN0ckdybxvA+Hk8ZPmeoZsUPf7I6fcLAhicO9iKws2
+KuXf852DQay6purfi5smNxXq+WeHwobmpxYdTFsmA2Yo0hGRED2v1dSWuLZ
IIdUJWqV7oGuS5RxVxIbyAXOWlu770GQYNnzoSw2DO0oSxLZHgVrJ/kubnjJ
hiv8hjzBfTGwPJD51egvNrwkhX/6o+U+TC0NMj8oz4In2d78k1QSlLvENBip
zILkV+9XvXFJcLtP82nd0VmQ8JAKqxBIBvGKtCu5erOwqcV0QHYxGbRvnPse
YD0LQbl7FQMGUiF5vpcuF05YS8+lwC0dDNjtlp6Ds5BczRt2oDgbsierWqnR
c7DSYr9ywoYB7g9PbHd7MAcC23e49TIYoKo77P86cQ7cDLan53MVQmuaoFJA
1hxsvCtQq/ekENgnz8ZMvJyD+IWQI2K+RaBZsWjRNDwHjzTPJ0q1F0N/8P4B
X7V5eJHUuXYpthSo0s+wkZF5mJS91CXpWwmRF8uc0+UWoVtllFvWpBEWUd6I
660lyL/dkD3o3gpeB5pKxRuXobCy+Vfyi04YZDTd65L9BpWZ77HZ0B5YdetJ
2em3Cg2tho87tT7Cbi2BNeeq72D+qPu+ae5n0M+UdSnevAaZfGIfKUcGwVva
btvf1uugJ+GULrH/b9jDOiXUd5wLmd4xJpXlDIEYDSc1feNCYfPtZYfkR4Cv
LqVweyo3sp0ynOz1+AqXDlX1/2LMg5iO8SBXNQp5ho7ptYs8aOuw0EGd4TFY
mJIUHk3gRTeNgupYzHEos9DnjdflQ/kqN+JFeyfglkHo49JRPtTSYPCs8skk
yA4YfcwK3YCKjyR8HrWeAnXVkHj6AX4UEqUM+lQWWMu8W+Hu5kdtyplWMhks
WGiNGvIIFECsYn1WnNI0JPLZepnLkRDT7q/mxPRpEGOWZfI0kdA9cktWIu8M
bLgZaKl27Re0If7aKLfDDHDl2hYOiQqize2V4efyZ8AzuTBKtEEQaUTRSf6z
M1CzO5wk4i6E2m57DbL3YCBi5LkniEpGESbCSO8cBumvaELqImQkHnBeep2w
slrBBFuMjNTHfvWusMbAVHH8qQOdjMT6ezPkbTGI4LeV1ZIjowTSWv+aPQZ8
jYbiXOpkxAwibXrojMHiUVmuP5zIKKdnKdf1GgZflDq7favJKCRY6+OjUAwe
T4nc5K0j9j/hrdl7BwPHXAv5qFdkJOpWqlFLeEKuzye9mYyizYvEvoQR521h
Sr/pJCPvqfLNYhFE/oIsl41fycggcmeBezQGeqMC3xkUCrrPu3RjIAGDokcg
N2JLQafd6iuzn2Iw5zcn4OBAQXZjJzoln2GgYvVsauA8BdXn5cTFEq6i0Ur6
XClIKstewj8Hg+bbTK0/PSlIySde3eQ5Bp8db9q9uENBR7bYLDELMOBXqEq+
zaAgTa0fAW9KMbApVBGRXqMgCtZJZrzCoPy3ZWonFxWFSDVVSTRgQOWvJAfz
UhHprsLGYML11hqkCRIVBf2QaDjdiME2Qd31UjEqShBMlfjWhMHoBbNpk51U
5CesPKDcgoG75OW3AZZUJLVEFbbvwOB2aEbgl+dUxDNm7vquHwOKt4CRQwEV
US+W7vrXJwySXa+IjhZSkfWoTL4H4RJjtSyslIoU3z5jCX8mzhfpauKpoyJP
VoWr6RcMjB9xkXZ2U5FNnL57DRMj3h+76N9XqUg+rrvy8jAGBePSKVQTGjqm
520kQfzj4Wmh9kxTGtJ2PhHrQPiC+fQOhhkNvauF2OeEpaqri45b0ZDwAZm6
o9NEv8Sca450pCFS++uB32YwcFVJYgv60hD/IRu9SJyoP2SjgcBTGgqqe8hd
M4/B2pEASl8ODfl+2Dv0g3D/9PD7p3k05DZ+J0hzAYNYqxIbvWIaapPex1tH
eH2X+fXQahq64WnxS80i0W9dMY94u2kofNvdkwXLGLy8s3S++wMNDY27ak8S
jj9qtzPrIw15UpmL8itE/U/2lmozaag2RiPnMeFKn/a3gRM0NCv+en/0NwwS
lA7HmLFoqD9IR+Mt4WtDqZayGA3JrdWT+VYxUDS5PFg/T0MjJhbLPoT5uHuy
Y5doqHOqZGMJ4b/KjrrZfyPuzzZ/gUW42i1rn/IPGuJ745gi/x2Dh1uFFtbX
aYjb8McGe8L/AVLTy94=
       "]]},
     Annotation[#, "Charting`Private`Tag$395192#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxN13c4lW/cAHDzOOfBOaJkZzRsskXne4ckI2S0kBUlGlIqDVlZUVJSFFJJ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       "]]},
     Annotation[#, "Charting`Private`Tag$395192#3"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxN2Hk41F+4AHD7DMYMKSLJUraUigg170lIsoZSkZItkVISEbIkslRkj6KU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       "]]},
     Annotation[#, "Charting`Private`Tag$395192#4"]& ], 
    TagBox[
     {RGBColor[0.528488, 0.470624, 0.701351], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxN2Xk81N8XMHDrDDOTyZIQKvUtOxXZ51yRJVpQUaESKlmyVZJItspWiQoR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       "]]},
     Annotation[#, "Charting`Private`Tag$395192#5"]& ], 
    TagBox[
     {RGBColor[0.772079, 0.431554, 0.102387], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxN2Hk4lc8bMHDLOcc5HE4hIi2kErKEZDv3iFT2tUURoiRLiZJSCClLKm2W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       "]]},
     Annotation[#, "Charting`Private`Tag$395192#6"]& ], 
    TagBox[
     {RGBColor[0.363898, 0.618501, 0.782349], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxN2Xk4lF/4MHDLjDFjFmuyJWtEsldkzglZklCUhJAkIVkqSWRLZQsJIbRJ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       "]]},
     Annotation[#, "Charting`Private`Tag$395192#7"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7938936696636953`*^9, 3.7938936961529703`*^9}, 
   3.823224530371558*^9},
 CellLabel->
  "Out[633]=",ExpressionUUID->"0e9122b0-f719-4ab6-a517-c874f5c6a738"]
}, Open  ]],

Cell["Look at state-space representations :", "Text",
 CellChangeTimes->{{3.508364945864127*^9, 3.508364965354784*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"618c9bb6-d5b7-48bb-a3ea-6519bf51be98"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"b2sys", " ", "=", " ", 
    RowBox[{"StateSpaceModel", "[", "b2tf", "]"}]}], ",", 
   RowBox[{"b4sys", " ", "=", " ", 
    RowBox[{"StateSpaceModel", "[", "b4tf", "]"}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.5083649821605253`*^9, 3.5083649999404716`*^9}, {
  3.7938933185159597`*^9, 3.7938933251116*^9}},
 FontSize->12,
 CellLabel->
  "In[634]:=",ExpressionUUID->"ac3cdb3d-2dda-4815-92af-b3a003291527"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"0", "1", "0", 
     RowBox[{"-", "3"}], 
     RowBox[{"-", "3"}], "1", "3", "0", "0", 
     InterpretationBox["\[InvisibleSpace]", None], {
     StateSpaceModel, {
      False, False, {
       False, False}}, {$CellContext`stname1, $CellContext`stname2}, {{
       Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}, {
       Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, Identity, 
      Automatic, 1, 1, 2, 1, {}, {False, False}, False, Automatic, None, 
      Automatic}, {}},
    "StateSpaceModelFull",
    BaseStyle->{NumberMarks -> False},
    DisplayFunction->(TagBox[
      SubsuperscriptBox[
       RowBox[{"(", 
         GridBox[{{#, #2, #3}, {#4, #5, #6}, {#7, #8, #9}}, 
          AllowedDimensions -> {3, 3}, 
          GridBoxDividers -> {"Rows" -> {False, False, 
              Directive[
               GrayLevel[0], 
               GrayLevel[0.6]], {False}, False}, "Columns" -> {False, False, 
              Directive[
               GrayLevel[0], 
               GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
          "SystemsModelGrid00"], ")"}], #10, 
       ButtonBox[
        GraphicsBox[{
          RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
          InsetBox[
           StyleBox[
           "\[ScriptCapitalS]", DefaultBaseStyle -> 
            "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
        ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
          ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
        None], MultilineFunction -> None], 
      EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
            FrontEnd`Value[
             FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
        True}]]& ),
    InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
       RowBox[{"{", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{1, 2}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{4, 5}, ","], "}"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{3, 3}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{6, 6}, ","], "}"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{7, 8}, ","], "}"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{9, 9}, ","], "}"}], "}"}], "}"}], ",", 
       "SamplingPeriod", "->", 
       RowBox[{#10}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
    Tooltip->StateSpaceModel], ",", 
   TemplateBox[{
    "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "1", "0", 
     RowBox[{"-", "105"}], 
     RowBox[{"-", "105"}], 
     RowBox[{"-", "45"}], 
     RowBox[{"-", "10"}], "1", "105", "0", "0", "0", "0", 
     InterpretationBox["\[InvisibleSpace]", None], {
     StateSpaceModel, {
      False, False, {
       False, False}}, {$CellContext`stname1, $CellContext`stname2, \
$CellContext`stname3, $CellContext`stname4}, {{Control`CommonDump`$DUMMY$}, {
       Control`CommonDump`$DUMMY$}, {
       Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$, 
        Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, Identity, 
      Automatic, 1, 1, 4, 1, {}, {False, False}, False, Automatic, None, 
      Automatic}, {}},
    "StateSpaceModelFull",
    BaseStyle->{NumberMarks -> False},
    DisplayFunction->(TagBox[
      SubsuperscriptBox[
       RowBox[{"(", 
         GridBox[{{#, #2, #3, #4, #5}, {#6, #7, #8, #9, #10}, {#11, #12, #13, \
#14, #15}, {#16, #17, #18, #19, #20}, {#21, #22, #23, #24, #25}}, 
          AllowedDimensions -> {5, 5}, 
          GridBoxDividers -> {"Rows" -> {False, False, False, False, 
              Directive[
               GrayLevel[0], 
               GrayLevel[0.6]], {False}, False}, 
            "Columns" -> {False, False, False, False, 
              Directive[
               GrayLevel[0], 
               GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
          "SystemsModelGrid00"], ")"}], #26, 
       ButtonBox[
        GraphicsBox[{
          RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
          InsetBox[
           StyleBox[
           "\[ScriptCapitalS]", DefaultBaseStyle -> 
            "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
        ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
          ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
        None], MultilineFunction -> None], 
      EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
            FrontEnd`Value[
             FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
        True}]]& ),
    InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
       RowBox[{"{", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{1, 4}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{6, 9}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{11, 14}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{16, 19}, ","], "}"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{5, 5}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{10, 10}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{15, 15}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{20, 20}, ","], "}"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{21, 24}, ","], "}"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{25, 25}, ","], "}"}], "}"}], "}"}], ",", 
       "SamplingPeriod", "->", 
       RowBox[{#26}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
    Tooltip->StateSpaceModel]}], "}"}]], "Output",
 CellChangeTimes->{
  3.508365000902452*^9, 3.508512480114944*^9, 3.508519272820166*^9, 
   3.753898379567627*^9, 3.75389892860576*^9, 3.7933287028502417`*^9, 
   3.79332885398044*^9, 3.793893158829855*^9, {3.793893304862399*^9, 
   3.7938933256177597`*^9}, {3.7938934088047457`*^9, 3.7938934222292337`*^9}, 
   3.7938936963594503`*^9, 3.8232245305305557`*^9},
 FontSize->12,
 CellLabel->
  "Out[634]=",ExpressionUUID->"7a2f2cf6-6c31-43c5-929e-27ec9a312877"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"b6sys", " ", "=", " ", 
    RowBox[{"StateSpaceModel", "[", "b6tf", "]"}]}], ",", 
   RowBox[{"b8sys", " ", "=", " ", 
    RowBox[{"StateSpaceModel", "[", "b8tf", "]"}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.5083650170248327`*^9, 3.5083650199663887`*^9}, {
  3.7938933363166447`*^9, 3.793893339138496*^9}},
 FontSize->12,
 CellLabel->
  "In[635]:=",ExpressionUUID->"23c50bb3-f8d3-409d-a06c-121ca23bb4d6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{
    "0", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0",
      "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", 
     "0", "0", "0", "0", "1", "0", 
     RowBox[{"-", "10395"}], 
     RowBox[{"-", "10395"}], 
     RowBox[{"-", "4725"}], 
     RowBox[{"-", "1260"}], 
     RowBox[{"-", "210"}], 
     RowBox[{"-", "21"}], "1", "10395", "0", "0", "0", "0", "0", "0", 
     InterpretationBox["\[InvisibleSpace]", None], {
     StateSpaceModel, {
      False, False, {
       False, False}}, {$CellContext`stname1, $CellContext`stname2, \
$CellContext`stname3, $CellContext`stname4, $CellContext`stname5, \
$CellContext`stname6}, {{Control`CommonDump`$DUMMY$}, {
       Control`CommonDump`$DUMMY$}, {
       Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$, 
        Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$, 
        Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, Identity, 
      Automatic, 1, 1, 6, 1, {}, {False, False}, False, Automatic, None, 
      Automatic}, {}},
    "StateSpaceModelMinimal",
    BaseStyle->{NumberMarks -> False},
    DisplayFunction->(TagBox[
      SubsuperscriptBox[
       RowBox[{"(", 
         GridBox[{{#, 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", 
               "SystemsModelMinimalElement"]], #2], #3, #4, #5, #6, #7}, {#8, \
#9, 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", 
               "SystemsModelMinimalElement"]], #10], #11, #12, #13, #14}, \
{#15, #16, #17, 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", 
               "SystemsModelMinimalElement"]], #18], #19, #20, #21}, {#22, \
#23, #24, #25, 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", 
               "SystemsModelMinimalElement"]], #26], #27, #28}, {#29, #30, \
#31, #32, #33, 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", 
               "SystemsModelMinimalElement"]], #34], #35}, {
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #36], 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #37], 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #38], 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #39], 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #40], 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #41], 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #42]}, {
           
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", 
               "SystemsModelMinimalElement"]], #43], #44, #45, #46, #47, #48, \
#49}}, AllowedDimensions -> {7, 7}, 
          GridBoxDividers -> {
           "Rows" -> {False, False, False, False, False, False, 
              Directive[
               GrayLevel[0], 
               GrayLevel[0.6]], {False}, False}, 
            "Columns" -> {False, False, False, False, False, False, 
              Directive[
               GrayLevel[0], 
               GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
          "SystemsModelGrid00"], ")"}], #50, 
       ButtonBox[
        GraphicsBox[{
          RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
          InsetBox[
           StyleBox[
           "\[ScriptCapitalS]", DefaultBaseStyle -> 
            "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
        ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
          ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
        None], MultilineFunction -> None], 
      EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
            FrontEnd`Value[
             FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
        True}]]& ),
    InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
       RowBox[{"{", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{1, 6}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{8, 13}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{15, 20}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{22, 27}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{29, 34}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{36, 41}, ","], "}"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{7, 7}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{14, 14}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{21, 21}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{28, 28}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{35, 35}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{42, 42}, ","], "}"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{43, 48}, ","], "}"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{49, 49}, ","], "}"}], "}"}], "}"}], ",", 
       "SamplingPeriod", "->", 
       RowBox[{#50}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
    Tooltip->StateSpaceModel], ",", 
   TemplateBox[{
    "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0",
      "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", 
     "0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", 
     "0", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", 
     "0", "0", "0", "0", "1", "0", 
     RowBox[{"-", "2027025"}], 
     RowBox[{"-", "2027025"}], 
     RowBox[{"-", "945945"}], 
     RowBox[{"-", "270270"}], 
     RowBox[{"-", "51975"}], 
     RowBox[{"-", "6930"}], 
     RowBox[{"-", "630"}], 
     RowBox[{"-", "36"}], "1", "2027025", "0", "0", "0", "0", "0", "0", "0", 
     "0", 
     InterpretationBox["\[InvisibleSpace]", None], {
     StateSpaceModel, {
      False, False, {
       False, False}}, {$CellContext`stname1, $CellContext`stname2, \
$CellContext`stname3, $CellContext`stname4, $CellContext`stname5, \
$CellContext`stname6, $CellContext`stname7, $CellContext`stname8}, {{
       Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}, {
       Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$, 
        Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$, 
        Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$, 
        Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, Identity, 
      Automatic, 1, 1, 8, 1, {}, {False, False}, False, Automatic, None, 
      Automatic}, {}},
    "StateSpaceModelMinimal",
    BaseStyle->{NumberMarks -> False},
    DisplayFunction->(TagBox[
      SubsuperscriptBox[
       RowBox[{"(", 
         GridBox[{{#, 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", 
               "SystemsModelMinimalElement"]], #2], #3, #4, #5, #6, #7, #8, \
#9}, {#10, #11, 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", 
               "SystemsModelMinimalElement"]], #12], #13, #14, #15, #16, #17, \
#18}, {#19, #20, #21, 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", 
               "SystemsModelMinimalElement"]], #22], #23, #24, #25, #26, \
#27}, {#28, #29, #30, #31, 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", 
               "SystemsModelMinimalElement"]], #32], #33, #34, #35, #36}, \
{#37, #38, #39, #40, #41, 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", 
               "SystemsModelMinimalElement"]], #42], #43, #44, #45}, {#46, \
#47, #48, #49, #50, #51, 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", 
               "SystemsModelMinimalElement"]], #52], #53, #54}, {#55, #56, \
#57, #58, #59, #60, #61, 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", 
               "SystemsModelMinimalElement"]], #62], #63}, {
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #64], 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #65], 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #66], 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #67], 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #68], 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #69], 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #70], 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #71], 
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #72]}, {
           
            TooltipBox[
             StyleBox[
              StyleBox[
              "\[FilledSmallSquare]", 
               "SystemsModelMinimalElement"]], #73], #74, #75, #76, #77, #78, \
#79, #80, #81}}, AllowedDimensions -> {9, 9}, 
          GridBoxDividers -> {
           "Rows" -> {
             False, False, False, False, False, False, False, False, 
              Directive[
               GrayLevel[0], 
               GrayLevel[0.6]], {False}, False}, 
            "Columns" -> {
             False, False, False, False, False, False, False, False, 
              Directive[
               GrayLevel[0], 
               GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
          "SystemsModelGrid00"], ")"}], #82, 
       ButtonBox[
        GraphicsBox[{
          RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
          InsetBox[
           StyleBox[
           "\[ScriptCapitalS]", DefaultBaseStyle -> 
            "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
        ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
          ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
        None], MultilineFunction -> None], 
      EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
            FrontEnd`Value[
             FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
        True}]]& ),
    InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
       RowBox[{"{", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{1, 8}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{10, 17}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{19, 26}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{28, 35}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{37, 44}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{46, 53}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{55, 62}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{64, 71}, ","], "}"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{9, 9}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{18, 18}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{27, 27}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{36, 36}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{45, 45}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{54, 54}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{63, 63}, ","], "}"}], ",", 
           RowBox[{"{", 
             TemplateSlotSequence[{72, 72}, ","], "}"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{73, 80}, ","], "}"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"{", 
             TemplateSlotSequence[{81, 81}, ","], "}"}], "}"}], "}"}], ",", 
       "SamplingPeriod", "->", 
       RowBox[{#82}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
    Tooltip->StateSpaceModel]}], "}"}]], "Output",
 CellChangeTimes->{
  3.508365020679154*^9, 3.508512480251033*^9, 3.508519272923715*^9, 
   3.7538983798739767`*^9, 3.7538989290266523`*^9, 3.7933287030853167`*^9, 
   3.793328854214737*^9, 3.793893159002962*^9, 3.793893305030004*^9, 
   3.793893339573515*^9, {3.7938934089519587`*^9, 3.793893422369809*^9}, 
   3.7938936964999247`*^9, 3.823224530660624*^9},
 FontSize->12,
 CellLabel->
  "Out[635]=",ExpressionUUID->"09dc6fd4-fe53-4fd7-8e3e-676d58e263c1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Look at group delay properties of Bessel filters", "Section",
 CellChangeTimes->{{3.508510630990398*^9, 3.5085106453322363`*^9}},
 FontSize->18,ExpressionUUID->"35758e8f-905d-4fb1-9b4f-ca11361c86c7"],

Cell["\<\
(this is actually how they are defined -- having the flattest group delay vs \
\[Omega])\
\>", "Text",
 CellChangeTimes->{{3.5085106496930017`*^9, 3.5085106768834963`*^9}},
 FontSize->14,ExpressionUUID->"0141f0d1-88c6-4b42-a80f-4ff0bba7ad9d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b2", " ", "=", " ", 
  RowBox[{
   FractionBox["3", 
    RowBox[{"3", "+", 
     RowBox[{"3", "s"}], " ", "+", " ", 
     RowBox[{"s", "^", "2"}]}]], " ", "/.", " ", 
   RowBox[{"s", "\[Rule]", 
    RowBox[{"I", " ", "\[Omega]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.508512424156039*^9, 3.50851243110107*^9}, 
   3.508512473885559*^9, {3.508512840818863*^9, 3.508512845096059*^9}, {
   3.508513375142514*^9, 3.508513375524686*^9}, {3.5085135555797663`*^9, 
   3.508513593133535*^9}, {3.508513623280024*^9, 3.508513646667737*^9}},
 FontSize->12,
 CellLabel->
  "In[636]:=",ExpressionUUID->"d52b9de3-fdff-442f-a63d-55fa3b074c58"],

Cell[BoxData[
 FractionBox["3", 
  RowBox[{"3", "+", 
   RowBox[{"3", " ", "\[ImaginaryI]", " ", "\[Omega]"}], "-", 
   SuperscriptBox["\[Omega]", "2"]}]]], "Output",
 CellChangeTimes->{
  3.5085124804326277`*^9, 3.508512845679924*^9, 3.508513376767995*^9, {
   3.5085135678826714`*^9, 3.508513648360359*^9}, 3.508519273020479*^9, 
   3.7538983801718903`*^9, 3.753898929428094*^9, 3.793328703273006*^9, 
   3.7933288543545227`*^9, 3.79389315913675*^9, 3.7938933051570587`*^9, {
   3.7938934090048237`*^9, 3.793893422412771*^9}, 3.793893696541926*^9, 
   3.823224530700206*^9},
 FontSize->12,
 CellLabel->
  "Out[636]=",ExpressionUUID->"e5e48100-d85f-4421-ba35-3e8db477b74f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Phi]2", " ", "=", 
  RowBox[{
   RowBox[{"ArcTan", "[", " ", 
    FractionBox[
     RowBox[{
      RowBox[{"Refine", "[", 
       RowBox[{
        RowBox[{"Im", "[", " ", 
         RowBox[{"ComplexExpand", "[", "b2", "]"}], "]"}], ",", 
        RowBox[{"\[Omega]", "\[Element]", 
         TemplateBox[{},
          "Reals"]}]}], "]"}], " "}], 
     RowBox[{"Refine", "[", 
      RowBox[{
       RowBox[{"Re", "[", " ", 
        RowBox[{"ComplexExpand", "[", "b2", "]"}], "]"}], ",", 
       RowBox[{"\[Omega]", "\[Element]", 
        TemplateBox[{},
         "Reals"]}]}], "]"}]], "]"}], "//", " ", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.508514350366222*^9, 3.508514386327721*^9}, {
  3.5085145629380293`*^9, 3.508514588748706*^9}, {3.508514626014386*^9, 
  3.508514671665339*^9}, {3.508515262518416*^9, 3.508515267077776*^9}, {
  3.753898613455337*^9, 3.753898616373171*^9}},
 FontSize->12,
 CellLabel->
  "In[637]:=",ExpressionUUID->"1e2a5f35-ffe6-42d1-9d0c-1fbf2a32b551"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"ArcTan", "[", 
   FractionBox[
    RowBox[{"3", " ", "\[Omega]"}], 
    RowBox[{"3", "-", 
     SuperscriptBox["\[Omega]", "2"]}]], "]"}]}]], "Output",
 CellChangeTimes->{{3.508514371282761*^9, 3.5085143875994253`*^9}, {
   3.508514568466035*^9, 3.5085145891836987`*^9}, {3.508514660786161*^9, 
   3.508514672237048*^9}, 3.5085152685630503`*^9, 3.508519273068712*^9, 
   3.753898380238461*^9, 3.753898617468061*^9, 3.753898929528708*^9, 
   3.793328703337075*^9, 3.793328854417564*^9, 3.793893159183743*^9, 
   3.7938933051884413`*^9, {3.793893409046324*^9, 3.79389342244326*^9}, 
   3.7938936965685596`*^9, 3.823224530721361*^9},
 FontSize->12,
 CellLabel->
  "Out[637]=",ExpressionUUID->"d45a7a55-4d1f-4ad7-b437-2c392101177e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d2", " ", "=", " ", 
  RowBox[{
   RowBox[{"-", " ", 
    RowBox[{"D", "[", 
     RowBox[{"\[Phi]2", ",", "\[Omega]"}], "]"}]}], " ", "//", " ", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.508514740022915*^9, 3.508514762343658*^9}, {
  3.508514804915103*^9, 3.5085148448116617`*^9}, {3.508515293197094*^9, 
  3.508515315496497*^9}},
 FontSize->12,
 CellLabel->
  "In[638]:=",ExpressionUUID->"9489c345-9e31-47a3-8e36-9ab7113274b4"],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", 
     SuperscriptBox["\[Omega]", "2"]}], ")"}]}], 
  RowBox[{"9", "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["\[Omega]", "2"]}], "+", 
   SuperscriptBox["\[Omega]", "4"]}]]], "Output",
 CellChangeTimes->{
  3.5085147630198708`*^9, {3.508514816491536*^9, 3.508514845391473*^9}, 
   3.508515272011898*^9, {3.50851531056509*^9, 3.508515315947731*^9}, 
   3.508519273106586*^9, 3.7538983803239326`*^9, 3.753898929645225*^9, 
   3.793328703344768*^9, 3.793328854425722*^9, 3.793893159190342*^9, 
   3.793893305194254*^9, {3.793893409052766*^9, 3.793893422450471*^9}, 
   3.793893696574226*^9, 3.8232245307258873`*^9},
 FontSize->12,
 CellLabel->
  "Out[638]=",ExpressionUUID->"676e7502-2e8b-4ec4-807a-f66d4d97f67a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Tau]2", " ", "=", " ", 
  RowBox[{"Series", "[", 
   RowBox[{"d2", ",", 
    RowBox[{"{", 
     RowBox[{"\[Omega]", ",", "0", ",", "7"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.508515320506282*^9, 3.508515339787627*^9}},
 FontSize->12,
 CellLabel->
  "In[639]:=",ExpressionUUID->"d6e5d84d-a996-4c20-aa30-cb760d8a1e9f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["\[Omega]", "4"], "9"], "+", 
   FractionBox[
    SuperscriptBox["\[Omega]", "6"], "27"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Omega]", "]"}], "8"],
    SeriesData[$CellContext`\[Omega], 0, {}, 0, 8, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Omega], 0, {1, 0, 0, 0, 
    Rational[-1, 9], 0, 
    Rational[1, 27]}, 0, 8, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5085153307574043`*^9, 3.508515340552477*^9}, 
   3.508519273153309*^9, 3.753898380406563*^9, 3.753898929763297*^9, 
   3.793328703382576*^9, 3.793328854464904*^9, 3.793893159218993*^9, 
   3.7938933052231607`*^9, {3.793893409088778*^9, 3.793893422476699*^9}, 
   3.7938936965977182`*^9, 3.823224530730337*^9},
 FontSize->12,
 CellLabel->
  "Out[639]=",ExpressionUUID->"26b7018f-87fb-4b8f-87e9-39b46f092032"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n0", " ", "=", " ", "3"}], ";", " ", 
  RowBox[{"b3a", " ", "=", 
   FractionBox[
    RowBox[{"b", "[", 
     RowBox[{"n0", ",", "0"}], "]"}], 
    RowBox[{
     SubsuperscriptBox["\[Sum]", 
      RowBox[{"i", "=", "0"}], "n0"], 
     RowBox[{
      RowBox[{"b", "[", 
       RowBox[{"n0", ",", "i"}], "]"}], 
      SuperscriptBox["s", "i"]}]}]]}]}]], "Input",
 CellChangeTimes->{{3.50851502201341*^9, 3.508515070427781*^9}},
 FontSize->12,
 CellLabel->
  "In[640]:=",ExpressionUUID->"198b2b35-837b-4281-bd83-dd7147ed1b8c"],

Cell[BoxData[
 FractionBox["15", 
  RowBox[{"15", "+", 
   RowBox[{"15", " ", "s"}], "+", 
   RowBox[{"6", " ", 
    SuperscriptBox["s", "2"]}], "+", 
   SuperscriptBox["s", "3"]}]]], "Output",
 CellChangeTimes->{{3.508515056701417*^9, 3.508515071996921*^9}, 
   3.508519273210232*^9, 3.753898380489335*^9, 3.753898929879987*^9, 
   3.793328703389565*^9, 3.793328854561098*^9, 3.793893159226056*^9, 
   3.793893305229189*^9, {3.7938934090952883`*^9, 3.793893422483477*^9}, 
   3.793893696604114*^9, 3.823224530734552*^9},
 FontSize->12,
 CellLabel->
  "Out[640]=",ExpressionUUID->"0315e0b3-6949-4321-a4e3-a484392fe585"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b3", " ", "=", " ", 
  RowBox[{"b3a", " ", "/.", " ", 
   RowBox[{"s", "\[Rule]", " ", 
    RowBox[{"I", " ", "\[Omega]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.508515073156582*^9, 3.508515081412302*^9}},
 FontSize->12,
 CellLabel->
  "In[641]:=",ExpressionUUID->"611353ac-ffbf-4b79-935c-cd441ad1cdad"],

Cell[BoxData[
 FractionBox["15", 
  RowBox[{"15", "+", 
   RowBox[{"15", " ", "\[ImaginaryI]", " ", "\[Omega]"}], "-", 
   RowBox[{"6", " ", 
    SuperscriptBox["\[Omega]", "2"]}], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[Omega]", "3"]}]}]]], "Output",
 CellChangeTimes->{
  3.508515082247216*^9, 3.508519273255562*^9, 3.753898380574136*^9, 
   3.7538989299978123`*^9, 3.793328703425345*^9, 3.793328854570333*^9, 
   3.7938931592551928`*^9, 3.793893305255831*^9, {3.7938934091347227`*^9, 
   3.793893422508129*^9}, 3.793893696609614*^9, 3.823224530739917*^9},
 FontSize->12,
 CellLabel->
  "Out[641]=",ExpressionUUID->"513c75da-aad5-46bc-af1a-51a49aa65e01"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Phi]3", " ", "=", 
  RowBox[{
   RowBox[{"ArcTan", "[", " ", 
    FractionBox[
     RowBox[{
      RowBox[{"Refine", "[", 
       RowBox[{
        RowBox[{"Im", "[", " ", 
         RowBox[{"ComplexExpand", "[", "b3", "]"}], "]"}], ",", 
        RowBox[{"\[Omega]", "\[Element]", 
         TemplateBox[{},
          "Reals"]}]}], "]"}], " "}], 
     RowBox[{"Refine", "[", 
      RowBox[{
       RowBox[{"Re", "[", " ", 
        RowBox[{"ComplexExpand", "[", "b3", "]"}], "]"}], ",", 
       RowBox[{"\[Omega]", "\[Element]", 
        TemplateBox[{},
         "Reals"]}]}], "]"}]], "]"}], "//", " ", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.5085150957708607`*^9, 3.508515101252096*^9}, {
  3.508515356402878*^9, 3.508515363752771*^9}, {3.753898605311857*^9, 
  3.753898608101739*^9}},
 FontSize->12,
 CellLabel->
  "In[642]:=",ExpressionUUID->"fac41742-e6e2-4cd6-b8bd-2a1d07b0d6dc"],

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  FractionBox[
   RowBox[{"\[Omega]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "15"}], "+", 
      SuperscriptBox["\[Omega]", "2"]}], ")"}]}], 
   RowBox[{"15", "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["\[Omega]", "2"]}]}]], "]"}]], "Output",
 CellChangeTimes->{
  3.5085151024641848`*^9, 3.508515364778345*^9, 3.508519273307836*^9, 
   3.753898380658058*^9, 3.75389860905989*^9, 3.753898930179133*^9, 
   3.7933287034850273`*^9, 3.793328854617407*^9, 3.793893159359598*^9, 
   3.7938933052870827`*^9, {3.793893409176269*^9, 3.7938934225349607`*^9}, 
   3.793893696634495*^9, 3.823224530761176*^9},
 FontSize->12,
 CellLabel->
  "Out[642]=",ExpressionUUID->"e858dd4c-d054-42b7-807c-b5b96b0bb5ba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d3", " ", "=", " ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"D", "[", 
     RowBox[{"\[Phi]3", ",", "\[Omega]"}], "]"}]}], "  ", "//", " ", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.508515115251845*^9, 3.508515200955852*^9}},
 FontSize->12,
 CellLabel->
  "In[643]:=",ExpressionUUID->"2faad29f-fefc-40cd-bccc-035c9fbb5ed2"],

Cell[BoxData[
 FractionBox[
  RowBox[{"225", "+", 
   RowBox[{"45", " ", 
    SuperscriptBox["\[Omega]", "2"]}], "+", 
   RowBox[{"6", " ", 
    SuperscriptBox["\[Omega]", "4"]}]}], 
  RowBox[{"225", "+", 
   RowBox[{"45", " ", 
    SuperscriptBox["\[Omega]", "2"]}], "+", 
   RowBox[{"6", " ", 
    SuperscriptBox["\[Omega]", "4"]}], "+", 
   SuperscriptBox["\[Omega]", "6"]}]]], "Output",
 CellChangeTimes->{{3.5085151254431963`*^9, 3.508515201670063*^9}, 
   3.5085153707258797`*^9, 3.508519273387314*^9, 3.753898380741293*^9, 
   3.753898930412669*^9, 3.793328704136196*^9, 3.793328854626566*^9, 
   3.793893159370743*^9, 3.793893305293037*^9, {3.793893409182666*^9, 
   3.7938934225413303`*^9}, 3.793893696640707*^9, 3.823224530766012*^9},
 FontSize->12,
 CellLabel->
  "Out[643]=",ExpressionUUID->"9f49d5a6-fa82-4bc2-81ce-31e44d69f9b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Tau]3", " ", "=", " ", 
  RowBox[{"Series", "[", 
   RowBox[{"d3", ",", 
    RowBox[{"{", 
     RowBox[{"\[Omega]", ",", "0", ",", "9"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.508515388235752*^9, 3.508515417234659*^9}},
 FontSize->12,
 CellLabel->
  "In[644]:=",ExpressionUUID->"d6d207db-d5cc-4fa8-9e3a-1aeb9c812df1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["\[Omega]", "6"], "225"], "+", 
   FractionBox[
    SuperscriptBox["\[Omega]", "8"], "1125"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Omega]", "]"}], "10"],
    SeriesData[$CellContext`\[Omega], 0, {}, 0, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Omega], 0, {1, 0, 0, 0, 0, 0, 
    Rational[-1, 225], 0, 
    Rational[1, 1125]}, 0, 10, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.5085154178434973`*^9, 3.508519273444076*^9, 3.7538983808252373`*^9, 
   3.753898930531658*^9, 3.793328704671671*^9, 3.793328854666172*^9, 
   3.7938931594043703`*^9, 3.793893305322311*^9, {3.793893409220378*^9, 
   3.793893422570771*^9}, 3.793893696664812*^9, 3.8232245307888193`*^9},
 FontSize->12,
 CellLabel->
  "Out[644]=",ExpressionUUID->"0b8cc03f-9e9b-4bdb-9354-be30ec3870f9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n0", " ", "=", "4"}], ";", " ", 
  RowBox[{"b4a", " ", "=", 
   FractionBox[
    RowBox[{"b", "[", 
     RowBox[{"n0", ",", "0"}], "]"}], 
    RowBox[{
     SubsuperscriptBox["\[Sum]", 
      RowBox[{"i", "=", "0"}], "n0"], 
     RowBox[{
      RowBox[{"b", "[", 
       RowBox[{"n0", ",", "i"}], "]"}], 
      SuperscriptBox["s", "i"]}]}]], " "}]}]], "Input",
 CellChangeTimes->{{3.508515437717209*^9, 3.508515472284974*^9}},
 FontSize->12,
 CellLabel->
  "In[645]:=",ExpressionUUID->"1053f28f-a9ad-4e8c-87a3-cf7c6ca15099"],

Cell[BoxData[
 FractionBox["105", 
  RowBox[{"105", "+", 
   RowBox[{"105", " ", "s"}], "+", 
   RowBox[{"45", " ", 
    SuperscriptBox["s", "2"]}], "+", 
   RowBox[{"10", " ", 
    SuperscriptBox["s", "3"]}], "+", 
   SuperscriptBox["s", "4"]}]]], "Output",
 CellChangeTimes->{
  3.508515475492737*^9, 3.508519273491045*^9, 3.753898380908552*^9, 
   3.753898930632847*^9, 3.79332870469189*^9, 3.793328854673781*^9, 
   3.793893159434537*^9, 3.79389330532857*^9, {3.793893409227461*^9, 
   3.7938934225768557`*^9}, 3.793893696671217*^9, 3.8232245308088713`*^9},
 FontSize->12,
 CellLabel->
  "Out[645]=",ExpressionUUID->"45f7a734-090c-4cec-b82d-41f98b4034de"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b4", " ", "=", " ", 
  RowBox[{"b4a", " ", "/.", " ", 
   RowBox[{"s", "\[Rule]", " ", 
    RowBox[{"I", " ", "\[Omega]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.508515479046571*^9, 3.508515486767364*^9}},
 FontSize->12,
 CellLabel->
  "In[646]:=",ExpressionUUID->"562db4f2-8bcb-4769-86bc-3e38352f3c3d"],

Cell[BoxData[
 FractionBox["105", 
  RowBox[{"105", "+", 
   RowBox[{"105", " ", "\[ImaginaryI]", " ", "\[Omega]"}], "-", 
   RowBox[{"45", " ", 
    SuperscriptBox["\[Omega]", "2"]}], "-", 
   RowBox[{"10", " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[Omega]", "3"]}], "+", 
   SuperscriptBox["\[Omega]", "4"]}]]], "Output",
 CellChangeTimes->{
  3.508515487234178*^9, 3.508519273571076*^9, 3.75389838099236*^9, 
   3.75389893073244*^9, 3.793328704728381*^9, 3.793328854711825*^9, 
   3.793893159442272*^9, 3.793893305357078*^9, {3.793893409260737*^9, 
   3.7938934226014833`*^9}, 3.793893696676874*^9, 3.823224530813705*^9},
 FontSize->12,
 CellLabel->
  "Out[646]=",ExpressionUUID->"96728b8c-3332-4e2c-bce4-fe3ecb25e60d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Phi]4", " ", "=", 
  RowBox[{
   RowBox[{"ArcTan", "[", " ", 
    FractionBox[
     RowBox[{
      RowBox[{"Refine", "[", 
       RowBox[{
        RowBox[{"Im", "[", " ", 
         RowBox[{"ComplexExpand", "[", "b4", "]"}], "]"}], ",", 
        RowBox[{"\[Omega]", "\[Element]", 
         TemplateBox[{},
          "Reals"]}]}], "]"}], " "}], 
     RowBox[{"Refine", "[", 
      RowBox[{
       RowBox[{"Re", "[", " ", 
        RowBox[{"ComplexExpand", "[", "b4", "]"}], "]"}], ",", 
       RowBox[{"\[Omega]", "\[Element]", 
        TemplateBox[{},
         "Reals"]}]}], "]"}]], "]"}], "//", " ", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.5085154972632723`*^9, 3.508515501767332*^9}, {
  3.75389850571561*^9, 3.753898518731861*^9}, {3.753898551312562*^9, 
  3.753898573319556*^9}},
 FontSize->12,
 CellLabel->
  "In[647]:=",ExpressionUUID->"c5b56a38-5438-499f-91a1-5c15d0be64b7"],

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  FractionBox[
   RowBox[{"5", " ", "\[Omega]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "21"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
   RowBox[{"105", "-", 
    RowBox[{"45", " ", 
     SuperscriptBox["\[Omega]", "2"]}], "+", 
    SuperscriptBox["\[Omega]", "4"]}]], "]"}]], "Output",
 CellChangeTimes->{
  3.753898574151812*^9, 3.753898930833728*^9, 3.793328704832961*^9, 
   3.793328854762677*^9, 3.7938931594772*^9, 3.793893305388694*^9, {
   3.793893409308592*^9, 3.7938934226345243`*^9}, 3.79389369670891*^9, 
   3.823224530847032*^9},
 FontSize->12,
 CellLabel->
  "Out[647]=",ExpressionUUID->"0254058a-2ed6-4005-a89e-6048b5ecbdae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d4", " ", "=", " ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"D", "[", 
     RowBox[{"\[Phi]4", ",", "\[Omega]"}], "]"}]}], "  ", "//", " ", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.508515519622213*^9, 3.508515521578973*^9}},
 FontSize->12,
 CellLabel->
  "In[648]:=",ExpressionUUID->"f3188f3d-9821-4606-ad44-f4c0aec69e65"],

Cell[BoxData[
 FractionBox[
  RowBox[{"5", " ", 
   RowBox[{"(", 
    RowBox[{"2205", "+", 
     RowBox[{"315", " ", 
      SuperscriptBox["\[Omega]", "2"]}], "+", 
     RowBox[{"27", " ", 
      SuperscriptBox["\[Omega]", "4"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Omega]", "6"]}]}], ")"}]}], 
  RowBox[{"11025", "+", 
   RowBox[{"1575", " ", 
    SuperscriptBox["\[Omega]", "2"]}], "+", 
   RowBox[{"135", " ", 
    SuperscriptBox["\[Omega]", "4"]}], "+", 
   RowBox[{"10", " ", 
    SuperscriptBox["\[Omega]", "6"]}], "+", 
   SuperscriptBox["\[Omega]", "8"]}]]], "Output",
 CellChangeTimes->{
  3.508515522055851*^9, 3.5085192736772747`*^9, 3.753898381192019*^9, 
   3.753898930931872*^9, 3.793328706016111*^9, 3.793328854774538*^9, 
   3.7938931594850683`*^9, 3.793893305395774*^9, {3.793893409316526*^9, 
   3.793893422641705*^9}, 3.793893696733685*^9, 3.823224530868524*^9},
 FontSize->12,
 CellLabel->
  "Out[648]=",ExpressionUUID->"0b75a372-8e37-4026-8ea5-de163c7a0d9a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Tau]4", " ", "=", " ", 
  RowBox[{"Series", "[", 
   RowBox[{"d4", ",", 
    RowBox[{"{", 
     RowBox[{"\[Omega]", ",", "0", ",", "11"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.508515545663164*^9, 3.508515550323187*^9}},
 FontSize->12,
 CellLabel->
  "In[649]:=",ExpressionUUID->"4534f50e-542d-4a88-8632-e4fb72cd5e79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["\[Omega]", "8"], "11025"], "+", 
   FractionBox[
    SuperscriptBox["\[Omega]", "10"], "77175"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Omega]", "]"}], "12"],
    SeriesData[$CellContext`\[Omega], 0, {}, 0, 12, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Omega], 0, {1, 0, 0, 0, 0, 0, 0, 0, 
    Rational[-1, 11025], 0, 
    Rational[1, 77175]}, 0, 12, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.5085155509383698`*^9, 3.5085192737263947`*^9, 3.753898381276428*^9, 
   3.753898931033176*^9, 3.7933287068843107`*^9, 3.7933288548148327`*^9, 
   3.793893159514885*^9, 3.793893305422853*^9, {3.793893409357985*^9, 
   3.793893422666457*^9}, 3.793893696739934*^9, 3.823224530873966*^9},
 FontSize->12,
 CellLabel->
  "Out[649]=",ExpressionUUID->"a4301438-38b7-4a15-afe7-ce5c54c17efc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n0", " ", "=", "6"}], ";", " ", 
  RowBox[{"b6a", " ", "=", 
   FractionBox[
    RowBox[{"b", "[", 
     RowBox[{"n0", ",", "0"}], "]"}], 
    RowBox[{
     SubsuperscriptBox["\[Sum]", 
      RowBox[{"i", "=", "0"}], "n0"], 
     RowBox[{
      RowBox[{"b", "[", 
       RowBox[{"n0", ",", "i"}], "]"}], 
      SuperscriptBox["s", "i"]}]}]], " "}]}]], "Input",
 CellChangeTimes->{{3.5085191431447153`*^9, 3.5085191635768538`*^9}},
 FontSize->12,
 CellLabel->
  "In[650]:=",ExpressionUUID->"105a9520-711f-4884-95b4-9e56fded8e9f"],

Cell[BoxData[
 FractionBox["10395", 
  RowBox[{"10395", "+", 
   RowBox[{"10395", " ", "s"}], "+", 
   RowBox[{"4725", " ", 
    SuperscriptBox["s", "2"]}], "+", 
   RowBox[{"1260", " ", 
    SuperscriptBox["s", "3"]}], "+", 
   RowBox[{"210", " ", 
    SuperscriptBox["s", "4"]}], "+", 
   RowBox[{"21", " ", 
    SuperscriptBox["s", "5"]}], "+", 
   SuperscriptBox["s", "6"]}]]], "Output",
 CellChangeTimes->{{3.5085191441506557`*^9, 3.5085191641102953`*^9}, 
   3.5085192737786303`*^9, 3.753898381360358*^9, 3.753898931133892*^9, 
   3.793328706943528*^9, 3.793328854822857*^9, 3.7938931595426064`*^9, 
   3.793893305429394*^9, {3.793893409365445*^9, 3.793893422673132*^9}, 
   3.793893696764584*^9, 3.823224530895698*^9},
 FontSize->12,
 CellLabel->
  "Out[650]=",ExpressionUUID->"19b639a4-9d9a-4c9f-8f15-4fee8924ef36"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b6", " ", "=", " ", 
  RowBox[{"b6a", " ", "/.", " ", 
   RowBox[{"s", "\[Rule]", " ", 
    RowBox[{"I", " ", "\[Omega]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5085191530805817`*^9, 3.5085191554211683`*^9}},
 FontSize->12,
 CellLabel->
  "In[651]:=",ExpressionUUID->"c1b4a965-fe7e-4bab-b0a4-4072f41e3752"],

Cell[BoxData[
 FractionBox["10395", 
  RowBox[{"10395", "+", 
   RowBox[{"10395", " ", "\[ImaginaryI]", " ", "\[Omega]"}], "-", 
   RowBox[{"4725", " ", 
    SuperscriptBox["\[Omega]", "2"]}], "-", 
   RowBox[{"1260", " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[Omega]", "3"]}], "+", 
   RowBox[{"210", " ", 
    SuperscriptBox["\[Omega]", "4"]}], "+", 
   RowBox[{"21", " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[Omega]", "5"]}], "-", 
   SuperscriptBox["\[Omega]", "6"]}]]], "Output",
 CellChangeTimes->{{3.508519156445312*^9, 3.508519166207513*^9}, 
   3.5085192738263807`*^9, 3.753898381443967*^9, 3.753898931234563*^9, 
   3.793328706984501*^9, 3.793328854858397*^9, 3.793893159549651*^9, 
   3.79389330545645*^9, {3.7938934093722973`*^9, 3.793893422678966*^9}, 
   3.7938936967708*^9, 3.8232245309011583`*^9},
 FontSize->12,
 CellLabel->
  "Out[651]=",ExpressionUUID->"1014d0a5-f7a6-400f-bb72-43eb70021698"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Phi]6", " ", "=", 
  RowBox[{
   RowBox[{"ArcTan", "[", " ", 
    FractionBox[
     RowBox[{
      RowBox[{"Refine", "[", 
       RowBox[{
        RowBox[{"Im", "[", " ", 
         RowBox[{"ComplexExpand", "[", "b6", "]"}], "]"}], ",", 
        RowBox[{"\[Omega]", "\[Element]", 
         TemplateBox[{},
          "Reals"]}]}], "]"}], " "}], 
     RowBox[{"Refine", "[", 
      RowBox[{
       RowBox[{"Re", "[", " ", 
        RowBox[{"ComplexExpand", "[", "b6", "]"}], "]"}], ",", 
       RowBox[{"\[Omega]", "\[Element]", 
        TemplateBox[{},
         "Reals"]}]}], "]"}]], "]"}], "//", " ", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.508519178634079*^9, 3.5085191822462797`*^9}, {
  3.753898582953393*^9, 3.753898585702518*^9}},
 FontSize->12,
 CellLabel->
  "In[652]:=",ExpressionUUID->"57230dfe-0905-4af8-8929-579cdf0ee05a"],

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  FractionBox[
   RowBox[{"21", " ", "\[Omega]", " ", 
    RowBox[{"(", 
     RowBox[{"495", "-", 
      RowBox[{"60", " ", 
       SuperscriptBox["\[Omega]", "2"]}], "+", 
      SuperscriptBox["\[Omega]", "4"]}], ")"}]}], 
   RowBox[{
    RowBox[{"-", "10395"}], "+", 
    RowBox[{"4725", " ", 
     SuperscriptBox["\[Omega]", "2"]}], "-", 
    RowBox[{"210", " ", 
     SuperscriptBox["\[Omega]", "4"]}], "+", 
    SuperscriptBox["\[Omega]", "6"]}]], "]"}]], "Output",
 CellChangeTimes->{
  3.508519184496335*^9, 3.50851927399262*^9, 3.753898381578298*^9, 
   3.753898586511362*^9, 3.753898931364182*^9, 3.793328707164596*^9, 
   3.793328854931736*^9, 3.793893159626685*^9, 3.793893305526936*^9, {
   3.793893409450416*^9, 3.793893422750091*^9}, 3.793893696842031*^9, 
   3.823224530975875*^9},
 FontSize->12,
 CellLabel->
  "Out[652]=",ExpressionUUID->"6e8d4f27-8b7e-4bcf-a7b3-57588a5797c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d6", "=", " ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"D", "[", 
     RowBox[{"\[Phi]6", ",", "\[Omega]"}], "]"}]}], "  ", "//", " ", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.508519209686645*^9, 3.508519211884166*^9}},
 FontSize->12,
 CellLabel->
  "In[653]:=",ExpressionUUID->"0a9504c4-808a-4827-b154-62854d2d422f"],

Cell[BoxData[
 FractionBox[
  RowBox[{"21", " ", 
   RowBox[{"(", 
    RowBox[{"5145525", "+", 
     RowBox[{"467775", " ", 
      SuperscriptBox["\[Omega]", "2"]}], "+", 
     RowBox[{"23625", " ", 
      SuperscriptBox["\[Omega]", "4"]}], "+", 
     RowBox[{"900", " ", 
      SuperscriptBox["\[Omega]", "6"]}], "+", 
     RowBox[{"30", " ", 
      SuperscriptBox["\[Omega]", "8"]}], "+", 
     SuperscriptBox["\[Omega]", "10"]}], ")"}]}], 
  RowBox[{"108056025", "+", 
   RowBox[{"9823275", " ", 
    SuperscriptBox["\[Omega]", "2"]}], "+", 
   RowBox[{"496125", " ", 
    SuperscriptBox["\[Omega]", "4"]}], "+", 
   RowBox[{"18900", " ", 
    SuperscriptBox["\[Omega]", "6"]}], "+", 
   RowBox[{"630", " ", 
    SuperscriptBox["\[Omega]", "8"]}], "+", 
   RowBox[{"21", " ", 
    SuperscriptBox["\[Omega]", "10"]}], "+", 
   SuperscriptBox["\[Omega]", "12"]}]]], "Output",
 CellChangeTimes->{
  3.5085192127196493`*^9, 3.508519274026698*^9, 3.753898381660858*^9, 
   3.753898931467903*^9, 3.793328712754972*^9, 3.793328854971521*^9, 
   3.7938931596545258`*^9, 3.793893305554332*^9, {3.793893409490142*^9, 
   3.793893422776125*^9}, 3.793893696866942*^9, 3.823224530996211*^9},
 FontSize->12,
 CellLabel->
  "Out[653]=",ExpressionUUID->"d631cafd-0284-403b-849e-87472c196607"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Tau]6", " ", "=", " ", 
  RowBox[{"Series", "[", 
   RowBox[{"d6", ",", 
    RowBox[{"{", 
     RowBox[{"\[Omega]", ",", "0", ",", "15"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.508519244465516*^9, 3.50851925458862*^9}},
 FontSize->12,
 CellLabel->
  "In[654]:=",ExpressionUUID->"327f289e-ca54-4ace-95c4-6bac3363bdd8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["\[Omega]", "12"], "108056025"], "+", 
   FractionBox[
    SuperscriptBox["\[Omega]", "14"], "1188616275"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Omega]", "]"}], "16"],
    SeriesData[$CellContext`\[Omega], 0, {}, 0, 16, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Omega], 0, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    Rational[-1, 108056025], 0, 
    Rational[1, 1188616275]}, 0, 16, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.508519249807563*^9, 3.508519274057725*^9}, 
   3.753898381743909*^9, 3.753898931852119*^9, 3.793328721232156*^9, 
   3.793328854979402*^9, 3.793893159661413*^9, 3.793893305560637*^9, {
   3.7938934094973*^9, 3.793893422782708*^9}, 3.793893696873197*^9, 
   3.823224531000929*^9},
 FontSize->12,
 CellLabel->
  "Out[654]=",ExpressionUUID->"0ffe49f4-a7b9-4760-96c9-b582a2a8d8a0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n0", " ", "=", "8"}], ";", " ", 
  RowBox[{"b8a", " ", "=", 
   FractionBox[
    RowBox[{"b", "[", 
     RowBox[{"n0", ",", "0"}], "]"}], 
    RowBox[{
     SubsuperscriptBox["\[Sum]", 
      RowBox[{"i", "=", "0"}], "n0"], 
     RowBox[{
      RowBox[{"b", "[", 
       RowBox[{"n0", ",", "i"}], "]"}], 
      SuperscriptBox["s", "i"]}]}]], " "}]}]], "Input",
 CellChangeTimes->{{3.508517314679656*^9, 3.508517318823786*^9}},
 FontSize->12,
 CellLabel->
  "In[655]:=",ExpressionUUID->"a4e4d82c-5e9f-40ed-ba18-2d931fdd1152"],

Cell[BoxData[
 FractionBox["2027025", 
  RowBox[{"2027025", "+", 
   RowBox[{"2027025", " ", "s"}], "+", 
   RowBox[{"945945", " ", 
    SuperscriptBox["s", "2"]}], "+", 
   RowBox[{"270270", " ", 
    SuperscriptBox["s", "3"]}], "+", 
   RowBox[{"51975", " ", 
    SuperscriptBox["s", "4"]}], "+", 
   RowBox[{"6930", " ", 
    SuperscriptBox["s", "5"]}], "+", 
   RowBox[{"630", " ", 
    SuperscriptBox["s", "6"]}], "+", 
   RowBox[{"36", " ", 
    SuperscriptBox["s", "7"]}], "+", 
   SuperscriptBox["s", "8"]}]]], "Output",
 CellChangeTimes->{
  3.508517323258053*^9, 3.508519274117457*^9, 3.7538983818283873`*^9, 
   3.753898931951378*^9, 3.79332872251163*^9, 3.793328855015283*^9, 
   3.793893159690309*^9, 3.7938933055874987`*^9, {3.793893409504485*^9, 
   3.793893422807942*^9}, 3.7938936968980713`*^9, 3.823224531020823*^9},
 FontSize->12,
 CellLabel->
  "Out[655]=",ExpressionUUID->"e9116442-ecaf-4cd0-9609-95a8a3d5a6a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b8", " ", "=", " ", 
  RowBox[{"b8a", " ", "/.", " ", 
   RowBox[{"s", "\[Rule]", " ", 
    RowBox[{"I", " ", "\[Omega]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.508517362372069*^9, 3.5085173648519382`*^9}},
 FontSize->12,
 CellLabel->
  "In[656]:=",ExpressionUUID->"d668ed5b-7d02-428e-ab28-76cf855b3fd7"],

Cell[BoxData[
 FractionBox["2027025", 
  RowBox[{"2027025", "+", 
   RowBox[{"2027025", " ", "\[ImaginaryI]", " ", "\[Omega]"}], "-", 
   RowBox[{"945945", " ", 
    SuperscriptBox["\[Omega]", "2"]}], "-", 
   RowBox[{"270270", " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[Omega]", "3"]}], "+", 
   RowBox[{"51975", " ", 
    SuperscriptBox["\[Omega]", "4"]}], "+", 
   RowBox[{"6930", " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[Omega]", "5"]}], "-", 
   RowBox[{"630", " ", 
    SuperscriptBox["\[Omega]", "6"]}], "-", 
   RowBox[{"36", " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[Omega]", "7"]}], "+", 
   SuperscriptBox["\[Omega]", "8"]}]]], "Output",
 CellChangeTimes->{
  3.5085173655253973`*^9, 3.5085192741611233`*^9, 3.7538983819118423`*^9, 
   3.753898932052149*^9, 3.793328722522386*^9, 3.793328855023142*^9, 
   3.793893159697154*^9, 3.793893305593693*^9, {3.793893409546349*^9, 
   3.7938934228145103`*^9}, 3.793893696904481*^9, 3.823224531026016*^9},
 FontSize->12,
 CellLabel->
  "Out[656]=",ExpressionUUID->"b0c57f66-913c-4f94-9825-4b106215dc56"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Phi]8", " ", "=", 
  RowBox[{
   RowBox[{"ArcTan", "[", " ", 
    FractionBox[
     RowBox[{
      RowBox[{"Refine", "[", 
       RowBox[{
        RowBox[{"Im", "[", " ", 
         RowBox[{"ComplexExpand", "[", "b8", "]"}], "]"}], ",", 
        RowBox[{"\[Omega]", "\[Element]", 
         TemplateBox[{},
          "Reals"]}]}], "]"}], " "}], 
     RowBox[{"Refine", "[", 
      RowBox[{
       RowBox[{"Re", "[", " ", 
        RowBox[{"ComplexExpand", "[", "b8", "]"}], "]"}], ",", 
       RowBox[{"\[Omega]", "\[Element]", 
        TemplateBox[{},
         "Reals"]}]}], "]"}]], "]"}], "//", " ", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.508517335641294*^9, 3.5085173429934397`*^9}, {
  3.753898592672224*^9, 3.753898596406405*^9}},
 FontSize->12,
 CellLabel->
  "In[657]:=",ExpressionUUID->"0360133a-1b12-4c9f-852d-77fb52ac02ec"],

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  FractionBox[
   RowBox[{"9", " ", "\[Omega]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "225225"}], "+", 
      RowBox[{"30030", " ", 
       SuperscriptBox["\[Omega]", "2"]}], "-", 
      RowBox[{"770", " ", 
       SuperscriptBox["\[Omega]", "4"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[Omega]", "6"]}]}], ")"}]}], 
   RowBox[{"2027025", "-", 
    RowBox[{"945945", " ", 
     SuperscriptBox["\[Omega]", "2"]}], "+", 
    RowBox[{"51975", " ", 
     SuperscriptBox["\[Omega]", "4"]}], "-", 
    RowBox[{"630", " ", 
     SuperscriptBox["\[Omega]", "6"]}], "+", 
    SuperscriptBox["\[Omega]", "8"]}]], "]"}]], "Output",
 CellChangeTimes->{{3.508517343803561*^9, 3.5085173680726*^9}, 
   3.50851927471527*^9, 3.7538983822836523`*^9, 3.75389859754885*^9, 
   3.753898932431552*^9, 3.793328722940605*^9, 3.793328855213202*^9, 
   3.793893159883255*^9, 3.793893305771449*^9, {3.793893409753973*^9, 
   3.793893422996233*^9}, 3.793893697084511*^9, 3.823224531223867*^9},
 FontSize->12,
 CellLabel->
  "Out[657]=",ExpressionUUID->"43c6f093-29c5-428f-b416-6a951616a323"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d8", "=", " ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"D", "[", 
     RowBox[{"\[Phi]8", ",", "\[Omega]"}], "]"}]}], "  ", "//", " ", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.508517381656423*^9, 3.508517384645239*^9}},
 FontSize->12,
 CellLabel->
  "In[658]:=",ExpressionUUID->"200274ad-71d2-4512-9e32-51d8a6f51c47"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"9", " ", 
    RowBox[{"(", 
     RowBox[{"456536705625", "+", 
      RowBox[{"30435780375", " ", 
       SuperscriptBox["\[Omega]", "2"]}], "+", 
      RowBox[{"1092566475", " ", 
       SuperscriptBox["\[Omega]", "4"]}], "+", 
      RowBox[{"28378350", " ", 
       SuperscriptBox["\[Omega]", "6"]}], "+", 
      RowBox[{"606375", " ", 
       SuperscriptBox["\[Omega]", "8"]}], "+", 
      RowBox[{"11550", " ", 
       SuperscriptBox["\[Omega]", "10"]}], "+", 
      RowBox[{"210", " ", 
       SuperscriptBox["\[Omega]", "12"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[Omega]", "14"]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"4108830350625", "+", 
    RowBox[{"273922023375", " ", 
     SuperscriptBox["\[Omega]", "2"]}], "+", 
    RowBox[{"9833098275", " ", 
     SuperscriptBox["\[Omega]", "4"]}], "+", 
    RowBox[{"255405150", " ", 
     SuperscriptBox["\[Omega]", "6"]}], "+", 
    RowBox[{"5457375", " ", 
     SuperscriptBox["\[Omega]", "8"]}], "+", 
    RowBox[{"103950", " ", 
     SuperscriptBox["\[Omega]", "10"]}], "+", 
    RowBox[{"1890", " ", 
     SuperscriptBox["\[Omega]", "12"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["\[Omega]", "14"]}], "+", 
    SuperscriptBox["\[Omega]", "16"]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.508517385069002*^9, 3.508519274772579*^9, 3.753898382396598*^9, 
   3.7538989325382566`*^9, 3.793328732881364*^9, 3.793328855244072*^9, 
   3.793893159912759*^9, 3.7938933058774223`*^9, {3.7938934098639383`*^9, 
   3.793893423102002*^9}, 3.79389369710994*^9, 3.823224531245944*^9},
 FontSize->12,
 CellLabel->
  "Out[658]=",ExpressionUUID->"850da28b-ebe7-4882-a408-38e57115c7e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Tau]8", " ", "=", " ", 
  RowBox[{"Series", "[", 
   RowBox[{"d8", ",", 
    RowBox[{"{", 
     RowBox[{"\[Omega]", ",", "0", ",", "19"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5085174027741747`*^9, 3.508517413253796*^9}},
 FontSize->12,
 CellLabel->
  "In[659]:=",ExpressionUUID->"ab94ded3-eea1-4aff-9b77-d2cb0f595afd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["\[Omega]", "16"], "4108830350625"], "+", 
   FractionBox[
    SuperscriptBox["\[Omega]", "18"], "61632455259375"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Omega]", "]"}], "20"],
    SeriesData[$CellContext`\[Omega], 0, {}, 0, 20, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Omega], 0, {
   1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    Rational[-1, 4108830350625], 0, 
    Rational[1, 61632455259375]}, 0, 20, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.508517408601582*^9, 3.508517414065144*^9}, 
   3.508519274816265*^9, 3.7538983825472116`*^9, 3.7538989329221*^9, 
   3.793328813409877*^9, 3.793328855303021*^9, 3.793893159921487*^9, 
   3.7938933058855543`*^9, {3.793893409871965*^9, 3.7938934231129217`*^9}, 
   3.793893697118814*^9, 3.8232245312518377`*^9},
 FontSize->12,
 CellLabel->
  "Out[659]=",ExpressionUUID->"b8348f02-07f9-4782-9d7d-04b18b5720c2"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.508517645214568*^9, 3.5085176515788517`*^9}},
 FontSize->12,
 CellLabel->
  "In[660]:=",ExpressionUUID->"a0baee9e-b3d9-43cd-8e66-123e11d90f3e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"d2", ",", "d4", ",", "d6", ",", "d8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Omega]", ",", "0", ",", "20"}], "}"}]}], "]"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "group", " ", "delays", " ", "for", " ", "different", " ", "orders"}], " ",
    "*)"}]}]], "Input",
 CellChangeTimes->{{3.508517604456522*^9, 3.508517630993417*^9}, {
  3.508517737460614*^9, 3.5085177983406973`*^9}, {3.5085178533030367`*^9, 
  3.508517864986565*^9}, {3.508517897579504*^9, 3.508517899642695*^9}, {
  3.508519281152953*^9, 3.508519283064393*^9}, {3.7938933634811573`*^9, 
  3.7938933903883266`*^9}},
 FontSize->12,
 CellLabel->
  "In[661]:=",ExpressionUUID->"10b7ea1d-f6b2-48c5-8fe6-40f4e0078e2b"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd1Hk01N8bB/BhKEv2EiqRLWRrKl9Rz81OJS1ki1LSZo/soygK2UtJtigh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       "]]},
     Annotation[#, "Charting`Private`Tag$398049#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd1nc4lX0YB3A7KlmRvVLKCifRvH8hIzSMkii8GZVIQ5JRSUaE3mQnI6mM
rMpISNkz2yl7cw6Og2O+v/M+/5zrc13Pua7n+d33/b0fKVsXYzsmBgYGYGRg
oP/Ge9uyqVyJPcbw/zUDv1ccX85IFED40Aa+yLCpZ0B2WqIadDKH/vcrjsJX
ow6NYPrR6n/zxlUxzXa0QEqq3hrdnx28X5OvtkJres8y3RaE/YdIK22wJvh1
gW4FIa6A6Yp2uDJbQKF7fX28bSqkA7q0p8h0j7p2eDrNdcAr9/fTdDcNVeyc
OtcJvO2Sk3R/PZ9Tc72oEz6cNBijO7EmwXVSogueKEkN0z0flS/XG9wFuRX6
/XTrONQOttC6QL+BRqQ7Wq0/7pd9N+SPyHTSPcW8aFb4uxuc33xroRtatnJl
oh74cTu/ju4Xb6SrEjN6YFvG6k+6h501HkUIE2HkwuMSujWOnjoU6E+EYrX9
n+l+tuUKxXOeCGcj1tPp/tt1P/2mzR/IPluXRLdKWqjdlYY/0J/9NJLuJ25v
xc0P/wUuU/5ndHdoF3UYpP0FX/5LXnTL8TWHAX8vNNK0nen26h/RJzzuhTnu
dKv/zydrlUmW3AsxlrcN/q8HcFziVOoDyHNXp/vw7peH/K/0gXFapBTdVzgl
djDG9oHblfccdD+ff0/xaO6Da2FPyOv08+3Z3zS/qR+OKq+10N1f/j3d+Vg/
sPoO5dK9P7zNzvZjP+yMVLtB9yV3a01ifz8UVqieoNv/8qT4OcEB+ED4KUT3
Jx23lcZTA/BeNXNiDbtbkbFT328Alpw+fqGbmT8470fRAOwrc3tIt8KqQPjR
uQEoFvilTbdPjcJJlcuDwBKQW7KKnZb9ZffHiEHo2ZZ2m+6WKE3mXXWD4MBV
L033ik9972umIfhBKatdwZZxMC8WPDgE+vxSznSfOjUY9cJlCMYDfDjovqfm
fHdr6hC4TDjFL2PXMD9RYuAbhp3HBTJo9H6a2LbFQ38YIiVbZekWa4kepfgM
g+Rpmeglen8VyFTc+DwMi6X3GOi++SbrzejUMMy90rBaxI7xP+Rls3MEEnqr
Mxewfzj/vNBzYQRMzvvPU7EFjvbwNv4aAe2Exgvz2EjGnqy3NgL1ixP3KNhX
t8zWlhNGIYPVxH+O3o9zD9KOXBuF39RD/rPYxV1sfp/fjMIgc73bDPZIabiN
csco1O6TMyNjc6WJHvvAOQYbs1elSNi2bqqL8R5j4JnyzWcSO9jq2+8d2WOw
W6qBawI7X1vvU/joGNR/KAgcw2bnu3TVz3QcfJSSDwxjqy6PndgIGoe+IW2H
QeyL/bel75eNw9Itdq9+7MyswB4npQmYp+Yb/8Ge4J0IPmkzAaUUdfUebFm3
k8f2vJwAPt7IjU7sN0e2JA7SJqDXa+1AKzYx4bpxmcIkVPe6JjdjCzHXMSdc
ngSzjThSA/39q4PtLX5OAuH+bZFq7AaF6R0aS5PAV6i0/BN7S5hRNb/8FNyZ
+55dTp+vc9sUmsOmgNeWllKEXVrg/CfzxxQMihn8+YK9Jtr4PHhhCjrg52gu
tttg6Kyu5TRk9Uxf/4idozOTtCt0GjIb2/pTscnvz5gyl0+Dt6e5dBK2402e
LyWyJBDRW1mOxE757eoYZ0GC+pLu5y/o83OgRcgjhATsCy1DwfQ8XHvhqUYh
wbNTnfUP6XlqTVHk202GRRlJSw/s3z9MemfMySDqTk26jW0YtF0zvYQM5/hX
TtthJ2yp9eU5MQN3hFCPNvaxow8sH16agXs1RwYO08/PWV6NfG8GvjcfeaaK
LdjybKTuwwwU5/l9FqfnM/OR74crZmCgSEN1O7ap2lTkhz8zcDW3XJMDOzzK
UD+AexaSQ45un1sng3LNqtTi3llYCxypH8ZuWElfttOahdHxNs4u7M2XOdO1
3GbhlQmVuwTbd1fDto2eWWA715n9CFv6vPfoDeosOL2kybtilwYolRK3zYG7
Se5ma+zVyeeuhcfnwDNDfvAwdowYnNx7cQ7OvtL6vQdb4zRZOurOHLS2v93O
j30353Tr3XdzoNj1y21yjQzbhzbSh0rx/dKrwW3YOfyf/Ey65yCD07G3BJvk
zq2uwkmBfmKQdCi2AzRHT92iADd/t/cubIakhcKeZxQ4eO6zPQd2FIsosSaF
ArNlflemVslQVW0v/r6dAiV+GoFZ2NYKwRBFpkAI7XpyKPbS82xrf/Z5OLBb
tdAZe4/papLdoXmY9S0u34td+lmqwtRkHu5o/k5lxTYX0h3WcpqHWmUpp74V
MgT8DZeVfj0PlqoJXi+wxxxl0/8yUqHO49bk6DIZHtYa1tcLU+GFmhtHIbag
0i1SMYEKIQVfaoOw9SjFyrF2VIg1GBTZg/3eyzj/fDUVjvwNWjlDI4Nm3712
nQEqlDJJGe3A7taMX1RboUKg7K61niVcP/axg9sVF+BabbOxNfa1F14lTWEL
cPvXaIXJIhmYqEm9398vAFFRfGULdsz5Koas8gX4tR6ByhdwXoryaYXMY0+2
NOzBln+XVqlvvgim8dG/iPNkqOBoGNNwXYSDD1h0nmBbOlE49gQtQrVewYO9
2MEqxwzZihfBZTaw24mC93HR76ZyiSXY9T2Ru30Wz684bTZbYwl4FM+SrmKL
PhLnSzy7BKYuGhIrM3g+dK6a+fguga6JsA4/dkbTetfh0SUYaRXeJ0vC+UyQ
WZFjoIGHaZRSyjTexxH6osJCNKiPoPKJY2+7+PLS0kkaJJu9PMc+RQbn4b2D
eZk0qHI/KZ4/Toa+S13sZdU04AyS37cZ26QzQKl+iAafj+pvuTiG+7N29P6w
8DJ82zneSh7B+yz7LbeA/zJwGFu5DA7iPJEzOyCdtAyPCWfit2OPJbNYKn1b
huMfNWfQAJ6nV/+806EsgyYzQ2ZQH+4/T6lj9y6vAO9LXZE+Iq7PQtM/vh4r
kLtbjHWsB+9/l4eBoRErsI3ngvVEN85z297Wd7UrEF3myvm3E+9Pvfjrneqr
sFb1PM27lQxlfELRB7nXIHN23Su0Bu/vkKqSE/JrsEXo/G5CNRlS2dyHzuqs
wWKkUH5jJa4HrX3fNc81KCfeFaNU4NzpffkrZmwNdAvY1ftwDlWZa0+lMq+D
UfERFb1v+PuihcKTK74O4TmxR9OKyCD509iq1nQdTljclDzzFef/B+75ldJ1
KLzWy3MkG9dfplSInbgOd/akJtpkkaEx3gW2L65DS6COo3cGGfLCGoIUFDfg
eBxRLv493v9uwVJW0Rugku9zzykRn4fUE9leDQZE/kOOOxiKn+dI+D7vEwwo
xDfkKzmYDE/NX6uLGTMgg9GId3FBuH/DvupevM6A1nTvp3T7kWF5fcqhI54B
BeXIxQ49IMMk0SytkYkR3dyZlSlqT4YPS7afnLkYUaxe/WW1f3C+b7/5lVOU
EQl8l/fUsibDkEFQlYEaIwrjOJIAFjhvC0vGKh0YkXNVs3K+ERnqomT3ltYx
orxfvmuPVckQlLdf5XIXI1q60HFlTAnPa9Pxg+vDjEg0p3bsuDyej02W+kc2
GNEldo+lpp14n7uFXf2qwoQm9TgkrLbjfjalvf/0igmFbVN/IIb3htNNtpzT
yUyICzZRikgkkAvmKyRlMSE2vQEHowkSpP5QrFGoZkI/9+ty6PeT4LWq7UTa
ChOyERL0TmwgwXPuWrlEa2ak0ZD2rSaVBAXqYvmnnJmRD8upd1KJJBi65AKr
D5jRs+VXJxxjSXA4g8/0fCQz+vDUxbEilARj+pZenA3M6PUeQ+LneyTQ8p1u
vH+YBXV0fSrz0CaB8wewkNVnQfMCxrcqj5Igpjl8qPUcC1J0P6HKrE6CGYkD
tH23WNA0dapKdy9+vmJv6ZE0FtSnpV7PwkmCJSrXXWMBVnQ7RbffoHkadorZ
bmzsZEXBdxTn/Kun4ZR2XmCGCisqW86h5pRNw9sX5q/ZjVjRXJ1Mf1v2NBjv
S6ws8WVFq5ZaZafDpyHDUVVYfpYVud2LPy5kNA22PabfmevYUEDG1tdGX6dg
c2z/DdcuNnT+EbUyNXMKciycRXtH2NDMoejxmZQpYO72v1/IuAmVfF+wMQ+f
gpTOQoKr+iZ0zCfexu3qFIy0Sab9TdqEKhqv9DLumIJrTVNhBffZ0bjzWQY2
x0lw/fnE1kV2M2I/d0XUYGwcsm9uNRHU50Q8re4e7zpGIPHB9Qnl89zIrtEk
RfnpIDxOWD07P8WDjOU/LvoU9MEZ5a+u8hQexF3pMqqf1QfiZbfDbWk8aLUz
QkD4bR8UDkw0NbHyIi8W60P1YX0wt6vrdIY4L3IcPfrL27EPbNPzjezP8CK7
t147uIX64HiBs35nLi86uV9Yrn/tLzD87kPFHnzoi9L9G/JFRHgyXpLo8YgP
yd0XfHI9jQgcDPFMBwP40ELOB67CCCLwKl6oyI/gQ095VV0e3yTCLv9m3axP
fGj6wXj6991EOHm4/FTSCP5/GGPxSEQP/JucbBlgvB3ddCY9/eLdDbvv2Lub
yvEjySgpt0/unaB4qNckQZkfBTC5D1y81gn7Gcz3TRzgR0yr8ft5LTtBM1h/
xEeLH8leaHZKgE64lKJg+tGSH+1UvGN1eFMnvGqd28cUyo+4mkaLbkV1AKua
z2gWhR9dqB4mfyhvhyFq5Lkt3wRQWhv/Ruz+Nkg6Trj954cAErd2naiUbYPL
IQ2hWTUCSCL7sOu6cBt0y7BWm3QKIMHiMflnjG3QbHLrcBxFAD2ZEjWWbmyF
kmxDSUW5HUg3rtEEnFoh8gbjxKnIHWgy/mrOfMZvODl8zeuFqyByrF4MsTVq
AR2vnena7oIoJJCZTVKrBTT5id0L3oJopNrmzbBGCxw6YaRxMVgQbdPcJR4o
0wJyb/dRdr4TRHPkxzeUV5thi928Yz5REHGliU3T0puhbsjLtFNXCBGPSWro
bG+GU0Nh8uLiwqjv46ONZzONUCc/1GopI4z4+YiJdX2NYHBb3TtWThjJjZk/
EGxuBD2mv02C6sLI+HN1enN2I2hKyrvxnRFGDsNdy1W3G0HN8mcp+2NhVOJq
O1FOawDRVpoZZVgY+fbosCdzNsDED9uHVRkiyNCQnLPbpA4kwjuvPc8TQZXf
FAsbtevA9NIpM9MiERS0dd7a90AdlCwdlOurEkHcm9/abRaugxeKPK2LgyKo
1j/l4Kv+Wjgc+V1WVlgU5cnyxsfdqoXga6KNfk9FEWNVfId0XA0o8bSLaV0W
Q/WlSj9lt1TDZqDaECniaImcbPjG7RfoTlssSptJIuvne5Z4dlRAZ/kVRgsF
KcT176+zZ0XKIT+g4pIkVQpNaEhwuTwuBXvWu30NDdIoPVQ5pI2pBP659SB/
a8xOlGVxU+5YaBHsc5BvMLSRQUfXprOpLgXQyKuw5e7BXejfmIfvO+y/QFHm
41gF5t0o1823SeFLPjxglDtT92c3+hTaJK4okAebiR56znmyqD/+78x6Wg4M
p0q9TPDcg+5cvb7i6ZYNL/cIsRSY7UWy7ELbrp/8BGEx9pU2knJI2Vr21rfo
TLB4adWwdVQOmTKSeRxa02FJ+y0toUQe7b33QKOK7yMMDmu6l/srIFcx8UPH
It5D0lEVkXobRcSmDaq2QmmQ4XeXx0FRCYnWuPL0/E4Ff7N/DJipSmg1q9JS
KeMtqBET3/vX70PnKZvzZJ6mQNTe2Ix6A2UksWlx4F//ZPApDYkyKFBGbD0X
jogHJIGRiNnbGhkVnE96lfMJiXDcufIiT6AKuquUKurW/gYSRG1l6qgqCGJV
h0c3vwGZH+9enbqoigws7G30c19DmGK5XEuJKmL1m2iPuxEP9hSW5mo5AhLj
OSr4WToObLPnJANDCWhx4227FmMsOD02WT0ZTkBWhgxXLq/GwF2TvI6t/xLQ
T0NPHc/FGAig3n0e9oqA/uEbZy+cjoHMg7SVyHgCOpPH5XaiOwZoZRvtqR8J
yExc6GlsbgyEtWwNqagkIJ/5XIXjDjEQk3zD8Wk1AZHKF1yf2sZA8p0GLb1a
AvorpLlWZxUDnwXClmsbCMjPTmzIyjQGiBZ8jr/bCGhUWGLk+fEYkB0U0hoY
JCAWrlIzRdEYUM7zEE8ZJqC0R0w/n+6IgUN+PTS7UQKyP85zu583Bgxl4z+N
TxDQi4+1gTEcMXDruqT47CwBhTvqRogsRoPnkUe0HAoBbRbxJnnPRYMf50Dr
HSoBeRssPB6cjoaorORnS0sEFOkzfvHTUDQkPWRxKFwmICPFJwmCfdHw8ayd
pucqAa2mJ4g+7omGPOlfYsfWCSj3TF3LVHs0lFB20zY2COhEXEyZeUs0/AdU
XmDd
       "]]},
     Annotation[#, "Charting`Private`Tag$398049#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw113k0lP8XB/DByC5bfVtkq5BCjNLq3hbJEpGlRZIiqUjfLJXkW8pSWUqR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       "]]},
     Annotation[#, "Charting`Private`Tag$398049#3"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw913lYTG/0APCWmfZtmvaSSipp09jDe6SkFZUoRdKKNkRZCqXEN5IWohJF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       "]]},
     Annotation[#, "Charting`Private`Tag$398049#4"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.508517618765127*^9, 3.508517631467358*^9}, {
   3.5085177418814487`*^9, 3.5085177649270782`*^9}, 3.508517799174019*^9, 
   3.50851786541263*^9, 3.508517901410297*^9, {3.508519274882102*^9, 
   3.508519283991675*^9}, 3.753898383086935*^9, 3.7538989331772213`*^9, 
   3.7933288247469063`*^9, 3.793328855385953*^9, 3.79389316000616*^9, 
   3.793893305974759*^9, {3.793893364432055*^9, 3.79389342323313*^9}, 
   3.793893697200069*^9, 3.823224531320607*^9},
 FontSize->12,
 CellLabel->
  "Out[661]=",ExpressionUUID->"d97ab1cf-4405-4b33-b5d2-eec1380819e9"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 652},
WindowMargins->{{Automatic, 226}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"253b14c8-a0e5-4420-8c00-56c95833e4aa"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 295, 5, 62, "Section",ExpressionUUID->"a28d16a0-0e28-4482-b7f5-1546cb963462"],
Cell[877, 29, 224, 3, 36, "Text",ExpressionUUID->"fca7d474-662d-412b-8629-ced54de83070"],
Cell[1104, 34, 174, 4, 30, "Input",ExpressionUUID->"8d7bb64d-867e-4a95-ad92-0ef563acc9d3"],
Cell[1281, 40, 799, 26, 49, "Input",ExpressionUUID->"c8000e26-e379-4193-b2fc-2843a5598e36"],
Cell[CellGroupData[{
Cell[2105, 70, 710, 20, 51, "Input",ExpressionUUID->"20a60d6e-5086-42d3-8556-f32f00b1ff9e"],
Cell[2818, 92, 4792, 101, 48, "Output",ExpressionUUID->"eba68342-109f-41c4-95e2-ac2f3de4fa68"]
}, Open  ]],
Cell[7625, 196, 444, 11, 29, "Input",ExpressionUUID->"c648b837-c940-4129-a783-e7b7dbd95a19"],
Cell[CellGroupData[{
Cell[8094, 211, 658, 19, 51, "Input",ExpressionUUID->"282c598c-3796-4b01-b7fc-528edca7e0ca"],
Cell[8755, 232, 3104, 67, 56, "Output",ExpressionUUID->"e95a3f43-6c9b-426f-b560-126521d0abfd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11896, 304, 280, 6, 29, "Input",ExpressionUUID->"0059955d-2333-4b39-8696-76c9da340e49"],
Cell[12179, 312, 1179, 29, 49, "Output",ExpressionUUID->"ffcbcb91-af0e-4fb3-81b9-10a2d3893854"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13395, 346, 659, 19, 51, "Input",ExpressionUUID->"8a507f3e-c200-4066-b0d1-4f57ca514ae7"],
Cell[14057, 367, 3343, 74, 56, "Output",ExpressionUUID->"81691e12-df44-4bee-9912-ca6423a5e018"]
}, Open  ]],
Cell[17415, 444, 340, 9, 29, "Input",ExpressionUUID->"e3deab33-b50e-4c6b-9823-8b49e87160b6"],
Cell[CellGroupData[{
Cell[17780, 457, 663, 19, 51, "Input",ExpressionUUID->"6c07d6a6-a6e8-415f-9f89-afd68adc1da6"],
Cell[18446, 478, 3392, 75, 56, "Output",ExpressionUUID->"8e3c8912-7325-4b64-bfe0-5f42a9def6b6"]
}, Open  ]],
Cell[21853, 556, 274, 8, 29, "Input",ExpressionUUID->"69507958-ace4-4107-9cdb-e21a088f50db"],
Cell[CellGroupData[{
Cell[22152, 568, 659, 19, 51, "Input",ExpressionUUID->"673300ce-e032-461f-8d59-352c6ea4a0f3"],
Cell[22814, 589, 3826, 83, 71, "Output",ExpressionUUID->"1c37741b-b03d-4c11-88a0-a9de52c3fbb2"]
}, Open  ]],
Cell[26655, 675, 328, 9, 29, "Input",ExpressionUUID->"c92f4630-1f54-492f-9e7c-398c16500939"],
Cell[CellGroupData[{
Cell[27008, 688, 658, 19, 51, "Input",ExpressionUUID->"5e9ddda4-81f5-4a13-bbb7-7b75d7fe92c2"],
Cell[27669, 709, 4164, 89, 48, "Output",ExpressionUUID->"8704bb02-0c27-413a-b6cb-0137637a8b4f"]
}, Open  ]],
Cell[31848, 801, 328, 9, 29, "Input",ExpressionUUID->"4df32ad1-c6de-47b3-bd36-40882208d85f"],
Cell[CellGroupData[{
Cell[32201, 814, 1049, 26, 49, "Input",ExpressionUUID->"c3583d82-7338-4edb-b07d-862b625de889"],
Cell[33253, 842, 2908, 68, 449, "Output",ExpressionUUID->"e2a5f8f9-009a-4795-a16b-3ab0b5782f8d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36198, 915, 723, 15, 29, "Input",ExpressionUUID->"90cf9079-f257-4d50-a532-2030deba9e9d"],
Cell[36924, 932, 131344, 2395, 247, "Output",ExpressionUUID->"11b78a80-2852-48a5-ba44-1d03db6c47e5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[168305, 3332, 2148, 58, 163, "Input",ExpressionUUID->"eb6b0ec4-b0b7-49c6-9927-0f987701e995"],
Cell[170456, 3392, 75938, 1280, 239, "Output",ExpressionUUID->"0e9122b0-f719-4ab6-a517-c874f5c6a738"]
}, Open  ]],
Cell[246409, 4675, 222, 4, 52, "Text",ExpressionUUID->"618c9bb6-d5b7-48bb-a3ea-6519bf51be98"],
Cell[CellGroupData[{
Cell[246656, 4683, 459, 11, 29, "Input",ExpressionUUID->"ac3cdb3d-2dda-4815-92af-b3a003291527"],
Cell[247118, 4696, 6581, 148, 107, "Output",ExpressionUUID->"7a2f2cf6-6c31-43c5-929e-27ec9a312877"]
}, Open  ]],
Cell[CellGroupData[{
Cell[253736, 4849, 461, 11, 29, "Input",ExpressionUUID->"23c50bb3-f8d3-409d-a06c-121ca23bb4d6"],
Cell[254200, 4862, 14401, 353, 175, "Output",ExpressionUUID->"09dc6fd4-fe53-4fd7-8e3e-676d58e263c1"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[268650, 5221, 205, 2, 54, "Section",ExpressionUUID->"35758e8f-905d-4fb1-9b4f-ca11361c86c7"],
Cell[268858, 5225, 252, 5, 33, "Text",ExpressionUUID->"0141f0d1-88c6-4b42-a80f-4ff0bba7ad9d"],
Cell[CellGroupData[{
Cell[269135, 5234, 653, 15, 45, "Input",ExpressionUUID->"d52b9de3-fdff-442f-a63d-55fa3b074c58"],
Cell[269791, 5251, 674, 14, 51, "Output",ExpressionUUID->"e5e48100-d85f-4421-ba35-3e8db477b74f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[270502, 5270, 1009, 26, 49, "Input",ExpressionUUID->"1e2a5f35-ffe6-42d1-9d0c-1fbf2a32b551"],
Cell[271514, 5298, 768, 16, 51, "Output",ExpressionUUID->"d45a7a55-4d1f-4ad7-b437-2c392101177e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[272319, 5319, 462, 12, 29, "Input",ExpressionUUID->"9489c345-9e31-47a3-8e36-9ab7113274b4"],
Cell[272784, 5333, 802, 19, 55, "Output",ExpressionUUID->"676e7502-2e8b-4ec4-807a-f66d4d97f67a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[273623, 5357, 355, 9, 29, "Input",ExpressionUUID->"d6e5d84d-a996-4c20-aa30-cb760d8a1e9f"],
Cell[273981, 5368, 925, 23, 52, "Output",ExpressionUUID->"26b7018f-87fb-4b8f-87e9-39b46f092032"]
}, Open  ]],
Cell[CellGroupData[{
Cell[274943, 5396, 558, 17, 51, "Input",ExpressionUUID->"198b2b35-837b-4281-bd83-dd7147ed1b8c"],
Cell[275504, 5415, 619, 14, 50, "Output",ExpressionUUID->"0315e0b3-6949-4321-a4e3-a484392fe585"]
}, Open  ]],
Cell[CellGroupData[{
Cell[276160, 5434, 327, 8, 29, "Input",ExpressionUUID->"611353ac-ffbf-4b79-935c-cd441ad1cdad"],
Cell[276490, 5444, 678, 15, 51, "Output",ExpressionUUID->"513c75da-aad5-46bc-af1a-51a49aa65e01"]
}, Open  ]],
Cell[CellGroupData[{
Cell[277205, 5464, 914, 25, 49, "Input",ExpressionUUID->"fac41742-e6e2-4cd6-b8bd-2a1d07b0d6dc"],
Cell[278122, 5491, 759, 19, 55, "Output",ExpressionUUID->"e858dd4c-d054-42b7-807c-b5b96b0bb5ba"]
}, Open  ]],
Cell[CellGroupData[{
Cell[278918, 5515, 358, 10, 29, "Input",ExpressionUUID->"2faad29f-fefc-40cd-bccc-035c9fbb5ed2"],
Cell[279279, 5527, 842, 20, 54, "Output",ExpressionUUID->"9f49d5a6-fa82-4bc2-81ce-31e44d69f9b5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[280158, 5552, 355, 9, 29, "Input",ExpressionUUID->"d6d207db-d5cc-4fa8-9e3a-1aeb9c812df1"],
Cell[280516, 5563, 919, 23, 52, "Output",ExpressionUUID->"0b8cc03f-9e9b-4bdb-9354-be30ec3870f9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[281472, 5591, 559, 17, 51, "Input",ExpressionUUID->"1053f28f-a9ad-4e8c-87a3-cf7c6ca15099"],
Cell[282034, 5610, 659, 16, 50, "Output",ExpressionUUID->"45f7a734-090c-4cec-b82d-41f98b4034de"]
}, Open  ]],
Cell[CellGroupData[{
Cell[282730, 5631, 327, 8, 29, "Input",ExpressionUUID->"562db4f2-8bcb-4769-86bc-3e38352f3c3d"],
Cell[283060, 5641, 729, 16, 51, "Output",ExpressionUUID->"96728b8c-3332-4e2c-bce4-fe3ecb25e60d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[283826, 5662, 913, 25, 49, "Input",ExpressionUUID->"c5b56a38-5438-499f-91a1-5c15d0be64b7"],
Cell[284742, 5689, 742, 20, 55, "Output",ExpressionUUID->"0254058a-2ed6-4005-a89e-6048b5ecbdae"]
}, Open  ]],
Cell[CellGroupData[{
Cell[285521, 5714, 358, 10, 29, "Input",ExpressionUUID->"f3188f3d-9821-4606-ad44-f4c0aec69e65"],
Cell[285882, 5726, 998, 26, 55, "Output",ExpressionUUID->"0b75a372-8e37-4026-8ea5-de163c7a0d9a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[286917, 5757, 356, 9, 29, "Input",ExpressionUUID->"4534f50e-542d-4a88-8632-e4fb72cd5e79"],
Cell[287276, 5768, 932, 23, 52, "Output",ExpressionUUID->"a4301438-38b7-4a15-afe7-ce5c54c17efc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[288245, 5796, 563, 17, 51, "Input",ExpressionUUID->"105a9520-711f-4884-95b4-9e56fded8e9f"],
Cell[288811, 5815, 823, 20, 50, "Output",ExpressionUUID->"19b639a4-9d9a-4c9f-8f15-4fee8924ef36"]
}, Open  ]],
Cell[CellGroupData[{
Cell[289671, 5840, 331, 8, 29, "Input",ExpressionUUID->"c1b4a965-fe7e-4bab-b0a4-4072f41e3752"],
Cell[290005, 5850, 926, 20, 51, "Output",ExpressionUUID->"1014d0a5-f7a6-400f-bb72-43eb70021698"]
}, Open  ]],
Cell[CellGroupData[{
Cell[290968, 5875, 865, 24, 49, "Input",ExpressionUUID->"57230dfe-0905-4af8-8929-579cdf0ee05a"],
Cell[291836, 5901, 933, 24, 55, "Output",ExpressionUUID->"6e8d4f27-8b7e-4bcf-a7b3-57588a5797c1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[292806, 5930, 353, 10, 29, "Input",ExpressionUUID->"0a9504c4-808a-4827-b154-62854d2d422f"],
Cell[293162, 5942, 1279, 33, 55, "Output",ExpressionUUID->"d631cafd-0284-403b-849e-87472c196607"]
}, Open  ]],
Cell[CellGroupData[{
Cell[294478, 5980, 355, 9, 29, "Input",ExpressionUUID->"327f289e-ca54-4ace-95c4-6bac3363bdd8"],
Cell[294836, 5991, 956, 23, 52, "Output",ExpressionUUID->"0ffe49f4-a7b9-4760-96c9-b582a2a8d8a0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[295829, 6019, 559, 17, 51, "Input",ExpressionUUID->"a4e4d82c-5e9f-40ed-ba18-2d931fdd1152"],
Cell[296391, 6038, 932, 24, 50, "Output",ExpressionUUID->"e9116442-ecaf-4cd0-9609-95a8a3d5a6a8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[297360, 6067, 329, 8, 29, "Input",ExpressionUUID->"d668ed5b-7d02-428e-ab28-76cf855b3fd7"],
Cell[297692, 6077, 1079, 24, 51, "Output",ExpressionUUID->"b0c57f66-913c-4f94-9825-4b106215dc56"]
}, Open  ]],
Cell[CellGroupData[{
Cell[298808, 6106, 865, 24, 49, "Input",ExpressionUUID->"0360133a-1b12-4c9f-852d-77fb52ac02ec"],
Cell[299676, 6132, 1140, 28, 55, "Output",ExpressionUUID->"43c6f093-29c5-428f-b416-6a951616a323"]
}, Open  ]],
Cell[CellGroupData[{
Cell[300853, 6165, 353, 10, 29, "Input",ExpressionUUID->"200274ad-71d2-4512-9e32-51d8a6f51c47"],
Cell[301209, 6177, 1726, 44, 102, "Output",ExpressionUUID->"850da28b-ebe7-4882-a408-38e57115c7e7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[302972, 6226, 358, 9, 29, "Input",ExpressionUUID->"ab94ded3-eea1-4aff-9b77-d2cb0f595afd"],
Cell[303333, 6237, 1018, 24, 52, "Output",ExpressionUUID->"b8348f02-07f9-4782-9d7d-04b18b5720c2"]
}, Open  ]],
Cell[304366, 6264, 192, 4, 29, "Input",ExpressionUUID->"a0baee9e-b3d9-43cd-8e66-123e11d90f3e"],
Cell[CellGroupData[{
Cell[304583, 6272, 784, 19, 29, "Input",ExpressionUUID->"10b7ea1d-f6b2-48c5-8fe6-40f4e0078e2b"],
Cell[305370, 6293, 28104, 488, 239, "Output",ExpressionUUID->"d97ab1cf-4405-4b33-b5d2-eec1380819e9"]
}, Open  ]]
}, Open  ]]
}
]
*)

