(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    117632,       2355]
NotebookOptionsPosition[    115379,       2308]
NotebookOutlinePosition[    115775,       2324]
CellTagsIndexPosition[    115732,       2321]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Illustrate nonlocal trajectory in simple control system
Chapter 4 (controllability in practice)\
\>", "Section",
 CellChangeTimes->{{3.593827176110529*^9, 3.593827193561026*^9}, {
  3.793327345581956*^9, 
  3.7933273569431477`*^9}},ExpressionUUID->"3ccdef91-63d4-48c6-8b44-\
ec3af715a9f8"],

Cell["example adapted from Sun and Motter, PRL 2013", "Text",
 CellChangeTimes->{{3.593827196981172*^9, 3.593827209001429*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"182e11e8-6ca5-43fc-8103-4d98d02001fb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Plot", ",", "ParametricPlot"}], "}"}], ",", 
    RowBox[{"PlotRange", " ", "\[Rule]", " ", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.593823684002606*^9, 3.5938236898512793`*^9}},
 CellLabel->
  "In[3686]:=",ExpressionUUID->"5631db25-9a91-4837-8c1d-da1ebf4ad967"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "0"},
      {"1", "0"}
     }], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1"},
      {"1"}
     }], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"tf", "=", "10"}], ";", 
  RowBox[{"\[Epsilon]", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"StateSpaceModel", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expA", "=", 
   RowBox[{"MatrixExp", "[", 
    RowBox[{"a", " ", "t"}], "]"}]}], ";", 
  RowBox[{"vec", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"expA", ".", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Outer", "[", 
    RowBox[{"Times", ",", "vec", ",", "vec"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{"g", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tf"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pinv", "=", 
   RowBox[{"Inverse", "[", "P", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TraditionalForm", " ", "/@", 
  RowBox[{"{", 
   RowBox[{"vec", ",", "expA", ",", "g", ",", "P", ",", "Pinv"}], 
   "}"}]}]}], "Input",
 CellChangeTimes->{{3.593812176324749*^9, 3.593812231471073*^9}, {
   3.593812271317552*^9, 3.593812327586857*^9}, {3.593812378593099*^9, 
   3.5938124550347223`*^9}, {3.593812501148181*^9, 3.593812664885519*^9}, {
   3.593815148078759*^9, 3.593815152402176*^9}, {3.593815321909863*^9, 
   3.5938153282676563`*^9}, {3.593815574866708*^9, 3.593815643576098*^9}, {
   3.5938157031866627`*^9, 3.5938157038883953`*^9}, 3.5938157774866543`*^9, {
   3.59381582659914*^9, 3.593815839772093*^9}, {3.593815883055379*^9, 
   3.59381588350871*^9}, {3.593815927313244*^9, 3.593815935859003*^9}, {
   3.593823454919689*^9, 3.5938234691104927`*^9}, 3.593824448251912*^9, {
   3.593824530418029*^9, 3.593824592927719*^9}, {3.5938246509258757`*^9, 
   3.5938246515880632`*^9}, {3.593826715210898*^9, 3.593826720993936*^9}, {
   3.593826848032907*^9, 3.593826875245665*^9}, {3.5938269486015987`*^9, 
   3.593826948750884*^9}, {3.5938270223291607`*^9, 3.593827048830175*^9}, {
   3.593831443426094*^9, 3.593831451423892*^9}, 3.5938322905457983`*^9},
 CellLabel->
  "In[3688]:=",ExpressionUUID->"705a497e-0f3f-4bbc-8c24-4609b31a5b19"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    FormBox[
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"t", "+", "1"}]}], "}"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "0"},
        {"t", "1"}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}], "\[NoBreak]", ")"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", 
         RowBox[{"t", "+", "1"}]},
        {
         RowBox[{"t", "+", "1"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"t", "+", "1"}], ")"}], "2"]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}], "\[NoBreak]", ")"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"10", "60"},
        {"60", 
         FractionBox["1330", "3"]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}], "\[NoBreak]", ")"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         FractionBox["133", "250"], 
         RowBox[{"-", 
          FractionBox["9", "125"]}]},
        {
         RowBox[{"-", 
          FractionBox["9", "125"]}], 
         FractionBox["3", "250"]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}], "\[NoBreak]", ")"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True]}], "}"}]], "Output",
 CellChangeTimes->{
  3.593815840698986*^9, 3.593815884103815*^9, 3.593815937263124*^9, 
   3.593822786524807*^9, 3.593822922002967*^9, 3.593823485950232*^9, 
   3.593823693289187*^9, 3.593824450711174*^9, 3.593824489903535*^9, 
   3.59382453779326*^9, {3.593824589669766*^9, 3.5938246113914213`*^9}, 
   3.593824652848565*^9, 3.59382474074858*^9, 3.593824786505107*^9, {
   3.593825387416161*^9, 3.593825404201952*^9}, 3.5938255076210327`*^9, 
   3.593826040296216*^9, 3.5938261477348433`*^9, 3.593826721762629*^9, {
   3.593826833466918*^9, 3.5938268813430557`*^9}, {3.5938269495037613`*^9, 
   3.5938269579224157`*^9}, {3.593827023434713*^9, 3.593827050756404*^9}, 
   3.5938274675040493`*^9, 3.593831454087057*^9, 3.593832293826322*^9, 
   3.593838932075994*^9, 3.593839235248681*^9, 3.593839777116035*^9, 
   3.5938921490555353`*^9, 3.59391302695763*^9, 3.738608815332679*^9, {
   3.7590847155365667`*^9, 3.7590847291384077`*^9}, {3.7590847973801527`*^9, 
   3.75908481523225*^9}, 3.79332736270404*^9, 3.7933274075940943`*^9, 
   3.8232300183128567`*^9},
 CellLabel->
  "Out[3694]=",ExpressionUUID->"bc9b982e-ac29-4c32-9b8d-c1b6325a269a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x0", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1"},
      {"0"}
     }], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"xf", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1"},
      {
       RowBox[{"-", "\[Epsilon]"}]}
     }], "\[NoBreak]", ")"}]}], ";", " ", 
  RowBox[{"dx", "=", 
   RowBox[{"xf", "-", 
    RowBox[{
     RowBox[{"MatrixExp", "[", 
      RowBox[{"a", " ", "tf"}], "]"}], ".", "x0"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expA1", "=", 
   RowBox[{
    RowBox[{"MatrixExp", "[", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"tf", "-", "t"}], ")"}]}], "]"}], "\[Transpose]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"b", "\[Transpose]"}], ".", "expA1", ".", "Pinv", ".", "dx"}], "//",
     "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TraditionalForm", " ", "/@", 
  RowBox[{"{", 
   RowBox[{"dx", ",", "expA1", ",", "u"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.593815455656039*^9, 3.593815561125675*^9}, {
   3.5938159679447403`*^9, 3.593815976702415*^9}, {3.593816087123364*^9, 
   3.59381623865209*^9}, 3.5938163518187513`*^9, 3.5938234370428867`*^9, {
   3.5938247364143133`*^9, 3.593824737612589*^9}, {3.5938247716595383`*^9, 
   3.593824778002926*^9}, {3.593825262037053*^9, 3.593825272874823*^9}, {
   3.593825352765481*^9, 3.5938254011631203`*^9}, {3.5938254629164352`*^9, 
   3.593825463314885*^9}, {3.593826140489802*^9, 3.593826142760083*^9}, {
   3.593826769126313*^9, 3.593826775563621*^9}},
 CellLabel->
  "In[3695]:=",ExpressionUUID->"5f0908ff-6070-4a3f-807a-ba524aa5d9d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    FormBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"0"},
        {
         RowBox[{"-", "10.5`"}]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}], "\[NoBreak]", ")"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", 
         RowBox[{"10", "-", "t"}]},
        {"0", "1"}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}], "\[NoBreak]", ")"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         RowBox[{
          RowBox[{"0.126`", " ", "t"}], "-", "0.63`"}]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}], "\[NoBreak]", ")"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True]}], "}"}]], "Output",
 CellChangeTimes->{{3.593815523855365*^9, 3.5938155617770863`*^9}, {
   3.593815972387374*^9, 3.59381600560929*^9}, {3.593816110178821*^9, 
   3.593816143869341*^9}, {3.5938161834034653`*^9, 3.5938162400860987`*^9}, 
   3.593816352289769*^9, 3.5938227866384373`*^9, 3.593822922098092*^9, 
   3.593823486066947*^9, 3.593823693406639*^9, 3.593824450827561*^9, 
   3.593824490053336*^9, {3.59382473809788*^9, 3.593824740865172*^9}, 
   3.593824786641114*^9, 3.5938252738632097`*^9, {3.593825387516034*^9, 
   3.593825404340816*^9}, 3.5938254646977386`*^9, 3.5938255077225113`*^9, 
   3.5938260404209833`*^9, {3.593826143773059*^9, 3.593826147855926*^9}, {
   3.59382683361532*^9, 3.5938268583709927`*^9}, 3.593826958054853*^9, {
   3.593827027918672*^9, 3.593827050907029*^9}, 3.593827467550796*^9, 
   3.593831454136904*^9, 3.593832293875173*^9, 3.5938389321270533`*^9, 
   3.593839235299162*^9, 3.593839777167438*^9, 3.5938921491052923`*^9, 
   3.593913027010812*^9, 3.738608815428844*^9, {3.7590847157048883`*^9, 
   3.759084729236473*^9}, {3.7590847975003967`*^9, 3.759084815298008*^9}, 
   3.793327362744191*^9, 3.793327407603957*^9, 3.823230018340815*^9},
 CellLabel->
  "Out[3698]=",ExpressionUUID->"c117af3b-79b8-4546-a04a-366a5c7b55dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x1out", ",", "x2out"}], "}"}], "=", 
  RowBox[{"OutputResponse", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"sys", ",", 
      RowBox[{"Flatten", "[", "x0", "]"}]}], "}"}], ",", 
    RowBox[{"u", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "t"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.593822966732684*^9, {3.5938230006856737`*^9, 3.593823073487701*^9}, {
   3.59382311115244*^9, 3.593823124915674*^9}, {3.5938235200785418`*^9, 
   3.5938235257891293`*^9}, 3.5938251576089897`*^9, 3.73860883054779*^9},
 CellLabel->
  "In[3699]:=",ExpressionUUID->"b068eed6-efde-4b0f-8939-e84702e6f4a8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.063`", " ", 
     RowBox[{"(", 
      RowBox[{"15.873015873015873`", "\[VeryThinSpace]", "-", 
       RowBox[{"10.`", " ", "t"}], "+", 
       RowBox[{"1.`", " ", 
        SuperscriptBox["t", "2"]}]}], ")"}]}]}], ",", 
   RowBox[{"0.`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.021000000000000005`", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"17.619047619047613`", " ", "t"}], "-", 
       RowBox[{"11.999999999999998`", " ", 
        SuperscriptBox["t", "2"]}], "+", 
       RowBox[{"1.`", " ", 
        SuperscriptBox["t", "3"]}]}], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.593822970021859*^9, {3.5938230165249653`*^9, 3.593823076132913*^9}, {
   3.593823114291711*^9, 3.593823127373253*^9}, 3.593823486149788*^9, 
   3.5938235264578867`*^9, 3.5938236934892273`*^9, 3.593824450911314*^9, 
   3.59382449015201*^9, 3.593824740942185*^9, 3.5938247866841087`*^9, 
   3.5938251585004663`*^9, 3.593825279745041*^9, {3.593825387566011*^9, 
   3.593825404385388*^9}, 3.593825507772194*^9, 3.593826040454714*^9, 
   3.593826147905944*^9, {3.5938268336656322`*^9, 3.5938268584216423`*^9}, 
   3.593826958089326*^9, {3.593827027968993*^9, 3.5938270509561996`*^9}, 
   3.5938274676000633`*^9, 3.5938314541857033`*^9, 3.5938322939252853`*^9, 
   3.593838932175312*^9, 3.593839235347872*^9, 3.5938397772154512`*^9, 
   3.5938921491552153`*^9, 3.5939130270597343`*^9, {3.738608815530051*^9, 
   3.73860883163066*^9}, {3.7590847158715897`*^9, 3.759084729337326*^9}, {
   3.75908479759862*^9, 3.759084815366069*^9}, 3.79332736275452*^9, 
   3.793327407646078*^9, 3.8232300183522873`*^9},
 CellLabel->
  "Out[3699]=",ExpressionUUID->"6fefecd8-ef44-4940-a1cb-a05518b356d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vp", "=", 
   RowBox[{"VectorPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", ".2", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"VectorColorFunction", "\[Rule]", "\"\<GrayTones\>\""}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pp", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1out", ",", "x2out"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tf"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pall", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", "x1out", ",", "x2out"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tf"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Show", "[", 
      RowBox[{"vp", ",", "pp"}], "]"}], ",", "pall"}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.593825752588146*^9, 3.593825792926815*^9}, {
   3.5938260234139833`*^9, 3.593826028653735*^9}, {3.593826176537128*^9, 
   3.59382619860146*^9}, {3.593826483675952*^9, 3.5938265004523773`*^9}, {
   3.5938265598717747`*^9, 3.59382660082909*^9}, {3.5938266467212353`*^9, 
   3.5938266716548*^9}, {3.5938268060182333`*^9, 3.593826811426132*^9}, {
   3.593826983761568*^9, 3.593826991152261*^9}, {3.593831730717346*^9, 
   3.5938317353353243`*^9}, {3.593831977234146*^9, 3.59383200560419*^9}, 
   3.593832043899325*^9, 3.593832085275818*^9, {3.5938322996233788`*^9, 
   3.5938323032402267`*^9}, {3.7590847011696587`*^9, 3.759084792804171*^9}},
 CellLabel->
  "In[3700]:=",ExpressionUUID->"8606eba1-c162-4d17-96d5-cb51364b8625"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, 
        {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{-1., -2.904}, {-1., -3.096}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{-0.8666666666666667, -2.904}, {-0.8666666666666667, \
-3.096}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{-0.7333333333333334, -2.904}, {-0.7333333333333334, \
-3.096}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.51593, 0.541278, 0.547958], 
           ArrowBox[{{-0.6, -2.904}, {-0.6, -3.096}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.39435333333333333`, 0.4257073333333334, 0.443674], 
           ArrowBox[{{-0.4666666666666667, -2.904}, {-0.4666666666666667, \
-3.096}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.2974953333333334, 0.3275776666666667, 0.35059833333333335`], 
           ArrowBox[{{-0.33333333333333337`, -2.904}, {-0.33333333333333337`, \
-3.096}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{-0.19999999999999996`, -2.904}, {-0.19999999999999996`, \
-3.096}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{-0.06666666666666665, -2.904}, {-0.06666666666666665, \
-3.096}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{0.06666666666666665, -3.096}, {
            0.06666666666666665, -2.904}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{0.19999999999999996`, -3.096}, {
            0.19999999999999996`, -2.904}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.29749533333333333`, 0.32757766666666666`, 0.35059833333333323`], 
           ArrowBox[{{0.33333333333333326`, -3.096}, {
            0.33333333333333326`, -2.904}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.3943533333333333, 0.4257073333333333, 0.4436739999999999], 
           ArrowBox[{{0.46666666666666656`, -3.096}, {
            0.46666666666666656`, -2.904}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.5159300000000001, 0.5412780000000001, 0.5479580000000001], 
           ArrowBox[{{0.6000000000000001, -3.096}, {
            0.6000000000000001, -2.904}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{0.7333333333333334, -3.096}, {
            0.7333333333333334, -2.904}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{0.8666666666666667, -3.096}, {
            0.8666666666666667, -2.904}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{1., -3.096}, {1., -2.904}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8630773333333333, 0.8665753333333334, 0.8339470000000001], 
           ArrowBox[{{-0.9333333333333333, -2.6906666666666665`}, \
{-0.9333333333333333, -2.8826666666666667`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.753644, 0.757794, 0.737969], 
           ArrowBox[{{-0.8, -2.6906666666666665`}, {-0.8, \
-2.8826666666666667`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.5951680000000001, 0.6134500000000002, 0.6112950000000001], 
           ArrowBox[{{-0.6666666666666667, -2.6906666666666665`}, \
{-0.6666666666666667, -2.8826666666666667`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.45514166666666667`, 0.4834926666666667, 0.4958159999999999], 
           ArrowBox[{{-0.5333333333333333, -2.6906666666666665`}, \
{-0.5333333333333333, -2.8826666666666667`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.333565, 0.367922, 0.391532], 
           ArrowBox[{{-0.4, -2.6906666666666665`}, {-0.4, \
-2.8826666666666667`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.26142566666666667`, 0.28723333333333334`, 0.3096646666666667], 
           ArrowBox[{{-0.2666666666666667, -2.6906666666666665`}, \
{-0.2666666666666667, -2.8826666666666667`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.18357066666666666`, 0.197926, 0.2124873333333333], 
           ArrowBox[{{-0.1333333333333333, -2.6906666666666665`}, \
{-0.1333333333333333, -2.8826666666666667`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.18357066666666666`, 0.197926, 0.2124873333333333], 
           ArrowBox[{{0.1333333333333333, -2.8826666666666667`}, {
            0.1333333333333333, -2.6906666666666665`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.2614256666666666, 0.28723333333333334`, 0.30966466666666664`], 
           ArrowBox[{{0.2666666666666666, -2.8826666666666667`}, {
            0.2666666666666666, -2.6906666666666665`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.33356499999999994`, 0.36792199999999997`, 0.39153199999999994`], 
           ArrowBox[{{0.3999999999999999, -2.8826666666666667`}, {
            0.3999999999999999, -2.6906666666666665`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.45514166666666656`, 0.4834926666666666, 0.49581599999999987`], 
           ArrowBox[{{0.5333333333333332, -2.8826666666666667`}, {
            0.5333333333333332, -2.6906666666666665`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.5951680000000001, 0.6134500000000002, 0.6112950000000001], 
           ArrowBox[{{0.6666666666666667, -2.8826666666666667`}, {
            0.6666666666666667, -2.6906666666666665`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.753644, 0.757794, 0.737969], 
           ArrowBox[{{0.8, -2.8826666666666667`}, {
            0.8, -2.6906666666666665`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8630773333333333, 0.8665753333333334, 0.8339470000000001], 
           ArrowBox[{{0.9333333333333333, -2.8826666666666667`}, {
            0.9333333333333333, -2.6906666666666665`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{-1., -2.477333333333333}, {-1., \
-2.6693333333333333`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{-0.8666666666666667, -2.477333333333333}, \
{-0.8666666666666667, -2.6693333333333333`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{-0.7333333333333334, -2.477333333333333}, \
{-0.7333333333333334, -2.6693333333333333`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.51593, 0.541278, 0.547958], 
           ArrowBox[{{-0.6, -2.477333333333333}, {-0.6, \
-2.6693333333333333`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.39435333333333333`, 0.4257073333333334, 0.443674], 
           ArrowBox[{{-0.4666666666666667, -2.477333333333333}, \
{-0.4666666666666667, -2.6693333333333333`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.2974953333333334, 0.3275776666666667, 0.35059833333333335`], 
           ArrowBox[{{-0.33333333333333337`, -2.477333333333333}, \
{-0.33333333333333337`, -2.6693333333333333`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{-0.19999999999999996`, -2.477333333333333}, \
{-0.19999999999999996`, -2.6693333333333333`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{-0.06666666666666665, -2.477333333333333}, \
{-0.06666666666666665, -2.6693333333333333`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{0.06666666666666665, -2.6693333333333333`}, {
            0.06666666666666665, -2.477333333333333}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{0.19999999999999996`, -2.6693333333333333`}, {
            0.19999999999999996`, -2.477333333333333}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.29749533333333333`, 0.32757766666666666`, 0.35059833333333323`], 
           ArrowBox[{{0.33333333333333326`, -2.6693333333333333`}, {
            0.33333333333333326`, -2.477333333333333}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.3943533333333333, 0.4257073333333333, 0.4436739999999999], 
           ArrowBox[{{0.46666666666666656`, -2.6693333333333333`}, {
            0.46666666666666656`, -2.477333333333333}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.5159300000000001, 0.5412780000000001, 0.5479580000000001], 
           ArrowBox[{{0.6000000000000001, -2.6693333333333333`}, {
            0.6000000000000001, -2.477333333333333}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{0.7333333333333334, -2.6693333333333333`}, {
            0.7333333333333334, -2.477333333333333}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{0.8666666666666667, -2.6693333333333333`}, {
            0.8666666666666667, -2.477333333333333}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{1., -2.6693333333333333`}, {1., -2.477333333333333}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8630773333333333, 0.8665753333333334, 0.8339470000000001], 
           ArrowBox[{{-0.9333333333333333, -2.264}, {-0.9333333333333333, \
-2.456}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.753644, 0.757794, 0.737969], 
           ArrowBox[{{-0.8, -2.264}, {-0.8, -2.456}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.5951680000000001, 0.6134500000000002, 0.6112950000000001], 
           ArrowBox[{{-0.6666666666666667, -2.264}, {-0.6666666666666667, \
-2.456}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.45514166666666667`, 0.4834926666666667, 0.4958159999999999], 
           ArrowBox[{{-0.5333333333333333, -2.264}, {-0.5333333333333333, \
-2.456}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.333565, 0.367922, 0.391532], 
           ArrowBox[{{-0.4, -2.264}, {-0.4, -2.456}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.26142566666666667`, 0.28723333333333334`, 0.3096646666666667], 
           ArrowBox[{{-0.2666666666666667, -2.264}, {-0.2666666666666667, \
-2.456}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.18357066666666666`, 0.197926, 0.2124873333333333], 
           ArrowBox[{{-0.1333333333333333, -2.264}, {-0.1333333333333333, \
-2.456}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.18357066666666666`, 0.197926, 0.2124873333333333], 
           ArrowBox[{{0.1333333333333333, -2.456}, {
            0.1333333333333333, -2.264}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.2614256666666666, 0.28723333333333334`, 0.30966466666666664`], 
           ArrowBox[{{0.2666666666666666, -2.456}, {
            0.2666666666666666, -2.264}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.33356499999999994`, 0.36792199999999997`, 0.39153199999999994`], 
           ArrowBox[{{0.3999999999999999, -2.456}, {
            0.3999999999999999, -2.264}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.45514166666666656`, 0.4834926666666666, 0.49581599999999987`], 
           ArrowBox[{{0.5333333333333332, -2.456}, {
            0.5333333333333332, -2.264}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.5951680000000001, 0.6134500000000002, 0.6112950000000001], 
           ArrowBox[{{0.6666666666666667, -2.456}, {
            0.6666666666666667, -2.264}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.753644, 0.757794, 0.737969], 
           ArrowBox[{{0.8, -2.456}, {0.8, -2.264}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8630773333333333, 0.8665753333333334, 0.8339470000000001], 
           ArrowBox[{{0.9333333333333333, -2.456}, {
            0.9333333333333333, -2.264}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{-1., -2.0506666666666664`}, {-1., \
-2.2426666666666666`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{-0.8666666666666667, -2.0506666666666664`}, \
{-0.8666666666666667, -2.2426666666666666`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{-0.7333333333333334, -2.0506666666666664`}, \
{-0.7333333333333334, -2.2426666666666666`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.51593, 0.541278, 0.547958], 
           ArrowBox[{{-0.6, -2.0506666666666664`}, {-0.6, \
-2.2426666666666666`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.39435333333333333`, 0.4257073333333334, 0.443674], 
           ArrowBox[{{-0.4666666666666667, -2.0506666666666664`}, \
{-0.4666666666666667, -2.2426666666666666`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.2974953333333334, 0.3275776666666667, 0.35059833333333335`], 
           ArrowBox[{{-0.33333333333333337`, -2.0506666666666664`}, \
{-0.33333333333333337`, -2.2426666666666666`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{-0.19999999999999996`, -2.0506666666666664`}, \
{-0.19999999999999996`, -2.2426666666666666`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{-0.06666666666666665, -2.0506666666666664`}, \
{-0.06666666666666665, -2.2426666666666666`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{0.06666666666666665, -2.2426666666666666`}, {
            0.06666666666666665, -2.0506666666666664`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{0.19999999999999996`, -2.2426666666666666`}, {
            0.19999999999999996`, -2.0506666666666664`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.29749533333333333`, 0.32757766666666666`, 0.35059833333333323`], 
           ArrowBox[{{0.33333333333333326`, -2.2426666666666666`}, {
            0.33333333333333326`, -2.0506666666666664`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.3943533333333333, 0.4257073333333333, 0.4436739999999999], 
           ArrowBox[{{0.46666666666666656`, -2.2426666666666666`}, {
            0.46666666666666656`, -2.0506666666666664`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.5159300000000001, 0.5412780000000001, 0.5479580000000001], 
           ArrowBox[{{0.6000000000000001, -2.2426666666666666`}, {
            0.6000000000000001, -2.0506666666666664`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{0.7333333333333334, -2.2426666666666666`}, {
            0.7333333333333334, -2.0506666666666664`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{0.8666666666666667, -2.2426666666666666`}, {
            0.8666666666666667, -2.0506666666666664`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{1., -2.2426666666666666`}, {
            1., -2.0506666666666664`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.8630773333333333, 0.8665753333333334, 0.8339470000000001], 
           ArrowBox[{{-0.9333333333333333, -1.837333333333333}, \
{-0.9333333333333333, -2.029333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.753644, 0.757794, 0.737969], 
           
           ArrowBox[{{-0.8, -1.837333333333333}, {-0.8, \
-2.029333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.5951680000000001, 0.6134500000000002, 0.6112950000000001], 
           ArrowBox[{{-0.6666666666666667, -1.837333333333333}, \
{-0.6666666666666667, -2.029333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.45514166666666667`, 0.4834926666666667, 0.4958159999999999], 
           ArrowBox[{{-0.5333333333333333, -1.837333333333333}, \
{-0.5333333333333333, -2.029333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.333565, 0.367922, 0.391532], 
           ArrowBox[{{-0.4, -1.837333333333333}, {-0.4, \
-2.029333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.26142566666666667`, 0.28723333333333334`, 0.3096646666666667], 
           ArrowBox[{{-0.2666666666666667, -1.837333333333333}, \
{-0.2666666666666667, -2.029333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.18357066666666666`, 0.197926, 0.2124873333333333], 
           ArrowBox[{{-0.1333333333333333, -1.837333333333333}, \
{-0.1333333333333333, -2.029333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.18357066666666666`, 0.197926, 0.2124873333333333], 
           ArrowBox[{{0.1333333333333333, -2.0293333333333337`}, {
            0.1333333333333333, -1.8373333333333335`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.2614256666666666, 0.28723333333333334`, 0.30966466666666664`], 
           ArrowBox[{{0.2666666666666666, -2.0293333333333337`}, {
            0.2666666666666666, -1.8373333333333335`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.33356499999999994`, 0.36792199999999997`, 0.39153199999999994`], 
           ArrowBox[{{0.3999999999999999, -2.0293333333333337`}, {
            0.3999999999999999, -1.8373333333333335`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.45514166666666656`, 0.4834926666666666, 0.49581599999999987`], 
           ArrowBox[{{0.5333333333333332, -2.0293333333333337`}, {
            0.5333333333333332, -1.8373333333333335`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.5951680000000001, 0.6134500000000002, 0.6112950000000001], 
           ArrowBox[{{0.6666666666666667, -2.0293333333333337`}, {
            0.6666666666666667, -1.8373333333333335`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.753644, 0.757794, 0.737969], 
           ArrowBox[{{0.8, -2.0293333333333337`}, {
            0.8, -1.8373333333333335`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.8630773333333333, 0.8665753333333334, 0.8339470000000001], 
           ArrowBox[{{0.9333333333333333, -2.0293333333333337`}, {
            0.9333333333333333, -1.8373333333333335`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{-1., -1.6239999999999997`}, {-1., \
-1.8159999999999998`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{-0.8666666666666667, -1.6239999999999997`}, \
{-0.8666666666666667, -1.8159999999999998`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{-0.7333333333333334, -1.6239999999999997`}, \
{-0.7333333333333334, -1.8159999999999998`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.51593, 0.541278, 0.547958], 
           ArrowBox[{{-0.6, -1.6239999999999997`}, {-0.6, \
-1.8159999999999998`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.39435333333333333`, 0.4257073333333334, 0.443674], 
           ArrowBox[{{-0.4666666666666667, -1.6239999999999997`}, \
{-0.4666666666666667, -1.8159999999999998`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.2974953333333334, 0.3275776666666667, 0.35059833333333335`], 
           ArrowBox[{{-0.33333333333333337`, -1.6239999999999997`}, \
{-0.33333333333333337`, -1.8159999999999998`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{-0.19999999999999996`, -1.6239999999999997`}, \
{-0.19999999999999996`, -1.8159999999999998`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{-0.06666666666666665, -1.6239999999999997`}, \
{-0.06666666666666665, -1.8159999999999998`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{0.06666666666666665, -1.8160000000000003`}, {
            0.06666666666666665, -1.624}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{0.19999999999999996`, -1.8160000000000003`}, {
            0.19999999999999996`, -1.624}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.29749533333333333`, 0.32757766666666666`, 0.35059833333333323`], 
           ArrowBox[{{0.33333333333333326`, -1.8160000000000003`}, {
            0.33333333333333326`, -1.624}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.3943533333333333, 0.4257073333333333, 0.4436739999999999], 
           ArrowBox[{{0.46666666666666656`, -1.8160000000000003`}, {
            0.46666666666666656`, -1.624}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.5159300000000001, 0.5412780000000001, 0.5479580000000001], 
           ArrowBox[{{0.6000000000000001, -1.8160000000000003`}, {
            0.6000000000000001, -1.624}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{0.7333333333333334, -1.8160000000000003`}, {
            0.7333333333333334, -1.624}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{0.8666666666666667, -1.8160000000000003`}, {
            0.8666666666666667, -1.624}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{1., -1.8160000000000003`}, {1., -1.624}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.8630773333333333, 0.8665753333333334, 0.8339470000000001], 
           ArrowBox[{{-0.9333333333333333, -1.4106666666666663`}, \
{-0.9333333333333333, -1.6026666666666665`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.753644, 0.757794, 0.737969], 
           ArrowBox[{{-0.8, -1.4106666666666663`}, {-0.8, \
-1.6026666666666665`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.5951680000000001, 0.6134500000000002, 0.6112950000000001], 
           ArrowBox[{{-0.6666666666666667, -1.4106666666666663`}, \
{-0.6666666666666667, -1.6026666666666665`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.45514166666666667`, 0.4834926666666667, 0.4958159999999999], 
           ArrowBox[{{-0.5333333333333333, -1.4106666666666663`}, \
{-0.5333333333333333, -1.6026666666666665`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.333565, 0.367922, 0.391532], 
           ArrowBox[{{-0.4, -1.4106666666666663`}, {-0.4, \
-1.6026666666666665`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.26142566666666667`, 0.28723333333333334`, 0.3096646666666667], 
           ArrowBox[{{-0.2666666666666667, -1.4106666666666663`}, \
{-0.2666666666666667, -1.6026666666666665`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.18357066666666666`, 0.197926, 0.2124873333333333], 
           ArrowBox[{{-0.1333333333333333, -1.4106666666666663`}, \
{-0.1333333333333333, -1.6026666666666665`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.18357066666666666`, 0.197926, 0.2124873333333333], 
           ArrowBox[{{0.1333333333333333, -1.602666666666667}, {
            0.1333333333333333, -1.4106666666666667`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.2614256666666666, 0.28723333333333334`, 0.30966466666666664`], 
           ArrowBox[{{0.2666666666666666, -1.602666666666667}, {
            0.2666666666666666, -1.4106666666666667`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.33356499999999994`, 0.36792199999999997`, 0.39153199999999994`], 
           ArrowBox[{{0.3999999999999999, -1.602666666666667}, {
            0.3999999999999999, -1.4106666666666667`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.45514166666666656`, 0.4834926666666666, 0.49581599999999987`], 
           ArrowBox[{{0.5333333333333332, -1.602666666666667}, {
            0.5333333333333332, -1.4106666666666667`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.5951680000000001, 0.6134500000000002, 0.6112950000000001], 
           ArrowBox[{{0.6666666666666667, -1.602666666666667}, {
            0.6666666666666667, -1.4106666666666667`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.753644, 0.757794, 0.737969], 
           ArrowBox[{{0.8, -1.602666666666667}, {
            0.8, -1.4106666666666667`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.8630773333333333, 0.8665753333333334, 0.8339470000000001], 
           ArrowBox[{{0.9333333333333333, -1.602666666666667}, {
            0.9333333333333333, -1.4106666666666667`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{-1., -1.197333333333333}, {-1., -1.389333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{-0.8666666666666667, -1.197333333333333}, \
{-0.8666666666666667, -1.389333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{-0.7333333333333334, -1.197333333333333}, \
{-0.7333333333333334, -1.389333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.51593, 0.541278, 0.547958], 
           ArrowBox[{{-0.6, -1.197333333333333}, {-0.6, \
-1.389333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.39435333333333333`, 0.4257073333333334, 0.443674], 
           ArrowBox[{{-0.4666666666666667, -1.197333333333333}, \
{-0.4666666666666667, -1.389333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.2974953333333334, 0.3275776666666667, 0.35059833333333335`], 
           ArrowBox[{{-0.33333333333333337`, -1.197333333333333}, \
{-0.33333333333333337`, -1.389333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{-0.19999999999999996`, -1.197333333333333}, \
{-0.19999999999999996`, -1.389333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{-0.06666666666666665, -1.197333333333333}, \
{-0.06666666666666665, -1.389333333333333}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{0.06666666666666665, -1.3893333333333335`}, {
            0.06666666666666665, -1.1973333333333334`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{0.19999999999999996`, -1.3893333333333335`}, {
            0.19999999999999996`, -1.1973333333333334`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.29749533333333333`, 0.32757766666666666`, 0.35059833333333323`], 
           ArrowBox[{{0.33333333333333326`, -1.3893333333333335`}, {
            0.33333333333333326`, -1.1973333333333334`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.3943533333333333, 0.4257073333333333, 0.4436739999999999], 
           ArrowBox[{{0.46666666666666656`, -1.3893333333333335`}, {
            0.46666666666666656`, -1.1973333333333334`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.5159300000000001, 0.5412780000000001, 0.5479580000000001], 
           ArrowBox[{{0.6000000000000001, -1.3893333333333335`}, {
            0.6000000000000001, -1.1973333333333334`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{0.7333333333333334, -1.3893333333333335`}, {
            0.7333333333333334, -1.1973333333333334`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{0.8666666666666667, -1.3893333333333335`}, {
            0.8666666666666667, -1.1973333333333334`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{1., -1.3893333333333335`}, {
            1., -1.1973333333333334`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.8630773333333333, 0.8665753333333334, 0.8339470000000001], 
           ArrowBox[{{-0.9333333333333333, -0.9839999999999995}, \
{-0.9333333333333333, -1.1759999999999997`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.753644, 0.757794, 0.737969], 
           ArrowBox[{{-0.8, -0.9839999999999995}, {-0.8, \
-1.1759999999999997`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.5951680000000001, 0.6134500000000002, 0.6112950000000001], 
           ArrowBox[{{-0.6666666666666667, -0.9839999999999995}, \
{-0.6666666666666667, -1.1759999999999997`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.45514166666666667`, 0.4834926666666667, 0.4958159999999999], 
           ArrowBox[{{-0.5333333333333333, -0.9839999999999995}, \
{-0.5333333333333333, -1.1759999999999997`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.333565, 0.367922, 0.391532], 
           ArrowBox[{{-0.4, -0.9839999999999995}, {-0.4, \
-1.1759999999999997`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[
           0.26142566666666667`, 0.28723333333333334`, 0.3096646666666667], 
           ArrowBox[{{-0.2666666666666667, -0.9839999999999995}, \
{-0.2666666666666667, -1.1759999999999997`}}]}}, 
         {Arrowheads[{{0.02999999999999997, 1.}}], 
          {RGBColor[0.18357066666666666`, 0.197926, 0.2124873333333333], 
           ArrowBox[{{-0.1333333333333333, -0.9839999999999995}, \
{-0.1333333333333333, -1.1759999999999997`}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.18357066666666666`, 0.197926, 0.2124873333333333], 
           ArrowBox[{{0.1333333333333333, -1.176}, {
            0.1333333333333333, -0.9839999999999998}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.2614256666666666, 0.28723333333333334`, 0.30966466666666664`], 
           ArrowBox[{{0.2666666666666666, -1.176}, {
            0.2666666666666666, -0.9839999999999998}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.33356499999999994`, 0.36792199999999997`, 0.39153199999999994`], 
           ArrowBox[{{0.3999999999999999, -1.176}, {
            0.3999999999999999, -0.9839999999999998}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.45514166666666656`, 0.4834926666666666, 0.49581599999999987`], 
           ArrowBox[{{0.5333333333333332, -1.176}, {
            0.5333333333333332, -0.9839999999999998}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.5951680000000001, 0.6134500000000002, 0.6112950000000001], 
           ArrowBox[{{0.6666666666666667, -1.176}, {
            0.6666666666666667, -0.9839999999999998}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.753644, 0.757794, 0.737969], 
           ArrowBox[{{0.8, -1.176}, {0.8, -0.9839999999999998}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8630773333333333, 0.8665753333333334, 0.8339470000000001], 
           ArrowBox[{{0.9333333333333333, -1.176}, {
            0.9333333333333333, -0.9839999999999998}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{-1., -0.7706666666666666}, {-1., \
-0.9626666666666668}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{-0.8666666666666667, -0.7706666666666666}, \
{-0.8666666666666667, -0.9626666666666668}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{-0.7333333333333334, -0.7706666666666666}, \
{-0.7333333333333334, -0.9626666666666668}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.51593, 0.541278, 0.547958], 
           ArrowBox[{{-0.6, -0.7706666666666666}, {-0.6, \
-0.9626666666666668}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.39435333333333333`, 0.4257073333333334, 0.443674], 
           ArrowBox[{{-0.4666666666666667, -0.7706666666666666}, \
{-0.4666666666666667, -0.9626666666666668}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.2974953333333334, 0.3275776666666667, 0.35059833333333335`], 
           ArrowBox[{{-0.33333333333333337`, -0.7706666666666666}, \
{-0.33333333333333337`, -0.9626666666666668}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{-0.19999999999999996`, -0.7706666666666666}, \
{-0.19999999999999996`, -0.9626666666666668}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{-0.06666666666666665, -0.7706666666666666}, \
{-0.06666666666666665, -0.9626666666666668}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{0.06666666666666665, -0.9626666666666668}, {
            0.06666666666666665, -0.7706666666666666}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{0.19999999999999996`, -0.9626666666666668}, {
            0.19999999999999996`, -0.7706666666666666}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.29749533333333333`, 0.32757766666666666`, 0.35059833333333323`], 
           ArrowBox[{{0.33333333333333326`, -0.9626666666666668}, {
            0.33333333333333326`, -0.7706666666666666}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.3943533333333333, 0.4257073333333333, 0.4436739999999999], 
           ArrowBox[{{0.46666666666666656`, -0.9626666666666668}, {
            0.46666666666666656`, -0.7706666666666666}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.5159300000000001, 0.5412780000000001, 0.5479580000000001], 
           ArrowBox[{{0.6000000000000001, -0.9626666666666668}, {
            0.6000000000000001, -0.7706666666666666}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{0.7333333333333334, -0.9626666666666668}, {
            0.7333333333333334, -0.7706666666666666}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{0.8666666666666667, -0.9626666666666668}, {
            0.8666666666666667, -0.7706666666666666}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{1., -0.9626666666666668}, {1., -0.7706666666666666}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8630773333333333, 0.8665753333333334, 0.8339470000000001], 
           ArrowBox[{{-0.9333333333333333, -0.5573333333333332}, \
{-0.9333333333333333, -0.7493333333333334}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.753644, 0.757794, 0.737969], 
           ArrowBox[{{-0.8, -0.5573333333333332}, {-0.8, \
-0.7493333333333334}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.5951680000000001, 0.6134500000000002, 0.6112950000000001], 
           ArrowBox[{{-0.6666666666666667, -0.5573333333333332}, \
{-0.6666666666666667, -0.7493333333333334}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.45514166666666667`, 0.4834926666666667, 0.4958159999999999], 
           ArrowBox[{{-0.5333333333333333, -0.5573333333333332}, \
{-0.5333333333333333, -0.7493333333333334}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.333565, 0.367922, 0.391532], 
           
           ArrowBox[{{-0.4, -0.5573333333333332}, {-0.4, \
-0.7493333333333334}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.26142566666666667`, 0.28723333333333334`, 0.3096646666666667], 
           ArrowBox[{{-0.2666666666666667, -0.5573333333333332}, \
{-0.2666666666666667, -0.7493333333333334}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.18357066666666666`, 0.197926, 0.2124873333333333], 
           ArrowBox[{{-0.1333333333333333, -0.5573333333333332}, \
{-0.1333333333333333, -0.7493333333333334}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.18357066666666666`, 0.197926, 0.2124873333333333], 
           ArrowBox[{{0.1333333333333333, -0.7493333333333334}, {
            0.1333333333333333, -0.5573333333333332}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.2614256666666666, 0.28723333333333334`, 0.30966466666666664`], 
           ArrowBox[{{0.2666666666666666, -0.7493333333333334}, {
            0.2666666666666666, -0.5573333333333332}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.33356499999999994`, 0.36792199999999997`, 0.39153199999999994`], 
           ArrowBox[{{0.3999999999999999, -0.7493333333333334}, {
            0.3999999999999999, -0.5573333333333332}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.45514166666666656`, 0.4834926666666666, 0.49581599999999987`], 
           ArrowBox[{{0.5333333333333332, -0.7493333333333334}, {
            0.5333333333333332, -0.5573333333333332}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.5951680000000001, 0.6134500000000002, 0.6112950000000001], 
           ArrowBox[{{0.6666666666666667, -0.7493333333333334}, {
            0.6666666666666667, -0.5573333333333332}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[0.753644, 0.757794, 0.737969], 
           ArrowBox[{{0.8, -0.7493333333333334}, {
            0.8, -0.5573333333333332}}]}}, 
         {Arrowheads[{{0.030000000000000027`, 1.}}], 
          {RGBColor[
           0.8630773333333333, 0.8665753333333334, 0.8339470000000001], 
           ArrowBox[{{0.9333333333333333, -0.7493333333333334}, {
            0.9333333333333333, -0.5573333333333332}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{-1., -0.344}, {-1., -0.5359999999999999}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{-0.8666666666666667, -0.344}, {-0.8666666666666667, \
-0.5359999999999999}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{-0.7333333333333334, -0.344}, {-0.7333333333333334, \
-0.5359999999999999}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.51593, 0.541278, 0.547958], 
           ArrowBox[{{-0.6, -0.344}, {-0.6, -0.5359999999999999}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.39435333333333333`, 0.4257073333333334, 0.443674], 
           ArrowBox[{{-0.4666666666666667, -0.344}, {-0.4666666666666667, \
-0.5359999999999999}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.2974953333333334, 0.3275776666666667, 0.35059833333333335`], 
           ArrowBox[{{-0.33333333333333337`, -0.344}, {-0.33333333333333337`, \
-0.5359999999999999}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{-0.19999999999999996`, -0.344}, {-0.19999999999999996`, \
-0.5359999999999999}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{-0.06666666666666665, -0.344}, {-0.06666666666666665, \
-0.5359999999999999}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{0.06666666666666665, -0.5359999999999999}, {
            0.06666666666666665, -0.344}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{0.19999999999999996`, -0.5359999999999999}, {
            0.19999999999999996`, -0.344}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.29749533333333333`, 0.32757766666666666`, 0.35059833333333323`], 
           ArrowBox[{{0.33333333333333326`, -0.5359999999999999}, {
            0.33333333333333326`, -0.344}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.3943533333333333, 0.4257073333333333, 0.4436739999999999], 
           ArrowBox[{{0.46666666666666656`, -0.5359999999999999}, {
            0.46666666666666656`, -0.344}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.5159300000000001, 0.5412780000000001, 0.5479580000000001], 
           ArrowBox[{{0.6000000000000001, -0.5359999999999999}, {
            0.6000000000000001, -0.344}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{0.7333333333333334, -0.5359999999999999}, {
            0.7333333333333334, -0.344}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{0.8666666666666667, -0.5359999999999999}, {
            0.8666666666666667, -0.344}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{1., -0.5359999999999999}, {1., -0.344}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.8630773333333333, 0.8665753333333334, 0.8339470000000001], 
           ArrowBox[{{-0.9333333333333333, -0.13066666666666657`}, \
{-0.9333333333333333, -0.32266666666666655`}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.753644, 0.757794, 0.737969], 
           
           ArrowBox[{{-0.8, -0.13066666666666657`}, {-0.8, \
-0.32266666666666655`}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.5951680000000001, 0.6134500000000002, 0.6112950000000001], 
           ArrowBox[{{-0.6666666666666667, -0.13066666666666657`}, \
{-0.6666666666666667, -0.32266666666666655`}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.45514166666666667`, 0.4834926666666667, 0.4958159999999999], 
           ArrowBox[{{-0.5333333333333333, -0.13066666666666657`}, \
{-0.5333333333333333, -0.32266666666666655`}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.333565, 0.367922, 0.391532], 
           ArrowBox[{{-0.4, -0.13066666666666657`}, {-0.4, \
-0.32266666666666655`}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.26142566666666667`, 0.28723333333333334`, 0.3096646666666667], 
           ArrowBox[{{-0.2666666666666667, -0.13066666666666657`}, \
{-0.2666666666666667, -0.32266666666666655`}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.18357066666666666`, 0.197926, 0.2124873333333333], 
           ArrowBox[{{-0.1333333333333333, -0.13066666666666657`}, \
{-0.1333333333333333, -0.32266666666666655`}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.18357066666666666`, 0.197926, 0.2124873333333333], 
           ArrowBox[{{0.1333333333333333, -0.32266666666666655`}, {
            0.1333333333333333, -0.13066666666666657`}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.2614256666666666, 0.28723333333333334`, 0.30966466666666664`], 
           ArrowBox[{{0.2666666666666666, -0.32266666666666655`}, {
            0.2666666666666666, -0.13066666666666657`}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.33356499999999994`, 0.36792199999999997`, 0.39153199999999994`], 
           ArrowBox[{{0.3999999999999999, -0.32266666666666655`}, {
            0.3999999999999999, -0.13066666666666657`}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.45514166666666656`, 0.4834926666666666, 0.49581599999999987`], 
           ArrowBox[{{0.5333333333333332, -0.32266666666666655`}, {
            0.5333333333333332, -0.13066666666666657`}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.5951680000000001, 0.6134500000000002, 0.6112950000000001], 
           ArrowBox[{{0.6666666666666667, -0.32266666666666655`}, {
            0.6666666666666667, -0.13066666666666657`}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.753644, 0.757794, 0.737969], 
           ArrowBox[{{0.8, -0.32266666666666655`}, {
            0.8, -0.13066666666666657`}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.8630773333333333, 0.8665753333333334, 0.8339470000000001], 
           ArrowBox[{{0.9333333333333333, -0.32266666666666655`}, {
            0.9333333333333333, -0.13066666666666657`}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{-1., 
            0.0826666666666668}, {-1., -0.1093333333333332}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{-0.8666666666666667, 
            0.0826666666666668}, {-0.8666666666666667, \
-0.1093333333333332}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{-0.7333333333333334, 
            0.0826666666666668}, {-0.7333333333333334, \
-0.1093333333333332}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.51593, 0.541278, 0.547958], 
           ArrowBox[{{-0.6, 
            0.0826666666666668}, {-0.6, -0.1093333333333332}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.39435333333333333`, 0.4257073333333334, 0.443674], 
           ArrowBox[{{-0.4666666666666667, 
            0.0826666666666668}, {-0.4666666666666667, \
-0.1093333333333332}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.2974953333333334, 0.3275776666666667, 0.35059833333333335`], 
           ArrowBox[{{-0.33333333333333337`, 
            0.0826666666666668}, {-0.33333333333333337`, \
-0.1093333333333332}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{-0.19999999999999996`, 
            0.0826666666666668}, {-0.19999999999999996`, \
-0.1093333333333332}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{-0.06666666666666665, 
            0.0826666666666668}, {-0.06666666666666665, \
-0.1093333333333332}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.14178533333333332`, 0.148963, 0.15624366666666667`], 
           ArrowBox[{{0.06666666666666665, -0.1093333333333332}, {
            0.06666666666666665, 0.0826666666666668}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.22535599999999997`, 0.24688899999999997`, 0.26873099999999994`], 
           ArrowBox[{{0.19999999999999996`, -0.1093333333333332}, {
            0.19999999999999996`, 0.0826666666666668}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.29749533333333333`, 0.32757766666666666`, 0.35059833333333323`], 
           ArrowBox[{{0.33333333333333326`, -0.1093333333333332}, {
            0.33333333333333326`, 0.0826666666666668}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.3943533333333333, 0.4257073333333333, 0.4436739999999999], 
           ArrowBox[{{0.46666666666666656`, -0.1093333333333332}, {
            0.46666666666666656`, 0.0826666666666668}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.5159300000000001, 0.5412780000000001, 0.5479580000000001], 
           ArrowBox[{{0.6000000000000001, -0.1093333333333332}, {
            0.6000000000000001, 0.0826666666666668}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.6744060000000001, 0.6856220000000001, 0.674632], 
           ArrowBox[{{0.7333333333333334, -0.1093333333333332}, {
            0.7333333333333334, 0.0826666666666668}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[
           0.8083606666666667, 0.8121846666666668, 0.7859580000000002], 
           ArrowBox[{{0.8666666666666667, -0.1093333333333332}, {
            0.8666666666666667, 0.0826666666666668}}]}}, 
         {Arrowheads[{{0.03, 1.}}], 
          {RGBColor[0.917794, 0.920966, 0.881936], 
           ArrowBox[{{1., -0.1093333333333332}, {1., 
            0.0826666666666668}}]}}}}, {{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
           1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw12nk4lN/bAHDMhFSWsiuSpIRIRZJTtoiQKFul7IlQQqGkKCVk35WyhZSy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            "]]},
          Annotation[#, "Charting`Private`Tag$2034377#1"]& ]}, {}}},
      AspectRatio->1,
      DisplayFunction->Identity,
      Frame->True,
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{23., 1.5}, {16.999999999999943`, 0.5}},
      Method->{
       "VectorLengthFunction" -> 
        Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
          System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
          System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
          System`VectorPlotsDump`imin = If[
             NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
             Min[System`VectorPlotsDump`m], 
             Min[System`VectorPlotsDump`m]]; 
          System`VectorPlotsDump`imax = If[
             NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
             Max[System`VectorPlotsDump`m], 
             Max[System`VectorPlotsDump`m]]; Map[If[
             
             Or[# > System`VectorPlotsDump`imax, # < 
              System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& ,
             System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "TransparentPolygonMesh" -> True},
      PlotRange->{{-1.0416666666666667`, 
       1.0416666666666667`}, {-3.066666666666667, 0.26666666666666683`}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{Automatic, Automatic}], {123.27801686179758, -115.73138842694797},
      ImageScaled[{0.5, 0.5}], {227.44073986085334, 220.44073986085328}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwl1Pk/1HkcwHFC9WDaHCXn+I5vJZLSPmpT8n6X7XJm0eFoM8UoodSUKJWc
j5aGPGokIWVrbWKjVmo+5cgxjmUsyZF8v9NB7SZNDMruPvaH1+P5H7x4/PAf
AqepqKi4/tt/Zsfwp9vuPedg9d2TUsUillTLKJft1D7IHR7dLF3AkqmnkrMU
dRz0f7XpzTVnSfbjFDMNKhlUeVc0XExYcmCtMHTULBO6NI9tuzabJbKJ4IwP
Zrcgsc96zO0zQ2Z0D1i8NysHebx4zc0qhuQ15BwaMquH3PbwSp9dDCm6k9x9
wOY5NLPVWmWxA0QArZnvIhhYPjc1I7vsJQmTWzKlRW/B9Yzt9J/e9RNNXpzF
i1UfwGx39N1w3X6Sqi21yts9AlslEViV0kf43V5ErfEz/JG3Ji2tvYccqonj
h1uMA5n8/W4I3U1KDnI8DbZ8ASMx15t/vovkRYcMLtuugoxBa6hjVyeJzZn0
+PROFQ2fh2isww6iIuvHh1Fq+FC3IszpTjtZeCQo0stKA1uWbXd3mGwjrOLS
Nq1H09H9fHeRW1ArcZLvP5l+aCbGFOzUuuDXQtxY0WIuVxNXmgb65U5KyWAV
/3TdbS2sm7Ou8FVHHbHR6TB1/HEWruq890Y1tIZogiKgZ+QbjDP6Qm9bW0k2
vfcZNffWxh0eD7K+pj8izyr3qvpY6+BuZ5eVp6X3SFlS9S5KoYMGm041Ho4s
JkEawv7mZl2kSqSnzFfnkz0R0WWcy3r42D/kmEZJMlkqWNzsEjAH0bi+Sz0+
CVp0rbWEdnNRZLdD+yDJh4qi2CxrNX2MnBNz3H91MUSrWm1t7NXHg0evzNpp
eh80e6I2h5XOw+LxNz4L+h+BvICXkXPCAK84OHXAvErIWGSoXu5tiOorErTF
sTUguhxUG0AZofiXYZf7d+vAJ8O/mfPaCF1sP8kl7VIY+/6GMkdijNR7P9Gw
XQsw8vWRlYkmqJ0RdVW4vBWurbU1bgowRarx+JcZg21wO16oI1jCxeoqUe/J
uHZI9N7jrKbg4rjjyNBr/Q5Y0ZN3K7HJDCv7Zp4VSDtBbJl1u8mZQq7dyqwG
fhecepwidi6nULNI397RpBtcjb1vNMznYULheq3iph5YF1brq5PMw/TgBF8V
fh/kmPDnNyp4aJjrYPQtpx/mV/180c3XHMuGNtR2PusH0ZJKqzaJOWZORJw7
mvcSgkbUW+utaKwRK/Wo6AHgl3ykks/TWDGX479mIwMHYj0nndJodBzcv/Hp
FgaEnqWdnAs01krql3q4MpCkEKaKLtIoEyROE3gxUGSnnLiUTeNQ+bSb6XwG
lE+mOgoKaZy3S/nxbQwDojZOSnUtjYcLXiWJ7zNwOT80OKGeRmXUhgi6goH8
I82Om6U0nnS/7lskYeCevmhc2kxj8liATXUNAz0+esGyP2nMc+qV/S1jwIIx
dBxgaGz6S8bd9IGBZaVR3OtyGj2rls9sG2FgdXy3MvA1jV2X0ob9Rhlwscgu
fjtII4Pu1RFfGYgIobjDwzROpDfsu8ph4YT9GeVvIzSeEVh6WmqzED9roP2I
gsYZ9kn2pXosiO/knxsbo1FHvmF2gxEL106rCx6M05hZfn3Mi8tCoUfg+hOT
NJqmqg284LFQav7U1OErjfl8vnT/AhYkIwuVU1M0Wv7/L/gHZuJbrg==
           "]]},
         Annotation[#, "Charting`Private`Tag$2034413#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwt2Hk0Ff8bB3BLX0nk3jtzL9l10SalUCLziIpoQVoslZs1e2n5RpEW2dJO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           "]]},
         Annotation[#, "Charting`Private`Tag$2034413#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV1nk4VV0XAHDcmxIVkXBHXRGhQQMla1fIlMpQQgMNJCkKJRpoMKSQWcgQ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           "]]},
         Annotation[#, "Charting`Private`Tag$2034413#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{16.153061224489797`, 1.4999999999999432`}, {
       16.999999999999943`, 0.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {429.12271866566664, -115.73138842694797},
      ImageScaled[{0.5, 0.5}], {346.0180760214011, 220.44073986085328}]}, {}},
  
  ImageSize->Large,
  PlotRange->{{0, 611.6894036077381}, {-231.46277685389595`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.593825758477265*^9, 3.593825794092319*^9, 3.593826040553158*^9, {
   3.593826148050331*^9, 3.5938261991208353`*^9}, {3.59382648512784*^9, 
   3.593826501156796*^9}, 3.593826560605505*^9, {3.5938265907092133`*^9, 
   3.5938266017602177`*^9}, {3.5938266474033127`*^9, 3.593826672503848*^9}, {
   3.593826833778701*^9, 3.593826858538643*^9}, 3.5938269581893253`*^9, 
   3.59382699174867*^9, {3.593827028033374*^9, 3.5938270510252247`*^9}, 
   3.593827467666462*^9, 3.593831454250039*^9, {3.5938319864730263`*^9, 
   3.593832006624201*^9}, 3.593832044782633*^9, 3.593832086069331*^9, {
   3.593832294018614*^9, 3.5938323037467937`*^9}, 3.5938389322727957`*^9, 
   3.59383923543569*^9, 3.5938397773063307`*^9, 3.5938921492774487`*^9, 
   3.593913027161128*^9, 3.738608815761794*^9, {3.759084715109407*^9, 
   3.7590847295883417`*^9}, {3.759084793903391*^9, 3.759084815564307*^9}, 
   3.7933273630474253`*^9, 3.793327407892668*^9, 3.823230018667552*^9},
 CellLabel->
  "Out[3703]=",ExpressionUUID->"1b46f37b-11d9-4381-b00f-2525e5448708"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u1", "=", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"2", "u0"}], "tf1"], 
    RowBox[{"(", 
     RowBox[{"t", "-", 
      FractionBox["tf1", "2"]}], ")"}]}], "/.", 
   RowBox[{"u0", "\[Rule]", 
    RowBox[{"6", "/", "tf1"}]}]}]}]], "Input",
 CellChangeTimes->{{3.593891802779628*^9, 3.5938918699620867`*^9}, {
  3.593891944107671*^9, 3.5938919467384787`*^9}, {3.593892357514523*^9, 
  3.593892358214439*^9}},
 CellLabel->
  "In[3704]:=",ExpressionUUID->"ac5c4e97-1238-488e-8026-3a4494244f58"],

Cell[BoxData[
 FractionBox[
  RowBox[{"12", " ", 
   RowBox[{"(", 
    RowBox[{"t", "-", 
     FractionBox["tf1", "2"]}], ")"}]}], 
  SuperscriptBox["tf1", "2"]]], "Output",
 CellChangeTimes->{{3.5938918572096157`*^9, 3.59389187072974*^9}, 
   3.593891947529008*^9, 3.5938921493217154`*^9, 3.593892358782926*^9, 
   3.593913027259699*^9, 3.738608815910179*^9, {3.759084716487877*^9, 
   3.759084729741166*^9}, {3.75908479800104*^9, 3.7590848157343616`*^9}, 
   3.793327363075101*^9, 3.793327407915669*^9, 3.8232300187030888`*^9},
 CellLabel->
  "Out[3704]=",ExpressionUUID->"aa0dbca2-fa51-40c3-b8d7-765a12e51c09"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1out1", ",", "x2out1"}], "}"}], "=", 
   RowBox[{
    RowBox[{"OutputResponse", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sys", ",", 
        RowBox[{"Flatten", "[", "x0", "]"}]}], "}"}], ",", "u1", ",", "t"}], 
     "]"}], "//", "Simplify"}]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.593891955075531*^9, 3.593891990324415*^9}, 
   3.593892452106346*^9, {3.5938925713725967`*^9, 3.593892591620116*^9}, {
   3.5938931643455276`*^9, 3.593893196651297*^9}},
 CellLabel->
  "In[3705]:=",ExpressionUUID->"6b5025e7-2e40-43a0-963d-048f3970ed16"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"6", " ", 
      SuperscriptBox["t", "2"]}], "-", 
     RowBox[{"6", " ", "t", " ", "tf1"}], "+", 
     SuperscriptBox["tf1", "2"]}], 
    SuperscriptBox["tf1", "2"]], ",", 
   FractionBox[
    RowBox[{"t", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["t", "2"]}], "-", 
       RowBox[{"3", " ", "t", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "tf1"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "6"}], "+", "tf1"}], ")"}], " ", "tf1"}]}], ")"}]}], 
    SuperscriptBox["tf1", "2"]]}], "}"}]], "Output",
 CellChangeTimes->{{3.5938931811588163`*^9, 3.593893196962715*^9}, 
   3.593913027307921*^9, 3.7386088160642147`*^9, {3.759084716656658*^9, 
   3.759084729909032*^9}, {3.7590847981626587`*^9, 3.75908481581983*^9}, 
   3.793327363128941*^9, 3.793327407966065*^9, 3.8232300187349977`*^9},
 CellLabel->
  "Out[3705]=",ExpressionUUID->"4c836862-5ada-424c-8309-cf93044b1a46"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x1out1", ",", "x2out1"}], "}"}], "/.", 
    RowBox[{"tf1", "\[Rule]", "0.1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"tf1", "/.", 
      RowBox[{"tf1", "\[Rule]", "0.1"}]}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.593893174941431*^9, {3.593893285459112*^9, 3.593893345443152*^9}},
 CellLabel->
  "In[3706]:=",ExpressionUUID->"deb65661-f5a6-487c-845c-fd81a88566a4"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJxd1nk0VXsbB3BTKm6INJCOdFUWQiLue/Mzk7r10qUk1QlJSORW5qHBSQkN
lDpvhjImQumYHkOGSqQjwz2cjUimc3AcW4eT+7Pe9f7z7rX22vuz9l6/9Tz7
+f7W2ptP+Tl4iImIiNzG59L1v8ck+t+djqjGSs4kF2UNbr93JsMVdmbZn2f3
c1GNeWzP9jRfYPSnHWmo4yKV0Sa3nMdh0CRnklgUw0XeQwb7c+/GwYCTR/qC
LBc53265mhdFhw1X/CwPq3FQTI7gXp5rPsS4BMRsPTCOtJeZ6KUrVsLZCPJ0
zKXvaJd5OL0j7yNsfEtTNZQaQgqXwt29H34B22ra5UZmP/rcRB8fmWbBgpar
boZ4L5Kw+XUy37wf4CDDykW1E43NHWJWaQ8CYcP7YajYhqwmyhWY2sMQaCh9
b998AwpZN+bYyB+BvW0qj63tyxDvanuMzplxUDhj2Xbt5EPkku1q9ts3DrjO
2VapK2dC17ZR+1s3JiEuUTJadLIMjqfZUfbRpgAFaNhanKsHvsrKPDPaNAha
/Q0yTJohuOXobbYbD15mqEwRwW1w3e8NOfr7DKTWnqAw/dohMa2hoGhhBjzF
ecwdgx1AVsvJRTzmg5KzuqiscTeQktHHBLtmQeHJctbLtSyQnnAPKyqYBfpI
iE9qfQ+I34ivNaeQECOu0CmryAbXWw8H11wigfteqqxwkQ0O7hLCO69IKFlt
wc7PJsAzItxv7SAJ44dZWaG5BHxWPGGUgq3B/T3F+jkB90ddmjcOkdAjd+zH
hwICQi6nOm76RgJfVSrt8WsCUm3kJuS/k9B9QT3JsY6AmRo37doxEloGj6zb
2k2Ax6P0AaNpEoj9ygLnvwmwk7KRSsKeX5a17AaLgCoxxsIUtqu3UnJXLwEM
xrxZJo+EPjH/jD0D+Dm19A8RPgmp7r1UyigBL7L7PINJEox5RX+ZzRLw7nrd
/evzJJQevRzaiS2X7SFegb15r1HPGZKATmG8zSR2Y1lWZtgc7k808JDjAgkX
piw9/QQExMcYBa0WkhCSwDbow17jxUrZg+3/OsB1/zwBfTO8O2ewDZJjS9cu
ELCjIVSyHFvm+eXkC0ICuryfC+x/kpAU/U0bsBvKy1sDsZX6DqhI/sT1a+4I
ScKe1pFdfh2bsVXfsQPbWs1TFLA1ZGuuzGDffcT4k4d943M2bfUiCRNqByQP
LBIgeBqqaIstp5fgHogdtNqdTsVWaGhWTsJ+r/B4PghbfkBcqxg7+6iabiL2
smsG9z9gN9yb+S0Le/AF9TCB3XdebmMF9usTtAAOdj79ArMVOyQ559sc9vA7
ZeoAtp5TffFPbNunkvU87NZHrO5F7OssvUVxkTk4d2b8yAK2y6ZHsgrY3HJS
dwY7Qtl0VhX7QpKQOoydG7WpWBv7Mykc+4L9YFHf2hhbp2+uBbAXLcILLLAj
D3KknmEnCQWc/dg1Vuwn17A3sLIkHLGnapviqNjoZvSkC7Z8Y367EXZdBa2I
iq3pEBcoje286Y3daWx1d0/f7qXvf1yG4bVk4b8gHTtb64bQG3uZivRZT2ym
4db1vtj9de2+27B5ml9XLDl36sH7ATzP2rLK1qX33TIPRz7EXkgs9llaT35A
Ln4f9pGTtYQH9tOnb2fncD5utQ9vX6oHcQJK07AP0TfbLtX7qkq5zQrb08t3
z5/Y+mvBYgjnK2y4acVSv4QzX38tdkrJs81G2NusaS+zcB5XU9X8tLCPMxRp
u7D9gp/doWDTd6mamv4goObFKxcxbP9wHouC8z5rXMln4Hm9Gr5FjcD7obFB
XiUDe+H2Od9uPgElOulDsdhWyVLrw2ZwP3DqqBO2ffyzN9FTeD+JrP/cg/NI
UfHcFoP3m6VRBZmF855WsL48sIsAV3WD5bsFJKwrNCgfyCAgQNswcTeXhCjN
03M7luP5vr9Z9vMDCeku4rV6y9lQ5ibzb60EEjIZfNnikh6YYtoqhSMSmg0y
EymaLGAbNfc86JsFalxY6EnNbriX+27dbvdZ2CnqNzgq7IBd1SGOwyw+yD7x
dStMaAfzCGbVHxZ8sBo70UGktMH6gQNsH9oMpOlfvRgm/xGChlvipRp4kG8z
SzZBPcSYuZqf752GzpI+vZsJFXDQuEwpkzsFxQx6uk1YDjBGmI7avEno7G2r
T51MQgGEZQ9K5sI1YpVpptEb5OAQchesJ0B+y60S348N6KBeivO6B6PA8diy
9YPwE1pQibxc1TQMh/6TtHEgugOZMeWFpqJDQLGXM7Zv70EUrgMlsa0fxFy/
7tW91o+6JB829h3rhenqIukNrweRQCIg9JfvHRCpoWfs6fQd6XbXvbPc1ArF
W5RjZfrGUHjkpwSFump4+qqaozs5htis8yO3o6rBxGefnZPIOHK6avVFiKrB
zkbuW47qOGpRNm/2CQKoLDlcGEgdR/yzPsxfvSvB2bc3/sHXcaTJkqgd28sA
C8e3wRtGJ5B4ADuXOVMIwmCZihTBBEpz66p5ca4QTtbvmdkkzUFZ45Sp/k8F
MN24b6+uFgdtN62nOZbmQ8JV9esXz3GQV2fkk+GoHLjCarVL5HFQuOqpVaWr
0oCyz0dgJsFFGaWyYukLT8CLmEjlr+Eik9r5owG9dPjwV+pnD0Mu+nvVyePf
6Q+B71zX5BXERUPq4vc0lBLhNoemszOWi3pif/RHTcZBZZZ+nDCFi+Z/dPqP
5N2AVTQjbXoFFwVfzPvFTTUKFAvu+Pl/5CLblUnbR4uCoEHQlm3L5iLijmNH
xBZ/kPee7VLjctEKpUgTGXUq/P//zD//YSsJ
       "]]},
     Annotation[#, "Charting`Private`Tag$2034571#1"]& ]}, {}},
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Gill Sans", FontSize -> 24},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{{{-0.5, ""}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, ""}}, {{-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, ""}, {0.5, 
      FormBox["0.5`", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{
  3.59389315950406*^9, {3.593893286414301*^9, 3.59389334644552*^9}, 
   3.59391302735872*^9, 3.738608816401902*^9, {3.759084716836013*^9, 
   3.759084730003965*^9}, {3.759084798281209*^9, 3.759084815909107*^9}, 
   3.7933273631818113`*^9, 3.793327408026726*^9, 3.8232300187791023`*^9},
 CellLabel->
  "Out[3706]=",ExpressionUUID->"fa5bf64a-0cdf-406a-a69b-2044e1422aaf"]
}, Open  ]],

Cell["\<\
An input u[t] that goes back to itself must cross the x1=0 line, so that it \
can pick up the required drift \[OpenCurlyDoubleQuote]down\
\[CloseCurlyDoubleQuote].\
\>", "Text",
 CellChangeTimes->{{3.5938938060595827`*^9, 3.593893869520185*^9}, {
  3.793327393461277*^9, 3.793327393861947*^9}},
 FontSize->16,ExpressionUUID->"81c45cbc-bf19-448d-80a8-f3c3ca9a65da"]
}, Open  ]]
},
WindowSize->{755, 794},
WindowMargins->{{90, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"1534f61a-2ba0-4ff8-87b6-1e1755631bac"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 299, 7, 105, "Section",ExpressionUUID->"3ccdef91-63d4-48c6-8b44-ec3af715a9f8"],
Cell[881, 31, 230, 4, 52, "Text",ExpressionUUID->"182e11e8-6ca5-43fc-8103-4d98d02001fb"],
Cell[1114, 37, 525, 13, 52, "Input",ExpressionUUID->"5631db25-9a91-4837-8c1d-da1ebf4ad967"],
Cell[CellGroupData[{
Cell[1664, 54, 2493, 60, 173, "Input",ExpressionUUID->"705a497e-0f3f-4bbc-8c24-4609b31a5b19"],
Cell[4160, 116, 3847, 108, 65, "Output",ExpressionUUID->"bc9b982e-ac29-4c32-9b8d-c1b6325a269a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8044, 229, 1674, 45, 110, "Input",ExpressionUUID->"5f0908ff-6070-4a3f-807a-ba524aa5d9d0"],
Cell[9721, 276, 2972, 74, 49, "Output",ExpressionUUID->"c117af3b-79b8-4546-a04a-366a5c7b55dd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12730, 355, 679, 17, 30, "Input",ExpressionUUID->"b068eed6-efde-4b0f-8939-e84702e6f4a8"],
Cell[13412, 374, 1782, 35, 37, "Output",ExpressionUUID->"6fefecd8-ef44-4940-a1cb-a05518b356d7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15231, 414, 1970, 50, 94, "Input",ExpressionUUID->"8606eba1-c162-4d17-96d5-cb51364b8625"],
Cell[17204, 466, 89692, 1629, 240, "Output",ExpressionUUID->"1b46f37b-11d9-4381-b00f-2525e5448708"]
}, Open  ]],
Cell[CellGroupData[{
Cell[106933, 2100, 528, 15, 49, "Input",ExpressionUUID->"ac5c4e97-1238-488e-8026-3a4494244f58"],
Cell[107464, 2117, 613, 13, 60, "Output",ExpressionUUID->"aa0dbca2-fa51-40c3-b8d7-765a12e51c09"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108114, 2135, 636, 16, 52, "Input",ExpressionUUID->"6b5025e7-2e40-43a0-963d-048f3970ed16"],
Cell[108753, 2153, 1088, 30, 57, "Output",ExpressionUUID->"4c836862-5ada-424c-8309-cf93044b1a46"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109878, 2188, 511, 14, 30, "Input",ExpressionUUID->"deb65661-f5a6-487c-845c-fd81a88566a4"],
Cell[110392, 2204, 4582, 91, 377, "Output",ExpressionUUID->"fa5bf64a-0cdf-406a-a69b-2044e1422aaf"]
}, Open  ]],
Cell[114989, 2298, 374, 7, 60, "Text",ExpressionUUID->"81c45cbc-bf19-448d-80a8-f3c3ca9a65da"]
}, Open  ]]
}
]
*)

