(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     45253,        926]
NotebookOptionsPosition[     44423,        902]
NotebookOutlinePosition[     44821,        918]
CellTagsIndexPosition[     44778,        915]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Calculation of an example singular value plot (Ch. 3)", "Section",
 CellChangeTimes->{{3.504481706482094*^9, 3.504481736994545*^9}, {
  3.793324594510638*^9, 
  3.7933245964354563`*^9}},ExpressionUUID->"871e9615-13e8-4f0a-99b5-\
8dd536e2a753"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"G0", " ", "=", 
  RowBox[{
   RowBox[{"TransferFunctionModel", "[", " ", 
    RowBox[{
     RowBox[{"(", GridBox[{
        {
         FractionBox["1", 
          RowBox[{"1", "+", " ", "s"}]], 
         FractionBox["1", 
          RowBox[{"1", "+", " ", 
           RowBox[{"\[Tau]", " ", "s"}]}]]},
        {
         FractionBox["1", 
          RowBox[{"1", "+", "  ", 
           RowBox[{"\[Tau]", " ", "s"}]}]], 
         FractionBox["1", 
          RowBox[{"1", "+", "  ", "s"}]]}
       }], ")"}], ",", "s"}], "]"}], " ", "/.", " ", 
   RowBox[{"\[Tau]", " ", "\[Rule]", " ", 
    FractionBox["1", "2"]}]}]}]], "Input",
 CellChangeTimes->{{3.504480574583468*^9, 3.504480587733837*^9}, {
  3.504480638781898*^9, 3.5044806537290373`*^9}, {3.793324623346345*^9, 
  3.793324624248376*^9}},
 CellLabel->
  "In[2181]:=",ExpressionUUID->"919953c3-252c-45ba-b4ae-530b102f3cda"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox["1", 
     RowBox[{"1", "+", "s"}]], 
    FractionBox["1", 
     RowBox[{"1", "+", 
       FractionBox["s", "2"]}]], 
    FractionBox["1", 
     RowBox[{"1", "+", 
       FractionBox["s", "2"]}]], 
    FractionBox["1", 
     RowBox[{"1", "+", "s"}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, 
     InterpretationBox[#, 
      TransferFunctionModel[{{{1, 1}, {1, 
        1}}, {{1 + $CellContext`s, 1 + Rational[1, 2] $CellContext`s}, {
         1 + Rational[1, 2] $CellContext`s, 
          1 + $CellContext`s}}}, $CellContext`s], AutoDelete -> True, 
      Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 2, 2, 
     Control`CountStates[
      TransferFunctionModel[{{{1, 1}, {1, 
        1}}, {{1 + $CellContext`s, 1 + Rational[1, 2] $CellContext`s}, {
         1 + Rational[1, 2] $CellContext`s, 
          1 + $CellContext`s}}}, $CellContext`s]], 1, {}, {False, False}, 
     False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#, #2}, {#3, #4}}, AllowedDimensions -> {2, 2}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #5, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 2}, ","], "}"}], ",", 
        RowBox[{"{", 
          TemplateSlotSequence[{3, 4}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#5}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{1, 1}, {1, 
    1}}, {{1 + $CellContext`s, 1 + Rational[1, 2] $CellContext`s}, {
     1 + Rational[1, 2] $CellContext`s, 1 + $CellContext`s}}}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{
  3.504480657943823*^9, {3.793324608457665*^9, 3.79332463119914*^9}, 
   3.793324664509849*^9, 3.79384854222291*^9, 3.793850499039222*^9, 
   3.8232280473342333`*^9},
 CellLabel->
  "Out[2181]=",ExpressionUUID->"9815f4d8-d563-40b8-900f-0331b35648b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"svp", " ", "=", 
  RowBox[{"SingularValuePlot", "[", "G0", "]"}]}]], "Input",
 CellChangeTimes->{{3.504480664043014*^9, 3.504480670824644*^9}, {
  3.504483103276444*^9, 3.5044831063427353`*^9}},
 CellLabel->
  "In[2182]:=",ExpressionUUID->"d2379b9d-ba13-4963-a25a-fa832a8f1155"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Xc81d0fAHAR2avLV9ZjhcgKNxTnSBpSklIRKtkySsOKjIpSSGiJlLLi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       "]]},
     Annotation[#, "Charting`Private`Tag$811111#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd2nk4lF8fBnBrO23I2k/GTnbZfUnRai8pFLITSpasiUKyFkIhFYmSsi/P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       "]]},
     Annotation[#, "Charting`Private`Tag$811111#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-1.3010299956639813`, -32.054756916168024`},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
      Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
      Part[#, 2]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{{{-40., 
       FormBox[
        RowBox[{"-", "40"}], TraditionalForm]}, {-30., 
       FormBox[
        RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
       FormBox[
        RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
       FormBox[
        RowBox[{"-", "10"}], TraditionalForm]}, {0., 
       FormBox["0", TraditionalForm]}, {10., 
       FormBox["10", TraditionalForm]}, {-40., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-38., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-36., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-34., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-32., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-30., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-30., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-28., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-26., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-24., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-22., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-18., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-16., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-14., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-12., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-10., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-10., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-8., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-6., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, {{-40., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-30., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-20., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-10., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {10., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-40., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-38., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-36., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-34., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-32., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-30., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-30., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-28., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-26., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-24., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-22., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-18., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-16., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-14., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-12., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-10., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-10., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-8., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-6., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}, {{{-1., 
       FormBox["0.1`", TraditionalForm]}, {0., 
       FormBox["1", TraditionalForm]}, {1., 
       FormBox["10", TraditionalForm]}, {2., 
       FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5228787452803375, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.3979400086720376, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.3010299956639812, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2218487496163563, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.1549019599857432, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.09691001300805639, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.04575749056067506, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.3010299956639812, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.47712125471966244`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6020599913279624, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6989700043360189, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.7781512503836436, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.8450980400142568, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.9030899869919435, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.9542425094393249, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3010299956639813`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.4771212547196624`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6020599913279623`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6989700043360187`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.7781512503836436`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.845098040014257, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9030899869919435`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.954242509439325, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-1., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], 
        TraditionalForm]}, {-0.6989700043360187, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5228787452803375, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.3979400086720376, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.3010299956639812, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2218487496163563, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.1549019599857432, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.09691001300805639, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.04575749056067506, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.3010299956639812, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.47712125471966244`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6020599913279624, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6989700043360189, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.7781512503836436, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.8450980400142568, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.9030899869919435, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.9542425094393249, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3010299956639813`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.4771212547196624`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6020599913279623`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6989700043360187`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.7781512503836436`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.845098040014257, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9030899869919435`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.954242509439325, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{-1.3010299956639813`, 
   1.6020599913279623`}, {-32.054756916168024`, 6.013145583349457}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{{{-1., 
      FormBox["0.1`", TraditionalForm]}, {0., 
      FormBox["1", TraditionalForm]}, {1., 
      FormBox["10", TraditionalForm]}, {2., 
      FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.5228787452803375, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.3979400086720376, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.3010299956639812, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2218487496163563, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.1549019599857432, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.09691001300805639, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.04575749056067506, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.3010299956639812, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.47712125471966244`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6020599913279624, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6989700043360189, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.7781512503836436, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.8450980400142568, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.9030899869919435, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.9542425094393249, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.3010299956639813`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.4771212547196624`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.6020599913279623`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.6989700043360187`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.7781512503836436`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.845098040014257, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.9030899869919435`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.954242509439325, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}, {{-40., 
      FormBox[
       RowBox[{"-", "40"}], TraditionalForm]}, {-30., 
      FormBox[
       RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
      FormBox[
       RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
      FormBox[
       RowBox[{"-", "10"}], TraditionalForm]}, {0., 
      FormBox["0", TraditionalForm]}, {10., 
      FormBox["10", TraditionalForm]}, {-40., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-38., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-36., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-34., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-32., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-30., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-30., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-28., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-26., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-24., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-22., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-20., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-20., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-18., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-16., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-14., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-12., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-10., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-10., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-8., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-6., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-4., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-2., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {0., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {0., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {2., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {4., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {6., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {8., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {10., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}}}]], "Output",
 CellChangeTimes->{
  3.504480673270434*^9, 3.504483107825623*^9, {3.793324608684638*^9, 
   3.7933246314481792`*^9}, 3.793324664726884*^9, 3.7938485424672422`*^9, 
   3.793850499260889*^9, 3.823228047583005*^9},
 CellLabel->
  "Out[2182]=",ExpressionUUID->"ee33f779-b120-4f6c-8c16-e7b4a7e463ff"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 652},
WindowMargins->{{Automatic, 252}, {Automatic, 17}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"ccf05ab6-d2ed-4822-9381-dd6229ba3337"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 249, 4, 67, "Section",ExpressionUUID->"871e9615-13e8-4f0a-99b5-8dd536e2a753"],
Cell[CellGroupData[{
Cell[853, 30, 899, 25, 63, "Input",ExpressionUUID->"919953c3-252c-45ba-b4ae-530b102f3cda"],
Cell[1755, 57, 3309, 77, 109, "Output",ExpressionUUID->"9815f4d8-d563-40b8-900f-0331b35648b3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5101, 139, 302, 6, 30, "Input",ExpressionUUID->"d2379b9d-ba13-4963-a25a-fa832a8f1155"],
Cell[5406, 147, 38989, 751, 268, "Output",ExpressionUUID->"ee33f779-b120-4f6c-8c16-e7b4a7e463ff"]
}, Open  ]]
}, Open  ]]
}
]
*)

