(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    118098,       2709]
NotebookOptionsPosition[    113351,       2621]
NotebookOutlinePosition[    113749,       2637]
CellTagsIndexPosition[    113706,       2634]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["MIMO RHP zero  (Section 3.8.3)", "Section",
 CellChangeTimes->{{3.5048708903849983`*^9, 3.504870928209228*^9}, 
   3.5048759516443663`*^9, 3.504876253336381*^9, {3.7933241806197243`*^9, 
   3.79332418992705*^9}, {3.793848121807761*^9, 
   3.7938481328121853`*^9}},ExpressionUUID->"9d313e16-b8be-4e51-ab03-\
8409dc1e3adc"],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellLabel->
  "In[2160]:=",ExpressionUUID->"c5a094b2-44b4-45b5-99d2-a9669f7d71a7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"G0", " ", "=", " ", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", "s"}]}], ")"}], "2"]], " ", 
    RowBox[{"(", GridBox[{
       {"1", "1"},
       {
        RowBox[{"1", "+", 
         RowBox[{"2", "s"}]}], "2"}
      }], ")"}]}]}], ";", 
  RowBox[{
   RowBox[{"Det", "[", "G0", "]"}], " ", "//", " ", "Simplify"}]}]], "Input",
 CellChangeTimes->{
  3.5048709651807947`*^9, {3.504873713731339*^9, 3.504873745306738*^9}, {
   3.504875975719751*^9, 3.5048759888809433`*^9}, {3.504876067353894*^9, 
   3.504876072769017*^9}, {3.5048761139506073`*^9, 3.5048761163494787`*^9}, 
   3.504876164719285*^9, {3.5048762043277473`*^9, 3.5048762050512257`*^9}, 
   3.5048765599828157`*^9, {3.504876683275114*^9, 3.5048766853771772`*^9}, {
   3.5048767321552477`*^9, 3.504876748181554*^9}, {3.504915667961619*^9, 
   3.504915669173205*^9}, {3.757628884159307*^9, 3.757628895832761*^9}},
 CellLabel->
  "In[2161]:=",ExpressionUUID->"07afd9fe-f5ab-4147-bf9c-cb68ebef9592"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   RowBox[{"2", " ", "s"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "s"}]}], ")"}], "4"]]], "Output",
 CellChangeTimes->{
  3.5048737488201647`*^9, 3.504875993488222*^9, 3.504876073992217*^9, 
   3.504876117031272*^9, 3.5048761658666162`*^9, 3.504876215814041*^9, 
   3.504876345913002*^9, 3.5048765686223392`*^9, 3.5048766893109083`*^9, {
   3.504876737177863*^9, 3.504876751164641*^9}, 3.504877472677842*^9, 
   3.507141803613784*^9, {3.75762887615549*^9, 3.757628896691831*^9}, 
   3.7933242403672523`*^9, 3.79332440677468*^9, 3.7933244498479633`*^9, 
   3.793327141764323*^9, 3.7933271878092537`*^9, 3.7933272628029833`*^9, 
   3.79384814141187*^9, 3.82322803459443*^9},
 CellLabel->
  "Out[2161]=",ExpressionUUID->"7155f370-ab21-4f09-806c-e58796f373d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"G0a", " ", "=", " ", 
   RowBox[{"G0", " ", "/.", " ", 
    RowBox[{"s", "\[Rule]", " ", 
     FractionBox["1", "2"]}]}]}], ";", "  ", 
  RowBox[{"MatrixForm", "[", "G0a", "]"}]}]], "Input",
 CellChangeTimes->{{3.504874067729085*^9, 3.504874076748007*^9}, {
  3.757628905128693*^9, 3.75762892071632*^9}},
 CellLabel->
  "In[2162]:=",ExpressionUUID->"8d82452a-fd15-4239-8241-d7ffe27a97db"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["1", "4"], 
      FractionBox["1", "4"]},
     {
      FractionBox["1", "2"], 
      FractionBox["1", "2"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.50487407772955*^9, 3.504876006805154*^9, 3.5048760814561977`*^9, 
   3.504876125296454*^9, 3.504876178781369*^9, 3.5048762160178013`*^9, 
   3.504876346117609*^9, 3.5048765688240147`*^9, 3.504876689498087*^9, {
   3.504876737364533*^9, 3.504876751369154*^9}, 3.5048774727718267`*^9, 
   3.507141804572003*^9, 3.7576288763202953`*^9, {3.757628907042081*^9, 
   3.757628921153657*^9}, 3.7933242403763123`*^9, 3.7933244067823257`*^9, 
   3.79332444985583*^9, 3.793327141772579*^9, 3.793327187817029*^9, 
   3.793327262810247*^9, 3.7938481414203377`*^9, 3.8232280346029453`*^9},
 CellLabel->
  "Out[2162]//MatrixForm=",ExpressionUUID->"7bcab944-721d-4fbe-bea1-\
e4784563dde9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", "G0a", "]"}]}], ";", " ", 
  RowBox[{"{", " ", 
   RowBox[{
    RowBox[{"vals", "//", "MatrixForm"}], ",", 
    RowBox[{"vecs", "//", "MatrixForm"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5048774308400793`*^9, 3.504877433463269*^9}, {
  3.757628938471158*^9, 3.757628959723144*^9}},
 CellLabel->
  "In[2163]:=",ExpressionUUID->"c066c259-ea75-4f91-8d02-d17906fa9d07"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         FractionBox["3", "4"]},
        {"0"}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", "2"], "1"},
       {
        RowBox[{"-", "1"}], "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{3.504877435046133*^9, 3.504877472819882*^9, 
  3.507141804833522*^9, 3.7576288764035873`*^9, 3.757628960090014*^9, 
  3.793324240402034*^9, 3.793324406795085*^9, 3.793324449897173*^9, 
  3.793327141804818*^9, 3.793327187855747*^9, 3.793327262850368*^9, 
  3.793848141437213*^9, 3.8232280346267357`*^9},
 CellLabel->
  "Out[2163]=",ExpressionUUID->"f3ee38c6-6747-4db8-afd0-a30d9138e528"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", "\[CapitalSigma]", ",", "v"}], "}"}], " ", "=", " ", 
   RowBox[{"SingularValueDecomposition", "[", "G0a", "]"}]}], ";", "  ", 
  RowBox[{"MatrixForm", "/@", 
   RowBox[{"{", 
    RowBox[{"u", ",", "\[CapitalSigma]", ",", "v"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.50487408933361*^9, 3.50487414592402*^9}, {
  3.504874182480451*^9, 3.504874194485077*^9}, {3.504888855808073*^9, 
  3.504888884223256*^9}, {3.757628981078022*^9, 3.7576289938364363`*^9}, {
  3.75762906198143*^9, 3.75762908170004*^9}, {3.793327177368641*^9, 
  3.793327180818645*^9}},
 CellLabel->
  "In[2164]:=",ExpressionUUID->"65140064-dcb3-4c69-9229-08570c6fb419"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", 
         SqrtBox["5"]], 
        RowBox[{"-", 
         FractionBox["2", 
          SqrtBox["5"]]}]},
       {
        FractionBox["2", 
         SqrtBox["5"]], 
        FractionBox["1", 
         SqrtBox["5"]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         SqrtBox[
          FractionBox["5", "2"]], "2"], "0"},
       {"0", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", 
         SqrtBox["2"]], 
        RowBox[{"-", 
         FractionBox["1", 
          SqrtBox["2"]]}]},
       {
        FractionBox["1", 
         SqrtBox["2"]], 
        FractionBox["1", 
         SqrtBox["2"]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{{3.504888882686702*^9, 3.5048888846214314`*^9}, 
   3.5071418048743877`*^9, 3.757628876549156*^9, 3.757629082614746*^9, 
   3.7933242404102182`*^9, 3.793324406833831*^9, 3.793324449905164*^9, 
   3.7933271418132563`*^9, {3.793327181865326*^9, 3.793327187864214*^9}, 
   3.793327262858295*^9, 3.793848141455081*^9, 3.8232280346323633`*^9},
 CellLabel->
  "Out[2164]=",ExpressionUUID->"27195f1e-cec5-46f5-9097-1dd68a22d23e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixForm", "[", 
   RowBox[{
    RowBox[{"u", ".", "\[CapitalSigma]", ".", 
     RowBox[{"v", "\[Transpose]"}]}], "-", "G0a"}], "]"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"check", " ", "the", " ", "SVD"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.504902214276174*^9, 3.504902230152598*^9}, {
  3.504902349018664*^9, 3.504902408338153*^9}, {3.504915163381378*^9, 
  3.504915164470771*^9}, {3.7576290959094143`*^9, 3.757629111641561*^9}},
 CellLabel->
  "In[2165]:=",ExpressionUUID->"0892cb47-ff44-4985-beef-66c7e0dd7c1e"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0"},
     {"0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.504902230884534*^9, {3.5049023566496696`*^9, 3.504902377213779*^9}, 
   3.50490241404629*^9, 3.50491516505439*^9, 3.507141805002933*^9, 
   3.7576288767851553`*^9, {3.7576290978695917`*^9, 3.7576291127126617`*^9}, 
   3.793324240431817*^9, 3.793324406840541*^9, 3.7933244499421053`*^9, 
   3.793327141848078*^9, 3.7933271879013367`*^9, 3.7933272628898687`*^9, 
   3.7938481414623203`*^9, 3.823228034637623*^9},
 CellLabel->
  "Out[2165]//MatrixForm=",ExpressionUUID->"52fe2836-00d9-4810-89ee-\
60ff1dc88398"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"G0tf", " ", "=", " ", 
  RowBox[{"TransferFunctionModel", "[", 
   RowBox[{"G0", ",", "s"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5048743199247503`*^9, 3.504874342181374*^9}},
 CellLabel->
  "In[2166]:=",ExpressionUUID->"f8151ee8-1a0f-422c-a31b-0cf847f832c0"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
        RowBox[{"1", "+", 
          RowBox[{"2", " ", "s"}]}], ")"}], "2"]], 
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
        RowBox[{"1", "+", 
          RowBox[{"2", " ", "s"}]}], ")"}], "2"]], 
    FractionBox["1", 
     RowBox[{"1", "+", 
       RowBox[{"2", " ", "s"}]}]], 
    FractionBox["2", 
     SuperscriptBox[
      RowBox[{"(", 
        RowBox[{"1", "+", 
          RowBox[{"2", " ", "s"}]}], ")"}], "2"]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, 
     InterpretationBox[#, 
      TransferFunctionModel[{{{1, 1}, {1, 
        2}}, {{(1 + 2 $CellContext`s)^2, (1 + 2 $CellContext`s)^2}, {
         1 + 2 $CellContext`s, (1 + 2 $CellContext`s)^2}}}, $CellContext`s], 
      AutoDelete -> True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 2, 2, 
     Control`CountStates[
      TransferFunctionModel[{{{1, 1}, {1, 
        2}}, {{(1 + 2 $CellContext`s)^2, (1 + 2 $CellContext`s)^2}, {
         1 + 2 $CellContext`s, (1 + 2 $CellContext`s)^2}}}, $CellContext`s]], 
     1, {}, {False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#, #2}, {#3, #4}}, AllowedDimensions -> {2, 2}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #5, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 2}, ","], "}"}], ",", 
        RowBox[{"{", 
          TemplateSlotSequence[{3, 4}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#5}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{1, 1}, {1, 
    2}}, {{(1 + 2 $CellContext`s)^2, (1 + 2 $CellContext`s)^2}, {
     1 + 2 $CellContext`s, (1 + 2 $CellContext`s)^2}}}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{
  3.504874344116104*^9, 3.50487602731765*^9, 3.5048760889711123`*^9, 
   3.504876134354412*^9, {3.504876186481361*^9, 3.5048762161694393`*^9}, 
   3.504876346264881*^9, 3.504876568976471*^9, 3.504876689647195*^9, {
   3.504876737512535*^9, 3.504876751517808*^9}, 3.504877472960135*^9, 
   3.507141805059431*^9, 3.757628877204183*^9, 3.793324240529771*^9, 
   3.793324406914719*^9, 3.793324450017762*^9, 3.793327141922196*^9, 
   3.793327187978793*^9, 3.793327262940158*^9, 3.793848141524823*^9, 
   3.823228034695907*^9},
 CellLabel->
  "Out[2166]=",ExpressionUUID->"7c0d535b-a002-4d86-a416-4c72d870c18c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"tmax", " ", "=", " ", "10"}], ";"}]], "Input",
 CellChangeTimes->{{3.5048743977280617`*^9, 3.504874406553787*^9}},
 CellLabel->
  "In[2167]:=",ExpressionUUID->"6bcc479c-73d4-44ba-b133-38741ffc9d8b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y0a", " ", "=", " ", 
   RowBox[{
    RowBox[{"OutputResponse", "[", 
     RowBox[{"G0tf", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", "1", ")"}], 
         RowBox[{"UnitStep", "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", "0", ")"}], 
         RowBox[{"UnitStep", "[", "t", "]"}]}]}], "}"}], ",", "t"}], "]"}], 
    " ", "//", " ", "Simplify"}]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.504874383153081*^9, 3.504874413603945*^9}, {
  3.504876300376816*^9, 3.504876303091344*^9}, {3.5048764103425407`*^9, 
  3.50487641251553*^9}},
 CellLabel->
  "In[2168]:=",ExpressionUUID->"3a9b1f45-513d-4f28-858d-c53fe42089e7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {
          RowBox[{"1", "-", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "t"}], "/", "2"}]], " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "t"}], ")"}]}]}], 
          RowBox[{"t", "\[GreaterEqual]", "0"}]},
         {"0", 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "t"}], "/", "2"}]]}], ")"}], " ", 
    RowBox[{"UnitStep", "[", "t", "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.504876303975916*^9, 3.504876346366235*^9, 3.5048764130723877`*^9, 
   3.504876569090838*^9, 3.504876689797613*^9, {3.50487673772642*^9, 
   3.5048767516503277`*^9}, 3.5048774730761337`*^9, 3.507141809639185*^9, 
   3.757628877638823*^9, 3.793324240626156*^9, 3.793324406996122*^9, 
   3.793324450169339*^9, 3.7933271420077047`*^9, 3.793327188050403*^9, 
   3.7933272630545177`*^9, 3.793848141688315*^9, 3.8232280348276987`*^9},
 CellLabel->
  "Out[2168]=",ExpressionUUID->"5aff036a-55ed-41f9-b390-c2dbfb1bd41b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y0b", " ", "=", " ", 
   RowBox[{
    RowBox[{"OutputResponse", "[", 
     RowBox[{"G0tf", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", "0", ")"}], 
         RowBox[{"UnitStep", "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"UnitStep", "[", "t", "]"}]}]}], "}"}], ",", "t"}], "]"}], 
    " ", "//", " ", "Simplify"}]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.504874427177384*^9, 3.504874432810767*^9}, 
   3.504874538315927*^9, {3.5048763087273684`*^9, 3.504876311476035*^9}, {
   3.504876415310351*^9, 3.5048764169472303`*^9}},
 CellLabel->
  "In[2169]:=",ExpressionUUID->"4c1c3162-93ad-4112-aed7-9bbc8e6bb550"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "t"}], "/", "2"}]], " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "t"}], ")"}]}]}], 
          RowBox[{"t", "\[GreaterEqual]", "0"}]},
         {"0", 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "t"}], "/", "2"}]]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"t", "/", "2"}]]}], "-", "t"}], ")"}], " ", 
    RowBox[{"UnitStep", "[", "t", "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.504876311827516*^9, 3.5048763464206247`*^9, 3.504876417331707*^9, 
   3.5048765691585617`*^9, 3.50487668987401*^9, {3.50487673782979*^9, 
   3.504876751724339*^9}, 3.504877473152861*^9, 3.507141810467288*^9, 
   3.757628877738226*^9, 3.793324240667392*^9, 3.793324407040998*^9, 
   3.793324450210196*^9, 3.793327142050496*^9, 3.7933271880949697`*^9, 
   3.7933272630985117`*^9, 3.793848141747913*^9, 3.823228034882229*^9},
 CellLabel->
  "Out[2169]=",ExpressionUUID->"3a5914bc-e915-456f-a41b-dffbaad3ad1c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y0c", " ", "=", " ", 
   RowBox[{
    RowBox[{"OutputResponse", "[", 
     RowBox[{"G0tf", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", "1", ")"}], 
         RowBox[{"UnitStep", "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"UnitStep", "[", "t", "]"}]}]}], "}"}], ",", "t"}], "]"}], 
    " ", "//", " ", "Simplify"}]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.504874437977378*^9, 3.504874440434019*^9}, 
   3.504874522053625*^9, {3.5048763168769903`*^9, 3.504876320658414*^9}, {
   3.50487641922864*^9, 3.5048764208748817`*^9}},
 CellLabel->
  "In[2170]:=",ExpressionUUID->"d4fa5b47-72e5-4ad1-8d91-57bab1abde3f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "t"}], "/", "2"}]], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "t"}], ")"}]}]}], 
          RowBox[{"t", "\[GreaterEqual]", "0"}]},
         {"0", 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True]}], "}"}]], "Output",
 CellChangeTimes->{{3.504876321200964*^9, 3.5048763464890747`*^9}, 
   3.504876421222302*^9, 3.50487656923717*^9, 3.504876689943487*^9, {
   3.504876737969356*^9, 3.504876751794091*^9}, 3.504877473223442*^9, 
   3.5071418108538723`*^9, 3.7576288778372993`*^9, 3.793324240722148*^9, 
   3.793324407091312*^9, 3.793324450291403*^9, 3.7933271421035137`*^9, 
   3.79332718813653*^9, 3.793327263139822*^9, 3.793848141800054*^9, 
   3.823228034935926*^9},
 CellLabel->
  "Out[2170]=",ExpressionUUID->"f84f6696-78da-49fa-966c-8cb914c7f220"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pa", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"y0a", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "tmax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}]}], ";", 
  RowBox[{"pb", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"y0b", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "tmax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}]}], ";", 
  RowBox[{"pc", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"y0c", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "tmax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{"pa", ",", "pb", ",", "pc"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.50487446942564*^9, 3.504874499323175*^9}, {
  3.504874574181139*^9, 3.504874593988501*^9}, {3.793324418628173*^9, 
  3.793324443841509*^9}},
 CellLabel->
  "In[2171]:=",ExpressionUUID->"da28fe87-3377-4309-90c9-fda5d79c8997"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwd0Qk01dseB/C/Id0yvNBDMhyOKNPVcNVV/HYkQ3LLUF0iTsYGSUhIhjiU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           "]]},
         Annotation[#, "Charting`Private`Tag$805692#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVzns01AkUB/CRqDU4VCzJPPxsk0dSbdkK9yK0lBOaDZ2KicFGbTFb00iT
lccWTbuTPJKDqIRqd3rY2qkmjySzIa1daoVZGcxPaWJQ9rd/3HPv59x7zv2y
eftDYubQaLQtVP3fi1N5hiujT3pSI+kaLfKs72Bt3s6KB1r6fP94m3CYbZT/
wGIJgdZZqPG1jIfiBzlMA1Y2iBvf+HGNhZDgIUicYBYAVksE1ZNZ0DEdJx1j
XoHelNuXq9vyYV53H2eUWQcs0ZO+K+mXofRJyYFhZjNk8bQuuzW3ofZadneC
y9+waM0tLb+mCWKhrWDkYD9k0OImTjU8g30qh35Z7RCEaK6eKuZ0ghE7nfPP
V2MwyfowJyLpL8g1a3EsjRyHN/e7ls6avwRe97b7+k8/QK87ZxUzqBcONKTz
9nOmYO3FFqH/q9dw4zvjUKuvP8JY+JrnWSv6oVS0V+26nYZnV8/7QikcgLSS
meD3I3qYE2LpZSJRAa2jF+8d0cfHSYyH3Mx/YWky//A2RwOULPgQ3i4chAHt
uW/ovxviVvmNQAe/NxCg+vboTwfmY44V/9fFpkMQNCBxYjCMsO9OQv5t+RCo
H/HEj2voKH0XJpOGqsHF/IWtz24TFJYFV+xXqcEItFE946b4XIIDoZHD4D8a
MWHHNUM/vztTwq5h6FJE60U4m+O51IAGifcI3Myq38XSmqPEJtJWVzQCfANB
r1K5AMvyDHji8RHYc1B007hwIZqOvde6e4zCilgn5eaoRTj9o1GBInUU/ljg
TBess8Cpxk1VH+WjcLc2rchZ3xLdDKpcbbWjINJz3Pr0pSVu8dy93dRRA0Y9
Rzbtk32OehPhIc/CNKCqZEtLUqwwxCSUvk6sAeky67l1XGvs1NY9bK/UgKSQ
3xTFWoxYyV4d1qSBCOlOpfHgYhS9qOqAAQ1MbqzQlchtUOy2M7yARkK/yvuw
InMJ+tad3XHUioQyj5U2rVG2uCfYi3y1goSaEwLz2OUM3ChdvvCMDwmZ3D2B
+loG9np9+cqMS8KantIrma1MVGyYM7OWT0K+Q1FNayALJ23K6FXJJBx7kJMf
WMdCgzSAljQStthwK57Ys3GtRXOS72kSvPY17TDPZiP9gltqcwEJJUt49k+1
bMytVn9vcZEE+0eX8oJ22OG9bgcnRTUJkuUKx3a5HaI2t+KQjAT++Ny2ZkcC
hx4cOm94jwTejXes7NMEbo2/TsQoSEhIC50JOENgl5u1i5iyIFT2p/HPBB7P
KHcuopylFeRK8gisP7zSsI1y7Trd9LliAj/Tq3dyf0SC7uHsi8qr1H2Nn69Z
PfW/3TinvolAPU1057UGEgrLE+Mymgk8Y6JObKZcnqz02dRC5Zm/erqP8i1L
yVSLktoH2L+3aCShJ2JhXEcngbQMk0gRZU6/tU9fP4Fhq9B+YxMJrrIjjIsq
AgMZQfSdlNef6NbFDBKY1JI4KKC8mVN8fUhNoH++NvUS5YN7WYy3bwm8oKx2
MnpMQor7cd0v4wQWVijv2lE+YdL3PFlLID1mmdcGyvnXyk9OThLonZ3nlEC5
TDw39rcpAp/tkknSKV8NjvFOmSGQ/2nJ8HnKMrtGW89PBHrYdK6/SVk+vlQ3
O0tgCv/1sVbK/wGJIk8J
           "]]},
         Annotation[#, "Charting`Private`Tag$805692#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{14.999999999999998`, 6.5}, {7.500000000000028, 
       6.499999999999986}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 10}, {-2, 2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}], {107.22500293798116, -65.10150514031457},
      ImageScaled[{0.5, 0.5}], {199.48837755903472, 124.00286693393251}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwd0Ak01GsfB/C/Jd2yvKEXyTKMTNlu262u0vNEsiS3QnWJmKwtkpAkiZi0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           "]]},
         Annotation[#, "Charting`Private`Tag$805739#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVzXk81GsfxvGxdrI9oceWYfiJkhwth1K670ghSZaciCJri3AioQVlUlmz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           "]]},
         Annotation[#, "Charting`Private`Tag$805739#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{14.999999999999998`, 6.5}, {7.500000000000028, 
       6.499999999999986}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 10}, {-2, 2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}], {321.67500881394346, -65.10150514031457},
      ImageScaled[{0.5, 0.5}], {199.48837755903472, 124.00286693393251}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJxFz2lI0wEYBvDZtGLOcFqmqdt/Ji7nkX4IMvJIg8yLTJcw6djUzfJKcWBq
ZabpEG3V8GQMNQ0RZ8YM7FimpnktdGXRjMQ5RFPQ1tKptQryfV94ePh9e14m
P+tsyg4SiRT9N/9adoO/0z+5Ioj0/wY0RFQCcTl42+ZB1W2CuAaW9VYyrAgx
OD1QlLHGqANrNlOlK4w28C7tLGuZ0QNuHJFnf2MMgxWdYm2672ewMHiibilH
B87Ue+qUigUwhVnC+np0BVxlO8puvGQA87Xxr8hjP8HZb0r4WawNcNdVapzj
6V+4pyBt0S+BFLLtYvlW7I8lCzBJMxPyIp8M9sgV5MWzrcBzxppz1i93giP0
V67fz94NjpmTeNHpFPBiP7/obYc12Jc25Rp20QZMCTbypg17wKeWuWtuHFvw
p75kC643DdxdPnCBMKIFVqIZtdoOnJRT0E2ttwcfFnqpo3h7we/svK1FAfvA
zxXFDd5kB3CBBfvM2Bc0ZTo/PFO5H6xvZUrlhY5g6SEnyx6OE1hSLxjiEQfA
XOl5NXUevX6yxSRXOYN1+tC8vjIXcFOgv/M4zxXcUSqiCX3o4DJOUiTZiD4y
3dhWNs4A13o2dIxHEuCbvZW1kT3oaGdOy4g7E3wicyiRJkbLXfjuY0a0e/+j
6phEN/zPp489qUILDJYTw+yDYH7Xd0J8F51eHLcVcQ8tilN+pD5AlxtFVZJq
tCLAtFkjQ5tem6da29GSSWrlwBC6vjkj9c4wujlXHRY+in7qINkYVaOnufap
mg9ols4pbFaH9lPm0x/q0cdKtaaUeXQUS/Z4YRGdk0bQV1fRhcdvmZ4Y0KU2
s+9zjejazuaK9XV0U5Gl8NkGuj02JbRwC610G3QN+o1WGTxMZjP6DwbEFmI=

           "]]},
         Annotation[#, "Charting`Private`Tag$805786#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVlXk8lN8XxwcpW2UpSZZhEiFL3xIp57EkIckSiQiFZMk3UlK2QqmGhJQl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           "]]},
         Annotation[#, "Charting`Private`Tag$805786#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{14.999999999999998`, 6.5}, {7.500000000000028, 
       6.499999999999986}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 10}, {-2, 2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}], {536.1250146899058, -65.10150514031457},
      ImageScaled[{0.5, 0.5}], {199.48837755903472, 124.00286693393251}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[223]},
  PlotRange->{{0, 643.3500176278869}, {-130.20301028062914`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.5048745000704527`*^9, {3.504874531744934*^9, 3.504874546018401*^9}, 
   3.5048745957194347`*^9, 3.5048760381211348`*^9, 3.5048760977999773`*^9, 
   3.5048761435994062`*^9, {3.50487619492951*^9, 3.50487621639602*^9}, 
   3.504876346548049*^9, 3.5048765692808*^9, 3.504876689996195*^9, {
   3.504876738073277*^9, 3.504876751847928*^9}, 3.504877473275955*^9, 
   3.507141811712446*^9, 3.7576288780970793`*^9, 3.793324240807186*^9, 
   3.793324407179557*^9, {3.793324444962084*^9, 3.793324450522245*^9}, 
   3.793327142365315*^9, 3.793327188339099*^9, 3.793327263345018*^9, 
   3.793848141957103*^9, 3.823228035118744*^9},
 CellLabel->
  "Out[2172]=",ExpressionUUID->"5b14da7a-69a1-4bf7-9cbb-317c803e93f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y0gen", " ", "=", "  ", 
  RowBox[{
   RowBox[{"OutputResponse", "[", 
    RowBox[{"G0tf", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"UnitStep", "[", "t", "]"}]}], ",", 
       RowBox[{"b", " ", 
        RowBox[{"UnitStep", "[", "t", "]"}]}]}], "}"}], ",", "t"}], "]"}], 
   " ", "//", " ", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.504876377891913*^9, 3.504876406356401*^9}, {
  3.504876481147996*^9, 3.504876503001731*^9}, {3.504911170192622*^9, 
  3.5049111968058662`*^9}},
 CellLabel->
  "In[2173]:=",ExpressionUUID->"bad36633-f7b5-43c6-a3eb-4a261d2ee99b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"2", "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "t"}], "/", "2"}]], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "t"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"UnitStep", "[", "t", "]"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"2", " ", "b"}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "t"}], "/", "2"}]], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "t"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"UnitStep", "[", "t", "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5048763962498007`*^9, 3.504876406825809*^9}, {
   3.504876482782302*^9, 3.504876503509162*^9}, 3.504876569923171*^9, 
   3.504876691236936*^9, {3.504876740089258*^9, 3.504876753127984*^9}, 
   3.5048774745603*^9, {3.5049111717323647`*^9, 3.50491119731354*^9}, 
   3.507141816409348*^9, 3.757628878945722*^9, 3.793324241270424*^9, 
   3.793324407636639*^9, 3.793324450982583*^9, 3.793327142837655*^9, 
   3.7933271888247013`*^9, 3.793327263818174*^9, 3.79384814243506*^9, 
   3.8232280356242456`*^9},
 CellLabel->
  "Out[2173]=",ExpressionUUID->"cc7fc08b-0a66-4aab-b8da-02599ba3b60e"]
}, Open  ]],

Cell["Show that we can find the zero numerically, too :", "Text",
 CellChangeTimes->{{3.504907508325872*^9, 3.5049075202160473`*^9}},
 FontSize->14,ExpressionUUID->"229938a1-5386-4972-8814-3261fada5ef6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sigmas", " ", "=", " ", 
   RowBox[{"SingularValueList", "[", "G0", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.504907046388461*^9, 3.5049070724643707`*^9}},
 CellLabel->
  "In[2174]:=",ExpressionUUID->"fdd5b960-d8b5-4e21-85e6-1d3a0b21c2ec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", " ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"sigmas", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.504907076770961*^9, 3.504907089461417*^9}, 
   3.504907161914578*^9, {3.504907289876429*^9, 3.504907323466194*^9}, {
   3.504907467274886*^9, 3.504907485342866*^9}},
 CellLabel->
  "In[2175]:=",ExpressionUUID->"42a11bed-4469-45dd-a186-3cfd4c1f50b4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"s", "\[Rule]", "0.4999999572236653`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5049070914635267`*^9, 3.50490716322655*^9, {3.504907305658983*^9, 
   3.504907324792822*^9}, {3.504907468945952*^9, 3.504907487495512*^9}, 
   3.5071418169472218`*^9, 3.7576288792176027`*^9, 3.79332424129572*^9, 
   3.7933244077894*^9, 3.7933244510950727`*^9, 3.7933271429826317`*^9, 
   3.7933271889584303`*^9, 3.793327263957902*^9, 3.793848142523849*^9, 
   3.823228035731206*^9},
 CellLabel->
  "Out[2175]=",ExpressionUUID->"8761dc59-2026-46b5-b1d6-04b748929e15"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", " ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"sigmas", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.504907494939865*^9},
 CellLabel->
  "In[2176]:=",ExpressionUUID->"4931a1df-bf8f-48c9-9004-acc98e59a458"],

Cell[BoxData[
 TemplateBox[{
  "FindRoot", "cvmit", 
   "\"Failed to converge to the requested accuracy or precision within \\!\\(\
\\*RowBox[{\\\"100\\\"}]\\) iterations.\"", 2, 2176, 164, 
   24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.504907495619417*^9, 3.507141817050227*^9, 
  3.757628879326273*^9, 3.793324241302979*^9, 3.793324407835487*^9, 
  3.793324451137248*^9, 3.793327143023202*^9, 3.793327188999091*^9, 
  3.79332726400212*^9, 3.793848142535281*^9, 3.8232280357402973`*^9},
 CellLabel->
  "During evaluation of \
In[2176]:=",ExpressionUUID->"fbd155ff-cb2f-4bf0-8638-c7642c3e7ca6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"s", "\[Rule]", "2.7168007140511482`*^29"}], "}"}]], "Output",
 CellChangeTimes->{3.504907495621088*^9, 3.5071418170561323`*^9, 
  3.757628879406714*^9, 3.7933242413089046`*^9, 3.7933244078415318`*^9, 
  3.7933244511437283`*^9, 3.7933271430301037`*^9, 3.793327189006721*^9, 
  3.793327264008911*^9, 3.793848142544379*^9, 3.823228035746551*^9},
 CellLabel->
  "Out[2176]=",ExpressionUUID->"42f2e589-29e6-4dcc-a431-7e044668919d"]
}, Open  ]],

Cell["\<\
above shows that only 1 singular value has a root (zero).  
Below, a graph of \[Sigma](s) also shows the root at s=0.5;
note that this kind of graph would not find a complex zero.\
\>", "Text",
 CellChangeTimes->{{3.504907539240362*^9, 3.504907558808572*^9}, {
   3.50491050617908*^9, 3.5049105661272717`*^9}, {3.507142307247759*^9, 
   3.5071423086446667`*^9}, 3.793327235681465*^9},
 FontSize->14,ExpressionUUID->"063d94e7-a922-40e9-98ed-ada313ea4fa9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"G1", " ", "=", " ", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", "s"}]}], ")"}], "^", "2"}]], 
    RowBox[{"(", GridBox[{
       {"1", "1", "1"},
       {
        RowBox[{"1", "+", 
         RowBox[{"2", "s"}]}], "2", "1"}
      }], ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5049152666456614`*^9, 3.5049152821485367`*^9}, {
  3.504915646354929*^9, 3.504915675691876*^9}},
 CellLabel->
  "In[2177]:=",ExpressionUUID->"b92b3c7a-2a76-4838-b9f2-d59f6bf1ceaa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sigmas1", " ", "=", " ", 
   RowBox[{"SingularValueList", "[", "G1", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.504915304490025*^9, 3.504915310767823*^9}},
 CellLabel->
  "In[2178]:=",ExpressionUUID->"57ebf0be-63ca-49d2-b6ba-140a2cb3ed37"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LogLogPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"sigmas", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"sigmas", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0.01", ",", "100"}], "}"}]}], "]"}], ",", 
   RowBox[{"LogLogPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"sigmas1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"sigmas1", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0.1", ",", "100"}], "}"}]}], "]"}]}], "}"}]], "Input",\

 CellChangeTimes->{{3.50491532774996*^9, 3.5049153501426497`*^9}, {
  3.504915420674348*^9, 3.504915463151535*^9}, {3.504917304865302*^9, 
  3.504917317164073*^9}},
 CellLabel->
  "In[2179]:=",ExpressionUUID->"46bbe50f-8ff8-41e7-9649-103cc75e724b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwlmXk0Ve/3x83jvde91yVDmYc+KVOiks4NSYkyRmlSJAnNqCTKx1AaTFH5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         "]]},
       Annotation[#, "Charting`Private`Tag$808667#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwlVXk01HsfnsFgZsz2M3O7KNLIbUP1Ci36/t6sEUIytJElivQ6bSOihShL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         "]]},
       Annotation[#, "Charting`Private`Tag$808667#2"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{-4.605170185988091, -11.960230458027617`},
    CoordinatesToolOptions:>{"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
       Charting`ScaledFrameTicks[{Log, Exp}]}, {Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
       Charting`ScaledFrameTicks[{Log, Exp}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None},
    
    PlotRange->NCache[{{-4.605170185988091, 
        Log[100]}, {-11.960230458027617`, 
       0.9262450403237162}}, {{-4.605170185988091, 
      4.605170185988092}, {-11.960230458027617`, 0.9262450403237162}}],
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->FrontEndValueCache[{Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 
         6}]]& }, {{{-4.605170185988091, 
         FormBox[
          TagBox[
           InterpretationBox[
            StyleBox["\"0.01\"", ShowStringCharacters -> False], 0.01, 
            AutoDelete -> True], NumberForm[#, {
             DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
         0.}}, {-2.3025850929940455`, 
         FormBox[
          TagBox[
           InterpretationBox[
            StyleBox["\"0.10\"", ShowStringCharacters -> False], 0.1, 
            AutoDelete -> True], NumberForm[#, {
             DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}}, {
        0., 
         FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
         FormBox["10", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
         FormBox["100", TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-6.214608098422191, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.809142990314028, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.521460917862246, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.298317366548036, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.115995809754082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.961845129926823, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.8283137373023015`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.710530701645918, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.912023005428146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.506557897319982, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.2188758248682006`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.8134107167600364`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.659260036932778, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.5257286443082556`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.4079456086518722`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.2039728043259361`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.916290731874155, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.5108256237659907, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.35667494393873245`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.2231435513142097, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.10536051565782628`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.0986122886681098`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.3862943611198906`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.791759469228055, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.9459101490553132`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.0794415416798357`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.1972245773362196`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.4011973816621555`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.6888794541139363`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.912023005428146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.0943445622221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.248495242049359, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.382026634673881, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.499809670330265, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.298317366548036, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.703782474656201, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.991464547107982, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.214608098422191, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.396929655216146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.551080335043404, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.684611727667927, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.802394763324311, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.907755278982137, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}}, {{-11.512925464970229`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
         FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
         FormBox[
          TagBox[
           InterpretationBox[
            StyleBox["\"0.010\"", ShowStringCharacters -> False], 0.01, 
            AutoDelete -> True], NumberForm[#, {
             DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
         0.}}, {-2.3025850929940455`, 
         FormBox[
          TagBox[
           InterpretationBox[
            StyleBox["\"0.100\"", ShowStringCharacters -> False], 0.1, 
            AutoDelete -> True], NumberForm[#, {
             DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {
        0., 
         FormBox["1", TraditionalForm], {0.01, 0.}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.517193191416238, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.111728083308073, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.824046010856292, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.600902459542082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.418580902748128, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.264430222920869, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.1308988302963465`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.013115794639964, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-6.214608098422191, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.809142990314028, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.521460917862246, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.298317366548036, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.115995809754082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.961845129926823, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.8283137373023015`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.710530701645918, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.912023005428146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.506557897319982, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.2188758248682006`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.8134107167600364`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.659260036932778, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.5257286443082556`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.4079456086518722`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.2039728043259361`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.916290731874155, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.5108256237659907, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.35667494393873245`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.2231435513142097, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.10536051565782628`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.0986122886681098`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.3862943611198906`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.791759469228055, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.9459101490553132`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.0794415416798357`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.1972245773362196`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.302585092994046, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.4011973816621555`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.6888794541139363`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.912023005428146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.0943445622221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.248495242049359, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}}}]], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwVjHs0lGkcgOciY8hlvonKpTDfEiu3lHaT7z2toe2EHZciJTJSYZHVyuVU
SiZdRnG0U+pEtLZGZqZcZtb2/rJNm0Sy0RKTTWZN7SmaRI2cbf94zvPPcx6n
HRkRyQwajRb6mf+9O7+jXp7KAM6ItYBRqMf2NUHjW1IYIF9cv/LOQT3uvodd
jZIYMGanbSo5ose+Ns1XNm1hAP+o0XHuCT2eldXUGtYzYJeMWx54Xo9PafMv
8V0YcOENZD9X6rFC4PnTwAgdNkcXewtnPveu5SX0TXTIL8/xFua9w+faHg9M
LaPB8udrFXBtCg9g9xrV0jlcfGov+ln7Hu/bXqcsmzHgtEKGJtp/Brs9tGxt
rPmAU9sq12S3f8D8rbm0ph+mcXfpkwz7jQb8o7LHi7loCpc9F2UrzD7h6gxn
Uczdtzg5kZm1+OEcXvHNXveKqgm8p2T7H/5f06ClKynFR/Qvrlppwry1iA4D
4c/MWa7j2LCBtSNMQ4eXh0ONXz0dxYey+5t3VjBAIFslub1Tg5suzibFhzEh
vft+aHBTHxYW7IoUTzGhIzYgYPj0PazU8zVHrxnB4/0tZ6r49TjnjHZbaso8
CEh6xldub6YcuIayoS+MwQAWKwa0XdT8TxoTUzMWnNh7USlofEJxo1C49UcW
LHU2XGSXj1D72x06Le3YwI71s9y6eowabBe3mW4yBV501qu/T+ooxzviuoNn
zcBK3v2hD72mhtJrP/ZbmYONbqFqTjBJxQthKLnUAhocw8OO5+qpOW2wyJZt
BctFlYburilqrUURt2zcCvi9z+I9DNNUQX70wYB2DgRv/Oop2vyRSh+lxK+a
CQhPl3iG1c9ScV/6Hhu9zoWJTIN/zqM5atCLWO9btQACe1c1/FJBQ+y/XIoD
L1vDd8OZkjopHcUnRE1nXrAB7RrPSQfMQK2todKCyoWQpcjumxxnoojIYp2w
fhGst1VV9M4ZoaJGetTE1cXAPScasfAwRrrMPLHxXVtwN4thxfBZ6EXeuzVX
euxA/fCqxCHWBIlP9/dqn9hDtLS4NfAIG3FVpbFo2gF88hIVaedNkWvafbt/
jJYCI0G9+n2HGTqB4iMpa0fYLJG6z76dj2hDn2QzdY4w83vFtIWJBUp+XfQu
c7kTnDSeJyj0s0Tr7Iz2qcEJ/B1+XVfgYoVkN2uDGzY4gy6hiZhptELDbNUD
t15nqJTp6534HNSs1qVkJfNAl6uQCno4qOlPc7bdGx5ckd7zwL0cpLvh5V00
yQPhiEbq0cdB5hWecTo9DzQhZg2sQQ7qGVO2tczw4LGNsOG3UQ6KY6sbohgk
3Lppfd1t+vNvbS1fbE1CxURuI30JgagHJQGsABIiSLFXhiOB3M/2Dn4fSIJl
TF3jkDOBRNXygn5EQil+1NjiSqD3El5nHZ+EA6fcZek+BCpMPHcmKJyEPR5D
soEgAnGrJzqKdpCwLOGtd0gIgVwu5F96KSRhrNxEfvNbAmXn5OZFpJCQYPCT
i8MIVL8Nr3ZOIyH6/kk5P4ZASw6FaG7nkEDMXfa5sYVA0mGXHrdcEnp8VHLH
bQSqzkhRn84jYYNEKzckEqjzBVOVeIAEk65Zn91CAtGvxik7DpGgpnEV/TsJ
FJk2v83nCAlFfm6+QbsJZGu/oF1ylAS0i1LIUwlESDM76cdI+A9DX1af
         "]]},
       Annotation[#, "Charting`Private`Tag$808725#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAAaXvJqLFrAsAppesQr/DnPxyiROha
ZwLA3cxltmDr5z/OyL8nBGMCwE+W7wQQ5uc/Mha2plZaAsDLshSaZ9vnP/yw
oqT7SALADH/WjvrF5z+O5nugRSYCwDaDtvOumuc/slEumNngAcD8fVs2TELn
P/wnk4cBVgHAY6o8/iyK5j+avNTZ9SgAwG8Y08uq1+Q/2b8qorof/r/Ea96y
jRPjP3ZfpbmQ+Pu/RLsUVdYp4T8pzw+4r6L5vwiBIKkjv90/RVx4ALV097/m
huQnqwzZP3e50C8DGPW/DAWH9G170z+hbyKIWMbyvyort/k3DMs/M0NyKpSc
8L9GToN/7xi+P7fNY2cxiOy/8v4pFCRogT/ZT98NByfov2QyhCqEnLm/6oNN
Buvb478u6KnFeS/Lv1GwNpnBZt6/sKTcCEbI1b9tzspNRrXVvwhgLvW8vt2/
yVk8PN2RyL/Nn9wTk1Xjv9R5t5KcRai/i9gdL1zU5788Y99FuV+2PzRB4QUY
GOy/+8AOM9nmzT8c+Hv5CGLwv4xynrlRr9c/je3L5EyS8r8fIvueCZPgP6Xx
kJiE8PS/CVk0D1w45T/f7oioiUD3vyNVcevhjek/7p0Pk9lk+b8Qsc751UDu
P3HY1Kqasvu/FukXuv5R8T9EfxkFEdX9v60gT06LePM/r4auEIbp/78tiJb7
zs31PzoQNVc2FAHARdLfXiz79z9DXFDyoR8CwEZMOdtAV/o/flAq2gpBA8BP
bZkuTqj8PycSIA0mXQTA8HD7N3XR/j9TZqFFaWYFwD7SNq2plABAbk4WBJqG
BsBQ3XCZpawBQBrujgpDlAfA5jsu8R2/AkDfFl4mS50IwHGyc9Xx6ANAcLEX
pLC9CcBIGrqU0v4EQAYxWSWKywrAE5qI4A4sBkBmVxTG5fALwCoLWAdYRQdA
b+3bJpIDDcDFz6qZHVkIQCxIa0WEEQ7AVayFuD6ECUCYQ5mKAjcPwDF6YbJs
mwpAC5TZc8IkEMACYMU49skLQFnE3i/KuRDAV5msKvzyDECKJgbaXkwRwPjD
lPcOCA5AsyhY1VHVEcCNBgVRfTQPQJSfvpAFahLANx27QnwmEEBRZTj8BfUS
wOlgtRL4rxBAy92a6W99E8CWsPOoIUURQBJlRxuVERTA6XiyrFHQEUCa0nii
8JsUwKasyCy/0hFAnQwZq1qeFMBk4N6sLNURQNPlvLXEoBTA3kcLrQfaEUB6
/wrRmKUUwNQWZK294xFAKbKhH0GvFMC+tBWuKfcRQMj0wRuSwhTAlPB4rwEe
EkBneDGINekUwFIkjy9vIBJAfpUmz5/rFMAPWKWv3CISQGao/BcK7hTAir/R
r7cnEkBufkev3vIUwH+OKrBtMRJA/6869If8FMBqLNyw2UQSQD0Hr9baDxXA
KGDyMEdHEkD40TY7RRIVwOWTCLG0SRJARAqPoa8UFcBg+zSxj04SQLazrHOE
GRXAVcqNsUVYEkDGl4AtLiMVwBL+ozGzWhJAPXlvoJglFcDQMbqxIF0SQOq1
JhUDKBXASpnmsfthEkBuQeoD2CwVwAjN/DFpZBJA1ZH0fUIvFcDFABOy1mYS
QIhAw/msMRXAgjQpMkRpEkCUT1V3FzQVwEBoP7KxaxJAhsGp9oE2FcBmtlS3

         "]]},
       Annotation[#, "Charting`Private`Tag$808725#2"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{-2.3025850929940455`, -10.26759181738274},
    CoordinatesToolOptions:>{"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
       Charting`ScaledFrameTicks[{Log, Exp}]}, {Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
       Charting`ScaledFrameTicks[{Log, Exp}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None},
    
    PlotRange->NCache[{{-2.3025850929940455`, 
        Log[100]}, {-10.26759181738274, 
       0.7481303530195521}}, {{-2.3025850929940455`, 
      4.605170185988092}, {-10.26759181738274, 0.7481303530195521}}],
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->FrontEndValueCache[{Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 
         6}]]& }, {{{-2.3025850929940455`, 
         FormBox[
          TagBox[
           InterpretationBox[
            StyleBox["\"0.1\"", ShowStringCharacters -> False], 0.1, 
            AutoDelete -> True], NumberForm[#, {
             DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 
         0.}}, {-0.6931471805599453, 
         FormBox[
          TagBox[
           InterpretationBox[
            StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, 
            AutoDelete -> True], NumberForm[#, {
             DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}}, {
        0., 
         FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
         FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
         FormBox["10", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
         FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
         FormBox["100", TraditionalForm], {0.01, 0.}}, {-2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.8134107167600364`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.659260036932778, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.5257286443082556`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.4079456086518722`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.2039728043259361`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.916290731874155, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.5108256237659907, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.35667494393873245`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.2231435513142097, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.10536051565782628`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.0986122886681098`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.3862943611198906`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.791759469228055, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.9459101490553132`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.0794415416798357`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.1972245773362196`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.4011973816621555`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.6888794541139363`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.0943445622221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.248495242049359, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.382026634673881, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.499809670330265, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.298317366548036, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.703782474656201, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.991464547107982, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.214608098422191, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.396929655216146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.551080335043404, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}}, {{-9.210340371976182, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
         FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
         FormBox[
          TagBox[
           InterpretationBox[
            StyleBox["\"0.010\"", ShowStringCharacters -> False], 0.01, 
            AutoDelete -> True], NumberForm[#, {
             DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
         0.}}, {-2.3025850929940455`, 
         FormBox[
          TagBox[
           InterpretationBox[
            StyleBox["\"0.100\"", ShowStringCharacters -> False], 0.1, 
            AutoDelete -> True], NumberForm[#, {
             DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {
        0., 
         FormBox["1", TraditionalForm], {0.01, 0.}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.517193191416238, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.111728083308073, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.824046010856292, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.600902459542082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.418580902748128, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.264430222920869, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.1308988302963465`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.013115794639964, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-6.214608098422191, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.809142990314028, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.521460917862246, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.298317366548036, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.115995809754082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.961845129926823, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.8283137373023015`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.710530701645918, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.912023005428146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.506557897319982, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.2188758248682006`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.8134107167600364`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.659260036932778, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.5257286443082556`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.4079456086518722`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.2039728043259361`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.916290731874155, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.5108256237659907, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.35667494393873245`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.2231435513142097, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.10536051565782628`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.0986122886681098`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.3862943611198906`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.791759469228055, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.9459101490553132`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.0794415416798357`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.1972245773362196`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.302585092994046, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.4011973816621555`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.6888794541139363`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.912023005428146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}}}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.504915330112327*^9, 3.5049153508550367`*^9}, {
   3.504915422015472*^9, 3.5049154639148407`*^9}, {3.504915651381145*^9, 
   3.5049156797058573`*^9}, 3.504917319604822*^9, 3.507141819069668*^9, 
   3.757628880230076*^9, 3.793324241797089*^9, 3.7933244083167467`*^9, 
   3.793324451546126*^9, 3.7933271434793987`*^9, 3.793327189419642*^9, 
   3.7933272644575777`*^9, 3.793848142973118*^9, 3.823228036229621*^9},
 CellLabel->
  "Out[2179]=",ExpressionUUID->"20aeb136-6701-4457-a12d-3763427c7ee2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["equivalent state space form",
 FontSize->24]], "Section",
 CellChangeTimes->{{3.507141770195982*^9, 3.5071417786504507`*^9}, {
  3.7933242065993147`*^9, 
  3.793324210423092*^9}},ExpressionUUID->"e4aa0c27-fa9a-432b-9fc2-\
f2a135377cdc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sys0", " ", "=", " ", 
  RowBox[{"StateSpaceModel", "[", "G0tf", "]"}]}]], "Input",
 CellChangeTimes->{{3.507141784907721*^9, 3.507141787977633*^9}, {
  3.507141852756093*^9, 3.507141852984947*^9}},
 CellLabel->
  "In[2180]:=",ExpressionUUID->"bc32a308-1f21-4cf3-ad58-4b0ddca6ac36"],

Cell[BoxData[
 TemplateBox[{"0", "1", "0", "0", "0", "0", 
   RowBox[{"-", 
     FractionBox["1", "4"]}], 
   RowBox[{"-", "1"}], "0", "0", "1", "0", "0", "0", "0", "1", "0", "0", "0", 
   "0", 
   RowBox[{"-", 
     FractionBox["1", "4"]}], 
   RowBox[{"-", "1"}], "0", "1", 
   FractionBox["1", "4"], "0", 
   FractionBox["1", "4"], "0", "0", "0", 
   FractionBox["1", "4"], 
   FractionBox["1", "2"], 
   FractionBox["1", "2"], "0", "0", "0", 
   InterpretationBox["\[InvisibleSpace]", None], {
   StateSpaceModel, {
    False, False, {
     False, False}}, {$CellContext`stname1, $CellContext`stname2, \
$CellContext`stname3, $CellContext`stname4}, {{
     Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$, 
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, Identity, 
    Automatic, 2, 2, 4, 1, {}, {False, False}, False, Automatic, None, 
    Automatic}, {}},
  "StateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{#, #2, #3, #4, #5, #6}, {#7, #8, #9, #10, #11, #12}, {#13, \
#14, #15, #16, #17, #18}, {#19, #20, #21, #22, #23, #24}, {#25, #26, #27, \
#28, #29, #30}, {#31, #32, #33, #34, #35, #36}}, AllowedDimensions -> {6, 6}, 
        GridBoxDividers -> {"Rows" -> {False, False, False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}, 
          "Columns" -> {False, False, False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
        "SystemsModelGrid00"], ")"}], #37, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalS]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None], MultilineFunction -> None], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{1, 4}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{7, 10}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{13, 16}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{19, 22}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{5, 6}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{11, 12}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{17, 18}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{23, 24}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{25, 28}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{31, 34}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{29, 30}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{35, 36}, ","], "}"}], "}"}], "}"}], ",", 
     "SamplingPeriod", "->", 
     RowBox[{#37}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
  Tooltip->StateSpaceModel]], "Output",
 CellChangeTimes->{3.5071418193438797`*^9, 3.5071418534115763`*^9, 
  3.757628880852364*^9, 3.793324242044282*^9, 3.793324408538733*^9, 
  3.79332445182158*^9, 3.793327143774805*^9, 3.793327189681555*^9, 
  3.793327264716915*^9, 3.793848143194138*^9, 3.823228036418853*^9},
 CellLabel->
  "Out[2180]=",ExpressionUUID->"a7db8826-e81f-4666-bf20-26f6fdf8b390"]
}, Open  ]],

Cell["\<\
4-dimensional state space  \[Rule]  if there were 4 inputs or 4 outputs, \
there could be no zeros.\
\>", "Text",
 CellChangeTimes->{{3.5071423255257196`*^9, 3.507142350031433*^9}, {
  3.793324222193616*^9, 3.793324232179916*^9}, {3.793324487744982*^9, 
  3.793324493142318*^9}},
 FontSize->16,ExpressionUUID->"2d5044eb-51ff-4eb7-b724-923fdf025b29"]
}, Open  ]]
},
WindowSize->{740, 652},
WindowMargins->{{Automatic, 193}, {Automatic, 39}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"99f1b485-99bc-4b0e-adbd-2e75ab2509b2"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 327, 5, 67, "Section",ExpressionUUID->"9d313e16-b8be-4e51-ab03-8409dc1e3adc"],
Cell[909, 29, 157, 3, 30, "Input",ExpressionUUID->"c5a094b2-44b4-45b5-99d2-a9669f7d71a7"],
Cell[CellGroupData[{
Cell[1091, 36, 1069, 26, 51, "Input",ExpressionUUID->"07afd9fe-f5ab-4147-bf9c-cb68ebef9592"],
Cell[2163, 64, 851, 18, 54, "Output",ExpressionUUID->"7155f370-ab21-4f09-806c-e58796f373d1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3051, 87, 423, 10, 47, "Input",ExpressionUUID->"8d82452a-fd15-4239-8241-d7ffe27a97db"],
Cell[3477, 99, 1279, 31, 76, "Output",ExpressionUUID->"7bcab944-721d-4fbe-bea1-e4784563dde9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4793, 135, 502, 13, 52, "Input",ExpressionUUID->"c066c259-ea75-4f91-8d02-d17906fa9d07"],
Cell[5298, 150, 1570, 44, 57, "Output",ExpressionUUID->"f3ee38c6-6747-4db8-afd0-a30d9138e528"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6905, 199, 713, 15, 30, "Input",ExpressionUUID->"65140064-dcb3-4c69-9229-08570c6fb419"],
Cell[7621, 216, 2472, 75, 69, "Output",ExpressionUUID->"27195f1e-cec5-46f5-9097-1dd68a22d23e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10130, 296, 567, 12, 30, "Input",ExpressionUUID->"0892cb47-ff44-4985-beef-66c7e0dd7c1e"],
Cell[10700, 310, 1015, 25, 60, "Output",ExpressionUUID->"52fe2836-00d9-4810-89ee-60ff1dc88398"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11752, 340, 287, 6, 30, "Input",ExpressionUUID->"f8151ee8-1a0f-422c-a31b-0cf847f832c0"],
Cell[12042, 348, 3852, 88, 101, "Output",ExpressionUUID->"7c0d535b-a002-4d86-a416-4c72d870c18c"]
}, Open  ]],
Cell[15909, 439, 233, 5, 30, "Input",ExpressionUUID->"6bcc479c-73d4-44ba-b133-38741ffc9d8b"],
Cell[CellGroupData[{
Cell[16167, 448, 722, 19, 52, "Input",ExpressionUUID->"3a9b1f45-513d-4f28-858d-c53fe42089e7"],
Cell[16892, 469, 2351, 63, 57, "Output",ExpressionUUID->"5aff036a-55ed-41f9-b390-c2dbfb1bd41b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19280, 537, 775, 20, 52, "Input",ExpressionUUID->"4c1c3162-93ad-4112-aed7-9bbc8e6bb550"],
Cell[20058, 559, 2531, 69, 57, "Output",ExpressionUUID->"3a5914bc-e915-456f-a41b-dffbaad3ad1c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22626, 633, 774, 20, 52, "Input",ExpressionUUID->"d4fa5b47-72e5-4ad1-8d91-57bab1abde3f"],
Cell[23403, 655, 2129, 56, 53, "Output",ExpressionUUID->"f84f6696-78da-49fa-966c-8cb914c7f220"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25569, 716, 1644, 49, 94, "Input",ExpressionUUID->"da28fe87-3377-4309-90c9-fda5d79c8997"],
Cell[27216, 767, 23447, 436, 145, "Output",ExpressionUUID->"5b14da7a-69a1-4bf7-9cbb-317c803e93f6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50700, 1208, 634, 16, 30, "Input",ExpressionUUID->"bad36633-f7b5-43c6-a3eb-4a261d2ee99b"],
Cell[51337, 1226, 1489, 39, 50, "Output",ExpressionUUID->"cc7fc08b-0a66-4aab-b8da-02599ba3b60e"]
}, Open  ]],
Cell[52841, 1268, 203, 2, 33, "Text",ExpressionUUID->"229938a1-5386-4972-8814-3261fada5ef6"],
Cell[53047, 1272, 280, 6, 30, "Input",ExpressionUUID->"fdd5b960-d8b5-4e21-85e6-1d3a0b21c2ec"],
Cell[CellGroupData[{
Cell[53352, 1282, 502, 12, 30, "Input",ExpressionUUID->"42a11bed-4469-45dd-a186-3cfd4c1f50b4"],
Cell[53857, 1296, 588, 11, 34, "Output",ExpressionUUID->"8761dc59-2026-46b5-b1d6-04b748929e15"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54482, 1312, 356, 10, 30, "Input",ExpressionUUID->"4931a1df-bf8f-48c9-9004-acc98e59a458"],
Cell[54841, 1324, 645, 13, 24, "Message",ExpressionUUID->"fbd155ff-cb2f-4bf0-8638-c7642c3e7ca6"],
Cell[55489, 1339, 466, 8, 37, "Output",ExpressionUUID->"42f2e589-29e6-4dcc-a431-7e044668919d"]
}, Open  ]],
Cell[55970, 1350, 464, 8, 75, "Text",ExpressionUUID->"063d94e7-a922-40e9-98ed-ada313ea4fa9"],
Cell[56437, 1360, 569, 18, 49, "Input",ExpressionUUID->"b92b3c7a-2a76-4838-b9f2-d59f6bf1ceaa"],
Cell[57009, 1380, 279, 6, 30, "Input",ExpressionUUID->"57ebf0be-63ca-49d2-b6ba-140a2cb3ed37"],
Cell[CellGroupData[{
Cell[57313, 1390, 960, 28, 52, "Input",ExpressionUUID->"46bbe50f-8ff8-41e7-9649-103cc75e724b"],
Cell[58276, 1420, 49927, 1071, 124, "Output",ExpressionUUID->"20aeb136-6701-4457-a12d-3763427c7ee2"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[108252, 2497, 260, 5, 62, "Section",ExpressionUUID->"e4aa0c27-fa9a-432b-9fc2-f2a135377cdc"],
Cell[CellGroupData[{
Cell[108537, 2506, 306, 6, 30, "Input",ExpressionUUID->"bc32a308-1f21-4cf3-ad58-4b0ddca6ac36"],
Cell[108846, 2514, 4115, 94, 196, "Output",ExpressionUUID->"a7db8826-e81f-4666-bf20-26f6fdf8b390"]
}, Open  ]],
Cell[112976, 2611, 359, 7, 36, "Text",ExpressionUUID->"2d5044eb-51ff-4eb7-b724-923fdf025b29"]
}, Open  ]]
}
]
*)

