(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    226382,       4347]
NotebookOptionsPosition[    223204,       4287]
NotebookOutlinePosition[    223603,       4303]
CellTagsIndexPosition[    223560,       4300]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["The negative combination is non-minimum phase (Sec. \
3.6.4)", "Subsection"]], "Text",
 CellChangeTimes->{{3.503190341398798*^9, 3.503190376788212*^9}, {
  3.5037413546914263`*^9, 3.503741358598384*^9}, {3.79332575524231*^9, 
  3.793325757748115*^9}, {3.7938510539761744`*^9, 
  3.793851082753109*^9}},ExpressionUUID->"37f451fd-4264-48a7-86e5-\
773d7aee0f6e"],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 FontSize->14,
 CellLabel->
  "In[2148]:=",ExpressionUUID->"b5a5a892-bf70-40bf-88f6-5bd35ac32ab9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gnmp", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["\[Alpha]", 
          RowBox[{"1", "+", 
           RowBox[{"0.02", "s"}], "+", 
           SuperscriptBox["s", "2"]}]], "+", 
         FractionBox["\[Beta]", 
          RowBox[{"1", "+", 
           RowBox[{"0.02", "s"}], "+", " ", 
           FractionBox[
            SuperscriptBox["s", "2"], 
            SuperscriptBox["\[Omega]", "2"]]}]]}], ")"}], " ", "/.", 
       RowBox[{"\[Alpha]", "\[Rule]", 
        RowBox[{"-", "1"}]}]}], " ", "/.", 
      RowBox[{"\[Beta]", "\[Rule]", "2"}]}], " ", "/.", 
     RowBox[{"\[Omega]", "\[Rule]", 
      RowBox[{"1", "/", "2"}]}]}], " ", "//", " ", "Factor"}], " ", "//", " ",
    "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.503710535033688*^9, 3.503710535475306*^9}, {
   3.5053298493446217`*^9, 3.5053299055600653`*^9}, {3.5053299415946608`*^9, 
   3.50532999226322*^9}, {3.505330048395296*^9, 3.505330055328455*^9}, {
   3.505330185984968*^9, 3.5053301880888023`*^9}, {3.505330627066401*^9, 
   3.505330630481312*^9}, {3.505330815342444*^9, 3.5053308183486633`*^9}, 
   3.505398696809875*^9, {3.505398838028449*^9, 3.505398848987485*^9}, 
   3.5053998068273993`*^9, 3.505401734412991*^9, {3.505402122064433*^9, 
   3.505402122168022*^9}, 3.5054021601880093`*^9, {3.505402197689837*^9, 
   3.5054022346010113`*^9}, {3.50540419598708*^9, 3.5054042203277397`*^9}, {
   3.505404741758353*^9, 3.505404774017671*^9}},
 CellLabel->
  "In[2149]:=",ExpressionUUID->"bca3fd42-6028-4c71-bf75-82dbf897f2b6"],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.25`", "\[VeryThinSpace]", "+", 
   RowBox[{"0.0050000000000000044`", " ", "s"}], "-", 
   RowBox[{"0.5`", " ", 
    SuperscriptBox["s", "2"]}]}], 
  RowBox[{"0.25`", "\[VeryThinSpace]", "+", 
   RowBox[{"0.01`", " ", "s"}], "+", 
   RowBox[{"1.2501`", " ", 
    SuperscriptBox["s", "2"]}], "+", 
   RowBox[{"0.025`", " ", 
    SuperscriptBox["s", "3"]}], "+", 
   RowBox[{"1.`", " ", 
    SuperscriptBox["s", "4"]}]}]]], "Output",
 CellChangeTimes->{
  3.503190282192957*^9, 3.503710538713365*^9, {3.505329887986141*^9, 
   3.505329906167819*^9}, 3.505329993702826*^9, 3.505330059170473*^9, 
   3.50533018930795*^9, 3.505330634342409*^9, 3.5053308219350443`*^9, 
   3.50539870370191*^9, 3.505398860068872*^9, 3.5053998169444847`*^9, 
   3.505401739501975*^9, 3.505402129445117*^9, {3.505402163621451*^9, 
   3.505402240713093*^9}, 3.505404130749378*^9, {3.50540421014815*^9, 
   3.50540425730792*^9}, 3.5054043430417423`*^9, 3.505404576097804*^9, 
   3.505404672284205*^9, 3.50540472248276*^9, {3.505404756021358*^9, 
   3.505404785567004*^9}, 3.757300762775139*^9, 3.7573008439213963`*^9, 
   3.7933257089016237`*^9, 3.793325763377182*^9, 3.8232280002198067`*^9},
 FontSize->14,
 CellLabel->
  "Out[2149]=",ExpressionUUID->"a2422857-5edf-4137-a0a4-434f9fd25241"]
}, Open  ]],

Cell["\<\
Solving for the roots of the numerator shows one positive and one negative \
zero:\
\>", "Text",
 CellChangeTimes->{{3.503741414695532*^9, 3.503741444394539*^9}},
 FontSize->16,ExpressionUUID->"73b0aeb8-cb5e-433b-af70-5f14a0c77aaa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"s", "/.", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Numerator", "[", "Gnmp", "]"}], "\[Equal]", "0"}], ",", "s"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.503710541482272*^9, 3.503710541992799*^9}, {
  3.757300813358835*^9, 3.757300823440599*^9}},
 FontSize->14,
 CellLabel->
  "In[2150]:=",ExpressionUUID->"f8ab6656-0d89-47fe-966d-8b6682e9bad2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.7021244586351119`"}], ",", "0.7121244586351119`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.757300824319433*^9, 3.75730084400596*^9}, 
   3.793325708909622*^9, 3.7933257633843946`*^9, 3.823228000225739*^9},
 CellLabel->
  "Out[2150]=",ExpressionUUID->"bcb00e8c-ca70-49df-9561-70f792af7ff9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The positive combination is minimum phase", "Subsection",
 CellChangeTimes->{{3.503190411479273*^9, 3.503190432557456*^9}, {
  3.503741361751255*^9, 
  3.503741363863317*^9}},ExpressionUUID->"c1a93e4c-5da3-4811-92dd-\
def1767eaa68"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gmp", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["\[Alpha]", 
          RowBox[{"1", "+", 
           RowBox[{"0.02", "s"}], "+", 
           SuperscriptBox["s", "2"]}]], "+", 
         FractionBox["\[Beta]", 
          RowBox[{"1", "+", 
           RowBox[{"0.02", "s"}], "+", " ", 
           FractionBox[
            SuperscriptBox["s", "2"], 
            SuperscriptBox["\[Omega]", "2"]]}]]}], ")"}], "  ", "/.", 
       RowBox[{"\[Alpha]", "\[Rule]", "1"}]}], " ", "/.", 
      RowBox[{"\[Beta]", "\[Rule]", "2"}]}], " ", "/.", 
     RowBox[{"\[Omega]", "\[Rule]", 
      RowBox[{"1", "/", "2"}]}]}], "//", " ", "Factor"}], " ", "//", " ", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.503710470206315*^9, 3.503710474315235*^9}, {
   3.503710548845701*^9, 3.503710549298295*^9}, 3.5053299353019*^9, {
   3.505330011933529*^9, 3.505330021422776*^9}, 3.505398699227611*^9, {
   3.505398841321968*^9, 3.505398851944584*^9}, 3.505399812578434*^9, 
   3.5054017364697533`*^9, {3.505402124341568*^9, 3.505402124430861*^9}, {
   3.5054021826414413`*^9, 3.50540223716074*^9}, {3.505404201882908*^9, 
   3.5054042258010283`*^9}, {3.505404749213399*^9, 3.505404779127886*^9}},
 CellLabel->
  "In[2151]:=",ExpressionUUID->"58c2d9b9-dc95-46c6-91ff-8b166d4a9309"],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.75`", "\[VeryThinSpace]", "+", 
   RowBox[{"0.015`", " ", "s"}], "+", 
   RowBox[{"1.5`", " ", 
    SuperscriptBox["s", "2"]}]}], 
  RowBox[{"0.25`", "\[VeryThinSpace]", "+", 
   RowBox[{"0.01`", " ", "s"}], "+", 
   RowBox[{"1.2501`", " ", 
    SuperscriptBox["s", "2"]}], "+", 
   RowBox[{"0.025`", " ", 
    SuperscriptBox["s", "3"]}], "+", 
   RowBox[{"1.`", " ", 
    SuperscriptBox["s", "4"]}]}]]], "Output",
 CellChangeTimes->{
  3.503190318121949*^9, 3.503710483457822*^9, 3.503710552654417*^9, 
   3.5053300225175657`*^9, 3.5053300593120213`*^9, 3.505330634500421*^9, 
   3.505330822090827*^9, 3.50539870390781*^9, 3.505398860224661*^9, 
   3.5053998170806637`*^9, 3.505401739641569*^9, 3.505402129583906*^9, {
   3.505402163760159*^9, 3.505402240852542*^9}, 3.5054041309619293`*^9, {
   3.50540421028579*^9, 3.505404257482328*^9}, 3.505404343198345*^9, 
   3.505404576202183*^9, 3.505404672423483*^9, 3.505404722624125*^9, {
   3.50540475610883*^9, 3.505404785656707*^9}, 3.757300763596785*^9, 
   3.75730084408957*^9, 3.793325708950165*^9, 3.793325763422048*^9, 
   3.823228000248185*^9},
 FontSize->14,
 CellLabel->
  "Out[2151]=",ExpressionUUID->"648b0411-b653-486b-8e85-c3ef95a981d7"]
}, Open  ]],

Cell["\<\
Here, the zeros are a lightly damped complex - conjugate pair\
\>", "Text",
 CellChangeTimes->{{3.503741458280346*^9, 3.503741480147428*^9}},
 FontSize->16,ExpressionUUID->"427e0aaf-7d44-47a8-a804-cee25eec8bd2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"s", "/.", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Numerator", "[", "Gmp", "]"}], "\[Equal]", "0"}], ",", "s"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.503710557380536*^9, 3.5037105575004663`*^9}, {
  3.757300830634391*^9, 3.7573008345528793`*^9}},
 FontSize->14,
 CellLabel->
  "In[2152]:=",ExpressionUUID->"aebf5820-5801-4c4b-9edd-782ed407d846"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.005`"}], "-", 
    RowBox[{"0.7070891032960415`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.005`"}], "+", 
    RowBox[{"0.7070891032960415`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.503190325637141*^9, 3.503710486071383*^9, 3.503710558557633*^9, 
   3.505330025285137*^9, 3.505330059357176*^9, 3.505330634546225*^9, 
   3.5053308221341743`*^9, 3.505398703952598*^9, 3.5053988602701063`*^9, 
   3.505399817127864*^9, 3.5054017396880903`*^9, 3.505402129631976*^9, {
   3.5054021638069153`*^9, 3.505402240900275*^9}, 3.5054041310089397`*^9, {
   3.505404210334652*^9, 3.505404257547082*^9}, 3.5054043432453957`*^9, 
   3.505404576252808*^9, 3.505404672490344*^9, 3.505404722690761*^9, {
   3.505404756159419*^9, 3.505404785704269*^9}, 3.7573007636960917`*^9, {
   3.7573008351771097`*^9, 3.75730084418707*^9}, 3.79332570895685*^9, 
   3.793325763428563*^9, 3.823228000253311*^9},
 FontSize->14,
 CellLabel->
  "Out[2152]=",ExpressionUUID->"814e0a29-787d-4e13-9b7d-465f33eea14c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bode Plots for both systems", "Subsection",
 CellChangeTimes->{{3.503190411479273*^9, 3.5031904528680773`*^9}, {
  3.5053300267834473`*^9, 
  3.505330028390152*^9}},ExpressionUUID->"545ce957-b9e7-4c6a-a326-\
03b91d75f58b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BodePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Gmp", ",", "Gnmp"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{".2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.503710508084516*^9, 3.5037105082272367`*^9}, {
  3.503710562500771*^9, 3.503710577262638*^9}, {3.505330078885838*^9, 
  3.505330095517029*^9}, {3.5053301469333963`*^9, 3.505330160365283*^9}, {
  3.5053301971435747`*^9, 3.505330199368371*^9}, {3.505399025833436*^9, 
  3.5053990315456877`*^9}},
 FontSize->14,
 CellLabel->
  "In[2153]:=",ExpressionUUID->"b5895691-ba64-4701-949c-cfc681a3dead"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVl3c8148Tx42EIqOysvf42Hu+jyQipZBQJERZSaSUkTKiIolUpKiQPcq6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           "]]},
         Annotation[#, "Charting`Private`Tag$799885#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVl3c81f8Xx40kWaVBRsi4197XzOeYqaSMhIREQ4OKUslKGVGRkZGdjLJH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           "]]},
         Annotation[#, "Charting`Private`Tag$799885#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-0.6989700043360187, -23.368301187541714`},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-40., 
           FormBox[
            RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
           FormBox[
            RowBox[{"-", "20"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {20., 
           FormBox["20", TraditionalForm]}, {40., 
           FormBox["40", TraditionalForm]}, {60., 
           FormBox["60", TraditionalForm]}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {11.326498990602667`, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-0.3010299956639812, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {0., 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"1.0\"", ShowStringCharacters -> False], 1., 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.17609125905568124`, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.3010299956639812, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"2.0\"", ShowStringCharacters -> False], 2., 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.3979400086720376, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"2.5\"", ShowStringCharacters -> False], 2.5, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.47712125471966244`, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"3.0\"", ShowStringCharacters -> False], 3., 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-1., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5228787452803376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.2218487496163564, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.045757490560675115`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.04139268515822508, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.07918124604762482, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.11394335230683679`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.146128035678238, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2041199826559248, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2304489213782739, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.25527250510330607`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2787536009528289, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3222192947339193, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3424226808222063, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.36172783601759284`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.38021124171160603`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.414973347970818, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.43136376415898736`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4471580313422192, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4623979978989561, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}, {{-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.17609125905568124`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5228787452803376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.2218487496163564, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.045757490560675115`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.04139268515822508, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.07918124604762482, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.11394335230683679`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.146128035678238, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2041199826559248, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2304489213782739, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.25527250510330607`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2787536009528289, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3222192947339193, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3424226808222063, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.36172783601759284`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.38021124171160603`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.414973347970818, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.43136376415898736`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4471580313422192, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4623979978989561, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->
       NCache[{{-0.6989700043360187, Log[3]/Log[10]}, {-23.368301187541714`, 
         46.02129916874705}}, {{-0.6989700043360187, 
        0.4771212547196624}, {-23.368301187541714`, 46.02129916874705}}],
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-0.3010299956639812, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {0., 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"1.0\"", ShowStringCharacters -> False], 1., 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.17609125905568124`, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.3010299956639812, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"2.0\"", ShowStringCharacters -> False], 2., 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.3979400086720376, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"2.5\"", ShowStringCharacters -> False], 2.5, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.47712125471966244`, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"3.0\"", ShowStringCharacters -> False], 3., 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-1., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.5228787452803376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.2218487496163564, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.045757490560675115`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.04139268515822508, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.07918124604762482, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.11394335230683679`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.146128035678238, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.2041199826559248, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.2304489213782739, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.25527250510330607`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.2787536009528289, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3222192947339193, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3424226808222063, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.36172783601759284`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.38021124171160603`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.414973347970818, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.43136376415898736`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.4471580313422192, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.4623979978989561, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}}, {{-40., 
          FormBox[
           RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
          FormBox[
           RowBox[{"-", "20"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {20., 
          FormBox["20", TraditionalForm]}, {40., 
          FormBox["40", TraditionalForm]}, {60., 
          FormBox["60", TraditionalForm]}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {11.326498990602667`, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV2nc4lt8bAHApIcUXrxkZGYUKEUkeJCMze2a+bxoio5CERERlk5KZlOy9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           "]]},
         Annotation[#, "Charting`Private`Tag$800380#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV13c8ld8fAHAjMxIp8U2IomiQEeFBEoWijEhG3Gsn3BtFRrJLKjIzkozI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           "]]},
         Annotation[#, "Charting`Private`Tag$800380#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-0.6989700043360187, -359.2911349870091},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-400., 
           FormBox[
            RowBox[{"-", "400"}], TraditionalForm]}, {-300., 
           FormBox[
            RowBox[{"-", "300"}], TraditionalForm]}, {-200., 
           FormBox[
            RowBox[{"-", "200"}], TraditionalForm]}, {-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-400., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-380., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-360., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-340., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-320., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-280., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-260., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-179.64556749350456`, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-400., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-400., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-380., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-360., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-340., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-320., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-280., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-260., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-0.3010299956639812, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {0., 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"1.0\"", ShowStringCharacters -> False], 1., 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.17609125905568124`, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.3010299956639812, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"2.0\"", ShowStringCharacters -> False], 2., 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.3979400086720376, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"2.5\"", ShowStringCharacters -> False], 2.5, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.47712125471966244`, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"3.0\"", ShowStringCharacters -> False], 3., 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-1., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5228787452803376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.2218487496163564, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.045757490560675115`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.04139268515822508, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.07918124604762482, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.11394335230683679`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.146128035678238, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2041199826559248, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2304489213782739, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.25527250510330607`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2787536009528289, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3222192947339193, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3424226808222063, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.36172783601759284`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.38021124171160603`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.414973347970818, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.43136376415898736`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4471580313422192, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4623979978989561, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}, {{-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.17609125905568124`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5228787452803376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.2218487496163564, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.045757490560675115`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.04139268515822508, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.07918124604762482, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.11394335230683679`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.146128035678238, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2041199826559248, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2304489213782739, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.25527250510330607`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2787536009528289, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3222192947339193, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3424226808222063, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.36172783601759284`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.38021124171160603`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.414973347970818, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.43136376415898736`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4471580313422192, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4623979978989561, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->
       NCache[{{-0.6989700043360187, Log[3]/Log[10]}, {-359.2911349870091, 
         0.}}, {{-0.6989700043360187, 
        0.4771212547196624}, {-359.2911349870091, 0.}}],
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-0.3010299956639812, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {0., 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"1.0\"", ShowStringCharacters -> False], 1., 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.17609125905568124`, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.3010299956639812, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"2.0\"", ShowStringCharacters -> False], 2., 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.3979400086720376, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"2.5\"", ShowStringCharacters -> False], 2.5, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.47712125471966244`, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"3.0\"", ShowStringCharacters -> False], 3., 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-1., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.5228787452803376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.2218487496163564, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.045757490560675115`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.04139268515822508, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.07918124604762482, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.11394335230683679`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.146128035678238, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.2041199826559248, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.2304489213782739, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.25527250510330607`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.2787536009528289, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3222192947339193, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3424226808222063, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.36172783601759284`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.38021124171160603`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.414973347970818, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.43136376415898736`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.4471580313422192, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.4623979978989561, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}}, {{-400., 
          FormBox[
           RowBox[{"-", "400"}], TraditionalForm]}, {-300., 
          FormBox[
           RowBox[{"-", "300"}], TraditionalForm]}, {-200., 
          FormBox[
           RowBox[{"-", "200"}], TraditionalForm]}, {-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-400., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-380., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-360., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-340., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-320., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-300., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-300., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-280., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-260., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-240., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-220., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-180., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-160., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-140., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-120., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-179.64556749350456`, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.503190461683221*^9, {3.5037104954133368`*^9, 3.503710509192091*^9}, {
   3.503710565947543*^9, 3.50371057823393*^9}, {3.50533003281569*^9, 
   3.505330096388953*^9}, {3.5053301487717743`*^9, 3.505330161798605*^9}, {
   3.505330192088766*^9, 3.50533020073077*^9}, 3.505330634977249*^9, 
   3.505330822573145*^9, 3.505398704445074*^9, 3.505398860700994*^9, {
   3.505399027700344*^9, 3.5053990327070704`*^9}, 3.5053998175495234`*^9, 
   3.505401740118333*^9, 3.505402130145423*^9, {3.505402164280641*^9, 
   3.505402241332662*^9}, 3.505404131433627*^9, {3.505404210758398*^9, 
   3.50540425824247*^9}, 3.50540434366951*^9, 3.505404576685527*^9, 
   3.505404672938004*^9, 3.505404723116928*^9, {3.5054047566815567`*^9, 
   3.505404786462489*^9}, 3.7573007644767838`*^9, 3.757300844789317*^9, 
   3.793325709233656*^9, 3.793325763687578*^9, 3.823228000576515*^9},
 CellLabel->
  "Out[2153]=",ExpressionUUID->"bcb87002-d30e-4565-8fef-f10746301d7c"]
}, Open  ]],

Cell["Now check the mass + 2 - spring system of Doyle et al.", "Text",
 CellChangeTimes->{{3.5054031723705387`*^9, 3.505403191050763*^9}},
 FontSize->16,ExpressionUUID->"1c89b96b-1b26-4c07-972e-dfbfdfc7685c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gdmp", " ", "=", 
   RowBox[{"(", " ", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"k", "+", 
       RowBox[{"m", " ", 
        SuperscriptBox["s", "2"]}]}]], "+", 
     FractionBox[
      RowBox[{" ", 
       SuperscriptBox[
        SubscriptBox["l", "u"], "2"]}], 
      RowBox[{
       RowBox[{"k", " ", 
        SuperscriptBox["l", "2"]}], "+", 
       RowBox[{"I0", " ", 
        SuperscriptBox["s", "2"]}]}]]}], ")"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.505403195606043*^9, 3.5054033665108423`*^9}, {
   3.505403439288041*^9, 3.505403440247664*^9}, {3.5054040961566*^9, 
   3.505404101525754*^9}, 3.505404253497428*^9, {3.50540431887733*^9, 
   3.505404333503808*^9}, {3.505404482559525*^9, 3.505404484418686*^9}, {
   3.505404703285471*^9, 3.5054047081201143`*^9}},
 FontSize->14,
 CellLabel->
  "In[2154]:=",ExpressionUUID->"0979cb3f-493c-4fd0-bb41-4cf0f914a47f"],

Cell["minus one to make a prettier phase graph", "Text",
 CellChangeTimes->{{3.505404103657611*^9, 3.505404125673627*^9}},
 FontSize->16,ExpressionUUID->"74f888b1-6e23-4c4c-abc9-5af1cd98f6cf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gdnmp", " ", "=", " ", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"k", "+", 
      RowBox[{"m", " ", 
       SuperscriptBox["s", "2"]}]}]], "-", 
    FractionBox[
     RowBox[{" ", 
      SuperscriptBox[
       SubscriptBox["l", "u"], "2"]}], 
     RowBox[{
      RowBox[{"k", " ", 
       SuperscriptBox["l", "2"]}], "+", 
      RowBox[{"I0", " ", 
       SuperscriptBox["s", "2"]}]}]]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.505403368531836*^9, 3.505403379764389*^9}, {
  3.505403446934669*^9, 3.50540345007178*^9}, {3.505404336993362*^9, 
  3.505404339946023*^9}, {3.505404490837338*^9, 3.505404491509026*^9}, {
  3.505404710960404*^9, 3.505404714797777*^9}},
 FontSize->14,
 CellLabel->
  "In[2155]:=",ExpressionUUID->"b7d03ec2-f9b0-455f-abb7-b54e6c69e281"],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"1", "/", "2"}]}], ";", " ", 
  RowBox[{"m", "=", "2"}], ";", " ", 
  RowBox[{"l", "=", "1"}], ";", " ", 
  RowBox[{"I0", "=", 
   RowBox[{"1", "/", "2"}]}], ";", " ", 
  RowBox[{
   SubscriptBox["l", "u"], "=", 
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.50540338485651*^9, 3.5054034233691883`*^9}},
 FontSize->14,
 CellLabel->
  "In[2156]:=",ExpressionUUID->"8ec5b7fa-75bf-4022-8468-62531d9bf260"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"Gdmp", "-", " ", "Gmp"}], ")"}], " ", "//", " ", "Together"}], 
  " ", "//", " ", "Simplify"}]], "Input",
 CellChangeTimes->{{3.505403425357325*^9, 3.5054034285430193`*^9}, {
   3.505403459192265*^9, 3.505403478190699*^9}, {3.505403536974771*^9, 
   3.5054035386141*^9}, {3.50540436986935*^9, 3.50540440130729*^9}, {
   3.505404457544993*^9, 3.505404459642273*^9}, {3.50540449658073*^9, 
   3.505404504332878*^9}, 3.5054045502665653`*^9, {3.5054045937813263`*^9, 
   3.505404600974361*^9}},
 FontSize->14,
 CellLabel->
  "In[2157]:=",ExpressionUUID->"af20592d-06e7-41e4-ba4c-4e1004033a85"],

Cell[BoxData[
 FractionBox[
  RowBox[{"s", " ", 
   RowBox[{"(", 
    RowBox[{"0.0037499999999999994`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.00007500000000004725`", " ", "s"}], "+", 
     RowBox[{"0.014999999999999998`", " ", 
      SuperscriptBox["s", "2"]}], "+", 
     RowBox[{"0.0001500000000000945`", " ", 
      SuperscriptBox["s", "3"]}], "+", 
     RowBox[{"0.022500000000000006`", " ", 
      SuperscriptBox["s", "4"]}]}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1.`", "\[VeryThinSpace]", "+", 
     SuperscriptBox["s", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"0.25`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      SuperscriptBox["s", "2"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"0.25`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.01`", " ", "s"}], "+", 
     RowBox[{"1.2501`", " ", 
      SuperscriptBox["s", "2"]}], "+", 
     RowBox[{"0.025`", " ", 
      SuperscriptBox["s", "3"]}], "+", 
     RowBox[{"1.`", " ", 
      SuperscriptBox["s", "4"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.505403428984095*^9, 3.50540348173232*^9}, 
   3.505403539078188*^9, 3.5054041318794527`*^9, {3.505404211169544*^9, 
   3.505404258415612*^9}, {3.505404344114399*^9, 3.505404401648868*^9}, {
   3.5054045772570066`*^9, 3.505404601450886*^9}, 3.5054046734599524`*^9, 
   3.5054047236251507`*^9, {3.5054047571960087`*^9, 3.5054047870241213`*^9}, 
   3.757300764967724*^9, 3.757300845223599*^9, 3.793325709394191*^9, 
   3.7933257638280497`*^9, 3.8232280006851683`*^9},
 CellLabel->
  "Out[2157]=",ExpressionUUID->"0358063f-be7c-46e6-8178-6634d43a721f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Gdnmp", "-", "Gnmp"}], " ", "//", " ", "Together"}], " ", "//", 
  " ", "Simplify"}]], "Input",
 CellChangeTimes->{{3.505403485708991*^9, 3.505403489297464*^9}, {
   3.505403530115712*^9, 3.5054035320433807`*^9}, {3.505404554570509*^9, 
   3.5054045617163963`*^9}, 3.5054046175169563`*^9},
 FontSize->14,
 CellLabel->
  "In[2158]:=",ExpressionUUID->"123c11d4-2cbb-4fd3-8e48-e060eb8dde8d"],

Cell[BoxData[
 FractionBox[
  RowBox[{"s", " ", 
   RowBox[{"(", 
    RowBox[{"0.001249999999999999`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.000024999999999997243`", " ", "s"}], "-", 
     RowBox[{"0.005000000000000005`", " ", 
      SuperscriptBox["s", "2"]}], "-", 
     RowBox[{"0.000049999999999994487`", " ", 
      SuperscriptBox["s", "3"]}], "-", 
     RowBox[{"0.017500000000000005`", " ", 
      SuperscriptBox["s", "4"]}]}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1.`", "\[VeryThinSpace]", "+", 
     SuperscriptBox["s", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"0.25`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      SuperscriptBox["s", "2"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"0.25`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.01`", " ", "s"}], "+", 
     RowBox[{"1.2501`", " ", 
      SuperscriptBox["s", "2"]}], "+", 
     RowBox[{"0.025`", " ", 
      SuperscriptBox["s", "3"]}], "+", 
     RowBox[{"1.`", " ", 
      SuperscriptBox["s", "4"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.50540349084156*^9, 3.505403532450543*^9, 3.5054041319345493`*^9, {
   3.505404211268733*^9, 3.5054042584895144`*^9}, 3.505404344172863*^9, 
   3.505404577312251*^9, 3.505404631901029*^9, 3.505404673515952*^9, 
   3.5054047236967287`*^9, {3.505404757252885*^9, 3.505404787082925*^9}, 
   3.757300765087936*^9, 3.757300845307167*^9, 3.793325709402446*^9, 
   3.793325763860921*^9, 3.823228000690288*^9},
 CellLabel->
  "Out[2158]=",ExpressionUUID->"e6caf2e1-e766-4ecc-b631-1e877b1283bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BodePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Gdmp", ",", "Gdnmp"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5054035702641153`*^9, 3.5054036559589767`*^9}, 
   3.505403724042582*^9, 3.505404569864231*^9, {3.505404621131987*^9, 
   3.50540462416286*^9}},
 CellLabel->
  "In[2159]:=",ExpressionUUID->"b856004e-3e56-4bd6-afee-00c85d25aafc"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVkHk41IsbxSUSkhalki2MMcYYw2CsrzVpk7KUuoWSFq266Vqypahu9BQi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           "]], 
          LineBox[CompressedData["
1:eJw9mGk8FOzfxS1Zo2SNyFjKNvadyVx2shSlbEWWECGKyJISKu4ihDYhQmVN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           "]], 
          LineBox[CompressedData["
1:eJwVjns80wsfgEtO6bj0suLQOgmxbFNKLKPvlxRFjlsyrxpS6YS35pZCEgqL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           "]]},
         Annotation[#, "Charting`Private`Tag$801459#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVjmk4lAsbgCcfLUrKp7RcaOzGxJgiY31IcogmJ0vJrtKCFtVUQiihIiFb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           "]], 
          LineBox[CompressedData["
1:eJw9mHk81N/3x62JLCVLSRHqPWMGY5eGDsYuEalUaNEeUYlSJJ9EVGQJJSQp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           "]], LineBox[CompressedData["
1:eJwVxXs80wsfAGDplEtJktwqhuYS5bqN0fc7RC6vco29nUhCuVQrJCM5UrSS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           "]]},
         Annotation[#, "Charting`Private`Tag$801459#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-0.6989700043360187, -47.69223818838891},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-60., 
           FormBox[
            RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
           FormBox[
            RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
           FormBox[
            RowBox[{"-", "20"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {20., 
           FormBox["20", TraditionalForm]}, {40., 
           FormBox["40", TraditionalForm]}, {60., 
           FormBox["60", TraditionalForm]}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {3.681579253648067, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-0.3010299956639812, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {0., 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"1.0\"", ShowStringCharacters -> False], 1., 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.17609125905568124`, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.3010299956639812, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"2.0\"", ShowStringCharacters -> False], 2., 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.3979400086720376, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"2.5\"", ShowStringCharacters -> False], 2.5, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.47712125471966244`, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"3.0\"", ShowStringCharacters -> False], 3., 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-1., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5228787452803376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.2218487496163564, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.045757490560675115`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.04139268515822508, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.07918124604762482, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.11394335230683679`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.146128035678238, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2041199826559248, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2304489213782739, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.25527250510330607`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2787536009528289, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3222192947339193, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3424226808222063, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.36172783601759284`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.38021124171160603`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.414973347970818, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.43136376415898736`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4471580313422192, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4623979978989561, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}, {{-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.17609125905568124`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5228787452803376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.2218487496163564, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.045757490560675115`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.04139268515822508, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.07918124604762482, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.11394335230683679`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.146128035678238, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2041199826559248, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2304489213782739, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.25527250510330607`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2787536009528289, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3222192947339193, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3424226808222063, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.36172783601759284`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.38021124171160603`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.414973347970818, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.43136376415898736`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4471580313422192, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4623979978989561, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->
       NCache[{{-0.6989700043360187, Log[3]/Log[10]}, {-47.69223818838891, 
         55.05539669568505}}, {{-0.6989700043360187, 
        0.4771212547196624}, {-47.69223818838891, 55.05539669568505}}],
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-0.3010299956639812, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {0., 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"1.0\"", ShowStringCharacters -> False], 1., 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.17609125905568124`, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.3010299956639812, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"2.0\"", ShowStringCharacters -> False], 2., 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.3979400086720376, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"2.5\"", ShowStringCharacters -> False], 2.5, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.47712125471966244`, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"3.0\"", ShowStringCharacters -> False], 3., 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-1., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.5228787452803376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.2218487496163564, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.045757490560675115`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.04139268515822508, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.07918124604762482, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.11394335230683679`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.146128035678238, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.2041199826559248, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.2304489213782739, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.25527250510330607`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.2787536009528289, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3222192947339193, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3424226808222063, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.36172783601759284`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.38021124171160603`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.414973347970818, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.43136376415898736`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.4471580313422192, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.4623979978989561, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}}, {{-60., 
          FormBox[
           RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
          FormBox[
           RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
          FormBox[
           RowBox[{"-", "20"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {20., 
          FormBox["20", TraditionalForm]}, {40., 
          FormBox["40", TraditionalForm]}, {60., 
          FormBox["60", TraditionalForm]}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {3.681579253648067, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJxF1Xs01FkcAPDptdRqxW5Zk9egxmOiExFrPWbtbA+yLI0N0TRhFdqwKROz
crwyB0WlQt6PrCJSeYxInnkbMx6zP8IqsysWLZHdzna+33vOPfd8/rr3fB/3
S2H5O5xcSyKREv/bH87LwS8OLrhN8Ekfl/c7Wv8aFzQjNO7EZmf02ohDHE0H
dHB8828ODDQ7t2HLPT20WW+1wGt1HPynfjFLdAf9iG9o0dszBi4xytl78gu0
1fhkaIXzS7Dp6e44Cm8UfHwgp4zSMQKeVVPNMFmDJqefIuSNCTAhbR2wfl4M
PhaxXCzvOgw2aY9WsRUPgulRlQabvAfAyjMm3QtdQrCjdly2LLMf7CavQ3Ku
6gPXaOjTPn2IVtlr6FxzD00wze9rZqHZqQ4eMzFoH62Q2lgmOti8jVs92wsW
2XUVnZGgTY8LhBoT6OVLxO5YETqseY44UouOdFS2esNDJ/n4rdHQRuu10sV0
DXSTrkIlSxm9IuEHZsqhPf3lJilLPRjPwLJ2tVZ0b2/0XcsGtN9et2gPPjpz
YQP9zgO0zHlmueptdK5I94rFNbSlKcnfPQEd9C5fKz0CLb64dEvFFx0sbg82
90LLW2Q5HTuOLko/tyfUBf0dyUY2zQk96qEmqbZDc57ONQ0fQG9Tb85Z+eaj
uZ6198NTw5XN0Yobpudv70SHR1n+pCSLdox7abed6AZTEyONyCXoAc6j5F3j
XWCe9+s5S0X0bSXrdqpJB7i++WADjdQGZjilSRkLmsDsV7dcvV0bwb9eTClJ
GW0A/6Nao9ayFX2mbjR+af8zcNHnQY1XRuvBk2ypVR0O2nhxSiaRhY7kdZLf
7kcX99dRdMzqIX59lHItN3308qk8/QR1tObDFKP6rWgbUtzXC9LogIOh1trL
deA6McshfhTtIUXzc7mHXpquEnhloZOFthaB19EtBf5beGFoA5sHpTV26E8S
Td9S3jzF+iEf4E7uRk+7tGlOsfng/pMD63RiHoOlDBSkqXoPwN8HMCoKwgqx
/j4Ltl934Ba49Ijvk01jN8FK6SwN+TD0G33bebXyFPANe/UUc8oN8KukNuL8
YhJYwZhOED/wwJJGWul0TBy41lkh4j3/Ms6HCxKqEi0W/KT6mj9zfRTY1Xrq
/YsyLsa78G7G474w8MY27rf9VqHgo7K6PHlyCOY7OUwppiUQnF3hWJtrFAC2
FWmzn2X+jPPFJJ+5On8azGXY/yI54oH9bcs4RGo9Ct6x+XUBddIR7H9zu1za
psP4/5FPtEus6eAxn0K9v5a1wdFJxkMCxR0W/1/mWbvCfr64U8YKLBwLNRN2
2YDlTIT21CUWWPIoIUnI9wPbD5F4qTtCwNuKh7zygi6BZ3YlFzp/FQ+eEOQu
RHCTwV9Oct+6qmeAq9jFAeci8sBXg8o9cypKwLLLi5z18RVgOl/WL2e8Ghyu
OdXY8sdTMF/K+PkJpQaw9eFB12xyE9j34Z783ze24nurZonKfe1g96sbROk3
OsFnFRj7Sg27wUwaMWPV3AMmzuaey6H3ga9LUwJFgwLwbEej2ciPQrCqVpO7
Z6cIfKGDs1jpOQg+n+/mPj4yBG6Y+9s3snwY82MVy6HGiMH/Aqrsx/U=
           "]]},
         Annotation[#, "Charting`Private`Tag$801953#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJxF0XlM0wcUB/AfKgGvVYgRYVzlsKAVjYK1SIB2pMZrDARbA0iBUhgbZRGQ
Oit22CAgDR7gEUG8iogKoiIYwKKm2goWgVpaju4HUka0mwORBYRMl5n3XvLy
zee/l++jJmZEJs8jCCLty/6Xx8Uvt0/FjSqJr5P6id5rFYPm5BYnLeWh58l2
SLwi0eISze1IDlpQpVpW54cO0rXqU/41g/9cV5tovIRuUvqH6HpGwPWbFAHJ
y9Es81huI+8NOPDn7mKqfBic0Ke4T+0cAk+4u11mWqGdKn8i7RkkmLQNy1zw
0QTeJ5uttY8dBDO1Ba67TP1g9rHmjYtS+8Au48zuqS4DOMq3+BqF2wuOs19N
8Fpegx95rqMvfoB2DfDnPapDk9zgO15X0YKKSP54ITrN51BbERctDu6Qtk7o
wMbwrlu/WNCBCXqD5yh69ii5vsiIPqKZJPe0ofOjXFh/y9GlaSIrT1+0Xzvb
xPZEq9c4NCe6oOcsyqwrdmhhht0YdaYH+8y6r3VvR+t0BTdDVWhRQFwBX4m+
MmXNvnQPveQgt8GtHF1lXHMq5Aw6NJDIiD+Bzv5U7VMpQ5sOz1xwTUeLTVpx
cAraPuRq9L4E9K3KnA25MeitxE7KxWj0MN/d0hqOljyeVA9uQ6/w0Cjmvvtq
qbDtTl5Fnksw2tH6/cfyVei8Y6E/OlPQUcVvwr8lu8G0k/mbnOrRfZKmsrXm
LrA89e1kqCO63DlMS2N2gp9qtqvoRAeYE33RhqFXg387fL7+/LAKzLehi2Lq
noDfx3R4vRMowb3JffNXFz4E22x0sKX53QP/kMlpvHGkBrz1G3HE/G0XwA4M
NknuloOlnIgDlj18sPfStzdoY1HgUqckrSWMDR5Jq/H7a9YXXFDKGNA7eof8
7wNtc4Jn06uWsMCGkdwgQ9dOsB3TEEGbSQRbmk6UGpQicMQAIa/wPgReUTuQ
cj37KHh8bVkNb0sJeFRfNSWTloFXjkn/ifW4DG4R1GbmyK6DT2c3CBWN9WDK
7LRkQUkjmK2kiBTmVnCe17vnL/54DFbaMJ4lOavAYd/3x15zUoPTH2yo/n1h
O97bMkE2b9aC409bGyvPvQLvd+BsvuvfDebSyXGWpgdM7q/KUbBfg8/aUrOM
/XrwROfzoKG9BrCbjzpe+MoI/rVTMt0s7AcfrI6LNw8NgFWTH9LzGwbxP6wi
Ca3QBP4MCmIlwQ==
           "]]},
         Annotation[#, "Charting`Private`Tag$801953#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-0.6989700043360187, -360.},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-400., 
           FormBox[
            RowBox[{"-", "400"}], TraditionalForm]}, {-300., 
           FormBox[
            RowBox[{"-", "300"}], TraditionalForm]}, {-200., 
           FormBox[
            RowBox[{"-", "200"}], TraditionalForm]}, {-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-400., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-380., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-360., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-340., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-320., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-280., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-260., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-400., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-400., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-380., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-360., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-340., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-320., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-280., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-260., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-0.3010299956639812, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {0., 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"1.0\"", ShowStringCharacters -> False], 1., 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.17609125905568124`, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.3010299956639812, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"2.0\"", ShowStringCharacters -> False], 2., 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.3979400086720376, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"2.5\"", ShowStringCharacters -> False], 2.5, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
          0.47712125471966244`, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"3.0\"", ShowStringCharacters -> False], 3., 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-1., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5228787452803376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.2218487496163564, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.045757490560675115`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.04139268515822508, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.07918124604762482, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.11394335230683679`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.146128035678238, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2041199826559248, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2304489213782739, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.25527250510330607`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2787536009528289, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3222192947339193, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3424226808222063, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.36172783601759284`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.38021124171160603`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.414973347970818, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.43136376415898736`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4471580313422192, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4623979978989561, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}, {{-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.17609125905568124`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.5228787452803376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.2218487496163564, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-0.045757490560675115`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.04139268515822508, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.07918124604762482, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.11394335230683679`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.146128035678238, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2041199826559248, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2304489213782739, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.25527250510330607`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.2787536009528289, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3222192947339193, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3424226808222063, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.36172783601759284`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.38021124171160603`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.414973347970818, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.43136376415898736`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4471580313422192, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.4623979978989561, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->
       NCache[{{-0.6989700043360187, Log[3]/Log[10]}, {-360., 
         0.}}, {{-0.6989700043360187, 0.4771212547196624}, {-360., 0.}}],
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-0.3010299956639812, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {0., 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"1.0\"", ShowStringCharacters -> False], 1., 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.17609125905568124`, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.3010299956639812, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"2.0\"", ShowStringCharacters -> False], 2., 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.3979400086720376, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"2.5\"", ShowStringCharacters -> False], 2.5, 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
         0.47712125471966244`, 
          FormBox[
           TagBox[
            InterpretationBox[
             StyleBox["\"3.0\"", ShowStringCharacters -> False], 3., 
             AutoDelete -> True], NumberForm[#, {
              DirectedInfinity[1], 1}]& ], TraditionalForm]}, {-1., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.5228787452803376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.2218487496163564, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-0.045757490560675115`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.04139268515822508, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.07918124604762482, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.11394335230683679`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.146128035678238, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.17609125905568124`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.2041199826559248, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.2304489213782739, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.25527250510330607`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.2787536009528289, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3222192947339193, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3424226808222063, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.36172783601759284`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.38021124171160603`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.414973347970818, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.43136376415898736`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.4471580313422192, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.4623979978989561, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}}, {{-400., 
          FormBox[
           RowBox[{"-", "400"}], TraditionalForm]}, {-300., 
          FormBox[
           RowBox[{"-", "300"}], TraditionalForm]}, {-200., 
          FormBox[
           RowBox[{"-", "200"}], TraditionalForm]}, {-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-400., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-380., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-360., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-340., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-320., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-300., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-300., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-280., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-260., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-240., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-220., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-180., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-160., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-140., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-120., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-180., 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.505403606592794*^9, 3.505403657152151*^9}, 
   3.5054041323123417`*^9, {3.505404212080221*^9, 3.505404258854629*^9}, 
   3.505404344855165*^9, 3.505404577851739*^9, 3.505404625758026*^9, 
   3.505404674208461*^9, 3.5054047240656443`*^9, {3.5054047578137293`*^9, 
   3.5054047874530487`*^9}, 3.757300765729491*^9, 3.757300845699527*^9, 
   3.7933257096148033`*^9, 3.793325764069504*^9, 3.8232280009093027`*^9},
 CellLabel->
  "Out[2159]=",ExpressionUUID->"3b09fb01-9f88-4078-b779-30e6ceb7e480"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 652},
WindowMargins->{{Automatic, 142}, {Automatic, 129}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"2d10f4df-dfcf-4ad6-95c3-38d0ab69a9ed"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 383, 6, 41, "Text",ExpressionUUID->"37f451fd-4264-48a7-86e5-773d7aee0f6e"],
Cell[943, 28, 172, 4, 32, "Input",ExpressionUUID->"b5a5a892-bf70-40bf-88f6-5bd35ac32ab9"],
Cell[CellGroupData[{
Cell[1140, 36, 1620, 36, 97, "Input",ExpressionUUID->"bca3fd42-6028-4c71-bf75-82dbf897f2b6"],
Cell[2763, 74, 1304, 27, 58, "Output",ExpressionUUID->"a2422857-5edf-4137-a0a4-434f9fd25241"]
}, Open  ]],
Cell[4082, 104, 242, 5, 36, "Text",ExpressionUUID->"73b0aeb8-cb5e-433b-af70-5f14a0c77aaa"],
Cell[CellGroupData[{
Cell[4349, 113, 428, 12, 32, "Input",ExpressionUUID->"f8ab6656-0d89-47fe-966d-8b6682e9bad2"],
Cell[4780, 127, 352, 8, 34, "Output",ExpressionUUID->"bcb00e8c-ca70-49df-9561-70f792af7ff9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5169, 140, 238, 4, 54, "Subsection",ExpressionUUID->"c1a93e4c-5da3-4811-92dd-def1767eaa68"],
Cell[CellGroupData[{
Cell[5432, 148, 1377, 32, 97, "Input",ExpressionUUID->"58c2d9b9-dc95-46c6-91ff-8b166d4a9309"],
Cell[6812, 182, 1239, 27, 58, "Output",ExpressionUUID->"648b0411-b653-486b-8e85-c3ef95a981d7"]
}, Open  ]],
Cell[8066, 212, 221, 4, 36, "Text",ExpressionUUID->"427e0aaf-7d44-47a8-a804-cee25eec8bd2"],
Cell[CellGroupData[{
Cell[8312, 220, 432, 12, 32, "Input",ExpressionUUID->"aebf5820-5801-4c4b-9edd-782ed407d846"],
Cell[8747, 234, 1102, 23, 36, "Output",ExpressionUUID->"814e0a29-787d-4e13-9b7d-465f33eea14c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9898, 263, 228, 4, 54, "Subsection",ExpressionUUID->"545ce957-b9e7-4c6a-a326-03b91d75f58b"],
Cell[CellGroupData[{
Cell[10151, 271, 603, 14, 32, "Input",ExpressionUUID->"b5895691-ba64-4701-949c-cfc681a3dead"],
Cell[10757, 287, 116430, 2116, 253, "Output",ExpressionUUID->"bcb87002-d30e-4565-8fef-f10746301d7c"]
}, Open  ]],
Cell[127202, 2406, 208, 2, 36, "Text",ExpressionUUID->"1c89b96b-1b26-4c07-972e-dfbfdfc7685c"],
Cell[127413, 2410, 919, 25, 55, "Input",ExpressionUUID->"0979cb3f-493c-4fd0-bb41-4cf0f914a47f"],
Cell[128335, 2437, 192, 2, 36, "Text",ExpressionUUID->"74f888b1-6e23-4c4c-abc9-5af1cd98f6cf"],
Cell[128530, 2441, 805, 23, 55, "Input",ExpressionUUID->"b7d03ec2-f9b0-455f-abb7-b54e6c69e281"],
Cell[129338, 2466, 514, 15, 32, "Input",ExpressionUUID->"8ec5b7fa-75bf-4022-8468-62531d9bf260"],
Cell[CellGroupData[{
Cell[129877, 2485, 654, 14, 32, "Input",ExpressionUUID->"af20592d-06e7-41e4-ba4c-4e1004033a85"],
Cell[130534, 2501, 1601, 37, 62, "Output",ExpressionUUID->"0358063f-be7c-46e6-8178-6634d43a721f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132172, 2543, 435, 10, 32, "Input",ExpressionUUID->"123c11d4-2cbb-4fd3-8e48-e060eb8dde8d"],
Cell[132610, 2555, 1542, 37, 62, "Output",ExpressionUUID->"e6caf2e1-e766-4ecc-b631-1e877b1283bd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[134189, 2597, 442, 11, 30, "Input",ExpressionUUID->"b856004e-3e56-4bd6-afee-00c85d25aafc"],
Cell[134634, 2610, 88542, 1673, 276, "Output",ExpressionUUID->"3b09fb01-9f88-4078-b779-30e6ceb7e480"]
}, Open  ]]
}, Open  ]]
}
]
*)

