(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    544235,       9812]
NotebookOptionsPosition[    540419,       9739]
NotebookOutlinePosition[    540816,       9755]
CellTagsIndexPosition[    540773,       9752]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Pade Approximant to Delay  (Section 3.6.4)", "Section",
 CellChangeTimes->{{3.7933252484828053`*^9, 3.793325262937768*^9}, {
  3.793848331380251*^9, 
  3.793848333427565*^9}},ExpressionUUID->"b616df30-29f2-42a9-b08a-\
c4a34f907035"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[2127]:=",ExpressionUUID->"9674331b-75cb-43d1-ba6d-7a222b949ae3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"G1", " ", "=", " ", 
  RowBox[{"PadeApproximant", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", "s"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5015920597598753`*^9, 3.501592062526567*^9}, {
  3.505308507984537*^9, 3.505308512963695*^9}, {3.505308704923073*^9, 
  3.5053087073871193`*^9}},
 CellLabel->
  "In[2128]:=",ExpressionUUID->"63df2661-e96e-4a53-9649-da7b563d3760"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   FractionBox["s", "2"]}], 
  RowBox[{"1", "+", 
   FractionBox["s", "2"]}]]], "Output",
 CellChangeTimes->{
  3.5015920635255947`*^9, 3.50530851430205*^9, 3.50530870779853*^9, {
   3.505308933835496*^9, 3.505308944372343*^9}, 3.505309170244028*^9, {
   3.505309646142844*^9, 3.5053097175844517`*^9}, 3.5053098456994*^9, 
   3.756405124978743*^9, 3.7564051974370737`*^9, 3.7564097214403343`*^9, 
   3.7933252686720963`*^9, 3.793848340755568*^9, 3.823227981761919*^9},
 CellLabel->
  "Out[2128]=",ExpressionUUID->"44bd381a-c016-4cd5-90bf-35230474ba0d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"G2", " ", "=", " ", 
  RowBox[{"PadeApproximant", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", "s"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "0", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.50159191287637*^9, 3.5015919143224297`*^9}, {
  3.5053084957109423`*^9, 3.505308502956938*^9}, {3.505308700137664*^9, 
  3.505308702106612*^9}},
 CellLabel->
  "In[2129]:=",ExpressionUUID->"b317103d-e808-476a-932e-ecdd52f71604"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   FractionBox["s", "2"], "+", 
   FractionBox[
    SuperscriptBox["s", "2"], "12"]}], 
  RowBox[{"1", "+", 
   FractionBox["s", "2"], "+", 
   FractionBox[
    SuperscriptBox["s", "2"], "12"]}]]], "Output",
 CellChangeTimes->{
  3.501591915586754*^9, 3.505308504286772*^9, 3.505308702463093*^9, {
   3.505308933802226*^9, 3.505308944335734*^9}, 3.505309170359742*^9, {
   3.5053096462417107`*^9, 3.505309717667935*^9}, 3.50530984579356*^9, 
   3.756405125344133*^9, 3.75640519756511*^9, 3.756409721591032*^9, 
   3.793325268682456*^9, 3.7938483407632236`*^9, 3.823227981767928*^9},
 CellLabel->
  "Out[2129]=",ExpressionUUID->"e3e593b1-0b18-4fb6-b7e4-b72d91582590"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"G3", " ", "=", 
  RowBox[{"PadeApproximant", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", "s"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "0", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.501591612860293*^9, 3.501591613913499*^9}, {
  3.505308487451579*^9, 3.505308491275786*^9}, {3.505308693491547*^9, 
  3.505308696772812*^9}},
 CellLabel->
  "In[2130]:=",ExpressionUUID->"486c7e81-923f-4b23-b68b-56b54f4a5e67"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   FractionBox["s", "2"], "+", 
   FractionBox[
    SuperscriptBox["s", "2"], "10"], "-", 
   FractionBox[
    SuperscriptBox["s", "3"], "120"]}], 
  RowBox[{"1", "+", 
   FractionBox["s", "2"], "+", 
   FractionBox[
    SuperscriptBox["s", "2"], "10"], "+", 
   FractionBox[
    SuperscriptBox["s", "3"], "120"]}]]], "Output",
 CellChangeTimes->{
  3.5015916148156347`*^9, 3.505308492276181*^9, 3.505308697213969*^9, {
   3.505308933718443*^9, 3.505308944252542*^9}, 3.5053091704332523`*^9, {
   3.5053096462764072`*^9, 3.505309717703684*^9}, 3.505309845828968*^9, 
   3.756405125458777*^9, 3.756405197654523*^9, 3.756409721724957*^9, 
   3.793325268738819*^9, 3.793848340806426*^9, 3.823227981773756*^9},
 CellLabel->
  "Out[2130]=",ExpressionUUID->"4aae4d76-3b73-4d0f-8f41-b1c83ac0b42a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BodePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"G1", ",", "G2", ",", "G3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.01", ",", "10000"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.501591885525587*^9, {3.501591920746064*^9, 3.501591927992085*^9}, {
   3.50159198162169*^9, 3.501591988825877*^9}, {3.5015920687751017`*^9, 
   3.501592074779377*^9}, {3.501592171444631*^9, 3.5015922096366997`*^9}, {
   3.50159228980013*^9, 3.5015922932493057`*^9}, {3.5015923580060673`*^9, 
   3.501592374626618*^9}, {3.505308522705633*^9, 3.505308530696135*^9}, {
   3.505308584982958*^9, 3.505308586225184*^9}, {3.505309179623913*^9, 
   3.5053091815023746`*^9}},
 CellLabel->
  "In[2131]:=",ExpressionUUID->"2df168ce-5e31-4578-af1c-9d452d2fcded"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], 
          LineBox[{{-1.9999998775510204`, -9.643274665532871*^-16}, \
{-1.998159692476642, 
           0.}, {-1.996319507402264, -9.643274665532871*^-16}, \
{-1.9944793223278858`, 0.}, {-1.9926391372535077`, 
           0.}, {-1.9907989521791296`, -1.9286549331065743`*^-15}, \
{-1.9889587671047513`, 0.}, {-1.9875786282989676`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.913051132786652, 
           1.4464911998299308`*^-15}, {-1.9116709939808683`, 
           0.}, {-1.8822280327908176`, 0.}, {-1.880731804173979, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.7602022767064167`, 
           1.4464911998299308`*^-15}, {-1.7585398004654849`, \
-9.643274665532871*^-16}, {-1.7565448289763665`, 
           0.}, {-1.7545498574872482`, -1.9286549331065743`*^-15}, \
{-1.7526870893793083`, 0.}, {-1.7508243212713683`, 0.}, {-1.7494272451904134`,
            1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQXX6xSPRy7K/9+8quJB/mu2UjOXmjilTEr/0MUDDn
1frHFQG/9mv6W7zViX+4R8Fp3aLrHjD+xT1LZq5JNHNEqNf4uEphqiWCv8Zj
5f3Phgj1+guWzwvSQsibzPFfd10JIW814/veGGmEvNsE97tpPAh+TMNz6ep3
P+H8jgT1mYs3IfiPFJZP/mKF4L+Q8V9cafwTbv5bie+b/mkj5H8IuF/ikEXw
//G8f9griuAzc07/KMSH4HOw2jPOYEPweZj+nvnN8BMefgAIDXvx
           "]], 
          LineBox[{{-1.531009424532211, 
           1.4464911998299308`*^-15}, {-1.5294114750391514`, \
-1.9286549331065743`*^-15}, {-1.5275852470470834`, -9.643274665532871*^-16}, \
{-1.5257590190550157`, -9.643274665532871*^-16}, {-1.5221065630708799`, \
-9.643274665532871*^-16}, {-1.518454107086744, -9.643274665532871*^-16}, \
{-1.5164730926799361`, 0.}, {-1.5144920782731282`, 
           0.}, {-1.5125110638663202`, -9.643274665532871*^-16}, \
{-1.5105300494595122`, 0.}, {-1.5085490350527042`, 
           0.}, {-1.5065680206458962`, -1.9286549331065743`*^-15}, \
{-1.5045870062390883`, 0.}, {-1.5031012454339823`, 
           1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQfTlA+t7jv9/27yu7knyY75bNPt4s91Pfvu3X9Ld4
qxP/cE/TnBcca9/B+Bf3uGmnn+p/9m0/AxSEpSVekDqG4Et9vT/x716E/nvN
ccEPtiLk0xZGX1u6FMEvuxN6x6AVwZ8W5PXCzQXB38d3x3OLDYL/9FTuakVT
BN/EeWLeH1UE/5LxjS8b2RH8X+8zw+QZEHzFNb+39/z4CucXqMhXp79E8Gc8
2HDnykME/8AcJzunW1/h/n8RcWX++ksIedZljCsZz36Fhx8AUO2Cnw==
           "]], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQ/cSnQKv83pf9+8quJB/mu2XDOGuu8ckbX/YzQIFG
mP5Us4sIfoDQwW+LTyL4C7qe7KzbheDbVWs7mMxB8NPM9y5cOOXLfk1/i7c6
8Q/39H72Y+bvRchvWf8gpaYVJn9xz53somMvaxHqWTRYNMLLEOq1n0ztPJKH
4ActUH9tmI7QXxWz02d+PIK/6vLv599lEfxbXnbNAXc+w/kHZi6bJn3lM9y8
ZS/4Vj07jeD3mJfv3XgYwS9qu3+hZvdnuPsirro/cd+MkLdT2fBdaDVC3j1z
9Yoniz/DwxcAshWcDA==
           "]], 
          LineBox[{{-1.1547990975221847`, 
           1.4464911998299308`*^-15}, {-1.153129432988543, \
-9.643274665532871*^-16}, {-1.1511258355481733`, -9.643274665532871*^-16}, \
{-1.1491222381078035`, 0.}, {-1.1471186406674336`, 
           0.}, {-1.145115043227064, -9.643274665532871*^-16}, \
{-1.1431479859025662`, 0.}, {-1.1411809285780685`, 0.}, {-1.1392138712535709`,
            0.}, {-1.1372468139290732`, 0.}, {-1.1357715209357, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.0443033553465582`, 
           1.4464911998299308`*^-15}, {-1.042828062353185, 
           0.}, {-1.0408610050286873`, 0.}, {-1.0388939477041896`, 
           0.}, {-1.0349598330551941`, 0.}, {-1.0329927757306963`, 
           0.}, {-1.0310257184061986`, 0.}, {-1.0270916037572033`, 
           0.}, {-1.0192233744592127`, 0.}, {-1.0173885205158935`, 
           0.}, {-1.015553666572574, 
           0.}, {-1.0137188126292545`, -1.9286549331065743`*^-15}, \
{-1.01211331542885, 1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQvXCLk6K+7av9+8quJB/mu2VzSW+3/Bu9V/s1/S3e
6sQ/3PNs6qbu+XIw/sU9P/+s/B7Eh+DzpCxMZvv3cj8DFCicnnF+51sE38Ro
gnXuXQTfY2b7coWzCH4MQ73wlT0IfkF6WX37mpdw81vO5b62moOQn26aGv6u
G8F/dtGJfY8Xgv/Lwqo43wrB511geF9J6yXcPwrsmt7XJJHcl6ewvZMTYZ/H
VXFl258vEO6z4e//8ALBL1jM9nvxjRdw85q5/qWFn3gB1x93RlpYYSdC/UFZ
oynb1r6Ahy8AmtuPXA==
           "]], 
          LineBox[{{-0.6718323461982714, 
           1.4464911998299308`*^-15}, {-0.6704392684656104, 
           0.}, {-0.6685818314887292, 0.}, {-0.666724394511848, 
           0.}, {-0.6630095205580855, 0.}, {-0.6611520835812043, 
           0.}, {-0.659294646604323, -1.9286549331065743`*^-15}, \
{-0.6574372096274417, 
           0.}, {-0.6555797726505604, -9.643274665532871*^-16}, \
{-0.6482961852065239, -9.643274665532871*^-16}, {-0.6410125977624874, \
-9.643274665532871*^-16}, {-0.6391917009014783, 0.}, {-0.6373708040404692, 
           0.}, {-0.6355499071794601, 0.}, {-0.633729010318451, 
           0.}, {-0.6319081134574418, 0.}, {-0.630542440811685, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.5731841896898979, 
           1.4464911998299308`*^-15}, {-0.5718185170441411, 
           0.}, {-0.569997620183132, 0.}, {-0.5681767233221229, 
           0.}, {-0.539042373545977, 0.}, {-0.5370666902702277, 
           0.}, {-0.5350910069944785, 0.}, {-0.53113964044298, 
           0.}, {-0.5232369073399832, 0.}, {-0.5217551448831713, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.34761597761440044`, 
           1.4464911998299308`*^-15}, {-0.34623336769347224`, 
           0.}, {-0.3443898877989013, -9.643274665532871*^-16}, \
{-0.34254640790433033`, 0.}, {-0.3407029280097594, 
           0.}, {-0.3388594481151884, -9.643274665532871*^-16}, \
{-0.33701596822061747`, -9.643274665532871*^-16}, {-0.3351724883260465, 
           0.}, {-0.33332900843147556`, 0.}, {-0.3314855285369046, 
           0.}, {-0.32964204864233365`, 0.}, {-0.3277985687477627, 
           0.}, {-0.32411160895862073`, 0.}, {-0.2946159306454854, 
           0.}, {-0.29261766433617437`, 
           0.}, {-0.2906193980268633, -9.643274665532871*^-16}, \
{-0.2889541761024374, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.20019784753053765`, 
           1.4464911998299308`*^-15}, {-0.19869914779855435`, 
           0.}, {-0.1967008814892433, -9.643274665532871*^-16}, \
{-0.19470261517993223`, -9.643274665532871*^-16}, {-0.19270434887062116`, 
           0.}, {-0.1907060825613101, -9.643274665532871*^-16}, \
{-0.18870781625199906`, 0.}, {-0.18670954994268799`, 
           
           0.}, {-0.1847112836333769, -9.643274665532871*^-16}, \
{-0.18271301732406586`, 0.}, {-0.16672688684957734`, 
           0.}, {-0.041176410469486245`, 0.}, {-0.03934688765722559, 
           0.}, {-0.03751736484496493, 0.}, {-0.033858319220443606`, 
           0.}, {-0.032028796408182944`, 0.}, {-0.030656654298987448`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.0031895177278347744`, 1.4464911998299308`*^-15}, {
           0.004561659837030271, 0.}, {0.0063911826492909305`, 0.}, {
           0.00822070546155159, -9.643274665532871*^-16}, {
           0.010050228273812252`, -9.643274665532871*^-16}, {
           0.013709273898333573`, -9.643274665532871*^-16}, {
           0.017368319522854895`, -9.643274665532871*^-16}, {
           0.04664068451902546, -9.643274665532871*^-16}, {
           0.07591304951519603, -9.643274665532871*^-16}, {0.0778973587421968,
            0.}, {0.07988166796919757, 0.}, {0.08136989988944815, 
           1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQBmIQbXjrBkuQ4gH7fWVXkg/z3bKpyek3Ews6YM8ABQ9a
dM9JTz5gr+lv8VYn/uIel7mnUxWvwPgP96zYmvlXTfQgXD3POfapOmEIfsGz
pTpG0xH8y/+cj5jfQPDNxB9F20oegvNn6Td8dopC8JMS9ij53UHwj1VE7QqW
PQzna038ERgZh+D3rZz2Mm4+gv/poEljyoPDcPeG3bokkaV4BO6fXZ8KNuQn
HYGrl+Pm9yhdjOA3Ka+9X/UEwX9m7V3eoHoUzvcKecnXlobgC7aq2k18geD7
c7PvePXjJJw/bQe3/2zTU3D+vVSBZ95FCH7eAUmRta8R/J5SnYL8e6fh/CtK
huwK0mfgfOkLpvMuhCP4q7TszxheRPA/XXdOfsR7Fu5fy1aPX5O8zsLlG4x8
Jzq3I/gn7gdqfDmMUN9y9GpA+7ez8PQBAEytp9g=
           "]], 
          LineBox[{{0.31982302156079057`, 1.4464911998299308`*^-15}, {
           0.32144361417588524`, -1.9286549331065743`*^-15}, {
           0.3231996449038775, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.4461217958633373, 1.4464911998299308`*^-15}, {
           0.4478778265913296, -1.9286549331065743`*^-15}, {
           0.44988471885189213`, -9.643274665532871*^-16}, {
           0.4518550709965826, 0.}, {0.45382542314127305`, 0.}, {
           0.4553031872497909, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.5467603659658401, 1.4464911998299308`*^-15}, {
           0.5484023260864155, -9.643274665532871*^-16}, {0.550372678231106, 
           0.}, {0.5523430303757965, -1.9286549331065743`*^-15}, {
           0.5543133825204869, -9.643274665532871*^-16}, {0.5562837346651774, 
           0.}, {0.5582540868098679, 0.}, {0.5602244389545583, 0.}, {
           0.5621947910992487, 0.}, {0.5641651432439392, 0.}, {
           0.5681058475333202, 0.}, {0.575987256112082, 0.}, {
           0.5778254048755942, -9.643274665532871*^-16}, {0.5796635536391064, 
           0.}, {0.5815017024026186, 0.}, {
           0.5833398511661309, -9.643274665532871*^-16}, {
           0.5851779999296431, -9.643274665532871*^-16}, {0.5867097905659033, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.6167328870366027, 1.4464911998299308`*^-15}, {
           0.6182646776728629, -9.643274665532871*^-16}, {0.620102826436375, 
           0.}, {0.6219409751998872, -9.643274665532871*^-16}, {
           0.6237791239633994, 0.}, {0.6256172727269116, 0.}, {
           0.6274554214904238, -9.643274665532871*^-16}, {0.629293570253936, 
           0.}, {0.6311317190174481, -9.643274665532871*^-16}, {
           0.6329698677809603, 0.}, {0.6348080165444726, 0.}, {
           0.6936287769768632, 0.}, {0.6956217121551155, 0.}, {
           0.6976146473333678, 0.}, {
           0.6996075825116201, -9.643274665532871*^-16}, {0.7012683618268304, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.8137031214665649, 1.4464911998299308`*^-15}, {
           0.8151978228502541, 0.}, {0.8171907580285065, 0.}, {
           0.8191836932067588, -9.643274665532871*^-16}, {
           0.821176628385011, -9.643274665532871*^-16}, {0.8230373601820851, 
           0.}, {0.8248980919791591, -9.643274665532871*^-16}, {
           0.8267588237762331, 0.}, {0.8286195555733072, 0.}, {
           0.8304802873703814, -9.643274665532871*^-16}, {0.8320308972012764, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.938712853566855, 1.4464911998299308`*^-15}, {
           0.9402634633977501, -9.643274665532871*^-16}, {0.9420876550789521, 
           0.}, {0.9439118467601539, 0.}, {
           0.9457360384413559, -9.643274665532871*^-16}, {
           0.9475602301225579, -9.643274665532871*^-16}, {0.9493844218037597, 
           0.}, {0.9512086134849617, 0.}, {0.9530328051661636, 0.}, {
           0.9548569968473655, 0.}, {0.9562251406082669, 
           1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQHewvzlWv8cF+X9mV5MN8t2x+nrvDtVPvg72mv8Vb
nfiLe6JmT7thaPbBngEKdqcHLFtli+DLmHCVKLsi+PfP1PKLhiD4Kf9S3H4U
IvhHT8mJFFYi+GrTbzx82YCwryN50vqkDgT/pb5P7e1+hPq8ROMt+9Yi+JVH
GJVaXyK5598T2wUfEfx95icid/9EmJdYuLr0GuNHOJ9ldd/Ej5wf4eonTJRm
jNNC8I1P/5OpNEKov8byyGKKFYJfYXc0ZL0TQr10xYqCU14IfujjSUfvBXyE
hy8ASA2CNg==
           "]], 
          LineBox[{{1.182017180721676, 1.4464911998299308`*^-15}, {
           1.183666329134961, -9.643274665532871*^-16}, {1.1855131038497246`, 
           0.}, {1.1868981848857976`, 1.4464911998299308`*^-15}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQra/K+qyy87P9vrIryYf5btnE6T10Uuv/bM8ABfOs
Nu7bNg3Bv+vWaOU+77O9pr/FW534i3tkggO3XV+KkBfbenFK9CMEP/TgQoE3
LxH8KWcLe2o+IvRfuenIwfsTwRd+Jtgyl+ELXL2AeFDxfTkEn6vyUmByNIL/
z+YyX/YVBL9+25kbc+98gZvHYHBs0YUnCH7Dyv05zG8R6hmVd5qZfUXwm+Zs
Ysj8C1P/cA+T2JpTs1m/wuWb+5dOOceL4C9ZpbDmi/BXePgBAGXZeDg=
           "]], 
          LineBox[{{1.404439918766913, 1.4464911998299308`*^-15}, {
           1.405941089614041, 0.}, {1.4139473341320565`, 0.}, {
           1.4299598231680872`, 0.}, {1.5557211680405167`, 0.}, {
           1.6730214965175376`, 0.}, {
           1.6750091005647312`, -9.643274665532871*^-16}, {
           1.6769967046119247`, -9.643274665532871*^-16}, {
           1.6789843086591183`, 0.}, {1.6809719127063119`, 0.}, {
           1.688922328895086, 0.}, {1.7048231612726346`, 0.}, {
           1.7366248260277315`, 0.}, {1.7381155290631267`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.9064498436673007`, 1.4464911998299308`*^-15}, {
           1.9078413941668122`, 0.}, {1.9096967948328274`, 0.}, {
           1.9115521954988428`, -9.643274665532871*^-16}, {1.913407596164858, 
           0.}, {1.9152629968308732`, 0.}, {1.9171183974968886`, 0.}, {
           1.9189737981629038`, 0.}, {
           1.9207926587130468`, -9.643274665532871*^-16}, {1.92261151926319, 
           0.}, {1.9244303798133333`, 0.}, {
           1.9262492403634766`, -9.643274665532871*^-16}, {
           1.9280681009136198`, 0.}, {1.929432246326227, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.034016727959458, 1.4464911998299308`*^-15}, {
           2.0353808733720653`, 0.}, {2.0373545203369483`, 0.}, {
           2.0393281673018318`, -9.643274665532871*^-16}, {
           2.041301814266715, -1.9286549331065743`*^-15}, {2.043028755360988, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.2726412550428203`, 1.4464911998299308`*^-15}, {
           2.274022337730599, 0.}, {
           2.275863781314304, -1.9286549331065743`*^-15}, {
           2.2777052248980088`, 0.}, {2.279546668481714, 0.}, {
           2.2815428984801587`, 0.}, {
           2.283539128478604, -9.643274665532871*^-16}, {2.2855353584770493`, 
           0.}, {2.287032530975883, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.395827065891141, 1.4464911998299308`*^-15}, {
           2.3973242383899747`, 0.}, {2.39932046838842, 0.}, {
           2.4013166983868652`, -1.9286549331065743`*^-15}, {2.40331292838531,
            0.}, {2.405309158383755, 0.}, {
           2.4073053883822, -9.643274665532871*^-16}, {2.409169414999467, 
           0.}, {2.411033441616734, 0.}, {2.412897468234001, 0.}, {
           2.414295488196951, 1.4464911998299308`*^-15}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQPc+3yu08K4vDvrIryYf5btksKuuyXcPB4sAABX/C
v7bV8iD4YZYJF/wEWBw0/S3e6sRf3LNB6rSkgghCnuuPafJHcYR8yt0Faw5J
I+T37eP+NlkewZdYUGafqozgFzY+7DBTR/BPJflcYtdG8FVctkvf1EPwb7D1
rqs2Q/A/ii4+b2mF5B7VnR++2yL4Ns5PjUpcEfzQoN/BRp4Ifl6iYOkHH4T7
2wrUp60LQMjf/P1drzYYEV4AhvRQcQ==
           "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQB2IQ/ddwM/v1+ywO+8quJB/mu2UTsLd5wdJHLA4MUJB5
ZubB5GcsDpr+Fm914i/uabq9/pHiK4T87FdHmR+8RfC3/LytMu8jgn+W45Nr
zFcE/5k4R7rUT4R5/9XkOm78QfAlzExWTmNghfMNXb1OhbAg+F4hCa+FOFjh
5gmeFfjCrIbgn5pkbSOsheC3RKS1KOkh+HZyE88YGiHM+/F4t4ijGYK/aeWz
mAArhPrsfMGl8XYIvoqpzds8J4T6e7/STOvcEPwZBybW9noh1Ae17Tk6xw/B
5/F5zrsmCKH+qKBQ2O4whHzddZt5p6IQfIu56c9uxsHUP9zzKWmS3sskhP41
GnvLfqQh1Ke9e76PPRvB38jEYSqcxwqPXwD8IJl7
           "]], 
          LineBox[{{2.7648112546801173`, 1.4464911998299308`*^-15}, {
           2.7664631487768965`, -9.643274665532871*^-16}, {
           2.7684454216930314`, -9.643274665532871*^-16}, {
           2.7704276946091664`, -9.643274665532871*^-16}, {
           2.7852282508888186`, -9.643274665532871*^-16}, {
           2.800028807168471, -9.643274665532871*^-16}, {2.8018788767034275`, 
           0.}, {2.803728946238384, 0.}, {
           2.8055790157733407`, -9.643274665532871*^-16}, {
           2.8074290853082973`, 0.}, {2.809279154843254, 0.}, {
           2.8111292243782104`, -9.643274665532871*^-16}, {2.812979293913167, 
           0.}, {2.814829363448123, 0.}, {
           2.8166794329830793`, -9.643274665532871*^-16}, {2.818221157595543, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.887444592695168, 1.4464911998299308`*^-15}, {
           2.888832144846385, 0.}, {2.8908370007960817`, 0.}, {
           2.892340642758354, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.135733954614897, 1.4464911998299308`*^-15}, {
           3.137210191490265, 0.}, {3.1391785073240897`, 0.}, {
           3.1411468231579143`, 0.}, {3.143115138991739, 0.}, {
           3.144492223331224, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.2590962422505596`, 1.4464911998299308`*^-15}, {
           3.2606263359610983`, -9.643274665532871*^-16}, {
           3.29248071783928, -9.643274665532871*^-16}, {
           3.3243350997174614`, -9.643274665532871*^-16}, {
           3.3402622906565522`, -9.643274665532871*^-16}, {
           3.356189481595643, -9.643274665532871*^-16}, {3.3581803804630295`, 
           0.}, {3.360171279330416, 0.}, {3.362162178197802, 0.}, {
           3.3641530770651884`, -9.643274665532871*^-16}, {
           3.366143975932575, -9.643274665532871*^-16}, {
           3.368134874799961, -9.643274665532871*^-16}, {3.3701257736673473`, 
           0.}, {3.372116672534734, 0.}, {3.3736098466852735`, 
           1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQbdnSVJnDze2wr+xK8mG+Wza7Vn0OrubjdmCAAoF7
9xX7hRD8dMEz7xeJIfj7XHbs3SaF4Cc/nGXdKsftoOlv8VYn/uIejrrancFK
CPmg7U5bP2gi+N+DVY336yL4cz6wb+w1RPAde1/pxZgizHumeXaNliWC331s
vdZPG4R6g+RJK447IPhX/5eoTXOBqX+4p2pO+JIUD4R+eUsrJWMfBP/IVZkF
jAEI/ZlF/2UvBCPk+fgfzZ4XjpCPu8ld1TYFwWcue/c9ZAZC/Qqhi6XKcxDy
KhzWIf/mIcIbAEgvcTU=
           "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQrbrk1ZJodh6HfWVXkg/z3bKJuFizo52Lx0HT3+Kt
TvzFPX9z483C+BD8+l0SLw60IviM7Jdmav9F8Lk4xSe7sPLC+SLcMT2xvAi+
ZM8/jixBBF+Od2FrmSivAwMUKPc5MzVLIvga/M/q+mURfN0JHb9nKyL4RoLa
FStUEeaZTTr7ZYsmgm8tXFB4UBeh3mGK0Luzhgi+i+jWrFumCPWe08KfP7NE
yPOWX3T5YMMLDx8Ai8ljKg==
           "]], 
          LineBox[{{3.734821293703171, 1.4464911998299308`*^-15}, {
           3.736304000041978, 0.}, {
           3.738280941827054, -9.643274665532871*^-16}, {3.74025788361213, 
           0.}, {3.742234825397206, 0.}, {3.744211767182282, 0.}, {
           3.746188708967358, 0.}, {3.75014259253751, 0.}, {3.751987330941408,
            0.}, {3.7538320693453056`, 0.}, {3.757521546153101, 0.}, {
           3.764900499768692, 0.}, {3.7796584069998747`, 0.}, {
           3.8091742214622393`, 0.}, {3.8682058503869685`, 0.}, {
           3.870265132061407, -9.643274665532871*^-16}, {3.872324413735845, 
           0.}, {3.8738688749916736`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.957215574571728, 
           1.4464911998299308`*^-15}, {-1.9558354357659442`, 
           0.}, {-1.941113955170919, 
           0.}, {-1.9392737700965408`, -1.9286549331065743`*^-15}, \
{-1.93766360815646, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.8677644894947103`, 
           1.4464911998299308`*^-15}, {-1.8662682608778716`, 
           0.}, {-1.8503084889649253`, 0.}, {-1.818388945139033, 
           0.}, {-1.8163939736499146`, 
           0.}, {-1.8143990021607963`, -9.643274665532871*^-16}, \
{-1.812404030671678, -1.9286549331065743`*^-15}, {-1.81040905918256, 
           0.}, {-1.8084140876934418`, -9.643274665532871*^-16}, \
{-1.8064191162043235`, 0.}, {-1.8049228875874848`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.7056521946538232`, 
           1.4464911998299308`*^-15}, {-1.7042551185728683`, 
           0.}, {-1.702392350464928, 0.}, {-1.700529582356988, 
           0.}, {-1.698666814249048, 0.}, {-1.694941278033168, 
           0.}, {-1.6930785099252281`, 
           0.}, {-1.6912157418172882`, -9.643274665532871*^-16}, \
{-1.6893529737093482`, 0.}, {-1.687490205601408, 0.}, {-1.680039133169648, 
           0.}, {-1.678642057088693, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.4607570624884618`, 
           1.4464911998299308`*^-15}, {-1.4590236748825047`, \
-1.9286549331065743`*^-15}, {-1.4570426604756967`, -9.643274665532871*^-16}, \
{-1.455061646068889, -9.643274665532871*^-16}, {-1.4530806316620812`, 
           0.}, {-1.4510996172552733`, -9.643274665532871*^-16}, \
{-1.4491186028484653`, 0.}, {-1.4476328420433593`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.0836445018365115`, 
           1.4464911998299308`*^-15}, {-1.0821692088431383`, 
           0.}, {-1.080693915849765, 1.4464911998299308`*^-15}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQfdTx+uaEL+/37yu7knyY75bNt098u6Revt/PAAW9
JpGHhG6936/pb/FWJ/7hHpWyxae4TiPkA3+a3/61BsF/YdX0+NNcmPqLe+pq
zrx+1YeQX/M/4c+tAgTf2XE1y+VEBP9W01ee00EI/YVH7EUPOyPkOdi6ZHeb
IOTnu19R3ayK4Jt1yumtFkOoP3Mqw2wxO0I+mWez3ewf7+Dyv3z/uk1++Q4u
P6Hf3b/7FkJe/eLE8ObTCPl9Qnfiq/cg+IJfJPd8Wf8OHn4ABdOSVg==
           "]], 
          LineBox[{{-0.8455853819715887, 
           1.4464911998299308`*^-15}, {-0.8440931517030441, 
           0.}, {-0.8421035113449846, 
           0.}, {-0.8401138709869251, -9.643274665532871*^-16}, \
{-0.8381242306288655, 
           0.}, {-0.8361345902708059, -9.643274665532871*^-16}, \
{-0.8341449499127465, 0.}, {-0.8301656691966275, 0.}, {-0.828176028838568, 
           0.}, {-0.8261863884805084, 0.}, {-0.8241967481224488, 
           0.}, {-0.8222071077643893, -9.643274665532871*^-16}, \
{-0.8205490741326731, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7164108336434216, 
           1.4464911998299308`*^-15}, {-0.7150177559107607, 
           0.}, {-0.7131603189338794, 0.}, {-0.7113028819569982, 
           0.}, {-0.7075880080032356, 
           0.}, {-0.7057305710263544, -1.9286549331065743`*^-15}, \
{-0.703873134049473, 0.}, {-0.7024800563168121, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.5986767457440256, 
           1.4464911998299308`*^-15}, {-0.5973110730982687, 
           0.}, {-0.5954901762372595, 0.}, {-0.5936692793762505, 
           0.}, {-0.5900274856542322, 0.}, {-0.5882065887932231, 
           0.}, {-0.586385691932214, 0.}, {-0.584564795071205, 
           0.}, {-0.583199122425448, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.39923341466238726`, 
           1.4464911998299308`*^-15}, {-0.39785080474145906`, 
           0.}, {-0.3960073248468881, -9.643274665532871*^-16}, \
{-0.39416384495231716`, -9.643274665532871*^-16}, {-0.3923203650577462, 
           0.}, {-0.39047688516317525`, 0.}, {-0.38310296558489143`, 
           0.}, {-0.3812594856903205, -9.643274665532871*^-16}, \
{-0.3794160057957495, 0.}, {-0.3757290460066076, 0.}, {-0.36835512642832374`, 
           0.}, {-0.35360728727175605`, 0.}, {-0.3517638073771851, 
           0.}, {-0.3503811974562569, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.23416837478882574`, 
           1.4464911998299308`*^-15}, {-0.23266967505684244`, 
           0.}, {-0.2306714087475314, -9.643274665532871*^-16}, \
{-0.22867314243822034`, -9.643274665532871*^-16}, {-0.22667487612890927`, 
           0.}, {-0.2246766098195982, -9.643274665532871*^-16}, \
{-0.22301138789517233`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.24041398342115072`, 1.4464911998299308`*^-15}, {
           0.2418030628055176, 0.}, {0.2436551686513401, 0.}, {
           0.2455072744971626, -9.643274665532871*^-16}, {0.2473593803429851, 
           0.}, {0.24921148618880762`, 0.}, {0.25106359203463013`, 0.}, {
           0.2547678037262751, 0.}, {0.2621762271095651, 0.}, {
           0.26402833295538763`, -9.643274665532871*^-16}, {
           0.26588043880121015`, -9.643274665532871*^-16}, {
           0.26773254464703267`, 0.}, {
           0.2695846504928551, -1.9286549331065743`*^-15}, {
           0.2714367563386776, 0.}, {0.2728258357230445, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.3599090491700019, 1.4464911998299308`*^-15}, {
           0.36158145938713737`, -9.643274665532871*^-16}, {0.3635883516477, 
           0.}, {0.3655952439082626, -9.643274665532871*^-16}, {
           0.3676021361688252, -1.9286549331065743`*^-15}, {
           0.3696090284293878, 0.}, {
           0.3716159206899504, -9.643274665532871*^-16}, {
           0.37362281295051303`, -1.9286549331065743`*^-15}, {
           0.37562970521107564`, -1.9286549331065743`*^-15}, {
           0.37763659747163825`, 0.}, {
           0.37964348973220086`, -9.643274665532871*^-16}, {
           0.38165038199276347`, 0.}, {
           0.3836572742533261, -1.9286549331065743`*^-15}, {
           0.3856641665138887, -1.9286549331065743`*^-15}, {
           0.3876710587744513, -9.643274665532871*^-16}, {0.3896779510350139, 
           0.}, {0.3916848432955765, 0.}, {0.3931900124909985, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.5075175190840883, 1.4464911998299308`*^-15}, {
           0.5089952831926061, 0.}, {0.5129359874819871, 0.}, {
           0.5149063396266775, 0.}, {0.5168766917713681, 0.}, {
           0.520817396060749, 0.}, {0.5286988046395109, 0.}, {
           0.5306691567842013, 0.}, {0.5326395089288918, 0.}, {
           0.5365802132182728, 0.}, {
           0.5385505653629632, -9.643274665532871*^-16}, {0.5405209175076537, 
           0.}, {0.5424912696523442, 0.}, {
           0.5444616217970346, -9.643274665532871*^-16}, {0.54610358191761, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.7020987514844355, 1.4464911998299308`*^-15}, {
           0.7035934528681247, 0.}, {
           0.7055863880463771, -9.643274665532871*^-16}, {0.7075793232246294, 
           0.}, {0.7095722584028816, 0.}, {0.7255157398289002, 0.}, {
           0.7574027026809371, 0.}, {0.7593956378591894, 0.}, {
           0.7613885730374417, 0.}, {0.7633815082156941, 0.}, {
           0.7653744433939463, -9.643274665532871*^-16}, {0.7673673785721986, 
           0.}, {0.769360313750451, -9.643274665532871*^-16}, {
           0.7710210930656612, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.8680050452780412, 1.4464911998299308`*^-15}, {
           0.8695556551089363, -9.643274665532871*^-16}, {0.8714163869060103, 
           0.}, {0.8732771187030844, 0.}, {0.8807200458913806, 0.}, {
           0.8825807776884547, 0.}, {
           0.8844415094855287, -1.9286549331065743`*^-15}, {
           0.8863022412826027, 0.}, {
           0.8881629730796768, -9.643274665532871*^-16}, {
           0.890023704876751, -9.643274665532871*^-16}, {0.891884436673825, 
           0.}, {0.8932799855216306, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.9952932457806744, 1.4464911998299308`*^-15}, {
           0.9968134055150093, -9.643274665532871*^-16}, {
           0.9986375971962111, -9.643274665532871*^-16}, {1.000461788877413, 
           0.}, {1.0022859805586148`, 0.}, {1.004110172239817, 0.}, {
           1.0059343639210188`, -1.9286549331065743`*^-15}, {
           1.0077585556022206`, -9.643274665532871*^-16}, {
           1.0092787153365557`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.1048370349799375`, 1.4464911998299308`*^-15}, {
           1.1064861833932225`, -9.643274665532871*^-16}, {
           1.1084651614891645`, -9.643274665532871*^-16}, {
           1.1104441395851066`, 0.}, {1.1124231176810486`, 0.}, {
           1.1144020957769907`, 0.}, {1.1163810738729327`, 0.}, {
           1.1183600519688746`, 0.}, {
           1.1203390300648166`, -9.643274665532871*^-16}, {
           1.1223180081607587`, 0.}, {1.1242969862567005`, 0.}, {
           1.1262759643526425`, 0.}, {
           1.1282549424485846`, -9.643274665532871*^-16}, {
           1.1302339205445266`, 0.}, {1.1317181541164831`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.3402231658619979`, 1.4464911998299308`*^-15}, {
           1.3418911334699177`, -9.643274665532871*^-16}, {
           1.3458942557289255`, -9.643274665532871*^-16}, {
           1.3498973779879333`, -9.643274665532871*^-16}, {
           1.3579036225059486`, -9.643274665532871*^-16}, {
           1.365909867023964, -9.643274665532871*^-16}, {1.367911428153468, 
           0.}, {1.3699129892829718`, -9.643274665532871*^-16}, {
           1.3715809568908914`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.043604402392412, 1.4464911998299308`*^-15}, {
           2.045249108196481, -9.643274665532871*^-16}, {2.0472227551613646`, 
           0.}, {2.049196402126248, -9.643274665532871*^-16}, {
           2.051170049091131, 0.}, {2.0669592248101973`, 0.}, {
           2.0985375762483294`, 0.}, {2.1005112232132124`, 0.}, {
           2.102484870178096, 0.}, {2.1044585171429793`, 0.}, {
           2.1064321641078623`, -9.643274665532871*^-16}, {2.108076869911932, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.2080372759811695`, 1.4464911998299308`*^-15}, {
           2.209571812300924, -9.643274665532871*^-16}, {2.211413255884629, 
           0.}, {2.213254699468334, -9.643274665532871*^-16}, {
           2.215096143052039, -1.9286549331065743`*^-15}, {2.216937586635744, 
           0.}, {2.2187790302194488`, -9.643274665532871*^-16}, {
           2.220620473803154, -9.643274665532871*^-16}, {
           2.2243033609705636`, -9.643274665532871*^-16}, {
           2.2279862481379737`, -9.643274665532871*^-16}, {
           2.229827691721679, -9.643274665532871*^-16}, {2.231362228041433, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.288030645975106, 1.4464911998299308`*^-15}, {
           2.28952781847394, 0.}, {
           2.2915240484723847`, -9.643274665532871*^-16}, {
           2.2935202784708295`, -9.643274665532871*^-16}, {2.295516508469275, 
           0.}, {2.3114863484568353`, 0.}, {2.3434260284319572`, 0.}, {
           2.3454222584304025`, 0.}, {2.3474184884288474`, 0.}, {
           2.3514109484257375`, 0.}, {2.3593958684195178`, 0.}, {
           2.361392098417963, 0.}, {2.363388328416408, 0.}, {
           2.3653845584148527`, -9.643274665532871*^-16}, {
           2.367380788413298, -1.9286549331065743`*^-15}, {2.369127489661938, 
           1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQvWQ3+6r+CmaHfWVXkg/z3bJZ8UR8YU41swMDFDAe
a3plW8/soOlv8VYn/uGeqOVvjfmbYfyLe7Z0RNQ+aEPI82UdPraxCyGf4a0n
0NyHMO+QzszIkEkIeRk+lsWq0xDyFy7cND0xF8HX2uRSP3MhQn3L5PUnspYi
5O+VSAnZrETwzcNao3nXItRPMP+w5N4GhPwrieh367cg+C6/jpo37kDw5902
aAzag+D/2DP7lPIBBD9oHpvI18MI/pr6wthjxxF81sQ7y6afRtivWrSV79g5
RPgCAFZQdPI=
           "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3WK773TfFDaHfWVXkg/z3bJJ6G+R2j6dzUHT3+Kt
TvzFPRn7lgo1zmZzYICCgrfHuLznI/gVMi+YRBcj+A3enL/vLUPo76jS+rxi
FUJ+xo2cxzabEPztUz4eTjmI4O87LLRH7yiCf+yT8ZYfJxD8awFlS3ouIPj3
6qfPCbuCsO/Zuh1TFG4g+O/u3ux5dRuh/hvP75Yt9xHy/6xlauseI+TZsm1L
PZ4j+Hyz4nKFXiP4YifrU++8Q/DlfiyIXfYJYZ6a+qHQgm8Ivl7YY1+rXwj1
Zq0sbiz/EHy7Lap25xjZ4eql2N70fGNhh8cHAIjzg8g=
           "]], 
          LineBox[{{2.901362494531989, 1.4464911998299308`*^-15}, {
           2.9028661364942616`, 0.}, {2.904870992443958, 0.}, {
           2.9209098400415314`, 0.}, {2.9529875352366775`, 0.}, {
           2.9549923911863742`, -9.643274665532871*^-16}, {
           2.9566631044777885`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.06290626876339, 1.4464911998299308`*^-15}, {
           3.0643825056387586`, 0.}, {3.0801290323093546`, 0.}, {
           3.0820973481431793`, -9.643274665532871*^-16}, {
           3.084065663977004, -1.9286549331065743`*^-15}, {
           3.0860339798108285`, 0.}, {3.0880022956446527`, 0.}, {
           3.089970611478477, 0.}, {3.0919389273123015`, 0.}, {
           3.093907243146126, -1.9286549331065743`*^-15}, {
           3.0956295195007226`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.1968214282316416`, 1.4464911998299308`*^-15}, {
           3.1981985125711265`, 0.}, {3.2018707374764186`, 0.}, {
           3.2037068499290644`, 0.}, {3.2055429623817107`, 0.}, {
           3.207379074834357, -9.643274665532871*^-16}, {
           3.209215187287003, -9.643274665532871*^-16}, {
           3.2110512997396494`, -9.643274665532871*^-16}, {3.212581393450188, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.685233003927513, 1.4464911998299308`*^-15}, {
           3.6868804554150767`, -9.643274665532871*^-16}, {
           3.6947882225553808`, -9.643274665532871*^-16}, {
           3.702695989695685, -9.643274665532871*^-16}, {3.704672931480761, 
           0.}, {3.706649873265837, 0.}, {3.708626815050913, 0.}, {
           3.7101095213897204`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.928268232558086, 1.4464911998299308`*^-15}, {
           3.929984300620118, -9.643274665532871*^-16}, {
           3.932043582294556, -9.643274665532871*^-16}, {
           3.9341028639689943`, -9.643274665532871*^-16}, {3.936162145643433, 
           0.}, {3.9377066068992614`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.9719370551667532`, 
           1.4464911998299308`*^-15}, {-1.9705569163609695`, 
           0.}, {-1.9687167312865914`, 0.}, {-1.9673365924808077`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.7262978745168247`, 
           1.4464911998299308`*^-15}, {-1.7247455677602082`, \
-9.643274665532871*^-16}, {-1.7228827996522682`, 
           0.}, {-1.7210200315443283`, -9.643274665532871*^-16}, \
{-1.7194677247877117`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.4923707507304391`, 
           1.4464911998299308`*^-15}, {-1.4907199053914324`, \
-9.643274665532871*^-16}, {-1.4887388909846244`, 0.}, {-1.4867578765778164`, 
           0.}, {-1.4847768621710085`, 
           0.}, {-1.4827958477642005`, -9.643274665532871*^-16}, \
{-1.4808148333573925`, 0.}, {-1.4788338189505845`, 
           0.}, {-1.4768528045437765`, -9.643274665532871*^-16}, \
{-1.4748717901369686`, -9.643274665532871*^-16}, {-1.4728907757301606`, 
           0.}, {-1.4709097613233526`, -9.643274665532871*^-16}, \
{-1.4689287469165446`, -9.643274665532871*^-16}, {-1.467277901577538, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.117084476352972, 
           1.4464911998299308`*^-15}, {-1.1156091833595987`, 
           0.}, {-1.113642126035101, 0.}, {-1.1116750687106034`, 
           0.}, {-1.1097080113861058`, -1.9286549331065743`*^-15}, \
{-1.107740954061608, 
           0.}, {-1.1057738967371105`, -9.643274665532871*^-16}, \
{-1.1038068394126128`, 
           0.}, {-1.1018397820881152`, -9.643274665532871*^-16}, \
{-1.0998727247636175`, -9.643274665532871*^-16}, {-1.098233510326536, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8716165099895341, 
           1.4464911998299308`*^-15}, {-0.8699584763578179, \
-9.643274665532871*^-16}, {-0.8679688359997584, 0.}, {-0.8659791956416989, 
           0.}, {-0.8639895552836394, 0.}, {-0.8624973250150947, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.6296319923811805, 
           1.4464911998299308`*^-15}, {-0.6282663197354237, 
           0.}, {-0.6264454228744145, 0.}, {-0.6246245260134053, 
           0.}, {-0.6228036291523963, 
           0.}, {-0.6212862151015555, -2.410818666383218*^-15}}], 
          LineBox[{{-0.5207673032452967, 
           1.4464911998299308`*^-15}, {-0.5192855407884848, 
           0.}, {-0.5153341742369864, 
           0.}, {-0.5133584909612371, -9.643274665532871*^-16}, \
{-0.5113828076854878, 0.}, {-0.5094071244097387, 
           0.}, {-0.5074314411339894, -9.643274665532871*^-16}, \
{-0.5057850384041983, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.28828808733266703`, 
           1.4464911998299308`*^-15}, {-0.28662286540824117`, \
-9.643274665532871*^-16}, {-0.2846245990989301, -9.643274665532871*^-16}, \
{-0.282626332789619, 0.}, {-0.28062806648030797`, 0.}, {-0.2786298001709969, 
           0.}, {-0.26264366969650843`, 0.}, {-0.2606454033871974, 
           0.}, {-0.2591467036552141, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.02623530750269085, 
           1.4464911998299308`*^-15}, {-0.024710705159140298`, \
-9.643274665532871*^-16}, {-0.022881182346879636`, 
           0.}, {-0.021051659534618974`, 0.}, {-0.019222136722358316`, 
           0.}, {-0.017392613910097658`, 
           0.}, {-0.015563091097836997`, -1.9286549331065743`*^-15}, \
{-0.013733568285576335`, 
           0.}, {-0.011904045473315675`, -9.643274665532871*^-16}, \
{-0.010074522661055015`, -9.643274665532871*^-16}, {-0.008244999848794354, 
           0.}, {-0.006872857739598857, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.3418470188249384, 1.4464911998299308`*^-15}, {
           0.3435194290420739, -9.643274665532871*^-16}, {0.3455263213026365, 
           0.}, {0.3475332135631991, 0.}, {0.3495401058237617, 0.}, {
           0.35355389034488693`, 0.}, {0.35556078260544954`, 0.}, {
           0.35756767486601215`, 0.}, {0.35907284406143414`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.4797683930463642, 1.4464911998299308`*^-15}, {
           0.4814103531669396, -9.643274665532871*^-16}, {0.48338070531163, 
           0.}, {0.4853510574563205, -9.643274665532871*^-16}, {
           0.487321409601011, 0.}, {
           0.48929176174570144`, -1.9286549331065743`*^-15}, {
           0.49101581987230564`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.8476920564933162, 1.4464911998299308`*^-15}, {
           0.8490876053411218, 0.}, {
           0.8509483371381958, -9.643274665532871*^-16}, {0.8524989469690909, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.9662581948548774, 1.4464911998299308`*^-15}, {
           0.9676263386157788, 0.}, {0.9694505302969807, 0.}, {
           0.9712747219781825, -9.643274665532871*^-16}, {0.9727948817125175, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.0832331907659039`, 1.4464911998299308`*^-15}, {
           1.0847174243378603`, 0.}, {1.0866964024338024`, 0.}, {
           1.0886753805297444`, -1.9286549331065743`*^-15}, {
           1.0906543586256865`, 0.}, {1.0926333367216285`, 0.}, {
           1.0946123148175704`, 0.}, {
           1.0965912929135124`, -9.643274665532871*^-16}, {
           1.0985702710094545`, 0.}, {
           1.1005492491053963`, -9.643274665532871*^-16}, {
           1.1021983975186813`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.1878215722431795`, 1.4464911998299308`*^-15}, {
           1.1892066532792522`, 0.}, {
           1.191053427994016, -9.643274665532871*^-16}, {
           1.1929002027087798`, -9.643274665532871*^-16}, {
           1.1947469774235435`, 0.}, {1.1965937521383072`, 0.}, {
           1.1984405268530711`, 0.}, {
           1.2002873015678348`, -9.643274665532871*^-16}, {
           1.2021340762825985`, -9.643274665532871*^-16}, {
           1.2039808509973624`, -9.643274665532871*^-16}, {1.205827625712126, 
           0.}, {1.213214724571181, 0.}, {
           1.2150614992859448`, -9.643274665532871*^-16}, {
           1.2169082740007084`, 0.}, {1.2187550487154724`, 0.}, {
           1.220140129751545, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.3223759124572552`, 1.4464911998299308`*^-15}, {
           1.3238770833043831`, 0.}, {1.325878644433887, 0.}, {
           1.327880205563391, 0.}, {1.3298817666928948`, 0.}, {
           1.3338848889519024`, 0.}, {1.3358864500814063`, 0.}, {
           1.33788801121091, 0.}, {1.339389182058038, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.9303416766012986`, 1.4464911998299308`*^-15}, {
           1.9317058220139058`, 0.}, {1.933524682564049, 0.}, {
           1.9480755669651941`, 0.}, {1.9494397123778016`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.1842519630249804`, 1.4464911998299308`*^-15}, {
           2.185633045712759, 0.}, {2.1874744892964637`, 0.}, {
           2.189315932880169, 0.}, {
           2.191157376463874, -9.643274665532871*^-16}, {2.192998820047579, 
           0.}, {2.194840263631284, -9.643274665532871*^-16}, {
           2.1966817072149887`, 0.}, {2.1985231507986938`, 0.}, {
           2.200364594382399, -1.9286549331065743`*^-15}, {
           2.2022060379661035`, 0.}, {2.2058889251335136`, 0.}, {
           2.2072700078212923`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.019603320419251, 1.4464911998299308`*^-15}, {
           3.0210795572946196`, 0.}, {3.0230478731284443`, 0.}, {
           3.0250161889622684`, -9.643274665532871*^-16}, {
           3.0269845047960926`, -9.643274665532871*^-16}, {3.028952820629917, 
           0.}, {3.030921136463742, -1.9286549331065743`*^-15}, {
           3.0328894522975665`, 0.}, {3.034857768131391, 0.}, {
           3.0368260839652157`, 0.}, {3.0407627156328645`, 0.}, {
           3.0486359789681625`, 0.}, {3.050112215843531, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.1527547293681315`, 1.4464911998299308`*^-15}, {
           3.1541318137076164`, 0.}, {
           3.1559679261602627`, -9.643274665532871*^-16}, {
           3.157804038612909, -9.643274665532871*^-16}, {
           3.165148488423494, -9.643274665532871*^-16}, {
           3.172492938234079, -9.643274665532871*^-16}, {
           3.174329050686725, -1.9286549331065743`*^-15}, {
           3.1761651631393715`, -9.643274665532871*^-16}, {
           3.1780012755920177`, 0.}, {3.179837388044664, 0.}, {
           3.1816735004973102`, -9.643274665532871*^-16}, {
           3.1835096129499565`, 0.}, {
           3.1853457254026027`, -9.643274665532871*^-16}, {
           3.1868758191131414`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.7941167920214272`, 
           1.4464911998299308`*^-15}, {-1.7924543157804953`, \
-9.643274665532871*^-16}, {-1.790459344291377, 0.}, {-1.7884643728022587`, 
           0.}, {-1.7864694013131406`, 
           0.}, {-1.7844744298240225`, -9.643274665532871*^-16}, \
{-1.7824794583349042`, 0.}, {-1.7804844868457859`, 0.}, {-1.7789882582289471`,
            1.4464911998299308`*^-15}}], 
          LineBox[{{-1.6685520631706845`, 
           1.4464911998299308`*^-15}, {-1.666999756414068, \
-9.643274665532871*^-16}, {-1.665136988306128, -9.643274665532871*^-16}, \
{-1.663274220198188, 0.}, {-1.661411452090248, 0.}, {-1.6595486839823081`, 
           0.}, {-1.658151607901353, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.55817456591422, 
           1.4464911998299308`*^-15}, {-1.5568048949201692`, 
           0.}, {-1.5549786669281014`, -9.643274665532871*^-16}, \
{-1.5513262109439658`, -9.643274665532871*^-16}, {-1.54767375495983, \
-9.643274665532871*^-16}, {-1.545847526967762, -9.643274665532871*^-16}, \
{-1.5440212989756943`, -9.643274665532871*^-16}, {-1.5421950709836265`, \
-9.643274665532871*^-16}, {-1.54067321432357, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.9583673853391189, 
           1.4464911998299308`*^-15}, {-0.9568383403863527, \
-9.643274665532871*^-16}, {-0.9550034864430332, 0.}, {-0.9531686324997138, 
           0.}, {-0.9513337785563944, 0.}, {-0.949498924613075, 
           0.}, {-0.9458292167264362, 0.}, {-0.9439943627831168, 
           0.}, {-0.9421595088397974, -9.643274665532871*^-16}, \
{-0.9403246548964779, -9.643274665532871*^-16}, {-0.9384898009531585, 
           0.}, {-0.9311503851798808, 0.}, {-0.9293155312365614, 
           0.}, {-0.927480677293242, 
           0.}, {-0.9256458233499225, -9.643274665532871*^-16}, \
{-0.9241167783971563, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.6866918420133215, 
           1.4464911998299308`*^-15}, {-0.6852987642806605, 
           0.}, {-0.6834413273037793, 0.}, {-0.681583890326898, 
           0.}, {-0.6797264533500167, 0.}, {-0.6783333756173557, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.4595211216970708, 
           1.4464911998299308`*^-15}, {-0.4580393592402589, 
           0.}, {-0.4560636759645097, -9.643274665532871*^-16}, \
{-0.45408799268876043`, -9.643274665532871*^-16}, {-0.4521123094130112, 
           0.}, {-0.450136626137262, 0.}, {-0.44816094286151276`, 
           0.}, {-0.44420957631001434`, 0.}, {-0.44223389303426514`, 
           0.}, {-0.44025820975851593`, 0.}, {-0.43630684320701746`, 
           0.}, {-0.43482508075020554`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.27375188864595573`, 1.4464911998299308`*^-15}, {
           0.2751409680303226, 0.}, {0.27699307387614513`, 0.}, {
           0.29180992064272515`, 0.}, {0.29366202648854767`, 0.}, {
           0.2955141323343702, 0.}, {0.29921834402601516`, 0.}, {
           0.30662676740930517`, 0.}, {0.3084788732551277, 0.}, {
           0.3103309791009502, 0.}, {0.31403519079259523`, 0.}, {
           0.31588729663841775`, -9.643274665532871*^-16}, {
           0.3174307181766032, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.4062348121846554, 1.4464911998299308`*^-15}, {
           0.4077399813800774, 0.}, {
           0.40974687364064, -9.643274665532871*^-16}, {
           0.4117537659012026, -9.643274665532871*^-16}, {0.4137606581617652, 
           0.}, {0.4157675504223278, -9.643274665532871*^-16}, {
           0.41777444268289043`, 0.}, {0.4192796118783124, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.7738444179015186, 1.4464911998299308`*^-15}, {
           0.7753391192852079, 0.}, {
           0.7773320544634602, -9.643274665532871*^-16}, {0.7793249896417125, 
           0.}, {0.7813179248199649, 0.}, {
           0.7833108599982171, -9.643274665532871*^-16}, {0.7853037951764694, 
           0.}, {0.7892896655329741, 0.}, {0.7912826007112264, 0.}, {
           0.7927773020949157, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.894055290437078, 1.4464911998299308`*^-15}, {
           0.895605900267973, -9.643274665532871*^-16}, {
           0.8974666320650471, -1.9286549331065743`*^-15}, {
           0.8993273638621211, 0.}, {0.9011880956591951, 0.}, {
           0.9030488274562692, 0.}, {0.9049095592533434, 0.}, {
           0.9067702910504174, -9.643274665532871*^-16}, {0.9086310228474914, 
           0.}, {0.9104917546445654, -9.643274665532871*^-16}, {
           0.9142132182387135, -9.643274665532871*^-16}, {
           0.9179346818328616, -9.643274665532871*^-16}, {0.9194852916637568, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.1483745530906617`, 1.4464911998299308`*^-15}, {
           1.1500237015039467`, -9.643274665532871*^-16}, {
           1.1520026795998888`, 0.}, {1.1539816576958308`, 0.}, {
           1.1554658912677873`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.3724149406948514`, 1.4464911998299308`*^-15}, {
           1.3739161115419793`, 0.}, {1.3759176726714832`, 0.}, {
           1.377919233800987, -9.643274665532871*^-16}, {
           1.3799207949304908`, -9.643274665532871*^-16}, {
           1.3819223560599947`, -1.9286549331065743`*^-15}, {
           1.3839239171894986`, 0.}, {1.3859254783190025`, 0.}, {
           1.3879270394485064`, 0.}, {1.3899286005780103`, 0.}, {
           1.3919301617075142`, 0.}, {
           1.393931722837018, -9.643274665532871*^-16}, {
           1.3959332839665217`, -9.643274665532871*^-16}, {
           1.3979348450960256`, 0.}, {
           1.3999364062255295`, -9.643274665532871*^-16}, {
           1.4016043738334492`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.7646997331943406`, 1.4464911998299308`*^-15}, {
           1.7664388867356349`, -1.9286549331065743`*^-15}, {
           1.7684264907828284`, -1.9286549331065743`*^-15}, {
           1.770414094830022, 0.}, {1.7724016988772155`, 0.}, {
           1.774389302924409, 0.}, {1.7758800059598043`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.884030418952949, 1.4464911998299308`*^-15}, {
           1.8855765861746285`, -9.643274665532871*^-16}, {
           1.8874319868406437`, 0.}, {
           1.8892873875066591`, -9.643274665532871*^-16}, {
           1.8911427881726746`, 0.}, {1.8929981888386898`, 0.}, {
           1.894853589504705, -9.643274665532871*^-16}, {1.8963997567263844`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.004763387444656, 1.4464911998299308`*^-15}, {
           2.006279104569775, -9.643274665532871*^-16}, {2.0080979651199184`, 
           0.}, {2.0099168256700617`, 0.}, {2.011735686220205, 0.}, {
           2.0135545467703477`, -9.643274665532871*^-16}, {
           2.0153734073204905`, -9.643274665532871*^-16}, {
           2.0171922678706338`, 0.}, {2.018556413283241, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.1167938106735, 1.4464911998299308`*^-15}, {
           2.118274045897162, 0.}, {2.1202476928620455`, 0.}, {
           2.122221339826929, 0.}, {2.124194986791812, 0.}, {
           2.1261686337566954`, -9.643274665532871*^-16}, {2.128142280721579, 
           0.}, {2.130115927686462, 0.}, {2.132089574651345, 0.}, {
           2.1340632216162283`, -1.9286549331065743`*^-15}, {
           2.1360368685811117`, 0.}, {2.1380105155459947`, 0.}, {
           2.1399841625108778`, -9.643274665532871*^-16}, {
           2.1416288683149474`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.23949527053613, 1.4464911998299308`*^-15}, {
           2.240876353223909, 0.}, {2.242717796807614, 0.}, {
           2.244559240391319, 0.}, {2.2464006839750237`, 0.}, {
           2.2482421275587288`, 0.}, {
           2.250083571142434, -9.643274665532871*^-16}, {
           2.251925014726139, -9.643274665532871*^-16}, {2.253766458309844, 
           0.}, {2.2556079018935487`, -9.643274665532871*^-16}, {
           2.2574493454772537`, -9.643274665532871*^-16}, {
           2.259290789060959, -1.9286549331065743`*^-15}, {
           2.2611322326446635`, -9.643274665532871*^-16}, {
           2.2629736762283685`, 0.}, {2.2643547589161472`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.3698760759113546`, 1.4464911998299308`*^-15}, {
           2.3713732484101886`, 0.}, {2.373369478408634, 0.}, {
           2.3753657084070787`, -9.643274665532871*^-16}, {
           2.3773619384055236`, 0.}, {2.3788591109043575`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.4786044064926562`, 1.4464911998299308`*^-15}, {
           2.4800024264556066`, 0.}, {2.4818664530728736`, 0.}, {
           2.4837304796901405`, -9.643274665532871*^-16}, {
           2.4855945063074074`, 0.}, {2.4874585329246743`, 0.}, {
           2.4893225595419413`, -9.643274665532871*^-16}, {2.491186586159208, 
           0.}, {2.493050612776475, 0.}, {
           2.494914639393742, -9.643274665532871*^-16}, {
           2.4967786660110085`, -9.643274665532871*^-16}, {2.498642692628275, 
           0.}, {2.500506719245542, -9.643274665532871*^-16}, {
           2.502060074759931, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.7372246232639084`, 1.4464911998299308`*^-15}, {
           2.7387113279510094`, 0.}, {2.740693600867144, 0.}, {
           2.742675873783279, -9.643274665532871*^-16}, {2.744327767880058, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.973370237391927, -2.410818666383218*^-15}, {
           2.975040950683341, 0.}, {2.977045806633037, 0.}, {
           2.979050662582734, -9.643274665532871*^-16}, {2.981055518532431, 
           0.}, {2.985065230431824, 0.}, {2.9870700863815207`, 0.}, {
           2.989074942331217, 0.}, {2.9930846542306107`, 0.}, {
           3.001104078029397, 0.}, {
           3.0031089339790937`, -9.643274665532871*^-16}, {
           3.0051137899287905`, 0.}, {
           3.007118645878487, -9.643274665532871*^-16}, {3.008789359169901, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.096367637938407, 1.4464911998299308`*^-15}, {
           3.0978438748137753`, 0.}, {3.0998121906476, 0.}, {
           3.1017805064814246`, 0.}, {3.1037488223152487`, 0.}, {
           3.105717138149073, 0.}, {3.1076854539828975`, 0.}, {
           3.109653769816722, 0.}, {
           3.1116220856505468`, -9.643274665532871*^-16}, {
           3.1135904014843714`, 0.}, {3.115558717318196, 0.}, {
           3.1170349541935645`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.4664188564755993`, 1.4464911998299308`*^-15}, {
           3.4679677693807727`, -9.643274665532871*^-16}, {
           3.4698264648669808`, 0.}, {
           3.471685160353189, -1.9286549331065743`*^-15}, {3.473543855839397, 
           0.}, {3.477261246811813, 0.}, {3.4786552684264693`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.7110979922822582`, 1.4464911998299308`*^-15}, {
           3.7125806986210654`, 0.}, {
           3.7145576404061416`, -9.643274665532871*^-16}, {
           3.7165345821912172`, -9.643274665532871*^-16}, {
           3.7185115239762934`, 0.}, {
           3.7204884657613695`, -9.643274665532871*^-16}, {3.722465407546445, 
           0.}, {3.7244423493315213`, 0.}, {
           3.7264192911165974`, -9.643274665532871*^-16}, {
           3.7283962329016735`, 0.}, {
           3.7303731746867497`, -1.9286549331065743`*^-15}, {
           3.732350116471826, 0.}, {3.733832822810633, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.9407955294109183`, 1.4464911998299308`*^-15}, {
           3.9423399906667473`, 0.}, {
           3.944399272341186, -9.643274665532871*^-16}, {3.9464585540156243`, 
           0.}, {3.950577117364501, 0.}, {3.952636399038939, 0.}, {
           3.9546956807133773`, 0.}, {3.9588142440622542`, 0.}, {
           3.9608735257366927`, -9.643274665532871*^-16}, {
           3.9629328074111307`, 0.}, {3.9649920890855688`, 0.}, {
           3.9670513707600072`, -9.643274665532871*^-16}, {
           3.9691106524344457`, -9.643274665532871*^-16}, {3.970826720496478, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.011578149695382, 
           1.4464911998299308`*^-15}, {-1.0100491047426157`, \
-9.643274665532871*^-16}, {-1.0082142507992962`, -9.643274665532871*^-16}, \
{-1.0063793968559769`, -9.643274665532871*^-16}, {-1.0045445429126574`, \
-9.643274665532871*^-16}, {-1.0027096889693379`, 0.}, {-1.0008748350260186`, 
           0.}, {-0.999498694568529, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7704312923877181, 
           
           1.4464911998299308`*^-15}, {-0.7688834282403171, \
-9.643274665532871*^-16}, {-0.7670259912634358, -9.643274665532871*^-16}, \
{-0.7651685542865546, 0.}, {-0.7633111173096734, 0.}, {-0.7614536803327921, 
           0.}, {-0.7595962433559109, 0.}, {-0.7577388063790297, 
           0.}, {-0.7558813694021485, 
           0.}, {-0.7540239324252671, -1.9286549331065743`*^-15}, \
{-0.7523986750704961, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.08236205450294853, 1.4464911998299308`*^-15}, {
           0.0838502864231991, 0.}, {
           0.08583459565019985, -1.9286549331065743`*^-15}, {
           0.08781890487720062, -9.643274665532871*^-16}, {
           0.08980321410420139, 0.}, {0.09178752333120216, 0.}, {
           0.09377183255820293, 0.}, {0.0957561417852037, 0.}, {
           0.09972476023920522, 0.}, {0.10170906946620598`, 0.}, {
           0.10369337869320674`, 0.}, {0.10518161061345732`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.4562883633221362, 1.4464911998299308`*^-15}, {
           0.45776612743065404`, 0.}, {0.45973647957534447`, 0.}, {
           0.46170683172003496`, 0.}, {0.4656475360094159, 0.}, {
           0.4676178881541063, -9.643274665532871*^-16}, {
           0.4695882402987968, -9.643274665532871*^-16}, {0.4715585924434873, 
           0.}, {0.47352894458817774`, -9.643274665532871*^-16}, {
           0.47549929673286817`, 0.}, {0.476977060841386, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.5873225068204073, 1.4464911998299308`*^-15}, {
           0.5888542974566675, -9.643274665532871*^-16}, {0.5906924462201797, 
           0.}, {0.5925305949836919, -1.9286549331065743`*^-15}, {
           0.594368743747204, 0.}, {0.5980450412742285, 0.}, {
           0.5994236528468627, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.8326511411336344, 1.4464911998299308`*^-15}, {
           0.8342017509645294, -9.643274665532871*^-16}, {0.8360624827616034, 
           0.}, {0.8379232145586775, 0.}, {
           0.8397839463557515, -9.643274665532871*^-16}, {0.8416446781528255, 
           0.}, {0.8435054099498996, -9.643274665532871*^-16}, {
           0.8453661417469738, 0.}, {0.8467616905947793, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.17489129147448, 1.4464911998299308`*^-15}, {
           2.176425827794234, -9.643274665532871*^-16}, {2.1779603641139884`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.4149944981784257`, 1.4464911998299308`*^-15}, {
           2.416625521468534, -1.9286549331065743`*^-15}, {2.418489548085801, 
           0.}, {2.420353574703068, 0.}, {
           2.4222176013203347`, -1.9286549331065743`*^-15}, {
           2.4240816279376016`, -9.643274665532871*^-16}, {
           2.4259456545548685`, 0.}, {2.4278096811721355`, 0.}, {
           2.4296737077894024`, -9.643274665532871*^-16}, {
           2.4312270633037913`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.876957797503331, 1.4464911998299308`*^-15}, {
           3.87850225875916, 0.}, {3.8805615404335985`, 0.}, {
           3.882620822108037, 0.}, {
           3.884680103782475, -9.643274665532871*^-16}, {3.886739385456913, 
           0.}, {3.888283846712742, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.4446613204331473`, 
           1.4464911998299308`*^-15}, {-1.4431755596280413`, 
           0.}, {-1.4411945452212334`, 0.}, {-1.4392135308144254`, 
           0.}, {-1.4377277700093194`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.3320450294744757`, 
           1.4464911998299308`*^-15}, {-1.3306584212052535`, 
           0.}, {-1.3288096101796236`, 0.}, {-1.3269607991539938`, 
           0.}, {-1.3251119881283642`, 
           0.}, {-1.3232631771027346`, -9.643274665532871*^-16}, \
{-1.3214143660771047`, 0.}, {-1.3177167440258453`, 
           0.}, {-1.3158679330002157`, -9.643274665532871*^-16}, \
{-1.3140191219745858`, 0.}, {-1.312170310948956, 
           0.}, {-1.3103214999233264`, -1.9286549331065743`*^-15}, \
{-1.3084726888976967`, -9.643274665532871*^-16}, {-1.3066238778720671`, 
           0.}, {-1.305237269602845, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.194871046329581, 
           1.4464911998299308`*^-15}, {-1.1932013817959395`, \
-9.643274665532871*^-16}, {-1.1911977843555697`, -9.643274665532871*^-16}, \
{-1.1891941869151998`, -9.643274665532871*^-16}, {-1.18719058947483, 
           0.}, {-1.1851869920344602`, 0.}, {-1.1836842939541827`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.075776272538521, 
           1.4464911998299308`*^-15}, {-1.0743009795451477`, 
           0.}, {-1.066432750247157, 
           0.}, {-1.064465692922659, -9.643274665532871*^-16}, \
{-1.0624986355981614`, 0.}, {-1.058564520949166, 0.}, {-1.0570892279557929`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7017835174504816, 
           1.4464911998299308`*^-15}, {-0.7001582600957106, \
-1.9286549331065743`*^-15}, {-0.6983008231188294, -9.643274665532871*^-16}, \
{-0.6964433861419481, -9.643274665532871*^-16}, {-0.6945859491650668, 
           0.}, {-0.6927285121881855, -9.643274665532871*^-16}, \
{-0.6908710752113043, 
           0.}, {-0.689013638234423, -9.643274665532871*^-16}, \
{-0.6874657740870219, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.22217877693295937`, 
           1.4464911998299308`*^-15}, {-0.22068007720097607`, 
           0.}, {-0.218681810891665, 
           0.}, {-0.21668354458235395`, -9.643274665532871*^-16}, \
{-0.21468527827304287`, -9.643274665532871*^-16}, {-0.2126870119637318, \
-9.643274665532871*^-16}, {-0.21068874565442075`, 
           0.}, {-0.20869047934510968`, -9.643274665532871*^-16}, \
{-0.2066922130357986, 0.}, {-0.2051935133038153, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.39804000212069146`, 1.4464911998299308`*^-15}, {
           0.39971241233782695`, -9.643274665532871*^-16}, {
           0.40171930459838956`, -1.9286549331065743`*^-15}, {
           0.40372619685895217`, -9.643274665532871*^-16}, {
           0.40539860707608766`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.1325427283231257`, 1.4464911998299308`*^-15}, {
           1.1341918767364108`, -9.643274665532871*^-16}, {
           1.1361708548323528`, 0.}, {1.1381498329282949`, 0.}, {
           1.140128811024237, -9.643274665532871*^-16}, {1.1417779594375217`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.7490473513226912`, 1.4464911998299308`*^-15}, {
           1.7505380543580864`, 0.}, {
           1.75252565840528, -9.643274665532871*^-16}, {1.7545132624524735`, 
           0.}, {1.756500866499667, 0.}, {1.7579915695350623`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.873052631679025, 1.4464911998299308`*^-15}, {
           1.8744441821785367`, 0.}, {1.8762995828445521`, 0.}, {
           1.8781549835105673`, 0.}, {1.881865784842598, 0.}, {
           1.8832573353421096`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.9885452142058795`, 1.4464911998299308`*^-15}, {
           1.989909359618487, 0.}, {1.99172822016863, 0.}, {1.993547080718773,
            0.}, {1.9953659412689162`, -9.643274665532871*^-16}, {
           1.9971848018190594`, -9.643274665532871*^-16}, {
           1.9990036623692027`, 0.}, {2.0008225229193455`, 0.}, {
           2.0026413834694887`, 0.}, {2.004005528882096, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.1088992228139665`, 1.4464911998299308`*^-15}, {
           2.110379458037629, 0.}, {
           2.112353105002512, -9.643274665532871*^-16}, {
           2.1143267519673956`, -1.9286549331065743`*^-15}, {
           2.1160536930616685`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.231899315753347, 1.4464911998299308`*^-15}, {
           2.233510578889089, -1.9286549331065743`*^-15}, {2.235352022472794, 
           0.}, {2.2367331051605728`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.5855395315572567`, 1.4464911998299308`*^-15}, {
           2.586910146433303, 0.}, {2.5887376329346976`, 0.}, {
           2.5905651194360924`, -9.643274665532871*^-16}, {
           2.592392605937487, -9.643274665532871*^-16}, {2.594220092438882, 
           0.}, {2.5960475789402766`, 0.}, {2.597875065441671, 0.}, {
           2.5997025519430657`, 0.}, {2.6015300384444604`, 0.}, {
           2.6033575249458547`, 0.}, {2.6051850114472495`, 0.}, {
           2.607012497948644, -9.643274665532871*^-16}, {2.6085354033664734`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.719218977609017, 1.4464911998299308`*^-15}, {
           2.720870871705796, -9.643274665532871*^-16}, {
           2.722853144621931, -9.643274665532871*^-16}, {2.724835417538066, 
           0.}, {2.7268176904542005`, 0.}, {2.728799963370335, 0.}, {
           2.7302866680574365`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.7113957296533047`, 
           1.4464911998299308`*^-15}, {-1.7098434228966881`, \
-9.643274665532871*^-16}, {-1.7079806547887482`, 0.}, {-1.7065835787077932`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.3580824514187608`, 
           1.4464911998299308`*^-15}, {-1.3565417755640694`, \
-9.643274665532871*^-16}, {-1.3546929645384398`, -9.643274665532871*^-16}, \
{-1.3528441535128102`, 0.}, {-1.3509953424871803`, 0.}, {-1.3491465314615505`,
            0.}, {-1.3472977204359209`, -9.643274665532871*^-16}, \
{-1.3457570445812295`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.226761638922134, 
           1.4464911998299308`*^-15}, {-1.2252589408418566`, 
           0.}, {-1.2232553434014868`, 
           0.}, {-1.221251745961117, -9.643274665532871*^-16}, \
{-1.2192481485207471`, 
           0.}, {-1.2172445510803773`, -9.643274665532871*^-16}, \
{-1.2152409536400075`, -9.643274665532871*^-16}, {-1.2132373561996377`, 
           0.}, {-1.2112337587592679`, 0.}, {-1.2097310606789904`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8615025048360649, 
           1.4464911998299308`*^-15}, {-0.8600102745675202, 
           0.}, {-0.8580206342094607, -9.643274665532871*^-16}, \
{-0.8560309938514012, 0.}, {-0.8540413534933418, 0.}, {-0.8520517131352823, 
           0.}, {-0.8500620727772227, 
           0.}, {-0.8480724324191631, -9.643274665532871*^-16}, \
{-0.8464143987874468, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7331277664353529, 
           1.4464911998299308`*^-15}, {-0.731734688702692, 
           0.}, {-0.7298772517258107, -9.643274665532871*^-16}, \
{-0.7280198147489295, -9.643274665532871*^-16}, {-0.7261623777720483, \
-9.643274665532871*^-16}, {-0.7243049407951669, 0.}, {-0.722911863062506, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.49327237765778664`, 
           1.4464911998299308`*^-15}, {-0.49162597492799565`, \
-9.643274665532871*^-16}, {-0.48965029165224644`, 0.}, {-0.48767460837649723`,
            0.}, {-0.48569892510074797`, 
           0.}, {-0.48372324182499876`, -9.643274665532871*^-16}, \
{-0.48174755854924955`, 
           0.}, {-0.4797718752735003, -1.9286549331065743`*^-15}, \
{-0.47804315240721973`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.2581475705005586, 
           1.4464911998299308`*^-15}, {-0.25664887076857523`, 
           0.}, {-0.2546506044592642, -9.643274665532871*^-16}, \
{-0.25265233814995314`, 0.}, {-0.25065407184064203`, 0.}, {-0.248655805531331,
            0.}, {-0.2466575392220199, 0.}, {-0.24465927291270884`, 
           0.}, {-0.2426610066033978, 0.}, {-0.23866447398477564`, 
           0.}, {-0.2366662076754646, -9.643274665532871*^-16}, \
{-0.2350009857510387, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.491590505914507, 1.4464911998299308`*^-15}, {
           0.4932324660350824, -9.643274665532871*^-16}, {
           0.49520281817977285`, -9.643274665532871*^-16}, {
           0.49717317032446334`, -1.9286549331065743`*^-15}, {
           0.49914352246915383`, 0.}, {0.5006212865776717, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.8625779108699086, 1.4464911998299308`*^-15}, {
           0.8639734597177142, 0.}, {0.8658341915147882, 0.}, {
           0.8672297403625938, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.973554961579685, 1.4464911998299308`*^-15}, {
           0.9749231053405865, 0.}, {0.9767472970217883, 0.}, {
           0.9785714887029902, 0.}, {0.9803956803841921, 0.}, {
           0.9822198720653941, -9.643274665532871*^-16}, {
           0.9840440637465959, -9.643274665532871*^-16}, {
           0.9858682554277978, -9.643274665532871*^-16}, {0.9876924471089997, 
           0.}, {0.9895166387902017, 0.}, {0.9913408304714035, 0.}, {
           0.9931650221526054, 0.}, {0.9945331659135068, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.9521680032030162`, 1.4464911998299308`*^-15}, {
           1.9535321486156234`, 0.}, {1.9553510091657667`, 0.}, {
           1.9626264513663394`, 0.}, {1.9644453119164824`, 0.}, {
           1.9662641724666257`, 0.}, {1.9699018935669121`, 0.}, {
           1.9717207541170554`, 0.}, {1.9735396146671984`, 0.}, {
           1.9749037600798056`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.5561474569931586`, 1.4464911998299308`*^-15}, {
           2.5576703624109878`, -9.643274665532871*^-16}, {
           2.5594978489123825`, -9.643274665532871*^-16}, {
           2.5613253354137773`, -9.643274665532871*^-16}, {2.563152821915172, 
           0.}, {2.5649803084165668`, -9.643274665532871*^-16}, {
           2.5668077949179615`, 0.}, {2.568635281419356, 0.}, {
           2.5704627679207506`, -1.9286549331065743`*^-15}, {
           2.5722902544221453`, 0.}, {
           2.5741177409235396`, -1.9286549331065743`*^-15}, {2.57571679161226,
            1.4464911998299308`*^-15}}], 
          LineBox[{{2.679573519286321, 1.4464911998299308`*^-15}, {
           2.6812254133830997`, -9.643274665532871*^-16}, {
           2.6832076862992347`, 0.}, {2.6851899592153696`, 0.}, {
           2.6871722321315046`, -9.643274665532871*^-16}, {
           2.6891545050476395`, 0.}, {
           2.691136777963774, -9.643274665532871*^-16}, {2.6931190508799085`, 
           0.}, {2.6951013237960435`, -9.643274665532871*^-16}, {
           2.6970835967121785`, -9.643274665532871*^-16}, {
           2.6990658696283134`, 0.}, {2.7010481425444484`, 0.}, {
           2.703030415460583, -9.643274665532871*^-16}, {
           2.7050126883767174`, -9.643274665532871*^-16}, {
           2.7066645824734965`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.6575558189364483`, 1.4464911998299308`*^-15}, {
           3.659203270424012, -9.643274665532871*^-16}, {3.661180212209088, 
           0.}, {3.663157153994164, 0.}, {3.66513409577924, 0.}, {
           3.6671110375643163`, -9.643274665532871*^-16}, {
           3.669087979349392, -9.643274665532871*^-16}, {
           3.671064921134468, -1.9286549331065743`*^-15}, {
           3.6730418629195443`, 0.}, {3.67501880470462, 0.}, {
           3.676995746489696, 0.}, {3.6784784528285033`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.7740008295061513`, 
           1.4464911998299308`*^-15}, {-1.7725046008893126`, 
           0.}, {-1.7705096294001943`, -9.643274665532871*^-16}, \
{-1.768514657911076, -9.643274665532871*^-16}, {-1.7665196864219577`, 
           0.}, {-1.7645247149328394`, -9.643274665532871*^-16}, \
{-1.7625297434437213`, 0.}, {-1.7610335148268828`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.6553574557394428`, 
           1.4464911998299308`*^-15}, {-1.6539603796584879`, 
           0.}, {-1.652097611550548, 0.}, {-1.650234843442608, 
           0.}, {-1.648837767361653, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.1668206821644036`, 
           1.4464911998299308`*^-15}, {-1.165151017630762, \
-9.643274665532871*^-16}, {-1.1631474201903922`, -1.9286549331065743`*^-15}, \
{-1.1611438227500224`, 0.}, {-1.1591402253096525`, 0.}, {-1.1571366278692827`,
            0.}, {-1.1556339297890053`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.9233522559207733, 
           1.4464911998299308`*^-15}, {-0.9219761154632837, 
           0.}, {-0.9201412615199642, -1.9286549331065743`*^-15}, \
{-0.9183064075766448, -9.643274665532871*^-16}, {-0.9164715536333254, 
           0.}, {-0.914636699690006, 
           0.}, {-0.9128018457466867, -9.643274665532871*^-16}, \
{-0.9109669918033673, 
           0.}, {-0.9091321378600479, -9.643274665532871*^-16}, \
{-0.9072972839167285, 0.}, {-0.9054624299734091, 0.}, {-0.9036275760300896, 
           0.}, {-0.9022514355726, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.43013283297030114`, 
           1.4464911998299308`*^-15}, {-0.4284041101040206, \
-1.9286549331065743`*^-15}, {-0.4264284268282713, -9.643274665532871*^-16}, \
{-0.4244527435525221, 0.}, {-0.4229709810957102, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.42028305800859367`, 1.4464911998299308`*^-15}, {
           0.42178822720401565`, 0.}, {
           0.42379511946457826`, -9.643274665532871*^-16}, {
           0.42580201172514087`, -9.643274665532871*^-16}, {
           0.4278089039857035, 0.}, {0.4298157962462661, 0.}, {
           0.4318226885068287, -9.643274665532871*^-16}, {0.4338295807673913, 
           0.}, {0.4358364730279539, 0.}, {
           0.43784336528851653`, -9.643274665532871*^-16}, {
           0.43985025754907914`, 0.}, {0.44185714980964175`, 0.}, {
           0.44336231900506373`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.7977596400405463, 1.4464911998299308`*^-15}, {
           0.7992543414242357, 0.}, {
           0.801247276602488, -9.643274665532871*^-16}, {
           0.8032402117807402, -9.643274665532871*^-16}, {0.8052331469589926, 
           0.}, {0.8072260821372449, -9.643274665532871*^-16}, {
           0.8092190173154972, -1.9286549331065743`*^-15}, {
           0.8112119524937496, 0.}, {0.8127066538774388, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.9201055355961147, 1.4464911998299308`*^-15}, {
           0.9216561454270098, -9.643274665532871*^-16}, {0.9235168772240838, 
           0.}, {0.9253776090211578, 0.}, {0.9267731578689634, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.1564553803157582`, 1.4464911998299308`*^-15}, {
           1.1579396138877147`, 0.}, {1.1599185919836568`, 0.}, {
           1.1678345043674248`, 0.}, {1.1698134824633668`, 0.}, {
           1.1717924605593089`, 0.}, {1.173771438655251, 0.}, {
           1.175750416751193, -9.643274665532871*^-16}, {1.177729394847135, 
           0.}, {1.179708372943077, 0.}, {1.1811926065150335`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.776873807983401, 1.4464911998299308`*^-15}, {
           1.7783645110187962`, 0.}, {1.7803521150659898`, 0.}, {
           1.7823397191131833`, -9.643274665532871*^-16}, {1.784327323160377, 
           0.}, {1.7863149272075705`, -9.643274665532871*^-16}, {
           1.788302531254764, 0.}, {
           1.7902901353019576`, -9.643274665532871*^-16}, {
           1.7922777393491511`, -9.643274665532871*^-16}, {
           1.7942653433963447`, -9.643274665532871*^-16}, {
           1.7962529474435383`, 0.}, {
           1.7982405514907316`, -9.643274665532871*^-16}, {
           1.7998968881967263`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.90273904233527, 1.4464911998299308`*^-15}, {
           1.9041305928347816`, 0.}, {1.9055221433342933`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.019465843558313, 1.4464911998299308`*^-15}, {
           2.0208299889709203`, 0.}, {2.0221941343835277`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.37969087340371, 1.4464911998299308`*^-15}, {
           2.381354398402414, -9.643274665532871*^-16}, {2.3833506284008594`, 
           0.}, {2.3853468583993047`, 0.}, {
           2.3873430883977496`, -9.643274665532871*^-16}, {
           2.3893393183961944`, -1.9286549331065743`*^-15}, {
           2.3913355483946397`, 0.}, {2.393331778393085, 0.}, {
           2.3948289508919185`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.7449885255187696`, 1.4464911998299308`*^-15}, {
           2.7466404196155487`, -9.643274665532871*^-16}, {
           2.750604965447818, -9.643274665532871*^-16}, {
           2.7545695112800876`, -9.643274665532871*^-16}, {
           2.7565517841962226`, 0.}, {2.7585340571123576`, 0.}, {
           2.7605163300284925`, 0.}, {2.762498602944627, 0.}, {
           2.763985307631728, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.1178550857909912`, 1.4464911998299308`*^-15}, {
           3.119495348985845, -9.643274665532871*^-16}, {
           3.121463664819669, -9.643274665532871*^-16}, {
           3.1234319806534936`, -9.643274665532871*^-16}, {3.125400296487318, 
           0.}, {3.127368612321143, 0.}, {3.1288448491965113`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.233543677284566, 1.4464911998299308`*^-15}, {
           3.2349207616240507`, 0.}, {3.236756874076697, 0.}, {
           3.2385929865293432`, -9.643274665532871*^-16}, {
           3.2404290989819895`, 0.}, {
           3.2422652114346358`, -1.9286549331065743`*^-15}, {
           3.244101323887282, -1.9286549331065743`*^-15}, {
           3.2459374363399283`, -9.643274665532871*^-16}, {
           3.2477735487925745`, 0.}, {3.2496096612452208`, 0.}, {
           3.2509867455847057`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.9716847545274936`, 1.4464911998299308`*^-15}, {
           3.9732292157833227`, 0.}, {3.9752884974577607`, 0.}, {
           3.9773477791321987`, -9.643274665532871*^-16}, {3.979407060806637, 
           0.}, {3.983525624155514, 0.}, {3.9855849058299526`, 0.}, {
           3.9876441875043906`, -1.9286549331065743`*^-15}, {
           3.9897034691788287`, 0.}, {3.991762750853267, 0.}, {
           3.9938220325277056`, -9.643274665532871*^-16}, {
           3.995881314202144, -9.643274665532871*^-16}, {3.997597382264176, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.8797343184294197`, 
           1.4464911998299308`*^-15}, {-1.878238089812581, 
           0.}, {-1.8762431183234627`, 
           0.}, {-1.8742481468343446`, -9.643274665532871*^-16}, \
{-1.8722531753452265`, 0.}, {-1.8702582038561082`, 0.}, {-1.8687619752392695`,
            1.4464911998299308`*^-15}}], 
          LineBox[{{-1.748651091812105, 
           1.4464911998299308`*^-15}, {-1.7470987850554882`, \
-9.643274665532871*^-16}, {-1.7455464782988714`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.9012953119972553, 
           1.4464911998299308`*^-15}, {-0.8998030817287106, 
           0.}, {-0.8978134413706511, 0.}, {-0.8958238010125916, 
           0.}, {-0.8938341606545321, -9.643274665532871*^-16}, \
{-0.8918445202964727, 0.}, {-0.8898548799384131, 
           0.}, {-0.8878652395803535, -9.643274665532871*^-16}, \
{-0.8862072059486372, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.4066073342406711, 
           1.4464911998299308`*^-15}, {-0.4052247243197429, 
           0.}, {-0.4033812444251719, -1.9286549331065743`*^-15}, \
{-0.40153776453060097`, -9.643274665532871*^-16}, {-0.40000153128512517`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.3239522295015884, 1.4464911998299308`*^-15}, {
           0.3254573986970104, 0.}, {
           0.327464290957573, -9.643274665532871*^-16}, {0.3294711832181356, 
           0.}, {0.33147807547869823`, 0.}, {0.33348496773926084`, 0.}, {
           0.33549185999982345`, -9.643274665532871*^-16}, {
           0.33716427021695894`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.1621546400205203`, 1.4464911998299308`*^-15}, {
           2.163535722708299, 0.}, {2.1653771662920036`, 0.}, {
           2.1672186098757087`, 0.}, {2.1690600534594138`, 0.}, {
           2.1704411361471925`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.893343070733202, 1.4464911998299308`*^-15}, {
           2.894846712695475, 0.}, {
           2.8968515686451717`, -9.643274665532871*^-16}, {
           2.898856424594868, -9.643274665532871*^-16}, {2.9005271378862822`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.149082504462839, 1.4464911998299308`*^-15}, {
           3.150459588802324, 0.}, {3.151836673141809, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.9352867024353881`, 
           1.4464911998299308`*^-15}, {-1.9337532148734062`, \
-9.643274665532871*^-16}, {-1.9322197273114243`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2048890335314302`, 
           1.4464911998299308`*^-15}, {-1.2032193689977886`, \
-9.643274665532871*^-16}, {-1.2012157715574188`, 0.}, {-1.1997130734771413`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.4716221817610348, 
           1.4464911998299308`*^-15}, {-0.4698934588947542, \
-1.9286549331065743`*^-15}, {-0.467917775619005, -9.643274665532871*^-16}, \
{-0.4659420923432558, -1.9286549331065743`*^-15}, {-0.4639664090675065, 
           0.}, {-0.4619907257917573, -9.643274665532871*^-16}, \
{-0.4603443230619663, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.7409313014633174`, 1.4464911998299308`*^-15}, {
           1.7425876381693122`, -9.643274665532871*^-16}, {
           1.7445752422165057`, -9.643274665532871*^-16}, {
           1.7465628462636993`, -9.643274665532871*^-16}, {1.748219182969694, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.9776320509050205`, 1.4464911998299308`*^-15}, {
           1.978996196317628, 0.}, {
           1.980815056867771, -9.643274665532871*^-16}, {1.982633917417914, 
           0.}, {1.9844527779680572`, 0.}, {1.9862716385182004`, 0.}, {
           1.9876357839308079`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.707242745407369, 1.4464911998299308`*^-15}, {
           2.7089772342089873`, -1.9286549331065743`*^-15}, {
           2.7109595071251222`, 0.}, {
           2.712941780041257, -9.643274665532871*^-16}, {2.7149240529573917`, 
           0.}, {2.716906325873526, 0.}, {2.7183930305606276`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.4534079880721427`, 1.4464911998299308`*^-15}, {
           3.454956900977316, -9.643274665532871*^-16}, {3.456815596463524, 
           0.}, {3.458674291949732, 0.}, {3.4605329874359403`, 0.}, {
           3.4619270090505965`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.9665698486998169`, 
           1.4464911998299308`*^-15}, {-1.9650363611378352`, \
-9.643274665532871*^-16}, {-1.9631961760634569`, -9.643274665532871*^-16}, \
{-1.9613559909890785`, 0.}, {-1.9599758521832948`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.7186915714094033`, 
           1.4464911998299308`*^-15}, {-1.7172944953284481`, 
           0.}, {-1.715431727220508, 0.}, {-1.714034651139553, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7442723882966406, 
           1.4464911998299308`*^-15}, {-0.7428793105639796, 
           0.}, {-0.7410218735870984, 
           0.}, {-0.739164436610217, -9.643274665532871*^-16}, \
{-0.7373069996333358, 0.}, {-0.7354495626564546, 0.}, {-0.7340564849237935, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.6205275080761349, -2.410818666383218*^-15}, \
{-0.6191618354303781, -9.643274665532871*^-16}, {-0.6173409385693689, \
-9.643274665532871*^-16}, {-0.6155200417083598, 0.}, {-0.6136991448473508, 
           0.}, {-0.6123334722015938, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.005958096333468528, 
           1.4464911998299308`*^-15}, {-0.004585954224273032, 
           0.}, {-0.0027564314120123714`, 
           0.}, {-0.0009269085997517111, -9.643274665532871*^-16}, {
           0.0009026142125089494, 0.}, {0.0022747563217044454`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.10815807445395847`, 1.4464911998299308`*^-15}, {
           0.10964630637420905`, 0.}, {0.11163061560120982`, 0.}, {
           0.11361492482821059`, 0.}, {0.11559923405521134`, 0.}, {
           0.1175835432822121, 0.}, {0.11956785250921287`, 0.}, {
           0.12155216173621364`, 0.}, {0.12304039365646421`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.611371619809692, 1.4464911998299308`*^-15}, {
           0.6127502313823262, 0.}, {0.6145883801458385, 0.}, {
           0.6159669917184727, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.8532742518845383, 1.4464911998299308`*^-15}, {
           0.8546698007323439, 0.}, {
           0.8565305325294179, -9.643274665532871*^-16}, {
           0.858391264326492, -9.643274665532871*^-16}, {
           0.8602519961235662, -9.643274665532871*^-16}, {0.8618026059544612, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.0510963737604433`, 1.4464911998299308`*^-15}, {
           3.0525726106358118`, 0.}, {3.0545409264696364`, 0.}, {
           3.0565092423034605`, -9.643274665532871*^-16}, {
           3.0584775581372847`, 0.}, {3.0604458739711093`, 0.}, {
           3.061922110846478, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.1746681054725188`, 
           1.4464911998299308`*^-15}, {-1.1731654073922413`, 
           0.}, {-1.1711618099518715`, 0.}, {-1.1691582125115016`, 
           0.}, {-1.1676555144312242`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.479584616169573, 1.4464911998299308`*^-15}, {
           3.4809786377842293`, 0.}, {3.4846960287566455`, 0.}, {
           3.4865547242428536`, -9.643274665532871*^-16}, {
           3.4884134197290617`, 0.}, {3.49027211521527, 0.}, {
           3.491666136829926, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.496332779544055, 
           
           1.4464911998299308`*^-15}, {-1.4946819342050484`, \
-9.643274665532871*^-16}, {-1.4930310888660416`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8853781891327791, 
           1.4464911998299308`*^-15}, {-0.8838859588642345, 
           0.}, {-0.881896318506175, -9.643274665532871*^-16}, \
{-0.8799066781481155, 0.}, {-0.8779170377900559, 0.}, {-0.8759273974319963, 
           0.}, {-0.8739377570739368, 0.}, {-0.8724455268053922, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.541679855523784, 1.4464911998299308`*^-15}, {
           2.5430504703998302`, 0.}, {
           2.5448779569012245`, -9.643274665532871*^-16}, {
           2.5467054434026193`, 0.}, {2.548532929904014, 0.}, {
           2.550360416405409, 0.}, {2.5521879029068035`, 0.}, {
           2.5540153894081983`, 0.}, {2.5553860042842444`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.889141880743758, 1.4464911998299308`*^-15}, {
           3.89085794880579, -9.643274665532871*^-16}, {3.8929172304802284`, 
           0.}, {3.8944616917360575`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.922252058158543, 
           1.4464911998299308`*^-15}, {-1.9208719193527592`, 
           0.}, {-1.919031734278381, -1.9286549331065743`*^-15}, \
{-1.9171915492040026`, 
           0.}, {-1.9153513641296245`, -1.9286549331065743`*^-15}, \
{-1.9137412021895437`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.6778659037103847`, 
           1.4464911998299308`*^-15}, {-1.6763135969537681`, \
-9.643274665532871*^-16}, {-1.6744508288458282`, 0.}, {-1.672588060737888, 
           0.}, {-1.6707252926299478`, -1.9286549331065743`*^-15}, \
{-1.6690953705355003`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.5824404154000276, 
           1.4464911998299308`*^-15}, {-0.5809230013491866, \
-9.643274665532871*^-16}, {-0.5791021044881776, -1.9286549331065743`*^-15}, \
{-0.5772812076271685, 
           0.}, {-0.5754603107661593, -9.643274665532871*^-16}, \
{-0.5739428967153184, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.7588197378880595`, 1.4464911998299308`*^-15}, {
           1.7604760745940542`, -9.643274665532871*^-16}, {
           1.7624636786412478`, -9.643274665532871*^-16}, {
           1.7641200153472425`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.2223739931976345`, 1.4464911998299308`*^-15}, {
           3.223904086908173, -9.643274665532871*^-16}, {3.2257401993608195`, 
           0.}, {3.2275763118134657`, 0.}, {3.2289533961529506`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.3412890846026242`, 
           1.4464911998299308`*^-15}, {-1.339902476333402, 
           0.}, {-1.3380536653077724`, 0.}, {-1.33666705703855, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.0916766525782102`, 
           1.4464911998299308`*^-15}, {-1.0900374381411289`, \
-9.643274665532871*^-16}, {-1.0880703808166312`, -1.9286549331065743`*^-15}, \
{-1.0863492056576958`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.5016064626500168, 1.4464911998299308`*^-15}, {
           0.5030842267585347, 0.}, {0.5050545789032252, 0.}, {
           0.5065323430117431, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.576402099050283, 1.4464911998299308`*^-15}, {
           2.577772713926329, 0.}, {2.5791433288023753`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.1874878565973566`, 1.4464911998299308`*^-15}, {
           3.1890179503078953`, -9.643274665532871*^-16}, {
           3.1908540627605415`, -9.643274665532871*^-16}, {
           3.1926901752131878`, -9.643274665532871*^-16}, {3.194526287665834, 
           0.}, {3.195903372005319, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.9179718241858943`, 1.4464911998299308`*^-15}, {
           3.919687892247926, -9.643274665532871*^-16}, {
           3.9217471739223644`, -1.9286549331065743`*^-15}, {
           3.923806455596803, 0.}, {3.9258657372712413`, 0.}, {
           3.9274101985270704`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.9277035237675003, 1.4464911998299308`*^-15}, {
           0.9290990726153059, 0.}, {
           0.9309598044123799, -9.643274665532871*^-16}, {
           0.9328205362094539, -9.643274665532871*^-16}, {0.934681268006528, 
           0.}, {0.936541999803602, 0.}, {0.9379375486514075, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.2519048018110284`, 1.4464911998299308`*^-15}, {
           3.2532818861505133`, 0.}, {3.2551179986031595`, 0.}, {
           3.256954111055806, 0.}, {3.2583311953952907`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.4122913972489316, 
           1.4464911998299308`*^-15}, {-0.4107551640034558, \
-9.643274665532871*^-16}, {-0.4089116841088848, -9.643274665532871*^-16}, \
{-0.407375450863409, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.145180765500966, 1.4464911998299308`*^-15}, {
           3.1467873638970314`, -1.9286549331065743`*^-15}, {
           3.1483939622930968`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.0798743086312244`, 
           1.4464911998299308`*^-15}, {-1.078235094194143, \
-9.643274665532871*^-16}, {-1.0765958797570616`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.23485766588368323`, 1.4464911998299308`*^-15}, {
           0.2362467452680501, 0.}, {0.23809885111387258`, 0.}, {
           0.23948793049823947`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.6057039944555294, 1.4464911998299308`*^-15}, {
           0.6072357850917895, -9.643274665532871*^-16}, {
           0.6090739338553017, -9.643274665532871*^-16}, {0.6106057244915619, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.0484013914392616`, 
           1.4464911998299308`*^-15}, {-1.0467621770021802`, \
-9.643274665532871*^-16}, {-1.0451229625650988`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.9848183506874004`, 
           1.4464911998299308`*^-15}, {-1.9834382118816167`, 
           0.}, {-1.9815980268072386`, 
           0.}, {-1.9797578417328605`, -1.9286549331065743`*^-15}, \
{-1.9781476797927795`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.7391820205967432`, 
           1.4464911998299308`*^-15}, {-1.7377849445157882`, 
           0.}, {-1.7359221764078483`, 0.}, {-1.7340594082999083`, 
           0.}, {-1.7326623322189532`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.5021107382305783`, 
           1.4464911998299308`*^-15}, {-1.5006249774254723`, 
           0.}, {-1.4986439630186643`, 0.}, {-1.4971582022135583`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.1269197629754606`, 
           1.4464911998299308`*^-15}, {-1.1254444699820874`, 
           0.}, {-1.1234774126575897`, 0.}, {-1.1220021196642163`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.9571372364488678, 1.4464911998299308`*^-15}, {
           0.9585053802097693, 0.}, {0.9603295718909712, 0.}, {
           0.9616977156518727, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.799935458864689, 
           1.4464911998299308`*^-15}, {-1.7984392302478502`, 
           0.}, {-1.796444258758732, 0.}, {-1.7949480301418932`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.2168656558396957`, 1.4464911998299308`*^-15}, {
           3.2183957495502344`, -9.643274665532871*^-16}, {
           3.2202318620028807`, 0.}, {3.2216089463423656`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.3449867066538839`, 
           1.4464911998299308`*^-15}, {-1.3436000983846614`, 
           0.}, {-1.342213490115439, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.0974139031079952`, 
           1.4464911998299308`*^-15}, {-1.0959386101146218`, 
           0.}, {-1.0939715527901241`, -9.643274665532871*^-16}, \
{-1.0923323383530428`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.0229519929460875`, 1.4464911998299308`*^-15}, {
           2.0244677100712067`, -9.643274665532871*^-16}, {2.02628657062135, 
           0.}, {2.027650716033957, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.2651220270760244`, 1.4464911998299308`*^-15}, {
           2.2666565633957787`, -9.643274665532871*^-16}, {
           2.268498006979484, -1.9286549331065743`*^-15}, {
           2.270339450563189, -9.643274665532871*^-16}, {2.271873986882943, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.1298290071134236`, 1.4464911998299308`*^-15}, {
           3.131305243988792, 0.}, {
           3.1332735598226167`, -1.9286549331065743`*^-15}, {
           3.134995836177213, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.374605296118967, 1.4464911998299308`*^-15}, {
           3.3760984702695067`, 0.}, {3.3780893691368927`, 0.}, {
           3.3795825432874325`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.744770324920563, 
           1.4464911998299308`*^-15}, {-1.743373248839608, 
           0.}, {-1.7415104807316681`, 0.}, {-1.7401134046507132`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.1713618579390452`, 1.4464911998299308`*^-15}, {
           2.172742940626824, 0.}, {2.1741240233146026`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.9314529835304335`, 
           1.4464911998299308`*^-15}, {-1.9300728447246498`, 
           0.}, {-1.928692705918866, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.1988782412103207`, 
           1.4464911998299308`*^-15}, {-1.1972085766766791`, \
-9.643274665532871*^-16}, {-1.1955389121430375`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.8674864296809792`, 1.4464911998299308`*^-15}, {
           1.868877980180491, 0.}, {1.870733380846506, 0.}, {
           1.8721249313460175`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.9613411016937468`, 1.4464911998299308`*^-15}, {
           2.963011814985161, -9.643274665532871*^-16}, {2.9650166709348573`, 
           0.}, {2.967021526884554, -9.643274665532871*^-16}, {
           2.9686922401759683`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.4991994274850343, 
           1.4464911998299308`*^-15}, {-0.4975530247552433, \
-9.643274665532871*^-16}, {-0.49557734147949406`, 0.}, {-0.49409557902268214`,
            1.4464911998299308`*^-15}}], 
          LineBox[{{-1.538086058001474, 
           1.4464911998299308`*^-15}, {-1.536716387007423, 
           0.}, {-1.534890159015355, -9.643274665532871*^-16}, \
{-1.5333683023552984`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.6774046571289152, 
           1.4464911998299308`*^-15}, {-0.6760115793962542, 
           0.}, {-0.6741541424193729, 0.}, {-0.6727610646867119, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.43383723911233096`, 
           1.4464911998299308`*^-15}, {-0.432355476655519, 
           0.}, {-0.43087371419870707`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.897172840337224, 1.4464911998299308`*^-15}, {
           1.8985643908367358`, 0.}, {
           1.900419791502751, -9.643274665532871*^-16}, {1.9019659587244304`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.9756174253155094`, 
           1.4464911998299308`*^-15}, {-1.9742372865097257`, 
           0.}, {-1.972857147703942, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.7318861788406448`, 
           1.4464911998299308`*^-15}, {-1.730333872084028, \
-9.643274665532871*^-16}, {-1.728471103976088, 0.}, {-1.727074027895133, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7517021362041656, 
           1.4464911998299308`*^-15}, {-0.7503090584715046, 
           0.}, {-0.7484516214946233, 0.}, {-0.7465941845177421, 
           0.}, {-0.7452011067850811, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.6003427272286188, 1.4464911998299308`*^-15}, {
           0.601721338801253, 0.}, {0.6035594875647652, 0.}, {
           0.6049380991373994, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.8954913325732763`, 1.4464911998299308`*^-15}, {
           3.897035793829105, 0.}, {
           3.899095075503543, -9.643274665532871*^-16}, {3.900811143565575, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.1828494616873622`, 
           1.4464911998299308`*^-15}, {-1.1811797971537206`, \
-9.643274665532871*^-16}, {-1.1791761997133507`, 0.}, {-1.1776735016330733`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.056105699293544, 
           1.4464911998299308`*^-15}, {-1.0546304063001708`, 
           0.}, {-1.0526633489756732`, -9.643274665532871*^-16}, \
{-1.0510241345385918`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.7312778045155035`, 1.4464911998299308`*^-15}, {
           2.732764509202605, 0.}, {2.73474678211874, 0.}, {
           2.7362334868058413`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7219831445740654, 
           1.4464911998299308`*^-15}, {-0.7205900668414045, 
           0.}, {-0.7187326298645231, 0.}, {-0.7173395521318622, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.604367048434679, 
           1.4464911998299308`*^-15}, {-0.602773763681296, \
-1.9286549331065743`*^-15}, {-0.6009528668202869, 0.}, {-0.5995871941745301, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.5800570720530724`, 1.4464911998299308`*^-15}, {
           2.5814276869291186`, 0.}, {
           2.5832551734305134`, -9.643274665532871*^-16}, {
           2.5847780788483425`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.679302178572285, 1.4464911998299308`*^-15}, {
           3.6809496300598483`, -9.643274665532871*^-16}, {
           3.6829265718449244`, 0.}, {3.6844092781837317`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.42000745618208635`, 
           1.4464911998299308`*^-15}, {-0.41852569372527443`, 
           0.}, {-0.4165500104495252, 
           
           0.}, {-0.41457432717377596`, -9.643274665532871*^-16}, \
{-0.41292792444398496`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.0302274351466596`, 1.4464911998299308`*^-15}, {
           2.031743152271779, -9.643274665532871*^-16}, {2.033258869396898, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.881894384090298, 1.4464911998299308`*^-15}, {
           2.8832819362415156`, 0.}, {2.885132005776472, 0.}, {
           2.8865195579276897`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.0096247158156078`, 1.4464911998299308`*^-15}, {
           3.0111283577778805`, 0.}, {
           3.013133213727577, -9.643274665532871*^-16}, {3.0151380696772736`, 
           0.}, {3.0166417116395463`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2088962284121698`, 
           1.4464911998299308`*^-15}, {-1.2072265638785282`, \
-9.643274665532871*^-16}, {-1.2055568993448866`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.47549122817604367`, 
           1.4464911998299308`*^-15}, {-0.47384482544625267`, \
-9.643274665532871*^-16}, {-0.4721984227164617, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.361626005884551, 
           1.4464911998299308`*^-15}, {-1.3602393976153286`, 
           0.}, {-1.3588527893461064`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.3380004753255267, 1.4464911998299308`*^-15}, {
           0.33950564452094867`, 0.}, {0.34101081371637065`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.3183727901982474`, 1.4464911998299308`*^-15}, {
           1.3198739610453754`, 0.}, {1.3213751318925033`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.9259324283072992`, 
           1.4464911998299308`*^-15}, {-1.9245522895015155`, 
           0.}, {-1.9231721506957318`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.561827021898356, 
           1.4464911998299308`*^-15}, {-1.5604573509043052`, 
           0.}, {-1.5590876799102542`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.969527596821675, 1.4464911998299308`*^-15}, {
           2.9710312387839473`, 0.}, {
           2.972701952075361, -2.410818666383218*^-15}}], 
          LineBox[{{3.4628563567937003`, 1.4464911998299308`*^-15}, {
           3.4642503784083565`, 0.}, {3.4656444000230127`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.39402621759956624`, 1.4464911998299308`*^-15}, {
           0.39569862781670173`, -9.643274665532871*^-16}, {
           0.3973710380338372, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.7782401439205278`, 
           1.4464911998299308`*^-15}, {-1.7764945438675492`, \
-1.9286549331065743`*^-15}, {-1.7747489438145707`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.1210185910019674`, 
           1.4464911998299308`*^-15}, {-1.119543298008594, 
           0.}, {-1.1180680050152207`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.9624577955190401, 1.4464911998299308`*^-15}, {
           0.9639779552533749, -9.643274665532871*^-16}, {0.9654981149877099, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.1445815117401064`, 1.4464911998299308`*^-15}, {
           1.1460657453120628`, 0.}, {1.1475499788840193`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.957498461123495, 1.4464911998299308`*^-15}, {
           2.9590021030857674`, 0.}, {2.96050574504804, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.5029861537635537, 
           1.4464911998299308`*^-15}, {-0.5015043913067417, 
           0.}, {-0.5000226288499299, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.7937737696840418, 1.4464911998299308`*^-15}, {
           0.795268471067731, 0.}, {0.7967631724514203, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.18056907585757, 1.4464911998299308`*^-15}, {
           2.181950158545349, 0.}, {2.1833312412331276`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.4664524789080347`, 
           1.4464911998299308`*^-15}, {-1.4649667181029287`, 
           0.}, {-1.4634809572978227`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.818992019901775, 1.4464911998299308`*^-15}, {
           2.8203795720529925`, 0.}, {2.82176712420421, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.878194245020385, 1.4464911998299308`*^-15}, {
           2.8795817971716025`, 0.}, {2.88096934932282, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.029741892892857117`, 
           1.4464911998299308`*^-15}, {-0.02836975078366162, 
           0.}, {-0.026997608674466125`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.2131934309344032`, 1.4464911998299308`*^-15}, {
           3.214723524644942, -9.643274665532871*^-16}, {3.2162536183554806`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.142451221216982, 1.4464911998299308`*^-15}, {
           2.1439314564406446`, 0.}, {2.145411691664307, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.998455416295192, 1.4464911998299308`*^-15}, {
           3.9999998775510206`, 0.}}]},
         Annotation[#, "Charting`Private`Tag$792334#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], 
          LineBox[{{-1.9999998775510204`, 
           0.}, {-1.998159692476642, -9.643274665532871*^-16}, \
{-1.996319507402264, -9.643274665532871*^-16}, {-1.9944793223278858`, 
           0.}, {-1.9926391372535077`, -1.9286549331065743`*^-15}, \
{-1.991028975313427, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.9444876278072787`, 
           1.4464911998299308`*^-15}, {-1.942954140245297, \
-9.643274665532871*^-16}, {-1.941113955170919, 0.}, {-1.8822280327908176`, 
           0.}, {-1.7545498574872482`, 
           0.}, {-1.7526870893793083`, -9.643274665532871*^-16}, \
{-1.7508243212713683`, 0.}, {-1.7470987850554882`, 0.}, {-1.745236016947548, 
           0.}, {-1.743838940866593, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.5253024620569988`, 
           1.4464911998299308`*^-15}, {-1.5239327910629479`, 
           0.}, {-1.5221065630708799`, 0.}, {-1.5202803350788119`, 
           0.}, {-1.518454107086744, 0.}, {-1.5164730926799361`, 
           0.}, {-1.5144920782731282`, -9.643274665532871*^-16}, \
{-1.5125110638663202`, 0.}, {-1.5105300494595122`, 0.}, {-1.5090442886544062`,
            1.4464911998299308`*^-15}}], 
          LineBox[{{-1.4010790034833718`, 
           1.4464911998299308`*^-15}, {-1.3995932426782658`, 
           0.}, {-1.3976122282714578`, 0.}, {-1.3956312138646498`, 
           0.}, {-1.3936501994578419`, 
           0.}, {-1.3916691850510339`, -9.643274665532871*^-16}, \
{-1.3901285091963425`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2785835773166834`, 
           1.4464911998299308`*^-15}, {-1.2770429014619917`, \
-9.643274665532871*^-16}, {-1.275194090436362, 
           0.}, {-1.2733452794107323`, -1.9286549331065743`*^-15}, \
{-1.2715921316504086`, 1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQHTnVQCOt6tP+fWVXkg/z3bJJuqV907z4035Nf4u3
OvEP93hoTnnDlP1pPwMU6FX8+X82CcEXOZ4iPDMKpv7int+iZ9VSghDySZz3
u0K9EPxTfz68c3NC8I0+MAVbWCH4sx6LbNc0QtjPdF1NWloLIZ91yqKeRwnB
v7TX6/FfSYT9Vhtj3N8LIuQXLclb/YATIc81o4H/EiNCvqh7UvHhnx/h8jfr
llzf8hHBZ5GPY/j36iM8fADi1nnB
           "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBmIQ/Y65/HLG2g/795VdST7Md8umpqrlXuzyD/sZoOBJ
7jQn//kIvk/iimUO0xH8zSG7uIz6EXwpjzN5yu0IfpP1vUsi9Qh+kBLT7O95
CP4uUZH/L9IQfCVOteRbcR/2a/pbvNWJf7in64/58dNhCPlP7z219/oh5PcJ
5OtbuiPkOw2nGG+1R/BDgnaaG1og+ArF96zXGsD0X9zzejKzg6Ymgr9ti4bL
UkWE+U1XfT0UpRD6fb8V+cwVQvAlxGcESHIjhZf53pCpzAh+/MYjG5V+vIfz
v33i2yX18j3c/F6TyENCtxDyKmWLT3GdRvBD1G9fOLL/PTx+ALwLmGY=
           "]], 
          LineBox[{{-0.8039687378155105, -2.410818666383218*^-15}, \
{-0.8023107041837942, 0.}, {-0.7983314234676752, 0.}, {-0.7903728620354371, 
           0.}, {-0.7744557391709609, 
           0.}, {-0.7725983021940797, -1.9286549331065743`*^-15}, \
{-0.7707408652171983, 0.}, {-0.7688834282403171, 
           0.}, {-0.7670259912634358, -1.9286549331065743`*^-15}, \
{-0.7651685542865546, 0.}, {-0.7637754765538937, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.6738445695898927, -2.410818666383218*^-15}, \
{-0.6722967054424916, 0.}, {-0.6704392684656104, 0.}, {-0.6685818314887292, 
           0.}, {-0.666724394511848, 0.}, {-0.6630095205580855, 
           0.}, {-0.6611520835812043, 0.}, {-0.659294646604323, 
           0.}, {-0.6574372096274417, 
           0.}, {-0.6555797726505604, -1.9286549331065743`*^-15}, \
{-0.6537588757895514, 0.}, {-0.6523932031437945, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.5422289430527429, 
           1.4464911998299308`*^-15}, {-0.540863270406986, 
           0.}, {-0.539042373545977, -9.643274665532871*^-16}, \
{-0.5370666902702277, 0.}, {-0.5355849278134158, 1.4464911998299308`*^-15}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAmIQzXB00R3v9tv795VdST7Md8tmwczpQj+zbu/X9Ld4
qxP/cE/Yr8sls7xu72eAAt5ogevWWjD5i3uO7PaxvMuJ4FfJdM6ue3kLrt6w
9uhf+ZO34PIv7jImHFyB4M+zszuU1IHgh86vUmHJuAW3f9ZWZvYLngjz7p3u
eTlbG8FXfiR6Jp0Xwc/4MW+d8fubcP5aPo2J/y8g+J9UNhaf3oTg1wQetkgu
Q/APpvtI60fchNvPVnf17y9LhLz3lLgHx6Rvwt07YdXzQ5P+3oDzrx4oWBp3
/wZcvdT1n+1aBxH8+LdNWd8WIdQvYebxPdSC4L+UnKrfl4bg6xnICUV5IPQX
uy3/oqqFkN8RY3D9I/cNuHv/Fu3cufftdbh6p06nOZ3nEfy2+afrQjdeh6s/
vTUkUXEyQr6+zdq7quY6PD0AADpA5BE=
           "]], 
          LineBox[{{-0.17022385289087172`, 
           1.4464911998299308`*^-15}, {-0.16872515315888842`, 
           0.}, {-0.16672688684957734`, 
           0.}, {-0.16476516065613844`, -1.9286549331065743`*^-15}, \
{-0.16280343446269951`, -1.9286549331065743`*^-15}, {-0.16182257136598005`, \
-2.410818666383218*^-15}}], 
          LineBox[{{0.05441615647113327, 1.4464911998299308`*^-15}, {
           0.05578829858032877, 0.}, {
           0.05761782139258943, -9.643274665532871*^-16}, {
           0.059447344204850094`, -9.643274665532871*^-16}, {
           0.06127686701711075, -9.643274665532871*^-16}, {0.0631063898293714,
            0.}, {0.06493591264163207, -9.643274665532871*^-16}, {
           0.06676543545389273, 0.}, {0.06859495826615339, 0.}, {
           0.07042448107841405, -9.643274665532871*^-16}, {
           0.07225400389067471, 0.}, {
           0.07408352670293537, -9.643274665532871*^-16}, {
           0.07591304951519603, -9.643274665532871*^-16}, {
           0.0838502864231991, -9.643274665532871*^-16}, {
           0.09178752333120216, -9.643274665532871*^-16}, {
           0.09377183255820293, 0.}, {0.0952600644784535, 
           1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQvV9w6s2pa/fa7yu7knyY75aNwNOPDV8k99lr+lu8
1Ym/uOeGqN6G/7P32TNAwQK3rPtccvvh/IzyZXxiCxD8y/+cj5jfOAjnm4k/
iraVPAQ3b5Z+w2enqENw+aSEPUp+dxD8TwdNGlMeHIbzBVtV7Sa+OArn+3Oz
73j14yScP20Ht/9s01Nw/r1UgWfeRQh+3gFJkbWvEfyeUp2C/Hun4fwT9wM1
vhw+C+crRPmdqTt+Ac6fqTfTpmPSFThfXHKO28tTd+D+cdi8OS73/D04f+uy
1N0/Mh/A+REKz/84dCH4v2Zm2HWuQvBDzDnX/9n+AB7+AMCVifs=
           "]], 
          LineBox[{{0.5626873791354213, 1.4464911998299308`*^-15}, {
           0.5641651432439392, 0.}, {0.5661354953886297, 0.}, {
           0.5681058475333202, -9.643274665532871*^-16}, {0.5700761996780106, 
           0.}, {0.5720465518227011, -9.643274665532871*^-16}, {
           0.5740169039673916, -9.643274665532871*^-16}, {
           0.575987256112082, -1.9286549331065743`*^-15}, {0.5778254048755942,
            0.}, {0.5796635536391064, -9.643274665532871*^-16}, {
           0.5815017024026186, -9.643274665532871*^-16}, {0.5833398511661309, 
           0.}, {0.5851779999296431, -9.643274665532871*^-16}, {
           0.5870161486931553, 0.}, {0.5906924462201797, 0.}, {
           0.5925305949836919, 0.}, {0.5939092065563261, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.6755536474689932, 1.4464911998299308`*^-15}, {
           0.6770854381052533, -9.643274665532871*^-16}, {0.6789235868687655, 
           0.}, {0.6936287769768632, 0.}, {
           0.6956217121551155, -9.643274665532871*^-16}, {
           0.6976146473333678, -9.643274665532871*^-16}, {
           0.6996075825116201, -9.643274665532871*^-16}, {0.7016005176898724, 
           0.}, {0.7030952190735617, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.7220281032669585, 1.4464911998299308`*^-15}, {
           0.7235228046506479, 0.}, {0.7255157398289002, 0.}, {
           0.7574027026809371, 0.}, {0.821176628385011, 0.}, {
           0.8230373601820851, -9.643274665532871*^-16}, {0.8248980919791591, 
           0.}, {0.8267588237762331, 0.}, {
           0.8286195555733072, -9.643274665532871*^-16}, {0.8304802873703814, 
           0.}, {0.8323410191674554, -9.643274665532871*^-16}, {
           0.8342017509645294, -9.643274665532871*^-16}, {0.8360624827616034, 
           0.}, {0.8509483371381958, 0.}, {0.8807200458913806, 0.}, {
           0.8825807776884547, 0.}, {0.8839763265362602, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.9163840720019665, 1.4464911998299308`*^-15}, {
           0.9179346818328616, -9.643274665532871*^-16}, {0.9197954136299358, 
           0.}, {0.9216561454270098, 0.}, {0.9235168772240838, 0.}, {
           0.9253776090211578, 0.}, {
           0.9272383408182319, -9.643274665532871*^-16}, {
           0.9290990726153059, -1.9286549331065743`*^-15}, {
           0.9309598044123799, 0.}, {0.9328205362094539, 0.}, {
           0.934681268006528, 0.}, {
           0.936541999803602, -1.9286549331065743`*^-15}, {
           0.938402731600676, -9.643274665532871*^-16}, {
           0.9402634633977501, -9.643274665532871*^-16}, {0.9417836231320851, 
           1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQLe8dKWxe/MF+X9mV5MN8t2yOnpITKaz8YK/pb/FW
J/7iHrXpNx6+bEDwO5InrU/qQPBf6vvU3u7/YM8ABV5/WL1DpiP4a07slzg7
D8HPSzTesm8tgn9B922j+VYE3/DXMv8NexD8SccSZDWPwOx7uOfLJKnXC08j
7N+m3dc2+RaCX3mEUan1JYKvq3tByufDJzhfK06Aq4/vM5yv0R/w87wOgp8+
W6E0wQTBX7b8w4cP1p/h7rm24YzvXMfP8PACAMYDh0I=
           "]], 
          LineBox[{{1.293087730984713, 1.4464911998299308`*^-15}, {
           1.2944728120207858`, 0.}, {1.2963195867355495`, 0.}, {
           1.2981663614503134`, 0.}, {1.3018599108798408`, 0.}, {
           1.3038614720093447`, 0.}, {1.3058630331388486`, 0.}, {
           1.3078645942683522`, 0.}, {
           1.3098661553978561`, -9.643274665532871*^-16}, {1.311534123005776, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.4144477244144325`, 1.4464911998299308`*^-15}, {
           1.4159488952615604`, 0.}, {1.4179504563910643`, 0.}, {
           1.419952017520568, 0.}, {1.4219535786500719`, 0.}, {
           1.4239551397795758`, 0.}, {1.4259567009090794`, 0.}, {
           1.4279582620385833`, -9.643274665532871*^-16}, {
           1.4299598231680872`, -9.643274665532871*^-16}, {
           1.431924844181719, -1.9286549331065743`*^-15}, {
           1.4338898651953507`, 0.}, {1.4358548862089824`, 0.}, {
           1.437819907222614, -9.643274665532871*^-16}, {1.439457424733974, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.5345971921439758`, 1.4464911998299308`*^-15}, {
           1.5360709579041996`, 0.}, {1.540000999931463, 0.}, {
           1.5419660209450947`, 0.}, {1.5439310419587264`, 0.}, {
           1.5458960629723582`, 0.}, {
           1.5478610839859899`, -9.643274665532871*^-16}, {
           1.5498261049996216`, 0.}, {
           1.5517911260132533`, -9.643274665532871*^-16}, {
           1.553756147026885, -9.643274665532871*^-16}, {1.5557211680405167`, 
           0.}, {1.5575539856729703`, 0.}, {1.5593868033054237`, 0.}, {
           1.561219620937877, 0.}, {
           1.5630524385703306`, -9.643274665532871*^-16}, {
           1.5648852562027842`, 0.}, {1.5667180738352375`, 0.}, {
           1.5680926870595775`, 1.4464911998299308`*^-15}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQ3b/V5vaSrp/2+8quJB/mu2Xz7PXM1GcTftpr+lu8
1Ym/uKdp8jW7jBk/7RmgQM5aWOLVfAR/5yP/j9nLEepDunpOvV2HkP9geHJx
/jYEP+7Cbo7yKwj+mcMBBpuO/ILzuX9f5dxz9g+cn36z/57sln9w/jLvgiOl
HgwOMP6hxTfbGnwQ/Pu/nTy7AxgcYO75E7yGe1oIQl5ijei5BREIeROW+gmr
YxDygTEvgrYlIPh5WwJFD6Yg1Hfx7L5+OgMhvyxFZda1HAT/8J7emIcFCP4D
ke9yb0oQ/K9ixwy+lDM4wMIbAOcre+4=
           "]], 
          LineBox[{{2.1483721621116314`, 1.4464911998299308`*^-15}, {
           2.149852397335294, 0.}, {2.1518260443001775`, 0.}, {
           2.1537996912650605`, -9.643274665532871*^-16}, {2.155773338229944, 
           0.}, {2.1577469851948274`, 0.}, {2.1597206321597104`, 0.}, {
           2.161694279124594, -1.9286549331065743`*^-15}, {
           2.163535722708299, -9.643274665532871*^-16}, {
           2.1653771662920036`, -9.643274665532871*^-16}, {2.166911702611758, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.245019601287245, 1.4464911998299308`*^-15}, {
           2.2464006839750237`, 0.}, {2.250083571142434, 0.}, {
           2.251925014726139, 0.}, {2.253766458309844, 0.}, {
           2.2574493454772537`, 0.}, {2.2648151198120736`, 0.}, {
           2.279546668481714, 0.}, {2.2815428984801587`, 0.}, {
           2.283539128478604, -9.643274665532871*^-16}, {
           2.2855353584770493`, -9.643274665532871*^-16}, {
           2.2875315884754945`, 0.}, {2.28952781847394, 0.}, {
           2.2910249909727733`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.305830363461241, 1.4464911998299308`*^-15}, {
           2.307493888459945, -9.643274665532871*^-16}, {
           2.30949011845839, -9.643274665532871*^-16}, {2.3114863484568353`, 
           0.}, {2.3434260284319572`, 0.}, {2.4073053883822, 0.}, {
           2.526603091887278, 0.}, {2.5284305783886727`, 0.}, {
           2.5302580648900674`, -1.9286549331065743`*^-15}, {
           2.532085551391462, 0.}, {
           2.533913037892857, -9.643274665532871*^-16}, {
           2.5357405243942517`, -9.643274665532871*^-16}, {
           2.537111139270298, -2.410818666383218*^-15}}], 
          LineBox[{{2.878194245020385, 1.4464911998299308`*^-15}, {
           2.8795817971716025`, 0.}, {
           2.881431866706559, -9.643274665532871*^-16}, {2.8832819362415156`, 
           0.}, {2.885132005776472, 0.}, {2.886982075311429, 0.}, {
           2.888832144846385, 0.}, {
           2.8908370007960817`, -9.643274665532871*^-16}, {
           2.892841856745778, -9.643274665532871*^-16}, {2.894846712695475, 
           0.}, {2.8968515686451717`, 0.}, {2.904870992443958, 0.}, {
           2.9068758483936548`, 0.}, {2.9083794903559275`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.1198234016248154`, 1.4464911998299308`*^-15}, {
           3.121463664819669, -9.643274665532871*^-16}, {
           3.1234319806534936`, -9.643274665532871*^-16}, {
           3.125400296487318, -9.643274665532871*^-16}, {3.127368612321143, 
           0.}, {3.1293369281549674`, 0.}, {3.131305243988792, 0.}, {
           3.1332735598226167`, -9.643274665532871*^-16}, {
           3.135241875656441, -9.643274665532871*^-16}, {3.137210191490265, 
           0.}, {3.1391785073240897`, 0.}, {3.1411468231579143`, 0.}, {
           3.143115138991739, -1.9286549331065743`*^-15}, {
           3.1447217373878043`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.233543677284566, 1.4464911998299308`*^-15}, {
           3.2349207616240507`, 0.}, {3.2385929865293432`, 0.}, {
           3.2459374363399283`, 0.}, {
           3.2477735487925745`, -9.643274665532871*^-16}, {
           3.2496096612452208`, 0.}, {3.2532818861505133`, 0.}, {
           3.2551179986031595`, -9.643274665532871*^-16}, {
           3.256954111055806, -9.643274665532871*^-16}, {3.258790223508452, 
           0.}, {3.2606263359610983`, -1.9286549331065743`*^-15}, {
           3.2626172348284848`, 0.}, {3.264608133695871, 0.}, {
           3.266101307846411, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.3726143972515805`, 1.4464911998299308`*^-15}, {
           3.3741075714021203`, 0.}, {3.3760984702695067`, 0.}, {
           3.3780893691368927`, 0.}, {3.380080268004279, 0.}, {
           3.3820711668716656`, -9.643274665532871*^-16}, {
           3.3840620657390517`, -9.643274665532871*^-16}, {
           3.386052964606438, -9.643274665532871*^-16}, {3.3880438634738246`, 
           0.}, {3.3894378850884808`, 1.4464911998299308`*^-15}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBmIQXfN8QqnBNW6HfWVXkg/z3bL5cedXMPdNbgcGKHAS
O+C/4gGC/3zTorNlTxD8Hv9Wb9cXCL7hm/STwm8Q/GsdXu6P3nM7aPpbvNWJ
v7inWlX36IbPMP7DPQqH+J3rvyPUH437dMD3N4Kf9fuKncx/BJ9/xvY9r5h4
4OZtMZlltZMNwY+4WLOjnYsHrv5vbrxZGB+Cz8h+aab2XwTfzKPokBcDH5z/
686aF6KfEHyXnBMTfL8h+L2/H1u0/kLwFaSkO78w8SPcu9LMUIcdwd9iEXQz
mRvB/3c8t3E2Pz/cve7hnZqXhRH8Cc+WXOSSQKjnmLSz30SaHx4/ABRweyU=

           "]], 
          LineBox[{{-1.7039446572215449`, 
           1.4464911998299308`*^-15}, {-1.702392350464928, \
-9.643274665532871*^-16}, {-1.698666814249048, -9.643274665532871*^-16}, \
{-1.694941278033168, -9.643274665532871*^-16}, {-1.6933889712765515`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.0838084232802196`, 
           1.4464911998299308`*^-15}, {-1.0821692088431383`, \
-9.643274665532871*^-16}, {-1.066432750247157, -9.643274665532871*^-16}, \
{-1.0506962916511755`, -9.643274665532871*^-16}, {-1.0487292343266779`, 
           0.}, {-1.0467621770021802`, 
           0.}, {-1.0447951196776826`, -1.9286549331065743`*^-15}, \
{-1.0430739445187471`, 1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQPUfS0OCl0Pv9+8quJB/mu2Vz5lSG2WL29/sZoCCZ
Z7Pd7B/v9mv6W7zVib+455fvX7fJL9/B5Sf0u/t330Lw1S9ODG8+jVC/T+hO
fPUehHxoiFpG8VoE/83UgoLseQi+pCRrY3QDgr8hyr8zuBDBd5szc6J3EsL8
u3cfz3QORsiXyOstsnZByHMnVqwyNkXIL1p0aJO2Gkz+4R6LJzy7lcUR8udV
ww9LcyD4DNf7Tl798xYePgAPFXH1
           "]], 
          LineBox[{{-0.7164108336434216, 
           1.4464911998299308`*^-15}, {-0.7150177559107607, 
           0.}, {-0.7136246781780997, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.6241693017981531, 
           1.4464911998299308`*^-15}, {-0.6228036291523963, 
           0.}, {-0.6191618354303781, 0.}, {-0.6118782479863416, 
           0.}, {-0.5973110730982687, 
           0.}, {-0.5954901762372595, -9.643274665532871*^-16}, \
{-0.5936692793762505, 0.}, {-0.5900274856542322, 0.}, {-0.5893446493313538, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.49903478721205524`, 
           1.4464911998299308`*^-15}, {-0.4975530247552433, 
           0.}, {-0.49557734147949406`, -9.643274665532871*^-16}, \
{-0.49360165820374485`, 0.}, {-0.49162597492799565`, 
           0.}, {-0.4758205087220019, 
           0.}, {-0.47384482544625267`, -9.643274665532871*^-16}, \
{-0.47186914217050346`, -1.9286549331065743`*^-15}, {-0.47014041930422285`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.364207296665539, 
           1.4464911998299308`*^-15}, {-0.3628246867446108, 
           0.}, {-0.36098120685003987`, 
           0.}, {-0.3591377269554689, -9.643274665532871*^-16}, \
{-0.35729424706089796`, -9.643274665532871*^-16}, {-0.355450767166327, 
           0.}, {-0.35360728727175605`, -9.643274665532871*^-16}, \
{-0.3517638073771851, -9.643274665532871*^-16}, {-0.34992032748261415`, \
-9.643274665532871*^-16}, {-0.3480768475880432, 0.}, {-0.346694237667115, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.10959161146566869`, 
           1.4464911998299308`*^-15}, {-0.10787510104640964`, \
-1.9286549331065743`*^-15}, {-0.10591337485297073`, -9.643274665532871*^-16}, \
{-0.1039516486595318, 
           0.}, {-0.10198992246609287`, -9.643274665532871*^-16}, \
{-0.10002819627265395`, -9.643274665532871*^-16}, {-0.09806647007921504, 
           0.}, {-0.09659517543413584, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.015843717179304342`, 1.4464911998299308`*^-15}, {
           0.017368319522854895`, -9.643274665532871*^-16}, {
           0.021027365147376215`, -9.643274665532871*^-16}, {
           0.024686410771897538`, -9.643274665532871*^-16}, {
           0.02621101311544809, 1.4464911998299308`*^-15}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQrde0WTxr/mP7fWVXkg/z3bLZ5q3usHXVY3sGKDiw
9qDCkZ0I/in+GMbLJxD8K4XfHj68juDfuzzh0IdnCP4LU+3F/78i+H9+xqfI
ijyB89lifrnoKCP4AvumqFobPbHX9Ld4qxP/cI+Ugj6blyNCXrXp5LOIAJj8
xT0GT5KPp8cj+FZu/5aX5SHUu6yY0dFai+D7cRlnTulB8CNyznouno3Qn3Qu
XWvTKgQ/x4CJ++BOhPqySXNenz+B4Dd8MTtz7zrCvZ5c+y5wP30CD08Af/t8
oA==
           "]], 
          LineBox[{{0.9772033449420887, 1.4464911998299308`*^-15}, {
           0.9785714887029902, 0.}, {
           0.9803956803841921, -9.643274665532871*^-16}, {
           0.9822198720653941, -1.9286549331065743`*^-15}, {
           0.9840440637465959, 0.}, {0.9986375971962111, 0.}, {
           1.000461788877413, 0.}, {
           1.0022859805586148`, -9.643274665532871*^-16}, {1.004110172239817, 
           0.}, {1.0059343639210188`, 0.}, {1.0132311306458264`, 0.}, {
           1.0150553223270282`, -9.643274665532871*^-16}, {1.01687951400823, 
           0.}, {1.020527897370634, 0.}, {
           1.0223520890518358`, -9.643274665532871*^-16}, {1.024176280733038, 
           0.}, {1.0260004724142398`, 0.}, {1.0273686161751412`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.2153692950717387`, 1.4464911998299308`*^-15}, {
           1.2169082740007084`, -9.643274665532871*^-16}, {
           1.2187550487154724`, -9.643274665532871*^-16}, {
           1.220601823430236, -9.643274665532871*^-16}, {
           1.2224485981449997`, -9.643274665532871*^-16}, {
           1.2242953728597636`, 0.}, {
           1.2261421475745273`, -1.9286549331065743`*^-15}, {
           1.227988922289291, 0.}, {1.242763120007401, 0.}, {
           1.2441482010434737`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.21540305031599, 1.4464911998299308`*^-15}, {
           2.216937586635744, -9.643274665532871*^-16}, {2.2187790302194488`, 
           0.}, {2.220620473803154, -9.643274665532871*^-16}, {
           2.222461917386859, 0.}, {
           2.2243033609705636`, -1.9286549331065743`*^-15}, {
           2.2261448045542687`, -9.643274665532871*^-16}, {
           2.2279862481379737`, 0.}, {
           2.229827691721679, -1.9286549331065743`*^-15}, {
           2.231669135305384, -9.643274665532871*^-16}, {2.233203671625138, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.572747126047494, 1.4464911998299308`*^-15}, {
           2.5741177409235396`, 0.}, {
           2.5759452274249344`, -9.643274665532871*^-16}, {2.577772713926329, 
           0.}, {2.579600200427724, 0.}, {2.5814276869291186`, 0.}, {
           2.5832551734305134`, -9.643274665532871*^-16}, {
           2.585082659931908, -1.9286549331065743`*^-15}, {
           2.5866817106206286`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.6855203380347255`, 1.4464911998299308`*^-15}, {
           2.6871722321315046`, -9.643274665532871*^-16}, {
           2.6891545050476395`, 0.}, {
           2.691136777963774, -9.643274665532871*^-16}, {
           2.6931190508799085`, -9.643274665532871*^-16}, {
           2.6951013237960435`, 0.}, {2.6970835967121785`, 0.}, {
           2.6990658696283134`, 0.}, {
           2.7010481425444484`, -9.643274665532871*^-16}, {
           2.703030415460583, -9.643274665532871*^-16}, {2.7050126883767174`, 
           0.}, {2.7069949612928523`, -9.643274665532871*^-16}, {
           2.7086468553896315`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.826238125580355, 1.4464911998299308`*^-15}, {
           2.827779850192819, -9.643274665532871*^-16}, {2.8296299197277754`, 
           0.}, {2.831017471878993, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.9374499016265285`, 1.4464911998299308`*^-15}, {
           2.9389535435888012`, 0.}, {2.9409583995384976`, 0.}, {
           2.9429632554881944`, 0.}, {2.944968111437891, 0.}, {
           2.9469729673875875`, 0.}, {
           2.9489778233372843`, -9.643274665532871*^-16}, {
           2.950982679286981, -9.643274665532871*^-16}, {2.9529875352366775`, 
           0.}, {2.9549923911863742`, 0.}, {
           2.956997247136071, -9.643274665532871*^-16}, {2.9590021030857674`, 
           0.}, {2.961006959035464, 0.}, {2.962510600997737, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.070615505779203, 1.4464911998299308`*^-15}, {
           3.0722557689740566`, -9.643274665532871*^-16}, {
           3.074224084807881, -9.643274665532871*^-16}, {3.0761924006417054`, 
           0.}, {3.07816071647553, 0.}, {3.0801290323093546`, 0.}, {
           3.0820973481431793`, 0.}, {3.084065663977004, 0.}, {
           3.0880022956446527`, 0.}, {3.0958755589799507`, 0.}, {
           3.1116220856505468`, 0.}, {3.1135904014843714`, 0.}, {
           3.115558717318196, 0.}, {3.1175270331520206`, 0.}, {
           3.1190032700273886`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.300942038025672, 1.4464911998299308`*^-15}, {
           3.3024352121762117`, 0.}, {3.3044261110435977`, 0.}, {
           3.306417009910984, 0.}, {
           3.3084079087783707`, -9.643274665532871*^-16}, {
           3.310398807645757, -9.643274665532871*^-16}, {3.3123897065131436`, 
           0.}, {3.3143806053805296`, -1.9286549331065743`*^-15}, {
           3.316371504247916, 0.}, {3.3183624031153025`, 0.}, {
           3.3203533019826885`, -9.643274665532871*^-16}, {
           3.322344200850075, -9.643274665532871*^-16}, {3.3243350997174614`, 
           0.}, {3.326325998584848, 0.}, {
           3.3283168974522344`, -9.643274665532871*^-16}, {
           3.3299759798417226`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.4089541876936655`, 1.4464911998299308`*^-15}, {
           3.4103482093083217`, 0.}, {
           3.41220690479453, -9.643274665532871*^-16}, {
           3.414065600280738, -9.643274665532871*^-16}, {3.415924295766946, 
           0.}, {3.417782991253154, -9.643274665532871*^-16}, {
           3.432652555142819, -9.643274665532871*^-16}, {
           3.4475221190324836`, -9.643274665532871*^-16}, {3.449071031937657, 
           1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQvSbyeHKALL/DvrIryYf5btmosN5RrFLgd2CAgrwp
309uVEHwdygLF73U4HfQ9Ld4qxN/cQ/jZj0pRV2E/JSLqVkTTBF8vWNyb7gq
EfyKUKspTrUI/QefhNpUNcL4D/dwlRQ+2diKUB/C3NvzshOhft6kFSaKfQj5
F4pH7kRMQvCNNt5vmTANwa92+K1zYhaCf+S82NX/8xDm8cUb1ZovRvAj3vmq
5i9HqF9Um3l22WqE/Bue1tJ76xHypnMWyIptQfDXuG+9bb8dEZ4AQZdqpg==

           "]], 
          LineBox[{{-1.7261426438411631`, 
           1.4464911998299308`*^-15}, {-1.7247455677602082`, 
           0.}, {-1.7228827996522682`, 0.}, {-1.7210200315443283`, 
           0.}, {-1.7172944953284481`, 0.}, {-1.7098434228966881`, 
           0.}, {-1.7079806547887482`, -1.9286549331065743`*^-15}, \
{-1.7063507326943006`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.6332020992550085`, 
           1.4464911998299308`*^-15}, {-1.631680242594952, \
-9.643274665532871*^-16}, {-1.6298540146028841`, 0.}, {-1.6280277866108164`, 
           0.}, {-1.6262015586187486`, 0.}, {-1.6243753306266806`, 
           0.}, {-1.6207228746425448`, 0.}, {-1.618896646650477, 
           0.}, {-1.617070418658409, 0.}, {-1.6134179626742733`, 
           0.}, {-1.6061130507060017`, 
           0.}, {-1.604286822713934, -9.643274665532871*^-16}, \
{-1.602460594721866, 0.}, {-1.5988081387377302`, 0.}, {-1.5969819107456624`, 
           0.}, {-1.5956122397516115`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.4884087219168232`, 
           1.4464911998299308`*^-15}, {-1.4867578765778164`, \
-9.643274665532871*^-16}, {-1.4847768621710085`, 0.}, {-1.4827958477642005`, 
           0.}, {-1.4808148333573925`, -9.643274665532871*^-16}, \
{-1.4788338189505845`, -1.9286549331065743`*^-15}, {-1.4768528045437765`, 
           0.}, {-1.4753670437386706`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.3728729396237984`, 
           1.4464911998299308`*^-15}, {-1.3713322637691068`, \
-9.643274665532871*^-16}, {-1.3694834527434772`, 0.}, {-1.3676346417178475`, 
           0.}, {-1.365785830692218, 0.}, {-1.3620882086409585`, 
           0.}, {-1.3602393976153286`, -9.643274665532871*^-16}, \
{-1.358390586589699, 0.}, {-1.3546929645384398`, 0.}, {-1.3533063562692176`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2550624527673577`, 
           1.4464911998299308`*^-15}, {-1.253309305007034, \
-1.9286549331065743`*^-15}, {-1.2513057075666643`, 0.}, {-1.2493021101262944`,
            0.}, {-1.2472985126859246`, 
           0.}, {-1.2452949152455548`, -9.643274665532871*^-16}, \
{-1.243291317805185, -1.9286549331065743`*^-15}, {-1.2412877203648152`, \
-1.9286549331065743`*^-15}, {-1.2402859216446303`, -2.410818666383218*^-15}}],
           LineBox[{{-1.1190515336774696`, 
           1.4464911998299308`*^-15}, {-1.1175762406840963`, 
           0.}, {-1.1156091833595987`, 
           0.}, {-1.113642126035101, -9.643274665532871*^-16}, \
{-1.1116750687106034`, -9.643274665532871*^-16}, {-1.110035854273522, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.9914712085665066, 
           1.4464911998299308`*^-15}, {-0.9898657113661021, \
-1.9286549331065743`*^-15}, {-0.9882602141656976, 1.4464911998299308`*^-15}}],
           LineBox[{{-0.8716165099895341, 
           1.4464911998299308`*^-15}, {-0.8699584763578179, \
-9.643274665532871*^-16}, {-0.8679688359997584, -1.9286549331065743`*^-15}, \
{-0.8659791956416989, 0.}, {-0.8647356704179118, -2.410818666383218*^-15}}], 
          LineBox[{{-0.6461718055353466, 
           1.4464911998299308`*^-15}, {-0.6446543914845057, \
-9.643274665532871*^-16}, {-0.6428334946234966, 
           0.}, {-0.6410125977624874, -1.9286549331065743`*^-15}, \
{-0.6391917009014783, 0.}, {-0.6373708040404692, 0.}, {-0.6355499071794601, 
           0.}, {-0.633729010318451, -1.9286549331065743`*^-15}, \
{-0.6319081134574418, -9.643274665532871*^-16}, {-0.6300872165964327, \
-1.9286549331065743`*^-15}, {-0.6282663197354237, 0.}, {-0.6264454228744145, 
           0.}, {-0.6250797502286576, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.5327860431727711, 
           1.4464911998299308`*^-15}, {-0.53113964044298, \
-9.643274665532871*^-16}, {-0.5291639571672309, 0.}, {-0.5271882738914816, 
           0.}, {-0.5252125906157323, 0.}, {-0.5232369073399832, 
           0.}, {-0.521261224064234, 
           0.}, {-0.5192855407884848, -9.643274665532871*^-16}, \
{-0.5173098575127355, -9.643274665532871*^-16}, {-0.5153341742369864, 
           0.}, {-0.5074314411339894, 
           0.}, {-0.5054557578582402, -9.643274665532871*^-16}, \
{-0.503480074582491, 0.}, {-0.501998312125679, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.1387722885930727, 
           1.4464911998299308`*^-15}, {-0.1373009939479935, 
           0.}, {-0.13533926775455457`, -9.643274665532871*^-16}, \
{-0.13337754156111564`, 
           0.}, {-0.1314158153676767, -1.9286549331065743`*^-15}, \
{-0.12945408917423779`, -9.643274665532871*^-16}, {-0.12749236298079888`, \
-9.643274665532871*^-16}, {-0.12553063678735996`, 
           0.}, {-0.12356891059392103`, -9.643274665532871*^-16}, \
{-0.12193413876605526`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.1061737652269577, 1.4464911998299308`*^-15}, {
           0.10766199714720828`, 0.}, {0.10915022906745886`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.6003427272286188, 1.4464911998299308`*^-15}, {
           0.601721338801253, 0.}, {0.6035594875647652, 0.}, {
           0.6053976363282774, -1.9286549331065743`*^-15}, {
           0.6072357850917895, -1.9286549331065743`*^-15}, {
           0.6090739338553017, 0.}, {0.6109120826188139, 0.}, {
           0.6122906941914481, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.9644340031736754, 1.4464911998299308`*^-15}, {
           0.9658021469345769, 0.}, {0.9676263386157788, 0.}, {
           0.9694505302969807, 0.}, {0.9712747219781825, 0.}, {
           0.9730989136593845, -9.643274665532871*^-16}, {0.9749231053405865, 
           0.}, {0.9762912491014879, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.2044425446760534`, 1.4464911998299308`*^-15}, {
           1.205827625712126, 0.}, {1.2076744004268898`, 0.}, {
           1.2095211751416537`, 0.}, {1.213214724571181, 0.}, {
           1.2145998056072538`, 1.4464911998299308`*^-15}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQnXfuZ4IO/1f7fWVXkg/z3bJh4Zwfxyj21V7T3+Kt
TvzFPa1NMzRM5L7aM0AB25+Jn9LUEPLtpd17ZurB+A/3cLxvaTtjhlDfmVEX
8N8OoZ7rUbmUkTtCviu68EmKP4LPfTVr3fRwhPoev5SKU/EI83lOxDr9TUfI
9zqG8xgUIPh8uwOuJVUg1PebeC2Y2oCQF1jnnHWiA2HfRHVbk98TEPJCC83+
6c5E8CdLGZxIWIhQLzJFc9LklQjzp/AqxxzbiJAXbZdR+7kTwZ/GIPZB+xBC
/TOvCwkRJxHhDQAW15sR
           "]], 
          LineBox[{{2.0635053426216516`, 1.4464911998299308`*^-15}, {
           2.064985577845314, 0.}, {
           2.0669592248101973`, -9.643274665532871*^-16}, {
           2.068932871775081, -1.9286549331065743`*^-15}, {
           2.070906518739964, -9.643274665532871*^-16}, {
           2.0728801657048472`, -9.643274665532871*^-16}, {2.074524871508917, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.18793485019239, 1.4464911998299308`*^-15}, {
           2.189315932880169, 0.}, {2.191157376463874, 0.}, {
           2.192998820047579, -9.643274665532871*^-16}, {2.194840263631284, 
           0.}, {2.1985231507986938`, 0.}, {2.200364594382399, 0.}, {
           2.2022060379661035`, -9.643274665532871*^-16}, {
           2.2040474815498086`, 0.}, {
           2.2058889251335136`, -9.643274665532871*^-16}, {
           2.2077303687172187`, 0.}, {2.209571812300924, 0.}, {
           2.211413255884629, 0.}, {2.213254699468334, 0.}, {
           2.2146357821561127`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.5384817541463436`, -2.410818666383218*^-15}, {
           2.5393954973970407`, -1.9286549331065743`*^-15}, {
           2.5412229838984355`, 0.}, {2.555842875909593, 0.}, {
           2.5576703624109878`, 0.}, {2.5594978489123825`, 0.}, {
           2.563152821915172, 0.}, {2.5649803084165668`, 0.}, {
           2.5668077949179615`, -9.643274665532871*^-16}, {2.568635281419356, 
           0.}, {2.5704627679207506`, -9.643274665532871*^-16}, {
           2.5719856733385797`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.798487082556007, 1.4464911998299308`*^-15}, {
           2.800028807168471, -9.643274665532871*^-16}, {
           2.8018788767034275`, -9.643274665532871*^-16}, {
           2.803728946238384, -9.643274665532871*^-16}, {2.805270670850848, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.9172342708004204`, 1.4464911998299308`*^-15}, {
           2.9189049840918346`, -9.643274665532871*^-16}, {
           2.9209098400415314`, -9.643274665532871*^-16}, {
           2.9229146959912278`, 0.}, {2.9249195519409246`, 0.}, {
           2.9269244078906214`, -9.643274665532871*^-16}, {
           2.9289292638403177`, 0.}, {2.9309341197900145`, 0.}, {
           2.9329389757397113`, -9.643274665532871*^-16}, {
           2.9349438316894076`, 0.}, {2.9364474736516804`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.0291988601091453`, 1.4464911998299308`*^-15}, {
           3.030921136463742, -1.9286549331065743`*^-15}, {
           3.0328894522975665`, 0.}, {3.034857768131391, 0.}, {
           3.0368260839652157`, 0.}, {3.0407627156328645`, 0.}, {
           3.0427310314666887`, -9.643274665532871*^-16}, {
           3.0446993473005133`, 0.}, {3.046667663134338, 0.}, {
           3.0486359789681625`, -1.9286549331065743`*^-15}, {
           3.050604294801987, -9.643274665532871*^-16}, {3.0525726106358118`, 
           0.}, {3.05404884751118, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.2810330493518083`, 1.4464911998299308`*^-15}, {
           3.282526223502348, 0.}, {
           3.2845171223697345`, -9.643274665532871*^-16}, {3.286508021237121, 
           0.}, {3.288498920104507, -9.643274665532871*^-16}, {
           3.2904898189718934`, 0.}, {3.29248071783928, 0.}, {
           3.2944716167066663`, 0.}, {3.296462515574053, 0.}, {
           3.2979556897245925`, 1.4464911998299308`*^-15}}], 
          
          LineBox[{{-1.4369023473398161`, -2.410818666383218*^-15}, \
{-1.4352515020008094`, 0.}, {-1.4312894731871935`, 
           0.}, {-1.4293084587803855`, -9.643274665532871*^-16}, \
{-1.4273274443735775`, -9.643274665532871*^-16}, {-1.4253464299667695`, 
           0.}, {-1.4233654155599615`, -9.643274665532871*^-16}, \
{-1.4217145702209548`, 1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQ/cVnbt2XsM/795VdST7Md8tGoUP77JmAz/sZoIDt
+uQH0z0Q/Deqfz4nOSD4l0pS2PUsEPwdh89I/dRH8OcJmeodUf+8X9Pf4q1O
/MU9LYlzHfvlEfysDayhUeIIfsD/3AxVfhj/4R4zv2vVH9gQ8jJz7fp3//sE
N5/pzbJFbd8Q/BdW/NsC332Cqz/XWX5S5hlCfsuN+3ee30XwZ6l7fNh0FaG+
oWwDc91ZhPyajXZBYcc/wcMHANyrfxg=
           "]], 
          LineBox[{{-0.9363491380192859, 
           1.4464911998299308`*^-15}, {-0.9348200930665196, \
-9.643274665532871*^-16}, {-0.9329852391232002, -9.643274665532871*^-16}, \
{-0.9311503851798808, -1.9286549331065743`*^-15}, {-0.927480677293242, \
-1.9286549331065743`*^-15}, {-0.9238109694066031, -1.9286549331065743`*^-15}, \
{-0.9219761154632837, 
           0.}, {-0.9201412615199642, -9.643274665532871*^-16}, \
{-0.9183064075766448, 0.}, {-0.9164715536333254, 0.}, {-0.914636699690006, 
           0.}, {-0.9128018457466867, -9.643274665532871*^-16}, \
{-0.9109669918033673, -9.643274665532871*^-16}, {-0.9091321378600479, 
           0.}, {-0.9077559974025583, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8137511362426364, -2.410818666383218*^-15}, \
{-0.8122589059740917, -9.643274665532871*^-16}, {-0.8102692656160322, 
           0.}, {-0.8082796252579727, 0.}, {-0.8062899848999132, 
           0.}, {-0.804631951268197, -2.410818666383218*^-15}}], 
          LineBox[{{-0.7126959596896592, 
           1.4464911998299308`*^-15}, {-0.7113028819569982, 
           0.}, {-0.7075880080032356, 
           0.}, {-0.7057305710263544, -9.643274665532871*^-16}, \
{-0.703873134049473, 
           0.}, {-0.7020156970725918, -9.643274665532871*^-16}, \
{-0.7001582600957106, -9.643274665532871*^-16}, {-0.6983008231188294, 
           0.}, {-0.6964433861419481, 0.}, {-0.6945859491650668, 
           0.}, {-0.6927285121881855, 
           0.}, {-0.6908710752113043, -1.9286549331065743`*^-15}, \
{-0.689013638234423, 0.}, {-0.6852987642806605, 0.}, {-0.6834413273037793, 
           0.}, {-0.681583890326898, -9.643274665532871*^-16}, \
{-0.6797264533500167, -9.643274665532871*^-16}, {-0.6781785892026156, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.5695423959678798, 
           1.4464911998299308`*^-15}, {-0.5681767233221229, 
           0.}, {-0.5663558264611137, 
           0.}, {-0.5645349296001047, -9.643274665532871*^-16}, \
{-0.5627140327390956, 0.}, {-0.5608931358780864, 
           0.}, {-0.5590722390170773, -9.643274665532871*^-16}, \
{-0.5572513421560682, 0.}, {-0.5558856695103114, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.4537587121428022, 
           1.4464911998299308`*^-15}, {-0.4521123094130112, \
-9.643274665532871*^-16}, {-0.450136626137262, 0.}, {-0.44816094286151276`, 
           0.}, {-0.44618525958576355`, 
           0.}, {-0.44420957631001434`, -9.643274665532871*^-16}, \
{-0.44223389303426514`, -9.643274665532871*^-16}, {-0.44025820975851593`, \
-1.9286549331065743`*^-15}, {-0.4385294868922353, 1.4464911998299308`*^-15}}],
           LineBox[{{-0.3291811786686909, -2.410818666383218*^-15}, \
{-0.3277985687477627, -9.643274665532871*^-16}, {-0.3259550888531917, 
           0.}, {-0.32411160895862073`, -9.643274665532871*^-16}, \
{-0.32257537571314493`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.034291405536265994`, 1.4464911998299308`*^-15}, {
           0.035663547645461494`, 0.}, {0.037493070457722155`, 0.}, {
           0.03932259326998282, -9.643274665532871*^-16}, {
           0.04115211608224348, 0.}, {
           0.04298163889450414, -9.643274665532871*^-16}, {0.0448111617067648,
            0.}, {0.04664068451902546, -1.9286549331065743`*^-15}, {
           0.048470207331286125`, 0.}, {0.049842349440481624`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.6536490413704725, 1.4464911998299308`*^-15}, {
           0.6550276529431067, 0.}, {0.656865801706619, 0.}, {
           0.6642183967606679, 0.}, {0.66605654552418, 0.}, {
           0.6678946942876922, 0.}, {0.6692733058603264, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.9090962057967599, 1.4464911998299308`*^-15}, {
           0.9104917546445654, 0.}, {0.9123524864416395, 0.}, {
           0.913748035289445, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.2559983387965412`, 1.4464911998299308`*^-15}, {
           1.257537317725511, -9.643274665532871*^-16}, {
           1.264924416584566, -9.643274665532871*^-16}, {
           1.2723115154436209`, -9.643274665532871*^-16}, {
           1.2741582901583846`, 0.}, {
           1.2760050648731482`, -9.643274665532871*^-16}, {
           1.2778518395879122`, 0.}, {1.2796986143026758`, 0.}, {
           1.2815453890174395`, 0.}, {1.2829304700535125`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.3882606329700904`, 1.4464911998299308`*^-15}, {
           1.3899286005780103`, -9.643274665532871*^-16}, {
           1.3919301617075142`, 0.}, {1.393931722837018, 0.}, {
           1.3959332839665217`, 0.}, {1.3979348450960256`, 0.}, {
           1.3999364062255295`, -9.643274665532871*^-16}, {
           1.4019379673550332`, -9.643274665532871*^-16}, {1.403939528484537, 
           0.}, {1.405941089614041, -1.9286549331065743`*^-15}, {
           1.4079426507435449`, 0.}, {1.4099442118730487`, 0.}, {
           1.4114453827201767`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.5228070660621855`, -2.410818666383218*^-15}, {
           1.5242808318224093`, -9.643274665532871*^-16}, {1.526245852836041, 
           0.}, {1.5282108738496727`, -9.643274665532871*^-16}, {
           1.5298483913610326`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.1227147515681497`, 1.4464911998299308`*^-15}, {
           2.124194986791812, 0.}, {2.1261686337566954`, 0.}, {
           2.128142280721579, 0.}, {2.130115927686462, 0.}, {
           2.132089574651345, 0.}, {2.1335698098750076`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.6090684202627132`, 1.4464911998299308`*^-15}, {
           2.6106674709514337`, -1.9286549331065743`*^-15}, {
           2.6124949574528284`, 0.}, {2.614322443954223, 0.}, {
           2.616149930455618, 0.}, {2.6179774169570127`, 0.}, {
           2.6198049034584074`, 0.}, {
           2.621632389959802, -9.643274665532871*^-16}, {
           2.623459876461197, -9.643274665532871*^-16}, {
           2.6252873629625917`, -9.643274665532871*^-16}, {
           2.6271148494639864`, 0.}, {2.628942335965381, 0.}, {
           2.630769822466776, -9.643274665532871*^-16}, {2.632292727884605, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.7174018941025597`, 1.4464911998299308`*^-15}, {
           2.718888598789661, 0.}, {2.722853144621931, 0.}, {
           2.724835417538066, -9.643274665532871*^-16}, {
           2.7268176904542005`, -9.643274665532871*^-16}, {2.728799963370335, 
           0.}, {2.73078223628647, 0.}, {2.7387113279510094`, 0.}, {
           2.740693600867144, 0.}, {
           2.742675873783279, -9.643274665532871*^-16}, {2.7446581466994138`, 
           0.}, {2.7466404196155487`, -9.643274665532871*^-16}, {
           2.7486226925316837`, 0.}, {
           2.750604965447818, -9.643274665532871*^-16}, {2.752256859544597, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.226199227473981, 1.4464911998299308`*^-15}, {
           3.2275763118134657`, 0.}, {3.2312485367187582`, 0.}, {
           3.232625621058243, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.4684324432523246`, 1.4464911998299308`*^-15}, {
           3.4698264648669808`, 0.}, {3.471685160353189, 0.}, {
           3.473543855839397, -9.643274665532871*^-16}, {3.475402551325605, 
           0.}, {3.477261246811813, 0.}, {3.4786552684264693`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.965335302697975, 1.4464911998299308`*^-15}, {
           3.9670513707600072`, -9.643274665532871*^-16}, {
           3.9691106524344457`, 0.}, {3.971169934108884, 0.}, {
           3.9727143953647133`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.990338905910535, 
           1.4464911998299308`*^-15}, {-1.9889587671047513`, 
           0.}, {-1.987118582030373, -9.643274665532871*^-16}, \
{-1.9852783969559948`, -9.643274665532871*^-16}, {-1.9834382118816167`, \
-9.643274665532871*^-16}, {-1.981904724319635, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.5080537814510022`, 
           1.4464911998299308`*^-15}, {-1.5065680206458962`, 
           0.}, {-1.5045870062390883`, -9.643274665532871*^-16}, \
{-1.5026059918322803`, -1.9286549331065743`*^-15}, {-1.5008726042263232`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2670005541828946`, 
           1.4464911998299308`*^-15}, {-1.265330889649253, \
-9.643274665532871*^-16}, {-1.2633272922088832`, 
           0.}, {-1.2613236947685134`, -9.643274665532871*^-16}, \
{-1.2593200973281435`, 0.}, {-1.2573164998877737`, 0.}, {-1.2558138018074962`,
            1.4464911998299308`*^-15}}], 
          LineBox[{{-0.15446609814058407`, 
           1.4464911998299308`*^-15}, {-0.15299480349550487`, 
           0.}, {-0.15103307730206594`, 0.}, {-0.14907135110862701`, 
           0.}, {-0.1471096249151881, 0.}, {-0.14318617252831026`, 
           0.}, {-0.14122444633487136`, 0.}, {-0.13975315168979216`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.03705998414189977, 
           1.4464911998299308`*^-15}, {-0.03568784203270427, 
           0.}, {-0.033858319220443606`, -9.643274665532871*^-16}, \
{-0.032028796408182944`, 0.}, {-0.030199273595922282`, 
           0.}, {-0.02836975078366162, -1.9286549331065743`*^-15}, \
{-0.02654022797140096, 0.}, {-0.024710705159140298`, 
           0.}, {-0.022881182346879636`, -9.643274665532871*^-16}, \
{-0.021356580003329084`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.7039256087311667, 1.4464911998299308`*^-15}, {
           0.7055863880463771, -9.643274665532871*^-16}, {0.7075793232246294, 
           0.}, {0.7095722584028816, -9.643274665532871*^-16}, {
           0.711565193581134, -1.9286549331065743`*^-15}, {0.7133090118621047,
            1.4464911998299308`*^-15}}], 
          LineBox[{{1.5690090958758043`, 1.4464911998299308`*^-15}, {
           1.5703837091001445`, 0.}, {1.572216526732598, 0.}, {
           1.5740493443650514`, -9.643274665532871*^-16}, {1.575576692392096, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.17489129147448, 1.4464911998299308`*^-15}, {
           2.176425827794234, -9.643274665532871*^-16}, {
           2.178267271377939, -9.643274665532871*^-16}, {2.1801087149616443`, 
           0.}, {2.181950158545349, -1.9286549331065743`*^-15}, {
           2.183791602129054, -9.643274665532871*^-16}, {
           2.185633045712759, -9.643274665532871*^-16}, {2.187167582032513, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.2938529834705705`, 1.4464911998299308`*^-15}, {
           2.295516508469275, -9.643274665532871*^-16}, {
           2.299508968466165, -9.643274665532871*^-16}, {
           2.303501428463055, -9.643274665532871*^-16}, {2.3051649534617593`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.655951433702381, 1.4464911998299308`*^-15}, {
           2.657438138389482, 0.}, {
           2.659420411305617, -1.9286549331065743`*^-15}, {2.661402684221752, 
           0.}, {2.663384957137887, -1.9286549331065743`*^-15}, {
           2.665367230054022, 0.}, {2.6673495029701564`, 0.}, {
           2.6688362076572574`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.7836865262763553`, 1.4464911998299308`*^-15}, {
           2.7852282508888186`, -9.643274665532871*^-16}, {2.786769975501282, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.154437832449724, 1.4464911998299308`*^-15}, {
           3.1559679261602627`, -9.643274665532871*^-16}, {
           3.157804038612909, -9.643274665532871*^-16}, {3.159640151065555, 
           0.}, {3.16101723540504, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.2710785550148764`, 1.4464911998299308`*^-15}, {
           3.272571729165416, 0.}, {3.276553526900189, 0.}, {
           3.2785444257675755`, -9.643274665532871*^-16}, {3.280203508157064, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.401364514458316, 1.4464911998299308`*^-15}, {
           3.4029134273634893`, -9.643274665532871*^-16}, {
           3.4047721228496974`, -9.643274665532871*^-16}, {
           3.4066308183359055`, -9.643274665532871*^-16}, {3.408179731241079, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.5746106178428312`, 
           1.4464911998299308`*^-15}, {-1.5732409468487802`, 
           0.}, {-1.5714147188567122`, -9.643274665532871*^-16}, \
{-1.5695884908646445`, 0.}, {-1.5677622628725767`, 
           0.}, {-1.5659360348805087`, -9.643274665532871*^-16}, \
{-1.5641098068884407`, 0.}, {-1.562283578896373, 0.}, {-1.5604573509043052`, 
           0.}, {-1.5586311229122372`, -1.9286549331065743`*^-15}, \
{-1.5568048949201692`, -1.9286549331065743`*^-15}, {-1.5549786669281014`, 
           0.}, {-1.5536089959340504`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.454566392467187, 
           1.4464911998299308`*^-15}, {-1.4530806316620812`, 
           0.}, {-1.4510996172552733`, -9.643274665532871*^-16}, \
{-1.4491186028484653`, -9.643274665532871*^-16}, {-1.4471375884416573`, 
           0.}, {-1.4451565740348493`, -1.9286549331065743`*^-15}, \
{-1.4431755596280413`, 0.}, {-1.4392135308144254`, 
           0.}, {-1.4375626854754187`, -2.410818666383218*^-15}}], 
          LineBox[{{-1.3320450294744757`, 
           1.4464911998299308`*^-15}, {-1.3306584212052535`, 
           0.}, {-1.3288096101796236`, 0.}, {-1.3269607991539938`, 
           0.}, {-1.3251119881283642`, 
           0.}, {-1.3232631771027346`, -9.643274665532871*^-16}, \
{-1.3214143660771047`, 0.}, {-1.3195655550514749`, 
           0.}, {-1.3177167440258453`, -9.643274665532871*^-16}, \
{-1.3158679330002157`, 0.}, {-1.3140191219745858`, 0.}, {-1.312170310948956, 
           0.}, {-1.3103214999233264`, -9.643274665532871*^-16}, \
{-1.3084726888976967`, -9.643274665532871*^-16}, {-1.3066238778720671`, \
-9.643274665532871*^-16}, {-1.3047750668464375`, 0.}, {-1.303388458577215, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8276786187490531, 
           1.4464911998299308`*^-15}, {-0.8261863884805084, 
           0.}, {-0.8222071077643893, 
           0.}, {-0.8202174674063298, -1.9286549331065743`*^-15}, \
{-0.8182278270482704, 0.}, {-0.8162381866902109, 
           0.}, {-0.8145801530584945, -2.410818666383218*^-15}}], 
          LineBox[{{-0.5860822091220459, 
           1.4464911998299308`*^-15}, {-0.584564795071205, \
-9.643274665532871*^-16}, {-0.5827438982101958, -9.643274665532871*^-16}, \
{-0.5809230013491866, 
           0.}, {-0.5791021044881776, -9.643274665532871*^-16}, \
{-0.5772812076271685, -1.9286549331065743`*^-15}, {-0.5756879228737855, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.2183487665067798, 
           1.4464911998299308`*^-15}, {-0.21668354458235395`, \
-9.643274665532871*^-16}, {-0.21468527827304287`, 0.}, {-0.2126870119637318, 
           0.}, {-0.21068874565442075`, 0.}, {-0.2066922130357986, 
           0.}, {-0.2051935133038153, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.026973314287223365`, 1.4464911998299308`*^-15}, {
           0.028345456396418858`, 0.}, {0.030174979208679516`, 0.}, {
           0.03200450202094018, -1.9286549331065743`*^-15}, {
           0.03360533448166825, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.5232803362416121, 1.4464911998299308`*^-15}, {
           0.5247581003501299, 0.}, {
           0.5267284524948204, -9.643274665532871*^-16}, {0.5286988046395109, 
           0.}, {0.5306691567842013, -9.643274665532871*^-16}, {
           0.5326395089288918, -1.9286549331065743`*^-15}, {0.534363567055496,
            1.4464911998299308`*^-15}}], 
          LineBox[{{0.8847516314517077, 1.4464911998299308`*^-15}, {
           0.8863022412826027, -9.643274665532871*^-16}, {0.8881629730796768, 
           0.}, {0.890023704876751, -9.643274665532871*^-16}, {
           0.891884436673825, -9.643274665532871*^-16}, {
           0.893745168470899, -9.643274665532871*^-16}, {
           0.895605900267973, -9.643274665532871*^-16}, {0.8971565100988681, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.366243460545548, 1.4464911998299308`*^-15}, {
           1.367911428153468, -9.643274665532871*^-16}, {1.3699129892829718`, 
           0.}, {1.3719145504124755`, 0.}, {
           1.3739161115419793`, -9.643274665532871*^-16}, {
           1.3759176726714832`, -9.643274665532871*^-16}, {
           1.377919233800987, -9.643274665532871*^-16}, {1.3799207949304908`, 
           0.}, {1.3819223560599947`, 0.}, {1.3839239171894986`, 0.}, {
           1.3854250880366266`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.4931679991065738`, 1.4464911998299308`*^-15}, {
           1.4948055166179337`, -9.643274665532871*^-16}, {
           1.4967705376315652`, 0.}, {1.498735558645197, 0.}, {
           1.5007005796588286`, 0.}, {
           1.5026656006724604`, -9.643274665532871*^-16}, {
           1.504630621686092, -9.643274665532871*^-16}, {
           1.5065956426997238`, -1.9286549331065743`*^-15}, {
           1.5085606637133555`, 0.}, {
           1.5105256847269872`, -1.9286549331065743`*^-15}, {
           1.512490705740619, -9.643274665532871*^-16}, {
           1.5144557267542507`, -1.9286549331065743`*^-15}, {
           1.5161751201411784`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.09903098798955, 1.4464911998299308`*^-15}, {
           2.1005112232132124`, 0.}, {2.102484870178096, 0.}, {
           2.1044585171429793`, 0.}, {
           2.1064321641078623`, -9.643274665532871*^-16}, {
           2.1084058110727457`, 0.}, {
           2.110379458037629, -1.9286549331065743`*^-15}, {2.112353105002512, 
           0.}, {2.1143267519673956`, -1.9286549331065743`*^-15}, {
           2.1160536930616685`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.2338174861530398`, 1.4464911998299308`*^-15}, {
           2.235352022472794, -9.643274665532871*^-16}, {2.237193466056499, 
           0.}, {2.2390349096402042`, 0.}, {2.240876353223909, 0.}, {
           2.242717796807614, 0.}, {2.2440988794953927`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.5872147275168684`, 1.4464911998299308`*^-15}, {
           2.5887376329346976`, -9.643274665532871*^-16}, {
           2.5905651194360924`, 0.}, {
           2.592392605937487, -9.643274665532871*^-16}, {2.594220092438882, 
           0.}, {2.5960475789402766`, -9.643274665532871*^-16}, {
           2.597875065441671, 0.}, {2.5997025519430657`, 0.}, {
           2.6015300384444604`, -9.643274665532871*^-16}, {
           2.6033575249458547`, -9.643274665532871*^-16}, {
           2.6051850114472495`, 0.}, {
           2.607012497948644, -9.643274665532871*^-16}, {2.6085354033664734`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.8393427847862975`, 1.4464911998299308`*^-15}, {
           2.840730336937515, 0.}, {2.8425804064724716`, 0.}, {
           2.8444304760074277`, -9.643274665532871*^-16}, {
           2.846280545542384, -1.9286549331065743`*^-15}, {
           2.8481306150773404`, 0.}, {2.849518167228558, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.9655178849222814`, 1.4464911998299308`*^-15}, {
           2.967021526884554, 0.}, {
           2.969026382834251, -9.643274665532871*^-16}, {2.9710312387839473`, 
           0.}, {2.973036094733644, -9.643274665532871*^-16}, {
           2.975040950683341, -9.643274665532871*^-16}, {2.977045806633037, 
           0.}, {2.979050662582734, -9.643274665532871*^-16}, {
           2.981055518532431, 0.}, {
           2.983060374482127, -1.9286549331065743`*^-15}, {2.984814623438112, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.3347873187712396`, 1.4464911998299308`*^-15}, {
           3.3362804929217793`, 0.}, {3.3382713917891658`, 0.}, {
           3.3402622906565522`, 0.}, {3.3422531895239387`, 0.}, {
           3.344244088391325, 0.}, {3.3482258861260976`, 0.}, {
           3.350216784993484, 0.}, {
           3.35220768386087, -9.643274665532871*^-16}, {3.3541985827282566`, 
           0.}, {3.3556917568787963`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.4498454883902436`, 1.4464911998299308`*^-15}, {
           3.4512395100049, 0.}, {
           3.453098205491108, -9.643274665532871*^-16}, {3.454956900977316, 
           0.}, {3.456815596463524, 0.}, {3.458674291949732, 0.}, {
           3.4605329874359403`, -1.9286549331065743`*^-15}, {
           3.4623916829221484`, -9.643274665532871*^-16}, {
           3.4639405958273217`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.959055759646106, 
           1.4464911998299308`*^-15}, {-1.9576756208403223`, 
           0.}, {-1.9558354357659442`, -9.643274665532871*^-16}, \
{-1.953995250691566, 0.}, {-1.952155065617188, 0.}, {-1.9503148805428099`, 
           0.}, {-1.9484746954684316`, 0.}, {-1.9466345103940532`, 
           0.}, {-1.9452543715882695`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.4743765365352666`, 
           1.4464911998299308`*^-15}, {-1.4728907757301606`, 
           0.}, {-1.4709097613233526`, 0.}, {-1.4689287469165446`, 
           0.}, {-1.4669477325097366`, 0.}, {-1.4629857036961207`, 
           0.}, {-1.4610046892893127`, -1.9286549331065743`*^-15}, \
{-1.4590236748825047`, -9.643274665532871*^-16}, {-1.4570426604756967`, 
           0.}, {-1.455556899670591, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.3488383962906123`, 
           1.4464911998299308`*^-15}, {-1.3472977204359209`, \
-9.643274665532871*^-16}, {-1.3454489094102913`, -9.643274665532871*^-16}, \
{-1.3445245038974762`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.1093801684986895`, 
           1.4464911998299308`*^-15}, {-1.107740954061608, \
-9.643274665532871*^-16}, {-1.1057738967371105`, -9.643274665532871*^-16}, \
{-1.1038068394126128`, -9.643274665532871*^-16}, {-1.1018397820881152`, \
-9.643274665532871*^-16}, {-1.0998727247636175`, 0.}, {-1.0979056674391197`, 
           0.}, {-1.0959386101146218`, 
           0.}, {-1.0939715527901241`, -1.9286549331065743`*^-15}, \
{-1.0920044954656265`, -9.643274665532871*^-16}, {-1.0900374381411289`, 
           0.}, {-1.0883982237040475`, -2.410818666383218*^-15}}], 
          LineBox[{{-0.9841317927932289, 
           1.4464911998299308`*^-15}, {-0.9825262955928245, \
-1.9286549331065743`*^-15}, {-0.9806914416495051, 0.}, {-0.9788565877061857, 
           0.}, {-0.9770217337628663, -9.643274665532871*^-16}, \
{-0.9751868798195469, 
           0.}, {-0.9733520258762275, -1.9286549331065743`*^-15}, \
{-0.971746528675823, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8624973250150947, -2.410818666383218*^-15}, \
{-0.8619999149255798, -1.9286549331065743`*^-15}, {-0.8600102745675202, \
-9.643274665532871*^-16}, {-0.8580206342094607, -9.643274665532871*^-16}, \
{-0.8560309938514012, -9.643274665532871*^-16}, {-0.8540413534933418, \
-1.9286549331065743`*^-15}, {-0.8520517131352823, -9.643274665532871*^-16}, \
{-0.8500620727772227, 0.}, {-0.8480724324191631, 0.}, {-0.8460827920611036, 
           0.}, {-0.8440931517030441, -1.9286549331065743`*^-15}, \
{-0.8421035113449846, -9.643274665532871*^-16}, {-0.8404454777132684, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.733282552850093, 
           1.4464911998299308`*^-15}, {-0.731734688702692, \
-9.643274665532871*^-16}, {-0.7298772517258107, 
           0.}, {-0.7280198147489295, -9.643274665532871*^-16}, \
{-0.7261623777720483, -9.643274665532871*^-16}, {-0.7243049407951669, 
           0.}, {-0.722911863062506, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.002299050708947207, 
           1.4464911998299308`*^-15}, {-0.0009269085997517111, 0.}, {
           0.00273213702476961, 0.}, {
           0.004561659837030271, -1.9286549331065743`*^-15}, {
           0.0063911826492909305`, 0.}, {0.010050228273812252`, 0.}, {
           0.011879751086072914`, 0.}, {0.01325189319526841, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.4618914146396027`, 1.4464911998299308`*^-15}, {
           1.4633651803998264`, 0.}, {
           1.4653302014134582`, -9.643274665532871*^-16}, {
           1.4672952224270899`, -9.643274665532871*^-16}, {
           1.4692602434407216`, 0.}, {
           1.4712252644543533`, -9.643274665532871*^-16}, {
           1.473190285467985, -9.643274665532871*^-16}, {
           1.4751553064816167`, -1.9286549331065743`*^-15}, {
           1.4771203274952485`, 0.}, {1.4790853485088802`, 0.}, {
           1.481050369522512, -9.643274665532871*^-16}, {1.4826878870338718`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.0753472244109514`, 1.4464911998299308`*^-15}, {
           2.0768274596346137`, 0.}, {
           2.078801106599497, -9.643274665532871*^-16}, {2.0807747535643806`, 
           0.}, {2.0827484005292636`, 0.}, {
           2.0847220474941466`, -9.643274665532871*^-16}, {2.086366753298216, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.80604153315708, 1.4464911998299308`*^-15}, {
           2.8074290853082973`, 0.}, {2.809279154843254, 0.}, {
           2.8111292243782104`, -9.643274665532871*^-16}, {
           2.812979293913167, -9.643274665532871*^-16}, {2.814829363448123, 
           0.}, {2.8166794329830793`, -1.9286549331065743`*^-15}, {
           2.818529502518036, 0.}, {2.8199170546692534`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.0609379529295655`, 1.4464911998299308`*^-15}, {
           3.062414189804934, 0.}, {3.0643825056387586`, 0.}, {
           3.066350821472583, 0.}, {
           3.068319137306408, -9.643274665532871*^-16}, {3.069959400501262, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.178460303705179, 1.4464911998299308`*^-15}, {
           3.179837388044664, 0.}, {
           3.1816735004973102`, -9.643274665532871*^-16}, {
           3.1835096129499565`, 0.}, {3.1853457254026027`, 0.}, {
           3.187181837855249, -9.643274665532871*^-16}, {3.1890179503078953`, 
           0.}, {3.1908540627605415`, 0.}, {
           3.1926901752131878`, -9.643274665532871*^-16}, {
           3.194526287665834, -9.643274665532871*^-16}, {3.1963624001184803`, 
           0.}, {3.1981985125711265`, -1.9286549331065743`*^-15}, {
           3.200034625023773, -9.643274665532871*^-16}, {3.201564718734311, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.660945760063263, 
           1.4464911998299308`*^-15}, {-1.6595486839823081`, 
           0.}, {-1.657685915874368, 
           0.}, {-1.6558231477664278`, -9.643274665532871*^-16}, \
{-1.6539603796584879`, -1.9286549331065743`*^-15}, {-1.652097611550548, 
           0.}, {-1.650234843442608, 0.}, {-1.648372075334668, 
           0.}, {-1.6465093072267278`, 
           0.}, {-1.6446465391187877`, -1.9286549331065743`*^-15}, \
{-1.6427837710108477`, -9.643274665532871*^-16}, {-1.6409210029029078`, \
-9.643274665532871*^-16}, {-1.6390582347949678`, 0.}, {-1.6371954666870279`, 
           0.}, {-1.6357983906060727`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2895223758849923`, 
           1.4464911998299308`*^-15}, {-1.28813576761577, 
           0.}, {-1.2862869565901405`, -9.643274665532871*^-16}, \
{-1.2844381455645106`, -9.643274665532871*^-16}, {-1.282897469709819, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.321807259090407, 
           1.4464911998299308`*^-15}, {-0.32042464916947877`, 
           0.}, {-0.3185811692749078, 0.}, {-0.31673768938033686`, 
           0.}, {-0.3148942094857659, -9.643274665532871*^-16}, \
{-0.31305072959119495`, 0.}, {-0.30936376980205305`, 
           0.}, {-0.30798115988112484`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.19770001464389883`, 
           1.4464911998299308`*^-15}, {-0.1967008814892433, \
-9.643274665532871*^-16}, {-0.19470261517993223`, 0.}, {-0.19270434887062116`,
            0.}, {-0.1907060825613101, -9.643274665532871*^-16}, \
{-0.18870781625199906`, -1.9286549331065743`*^-15}, {-0.18670954994268799`, 
           0.}, {-0.1847112836333769, 0.}, {-0.18271301732406586`, 
           0.}, {-0.18071475101475482`, -9.643274665532871*^-16}, \
{-0.17871648470544374`, 0.}, {-0.17671821839613266`, 
           0.}, {-0.17521951866414937`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.0642266932423936, 
           1.4464911998299308`*^-15}, {-0.06275539859731441, 
           0.}, {-0.06079367240387549, 0.}, {-0.05883194621043657, 
           0.}, {-0.05687022001699764, -1.9286549331065743`*^-15}, \
{-0.05490849382355871, 
           0.}, {-0.05294676763011979, -9.643274665532871*^-16}, \
{-0.05098504143668087, 0.}, {-0.04951374679160167, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.5585824788339829, 1.4464911998299308`*^-15}, {
           0.5602244389545583, -9.643274665532871*^-16}, {0.5618663990751337, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.2855467342327611`, 1.4464911998299308`*^-15}, {
           1.2870857131617308`, -9.643274665532871*^-16}, {
           1.2886246920907005`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.142451221216982, 1.4464911998299308`*^-15}, {
           2.1439314564406446`, 0.}, {
           2.1459051034055276`, -9.643274665532871*^-16}, {2.147549809209597, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.753082806592986, 1.4464911998299308`*^-15}, {
           2.7545695112800876`, 0.}, {2.756056215967189, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.868943897345602, 1.4464911998299308`*^-15}, {
           2.8703314494968195`, 0.}, {2.872181519031776, 0.}, {
           2.8740315885667327`, -9.643274665532871*^-16}, {
           2.8758816581016893`, 0.}, {2.8772692102529067`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.987571300368945, 1.4464911998299308`*^-15}, {
           2.989074942331217, 0.}, {2.991079798280914, 0.}, {
           2.9930846542306107`, 0.}, {2.995089510180307, 0.}, {
           2.997094366130004, 0.}, {
           2.9990992220797006`, -9.643274665532871*^-16}, {
           3.001104078029397, -9.643274665532871*^-16}, {
           3.0051137899287905`, -9.643274665532871*^-16}, {
           3.0091235018281837`, -9.643274665532871*^-16}, {
           3.0111283577778805`, -9.643274665532871*^-16}, {
           3.0127990710692942`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.3856605492177372`, 
           1.4464911998299308`*^-15}, {-1.384273940948515, 
           0.}, {-1.3824251299228854`, -9.643274665532871*^-16}, \
{-1.3808844540681937`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.651634496118374, 
           1.4464911998299308`*^-15}, {-0.650117082067533, \
-9.643274665532871*^-16}, {-0.6482961852065239, 0.}, {-0.646930512560767, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.15986084517254112`, -2.410818666383218*^-15}, \
{-0.15887998207582166`, -1.9286549331065743`*^-15}, {-0.15691825588238273`, 
           0.}, {-0.15544696123730353`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.9425437029992525, 1.4464911998299308`*^-15}, {
           0.9439118467601539, 0.}, {
           0.9457360384413559, -1.9286549331065743`*^-15}, {
           0.9475602301225579, 0.}, {0.9493844218037597, 0.}, {
           0.9512086134849617, -9.643274665532871*^-16}, {0.9530328051661636, 
           0.}, {0.9544009489270651, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.167678970771635, 1.4464911998299308`*^-15}, {
           2.1690600534594138`, 0.}, {2.170901497043119, 0.}, {
           2.172742940626824, 0.}, {2.1741240233146026`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.647857152628164, 1.4464911998299308`*^-15}, {
           2.649509046724943, -9.643274665532871*^-16}, {2.651491319641078, 
           0.}, {2.6529780243281795`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.7708902119929055`, 1.4464911998299308`*^-15}, {
           2.772277764144123, 0.}, {2.7741278336790796`, 0.}, {
           2.775977903214036, 0.}, {
           2.7778279727489927`, -9.643274665532871*^-16}, {
           2.7796780422839493`, 0.}, {2.781528111818906, 0.}, {
           2.7829156639701234`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.0213255967738477`, 1.4464911998299308`*^-15}, {
           3.0230478731284443`, -1.9286549331065743`*^-15}, {
           3.0250161889622684`, 0.}, {3.0269845047960926`, 0.}, {
           3.028460741671461, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.145180765500966, 1.4464911998299308`*^-15}, {
           3.1467873638970314`, -1.9286549331065743`*^-15}, {
           3.1486234763496777`, 0.}, {3.150459588802324, 0.}, {
           3.15229570125497, -9.643274665532871*^-16}, {3.153825794965509, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.267096757280104, 1.4464911998299308`*^-15}, {
           3.2685899314306437`, 0.}, {3.2700831055811834`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.3903672328315846`, 1.4464911998299308`*^-15}, {
           3.3917612544462408`, 0.}, {3.395478645418657, 0.}, {
           3.397337340904865, -9.643274665532871*^-16}, {
           3.399196036391073, -9.643274665532871*^-16}, {3.4007449492962465`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.6890425123580248`, 
           1.4464911998299308`*^-15}, {-1.687490205601408, \
-9.643274665532871*^-16}, {-1.6859378988447913`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8316578994651721, 
           1.4464911998299308`*^-15}, {-0.8301656691966275, 
           0.}, {-0.8286734389280829, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.469564178348796, 
           1.4464911998299308`*^-15}, {-0.467917775619005, \
-9.643274665532871*^-16}, {-0.4659420923432558, 
           0.}, {-0.4639664090675065, -9.643274665532871*^-16}, \
{-0.4619907257917573, 0.}, {-0.4603443230619663, -2.410818666383218*^-15}}], 
          LineBox[{{-0.2261753095515815, 
           1.4464911998299308`*^-15}, {-0.2246766098195982, 
           0.}, {-0.22267834351028715`, 0.}, {-0.22068007720097607`, 
           0.}, {-0.21918137746899277`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.2449176905079586`, 1.4464911998299308`*^-15}, {
           1.2464566694369283`, -9.643274665532871*^-16}, {
           1.2483034441516923`, -9.643274665532871*^-16}, {1.250150218866456, 
           0.}, {1.2519969935812196`, -1.9286549331065743`*^-15}, {
           1.2538437682959835`, 0.}, {1.2552288493320563`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.709472802438021, 1.4464911998299308`*^-15}, {
           2.7109595071251222`, 0.}, {2.712941780041257, 0.}, {
           2.7149240529573917`, 0.}, {2.7164107576444927`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.835488473255138, 1.4464911998299308`*^-15}, {
           2.837030197867602, -9.643274665532871*^-16}, {2.8385719224800656`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.20232976558958, 1.4464911998299308`*^-15}, {
           3.2037068499290644`, 0.}, {
           3.2055429623817107`, -1.9286549331065743`*^-15}, {
           3.207379074834357, -9.643274665532871*^-16}, {
           3.209215187287003, -9.643274665532871*^-16}, {3.2110512997396494`, 
           0.}, {3.2128874121922957`, 0.}, {
           3.214723524644942, -1.9286549331065743`*^-15}, {
           3.2163301230410073`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.3305566586780437`, 1.4464911998299308`*^-15}, {
           3.332298695187007, -1.9286549331065743`*^-15}, {3.33404073169597, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.970250218848573, 
           1.4464911998299308`*^-15}, {-1.9687167312865914`, \
-9.643274665532871*^-16}, {-1.9668765462122133`, -9.643274665532871*^-16}, \
{-1.9650363611378352`, -9.643274665532871*^-16}, {-1.9631961760634569`, 
           0.}, {-1.9613559909890785`, -9.643274665532871*^-16}, \
{-1.9598225034270969`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2387832235643528`, -2.410818666383218*^-15}, \
{-1.2372805254840755`, -9.643274665532871*^-16}, {-1.2332733306033359`, 
           0.}, {-1.231269733162966, -9.643274665532871*^-16}, \
{-1.2292661357225962`, 0.}, {-1.2272625382822264`, 0.}, {-1.225759840201949, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7388548637807368, 
           1.4464911998299308`*^-15}, {-0.7373069996333358, \
-9.643274665532871*^-16}, {-0.7354495626564546, 0.}, {-0.7340564849237935, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.011599125004605566`, 
           1.4464911998299308`*^-15}, {-0.010074522661055015`, \
-9.643274665532871*^-16}, {-0.008244999848794354, -9.643274665532871*^-16}, \
{-0.006415477036533693, 0.}, {-0.004585954224273032, 
           0.}, {-0.003213812115077536, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.5907738052611888`, 1.4464911998299308`*^-15}, {
           1.5923775206895856`, -1.9286549331065743`*^-15}, {
           1.5942103383220392`, 0.}, {1.5955849515463791`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.6775912463701865`, 1.4464911998299308`*^-15}, {
           2.679243140466965, -9.643274665532871*^-16}, {2.6812254133830997`, 
           0.}, {2.6832076862992347`, 0.}, {2.684694390986336, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.054868979108607, 1.4464911998299308`*^-15}, {
           3.0565092423034605`, -9.643274665532871*^-16}, {3.058149505498314, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.5433364634786688`, -2.410818666383218*^-15}, \
{-1.5421950709836265`, 0.}, {-1.5403688429915587`, 
           0.}, {-1.538542614999491, -9.643274665532871*^-16}, \
{-1.536716387007423, 
           0.}, {-1.534890159015355, -9.643274665532871*^-16}, \
{-1.5333683023552984`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2969176199875112`, 
           1.4464911998299308`*^-15}, {-1.295531011718289, 
           0.}, {-1.2936822006926594`, -9.643274665532871*^-16}, \
{-1.2918333896670295`, -9.643274665532871*^-16}, {-1.290292713812338, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.5306671501167124`, 1.4464911998299308`*^-15}, {
           1.5321409158769361`, 0.}, {1.5336146816371599`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.134556633357449, 1.4464911998299308`*^-15}, {
           2.1360368685811117`, 0.}, {
           2.1380105155459947`, -9.643274665532871*^-16}, {2.139655221350064, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.865243758275689, 1.4464911998299308`*^-15}, {
           2.8666313104269063`, 0.}, {2.8680188625781238`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.973744036201932, 1.4464911998299308`*^-15}, {
           3.9752884974577607`, 0.}, {
           3.9773477791321987`, -9.643274665532871*^-16}, {3.979063847194231, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.9811379805386442`, 
           1.4464911998299308`*^-15}, {-1.9797578417328605`, 
           0.}, {-1.9779176566584822`, -9.643274665532871*^-16}, \
{-1.9760774715841039`, -1.9286549331065743`*^-15}, {-1.9742372865097257`, 
           0.}, {-1.9723971014353476`, -9.643274665532871*^-16}, \
{-1.970863613873366, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.5001297238237703`, 
           1.4464911998299308`*^-15}, {-1.4986439630186643`, 
           0.}, {-1.4966629486118563`, 
           0.}, {-1.4946819342050484`, -9.643274665532871*^-16}, \
{-1.4927009197982404`, 0.}, {-1.4907199053914324`, 0.}, {-1.4892341445863264`,
            1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7554170101579282, 
           1.4464911998299308`*^-15}, {-0.7540239324252671, 
           0.}, {-0.7521664954483859, 
           0.}, {-0.7503090584715046, -9.643274665532871*^-16}, \
{-0.7484516214946233, 0.}, {-0.7465941845177421, 0.}, {-0.7452011067850811, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.020746739065908865`, 
           1.4464911998299308`*^-15}, {-0.019222136722358316`, \
-9.643274665532871*^-16}, {-0.017392613910097658`, 
           0.}, {-0.015563091097836997`, 0.}, {-0.013733568285576335`, 
           0.}, {-0.012361426176380839`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.09625221909195389, 1.4464911998299308`*^-15}, {
           0.09774045101220447, 0.}, {
           0.09972476023920522, -9.643274665532871*^-16}, {
           0.10170906946620598`, -1.9286549331065743`*^-15}, {
           0.10369337869320674`, 0.}, {0.10518161061345732`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.7160492977322016, 1.4464911998299308`*^-15}, {
           0.717543999115891, 0.}, {0.7195369342941432, 0.}, {
           0.7210316356778325, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.4520663095714441`, 1.4464911998299308`*^-15}, {
           1.4535400753316678`, 0.}, {1.4550138410918916`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.5763403664056181`, 1.4464911998299308`*^-15}, {
           1.5777149796299583`, 0.}, {1.5795477972624117`, 0.}, {
           1.581380614894865, 0.}, {1.5832134325273186`, 0.}, {
           1.5845880457516586`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.7873866653462676`, 1.4464911998299308`*^-15}, {
           2.7889283899587314`, -9.643274665532871*^-16}, {2.790778459493688, 
           0.}, {2.7926285290286446`, 0.}, {
           2.794478598563601, -9.643274665532871*^-16}, {2.796020323176065, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.9093819183307756`, 1.4464911998299308`*^-15}, {
           2.910885560293048, 0.}, {2.9128904162427447`, 0.}, {
           2.9148952721924415`, 0.}, {2.9163989141547138`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.161782282260309, 1.4464911998299308`*^-15}, {
           3.1633123759708477`, -9.643274665532871*^-16}, {
           3.165148488423494, -9.643274665532871*^-16}, {3.16698460087614, 
           0.}, {3.1688207133287865`, -1.9286549331065743`*^-15}, {
           3.1706568257814327`, 0.}, {3.1720339101209176`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.3328681384578328, 
           1.4464911998299308`*^-15}, {-0.3314855285369046, 
           0.}, {-0.3299492952914288, -2.410818666383218*^-15}}], 
          LineBox[{{-0.08793088474644727, 
           1.4464911998299308`*^-15}, {-0.0862961129185815, \
-9.643274665532871*^-16}, {-0.08433438672514257, 0.}, {-0.08237266053170364, 
           0.}, {-0.08041093433826471, 0.}, {-0.07893963969318551, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.8979318150143155, 1.4464911998299308`*^-15}, {
           0.8993273638621211, 0.}, {
           0.9011880956591951, -9.643274665532871*^-16}, {0.9030488274562692, 
           0.}, {0.9049095592533434, 0.}, {
           0.9067702910504174, -9.643274665532871*^-16}, {0.9083209008813125, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.85028902953479, 1.4464911998299308`*^-15}, {
           2.8518307541472536`, -9.643274665532871*^-16}, {
           2.85368082368221, -9.643274665532871*^-16}, {2.855530893217167, 
           0.}, {2.8573809627521234`, 0.}, {2.858768514903341, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.2170186652107495`, 1.4464911998299308`*^-15}, {
           3.2183957495502344`, 0.}, {
           3.2202318620028807`, -9.643274665532871*^-16}, {3.222067974455527, 
           0.}, {3.223904086908173, 0.}, {3.225281171247658, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.5894487202783825`, 
           1.4464911998299308`*^-15}, {-1.587850770785323, \
-1.9286549331065743`*^-15}, {-1.5860245427932553`, 0.}, {-1.5841983148011876`,
            0.}, {-1.5823720868091198`, 0.}, {-1.5810024158150688`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.3424445914936427`, 
           1.4464911998299308`*^-15}, {-1.3417512873590316`, 
           0.}, {-1.339902476333402, 0.}, {-1.3385158680641798`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2247580414817643`, 
           1.4464911998299308`*^-15}, {-1.2232553434014868`, 
           0.}, {-1.221251745961117, 0.}, {-1.2192481485207471`, 
           0.}, {-1.2172445510803773`, -1.9286549331065743`*^-15}, \
{-1.2154914033200537`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.11915502665868345`, 
           1.4464911998299308`*^-15}, {-0.11768373201360427`, 
           0.}, {-0.11572200582016534`, 0.}, {-0.11376027962672641`, 
           0.}, {-0.11179855343328748`, 0.}, {-0.11032725878820829`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.4833428940384155`, 1.4464911998299308`*^-15}, {
           1.4849804115497753`, -9.643274665532871*^-16}, {1.486945432563407, 
           0.}, {1.4889104535770388`, -9.643274665532871*^-16}, {
           1.4908754745906703`, -9.643274665532871*^-16}, {
           1.4925129921020301`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.0871891062002508`, 1.4464911998299308`*^-15}, {
           2.0886693414239135`, 0.}, {2.0906429883887965`, 0.}, {
           2.0921232236124587`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.820610830744862, 1.4464911998299308`*^-15}, {
           2.822229641587949, -1.9286549331065743`*^-15}, {
           2.8240797111229057`, -1.9286549331065743`*^-15}, {
           2.8256985219659927`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2822811993679426`, 
           1.4464911998299308`*^-15}, {-1.2807405235132512`, \
-9.643274665532871*^-16}, {-1.2791998476585598`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.5476916336357704, 
           1.4464911998299308`*^-15}, {-0.5463259609900135, 
           0.}, {-0.5445050641290043, -1.9286549331065743`*^-15}, \
{-0.5429117793756213, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.30352608346924503`, 
           1.4464911998299308`*^-15}, {-0.30198985022376923`, \
-9.643274665532871*^-16}, {-0.3001463703291983, 
           0.}, {-0.2983028904346273, -9.643274665532871*^-16}, \
{-0.2967666571891515, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.634881667094914, 1.4464911998299308`*^-15}, {
           2.63625228197096, 0.}, {
           2.638079768472355, -1.9286549331065743`*^-15}, {
           2.6399072549737497`, 0.}, {2.641734741475144, 0.}, {
           2.64310535635119, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.7567995683107394`, 1.4464911998299308`*^-15}, {
           2.7585340571123576`, -1.9286549331065743`*^-15}, {
           2.7605163300284925`, 0.}, {2.762498602944627, 0.}, {
           2.7644808758607615`, -9.643274665532871*^-16}, {
           2.7664631487768965`, 0.}, {2.767949853463998, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2708407826102701`, 
           1.4464911998299308`*^-15}, {-1.2693380845299926`, 
           0.}, {-1.2678353864497152`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.6926128178982431`, 
           1.4464911998299308`*^-15}, {-1.6912157418172882`, 
           0.}, {-1.6898186657363332`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.831788334185225, 1.4464911998299308`*^-15}, {
           2.8333300587976886`, -9.643274665532871*^-16}, {
           2.8348717834101524`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.9877250484322295, 
           1.4464911998299308`*^-15}, {-0.9861960034794632, \
-9.643274665532871*^-16}, {-0.9846669585266971, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7442723882966406, 
           1.4464911998299308`*^-15}, {-0.7428793105639796, 
           0.}, {-0.7410218735870984, 0.}, {-0.7396287958544373, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.11014238368095924`, 1.4464911998299308`*^-15}, {
           0.11163061560120982`, 0.}, {0.11361492482821059`, 0.}, {
           0.11510315674846115`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.5855044545678854`, 1.4464911998299308`*^-15}, {
           1.5868790677922253`, 0.}, {1.588711885424679, 0.}, {
           1.5900864986490189`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.174635069428833, 1.4464911998299308`*^-15}, {
           3.1761651631393715`, -9.643274665532871*^-16}, {3.17769525684991, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.4208891475514516`, 
           1.4464911998299308`*^-15}, {-1.4194033867463456`, 
           0.}, {-1.4174223723395376`, 0.}, {-1.4159366115344316`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.5467603659658401, 1.4464911998299308`*^-15}, {
           0.5484023260864155, -9.643274665532871*^-16}, {0.550372678231106, 
           0.}, {0.5518504423396239, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.859693549670819, 1.4464911998299308`*^-15}, {
           2.8610811018220366`, 0.}, {2.862931171356993, 0.}, {
           2.8643187235082106`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.7391820205967432`, 
           1.4464911998299308`*^-15}, {-1.7377849445157882`, 
           0.}, {-1.7359221764078483`, 0.}, {-1.7340594082999083`, 
           0.}, {-1.7326623322189532`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8853781891327791, 
           1.4464911998299308`*^-15}, {-0.8838859588642345, 
           0.}, {-0.881896318506175, 
           
           0.}, {-0.8799066781481155, -1.9286549331065743`*^-15}, \
{-0.8781657428348134, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.9553130447676659, 1.4464911998299308`*^-15}, {
           0.9566811885285673, 0.}, {
           0.9585053802097693, -9.643274665532871*^-16}, {0.9603295718909712, 
           0.}, {0.9616977156518727, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.4481362675441807`, 1.4464911998299308`*^-15}, {
           1.4496100333044044`, 0.}, {1.4510837990646281`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.4595211216970708, -2.410818666383218*^-15}, \
{-0.4580393592402589, -9.643274665532871*^-16}, {-0.4560636759645097, 
           0.}, {-0.4545819135076977, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.116629340093093, 1.4464911998299308`*^-15}, {
           2.118274045897162, -9.643274665532871*^-16}, {2.1199187517012317`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.532759559691276, 
           1.4464911998299308`*^-15}, {-1.5312377030312194`, \
-9.643274665532871*^-16}, {-1.5294114750391514`, -1.9286549331065743`*^-15}, \
{-1.5275852470470834`, -1.9286549331065743`*^-15}, {-1.525987297554024, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.4070220467037957`, 
           1.4464911998299308`*^-15}, {-1.4055362858986897`, 
           0.}, {-1.4035552714918818`, -1.9286549331065743`*^-15}, \
{-1.4018218838859247`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.16064292338993, 
           1.4464911998299308`*^-15}, {-1.1591402253096525`, 
           0.}, {-1.1571366278692827`, -1.9286549331065743`*^-15}, \
{-1.155383480108959, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.5531543242187977, 
           1.4464911998299308`*^-15}, {-0.5517886515730408, 
           0.}, {-0.5499677547120317, 0.}, {-0.5486020820662749, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.2893941815551855`, 1.4464911998299308`*^-15}, {
           1.2907792625912582`, 0.}, {1.2921643436273311`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.9840404445741235`, 1.4464911998299308`*^-15}, {
           3.9855849058299526`, 0.}, {
           3.9876441875043906`, -9.643274665532871*^-16}, {
           3.9897034691788287`, -9.643274665532871*^-16}, {
           3.9914195372408607`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.312368106809736, 1.4464911998299308`*^-15}, {
           1.3138692776568637`, 0.}, {1.3153704485039917`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.4401124317385177`, 1.4464911998299308`*^-15}, {
           1.4417499492498775`, -9.643274665532871*^-16}, {
           1.4437149702635093`, 0.}, {1.445188736023733, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.685161745466483, 
           1.4464911998299308`*^-15}, {-1.683764669385528, 
           0.}, {-1.681901901277588, -9.643274665532871*^-16}, \
{-1.6803495945209714`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.09561431233741638, 
           1.4464911998299308`*^-15}, {-0.09414301769233718, 
           0.}, {-0.09218129149889825, -1.9286549331065743`*^-15}, \
{-0.09021956530545933, -9.643274665532871*^-16}, {-0.08858479347759356, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.352536018341872, 
           1.4464911998299308`*^-15}, {-1.3509953424871803`, \
-9.643274665532871*^-16}, {-1.3494546666324887`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.4149461043310276`, 
           1.4464911998299308`*^-15}, {-1.4134603435259216`, 
           0.}, {-1.4114793291191137`, 0.}, {-1.4094983147123057`, 
           0.}, {-1.4080125539071997`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.1668206821644036`, 
           1.4464911998299308`*^-15}, {-1.165151017630762, \
-9.643274665532871*^-16}, {-1.1631474201903922`, -9.643274665532871*^-16}, \
{-1.1614777556567506`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.43581292238808017`, 
           1.4464911998299308`*^-15}, {-0.43433115993126825`, 
           0.}, {-0.432355476655519, 0.}, {-0.43087371419870707`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.5526714223999115, 1.4464911998299308`*^-15}, {
           0.5543133825204869, -9.643274665532871*^-16}, {0.5562837346651774, 
           0.}, {0.5577614987736953, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8754299873424815, 
           1.4464911998299308`*^-15}, {-0.8739377570739368, 
           0.}, {-0.8724455268053922, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.4557507239720036`, 1.4464911998299308`*^-15}, {
           1.4574701173589313`, -1.9286549331065743`*^-15}, {
           1.459435138372563, -9.643274665532871*^-16}, {1.4610726558839229`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.5526958819380168`, 
           1.4464911998299308`*^-15}, {-1.5513262109439658`, 
           0.}, {-1.549499982951898, -1.9286549331065743`*^-15}, \
{-1.5479020334588385`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.5750050865509071, 
           1.4464911998299308`*^-15}, {-0.5736394139051502, 
           0.}, {-0.5718185170441411, -9.643274665532871*^-16}, \
{-0.5703011029933002, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.20419438014915978`, 
           1.4464911998299308`*^-15}, {-0.20269568041717648`, 
           0.}, {-0.2006974141078654, -9.643274665532871*^-16}, \
{-0.19969828095320988`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.07820399237064592, 
           1.4464911998299308`*^-15}, {-0.07648748195138687, \
-1.9286549331065743`*^-15}, {-0.07477097153212782, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.5169120030212904`, 1.4464911998299308`*^-15}, {
           1.518385768781514, 0.}, {1.5203507897951458`, 0.}, {
           1.5219883073065055`, -2.410818666383218*^-15}}], 
          LineBox[{{-1.2149070207332793`, 
           1.4464911998299308`*^-15}, {-1.2132373561996377`, \
-9.643274665532871*^-16}, {-1.2112337587592679`, -1.9286549331065743`*^-15}, \
{-1.2094806109989442`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.087742537929215, -2.410818666383218*^-15}, \
{-1.0861033234921336`, 0.}, {-1.0846280304987603`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7221379309888055, 
           1.4464911998299308`*^-15}, {-0.7205900668414045, \
-9.643274665532871*^-16}, {-0.7187326298645231, -9.643274665532871*^-16}, \
{-0.7171847657171221, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.0929455765144933`, 1.4464911998299308`*^-15}, {
           2.094590282318563, -9.643274665532871*^-16}, {2.0962349881226325`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.048696360877668786`, 
           1.4464911998299308`*^-15}, {-0.04706158904980302, \
-9.643274665532871*^-16}, {-0.045099862856364095`, -9.643274665532871*^-16}, \
{-0.04313813666292517, 0.}, {-0.04166684201784598, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.6438926067958946`, 1.4464911998299308`*^-15}, {
           2.6455445008926732`, -9.643274665532871*^-16}, {
           2.6471963949894524`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.017470978265941, -2.410818666383218*^-15}, {
           3.019111241460795, 0.}, {3.0205874783361635`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8376268205393507, 
           1.4464911998299308`*^-15}, {-0.8361345902708059, 
           0.}, {-0.8346423600022613, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.23017184217020364`, 
           1.4464911998299308`*^-15}, {-0.22867314243822034`, 
           0.}, {-0.22717444270623705`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.6648265269548046`, 
           1.4464911998299308`*^-15}, {-1.663274220198188, \
-9.643274665532871*^-16}, {-1.6617219134415715`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.547217197961813, 
           1.4464911998299308`*^-15}, {-1.545847526967762, 
           0.}, {-1.5447061344727198`, -2.410818666383218*^-15}}], 
          LineBox[{{-1.3024640530644003`, 
           1.4464911998299308`*^-15}, {-1.3010774447951778`, 
           0.}, {-1.2996908365259556`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.3766475954677924`, 
           1.4464911998299308`*^-15}, {-1.3750298858203664`, \
-1.9286549331065743`*^-15}, {-1.3734121761729403`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7588997044895804, -2.410818666383218*^-15}, \
{-0.7577388063790297, 0.}, {-0.7563457286463687, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.33839857814154567`, 
           1.4464911998299308`*^-15}, {-0.33701596822061747`, 
           0.}, {-0.33563335829968927`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.6718773499419687, 1.4464911998299308`*^-15}, {
           0.673409140578229, -9.643274665532871*^-16}, {0.6749409312144892, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.7317309481649832`, 
           1.4464911998299308`*^-15}, {-1.730333872084028, 
           0.}, {-1.728936796003073, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.0593113428212746`, 1.4464911998299308`*^-15}, {
           2.0610382839155474`, -1.9286549331065743`*^-15}, {
           2.0627652250098203`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.9921059644656736`, 1.4464911998299308`*^-15}, {
           3.9938220325277056`, -9.643274665532871*^-16}, {3.994851673364925, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.172831474485513, 
           1.4464911998299308`*^-15}, {-1.1711618099518715`, \
-9.643274665532871*^-16}, {-1.1694921454182299`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.05075711084661195, 1.4464911998299308`*^-15}, {
           0.05212925295580745, 0.}, {0.05350139506500295, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.594675101874456, 1.4464911998299308`*^-15}, {
           0.5962068925107162, -9.643274665532871*^-16}, {0.5977386831469765, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7630789376875632, 
           1.4464911998299308`*^-15}, {-0.7614536803327921, \
-1.9286549331065743`*^-15}, {-0.7609893210885719, -2.410818666383218*^-15}}], 
          LineBox[{{-1.5946991257555778`, 
           1.4464911998299308`*^-15}, {-1.5933294547615269`, 
           0.}, {-1.591959783767476, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.9799218812252466`, 1.4464911998299308`*^-15}, {
           3.9814663424810757`, 0.}, {3.9830108037369047`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.6718096170314594`, 1.4464911998299308`*^-15}, {
           2.673296321718561, 0.}, {2.6747830264056622`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.5802414874850406`, 
           1.4464911998299308`*^-15}, {-1.5787196308249838`, \
-9.643274665532871*^-16}, {-1.5771977741649272`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.3357426515257351`, 
           1.4464911998299308`*^-15}, {-1.3343560432565127`, 
           0.}, {-1.3329694349872905`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.9050037164875792, -2.410818666383218*^-15}, \
{-0.9036275760300896, -9.643274665532871*^-16}, {-0.9020985310773234, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.013634427715001, 1.4464911998299308`*^-15}, {
           3.0151380696772736`, 0.}, {
           3.0168087829686874`, -2.410818666383218*^-15}}], 
          LineBox[{{3.997168365248668, 1.4464911998299308`*^-15}, {
           3.9979405958765826`, 0.}, {3.9999998775510206`, 0.}}], 
          LineBox[{{-0.6758258356985661, 
           1.4464911998299308`*^-15}, {-0.674339886117061, \
-2.410818666383218*^-15}}], 
          LineBox[{{-0.9071137985223966, 
           1.4464911998299308`*^-15}, {-0.9056459153677411, \
-2.410818666383218*^-15}}]},
         Annotation[#, "Charting`Private`Tag$792334#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
          Opacity[1.], 
          LineBox[{{-1.9999998775510204`, 
           0.}, {-1.998159692476642, -9.643274665532871*^-16}, \
{-1.996319507402264, -9.643274665532871*^-16}, {-1.9944793223278858`, 
           0.}, {-1.9926391372535077`, -1.9286549331065743`*^-15}, \
{-1.991028975313427, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.9461744641254588`, 
           1.4464911998299308`*^-15}, {-1.944794325319675, 
           0.}, {-1.941113955170919, 0.}, {-1.8822280327908176`, 
           0.}, {-1.7545498574872482`, 0.}, {-1.6353326985790877`, 
           0.}, {-1.6339630275850368`, 1.4464911998299308`*^-15}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQHXJhg0D14h/795VdST7Md8sm4mzenXtzf+xngILY
k2Jvkqch+ElH9/1+0YfgZxxM485rR/Dz9vJJf65H8It3btOqqPixX9Pf4q1O
/MM9FVvjrP4WIOTrNrJ5NWUi+C1r10WyJyH4nSvDMnuiEPy+pf8qBIMR5k1Z
uKxjmjeMf3FPhIGqV6UzQr3M/sXcMdYI/gNfpbN2xgj+kjsL+hS1EeZlZMsH
sCgj5HV+zRV8LoXg2z/do3RRBBFeAMCzdE4=
           "]], 
          LineBox[{{-1.4091681456445044`, 
           1.4464911998299308`*^-15}, {-1.4075173003054977`, \
-9.643274665532871*^-16}, {-1.3995932426782658`, -9.643274665532871*^-16}, \
{-1.3916691850510339`, -9.643274665532871*^-16}, {-1.3898203740254043`, 
           0.}, {-1.3879715629997744`, -9.643274665532871*^-16}, \
{-1.3861227519741446`, -9.643274665532871*^-16}, {-1.3845820761194532`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.1487883052010752`, 
           1.4464911998299308`*^-15}, {-1.1471186406674336`, \
-9.643274665532871*^-16}, {-1.145115043227064, 
           0.}, {-1.1431479859025662`, -9.643274665532871*^-16}, \
{-1.1411809285780685`, 0.}, {-1.1392138712535709`, 
           0.}, {-1.1372468139290732`, -9.643274665532871*^-16}, \
{-1.1356075994919919`, 1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQfeb75rOBX9/u31d2Jfkw3y2bPyteX+Z+9XY/AxRo
6TQ8+X0awT+Ye+rN5z0IfsR6ka+v177dr+lv8VYn/uGedx/i/j6eh5BvNVrJ
eqcfwX9gcUltTzCCP91VJbPm9hs4f9Ua6av6p99Azbu4Z5+wsOPjXQj+pSqu
tdNWIdQ/e8go6TULIf/L42fL306EPO+GDx82VCL4CuIvYlIyEXyTuvsnxCMR
/EvbZmlsvvYaoV9D8MXLi68Q+vs5QuYeRPBNvv3fH7ARwfeI/a7NshDBjzny
bvr2Ca/g7nOa9bxQqfkVPLwBcVuWbg==
           "]], 
          LineBox[{{-0.7761137728026772, 
           1.4464911998299308`*^-15}, {-0.7744557391709609, \
-9.643274665532871*^-16}, {-0.7725983021940797, -1.9286549331065743`*^-15}, \
{-0.7709730448393085, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.6608425107517241, 
           1.4464911998299308`*^-15}, {-0.659294646604323, \
-9.643274665532871*^-16}, {-0.6574372096274417, 0.}, {-0.6555797726505604, 
           0.}, {-0.6537588757895514, 0.}, {-0.6523932031437945, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.5531543242187977, 
           1.4464911998299308`*^-15}, {-0.5517886515730408, 
           0.}, {-0.5499677547120317, 0.}, {-0.5481468578510227, 
           0.}, {-0.5463259609900135, 0.}, {-0.5445050641290043, 
           0.}, {-0.5426841672679952, 0.}, {-0.540863270406986, 
           0.}, {-0.539042373545977, -1.9286549331065743`*^-15}, \
{-0.5370666902702277, 0.}, {-0.5350910069944785, 0.}, {-0.5331153237187293, 
           0.}, {-0.53113964044298, 
           0.}, {-0.5291639571672309, -9.643274665532871*^-16}, \
{-0.5271882738914816, 0.}, {-0.5232369073399832, 0.}, {-0.5217551448831713, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.4399289292125577, 
           1.4464911998299308`*^-15}, {-0.43828252648276667`, \
-9.643274665532871*^-16}, {-0.43630684320701746`, 0.}, {-0.4284041101040206, 
           0.}, {-0.41259864389802675`, 
           0.}, {-0.4107551640034558, -9.643274665532871*^-16}, \
{-0.40921893075797994`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.321807259090407, 
           1.4464911998299308`*^-15}, {-0.32042464916947877`, 
           0.}, {-0.31673768938033686`, 0.}, {-0.30936376980205305`, 
           0.}, {-0.2946159306454854, 0.}, {-0.16672688684957734`, 
           0.}, {-0.16525559220449818`, 1.4464911998299308`*^-15}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQXfnhfq/Mp9X795VdST7Md8vm+4cz265Jr96v6W/x
Vif+4h6NbhnpbVKr9jNAQYRqTv1UyZVw+V2R3B4h4svhfOm+VQLCokvh/H1X
4svdVJfA9SdIi96rNF0M5zMlnXJZ67oIzl+yon71g9CFcP1u702ERNIWwOUv
ZF/52PdmHlT+4R6Rn3b7v/LMRbivbWVPjO5sOH+OsEjUYd+ZcP6DBXXqWnnT
4ear6L38MqFvKlw+c3fwoe/rJsP5Xx/8fq+a2AHn1/2+0PV5YQtcv4uN7sN5
TY3w8AMA6UOCkA==
           "]], 
          LineBox[{{0.05624567928339393, 1.4464911998299308`*^-15}, {
           0.05761782139258943, 0.}, {0.06127686701711075, 0.}, {
           0.0631063898293714, -9.643274665532871*^-16}, {
           0.06493591264163207, -9.643274665532871*^-16}, {
           0.06676543545389273, 0.}, {0.06859495826615339, 0.}, {
           0.07591304951519603, 0.}, {0.07740128143544661, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.19745198966899294`, 1.4464911998299308`*^-15}, {
           0.19894022158924352`, 0.}, {0.20092453081624428`, 0.}, {
           0.20290884004324503`, 0.}, {0.2047609458890675, 0.}, {
           0.20661305173489003`, 0.}, {0.21031726342653506`, 0.}, {
           0.21772568680982507`, 0.}, {0.21911476619419196`, 
           1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQndAy9+Na9dv2+8quJB/mu2Wj0LtbJNzhtj0DFJya
8XiGRSKCX7KEW1aqCcGX22C88Pei2/aa/hZvdeIv7jmxO1r17mEEv+h488p9
TxDqZS6v1l3AegfOP3bv8sZGtTtQ9Q/3FLz6bZrsjpCX+qa8yyXjDty8I4w+
dmqdCHlxyTluL08h+LsmyXYYvkbwY3jmn6zkvgvX/79VgfuQ9l24/KL/C324
fBB8l0rlvqAchPrnn5acn9WDkO/KURN8vAYhb7M8/dPJ43fh4QcAU6h6Bw==

           "]], 
          LineBox[{{0.5034126187826498, 1.4464911998299308`*^-15}, {
           0.5050545789032252, -9.643274665532871*^-16}, {0.5070249310479157, 
           0.}, {0.5089952831926061, 0.}, {0.5109656353372967, 0.}, {
           0.5129359874819871, 0.}, {0.575987256112082, 0.}, {
           0.6936287769768632, 0.}, {0.6956217121551155, 0.}, {
           0.6976146473333678, 0.}, {
           0.6996075825116201, -9.643274665532871*^-16}, {0.7012683618268304, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.8644386426669827, 1.4464911998299308`*^-15}, {
           0.8658341915147882, 0.}, {0.8676949233118623, 0.}, {
           0.8695556551089363, -1.9286549331065743`*^-15}, {
           0.8714163869060103, -9.643274665532871*^-16}, {0.8732771187030844, 
           0.}, {0.8807200458913806, 0.}, {
           0.8825807776884547, -9.643274665532871*^-16}, {
           0.8844415094855287, -9.643274665532871*^-16}, {0.8863022412826027, 
           0.}, {0.8881629730796768, 0.}, {0.895605900267973, 0.}, {
           0.9104917546445654, 0.}, {0.9402634633977501, 0.}, {
           0.9420876550789521, 0.}, {0.9439118467601539, 0.}, {
           0.9457360384413559, 0.}, {0.9471041822022573, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.044546421173126, 1.4464911998299308`*^-15}, {
           1.0460665809074607`, -9.643274665532871*^-16}, {
           1.0478907725886626`, 0.}, {
           1.0497149642698647`, -9.643274665532871*^-16}, {
           1.0533633476322684`, -9.643274665532871*^-16}, {
           1.0570117309946723`, -9.643274665532871*^-16}, {
           1.0589907090906143`, 0.}, {
           1.0609696871865562`, -9.643274665532871*^-16}, {
           1.0629486652824982`, -9.643274665532871*^-16}, {
           1.0645978136957832`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.1802031174670624`, 1.4464911998299308`*^-15}, {
           1.181687351039019, 0.}, {
           1.183666329134961, -1.9286549331065743`*^-15}, {
           1.1855131038497246`, 0.}, {1.1873598785644885`, 0.}, {
           1.1892066532792522`, 0.}, {
           1.191053427994016, -9.643274665532871*^-16}, {
           1.1929002027087798`, -9.643274665532871*^-16}, {
           1.1944391816377495`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.2983972082896589`, 1.4464911998299308`*^-15}, {
           1.300013136165077, -1.9286549331065743`*^-15}, {
           1.3018599108798408`, -9.643274665532871*^-16}, {
           1.3038614720093447`, 0.}, {1.3058630331388486`, 0.}, {
           1.3073642039859763`, 1.4464911998299308`*^-15}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQLdB/+OHEU9/s95VdST7Md8vGYJXdz+0XvtkzQMFG
ZYvDr258s9f0t3irE39xj9Fcw17Zhwi+YVEjm9ZLBN/A/WK92UeEfn0ZxZ9O
PxF8vY8FRf6M3+F83WMHXkdzIvg6swVSMwS/w83TLki4VyKJkNdy3RDeqIjg
a0oxXOzVRKjXeO/vNcsQIa82873NZkcEX+mtntLTRARf8VDd7I+ZCL7C9HMi
/woRfDnHPHbxJgRfVmxfg3IXgi/zmveX/iQEX/pAbLHNLARfauraNx6LEO6T
zPqbGroKwZew972fuAnBFxeZG5G3C6Ff7OWbi1WHEPyrJ17otJz4Do8vADuh
loQ=
           "]], 
          LineBox[{{1.5247720870758172`, 1.4464911998299308`*^-15}, {
           1.526245852836041, 0.}, {1.5282108738496727`, 0.}, {
           1.5301758948633044`, -9.643274665532871*^-16}, {
           1.5321409158769361`, -9.643274665532871*^-16}, {
           1.5341059368905678`, 0.}, {
           1.5360709579041996`, -9.643274665532871*^-16}, {
           1.5380359789178313`, 0.}, {
           1.540000999931463, -1.9286549331065743`*^-15}, {
           1.5419660209450947`, 0.}, {1.5439310419587264`, 0.}, {
           1.5458960629723582`, -9.643274665532871*^-16}, {
           1.5478610839859899`, 0.}, {1.5498261049996216`, 0.}, {
           1.5517911260132533`, -9.643274665532871*^-16}, {1.553756147026885, 
           0.}, {1.5557211680405167`, 0.}, {1.557095781264857, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.60726916395327, 1.4464911998299308`*^-15}, {
           1.608872879381667, -1.9286549331065743`*^-15}, {
           1.6107056970141203`, 0.}, {1.6125385146465736`, 0.}, {
           1.6143713322790272`, -9.643274665532871*^-16}, {
           1.6436964143982824`, -9.643274665532871*^-16}, {
           1.6730214965175376`, -9.643274665532871*^-16}, {
           1.6746778332235324`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.7887994322665624`, 1.4464911998299308`*^-15}, {
           1.7902901353019576`, 0.}, {1.7922777393491511`, 0.}, {
           1.7942653433963447`, 0.}, {1.7962529474435383`, 0.}, {
           1.7982405514907316`, -9.643274665532871*^-16}, {
           1.8002281555379251`, -9.643274665532871*^-16}, {
           1.8020835562039403`, -1.9286549331065743`*^-15}, {
           1.8039389568699558`, 0.}, {
           1.805794357535971, -9.643274665532871*^-16}, {1.8073405247576504`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.8544986250188724`, 1.4464911998299308`*^-15}, {
           1.8558901755183839`, 0.}, {1.8577455761843993`, 0.}, {
           1.8596009768504145`, 0.}, {
           1.8614563775164297`, -9.643274665532871*^-16}, {
           1.863311778182445, -9.643274665532871*^-16}, {1.8651671788484603`, 
           0.}, {1.8670225795144755`, 0.}, {1.8744441821785367`, 0.}, {
           1.8892873875066591`, 0.}, {1.9189737981629038`, 0.}, {
           1.9207926587130468`, -1.9286549331065743`*^-15}, {
           1.92261151926319, -9.643274665532871*^-16}, {
           1.9244303798133333`, -9.643274665532871*^-16}, {
           1.9262492403634766`, 0.}, {1.933524682564049, 0.}, {
           1.9348888279766565`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.9503491426528732`, 1.4464911998299308`*^-15}, {
           1.9517132880654804`, 0.}, {1.9535321486156234`, 0.}, {
           1.9553510091657667`, 0.}, {
           1.95716986971591, -9.643274665532871*^-16}, {
           1.9589887302660531`, -9.643274665532871*^-16}, {
           1.9608075908161964`, -9.643274665532871*^-16}, {
           1.9626264513663394`, 0.}, {1.9644453119164824`, 0.}, {
           1.9662641724666257`, -9.643274665532871*^-16}, {
           1.968083033016769, -1.9286549331065743`*^-15}, {
           1.9699018935669121`, 0.}, {1.9771773357674847`, 0.}, {
           2.0353808733720653`, 0.}, {2.161694279124594, 0.}, {
           2.1630753618123726`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.2779354053459717`, 1.4464911998299308`*^-15}, {
           2.279546668481714, -1.9286549331065743`*^-15}, {
           2.2815428984801587`, 0.}, {
           2.283539128478604, -9.643274665532871*^-16}, {
           2.2855353584770493`, -9.643274665532871*^-16}, {
           2.2875315884754945`, -9.643274665532871*^-16}, {2.28952781847394, 
           0.}, {2.2915240484723847`, 0.}, {2.2935202784708295`, 0.}, {
           2.295516508469275, 0.}, {2.2970136809681088`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.351910005925349, 1.4464911998299308`*^-15}, {
           2.353407178424183, 0.}, {2.3554034084226276`, 0.}, {
           2.3573996384210725`, 0.}, {2.3593958684195178`, 0.}, {
           2.3753657084070787`, 0.}, {2.4073053883822, 0.}, {
           2.409169414999467, -9.643274665532871*^-16}, {2.411033441616734, 
           0.}, {2.412897468234001, 0.}, {
           2.4147614948512675`, -9.643274665532871*^-16}, {
           2.4163148503656564`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.4170915281228504`, 1.4464911998299308`*^-15}, {
           2.418489548085801, 0.}, {2.420353574703068, 0.}, {
           2.4222176013203347`, 0.}, {2.4371298142584696`, 0.}, {
           2.466954240134739, 0.}, {2.526603091887278, 0.}, {
           2.6435622279765387`, 0.}, {2.6450489326636397`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.8522932715309928`, 1.4464911998299308`*^-15}, {
           2.85368082368221, 0.}, {
           2.855530893217167, -1.9286549331065743`*^-15}, {
           2.8573809627521234`, -9.643274665532871*^-16}, {
           2.85923103228708, -9.643274665532871*^-16}, {
           2.8740315885667327`, -9.643274665532871*^-16}, {
           2.888832144846385, -9.643274665532871*^-16}, {2.8908370007960817`, 
           0.}, {2.8925077140874955`, -2.410818666383218*^-15}}], 
          LineBox[{{3.003610147966518, 1.4464911998299308`*^-15}, {
           3.0051137899287905`, 0.}, {3.007118645878487, 0.}, {
           3.0091235018281837`, -9.643274665532871*^-16}, {
           3.013133213727577, -9.643274665532871*^-16}, {
           3.0171429256269704`, -9.643274665532871*^-16}, {3.019111241460795, 
           0.}, {3.0210795572946196`, 0.}, {3.0230478731284443`, 0.}, {
           3.0250161889622684`, 0.}, {3.0269845047960926`, 0.}, {
           3.028952820629917, -1.9286549331065743`*^-15}, {
           3.0306750969845138`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.139670586282546, 1.4464911998299308`*^-15}, {
           3.1411468231579143`, 0.}, {
           3.143115138991739, -1.9286549331065743`*^-15}, {3.144951251444385, 
           0.}, {3.1467873638970314`, -9.643274665532871*^-16}, {
           3.1486234763496777`, -9.643274665532871*^-16}, {
           3.150459588802324, -9.643274665532871*^-16}, {3.157804038612909, 
           0.}, {3.159640151065555, 0.}, {3.16101723540504, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.2537409142636746`, 1.4464911998299308`*^-15}, {
           3.2551179986031595`, 0.}, {3.256954111055806, 0.}, {
           3.258790223508452, 0.}, {3.2606263359610983`, 0.}, {
           3.2626172348284848`, -1.9286549331065743`*^-15}, {
           3.264359271337448, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.306914734627831, 1.4464911998299308`*^-15}, {
           3.3084079087783707`, 0.}, {3.310398807645757, 0.}, {
           3.3123897065131436`, 0.}, {3.316371504247916, 0.}, {
           3.3243350997174614`, 0.}, {3.3880438634738246`, 0.}, {
           3.3899025589600327`, -9.643274665532871*^-16}, {
           3.3917612544462408`, -9.643274665532871*^-16}, {3.393619949932449, 
           0.}, {3.395478645418657, 0.}, {3.396872667033313, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.8649775581801475`, 1.4464911998299308`*^-15}, {
           3.8663611119830708`, 0.}, {
           3.8682058503869685`, -1.9286549331065743`*^-15}, {
           3.870265132061407, 0.}, {
           3.872324413735845, -9.643274665532871*^-16}, {3.874383695410283, 
           0.}, {3.8764429770847215`, -9.643274665532871*^-16}, {
           3.87850225875916, -9.643274665532871*^-16}, {3.8805615404335985`, 
           0.}, {3.882620822108037, 0.}, {
           3.884680103782475, -1.9286549331065743`*^-15}, {
           3.8864819752476083`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.6239187736286635`, 
           1.4464911998299308`*^-15}, {-1.6225491026346126`, 
           0.}, {-1.6207228746425448`, 0.}, {-1.6061130507060017`, 
           0.}, {-1.576893402832916, 0.}, {-1.575523731838865, 
           1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAmIQrelVydbB8GP/vrIryYf5btnYmM4QL/r1fT8DFBwJ
mjrL/BWC3/FQOEbqEYLvUzBJ9u9NBF/gv8D9+xe/79f0t3irE39xz5Xe/gWH
TiL4M2T4kpYeRPBjVvcod+xE6Few4n6atREh/+RE5zLflQj5FeEcGQYLEfyc
Z22awjMRfINS1tdfJyD0f2FuWXOjA8HfMYkpb3cDgl+j2Kg/rwLGf7jHYcP/
Dw0FCPNY7Os2JWcg+CfO/il2S0Dwe2KqTTUjEHzRqood79wR/Fsc3ysv2iPM
nze91HqLOcL+JLUvf6bpI/hqW4v2Vaoj9Jt9yDnCwo7gh6UlXpA69g3Ol/p6
f+Lfvd/g5t9rjgt+sBUhn7Yw+trSpQi+lsGt6R1zEfx3+yIis6ci+IyryrNC
+7/B0wMAbWnXWA==
           "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQnZ7aMc8p4uv+fWVXkg/z3bLpuN4o9Tnw635Nf4u3
OvEX92yYLFyT4AXjP9xz3X/p3bNOX/czQME/bnN7a2sEX+3EiQUrjBH6/Vqi
mMR0EPxShzfJzSoI9XP+1B79IIPgH9nBrx4niuC/KVnYcZoXwRc2NH5lwYbg
W7094r3s3xe4+Ukrw9YKf/8Cd29X6gu+xvdf4Oo3KVYVvHuOUH/rLvel6AcI
9Yyz5hqfvIGQ1wjTn2p2EcH3PKEh+PzUF3h4AQATaIvx
           "]], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAmIQrVWYVysw/eP+fWVXkg/z3bLZ/ry6g3Xix/0MUCB3
u/fNtw4Ev+3c/IAXDQh+2NbDEqcLEPxvTdwrJwQg+HFlsrxNHh/3a/pbvNWJ
v7jnWKZ+YbEDQn5aQLBlmAGCbyo3+6S0AIJfslPr1bLzH+D8O2ts/GYcR/Bd
Fvht6tyP4K+ZnCBWvf0D3D6R9qKqnPUw/sM9NVUt92KXI9Q/yZ3m5D8fod4n
ccUyh+kI+c0hu7iM+hF8KY8zecrtCH6T9b1LIvUI/iu9D2Zs5QjzgpSYZn/P
Q/B3iYr8f5GGcI8Sp1ryrTiEvN/K+93KER/g8QEA6wSdcA==
           "]], 
          LineBox[{{-0.9657068011123966, 
           1.4464911998299308`*^-15}, {-0.9641777561596303, \
-9.643274665532871*^-16}, {-0.9623429022163109, 
           0.}, {-0.9605080482729915, -1.9286549331065743`*^-15}, \
{-0.9586731943296721, -1.9286549331065743`*^-15}, {-0.9568383403863527, \
-9.643274665532871*^-16}, {-0.9550034864430332, -1.9286549331065743`*^-15}, \
{-0.9533979892426288, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7182682706203029, 
           1.4464911998299308`*^-15}, {-0.7168751928876419, 
           0.}, {-0.7150177559107607, -9.643274665532871*^-16}, \
{-0.7134698917633596, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.6405573735472352, 
           1.4464911998299308`*^-15}, {-0.6391917009014783, 
           0.}, {-0.6373708040404692, 0.}, {-0.6355499071794601, 
           0.}, {-0.633729010318451, 
           0.}, {-0.6319081134574418, -9.643274665532871*^-16}, \
{-0.6300872165964327, 0.}, {-0.6264454228744145, 0.}, {-0.5973110730982687, 
           0.}, {-0.5959454004525118, 1.4464911998299308`*^-15}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQrVjBYaiw6sH+fWVXkg/z3bJJlbm/9c/cB/sZoECm
VlpiXi2C32k35c4DGwT/Sd6m3o06CL7D/At2TTII/tv/kk7uP+7D+SeauE+f
KUPw6x+76+aF3d+v6W/xVif+4h4zl5Z+fjME/82SAx83iCL4i1n/Bgd9vQfX
H5Vmue3zlXtweYHjpRJTtyD4x9U3VZlNQaiv63h353oxQt70pZZ9ZTBC/o1n
+kIpY4T8zffvZBUl7sHDBwCs7Xsw
           "]], 
          LineBox[{{-0.1642747291077787, 
           1.4464911998299308`*^-15}, {-0.16280343446269951`, 
           0.}, {-0.15887998207582166`, 0.}, {-0.15103307730206594`, 
           0.}, {-0.13533926775455457`, 0.}, {-0.1039516486595318, 
           0.}, {-0.10198992246609287`, -9.643274665532871*^-16}, \
{-0.10002819627265395`, 0.}, {-0.09610474388577611, 
           0.}, {-0.09414301769233718, 0.}, {-0.09218129149889825, 
           0.}, {-0.09021956530545933, 
           0.}, {-0.08825783911202041, -9.643274665532871*^-16}, \
{-0.08662306728415464, 1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQfeK9XNZjp4b9+8quJB/mu2Ujm/itQda9ar+mv8Vb
nfiLe/SmLdi240QRnF83beqN5VPS9jNAQQvTCv7KeD84/1MIm/Payb72MPVS
2rlPtySmQfkP99Qk8Njary+yh6nP0k5iX6JbBVev8/t2Bsu1Bjh/yQO2c2ZT
W+DqZY4ZGmeGdMDlJ6+OmTFbuAcu72gdachwciKc/2ftu+SZKybD1e9QaJlm
1DEVLm/Atv53ivtMOP9NhYveP7XZcPXLX99MmM42F+5+7g0yubar5tnDwgsA
HDR4nw==
           "]], 
          LineBox[{{0.1377573537567199, 1.4464911998299308`*^-15}, {
           0.13941094477922053`, -9.643274665532871*^-16}, {
           0.14139525400622127`, 0.}, {0.14337956323322204`, 0.}, {
           0.1453638724602228, -9.643274665532871*^-16}, {
           0.14734818168722358`, 0.}, {0.14933249091422435`, 0.}, {
           0.15131680014122512`, -9.643274665532871*^-16}, {
           0.15330110936822589`, 0.}, {0.15528541859522665`, 0.}, {
           0.15726972782222742`, -9.643274665532871*^-16}, {
           0.1592540370492282, -9.643274665532871*^-16}, {
           0.16090762807172884`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.25322438218808974`, 1.4464911998299308`*^-15}, {
           0.2547678037262751, -9.643274665532871*^-16}, {
           0.25661990957209757`, 0.}, {
           0.2584720154179201, -9.643274665532871*^-16}, {0.2603241212637426, 
           0.}, {0.2621762271095651, 0.}, {0.26402833295538763`, 0.}, {
           0.26588043880121015`, 0.}, {
           0.26773254464703267`, -9.643274665532871*^-16}, {
           0.2695846504928551, -9.643274665532871*^-16}, {
           0.2714367563386776, -1.9286549331065743`*^-15}, {
           0.2732888621845001, -9.643274665532871*^-16}, {0.2751409680303226, 
           0.}, {0.27699307387614513`, 0.}, {0.27884517972196765`, 0.}, {
           0.28069728556779017`, -9.643274665532871*^-16}, {
           0.2825493914136127, 0.}, {0.2839384707979795, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.35004182888890234`, 1.4464911998299308`*^-15}, {
           0.3515469980843243, 0.}, {0.35355389034488693`, 0.}, {
           0.35556078260544954`, 0.}, {
           0.35756767486601215`, -9.643274665532871*^-16}, {
           0.35957456712657476`, 0.}, {0.36158145938713737`, 0.}, {
           0.3696090284293878, 0.}, {0.3856641665138887, 0.}, {
           0.38716933570931067`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.7457772474744653, 1.4464911998299308`*^-15}, {
           0.7474380267896756, -9.643274665532871*^-16}, {0.7494309619679279, 
           0.}, {0.7514238971461802, 0.}, {0.7534168323244326, 0.}, {
           0.7554097675026848, 0.}, {
           0.7574027026809371, -9.643274665532871*^-16}, {
           0.7593956378591894, -1.9286549331065743`*^-15}, {
           0.7611394561401601, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.9952932457806744, 1.4464911998299308`*^-15}, {
           0.9968134055150093, -9.643274665532871*^-16}, {0.9986375971962111, 
           0.}, {1.000461788877413, 0.}, {
           1.0022859805586148`, -9.643274665532871*^-16}, {
           1.004110172239817, -9.643274665532871*^-16}, {1.0056303319741517`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.1048370349799375`, 1.4464911998299308`*^-15}, {
           1.1064861833932225`, -9.643274665532871*^-16}, {
           1.1084651614891645`, 0.}, {
           1.1104441395851066`, -9.643274665532871*^-16}, {
           1.1124231176810486`, -9.643274665532871*^-16}, {
           1.1144020957769907`, 0.}, {1.1163810738729327`, 0.}, {
           1.1183600519688746`, -9.643274665532871*^-16}, {
           1.1203390300648166`, 0.}, {
           1.1223180081607587`, -9.643274665532871*^-16}, {
           1.1242969862567005`, 0.}, {1.125781219828657, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.2302973906827457`, 1.4464911998299308`*^-15}, {
           1.2316824717188184`, 0.}, {1.2335292464335823`, 0.}, {
           1.235376021148346, -1.9286549331065743`*^-15}, {
           1.2372227958631097`, -9.643274665532871*^-16}, {
           1.2390695705778736`, 0.}, {1.2409163452926373`, 0.}, {
           1.242763120007401, -9.643274665532871*^-16}, {1.2443020989363707`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.487436687816815, 1.4464911998299308`*^-15}, {
           1.4889104535770388`, 0.}, {1.492840495604302, 0.}, {
           1.4948055166179337`, -9.643274665532871*^-16}, {
           1.4967705376315652`, -9.643274665532871*^-16}, {1.498735558645197, 
           0.}, {1.5007005796588286`, -9.643274665532871*^-16}, {
           1.5026656006724604`, -9.643274665532871*^-16}, {
           1.504630621686092, -9.643274665532871*^-16}, {1.5065956426997238`, 
           0.}, {1.5085606637133555`, 0.}, {1.5105256847269872`, 0.}, {
           1.511999450487211, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.729005677180156, 1.4464911998299308`*^-15}, {
           1.7306620138861508`, -9.643274665532871*^-16}, {
           1.7326496179333444`, 0.}, {1.734637221980538, 0.}, {
           1.7366248260277315`, -1.9286549331065743`*^-15}, {
           1.738612430074925, 0.}, {
           1.7406000341221186`, -9.643274665532871*^-16}, {
           1.7425876381693122`, -9.643274665532871*^-16}, {
           1.7445752422165057`, 0.}, {1.7465628462636993`, 0.}, {
           1.7485504503108928`, -9.643274665532871*^-16}, {
           1.7505380543580864`, -9.643274665532871*^-16}, {1.75252565840528, 
           0.}, {1.7545132624524735`, 0.}, {1.756500866499667, 0.}, {
           1.7584884705468606`, -9.643274665532871*^-16}, {
           1.7601448072528554`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.319970325950227, 1.4464911998299308`*^-15}, {
           2.321467498449061, 0.}, {2.323463728447506, 0.}, {
           2.3254599584459514`, -9.643274665532871*^-16}, {
           2.3274561884443963`, 0.}, {2.329452418442841, 0.}, {
           2.3314486484412864`, 0.}, {2.335441108438177, 0.}, {
           2.3434260284319572`, 0.}, {2.3454222584304025`, 0.}, {
           2.3474184884288474`, 0.}, {2.349414718427292, 0.}, {
           2.350911890926126, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.701543710773482, 1.4464911998299308`*^-15}, {
           2.703030415460583, 0.}, {2.7050126883767174`, 0.}, {
           2.7069949612928523`, -9.643274665532871*^-16}, {
           2.7089772342089873`, 0.}, {2.7109595071251222`, 0.}, {
           2.712941780041257, 0.}, {2.7149240529573917`, 0.}, {
           2.716906325873526, 0.}, {2.718888598789661, 0.}, {
           2.7203753034767626`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.917401342129562, 1.4464911998299308`*^-15}, {
           2.9189049840918346`, 0.}, {2.9209098400415314`, 0.}, {
           2.9229146959912278`, -9.643274665532871*^-16}, {
           2.9249195519409246`, 0.}, {2.9269244078906214`, 0.}, {
           2.9289292638403177`, -9.643274665532871*^-16}, {
           2.9309341197900145`, 0.}, {2.9329389757397113`, 0.}, {
           2.9349438316894076`, -9.643274665532871*^-16}, {
           2.9369486876391044`, 0.}, {2.9529875352366775`, 0.}, {
           2.9549923911863742`, -9.643274665532871*^-16}, {
           2.9566631044777885`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.078406755954758, 1.4464911998299308`*^-15}, {
           3.0801290323093546`, -1.9286549331065743`*^-15}, {
           3.0820973481431793`, 0.}, {3.084065663977004, 0.}, {
           3.0855419008523723`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.196591914175061, 1.4464911998299308`*^-15}, {
           3.1981985125711265`, -1.9286549331065743`*^-15}, {
           3.200034625023773, -9.643274665532871*^-16}, {
           3.2018707374764186`, -9.643274665532871*^-16}, {
           3.2037068499290644`, 0.}, {3.2055429623817107`, 0.}, {
           3.207379074834357, 0.}, {
           3.209215187287003, -9.643274665532871*^-16}, {
           3.2110512997396494`, -9.643274665532871*^-16}, {3.212581393450188, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.438693315472995, 1.4464911998299308`*^-15}, {
           3.4400873370876512`, 0.}, {
           3.4419460325738593`, -9.643274665532871*^-16}, {
           3.4438047280600674`, 0.}, {3.4475221190324836`, 0.}, {
           3.4493808145186917`, 0.}, {3.450774836133348, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.5530097976921247`, 1.4464911998299308`*^-15}, {
           3.5543764142198766`, 0.}, {3.5561985695902125`, 0.}, {
           3.5580207249605484`, 0.}, {3.5598428803308844`, 0.}, {
           3.5616650357012203`, 0.}, {
           3.563487191071556, -9.643274665532871*^-16}, {
           3.5653093464418926`, -9.643274665532871*^-16}, {
           3.567131501812229, -9.643274665532871*^-16}, {3.568953657182565, 
           0.}, {3.5707758125529008`, -9.643274665532871*^-16}, {
           3.5725979679232367`, -1.9286549331065743`*^-15}, {
           3.5744201232935726`, 0.}, {3.5757867398213246`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.9303275142325242`, 1.4464911998299308`*^-15}, {
           3.932043582294556, -9.643274665532871*^-16}, {
           3.9341028639689943`, -9.643274665532871*^-16}, {
           3.936162145643433, -1.9286549331065743`*^-15}, {3.937964017108566, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.9811379805386442`, 
           1.4464911998299308`*^-15}, {-1.9797578417328605`, 
           0.}, {-1.9779176566584822`, 
           0.}, {-1.9760774715841039`, -9.643274665532871*^-16}, \
{-1.9742372865097257`, -9.643274665532871*^-16}, {-1.9723971014353476`, \
-1.9286549331065743`*^-15}, {-1.9705569163609695`, -9.643274665532871*^-16}, \
{-1.9687167312865914`, -9.643274665532871*^-16}, {-1.9668765462122133`, 
           0.}, {-1.9650363611378352`, -9.643274665532871*^-16}, \
{-1.9631961760634569`, 
           0.}, {-1.9613559909890785`, -9.643274665532871*^-16}, \
{-1.9598225034270969`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.3801141161408481`, 
           1.4464911998299308`*^-15}, {-1.3787275078716257`, 
           0.}, {-1.376878696845996, -9.643274665532871*^-16}, \
{-1.3750298858203664`, 0.}, {-1.3731810747947366`, 
           0.}, {-1.3713322637691068`, -1.9286549331065743`*^-15}, \
{-1.3694834527434772`, 0.}, {-1.3676346417178475`, 0.}, {-1.365785830692218, 
           0.}, {-1.3620882086409585`, 0.}, {-1.3602393976153286`, 
           0.}, {-1.358390586589699, -9.643274665532871*^-16}, \
{-1.3565417755640694`, -1.9286549331065743`*^-15}, {-1.3546929645384398`, 
           0.}, {-1.3528441535128102`, 0.}, {-1.3509953424871803`, 
           0.}, {-1.3491465314615505`, -1.9286549331065743`*^-15}, \
{-1.3475288218141246`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2528084056469417`, 
           1.4464911998299308`*^-15}, {-1.2513057075666643`, 
           0.}, {-1.2493021101262944`, 0.}, {-1.2412877203648152`, 
           0.}, {-1.2392841229244453`, -9.643274665532871*^-16}, \
{-1.2376144583908038`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7499994856420245, 
           1.4464911998299308`*^-15}, {-0.7484516214946233, \
-9.643274665532871*^-16}, {-0.7465941845177421, 0.}, {-0.7447367475408608, 
           0.}, {-0.7428793105639796, -9.643274665532871*^-16}, \
{-0.7410218735870984, -9.643274665532871*^-16}, {-0.739164436610217, \
-9.643274665532871*^-16}, {-0.7373069996333358, -1.9286549331065743`*^-15}, \
{-0.7354495626564546, 0.}, {-0.7335921256795732, 
           0.}, {-0.731734688702692, -9.643274665532871*^-16}, \
{-0.7298772517258107, 0.}, {-0.7280198147489295, 0.}, {-0.7261623777720483, 
           0.}, {-0.7247693000393872, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.078393436048947, 1.4464911998299308`*^-15}, {
           0.07988166796919757, 0.}, {0.0838502864231991, 0.}, {
           0.09178752333120216, 0.}, {0.10766199714720828`, 0.}, {
           0.10915022906745886`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.2255971366545707, 1.4464911998299308`*^-15}, {
           0.2269862160389376, 0.}, {
           0.22883832188476008`, -9.643274665532871*^-16}, {
           0.23069042773058257`, 0.}, {
           0.23254253357640509`, -9.643274665532871*^-16}, {
           0.2343946394222276, -9.643274665532871*^-16}, {0.2362467452680501, 
           0.}, {0.23809885111387258`, 0.}, {
           0.2399509569596951, -9.643274665532871*^-16}, {
           0.24149437849788052`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.4797683930463642, 1.4464911998299308`*^-15}, {
           0.4814103531669396, -9.643274665532871*^-16}, {0.48338070531163, 
           0.}, {0.4853510574563205, 0.}, {0.487321409601011, 0.}, {
           0.48929176174570144`, -9.643274665532871*^-16}, {
           0.4909337218662769, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.7040916866626877, 1.4464911998299308`*^-15}, {
           0.7055863880463771, 0.}, {0.7075793232246294, 0.}, {
           0.7095722584028816, 0.}, {0.7255157398289002, 0.}, {
           0.7275086750071524, -9.643274665532871*^-16}, {0.7295016101854048, 
           0.}, {0.7314945453636571, 0.}, {
           0.7334874805419094, -9.643274665532871*^-16}, {0.7354804157201618, 
           0.}, {0.736975117103851, 1.4464911998299308`*^-15}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQvS3x9pR5nq/s95VdST7Md8um7YR2UVDYK3tNf4u3
OvEX9/is+rRuQiqM/3CPUM/O1+dKEPI3cxs0eFte2TNAwQJ/91TvyQj5NEO+
RZ2LEPKfvsyWZjuI4O+4lhThcgGhvm6H5tSm+wh57prtfP//IviXYuu8bXlf
w/kz7F07qmUQ/DhFnqM7tV/DzVNhvsz4wwrBf/Vkpp2ZF0L9hmMJ1SWRCH7Z
CvUdmzIQ6m273n35UI6Qn7S5eVF882t4eAEArZ16xA==
           "]], 
          LineBox[{{1.071359322190252, 1.4464911998299308`*^-15}, {
           1.0728435557622085`, 0.}, {1.0748225338581505`, 0.}, {
           1.0768015119540926`, 0.}, {1.0787804900500344`, 0.}, {
           1.0807594681459765`, -9.643274665532871*^-16}, {
           1.0827384462419185`, 0.}, {
           1.0847174243378603`, -9.643274665532871*^-16}, {
           1.0866964024338024`, -1.9286549331065743`*^-15}, {
           1.0886753805297444`, 0.}, {
           1.0906543586256865`, -9.643274665532871*^-16}, {
           1.0926333367216285`, 0.}, {1.0965912929135124`, 0.}, {
           1.0985702710094545`, 0.}, {1.100054504581411, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.2042886467831564`, 1.4464911998299308`*^-15}, {
           1.205827625712126, -9.643274665532871*^-16}, {
           1.2076744004268898`, -9.643274665532871*^-16}, {
           1.2095211751416537`, -9.643274665532871*^-16}, {
           1.2113679498564174`, 0.}, {1.213214724571181, 0.}, {
           1.2150614992859448`, -9.643274665532871*^-16}, {
           1.2169082740007084`, 0.}, {1.220601823430236, 0.}, {
           1.2224485981449997`, 0.}, {1.2242953728597636`, 0.}, {
           1.2261421475745273`, 0.}, {
           1.227988922289291, -9.643274665532871*^-16}, {1.2295279012182607`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.3083649845507281`, 1.4464911998299308`*^-15}, {
           1.3098661553978561`, 0.}, {1.31186771652736, 0.}, {
           1.3138692776568637`, -1.9286549331065743`*^-15}, {
           1.3158708387863676`, 0.}, {
           1.3178723999158715`, -9.643274665532871*^-16}, {
           1.3198739610453754`, 0.}, {1.3218755221748792`, 0.}, {
           1.3238770833043831`, -9.643274665532871*^-16}, {1.325878644433887, 
           0.}, {1.327880205563391, -9.643274665532871*^-16}, {
           1.3298817666928948`, -1.9286549331065743`*^-15}, {
           1.3318833278223985`, 0.}, {1.3338848889519024`, 0.}, {
           1.3353860597990304`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.7013448541900458`, 1.4464911998299308`*^-15}, {
           1.702835557225441, 0.}, {
           1.7048231612726346`, -9.643274665532871*^-16}, {
           1.7068107653198281`, -1.9286549331065743`*^-15}, {
           1.7087983693670217`, 0.}, {
           1.7107859734142152`, -9.643274665532871*^-16}, {
           1.7127735774614088`, -9.643274665532871*^-16}, {
           1.7147611815086024`, -9.643274665532871*^-16}, {1.716748785555796, 
           0.}, {1.7187363896029895`, 0.}, {1.7202270926383847`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.826512998306475, 1.4464911998299308`*^-15}, {
           1.8280591655281544`, -9.643274665532871*^-16}, {
           1.8299145661941698`, -1.9286549331065743`*^-15}, {
           1.8317699668601852`, -9.643274665532871*^-16}, {
           1.8336253675262004`, 0.}, {
           1.8354807681922156`, -9.643274665532871*^-16}, {1.837336168858231, 
           0.}, {1.8391915695242465`, 0.}, {1.8410469701902616`, 0.}, {
           1.8429023708562768`, 0.}, {
           1.8447577715222923`, -9.643274665532871*^-16}, {
           1.8466131721883077`, 0.}, {
           1.8484685728543229`, -9.643274665532871*^-16}, {1.850323973520338, 
           0.}, {1.8517155240198497`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.9465598498400747`, 1.4464911998299308`*^-15}, {
           1.9480755669651941`, -9.643274665532871*^-16}, {
           1.9495912840903136`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.18793485019239, 1.4464911998299308`*^-15}, {
           2.189315932880169, 0.}, {
           2.191157376463874, -9.643274665532871*^-16}, {
           2.1920780982557266`, -2.410818666383218*^-15}}], 
          LineBox[{{2.3078265934596858`, 1.4464911998299308`*^-15}, {
           2.30949011845839, -9.643274665532871*^-16}, {
           2.3114863484568353`, -9.643274665532871*^-16}, {
           2.3134825784552806`, 0.}, {
           2.3154788084537254`, -9.643274665532871*^-16}, {
           2.3174750384521703`, 0.}, {2.3189722109510043`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.6460400691217068`, 1.4464911998299308`*^-15}, {
           2.647526773808808, 0.}, {2.651491319641078, 0.}, {
           2.659420411305617, 0.}, {2.6752785946346958`, 0.}, {
           2.6772608675508307`, 0.}, {2.679243140466965, 0.}, {
           2.6812254133830997`, -9.643274665532871*^-16}, {2.682877307479879, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.798487082556007, 1.4464911998299308`*^-15}, {
           2.800028807168471, -9.643274665532871*^-16}, {2.8018788767034275`, 
           0.}, {2.803728946238384, 0.}, {
           2.8055790157733407`, -9.643274665532871*^-16}, {
           2.8074290853082973`, 0.}, {2.809279154843254, 0.}, {
           2.8111292243782104`, 0.}, {2.812979293913167, 0.}, {
           2.814366846064384, 1.4464911998299308`*^-15}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQHWCSPinUgcNhX9mV5MN8t2zuMU3ojnbmcGCAAjex
wqZkdw4HTX+LtzrxD/es0wyqzPaG8S/uEbM1Lij2R6ivDRBJrw5GyD9J/hrb
HI6Q9ym/FtIdjZDf0rXde3I8gi8zb4bT7GSE+paNlZaL0xHyb45EGazORsiH
3LBW35yP4O9+LSO3uxihvkvoPvfpagQ/ynLhz1vNCP4hn6YPj9oRfK2E5Oev
uhHmTSp2ufepH8H/2aZ69ddkBD9hFtsZphkI/om1zw9xzUHww2oE9gjMR4Qv
ACXPeIM=
           "]], 
          LineBox[{{3.2651058584127175`, 1.4464911998299308`*^-15}, {
           3.2665990325632572`, 0.}, {3.2685899314306437`, 0.}, {
           3.27058083029803, -9.643274665532871*^-16}, {3.272571729165416, 
           0.}, {3.2745626280328026`, -9.643274665532871*^-16}, {
           3.276553526900189, -9.643274665532871*^-16}, {3.2785444257675755`, 
           0.}, {3.280535324634962, 0.}, {3.282526223502348, 0.}, {
           3.2845171223697345`, -9.643274665532871*^-16}, {3.286508021237121, 
           0.}, {3.288498920104507, 0.}, {3.2904898189718934`, 0.}, {
           3.29248071783928, -1.9286549331065743`*^-15}, {3.294222754348243, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.5329660886184295`, 1.4464911998299308`*^-15}, {
           3.5343327051461815`, 0.}, {3.5361548605165174`, 0.}, {
           3.5379770158868533`, 0.}, {3.5397991712571892`, 0.}, {
           3.541621326627525, 0.}, {3.542987943155277, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.7744316481888305`, 1.4464911998299308`*^-15}, {
           3.7759689301920787`, -9.643274665532871*^-16}, {3.777813668595977, 
           0.}, {3.7796584069998747`, 0.}, {3.781041960802798, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.8954913325732763`, 1.4464911998299308`*^-15}, {
           3.897035793829105, 0.}, {3.9011543571779814`, 0.}, {
           3.90321363885242, 0.}, {3.9047581001082485`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.5510218396119546`, 
           1.4464911998299308`*^-15}, {-1.549499982951898, \
-9.643274665532871*^-16}, {-1.54767375495983, -9.643274665532871*^-16}, \
{-1.545847526967762, 0.}, {-1.5440212989756943`, 
           0.}, {-1.5421950709836265`, -1.9286549331065743`*^-15}, \
{-1.5405971214905672`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.182682495233998, 
           1.4464911998299308`*^-15}, {-1.1811797971537206`, 
           0.}, {-1.177172602272981, 0.}, {-1.1756699041927035`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.6979912502893492, 
           1.4464911998299308`*^-15}, {-0.6964433861419481, \
-9.643274665532871*^-16}, {-0.6945859491650668, 0.}, {-0.6927285121881855, 
           0.}, {-0.6908710752113043, 
           0.}, {-0.689013638234423, -9.643274665532871*^-16}, \
{-0.6871562012575417, 
           0.}, {-0.6852987642806605, -9.643274665532871*^-16}, \
{-0.6778690163731355, -9.643274665532871*^-16}, {-0.6704392684656104, \
-9.643274665532871*^-16}, {-0.6685818314887292, 0.}, {-0.666724394511848, 
           0.}, {-0.6648669575349667, 0.}, {-0.6634738798023058, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.5751568279559911, 
           1.4464911998299308`*^-15}, {-0.5736394139051502, \
-9.643274665532871*^-16}, {-0.5718185170441411, 0.}, {-0.569997620183132, 
           0.}, {-0.5681767233221229, -9.643274665532871*^-16}, \
{-0.5663558264611137, 0.}, {-0.5649901538153569, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.4693995380758169, 
           1.4464911998299308`*^-15}, {-0.467917775619005, 
           0.}, {-0.4659420923432558, 0.}, {-0.4639664090675065, 
           0.}, {-0.4600150425160081, 0.}, {-0.4580393592402589, 
           0.}, {-0.4560636759645097, -9.643274665532871*^-16}, \
{-0.45408799268876043`, -9.643274665532871*^-16}, {-0.4521123094130112, 
           0.}, {-0.44420957631001434`, 0.}, {-0.44223389303426514`, 
           0.}, {-0.4407521305774532, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.3291811786686909, 
           1.4464911998299308`*^-15}, {-0.3277985687477627, 
           0.}, {-0.32411160895862073`, 0.}, {-0.32272899903769253`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.08580568137022176, 
           1.4464911998299308`*^-15}, {-0.08433438672514257, 
           0.}, {-0.08237266053170364, 0.}, {-0.08041093433826471, 
           0.}, {-0.07844920814482578, 0.}, {-0.07648748195138687, 
           0.}, {-0.07256402956450902, 0.}, {-0.0706023033710701, 
           0.}, {-0.06864057717763118, 0.}, {-0.06471712479075334, 
           0.}, {-0.05687022001699764, 0.}, {-0.05539892537191844, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.28486452372089077`, 1.4464911998299308`*^-15}, {
           0.2862536031052576, 0.}, {0.2881057089510801, 0.}, {
           0.28995781479690264`, -9.643274665532871*^-16}, {
           0.29180992064272515`, -9.643274665532871*^-16}, {
           0.29366202648854767`, -1.9286549331065743`*^-15}, {
           0.2955141323343702, 0.}, {0.2973662381801927, 0.}, {
           0.29921834402601516`, 0.}, {0.300607423410382, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.3881727818395919, 1.4464911998299308`*^-15}, {
           0.3896779510350139, 0.}, {0.3936917355561391, 0.}, {
           0.40171930459838956`, 0.}, {0.40372619685895217`, 0.}, {
           0.4057330891195148, -1.9286549331065743`*^-15}, {
           0.4077399813800774, 0.}, {0.40974687364064, 0.}, {
           0.4117537659012026, -9.643274665532871*^-16}, {0.4137606581617652, 
           0.}, {0.4157675504223278, -9.643274665532871*^-16}, {
           0.41777444268289043`, -9.643274665532871*^-16}, {
           0.41978133494345304`, 0.}, {0.42178822720401565`, 0.}, {
           0.42329339639943764`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.769858547545014, 1.4464911998299308`*^-15}, {
           0.7713532489287033, 0.}, {0.7733461841069555, 0.}, {
           0.7753391192852079, -9.643274665532871*^-16}, {0.7773320544634602, 
           0.}, {0.7793249896417125, -1.9286549331065743`*^-15}, {
           0.7813179248199649, -9.643274665532871*^-16}, {0.7833108599982171, 
           0.}, {0.7853037951764694, 0.}, {0.7872967303547218, 0.}, {
           0.7892896655329741, 0.}, {0.7912826007112264, 0.}, {
           0.7932755358894787, -9.643274665532871*^-16}, {0.794936315204689, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.0209839452909344`, 1.4464911998299308`*^-15}, {
           1.0223520890518358`, 0.}, {1.024176280733038, 0.}, {
           1.0260004724142398`, -9.643274665532871*^-16}, {
           1.0278246640954416`, 0.}, {1.0296488557766434`, 0.}, {
           1.0314730474578453`, 0.}, {
           1.0332972391390474`, -9.643274665532871*^-16}, {
           1.0348173988733822`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.1327076431644543`, 1.4464911998299308`*^-15}, {
           1.1341918767364108`, 0.}, {1.1361708548323528`, 0.}, {
           1.1520026795998888`, 0.}, {1.1539816576958308`, 0.}, {
           1.1559606357917729`, -1.9286549331065743`*^-15}, {
           1.1579396138877147`, 0.}, {
           1.1599185919836568`, -9.643274665532871*^-16}, {
           1.1618975700795988`, 0.}, {
           1.1638765481755406`, -9.643274665532871*^-16}, {
           1.1658555262714827`, -9.643274665532871*^-16}, {
           1.1678345043674248`, 0.}, {
           1.1698134824633668`, -9.643274665532871*^-16}, {
           1.1717924605593089`, -1.9286549331065743`*^-15}, {
           1.173771438655251, 0.}, {1.175750416751193, 0.}, {
           1.177729394847135, -9.643274665532871*^-16}, {1.17937854326042, 
           1.4464911998299308`*^-15}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQvVXi/Xm915/t95VdST7Md8tmytnCnpqPn+01/S3e
6sRf3HPlpiMH78/P9gxQIPxMsGUuwxc4P+jTw/+6HAj+pH8bq/fxI/gC4kHF
9+UQfH9lpff5agh+n/6nLAa9L1D7Hu45Z33o2QRThDyvx6QkRVsEn6vyUmBy
NILv2bro7OckBL9jYpFnSxaCz75KyHFpJYLvtu3RHtNGBL/t0CaLYx0I/tFz
TVvCJiD4X67HCTJP+wIPHwBOB1+u
           "]], 
          LineBox[{{1.3884274297308823`, 1.4464911998299308`*^-15}, {
           1.3899286005780103`, 0.}, {1.3919301617075142`, 0.}, {
           1.393931722837018, -9.643274665532871*^-16}, {1.3959332839665217`, 
           0.}, {1.3979348450960256`, 0.}, {1.3999364062255295`, 0.}, {
           1.4014375770726573`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.2431781577035403`, 1.4464911998299308`*^-15}, {
           2.244559240391319, 0.}, {
           2.2464006839750237`, -9.643274665532871*^-16}, {
           2.2482421275587288`, -9.643274665532871*^-16}, {2.250083571142434, 
           0.}, {2.251925014726139, 0.}, {
           2.253766458309844, -9.643274665532871*^-16}, {2.2556079018935487`, 
           0.}, {2.2574493454772537`, -9.643274665532871*^-16}, {
           2.258983881797008, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.9655178849222814`, 1.4464911998299308`*^-15}, {
           2.967021526884554, 0.}, {
           2.969026382834251, -9.643274665532871*^-16}, {
           2.973036094733644, -9.643274665532871*^-16}, {
           2.977045806633037, -9.643274665532871*^-16}, {2.979050662582734, 
           0.}, {2.981055518532431, -9.643274665532871*^-16}, {
           2.983060374482127, 0.}, {2.985065230431824, 0.}, {
           2.9870700863815207`, 0.}, {2.989074942331217, 0.}, {
           2.9930846542306107`, 0.}, {2.995089510180307, 0.}, {
           2.9965931521425797`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.1081775329413537`, 1.4464911998299308`*^-15}, {
           3.109653769816722, 0.}, {3.1116220856505468`, 0.}, {
           3.1135904014843714`, 0.}, {
           3.115558717318196, -9.643274665532871*^-16}, {3.1175270331520206`, 
           0.}, {3.119495348985845, 0.}, {3.127368612321143, 0.}, {
           3.1288448491965113`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.4517041838764517`, 1.4464911998299308`*^-15}, {
           3.453098205491108, 0.}, {3.454956900977316, 0.}, {
           3.4623916829221484`, 0.}, {3.477261246811813, 0.}, {
           3.4791199422980212`, 0.}, {
           3.4809786377842293`, -9.643274665532871*^-16}, {
           3.4825275506894027`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.9593290644808636`, 1.4464911998299308`*^-15}, {
           3.9608735257366927`, 0.}, {3.9629328074111307`, 0.}, {
           3.9649920890855688`, 0.}, {3.9670513707600072`, 0.}, {
           3.9691106524344457`, 0.}, {3.970655113690275, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.990338905910535, 
           1.4464911998299308`*^-15}, {-1.9889587671047513`, 
           0.}, {-1.987118582030373, -9.643274665532871*^-16}, \
{-1.9852783969559948`, -9.643274665532871*^-16}, {-1.9834382118816167`, 
           0.}, {-1.982058073075833, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.5040917526373863`, 
           1.4464911998299308`*^-15}, {-1.5026059918322803`, 
           0.}, {-1.5011202310271743`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2668335877295305`, 
           1.4464911998299308`*^-15}, {-1.265330889649253, 
           0.}, {-1.2633272922088832`, -9.643274665532871*^-16}, \
{-1.2613236947685134`, -1.9286549331065743`*^-15}, {-1.2593200973281435`, 
           0.}, {-1.2573164998877737`, 0.}, {-1.255312902447404, 
           0.}, {-1.2538102043671264`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.1347879922734512`, 
           1.4464911998299308`*^-15}, {-1.133312699280078, 
           0.}, {-1.1313456419555803`, 0.}, {-1.1293785846310826`, 
           0.}, {-1.127411527306585, -9.643274665532871*^-16}, \
{-1.1254444699820874`, -1.9286549331065743`*^-15}, {-1.1234774126575897`, \
-9.643274665532871*^-16}, {-1.1215103553330918`, -9.643274665532871*^-16}, \
{-1.119543298008594, 0.}, {-1.1180680050152207`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.018764660973383, 
           1.4464911998299308`*^-15}, {-1.0173885205158935`, 
           0.}, {-1.015553666572574, 0.}, {-1.0137188126292545`, 
           0.}, {-1.0118839586859352`, 
           0.}, {-1.0100491047426157`, -9.643274665532871*^-16}, \
{-1.0082142507992962`, 
           0.}, {-1.0063793968559769`, -9.643274665532871*^-16}, \
{-1.0045445429126574`, -9.643274665532871*^-16}, {-1.0027096889693379`, 
           0.}, {-1.0008748350260186`, 0.}, {-0.9990399810826992, 
           0.}, {-0.9976638406252096, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7647041950423343, 
           1.4464911998299308`*^-15}, {-0.7633111173096734, 
           0.}, {-0.7614536803327921, 0.}, {-0.7595962433559109, 
           0.}, {-0.7577388063790297, 0.}, {-0.7558813694021485, 
           0.}, {-0.7540239324252671, -9.643274665532871*^-16}, \
{-0.7521664954483859, -9.643274665532871*^-16}, {-0.7506186313009848, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.39938703798693487`, 
           1.4464911998299308`*^-15}, {-0.39785080474145906`, \
-9.643274665532871*^-16}, {-0.3960073248468881, -1.9286549331065743`*^-15}, \
{-0.39416384495231716`, 0.}, {-0.3923203650577462, 
           0.}, {-0.39047688516317525`, 0.}, {-0.3886334052686043, 
           0.}, {-0.38678992537403334`, 0.}, {-0.3849464454794624, 
           0.}, {-0.3835638355585342, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.32997290628327625`, 1.4464911998299308`*^-15}, {
           0.33147807547869823`, 0.}, {0.33348496773926084`, 0.}, {
           0.33549185999982345`, 0.}, {0.33749875226038606`, 0.}, {
           0.33900392145580804`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.9478642620694249, 1.4464911998299308`*^-15}, {
           0.9493844218037597, -9.643274665532871*^-16}, {0.9512086134849617, 
           0.}, {0.9530328051661636, -1.9286549331065743`*^-15}, {
           0.9548569968473655, 0.}, {
           0.9566811885285673, -9.643274665532871*^-16}, {0.9585053802097693, 
           0.}, {0.9621537635721731, 0.}, {
           0.9639779552533749, -9.643274665532871*^-16}, {
           0.9658021469345769, -9.643274665532871*^-16}, {
           0.9676263386157788, -9.643274665532871*^-16}, {0.9691464983501137, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.1952086711022345`, 1.4464911998299308`*^-15}, {
           1.1965937521383072`, 0.}, {1.1984405268530711`, 0.}, {
           1.2002873015678348`, 0.}, {1.2021340762825985`, 0.}, {
           1.2035191573186714`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.67534036790593, 1.4464911998299308`*^-15}, {
           1.6769967046119247`, -9.643274665532871*^-16}, {
           1.6789843086591183`, 0.}, {
           1.6809719127063119`, -1.9286549331065743`*^-15}, {
           1.6829595167535054`, 0.}, {1.684947120800699, 0.}, {
           1.6869347248478925`, 0.}, {1.688922328895086, 0.}, {
           1.6909099329422796`, -9.643274665532871*^-16}, {
           1.6928975369894732`, 0.}, {1.6968727450838603`, 0.}, {
           1.6988603491310539`, 0.}, {1.700351052166449, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.8081136083684899`, 1.4464911998299308`*^-15}, {
           1.8095051588680016`, 0.}, {1.8113605595340168`, 0.}, {
           1.813215960200032, 0.}, {1.8150713608660474`, 0.}, {
           1.8169267615320628`, 0.}, {1.818782162198078, 0.}, {
           1.8206375628640932`, -9.643274665532871*^-16}, {
           1.8221837300857726`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.16583752718793, 1.4464911998299308`*^-15}, {
           2.1672186098757087`, 0.}, {2.1690600534594138`, 0.}, {
           2.176425827794234, 0.}, {2.177806910482013, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.772740281527862, 1.4464911998299308`*^-15}, {
           2.7741278336790796`, 0.}, {2.775977903214036, 0.}, {
           2.7778279727489927`, -9.643274665532871*^-16}, {
           2.7796780422839493`, -9.643274665532871*^-16}, {2.781528111818906, 
           0.}, {2.7833781813538625`, 0.}, {
           2.7852282508888186`, -9.643274665532871*^-16}, {2.787078320423775, 
           0.}, {2.7889283899587314`, 0.}, {2.790778459493688, 0.}, {
           2.7926285290286446`, 0.}, {2.794478598563601, 0.}, {
           2.7963286680985577`, 0.}, {2.797716220249775, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.893175999404061, -2.410818666383218*^-15}, {
           2.894846712695475, 0.}, {2.8968515686451717`, 0.}, {
           2.898856424594868, -9.643274665532871*^-16}, {
           2.900861280544565, -9.643274665532871*^-16}, {
           2.9028661364942616`, -9.643274665532871*^-16}, {2.904870992443958, 
           0.}, {2.9068758483936548`, 0.}, {2.9083794903559275`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.761672207561871, 1.4464911998299308`*^-15}, {
           3.7630557613647944`, 0.}, {
           3.764900499768692, -1.9286549331065743`*^-15}, {
           3.76674523817259, -9.643274665532871*^-16}, {
           3.7685899765764876`, -1.9286549331065743`*^-15}, {
           3.7704347149803854`, 0.}, {3.772279453384283, 0.}, {
           3.7736630071872064`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2089797116388519`, 
           1.4464911998299308`*^-15}, {-1.2072265638785282`, \
-1.9286549331065743`*^-15}, {-1.2052229664381584`, 0.}, {-1.2032193689977886`,
            0.}, {-1.2012157715574188`, -9.643274665532871*^-16}, \
{-1.199212174117049, -9.643274665532871*^-16}, {-1.1972085766766791`, \
-9.643274665532871*^-16}, {-1.1952049792363093`, 
           0.}, {-1.1932013817959395`, -1.9286549331065743`*^-15}, \
{-1.1911977843555697`, -9.643274665532871*^-16}, {-1.1891941869151998`, 
           0.}, {-1.18719058947483, 0.}, {-1.1851869920344602`, 
           0.}, {-1.1836842939541827`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8236993380329339, 
           1.4464911998299308`*^-15}, {-0.8222071077643893, 
           0.}, {-0.821460992630117, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7017835174504816, 
           1.4464911998299308`*^-15}, {-0.7001582600957106, \
-1.9286549331065743`*^-15}, {-0.6985330027409395, 1.4464911998299308`*^-15}}],
           LineBox[{{-0.5932140551609982, 
           1.4464911998299308`*^-15}, {-0.5918483825152414, 
           0.}, {-0.5900274856542322, 0.}, {-0.5827438982101958, 
           0.}, {-0.5813782255644389, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.3531464172981133, 
           1.4464911998299308`*^-15}, {-0.3517638073771851, 
           0.}, {-0.34992032748261415`, 
           0.}, {-0.3480768475880432, -9.643274665532871*^-16}, \
{-0.34623336769347224`, 
           0.}, {-0.3443898877989013, -9.643274665532871*^-16}, \
{-0.34254640790433033`, -9.643274665532871*^-16}, {-0.3407029280097594, \
-9.643274665532871*^-16}, {-0.3388594481151884, -9.643274665532871*^-16}, \
{-0.33701596822061747`, 0.}, {-0.3351724883260465, 
           0.}, {-0.33332900843147556`, 0.}, {-0.3314855285369046, 
           0.}, {-0.3301029186159764, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.006162387881169, 1.4464911998299308`*^-15}, {
           1.0077585556022206`, -1.9286549331065743`*^-15}, {
           1.0095827472834227`, 0.}, {1.0114069389646245`, 0.}, {
           1.0132311306458264`, -9.643274665532871*^-16}, {
           1.0150553223270282`, 0.}, {1.0164234660879297`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.3704133795653477`, 1.4464911998299308`*^-15}, {
           1.3719145504124755`, 0.}, {1.3739161115419793`, 0.}, {
           1.3759176726714832`, 0.}, {1.377919233800987, 0.}, {
           1.3799207949304908`, 0.}, {
           1.3819223560599947`, -9.643274665532871*^-16}, {
           1.3839239171894986`, 0.}, {1.3859254783190025`, 0.}, {
           1.3874266491661305`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.721118655820313, 1.4464911998299308`*^-15}, {
           2.722853144621931, -1.9286549331065743`*^-15}, {
           2.724835417538066, -9.643274665532871*^-16}, {2.7268176904542005`, 
           0.}, {2.728799963370335, 0.}, {2.73078223628647, 0.}, {
           2.732764509202605, -9.643274665532871*^-16}, {2.73474678211874, 
           0.}, {2.736729055034875, -9.643274665532871*^-16}, {
           2.738215759721976, -2.410818666383218*^-15}}], 
          LineBox[{{2.8337925761814278`, 1.4464911998299308`*^-15}, {
           2.835180128332645, 0.}, {2.837030197867602, 0.}, {
           2.8388802674025584`, 0.}, {
           2.840730336937515, -1.9286549331065743`*^-15}, {
           2.8425804064724716`, 0.}, {2.8444304760074277`, 0.}, {
           2.846280545542384, 0.}, {
           2.8481306150773404`, -1.9286549331065743`*^-15}, {
           2.849980684612297, 0.}, {2.8513682367635145`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.086362032449799, 1.4464911998299308`*^-15}, {
           3.0880022956446527`, -9.643274665532871*^-16}, {3.089970611478477, 
           0.}, {3.0919389273123015`, 0.}, {3.093907243146126, 0.}, {
           3.0958755589799507`, -9.643274665532871*^-16}, {
           3.0978438748137753`, 0.}, {
           3.0998121906476, -9.643274665532871*^-16}, {3.1017805064814246`, 
           0.}, {3.1037488223152487`, -1.9286549331065743`*^-15}, {
           3.105717138149073, 0.}, {3.1071933750244414`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.213346440305457, 1.4464911998299308`*^-15}, {
           3.214723524644942, 0.}, {3.216559637097588, 0.}, {
           3.2183957495502344`, 0.}, {3.2202318620028807`, 0.}, {
           3.222067974455527, 0.}, {3.223445058795012, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.5785199728768284`, 1.4464911998299308`*^-15}, {
           3.5798865894045804`, 0.}, {
           3.5817087447749163`, -1.9286549331065743`*^-15}, {
           3.5833031307239605`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.9407955294109183`, 1.4464911998299308`*^-15}, {
           3.9423399906667473`, 0.}, {
           3.944399272341186, -9.643274665532871*^-16}, {3.9464585540156243`, 
           0.}, {3.950577117364501, 0.}, {
           3.952636399038939, -9.643274665532871*^-16}, {3.9546956807133773`, 
           0.}, {3.9567549623878158`, 0.}, {3.958299423643645, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2370300758040293`, 
           1.4464911998299308`*^-15}, {-1.2352769280437057`, \
-1.9286549331065743`*^-15}, {-1.2332733306033359`, 0.}, {-1.2252589408418566`,
            0.}, {-1.2232553434014868`, 0.}, {-1.221251745961117, 
           0.}, {-1.2172445510803773`, 0.}, {-1.2152409536400075`, 
           0.}, {-1.2132373561996377`, 0.}, {-1.2112337587592679`, 
           0.}, {-1.2097310606789904`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.9896363546231872, 
           1.4464911998299308`*^-15}, {-0.9880308574227827, \
-1.9286549331065743`*^-15}, {-0.9861960034794632, 0.}, {-0.9843611495361438, 
           0.}, {-0.9825262955928245, 
           0.}, {-0.9806914416495051, -9.643274665532871*^-16}, \
{-0.9788565877061857, 0.}, {-0.9770217337628663, 
           0.}, {-0.9751868798195469, -1.9286549331065743`*^-15}, \
{-0.9733520258762275, 0.}, {-0.9719758854187379, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.3826420956112487, 
           1.4464911998299308`*^-15}, {-0.3812594856903205, 
           0.}, {-0.3794160057957495, -9.643274665532871*^-16}, \
{-0.37757252590117857`, 0.}, {-0.3757290460066076, 
           0.}, {-0.37388556611203666`, 0.}, {-0.3720420862174657, 
           0.}, {-0.36835512642832374`, 
           0.}, {-0.3665116465337528, -9.643274665532871*^-16}, \
{-0.36497541328827693`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.11014238368095924`, 1.4464911998299308`*^-15}, {
           0.11163061560120982`, 0.}, {
           0.11361492482821059`, -9.643274665532871*^-16}, {
           0.11559923405521134`, -9.643274665532871*^-16}, {
           0.1175835432822121, 0.}, {
           0.11956785250921287`, -9.643274665532871*^-16}, {
           0.12155216173621364`, -9.643274665532871*^-16}, {
           0.1235364709632144, 0.}, {0.12552078019021518`, 0.}, {
           0.12750508941721594`, -1.9286549331065743`*^-15}, {
           0.1294893986442167, -1.9286549331065743`*^-15}, {
           0.13147370787121748`, 0.}, {0.13345801709821825`, 0.}, {
           0.13544232632521902`, 0.}, {0.1369305582454696, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.49175470192656456`, 1.4464911998299308`*^-15}, {
           0.4932324660350824, 0.}, {0.49520281817977285`, 0.}, {
           0.49717317032446334`, -1.9286549331065743`*^-15}, {
           0.49914352246915383`, 0.}, {
           0.5011138746138443, -9.643274665532871*^-16}, {0.5027558347344196, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.7379715846929771, 1.4464911998299308`*^-15}, {
           0.7394662860766663, 0.}, {
           0.7414592212549187, -9.643274665532871*^-16}, {0.743120000570129, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.3363868403637822`, 1.4464911998299308`*^-15}, {
           1.33788801121091, 0.}, {1.3418911334699177`, 0.}, {
           1.3498973779879333`, 0.}, {1.3518989391174372`, 0.}, {
           1.353900500246941, -9.643274665532871*^-16}, {
           1.3559020613764448`, -9.643274665532871*^-16}, {
           1.3579036225059486`, 0.}, {1.3594047933530766`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.5910029074652456`, 1.4464911998299308`*^-15}, {
           1.5923775206895856`, 0.}, {1.5942103383220392`, 0.}, {
           1.5960431559544925`, 0.}, {1.5997087912193995`, 0.}, {
           1.601541608851853, -1.9286549331065743`*^-15}, {
           1.6031453242802498`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.687667800360538, 1.4464911998299308`*^-15}, {
           2.6891545050476395`, 0.}, {
           2.691136777963774, -9.643274665532871*^-16}, {2.6931190508799085`, 
           0.}, {2.6951013237960435`, -1.9286549331065743`*^-15}, {
           2.6970835967121785`, -9.643274665532871*^-16}, {
           2.6990658696283134`, 0.}, {2.700552574315415, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.1747880787998866`, 1.4464911998299308`*^-15}, {
           3.1761651631393715`, 0.}, {
           3.1780012755920177`, -1.9286549331065743`*^-15}, {
           3.179837388044664, -9.643274665532871*^-16}, {
           3.1816735004973102`, -9.643274665532871*^-16}, {
           3.1835096129499565`, 0.}, {
           3.1853457254026027`, -1.9286549331065743`*^-15}, {
           3.187181837855249, 0.}, {
           3.1890179503078953`, -9.643274665532871*^-16}, {
           3.1908540627605415`, -1.9286549331065743`*^-15}, {
           3.1926901752131878`, -9.643274665532871*^-16}, {
           3.194526287665834, -9.643274665532871*^-16}, {3.1960563813763727`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.418092773834189, 1.4464911998299308`*^-15}, {
           3.419641686739362, -9.643274665532871*^-16}, {3.4215003822255703`, 
           0.}, {3.4233590777117784`, -9.643274665532871*^-16}, {
           3.4252177731979865`, -9.643274665532871*^-16}, {
           3.4270764686841946`, 0.}, {3.4289351641704027`, 0.}, {
           3.4307938596566108`, 0.}, {
           3.432652555142819, -1.9286549331065743`*^-15}, {3.434511250629027, 
           0.}, {3.436369946115235, 0.}, {3.4377639677298912`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.5491377175301606`, 1.4464911998299308`*^-15}, {
           3.5507321034792048`, -1.9286549331065743`*^-15}, {
           3.552326489428249, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.9076754158137024`, 1.4464911998299308`*^-15}, {
           3.9093914838757344`, -9.643274665532871*^-16}, {
           3.911450765550173, -9.643274665532871*^-16}, {
           3.9135100472246114`, -9.643274665532871*^-16}, {
           3.91556932889905, -1.9286549331065743`*^-15}, {3.917628610573488, 
           0.}, {3.919687892247926, 0.}, {3.921232353503755, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2950688089618816`, 
           1.4464911998299308`*^-15}, {-1.2936822006926594`, 
           0.}, {-1.2918333896670295`, -9.643274665532871*^-16}, \
{-1.2899845786413997`, -9.643274665532871*^-16}, {-1.28813576761577, \
-9.643274665532871*^-16}, {-1.2862869565901405`, 0.}, {-1.284900348320918, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.162813487283664, 
           1.4464911998299308`*^-15}, {-1.1611438227500224`, \
-9.643274665532871*^-16}, {-1.1594741582163808`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7918650923039817, 
           1.4464911998299308`*^-15}, {-0.7903728620354371, 
           0.}, {-0.7883832216773776, 0.}, {-0.7868909914088329, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.1815775158529868, 1.4464911998299308`*^-15}, {
           0.18306574777323736`, 0.}, {0.18505005700023813`, 0.}, {
           0.1870343662272389, 0.}, {0.18901867545423967`, 0.}, {
           0.19100298468124044`, 0.}, {0.19249121660149102`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.30153347633329325`, 1.4464911998299308`*^-15}, {
           0.30292255571766014`, 0.}, {
           0.30477466156348265`, -9.643274665532871*^-16}, {
           0.30662676740930517`, -9.643274665532871*^-16}, {
           0.3081701889474906, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.8037384455753033, 1.4464911998299308`*^-15}, {
           0.8052331469589926, 0.}, {
           0.8072260821372449, -9.643274665532871*^-16}, {0.8088868614524551, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.0355774787405496`, 1.4464911998299308`*^-15}, {
           1.036945622501451, 0.}, {
           1.0387698141826531`, -9.643274665532871*^-16}, {
           1.040594005863855, -9.643274665532871*^-16}, {1.0424181975450568`, 
           0.}, {1.0437863413059585`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.402438357637409, 1.4464911998299308`*^-15}, {
           1.403939528484537, 0.}, {
           1.405941089614041, -9.643274665532871*^-16}, {
           1.4079426507435449`, -9.643274665532871*^-16}, {
           1.4099442118730487`, -1.9286549331065743`*^-15}, {
           1.4119457730025526`, 0.}, {1.4139473341320565`, 0.}, {
           1.4159488952615604`, 0.}, {
           1.4179504563910643`, -9.643274665532871*^-16}, {1.419952017520568, 
           0.}, {1.4219535786500719`, 0.}, {1.4234547494971999`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.7788614120305946`, 1.4464911998299308`*^-15}, {
           1.7803521150659898`, 0.}, {1.784327323160377, 0.}, {
           1.7863149272075705`, 0.}, {1.7878056302429657`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.2613624130926264`, 1.4464911998299308`*^-15}, {
           2.2629736762283685`, -1.9286549331065743`*^-15}, {
           2.2648151198120736`, 0.}, {2.2666565633957787`, 0.}, {
           2.268498006979484, 0.}, {2.270339450563189, 0.}, {
           2.2717205332509676`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.7431714420123128`, -2.410818666383218*^-15}, {
           2.7446581466994138`, -9.643274665532871*^-16}, {
           2.7466404196155487`, -1.9286549331065743`*^-15}, {
           2.7486226925316837`, 0.}, {2.750604965447818, 0.}, {
           2.7525872383639527`, 0.}, {2.7545695112800876`, 0.}, {
           2.7565517841962226`, -9.643274665532871*^-16}, {
           2.7585340571123576`, -9.643274665532871*^-16}, {
           2.7605163300284925`, -9.643274665532871*^-16}, {
           2.762498602944627, -9.643274665532871*^-16}, {2.7644808758607615`, 
           0.}, {2.7664631487768965`, -9.643274665532871*^-16}, {
           2.7684454216930314`, -9.643274665532871*^-16}, {2.769436558151099, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.239052014642505, -2.410818666383218*^-15}, {
           3.2404290989819895`, -9.643274665532871*^-16}, {
           3.2422652114346358`, 0.}, {3.244101323887282, 0.}, {
           3.2459374363399283`, 0.}, {3.2477735487925745`, 0.}, {
           3.2496096612452208`, 0.}, {3.251445773697867, 0.}, {
           3.252822858037352, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.4851607026281974`, 1.4464911998299308`*^-15}, {
           3.4865547242428536`, 0.}, {3.4884134197290617`, 0.}, {
           3.49027211521527, 0.}, {
           3.492130810701478, -1.9286549331065743`*^-15}, {3.49375716925191, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.605700457151006, 1.4464911998299308`*^-15}, {
           3.607218919959619, -9.643274665532871*^-16}, {
           3.609041075329955, -9.643274665532871*^-16}, {
           3.610863230700291, -1.9286549331065743`*^-15}, {3.612457616649335, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.852064389352863, 1.4464911998299308`*^-15}, {
           3.8534479431557864`, 0.}, {3.855292681559684, 0.}, {
           3.857137419963582, 0.}, {3.8608268967713775`, 0.}, {
           3.8626716351752752`, -9.643274665532871*^-16}, {
           3.8642089171785234`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.65148275471329, 
           1.4464911998299308`*^-15}, {-0.650117082067533, 
           0.}, {-0.6482961852065239, -9.643274665532871*^-16}, \
{-0.6464752883455147, -9.643274665532871*^-16}, {-0.6446543914845057, 
           0.}, {-0.6428334946234966, -9.643274665532871*^-16}, \
{-0.6413160805726557, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.4066073342406711, 
           1.4464911998299308`*^-15}, {-0.4052247243197429, 
           0.}, {-0.4033812444251719, 0.}, {-0.4019986345042437, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.7506037771384846`, 1.4464911998299308`*^-15}, {
           3.751987330941408, 0.}, {3.7538320693453056`, 0.}, {
           3.7556768077492033`, 0.}, {3.757521546153101, 0.}, {
           3.759366284556999, -9.643274665532871*^-16}, {3.760903566560247, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.5746106178428312`, 
           1.4464911998299308`*^-15}, {-1.5732409468487802`, 
           0.}, {-1.5695884908646445`, 0.}, {-1.5677622628725767`, 
           0.}, {-1.5659360348805087`, 0.}, {-1.5641098068884407`, 
           0.}, {-1.5627401358943898`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7126959596896592, 
           1.4464911998299308`*^-15}, {-0.7113028819569982, 
           0.}, {-0.7094454449801169, 0.}, {-0.7075880080032356, 
           0.}, {-0.7057305710263544, 0.}, {-0.703873134049473, 
           0.}, {-0.7024800563168121, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.7618868068320047, 1.4464911998299308`*^-15}, {
           0.7633815082156941, 0.}, {0.7653744433939463, 0.}, {
           0.7673673785721986, 0.}, {0.768862079955888, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.9573313897943536`, 1.4464911998299308`*^-15}, {
           2.9590021030857674`, -9.643274665532871*^-16}, {2.961006959035464, 
           0.}, {2.963011814985161, -9.643274665532871*^-16}, {
           2.9646825282765747`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.815169621274907, 1.4464911998299308`*^-15}, {
           3.8165531750778303`, 0.}, {
           3.818397913481728, -9.643274665532871*^-16}, {
           3.820242651885626, -1.9286549331065743`*^-15}, {
           3.8220873902895236`, 0.}, {3.823470944092447, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.9699065782172811, 1.4464911998299308`*^-15}, {
           0.9712747219781825, 0.}, {0.9730989136593845, 0.}, {
           0.9749231053405865, 0.}, {0.9767472970217883, 0.}, {
           0.9785714887029902, 0.}, {0.9803956803841921, 0.}, {
           0.9822198720653941, 0.}, {0.9835880158262955, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.1936893613914683`, -2.410818666383218*^-15}, {
           2.194840263631284, 0.}, {2.1966817072149887`, 0.}, {
           2.1985231507986938`, 0.}, {2.200364594382399, 0.}, {
           2.2017456770701775`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.294969341423513, 1.4464911998299308`*^-15}, {
           3.296462515574053, 0.}, {3.298453414441439, 0.}, {
           3.3004443133088253`, -9.643274665532871*^-16}, {
           3.3024352121762117`, 0.}, {
           3.3044261110435977`, -9.643274665532871*^-16}, {
           3.3060851934330864`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.1748350719258829`, 
           1.4464911998299308`*^-15}, {-1.1731654073922413`, \
-9.643274665532871*^-16}, {-1.1711618099518715`, 0.}, {-1.1691582125115016`, 
           0.}, {-1.1671546150711318`, 
           0.}, {-1.165151017630762, -9.643274665532871*^-16}, \
{-1.1634813530971204`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8018132940942794, 
           1.4464911998299308`*^-15}, {-0.8003210638257348, 
           0.}, {-0.7983314234676752, -9.643274665532871*^-16}, \
{-0.7966733898359588, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.5640797053848524, 
           1.4464911998299308`*^-15}, {-0.5627140327390956, 
           0.}, {-0.5608931358780864, -9.643274665532871*^-16}, \
{-0.5590722390170773, 0.}, {-0.5572513421560682, 
           0.}, {-0.5554304452950591, -9.643274665532871*^-16}, \
{-0.5539130312442182, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.05258663365887261, 1.4464911998299308`*^-15}, {
           0.05395877576806811, 0.}, {0.05533091787726361, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.17736085874561014`, 1.4464911998299308`*^-15}, {
           0.17909712931923583`, -1.9286549331065743`*^-15}, {
           0.1808333998928615, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.7709109958418203`, 1.4464911998299308`*^-15}, {
           1.7724016988772155`, 0.}, {
           1.774389302924409, -9.643274665532871*^-16}, {1.7763769069716027`, 
           0.}, {1.777867610006998, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.5949193712098517`, 1.4464911998299308`*^-15}, {
           3.5962859877376037`, 0.}, {
           3.5981081431079396`, -9.643274665532871*^-16}, {
           3.5999302984782755`, 0.}, {3.6017524538486114`, 0.}, {
           3.6031190703763634`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.844531707536947, 1.4464911998299308`*^-15}, {
           3.8460689895401954`, -9.643274665532871*^-16}, {
           3.847913727944093, -9.643274665532871*^-16}, {3.849758466347991, 
           0.}, {3.851142020150914, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.9716847545274936`, 1.4464911998299308`*^-15}, {
           3.9732292157833227`, 0.}, {3.9752884974577607`, 0.}, {
           3.9773477791321987`, 0.}, {3.978892240388028, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.3400073675860893, 1.4464911998299308`*^-15}, {
           0.3415125367815113, 0.}, {0.3435194290420739, 0.}, {
           0.3455263213026365, -9.643274665532871*^-16}, {0.3475332135631991, 
           0.}, {0.3490383827586211, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.46614012404558847`, 1.4464911998299308`*^-15}, {
           0.4676178881541063, 0.}, {0.4695882402987968, 0.}, {
           0.4715585924434873, -1.9286549331065743`*^-15}, {
           0.47352894458817774`, 0.}, {0.47549929673286817`, 0.}, {
           0.47746964887755866`, 0.}, {0.4789474129860765, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.5763403664056181`, 1.4464911998299308`*^-15}, {
           1.5777149796299583`, 0.}, {1.5795477972624117`, 0.}, {
           1.581380614894865, 0.}, {1.5832134325273186`, 0.}, {
           1.5845880457516586`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.17857417864189, 1.4464911998299308`*^-15}, {
           2.1801087149616443`, -9.643274665532871*^-16}, {2.181950158545349, 
           0.}, {2.183791602129054, 0.}, {
           2.185633045712759, -9.643274665532871*^-16}, {2.187167582032513, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.9093819183307756`, 1.4464911998299308`*^-15}, {
           2.910885560293048, 0.}, {
           2.9128904162427447`, -9.643274665532871*^-16}, {
           2.9148952721924415`, 0.}, {2.9163989141547138`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.525677467137086, 1.4464911998299308`*^-15}, {
           3.527044083664838, 0.}, {3.5288662390351737`, 0.}, {
           3.5306883944055096`, 0.}, {3.5320550109332616`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.8872542058755224`, 1.4464911998299308`*^-15}, {
           3.8887986671313515`, 0.}, {3.89085794880579, 0.}, {
           3.8929172304802284`, 0.}, {3.8944616917360575`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.5619792075643617`, 
           1.4464911998299308`*^-15}, {-1.5604573509043052`, \
-9.643274665532871*^-16}, {-1.5586311229122372`, 
           0.}, {-1.5568048949201692`, -9.643274665532871*^-16}, \
{-1.5549786669281014`, -9.643274665532871*^-16}, {-1.5531524389360336`, 
           0.}, {-1.5517827679419827`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.9418536998492442, 
           1.4464911998299308`*^-15}, {-0.9403246548964779, \
-9.643274665532871*^-16}, {-0.9384898009531585, 0.}, {-0.9371136604956689, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8192226472273001, 
           1.4464911998299308`*^-15}, {-0.8182278270482704, \
-9.643274665532871*^-16}, {-0.8162381866902109, 0.}, {-0.8142485463321513, 
           0.}, {-0.8122589059740917, 0.}, {-0.8102692656160322, 
           0.}, {-0.8082796252579727, -9.643274665532871*^-16}, \
{-0.8066215916262565, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.03246188272400534, 1.4464911998299308`*^-15}, {
           0.03383402483320083, 0.}, {0.035663547645461494`, 0.}, {
           0.037493070457722155`, 0.}, {
           0.03932259326998282, -9.643274665532871*^-16}, {
           0.04115211608224348, 0.}, {0.04298163889450414, 0.}, {
           0.0448111617067648, -9.643274665532871*^-16}, {0.04633576405031535,
            1.4464911998299308`*^-15}}], 
          LineBox[{{1.5128182092428908`, 1.4464911998299308`*^-15}, {
           1.5144557267542507`, -9.643274665532871*^-16}, {
           1.5164207477678824`, 0.}, {1.518385768781514, 0.}, {
           1.5203507897951458`, 0.}, {1.5223158108087775`, 0.}, {
           1.5237895765690013`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.9536885531791697`, 
           1.4464911998299308`*^-15}, {-1.952155065617188, \
-9.643274665532871*^-16}, {-1.9503148805428099`, 0.}, {-1.9484746954684316`, 
           0.}, {-1.9470945566626479`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.3432919632137232`, 
           1.4464911998299308`*^-15}, {-1.3417512873590316`, \
-9.643274665532871*^-16}, {-1.339902476333402, -1.9286549331065743`*^-15}, \
{-1.3380536653077724`, 0.}, {-1.3362048542821425`, 0.}, {-1.33481824601292, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7239953679656868, 
           1.4464911998299308`*^-15}, {-0.7224475038182857, \
-9.643274665532871*^-16}, {-0.7208996396708847, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.36436091999008663`, 
           1.4464911998299308`*^-15}, {-0.3628246867446108, \
-9.643274665532871*^-16}, {-0.36098120685003987`, 0.}, {-0.3591377269554689, 
           0.}, {-0.35729424706089796`, 0.}, {-0.355450767166327, 
           0.}, {-0.3540681572453988, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.2061958323974644`, 1.4464911998299308`*^-15}, {
           2.2077303687172187`, -9.643274665532871*^-16}, {
           2.209571812300924, -1.9286549331065743`*^-15}, {
           2.211413255884629, -9.643274665532871*^-16}, {2.213254699468334, 
           0.}, {2.215096143052039, 0.}, {2.216937586635744, 0.}, {
           2.2187790302194488`, -9.643274665532871*^-16}, {2.220313566539203, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.8152918808318623`, 1.4464911998299308`*^-15}, {
           2.8166794329830793`, 0.}, {2.818529502518036, 0.}, {
           2.8203795720529925`, 0.}, {
           2.822229641587949, -9.643274665532871*^-16}, {2.8240797111229057`, 
           0.}, {2.8259297806578623`, 0.}, {2.8273173328090797`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.1566357285091904`, 
           1.4464911998299308`*^-15}, {-1.155133030428913, 
           0.}, {-1.153129432988543, -9.643274665532871*^-16}, \
{-1.1511258355481733`, 0.}, {-1.1496231374678958`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.3089418997165833, 1.4464911998299308`*^-15}, {
           0.3103309791009502, 0.}, {
           0.3121830849467727, -9.643274665532871*^-16}, {
           0.31403519079259523`, -9.643274665532871*^-16}, {
           0.31588729663841775`, -9.643274665532871*^-16}, {
           0.31773940248424026`, 0.}, {
           0.3195915083300628, -9.643274665532871*^-16}, {
           0.32113492986824815`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.8097172511100602, 1.4464911998299308`*^-15}, {
           0.8112119524937496, 0.}, {
           0.8132048876720018, -9.643274665532871*^-16}, {0.8151978228502541, 
           0.}, {0.8171907580285065, -9.643274665532871*^-16}, {
           0.8191836932067588, -9.643274665532871*^-16}, {0.820844472521969, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.496312875545446, 1.4464911998299308`*^-15}, {
           3.497706897160102, 0.}, {3.4995655926463103`, 0.}, {
           3.5009596142609665`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.614963080283547, 1.4464911998299308`*^-15}, {
           3.616329696811299, 0.}, {3.6181518521816347`, 0.}, {
           3.6199740075519706`, 0.}, {3.6217961629223066`, 0.}, {
           3.623162779450059, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.9840404445741235`, 1.4464911998299308`*^-15}, {
           3.9855849058299526`, 0.}, {3.9876441875043906`, 0.}, {
           3.9897034691788287`, 0.}, {3.991762750853267, 0.}, {
           3.9938220325277056`, 0.}, {3.9953664937835347`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.6330499135890029`, 
           1.4464911998299308`*^-15}, {-1.631680242594952, 
           0.}, {-1.6298540146028841`, 0.}, {-1.6284843436088332`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.27284438005064, 
           1.4464911998299308`*^-15}, {-1.2713416819703625`, 
           0.}, {-1.2693380845299926`, 0.}, {-1.2678353864497152`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.557859455278379, 1.4464911998299308`*^-15}, {
           1.5593868033054237`, -9.643274665532871*^-16}, {1.561219620937877, 
           0.}, {1.5625942341622172`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.8114801444671116`, 1.4464911998299308`*^-15}, {
           3.812863698270035, 0.}, {3.814247252072958, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.1131503617039766`, 
           1.4464911998299308`*^-15}, {-1.1116750687106034`, 
           0.}, {-1.1097080113861058`, 
           0.}, {-1.107740954061608, -9.643274665532871*^-16}, \
{-1.1061017396245267`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.781810601804422, 1.4464911998299308`*^-15}, {
           3.7833478838076706`, -9.643274665532871*^-16}, {
           3.7851926222115684`, -1.9286549331065743`*^-15}, {
           3.786806768314979, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.1714906106157329, 1.4464911998299308`*^-15}, {
           0.17314420163823352`, -9.643274665532871*^-16}, {
           0.1751285108652343, 0.}, {0.17661674278548486`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.231554555460866, 1.4464911998299308`*^-15}, {
           3.2330846491714045`, -9.643274665532871*^-16}, {
           3.2349207616240507`, -9.643274665532871*^-16}, {3.236756874076697, 
           0.}, {3.2382869677872357`, -2.410818666383218*^-15}}], 
          LineBox[{{3.8391512205255784`, 1.4464911998299308`*^-15}, {
           3.8405347743285017`, 0.}, {3.8423795127324, 0.}, {
           3.843763066535323, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.9356466865392161`, 1.4464911998299308`*^-15}, {
           1.9371624036643353`, -9.643274665532871*^-16}, {
           1.9389812642144784`, 0.}, {1.9403454096270858`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.2980117959673314`, 1.4464911998299308`*^-15}, {
           2.299508968466165, 0.}, {2.3015051984646098`, 0.}, {
           2.3030023709634437`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.5806195185390185, 
           1.4464911998299308`*^-15}, {-0.5791021044881776, \
-9.643274665532871*^-16}, {-0.5772812076271685, -1.9286549331065743`*^-15}, \
{-0.5756879228737855, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.235658929736745, 1.4464911998299308`*^-15}, {
           2.237193466056499, -9.643274665532871*^-16}, {2.2390349096402042`, 
           0.}, {2.240415992327983, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.2476680646506222, -2.410818666383218*^-15}, {
           0.24921148618880762`, 0.}, {
           0.25106359203463013`, -9.643274665532871*^-16}, {
           0.25260701357281556`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.9845001116668963, 1.4464911998299308`*^-15}, {
           0.9858682554277978, 0.}, {
           0.9876924471089997, -9.643274665532871*^-16}, {0.9895166387902017, 
           0.}, {0.9908847825511031, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.7212208946619814`, 1.4464911998299308`*^-15}, {
           1.7227115976973766`, 0.}, {1.7246992017445701`, 0.}, {
           1.7266868057917637`, 0.}, {1.728177508827159, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.2893941815551855`, 1.4464911998299308`*^-15}, {
           1.2907792625912582`, 0.}, {1.292626037306022, 0.}, {
           1.2940111183420948`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.1298290071134236`, 1.4464911998299308`*^-15}, {
           3.131305243988792, 0.}, {3.1332735598226167`, 0.}, {
           3.1347497966979847`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.0652574730610973`, 1.4464911998299308`*^-15}, {
           1.0669066214743823`, -9.643274665532871*^-16}, {
           1.0688855995703244`, 0.}, {1.0703698331422808`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.5633579081757396`, 1.4464911998299308`*^-15}, {
           1.5648852562027842`, -9.643274665532871*^-16}, {
           1.5667180738352375`, 0.}, {1.5685508914676909`, 0.}, {
           1.569925504692031, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.397802014776417, 1.4464911998299308`*^-15}, {
           3.399196036391073, 0.}, {3.4010547318772812`, 0.}, {
           3.4024487534919374`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.9528628235091606, 
           1.4464911998299308`*^-15}, {-0.9513337785563944, \
-9.643274665532871*^-16}, {-0.949498924613075, -9.643274665532871*^-16}, \
{-0.9476640706697556, -9.643274665532871*^-16}, {-0.9461350257169894, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8278444221122248, 
           1.4464911998299308`*^-15}, {-0.8261863884805084, \
-9.643274665532871*^-16}, {-0.8245283548487921, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.105282132405986, 
           1.4464911998299308`*^-15}, {-1.1038068394126128`, 
           0.}, {-1.1018397820881152`, -9.643274665532871*^-16}, \
{-1.1002005676510338`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.8605621180897451, 1.4464911998299308`*^-15}, {
           0.8621127279206402, -9.643274665532871*^-16}, {0.8636633377515353, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.7874985452164407`, 1.4464911998299308`*^-15}, {
           3.788882099019364, 0.}, {
           3.7907268374232617`, -9.643274665532871*^-16}, {
           3.7925715758271594`, 0.}, {3.7939551296300826`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7960101763832723, 
           1.4464911998299308`*^-15}, {-0.7943521427515561, \
-9.643274665532871*^-16}, {-0.7926941091198398, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.7977596400405463, 1.4464911998299308`*^-15}, {
           0.7992543414242357, 0.}, {0.801247276602488, 0.}, {
           0.8027419779861772, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.99674641365355, 
           1.4464911998299308`*^-15}, {-0.9953702731960604, 
           0.}, {-0.993535419252741, 
           0.}, {-0.9917005653094215, -9.643274665532871*^-16}, \
{-0.9901715203566553, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.9412548399021574`, 1.4464911998299308`*^-15}, {
           1.9426189853147648`, 0.}, {1.9444378458649079`, 0.}, {
           1.945801991277515, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.165378002480075, 1.4464911998299308`*^-15}, {
           3.16698460087614, -1.9286549331065743`*^-15}, {
           3.1688207133287865`, -1.9286549331065743`*^-15}, {
           3.1706568257814327`, -9.643274665532871*^-16}, {
           3.1721869194919714`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.16355337370772985`, 1.4464911998299308`*^-15}, {
           0.1652069647302305, -9.643274665532871*^-16}, {
           0.16719127395723127`, -1.9286549331065743`*^-15}, {
           0.16917558318423204`, 0.}, {0.17066381510448259`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.760807341935253, 1.4464911998299308`*^-15}, {
           1.7624636786412478`, -9.643274665532871*^-16}, {
           1.7644512826884413`, 0.}, {
           1.7664388867356349`, -9.643274665532871*^-16}, {
           1.7680952234416296`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.589452905098844, 1.4464911998299308`*^-15}, {
           3.590819521626596, 0.}, {3.592641676996932, 0.}, {
           3.5940082935246838`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.3601553787766405`, 1.4464911998299308`*^-15}, {
           1.3619067447649562`, -1.9286549331065743`*^-15}, {1.36390830589446,
            0.}, {1.365409476741588, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.802256452447623, 1.4464911998299308`*^-15}, {
           3.803640006250546, 0.}, {3.8054847446544438`, 0.}, {
           3.806868298457367, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7819168905136841, 
           1.4464911998299308`*^-15}, {-0.7804246602451395, 
           0.}, {-0.77843501988708, 0.}, {-0.7769427896185354, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.2726412550428203`, 1.4464911998299308`*^-15}, {
           2.274022337730599, 0.}, {2.275863781314304, 0.}, {
           2.277244864002083, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.5018889620040703`, 1.4464911998299308`*^-15}, {
           3.5032829836187265`, 0.}, {3.505141679104934, 0.}, {
           3.5065357007195903`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.366243460545548, 1.4464911998299308`*^-15}, {
           1.367911428153468, -9.643274665532871*^-16}, {1.3695793957613878`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.8300924371115146`, 1.4464911998299308`*^-15}, {
           2.831479989262732, 0.}, {2.8328675414139495`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.5855044545678854`, 1.4464911998299308`*^-15}, {
           1.5868790677922253`, 0.}, {1.5882536810165655`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.8057925748103983, 
           1.4464911998299308`*^-15}, {-0.8043003445418537, 
           0.}, {-0.8028081142733091, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.046945604987735576`, 1.4464911998299308`*^-15}, {
           0.048470207331286125`, -9.643274665532871*^-16}, {
           0.049994809674836674`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.5706891787055535`, 1.4464911998299308`*^-15}, {
           1.572216526732598, -9.643274665532871*^-16}, {
           1.573591139956938, -2.410818666383218*^-15}}], 
          LineBox[{{-0.945523407735883, 
           1.4464911998299308`*^-15}, {-0.9439943627831168, \
-9.643274665532871*^-16}, {-0.9424653178303506, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.3469895852649827`, 
           1.4464911998299308`*^-15}, {-1.3454489094102913`, \
-9.643274665532871*^-16}, {-1.3439082335555996`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.6277234152788052`, 
           1.4464911998299308`*^-15}, {-1.6262015586187486`, \
-9.643274665532871*^-16}, {-1.6246797019586918`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.3838117381921076`, 
           1.4464911998299308`*^-15}, {-1.3824251299228854`, 
           0.}, {-1.381038521653663, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.1285847721312416`, 1.4464911998299308`*^-15}, {
           1.1302339205445266`, -9.643274665532871*^-16}, {
           1.1318830689578117`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.6835380651185905`, 1.4464911998299308`*^-15}, {
           2.6851899592153696`, -9.643274665532871*^-16}, {
           2.6868418533121488`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.543899020840445, 1.4464911998299308`*^-15}, {
           3.545265637368197, 0.}, {3.546632253895949, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.3040004859626664`, 1.4464911998299308`*^-15}, {
           2.3054976584615003`, 0.}, {2.306994830960334, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{0.9917968783917039, 1.4464911998299308`*^-15}, {
           0.9931650221526054, 0.}, {0.9945331659135068, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.9263805576898507`, 1.4464911998299308`*^-15}, {
           3.92792501894568, 0.}, {3.9294694802015084`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{1.2949345056994768`, 1.4464911998299308`*^-15}, {
           1.2963195867355495`, 0.}, {1.2977046677716224`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.135733954614897, 1.4464911998299308`*^-15}, {
           3.137210191490265, 0.}, {3.1386864283656335`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.770276505972978, 
           1.4464911998299308`*^-15}, {-0.7688834282403171, 
           0.}, {-0.7674903505076561, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2987664310131408`, 
           1.4464911998299308`*^-15}, {-1.2973798227439186`, 
           0.}, {-1.2959932144746964`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.2218929249629257, 1.4464911998299308`*^-15}, {
           0.22328200434729256`, 0.}, {0.22467108373165945`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{3.1617057775747823`, 1.4464911998299308`*^-15}, {
           3.1633123759708477`, -1.9286549331065743`*^-15}, {
           3.164918974366913, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.583834592706975, 1.4464911998299308`*^-15}, {
           3.585353055515588, -9.643274665532871*^-16}, {3.5868715183242013`, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-0.9710584584470783, 
           1.4464911998299308`*^-15}, {-0.9696823179895886, 
           0.}, {-0.968306177532099, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.6036798960897152`, 1.4464911998299308`*^-15}, {
           1.6052072441167597`, -9.643274665532871*^-16}, {
           1.6067345921438043`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.922090387534771, 1.4464911998299308`*^-15}, {
           3.923806455596803, -9.643274665532871*^-16}, {3.925522523658835, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{-1.2839759428081032`, 
           1.4464911998299308`*^-15}, {-1.2825893345388808`, 
           0.}, {-1.2812027262696586`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-0.7860619745929748, 
           1.4464911998299308`*^-15}, {-0.7844039409612584, \
-9.643274665532871*^-16}, {-0.7827459073295422, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.959055759646106, 
           1.4464911998299308`*^-15}, {-1.9576756208403223`, 
           0.}, {-1.9562954820345386`, 1.4464911998299308`*^-15}}], 
          LineBox[{{0.24411819511279573`, 1.4464911998299308`*^-15}, {
           0.2455072744971626, 0.}, {
           0.24705069603534802`, -2.410818666383218*^-15}}], 
          LineBox[{{1.100796621367389, 1.4464911998299308`*^-15}, {
           1.1025282272013384`, -1.9286549331065743`*^-15}, {
           1.1042598330352877`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.2025129452300543`, 1.4464911998299308`*^-15}, {
           2.2040474815498086`, -9.643274665532871*^-16}, {2.205582017869563, 
           1.4464911998299308`*^-15}}], 
          LineBox[{{2.9974285087882864`, 1.4464911998299308`*^-15}, {
           2.9990992220797006`, -9.643274665532871*^-16}, {
           3.0007699353711144`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.9797502744190436`, 1.4464911998299308`*^-15}, {
           3.9814663424810757`, -9.643274665532871*^-16}, {
           3.9831824105431077`, 1.4464911998299308`*^-15}}], 
          LineBox[{{-1.117084476352972, 
           1.4464911998299308`*^-15}, {-1.1156091833595987`, 
           0.}, {-1.1141338903662255`, 1.4464911998299308`*^-15}}], 
          LineBox[{{3.9962245278145505`, 1.4464911998299308`*^-15}, {
           3.9979405958765826`, -9.643274665532871*^-16}, {
           3.9999998775510206`, 0.}}], 
          LineBox[{{3.8093586953026293`, -2.410818666383218*^-15}, {
           3.8108344860257475`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.738909555242623, -2.410818666383218*^-15}, {
           2.7404953735755306`, 1.4464911998299308`*^-15}}], 
          LineBox[{{1.5742326261282968`, -2.410818666383218*^-15}, {
           1.5756988802342595`, 1.4464911998299308`*^-15}}], 
          LineBox[{{2.7408918281587575`, 1.4464911998299308`*^-15}, {
           2.742477646491665, -2.410818666383218*^-15}}], 
          LineBox[{{3.807513956898731, 1.4464911998299308`*^-15}, {
           3.8089897476218493`, -2.410818666383218*^-15}}]},
         Annotation[#, "Charting`Private`Tag$792334#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-2., -2.410818666383218*^-15},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-3.*^-15, 
           FormBox[
            TemplateBox[{"\[Times]", "\"\[Times]\"", 
              RowBox[{"-", "3.`"}], 
              TemplateBox[{"10", 
                RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
               SuperscriptBox]}, "RowWithSeparators"], 
            TraditionalForm]}, {-2.*^-15, 
           FormBox[
            TemplateBox[{"\[Times]", "\"\[Times]\"", 
              RowBox[{"-", "2.`"}], 
              TemplateBox[{"10", 
                RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
               SuperscriptBox]}, "RowWithSeparators"], 
            TraditionalForm]}, {-1.*^-15, 
           FormBox[
            TemplateBox[{"\[Times]", "\"\[Times]\"", 
              RowBox[{"-", "1.`"}], 
              TemplateBox[{"10", 
                RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
               SuperscriptBox]}, "RowWithSeparators"], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {1.*^-15, 
           FormBox[
            TemplateBox[{"\[Times]", "\"\[Times]\"", "1.`", 
              TemplateBox[{"10", 
                RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
               SuperscriptBox]}, "RowWithSeparators"], TraditionalForm]}, {
          2.*^-15, 
           FormBox[
            TemplateBox[{"\[Times]", "\"\[Times]\"", "2.`", 
              TemplateBox[{"10", 
                RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
               SuperscriptBox]}, "RowWithSeparators"], 
            TraditionalForm]}, {-3.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.8*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.6*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.4*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.2*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.8*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.6*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.4*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.2*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-8.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-6.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-4.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {2.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {4.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {6.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {8.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.2*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.4*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.6*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.8*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {2.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-4.821637332766437*^-16, 
           FormBox[
            StyleBox[
            "\"9999999999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-3.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-2.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-3.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.8*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.6*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.4*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.2*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.8*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.6*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.4*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.2*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-8.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-6.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-4.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {2.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {4.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {6.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {8.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.2*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.4*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.6*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.8*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {2.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {3., 
           FormBox["1000", TraditionalForm]}, {4., 
           FormBox[
            
            TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
             SuperscriptBox], TraditionalForm]}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.4771212547196626`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.6020599913279625`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.7781512503836434`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.9030899869919438`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.9542425094393248`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {3., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {4., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.4771212547196626`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.6020599913279625`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.7781512503836434`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.9030899869919438`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.9542425094393248`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-2., 4}, {-2.410818666383218*^-15, 
        1.4464911998299308`*^-15}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-2., 
          FormBox["0.01`", TraditionalForm]}, {-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {3., 
          FormBox["1000", TraditionalForm]}, {4., 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {-1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.5228787452803376`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.2218487496163564`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.0969100130080565`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.045757490560675, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.4771212547196626`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6020599913279625`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.7781512503836434`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9030899869919438`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9542425094393248`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.4771212547196626`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.6020599913279625`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.7781512503836434`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.9030899869919438`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.9542425094393248`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-3.*^-15, 
          FormBox[
           TemplateBox[{"\[Times]", "\"\[Times]\"", 
             RowBox[{"-", "3.`"}], 
             TemplateBox[{"10", 
               RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
              SuperscriptBox]}, "RowWithSeparators"], 
           TraditionalForm]}, {-2.*^-15, 
          FormBox[
           TemplateBox[{"\[Times]", "\"\[Times]\"", 
             RowBox[{"-", "2.`"}], 
             TemplateBox[{"10", 
               RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
              SuperscriptBox]}, "RowWithSeparators"], 
           TraditionalForm]}, {-1.*^-15, 
          FormBox[
           TemplateBox[{"\[Times]", "\"\[Times]\"", 
             RowBox[{"-", "1.`"}], 
             TemplateBox[{"10", 
               RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
              SuperscriptBox]}, "RowWithSeparators"], TraditionalForm]}, {
         0., 
          FormBox["0", TraditionalForm]}, {1.*^-15, 
          FormBox[
           TemplateBox[{"\[Times]", "\"\[Times]\"", "1.`", 
             TemplateBox[{"10", 
               RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
              SuperscriptBox]}, "RowWithSeparators"], TraditionalForm]}, {
         2.*^-15, 
          FormBox[
           TemplateBox[{"\[Times]", "\"\[Times]\"", "2.`", 
             TemplateBox[{"10", 
               RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
              SuperscriptBox]}, "RowWithSeparators"], 
           TraditionalForm]}, {-3.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2.8*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2.6*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2.4*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2.2*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.8*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.6*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.4*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.2*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-8.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-6.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-4.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {2.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {4.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {6.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {8.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {1.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {1.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {1.2*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {1.4*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {1.6*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {1.8*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {2.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-4.821637332766437*^-16, 
          FormBox[
           StyleBox[
           "\"9999999999\"", ShowContents -> False, StripOnInput -> False], 
           TraditionalForm], 0}}}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV13c4lt8bAHCvvYkoMypbKHvkORkZqWSFJON9X0nR0JARKqlkRLJllEgq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           "]]},
         Annotation[#, "Charting`Private`Tag$792962#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1nc8V98fB/CPPT52ITNKZCYz8x67ZK9USF8SQtbnIyujkialEDIiClEq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           "]]},
         Annotation[#, "Charting`Private`Tag$792962#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1nc4V98fAPCPvffKjOyZMkK4p6xChJQkIyOEFrLdpKKs4msnIkpCSgM5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           "]]},
         Annotation[#, "Charting`Private`Tag$792962#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-2., -539.8624900876475},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-600., 
           FormBox[
            RowBox[{"-", "600"}], TraditionalForm]}, {-500., 
           FormBox[
            RowBox[{"-", "500"}], TraditionalForm]}, {-400., 
           FormBox[
            RowBox[{"-", "400"}], TraditionalForm]}, {-300., 
           FormBox[
            RowBox[{"-", "300"}], TraditionalForm]}, {-200., 
           FormBox[
            RowBox[{"-", "200"}], TraditionalForm]}, {-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-600., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-580., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-560., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-540., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-520., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-500., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-500., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-480., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-460., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-440., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-420., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-400., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-400., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-380., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-360., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-340., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-320., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-280., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-260., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-269.93124504382376`, 
           FormBox[
            StyleBox[
            "\"9999999999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-600., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-500., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-400., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-600., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-580., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-560., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-540., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-520., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-500., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-500., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-480., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-460., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-440., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-420., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-400., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-400., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-380., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-360., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-340., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-320., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-280., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-260., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {3., 
           FormBox["1000", TraditionalForm]}, {4., 
           FormBox[
            
            TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
             SuperscriptBox], TraditionalForm]}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.4771212547196626`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.6020599913279625`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.7781512503836434`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.9030899869919438`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {3.9542425094393248`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {3., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {4., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.4771212547196626`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.6020599913279625`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.7781512503836434`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.9030899869919438`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {3.9542425094393248`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-2., 4}, {-539.8624900876475, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-2., 
          FormBox["0.01`", TraditionalForm]}, {-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {3., 
          FormBox["1000", TraditionalForm]}, {4., 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {-1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.5228787452803376`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.2218487496163564`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.0969100130080565`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.045757490560675, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.4771212547196626`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6020599913279625`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.7781512503836434`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9030899869919438`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9542425094393248`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.4771212547196626`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.6020599913279625`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.7781512503836434`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.9030899869919438`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.9542425094393248`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-600., 
          FormBox[
           RowBox[{"-", "600"}], TraditionalForm]}, {-500., 
          FormBox[
           RowBox[{"-", "500"}], TraditionalForm]}, {-400., 
          FormBox[
           RowBox[{"-", "400"}], TraditionalForm]}, {-300., 
          FormBox[
           RowBox[{"-", "300"}], TraditionalForm]}, {-200., 
          FormBox[
           RowBox[{"-", "200"}], TraditionalForm]}, {-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-600., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-580., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-560., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-540., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-520., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-500., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-500., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-480., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-460., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-440., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-420., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-400., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-400., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-380., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-360., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-340., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-320., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-300., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-300., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-280., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-260., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-240., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-220., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-180., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-160., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-140., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-120., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-269.93124504382376`, 
          FormBox[
           StyleBox[
           "\"9999999999\"", ShowContents -> False, StripOnInput -> False], 
           TraditionalForm], 0}}}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.501591888270073*^9, 3.5015919299711733`*^9, 3.50159199147089*^9, 
   3.501592077122225*^9, 3.501592186478629*^9, {3.501592272247191*^9, 
   3.5015922958934507`*^9}, {3.501592366862146*^9, 3.5015923771241713`*^9}, {
   3.5053085257233143`*^9, 3.505308532304352*^9}, 3.505308588473485*^9, 
   3.505308712060595*^9, {3.505308934513095*^9, 3.505308945038508*^9}, {
   3.5053091714886627`*^9, 3.50530918336551*^9}, {3.5053096469701157`*^9, 
   3.505309718412923*^9}, 3.505309846495542*^9, 3.756405126672737*^9, 
   3.7564051984247007`*^9, 3.7564097228718977`*^9, 3.7933252691616907`*^9, 
   3.793848341242112*^9, 3.823227982258999*^9},
 CellLabel->
  "Out[2131]=",ExpressionUUID->"7d4b7ec1-6336-449f-b4c4-3468154e59d3"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5015940518919888`*^9, 3.5015940548719387`*^9}},
 CellLabel->
  "In[2132]:=",ExpressionUUID->"9b099472-921a-4155-bc7b-bea7b57af91a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     FractionBox["s", "2"], "+", 
     FractionBox[
      SuperscriptBox["s", "2"], "12"]}], "\[Equal]", "0"}], ",", "s"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.505308304260954*^9, 3.505308317014002*^9}, {
  3.5053087159352493`*^9, 3.505308719308135*^9}},
 CellLabel->
  "In[2133]:=",ExpressionUUID->"4a2a5292-acd3-4ff4-890a-80245aa6ce2e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", "\[Rule]", 
     RowBox[{"3", "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", "\[Rule]", 
     RowBox[{"3", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.505308318429346*^9, 3.505308719707796*^9, {3.505308934976658*^9, 
   3.505308945494998*^9}, 3.505309171601995*^9, {3.5053096474482737`*^9, 
   3.505309718892338*^9}, 3.505309846951956*^9, 3.756405127140645*^9, 
   3.756405198879575*^9, 3.7564097230625467`*^9, 3.793325269348515*^9, 
   3.793848341428252*^9, 3.823227982397202*^9},
 CellLabel->
  "Out[2133]=",ExpressionUUID->"6af78b73-8aad-4a41-9ec9-ac6fe2a62f51"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      FractionBox["s", "2"], "+", 
      FractionBox[
       SuperscriptBox["s", "2"], "10"], "-", 
      FractionBox[
       SuperscriptBox["s", "3"], "120"]}], "\[Equal]", "0"}], ",", "s"}], 
   "]"}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.505308355839522*^9, 3.505308359797381*^9}, {
  3.5053087223683558`*^9, 3.505308731935708*^9}},
 CellLabel->
  "In[2134]:=",ExpressionUUID->"2d976f13-ff63-4b7b-a2b0-74804f937bd6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", "\[Rule]", "4.644370709252172`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", "\[Rule]", 
     RowBox[{"3.677814645373914`", "\[VeryThinSpace]", "-", 
      RowBox[{"3.5087619195674424`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", "\[Rule]", 
     RowBox[{"3.677814645373914`", "\[VeryThinSpace]", "+", 
      RowBox[{"3.5087619195674424`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.505308356756287*^9, 3.50530836009136*^9}, 
   3.505308732354723*^9, {3.5053089350119123`*^9, 3.50530894555258*^9}, 
   3.505309171673441*^9, {3.505309647484539*^9, 3.5053097189314623`*^9}, 
   3.505309846990484*^9, 3.756405127248589*^9, 3.756405198958783*^9, 
   3.7564097231944647`*^9, 3.793325269355919*^9, 3.7938483414341993`*^9, 
   3.823227982402296*^9},
 CellLabel->
  "Out[2134]=",ExpressionUUID->"880a4a11-adfe-4ae7-a643-d6d0687a88dc"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmax", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G1tf", " ", "=", "  ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"G1", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G2tf", " ", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"G2", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G3tf", " ", "=", " ", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"G3", ",", "s"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.505308783666422*^9, 3.505308786707032*^9}, {
  3.5053089301856728`*^9, 3.505308941768425*^9}, {3.756405173077648*^9, 
  3.756405182634859*^9}},
 CellLabel->
  "In[2135]:=",ExpressionUUID->"36bf29ef-87a7-4bff-8104-f3fb6a482f8c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y1", " ", "=", " ", 
  RowBox[{
   RowBox[{"OutputResponse", "[", 
    RowBox[{"G1tf", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}], " ", "//", " ", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.505308757789171*^9, 3.50530877669248*^9}, {
  3.505311559534727*^9, 3.505311579035307*^9}},
 CellLabel->
  "In[2139]:=",ExpressionUUID->"4b971cb1-4f3d-4112-bcc2-716e0b39260c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "t"}]]}]}], ")"}], " ", 
   RowBox[{"UnitStep", "[", "t", "]"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5053115631181307`*^9, 3.505311579503991*^9}, 
   3.756405127495183*^9, 3.756405199059857*^9, 3.7564097233971987`*^9, 
   3.793325269463646*^9, 3.793848341515764*^9, 3.8232279824895763`*^9},
 CellLabel->
  "Out[2139]=",ExpressionUUID->"051af68a-4a3a-4aea-ae1c-26a0638bec7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y2", " ", "=", " ", 
  RowBox[{
   RowBox[{"OutputResponse", "[", 
    RowBox[{"G2tf", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", "t"}], "]"}], " ", "//", " ", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.505308851299265*^9, 3.5053088552171383`*^9}, {
  3.505311569701127*^9, 3.5053115834058037`*^9}},
 CellLabel->
  "In[2140]:=",ExpressionUUID->"e28c8f14-e301-4102-95e1-e778fb38708e"],

Cell[BoxData[
 RowBox[{"{", 
  TagBox[GridBox[{
     {"\[Piecewise]", GridBox[{
        {
         RowBox[{"1", "-", 
          RowBox[{"4", " ", 
           SqrtBox["3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "3"}], " ", "t"}]], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             SqrtBox["3"], " ", "t"}], "]"}]}]}], 
         RowBox[{"t", "\[GreaterEqual]", "0"}]},
        {"0", 
         TagBox["True",
          "PiecewiseDefault",
          AutoDelete->True]}
       },
       AllowedDimensions->{2, Automatic},
       Editable->True,
       GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.84]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}},
       Selectable->True]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   "Piecewise",
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True,
   Selectable->False,
   StripWrapperBoxes->True], "}"}]], "Output",
 CellChangeTimes->{{3.505311572598585*^9, 3.505311584335156*^9}, 
   3.7564051285490637`*^9, 3.756405200080825*^9, 3.756409724385421*^9, 
   3.7933252703326693`*^9, 3.793848342394923*^9, 3.823227983407434*^9},
 CellLabel->
  "Out[2140]=",ExpressionUUID->"ffe7deb7-5561-4ab8-9ef7-4e1386e2fabf"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"y3", " ", "=", " ", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"G3tf", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.50530886100681*^9, 3.505308863741817*^9}},
 CellLabel->
  "In[2141]:=",ExpressionUUID->"3097185d-f6b2-4026-bf3f-20b7111ed909"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y1", ",", "y2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5053088056504927`*^9, 3.505308806335415*^9}, {
  3.5053088668545103`*^9, 3.505308870718658*^9}, {3.505311600688553*^9, 
  3.505311632212954*^9}},
 CellLabel->
  "In[2142]:=",ExpressionUUID->"daeb9722-d523-4ead-a3d5-77aecd5b3103"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV0Hk41HkcB/Bx5Gut0MZsYWzECO2jsm1sT/P5JtWqlRERk2vckmtLRVSK
SsY6qmd1OHazcqxtO0bZ9AsT06aZjinbMWQQxsz8hMUQs7/94/28n9ef77c1
N2lnlDaNRvOi8n9Pb0+8wk5KZl3OyDmi0ZBEbqT9CjFzB+xkT3m+7yWJJ6r+
eB4zBM69a/QQt5HE6M1N+QnMRPCoPljddYoksunjlnuYWXA1rC+myIQkHnds
G/BlFkDWoLPRr7YqIqki7ZE3swyMlMfDFgUoiJb8/L+8mA3w4Y5ZZmPfELFA
LxUNxxPw1KR5l/EXMsLzaHjObf8OcI1/6qPV9w/ReDhKWvVMBNdKRyPGHETE
66C9zqkHX4DJ3aajxjV8YtFWXnQL7gLaV+oYm54KMJFE3VjHeQvYycc+idEG
y5cl1ORwe8AwfnvfrXkxuEr3Pd5Y3AuukvLLQ+yX0DJz7AfJpT74rZpext37
BmIJofB+9gBcv2Cu90dlN5RGVJubhQ1CeaVS3MDsha93907ORw2DH/o9bpVc
Bt3j3iLsOQJsv3TGp5B+GOtZuoq+SwkSqzxOqGAACuvSYwICSDgdfCX3gPoD
MI31vQ5dGoXrom2PWqcHgZ98rK6g/COk4cWCHuUQSOxKkE/xGLS69/isvTMM
tiderAguHYegTtE9Wroc3Ng935RfmoDu54aDudYjIE3OYfHy/4X9XI95ad0I
3HALXPiwaBL07yvOFq5SAN2/4/W1nCngsrwOLy5TAMhoRa37p8HIPnhN1pwC
SumxC5mH1PBMOpZsH6iE7LK4U2vjZ8DZwZ4luaqEK6Kf2wuSZ0G8d0IaqFRC
ZmLJKCP1E2SxfFONV6pgJHzFkkDuHHxmmeLzJlQFZ+fkut3R88A6EXnhpyIV
NCm2kkZBGhC7L1FfaFLBKztX2Xe2NBw2oFwW2K2CWIcI55IqGr5+XqRupJHQ
4s/J2GilhR9VOgYsZZDgslteY1qphd9IkhTeriQknNjStcFCG4c2yG4JdlC/
RuvPaJVo4yzB5jt+XBKaGeEauakOtjMVyhkHSLg7n6vjWKCDO/KUtIqTJIhu
bpLzFuliblhIYEYJCQ+XRbfnF+viYEuXI74VJJxs3FXZa7AAW/gPTqhqSdhj
8y6Ew1uArbWZ6y1vkzDLd7ZwQno4vVYel91MwhGd4c7zWXr45aS+iURAAt3W
LdyOhnDajvigd49JOJjoP2FwGOGxuOdE7TMSLL+NFDIzEHaw5TDbKD+YS7ns
nolw23qDY28pG/B4HunHEd5cNGlo+JyEsjrBueEzCJ9OEfASKLcPrVkrvIiw
hbfRaqcXJJhGGKfl3EPYv3TfynIJtdeRsa3yPsJmBRd1+ZRDxhytmh8gvLqW
eNpJ+drxLe0TAoSn6j/fPEN5fUUmPfIJwmdSOGV+L0ngSkf47t0In2z1XYpe
kYCq1Hkh7xH+ct2EC4NyfQIKTZchXFs16u5CeXLWBt34gLDluBkrlHKeeVCA
NYmw2LG5hk/ZWRbjtOEjwvzwoZhOypKaA5rd4wj/sqnCXEbZyq2ounAKYbat
KHhhFwlttPKMejXCeg5slQ3lWGG9t3AW4Yb+tB9dKRsWNi3vn0M4aOf3Si/K
fwYIpzQahKfj/uZEUP4P4l5kHg==
       "]]},
     Annotation[#, "Charting`Private`Tag$796291#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV13k8VF0YB/A7qPFKkZCyJEmElC1JnktClBSVZCkhIansUVlLKBUllIgk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       "]]},
     Annotation[#, "Charting`Private`Tag$796291#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 3}, {-0.9999997551020559, 1.006061215808764}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.505308809031036*^9, 3.505308871471862*^9, 3.5053089015310802`*^9, {
   3.505308935324625*^9, 3.505308945809517*^9}, 3.505309171933909*^9, {
   3.505309647718267*^9, 3.505309719161512*^9}, 3.505309847219307*^9, {
   3.505311602317751*^9, 3.505311633010705*^9}, 3.756405128881219*^9, 
   3.7564052003883247`*^9, 3.756409724689823*^9, 3.793325270553191*^9, 
   3.793848342547132*^9, 3.823227983592579*^9},
 CellLabel->
  "Out[2142]=",ExpressionUUID->"59f11057-4023-4dab-9c6f-711d1b827437"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gtest", "=", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{" ", 
      RowBox[{
       SuperscriptBox["\[Omega]", "2"], "-", 
       RowBox[{"2", "\[Zeta]", " ", "\[Omega]", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]}], 
     RowBox[{
      SuperscriptBox["\[Omega]", "2"], "+", 
      RowBox[{"2", "\[Zeta]", " ", "\[Omega]", " ", "s"}], "+", 
      SuperscriptBox["s", "2"]}]], " ", "/.", " ", 
    RowBox[{"\[Zeta]", "\[Rule]", " ", "0.5"}]}], " ", "/.", " ", 
   RowBox[{"\[Omega]", " ", "\[Rule]", " ", 
    RowBox[{"2", " ", "Pi"}]}]}]}]], "Input",
 CellChangeTimes->{{3.505309219541338*^9, 3.505309342788451*^9}, {
  3.505309404469303*^9, 3.50530941181796*^9}, {3.505309550117856*^9, 
  3.505309607253121*^9}, {3.505309642583003*^9, 3.5053096534886217`*^9}, {
  3.505309684886443*^9, 3.505309713368845*^9}, {3.505309832762917*^9, 
  3.50530983360846*^9}, {3.756405141472639*^9, 3.756405150987561*^9}},
 CellLabel->
  "In[2143]:=",ExpressionUUID->"30ea221f-1fe9-45f0-b981-5f77e8dc38e5"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"4", " ", 
    SuperscriptBox["\[Pi]", "2"]}], "-", 
   RowBox[{"6.283185307179586`", " ", "s"}], "+", 
   SuperscriptBox["s", "2"]}], 
  RowBox[{
   RowBox[{"4", " ", 
    SuperscriptBox["\[Pi]", "2"]}], "+", 
   RowBox[{"6.283185307179586`", " ", "s"}], "+", 
   SuperscriptBox["s", "2"]}]]], "Output",
 CellChangeTimes->{{3.505309592064577*^9, 3.5053096086180887`*^9}, {
   3.5053096477710648`*^9, 3.505309719213835*^9}, 3.505309847274528*^9, {
   3.7564051289713907`*^9, 3.756405153103078*^9}, 3.756405200499941*^9, 
   3.756409724750043*^9, 3.793325270563778*^9, 3.793848342555361*^9, 
   3.8232279835995483`*^9},
 CellLabel->
  "Out[2143]=",ExpressionUUID->"2731871a-e5ab-4014-bb25-de644bddb811"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gtesttf", " ", "=", "  ", 
  RowBox[{"TransferFunctionModel", "[", 
   RowBox[{"Gtest", ",", "s"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5053093455524597`*^9, 3.5053093744167337`*^9}, 
   3.5053094107286987`*^9},
 CellLabel->
  "In[2144]:=",ExpressionUUID->"9190d655-5423-4858-8af8-ee20caa0881b"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox[
     RowBox[{
       RowBox[{"39.47841760435743`", "\[VeryThinSpace]"}], "-", 
       RowBox[{"6.283185307179586`", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}], 
     RowBox[{
       RowBox[{"39.47841760435743`", "\[VeryThinSpace]"}], "+", 
       RowBox[{"6.283185307179586`", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{
         39.47841760435743 - 
          6.283185307179586 $CellContext`s + $CellContext`s^2}}, 
        39.47841760435743 + 
        6.283185307179586 $CellContext`s + $CellContext`s^2}, $CellContext`s],
       AutoDelete -> True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{
         39.47841760435743 - 
          6.283185307179586 $CellContext`s + $CellContext`s^2}}, 
        39.47841760435743 + 
        6.283185307179586 $CellContext`s + $CellContext`s^2}, \
$CellContext`s]], 1, {}, {False, False}, False, Automatic, None, 
     Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{
     39.47841760435743 - 
      6.283185307179586 $CellContext`s + $CellContext`s^2}}, 
    39.47841760435743 + 
    6.283185307179586 $CellContext`s + $CellContext`s^2}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{{3.5053093620964203`*^9, 3.50530937524576*^9}, 
   3.5053094151053762`*^9, 3.5053096148928633`*^9, {3.505309647809455*^9, 
   3.505309719265849*^9}, 3.5053098473105164`*^9, {3.7564051291576242`*^9, 
   3.75640515589021*^9}, 3.75640520068233*^9, 3.7564097252428513`*^9, 
   3.7933252706878767`*^9, 3.793848342629724*^9, 3.823227983662488*^9},
 CellLabel->
  "Out[2144]=",ExpressionUUID->"e6b9854c-600e-4c5f-a044-b83e12ddda31"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ytest", " ", "=", " ", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"Gtesttf", ",", 
     RowBox[{"UnitStep", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.505309389731105*^9, 3.50530947003752*^9}, {
  3.50530961937999*^9, 3.5053096213562403`*^9}},
 CellLabel->
  "In[2145]:=",ExpressionUUID->"a7c4c746-607a-4841-a4af-848e31e437e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"ytest", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.505309436546179*^9, 3.505309473073797*^9}, 
   3.5053096247803*^9},
 CellLabel->
  "In[2146]:=",ExpressionUUID->"751ec2b4-7899-4545-a008-33f90ee96ca0"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd2mk41F0UAHCMZexjaJPQ8iJEtNF2L0W2kFBJtlSWiKgklSTKUpLQgoQo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       "]]},
     Annotation[#, "Charting`Private`Tag$796778#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 5}, {-0.09258149928174975, 1.1781282693036368`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.505309438252142*^9, 3.505309473396037*^9}, {
   3.505309625274081*^9, 3.505309719346611*^9}, 3.505309847389595*^9, 
   3.756405129302038*^9, 3.756405200854292*^9, 3.756409725365693*^9, 
   3.793325270816762*^9, 3.7938483427539682`*^9, 3.823227983738783*^9},
 CellLabel->
  "Out[2146]=",ExpressionUUID->"b574ce32-dbc4-444a-85bb-98f576efd3cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BodePlot", "[", "Gtest", "]"}]], "Input",
 CellChangeTimes->{{3.505309767286549*^9, 3.5053097784852953`*^9}},
 CellLabel->
  "In[2147]:=",ExpressionUUID->"91f9568b-f057-429a-8953-12ce9447d68f"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJxN23k4le8aN3xDRIQUUZKxkBBCkllFtZSkEpLMU0KIokFCZFaGJFPmKUmR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           "]]},
         Annotation[#, "Charting`Private`Tag$797524#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-0.5028501273058661, -2.892982399659862*^-15},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-3.*^-15, 
           FormBox[
            TemplateBox[{"\[Times]", "\"\[Times]\"", 
              RowBox[{"-", "3.`"}], 
              TemplateBox[{"10", 
                RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
               SuperscriptBox]}, "RowWithSeparators"], 
            TraditionalForm]}, {-2.*^-15, 
           FormBox[
            TemplateBox[{"\[Times]", "\"\[Times]\"", 
              RowBox[{"-", "2.`"}], 
              TemplateBox[{"10", 
                RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
               SuperscriptBox]}, "RowWithSeparators"], 
            TraditionalForm]}, {-1.*^-15, 
           FormBox[
            TemplateBox[{"\[Times]", "\"\[Times]\"", 
              RowBox[{"-", "1.`"}], 
              TemplateBox[{"10", 
                RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
               SuperscriptBox]}, "RowWithSeparators"], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {1.*^-15, 
           FormBox[
            TemplateBox[{"\[Times]", "\"\[Times]\"", "1.`", 
              TemplateBox[{"10", 
                RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
               SuperscriptBox]}, "RowWithSeparators"], TraditionalForm]}, {
          2.*^-15, 
           FormBox[
            TemplateBox[{"\[Times]", "\"\[Times]\"", "2.`", 
              TemplateBox[{"10", 
                RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
               SuperscriptBox]}, "RowWithSeparators"], 
            TraditionalForm]}, {-3.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.8*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.6*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.4*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.2*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.8*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.6*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.4*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.2*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-8.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-6.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-4.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {2.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {4.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {6.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {8.*^-16, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.2*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.4*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.6*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.8*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {2.*^-15, 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-4.821637332766441*^-16, 
           FormBox[
            StyleBox[
            "\"9999999999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-3.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-2.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-3.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.8*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.6*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.4*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.2*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.8*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.6*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.4*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.2*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-1.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-8.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-6.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-4.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {2.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {4.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {6.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {8.*^-16, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.2*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.4*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.6*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {1.8*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {2.*^-15, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-0.5028501273058661, 
       2.099209864022096}, {-2.892982399659862*^-15, 1.928654933106574*^-15}},
      
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-3.*^-15, 
          FormBox[
           TemplateBox[{"\[Times]", "\"\[Times]\"", 
             RowBox[{"-", "3.`"}], 
             TemplateBox[{"10", 
               RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
              SuperscriptBox]}, "RowWithSeparators"], 
           TraditionalForm]}, {-2.*^-15, 
          FormBox[
           TemplateBox[{"\[Times]", "\"\[Times]\"", 
             RowBox[{"-", "2.`"}], 
             TemplateBox[{"10", 
               RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
              SuperscriptBox]}, "RowWithSeparators"], 
           TraditionalForm]}, {-1.*^-15, 
          FormBox[
           TemplateBox[{"\[Times]", "\"\[Times]\"", 
             RowBox[{"-", "1.`"}], 
             TemplateBox[{"10", 
               RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
              SuperscriptBox]}, "RowWithSeparators"], TraditionalForm]}, {
         0., 
          FormBox["0", TraditionalForm]}, {1.*^-15, 
          FormBox[
           TemplateBox[{"\[Times]", "\"\[Times]\"", "1.`", 
             TemplateBox[{"10", 
               RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
              SuperscriptBox]}, "RowWithSeparators"], TraditionalForm]}, {
         2.*^-15, 
          FormBox[
           TemplateBox[{"\[Times]", "\"\[Times]\"", "2.`", 
             TemplateBox[{"10", 
               RowBox[{"-", "15"}]}, "Superscript", SyntaxForm -> 
              SuperscriptBox]}, "RowWithSeparators"], 
           TraditionalForm]}, {-3.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2.8*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2.6*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2.4*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2.2*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.8*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.6*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.4*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.2*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-1.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-8.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-6.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-4.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {2.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {4.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {6.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {8.*^-16, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {1.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {1.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {1.2*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {1.4*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {1.6*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {1.8*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {2.*^-15, 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-4.821637332766441*^-16, 
          FormBox[
           StyleBox[
           "\"9999999999\"", ShowContents -> False, StripOnInput -> False], 
           TraditionalForm], 0}}}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV0Hs01AkbB/ApSski5RK5lGoUTRlapfT8UERM0WSNmlIuuZTm3lEthS3k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           "]]},
         Annotation[#, "Charting`Private`Tag$798259#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-0.5028501273058661, -354.2608648988826},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-400., 
           FormBox[
            RowBox[{"-", "400"}], TraditionalForm]}, {-300., 
           FormBox[
            RowBox[{"-", "300"}], TraditionalForm]}, {-200., 
           FormBox[
            RowBox[{"-", "200"}], TraditionalForm]}, {-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-400., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-380., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-360., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-340., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-320., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-280., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-260., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-177.1304324494413, 
           FormBox[
            StyleBox[
            "\"9999999999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-400., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-400., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-380., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-360., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-340., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-320., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-280., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-260., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-0.5028501273058661, 
       2.099209864022096}, {-354.2608648988826, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-400., 
          FormBox[
           RowBox[{"-", "400"}], TraditionalForm]}, {-300., 
          FormBox[
           RowBox[{"-", "300"}], TraditionalForm]}, {-200., 
          FormBox[
           RowBox[{"-", "200"}], TraditionalForm]}, {-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-400., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-380., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-360., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-340., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-320., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-300., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-300., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-280., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-260., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-240., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-220., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-180., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-160., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-140., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-120., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-177.1304324494413, 
          FormBox[
           StyleBox[
           "\"9999999999\"", ShowContents -> False, StripOnInput -> False], 
           TraditionalForm], 0}}}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.505309773813437*^9, 3.505309779269197*^9}, 
   3.505309848199068*^9, 3.756405129722233*^9, 3.75640520125561*^9, 
   3.7564097259536047`*^9, 3.793325271128438*^9, 3.793848343091112*^9, 
   3.82322798401598*^9},
 CellLabel->
  "Out[2147]=",ExpressionUUID->"ad18f439-496c-4577-b737-c5e492f6a3bc"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 652},
WindowMargins->{{222, Automatic}, {Automatic, 1}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"714ee943-cce0-4514-bbc6-628525bb338c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 238, 4, 67, "Section",ExpressionUUID->"b616df30-29f2-42a9-b08a-c4a34f907035"],
Cell[820, 28, 175, 4, 30, "Input",ExpressionUUID->"9674331b-75cb-43d1-ba6d-7a222b949ae3"],
Cell[CellGroupData[{
Cell[1020, 36, 492, 12, 30, "Input",ExpressionUUID->"63df2661-e96e-4a53-9649-da7b563d3760"],
Cell[1515, 50, 601, 13, 63, "Output",ExpressionUUID->"44bd381a-c016-4cd5-90bf-35230474ba0d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2153, 68, 491, 12, 30, "Input",ExpressionUUID->"b317103d-e808-476a-932e-ecdd52f71604"],
Cell[2647, 82, 715, 17, 73, "Output",ExpressionUUID->"e3e593b1-0b18-4fb6-b7e4-b72d91582590"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3399, 104, 483, 12, 30, "Input",ExpressionUUID->"486c7e81-923f-4b23-b68b-56b54f4a5e67"],
Cell[3885, 118, 839, 21, 73, "Output",ExpressionUUID->"4aae4d76-3b73-4d0f-8f41-b1c83ac0b42a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4761, 144, 777, 16, 30, "Input",ExpressionUUID->"2df168ce-5e31-4578-af1c-9d452d2fcded"],
Cell[5541, 162, 407750, 7069, 215, "Output",ExpressionUUID->"7d4b7ec1-6336-449f-b4c4-3468154e59d3"]
}, Open  ]],
Cell[413306, 7234, 180, 3, 30, "Input",ExpressionUUID->"9b099472-921a-4155-bc7b-bea7b57af91a"],
Cell[CellGroupData[{
Cell[413511, 7241, 428, 12, 50, "Input",ExpressionUUID->"4a2a5292-acd3-4ff4-890a-80245aa6ce2e"],
Cell[413942, 7255, 786, 20, 38, "Output",ExpressionUUID->"6af78b73-8aad-4a41-9ec9-ac6fe2a62f51"]
}, Open  ]],
Cell[CellGroupData[{
Cell[414765, 7280, 525, 15, 51, "Input",ExpressionUUID->"2d976f13-ff63-4b7b-a2b0-74804f937bd6"],
Cell[415293, 7297, 974, 21, 34, "Output",ExpressionUUID->"880a4a11-adfe-4ae7-a643-d6d0687a88dc"]
}, Open  ]],
Cell[416282, 7321, 791, 19, 94, "Input",ExpressionUUID->"36bf29ef-87a7-4bff-8104-f3fb6a482f8c"],
Cell[CellGroupData[{
Cell[417098, 7344, 421, 10, 30, "Input",ExpressionUUID->"4b971cb1-4f3d-4112-bcc2-716e0b39260c"],
Cell[417522, 7356, 574, 14, 37, "Output",ExpressionUUID->"051af68a-4a3a-4aea-ae1c-26a0638bec7f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[418133, 7375, 426, 10, 30, "Input",ExpressionUUID->"e28c8f14-e301-4102-95e1-e778fb38708e"],
Cell[418562, 7387, 1866, 52, 55, "Output",ExpressionUUID->"ffe7deb7-5561-4ab8-9ef7-4e1386e2fabf"]
}, Open  ]],
Cell[420443, 7442, 413, 11, 30, "Input",ExpressionUUID->"3097185d-f6b2-4026-bf3f-20b7111ed909"],
Cell[CellGroupData[{
Cell[420881, 7457, 496, 12, 30, "Input",ExpressionUUID->"daeb9722-d523-4ead-a3d5-77aecd5b3103"],
Cell[421380, 7471, 14050, 253, 231, "Output",ExpressionUUID->"59f11057-4023-4dab-9c6f-711d1b827437"]
}, Open  ]],
Cell[CellGroupData[{
Cell[435467, 7729, 1033, 23, 53, "Input",ExpressionUUID->"30ea221f-1fe9-45f0-b981-5f77e8dc38e5"],
Cell[436503, 7754, 752, 18, 55, "Output",ExpressionUUID->"2731871a-e5ab-4014-bb25-de644bddb811"]
}, Open  ]],
Cell[CellGroupData[{
Cell[437292, 7777, 324, 7, 30, "Input",ExpressionUUID->"9190d655-5423-4858-8af8-ee20caa0881b"],
Cell[437619, 7786, 3490, 78, 62, "Output",ExpressionUUID->"e6b9854c-600e-4c5f-a044-b83e12ddda31"]
}, Open  ]],
Cell[441124, 7867, 464, 11, 30, "Input",ExpressionUUID->"a7c4c746-607a-4841-a4af-848e31e437e0"],
Cell[CellGroupData[{
Cell[441613, 7882, 368, 9, 30, "Input",ExpressionUUID->"751ec2b4-7899-4545-a008-33f90ee96ca0"],
Cell[441984, 7893, 24062, 414, 234, "Output",ExpressionUUID->"b574ce32-dbc4-444a-85bb-98f576efd3cd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[466083, 8312, 217, 4, 30, "Input",ExpressionUUID->"91f9568b-f057-429a-8953-12ce9447d68f"],
Cell[466303, 8318, 74088, 1417, 238, "Output",ExpressionUUID->"ad18f439-496c-4577-b737-c5e492f6a3bc"]
}, Open  ]]
}, Open  ]]
}
]
*)

