(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    570874,      10653]
NotebookOptionsPosition[    562425,      10505]
NotebookOutlinePosition[    562823,      10521]
CellTagsIndexPosition[    562780,      10518]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Undamped oscillator & PID for disturbance rejection & command tracking  \
(Problem 3.2)\
\>", "Section",
 CellChangeTimes->{{3.510432288913591*^9, 3.5104322948525543`*^9}, {
  3.5105367736963882`*^9, 3.51053678500532*^9}, {3.510539713993991*^9, 
  3.510539714456819*^9}, {3.512583743179525*^9, 3.5125837533268957`*^9}, {
  3.6762455646348352`*^9, 3.676245568192129*^9}, {3.677187569186164*^9, 
  3.677187594942622*^9}, {3.793322188594365*^9, 
  3.793322197693276*^9}},ExpressionUUID->"9bd9fefe-f8f2-4dd9-bc09-\
c38d9a67cd28"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Plot", ",", 
    RowBox[{"PlotRange", " ", "\[Rule]", " ", "All"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmax", "=", "10"}], ";", 
   RowBox[{"trange", "=", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], ";", 
   RowBox[{"d", "=", 
    RowBox[{"DiracDelta", "[", "t", "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"d", " ", "=", " ", 
    RowBox[{"input", " ", "disturbance"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"step", "=", 
    RowBox[{"UnitStep", "[", "t", "]"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[Omega]", "2"], 
     RowBox[{
      SuperscriptBox["s", "2"], "+", 
      RowBox[{"2", "\[Zeta]", " ", "\[Omega]", " ", "s"}], "+", 
      SuperscriptBox["\[Omega]", "2"]}]], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Zeta]", "\[Rule]", "0"}], ",", 
      RowBox[{"\[Omega]", "\[Rule]", "1"}]}], "}"}]}]}], ";", " ", 
  RowBox[{"Gtf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"G", ",", "s"}], "]"}]}], ";", " ", 
  RowBox[{"K1", "=", "Kp"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.512583870682418*^9, 3.5125839542590017`*^9}, {
   3.512584024671331*^9, 3.512584027989682*^9}, {3.5125841211889*^9, 
   3.512584127296365*^9}, {3.512591589001939*^9, 3.512591603624406*^9}, 
   3.512591701660733*^9, {3.5125917993240232`*^9, 3.512591809132443*^9}, {
   3.5125924521094418`*^9, 3.512592453502307*^9}, 3.512592692473535*^9, {
   3.512593887458066*^9, 3.512593888716017*^9}, {3.51259461270013*^9, 
   3.512594622096017*^9}, {3.5125948116628113`*^9, 3.51259483773976*^9}, {
   3.525484524756365*^9, 3.525484535149781*^9}, 3.6762503250439157`*^9, {
   3.6762561183589163`*^9, 3.6762561185417137`*^9}, {3.67625941292187*^9, 
   3.676259430759695*^9}, {3.676389041170067*^9, 3.676389067424848*^9}, 
   3.676389101065217*^9, {3.676391100452928*^9, 3.676391108995421*^9}, {
   3.676391217033957*^9, 3.676391220440343*^9}, {3.676391268040085*^9, 
   3.676391275278243*^9}, {3.6764881379502897`*^9, 3.676488162707871*^9}, {
   3.676497088101334*^9, 3.676497134019588*^9}, {3.676497401187972*^9, 
   3.6764974056105127`*^9}, {3.676497724523225*^9, 3.676497724978266*^9}, {
   3.676601115668239*^9, 3.676601127137619*^9}, 3.676602873260806*^9, 
   3.676602920963943*^9, {3.676602968557851*^9, 3.676602969437344*^9}, {
   3.676605708557879*^9, 3.6766057086604757`*^9}, {3.676841872402276*^9, 
   3.676841872575727*^9}, 3.676841921782186*^9, {3.676841981243576*^9, 
   3.676842001549775*^9}, {3.676842124929678*^9, 3.676842125057537*^9}, {
   3.6768421644013443`*^9, 3.676842263012306*^9}, {3.676842328199706*^9, 
   3.6768423577905397`*^9}, 3.677203813028906*^9, 3.677464346208149*^9},
 CellLabel->
  "In[1745]:=",ExpressionUUID->"65e98b6e-d892-43a0-9c77-4d90f85fe95d"],

Cell["Proportional control", "Text",
 CellChangeTimes->{{3.676256123319852*^9, 3.6762561340117064`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"9a119fa1-f177-4d48-8fc4-7c40cf1badbf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"SG1", "=", 
     RowBox[{"Together", "[", 
      FractionBox["G", 
       RowBox[{"1", "+", 
        RowBox[{"K1", " ", "G"}]}]], "]"}]}], ";", " ", 
    RowBox[{"SG1tf", "=", 
     RowBox[{"TransferFunctionModel", "[", 
      RowBox[{"SG1", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"negT1", "=", 
     RowBox[{"Together", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "K1"}], " ", "G"}], 
       RowBox[{"1", "+", 
        RowBox[{"K1", " ", "G"}]}]], "]"}]}], ";", " ", 
    RowBox[{"negT1tf", "=", 
     RowBox[{"TransferFunctionModel", "[", 
      RowBox[{"negT1", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"y0", "=", 
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{"Gtf", ",", "d", ",", "trange"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"open", "-", 
     RowBox[{"loop", " ", "impulse", " ", 
      RowBox[{"resp", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"y1a", "=", 
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"SG1tf", "/.", 
         RowBox[{"Kp", "\[Rule]", "3"}]}], ",", "d", ",", "trange"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"y1b", "=", 
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"SG1tf", "/.", 
         RowBox[{"Kp", "\[Rule]", "10"}]}], ",", "d", ",", "trange"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
    RowBox[{"y1c", "=", 
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"SG1tf", "/.", 
         RowBox[{"Kp", "\[Rule]", "30"}]}], ",", "d", ",", "trange"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"closed", "-", 
     RowBox[{"loop", " ", 
      RowBox[{"prop", ".", " ", "control"}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p1a", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"y0", ",", "y1a", ",", "y1b", ",", "y1c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u1a", "=", 
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"negT1tf", "/.", 
         RowBox[{"Kp", "\[Rule]", "3"}]}], ",", "d", ",", "trange"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u1b", "=", 
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"negT1tf", "/.", 
         RowBox[{"Kp", "\[Rule]", "10"}]}], ",", "d", ",", "trange"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"[", 
     RowBox[{"=", 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{"t", "-", "1"}], ")"}], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "t"}]]}]}], "]"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u1c", "=", 
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"negT1tf", "/.", 
         RowBox[{"Kp", "\[Rule]", "30"}]}], ",", "d", ",", "trange"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"[", 
     RowBox[{"=", 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{"t", "-", "1"}], ")"}], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "t"}]]}]}], "]"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p1b", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "u1a", ",", "u1b", ",", "u1c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"GraphicsRow", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1a", ",", " ", "p1b"}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.676249895364493*^9, 3.676249952859128*^9}, {
   3.676250078936203*^9, 3.6762501753561983`*^9}, {3.676250267749674*^9, 
   3.676250338091148*^9}, {3.6762506936720343`*^9, 3.6762508529918823`*^9}, {
   3.6762508917284107`*^9, 3.676250938069023*^9}, {3.6762510186394672`*^9, 
   3.6762510234710913`*^9}, {3.676255994020452*^9, 3.676256039711348*^9}, 
   3.676256116897809*^9, {3.6762567229744873`*^9, 3.676256731357649*^9}, 
   3.676257828382625*^9, {3.6762588568670807`*^9, 3.6762588673601723`*^9}, 
   3.676259292055314*^9, {3.676259435256177*^9, 3.676259452240838*^9}, {
   3.67625955505368*^9, 3.676259558603372*^9}, {3.67638913777337*^9, 
   3.676389189752734*^9}, 3.6763911138705683`*^9, {3.676391144187562*^9, 
   3.676391153918634*^9}, 3.67639124215591*^9, 3.6763912881463118`*^9, {
   3.676488167677823*^9, 3.676488170171958*^9}, 3.676577443596999*^9, 
   3.6765774745947742`*^9, {3.676605685256126*^9, 3.676605690239094*^9}, {
   3.6768190111166*^9, 3.676819118661612*^9}},
 CellLabel->
  "In[1750]:=",ExpressionUUID->"5d542e41-ff5d-4be9-a72b-e39fc92d684f"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVmHk41N8Xxy1RpDBjyTILU1GKikqbc1GUSJQlybdUkr2iKJU2hRRlV5Qo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           "]]},
         Annotation[#, "Charting`Private`Tag$652348#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVWnc8ld8ft1L2JlzjIiSJhtI6n0qKNMxklZGdpNDwbRfZKSNlFSWKFIXk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           "]]},
         Annotation[#, "Charting`Private`Tag$652348#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwU23k4VG8bB3B7jHUYDAZDQogSUannTlosRYo2EaVUolWiVUIkErKVFv0s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           "]]},
         Annotation[#, "Charting`Private`Tag$652348#3"]& ], 
        TagBox[
         {RGBColor[0.922526, 0.385626, 0.209179], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwU23c8ld8fAHDZu8t1rYRKSEWkjMrnVFSikmj4SpGMhiLR0JakzIiIiEpG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           "]]},
         Annotation[#, "Charting`Private`Tag$652348#4"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{16.153061224489797`, 1.4999999999999432`}, {1.5, 0.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {159.80230278150262, -92.62500043839714},
      ImageScaled[{0.5, 0.5}], {299.88441975613375, 176.4285722636136}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJxFz2lI0wEYBvDZtGLOcFqmqdt/Ji7nkX4IMvJIg8yLTJcw6djUzfJKcWBq
ZabpEG3V8GQMNQ0RZ8YM7FimpnktdGXRjMQ5RFPQ1tKptQryfV94ePh9e14m
P+tsyg4SiRT9N/9adoO/0z+5Ioj0/wY0RFQCcTl42+ZB1W2CuAaW9VYyrAgx
OD1QlLHGqANrNlOlK4w28C7tLGuZ0QNuHJFnf2MMgxWdYm2672ewMHiibilH
B87Ue+qUigUwhVnC+np0BVxlO8puvGQA87Xxr8hjP8HZb0r4WawNcNdVapzj
6V+4pyBt0S+BFLLtYvlW7I8lCzBJMxPyIp8M9sgV5MWzrcBzxppz1i93giP0
V67fz94NjpmTeNHpFPBiP7/obYc12Jc25Rp20QZMCTbypg17wKeWuWtuHFvw
p75kC643DdxdPnCBMKIFVqIZtdoOnJRT0E2ttwcfFnqpo3h7we/svK1FAfvA
zxXFDd5kB3CBBfvM2Bc0ZTo/PFO5H6xvZUrlhY5g6SEnyx6OE1hSLxjiEQfA
XOl5NXUevX6yxSRXOYN1+tC8vjIXcFOgv/M4zxXcUSqiCX3o4DJOUiTZiD4y
3dhWNs4A13o2dIxHEuCbvZW1kT3oaGdOy4g7E3wicyiRJkbLXfjuY0a0e/+j
6phEN/zPp489qUILDJYTw+yDYH7Xd0J8F51eHLcVcQ8tilN+pD5AlxtFVZJq
tCLAtFkjQ5tem6da29GSSWrlwBC6vjkj9c4wujlXHRY+in7qINkYVaOnufap
mg9ols4pbFaH9lPm0x/q0cdKtaaUeXQUS/Z4YRGdk0bQV1fRhcdvmZ4Y0KU2
s+9zjejazuaK9XV0U5Gl8NkGuj02JbRwC610G3QN+o1WGTxMZjP6DwbEFmI=

           "]]},
         Annotation[#, "Charting`Private`Tag$653466#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVWnk8VO8XtpedMMKQMUqLhLTLe0iSlLKlkpBkiSi0EEVly9Jmq2yhUqkk
VPLaskbCV9n3fWdmrt3v/v6az/OZd+455znPed/73Lk028vGFzjY2NjCOdnY
/v/5wteWR80uVItt75kSxdCU/JJ6ecOT8o7Ijtv9255//nilND9AXv4Gun7l
s83c30f4RUHYOm75YLRmZ0pf4N9kfGm/pwuxLhaZjyTM8TZm4voFhyeT696g
jKm3XTtri/Cqlm6lsXVfkYHyNfqqr3U4qTLBfWRdBWLd5li3aNmNGTFfNnc8
qEDi8fRK69fdWO9iVU/dXAWy9Kywi5jpxqOchNm3+kqUGp/CfSi4B+/ef2xv
cOAvFDGVBKsze3Hth0UOpYnf6OSVn3GU2X7sV6lsoHauHunVOFl/PD6CX3/K
2fD2aT3S+hPA9u3xCK6L0eFc/6seUf3dMq42jmDFixZ5a/c0IKlT7IhxehRX
ct5VYRP7D6UZn/aXsB7DlP0ta36XNqLIz3cNtp+ewBkfglsuqTSj4tzWhWt3
p/DwmuEHBjbNqK3+ziPP+Cms5GWgtfFJM9qz49wrvdwpnKjJn9Qz14yqLIwN
bUem8KOKB/anf7agGe5VgdeNprFXT8TUIcs29CXNgxgUmsGZepPJ6yPakLRO
WDrbhhk88ea4KWdRG1r/4cfCgOYMdnATzclXakehu3JjFZ1m8OmlRz47ZtqR
zmOT90ZFMziBvypA9GAnepfk7KfpyMBa+70tb1t1Iv0JzdUatxi41XXLjolr
nWij35MyIpKB19aF9v9K70Q7jINVenIY+GGM4eEgkS40oOnqq8vJxAHra4RW
WrrQUIf+1tWRTKxw0nfAhdmF9phwKr9PZOKCIJWCVqFudOxaxU2ZT0y8OBLu
/k27G6W6p1wx+cPEnplGDZ6vutHtfo/PysIsfBH9iR290oPYwm7lnr/NwmzJ
rG8toT0ohnohxSCMhWO4qK2VKT2o+N6+wvlYFi6vsJd709iDZsdCRLMzWXij
6WLyhb29KEv8t0pUFwsXZNNKTE16UaGmdUzxKAtbSB3qO3CpF2VvSzzzlWDh
oPaHSgrxvehaGD1wSYDAgw5K79rZ+9CmyrnYPg0C364yrK6W7kOGI0WzxloE
XqtyZTxvex96wr2pK/AQgfVn8lSfXehDQQtd/YdOEbjTrPtEiG8fgrPhDXU2
BL6eu+rqjeg+1NvoPqXoROA3t4y/nKzoQ+0KstfkbhJYp/Nao153H3p7iwv/
vEPgZp0XxI6FPmTMbsvYHkxgvtWDe8S39iPZJ/l9dtEEdnp0K782sh+pWOVQ
JD8RmIOZ3IHf9CMTL97lmWwCx50sZ/tQ1I9Um4yMovMIXEkVOxDG6EfLEbNj
qmUEtvXbbecjOIAcLt2UVvpF4Pmus/ecNwwg06Ze155aAm959brssMUAijF3
t81oInAJb83gbvcBdIfGycxrI7DlpRnejSHk+l3TEQ+7CMyoWbtF8uUAolbK
bVXuI/ADNS1DnrwB1MvvWPpgkMCKT867MBsGUK7KJ7PPIwTOYwWF944NoGS7
vw0J4wQ2PZXxoZ5nEGV0fN9vPEXg0e/1tUXrBlH/H62QyhkC35Wbm/q0exCd
dIGs1SwCU+/IiSWdGET8vYlfBGYJnNVzQCPSaRAJO0BQ4xyBDfUczfwCBpHz
lpX19gsE7n0d7uX6fBCpWP8I+r5IYB/+rOizXwaR9e4z6Y1LBBZ3bco1rCF/
3597N2eZwO9rl5v2DQwi3WfZolYrBNbbrriwmW0I8YdoHKkkcfvTw1RpqSFk
e1hKeZHEXrOu+3nVhxCL/3D2DImFzjyxmjUYQh6Sj8c/kjjtx1e/gfNDqGhb
RdN2EmvJdyQ2+gyh8rU/fHzIeI3+XEU/nw4hpyhoDSHzce3b1JOVMYQiLq1f
siLz7bRqWl1YMYS6KBptf+cJbPIvSKW6dwhp4FIkQNZbemK3adPKEOLcxbVl
keRnd9XAjT7pYVRmJJb6ikHgt7rRCVM7htF8s3SW0DSB5fL1fi4dH0YS6dpW
ahMEjtzFGua9NIweh2e8ER4lMOenVBFK4DAaOxX0/A3ZP6/NZjsVkofRizam
5kovOR8vuSxVfgwj6ojsQxGy/zVR51/pzQyj5andLvb/CAwiYtXGQiOoYVCG
6209gT8HF01bbRpB6mkNnm9rCBzjQ9O6dm4ENSsP7eksJvXNqj0fcHMEGdWZ
ZYnnE/jW5dvBEU9HUDLr6ynuXFKvth0Nr6pG0D6PEE+ZtwRuaAmf/9w/gt69
WSWunULgQ2Za8gXso8iEEr+V/oLAyvovnP/tGkVxR3cryIYTOL7Q8GGv8Siy
Yxiu33GfwKL7FrMnXUZRXsjzGV5fArO2nuHgTRlFzlpCOsOXCFwoJhW7R2QM
/adxsPf/860RVp5/cMsY0vG+ExW0n+wnz/XeE3pjSF1wf7PedlLvc43bnHzG
0Ov1H58vyhLYvONJadzgGLJ7Nfvt+CS5P1nojqZxjiPz8qQ07V4W3lc3I/pZ
bhyNWpSqTv1lYfmfxmerTMeRSMtK2oN8Fh5OF2EsFIyjL11p5blBLGypWCC1
unUctQnOmiXfZOHfLy4jcWIcHVykRx25xMJZkTUhylsnUMsO66G2Yyzs5/WA
djZ2Au3h/0LwiLIwH+2uUsfuSZSRoxT1OJiJyzUfbvM9OInOdvKtFF9n4vsW
8btkjSfRvoDf4/kXmZgjMvfQGedJ9Ii1bUn8IBPPL49e/PtiErFMLlXrLTHw
SKvZ698cUyjZg6Y7cp6B02dtP7oKTyGrhMeRTUYM7CDulitInULKbySMn+5j
4N4jIeVHdkyhv8axDM815PnyLX+w7OIUEkr/vtL5Ywb/ilHaVPBrCmlo/OcW
xj+DQ7I01M41TSE5CzEPZ8Y01q/V3rPcN4UoSePHpdumcckqy8OaK1MobfeF
WyPvp3GeV6Rjrto00nmWMWxzdBq/N5178zFqGgXRlmLqAqZwuEjV5iTrGXST
/bKraNIE/rpL9ssx1xkUJJEvu/H8BO61uowWvWdQwS1u3h7FCbzvvZjpyegZ
lJ5oeUf/1TgePGx5S7BmBmWGHLrZ/2oMHwgY+31jHwMJ+Iw9XRM7gmeZwp7G
FCY6wZC4chMGsG2LKeb8xULPz32fX5Pcgt1/3rW9rDSPBudv0/65lyO5Xj0e
1vZ5VLfqgkX/swpUxcGb7gPzyNzv2M8vPyvRegibCj41j+SrvMcfrK1GTd+e
3k4JnUebj798Yd9Wi7Q/psU3Tcwj8SrH+rBr/yHRZ+XNB3IXkFLBx5zoO+0o
/2uIb2XJAsp/3kwhhDuQ8z9DhRN/FpDROdnzfPEd6KfEH0er4QWktuSY/tKy
E92IbJq9Tl1EmxQ2HZ337EJd94YpGbcXkXXzEwOvxB70yU3AZO3hJaTlGmrL
WzuAfsWJ3XhvvoQS81u/v6GQ+3SJdIKO3RKK12/I4Do7iKSlNo1c8ltCv37s
UxoYHER3Cw8GFH5ZQgIyT8oPLQ0h8zV+n50UltEv4bc65ZKjaP7zlNiPhWVk
VOMrcWLVJBJvn91jzLuCutbNd4etn0Qqq9msBygrqD3nuOjzA5PovKXQO1H1
FVTZ+9Nwi98k+sW1RdfeYQVpmh+xE2BMongzOw/h/1aQVfYz7UcNUyjJ23lY
9SQbbLn9cf4m2XfVAt7ZwLNsMDSRMvrlLtl3rtfcHefZIKHkcSeOm0GdYb3y
YW5sEO/ygolKZ5Bc4tmTQ8Fs8O8K38CwNAPFlRiVJOWReCrGJ+8bA23mHf8z
W8QGt38aKdVUM9DXow86jCrYwK9KzvNtJwP9ayyfX/qPDTi9Wcbl3ExEGdJW
Oz3BBn8OBUfdP8pEjwQ14tcosINWFH3HVB0TKRjXvXXcyA6MHcq5b7qZ6FOU
29cCFXYQmnhlsGWaiWrXvW9w3ccOX89pzwWJsJCQ+gb+KlN2eC49t/DGgIXi
vUrWKpxhB90L0TfSLFho63fbDTds2OH31r0/nOxZyFA3QVvJlR1Etv1lM7jD
QiHma68HBLKD6N/b9tZZLCT9LPtecxg7cL/s/xBdwEJvOkwfqz1hh3uX1Ruf
kroud3iY0ZHIDv7mfYb9PSzE483Xt+8bO/y5EjvcIEygKPx6+lEBO4ScEqGD
NIHWcx1iGy5lB58mdM5dkUC6YQEyMfXsYDel5rV+N4H8ExZPMEbZIS36wIY/
lgQ6rprrvmWGHWQ27fyldYFAcoVXH9rOsYNf2tzAVRcCfeserq3l5oCTQqXS
GrcIFHQ1bXKVAAfIv3nMhe8SyJzLVgSt4YArn5VERR8QaHp9k9F7OQ6IHcs/
zxdHoILsJ5d7FTmgb/XxR58SCRR+6HiEzBYOeOlUnLXuFYE2O5bVBO/iAOt/
l9KOfybQ7Jz/eMF+Dmj4rWol9pVApSFaQrMHOCCtd7r5eT6BbN99OWp/nAP0
9ocxOCsIpLrf3eWFOQeEXJq50VVNoOVq5bAGSw6QiLz69F4dgeImXv7SceSA
/pC2c7QWAjncPjd64zIHJB41I9Z2EGinqIzAJ08OCG3hYDV2E6hO/dGRdf4c
0LRNZj51iECJxUedzYM44FOX2GD2KIFcTXlDw8I5IHmHlVD4BIE0+0rSS55w
gANN22bLNIH4vG5XLsRxQF4c53/hDAL949EcVk/iAIvo0bO5LAKlRRO8Tq84
YKo8YPLVLIE8Nn7elPSeA3ImOwLPzhNI+6vr4X+fOeDusMSGpgUCCRlsdhT+
xgGmgQ+rpZcI1NrcF6RXwAEKMfm3FZYJlO6c9PpWKQcMjq3WmSTx9UXL8qxf
HJBwqlXs7gqB9MLWDo7UcYDuu5TZNhKLyzWsojdxQE129fQSibszIpROd3CA
pkExVy+JP6Ijhx72kfF3TalGkti3ludi+QgHpBgV3+AgsaFN0f2VKQ6IOp/a
tZeMJz19K23nLAcY63I67yHzG/TfU+qyTPavSH/tMpl/thizL4WLE9Z+7BoJ
Iuu7m/KRu5WPEyhtewabyPqNd1xaLybKCZXSP4SnSH7kS5UOGkhygsrev3Y1
JH/j5j12d2Q5Yb8AY8id5DdvIP5uLp0TJm38klpI/kOun06Z2MQJugJ9Yfxj
BLLgpZRsUOUEtdbIT+zDBNoQ96fn7E5O+Jw8LpTfTyDG5jDOp5qcUKLq9Bp6
CBRpyHWA8zAnzByqi40h9WHVhm33GnHCf+npyy5/CaTs6u3vbkbmc+QQ5q0n
UHnEdGGHDSe8uVf39Ampvyj5jC6KAyf4FBT/CighkN0nR/Zjrpyw+aZv0h5M
ILb6Tsi7yQneb83s50h93x3KT7p5hxNOa5vK+b0nEC/bC449QZwwvv+/6MI0
Aq3Zeqrky1NOaA7JpN+KIVD0gV3rPZ5zwsrwbmtWJIGopyXuq7/khBt/nmYq
B5PzHvjn0IePnCB0Qmms9jqphxcfXrvkcAIxd29Fy41AKllhvMr5nNCgL+zj
dJFAu7sOV72u4oTVs8xV86YEMthXdCy5nxNyblh/XVImUM2JxA/WY5yQQTni
ekqBQCYOviLrGJygVff00FVJAlk+3Vv3jJ0Lcl/6sXezkfMwkWn2lMoFnbKr
Kj/UstDjly8tg4y5wLdt1kHFjoXWfrvzQ+8UF8irtHj6mpHndO05OW5rLrga
OygcocdCaUsynXdcuIBqm3NvWomFck8+Oe8dxAWh2wI/lA4wUSv/PSfXfC5Y
3MZ1s+oME1krnK9S/skFplt21+0+zER9u7WVR6q44MQlgRzHnUw0fmFp7GIT
F7gONXBIijARe4Gnuw2DCyyJhNepBQy0wcP+uulmbnA5Nn26mMJAW/d2mCSo
csObO0zEwcFAGmwW24Z3ckN75Z9w4bEZpPPgcL/fAW64KqF5LKpoBlmlKJu+
teQGlbLeyNPOMyiqYXobRwQ3VHtPCk5+nkbcO/wGPsxwg9vBnYc7FaaQwAJR
ND/HDdpCW3gsV0+hNYVu8QfZeGAujiP5/dgkkj9qa9YiwAM2U2vu1+dMIs0L
B4t5NvBA1JYyFzWDSeTxlD/hrAUPGGr3neyuGUe9zGhz/h88oLyvbqWOn7xv
195+ta2YB27fkrosWD6MzoXVRHyo5AG78/5i8wHDqFmRu8LkHw/Ebc8RHJsf
Qn9Mrux7PsMD1s8SDhr1DaL8T4byWzevgk1d+N+nd/0o2oV9+Fj0Kmi8Mf76
I383MuhzuvXIfTVcuP7VdtijFh3rjdwiJ8cHzAmOakP7v/jXlt4GS0U+8FCP
Kw0h/uIjV3f5PtvMB09as8+FB/3D+hzttWt38UFke31f55smrCO/xUvsOB/Y
tfZ6PRhqwTssfxas9ucDixlRx96tnZjaMGc208cHu+dHu/bd6cVxMkdX1Eb5
YHtuoUpvSS+WOp/42m2aDyII9+pTq/swZVpvYWyZD1KD1fzTw/uwiMiTxEFJ
ftg9UGJWG9OPOQ1VRtoO8wNP/wJvcvIgHi62vV3+nh8k+Let5Q0axese/nMK
z+KH48PBZpoVo9jU6piZ6Xd++OYXJyXLN4bzZ/ds7iznh7Rfekd6Q8bwo62i
DUQPP1SNfBr2CBrH+6KxkpK0ADwrMdD33TOJ3ex2rBmTF4DR419qLU5O4jS1
t4uZSgJQ6PruDpfnJBb5FfVHa4cAXLtfI1HzYRL3srl6mx8XAKd9P9fQ6FP4
gRP19737AjBs9zTfl20aF+569PVImABQ37u7HZSZxiyu1SmiTwRAbb3Y1n87
prF1wsz1F0kC4Bqq6mftNI01GioVvuQJAC7SXseoncZt+2949U4LwOUzr3tG
Hs/gNfwT1ulzAuR5nGp44u0M1v9nd8SNTRB6On9b+xbN4Mwrx+UXBQXBRvO8
r8rkDL7/SqlSbJMguPxnv7tDn4FVRBtlD5wThIvTvbv0Jxi4P6zf/+kFQZA4
UqzxjZ2JX/ARAwPOglDfdjaTEGNiAa61mQ+uC0K5wMfQhl1MPMw6pdf4UBDO
CtP3it5i4tTWNlfHEkG490Iy6coSE1ueGq//XikI7IcZrsECLCzeuLxb6I8g
xDxT2eoow8L+v9dxfm4TBMOHKY3+u1nYusgmepElCFPKLGtpNxamvu7DEZuE
IETK9N/3BhZuUGQpdm8Tgv6N79OOd7JwaBJPiMZOISgVJCzfjbDwfJySaZOO
EAy//ieZy07gf2GOgwqWQuB8Wr1Xdgvp1/luHvW0FYI3R9yFBzRI/xsYklnm
IAQCWdFGXloEzr791ueSpxBI76Ok9h8n8OOrYyLZ4ULAabGniP8qgQ0mlzxX
PxUCld1imRzeBOZwEWo5/UwI6GpVPfn+BHaz35a68or8/Z93b+8/JPDGHsRn
nCEED5mJ9EcxBO44d/xySpYQfJqWj7NNIPCxU+57DhcKgaJbjrnxOwLzNN6J
f1YmBMIuZffdMwn8w/gR53i1EDTsMw82I/28suHn6kfNQiCv39PkTPr/3vJi
9b5OIUAcLaLx5QR+drAheteAEDgE6k4+qSYwH2LatM4IAf/oOY/aRgJf1964
OnteCLLMTyS5tBC4/8CZjAh2YWCz0xwu6SCwqV64qeNqYXDVkdNu7CFwkX7h
vI6wMNyRZ0QnDRBY9QgjkUoRhjzl750bRggcf1TpEIsqDIlP3QTtxwkscPz0
2G+6MLwLFhU5N0Xgm8Zhj99sFgb7Xc+aRRkEHjQt2BOgJgyG1XznfFmk3z85
02G5Wxi6b5yNSJklcMmpDfd3ImF44xx59u48gdUtTymL6AmDwp/E77KLBE60
elA3ZCgM0uU/nrstEVjIBl8vNhGGvreMlf8/D/I5Py334rQwyPnKjuisEHjk
wvqfXjbCsPxJ0a6IxKcdLJyPOwhD/jeW2wKJy51CRTdfFoan/Lclx0m80yU/
h9NLGH5Ivj8bR+KUy1Nn23yEwcXY6TAbiddcUeTKCRCGdpWUznVkvNseJ9Mj
Q4TBQP7Qpjkyv3GvkONOD4VhIBZterBAYMsbP1gHYoRhUuhm/785Ald6Tz6X
TRCGZ9Pd9h0EgXf70g8QqWR9ufYfE5gETrttPlT7joxfN1UuNUNg8YDgiPTP
wpD6xS376CSB/e/l7bj7TRjEGn777hsj8GTgRMvZQmHYn7Sg1DNE4F8PzDaK
/haGDHFnDetuAu+NCKoZ/k8YLiQFvtzRTuDXD797lLSS/XujwP+zicB3o2iF
14aFYfP8vRbRWgJPx5hePDElDJkblY7/riSw9bNAwS2zZP1GPP/0fhJYrpal
PMEhAmtScm7ZfSWw2QkRNkseEbhgPl7D95nAD+o21ZfzisC2F2lRzqSe5xss
bySLiEDwU7tJy3gCNzYV/TSTEyH92KPn7H4EFjzTGlNEE4EqDhN3Xy8C67Yy
nbetF4Gf3BtCsl0InNm+cQ2vsgjU368etzhD4PCecKu8PSLAuz3BxHE7gX/a
vVbbtF8EbH2vri3eSODFvkKuKBCBfLHR8X+yBHYaZKRfPiQC3RWPdu1ZRc77
2GlCwUwEejMnNv9uZOF48YB6PwsRsHzc9Eq/koUZ+95+aD0jArrZ3el3frBw
YsjCxShbEbA2Kh1Vf0nuL0rP//G6icC/5AX2aGcWfmfb9nUyRATmLl8ICJlk
Yo4Q7qij4SJQ3lG9X6STiS0+bb2S/lAEKEV0RYvfTMzN5rvZLkYEVJz45ba9
Z2KrF3LP/qaKgGhawKXlC0ws8u+cT36BCFR3/cw0+sXA9iuBFjIlIiCYOiMq
nMvAeRs+alwvEwG9Z+fGHr9kYEdPtjG1GhHgvDPOPXGDgYvWJJ1NbRGBwoaa
3VN0BvY42q31gCUCWVk1PqdcZvC/Ijv208qikOWve/T23yk8qd0sfWubKEi2
nmzXzJ/CqwqNNBLVRaFuoLK2OmUK78R7L/bvFoUC8fIqF/cp/OS7SPWVg6KQ
+q0/593qKWyUlRcTaiUKe6f7hiy3TeLSVHHVH5Gi0Fz8e7k1fxR/CSqxkmeK
gvX3Yxu+ZfXi1wZVawNnRWH75uWdhBN5PyBQVze2IApSOjtpc/K9+HZkh953
jjWwV5nGOvagBxvGzKuYi6wBN4mon6etu3H3K9WV0C1roGXDPjWHpQ4sVPY8
gbBZA7cPbZWf0WjE9tyenTU1ayA9WtVPkSsRn7/i/UUgTgyUD9AumiV1oZ3q
7V82vRCDDvVRcdzfhfimIVsvUQw2vFo5trSlG31058m5nSYGuUNrvzG+dKNF
t4e5jEwxqJ2R+vKjrAdFXX71vbVKDDZRtLi3dPehikv1he+WxIDe2X6Jd3wI
PVfeWVTBJg7rlM+7VSoPI7fRmKJ+TnEQ3S66dMR5GFEuWRXL84lD0HND5/CB
YWTrPFTyhCIOv/gn37G1jaBFx5Uyn23iwF1mayzzfQxtu7ilxtBGHNLF86yl
EidRu+O6y+/txEFnY9N+zR+T6MElMREhB3Gop228uK15Eg25L5z47SoO/tfb
Le+JTaGXPlX/nfARB+9wxDcQMIUkHzm3mUeLwyY1J6l9Z6ZR6ZNzvjlx4rDg
zhLY7zmNPKJN1q2NJ/Oxwnp8EdPoz/N9Nk0p4nCv8c1J7qJpFPqKv+9MpjhQ
HLPjvdbPoJW8t6PW1eKwPqDaXqB7BmXghLDCWnGQNRGaSJ6dQZZFj1UUGsTh
xJv5h2zCDPS1zNutp1kcQgxSaCL7GOhq3RHGhUFxkBHq1LwRyUADAyMLTpwS
sLVrQnKfKhNFDXc8r+KRgN0HDJ3XH2Ai3bH6/cp8ErDcy5StN2OipOnvfmMi
EsC3M6Dt2k0mOrMUyukmJwFP1EqduwqY6PcaZX7PPRIwmD7O4tVhIS0Xl6Fn
mhLQnJuwXvw4C2WUZZQVIQn4Uwhd/WdZKNxH7a6IngQ8zjS07rvOQob9O5fe
GktAnN4Vd513LJQH11vqzCTg26NdomG5LKT87OvXOQsJuJ9WoJlQwkL8xzW9
Dp2TAG/9wDqpVhaq/Ko90e0sAaUupbsvrCbQXvGAat7LEsAxEew1tIb0d64l
b1WvSECWb4+XhiyBgumHHHyvS0DbaOFpOTUC6YcZdkndkwDFRf4JLXMC5Q6E
YQiSgPbBc3dYVgRS0vn94mKoBPzdTBX0IP0gD3Hi9JeHErDwZ+e7gmsE+ml9
sv54vAR8uNSi/+IpgTS+x3y6liQBPjpCI3eeEyhFojkiPkUCYMGydstL0s9W
WhqOpkvANr8Rzd8fSH+tGL9ZLEMCZFZufCz/QqDzfh2r936SgNtVhSjwO4F0
NGx/BuZIAPosHWJSSqDM8JcvM75JwNmAm2o2VQRSGOq9898PCbjOq1a9vZZA
7PEXteglEqCWhL4pNRHIbfY11aBMAiIv9hP6bQTqNB6ed6uUAM+jdzi2dRGo
YJVLTn6tBBh1qZ48PEggVduMp331ErBK90nYrRECJeZNXBX4KwHl24IdvcYJ
JCKpZry9WQKml3d2bZ8ikJ/7FdXTbRIwwP9z+MsMgcarPgvd6ZSA1Z9O+ywy
CWS1gTn6qkcCcvXXPVg1S/rl2zuravol4OTWvSJ/5wik1XLtDXNIAvS+1i07
LRAoY8fXQOqYBPTpiRwrXiSQbOT8hQOTEhCtKs3oWCLQg+F9uk4zEmB+eNNA
wTKBFnVvKTxkkXwFtCjYrxDoUkI+W+6cBIQf5Xr3m8Stcyvt7Ytkft5ng/7/
/MbQVPsHNxsFiO7EHxMk/p7h/0yZkwIbTgadSCMxj6GZdDQPBdZXB7mKkfjE
kFIsOx8FWDp84f9/fvP8/rzkJUEKzHaa58iQ+QzQq6MaRSjw4HfuVDaZv3ph
goS2OAXW7LqpKzBPoFtWV568laTAMOrLliHrL1/QFaPIUMBjje7xPpIfsVjJ
R7flyPV/OyUdSf6sdg6LjNAooJDNLfFqkkBv6vMizNZTgPvf4rGEMVIvbhFC
BRspQL0gUn1imEBIyDZsszIFSu+FRP3/eU3IWw2Bp9soYGf7JbOvm0D/6a8K
XVGngDm9ZWNZO4GcA94FNeyhQPYMgq//EShb3m8V2k+BPhOxyYr/6yf/xP03
QIHBPXyST0l9Rc+yAnwPUWByd+jA6QICdT+t4BgyoIAGr+9bs28E2rr9+R2T
YxR4XbpViT+LQMUu2n4bzSggr53/Ki2NQEL84suPLCiw+PdZ24MEAp163e+z
dIYCjftUt6rEEGiiO/RmnS0Fdstd804OIpCMRaOnjxsFXu064W9qTyB75mtG
/1WyHvmv2ylnCfTpkffVE9coELS/quixCYEOVcu7b/ClQGH5QEsRItBVHedL
taEUGC+XypgRJ1B+x/6RvREUuHzvkXg0L4F4b4k4pT6iwJWLP7WIJRZKyPly
8WYsBaRtUm+M97FQlTLbecVXFKgNty7Py2QhSmVdV3g6BXa05IUapLKQzcVU
67n3FDj11+lwVDQLEUkGVjVZFFh5ucrIwZuF6JJPT10vokDstHnRPGIhb/bN
x3+1USBpfwL7ch4T9evy/9vQRQGBlVWWf94y0fGg0XN3eimgExNfezGOiRSF
P1zeOUIBcc6Dv9u9mOgXVSMicZas7yHX43llJpLbrVXjISYJ2ls01CTCGSjI
e535b4okqDzUYqrdYKDpfLb2TdKSkBslsUXCjoHKDhaPtctLwrWHKz3b9jCQ
m4m+4GEVSeDOe3HiR+cMKnI1NpQ9LAkc4zqmruR5o5y5veGaoSSUu3IbCgvO
oCimuGWdkSTob09Mv8mYRs4+f50DzSVBRuVQ4SfyvBIPsQydOk9e72aO+RvL
aWSfal/501cSNLu4dyzfn0J8rTf1XbMk4YfOofBk1wm089obwYgcSXho/y8Z
75hANmv+1X34JgmWR+OsIxfHUa7+jrNTBZLgqPgf41jwOLL/MuHuUS0JgSYe
14wSxlBhuN2zm/2SUFrAZd7+YwRd1z42fn/tWtgeYVRiWDGA+tJoTxJ81sKj
1FWtk9fa0ZONUlxfzaRgdbfN3vdWxdjSasOrHgspiB4qS+IKK8GKT7YbCFlK
QfNk7LWN33/irJWjkedtpUC/8t2RCko5bmj0pwpdlgIKX2qqbNUvLHZvVON8
kBSszxDLL1xTjx914QuC36Xg7DvKQWe9Vnxasnr17nwpyF3W/hL4txUrHG1+
a1tIxh++/uuMQxvOzGVM5ZRJgQZXvvX64HZcF7HJ17ZBCnwPV8aFnu/EolqP
o3LGpOBCPksmIbYbR8bZl9nIS8MvUcXKK139+JqX/1UfujQYS5x836AwgK2M
49dFb5AGra+HO5bPD2BlvsZrv5SlYUXA/OebvgFccePgxl17pKFTyO6zfv8g
5jilGCxgLA03/8h101uHsadkt0FOgDQEa5y+uTFqHFvOLLH+3JeGcgOZeZff
41j3t9TL0WBp4C11POm4egKvCTyxQIuUBgPa1ft+NyZwBqvg7YPn0tB2xcBS
UHkSD/6XIGD7RRo2+P+HDDin8OknZ2sEBqQBxX1VDXo0jamf+WSch6Vh7tbx
6lXvpnHHn5yLFWPS4Jaz/7bxz2lsJ7yG/T6DXO/pxq5PTGPXkNLtK+wyIEB7
cOatxQz2v70tdooqA9EPAw6LizKwbkJrn5G8DBRYEB/oSgy8Kj9YPYMuA4+d
bkzNaTLwg4WeKqfNMvDn+zh1/iIDR3nFLPfskgGsEZKr852B31xit2s0loFl
vz6pInMmvhSa8VHDXAYSBLxH6I5MrJJ+ZunRKRnIlN7N1Pdm4syBL1FG1jIw
u/pyeUs8E+fZOlWUu8hA2IeMN3I9TOx7R5Ki5C4DugWet57MMLF2YontPQ8Z
OC6YxPeLk4VL2+QWtb1lwLiS8d6PzsK1FvUq34NkQKruQDLjHAs/unbbW+oB
+X1ZR+VVVxY2i9pafi1CBjobbtt/9mHh5vpAG40oGRhLSza5GsPCvcc0n7x/
KQPNG9dGTP1i4TSXoU7+VzKQ2B3RdLmJhR0fRG11SpeBH5Hvj7/vY+HxisnS
DZ9kYGTXW9qFJRae1U2dS8iXgbViEbPFm0h//z0hoKRQBlY2sR29T/o/NvU4
waESGbC2vnNEeD+BV62LoKlXycA8037Zw4jAlLnrh0v+ykDw0WTtMHcCx12+
Wj/YLAOqQ9dG/W8QWLbf5axguwwo7Sn+qHWHwIr1tu7mvTLgUeCyf3Ukgbe/
N4wdnJSBK0zmpa50AmfTD9EFGTIQmmc5xP2J9Ndx2u/VCBmo+RU/PpFNYJ3A
nYU3l2RA4/HFI+JFBC5dUj2SwEaF8Iwy32NlBD7sseW/Yk4qeLV9mT76i8DH
beSHBPio4AITJs//I3DDX+mraoJU+NgkJjtC+nOLYxJLZiJU+C3/qHO5jcCt
JcKBN8WosPlqcczfLgKf28cnmkChQkv3hgOefQTu/sT1rFiKChfj97X9HSSw
/cYVxUEqFcwbbtutjBB4OH4uQ0CeCls+ezaOjBPYVYKxW41OhcuOsaovpkj/
HzpeZLaBCqnrnd3EGAT25BgyvLmJCqYUp8fHWASevd7TGK9MBQ4niehjs2Q/
Jtqsi7dRQcNo9LrYPNkP+3/DA+pUuMJw2fligcB3W+s8BHZSAQVJVY8sEni1
SfWy6h4qKOxx3buyRODQirIgM00qJO8Y8f67TGAhKFpzE1HhwDvhCI8VAj/K
znser0OFsKrT7o0kpmzN2VB8kApcRUfkyfslHPfy08cBfSpszbeJHSSxnPS7
vQKGVIgcl2mOIXFSZFqJqhEVMu/MdQiSWHFV0jEzYypIp914fYiM9/rWs383
zKhgGCKjpkfmo8x4ahtvQYUaS6trvGS+H50iR4vOUEHJsPD6Q7I+ja4QrwEr
KrTeL1ZvJ+vPOXmPTcCWCh77epMnSH721viFqF6gQsfHldKfJH/5ujfFzRxI
/j4npVhPk/r47hF/w5kK266k6BdMkPpQu7wx3pUK02VbCnpHCWzw2jGzyJ0K
MhFn1tYMEbhazk5zwINcn3zSyqef1Af/qeOq3mT+FN1BpQ5SH/4mzaa+VJjZ
4qO3voXUx+xRuxt3qPCdEC4baCRwT5/O9aJAKsjLNJ/PqybjJ9Qkbw6lQuUS
f7tNOYETLU5XPwon+1Fd4lhE6tWqyl3h/FMqxHQVzGaRev5xd8mwKoYK0cu+
soc+EpiqFXxt+3OS/9yvUU/eELj5Y+IvzpdUGPwQV2HzjMB7nJQJ5zQqaJV+
T+l6TOAYei6t4Q0VijcaSco+ILB51G+vlI9UWOtfxF3mTeA672X5g/lUcNB0
Zg6eJLDajpAj7wupoCqonXroGIEjxyW8JH5S4cWc+gdbXQIfs9la1VdFhbfW
ZmY12whcqWfpeb+JCo95Fu/5cRJ4E9tgwngr2Q8T6eSS/7+f+PVqpXknFULU
N8mXjbCwnnLoOqUBsr5ujlKuehYuEv1WUcagQpOVval9PAvTqg4yts1SQdO7
XSEukoVv3/0jF7NABXuFm64P/FlYixi86sAhCy8Ve9XfX2Dhb62ScrwispBx
Z8GhdyMLZ77yvGKwRRYi+haOnnjJxKI27C8yVWTh1KNN+/0fMrGbdFiZtLos
LDvphXj4kft3WAp1ZLcsPFyXQ48/zcTpV+pLQ/Vkwf1gQCy/EBMn71eTqbaR
BSF2zcI7jgxcdIwvYMFOFm7XL1SamDFw97me4U0OshD5ysd8GhiY7v/0231X
WdieG1r9VJKBU0rnToG3LCQe+2ruUzSDU42KYj4/kYXeZc53s0Iz+LWNCSWu
TBZS1E9YaN+dwuVXlH3LK2Xhb1J9zBqnKTwYwN3PqpYF9lGtyhyjKbwxLeeL
SYMsWCeXsPlJT+E3wzJmgl2ywB9aNLwqYxKnX+19fHteFui3TzkExE3g9/c8
RS9ulYPGJnGlhNYRPKp51v+eqhzU+j13DU4YIedNd+bldvJ7+UsPVW1HcLqt
+H+de+RAQej815z+YfwafY45rScH86+3ln4dHcIpc5Prjp2TA/QjkVN0bADH
uVxS2fFQDm7EVtDOFffgQLPzRziZcpDtu30tq+E/vKM16U1g9To4GWK5d9Sj
DomoOMx+qF0Hjav0hyJ469Gon8qhf/XrwO5EuDJXfD1KoX/v3di8DtT5A99Y
lDYgceeGdZX96+Dw5bdCweJ/0bwP5xEeNnlwGb7lUZLagpr4dxbqS8nD85iJ
S1363ahUI3awVVoePt09vLklvBtlnV0UdqfKw8p8clxaQzeK/FBkFbtOHgJ2
e45/ONeD9E2MFofWy4N9s3fTjau9KDfOYVeoujxE1+/2MH/Yj2I2PXtffUQe
1D82d0QnDSPGjF5qwFF5GOfRLS/qG0ZG+dPP9xjJA8fvgVUJm0YQj4nBg1Rj
ebiTvuGqw8cR5Okz53TrlDwEHr1xcNO3UWT8++TGrRflwSuKXvnlxzjKiOWU
73GQB+S7ujKWvL/ltfsgGeskD3s3GUjR902gglmeVdyu8iDWadylkDOBtilk
97V6yP///7sWG7NJJOAp/vKBP5kf/8l8Ak0hB1QQp3NXHqwnPmU5WU6hYt5L
j2bvyUPjhdCK9OtT6GZ88R27YHnIsFFlf/hxCg2VXbHWjJSHNh8twzHZaVQq
/Ud29AVZn0Del+TxaeRXEBZz5Ks88F+p0Z2+wEDDbQVP5r6R9Q58rF/jzUDm
CzORr/LI64W7vZqLYCDlnaeDOQvkoVzXUl3qKwP9e7vh5vdSsl5G9sXY1Uyk
Ho3PbGmQB4m5gxrOz5noRdb0yab/5IHK5BxueM9Eq+vWmwb+lQdRzhZPdsxE
HQIPDHua5SEkwMkquZOJHvhb7H/WJQ85ZzfHLsuzUL/LlBz/BMn3x1X9c09Z
6ESooszXSXkIPzip7vOShfJen5S8OC0Pt14ZROZ/ZKHHPT+Ei5nyIKKX0OBf
yUJwKoTNe1Ee/qnOyvIssNBbrx+LG5flQTFCYds9HgJRnkzONq7Iw6O1z42L
RQk0VmM+pc5JA4mj7pY+SgSK06V3D/PSYPKFqVG7EYG4bc3bY/hpkJ/9utT4
FIHc/IKb9QRpIL5vh8M9W9KPfpuoSxahQcyG0S+KHgTK/Kvw+/gaGvxtE9n4
0IdAckyzqmUxGvxLtD3+/S7p57flFZ+WpMHO4TtG+k8IdO7oBF4tRYMPT+vG
0p8RqNJJIS9bmgaE0pOWymQCJaYGZa2Ro0GDkqi7zkcC8Rd//1iwjgaqiinL
sdkE8uocf+dKo4HFLdNXGXkEOipjllqpSIPn5/MkhMsJFNOrUnBmAw0OmRhU
s1cTqPf96pZRJRoUqZ9R+PaHQD6QJyK8hQYbjobf9G4mUDlv1JZEZRoI1Xg4
3G0nkHj9ZT01FRqUVdpXGHcT6N0Fuo+JGg3eFTO/oiECzaosRfWq06CJ+6SG
1SiBdGcbP3lq0KDZyJDQniBQZOHHXzw7aZBRsmt2eIpALSEhA9G7aGAa6K18
ikGgDaZ2HJv20ODPtxvBD1gEuiKrJfttLw0U/Z9w3Zsl/Xy/5O4jmjQQGdn+
WGeeQHwfp4xb99Pg86b7234uEMj8RpWLC6JB53b7FoElAiXrpAYtAw1+hY7F
SC0TaJzf72WEDpnv5x1OIyTe859FvrwuDXK2WpzwXyHQ3Xj1pk8HaUD3cT3e
TuLaiwIMnUMkH7RHjiskpqr1CzXo04AV3xrfR2KHebzpggHJx7WL0/9//yer
OFaXdYQGdVsN7dlJzBZ29VzgURoYHkhZ3EnGMzQ/enOtEQ2c9gbnqJH5xaxT
evrmOA3OPxWPnSLz7x1k+7jXmAaXGs+99CLrU81srqwyoUGe391/BWT9Pt5Z
fZZmNAgSe763luSnTDecbdycBqvFC6pSSP7WCDnI+FnQwJ2TL1xrmkBWf7V3
ipwm8z3/OOAFyX96osyJpDMkvzmeGYVkf1iOTGf1szTYcadS5C3ZP53tv+8X
W9HA+xJ+d6qfQOGLr5NMrWlwbpVkcDXZ7w0Rln+9zpP8Zofv5W4h+2Oxc3rV
BRrYcdooVzSS/aGJCMba04Cn+Hy0cR2BzLKKdb47ktfjP7cmm9Rf4q0XZw2d
yXi/eFFkMYFG9a5db7tEg5bLh+VUyR3ubtPmjJXLJJ+/R7YWZpL8J3NVRLrT
gFnM5p35juT/UnsP7SoNevmEsxzTCPR5+aGUrhc5T2w+9M2xBOqmz90N8qFB
8TPzYIY3gVTG6hKkfMl50mCWUch5vJn97lu6Hw2WV8wurDiTfB22nvzlT4NG
g/tL9DME0nYtOyMaTIPUwRWLHzsJNP9vSK8khOTPfS2hrUz294CA+rUH5Pz/
GvsaQCP5kDqxui2C5OeBggbiJ5BASXPW6ygavDZYSottYaFSlaWEMzE0qPU6
KMn/m4X8YteFCsXRICFhKndvEQtNu9rZeLygQZpPBeW/Vyz0T2pcEFJo0N2Y
OTJ3mYUe3RWZm04l948YnjRrGxY6MqHem/qKBh6Hy/LuG7NQfsm1b/xvaTC8
9U2BqAYLpVxmv/j3Ew2+r3rpuJHBRG4/xQtcMbleVtjX34GJNquSxq+QBq6H
diQyzZioJ+5UVEMRDd7v30bfcoCJzN3iL+0tJecjgCHUTmUiTZmNUjzVNHjI
ees/x2oGWu2+78qLZhrMG3pcMKIzUALVVvEXk8y/yx74U6bR3u1bVGwJkl+W
Zdlc6DRqOMzYNTtLg9iKioyvV6fR6mv3jygu0uD0m5ePMnSmkduf9Cs+HApw
/eLzk1fbpxDcnylQFlaA1flBwfGCU6h74u7ZsI0KUCO90v4qZhwpFr+KOnZG
AbzvugadzO5HNcqzKa2WCmBp5VHl7dGPrkfpf3ayUoATC8bljur9qMpx6Pd9
GwWA1AmH1Pd96IrIFl58UQF8LDvj3iX1Inw2w3ubB3m9L0yr4Nvd6PRslrVI
mAJovo0RF9VsRZFbizbX5StA74e0G3dYxch+hutPxWY6CAlfF3Gfb8NW6bo1
lsp0KH2Q3toS3I7Nbe5WTWylQ22eOv/C2g6s95uzVEKNDvnCH+5ulOnEG95y
fLfZRQdbVWe3uJ1duM+WLXXuAB12/DE5ZXKhB9vVLVzfdJYOp8LlDti/GMCW
wfu88qzokP7UJ0e0YwCbgvdVI2s6LFrYcPrLD2LdjHkXz/Nk/Lt1QRnJg1gx
ZM620JEOgwydbetThnCPNmF4yosOx/iCtrM9G8G2n6blgyPokPLK0VHHdAJf
8jdZNHhIh1nZWxJzjyewp0nWX4HHdLBgXtt3rH4CBzE9wyOj6BCoXXvHYeMk
ztgztxD9gg77qGLMhy8n8VzhSmPaWzok306T3Ro5hTkeW2c6vKcDm9Zeau27
KSxgVxi2+QMdylU/emhWTGE5ngDdjEw6bLo1U3OZfRrrGvBkfvlKByN9yrHd
l6dxZJ1AWEkZHVL5wrj5YIb0ny4O9yvocOjd4hbqqRn80qPmgH4VHc4I/Yie
dp/B2ZTI+aoaOrCsNi8NJ8/g1tNiDvX/0cHaZ90Rdg4GVuqROtDdQ4d23Opy
P4uBVbNuyqX00eGxaazKtwoG3nuvZe7CAB2MrX7mvW9nYEOlFx+Hhukw95hT
rX4VE19xlpebmqKDVuC69yInmdhH885c5gwdwltLh/c5MfE9we4GDyYdJo17
BdbfYuKYDy9DZ2fpMM9lKqGaTPqL21wXv82T692FA09kMfHbExd0fBbpIG4j
xthWysRZCqWyWst0ELwkrlD1l4nzZzbMrazQYWFzWaPCEBP/D9Pwrm0=
           "]]},
         Annotation[#, "Charting`Private`Tag$653466#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwU2Xk4lN8XAHBme8cWw2AwGFQkKSokX/e0aVOJSJJkKSK0Ce0LKhQVSWUp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           "]]},
         Annotation[#, "Charting`Private`Tag$653466#3"]& ], 
        TagBox[
         {RGBColor[0.922526, 0.385626, 0.209179], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwU23k8F88fB3D3fXyOXR9UqBRfVEqHJPOuUHJEoUgqRIhIh0KKotwUColS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           "]]},
         Annotation[#, "Charting`Private`Tag$653466#4"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{7.989795918367348, 1.5}, {1.5, 0.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {475.3252756914467, -92.62500043839714},
      ImageScaled[{0.5, 0.5}], {291.72115445001134, 176.4285722636136}]}, {}},
  
  ImageSize->Large,
  PlotRange->{{0, 631.0459458198881}, {-185.25000087679427`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.6762501315983133`*^9, 3.676250176425877*^9}, {
   3.6762502781850224`*^9, 3.6762502874836683`*^9}, {3.676250328606864*^9, 
   3.676250333087245*^9}, {3.676250819102541*^9, 3.676250853437847*^9}, {
   3.676250892421486*^9, 3.676250938582748*^9}, {3.6762510202336903`*^9, 
   3.67625102393753*^9}, {3.6762511114566317`*^9, 3.676251112422825*^9}, 
   3.6762512075562983`*^9, {3.676251379591207*^9, 3.6762513961035223`*^9}, {
   3.67625600602418*^9, 3.6762560404205*^9}, 3.6762565185864983`*^9, {
   3.676256756416443*^9, 3.676256783467104*^9}, 3.6762577168113403`*^9, {
   3.676257829617527*^9, 3.6762578373188257`*^9}, 3.676258873023013*^9, {
   3.676259545004307*^9, 3.676259572105538*^9}, 3.676259673716868*^9, {
   3.676260230687654*^9, 3.6762602434073887`*^9}, 3.6762629132378263`*^9, 
   3.6763890708784037`*^9, 3.676389104174048*^9, {3.676389139035212*^9, 
   3.676389190663061*^9}, 3.676389915755176*^9, {3.676390324212613*^9, 
   3.676390345094112*^9}, {3.6763911188715878`*^9, 3.6763911549504004`*^9}, {
   3.676391201989612*^9, 3.6763913060630198`*^9}, 3.676392078951173*^9, 
   3.676393391926305*^9, 3.676393482363571*^9, 3.676393529593643*^9, 
   3.676393587447521*^9, 3.6764307023282423`*^9, 3.6764314649084587`*^9, 
   3.6764314951333*^9, 3.676431829210865*^9, 3.676431859821949*^9, 
   3.676431941851122*^9, 3.6764319981859713`*^9, 3.676432434801207*^9, 
   3.6764863979194803`*^9, 3.676488200904688*^9, 3.67649713970446*^9, 
   3.67649743316362*^9, 3.676497729318718*^9, 3.676497813509261*^9, 
   3.676577376762377*^9, {3.676577448108829*^9, 3.676577475103301*^9}, 
   3.676601154519813*^9, 3.67660287748738*^9, 3.676602923531617*^9, 
   3.676602971868058*^9, {3.6766056864553757`*^9, 3.676605711042254*^9}, 
   3.676606251770198*^9, 3.676816043707613*^9, 3.676819023645433*^9, {
   3.6768190719976387`*^9, 3.676819081146605*^9}, 3.6768191210901413`*^9, 
   3.676819597696735*^9, 3.6768278664744587`*^9, 3.676834844515132*^9, 
   3.6768381669445267`*^9, 3.6768418752382517`*^9, 3.67684192445535*^9, 
   3.676842004331766*^9, {3.676842107235175*^9, 3.676842128083098*^9}, {
   3.676842167643921*^9, 3.6768422128540907`*^9}, 3.676842265477682*^9, {
   3.676842335289373*^9, 3.676842360300506*^9}, 3.6768602183766603`*^9, 
   3.676860730395294*^9, 3.676861160635583*^9, 3.6769416713789787`*^9, 
   3.676941785625175*^9, 3.676943082495483*^9, 3.676943575364612*^9, 
   3.676943954969586*^9, 3.676944053116403*^9, 3.676944090042754*^9, 
   3.6770882870902233`*^9, 3.677182170953744*^9, 3.677182581586235*^9, 
   3.6771874391515493`*^9, 3.677201631539794*^9, 3.677203842717952*^9, 
   3.67720728157246*^9, 3.6774634512548227`*^9, 3.677768790498324*^9, 
   3.6777690322082357`*^9, 3.677769310565194*^9, 3.677769386943334*^9, {
   3.67777044968382*^9, 3.6777704766017523`*^9}, 3.793322208537978*^9, {
   3.793851490650429*^9, 3.7938515001868267`*^9}, 3.8232276413672113`*^9},
 CellLabel->
  "Out[1760]=",ExpressionUUID->"6bbb67f5-54d2-424c-8f90-20822ec6573e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{"SG1tf", ",", "d", ",", "t"}], "]"}], ",", 
      RowBox[{"OutputResponse", "[", 
       RowBox[{"negT1tf", ",", "d", ",", "t"}], "]"}]}], "}"}], ",", 
    RowBox[{"Kp", ">", "0"}]}], "]"}], "//", "TraditionalForm", 
  " "}]], "Input",
 CellChangeTimes->{{3.676818530661182*^9, 3.6768186004580593`*^9}, {
  3.6768191304046183`*^9, 3.676819191033111*^9}, {3.67684202508741*^9, 
  3.676842027356264*^9}, {3.6771821649943027`*^9, 3.677182167039564*^9}},
 CellLabel->
  "In[1761]:=",ExpressionUUID->"7c74e168-3bea-4df3-a89a-682ab318c7d7"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{
        TemplateBox[{
          RowBox[{"t"}]},
         "HeavisideThetaSeq"], " ", 
        RowBox[{"sin", "(", 
         RowBox[{
          SqrtBox[
           RowBox[{"Kp", "+", "1"}]], " ", "t"}], ")"}]}], 
       SqrtBox[
        RowBox[{"Kp", "+", "1"}]]]},
     {
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Kp", " ", 
         TemplateBox[{
           RowBox[{"t"}]},
          "HeavisideThetaSeq"], " ", 
         RowBox[{"sin", "(", 
          RowBox[{
           SqrtBox[
            RowBox[{"Kp", "+", "1"}]], " ", "t"}], ")"}]}], 
        SqrtBox[
         RowBox[{"Kp", "+", "1"}]]]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.6771821677269773`*^9, 3.6771821712945623`*^9}, 
   3.677182581922124*^9, 3.6771874394828377`*^9, 3.677201631885255*^9, 
   3.6772038430574512`*^9, 3.6772072819199553`*^9, 3.6774634516773357`*^9, 
   3.6777687908517027`*^9, 3.677769032554233*^9, 3.6777693108938007`*^9, 
   3.677769387265566*^9, {3.677770450031959*^9, 3.677770476943654*^9}, 
   3.793322208735406*^9, {3.7938514908555183`*^9, 3.793851500378367*^9}, 
   3.823227641574705*^9},
 CellLabel->
  "Out[1761]//TraditionalForm=",ExpressionUUID->"d008526a-5737-4b9c-9cd6-\
e16d97cbd7d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"DSolveValue", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"y", "''"}], "[", "t", "]"}], "+", 
          RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "Kp"}], " ", 
           RowBox[{"y", "[", "t", "]"}]}], "+", "d"}]}], ",", 
        RowBox[{
         RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
      ",", 
      RowBox[{"y", "[", "t", "]"}], ",", "t"}], "]"}], ",", 
    RowBox[{"Kp", ">", "0"}]}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellChangeTimes->{{3.676819423025991*^9, 3.676819512988514*^9}, {
  3.6768195560397673`*^9, 3.676819571281768*^9}, {3.676819617889502*^9, 
  3.676819625712552*^9}, {3.676820998719554*^9, 3.676821016964134*^9}, {
  3.676842034277919*^9, 3.676842036708259*^9}, {3.677182182129262*^9, 
  3.677182184286817*^9}},
 CellLabel->
  "In[1762]:=",ExpressionUUID->"038ba38a-8982-43e5-825f-536104ed9c62"],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      TemplateBox[{
        RowBox[{"t"}]},
       "HeavisideThetaSeq"], "-", 
      TemplateBox[{
        RowBox[{"0"}]},
       "HeavisideThetaSeq"]}], ")"}], " ", 
    RowBox[{"sin", "(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Kp", "+", "1"}]], " ", "t"}], ")"}]}], 
   SqrtBox[
    RowBox[{"Kp", "+", "1"}]]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.677182185123253*^9, 3.677182582142461*^9, 3.677187439710992*^9, 
   3.677201632114305*^9, 3.677203843288783*^9, 3.6772072821396303`*^9, 
   3.677463452087085*^9, 3.677768791071549*^9, 3.677769032765685*^9, 
   3.677769311102903*^9, 3.6777693874739513`*^9, {3.6777704502550383`*^9, 
   3.677770477175334*^9}, 3.793322208853499*^9, {3.793851490985815*^9, 
   3.793851500485813*^9}, 3.8232276416805143`*^9},
 CellLabel->
  "Out[1762]//TraditionalForm=",ExpressionUUID->"3c8947ef-a20b-488d-8402-\
a4e59e3e71a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SG1", ",", "negT1"}], "}"}]], "Input",
 CellChangeTimes->{{3.676822768361332*^9, 3.676822768742805*^9}, {
  3.676827687369628*^9, 3.676827696304303*^9}},
 CellLabel->
  "In[1763]:=",ExpressionUUID->"20020af2-8112-44fd-baf3-d07b4f54ea6f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", "Kp", "+", 
     SuperscriptBox["s", "2"]}]], ",", 
   RowBox[{"-", 
    FractionBox["Kp", 
     RowBox[{"1", "+", "Kp", "+", 
      SuperscriptBox["s", "2"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6768227692965527`*^9, 3.6768276966841*^9, 3.676827867159711*^9, 
   3.676834845136509*^9, 3.676838167888631*^9, 3.676841876071027*^9, 
   3.6768419250758333`*^9, 3.676842004917297*^9, {3.6768421073485327`*^9, 
   3.67684212818437*^9}, {3.676842167874468*^9, 3.676842212946431*^9}, 
   3.676842265569878*^9, {3.676842335378899*^9, 3.676842360399035*^9}, 
   3.676860218480192*^9, 3.676860730499194*^9, 3.676861160739222*^9, 
   3.676941671482045*^9, 3.676941785714602*^9, 3.676943082589231*^9, 
   3.676943575464501*^9, 3.676943955056562*^9, 3.6769440532413483`*^9, 
   3.6769440901403093`*^9, 3.6770882871903543`*^9, 3.677182171371738*^9, 
   3.677182582207848*^9, 3.677187439768669*^9, 3.67720163213918*^9, 
   3.677203843352675*^9, 3.67720728216682*^9, 3.677463452130307*^9, 
   3.677768791130578*^9, 3.6777690328195553`*^9, 3.677769311132461*^9, 
   3.677769387534049*^9, {3.6777704503091593`*^9, 3.677770477253508*^9}, 
   3.793322208859517*^9, {3.793851490993285*^9, 3.793851500508285*^9}, 
   3.823227641686762*^9},
 CellLabel->
  "Out[1763]=",ExpressionUUID->"6e09e546-4a11-4def-a506-772dba49c37f"]
}, Open  ]],

Cell["Pure derivative control", "Text",
 CellChangeTimes->{{3.676256123319852*^9, 3.6762561340117064`*^9}, {
  3.676256527464588*^9, 3.676256537807025*^9}, {3.676390134403613*^9, 
  3.676390134811151*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"4775a3c5-3c4a-484d-aa5d-38e64b15ab7f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"K2", "=", 
   RowBox[{"Kd", " ", "s"}]}], ";", " ", 
  RowBox[{"SG2", "=", 
   RowBox[{"Together", "[", 
    FractionBox["G", 
     RowBox[{"1", "+", 
      RowBox[{"K2", " ", "G"}]}]], "]"}]}], ";", " ", 
  RowBox[{"SG2tf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"SG2", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"negT2", "=", 
   RowBox[{"Together", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "K2"}], " ", "G"}], 
     RowBox[{"1", "+", 
      RowBox[{"K2", " ", "G"}]}]], "]"}]}], ";", " ", 
  RowBox[{"negT2tf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"negT2", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y2a", "=", 
   RowBox[{
    RowBox[{"OutputResponse", "[", 
     RowBox[{
      RowBox[{"SG2tf", "/.", 
       RowBox[{"Kd", "\[Rule]", "1"}]}], ",", "d", ",", "trange"}], "]"}], 
    "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y2b", "=", 
    RowBox[{
     RowBox[{"OutputResponse", "[", 
      RowBox[{
       RowBox[{"SG2tf", "/.", 
        RowBox[{"Kd", "\[Rule]", "2"}]}], ",", "d", ",", "trange"}], "]"}], 
     "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p2a", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y0", ",", "y2a", ",", "y2b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u2a", "=", 
   RowBox[{
    RowBox[{"OutputResponse", "[", 
     RowBox[{
      RowBox[{"negT2tf", "/.", 
       RowBox[{"Kd", "\[Rule]", "1"}]}], ",", "d", ",", "trange"}], "]"}], 
    "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u2b", "=", 
    RowBox[{
     RowBox[{"OutputResponse", "[", 
      RowBox[{
       RowBox[{"negT2tf", "/.", 
        RowBox[{"Kd", "\[Rule]", "2"}]}], ",", "d", ",", "trange"}], "]"}], 
     "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"[", 
    RowBox[{"=", 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"t", "-", "1"}], ")"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "t"}]]}]}], "]"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p2b", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "u2a", ",", "u2b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p2a", ",", " ", "p2b"}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Large"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.67639015361418*^9, 3.6763901538583727`*^9}, {
   3.676390217550023*^9, 3.676390242846733*^9}, {3.676391167803063*^9, 
   3.676391174097126*^9}, 3.676391239099794*^9, 3.676391297345697*^9, {
   3.6764318372903347`*^9, 3.676431995682521*^9}, {3.676432027629024*^9, 
   3.676432035833112*^9}, {3.676486483492124*^9, 3.67648650799666*^9}, {
   3.676487592701482*^9, 3.6764876852105513`*^9}, {3.6764881738200502`*^9, 
   3.676488177835948*^9}, {3.676497419291457*^9, 3.676497423305826*^9}, {
   3.676497532637602*^9, 3.676497563572935*^9}, {3.6765774123744583`*^9, 
   3.676577417413067*^9}, 3.676577521328265*^9},
 CellLabel->
  "In[1764]:=",ExpressionUUID->"7aafc2b1-de7a-4ae1-b42c-a905e6b43e3d"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVmHk41N8Xxy1RpDBjyTILU1GKikqbc1GUSJQlybdUkr2iKJU2hRRlV5Qo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           "]]},
         Annotation[#, "Charting`Private`Tag$655974#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV13k4VP8XB3BRlN0MKlnuIFuFpIXkfCqlIpUiSXwT2YUsWSqhZBkhe0l2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           "]]},
         Annotation[#, "Charting`Private`Tag$655974#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVl3k4lV0XxkWEiKJBr+Ecp1CkVxNS7i1DpsgUSRRCiAZTKDIrZUhIgzel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           "]]},
         Annotation[#, "Charting`Private`Tag$655974#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{16.153061224489797`, 1.4999999999999432`}, {1.5, 0.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {159.41145800166436, -92.30444697339695},
      ImageScaled[{0.5, 0.5}], {298.89648375312066, 175.8179942350418}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJxFz2lI0wEYBvDZtGLOcFqmqdt/Ji7nkX4IMvJIg8yLTJcw6djUzfJKcWBq
ZabpEG3V8GQMNQ0RZ8YM7FimpnktdGXRjMQ5RFPQ1tKptQryfV94ePh9e14m
P+tsyg4SiRT9N/9adoO/0z+5Ioj0/wY0RFQCcTl42+ZB1W2CuAaW9VYyrAgx
OD1QlLHGqANrNlOlK4w28C7tLGuZ0QNuHJFnf2MMgxWdYm2672ewMHiibilH
B87Ue+qUigUwhVnC+np0BVxlO8puvGQA87Xxr8hjP8HZb0r4WawNcNdVapzj
6V+4pyBt0S+BFLLtYvlW7I8lCzBJMxPyIp8M9sgV5MWzrcBzxppz1i93giP0
V67fz94NjpmTeNHpFPBiP7/obYc12Jc25Rp20QZMCTbypg17wKeWuWtuHFvw
p75kC643DdxdPnCBMKIFVqIZtdoOnJRT0E2ttwcfFnqpo3h7we/svK1FAfvA
zxXFDd5kB3CBBfvM2Bc0ZTo/PFO5H6xvZUrlhY5g6SEnyx6OE1hSLxjiEQfA
XOl5NXUevX6yxSRXOYN1+tC8vjIXcFOgv/M4zxXcUSqiCX3o4DJOUiTZiD4y
3dhWNs4A13o2dIxHEuCbvZW1kT3oaGdOy4g7E3wicyiRJkbLXfjuY0a0e/+j
6phEN/zPp489qUILDJYTw+yDYH7Xd0J8F51eHLcVcQ8tilN+pD5AlxtFVZJq
tCLAtFkjQ5tem6da29GSSWrlwBC6vjkj9c4wujlXHRY+in7qINkYVaOnufap
mg9ols4pbFaH9lPm0x/q0cdKtaaUeXQUS/Z4YRGdk0bQV1fRhcdvmZ4Y0KU2
s+9zjejazuaK9XV0U5Gl8NkGuj02JbRwC610G3QN+o1WGTxMZjP6DwbEFmI=

           "]]},
         Annotation[#, "Charting`Private`Tag$656742#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVl3k4VP8XxzHIVvaZsTO37NEiWuRzKJGUJUSpLNmyhyTLTNaIUEJIyDLf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           "]]},
         Annotation[#, "Charting`Private`Tag$656742#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV13k0lN8fB/AZJEX2lIRhhGwhFS0+NyIMsossUdmTlBCibCm+EUnWUvYk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           "]]},
         Annotation[#, "Charting`Private`Tag$656742#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{16.15306122448979, 1.5}, {1.5, 0.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {478.234374004993, -92.30444697339695}, 
     ImageScaled[{0.5, 0.5}], {298.8964837531207, 175.8179942350418}]}, {}},
  ImageSize->Large,
  PlotRange->{{0, 637.6458320066574}, {-184.6088939467939, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.676390243378992*^9, {3.676390324317307*^9, 3.676390345202203*^9}, 
   3.6763911361549177`*^9, {3.6763912020947227`*^9, 3.67639126014498*^9}, {
   3.676391293728889*^9, 3.676391306162238*^9}, 3.676392079058054*^9, 
   3.676393392031827*^9, 3.676393482464674*^9, 3.6763935296962023`*^9, 
   3.676393587553035*^9, 3.676430702436685*^9, 3.676431465005735*^9, 
   3.676431495232252*^9, 3.676431829309916*^9, 3.6764318599245253`*^9, 
   3.676431942254943*^9, 3.676431998373467*^9, 3.6764320369428062`*^9, 
   3.676432434953992*^9, 3.676486398082144*^9, {3.676486488621303*^9, 
   3.676486508643564*^9}, {3.6764876036554537`*^9, 3.6764876290618753`*^9}, 
   3.676487685833844*^9, 3.6764882010544033`*^9, 3.676497139873818*^9, 
   3.676497433328134*^9, 3.6764975653951693`*^9, 3.676497729471182*^9, 
   3.676497813665024*^9, 3.676577376900106*^9, {3.676577413231312*^9, 
   3.676577448249893*^9}, 3.6765775224221697`*^9, 3.6766011546741743`*^9, 
   3.67660287769805*^9, 3.676602923682816*^9, 3.676602972030027*^9, 
   3.676605711192747*^9, 3.67660625193326*^9, 3.676816043894238*^9, 
   3.676819598541135*^9, 3.676827867306831*^9, 3.676834845334103*^9, 
   3.676838168045702*^9, 3.676841876226079*^9, 3.676841925215283*^9, 
   3.676842005062386*^9, {3.6768421074993773`*^9, 3.676842128335044*^9}, {
   3.6768421681833353`*^9, 3.676842213087365*^9}, 3.676842265719543*^9, {
   3.6768423355280313`*^9, 3.676842360541974*^9}, 3.67686021862742*^9, 
   3.676860730641261*^9, 3.676861160885689*^9, 3.6769416716322327`*^9, 
   3.6769417858587227`*^9, 3.676943082738469*^9, 3.676943575610818*^9, 
   3.676943955204238*^9, 3.676944053390684*^9, 3.67694409028708*^9, 
   3.677088287359017*^9, 3.677182171511278*^9, 3.677182582401454*^9, 
   3.6771874400158453`*^9, 3.67720163227984*^9, 3.6772038435424547`*^9, 
   3.6772072823137703`*^9, 3.6774634522785397`*^9, 3.677768791283386*^9, 
   3.677769032966736*^9, 3.677769311277871*^9, 3.6777693876748543`*^9, {
   3.677770450521491*^9, 3.6777704774194727`*^9}, 3.793322209027669*^9, {
   3.7938514911906843`*^9, 3.793851500705695*^9}, 3.823227641888064*^9},
 CellLabel->
  "Out[1772]=",ExpressionUUID->"19373a27-7c07-4831-9349-59972b99b155"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"SG2", ",", "negT2", ",", 
    RowBox[{"Limit", "[", 
     RowBox[{
      RowBox[{"s", " ", "negT2"}], ",", 
      RowBox[{"s", " ", "\[Rule]", " ", "\[Infinity]"}]}], "]"}]}], "}"}], 
  "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"=", " ", 
    RowBox[{"u", 
     RowBox[{"(", 
      SuperscriptBox["0", "+"], ")"}], " ", "the", " ", "initial", " ", 
     "value", " ", "of", " ", "the", " ", "output"}]}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.676497615306693*^9, 3.676497674461561*^9}, {
  3.676497751555558*^9, 3.67649777245015*^9}, {3.676827715438718*^9, 
  3.676827716110676*^9}},
 CellLabel->
  "In[1773]:=",ExpressionUUID->"053003a9-98f2-44af-8131-22eee24b5edf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{"Kd", " ", "s"}], "+", 
     SuperscriptBox["s", "2"]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"Kd", " ", "s"}], 
     RowBox[{"1", "+", 
      RowBox[{"Kd", " ", "s"}], "+", 
      SuperscriptBox["s", "2"]}]]}], ",", 
   RowBox[{"-", "Kd"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.67649764972885*^9, 3.6764977295078077`*^9, {3.6764977597006493`*^9, 
   3.676497774795579*^9}, 3.676497813709174*^9, 3.67657737697015*^9, 
   3.676577448302055*^9, 3.676601154749216*^9, 3.6766028777397738`*^9, 
   3.676602923730033*^9, 3.676602972070134*^9, 3.676605711239973*^9, 
   3.67660625200463*^9, 3.676816043979768*^9, 3.676819598595599*^9, 
   3.676827716468731*^9, 3.676827867372294*^9, 3.6768348453736773`*^9, 
   3.676838168088719*^9, 3.676841876282466*^9, 3.67684192530785*^9, 
   3.676842005135972*^9, {3.676842107538912*^9, 3.6768421283847847`*^9}, {
   3.676842168268491*^9, 3.676842213130069*^9}, 3.676842265770105*^9, {
   3.676842335579534*^9, 3.676842360581489*^9}, 3.6768602186797943`*^9, 
   3.676860730698351*^9, 3.6768611609399652`*^9, 3.676941671691852*^9, 
   3.676941785920616*^9, 3.676943082799412*^9, 3.6769435756818542`*^9, 
   3.676943955264844*^9, 3.676944053462699*^9, 3.676944090349834*^9, 
   3.677088287438211*^9, 3.6771821715449047`*^9, 3.6771825824712877`*^9, 
   3.677187440060526*^9, 3.677201632406971*^9, 3.677203843576766*^9, 
   3.6772072824020147`*^9, 3.6774634523482924`*^9, 3.677768791324078*^9, 
   3.677769033176409*^9, 3.677769311393178*^9, 3.677769387766385*^9, {
   3.677770450592081*^9, 3.677770477455801*^9}, 3.793322209073553*^9, {
   3.793851491209587*^9, 3.7938515007254887`*^9}, 3.823227641911731*^9},
 CellLabel->
  "Out[1773]=",ExpressionUUID->"9d0ead8e-4e0c-4f32-8b11-404a3ff20bed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"OutputResponse", "[", 
      RowBox[{
       RowBox[{"SG2tf", "/.", 
        RowBox[{"Kd", "\[Rule]", "1"}]}], ",", "d", ",", "t"}], "]"}], ",", 
     RowBox[{"OutputResponse", "[", 
      RowBox[{
       RowBox[{"negT2tf", "/.", 
        RowBox[{"Kd", "\[Rule]", "1"}]}], ",", "d", ",", "t"}], "]"}], ",", 
     RowBox[{"OutputResponse", "[", 
      RowBox[{
       RowBox[{"SG2tf", "/.", 
        RowBox[{"Kd", "\[Rule]", "2"}]}], ",", "d", ",", "t"}], "]"}], ",", 
     RowBox[{"OutputResponse", "[", 
      RowBox[{
       RowBox[{"negT2tf", "/.", 
        RowBox[{"Kd", "\[Rule]", "2"}]}], ",", "d", ",", "t"}], "]"}]}], 
    "}"}], "//", "Simplify"}], "//", "TraditionalForm", " "}]], "Input",
 CellChangeTimes->{{3.676816032253261*^9, 3.6768160367049837`*^9}, {
  3.676816089004978*^9, 3.67681609755521*^9}, {3.6768161359101353`*^9, 
  3.6768162162691317`*^9}, {3.6768162570771427`*^9, 3.676816259476523*^9}, {
  3.676827897183964*^9, 3.676827902261963*^9}, {3.676842043092464*^9, 
  3.6768420452278233`*^9}, {3.677182208790618*^9, 3.677182210750058*^9}},
 CellLabel->
  "In[1774]:=",ExpressionUUID->"6610d31e-5652-43cb-9ff2-5b22bcad6dd4"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "t"}], "/", "2"}]], " ", 
        TemplateBox[{
          RowBox[{"t"}]},
         "HeavisideThetaSeq"], " ", 
        RowBox[{"sin", "(", 
         FractionBox[
          RowBox[{
           SqrtBox["3"], " ", "t"}], "2"], ")"}]}], 
       SqrtBox["3"]]},
     {
      RowBox[{
       FractionBox["1", "3"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "t"}], "/", "2"}]], " ", 
       TemplateBox[{
         RowBox[{"t"}]},
        "HeavisideThetaSeq"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SqrtBox["3"], " ", 
          RowBox[{"sin", "(", 
           FractionBox[
            RowBox[{
             SqrtBox["3"], " ", "t"}], "2"], ")"}]}], "-", 
         RowBox[{"3", " ", 
          RowBox[{"cos", "(", 
           FractionBox[
            RowBox[{
             SqrtBox["3"], " ", "t"}], "2"], ")"}]}]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "t"}]], " ", "t", " ", 
       TemplateBox[{
         RowBox[{"t"}]},
        "HeavisideThetaSeq"]}]},
     {
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "t"}]], " ", 
       RowBox[{"(", 
        RowBox[{"t", "-", "1"}], ")"}], " ", 
       TemplateBox[{
         RowBox[{"t"}]},
        "HeavisideThetaSeq"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.677182211323977*^9, 3.677182582687406*^9, 3.6771874402702303`*^9, 
   3.677201632626742*^9, 3.67720384380422*^9, 3.677207282614703*^9, 
   3.677463452581106*^9, 3.67776879154617*^9, 3.677769033419799*^9, 
   3.677769311613859*^9, 3.677769387981476*^9, {3.6777704508125257`*^9, 
   3.677770477665225*^9}, 3.79332220920924*^9, {3.793851491373206*^9, 
   3.79385150088878*^9}, 3.823227642075248*^9},
 CellLabel->
  "Out[1774]//TraditionalForm=",ExpressionUUID->"4625d37c-38c6-494e-88b5-\
47efc3a31224"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqs2", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "t", "]"}], "+", 
        RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", 
       RowBox[{
        RowBox[{"u", "[", "t", "]"}], "+", "d"}]}], ",", 
      RowBox[{
       RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"-", "Kd"}], " ", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "t", "]"}]}]}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], "/.", 
    RowBox[{"Kd", "\[Rule]", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DSolveValue", "[", 
    RowBox[{"eqs2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "[", "t", "]"}], ",", 
       RowBox[{"u", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}], "//", 
   "Simplify"}], "//", "TraditionalForm"}]}], "Input",
 CellChangeTimes->{{3.676830089988242*^9, 3.6768301320965776`*^9}, {
  3.676830172352146*^9, 3.676830191928865*^9}, {3.676842048284214*^9, 
  3.676842050523653*^9}, {3.677182217478765*^9, 3.677182341457481*^9}, {
  3.677769286326721*^9, 3.677769320052544*^9}},
 CellLabel->
  "In[1775]:=",ExpressionUUID->"95e0b675-7ca6-4b52-bd2e-e5ea79f08e59"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "t"}]], " ", "t", " ", 
     RowBox[{"(", 
      RowBox[{
       TemplateBox[{
         RowBox[{"t"}]},
        "HeavisideThetaSeq"], "-", 
       TemplateBox[{
         RowBox[{"0"}]},
        "HeavisideThetaSeq"]}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "t"}]], " ", 
     RowBox[{"(", 
      RowBox[{"t", "-", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       TemplateBox[{
         RowBox[{"0"}]},
        "HeavisideThetaSeq"], "-", 
       TemplateBox[{
         RowBox[{"t"}]},
        "HeavisideThetaSeq"]}], ")"}]}]}], "}"}], TraditionalForm]], "Output",\

 CellChangeTimes->{{3.677182238328603*^9, 3.677182259736835*^9}, {
   3.677182292042904*^9, 3.677182341923278*^9}, 3.6771825827418127`*^9, 
   3.6771874403328648`*^9, 3.677201632675681*^9, 3.677203843850811*^9, 
   3.677207282667153*^9, 3.677463452631495*^9, 3.6777687916016006`*^9, 
   3.67776903352022*^9, {3.677769306656385*^9, 3.6777693210181704`*^9}, 
   3.677769388032874*^9, {3.677770450873556*^9, 3.677770477725691*^9}, 
   3.793322209251327*^9, {3.793851491479101*^9, 3.793851500979508*^9}, 
   3.8232276422194357`*^9},
 CellLabel->
  "Out[1776]//TraditionalForm=",ExpressionUUID->"7c45103f-7945-4a73-af30-\
0f252b14f73f"]
}, Open  ]],

Cell["PD control", "Text",
 CellChangeTimes->{{3.676256123319852*^9, 3.6762561340117064`*^9}, {
  3.676256527464588*^9, 3.676256537807025*^9}, {3.676390134403613*^9, 
  3.676390134811151*^9}, {3.676432290911524*^9, 3.676432291046063*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"63e733b7-036f-499d-a3df-030eefae8655"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"K3", "=", 
   RowBox[{"Kp", "+", 
    RowBox[{"Kd", " ", "s"}]}]}], ";", " ", 
  RowBox[{"SG3", "=", 
   RowBox[{"Together", "[", 
    FractionBox["G", 
     RowBox[{"1", "+", 
      RowBox[{"K3", " ", "G"}]}]], "]"}]}], ";", " ", 
  RowBox[{"SG3tf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"SG3", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"negT3", "=", 
   RowBox[{"Together", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "K3"}], " ", "G"}], 
     RowBox[{"1", "+", 
      RowBox[{"K3", " ", "G"}]}]], "]"}]}], ";", " ", 
  RowBox[{"negT3tf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"negT3", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"y3a", "=", 
    RowBox[{
     RowBox[{"OutputResponse", "[", 
      RowBox[{
       RowBox[{"SG3tf", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Kp", "\[Rule]", "1"}], ",", 
          RowBox[{"Kd", "\[Rule]", 
           RowBox[{"2", 
            SqrtBox["2"]}]}]}], "}"}]}], ",", "d", ",", "trange"}], "]"}], 
     "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y3b", "=", 
    RowBox[{
     RowBox[{"OutputResponse", "[", 
      RowBox[{
       RowBox[{"SG3tf", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Kp", "\[Rule]", "5"}], ",", 
          RowBox[{"Kd", "\[Rule]", 
           RowBox[{"2", 
            SqrtBox["6"]}]}]}], "}"}]}], ",", "d", ",", "trange"}], "]"}], 
     "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p3a", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y2b", ",", "y3a", ",", "y3b", ",", "y0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u3a", "=", 
   RowBox[{
    RowBox[{"OutputResponse", "[", 
     RowBox[{
      RowBox[{"negT3tf", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Kp", "\[Rule]", "1"}], ",", 
         RowBox[{"Kd", "\[Rule]", 
          RowBox[{"2", 
           SqrtBox["2"]}]}]}], "}"}]}], ",", "d", ",", "trange"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u3b", "=", 
   RowBox[{
    RowBox[{"OutputResponse", "[", 
     RowBox[{
      RowBox[{"negT3tf", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Kp", "\[Rule]", "5"}], ",", 
         RowBox[{"Kd", "\[Rule]", 
          RowBox[{"2", 
           SqrtBox["6"]}]}]}], "}"}]}], ",", "d", ",", "trange"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p3b", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u2b", ",", "u3a", ",", ",", "u3b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p3a", ",", " ", "p3b"}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Large"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.676432298991929*^9, 3.676432431939209*^9}, {
  3.6764325448829613`*^9, 3.676432574408371*^9}, {3.6764326061149273`*^9, 
  3.67643261212192*^9}, {3.6764863825642242`*^9, 3.676486437278077*^9}, {
  3.676488182891757*^9, 3.676488187899344*^9}, {3.676497581469248*^9, 
  3.676497600683674*^9}, {3.676497808117062*^9, 3.676497809328231*^9}, {
  3.676577169875874*^9, 3.676577174001404*^9}, {3.676577225560358*^9, 
  3.6765772698475924`*^9}, {3.676577563865212*^9, 3.676577599834036*^9}},
 CellLabel->
  "In[1777]:=",ExpressionUUID->"d1a9b2ee-73bb-4134-b7a2-8d7c90ddfb9f"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVl3k4lV0XxkWEiKJBr+Ecp1CkVxNS7i1DpsgUSRRCiAZTKDIrZUhIgzel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           "]]},
         Annotation[#, "Charting`Private`Tag$659297#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVl3k0VX8Xxs0Zknme7nWFzEUounuThETIUIRIZJYMPxGhkEiSqUwhpVKU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           "]]},
         Annotation[#, "Charting`Private`Tag$659297#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVVnc4F94XNrJl7/kZRJEiIXHPJaMkSihCkRURSSgiRNkrMyEppZCQbB+r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           "]]},
         Annotation[#, "Charting`Private`Tag$659297#3"]& ], 
        TagBox[
         {RGBColor[0.922526, 0.385626, 0.209179], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVmHk41N8Xxy1RpDBjyTILU1GKikqbc1GUSJQlybdUkr2iKJU2hRRlV5Qo
FSpJET62QmTPkiX7PnOzzyB+n98/c5/Xc+/ce895v8+Z+4ySvbv5aQE+Pr7N
5Mf/x6fX7IU3ngrS4XvSIvT/sbiOaWzFPAtxeRWu5uS48D3vFpPpA07/NUhK
kePT/GCGEDMAFGQio5sZAeCyy8t1mhENJyx3ypqRY92sY9hfxmuYzabvOEp7
DYtbulTYjCzYGJNZGSOdBc9/xJ8bZpRBR8J94/SpUkh7F9Diov4bwtvrd4l6
NcMZqIkeOd8NtPaHs3wGXcCXMJXdEtQNaRWuzhdsuiBqkWLrj8RuMP24PfO3
WxeUljnQXzd0gwrNNOVuZBeoHp5LOL29B7CZcumRgS4YcFRJaefvhd+fzq2r
v9sNTo+u5lWH9IHR3KTsz9wecOtd052RNggHt39fu1uwHzrsmpcUlA3CS/Hs
XYtl+uFQ0z31nz2DsOvn0qos1X7QLu/36ZUfglNVvlvYJv0g+CFJQubuEDSM
LmQGRfZDlK+SzqX/hkHqoNz1JyoDUECVi94mwYYv3ss2fNo+CFrBpXl71Niw
sY7tb7qfPEfYu8fMgA07u3xLG48Own1eg4aTLxt0UkV+f/AdBMs/Yd9jBthw
1bpgLjB3EIbeSEzM5nPAlarysWTHEIgq3Vb5o/0Xip7svkJfOwylO0M1ru35
CwZ9lz64bh0Gf+u4rTTzv3Cr7vXk293DIBDyxfCo81+Q7314e9JuGGbmR840
Pv0LxSJOzV8fDcNwq0VylcAoqCp4NC+fHoaKKJU1+RWjMOnmpB2TPgKBGVob
/2sehcfiusdyckdgb7XutvneUdCMro2rKB2B4sW2+3YujMLY9/M2n9tHIOdi
yNkvG8dA9HJoV4YIG1IP816/jxgDpaDgE0a2bHggUb72+fFx0LDL8skcZ0PW
VtqnA27jcEFY8a3xPzb02LnD3JVxiH1wZ6JCmAM7UqmHrSLHIb5DKj1IjgMD
+2yvLqschxRelii/Dgf0b7GrfHZMwMOlzWXFNzng9gZsVPZNwIJVFoUXyIGY
mtCeessJcHe3FpJ9zIG/jC08jfMT0K7NXy/+ggNxOdeU+5IngK8M3Z8o4AB3
UtzLXGYSTl0Mo/jPcoBFs19YYE3C9MaKRHMBDAd2ZwSkbpyE+rgroUtEMCQ9
so5bYjIJ/765O2yQwWCu8bwk79YkUNv+XnDXwHDNctzMJXQSuJ/WmPpvxvD6
6p5WufhJ2P9xyzH/HRj4Kgb/emZPQu3h2X+6hhhSHTfJq41Owsnv50teHsPQ
9PB2YtP8JBRbhKQJn8Sw6HODur/YFGT5tj8zdcRgI3RFv1NlCrqEDR4/OY9h
SUKRS6TdFMjvld+n7I9Bs0x6erfLFPxyi6f9CMRg9/fMjTGfKdgSsb7b5iGG
TzpiESbhU3BDxGnr1igM9i2HCcGKKVD3vJv3OxmDaGyn67nmKdgU8TLlcwqG
dBs3xT99U/BWctLk2nsMgr/v+mTzT0PfxbRnpZ8xJDZla57bOg1try7tNvuG
wTjKsKt99zQM6U0FXCnFMGFVH2JsPg0wm+/+sBzDnkY2W8V1Gt6uKqN41mDo
+8VMbk8g91se4LmhFcOD8FRL4/fTEKZrcvlVO4YtFtuFsnOnwdbi8rIlnRju
1h+yD2+aBpWbT2vv9GLYENYhIdg3DfSK3wsJ/WT+DrkSHuPTIHdE/MPrQQyq
df6Kxsu5IBQ3En6BjaH6EbU8S4ELw/6txVswBm/zZz4qa7hg7PKfW/dfDEzK
etXwLVyIVjEO9RnDUFaT1SCwmwvHOiPX88YxnA81uONhxoW2cH19+0kM8mZ1
mu12XLDTPVibMYXBqXokJMuHC55uIbYyPAyUEB9QucuFxwPfrFbNYMg2FeaE
hXGh2Oh4BW2WzL/44ycCCVwwCT2evUDy0irGfo93XDj3pUSpfA5DxoMUXlsO
Fy7mRAj4/cNge2Bb8v4fXHgWXWlLnyf9sfy7ZVYjF7SMPTa8JDnlp7mQSi8X
vKp9r8ouYDgc/Odj2BgXXitP6p8nec7YxV6AjwdS8PtWJsmJYjwJj2U8mFFa
v6uHZJOKO0SbPA+elXDcZ0meCqK47Vflwf51TMU5kuP2xytmbeYBGBfq9pFs
sHRd+Wp9HhSwGjqySOb8+OITdpDc/50t7yLJEYF7VAXseHBtyDKIRrKOUW2D
uzMPdtd+i0gl79sn8t+dNm8evLZ/o6BC8sOyYc39/jwYixSSDyTj1Q7w7vry
mAcn3ZpCG8h8dOwVCl39nAd6XaxbYiTfW/IIwtJ4UIcH2Gpk/jaU0jn8OTyw
eaxaq0Xmu+nu2yfuZTxQLOvWUCH18DPU3t/WwAPbYIXFglzSH4u/8Yx6eHCi
tdqqlNSv+rtZ8pdRHrilL1K+ROrr7d9uuXqBB6VLv5wWnyD9YeAsFCY2Ax97
hpVDSX+c+3bb3l1lBp78aRExI/1E7zEQntKcAZPPX1amkX4rFxB544tmYPXM
5+TpYQyrUPBowJEZOGRcOW46gKHWzjRcwmEGVJ/n5tn1Ybh+VXJb5HmSR67P
HOnB0Jwd7pcYNAPv8foK6Q4M/s1WK9WiZiCLPXq6oY2sd65c6YfEGRh12eZ9
qwVD8OY4cSJ3BiZ8BJe/aMCg+/5lXDOegeOxVlpcsv44lY56x+dmgM9jaali
GYZY9tq+viWz0NTyonv9dwyTa9+tn1CaBc1FmtnS+WT/Svqcs/zwLKSeipOf
S8dgWexzPPz4LKzON2LdeUf2g+4dixRdZ6GtdGfRzFsMx5j5+9f4z4KEa0L1
20QMkrGlv/W/zELsT0OrVeEY8rICr/0ongW145Om1FAMzk3GymY1syCYuQ+z
72P4Jl1z1m5oFh5siVxz9jYGn5BmrrfiHKy1ji68RPa7zjtDMml+c5CeyP9x
2ojsF4kp2VrBc/DRzmnrhz0YdhS52X2NnoMkhWWhVghDON94Umn6HNzxhTon
sh/vuzKr1d0zB6fZ4vNv6Rg+eIgdWrHvH1BXMfWfsDlQEUP1SbX8B0HziSei
+jjQVywfr3fqH9SEftC59ocD8nJrhl2u/4OzqrWGi2s4cLtgz62CT//AdECP
Lv6RA5aU6x+dlOdhmeE5xZnzHPDY6d+8oDEP2ktKncKcOBDoELwQtmse1rrr
lKyw5wCRHbufsJ6H4qgDJX8OckD15Jdu6sN5SJ4/mnpmPQdmPo5Sc2fngaml
anu6iw1S7dxt5iILkH7ab/hFExvUl/Ad75dZgLi9onMVlWw4abs8RXLTAiS/
upTbns2GikVqux0cF8DGbUUQ/yM2xFmc8hT/tQCqu9yfGO1kw/MrzkMbrPjQ
Lu32k/QbI7AhX4R79xgfqmsIbnzgNQL5i5KF/pzkQ9/PfHNhnx2BjuAeZrAH
H3q711Xey3wE6M+OWQ0G8KGUY8JH3imPQEyxafHzHD606EGITAMxDI+WacVR
lPmR2JshDWX2ENyMnzObGOFHfSBTFyxNvss2fDmnNs6Poqr4g2WEB4FecCHU
nsePOnWfrw2ZGoDsrqHqaiEB1Cq7UcuycQDGVjWbptIFkIj5Fm/1qAGwT/lk
4nBQAJ0XKzNZITsAullu+5o+CiCXtXJtK0T7ga+uA+VcFkTathrO4iU9sNrT
wfvwWiF0Zvji6e2e7dAzGWm5NFcYqauUD8a314JRr9PVR+eWoJQu1nOGcCYc
6AlRo9NFEZddpM9zJ4ihInu/0tSlaOPNuPpa4XpCXbKBpv/fMnRjg8XQ93Ud
RF9w383w08sQ77fvxcd6HcRT0en+fudlKOlva5OFdQchtmhF+n3vZaj2uODI
11sdxNDUEYOG0GXoiZNU+9LfHURSa5vb2eJlSOVX/M13tzsJxeRe4uGa5WhF
iJL1m5ouQhQmT7SOL0e52/N9Iw17CW9d1SWZM8sRTvnsJ2zbS/TpH017yC+O
PCZk2k979BKFewtm9MTF0brrrWcno3qJy+bBj1+vJblPQ8VysJcYPr3q28UT
4sha/KiB5N0+ouK+hapklTjaatoisTizn9j+8F7l0C9xdNyz/dep0n4iOfSr
Z3GrOLIZ2an24Xc/cTtCqeDSkDgKbHA7JL3QT9Crp9ZhAQmk8+zoBlHDAaKh
ufCbBV0Cabnw18bUDRCGbJtpZQsJZHq4/sS/9kEiTupW3XVrCfTSVvtEGWeQ
mNjx9l3rUQnkTs9afGt+kHgWOHsmwl4CpVC3KRG0IWJG5UmTiIcEmnxt7Hjk
6BCRYt+W9TdQAq1IC7VaVjdESDT955uXL4H+WIvpqmUMEw4Ld60ViiWQHzPg
aFTBMJGz+r2Wd4kEGi8/1TBaOUyc9eJjb6yUQPHUE8VnB4eJQsrzY0ktEujW
q46TLrQRwtOkS+f+lAQqfZxWlnFjhGgqPMVvs04SHQv0T5TbwSb+6v6Wv6oh
iTjHlkgb7mETiwtMtZ5tkkSEwQ9/e1M2sYXYfqZPWxLJyEweOnmSTYR9lfh5
fo8kWta2uT0okE2YZuREBdlJIuVNbXPnf7EJB81N6WknJJFsssCFq+1s4lr6
q/KaU5JIXtnutlc/m0h5/2he1lkS6QcxHNR5bEI01fFU4iVJdFLy1YtCBQ7x
PUlqQ24IeV5f/KTHMQ7RvjJwX8djSXRx+MSo+WkOMfliwV4wUhJNR83uUnbl
ECsThsL3PZVEZy3on+/5coibcfmzv15Loq2acy89YziETqRLCadQEhVe+etc
XMshLGW6OiS/S6LF5mcNfZo5hGu41YxWmSTy9zy6RqGDQzx5rLf+SpUk0lks
xVnF5hAzD1c8XtwqiT7qfeBaCmPi071iO+akJKK3Ce1ibcZEslH5irtcSXRf
zdxVcQcmYsRqa9mzkmj+4PbFCwgTfiF/DL4KUNBgzEonP2NMGEfNqFtKUFCE
34H7F+wxATb8gzlUCmK3Orz+fAYTmxSXvGDJUtCWRclSvS6YkH0mLTtKo6Do
9cMlsxcx0fVqw0KQGgU56trrrgjExK+zW7PG1ClIcX+a+8sHmChV07lwZBMF
pVPfV9MeYyL13f7+1dso6PJRBVppLCa8PztUFRhQkIHCteuiKZhw9nENUDWi
oMpzp7s732HCboen/kMTClK58tAu4SMm9Ikbn20PU5Aec+x+ezYmlpc8iZ8+
QUHdIn/O6pdigj/gxRG70xT0ybhM5WQ5JiaM3lC/OVKQ4ZZbnc6VmGiu/Hz3
kTsFvUn7s0u7HhMVIXm6vPMUxCzf0z7bgIk882+z/12koGJXU8/kZkwkNtS6
r79KrpctvZrTjonIqOY1YX4UNHbXE7M6MRFo09E9c4uCvA/CIc9uTLi3s61K
AynIKOcNu6ofE/bPJiQ1HlDQ09J7yi2DmDhsP1seHkpBOxcW9lQNY2J73xJ0
MoqC3HK1LM5jTKxPFp8pi6Ug4TQNUBrFBNNJJmNDPAXxYnSkssYwQVlHc4tM
oKAybb+6bROYEOKwVOeTKGhmB9X3xSQmuO/Wdp16TUGSR2SWTU1hYujcxifl
KRT0cHfynY1cTLRpaltuek+uT+/vseBhonpSRyL6IwXVW4+vOTmDiaLPe34s
ZFLQ86HBQ0dmMZHpY3zbIZuCehWHTmjPkf7acUjnZy4FsRIph/j+YSL23xGu
ZgEF/dG6ufoDyQ+I4+kxxRT05JZVi9E86bcbZ1z4SymoffcHj58kX9B3W+1Y
TkFr1qf1ai9gwkHIq6OykoL4yAdXMMnyjLLG2RrSn5P61BKSK7VpVaq/KCiG
f6BghOSb5ue+WzSR85+e754neYvLt9ybLRSUlpEVQ76viaE7cp/etVMQEe9d
RL6/ibh415TWTlKvFSp55HuaMM8qeCHSS0GMwmWBl0kWrpOO3TJAQQq7vFar
kJw9cvbRyWHy+2ovHxHkfd2E8wJCOBQksmHwpz7JykzKjdxRCrok19f4kYy3
YZuD99AEBfmNJ38QJznwULa7LJfM17JQWysyXzquy8/snqUg+y//mgPJfI75
29udm6egL3oH1N6Q+U56lmkRx09FSXOdZp9IPayzRU3KF1HR4OYVpimkXmL1
dru5i6kI6Rxc+XAaE56LF2uaL6eiNbN6titIvVWVjq69LklF2qY5BXnjmGjd
/k4pRYqKrD5kLDIj/bLbzUpCWIGK8tvjVbeR/uLefbtYk05F9/aZiT1kYyLl
+cL8f0pUZMu/UFtN+lHq1yt2lgoVMSMrlq8YwETPDu4PVy0qWqA+dfj0BxNR
FsaFMVupSODZ03tObWT/cH+WVbKdihZPh0UtbcFERsLeZCVdKqLu6b0rSdbT
bZHoO79MqEhC3ufHOrIetVlsXwEzKhL8/OSmLlmvIzt1PTUOUxF+8kFT7xtZ
Hx6D9gE2VJR6c53/YgITKxu3oV1nqCjerY6S8AETTX+Dtzo5kfGKcb7IpGHi
vmiXeqQrGZ/HhP2lN2S97wqkjV6gotifuqVzCZgoTvw9k+hHRWI9O5RXkP3n
5Pkrn8RiqOjvXBZfmDvpn03tn9Y8paLIb0evdDlhQnQMZRo8o6KJiGeY5oCJ
9+eEP/u9pKLzXmdqjtpiYs4j9MtEOhVFi22tHjfERIT7q6+t5VQ0MrfbNVIB
E2c1RHN4lWQ8aHw8UxoTO7FLjkwteb5UeFKROCa63TblHmyiorUBiyMSBTGx
wS03r7iHigwTJvnvDHGIMpe6gpR/JO8WPVCUQfb/dVsKy/ikkNWBhU2fUzmE
x0hUYZ+gFMp+NH0z6iWHkHGxK2KKSiGF0RcXWVEcwt55sDhMRgodpJRrHL3M
IebOLpT4akghsNrPZ7mDQ2icUas0PiGFSj9w+qLfsYn2swz31FNSSOX6l0/e
SWzivgtVYrmjFForY3ZcL5ZNDJ6bNatyI+cbkxwj/NnEC9/yX2a+UiiK0cHS
s2UTso+c2ywjpdBo3Futd4JsYiHn7cjxn1LogXK3oaz+CJFGxAcXVEuhsSZN
7vEtI4Rt4WN15XoplDNrExCxZoTIKrni0f1bCklvPer1TXyEuFC7f+L0gBQy
PeLkr9kyTPT3D886CUqjvxwe/YjbMFFFWbfUa5s0Mn21L3e5/xBZX66DsTul
kVnHuP7wpSEirSStpBCkkaKEyZHPZ4eIB74bb0sYSKNpCLOgmwwRxn1b/r01
l0bih9fHqlKHiB9ZurjLWRrd6N8TsuXJIPHtuFXdwThpVBnIrvJJGCC+pt2M
XScogxZ9/w+KbvQRwsYW8pHCMkjscNM/E7c+wmxQJZpfVAZ93ZNpV2rTR/Sz
fkY0SMgg2kYZnfuafQQ1WvaRH51c3+M9Y9bTSzjfSrlXv43c796WW116vYSC
dYOXr4cM0iBWvr4x0U1c4V97sKJNBi0oce1l13cSoq2X97plyKLYCeNVx481
EL0vlcLifVegKzsme/3CiokwVblFWRZyiCs3GiXY+hpCYhxKTjDlEd9YlbuZ
TxXYhB2rFOuXR+OalRs6HFqAuzuJF5+ngNILstWXnusG36/xt4oLFJDFLs6x
f7e7gW9TzLLBYgXEmX51ozuqGxYzHiptKldA3fb2F4Pyu0GG572vuFEBmcZ1
FO4V7wHNVOPogb/kPM3dyu1ND7hJT2hvZCkiy4+n/ko09sJYEKfQYrUiwmIi
h50Ge8FLYND48hpFpH1XSSNzthd8cdvxIg1FNGoexFzF7IOgspJ7FjsVUa/P
vkI7xz5Ivhrb5GOhiC4/fR26daoPunv1vAvvKqL7vG+dmosHQC++MmFtkCKK
/TpmpiY3AM+sbX4+eqCIzIKFd0uqDYBd+Tnlk+GKqMeMczH5wAD8fv+sQvCF
IqpyknkhED4AtVfmmXvyFFGWWfnto/RBKJTMLiuZUERyO8I3G7OGQKl8z4QG
VxFdaReTnts0BH63a+hRs4ooKMtmPEpvCHSmBy44CtBQsuuwb/SJIchulaWL
SNCQkzr/pYy4IUh/5XXeSI2Gnu0I5xlKD0PCro0KP0/QEDV1+aW48WEoPCB6
a/YUDXm1FD3mLQxD13/dQ2scaWj88Nc5PbERYN0Mz/Z3o6FJOavHz1aOQOJ3
3hF0hYa++AWN3Tk8AkmmhVEfw2hIXn3LhbH3I/D9eCxfVyQN/VT9HqqeMwJ9
5zwdJWJpiH/922vWJSOwOmy1tutzGkoM8Hzj1TYCL5sCG1en0dAdOeHY+iVs
SD5xSCamhIbsCjY4MmzZUHp+3bXSHzR047fstc0ObBi4JdQ39ZOGmloOz2t7
sEH15edPh+ppqLqyeuWS22x4PaRgsayThuJna2y+v2HDmws9j/1maMggTmg8
Z4INqXe8JM+sp6PdlZV9Zy5zYGTnsZt3NtCRSszRUe4NDqyb2D3+QpOObqfY
elwK4MAbe6lfHdvoiF2z7evOKA4kw8coGwM6um9bJzGQwYFE3l/Ggf/oqMea
xsgb4kDP+6YQF3s6avv9+cbKUQ6wHPP5g07T0TlrQsZ7mgMJDQ+7S5zpKOvC
45I+QQzxH9Vf6XrTUe6ZoupOBQwxri7qm0PpyP19X4/RXgy/Vx6OPxRGR9+O
KvndNMEg17pD4nwkHWW8D1j+yhxDlNHSsbSndOQfkjabaYshXOXNJ9U3dJT3
ubFh1B1DfXvoasNUOiqE5eUhnhikInwiT7+no2fdS54p+mB4tGifT0ImHfF/
ke6euYEhpLN/p2IRHW1nKQbXPMJQHVWVuv07HTXJCRg2RmAQP/iZfqSMjoLi
9KrKYjA8yPPni6iiI9OgOF2vBAz3Y1cVi7fSkerNg6697zFUmC/brP6Hjgx8
oo+YZWBYKjqZZNxFR5kedfxvPmMI9C6+GzBAR6nRvb5KeRjuWpzcLzhJxntS
sk31B4YE01bb01zyvJv7Erb8xJCzz8KtZJaOxPH7l+urMYztMgwNEmAgo0GT
E42/MIhp5yewhRho+tELycAmDCqbtmWYijCQVaHj5KoWDLar1RqpEgykI2xj
JNeB4RIzccCLykCvTbjpHl1kPuRpM40yDMS5y9L/0IOhZLk47QmNgRa2bW9m
D2DoWnJPfZ7JQPtOpbcPDmGYE+BHx1cy0Jm+atGqEQybpsfsV6oxEN1KvuHw
Xwwmo86e/uoMtJlb4zk5isFxuOfOwEYGUrDct+36OIabvccijTYzkOQPA9bY
BIanfxqSU7QZyCI1ZNOBKQxfmk2zl+9koFVH2A6PpzHU1pWWewADFa5m5Rdw
MbB/6rbV6jHQWXfurmYehiWl2RwtAwayua/Z0TyDgVWoyRe5j4HqGmJeFs1i
0MlJkeQZM5BU8kRIxBwG68xVrKMHyfVHFseb/8Nw4X2cVu4hBurTj66eJvnB
G1kDhhUDTeV7rPKfx5CcGGJ1w4aBStccfvqP5KI4kbPdxxjoaaOItt0Chvao
m5f3nGCgdJb15CuSeY9mg16dYiCDM0K/fpMsFez5VMSRgaJnGxumSFa/y05z
dmagwW0RM///f3rfDYf8n24M5HVFGA2RfOrKnxqN8wzkK4dfFpB8zcu6O9SL
1M9VRuMmydHuNRPj3qTeVXpNaiRnnDUStvQl94vZnpBH3q/qZJHsl+sMZKZS
fH87yUPHdq6Rv8VAbpVJkfFkfIusP2339Wcgv8GkQjaZD4a5unF7AAN9qwlc
tork7cavjqFgBrrSIe+9h8zfYQOme0IIA3W7KQqYkvl1R9F+i8IYaEeDxVtd
Mv+B2ymPHCIZqMA9+AKN1CdJK+hFaQwDfQoLsOki9cxXX/RpbRypb5zE8ZBJ
DJPKU42cRAaKKG769moMgwTNffBgMrn+8ctVkqRf1soOzKS/JeNPWfHiJMZw
fOlv2qV0BgrvtZsqGsZwWeiQRvMnUv8N3pU1g2T9L5SjHVkM9C9Kqqy0H8OP
8dyTCwQDbTixcuP5bgybW5+/vvuTgQ7QCYWPzeR56o7cd9WkH888uqDdiGHk
urphUx0DiVPWTbyux5DI+tqj+puBanhd3mZVpH7O9YwffQzkxJdenV6E4W9O
jNvYIAOtNFr6LjqfrPflJ3Ll2QxUURFU6pKL4XY628Z5nIH0BzZlNmZimPEV
3C/Mx0S3z7jk5CdjGEhyOB/Dz0QWjuYZIkkYGirLotUFmajJO5+n8xxDOjNk
wFKYiSy1Tl90i8bgVKzo/0qMiboXrbzUeQ9D89ItBXvlmKgqYHm03CkM37Wi
B1rlmchYQfmq6n+kH47NiZ9TZCJ+p+t1LBuyv70rtItmMNGNN4Ydf0wx7D1k
Oje4iomCX53Idt1O1luM49agTUwkPXekqWsphpdF5XYMLSbyHWlfly2EIWxE
3f/jZiZihSqtvbbAAQ+dyfoWbSby9y3YWDHGAdWuG+fXARPN+0Xw/Jo4ELUm
NvXnfiaKdR66b/aMAxPjBkm3TMjzXC+rWpG/J6Z5Y0+2mTKR90KJg0EIB4QP
Gd1PMmeizvaE7s7rHPDy5TldPcJEa9rv+S+z44B5lZXq+jNMFOn+LH2nDAfS
ogWZ3Y5M9KW61eiPGAdETr2TjXZiory/Y73OghzI5wovFnJjImWfjzv1/7JB
Qzmzt9WTiTz/ZUoNl7JBzEvqxf2bZHz94byVF9ngCPkxereZKPDEXIGTMxuK
RFwece8wUdqBroWY42y4HFd041QAE4VZ44VsIzYMlpw/vjOE3H+J/dIZGhu+
y9fQRp4y0bL8vcq++SNwPT84an8WGW8HpbdychiG2vLDeNlM5K65V+3jwDBY
zo6HvMphIhf74oJbLcOwbotNgGA+E4WmOPIP5Q9D09vVl79+J+O32v2lPHAY
NkUSR9XqmeiyVmnBsPww9LmO0pdiJtIt/+/pwLohMFGwSPqxUgmZirCEQH4A
onrU84+uVkLOl6dFs0UGoCd1ScuIihL6rpphsprXD74oR0JcTQm9FVb6VNvY
DymnWb6HNioh372ntvuG9YPo+1Hz1l1K6BXH5bHC0n4o2f2Aj2OphNxlz6xu
ZPeCrlvJUckAJfSyJyY7Kagb4hXtV1ZMKqGOq9U8uNcCK4teRRw4qoz2jjOy
Z7dVQcj6wrW1ecro5ZtcKnr1BhzGF9WUrWUhSCnW8t1VTNh/GGMGPGShZ8b1
ztGGDYTLzUNzRqEs1JJf1WLo20B4HcpoFHvMQhkl9Zye9w3EvUmvByERLMQJ
6bMekmsk0rbxZiOfspB48t2vtOFGglew0PDyLQt5R7/LFwxsJkJqxYKLS1hI
P7rS+suXViLmhaujfxkLmTw98pY91Eq88KzU31vOQoFT0clitDYiUyZkpryS
hRwatIQW32gjWm2ojnW/WGhFe8byQcN2QqVbTr+rm4XQjbV+ujV/iA0Zl+mJ
vSz00+DNzwW+DmL7nRbe6X4WIpQ/3DCX6yCMVZ6+HxxiIdlZwUe1+zqI885M
+ugoC/UE7DfY8aaD8N15g5c+zkKvo+d8Nhd2EHeWddV7TpLzufO5yr87iKh3
L4K4XBay7u5VaxDpJBL8Fp3JnmGhPRl6G54odRJvzU7r+c6x0PJtHbzD2zqJ
DOXvNJ15Foo5MuPFZ9ZJ5I2v5i0ssFD1v4rQOMdO4n+7QOvk
           "]]},
         Annotation[#, "Charting`Private`Tag$659297#4"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{16.153061224489797`, 1.4999999999999432`}, {1.5, 
       0.5000000000000284}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {159.8023027815026, -92.62500043839714},
      ImageScaled[{0.5, 0.5}], {299.8844197561337, 176.4285722636136}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV13k0lN8fB/AZJEX2lIRhhGwhFS0+NyIMsossUdmTlBCibCm+EUnWUvYk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           "]]},
         Annotation[#, "Charting`Private`Tag$660072#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVV3k4FV4TtqWyXvt2uZsQQhKFzInsomSJUJbwQ7ZU1pJEsiQRaSEhJAol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           "]]},
         Annotation[#, "Charting`Private`Tag$660072#2"]& ], {}, 
        TagBox[
         {RGBColor[0.922526, 0.385626, 0.209179], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVV3c8Fl4XN7Jl7/l4HiEkJBl1zzUSUkJKkkS2kJAKCdlKRqSioohIUubP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           "]]},
         Annotation[#, "Charting`Private`Tag$660072#4"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{7.989795918367347, 1.5}, {1.5, 0.5000000000000284}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {475.32527569144656, -92.62500043839714},
      ImageScaled[{0.5, 0.5}], {291.7211544500113, 176.4285722636136}]}, {}},
  ImageSize->Large,
  PlotRange->{{0, 631.045945819888}, {-185.25000087679427`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.676432373871625*^9, {3.676432405454009*^9, 3.6764324351475887`*^9}, 
   3.676432576349979*^9, {3.676432606973402*^9, 3.67643261283149*^9}, {
   3.676486398281088*^9, 3.676486438083292*^9}, 3.676488201261633*^9, 
   3.676497140101054*^9, 3.676497433525754*^9, 3.676497602428727*^9, 
   3.676497729802744*^9, {3.676497810050425*^9, 3.676497813906673*^9}, 
   3.6765771751596947`*^9, {3.6765772316648083`*^9, 3.676577270490424*^9}, 
   3.6765773772354403`*^9, 3.6765774484953337`*^9, 3.676577532544743*^9, {
   3.67657756480787*^9, 3.676577600493614*^9}, 3.676601154951412*^9, 
   3.676602878000321*^9, 3.676602924032707*^9, 3.676602972284492*^9, 
   3.676605711594183*^9, 3.676606252200625*^9, 3.676816044447283*^9, 
   3.6768195990633087`*^9, 3.676827867936029*^9, 3.6768348473497343`*^9, 
   3.6768381701856823`*^9, 3.6768418782480097`*^9, 3.676841927302929*^9, 
   3.676842007184445*^9, {3.6768421078388023`*^9, 3.676842128590975*^9}, {
   3.676842168488954*^9, 3.676842213374511*^9}, 3.676842266021447*^9, {
   3.676842335785746*^9, 3.676842360833517*^9}, 3.67686021897477*^9, 
   3.676860730990231*^9, 3.676861161190494*^9, 3.676941671995908*^9, 
   3.676941786177718*^9, 3.676943083068301*^9, 3.676943575954605*^9, 
   3.676943955512025*^9, 3.676944053783701*^9, 3.676944090619391*^9, 
   3.677088287863345*^9, 3.6771821719782343`*^9, 3.677182582952682*^9, 
   3.67718744055473*^9, 3.677201632892767*^9, 3.677203844059903*^9, 
   3.677207282883128*^9, 3.6774634528604116`*^9, 3.6777687918046637`*^9, 
   3.6777690337239037`*^9, 3.677769311883356*^9, 3.677769388232547*^9, {
   3.677770451079006*^9, 3.677770477924716*^9}, 3.793322209444277*^9, {
   3.793851491778661*^9, 3.793851501211172*^9}, 3.8232276424679832`*^9},
 CellLabel->
  "Out[1785]=",ExpressionUUID->"54c83f86-7322-4de8-b9ce-a58ad7e175b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"SG3", ",", "negT3", ",", 
    RowBox[{"Limit", "[", 
     RowBox[{
      RowBox[{"s", " ", "negT3"}], ",", 
      RowBox[{"s", " ", "\[Rule]", " ", "\[Infinity]"}]}], "]"}], ",", 
    RowBox[{"Limit", "[", " ", 
     RowBox[{"negT3", ",", 
      RowBox[{"s", " ", "\[Rule]", " ", "0"}]}], "]"}]}], "}"}], " ", " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"=", " ", 
     RowBox[{"u", 
      RowBox[{"(", 
       SuperscriptBox["0", "+"], ")"}]}]}], ",", " ", 
    RowBox[{
    "the", " ", "initial", " ", "value", " ", "of", " ", "the", " ", 
     "output"}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{
  3.6764976874463654`*^9, {3.6764978290039682`*^9, 3.6764978339685163`*^9}, {
   3.6766014797666407`*^9, 3.676601495267418*^9}, {3.6768297116287317`*^9, 
   3.676829712385936*^9}},
 CellLabel->
  "In[1786]:=",ExpressionUUID->"934d3e82-6e2b-4222-b5d8-2d09f3a1348a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", "Kp", "+", 
     RowBox[{"Kd", " ", "s"}], "+", 
     SuperscriptBox["s", "2"]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "Kp"}], "-", 
     RowBox[{"Kd", " ", "s"}]}], 
    RowBox[{"1", "+", "Kp", "+", 
     RowBox[{"Kd", " ", "s"}], "+", 
     SuperscriptBox["s", "2"]}]], ",", 
   RowBox[{"-", "Kd"}], ",", 
   RowBox[{"-", 
    FractionBox["Kp", 
     RowBox[{"1", "+", "Kp"}]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.676601496115355*^9, 3.676602878039474*^9, 3.67660292408062*^9, 
   3.67660297233599*^9, 3.6766057116388597`*^9, 3.67660625226964*^9, 
   3.676816044567515*^9, 3.676819599232201*^9, 3.67682786802349*^9, 
   3.6768297128690443`*^9, 3.67683484742375*^9, 3.676838170245132*^9, 
   3.676841878303522*^9, 3.676841927345592*^9, 3.676842007235425*^9, {
   3.6768421078978167`*^9, 3.6768421286304893`*^9}, {3.6768421685603437`*^9, 
   3.676842213413128*^9}, 3.67684226606958*^9, {3.676842335829458*^9, 
   3.676842360881865*^9}, 3.67686021907213*^9, 3.6768607311100073`*^9, 
   3.676861161306089*^9, 3.676941672109432*^9, 3.676941786290638*^9, 
   3.6769430831789627`*^9, 3.6769435760817738`*^9, 3.676943955632679*^9, 
   3.676944053911097*^9, 3.6769440907516403`*^9, 3.677088287906999*^9, 
   3.6771821720315447`*^9, 3.677182583000545*^9, 3.677187440599498*^9, 
   3.677201632958376*^9, 3.677203844119422*^9, 3.67720728294945*^9, 
   3.677463453061728*^9, 3.677768791874076*^9, 3.677769033787162*^9, 
   3.6777693119316397`*^9, 3.677769388304174*^9, {3.677770451144635*^9, 
   3.677770477999645*^9}, 3.793322209554811*^9, {3.793851491809122*^9, 
   3.793851501241064*^9}, 3.82322764249583*^9},
 CellLabel->
  "Out[1786]=",ExpressionUUID->"32c4245e-4908-4a8d-808e-092f6c62c419"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"SG3", ",", "negT3"}], "}"}], "/.", 
    RowBox[{"Kd", "\[Rule]", 
     RowBox[{"2", 
      SqrtBox[
       RowBox[{"Kp", "+", "1"}]]}]}]}], "//", "FullSimplify"}], "//", 
  "TraditionalForm"}]], "Input",
 CellChangeTimes->{{3.676829951177149*^9, 3.676829970996765*^9}, {
  3.676830007798738*^9, 3.676830014472374*^9}},
 CellLabel->
  "In[1787]:=",ExpressionUUID->"9bbea276-e2f4-4a0c-a6b1-ad9de9cd3ccd"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"Kp", "+", "1"}]], " ", "s"}], "+", "Kp", "+", 
      SuperscriptBox["s", "2"], "+", "1"}]], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"Kp", "+", "1"}]], " ", "s"}], "+", "Kp"}], 
      RowBox[{
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"Kp", "+", "1"}]], " ", "s"}], "+", "Kp", "+", 
       SuperscriptBox["s", "2"], "+", "1"}]]}]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.676829960141459*^9, 3.676829971489717*^9}, {
   3.676830009491211*^9, 3.6768300158950443`*^9}, 3.676834847509598*^9, 
   3.676838170324628*^9, 3.676841878423154*^9, 3.6768419274440117`*^9, 
   3.676842007327519*^9, {3.676842108026497*^9, 3.676842128768153*^9}, {
   3.676842168731888*^9, 3.676842213492959*^9}, 3.676842266123623*^9, {
   3.676842335990177*^9, 3.676842360944291*^9}, 3.676860219158168*^9, 
   3.676860731169012*^9, 3.676861161360179*^9, 3.676941672197332*^9, 
   3.676941786352367*^9, 3.676943083267981*^9, 3.67694357621129*^9, 
   3.6769439557214727`*^9, 3.676944054000719*^9, 3.676944090815361*^9, 
   3.6770882880390043`*^9, 3.6771821721186867`*^9, 3.677182583090024*^9, 
   3.67718744068645*^9, 3.677201633053627*^9, 3.6772038442125053`*^9, 
   3.677207283040594*^9, 3.6774634531484423`*^9, 3.6777687919624023`*^9, 
   3.677769033874889*^9, 3.677769311990656*^9, 3.677769388366849*^9, {
   3.6777704512001963`*^9, 3.677770478061067*^9}, 3.79332220960688*^9, {
   3.79385149185893*^9, 3.793851501277225*^9}, 3.823227642543159*^9},
 CellLabel->
  "Out[1787]//TraditionalForm=",ExpressionUUID->"45e0c561-00d1-4f21-9277-\
dce0c75f7c90"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"SG3tf", "/.", 
         RowBox[{"Kd", "\[Rule]", 
          RowBox[{"2", 
           SqrtBox[
            RowBox[{"Kp", "+", "1"}]]}]}]}], ",", "d", ",", "t"}], "]"}], ",", 
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"negT3tf", "/.", 
         RowBox[{"Kd", "\[Rule]", 
          RowBox[{"2", 
           SqrtBox[
            RowBox[{"Kp", "+", "1"}]]}]}]}], ",", "d", ",", "t"}], "]"}]}], 
     "}"}], "//", "Simplify"}], "//", "TraditionalForm", " "}]}]], "Input",
 CellChangeTimes->{{3.676829758925089*^9, 3.676829768180489*^9}, {
  3.676829800700638*^9, 3.67682987378516*^9}, {3.676842063435792*^9, 
  3.676842065891087*^9}, {3.6771823598973*^9, 3.677182363001706*^9}},
 CellLabel->
  "In[1788]:=",ExpressionUUID->"870fe140-c778-420f-848f-fddc466fc64f"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"t", " ", 
       TemplateBox[{
         RowBox[{"t"}]},
        "HeavisideThetaSeq"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"Kp", "+", "1"}]]}], " ", "t"}]]}]},
     {
      RowBox[{
       TemplateBox[{
         RowBox[{"t"}]},
        "HeavisideThetaSeq"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"Kp", "+", "1"}]]}], " ", "t"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Kp", "+", "2"}], ")"}], " ", "t"}], "-", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"Kp", "+", "1"}]]}]}], ")"}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.677182363434547*^9, 3.6771825832246*^9, 3.677187440816702*^9, 
   3.677201633185931*^9, 3.677203844347005*^9, 3.677207283182535*^9, 
   3.677463453279172*^9, 3.677768792099187*^9, 3.677769034006783*^9, 
   3.677769312126101*^9, 3.677769388503982*^9, {3.6777704513274508`*^9, 
   3.677770478185068*^9}, 3.7933222096627617`*^9, {3.793851491933799*^9, 
   3.793851501351603*^9}, 3.8232276426174603`*^9},
 CellLabel->
  "Out[1788]//TraditionalForm=",ExpressionUUID->"f8c4c833-e488-4d97-ab72-\
034afd8aaa69"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqs3", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "t", "]"}], "+", 
        RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "Kp"}], " ", 
         RowBox[{"y", "[", "t", "]"}]}], "-", 
        RowBox[{"Kd", " ", 
         RowBox[{
          RowBox[{"y", "'"}], "[", "t", "]"}]}], "+", "d"}]}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], "/.", 
    RowBox[{"Kd", "\[Rule]", 
     RowBox[{"2", 
      SqrtBox[
       RowBox[{"Kp", "+", "1"}]]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ysol1", ",", "usol1"}], "}"}], "=", 
   RowBox[{
    RowBox[{"DSolveValue", "[", 
     RowBox[{"eqs3", ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y", "[", "t", "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "Kp"}], " ", 
           RowBox[{"y", "[", "t", "]"}]}], "-", 
          RowBox[{"Kd", " ", 
           RowBox[{
            RowBox[{"y", "'"}], "[", "t", "]"}]}]}]}], "}"}], "/.", 
       RowBox[{"Kd", "\[Rule]", 
        RowBox[{"2", 
         SqrtBox[
          RowBox[{"Kp", "+", "1"}]]}]}]}], ",", "t"}], "]"}], "//", 
    "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ysol1", ",", "usol1"}], "}"}], "/.", 
   RowBox[{"{", 
    RowBox[{"Kp", "\[Rule]", "1"}], "}"}]}], "//", "TraditionalForm", 
  " "}]}], "Input",
 CellChangeTimes->{{3.676830244541691*^9, 3.676830286212282*^9}, 
   3.6768303307119827`*^9, {3.676830675267845*^9, 3.676830683514049*^9}, 
   3.676830736714744*^9, {3.676842070915887*^9, 3.676842074298871*^9}, {
   3.677182370362712*^9, 3.6771824074309397`*^9}, {3.6777688098767147`*^9, 
   3.677768825458035*^9}, {3.677768933174461*^9, 3.6777689645907707`*^9}, {
   3.677769003427041*^9, 3.677769029052013*^9}, 3.6777690594248466`*^9, {
   3.677770434354707*^9, 3.677770467277891*^9}},
 CellLabel->
  "In[1789]:=",ExpressionUUID->"877dc4e4-17ff-4c90-9dd3-fc5ae95f9a3f"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", 
        SqrtBox["2"]}], " ", "t"}]], " ", "t", " ", 
     RowBox[{"(", 
      RowBox[{
       TemplateBox[{
         RowBox[{"t"}]},
        "HeavisideThetaSeq"], "-", 
       TemplateBox[{
         RowBox[{"0"}]},
        "HeavisideThetaSeq"]}], ")"}]}], ",", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", 
        SqrtBox["2"]}], " ", "t"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SqrtBox["2"]}], "-", 
       RowBox[{"3", " ", "t"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       TemplateBox[{
         RowBox[{"0"}]},
        "HeavisideThetaSeq"], "-", 
       TemplateBox[{
         RowBox[{"t"}]},
        "HeavisideThetaSeq"]}], ")"}]}]}], "}"}], TraditionalForm]], "Output",\

 CellChangeTimes->{{3.677770469790357*^9, 3.677770478281028*^9}, 
   3.79332220971119*^9, {3.7938514919781847`*^9, 3.793851501400772*^9}, 
   3.8232276426610126`*^9},
 CellLabel->
  "Out[1791]//TraditionalForm=",ExpressionUUID->"f5326129-551e-4392-a5c2-\
ee67110a1322"]
}, Open  ]],

Cell["PD control does not reject a step disturbance", "Text",
 CellChangeTimes->{{3.676256123319852*^9, 3.6762561340117064`*^9}, {
  3.676256527464588*^9, 3.676256537807025*^9}, {3.676390134403613*^9, 
  3.676390134811151*^9}, {3.676432290911524*^9, 3.676432291046063*^9}, {
  3.676518622684082*^9, 3.67651863874605*^9}, {3.676834353011854*^9, 
  3.676834359707809*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"9d73bba5-da20-4880-bbec-792a380ec867"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"y3c", "=", 
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"SG3tf", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Kp", "\[Rule]", "1"}], ",", 
           RowBox[{"Kd", "\[Rule]", 
            RowBox[{"2", 
             SqrtBox["2"]}]}]}], "}"}]}], ",", "step", ",", "trange"}], "]"}],
       "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
   " ", 
   RowBox[{
    RowBox[{"y3d", "=", 
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"SG3tf", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Kp", "\[Rule]", "3"}], ",", 
           RowBox[{"Kd", "\[Rule]", 
            RowBox[{"2", 
             SqrtBox["4"]}]}]}], "}"}]}], ",", "step", ",", "trange"}], "]"}],
       "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"y3e", "=", 
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"SG3tf", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Kp", "\[Rule]", "9"}], ",", 
           RowBox[{"Kd", "\[Rule]", 
            RowBox[{"2", 
             SqrtBox["10"]}]}]}], "}"}]}], ",", "step", ",", "trange"}], 
       "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
   RowBox[{"p3c", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y3c", ",", "y3d", ",", "y3e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.676834404148059*^9, 3.676834465700632*^9}, {
  3.6768345060244923`*^9, 3.676834520470763*^9}, {3.6768398912942944`*^9, 
  3.676839970661489*^9}, {3.677203820149604*^9, 3.677203823572308*^9}},
 CellLabel->
  "In[1792]:=",ExpressionUUID->"9461ab1b-7c58-471c-b45f-5cb8f4a15df8"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV1Xc4ll0YAHCjZO/1Wu+ShFQ+oVLnljRUklVKioTKyEpFyM6IZKUhUUJI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       "]]},
     Annotation[#, "Charting`Private`Tag$662298#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd13c8V98bAHB7r4+9fYzIiEik0nkqlcwSDVlJSSSUorSMRESSlVlkRCgq
kuz9+VyVrPRVmUnZO/md+/vn3tf7de49zznP89x7X1fe+bzVKSYGBgYKPpDn
lOvObNoud3cwMJQOzLrqG9Z9opodobqh9GjUfe7Zpx1rDZVBVKo/YiYsTobF
zOzgi3lVxNUdiLqJOKW+cVaUUhUpx0oNQ5esLjRHnxFCGhMu99Zco9Bw+iX/
hE2y6Ctf6r+/XTFIzPBVNGfOOqT0lFNveeUh2rVb7+G+4xuQh6HvuQW5RKT5
qMrwj9gm9LLjW+bs7mSUYFt4S4qyBS27m/VNuaahWV5WMZd4Q5TO2Be2sCcD
5RdroZsdO5ER7f66+a7HKCtww5Swwh40mrCvetYtE209/HHk/ktjFOGyajez
koUutkoWSN8xQ59WzsROyuUiJr03nP5XrdClRtmNE8V5SHof8V9dozWSfNDR
+nt3PpK9mPp6ZNMR5KwGzL9cC1H5Jmc1gbN2iGnlCjEbUITKNaKfG21yRB3f
bGRm9xSjyFuX1o7wnkB++dxl010vkGPtHwFzeRdkEjPMNp3+Ej0NybBdX30K
SftVW0+5laB868ejNuddUdXuy5MTK6WoMrI4eXDuLGL/8kPlt1wZSvh2apft
IW/UXfXOd3y0DFGZtpktHfNBeU8Tan8Vl6NZ27M7WV0vIAsfC8ex3RXI7HFm
C1usL4rjLI8bcX2P/hFvuU30ryDB5Camqa4a9HaPxjVZ40C0wvcq12t7LZJ5
/L24aikQDd56cmAyvRb1ltDmJwuC0CvX66kTbnWosHymq0MmBNlu0t36Z6Ue
6cRYbU+WvIMyWtK8f8k1ox6W7dkbb95Dswmlav0RzSh/x0YDnzNRaK9r68DH
pWZk9YSVI0Q1Go0zL9iUf2pBNjneBmFi99EWQ4utYaFtSC/2+FARwwPUXviX
SWWCQHryAQWazPHoRouGibbjJ8TXFbqTOTcNPS8M++Kh2Yv4GhS5ZyxzkSv6
kDjuM4DSHEXngmdKkeeQ6kDJ85+oaoJyrSGwEn1z6OGobv6J/jyuFknJqkSH
uu9o0gZ/ogI9wt6+qRJtaR3xH5IcQ/SNVjFJvO8Rc3GWgGjoGOqhlFWxxL9H
CQHyOy47/kL/LkXTaq2qULWQRKKBwG/00YVqfvZoNeKSD1bp3zKJuP99cF2H
alHT9vta1/dMonALt5REs1p0+2iqvozVJPK1HOVltq1FTNFv9h13n0Si37c9
Kb1Yi5b/jbt2pUwi3rJ7bxJza9GvPpscgmkK9ZczHnOg1KG2BBXVqrYpxHKQ
P2uouw6Fl+hqO/ZMobhdTLwsQ3XIuH2nwb+hKfQ2uWZcbKoO1bHb7d++NoVO
ZxjJUjnrUcWlaLc32tPo/OfpuBdb6lGB9VJuUdw0cu48rzbwsB7dE2hVy3Ca
QQr0hD1Rxg2oTF+m1MJzBi0bmVw3tW5Agw7n0d+rM8gkp/7PimMD2lYgZH0k
fgaNJjdFG1xuQKP77a7x0meQgWRdxPqsBrQ76Dfhv20Waex9w/TlXwNanOP3
tRKdQ9uKvJirchuRoozz2priHNL+92qSv6QRWRiVhBVozyF/0fI/1pWNKCvm
aCqH+Ryqpf8yqPzYiKy0Mhorg+ZQ+NXiLr6VRlRwRkdSfWoOveddzHy+vwk5
f7F+z9w2j5YqNA7I9jchrkffz3n3zKP9tq4zsyNN6IWtp3T/8DySlwtfqJ5s
Qsy9of7ljAuoXycCEFMzyuwu3+Stv4CKudKyG5Wa0fBnas5/jxfQasWAreiZ
ZnS2fTy6zH8R3WhzHu8faUaC0f5IJXQRRT9dMrg/0YzKLdn+xMYuoidBy90G
C82Im5Az9SpcRFQwUfVma0H5NCtWlaFFlPvg/pCfUgv60/LGP/bAEvLwtnea
cWhB3vXBzudVlpEpi71PE60FyQ7uZZvftIz69uv/XcPPSSsTZ14ALCPWlQ8N
G3tb0DqInAo7toy2+hnrXR9uQT3lD29m3l1GJsUbFZr/taCdRU9TeyaWkZve
3V1Kmq2I8qipd/ebFZRurrBb/E4rqiwLv95St4J6vH+pB0W2IvduM4WDH1bQ
VAkb32hMK6oX+eDmMIbHL3l2pKW0Iv/onkU/6b8ImNNYm160ou8hY6LPb/5F
HjynOte+tKJiL55D4vtX0fF0yZRNam2oLUnIv+DwKpopoJaba7Wh4TrJtF0u
qyhiS3/kCd02JCmh+svjxiqqZTx98dKONhRcvSeounQVbeGvWLKxakOHBW+8
PKvwD92u8imd8mtDyy+nhN6t/ENn6YpuTdVtSPi/RQMrzjW0z+LW7LqGNqTJ
weA0IrqGhNa1MF9vaUMn7fjyKTprqD7foUHmE14Pi7rR6TNrqGh1yw3pwTaU
auNykf/zGtJ/bfNFipWGMq66j208wgDaympcprtpaGMV52KoPQM0uP/Vqt9L
Q1UsOaz9JxmAP15Uc5sJDX2LHKRGejHA0fm0OsmDNCSbbn/kZxgDMBle/Jzj
QENJdZZ1GRUMkCp87xiLPw3F8OqmCiowwi3XvaJdeTSkYPXxmdt6RhipaU/r
KKCh4jivsipNRqgtzL5DL6KhdrmCDs9tjDC7tv3O61c0xKejzN1qzQgVTZRC
hxoaCj8s7hcUyghXipEUaw8NBab9PTg7zgj3R78K05jp6MDGN97qM4xQdfec
8kE2OpKtvnDfeYkRdiT+1PrIQUflP8ba21mZQPqx85ZWXjqaXtdjWSDLBDK6
V24kitGRc36p+ekDTLDd/RQ9V42OdpZ57u9+yQS/DvYdK7SgIz4TNTf+cibY
d+VhcfcBOurrHbqzt4oJcnVVXdes6Mjvr11TSRsT7DlntGh0hI6KkOm++0NM
UGp+kLnYkY6oDSp7TMSYwdeI0OH3oiOGT9+g4gozBCulZC7co6Pgn5UZV24x
w1vYeXk5mo44GVKYDO4wg+Su1cTlGDoS3HCsrvQhM7Sl5/VNx9HRutAP+wqL
mCE0xLa4NpWOTLbVWDweZobTOTwePwvo6MGTJ3Z3rFjg0Ob5lOMtdCRefuvd
3mMsYCvPns3XRkfJ7Y6yrE4sULzE4/KeRkdPV6W+3TrHAky63qySH+jozZHY
k1fvsMBvrcnNJV14v9whZz0rWYDL1L39+iAdKV887WetxgqWftdjb/6low1b
+w+lbWSF4UPR/F2rdKTLcFRrTA9bxapTfY2OdkXsH76xmxU6S3kt2xkJ5JCp
Yf3MjhUOWwUos7ITKK5jWospihV+dcxvplIIxLr5xkjhDCuEu/G8VFUiEM/K
Qs3yEiskBa5eM19HIMFqr9Q9DGzwZ0D043llAlHNnW2+8LABE1u/dNF6Am0/
taeWTZkN1C5FeMptINDFh9xp9kfZgMc/Mbp8M4EG5+IPc79jAyfTFz1/9hDo
8c5NF77WssGpAwW/V/YSyDGSHlXYwgaL11XusBsTqFeJtflQNxskhPkdlTQh
0IdDPtuSZ9jAIS87RdOCQJXFZtQNauww0MBzQegwgeLPMY5ZxLOD0aOxM19c
CGRdlswmn8oO668/W644hdfPukVxJpMdmtpvm6ecJtC9ZE+7+Bfs4HHW0dD2
DIGCW7/Q+2nskDNj61vvTiAv1VcvvVg4QLNwqdbZh0AmQ2evxXhzgKdRV1/t
dQLtvaaYb+THAbeeJhpdu0GgXSJ9vfPXOaDLZ2fu5psE2rrHfMvxCA7Yzdvp
+eQWgdSytGYUszlgNUVJ8EIwgbhPzZ4p7cP3p0b9HggjUNvgNevufZzQ921D
vnAsgZoC9ILCLTjB7lGVfhF2nfBE8XYbTqjqShs1eUigCiMn/gxnTlA0En5/
LY5A+Zm7WtyuccL4eKhTTwKBIl3YYeUFJ6gucl5wSyGQxWC0uqwsFzy0Szee
zcLx1Ac77JS4oGWo+tu5pwQyvaB//ZEaF5gK+HUPYxsz/dcuro/HtT7+7MzG
+6OqXxI6wAVMIxF5hbkE2mxXX8URyAX3jOxsjAoIJN2xZDMzxAWvA4PC1l4S
KEnKfE17nAuy/qNGny4hkMTJ9ByvaS4Qoqnw0bBFp/eu/P7HBdzp1AsJpQQS
EIhNHxXjhhsdt2bWvyYQs5nmr6/7uUHaT85Fu5xAY7XON5sKuIHBwDl88D2B
5O53n71Xwg3cMpyyu6twvR0sbKzfcsM1qrxqBnblooHatyZumAiNzTleTaCY
DZSOhQFuOCCV4dRSQ6Bt8e9VVCR54OsU5XBUPYEizkoTIbd54IK2tlFFC4Gq
9WPKTCN5IOiVrhJ3K4HmWTgyKbE88O1hyv1j2E5pM34pGTxQoL9RbA5bt6NF
obSCBxI7LPqVaQT6auh/aXCaB8bW80z7EgTSpHTK7HbkhbJXO3UaPhFoOHI4
8OEpXlDhEI5k7iBQCtfCyIg7LzyMOR4L2Dws4i8i/HhB/KtkXhn22PyxvZ33
eYFXg2Mt+zOBsvq+errV8YLn16w83y6c/5yh91GqfJCkbkvv6iVQh9K80g8t
PqDVHwvm/kKguxls4bp6fGCxVDWzA3s5ScW6Zxcf1F1XYcjC7o50G1Ww44Oj
W/91n+sj0IMLvwVe3eODb2rS3dNfCcSF5k70zfDB5u2Cl9q+Echv53qOV8t8
EGzWm7mCPbz7+PMoRn7g7bkaqfadQDXG1cu7+Plhx/zHyFDsK1aRD3LV+GHL
hts2O34Q6NepdfWXTvDD1T/Zh9MGcD9G2KynEPyQmPmzQXsYPz9Rd+hjn/lh
muXXr6PYOfffXqzr44fsgLOdN7CD4+SrL4/xw12jjatt2LLt8xoTTAKwrDeR
5DJCoM6emnobWQFwyV92DBsl0L7ftgsKNgJgWL1i8WyMQKnCQZ9uHBWAbz+c
1FuxZ7c9K+w7LgA+h7u7x7DTw1dc45wF4JofS47qL5wvleRuTi8B6Lt7TTYL
O9/5a9lkuABI8lplPRjH/dvtGFBZJQCHb3wZOPCHQKfXQo9K1QnAbYswJ3fs
CuUiXb9GAbAOkX8Vgu3my/Bbmy4A45Th8TLsGsEM+6wvAqDEEHOPiv9LLpr/
2BExLwCaS+wfhrG7a1wYbTUo0G7N0Hh0ikCTO3slr2lR4Je+lOU5bPZqS910
HQqENA2W38LWe7/VdXgLBaKvUnbkYce+FaD57KGA51jh/BK2ZUlFwl0HCuTM
z1vGThOoIUt447toCvxWdEgqnSHQf0rh+789oECX4de+Buy5J2vOzPEUYD1w
mb0bW+nx2MP9KRQIHg4TWcYOTK1a+ZxLgZLFcXHDWQLtiPdo/FNDAeY3zzor
sUvv1DlQ5ygQxpa9WDyH62nSKh66SIHtDluKq7GTeD5+/L1CAXUHYasP2Dej
+/e+ZRKEWwvIfBLbLGFZ87CAIByZ89ywYZ5AP7I3rt1VF4Sbk+9LHmPzNSan
LZwQhA6hk+XXFgjEGPbkmMMpfL3D0Xfh2LMmeUL1ZwTBUC05Px67h/46NOa8
ILyoCT1QjJ3Z+fH8hmuC8MF+a/EA9tZhDjiZIAgx/ucmjRZxPVl9v9HpgrBz
6cT6ZWxJueaulQ+C8NKtezPLEoHoW2SI9Z8FgVuRezMftp5H/bvAL4IQpD/N
oYDN9knkkd6oIOgc+8axHzsr/ZVNKqMQePNwXInFHty22HJOVwgGEr9nyy8T
KMHGrCZJXwgWH1IE1bDNzqeXNW4VgqdCLl462CWPjXPkdwrBiO07zt3YwZyJ
IZ/NhcBqjLv4JLZSlwEYugrB9s7z/z3GPulztZQnSQgkrNaJSazg9en8V6qa
IgTV26XW5LC5puHV3nQhWNnm+lUZu8ib7fXNp0LgWaB3TRf7r9f9N7MvhODs
BxVTS+y489lv+1qFwL5hXj0Iu9njU3X+qhCIeOk4DGIna+jVNDMIA0frbbUx
bK/xhJphZmF47d70ZwJb1MOhlsolDC92bXNcwXZ2/1kXKyoMrVlz3yh/cTy3
tcYALWE4peflZYit5apONzshDN+1hFmjsP9zkztf4CIM+bsKTGOxIzyEBPjO
CIONq2F4IvZP75WDhKcw7Mj3nXiC/SSg9fPBAGGwvJd7/A22WIz718PxwnCR
aWtDP/ZaxbNxJ5owvDWmbVZdJdDz92mR1e3C8EjFIWYDtl3NA02FDmEwemM8
qo1d1njVa6BXGCRaD9zcin3ho+nsqVFh4K/Y7GyKPTLya+UsswhMzCbNuWMT
ghrcvgYi8FhAOCUHe8e5cz8fbReB4eLapWdkvMbnjTVIBH4LFR0sxL4XoB0s
sFcEBv6znynFNhvWW31mJQKia5//1WC3lO2c+OEuAsr+5tv6sOudjnw6kCoC
6pcoPtz/8PfobULx5QwRePVZfhcfdqZIb1Rqpgh8sVHno2AHt9iZjeeJQK87
JIli79J1rg99LQItPZQgeewq9nOvK9tFIE50f7Ie9tvngY80mEXhh3CBsAM2
m5mNZDybKHC4yWY4YR/8qZLIyCUKFWwZqiexRxRpcZ0ColD4bELzDLZQoljM
TVlRmPfdz+2D7R6Uf6fDQBSSv2bxh2BLHe30DfAShS8hbzxysE/P5cwOXxCF
gP21IXnYxTFXLxy8LApV7+4+ysfeR6N6K18XBaE97u+KsC/scvdovysKwrkr
vW+wWzUYTipli8JqvVhgE/ZVRrUDbV9F4em21+lD2MNG3N3K30XBS/SX1Qj2
gTvjjrcGcbz+20w/sZX4C8/r/RKFrTqstuPYbdK6UemLomDzIGRsGlt2yw76
RSExOMfzJXYNu8bTykxmvxiwy7Criq0RSOPFpo7LZmKAui5HiWPHzQnbfbQU
gyeaTTMS2O4BXe6hh8WA01jglTS2cLjd3amTYuDYfVVeAft01umW+uti4Hvq
VpwGNlffFWPPEjHYxF3OB9h6l3N5o16LQVJvq8JO7BOC3R8Ly8VgVe3Q5l3Y
b4w3209ViQG3dKuNETlf6YT3RZoYSG9JDTbGrr7n8ujKsBhc/f7s0YE18ntu
8ee2uDi8q45754id2RfwMltKHFYdnTKdsInLz/yaZMUBNfaHncBWfs7BzLVO
HAyA/eBJ7E+StWKR2uIgyqHRfhpbc1Z/5wMTcRjMcX5wDnvoqXxsWoA4XDl2
0OAK9njw9yXmm+KQHevNdRV72jnD8UyQOMRImveSZpCTV9cOFweRZMNL17Al
46k1NfHiIBRhkHYT+0Co3OTQC3EoW7f39W3sClcZM42f4pA4w8kbg12752tx
9Lg4nArRKiPdopgiNjchDhdqjV0eYHf1Sw+8mxcHfSe717Fk/CPSVyxZJOBs
v87BeOz1xlI5PnISwM47Y52MHbtegqXMRgKMf3plZ2HbOShnDxyVAKbOFPWn
2Eqxm0z47CTgsBd3IemSNfPok84SMJBV8DIbu6MzUJrvvAQEyemU5GILhYzr
nrwjAYtLKg8KsGO+vz/F+1YCRgsG6CXYtmI0ji2VEvD3soRhKbaCee8z52oJ
8JB7nkf6xZvZqdeNEvD8xkLQK+yPUarXnTvw/Z0KWm+wKTsexL3+LQGP3FLP
vMWOTjrdeIIqCYsyOzyrsS9fCrwQoCgJrMs6TaQdrFLl4pUlQaUgR76G7F+u
zsttGpJgPi/+iXSz/571+gaSEPdEZmMdNtMxpTAeK0loGtr2qQHbV+yHyesg
SdAcnqhuJfMzszr/4bYkfFlT4m3DNiIknoyHSULp199HSAuGHlyRj5aE+N2G
46Sfz1c9i0iWhOB9A/x07NHPaTzOpZJQ/Kx9dzuZj1h7Os+IJNQrujh3YEu/
5JJyH5OE8uqop6T7P7x2bf4tCQWqVmOkXfgFGW/PSsLBOylen7E9wxs2rTFK
AW+nvV8nduBNrcQpaSkYdFi72I2d68Ho0mklBbWBj5T7sD3uPi/SPSwFfxiK
HEhr5h1fjTkmBZaERxzpFyOlcZZOUnAr8jvLV7L/nM82N52TAoGhhq+k249+
0nx7Rwp88ldu9GMvGmUtpVVKQUbpn7Af2AFv04LqqqXAoYexlDSDThLvzzop
mHfr7CfNLhclr9MqBYzi9boD2KJLfvvruqSg8EH1F9KbCswSRyelIOLsddkh
cn8is1u0FaXhVNou/xGyn+/+qbFRlgZbD/kU0r5MP82uqEpDcndrFemAia9O
tVrSYP05mH0U+25z4x2b7dLwzjQ6hnTOtUfd/jbScOaDWdpP7IGhXX41odLw
10r14S/sXWn0x2p3pSEi63Yp6fSjtrSYe9LQk1T0mbRDq7fCyYfSYFLrLjKO
3VuU3sb8RBreOt+JIf3x6j/qnkppaHuYFfQbu4ZS3tw4Kw0Tg9W7J7DlW/fM
ai3i8XPWDqRvBn+QTViRhk/HK/xI71gYvXCGSQY8/HgLSJf3iclyCsiAinqF
0CRZn2xfHxN1GfDXDu0h/dhQW4p2QgbuxhcbT5PxLLiCVlxkQE6a1Z70D8eB
MdUzMnBiZKs3acXAh+W3PWVg60aLRNKZDUvH4KoM+KZJjJLOsqxJeBkrA8kP
L96cIfN14pBoUqMMDAlzpsxiN/loXG9qkYHPB2cKSI8GsQ7P02TgiUFdJen1
T1+XHuqQgZVcyW+kc8ekbHi/y8Azz1T5Oey8C4MPbi7LgGm0UjrpghBfiusG
Wai/tDtinnx/brcPDNkoC9IHuJJIa8wazTzZJAt1qe+ySec5C3/+ZiALEzpj
NaRz0MsE272yIHfEcZF05tKknIWjLCwffO+4gJ10zkNz831ZuL+9lLpI1kvJ
Ou1QrCxETmlpkJbo2ybgEy8LVUSiPukEE+7p5ymy0H1pmwXphyp5pevzZGG7
f9kV0tHfR7ZL18oCJelNO+lQm5OmzHOyMJMV4r1E1sOyz+7UoiwY3xq7Srpi
v41n44os8A7suE162nDf/btMcrCxtySJtJ2yepeQgBzwR3XXkNZZmHZWUpeD
dx2iAsvY/yUEXtlzQg4c+jTSSC/FrNzNdpGDS3czs0kLR15M4TwjB8ci+IpI
7791uormKQdSk2VVpEvcTNgOB8hBtb73d9LhWwVjTsfLgVKYP3UFe3NfRm4o
TQ5oUPiQtIDmmcXCdjm4oKuVTHr8hua+7k9ykLPx6WPSmYpvB9f3ygHnI/9C
0sLuHXItw3KQm/GmifRyALMpGwMVbjbkLZHu4darNpagglp1hs1f7AbdxNE+
SSoc45I8TrrE/i+/tzQVnrOFO5GOLqxxSJSjQpLJQXfSxocs//5cRwULu+s3
Sb9JOqN/V4cKGZH2uaQTVB8V0EypEHc8dI707MzerCBzKhR+8FwmbVk5nWxg
SYU+e4s10myHTCKyrKjQtTDHsUq+PwKWzl47RoUtf0alSFsRR9ZvcKXCu1p3
IM3jK/wkIpAK/lzWwaTPoKqkXcFU4F62u0O6ltMjZjGECn+XHSNIX0mtveUS
RoXTXtaxpH82+jhtj6aC/tDiE9INkh9kxlOo4BW7uYb0jarIBNMyPJ/tpmXS
h1dmorMrqNA4lc/wj+x/Pdsw5ioqHDWmsJPufqZ85W0DFVRNHwmR1ol/f1y9
gwoLRyrUSQ+fm5LlnqBCBMXrKOmKnCNirtM4n+Gv7Ek/GHjHXztHBVOVcWfS
cCyc4epfKjQPrjtHOslI8ccYpzxkUL/cJG0uZZPVoiQPPHLhWaQDoEKAX10e
tPcnFZDOP6UYcEhbHgyd/UpJcxVNWfUZykMQ5Ukd6Uajewx/DstD4dZP30jP
u82569jLg2jxhRHSylF2XZdOysPM5V+/SQf3qD1fOy8PY9mnlknv9Gw8TgmT
h7zTWZQ18nqJgxxfo+SBQzpOjDRPXW9JThxej7yzDOluiT+8kCkPdSIx60l7
1QtXeb7H8y9cMyR92CvVY2uDPGxTvbiL9Hap9RJsNHkwiLHcR5rDe5tPSq88
HOZ+dYB0mrSzUtucPIgn7XT+/3wf8nwCmBSgIKLfjTTcnqnS4FcAHzmqN+kf
E8H2kesVIHxd2HXSLzJpzww3K8B/CcXBpIOOiS7/3qkAJ/IDwkkr1WbHWRxX
AB4pzoekfQTUOd+7KoBg4ZdE0u/tn1/VuojHVwNSSdsuljgJRCrAlwb1bNJz
MW/3TGUpwBU/kULS0Rtq1D5WKsAoZesr0mz9VsLtPQpwVkTqHemr0QOrtFkF
6OgXrSU9ufPiSCu/IrAfCGwifXqG5UOzmiI8ORpCI+3yccVP1V4Rtjxo+kza
uXiaGhalCJboed//433kiaxrVIR7rzYNkK6cUV5aW1OEgq1Ro6T/B+JHcrs=

       "]]},
     Annotation[#, "Charting`Private`Tag$662298#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwl1nc8V+8XAHB7j4+PWZmlr0KktBTnEA2rEkopI7MkipLQUEm2rIgUMkpk
fj6SFQmRlaxSGWUne5TfvX5/3df79Tz3PM859zzP68pYXzCyZWJgYPjByMBA
PuN9rNlUbAI0GG5YvrGw3aFe2SKtf0zaEXy5WKLC4ls0lt+V+EpLX4U9VG4j
Pc9JDb7wgmyu9lvwbIPDjcpKVogvC5JilfYH3TTaRMQuQVActwletg+BRNqn
bXfaJeALX8K/pc/hQO08K1Rrth5kn3FuX1iMBKvdCbGlPYrgpO5+flbqIdgt
X3E5UrwFclu/JU/tfQSHdFbLeYbsgIVz+t0T9o/BKFv0ffzAHkhk7Paf1XkC
FtAhEGihCdr1YetnPj+FkBpGJrkAbfgVs798yjEZLBMaJJun9kOgzV/zycUU
UOxhbNWO04OWRYeI31LpEDS8rvHdhyNwuVpy8/irDEjIyjhyefYorH7QWje6
9wVcaOWqE9YwBWt5ZB62z4Lzu2VqG8RPAtOi58cpr2xQpHiFFueegtZvJhJT
Oq8gJyl6ad0WS/B4wU3/8zkHbvZ4dLFznAHd8AG2P4m5cIeJU1z8jg2Ie5Qb
TzjmQaM8p/4wrx2U7b3ye3wxH94Ej8ymajoCe9cPuVEpOpzKiJfUE3aB9rI3
7iO/6NDXNSCvvOwCGc9i3g6/KoJv95vZJ0ZdwfCiocXQ3mJgCZRzj+m4BFGc
RVE/7Ush/76ckuXAFaA+es808bkCkp/bWwlY3IBFvoJ0lz1v4bJr4tz1qRvQ
dzPp8O/Et5DoyPvofsBNKLD3SRh3rIR9Mgz/6ZTcghNbVdXGFquAVTjv2Jpt
d+BJ7WPXYakakDWfebvO4j5MxeTL9wTWgJPaTrd00QDYZ1/X2zxfA0o2jK5G
TQEwwjxrUtRSCymDWle/7Q+CneqGav5+H2DXb44rp6RDoTFriUlu/CNk9iwc
P6n4AK7XKuqqWLSAc4jmEPfFh/Ayy7/LSakTmvkjsejvUxiiDgXqWnXCgFVb
gIlCEshd1tXYENEJtiouYm3HkyBxD/eT3vlO0LnP9eB2bhKE1wTanajqguCA
LbH37JPhcm/IxH7zL/BVeuhKUU0KPOau8xXQ+Qa8X2fM6i+lgYb6NfMbp7+B
aTHnkkJ8GnQ7K2wbv/INUuMGec+8SwOx5oCBDxnfQLZO1M9MLB3CYvQP3qN8
h+7A9CXLonTwXd/At9z1HRqdqLuyZjLAHpoejlzsBebvT5ZPHMoEhqczRV0B
vfCGLelq2cVMiGER765N7oUUMduxxchMeF9jJ5ne1gvmn7bSproyYYPx0lNb
tT6we67QMGr7En45yL34ytgPp6wDef+5ZsHZcO+SxtAByM6euGaRnw1M0097
StMH4IndKkf3ymyIPfaeIatiAJRlh5ovt2RDrbjg3qCpAfh5p0Vnz0Q2KKSm
VR88/hN2h/fUNCu8gpHXLY0VUr/Aydz3y474V+Dcv7E37+UgmNbsD0TXHPh2
uoOjvGYQ3K61lo755MDR9ntK9X2DsD5P7+PdwBzYWffzav/qIXCYDG5zS80B
5lcpFBG/IbiP3m263TkQ4yWjccViGNz7FW9OaOZCueCqh7soo+DG4HWz9m8u
qAa9L9FRGAX+R6vP93DkwTM2j74j+0YhLqhO4LtgHgTOtymf9RqFjGuDAxkb
88C0J+Jd7K9RCH5LO3PSOA+GMihTi2Vj0PPesF/7WR5wydyW69n5G7y28qr2
7cmH93vClH10foNv7VfXDTr5cPd4wg4Jo98wtlfi7mmDfGAKpe0/eY4Y3xZ1
PfFUPiz8G7H/HP8bdHNd27y982G42yTtI9ME5Dhxf3lZlA8fYuQ2ln2YgGMz
lNjzCgVwP09VxaJjArKOiNkKbCmAA42au/71T4CD34+T6TsLoJLd/OCe5QmY
i9AQKtApgOLLoY40lT/w6E1wsrZFAWQaz6dnR/0BU8uISJ3QAgim1Mk/sZyE
yZDHbAZDBUDfIZFv6DwJh+eFYzh+F0Df6QuwdG0Sfs5eLKVNF8DuTEHjY9GT
oHB7UWKWoRB+HTT35m2YhGXTs3vGRAphr+/ox6u7p0CJVYXxMxaCcwackDs4
BQKzpzj7dQohtimsr9V0CiRrSzt+6RbCb6nt88oXp0ChoFa82bgQEop91g6k
TYH//cPKmxwKYW6a391IZBrM3Y1WCQcVwjoJ6+XlddPw8dELwXthhWConeef
qTINSZH1ExORhZASfjyBw2Aatimox2ckFIKR8pPqEt9pqArUufoqqxAyHbas
VpiYBocrFz3XNRaCdZdxKfOHGfjxPiiHlZsGXHHfz7t2zIB13fzQGT4a5Jxw
Fu8ZmIEWvc9bXwvQgLnT72oR4yxce3BbwUSMBsntRVtdd8yCWfvc2p3raTDw
STrt69NZSOhqulWlToPgyExT/exZ2BUt/rEIabDdRI216M0sdG22nUrfSwO/
1qPWke2z8Ofz5zn3gzTY0HJXXJ9vDl4MPlR5Z0yDs40jofSrc+A5fCr6yFka
UEOvgpzfHGztONY/6ESDokNsYxERc8D40rTc6wINuD9K6blkzUHDNgaDcDca
vKg3YpXrn4OubsM2bx8ajNXSrkYcngd/7ugaizAauFbdtr4gtwBa/MpuD3Jp
INm3j21m6wL8uh1Q5pxPgzomzgwvXIBSBlnzfYU0WI9BE/5mCxCmaRA3VESD
jqLIG8kBC8CfbDnBXkEDzexnCR3jC7D2473XcR+J9RoctCyXFmAN5QU/NNEg
blR+YIBjEc6clhDvaabBtHzWpimZRdiiLeUh3EaD9JTCYj7jRfhxcdvAyW4a
CMS979xLWwTuPulU4180KKHf96mtXIRP9twG7wZpcK5df+2RpkX42bqbc9sw
DaqEmxxPDy3Cf8GeXZxjNLga2jHnIb4Ev/vN7oVN0uD7nSGRlzeWYMH7aLrE
Pxq8cuE5KnbwLzw/wqGnL0CHD7GCVzNN/8KUu+vULSodBipXP9ay+QtlG2Gs
QJAOq1dtHHa6/hcsetYPiojQ4Xa5jm95/l/Y1DMeVbiaDqbU67ln1/4Dvorf
aTfW0cFlz92OZeV/UHH+/XiwLB3u2wUtR6j/g3yTw19j19OhtChOr/T4PyiX
lal6LkeHDWdovYIh/8D4fcyeHAU6LOROCL5Z/AfhTi6DJlvpIPR1bpcR5zI8
jJjqQlU6KHEwWP4UWYY7a4fKNm6jwxlzvhcCW5bhWlGH2/R2Ih8WBW07h2Xg
Tq1lcVejQ4KJjRv/p2VYvtJ9REyTDk+unRvafIwBNU91SnIb0GFzGeec3ykG
7DevjMgmXMaSxtpzhgGpyxaZxoZ0+BbUJx3kwoAimy80xRyig2TiqWOD/gy4
yUFrs4ARHWIrD1U+KWbAPD3bpEpTOshzjjXNVTBgHLe2n8kxOtANAnsO1TDg
DusvO/sJt7e9X/j7iQF7GHL5GM3oIDKoqXJinAFrTvS/lT9Jh3Be1QTqWkZs
KdUyOGBBh7VGzc8dNzCi7eABiWrCr6Jc6GVKjChat7tH25IOjVKZrc67GTEv
ZVhT3YoOfFv+464zZsRUCCmXOUPU31TMw9ePEZWcNvu9tqPDrcdLR6ZGGNHA
zNsXztPh8Gaaq8IkIx7O2vAogbBk+aUw63lGlJxnH10iXPRjqLGRlQnz+IPU
C53p8Gd9x6FMSSZk+tpVudaFDtYv8g3sDjPhgvuTyraLRD3VXc/HmzIh57Cm
mPwlOvyrVwxqNWdC7lChYi/CseNJH7QcmdBs79C8lBsdmreE60ndYkIOzUD3
0+500KQ7H2zPZcKQxar44itEPrryjvxFTBhXGhnD6kGH7s7+e/vKmDCqf3jO
gLDHkvn7vA9MmFihOd5NOBv09of1M2FyxrNPk1fpIP1OTkdXlBkd2d+GsHnR
gaHlGxZ7MqPq4tPo6utEPw+WPPG8yYxWyefVWW7QgZMhnmnXPWbccN3+GBKm
bjKrzI9kRsaNbiMFhNf7Ne3PymbGs0NlRfE36aC7u8Lw6QAzWnKkDBj50qHh
SGKW5Sgzai4VHvMjfNTBhyI1xYylj+UOvSZsHqnWHMfIgiImaZ9kbtPBeTzH
JFKcBQuFly0HCT9ISjK/Z8SCOvXdx8/cpYNY0c03+8xY0OCSWFYo4UeNFpKs
lizIIFMd94bws79rvt08z4IalRv3iPjRgXYs4sy1eywodoOeU0G4m/vOWecS
FlT1ztTm9KfDf252HsbyrFhLj2c9GkCHTWo9Rx9vZsXJeYi9SFiV4bjy0HZW
VFHtHAwjrBV4cOD6XlbUyjIs/kj4dLKi8XNzVtxyNlHjQCAdolr/KDOFsOL6
o2O7NwXRIT72HLdBJCt6qXRXHSCcbNk3EB3HiqnhOYI2hHNGPsVvSiPi0f4s
PSTcwELnNitnxa2B+VTmYDqwbrv+M2uSFQe3jubUEuZZnK1YmGfFO71DOT8I
U8tdEnQY2HDjzZ0+C4SlDaxNunjY8IRVvMfGEDrssdV5y/YfG85m3+K8Q9gt
kvvxqeNsWHR6O8PWUOK/fzralPsNG77lNB12CqPDU82tl768ZUOXrN1pNwhb
BDWEZNWyId9nnu0RhDtlWWuOtrPhrlHDd0WEm45e3P1okg1VX+q/Yw2nQ8kr
felN8uxY2LQ5/gFhr78/9yxvZseXN8zjkgnvOuhr1rSDHV8VNrvkE877Rg93
1yGsLZLURjiDX461xJIdQ+9rKIs+oEP0ecYhw2h2VNbZtTOMsDH9EZtMAjvq
avF/fkyYyrpz3WQyOz5o5z76knDwI2fz6Bx29E/I6K0lfLuuq6Gnnh3tuu0u
MEUQ9/HGglwXFg78yCThco6wbv9Z73BXDqwWiKbIRdJhn/e6F9oeHDjeGPdS
hbCWcHfnjA8H8ua+3bqHsJqOwc6TgRyot1Vl6jBh+RTlyXWpHDgV1mJ0lTC3
7ZRDfjcH2q4PzK0izPH3RbR9Lwf2yTd3NhBmibR9t2qIAzNKzUY+E16qbFvn
M8uBF/bNNQwSHpGlf91H5cS7EX+jeaKI+7vP27h9Pyeah163NST83mu7731D
TqwXfXzAlHCl0PirPSacyDsiv+o04WJtS/4n1pz4+ri273nCL5K1ah29OfES
m/H1AMJBNuy4mMOJMpToHZWEDftCFSQlufDy7rasjdHEegp9reayXGh5JHS9
MmG9Szt84uS58KfB7hBVwgeYvjaK7eDC4ukvGkBYS1rhsuBhLhytoVKNCW8z
ryrjuMWFYfHOcdcI5yWJnd1/jwuZ9z08eYPwluFzgneDuZDbV0HgDmElT6od
cxwXPhX/bh5MeEOMBfe/XC484sl5NZGweOu8yWQ/F/7SEmqvIBy7xmBZZYQL
u9IPzb8jvOpMYprLHy70VDQXqCMs8mff4ug/Lrw+oPVfC2EKJSLxlyg3Xikp
7f9BmFlfafjLQW68uaOljiGGDkNvrW+8z+RGDp9DadsJS4W1nw3O40YH1nwu
NcLGpw1NjF9z4xHDfht1wiVzu+S/vefGzFWLDNqEwzcJtM72ciPvQcPOw4R3
R5fKya3mwfVlPOscCbvYbKOOSvNg1LNr3E6En6k8X8qR48E9kd0jzoQpH6Ka
NLbxYPXJ3Fg3wn0MztdMD/OgupZT8nXCgWfFP965y4PZojXeEYTLd4TT9YJ4
cOdU3lIU4RkWjmSBCB68vCbY/SFhy8eTHvFPeDB39X6TBMKqrbVr84t5MDI0
oCGV8Bf1q5f7/vDgWf3IfDphJYE2ib0WvOgbYp3eQXggaOBWpC0vHm/vsuwi
HM81+/PnOV40CrUX+kKYh0UsJ9CDFxemOy98I+s3Y7avLYwXZbZsmR8gnNL9
xdmxkheb1FNPTRI2NxtreV3Li94qDzqnCAu1/dvJ18SLl7bJGs8QvvVRijn3
C7G+yAn1eXL/FVbRSzO8yBzBN/iPsHhaf2nIRj78c/FGBudDOrTKzsj+UObD
gCb+aS7CAU/Y7qtu50Ou5y/28BBeiJUz7tDiw7rtcm/5CLcHOf5aa86HI/61
mYKEH1wapRQE86Fkr/SyOGEumLbqnuTDwdsVxZsIe2hu4ChY4MPqSPcaJcID
e0++DGHkx7yYmBZlwhUHyhe0+Pkx1MDgmwphT6OgB+ny/Dh6tq9rG+Fh2/VV
l6348Q2F21Kd8AmH4+cOO/Cjq/6mfRqE358NEJC/wI9Mm6nyQDj5wsSpL178
uPRt5zASNr/6ZmZvDD8u+wce1Sb8IdBkg8BHfhyY/l6mS1gt5F7D0Cd+LKMm
3dEjnBb22q2ym4if6HlAn/DtKJnyK0P8GMVw670BYcnGGcVxJgomXbqdc5hw
W0dFlYkkBc8FftpiSnj/6InZtSYUXNJiWLYgnCDk23L9OAW7/C8HWhKe2v08
q/skBXOnQ8WsCCfeX7SPsqbg1qxSRWuy3nKP2jldKPis3lrHhvAL6y/03/eJ
8c5sNQfCTPdZowyCKWj0cymX9PFXmy5mhFFwoW+toiNhVgYfeZsYCr6T5Vp1
lvDpeMm4zykUFLyW1H+OMKXdwqukjIJPWMb0LhC2W/Y7vqaSgin7VuWRLv4v
W9WjmoL5u3TWuBB2dGcYVWmgoDd32gDpCuqTUyldFFQ9+Nn1ImE3gx8agTMU
fORfd9Kd7I8KG8YTigKoxHg3yJPwb83O1d7KAnjHfLKVNHv5IdXELQL4daF0
zTXC20vV7Ad2CqDuUc9U0hGvKfUXdQRwuTKg0IvwobzimIDTAhi/qPLah9zv
1i05L60EsL6eOk/aJye1rslGAO3ZbLdfJ+uVHf5P9JwASvpbZ5HmynSwSb4i
gFd/9cbeIPwuRWjzm1ABHMqkmN0i/FX2/sFvDwSw5s/DYNLTScvWzNECuF40
7S1p2adDkQfjBTC6+5iiL+FbCWWLn9IFUN9Zbo60RrRT9ViFABbsjPa8Qzj/
XuVp6WkBfBa6SeUe2U+6dWJ+cwLoPZBnTjqWp7l5dFEAz/F89CN9I7Rn32sm
KhaMlXaT1o9ZUDKlUPGP6Kub/oR/pG5eDlCg4lNjOu0+4U+OO+h/lKgoKjv0
hfR7BY1LZluoqGJewhRAODNL7+d/u6joqmiiR9qj0O5j+T4qyhw3ayfNV/3o
8awVFZnZkn8EEmb0TzI7bUvFIfpdpiCyP3UzBKscqFi/vGYt6Y6GQr/wC1SE
e5aWpJPbmi9s8qZir6dVB2m1AQ48E0NFB4uKN8Hk92F1/9bQQMXUn4tHQwmv
lqr5vNhERXnxckfSDTslPm74RMXHaUbXSW93qnpzq4uKz5K600mztQjHbf9F
RbHVD5dIpyQWmCQwCmLzAYmHYWS/F3EZ1LEIopXZj+ekeVpPa8+xC+Kwg1cJ
aTd29q1GfIJYTt/cS1rb+RiFbY0gro94Kh9OuG/3XO15VUH0oI+9Ih1jol8R
u0MQNwzJVZDWv5BIr1YTRJFRtWbSeU8PpMloCuK1hPEJ0rc5H975ZCCIUjKP
lB+Q/fF5F6rbC+KFrTrJpM9cvJbPEyuIp+cn3SLI/LZ8zd8YL4jJwuU3SHP9
wYJ9iYIY9+JSIOlsV7bCG88EsVXmfhLpJZcw2lSOIKq532wkHXUh9XV3nSDO
SFSujyTPozJX8XyDIDozM2wmvWfcqVikWRC9XWXVSPc6b3lzuF0QhdLlDElv
dn5TUtkniL1N4u6ka5xayl/8FURZh5ES0o8Ut1fUMAhhkH91NWmXkZiKAWYh
3K8W3EhaxOn0W2kuIbTg7vlO2vrcYGWEiBB2FT5gjiL367hc7aUshAoxl/aS
VrZXaNC3EkL5EfsC0l8dpS5k2ghhjvqTN6QDnQQpfA5CeP3D+0rSg66LRz46
C6GSUm8z6SSvuk9HvITw2ecDY6RFw899MY0WQjvXGZlo8vxGWPgUxgohE7vs
BtJu0UelxBKEcIhLS4l006PdVh3JQtg3eEiNdEAqd//JHCKfzoIjpJeLn49Y
1gvh+q2N3qRflj4OKm8UQm0JYV/S5hUPlNa2CmHBM/17pOnV11x6O4XwhFtE
OOlLzXpTtr+E8MmhwGekf/4cXjzLLIyax1Q/kP5IVeR23yWMavsl+GPI+NUv
qytAGMN1QYR0sJfKbco+YczLBQnS+gPb/z43EkYvq6/ypGvpmuM/zgkjY3OK
NukM58rnmy8KY0JGvS5p/3X7HXw8hPGgesdh0geC9L+vuiOMY2oJ5qSrLI+1
HE4QRhX90Yukk4U7QxKSifg24EH6dq25/kiGMJq0X/EmraVqXeVXKIypP+L9
SJexny8saRTGCxMfYkm/fnkrTpFZBFvc5N+Q/rmuPqqNIoIbq9OrSAs+FA2/
ISmCFqqd9aTP+b6417pLBG9bnvlCOnpuxtdnvwgyJr7rI/32vOb1DSYi6O07
Mkx6zfE2dy8XEWzaYjtPen+9tOt/PiKYOf96mfQlrXNOjQEiuCusmfUh4TpF
hjOyqSLI9e6gAOlrjPKHP3wRQbXDGetJfxBXDUmcE8FP3JFKpCV3ajS4CYoi
q/j37aRdjh7gPagkiimT/hqkK5yN9CUOiqISS7QOaaH75gETZ0RRb7eQPmm7
FLvaKh9i/l1eI9Jc3Z4HnPNE8TUl2Zx0ebBNnOeAKO5p2WRL2kPTcOyumBju
MEl3Iq00tUPzga4YVo2KXSLd/0wm4rGXGPY/8vIgXWwvoa84KIad/v43SUds
WMVCN1mFJpx//EiHfy+15X29Cv+a6AWSDo21q7aSXo0JMoEhpN1Ff+gW+q7G
QqO/YaRPRJxq4Pm5GvfKf35AOt2J0abNaA1C+qlI0nPaKfOPS9Zgb49nFGln
4amdKuvEcSlmbzTp3n4tjwo/cdSw+rziCoGimuopcezfRbQb4afqKmvqrSTw
rUPqitOsjorEVkugTUPfijPvuAvYb5JEDlvhh6T9TM7oMU9L4m9J9xV/jbnl
qWMlhZSUlBVv636S7lcvhfTAxhV3cG8vP7BKGg/rT6w4ZmNcZr2eNG7+yRFL
msddKCnwljQ+qhZe8fWyoBg9ujTaDFBXPHB+QpJ7XBov7fy38r7BGpOUWlkZ
dHrdu+Jq7WCGMVMZvDrdvGJN5+qTAv4yWChWvWKXKqEy51IZfJhQvOLH4tay
H6ZlkEvj1Yp/jN8+FbRhLdqVPF2x7NvUKMOTa3EqLmjFJ+byLClBa3HyuuuK
QzdVyDeXrEWt4pMrvhba+7d+ai3ePW+wYrtJlqYa+XW46LNvxTbNix4bT63D
gSjtFVu/+iPtH7KOuJ90/h+vmSeosnodnt32//klk//NLy+vw2z8//j/AJV9
V4s=
       "]]},
     Annotation[#, "Charting`Private`Tag$662298#3"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.676834431383214*^9, 3.676834466186804*^9}, {
   3.67683451490733*^9, 3.676834522213119*^9}, 3.676834847927932*^9, 
   3.676838170765526*^9, {3.676839901108862*^9, 3.676839941185751*^9}, 
   3.676839972042211*^9, 3.676841879581751*^9, 3.676841927922388*^9, 
   3.676842007813581*^9, {3.676842108215199*^9, 3.676842128933477*^9}, {
   3.676842168836042*^9, 3.6768422136719*^9}, 3.676842266295211*^9, {
   3.67684233615812*^9, 3.676842361249408*^9}, 3.676860219289192*^9, 
   3.67686073134385*^9, 3.676861161515582*^9, 3.6769416723833857`*^9, 
   3.676941786504388*^9, 3.6769430834275703`*^9, 3.67694357644493*^9, 
   3.676943955875613*^9, 3.676944054150393*^9, 3.676944090977311*^9, 
   3.6770882883265123`*^9, 3.677182172283051*^9, 3.6771825834909973`*^9, 
   3.6771874410918283`*^9, 3.6772016333925*^9, 3.6772038445983067`*^9, 
   3.677207283396874*^9, 3.677463453487028*^9, 3.677768792367957*^9, {
   3.677770451594849*^9, 3.677770478456231*^9}, 3.7933222097749023`*^9, {
   3.7938514920795517`*^9, 3.793851501502913*^9}, 3.823227642755632*^9},
 CellLabel->
  "Out[1795]=",ExpressionUUID->"48df39b7-54f8-495c-abc4-514a99345cf0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"SG3", ",", 
    RowBox[{"Limit", "[", 
     RowBox[{"SG3", ",", 
      RowBox[{"s", "\[Rule]", "0"}]}], "]"}]}], "}"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SG3", 
     RowBox[{"(", "0", ")"}], " ", "gives", " ", "the", " ", "step", " ", 
     "response", " ", "for", " ", "t"}], "\[Rule]", "\[Infinity]"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.6768345577210293`*^9, 3.67683465372572*^9}},
 CellLabel->
  "In[1796]:=",ExpressionUUID->"0a3dff5b-38b5-4321-857d-29033526d0b3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", "Kp", "+", 
     RowBox[{"Kd", " ", "s"}], "+", 
     SuperscriptBox["s", "2"]}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", "Kp"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.676834654263092*^9, 3.676834847987586*^9, 3.6768381708283253`*^9, 
   3.676841879602406*^9, 3.67684192795269*^9, 3.67684200785067*^9, {
   3.6768421082683907`*^9, 3.6768421289629507`*^9}, {3.6768421688935823`*^9, 
   3.67684221369132*^9}, 3.6768422663161697`*^9, {3.676842336196125*^9, 
   3.676842361299477*^9}, 3.676860219324469*^9, 3.676860731398468*^9, 
   3.67686116155581*^9, 3.676941672441785*^9, 3.6769417865580587`*^9, 
   3.676943083481735*^9, 3.676943576496855*^9, 3.676943955948653*^9, 
   3.676944054211217*^9, 3.676944091033308*^9, 3.6770882883945713`*^9, 
   3.6771821723284903`*^9, 3.677182583533454*^9, 3.6771874411291323`*^9, 
   3.677201633522923*^9, 3.6772038446521463`*^9, 3.677207283479349*^9, 
   3.677463453548955*^9, 3.677768792412163*^9, {3.6777704516336308`*^9, 
   3.677770478487328*^9}, 3.793322209817416*^9, {3.793851492094008*^9, 
   3.793851501518018*^9}, 3.823227642775813*^9},
 CellLabel->
  "Out[1796]=",ExpressionUUID->"af523d27-0dae-4535-b7d1-b91b2be33b1d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"ysol", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"SG3tf", "/.", 
         RowBox[{"Kd", "\[Rule]", 
          RowBox[{"2", 
           SqrtBox[
            RowBox[{"Kp", "+", "1"}]]}]}]}], ",", "step", ",", "t"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}], "//", "FullSimplify"}], "//", 
    "TraditionalForm"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.6768347002313004`*^9, 3.6768347363389397`*^9}, {
   3.6768348133039513`*^9, 3.676834867528852*^9}, {3.676838526711197*^9, 
   3.676838528188023*^9}, {3.6768420831549892`*^9, 3.676842085514434*^9}, 
   3.677203827123999*^9},
 CellLabel->
  "In[1797]:=",ExpressionUUID->"c58ab069-c802-42ea-bf4d-1de12325070a"],

Cell["PID control:  needed to reject a step disturbance", "Text",
 CellChangeTimes->{{3.676256123319852*^9, 3.6762561340117064`*^9}, {
  3.676256527464588*^9, 3.676256537807025*^9}, {3.676390134403613*^9, 
  3.676390134811151*^9}, {3.676432290911524*^9, 3.676432291046063*^9}, {
  3.676518622684082*^9, 3.67651863874605*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"197597c9-a571-4b57-bb78-0dea02458217"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"K4", "=", 
   RowBox[{"Kp", "+", 
    FractionBox["Ki", "s"], "+", 
    RowBox[{"Kd", " ", "s"}]}]}], ";", " ", 
  RowBox[{"SG4", "=", 
   RowBox[{"Together", "[", 
    FractionBox["G", 
     RowBox[{"1", "+", 
      RowBox[{"K4", " ", "G"}]}]], "]"}]}], ";", " ", 
  RowBox[{"SG4tf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"SG4", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"negT4", "=", 
   RowBox[{"Together", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "K4"}], " ", "G"}], 
     RowBox[{"1", "+", 
      RowBox[{"K4", " ", "G"}]}]], "]"}]}], ";", " ", 
  RowBox[{"negT4tf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"negT4", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"y4a", "=", 
    RowBox[{
     RowBox[{"OutputResponse", "[", 
      RowBox[{
       RowBox[{"SG4tf", "//.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Kp", "\[Rule]", 
           RowBox[{
            RowBox[{"3", 
             SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
          RowBox[{"Ki", "\[Rule]", 
           SuperscriptBox["a", "3"]}], ",", 
          RowBox[{"Kd", "\[Rule]", 
           RowBox[{"3", "a"}]}], ",", 
          RowBox[{"a", "\[Rule]", "2"}]}], "}"}]}], ",", "step", ",", 
       "trange"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}]}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"y4b", "=", 
    RowBox[{
     RowBox[{"OutputResponse", "[", 
      RowBox[{
       RowBox[{"SG4tf", "//.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Kp", "\[Rule]", 
           RowBox[{
            RowBox[{"3", 
             SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
          RowBox[{"Ki", "\[Rule]", 
           SuperscriptBox["a", "3"]}], ",", 
          RowBox[{"Kd", "\[Rule]", 
           RowBox[{"3", "a"}]}], ",", 
          RowBox[{"a", "\[Rule]", "2"}]}], "}"}]}], ",", "d", ",", "trange"}],
       "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p4a", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y4a", ",", "y4b", ",", "y0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u4a", "=", 
   RowBox[{
    RowBox[{"OutputResponse", "[", 
     RowBox[{
      RowBox[{"negT4tf", "//.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Kp", "\[Rule]", 
          RowBox[{
           RowBox[{"3", 
            SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
         RowBox[{"Ki", "\[Rule]", 
          SuperscriptBox["a", "3"]}], ",", 
         RowBox[{"Kd", "\[Rule]", 
          RowBox[{"3", "a"}]}], ",", 
         RowBox[{"a", "\[Rule]", "2"}]}], "}"}]}], ",", "step", ",", 
      "trange"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u4b", "=", 
   RowBox[{
    RowBox[{"OutputResponse", "[", 
     RowBox[{
      RowBox[{"negT4tf", "//.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Kp", "\[Rule]", 
          RowBox[{
           RowBox[{"3", 
            SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
         RowBox[{"Ki", "\[Rule]", 
          SuperscriptBox["a", "3"]}], ",", 
         RowBox[{"Kd", "\[Rule]", 
          RowBox[{"3", "a"}]}], ",", 
         RowBox[{"a", "\[Rule]", "2"}]}], "}"}]}], ",", "d", ",", "trange"}], 
     "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p4b", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u4a", ",", "u4b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p4a", ",", " ", "p4b"}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.676600980477118*^9, 3.676601098953053*^9}, {
  3.676601138077429*^9, 3.6766011507698803`*^9}, {3.676601204540559*^9, 
  3.676601215762928*^9}, {3.676602735926928*^9, 3.6766029020607224`*^9}, {
  3.676603000393454*^9, 3.676603139616612*^9}, {3.676603573209407*^9, 
  3.676603614718348*^9}, {3.676605585214613*^9, 3.676605648091826*^9}, {
  3.677182474865823*^9, 3.677182496713669*^9}, {3.6772038290133953`*^9, 
  3.67720383027645*^9}},
 CellLabel->
  "In[1798]:=",ExpressionUUID->"ecfc144e-c5e3-4ede-89c5-c1dfdc484bde"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVl3c4lv8Xx+29Z/bzeKSMhGSV+3yIhlVWUqIkO0VWIYUiI3uWIiObRyiR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           "]]},
         Annotation[#, "Charting`Private`Tag$663199#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVl3c41l8bwI2SjOy9Hh4hI4mfVTknKysiFEnZZJNNCtnKjJD5KElWKOt7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           "]]},
         Annotation[#, "Charting`Private`Tag$663199#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVmHk41N8Xxy1RpDBjyTILU1GKikqbc1GUSJQlybdUkr2iKJU2hRRlV5Qo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           "]]},
         Annotation[#, "Charting`Private`Tag$663199#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{16.153061224489797`, 1.4999999999999432`}, {
       1.5000000000000284`, 0.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {159.8023027815026, -92.62500043839714},
      ImageScaled[{0.5, 0.5}], {299.8844197561337, 176.4285722636136}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV13c8lV0cAPCL8orI3uMaIaShJeMcIyuprCJUlFEqKhSaZkSSzGigMqIk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           "]]},
         Annotation[#, "Charting`Private`Tag$663995#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVV3k4VV8XNmcq8zzde0lCQhGRvYVCfiKRJGSWWaZQCSEhSpIMV5GphJSx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           "]]},
         Annotation[#, "Charting`Private`Tag$663995#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{7.989795918367348, 1.5}, {1.5000000000000284`, 0.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {475.32527569144656, -92.62500043839714},
      ImageScaled[{0.5, 0.5}], {291.7211544500113, 176.4285722636136}]}, {}},
  ImageSize->Large,
  PlotRange->{{0, 631.045945819888}, {-185.25000087679427`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.67660110434932*^9, 3.676601155221106*^9, {3.676601207720232*^9, 
   3.676601216782381*^9}, 3.6766028053486443`*^9, {3.676602841313307*^9, 
   3.6766029241889772`*^9}, {3.6766029724962606`*^9, 3.676603034441921*^9}, {
   3.6766030965543327`*^9, 3.6766031402486553`*^9}, {3.6766035881926403`*^9, 
   3.676603615258811*^9}, {3.676605587299344*^9, 3.6766056488552732`*^9}, 
   3.676605711824731*^9, 3.676606252445129*^9, 3.676816044798842*^9, 
   3.676819599411893*^9, 3.676827868210865*^9, 3.676834848508319*^9, 
   3.676838171424363*^9, 3.67684192945436*^9, 3.676842009338846*^9, {
   3.6768421084902554`*^9, 3.676842129190812*^9}, {3.6768421691661167`*^9, 
   3.676842213919544*^9}, 3.676842266541978*^9, {3.6768423364143963`*^9, 
   3.676842361552977*^9}, 3.676860219536871*^9, 3.676860731603294*^9, 
   3.676861161780198*^9, 3.676941672660581*^9, 3.676941786796755*^9, 
   3.676943083725559*^9, 3.676943576720396*^9, 3.676943956147101*^9, 
   3.676944054567944*^9, 3.676944091245414*^9, 3.6770882889191628`*^9, 
   3.677182172570299*^9, 3.677182498173419*^9, 3.677182583760962*^9, 
   3.6771874413790493`*^9, 3.677201633744089*^9, 3.677203844880739*^9, 
   3.6772072836840076`*^9, 3.677463453766602*^9, 3.677768792645176*^9, {
   3.677770451866084*^9, 3.677770478693289*^9}, 3.793322210006781*^9, {
   3.793851492342909*^9, 3.793851501761148*^9}, 3.823227643056542*^9},
 CellLabel->
  "Out[1806]=",ExpressionUUID->"860305e4-66ce-4319-b233-f2ed67b81102"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SG4", ",", "negT4"}], "}"}]], "Input",
 CellLabel->
  "In[1807]:=",ExpressionUUID->"497d5b1d-3e7e-4d1f-925c-fe80d1aea9e5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["s", 
    RowBox[{"Ki", "+", "s", "+", 
     RowBox[{"Kp", " ", "s"}], "+", 
     RowBox[{"Kd", " ", 
      SuperscriptBox["s", "2"]}], "+", 
     SuperscriptBox["s", "3"]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "Ki"}], "-", 
     RowBox[{"Kp", " ", "s"}], "-", 
     RowBox[{"Kd", " ", 
      SuperscriptBox["s", "2"]}]}], 
    RowBox[{"Ki", "+", "s", "+", 
     RowBox[{"Kp", " ", "s"}], "+", 
     RowBox[{"Kd", " ", 
      SuperscriptBox["s", "2"]}], "+", 
     SuperscriptBox["s", "3"]}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.676606302574239*^9, 3.676816044851344*^9, 3.676819599461483*^9, 
   3.676827868302759*^9, 3.676834848564995*^9, 3.676838171463881*^9, 
   3.6768419294791718`*^9, 3.676842009384706*^9, {3.676842108552086*^9, 
   3.676842129234849*^9}, {3.676842169241803*^9, 3.676842213963553*^9}, 
   3.676842266586835*^9, {3.676842336462435*^9, 3.676842361599676*^9}, 
   3.676860219580394*^9, 3.6768607316682577`*^9, 3.676861161822526*^9, 
   3.67694167272231*^9, 3.676941786856435*^9, 3.676943083798777*^9, 
   3.676943576777628*^9, 3.67694395621931*^9, 3.676944054629537*^9, 
   3.676944091313971*^9, 3.6770882889627*^9, 3.6771821727033253`*^9, 
   3.677182501906886*^9, 3.677182583801134*^9, 3.677187441428195*^9, 
   3.677201633787424*^9, 3.677203844917406*^9, 3.677207283750009*^9, 
   3.677463453832501*^9, 3.677768792696588*^9, {3.6777704519163*^9, 
   3.6777704787183123`*^9}, 3.793322210018815*^9, {3.793851492355198*^9, 
   3.793851501771797*^9}, 3.823227643065884*^9},
 CellLabel->
  "Out[1807]=",ExpressionUUID->"6e37da1e-5cc1-40e2-9ad2-83f710c63131"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"SG4", ",", "negT4"}], "}"}], "//.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Kp", "\[Rule]", 
      RowBox[{
       RowBox[{"3", 
        SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
     RowBox[{"Ki", "\[Rule]", 
      SuperscriptBox["a", "3"]}], ",", 
     RowBox[{"Kd", "\[Rule]", 
      RowBox[{"3", "a"}]}], ",", 
     RowBox[{"a", "\[Rule]", "2"}]}], "}"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.676605080057453*^9, 3.676605088441555*^9}, {
  3.676605125908675*^9, 3.676605131623805*^9}, {3.67660622246846*^9, 
  3.676606242220643*^9}, {3.6771825127047987`*^9, 3.677182517583016*^9}},
 CellLabel->
  "In[1808]:=",ExpressionUUID->"42962125-494c-492b-95ec-91b20eecb229"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["s", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "+", "s"}], ")"}], "3"]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"8", "+", 
      RowBox[{"11", " ", "s"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["s", "2"]}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "+", "s"}], ")"}], "3"]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.676605080879779*^9, 3.676605088846307*^9}, {
   3.676605126330469*^9, 3.6766051320181293`*^9}, 3.6766057121642*^9, {
   3.676606227884324*^9, 3.676606252669862*^9}, 3.6768160449097977`*^9, 
   3.676819599538183*^9, 3.676827868369516*^9, 3.676834848620837*^9, 
   3.676838171496786*^9, 3.676841929542655*^9, 3.676842009435408*^9, {
   3.676842108599226*^9, 3.676842129284316*^9}, {3.676842169355895*^9, 
   3.676842214030025*^9}, 3.676842266637068*^9, {3.6768423365126963`*^9, 
   3.6768423616475563`*^9}, 3.67686021963011*^9, 3.6768607317165813`*^9, 
   3.676861161873082*^9, 3.6769416727719383`*^9, 3.6769417869240513`*^9, 
   3.676943083868175*^9, 3.6769435768414783`*^9, 3.676943956286265*^9, 
   3.676944054695798*^9, 3.676944091363277*^9, 3.6770882890132637`*^9, 
   3.677182172767075*^9, {3.677182514484234*^9, 3.677182518465629*^9}, 
   3.67718258385565*^9, 3.6771874414820623`*^9, 3.677201633841179*^9, 
   3.677203844969543*^9, 3.677207283800139*^9, 3.677463453878702*^9, 
   3.677768792754554*^9, {3.67777045197213*^9, 3.677770478779887*^9}, 
   3.79332221005794*^9, {3.793851492373706*^9, 3.793851501804673*^9}, 
   3.823227643091251*^9},
 CellLabel->
  "Out[1808]=",ExpressionUUID->"63369006-6f91-4fc3-b069-acf0c8541518"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"OutputResponse", "[", 
      RowBox[{
       RowBox[{"SG4tf", "//.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Kp", "\[Rule]", 
           RowBox[{
            RowBox[{"3", 
             SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
          RowBox[{"Ki", "\[Rule]", 
           SuperscriptBox["a", "3"]}], ",", 
          RowBox[{"Kd", "\[Rule]", 
           RowBox[{"3", "a"}]}], ",", 
          RowBox[{"a", "\[Rule]", "2"}]}], "}"}]}], ",", "d", ",", "t"}], 
      "]"}], "//", "TraditionalForm"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"OutputResponse", "[", 
      RowBox[{
       RowBox[{"SG4tf", "//.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Kp", "\[Rule]", 
           RowBox[{
            RowBox[{"3", 
             SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
          RowBox[{"Ki", "\[Rule]", 
           SuperscriptBox["a", "3"]}], ",", 
          RowBox[{"Kd", "\[Rule]", 
           RowBox[{"3", "a"}]}], ",", 
          RowBox[{"a", "\[Rule]", "2"}]}], "}"}]}], ",", "step", ",", "t"}], 
      "]"}], "//", "TraditionalForm"}]}], "}"}], " "}]], "Input",
 CellChangeTimes->{{3.676605178018722*^9, 3.676605196017091*^9}, {
   3.676606092674406*^9, 3.676606112417509*^9}, {3.676606171467346*^9, 
   3.676606178968749*^9}, {3.6768420920427513`*^9, 3.67684209413822*^9}, {
   3.677182429714931*^9, 3.677182432248598*^9}, {3.67718252677677*^9, 
   3.6771825299360332`*^9}, 3.677203831308206*^9},
 CellLabel->
  "In[1809]:=",ExpressionUUID->"bd6d9a15-4bb3-4654-868e-5435175e3dab"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    FormBox[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "2"}], " ", "t"}]]}], " ", 
       RowBox[{"(", 
        RowBox[{"t", "-", "1"}], ")"}], " ", "t", " ", 
       TemplateBox[{
         RowBox[{"t"}]},
        "HeavisideThetaSeq"]}], "}"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "t"}]], " ", 
       SuperscriptBox["t", "2"], " ", 
       TemplateBox[{
         RowBox[{"t"}]},
        "UnitStepSeq"]}], "}"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True]}], "}"}]], "Output",
 CellChangeTimes->{
  3.677182432831717*^9, 3.677182531472887*^9, 3.677182584007679*^9, 
   3.677187441642955*^9, 3.677201633990847*^9, 3.677203845119948*^9, 
   3.6772072839585457`*^9, 3.677463454048835*^9, 3.6777687929123783`*^9, {
   3.677770452122817*^9, 3.677770478947351*^9}, 3.793322210184155*^9, {
   3.793851492508666*^9, 3.79385150193357*^9}, 3.823227643361549*^9},
 CellLabel->
  "Out[1809]=",ExpressionUUID->"96973d3e-b8e7-4ddd-91f7-41cd7d693780"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"negT4tf", "//.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Kp", "\[Rule]", 
            RowBox[{
             RowBox[{"3", 
              SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
           RowBox[{"Ki", "\[Rule]", 
            SuperscriptBox["a", "3"]}], ",", 
           RowBox[{"Kd", "\[Rule]", 
            RowBox[{"3", "a"}]}], ",", 
           RowBox[{"a", "\[Rule]", "2"}]}], "}"}]}], ",", "d", ",", "t"}], 
       "]"}], "//", "Simplify"}], "//", "TraditionalForm"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"negT4tf", "//.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Kp", "\[Rule]", 
            RowBox[{
             RowBox[{"3", 
              SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
           RowBox[{"Ki", "\[Rule]", 
            SuperscriptBox["a", "3"]}], ",", 
           RowBox[{"Kd", "\[Rule]", 
            RowBox[{"3", "a"}]}], ",", 
           RowBox[{"a", "\[Rule]", "2"}]}], "}"}]}], ",", "step", ",", "t"}], 
       "]"}], "//", "Simplify"}], "//", "TraditionalForm"}]}], "}"}], 
  " "}]], "Input",
 CellChangeTimes->{{3.6766052272940063`*^9, 3.6766052617405853`*^9}, {
   3.676606188784966*^9, 3.6766061977440557`*^9}, {3.6768405203746223`*^9, 
   3.676840538603445*^9}, {3.676842097266479*^9, 3.676842099409959*^9}, {
   3.677182438728973*^9, 3.677182441016192*^9}, {3.677182537576041*^9, 
   3.6771825404236937`*^9}, 3.677203832308165*^9},
 CellLabel->
  "In[1810]:=",ExpressionUUID->"e1c5bfb1-feba-453a-a89d-84205d7b0d1f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    FormBox[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "2"}], " ", "t"}]]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["t", "2"]}], "-", 
         RowBox[{"13", " ", "t"}], "+", "6"}], ")"}], " ", 
       TemplateBox[{
         RowBox[{"t"}]},
        "HeavisideThetaSeq"]}], "}"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "t"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"5", " ", 
           SuperscriptBox["t", "2"]}]}], "+", 
         RowBox[{"8", " ", "t"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "t"}]]}], "-", "2"}], ")"}], " ", 
       TemplateBox[{
         RowBox[{"t"}]},
        "UnitStepSeq"]}], "}"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True]}], "}"}]], "Output",
 CellChangeTimes->{
  3.677182441732197*^9, 3.677182541048189*^9, 3.677182584189868*^9, 
   3.677187441826857*^9, 3.677201634178563*^9, 3.677203845312586*^9, 
   3.6772072841488323`*^9, 3.6774634543913603`*^9, 3.67776879310562*^9, {
   3.6777704523084393`*^9, 3.677770479134766*^9}, 3.79332221023827*^9, {
   3.7938514926442432`*^9, 3.793851502066887*^9}, 3.823227643439218*^9},
 CellLabel->
  "Out[1810]=",ExpressionUUID->"7a89bc60-a54d-43da-935e-26b26cb186e9"]
}, Open  ]],

Cell["PID control:  look at command tracking (step response)", "Text",
 CellChangeTimes->{{3.676256123319852*^9, 3.6762561340117064`*^9}, {
  3.676256527464588*^9, 3.676256537807025*^9}, {3.676390134403613*^9, 
  3.676390134811151*^9}, {3.676432290911524*^9, 3.676432291046063*^9}, {
  3.676518622684082*^9, 3.67651863874605*^9}, {3.676860203476437*^9, 
  3.676860210090838*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"974c36b0-0b7f-414a-be31-ec79c4b9ec66"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"T4", "=", 
   RowBox[{"Together", "[", 
    FractionBox[
     RowBox[{"K4", " ", "G"}], 
     RowBox[{"1", "+", 
      RowBox[{"K4", " ", "G"}]}]], "]"}]}], ";", " ", 
  RowBox[{"T4tf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"T4", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SK4", "=", 
   RowBox[{"Together", "[", 
    FractionBox["K4", 
     RowBox[{"1", "+", 
      RowBox[{"K4", " ", "G"}]}]], "]"}]}], ";", 
  RowBox[{"SK4tf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"SK4", ",", "s"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6768602598276987`*^9, 3.6768603356880217`*^9}, {
  3.6768613528261633`*^9, 3.676861362113482*^9}},
 CellLabel->
  "In[1811]:=",ExpressionUUID->"9adf6503-dd14-4617-a184-b3dcf761ee8a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ypid", "=", 
   RowBox[{
    RowBox[{"OutputResponse", "[", 
     RowBox[{
      RowBox[{"T4tf", "//.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Kp", "\[Rule]", 
          RowBox[{
           RowBox[{"3", 
            SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
         RowBox[{"Ki", "\[Rule]", 
          SuperscriptBox["a", "3"]}], ",", 
         RowBox[{"Kd", "\[Rule]", 
          RowBox[{"3", "a"}]}], ",", 
         RowBox[{"a", "\[Rule]", "2"}]}], "}"}]}], ",", "step", ",", 
      "trange"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"upid", "=", 
   RowBox[{
    RowBox[{"OutputResponse", "[", 
     RowBox[{
      RowBox[{"SK4tf", "//.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Kp", "\[Rule]", 
          RowBox[{
           RowBox[{"3", 
            SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
         RowBox[{"Ki", "\[Rule]", 
          SuperscriptBox["a", "3"]}], ",", 
         RowBox[{"Kd", "\[Rule]", 
          RowBox[{"3", "a"}]}], ",", 
         RowBox[{"a", "\[Rule]", "2"}]}], "}"}]}], ",", "step", ",", 
      "trange"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ypid", ",", "upid"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1.2"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.676860296716926*^9, 3.676860299287456*^9}, {
   3.676860338983132*^9, 3.676860354989731*^9}, {3.676860389814013*^9, 
   3.676860417213109*^9}, {3.676860476846644*^9, 3.676860557297215*^9}, {
   3.676860657072507*^9, 3.676860660662347*^9}, {3.676860828412327*^9, 
   3.676860832452153*^9}, 3.6768613647302427`*^9, {3.677203833300742*^9, 
   3.677203834131673*^9}, {3.6772046301116457`*^9, 3.677204660427512*^9}, {
   3.677205269062132*^9, 3.677205272636747*^9}},
 CellLabel->
  "In[1813]:=",ExpressionUUID->"a08e7e67-6995-4aec-b045-a97d95dc9abf"],

Cell[BoxData[
 TemplateBox[{
  "NDSolve", "irfail", 
   "\"Unable to reduce the index of the system to 0 or 1.\"", 2, 1814, 156, 
   24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.7933222103311567`*^9, {3.793851492742372*^9, 3.7938515021684923`*^9}, 
   3.823227643563931*^9},
 CellLabel->
  "During evaluation of \
In[1813]:=",ExpressionUUID->"ec92af23-2804-4ec7-b6ed-8f5a9bed1929"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV13c8lV8YAPCL8hORvcc1QkhDS+E5RlZSWWUmyigVFQpNMyJkiwYNKkqi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       "]]},
     Annotation[#, "Charting`Private`Tag$667220#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 9.999999795918367}, {0, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.676860507478595*^9, 3.676860511135454*^9}, 
   3.676860558060039*^9, {3.676860658177109*^9, 3.676860661157155*^9}, 
   3.676860731877676*^9, {3.676860829393259*^9, 3.676860833553275*^9}, 
   3.6768611620327787`*^9, {3.6768613667036657`*^9, 3.67686137433606*^9}, 
   3.676941672995088*^9, 3.6769417871380463`*^9, 3.676943084071375*^9, 
   3.676943577131353*^9, 3.676943956510064*^9, 3.676944054958249*^9, 
   3.676944091725684*^9, 3.67708828932612*^9, 3.6771821731079197`*^9, 
   3.677182584371237*^9, 3.677187442063706*^9, 3.677201634355056*^9, 
   3.6772038454867487`*^9, {3.6772046320795*^9, 3.6772046610515223`*^9}, 
   3.677205273658207*^9, 3.67720728432552*^9, 3.677463454642042*^9, 
   3.6777687934140387`*^9, {3.6777704525020227`*^9, 3.677770479352713*^9}, 
   3.793322210375235*^9, {3.793851492790783*^9, 3.7938515022142143`*^9}, 
   3.8232276436077957`*^9},
 CellLabel->
  "Out[1815]=",ExpressionUUID->"a4a04507-668a-4970-9dc5-1f3bd51b8ad0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"K4", ",", "T4", ",", "SK4"}], "}"}], "//.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Kp", "\[Rule]", 
      RowBox[{
       RowBox[{"3", 
        SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
     RowBox[{"Ki", "\[Rule]", 
      SuperscriptBox["a", "3"]}], ",", 
     RowBox[{"Kd", "\[Rule]", 
      RowBox[{"3", "a"}]}], ",", 
     RowBox[{"a", "\[Rule]", "2"}]}], "}"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.6768611714540043`*^9, 3.67686118370898*^9}, {
  3.67694367919162*^9, 3.6769436985673122`*^9}},
 CellLabel->
  "In[1816]:=",ExpressionUUID->"802dd245-10d5-44f3-93c9-bc9ce494abed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"11", "+", 
    FractionBox["8", "s"], "+", 
    RowBox[{"6", " ", "s"}]}], ",", 
   FractionBox[
    RowBox[{"8", "+", 
     RowBox[{"11", " ", "s"}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["s", "2"]}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "+", "s"}], ")"}], "3"]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["s", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"8", "+", 
       RowBox[{"11", " ", "s"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["s", "2"]}]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "+", "s"}], ")"}], "3"]]}], "}"}]], "Output",
 CellChangeTimes->{{3.676861171960381*^9, 3.676861184160039*^9}, 
   3.676941673053315*^9, 3.6769417871862383`*^9, 3.676943084126399*^9, 
   3.6769435772814302`*^9, {3.67694368442068*^9, 3.676943699023716*^9}, 
   3.67694395655618*^9, 3.6769440551188183`*^9, 3.6769440919399*^9, 
   3.6770882893625107`*^9, 3.67718217317179*^9, 3.677182549242137*^9, 
   3.677182584471459*^9, 3.677187442094266*^9, 3.677201634398574*^9, 
   3.677203845582905*^9, 3.677207284352412*^9, 3.677463454674162*^9, 
   3.677768793445085*^9, {3.677770452698951*^9, 3.677770479442507*^9}, 
   3.793322210382786*^9, {3.793851492798347*^9, 3.7938515022213287`*^9}, 
   3.823227643614065*^9},
 CellLabel->
  "Out[1816]=",ExpressionUUID->"7092d396-43a0-4b96-98a5-ef3f69952a0e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T4tfa", " ", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"T4tf", " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Kp", "\[Rule]", 
        RowBox[{
         RowBox[{"3", 
          SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
       RowBox[{"Ki", "\[Rule]", 
        SuperscriptBox["a", "3"]}], ",", 
       RowBox[{"Kd", "\[Rule]", 
        RowBox[{"3", "a"}]}]}], "}"}]}], "/.", 
    RowBox[{"a", "\[Rule]", "2"}]}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.6772016937369213`*^9, 3.6772017475346193`*^9}, {
  3.677201835850177*^9, 3.677201837825718*^9}},
 CellLabel->
  "In[1817]:=",ExpressionUUID->"abdd52dd-2399-4b18-8f5a-f7fc833e8360"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox[
     RowBox[{"8", "+", 
       RowBox[{"11", " ", "s"}], "+", 
       RowBox[{"6", " ", 
         SuperscriptBox["s", "2"]}]}], 
     SuperscriptBox[
      RowBox[{"(", 
        RowBox[{"2", "+", "s"}], ")"}], "3"]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{8 + 11 $CellContext`s + 6 $CellContext`s^2}}, (
         2 + $CellContext`s)^3}, $CellContext`s], AutoDelete -> True, 
      Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{8 + 11 $CellContext`s + 6 $CellContext`s^2}}, (
         2 + $CellContext`s)^3}, $CellContext`s]], 1, {}, {False, False}, 
     False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{8 + 11 $CellContext`s + 6 $CellContext`s^2}}, (
     2 + $CellContext`s)^3}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{{3.677201699709094*^9, 3.67720174810728*^9}, 
   3.6772018387855587`*^9, 3.677203845679283*^9, 3.677207284443183*^9, 
   3.677463454770905*^9, 3.677768793557703*^9, {3.677770452800687*^9, 
   3.677770479542577*^9}, 3.793322210495365*^9, {3.793851492859969*^9, 
   3.793851502291067*^9}, 3.8232276436702633`*^9},
 CellLabel->
  "Out[1817]=",ExpressionUUID->"3e649472-a3e9-4d38-8ade-8ae2065dc8f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ytest", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"OutputResponse", "[", 
      RowBox[{"T4tfa", ",", "step", ",", "t"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], " ", "//", "FullSimplify"}]}], ";", " ", 
  
  RowBox[{"ytest", "//", "TraditionalForm"}]}]], "Input",
 CellChangeTimes->{{3.677201108531274*^9, 3.677201168410781*^9}, {
   3.677201206414442*^9, 3.677201218781085*^9}, {3.677201563037527*^9, 
   3.677201615210597*^9}, 3.677201768310587*^9, 3.677201858756094*^9, 
   3.677201922393672*^9, 3.677203835147718*^9, {3.677203907334155*^9, 
   3.677203913011991*^9}},
 CellLabel->
  "In[1818]:=",ExpressionUUID->"05348777-84e2-44ec-bfa5-bc1a109492a4"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "t"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "-", 
         RowBox[{"5", " ", "t"}]}], ")"}], " ", "t"}], "-", "2"}], ")"}], " ", 
    TemplateBox[{
      RowBox[{"t"}]},
     "UnitStepSeq"]}], "+", 
   TemplateBox[{
     RowBox[{"t"}]},
    "UnitStepSeq"]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.6772011619453363`*^9, 3.677201185664495*^9}, 
   3.677201220692626*^9, 3.6772012793370028`*^9, {3.677201563838606*^9, 
   3.677201636562682*^9}, 3.677201669978553*^9, 3.6772017706765633`*^9, 
   3.677201860480605*^9, 3.677201923217605*^9, 3.6772038460716867`*^9, {
   3.6772038904374237`*^9, 3.677203913832082*^9}, 3.677207284967474*^9, 
   3.677463455147285*^9, 3.677768793953958*^9, {3.6777704532417727`*^9, 
   3.677770479995881*^9}, 3.793322210833473*^9, {3.793851493106496*^9, 
   3.793851502536063*^9}, 3.823227643908128*^9},
 CellLabel->
  "Out[1818]//TraditionalForm=",ExpressionUUID->"0f51f88f-b229-4278-8a9d-\
dc6eada74cf3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"ytest", ",", "t"}], "]"}], ",", 
   RowBox[{"t", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.677204701832028*^9, 3.677204794312545*^9}},
 CellLabel->
  "In[1819]:=",ExpressionUUID->"f6a0b448-e9c5-4cf8-8191-348d2227a5d8"],

Cell[BoxData["Indeterminate"], "Output",
 CellChangeTimes->{{3.677204746319141*^9, 3.677204794928237*^9}, 
   3.677207285023487*^9, 3.677463455332657*^9, 3.6777687939820147`*^9, {
   3.677770453288988*^9, 3.677770480026433*^9}, 3.7933222108866873`*^9, {
   3.793851493146657*^9, 3.793851502570711*^9}, 3.8232276439490957`*^9},
 CellLabel->
  "Out[1819]=",ExpressionUUID->"32d4e0b4-49e6-4e6c-9b6c-31c7e0822499"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SK4tfa", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"SK4tf", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Kp", "\[Rule]", 
        RowBox[{
         RowBox[{"3", 
          SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
       RowBox[{"Ki", "\[Rule]", 
        SuperscriptBox["a", "3"]}], ",", 
       RowBox[{"Kd", "\[Rule]", 
        RowBox[{"3", "a"}]}]}], "}"}]}], "/.", 
    RowBox[{"a", "\[Rule]", "2"}]}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.6772039285030746`*^9, 3.677203940828981*^9}, {
  3.677204055820921*^9, 3.677204056644253*^9}},
 CellLabel->
  "In[1820]:=",ExpressionUUID->"9f0c3d1b-52f2-4c9f-93b3-b99755db1f91"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox[
     RowBox[{
       RowBox[{"(", 
         RowBox[{"1", "+", 
           SuperscriptBox["s", "2"]}], ")"}], " ", 
       RowBox[{"(", 
         RowBox[{"8", "+", 
           RowBox[{"11", " ", "s"}], "+", 
           RowBox[{"6", " ", 
             SuperscriptBox["s", "2"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
        RowBox[{"2", "+", "s"}], ")"}], "3"]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{(1 + $CellContext`s^2) (8 + 11 $CellContext`s + 
           6 $CellContext`s^2)}}, (2 + $CellContext`s)^3}, $CellContext`s], 
      AutoDelete -> True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{(1 + $CellContext`s^2) (8 + 11 $CellContext`s + 
           6 $CellContext`s^2)}}, (2 + $CellContext`s)^3}, $CellContext`s]], 
     1, {}, {False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{(1 + $CellContext`s^2) (8 + 11 $CellContext`s + 
       6 $CellContext`s^2)}}, (2 + $CellContext`s)^3}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{
  3.677201283494677*^9, 3.67720163678906*^9, 3.677203846240567*^9, {
   3.677203919934787*^9, 3.6772039414007597`*^9}, 3.677204057418789*^9, 
   3.6772072851226273`*^9, 3.6774634554189053`*^9, 3.677768794088819*^9, {
   3.6777704533996058`*^9, 3.677770480127757*^9}, 3.793322210967161*^9, {
   3.793851493201704*^9, 3.793851502644403*^9}, 3.823227644003389*^9},
 CellLabel->
  "Out[1820]=",ExpressionUUID->"aa1a534a-2aca-4600-9b4a-13074009f5cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"utest", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"OutputResponse", "[", 
      RowBox[{"SK4tfa", ",", "1", ",", "t"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], " ", "//", "FullSimplify"}]}], ";", " ", 
  
  RowBox[{"utest", "//", "TraditionalForm"}]}]], "Input",
 CellChangeTimes->{{3.677204062433024*^9, 3.677204085986738*^9}, {
   3.677204156222558*^9, 3.677204156787757*^9}, 3.6772041880921993`*^9, {
   3.677204333480276*^9, 3.6772043869508753`*^9}},
 CellLabel->
  "In[1821]:=",ExpressionUUID->"855e57a8-5456-4b75-8191-c8446d517c8c"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "t"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["5", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"16", "-", 
         RowBox[{"5", " ", "t"}]}], ")"}], " ", "t"}], "-", "26"}], ")"}]}], 
   "+", "1"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.677204078402218*^9, 3.67720408830296*^9}, 
   3.677204159214472*^9, 3.677204190658637*^9, {3.677204335899328*^9, 
   3.677204387976405*^9}, 3.6772072853578787`*^9, 3.677463455649547*^9, 
   3.677768794319008*^9, {3.677770453634774*^9, 3.677770480371305*^9}, 
   3.7933222110893393`*^9, {3.793851493328269*^9, 3.793851502779065*^9}, 
   3.823227644175345*^9},
 CellLabel->
  "Out[1821]//TraditionalForm=",ExpressionUUID->"86c6df80-57dc-434b-9602-\
66c07fb2a3f5"]
}, Open  ]],

Cell["\<\
PID control: command tracking (step response), with feedforward\
\>", "Text",
 CellChangeTimes->{{3.676256123319852*^9, 3.6762561340117064`*^9}, {
  3.676256527464588*^9, 3.676256537807025*^9}, {3.676390134403613*^9, 
  3.676390134811151*^9}, {3.676432290911524*^9, 3.676432291046063*^9}, {
  3.676518622684082*^9, 3.67651863874605*^9}, {3.676860203476437*^9, 
  3.676860210090838*^9}, {3.6768624216287823`*^9, 3.676862426233543*^9}, {
  3.676862466093924*^9, 3.6768624681098413`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"9f0ce2db-f1f8-4c2a-8b27-6a57998ced9f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"F4", "=", 
    FractionBox["1", 
     RowBox[{" ", 
      RowBox[{"T4", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"s", "/", "a"}]}], ")"}], "2"]}]}]]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "the", " ", "feedforward", " ", "element", " ", "F4", " ", "needs", " ", 
    "to", " ", "be", " ", "biproper"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.676862470634843*^9, 3.676862479584135*^9}, {
  3.676862510307961*^9, 3.676862545681325*^9}, {3.676862578475119*^9, 
  3.676862591946381*^9}, {3.6768626550861588`*^9, 3.676862700107788*^9}, {
  3.676862924930871*^9, 3.676862928224642*^9}, {3.676862974965064*^9, 
  3.676863043104526*^9}, {3.676943508723237*^9, 3.676943511712461*^9}, {
  3.6769435563972588`*^9, 3.6769435717385597`*^9}, {3.791516690187745*^9, 
  3.791516691174893*^9}},
 CellLabel->
  "In[1822]:=",ExpressionUUID->"d2d776a9-538d-4dd8-8b46-33d0a02e1dd1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"T4a", "=", 
   RowBox[{"F4", " ", "T4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T4atf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"T4a", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SFK4", "=", 
    RowBox[{"SK4", " ", "F4"}]}], ";", " ", 
   RowBox[{"SFK4tf", "=", 
    RowBox[{"TransferFunctionModel", "[", 
     RowBox[{"SFK4", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ypida", "=", 
   RowBox[{
    RowBox[{"OutputResponse", "[", 
     RowBox[{
      RowBox[{"T4atf", "//.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Kp", "\[Rule]", 
          RowBox[{
           RowBox[{"3", 
            SuperscriptBox["a", "2"]}], "-", "1"}]}], ",", 
         RowBox[{"Ki", "\[Rule]", 
          SuperscriptBox["a", "3"]}], ",", 
         RowBox[{"Kd", "\[Rule]", 
          RowBox[{"3", "a"}]}], ",", 
         RowBox[{"a", "\[Rule]", "2"}]}], "}"}]}], ",", "step", ",", 
      "trange"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"upida", "=", 
   RowBox[{
    RowBox[{"OutputResponse", "[", 
     RowBox[{
      RowBox[{"SFK4tf", "/.", 
       RowBox[{"a", "\[Rule]", "2"}]}], ",", "step", ",", "trange"}], "]"}], 
    "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ypida", ",", "upida"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6768627074062967`*^9, 3.676862720070436*^9}, {
   3.67686281397927*^9, 3.676862886366935*^9}, {3.676863230285181*^9, 
   3.676863251706378*^9}, {3.676863314794487*^9, 3.676863381405813*^9}, {
   3.676863517096043*^9, 3.67686353002008*^9}, {3.676941435345442*^9, 
   3.676941573993987*^9}, {3.6769416124837523`*^9, 3.676941695618382*^9}, {
   3.67694302529777*^9, 3.676943051223188*^9}, {3.676943108101063*^9, 
   3.676943211535818*^9}, {3.676943310248893*^9, 3.6769433186707163`*^9}, {
   3.676943361108829*^9, 3.676943366378996*^9}, 3.676943951012031*^9, 
   3.676944087100445*^9, {3.677203836220895*^9, 3.677203837123721*^9}, {
   3.677207301131459*^9, 3.677207332129283*^9}},
 CellLabel->
  "In[1823]:=",ExpressionUUID->"ef04123c-c4ab-4193-a67a-008d0fe5c0b4"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd1Xk8Fl8XAHD7vj323fMgskSplEr3JJWsUSqylJREQhulUpSIkuxZixBC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       "]]},
     Annotation[#, "Charting`Private`Tag$671208#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd1nc8ld8fAPBr7733vQghlUoqnE+JkJDIiOzQkAb5GkW0rCSrYZWGkZZV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       "]]},
     Annotation[#, "Charting`Private`Tag$671208#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.676863340370306*^9, 3.676863381848548*^9}, {
   3.67686352641483*^9, 3.676863530492674*^9}, {3.676941620445503*^9, 
   3.6769416999510508`*^9}, 3.6769417878060627`*^9, 3.676943052503591*^9, {
   3.676943084721781*^9, 3.676943111963891*^9}, {3.676943172718781*^9, 
   3.676943212122427*^9}, {3.676943310801765*^9, 3.676943319087628*^9}, {
   3.6769433618094387`*^9, 3.6769433669811687`*^9}, 3.676943515733314*^9, 
   3.676943577523851*^9, 3.676943956791473*^9, 3.676944055217182*^9, 
   3.676944092035901*^9, 3.67708828947618*^9, 3.6771821733047113`*^9, 
   3.677182584592206*^9, 3.677187442203373*^9, 3.677201636885704*^9, 
   3.677203846337997*^9, {3.677207285460362*^9, 3.677207333096538*^9}, 
   3.6774634557540483`*^9, 3.677768794488146*^9, {3.677770453811016*^9, 
   3.6777704805298567`*^9}, 3.7933222111535263`*^9, {3.7938514934109087`*^9, 
   3.7938515028653173`*^9}, 3.8232276443341637`*^9},
 CellLabel->
  "Out[1828]=",ExpressionUUID->"f6b6e413-3faa-407d-8f07-e6ae96c55249"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"T4atf", ",", "SFK4"}], "}"}], "/.", 
   RowBox[{"a", "\[Rule]", "2"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.676863286002529*^9, 3.676863286666284*^9}, {
   3.676863424410009*^9, 3.6768634559346857`*^9}, {3.6768636526389503`*^9, 
   3.676863660453395*^9}, 3.676944138117234*^9, {3.67720399783318*^9, 
   3.677204037052644*^9}, {3.6772065687381477`*^9, 3.677206570607246*^9}, {
   3.677206726751233*^9, 3.6772067371576557`*^9}},
 CellLabel->
  "In[1829]:=",ExpressionUUID->"dc0780d1-ec62-4697-878f-688b6b556d0d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    TemplateBox[{
      FractionBox["4", 
       SuperscriptBox[
        RowBox[{"(", 
          RowBox[{"2", "+", "s"}], ")"}], "2"]], 
      InterpretationBox["\[InvisibleSpace]", None], {
      TransferFunctionModel, {
       False, False, {False, False}}, $Failed, {{
        Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}}, 
       InterpretationBox[#, 
        TransferFunctionModel[{{{
          4}}, (2 + $CellContext`s)^2}, $CellContext`s], AutoDelete -> True, 
        Editable -> True, BaseStyle -> 
        "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
       Control`CountStates[
        TransferFunctionModel[{{{
          4}}, (2 + $CellContext`s)^2}, $CellContext`s]], 1, {}, {
       False, False}, False, Automatic, None, Automatic}, {}},
     "TransferFunctionModelFull",
     BaseStyle->{NumberMarks -> False},
     DisplayFunction->(TagBox[
       SubsuperscriptBox[
        RowBox[{"(", 
          
          GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
           GridBoxDividers -> {
            "Rows" -> {False, {False}, False}, 
             "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
           "SystemsModelGrid00"], ")"}], #2, 
        ButtonBox[
         GraphicsBox[{
           
           RectangleBox[{0, 0}, DefaultBaseStyle -> 
            "SystemsModelSuperscript"], 
           InsetBox[
            StyleBox[
            "\[ScriptCapitalT]", DefaultBaseStyle -> 
             "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
         ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
           ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
         None], MultilineFunction -> None], 
       EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
             FrontEnd`Value[
              FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
         True}]]& ),
     InterpretationFunction->(
      RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
        RowBox[{"{", 
          RowBox[{"{", 
            TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", 
        ",", "SamplingPeriod", "->", 
        RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
     Tooltip->TransferFunctionModel],
    TransferFunctionModel[{{{4}}, (2 + $CellContext`s)^2}, $CellContext`s],
    AutoDelete->True,
    BaseStyle->"TransferFunctionModelMinimal",
    Editable->True], ",", 
   FractionBox[
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["s", "2"]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "+", "s"}], ")"}], "2"]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.676862887793323*^9, 3.6768629334664593`*^9, {3.6768630047513247`*^9, 
   3.676863045573859*^9}, 3.676863252851549*^9, 3.6768632870050297`*^9, {
   3.676863425022461*^9, 3.676863456503584*^9}, 3.676863552700431*^9, 
   3.676863661282463*^9, 3.676941673739051*^9, 3.676941787951723*^9, 
   3.6769430847558002`*^9, 3.676943577544424*^9, 3.67694395683952*^9, 
   3.6769440552823563`*^9, 3.6769440920996113`*^9, 3.6769441386747*^9, 
   3.6771821733443613`*^9, 3.677182584633905*^9, 3.677187442244882*^9, 
   3.6772016369326153`*^9, 3.677203846381617*^9, {3.677204001346397*^9, 
   3.6772040375498533`*^9}, 3.677206570983317*^9, {3.677206727487701*^9, 
   3.677206740733493*^9}, 3.677207285589492*^9, 3.6774634558403177`*^9, 
   3.6777687945823727`*^9, {3.67777045390863*^9, 3.677770480622116*^9}, 
   3.7933222112324142`*^9, {3.793851493464587*^9, 3.793851502918696*^9}, 
   3.823227644388749*^9},
 CellLabel->
  "Out[1829]=",ExpressionUUID->"d925ee75-870a-432c-8294-4af5fc8022ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"OutputResponse", "[", 
       RowBox[{
        RowBox[{"T4atf", "/.", 
         RowBox[{"a", "\[Rule]", "2"}]}], ",", "step", ",", "t"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"OutputResponse", "[", 
      RowBox[{
       RowBox[{"SFK4tf", "/.", 
        RowBox[{"a", "\[Rule]", "2"}]}], ",", "step", ",", "t"}], "]"}]}], 
    "}"}], " ", "//", "FullSimplify"}], "//", "TraditionalForm"}]], "Input",
 CellChangeTimes->{{3.676943223037129*^9, 3.6769432318593817`*^9}, {
   3.676943292872799*^9, 3.676943293415347*^9}, 3.676943356484541*^9, {
   3.6769521041649113`*^9, 3.676952141124073*^9}, 3.677203837972032*^9, {
   3.677206714936034*^9, 3.677206719550173*^9}, {3.677206766116406*^9, 
   3.6772067942752037`*^9}},
 CellLabel->
  "In[1830]:=",ExpressionUUID->"b827a3f9-3c5e-447c-8527-ee4099093057"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     TemplateBox[{
       RowBox[{"t"}]},
      "UnitStepSeq"], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "t"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "t"}], "+", "1"}], ")"}], " ", 
      TemplateBox[{
        RowBox[{"t"}]},
       "UnitStepSeq"]}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "t"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"10", " ", "t"}]}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "t"}]], "+", "3"}], ")"}], " ", 
      TemplateBox[{
        RowBox[{"t"}]},
       "UnitStepSeq"]}], "}"}]}], "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.6769432266748667`*^9, 3.6769432324386387`*^9}, 
   3.676943294156443*^9, 3.6769433575500803`*^9, 3.676943577810012*^9, 
   3.676943957031227*^9, 3.676944055515032*^9, 3.676944092292334*^9, {
   3.676952133164887*^9, 3.67695214179174*^9}, 3.677088289780767*^9, 
   3.67718217359799*^9, {3.677182572402452*^9, 3.677182584920532*^9}, 
   3.677187442528214*^9, 3.6772016371969757`*^9, 3.677203846643539*^9, {
   3.6772067673697777`*^9, 3.677206794816297*^9}, 3.677207285967536*^9, 
   3.67746345614499*^9, 3.677768794904138*^9, {3.677770454242188*^9, 
   3.677770480967134*^9}, 3.793322211403563*^9, {3.793851493657827*^9, 
   3.7938515031090927`*^9}, 3.82322764459888*^9},
 CellLabel->
  "Out[1830]//TraditionalForm=",ExpressionUUID->"74366e7c-963d-43cc-9ab3-\
6127977d1d00"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{775, 638},
WindowMargins->{{102, Automatic}, {Automatic, 20}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"2c9aced6-2427-40ff-a385-1dab22bf85a8"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 535, 10, 105, "Section",ExpressionUUID->"9bd9fefe-f8f2-4dd9-bc09-c38d9a67cd28"],
Cell[1117, 34, 3077, 66, 204, "Input",ExpressionUUID->"65e98b6e-d892-43a0-9c77-4d90f85fe95d"],
Cell[4197, 102, 207, 4, 52, "Text",ExpressionUUID->"9a119fa1-f177-4d48-8fc4-7c40cf1badbf"],
Cell[CellGroupData[{
Cell[4429, 110, 5452, 145, 388, "Input",ExpressionUUID->"5d542e41-ff5d-4be9-a72b-e39fc92d684f"],
Cell[9884, 257, 175570, 2917, 192, "Output",ExpressionUUID->"6bbb67f5-54d2-424c-8f90-20822ec6573e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[185491, 3179, 687, 16, 52, "Input",ExpressionUUID->"7c74e168-3bea-4df3-a89a-682ab318c7d7"],
Cell[186181, 3197, 1637, 46, 89, "Output",ExpressionUUID->"d008526a-5737-4b9c-9cd6-e16d97cbd7d9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[187855, 3248, 1187, 31, 52, "Input",ExpressionUUID->"038ba38a-8982-43e5-825f-536104ed9c62"],
Cell[189045, 3281, 964, 27, 71, "Output",ExpressionUUID->"3c8947ef-a20b-488d-8402-a4e59e3e71a1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[190046, 3313, 277, 6, 30, "Input",ExpressionUUID->"20020af2-8112-44fd-baf3-d07b4f54ea6f"],
Cell[190326, 3321, 1396, 27, 54, "Output",ExpressionUUID->"6e09e546-4a11-4def-a506-772dba49c37f"]
}, Open  ]],
Cell[191737, 3351, 308, 6, 52, "Text",ExpressionUUID->"4775a3c5-3c4a-484d-aa5d-38e64b15ab7f"],
Cell[CellGroupData[{
Cell[192070, 3361, 3686, 105, 302, "Input",ExpressionUUID->"7aafc2b1-de7a-4ae1-b42c-a905e6b43e3d"],
Cell[195759, 3468, 57171, 975, 190, "Output",ExpressionUUID->"19373a27-7c07-4831-9349-59972b99b155"]
}, Open  ]],
Cell[CellGroupData[{
Cell[252967, 4448, 730, 20, 52, "Input",ExpressionUUID->"053003a9-98f2-44af-8131-22eee24b5edf"],
Cell[253700, 4470, 1842, 35, 53, "Output",ExpressionUUID->"9d0ead8e-4e0c-4f32-8b11-404a3ff20bed"]
}, Open  ]],
Cell[CellGroupData[{
Cell[255579, 4510, 1225, 28, 73, "Input",ExpressionUUID->"6610d31e-5652-43cb-9ff2-5b22bcad6dd4"],
Cell[256807, 4540, 2413, 73, 133, "Output",ExpressionUUID->"4625d37c-38c6-494e-88b5-47efc3a31224"]
}, Open  ]],
Cell[CellGroupData[{
Cell[259257, 4618, 1396, 39, 52, "Input",ExpressionUUID->"95e0b675-7ca6-4b52-bd2e-e5ea79f08e59"],
Cell[260656, 4659, 1411, 40, 46, "Output",ExpressionUUID->"7c45103f-7945-4a73-af30-0f252b14f73f"]
}, Open  ]],
Cell[262082, 4702, 341, 6, 52, "Text",ExpressionUUID->"63e733b7-036f-499d-a3df-030eefae8655"],
Cell[CellGroupData[{
Cell[262448, 4712, 3946, 114, 328, "Input",ExpressionUUID->"d1a9b2ee-73bb-4134-b7a2-8d7c90ddfb9f"],
Cell[266397, 4828, 84604, 1429, 192, "Output",ExpressionUUID->"54c83f86-7322-4de8-b9ce-a58ad7e175b4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[351038, 6262, 930, 25, 52, "Input",ExpressionUUID->"934d3e82-6e2b-4222-b5d8-2d09f3a1348a"],
Cell[351971, 6289, 1795, 37, 55, "Output",ExpressionUUID->"32c4245e-4908-4a8d-808e-092f6c62c419"]
}, Open  ]],
Cell[CellGroupData[{
Cell[353803, 6331, 481, 14, 34, "Input",ExpressionUUID->"9bbea276-e2f4-4a0c-a6b1-ad9de9cd3ccd"],
Cell[354287, 6347, 1786, 39, 70, "Output",ExpressionUUID->"45e0c561-00d1-4f21-9277-dce0c75f7c90"]
}, Open  ]],
Cell[CellGroupData[{
Cell[356110, 6391, 939, 25, 66, "Input",ExpressionUUID->"870fe140-c778-420f-848f-fddc466fc64f"],
Cell[357052, 6418, 1718, 49, 69, "Output",ExpressionUUID->"f8c4c833-e488-4d97-ab72-034afd8aaa69"]
}, Open  ]],
Cell[CellGroupData[{
Cell[358807, 6472, 2265, 65, 104, "Input",ExpressionUUID->"877dc4e4-17ff-4c90-9dd3-fc5ae95f9a3f"],
Cell[361075, 6539, 1184, 41, 52, "Output",ExpressionUUID->"f5326129-551e-4392-a5c2-ee67110a1322"]
}, Open  ]],
Cell[362274, 6583, 473, 8, 52, "Text",ExpressionUUID->"9d73bba5-da20-4880-bbec-792a380ec867"],
Cell[CellGroupData[{
Cell[362772, 6595, 1994, 58, 136, "Input",ExpressionUUID->"9461ab1b-7c58-471c-b45f-5cb8f4a15df8"],
Cell[364769, 6655, 32917, 563, 239, "Output",ExpressionUUID->"48df39b7-54f8-495c-abc4-514a99345cf0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[397723, 7223, 556, 15, 30, "Input",ExpressionUUID->"0a3dff5b-38b5-4321-857d-29033526d0b3"],
Cell[398282, 7240, 1262, 24, 54, "Output",ExpressionUUID->"af523d27-0dae-4535-b7d1-b91b2be33b1d"]
}, Open  ]],
Cell[399559, 7267, 801, 21, 59, "Input",ExpressionUUID->"c58ab069-c802-42ea-bf4d-1de12325070a"],
Cell[400363, 7290, 428, 7, 52, "Text",ExpressionUUID->"197597c9-a571-4b57-bb78-0dea02458217"],
Cell[CellGroupData[{
Cell[400816, 7301, 4702, 136, 372, "Input",ExpressionUUID->"ecfc144e-c5e3-4ede-89c5-c1dfdc484bde"],
Cell[405521, 7439, 74570, 1260, 192, "Output",ExpressionUUID->"860305e4-66ce-4319-b233-f2ed67b81102"]
}, Open  ]],
Cell[CellGroupData[{
Cell[480128, 8704, 162, 4, 30, "Input",ExpressionUUID->"497d5b1d-3e7e-4d1f-925c-fe80d1aea9e5"],
Cell[480293, 8710, 1659, 36, 57, "Output",ExpressionUUID->"6e37da1e-5cc1-40e2-9ad2-83f710c63131"]
}, Open  ]],
Cell[CellGroupData[{
Cell[481989, 8751, 762, 20, 33, "Input",ExpressionUUID->"42962125-494c-492b-95ec-91b20eecb229"],
Cell[482754, 8773, 1674, 34, 57, "Output",ExpressionUUID->"63369006-6f91-4fc3-b069-acf0c8541518"]
}, Open  ]],
Cell[CellGroupData[{
Cell[484465, 8812, 1631, 42, 100, "Input",ExpressionUUID->"bd6d9a15-4bb3-4654-868e-5435175e3dab"],
Cell[486099, 8856, 1327, 41, 50, "Output",ExpressionUUID->"96973d3e-b8e7-4ddd-91f7-41cd7d693780"]
}, Open  ]],
Cell[CellGroupData[{
Cell[487463, 8902, 1749, 46, 100, "Input",ExpressionUUID->"e1c5bfb1-feba-453a-a89d-84205d7b0d1f"],
Cell[489215, 8950, 1722, 53, 50, "Output",ExpressionUUID->"7a89bc60-a54d-43da-935e-26b26cb186e9"]
}, Open  ]],
Cell[490952, 9006, 482, 8, 52, "Text",ExpressionUUID->"974c36b0-0b7f-414a-be31-ec79c4b9ec66"],
Cell[491437, 9016, 828, 23, 111, "Input",ExpressionUUID->"9adf6503-dd14-4617-a184-b3dcf761ee8a"],
Cell[CellGroupData[{
Cell[492290, 9043, 2129, 56, 119, "Input",ExpressionUUID->"a08e7e67-6995-4aec-b045-a97d95dc9abf"],
Cell[494422, 9101, 433, 11, 24, "Message",ExpressionUUID->"ec92af23-2804-4ec7-b6ed-8f5a9bed1929"],
Cell[494858, 9114, 16180, 282, 250, "Output",ExpressionUUID->"a4a04507-668a-4970-9dc5-1f3bd51b8ad0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[511075, 9401, 676, 19, 33, "Input",ExpressionUUID->"802dd245-10d5-44f3-93c9-bc9ce494abed"],
Cell[511754, 9422, 1488, 38, 59, "Output",ExpressionUUID->"7092d396-43a0-4b96-98a5-ef3f69952a0e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[513279, 9465, 690, 19, 33, "Input",ExpressionUUID->"abdd52dd-2399-4b18-8f5a-f7fc833e8360"],
Cell[513972, 9486, 3026, 67, 64, "Output",ExpressionUUID->"3e649472-a3e9-4d38-8ade-8ae2065dc8f4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[517035, 9558, 703, 16, 52, "Input",ExpressionUUID->"05348777-84e2-44ec-bfa5-bc1a109492a4"],
Cell[517741, 9576, 1167, 30, 61, "Output",ExpressionUUID->"0f51f88f-b229-4278-8a9d-dc6eada74cf3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[518945, 9611, 319, 8, 30, "Input",ExpressionUUID->"f6a0b448-e9c5-4cf8-8191-348d2227a5d8"],
Cell[519267, 9621, 410, 6, 34, "Output",ExpressionUUID->"32d4e0b4-49e6-4e6c-9b6c-31c7e0822499"]
}, Open  ]],
Cell[CellGroupData[{
Cell[519714, 9632, 680, 19, 33, "Input",ExpressionUUID->"9f0c3d1b-52f2-4c9f-93b3-b99755db1f91"],
Cell[520397, 9653, 3319, 73, 66, "Output",ExpressionUUID->"aa1a534a-2aca-4600-9b4a-13074009f5cf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[523753, 9731, 585, 14, 52, "Input",ExpressionUUID->"855e57a8-5456-4b75-8191-c8446d517c8c"],
Cell[524341, 9747, 882, 23, 61, "Output",ExpressionUUID->"86c6df80-57dc-434b-9602-66c07fb2a3f5"]
}, Open  ]],
Cell[525238, 9773, 598, 11, 52, "Text",ExpressionUUID->"9f0ce2db-f1f8-4c2a-8b27-6a57998ced9f"],
Cell[525839, 9786, 985, 23, 51, "Input",ExpressionUUID->"d2d776a9-538d-4dd8-8b46-33d0a02e1dd1"],
Cell[CellGroupData[{
Cell[526849, 9813, 2437, 61, 201, "Input",ExpressionUUID->"ef04123c-c4ab-4193-a67a-008d0fe5c0b4"],
Cell[529289, 9876, 26087, 449, 243, "Output",ExpressionUUID->"f6b6e413-3faa-407d-8f07-e6ae96c55249"]
}, Open  ]],
Cell[CellGroupData[{
Cell[555413, 10330, 592, 12, 30, "Input",ExpressionUUID->"dc0780d1-ec62-4697-878f-688b6b556d0d"],
Cell[556008, 10344, 3752, 84, 62, "Output",ExpressionUUID->"d925ee75-870a-432c-8294-4af5fc8022ae"]
}, Open  ]],
Cell[CellGroupData[{
Cell[559797, 10433, 925, 22, 52, "Input",ExpressionUUID->"b827a3f9-3c5e-447c-8527-ee4099093057"],
Cell[560725, 10457, 1672, 44, 99, "Output",ExpressionUUID->"74366e7c-963d-43cc-9ab3-6127977d1d00"]
}, Open  ]]
}, Open  ]]
}
]
*)

