(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    342754,       6909]
NotebookOptionsPosition[    337349,       6813]
NotebookOutlinePosition[    337745,       6829]
CellTagsIndexPosition[    337702,       6826]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["Rescuing the shower :  change the DC coefs!   \
(Problem 3.24)",
 FontSize->24]], "Section",
 CellChangeTimes->{{3.5047750383747597`*^9, 3.5047750654746437`*^9}, {
  3.7933032299004183`*^9, 3.793303239349784*^9}},
 FontSize->12,ExpressionUUID->"34c7fbd8-4ef0-42b2-8e04-6e582f05eb5d"],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 FontSize->12,
 CellLabel->
  "In[2097]:=",ExpressionUUID->"80d1cc00-918b-41f7-8496-6fdda952b42c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"I0", " ", "=", "  ", 
   RowBox[{"IdentityMatrix", "[", "2", "]"}]}], ";", " ", 
  RowBox[{"TraditionalForm", "[", "I0", "]"}]}]], "Input",
 CellChangeTimes->{{3.793303249472714*^9, 3.793303274009611*^9}},
 FontSize->12,
 CellLabel->
  "In[2098]:=",ExpressionUUID->"34c6cd69-3d5f-4f37-a1c8-c64e34647e0e"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0"},
     {"0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.504786613239126*^9, 3.504786716108246*^9, 3.504786818344322*^9, 
   3.504786919017359*^9, {3.504787164439549*^9, 3.504787198418227*^9}, 
   3.504787239041465*^9, 3.504787333819219*^9, 3.5047874098139973`*^9, 
   3.504787463469681*^9, {3.504789269892642*^9, 3.504789291005068*^9}, 
   3.5047893298835773`*^9, {3.5047893965360613`*^9, 3.504789463037787*^9}, 
   3.504789521387411*^9, 3.504789569488926*^9, 3.5047896059513597`*^9, {
   3.504789640754403*^9, 3.504789668227417*^9}, {3.504789703213146*^9, 
   3.504789726796082*^9}, 3.5047899965415707`*^9, 3.504790043535324*^9, 
   3.5047901236218147`*^9, 3.504790177813118*^9, 3.504790208807873*^9, 
   3.504790304543604*^9, {3.504790350465234*^9, 3.504790394979066*^9}, {
   3.504791021266182*^9, 3.504791040000148*^9}, 3.504791331861019*^9, 
   3.504791367233227*^9, {3.504791397262136*^9, 3.504791455997707*^9}, {
   3.50479149284584*^9, 3.504791503563854*^9}, 3.504805902982644*^9, 
   3.528837649156755*^9, {3.793303254391609*^9, 3.793303274540419*^9}, 
   3.793303439424448*^9, 3.793303496478135*^9, 3.793324697553512*^9, 
   3.793324746214397*^9, 3.7938511814042273`*^9, 3.823227966161502*^9},
 FontSize->12,
 CellLabel->
  "Out[2098]//TraditionalForm=",ExpressionUUID->"02c34d0a-fe14-4230-b487-\
fbed144a78ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"G3", " ", "=", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", GridBox[{
       {
        FractionBox["1", 
         RowBox[{"1", "+", " ", "s"}]], 
        FractionBox[
         RowBox[{"1", "/", "2"}], 
         RowBox[{"1", "+", " ", 
          RowBox[{"\[Tau]", " ", "s"}]}]]},
       {
        FractionBox[
         RowBox[{"1", "/", "2"}], 
         RowBox[{"1", "+", "  ", 
          RowBox[{"\[Tau]", " ", "s"}]}]], 
        FractionBox["1", 
         RowBox[{"1", "+", "  ", "s"}]]}
      }], ")"}], " ", "/.", " ", 
    RowBox[{"\[Tau]", " ", "\[Rule]", " ", 
     FractionBox["1", "2"]}]}], "//", " ", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.504775092735155*^9, 3.5047751366237392`*^9}, {
  3.793303285192966*^9, 3.793303285990522*^9}},
 FontSize->12,
 CellLabel->
  "In[2099]:=",ExpressionUUID->"8f36a4b4-7849-4e28-a995-d122a12ddecb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "+", "s"}]], ",", 
     FractionBox["1", 
      RowBox[{"2", "+", "s"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "+", "s"}]], ",", 
     FractionBox["1", 
      RowBox[{"1", "+", "s"}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.504775128712162*^9, 3.504775137032984*^9}, {
   3.504776095422332*^9, 3.504776113256727*^9}, 3.504776233172512*^9, {
   3.50477626944735*^9, 3.504776316091763*^9}, {3.504776353264553*^9, 
   3.5047764288826942`*^9}, 3.5047764735644913`*^9, 3.5047765574772367`*^9, 
   3.504776825651104*^9, 3.504780231909463*^9, 3.5047867161580057`*^9, 
   3.504786818403769*^9, 3.504786919065673*^9, {3.504787164479035*^9, 
   3.504787198476416*^9}, 3.50478723909798*^9, 3.504787333893693*^9, 
   3.5047874098881063`*^9, 3.5047874635217752`*^9, {3.5047892699453573`*^9, 
   3.504789291063278*^9}, 3.5047893299588833`*^9, {3.504789396610527*^9, 
   3.5047894630961657`*^9}, 3.504789521461952*^9, 3.504789569547564*^9, 
   3.5047896060263147`*^9, {3.504789640794633*^9, 3.5047896682833977`*^9}, {
   3.504789703287952*^9, 3.504789726853244*^9}, 3.5047899965987997`*^9, 
   3.5047900435942583`*^9, 3.504790123680614*^9, 3.504790177869844*^9, 
   3.5047902088667717`*^9, 3.504790304600528*^9, {3.504790350525605*^9, 
   3.504790395020153*^9}, {3.50479102132331*^9, 3.504791040054175*^9}, 
   3.5047913319215527`*^9, 3.5047913672771883`*^9, {3.504791397304718*^9, 
   3.504791456072275*^9}, {3.504791492904245*^9, 3.5047915036055317`*^9}, 
   3.504805903056427*^9, 3.528837649249447*^9, 3.7933032869698477`*^9, 
   3.793303439433427*^9, 3.7933034964871883`*^9, 3.793324697562825*^9, 
   3.7933247462223063`*^9, 3.793851181415194*^9, 3.823227966168997*^9},
 FontSize->12,
 CellLabel->
  "Out[2099]=",ExpressionUUID->"3e0789d2-c0cb-449d-a2ca-158286de61ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValuePlot", "[", "G3", "]"}]], "Input",
 CellChangeTimes->{{3.504775257680951*^9, 3.504775262957139*^9}},
 FontSize->12,
 CellLabel->
  "In[2100]:=",ExpressionUUID->"c2021ab2-ae8a-4ca0-8309-560262e75cc6"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV13c4Fe4XAPBrZdybyEhIViF7xbXeV0JLKhmlSHYIJauhrzQohZDsUUlF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       "]]},
     Annotation[#, "Charting`Private`Tag$778581#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Hk01V0XB3CJVIoS9TN2TZkiYygc88wlpTKkUmahKEkhVJQhc4kMjSTF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       "]]},
     Annotation[#, "Charting`Private`Tag$778581#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-1.3010299956639813`, -64.09595650956126},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
      Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
      Part[#, 2]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{{{-80., 
       FormBox[
        RowBox[{"-", "80"}], TraditionalForm]}, {-60., 
       FormBox[
        RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
       FormBox[
        RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
       FormBox[
        RowBox[{"-", "20"}], TraditionalForm]}, {0., 
       FormBox["0", TraditionalForm]}, {20., 
       FormBox["20", TraditionalForm]}, {-80., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-75., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-70., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-65., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-60., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-60., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-55., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-50., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-45., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-40., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-40., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-35., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-30., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-25., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-15., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-10., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-5., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {15., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {20., 
       FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, {{-80., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-60., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-40., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-20., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {20., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-80., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-75., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-70., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-65., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-60., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-60., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-55., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-50., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-45., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-40., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-40., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-35., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-30., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-25., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-15., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-10., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-5., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {15., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {20., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}, {{{-1., 
       FormBox["0.1`", TraditionalForm]}, {0., 
       FormBox["1", TraditionalForm]}, {1., 
       FormBox["10", TraditionalForm]}, {2., 
       FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5228787452803375, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.3979400086720376, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.3010299956639812, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2218487496163563, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.1549019599857432, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.09691001300805639, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.04575749056067506, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.3010299956639812, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.47712125471966244`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6020599913279624, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6989700043360189, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.7781512503836436, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.8450980400142568, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.9030899869919435, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.9542425094393249, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3010299956639813`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.4771212547196624`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6020599913279623`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6989700043360187`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.7781512503836436`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.845098040014257, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9030899869919435`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.954242509439325, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-1., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], 
        TraditionalForm]}, {-0.6989700043360187, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5228787452803375, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.3979400086720376, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.3010299956639812, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2218487496163563, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.1549019599857432, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.09691001300805639, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.04575749056067506, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.3010299956639812, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.47712125471966244`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6020599913279624, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6989700043360189, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.7781512503836436, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.8450980400142568, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.9030899869919435, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.9542425094393249, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3010299956639813`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.4771212547196624`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6020599913279623`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6989700043360187`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.7781512503836436`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.845098040014257, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9030899869919435`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.954242509439325, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{-1.3010299956639813`, 
   1.6020599913279623`}, {-64.09595650956126, 3.513090690514465}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{{{-1., 
      FormBox["0.1`", TraditionalForm]}, {0., 
      FormBox["1", TraditionalForm]}, {1., 
      FormBox["10", TraditionalForm]}, {2., 
      FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.5228787452803375, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.3979400086720376, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.3010299956639812, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2218487496163563, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.1549019599857432, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.09691001300805639, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.04575749056067506, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.3010299956639812, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.47712125471966244`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6020599913279624, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6989700043360189, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.7781512503836436, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.8450980400142568, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.9030899869919435, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.9542425094393249, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.3010299956639813`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.4771212547196624`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.6020599913279623`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.6989700043360187`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.7781512503836436`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.845098040014257, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.9030899869919435`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.954242509439325, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}, {{-80., 
      FormBox[
       RowBox[{"-", "80"}], TraditionalForm]}, {-60., 
      FormBox[
       RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
      FormBox[
       RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
      FormBox[
       RowBox[{"-", "20"}], TraditionalForm]}, {0., 
      FormBox["0", TraditionalForm]}, {20., 
      FormBox["20", TraditionalForm]}, {-80., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-75., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-70., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-65., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-60., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-60., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-55., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-50., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-45., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-40., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-40., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-35., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-30., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-25., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-20., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-20., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-15., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-10., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-5., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {0., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {0., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {5., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {10., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {15., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {20., 
      FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}}}]], "Output",
 CellChangeTimes->{
  3.5047752647313643`*^9, {3.5047760956092854`*^9, 3.504776113435239*^9}, 
   3.5047762333830357`*^9, {3.504776269624001*^9, 3.504776316268437*^9}, {
   3.504776353443174*^9, 3.504776429059457*^9}, 3.504776473740367*^9, 
   3.504776557652802*^9, 3.504776825830884*^9, 3.504780232089139*^9, 
   3.504786716339967*^9, 3.504786818584297*^9, 3.504786919245775*^9, {
   3.504787164728191*^9, 3.504787198655611*^9}, 3.504787239276888*^9, 
   3.50478733407504*^9, 3.50478741006849*^9, 3.504787463708571*^9, {
   3.504789270124215*^9, 3.504789291240531*^9}, 3.5047893301381273`*^9, {
   3.504789396791486*^9, 3.5047894632747173`*^9}, 3.504789521641653*^9, 
   3.5047895697279053`*^9, 3.504789606206438*^9, {3.504789640976489*^9, 
   3.504789668507135*^9}, {3.504789703465466*^9, 3.5047897270311317`*^9}, 
   3.504789996776226*^9, 3.504790043778718*^9, 3.504790123861895*^9, 
   3.504790178111876*^9, 3.504790209045113*^9, 3.504790304780299*^9, {
   3.5047903507069063`*^9, 3.504790395199448*^9}, {3.5047910214995947`*^9, 
   3.504791040234264*^9}, 3.504791332100477*^9, 3.5047913674541473`*^9, {
   3.5047913974829617`*^9, 3.504791456251587*^9}, {3.504791493082363*^9, 
   3.504791503783621*^9}, 3.504805903323615*^9, 3.528837650026428*^9, 
   3.793303439571013*^9, 3.793303496648878*^9, 3.7933246977058363`*^9, 
   3.793324746377191*^9, 3.7938511815757504`*^9, 3.823227966322442*^9},
 FontSize->12,
 CellLabel->
  "Out[2100]=",ExpressionUUID->"2b4a6168-bc51-465b-ba26-98cd3164a66d"]
}, Open  ]],

Cell["\<\
Note the divergence of the condition number as s \[RightArrow] \[Infinity];  \
that' s ok because we control only up to a finite bandwith.
By contrast, a divergence at s \[RightArrow] 0 is bad because we do care \
about DC response.\
\>", "Text",
 CellChangeTimes->{{3.5047861635311728`*^9, 3.504786233739388*^9}, {
  3.504786265186211*^9, 3.5047862822102222`*^9}, {3.793303299496004*^9, 
  3.7933033025799723`*^9}},
 FontSize->12,ExpressionUUID->"04dadf28-a6ab-4811-a238-007c5afb646a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexExpand", "[", 
   RowBox[{"SingularValueList", "[", 
    RowBox[{"G3", "/.", 
     RowBox[{"s", "\[Rule]", 
      RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]}]}], "]"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.52883830650807*^9, 3.528838362841063*^9}, {
  3.793303313204295*^9, 3.7933033145080957`*^9}},
 FontSize->12,
 CellLabel->
  "In[2101]:=",ExpressionUUID->"b009454a-d2c0-451a-9f31-ac5932038544"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
      RowBox[{"Arg", "[", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{"\[Omega]", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "\[ImaginaryI]"}], "+", "\[Omega]"}], 
             ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{
            RowBox[{"Conjugate", "[", "\[Omega]", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "\[ImaginaryI]"}], "+", 
              RowBox[{"Conjugate", "[", "\[Omega]", "]"}]}], ")"}]}]}], 
          ")"}]}]], "]"}]}]], " ", 
    SqrtBox[
     FractionBox["1", 
      RowBox[{"4", "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["\[Omega]", "2"]}], "+", 
       SuperscriptBox["\[Omega]", "4"]}]]]}], ",", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
      RowBox[{"Arg", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", "\[ImaginaryI]"}], "+", 
           RowBox[{"2", " ", "\[Omega]"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "\[ImaginaryI]"}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"Conjugate", "[", "\[Omega]", "]"}]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{"\[Omega]", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "\[ImaginaryI]"}], "+", "\[Omega]"}], 
             ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{
            RowBox[{"Conjugate", "[", "\[Omega]", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "\[ImaginaryI]"}], "+", 
              RowBox[{"Conjugate", "[", "\[Omega]", "]"}]}], ")"}]}]}], 
          ")"}]}]], "]"}]}]], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{"9", "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["\[Omega]", "2"]}]}], 
      RowBox[{"4", "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["\[Omega]", "2"]}], "+", 
       SuperscriptBox["\[Omega]", "4"]}]]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.528838316392544*^9, 3.528838365993211*^9}, 
   3.7933033169336433`*^9, 3.7933034396080513`*^9, 3.793303496686301*^9, 
   3.793324698596158*^9, 3.793324746430773*^9, 3.793851182438661*^9, 
   3.823227967207405*^9},
 FontSize->12,
 CellLabel->
  "Out[2101]=",ExpressionUUID->"2de95c1a-32fc-4351-b9ff-e7b9371be823"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"G3inv", " ", "=", " ", 
   RowBox[{
    RowBox[{"Inverse", "[", "G3", "]"}], " ", "//", " ", "Simplify"}]}], ";", 
  
  RowBox[{"TraditionalForm", "[", "G3inv", "]"}]}]], "Input",
 CellChangeTimes->{{3.504775173370871*^9, 3.5047751754160023`*^9}, {
  3.793303325142147*^9, 3.793303328863166*^9}},
 FontSize->12,
 CellLabel->
  "In[2102]:=",ExpressionUUID->"5a006b56-b528-4f18-974b-4629ad021b0d"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"s", "+", "1"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"s", "+", "2"}], ")"}], "2"]}], 
       RowBox[{
        RowBox[{"2", " ", "s"}], "+", "3"}]], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"s", "+", "1"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"s", "+", "2"}], ")"}]}], 
        RowBox[{
         RowBox[{"2", " ", "s"}], "+", "3"}]]}]},
     {
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"s", "+", "1"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"s", "+", "2"}], ")"}]}], 
        RowBox[{
         RowBox[{"2", " ", "s"}], "+", "3"}]]}], 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"s", "+", "1"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"s", "+", "2"}], ")"}], "2"]}], 
       RowBox[{
        RowBox[{"2", " ", "s"}], "+", "3"}]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.5047751760927887`*^9, {3.504776095724936*^9, 3.50477611353753*^9}, 
   3.5047762334944077`*^9, {3.50477626972437*^9, 3.504776316409855*^9}, {
   3.5047763535631323`*^9, 3.5047764291549273`*^9}, 3.5047764738377323`*^9, 
   3.504776557743904*^9, 3.504776825964053*^9, 3.504780232225937*^9, 
   3.504786716438739*^9, 3.504786818705235*^9, 3.504786919350686*^9, {
   3.504787164830707*^9, 3.50478719875535*^9}, 3.504787239402483*^9, 
   3.504787334197459*^9, 3.504787410191729*^9, 3.504787463828229*^9, {
   3.50478927023475*^9, 3.504789291350257*^9}, 3.504789330262209*^9, {
   3.5047893968959923`*^9, 3.504789463398522*^9}, 3.5047895217660513`*^9, 
   3.504789569851493*^9, 3.504789606330655*^9, {3.504789641082752*^9, 
   3.504789668649528*^9}, {3.50478970359193*^9, 3.504789727139757*^9}, 
   3.504789996902326*^9, 3.504790043879464*^9, 3.50479012396173*^9, 
   3.504790178293836*^9, 3.504790209153851*^9, 3.5047903048881807`*^9, {
   3.5047903508266153`*^9, 3.5047903953052893`*^9}, {3.504791021606021*^9, 
   3.504791040340589*^9}, 3.5047913322066298`*^9, 3.504791367568796*^9, {
   3.504791397590891*^9, 3.504791456360695*^9}, {3.504791493187819*^9, 
   3.504791503886582*^9}, 3.504805903488028*^9, 3.5288376501763268`*^9, 
   3.7933033296536407`*^9, 3.793303439632227*^9, 3.79330349671812*^9, 
   3.7933246986803007`*^9, 3.7933247464702587`*^9, 3.7938511825006037`*^9, 
   3.823227967319412*^9},
 FontSize->12,
 CellLabel->
  "Out[2102]//TraditionalForm=",ExpressionUUID->"d359c214-0793-485a-9ea8-\
d26a3bdcec44"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"K3", " ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Ki3", "/", 
      RowBox[{"(", 
       RowBox[{"s", 
        RowBox[{"(", 
         RowBox[{"s", "+", "2"}], ")"}]}], ")"}]}], " ", 
     RowBox[{"I0", " ", ".", " ", "G3inv"}]}], " ", "/.", " ", 
    RowBox[{"Ki3", "\[Rule]", " ", "3"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.504775202038426*^9, 3.504775212750556*^9}, {
   3.504775693382819*^9, 3.504775693595354*^9}, {3.504775732922724*^9, 
   3.504775743410219*^9}, 3.5047757841203613`*^9, {3.504776090132328*^9, 
   3.504776106945676*^9}, {3.504789262449789*^9, 3.5047892777049923`*^9}, 
   3.504789722611937*^9, 3.50478993183465*^9, {3.5047899885373297`*^9, 
   3.504789990568347*^9}, {3.504790027121375*^9, 3.504790038470002*^9}, 
   3.504790301550202*^9, 3.50479034752061*^9},
 FontSize->12,
 CellLabel->
  "In[2103]:=",ExpressionUUID->"3a24d594-4692-42f8-ae0c-47938bd69246"],

Cell[BoxData[
 RowBox[{
  RowBox[{"K3a", " ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"s", "/", "2"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"s", "/", "20"}]}]], ")"}], 
     RowBox[{"(", 
      FractionBox["3", 
       RowBox[{"s", 
        RowBox[{"(", 
         RowBox[{"s", "+", "2"}], ")"}]}]], " ", ")"}], 
     RowBox[{"I0", " ", ".", " ", "G3inv"}]}], "  ", "//", " ", 
    "Simplify"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.504776212274069*^9, 3.504776220575986*^9}, {
   3.504776303027727*^9, 3.504776365688526*^9}, {3.504776398423521*^9, 
   3.504776423741527*^9}, {3.504776460139743*^9, 3.504776465213203*^9}, 
   3.504776609473906*^9, {3.504787235222481*^9, 3.504787324604259*^9}, 
   3.504787400400326*^9, 3.50478744831746*^9, 3.504789288102803*^9, {
   3.504789324883791*^9, 3.504789460147646*^9}, 3.504789518380575*^9, {
   3.5047895562376204`*^9, 3.504789660856275*^9}, {3.504789698714581*^9, 
   3.5047897200451317`*^9}, 3.5047899382202883`*^9, 3.504790174899768*^9, {
   3.5047902056821623`*^9, 3.504790205769082*^9}, {3.504790293785021*^9, 
   3.5047902949288893`*^9}, 3.50479100646036*^9, 3.504791037014776*^9, {
   3.504791324017591*^9, 3.5047913265339117`*^9}, {3.504791361986196*^9, 
   3.504791451549885*^9}, {3.504791489213255*^9, 3.5047915009045773`*^9}},
 FontSize->12,
 CellLabel->
  "In[2104]:=",ExpressionUUID->"d26edfe7-db94-439f-9256-05f65234175e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MatrixForm", "[", "K3", "]"}], ",", 
   RowBox[{"MatrixForm", "[", "K3a", "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.5047898958602743`*^9, 3.5047899097601957`*^9}},
 FontSize->12,
 CellLabel->
  "In[2105]:=",ExpressionUUID->"28db5ad6-6c36-4a0c-b418-b4b8e564e967"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "s"}], ")"}]}], 
         RowBox[{"s", " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "s"}]}], ")"}]}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "s"}], ")"}], "2"]}], 
          RowBox[{"s", " ", 
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "s"}]}], ")"}]}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "s"}], ")"}], "2"]}], 
          RowBox[{"s", " ", 
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "s"}]}], ")"}]}]]}], 
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "s"}], ")"}]}], 
         RowBox[{"s", " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "s"}]}], ")"}]}]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{"30", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"2", "+", "s"}], ")"}], "2"]}], 
         RowBox[{"s", " ", 
          RowBox[{"(", 
           RowBox[{"20", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "s"}]}], ")"}]}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"30", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "s"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "s"}], ")"}]}], 
          RowBox[{"s", " ", 
           RowBox[{"(", 
            RowBox[{"20", "+", "s"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "s"}]}], ")"}]}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"30", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "s"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "s"}], ")"}]}], 
          RowBox[{"s", " ", 
           RowBox[{"(", 
            RowBox[{"20", "+", "s"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "s"}]}], ")"}]}]]}], 
        FractionBox[
         RowBox[{"30", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"2", "+", "s"}], ")"}], "2"]}], 
         RowBox[{"s", " ", 
          RowBox[{"(", 
           RowBox[{"20", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "s"}]}], ")"}]}]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.504789910737599*^9, 3.504789944165213*^9, 3.50478999703139*^9, 
   3.504790044026606*^9, 3.5047901240605383`*^9, 3.504790178418664*^9, 
   3.504790209265554*^9, 3.504790305001071*^9, {3.504790350938365*^9, 
   3.504790395399932*^9}, {3.504791021906979*^9, 3.504791040557453*^9}, 
   3.5047913323213882`*^9, 3.504791367678487*^9, {3.504791397701351*^9, 
   3.504791456673539*^9}, {3.504791493286708*^9, 3.504791504147464*^9}, 
   3.504805903609982*^9, 3.528837650295249*^9, 3.7933034396635427`*^9, 
   3.793303496756626*^9, 3.793324698721025*^9, 3.7933247465171824`*^9, 
   3.793851182548522*^9, 3.8232279673597927`*^9},
 FontSize->12,
 CellLabel->
  "Out[2105]=",ExpressionUUID->"af2e23ad-a26e-4d4e-8343-aae91de231a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SingularValuePlot", "[", "K3", "]"}], ",", " ", 
    RowBox[{"SingularValuePlot", "[", "K3a", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.504775392661289*^9, 3.504775393347331*^9}, {
  3.50478666792692*^9, 3.504786678410514*^9}, {3.5047867269227657`*^9, 
  3.504786770502296*^9}, {3.793303358685961*^9, 3.7933033658132772`*^9}},
 FontSize->12,
 CellLabel->
  "In[2106]:=",ExpressionUUID->"21f495eb-eb15-4d16-afd2-7acdf2023ec4"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV12c81X8UB3D7FvojLSPrd42MZGWE77FlXyGaRhclo1BIpKy0JBUNlZG0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           "]]},
         Annotation[#, "Charting`Private`Tag$781924#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVl2c4FW4Dh885xsnKqhCF7JG9nTyPLSOpkMqIjIaRlTgRkaIhqeyMkJRK
ZYSexyoqK9JA9szeBznv//10X/d1X9fv+0/U1feIO4lAIOwlEgj/p5pQ2j86
nYwBuxM3gXAIssVk+wf8576Blift6VZwcLpgbHSLjIU0p/yKt6zgPfS2vfkf
GRuR+rZO/rOCM64teWkbZFyVPZ7zdt0KPi0kHtJcJeOvgxwrJ5etoJCmV6bP
DBmfttUXiJq0gkxH1EFvDxkzeqxnSnZawWzH9YmGUjI+/mNbyuUnVnCvO0eT
2n0yNn1zLoE9xAoKv3Y1tPMj43hd/vw4Sys49W1Q8po5Gd+ZcVJT3WMFU+de
6WlIkbHzbdqk6Lwl5B0uREsEMg5vez+nU2MJuYRGut27mXFayeFNw0RLOGPt
I+9YzoxHMllDr3lYwmSHfaPOicxYI1+OZ1PDEu5zFu8c92HGt97F8r9gtYTK
hV6O4pbM+EoWJ92yzwKyNf2wPi/JjIm+IoF8ryzgx+GkYC0GZuxv4FAvFW0B
rbqozNy9TNgthoXgdswCHmcvUE4vY8Ly3jq0aAkLaKQnfO9FEhPuiSJwztLM
4YZxrcNnHyZcQiyeifxsDu8ffGPnbcGE0580xp7KNIcr+1qrBCWY8ODT2zc8
fMzhH7j/A5XOiLdTIgy8gTksOPFr0a2HETtvXTkXzmsOdc1fJdqVMuLm3xOF
W0MH4Sv17+6tiYxY8CLbpZtlB2GhO6Vz3ZcRSw8MeLHeOgh9zrcUKZsz4rfu
Tk0fTh2EvN7FZTOSjBj8Tk+oVDoIo40q5MsIjHh64Ma2v4SD8LIL8wGVbgZc
5hzDzv3NDFqHZEeqljPgW7f4BQzzzeC8u6ciTGTAVGv3AwPBZjDAOoy7w4cB
p2Qug3hzMxh6pf0OvyUD1j5ll6MmbAYtI48EnZVkwKLpu2zY5kwh/apoAmRg
wIzztuEy9abwip3gDrFeEi4PY/nkl2QKe6TcvsZXkLDQiv0I3dMU4gPTwgUP
SZj7qEFeEMUU+srk9DT7kbBZblzlLo7/9rjymkOtSLjzxdKhf/0m8ETLNylV
KRK2DPk4t/21CdRpM9iTSSTh311hwixRJnC9mWB69w8RK826fTK1M4HXsyd+
xZcTMUO7ZXeJpAlc9BPJ3v6AiEO3f5k7vW4Mh6NTGIz8iVirYvAnrcUYZvsc
aI22JOKzb+n1VY+Nod4xxVYLGSJeXO6FDQHGsIDTUmsvAxE/b+Yj0AyNYRJn
ESW3l4CvVot78e40hq5sx4OK3xNwLkX7U9CEEdzoUeRrSCLgYrFBceJ7Ixj0
zHb69EUCNvsWJtt52whWWuXLs1oQMJ8uonc5GsEYdW2yuwQBJxjy/OlSMIJK
Art3mZAI+GKC9rM+khG0yrMQci+nIzFWo+ITHYZwg5MeaH6RjhR3L7b/yTeE
JQyajA/k6MjW/+sn2zBDSMitd1/p20KndO6PMlsaQk6dGcUzKVvI7xHIXRM2
hO+o3l/HLf/zETdtyTkDeMbs4uNvxC3UFcNeZ1xjAL+zcXc3Vv5Dbg4zuj4P
DGBvKPPEd99/6G2mXxSLhwHMH3jkPCv9D02fu5f1QtsAhrS/YPcZ2kRmqidG
zbYbwIELArcYkjdR1GbUCH+fPmQjiAbm2WwidS/vHcpv9OFXvXAFJ6ZN5LIe
EhV0TR9aB12yEfuwgf6QXspu2OnDbrXlZ1YhG4hdpeDGeTl9uPW4seuO/AZq
eCOSwbwJ4SBJ63zPyDoyT8SC460QOnL/a4cp60jhts3G4mMIB56a+LIeWkf5
fFYcq34QSmrJB/WT1xH9h6iOmDGEpABPq+ZKGmoIHe9I3glhVp7enY+BNOT7
NgCc/Qag6elUJglFGvpocasoMQzAmEYL69ShNRTnnFbCtQfAaKkUolDGGrrT
sxgu1KAHd6tQrr89vIauTKWdv+KuBysa3PRLmNbQ5yXe201kPShgI+VehVbR
RyXZJ76vDkCuG/Bkb8AqSjhp/OaRzQHYVLpcwbr/v57hWSZNo8B4H0XrjLEV
dGGz1TM9hwKH2z+UmqSvoFq+ZXkvIwrckp+8vmm7gg4HvolDU7rwpep5mSaW
FXR55tY3v9u6cJ/KDbWc2mVUOCLgWKymCzMqZIL7qcuI36UvqKJXB76cEolT
V15GNr2lJPEIHXiN7y3zo8kl1Kp0irRLSgfOTKfbcmYuocww50HPT9rQ1Yq1
e+rIEno+dWTPjbPa8NET3qYu9iV0Wp9aos6jDd0K/G/+wItIsJU6pfdGC85n
e5cMX15Elc6lD7+f0IKxEtPc9mqLSMWQ1KjDqAXfHqs17B9fQIFltiYM+Zow
N0z1T1DOAsIR3vJHD2lCmUPr5vvsFpAbZ1fytlkNWF5oPKPKtoAo9R1pd+5p
wG3/5NdtGuYRf2xzSZaOBpzdOPvz+uV5dK5i8smuHnWYvGAg3Kgyj0JK13X4
o9Xhz6SLWiKjc0hEv44pQlwdimDxG72pcyjiXfyBmo9qUHYoABYcm0PkBE/T
675q8Mtr/i+x2+ZQlry9Vh2XGjw5V0KdiJpFel3KL0PKVaHy3QNtt1dnkAFa
e8DlqgrVYwIanV1mUM011zM7GVVh1bmBe+Yd02isBko+fa4CLxas0111ppGY
c/Th51YqUGtFqNv4yRSaqJaKS55ThlFql2L1+adQQfWnuM0UZbjeRP157upf
xHKj9uekrjJcPvR+/fnCJOp3guknh5UgcZQQV+E5iXY8kWZ6dUcJ6nYuVC+2
TaDHHDdqY5WV4NproToTowkUc23q5a93inBodP7Cp6JxtLiRy1lNU4A2bPQx
lz3jyGXhXdAHcwXYrr+zrf7eGKq5Xpwe+Xg/jGjtOmW3PooYEyMFIkfk4SvL
tvcE71Ek41YY/UBLHnKKBlX/7BhBVe4v3m9S5WAEWWx/2IERJFaKrECDLPTv
3eaj8XoY0XkIsjm7ZeF91tSjwgLDqIvqleZ/WgZqSrmxisYPoe3XLr51fycN
p23VFabpg+g9MXVEi0MatneXrIx6DaKwtKuzr+2koJaNVwKtewBZL93MAC8k
YfOephZtwwHE0s4WnrYsAQM2VUKNXvSjWEdWC6KBBEz/3LniKdqPSoYUBa6m
icOxPkMlf94+xOu+vZg4JgZTWQ7tNFnrRcuB9FNpQAwWDRQbBjX0oD+uf63P
xu2Dvb2iltrJ3YhLQ6Iq9Zco3FnBuKoQ8RsdDZsKjVQXhc8M9P5GHPqFAg66
eR2OFoEmRWORJJWfKP5FfakHEoaMWrkLAoI/0LnKHS6MEXvh3oB3z29NfUff
Qz9/NxDfA/Vua7Iof+tEXFFKIeeGBGGlLddLpawORKpqvV16Yzd0MNhQaAj4
hn5nDqef1hSA/zjsbOJPtqMQRYV9cVt8cCuWXP1crg1tb9wWnPFiF2SttXlI
F25BtezDagJBO6FjVblH6+IXxLHYInPXeAc8y9vcZJvchEwuJ/QH/+OBkdI1
F4H7J2TVGdhv38INbVJdn/eRGlBFn/gjoVgu6HlMOq2wqBaV7Q0Osb63Hd78
2tzSRcWo0WYLuxmxw48G+rJBB6oQAzHm8rlGFpjolQ8ZvpWh77HXKTZUMmw1
9aBukd+gSmWeHSwkJrjftxemPn2OxuYXz8kmk+CUiXd6/WAu2qMlU3vJgQAF
xNxjElESElPimyr/swE+G3t/ejniiaaprX1DTqtgdW/r8Otft0B4yu4RpY0F
sDIn/cThaRYQfjGToBc8BeiijysrQgqB0fnXuQtZQ4B3TrFe+NprEJ2aKeor
0gnSP5ga3FUtBd2Otip8og8BB3eWhtb99+BE7se1r2JtiONZBlOgDQLUg/Gt
R28PoLAh77zAvhrw9ruR2JbvJHpWOH6fia0eyA5Er5jcn0civKWzfe4fAc/h
ALL70RUU9yGX2T65EbT+1fa6VreOKBzDcXzrn4H0QATH7zQ6Gsww+hyo2gx0
LtiX5fCQsOHoVdunp1sBUVzG9dEhRrwyTi5I7GsDYwG0ciPMjOsj+q4Kr7eD
4zNjSdmsLFjdy4XbRr4D+Cc3pf6NZ8Mx8q2fpo93ApG6CzePMm3Hrdwt3ccv
fgePTrie6JTjwlVmwfle2V3gh8ib3t9+3Dg3q7jFpPoHKFCkVcrm8GCvzk6h
hI6fgM7VM6XQyovbHJ6IhhN/A59REas1/p1YhcAYrSPYDRwJI90qh3ZhzTX2
jDTLHpB6KdI0OYsPC35l6PEM6QUZrPEaazP8mIbjQkgJf4D9eMKvvdK7cSi5
8os+6gPR2skTf8IFcWjZgQ9S3v0gB9zSJmIhzJK0MH+VeQAoxiRxVOzdi2Od
Mss5MwZAd2X9fFCIMI7S5imOkRkEAnr9wXVOIti6+vdWc80g2BUnoeDGKYpT
bM6H/7MeAk3nPDyuvhPF7R0LCa7dQ8D/uZPOwPF9uHurZSvFfxhsaHnmsbOJ
YVedgLRy+jBYy7O71PRaDFfuvXC/MHkEDDS27zrpKY4Z5k/ubVMYBU4ti492
7JbAjR28P3vfjwKJKz/EG2oksLOzyHT1kTEQOxtbX3hJEgdsLCnF9I+BC+bb
ls/sk8JBMZgcdX4cCD+vYphqksIHy/u1bUgTIMu871vkVWmcutGYSr47AWqe
5d7vkJXB1WNM9glSkyBM2tzs1LAMdhxmNSCUTgLiSUO1N/dk8VQLM87T/wvu
DH9jrdWVw1au9il7fv0FPriSW3BZDssx+2VTPaaAmvQ2saVsedx9pJexmD4F
nEjHzfY47ceXb+tv7Hg4Dfw6jjPX7FLAST+9Rdz2zQCjo8Nf9OsUcOTXmaxr
72dA7bgk371wRfy3TfNwvNks4FiVLejepYSN6i4lNnbMgrRXKUopF5SwpiIz
/wX1OfDAgPiB8FkJs8WohY+FzYHSpYt8jKLK2EyRg8eycQ7UGGzolkQoY+rh
074WvPOAmuC/crtHGc9eFjij5zAPQvhm5JVVVfCX1bDru/PmwU+ditAj91Tw
yBUDOPl3HqjCNX2pCRW8Ehpdd0x5ARQXGXXKAFXs99Uv8Cl1AVBn6JXf01Wx
jGRN1WztAsjtyzdkX1LFFp2VKiKci4D3N8+xv0fUcFHcbmhktwjeveILtilS
wwzlS7sY0hfBiYf17CtEdVyvfVmwaGwRsNgMZem5qOO6utNlJgpLgDttmL69
XB3L5Sxd/RK6BHqGbcjRfBo4bpW042/DEgD8uFE9SANL2wbpbbEtg/P7jIw9
vmpgRXLiw3X7ZXBC5OgGlNPEgTU81yf/+053bp6YTb6miV8vbAdBw8ugxrP+
sexvTWwf8k5iQnEFBJt/zHHR0sK6zDj3cPAKkDx9o5svQQvfGA+0zq5dAVKc
wQP+s1r4q35e/S2OVXBONNad2UobW+dqt58/ugpStzf07XiijXUdQtjUHq+C
/pF83y8kHezOJ9g7O7IKXKhF/ZsndPCajFdPksoaMH+2HvXjvQ6+9kYpr/PK
GjBkbLIf49fFlsaOTNvq1wBXZn/EBT9dHC6ndl+ciwaSG8VFUlt18ayAb7ma
PQ1EBP3eYSJNwaeCBNldjtPAey0l9i8yFPy57ZNzvAMNOMybpurLUXB+rAh5
8CQNPPmRkM6lQMFOy+22d11oYGa3kPpbVQpublNbnDhLAyrBdRPcgIKLYtf3
P6bSAIEUSJaxo2D+ofzIz1dooJf4NCXTnoKv6x39vhxOAx6fUwt3OFCw63IR
1TKSBmiESkPSKQre7eb4hRZDA/LGw55Dpyn4ph72OnaXBjzHPZ5We1PwSsqF
qogEGlDIeaem60vBZ5b5uYru0UBBdbtBhR8Fw+cXy4hJNBB4nDpSGkDBawJi
zC+TaWC0cNqi/DIFewS1OvxOoQGegrVp7TAK7mwLe8GURgOVCZO8VVQKfhXb
eexUBg0MFt6fqomg4L1DV5/GZtLAQnLHY+NICr6lt3+z5DENsC2x/WyKouD1
lF/Wf7JoQC8t8sGhaAr2XI7JZcmhAfOcyz87Yij4f9Xy0sY=
           "]]},
         Annotation[#, "Charting`Private`Tag$781924#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-3., -28.522763757415568`},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-40., 
           FormBox[
            RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
           FormBox[
            RowBox[{"-", "20"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {20., 
           FormBox["20", TraditionalForm]}, {40., 
           FormBox["40", TraditionalForm]}, {60., 
           FormBox["60", TraditionalForm]}, {80., 
           FormBox["80", TraditionalForm]}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {65., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}, {{-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {65., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {70., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-3., 
           FormBox["0.001`", TraditionalForm]}, {-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-3., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-2.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{13.091836734693914`, 1.4999999999999432`}, {
       12.730520302207367`, 3.186744446225134}},
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-3., 1.6020599913279623`}, {-28.522763757415568`, 
       69.54242909494303}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-3., 
          FormBox["0.001`", TraditionalForm]}, {-2., 
          FormBox["0.01`", TraditionalForm]}, {-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {-2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.5228787452803374`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.221848749616356, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0969100130080562`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0457574905606752`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.5228787452803376`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.2218487496163564`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.0969100130080565`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.045757490560675, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-40., 
          FormBox[
           RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
          FormBox[
           RowBox[{"-", "20"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {20., 
          FormBox["20", TraditionalForm]}, {40., 
          FormBox["40", TraditionalForm]}, {60., 
          FormBox["60", TraditionalForm]}, {80., 
          FormBox["80", TraditionalForm]}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {65., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}}}], {159.15447843469929, -100.44793936543498},
      ImageScaled[{0.5, 0.5}], {298.41464706506116, 191.32940831511425}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV13c81d8fB3DjotCgQiVJQ31k73Gdtz2SESLJSiLyRQMpVMgoiYxshUJG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           "]]},
         Annotation[#, "Charting`Private`Tag$783128#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV12c8FW4DxvFzOBwk2WRk773X0X1b2aJISSWlEP4qDTQkIqlURCKOLaEh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           "]]},
         Annotation[#, "Charting`Private`Tag$783128#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-3., -28.53014335970296},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-40., 
           FormBox[
            RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
           FormBox[
            RowBox[{"-", "20"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {20., 
           FormBox["20", TraditionalForm]}, {40., 
           FormBox["40", TraditionalForm]}, {60., 
           FormBox["60", TraditionalForm]}, {80., 
           FormBox["80", TraditionalForm]}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {65., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}, {{-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {65., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {70., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-3., 
           FormBox["0.001`", TraditionalForm]}, {-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {3., 
           FormBox["1000", TraditionalForm]}, {-2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-3., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {3., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-2.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{13.091836734693857`, 1.5}, {12.730520302207367`, 
       3.186744446225134}},
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-3., 2.6020599913279625`}, {-28.53014335970296, 
       69.54243009912516}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-3., 
          FormBox["0.001`", TraditionalForm]}, {-2., 
          FormBox["0.01`", TraditionalForm]}, {-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {3., 
          FormBox["1000", TraditionalForm]}, {-2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.5228787452803374`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.221848749616356, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0969100130080562`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0457574905606752`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.5228787452803376`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.2218487496163564`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.0969100130080565`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.045757490560675, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.4771212547196626`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6020599913279625`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.7781512503836434`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9030899869919438`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9542425094393248`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-40., 
          FormBox[
           RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
          FormBox[
           RowBox[{"-", "20"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {20., 
          FormBox["20", TraditionalForm]}, {40., 
          FormBox["40", TraditionalForm]}, {60., 
          FormBox["60", TraditionalForm]}, {80., 
          FormBox["80", TraditionalForm]}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {65., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}}}], {477.46343530409786, -100.44793936543498},
      ImageScaled[{0.5, 0.5}], {298.41464706506116, 191.32940831511425}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[223]},
  PlotRange->{{0, 636.6179137387971}, {-200.89587873086995`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.504775394562008*^9, 3.504775699618352*^9, 3.50477574802623*^9, 
   3.5047757874941177`*^9, {3.504776096001623*^9, 3.504776113802247*^9}, 
   3.504776233825248*^9, {3.504776270105722*^9, 3.504776316714038*^9}, {
   3.504776353881967*^9, 3.504776429470285*^9}, 3.504776474221901*^9, 
   3.504776558025051*^9, 3.504776826269512*^9, 3.504780232517212*^9, {
   3.504786670972458*^9, 3.504786735153554*^9}, 3.5047867718437023`*^9, 
   3.504786819433765*^9, 3.5047869199945707`*^9, {3.504787165402903*^9, 
   3.504787199331094*^9}, 3.504787240117055*^9, 3.504787334876995*^9, {
   3.504787404030583*^9, 3.504787410902019*^9}, {3.5047874544992733`*^9, 
   3.504787464604835*^9}, {3.5047892708776083`*^9, 3.504789291914537*^9}, 
   3.504789330979559*^9, {3.504789397477627*^9, 3.504789464067457*^9}, 
   3.504789522343623*^9, 3.504789570620302*^9, 3.504789607005422*^9, {
   3.504789641669095*^9, 3.504789669203025*^9}, {3.5047897042603292`*^9, 
   3.504789727703908*^9}, 3.5047899976573257`*^9, 3.504790044493607*^9, 
   3.5047901245162773`*^9, 3.504790178872094*^9, 3.5047902098612347`*^9, 
   3.50479030559409*^9, {3.504790351531588*^9, 3.504790395846345*^9}, {
   3.504791022352161*^9, 3.504791041041292*^9}, 3.504791332769087*^9, 
   3.504791368149231*^9, {3.504791398149746*^9, 3.504791457141313*^9}, {
   3.504791493788158*^9, 3.504791504599909*^9}, 3.504805904209322*^9, 
   3.528837650808302*^9, {3.793303366571945*^9, 3.793303376317217*^9}, 
   3.793303440195848*^9, 3.793303497320951*^9, 3.793324699318614*^9, 
   3.7933247470868464`*^9, 3.7938511831128397`*^9, 3.823227967931984*^9},
 FontSize->12,
 CellLabel->
  "Out[2106]=",ExpressionUUID->"4d83f079-1dcc-46f5-86f8-07419e975a5e"]
}, Open  ]],

Cell[TextData[{
 StyleBox["In order for the controller to be \"valid\", it must be finite as  \
s \[RightArrow] \[Infinity] , else ",
  FontSize->14],
 StyleBox["Mathematica",
  FontSize->14,
  FontSlant->"Italic"],
 StyleBox[" complains.",
  FontSize->14]
}], "Text",
 CellChangeTimes->{{3.504786314878254*^9, 3.504786368465461*^9}, {
  3.79332473392906*^9, 3.793324742756571*^9}},
 FontSize->12,
 Background->GrayLevel[
  0.85],ExpressionUUID->"e780d994-a6f6-4e22-8246-40d1ac01c21c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SingularValuePlot", "[", 
     RowBox[{"G3", ".", "K3"}], "]"}], ",", " ", 
    RowBox[{"SingularValuePlot", "[", 
     RowBox[{"G3", ".", "K3a"}], "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.504805892498979*^9, 3.504805895717024*^9}, {
  3.7933033803344803`*^9, 3.793303385139127*^9}},
 FontSize->12,
 CellLabel->
  "In[2107]:=",ExpressionUUID->"1908c90f-9c08-49dd-bf80-bab08be3bcf5"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1vc/Fd4Dx/HL5d4iCQ0rexbZe5xjXdyLmzIbkhIqJDSkkNUmSlKyUqSB
hETnVGRlRTITycoel2vd7+f70/vxfDzef8BL0sN/nyc7gUAQYyMQ/r+aoo/W
WCwyns8bEav/TIfc0RlnA/9zzEqDt9R/Hph4Pjy0TsbuGcevXPxEh3dRUUvD
Ghkbyllsksd0OOnRmP1ohYzVSLvywyroMCeXzU5nkYyJyxxE+VI6FNXxfuI3
ScYoKl3W9hUdcu7TAr09ZJwxIPJiJokOMw4vj1YVk7Fyzb4Mcy86FPPkqdVM
JOPB0633f+rToXiBh5nTGTL+KRKY48hLh+PfB+QiqWRMJ0horPfZwZTpfGNt
eTKe6tk2NP7WDgoM5qJ5Ahn3HLs5zBllB7eI/u327CZhDeqNyc2OdnCS7qd0
uJSEZVrSvOwU7WCyq9TQkQQSrn5otfyVaQuljsi0jfiR8KEFoZXzDbZQLdf7
sIwNCR9lfOrekWkLuWt/0k/JkfBi1l/rgbO28OvgvXO6RBK+TtqZOEuxhbbt
oSS+Xk78pOvGV+UdttBl03O1xyWcONdjpJg+YgPNjcXvvrrHiX9xVX55X24D
Vyw+u9b5ceLbLpPJNrdtYKL1WydfGieOtvCUlz9qAxlSTeUispx4+U2aiJqa
DfwFlT+GsjiwkatSjQ67DXx+oHPuWA8Hvnb+wYBVOw0aUPMTnIo5cPkdHv7a
ZzSYr/XDsymBA4+HLDfuD6HBXE/DtmV/DnzdN+tNmx0N+p1qzFOjcuBXZv0r
18RpUMD3dcmkHAcubX/6OnqOCqPM3yuVEDhwy3Pfze++UOFFd5KRejcRX17L
XOq6R4X0CxkRGqVEfN9R8N8mHyqc8fRSgQlEPJ+dP/1CjwoD6Zf4Wv2ImKS8
o82BhwpDLrfcEbQh4vHC4G3r/dbQJmJfsI8cEY/o26S2FVpDVrhkPCQScaeY
etZsjDW87CSyVbqXHRcdCK/Qc7aGPfLHvt18z46plxpf1uyyhthoQvx5Ejv2
Lu7RN2ZZQX/FzJ6GM+y4/f6h7X1NVpC1JbshxJYdbwqw9qvKsoIHGr/La8iz
Y8bxpdr2QCuo32y68wkbO/adLX7VbG4FlxsIlnG/2LDLXPtGXiErGJMx2nmz
lA1brHlXXhy1hHNnJDI232fDWbynwxQqLOFg1EOi+Vk27HDgLhnftYQZfkZN
UTZs+HJx3NWrHpbQ2EGliabIhp8eINy6oW0Jn/Pa6IoR2bCEzL7KCpIlvMeb
Z5jVS8ArKlqPf/6kQA9ul+DXZQS8yT7LR+8lBa70qOyoukfAe/PjRSpDKTD4
hePE0QACVtB0DkzaS4EfbJ8pcdEIuPHbu0vJEhQYraVH9pT971+mHvZgxgKq
Cglvp7AT8PqpMN+0Kgtom00T9SxloUnvr6eFkizgCi8riBrAQnXPnsY+9rGA
hUQdjvu7WUji64fj/MYWkJBV6cnoW0eswRLdz5stIK/+pMrxh+so937qs8IB
c/gu1PfbiM06ajzpWvir0BwetwpI+872n88VJq1GmsMf3HzdNR/WUKpk1nFp
F3PYG0Ia/eG/hk6sOr8rVzCHz/ofHJlSWENTcwLtbqtm8ELLq01+f1ZRmz4f
YanZDPafFrpFTF5Fo2h7ZFWGGeQmSAZl26+iArG3e7qDzeA34yt73DhXkZvm
gWeiFDNIDz5vL/1xBfGrsmzThMxgt+bCC9sLK8hn/HPopklTuJ5W035HaQXZ
vZBozvpoCgfYdU/1/F1GRXv4r0YkmMLDfGst8OEyKp3rGrrmYQr7cyj+XHbL
yPJUh0qshimU01UK/k1eRrdaa6Nek00he6CXbcMHJurgLjop1mEC07ON73wN
YqIrEtx+RXkm0PJoCqesChNJFeoQzcJNYHQNjZ7yZwl9frSlYXmvCYySf8gm
mrqEyhTUjjNlTKCwumFM0d4ldL01w1ByAcL3VcdMCjmX0ExWmpDxVwiF7OU9
y9Eiatlv1x6bAuGWa/Bgb+Ai2kGnDW85BWFt8cJ7LuVFZHAM2jUaQ3jTT4We
OsxAL5kZR0MFIBxs+VhMecxATmJTNTk1AK4rjcWsOjKQO4+H4OAZAN9onFKs
3chAYrIfbIP4AJRSv6aZ+XkBhTlfcYkvNYap7xXP/Q5dQGvlkaPnjxrDN+MS
N7TUFhDX94L7pezGMHJHEenB2Dx6urdPK/yFEZyceOzI+2QeUfYPyaRTjaCH
LVf3+L55pH9Ile3muCF88FSgtn3TPCp2ss5hv28Ijz0/e/0nnkNnLxjbf9My
hDMZvoWDF+eQFUE7U6rXAMbKTvA5a84h8vltj8xiDGCRw2ez3yOzKOWjUdEH
eQOYdUnjV3DmLIpsP2tX1qQPFe2WqVJOs+hW8cgk7xl9WJprManBPYu+ZFan
qfDrww1rSsv2VTNIRueBR1eZHpxa8emIuTiDBg/2J7Qf1IPJs6biNeozyNE7
ZfUQUQ923AvQlRiaRkfNtj9Tz9KFEljmWm/KNGoce9vRaa4Ld/0JhM8dppGg
NNOAfUIH1hcI1sdumEbAviQ/5rYOPDhdGDp6dQptOovcIjR1oFqcUfPtxUn0
1TnYc3+vNtSKDqw54j6JjPnJUv5XtGH5yf671NYJdEPoq8t2OW0Y8HyZ5aE/
gZglkRKcX7WgLkO02+LpOCpy0fGo9dKCVzXPx5oIjqOTy+Jx7Fu04HJtaMfJ
8H/I0Y9H426+JlywK1t+OTuGXPZfPP3EWROyDRFuvPcaQwXVhXEhBE1o0DZb
Mdc8iloPakY8yNCASwWiXyjmo2hWx+29kbUG/DM0c7o6bwS9MxX4KDmqDu25
WcPuO0fQ0udItbg4ddhisq258u4wsj5WkflRRx2GNbUfcloeQr/Xz95W7FCD
+TbNZQTfIVS9SuESClODvJLBFR2tf9HQYJOpkZgaDCNLK18y+ou0qrfZiCJV
eLZ3g592wSCak7rdFH1CFSZypewXFxpEkVwq3QIkVagjf4xL8uYf1JLs+cvJ
RQVOOGrtmWANoCu/DvYvPt8DW7oLGUPeA8j9kJ9227Ay1LX3jmd29yPAbN9Z
oqkMG3bWNuqZ9SNezS5XFKAEA1fVQ8xf/UZFJQ3cEoW74eO6NoaX5G+kMFmb
Gs/aBYf7zFTPCvSh/QrNYouGu2DKRrttlKVeJLVLYdQ7VhHm9b82C67qQX7I
SPjlJwXY2ytpo5fcjRI7d248wpKH295zLO4J60J1sOQctpaHL0yN/4XZdaLt
7Ae8FaLkICVvOIJdvQOdtKkvE6qXhRy6WbNCIj+R9HECZ9Q2WSgW+O7lrfEf
aPu0UCegy0Dj2zob1b63Ibl44WxSkjT84LjljWp6KzIMCs/rr5eCrqYre6oC
vyNfbrd0Dk4puMbjZH/zYAty7HnwLp4qCddjyRUvdzejgFy3ON8wCcj12T6J
Jd6IQkaDk/wixOHh8tITTXP1aMx0APtziUEfgYZax+RaVMSgZE74i8IIhU8B
wLMaqc14frk6JQztUzxe9rFXIXYfo191VCHo5aDwKDfvMzocv+ZumbcDXv/W
0NgeitHj2JVPYbLb4VdTk13BRuVIju2H7/GQrTDB+xkkfi9BxnmHHc+M8sMm
yxOh6+S36I0DfHdCnQ8q+/fClJyXKGibh3AHazMcp/g+rhzIQpYXd5c51nND
IWnP6AR0D8Enwak+tA2wzsK3+s1fL0Ryf+23tMIBF8WaBgs6b4Hnw3mvT7xj
g4xphaeuOengqa07OUhvFbAk0z68v5ALkhP0AsQCFoDAtEqleGQBYAgnC2ms
/QOPP1qaxmkUg9XcHTlex7oAD1+6tm5iGaDUsfm6K6UgnhepnEH2CPxq/p0T
uus3uvTHNzuo7xOIzKPE0d9Pohe5I4mc3JXgwKVk+YOJDCQhUDzV5/kVJJf0
MpRj19GNj1kk5+QaULXLMLHrvw4y5Bm8sWO5Diht3FqyIEfGA6nmdUEaDeC7
lxTy4uXGZkPhjjlHm4Cy6FBN4/RmzBghP0/oawbXskHqtcd8uDKsL1x8uQXw
xZdsHM4QwFre7nz2Sq2AQ4bGa9OzDUcrNVVPuLQBXmtO0nUBQdzE19jtEvAD
dPqEzrLvFsblVueeeWe0g5zLDXrxF0RxVvrrRkrFT7Bzg9sDt2wx7N3WJhrf
2gH89sp+CT0hgZtdn0peYesCxk3HBi8nSWJ1AkeUvkg3OJL+yPJdkRTWWdqU
+simByxyM9YKpqSxyDdij9eFXrB3S4SPrYIsZuIbF9jjfwHUIvBk3VYOh5A/
1JugPiCQshK19a48Dikx+ijv+xu0vbW7lYYV8MZ7szPhpH4QvmHK4QHPLhzr
9qSUN7UffFAJ/lTqtBtf1eN/Ha04AAJrR7YF31bC9Iqu9YZPA2Dvue+mqE8Z
P7Q/dWWN/gf45OxgSIir4JbW2XiP7j8Ays7smVFSxd3rjesPzw4CaT/ffQKd
qthDP/BRKWsQ8HD45gWEqOEPYqcTc5P/Au+d42OZu9QxceagWPOeIfDKrJnn
QIc6rmkV6OgtGwIa3DZsPy9p4CNHJCYq9g2DTuIPfgtlTRy4Mq8a/XsY8G/l
+2jVpomDozH56qkRUJuiTbe6oIWtS3/r2bOPgk0uUtOBu7VxykpNCjluFEwK
FD1J+a6NK4Y5nePlx8DlGikfxes6+PAglymheAxIid7qrdPQxeONJJxt8g8M
ffJmUbp1sa2H88Odnf/AZgNbTesEPbybdCYj9MQ40HevPjRiqI+79/VyvGaN
g6c1m9kEF/XxxdsmK1uTJsC4q75n9SsDfK/DV+KY1CQIj8kzS3YxxBHfJtMj
yybBTO7lQUN+I/yvWWfvTaspQPyr1rqEjLD5l/MJNa1TQFAknZvpY4x1VEiC
p7WmQUaSATVBGmDuaM0rw5emgVNHW75jM8BWKjz8NjXTIESAPe0ABeLQvUf9
aQIzYEy0ICc/E+Kpi0LHjV1ngMO8A717CeL6xUsxwtkz4I/Md70EJxP897Ip
HPs3A77LOmawXplgRkjUFwe1WbBE35iUQDTFZ76dCcoJnQWZ6oqLM+6mWFHu
U/nU51mwNVGgpK7EFNPaPqhL8M6B6v6xNr/tZjjvhjA0d5oDyFkjI8bPDBNL
57cTH8+BhVs19J5KM1ypd1Ekb3gOXBWoC2NImeMvX46WUPbMA5MXBWrRIeZ4
d+Z8eH3IPIi5c+1aZ6c5vrHIvvVf1TwwuGu12UfHAis4Bhuvcy8AtwmrNrc7
FliFnJC07LwA3pXPLUhNWOCgT/wxY08WQMWJrAmqBQUXzG4GwYML4DTPNcPc
RxTsfOGd7KgKA8TIuLd/Y1KwAQln7T3HANs6F8wO2FviayNB9IzPDOBR1Gbw
Mt8SfzPJrrzFswgSTmsnq2+2wvQsvZZT+xcBt78wU9DTChu4XuDWTFsEfQ4Z
iXVfrLDnDpHeqb+L4F/FHWKPiDVeUvTuuae+BKymN/uXXbLGkW9Vs9suLwHR
kg6xmk5rbGNxmHND5RJIFlOuV1Kj4iu7NRNltjBBzmn1L4fjqXhKyL9U05kJ
MjrvSM6NUPGhYJFN7i5M4EChVYSNUXFdc/WRm65M8O2ySSXjHxU/i5UgDxxk
Ajlp1fSSSSp2W2hxjHNnAmkqv5fJPBU3NGvOjfowQeXuyLxgFhXnxS4rp4Uy
wfkfZmTP7TQs+OdZRN1lJggTSRTr2kHDMcb7fyxcYYJJFaVZuhANeyzkhdpE
MMFQbXGzkSgNCx87XM+MZgK+8OJQKSkavm6MvR3imIA70ER8yx4aZjw8XR4W
zwTrAQaWd1Vo+PiC4Ja8u0xQOl6tJaBGw/BlQAnbPSbYfcbSR0iThpeEpElv
kpkg6EeXoYo+DZ8IbnLtesgEP8YOvSw2oOG25kuvOB8xAd11aNjYiIbzY9sc
DqUyQffNrip7SMNif8JzYp8wQYr+K58eExq+Zay8WpjGBMvCzj1eZjS8/LCT
/iudCVh+d8TmzWnYayE6a2MmE5C8uNQiKDT8P3mh080=
           "]]},
         Annotation[#, "Charting`Private`Tag$785134#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1vc/Fd4Dx/HL5d4iCQ0rexbZe5xjXdyLmzIbkhIqJDSkkNUmSlKyUqSB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           "]]},
         Annotation[#, "Charting`Private`Tag$785134#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-3., -54.550817613677324`},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-60., 
           FormBox[
            RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
           FormBox[
            RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
           FormBox[
            RowBox[{"-", "20"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {20., 
           FormBox["20", TraditionalForm]}, {40., 
           FormBox["40", TraditionalForm]}, {60., 
           FormBox["60", TraditionalForm]}, {80., 
           FormBox["80", TraditionalForm]}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {65., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}, {{-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {65., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {70., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-3., 
           FormBox["0.001`", TraditionalForm]}, {-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-3., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-2.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{13.091836734693885`, 1.5}, {12.730520302207367`, 
       4.79614501730245}},
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-3., 1.6020599913279623`}, {-54.550817613677324`, 
       63.52182375298426}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-3., 
          FormBox["0.001`", TraditionalForm]}, {-2., 
          FormBox["0.01`", TraditionalForm]}, {-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {-2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.5228787452803374`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.221848749616356, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0969100130080562`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0457574905606752`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.5228787452803376`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.2218487496163564`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.0969100130080565`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.045757490560675, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-60., 
          FormBox[
           RowBox[{"-", "60"}], TraditionalForm]}, {-40., 
          FormBox[
           RowBox[{"-", "40"}], TraditionalForm]}, {-20., 
          FormBox[
           RowBox[{"-", "20"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {20., 
          FormBox["20", TraditionalForm]}, {40., 
          FormBox["40", TraditionalForm]}, {60., 
          FormBox["60", TraditionalForm]}, {80., 
          FormBox["80", TraditionalForm]}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {65., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}}}], {159.00450316784773, -101.20163313118302},
      ImageScaled[{0.5, 0.5}], {298.1334434397145, 192.76501548796764}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVzWc8FW4DxvFzOIhUViFk75GVnfu29zoyU5QQJSoVacg/W0JWKHuUUBES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           "]]},
         Annotation[#, "Charting`Private`Tag$786237#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVzWc8FW4DxvFzOIhUViFk75GVnfu29zoyU5QQJSoVacg/W0JWKHuUUBES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           "]]},
         Annotation[#, "Charting`Private`Tag$786237#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-3., -74.5508174364678},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-75., 
           FormBox[
            RowBox[{"-", "75"}], TraditionalForm]}, {-50., 
           FormBox[
            RowBox[{"-", "50"}], TraditionalForm]}, {-25., 
           FormBox[
            RowBox[{"-", "25"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {25., 
           FormBox["25", TraditionalForm]}, {50., 
           FormBox["50", TraditionalForm]}, {75., 
           FormBox["75", TraditionalForm]}, {-75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-65., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {65., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}, {{-75., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {75., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-75., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-65., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-55., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-45., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-35., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-15., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-5., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {5., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {15., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {25., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {35., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {45., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {55., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {65., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {70., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {75., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-3., 
           FormBox["0.001`", TraditionalForm]}, {-2., 
           FormBox["0.01`", TraditionalForm]}, {-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {3., 
           FormBox["1000", TraditionalForm]}, {-2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-3., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {3., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-2.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.5228787452803374`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.221848749616356, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.0969100130080562`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-2.0457574905606752`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.5228787452803376`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3979400086720375`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.2218487496163564`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.154901959985743, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.0969100130080565`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-1.045757490560675, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.4771212547196626`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.6020599913279625`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.7781512503836434`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.9030899869919438`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {2.9542425094393248`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{13.091836734693885`, 1.5}, {12.730520302207367`, 
       4.79614501730245}},
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-3., 2.6020599913279625`}, {-74.5508174364678, 
       63.521824757166286`}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-3., 
          FormBox["0.001`", TraditionalForm]}, {-2., 
          FormBox["0.01`", TraditionalForm]}, {-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {3., 
          FormBox["1000", TraditionalForm]}, {-2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.5228787452803374`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.221848749616356, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0969100130080562`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.0457574905606752`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.5228787452803376`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3979400086720375`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.2218487496163564`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.154901959985743, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.0969100130080565`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.045757490560675, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.4771212547196626`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6020599913279625`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.7781512503836434`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9030899869919438`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.9542425094393248`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-75., 
          FormBox[
           RowBox[{"-", "75"}], TraditionalForm]}, {-50., 
          FormBox[
           RowBox[{"-", "50"}], TraditionalForm]}, {-25., 
          FormBox[
           RowBox[{"-", "25"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {25., 
          FormBox["25", TraditionalForm]}, {50., 
          FormBox["50", TraditionalForm]}, {75., 
          FormBox["75", TraditionalForm]}, {-75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-65., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {5., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {15., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {25., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {35., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {45., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {55., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {65., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {75., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}}}], {477.0135095035432, -101.20163313118302},
      ImageScaled[{0.5, 0.5}], {298.1334434397145, 192.76501548796764}]}, {}},
  
  ImageSize->{
    UpTo[600], 
    UpTo[223]},
  PlotRange->{{0, 636.0180126713909}, {-202.40326626236603`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.504805898931406*^9, 3.504805904807435*^9}, 
   3.528837651407652*^9, 3.7933033863040524`*^9, 3.793303440747839*^9, 
   3.793303497874103*^9, 3.793324699904338*^9, 3.7933247477682333`*^9, 
   3.793851183663116*^9, 3.823227968500757*^9},
 FontSize->12,
 CellLabel->
  "Out[2107]=",ExpressionUUID->"01d7de89-0c0e-429e-a79e-de898b314c05"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S3", " ", "=", " ", 
  RowBox[{
   RowBox[{"Inverse", "[", 
    RowBox[{"I0", "+", " ", 
     RowBox[{"G3", ".", "K3"}]}], "]"}], " ", "//", " ", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.504775330465312*^9, 3.50477533471631*^9}},
 FontSize->12,
 CellLabel->
  "In[2108]:=",ExpressionUUID->"e750a442-8682-4b1c-978a-0f0e2cdba690"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"s", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "s"}], ")"}]}], 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"s", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "s"}], ")"}]}], 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.504775335682629*^9, 3.504775717462453*^9, 3.5047757533545322`*^9, 
   3.504775791929976*^9, {3.504776096110629*^9, 3.504776113904244*^9}, 
   3.504776233950201*^9, {3.504776270227968*^9, 3.5047763168348083`*^9}, {
   3.504776354002039*^9, 3.5047764295784693`*^9}, 3.504776474387576*^9, 
   3.504776558135652*^9, 3.5047768263899403`*^9, 3.504780232635886*^9, 
   3.5047867168640327`*^9, 3.504786819707768*^9, 3.504786920342627*^9, {
   3.504787165700828*^9, 3.504787199641941*^9}, 3.5047872404897203`*^9, 
   3.5047873351451807`*^9, 3.504787411173011*^9, 3.504787464943116*^9, {
   3.504789271272407*^9, 3.504789292364223*^9}, 3.504789331312293*^9, {
   3.504789397799253*^9, 3.504789464330022*^9}, 3.5047895227044907`*^9, 
   3.5047895709988403`*^9, 3.504789607260803*^9, {3.504789641980474*^9, 
   3.504789669568412*^9}, {3.504789704646523*^9, 3.5047897280509663`*^9}, 
   3.504789997931591*^9, 3.504790044861389*^9, 3.504790124847558*^9, 
   3.504790179171981*^9, 3.504790210207954*^9, 3.50479030594308*^9, {
   3.504790351807526*^9, 3.50479039615248*^9}, {3.504791022625491*^9, 
   3.50479104131866*^9}, 3.504791333059011*^9, 3.5047913684320297`*^9, {
   3.504791398443942*^9, 3.504791457474736*^9}, {3.504791494072652*^9, 
   3.504791504943049*^9}, 3.504805905019157*^9, 3.528837651620152*^9, 
   3.793303440807953*^9, 3.7933034979753923`*^9, 3.7933247000073223`*^9, 
   3.7933247478014383`*^9, 3.793851183744424*^9, 3.8232279686309958`*^9},
 FontSize->12,
 CellLabel->
  "Out[2108]=",ExpressionUUID->"6a99ade8-4b5f-4ec2-a586-1a347efbee58"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T3", " ", "=", " ", 
  RowBox[{
   RowBox[{"I0", "-", "S3"}], " ", "//", " ", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.504775348959744*^9, 3.5047753525811853`*^9}},
 FontSize->12,
 CellLabel->
  "In[2109]:=",ExpressionUUID->"07a2e0d1-c131-405d-a216-d9b7b912cd98"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["3", 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["3", 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.504775353474143*^9, {3.504775771769505*^9, 3.504775798805077*^9}, {
   3.504776096169796*^9, 3.504776113960194*^9}, 3.504776233995246*^9, {
   3.504776270271948*^9, 3.504776316883028*^9}, {3.504776354047674*^9, 
   3.504776429625132*^9}, 3.5047764744260693`*^9, 3.504776558183906*^9, 
   3.5047768264332933`*^9, 3.5047802326812477`*^9, 3.504786716910583*^9, 
   3.504786819763102*^9, 3.504786920444496*^9, {3.504787165752404*^9, 
   3.504787199700349*^9}, 3.50478724059027*^9, 3.5047873352044563`*^9, 
   3.5047874112312183`*^9, 3.504787465000745*^9, {3.504789271372601*^9, 
   3.504789292401121*^9}, 3.504789331346528*^9, {3.5047893978348293`*^9, 
   3.5047894643871603`*^9}, 3.5047895228205423`*^9, 3.504789571056796*^9, 
   3.5047896073191433`*^9, {3.5047896420886393`*^9, 3.504789669625917*^9}, {
   3.504789704679936*^9, 3.504789728110794*^9}, 3.504789997991231*^9, 
   3.504790044918515*^9, 3.5047901249047813`*^9, 3.504790179207481*^9, 
   3.5047902102540283`*^9, 3.504790306006462*^9, {3.5047903518443947`*^9, 
   3.5047903962103853`*^9}, {3.504791022682537*^9, 3.504791041382869*^9}, 
   3.504791333116928*^9, 3.504791368489204*^9, {3.504791398494328*^9, 
   3.5047914575324078`*^9}, {3.504791494124784*^9, 3.504791504976449*^9}, 
   3.504805905086935*^9, 3.5288376516740932`*^9, 3.793303440831931*^9, 
   3.7933034979829407`*^9, 3.7933247000174713`*^9, 3.7933247478475237`*^9, 
   3.793851183785864*^9, 3.8232279686368523`*^9},
 FontSize->12,
 CellLabel->
  "Out[2109]=",ExpressionUUID->"8b663f7f-210a-48f8-987e-6d5397f868b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T3tf", " ", "=", " ", 
  RowBox[{"TransferFunctionModel", "[", 
   RowBox[{"T3", ",", "s"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.504775534764*^9, 3.504775537310746*^9}},
 FontSize->12,
 CellLabel->
  "In[2110]:=",ExpressionUUID->"fe729b1f-68c7-4cc7-8d1f-dec154c15631"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox["3", 
     RowBox[{"3", "+", 
       RowBox[{"2", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]], "0", "0", 
    FractionBox["3", 
     RowBox[{"3", "+", 
       RowBox[{"2", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, 
     InterpretationBox[#, 
      TransferFunctionModel[{{{3, 0}, {0, 
        3}}, {{3 + 2 $CellContext`s + $CellContext`s^2, 1}, {
         1, 3 + 2 $CellContext`s + $CellContext`s^2}}}, $CellContext`s], 
      AutoDelete -> True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 2, 2, 
     Control`CountStates[
      TransferFunctionModel[{{{3, 0}, {0, 
        3}}, {{3 + 2 $CellContext`s + $CellContext`s^2, 1}, {
         1, 3 + 2 $CellContext`s + $CellContext`s^2}}}, $CellContext`s]], 
     1, {}, {False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#, #2}, {#3, #4}}, AllowedDimensions -> {2, 2}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #5, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 2}, ","], "}"}], ",", 
        RowBox[{"{", 
          TemplateSlotSequence[{3, 4}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#5}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{3, 0}, {0, 
    3}}, {{3 + 2 $CellContext`s + $CellContext`s^2, 1}, {
     1, 3 + 2 $CellContext`s + $CellContext`s^2}}}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{
  3.504775537850333*^9, {3.5047757770539637`*^9, 3.504775803302239*^9}, {
   3.50477609621206*^9, 3.504776114010539*^9}, 3.504776234051662*^9, {
   3.504776270326795*^9, 3.504776316932496*^9}, {3.504776354105578*^9, 
   3.504776429681243*^9}, 3.5047764744731913`*^9, 3.504776558232625*^9, 
   3.504776826489852*^9, 3.5047802327331123`*^9, 3.504786716961195*^9, 
   3.5047868198138123`*^9, 3.504786920528804*^9, {3.50478716579992*^9, 
   3.504787199746729*^9}, 3.50478724063708*^9, 3.504787335265772*^9, 
   3.504787411281011*^9, 3.50478746504776*^9, {3.504789271419182*^9, 
   3.504789292434586*^9}, 3.504789331379695*^9, {3.504789397864176*^9, 
   3.504789464437427*^9}, 3.5047895228876343`*^9, 3.5047895711034527`*^9, 
   3.5047896073686132`*^9, {3.504789642189499*^9, 3.504789669672022*^9}, {
   3.5047897047267637`*^9, 3.50478972815742*^9}, 3.504789998059864*^9, 
   3.504790044965254*^9, 3.5047901249517107`*^9, 3.504790179313445*^9, 
   3.5047902103044357`*^9, 3.504790306056532*^9, {3.5047903518785*^9, 
   3.504790396256611*^9}, {3.504791022728106*^9, 3.5047910414290247`*^9}, 
   3.5047913331635323`*^9, 3.504791368535082*^9, {3.504791398564602*^9, 
   3.504791457578971*^9}, {3.50479149417531*^9, 3.5047915050108356`*^9}, 
   3.504805905153998*^9, 3.528837651725605*^9, 3.7933034409602547`*^9, 
   3.793303498109219*^9, 3.793324700142168*^9, 3.793324747981763*^9, 
   3.793851183917807*^9, 3.823227968706222*^9},
 FontSize->12,
 CellLabel->
  "Out[2110]=",ExpressionUUID->"aa826d77-6849-4926-95a9-235d5dce5203"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u3tf", " ", "=", " ", 
  RowBox[{"TransferFunctionModel", "[", 
   RowBox[{
    RowBox[{"S3", ".", "K3"}], ",", "s"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.504775550402225*^9, 3.504775554098199*^9}, {
  3.504776692034491*^9, 3.504776693761559*^9}},
 FontSize->12,
 CellLabel->
  "In[2111]:=",ExpressionUUID->"d15c2472-0624-440c-b2ee-f052ff0338d2"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox[
     RowBox[{"3", " ", 
       RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
          RowBox[{"2", "+", "s"}], ")"}], "2"]}], 
     RowBox[{
       RowBox[{"(", 
         RowBox[{"3", "+", 
           RowBox[{"2", " ", "s"}]}], ")"}], " ", 
       RowBox[{"(", 
         RowBox[{"3", "+", 
           RowBox[{"2", " ", "s"}], "+", 
           SuperscriptBox["s", "2"]}], ")"}]}]], 
    RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"1", "+", "s"}], ")"}], "2"], " ", 
         RowBox[{"(", 
           RowBox[{"2", "+", "s"}], ")"}]}], 
       RowBox[{
         RowBox[{"(", 
           RowBox[{"3", "+", 
             RowBox[{"2", " ", "s"}]}], ")"}], " ", 
         RowBox[{"(", 
           RowBox[{"3", "+", 
             RowBox[{"2", " ", "s"}], "+", 
             SuperscriptBox["s", "2"]}], ")"}]}]]}], 
    RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"1", "+", "s"}], ")"}], "2"], " ", 
         RowBox[{"(", 
           RowBox[{"2", "+", "s"}], ")"}]}], 
       RowBox[{
         RowBox[{"(", 
           RowBox[{"3", "+", 
             RowBox[{"2", " ", "s"}]}], ")"}], " ", 
         RowBox[{"(", 
           RowBox[{"3", "+", 
             RowBox[{"2", " ", "s"}], "+", 
             SuperscriptBox["s", "2"]}], ")"}]}]]}], 
    FractionBox[
     RowBox[{"3", " ", 
       RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
          RowBox[{"2", "+", "s"}], ")"}], "2"]}], 
     RowBox[{
       RowBox[{"(", 
         RowBox[{"3", "+", 
           RowBox[{"2", " ", "s"}]}], ")"}], " ", 
       RowBox[{"(", 
         RowBox[{"3", "+", 
           RowBox[{"2", " ", "s"}], "+", 
           SuperscriptBox["s", "2"]}], ")"}]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, 
     InterpretationBox[#, 
      TransferFunctionModel[{{{
         3 (1 + $CellContext`s) (2 + $CellContext`s)^2, (-3) (
            1 + $CellContext`s)^2 (
           2 + $CellContext`s)}, {(-3) (1 + $CellContext`s)^2 (
           2 + $CellContext`s), 
          3 (1 + $CellContext`s) (2 + $CellContext`s)^2}}, (3 + 
         2 $CellContext`s) (3 + 
         2 $CellContext`s + $CellContext`s^2)}, $CellContext`s], AutoDelete -> 
      True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 2, 2, 
     Control`CountStates[
      TransferFunctionModel[{{{
         3 (1 + $CellContext`s) (2 + $CellContext`s)^2, (-3) (
            1 + $CellContext`s)^2 (
           2 + $CellContext`s)}, {(-3) (1 + $CellContext`s)^2 (
           2 + $CellContext`s), 
          3 (1 + $CellContext`s) (2 + $CellContext`s)^2}}, (3 + 
         2 $CellContext`s) (3 + 
         2 $CellContext`s + $CellContext`s^2)}, $CellContext`s]], 1, {}, {
     False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#, #2}, {#3, #4}}, AllowedDimensions -> {2, 2}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #5, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 2}, ","], "}"}], ",", 
        RowBox[{"{", 
          TemplateSlotSequence[{3, 4}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#5}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{
     3 (1 + $CellContext`s) (2 + $CellContext`s)^2, (-3) (
        1 + $CellContext`s)^2 (
       2 + $CellContext`s)}, {(-3) (1 + $CellContext`s)^2 (
       2 + $CellContext`s), 3 (1 + $CellContext`s) (2 + $CellContext`s)^2}}, (
     3 + 2 $CellContext`s) (3 + 
     2 $CellContext`s + $CellContext`s^2)}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{
  3.504775554694952*^9, 3.504775826096999*^9, {3.504776096250635*^9, 
   3.504776114055523*^9}, 3.504776234129036*^9, {3.504776270375798*^9, 
   3.5047763169884243`*^9}, {3.5047763541484823`*^9, 3.504776429726378*^9}, 
   3.5047764745804243`*^9, 3.504776558272933*^9, 3.504776826534007*^9, 
   3.504780232781805*^9, 3.504786717012931*^9, 3.5047868198616447`*^9, 
   3.5047869205761833`*^9, {3.5047871658504257`*^9, 3.504787199795455*^9}, 
   3.504787240674863*^9, 3.5047873353231373`*^9, 3.504787411334483*^9, 
   3.504787465097321*^9, {3.5047892714697523`*^9, 3.504789292469207*^9}, 
   3.504789331414483*^9, {3.5047893978991823`*^9, 3.504789464490657*^9}, 
   3.5047895229549103`*^9, 3.504789571154038*^9, 3.504789607421359*^9, {
   3.5047896422883253`*^9, 3.5047896697240143`*^9}, {3.504789704777347*^9, 
   3.504789728210425*^9}, 3.5047899981315107`*^9, 3.504790045015909*^9, 
   3.5047901250019073`*^9, 3.504790179397202*^9, 3.504790210341783*^9, 
   3.504790306112062*^9, {3.504790351912717*^9, 3.504790396307242*^9}, {
   3.504791022779787*^9, 3.504791041480191*^9}, 3.504791333213944*^9, {
   3.504791368638917*^9, 3.504791457629284*^9}, {3.504791494225871*^9, 
   3.504791505045026*^9}, 3.5048059052215347`*^9, 3.528837651777829*^9, 
   3.793303441096313*^9, 3.793303498244973*^9, 3.793324700270673*^9, 
   3.793324748129786*^9, 3.793851184034602*^9, 3.823227968818758*^9},
 FontSize->12,
 CellLabel->
  "Out[2111]=",ExpressionUUID->"4710703a-5d73-416b-ad58-8daa1bc0eca9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S3a", " ", "=", "  ", 
  RowBox[{
   RowBox[{"Inverse", "[", 
    RowBox[{"I0", "+", " ", 
     RowBox[{"G3", ".", "K3a"}]}], "]"}], " ", "//", " ", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.504786581777582*^9, 3.504786593911395*^9}},
 FontSize->12,
 CellLabel->
  "In[2112]:=",ExpressionUUID->"21427c7a-19f8-4bec-b95c-e5a6e5496198"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"s", " ", 
       RowBox[{"(", 
        RowBox[{"20", "+", "s"}], ")"}]}], 
      RowBox[{"30", "+", 
       RowBox[{"20", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"s", " ", 
       RowBox[{"(", 
        RowBox[{"20", "+", "s"}], ")"}]}], 
      RowBox[{"30", "+", 
       RowBox[{"20", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.504786596299656*^9, 3.504786621643824*^9}, 
   3.504786717146669*^9, 3.5047868199126663`*^9, 3.504786920625235*^9, {
   3.5047871659003687`*^9, 3.5047871998473*^9}, 3.5047872407204247`*^9, 
   3.504787335389431*^9, 3.504787411397472*^9, 3.5047874651480713`*^9, {
   3.504789271524404*^9, 3.504789292502569*^9}, 3.504789331446856*^9, {
   3.504789397938614*^9, 3.504789464554048*^9}, 3.504789523021531*^9, 
   3.504789571203227*^9, 3.504789607469016*^9, {3.504789642335758*^9, 
   3.504789669772819*^9}, {3.504789704826634*^9, 3.5047897282590218`*^9}, 
   3.5047899981916513`*^9, 3.5047900450658216`*^9, 3.504790125051282*^9, 
   3.50479017943145*^9, 3.504790210387928*^9, 3.504790306156785*^9, {
   3.504790351944715*^9, 3.50479039635693*^9}, {3.504791022828396*^9, 
   3.504791041532173*^9}, 3.504791333263927*^9, {3.504791368740519*^9, 
   3.504791457679195*^9}, {3.5047914942754908`*^9, 3.504791505077608*^9}, 
   3.504805905271159*^9, 3.528837651825211*^9, 3.793303441167962*^9, 
   3.793303498264367*^9, 3.7933247002903233`*^9, 3.79332474833604*^9, 
   3.79385118411547*^9, 3.8232279688847857`*^9},
 FontSize->12,
 CellLabel->
  "Out[2112]=",ExpressionUUID->"a652b871-219e-4fd0-9605-567294145e9d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T3a", " ", "=", " ", 
  RowBox[{
   RowBox[{"I0", "-", "S3a"}], " ", "//", " ", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.504786631456008*^9, 3.50478663398131*^9}},
 FontSize->12,
 CellLabel->
  "In[2113]:=",ExpressionUUID->"1401d3a8-6498-42cf-854b-bb40c73a2170"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["30", 
      RowBox[{"30", "+", 
       RowBox[{"20", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["30", 
      RowBox[{"30", "+", 
       RowBox[{"20", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.50478663541187*^9, 3.5047867171963797`*^9, 3.504786819959778*^9, 
   3.504786920659294*^9, {3.504787165950549*^9, 3.504787199952106*^9}, 
   3.504787240770932*^9, 3.504787335450441*^9, 3.50478741144499*^9, 
   3.50478746520443*^9, {3.504789271570177*^9, 3.5047892925353127`*^9}, 
   3.504789331480413*^9, {3.504789397981756*^9, 3.504789464600086*^9}, 
   3.504789523090598*^9, 3.504789571256817*^9, 3.504789607517007*^9, {
   3.5047896423850107`*^9, 3.504789669823701*^9}, {3.504789704876975*^9, 
   3.504789728308846*^9}, 3.504789998238167*^9, 3.504790045116219*^9, 
   3.504790125102206*^9, 3.5047901794772453`*^9, 3.5047902104384947`*^9, 
   3.5047903062072067`*^9, {3.504790351978808*^9, 3.504790396407446*^9}, {
   3.5047910228790007`*^9, 3.504791041579968*^9}, 3.50479133331415*^9, {
   3.504791368841446*^9, 3.5047914577290792`*^9}, {3.504791494326111*^9, 
   3.504791505110917*^9}, 3.504805905319113*^9, 3.5288376518750563`*^9, 
   3.793303441175498*^9, 3.79330349834068*^9, 3.793324700353258*^9, 
   3.79332474834475*^9, 3.793851184120865*^9, 3.823227968892261*^9},
 FontSize->12,
 CellLabel->
  "Out[2113]=",ExpressionUUID->"73748d4b-2b5e-4ddd-9945-cd27071acf1a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T3atf", " ", "=", "  ", 
  RowBox[{"TransferFunctionModel", "[", 
   RowBox[{"T3a", ",", "s"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.50478654614865*^9, 3.504786561649191*^9}},
 FontSize->12,
 CellLabel->
  "In[2114]:=",ExpressionUUID->"ac33ff65-2c8d-4fe7-ad81-9110805e4287"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox["30", 
     RowBox[{"30", "+", 
       RowBox[{"20", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]], "0", "0", 
    FractionBox["30", 
     RowBox[{"30", "+", 
       RowBox[{"20", " ", "s"}], "+", 
       SuperscriptBox["s", "2"]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, 
     InterpretationBox[#, 
      TransferFunctionModel[{{{30, 0}, {0, 
        30}}, {{30 + 20 $CellContext`s + $CellContext`s^2, 1}, {
         1, 30 + 20 $CellContext`s + $CellContext`s^2}}}, $CellContext`s], 
      AutoDelete -> True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 2, 2, 
     Control`CountStates[
      TransferFunctionModel[{{{30, 0}, {0, 
        30}}, {{30 + 20 $CellContext`s + $CellContext`s^2, 1}, {
         1, 30 + 20 $CellContext`s + $CellContext`s^2}}}, $CellContext`s]], 
     1, {}, {False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#, #2}, {#3, #4}}, AllowedDimensions -> {2, 2}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #5, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 2}, ","], "}"}], ",", 
        RowBox[{"{", 
          TemplateSlotSequence[{3, 4}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#5}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{30, 0}, {0, 
    30}}, {{30 + 20 $CellContext`s + $CellContext`s^2, 1}, {
     1, 30 + 20 $CellContext`s + $CellContext`s^2}}}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{
  3.504786640814892*^9, 3.50478671725359*^9, 3.504786820008786*^9, 
   3.504786920708843*^9, {3.504787166000804*^9, 3.504787200048147*^9}, 
   3.504787240821031*^9, 3.504787335499511*^9, 3.5047874114939737`*^9, 
   3.504787465249208*^9, {3.5047892716206284`*^9, 3.5047892925692673`*^9}, 
   3.504789331513776*^9, {3.5047893980155973`*^9, 3.504789464650807*^9}, 
   3.504789523155239*^9, 3.5047895713061743`*^9, 3.504789607565667*^9, {
   3.504789642424221*^9, 3.504789669874261*^9}, {3.5047897049278383`*^9, 
   3.5047897283605013`*^9}, 3.504789998289154*^9, 3.5047900451671762`*^9, 
   3.504790125152442*^9, 3.504790179528314*^9, 3.50479021048886*^9, 
   3.504790306258265*^9, {3.5047903520118093`*^9, 3.504790396462673*^9}, {
   3.5047910229293747`*^9, 3.504791041630673*^9}, 3.5047913333647747`*^9, {
   3.504791368941308*^9, 3.504791457780264*^9}, {3.504791494377034*^9, 
   3.504791505144835*^9}, 3.504805905434606*^9, 3.5288376519263983`*^9, 
   3.79330344129679*^9, 3.793303498480895*^9, 3.793324700479409*^9, 
   3.79332474843852*^9, 3.793851184234507*^9, 3.823227968988143*^9},
 FontSize->12,
 CellLabel->
  "Out[2114]=",ExpressionUUID->"0c3fb15c-82e6-4b7c-a759-483ea93cb2f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u3atf", " ", "=", "  ", 
  RowBox[{"TransferFunctionModel", "[", 
   RowBox[{
    RowBox[{"S3a", ".", "K3a"}], ",", "s"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.504786857455653*^9, 3.504786895201705*^9}, 
   3.504790115235551*^9},
 FontSize->12,
 CellLabel->
  "In[2115]:=",ExpressionUUID->"4fed043f-cf4e-4c55-89a7-83e6c7ba537e"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox[
     RowBox[{"30", " ", 
       RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
          RowBox[{"2", "+", "s"}], ")"}], "2"]}], 
     RowBox[{
       RowBox[{"(", 
         RowBox[{"3", "+", 
           RowBox[{"2", " ", "s"}]}], ")"}], " ", 
       RowBox[{"(", 
         RowBox[{"30", "+", 
           RowBox[{"20", " ", "s"}], "+", 
           SuperscriptBox["s", "2"]}], ")"}]}]], 
    RowBox[{"-", 
      FractionBox[
       RowBox[{"30", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"1", "+", "s"}], ")"}], "2"], " ", 
         RowBox[{"(", 
           RowBox[{"2", "+", "s"}], ")"}]}], 
       RowBox[{
         RowBox[{"(", 
           RowBox[{"3", "+", 
             RowBox[{"2", " ", "s"}]}], ")"}], " ", 
         RowBox[{"(", 
           RowBox[{"30", "+", 
             RowBox[{"20", " ", "s"}], "+", 
             SuperscriptBox["s", "2"]}], ")"}]}]]}], 
    RowBox[{"-", 
      FractionBox[
       RowBox[{"30", " ", 
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"1", "+", "s"}], ")"}], "2"], " ", 
         RowBox[{"(", 
           RowBox[{"2", "+", "s"}], ")"}]}], 
       RowBox[{
         RowBox[{"(", 
           RowBox[{"3", "+", 
             RowBox[{"2", " ", "s"}]}], ")"}], " ", 
         RowBox[{"(", 
           RowBox[{"30", "+", 
             RowBox[{"20", " ", "s"}], "+", 
             SuperscriptBox["s", "2"]}], ")"}]}]]}], 
    FractionBox[
     RowBox[{"30", " ", 
       RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
          RowBox[{"2", "+", "s"}], ")"}], "2"]}], 
     RowBox[{
       RowBox[{"(", 
         RowBox[{"3", "+", 
           RowBox[{"2", " ", "s"}]}], ")"}], " ", 
       RowBox[{"(", 
         RowBox[{"30", "+", 
           RowBox[{"20", " ", "s"}], "+", 
           SuperscriptBox["s", "2"]}], ")"}]}]], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, 
     InterpretationBox[#, 
      TransferFunctionModel[{{{
         30 (1 + $CellContext`s) (2 + $CellContext`s)^2, (-30) (
            1 + $CellContext`s)^2 (
           2 + $CellContext`s)}, {(-30) (1 + $CellContext`s)^2 (
           2 + $CellContext`s), 
          30 (1 + $CellContext`s) (2 + $CellContext`s)^2}}, (3 + 
         2 $CellContext`s) (30 + 
         20 $CellContext`s + $CellContext`s^2)}, $CellContext`s], AutoDelete -> 
      True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 2, 2, 
     Control`CountStates[
      TransferFunctionModel[{{{
         30 (1 + $CellContext`s) (2 + $CellContext`s)^2, (-30) (
            1 + $CellContext`s)^2 (
           2 + $CellContext`s)}, {(-30) (1 + $CellContext`s)^2 (
           2 + $CellContext`s), 
          30 (1 + $CellContext`s) (2 + $CellContext`s)^2}}, (3 + 
         2 $CellContext`s) (30 + 
         20 $CellContext`s + $CellContext`s^2)}, $CellContext`s]], 1, {}, {
     False, False}, False, Automatic, None, Automatic}, {}},
   "TransferFunctionModelMinimal",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{
           TooltipBox[
            StyleBox[
             StyleBox[
             "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #], 
           TooltipBox[
            StyleBox[
             StyleBox[
             "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #2]}, {
           TooltipBox[
            StyleBox[
             StyleBox[
             "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #3], 
           TooltipBox[
            StyleBox[
             StyleBox[
             "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #4]}}, 
         AllowedDimensions -> {2, 2}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #5, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 2}, ","], "}"}], ",", 
        RowBox[{"{", 
          TemplateSlotSequence[{3, 4}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#5}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{
     30 (1 + $CellContext`s) (2 + $CellContext`s)^2, (-30) (
        1 + $CellContext`s)^2 (
       2 + $CellContext`s)}, {(-30) (1 + $CellContext`s)^2 (
       2 + $CellContext`s), 
      30 (1 + $CellContext`s) (2 + $CellContext`s)^2}}, (3 + 
     2 $CellContext`s) (30 + 
     20 $CellContext`s + $CellContext`s^2)}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{{3.5047868991903048`*^9, 3.504786920760295*^9}, {
   3.504787166051775*^9, 3.5047872000992727`*^9}, 3.504787240872673*^9, 
   3.5047873355383177`*^9, 3.504787411545463*^9, 3.504787465302185*^9, {
   3.5047892716710043`*^9, 3.504789292603343*^9}, 3.504789331548472*^9, {
   3.504789398049547*^9, 3.5047894647017193`*^9}, 3.504789523224079*^9, 
   3.504789571357897*^9, 3.504789607619607*^9, {3.504789642472186*^9, 
   3.504789669924676*^9}, {3.504789704978606*^9, 3.504789728397715*^9}, 
   3.504789998339201*^9, 3.504790045216733*^9, 3.5047901252039824`*^9, 
   3.504790179578435*^9, 3.5047902105394*^9, 3.504790306309486*^9, {
   3.5047903520459127`*^9, 3.504790396508877*^9}, {3.504791022980102*^9, 
   3.504791041681181*^9}, 3.5047913334159737`*^9, 3.504791368989202*^9, {
   3.504791399031255*^9, 3.504791457830331*^9}, {3.504791494430759*^9, 
   3.504791505178845*^9}, 3.504805905468524*^9, 3.528837651978114*^9, 
   3.79330344139823*^9, 3.7933034986034107`*^9, 3.7933247005842457`*^9, 
   3.7933247485610037`*^9, 3.793851184328177*^9, 3.8232279691485*^9},
 FontSize->12,
 CellLabel->
  "Out[2115]=",ExpressionUUID->"7ee18625-d84f-40e1-a229-176b7831d442"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"tmax", " ", "=", " ", "3"}], ";"}]], "Input",
 CellChangeTimes->{{3.5047871119556627`*^9, 3.504787115284381*^9}, {
   3.50478717753566*^9, 3.50478719537442*^9}, 3.504790364488516*^9},
 FontSize->12,
 CellLabel->
  "In[2116]:=",ExpressionUUID->"a45bd6d3-ddcb-4434-b0e9-a09ba9bf2b77"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y3", " ", "=", " ", 
    RowBox[{"OutputResponse", "[", 
     RowBox[{"T3tf", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"UnitStep", "[", "t", "]"}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "3"}], ")"}], 
         RowBox[{"UnitStep", "[", "t", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.504775572277047*^9, 3.5047755745704823`*^9}, {
  3.504775862564402*^9, 3.504775876815696*^9}, {3.504775953687613*^9, 
  3.504775953791196*^9}, {3.504776262319998*^9, 3.504776283094812*^9}, {
  3.504787098360477*^9, 3.504787119071186*^9}},
 FontSize->12,
 CellLabel->
  "In[2117]:=",ExpressionUUID->"1f25bd48-fa86-4052-9bdd-8be6c0c45100"],

Cell[BoxData[
 RowBox[{
  RowBox[{"u3", " ", "=", " ", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"u3tf", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"UnitStep", "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}], 
        RowBox[{"UnitStep", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.504775590721219*^9, 3.5047755928972187`*^9}, {
  3.5047758652277803`*^9, 3.504775879458438*^9}, {3.504775955624082*^9, 
  3.504775955780403*^9}, {3.504776264310092*^9, 3.504776285430656*^9}, {
  3.504776698603972*^9, 3.50477670073624*^9}, {3.5047871012240667`*^9, 
  3.504787121158567*^9}},
 FontSize->12,
 CellLabel->
  "In[2118]:=",ExpressionUUID->"4f31fa4d-0d5c-4a32-88ec-750b2a32b124"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"S3a", " ", "=", " ", 
   RowBox[{"Inverse", "[", 
    RowBox[{"I0", "+", " ", 
     RowBox[{"G3", ".", "K3a"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T3a", " ", "=", " ", 
   RowBox[{"I0", "-", "S3a"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5047766221300383`*^9, 3.504776657345853*^9}, {
  3.5047801702698183`*^9, 3.504780175856242*^9}},
 FontSize->12,
 CellLabel->
  "In[2119]:=",ExpressionUUID->"c1f2a253-f0a4-4286-94db-6612f40c301a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"y3a", " ", "=", " ", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"T3atf", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"UnitStep", "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}], 
        RowBox[{"UnitStep", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u3a", " ", "=", " ", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"u3atf", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"UnitStep", "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}], 
        RowBox[{"UnitStep", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.504776768627499*^9, 3.504776776273419*^9}, {
   3.504780259542119*^9, 3.5047802928724213`*^9}, 3.504786529112397*^9, {
   3.504787104010943*^9, 3.5047871255053062`*^9}},
 FontSize->12,
 CellLabel->
  "In[2121]:=",ExpressionUUID->"00bcf2a1-c906-4cab-957b-8a669119ec5a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y3", ",", "u3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "tmax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "3"}], "}"}]}], "}"}]}]}], "]"}]}], ";", 
  RowBox[{"p3a", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y3a", ",", "u3a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "tmax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "3"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{"p3", ",", "p3a"}], "}"}], "]"}], "\[IndentingNewLine]"}], "Input",\

 CellChangeTimes->{{3.504775850770293*^9, 3.5047758535786543`*^9}, {
   3.5047758865295353`*^9, 3.50477588804072*^9}, {3.504776793951486*^9, 
   3.504776818712071*^9}, {3.504787002533296*^9, 3.504787075810899*^9}, {
   3.504787128768993*^9, 3.504787137328203*^9}, {3.5047874223118963`*^9, 
   3.504787428601479*^9}, {3.5047897718948936`*^9, 3.5047897808586817`*^9}, {
   3.50478982695422*^9, 3.504789854404461*^9}, {3.504790140537352*^9, 
   3.504790142259302*^9}, {3.504790228651325*^9, 3.504790230229456*^9}, {
   3.5047909793810596`*^9, 3.504790979750536*^9}, 3.504791059994196*^9, {
   3.5047914802564297`*^9, 3.5047914806450853`*^9}, 3.50479151599475*^9, {
   3.7933033960142813`*^9, 3.793303422479066*^9}},
 FontSize->12,
 CellLabel->
  "In[2123]:=",ExpressionUUID->"8285c3fc-b4b0-44a6-a88a-f45270faada7"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV13cglV0YAPD7XupK+ZKtrKyQVSQankNSNGhZGUkkJISEIkllJSLZUkZm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           "]]},
         Annotation[#, "Charting`Private`Tag$791252#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV13k4lF8bB/B5RhpJyRYJhawRqRS93IcspZLysxYhaZOQPVtCsiVb9iWK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           "]]},
         Annotation[#, "Charting`Private`Tag$791252#1"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV1nk41N0XAHDbzBdlLX4ha5aiVQoV52arLBFJSrJlS5ZCokXSYpddKLQq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           "]]},
         Annotation[#, "Charting`Private`Tag$791252#2"]& ], 
        TagBox[
         {RGBColor[0.922526, 0.385626, 0.209179], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV13k8VdsXAPB7Lrlek2TIkyTiCaVRI3sbQiMlkqESSfKQJyEyhGTILEXG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           "]]},
         Annotation[#, "Charting`Private`Tag$791252#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{14.999999999999996`, 8.000000000000057}, {7.5, 
       6.500000000000028}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 3}, {-2, 3}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}], {160.03139100732724, -97.24669038733732},
      ImageScaled[{0.5, 0.5}], {300.0588581387386, 185.23179121397587}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVz3k41PsCBvAJ+ZWWUx3kkKIYS9dVaZPyfi3p6DjhOJaQDJIQrmQbUdaa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           "]]},
         Annotation[#, "Charting`Private`Tag$791303#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVznk81PkDx/HJ9bVF0a8mCR00jh5WET/y4/1JW6lUpEOSjHs7DLYaOUOH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           "]]},
         Annotation[#, "Charting`Private`Tag$791303#1"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwd1nk0lVsfB/DDkUfpRpIQMl+NJJXq6vskLypumkuFRLm4hiZzaVCEOkhJ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           "]]},
         Annotation[#, "Charting`Private`Tag$791303#2"]& ], 
        TagBox[
         {RGBColor[0.922526, 0.385626, 0.209179], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwl13k4VO0bB/Cx1CgVSioKSUpa0EJ6eU4r9aZUokiULKUFlYqWUbQQiZQt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           "]]},
         Annotation[#, "Charting`Private`Tag$791303#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{14.999999999999996`, 8.000000000000057}, {7.5, 
       6.500000000000028}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 3}, {-2, 3}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}], {480.09417302198176, -97.24669038733732},
      ImageScaled[{0.5, 0.5}], {300.0588581387386, 185.23179121397587}]}, {}},
  
  ImageSize->{
    UpTo[600], 
    UpTo[223]},
  PlotRange->{{0, 640.125564029309}, {-194.49338077467465`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.504776827135028*^9, 3.504780234936344*^9, {3.504780278074354*^9, 
   3.504780298925452*^9}, 3.504786717648312*^9, 3.504786820401075*^9, 
   3.5047869210836554`*^9, {3.504787044815975*^9, 3.5047870769926233`*^9}, {
   3.504787166543569*^9, 3.504787200569481*^9}, 3.5047872415327597`*^9, 
   3.504787335924198*^9, 3.504787411937818*^9, 3.504787465669876*^9, {
   3.504789272051712*^9, 3.504789292904071*^9}, 3.504789331887803*^9, {
   3.504789398430262*^9, 3.504789465085168*^9}, 3.504789523614296*^9, 
   3.5047895721474648`*^9, 3.50478960799104*^9, {3.504789642848403*^9, 
   3.504789670342614*^9}, {3.50478970542004*^9, 3.504789728647481*^9}, {
   3.504789774396348*^9, 3.504789781628605*^9}, {3.504789831474038*^9, 
   3.504789854973525*^9}, 3.504789998688518*^9, 3.504790045510089*^9, {
   3.504790125500469*^9, 3.504790143122706*^9}, 3.504790179894394*^9, {
   3.504790210880423*^9, 3.504790230983246*^9}, 3.504790307030875*^9, {
   3.504790352431325*^9, 3.5047903968774776`*^9}, 3.5047909807216787`*^9, {
   3.504791023325317*^9, 3.504791060811524*^9}, 3.504791333794458*^9, 
   3.504791369336628*^9, {3.504791399395413*^9, 3.504791516625936*^9}, 
   3.50480590574856*^9, 3.5288376524643393`*^9, 3.793303441760742*^9, 
   3.793303499023972*^9, 3.793324700958769*^9, 3.7933247490185823`*^9, 
   3.793851184721425*^9, 3.82322796952455*^9},
 FontSize->12,
 CellLabel->
  "Out[2124]=",ExpressionUUID->"af274edc-5d3f-4c88-9ef4-674dbdfaac54"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.7938511334937696`*^9, 3.79385113699925*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"76eb9063-01ef-40fc-b4fd-e5d2a79a4b2d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dt", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"y3", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"y3", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"u3", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"u3", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"y3a", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"y3a", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"u3a", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"u3a", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax", ",", "dt"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<MIMO-shower-problem_out.dat\>\"", ",", " ", "dat"}], "]"}], 
    ";"}], "\[IndentingNewLine]", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.504776805285945*^9, 3.504776817294106*^9}, {
  3.504786442421857*^9, 3.504786487681871*^9}, {3.504787141568613*^9, 
  3.5047871420598907`*^9}, {3.504790384715968*^9, 3.5047903884251423`*^9}, {
  3.7933034539707747`*^9, 3.7933034603566713`*^9}, {3.793851151302195*^9, 
  3.7938511729705353`*^9}},
 FontSize->12,
 CellLabel->
  "In[2125]:=",ExpressionUUID->"fb3590d5-6291-41af-b81f-ff4f44c01ad3"]
}, Open  ]]
},
WindowSize->{906, 631},
WindowMargins->{{28, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"7725ed55-e9e9-413b-940c-2421287798ce"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 307, 5, 62, "Section",ExpressionUUID->"34c7fbd8-4ef0-42b2-8e04-6e582f05eb5d"],
Cell[889, 29, 172, 4, 29, "Input",ExpressionUUID->"80d1cc00-918b-41f7-8496-6fdda952b42c"],
Cell[CellGroupData[{
Cell[1086, 37, 339, 8, 29, "Input",ExpressionUUID->"34c6cd69-3d5f-4f37-a1c8-c64e34647e0e"],
Cell[1428, 47, 1738, 34, 58, "Output",ExpressionUUID->"02c34d0a-fe14-4230-b487-fbed144a78ed"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3203, 86, 877, 26, 61, "Input",ExpressionUUID->"8f36a4b4-7849-4e28-a995-d122a12ddecb"],
Cell[4083, 114, 1931, 37, 49, "Output",ExpressionUUID->"3e0789d2-c0cb-449d-a2ca-158286de61ad"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6051, 156, 236, 5, 29, "Input",ExpressionUUID->"c2021ab2-ae8a-4ca0-8309-560262e75cc6"],
Cell[6290, 163, 33936, 657, 244, "Output",ExpressionUUID->"2b4a6168-bc51-465b-ba26-98cd3164a66d"]
}, Open  ]],
Cell[40241, 823, 496, 9, 50, "Text",ExpressionUUID->"04dadf28-a6ab-4811-a238-007c5afb646a"],
Cell[CellGroupData[{
Cell[40762, 836, 469, 12, 29, "Input",ExpressionUUID->"b009454a-d2c0-451a-9f31-ac5932038544"],
Cell[41234, 850, 2987, 87, 108, "Output",ExpressionUUID->"2de95c1a-32fc-4351-b9ff-e7b9371be823"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44258, 942, 430, 11, 29, "Input",ExpressionUUID->"5a006b56-b528-4f18-974b-4629ad021b0d"],
Cell[44691, 955, 3092, 76, 86, "Output",ExpressionUUID->"d359c214-0793-485a-9ea8-d26a3bdcec44"]
}, Open  ]],
Cell[47798, 1034, 928, 21, 29, "Input",ExpressionUUID->"3a24d594-4692-42f8-ae0c-47938bd69246"],
Cell[48729, 1057, 1463, 32, 46, "Input",ExpressionUUID->"d26edfe7-db94-439f-9256-05f65234175e"],
Cell[CellGroupData[{
Cell[50217, 1093, 320, 8, 29, "Input",ExpressionUUID->"28db5ad6-6c36-4a0c-b418-b4b8e564e967"],
Cell[50540, 1103, 4834, 139, 79, "Output",ExpressionUUID->"af2e23ad-a26e-4d4e-8343-aae91de231a2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55411, 1247, 523, 11, 29, "Input",ExpressionUUID->"21f495eb-eb15-4d16-afd2-7acdf2023ec4"],
Cell[55937, 1260, 95563, 1828, 212, "Output",ExpressionUUID->"4d83f079-1dcc-46f5-86f8-07419e975a5e"]
}, Open  ]],
Cell[151515, 3091, 485, 14, 49, "Text",ExpressionUUID->"e780d994-a6f6-4e22-8246-40d1ac01c21c"],
Cell[CellGroupData[{
Cell[152025, 3109, 481, 12, 29, "Input",ExpressionUUID->"1908c90f-9c08-49dd-bf80-bab08be3bcf5"],
Cell[152509, 3123, 93747, 1818, 214, "Output",ExpressionUUID->"01d7de89-0c0e-429e-a79e-de898b314c05"]
}, Open  ]],
Cell[CellGroupData[{
Cell[246293, 4946, 363, 10, 29, "Input",ExpressionUUID->"e750a442-8682-4b1c-978a-0f0e2cdba690"],
Cell[246659, 4958, 2144, 44, 50, "Output",ExpressionUUID->"6a99ade8-4b5f-4ec2-a586-1a347efbee58"]
}, Open  ]],
Cell[CellGroupData[{
Cell[248840, 5007, 294, 7, 29, "Input",ExpressionUUID->"07a2e0d1-c131-405d-a216-d9b7b912cd98"],
Cell[249137, 5016, 1968, 38, 50, "Output",ExpressionUUID->"8b663f7f-210a-48f8-987e-6d5397f868b2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[251142, 5059, 297, 7, 29, "Input",ExpressionUUID->"fe729b1f-68c7-4cc7-8d1f-dec154c15631"],
Cell[251442, 5068, 4476, 91, 91, "Output",ExpressionUUID->"aa826d77-6849-4926-95a9-235d5dce5203"]
}, Open  ]],
Cell[CellGroupData[{
Cell[255955, 5164, 375, 9, 29, "Input",ExpressionUUID->"d15c2472-0624-440c-b2ee-f052ff0338d2"],
Cell[256333, 5175, 6736, 158, 107, "Output",ExpressionUUID->"4710703a-5d73-416b-ad58-8daa1bc0eca9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[263106, 5338, 367, 10, 29, "Input",ExpressionUUID->"21427c7a-19f8-4bec-b95c-e5a6e5496198"],
Cell[263476, 5350, 1806, 39, 50, "Output",ExpressionUUID->"a652b871-219e-4fd0-9605-567294145e9d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[265319, 5394, 293, 7, 29, "Input",ExpressionUUID->"1401d3a8-6498-42cf-854b-bb40c73a2170"],
Cell[265615, 5403, 1611, 33, 50, "Output",ExpressionUUID->"73748d4b-2b5e-4ddd-9945-cd27071acf1a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[267263, 5441, 302, 7, 29, "Input",ExpressionUUID->"ac33ff65-2c8d-4fe7-ad81-9110805e4287"],
Cell[267568, 5450, 4164, 86, 91, "Output",ExpressionUUID->"0c3fb15c-82e6-4b7c-a759-483ea93cb2f5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[271769, 5541, 356, 9, 29, "Input",ExpressionUUID->"4fed043f-cf4e-4c55-89a7-83e6c7ba537e"],
Cell[272128, 5552, 7020, 171, 55, "Output",ExpressionUUID->"7ee18625-d84f-40e1-a229-176b7831d442"]
}, Open  ]],
Cell[279163, 5726, 317, 7, 29, "Input",ExpressionUUID->"a45bd6d3-ddcb-4434-b0e9-a09ba9bf2b77"],
Cell[279483, 5735, 851, 22, 49, "Input",ExpressionUUID->"1f25bd48-fa86-4052-9bdd-8be6c0c45100"],
Cell[280337, 5759, 854, 22, 29, "Input",ExpressionUUID->"4f31fa4d-0d5c-4a32-88ec-750b2a32b124"],
Cell[281194, 5783, 501, 13, 49, "Input",ExpressionUUID->"c1f2a253-f0a4-4286-94db-6612f40c301a"],
Cell[281698, 5798, 1183, 34, 49, "Input",ExpressionUUID->"00bcf2a1-c906-4cab-957b-8a669119ec5a"],
Cell[CellGroupData[{
Cell[282906, 5836, 1922, 49, 87, "Input",ExpressionUUID->"8285c3fc-b4b0-44a6-a88a-f45270faada7"],
Cell[284831, 5887, 50600, 871, 205, "Output",ExpressionUUID->"af274edc-5d3f-4c88-9ef4-674dbdfaac54"]
}, Open  ]],
Cell[335446, 6761, 182, 3, 51, "Text",ExpressionUUID->"76eb9063-01ef-40fc-b4fd-e5d2a79a4b2d"],
Cell[335631, 6766, 1702, 44, 180, "Input",ExpressionUUID->"fb3590d5-6291-41af-b81f-ff4f44c01ad3"]
}, Open  ]]
}
]
*)

