(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    291198,       5390]
NotebookOptionsPosition[    287609,       5326]
NotebookOutlinePosition[    288005,       5342]
CellTagsIndexPosition[    287962,       5339]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["PID tune:  explore PID tuning rules....  (Problem 3.22)", "Section",
 CellChangeTimes->{{3.598311526884038*^9, 3.5983115405593*^9}, {
  3.793303701800971*^9, 
  3.793303707262805*^9}},ExpressionUUID->"5960a009-d100-4dcd-a274-\
3a6ddb50a095"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[2053]:=",ExpressionUUID->"5c7ed008-b19d-47e6-98f7-d0b42d2ffcc8"],

Cell["Define Sample process and step response", "Text",
 CellChangeTimes->{{3.598311571659669*^9, 3.598311578549725*^9}, {
  3.598311663882916*^9, 3.598311674497301*^9}, {3.5984883937754803`*^9, 
  3.5984883949430447`*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"84b2d739-2ac1-4e38-a794-dfdb80e655cf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmax", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g0", "=", 
   FractionBox[
    RowBox[{"Exp", "[", 
     RowBox[{"-", "s"}], "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"10", " ", "s"}], "+", "1"}], ")"}], "2"]]}], ";", 
  RowBox[{"g0tf", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"g0", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y0out", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"g0tf", ",", "1", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.598299990261166*^9, 3.598300000270298*^9}, {
   3.598300048832502*^9, 3.598300147505599*^9}, {3.5983003145338793`*^9, 
   3.598300406364339*^9}, 3.59830080342203*^9, {3.59830852581588*^9, 
   3.598308533280891*^9}, 3.598308569221326*^9, {3.5983086096211777`*^9, 
   3.59830860998564*^9}, {3.5983116057283573`*^9, 3.598311657701272*^9}, {
   3.598311691643832*^9, 3.5983116963957653`*^9}, 3.598415973717824*^9, 
   3.59846236938579*^9, {3.598462464897149*^9, 3.598462465772596*^9}, {
   3.5984718258096437`*^9, 3.5984718683660297`*^9}, 3.5984730106975822`*^9, {
   3.5984730917372932`*^9, 3.598473091815539*^9}, {3.5984824658332863`*^9, 
   3.5984824771071167`*^9}, {3.598484649687598*^9, 3.5984846499259977`*^9}, {
   3.59848493502066*^9, 3.598484941021224*^9}, {3.598488294687726*^9, 
   3.598488312098785*^9}, {3.5984883879947243`*^9, 3.598488438792996*^9}, {
   3.7933037570610943`*^9, 3.7933037598966627`*^9}, {3.7933038910941973`*^9, 
   3.79330389230571*^9}},
 CellLabel->
  "In[2054]:=",ExpressionUUID->"7ee7bff1-77b3-466e-97fe-7c6b6a8a2c69"],

Cell["\<\
Simple proportional feedback (adjust to find critical gain, kp ~ 20.67, Tc ~ \
14.2)\
\>", "Text",
 CellChangeTimes->{{3.598311571659669*^9, 3.598311578549725*^9}, {
   3.598311663882916*^9, 3.598311674497301*^9}, {3.598311808389928*^9, 
   3.5983118175164557`*^9}, {3.5984158958216248`*^9, 
   3.5984159075369453`*^9}, {3.598416134524806*^9, 3.598416141025721*^9}, {
   3.598416203335421*^9, 3.598416207902755*^9}, {3.598416314031296*^9, 
   3.598416314638133*^9}, 3.5984164887638187`*^9, {3.598463264312915*^9, 
   3.5984632644767313`*^9}, 3.598463418956615*^9},
 Background->GrayLevel[
  0.85],ExpressionUUID->"32bbea04-3afe-4cb6-8015-8d274b687201"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k0", "=", 
   RowBox[{"TransferFunctionModel", "[", 
    RowBox[{"20.67", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L0", "=", 
   RowBox[{"SystemsModelSeriesConnect", "[", 
    RowBox[{"g0tf", ",", "k0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c0", "=", 
   RowBox[{"SystemsModelFeedbackConnect", "[", "L0", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y0", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"c0", ",", "1", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1000"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"g0", ",", "k0", ",", "L0", ",", "c0"}], "}"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"y0", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "900", ",", "1000"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.598311750315029*^9, 3.598311794489285*^9}, {
   3.598415986104369*^9, 3.5984159938535967`*^9}, {3.5984160333922873`*^9, 
   3.598416104637748*^9}, {3.598416166019759*^9, 3.5984161853787947`*^9}, {
   3.598416262019597*^9, 3.598416278384822*^9}, {3.598416438614708*^9, 
   3.598416440877349*^9}, {3.598462244271179*^9, 3.598462259065548*^9}, {
   3.598462410414362*^9, 3.5984624134362288`*^9}, {3.5984625186719017`*^9, 
   3.598462539237975*^9}, {3.598462670344882*^9, 3.598462693179903*^9}, {
   3.5984631495103617`*^9, 3.598463161828862*^9}, {3.598463324104151*^9, 
   3.5984634346899633`*^9}, {3.598467763907645*^9, 3.598467861986495*^9}, {
   3.5984678940670147`*^9, 3.598467920531026*^9}, {3.598467973212315*^9, 
   3.598468048007577*^9}, {3.5984680980359783`*^9, 3.5984681100680523`*^9}, {
   3.5984683660043097`*^9, 3.598468392052232*^9}, {3.598468424083946*^9, 
   3.598468465073203*^9}, {3.5984691052337313`*^9, 3.5984691094513073`*^9}, 
   3.598471874407292*^9, {3.598482481986924*^9, 3.598482482274686*^9}, {
   3.793303874893487*^9, 3.793303879150141*^9}},
 CellLabel->
  "In[2057]:=",ExpressionUUID->"2ea7c208-d6d2-4d41-abe5-0fadcd5c4831"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "s"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"10", " ", "s"}]}], ")"}], "2"]], ",", 
   InterpretationBox[
    TemplateBox[{"20.67`", 
      InterpretationBox["\[InvisibleSpace]", None], {
      TransferFunctionModel, {
       False, False, {False, False}}, $Failed, {{
        Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}}, 
       InterpretationBox[#, 
        TransferFunctionModel[{{{20.67}}, 1}, $CellContext`s], AutoDelete -> 
        True, Editable -> True, BaseStyle -> 
        "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
       Control`CountStates[
        TransferFunctionModel[{{{20.67}}, 1}, $CellContext`s]], 1, {}, {
       False, False}, False, Automatic, None, Automatic}, {}},
     "TransferFunctionModelFull",
     BaseStyle->{NumberMarks -> False},
     DisplayFunction->(TagBox[
       SubsuperscriptBox[
        RowBox[{"(", 
          
          GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
           GridBoxDividers -> {
            "Rows" -> {False, {False}, False}, 
             "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
           "SystemsModelGrid00"], ")"}], #2, 
        ButtonBox[
         GraphicsBox[{
           
           RectangleBox[{0, 0}, DefaultBaseStyle -> 
            "SystemsModelSuperscript"], 
           InsetBox[
            StyleBox[
            "\[ScriptCapitalT]", DefaultBaseStyle -> 
             "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
         ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
           ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
         None], MultilineFunction -> None], 
       EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
             FrontEnd`Value[
              FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
         True}]]& ),
     InterpretationFunction->(
      RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
        RowBox[{"{", 
          RowBox[{"{", 
            TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", 
        ",", "SamplingPeriod", "->", 
        RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
     Tooltip->TransferFunctionModel],
    TransferFunctionModel[{{{20.67}}, 1}, $CellContext`s],
    AutoDelete->True,
    BaseStyle->"TransferFunctionModelMinimal",
    Editable->True], ",", 
   InterpretationBox[
    TemplateBox[{
      FractionBox[
       RowBox[{"20.67`", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "s"}]]}], 
       RowBox[{
         RowBox[{"1.`", "\[VeryThinSpace]"}], "+", 
         RowBox[{"20.`", " ", "s"}], "+", 
         RowBox[{"100.`", " ", 
           SuperscriptBox["s", "2"]}]}]], 
      InterpretationBox["\[InvisibleSpace]", None], {
      TransferFunctionModel, {
       False, False, {False, False}}, $Failed, {{
        Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}}, 
       InterpretationBox[#, 
        TransferFunctionModel[{{{20.67 E^(-$CellContext`s)}}, {{
           1. + 20. $CellContext`s + 100. $CellContext`s^2}}}, $CellContext`s,
          SystemsModelLabels -> {{None}, {None}}, SamplingPeriod -> 
         Automatic], AutoDelete -> True, Editable -> True, BaseStyle -> 
        "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
       Control`CountStates[
        TransferFunctionModel[{{{20.67 E^(-$CellContext`s)}}, {{
           1. + 20. $CellContext`s + 100. $CellContext`s^2}}}, $CellContext`s,
          SystemsModelLabels -> {{None}, {None}}, SamplingPeriod -> 
         Automatic]], 1, {}, {False, False}, False, 
       Automatic, {{None}, {None}}, Automatic}, {}},
     "TransferFunctionModelFull",
     BaseStyle->{NumberMarks -> False},
     DisplayFunction->(TagBox[
       SubsuperscriptBox[
        RowBox[{"(", 
          
          GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
           GridBoxDividers -> {
            "Rows" -> {False, {False}, False}, 
             "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
           "SystemsModelGrid00"], ")"}], #2, 
        ButtonBox[
         GraphicsBox[{
           
           RectangleBox[{0, 0}, DefaultBaseStyle -> 
            "SystemsModelSuperscript"], 
           InsetBox[
            StyleBox[
            "\[ScriptCapitalT]", DefaultBaseStyle -> 
             "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
         ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
           ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
         None], MultilineFunction -> None], 
       EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
             FrontEnd`Value[
              FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
         True}]]& ),
     InterpretationFunction->(
      RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
        RowBox[{"{", 
          RowBox[{"{", 
            TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", 
        ",", "SamplingPeriod", "->", 
        RowBox[{#2}], ",", "SystemsModelLabels", "->", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", "None", "}"}], ",", 
            RowBox[{"{", "None", "}"}]}], "}"}], "]"}]& ),
     Tooltip->TransferFunctionModel],
    TransferFunctionModel[{{{20.67 E^(-$CellContext`s)}}, {{
       1. + 20. $CellContext`s + 100. $CellContext`s^2}}}, $CellContext`s, 
     SystemsModelLabels -> {{None}, {None}}, SamplingPeriod -> Automatic],
    AutoDelete->True,
    BaseStyle->"TransferFunctionModelMinimal",
    Editable->True], ",", 
   InterpretationBox[
    TemplateBox[{
      FractionBox[
       RowBox[{"20.67`", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
            RowBox[{"-", "1.`"}], " ", "s"}]]}], 
       RowBox[{
         RowBox[{"1.`", "\[VeryThinSpace]"}], "+", 
         RowBox[{"20.67`", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
              RowBox[{"-", "1.`"}], " ", "s"}]]}], "+", 
         RowBox[{"20.`", " ", "s"}], "+", 
         RowBox[{"100.`", " ", 
           SuperscriptBox["s", "2"]}]}]], 
      InterpretationBox["\[InvisibleSpace]", None], {
      TransferFunctionModel, {
       False, False, {False, False}}, $Failed, {{
        Control`CommonDump`$DUMMY$}, {Control`CommonDump`$DUMMY$}}, 
       InterpretationBox[#, 
        TransferFunctionModel[{{{20.67 E^(-$CellContext`s)}}, {{
           1. + 20.67 E^(-$CellContext`s) + 20. $CellContext`s + 
            100. $CellContext`s^2}}}, $CellContext`s, SamplingPeriod -> 
         Automatic, SystemsModelLabels -> {{None}, {None}}], AutoDelete -> 
        True, Editable -> True, BaseStyle -> 
        "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
       Control`CountStates[
        TransferFunctionModel[{{{20.67 E^(-$CellContext`s)}}, {{
           1. + 20.67 E^(-$CellContext`s) + 20. $CellContext`s + 
            100. $CellContext`s^2}}}, $CellContext`s, SamplingPeriod -> 
         Automatic, SystemsModelLabels -> {{None}, {None}}]], 1, {}, {
       False, False}, False, Automatic, {{None}, {None}}, Automatic}, {}},
     "TransferFunctionModelFull",
     BaseStyle->{NumberMarks -> False},
     DisplayFunction->(TagBox[
       SubsuperscriptBox[
        RowBox[{"(", 
          
          GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
           GridBoxDividers -> {
            "Rows" -> {False, {False}, False}, 
             "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
           "SystemsModelGrid00"], ")"}], #2, 
        ButtonBox[
         GraphicsBox[{
           
           RectangleBox[{0, 0}, DefaultBaseStyle -> 
            "SystemsModelSuperscript"], 
           InsetBox[
            StyleBox[
            "\[ScriptCapitalT]", DefaultBaseStyle -> 
             "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
         ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
           ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
         None], MultilineFunction -> None], 
       EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
             FrontEnd`Value[
              FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
         True}]]& ),
     InterpretationFunction->(
      RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
        RowBox[{"{", 
          RowBox[{"{", 
            TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", 
        ",", "SamplingPeriod", "->", 
        RowBox[{#2}], ",", "SystemsModelLabels", "->", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", "None", "}"}], ",", 
            RowBox[{"{", "None", "}"}]}], "}"}], "]"}]& ),
     Tooltip->TransferFunctionModel],
    TransferFunctionModel[{{{20.67 E^(-$CellContext`s)}}, {{
       1. + 20.67 E^(-$CellContext`s) + 20. $CellContext`s + 
        100. $CellContext`s^2}}}, $CellContext`s, SamplingPeriod -> Automatic,
      SystemsModelLabels -> {{None}, {None}}],
    AutoDelete->True,
    BaseStyle->"TransferFunctionModelMinimal",
    Editable->True]}], "}"}]], "Output",
 CellChangeTimes->{
  3.598462694486518*^9, 3.5984628799989233`*^9, {3.5984631505046387`*^9, 
   3.598463162526637*^9}, {3.5984633249600677`*^9, 3.598463435856819*^9}, 
   3.598467767818283*^9, {3.598467841714794*^9, 3.598467921681147*^9}, {
   3.5984679736756887`*^9, 3.598468049849474*^9}, {3.598468098884239*^9, 
   3.598468110664361*^9}, 3.5984683968132143`*^9, {3.598468432578191*^9, 
   3.59846846611096*^9}, 3.5984685757087317`*^9, 3.598468668491548*^9, 
   3.5984691107420483`*^9, {3.5984691876355133`*^9, 3.59846920632364*^9}, 
   3.5984718753479137`*^9, 3.598473048546444*^9, 3.5984730949443073`*^9, 
   3.598480181416099*^9, 3.598480860632895*^9, 3.5984817939135838`*^9, {
   3.598482501765861*^9, 3.598482522984261*^9}, 3.59848298267634*^9, 
   3.598483018543105*^9, 3.598483104261106*^9, 3.598483629050735*^9, 
   3.598484159932*^9, 3.598484472190959*^9, 3.598484665119294*^9, 
   3.598484782742351*^9, 3.598484896831265*^9, 3.598484944868887*^9, 
   3.598488348876734*^9, {3.598488415677032*^9, 3.598488442236812*^9}, 
   3.598488506055685*^9, 3.598488553902668*^9, 3.598488881993857*^9, {
   3.598488995305579*^9, 3.598489010019356*^9}, {3.59849519863314*^9, 
   3.59849521421037*^9}, 3.598495422414006*^9, 3.598497704629752*^9, 
   3.7573061173520927`*^9, 3.793303765795807*^9, {3.793303875833581*^9, 
   3.79330388025504*^9}, {3.7933247803102837`*^9, 3.793324798306531*^9}, 
   3.7938498027221746`*^9, 3.8232279475081463`*^9},
 CellLabel->
  "Out[2061]=",ExpressionUUID->"4b95643e-b616-458d-a6ae-b523047233e0"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwU23c41f0bB3BFJUqRUGaoSCnSILm/ySNtGYUk2YnsvWVE55xkJKQkm6wy
QrJTWZERQsnee51z/O7fX8/1ujjHd3w+9+f9vp6rfQZWasYbGRgYojcxMPz/
v6Mj7BsYhEjEdqlVrm0MdFBT6GxSQD9xkyamttGhKDQ+zgN9psiAS3APHYSH
zK1L0KIRXzbFiNIh6MxxYg3NoSP8yOAoHaafru2Q20ci3hp8ZnWQpYPWv8pe
Z3QRi/v+ZkU6lJ0mZRWgo07V6blcpoMYWcNrEa1q9fmauTodQv7wXT8hTCIY
szkiEnTosHxiQMAe/TDrROfBe3TQD343mYveJyjTOGdCh9oeh9IZtCBb7RFm
CzocO65AOSZCIsqV7xQaWdPhReBmPSt0Oien3FZ7OjB0NxzJRG+LqQxYcKSD
6bFI2jg6smjNVdyFDg1+d+slRPF6AzZTE1zpcPLXwVhz9LrKyJKpGx1eHZm2
SEVbcBgb26I3+xbKD6PPLC2er8Lff9jmve3gfhLBkDkecwe/r+3QxW5j9FNt
dU8FJzooeLFnJKBtC4eZTPF6klp+ufWjP+TsV2vH62UTi78sfIBELIfIP3uK
9+Pobs57D13dzLX41JQOPU3SY6/R2d5qnzrwefy3f62oB83ND4fNb9Mhw6Uy
mP8giTDg7wxR0qADZ8MTHV20xty3c2ZX6PDPkW/1F7r0jB8bWY4OV77/+8oj
RiL+m+/b+PQYHT4Ivou6he4YSpvv2k+HR7VnZVvR0U9392mx0WGUb/NWTnES
MbSpbTFoA64Xm4YONfSfByf+Y56ngfDeu85N6Ecy94Sm2mgQ/PCgyo5D+L66
NrJpf6HBbMUU9zX0alH3PEcBDSoeeBd8R5/rr/3uEk6De5/eLNZIkIjHbvFn
JS7QoJbdvGbTYRKhaNejdViaBsdMpJ8roQ/9veLpx0cDhh2VJyrQjU92sShM
USFO/5/9pyMkQji0u3GeRAXmvAwlKnpT6YasOlsqWG914DwjSSKSby+kMGlR
AXI3fShE543Xb4kWokIP48G590dJhMsiZ51X2hp45biyLqMfFfgJdT1eA6G7
DSLyx0gEK9s+SqDJGhgUOWhUoVnOKRp2Ca7BoHVV3k8pXB/+/k1Jwasw8fue
88JxEsGnJBeeqrgClCd5IbIyJCJ1/90dO7lXQFJ2a6oHulr9vOvo6DJYh2f/
2nQC3++tkDWmZ8swf2ldjuskiTh6l/cWd/sSUAte0k6eJhHBorrLtCuLEGs8
vdsNvbHAj6dzzyIo7FKS/Izmd8wt1xhcAO+HY3oXZEkE04zCESnPBWDaL1d2
S45EFPhJrLWnzsO20HZfZ3kS8bHWbrPL3CzwWnAwFxH497vNryh8n4QXosdi
V9A6tD/D03cngfP3VWnZcyQiy+L73cT5Cdh2LUi3EF2/mT9HTGACqEcZcvIV
8f3JzpIP2Y5B99yE9nslEtHgJLfyVngYtDJYp2bR5zJeRP/9OAQ/jcT9pP8j
EfcePsh1uDEEda1GmTno08cYA9/5DEJJQdfGbGUSITs7SZ4e/Acv3b6mZ6jg
+/nSUc3z9Q/wyAwR4+i1I2ZVc6Z/IHycqU3iIomYoPOU2Wz5A6Q7BEM6WpFL
2PC+Sh+4Q4FG6iVcz6fK/4Yk/oY7jIm0xCskIryuzfze3g7oLK4IHUCv/ntl
88G6HW7a9x3cf5VESGSPfeqsbYNrA7xqCeg0DrGkcs9WUPgSmhR/jUR0l8ax
tm9oAYEn3tdfq5KIb1G63x+110G4mXrib/QJ+cwUge/fgVX5wBrvDRLhTal+
L1j5DZYZ6pJeoP2ly/X9y2qh2ZGb/kyNRDguD+Ydmq0CFY1R9Sb0FUnadiWW
Kvgs9SmVTZ1EDHPNHBI6WAkZ4waaT9C1v9m6L1mVQ4BBZoafBq73vL3CWx1K
gAo+GyvRf2Kn98XNFYEdv4bWBk38/MQeO233j6DfscLoid69bBHhnJEPbXl1
2iXo6UXZtXX1PLga9jprFZ2wdUfn+KYPIHftv9tON/Hzd6u7ZIJyIFuCJycP
HS9C5L7TyYaDW8c2z6MfqHM2UiwzgbMqJNf6FolQOBX4/YBAGgS/MWTOQjfv
62gt5UqBDV4n9SbQSdH8pHXRJJiU7d5qrkUiLE+adbT5xoMRd9bdFLRMC2vz
i+Y46Jr3yRtEv2Q3cvlg/QrUmjVY92vj+7gq56hrFgO1WQfvGaIfmor+uEp6
AQrk1fw36IOadVlp3RGQZ16/rQ9d7WmyP0w7DOL32xXq6pCIdq3rriu5ZOBh
VGaLQTfh3DP9GARP+3iMfqHvpZZyVu4JgM2lYx+5b+P9yEfeOP3TF9xjSnfc
RP9kDmHo/uEFs87PjMPRBuWiS9uzXeH+TaPiZnRVa0H9+fOO0Hf8FDu7Lono
O0vWzn1iCzfZWUyvo3WaFpdYd1lB3WR3CRmdcN8fql3M4XxdFkcd2itik8WX
y6ZQlOprxnKHRHS9sLc6HWQMxwI1S1XQTYz/LhyRNoYkIzHOQPTzKVN6qrIJ
8Cuu3a9G7zy/OflNjRmECzZ8ZtTD9Zd/9d5ijgWw0OJ2K6L9Xz5Ll2eyAe9O
uwfeaJulf/oLRvawVKBcXop+K/tskerqDA8j9nDT0LHBD2OFlT3gn+24xZm7
eP6+qg3iMvQBHdXPFS7ofhdfdUsPP2g6EspTiJ6L2PByeiYQlFmNHy6imd1Y
BJzKnsCn4VNVMvr4fC503msZfgoWgs8NnNFUTiUZfbNQ4Ls5z1CCPv044sPM
zgioI6m9XkcXH5dpXZ6IBPfK7LPn75GIU8QZravr0XB4la07AJ3FnyFUpfQK
uo5Zun5DM5EeRXP3xoHcK/GCGwZ4f27z29mSEmD0Z6BmBJphaNvfPdlJEMU6
ONeBjh+I+pDXkgLLzvHH9A1JhBvfzmwR03dQoM6b9tCIRHBKTrbG/H4PJsEu
KrnoggtP1ndfyAOu8vbBBbSH0S1KXUk+OEqGi3gYk4hRqsG+l3UfQWbr9tgn
JiRi0dDSIfNsGfyDB2ca0UnmIkYSwuUQ5vj1F4cpricld+LBtgqY7ffnikaH
LmpsZJithJxS+tMUMzx/p6w2bWSoBf0FXclx9M2jZ1b42L/CzsPFdUfvk4jr
HXN3nhz8BtZRTlsL0G77GbfvN6oDSftp32pznNdXQhkvkJsgXfyvw18LnNcF
IfSs/FbQ0Sc4D1ji/tqx88iicRuwRL7KvY8OUmSzu83dDuZMt6em0Xcm0mV0
vTtArLfFbP0h7vejSw0C5l2QGF59m8+GRMTNadBqv/bBsbYJx9toppYsqwPi
f6CImys0Gm0tZ2h5MOgPNEWb1PLYkoiZjbuSN1z+C6txW07stsN5n3qzOLy1
H1TfXWRjcyARZSwGjds2DgG1ur5s3ZlEXBp6KjsRMQGBWxa7FFxIRED1lgNG
DJPAcVFgyQNN5rpt98d8Eg7WPTxCRb91FW3phCmcFzuil11JhO/zcvZY+2lI
7rlhN+NOIrbs9doQu3cW1JZa9/d7k4gwdaP+mAsLwBUaFHTQh0RorxT9sXZf
gM7DZyceoFkknYzHsxfAwCDhwzy6OCr79HeeRbCptz2/+RHu//6Arrb+RQh5
u+OeuD+J+Ot+qCTLaBk0FCqrLNG9lITpyNBl4PnlKJaL7ifMr6x+XobXbD1T
cgH4fFTNVUX2rECmS4bnlUASMSYrure8agXqr198aRVEIirs9p3mXV+FkFHq
+nu06pY3Tf4ia6Dhn224jL6fH/zuvwtr0F3ELeETjPMt9tPJT6Q1GN8/+DH0
Cb6vmtxizR1UyC6L4m9Haxl03JeRpIL97as+vCScj0xshtpXqLAW8kElAa3L
OedmFUAFFqpvex4Z8/7QSa/XM1RoeH7yzCr6jfS6/SMWGoRKjb5SoGCeqOe+
9UaYBntNb5h8QZe8/Ortr0qDng2bvrE+JRE1r4tkLprQIP5l4RFVtKhO07tz
bjQQbxZc6EDfuSn/X108DcYtWrT4Q/B+P8pK6ObRIHtLYMk99D3Rb8Z8mCdP
n518NIp+/KNiSHyYBtT2N0OSz0jEATK7hsMSDcpsNS/boZXInXoTm+igklLC
QUVLULp59YUwv5vtPwWhmCecWW6KHKZD1UHKbV/0x91xy9yn6OA7tOhVje5o
aXtw9hwdziXfTWAOwzxtLCASdgn7hGlt7WW09CnRWB7sL6UHpCYo6Ov/dRrW
Y39xH4xib0ZPXvLYloN5XS5p48nd4bi/r0afqsQ8v2z8QEcLXaXG/YzRkg75
+396xqCfbyWabGzoYD8g/7YHXd2fX7DdgQ7HExO/7IsgEf/CvXa3Y5+YNWIb
N0KzeG2srMe+kS3qtDMFPZHEljjz/z7yr1dmDK3K1JWuiH3lcIKKtuRzEqEp
uaWlDH8+apjjYYM2NIzZZ4GfTxHZG/8BfXh8S5oSfr9Jv2/NEtrql0jwJewr
+9+OjcpFkgipusNjHthX/hlo7PBEp8a3buh9QId44U/Hy9FKgRJsD7Gf6f/d
r8X0gkSozETcltCng0A8xf0CesijjeDWpkP3vaW4YLT+JSYh6Rt0iNmnX12P
5v8QYOKuQgedP7UjO6OwD3ntIC8q0IHnjRSbBvqGWTj3GxnsV/rR0pHoW7tU
ItzF6RAuxHirEy1qFxoXxE8H9rifr/WjMS9/0t1whpEOTXfPVr1Ft1bqVPZh
X6EIJg0PoscC/4wVDdCA5bWTlGUMrr9Kjsod1dg/9Po0s9F7bpucJL2nQaDA
Rdc5tPpL9yjiDQ2YXu2tdHmJ52lmyVFNV+wzdx4NlaAZNh/1LDCmgTf/OCtD
LPaRkx2zmrj+aS8/aQSgvQvVVy+L0GAxRn8w9BVeX9CYO5RR4cPtryxt6Olr
xu8SE6lgyyt9dM9rnN/jmvfVgqkwFc3o/Br94vdmZ/8bVBiOStqaEYfz6ZJX
rUf7GnRGjh+ujicRdLK75YnKVbA3EGxgfIt5vmn8nXrcKmw/omaliL5xKHli
2H0ViIqCnM/ozJ/A7yWzConjvieLEvB51NzyCI5dAetze4isJBJxVsSe9b3W
Mmwe+089Ko1EfPnxRX+PzwLE5TnPt6O3C5w9U6G6ALLe6RFc6ZhfRg15hYUW
wGI3e0cY2nxtkmdn6Tz8gG5dSgaJ+OyjPzuwOAcvw21NHmXi9RWRm4P0ZkFa
4bWLZS7u76yz1epHJoHJ4I5hDnrJ5LFbadEEtPvzXl1Al16ttZdRmQD3+kgh
j/d4/qfFkG8bjkONbsgX0gfMz88oLy/EjIKOm8/ujHxc7zo7L+7hHoLDr2F9
Cp2uEBd3OGUQ1itow8cLSESd0wH3LNlBSGBxLSlG34zWluLTG4DJKFvD74Uk
gojRlznzrh98Cw1zRouwb7K+elNxvw80uvfFSBZjH5w6UBbD1AcHGfr8bNFa
b9mofkQv1F3Q1VpF953PZRX48Bu42jXWt34iEbdrMppcsjshbeG/q+KfMd9q
fhfYvqUV3PcwnbJEDxQbmtnc/gnXz1YI5aDdJdzduXJbYN5PYf50GX6+hMtE
xaQZFDhPxaiU4/NMm7MIa2uEFmmxEdNKErH3UvKtoJ4a8L6XfT0ZbX/r1sz4
cDVIhpzOH0TLhr+QPbBcBcETKo+Mq0hEzyG3XSr7K4FIuc9vWI3zWvdSJN3x
M0y2zTyKR9sxZ2aHdH2CmE2uo3/QTs8U4l0vlcCiQXCBfg3mz+bg5fgLHyGD
P/2G3hfc3/sqfM+XvwedK8cLY9HWcTuHIlxzYYtbscBvdIbC8Ic6hRww6Pg+
druWRHBNdM1daHoHO7doqMWgu4u2pVZEp0Ppie7CTrSJ17ESF7dU2BM27q/9
lUS0KX+qZvJOhJpy+/EX6BOKNRNbE96C/TRVrQN9uCPh57ueNyAs6P+R+xvm
vaoOnc3H4qDp6nahW2ihvuYQ1WOx4OkeEfAcrcHDGHlNMhok0vknWtFxxa+m
JHQiIYBZskjjO54nbNtF2eRDQeZUvlA42v/6y4cJ/57CH2OFwBZ0EXsU+/C7
J0AJr5ngqMO+f5dLgfdnIMhXXtNQQz+P2uRvecsPRmfaip6hWX3Xlree9oEX
Qnf3/UD3jYKW5Lg7KF8fCtxZj/tRMkP3oYgzzHlYTV5HbyfLcu/gsoe4jCWN
p+jHlfzhilXWcK3Lq7gBLf8fR5yhrgVQtzILszXgfPk8bb+SbAZpp0MeX0Wf
lXU2sn9gAlqmPFMktL14EPN0kjFseh6nWYfmNZtvddAxgdwqsRLWRnTydj6a
vxnoz2ULX0aP3BXc9EDcAtiEZYOC0SKrvZcvxltDsWr51Ff0k/N+utFjdmDm
dfHm1ibc761t3N7TTsCV+aNEBb31FbWlNtsdqrq1RR6jh0u3TvJx+YAt69+g
L+iScz6FF6T8QEjOfHrzD8zLD6ZMS1MDod5s9qYymvHgo703vZ6Aa6TrJ3+0
LmnUqjfnKYjVbBStRvv5NvwXJhQKbfPBwUzNuN/tM5+4PA8HP5FdM+fRkk7L
wn5ykSCtFnPrETpai+VB6LZo6PUWKa1AR0o1BftsiwW5nuNPzrWQCJ6j4ZN5
397AXymbXC/05Qf2Zyf830Kwf+avT+gxgTXm/puJmAfFxeR+koiU7KQfubKp
4Ottct0Z7TL1L03vcjoc+vnWMR+t9HBbsYXtO3B1E6iWbsX7z+sXEWXIAeHG
2+PWaBrxq8PqeC58E47alYUe5e+OPGnzHvZ+22Ug0Yb5KnlX1QprPhTzbF0X
aScRaqWVXTElxWBkoXzAAE0J1tBgVvwE28oeXY1DK1nFUix+lIKuKT2Gr4NE
mAVo/R7eXA7UvLnTu3+RiHdjm2odPKpAXr3HdnMXrt+N5/IGL9bBvyTeaCW0
jEeVYcCteiCtapX7oj+28p63u98A3W9adqyjMwIVaxmuNoH7dG3GUjf2uUAd
KeJ5M5SQ3w8O92A+sNT5ae/fDmdrH+t8/4vnU7fXxB/VPyDgcOMbWz/2Ca39
8lUFf4BBeK+cGnq3+BY/bcG/UOGWvucX2iKp92bA9F9QPtrQMfiPRFyQ4LRQ
if4Hqs933do4RCJejUsXXts8DAZGr9Rlx3D/lhzdup9rCs6zm1a6o/uqjDcN
BU6BaOnR42XogB/Co9ErUzDEXc5xYRznfWFp3d2H02Dxvf+HxgT2aba8J8mq
M+AgLa5qPYV94ItRIPuOOXjM8OFK8hye95ObheT0FkGpUFl2EF327cI6A3kR
GKx/7d8/TyLEqjYesipeBJdeOj0efbzqRuhp7iUwL72Y82oB53eO05LityW4
4t67+/kSrtf/pNfu8q0As4ztxlZ0i4vP0EulFagaY5ratUwiHC6GsulbrMDZ
24dqn6GdLhs9silaAUk5B1fyCp6HpnqhZNVV2LnM0uu3RiLO/OvfI2K4BnVZ
sd8r0bIxfTqTvmvw2PRY4UYq3v/WT0Gi8WuwoV3zmTd6N7fc1+89azCbF3fe
nUYi8t/QWHtUqZBpefxYMfpMwPsvHQ+oYL6/hm8VrWTNd/c45v/+8LEFJzqJ
iBjv28/4kQo/7U6m2K3jvH/+enCMiwYhEl/Dc9E3fE4LVB2mwZX+2z4z6Peu
a5vmztGgWs1Hx4qBTFw/wDikak4DXxbOC5noGynsCx4eNFCoSDo+gd45NN9N
e0qDfKm6bQ82kIkgXp7S2Vwa2I7oraSihdg3sJlU0uDom5mBYXR+vtCAWAsN
UnZyfzbZSCakMq5IR0/TwKg2NT0R/TiDU/ECnQZC3vIv/qHvBsVsO8dKh6ip
ezYGjGSi4miXAY8IHSgM3klJ6N864+utknTwY3/VNYqWV9M4XypLBxfhkp1H
mcjE7TMiz5rOY74+3vmfHdpRVFd721U6GCktuxagczho3DaadNDW5MpeQ2vJ
bdak69LhmonMAGwiEx/8vBPeG9JByUltrx96i/6jpJD72A8eW1+vRU/+kt0S
8ZAOR6Mofts2k4lEyohnmS0dRNMyPqqi2yfXf3A40mFv8bfJcDSTwKYfT5zp
sLNuWOQX2mQkXksC8/2m35u1+beQiVDplBv/7wOrE6KUe2gODpac3+hpumJl
IvqL0j+nacz/gzvuLY+gL/U7vxfH7+sS8joiyUwm1u8d9QjC/tEkFWtgiw4z
D1vdgddTo1gcmY9uPnj3zifsL8Xqv+pW0fyc5v3PzLCPGC1tgK1kovFKQhvZ
gA5JDrtPPUJfv8pFzrmNeT/guMUXdOrmbjPa////T+SNN6wsZIL3P8EOm8t0
CEixaruOvm/MrrlDkQ5uH8ms4Wgj7X/GbdjPrL+lEx1o2dWKl1+wv5l0fXXg
YyUT19JrI/ux390eH0rTR4vWURkkOOmgzCa6ewRtquG2AZZpIC+oeOnINjKh
qsYitn2EBlLH9L1s0EWr57q2/qIBn9rLkRV0sOSpwNB8GrAbFgkobCcT87vr
LYQSaLDZvkPdF71v95vCvhAazERwlrKwkYnst9ZdVFMaDCZJz11DV4jxrumo
0aC7QFUsDD1CKHJMn6FBzS9SKO8OMiHjqS9TtY0GL/k3mR7eSSbc4/g55DD/
h0qKvLRGcyd/MnMIokIgnPvxAR1i7jY1a4H94J7HmbPsZGLjiMVikRQVVBIX
dlzjIBMRjMbsmblrMHd4sNCKk0z4XRTrLwpbhb8GHzNz0dHGVtmJlqvQ/IKU
sIBOqA6KXVRehVym4yFuu8nEwY0fj7csrYBtt5dpIBe6+130e7UVmH6yh+s1
D5loSdb/tW1qCSZHr9g18JEJOUEROdOWeegRErrPzk8m/jmMTqa/moeGm3N6
GuhPrNENSffnIbMi6lInenqSxeMbfQ4sowf3DQqQCVeRGdO9B+Zg/KJ3E02I
TGTCERPLBzMwkvL+yJH9ZEJ653Di++9j8GFENe4BOu/dd/cfBmPgeWiSIw19
9E3WFOfqKHBmiC0fOEAmThYWKwmJjwKRFVshdJBMLIW7PvwRNAwv8gJvcYqT
iSn66MFO7QEwXBT9pobe15kk/WLhH0ieqpB/hq76sKuv9tk/qCqk7mM7RCY8
3zo3hH/vh+lim/EtEjh/rlYYaf33Fy5U3PZZO0wmnl16sGVreg9wMK7MyR4h
E05VsraCC7+h+/xzE2d02glzzzTiN9hWN11eQCffNpIhurvgVe1/XFOSZELp
UbiE2oFfsNhwNP3vMTJR/NpwD/v2n1C+o55/nxSZiBJSTD9r2wIkVfOQu2hh
Tctfur+aQbg5waEb7XNgb/jTdz/gWuseok2aTOzhXWPm+N0AiV2MrV9lyMS3
F1levDk1kOZwOGT7CVyPhu9O/UuvhswdmpdvoBNqg37KZFRB/vmk8g705PvX
5YmfKqAmXSVz6CSZ8O2fvuJ6qRS+/WdzX+IUzkOBxVK3mBJo6I0StUJXaUYV
6y4XQduusehF9Icz1xn2tBXAoBs5cJMs7u+LEwrtIrkwujtf8SL6nVfznpNt
2TCZ1UMjoTclHh2QOZQFi/1H7TnlyMT4ryFVO5s0WPXQOqqFdqZpv5Q4kwJ0
bp/RGPRj2ecb7QWSYMuVZn2RM2SCWD3VfEg6HrYNrvKaom9S1YObDOJgp7dI
exo6jP3M1IhOLHDuvRI6iS5/xq+vLxoNPB/sr0rLkwlx86T3UsKRwHctltkR
feQMp8ZjjXAQGq6u/IgullqueVL8DER9Jz1paHWlPxrlmRQQ4+OWO3cWn8eH
FbMbqsFwOB8W/NCyYQr3NukGwDFVs+xadPCn01TOZl+QGQ15sE2BTFxQ/i5r
ZOwFp/0+HlBFU0YWnrJTXUBe4O+fMPSRU2uKnmYOQBSyxLajP2tptY6m2YCS
2nEtXiATKjvnGXgCLUFl/Pauu+hz3WWGu43vw5UAv4Z4tNBvR3bmaRNQFXoX
NIjetOfmWw4xE9AoalU6ROD7GKJwENtNQUuDvm6J1ldWKXj0+j7oTh4ozkGr
3Bu88LHHEvQfX3dcQL8kPbZUG7ABI2FnKdlzZOKnk5+DS44D3C+JG3dHR8nt
P/JS3RUe3vyaXIZuz/8s7/LdC2ynZwyYFMnERGJW5b1tj8AxeK+ACrrXJID7
WWwAuIqe//UETR/4fYUnKhg8Sx+EN6JfXaTKfaZTwFcr/Pqu82TiMO/AlMjQ
MwgmDVRHo3vO7Aqb14gEygE2nx70yYs6Nz/oRENo2Ul5YSV8HmLmPd/DYyF6
PjA3FX1VlSMzQS0eXlGyLSfQM0/zOhPPJkC82C8xqf/IBIjwqFopJkGa7qHX
heihzeuNQy/SIGgDf/sSeotB6PHNFRlglrRjxyllMsGoMM0pvSELDk7Pe+ah
w5+zWr3py4GER5/1ci+QiY9nT/V4CxfAI7Hc5zPoipQTOknkQjCoT2g4pkIm
Fo+cjtZkLAIh7mCFLDTTXNPhrWyfIDZNQyDjIpnQsd9FudVYDu7XL9wcQ4+y
eRsxZ1aA7rws5dAlMsG16OuQ9awS9ioI0lPQZjaq2h9Mq+H5j5HfiZdx/gwN
kLSufoWQZc/Y11fx/XvpvhJZbQKrWJvWHnTCS0F9PQrOC0Wj7QLX8Dy1SlTL
Em2GbaSLHi/RbMM87Y63WiBIkPNO1HXMH042/9X9bAVf5VS+sBuYFw5TFssP
doFDeEtMgCbOxwMrQgyu/UAJvcH3Hc1GtXNhHOyHpJDGlztukonl+gWWOLV/
0Eb6HvsCvUdL5BbpyACc9q98nXYL1/dO7kt+I4Ow6vD+bYM2mai9CmPW9qPg
eSssnUsPz0P90r1vf07Dc032w7fRNtMzHrvYZiBT/WnGa7QEeXaj+YUZ6L3+
5J3YXTKxViTzuOTjDBAqj7Lk9HH+yT3yin05C4yydu/1DMjE17/NawFa8/B4
r3pxkgmZcFv84f0wbAlizgZQR9CtEvOaRRVLkKn/8ewRUzKxovOeMWRmCVqS
BMveo/vqIiobri6DwPHxqjIzXE9eruc1GFZA6qbgZqb7+Pmv8UKpEiug5KJ2
4QJaI31A3v7mCtz/XPi1Hs1Z9H3SMG0FPlz2b+g0x/N/3J3N/PIqfHlYuEPg
AZnobCwNkLJdhc5nY6r30DdGJ33vvFiF9fYbLUPoN3XM1Z1/V+GSkUDHvAXm
Adv4QGnrNbgTeGPPaUvcv0KnqAPP1sA6zU/HDc1xWUlzEvNAxPRo94aHmMde
6T9bnF2DPveCP2xWZOJ148iVPHMqzL0eFVZDiwyKlPVi3t9cyW8UgY5wMPx2
I54KElv9BnmtyQTfwEzB5nYqKBwuOHgXXTPwtFR5mgqq10fN4tEeHCvxtcw0
cIxQHROzwfW3qb2EdIoGQYWPDlugXVvOmNVdxbzTlW+ZhU5iNPqtYkiD8n38
0ydscZ74zPrNPaHBTyVVKRe0eCCLr+BrzFOmj2xL0NI1pj2PcmiwLXNkXtGO
TCxU7y+fwfwv+IPvZADa88KY2Uo/DaTnrzt9Rftq/M09MUcDJe5HhdvsMc9E
nf+euIEOt+TyV66jowPvjKjsoIP5nRG5MLRU4+vrAnx0cPfmc29Du/glXt4v
Rof4Gl+6rgOZiGRysas+S8c8kgdxaG/7FNs7F+jwZduIdz+aeephpqgqHTqP
8lUccMT3J96YsVeLDuNq1xnN0f/tPrCucJcO6w6+Su/QQT5HFZ8Z04EjKs9/
Gv358A4B9geY90uGa447YT6w1VQutaLDqV5eZif0e3VG1xd2+PPte2ry0OE3
agVtsQ9wnOHym0fXiKZ3hWF+Z7i/S/G4Mz4vqb9hNMz3k893MtiidxtpnsrC
/N9dtb00Gz279upTCvrbLIv7FPpwCefBUfz9QiFmOUkXMlb7z+52+H1J1zYt
W6AbzLSalPDvhbtvzE9H/1lTkdfD6/FNW7cbRceLvuv/jNdr3UGVEnclE+nL
12fv4/3c2bw6ZYp2Ykp7qWtCh0syS++S0D49PYIv9Olw2mD+wQDaXaOonE+H
DgdCZsRF3chEpfS7plE1OnCWTg4ZoFcSv77diP1g4/hY4ht078inaCPsB9N7
Rgz70D+Pf+dnx77Wc2Fwn6A7mRh4/TWW+Sgd6hz6e++gL88Lhl8WpUPR277Y
l+iy6598O3nokPLj9+0u9Azbrvm8bXR4dKSjXcuDTLCu73yvMUsD69utEZHo
Xe9GYc8/GugFNau3oQuqm+oPt9JAbqCuUd0T82W50ZfzeTSYfVn+5ZoXrn+9
h1RlSxr0fSv1J6NP8afui9KmQcNy8fm6/7s0v4X4jwapGvmfL3qTCbvG2dLw
vTTQ35ZeoORDJq785xL+4BMVrsmlODxC98myfgtIoIK8WeLxCnTS8Qu8DE+o
wFP1Ogt8cb9vKRhjv0mFRrfwZLlHZCJlIzHU+m8NSlKfGbugaSeHTTZ9WYO0
dopIIfoIr6JrbMoaBBwPen3Cj0wMS2YIbzdfA4Uxj8hj/jgfFstsOAdXIUPH
NPBAIJnoX81gFq9agZY/U2RzdGe2lq9W9AqsmjmHZ6LTqktG5q1WQMUp6M3J
x3je+J5c8NizAv/C0ouVg8hE4D6Lv5wmy8BXPzVl8oRMGAuSc8lDi/AEnLWS
n+L6ms5rL3s1B7k1DHfH0IxyjgxJpnPQcTXI+GgImVB+YXhW9dgcHNCNti1A
//JpUmQon4UK5xLSl2eYryjGF/f3zcBqDkP5UBjmzRfsnud4psFcNEhc7AXm
jfN9u6ZZR8AivyvDFB1SedozJX4YHqpIHktGf/g3NpIqOwy2Fi0nD0RhH/lm
z/PSbAhcP/AriUZj/+iUPvH92wA8UcrVE3qJ+V95pSor4S9Q2pj+3kV3NLy1
UlX8CyFmt4xfozXvs4sH9f2BcBL1gUAsmXiiHpDTKvAHXv5UduF7hf3tsN7j
YuVeyDDqCuOJw/OyMyVUOe4XZC4e4dZCt25Wb2yd7YDsx97RkWjD+NkXohc6
4EPG/jdcb8gE6bz6+r6FNiiZt8rkjMf8cXnd0Mv0J5QGVEhpoF2fNw5P1rZA
Gc/uvDB0mZb4+p3DLVAlX1TM8ZZMGEhb8Gqv/IB6P6avOxOwL9dSZYS1G6GJ
69YVVfSTNtPSyLMN0JyS2vgUPdb/ZJf3gXpoq7vWxpaI628pYKVn03fo4Yzq
35ZEJnKD4y8oUmugL2nM5Aq6e0selGyqgb+nFUafoCskRAbZOKthULd/miUZ
97/AwWYLqITJhCN05hQykRNyPy4w4TOM3j6heAG923wTs+eOUhjiOBvgj36c
1DDxwK8E+ryvsG1MJRMZ+0UuOZE+QvcpDTUC/fldp2ChYCH8mrz93BMdlLX3
2KlP+dCs+0BgDV136pi/FPcHaNhlZyCbhvlPtUyrriUXvn9zTXJC39nww/df
dA5UnQ6WnEfHpG2XJz/LhLKpZ7bS6fh8ma5aaN3NgE9JUfnW6Ez5ob8kxTTI
50xVmEA7s7+8EXExCXK/Z/tKZJCJvZ8PvH5hmQBZvoU199Gxl992GSbHQ8r0
l2uDaE+J7xqXP76ChOTGUNF3mFcPnhgLyI6BN3rtbQboiyfaFaZaXkB03aBe
L/rC0Bbrutdh8PzRZDx/JvbJ33eveqk8gzC5xcHbaN97yl/zzlAgZIZ2KBr9
s3j/tlkIBlLKJqsO9H4d5V9/MX8/vrv9PVcW5mexLy7vNR+BP9fuJQ00X//6
liem3uBbz3cmDP3Q5kIXT7IbePqJev1AW/nwlmUcdwLXM4crd2Rj38gmV2x2
sAOn2eNbrqFV3E56qj+wBvvUM5dJ6Aj7g/89PGIB1vrnn35DN57/+Dd60gws
uC+3MOfg9/11cFXfawr3G9S4L6A1vzT/eJdtAib+Orf90ZEeD+szc0zBQN7g
dSU65NZf60v85qA3d79/Qy72rZN3ew3nLOF2ms1BAv3paXDmYJQNaN1zeeCJ
Fv6SKyY6ZQ8aPD5ZJegR0nSC4oozqDY+nltFM/76SGUv9ICrASGnZN/j+vpR
2JgR4QOXzr5wc0KvLtEuW6T6gfL86895aIFDEzXC3I9BMT2ZcR5dsueKUXLP
EwCDrAvSH8hEvln9nvr1pyC/p+CJNVpBNUJL6mwonG4qbcxEM0qcNt6THA4y
gTW7JtCdexSmfM5GgpRCwy2JPMz3sm1CVxii4VDG795kdImN2zBsioMDhgMi
g+jeHczpTSlvQGTvhKloPpnYLvno4iWDt8D3mDoVhzYXZPibwJUMPMAk04vW
afiTr82eCrsXWZ35C7Cvz94QfL0vHdiMeBmi0X98n11z9s0CJftM0m90neNk
FAtjDrj4nduzrxDzSoRG66UbufAvwVQ6Bb2y7UpRG0ceFA+8N8r/iJ8/ssg2
c7AYpheUZ1bQ8rs+mx78XgIHNnd6nC0iE+RHz64dci2F0AMMkVXoqrKpWzG0
MjAzvfK1uRjX17N+xZuVVfDKqVeTq4RM1JcLq32pqIaWQNu/2ujFcmGDgi81
oJDyYq0PPeRIYun6Uwu7R/4dmfqE/XJLYwJZsx4qzD1CWcvIhFzISemrz1tg
2XWn4HV0+Rvzl+oKP+HIk7fpoWj1jY6nnw//hBfpX6v2lOP1ZDu9SDvfBlbj
u5cOVpCJDWdZbjHu+gV8DzNvK1Xh+1T9NJqzvRccbXpFPWrJxNbvP2/17xqE
QJK8ZAmabq39WMl1EF4kR51aQ0+qSa5s+TMIH3+rX3L5ivPR7eLam6whoF6s
tXL4huvZMFjqheoI+ArnFFnWofWCyUdjx4Hc4quq14Tz99tKya9XM/Bqslc7
Fn2qlias0YJ9Z+tZw260/g6t01lbZqEJlhx0fmCfkdrrQLOaBY6MBzE3m/Hv
63p8+KAwBy/8NAav/SQT27KlBe83z0PCiQPu0EEm/k1UvtbAfjOZytbwCM1T
USEwhP3mtMCSYC26TKGDlSa0DHWbaytVf5GJ1LsxqSkeyzDXfp/VoBPn8e6O
7vxjKyB/Re1OEjpbv8GfT3cFAsrkskbRC2J01ZmAFdibyqpu14XzrTm2pKdz
BRRd30X7deP59X1zVaDbKpAmI8Zr0RI/lvbtj1+FNgNPhe2/cb98WNIVrF0F
88vX/0agz3AkT+/jWINnfDPiyT3YlwuDlA+8WoPOkF9uY2iT47c323xeA9FN
FfVHezGv70lMYu5bg8KJUJtC9EeeV0rcglToK5X5+LWPTCydDNLyCafCoeP8
rGx/8PyxVjy9MZsK9smb7qihF7MjPCq+UYE5pI2hC10c9ltpjUYFNabPaoJ/
yYTewZ3D1lzYX5yTEwzRT996HheSpMHRe84q4+iLfvJeB27TwLlVP/pYP5nY
cvDdiqs1DSouXhy3R5/kK9vJ5E+Dm9J7Q2hoZdFJ/6x0GsQlbfx77h/u39pr
Hxs/0WB079jxAPTmvYwyQo008GQsaWcbIBOq1Bzxa1M0qHVKEFdHf8vd1S5O
pwHHOMktEv1RNv+YNOZXXX2H+i509Oo1S5M9dEj8eUdQaJBM2Ic7NFbvxz6g
omxjhPY4n5l4XQrz9yfJyhQ0JczuEqM85nkp7t0T6KmI86J9/2F+Tlw3kRrC
/XwhM3HgGh249g4XOqDL669e3XWLDvqUJpYi9PODPxPN9OiQtvGjLh29fQeH
8oARHeYd32QqDmM/KqA2PTanY74MYghEC7TkLqhhX3h811btO/rcsLfVeewT
zS06CTtG8PkN/Nukg32DV+X8ojr6aHco6Tn2Ef0/fcyR6CMbJfXnsa8kuHry
dqIVXIdavbDPDO/ik+QfJRP8ZmcGT6MPv/tI6KNJ2RsjBPH3rZVvqb9FM762
nTnuRIe83nnjQfTzIV4uR3s6rDqHOouPkQkbphGxQWu8Xo5jTyzQ3yd4b/tZ
4PNJr4/NQrcduTyiakqHGqUH2bPod9xmvFfu0YGlh7nyxDiZYCDnKTlin7nu
lNTqjE6WKKpsxD4TvlNpuBidYXtuo/YlOnSk/lmlo9PmNB04zuH9dfMJ+U9g
fuMw3sRzGO/PoUi6Fq15wk7JWAjvj03rP9ZJPE/f7qf+20UHm3Nh5s/QhlFj
YZ7LNMjvPObxE82y/mcyaoQGq3YNT7mn8OeOhwpHf9HAN2lrXixaVImb6Vgh
DWog+Usf+vQZQe0DSTRg+aXUKTKN897pYLlmGA3CWL3XU9E2LygDhg9okGC9
eDF/hkx4admG6nLQYHhruO4Kui7CQVlulQqH30pZyc+SCcfqjJs6f6iQ12oR
XoHus05bMHlHhRq5/p6GOTLxpbVHpVOeCiw/vWfY5/H8S5XOmRWgwnVLASZN
dENv8VVtBip0vNYW70Knjil+5S5fgxGmJruhBTLx5s+YQbDcGki+sgw4tIh9
tz2pXIl7DWxPsUZZonWF7ENvz63C6n3l0jm0RKCEZlLqKmxrLGFmWMbzZPVb
/TDbKkhGpcbyrJKJ0rMNQgyly3DtLPuRW+hpRVlzr/BlsPzjXBKB7khujqWY
L0OGuEoXxxrmpamiNKPdyyBeNMiznUomov4xfTtosgSiXSLhG+hkwjsvV/73
wgLs5X8VPLqBQsxeiv7q9HsW5Mo37RXfSCFkX9op8KXNgraxZaopur+/uDrS
cRZevJOv/YcujRAr4d8xC7sVujb1MlKI8gVNt1SFGdh5l8enZROFKFKtNq87
PgVb3oQ6lWylEKsDrjcfJwyD/iv/6wwsFCKJxKtlJDMMhTHOB5XQrff1S6Oq
hsD8uV77d3Sf05n74oODUPfk0KkuVgphWtjYGCg5ACGOFYsr2/Hnr5rjA3/9
gWG7vIazbBTCprtX6YfNHzhnk5Lkg+apVx9vYfkDsw8oN7fuoBAVS/ZMvNAH
Gvd08nl2Uoi6UXOOaIPfwHNl1uEUB4VwT/kqSvdpB+uLA1fd0PWB1xxaG9rg
q3LH/s9osiRR8JW/DVzPlbYq76IQLBEjHMcqfkL3yeATNzkpxHX5ITf6/maQ
kfHYHo0+UrzqVOv3A8hS1gO/0VeD359aHWgChcM3I4x3U4htOUmzVncbIW6f
8II9F4Uo7pw8t+v///5CYHd9IbqucM1nPeUr3OBjTqSiJbyMpyC8FjZyT2r4
cVMIOYvNUquuNWC0rehDGA+FMLrRQ54IroCSre9I7WiPJxt8uGLLYfeWOCPe
PRRCvFvNflNeGdRsCOB8i77xRSulafwTiC/dsM/dSyHy1WKkxH0KQHed7esM
ujn1brc9fz6EbKnjl+KlEJsMj2y0rfoAy9zKX7LQ9PGT7yqkc+GwECPfFDqq
5/rvE6vZcFeszFqSj0K4+Fz7eDwqC2pOy+19h5bn58/pEk2HVWLp4Tj6u4Vl
6CxrKhy5+KFSgp9CFMxl9WptTYZwbUnLNHRL2e9qhwtvofbeWPkIem2SJUvn
8Rug3k/hEhegEEqTA0rtn1+DoatwWTL6h7t5TFVSFDz37eUcQk//rZbp6nkO
34Jf3j8gSCHebr0k3acUDvRQ7VJjdHNEZcJcxzOQjuHalYgujI//ZnLyKZi8
bTH9h37TrHjQkfsJRKWHlIgIUYiH/K1iKpqBUPf+Krsh+r8QZWHW6UfAUMJi
Eo++wdk7PjzkDTJVX4r+oLPsreq2u7qDaZ3fjn37KMRNvd5u1l4niP55zkgf
TWmRqmdat4OGbnrha/TT4I96Yp3WsHGgeHsv+n3Uvddyfyzg5ISzgYAwhZDu
rMzd6H8fzBdOFNxBR/J732l+bQqxtFnWWHSxeN9imZQpNG3K1u9Gs81mVrXI
mQETm2UerwiFKPvv/AqtyBxOcx1iuY1uYZEsEsp9CBYCQ3rR6Acejk837bSF
uAMJ73+h+0rC9pz1dYAWyXvMe0RxHigsupOyXGDzKYE7WujVrcOnyyI9QQ66
ciLRHN0ug1f5feHhhReb29HSv4d/j1/2hzfXNW9z7cf1lWzwJaL9Mfy8xZGt
ie42/TDOV0YCZv1Gpgi0oZjrjlTfEJA3I2n/RLMH39f1bgkFa+uLmbsOUIgR
k7pGJ7UIaPeuvBWK/ijO3nOxMxpYgrwzfqAlbvpd6vsbCwrPzm5gP0gh7MK3
KgaS4iDpTUHaU7Qa9fVQ7eYE6Ey1X29AN6d5PqsdSITtuVIabGIUYosWr4lC
VzLYV6TTSOiwUut/h7ZmQMo3M7U69ONdAcwPz2VCV/P+ZFZxCjGQpnCw70I2
KPa/Vg1Gu/w6W7qjIBfYmcLfBh6iEIltaZwnuAuBkNr8sRotZDPf4O37ER7q
OTcwSuD7iBuljS4VwbdC3RUvtNiBcZFWhlLwtdx/3fkwhTgY21nnpVQB2dGR
RvnoRwPCKXH7KqHny1bXeTRvW+Jxf8YqkBOeTLA+QiECCSl1q9ZqmG3LXzWT
pBAdRYnaEdlfQYhJfGcy+qDQ8Gh87je4JhWzf+D/Hn0atPfjd0h74qV67yju
bxeuA9wt9WBAqCRpH8P9MGjxfJbvB7Sk/rpxSRrvv+tL5vP+VtjYftn0MTpI
wiu9x68NjjGVuteg5ZVatk0dbAeSXnyy4nEKEROY/fGSXQco7XpAk5OhENu9
0x/sFuiCD+7UFImTFOLSbICCm14fRFwXZNguRyH2fDmkImU7CNRWPj1V9HB1
qietdxCMdPeWhKFZ6GL3ZK4NgfT93c57z1CIxpRQwW8Sw9Dgyzp9UB7/XsQB
rvHREWDOX+pVVKAQzOFTAjl2E+DG1/TZWZFC7P6Z/WSL4iz8ja/nL0HbTj0w
SHWZhUvi393W0bxzR4wFcmaB52TNqYDzFOKu6a0uB8E5+HC9JCtMiUKk+fPF
BqzMwaRvyutMZQpxL/huR3TcAtwb8fb6dwnnsc35oK9Jy5j3VHRELlMIkvPx
UZWmZRhk3XnCAD3Ev/m6xsoymEu+Hu1FO2Z/099yaQXs7T5pdl3BeVh253Hq
wArkM/kf23uVQqTPptSos67CcsQVVm30Pal8brdjq+BR2FXWht779PeYrMsq
BNBWJJqv4TxocnuuwrQGtZTyzezXKcTW3GqX9P1rwCIU9Oc62lUxldVTeQ2e
KvJE1qP5W1mYLQLW4EXgyY1fVSnERY0bfufWsb/w0Lu33KAQMwt7GpZ4qcCX
Vl2gjL74ao2b4zQV3tRpWFahxQ7F61k+pEIau13HZzUKkSv1RyGmhQrj8XLv
6eiXpx1+Xx2jgqTMRspZddxfREGSzkYavL/57HwxupGj5J4n9pPFIS2BVbTS
wLMzYedpcNpFaOW0Bu7frZo76bdoUBKTlZmPfnZCtOWHJw3oh52CFtDv+ctH
Tj+jAVGqYCSjSSFqxR5dmY2nQXVf/Z5cdE7a+hutKhow20bMT6NZr8utM/6k
wSXGO41Hb+L6+5LmQf9Lg4b9437v0BAmvqMH+8rOgvd3x9GGc98by1npoKbi
JidxC6+HrXvbLDfm41+Ku83RHNG60g9F6NBuzjKdgr7N3/nhhCQd9lJ/fBtC
T39wZFc5jX2HHJV4QItCvDo6W5+A+fmVwD1vY/SXrnjny5iv+7LEbiegJxx8
Us5g/hY+N32iH/35hCTNXpsOxs0FO4W1KYTWlQWBpbt0SDH0GtNHty80l5Yb
02F0XrnmNfqjgNPzn9hfDgewvelBL8WomB3F/vKQu82NXwfzyYLp+g9bOmSn
xN7URXNW5BwtcaDDnKyxVAxatamsdQL7xkPRQo1e9EaPm/ye2EdG2VidRW5T
CCcd8xsnsK8Yr9yJMUW/0fhmugvd159dmo5u9dQz4MHf121g/DuFvsskfv3/
/16jvfDmJhldfH9W/6lEYn9Re5sq5oyWvjBkx25DhwYy9XIJ2ohRi+k99pdL
ztetGO5QCD2d+VPu2F+qDeJDldD+A2LalthfiKsLeY/RCnaWpQHYX0pOqfyq
Q++tlf1Wi8/vtHAMdace5q0bW8eO4/N9v21SUBMtkaYeU0tg//sTZvIbbRM/
12gtQYcDdYNB++5SiK7x337+gnR4ky/7zhgtHXT7UA0HHV486Z2bQLfoPDrU
sEiDXY7S3NL6FEJ9UZUzcogGFH1/OUf0el/ftqftNPA/IeFDR39lGKjdkUcD
BiHPBMV7mA+8XztH4/p0Z/nxJQDdzhe0Q+spDWx7Hdl2GOD+T469aG1CA/2g
ihhBQwrh18365QQrDbrtdn82RHN3TZ9ynqXCLT2zv8nosJdW95Y6qHDtOJv4
MSNcHwElL3LeUkH+t3Y+YYzn9c0YFuIYFQq/ZPzyQyeIeRiHslPheO46tRY9
FC+9UXJ2DQ4FJp6/YYLz6xcDq0rOGnBLzTTdM6UQhH5Ng9zBNQjlVZpPRIf+
bTZiYVwDts2R3KNoyRvsN6R7VoGpS17P1oxC/NK8YxEWugqzfo/HfO/jeirh
fdg2twINHYKbEx7get929axO9DKINsgn9aMZSkfSKqyWwa1SW1nEgkIIOl2Z
LVRaBrHMsIB49Exvqc2tiSXwfbRlyxtLCpH3gYXrhewSnJSc2vLKikJc6K93
5C5bgFePSre+sMO8+zYqwTJiFuadu1Lb0aKO0vtX9Gfh8sPli9z2uB/6NHvu
HJ6FZS3p4Ofo8qd8Jz9VzICaZBJLhAPmWdmTrryT07D5F5k11AmfHws5TebR
JFhJ3tlOcsO/12Isl9s1BGUqRx9+Q6u7PXE87DAEOw03NDK7U4jMk4HH19iG
IDcyMcQf7fdGWin1/CAsMkzu8vKgEL6Hqm/V5fwDzxbPvbZeeP5+OHlZMfEP
NE6oumWjvziUfD6p/AeEmEW6J9FXJM8lfx3qgwr5L7EPvCnEC64Ai+7DfbA5
acc+Yx8KcfJQcoOe52+gOMcd1HqE6yso6oTzzg7oDbV9/BytO/OTesS8HY69
Uxr5iX7vdaQxsboNmv8Mp93ww/mtL66w6tMKXJelJC/7Y35XZhJhZm8BU2PG
p0HolAWXnDiXZij0ap36gnYLvHLn5L8foPPBJUcpgEKYX+Xss//cBLH8FTIK
gfg8/I6sL/HXw+Sp8Ah3dMFjr91OO+tAQc1ksQht/rgmVWfLd+gLYCk89Rjz
xLnXcd4bv4LotNoZqSDsixNCtyKOVoMDy/6XVuisX7u0A5WroEZ0ifoObSSl
TpMzqAQz7ZjSQ8EUYnAiO4Y9pRwyKvrPiT6hELH8z/dJ/S6BkyfPjZmiR9wP
TmyVLYay1Ffh6WiVlBDfxriP8DNEe0iahP3MJkHQNTwf9JgKQhzR98xFWYKF
8mDYiVOuCO1wqN6nu/A90PQaSefIeH1+Mh6RbDnwuPnwSX+09rgPw+UXWcCh
HNxbi6Yubtnre/gdHDjyn7QqBc+LPTuMa+NSIDsuvisMbTQy84TbJwnkOBn8
29GR+oHvNrglwLW1ona9pxTi+eIXHe6SOOh4yOMTj66mj0hNbX4FBn8dDg2i
k8tu3S/8Gg3jmi0t4iHYd6z3TRaURYLj12MelujDUtN2POPhwHCWciAHPRjl
VL/hSigEZ481zqObH4b8lCp/CpyiF11OP6MQY3LPU9fVn8CryCRhd/SBh/X6
6aqBIMbKVPcZTZ+NsrIseAS5nvccGEMpRKf8oKPzY2+Qny0VuIDeWH3IezbQ
DWqM+WqD0W+2+lkd+ekIqr9cbBrQij3vevsXbKHzSvtejjBc/zN0uxedVmBU
JlOlid4pKKkm7PAApo6HWkah88LYjrwtNgPX5Cmu32g2m5tq5zJNgYn3aplQ
OM6TyHOPWa+aAYWSdt8IHeP/c9tKpDnwbGTelYJe47d8PkJ5CPEOxiVjaPbK
prRmHls4PFJhfDQCz4P3J90nPztAvq7QDju01CfN9nB5VyCaPArz0Zy5PuEB
FC/4dr7r3iradpn1fkmnL2gUnGZVeE4hnLN7PYK1AqDn0PMPPmgtHjsTdyIY
zF7N3alGW2zhkrgdSoFZ9htbtkZiPr7czbCQ9Azc/TOzr6Bz7eLF7GTDIcTi
PuNPtJ3qOgMDNQr29tVkcL+gEHwPzid8koiFBHXRm7fRzDVDi18uxEGhXG/K
X7Tw9hVjrZW3oJgpr3YgikJke0fmf19OhLp90Wv30V77Jcz/sKfAH2bNazNo
hSMnPdxDMsDCPXdJJppCjF9TeFWxkAmLUzveOKPv5TzQ4CrKBpb2b3Pr6BVH
9rtTd96DdCIRxfYS72+rvuAF2Y8QKWL2+SpaiezDwPS+CKhvng6Q/v/zewHm
h06VwJdXPVKssRTC8sw3pvt6n0H3hfu3La8oRPjuM+uK/6vIzsOp6towgJNC
RCpJ4o0yZCYZUjwbKVEkRSQqGTMTIhER4mwqUpGKlCEihJCIImNKiMwykymc
oe/5/vxd17nW2Xvtvda673O2VMMHvrTZw2g9/7dZhcvVIB7/hS8crTurOM85
+BFm4wRs1qZQCH4NHlWV2loIu11MZXqC+SwkdUatph7G1/eJEOhnTqN+N1q+
wIkINr0gdN3U3WvH+xpAIMz0Hh2teNI49wBXM+RcX5BZfYp5c5qICmhshQ4P
Bav5VAphbxFMLy5rB41Zs5t703B+q4vb9tr8gGeuQZke6MitXsr+nB3gfLlp
aQbt1lFpYHyhE5htncnJ59hfpvgm94t0g9SZl5XDL7Bf+ZWC5mIfBGoK7+7I
ohBbgv3fvFX8DYJ8bXGC2fh8buqxLD/9DaVTYUwX0GMeqYGPNo/CUtJEzxh6
NIA1cW5hFNypRYnUV7i+C672yJWPw8Xi49w7X+P+//20IZhOw5G9ASu2BZgP
lDkEiyvmYGS9nEMmejRJTLl5aQ5u9ve1T6Mfz5uy5MnNQ2Xs4QLfQpy/sBmF
z8nzoD6zyS2yiEJI7ivLmPJbAJnsl0PZxbjeSopyHYSXoD70rMkf9OHJaZ1S
kyVwOMtdpVyC81VlIJ4evgTPObxTKtCTI+n2WhNL8J8jWLSU4vpNsZVXzf0L
m8Tbm+fLsB9t/f7j/c4VyNyl+U+lnEK0CyYdfIb9Rntnupw/+u+OkYAVb+w7
/D4xTBW4Hhp+2NA/rcAPDj4DrvfY/8zVbwrar4I723X/E+ittueU7GNWgX3t
SMZd9OZREdj6ZhXU6YXsApWY987L69+lrULyzOla8Q84X3cSJPpuUUFlsnzR
Ee14Qe0qdwYVmkbFxF6h99hHf46towLTwGKoUhWet0cen4tip4HNt3gtohrX
383oS7uu04DWQncPRR892m/74QEN7jXaPqlFG1p9N39RQIPaWuV/xz5SiMU5
ASPtURpIlnwvM6/B+RRs3Uk5TIeqQo3JJHT3NnURTUs6WOQ/39GH/ul26LaU
Bx2is67429VSCI3kXoGCRDqIvezJyED3mS/tMMqiQ0Wabuckuvzpj4O7yukw
k7xVzesThWhqr+Z0+UWHiIeB9kVoE/M1kwNTdBC+P5ywgtYvDD4RQ6NDyd3j
tQc/43rObHK5zIF5O7ZwMQgd9ygm9Br2l4loIbFqtO03/+732F9uRoadYq3D
/V/tatM+eQYUhpx+E43edV2cK0+HAYZB5QPN6IOcLzTeHmPASIDY5i31mJ9j
l5omTzEgyC9GyxTtvVvNyNiSAfxXFt0foIWe9JsNXWRAnse5J91oanhVzHMH
zPeuNc07v+B+28D+9J4LAwacZP9dRC8y6R7Pwz4QYB8vl44O6XQxp2Jf4L1E
PzeGvrJ+8L4n9ons87YxMg14/hW5jfBh39A911jmhjZcOCU3iv5lrjyZj1Z1
0700gvY1Td6xhO6/YhWxCc1jss5gfyPuZyCb7ojjvTRy8b+GjpbI+TaN36d1
7HvGe7THEQOVp3g9BSZspgx0XJBpSBNe756z+9doNOF62C9ZeMiRAUkXL+cE
oHWFY9atvYTjOyVblKLLfk7kb7DC+fVoZl1By5iYrrM2Y8CyH/Mb1WYKIRXo
cZxqxADnYCVrH/SenCtD/UewT92y5SxEzzrIyGwBBpwi77+dRz95PUEhlRnw
OaHOZm8L5oPZ2CAz7C+5z2XLctHbU8KZGnixP76ydphGtxmyPL3KzoCEgjhe
2VYKcc0ub8abSofr1YvOmWjfXS94zXrpMFcvsX0MnXDeQRNa6GD31bxG4iv2
JUOlct9KOhj2lws9R/8nJFbW/Rjf79GZukF01m3mrxwxdFCZFfHZ1UYhZsrB
IdqfDkL/wppS0EGnNz6KMaFDLGux/y90p7sj90agw1rucXGhbxSC+f2T3N+S
dJgUNAx6iE48wnvjGZ0GZep8CvHfcf7D9TQtk2mgoK3X3YZmfVRVWxBKg7Sj
/hGb27G/lA6edHGkQfSZX30keu1okieLEg3O+qTHRf3A88n6mNloBRVW81Tm
gzoxD/wZftpSugquJQ4pFWi2Qjv2pvurMFD50ICO5lFcStP2XoW6ZkaqfxeF
kHegqidKr0LiVO2pKz///3uJoanYvRVQlTQrcurB/JTDOmlluAxDkbxZOehL
Pjf12ISXIXa8NWUOrZ+l1Kn45y+MZx2L9P9FIWJb+pj47/yFx3LallG9FCK+
YrDas2kJWPfJrsnsx/kc1Ttap7QI7ZoshmPDFELsh9Hy4Zo/EJpSqS07gn16
44G07Og/oMB0XdUDnXcnpOOPyR+I+rAsvILW/nfFXWJgFjQPTc+zj+L4EWUJ
8tQZSD/a+WDPOO6P6xRZX9hNgs+p3GH7aewH02/VKs4PA+O9itkL9DLb78jB
1SEIl674PIJePJ4ycT1+CBLWNGbZzmA/OzThJd0wCEWvxz1sZinE1ZSWQ4Mw
AH83iDOs5nA/FpXfOxb5C4L9Xrk9RkunCAS5t/YA+9C+/h70irusiL9AD/C/
0/loOU8hzunszlXN+wlqjheiLBYwj4s8LzSc6wC/miQ+0yXMf9b7RTTr24BJ
UTQiHu0p6rU6INsGEUlZK9/QW08UfYy5+xUSvUq7Tf5iP3sf8HuzbSuUiHQ8
M16mEAfe9Nca6DSBdow1bxz6W/ZQT5RMI9Qvj4S1oCPZ8ryPCDRAV/Oig9EK
nnfysZMuLPWwGrhF/vgqhVD23Sb6nasWQsYePolGcwm+7bATrAGO07s2N6Cj
Wsy/dMp/BAEZxUV9KoX4Xpw8EmtbBepdhu/0aLgfbOFpHhOogCrddpkItJNJ
kU54RBno5517/AndI/UsksL0DiwinG8cplMIjs7WOlmeYghQiTpyiIH5fYDH
4EFuPjBqa6+GoIfv12Rk+uVBsBlLdiW6huAI1jn2GsL9rvFo/MM8HNpaEyae
DezrS7QD0OGNJ4tvcWXC7QeL3iVon/sb9ddwvITYUtdOZSaSOJNfvqFSJw02
G2RxeqMlRj4LKtx4BvE/f2vko8N7Vm55fnsC/M6i7rPobcxRrioBj+Eh7fwz
OWaSMOcP+8//6iMQjEn+5ox+tDH5V1tqIqQIdbFmofeLOF2wXY2HNE2TyxJr
SCIuLk0pWyYOxJvJZFu0hJzCQeVNFMiwbmhORXdl69Ntd0WBzCz7mgG0i8kR
p+0x4ZATrLtPmIUkWiSHBPyNQ0FhU4idFXrtnHRgjlswvHlakZiENpd3Ss9r
DgCVvdT6LnQZK7+NnLcvFFep0vnXkkSV02Mqa6MXqJt4y5v939TVLrsudygf
fH0hHj3Y17llQM0FCO+pu23os9kFFsHiTlC1Vqp20zqS2OCmxNEY6ACH4u2W
jdAn5bTaf2o6wCexVCkKevsD2fRcR0fQL+q1bEBzOZfcUWdchobDgiQHK0kY
3NYcOkdzA8MfZz7ooeU0qrgW8zyh1T5+PhzNJmnpZyTgA6eWW8Vq0Ldjt2dt
VfWH9gjuMyxseH+NwhV87EFwZrtBlBb6Kd25MPpwCPzMuFUWhF4ijrNNXwwD
K/WP0+VoBdEuU47OCOirZxKhoSmB3gHFL6Ph4lkNE3V2kviq1RI37BALwxNX
w/zQ5jZxl9kz74DDtaK3ReisnlRaxrZ4GN8wP7aANqqytH2Vdx+ck+UFldaT
RPeza0Xzvg9hRtbZ0AP9Mv7F3FmnZFgwHM6fQnf9cqbdGHsKPr0iw9IcJFEX
9+JTQFoqrLhZbXNCS5x/ZKp+5TkwYn8EjKDNkwrtcswyIFiEN0eUkyRMN06+
VXbMApb8E30X0dEOIm5isa+Ava3uUC96gmOz5QT28SgbVl+hDSSxU4dli6J2
PnAtaGecRR/MO9O1EPQGNm8t4+pAR764t/WdQBEImuW0t3Dh/ccypYZ/eQcd
hI8xLzdJ+N15XBLrWQ53pTQbzNBflFqYzoi9Bw5G44dfaM88LeVe0w+wkjaV
PbmRJGKtQjLu7a6BAkqhhAIPSXB/ObzxtWgtuPsFPvNCnyzMV9GW/gSjBlyJ
q2jR7b+3xOnVQfucTCj7ZpKwPZjzcl9VI9zpXqAboHV+8XXZTDXB8doyPxLd
IyDs9om7BT4+OObKt4Uk2mOOfNE/3ApvCGdzUV6SOGCgWfKhtQ1iKVnyBB9J
3G28U37tZCcc8/PKDEW7GSua1nB2AdvFA2Kf0Kox8RV/a7vguvIXAcNtJCEY
L7c4q90NLt3j6yz5SSLm40cBnhO9oC8l1e0rgOv3UOzO2q4BWFf7MiL3P5JI
fdcT+TNnDJJK1YOn0QksFnbt28Zhb26Dr+xOfF9XWDTYbozD+cRZuyy0WoZO
85LJBJQ6qem+ECaJC+8/NQVTJ8F942fmlF0kcajdn/uy+Cx0n/ntTxEnCcvM
3u7HTvPgdfyqZyManNe5JmF/4dDmdNogQRIaptUzl1rmQVVa3jwK/VbyguBx
5QW4Q/dRDd9DEiJjA9tUaQug94x1IVCKJG71B1baXFuC3oTEiTL09CXfnoXM
JfC5LTVIRatSx0qkO5cg1dvw61Vpkjjns37sxr6/wDic8PqKDElUZJ9NvTvy
FwomxFxc5PD6meWu+qmsgNUGl7dv0MzqM4trbVaATbaAeRW968f+/L+UFbBw
1U4IlycJEwv/sHXDK8D0x+p9igK+D14K4wGRq5C5KX39CNpIbLff/OtVMNk7
ZSKjSBJJZ7h8y3+sQrpXwGgxet8OycewmwrHlu5v+rqXJD5dtq6oyKPCEl/v
WX4lkhA6l1Nyu40KKari6VZoV0bg2IMFKsz5FahPoAeNzQQ899Eg6QH1puI+
kjhyedJYzYQGuqXazb5ozu/G0moeNEikttisVSaJozVqeT2ZNNAW5M/RR3O+
OTkXVEuDiYPWy7HoOXod41Q/DTSvT0ULqZCEr1bsnjheOgwzcRSpqJKEruuV
/Xuw31BEjJkC0Z724lSVcDqoaSfqV6PDuvdKujzE/hMq3mukhuMVxnAaYL5U
SXORTEAfeF8fPNtKh96PBV7d6D/3EoaKB+iwl1WH3XE/SdgbTUTmMDOgWzzq
ZC5aNPriYudGBoQdaU1aRCskuKaKCjFAzoH/9wF1kqClaNTHSDKgI8JaMQT9
t9TyFS/m55CM9IDPaJGYquRizNfS9VM13Adw/5LqXPE7yoBv4/t4TqPLeG7J
nj7JgOuc1yweod1ANf+YBeZ/meq0frSM7gi39QUGtB7jmJE4SBIRRRc6btsz
wN/FeL8rOmVh5fVXZwaIUhJDC9ACQvF6Sv//vyOnt3EVfWKg0vIV9g3fZnF+
LQ2S6JAoKiawjwjPuly8hR6qPKs85ceAep7C7Eb0nKFeST72F29F2tIWTZLI
gWq1OLTQSR0tC3TY6MfCCPx8rWfU7SdouYpFeODDAPe7rd9H0Ivp2QtVXgwQ
KOAXlgV83oqLjHXuDKj+Zu3khb599PP9i5exjyymF5Sgm7VerOu0ZQAf3zTj
H/rnzpwkR2sG/A9xn6Ta
       "]]},
     Annotation[#, "Charting`Private`Tag$772199#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{900.0000020408163, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.598462694486518*^9, 3.5984628799989233`*^9, {3.5984631505046387`*^9, 
   3.598463162526637*^9}, {3.5984633249600677`*^9, 3.598463435856819*^9}, 
   3.598467767818283*^9, {3.598467841714794*^9, 3.598467921681147*^9}, {
   3.5984679736756887`*^9, 3.598468049849474*^9}, {3.598468098884239*^9, 
   3.598468110664361*^9}, 3.5984683968132143`*^9, {3.598468432578191*^9, 
   3.59846846611096*^9}, 3.5984685757087317`*^9, 3.598468668491548*^9, 
   3.5984691107420483`*^9, {3.5984691876355133`*^9, 3.59846920632364*^9}, 
   3.5984718753479137`*^9, 3.598473048546444*^9, 3.5984730949443073`*^9, 
   3.598480181416099*^9, 3.598480860632895*^9, 3.5984817939135838`*^9, {
   3.598482501765861*^9, 3.598482522984261*^9}, 3.59848298267634*^9, 
   3.598483018543105*^9, 3.598483104261106*^9, 3.598483629050735*^9, 
   3.598484159932*^9, 3.598484472190959*^9, 3.598484665119294*^9, 
   3.598484782742351*^9, 3.598484896831265*^9, 3.598484944868887*^9, 
   3.598488348876734*^9, {3.598488415677032*^9, 3.598488442236812*^9}, 
   3.598488506055685*^9, 3.598488553902668*^9, 3.598488881993857*^9, {
   3.598488995305579*^9, 3.598489010019356*^9}, {3.59849519863314*^9, 
   3.59849521421037*^9}, 3.598495422414006*^9, 3.598497704629752*^9, 
   3.7573061173520927`*^9, 3.793303765795807*^9, {3.793303875833581*^9, 
   3.79330388025504*^9}, {3.7933247803102837`*^9, 3.793324798306531*^9}, 
   3.7938498027221746`*^9, 3.823227947580254*^9},
 CellLabel->
  "Out[2062]=",ExpressionUUID->"aa37659e-ac81-4e9f-956e-07181ed7f9ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"490.4", "-", "305.8"}], ")"}], "/", "13"}], "]"}]], "Input",
 CellChangeTimes->{{3.598463124862421*^9, 3.598463135899761*^9}, {
  3.598463240226728*^9, 3.5984632604888973`*^9}},
 CellLabel->
  "In[2063]:=",ExpressionUUID->"b79fc745-9eea-4f3f-9505-8e0cdef0509e"],

Cell[BoxData["14.199999999999998`"], "Output",
 CellChangeTimes->{
  3.5984631375866213`*^9, 3.598463260978207*^9, 3.598467866859182*^9, 
   3.5984683969838448`*^9, {3.598468432660625*^9, 3.59846846023158*^9}, 
   3.5984685757699957`*^9, 3.5984686685684013`*^9, {3.598469187702168*^9, 
   3.598469206395236*^9}, 3.5984730486099033`*^9, 3.5984730950127897`*^9, 
   3.598480181543737*^9, 3.598480860705501*^9, 3.5984817940171432`*^9, {
   3.5984825018407393`*^9, 3.598482523060227*^9}, 3.598482982760881*^9, 
   3.598483018627701*^9, 3.598483104338154*^9, 3.5984836291496067`*^9, 
   3.598484160015983*^9, 3.598484472257558*^9, 3.598484665198361*^9, 
   3.59848478282897*^9, 3.598484896896402*^9, 3.598484944951655*^9, 
   3.598488348966741*^9, {3.59848841596621*^9, 3.598488442302041*^9}, 
   3.5984885061407757`*^9, 3.598488553963256*^9, 3.598488882089278*^9, {
   3.598488995372108*^9, 3.598489010101325*^9}, {3.59849519872158*^9, 
   3.598495214303849*^9}, 3.5984954225111723`*^9, 3.59849770470568*^9, 
   3.7573061177212677`*^9, 3.793303765909855*^9, {3.793324780416127*^9, 
   3.793324798419372*^9}, 3.7938498028066053`*^9, 3.8232279475877447`*^9},
 CellLabel->
  "Out[2063]=",ExpressionUUID->"8daa65b8-4191-4d87-a4b6-0da928f1d07c"]
}, Open  ]],

Cell["Relay feedback:  Kc ~19.2  , Tc ~ 14.9", "Text",
 CellChangeTimes->{{3.598311571659669*^9, 3.598311578549725*^9}, {
   3.598311663882916*^9, 3.598311674497301*^9}, {3.598311808389928*^9, 
   3.598311841235222*^9}, {3.5984163307752047`*^9, 3.5984163661730623`*^9}, {
   3.598416406941353*^9, 3.5984164070036497`*^9}, {3.5984626310143337`*^9, 
   3.598462637067259*^9}, {3.598462867340734*^9, 3.598462876003428*^9}, 
   3.5984677242364283`*^9, {3.598468654819207*^9, 3.598468655281787*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"786035a5-0226-4bb7-887c-6544271c9ec3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"100", 
          RowBox[{
           RowBox[{"y", "''"}], "[", "t", "]"}]}], "+", 
         RowBox[{"20", " ", 
          RowBox[{
           RowBox[{"y", "'"}], "[", "t", "]"}]}], "+", 
         RowBox[{"y", "[", "t", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{"-", "0.1"}], 
         RowBox[{"Sign", "[", 
          RowBox[{"y", "[", 
           RowBox[{"t", "-", "1"}], "]"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0.06"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",",
      "y", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "500"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "t", "]"}], "/.", "sol"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "400", ",", "500"}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.598303496106985*^9, 3.598303538540124*^9}, {
   3.598304630931346*^9, 3.5983046913787947`*^9}, {3.5983049402251987`*^9, 
   3.598305026655827*^9}, {3.598305341730454*^9, 3.598305402529045*^9}, {
   3.598307895832712*^9, 3.598307900165428*^9}, {3.5983079334852953`*^9, 
   3.5983080970812263`*^9}, {3.5983083987107553`*^9, 3.598308494374836*^9}, 
   3.598308544104594*^9, {3.598308987241395*^9, 3.598309009062285*^9}, {
   3.598416319448699*^9, 3.59841632377666*^9}, {3.598416380432745*^9, 
   3.598416380841651*^9}, {3.598462306231275*^9, 3.59846231548555*^9}, {
   3.598462346421379*^9, 3.5984623896012173`*^9}, 3.5984624298845787`*^9, {
   3.59846257460332*^9, 3.598462580286133*^9}, {3.5984627659860897`*^9, 
   3.598462766136745*^9}, {3.598462983831004*^9, 3.598462984002385*^9}, {
   3.598467639881073*^9, 3.598467640222109*^9}, {3.59846860508706*^9, 
   3.5984686202456293`*^9}, {3.598468663412098*^9, 3.5984686643321657`*^9}, {
   3.598473064768374*^9, 3.5984730650860977`*^9}, {3.793303860037306*^9, 
   3.793303865926696*^9}},
 CellLabel->
  "In[2064]:=",ExpressionUUID->"1d268592-b92a-4a59-93d2-349674ba2477"],

Cell[BoxData[
 TemplateBox[{
  "NDSolve", "ihist", 
   "\"Conditions given at \\!\\(\\*RowBox[{\\\"t\\\"}]\\) = \\!\\(\\*RowBox[{\
\\\"0.`\\\"}]\\) will be interpreted as initial history functions for \
\\!\\(\\*RowBox[{\\\"t\\\", \\\"/;\\\", RowBox[{\\\"t\\\", \\\"\[LessEqual]\\\
\", \\\"0.`\\\"}]}]\\).\"", 2, 2064, 163, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.598308020076165*^9, 3.598308033734209*^9}, {
   3.598308064849593*^9, 3.598308097606037*^9}, {3.59830839940254*^9, 
   3.598308507196053*^9}, 3.598308546399892*^9, {3.598308988074849*^9, 
   3.5983090096628923`*^9}, {3.598415917567334*^9, 3.598415923163499*^9}, 
   3.5984163242869787`*^9, 3.598416381470509*^9, 3.598462219031313*^9, {
   3.5984623068198967`*^9, 3.598462316182996*^9}, {3.5984623468863583`*^9, 
   3.598462390138536*^9}, 3.598462430399681*^9, {3.598462575402876*^9, 
   3.598462581068199*^9}, 3.598462641572834*^9, 3.5984627669148903`*^9, 
   3.5984628800996237`*^9, 3.598462985184843*^9, 3.5984676408031073`*^9, 
   3.598467866925562*^9, 3.5984683970534573`*^9, {3.598468432725793*^9, 
   3.5984684602983027`*^9}, 3.598468575832899*^9, {3.5984686092764606`*^9, 
   3.5984686207308207`*^9}, 3.598468668632657*^9, {3.598469187768003*^9, 
   3.598469206463047*^9}, {3.598473048680663*^9, 3.5984730950861893`*^9}, 
   3.598480181740753*^9, 3.598480860770608*^9, 3.598481794082181*^9, {
   3.598482501906693*^9, 3.5984825231243973`*^9}, 3.598482982826811*^9, 
   3.598483018693357*^9, 3.598483104409945*^9, 3.59848362926687*^9, 
   3.5984841600843887`*^9, 3.598484472330267*^9, 3.598484665264598*^9, 
   3.598484782911743*^9, 3.598484896965066*^9, 3.598484945022703*^9, 
   3.598488349044127*^9, {3.5984884160387907`*^9, 3.598488442369156*^9}, 
   3.59848850620993*^9, 3.598488554029902*^9, 3.5984888821684027`*^9, {
   3.598488995450017*^9, 3.598489010169957*^9}, {3.5984951987959137`*^9, 
   3.5984952143725433`*^9}, 3.598495422581463*^9, 3.598497704775069*^9, 
   3.7573061178082943`*^9, 3.793303765989455*^9, {3.793303860600528*^9, 
   3.793303866174891*^9}, {3.793324780455193*^9, 3.793324798457365*^9}, 
   3.793849802839198*^9, 3.823227947609438*^9},
 CellLabel->
  "During evaluation of \
In[2064]:=",ExpressionUUID->"1c45b2db-da9b-48af-a11a-aac2a098d0bf"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwU23c8V98fB3BUxpeWipRIKZKEjIw6B8nMSkZkZa/sz+fe+/moVDStFAlR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       "]]},
     Annotation[#, "Charting`Private`Tag$772268#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{400.0000020408163, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Medium,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.5983050209258432`*^9, 3.598305030258236*^9}, {
   3.5983053478720007`*^9, 3.598305403247961*^9}, 3.598307900589336*^9, {
   3.598307934747879*^9, 3.598308033784519*^9}, {3.5983080651243143`*^9, 
   3.598308097660617*^9}, {3.5983083994711227`*^9, 3.59830850729327*^9}, 
   3.5983085464945602`*^9, {3.598308988192316*^9, 3.598309009760664*^9}, {
   3.5984159176720047`*^9, 3.5984159232564993`*^9}, 3.5984163243888197`*^9, 
   3.598416381556655*^9, 3.5984622191064262`*^9, {3.598462306885936*^9, 
   3.59846231623731*^9}, {3.598462346947362*^9, 3.598462390267591*^9}, 
   3.5984624305238743`*^9, {3.598462575566*^9, 3.598462581260458*^9}, 
   3.598462641772893*^9, 3.598462767192819*^9, 3.598462880376419*^9, 
   3.598462985463418*^9, 3.5984676411012573`*^9, 3.598467867200919*^9, 
   3.598468397324479*^9, {3.598468433004796*^9, 3.598468460580431*^9}, 
   3.5984685761108847`*^9, {3.598468609551296*^9, 3.5984686209973516`*^9}, 
   3.598468668853159*^9, {3.598469187987179*^9, 3.598469206689539*^9}, {
   3.598473048764523*^9, 3.598473095312174*^9}, 3.598480181955748*^9, 
   3.5984808609889812`*^9, 3.598481794298779*^9, {3.598482502119259*^9, 
   3.598482523342247*^9}, 3.598482983044589*^9, 3.5984830189178123`*^9, 
   3.598483104631542*^9, 3.598483629437337*^9, 3.598484160332265*^9, 
   3.598484472551396*^9, 3.598484665484313*^9, 3.5984847831306562`*^9, 
   3.598484897186585*^9, 3.598484945244561*^9, 3.598488349271555*^9, {
   3.598488416260058*^9, 3.5984884425871897`*^9}, 3.598488506433589*^9, 
   3.598488554251828*^9, 3.5984888823912973`*^9, {3.5984889956741047`*^9, 
   3.598489010390059*^9}, {3.5984951990270863`*^9, 3.5984952145966663`*^9}, 
   3.598495422801252*^9, 3.59849770499614*^9, 3.757306117946126*^9, 
   3.7933037660474358`*^9, {3.793303860688449*^9, 3.7933038662536583`*^9}, {
   3.793324780536524*^9, 3.793324798542088*^9}, 3.7938498029215107`*^9, 
   3.823227947723961*^9},
 CellLabel->
  "Out[2065]=",ExpressionUUID->"9cfc2590-69d8-47d3-9891-ff3b767f85e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"{", 
  RowBox[{"(*", " ", "Kc", " ", "*)"}], " ", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"4", "/", "\[Pi]"}], ")"}], "/", "0.06627"}], "]"}], ",", 
   RowBox[{"(*", " ", "Tc", " ", "*)"}], " ", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"475", "-", "103.3"}], ")"}], "/", "25"}], "]"}]}], 
  "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"need", " ", 
    RowBox[{"4", "/", "\[Pi]"}], " ", "factor", " ", "to", " ", "get", " ", 
    "amplitude", " ", "of", " ", "square", " ", "wave", " ", "1", "st", " ", 
    "harmonic"}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.598462616061644*^9, 3.5984626251085567`*^9}, {
  3.598462792512385*^9, 3.598462862580461*^9}, {3.598467664189657*^9, 
  3.598467665732059*^9}, {3.598467712092836*^9, 3.598467718754867*^9}, {
  3.5984685268073807`*^9, 3.598468572180931*^9}, {3.5984686474769497`*^9, 
  3.598468647667616*^9}},
 CellLabel->
  "In[2066]:=",ExpressionUUID->"fd8dd30f-d6ec-48cd-8876-7c3be5d68557"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"19.212909985440817`", ",", "14.868`"}], "}"}]], "Output",
 CellChangeTimes->{{3.598462625543457*^9, 3.598462641811811*^9}, 
   3.598462793915978*^9, {3.598462863071835*^9, 3.5984628804124823`*^9}, 
   3.598467719267969*^9, 3.598467867327589*^9, 3.598468397362649*^9, {
   3.598468433129591*^9, 3.598468460700115*^9}, 3.598468530774795*^9, 
   3.598468576210129*^9, {3.598468648486042*^9, 3.598468668969904*^9}, {
   3.598469188086089*^9, 3.5984692068181953`*^9}, 3.59847304879335*^9, 
   3.598473095409259*^9, 3.5984801819953938`*^9, 3.598480861090344*^9, 
   3.598481794406478*^9, {3.598482502225111*^9, 3.598482523460532*^9}, 
   3.5984829831466923`*^9, 3.598483019013034*^9, 3.598483104739119*^9, 
   3.5984836295682583`*^9, 3.598484160548727*^9, 3.5984844726592093`*^9, 
   3.598484665732319*^9, 3.598484783279261*^9, 3.598484897281355*^9, 
   3.598484945353128*^9, 3.598488349367776*^9, {3.5984884163006897`*^9, 
   3.598488442685525*^9}, 3.598488506526326*^9, 3.598488554347097*^9, 
   3.5984888824897614`*^9, {3.59848899578937*^9, 3.5984890105206547`*^9}, {
   3.598495199140648*^9, 3.598495214723612*^9}, 3.598495422929431*^9, 
   3.598497705157666*^9, 3.7573061180365267`*^9, 3.793303766055584*^9, {
   3.79332478054383*^9, 3.7933247985496073`*^9}, 3.793849802928788*^9, 
   3.82322794773039*^9},
 CellLabel->
  "Out[2066]=",ExpressionUUID->"520de8b3-a3d3-42ed-bb8d-ee13b5dca90c"]
}, Open  ]],

Cell["\<\
my best \[OpenCurlyDoubleQuote]tweaking\[CloseCurlyDoubleQuote] effort to \
find PIDF algorithm  (needs a large input range)\
\>", "Text",
 CellChangeTimes->{{3.5984687300483837`*^9, 3.598468740626544*^9}, {
  3.598487503621909*^9, 3.598487528037648*^9}, {3.7933181137146177`*^9, 
  3.793318117440693*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"ded4cda6-93e8-4d50-b244-4fa2436187e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"k1", "=", 
     RowBox[{"4", "+", 
      FractionBox["0.2", "s"], "+", 
      FractionBox[
       RowBox[{"20", "s"}], 
       RowBox[{
        RowBox[{"1.2", "s"}], "+", "1"}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k1tf", "=", 
     RowBox[{"TransferFunctionModel", "[", 
      RowBox[{"k1", ",", "s"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t1", "=", 
     FractionBox[
      RowBox[{"k1", " ", "g0"}], 
      RowBox[{"1", "+", 
       RowBox[{"k1", " ", "g0"}]}]]}], ";", " ", 
    RowBox[{"t1tf", "=", 
     RowBox[{"TransferFunctionModel", "[", 
      RowBox[{"t1", ",", "s"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"command", " ", "response"}], " ", "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"u1", "=", 
     FractionBox[
      RowBox[{"k1", " "}], 
      RowBox[{"1", "+", 
       RowBox[{"k1", " ", "g0"}]}]]}], ";", " ", 
    RowBox[{"u1tf", "=", 
     RowBox[{"TransferFunctionModel", "[", 
      RowBox[{"u1", ",", "s"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"system", " ", "input"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d1", "=", 
     FractionBox[
      RowBox[{"g0", " "}], 
      RowBox[{"1", "+", 
       RowBox[{"k1", " ", "g0"}]}]]}], ";", " ", 
    RowBox[{"d1tf", "=", 
     RowBox[{"TransferFunctionModel", "[", 
      RowBox[{"d1", ",", "s"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"disturbance", " ", "response"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"y1out", "=", 
     RowBox[{"OutputResponse", "[", 
      RowBox[{"t1tf", ",", "1", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u1out", "=", 
     RowBox[{"OutputResponse", "[", 
      RowBox[{"u1tf", ",", "1", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d1out", "=", 
     RowBox[{"OutputResponse", "[", 
      RowBox[{"d1tf", ",", "1", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "y0out", ",", "y1out"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Dashed", ",", "Black", ",", "Thin"}], "}"}], ",", "Blue", 
          ",", 
          RowBox[{"{", 
           RowBox[{"Thick", ",", "Red"}], "}"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{"d1out", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0.4"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"Thick", ",", "Red"}], "}"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "u1out"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Dashed", ",", "Black", ",", "Thin"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Thick", ",", "Red"}], "}"}]}], "}"}]}]}], "]"}]}], 
    "}"}]}]}]], "Input",
 CellChangeTimes->{{3.598468747587332*^9, 3.598468767821928*^9}, {
   3.598468799077754*^9, 3.598468853043968*^9}, {3.5984691371362658`*^9, 
   3.598469200581986*^9}, {3.5984692319806747`*^9, 3.598469431600719*^9}, {
   3.598469522264392*^9, 3.59846958596672*^9}, {3.598469834215106*^9, 
   3.598469967541521*^9}, {3.598470007628188*^9, 3.598470091642561*^9}, {
   3.5984701394209948`*^9, 3.598470250363792*^9}, {3.59847031109057*^9, 
   3.5984703153592033`*^9}, {3.598470363249447*^9, 3.5984703926084127`*^9}, {
   3.598470550330907*^9, 3.598470596402381*^9}, {3.5984706773145733`*^9, 
   3.5984710355041113`*^9}, 3.598471104920719*^9, {3.598473031368466*^9, 
   3.598473033259005*^9}, {3.598474981873465*^9, 3.598475084123027*^9}, {
   3.5984751878876534`*^9, 3.598475218013606*^9}, {3.5984771276612043`*^9, 
   3.598477132116346*^9}, {3.598480373044265*^9, 3.59848038087037*^9}, {
   3.5984824895635433`*^9, 3.5984824898672113`*^9}, {3.598482809250736*^9, 
   3.598482932171215*^9}, {3.5984829637177343`*^9, 3.59848297498032*^9}, {
   3.598483014362934*^9, 3.5984830991065483`*^9}, {3.598483180808907*^9, 
   3.598483200513064*^9}, {3.598484004712529*^9, 3.598484027651319*^9}, {
   3.598484280108584*^9, 3.598484310653263*^9}, {3.5984844569674187`*^9, 
   3.5984844670672503`*^9}, 3.598484825824409*^9, {3.598487188809054*^9, 
   3.598487318317506*^9}, {3.598487415397036*^9, 3.5984874262048473`*^9}, {
   3.59848832852637*^9, 3.5984883291558437`*^9}, {3.598488459581151*^9, 
   3.598488481473433*^9}, {3.5984889911606207`*^9, 3.5984889922712517`*^9}, {
   3.598489959773754*^9, 3.598489966701131*^9}, {3.5984899985849047`*^9, 
   3.598490000991458*^9}, {3.7933037570649767`*^9, 3.7933037570690928`*^9}, {
   3.793303834485536*^9, 3.793303845766906*^9}},
 CellLabel->
  "In[2067]:=",ExpressionUUID->"15388b5b-8cd8-43a8-8eab-e372ba0eea4e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {GrayLevel[0], Thickness[Tiny], Opacity[1.], Dashing[{Small, Small}], 
        LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQrdT/d/E8uYN2DGDwwf7UxNuFL9Lf28P4XnvZ/Z6l
/4fzz/KacbLECjjA+E79rgeW+0vA+an6v3gNeRXgfF/N1I9i7ipw/qYrtaUn
LTTgfGshrfUs9TpwfvrvSXOXRhjA+fnHnhuv9zWC87ui2FT/5pjA+cnHq9MM
M8zg/IPskoHZkRZwvqFgw7SXJVZwfsJnWx2/HBs4f+G8ozLfe+3g/M19Vrcv
BTnA+SW7bAPm+jjC+ftPLf3UGe0E52e6W+7NjHCG8+esMNyaneUC50/8vLex
oNwVzn+2qrQso8gNzj/iNmlGU5M7nM/of+tRf4MHnM/guI1xQaUnnN8h/t33
UrsXnF8QlXzoe7M3nP+w0STFfqoPnC8yeeatzoW+cP4yAa3K47P9EOFVJO+q
vtofzp+nsEDGNiQAzt9b84sh4wKCr+jN/kc5PBDO33Jes/vmFQS/59g/A4XY
IDh/cvHLrIQ7CH6NqBy/UmQwnL9Sk/VUyQMEn+0Lo+TBuBA4f7nBxrp5zxF8
zaRVfn9zQ+H82547N4W+RvAvLa7StS8Og/N/bA60UfqE4P/fUbS1LS8czvc2
cHOt+YrgH4/Vz8wujoDzrdgDNmzdieCv21Dw/f9/BB8A8gTzyg==
         "]]},
       Annotation[#, "Charting`Private`Tag$773879#1"]& ], 
      TagBox[
       {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJw91nk01nsTAHBECJU1XMlWUU+hXOm5ZaYi0iXP4nkeW0XJljUiUVSkUqHF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         "]]},
       Annotation[#, "Charting`Private`Tag$773879#2"]& ], 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJw913c8lt//OHAkKYoykiR7lHGLJOu87HHfNxISRUlGyi6zIkpDVlJJpCSE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         "]]},
       Annotation[#, "Charting`Private`Tag$773879#3"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    Background->GrayLevel[0.97],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJw9l3k0VP//xxFRJFpsyU6GGWP7IOH1CkXWmDGmLEm2QnYpS4hSCaEiQqWi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         "]]},
       Annotation[#, "Charting`Private`Tag$773927#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    Background->GrayLevel[0.97],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{0., 99.99999795918367}, {0, 0.4}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {GrayLevel[0], Thickness[Tiny], Opacity[1.], Dashing[{Small, Small}], 
        LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQrdT/d/E8uYN2DGDwwf7UxNuFL9Lf28P4XnvZ/Z6l
/4fzz/KacbLECjjA+E79rgeW+0vA+an6v3gNeRXgfF/N1I9i7ipw/qYrtaUn
LTTgfGshrfUs9TpwfvrvSXOXRhjA+fnHnhuv9zWC87ui2FT/5pjA+cnHq9MM
M8zg/IPskoHZkRZwvqFgw7SXJVZwfsJnWx2/HBs4f+G8ozLfe+3g/M19Vrcv
BTnA+SW7bAPm+jjC+ftPLf3UGe0E52e6W+7NjHCG8+esMNyaneUC50/8vLex
oNwVzn+2qrQso8gNzj/iNmlGU5M7nM/of+tRf4MHnM/guI1xQaUnnN8h/t33
UrsXnF8QlXzoe7M3nP+w0STFfqoPnC8yeeatzoW+cP4yAa3K47P9EOFVJO+q
vtofzp+nsEDGNiQAzt9b84sh4wKCr+jN/kc5PBDO33Jes/vmFQS/59g/A4XY
IDh/cvHLrIQ7CH6NqBy/UmQwnL9Sk/VUyQMEn+0Lo+TBuBA4f7nBxrp5zxF8
zaRVfn9zQ+H82547N4W+RvAvLa7StS8Og/N/bA60UfqE4P/fUbS1LS8czvc2
cHOt+YrgH4/Vz8wujoDzrdgDNmzdieCv21Dw/f9/BB8A8gTzyg==
         "]]},
       Annotation[#, "Charting`Private`Tag$773975#1"]& ], 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJwd2nk4Vc8bAHB7QrLvJGTf9/281mRfr1tUiixR9rWUJCRJ2iShkvAlErKU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         "]]},
       Annotation[#, "Charting`Private`Tag$773975#2"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    Background->GrayLevel[0.97],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.5984687684718103`*^9, {3.598468800191082*^9, 3.598468853906371*^9}, {
   3.598469157273785*^9, 3.598469440916803*^9}, {3.598469527678791*^9, 
   3.59846958668386*^9}, {3.598469836351178*^9, 3.598469968745281*^9}, {
   3.598470011447733*^9, 3.59847009208045*^9}, {3.598470139997632*^9, 
   3.5984702508410463`*^9}, 3.598470315875102*^9, {3.5984703651086473`*^9, 
   3.598470393330844*^9}, 3.5984706020810747`*^9, {3.598470680836363*^9, 
   3.598471036413418*^9}, 3.5984730489865026`*^9, 3.598473095603245*^9, {
   3.598474986218081*^9, 3.598475084727584*^9}, {3.598475190607894*^9, 
   3.598475218649366*^9}, {3.598477128890003*^9, 3.598477133100945*^9}, 
   3.598480182194422*^9, 3.598480861278689*^9, 3.5984817945992327`*^9, {
   3.598482502413281*^9, 3.59848252364443*^9}, 3.598482857847649*^9, 
   3.598482932976487*^9, {3.598482979244823*^9, 3.598482983217329*^9}, {
   3.598483015262261*^9, 3.598483019294444*^9}, {3.598483061831341*^9, 
   3.598483105235909*^9}, 3.5984832031070223`*^9, 3.598483630147048*^9, {
   3.5984840063210573`*^9, 3.598484028695362*^9}, 3.5984841610967503`*^9, {
   3.598484281908443*^9, 3.598484311662114*^9}, 3.59848447300134*^9, 
   3.598484666155595*^9, 3.5984847837002497`*^9, 3.598484827491819*^9, 
   3.5984848978938713`*^9, 3.598484946030352*^9, 3.598487191192631*^9, 
   3.598487233942383*^9, {3.598487267688301*^9, 3.598487273237316*^9}, {
   3.598487417204916*^9, 3.598487427466764*^9}, 3.598488350255172*^9, {
   3.598488417320734*^9, 3.5984884434826193`*^9}, 3.5984885070508127`*^9, 
   3.598488554861689*^9, 3.598488883008987*^9, {3.598488996602353*^9, 
   3.598489011358206*^9}, 3.598489969022902*^9, 3.5984900037742243`*^9, {
   3.598495199930635*^9, 3.598495215533826*^9}, 3.598495423729871*^9, 
   3.5984977059646683`*^9, 3.757306118897336*^9, 3.793303766454664*^9, {
   3.793303838787614*^9, 3.793303846731174*^9}, {3.793324781002726*^9, 
   3.79332479895821*^9}, 3.793849803432008*^9, 3.823227948298399*^9},
 CellLabel->
  "Out[2075]=",ExpressionUUID->"f3fc57c0-14fa-4f17-b9bf-018e33528b79"]
}, Open  ]],

Cell["\<\
optimized PI algorithm (from ZN knowing system, but my optimum is similar)\
\>", "Text",
 CellChangeTimes->{{3.5984687300483837`*^9, 3.598468740626544*^9}, {
  3.598487489979722*^9, 3.598487495742135*^9}, {3.598495167092866*^9, 
  3.5984951913634768`*^9}, {3.793303775881012*^9, 3.793303776104849*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"b7842e4f-8131-4dae-9638-acb8a72b1a22"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k2tf", "=", 
   RowBox[{"PIDTune", "[", 
    RowBox[{"g0tf", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<PI\>\"", ",", "\"\<ZieglerNichols\>\""}], "}"}]}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k2tf", "//", "N"}], "//", 
  "Simplify"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.598471107692952*^9, 3.598471164014176*^9}, {
   3.598473036753487*^9, 3.598473039145803*^9}, {3.5984824920592833`*^9, 
   3.598482517933474*^9}, {3.5984832630085278`*^9, 3.598483267087122*^9}, {
   3.598483302192562*^9, 3.598483316200233*^9}, {3.598484512016821*^9, 
   3.5984845648559504`*^9}, 3.598484633838986*^9, 3.598485116068709*^9, {
   3.5984851553158216`*^9, 3.598485164248117*^9}, {3.598485221547811*^9, 
   3.598485221754859*^9}, {3.5984921907005873`*^9, 3.598492192454851*^9}, 
   3.5984934672527103`*^9},
 CellLabel->
  "In[2076]:=",ExpressionUUID->"a95c19fd-82dd-4c06-a9f5-1ce5ac7f6576"],

Cell[BoxData[
 InterpretationBox[
  TemplateBox[{
    FractionBox[
     RowBox[{
       RowBox[{"0.08118970769096807`", "\[VeryThinSpace]"}], "+", 
       RowBox[{"1.8559600136452905`", " ", "s"}]}], "s"], 
    InterpretationBox["\[InvisibleSpace]", None], {
    TransferFunctionModel, {
     False, False, {False, False}}, $Failed, {{Control`CommonDump`$DUMMY$}, {
      Control`CommonDump`$DUMMY$}}, InterpretationBox[#, 
      TransferFunctionModel[{{{
         0.08118970769096807 + 
          1.8559600136452905` $CellContext`s}}, $CellContext`s}, \
$CellContext`s], AutoDelete -> True, Editable -> True, BaseStyle -> 
      "TransferFunctionModelMinimal"]& , $CellContext`s, 1, 1, 
     Control`CountStates[
      TransferFunctionModel[{{{
         0.08118970769096807 + 
          1.8559600136452905` $CellContext`s}}, $CellContext`s}, \
$CellContext`s]], 1, {}, {False, False}, False, Automatic, None, 
     Automatic}, {}},
   "TransferFunctionModelFull",
   BaseStyle->{NumberMarks -> False},
   DisplayFunction->(TagBox[
     SubsuperscriptBox[
      RowBox[{"(", 
        GridBox[{{#}}, AllowedDimensions -> {1, 1}, 
         GridBoxDividers -> {
          "Rows" -> {False, {False}, False}, 
           "Columns" -> {False, {False}, False}}, DefaultBaseStyle -> 
         "SystemsModelGrid00"], ")"}], #2, 
      ButtonBox[
       GraphicsBox[{
         RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
         
         InsetBox[
          StyleBox[
          "\[ScriptCapitalT]", DefaultBaseStyle -> 
           "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
       ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
         ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
       None], MultilineFunction -> None], 
     EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
           FrontEnd`Value[
            FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
       True}]]& ),
   InterpretationFunction->(
    RowBox[{"TransferFunctionModel", "[", "Unevaluated", "[", 
      RowBox[{"{", 
        RowBox[{"{", 
          TemplateSlotSequence[{1, 1}, ","], "}"}], "}"}], "]", ",", "s", ",",
       "SamplingPeriod", "->", 
      RowBox[{#2}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
   Tooltip->TransferFunctionModel],
  TransferFunctionModel[{{{
     0.08118970769096807 + 
      1.8559600136452905` $CellContext`s}}, $CellContext`s}, $CellContext`s],
  AutoDelete->True,
  BaseStyle->"TransferFunctionModelMinimal",
  Editable->True]], "Output",
 CellChangeTimes->{{3.598484636840603*^9, 3.59848466618542*^9}, 
   3.598484783747547*^9, 3.598484897934037*^9, 3.5984849460742397`*^9, 
   3.59848512043682*^9, {3.598485159398329*^9, 3.598485164874392*^9}, 
   3.598485223435288*^9, 3.5984883503371067`*^9, {3.598488417485063*^9, 
   3.5984884435235558`*^9}, 3.598488507094771*^9, 3.5984885549046288`*^9, 
   3.598488883059414*^9, {3.598488996691781*^9, 3.598489011415663*^9}, 
   3.598492193193928*^9, {3.59849346861588*^9, 3.598493483597838*^9}, {
   3.598495199976622*^9, 3.5984952155757713`*^9}, 3.598495423782641*^9, 
   3.598497706011078*^9, 3.757306119250889*^9, 3.7933037666091757`*^9, {
   3.793324781167439*^9, 3.7933247991391497`*^9}, 3.793849803609622*^9, 
   3.8232279485334578`*^9},
 CellLabel->
  "Out[2077]=",ExpressionUUID->"c1f096f3-b144-48b1-9ffc-ba77a087a950"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k2", "=", 
   FractionBox[
    RowBox[{"0.08118970769096807`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.8559600136452905`", " ", "s"}]}], "s"]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"t2", "=", 
    FractionBox[
     RowBox[{"k2", " ", "g0"}], 
     RowBox[{"1", "+", 
      RowBox[{"k2", " ", "g0"}]}]]}], ";", " ", 
   RowBox[{"t2tf", "=", 
    RowBox[{"TransferFunctionModel", "[", 
     RowBox[{"t2", ",", "s"}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"command", " ", "response"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u2", "=", 
    FractionBox[
     RowBox[{"k2", " "}], 
     RowBox[{"1", "+", 
      RowBox[{"k2", " ", "g0"}]}]]}], ";", " ", 
   RowBox[{"u2tf", "=", 
    RowBox[{"TransferFunctionModel", "[", 
     RowBox[{"u2", ",", "s"}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"system", " ", "input"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d2", "=", 
    FractionBox["g0", 
     RowBox[{"1", "+", 
      RowBox[{"k2", " ", "g0"}]}]]}], ";", " ", 
   RowBox[{"d2tf", "=", 
    RowBox[{"TransferFunctionModel", "[", 
     RowBox[{"d2", ",", "s"}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"disturbance", " ", "response"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y2out", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"t2tf", ",", "1", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u2out", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"u2tf", ",", "1", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d2out", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"d2tf", ",", "1", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "y0out", ",", "y2out"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Dashed", ",", "Black"}], "}"}], ",", "Blue", ",", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Red"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{"d2out", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Red"}], "}"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "u2out"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Dashed", ",", "Black"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Red"}], "}"}]}], "}"}]}]}], "]"}]}], 
  "}"}]}], "Input",
 CellChangeTimes->{{3.5984845885356703`*^9, 3.598484635153771*^9}, {
   3.5984848483744993`*^9, 3.5984848931851807`*^9}, {3.5984849990823708`*^9, 
   3.598484999246879*^9}, {3.5984851240538387`*^9, 3.598485138417995*^9}, 
   3.598485172039298*^9, {3.598485228446319*^9, 3.598485229036331*^9}, {
   3.598486028474084*^9, 3.598486136213655*^9}, {3.598487332356336*^9, 
   3.5984873439966297`*^9}, {3.598487374461443*^9, 3.598487395069736*^9}, {
   3.5984874320529737`*^9, 3.5984874712934*^9}, 3.598488333785614*^9, {
   3.5984884876297283`*^9, 3.598488523064095*^9}, {3.598489975822945*^9, 
   3.5984899817804413`*^9}, 3.5984900161147633`*^9, {3.598493359865078*^9, 
   3.5984934148811274`*^9}, 3.598493490188292*^9, {3.5984948644941053`*^9, 
   3.598494879394978*^9}, 3.598495150308951*^9, {3.793303757072218*^9, 
   3.7933037570761127`*^9}},
 CellLabel->
  "In[2078]:=",ExpressionUUID->"ebb9cec1-dc46-4c59-b144-f1dbdbe79304"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQrdT/d/E8uYN2DGDwwf7UxNuFL9Lf28P4XnvZ/Z6l
/4fzz/KacbLECjjA+E79rgeW+0vA+an6v3gNeRXgfF/N1I9i7ipw/qYrtaUn
LTTgfGshrfUs9TpwfvrvSXOXRhjA+fnHnhuv9zWC87ui2FT/5pjA+cnHq9MM
M8zg/IPskoHZkRZwvqFgw7SXJVZwfsJnWx2/HBs4f+G8ozLfe+3g/M19Vrcv
BTnA+SW7bAPm+jjC+ftPLf3UGe0E52e6W+7NjHCG8+esMNyaneUC50/8vLex
oNwVzn+2qrQso8gNzj/iNmlGU5M7nM/of+tRf4MHnM/guI1xQaUnnN8h/t33
UrsXnF8QlXzoe7M3nP+w0STFfqoPnC8yeeatzoW+cP4yAa3K47P9EOFVJO+q
vtofzp+nsEDGNiQAzt9b84sh4wKCr+jN/kc5PBDO33Jes/vmFQS/59g/A4XY
IDh/cvHLrIQ7CH6NqBy/UmQwnL9Sk/VUyQMEn+0Lo+TBuBA4f7nBxrp5zxF8
zaRVfn9zQ+H82547N4W+RvAvLa7StS8Og/N/bA60UfqE4P/fUbS1LS8czvc2
cHOt+YrgH4/Vz8wujoDzrdgDNmzdieCv21Dw/f9/BB8A8gTzyg==
         "]]},
       Annotation[#, "Charting`Private`Tag$776154#1"]& ], 
      TagBox[
       {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJw91nk01nsTAHBECJU1XMlWUU+hXOm5ZaYi0iXP4nkeW0XJljUiUVSkUqHF
LkKL7pUlbS5SQoUkLYTKLpeffZf3+57zvs05c+Z8/puZc+acUXX0YjoJ8PHx
vSP536p2eS4jVbnMkO9/8UhEa4WHyw34v8sCczI1Xe7/coWOj/NCl9Jfroqq
Nx1zfvvLr+inn/zr/PWXX8d88elxpn45Mv76qyu6g2CjylqoEX3HkOYCNhvv
D4KD299FDNV2w7eben7U04bgsOOr/aYas4a+wjHHfbOHIFqtq5nPQBxkP20W
l9IchpnNmns0EpbB41ttyXlZwxC1svopr0QVbI9eWMdQHwHm7LtZj++a8NNY
r2QwbQSSsuVqJhJ0IF22xSJaeRReH1rpPG/9Oxh1hn/VTh6Fa/b1Ia336dDz
YL33W4UxMIj1ZbPMES6c+cTnFTcGnZUpI4VRO2A9OzRmsew4cM5ftUiXNYF6
dS21nNhxSAx0fXqj2wzkXwTt6L84AemLjWRP5TOgKFa9IUpsEpyPJimXCbNh
r2P1Qdq5SVD1UvuYHsqBTH7lCPczU2C5YGfTgWZbMHlXIScmMA30uWOq70v2
wo80r9vZJ6chQ9fDnK9tP+hiWVVv0AxMCBTbNSkehIYlbtbnJmeAJrYrsaPO
CQK/Sv3QPDoLA4UD8S1xzlBy4qCYi88c5MrQbmvz3MGsWNiiy3keTHyOse6/
9QHdeccxucF5uPbqWh5D6AhEqeyrVd/Ch75+Du2HjPzAz/GpP7ucD3/P73if
2XoUjLq8ywsb+DGcXmwWFxYMBmeV5WvlBdBDNXjVJN8JoGlWu3fZCeDTqAuy
JudOgrTbaullnQLYGNe9ZpNNGLT1tzgEji3ApzqaWy49OQMfL10ojN4siOcr
tZbJJIfDa+3NondDBDGHpZJSdyoC8n2u5jYKCWGgZMG6t3aREDZmNk+XW4hp
H8pmxLdHgcrco+Q5fRGU90o57OsUCzKpToOyx0VwRsmuIGM8FkRA2mh9qQim
208de3DuClChnn17TUTxuqTHxkOFV6FEcCX9GXcRjiefXXJLLQ7sxWM/nQoU
R90tr4zPMpKhRkJfVNB+KbLWORY+GM2A+t1S8bXBS/H8TPcPW0YmfD43sCoh
eSnWrLr5NSsnEzqEbhutb16Kw/mmG5e7Z8Hs3LJQnq0kigYcLwrouwVrBqbG
/7KWwh0tsVSNSDZE1hZ3WHFksHEswHCEkwvbLxs/u71HHscYj+Vq8x9BqNmD
u/We8lg+vWVPE/UISoTUr8xdlMehpfd0ZNY9Bnow3yFWtTwqW/40XHLnMWx0
LRKbN1XAqszkErm0J6CxQ5fL2a6IIuOquyXii2DhhNKA4O9KaObp96UpsxSc
tKcldCVU0Ju6GFe5uBzMtZyG5Ew0UH/59UUdL2sgvyHE/5WBJkrkh9slhb+H
P6TW3Bc8SUNd1u/9D30+g/NMbEoWTwefiXrG24u2gFdF98b75hvQbrlFo/iZ
b3DeZuHKucN6OJHTU/gxtA0OVB4/pOuijyXrjN4LaXdAmbACw93aAI1YNf9M
ZXeCrmTo9V4/Ou7qrirVVuyG/SNbaRaHtyDnkvkp4V09kJ76UmnioiHmn99N
2+7aCwWX6F/qmYhXMjbb8/b9AL+nWy1T/tyGI8JU/abVfVD6Omv4nO12dBm+
16LV3geuJpuLXXk70KRWNvFy0L+QfEe30N3NCBcErBhKEu6HmJHiMO8AY1yd
1vH2WUg/dGX7H3Xx3YnPpAu+r23uh/KdsfGnTpkgo1+1LHnjAPDvaWq7HGqK
R2P9hZWPDQDftof8acd2YcDPZA/vggGIXDZhXn/WDN2kDx817B0Ab5sDzydO
78aE1F0t76Qp+B6mdxCu/YmMhxbKLXQKZK4kNJ1LN8fx+ut/S9tScGvpmmOV
SRa40vtWfJAfBWW+K4xX39uDGw63Vzy5QEGqSprSVrYlasTVWf5MoaA4eJrP
pc4Sqw1afNb+TYHqbuFZdS4DnbISMxcVUfDgrdaFxgYGcs7/Zdj3koJo9bKs
6Y8MVAqzPSFXQYF7AO/Zb40MTIjxT91GrLbi7Jh9CwOHBI1D44gve3bsa+tk
YKV1ZfW2SgrcJG7o9Y0z0Pj7opToKgpUdsu0zsoz8e6T8EfL3lAQVfFTR8We
iYUWPpy6txSgT5fu8n1MPJlxa2KIePS32g2KDky8uKkhTLqOAjufFD0ZJyba
9HAZHOJ1SlsMRDyYqDVV2tpEXOtzDAaDmWi2Xqjs6zsKli4fNX+WzETaNwux
xvcUXDnS67a/mYkm54vLoj5RoLgzyIfVysRpP2bEHeKb8mKBO78xsdlho0E5
cX4xLZzWwcSH4RIHZ4jrhL1vTPYxsere6RaXzxQsTh5/Hz3DxP305Q7YSEFk
+YKtZYosLFK6Ofe9iYJgWeUlatYszMxqWTzcQkFNnqgN2LLw9F73ELFWCpQt
xjLt7Fk4vNmiUYO4NKKaHufAwsOqptZcYoHJoEPibixcr3vieBHx2aZPxeNB
LMwzOskO/UpB7I2Yw2+SWThPHSmY/UbBXS2h137fWAgStC/P2ymoV9o249HG
QrdWscSPxLNLQmjOHSzky+Ls/kFsMT56ybqHhXckGOGSHWTfzztYhoMs7Ff6
wN1HjHblLcJ8bPQvmDwxSfz50umhxBVsTBK7K63aRcHCUX6Fsr1sTG/p3mDe
Q8Fkbvyljv1sLAverLePuM9DW1DkABufgJymD3Fdtx1l4czG9sjr3VeJE788
etnsxcaZi48qvhCvf+HhOxnKRtXYWxLOvRRwYhvfaGew0W4qZv7IDwpu6+Sd
SO1mo0RiU6DrvxR4yg5NPepl40CdmEogsd60jv+7Pjb+bPP4J4L42Ytcd8FB
NjbeaW/IIP7MyeW5TbKxl+YV3kIsEnJ/g76oFb5Of9dn0U+By6u/u2rWWGHd
BlnBNQMUaDlmW8x5WOGXCNeJ5xQFVSn03GEvK9x7E9m1xIcaX0v2+FihnT7e
bSTOtOxrqPe3wrH62j8GiVWAZnsnxAqzaOULlg9SIKeU48y6aIUJml/V/YkF
PuaF3v3LClsfuFatGKLgy64n+VZ9VujZoZG3b5iC7Xsyef79Vrghok3CjTib
ffnnVcoK+682O/oRB+1zMmsYscIdG5PGIokV/SXbmLNW2FvzuSSPmJfmKmkp
wcFgftFO/hEKPo4reJtpc/DM1casZOL6jKB1cISDNIajRvEoBVJ8D5/Q/Tno
4emh+ZKYZTdkrB/AwbKkD6tqiBtkXPauO87Ba57VUi3En8KtLv92moPl/5bc
niVudtYZmojlYI3oklf0MQo613Y9yM3nYNNTBcEC4skCxha1YQ6mFSWsvTpO
gbiBfq30KAfttno8TyRW+Udxv9A4B+fD8tjpxKbl7ad7pjjY4x/vnkOc0OD/
Joefi1LjegeqiOljCTZ/SHLx5cs9wTPEwfptgWwdLv4lZeq+d4KC+ce+hRGe
XGzlX9C5bJL0tzD/wk1vLhrrzXcvJ37KHnIo8eXiw9SALnViv0GvxeNHuSic
2vtBm7hntYez00kuJn3UOmlCXH/dWcEomosb8z7N+RNn+dmF8OdzMUahpuwt
8W6dncbBY1w8mbVVOmCK/LUfPvD7TXBRdHvF4+PED485lbhPcTH6jbhtKLHa
izObbOe42Pjty7VzxNNWL7ToQjxyb0UdScTZx3HxpAwPdw1Z9JYSi1bSPx3R
46HrlbXJQtMUVNpru7of4WFYzMxvkcRSB1yKUvx5WJDK5x9FvNclXaIugIcj
TxNfRxOP+0rn6wXzcOJKgnsCsUbkxPTcGR6epSTDs4lD80ujoq/zsD2XJV9N
TBe2zC18wsPFPTF14jMURIifE+gp4qHNAb2ypcTvJJ+zFUt4WNdelCND7KKk
N3XiOQ+j7p8OVSKO05XfbvqGh9Yx9Pm1xKO23943NfNQKeCQuxkxOiiskvjK
QxWDkLUWxBcOMQPhOw9P993oYRCr+ZQrZXaSeTqkbKyJGRF3nDwGeCixeVDB
hTj5wvdHNwZ5mFtw+7k7cU+04qL6YR6mLw9x8SIOTYrK0Z/gYaT5+XtHiavT
XvK5TpF5bSpMg4iX3frJTJrhYXeHZnsIseO9TVk1czykLX0QFEack+s9MT/P
w9Z51yXhxP8BuE9idg==
         "]]},
       Annotation[#, "Charting`Private`Tag$776154#2"]& ], 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJw913k0ld/3OHBkKkQZE5KhKJmJi8423hsZ7zVFpVKmCEWIEiGSTG8ZUxlT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         "]]},
       Annotation[#, "Charting`Private`Tag$776154#3"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    Background->GrayLevel[0.97],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJw9lnk01V3Ux5Gp0kCZGmSeHhnuvYZU9jYPGRrEDRXJXEIyl6EiEpIoZChl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         "]]},
       Annotation[#, "Charting`Private`Tag$776202#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    Background->GrayLevel[0.97],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQrdT/d/E8uYN2DGDwwf7UxNuFL9Lf28P4XnvZ/Z6l
/4fzz/KacbLECjjA+E79rgeW+0vA+an6v3gNeRXgfF/N1I9i7ipw/qYrtaUn
LTTgfGshrfUs9TpwfvrvSXOXRhjA+fnHnhuv9zWC87ui2FT/5pjA+cnHq9MM
M8zg/IPskoHZkRZwvqFgw7SXJVZwfsJnWx2/HBs4f+G8ozLfe+3g/M19Vrcv
BTnA+SW7bAPm+jjC+ftPLf3UGe0E52e6W+7NjHCG8+esMNyaneUC50/8vLex
oNwVzn+2qrQso8gNzj/iNmlGU5M7nM/of+tRf4MHnM/guI1xQaUnnN8h/t33
UrsXnF8QlXzoe7M3nP+w0STFfqoPnC8yeeatzoW+cP4yAa3K47P9EOFVJO+q
vtofzp+nsEDGNiQAzt9b84sh4wKCr+jN/kc5PBDO33Jes/vmFQS/59g/A4XY
IDh/cvHLrIQ7CH6NqBy/UmQwnL9Sk/VUyQMEn+0Lo+TBuBA4f7nBxrp5zxF8
zaRVfn9zQ+H82547N4W+RvAvLa7StS8Og/N/bA60UfqE4P/fUbS1LS8czvc2
cHOt+YrgH4/Vz8wujoDzrdgDNmzdieCv21Dw/f9/BB8A8gTzyg==
         "]]},
       Annotation[#, "Charting`Private`Tag$776250#1"]& ], 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJwV13c81G8cAPCjrEJWNJBKRSRkj55PmXdG7ohDESmrZKWMoi1JKlFmi6ys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         "]]},
       Annotation[#, "Charting`Private`Tag$776250#2"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0.7698629101673932},
    Background->GrayLevel[0.97],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5984860660054073`*^9, 3.598486138177793*^9}, 
   3.598487346595269*^9, 3.5984873961889153`*^9, {3.598487433047442*^9, 
   3.5984874388614473`*^9}, 3.598488351055285*^9, {3.598488418265823*^9, 
   3.598488444080349*^9}, {3.598488507760112*^9, 3.598488524428149*^9}, 
   3.598488555442738*^9, 3.598488883595675*^9, {3.598488997475683*^9, 
   3.598489012103207*^9}, 3.59848998323764*^9, 3.598490017741329*^9, 
   3.598493361919691*^9, 3.5984934161666393`*^9, 3.598493491303132*^9, {
   3.598494872547477*^9, 3.598494880932872*^9}, 3.598495152185951*^9, {
   3.598495200520692*^9, 3.598495216129487*^9}, 3.598495424367503*^9, 
   3.5984977066629057`*^9, 3.757306119775001*^9, 3.793303766872267*^9, {
   3.79332478144071*^9, 3.7933247994072313`*^9}, 3.793849803946155*^9, 
   3.823227948935979*^9},
 CellLabel->
  "Out[2085]=",ExpressionUUID->"e5a06e5a-ad0c-4065-9d13-ba6418a0aea0"]
}, Open  ]],

Cell["Ziegler-Nichols PI algorithm", "Text",
 CellChangeTimes->{{3.5984687300483837`*^9, 3.598468740626544*^9}, {
  3.598487489979722*^9, 3.598487495742135*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"e512d222-7b44-40e2-a102-0abfad13e640"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"k3", "=", 
    RowBox[{"8", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"0.8", "*", "14"}], ")"}], "s"}]]}], ")"}]}]}], ";"}], " ", 
  
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"ZN", " ", "based", " ", "on", " ", "Kc"}], "=", 
    RowBox[{
     RowBox[{"20", " ", "and", " ", "Tc"}], "=", "14"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"t3", "=", 
    FractionBox[
     RowBox[{"k3", " ", "g0"}], 
     RowBox[{"1", "+", 
      RowBox[{"k3", " ", "g0"}]}]]}], ";", " ", 
   RowBox[{"t3tf", "=", 
    RowBox[{"TransferFunctionModel", "[", 
     RowBox[{"t3", ",", "s"}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"command", " ", "response"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u3", "=", 
    FractionBox[
     RowBox[{"k3", " "}], 
     RowBox[{"1", "+", 
      RowBox[{"k3", " ", "g0"}]}]]}], ";", " ", 
   RowBox[{"u3tf", "=", 
    RowBox[{"TransferFunctionModel", "[", 
     RowBox[{"u3", ",", "s"}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"system", " ", "input"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d3", "=", 
    FractionBox["g0", 
     RowBox[{"1", "+", 
      RowBox[{"k3", " ", "g0"}]}]]}], ";", " ", 
   RowBox[{"d3tf", "=", 
    RowBox[{"TransferFunctionModel", "[", 
     RowBox[{"d3", ",", "s"}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"disturbance", " ", "response"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y3out", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"t3tf", ",", "1", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u3out", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"u3tf", ",", "1", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d3out", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"d3tf", ",", "1", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "y0out", ",", "y3out"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Dashed", ",", "Black", ",", "Thin"}], "}"}], ",", "Blue", 
        ",", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Red"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{"d3out", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Red"}], "}"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "u3out"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Dashed", ",", "Black", ",", "Thin"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Red"}], "}"}]}], "}"}]}]}], "]"}]}], 
  "}"}]}], "Input",
 CellChangeTimes->{{3.598495236673479*^9, 3.598495384257077*^9}, {
  3.7933037570793467`*^9, 3.793303757083296*^9}, {3.793303811361421*^9, 
  3.793303820879313*^9}},
 CellLabel->
  "In[2086]:=",ExpressionUUID->"234db76d-2ad5-48df-b540-4e13c38bd900"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {GrayLevel[0], Thickness[Tiny], Opacity[1.], Dashing[{Small, Small}], 
        LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQrdT/d/E8uYN2DGDwwf7UxNuFL9Lf28P4XnvZ/Z6l
/4fzz/KacbLECjjA+E79rgeW+0vA+an6v3gNeRXgfF/N1I9i7ipw/qYrtaUn
LTTgfGshrfUs9TpwfvrvSXOXRhjA+fnHnhuv9zWC87ui2FT/5pjA+cnHq9MM
M8zg/IPskoHZkRZwvqFgw7SXJVZwfsJnWx2/HBs4f+G8ozLfe+3g/M19Vrcv
BTnA+SW7bAPm+jjC+ftPLf3UGe0E52e6W+7NjHCG8+esMNyaneUC50/8vLex
oNwVzn+2qrQso8gNzj/iNmlGU5M7nM/of+tRf4MHnM/guI1xQaUnnN8h/t33
UrsXnF8QlXzoe7M3nP+w0STFfqoPnC8yeeatzoW+cP4yAa3K47P9EOFVJO+q
vtofzp+nsEDGNiQAzt9b84sh4wKCr+jN/kc5PBDO33Jes/vmFQS/59g/A4XY
IDh/cvHLrIQ7CH6NqBy/UmQwnL9Sk/VUyQMEn+0Lo+TBuBA4f7nBxrp5zxF8
zaRVfn9zQ+H82547N4W+RvAvLa7StS8Og/N/bA60UfqE4P/fUbS1LS8czvc2
cHOt+YrgH4/Vz8wujoDzrdgDNmzdieCv21Dw/f9/BB8A8gTzyg==
         "]]},
       Annotation[#, "Charting`Private`Tag$777683#1"]& ], 
      TagBox[
       {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJw91nk01nsTAHBECJU1XMlWUU+hXOm5ZaYi0iXP4nkeW0XJljUiUVSkUqHF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         "]]},
       Annotation[#, "Charting`Private`Tag$777683#2"]& ], 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJw8enk01d/3vmSMJENRSOYpQ5nD3uZZLtclZaiEpAxRElGUUgmpJEOkkiRK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         "]]},
       Annotation[#, "Charting`Private`Tag$777683#3"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    Background->GrayLevel[0.97],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJw8t3k41O/3P45UvGhRiqTIFpIte3Qf29gZhsmSJdmiJNmXECWSLSFZh7GM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         "]]},
       Annotation[#, "Charting`Private`Tag$777731#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    Background->GrayLevel[0.97],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {GrayLevel[0], Thickness[Tiny], Opacity[1.], Dashing[{Small, Small}], 
        LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQrdT/d/E8uYN2DGDwwf7UxNuFL9Lf28P4XnvZ/Z6l
/4fzz/KacbLECjjA+E79rgeW+0vA+an6v3gNeRXgfF/N1I9i7ipw/qYrtaUn
LTTgfGshrfUs9TpwfvrvSXOXRhjA+fnHnhuv9zWC87ui2FT/5pjA+cnHq9MM
M8zg/IPskoHZkRZwvqFgw7SXJVZwfsJnWx2/HBs4f+G8ozLfe+3g/M19Vrcv
BTnA+SW7bAPm+jjC+ftPLf3UGe0E52e6W+7NjHCG8+esMNyaneUC50/8vLex
oNwVzn+2qrQso8gNzj/iNmlGU5M7nM/of+tRf4MHnM/guI1xQaUnnN8h/t33
UrsXnF8QlXzoe7M3nP+w0STFfqoPnC8yeeatzoW+cP4yAa3K47P9EOFVJO+q
vtofzp+nsEDGNiQAzt9b84sh4wKCr+jN/kc5PBDO33Jes/vmFQS/59g/A4XY
IDh/cvHLrIQ7CH6NqBy/UmQwnL9Sk/VUyQMEn+0Lo+TBuBA4f7nBxrp5zxF8
zaRVfn9zQ+H82547N4W+RvAvLa7StS8Og/N/bA60UfqE4P/fUbS1LS8czvc2
cHOt+YrgH4/Vz8wujoDzrdgDNmzdieCv21Dw/f9/BB8A8gTzyg==
         "]]},
       Annotation[#, "Charting`Private`Tag$777779#1"]& ], 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJwUV3c81e8Xt7ebvZLsPbNX95jXzuW6ZhGyd5FkhRCSopJ8jVJRKllF8vmQ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         "]]},
       Annotation[#, "Charting`Private`Tag$777779#2"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    Background->GrayLevel[0.97],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.598495365503467*^9, 3.598495386005917*^9}, 
   3.5984954252180634`*^9, 3.598497707444751*^9, 3.757306120539995*^9, 
   3.793303767248719*^9, {3.793303812897814*^9, 3.793303821478333*^9}, {
   3.7933247818383217`*^9, 3.7933247997781754`*^9}, 3.793849804376773*^9, 
   3.823227949418789*^9},
 CellLabel->
  "Out[2093]=",ExpressionUUID->"6b86b0e8-c974-4c77-ab91-4caf2a32a8a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{".8", "*", "14"}], "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"8", "/", ".8"}], "/", "14"}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.598496666433098*^9, 3.5984966897916327`*^9}},
 CellLabel->
  "In[2094]:=",ExpressionUUID->"f333fa68-5267-4fb9-b711-7536e1750730"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11.200000000000001`", ",", "0.7142857142857142`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.598496690262693*^9, 3.5984977076152077`*^9, 3.75730612069736*^9, 
   3.7933037672604723`*^9, {3.79332478184975*^9, 3.7933247997899723`*^9}, 
   3.7938498043870983`*^9, 3.8232279495740747`*^9},
 CellLabel->
  "Out[2094]=",ExpressionUUID->"8445ae06-e0cd-4638-8e26-d03394fe2dcf"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.7938497698364*^9, 3.793849774662876*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"c0de7116-260b-4c34-a0a8-2b09a6c343fd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dt", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"y0out", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"y1out", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"u1out", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"d1out", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"y2out", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"u2out", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"d2out", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"y3out", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"u3out", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"d3out", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax", ",", "dt"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<PIDtune_out.dat\>\"", ",", " ", "dat"}], "]"}], ";"}], " ", 
   "\[IndentingNewLine]", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.5984853763113613`*^9, 3.598485527962461*^9}, 
   3.598488357821542*^9, {3.59848852940943*^9, 3.5984885482608337`*^9}, {
   3.598495395012817*^9, 3.598495411540078*^9}, {3.793303722212463*^9, 
   3.793303757084343*^9}, {3.793849796022111*^9, 3.793849796253355*^9}, {
   3.793849827558962*^9, 3.7938498293549557`*^9}, {3.793849865800357*^9, 
   3.7938498662867126`*^9}},
 CellLabel->
  "In[2095]:=",ExpressionUUID->"7c05237c-4f5f-4c42-b891-b36dafba1fa7"]
}, Open  ]]
},
WindowSize->{740, 752},
WindowMargins->{{44, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e57cd7a2-0ea4-431b-9d31-f1adc223a1cf"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 247, 4, 67, "Section",ExpressionUUID->"5960a009-d100-4dcd-a274-3a6ddb50a095"],
Cell[829, 28, 175, 4, 30, "Input",ExpressionUUID->"5c7ed008-b19d-47e6-98f7-d0b42d2ffcc8"],
Cell[1007, 34, 311, 5, 51, "Text",ExpressionUUID->"84b2d739-2ac1-4e38-a794-dfdb80e655cf"],
Cell[1321, 41, 1729, 37, 97, "Input",ExpressionUUID->"7ee7bff1-77b3-466e-97fe-7c6b6a8a2c69"],
Cell[3053, 80, 662, 12, 51, "Text",ExpressionUUID->"32bbea04-3afe-4cb6-8015-8d274b687201"],
Cell[CellGroupData[{
Cell[3740, 96, 2158, 46, 157, "Input",ExpressionUUID->"2ea7c208-d6d2-4d41-abe5-0fadcd5c4831"],
Cell[5901, 144, 10838, 235, 116, "Output",ExpressionUUID->"4b95643e-b616-458d-a6ae-b523047233e0"],
Cell[16742, 381, 31143, 529, 242, "Output",ExpressionUUID->"aa37659e-ac81-4e9f-956e-07181ed7f9ed"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47922, 915, 336, 8, 30, "Input",ExpressionUUID->"b79fc745-9eea-4f3f-9505-8e0cdef0509e"],
Cell[48261, 925, 1236, 18, 34, "Output",ExpressionUUID->"8daa65b8-4191-4d87-a4b6-0da928f1d07c"]
}, Open  ]],
Cell[49512, 946, 582, 8, 51, "Text",ExpressionUUID->"786035a5-0226-4bb7-887c-6544271c9ec3"],
Cell[CellGroupData[{
Cell[50119, 958, 2296, 53, 73, "Input",ExpressionUUID->"1d268592-b92a-4a59-93d2-349674ba2477"],
Cell[52418, 1013, 2296, 35, 24, "Message",ExpressionUUID->"1c45b2db-da9b-48af-a11a-aac2a098d0bf"],
Cell[54717, 1050, 33099, 559, 223, "Output",ExpressionUUID->"9cfc2590-69d8-47d3-9891-ff3b767f85e2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87853, 1614, 1068, 26, 52, "Input",ExpressionUUID->"fd8dd30f-d6ec-48cd-8876-7c3be5d68557"],
Cell[88924, 1642, 1429, 22, 34, "Output",ExpressionUUID->"520de8b3-a3d3-42ed-bb8d-ee13b5dca90c"]
}, Open  ]],
Cell[90368, 1667, 404, 8, 51, "Text",ExpressionUUID->"ded4cda6-93e8-4d50-b244-4fa2436187e9"],
Cell[CellGroupData[{
Cell[90797, 1679, 5754, 141, 391, "Input",ExpressionUUID->"15388b5b-8cd8-43a8-8eab-e372ba0eea4e"],
Cell[96554, 1822, 47683, 840, 141, "Output",ExpressionUUID->"f3fc57c0-14fa-4f17-b9bf-018e33528b79"]
}, Open  ]],
Cell[144252, 2665, 400, 7, 51, "Text",ExpressionUUID->"b7842e4f-8131-4dae-9638-acb8a72b1a22"],
Cell[CellGroupData[{
Cell[144677, 2676, 956, 20, 73, "Input",ExpressionUUID->"a95c19fd-82dd-4c06-a9f5-1ce5ac7f6576"],
Cell[145636, 2698, 3408, 73, 57, "Output",ExpressionUUID->"c1f096f3-b144-48b1-9ffc-ba77a087a950"]
}, Open  ]],
Cell[CellGroupData[{
Cell[149081, 2776, 4280, 117, 349, "Input",ExpressionUUID->"ebb9cec1-dc46-4c59-b144-f1dbdbe79304"],
Cell[153364, 2895, 46432, 825, 130, "Output",ExpressionUUID->"e5a06e5a-ad0c-4065-9d13-ba6418a0aea0"]
}, Open  ]],
Cell[199811, 3723, 249, 4, 51, "Text",ExpressionUUID->"e512d222-7b44-40e2-a102-0abfad13e640"],
Cell[CellGroupData[{
Cell[200085, 3731, 3901, 120, 350, "Input",ExpressionUUID->"234db76d-2ad5-48df-b540-4e13c38bd900"],
Cell[203989, 3853, 80679, 1388, 130, "Output",ExpressionUUID->"6b86b0e8-c974-4c77-ab91-4caf2a32a8a7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[284705, 5246, 362, 10, 30, "Input",ExpressionUUID->"f333fa68-5267-4fb9-b711-7536e1750730"],
Cell[285070, 5258, 413, 9, 34, "Output",ExpressionUUID->"8445ae06-e0cd-4638-8e26-d03394fe2dcf"]
}, Open  ]],
Cell[285498, 5270, 179, 3, 51, "Text",ExpressionUUID->"c0de7116-260b-4c34-a0a8-2b09a6c343fd"],
Cell[285680, 5275, 1913, 48, 233, "Input",ExpressionUUID->"7c05237c-4f5f-4c42-b891-b36dafba1fa7"]
}, Open  ]]
}
]
*)

