(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    171423,       3322]
NotebookOptionsPosition[    168068,       3257]
NotebookOutlinePosition[    168465,       3273]
CellTagsIndexPosition[    168422,       3270]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Instability on increasing gain for RHP zero sys.  (Problem 3.13)\
\>", "Section",
 CellChangeTimes->{{3.504267851694449*^9, 3.5042678646393023`*^9}, {
  3.756999395626483*^9, 3.756999426991372*^9}, {3.793325287810915*^9, 
  3.793325316814187*^9}, {3.793848437628469*^9, 
  3.793848450283609*^9}},ExpressionUUID->"90372875-bdc4-460c-a8d8-\
65809edc93ea"],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellLabel->
  "In[1956]:=",ExpressionUUID->"e1da7b9a-8fa3-42ec-8763-f3a2825c2727"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"G0mp", "=", " ", 
    FractionBox["1", 
     RowBox[{"1", "+", "s"}]]}], ";", " ", 
   RowBox[{"G0ap", "=", 
    FractionBox[
     RowBox[{"1", "-", 
      FractionBox["s", "2"]}], 
     RowBox[{"1", "+", 
      FractionBox["s", "2"]}]]}], ";", " ", 
   RowBox[{"G0", "=", " ", 
    RowBox[{"G0mp", " ", "G0ap"}]}], ";", " ", 
   RowBox[{"K0", "=", "Kp"}], ";", " ", 
   RowBox[{"KG0", "=", 
    RowBox[{"K0", " ", "G0"}]}], ";"}], " "}]], "Input",
 CellChangeTimes->{{3.756999464687167*^9, 3.756999544652677*^9}, {
   3.756999590818722*^9, 3.756999608823454*^9}, {3.756999663918887*^9, 
   3.756999695355914*^9}, {3.757000379171546*^9, 3.7570003923680563`*^9}, {
   3.757000550238027*^9, 3.757000562680847*^9}, {3.757000875424568*^9, 
   3.757000879212371*^9}, 3.757001087444976*^9},
 CellLabel->
  "In[1957]:=",ExpressionUUID->"6ab4e372-bc94-4de1-977d-9636cb717006"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BodePlot", "[", 
  RowBox[{"{", 
   RowBox[{"G0mp", ",", "G0"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.756999650196097*^9, 3.756999655972612*^9}, {
  3.756999702587245*^9, 3.7569997113449373`*^9}, {3.793325388859708*^9, 
  3.793325421825934*^9}},
 CellLabel->
  "In[1958]:=",ExpressionUUID->"a529adff-c86f-42e3-9a35-91c254770337"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVl3k01Iv/xgeRcLXZrqQsbYhUotx87PS92lwUJRQlKUlJikqlSCJLlCyF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           "]]},
         Annotation[#, "Charting`Private`Tag$725664#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVl3k01IsbxgdZoitlvVKytCFSRClfW+hebUJRskRJSiIh2lMklyxRshSl
SLKV0PO1k12y78ZgLDPDhCnx6/fX88fnnPe87zmfc97zyDm6mztzUygUES4K
5f856a1XtqyJDX5ZTwtTzUCYKhEb7OrYMAorbogzC8SLnr2B+dVs/Ig4Ub7c
KRDHjXRML5awURS/LHBrRCBKVu2sbctmw11GQD1hOhAx6cotb6PZcKgu3mCQ
dx8GgxLUwyfZeC+V8dvwSBDiosT3pR1nw0zunU/X+SDMmYq94rVkY0jxQVto
YBDS369y+XyADbZkXO7+wiBIBqyYUCD+7GPhqiy6JRgTktzsWTk2tt03VVwp
8BBPDkzyPB+ZQW7cmYXb3SGo5Z/uTh2ageov5RG73yHgLpnNzembgblk4lbH
dY9wcSfFpbZtBmFFYlfb7B/BWFa09lflDHTtNr8JGnkENlM70iZ1Bj3HWWHb
F0JxJPKuotS5GQhur3YfTQpD4MGg3wrOM6D/8zugLScMhQKhrWoOM1h6cntl
d2UYNgc8eWBiPYP1LjzrNk6FgXLm7YT3/hkUHrocS+qEI0OrMef7lhn8rPyL
rtgVDqGuNfsi6NOg8T9otFOOgPBazrZB2jS2CFUVFRERELFrlVEfmoarV5KB
ukUExIbC2PVd0wi66XjROiACMuO8yYJ106BTtjRnNkb8uZvBffv9NGSjcnaH
XYvE4TVl5CWvaeg9cdv8eTAK5rZJ6bg0jZutgn9xOFGwSLgeI3xhGhYp7x8f
XhWN4wq7LqU7T8OpgGdsv140HJQzZEetplGiFJTgkhCNyzox1+12TeOY4F/+
FxyfIOqE256DiyzIrOJetFiIwZdD6lnvf7IQ/biYaSURC5rh7KZVcyxs27pl
0HNbLLRVboq2MFgwSgrYtuQUi+6FCLr1AAsJjKOhpxpiIR9fEONcxsLto0bG
1m+eIqNf8Id/MAt3552urPCMQ1tLg2tvIAt2L1QuvgqLA6U6sp+4w8LHWidp
u4w4HPmwrpbbn4UzLY1CW+lxYN/a/vLBBRZ0Cg816p5+jt0KNkciD7NgocPU
tjoRj0rnN+/SJFi4VndfUnZ7Ir7aez37spoFWZlnvs5Giag/QQQ1CbPwvc/0
LGmViNYj353m+FjIMzHQz7mWCNpeLhnDOSZqrLuuRlckgk/COrizjYnLpvr3
rO2TsK9C4OzyWCY0SzV23E1+AdPibxYyUUz4a388H5z/AmaF8QZq4Ux4kC56
qfUvYJGlsc4yiIll3XGblDkv4BRv/z3Rl4kyXu+Ww4de4q73J0NtGyYmlx/T
30FJRulGl/Vn1zAhdtXghOSVFES+EZIrkmTCRplimvowBU4q7+VExZjgr0lt
PvwiBcu2z8pjBRNrPPIVxhpSEOwn8K/qAgM+ykYuu1Re4b/XepahxQxID+ic
uzj2CjFcH84dNGNA2EpUsM87Fdr8864/jRhwuhstHBWWio4VhNurvQycC9GZ
dn6bCmmpuouLqgzQz8pUHO9NRZzqmGfGKgZuOH7OvGfyBkkn5K4Lt01hvnjs
srjsW7zNDX9c7zCFdanMDx1DaeCqpt7psZ6CzGPjjzE86TjerXVl4sgURrYN
Jl9TSAcfT+8xQYMpdM9d7Xh3Oh0Oh5XWGstP4fz6/8SrhtMhNV7yumhwEivY
Hq1zzHcIXM8uTD89ieH+7M6dqzPRs8Mko+DEJLw8/nELUMyEhsnThK9HJ6FJ
u5PQvjMTgxf0bo8aTmKur8S47kQm9haEmCgqTqLWUEou61Um2JYbmp9RJzBt
MhZ3Xe8DTj+0Ggl2nsB+6vCn2rtZEODxnfhiOwF3HPH2jM1Cut8z1rTlBD7l
05arZ2SBfa7/l43xBG7ITkuw2rJw19RVRHnTBAxqRQLvq2Qjhff6rprRcbjI
7P+l0JmNkRspD4XcxiGsw0VrNslFyFxlGOE0Dr8A6v1Au1xsc6dHeZ4cxz9J
uQctrubC55RaYpfZOAbfHS/UfZ0Lgb35OWlbx1HhF7nTXCAPW37W9vzLoONv
tjblUUMeznux1UIu00F4MKblPT8h9VeljfF5OoTfNHvfCPkE6u1n9yhOdDy+
PbX4I+UTToUbdHlZ0nFwv9Fd9Y5PMM8IC7TVpsNsnbDRsF4+tEdVelQXx+Cb
o8u0Ev8M3pPOwU1BY3g4y8ev8K0ABkPauQ9vj+Gyi9AjNqMA111X9O+7Ngb3
naIhQysKMe+TrfnZbQyCBaWu0iaFmIjiGnhxaOyPH10jU4WFaG54ruUlPgbb
muiNBzKKkGDYSpVIGkU1npfkpQKP23OXdsSO4t9OhaGdtUDghSjpI+GjKJ7t
0etlAG5PLA4/vDWKAgGDjKY1JLTHmwuWHEZx8uti9z0nEk2PGx6Pyo/CbHjc
sYhDgmewSu9z8giqHv24tEyjBLPeqSfa4kZg/kC61NG0BHShB97syBGkTXJu
tJ0sQaOmSbrqvRH0Dp+MXRZYgrigcsmXziPg/bhywr2jBJrqJVMPN47A5ZaR
a+LdUpy9WRBnm0rDY80V/0lNlmFa0ayHkkSDSorqOhp3Oa5Xd69NjqXBpkVq
rlqqHNGrF+PpwTSIqs70tBiVoyJZL+nqBRpWz3SMcZ6XQ7G6PCV8Ow1cNR9C
Ii0qMLCqMaO8cBi/GyLz079Vwi3PnuGSO4zwlR7e7hOVmLdhqa3IGIYgQ83h
X94qiCSv/mCeMIzehIPyh7SqoLfTMrvv1jBeyUTxBsVVId6m8yPHeBhiT94p
d5+vxomXVHJrExUiEz+tstfVQCPdSHy2mopT0QVSxO4aCOcmn/tSQkVAzMmN
NMsakBVOqw/lUGEhsCok8FENFOnU05eeUCH14IOl6GINJrYN82XbUtGbcrTW
k1oL/y/DZtr0IaTFyMmsqKyHZeW+JMrQEF7zXyvVoNVDtTHlR1XXEHJuSkj6
8zagf8A53rpuCI1eFM2zRg0w4qUx/DKHwKeveDGrtAF/mdEeF3kP4ftHuvQa
p0bEd9DaDXiGMCtZemXAqwmqTPO1F38NQulKzuzC/SYU8cEhdmYQWyw5+SrP
mtC94wmdMTSIJI+OY9XFTfg71GQhrmwQVGmlTZyVzYg0SJWduzcImw0pv40y
mxGcdu5MmsAgrOz/ObWeqwXSJd/ftlIGkeIeaz0h0YI37foMLs4AlDSpuxtU
WlDFK+1zfGwAK9W8BTqPt4DX/msQ79cBNF/OMuDLasFNMeV3dg8HcMbDg7/O
5TuuBEzMiAoPwKDdViFvtBXxL5efKucbgHjxQdmBpVZUVG+s8l7qhxc1OkJe
sg0SEg5xHcx+BB1u0xjb14a8jO9GCd/6IbS9Mfh+chtm+75EKcX2Y/6hmbb0
mXZcNQjX0lfsh9I6W6nNvzqQ4JKRNC3TD9WDmV/2i3eiMrRGKFm8Hz/veF65
q9YJyS7efj7+fojfWnTd59QJ9xG2SOy3PiwIqrXP1XeCub8y6/2pPvj3Z3HU
33SBJew22+3VC0dTqZ0xHj3I8P7ylte5FweaGH03w3vg2itip2rZi18OcweC
P/SA+i638oZmL0zfCE8tsXrQZrYUIz/bgyM1g4G+f+YUBT/Wcbnagxc33saT
N/oQxJd/c8a3GyNSJ3fptPfD+KKQpoxrN5Z6t3hb0/vB3Wo7ZmTTDZ6cXbzB
C/3wT+E2j97djc0N8TbycgNwNzJT2PWrCypiXKnq5wdgebuv/Lp/F3jueEp2
cA9CbpFXSPBGJzZJqPtAbwg+qnM0f/dOiOqefDpi8cfDU6MlDLtOrLL3O6Nw
bgjX8dXvu14nxMwb9raGD6Hz5n/0RO5O0H+YZytRhxDJ8/dXrcCOP74sbHwe
QoXAcpUg50ftMBSw3bx2chgMUXP+4metmBBJeGvKHIXP6RRVvUet8Hdsldoo
MAZK9rwlrrfCSHDppNT6Maw2T0gucmjFsamAJJ3DY9AIm9D/vKkVB54G5Fz/
MAafFff9s7O/I+uBXAePDx3cvIWslJoWrK4qvu8hPgHx2Q3dwb+asZ3hsE82
igFBh/ChhvFmzDwPrd+UywCldoEu1t2MsjuH9A98//P3k75x4gubUZd0P2ZO
kIkvB25JZgc0g2GxNt3UjAmXlG7zrqUmZLhq9L5vYqLQIqJaeVkTtHq2mLSO
sFB5huti7N/1GK++/DbBkA2xa3GiexbqUNiiXa9txYbjf1r5vb11uHcrOKnf
hY2FjxeWKSbXYX7ziSsnQ//0guWdTzNU68Bpnn/F28nG07SsylLDWqisNm9R
9PqBC8zTclMXvsLX63fH1+xZiPpVtBiUVCDU9/z4QUcOdpeH7/Z4UQHq78p/
Mv04sBexTUy4XQG50DvLN0RwkP5q5vyCQQX2LDOoNC3jwPjbep680nLY8nqq
+236CT+Va+pbysuQcFVZPIT1E4O9aqErq0rQ0rhpQ0rkAhzvb//v07MiPDMN
3auygkL+rWfE2WtbBIMU0y0vpSlk47zl6dJ1RWCP5pgrbqGQe119teqTCnFU
1tt1nzGFlDpA9g29LoCgrc4S9y0K2bD64LaVOfmw3+S86+I8hdwTf67JuTYX
Yg20d5IMLlLJVX/Txp9p2HPy3MtdCzxkr9/ez/2pjoTXVNXrHkMBcv36LfzF
DpmE1bxWf3vEX6SAgsMrhhyIF1G7pTkRq8jCfS5Hf9VUECZyLHHNaDHypeHj
SuHkemJwQFswT06KvGBhtW/xZzPhc8zA9176GrI/rXt9wHQrUca9/MzdAlky
tztT7HJbJ+Gxh8GXNCNHbtf/rWbh20sMRtvE/D2nQBo6J8n3aQwQp6TbDMI0
N5LFhpTiYKEhgmZ/7IGn9WaSKRx4ntVOJbx55u9uv6ZEPnQTEI2roxE2w7pR
PN9UyJ9DxgeLEkeJxgBjDX0BNbJl8lag/DM6QfPT5e/5tI28vcrXfNFzgrDS
y87t6VQnB+SeKEUZThHrRf2Y5+e3k1aD7Utaa5lETa75/G41DfKVnlFOPz+L
mAg5HilmrkmqjG49q8w3Tdjc+Go28mgnKcinnPhtaZrQ4Ar08S7TIpu38Sl8
HJ0hzrzqPnaDpk02Jtsl7xlmE18E4m4byO0mP2144v678QfhrbY4fMREh+TI
DJJrPs0SpvChFp3dQ7rbpol0Z80R17weHKlO3Es2vDV/2xY3T9C6z0gslOmS
flxClycS54k3vSnzYl91ScXjpbu4UuaJI8Iq3VsbdEkfXo1qpXfzROtv/td2
HbqkvL34aEDRPJGf3vJv6aQu6S3evkGxd54Id7jWGCxBkOtu2iZdkuUQbrYb
C6VdCLKqVfzcPQUOMaoSWLbjAkF6bq3f9nQTh/gYQqk3u/yHd+qSpWocQqCF
oF73J8jLmuv7JPQ4xI7csrVDYQRZTh+UKbLnEMt06kvT8gnykv4zapMTh6g9
SPSUfSFI6Zij6TQXDmHNyZvrKSXIi/vKdEQ8OES7ca6aSD1BSiWm2Jy+xSGk
rtemeQ0SZMmsrbzPPQ7ROn+47tEIQV44IEEPCeIQ8dHNjFcTf/jPQN+8cA7h
86xKq2OWIN2OEPo1URyCL2+37fQvgpRMnRPoj+UQpu+ai+9R9MiSxfeN7Occ
Qjz7juVqHj3SzdIlZvkLDpHQ9X4snleP/B9SG3KK
           "]]},
         Annotation[#, "Charting`Private`Tag$725664#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-1.3010299956639813`, -32.04391213499843},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-40., 
           FormBox[
            RowBox[{"-", "40"}], TraditionalForm]}, {-30., 
           FormBox[
            RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
           FormBox[
            RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
           FormBox[
            RowBox[{"-", "10"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-38., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-36., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-34., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-32., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-28., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-26., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-24., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-22., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-18., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-16., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-14., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-12., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-8., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-6., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-4., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-16.021956067499215`, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-38., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-36., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-34., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-32., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-28., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-26., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-24., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-22., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-18., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-16., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-14., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-12., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-8., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-6., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-4., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-1.3010299956639813`, 
       1.6020599913279623`}, {-32.04391213499843, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-40., 
          FormBox[
           RowBox[{"-", "40"}], TraditionalForm]}, {-30., 
          FormBox[
           RowBox[{"-", "30"}], TraditionalForm]}, {-20., 
          FormBox[
           RowBox[{"-", "20"}], TraditionalForm]}, {-10., 
          FormBox[
           RowBox[{"-", "10"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-38., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-36., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-34., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-32., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-28., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-26., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-24., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-22., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-18., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-16., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-14., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-12., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-8., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-6., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-4., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-2., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-16.021956067499215`, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVzHs01HkYBnBRQzk7JUyp1JhxCVmlMqdVvsYwrM3EmPmV5Ag7kZBIRWtX
7cku2lqEahRyyaXUbpe1lb4vqqGkRrkkuTVpjoQZ05iftrHTH+95zuc8z3mt
IvbzRfp6enr+uvuaHw95PJgrVWEZO3J0wwgFfB2QTdhTFZbGnKlkKSlw6c2W
jH9bVdjdeXGNh5YCO7zcfOObVNh/cipPRDOEJhPXtu4bKqyfUsf7zDWEs1cc
X9YUqLCLfpBHcLUheA7TZAG7VHj8lFG8OtEICv0/Glx4P4UzpKyAQ8sWgPHr
5d55o0rsYMCiu5pTIT8kdjNPq8DpxfXMCkcTkIiqr9bSFFgUVvzK6aQpNNtG
06OWT2LF+pyczp9pUHMrJ7c9fBy/Yx03UJdZQGQ28T5LNIbv8zl3CzMtYd9B
lfPJxFHcscnHIlBNh2JOl4xWKseHp8YFmX5MiEq/WxRaNYJns6vEXfa2EFIm
AyepDE8/tG6x32gPF1+N9HgavMUigaI6MGcNJKeNTZlSh/Cmfbb5q4i1oKDG
qvsO9mPH7/Xfy4+6gJV2nvGCX3rxayaPmW+2ESZM+YaN4i5cyloUoZSzwFxt
05f1uQNzDseIy9u+A8meOfHnLNrxdGdD6vA6dzBNffTSs+kRtpPEX9I+9oCI
31xO14sb8H+zmsy2O57gEMO2s52pxSYTR+d33/CC/tQtdwarIlAmbzbZLY8L
dLq9YWP4deRXcHlu6HlfMGKGV05YYRTDufj0crIf3POODvr85BFyjE72CWBt
hTJOroRa3o4cVgav1qPwIE5AeGtnOlDSEc/wpHPbYLC2j56m7ELHIj2fsQsC
4FbfdbPE7l40bm33ZbFfILiwvzgLUvpRwhXe0O2hQOCIShkDG4YQ9/LeYNdk
PjRy9BqzjN+idvKbuoEJPkxSM/YpemSoxSK9iBoSBNmxRqZFT0dQ3BvfHrIx
CGbecnkNJXK0Oy79TDFNAC8/HstgiEdR7ox1hk+UAI6bpPC1SWNoqsD19A/V
AhiyKnTI54yjQHaWg++wAIjhnlmW5SS6HzKyMGGpECo9vG4OGiqQtDX2WZmX
ENbInaIcKUoUWfIEUuOFsIDiWPJiVom2qLgy51whdKylMP+RT6GFvdTt/teE
8Lw8rHzzOxX6EFyXNvBYCPU2hfu/PP+E1p8aWx80JARyxTAsr1ejivabXmUq
IewPrV3U9/c0iqRIOUoKAc9q+DXdRRrkJuH+8tqcgNQ5xoljJRp0U+Vz14JG
gPWO5k1zKjSo07KrY7vOR+ZtaHW4qkEDB8bPvNCZsdtcntagQZJXYVGtSwg4
ZN5jY92v+5dctr3OgoCV6aGlCatI9BfXRh1qSUBLl/neE0wSHfzTrK1Q5ySn
9rXn7UikCWOkS7/2ve7Q7Eyin+rkx71WEpC4kT5A8yBR3i6fT6tXEfBwdHhF
w24SbRVEXPxAJyCBLZZJfyTRHk1UGNOKgGVng66MRJNIcrh5dqfO8d4P3BYd
INGvwpb+Vp2XllTsjDxGIpm75dJKBgFN6lDGkRMkUt5719mnc5w/bfRkJomI
XHGSKVPXz2Sk3M4h0bp1y7al6xwbiNhP8kl0ijD647bOS6qmjQbPkcgs+9va
sa977bXnqgskqgsvrmZY6/bC6LPzL5EoLSLu9x06/w/iznxX
           "]]},
         Annotation[#, "Charting`Private`Tag$726474#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVyn881HccB/AjIR4juxwicaK5kh+VarSPc65suWsk8+jI+TUnP+4bUnlM
aFHJVmlCVEhlfizL4pb0ebuKTBkmZLqkGzc5OS7uy7p2/fF6vB7Px+tlGyEM
iNamUCgcTT62PNXroU6PEof5Z8csk9HAl4Hsw54q8ZvmBl1jJQ0qXmzP+b1D
ifOTmxUrKWYQ7OPhmyhWYr+XySK2uRmITdyfDDQo8UPq7ahxXzMoql3XV31R
iWmBW1bvrzED71Ga9OsQJR41PF3rcsgcCjnyJZfHZ/Gbc4cj169aCYZ/W7Iv
TMxgleuuthALayjgxXty1Qp8t8C1o3mDLbRH/1xXQ1PgkjL3f++ds4MHDgKb
GMtpPJmWy+nIdoDqO+fzu8KnsE7yl3tZvzhC5Jmg8dzoSWzSslrEK3aCuBSl
c17SBDaXi4U7tF3hKqtfSiuX4fs6ttqfhWyEmMzm0tCqMZy2m3Hqio878K5J
walHioeXWB2sDdkGV56PDXoveY0HFSeM9Do94VD65CzV6BUeUeVVZ2R5gcIo
fm44RYL5z43UFs3eYKteamiQMYStt+qeX57MhrfUAL3Wkn5sLMmmOKX4gumc
/XDuYi/W/uJU3HT+Lmj/Viux2KILL4Qq+3v9dwM1ra3PW9yGrag7xMd/8oeI
k25nRSUt2GKxKeHE4B5gHGCudViowc4mbqkcFASStO13R6oiEMUwnbuvPBhs
bBz1WsPrkYWbV05AMA/07cJvvLXFaLduBo9FhsI9tmDPYmcbaqlyUF3n8OEa
K7/dqLILGZZwWi3vh0NCYBBbvdCLHAO6rU9RI2GkZtgmfaYfzR8SHGOmR8Gd
4foVSQNDyNuqLvJWbzS4Md87Bx6VIMdLiYFySgywosvpLze9Qp+i8MyGjQJo
ZVFacw1fo8t5E+Q+z1iYNsqJUwxKkTE13CCTcQDOxOtTS5+Oofbywh/lK+Jg
4fUObkuZDKXsBOnt53HQJ8/KoZdMoCzijJRZFA/HTY4GqJMnUcXZGl1v9wR4
ZVvIKGBNIYOWC/QFnABBo4MftqyaRltvzstHWIlww8vntxE9BeotEUW41SfC
eplTzDrdGdQnrM/YbCYEA911ZX99mEFUIbMgWSiEXhdduybZLJJZ07cXNwmh
uzKs0vMfJQJ+sdT4PyGI7AuF77vfoWMuA+2zFgSQVqNgKZpDU8LRwx9cCRCG
1iwfvj2PfmjoP9ntS8Cf1QHVA6UqxOHWWsTyCEjTMkyaLFOhrrvP7jVqvCb4
wTat6yq06HDHTSeEgCNLN3Uw6lRoLFZ98YrGdL6pLL1FhQL25/v0hBKQajpo
v0aiQga93K828AmwzgwtJ1aTiBtY+Wt7FAGP+01js+1IRFCpL4yjCUh26nK5
tJZEN7X4km80fjz0BTxwJlFXx7uIcY2TNtu8pHmRaKiiKVUnhoBHE6NWLXwS
XXpW+sI9lgCCWSLtiSKR33GPpO80Xlm0p3ZMQKL6xi2SVo0T2Q89lh8kEUt0
w9PvAAHmZdf3RWaR6JOdU6ZhcQSI50LpR7JJ9KRRX3BN4wQObSLvNInseR75
4x/3hZyjjedJxLjKFgrjCYj3R8zOAhKt4OyiN2hsVjWvP1JMIhu/R3VzGovV
t7qVl0mk//0fJp8naP57BUXLKkhU1HmQm67x/wCsemg=
           "]]},
         Annotation[#, "Charting`Private`Tag$726474#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-1.3010299956639813`, -262.84309238864216`},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& ), "CopiedValueFunction" -> ({10^Part[#, 1], 
          Part[#, 2]}& )},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{{{-300., 
           FormBox[
            RowBox[{"-", "300"}], TraditionalForm]}, {-250., 
           FormBox[
            RowBox[{"-", "250"}], TraditionalForm]}, {-200., 
           FormBox[
            RowBox[{"-", "200"}], TraditionalForm]}, {-150., 
           FormBox[
            RowBox[{"-", "150"}], TraditionalForm]}, {-100., 
           FormBox[
            RowBox[{"-", "100"}], TraditionalForm]}, {-50., 
           FormBox[
            RowBox[{"-", "50"}], TraditionalForm]}, {0., 
           FormBox["0", TraditionalForm]}, {-300., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-290., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-280., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-270., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-260., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-250., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-250., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-230., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-210., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-190., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-170., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-130., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-110., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-131.42154619432108`, 
           FormBox[
            StyleBox[
            "\"9999\"", ShowContents -> False, StripOnInput -> False], 
            TraditionalForm], 0}}, {{-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-250., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {-300., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-290., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-280., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-270., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-260., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-250., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-250., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-240., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-230., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-220., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-210., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-200., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-190., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-180., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-170., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-160., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-150., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-140., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-130., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-120., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-110., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-100., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-90., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-80., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-70., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-60., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-50., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-40., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-30., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-20., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {-10., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
            AbsoluteThickness[0.1]}}}}, {{{-1., 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {1., 
           FormBox["10", TraditionalForm]}, {2., 
           FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {1., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {2., 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], 
            TraditionalForm]}, {-0.6989700043360187, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.5228787452803375, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3979400086720376, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.2218487496163563, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.1549019599857432, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.09691001300805639, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {-0.04575749056067506, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.3010299956639812, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.47712125471966244`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6020599913279624, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.6989700043360189, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.7781512503836436, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.8450980400142568, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9030899869919435, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {0.9542425094393249, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.3010299956639813`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.4771212547196624`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6020599913279623`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.6989700043360187`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.7781512503836436`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.845098040014257, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.9030899869919435`, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}, {1.954242509439325, 
           FormBox[
            TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.00375, 0.}, {
           
            Thickness[0.001]}}}}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-1.3010299956639813`, 
       1.6020599913279623`}, {-262.84309238864216`, 0.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{{{-1., 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {1., 
          FormBox["10", TraditionalForm]}, {2., 
          FormBox["100", TraditionalForm]}, {-0.6989700043360187, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5228787452803375, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3979400086720376, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2218487496163563, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.1549019599857432, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.09691001300805639, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.04575749056067506, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.3010299956639812, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.47712125471966244`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6020599913279624, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6989700043360189, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.7781512503836436, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.8450980400142568, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9030899869919435, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.9542425094393249, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3010299956639813`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.4771212547196624`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6020599913279623`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6989700043360187`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.7781512503836436`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.845098040014257, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9030899869919435`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.954242509439325, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-300., 
          FormBox[
           RowBox[{"-", "300"}], TraditionalForm]}, {-250., 
          FormBox[
           RowBox[{"-", "250"}], TraditionalForm]}, {-200., 
          FormBox[
           RowBox[{"-", "200"}], TraditionalForm]}, {-150., 
          FormBox[
           RowBox[{"-", "150"}], TraditionalForm]}, {-100., 
          FormBox[
           RowBox[{"-", "100"}], TraditionalForm]}, {-50., 
          FormBox[
           RowBox[{"-", "50"}], TraditionalForm]}, {0., 
          FormBox["0", TraditionalForm]}, {-300., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-290., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-280., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-270., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-260., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-250., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-250., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-240., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-230., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-220., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-210., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-200., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-190., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-180., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-170., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-160., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-150., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-150., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-140., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-130., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-120., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-110., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-100., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-90., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-80., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-70., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-60., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-50., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-40., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-30., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-20., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-10., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {0., 
          FormBox["\"\"", TraditionalForm], {0.005, 0.}, {
           AbsoluteThickness[0.1]}}, {-131.42154619432108`, 
          FormBox[
           StyleBox["\"9999\"", ShowContents -> False, StripOnInput -> False],
            TraditionalForm], 0}}}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.7933254224248962`*^9, 3.79332543610791*^9}, 
   3.793848462575344*^9, 3.8232278074816093`*^9, 3.823227839797349*^9},
 CellLabel->
  "Out[1958]=",ExpressionUUID->"59f626a2-6d29-4c07-b3ba-23072bb109d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u0", " ", "=", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", " ", 
      RowBox[{"0", 
       RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], 
    RowBox[{"UnitStep", "[", "t", "]"}]}]}], ";", "        ", 
  RowBox[{"tmax", "=", "15"}], ";", "        ", 
  RowBox[{"trange", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y0", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{
     RowBox[{"TransferFunctionModel", "[", 
      RowBox[{"G0mp", ",", "s"}], "]"}], ",", "u0", ",", "trange"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y1", "=", 
    RowBox[{"OutputResponse", "[", 
     RowBox[{
      RowBox[{"TransferFunctionModel", "[", 
       RowBox[{"G0", ",", "s"}], "]"}], ",", "u0", ",", "trange"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y0", ",", "y1", ",", "1"}], "}"}], ",", "trange", ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.2"}], ",", "1"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{",", ",", 
        RowBox[{"{", 
         RowBox[{"Dashed", ",", "Thin", ",", "Black"}], "}"}]}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"RootLocusPlot", "[", 
    RowBox[{"KG0", ",", 
     RowBox[{"{", 
      RowBox[{"Kp", ",", "0", ",", "14"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{"p1", ",", "p2"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.7569997894924717`*^9, 3.756999938325718*^9}, {
  3.756999970265315*^9, 3.757000006794669*^9}, {3.793325328934111*^9, 
  3.793325347307796*^9}, {3.793325399485319*^9, 3.793325432023581*^9}},
 CellLabel->
  "In[1959]:=",ExpressionUUID->"188c09e8-31c3-4d6d-adfa-23bb27fd0bad"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwd13c8Vf8bAHAhK3vvcXFxLyUlKfk8VLJCRUZCSkMZSWRUMoqSaJFkhYai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           "]]},
         Annotation[#, "Charting`Private`Tag$728368#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwd1nk4VO8XAHDZCdn3fWdMiUpF3oNS6KsShYSUpWQrEakkRCRJi1JRkpDQ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           "]]},
         Annotation[#, "Charting`Private`Tag$728368#2"]& ], 
        TagBox[
         {GrayLevel[0], Thickness[Tiny], Opacity[1.], Dashing[{Small, Small}],
           LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/e3eySMq3VPsGMDgg72byqu7H68fsofxf143n/rh
+iU4/7Dz8iUXFz2G82Xu73yWpPMWzhfJiV/F7vwZzp9k6LbbL/QHnH9zhsGB
jwJ/4fzuJfXnmSQZHWB88SmPOyfPZYbz20M87S59Y4Xziy0Xxp9s4oDzXd7/
qsp7zAXnN9oEJkpZ8ML5Vutmbqnbzw/n5/z42HCCVxDO/6ktcE83VAjOt1m9
ZsG0acJw/kchr4SwQyJw/pOehLAidjE43/N9uedTM3E4/00yR/GWegk4301F
nKn9kCScL3RWrW/Deyk4X6ZjfYCZmQycP0PbUkA4XRbOPyXlaPp5ohzCPzKH
Juhfk4fz+ZgXlSQ2KcD5co3yNpFqinA+p2rMtqDjCL6ereT68lglOL/ontBh
LwZlOP/9555QzxkIvrv+sVmeuipw/r7P1r+/n0Pw83SMbl1MVYXzbd+lXInk
VIPzXVUkfHkXIfgaDV0Vh8zV4XytVMv9qrcQ/NR9GS1bCjXg/P0LrqR8FNWE
87+s+P9dfzuCn6y6mnOWrxac/1FrstmmDwj+jiW/H37t0Ibzo1yUHazldOB8
6dz2nXoHEHxRrpyNvuG6cP4t68mXl61G8Ofl7vr6/z+CDwBPk/D7
           "]]},
         Annotation[#, "Charting`Private`Tag$728368#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{16.1530612244898, 1.4999999999999432`}, {7.5, 
       6.500000000000014}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 14.999999693877552`}, {-0.2, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], {186.43920553063444, -116.18010788521644},
      ImageScaled[{0.5, 0.5}], {353.06413466753384, 221.29544359088845}], 
    InsetBox[
     GraphicsBox[{{{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJxM2Xc8le//OPBjxxGyKhRlJBEtIbruluxRkSKijJZVRhmZiWSUIoSUMrJF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            "]]},
          Annotation[#, "Charting`Private`Tag$729987#1"]& ], 
         TagBox[
          {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
           Opacity[1.], LineBox[CompressedData["
1:eJxM2Xc8lt//OPDbjlsqqxJRRjKiJUTX1ZItFQmllNE0ygqVUJGMUoQQyR4h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            "]]},
          Annotation[#, "Charting`Private`Tag$729987#2"]& ]}, {}}, {{}, {{
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.012833333333333334`], AbsoluteThickness[1.6], 
           GeometricTransformationBox[InsetBox[
             FormBox[
              StyleBox[
               GraphicsBox[
                {GrayLevel[0], Thickness[0.25], LineBox[{{0, 1}, {1, 0}}], 
                 LineBox[{{0, 0}, {1, 1}}]},
                ImageSize->{8., Automatic}],
               StripOnInput->False,
               GraphicsBoxOptions->{DefaultBaseStyle->Directive[
                 PointSize[0.012833333333333334`], 
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 AbsoluteThickness[1.6]]}],
              TraditionalForm], {0., 0.}], {{{-2., 0.}}, {{-1., 0.}}}]}, 
          {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
           0.012833333333333334`], AbsoluteThickness[1.6], 
           GeometricTransformationBox[InsetBox[
             FormBox[
              StyleBox[
               GraphicsBox[
                {GrayLevel[0], DiskBox[{0, 0}]},
                ImageSize->{7, Automatic}],
               StripOnInput->False,
               GraphicsBoxOptions->{DefaultBaseStyle->Directive[
                 PointSize[0.012833333333333334`], 
                 RGBColor[0.880722, 0.611041, 0.142051], 
                 AbsoluteThickness[1.6]]}],
              TraditionalForm], {0., 0.}], {{{2., 3.4641015567674573`}}, {{
            2., -3.4641015567674573`}}}]}, 
          {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
           0.012833333333333334`], AbsoluteThickness[1.6], 
           GeometricTransformationBox[InsetBox[
             FormBox[
              StyleBox[
               GraphicsBox[
                {GrayLevel[0], CircleBox[{0, 0}]},
                ImageSize->{7, Automatic}],
               StripOnInput->False,
               GraphicsBoxOptions->{DefaultBaseStyle->Directive[
                 PointSize[0.012833333333333334`], 
                 RGBColor[0.560181, 0.691569, 0.194885], 
                 AbsoluteThickness[1.6]]}],
              TraditionalForm], {0., 0.}], {{{2., 0.}}, {{2., 0.}}}]}}, {
          TagBox[
           TooltipBox[
            {Opacity[0.], PointBox[{{-2., 0.}}]},
            RowBox[{"Kp", "\[Equal]", "0"}]],
           Annotation[#, $CellContext`Kp == 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            {Opacity[0.], PointBox[{{-1., 0.}}]},
            RowBox[{"Kp", "\[Equal]", "0"}]],
           Annotation[#, $CellContext`Kp == 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            {Opacity[0.], PointBox[{{2., 3.4641015567674573`}}]},
            RowBox[{"Kp", "\[Equal]", "7.`"}]],
           Annotation[#, $CellContext`Kp == 7., "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            {Opacity[0.], PointBox[{{2., -3.4641015567674573`}}]},
            RowBox[{"Kp", "\[Equal]", "7.`"}]],
           Annotation[#, $CellContext`Kp == 7., "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            {Opacity[0.], PointBox[{{2., 0.}}]},
            RowBox[{"Kp", "\[Equal]", "\[Infinity]"}]],
           
           Annotation[#, $CellContext`Kp == DirectedInfinity[1], 
            "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            {Opacity[0.], PointBox[{{2., 0.}}]},
            RowBox[{"Kp", "\[Equal]", "\[Infinity]"}]],
           
           Annotation[#, $CellContext`Kp == DirectedInfinity[1], 
            "Tooltip"]& ]}}, {{}, {}}}},
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{0.5, 1.5}, {7.5, 6.500000000000014}},
      Method->{"ScalingFunctions" -> None},
      PlotRange->{{-2., 5.999999759080325}, {-3.46410155674292, 
       3.46410155674292}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{Automatic, Automatic}], {503.46762783039486, -116.18010788521644},
      ImageScaled[{0.5, 0.5}], {241.36415714451704, 221.29544359088845}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[312]},
  PlotRange->{{0, 634.0568445995209}, {-232.3602157704329, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.756999822042206*^9, 3.756999834861513*^9}, {
   3.756999882928472*^9, 3.756999906039715*^9}, 3.756999938755713*^9, {
   3.756999971012576*^9, 3.757000007266172*^9}, 3.7570003054535933`*^9, 
   3.757000410705965*^9, 3.757001868667981*^9, {3.79332530262116*^9, 
   3.7933254365426617`*^9}, 3.7938484630572*^9, 3.823227808128677*^9, 
   3.823227840364264*^9},
 CellLabel->
  "Out[1964]=",ExpressionUUID->"7ab34af2-4868-4d50-ba89-b8f5656c54ce"]
}, Open  ]],

Cell["Investigate root locus numerically, then analytically", "Text",
 CellChangeTimes->{{3.7570010198121347`*^9, 3.7570010325148087`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"223c84b8-1aff-4ef1-b3b2-6f723d8317f2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T0", "=", 
  RowBox[{
   FractionBox[
    RowBox[{"K0", " ", "G0"}], 
    RowBox[{"1", "+", 
     RowBox[{"K0", " ", "G0"}]}]], "//", "Simplify"}]}]], "Input",
 CellLabel->
  "In[1965]:=",ExpressionUUID->"c7a89742-d568-4e4f-bbd5-ea3154531730"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"Kp", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "s"}], ")"}]}], 
   RowBox[{"2", "-", 
    RowBox[{"Kp", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "s"}], ")"}]}], "+", 
    RowBox[{"3", " ", "s"}], "+", 
    SuperscriptBox["s", "2"]}]]}]], "Output",
 CellChangeTimes->{
  3.757001093722259*^9, 3.7570018693308887`*^9, {3.7933253029490623`*^9, 
   3.79332532050305*^9}, 3.7933253741492023`*^9, 3.793325436590199*^9, 
   3.7938484631045837`*^9, 3.8232278082813063`*^9, 3.8232278404596167`*^9},
 CellLabel->
  "Out[1965]=",ExpressionUUID->"8b457849-04cb-492d-b514-31c5ced98f11"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"den", "=", 
  RowBox[{"Denominator", "[", "T0", "]"}]}]], "Input",
 CellChangeTimes->{{3.7570010519256563`*^9, 3.757001065934354*^9}, {
  3.7570011007790318`*^9, 3.7570011097136497`*^9}, {3.757001396230216*^9, 
  3.757001396540173*^9}},
 CellLabel->
  "In[1966]:=",ExpressionUUID->"aabc7aac-f363-47a4-8cf4-08dc0487745f"],

Cell[BoxData[
 RowBox[{"2", "-", 
  RowBox[{"Kp", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "s"}], ")"}]}], "+", 
  RowBox[{"3", " ", "s"}], "+", 
  SuperscriptBox["s", "2"]}]], "Output",
 CellChangeTimes->{{3.757001058533095*^9, 3.757001066398815*^9}, 
   3.757001107569833*^9, 3.757001397190517*^9, 3.75700186942894*^9, {
   3.793325302956417*^9, 3.793325320509651*^9}, 3.7933253741560173`*^9, 
   3.793325436597398*^9, 3.79384846311094*^9, 3.823227808288365*^9, 
   3.823227840466536*^9},
 CellLabel->
  "Out[1966]=",ExpressionUUID->"4210a68c-582c-41ee-b47c-96aeecf0c45c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"s", "/.", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"den", "\[Equal]", "0"}], ",", "s"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.75700140807132*^9, 3.757001422777631*^9}},
 CellLabel->
  "In[1967]:=",ExpressionUUID->"45fbfb46-fa09-495d-9bce-9f5f5108fad2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "Kp", "-", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"14", " ", "Kp"}], "+", 
        SuperscriptBox["Kp", "2"]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "Kp", "+", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"14", " ", "Kp"}], "+", 
        SuperscriptBox["Kp", "2"]}]]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7933253029952183`*^9, 3.793325320547357*^9}, 
   3.793325374162881*^9, 3.793325436635248*^9, 3.793848463144137*^9, 
   3.823227808317954*^9, 3.8232278404836273`*^9},
 CellLabel->
  "Out[1967]=",ExpressionUUID->"d91e0816-8c57-4845-8941-5bd3ac4a8614"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "Kp", "-", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"14", " ", "Kp"}], "+", 
        SuperscriptBox["Kp", "2"]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "Kp", "+", "c"}], ")"}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.757002958485238*^9, 3.757002958512141*^9}},
 CellLabel->
  "In[1968]:=",ExpressionUUID->"4083fca0-20c7-4042-94cf-fd67f1b0d7b7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "Kp", "-", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"14", " ", "Kp"}], "+", 
        SuperscriptBox["Kp", "2"]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "c", "+", "Kp"}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.793325303002046*^9, 3.7933253205540333`*^9}, 
   3.7933253741695433`*^9, 3.793325436641666*^9, 3.793848463149869*^9, 
   3.823227808324383*^9, 3.823227840489913*^9},
 CellLabel->
  "Out[1968]=",ExpressionUUID->"d8572a5e-091e-4fc5-ade6-630ff010e8bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"14", " ", "Kp"}], "+", 
     SuperscriptBox["Kp", "2"]}], "\[Equal]", "0"}], ",", "Kp"}], 
  "]"}]], "Input",
 CellLabel->
  "In[1969]:=",ExpressionUUID->"5ff19088-75e1-4f95-ab45-59d4b2935243"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Kp", "\[Rule]", 
     RowBox[{"7", "-", 
      RowBox[{"4", " ", 
       SqrtBox["3"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Kp", "\[Rule]", 
     RowBox[{"7", "+", 
      RowBox[{"4", " ", 
       SqrtBox["3"]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.757003556101206*^9, {3.793325303038979*^9, 3.79332532056004*^9}, 
   3.793325374210841*^9, 3.793325436679511*^9, 3.793848463183049*^9, 
   3.8232278083523283`*^9, 3.82322784050842*^9},
 CellLabel->
  "Out[1969]=",ExpressionUUID->"ea966bd9-df3a-4db5-85d2-100266f09263"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k1", "=", 
    RowBox[{"Kp", "/.", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"sol", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
        RowBox[{"sol", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", "Kp"}], "]"}]}]}], ",", 
   RowBox[{"k1", "//", "N"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.757001425111442*^9, 3.757001477479186*^9}, {
  3.7570015293438253`*^9, 3.75700153034166*^9}},
 CellLabel->
  "In[1970]:=",ExpressionUUID->"6992eef5-ec77-4545-8a3b-312c8d357105"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"7", "-", 
      RowBox[{"4", " ", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"7", "+", 
      RowBox[{"4", " ", 
       SqrtBox["3"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.07179676972449123`", ",", "13.928203230275509`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.757001427124589*^9, 3.757001430377142*^9}, {
   3.757001466654784*^9, 3.757001478043325*^9}, 3.7570015307171993`*^9, 
   3.757001869630459*^9, {3.793325303045794*^9, 3.793325320597077*^9}, 
   3.7933253742480583`*^9, 3.7933254366863947`*^9, 3.7938484631906424`*^9, 
   3.823227808380772*^9, 3.8232278405183887`*^9},
 CellLabel->
  "Out[1970]=",ExpressionUUID->"2c3cdabd-869c-43e3-ad25-652b90f213c9"]
}, Open  ]],

Cell[TextData[StyleBox["by eye, it is clear that Kp=3 makes Re[s]==0",
 FontColor->RGBColor[0.6, 0.4, 0.2]]], "Text",
 CellChangeTimes->{{3.7570018092451468`*^9, 3.7570018312000313`*^9}},
 FontSize->16,ExpressionUUID->"37fb5c17-fd6e-40f9-b8f8-e6409a5b36eb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "/.", 
  RowBox[{"Kp", "\[Rule]", "3"}]}]], "Input",
 CellChangeTimes->{{3.757001506504924*^9, 3.75700160369119*^9}, {
  3.75700169646115*^9, 3.7570017368450127`*^9}},
 CellLabel->
  "In[1971]:=",ExpressionUUID->"96e36a02-441b-44fc-a8bb-2c85c7d9c5d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"]}], ",", 
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.757001589906658*^9, 3.7570016043011208`*^9}, 
   3.757001737304048*^9, {3.75700186339111*^9, 3.757001869785945*^9}, {
   3.793325303082778*^9, 3.793325320603715*^9}, 3.7933253743713408`*^9, 
   3.793325436723069*^9, 3.793848463226467*^9, 3.8232278083873777`*^9, 
   3.823227840534884*^9},
 CellLabel->
  "Out[1971]=",ExpressionUUID->"c54761bf-e13f-434b-b8b6-d6f10cda5f3b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ssol", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"sol", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "/.", 
      RowBox[{"Kp", "\[Rule]", "k1"}]}], "//", "Simplify"}]}], ",", 
   RowBox[{"ssol", "//", "N"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.7570019307806177`*^9, 3.757002036824832*^9}},
 CellLabel->
  "In[1972]:=",ExpressionUUID->"83c1f585-92e9-48c1-ae15-85f6773922e2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "-", 
      RowBox[{"2", " ", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["3"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4641016151377544`"}], ",", "5.464101615137754`"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.757001931810364*^9, 3.757002037197589*^9}, {
   3.793325303094899*^9, 3.793325320610099*^9}, 3.793325374379068*^9, 
   3.793325436729786*^9, 3.7938484633270893`*^9, 3.8232278084176407`*^9, 
   3.8232278405402317`*^9},
 CellLabel->
  "Out[1972]=",ExpressionUUID->"914bdbc2-5246-4750-aa66-b6d9091acefe"]
}, Open  ]],

Cell[TextData[{
 StyleBox["check that locus is a circle centered on s=2  2Re[s]=Kp-3, 2Im[s]= \
",
  FontColor->RGBColor[0.6, 0.4, 0.2]],
 Cell[BoxData[
  SqrtBox[
   RowBox[{"1", "-", 
    RowBox[{"14", " ", "Kp"}], "+", 
    SuperscriptBox["Kp", "2"]}]]],
  CellChangeTimes->{{3.7570014146179132`*^9, 3.757001423146667*^9}, 
    3.757001869529892*^9},ExpressionUUID->
  "dd7331f6-d691-42e2-8fbb-4019c8947ba0"]
}], "Text",
 CellChangeTimes->{{3.7570018092451468`*^9, 3.7570018312000313`*^9}, {
  3.757002900648636*^9, 3.757002940636428*^9}},
 FontSize->16,ExpressionUUID->"eec5d856-b0fb-4692-ad66-028dcd463456"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{
    FractionBox["1", "4"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"Kp", "-", "3", "-", "4"}], ")"}], "2"], "-", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"14", " ", "Kp"}], "+", 
        SuperscriptBox["Kp", "2"]}], ")"}]}], ")"}]}]], "//", "Simplify", 
  "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"radius", " ", "of", " ", "circle"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.7570029530539*^9, 3.75700298686051*^9}, {
  3.7570033194129467`*^9, 3.757003524555038*^9}},
 CellLabel->
  "In[1973]:=",ExpressionUUID->"53b7fd7c-5c28-4b5a-8f24-81717b3b7467"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox["3"]}]], "Output",
 CellChangeTimes->{{3.7570029733784924`*^9, 3.757002987200898*^9}, {
   3.7570033311803007`*^9, 3.757003399289686*^9}, {3.757003441580049*^9, 
   3.757003526420924*^9}, {3.7933253031318007`*^9, 3.793325320646344*^9}, 
   3.7933253744185963`*^9, 3.793325436765491*^9, 3.793848463332672*^9, 
   3.823227808423855*^9, 3.823227840564608*^9},
 CellLabel->
  "Out[1973]=",ExpressionUUID->"454aad7f-be51-4280-ae78-8d9f7cf5709a"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 755},
WindowMargins->{{112, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"ad137491-ab72-40aa-b028-c583989311ca"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 363, 7, 67, "Section",ExpressionUUID->"90372875-bdc4-460c-a8d8-65809edc93ea"],
Cell[946, 31, 157, 3, 30, "Input",ExpressionUUID->"e1da7b9a-8fa3-42ec-8763-f3a2825c2727"],
Cell[1106, 36, 915, 23, 62, "Input",ExpressionUUID->"6ab4e372-bc94-4de1-977d-9636cb717006"],
Cell[CellGroupData[{
Cell[2046, 63, 362, 8, 30, "Input",ExpressionUUID->"a529adff-c86f-42e3-9a35-91c254770337"],
Cell[2411, 73, 63417, 1247, 253, "Output",ExpressionUUID->"59f626a2-6d29-4c07-b3ba-23072bb109d6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65865, 1325, 2068, 59, 178, "Input",ExpressionUUID->"188c09e8-31c3-4d6d-adfa-23bb27fd0bad"],
Cell[67936, 1386, 88775, 1510, 242, "Output",ExpressionUUID->"7ab34af2-4868-4d50-ba89-b8f5656c54ce"]
}, Open  ]],
Cell[156726, 2899, 242, 4, 52, "Text",ExpressionUUID->"223c84b8-1aff-4ef1-b3b2-6f723d8317f2"],
Cell[CellGroupData[{
Cell[156993, 2907, 267, 8, 48, "Input",ExpressionUUID->"c7a89742-d568-4e4f-bbd5-ea3154531730"],
Cell[157263, 2917, 687, 19, 54, "Output",ExpressionUUID->"8b457849-04cb-492d-b514-31c5ced98f11"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157987, 2941, 344, 7, 30, "Input",ExpressionUUID->"aabc7aac-f363-47a4-8cf4-08dc0487745f"],
Cell[158334, 2950, 599, 14, 34, "Output",ExpressionUUID->"4210a68c-582c-41ee-b47c-96aeecf0c45c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[158970, 2969, 317, 8, 30, "Input",ExpressionUUID->"45fbfb46-fa09-495d-9bce-9f5f5108fad2"],
Cell[159290, 2979, 839, 25, 50, "Output",ExpressionUUID->"d91e0816-8c57-4845-8941-5bd3ac4a8614"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160166, 3009, 600, 19, 47, "Input",ExpressionUUID->"4083fca0-20c7-4042-94cf-fd67f1b0d7b7"],
Cell[160769, 3030, 723, 21, 50, "Output",ExpressionUUID->"d8572a5e-091e-4fc5-ade6-630ff010e8bd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[161529, 3056, 291, 9, 33, "Input",ExpressionUUID->"5ff19088-75e1-4f95-ab45-59d4b2935243"],
Cell[161823, 3067, 618, 18, 38, "Output",ExpressionUUID->"ea966bd9-df3a-4db5-85d2-100266f09263"]
}, Open  ]],
Cell[CellGroupData[{
Cell[162478, 3090, 580, 16, 30, "Input",ExpressionUUID->"6992eef5-ec77-4545-8a3b-312c8d357105"],
Cell[163061, 3108, 773, 20, 38, "Output",ExpressionUUID->"2c3cdabd-869c-43e3-ad25-652b90f213c9"]
}, Open  ]],
Cell[163849, 3131, 257, 3, 36, "Text",ExpressionUUID->"37fb5c17-fd6e-40f9-b8f8-e6409a5b36eb"],
Cell[CellGroupData[{
Cell[164131, 3138, 281, 6, 30, "Input",ExpressionUUID->"96e36a02-441b-44fc-a8bb-2c85c7d9c5d0"],
Cell[164415, 3146, 608, 14, 38, "Output",ExpressionUUID->"c54761bf-e13f-434b-b8b6-d6f10cda5f3b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[165060, 3165, 436, 12, 30, "Input",ExpressionUUID->"83c1f585-92e9-48c1-ae15-85f6773922e2"],
Cell[165499, 3179, 725, 21, 38, "Output",ExpressionUUID->"914bdbc2-5246-4750-aa66-b6d9091acefe"]
}, Open  ]],
Cell[166239, 3203, 612, 15, 40, "Text",ExpressionUUID->"eec5d856-b0fb-4692-ad66-028dcd463456"],
Cell[CellGroupData[{
Cell[166876, 3222, 677, 20, 53, "Input",ExpressionUUID->"53b7fd7c-5c28-4b5a-8f24-81717b3b7467"],
Cell[167556, 3244, 484, 9, 58, "Output",ExpressionUUID->"454aad7f-be51-4280-ae78-8d9f7cf5709a"]
}, Open  ]]
}, Open  ]]
}
]
*)

