(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     58254,       1151]
NotebookOptionsPosition[     56786,       1117]
NotebookOutlinePosition[     57183,       1133]
CellTagsIndexPosition[     57140,       1130]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Oscillator decay time (Prob. 2.3)", "Section",
 CellChangeTimes->{{3.510432288913591*^9, 3.5104322948525543`*^9}, {
  3.5105367736963882`*^9, 3.51053678500532*^9}, {3.510539713993991*^9, 
  3.510539714456819*^9}, {3.512583743179525*^9, 3.5125837533268957`*^9}, {
  3.6762455646348352`*^9, 3.676245568192129*^9}, {3.6766875416445303`*^9, 
  3.67668754786917*^9}, {3.676688867450783*^9, 3.676688867752162*^9}, {
  3.793241470737341*^9, 
  3.793241478186871*^9}},ExpressionUUID->"d8898ac9-5d04-4860-bec1-\
0167408970f4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.67668755119268*^9, 3.676687597860859*^9}, {
  3.676687888109214*^9, 3.6766879370506887`*^9}, {3.676687968634591*^9, 
  3.676688100020545*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"76829575-776e-4c21-ab38-badb1485f56f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"Re", "[", 
    RowBox[{"\[Zeta]", "+", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["\[Zeta]", "2"], "-", "1"}]]}], "]"}]}], ";", 
  RowBox[{"dp", "=", 
   FractionBox["1", "sp"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sm", "=", 
   RowBox[{"Re", "[", 
    RowBox[{"\[Zeta]", "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["\[Zeta]", "2"], "-", "1"}]]}], "]"}]}], ";", 
  RowBox[{"dm", "=", 
   FractionBox["1", "sm"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", " ", "[", 
  RowBox[{
   RowBox[{"{", "dm", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Zeta]", ",", "0.1", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.676688116629423*^9, 3.676688119858877*^9}, {
  3.6766881590279903`*^9, 3.676688391254188*^9}, {3.676688425729609*^9, 
  3.676688522421782*^9}, {3.676692883907584*^9, 3.676692888912305*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"1002122c-4aca-48c2-8730-4743278f615f"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwdxQ8403kcwPExY8xa6lqenJGni8zTzd+U8fmeVidSOVyTPPpDRGyaFJae
Qvp7cpILIe5BqTTKlev6c8jp4rYxY8iwpDv2+/of5XZ/3s/zet6rDwi+idQn
kUi7/vXfnzuNiVfpSYH0f0sR3zmht9VOCnVVlU6bahgoNzuVauYshXDfRo1V
IQO1/5XpyveUwh4+zdgqi4F4PxZkjwRIwU0ofxcdzkCcFU2byalSoNUFdX1h
xkBGc8w73DYp+JEjaz9PXoLqG56IaxJkwE62de8KoaMJZsut2VQZRKpZXnk+
dOQgknV5npXBqUXO6egNdFTGHuG8LpABy6qX47eCji4XMd6ONspA5SyJWpSZ
ooi0A/42TDn4tQX8OrfDFC33prLyGuSgfpX2W9S3NOTTd6bOoUkOux0SKuJ9
aEictOjT1CaHuHsjzembaEhze1I0pZaDsERwtJtFQ/XL+1sDjDrAtprFXjdq
gvhvJceWBHVAceIRIvikCSo6F9qWNd4BT8i3CgIlxmjtH/fEKdYKSHwUOWvC
paK7Q2FVA/YKUByNdl7DoSKXWdNOnqsCxt45WGxbQ0WbLWPZDF8F2Bwprnho
SkX7Ym1V5SIFaAdUipVvjFChUemGtpcKyLcY4U2eMUJLUc6kVVwXhNR6rczt
NEQf74uimx8r4dG4OTP1KgUVxHbSFhqV0MfbXu92kYLc17rWrG9XQnp/sc/C
aQpKKpydyR9Swl22ZtV1AQXhzOT0GFo39JDP7XXxoyDNnlPFjLBuCLXkPu8m
U1C7wcXOEFIPKPomJPkpBugmvwxpt6rgTkSt+XIxGbkHiLaLdqmgZJ8o2/AY
GUm38fgfQlTwmGPA0sWREcljRKAfpwIX45wjunAy2mdpX8LMVUH44Sk3Lo+M
rIcki14DKkiUGClv0smoNPZFQ/bxXigze5I8X66PStLULo5VfRAUO+Ql79dD
4fPc+h7uAFAsGn6aPkhCHsmd69rlaggu6yg3FPwNNfxn8Sy9IbD56HJNX/gJ
Mg5sTFm9bRiixG61uy8twFn2z7mOqRoI23H70w3dB3jPei2afvkWfmC2j7ac
mQOXGTPfCtN38JUEK6+4zUL1hfD1kdxRuHo9U8m2noF0X25PV+Z7mLN1XCVm
TENWq/X3wY//hFcllsdv2U3B2NGrZlmGY9DkvuyrId4kbNJxsyr9x2F4nGKI
T0zAA99xE0WaFqiH6YMrXmG45MO8RMrQQra5Z51nC4aDW4HucF4LgR661ENN
GJZ55zDSc7Ug/24r0fAUg3Cj62eOVVrYL92yU1CHgW130vKyTAujLzzOU25g
KKPQOVvWEHAiIDFfI8SQQnaTCNcR8EtE/U77eAwBeuFOResJaK7IIISxGEiL
912m3AlQl84Pkw5hCJsO2njTnwC58EUuOxSD+XCR92ISAV77S6qrt2DA6uZG
OzEBIX3BlTpvDC1vtLyg0wRMf3khPQhhSFKhr6svEuA/WNtL8sDQKdP4hZQS
UNGgpzvIwZD93CH4YSsBAuuY2kALDBH9l03OtxNwIcZpYtAcg/uC9tneDgJm
y38fFzIxqJ0l9gb9BJzsXGmVY4bhwa5lauUgAUtfsgJtGBjOxYnyqkcIyCss
3vzAFAOn0pUUiAl4alPHVxlhMGi69nDtDAHX426I4ykYutVzMQvzBGS0V4eS
yRgUmoQo448ERFwZuJeqj+Efemdhnw==
       "]], LineBox[CompressedData["
1:eJwVkXk01XkAxZ8tiR+msaSo1HRO1qISGu63Y0QNE4pC2RUiTvvYzYgIQ0V4
KkLJJENKQqREFDMdS1ommilF8X2bx7P8xvxxz/3nnvO553x0/cJdAqU5HI7L
fP7vbMbOIUqaIn+rU4N6FoWavnVhyQKKLD2DJ7KUIvbeWKSyAsWN8OLkHC0e
Pm274npKkcLpo0znZmseXHp3rn/PUATsKpUEe/PQ4M9RdFClaPUM3akYy0Nm
vG/zCnWK4uqRxGt3eJAoL+amaFJEPUsst+vmIeBSy3GBFsWrwqbCh8M8mN9f
bdC2nOJarm3QgDofV+175Ex0Kbb0RatUGfCh1J84mL+a4vQPngoDhI9BwYfs
w2spLM1FPfuD+UgxKuNomFK4P+uyv1jDh7B+7+u4jRSHcoe0Djzhw2uHwt3P
ZhTvVtdx3vbzYXow5FDjFgpllQtpA1P8+R+GfQG2FOmyJ4rSLQXQV6v6/fZe
iozNMw6NVQJcuOqbpONJoW1c4vumSYC59Yt9k/dTMMKxH3ufC/DC8aiGpx/F
5dKAnz0+CxCZvClBOpTintuvbn3LheiQ1Lk5x1Es8V5+PiZRCAnfTaUygcLq
1XHppEwh9EcFbUqJFKduXZ47VSBE6msji/YzFA2tdaMra4TY3lC0DOcoikb8
/JPfC9EekzJoWErhEWBK1L4X4QnHPWRhJ8Vccfv77H9FaFkwGdOkwUNzkEqk
l6YY23RWFTjNe5y60nHaUleMzg0O94eW8eA8KxpUNhCjx6dwQkaXhwfb1AWF
1mIM37cPtzfggbVd4h8WKIZSeJ7PX5j3JmWd3lAlhlu/pc0/QTwM5Xd8emw7
iZHrMQvl63nQN76kMuY1hbK18ktdd/OxjtvXlW87jYvWLzOiJXyY8HKmT66b
haT1USz3kgC3ZivulE3MQWB4W9S8SYjciha+jR2HaOuNdDe9EsJZ1cfxpI4U
eSO7xqT1mAhnw9RTLQeliKpLJNOiOAF9fxlzE640ObZR0zG3cgLa48Yl3n4y
5PBE7bfH7cUoMed42WvJkjzHQiuDMTGYyvza/jeyxCMxbWz4zCR2fZXXtcqS
I78Znl9asHIKrno1WdvJAiIKHrqh1zqFQwdNnH1mFhBe0obmRi8JzL7IPjtc
Lk90LJ5bGMhNg9v1Uz03cCFp3JdgnFk2jYapmnhVbQUi8LYonyYz8Oev6DZr
VSAek+Yp5OMMHlaFDmRHLSJ7Ir4fPxs/i1TdB1mi7xRJu7vHn12ac5iOvulh
3aFIQl42qY3Wz+H2x5nqp9FK5KqZ3iDjyiJeru1L7SqGkPHYsro9LIR21RHc
NQx5e70nItCDRf+Bm59i1zJkiVa8VKM3C17t2xpbY4ZkTPetCg1hceXG9Qcv
LBgS2ZwY2BHHomx7CHfEiSEuOwZHkspZ1HG6s7+JYwiVNrttWjG/DworFiQw
JL3+bNTflSzaX+eX9iYypN1ws5LZHRYKwdXJeakMsVbJMPrQxCLDkzxamcMQ
/Z4tETa9LHYe2bDMqGJ+n5ZlPt7PIsw186jyHwwJtB3mcF+xKP+lrnm8miGF
d89l8d+xcO+Ms6i+xxCNvM/VRSMsdunalpo9ZkiNM6Icv7IIDAsr0WxjiPOi
bJupcRbqorjcyacMSYsiPU4iFicyjnjf757nb8wpmBGzsJf3MOW+mOd/GQ0o
k7CYTLGURPUy5EDpVqPdsyw6WjVr971kiIzXRRHLsjAMEgVZvWbIfzBgj78=

       "]]},
     Annotation[#, "Charting`Private`Tag$320945#1"]& ], {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 1.9999999612244899`}, {0, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.6766881845952168`*^9, 3.676688295429968*^9}, {
   3.676688325664042*^9, 3.6766883950646353`*^9}, {3.676688436396982*^9, 
   3.676688487499617*^9}, 3.6766885228085403`*^9, {3.676692884530702*^9, 
   3.676692889500868*^9}, 3.757132801006135*^9, 3.757132874032495*^9, 
   3.8231998994582367`*^9, 3.8231999771124153`*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"bb1aa746-c9e2-492a-a945-0171c9a78957"]
}, Open  ]],

Cell["\<\
Thus, the minimum decay time is given by critical damping.  Note the sharp \
increase (infinite derivative) of the decay time for \[Zeta] > 1.  It is then \
better to err, if need be, on the slightly underdamped side of the optimum.\
\>", "Text",
 CellChangeTimes->{{3.676688876349175*^9, 3.676688959952005*^9}},
 FontSize->16,ExpressionUUID->"02b2daae-4480-4f35-a494-7d9b0c3e3124"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ysol", "=", 
  RowBox[{
   RowBox[{"DSolveValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"y", "''"}], "[", "t", "]"}], "+", 
         RowBox[{"2", "\[Zeta]", " ", 
          RowBox[{
           RowBox[{"y", "'"}], "[", "t", "]"}]}], "+", 
         RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"y", "[", "t", "]"}], ",", "t"}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.6766894722598886`*^9, 3.6766895681409607`*^9}, {
  3.6766898400399446`*^9, 3.67668984302277*^9}},
 CellLabel->"In[92]:=",ExpressionUUID->"6aefa47e-ce20-40a4-9394-5d4e97868304"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "t"}], " ", 
     RowBox[{"(", 
      RowBox[{"\[Zeta]", "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[Zeta]", "2"]}]]}], ")"}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "t", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[Zeta]", "2"]}]]}]]}], ")"}], " ", "\[Zeta]"}], 
     "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "t", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[Zeta]", "2"]}]]}]]}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[Zeta]", "2"]}]]}]}], ")"}]}], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[Zeta]", "2"]}]]}]]], "Output",
 CellChangeTimes->{{3.676689526719081*^9, 3.676689568831049*^9}, 
   3.676689843482196*^9, 3.7571328011556*^9, 3.757132874146373*^9, 
   3.82319989957683*^9, 3.82319997717181*^9},
 CellLabel->"Out[92]=",ExpressionUUID->"053245d4-7ca1-4364-8bd1-47334af48ec7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ycrit", "=", 
   RowBox[{"Limit", "[", 
    RowBox[{"ysol", ",", 
     RowBox[{"\[Zeta]", "\[Rule]", "1"}]}], "]"}]}], ";", " ", 
  RowBox[{"dycrit", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"ycrit", ",", "t"}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"ycrit", ",", "dycrit"}], "}"}]}], "Input",
 CellChangeTimes->{{3.676689657956257*^9, 3.676689663384287*^9}, {
  3.676689701787321*^9, 3.676689737881832*^9}},
 CellLabel->"In[93]:=",ExpressionUUID->"a13bdf2a-2fc5-4770-b5aa-fdb94b107e7a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "t"}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "t"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "t"}]]}], " ", "t"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6766896646825657`*^9, {3.676689704578678*^9, 3.676689738384178*^9}, 
   3.757132803003023*^9, 3.757132875585787*^9, 3.823199900442666*^9, 
   3.82319997809097*^9},
 CellLabel->"Out[94]=",ExpressionUUID->"8a246b1d-e56f-4121-9741-17efe43e02eb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmax", "=", "25"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ysol", "/.", 
        RowBox[{"\[Zeta]", "\[Rule]", "0.2"}]}], ",", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[Zeta]"}], " ", "t"}]], "/.", 
        RowBox[{"\[Zeta]", "\[Rule]", "0.2"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Dashed"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"ycrit", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"ysol", "/.", 
      RowBox[{"\[Zeta]", "\[Rule]", "5"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsColumn", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.676689551110261*^9, 3.676689647192939*^9}, {
  3.6766898745008907`*^9, 3.676689972220394*^9}, {3.676690644107972*^9, 
  3.676690663061458*^9}, {3.6766907424431353`*^9, 3.6766909277890253`*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"422d325e-da85-4bef-8a91-2f83aee0f13b"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
          LineBox[CompressedData["
1:eJwVV3k81F8bRdmXZN8qW/YYhiHKfZIQEWkhREgiZcmSyD6islNJlkxRJAwK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           "]]},
         Annotation[#, "Charting`Private`Tag$321077#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwBUQSu+yFib1JlAgAAAEQAAAACAAAAF0tVOOl7/j9B8foHxODlP2Uv+g0x
DQBA1wiqOTFs5T9NKWXxFkcEQIPvhP5SRuM/stR9dck4CEAMoJNsAHfhPzsS
Kq8EfwxAP4axm8Fj3z9n+5KdpVgQQJS3aAxxQ9w/b8bnM69NEkAfTJVX7qDZ
P4paBiX9bBRA1JjxtWMM1z9jx3tmMWgWQOVa033l39Q/wQcZUWtZGEBwGMN9
VPHSPzERgJbpdBpA39oTTFsM0T9g8z0sTmwcQLgGOdFa584/oZ7FHPeNHkDF
nWcylcfLP7OOOtvSUiBAcRxNniEFyT90uj1QnUwhQKo1nC6tscY/v8ql8olb
IkAWdrlqQWrEP2lHOb1pWCNAqLz9brB+wj+cqDG1a2okQOLmHhUYnsA/kfO9
gXB3JUA7C6zVeeu9P+aqdXZociZAcyP/FDcguz/ERpKYgoInQOhK0+/8Y7g/
AU/a4o+AKECGf1hQGBa2PwBBtgGgeSlAHqirN+sJtD+IF/dN0ocqQCnIua0S
CLI/cFpjwveDK0A+1q96FlewP+GBNGQ/lSxAHRsMihpfrT8Uk5naiaEtQNWP
YNr6cqo/phAqecebLkDLKs9Kb/ynP8FyH0Unqy9AnqJg5NOSpT+eIKAcPVQw
QPCb5c18iqM/vXz6AGjQMEBAmFLFAryhPyFLB/wjVzFA4A9Z1NTsnz+0zymL
2dQxQC/XSI1U8Jw/jMb+MCBdMkCJ09UXIgSaP5Nz6Wpg3DJAaHdNmt2Nlz98
FR4PIlkzQNnDdznkXZU/qSkFynTgM0CWh7h/IDmTPwb0ARnBXjRA8oC8i75q
kT+nMLF+nuc0QIZ+HzAwTY8/KWKqTv1tNUBpsroNoy6MP9tJubJV6zVAB30Y
cqCNiT/So3otP3M2QDzcVEWi+oY/+LNRPCLyNkDxEIk1dc+EP/+4crWGbjdA
869CnBbigj9LMEZFfPU3QJ/FD+JY/oA/x10vaWtzOEDlV8snbs1+PxJjaLud
dThA2RNk8+i/fj9eaKEN0Hc4QDG/PK5psn4/9nITsjR8OEDnnUPnfJd+PySI
9/r9hDhABnv/Hephfj+Asr+MkJY4QBo/qVzd930/OgdQsLW5OEB8/4hNFSh9
P4YMiQLouzhAlTf5CkkbfT/REcJUGr44QF2Le2aCDn0/aBw0+X7COECXt9rt
BfV8P5cxGEJIyzhA6P88+U/CfD/0W+DT2tw4QAXU5t/tXXw/QGEZJg3fOEB0
2vBYelF8P4tmUng/4ThApkYaSQxFfD8iccQcpOU4QFjcM4VALHw/UYaoZW3u
OEDQsJgp6vp7P5yL4bef8DhACjOtGKLuez/okBoK0vI4QEd6zWtf4ns/gJuM
rjb3OEDkXrs06sl7P8ygxQBp+ThAAJjQpbe9ez8Xpv5Sm/s4QNHMgHGKsXs/
Yqs3pc39OEBaYXKVYqV7P66wcPf//zhAxMFMD0CZez+i3fgg
           "]]},
         Annotation[#, "Charting`Private`Tag$321077#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{16.153061224489797`, 1.5}, {1.5, 0.4999999999999716}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 25}, {-0.5266176750604854, 0.6836872249473701}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {125.54138617877139, -74.7672323229391},
      ImageScaled[{0.5, 0.5}], {239.12644986432645, 138.87808178303385}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVlnc8F84fxxFCZG/Ze3/4fPhk3L2tiBIZ2ZSREckoKylKRlaSbIWQCiFZ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           "]]},
         Annotation[#, "Charting`Private`Tag$321124#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{16.153061224489797`, 1.5}, {6.3893654482480144`, 
       0.5000000000000142}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 25}, {0., 0.17059758240473163`}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {125.54138617877139, -226.7463796929413},
      ImageScaled[{0.5, 0.5}], {239.12644986432645, 143.7674472312819}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVU3s41HkfRUW7SzWSKElUa1TbzBr6vcLnW7tTbbmFrMuqjSZjqVxLSMLq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           "]]},
         Annotation[#, "Charting`Private`Tag$321170#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{16.153061224489797`, 1.5}, {6.231703716424022, 
       0.5000000000000284}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0, 25}, {0., 0.9999999999998699}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {125.54138617877139, -381.0913789211555},
      ImageScaled[{0.5, 0.5}], {239.12644986432645, 143.60978549945793}]}, {}},
  ImageSize->Medium,
  PlotRange->{{0, 251.08277235754278`}, {-458.2244631023067, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.676689949581905*^9, 3.676689972807637*^9}, {
   3.676690647116199*^9, 3.676690663723648*^9}, {3.6766907678293943`*^9, 
   3.676690818419612*^9}, {3.676690862024494*^9, 3.676690928441378*^9}, 
   3.757132801390852*^9, 3.7571328759176407`*^9, 3.8231999006626253`*^9, 
   3.823199978290176*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"fb224ac9-bd27-453e-b2af-083927a71b83"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 175}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"6843f33e-7b5b-4ee7-b908-3168dd1c8ab6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 523, 8, 67, "Section",ExpressionUUID->"d8898ac9-5d04-4860-bec1-0167408970f4"],
Cell[1106, 32, 335, 6, 30, "Input",ExpressionUUID->"76829575-776e-4c21-ab38-badb1485f56f"],
Cell[CellGroupData[{
Cell[1466, 42, 1097, 30, 113, "Input",ExpressionUUID->"1002122c-4aca-48c2-8730-4743278f615f"],
Cell[2566, 74, 5560, 109, 261, "Output",ExpressionUUID->"bb1aa746-c9e2-492a-a945-0171c9a78957"]
}, Open  ]],
Cell[8141, 186, 392, 6, 84, "Text",ExpressionUUID->"02b2daae-4480-4f35-a494-7d9b0c3e3124"],
Cell[CellGroupData[{
Cell[8558, 196, 892, 24, 30, "Input",ExpressionUUID->"6aefa47e-ce20-40a4-9394-5d4e97868304"],
Cell[9453, 222, 1456, 46, 73, "Output",ExpressionUUID->"053245d4-7ca1-4364-8bd1-47334af48ec7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10946, 273, 586, 15, 52, "Input",ExpressionUUID->"a13bdf2a-2fc5-4770-b5aa-fdb94b107e7a"],
Cell[11535, 290, 583, 16, 37, "Output",ExpressionUUID->"8a246b1d-e56f-4121-9741-17efe43e02eb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12155, 311, 1640, 46, 117, "Input",ExpressionUUID->"422d325e-da85-4bef-8a91-2f83aee0f13b"],
Cell[13798, 359, 42960, 754, 472, "Output",ExpressionUUID->"fb224ac9-bd27-453e-b2af-083927a71b83"]
}, Open  ]]
}, Open  ]]
}
]
*)

