(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[     39321,        815]
NotebookOptionsPosition[     37728,        776]
NotebookOutlinePosition[     38126,        792]
CellTagsIndexPosition[     38083,        789]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Krasovskii example, Problem 2.17", "Section",
 CellChangeTimes->{{3.643590844897092*^9, 3.6435908611947107`*^9}, {
  3.793240591908636*^9, 
  3.7932405953964787`*^9}},ExpressionUUID->"c5401059-86f4-401b-8e52-\
31d5243b8537"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", "2"}], "1"},
      {"1", 
       RowBox[{
        RowBox[{"-", "4"}], "-", 
        RowBox[{"3", 
         SuperscriptBox["x", "2"]}]}]}
     }], "\[NoBreak]", ")"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.643571032595455*^9, 3.643571062373705*^9}, {
  3.643590867907802*^9, 3.6435909020658092`*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"855b92e3-697f-411c-8af0-2d153833c25c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eigs", "=", 
   RowBox[{"Eigenvalues", "[", "a", "]"}]}], ";", "  ", 
  RowBox[{"TraditionalForm", "[", "eigs", "]"}]}]], "Input",
 CellChangeTimes->{{3.643571065508832*^9, 3.643571096020104*^9}, {
  3.643590969450251*^9, 3.64359097636902*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"1e9ec127-c4c0-442b-8eb8-4f468760923b"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"]}]}], "-", 
       SqrtBox[
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["x", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["x", "2"]}], "+", "8"}]], "-", "6"}], ")"}]}], ",", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"]}]}], "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["x", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["x", "2"]}], "+", "8"}]], "-", "6"}], ")"}]}]}], 
   "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.643571070971972*^9, 3.643571096782803*^9}, {
   3.6435908963552237`*^9, 3.643590904567032*^9}, {3.6435909727997293`*^9, 
   3.6435909808146477`*^9}, 3.64359101288373*^9, 3.793240695260804*^9, 
   3.793240834837933*^9, 3.823199606971808*^9, 3.823199666210253*^9, 
   3.8231998255978317`*^9},
 CellLabel->
  "Out[50]//TraditionalForm=",ExpressionUUID->"0fa81b19-967a-4801-8cf8-\
a5a66dd819cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{"eigs", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", "0"}], "}"}]}]}], "]"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"direct", " ", "check", " ", "that", " ", "eigenvalues"}], " ", 
    "<", " ", "0"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.643571109526585*^9, 3.643571163983346*^9}, {
  3.643590914211114*^9, 3.643590957880693*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"a01768dd-13cd-4d7e-a9ec-983e12602073"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw12Hk0Vd37AHCRFMK5GcIlVDIPJSLsaOD1mptIQoVeU+U1ViRJpkoyz0LI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       "]]},
     Annotation[#, "Charting`Private`Tag$9967#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw113k0Vfv7B3CRRETd5nQylJBEypDrfiJJZS6lwXwNGSKzzBwZ06nQMWSI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       "]]},
     Annotation[#, "Charting`Private`Tag$9967#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.9999999591836735, 0.9999999591836735}, {-8, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.643571112539055*^9, 3.6435711645342712`*^9}, {
   3.643590910253153*^9, 3.6435909808615427`*^9}, 3.643591012931158*^9, 
   3.793240695295011*^9, 3.7932408349012957`*^9, 3.8231996070013866`*^9, 
   3.823199666253381*^9, 3.823199825631562*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"c95f813d-eab3-4320-98a3-38ca4c3bcd5c"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tend", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xsol1", ",", "xsol2"}], "}"}], "=", 
   RowBox[{"NDSolveValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], 
          RowBox[{"x1", "[", "t", "]"}]}], "+", 
         RowBox[{"x2", "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"x1", "[", "t", "]"}], "-", 
         RowBox[{"2", 
          RowBox[{"x2", "[", "t", "]"}]}], "-", 
         SuperscriptBox[
          RowBox[{"x2", "[", "t", "]"}], "3"]}]}], ",", 
       RowBox[{
        RowBox[{"x1", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{"x2", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}]}], "]"}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.643588989216864*^9, 3.6435889915779343`*^9}, {
   3.6435890320098658`*^9, 3.6435891943872633`*^9}, {3.643589396111515*^9, 
   3.643589422769474*^9}, {3.6435894838372917`*^9, 3.6435895106681128`*^9}, 
   3.6435909867844763`*^9, 3.6435910246566553`*^9, {3.823199615940927*^9, 
   3.823199625262392*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"bc9313ce-1526-463e-b8ac-97ea61915349"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xsol1", "[", "t", "]"}], ",", 
       RowBox[{"xsol2", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";", 
  RowBox[{"p2", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xsol1", "[", "t", "]"}], ",", 
       RowBox[{"xsol2", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.3"}], ",", "0.3"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{"p1", ",", "p2"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.643589197820291*^9, 3.6435892551791058`*^9}, {
  3.643591035471878*^9, 3.643591048302061*^9}, {3.7932407181727962`*^9, 
  3.793240792903326*^9}, {3.823199635739581*^9, 3.823199645402372*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"da7b581c-566b-4ea5-b0ab-232d45697249"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVkGk41XkDhm1JHIW/l5StyIksGRMRPb9GpSivkhRJNGE6CEVZ2jRCEZUt
ZexaCaMJRUKyd3LKekjOsXTsY5d4ez88133dX+4PzzrnMwdPCfDx8QX/3P+Z
dMlZWPf3wO1ROHNnaWkUlSzlfbbKR8FYmyE01DeKparSa8rKf4CPd2F2rGEU
SWWRSsuU/eHb81V+54NRuJv4eswohaPdwtyDZjQK1ne3mDGle1C6tX7XyoAR
LO/ooQ8rPUbGj+DDG8SG0VpW4js08Bj3d1tdG58cwpOshIrBvCcwlHCUY3UN
wdLH0pFn+gxqpbqqzflDiFtRHNfv+hxczRr1NvshSD2oFhhvycdh4ybpN3mD
SK1N9h5UKsLTCLN4L3ceJhNeaHyJKEI0J89J1paH3a51nKa5IjyvHVX+tIOH
IcEZm2JWMY5/1paNkuVhq4mlUXjoawzmvKBEKr+B+XxBgD76BjPU4K4x5W+4
XKtprutYAbn9GW1j3/qR8zy8w127FharDhi9/7sXPClehLlTLToL7z6xyOgF
3c98+8aYWpyPzHTriulFirFYKmeuFtIKf0Rr+/XiTk2Ei927OgwmMjvPG/bC
jxM1bnasAYJ3c6jUci6SxequSe5iwoSbPzfQxYErPt4b8mEhRNTtrY1xD/jS
pos7brIwc0TNwXhzDxKE5Nm1GSysvoogLdUeVNe4KD5uZiFcuEdOh9aDjYcW
0k4ZfYJqQEx2DvsrBtzoz7r4PyP0ww+xuMtfcfrOxVJmdDPKxMdNS+q74dmr
zinIacPhNwUOmUJf0H28TeRtTRtu3LXW8BrtgnVrmHYDtw2WDkGrLdu7sLWu
3793TTsmU8ZFTHO7IJiXKSET2o6HMdTyVQ5dSAhat/28YwdMIwM6FYo78ZaS
u2co0Yl8u+u+N6+yIbruT/qXrd2g248np+5oR7XxbZ1Lu7rB/hi34a1uO64f
+ctA4WA3Csz3OQ2va4dAdKGZPaMboR7SVQyBdswvDrm2JHXDhBbXt1jRhkG2
zaMPAl9xKeKX1ef2tqE+ga5eVv8VJvL6G8wcWnFLok4j9QQHHitj+eWzmlFk
oPDC0pOD1LLb76bjm8E9fgYLgRwYh/gYdoY3Y1s2dcg2noOJLT1L9R7NGNh7
7KJ4Iwdn34fm6us3w/Ta8Af/bVz4Jxpx6TWfMTu1yvegTC/+u2Qi8cvMJzh3
HHojWN+HqIpN6be9WRC9/9XDu60P/07sSNR3Yf38wVP+S18fgvpo5lw7FgTb
Q/2L+fsRu0Yl7+hOFjJai/W8DfrBmV988lSWhb7Pyo+60vohHdRXzH3ThNPM
oegi/wGs2izh5S3TBO93fzqfofNQ19lxxrqdCUXubuFpPR5GDOjyNz4yUSew
4kkQ4eHVLnZJVTUTG0jkePhRHmJt5+sPvGSirTj2SsZNHlSsd9/IiWFiR27W
X22jPBxMURC8ZMWE5P3qdtPCQbwyXTROS/iAPC+a9eq9w+h7sOxoyMMGpAYy
eJttx2BQ8eR81VgNgpMXDkwOjUPvCi1Q+kcV+Fjd5HXABDY3rBaUvVgJtXMu
Fw5pTGFj3IPkjyrl4E7FHxYrmYZaIWPmzrYymPeevnjHexaMrou0o22vYcmN
3qSoOA/NXJFPDSVF4FU4X6nO/o6zx6yqFrVeQluyWcHU8Qe2/WuWZf+yAKKY
cmJPLEJkcmuVw7N8mA3bzay34SPs7cJr3/+di9by3/ntNPmJ/l5plYjpbLwI
qzyuPMVPJj2OVZfJPIXLMt/uxkYBotfcFdtk8QgnfQJf0BIFSTrbJcx6KhM6
rpsa9zkJET/Vne/o3HR8kNIU8zVcRuJsV84mf0nFq5zg+5qCwkSxgW03opWC
QH4Nq/pOYWJaxzwxIJ4EUXbAHs+C5USXsfFkpmoierPWxSQHiRBRvVfa5Xnx
iNkoJ1Rks4JI2y+eLtkXi+hEl/dOyqJEltYfN7vnLuxiHBpp/aLEt6Vvu/jl
25jdmTmXXCpGWsPk3bODosDp/e1CeSiNpC11pi2ERSDNRHdtg5M4mdFXL+zO
DEd2iK+kq9ZK4r475V68QShCbU5aCE6tJDIqiqfGVoZgCzv1cWjDKsLbJOhx
YzwYCer3sxssJMiAyvrqy+pXcbksMsGiSILIa3xfa9VyCfvX2mTWqkqS8qm5
A5KVgdjh+d5eMlySMNsnb+Ro+iNZ3lm1fkqSPPTanbMl3Q+qFQ/jLO2lyK/1
3g8VrpxDtFa5RlOpFLmhnW08fc8HLhNCH2s0KNJUPDt3uMQLznn/KodHUWTm
QsF+X1tPuAdbL5jfpoi53VlTFXNP+FoXtNDuUqTjjY5Ui7EnwqZ8b0XHUeSd
Ts1mq/WeyDGc+x6fRJFhi3itsGEPzL1das56ShGv0lOLtBAPRDfRIivfU2Sy
aar8SKE7EtM93K7XUKRuhEmVPHVH+rlG0z11FFGx4o2oJbvjH5no+bpGirh+
XzIUu+4Oth3lxvpMEZ+kD13/OeQOOkfOtIfz04+826Y7zsDmggDFjF6KlKUY
rBjmMmAU0jF3qv9nLyrMMKeVgX30pNxvPIpc8BspJGUM+DCUFcfHKaK5mjOc
GcVAkPHVufwJivgZnYyMuMZAiHjPp3NTFNmiJxV04TwDCc/Tb87OUkSpTNXk
hCMDaVeEXIvnKeJw4oHoMWsGnh449VvQAkUMR08rOJgxULC+SmH7IkX+8Vlz
9uQ2Bkon1OaWlijSMvbrijM6DPwPo9b6/Q==
           "]]},
         Annotation[#, "Charting`Private`Tag$10031#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwV1Wk4Vfv7BnDTkYqKXR1UppOhiAaFqHs55uGoDGU6OlSGY8yJMlZUhmRK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           "]]},
         Annotation[#, "Charting`Private`Tag$10031#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{10.03061224489796, 1.5}, {7.5, 6.500000000000014}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {105.85013743905223, -65.9970111335425},
      ImageScaled[{0.5, 0.5}], {192.27891196426035, 125.70859263531905}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw11Xk4VV3fB3AajFGRpFTm4ZaKDHehb5RoUncqKopk6iBChW5TVKRkCE0y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           "]]},
         Annotation[#, "Charting`Private`Tag$10074#1"]& ]}, {}},
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{10.000000000000028`, 8.}, {7.5, 6.500000000000014}},
      Method->{
       "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "ScalingFunctions" -> None},
      PlotRange->{{-1, 1}, {-0.3, 0.3}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}], {416.59194406055826, -65.9970111335425},
      ImageScaled[{0.5, 0.5}], {390.3619754510635, 125.70859263531905}]}, {}},
  
  ImageSize->{
    UpTo[600], 
    UpTo[223]},
  PlotRange->{{0, 621.4836132430121}, {-131.994022267085, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.7932407695713367`*^9, 3.793240793383052*^9}, 
   3.793240835037833*^9, 3.8231996071182423`*^9, {3.823199653966156*^9, 
   3.823199666370851*^9}, 3.823199825748942*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"f3e5aedf-3ec2-48b3-a92e-9a6acb88511d"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.7939116912934513`*^9, 3.793911695532187*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"dc9905a2-11a0-4948-b034-7bfb8b87144e"],

Cell[BoxData[
 RowBox[{"(*", " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"dt", "=", ".01"}], ";", "\[IndentingNewLine]", 
   RowBox[{"x1t", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"xsol1", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend", ",", "dt"}], "}"}]}], "]"}]}], ";",
    "\[IndentingNewLine]", 
   RowBox[{"x2t", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"xsol2", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend", ",", "dt"}], "}"}]}], "]"}]}], ";",
    "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<krasovskii.dat\>\"", ",", 
     RowBox[{"Flatten", "/@", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"x1t", ",", "x2t"}], "}"}], "]"}]}], ",", "\"\<Table\>\""}], 
    "]"}]}], " ", "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.643591152603766*^9, 3.6435912157636747`*^9}, {
  3.823199755599724*^9, 3.8231998169329367`*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"fa83d611-262f-4589-9831-a087278e370a"]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{119, Automatic}, {77, Automatic}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"235348df-f74e-42a2-b68a-e4fbadc7aaf1"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[422, 15, 230, 4, 67, "Section",ExpressionUUID->"c5401059-86f4-401b-8e52-31d5243b8537"],
Cell[655, 21, 494, 14, 47, "Input",ExpressionUUID->"855b92e3-697f-411c-8af0-2d153833c25c"],
Cell[CellGroupData[{
Cell[1174, 39, 358, 7, 30, "Input",ExpressionUUID->"1e9ec127-c4c0-442b-8eb8-4f468760923b"],
Cell[1535, 48, 1273, 38, 61, "Output",ExpressionUUID->"0fa81b19-967a-4801-8cf8-a5a66dd819cd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2845, 91, 651, 17, 52, "Input",ExpressionUUID->"a01768dd-13cd-4d7e-a9ec-983e12602073"],
Cell[3499, 110, 12786, 229, 251, "Output",ExpressionUUID->"c95f813d-eab3-4320-98a3-38ca4c3bcd5c"]
}, Open  ]],
Cell[16300, 342, 1559, 42, 98, "Input",ExpressionUUID->"bc9313ce-1526-463e-b8ac-97ea61915349"],
Cell[CellGroupData[{
Cell[17884, 388, 1360, 37, 94, "Input",ExpressionUUID->"da7b581c-566b-4ea5-b0ab-232d45697249"],
Cell[19247, 427, 17051, 308, 151, "Output",ExpressionUUID->"f3e5aedf-3ec2-48b3-a92e-9a6acb88511d"]
}, Open  ]],
Cell[36313, 738, 183, 3, 51, "Text",ExpressionUUID->"dc9905a2-11a0-4948-b034-7bfb8b87144e"],
Cell[36499, 743, 1213, 30, 187, "Input",ExpressionUUID->"fa83d611-262f-4589-9831-a087278e370a"]
}, Open  ]]
}
]
*)

