(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    116302,       2562]
NotebookOptionsPosition[    112388,       2488]
NotebookOutlinePosition[    112864,       2505]
CellTagsIndexPosition[    112821,       2502]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Massimiliano Esposito\[CloseCurlyQuote]s code for 2x2 bipartite Markov \
dynamics 
(for autonomous control, Maxwell demon) 
\t-- modified by JB   (March 5, 2018)    Problem 15.26\
\>", "Section",
 CellChangeTimes->{{3.7263306422385283`*^9, 3.7263306556656723`*^9}, {
   3.726330689617982*^9, 3.726330722508623*^9}, {3.7263360051195593`*^9, 
   3.726336017607091*^9}, {3.7263419031695757`*^9, 3.726341929637411*^9}, 
   3.7263704764394083`*^9, {3.7292755175408077`*^9, 3.729275518416868*^9}, {
   3.793999133103655*^9, 3.7939991381068974`*^9}, {3.793999382566777*^9, 
   3.7939993926432457`*^9}},ExpressionUUID->"4bdbcd86-ddd5-4310-abfa-\
e41f7e84faf1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[2321]:=",ExpressionUUID->"b4feff48-f9a7-4f78-9506-9b73d62f65dc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "labeling", " ", "scheme", " ", "for", " ", "subsystems", " ", "x", " ", 
     "and", " ", 
     RowBox[{"y", ":", "   ", "xy"}]}], ";", " ", 
    RowBox[{"1", "=", "L0"}], ";", " ", 
    RowBox[{"2", "=", "R0"}], ";", " ", 
    RowBox[{"3", "=", "L1"}], ";", " ", 
    RowBox[{"4", "=", "R1"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Nbpoint", "=", "80"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Beta]", "=", "1"}], ";", " ", 
    RowBox[{"\[Epsilon]1", "=", "0"}], ";", " ", 
    RowBox[{"\[Epsilon]2", "=", "0"}], ";", " ", 
    RowBox[{"\[Epsilon]3", "=", "0"}], ";", " ", 
    RowBox[{"\[Epsilon]4", "=", "0"}], ";", " ", 
    RowBox[{
     SubscriptBox["\[CapitalGamma]", "0"], "=", "1"}], ";", " ", 
    RowBox[{
     SubscriptBox["f", "0"], "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"param", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[CapitalGamma]", "\[Rule]", 
        SubscriptBox["\[CapitalGamma]", "0"]}], ",", 
       RowBox[{"f21", "\[Rule]", "0"}], ",", 
       RowBox[{"f34", "\[Rule]", " ", 
        RowBox[{"1", "f"}]}], ",", 
       RowBox[{"f42", "\[Rule]", "f"}], ",", 
       RowBox[{"f13", "\[Rule]", "f"}]}], "}"}]}], ";"}], "  ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Set", " ", "f34"}], "=", 
     RowBox[{
      RowBox[{"0", " ", "for", " ", "a", " ", "\"\<sensor\>\"", " ", "and"}], 
      " ", "=", 
      RowBox[{"f", " ", "for", " ", "a", " ", "\"\<regulator\>\""}]}]}], " ", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.530255654767646*^9, 3.530255683486402*^9}, {
   3.600349490341823*^9, 3.600349526078107*^9}, {3.600350434576366*^9, 
   3.600350487095393*^9}, {3.600499916432118*^9, 3.6004999398699913`*^9}, {
   3.600500035938946*^9, 3.600500116611858*^9}, {3.6005001745741167`*^9, 
   3.6005002352802267`*^9}, {3.6005002971605167`*^9, 3.600500327308214*^9}, {
   3.6005028622133303`*^9, 3.600502940424691*^9}, {3.600504379115353*^9, 
   3.600504391199416*^9}, {3.600509074743679*^9, 3.600509108579659*^9}, {
   3.6005098646229877`*^9, 3.600509871759947*^9}, {3.600509904910063*^9, 
   3.6005099054622726`*^9}, {3.600874860925645*^9, 3.6008748617813177`*^9}, {
   3.600875609626404*^9, 3.600875610505313*^9}, {3.726300566244594*^9, 
   3.7263005673812103`*^9}, {3.726300714758986*^9, 3.7263008026199503`*^9}, {
   3.72630116406758*^9, 3.726301166891181*^9}, {3.726330403487064*^9, 
   3.726330451084062*^9}, {3.726341520248489*^9, 3.726341540239518*^9}, {
   3.72634171423964*^9, 3.726341727540921*^9}, {3.726341950462397*^9, 
   3.726341963500547*^9}, {3.726370404269209*^9, 3.726370411942027*^9}, {
   3.72637073228423*^9, 3.726370765792148*^9}, {3.7263708191947737`*^9, 
   3.726370819609932*^9}, {3.7263710092433157`*^9, 3.726371011217175*^9}, {
   3.726371048164187*^9, 3.726371050324215*^9}, {3.726371108275388*^9, 
   3.7263711885596733`*^9}, {3.729275501089789*^9, 3.729275536797514*^9}, {
   3.729275572262865*^9, 3.729275610223546*^9}, {3.7292784924043016`*^9, 
   3.729278493377448*^9}, {3.7292796360769453`*^9, 3.729279637403386*^9}, 
   3.7292823198007517`*^9, 3.729282358457589*^9, {3.729282501859001*^9, 
   3.729282561853406*^9}, {3.72928261031824*^9, 3.729282675481854*^9}, {
   3.729282914399979*^9, 3.729282953955855*^9}, 3.729283674601129*^9, {
   3.729283865777964*^9, 3.729283866039379*^9}, 3.7292859368061132`*^9, {
   3.729286363991062*^9, 3.729286425161017*^9}, {3.729286471435362*^9, 
   3.729286489697708*^9}, {3.729389694248781*^9, 3.7293896947517557`*^9}, {
   3.72939261148606*^9, 3.729392629062636*^9}, {3.729465834522189*^9, 
   3.729465834758101*^9}, 3.729477159975136*^9, {3.729477208539447*^9, 
   3.72947722355329*^9}, 3.729478708676186*^9, 3.729478807679448*^9, {
   3.7294820689352818`*^9, 3.729482084577033*^9}, {3.7295398914529343`*^9, 
   3.729539933084408*^9}, 3.7297609916565523`*^9, {3.729761026861285*^9, 
   3.729761053596794*^9}},
 CellLabel->
  "In[2322]:=",ExpressionUUID->"598b22ce-56c5-4b44-a1cf-ebd71f7708ef"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"pvec", "=", 
    RowBox[{"Array", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["p", "#"], "&"}], ",", "4"}], "]"}]}], ";", 
   RowBox[{"ppvec", "=", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["pp", "1"], ",", 
      SubscriptBox["pp", "2"], ",", 
      SubscriptBox["pp", "3"], ",", 
      RowBox[{"1", "-", 
       SubscriptBox["pp", "1"], "-", 
       SubscriptBox["pp", "2"], "-", 
       SubscriptBox["pp", "3"]}]}], "}"}]}], ";"}], " "}]], "Input",
 CellChangeTimes->{{3.729278758060033*^9, 3.729278791522422*^9}, {
   3.729278832290772*^9, 3.729278832591949*^9}, {3.729278925724534*^9, 
   3.729278977354247*^9}, 3.72927957011178*^9, {3.729279731349712*^9, 
   3.72927980999011*^9}, 3.729280044936644*^9, {3.729281697599391*^9, 
   3.7292817273504457`*^9}},
 CellLabel->
  "In[2325]:=",ExpressionUUID->"30695159-c2f7-4264-b295-7aee56eba7e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Rate", " ", "matrix"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"WL", "=", 
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{
        SubscriptBox["w", 
         RowBox[{"#1", ",", "#2"}]], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"1", ",", "1"}]], "=", "0"}], ";", 
    "                                                          ", 
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"1", ",", "2"}]], "=", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "\[Beta]"}], 
       RowBox[{"(", 
        RowBox[{"\[Epsilon]1", "-", "\[Epsilon]2", "-", 
         RowBox[{"f21", "/", "2"}]}], ")"}]}], "]"}]}], ";", "            ", 
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"1", ",", "3"}]], "=", 
     RowBox[{"\[CapitalGamma]", "*", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "\[Beta]"}], 
        RowBox[{"(", 
         RowBox[{"\[Epsilon]1", "-", "\[Epsilon]3", "-", 
          RowBox[{"f13", "/", "2"}]}], ")"}]}], "]"}]}]}], ";", "          ", 
    
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"1", ",", "4"}]], "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"2", ",", "1"}]], "=", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "\[Beta]"}], 
       RowBox[{"(", 
        RowBox[{"\[Epsilon]2", "-", "\[Epsilon]1", "+", 
         RowBox[{"f21", "/", "2"}]}], ")"}]}], "]"}]}], ";", "         ", 
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"2", ",", "2"}]], "=", "0"}], ";", 
    "                                                             ", 
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"2", ",", "3"}]], "=", "0"}], ";", 
    "                                                                  ", 
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"2", ",", "4"}]], "=", 
     RowBox[{"\[CapitalGamma]", "*", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "\[Beta]"}], 
        RowBox[{"(", 
         RowBox[{"\[Epsilon]2", "-", "\[Epsilon]4", "+", 
          RowBox[{"f42", "/", "2"}]}], ")"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"3", ",", "1"}]], "=", 
     RowBox[{"\[CapitalGamma]", " ", "*", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "\[Beta]"}], 
        RowBox[{"(", 
         RowBox[{"\[Epsilon]3", "-", "\[Epsilon]1", "+", 
          RowBox[{"f13", "/", "2"}]}], ")"}]}], "]"}]}]}], ";", "  ", 
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"3", ",", "2"}]], "=", "0"}], ";", 
    "                                                             ", 
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"3", ",", "3"}]], "=", "0"}], ";", 
    "                                                                  ", 
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"3", ",", "4"}]], "=", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "\[Beta]"}], 
       RowBox[{"(", 
        RowBox[{"\[Epsilon]3", "-", "\[Epsilon]4", "-", 
         RowBox[{"f34", "/", "2"}]}], ")"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"4", ",", "1"}]], "=", "0"}], ";", 
    "                                                          ", 
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"4", ",", "2"}]], "=", 
     RowBox[{"\[CapitalGamma]", "*", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "\[Beta]"}], 
        RowBox[{"(", 
         RowBox[{"\[Epsilon]4", "-", "\[Epsilon]2", "-", 
          RowBox[{"f42", "/", "2"}]}], ")"}]}], "]"}]}]}], ";", "      ", 
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"4", ",", "3"}]], "=", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "\[Beta]"}], 
       RowBox[{"(", 
        RowBox[{"\[Epsilon]4", "-", "\[Epsilon]3", "+", 
         RowBox[{"f34", "/", "2"}]}], ")"}]}], "]"}]}], ";", 
    "                ", 
    RowBox[{
     SubscriptBox["w", 
      RowBox[{"4", ",", "4"}]], "=", "0"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"WL", " ", "-=", 
     RowBox[{"DiagonalMatrix", "[", 
      RowBox[{"Total", "[", "WL", "]"}], "]"}]}], ";"}], "  ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "set", " ", "diagonal", " ", "to", " ", "negative", " ", "column", " ", 
      "sum"}], ",", " ", 
     RowBox[{"to", " ", "conserve", " ", "probability"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"MatrixForm", "[", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"WL", "/.", "param"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.512641137128099*^9, {3.5302553057183247`*^9, 3.530255330188527*^9}, {
   3.530255699063119*^9, 3.530255700173545*^9}, {3.530255733655458*^9, 
   3.530255757572605*^9}, {3.530255856013513*^9, 3.530255959772773*^9}, {
   3.5302560382916117`*^9, 3.530256169190981*^9}, {3.530256242633153*^9, 
   3.53025627409534*^9}, {3.530256350083891*^9, 3.530256371550496*^9}, {
   3.530256411040865*^9, 3.5302564545635757`*^9}, {3.530256498731769*^9, 
   3.5302566016127863`*^9}, {3.530256698513609*^9, 3.5302567027779827`*^9}, {
   3.530256779044984*^9, 3.530256813997727*^9}, {3.530256848893182*^9, 
   3.530256854535837*^9}, {3.5302569741437902`*^9, 3.530257058407682*^9}, {
   3.530257117527952*^9, 3.530257160283369*^9}, {3.530257199105485*^9, 
   3.530257315056136*^9}, 3.530257517808831*^9, 3.530260179917959*^9, {
   3.60050033722904*^9, 3.600500346036612*^9}, {3.6005090485071573`*^9, 
   3.600509175620528*^9}, {3.6005097981901617`*^9, 3.600509842653862*^9}, {
   3.6005099098227167`*^9, 3.6005099389287558`*^9}, 3.6005101190256*^9, {
   3.7263004639946327`*^9, 3.72630048064452*^9}, {3.726300514022852*^9, 
   3.7263005201168623`*^9}, {3.726300601772539*^9, 3.726300603501449*^9}, {
   3.726300820382275*^9, 3.726300846463134*^9}, {3.726300877118782*^9, 
   3.726300983293194*^9}, {3.72630112624894*^9, 3.7263011267020397`*^9}, {
   3.7263011727515*^9, 3.72630124434158*^9}, {3.726301390013092*^9, 
   3.7263014225248537`*^9}, {3.7263014540528193`*^9, 3.726301587829303*^9}, {
   3.726301672452199*^9, 3.726301732700368*^9}, {3.726301775603161*^9, 
   3.726301828483602*^9}, {3.726308205875877*^9, 3.726308206121785*^9}, {
   3.726320473418501*^9, 3.726320529454743*^9}, {3.726320580744194*^9, 
   3.72632058096671*^9}, {3.72632061103965*^9, 3.726320611470848*^9}, {
   3.726321404446477*^9, 3.726321409901058*^9}, {3.7263217234206343`*^9, 
   3.726321723541554*^9}, {3.72632182002041*^9, 3.726321854802878*^9}, {
   3.726321934956615*^9, 3.726321942426557*^9}, {3.7263222755947237`*^9, 
   3.726322277682232*^9}, {3.726323960215293*^9, 3.7263240050857363`*^9}, 
   3.7263311185950813`*^9, {3.726331710352457*^9, 3.7263317359174013`*^9}, 
   3.726332406199963*^9, {3.726332727293455*^9, 3.726332739386726*^9}, {
   3.726335449964488*^9, 3.726335475240713*^9}, 3.726335506027626*^9, {
   3.7263355578500433`*^9, 3.726335559179228*^9}, {3.726335598320486*^9, 
   3.726335691922042*^9}, {3.7263357924068213`*^9, 3.726335890740999*^9}, {
   3.726336080341591*^9, 3.726336105905951*^9}, {3.726337468416623*^9, 
   3.726337469020543*^9}, {3.726337644635293*^9, 3.726337644926543*^9}, {
   3.7263376800547047`*^9, 3.7263376811883593`*^9}, {3.726337726724689*^9, 
   3.7263378632497883`*^9}, {3.7263383981185923`*^9, 3.726338436209343*^9}, {
   3.726338762415782*^9, 3.726339131804161*^9}, {3.726339821786641*^9, 
   3.726339832975781*^9}, {3.726340077749441*^9, 3.726340115727641*^9}, {
   3.7263401623618793`*^9, 3.726340175322258*^9}, 3.72634048085788*^9, {
   3.726370816339327*^9, 3.726370849808425*^9}, {3.7292750894003468`*^9, 
   3.729275219106398*^9}, {3.729275333110249*^9, 3.729275333372924*^9}, {
   3.729275421989237*^9, 3.7292754664582977`*^9}, {3.7292799306526012`*^9, 
   3.729279931500724*^9}, {3.729284538798299*^9, 3.729284548186928*^9}, {
   3.729284777013793*^9, 3.7292848120620737`*^9}, 3.729285409826941*^9, {
   3.7292858983946133`*^9, 3.7292859148241863`*^9}, {3.729389623579956*^9, 
   3.729389635339491*^9}, 3.729390003735998*^9, 3.7293900440594683`*^9, 
   3.7293926085532093`*^9, {3.729465783815486*^9, 3.729465786819045*^9}},
 CellLabel->
  "In[2326]:=",ExpressionUUID->"402b753f-0cf9-480f-b2f4-a0b735221c5c"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "f"}], "/", "2"}]]}], "1", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"f", "/", "2"}]], "0"},
     {"1", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"f", "/", "2"}]]}], "0", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "f"}], "/", "2"}]]},
     {
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "f"}], "/", "2"}]], "0", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"Cosh", "[", 
        FractionBox["f", "2"], "]"}]}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"f", "/", "2"}]]},
     {"0", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"f", "/", "2"}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "f"}], "/", "2"}]], 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"Cosh", "[", 
        FractionBox["f", "2"], "]"}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.726335666099107*^9, 3.726335845535347*^9, 3.7263358952233257`*^9, 
   3.726335938964652*^9, {3.7263360953317547`*^9, 3.726336133279187*^9}, 
   3.726336207524959*^9, 3.7263365390538187`*^9, 3.726336711211447*^9, 
   3.7263367557521887`*^9, 3.7263369577780743`*^9, 3.726337165958664*^9, 
   3.7263372328515263`*^9, 3.726337297792406*^9, 3.7263374704136457`*^9, 
   3.7263376567955513`*^9, 3.726337882070058*^9, 3.7263381299919577`*^9, 
   3.72633844058175*^9, 3.726339797701845*^9, {3.726339834547279*^9, 
   3.726339857764618*^9}, {3.726340081673284*^9, 3.7263401183674927`*^9}, {
   3.726340171791648*^9, 3.726340188839521*^9}, 3.7263402458177767`*^9, 
   3.726340410908791*^9, 3.7263404683605537`*^9, 3.7263405460043592`*^9, 
   3.7263406052793417`*^9, 3.726340637167183*^9, 3.7263406704255657`*^9, 
   3.7263409467813253`*^9, 3.726340991635046*^9, 3.726341042996976*^9, 
   3.7263411779789877`*^9, 3.726341550504184*^9, 3.726341625410191*^9, {
   3.7263417329149733`*^9, 3.7263417585278254`*^9}, 3.7263418844809437`*^9, 
   3.726341933585902*^9, 3.726341969441517*^9, 3.726342284135435*^9, 
   3.726342314687723*^9, 3.726342431222286*^9, 3.726370472724512*^9, 
   3.726370738789542*^9, 3.7263707690885344`*^9, 3.7263708602214613`*^9, 
   3.726371018398295*^9, 3.7263710573901987`*^9, {3.726371126313792*^9, 
   3.726371165081641*^9}, {3.726371204586443*^9, 3.726371231280208*^9}, 
   3.7263712662187767`*^9, {3.726371298657333*^9, 3.726371327043428*^9}, {
   3.726371624700201*^9, 3.7263716361667843`*^9}, 3.726371763302548*^9, 
   3.726372119320278*^9, 3.726384579274311*^9, 3.729187205223502*^9, {
   3.729189113923821*^9, 3.729189133771159*^9}, 3.72918925101497*^9, 
   3.729275229894009*^9, 3.729275336943377*^9, 3.729275474424973*^9, {
   3.729275557189929*^9, 3.729275612962213*^9}, {3.729275669118638*^9, 
   3.72927568280676*^9}, 3.7292783249468184`*^9, {3.729278373103498*^9, 
   3.729278390005549*^9}, 3.729278433676154*^9, 3.729278496715581*^9, {
   3.729279082338835*^9, 3.7292790843683023`*^9}, 3.729279664412676*^9, 
   3.7292799321900253`*^9, 3.7292800595146217`*^9, 3.729281124176547*^9, 
   3.729281575913731*^9, 3.729281666244864*^9, 3.729281774294854*^9, 
   3.729282069632834*^9, {3.729282101599806*^9, 3.729282131114695*^9}, 
   3.729282279003891*^9, 3.7292823231763268`*^9, {3.729282361812808*^9, 
   3.729282373551265*^9}, {3.729282541823841*^9, 3.729282566529867*^9}, {
   3.7292826134893*^9, 3.729282651608889*^9}, 3.729282688073172*^9, 
   3.729282867869603*^9, {3.729282919640193*^9, 3.729282956813808*^9}, 
   3.729283677235242*^9, 3.729283753486928*^9, 3.729283869028516*^9, 
   3.729283983618685*^9, 3.729284288870648*^9, 3.72928442667935*^9, {
   3.7292845490327673`*^9, 3.729284574907707*^9}, 3.729284685806685*^9, {
   3.729284782505477*^9, 3.729284812456058*^9}, 3.729284877969598*^9, 
   3.7292854129581614`*^9, 3.72928555254916*^9, 3.729285762456604*^9, {
   3.729285884550398*^9, 3.729285939249844*^9}, 3.729286097505512*^9, 
   3.729286229765993*^9, {3.729286367012038*^9, 3.729286428090695*^9}, {
   3.729286474845128*^9, 3.729286492400379*^9}, 3.729389557329863*^9, 
   3.7293896388283157`*^9, 3.729389697771613*^9, {3.729390005778413*^9, 
   3.729390011155054*^9}, {3.729390045230638*^9, 3.72939004862309*^9}, {
   3.729392617079011*^9, 3.729392633285466*^9}, 3.72946094748661*^9, {
   3.729465792688813*^9, 3.72946581511652*^9}, 3.7294658529953203`*^9, 
   3.7294687602636967`*^9, 3.729477163345132*^9, {3.729477211798684*^9, 
   3.729477227598075*^9}, 3.729478442600183*^9, 3.729478711480142*^9, {
   3.729478798483992*^9, 3.729478810373205*^9}, 3.729482088627541*^9, 
   3.729539938381275*^9, 3.7295408325990334`*^9, 3.729760958501834*^9, 
   3.729760995169135*^9, {3.729761031396583*^9, 3.729761057128579*^9}, 
   3.79399915296588*^9, 3.793999268693656*^9, 3.793999414058443*^9, 
   3.823228419412909*^9},
 CellLabel->
  "Out[2332]//MatrixForm=",ExpressionUUID->"d530c0fc-1d9d-4c74-bb4d-\
9ed12ef93783"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WL", "/.", 
   RowBox[{"\[CapitalGamma]", "\[Rule]", "1"}]}], "//", "MatrixForm", "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"for", " ", "problem", " ", "in", " ", "book"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.729465374992001*^9, 3.729465380606031*^9}},
 CellLabel->
  "In[2333]:=",ExpressionUUID->"4f12890a-cef7-40b4-b5a0-3064a322215f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "f13"}], "/", "2"}]]}], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "f21"}], "/", "2"}]]}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"f21", "/", "2"}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"f13", "/", "2"}]], "0"},
     {
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "f21"}], "/", "2"}]], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"f21", "/", "2"}]]}], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"f42", "/", "2"}]]}], "0", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "f42"}], "/", "2"}]]},
     {
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "f13"}], "/", "2"}]], "0", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"f13", "/", "2"}]]}], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "f34"}], "/", "2"}]]}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"f34", "/", "2"}]]},
     {"0", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"f42", "/", "2"}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "f34"}], "/", "2"}]], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"f34", "/", "2"}]]}], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "f42"}], "/", "2"}]]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.729465363746976*^9, {3.729465792866654*^9, 3.72946581522027*^9}, 
   3.729465853107092*^9, 3.729468760369816*^9, 3.7294771634637012`*^9, {
   3.729477211901133*^9, 3.7294772278053093`*^9}, 3.729478442717092*^9, 
   3.72947871160485*^9, {3.729478798595201*^9, 3.729478810496072*^9}, 
   3.729482088755435*^9, 3.7295399384771957`*^9, 3.7295408327076893`*^9, 
   3.7297609586398153`*^9, 3.729760995274234*^9, {3.7297610317129*^9, 
   3.7297610572488832`*^9}, 3.793999152973575*^9, 3.793999268702463*^9, 
   3.7939994140672817`*^9, 3.823228419420683*^9},
 CellLabel->
  "Out[2333]//MatrixForm=",ExpressionUUID->"d8f12401-c6bb-4a88-8e75-\
7ff2f3fc4ac8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Exact", " ", "stationary", " ", "state"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Pst", "=", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"WL", ".", "ppvec"}], "\[Equal]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["pp", "1"], ",", 
          SubscriptBox["pp", "2"], ",", 
          SubscriptBox["pp", "3"]}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pvec1", "=", 
     RowBox[{"ppvec", "/.", "Pst"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["p", "1"], ",", 
       SubscriptBox["p", "2"], ",", 
       SubscriptBox["p", "3"], ",", 
       SubscriptBox["p", "4"]}], "}"}], "=", "pvec1"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["p", 
      RowBox[{"L", ",", "0"}]], "=", 
     SubscriptBox["p", "1"]}], ";", " ", 
    RowBox[{
     SubscriptBox["p", 
      RowBox[{"R", ",", "0"}]], "=", 
     SubscriptBox["p", "2"]}], ";", "   ", 
    RowBox[{
     SubscriptBox["p", 
      RowBox[{"L", ",", "1"}]], "=", 
     SubscriptBox["p", "3"]}], ";", "    ", 
    RowBox[{
     SubscriptBox["p", 
      RowBox[{"R", ",", "1"}]], "=", 
     SubscriptBox["p", "4"]}], ";"}], "    ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"use", " ", "more"}], "-", 
     RowBox[{"intuitive", " ", "names"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pL", "=", 
     RowBox[{
      SubscriptBox["p", 
       RowBox[{"L", ",", "0"}]], "+", 
      SubscriptBox["p", 
       RowBox[{"L", ",", "1"}]]}]}], ";", "    ", 
    RowBox[{"pR", "=", 
     RowBox[{
      SubscriptBox["p", 
       RowBox[{"R", ",", "0"}]], "+", 
      SubscriptBox["p", 
       RowBox[{"R", ",", "1"}]]}]}], ";"}], "    ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "left", " ", "and", " ", "right", " ", "marginal", " ", "probabilities"}],
     " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Exact", " ", "full", " ", "entropy", " ", "production"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Smat", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["w", 
          RowBox[{"i", ",", "j"}]], 
         SubscriptBox["p", "j"], " ", 
         RowBox[{"Log", "[", 
          FractionBox[
           RowBox[{
            RowBox[{
             SubscriptBox["w", 
              RowBox[{"i", ",", "j"}]], 
             SubscriptBox["p", "j"]}], "+", "eps"}], 
           RowBox[{
            RowBox[{
             SubscriptBox["w", 
              RowBox[{"j", ",", "i"}]], 
             SubscriptBox["p", "i"]}], "+", "eps"}]], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "4"}], "}"}]}], "]"}], "/.", 
      RowBox[{"eps", "\[Rule]", "0"}]}]}], ";", "   ", 
    RowBox[{"Si", "=", 
     RowBox[{"Total", "[", 
      RowBox[{"Smat", ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Entropy", " ", "production", " ", "and", " ", "flow", " ", "in", " ", 
     "X"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Jmat", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["w", 
          RowBox[{"i", ",", "j"}]], 
         SubscriptBox["p", "j"]}], " ", "-", 
        RowBox[{
         SubscriptBox["w", 
          RowBox[{"j", ",", "i"}]], 
         SubscriptBox["p", "i"]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SiX", "=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Jmat", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}], "*", 
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{
          SubscriptBox["w", 
           RowBox[{"1", ",", "2"}]], 
          SubscriptBox["p", 
           RowBox[{"R", ",", "0"}]]}], 
         RowBox[{
          SubscriptBox["w", 
           RowBox[{"2", ",", "1"}]], 
          SubscriptBox["p", 
           RowBox[{"L", ",", "0"}]]}]], "]"}]}], "+", 
      RowBox[{
       RowBox[{"Jmat", "[", 
        RowBox[{"[", 
         RowBox[{"3", ",", "4"}], "]"}], "]"}], "*", 
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{
          SubscriptBox["w", 
           RowBox[{"3", ",", "4"}]], 
          SubscriptBox["p", 
           RowBox[{"R", ",", "1"}]]}], 
         RowBox[{
          SubscriptBox["w", 
           RowBox[{"4", ",", "3"}]], 
          SubscriptBox["p", 
           RowBox[{"L", ",", "1"}]]}]], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SeX", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Jmat", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}], "*", 
       RowBox[{"Log", "[", 
        FractionBox[
         SubscriptBox["w", 
          RowBox[{"1", ",", "2"}]], 
         SubscriptBox["w", 
          RowBox[{"2", ",", "1"}]]], "]"}]}], "+", " ", 
      RowBox[{
       RowBox[{"Jmat", "[", 
        RowBox[{"[", 
         RowBox[{"3", ",", "4"}], "]"}], "]"}], "*", 
       RowBox[{"Log", "[", 
        FractionBox[
         SubscriptBox["w", 
          RowBox[{"3", ",", "4"}]], 
         SubscriptBox["w", 
          RowBox[{"4", ",", "3"}]]], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"IX", "=", 
     RowBox[{"SeX", "-", "SiX"}]}], ";", 
    RowBox[{"SiY", "=", 
     RowBox[{"Si", "-", "SiX"}]}], ";", 
    RowBox[{"SeY", "=", 
     RowBox[{
      RowBox[{"-", "IX"}], "+", "SiY"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Current", " ", "counterclockwise", " ", "along", " ", "cycle"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"IXtest", "=", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Jmat", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "3"}], "]"}], "]"}]}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Log", "[", 
         FractionBox[
          SubscriptBox["p", 
           RowBox[{"L", ",", "0"}]], "pL"], "]"}], "+", 
        RowBox[{"Log", "[", 
         FractionBox[
          SubscriptBox["p", 
           RowBox[{"R", ",", "1"}]], "pR"], "]"}], "-", 
        RowBox[{"Log", "[", 
         FractionBox[
          SubscriptBox["p", 
           RowBox[{"R", ",", "0"}]], "pR"], "]"}], "-", 
        RowBox[{"Log", "[", 
         FractionBox[
          SubscriptBox["p", 
           RowBox[{"L", ",", "1"}]], "pL"], "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"IXtest", "-", "IX"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f21", ">", "0"}], ",", 
        RowBox[{"f34", ">", "0"}], ",", 
        RowBox[{"f42", ">", "0"}], ",", 
        RowBox[{"f13", ">", "0"}], ",", 
        RowBox[{"\[CapitalGamma]", ">", "0"}]}], "}"}]}]}], "]"}], "   ", 
   RowBox[{"(*", " ", 
    RowBox[{"are", " ", "they", " ", "they", " ", 
     RowBox[{"same", "?"}]}], " ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.5305396674406223`*^9, 3.53053975904424*^9}, {
   3.530540669723065*^9, 3.5305406926021767`*^9}, {3.530540728744054*^9, 
   3.530540750768939*^9}, {3.5305408081331577`*^9, 3.530540820341441*^9}, {
   3.5305408605612793`*^9, 3.530540899113106*^9}, {3.530540935482953*^9, 
   3.530540945580564*^9}, {3.530540983025385*^9, 3.530541053463255*^9}, {
   3.53054137764475*^9, 3.53054140151869*^9}, {3.530541577723055*^9, 
   3.530541626148466*^9}, {3.530541670740287*^9, 3.530541681047125*^9}, {
   3.5305417215883427`*^9, 3.530541724215026*^9}, {3.530541785553846*^9, 
   3.53054194670892*^9}, {3.530542080648642*^9, 3.530542088196164*^9}, {
   3.530542155421171*^9, 3.530542167563628*^9}, {3.530542237693084*^9, 
   3.5305422572142773`*^9}, {3.5305426132139387`*^9, 
   3.5305426305720377`*^9}, {3.53054270814643*^9, 3.530542725591524*^9}, 
   3.530542848212987*^9, {3.530542957045714*^9, 3.5305429762667713`*^9}, {
   3.530543123679257*^9, 3.5305431410581493`*^9}, {3.5305431725288897`*^9, 
   3.5305431973529587`*^9}, {3.5305432513497458`*^9, 3.530543258882972*^9}, {
   3.530543361235663*^9, 3.530543405622651*^9}, {3.530543436151888*^9, 
   3.530543547539967*^9}, {3.5305435878648*^9, 3.530543789512309*^9}, {
   3.530543861255083*^9, 3.530543870928481*^9}, {3.530543901228907*^9, 
   3.530543965815261*^9}, {3.530544047564098*^9, 3.530544153974629*^9}, {
   3.530544192231532*^9, 3.530544218942762*^9}, {3.530544500643634*^9, 
   3.530544809585918*^9}, {3.530544865359524*^9, 3.5305448755198507`*^9}, 
   3.530544979371464*^9, {3.53054523172589*^9, 3.5305452745382977`*^9}, {
   3.530545316819202*^9, 3.5305453206021023`*^9}, {3.530545359334532*^9, 
   3.530545552352559*^9}, 3.5305456588148117`*^9, {3.53054591258992*^9, 
   3.530545951300253*^9}, {3.530546038077869*^9, 3.530546069417018*^9}, {
   3.530546158176889*^9, 3.530546208629953*^9}, {3.530546258543639*^9, 
   3.5305462623924294`*^9}, {3.53054674400248*^9, 3.530546991861136*^9}, {
   3.530547030441678*^9, 3.530547102002926*^9}, {3.530815395263473*^9, 
   3.530815405444057*^9}, {3.53081565258638*^9, 3.5308156554579973`*^9}, {
   3.530815751787889*^9, 3.5308157522954283`*^9}, {3.530817241651771*^9, 
   3.5308173176467123`*^9}, {3.530817403694953*^9, 3.530817459794896*^9}, {
   3.5308698270269947`*^9, 3.530869966855958*^9}, {3.5308700861792583`*^9, 
   3.530870126036346*^9}, {3.530870550344288*^9, 3.530870601381641*^9}, {
   3.55794595735109*^9, 3.557945980261754*^9}, {3.600337029535931*^9, 
   3.6003370310133963`*^9}, {3.600337081338167*^9, 3.60033710215998*^9}, {
   3.600338798729844*^9, 3.600338813107863*^9}, {3.600338919861621*^9, 
   3.600338958904954*^9}, {3.600339064490065*^9, 3.600339127001672*^9}, {
   3.600339209408473*^9, 3.600339298064149*^9}, {3.600339401091298*^9, 
   3.60033961980591*^9}, {3.6003480349459677`*^9, 3.600348035487587*^9}, {
   3.600348373982016*^9, 3.600348384947844*^9}, {3.600348525109741*^9, 
   3.6003485428171377`*^9}, {3.600500352357525*^9, 3.600500409652931*^9}, {
   3.600500582983098*^9, 3.600500602776723*^9}, {3.6005007840749693`*^9, 
   3.60050086584816*^9}, {3.600501087438484*^9, 3.600501101025069*^9}, {
   3.60050136912366*^9, 3.600501379449081*^9}, {3.600501556729265*^9, 
   3.600501635352537*^9}, {3.600502556546015*^9, 3.600502560541325*^9}, {
   3.600503087185644*^9, 3.600503149778173*^9}, {3.6005033397501287`*^9, 
   3.6005034520360727`*^9}, {3.600503503073389*^9, 3.600503685516219*^9}, {
   3.6005038296949*^9, 3.6005038328608637`*^9}, {3.6005039348661118`*^9, 
   3.600504022969795*^9}, {3.600504076755907*^9, 3.600504120277568*^9}, {
   3.6005041809952106`*^9, 3.600504182374271*^9}, {3.6005086617305517`*^9, 
   3.600508690922967*^9}, {3.600508729045888*^9, 3.600508784993827*^9}, {
   3.600508837185906*^9, 3.6005088460630007`*^9}, 3.600508907736389*^9, {
   3.600509274504527*^9, 3.6005092777739143`*^9}, {3.726301032570121*^9, 
   3.726301116460599*^9}, {3.726301862584919*^9, 3.726301922119959*^9}, {
   3.7263019626951637`*^9, 3.7263019766257477`*^9}, 3.7263021224616947`*^9, {
   3.726302408168755*^9, 3.726302410879738*^9}, {3.726302538788663*^9, 
   3.726302544957156*^9}, {3.726302577754177*^9, 3.7263027494212017`*^9}, {
   3.726331244012826*^9, 3.7263312494117603`*^9}, {3.726331292389762*^9, 
   3.726331293270556*^9}, {3.726333778018159*^9, 3.726333820047126*^9}, {
   3.726333908620352*^9, 3.7263340664520807`*^9}, {3.7263343252037363`*^9, 
   3.726334387491831*^9}, 3.726334526265956*^9, {3.726334617015592*^9, 
   3.7263346968232727`*^9}, {3.726334892847436*^9, 3.726334893542899*^9}, 
   3.726334995007161*^9, {3.726335043271435*^9, 3.7263351213706703`*^9}, {
   3.726335156975153*^9, 3.726335159860669*^9}, {3.72633519546944*^9, 
   3.7263351975068274`*^9}, {3.726335919413416*^9, 3.726335929467051*^9}, {
   3.726336187927944*^9, 3.726336188807928*^9}, {3.726336366971839*^9, 
   3.726336446366542*^9}, {3.726336480897235*^9, 3.7263365264479923`*^9}, {
   3.726336770797261*^9, 3.7263368115397663`*^9}, {3.726336858467475*^9, 
   3.726336884544154*^9}, {3.7263369162057962`*^9, 3.726336920267514*^9}, {
   3.726337151274413*^9, 3.726337161301865*^9}, 3.726337528160988*^9, {
   3.726340447792652*^9, 3.726340541680683*^9}, {3.7263405799520197`*^9, 
   3.726340658090831*^9}, {3.726340700577916*^9, 3.726340883538446*^9}, {
   3.726340927376666*^9, 3.726341162426064*^9}, {3.726341489453744*^9, 
   3.726341516009407*^9}, {3.726371428823205*^9, 3.7263715429129267`*^9}, {
   3.726371587495714*^9, 3.726371630307344*^9}, {3.729278698441136*^9, 
   3.7292786988066673`*^9}, 3.7292789185581713`*^9, {3.7292789897419147`*^9, 
   3.72927902569969*^9}, {3.729279215374483*^9, 3.729279241890634*^9}, {
   3.729279820391254*^9, 3.729279898036828*^9}, {3.7292819400999193`*^9, 
   3.729282014999098*^9}, {3.729282085966264*^9, 3.729282093156967*^9}, {
   3.729284272950605*^9, 3.729284285061661*^9}, {3.7292855346252317`*^9, 
   3.729285545599736*^9}, {3.7292856477781973`*^9, 3.72928565216013*^9}, {
   3.729286717130631*^9, 3.729286721857451*^9}, {3.729465842035276*^9, 
   3.729465842191828*^9}, {3.729472969442131*^9, 3.729473017176837*^9}, {
   3.729477341749968*^9, 3.729477343220996*^9}},
 CellLabel->
  "In[2334]:=",ExpressionUUID->"ca0cddd8-4eb3-4913-be54-2d778be9d283"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.726371633195101*^9, 3.72637163630381*^9}, 
   3.726371763441918*^9, 3.726372119462262*^9, 3.72638457943573*^9, 
   3.729187205844469*^9, {3.7291891140508823`*^9, 3.7291891338933277`*^9}, 
   3.729189251166151*^9, 3.729275260842948*^9, 3.729275359910673*^9, 
   3.729275474991494*^9, {3.729275557618609*^9, 3.729275613419239*^9}, {
   3.729275669521842*^9, 3.729275683226165*^9}, 3.7292783253547773`*^9, {
   3.729278373506115*^9, 3.729278390419503*^9}, 3.72927843408016*^9, 
   3.729278497218254*^9, 3.729279669035878*^9, 3.729279902504664*^9, 
   3.729282044597056*^9, {3.72928207945781*^9, 3.72928213154736*^9}, 
   3.72928227946756*^9, 3.729282323626731*^9, {3.729282362260921*^9, 
   3.7292823740110598`*^9}, {3.7292825423106422`*^9, 3.729282567200156*^9}, {
   3.7292826139339237`*^9, 3.729282652139539*^9}, 3.7292826885185003`*^9, 
   3.729282868309104*^9, {3.7292829201035957`*^9, 3.729282957900372*^9}, 
   3.729283677693297*^9, 3.729283753936729*^9, 3.729283869487235*^9, 
   3.729283984219154*^9, 3.729284289243103*^9, 3.729284427059472*^9, 
   3.7292845752918367`*^9, 3.729284686173492*^9, 3.7292848783421803`*^9, 
   3.729285413326676*^9, {3.729285552075075*^9, 3.7292855566691847`*^9}, 
   3.729285762832552*^9, {3.729285884920474*^9, 3.729285939605835*^9}, 
   3.729286097875432*^9, 3.729286230132092*^9, {3.72928636740023*^9, 
   3.7292864284569073`*^9}, {3.7292864752152443`*^9, 3.7292864928186207`*^9}, 
   3.7293895577417088`*^9, 3.729389639200778*^9, 3.7293896983267527`*^9, 
   3.729390011541133*^9, 3.729390048994149*^9, {3.729392617444769*^9, 
   3.729392633654045*^9}, 3.729460947653459*^9, {3.7294658096327972`*^9, 
   3.729465853673099*^9}, 3.729468760540492*^9, 3.7294730179034433`*^9, 
   3.729477163595796*^9, {3.729477212329286*^9, 3.729477228237438*^9}, 
   3.729478443152975*^9, 3.729478711717656*^9, {3.729478798709243*^9, 
   3.729478810629587*^9}, 3.729482089256197*^9, 3.729539938929826*^9, 
   3.7295408331354723`*^9, 3.729760959200226*^9, 3.7297609954702463`*^9, {
   3.729761031929871*^9, 3.729761057363287*^9}, 3.793999153284383*^9, 
   3.793999268759666*^9, 3.7939994141232643`*^9, 3.823228419756584*^9},
 CellLabel->
  "Out[2345]=",ExpressionUUID->"72692dc2-971f-40e1-a7e0-824dca93a913"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"IX", "/.", "param"}], ",", 
     RowBox[{"f", ">", "0"}]}], "]"}], "//", "ExpToTrig"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.729482116986692*^9, 3.7294821419187202`*^9}, {
  3.729482206594028*^9, 3.729482213063755*^9}, {3.729537848623736*^9, 
  3.729537854052555*^9}},
 CellLabel->
  "In[2346]:=",ExpressionUUID->"db88fce9-d16a-434b-962b-cf1dde0f8928"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Log", "[", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "f"}], "/", "2"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", "f"], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"3", " ", "f"}], "/", "2"}]], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "f"}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"f", "/", "2"}]], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"3", " ", "f"}], "/", "2"}]], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"5", " ", "f"}], "/", "2"}]]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"f", "/", "2"}]], "+", 
        SuperscriptBox["\[ExponentialE]", "f"], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "f"}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", "f"], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "f"}]], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"5", " ", "f"}], "/", "2"}]]}], ")"}]}]], "]"}], " ", 
   RowBox[{"Sinh", "[", 
    FractionBox[
     RowBox[{"3", " ", "f"}], "2"], "]"}]}], 
  RowBox[{"2", "+", 
   RowBox[{"Cosh", "[", 
    FractionBox["f", "2"], "]"}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"Cosh", "[", "f", "]"}]}], "+", 
   RowBox[{"Cosh", "[", 
    FractionBox[
     RowBox[{"3", " ", "f"}], "2"], "]"}]}]]], "Output",
 CellChangeTimes->{{3.729482118012586*^9, 3.729482142471738*^9}, {
   3.729482209898488*^9, 3.729482213364962*^9}, {3.7295378500875483`*^9, 
   3.729537854723792*^9}, 3.7295399392278347`*^9, 3.7295408333273153`*^9, 
   3.7297609593944407`*^9, 3.7297609958232*^9, {3.729761032448058*^9, 
   3.729761057564467*^9}, 3.793999153386944*^9, 3.793999268859235*^9, 
   3.79399941422303*^9, 3.823228419861924*^9},
 CellLabel->
  "Out[2346]=",ExpressionUUID->"878a7e28-584b-4dd4-bb5f-df0aea75f71f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox[
    SubscriptBox["p", 
     RowBox[{"L", ",", "0"}]], 
    SubscriptBox["p", 
     RowBox[{"L", ",", "1"}]]], "/.", "param"}], "//", "Simplify"}]], "Input",\

 CellChangeTimes->{{3.7295378878492393`*^9, 3.72953793603934*^9}},
 CellLabel->
  "In[2347]:=",ExpressionUUID->"d49adf8d-6eac-42f8-9955-255eb0b295ee"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   SuperscriptBox["\[ExponentialE]", "f"], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", " ", "f"}]], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"5", " ", "f"}], "/", "2"}]]}], 
  RowBox[{"1", "+", 
   SuperscriptBox["\[ExponentialE]", "f"], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"3", " ", "f"}], "/", "2"}]], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", " ", "f"}]]}]]], "Output",
 CellChangeTimes->{{3.729537900651737*^9, 3.729537937354435*^9}, 
   3.729539939448942*^9, 3.7295408334413023`*^9, 3.7297609595549507`*^9, 
   3.729760996092144*^9, {3.7297610325628433`*^9, 3.7297610577174053`*^9}, 
   3.793999153392374*^9, 3.7939992688648443`*^9, 3.7939994142290916`*^9, 
   3.823228419866762*^9},
 CellLabel->
  "Out[2347]=",ExpressionUUID->"463fe46f-bfd7-414c-9da8-192dc269512b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"J", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Jmat", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "3"}], "]"}], "]"}], "/.", "param"}], "//", 
     "Simplify"}], "//", "ExpToTrig"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.729473391220943*^9, 3.729473421807062*^9}, {
  3.729477771574553*^9, 3.7294777718844557`*^9}},
 CellLabel->
  "In[2348]:=",ExpressionUUID->"18d97c4d-5623-47aa-8206-37aff939fd55"],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sinh", "[", 
   FractionBox[
    RowBox[{"3", " ", "f"}], "2"], "]"}], 
  RowBox[{"2", "+", 
   RowBox[{"Cosh", "[", 
    FractionBox["f", "2"], "]"}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"Cosh", "[", "f", "]"}]}], "+", 
   RowBox[{"Cosh", "[", 
    FractionBox[
     RowBox[{"3", " ", "f"}], "2"], "]"}]}]]], "Output",
 CellChangeTimes->{{3.729473395864974*^9, 3.729473422202367*^9}, 
   3.729477163730941*^9, {3.729477212452183*^9, 3.72947722840238*^9}, 
   3.729477773335025*^9, 3.7294784432683887`*^9, 3.729478711835328*^9, {
   3.729478798828952*^9, 3.729478810747575*^9}, 3.729482089523082*^9, 
   3.729539939585548*^9, 3.729540833677952*^9, 3.729760959621766*^9, 
   3.729760996657586*^9, {3.729761032796858*^9, 3.729761057833907*^9}, 
   3.793999153420805*^9, 3.7939992688928347`*^9, 3.793999414258336*^9, 
   3.823228419888425*^9},
 CellLabel->
  "Out[2348]=",ExpressionUUID->"f0525260-abb5-4d05-a39f-8028d8bc7229"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"J", "/.", "param"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.729479742313394*^9, 3.729479769007131*^9}},
 CellLabel->
  "In[2349]:=",ExpressionUUID->"b36d020d-5074-494b-8549-6ecd8c7c4e7f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"3", " ", "f"}], "16"], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["f", "3"]}], "512"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "f", "]"}], "5"],
    SeriesData[$CellContext`f, 0, {}, 1, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`f, 0, {
    Rational[3, 16], 0, 
    Rational[-3, 512]}, 1, 5, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.729479753439446*^9, 3.7294797694352922`*^9}, 
   3.7294820901868763`*^9, 3.729539939718933*^9, 3.729540833791584*^9, 
   3.729760959720553*^9, 3.7297609968923807`*^9, {3.729761033013582*^9, 
   3.7297610579540997`*^9}, 3.793999153428894*^9, 3.793999268898354*^9, 
   3.7939994142647457`*^9, 3.8232284198935337`*^9},
 CellLabel->
  "Out[2349]=",ExpressionUUID->"d30baa8b-dc37-4e0b-89ba-2ffae5664637"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Si", ",", 
      RowBox[{"3", "f", " ", "J"}]}], "}"}], "/.", "param"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "0", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7292860182551107`*^9, 3.729286052878934*^9}, {
  3.729479495382018*^9, 3.729479501435994*^9}},
 CellLabel->
  "In[2350]:=",ExpressionUUID->"0ac001a1-9219-4cf8-bd2b-c408aad2bb16"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"9", " ", 
       SuperscriptBox["f", "2"]}], "16"], "-", 
     FractionBox[
      RowBox[{"9", " ", 
       SuperscriptBox["f", "4"]}], "512"], "+", 
     FractionBox[
      RowBox[{"339", " ", 
       SuperscriptBox["f", "6"]}], "81920"], "-", 
     FractionBox[
      RowBox[{"19799", " ", 
       SuperscriptBox["f", "8"]}], "18350080"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "f", "]"}], "9"],
      SeriesData[$CellContext`f, 0, {}, 2, 9, 1],
      Editable->False]}],
    SeriesData[$CellContext`f, 0, {
      Rational[9, 16], 0, 
      Rational[-9, 512], 0, 
      Rational[339, 81920], 0, 
      Rational[-19799, 18350080]}, 2, 9, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"9", " ", 
       SuperscriptBox["f", "2"]}], "16"], "-", 
     FractionBox[
      RowBox[{"9", " ", 
       SuperscriptBox["f", "4"]}], "512"], "+", 
     FractionBox[
      RowBox[{"339", " ", 
       SuperscriptBox["f", "6"]}], "81920"], "-", 
     FractionBox[
      RowBox[{"19799", " ", 
       SuperscriptBox["f", "8"]}], "18350080"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "f", "]"}], "9"],
      SeriesData[$CellContext`f, 0, {}, 2, 9, 1],
      Editable->False]}],
    SeriesData[$CellContext`f, 0, {
      Rational[9, 16], 0, 
      Rational[-9, 512], 0, 
      Rational[339, 81920], 0, 
      Rational[-19799, 18350080]}, 2, 9, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{{3.72928600394174*^9, 3.7292860537161093`*^9}, 
   3.729286098009265*^9, 3.72928623027841*^9, {3.729286367767356*^9, 
   3.729286428586031*^9}, {3.729286475489118*^9, 3.729286492968286*^9}, 
   3.7293895579095182`*^9, 3.729389639350951*^9, 3.729389698480034*^9, 
   3.729390012137319*^9, 3.7293900491239233`*^9, {3.729392617600127*^9, 
   3.729392633916597*^9}, 3.729460947771783*^9, 3.729465853790489*^9, 
   3.7294687606494293`*^9, 3.7294722490905724`*^9, 3.729477168051384*^9, {
   3.729477222273347*^9, 3.729477232396*^9}, 3.729478443988578*^9, 
   3.72947871206805*^9, {3.729478799057629*^9, 3.729478811614703*^9}, {
   3.729479497469407*^9, 3.729479501784432*^9}, 3.729482090323638*^9, 
   3.729539939835142*^9, 3.7295408339082336`*^9, 3.729760959820306*^9, 
   3.729760997092217*^9, {3.729761033268044*^9, 3.729761058160789*^9}, 
   3.7939991534641314`*^9, 3.7939992689384108`*^9, 3.793999414308076*^9, 
   3.823228419919323*^9},
 CellLabel->
  "Out[2350]=",ExpressionUUID->"9e343dde-1bd1-4a07-bfd6-bf1bce37ca51"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"pL", ",", "pR", ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["p", 
          RowBox[{"L", ",", "0"}]], ",", 
         SubscriptBox["p", 
          RowBox[{"R", ",", "0"}]], ",", 
         SubscriptBox["p", 
          RowBox[{"L", ",", "1"}]], ",", 
         SubscriptBox["p", 
          RowBox[{"R", ",", "1"}]]}], "}"}], "//", "MatrixForm"}], ",", 
      RowBox[{"Jmat", "//", "MatrixForm"}]}], "}"}], "/.", "param"}], "/.", 
   RowBox[{"f", "\[Rule]", 
    SubscriptBox["f", "0"]}]}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.7263202130531187`*^9, 3.726320223053371*^9}, {
   3.7263203334049473`*^9, 3.726320415646695*^9}, {3.72632055546109*^9, 
   3.726320561499506*^9}, {3.72632075888332*^9, 3.726320778854374*^9}, {
   3.726321994841851*^9, 3.7263219954006567`*^9}, {3.7263220315134163`*^9, 
   3.726322033064629*^9}, {3.726322113840827*^9, 3.726322131496352*^9}, {
   3.72632229820037*^9, 3.726322325847584*^9}, {3.7263310580421553`*^9, 
   3.726331078306553*^9}, {3.726331777780848*^9, 3.726331809594224*^9}, {
   3.726331844107604*^9, 3.726331862928577*^9}, 3.726331929193636*^9, 
   3.726332034432887*^9, {3.7263326088312693`*^9, 3.726332647332398*^9}, {
   3.72633372660749*^9, 3.726333728269041*^9}, 3.7263341902639837`*^9, {
   3.726334224619954*^9, 3.7263342356014433`*^9}, {3.7263363289177723`*^9, 
   3.726336329475668*^9}, {3.72633718573219*^9, 3.726337221298016*^9}, {
   3.726337260900956*^9, 3.726337288112852*^9}, 3.726338108096755*^9, 
   3.726338158514575*^9, 3.726338228174549*^9, {3.7263382619968224`*^9, 
   3.726338284860149*^9}, 3.726339789338756*^9, {3.7263402063958607`*^9, 
   3.72634039325876*^9}, 3.726341036821677*^9, {3.726341565273356*^9, 
   3.726341567022767*^9}, {3.72634163796247*^9, 3.726341689616294*^9}, 
   3.726342273584888*^9, {3.726342310355088*^9, 3.726342311642383*^9}, 
   3.726370397447513*^9, {3.7263711984241037`*^9, 3.726371225635976*^9}, {
   3.726371256820113*^9, 3.726371324696147*^9}, {3.7263716895716133`*^9, 
   3.7263717589657516`*^9}, {3.7291891086914988`*^9, 
   3.7291891107785482`*^9}, {3.729189242345006*^9, 3.729189247755095*^9}, {
   3.729275365335099*^9, 3.7292753679659147`*^9}, {3.7292755497930183`*^9, 
   3.729275552704114*^9}, {3.729275656333767*^9, 3.729275680468896*^9}, {
   3.7292782307413177`*^9, 3.729278307281104*^9}, 3.729278430910557*^9, {
   3.7292784814466248`*^9, 3.729278487114079*^9}, {3.729282295627068*^9, 
   3.729282302744273*^9}, {3.729282370897874*^9, 3.729282395218605*^9}, {
   3.7292824426066628`*^9, 3.7292824563005342`*^9}, {3.729282495521352*^9, 
   3.729282496968667*^9}, 3.7292826848816032`*^9, {3.72928394111679*^9, 
   3.7292839711995087`*^9}, {3.7292845309214697`*^9, 3.729284533501461*^9}},
 CellLabel->
  "In[2351]:=",ExpressionUUID->"fb68e52e-56ed-4569-a571-ac4ee4bd1ac1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9868777714622652`", ",", "0.013122228537734815`", ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0.9802724517705507`"},
        {"0.006561113265428607`"},
        {"0.006605319691714562`"},
        {"0.006561115272306184`"}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", 
        RowBox[{"-", "0.973711338505122`"}], "0.9737113385051223`", "0.`"},
       {"0.973711338505122`", "0.`", "0.`", 
        RowBox[{"-", "0.973711338505122`"}]},
       {
        RowBox[{"-", "0.9737113385051223`"}], "0.`", "0.`", 
        "0.973711338505128`"},
       {"0.`", "0.9737113385051221`", 
        RowBox[{"-", "0.973711338505128`"}], "0.`"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{{3.726337292609529*^9, 3.726337297990902*^9}, 
   3.726337657079069*^9, 3.7263378822707367`*^9, 3.72633813017559*^9, {
   3.726338228861957*^9, 3.726338285515658*^9}, 3.726338440786662*^9, 
   3.726339798083467*^9, {3.72633983969691*^9, 3.726339857944339*^9}, 
   3.726340118600472*^9, {3.7263401893636293`*^9, 3.726340411093124*^9}, 
   3.7263404686102457`*^9, 3.726340546475191*^9, 3.726340605732421*^9, 
   3.7263406373879623`*^9, 3.7263406707887917`*^9, 3.726340947085951*^9, 
   3.726340992049884*^9, 3.726341043268446*^9, 3.7263411783467073`*^9, 
   3.726341550783238*^9, 3.726341625559166*^9, {3.7263417330878553`*^9, 
   3.726341758723795*^9}, 3.726341884910557*^9, 3.726341933786343*^9, 
   3.726341969641611*^9, 3.7263422842976923`*^9, 3.726342315100305*^9, 
   3.726342431406405*^9, 3.726370472938246*^9, 3.72637073902946*^9, 
   3.7263707693153143`*^9, 3.7263708604959583`*^9, 3.726371018633518*^9, 
   3.726371057570209*^9, {3.7263711272888527`*^9, 3.7263711653049097`*^9}, {
   3.7263712047605143`*^9, 3.726371231427902*^9}, 3.726371266402753*^9, {
   3.726371298839415*^9, 3.726371327210478*^9}, {3.726371625107724*^9, 
   3.726371636433936*^9}, 3.726371763544979*^9, 3.7263721195639677`*^9, 
   3.726384579569928*^9, 3.729187205981*^9, {3.729189114184792*^9, 
   3.729189134010515*^9}, 3.7291892513171167`*^9, 3.72927547514421*^9, {
   3.729275557759183*^9, 3.729275613661051*^9}, {3.7292756696414003`*^9, 
   3.729275683331102*^9}, {3.729278262454605*^9, 3.729278325457058*^9}, {
   3.7292783736310787`*^9, 3.729278390552945*^9}, 3.72927843417735*^9, 
   3.729278497515892*^9, {3.729282102204886*^9, 3.72928213168077*^9}, {
   3.729282279576344*^9, 3.729282323730983*^9}, {3.729282362402218*^9, 
   3.729282396057317*^9}, {3.729282443397458*^9, 3.729282456923164*^9}, {
   3.72928254257992*^9, 3.729282567330267*^9}, {3.729282614206923*^9, 
   3.729282652248508*^9}, 3.729282688616222*^9, 3.7292828684414253`*^9, {
   3.729282920375243*^9, 3.729282958003393*^9}, 3.729283677835269*^9, 
   3.729283754043518*^9, 3.729283869802339*^9, {3.72928394744447*^9, 
   3.729283984313168*^9}, 3.729284289356709*^9, 3.7292844271304293`*^9, 
   3.7292845753998947`*^9, 3.729284686288845*^9, 3.729284878432436*^9, 
   3.729285413478825*^9, 3.729285556910242*^9, 3.729285762974305*^9, {
   3.7292858850545483`*^9, 3.729285939769351*^9}, 3.729286098141267*^9, 
   3.729286230412587*^9, {3.729286368019965*^9, 3.729286429124112*^9}, {
   3.729286475634513*^9, 3.729286493117997*^9}, 3.729389558227725*^9, 
   3.729389639517807*^9, 3.729389698825778*^9, 3.729390012267438*^9, 
   3.729390049526823*^9, {3.729392617762066*^9, 3.729392634068015*^9}, 
   3.729460947891139*^9, 3.729465853912928*^9, 3.729468760774104*^9, 
   3.729477168249061*^9, {3.7294772223858833`*^9, 3.72947723259451*^9}, 
   3.729478444135461*^9, 3.7294787121880293`*^9, {3.729478799161147*^9, 
   3.7294788117648077`*^9}, 3.729482090456066*^9, 3.7295399399719143`*^9, 
   3.729540834020166*^9, 3.72976095993699*^9, 3.729760997173967*^9, {
   3.729761033381049*^9, 3.729761058286779*^9}, 3.793999153472747*^9, 
   3.793999268977397*^9, 3.793999414359811*^9, 3.8232284199491262`*^9},
 CellLabel->
  "Out[2351]=",ExpressionUUID->"12653b26-cc87-47c1-a9b3-d89e42b571c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["p", 
          RowBox[{"L", ",", "0"}]], ",", 
         SubscriptBox["p", 
          RowBox[{"R", ",", "0"}]], ",", 
         SubscriptBox["p", 
          RowBox[{"L", ",", "1"}]], ",", 
         SubscriptBox["p", 
          RowBox[{"R", ",", "1"}]]}], "}"}], "/.", "param"}], "//", 
      "ExpToTrig"}], "//", "Simplify"}], "//", "MatrixForm"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"pL", ",", "pR"}], "}"}], "/.", "param"}], "//", "ExpToTrig"}],
     "//", "FullSimplify"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.729284613995852*^9, 3.729284644423373*^9}, {
   3.72928548022666*^9, 3.729285501963089*^9}, {3.72928566222468*^9, 
   3.729285692182612*^9}, {3.729285725510297*^9, 3.729285737182891*^9}, 
   3.7294670140985327`*^9, 3.729468737879657*^9, {3.729479623139064*^9, 
   3.72947965524975*^9}},
 CellLabel->
  "In[2352]:=",ExpressionUUID->"43dbc811-464e-4102-82ab-62496199fa77"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Cosh", "[", 
              FractionBox["f", "4"], "]"}], "+", 
             RowBox[{"Sinh", "[", 
              FractionBox["f", "4"], "]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Cosh", "[", 
              FractionBox["f", "4"], "]"}], "+", 
             RowBox[{"Cosh", "[", 
              FractionBox[
               RowBox[{"3", " ", "f"}], "4"], "]"}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"Cosh", "[", 
               FractionBox[
                RowBox[{"5", " ", "f"}], "4"], "]"}]}], "-", 
             RowBox[{"Sinh", "[", 
              FractionBox["f", "4"], "]"}], "+", 
             RowBox[{"Sinh", "[", 
              FractionBox[
               RowBox[{"3", " ", "f"}], "4"], "]"}]}], ")"}]}], 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             RowBox[{"Cosh", "[", 
              FractionBox["f", "2"], "]"}], "+", 
             RowBox[{"4", " ", 
              RowBox[{"Cosh", "[", "f", "]"}]}], "+", 
             RowBox[{"Cosh", "[", 
              FractionBox[
               RowBox[{"3", " ", "f"}], "2"], "]"}]}], ")"}]}]]},
        {
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Cosh", "[", 
              FractionBox["f", "4"], "]"}], "-", 
             RowBox[{"Sinh", "[", 
              FractionBox["f", "4"], "]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Cosh", "[", 
              FractionBox["f", "4"], "]"}], "+", 
             RowBox[{"Cosh", "[", 
              FractionBox[
               RowBox[{"3", " ", "f"}], "4"], "]"}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"Cosh", "[", 
               FractionBox[
                RowBox[{"5", " ", "f"}], "4"], "]"}]}], "+", 
             RowBox[{"Sinh", "[", 
              FractionBox["f", "4"], "]"}], "-", 
             RowBox[{"Sinh", "[", 
              FractionBox[
               RowBox[{"3", " ", "f"}], "4"], "]"}]}], ")"}]}], 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             RowBox[{"Cosh", "[", 
              FractionBox["f", "2"], "]"}], "+", 
             RowBox[{"4", " ", 
              RowBox[{"Cosh", "[", "f", "]"}]}], "+", 
             RowBox[{"Cosh", "[", 
              FractionBox[
               RowBox[{"3", " ", "f"}], "2"], "]"}]}], ")"}]}]]},
        {
         FractionBox[
          RowBox[{"1", "+", 
           RowBox[{"Cosh", "[", 
            FractionBox["f", "2"], "]"}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"Cosh", "[", "f", "]"}]}], "+", 
           RowBox[{"Sinh", "[", 
            FractionBox["f", "2"], "]"}]}], 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             RowBox[{"Cosh", "[", 
              FractionBox["f", "2"], "]"}], "+", 
             RowBox[{"4", " ", 
              RowBox[{"Cosh", "[", "f", "]"}]}], "+", 
             RowBox[{"Cosh", "[", 
              FractionBox[
               RowBox[{"3", " ", "f"}], "2"], "]"}]}], ")"}]}]]},
        {
         FractionBox[
          RowBox[{"1", "+", 
           RowBox[{"Cosh", "[", 
            FractionBox["f", "2"], "]"}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"Cosh", "[", "f", "]"}]}], "-", 
           RowBox[{"Sinh", "[", 
            FractionBox["f", "2"], "]"}]}], 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             RowBox[{"Cosh", "[", 
              FractionBox["f", "2"], "]"}], "+", 
             RowBox[{"4", " ", 
              RowBox[{"Cosh", "[", "f", "]"}]}], "+", 
             RowBox[{"Cosh", "[", 
              FractionBox[
               RowBox[{"3", " ", "f"}], "2"], "]"}]}], ")"}]}]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "f"}]], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", "f"], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"f", "/", "2"}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", "f"]}], ")"}]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"Cosh", "[", 
          FractionBox["f", "2"], "]"}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"Cosh", "[", "f", "]"}]}], "+", 
         RowBox[{"Cosh", "[", 
          FractionBox[
           RowBox[{"3", " ", "f"}], "2"], "]"}]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"2", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "f"}], "/", "2"}]], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "f"}]]}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "f"}], "/", "2"}]], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", "f"]}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"Cosh", "[", 
          FractionBox["f", "2"], "]"}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"Cosh", "[", "f", "]"}]}], "+", 
         RowBox[{"Cosh", "[", 
          FractionBox[
           RowBox[{"3", " ", "f"}], "2"], "]"}]}], ")"}]}]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.7292846159940042`*^9, 3.7292846473141317`*^9}, 
   3.729284686476736*^9, 3.729284879492242*^9, 3.729285414428384*^9, 
   3.7292855037638893`*^9, 3.729285558063313*^9, {3.729285670828454*^9, 
   3.729285693764538*^9}, {3.729285738433613*^9, 3.729285763940303*^9}, {
   3.729285886210823*^9, 3.729285941057871*^9}, 3.729286099366828*^9, 
   3.72928623168504*^9, {3.72928636934378*^9, 3.729286430412013*^9}, {
   3.729286476835475*^9, 3.729286494566966*^9}, 3.7293895595561113`*^9, 
   3.7293896413056087`*^9, 3.729389700459934*^9, 3.729390012577012*^9, 
   3.729390051251306*^9, {3.729392619638962*^9, 3.729392634213736*^9}, 
   3.729460948021102*^9, 3.729465854147225*^9, {3.729468741592804*^9, 
   3.7294687608907022`*^9}, 3.729477169127645*^9, {3.7294772232714653`*^9, 
   3.729477233529752*^9}, 3.729478445002788*^9, 3.7294787124936743`*^9, {
   3.729478799300438*^9, 3.729478812786127*^9}, {3.729479627418436*^9, 
   3.7294796571885643`*^9}, 3.729482090607298*^9, 3.729539940960904*^9, 
   3.729540834952195*^9, 3.729760960563651*^9, 3.729760997499943*^9, {
   3.729761033562851*^9, 3.729761058943799*^9}, 3.7939991538328257`*^9, 
   3.793999269345049*^9, 3.7939994147222843`*^9, 3.823228420340023*^9},
 CellLabel->
  "Out[2352]=",ExpressionUUID->"07d457e5-6f64-4570-a396-27b7defc618f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"pvec", "/.", "param"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.72938980392776*^9, 3.72938994098538*^9}, {
   3.729466897386763*^9, 3.729466905542021*^9}, 3.729477616264656*^9, {
   3.729540512597699*^9, 3.7295405179246483`*^9}},
 CellLabel->
  "In[2353]:=",ExpressionUUID->"7064f184-0b0a-43d4-822b-00f2d8186393"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVzWs01AkYBvCxqDVujWJzmZs/TU1lu+1u2ep9lz27lWHVoBM1RW5tLnHY
I3RzWUmYSolWQtrUpnRkk6Uak7tpXCpiZWcMZpj5J00u2ezsh+c853eeDw87
IHJX0GcUCsVdl/+74HjAgrWBGVv7HTKWUChSEHexeLtZhyAkZsLtTwMpzDfU
JbNYR4EqN5o9YiSFgieZTENWOmzxpD4cs5BC2JbY8ClmHpTWCm99cpRC18fQ
nLfMMrhY5tyTx5PCwj4ZR82sBluzF7RrV6RQ1FIYNcZshnE2vbUKO6D8bnpf
mNNr2OqXXOUo7oQQ6Mgbj5aD6aRAsZjXDRGKFfLKciWYh7sNFA++ACo7hfNm
41ugO+7af7r0FWQtauUWHZgEvW5eZ9yuXgjo83qs3/YBjJrX1W926IOoZykB
kZxZWMC71rJD1Q8VR0z4S7f/Cw+Hb19PPzsARQmHVWt2U3CE4aHydByEpMK5
ne/H9bC999tjWRODQOkaxL/i9ZHq5ZdQ9eAfWBYTHOfFNcTtmwNd7qXKYEib
62NcuwBlDcOOahc57FD8fOx81Oe4fi5s+jh1CDyGhCsZDCpGC5kX45uGQFUf
cLLpjjFS7W2vWsQowIn2ku663xTfjKQPN3GGgQpa//5JM3xsCm3QPAw/qn2n
7L0Xoekp+2TrqBHoEQXq+a6i4aYB/s04s1F4cFosYGlp+L6gz+B4/igEG8YO
SiQW2FiRq2zgKuFgdMIDk/zFKLYRMffdUsKXISslPP8lGFPYEy1iqeC5xSrj
2E2WGLTyobo+TwU15UlXVulbYYOHUtGmPwYJelzPtr+t8EzlgWhB5BhQ++O3
RVR+gUcOVz2r6RgDxQ12TmHiUvRasmGZM2cccpZbG1R7WyPRf/a+/7FxEOYH
N/qzbLDJnf56tHEcfHP2SUxGbNC9Vc6vNFbD9PelM4V1tpgbTkv54yc1yBUu
caI0O2zLVMtYZ9RQvGWtbbs/Ha+a6187JFbDndRYWshqBt7sdQze+0ENad4H
3fS1DExz4teEEhr4qr+oLK2difIfDjU5eWrg8oord9rdWFjBd6kJ/kUDJ55k
XnarZmGgIWm18TcNuNt6l7Y4sFHQXfx4rlYD30U0+tHS2biwfoNl9WsNFNoF
OLRp2WiqIHptpzTgUP/7JQ8/eyxeLhF8Y06CcLWI21lnj66i8z4tDiQETxp0
NHMJHFiYZWPpTEJAxTtWejaBU2bTo2weCWFJ/Lkd5wiUJCc9jdA5ll/5yuQC
gawWu/ganU9rY7OElwj0fXU/w8udhPJNMx9zCwhc5y1am+pBwszT+Zc3bhPo
SuHlDHrq/jtNMsWNBL7ztjQ66U1Cfkl46K/NBI5mp31s0rkkRuK6rZXAR8pz
z2k+JFRZCWdbJQSuV1+1K9G533dxaNcLAgWKUTfxbhI4cmtXmZzA4uzrRnq+
JKypjGdcVxDoc9TJdpvOzql9M0EjBEaGmpln68zjFNxTqgj8hPMFdn4kRB9m
MSYmCPTcM77n670kJG4+NXN/ksCj1IgTiTqnmsq6Y7QEruaWpIl0vny3JGN6
mkAnug967COh+KRByKNZAmutx95e0Pn2ziCXxDnd3uOf0qtzpX0DfesnAstk
z2YZAhLqJpfNzM8TyH1i7xWo83/rikp3
       "]], LineBox[CompressedData["
1:eJwVkns0lAkchl2ro2GjdiLMDJ/ckstpbduWfr/oKrQSSraYDEoXHNT6ZrYa
JiQZJcRqkpDktjtEIYZGbjMHZYU9FeY4ke0yRkZq1v7xnufv5zmvGfPMfpaG
mpqa5+L+Z/7vzCVOIalbS2rfDqhUUmjrZ3j4M45Dg0jslzUrBZW4KYHB+A1W
33MWO01LIb85ja7NSAGHxI9nzw5J4aRL7KnP9JtgIAt13Vojhf4v4Zkf6KVw
b3PqxkcRUlg6PGo1Ta8HqUJ7e+SIBAo6BVFT9A7gvDTte9PdAxWVKcMn7Yeg
ZvIpL7m1C8Kg9+a76DFoYe/fWWzTCadlNmPCirdQ6c2j3nr+DHTMEq1e/fQB
nMf37arNboerK7psC4LkYPBpx3utTDEwhw880eyehVXjQZHizKcQ9TSRecZq
HmrUpnSu3W+D6kiKj+Ger6B2ixnIGmyFAjJi0tFfDWsv9+gZK0XAFSx4z7xT
x0BLRWOerQjU+l9jQ7wmTu4yOzIR1AKWMaHnDthqY2LaQy73UjOMK7L9ljcu
QS6dMloZ9wTcZSc416KWYUCkpKCxuRG8xvnraDQdrDOkkzPUBphsZV54Vr4c
D8iWJGxIfwT2+gOmbkd1UeVTuEMxXQc6oAgekeuh6M2EyD/qIeyaDvhs7rsC
v20uo7q9roFBUYh6gJ0+DrmmRyQeE0JNctsRhkIfR9R3llvr/gWh2rGvJRID
/OJucYlSWg3HoskaSu5K5B52uX8+ogocwtZJPIJX4eAUr/0MrwKkBnbLYzd9
j1XCFw96zR/A4wpunp0mFXtt94TnLbsPpLrtL93/UDHQpL+9ZawEdEbid58W
rkY9L35l3FQRyIrNMgVsQ5R1nNU5suEuZFobadX7GqFDhswE4+4APze0PZix
BvFoQsd7+W0IyPxVQplYg4XcDr2VVgKY216kFDQZo5dl5eht5h8wJnM9J0oy
wbr5i0v/Vd2EOy5Oxj3BptgArnGP87OhnBerH7aehku/3vgkzbgBSb7H9moq
aDj87GUxr+46OI8UlCb10JFmzPIMf5MBOTZ55T17GRiev1Hw0IsP55vTcvbW
M3BjPsOOdz4NPI19izotzDBkQDa4pfYybDvdflg/xQwrFOZlpX7JIDBhWnQr
zDBrx0z7zFceWLSWZHkdNkd3ayU1WJUA/PUi274mc5Q/KLll8SMXQuVavR22
BFbZO5zIib4AzOpPjJR0Ag+u1a6znuDASa7PgnsGgasD/a6cGOJArI/wb8p1
AjXSaUXVPRxIVsRe5WcR+Pn9u7x9Qg5UbFJ+yc4n0N0ni9V5kQPKFtVAcRmB
zU7ywnpTDvD7KGlt7QRW6KaIIw+xIbfwVPilDmLxrzFu/p5sKIyRuO3uIjCm
aazNdRsbaqn8+S4JgZbenB5rGzaMBKwM739BIB5Sf+KoJMFqzMhtdIxAI5e7
kfa5JDgK42l3ZQTOGfI9Qq6S8DNvWMmaIJDboKkn4JLgYZVf9XaSQGeNoU1E
BAnREQzax48ELvh1q1hbSGBvuaj8U77oU0P2iRxJ4OmOPo9REEjMR5MWa0nI
qSxMnZsj8LuEot2zuiTcuaAV9miewKRUw+OhGiSUebNc2QsEGqi7HRyejQeh
udh067fFHkGuq3yn4qFJbqlUqQhs6/whr/9VPPwHjdlGMg==
       "]], 
      LineBox[CompressedData["
1:eJwV1Xk0VXsbB3AcTaYbUrgch2NIJIlI8WyUIslMVIaMEfIiOcgt40UdQhok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       "]], LineBox[CompressedData["
1:eJwVi38803kcx4d+GTrDdX7OjPkV4Vxdit6fWo/OlVAsd3p0mMwuUXakbEpK
UmjKhdUeQyjRRCOctBAx9s2Pc9V0qdm5xCPF1KR23/vj/Xg9no/n823HPLQ7
RpdAIITg9/8KjzOXee0/vylgYud7rRaDziFKQBjlVwiIOnL86SIG2q62UxTK
MZASIyliDQZCaa7tUko2lLQXN/rPYnDQLzn+g20xhDJolfR/MBj6xC6Ysa2C
J+amSaEyDJYrXjlN2zbDCpKZt+5FDEp7RYlvbHug6WK7abkJBnNFDa4vcnqg
U9AbbrQSg22xMuWgpgfmFvt3c/QxmNL7wGgZ6gUzlR7Hg4DBer/ADdlZfZD0
sMw7ZVoOj2sXdZ3eYlBDNdeld8vhRK/bdq+IIQhtjNn2JUUO4tpsxcE1z2BM
TPW9gvVDLAwUT3GU8JO6a30Trw8SVC5Kifg1jHVeZt2lyoBod9rpxfoZuDES
dJ8s7oE8Y5lraeQslOxqDeuOeARMReh9vb55yNn97Vdj+t2Q+PA085DTAhie
pLfqP34IdYcNQ8x//AxTk35n9t7rhFJu3KRnGAHN+KYmsss7IEO0uGtuSgfV
XN16zru6HQhDY6g1VQ81CU0L+qQPwDGJdTTUdSmqGXmbkSKTwri6cI/BvWWI
sM+W5qy4D9tVB9IuJq5AxnoRFgeWt0HgOH81mUxERewHgyL/VpjsYKY/umWA
PHU+idvqW2ANacSGHmGEbki1QTnLmoEI6qjR2ZXoX5/HZfUZd+GH6fAPVIYx
8n9n42411QBP2vfrhLuREFqLiUVxEmg42/kLRU1CT0ZO/T1scgdYS5PH5HIT
5OyI2MqaOojmcBsMBabo8LnnHOeE2+ARu1oeEGWGZuI3suyzxYCZuBkk+3yN
jAeMK4JoNfCHOOOKm94qFOxy4VgI8SZwdVyD+56vQjNV37Enxq8DcTTVP0Hy
DeKXud7cOFUBqkq7AhHPHPGnqi+ovMuhwNliSTPDAt0OIgYKjpQBX8DqjqJY
oplj1yPc50ogvGCf3HDCEqFuXn2skwg+bq3QiNqsUMlGsuNT5lVQqrYcbc+y
RmMLVvFmBAGU+XlZ9UfZoJLq89iwsBBuZSaTYt3JKDLakvoy/3fIYkTv0FOT
ESVLn5nfdAnWjpZWZfXbIum6YsPDL/OhyOXKrf4dFEQR1Y61BvLhhDS3aEcz
BaXf8TXJOZELO60YFb0OdijdegN7c+M52JzQvZeUjTPZqLNmz1kQWTMd+tR2
CFXpDMx/zgSHjuuXA/dSEeJPHGFqTwHfvd11sI2KCLHWebR1GcCaXTLQ42qP
pN9jy4s56cCse0/JvmCPCIrwXJeJNDiYEbK4Pd8epbv7RMY9S4PkEMlfhpdw
JuWn1PenwVl1ch7/Mt57nIkLlqSB2EfzqVCI+9MCD9nJNNA80I5UVuOeDdEt
NmnAHzTM7ezGfSWJk/gzDwTX4tlnenAuHJwO28mDa0lyur8M7+ssEuibedC4
ir8gk+Pcwk5yceHBaLgpe+hPvA87FOWl4YKT0oL+Somzw29EDwEXPCWp5HIV
3nNCVPvzuLAhU6GJmcCZda9ClMGFACfh7deTOAsyMfs4LnDiKOR37/B/q8R8
li8XeL4nNfWzuDe3j+7w5EKm0avhJDXuu8gGNBoXimqvnf/4EWfLiJF5Iy6U
pS+JbVnAe6FCzdLlQvWumC28RdzbkMYV86kgoXbZbPqCc7CNiPEmFdpmHTVa
Ld5TybThF6nwHyOiYm4=
       "]]},
     Annotation[#, "Charting`Private`Tag$966045#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 9.999999795918367}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.729389818626243*^9, 3.729389941948538*^9}, 
   3.729390014604374*^9, 3.72939005184684*^9, {3.7293926202030582`*^9, 
   3.7293926346471148`*^9}, 3.729460948410568*^9, 3.7294658545046453`*^9, {
   3.729466898277199*^9, 3.729466906295775*^9}, 3.729468761261454*^9, 
   3.729477170334529*^9, {3.729477223970275*^9, 3.729477234530229*^9}, 
   3.729477617137659*^9, 3.7294784455585814`*^9, 3.729478712870226*^9, {
   3.7294787996456127`*^9, 3.729478813353327*^9}, 3.729482091037034*^9, 
   3.7295399416098824`*^9, {3.729540514255934*^9, 3.729540518741309*^9}, 
   3.729540835498879*^9, 3.729760961179617*^9, 3.729760998636104*^9, {
   3.729761033908968*^9, 3.7297610594132843`*^9}, 3.793999154093543*^9, 
   3.7939992696028223`*^9, 3.793999414982779*^9, 3.823228420707427*^9},
 CellLabel->
  "Out[2353]=",ExpressionUUID->"aeef9990-de26-45c4-ac39-3d4975bcc25c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PlotC", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Si", "/.", "param"}], ",", 
        RowBox[{"SiX", "/.", "param"}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"SiX", "-", "SiY"}], ")"}], "/.", "param"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "0", ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Black", ",", "Red", ",", "Blue"}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "10"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"StyleForm", "[", 
          RowBox[{"\"\<f\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "None"}], 
        "}"}]}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "Nbpoint"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "0"}]}], "]"}]}], ";"}], " ", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PlotD", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"IX", "/.", "param"}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Beta]", "*", 
           RowBox[{"(", 
            RowBox[{"f42", "+", "f13", "+", "f21", "+", "f34"}], ")"}], "*", 
           RowBox[{"Jmat", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "3"}], "]"}], "]"}]}], ")"}], "/.", "param"}], 
        ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"SiX", "+", "IX"}], ")"}], "/.", "param"}], ",", "0"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "0", ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Green", ",", "Pink", ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Gray", ",", "Dashed", ",", 
           RowBox[{"Thickness", "[", "0.003", "]"}]}], "]"}]}], "}"}]}], ",", 
      
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "10"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"StyleForm", "[", 
          RowBox[{"\"\<f\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "None"}], 
        "}"}]}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "Nbpoint"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "0"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"PlotC", ",", "PlotD"}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "800"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.600873067278131*^9, {3.6008731415500174`*^9, 3.6008731457966433`*^9}, {
   3.600873195372828*^9, 3.600873232964985*^9}, {3.600873354020275*^9, 
   3.6008734559046583`*^9}, {3.600873491059741*^9, 3.600873519815102*^9}, {
   3.600873551098178*^9, 3.6008735994392033`*^9}, {3.600873643756525*^9, 
   3.600873645555045*^9}, {3.6008736851035433`*^9, 3.600873685667234*^9}, {
   3.6008737345945044`*^9, 3.6008737566745977`*^9}, {3.600873806107925*^9, 
   3.600873807612256*^9}, 3.600873903235385*^9, {3.600873935107032*^9, 
   3.600873958315402*^9}, {3.6008740515846024`*^9, 3.600874070779147*^9}, {
   3.600874115737012*^9, 3.6008741209140873`*^9}, {3.600874151419623*^9, 
   3.600874232038803*^9}, {3.6008742908154497`*^9, 3.600874291342003*^9}, {
   3.600874775987378*^9, 3.60087481447025*^9}, {3.600875070923313*^9, 
   3.600875194744874*^9}, {3.600875276999358*^9, 3.600875361161314*^9}, {
   3.6008754354345207`*^9, 3.600875583811262*^9}, {3.600875932130945*^9, 
   3.600875944833014*^9}, {3.600954295643971*^9, 3.600954304749229*^9}, {
   3.600955594022891*^9, 3.600955627557008*^9}, {3.600956271058014*^9, 
   3.600956273048936*^9}, {3.600956308140647*^9, 3.6009563164917583`*^9}, {
   3.6009610065443773`*^9, 3.60096103871982*^9}, {3.600961086624976*^9, 
   3.6009612531238937`*^9}, {3.600961422553199*^9, 3.600961432016728*^9}, {
   3.600961779711631*^9, 3.6009617853743267`*^9}, {3.600962715908515*^9, 
   3.600962716830619*^9}, {3.600973304818738*^9, 3.6009733052263947`*^9}, {
   3.7263027707511873`*^9, 3.726302785089587*^9}, 3.726302839219811*^9, {
   3.726308022094736*^9, 3.726308041350028*^9}, {3.726308265126855*^9, 
   3.726308308867942*^9}, {3.7263083619115667`*^9, 3.726308363109096*^9}, {
   3.726310606973537*^9, 3.7263106819790697`*^9}, {3.726310721011387*^9, 
   3.7263107340764227`*^9}, {3.72631089080556*^9, 3.72631102512253*^9}, {
   3.726311066758808*^9, 3.7263110891955223`*^9}, {3.726311135054701*^9, 
   3.726311136869658*^9}, {3.726311177189417*^9, 3.7263112730371923`*^9}, {
   3.726311443466927*^9, 3.7263114711323442`*^9}, {3.72631152673919*^9, 
   3.726311540059099*^9}, {3.726311688812376*^9, 3.726311704876639*^9}, {
   3.726311809774551*^9, 3.726311846970561*^9}, {3.726319625402527*^9, 
   3.726319626753093*^9}, {3.726319782570582*^9, 3.726319783139913*^9}, 
   3.72632010634875*^9, {3.726321128864595*^9, 3.726321132010198*^9}, 
   3.7263211714196463`*^9, 3.7263224179664927`*^9, {3.726331257029771*^9, 
   3.726331260109336*^9}, {3.726331619206874*^9, 3.726331628997114*^9}, {
   3.726331955510421*^9, 3.7263320169278803`*^9}, {3.726332302677702*^9, 
   3.726332353690815*^9}, 3.7263324470243187`*^9, {3.726332544228565*^9, 
   3.7263325596806183`*^9}, {3.7263328949631042`*^9, 3.726332928154273*^9}, {
   3.726336251217021*^9, 3.726336251516108*^9}, {3.726336747260599*^9, 
   3.7263367483945103`*^9}, {3.7263373673050623`*^9, 3.726337441122986*^9}, {
   3.726337914174191*^9, 3.7263379453492203`*^9}, {3.72633798216187*^9, 
   3.726338034829447*^9}, {3.72633811908114*^9, 3.726338126702703*^9}, 
   3.726338163307431*^9, {3.7263381949491243`*^9, 3.7263382111306143`*^9}, {
   3.726338246272443*^9, 3.726338252703557*^9}, 3.726338287966983*^9, 
   3.726339794491582*^9, 3.726341570194705*^9, 3.726342276480097*^9, {
   3.726342421284668*^9, 3.7263424226815367`*^9}, {3.726370409301776*^9, 
   3.726370421696903*^9}, {3.729278244341618*^9, 3.729278249362486*^9}, {
   3.7292783394048443`*^9, 3.729278348958308*^9}, 3.729278386835634*^9, {
   3.729282422340767*^9, 3.729282426359685*^9}, {3.7292827067137947`*^9, 
   3.729282740546657*^9}, {3.72928277869899*^9, 3.729282877382946*^9}, {
   3.7292832011301813`*^9, 3.7292832546711884`*^9}, {3.729283307654378*^9, 
   3.729283378028325*^9}, {3.729283693596447*^9, 3.729283702034582*^9}, {
   3.729284074956551*^9, 3.729284149081498*^9}, {3.729286200936007*^9, 
   3.72928621034414*^9}, {3.729389727053722*^9, 3.72938974283097*^9}, {
   3.729465846323107*^9, 3.729465846446858*^9}, {3.729472954636116*^9, 
   3.729472955714944*^9}, {3.729477782974587*^9, 3.729477852922647*^9}, {
   3.7294788653358994`*^9, 3.729478874435749*^9}, {3.729540273585416*^9, 
   3.72954027400707*^9}},
 CellLabel->
  "In[2354]:=",ExpressionUUID->"701f7f2f-30a3-4b8a-851d-a397a7408915"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
          LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAALnIZf1X9gD4AAAAAABAEPXUyJEzW
Kr8/CKDTQksRgT8YlxRRMz3QP/T9VXFSgaI//IgQE2Mg2D8e0gxBSGC0Pxgj
URP3298/N8WaBh62wT+Fcz/jqR/kPy/9FpjYJsw/M4nOPrEJ6D8u8pWKSP/T
P8wz1POcR+w/NYsB0NeI2z9BGf5j3TjwPxx+PLyuBeI/djIOzxgq8j/PyOGI
FnrmPyGW2WZGRfQ/xQuYJczT6z+mE6F/oDz2Py4ZNy6tpvA/Obv5pxMq+D9M
aPDGVY7zP0GtDf14Qfo/Cncq+bjz9j8kuR3TCjX8Pwl8VvzDWPo/fA/p1Y5S
/j9wcoDt5ET+P/HHIvQVMwBAOzdbcEYuAUASFc+9+ioBQBRvxC/6MQNAbQfZ
ndg3AkBaWaQgbn4FQLYGYb7MMgNAlD4r1Hy+B0A5q0b1uUIEQMCjAshBSwpA
xOT0s7NNBUD+ltnhU+gMQDsrIbPDRgZA/yCLA/xwD0DuFqvIzFQHQIkZZL8Q
JRFAjQ+zHuxQCECSMEOQMIUSQDSdg/wXSAlAyaWNMP3oE0AV0LHwPFQKQMTd
jRdZdhVA5A9eJXhOC0B+7E6gWvMWQOz0Z3CsXQxAQzzmFteaGED7bjpD7WcN
QLbqssOsRBpA+fWKVkRgDkAA80tmUdobQDEiOYCUbQ9A9DtpH9eaHUCrrTJ1
fTQQQGnGXTQPRR9AwRQt7ravEECBmWNAtHYgQHROVvJsNRFArZGfE0pgIUCe
jr4WLrIRQA03kSIZPSJAZaFVxms5EkDy93iUSS8jQABAB7vCrBJAAAAAAAAA
JECxvAMs
           "]]},
         Annotation[#, "Charting`Private`Tag$966097#1"]& ], 
        TagBox[
         {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
          LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAALnIZf1X9gD50OIvkoEv0PHUyJEzW
Kr8/lGyCkkoQcT8YlxRRMz3QP/KJM+C9fJI//IgQE2Mg2D+qxrexqVWkPxgj
URP3298/KqgMMQGnsT+Fcz/jqR/kP2y6STKrA7w/M4nOPrEJ6D/DGnBE4N7D
P8wz1POcR+w/Tgto7ftRyz9BGf5j3TjwPw4VLvkt3NE/djIOzxgq8j9siwX5
NEHWPyGW2WZGRfQ/nLVqy4yI2z+mE6F/oDz2P+e23+4XeOA/Obv5pxMq+D/b
czcW/lbjP0GtDf14Qfo/HhbosUuz5j8kuR3TCjX8P1RCLKmQEOo/fA/p1Y5S
/j+UEslATPXtP/HHIvQVMwBAj/Gh/nQD8T8SFc+9+ioBQIQ2K0juBPM/bQfZ
ndg3AkB6Luzank/1P7YGYb7MMgNAMkCMuaGO9z85q0b1uUIEQDQtsgLiGvo/
xOT0s7NNBUBgM1FtA7j8PzsrIbPDRgZAeuuOUS1B/z/uFqvIzFQHQK17PCmm
DQFAjQ+zHuxQCEBWlSGOZW4CQDSdg/wXSAlA890Ms+/SA0AV0LHwPFQKQD64
vnw2YQVA5A9eJXhOC0B/EhIBKN8GQOz0Z3CsXQxAeKfda7iHCED7bjpD7WcN
QFqHwv2mMgpA+fWKVkRgDkBGuz3XVckLQDEiOYCUbQ9A7nqphfyKDUCrrTJ1
fTQQQP6paD8/Ng9AwRQt7ravEECknq08zG8QQHROVvJsNRFAsxxvtuhZEUCe
jr4WLrIRQJLS058wNxJAZaFVxms5EkAV0LEs3ikTQKO6K5a0txJAeg40gtEO
FEBkHuapgzMTQLAUhYQ48RRAw1TPSM+5E0B8F7cAsegVQJiR9wcmNxRAtj28
bS7RFkALoU5S+b4UQBRGJdmCzhdAAfuJ4FJEFUDLI3DQXcgYQG5bBI+3wBVA
pISjKz2yGUB4jq3ImEcWQPxnx494sBpA+ceVIoXFFkD0vfiOOp4bQP1LYsD3
QBdAsv0D0YWHHECfol3p5sYXQK4gogCxhB1At/+XMuFDGEByv7xP1HAeQG0v
AQdYyxhABMugC4NwH0CmqU4fVVAZQCees0KNNSBAVirbV13MGUCrBDfYKaog
QKN9lhviUhpAh/rj/04oIUBn15D/cdAaQK+BEqSznSFAyAO6bn5YG0Dpd9mv
dxwiQK16xyER3htAywqC43KYIkAI+BP1rlocQAAPyXCoCyNAAEiPU8nhHECm
ws1SCIgjQG+eSdLuXx1A9OKHUaT7I0D3xsWitWQdQAAAAAAAACRA52yoSQ==

           "]]},
         Annotation[#, "Charting`Private`Tag$966097#2"]& ], 
        TagBox[
         {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
          LineBox[CompressedData["
1:eJwV0XtUzHkUAPBvhRKV9NBDo5keVgnNRO9+35QesqnpabFmRFk9hEJMmhNJ
0VOmDqapEErrJCa1qzsemag1c9DDKSQ2qbQZTU9T+5s/7rnnc++59/5xqbsP
MPeqIoSCyFDmNYeM08IUXA9l6ZCU75ZMt9zSYQMEYjnqzV8kajIq1g9muEsJ
pC/N8maqws+zS/SizLsI1GdYRXG3AiOLYL2J7g8EMnVZXu3sARmHiU+3Vnwm
RKzy/ru8YGBkvfSoXThAIOHQUgsHFrQx3vy44jtMiGSw5Xt8LHgaz0a9cxol
WGccMtmiJDhC15YY2cgIVi1lRJzIASrvbbTPpjGClR12rkOSDpV65WllbuME
y6K2WrA5E5z/mrqhZzNJcJ2O7+iqPgeeNVqKY57TxDrXEmmwaT5YNpi91lz/
k1gXn/vizeJC4Oh8bc9lzhLrJjrtbPsvwHcxbcyAgTDqqOh5sO8iLDWQPJy2
UcHI70rbjwwexKu/5Xc5qmKcaNBTEVMMwgXspja6GmbZp23N+VYMztU+8oaN
8zB3k+vNvrUl8PTzWF3dr/OxucTe2+WXEnC1pdY98VmAex+bzEZ+KYYRw+qW
tlB13NvDX8nbXww5OnWU4SANXOZ2maraygMH/qmfy/wW4rJ2MTdViwcG0tpR
t1BNjDKsJJdoF+Gzzu9WxwIXYTT31k1AL4LhsZjE2zsXY+6LIo1qygWYSXDx
+hajhdH2qNHm+YUwJc8O92ZpY1Gjo3beTD7Y05y5RfE6mLswPY1xPw+qa+jJ
qQ5LMLfDafCrIAce6duNCO+QPjzUqV12DpICw2Vx63Ux6n/9KCkjC0pzmwzX
3NXF3KECuWZFJuwtD3sW67wUoyTBckFNBlxttOXdqyc95qMbKjsFeyj9t04x
9DDXf3Oof0Q6PAmV+EkaSL86+CT2HhdKCibUrR31MfJXi/2WcxIWlQcyp5pI
x+0p7Ll9AlRmsnqZ3gYY3eMwqnRSIGH7vLx6EeleTifn5RE4llvTUuJriNGw
8OhwThJMiS/SMppJq15vEgkOgSJgt2gCLyP/25V9pC8RBBU7v/Y/I73aMDI0
OAHq54rpH72MMFpMEWazYyF+rYp6ZCvpuPYT6Zx9UHkrcEVYkDF5P1olaHAv
hNt0R+xsI+1gsoP/MAqupvJM+5gmGEkjbAMusyGmM3/uoJT0qEvrJ/4uaFFr
TDgZaYrRgOuqVaY7oOa4mKr7nnTipYca87aBxqSe/M/flmN0VmFtGRcOyC8v
5PlHpQtedv8bAgdK/V+N7DLDSKOerf88GHYTA0WXuklzz1oEdW0F2d37fY/Z
FHJfwLU05y0wtfpx0Ph70qMtx80d/IGfovCvjF6BEav2mtjXB54uMcvsGSKd
rxryd6MX2He6y7QdzMl9KqWalz1ha97p/vijpHHUlf9MCLj5YnA/U6i0/J+s
WlfwsvXSnf6htMUjRZ0T2Mnpig8bqBihVc0h0vXA3LgxJSCZNP4j4MZ+Bjyb
HHCRP1D2h96JTe0hmX7nvOUkae6J8YY9ayC6IAYt20Ajbf+BrWULldvqG3xT
SKPKodb2lUC9bq02W6/0tGLzaisY2mZXKJtR+nzW2lIajDOsvao8LMj5rvbm
GHNwL/A4/YVDGrmUvLc2g1cRI5pRIqV7BlOvGkNZlWhmbk5pBm2B0BD+BzdH
SMo=
           "]]},
         Annotation[#, "Charting`Private`Tag$966097#3"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{False, False},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {
         FormBox[
          TagBox[
           StyleBox["\"f\"", FontSize -> 20], StyleForm[#, FontSize -> 20]& ],
           TraditionalForm], None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{15., 1.5}, {47., 6.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 9.999999873417721}, {-5, 10}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], {188.17354895442207, -137.21427884376777},
      ImageScaled[{0.5, 0.5}], {352.8254042895414, 261.36053113098626}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
          LineBox[CompressedData["
1:eJwBEQXu+iFib1JlAgAAAFAAAAACAAAALnIZf1X9gD5iI4IzgQ/bvHUyJEzW
Kr8/BrIq7ba9Vr8YlxRRMz3QP/LX6Kcbmni//IgQE2Mg2D/IPxLEkACLvxgj
URP3298/UD3rBwphl7+Fcz/jqR/kP1Qjypk1fqK/M4nOPrEJ6D8+5YX1FCiq
v8wz1POcR+w/WLJ4xYLtsb9BGf5j3TjwPz5ZbJmQYbe/djIOzxgq8j/YwGbM
lxS9vyGW2WZGRfQ/JAZgD7T2wb+mE6F/oDz2P4iYlpU8ecW/Obv5pxMq+D9C
uVxGvjXJv0GtDf14Qfo/osXZ2ZaYzb8kuR3TCjX8P5o05QEcANG/fA/p1Y5S
/j9ENzyavI7Tv/HHIvQVMwBA4jI/JBg91r8SFc+9+ioBQNixS6HI49i/bQfZ
ndg3AkCKy0+/Ve3bv7YGYb7MMgNAQK+9BTrp3r85q0b1uUIEQGTVYKXBJuG/
xOT0s7NNBUC88ipY7OTivzsrIbPDRgZABqu581+W5L/uFqvIzFQHQBIA5/tr
fua/jQ+zHuxQCEBifigNalbovzSdg/wXSAlAxr25SsYz6r8V0LHwPFQKQBo8
K7RBSey/5A9eJXhOC0DYfSCuA0nuv+z0Z3CsXQxAtv4yufxA8L/7bjpD7WcN
QNTV60sSX/G/+fWKVkRgDkDsh2t7lG/yvzEiOYCUbQ9A7KXGNtqc87+rrTJ1
fTQQQPigqeMUu/S/wRQt7ravEEA64azx+tf1v3ROVvJsNRFA/pi9+ocR97+e
jr4WLrIRQBgNzM3UOfi/ZaFVxms5EkBqVS98tH75v6O6K5a0txJA+DmPdSCx
+r9kHuapgzMTQFA/eSoR4Pu/w1TPSM+5E0BqKcdjHiv9v5iR9wcmNxRA4PuB
mA5i/r8LoU5S+b4UQJw8Vi3KtP+/AfuJ4FJEFUDILUKZZoEAwG5bBI+3wBVA
ehlJCLEdAcB4jq3ImEcWQHxRxg2OxwHA+ceVIoXFFkCCuDC/YWYCwP1LYsD3
QBdA2C6WdzMCA8Cfol3p5sYXQNgTuo5EqwPAt/+XMuFDGEDk/EMU8EgEwG0v
AQdYyxhAkDQ2UqLzBMCmqU4fVVAZQAS2RNLomgXAVirbV13MGUD4sIGokjYG
wKN9lhviUhpA1AeXufHeBsBn15D/cdAaQKDfmkaeewfAyAO6bn5YG0DKkhUe
ySQIwK16xyER3htATCZQBDnKCMAI+BP1rlocQPoeNWrxYwnAAEiPU8nhHECy
Ej+F4QkKwG+eSdLuXx1AGBwxYR2kCsBiP+iUmtsdQMRXCemjOgvA8rK14sJh
HkB4WNWOJd0LwPkswlD23h5AMsyHKg50DMCdef1JpmYfQOBkYcvGFg3AxBAd
h9zrH0AwVb5ur7UNwDHXPfIONCBANoihVSdJDsBPj4TmbXcgQJy3DVI+6A7A
qMrqalK2IEAsLCjb/HsPwEMrQxH68yBATAjaww0GEMAt9TL93zYhQIwfkTjY
UxDAUkJCeUt1IUCOxERgD5wQwMb46Dr1uCFAaoBzXvLpEMB1Mq+MJPghQGSh
23RQMhHAZpFnABc2IkBmRUDv7XgRwKZZt7lHeSJA1L1qqifFEcAhpSYD/rci
QO67T8D2CxLA61ktkvL7IkBUA7wJVlgSwPYzJkOqPiNARl5lRfeiEsA9kT6E
53wjQJKz6BBI6BLA0lfuCmPAI0DGHOwrHTMTwKCqwPv//yNAij9DjVt5E8C6
cWRv
           "]]},
         Annotation[#, "Charting`Private`Tag$966149#1"]& ], 
        TagBox[
         {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
          LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAALnIZf1X9gD4wxqrjoEsEPXUyJEzW
Kr8/DaDTQksRgT8YlxRRMz3QP/X9VXFSgaI//IgQE2Mg2D8a0gxBSGC0Pxgj
URP3298/O8WaBh62wT+Fcz/jqR/kPzj9FpjYJsw/M4nOPrEJ6D8u8pWKSP/T
P8wz1POcR+w/LosB0NeI2z9BGf5j3TjwPxl+PLyuBeI/djIOzxgq8j/NyOGI
FnrmPyGW2WZGRfQ/wguYJczT6z+mE6F/oDz2PywZNy6tpvA/Obv5pxMq+D9K
aPDGVY7zP0GtDf14Qfo/B3cq+bjz9j8kuR3TCjX8Pwx8VvzDWPo/fA/p1Y5S
/j9ucoDt5ET+P/HHIvQVMwBANzdbcEYuAUASFc+9+ioBQBZvxC/6MQNAbQfZ
ndg3AkBYWaQgbn4FQLYGYb7MMgNAkz4r1Hy+B0A5q0b1uUIEQLyjAshBSwpA
xOT0s7NNBUD7ltnhU+gMQDsrIbPDRgZAACGLA/xwD0DuFqvIzFQHQI0ZZL8Q
JRFAjQ+zHuxQCECRMEOQMIUSQDSdg/wXSAlAyqWNMP3oE0AV0LHwPFQKQL3d
jRdZdhVA5A9eJXhOC0B97E6gWvMWQOz0Z3CsXQxARzzmFteaGED7bjpD7WcN
QLnqssOsRBpA+fWKVkRgDkAA80tmUdobQDEiOYCUbQ9A7jtpH9eaHUCrrTJ1
fTQQQHjGXTQPRR9AwRQt7ravEECCmWNAtHYgQHROVvJsNRFArJGfE0pgIUCe
jr4WLrIRQBY3kSIZPSJAZaFVxms5EkDi93iUSS8jQPQ/B7vCrBJAAAAAAAAA
JECYYwZy
           "]]},
         Annotation[#, "Charting`Private`Tag$966149#2"]& ], 
        TagBox[
         {RGBColor[1, 0.5, 0.5], AbsoluteThickness[1.6], Opacity[1.], 
          LineBox[CompressedData["
1:eJwVjX08E3gcx4cyD3mYPXjc7EHuztLDJhrl92UoLyUc0oMKoVfMQyXcEYWX
mpBIUoTCkIRu4qpDKl0rXu4KpTryQk2uxmZs49wf79fn9f7n86aFxvqFq2Mw
GJ8V/t/1x03TAlTpzg6HAjacMRBvTWBZ7Xxj8wdamx57p70rAplcIfiyt/Uj
ce3xad7tc0h5zhAfRh1CcbwINV3mNWTC8MXPv/uIbjczDqaW1aKsE+hTneU4
6hYcCb/Y04LY5185N2tPoUlXsr6wrgOJ2H/PXt8+jegtDXzH/d3IxXQp7P2W
byhVVV1diO1Fp1j6fSY2EhQtHNSlyF8iWvFwhIf7HOK3dDxm5Q6gGnxlWsVW
GeLT5i4VsN8gzu8LtXgbOSLmgDYZ/xa5NOqpklwWUZTnJ5lX6Qdk1U7+S2ez
EmEFHMHZi6MoxeDz6zy/JSSR1c9+tR1H35/R54hsDDR6WomDpyaQEbHv4aKN
GlgU3UXyK58RDztcNuSgDhsSN765JJhGQs2QRyKWBvQIOHE1gn8Rp8FD2u66
Cs52q208k/0d9YzPtbbuWg3qHU4uue6zyIlJa33soQnzxJY9KukcmiE19Ir8
seCbmOVPGpGhXINWyrSPFvwqvkMsbpYju7IMpfEObdB4/wCUOYuI2N/8bau/
DsQORFqKypRo3ODg2iRvXTCawDNfXV1C03ORcbeD1wD5RzcDx0gMKGIcuV8j
9SDuumiQnKEGC1J+oNthffCZz76aU6AOm+ic9CKeAch/8DiW/0ADGhpZCal2
hnB2uPDlvaFV0EWwnRE2GUKDKBNzbXY1nPQOlERvxsFkdFqsHhML5XmPSOtb
cFBS3jV0ylcLwisDnkZxjCBB6mUeWqQNNzuYxffajECeVvHc6IkOHKFM1GWw
8XD//MsTRyW68Ni/b0dfOx64pfy+ASc9KCmYx1o7ECAl1SE/IF4fdCu9/RYe
EeAt78a1im4DUFOc/8fPjQiTa/oy6rMNIWb/qvy2zhWfP117hIGDpLzG3pLt
JHBG4+eaRThYeHaZnvWEBK0hh5u0o4xA5RXaOQ/G4DGxhRitiYcbVcGfJ54a
QzfJvV2/CQ9ty1dYo1wTwHSVuh/YSQDeBjVs0AsTeHA3a6xZRoCaOm/LAB9T
2DnqZlFTRoRAm3d7gkWm8Haj7QEdDgluphabj/mZgVW8kr52lASRgxeX4/vN
IK9w0Kok1Rh6NTpiTgeZA89a0M+3NoHGX57RcB/MIU59xO35SkdLjpfe2WcB
GXmJ64LCTQGzI//n56MWMKtQjFnqmkFsuefAzCEyjDgkSjjVZhCKpopK35Gh
Kp7fUOVkDpKW38a6QyiQmTSwD7vyu7Cu20f2gQKqipwXgyctoCxZ5VkTYQkX
csu1k43J0GNIzh4RWwJhtsJtl5AMmwa3SfTtqBB1SmZ7z5MCu/MzJ3iJVHBl
ih52TFFA8OeXY35CKhwN210ZlWIJXCYXtzhLhbyM10ykSQVbKUv10Z4GQ3e3
DGv4U8HP1TXZK4EG2SGFm+2vU+GpfMpRep8GXAeNYsIXKiSwmi5YyWnAqLw8
HMOiQURBJMbYng4KSpVSK5kGNXvb2rcn0+FVlX06ekIDWrW1xlIbHdqEpdO6
a+gg3mt7SaKgg90Zce3RIDrI2NbcemcGMNYxG7E36bCtwDlzMmXFcUG3Aqfo
MLBnRieskwFLZg2qn9gMqKjvVCwvMyDB12MqIpkB/wHeyjlY
           "]]},
         Annotation[#, "Charting`Private`Tag$966149#3"]& ], 
        TagBox[
         {GrayLevel[0.5], Thickness[0.003], Opacity[1.], 
          Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxFz30wE3AYB/CJzEsMMy/Jy0b+mOhsXpqYl8nLKc3yWqdC7K4ava3oiDtc
6Yp0wnURuVZoOVbWdGkhVLvm9IJTRE5EO83GmFl1l+f33D333Oe+d8/dl5ia
xUrfhMFgmH/33/U4Y5sfpymgY/4Pl+Ky9zP5ZeCGbaosY6gBA+C1K2b4NKdh
lDvH4JdHx8HFZwO/NzpOgakl7+mthjNgCfXj4p3weXCw7Xra110L4PMUU6kN
WQ4mVo5khO1RgHn4+vw6/yUw7fnKAzxZhf7xTTTZwatgF5H9ByPvNXAubvZT
KWsd/LuPpCBQMUEbtiBIX6ySdcAc7EjNsO8mcLt+SqeEogumNYcpRSF64J4p
hUCwbzN4txtR0B2mD5ZZNfdLYrHg6ziBwzzTAOxVU7hmHWEIJgy0LvjHGoGn
cIe3Z0cbg+cV7FOPkreA1Zl+jF9sE/CK8mp86FFTsCeJVlDBwYGb+RRunpcZ
+JWlu6y9BflcdLz8pLc5uLa008qjDTm9Pq73BM0C3NDhVvlEiHzMYbqxkIoH
d8dKI6Qi5OryZayrryXYuD6atdKJrKMu+cYKJYAzD+mVCcXI2aX8/upwK9S3
7xap+DWyJipVvBxkDb57L3l2uhdZqK2iTDBswJydOtjEd8i8xmjHOKYtOJ48
mpAsQW7Iq7SbZG0Fs4duaE8PIPfrdmReSrQD8y/2Ec3HkA1UeOXjg9vAmIiy
A28mkLNqIwdlR+zBqYEzFbdHkeVtTye7UhxQ/x1dzKUx5JocTSQvwxHcY2Z/
+cscsudQgNzUywm8v6xomnMB+eHbn8dZ7cgMN4b56iKyu5KiGfchglkhITlR
XORe1Yyf8hkyl9JyzUWFnFHOxlj7kMC8JKEoPAeZeN9Vd12IPJfkflOuRl6i
ujKa6M7ggHJ60Y9c5MEEmVGaGLmuSazWapH/AJvBGoY=
           "]]},
         Annotation[#, "Charting`Private`Tag$966149#4"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{False, False},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {
         FormBox[
          TagBox[
           StyleBox["\"f\"", FontSize -> 20], StyleForm[#, FontSize -> 20]& ],
           TraditionalForm], None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{15., 1.5}, {47., 6.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{0., 9.999999873417721}, {-5, 10}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], {564.5206468632662, -137.21427884376777},
      ImageScaled[{0.5, 0.5}], {352.8254042895414, 261.36053113098626}]}, {}},
  
  ImageSize->800,
  PlotRange->{{0, 752.6941958176883}, {-274.42855768753554`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.7292828529649153`*^9, 3.7292828804609756`*^9}, {
   3.72928292170903*^9, 3.729282959284445*^9}, {3.7292832107453814`*^9, 
   3.729283258345181*^9}, {3.729283315646907*^9, 3.729283379601639*^9}, {
   3.7292836790736094`*^9, 3.729283703501816*^9}, 3.7292837552650213`*^9, 
   3.729283871034083*^9, 3.729283985518564*^9, {3.729284078275899*^9, 
   3.729284088524777*^9}, {3.729284135302269*^9, 3.729284150747117*^9}, 
   3.729284290705429*^9, 3.729284428326147*^9, 3.729284576697468*^9, 
   3.729284687699122*^9, 3.7292848808903313`*^9, 3.729285416122139*^9, 
   3.729285559380858*^9, 3.72928576528986*^9, {3.729285887564601*^9, 
   3.729285942493515*^9}, 3.729286100774253*^9, {3.7292862032214737`*^9, 
   3.729286233211173*^9}, {3.729286370748233*^9, 3.729286431777072*^9}, {
   3.7292864781326427`*^9, 3.729286495905244*^9}, 3.729389561013568*^9, 
   3.729389642787097*^9, 3.7293897018465347`*^9, 3.729389745411146*^9, 
   3.729390015776326*^9, 3.729390053058423*^9, {3.7293926213739777`*^9, 
   3.72939263586261*^9}, 3.729460949778452*^9, 3.7294658557561607`*^9, 
   3.7294687628236628`*^9, 3.729477171574139*^9, {3.729477226539805*^9, 
   3.729477235737624*^9}, 3.7294777876077423`*^9, {3.729477826034197*^9, 
   3.729477854580538*^9}, 3.7294784468290997`*^9, 3.7294787141606817`*^9, {
   3.7294788010436974`*^9, 3.7294788146601677`*^9}, 3.72947887640029*^9, 
   3.729482092210986*^9, 3.729539942858893*^9, 3.729540276397193*^9, 
   3.729540836743288*^9, 3.729760962443177*^9, 3.7297609999558773`*^9, {
   3.729761035166548*^9, 3.7297610609180403`*^9}, 3.793999154962571*^9, 
   3.793999270421691*^9, 3.793999415829818*^9, 3.823228421445653*^9},
 CellLabel->
  "Out[2356]=",ExpressionUUID->"d12a140a-65a4-4f6e-ac5c-2e4e0690834f"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.793999177205838*^9, 3.793999185993596*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"defdb39c-26ac-40f2-ba1e-7a9a7f4ad855"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dt", "=", "0.1"}], ";", 
  RowBox[{"tmax", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["p", 
          RowBox[{"L", ",", "0"}]], ",", 
         SubscriptBox["p", 
          RowBox[{"R", ",", "0"}]], ",", 
         SubscriptBox["p", 
          RowBox[{"L", ",", "1"}]], ",", 
         SubscriptBox["p", 
          RowBox[{"R", ",", "1"}]]}], "}"}], "/.", "param"}], "//", "N"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "0", ",", "tmax", ",", "dt"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<bipartiteRegulator.dat\>\"", ",", " ", "dat"}], "]"}], 
    ";"}], "\[IndentingNewLine]", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.600941412667275*^9, 3.600941441203025*^9}, {
  3.726330485709305*^9, 3.726330488050775*^9}, {3.72633052966085*^9, 
  3.726330531905334*^9}, {3.726330995411737*^9, 3.726331006758379*^9}, {
  3.726334576973692*^9, 3.726334597202836*^9}, {3.729540574467132*^9, 
  3.729540690270546*^9}, {3.729540798956574*^9, 3.72954082762679*^9}, {
  3.729760947921221*^9, 3.729760951627911*^9}, {3.79399916125758*^9, 
  3.793999173529426*^9}, {3.793999215747608*^9, 3.793999248689818*^9}},
 CellLabel->
  "In[2357]:=",ExpressionUUID->"e85353c9-0ea7-44dd-b5d9-9cbc662518af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"J", "/.", "param"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.729477869460989*^9, 3.72947787788063*^9}, {
   3.729540339629877*^9, 3.729540350492662*^9}, {3.7295403901275578`*^9, 
   3.729540443775888*^9}, 3.729760983583617*^9},
 CellLabel->
  "In[2359]:=",ExpressionUUID->"af91e08a-48b6-40af-ab16-8e6e463259ee"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV1Hk41csfB3CS5YqyVVQc63GcYzlLKd3LfEqk0qYsIVv2XXGTpYQSUZIQ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       "]]},
     Annotation[#, "Charting`Private`Tag$966273#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.729477878217853*^9, 3.7294784472013073`*^9, 3.729478714506132*^9, {
   3.729478801416465*^9, 3.729478815032832*^9}, 3.729482092724742*^9, 
   3.7295399432550793`*^9, {3.729540335320448*^9, 3.729540351572661*^9}, {
   3.729540390480879*^9, 3.729540444516814*^9}, 3.729540837660165*^9, {
   3.729760963451786*^9, 3.729761000387212*^9}, {3.72976103561769*^9, 
   3.7297610613440733`*^9}, 3.793999155095996*^9, 3.7939992704971313`*^9, 
   3.793999415907671*^9, 3.82322842161968*^9},
 CellLabel->
  "Out[2359]=",ExpressionUUID->"d50ba1ca-bd84-47ea-b110-af1dbc1903fc"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1210, 820},
WindowMargins->{{Automatic, 99}, {Automatic, 21}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"c54859a4-e350-47f6-b3e9-e92d5561c9e2"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 662, 12, 143, "Section",ExpressionUUID->"4bdbcd86-ddd5-4310-abfa-e41f7e84faf1"],
Cell[1232, 36, 175, 4, 30, "Input",ExpressionUUID->"b4feff48-f9a7-4f78-9506-9b73d62f65dc"],
Cell[1410, 42, 4086, 78, 115, "Input",ExpressionUUID->"598b22ce-56c5-4b44-a1cf-ebd71f7708ef"],
Cell[5499, 122, 913, 24, 32, "Input",ExpressionUUID->"30695159-c2f7-4264-b295-7aee56eba7e0"],
Cell[CellGroupData[{
Cell[6437, 150, 8557, 194, 272, "Input",ExpressionUUID->"402b753f-0cf9-480f-b2f4-a0b735221c5c"],
Cell[14997, 346, 5519, 107, 120, "Output",ExpressionUUID->"d530c0fc-1d9d-4c74-bb4d-9ed12ef93783"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20553, 458, 384, 9, 30, "Input",ExpressionUUID->"4f12890a-cef7-40b4-b5a0-3064a322215f"],
Cell[20940, 469, 2802, 77, 110, "Output",ExpressionUUID->"d8f12401-c6bb-4a88-8e75-7ff2f3fc4ac8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23779, 551, 13831, 324, 526, "Input",ExpressionUUID->"ca0cddd8-4eb3-4913-be54-2d778be9d283"],
Cell[37613, 877, 2279, 32, 34, "Output",ExpressionUUID->"72692dc2-971f-40e1-a7e0-824dca93a913"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39929, 914, 461, 12, 30, "Input",ExpressionUUID->"db88fce9-d16a-434b-962b-cf1dde0f8928"],
Cell[40393, 928, 2309, 61, 91, "Output",ExpressionUUID->"878a7e28-584b-4dd4-bb5f-df0aea75f71f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42739, 994, 360, 11, 51, "Input",ExpressionUUID->"d49adf8d-6eac-42f8-9955-255eb0b295ee"],
Cell[43102, 1007, 920, 22, 57, "Output",ExpressionUUID->"463fe46f-bfd7-414c-9da8-192dc269512b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44059, 1034, 476, 13, 30, "Input",ExpressionUUID->"18d97c4d-5623-47aa-8206-37aff939fd55"],
Cell[44538, 1049, 967, 22, 67, "Output",ExpressionUUID->"f0525260-abb5-4d05-a39f-8028d8bc7229"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45542, 1076, 320, 8, 30, "Input",ExpressionUUID->"b36d020d-5074-494b-8549-6ecd8c7c4e7f"],
Cell[45865, 1086, 889, 23, 54, "Output",ExpressionUUID->"d30baa8b-dc37-4e0b-89ba-2ffae5664637"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46791, 1114, 455, 12, 30, "Input",ExpressionUUID->"0ac001a1-9219-4cf8-bd2b-c408aad2bb16"],
Cell[47249, 1128, 2647, 68, 54, "Output",ExpressionUUID->"9e343dde-1bd1-4a07-bfd6-bf1bce37ca51"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49933, 1201, 2898, 51, 33, "Input",ExpressionUUID->"fb68e52e-56ed-4569-a571-ac4ee4bd1ac1"],
Cell[52834, 1254, 4844, 89, 83, "Output",ExpressionUUID->"12653b26-cc87-47c1-a9b3-d89e42b571c8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57715, 1348, 1086, 30, 33, "Input",ExpressionUUID->"43dbc811-464e-4102-82ab-62496199fa77"],
Cell[58804, 1380, 7547, 196, 205, "Output",ExpressionUUID->"07d457e5-6f64-4570-a396-27b7defc618f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66388, 1581, 543, 13, 30, "Input",ExpressionUUID->"7064f184-0b0a-43d4-822b-00f2d8186393"],
Cell[66934, 1596, 11999, 217, 256, "Output",ExpressionUUID->"aeef9990-de26-45c4-ac39-3d4975bcc25c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78970, 1818, 7434, 147, 220, "Input",ExpressionUUID->"701f7f2f-30a3-4b8a-851d-a397a7408915"],
Cell[86407, 1967, 16267, 311, 315, "Output",ExpressionUUID->"d12a140a-65a4-4f6e-ac5c-2e4e0690834f"]
}, Open  ]],
Cell[102689, 2281, 181, 3, 51, "Text",ExpressionUUID->"defdb39c-26ac-40f2-ba1e-7a9a7f4ad855"],
Cell[102873, 2286, 1636, 41, 138, "Input",ExpressionUUID->"e85353c9-0ea7-44dd-b5d9-9cbc662518af"],
Cell[CellGroupData[{
Cell[104534, 2331, 442, 10, 30, "Input",ExpressionUUID->"af91e08a-48b6-40af-ab16-8e6e463259ee"],
Cell[104979, 2343, 7381, 141, 262, "Output",ExpressionUUID->"d50ba1ca-bd84-47ea-b110-af1dbc1903fc"]
}, Open  ]]
}, Open  ]]
}
]
*)

