(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     10605,        310]
NotebookOptionsPosition[      8441,        265]
NotebookOutlinePosition[      8839,        281]
CellTagsIndexPosition[      8796,        278]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Kramers-Kronig for 1st-order system  (Problem 15.1)", "Section",
 CellChangeTimes->{{3.604853501070706*^9, 3.6048535194516*^9}, {
  3.793999493098132*^9, 
  3.793999512073429*^9}},ExpressionUUID->"e4190ad9-ddec-4153-ab52-\
e750360e93a3"],

Cell["G''  to G\[CloseCurlyQuote]", "Text",
 CellChangeTimes->{{3.60485352831186*^9, 3.604853540648768*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"2a457e4c-9c56-4d43-8f85-979e35a988f4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    FractionBox["2", "\[Pi]"], 
    RowBox[{"(", 
     FractionBox[
      SuperscriptBox["\[Omega]1", "2"], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[Omega]1", "2"]}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Omega]1", "2"], "-", 
         SuperscriptBox["\[Omega]", "2"]}], ")"}]}]], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]1", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"PrincipalValue", "\[Rule]", "True"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", " ", 
    RowBox[{"\[Omega]", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6048517888718967`*^9, 3.604851917816202*^9}, {
  3.604851960184325*^9, 3.604851961504203*^9}},
 CellLabel->
  "In[2256]:=",ExpressionUUID->"03cdf90c-99c5-4801-a870-a6bb9bad81cc"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   SuperscriptBox["\[Omega]", "2"]}]]], "Output",
 CellChangeTimes->{3.604851879657281*^9, 3.604851965257144*^9, 
  3.793999533629917*^9, 3.823228211878442*^9},
 CellLabel->
  "Out[2256]=",ExpressionUUID->"679fa461-a857-4ac4-865f-910b27a09cc1"]
}, Open  ]],

Cell["G'  to G\[CloseCurlyQuote]\[CloseCurlyQuote]", "Text",
 CellChangeTimes->{{3.60485352831186*^9, 3.604853561704617*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"db428112-f9aa-4fe2-b84c-7330dce99d2e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"2", "\[Omega]"}], "\[Pi]"], 
    RowBox[{"(", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[Omega]1", "2"]}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Omega]1", "2"], "-", 
         SuperscriptBox["\[Omega]", "2"]}], ")"}]}]], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]1", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"PrincipalValue", "\[Rule]", "True"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", " ", 
    RowBox[{"\[Omega]", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6048519923482313`*^9, 3.604852000460814*^9}},
 CellLabel->
  "In[2257]:=",ExpressionUUID->"9e4dd209-925f-47d8-8d8c-c53091368c1a"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["\[Omega]", 
   RowBox[{"1", "+", 
    SuperscriptBox["\[Omega]", "2"]}]]}]], "Output",
 CellChangeTimes->{3.6048520084362507`*^9, 3.793999536441712*^9, 
  3.823228214932845*^9},
 CellLabel->
  "Out[2257]=",ExpressionUUID->"f0c9a8f4-438b-4c92-b075-695744258f99"]
}, Open  ]],

Cell["\<\
G\[CloseCurlyQuote] to G\[CloseCurlyQuote]\[CloseCurlyQuote]:   show \
integrand is even (step for contour integration)\
\>", "Text",
 CellChangeTimes->{{3.60485352831186*^9, 3.604853561704617*^9}, {
  3.604853738353505*^9, 3.604853760882496*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"53f6c551-a7e1-4b0b-b3a7-2a53f11e93c4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"(", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[Omega]1", "2"]}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[Omega]1", "2"], "-", 
        SuperscriptBox["\[Omega]", "2"]}], ")"}]}]], ")"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]1", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"PrincipalValue", "\[Rule]", "True"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", " ", 
    RowBox[{"\[Omega]", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.60485217900524*^9, 3.604852195957962*^9}},
 CellLabel->
  "In[2258]:=",ExpressionUUID->"173d4d34-d152-45f0-993e-ffba20ed472b"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["\[Pi]", 
   RowBox[{"1", "+", 
    SuperscriptBox["\[Omega]", "2"]}]]}]], "Output",
 CellChangeTimes->{{3.604852186771803*^9, 3.604852198753191*^9}, 
   3.7939995389179993`*^9, 3.823228217863188*^9},
 CellLabel->
  "Out[2258]=",ExpressionUUID->"577cce41-8043-4515-9727-a9c32bcb8ce5"]
}, Open  ]],

Cell["Bode gain-phase relation", "Text",
 CellChangeTimes->{{3.60485352831186*^9, 3.604853561704617*^9}, {
  3.604853675242581*^9, 3.604853678350689*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"fb0eaa69-a71e-4a5b-86de-0c238203cd02"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"2", "\[Omega]"}], "\[Pi]"], 
    RowBox[{"(", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        FractionBox[
         RowBox[{"-", "1"}], "2"], ")"}], 
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[Omega]1", "2"]}], "]"}]}], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[Omega]1", "2"], "-", 
        SuperscriptBox["\[Omega]", "2"]}], ")"}]], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]1", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"PrincipalValue", "\[Rule]", "True"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", " ", 
    RowBox[{"\[Omega]", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.604852815442017*^9, 3.604852860015089*^9}},
 CellLabel->
  "In[2259]:=",ExpressionUUID->"0a1e7c0d-d58a-46e6-9c39-ce20b010bb58"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"ArcTan", "[", "\[Omega]", "]"}]}]], "Output",
 CellChangeTimes->{3.6048528921935*^9, 3.79399955838783*^9, 
  3.823228237727681*^9},
 CellLabel->
  "Out[2259]=",ExpressionUUID->"6e69ff9a-f8d0-4ba4-a55f-b9134b76e454"]
}, Open  ]],

Cell["\<\
Check that the Green\[CloseCurlyQuote]s function (impulse response function) \
is causal (\[Theta] function appears)\
\>", "Text",
 CellChangeTimes->{{3.60485352831186*^9, 3.604853561704617*^9}, {
  3.604853685537188*^9, 3.604853710002479*^9}, {3.6048537689911547`*^9, 
  3.604853775372555*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"5bee19e1-a92d-47fa-94fc-16d1587fc77b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]}]], ",", "\[Omega]", ",", "t",
    ",", 
   RowBox[{"FourierParameters", "->", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6048533081557207`*^9, 3.604853385021387*^9}},
 CellLabel->
  "In[2260]:=",ExpressionUUID->"eabc4d91-5491-4c60-8ac3-3b66ee205a16"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "t"}]], " ", 
  RowBox[{"HeavisideTheta", "[", "t", "]"}]}]], "Output",
 CellChangeTimes->{3.60485338561985*^9, 3.7939995584549303`*^9, 
  3.8232282378859*^9},
 CellLabel->
  "Out[2260]=",ExpressionUUID->"9be2f90d-e76f-476f-855b-40a8fd3b5511"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "TraditionalForm"}]], "Input",
 CellChangeTimes->{{3.823228244681946*^9, 3.823228249191291*^9}},
 CellLabel->
  "In[2261]:=",ExpressionUUID->"fdb605ca-3827-43da-aff1-a91bfc087008"],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "t"}]], " ", 
   TemplateBox[{
     RowBox[{"t"}]},
    "HeavisideThetaSeq"]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.82322824964587*^9},
 CellLabel->
  "Out[2261]//TraditionalForm=",ExpressionUUID->"1b52cdd3-5724-4ffb-aadc-\
c91eb9835980"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 752},
WindowMargins->{{Automatic, 108}, {Automatic, 74}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"075d754c-8359-46ae-85fc-490c93151d58"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 243, 4, 67, "Section",ExpressionUUID->"e4190ad9-ddec-4153-ab52-e750360e93a3"],
Cell[825, 28, 196, 3, 51, "Text",ExpressionUUID->"2a457e4c-9c56-4d43-8f85-979e35a988f4"],
Cell[CellGroupData[{
Cell[1046, 35, 889, 24, 87, "Input",ExpressionUUID->"03cdf90c-99c5-4801-a870-a6bb9bad81cc"],
Cell[1938, 61, 298, 7, 52, "Output",ExpressionUUID->"679fa461-a857-4ac4-865f-910b27a09cc1"]
}, Open  ]],
Cell[2251, 71, 213, 3, 51, "Text",ExpressionUUID->"db428112-f9aa-4fe2-b84c-7330dce99d2e"],
Cell[CellGroupData[{
Cell[2489, 78, 832, 23, 87, "Input",ExpressionUUID->"9e4dd209-925f-47d8-8d8c-c53091368c1a"],
Cell[3324, 103, 305, 8, 49, "Output",ExpressionUUID->"f0c9a8f4-438b-4c92-b075-695744258f99"]
}, Open  ]],
Cell[3644, 114, 345, 7, 51, "Text",ExpressionUUID->"53f6c551-a7e1-4b0b-b3a7-2a53f11e93c4"],
Cell[CellGroupData[{
Cell[4014, 125, 776, 21, 87, "Input",ExpressionUUID->"173d4d34-d152-45f0-993e-ffba20ed472b"],
Cell[4793, 148, 327, 8, 49, "Output",ExpressionUUID->"577cce41-8043-4515-9727-a9c32bcb8ce5"]
}, Open  ]],
Cell[5135, 159, 242, 4, 51, "Text",ExpressionUUID->"fb0eaa69-a71e-4a5b-86de-0c238203cd02"],
Cell[CellGroupData[{
Cell[5402, 167, 913, 26, 92, "Input",ExpressionUUID->"0a1e7c0d-d58a-46e6-9c39-ce20b010bb58"],
Cell[6318, 195, 255, 6, 34, "Output",ExpressionUUID->"6e69ff9a-f8d0-4ba4-a55f-b9134b76e454"]
}, Open  ]],
Cell[6588, 204, 393, 8, 51, "Text",ExpressionUUID->"5bee19e1-a92d-47fa-94fc-16d1587fc77b"],
Cell[CellGroupData[{
Cell[7006, 216, 488, 13, 48, "Input",ExpressionUUID->"eabc4d91-5491-4c60-8ac3-3b66ee205a16"],
Cell[7497, 231, 320, 8, 34, "Output",ExpressionUUID->"9be2f90d-e76f-476f-855b-40a8fd3b5511"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7854, 244, 214, 4, 30, "Input",ExpressionUUID->"fdb605ca-3827-43da-aff1-a91bfc087008"],
Cell[8071, 250, 342, 11, 67, "Output",ExpressionUUID->"1b52cdd3-5724-4ffb-aadc-c91eb9835980"]
}, Open  ]]
}, Open  ]]
}
]
*)

