(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    234913,       4169]
NotebookOptionsPosition[    231956,       4113]
NotebookOutlinePosition[    232354,       4129]
CellTagsIndexPosition[    232311,       4126]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Mutual information rates  (Problem 15.18)", "Section",
 CellChangeTimes->{{3.793999650998548*^9, 
  3.793999666515913*^9}},ExpressionUUID->"ee864b8d-6920-4f56-b23e-\
d25d6384a043"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[2284]:=",ExpressionUUID->"ab4322c0-bde7-4aee-ad35-162268550380"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "[", "u_", "]"}], ":=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"2", "\[Pi]", " ", 
        SuperscriptBox["\[Sigma]", "2"]}]]], 
     RowBox[{"Exp", "[", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["x", "2"], 
        RowBox[{"2", " ", 
         SuperscriptBox["\[Sigma]", "2"]}]]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "u", ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"\[Sigma]", ">", "0"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.620615807851*^9, 3.620615863067937*^9}, {
  3.621092759084585*^9, 3.621092820808547*^9}},
 CellLabel->
  "In[2285]:=",ExpressionUUID->"e6a8f6ce-f14b-48b8-9c2c-f1e7cb56a820"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "[", "u", "]"}]], "Input",
 CellChangeTimes->{{3.6206158671866503`*^9, 3.620615890986993*^9}, {
  3.620844281535618*^9, 3.620844288386299*^9}, {3.6209357667468367`*^9, 
  3.620935769567099*^9}},
 CellLabel->
  "In[2286]:=",ExpressionUUID->"a128603c-b4a2-4728-8f7a-05f30d1fc002"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"Erfc", "[", 
   FractionBox["u", 
    RowBox[{
     SqrtBox["2"], " ", "\[Sigma]"}]], "]"}]}]], "Output",
 CellChangeTimes->{{3.6206158701843843`*^9, 3.620615891769319*^9}, 
   3.620691367477919*^9, 3.620691521309222*^9, 3.620836356882752*^9, 
   3.620844159051721*^9, 3.620844289554117*^9, 3.620934591691454*^9, 
   3.620935770863505*^9, 3.620962957714284*^9, 3.620967729249735*^9, {
   3.621092780463397*^9, 3.621092823927288*^9}, 3.766582976883678*^9, 
   3.793999737370055*^9, 3.823228288195579*^9},
 CellLabel->
  "Out[2286]=",ExpressionUUID->"c3d73459-fed7-4a98-8fb5-96d5af0661ec"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", 
   RowBox[{"y0_", ",", "u_"}], "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"a", "[", "u", "]"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"DiracDelta", "[", 
           RowBox[{"y0", "+", "u"}], "]"}], "+", 
          RowBox[{"DiracDelta", "[", 
           RowBox[{"y0", "-", "u"}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", 
         SqrtBox[
          RowBox[{"2", "\[Pi]", " ", 
           SuperscriptBox["\[Sigma]", "2"]}]]], 
        RowBox[{"Exp", "[", 
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["y0", "2"], 
           RowBox[{"2", 
            SuperscriptBox["\[Sigma]", "2"]}]]}], "]"}]}]}], ",", 
      RowBox[{
       RowBox[{"-", "u"}], "<", "y0", "<", "u"}]}], "}"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.6206912300222807`*^9, {3.620691270507903*^9, 3.620691272259082*^9}, {
   3.620934057492412*^9, 3.620934105984013*^9}, {3.620934198848311*^9, 
   3.620934211032621*^9}, {3.620935736931202*^9, 3.6209357455506153`*^9}, {
   3.6210928388824053`*^9, 3.621092843168706*^9}},
 CellLabel->
  "In[2287]:=",ExpressionUUID->"618d59c2-6040-4643-a154-b64fde8c7d9c"],

Cell[TextData[StyleBox["Now we look at the case with measurement noise of \
magnitude \[Xi]",
 FontSize->16]], "Text",
 CellChangeTimes->{{3.6207000309470577`*^9, 3.620700064615209*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"b13852e1-1c59-441f-a539-242725bb387e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p0", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Xi]"}]], 
      RowBox[{"Exp", "[", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox["x", "2"], 
         RowBox[{"2", 
          SuperscriptBox["\[Xi]", "2"]}]]}], "]"}], 
      RowBox[{"Piecewise", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           FractionBox["1", 
            RowBox[{
             SqrtBox[
              RowBox[{"2", " ", "\[Pi]", " ", 
               SuperscriptBox["\[Sigma]", "2"]}]], " "}]], 
           RowBox[{"Exp", "[", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"y", "-", "x"}], ")"}], "2"], 
              RowBox[{"2", 
               SuperscriptBox["\[Sigma]", "2"]}]]}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "u"}], "<", 
           RowBox[{"y", "-", "x"}], "<", "u"}]}], "}"}], "}"}], "]"}]}], ",", 
     
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Xi]", ">", "0"}], ",", 
        RowBox[{"\[Sigma]", ">", "0"}]}], "}"}]}]}], "]"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.6209343219321117`*^9, 3.620934482653028*^9}, {
  3.6209345371719418`*^9, 3.620934544597459*^9}, {3.620935811480051*^9, 
  3.620935830767851*^9}, {3.620936040472554*^9, 3.62093604078275*^9}, {
  3.620936957113014*^9, 3.620936959055863*^9}, {3.620937513135941*^9, 
  3.620937513639686*^9}, {3.6210928583993053`*^9, 3.6210928607220793`*^9}, {
  3.6210929778502283`*^9, 3.6210929959219627`*^9}, {3.621093034758998*^9, 
  3.621093119535964*^9}, {3.621093389561426*^9, 3.621093404322073*^9}, {
  3.62109350951377*^9, 3.621093522227675*^9}, {3.621093598348345*^9, 
  3.6210936010199623`*^9}},
 CellLabel->
  "In[2288]:=",ExpressionUUID->"a5ee9639-e7fd-4182-b6c6-63d13ad26504"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox["y", "2"], 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["\[Xi]", "2"], "+", 
                SuperscriptBox["\[Sigma]", "2"]}], ")"}]}]]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Erf", "[", 
             FractionBox[
              RowBox[{
               RowBox[{"u", " ", 
                SuperscriptBox["\[Xi]", "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"u", "+", "y"}], ")"}], " ", 
                SuperscriptBox["\[Sigma]", "2"]}]}], 
              RowBox[{
               SqrtBox["2"], " ", "\[Xi]", " ", "\[Sigma]", " ", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["\[Xi]", "2"], "+", 
                 SuperscriptBox["\[Sigma]", "2"]}]]}]], "]"}], "-", 
            RowBox[{"Erf", "[", 
             FractionBox[
              RowBox[{
               RowBox[{"y", " ", 
                SuperscriptBox["\[Sigma]", "2"]}], "-", 
               RowBox[{"u", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["\[Xi]", "2"], "+", 
                  SuperscriptBox["\[Sigma]", "2"]}], ")"}]}]}], 
              RowBox[{
               SqrtBox["2"], " ", "\[Xi]", " ", "\[Sigma]", " ", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["\[Xi]", "2"], "+", 
                 SuperscriptBox["\[Sigma]", "2"]}]]}]], "]"}]}], ")"}]}], 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"2", " ", "\[Pi]"}]], " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["\[Xi]", "2"], "+", 
            SuperscriptBox["\[Sigma]", "2"]}]]}]], 
        RowBox[{"u", ">", "0"}]},
       {"0", 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}},
      Selectable->True]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False,
  StripWrapperBoxes->True]], "Output",
 CellChangeTimes->{3.621093077224677*^9, 3.621093131061502*^9, 
  3.621093415238449*^9, 3.621093565980452*^9, 3.621093615219363*^9, 
  3.766582992399722*^9, 3.7939997475011263`*^9, 3.8232282984436703`*^9},
 CellLabel->
  "Out[2288]=",ExpressionUUID->"14c7e640-c66a-4321-9fd0-443654a86d30"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"pym", " ", "=", " ", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"a", "[", "u", "]"}], 
       SqrtBox[
        RowBox[{"2", "\[Pi]", " ", 
         SuperscriptBox["\[Xi]", "2"]}]]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "-", "u"}], ")"}], "2"], 
           RowBox[{"2", 
            SuperscriptBox["\[Xi]", "2"]}]]}], "]"}], "+", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "+", "u"}], ")"}], "2"], 
           RowBox[{"2", 
            SuperscriptBox["\[Xi]", "2"]}]]}], "]"}]}], ")"}]}], "+", 
     "p0"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.620700773364901*^9, 3.620700875611058*^9}, {
   3.620700914892848*^9, 3.620700994791794*^9}, {3.620701331774343*^9, 
   3.620701616616086*^9}, {3.620701755868641*^9, 3.6207017748060837`*^9}, 
   3.620701809026328*^9, {3.620702294584839*^9, 3.6207023872646*^9}, {
   3.620702658409973*^9, 3.620702729632629*^9}, {3.6207028546457043`*^9, 
   3.620702887275343*^9}, {3.620934748340541*^9, 3.6209347941555243`*^9}, {
   3.620935838035277*^9, 3.620935887804297*^9}},
 CellLabel->
  "In[2289]:=",ExpressionUUID->"313a1fe2-414b-4b24-9bb7-98614e6aea27"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"pym", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Xi]", "\[Rule]", "0.2"}], ",", 
        RowBox[{"\[Sigma]", "\[Rule]", "1"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "pym"}], " ", 
       RowBox[{"Log", "[", "pym", "]"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Xi]", "\[Rule]", "0.2"}], ",", 
        RowBox[{"u", "\[Rule]", "1"}], ",", 
        RowBox[{"\[Sigma]", "\[Rule]", "1"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{"p1", ",", "p2"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.621093304960787*^9, 3.621093308807908*^9}, {
  3.793999840176508*^9, 3.7939998575399303`*^9}},
 CellLabel->
  "In[2290]:=",ExpressionUUID->"4978b83d-c05f-45d5-af2d-fa523dab0c53"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx0nXdcj+0Xx1NIhJSZFZIVlfa8yxNaVraMKFv2yl4pUZK994iQFZkVWYVK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        "], {{
          {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
            GrayLevel[1], 3], 
           StyleBox[GraphicsGroup3DBox[
             TagBox[{Polygon3DBox[CompressedData["
1:eJw9nHccV9P/x+/n7hMZicysFiKZZa/smVlGCmXPsipSZGdWyJ7xNSJJdoiy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                "]], Polygon3DBox[CompressedData["
1:eJwtnAO09EoTRQfRPNu2bdu2bdv292zbtm3b+J9tW//e72Stm3X7pDqZTNLp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                "]], 
               Polygon3DBox[CompressedData["
1:eJwt1wnYTmUex/GH9+V9XruQNVI0ky1SJIUaZCmkkLVJ2WVKIUXITlJT2kiW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                "]], 
               Polygon3DBox[{{1844, 1076, 1249, 2308, 1708, 1709}, {2269, 
                1085, 923, 922, 1170, 1900}, {2276, 1105, 947, 946, 1524, 
                2151}, {2272, 1095, 935, 934, 1520, 2148}, {1845, 1077, 1594, 
                2345, 1710, 1711}, {2167, 1538, 946, 947, 1539, 2168}}]},
              Annotation[#, "Charting`Private`Tag$909665#1"]& ]],
            Lighting->{{"Ambient", 
               RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
              "Directional", 
               RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
               ImageScaled[{0, 2, 2}]}, {"Directional", 
               RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
               ImageScaled[{2, 2, 2}]}, {"Directional", 
               RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
               ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}}, {
          {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0s9L03EYB/BnS61WaR6CIDK6Ru4PiCVhQYRFEJ30IHRbQkqrmCehhDxJ
Jz1JCSodOzS9xSJBvIm/SlO3qakFEXQLOvj6IuzZ63l/9vl8n8/GLj/qffAk
FRFv1FQ6IukLbNY8bIg4K3fzEnuY5XNe5yDvJmfZxXccV4/1M+xnmUOc5ygX
OcUaS/zDWU4fj+gzs2z2kjzBV/LmsYhleYsrrHCVVX5NnsNv3OYad7jOXf5Q
3/V73GCnZ+7rN/UH3OJPVviLVabqI56a+9nemjzJQTnjfovyf/f9wt/8mNyH
k1zgCOf4mp9YZCnZp/L6MXZymB18yVzye7OVebZwwKyLZr43u0ke5wv5vjs2
yvd4hh08zTs8xdvM8ENdxAX7s86dlIu+0z/5vLpq7ZZ9J6z/lc+pK9ZuWjM2
3uqfWWuXXSdu0PFoo8dGjl5xzZutkfZhIXX03zkEqV5NHA==
            "]]}, 
          {GrayLevel[0.2], 
           Line3DBox[{1620, 1915, 2236, 2494, 1619, 2347, 1803, 1621, 2348, 
            1804, 1622, 2349, 1805, 1623, 2350, 1806, 1624, 2302, 2351, 1916, 
            2106, 1807, 2107, 2316, 2510, 2013, 1917, 1996, 1808, 2055, 2520, 
            2014, 2015, 1918, 1997, 2237, 2509, 2171, 2121, 2122, 2095, 2530, 
            1809, 1625, 2352, 1810, 1626, 2353, 1811, 1627, 2354, 1812, 1628, 
            2355, 1813, 1629, 2303, 2356, 1814, 1919}], 
           Line3DBox[{1631, 2238, 2411, 1630, 2239, 2412, 1632, 2357, 1815, 
            1633, 2358, 1816, 1634, 2359, 1817, 1635, 2297, 2360, 1920, 405, 
            509, 1401, 438, 512, 406, 510, 1402, 441, 516, 407, 1404, 514, 
            442, 1921, 2240, 2482, 1636, 2213, 2214, 2559, 1818, 1637, 2361, 
            1819, 1638, 2362, 1820, 1639, 2363, 1821, 1640, 2364, 1822, 
            1641}], Line3DBox[{1643, 2241, 2413, 1642, 2242, 2414, 1644, 2243,
             2415, 1645, 2365, 1823, 1646, 2304, 2366, 1824, 1922, 2108, 2534,
             1879, 2156, 1998, 1999, 1982, 2317, 2511, 1880, 2056, 2000, 2001,
             1923, 2495, 2016, 1881, 2057, 2002, 2003, 2521, 1924, 2017, 1882,
             1925, 2177, 2483, 2338, 2176, 2175, 2244, 2552, 1647, 2367, 1825,
             1648, 2368, 1826, 1649, 2369, 1827, 1650, 2370, 1828, 1651}], 
           Line3DBox[{1653, 2245, 2416, 1652, 2246, 2417, 1654, 2247, 2418, 
            1655, 2248, 2419, 1656, 2496, 1926, 1927, 1657, 2109, 2484, 1883, 
            2110, 1884, 2096, 1658, 2332, 2485, 1885, 2111, 1886, 2018, 1659, 
            2318, 2486, 1887, 2112, 1888, 2531, 2333, 1660, 2097, 1889, 2157, 
            1890, 2535, 2334, 1661, 1928, 1929, 2497, 1662, 2249, 2420, 1663, 
            2371, 1829, 1664, 2372, 1830, 1665, 2373, 1831, 1666}], 
           Line3DBox[{1668, 2250, 2421, 1667, 2251, 2422, 1669, 2252, 2423, 
            1670, 2253, 2424, 1671, 2305, 2425, 1930, 1672, 2019, 2487, 1891, 
            2058, 1892, 2113, 2020, 2072, 1356, 2062, 1893, 2059, 1894, 2021, 
            2073, 2524, 2022, 1895, 2060, 1896, 2063, 2023, 2498, 2074, 2024, 
            2114, 1897, 2061, 1898, 2512, 2319, 1673, 1934, 1229, 1674, 2254, 
            2426, 1675, 2255, 2427, 1676, 2374, 1832, 1677, 2375, 1833, 
            1678}], Line3DBox[{1680, 2256, 2428, 1679, 2257, 2429, 1681, 2258,
             2430, 1682, 2205, 2431, 2341, 1683, 2206, 2207, 2558, 2125, 2127,
             2126, 1684, 2025, 1367, 1931, 2027, 2026, 1685, 2525, 2075, 2076,
             1932, 2029, 2028, 1686, 2513, 2030, 2031, 1933, 2078, 2077, 2526,
             1687, 2032, 2033, 1935, 2034, 1375, 1688, 2129, 2130, 2128, 2432,
             2306, 1689, 2259, 2433, 1690, 2260, 2434, 1691, 2261, 2435, 1692,
             2376, 1834, 1693}], 
           Line3DBox[{1697, 2377, 1835, 1695, 2378, 1836, 1699, 2379, 1837, 
            1701, 2209, 2380, 1838, 2210, 2307, 2381, 1940, 2115, 1839, 2116, 
            2038, 2163, 2546, 2321, 1941, 2004, 2079, 1840, 2064, 2323, 2514, 
            2040, 1942, 1841, 2158, 2544, 1899, 1943, 2005, 2501, 1842, 2065, 
            2045, 2066, 2046, 1944, 2006, 2137, 2537, 1843, 2172, 2123, 2124, 
            1983, 2508, 1844, 1709, 2216, 2217, 2560, 1845, 1711, 2382, 1846, 
            1713, 2383, 1847, 1715, 2384, 1848, 1717}], 
           Line3DBox[{1716, 2444, 2267, 1714, 2443, 2266, 1712, 2442, 2265, 
            1710, 2345, 2441, 2215, 1708, 2308, 2440, 2134, 2136, 2135, 1707, 
            2325, 2516, 2044, 1939, 2043, 2042, 1706, 2324, 2515, 2041, 1938, 
            2162, 2161, 2545, 1705, 2159, 2160, 1937, 2039, 2500, 2322, 1704, 
            2036, 2037, 1936, 2320, 2499, 2035, 1703, 2132, 2133, 2131, 2343, 
            2536, 2211, 1702, 2342, 2439, 2208, 1700, 2438, 2264, 1698, 2437, 
            2263, 1694, 2436, 2262, 1696}], 
           Line3DBox[{1719, 2268, 2445, 1718, 2385, 1849, 1720, 2386, 1850, 
            1721, 2178, 2387, 1851, 2179, 2180, 2181, 2388, 1945, 2007, 1852, 
            1984, 2047, 2517, 2326, 1947, 2080, 2138, 1853, 1946, 2502, 2048, 
            2049, 1976, 1854, 1722, 2489, 1900, 2269, 2488, 1949, 2117, 2164, 
            2118, 1950, 2008, 2503, 1855, 2067, 2050, 2051, 1951, 2553, 2184, 
            1856, 2183, 2182, 2204, 2557, 1857, 1723, 2389, 1858, 1724, 2390, 
            1859, 1725, 2391, 1860, 1726}], 
           Line3DBox[{1728, 2270, 2446, 1727, 2271, 2447, 1729, 2392, 1861, 
            1730, 1952, 2393, 1862, 1953, 2119, 2298, 2547, 2165, 2086, 2087, 
            2085, 2098, 2532, 1901, 2120, 2089, 2090, 2088, 2527, 1948, 2194, 
            1863, 1731, 2541, 2148, 2272, 2540, 2149, 2150, 1902, 2166, 2092, 
            2490, 2331, 2091, 2099, 1903, 1954, 2554, 2187, 2188, 2186, 2185, 
            2394, 1864, 1732, 2395, 1865, 1733, 2396, 1866, 1734, 2397, 1867, 
            1735}], Line3DBox[{1737, 2273, 2448, 1736, 2274, 2449, 1738, 2275,
             2450, 1739, 1955, 2398, 1868, 1956, 2052, 2518, 1904, 1986, 2009,
             2010, 1985, 2053, 2519, 1905, 1977, 2144, 2145, 2143, 2538, 2142,
             2195, 1869, 1740, 2543, 2151, 2276, 2542, 2152, 1906, 1989, 2011,
             2491, 2314, 1988, 2054, 1907, 1991, 2315, 2492, 2012, 1979, 1959,
             2399, 1870, 1741, 2400, 1871, 1742, 2401, 1872, 1743, 2402, 1873,
             1744}], 
           Line3DBox[{1746, 2277, 2451, 1745, 2278, 2452, 1747, 2279, 2453, 
            1748, 1960, 2454, 2309, 1749, 2068, 2505, 1961, 1987, 1962, 2069, 
            1750, 2504, 1957, 1978, 1958, 2174, 1751, 2339, 2539, 2146, 2196, 
            2147, 1752, 2548, 2167, 2168, 2549, 1753, 2169, 1964, 1990, 1965, 
            2522, 2327, 1754, 2070, 1967, 1992, 1968, 2523, 2071, 1755, 1969, 
            2455, 2310, 1756, 2562, 2229, 2230, 1757, 2403, 1874, 1758, 2404, 
            1875, 1759}], 
           Line3DBox[{1761, 2280, 2456, 1760, 2281, 2457, 1762, 2282, 2458, 
            1763, 2081, 2459, 2328, 1764, 2299, 2506, 1963, 1908, 2100, 1765, 
            2493, 1909, 1993, 1910, 2155, 1766, 2556, 2202, 2153, 2201, 2154, 
            1767, 2405, 2283, 2460, 1768, 1911, 1966, 1912, 2528, 1769, 2101, 
            1913, 1994, 2461, 2300, 2083, 2141, 2140, 1970, 2139, 2462, 2311, 
            2222, 1770, 2232, 2346, 2563, 2231, 2218, 1771, 2406, 1876, 1772, 
            2407, 1877, 1773}], 
           Line3DBox[{1775, 2284, 2463, 1774, 2285, 2464, 1776, 2286, 2465, 
            1777, 2084, 2466, 2329, 1778, 2102, 2103, 2533, 1995, 2105, 2104, 
            1779, 2212, 2507, 2344, 1980, 2228, 2227, 1780, 2564, 2234, 2235, 
            2233, 2223, 1781, 2408, 2287, 2467, 1782, 2082, 2093, 2173, 2551, 
            2337, 1783, 1914, 1971, 2468, 2301, 1784, 2189, 2190, 2469, 2221, 
            2220, 1785, 2225, 2226, 2561, 2224, 2219, 1786, 2288, 2470, 1787, 
            2409, 1878, 1788}], 
           Line3DBox[{1802, 1975, 2481, 2313, 1801, 2480, 2296, 1800, 2479, 
            2295, 1799, 2335, 2478, 2198, 2200, 2199, 1798, 2170, 2550, 2336, 
            1981, 1972, 1797, 2477, 2294, 1796, 2476, 2293, 2410, 1795, 2475, 
            2292, 1794, 2191, 2197, 2340, 2555, 2203, 1793, 2192, 2193, 2094, 
            2529, 2330, 1792, 2474, 2291, 1791, 2473, 2290, 1790, 2472, 2289, 
            1789, 2312, 2471, 1973, 1974}]}, 
          {GrayLevel[0.2], 
           Line3DBox[{826, 1004, 2347, 827, 2412, 1015, 850, 2414, 1027, 862, 
            2417, 1038, 874, 2422, 1049, 886, 2429, 1060, 897, 2437, 1071, 
            2378, 908, 1082, 2385, 919, 2447, 1092, 931, 2449, 1102, 943, 
            2452, 1112, 955, 2457, 1121, 966, 2464, 1130, 977, 2472, 1141, 
            990}], Line3DBox[{828, 1005, 2348, 829, 1016, 2357, 851, 2415, 
            1028, 863, 2418, 1039, 875, 2423, 1050, 887, 2430, 1061, 898, 
            2438, 1072, 2379, 909, 1083, 2386, 920, 1093, 2392, 932, 2450, 
            1103, 944, 2453, 1113, 956, 2458, 1122, 967, 2465, 1131, 978, 
            2473, 1142, 991}], 
           Line3DBox[{830, 1006, 2349, 831, 1017, 2358, 852, 1029, 2365, 864, 
            2419, 1040, 876, 2424, 1051, 888, 2431, 1584, 1585, 1062, 899, 
            2439, 1588, 1589, 1073, 2380, 910, 1552, 1553, 1084, 2387, 921, 
            1257, 1258, 1094, 2393, 933, 1262, 1263, 1104, 2398, 945, 2454, 
            1268, 1291, 1114, 957, 2459, 1445, 1446, 1123, 968, 2466, 1449, 
            1450, 1132, 979, 2474, 1143, 992}], Line3DBox[CompressedData["
1:eJwVz7FKAmAYheEvKiFoypZGb6ChQLfQC4gg6gJ0r6Cta8iaashBF6WhXKul
iLDBhhqKNBoiIQgSEsKCButxeHnPOR//8KcKG8vrIxGxhOxoxCdmJyJy/IuM
vMqnYxFnWNDz+rl8KV/wmr4lN+RrvIxHzCciBrZbfU6+44793ZbR23qan3jR
9sw7mLLt8ootKXfke+8esCd/YB9f7gNbC129zX84kHt4dC/xpm0a2+jrTfuk
/C0X+YdvbGU+1Ct8xTNo4M2tajuSa8P/8Qle7cdcH2b//weH2zY0
            "]], 
           Line3DBox[CompressedData["
1:eJwV0T0oxHEYwPFHXspioNi8TGy33mxQjBZWVybFwI7zfgYmBgY2MqkrUd5S
nKRQR5RFl83A5GXx+Q3fvt/n+f3+/7vrOnJj/aNVETGM7uqInZqIXWTqI/Z4
ElPImoucxyHezTP8XRtxhSNd4mvM6qLzU57Dj90tznQvT2NeH7hzyQu4s+tD
SQ9wHotpjyUMmh/4wjNDuqBfsJyeN+fw5ezVfJ/uYkU38iqXeQRldyrmY/2I
Nb3PFft1/axP8KHHOeoiNnSTfnJnU0/oenym32zXnD5bF7gFW+n99ud6O31n
bsCNXdb7fu16+I+7uDO1swy3oh1tePN//ANSHT+z
            "]], 
           Line3DBox[CompressedData["
1:eJwV0LsvQ3EYBuBPlGDyL9QtaWtz2VwSCylCN8a6TLQrsYpZTBIGM2Eg4rJJ
hMRASEe3pGkJO4vB0+HJ+33vOb9zck4yX8wV6iIiz0h9RKohYpM0+4mIbnlD
hvvmiENdj3mLXk7s/XKVPtYYYJBWHpwZlkPcccY5p/ojeckFV56TlduMc2uf
rJ1nonbWviNfnHuXuzzqZuU6M5Ts167PmfeY51m3KDdY4Mn1V92SeZmyuVj7
Rn1BNlHRHcs3XdWcbIxoo52q/ktfkR32Trr41n3qPkjZ0/zpMvJX98OUeZpE
S0ROjjFKyX8/cO+Kd5XN/5kVOB0=
            "]], Line3DBox[CompressedData["
1:eJwNz8Erw3EcxvEPRjn6E/YHUHOh5sJm3GjcsIMoKRzXFClXl1mt+AOc1GpF
SVm5rVykLYcdHFyxLTeU1+Hd+3k+z+97+CU3D/L7AxGRR3YoYnw4oowJXCci
JrmI19GIFNfcpriCadzoM3yINI4wiyrmcG/PcsP7Y87gBPPI4dZ9jBexgEff
L/EFOrZlbrqt8ilW8KSv8bN9nV/0Am+gLf9yz/bHP+jKZ+5vKONOP+dL//tp
/9C7fKX3+Uv/5ro+OCLrCX7Qt7zb1pvynrwjt+SSvCu/y/8ALzEA
            "]], 
           Line3DBox[{839, 1010, 2352, 840, 1593, 1021, 2559, 856, 1549, 2552,
             1032, 868, 1219, 2497, 1043, 880, 1229, 1054, 891, 2432, 1239, 
            1065, 902, 2440, 1249, 1076, 2508, 913, 1582, 1171, 1557, 1558, 
            2553, 1559, 925, 1562, 1176, 1561, 1563, 2554, 1564, 937, 1498, 
            1537, 1181, 1290, 2492, 1317, 1318, 949, 1423, 1272, 2523, 1293, 
            1319, 1320, 961, 1448, 2461, 1187, 1295, 1499, 1500, 972, 2468, 
            1190, 1136, 984, 2550, 1542, 1277, 1515, 1516, 1517, 999}], 
           Line3DBox[{841, 1011, 2353, 842, 1022, 2361, 857, 1033, 2367, 869, 
            2420, 1044, 881, 2426, 1055, 892, 2433, 1066, 903, 2441, 1594, 
            1077, 2560, 914, 1556, 1087, 2557, 926, 1560, 1097, 2394, 938, 
            1267, 1107, 2399, 950, 2455, 1273, 1117, 962, 1607, 2462, 1276, 
            1597, 1599, 1600, 973, 1605, 2469, 1565, 1603, 1137, 985, 2478, 
            1514, 1148, 1000}], 
           Line3DBox[{843, 1012, 2354, 844, 1023, 2362, 858, 1034, 2368, 870, 
            1045, 2371, 882, 2427, 1056, 893, 2434, 1067, 904, 2442, 1078, 
            2382, 915, 1088, 2389, 927, 1098, 2395, 939, 1108, 2400, 951, 
            1612, 2562, 1613, 1614, 1615, 2563, 1595, 1598, 1596, 1610, 1611, 
            2561, 1601, 1604, 1602, 986, 2479, 1149, 1001}], 
           Line3DBox[{845, 1013, 2355, 846, 1024, 2363, 859, 1035, 2369, 871, 
            1046, 2372, 883, 1057, 2374, 894, 2435, 1068, 905, 2443, 1079, 
            2383, 916, 1089, 2390, 928, 1099, 2396, 940, 1109, 2401, 952, 
            1118, 2403, 963, 1127, 2406, 974, 2470, 1138, 987, 2480, 1150, 
            1002}], Line3DBox[{847, 1201, 1202, 2356, 848, 1025, 2364, 860, 
            1036, 2370, 872, 1047, 2373, 884, 1058, 2375, 895, 1069, 2376, 
            906, 2444, 1080, 2384, 917, 1090, 2391, 929, 1100, 2397, 941, 
            1110, 2402, 953, 1119, 2404, 964, 1128, 2407, 975, 1139, 2409, 
            988, 2481, 1279, 1280, 1281}], 
           Line3DBox[{989, 1140, 1278, 2471, 976, 1129, 2463, 965, 1120, 2456,
             954, 1111, 2451, 942, 1101, 2448, 930, 1091, 2446, 918, 1081, 
            2445, 907, 2377, 1070, 2436, 896, 1059, 2428, 885, 1048, 2421, 
            873, 1037, 2416, 861, 1026, 2413, 849, 1014, 2411, 825, 1003, 
            2494, 1191, 1282}], Line3DBox[CompressedData["
1:eJwV0D8oxHEcxvGPfu6uG62cdJPxZKOMMt8NFqar60w/bEhZKJuFlL/JYFGU
knKllIVMogwYJIv8SbeweBnePc/n/Xx/dV2xOl5JWyJiFC9JxExrxH4+4k5P
9V39Uq/pG/qZPqJnshFNdyKPuDL37m5mIr6xxw1xb9yX+wPr3AB3wr3KSW4C
S/wF18stuot40sfkDuq4sc97180vuLtwq2/JbTzaN+W0NwX+R+/ElV6R5/Y1
WUbqTRt/qB/g2daQp6jasrY5/Z4vyIZ7Ra5iGcPe/GJW78Cxvf//N6APg7ZP
XPs+5/9p5xL04AElTOEP5ko1oQ==
            "]], Line3DBox[CompressedData["
1:eJwNzr8rhAEcx/Gv3E9EKXUL+TUYmOxGma+wEN2VYvBMDEwGg4H8AaZjsJDu
zsLgNsNJBqVMfoUbTRaD1/Du83nen+/z9AyVkuJ6W0Qs4rM9YjsVcZaPeNIT
vSMT0YVO/PJNfoVvpSM+cIkXvsI1bAuywD1zB3Ifdb7Ij+rXfJ/cxAZObTO2
un5lq8kGbnBku+Wm7HueR/CtH8sTVHDopuVmks/7x2EuizW8YxWP9l13Y25y
bga5DJbxiiVs2fvtA3oaD96Zk7NIbL22ez2FL9udbKJsy9p6fLfGd8sJjGPe
9ocqv+NmWn/Tf+S55wv8A68pMcg=
            "]]}, {}, {}}},
        VertexNormals->CompressedData["
1:eJx8fHc8le///1EZlZSSJBWlqOxdOJdSiUKUyKaMVFYZaVghIplRIlJGRvY+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         "]], {}},
      Axes->True,
      AxesLabel->{None, None, None},
      AxesOrigin->{Automatic, Automatic, Automatic},
      BoxRatios->{1, 1, 0.4},
      DisplayFunction->Identity,
      FaceGrids->None,
      FaceGridsStyle->Automatic,
      Method->{"DefaultBoundaryStyle" -> Directive[
          GrayLevel[0.3]], 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "RotationControl" -> "Globe"},
      PlotRange->{All, All, All},
      PlotRangePadding->{Automatic, Automatic, Automatic},
      Ticks->{Automatic, Automatic, Automatic}], {190.94596799373574, -150.675},
      ImageScaled[{0.5, 0.5}], {360, 287},
     ContentSelectable->True], InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwc23c81d8bAHAZRUZIZZSMjIR8C5XUo6hEVlEKJQ0locyQ3TBDZSejJGQW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           "]]},
         Annotation[#, "Charting`Private`Tag$909705#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0.06459878376653008},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{2.887762211323661, 1.4999999999999432`}, {
       6.03243714368125, 0.4999999999999716}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {541.2169437932796, -150.675}, 
     ImageScaled[{0.5, 0.5}], {296.75807962414467, 287}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[223]},
  PlotRange->{{0, 700.5419515990876}, {-301.35, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.793999858820609*^9, 3.8232282998725758`*^9},
 CellLabel->
  "Out[2292]=",ExpressionUUID->"2f7bb1ca-392e-4082-abd1-23ff1d81a3f0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "=", 
  RowBox[{
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "pym"}], " ", 
       RowBox[{"Log", "[", "pym", "]"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Xi]", "\[Rule]", "0.2"}], ",", 
        RowBox[{"u", "\[Rule]", "1"}], ",", 
        RowBox[{"\[Sigma]", "\[Rule]", "1"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], "]"}], "//",
    "Chop"}]}]], "Input",
 CellChangeTimes->{{3.6209350005797043`*^9, 3.620935004168874*^9}, {
  3.6209351280919037`*^9, 3.6209351477497597`*^9}, {3.620936090099082*^9, 
  3.620936098560137*^9}, {3.620936163499124*^9, 3.6209361881691113`*^9}, {
  3.620936254618346*^9, 3.620936268335671*^9}, {3.620936300386417*^9, 
  3.620936324368546*^9}, {3.621093354367841*^9, 3.621093356387231*^9}},
 CellLabel->
  "In[2293]:=",ExpressionUUID->"1854bbc7-32be-46fa-9667-1fd3647f6690"],

Cell[BoxData["1.0059815535199044`"], "Output",
 CellChangeTimes->{{3.620936184450528*^9, 3.6209361885729933`*^9}, {
   3.620936255769528*^9, 3.6209362694410973`*^9}, {3.620936301555194*^9, 
   3.620936325022993*^9}, 3.620962970968781*^9, 3.620967745082735*^9, {
   3.6210933500186243`*^9, 3.621093356852498*^9}, 3.7665829959589148`*^9, 
   3.79399974880978*^9, 3.823228300001589*^9},
 CellLabel->
  "Out[2293]=",ExpressionUUID->"2fde5902-7a17-495a-9341-52a8c6641728"]
}, Open  ]],

Cell["Explore continuous saturation function", "Text",
 CellChangeTimes->{{3.6208366978536386`*^9, 3.6208367060028267`*^9}},
 FontSize->24,
 Background->GrayLevel[
  0.85],ExpressionUUID->"36602a5c-4c59-42e0-b5ba-64e7a7d079e2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"u0_", ",", "u_"}], "]"}], ":=", 
  RowBox[{"u0", " ", 
   RowBox[{"Erf", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["\[Pi]"], "u"}], 
     RowBox[{"2", "u0"}]], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{
      RowBox[{"g", "[", 
       RowBox[{"u0", ",", "u"}], "]"}], "/.", 
      RowBox[{"u0", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}]}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "3.2"}], ",", "3.2"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.620836377654728*^9, 3.620836475526471*^9}, {
  3.620836525506323*^9, 3.620836532685402*^9}, {3.620836564332695*^9, 
  3.620836590465804*^9}, {3.620836644182332*^9, 3.620836673608943*^9}, {
  3.6208367519259653`*^9, 3.62083681642271*^9}, {3.620839215825952*^9, 
  3.620839253311236*^9}},
 CellLabel->
  "In[2294]:=",ExpressionUUID->"3dcb85d0-0c0d-4954-b04f-1e4e530d1871"],

Cell[BoxData[
 TemplateBox[{
  "Power", "infy", 
   "\"Infinite expression \\!\\(\\*FractionBox[\\\"1\\\", \\\"0\\\"]\\) \
encountered.\"", 2, 2295, 165, 24760908551451207083, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.620844168673208*^9, 3.620934598154477*^9, 
  3.6209629710494757`*^9, 3.620967745207698*^9, 3.766582996057686*^9, 
  3.793999748862761*^9, 3.82322830003909*^9},
 CellLabel->
  "During evaluation of \
In[2294]:=",ExpressionUUID->"a3d846e5-73ac-4d32-9621-7f5a5a3a21a7"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[{{-3.2, -3.2}, {-3.080289834949345, -3.080289834949345}, \
{-2.6569705331891815`, -2.6569705331891815`}, {-2.261854619413714, \
-2.261854619413714}, {-1.8337176038270244`, -1.8337176038270244`}, \
{-1.4133758129597247`, -1.4133758129597247`}, {-1.0212374100771209`, \
-1.0212374100771209`}, {-0.5960779053832947, -0.5960779053832947}, \
{-0.1991217886741647, -0.1991217886741647}, {0.19003910331557547`, 
       0.19003910331557547`}, {0.612221097116538, 0.612221097116538}, {
       1.0061997029328045`, 1.0061997029328045`}, {1.4331994105602932`, 
       1.4331994105602932`}, {1.8524038934683922`, 1.8524038934683922`}, {
       2.243404988391795, 2.243404988391795}, {2.6674271851264204`, 
       2.6674271851264204`}, {3.0632459938763494`, 3.0632459938763494`}, {3.2,
        3.2}}]},
     Annotation[#, "Charting`Private`Tag$909926#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJxN1GlI03EYB/C5XE1neU7923SHITWYipLiEWk2JpRHs61IMpsuxFYzFVOm
ljg1LchritO98Ggpo4wgNSm0ZlpaSwpntg5rOa8or+kS1yrQ59cDX7583n1f
PXSBmCvE43C4mL/51wXTMUsWi3c/bvMMElejbgM51uHzWvcvZFpIhlm8jPy0
opo4aUAm+o579b9Crs1OPnK1EVllldWGC0YmCDkB2GkG2PndM1FLFR3MVctT
9g3TwJKfB0SVeiq457I8vTPOC+2t5tF+N1DAHMXj2OjvHmDlUJ42KxEDJ0lr
ya/b3cCFydvukpxdwTgWtS+qxAX8/npDmWrMCUyxTetYOeQIPr+fSdBR7MEp
wZ/a1WoSmJkbarnYRgQ3f0wYyIskgKeLyOEcdzy4V7aXPcM3923Zf3ZixU+x
Cj7cq7Mx8xfAGR2dJkdnPZh/zrv5Tf4L8NDLiYrAhOcHtxzKenI/vl4PxueQ
P6RiC+AddvFFgh+r4OJJbVRmqxl8r7E0vnDJKmLL4pZUh298AjgpXe5ZVkQE
lx/LCQlsIoGtXWSGK+u7wOMjJQtSe0cwTyIIkqudwCLSPENzygVMVQ3WbZ8j
gyU9UQn2jW7gDKWoK8gPA9vhgwW+Ux5g9oXjMmYNBez+0FPM3uMFrs68VuU/
TgVzS+NYii4amJko5bUV0MFag01LDY8B1gimIp2o3uAv1rdNMgbyijKtE/NB
xubnKXQWcmrW0ppfGPJ6seVOzAlkn1uYR/lN5BCObtSuBvnobFNZZR3yJRbN
WK9AfvTAZ1SpQuYOBpYODCEL04zh0SPIubbdyyMaZEVs6Nm3Y8gz2ojwr/r/
9ubil4XTyDt3D3TMziEHnOG4LS4is61sNNlG5JOtw1KTCTmdfSMsfwN583+B
/wA+Uhvc
       "]], LineBox[CompressedData["
1:eJxF2nk0Vd37AHDjNXOvIpSQJkIIRcPeRZQoJZKIZCi8EiUkU4iSJqSiURJS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       "]], LineBox[CompressedData["
1:eJwt2nk0lO8XAHDZ9xjbGMvMoEJIkqXwPqlIIgmVSCQp2lRSIktJUpKtJAkh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       "]], 
      LineBox[CompressedData["
1:eJwt2nlUjN8bAPCWmXnbl2mdaapZKIV2QtRDqRBCi1Lak/RNmwopQook2kkr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       "]]},
     Annotation[#, "Charting`Private`Tag$909926#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-9.999999591836735, 9.999999591836735}, {-3.2, 3.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.620836441442235*^9, 3.6208364759686127`*^9}, 
   3.6208365360651293`*^9, {3.6208365684894943`*^9, 3.6208365916411123`*^9}, {
   3.620836646226843*^9, 3.620836675915101*^9}, {3.620836757455551*^9, 
   3.6208368171004763`*^9}, 3.620839254301271*^9, 3.620840697007833*^9, 
   3.620844168980022*^9, 3.6209345984638233`*^9, 3.620962971358317*^9, 
   3.620967745515263*^9, 3.766582996368417*^9, 3.7939997489797897`*^9, 
   3.823228300149127*^9},
 CellLabel->
  "Out[2295]=",ExpressionUUID->"3f106260-8961-491f-832b-8b948cc1c213"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"dgdu", "=", 
    RowBox[{
     SubscriptBox["\[PartialD]", "u"], 
     RowBox[{"g", "[", 
      RowBox[{"u0", ",", "u"}], "]"}]}]}], ",", 
   RowBox[{"dgdu", "/.", 
    RowBox[{"u", "\[Rule]", "0"}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.620837554234478*^9, 3.6208375582813473`*^9}, {
  3.620839275279799*^9, 3.620839298240638*^9}, {3.7939997944111557`*^9, 
  3.7939998069162607`*^9}},
 CellLabel->
  "In[2296]:=",ExpressionUUID->"0133eec6-8fb0-4595-8c34-189640e92358"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[Pi]", " ", 
       SuperscriptBox["u", "2"]}], 
      RowBox[{"4", " ", 
       SuperscriptBox["u0", "2"]}]]}]], ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{
  3.620837559618002*^9, {3.6208392805536327`*^9, 3.620839298566345*^9}, 
   3.620840700611874*^9, 3.6208441690195312`*^9, 3.620934598487665*^9, 
   3.620962971402219*^9, 3.6209677456645308`*^9, 3.7665829963813677`*^9, 
   3.793999748985942*^9, {3.793999796984487*^9, 3.7939998071152983`*^9}, 
   3.8232283001552753`*^9},
 CellLabel->
  "Out[2296]=",ExpressionUUID->"0025156e-7f38-4030-970e-a11eb5a0692e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Py0", "=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        FractionBox["1", 
         SqrtBox[
          RowBox[{"2", "\[Pi]", " "}]]], 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              FractionBox["2", "\[Pi]"], 
              SuperscriptBox["u0", "2"]}], "-", "1"}], ")"}]}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"InverseErf", "[", 
             FractionBox["y0", "u0"], "]"}], ")"}], "2"]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "u0"}], "<", "y0", "<", "u0"}]}], "}"}], "}"}], ",", 
    "y0"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.620840417376935*^9, 3.6208405909182177`*^9}, {
  3.6208406648726997`*^9, 3.620840679353177*^9}, {3.6208409192781353`*^9, 
  3.620840948572487*^9}, {3.6208411844740458`*^9, 3.620841231698944*^9}, {
  3.620842589553465*^9, 3.6208426203036947`*^9}, {3.62084339013837*^9, 
  3.620843471632763*^9}},
 CellLabel->
  "In[2297]:=",ExpressionUUID->"7515897f-6897-45a2-a725-d149d6e21e4d"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {
        FractionBox[
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             FractionBox[
              RowBox[{"2", " ", 
               SuperscriptBox["u0", "2"]}], "\[Pi]"]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"InverseErf", "[", 
             FractionBox["y0", "u0"], "]"}], "2"]}]], 
         SqrtBox[
          RowBox[{"2", " ", "\[Pi]"}]]], 
        RowBox[{
         RowBox[{"-", "u0"}], "<", "y0", "<", "u0"}]},
       {"y0", 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}},
      Selectable->True]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False,
  StripWrapperBoxes->True]], "Output",
 CellChangeTimes->{
  3.620840484186224*^9, {3.6208405808851643`*^9, 3.620840591322384*^9}, {
   3.620840680393372*^9, 3.6208407052782297`*^9}, {3.620841217014208*^9, 
   3.620841232042224*^9}, 3.620842621105362*^9, 3.620843472243247*^9, 
   3.6208441691209383`*^9, 3.620934598588026*^9, 3.620962971501122*^9, 
   3.620967745755875*^9, 3.76658299650803*^9, 3.7939997490190487`*^9, 
   3.8232283001787243`*^9},
 CellLabel->
  "Out[2297]=",ExpressionUUID->"959b1abf-0533-4584-8108-fa22e132aaf6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"Py0", ",", 
   RowBox[{"{", 
    RowBox[{"y0", ",", 
     RowBox[{"-", "u0"}], ",", "u0"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"u0", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6208428190320673`*^9, 3.6208428633999243`*^9}, {
  3.620843318589583*^9, 3.6208433274306602`*^9}},
 CellLabel->
  "In[2298]:=",ExpressionUUID->"a95cb3db-e8c7-4ee3-bb85-d558e56ac582"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{{3.620842842886949*^9, 3.620842870857136*^9}, {
   3.6208433205435247`*^9, 3.620843334801446*^9}, 3.620844176151314*^9, 
   3.620934605573612*^9, 3.620962978506812*^9, 3.620967752706913*^9, 
   3.766583022968528*^9, 3.793999767196989*^9, 3.823228310971073*^9},
 CellLabel->
  "Out[2298]=",ExpressionUUID->"5a7db05b-cdfb-41f4-bb7e-3fdd79656c3c"]
}, Open  ]],

Cell["\<\
As this is complicated (and qualitatively the same),  I decided to drop it \
for the book.\
\>", "Text",
 CellChangeTimes->{{3.620934644400361*^9, 3.6209346661713877`*^9}, {
  3.793999681428093*^9, 3.793999700414871*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"9ceda31c-5cd1-4616-88a0-de21742ae131"]
}, Open  ]]
},
WindowSize->{808, 752},
WindowMargins->{{Automatic, 213}, {Automatic, 65}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"0efe2bee-42a5-42c6-b58e-407d5c7f248e"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 186, 3, 67, "Section",ExpressionUUID->"ee864b8d-6920-4f56-b23e-d25d6384a043"],
Cell[769, 27, 175, 4, 30, "Input",ExpressionUUID->"ab4322c0-bde7-4aee-ad35-162268550380"],
Cell[947, 33, 802, 23, 58, "Input",ExpressionUUID->"e6a8f6ce-f14b-48b8-9c2c-f1e7cb56a820"],
Cell[CellGroupData[{
Cell[1774, 60, 306, 6, 30, "Input",ExpressionUUID->"a128603c-b4a2-4728-8f7a-05f30d1fc002"],
Cell[2083, 68, 653, 14, 54, "Output",ExpressionUUID->"c3d73459-fed7-4a98-8fb5-96d5af0661ec"]
}, Open  ]],
Cell[2751, 85, 1298, 37, 112, "Input",ExpressionUUID->"618d59c2-6040-4643-a154-b64fde8c7d9c"],
Cell[4052, 124, 282, 5, 52, "Text",ExpressionUUID->"b13852e1-1c59-441f-a539-242725bb387e"],
Cell[CellGroupData[{
Cell[4359, 133, 2151, 57, 89, "Input",ExpressionUUID->"a5ee9639-e7fd-4182-b6c6-63d13ad26504"],
Cell[6513, 192, 3376, 93, 101, "Output",ExpressionUUID->"14c7e640-c66a-4321-9fd0-443654a86d30"]
}, Open  ]],
Cell[9904, 288, 1450, 38, 84, "Input",ExpressionUUID->"313a1fe2-414b-4b24-9bb7-98614e6aea27"],
Cell[CellGroupData[{
Cell[11379, 330, 1395, 41, 73, "Input",ExpressionUUID->"4978b83d-c05f-45d5-af2d-fa523dab0c53"],
Cell[12777, 373, 168300, 2767, 240, "Output",ExpressionUUID->"2f7bb1ca-392e-4082-abd1-23ff1d81a3f0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[181114, 3145, 994, 24, 30, "Input",ExpressionUUID->"1854bbc7-32be-46fa-9667-1fd3647f6690"],
Cell[182111, 3171, 467, 7, 34, "Output",ExpressionUUID->"2fde5902-7a17-495a-9341-52a8c6641728"]
}, Open  ]],
Cell[182593, 3181, 227, 4, 62, "Text",ExpressionUUID->"36602a5c-4c59-42e0-b5ba-64e7a7d079e2"],
Cell[CellGroupData[{
Cell[182845, 3189, 1181, 34, 76, "Input",ExpressionUUID->"3dcb85d0-0c0d-4954-b04f-1e4e530d1871"],
Cell[184029, 3225, 514, 11, 40, "Message",ExpressionUUID->"a3d846e5-73ac-4d32-9621-7f5a5a3a21a7"],
Cell[184546, 3238, 41529, 701, 240, "Output",ExpressionUUID->"3f106260-8961-491f-832b-8b948cc1c213"]
}, Open  ]],
Cell[CellGroupData[{
Cell[226112, 3944, 526, 14, 30, "Input",ExpressionUUID->"0133eec6-8fb0-4595-8c34-189640e92358"],
Cell[226641, 3960, 698, 17, 55, "Output",ExpressionUUID->"0025156e-7f38-4030-970e-a11eb5a0692e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[227376, 3982, 1165, 32, 53, "Input",ExpressionUUID->"7515897f-6897-45a2-a725-d149d6e21e4d"],
Cell[228544, 4016, 2171, 60, 81, "Output",ExpressionUUID->"959b1abf-0533-4584-8108-fa22e132aaf6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[230752, 4081, 451, 11, 30, "Input",ExpressionUUID->"a95cb3db-e8c7-4ee3-bb85-d558e56ac582"],
Cell[231206, 4094, 392, 6, 34, "Output",ExpressionUUID->"5a7db05b-cdfb-41f4-bb7e-3fdd79656c3c"]
}, Open  ]],
Cell[231613, 4103, 327, 7, 51, "Text",ExpressionUUID->"9ceda31c-5cd1-4616-88a0-de21742ae131"]
}, Open  ]]
}
]
*)

