(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     46955,        847]
NotebookOptionsPosition[     46037,        822]
NotebookOutlinePosition[     46435,        838]
CellTagsIndexPosition[     46392,        835]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Optimizing input distribution  (Figure 15.4)", "Section",
 CellChangeTimes->{{3.794000285175191*^9, 
  3.794000318562195*^9}},ExpressionUUID->"5e989071-ec13-405b-a0ba-\
f380d284f283"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.618195122322299*^9, 3.618195123796472*^9}},
 CellLabel->
  "In[2253]:=",ExpressionUUID->"f4c7f5ba-f2e4-4b9b-b655-c4dd812e2568"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Erf", "[", 
    FractionBox["x", 
     SqrtBox["2"]], "]"}]}], ";", 
  RowBox[{"g1", "=", 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], "g"}]}]}]], "Input",
 CellChangeTimes->{{3.618195129448846*^9, 3.61819515431763*^9}, {
  3.7940003563595953`*^9, 3.794000379622855*^9}},
 CellLabel->
  "In[2254]:=",ExpressionUUID->"6e5f4586-646c-4ff8-8be5-962ca477feeb"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}]], " ", 
  SqrtBox[
   FractionBox["2", "\[Pi]"]]}]], "Output",
 CellChangeTimes->{{3.6181951348767843`*^9, 3.618195156267109*^9}, {
   3.794000349007998*^9, 3.7940003831082582`*^9}, 3.823228198308543*^9},
 CellLabel->
  "Out[2254]=",ExpressionUUID->"3789f6e4-39f4-4963-9b53-095d7bea6cbb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"g", ",", "g1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.618195164268444*^9, 3.618195177116509*^9}},
 CellLabel->
  "In[2255]:=",ExpressionUUID->"b21a532f-ef6d-494b-81bc-22cc016458e4"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF2nk0Vd37AHDDNU93lEiGJkmURIi9Q5okRag0kZLklSISGpCESKmkSJKQ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       "]]},
     Annotation[#, "Charting`Private`Tag$825021#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwUl3c8V98fx5G9x+fzsXeEIlTKuPdcCfkqJNl7hyRZEdlJKJSE7GQ07Fk+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       "]]},
     Annotation[#, "Charting`Private`Tag$825021#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.618195178785185*^9, {3.794000349063416*^9, 3.7940003831440697`*^9}, 
   3.8232281983562107`*^9},
 CellLabel->
  "Out[2255]=",ExpressionUUID->"b0f0fe3f-4eea-4457-953e-171bab8db338"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 752},
WindowMargins->{{Automatic, 220}, {Automatic, 42}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"c085786b-c847-4c6b-a964-2b77844c74c1"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 189, 3, 67, "Section",ExpressionUUID->"5e989071-ec13-405b-a0ba-f380d284f283"],
Cell[772, 27, 241, 5, 30, "Input",ExpressionUUID->"f4c7f5ba-f2e4-4b9b-b655-c4dd812e2568"],
Cell[CellGroupData[{
Cell[1038, 36, 418, 12, 51, "Input",ExpressionUUID->"6e5f4586-646c-4ff8-8be5-962ca477feeb"],
Cell[1459, 50, 421, 11, 57, "Output",ExpressionUUID->"3789f6e4-39f4-4963-9b53-095d7bea6cbb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1917, 66, 362, 10, 30, "Input",ExpressionUUID->"b21a532f-ef6d-494b-81bc-22cc016458e4"],
Cell[2282, 78, 43727, 740, 263, "Output",ExpressionUUID->"b0f0fe3f-4eea-4457-953e-171bab8db338"]
}, Open  ]]
}, Open  ]]
}
]
*)

