(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     58344,       1200]
NotebookOptionsPosition[     55761,       1146]
NotebookOutlinePosition[     56159,       1162]
CellTagsIndexPosition[     56116,       1159]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Control effort for a first-order system  (Section 14.5)", "Section",
 CellChangeTimes->{{3.735423238101478*^9, 3.7354232503075657`*^9}, {
  3.7374659067985086`*^9, 3.737465917412478*^9}, {3.738161889688607*^9, 
  3.7381618970326977`*^9}, {3.793997249301652*^9, 
  3.793997253210416*^9}},ExpressionUUID->"80fed873-0dd1-414d-a31f-\
ead85dc68f76"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[2547]:=",ExpressionUUID->"3330eff7-ffab-49d4-aca7-f2778a3476af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Wg", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", "\[Lambda]", " ", "t"}]], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.738162099040057*^9, 3.738162137619575*^9}},
 CellLabel->
  "In[2548]:=",ExpressionUUID->"54276c0f-d6a9-4d67-a3fd-d758fa338a6e"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", " ", "\[Lambda]", " ", "\[Tau]"}]]}], 
  RowBox[{"2", " ", "\[Lambda]"}]]], "Output",
 CellChangeTimes->{
  3.738162138189535*^9, 3.738164571071487*^9, 3.7381712637604733`*^9, 
   3.73817130357065*^9, 3.738189447564973*^9, 3.738189522945491*^9, 
   3.738189632796479*^9, 3.73818981245753*^9, {3.738190862590837*^9, 
   3.738190871605077*^9}, 3.765828552727713*^9, 3.765828789462761*^9, 
   3.7939972558646793`*^9, 3.823228757617332*^9},
 CellLabel->
  "Out[2548]=",ExpressionUUID->"275cd40b-7467-409a-ad46-4c5f06253b02"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"umin", "=", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[Lambda]", 
     RowBox[{"(", 
      RowBox[{"\[Tau]", "-", "t"}], ")"}]}]], 
   FractionBox["1", "Wg"], 
   RowBox[{"(", 
    RowBox[{"x\[Tau]", "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Lambda]", " ", "\[Tau]"}]], "x0"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.738162143070533*^9, 3.738162145570965*^9}, {
  3.738164584703691*^9, 3.7381646683654118`*^9}},
 CellLabel->
  "In[2549]:=",ExpressionUUID->"c6dd6e39-bbab-4ac7-afd4-769b23e81761"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "t"}], "+", "\[Tau]"}], ")"}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[Lambda]", " ", "\[Tau]"}]]}], " ", "x0"}], "+", 
     "x\[Tau]"}], ")"}], " ", "\[Lambda]"}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", " ", "\[Lambda]", " ", "\[Tau]"}]]}]]], "Output",
 CellChangeTimes->{{3.738164637579026*^9, 3.7381646690570498`*^9}, 
   3.738171263908473*^9, 3.738171303704898*^9, 3.7381894477374487`*^9, 
   3.738189523060914*^9, 3.738189632896793*^9, 3.738189812574771*^9, {
   3.73819086269129*^9, 3.738190871720063*^9}, 3.76582855273916*^9, 
   3.765828789541255*^9, 3.793997255870452*^9, 3.8232287576233797`*^9},
 CellLabel->
  "Out[2549]=",ExpressionUUID->"5a42886f-53a4-4faa-9218-79e844ee14df"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"effort", " ", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x\[Tau]", "-", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[Lambda]", " ", "\[Tau]"}]], "x0"}]}], ")"}], "2"], " ", 
    FractionBox["1", "Wg"]}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.738171236262825*^9, 3.738171259793438*^9}, 
   3.738189463174529*^9},
 CellLabel->
  "In[2550]:=",ExpressionUUID->"7850dada-88b9-48b6-b3a8-24b707da1723"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[Lambda]", " ", "\[Tau]"}]]}], " ", "x0"}], "+", 
      "x\[Tau]"}], ")"}], "2"], " ", "\[Lambda]"}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", " ", "\[Lambda]", " ", "\[Tau]"}]]}]]], "Output",
 CellChangeTimes->{{3.7381712565026293`*^9, 3.738171264255765*^9}, 
   3.738171303956183*^9, {3.738189448253808*^9, 3.738189468739506*^9}, 
   3.7381895231802673`*^9, 3.738189633012549*^9, 3.7381898126909647`*^9, {
   3.738190862788632*^9, 3.73819087181787*^9}, 3.765828552797285*^9, 
   3.7658287895541973`*^9, 3.793997255909689*^9, 3.823228757650949*^9},
 CellLabel->
  "Out[2550]=",ExpressionUUID->"f97414e5-6674-4592-ae07-3ceba99143fd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "-", 
      RowBox[{"\[Lambda]", " ", 
       RowBox[{"x", "[", "t", "]"}]}]}], " ", "\[Equal]", "umin"}], ",", 
    RowBox[{
     RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.7381678677547817`*^9, 3.738167929937525*^9}, {
   3.73816796110852*^9, 3.7381679627220383`*^9}, {3.738167998396696*^9, 
   3.738167999962112*^9}, 3.738189573878105*^9, {3.7381896632329607`*^9, 
   3.738189663325018*^9}, {3.738189796761587*^9, 3.7381898259357557`*^9}},
 CellLabel->
  "In[2551]:=",ExpressionUUID->"ed49f6f0-f984-40a6-9a6a-cda71615ce36"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Lambda]"}], " ", 
      RowBox[{"x", "[", "t", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["x", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Lambda]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "t"}], "+", "\[Tau]"}], ")"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"\[Lambda]", " ", "\[Tau]"}]]}], " ", "x0"}], "+", 
        "x\[Tau]"}], ")"}], " ", "\[Lambda]"}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[Lambda]", " ", "\[Tau]"}]]}]]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.738167897521797*^9, 3.738167930351905*^9}, 
   3.73816796380413*^9, 3.738168004882237*^9, 3.738171264962022*^9, 
   3.738171304791913*^9, 3.738189448887505*^9, 3.73818952329387*^9, 
   3.73818957452698*^9, 3.738189633131035*^9, 3.73818966415396*^9, {
   3.7381898128249893`*^9, 3.738189826770698*^9}, {3.738190862888356*^9, 
   3.738190871937953*^9}, 3.765828552857017*^9, 3.765828789628736*^9, 
   3.7939972559158163`*^9, 3.823228757662327*^9},
 CellLabel->
  "Out[2551]=",ExpressionUUID->"ce76526c-ae81-4e11-9ff6-959d00fd3a03"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xs", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"DSolveValue", "[", 
     RowBox[{"eq", ",", 
      RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}], "//", "ExpToTrig"}], "//",
    "Simplify", "  ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"invariant", " ", "for", " ", "\[Lambda]"}], " ", "\[Rule]", " ", 
     RowBox[{"-", "\[Lambda]"}]}], "  ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.738167956760223*^9, 3.7381680225034637`*^9}, {
  3.7381896705361567`*^9, 3.738189672300572*^9}, {3.7381901662542543`*^9, 
  3.738190173154057*^9}, {3.7381905525288*^9, 3.738190571669366*^9}},
 CellLabel->
  "In[2552]:=",ExpressionUUID->"fc01c9c2-dce4-44dd-8839-68c3b2bf5961"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Csch", "[", 
   RowBox[{"\[Lambda]", " ", "\[Tau]"}], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x\[Tau]", " ", 
     RowBox[{"Sinh", "[", 
      RowBox[{"t", " ", "\[Lambda]"}], "]"}]}], "-", 
    RowBox[{"x0", " ", 
     RowBox[{"Sinh", "[", 
      RowBox[{"\[Lambda]", " ", 
       RowBox[{"(", 
        RowBox[{"t", "-", "\[Tau]"}], ")"}]}], "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.738168016841014*^9, 3.738168023020603*^9}, 
   3.738171265077034*^9, 3.738171304921754*^9, 3.7381894490047407`*^9, 
   3.7381895234146767`*^9, 3.7381895768016653`*^9, 3.738189633249406*^9, {
   3.7381896674202623`*^9, 3.738189672884522*^9}, {3.738189812939073*^9, 
   3.7381898290070477`*^9}, {3.738190169139511*^9, 3.738190173678743*^9}, 
   3.738190578112653*^9, {3.7381908655211897`*^9, 3.738190872086361*^9}, 
   3.7658285531398087`*^9, 3.7658287898268127`*^9, 3.793997256026059*^9, 
   3.823228757867378*^9},
 CellLabel->
  "Out[2552]=",ExpressionUUID->"8482c94e-05f7-4f5e-a5e1-310721171980"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"xs", "/.", 
   RowBox[{"t", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "\[Tau]"}], "}"}]}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.738168927031927*^9, 3.7381689303740664`*^9}, {
  3.738189595247696*^9, 3.738189598185382*^9}, {3.765828642626042*^9, 
  3.765828645206168*^9}},
 CellLabel->
  "In[2553]:=",ExpressionUUID->"51434853-d642-4044-8b47-63358fac49e6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x0", ",", "x\[Tau]"}], "}"}]], "Output",
 CellChangeTimes->{
  3.738168930886916*^9, 3.73817126521513*^9, 3.738171305054541*^9, 
   3.738189449255631*^9, 3.738189523530772*^9, {3.7381895809123287`*^9, 
   3.7381895987382183`*^9}, 3.738189633362924*^9, 3.7381896756897993`*^9, {
   3.738189813042596*^9, 3.738189831334938*^9}, {3.738190865718019*^9, 
   3.738190872185031*^9}, 3.765828553150569*^9, 3.7658286154755363`*^9, 
   3.765828645639412*^9, 3.765828789837945*^9, 3.7939972560310783`*^9, 
   3.823228757872842*^9},
 CellLabel->
  "Out[2553]=",ExpressionUUID->"770f758e-f357-4893-a282-eda602120b7d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmax", "=", "20"}], ";", 
  RowBox[{"pars0", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Lambda]", "\[Rule]", "1"}], ",", 
     RowBox[{"x0", "\[Rule]", "1"}], ",", 
     RowBox[{"x\[Tau]", "\[Rule]", "2"}], ",", 
     RowBox[{"\[Tau]", "\[Rule]", "tmax"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"xs", "/.", "pars0"}], ",", 
     RowBox[{"umin", "/.", "pars0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.738189838267941*^9, 3.738189923612417*^9}, {
   3.73818999499326*^9, 3.738190015931555*^9}, {3.738190075802826*^9, 
   3.738190085302706*^9}, {3.738190544972321*^9, 3.738190546782288*^9}, {
   3.7658287968486023`*^9, 3.765828882063426*^9}, 3.765830978958482*^9, {
   3.76583151662202*^9, 3.765831529067017*^9}, 3.765832746141281*^9, {
   3.7658328521253777`*^9, 3.765832942977868*^9}},
 CellLabel->
  "In[2554]:=",ExpressionUUID->"3d3150f9-6c91-48bd-9e38-5f4b53727471"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwdWnc4l+/3N5KRMiMj3sueb+8+qdA5QkYoW5KMshPKKFqIzKwkWRVlKyF7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       "]]},
     Annotation[#, "Charting`Private`Tag$1157441#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVl3c8F/4Tx+2QsrL33nyGUORzyciIUhpIZjISyigqRRGJZJeZFVllRHq/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       "]]},
     Annotation[#, "Charting`Private`Tag$1157441#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7381899080536213`*^9, 3.738189924001906*^9}, 
   3.7381900206487703`*^9, {3.738190076841188*^9, 3.738190085951255*^9}, 
   3.738190547971224*^9, {3.7381908658519506`*^9, 3.7381908723297873`*^9}, 
   3.765828553363104*^9, {3.765828789958377*^9, 3.765828883098713*^9}, 
   3.765830979702283*^9, 3.765831529962535*^9, 3.765832746821912*^9, {
   3.7658328671372557`*^9, 3.7658329438244553`*^9}, 3.793997256105424*^9, 
   3.8232287579413958`*^9},
 CellLabel->
  "Out[2555]=",ExpressionUUID->"7f05fd00-27ad-498d-88b7-28f0e8d107cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"umin", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Lambda]", "\[Rule]", "1"}], ",", 
     RowBox[{"x0", "\[Rule]", "1"}], ",", 
     RowBox[{"x\[Tau]", "\[Rule]", "1"}]}], "}"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.765832813884244*^9, 3.765832829935912*^9}},
 CellLabel->
  "In[2556]:=",ExpressionUUID->"5bfe4baf-fa59-452c-88d7-94773de555e0"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["2", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "t"], "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"t", "-", "\[Tau]"}]]}]]}]], "Output",
 CellChangeTimes->{{3.765832811507498*^9, 3.765832830427575*^9}, 
   3.793997256145499*^9, 3.823228757974629*^9},
 CellLabel->
  "Out[2556]=",ExpressionUUID->"1001b74c-24af-4c89-a4b4-f3334128d795"]
}, Open  ]],

Cell[TextData[{
 "Conclusion:  \tFast ops (\[Tau] <<  ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Lambda]", 
    RowBox[{"-", "1"}]], TraditionalForm]],ExpressionUUID->
  "7d7e6abc-6ba3-4a50-87d9-58c8dd22425c"],
 "):  effort ~",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{" ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x\[Tau]", " ", "-", " ", "x0"}], ")"}], "^", "2"}]}], 
    "\[Tau]"], TraditionalForm]],ExpressionUUID->
  "86a6d020-1da5-48ee-ac0c-1434b6d650a3"],
 "\n\t\t\tSlow ops (\[Tau] >>  ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Lambda]", 
    RowBox[{"-", "1"}]], TraditionalForm]],ExpressionUUID->
  "1223c698-e796-4370-9467-ad8ed5307a27"],
 "):  effort ratio ~ ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", "|", "\[Lambda]", "|", "\[Tau]"}]], TraditionalForm]],
  ExpressionUUID->"c6e7bd4d-2db8-4e5f-8bfa-8dab70afab65"],
 "\n\t\t\tThe zero in effort is for the natural (uncontrolled, with u=0) \
protocol.  If you ask for the right \t\t\t\txtau and the right tau, this \
works."
}], "Text",
 CellChangeTimes->{{3.7381704738015423`*^9, 3.738170595012917*^9}, {
  3.765831075808147*^9, 3.765831129645665*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"87e3bdb7-7d63-4930-a398-d02cfffe2642"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pars", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Lambda]", "\[Rule]", "1"}], ",", 
     RowBox[{"x0", "\[Rule]", "1"}], ",", 
     RowBox[{"x\[Tau]", "\[Rule]", "2"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"effort", "/.", "pars"}], ",", 
     RowBox[{
      RowBox[{"2", "\[Lambda]", " ", 
       SuperscriptBox["x0", "2"]}], "/.", "pars"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Tau]", ",", "0.1", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Thin", ",", "Dashed"}], "}"}]}], "}"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.7658291192888737`*^9, 3.765829196854039*^9}, {
   3.765829229568392*^9, 3.765829257444428*^9}, {3.765830986501706*^9, 
   3.7658310414594707`*^9}, {3.7658314898545933`*^9, 3.76583149952328*^9}, {
   3.765831534514806*^9, 3.765831556681312*^9}, 3.765831739847897*^9},
 CellLabel->
  "In[2557]:=",ExpressionUUID->"446c801e-27f9-4a01-b5aa-9fe2d0e5275d"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd13c4lt8fB3Drm5299/MQKqLQ5HPMKGlJCBkhkRLJqszKDIkICdmkrFRG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       "]]},
     Annotation[#, "Charting`Private`Tag$1157568#1"]& ], 
    TagBox[
     {GrayLevel[0], Thickness[Tiny], Opacity[1.], Dashing[{Small, Small}], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQveZy9N85M3faM0CAw9QOqeZZNifh/FWTDzsbX7sE
53vku7Y903gA55va2B4MLXkG5194teyaxoI3cP6B73LpH1d8hPOv9pr0zT/x
Bc7/ci5BzVH7B5z/iuHYapG633D+XLfSmJ3T/8H5a2fL7tf4xeAAVz93aerd
biY4f5LEKabVoixw/v4XlRGfDrDC+acPnXNe5M8O58d8Wvf89H8OOD9ilnYT
3wouON/Yx3fTTmMeOH9y8K9Z9x7wwvkXU3wkcwr54fxTT0VW7JwoAOcnXb24
72SaIJz/0jNRoU9XCGF+plkcP6swnJ/De++ZyzkE//bby6/aJovA+TyV/Kdb
M0XhfN1O2W8WhmJwvoBL4d8VnOJwvqa1cIPqPQTfcHu7b9gSCTj/z13H787V
knD+ts5zr586S8H5ywpXRk/hkEaED8up5f/vIvg/pffayS+VgfNj733d+LtG
Fs7foMpY0OMmB+dbroxaqckjD+e3XP+5r/kRgh9/dCu/Z6gCwrwSwXXrDiL4
ZY4iXVI6inA+e2BDd0I/gv/TlP83y28EPymWfUJzvBKc/2zRsiSOQwj+mb0Z
i1/rKCPCS3oK58oJCH6Ud1pjyAkEv6fa4uf//wg+ABXryTY=
       "]]},
     Annotation[#, "Charting`Private`Tag$1157568#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.765829122176785*^9, 3.765829197411433*^9}, {
   3.7658292324371233`*^9, 3.765829258020301*^9}, {3.765830987046515*^9, 
   3.765831042230481*^9}, 3.765831557243926*^9, 3.76583174144764*^9, 
   3.793997256202848*^9, 3.823228758007325*^9},
 CellLabel->
  "Out[2558]=",ExpressionUUID->"a96392fd-6903-4e8f-a4bd-d5ce36a59d99"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 755},
WindowMargins->{{Automatic, 173}, {Automatic, 13}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"49fc95f8-784d-42a7-982b-b5805ded281a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 350, 5, 67, "Section",ExpressionUUID->"80fed873-0dd1-414d-a31f-ead85dc68f76"],
Cell[933, 29, 175, 4, 30, "Input",ExpressionUUID->"3330eff7-ffab-49d4-aca7-f2778a3476af"],
Cell[CellGroupData[{
Cell[1133, 37, 410, 10, 33, "Input",ExpressionUUID->"54276c0f-d6a9-4d67-a3fd-d758fa338a6e"],
Cell[1546, 49, 643, 14, 53, "Output",ExpressionUUID->"275cd40b-7467-409a-ad46-4c5f06253b02"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2226, 68, 584, 16, 50, "Input",ExpressionUUID->"c6dd6e39-bbab-4ac7-afd4-769b23e81761"],
Cell[2813, 86, 1012, 25, 57, "Output",ExpressionUUID->"5a42886f-53a4-4faa-9218-79e844ee14df"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3862, 116, 510, 14, 50, "Input",ExpressionUUID->"7850dada-88b9-48b6-b3a8-24b707da1723"],
Cell[4375, 132, 886, 21, 58, "Output",ExpressionUUID->"f97414e5-6674-4592-ae07-3ceba99143fd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5298, 158, 725, 17, 30, "Input",ExpressionUUID->"ed49f6f0-f984-40a6-9a6a-cda71615ce36"],
Cell[6026, 177, 1531, 39, 57, "Output",ExpressionUUID->"ce76526c-ae81-4e11-9ff6-959d00fd3a03"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7594, 221, 697, 16, 30, "Input",ExpressionUUID->"fc01c9c2-dce4-44dd-8839-68c3b2bf5961"],
Cell[8294, 239, 1042, 23, 34, "Output",ExpressionUUID->"8482c94e-05f7-4f5e-a5e1-310721171980"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9373, 267, 418, 10, 30, "Input",ExpressionUUID->"51434853-d642-4044-8b47-63358fac49e6"],
Cell[9794, 279, 644, 12, 34, "Output",ExpressionUUID->"770f758e-f357-4893-a282-eda602120b7d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10475, 296, 1133, 27, 52, "Input",ExpressionUUID->"3d3150f9-6c91-48bd-9e38-5f4b53727471"],
Cell[11611, 325, 29213, 501, 236, "Output",ExpressionUUID->"7f05fd00-27ad-498d-88b7-28f0e8d107cf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40861, 831, 411, 11, 30, "Input",ExpressionUUID->"5bfe4baf-fa59-452c-88d7-94773de555e0"],
Cell[41275, 844, 399, 10, 52, "Output",ExpressionUUID->"1001b74c-24af-4c89-a4b4-f3334128d795"]
}, Open  ]],
Cell[41689, 857, 1289, 36, 124, "Text",ExpressionUUID->"87e3bdb7-7d63-4930-a398-d02cfffe2642"],
Cell[CellGroupData[{
Cell[43003, 897, 1183, 31, 77, "Input",ExpressionUUID->"446c801e-27f9-4a01-b5aa-9fe2d0e5275d"],
Cell[44189, 930, 11544, 212, 267, "Output",ExpressionUUID->"a96392fd-6903-4e8f-a4bd-d5ce36a59d99"]
}, Open  ]]
}, Open  ]]
}
]
*)

