(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      5522,        150]
NotebookOptionsPosition[      4640,        127]
NotebookOutlinePosition[      5037,        143]
CellTagsIndexPosition[      4994,        140]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
graphSimple \[Dash] illustration of a simple graph   (Section 14.1)\
\>", "Section",
 CellChangeTimes->{{3.734787329262885*^9, 3.734787348056664*^9}, {
  3.79399819029976*^9, 
  3.793998218186349*^9}},ExpressionUUID->"d1f6349e-d17f-4e16-962c-\
4f8142b11890"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[2543]:=",ExpressionUUID->"45ab6c53-e437-4ef6-b02d-2553a00451f9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "123", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"g0", "=", 
  RowBox[{"RandomGraph", "[", 
   RowBox[{
    RowBox[{"BarabasiAlbertGraphDistribution", "[", 
     RowBox[{"6", ",", "2"}], "]"}], ",", 
    RowBox[{"VertexStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"White", ",", 
       RowBox[{"EdgeForm", "[", 
        RowBox[{"Thickness", "[", "0.005", "]"}], "]"}]}], "]"}]}], ",", 
    RowBox[{"VertexSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Scaled\>\"", ",", " ", "0.05"}], "}"}]}], ",", 
    RowBox[{"EdgeStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", 
       RowBox[{"Thickness", "[", "0.008", "]"}]}], "]"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.7347874718573217`*^9, 3.7347874871224003`*^9}},
 CellLabel->
  "In[2544]:=",ExpressionUUID->"5258510a-6a75-4a98-b4b1-012ec7b5cd58"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6}, {
      Null, SparseArray[
       Automatic, {6, 6}, 0, {
        1, {{0, 3, 7, 9, 9, 9, 9}, {{2}, {3}, {6}, {3}, {4}, {5}, {6}, {4}, {
          5}}}, {1, 1, 1, 1, 1, 1, 1, 1, 1}}]}, {EdgeStyle -> {
         Directive[
          GrayLevel[0], 
          Thickness[0.008]]}, VertexSize -> {{"Scaled", 0.05}}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[
           Thickness[0.005]]]}}]]}, 
    TagBox[
     GraphicsGroupBox[
      GraphicsComplexBox[{{1.399687097155563, 1.3103002656646525`}, {
       0.8694442192798187, 0.7593673263463527}, {0.2518233813081381, 
       0.9552383259180206}, {0., 1.6905045849562712`}, {0.07099200833551511, 
       0.}, {2.0480620791622477`, 0.715291644788242}}, {
        {GrayLevel[0], Thickness[0.008], Opacity[0.7], Arrowheads[0.], 
         ArrowBox[{{1, 2}, {1, 3}, {1, 6}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {3,
           4}, {3, 5}}, 0.06639071862777848]}, 
        {GrayLevel[1], EdgeForm[{GrayLevel[0], Opacity[0.7], Thickness[
         0.005]}], DiskBox[1, 0.06639071862777848], 
         DiskBox[2, 0.06639071862777848], DiskBox[3, 0.06639071862777848], 
         DiskBox[4, 0.06639071862777848], DiskBox[5, 0.06639071862777848], 
         DiskBox[6, 0.06639071862777848]}}]],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{
  3.734787366247493*^9, {3.734787482325754*^9, 3.734787495618875*^9}, 
   3.73478990981428*^9, 3.7939981762077208`*^9, 3.793998221627482*^9, 
   3.8232287458689632`*^9},
 CellLabel->
  "Out[2545]=",ExpressionUUID->"c4b4a66e-39d2-4093-bc4a-c44c31955bea"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.79399816009391*^9, 3.793998166032802*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"30d9be8e-4b7e-407b-b847-86422e6c6bc8"],

Cell[BoxData[
 RowBox[{"(*", " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<graphSimple0.pdf\>\"", ",", "g0"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.734787394469529*^9, 3.734787396559547*^9}, {
  3.793998141921777*^9, 3.7939981575874*^9}},
 CellLabel->
  "In[2546]:=",ExpressionUUID->"7442f245-bf48-4a80-b5d4-8c4619ba927d"]
}, Open  ]]
},
WindowSize->{808, 755},
WindowMargins->{{Automatic, 68}, {Automatic, 45}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"d7218fd5-2d42-43fc-95a7-90b6d0768c8c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 268, 6, 67, "Section",ExpressionUUID->"d1f6349e-d17f-4e16-962c-4f8142b11890"],
Cell[851, 30, 175, 4, 30, "Input",ExpressionUUID->"45ab6c53-e437-4ef6-b02d-2553a00451f9"],
Cell[CellGroupData[{
Cell[1051, 38, 927, 23, 94, "Input",ExpressionUUID->"5258510a-6a75-4a98-b4b1-012ec7b5cd58"],
Cell[1981, 63, 1924, 41, 320, "Output",ExpressionUUID->"c4b4a66e-39d2-4093-bc4a-c44c31955bea"]
}, Open  ]],
Cell[3920, 107, 180, 3, 51, "Text",ExpressionUUID->"30d9be8e-4b7e-407b-b847-86422e6c6bc8"],
Cell[4103, 112, 521, 12, 124, "Input",ExpressionUUID->"7442f245-bf48-4a80-b5d4-8c4619ba927d"]
}, Open  ]]
}
]
*)

