(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15673,        424]
NotebookOptionsPosition[     13593,        380]
NotebookOutlinePosition[     13989,        396]
CellTagsIndexPosition[     13946,        393]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Dilation calculations   (Problem 14.7)", "Section",
 CellChangeTimes->{{3.7353896624694567`*^9, 3.735389667906332*^9}, {
  3.735758988567378*^9, 3.735758993698924*^9}, {3.793996678788105*^9, 
  3.793996691184101*^9}},ExpressionUUID->"efe0e596-0e78-4841-9626-\
ceeb3ea61669"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.7357581513026943`*^9, 3.73575816233538*^9}},
 CellLabel->
  "In[2430]:=",ExpressionUUID->"7a8795b1-920a-48d3-9f2c-b31f746f7d6a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"amat", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "0", "0"},
      {"a21", "a22", "0"},
      {"a31", "0", "0"}
     }], "\[NoBreak]", ")"}]}], ";", " ", 
  RowBox[{"bmat", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"b"},
      {"0"},
      {"0"}
     }], "\[NoBreak]", ")"}]}], ";", " ", 
  RowBox[{"cmat", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0", "0"}
     }], "\[NoBreak]", ")"}]}], ";", " ", 
  RowBox[{"sys", "=", 
   RowBox[{"StateSpaceModel", "[", 
    RowBox[{"{", 
     RowBox[{"amat", ",", "bmat", ",", "cmat"}], "}"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.735758164813705*^9, 3.735758299711885*^9}},
 CellLabel->
  "In[2431]:=",ExpressionUUID->"7d441464-f0ca-4986-ac61-bafc0e602399"],

Cell[BoxData[
 TemplateBox[{
  "0", "0", "0", "b", "a21", "a22", "0", "0", "a31", "0", "0", "0", "1", "0", 
   "0", "0", 
   InterpretationBox["\[InvisibleSpace]", None], {
   StateSpaceModel, {
    False, False, {
     False, False}}, {$CellContext`stname1, $CellContext`stname2, \
$CellContext`stname3}, {{Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$, 
      Control`CommonDump`$DUMMY$}}, Identity, Automatic, 1, 1, 3, 1, {}, {
    False, False}, False, Automatic, None, Automatic}, {}},
  "StateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{#, #2, #3, #4}, {#5, #6, #7, #8}, {#9, #10, #11, #12}, {#13, \
#14, #15, #16}}, AllowedDimensions -> {4, 4}, 
        GridBoxDividers -> {"Rows" -> {False, False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}, 
          "Columns" -> {False, False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
        "SystemsModelGrid00"], ")"}], #17, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalS]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None], MultilineFunction -> None], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{1, 3}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{5, 7}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{9, 11}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{4, 4}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{8, 8}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{12, 12}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{13, 15}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{16, 16}, ","], "}"}], "}"}], "}"}], ",", 
     "SamplingPeriod", "->", 
     RowBox[{#17}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
  Tooltip->StateSpaceModel]], "Output",
 CellChangeTimes->{{3.7357582811212997`*^9, 3.735758300724812*^9}, 
   3.735874174622731*^9, 3.793996731985716*^9, 3.823228607782346*^9},
 CellLabel->
  "Out[2431]=",ExpressionUUID->"b7e78d46-562d-4fb2-9da6-530515053d04"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Wc", "=", 
   RowBox[{"ControllabilityMatrix", "[", "sys", "]"}]}], ";", 
  RowBox[{"MatrixForm", "[", "Wc", "]"}]}]], "Input",
 CellChangeTimes->{{3.735758304684195*^9, 3.7357583126567307`*^9}},
 CellLabel->
  "In[2432]:=",ExpressionUUID->"040fe4a2-db46-4cd7-8327-2efc66d9c13b"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"b", "0", "0"},
     {"0", 
      RowBox[{"a21", " ", "b"}], 
      RowBox[{"a21", " ", "a22", " ", "b"}]},
     {"0", 
      RowBox[{"a31", " ", "b"}], "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.735758306973322*^9, 3.7357583131280117`*^9}, 
   3.735874176310772*^9, 3.793996732053281*^9, 3.823228607831149*^9},
 CellLabel->
  "Out[2432]//MatrixForm=",ExpressionUUID->"19525fa9-faf5-45d5-9b74-\
dcd9b5d6a268"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MatrixRank", "[", "Wc", "]"}], ",", 
   RowBox[{"Det", "[", "Wc", "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.735758318448925*^9, 3.735758320991252*^9}, {
  3.735874165163117*^9, 3.735874171231841*^9}},
 CellLabel->
  "In[2433]:=",ExpressionUUID->"cdebca90-18cb-4b48-bf40-9effcfa61f93"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{
    RowBox[{"-", "a21"}], " ", "a22", " ", "a31", " ", 
    SuperscriptBox["b", "3"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.7357583213466263`*^9, 3.735874178634877*^9, 
  3.7939967320582447`*^9, 3.823228607836658*^9},
 CellLabel->
  "Out[2433]=",ExpressionUUID->"0eaae79a-f30b-4db7-b3bd-bf10f22adb6b"]
}, Open  ]],

Cell[TextData[StyleBox["The system has strong structural controllability, as \
the determinant vanishes iff one of the system coefs =0.",
 Background->GrayLevel[0.85]]], "Text",
 CellChangeTimes->{{3.735759031480906*^9, 3.735759064110955*^9}, 
   3.79399674165142*^9},ExpressionUUID->"e143a48f-dfda-4976-87f6-\
106805beeff2"],

Cell[TextData[StyleBox["Now add a second self-link to node 3.",
 FontColor->RGBColor[1, 0, 0]]], "Text",
 CellChangeTimes->{{3.7358741343081703`*^9, 
  3.735874148952792*^9}},ExpressionUUID->"aafaa1a8-6526-43c2-8c0e-\
530dda9496e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"amat2", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "0", "0"},
      {"a21", "a22", "0"},
      {"a31", "0", "a33"}
     }], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"sys2", "=", 
   RowBox[{"StateSpaceModel", "[", 
    RowBox[{"{", 
     RowBox[{"amat2", ",", "bmat", ",", "cmat"}], "}"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7358741835696497`*^9, 3.735874201152898*^9}},
 CellLabel->
  "In[2434]:=",ExpressionUUID->"6a97fe82-ba25-4974-bfa0-d9a21976eb1a"],

Cell[BoxData[
 TemplateBox[{
  "0", "0", "0", "b", "a21", "a22", "0", "0", "a31", "0", "a33", "0", "1", 
   "0", "0", "0", 
   InterpretationBox["\[InvisibleSpace]", None], {
   StateSpaceModel, {
    False, False, {
     False, False}}, {$CellContext`stname1, $CellContext`stname2, \
$CellContext`stname3}, {{Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$, 
      Control`CommonDump`$DUMMY$}}, Identity, Automatic, 1, 1, 3, 1, {}, {
    False, False}, False, Automatic, None, Automatic}, {}},
  "StateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{#, #2, #3, #4}, {#5, #6, #7, #8}, {#9, #10, #11, #12}, {#13, \
#14, #15, #16}}, AllowedDimensions -> {4, 4}, 
        GridBoxDividers -> {"Rows" -> {False, False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}, 
          "Columns" -> {False, False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
        "SystemsModelGrid00"], ")"}], #17, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalS]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None], MultilineFunction -> None], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{1, 3}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{5, 7}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{9, 11}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{4, 4}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{8, 8}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{12, 12}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{13, 15}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{16, 16}, ","], "}"}], "}"}], "}"}], ",", 
     "SamplingPeriod", "->", 
     RowBox[{#17}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
  Tooltip->StateSpaceModel]], "Output",
 CellChangeTimes->{3.735874202837573*^9, 3.793996732125049*^9, 
  3.823228607895234*^9},
 CellLabel->
  "Out[2434]=",ExpressionUUID->"26926727-b026-4ff6-99c1-8d491e8b88f9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Wc2", "=", 
   RowBox[{"ControllabilityMatrix", "[", "sys2", "]"}]}], ";", 
  RowBox[{"MatrixForm", "[", "Wc2", "]"}]}]], "Input",
 CellChangeTimes->{{3.7358742094243193`*^9, 3.735874213488467*^9}},
 CellLabel->
  "In[2435]:=",ExpressionUUID->"82708e29-677c-421a-9aa5-e2f394b52aff"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"b", "0", "0"},
     {"0", 
      RowBox[{"a21", " ", "b"}], 
      RowBox[{"a21", " ", "a22", " ", "b"}]},
     {"0", 
      RowBox[{"a31", " ", "b"}], 
      RowBox[{"a31", " ", "a33", " ", "b"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.7358742141520033`*^9, 3.7939967321828833`*^9, 
  3.823228607952036*^9},
 CellLabel->
  "Out[2435]//MatrixForm=",ExpressionUUID->"6739cca3-ff73-43b3-8178-\
d1305bac6d6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MatrixRank", "[", "Wc2", "]"}], ",", 
   RowBox[{"Det", "[", "Wc2", "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.735874220728018*^9, 3.735874221920027*^9}},
 CellLabel->
  "In[2436]:=",ExpressionUUID->"a0a1fdc9-44a7-4aaa-a0cb-12599e66f86f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "a21"}], " ", "a22", " ", "a31", " ", 
     SuperscriptBox["b", "3"]}], "+", 
    RowBox[{"a21", " ", "a31", " ", "a33", " ", 
     SuperscriptBox["b", "3"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.7358742223949537`*^9, 3.793996732188566*^9, 
  3.823228607957769*^9},
 CellLabel->
  "Out[2436]=",ExpressionUUID->"ccc92f63-efcc-46e2-98b9-4440e6d161d8"]
}, Open  ]],

Cell[TextData[StyleBox["The determinant vanishes when a22=a33; \
controllability is lost for this non-generic case.  \n(If a symmetry were to \
force this equality, then the system would not be controllable generically.)",
 
 FontColor->RGBColor[1, 0, 0]]], "Text",
 CellChangeTimes->{{3.735874239292468*^9, 3.735874300699973*^9}, {
  3.793996744319603*^9, 3.793996765959485*^9}, {3.793996796556842*^9, 
  3.7939968399870872`*^9}},ExpressionUUID->"f328dce1-33ed-4e32-ba46-\
23b8da03cfe5"]
}, Open  ]]
},
WindowSize->{808, 755},
WindowMargins->{{Automatic, 33}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a6cd49ac-f89b-44b4-9af0-4f0802c714b7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 280, 4, 67, "Section",ExpressionUUID->"efe0e596-0e78-4841-9626-ceeb3ea61669"],
Cell[863, 28, 242, 5, 30, "Input",ExpressionUUID->"7a8795b1-920a-48d3-9f2c-b31f746f7d6a"],
Cell[CellGroupData[{
Cell[1130, 37, 782, 24, 88, "Input",ExpressionUUID->"7d441464-f0ca-4986-ac61-bafc0e602399"],
Cell[1915, 63, 3077, 71, 91, "Output",ExpressionUUID->"b7e78d46-562d-4fb2-9da6-530515053d04"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5029, 139, 314, 7, 30, "Input",ExpressionUUID->"040fe4a2-db46-4cd7-8327-2efc66d9c13b"],
Cell[5346, 148, 849, 24, 80, "Output",ExpressionUUID->"19525fa9-faf5-45d5-9b74-dcd9b5d6a268"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6232, 177, 342, 8, 30, "Input",ExpressionUUID->"cdebca90-18cb-4b48-bf40-9effcfa61f93"],
Cell[6577, 187, 368, 9, 37, "Output",ExpressionUUID->"0eaae79a-f30b-4db7-b3bd-bf10f22adb6b"]
}, Open  ]],
Cell[6960, 199, 325, 5, 35, "Text",ExpressionUUID->"e143a48f-dfda-4976-87f6-106805beeff2"],
Cell[7288, 206, 232, 4, 35, "Text",ExpressionUUID->"aafaa1a8-6526-43c2-8c0e-530dda9496e1"],
Cell[CellGroupData[{
Cell[7545, 214, 510, 14, 61, "Input",ExpressionUUID->"6a97fe82-ba25-4974-bfa0-d9a21976eb1a"],
Cell[8058, 230, 3030, 71, 91, "Output",ExpressionUUID->"26926727-b026-4ff6-99c1-8d491e8b88f9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11125, 306, 317, 7, 30, "Input",ExpressionUUID->"82708e29-677c-421a-9aa5-e2f394b52aff"],
Cell[11445, 315, 845, 25, 80, "Output",ExpressionUUID->"6739cca3-ff73-43b3-8178-d1305bac6d6e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12327, 345, 295, 7, 30, "Input",ExpressionUUID->"a0a1fdc9-44a7-4aaa-a0cb-12599e66f86f"],
Cell[12625, 354, 449, 12, 37, "Output",ExpressionUUID->"ccc92f63-efcc-46e2-98b9-4440e6d161d8"]
}, Open  ]],
Cell[13089, 369, 488, 8, 58, "Text",ExpressionUUID->"f328dce1-33ed-4e32-ba46-23b8da03cfe5"]
}, Open  ]]
}
]
*)

