(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     14918,        386]
NotebookOptionsPosition[     12815,        345]
NotebookOutlinePosition[     13211,        361]
CellTagsIndexPosition[     13168,        358]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Explore phase transition to a connected graph in ER model
Problem 14.2  (and also Section 14.1.3, Random networks)\
\>", "Section",
 CellChangeTimes->{{3.734206057003047*^9, 3.734206067364386*^9}, {
  3.734903156313593*^9, 3.734903167423464*^9}, {3.7939969912099943`*^9, 
  3.793997042820112*^9}},ExpressionUUID->"95f21faa-7f6f-4ac3-a29f-\
2aa120f50470"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{3.793997053162036*^9},
 CellLabel->
  "In[2418]:=",ExpressionUUID->"65ba8195-31e7-408a-913c-402fa7341787"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalD]", "[", 
   RowBox[{"n_", ",", "p_"}], "]"}], ":=", 
  RowBox[{"GraphPropertyDistribution", "[", 
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{"ConnectedGraphQ", "[", "g", "]"}], "]"}], ",", 
    RowBox[{"g", "\[Distributed]", 
     RowBox[{"BernoulliGraphDistribution", "[", 
      RowBox[{"n", ",", "p"}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->
  "In[2419]:=",ExpressionUUID->"949b6be3-d3c3-446c-8a2d-948e20c4d4d9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"prob1", "[", 
   RowBox[{"n_", ",", "p_"}], "]"}], ":=", 
  RowBox[{"NProbability", "[", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], ",", 
    RowBox[{"x", "\[Distributed]", 
     RowBox[{"\[ScriptCapitalD]", "[", 
      RowBox[{"n", ",", "p"}], "]"}]}], ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<MonteCarlo\>\"", ",", 
       RowBox[{"PrecisionGoal", "\[Rule]", "1"}], ",", ",", 
       RowBox[{"AccuracyGoal", "\[Rule]", "1"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->
  "In[2420]:=",ExpressionUUID->"0a94c526-af19-4922-8a40-3f6322983279"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pcrit", "[", "n_", "]"}], ":=", 
  FractionBox[
   RowBox[{"Log", "[", "n", "]"}], 
   RowBox[{"n", "-", "1"}]]}]], "Input",
 CellLabel->
  "In[2421]:=",ExpressionUUID->"902fa5bd-2881-4862-ae01-7a47f875fac3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"pcrit", "[", "1000.", "]"}], ",", 
   RowBox[{"prob1", "[", 
    RowBox[{"1000", ",", "0.012"}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.793997159137499*^9, 3.793997164005488*^9}},
 CellLabel->
  "In[2422]:=",ExpressionUUID->"9401ef1c-1640-465e-934b-903bd439532f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.006914669948931067`", ",", "0.9965`"}], "}"}]], "Output",
 CellChangeTimes->{3.7349032501303663`*^9, 3.793997094542801*^9, 
  3.793997164874044*^9, 3.823228583326674*^9},
 CellLabel->
  "Out[2422]=",ExpressionUUID->"7390a637-fd40-4ac7-9b2e-0b94586d720c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p1000", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["p", 
        RowBox[{"pcrit", "[", "1000", "]"}]], ",", 
       RowBox[{"prob1", "[", 
        RowBox[{"1000", ",", "p"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "0.005", ",", "0.012"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "20"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "0"}], ",", 
     RowBox[{"Mesh", "->", "All"}], ",", 
     RowBox[{"MeshStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.03", "]"}], ",", "Red"}], "]"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.734903326149432*^9, {3.7939970910924664`*^9, 3.793997091930214*^9}},
 CellLabel->
  "In[2423]:=",ExpressionUUID->"46c009e5-9723-48db-8887-b6ca2d6ba600"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pcrit", "[", "100.", "]"}]], "Input",
 CellLabel->
  "In[2424]:=",ExpressionUUID->"361ef986-eb5c-4a21-8021-2fc7129724e1"],

Cell[BoxData["0.046516870565536286`"], "Output",
 CellChangeTimes->{3.734903285646834*^9, 3.79399710470643*^9, 
  3.8232285928784313`*^9},
 CellLabel->
  "Out[2424]=",ExpressionUUID->"61cdacb6-7067-4b39-8450-db6f7b4ac721"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p100", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["p", 
        RowBox[{"pcrit", "[", "100", "]"}]], ",", 
       RowBox[{"prob1", "[", 
        RowBox[{"100", ",", "p"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "0.025", ",", "0.07"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "30"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "0"}], ",", 
     RowBox[{"Mesh", "->", "All"}], ",", 
     RowBox[{"MeshStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.03", "]"}], ",", "Green"}], "]"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{3.793997086527829*^9},
 CellLabel->
  "In[2425]:=",ExpressionUUID->"99f968c7-000d-45a1-b7b6-230e79e343dc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"pcrit", "[", "10.", "]"}], ",", 
   RowBox[{"prob1", "[", 
    RowBox[{"10", ",", "0.7"}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.793997144388535*^9, 3.793997150357543*^9}},
 CellLabel->
  "In[2426]:=",ExpressionUUID->"fe145ece-8df9-4ae1-990d-a2dbcc0328b4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.2558427881104495`", ",", "0.999875`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7349033000452137`*^9, {3.793997138039998*^9, 3.793997150928719*^9}, 
   3.823228594545825*^9},
 CellLabel->
  "Out[2426]=",ExpressionUUID->"c53d7487-557d-4aff-9f0a-e10a41f598dc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p10", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["p", 
        RowBox[{"pcrit", "[", "10", "]"}]], ",", 
       RowBox[{"prob1", "[", 
        RowBox[{"10", ",", "p"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "0.07", ",", "0.4"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "30"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "0"}], ",", 
     RowBox[{"Mesh", "->", "All"}], ",", 
     RowBox[{"MeshStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.03", "]"}], ",", "Blue"}], "]"}]}], ",", 
     
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{3.7939970822620173`*^9},
 CellLabel->
  "In[2427]:=",ExpressionUUID->"a8f3cdc9-65bd-4d26-90d3-e13716adb536"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"p10", ",", "p100", ",", "p1000"}], "}"}], "]"}]], "Input",
 CellLabel->
  "In[2428]:=",ExpressionUUID->"202222be-9093-46bb-9181-a0e0bb1b69aa"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQ7WL5fe+Bpov2f1Z+vOSb5GBfcWuF1RL7K1B+gP06
2en6NebX7a3v+/dOzyuyzyosX/Tzz00ov8m+MZrXpmfLHfub574HP17abT/9
+X1f4eX37XfItb4O3DHPXsbp0rv5xg/tua4vLrDlWm6f/fBSkcHGR/Zf/l6p
eKm20f6Ft17XafUn9ny6m+a+X77NfsW+pgTL1qf2IY+Xzj6icMA+o+lrkSLD
c/uHVSLr3B8ess/xS3S5k/jC3se80zHh6Qn7uU/VVy7c89J+22eQgefsz53l
8Xpo8trekGONTFTKZXuXfa9Wfp78xj4I7KAr9rv+P3NtEHhnb28at8uT55Z9
FI9dqXjbe3vNmP5DXzXu2C8QOL7RofCDPUi39f379lOc/x0z0vtoD5aOeWi/
8tdG6757H+2NweCxvf2tknPL5n6y/1WXtadk8hP7LPmnq1wiP9tXvlQDOuGZ
/Y4XF595c3yBWMf03L711lkHgWNf7Kc5d+c8//3cvjTA7Zdt+Vd7HibtdrGb
L+x/a+f8/aDyzX4VKPgFXtkzGiyUS3z4zf6bBsgFr+y1dgTNt5r43R7kOv/e
1/aXMoTtLvr/sFdla5zq3P3G/tMsm2PvmH/al++bL6V/9409AE9B+O4=
     "], {{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
         Opacity[1.], FaceForm[Opacity[0.3]], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30}]},
        Annotation[#, "Charting`Private`Tag$1017655#1"]& ]}, {
       {RGBColor[0, 0, 1], PointSize[0.03], AbsoluteThickness[1.6], Opacity[
        1.], FaceForm[Opacity[0.3]], 
        PointBox[{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30}]}, {}}}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQ3b7KU2OL0UP7Pys/XvJNCrD/7cZT3mn5CM7XX/C0
qCrsMZSfYD91/8/azoQn9tUi69wfVqXYx32fWJ6Q+tR+lycPk3Z7m/2z1w5y
wQ3P7G+e+x78eOls+4XLtK4kdzy3P/xVI6b/0FJ7WTlt8wnLXtgzgMEG+99r
13e07H9pP825O+f57532XCz5L6cdfWXvBTJO7KD9TTHX70cevrb/ATLtyAn7
O+9DRQRfv7EXB1tw1t7p4St51fdv7SdLsITx6V6yT++fdiOE8739SzVDjjUy
1+zvN9oFBHJ8sLe+7987Pe+WfbbUXi626R/sS8Ea7tqr76/dI6f8EeqfB/Z/
j90uPbb0o/2/KxVAIx7Zm+geZa0x/mS/b76U/l2VJ/bN37znHtj+yf7gqYWu
2z4/tTeWi+MWdv9sDzZe6Lm9cNCmgpOXP9sH7ZBrfR34wp7v5eK7fOFf7Lec
KAMa8dI+456CYtLTL/ZzjihsKMp4aX/bzDrHJeurfQrYga/sG2ZPX9f15qv9
UZD0xNf2rXH1x+9VfrO3N40DBvEb+0UtLC8O/v1mv+3zX6AL39grcIre39Tz
3b44Y+LbGvu39nvfGbOeFP5hPyNPqPnAqbf2AK8a9WQ=
     "], {{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
         Opacity[1.], FaceForm[Opacity[0.3]], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30}]},
        Annotation[#, "Charting`Private`Tag$1017147#1"]& ]}, {
       {RGBColor[0, 1, 0], PointSize[0.03], AbsoluteThickness[1.6], Opacity[
        1.], FaceForm[Opacity[0.3]], 
        PointBox[{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30}]}, {}}}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQ3eGk7bJY+bn9r7qsPSWTI+wf257aX3j8hb31ff/e
6XlN9oveRQpO6Htlr3z7J1DFEvuVJ58Vtpq/sTfkWCMTlbLb/v/ynHMqN97a
G4PBafsd1o8ZROa8txeIsNxyouya/Z0abcW3Cz7Yg3j75t+z79t2V6ei9aO9
vWncLk+eJ/YvC3vMbqR+sgdymLTbn9mnHtp5XNn8s73bts9/r1S8tJ+Se99Z
XOqLffm++VL6d1/ZP1/b7P7t7Rf7ZbOPKGwoemP/OF/Fc9Xer/YsYXy6m+a+
te/r2WvKNv+b/fPfKz9e8n1nH2t3daVv4Xd7iHHv7O97PeWwDf1hD3a+9Xt7
9psfUxlNf9p/WH7M27zzvX3Inxqvjay/7F26c4BGvLcPrmKQ4nzxy37WTBB4
b2+zjaE19shve6Bl75cfe28PAKDwp6s=
     "], {{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
         Opacity[1.], FaceForm[Opacity[0.3]], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20}]},
        Annotation[#, "Charting`Private`Tag$1016801#1"]& ]}, {
       {RGBColor[1, 0, 0], PointSize[0.03], AbsoluteThickness[1.6], Opacity[
        1.], FaceForm[Opacity[0.3]], 
        PointBox[{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
         19, 20}]}, {}}}], {}}},
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.27360552359904866`, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.7349033168743963`*^9, 3.734903351285611*^9, 
  3.793997138558855*^9, 3.823228595038715*^9},
 CellLabel->
  "Out[2428]=",ExpressionUUID->"af905ccf-1f49-4018-963a-7402e88058e5"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.7939970642255383`*^9, 3.793997067969613*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"30316474-9ba3-4c3e-a530-039f0c2b9e39"],

Cell[BoxData[
 RowBox[{"(*", " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<ERtrans10.dat\>\"", ",", 
     RowBox[{"p10", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{
  3.738610085728023*^9, {3.793997056581882*^9, 3.793997062422366*^9}},
 CellLabel->
  "In[2429]:=",ExpressionUUID->"dcfe9258-9f7d-4b4d-9f5c-1d77d3b24862"]
}, Open  ]]
},
WindowSize->{808, 755},
WindowMargins->{{Automatic, 77}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e4007351-33c1-4081-a4b1-5f9185ef4c10"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 364, 7, 105, "Section",ExpressionUUID->"95f21faa-7f6f-4ac3-a29f-2aa120f50470"],
Cell[947, 31, 217, 5, 30, "Input",ExpressionUUID->"65ba8195-31e7-408a-913c-402fa7341787"],
Cell[1167, 38, 480, 12, 52, "Input",ExpressionUUID->"949b6be3-d3c3-446c-8a2d-948e20c4d4d9"],
Cell[1650, 52, 625, 17, 52, "Input",ExpressionUUID->"0a94c526-af19-4922-8a40-3f6322983279"],
Cell[2278, 71, 243, 7, 47, "Input",ExpressionUUID->"902fa5bd-2881-4862-ae01-7a47f875fac3"],
Cell[CellGroupData[{
Cell[2546, 82, 324, 8, 30, "Input",ExpressionUUID->"9401ef1c-1640-465e-934b-903bd439532f"],
Cell[2873, 92, 296, 6, 34, "Output",ExpressionUUID->"7390a637-fd40-4ac7-9b2e-0b94586d720c"]
}, Open  ]],
Cell[3184, 101, 939, 24, 98, "Input",ExpressionUUID->"46c009e5-9723-48db-8887-b6ca2d6ba600"],
Cell[CellGroupData[{
Cell[4148, 129, 145, 3, 30, "Input",ExpressionUUID->"361ef986-eb5c-4a21-8021-2fc7129724e1"],
Cell[4296, 134, 222, 4, 34, "Output",ExpressionUUID->"61cdacb6-7067-4b39-8450-db6f7b4ac721"]
}, Open  ]],
Cell[4533, 141, 886, 23, 98, "Input",ExpressionUUID->"99f968c7-000d-45a1-b7b6-230e79e343dc"],
Cell[CellGroupData[{
Cell[5444, 168, 318, 8, 30, "Input",ExpressionUUID->"fe145ece-8df9-4ae1-990d-a2dbcc0328b4"],
Cell[5765, 178, 302, 7, 34, "Output",ExpressionUUID->"c53d7487-557d-4aff-9f0a-e10a41f598dc"]
}, Open  ]],
Cell[6082, 188, 888, 24, 98, "Input",ExpressionUUID->"a8f3cdc9-65bd-4d26-90d3-e13716adb536"],
Cell[CellGroupData[{
Cell[6995, 216, 207, 5, 30, "Input",ExpressionUUID->"202222be-9093-46bb-9181-a0e0bb1b69aa"],
Cell[7205, 223, 4810, 96, 266, "Output",ExpressionUUID->"af905ccf-1f49-4018-963a-7402e88058e5"]
}, Open  ]],
Cell[12030, 322, 183, 3, 51, "Text",ExpressionUUID->"30316474-9ba3-4c3e-a530-039f0c2b9e39"],
Cell[12216, 327, 583, 15, 124, "Input",ExpressionUUID->"dcfe9258-9f7d-4b4d-9f5c-1d77d3b24862"]
}, Open  ]]
}
]
*)

