(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[    232380,       5451]
NotebookOptionsPosition[    224862,       5313]
NotebookOutlinePosition[    225260,       5329]
CellTagsIndexPosition[    225217,       5326]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Control effort diverges for nearly identical first-order systems
Problem 14.11\
\>", "Section",
 CellChangeTimes->{{3.735423238101478*^9, 3.7354232503075657`*^9}, {
  3.7365406826528397`*^9, 3.736540692760747*^9}, {3.736626994310307*^9, 
  3.7366269955429*^9}, {3.736782638196594*^9, 3.736782640969318*^9}, {
  3.7367897036883287`*^9, 3.736789703980927*^9}, {3.793998507433649*^9, 
  3.793998509939929*^9}},ExpressionUUID->"e7c05409-7c1b-4a25-9441-\
bed3f14f65ef"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{3.736540675429278*^9},
 CellLabel->
  "In[2437]:=",ExpressionUUID->"3c5cba3b-1bf4-4240-a5c8-686484243826"],

Cell[TextData[{
 "Start with arbitrary way to fix u[t];  \[Lambda]=",
 Cell[BoxData[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1"},
     {"2"}
    }], "\[NoBreak]", ")"}]],
  CellChangeTimes->{{3.736645402848913*^9, 3.736645455926855*^9}},
  ExpressionUUID->"ec7e690e-76bc-4fdd-88d3-5653164d1177"],
 "; ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"target", " ", "state", " ", 
     SubscriptBox["x", "\[Tau]"]}], "="}], TraditionalForm]],ExpressionUUID->
  "666a5e31-7a94-4d21-8d4a-e05d3b8b1c23"],
 Cell[BoxData[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0"},
     {"1"}
    }], "\[NoBreak]", ")"}]],
  CellChangeTimes->{{3.736645402848913*^9, 3.736645455926855*^9}},
  ExpressionUUID->"5a032649-8341-4ea3-904e-77d65f9eda48"],
 "at \[Tau]=1;"
}], "Text",
 CellChangeTimes->{{3.736635962686264*^9, 3.736635977575574*^9}, {
  3.736647215301148*^9, 3.736647265280281*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"9a52bbaa-a057-451e-95de-ca26e6797a33"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"uNaive", "=", 
    RowBox[{"u0", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"u1", "-", "u0"}], ")"}], 
      RowBox[{"UnitStep", "[", 
       RowBox[{"t", "-", 
        FractionBox["1", "2"]}], "]"}]}]}]}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"tstart", "~", "0.405"}], " ", "makes", " ", "u1"}], "=", 
    RowBox[{"-", 
     RowBox[{"u0", "~", "3.8"}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "+", 
       RowBox[{"\[Lambda]", " ", 
        RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", "uNaive"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"xs", "=", 
  RowBox[{
   RowBox[{"DSolveValue", "[", 
    RowBox[{"eqs", ",", 
     RowBox[{"{", 
      RowBox[{"x", "[", "t", "]"}], "}"}], ",", "t"}], "]"}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.736636327608869*^9, 3.736636347756071*^9}, {
  3.736636732314176*^9, 3.736636748748295*^9}, {3.736636811027605*^9, 
  3.736636832609735*^9}, {3.73663841566509*^9, 3.736638416198318*^9}, {
  3.736638649015809*^9, 3.736638677378974*^9}, {3.736639004717259*^9, 
  3.736639129137006*^9}},
 CellLabel->
  "In[2438]:=",ExpressionUUID->"3955d148-5ec0-4dd6-90b3-0ffcad072ff4"],

Cell[BoxData[
 RowBox[{"{", 
  TagBox[GridBox[{
     {"\[Piecewise]", GridBox[{
        {
         FractionBox[
          RowBox[{"u0", "-", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "t"}], " ", "\[Lambda]"}]], " ", "u0"}]}], 
          "\[Lambda]"], 
         RowBox[{
          RowBox[{"2", " ", "t"}], "\[LessEqual]", "1"}]},
        {
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "t"}], " ", "\[Lambda]"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"\[Lambda]", "/", "2"}]]}], ")"}], " ", "u0"}], "+", 
             
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{"\[Lambda]", "/", "2"}]]}], "+", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"t", " ", "\[Lambda]"}]]}], ")"}], " ", "u1"}]}], 
            ")"}]}], "\[Lambda]"], 
         TagBox["True",
          "PiecewiseDefault",
          AutoDelete->True]}
       },
       AllowedDimensions->{2, Automatic},
       Editable->True,
       GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.84]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}},
       Selectable->True]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   "Piecewise",
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True,
   Selectable->False,
   StripWrapperBoxes->True], "}"}]], "Output",
 CellChangeTimes->{{3.736638585296067*^9, 3.736638588470587*^9}, {
   3.7366386499455013`*^9, 3.7366386779247007`*^9}, {3.736639007409577*^9, 
   3.736639021872635*^9}, {3.736639055959879*^9, 3.73663912977378*^9}, 
   3.73664004957537*^9, 3.736643213551794*^9, 3.7366433293260117`*^9, 
   3.736643460205707*^9, 3.736643543523099*^9, 3.73664358150875*^9, 
   3.736643813353981*^9, 3.736644143576322*^9, {3.736644930979557*^9, 
   3.736644936933468*^9}, 3.736644999507308*^9, 3.7366450650478992`*^9, 
   3.73664733382729*^9, 3.7367814356157084`*^9, 3.7367821685601053`*^9, 
   3.736783204495219*^9, 3.736789580380475*^9, 3.7367897360497417`*^9, 
   3.7367970148181677`*^9, 3.793998563372777*^9, 3.823228623845636*^9},
 CellLabel->
  "Out[2440]=",ExpressionUUID->"9a4ad028-c4d6-40ab-b207-ba498de6d4af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"xs1", "=", 
   RowBox[{"xs", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Lambda]", "\[Rule]", "1"}], ",", 
      RowBox[{"t", "\[Rule]", "1"}]}], "}"}]}]}], ";", 
  RowBox[{"xs2", "=", 
   RowBox[{"xs", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Lambda]", "\[Rule]", "2"}], ",", 
      RowBox[{"t", "\[Rule]", "1"}]}], "}"}]}]}], ";", "  ", 
  RowBox[{"usol", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"xs1", "\[Equal]", "0"}], ",", 
        RowBox[{"xs2", "\[Equal]", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u0", ",", "u1"}], "}"}]}], "]"}], "//", "N"}]}]}]], "Input",
 CellChangeTimes->{{3.736635609049087*^9, 3.736635679733428*^9}, {
   3.736635734945189*^9, 3.736635796628653*^9}, 3.736645037050881*^9},
 CellLabel->
  "In[2441]:=",ExpressionUUID->"12794fc9-a506-4ab5-a92a-5b66661fadff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u0", "\[Rule]", 
     RowBox[{"-", "13.257646171174086`"}]}], ",", 
    RowBox[{"u1", "\[Rule]", "8.041168878438885`"}]}], "}"}], "}"}]], "Output",\

 CellChangeTimes->{{3.736635616483025*^9, 3.736635628700448*^9}, {
   3.736635680100174*^9, 3.736635686987945*^9}, {3.7366357491798964`*^9, 
   3.736635797205923*^9}, {3.7366364473588123`*^9, 3.736636461062708*^9}, 
   3.736636839189323*^9, 3.736637847028298*^9, 3.7366383151403847`*^9, 
   3.7366384195763397`*^9, 3.736638597387936*^9, {3.7366386516606627`*^9, 
   3.73663866965108*^9}, {3.736639010273356*^9, 3.736639021990896*^9}, {
   3.736639078243896*^9, 3.736639134975601*^9}, 3.736640051039053*^9, 
   3.736643213699477*^9, 3.736643329485916*^9, 3.736643460340356*^9, 
   3.736643543640299*^9, 3.736643581679685*^9, 3.736643813505509*^9, 
   3.736644143780882*^9, 3.736644938912795*^9, 3.736644999616468*^9, {
   3.7366450377705603`*^9, 3.736645065194542*^9}, 3.736647334022785*^9, 
   3.736781435728332*^9, 3.736782168641471*^9, 3.7367832046113777`*^9, 
   3.736789580497409*^9, 3.7367897361506357`*^9, 3.736797014905411*^9, 
   3.793998563379723*^9, 3.823228623867021*^9},
 CellLabel->
  "Out[2441]=",ExpressionUUID->"fa4ab00d-7702-4565-97ed-6a5a20cb91bc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{
        RowBox[{"xs", "/.", "usol"}], "/.", 
        RowBox[{"\[Lambda]", "\[Rule]", "1"}]}], ",", 
       RowBox[{
        RowBox[{"xs", "/.", "usol"}], "/.", 
        RowBox[{"\[Lambda]", "\[Rule]", "2"}]}], ",", 
       RowBox[{"uNaive", "/.", "usol"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1.1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.002", "]"}], ",", 
          RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", "Dashed"}], "]"}], ",",
         ",", ",", 
        RowBox[{"Thickness", "[", "0.002", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.736635802933062*^9, 3.736635881299494*^9}, {
   3.7366359209184113`*^9, 3.7366359338629932`*^9}, {3.7366360414080677`*^9, 
   3.7366360509065123`*^9}, {3.7366360834359913`*^9, 3.736636196607625*^9}, {
   3.736636878508329*^9, 3.7366369873023233`*^9}, 3.736637850224719*^9, {
   3.736640267371788*^9, 3.736640287243992*^9}},
 CellLabel->
  "In[2442]:=",ExpressionUUID->"3f6fb48c-f8bd-43cf-8551-a9280629daf1"],

Cell["\<\
Now find the minimum-effort solution; need to use the SAME uopt for both \
values of \[Lambda]\
\>", "Text",
 CellChangeTimes->{{3.736635962686264*^9, 3.736635977575574*^9}, {
  3.736636024620076*^9, 3.736636029258498*^9}, {3.736639280394116*^9, 
  3.7366392980015287`*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"87c24437-99be-41be-b6d6-cdfc8723ffe8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", "1"}], "0"},
      {"0", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Delta]"}], ")"}]}]}
     }], "\[NoBreak]", ")"}]}], ";", " ", 
  RowBox[{"b", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1"},
      {"1"}
     }], "\[NoBreak]", ")"}]}], ";", " ", 
  RowBox[{"xtarget", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0"},
      {"1"}
     }], "\[NoBreak]", ")"}]}], ";", 
  RowBox[{"sys", "=", 
   RowBox[{"StateSpaceModel", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "]"}]}], ";", 
  RowBox[{"Wc", "=", 
   RowBox[{"ControllabilityMatrix", "[", "sys", "]"}]}], ";", 
  RowBox[{"Wg0", "=", 
   RowBox[{"ControllabilityGramian", "[", "sys", "]"}]}], ";", 
  RowBox[{"Wg", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Wg0", ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"\[Delta]", ">", "0"}]}]}], "]"}]}], ";", "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"gramian", " ", "for", " ", "infinite"}], "-", 
    RowBox[{"time", " ", "protocols"}]}], " ", "*)"}], 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "Wc", "]"}], ",", 
    RowBox[{"MatrixForm", "[", "Wg", "]"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.736645402848913*^9, 3.736645455926855*^9}, {
   3.73664729392622*^9, 3.7366473071840982`*^9}, 3.73678957607364*^9, 
   3.73678960888297*^9, {3.7367923771179447`*^9, 3.7367923892972183`*^9}},
 CellLabel->
  "In[2443]:=",ExpressionUUID->"68285cd9-6d0f-4b8c-9065-0f02be64d65e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", 
        RowBox[{"-", "1"}]},
       {"1", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "\[Delta]"}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", "2"], 
        FractionBox["1", 
         RowBox[{"2", "+", "\[Delta]"}]]},
       {
        FractionBox["1", 
         RowBox[{"2", "+", "\[Delta]"}]], 
        FractionBox["1", 
         RowBox[{"2", "+", 
          RowBox[{"2", " ", "\[Delta]"}]}]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{{3.736645429792934*^9, 3.736645456423677*^9}, {
   3.7366473058284893`*^9, 3.736647334269202*^9}, 3.736781435879277*^9, 
   3.736782168765594*^9, 3.736783204793889*^9, {3.736789580655511*^9, 
   3.736789609428516*^9}, 3.736789736315955*^9, 3.736797015049201*^9, 
   3.793998563438916*^9, 3.823228623916963*^9},
 CellLabel->
  "Out[2443]=",ExpressionUUID->"99cee9f4-a576-4a16-920f-2786cd49e700"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Det", "[", "Wc", "]"}], ",", 
   RowBox[{"Det", "[", "Wg", "]"}], ",", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Det", "[", "Wg", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Delta]", ",", "0", ",", "2"}], "}"}]}], "]"}]}], 
  "}"}]], "Input",
 CellChangeTimes->{{3.736645466535157*^9, 3.736645468483676*^9}, {
  3.736789636570092*^9, 3.7367896661776133`*^9}},
 CellLabel->
  "In[2444]:=",ExpressionUUID->"263e1397-c194-4f7c-a275-85c5e08884c7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "\[Delta]"}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]]}], "+", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"2", " ", "\[Delta]"}]}], ")"}]}]]}], ",", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      SuperscriptBox["\[Delta]", "2"], "16"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "\[Delta]", "]"}], "3"],
      SeriesData[$CellContext`\[Delta], 0, {}, 2, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`\[Delta], 0, {
      Rational[1, 16]}, 2, 3, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7366454688740377`*^9, 3.736647334455041*^9, 3.7367814359953737`*^9, 
   3.736782168839327*^9, 3.736783204910528*^9, 3.7367895808137693`*^9, {
   3.736789623426852*^9, 3.73678963702954*^9}, 3.7367896671718397`*^9, 
   3.736789736435759*^9, 3.736797015167407*^9, 3.793998563445044*^9, 
   3.8232286239227047`*^9},
 CellLabel->
  "Out[2444]=",ExpressionUUID->"eba65c23-3683-4c70-a10a-9fb9de09a0c2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalPhi]", "=", 
   RowBox[{
    RowBox[{"MatrixExp", "[", 
     RowBox[{"a", " ", "t"}], "]"}], "/.", 
    RowBox[{"\[Delta]", "\[Rule]", "1"}]}]}], ";", " ", 
  RowBox[{"Wg", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"\[CapitalPhi]", ".", "b", ".", 
      RowBox[{"b", "\[Transpose]"}], ".", 
      RowBox[{"\[CapitalPhi]", "\[Transpose]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", " ", 
  RowBox[{"Wginv", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "Wg", "]"}], "//", "Simplify"}]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "Wg", "]"}], ",", 
    RowBox[{"MatrixForm", "[", "Wginv", "]"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.736635506799864*^9, 3.736635515376473*^9}, {
   3.736635698641097*^9, 3.736635715150272*^9}, {3.736637838244796*^9, 
   3.7366378779004097`*^9}, {3.7366393386892347`*^9, 3.736639376053905*^9}, {
   3.7366394337829657`*^9, 3.736639595446213*^9}, {3.736639649375455*^9, 
   3.7366396920566673`*^9}, {3.736643108896822*^9, 3.736643144503409*^9}, {
   3.736643722332944*^9, 3.7366437374740353`*^9}, 3.736645399392386*^9, {
   3.736782069403914*^9, 3.736782090410945*^9}},
 CellLabel->
  "In[2445]:=",ExpressionUUID->"44aed752-0384-4324-8983-6164a3974bc5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "2"], "-", 
         FractionBox[
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "\[Tau]"}]], "2"]}], 
        RowBox[{
         FractionBox["1", "3"], "-", 
         FractionBox[
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "3"}], " ", "\[Tau]"}]], "3"]}]},
       {
        RowBox[{
         FractionBox["1", "3"], "-", 
         FractionBox[
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "3"}], " ", "\[Tau]"}]], "3"]}], 
        RowBox[{
         FractionBox["1", "4"], "-", 
         FractionBox[
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "4"}], " ", "\[Tau]"}]], "4"]}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{"18", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "\[Tau]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", "\[Tau]"], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[Tau]"}]], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"3", " ", "\[Tau]"}]]}], ")"}]}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], "3"], " ", 
          
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[Tau]"}]]}], ")"}]}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"24", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"3", " ", "\[Tau]"}]], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["\[ExponentialE]", "\[Tau]"], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[Tau]"}]]}], ")"}]}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], "3"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[Tau]"}]]}], ")"}]}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"24", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"3", " ", "\[Tau]"}]], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["\[ExponentialE]", "\[Tau]"], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[Tau]"}]]}], ")"}]}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], "3"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[Tau]"}]]}], ")"}]}]]}], 
        FractionBox[
         RowBox[{"36", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"4", " ", "\[Tau]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}]}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], "3"], " ", 
          
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[Tau]"}]]}], ")"}]}]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{{3.736635507426648*^9, 3.736635515740823*^9}, {
   3.736635699142706*^9, 3.736635715646224*^9}, 3.736636839538205*^9, 
   3.7366378784479113`*^9, 3.7366383153758698`*^9, 3.736638419839554*^9, 
   3.73663902235419*^9, 3.736639473260764*^9, {3.736639521074308*^9, 
   3.73663959628174*^9}, {3.7366396669144993`*^9, 3.736639692506145*^9}, 
   3.736643111024688*^9, 3.736643147594392*^9, 3.7366432142506638`*^9, 
   3.736643330011972*^9, 3.736643460775589*^9, 3.736643544134345*^9, 
   3.736643582227536*^9, 3.7366437402773046`*^9, 3.736643814015818*^9, 
   3.736644144400385*^9, 3.7366450000188932`*^9, 3.736645065988105*^9, 
   3.7366473346798887`*^9, 3.736781436258891*^9, 3.736782169102021*^9, 
   3.736783205163885*^9, 3.736789581068956*^9, 3.736789736692395*^9, 
   3.7367970154211903`*^9, 3.7939985635695553`*^9, 3.823228624056086*^9},
 CellLabel->
  "Out[2445]=",ExpressionUUID->"ea82b614-f4b3-4585-961e-0f6e39c3ebf3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"uopt", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"b", "\[Transpose]"}], ".", 
        RowBox[{"MatrixExp", "[", 
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "t"}], ")"}]}], "]"}], ".", 
        RowBox[{"(", 
         RowBox[{"Wginv", "/.", 
          RowBox[{"\[Tau]", "\[Rule]", "1"}]}], ")"}], ".", "xtarget"}], "/.", 
       RowBox[{"\[Delta]", "\[Rule]", "1"}]}], "//", "Simplify"}], "//", 
     "Flatten"}], "//", "First"}]}], ";", "uopt"}]], "Input",
 CellChangeTimes->{{3.7366401008481493`*^9, 3.736640101323716*^9}, {
   3.736643164660685*^9, 3.736643185795959*^9}, 3.7366437490718813`*^9, 
   3.736645087139084*^9, 3.736647317028668*^9, 3.736782095405506*^9},
 CellLabel->
  "In[2446]:=",ExpressionUUID->"96d4b1e2-4f64-41d2-bb9e-a37f6917637d"],

Cell[BoxData[
 FractionBox[
  RowBox[{"12", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", "+", "t"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "-", 
     RowBox[{"2", " ", "\[ExponentialE]"}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", "2"]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["\[ExponentialE]", "t"]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"1", "+", "t"}]]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[ExponentialE]"}], ")"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"4", " ", "\[ExponentialE]"}], "+", 
     SuperscriptBox["\[ExponentialE]", "2"]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.73664010184935*^9, 3.736640121636003*^9}, {
   3.736643165721734*^9, 3.7366432144067087`*^9}, 3.736643330172781*^9, 
   3.736643460891487*^9, 3.736643544276246*^9, 3.736643582403187*^9, 
   3.736643749629244*^9, 3.736643814139268*^9, 3.736644144650696*^9, 
   3.7366450001155577`*^9, 3.736645066347204*^9, 3.736645096429482*^9, {
   3.7366473185780478`*^9, 3.736647334980097*^9}, 3.736781436379035*^9, 
   3.736782169174292*^9, 3.7367832052944202`*^9, 3.736789581355431*^9, 
   3.736789736838359*^9, 3.736797015552905*^9, 3.7939985635992203`*^9, 
   3.82322862407892*^9},
 CellLabel->
  "Out[2446]=",ExpressionUUID->"f1005084-d657-4a20-8593-9c3e3c16c0e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"eqs2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x1", "'"}], "[", "t", "]"}], "+", " ", 
         RowBox[{"x1", "[", "t", "]"}]}], "\[Equal]", "uopt"}], ",", 
       RowBox[{
        RowBox[{"x1", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x2", "'"}], "[", "t", "]"}], "+", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", 
          RowBox[{"x2", "[", "t", "]"}]}]}], "\[Equal]", "uopt"}], ",", 
       RowBox[{
        RowBox[{"x2", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"xs2", "=", 
    RowBox[{
     RowBox[{"DSolveValue", "[", 
      RowBox[{
       RowBox[{"eqs2", "/.", 
        RowBox[{"\[Delta]", "\[Rule]", "1"}]}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x1", "[", "t", "]"}], ",", 
         RowBox[{"x2", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}], "//", 
     "Simplify"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7366378877515993`*^9, 3.736637931426642*^9}, {
   3.736639709963675*^9, 3.736639728198023*^9}, {3.736639770603189*^9, 
   3.736639854656011*^9}, {3.73663992480081*^9, 3.736639954611579*^9}, {
   3.7366399899934587`*^9, 3.736639991950761*^9}, {3.7366401048798428`*^9, 
   3.736640196190484*^9}, 3.736643163093079*^9, {3.736643193911407*^9, 
   3.7366432089385*^9}, {3.736643758181562*^9, 3.736643771402502*^9}},
 CellLabel->
  "In[2447]:=",ExpressionUUID->"b200dd06-01b7-4a56-8d43-ae8fc85495d1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"12", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", "-", "t"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", "t"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", "2"]}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "t"}]], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", "+", "t"}]], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "t"}]}]]}], ")"}]}], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[ExponentialE]"}], ")"}], "3"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[ExponentialE]"}], "+", 
       SuperscriptBox["\[ExponentialE]", "2"]}], ")"}]}]], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", "-", 
       RowBox[{"2", " ", "t"}]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "\[ExponentialE]", "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["\[ExponentialE]", "2"]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"3", " ", "t"}]]}], "+", 
       RowBox[{"9", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"4", " ", "t"}]]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"1", "+", 
          RowBox[{"3", " ", "t"}]}]]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", "+", 
          RowBox[{"3", " ", "t"}]}]]}], "+", 
       RowBox[{"9", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"1", "+", 
          RowBox[{"4", " ", "t"}]}]]}]}], ")"}]}], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[ExponentialE]"}], ")"}], "3"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[ExponentialE]"}], "+", 
       SuperscriptBox["\[ExponentialE]", "2"]}], ")"}]}]]}], "}"}]], "Output",\

 CellChangeTimes->{
  3.7366398285932617`*^9, {3.736639930835696*^9, 3.736639992686496*^9}, 
   3.7366400876266613`*^9, {3.7366401197678757`*^9, 3.736640124587295*^9}, 
   3.736640167333444*^9, 3.736640204919202*^9, {3.7366432096315947`*^9, 
   3.736643214909532*^9}, 3.736643330631845*^9, 3.736643461171269*^9, 
   3.736643544556032*^9, 3.7366435829266367`*^9, 3.7366437732347603`*^9, 
   3.736643814429789*^9, 3.736644144943664*^9, 3.736645000403904*^9, 
   3.736645066634261*^9, 3.736645098480012*^9, 3.73664733532845*^9, 
   3.7367814368332376`*^9, 3.736782169522478*^9, 3.736783205852086*^9, 
   3.736789581695174*^9, 3.736789737405534*^9, 3.736797016002871*^9, 
   3.793998563843439*^9, 3.823228624451836*^9},
 CellLabel->
  "Out[2448]=",ExpressionUUID->"6cd4b93e-0941-4425-94ba-67e5b7c0e7fd"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "xs2", ",", "uopt"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1.1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.002", "]"}], ",", 
          RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", "Dashed"}], "]"}], ",",
         ",", ",", 
        RowBox[{"Thickness", "[", "0.002", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2a", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"uNaive", "/.", "usol"}], ")"}], "2"], ",", 
       SuperscriptBox["uopt", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1.1"}], "}"}]}], "]"}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.736638037226328*^9, 3.736638125579063*^9}, {
  3.73663816179847*^9, 3.736638168864802*^9}, {3.736640216325942*^9, 
  3.736640388830769*^9}, {3.7366435710882797`*^9, 3.736643571476074*^9}},
 CellLabel->
  "In[2449]:=",ExpressionUUID->"fa82c85f-2c51-46a0-aac7-3e3d2fb83d47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p1", ",", "p2", ",", "p2a"}], "}"}]], "Input",
 CellChangeTimes->{{3.7366402942953873`*^9, 3.736640296817277*^9}, {
  3.736640391814576*^9, 3.73664039236454*^9}, {3.73664357347793*^9, 
  3.736643573756259*^9}},
 CellLabel->
  "In[2451]:=",ExpressionUUID->"1a4a95e4-ecc2-4082-93d9-d2dbd349f70a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {GrayLevel[0.8], Thickness[0.002], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQPX9RfcMuqQg7BjD4YJ9s2JUgIdNmD+NHd967JyYz
Dc6vFj0dpcS1HM5fu6mKp0R2I5y/cv/8Z3tnboPzt/9Rvc/buwfOX76nc0EU
70E4/7fQxoSN/Efg/KvRCfN+Mx+H80tcDk8oPHoSzpc5GjYp69AZOL/j6VyP
/p7zcL5tjdm+YJWLcP7uwG3xigsuwfnS3/tvtzBdgfPrXzDeX9l0Fc5Xu2y+
8MTva3D+ht7jtrXRN+B8uynvEz/fuAnnr8sqTPhvcxvOV+7tfnZm3x04//aK
TO0plvfg/NIpC70+zroP53M92/GDvfcBnH/6pa/lI/uHcL7uK5dIy/cI/iQB
DtvCtY/g/BdyP3i/xD2G8x2CtywKl38C51u1XBKzuIPgq86VrUjueQrnC90x
mZvv/QzO/8BUuf7YXwS/QE1+4aw1z+H8T/kTw/yzXsD5qQsNfvpJv4Tzb/2Y
Ha9/G8F3sDDZHNX3Cs73KNF7xmT3Gs4PuvblTvcfBN9X4cWB+HVv4HyvCcsz
RPLfwvkv/5x476rzDs6vDBRPOXQHwec+YzhHfs57ON99+p4Hyeof4PybboLJ
3+oQ/FxOH/efdxH8n/ayixaafYTzq0RvzJLNQPB/vZo0eeZMBB8A1kcUJw==

         "]]},
       Annotation[#, "Charting`Private`Tag$1018763#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwVkHs0VH0bhgdRaURmUxihIiopIbx4VOjkrAgVmpT0FUIl3kiWQ45JKjm3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         "]]},
       Annotation[#, "Charting`Private`Tag$1018763#2"]& ], 
      TagBox[
       {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwVU3k0VfsfvRkq5XLyQ/yQVKRB0s8185FnWmYqoZchQ/IKmSpUhhKZh8jN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         "]]},
       Annotation[#, "Charting`Private`Tag$1018763#3"]& ], 
      TagBox[
       {RGBColor[0.922526, 0.385626, 0.209179], Thickness[0.002], Opacity[1.],
         LineBox[CompressedData["
1:eJxFz1tMEmAchnFCO2gyi4RKJTy3VVY6Z9JSqCydpU6cqFCBoYvYGrHh5qls
5VqmpCHLeUCFG3RLC2vqktQsDymrZeowCMySAEu0WIHQOlz0/y7ePftdvsHn
BfQCLAaDOfp3/9qqKL/2xD8nYfD4crT1xp4hbtRtzo7Am9T/ZlUaDMTAe+BS
wiQzxFsJ7uwu8RGRVOCOwVbT04YecK873IgTq8FKdWUbE/cM7MKrOCrfF+AZ
FqfF5TEGFiU+rxWOvAQHjjAk/GEN+NaiLLmm+jU4vix2IDPsDbg/o4cd3DYF
DvhZo6vAToPLzeuMHddnwBFvD8nHXbPgh+Kx+CssLThBasv7rp0Dd/GFnN9H
dOBQcZVJM6AH69ov7pVSDOD2lvX9x6zIhVJ5ymqjEcxrKiXPTCCfUWTZ+9aQ
ZcKiXiZmnurvmUX0IwTRfPCj9hwP5LLubdHZG5CX6HmCLC/kiTq3JcMXuX26
Pj+NgFzAeJWbFIwcovVMp0UiE42G0LCzyN6mPsdGMbL1gsfOQhPypCWVskD9
AI60JuZSbMiSLZvihZ0LYPMuB85+7iOYlvlYkU3+BD5cMUWM0yOHy0hF3OpF
MF4fIxOcMoFXsMUPRn8hX44gyxvvfwZ/E9xlpPPN6L/8oDMtwAJ+52hiH9Ah
0+JiHjHvWMHJov0mbMISmD5r11e5kVODzEPsri/glFolz0/wFWxxj9tO7FsG
F2dszx/WI2/WRDWTm23gpHr1PHf3Cnju5Fbuj6vIl7xOJznfIzupJIU8dhVc
QtA2knjIa1ZJXUMD8h8f8KnR
         "]]},
       Annotation[#, "Charting`Private`Tag$1018763#4"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    Background->GrayLevel[0.97],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {GrayLevel[0.8], Thickness[0.002], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQPX9RfcMuqQg7BjD4YJ9s2JUgIdNmD+NHd967JyYz
Dc6vFj0dpcS1HM5fu6mKp0R2I5y/cv/8Z3tnboPzt/9Rvc/buwfOX76nc0EU
70E4/7fQxoSN/Efg/KvRCfN+Mx+H80tcDk8oPHoSzpc5GjYp69AZOL/j6VyP
/p7zcL5tjdm+YJWLcP7uwG3xigsuwfnS3/tvtzBdgfPrXzDeX9l0Fc5Xu2y+
8MTva3D+ht7jtrXRN+B8uynvEz/fuAnnr8sqTPhvcxvOV+7tfnZm3x04//aK
TO0plvfg/NIpC70+zroP53M92/GDvfcBnH/6pa/lI/uHcL7uK5dIy/cI/iQB
DtvCtY/g/BdyP3i/xD2G8x2CtywKl38C51u1XBKzuIPgq86VrUjueQrnC90x
mZvv/QzO/8BUuf7YXwS/QE1+4aw1z+H8T/kTw/yzXsD5qQsNfvpJv4Tzb/2Y
Ha9/G8F3sDDZHNX3Cs73KNF7xmT3Gs4PuvblTvcfBN9X4cWB+HVv4HyvCcsz
RPLfwvkv/5x476rzDs6vDBRPOXQHwec+YzhHfs57ON99+p4Hyeof4PybboLJ
3+oQ/FxOH/efdxH8n/ayixaafYTzq0RvzJLNQPB/vZo0eeZMBB8A1kcUJw==

         "]]},
       Annotation[#, "Charting`Private`Tag$1019430#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwV1nk8VFscAHCNbHOtJT0iS6iEF1EUflMJUeolKi1Isrw2rywRoUWyla0s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         "]]},
       Annotation[#, "Charting`Private`Tag$1019430#2"]& ], 
      TagBox[
       {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwV13k4VO0bB/BhzslSStIwjKRCEUl25Z5sibQIRSqSEqUUvWSLyouytZE1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         "]]},
       Annotation[#, "Charting`Private`Tag$1019430#2"]& ], 
      TagBox[
       {RGBColor[0.922526, 0.385626, 0.209179], Thickness[0.002], Opacity[1.],
         LineBox[CompressedData["
1:eJwV0nk81HsXB/CKqJgrJV2Mwm+iFFebkJnzU1G3PW4UT4nJkiKKmjBZKvuW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         "]]},
       Annotation[#, "Charting`Private`Tag$1019430#3"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    Background->GrayLevel[0.97],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJxFz2lM0nEcx3HCLk1mWdghRHi1VVY2R9riqDSdpQbOC0oxZJFbIzbdPDBb
cy1T0tTlUFHhCbqlhTV1aVaWR8pqmToMArP8B1ghxQyE1vGg7+/BZ++9Hn6o
58UcIR6Hwx37u39tVZVdfbQjg+FHW86SOoUsQcRN/jbSdeZ/8yqMxgDSHXAJ
cYIb5KMGd3YX++aTNeCOJ63YY3kPuNcTaiLIBsDqgYo2LuEZ2O2v4Wv8XoCn
efwWt9coOD/meY1k+CWYNJxWmzekBd9YUMRXV70G06W0wZSQN+B+dk82tW0S
HPizWl+OnwKXmVeZOq5Ng8PeHlaOuWfA92Wj9FKeDsyot+X80M2Cu/Ik/N9H
9eBgWSWmHTSA9e0X99ZHG8HtLWv6j1uRC+qVCfZGE1jUVEKZHkc+q0p19K0g
KySFvVzcHJNjKrWf2HOG5es/4sjwQpZ2bz6UvhZ5kZMjTvVGHq/zWNh+yO1T
DblJRGRh2qvMOCpykG51MiscOcBkDA45h+yD9TnXyZCtF7y2F2DIE5bE6Hnm
B3C4NSYz2oZcu3E9XdI5DzbvdBIcWR/BrJSHqnTKJ/CR8smAKANyqIJcKKha
APsbIhXiUxh4CV90b+QX8uUwirLx7mfwd/HttOQ8M/qvPOhKCrSA3zmbsg/o
kVlRkQ+4t6zg+Pz9GJ6xCObMOAyVHuTEXean2V1fwAk1atEW8VewxTNmi933
DVzE3po7ZEDeoI1opjTbwHENA3OC3Uvg2ZObBMtXkC95n45zvUd2MckqJc0O
LibqGski5BVrbZ1cjvwHXwb1UA==
         "]]},
       Annotation[#, "Charting`Private`Tag$1019481#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwV13c4le8bAHBRIUKokGSUVVZGKO6nQkVGhHNUsokKUcoKDTIyDomQlZVk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         "]]},
       Annotation[#, "Charting`Private`Tag$1019481#2"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    Background->GrayLevel[0.97],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.736640297417015*^9, 3.73664039288728*^9, 3.736643215147749*^9, 
   3.7366433309097*^9, 3.73664346149268*^9, {3.736643544853997*^9, 
   3.736643583473514*^9}, 3.736643814682983*^9, 3.736644145216411*^9, 
   3.736645000622221*^9, 3.736645066955611*^9, 3.736645102808194*^9, 
   3.736647335639565*^9, 3.736781437027707*^9, 3.7367821696968803`*^9, 
   3.736783206055728*^9, 3.736789581922604*^9, 3.7367897376259212`*^9, 
   3.73679701703951*^9, 3.7939985639148083`*^9, 3.823228624524478*^9},
 CellLabel->
  "Out[2451]=",ExpressionUUID->"f901ed94-016b-4523-9aad-2de17eb3287e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"uNaive", "/.", "usol"}], ")"}], "2"], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     SuperscriptBox["uopt", "2"], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.736640395685505*^9, 3.736640427457831*^9}},
 CellLabel->
  "In[2452]:=",ExpressionUUID->"cce57bee-d6d8-4538-ac08-c915453af349"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "120.21278946581059`", "}"}], ",", "74.78836292752996`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.736640412189459*^9, 3.73664042852737*^9}, 
   3.736643215327046*^9, 3.736643331031077*^9, 3.7366434616136503`*^9, 
   3.73664354501173*^9, 3.736643584488028*^9, 3.736643814843432*^9, 
   3.7366441454365053`*^9, 3.7366450007328873`*^9, 3.736645067125661*^9, 
   3.736645139179487*^9, 3.736647335827264*^9, 3.736781437143963*^9, 
   3.736782169790428*^9, 3.736783206191297*^9, 3.7367895820610113`*^9, 
   3.736789737766815*^9, 3.7367970172380047`*^9, 3.7939985639526577`*^9, 
   3.823228624554984*^9},
 CellLabel->
  "Out[2452]=",ExpressionUUID->"8f609c2c-0a40-42bf-8ce5-14af15520f4c"]
}, Open  ]],

Cell[TextData[{
 "Redo for \[Lambda]",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"=", 
     RowBox[{"1", "+", "\[Delta]"}]}], ",", " ", 
    RowBox[{
    "and", " ", "show", " ", "that", " ", "effort", " ", "diverges", " ", 
     "if", " ", "goals", " ", "are", " ", "not", " ", "the", " ", 
     RowBox[{"same", ".", "  ", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
       "Maybe", " ", "need", " ", "to", " ", "redo", " ", "to", " ", "have", 
        " ", "different", " ", 
        RowBox[{"goals", "."}]}], ")"}]}]}]}], TraditionalForm]],
  ExpressionUUID->"0fa05abe-84b6-4416-a58b-16cf4f2d9a7e"]
}], "Text",
 CellChangeTimes->{{3.736635962686264*^9, 3.736635977575574*^9}, {
  3.736636024620076*^9, 3.736636029258498*^9}, {3.736639280394116*^9, 
  3.7366392980015287`*^9}, {3.73664084529939*^9, 3.736640907478772*^9}, {
  3.7366432220180397`*^9, 3.736643245984866*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"9e6060e6-2d8d-43e2-aeab-dd9a797e08d9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalPhi]3", "=", 
   RowBox[{"MatrixExp", "[", 
    RowBox[{"a", " ", "t"}], "]"}]}], ";", " ", 
  RowBox[{"Wg3", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"\[CapitalPhi]3", ".", "b", ".", 
      RowBox[{"b", "\[Transpose]"}], ".", 
      RowBox[{"\[CapitalPhi]3", "\[Transpose]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}]}], "]"}]}], ";", " ", 
  RowBox[{"Wginv3", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "Wg3", "]"}], "//", "Simplify"}]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "Wg3", "]"}], ",", 
    RowBox[{"MatrixForm", "[", "Wginv3", "]"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.7366432786625633`*^9, 3.736643280629465*^9}, {
   3.736643313512045*^9, 3.736643324644618*^9}, {3.736643413538158*^9, 
   3.7366434214578238`*^9}, 3.7366437109589033`*^9, {3.736643991905878*^9, 
   3.736643994504199*^9}, {3.736644037232902*^9, 3.73664403907826*^9}, {
   3.736782115036312*^9, 3.7367821311457853`*^9}},
 CellLabel->
  "In[2453]:=",ExpressionUUID->"c214128f-5fab-424a-ae3e-4529147f29f2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "2"], "-", 
         FractionBox[
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "\[Tau]"}]], "2"]}], 
        FractionBox[
         RowBox[{"1", "-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}], 
             ")"}]}]]}], 
         RowBox[{"2", "+", "\[Delta]"}]]},
       {
        FractionBox[
         RowBox[{"1", "-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}], 
             ")"}]}]]}], 
         RowBox[{"2", "+", "\[Delta]"}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]]}], 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Delta]"}], ")"}]}]]}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "2"], "-", 
                FractionBox[
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{"-", "2"}], " ", "\[Tau]"}]], "2"]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]]}], 
               ")"}]}], 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "+", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}], 
                   ")"}]}]]}], ")"}], "2"], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]]}], ")"}]}]], 
        FractionBox[
         RowBox[{"1", "-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}], 
             ")"}]}]]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "2"], "-", 
                FractionBox[
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{"-", "2"}], " ", "\[Tau]"}]], "2"]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]]}], 
               ")"}]}], 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "+", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}], 
                   ")"}]}]]}], ")"}], "2"], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]]}], ")"}]}]]},
       {
        FractionBox[
         RowBox[{"1", "-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}], 
             ")"}]}]]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "2"], "-", 
                FractionBox[
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{"-", "2"}], " ", "\[Tau]"}]], "2"]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]]}], 
               ")"}]}], 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "+", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}], 
                   ")"}]}]]}], ")"}], "2"], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]]}], ")"}]}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           FractionBox["1", "2"], "-", 
           FractionBox[
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "2"}], " ", "\[Tau]"}]], "2"]}], 
          RowBox[{
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "2"], "-", 
               FractionBox[
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "\[Tau]"}]], "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]]}], 
              ")"}]}], 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "+", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}], 
                  ")"}]}]]}], ")"}], "2"], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]]}]]}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7366432830609417`*^9, {3.736643326629374*^9, 3.736643331230505*^9}, {
   3.7366434324950533`*^9, 3.7366434618241158`*^9}, 3.736643545234584*^9, 
   3.73664358501375*^9, 3.7366438150580807`*^9, {3.736643995749653*^9, 
   3.736644003037697*^9}, 3.736644041084733*^9, 3.736644146274053*^9, 
   3.7366450014992456`*^9, 3.736645068176271*^9, 3.7366451451429234`*^9, 
   3.736647119297894*^9, 3.7366473366643877`*^9, 3.736781438495329*^9, 
   3.736782170550405*^9, 3.736783206976722*^9, 3.736789582857271*^9, 
   3.736789738561976*^9, 3.736792428602108*^9, 3.736797017984007*^9, 
   3.793998564290053*^9, 3.823228624953875*^9},
 CellLabel->
  "Out[2453]=",ExpressionUUID->"f4aa3a2b-637b-48ed-9013-250e6c075269"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Det", "[", "Wg3", "]"}], "//", "Simplify"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.736789402367119*^9, 3.736789412049643*^9}, {
  3.736789446728527*^9, 3.736789450965065*^9}, {3.7367932368175917`*^9, 
  3.736793249354353*^9}, {3.736793422295636*^9, 3.736793424187381*^9}},
 CellLabel->
  "In[2454]:=",ExpressionUUID->"089162d5-3a0f-4c63-9826-d650521ab98c"],

Cell[BoxData[
 TagBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["\[Delta]", "2"], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]], " ", 
     SuperscriptBox["\[Delta]", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}], ")"}]}]], 
     " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Delta]"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[Tau]"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]}], "-", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]}]}], 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]}]],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.736789408345792*^9, 3.7367894126326237`*^9}, {
   3.736789448557106*^9, 3.736789451339419*^9}, 3.736789583262244*^9, 
   3.736789739055019*^9, 3.736793251622911*^9, 3.736793424449477*^9, 
   3.7367970183331127`*^9, 3.793998564388712*^9, 3.823228625126471*^9},
 CellLabel->
  "Out[2454]//MatrixForm=",ExpressionUUID->"2b36b485-3909-49d7-bbc0-\
a194109cdc24"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Det", "[", "Wg3", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Delta]", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7366470695700903`*^9, 3.736647072837274*^9}, {
   3.7366471267653837`*^9, 3.736647143011093*^9}, 3.736782137251206*^9, {
   3.7367934034008503`*^9, 3.736793408710249*^9}, {3.7367934715885763`*^9, 
   3.7367934774415503`*^9}, 3.736793550634453*^9},
 CellLabel->
  "In[2455]:=",ExpressionUUID->"2d4fd36c-83da-4f76-8fec-7cf5fc47f88d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "16"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "4"}], " ", "\[Tau]"}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[Tau]"}]]}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"4", " ", "\[Tau]"}]], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[Tau]"}]], " ", 
       SuperscriptBox["\[Tau]", "2"]}]}], ")"}], " ", 
    SuperscriptBox["\[Delta]", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Delta]", "]"}], "3"],
    SeriesData[$CellContext`\[Delta], 0, {}, 2, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Delta], 0, {
   Rational[1, 16] 
    E^((-4) $CellContext`\[Tau]) (1 - 2 E^(2 $CellContext`\[Tau]) + 
     E^(4 $CellContext`\[Tau]) - 4 
     E^(2 $CellContext`\[Tau]) $CellContext`\[Tau]^2)}, 2, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.73664707330429*^9, {3.736647121103607*^9, 3.736647143509753*^9}, 
   3.7366473368446693`*^9, 3.736781438722473*^9, 3.7367821707307987`*^9, 
   3.736783207270108*^9, 3.736789583114876*^9, 3.736789738840885*^9, 
   3.736790409668105*^9, 3.736790480880659*^9, {3.736793403942483*^9, 
   3.736793409302968*^9}, 3.736793478369266*^9, 3.7367935510099287`*^9, 
   3.736797018685852*^9, 3.793998564419662*^9, 3.823228625152429*^9},
 CellLabel->
  "Out[2455]=",ExpressionUUID->"690f318c-0c2d-4c1d-ab57-f8c6f92fa866"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Det", "[", "Wg3", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Tau]", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.736790463473934*^9, 3.736790491719792*^9}, 
   3.736790550273518*^9},
 CellLabel->
  "In[2456]:=",ExpressionUUID->"1532d0be-ab79-4e12-a162-04cbb9fcc86f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Delta]", "2"], " ", 
     SuperscriptBox["\[Tau]", "4"]}], "12"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Tau]", "]"}], "5"],
    SeriesData[$CellContext`\[Tau], 0, {}, 4, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Tau], 0, {
   Rational[1, 12] $CellContext`\[Delta]^2}, 4, 5, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.7367904645050793`*^9, 3.7367904922550993`*^9}, 
   3.736790550806417*^9, 3.736797018797187*^9, 3.793998564430941*^9, 
   3.823228625164168*^9},
 CellLabel->
  "Out[2456]=",ExpressionUUID->"cd49942d-c06c-4622-80ab-4428d77b36cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{"Wg3", ",", 
     RowBox[{"{", 
      RowBox[{"\[Tau]", ",", "0", ",", "2"}], "}"}]}], "]"}], "//", 
   "Normal"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.736793113563417*^9, 3.736793141456181*^9}},
 CellLabel->
  "In[2457]:=",ExpressionUUID->"7854be32-74ab-4994-a709-cdc51cc2b13c"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"\[Tau]", "-", 
       SuperscriptBox["\[Tau]", "2"]}], 
      RowBox[{"\[Tau]", "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "-", "\[Delta]"}], ")"}], " ", 
        SuperscriptBox["\[Tau]", "2"]}]}]},
     {
      RowBox[{"\[Tau]", "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "-", "\[Delta]"}], ")"}], " ", 
        SuperscriptBox["\[Tau]", "2"]}]}], 
      RowBox[{"\[Tau]", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "\[Delta]"}], ")"}], " ", 
        SuperscriptBox["\[Tau]", "2"]}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.736793129088602*^9, 3.736793141836403*^9}, 
   3.7367970189154882`*^9, 3.793998564460924*^9, 3.823228625189234*^9},
 CellLabel->
  "Out[2457]//MatrixForm=",ExpressionUUID->"8551464a-f5f6-47c8-9c5d-\
4860bd39f25d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"uopt3", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"b", "\[Transpose]"}], ".", 
       RowBox[{"MatrixExp", "[", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "t"}], ")"}]}], "]"}], ".", 
       RowBox[{"(", 
        RowBox[{"Wginv3", "/.", 
         RowBox[{"\[Tau]", "\[Rule]", "1"}]}], ")"}], ".", "xtarget"}], "//", 
      "Simplify"}], "//", "Flatten"}], "//", "First"}]}], ";", " ", 
  "uopt3"}]], "Input",
 CellChangeTimes->{{3.736643336060532*^9, 3.736643455914393*^9}, 
   3.7366437882285624`*^9, 3.736644135531558*^9, {3.736644618310536*^9, 
   3.73664461973918*^9}, 3.736647327612174*^9, 3.736782143741108*^9},
 CellLabel->
  "In[2458]:=",ExpressionUUID->"a992dc23-2863-4c8e-90df-919ea8f0d18e"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"1", "+", "t", "+", "\[Delta]"}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", "+", "\[Delta]"}]]}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"t", " ", "\[Delta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "\[Delta]"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", "+", 
        RowBox[{"t", " ", "\[Delta]"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "\[Delta]"}], ")"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["\[Delta]", "2"], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"4", "+", 
      RowBox[{"2", " ", "\[Delta]"}]}]], " ", 
    SuperscriptBox["\[Delta]", "2"]}], "+", 
   RowBox[{"8", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", "+", "\[Delta]"}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Delta]"}], ")"}]}], "-", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]}], "-", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", "\[Delta]"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]}]}]]], "Output",
 CellChangeTimes->{{3.736643348608482*^9, 3.736643387892104*^9}, {
   3.7366434304561653`*^9, 3.736643461932302*^9}, 3.736643545349873*^9, 
   3.736643585127425*^9, {3.7366437906882257`*^9, 3.736643815215802*^9}, 
   3.7366440449237423`*^9, 3.736644146695258*^9, 3.736644620801721*^9, 
   3.7366450016346827`*^9, 3.7366450684723377`*^9, 3.7366451481383677`*^9, {
   3.736647328870721*^9, 3.7366473372060223`*^9}, 3.736781438866397*^9, 
   3.736782170875646*^9, 3.73678320739674*^9, 3.7367895833975782`*^9, 
   3.7367897393510113`*^9, 3.7367970190459633`*^9, 3.793998564523831*^9, 
   3.8232286252613783`*^9},
 CellLabel->
  "Out[2458]=",ExpressionUUID->"809e9790-e3df-4c44-9bdc-17b5c1927b9b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqs3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x1", "'"}], "[", "t", "]"}], "+", " ", 
       RowBox[{"x1", "[", "t", "]"}]}], "\[Equal]", "uopt3"}], ",", 
     RowBox[{
      RowBox[{"x1", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x2", "'"}], "[", "t", "]"}], "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", 
        RowBox[{"x2", "[", "t", "]"}]}]}], "\[Equal]", "uopt3"}], ",", 
     RowBox[{
      RowBox[{"x2", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"xs3", "=", 
  RowBox[{
   RowBox[{"DSolveValue", "[", 
    RowBox[{"eqs3", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x1", "[", "t", "]"}], ",", 
       RowBox[{"x2", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{
  3.7366434083706703`*^9, {3.736643476890464*^9, 3.736643527423471*^9}, {
   3.736643601917885*^9, 3.7366436100113993`*^9}, {3.73664379570826*^9, 
   3.736643803991414*^9}},
 CellLabel->
  "In[2459]:=",ExpressionUUID->"f4a7bc70-d4a4-4af2-9d0a-31e11afbac78"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"1", "-", "t", "+", "\[Delta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "2"], "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "t"}]], "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", "+", "\[Delta]"}]], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"t", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "\[Delta]"}], ")"}]}]], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", "+", 
          RowBox[{"2", " ", "t"}], "+", "\[Delta]"}]], "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", "+", 
          RowBox[{"t", " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "\[Delta]"}], ")"}]}]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"3", " ", "\[Delta]"}], "+", 
        SuperscriptBox["\[Delta]", "2"]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["\[Delta]", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"4", "+", 
         RowBox[{"2", " ", "\[Delta]"}]}]], " ", 
       SuperscriptBox["\[Delta]", "2"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", "+", "\[Delta]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Delta]"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", "+", 
         RowBox[{"2", " ", "\[Delta]"}]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]}]}]]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Delta]"}], ")"}]}], ")"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[Delta]", "2"], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", "+", "\[Delta]"}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Delta]"}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"t", " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "\[Delta]"}], ")"}]}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Delta]"}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "t"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "\[Delta]"}], ")"}]}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Delta]"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "t", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "t", "+", 
             RowBox[{"t", " ", "\[Delta]"}]}], ")"}]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]}]}], ")"}]}], ")"}], 
    "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[Delta]", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"4", "+", 
         RowBox[{"2", " ", "\[Delta]"}]}]], " ", 
       SuperscriptBox["\[Delta]", "2"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", "+", "\[Delta]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Delta]"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", "+", 
         RowBox[{"2", " ", "\[Delta]"}]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]}]}], ")"}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.736643462221561*^9, {3.736643539132936*^9, 3.736643545947184*^9}, {
   3.736643585707389*^9, 3.736643613596303*^9}, {3.736643806754203*^9, 
   3.736643816465075*^9}, 3.736644054740074*^9, 3.736644154367466*^9, 
   3.736644628958743*^9, 3.73664500662904*^9, 3.736645073201256*^9, 
   3.736645154472024*^9, 3.736647341785297*^9, 3.7367814439928217`*^9, 
   3.736782175789843*^9, 3.736783212637738*^9, 3.736789588658139*^9, 
   3.736789743909832*^9, 3.736797023678584*^9, 3.7939985675856752`*^9, 
   3.823228628599601*^9},
 CellLabel->
  "Out[2460]=",ExpressionUUID->"033f06bb-9efc-4b83-a9c4-8d3df3a93770"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p3", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"xs3", "/.", 
       RowBox[{"\[Delta]", "\[Rule]", "1"}]}], ",", 
      RowBox[{"uopt3", "/.", 
       RowBox[{"\[Delta]", "\[Rule]", "1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.002", "]"}], ",", 
         RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", "Dashed"}], "]"}], ",", 
       ",", 
       RowBox[{"Thickness", "[", "0.002", "]"}], ","}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "3"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7366435872658873`*^9, 3.7366436965958014`*^9}, 
   3.736643956091058*^9, {3.736644061743866*^9, 3.736644110084132*^9}, {
   3.736644179315908*^9, 3.736644199419162*^9}, {3.7366442340744333`*^9, 
   3.736644390801571*^9}, {3.7366445058687973`*^9, 3.7366445908596687`*^9}, {
   3.736644635558226*^9, 3.736644715768157*^9}, 3.736647093056583*^9, 
   3.736782212034018*^9, {3.736795305070952*^9, 3.736795316371378*^9}, {
   3.7367958964375267`*^9, 3.736795911091157*^9}},
 CellLabel->
  "In[2461]:=",ExpressionUUID->"248c928b-dc36-4aa6-9612-37cf880ae8fc"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0.8], Thickness[0.002], Opacity[1.], Dashing[{Small, Small}], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7ZX64uKBl6F2DGDwwX6BqH9bl2SLPYzfyLFZvVNy
CpwfEblw/YePS+B87v+NMe5y6+F81cB3Lw53b4Hzy89Z2s/4shPOF98ieI+R
cT+cv+2R85nzNofg/ENZc6Uj3xyB87+q2fKvzT0O5zP9XC0grXoKzjf7n7At
eN0ZOP9Mi8m5Y1rn4Xz5Ca9/rnx3Ac5//f3+vasGl+D8Ja92n+Lruwzn88ku
f//kyRU4vydza9oClWtw/jeH1U8y6q/D+SVGR7aIHb4B599fd6T7ouItOP93
1pXZmlW34XxtR/Z/abvvwPnuixTTN4rfQ4SXbLzSw5j7cL7Om1Du674P4Hxh
/g8cR34h+Cz7Z69XnvMQzs822X2T0/sRnL/aM2nBvm8I/tfXUgLPpj2G87cG
uzNPcXkC59d7tM7f8gzBV7zrdWNx61M438q8ZYqk0TM4P0bu/E/Gywj+11O9
jwoan8P5M1jiSoJUXiDcf2/rIqYjCD5rbWOIZeFLOJ9hZdz6R0Kv4PyiWet7
hQ4h+Hu1OzgE817D+YJeRTpNfG/g/Du6Fy5X7kHwN8yzV3kS9xbOj11vJij7
D8FvaF3YeGfVOzh/7QvZ2Xw+7+F8pRYRD/ZlCP50ee6v//8j+ACgshGH
       "]]},
     Annotation[#, "Charting`Private`Tag$1020668#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1nk8VF8bAHBrMbcQlWi1VJRKaFWeRCkiW1myZ2uVregllSVEi1QqQihl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       "]], LineBox[CompressedData["
1:eJwV13k8lFsYB3DM+0YJoXJJC7KrXJQWPIUWW7ZEi+WqJMW13UrqSpeyhLIU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       "]]},
     Annotation[#, "Charting`Private`Tag$1020668#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], Thickness[0.002], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd0nk41HsbBnBU9mPL0kwY4zeE5ghhcOIRikMiJFOaKPG2WS4pbWQtOydJ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       "]]},
     Annotation[#, "Charting`Private`Tag$1020668#3"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 0.9999999795918367}, {-11, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.736644664856925*^9, 3.7366447163682203`*^9}, 
   3.736645007038129*^9, 3.736645073615004*^9, 3.736645155836403*^9, 
   3.736647096026383*^9, 3.736647342233652*^9, 3.7367814444925117`*^9, 
   3.736782176081949*^9, 3.736782215251974*^9, 3.73678321296663*^9, 
   3.736789589011455*^9, 3.73678974425872*^9, {3.736795302706978*^9, 
   3.736795317429077*^9}, {3.736795897479033*^9, 3.736795911813857*^9}, 
   3.7367970240235233`*^9, 3.793998567732177*^9, 3.823228628820745*^9},
 CellLabel->
  "Out[2461]=",ExpressionUUID->"2bf44355-4e5d-45ed-864b-d529aedfecb2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"effort", "[", "\[Delta]0_", "]"}], ":=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["uopt3", "2"], "/.", 
     RowBox[{"\[Delta]", "\[Rule]", "\[Delta]0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.736644731784445*^9, 3.736644803431142*^9}},
 CellLabel->
  "In[2462]:=",ExpressionUUID->"b44f1dda-8b53-426f-aca2-9234466c6787"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uopt3s", "=", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{"uopt3", ",", 
     RowBox[{"{", 
      RowBox[{"\[Delta]", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], "//", "Normal"}]}]], "Input",
 CellChangeTimes->{{3.736644994013253*^9, 3.7366449950149593`*^9}, {
  3.736645185082062*^9, 3.736645240477844*^9}},
 CellLabel->
  "In[2463]:=",ExpressionUUID->"1bfa103b-5cfb-4acf-8d36-9f77ad4d4f7d"],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"1", "+", "t"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     SuperscriptBox["\[ExponentialE]", "2"], "-", 
     RowBox[{"2", " ", "t"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", "2"], " ", "t"}]}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"6", " ", 
      SuperscriptBox["\[ExponentialE]", "2"]}], "+", 
     SuperscriptBox["\[ExponentialE]", "4"]}], ")"}], " ", 
   "\[Delta]"}]]], "Output",
 CellChangeTimes->{{3.736644995575563*^9, 3.7366450099069767`*^9}, 
   3.7366450764669857`*^9, {3.736645182674532*^9, 3.736645205123163*^9}, {
   3.7366452368390303`*^9, 3.736645240819895*^9}, 3.7366473424308167`*^9, 
   3.73678144463717*^9, 3.736782176201782*^9, 3.73678321305014*^9, 
   3.736789589313003*^9, 3.7367897444210167`*^9, 3.736797024155305*^9, 
   3.7939985677704697`*^9, 3.823228628846835*^9},
 CellLabel->
  "Out[2463]=",ExpressionUUID->"56b1101a-8e1c-4de1-8ee6-86e5db28b2aa"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"efforts", "[", "\[Delta]0_", "]"}], ":=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["uopt3s", "2"], "/.", 
     RowBox[{"\[Delta]", "\[Rule]", "\[Delta]0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.736645242665905*^9, 3.736645296089057*^9}},
 CellLabel->
  "In[2464]:=",ExpressionUUID->"a5bf6b1a-ebbc-4e73-8b43-300f116aeb83"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LogLogPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"effort", "[", "\[Delta]", "]"}], ",", 
      RowBox[{"efforts", "[", "\[Delta]", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Delta]", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{",", "Dashed"}], "}"}]}]}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "series", " ", "approximation", " ", "is", " ", "good", " ", "for", " ", 
    "small", " ", "\[Delta]"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.736645308025576*^9, 3.736645323537196*^9}, {
  3.7366473635725737`*^9, 3.73664737469617*^9}, {3.736781431196734*^9, 
  3.73678143168865*^9}, {3.736781473767167*^9, 3.736781504418088*^9}, {
  3.736781543650256*^9, 3.7367815668444633`*^9}, {3.7367816063556967`*^9, 
  3.7367816230020514`*^9}},
 CellLabel->
  "In[2465]:=",ExpressionUUID->"a009439e-3fac-40aa-b8fe-88abfa6e204d"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAA4Yo6tdO5G8CcV4ELUGAxQMQw1Wym
txvAqOJ5hTlfMUCm1m8kebUbwGvBev8iXjFAaiKlkx6xG8AF4Mjz9VsxQPS5
D3JpqBvAIIQY3ZtXMUAG6eQu/5YbwMxp6rLnTjFAKkePqCp0G8C6bFNrfz0x
QHMD5JuBLhvAqNFaEa8aMUCRSHx4d5cawA/NixU0zzBAVSD9q28KGsC+ST0L
u4gwQLdIExYsgBnAtC60c6VDMEClPRh2MOoYwGKJosBt8S9AOcUFLTdeGMAc
1Co6lWUvQFkZ4tmFxhfAQeu81wzOLkAXvlO9mDEXwEcDiUZOOS5Ae/Wt962m
FsDYnV92la4tQGv59icLEBbAkN0kDjEYLUABkCivaoMVwG51H7vTiyxANXfv
bI75FMDID6/gQgIsQPUqpSD6YxTAwYiEuQxtK0BbcUMraNgTwPF/S+jf4SpA
TYTQKx5BE8C9jWpFFEsqQN3n8mKYrBLAi9ZGEB63KUAT3v3wFCISwC9N+J00
LSlA1aD3dNmLEcC8Q4FuuZcoQD322U+g/xDAKLhIC08MKEAxGKsgr2cQwP1H
UDRgdSdAhRUjUASlD8BF2AjuWOEmQPQfwQyvjg7A/3EsjGlXJkB8wzy16WAN
wNTMtIoQwiVAT4yJCylHDMACrXLB1zYlQF32AM/wMgvAIcBfKZeuJECE+VV+
SAcKwAiCF2gUGyRA9yF826TvCMDo1kTgv5EjQIPjfySRwAfABXAEqFH9IkBK
Rq7aBZcGwBh6T2wTbCJAXM6tPn+BBcDXJu5sGOUhQIfvio6IVATArPu21lRT
IUD+NTmMljsDwPEgrwLtyyBAsB0S9ywoAsBVTb0W5kcgQHueyE1T/QDAaO34
/RhzH0AjiaCk/Mz/v5H1blhtax5AgwdrhXJw/b+r/QtkC1AdQHvQ18HxO/u/
z02B3g9KHEDo25nYgRL5v+imCIYITBtAhhkXxzG69r/zo5ARFjwaQLyhNhHr
ifS/6d8c+B5CGUAkXBEzxCryvwTaqHAGOBhABLKCXlyt77+K6bI+SjgXQO9A
Jw5DVeu/CLonS1JPFkA+NEJtaZ/mv8eN0USeWRVAvLyhg6I54r+L+kENiXsU
QEqUV53609u/QNgmw4CpE0Dkd1iSL3nSv4aGl0Q/zxJAuAvF6xN9w7/QetLw
oA0SQE4W1aAfL8O/cfMIAFgKEkDkIOVVK+HCv44me+UPBxJAEDYFwEJFwr8A
XYM0ggASQGhgRZRxDcG/5Hs67XDzEUAyaot5nju9v7VRKxp32RFA9LyMGxV9
s78n2e3rKKYRQCDSrIUs4bK/APwfdvuiEUBM58zvQ0Wyv6AEK+LOnxFApBEN
xHINsb8xV0JheJkRQKrMGtmgO62/XPu1BdaMEUBsHxx7F32jvzf0zTm8cxFA
xElcT0ZFor9/z4UNnXARQBx0nCN1DaG/HcL0yH5tEUCakTmYpTudv9qLcPhE
ZxFAXeQ6Ohx9k7/yfC1E3FoRQA45u+J5DZG/NqzrX8RXEUB8G3cWrzuNv2XY
UmatVBFAP254uCV9g7+ujJU0gk4RQEAv8hLCO32/1dQt/W1LEUACgvO0OH1z
v62Z6LFaSBFAianprV59Y7/nRyRTSEURQEZ3wxN7/IK+71A/4TZCEUDLXjGA

       "]]},
     Annotation[#, "Charting`Private`Tag$1020807#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAA4Yo6tdO5G8Dm1iynGGAxQMQw1Wym
txvA2Cn6AgJfMUCm1m8kebUbwMh8x17rXTFAaiKlkx6xG8CqImIWvlsxQPS5
D3JpqBvAb26XhWNXMUAG6eQu/5YbwPgFAmSuTjFAKkePqCp0G8ALNdcgRD0x
QHMD5JuBLhvAL5OBmm8aMUCRSHx4d5cawL61zYjqzjBAVSD9q28KGsCgIY6i
ZogwQLdIExYsgBnA0TWZ10RDMEClPRh2MOoYwJBgNw+O8C9AOcUFLTdeGMAk
6CTGlGQvQFkZ4tmFxhfARDwBc+PMLkAXvlO9mDEXwALhclb2Ny5Ae/Wt962m
FsBmGM2QC60tQGv59icLEBbAVhwWwWgWLUABkCivaoMVwOyyR0jIiSxANXfv
bI75FMAgmg4G7P8rQPUqpSD6YxTA4E3EuVdqK0BbcUMraNgTwEaUYsTF3ipA
TYTQKx5BE8A4p+/Ee0cqQN3n8mKYrBLAyAoS/PWyKUAT3v3wFCISwP4AHYpy
KClA1aD3dNmLEcDAwxYON5IoQD322U+g/xDAKBn56P0FKEAxGKsgr2cQwBw7
yrkMbidAhRUjUASlD8CurTDB39gmQPQfwQyvjg7A5bJ/H7VNJkB8wzy16WAN
wKmEvXPStiVAT4yJCylHDMAT6eMe8iklQF32AM/wMgvAGp6fANafJECE+VV+
SAcKwK0fStgBCiRA9yF826TvCMDnM90GMH4jQIPjfySRwAfArBRfK6bmIkBK
Rq7aBZcGwBBGdobgUSJAXM6tPn+BBcAZCnY4HcchQIfvio6IVATArppk4KEw
IUD+NTmMljsDwOq9O98opCBAsB0S9ywoAsDDMagUdBogQHueyE1T/QDAUeQG
gA4KH0AjiaCk/Mz/v2iKjoQ58x1AgwdrhXJw/b+YyfN09MQcQHvQ18HxO/u/
FC4qE7SqG0Do25nYgRL5v8ozix78lRpAhhkXxzG69r+Z0skV1GkZQLyhNhHr
ifS/tJbZurBRGEAkXBEzxCryv+jzxksdIhdABLKCXlyt779X8t5JEvgVQO9A
Jw5DVeu/EhbI9QviFEA+NEJtaZ/mv+bSjo2VtBNAvLyhg6I54r8FtSbTI5sS
QEqUV53609u/XzjphTqHEUDkd1iSL3nSv9JUiSThWxBAuAvF6xN9w78jLfXh
GIkOQE4W1aAfL8O/di6XWFp/DkDkIOVVK+HCv8gvOc+bdQ5AEDYFwEJFwr9u
Mn28HmIOQGhgRZRxDcG/uTcFlyQ7DkAyaot5nju9v09CFUww7Q1A9LyMGxV9
s797VzW2R1ENQCDSrIUs4bK/zljXLIlHDUBM58zvQ0WyvyBaeaPKPQ1ApBEN
xHINsb/HXL2QTSoNQKrMGtmgO62/EmJFa1MDDUBsHxx7F32jv6hsVSBftQxA
xElcT0ZFor/6bfeWoKsMQBx0nCN1DaG/TW+ZDeKhDECakTmYpTudv/Jx3fpk
jgxAXeQ6Ohx9k78+d2XVamcMQA45u+J5DZG/kXgHTKxdDEB8G3cWrzuNv+N5
qcLtUwxAP254uCV9g7+JfO2vcEAMQEAv8hLCO32/3H2PJrI2DEACgvO0OH1z
vy5/MZ3zLAxAianprV59Y7+AgNMTNSMMQEZ3wxN7/IK+1IF1inYZDEAZci+F

       "]]},
     Annotation[#, "Charting`Private`Tag$1020807#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-6.931471805599453, 3.512433129988702},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->
   NCache[{{-Log[1024], 0}, {3.512433129988702, 
     17.376221388890926`}}, {{-6.931471805599453, 0}, {3.512433129988702, 
     17.376221388890926`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 
       6}]]& }, {{{-6.907755278982137, 
       FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-5.298317366548036, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.005\"", ShowStringCharacters -> False], 0.005, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.010\"", ShowStringCharacters -> False], 0.01, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.995732273553991, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.050\"", ShowStringCharacters -> False], 0.05, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.100\"", ShowStringCharacters -> False], 0.1, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.500\"", ShowStringCharacters -> False], 0.5, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {-7.600902459542082, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.418580902748128, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.264430222920869, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.1308988302963465`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.013115794639964, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-6.214608098422191, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.809142990314028, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.521460917862246, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.115995809754082, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.961845129926823, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.8283137373023015`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.710530701645918, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
      4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}}, {9.210340371976184, 
       FormBox[
        TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}}, {11.512925464970229`, 
       FormBox[
        TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}}, {13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", "6"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}}, {16.11809565095832, 
       FormBox[
        TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.4011973816621555`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.6888794541139363`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.0943445622221, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.248495242049359, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.382026634673881, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.499809670330265, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.298317366548036, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.703782474656201, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.991464547107982, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.214608098422191, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.396929655216146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.551080335043404, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.684611727667927, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.802394763324311, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      7.600902459542082, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.006367567650246, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.294049640102028, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.517193191416238, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.699514748210191, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.85366542803745, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.987196820661973, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.104979856318357, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.903487552536127, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      10.308952660644293`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      10.596634733096073`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      10.819778284410283`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.002099841204238`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.156250521031495`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.289781913656018`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.407564949312402`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      12.206072645530174`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      12.611537753638338`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      12.89921982609012, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.122363377404328`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.304684934198283`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.458835614025542`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.592367006650065`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.710150042306449`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      14.508657738524219`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      14.914122846632385`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      15.201804919084164`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      15.424948470398375`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      15.60727002719233, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      15.761420707019587`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      15.89495209964411, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      16.012735135300492`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      16.811242831518264`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      17.216707939626428`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      17.50439001207821, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      17.72753356339242, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      17.909855120186375`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      18.064005800013632`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      18.197537192638155`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      18.31532022829454, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      18.420680743952367`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      19.11382792451231, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      19.519293032620475`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      19.806975105072254`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      20.030118656386467`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      20.21244021318042, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      20.36659089300768, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      20.5001222856322, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      20.617905321288585`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}}]]], "Output",
 CellChangeTimes->{{3.736645319762697*^9, 3.7366453265688868`*^9}, 
   3.736647344848281*^9, 3.7366473775758753`*^9, {3.7367814323878*^9, 
   3.736781446157749*^9}, {3.736781484961615*^9, 3.736781493408966*^9}, {
   3.736781550005159*^9, 3.736781568642115*^9}, {3.736781612879725*^9, 
   3.736781624624413*^9}, 3.7367821776341143`*^9, 3.736783214614368*^9, 
   3.7367895909791193`*^9, 3.7367897457307796`*^9, 3.736797025475713*^9, 
   3.793998568695068*^9, 3.8232286297343187`*^9},
 CellLabel->
  "Out[2465]=",ExpressionUUID->"3a8c9f45-cdf7-463a-9e87-496a28800196"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Wgeigs3", "=", 
   RowBox[{
    RowBox[{"Eigenvalues", "[", "Wg3", "]"}], "//", "Simplify"}]}], ";", 
  RowBox[{"TraditionalForm", "[", "Wgeigs3", "]"}]}]], "Input",
 CellChangeTimes->{{3.736781739083941*^9, 3.736781839566794*^9}, {
  3.736781886607852*^9, 3.7367819125394783`*^9}, {3.736782154095422*^9, 
  3.7367821861938763`*^9}, {3.7367822698570213`*^9, 3.7367822811946573`*^9}},
 CellLabel->
  "In[2466]:=",ExpressionUUID->"7fc70490-752a-47c0-ac10-017c0c4d2f2b"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"\[Delta]", "+", "1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Delta]", "+", "2"}], ")"}]}]], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Delta]", "2"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]]}], "-", 
        RowBox[{
         SuperscriptBox["\[Delta]", "2"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", "\[Delta]"}], "+", "4"}], ")"}], " ", 
           "\[Tau]"}]]}], "-", 
        RowBox[{"\[Sqrt]", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"\[Delta]", "+", "2"}], ")"}], "2"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"\[Delta]", "+", "1"}], ")"}], " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{"\[Delta]", "+", "1"}], ")"}], " ", "\[Tau]"}]]}], 
               "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]]}], 
               "+", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"2", " ", "\[Tau]"}]]}], ")"}], "2"]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{"\[Delta]", "+", "1"}], ")"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"4", " ", 
              RowBox[{"(", 
               RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[Delta]", "2"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]]}], 
              "+", 
              SuperscriptBox["\[Delta]", "2"], "-", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"\[Delta]", "+", "2"}], ")"}], "2"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"2", " ", "\[Tau]"}]]}], "-", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"\[Delta]", "+", "2"}], ")"}], "2"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"\[Delta]", "+", "1"}], ")"}], " ", "\[Tau]"}]]}], 
              "+", 
              RowBox[{"8", " ", 
               RowBox[{"(", 
                RowBox[{"\[Delta]", "+", "1"}], ")"}], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]]}]}],
              ")"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "\[Delta]", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]]}], "-", 
        RowBox[{"\[Delta]", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Delta]", "+", "4"}], ")"}], " ", "\[Tau]"}]]}], "-", 
        RowBox[{"3", " ", "\[Delta]", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", "\[Delta]"}], "+", "4"}], ")"}], " ", 
           "\[Tau]"}]]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Delta]", "+", "4"}], ")"}], " ", "\[Tau]"}]]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", "\[Delta]"}], "+", "4"}], ")"}], " ", 
           "\[Tau]"}]]}]}], ")"}]}]}], ",", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"\[Delta]", "+", "1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Delta]", "+", "2"}], ")"}]}]], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Delta]", "2"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]]}], "-", 
        RowBox[{
         SuperscriptBox["\[Delta]", "2"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", "\[Delta]"}], "+", "4"}], ")"}], " ", 
           "\[Tau]"}]]}], "+", 
        RowBox[{"\[Sqrt]", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"\[Delta]", "+", "2"}], ")"}], "2"], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"\[Delta]", "+", "1"}], ")"}], " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{"\[Delta]", "+", "1"}], ")"}], " ", "\[Tau]"}]]}], 
               "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]]}], 
               "+", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"2", " ", "\[Tau]"}]]}], ")"}], "2"]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{"\[Delta]", "+", "1"}], ")"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"4", " ", 
              RowBox[{"(", 
               RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[Delta]", "2"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]]}], 
              "+", 
              SuperscriptBox["\[Delta]", "2"], "-", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"\[Delta]", "+", "2"}], ")"}], "2"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"2", " ", "\[Tau]"}]]}], "-", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"\[Delta]", "+", "2"}], ")"}], "2"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"\[Delta]", "+", "1"}], ")"}], " ", "\[Tau]"}]]}], 
              "+", 
              RowBox[{"8", " ", 
               RowBox[{"(", 
                RowBox[{"\[Delta]", "+", "1"}], ")"}], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]]}]}],
              ")"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "\[Delta]", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]]}], "-", 
        RowBox[{"\[Delta]", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Delta]", "+", "4"}], ")"}], " ", "\[Tau]"}]]}], "-", 
        RowBox[{"3", " ", "\[Delta]", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", "\[Delta]"}], "+", "4"}], ")"}], " ", 
           "\[Tau]"}]]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"\[Delta]", "+", "2"}], ")"}], " ", "\[Tau]"}]]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Delta]", "+", "4"}], ")"}], " ", "\[Tau]"}]]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", "\[Delta]"}], "+", "4"}], ")"}], " ", 
           "\[Tau]"}]]}]}], ")"}]}]}]}], "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.7367817396585407`*^9, 3.736781840266509*^9}, {
   3.736781888408072*^9, 3.7367819131505623`*^9}, {3.7367821779940643`*^9, 
   3.7367821866813993`*^9}, 3.736782283120139*^9, 3.7367832158483047`*^9, 
   3.736789592404249*^9, 3.736789746965836*^9, 3.736797026792873*^9, 
   3.793998569289055*^9, 3.823228630395583*^9},
 CellLabel->
  "Out[2466]//TraditionalForm=",ExpressionUUID->"1b5012c5-6426-4a7e-9cce-\
a85c3283e9c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{"Wgeigs3", "/.", 
    RowBox[{"\[Delta]", "\[Rule]", "0.1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Tau]", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.73678184349123*^9, 3.73678187110402*^9}, 
   3.736782161242794*^9, {3.736782290436957*^9, 3.736782299270441*^9}},
 CellLabel->
  "In[2467]:=",ExpressionUUID->"4c8374f6-03ec-46c0-9453-c61ec7093a6f"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Xk4Vd0XB/B7b2SsJDRxriEyz8pQ1lGSIUIa+CmVN4oUFUki3gwJaUCI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       "]], LineBox[CompressedData["
1:eJwV1nc8Vf8fB/B7hawi0iQqhMgqq/E+JZK9fkVTZERJQ8oK36JCKaPsSDr2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       "]]},
     Annotation[#, "Charting`Private`Tag$1028935#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-4.628886712605407, -21.680129813358732`},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->NCache[{{-Log[
        Rational[512, 5]], 
      Log[10]}, {-21.680129813358732`, 0.}}, {{-4.628886712605407, 
    2.302585092994046}, {-21.680129813358732`, 0.}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 
       6}]]& }, {{{-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.01\"", ShowStringCharacters -> False], 0.01, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.995732273553991, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.05\"", ShowStringCharacters -> False], 0.05, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.10\"", ShowStringCharacters -> False], 0.1, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
       0.}}, {-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.50\"", ShowStringCharacters -> False], 0.5, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}}, {-5.298317366548036, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.115995809754082, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.961845129926823, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.8283137373023015`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.710530701645918, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.4011973816621555`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.6888794541139363`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.0943445622221, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.248495242049359, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}, {{-20.72326583694641, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
       FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {-18.420680743952367`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-16.11809565095832, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.512925464970229`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.605170185988091, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.302585092994046, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}}]]], "Output",
 CellChangeTimes->{{3.7367818538684063`*^9, 3.736781871562407*^9}, 
   3.736782178242405*^9, {3.736782295368228*^9, 3.736782300659802*^9}, 
   3.73678321647331*^9, 3.736789592917692*^9, 3.736789747460845*^9, 
   3.736797027446815*^9, 3.7939985694732847`*^9, 3.823228630577029*^9},
 CellLabel->
  "Out[2467]=",ExpressionUUID->"ddb28cc4-bf46-4556-bf48-d32df3673ff2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eigratio", "=", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"Wgeigs3", "[", 
       RowBox[{"[", "2", "]"}], "]"}], 
      RowBox[{"Wgeigs3", "[", 
       RowBox[{"[", "1", "]"}], "]"}]], ",", 
     RowBox[{"\[Tau]", "\[Rule]", "\[Infinity]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"0", "<", "\[Delta]", "<", "1"}]}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.736781946644928*^9, 3.7367820172711287`*^9}, {
  3.736782163482934*^9, 3.736782164785309*^9}, {3.736782305335903*^9, 
  3.736782307527833*^9}, {3.736782377395185*^9, 3.736782408674513*^9}},
 CellLabel->
  "In[2468]:=",ExpressionUUID->"149e76f9-fc63-4308-9a5b-eb98168975fd"],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", "+", 
   RowBox[{"4", " ", "\[Delta]"}], "+", 
   SuperscriptBox["\[Delta]", "2"], "+", 
   SqrtBox[
    RowBox[{"16", "+", 
     RowBox[{"32", " ", "\[Delta]"}], "+", 
     RowBox[{"20", " ", 
      SuperscriptBox["\[Delta]", "2"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["\[Delta]", "3"]}], "+", 
     SuperscriptBox["\[Delta]", "4"]}]]}], 
  RowBox[{"4", "+", 
   RowBox[{"4", " ", "\[Delta]"}], "+", 
   SuperscriptBox["\[Delta]", "2"], "-", 
   SqrtBox[
    RowBox[{"16", "+", 
     RowBox[{"32", " ", "\[Delta]"}], "+", 
     RowBox[{"20", " ", 
      SuperscriptBox["\[Delta]", "2"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["\[Delta]", "3"]}], "+", 
     SuperscriptBox["\[Delta]", "4"]}]]}]]], "Output",
 CellChangeTimes->{{3.73678198614541*^9, 3.736782017644669*^9}, 
   3.7367821786375933`*^9, 3.736782339761861*^9, {3.73678239402507*^9, 
   3.7367824101881647`*^9}, 3.736783217215404*^9, 3.7367895936736383`*^9, 
   3.736789748314012*^9, 3.736797028189139*^9, 3.793998569938149*^9, 
   3.8232286310362453`*^9},
 CellLabel->
  "Out[2468]=",ExpressionUUID->"fd19719c-2d6c-4c24-b41c-7035fa2cb08e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"eigratio", ",", 
   RowBox[{"{", 
    RowBox[{"\[Delta]", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.736782411562427*^9, 3.736782422937806*^9}},
 CellLabel->
  "In[2469]:=",ExpressionUUID->"5fcc635c-5862-4059-a244-4368dda5131a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["16", 
    SuperscriptBox["\[Delta]", "2"]], "+", 
   FractionBox["16", "\[Delta]"], "+", "6", "+", 
   FractionBox[
    RowBox[{"15", " ", 
     SuperscriptBox["\[Delta]", "2"]}], "16"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Delta]", "]"}], "3"],
    SeriesData[$CellContext`\[Delta], 0, {}, -2, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Delta], 0, {16, 16, 6, 0, 
    Rational[15, 16]}, -2, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.736782423293674*^9, 3.736783217432769*^9, 
  3.7367895939018106`*^9, 3.7367897484964437`*^9, 3.736797028423029*^9, 
  3.793998570014145*^9, 3.823228631150728*^9},
 CellLabel->
  "Out[2469]=",ExpressionUUID->"a21af705-3a4c-4e48-9ec4-03a37459c017"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"uopt3a", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"b", "\[Transpose]"}], ".", 
        RowBox[{"MatrixExp", "[", 
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "t"}], ")"}]}], "]"}], ".", 
        RowBox[{"(", "Wginv3", ")"}], ".", "xtarget"}], "/.", 
       RowBox[{"t", "\[Rule]", 
        RowBox[{"s", " ", "\[Tau]"}]}]}], "//", "Simplify"}], "//", 
     "Flatten"}], "//", "First"}]}], ";", " ", "uopt3a"}]], "Input",
 CellChangeTimes->{{3.736783273252201*^9, 3.736783287329196*^9}, {
  3.73678357263048*^9, 3.7367836056915493`*^9}},
 CellLabel->
  "In[2470]:=",ExpressionUUID->"c1910de7-7fc6-4239-a1f6-2f4569e9d50b"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[Tau]"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"s", " ", "\[Tau]"}]}], ")"}]}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[Tau]"}]]}], ")"}]}], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"s", " ", "\[Tau]"}]}]], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}], 
          ")"}]}]]}], ")"}]}], 
    RowBox[{"2", "+", "\[Delta]"}]]}], 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], "-", 
       FractionBox[
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[Tau]"}]], "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]]}], ")"}]}], 
    
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}], 
          ")"}]}]]}], ")"}], "2"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]]}]]], "Output",
 CellChangeTimes->{
  3.736783289685017*^9, {3.7367835712815647`*^9, 3.7367836061935368`*^9}, 
   3.736789594134227*^9, 3.736789748722245*^9, 3.7367970286529837`*^9, 
   3.793998570122286*^9, 3.8232286312797613`*^9},
 CellLabel->
  "Out[2470]=",ExpressionUUID->"882d7f3f-a421-45c6-80bb-a06600d95f67"]
}, Open  ]],

Cell["\<\
Long protocols (\[Tau] \[RightArrow] \[Infinity]) are problematic as they \
require large u in general.  So the control effort is more properly \
\>", "Text",
 CellChangeTimes->{{3.736635962686264*^9, 3.736635977575574*^9}, {
  3.736636024620076*^9, 3.736636029258498*^9}, {3.736639280394116*^9, 
  3.7366392980015287`*^9}, {3.736790106132189*^9, 3.736790116770254*^9}, {
  3.736790151382821*^9, 3.73679018496826*^9}, {3.7367902264710293`*^9, 
  3.7367902346062603`*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"49fe9587-0a42-4eb8-a7a1-94e728732850"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"uopt3a", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Tau]", "\[Rule]", "10"}], ",", 
      RowBox[{"\[Delta]", "\[Rule]", "1"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7367833005408173`*^9, 3.736783441231846*^9}, {
  3.736783487123782*^9, 3.736783534028808*^9}, {3.736783610995742*^9, 
  3.736783614011517*^9}},
 CellLabel->
  "In[2471]:=",ExpressionUUID->"dc9954a5-b0a0-4059-bbc8-cd2a5ce0f72f"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVV3c0F94bNlLIyMxItijrK5H53mskUSgi2aQQ2VGKlE1GKCszSRnZIT62
7L333kJpoV+/f+49z3nu+zzvOe895z0Pt8W9q7dIiIiIAv8d/78v3VrqJizr
KVJ4yWaQZNESDimzOU6ySkJHue+aYBot4Wzyq8RCVhXg074lypZIS9BoHyxI
YtWFiD6lxpvhtAR9qx+fo1itYCLY+/QVF1pCvTJbaV2iNUibegpV29ESxHkV
8r9x2oDs3kfDH5a0BPIZ37TrAg6g6zJjWnGNljAuFqAcxuoKewpbx5+J0xKi
k1kI/DfdgDE+uZvrFC3hEm22fFWiOwyt36/y4aAllGy0ndvk9IQpz3WuQApa
wvMcekEdgcfw6fqAaeYEDUGVIyNj+bY3BLSdPHall4bwuDH+WI2uDwQWN38q
aqIhSEoJh92IfQJxZ5VbKvNoCClMWv7BrM+g6ReTWZYXDeFh+8v66+XPgO2O
lcX5ezSE635TJLw3/aD2jPuCrzkNgeq7k3dFoj8040P8qqo0BI++aI81ziCo
kdtldaCgIVwLHS8pIwRBY2tSZ80vaoKoisD3Z+bBkB6nfqV1mZowV1jqxJEe
AqKqslL7zdQEnRcjtlcEnsMge6hZ61NqgrAG7zu2pueQwdrPVOlETSAnvbu4
cDscrmu2xhqbUhNMPx18rNaNAIqgjdv5MtQEJqEIUYPYSPCxvr7nu0JFeEJe
eCqINRrkz7jXqcpTEU6rRQYWOEbDNZpu8V88VIQev3vLo03RkJnjWqpEQUXg
IxV+L+oeA8U9vrei+44SGvczRPt6YqH2y74ki/VRAtVO7DnO0Dj44rWFWl0o
CcX/ucVenI0Ds/39Zw7XKAkmjtd+OMnGQ73IoVuvJCgJeeu0n+qX4uHg5tmh
h5sUhKtLgfK2qong+aFB2sqSgvBq/IFy8cFrUOKK+vBFgpyAT9zImNBLBlsH
jdLrlOSEFUNpMvKcZIgSEtwymD5COLnmaZkjkgJ5uYuXy8KOEO7ZSPETjaXA
xFeSgprJwwR6q7ysN+fTIL+E/mDzNhnB+unJG7JWaRBpGcmKpMgIFWlhFJ3h
aVAh4Nq+RUpGsJq2s/25kAZtaK3RNekQodhEUFgjJh0m9IV2eptJCQY3UvO+
bmXAquKpsMa/xITNUV3KNLY3QJxFnRfZREzwNyG/dU35DbRvvEyofk5MKLS8
x1YS/QaYjDKPATsxgcZBwe+hdCZMin6OzxYmIjT4DhsefvQW5FO5XBXM9qqN
yMKKS9+8BcLZTovDo3+qtwPQMZuOt7AzzT98V/dPNVfY24ZWzixIH2aoPqL8
u9rrpZt4ZG0W1AntcZym/Vkt8YHu8AnybEgc1T5darZT/UW0waxdPBsyj3Xf
Pla/XW320aPi8Y1suO53LWqEf7s6rGTScTo7G8TfpI0Vz32tXiLkjGZefg/9
RJlDd16vVb/uV//434sPEGHrxar8brr66N8nRmon80B/31KR9H0rvLLRNxG+
kAf+4ry0Rse7ga9P2IzOIQ+cCrnrm8z6QPHdoOXo5zxI2CzgDKYchU/vYotL
RfPBpTejM8V4DtavrVVqdOTD1aKv+j63t0CSYlBBcSYfFoZVSuf1t+FBVU2V
+G4+tLKHydpc2oEjQi8JTCc/goKt7c/hc9+B+wDXT9p/hFtUf5s6BH6BXtbL
VhfqAmij2bGHciKUaOyrac1dAIfPkllpqRCjGXr7doNzBbDR7OT9vJMY3Xuk
1KlgXADSVaupacskKOjqes+RnALgGoqqNBEmQ5/3lEYSNAvhXAThJsMGBeLX
2ViqCymCwNFW4isy9IjNW032dmoRNMjSSQsk0KNjOSkhlKVFsK5Nf3R8nx79
Jr8mqjNTBPj5g/PrDQyoi1DqMnG+GBwJ4luNZkzogfiTg5/zxfBdqPj0XC0L
umcyopX4pxh0G/zuuZ5lRVahZ1OBrgScv6wY/c1gRVpL88r+8iWwlZSUThXC
hvhSLgUxvCgB7dKf5TKWJ1AHLSOjKCqF7C9GVM08XKhOwf5Wt14pbBDpZxlY
cqEyu8YSV7tSmPFeUHbP4ELpTR43KmJLoZVjIM1IkBt5eI+/vrheCkzVeQE7
UjyIZzNTyDK+DFyPKtvIO/Kh+x0y8OrbJ9g3JnktdVMI0YgWz38hLwe5hFOq
y++EUEaYeOifE+XwzXNkU+qXEOrWPDVsoloO70POBryNO43OtDK68MeWw2Ra
fdqf6TNosmkzs0C6AuSWXKOsIkWR+ym7y3MaFfDY2DlBfUUUUQUs7DCZVUBr
xXm9UWUxJHNhHHkGVsBGm1EAxS8x9KK+ZQSGK6Can/LQcLE4Uqt5Q9P+oBKu
/Il9miojgSa4uIsPnlcCefNabo2dBHL1Sbwpnl4Jz0WED/BrCZQKL7JetFZC
7k2x5FuHzqI/n32UDE98hkWOnAsa/WdRXvlN98XPn6GWhCtRIPgcOl5EN0FM
XA1klo8CqFRlkFHoH9055mpYVZmXGQ+SQWlW862NwtVgXfSwSaZTBgkzffoU
YlANGbpGPvE3ZZGSu1kMU341vL+ryHv8oRySStTPjBYjQHzvGu1yvwK6Edg2
7SdLAKMYhvxvvIrIyxVz3FclQFKYxtkkZ0VUo3km+sZNApRJKt35QgdIc//g
yckAAowmnNUZPIOQuUmmcdYEAYr4JOZvPMHo2SX2uLhlAtDLZ1SG5mCUKRXR
F/yNANzbEHh8BKM1mgca9pQ1kPpOwFdaUgm5V1+WkZCqgV353ZWCNSUUyvWd
sTKsBgrPLGaevqeCSmaU2zrla+H+o/8MvlepoYGLT7bC1GohFrmx2++qod3c
KmbNq7Ugrn1CQ0v0IpJ+KGPefLsWtnyfLeslX0RlDGK7hKhayP44gp74q6NP
KmxcBUu1oCKpmLZvo4FGsvVVHXdq4aJ1s5hHlgb6fSzGVvSgFk44vn1vs6iB
ZMdpi7MZ6sDoFVN1kbUmKncju5SuWAeFk/IjJHaXUWXmV5fo6DrobHGegRAt
NEYlGnc1uQ6S+q70hHdroT1nu6pj2XWQyGyuJUGljRRggTysug7I5K5A1zVt
VDU4muS3UgcKEtSNCgvaqJq8qckd1cOxFwELl1iuolrbJPYba/XQTWn7s7hI
FxUu29mZ7NZDj8C7LO4JXZRxR7bCkqgBZM8dN+8/oof8rAcNHRgbYNk8s4HZ
SA9dtKCLfyrfABznn/vRkF9HnTf8WHJDG4Aq6lyagoM+Grtoz0Qq0ghNCirU
PPcNUXuT3C1y6Ua4ZJfy5mm2Iaq6QFlMjRuBXSAmTWHCECWrvNVl0WuEB34p
NJ8v3EQWaPqFyKNG8NttJPxiN0JL0nr0Bu2NMPS4+NTGoDH6LqBAm2PfBDR2
rdoU7WZIcUapKdijCZwHEG/AphnyT7rofedpE6S9+K9Yhd4cMTPqbvLGNUEL
T/qoj4E5kiK264yvb4L4l5/KKZbMkcfoq/BA9mbwIFGIrWewRHvh32itvjSD
92aiJ0q9hVQ0fjfhvmZgWz9nn9J2C4UeJvLhnGyGFhv1bq2ftxDHo6NfR741
g071AXuytjVStOXp0uH6Al4+CxdpyW4jbxXtCLj/BWgvPkgqfnQHkfx6f4yd
vwVa6zScNQvsEHu70g6ItcCzZIc99nk7JJk63G8l0wLhjw3yMctddEv9SELu
5Rao93RqjfS+i5rjLPiV3FvgO43nA92r9ihcllXWpqkFZvJmWefI76ETXv6W
pTatQIiVTBA3dULntDkujLm0Qno59UToYyd0ha9IkPhxK2y9vPKd47UT8m6b
Xr8U1QrA++f35LgTmjmh4DFR3grC1Bo/1kyd0bvPO6FkVG2Q9WX1tKeDC5L6
a1ZyLbcNDKhzctZK3ZDmZYKvalkbjFoa+PSMuyHLBE4t6do2yP0Dwbuk7ihC
emKRbaANTBOpen5ru6PlezdZZ/bb4DCcPP933R0lTul5OV5uh/cL2mk6kh6I
uPaSUthaOxBtmhnSfX+AWI5l03jvtkOxVvTJEN6HSNSEYtSRqANiH9e2aF99
iAx/N7noMnaAHm9vdU3+Q1QkofqGXb4DnMhZA9WcvJB1OpBnh3RA1fdBe23i
x6jtmWRH4+lOSHqL6DzyfZAsbStJ5LlOWCIKnDHu9EFZcebSN1EnzHd1ST/Y
8EFPc5+nbOp1gmeS16K+yBMkO7TkzPKkE16zKHZ8zHmCss4kHbcd7AS8vX/v
3CdfpLTsm39YqQuYT1scu3zwDHmKdrTYqXUBlXPBk0Y+P5TvwjrfpdkF7bxf
A55q+KGTB3msCfpdIGqRx98S54d+0Y/7itl3AZ41exEr44/y5aX1DF51wZNP
pyDWPwBxRqz+erfRBcfOO9R8uBGMqsy93xXsdMEZ98nUa/7ByOQsw42Kn11A
/gAslQuDUeKAbFkbSTcYtPEZ/6UOQSwcwe6bzN3w03+Gb7cxBNFnC+5IQjec
Ur31n7paGCKrv7VWHd4NUsHm772VIlBGzK+E5uhuaIm80TxsHIFUbodpdMd1
w+E6FiszzwjkS1mcPZPeDed47c59y49AB9qHbMjKuqFRo15AkScS/RxPm780
1Q1C9xf2Eqij0OqPyYl+8R6YsThP+poiGpXcDq+9JNUDHvLCWusi0chnUDGz
Wq4HON4nuHldjUbMpUn27y70wPXVSGqjxOh/++fmnpdRD3C53iwWPhuD4r8N
sPIF9oDG2O86D/tYdHGrXdd5sgfYVrlbqVjiEIP5o/OLcz0wpKVyXEE1Dk10
CZ8wWumB9ndRKZXOccg1P2RW9XsPjPI9iHjfEYeS76k7sx7tBeS3wG0QHI92
1+vDCVK94BXRddSGLhFlrFS00DzvhaVwmi0/i2Tk8FKL1/ZFL4hRCvsXxCUj
aZXZhw2vekG4nHdAoTsZtSRRinil98LxO09iPnGloC3tG+HLZb1wI8sTn3uR
ghRLd6/Vz/ZCVmyqUPiTVDT89L9xT5k+mDp85oOkfzpKE28416/YB6srLHLG
Weno7rjBc3GVPvBd2L1MaElHRNI+sHilD/ayOcKkj2UggZWOVF2rPogMEnf7
npSBXLXvWouF94H97iklioY3iIbj7ebcXB9Qu4ypBqpkIXT96fjsch+Qqs6r
7dhlIedw09aZjT4wuHObM+lFFhogZnk79bMPtr88HsudzUKvFwJNxqj6QVF+
KaLf/x0Szbdt75XsB86fxX+DhrPRZWXR97XP+sF4qPvgSWEOeuxFGVcT1A/M
4SrG0bM5KL94wZ/wvB/aDt2W22HIRYyCyRZVr/qBke++4Su33H/77hhb+Yd+
CN/OCwiTz0N3B7YCP/b1Q4qd7+vmu/ko1KbYOoVvAM4nJyu3CBWgFZQTePT0
AGzITH+KVi9Aaixvst3FBiDwqcB+jE0BImmK3tCUHQDaB84WitkFyJPP1f2X
1gCUiWK6/0QLkfWkhP/VhwMgF1NmtYOKENbLf3OoZwDqr2Kx8ugS9Fo4q+ne
4ADsFvu846osQXukKcsjYwP/8sLIt5bZElRWEC7ycXEA2LLud66dLUWix+4V
G+8PQPSHU67Og6XoRKtIQ4ngIDyPC2fcPPMJ7aL3c3e8ByHhfM8qP00lqsxY
Tbj/bBCsvv4uKpSrRL7kwtf8gwZhPkw5ItimEtF0fahJfzEIffp/tZgaK5GA
ae7ribeD8OLAZeq972d0/dFHA92uQaCY6j6uRlmNij+VtgH3EKT2ET++fqYG
PeD4+fSKwBCc7qarEFCrQejJeTnjM0PQwxUTyGtZg9oufnr34NwQqOg82kpP
qEFzg+X+xepDsKpkMdpEU4sYdz+jM85D4LPPEzG2X4tcJeqLmOuG4GMgOned
uAFZS3KlRDYPwa36kgNegQZkIOUVQtUxBGGf41P/02hAcrKSFiTDQ8C/dkOE
JrYBkShl0G5sDIGRsVr8kGgjCtd5ZtvANgzHvihLH7dvQtmOKlyuzsNg5OP1
IZCzBSU6pxzdvD8Ms1m12lKXW1CY696uzaNhKLFs4zz7sAU5ehS1mwYOQ7x1
sPmJoRYk7cP3UOP1MHxt40iujGlF9eGHBnhahuHzryMe+VztaDK3PqSbewTc
7t/zq5LvQl3rh9YkTo2AhDcSiTToQgRhVc1o4RHgKnDmfuHahVKyG6j0pUeA
U2dGTCCnC1lkNoaNaY5AqjrDl0iubrSQ1By+eP8fJoQMNB3rQeuhbS/220fA
p/6yDSNrH5popfpm0jsCs1Lzoe5yfaiD8rIuYWgEbgxosTCY9KHcwHbGp7Mj
UCNXsb2X3occn3XEkP8agQv6XnmvJfrRt4ddLxn4RiFbpPmi680B9Me2L0Ho
wShMbvbkGk0MIV0p40hR71HgG/ZO2yMbRh+IF/zPPhuFawY3r46KDCOTVz+c
FJ6PQnvuBZfrj4dRTQPbRZ20UTg4PlN0hWcEBXCZf/NoGQXPOO4Tqe6jiGFg
XbOZbQzo4i8Rqq5NoLup7krtnGNwP8TGluTZBKq/+1e6h28M5P+OOEcVTSB3
UjreMdExyNaxfxLHPImGxSV/bSqNgfo857b2xCRKDnnw5rjdGES8rlK2qZpC
Z/CRA+uKf/xQRtyI1wzKz35/aogwBh+0r6mUJ84gSUZtHfXGMeAXtYzrqpxB
8ouvMs50j8ECmd6ntP0ZdCXstMbXhTG4ZOYksfhkFjkPX37lST8O5Exikhdi
5tAnp2iJUJtxUES1K4IrC0hx9LzRvsM4hEob1yXTLaJalXE/B9dxcJ8/pGQo
s4hajgsMa3uPQ6DMYeLEoEU09rnUmylmHFSYhExMRZYQEeVo22vCOMx7J2xf
8V1Gamnctz8en4D20Zo5tVtrSPIVjUDjiQkgHZZjnI1aQ1zP/8yNcE/Ar/Eo
ySbCGvrt2W9xSHgCAvXk2e5yrKMcnSATfTQB+A2z5bmRdcRAvKW3f2cC3rnM
Z4lZbKJJU4KKevkE1E1FfEnU30JtejmkJtUTkNv9LsLJZQuVacTXOtdPwMKU
5YBz+BaKknZFiR0T4Ewn+vtP0xZSpRWU35yZADM+wafictvofVX42Zijk2Aq
YsZieXoH3ecw5Zk2moQ8ei+So6LfkYW2+PUx80m4XW83dV3rO7rylDh40HoS
BK7FLg04fkcCy+lb7Y6TQD7gWuVa9B31FS0Ryp9NQmiMbqi44i4S13Q2jf4w
CQ9Iqj5v3/yBlh74JartTYJdoddn6rpfaOX6mTupRFOgQmlNHbD6C5l9ZSDh
JJ0Ci7Mna4DxN9LgnT/HRj4Fhhks047WvxFPUEDSMfopSG87QTxO/Qd16bbd
3eefgtV4ynIpmz0kvKZ3dPDyFOwvbuZO6/5FZbqa1cHaUzAdjX4oB/9Fyp+V
XBSvTYHMHc4dIsJfZPhcbPSNwRQMtlGXXmAmwkHiFO9dLafg1Wu1OiI/Irzg
WnmJ3vMfjhgRdbIjxin7PMGXM6bAQSfQIcKEFAtbsyoSv50CgaZhhVBvUlza
Qbtd9G4KBLmfMRBSSHFH8t6NE3lTEJeTd6V7lhTv4wGh1U9TQPnaOTLj7iFs
6B/0JbBzCm4qt3ZZBZFhBtqv5PW/p4A7nGqKd/sI7vkcHKC+PwUrgp6qp1nI
cdRd/sOdf6fgVk7A8l1FckzfYkg6cmgafBof2WWF/MN+DfubNNNAuJa5TCJE
gY/9id9m552GDX8P88R7lJhqUXXMRWMafo1ydUqJUeO2mCnDX5enQbunviDI
mBqHqjwcfqw9DfrVf3b5Q6nx0bT8gSC9aWCa03CWX6HGlMbs3cmm07CcTsK0
8Y4Gk/d+bWh1mYYtxo7KBfZj+FB1Qh5v4jRcEMLiHs10eERe5eLk62lI21UY
o1mkw3nla1PxqdNwZzaGaoSMHhuWKNDTv50GsUeqlrQq9PhjzqQrUcE01Nmd
Wf5bS49NEnllx5umQSsqxOpSKwMu83xfH7vzr/7WVS9pcmb8/Mc146u706Dx
KfEpqygztnTb+079axoUbU5HyesyYxqny6f8Dv75E399qpbKjG/d2QxyoZgB
khWzE48Uj2N6/bNa2pwzoOdLV9bmx4LtJCuGKTRmQFdL0VxXgx0Tuvo/lF2e
geyGh2kWnuyYyf6r923tGWC2sfCqesuOq9/wCzTozcDRwhgyc7ITmOF4hLOP
2QyoEi+um9afwBW/rI7+cPunF2l9UKFzEh+tplGYS5mB1WdH9FYGuLDZTaFj
L9JnwJDkQP3qDhcu/qE8izNngOb9f6wrtNzYVNwzKPn9DGRW0wdlq3PjwtTZ
fsOSGXj7dj75fjU3vvmszKG7dQbc/7PeCyniwe/VLVKqdmfANWi7layJD0sK
cyvCrxlgdfMJLljkw1U0U6PVf2bAVMUnIYqcH3f1Gh+vIZoFkooXP9Yv8eNv
xjee11HOgoj/sQC2Hn6s6Kzt1XxyFsxV5fijVwRwV7yiQc+FWdB8bn/M4d+Q
bzza/35VfRYCDilInXEQwjOmlS96NWZh7hlPg0CsEP7GJ9vZpz0LxGLpmSML
Qpg179yFQcNZSPXy1EMhp7FFnbDkmMMsxC3saxlNncHfV9mOLcTOQvSfyurq
KlEcnbTYlBg3C1cSeA2Ed0TxWa0i72uJs+Dba6GwfUoMOxVc3iSkzoKDcKxW
aJQYXvfw6Uj4MAvbhfsyZFLieJ5sIVSndhYUL759acTyH+7n/EjxeX0WbHOM
XEpIzmLX7kc1Ll9noWzVipOT9yxmeHrJ8/TOLLQX5B1UKZ/FOguzSy9/zkJW
VEznG7+zuP0Dc7Mz6RzEUcUJsVFJ4gYZL39B1jlgr1jX2eE9h4uvqZFGq8xB
xQHTeWlfaRyoUeZ3Qm3uX56oz0t8K42NlIXI36jPASiyvVJol8YkZ49Sl1yZ
g2Ep+nNnWc/jK/SdzEMGc/D6v3TWn4Xn8VLX9dMn7Ofg8OFdHcXvMpjtirVO
Rswc8PSx3Q95J4/XVQd7hV/NQd3fN5Pcg/KYoHDxenH8HBS0OFYSkSlga5HT
NxuT5+DGykZynLkCLqTasFp6NwdU97/2qJxUxJqtbh7CVXOgxb/rsvwGsPdF
v+SihTlQuGK/v+qBcY/JHSPx5TnYE+YrEozGmM9Ng/XD6hzkS0gNh+dh3JJK
9yL96xwI6fPen1jAmPFPkn/U7zkgcmrTe6avhLNySuwdaeahfu1QrChWxl30
S3LCUv+wa7XhjrQq5hFq/fn2/Dy8PnqX/PANVewGucW8cvMQwUckp/lAFbPd
dRVjR/NA13DB0fWzKrZqIOKlvDQPkgbpRAoXLuCf91kpl4zngTGsKeCHuRrm
Hr80lO43D5WVc99c6tVxcK1cnl7gPMiiNzcov6rj7bfC/kdC5kG94/q9FfZL
uNaZRtIuYh56B6JTglwvYSvynnCJhHmYiKHa0BHSwFlnb6jV5M+DSKXPy4ep
mlg0+HbJxOg8vFWxvb/WqYVj7xmERUzMw8Mpd99xEm38V1fdSml6HrRvRKhs
c2jjLs4z9JkL89DH0OzwRlcbOxVv2NtvzUNSV9+sbL02Lppy4987vABFc9uX
7nzQwbLSz6JZJRZAV3nLjjX9Gh6wYJVKklyAFz5nuBhrr2GX57mDXNILEJKv
nAvT1/CH+SE2QfkF2A14GXqaSxefjBZJlbqwAFG86mP6KbqYZGsg55rhAjws
fFJ0PVsPt2YLNYX5LoBDuais2KI+vjNQdYfObwHOn/p5MEtlgA+R6FLGBCyA
acST830SBljxxuPLiaELYDF1/ckdbwOcf6S3Nzt2Afre83Tast/A0VZeU03Z
C3B41sftjKkhNjrZ+Yu4dwFWe2lorVmMMQ2rc3FF/wI88pOMFrpkjGsYmJzc
hhZA1LBcVMnLGAtQ3FxaGl8A29LMFddpY7y5szDQubQAPgGkGV/zTLDvl4PC
pIMFiOOZ/zIjaoazXEUdZE4vgp+SzlwykQU2vNcttCO8CF9Li+ttOC0wta3r
/AexRXDuTLt4R9ECO5uWG3GdWwT6W0nphx5ZYLlLFzSOoEUwuJSSXr9ngTs4
TQT79RZhe1mpuvCwFf7eEjbj+GQRlCS5uv9esMZjR/vv7D1dBNoIg5YIW2tc
q3liM8B/ESKN4gMMn1vjiI7sP69DFmFnm+9T3IA1Pt3TxNgeswi1OOpQt81t
bDJMrCaUvQjray/83BLu4MZFt/fTPYuQJkTJelHUDn8Q/Pyfff8iSPLMBH+4
YYdf2Bwq+zm4CFck1hSu+9lhs9WoetrxRWie0Od5OG6Hf2/kjSssLkJX4VuB
45F3sdjuMm38n0XwcNzz3iNzwK8Ombhe5VsClmlu+tloR3xgefxct8AS/BXm
FBnIdcRWdV3ftYSWwCxwaHqr2RGL+yrfvyy6BPcKtpkz9h1x81/BBxfPLwH3
8Jfy33ec8I/fO96KmkugE5Qdnq3mjK9vBYWcdl36l/+XDX8IuOJKbWXNd+5L
YPjUNd7ngivmyd+jEvRcArsRiv/krF3xhsO95/yPl2BFPOSVaqYr9lvTjeQK
XIJ6WdKpUkE3XLTI+ZI5cQmYtU+YGUi7Y4aJ4jSS+iUYI0sj7XvkgZ9TPXpU
2rgE6QWSRDZvPTClnIrB3S9LIHvTPEql2wOTvOqhHuhYgtz0YP1ufk+8rbPp
8W74Hx+59fFKjyfuahDU0t5cgpqjnytUZR7i0JyEP0lsy2BQun2/XOkxJh+z
GLjKsQzP3e45sLk/xs8oT388wrUMLz8nxnW/e4wf3i6zduJfhhom+kk1em9s
y93frSK+DDZuv6KtFr3xxRiarFXVZah2uVvm3O2DyR490ZVxWoZQhyucnz76
4qKttV/VLssgV9gnf73TF1tZGyRfcF8Gv7oazLPui+u1xFauPfz3fuT2mYtC
T/EznnFvB79lOJ66Xt6b/hQfaj7/Pj1uGRR6DEAk7RkmYfhKTFO7DN+d2RU4
G/1xQcDNt9H1y/CKnsZPYsUfW+w1arI3LYP0Y/6vj2kCcO180kvBtmWI5VaL
r9cPwL5lGiLKA8vw7ZK3GvV6ACY2eWvgsbIMv0iz/1vgCcJE70zyZuhXwFpw
e8+6KgQ3rg06JDOtgIIAazXFRggOFdcRNWJZgSDh5osHHKH4eJlyTj/HCpBa
y81PPA7Fok2C75sFVyBb9NtQmEoYNprfzsxVXIHAB1uhPFPP8SfugNcPbFfA
06nllYhoJH58i8hE2n4FVO9VH87RiMQq7zw5vt1bgQ2PcBZTm0jcJX430d5t
Bd5Q0D4zehOJ//3EeDOfFTAyDeNu5IzCzCbssRdiV4D9j0Rm+skX2Dk+L4y+
dgXi7xvy86jF4NK9+IDa+hVI2Mm//tc2Bu+Z+D9xblqBMHuTXyzhMTiA19it
p20FnkmPniYdisGJHyiNowZX4JTBdmjV3VjcUHVLmH59BfyOXyUTTXuJWWbZ
W+lYVsGXn1bmD8RjY9UjDTVsqyB9+0OUzN14nPZ2u8qJYxWu3v7kVfsqHgvf
/VLQzbMKrade/Srejsf4u3t8pMgqtFGhoP+yE7DtkR4bOuVV6BdSNV8/lYQ/
nwkkp3NYhR/sO9Un/kvBUn3H26McV6HEpN4m4lIKzvd6G8nosgpefxMZha1S
cFp7IxuLxyrs/FS1GXuZggPvkYlw+q7C0rT5EUHiVHy10FdHJHYVjCy6TmeM
puJF2Ufx6lX/+rXvVqcpSMdms1SmrYRVaKSpKyPtTscjIYm8l+tWgazTuUvo
azpuG6v4oN28ClUHd4UpxDJwwePfVfo9q1BYPkPHkZeBvWrvz95aWAX9U7JE
k2VvMN0lZ2FfmjXQ0JDioPv+FqfU0B6VpVuDm/nMJUscWVhcJmd5i2EN/ivX
2iBTy8JXBJcyzVnXoM/1MgtDfBYOPmzCjfnWgO97uLef8jt8qE6dmUh2DWKW
XuRKZWTjXTluose31iB+5FSafkoO9iusmjh3Zw1ajH+cHu7JwYxnjD6v267B
j1qptnyyXHyW7eUDY8c1CJMnz7C6m4sdf1J9l3+4Bn9aub9tKOTh5aKfy38i
1sCvYXCcwjMfj4l09XpWrgHN85MUT3QKcPIq3SPS6n/6zCe+ZjoUYIt31wTC
ataAsuuz9J+QArzMN+iR0rgGXMYhx8SbCvAu+wRHU9cazDC4He+FQkxHuXab
cX4NSrROemPZInxh4cheLvU6ECvOBW/plWCKDPU354+tg/F0ZstDzxLcZh5y
pZZ+HRxfR8YqJpXga+M0qf3H1+FHk5bcvfkSbNbHdGGPex3EUkgL/T1K8cNa
3gh1qXXwsqahn3pXhvNfA9+cyTo0vj71clmuAu882Dlibr4OIh3SKlbWFVhK
/+3quOU6oOUUCe7IClxBS1s4eGcdRKvvO1kuVuBGnwnc6rwOP+P91hhfVuJR
i0emBf7rEPmDPTWItAofPlUR75O7Dr/NJWvngwhYnfTe4/38dYgN9Mr+mE7A
oZM8Fg8K1yHUbqnjzWcCpnsVLORatg5hLyKajmwT8AkKw7LbtetASeNk/8mo
Bkus/uy/MrAOZ3rMvKlka7FxnhQdx8E6vG3qqLrCXI9LDH/SdBFtQFL1SWat
8/WY5nA51VPSDSAaT/kdaFiPCUYK5MvkG9Cc5beVnVyPeShV/hYxbIBmmcDt
AuEGvGCls64ptAESfjlcglcbsQPb3S9euhsQ1k38+FV7M25sEGkS098ALT0G
negfzZjTabN+5sYGuEdySg5yf8FdTc6Ei6YbUEBNTyV5/wuWcPMsZbTdgBCN
V8b6/C34R6f/mw/eG7Ad2nCkILwV+/ilPhnL/sczpZ3XTunA1PePXDLP2YBK
pnWanK4OHH/Hnn4hbwNYqHyUrxN34kINmfTNog1gHHmZHW7ZiRfouutJqjcg
6PjxpX6mLqzxmohcqHcD2EsiHz6c78LMpabP3f5sQBqrOn9pRg9Oz2q4/nt/
A8xbRbpP1fZg8fgznN5Em5DuQvq7cbIHqz/6kRdItgluCrFLkey92Es5vDuB
dhOCaeyNLWJ68UxnFWMt7yb0jLVpikf14ZwljgQazU3wSLPvzS0YwIFJfmYT
VzYhJlnuavHIALa6us6fq7MJWXXct0hIB/GJysr8y/qbQGMyLeOsO4iDw282
hlr8098Rcy75PYjvSMVtUXpuwpFk7QQlvWHM84zx4pHMTUi5f5JJ4MIYPjjv
RT2YtQkfL/7NI/YYw8Prsz2Z7zfBz9/x3LnsMRyhX2h84eMmLKeJ2mfSjuO/
p6+6+FVugkTk/ebaiXE81h3+mrR3E46tuIc6Pp/EZf4/LHv7N4FhanKCqXES
R8uZCqUPbcIvg1htjoNJrPFGtEhpYhOeMMWlZ0tP4XKP9i9Plv/VW6QZKb6f
wrEi58J11jbhwue/bOnNU9hpJlGXe3MTXheQ5sotTGFBzbuThG+bsPD1LIGC
ZxofIu7LiPjxz8+L5iegaTxVLGdr9nsTLpttuL03mcaVtuli4vub8LO+7qXm
o2n8kvPo979/N6HYja+SN3Ea/w8EqqPM
       "]]},
     Annotation[#, "Charting`Private`Tag$1030523#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.736783333331696*^9, 3.736783441677238*^9}, {
   3.736783490057461*^9, 3.736783534555999*^9}, {3.736783611569186*^9, 
   3.736783614601206*^9}, 3.736789594697072*^9, 3.73678974894865*^9, 
   3.73679702883971*^9, 3.793998570200425*^9, 3.823228631363418*^9},
 CellLabel->
  "Out[2471]=",ExpressionUUID->"64da48ec-c412-4a10-ab06-2b4bf1ad4957"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"uopt3a", ",", 
   RowBox[{"{", 
    RowBox[{"\[Tau]", ",", "\[Infinity]", ",", "0"}], "}"}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.7367836237577457`*^9, 3.736783701586956*^9}},
 CellLabel->
  "In[2472]:=",ExpressionUUID->"8fc63ec1-f4ca-4e2f-a393-786b4a0accc7"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    InterpretationBox[
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "s", "+", 
         RowBox[{"s", " ", "\[Delta]"}]}], ")"}], " ", "\[Tau]"}], "+", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", "\[Delta]"}], ")"}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "\[Tau]"], "]"}], "2"],
       SeriesData[$CellContext`\[Tau], 
        DirectedInfinity[1], {}, -1, 2, 1],
       Editable->False]}],
     SeriesData[$CellContext`\[Tau], 
      DirectedInfinity[
      1], {-2 + $CellContext`s + $CellContext`s $CellContext`\[Delta], -1 - \
$CellContext`\[Delta]}, -1, 2, 1],
     Editable->False]], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Delta]"}], ")"}]}]]}], "+", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {-2}, -1, 2, 1],
         Editable->False]], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "+", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {(-2) (1 + $CellContext`\[Delta])}, -1, 2, 1],
         Editable->False]], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {(-2) (2 + $CellContext`\[Delta])}, -1, 2, 1],
         Editable->False]], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "+", 
      FractionBox["1", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         InterpretationBox[
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "-", "\[Delta]"}], ")"}], " ", "\[Tau]"}], 
           "+", 
           InterpretationBox[
            SuperscriptBox[
             RowBox[{"O", "[", 
              FractionBox["1", "\[Tau]"], "]"}], "2"],
            SeriesData[$CellContext`\[Tau], 
             DirectedInfinity[1], {}, -1, 2, 1],
            Editable->False]}],
          SeriesData[$CellContext`\[Tau], 
           DirectedInfinity[1], {-2 - $CellContext`\[Delta]}, -1, 2, 1],
          Editable->False]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]], "+", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {(-2) (2 + $CellContext`\[Delta])}, -1, 2, 1],
         Editable->False]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]]}], ")"}]}]], "-", 
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    InterpretationBox[
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"s", "+", 
         RowBox[{"s", " ", "\[Delta]"}]}], ")"}], " ", "\[Tau]"}], "+", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", "\[Delta]"}], ")"}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "\[Tau]"], "]"}], "2"],
       SeriesData[$CellContext`\[Tau], 
        DirectedInfinity[1], {}, -1, 2, 1],
       Editable->False]}],
     SeriesData[$CellContext`\[Tau], 
      DirectedInfinity[
      1], {$CellContext`s + $CellContext`s $CellContext`\[Delta], -1 - \
$CellContext`\[Delta]}, -1, 2, 1],
     Editable->False]], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Delta]"}], ")"}]}]]}], "+", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {-2}, -1, 2, 1],
         Editable->False]], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "+", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {(-2) (1 + $CellContext`\[Delta])}, -1, 2, 1],
         Editable->False]], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {(-2) (2 + $CellContext`\[Delta])}, -1, 2, 1],
         Editable->False]], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "+", 
      FractionBox["1", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         InterpretationBox[
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "-", "\[Delta]"}], ")"}], " ", "\[Tau]"}], 
           "+", 
           InterpretationBox[
            SuperscriptBox[
             RowBox[{"O", "[", 
              FractionBox["1", "\[Tau]"], "]"}], "2"],
            SeriesData[$CellContext`\[Tau], 
             DirectedInfinity[1], {}, -1, 2, 1],
            Editable->False]}],
          SeriesData[$CellContext`\[Tau], 
           DirectedInfinity[1], {-2 - $CellContext`\[Delta]}, -1, 2, 1],
          Editable->False]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]], "+", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {(-2) (2 + $CellContext`\[Delta])}, -1, 2, 1],
         Editable->False]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]]}], ")"}]}]], "+", 
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    InterpretationBox[
     RowBox[{
      RowBox[{"s", " ", "\[Tau]"}], "-", "1", "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "\[Tau]"], "]"}], "2"],
       SeriesData[$CellContext`\[Tau], 
        DirectedInfinity[1], {}, -1, 2, 1],
       Editable->False]}],
     SeriesData[$CellContext`\[Tau], 
      DirectedInfinity[1], {$CellContext`s, -1}, -1, 2, 1],
     Editable->False]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Delta]"}], ")"}]}]]}], "+", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {-2}, -1, 2, 1],
         Editable->False]], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "+", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {(-2) (1 + $CellContext`\[Delta])}, -1, 2, 1],
         Editable->False]], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {(-2) (2 + $CellContext`\[Delta])}, -1, 2, 1],
         Editable->False]], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "+", 
      FractionBox["1", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         InterpretationBox[
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "-", "\[Delta]"}], ")"}], " ", "\[Tau]"}], 
           "+", 
           InterpretationBox[
            SuperscriptBox[
             RowBox[{"O", "[", 
              FractionBox["1", "\[Tau]"], "]"}], "2"],
            SeriesData[$CellContext`\[Tau], 
             DirectedInfinity[1], {}, -1, 2, 1],
            Editable->False]}],
          SeriesData[$CellContext`\[Tau], 
           DirectedInfinity[1], {-2 - $CellContext`\[Delta]}, -1, 2, 1],
          Editable->False]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]], "+", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {(-2) (2 + $CellContext`\[Delta])}, -1, 2, 1],
         Editable->False]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]]}], ")"}]}]], "-", 
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    InterpretationBox[
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "s", "-", "\[Delta]"}], ")"}], " ", 
       "\[Tau]"}], "-", "1", "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "\[Tau]"], "]"}], "2"],
       SeriesData[$CellContext`\[Tau], 
        DirectedInfinity[1], {}, -1, 2, 1],
       Editable->False]}],
     SeriesData[$CellContext`\[Tau], 
      DirectedInfinity[
      1], {-2 + $CellContext`s - $CellContext`\[Delta], -1}, -1, 2, 1],
     Editable->False]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Delta]"}], ")"}]}]]}], "+", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {-2}, -1, 2, 1],
         Editable->False]], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "+", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {(-2) (1 + $CellContext`\[Delta])}, -1, 2, 1],
         Editable->False]], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {(-2) (2 + $CellContext`\[Delta])}, -1, 2, 1],
         Editable->False]], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Delta]"}], ")"}]}]], "+", 
      FractionBox["1", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         InterpretationBox[
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "-", "\[Delta]"}], ")"}], " ", "\[Tau]"}], 
           "+", 
           InterpretationBox[
            SuperscriptBox[
             RowBox[{"O", "[", 
              FractionBox["1", "\[Tau]"], "]"}], "2"],
            SeriesData[$CellContext`\[Tau], 
             DirectedInfinity[1], {}, -1, 2, 1],
            Editable->False]}],
          SeriesData[$CellContext`\[Tau], 
           DirectedInfinity[1], {-2 - $CellContext`\[Delta]}, -1, 2, 1],
          Editable->False]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]], "+", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        InterpretationBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "\[Delta]"}], ")"}], " ", "\[Tau]"}]}], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "\[Tau]"], "]"}], "2"],
           SeriesData[$CellContext`\[Tau], 
            DirectedInfinity[1], {}, -1, 2, 1],
           Editable->False]}],
         SeriesData[$CellContext`\[Tau], 
          DirectedInfinity[1], {(-2) (2 + $CellContext`\[Delta])}, -1, 2, 1],
         Editable->False]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Delta]"}], ")"}], "2"]]}], ")"}]}]]}]], "Output",\

 CellChangeTimes->{{3.736783651239092*^9, 3.736783702133638*^9}, 
   3.736789594898019*^9, 3.736789749062541*^9, 3.73679702895438*^9, 
   3.7939985702358913`*^9, 3.8232286313908854`*^9},
 CellLabel->
  "Out[2472]=",ExpressionUUID->"bd543dd1-94b0-4128-9977-fdc3b8c02735"]
}, Open  ]],

Cell["\<\
Export data (trajectories and input signals for different \[Delta] values)\
\>", "Text",
 CellChangeTimes->{{3.736635962686264*^9, 3.736635977575574*^9}, {
  3.736636024620076*^9, 3.736636029258498*^9}, {3.736639280394116*^9, 
  3.7366392980015287`*^9}, {3.736790106132189*^9, 3.736790116770254*^9}, {
  3.736790151382821*^9, 3.73679018496826*^9}, {3.7367902264710293`*^9, 
  3.7367902346062603`*^9}, {3.736795333180395*^9, 3.7367953657538233`*^9}, {
  3.7939985274418993`*^9, 3.79399853072237*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"70ac82cc-4648-4d31-b637-f6a9d8f60009"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datx1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"xs3", "/.", 
        RowBox[{"\[Delta]", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"t", "\[Rule]", 
        RowBox[{"Range", "[", 
         RowBox[{"0", ",", "1", ",", "\[CapitalDelta]t"}], "]"}]}]}], ")"}], 
     "\[Transpose]"}], "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datu1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"uopt3", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "1"}]}], "/.", 
     RowBox[{"t", "\[Rule]", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "1", ",", "\[CapitalDelta]t"}], "]"}]}]}], "//", 
    "N"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datx2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"xs3", "/.", 
        RowBox[{"\[Delta]", "\[Rule]", "0.5"}]}], "/.", 
       RowBox[{"t", "\[Rule]", 
        RowBox[{"Range", "[", 
         RowBox[{"0", ",", "1", ",", "\[CapitalDelta]t"}], "]"}]}]}], ")"}], 
     "\[Transpose]"}], "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"datu2", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"uopt3", "/.", 
       RowBox[{"\[Delta]", "\[Rule]", "0.5"}]}], "/.", 
      RowBox[{"t", "\[Rule]", 
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "1", ",", "\[CapitalDelta]t"}], "]"}]}]}], "//", 
     "N"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"alldata", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"datx1", ",", 
     RowBox[{
      RowBox[{"{", "datu1", "}"}], "\[Transpose]"}], ",", "datx2", ",", 
     RowBox[{
      RowBox[{"{", "datu2", "}"}], "\[Transpose]"}], ",", "2"}], "]"}]}], 
  "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"concatenates", " ", "columns"}], " ", "*)"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<nearlyIdentical.dat\>\"", ",", "alldata"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.736795495938047*^9, 3.7367955246609592`*^9}, {
   3.736795685614304*^9, 3.73679573827812*^9}, {3.736795779550981*^9, 
   3.7367958509134407`*^9}, {3.736795918348468*^9, 3.736796023466804*^9}, 
   3.736796708116514*^9, {3.736796945142881*^9, 3.736796991902248*^9}, {
   3.73679705000462*^9, 3.736797059120751*^9}, {3.7367971326817837`*^9, 
   3.736797133493928*^9}, {3.7367985881021557`*^9, 3.736798590320608*^9}, {
   3.793998540421083*^9, 3.793998549498577*^9}},
 CellLabel->
  "In[2473]:=",ExpressionUUID->"c30f1e5a-98a2-47e9-a815-cc6f62f1db6a"]
}, Open  ]]
},
WindowSize->{808, 755},
WindowMargins->{{Automatic, 165}, {Automatic, 31}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"9faf7108-2b4e-4266-bd7a-13a7a883d60c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[422, 15, 474, 9, 105, "Section",ExpressionUUID->"e7c05409-7c1b-4a25-9441-bed3f14f65ef"],
Cell[899, 26, 217, 5, 30, "Input",ExpressionUUID->"3c5cba3b-1bf4-4240-a5c8-686484243826"],
Cell[1119, 33, 974, 28, 68, "Text",ExpressionUUID->"9a52bbaa-a057-451e-95de-ca26e6797a33"],
Cell[CellGroupData[{
Cell[2118, 65, 1470, 43, 90, "Input",ExpressionUUID->"3955d148-5ec0-4dd6-90b3-0ffcad072ff4"],
Cell[3591, 110, 3174, 81, 79, "Output",ExpressionUUID->"9a4ad028-c4d6-40ab-b207-ba498de6d4af"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6802, 196, 938, 27, 73, "Input",ExpressionUUID->"12794fc9-a506-4ab5-a92a-5b66661fadff"],
Cell[7743, 225, 1286, 23, 34, "Output",ExpressionUUID->"fa4ab00d-7702-4565-97ed-6a5a20cb91bc"]
}, Open  ]],
Cell[9044, 251, 1296, 32, 73, "Input",ExpressionUUID->"3f6fb48c-f8bd-43cf-8551-a9280629daf1"],
Cell[10343, 285, 372, 8, 51, "Text",ExpressionUUID->"87c24437-99be-41be-b6d6-cdfc8723ffe8"],
Cell[CellGroupData[{
Cell[10740, 297, 1603, 46, 152, "Input",ExpressionUUID->"68285cd9-6d0f-4b8c-9065-0f02be64d65e"],
Cell[12346, 345, 1790, 50, 65, "Output",ExpressionUUID->"99cee9f4-a576-4a16-920f-2786cd49e700"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14173, 400, 513, 14, 30, "Input",ExpressionUUID->"263e1397-c194-4f7c-a275-85c5e08884c7"],
Cell[14689, 416, 1208, 34, 57, "Output",ExpressionUUID->"eba65c23-3683-4c70-a10a-9fb9de09a0c2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15934, 455, 1331, 30, 73, "Input",ExpressionUUID->"44aed752-0384-4324-8983-6164a3974bc5"],
Cell[17268, 487, 6163, 158, 97, "Output",ExpressionUUID->"ea82b614-f4b3-4585-961e-0f6e39c3ebf3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23468, 650, 874, 22, 73, "Input",ExpressionUUID->"96d4b1e2-4f64-41d2-bb9e-a37f6917637d"],
Cell[24345, 674, 1471, 35, 62, "Output",ExpressionUUID->"f1005084-d657-4a20-8593-9c3e3c16c0e2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25853, 714, 1671, 43, 73, "Input",ExpressionUUID->"b200dd06-01b7-4a56-8d43-ae8fc85495d1"],
Cell[27527, 759, 3070, 81, 115, "Output",ExpressionUUID->"6cd4b93e-0941-4425-94ba-67e5b7c0e7fd"]
}, Open  ]],
Cell[30612, 843, 1285, 36, 96, "Input",ExpressionUUID->"fa82c85f-2c51-46a0-aac7-3e3d2fb83d47"],
Cell[CellGroupData[{
Cell[31922, 883, 334, 7, 30, "Input",ExpressionUUID->"1a4a95e4-ecc2-4082-93d9-d2dbd349f70a"],
Cell[32259, 892, 37551, 689, 134, "Output",ExpressionUUID->"f901ed94-016b-4523-9aad-2de17eb3287e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69847, 1586, 595, 17, 33, "Input",ExpressionUUID->"cce57bee-d6d8-4538-ac08-c915453af349"],
Cell[70445, 1605, 741, 14, 34, "Output",ExpressionUUID->"8f609c2c-0a40-42bf-8ce5-14af15520f4c"]
}, Open  ]],
Cell[71201, 1622, 987, 23, 75, "Text",ExpressionUUID->"9e6060e6-2d8d-43e2-aeab-dd9a797e08d9"],
Cell[CellGroupData[{
Cell[72213, 1649, 1125, 26, 73, "Input",ExpressionUUID->"c214128f-5fab-424a-ae3e-4529147f29f2"],
Cell[73341, 1677, 10079, 276, 248, "Output",ExpressionUUID->"f4aa3a2b-637b-48ed-9013-250e6c075269"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83457, 1958, 422, 9, 30, "Input",ExpressionUUID->"089162d5-3a0f-4c63-9826-d650521ab98c"],
Cell[83882, 1969, 1773, 52, 68, "Output",ExpressionUUID->"2b36b485-3909-49d7-bbc0-a194109cdc24"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85692, 2026, 535, 11, 30, "Input",ExpressionUUID->"2d4fd36c-83da-4f76-8fec-7cf5fc47f88d"],
Cell[86230, 2039, 1610, 39, 51, "Output",ExpressionUUID->"690f318c-0c2d-4c1d-ab57-f8c6f92fa866"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87877, 2083, 355, 9, 30, "Input",ExpressionUUID->"1532d0be-ab79-4e12-a162-04cbb9fcc86f"],
Cell[88235, 2094, 708, 19, 53, "Output",ExpressionUUID->"cd49942d-c06c-4622-80ab-4428d77b36cc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88980, 2118, 371, 10, 30, "Input",ExpressionUUID->"7854be32-74ab-4994-a709-cdc51cc2b13c"],
Cell[89354, 2130, 1419, 42, 76, "Output",ExpressionUUID->"8551464a-f5f6-47c8-9c5d-4860bd39f25d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90810, 2177, 805, 21, 52, "Input",ExpressionUUID->"a992dc23-2863-4c8e-90df-919ea8f0d18e"],
Cell[91618, 2200, 2285, 59, 59, "Output",ExpressionUUID->"809e9790-e3df-4c44-9bdc-17b5c1927b9b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93940, 2264, 1256, 37, 52, "Input",ExpressionUUID->"f4a7bc70-d4a4-4af2-9d0a-31e11afbac78"],
Cell[95199, 2303, 5514, 150, 135, "Output",ExpressionUUID->"033f06bb-9efc-4b83-a9c4-8d3df3a93770"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100750, 2458, 1413, 33, 73, "Input",ExpressionUUID->"248c928b-dc36-4aa6-9612-37cf880ae8fc"],
Cell[102166, 2493, 17105, 303, 232, "Output",ExpressionUUID->"2bf44355-4e5d-45ed-864b-d529aedfecb2"]
}, Open  ]],
Cell[119286, 2799, 468, 12, 33, "Input",ExpressionUUID->"b44f1dda-8b53-426f-aca2-9234466c6787"],
Cell[CellGroupData[{
Cell[119779, 2815, 440, 11, 30, "Input",ExpressionUUID->"1bfa103b-5cfb-4acf-8d36-9f77ad4d4f7d"],
Cell[120222, 2828, 1074, 26, 62, "Output",ExpressionUUID->"56b1101a-8e1c-4de1-8ee6-86e5db28b2aa"]
}, Open  ]],
Cell[121311, 2857, 470, 12, 33, "Input",ExpressionUUID->"a5bf6b1a-ebbc-4e73-8b43-300f116aeb83"],
Cell[CellGroupData[{
Cell[121806, 2873, 970, 23, 52, "Input",ExpressionUUID->"a009439e-3fac-40aa-b8fe-88abfa6e204d"],
Cell[122779, 2898, 20238, 471, 234, "Output",ExpressionUUID->"3a8c9f45-cdf7-463a-9e87-496a28800196"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143054, 3374, 502, 10, 30, "Input",ExpressionUUID->"7fc70490-752a-47c0-ac10-017c0c4d2f2b"],
Cell[143559, 3386, 10926, 281, 240, "Output",ExpressionUUID->"1b5012c5-6426-4a7e-9cce-a85c3283e9c4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[154522, 3672, 442, 10, 30, "Input",ExpressionUUID->"4c8374f6-03ec-46c0-9453-c61ec7093a6f"],
Cell[154967, 3684, 23067, 452, 233, "Output",ExpressionUUID->"ddb28cc4-bf46-4556-bf48-d32df3673ff2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[178071, 4141, 744, 18, 51, "Input",ExpressionUUID->"149e76f9-fc63-4308-9a5b-eb98168975fd"],
Cell[178818, 4161, 1174, 30, 60, "Output",ExpressionUUID->"fd19719c-2d6c-4c24-b41c-7035fa2cb08e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[180029, 4196, 305, 7, 30, "Input",ExpressionUUID->"5fcc635c-5862-4059-a244-4368dda5131a"],
Cell[180337, 4205, 811, 21, 55, "Output",ExpressionUUID->"a21af705-3a4c-4e48-9ec4-03a37459c017"]
}, Open  ]],
Cell[CellGroupData[{
Cell[181185, 4231, 742, 20, 52, "Input",ExpressionUUID->"c1910de7-7fc6-4239-a1f6-2f4569e9d50b"],
Cell[181930, 4253, 2451, 80, 96, "Output",ExpressionUUID->"882d7f3f-a421-45c6-80bb-a06600d95f67"]
}, Open  ]],
Cell[184396, 4336, 569, 10, 74, "Text",ExpressionUUID->"49fe9587-0a42-4eb8-a7a1-94e728732850"],
Cell[CellGroupData[{
Cell[184990, 4350, 549, 14, 30, "Input",ExpressionUUID->"dc9954a5-b0a0-4059-bbc8-cd2a5ce0f72f"],
Cell[185542, 4366, 15620, 276, 224, "Output",ExpressionUUID->"64da48ec-c412-4a10-ab06-2b4bf1ad4957"]
}, Open  ]],
Cell[CellGroupData[{
Cell[201199, 4647, 315, 8, 30, "Input",ExpressionUUID->"8fc63ec1-f4ca-4e2f-a393-786b4a0accc7"],
Cell[201517, 4657, 19850, 561, 368, "Output",ExpressionUUID->"bd543dd1-94b0-4128-9977-fdc3b8c02735"]
}, Open  ]],
Cell[221382, 5221, 597, 10, 51, "Text",ExpressionUUID->"70ac82cc-4648-4d31-b637-f6a9d8f60009"],
Cell[221982, 5233, 2864, 77, 296, "Input",ExpressionUUID->"c30f1e5a-98a2-47e9-a815-cc6f62f1db6a"]
}, Open  ]]
}
]
*)

