(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     22374,        583]
NotebookOptionsPosition[     20553,        542]
NotebookOutlinePosition[     20951,        558]
CellTagsIndexPosition[     20908,        555]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Coupled oscillators (convert to network representation)
Figure 14.3\
\>", "Section",
 CellChangeTimes->{{3.735423238101478*^9, 3.7354232503075657`*^9}, {
  3.793996886167095*^9, 
  3.793996888168591*^9}},ExpressionUUID->"c20c623c-b1f5-480e-9e93-\
ea1e94f1b325"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[2410]:=",ExpressionUUID->"63c88a6c-9ac3-49a9-a059-08faeb84012b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
       RowBox[{"x", "[", "t", "]"}], "-", 
       RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{"u", "[", "t", "]"}]}], ",", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "t", "]"}], "+", 
       RowBox[{"y", "[", "t", "]"}], "-", 
       RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sys", "=", 
  RowBox[{"StateSpaceModel", "[", 
   RowBox[{"eqs", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], ",", 
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], ",", 
      RowBox[{"y", "[", "t", "]"}], ",", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}]}], "}"}], ",", 
    RowBox[{"u", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], ",", 
      RowBox[{"y", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.7354238661625137`*^9, 3.735423897639634*^9}, {
  3.735423944589387*^9, 3.7354239725645227`*^9}, {3.7354240314097548`*^9, 
  3.73542405901536*^9}, {3.7354241226549473`*^9, 3.735424165452479*^9}, {
  3.7354242840371733`*^9, 3.735424299382709*^9}, {3.735424357910475*^9, 
  3.735424384858223*^9}, {3.7354244407222443`*^9, 3.735424513252927*^9}, {
  3.7354247025031757`*^9, 3.735424742577635*^9}, {3.736821272760907*^9, 
  3.736821296832756*^9}},
 CellLabel->
  "In[2411]:=",ExpressionUUID->"57315401-07de-4777-91d3-a51f0819d0d0"],

Cell[BoxData[
 TemplateBox[{"0", "1", "0", "0", "0", 
   RowBox[{"-", "1"}], "0", "1", "0", "1", "0", "0", "0", "1", "0", "1", "0", 
   
   RowBox[{"-", "1"}], "0", "0", "1", "0", "0", "0", "0", "0", "0", "1", "0", 
   "0", 
   InterpretationBox["\[InvisibleSpace]", None], {
   StateSpaceModel, {
    False, False, {
     False, False}}, {$CellContext`stname1, $CellContext`stname2, \
$CellContext`stname3, $CellContext`stname4}, {{Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$, 
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, Identity, 
    Automatic, 1, 2, 4, 1, {}, {False, False}, False, Automatic, None, {",", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{
             RowBox[{"x", "[", "t", "]"}], ",", "0"}], "}"}], ",", 
         SubscriptBox["\[FormalX]", "1"], ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{"y", "[", "t", "]"}], ",", "0"}], "}"}], ",", 
         SubscriptBox["\[FormalX]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{
           RowBox[{"u", "[", "t", "]"}], ",", "0"}], "}"}], "}"}], ",", 
     "Automatic", ",", "t"}}, {}},
  "StateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{#, #2, #3, #4, #5}, {#6, #7, #8, #9, #10}, {#11, #12, #13, \
#14, #15}, {#16, #17, #18, #19, #20}, {#21, #22, #23, #24, #25}, {#26, #27, \
#28, #29, #30}}, AllowedDimensions -> {5, 6}, 
        GridBoxDividers -> {"Rows" -> {False, False, False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}, 
          "Columns" -> {False, False, False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
        "SystemsModelGrid00"], ")"}], #31, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalS]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None], MultilineFunction -> None], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{1, 4}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{6, 9}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{11, 14}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{16, 19}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{5, 5}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{10, 10}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{15, 15}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{20, 20}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{21, 24}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{26, 29}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{25, 25}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{30, 30}, ","], "}"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{
             RowBox[{"x", "[", "t", "]"}], ",", "0"}], "}"}], ",", 
         SubscriptBox["\[FormalX]", "1"], ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{"y", "[", "t", "]"}], ",", "0"}], "}"}], ",", 
         SubscriptBox["\[FormalX]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{
           RowBox[{"u", "[", "t", "]"}], ",", "0"}], "}"}], "}"}], ",", 
     "Automatic", ",", "t", ",", "SamplingPeriod", "->", 
     RowBox[{#31}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
  Tooltip->StateSpaceModel]], "Output",
 CellChangeTimes->{
  3.735424167063643*^9, {3.735424290366235*^9, 3.73542430011339*^9}, 
   3.735424385426179*^9, 3.7354245273518963`*^9, {3.735424703477859*^9, 
   3.735424743365301*^9}, 3.735424853568569*^9, 3.735439677172881*^9, 
   3.735571821562828*^9, 3.735571952214645*^9, 3.73557198724131*^9, 
   3.735572100928887*^9, 3.73557320262851*^9, {3.736821250340275*^9, 
   3.736821301540598*^9}, 3.793996925900511*^9, 3.823228569283059*^9},
 CellLabel->
  "Out[2412]=",ExpressionUUID->"e4fcc095-615f-469e-bda5-5e6e09d474db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "=", 
   RowBox[{"Normal", "[", "sys", "]"}]}], ";", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "a", "]"}], ",", 
    RowBox[{"MatrixForm", "[", "b", "]"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.735424745769981*^9, 3.735424785055559*^9}},
 CellLabel->
  "In[2413]:=",ExpressionUUID->"b2e55f5d-28ee-48e6-9f75-e1e49f319ce8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0", "0"},
       {
        RowBox[{"-", "1"}], "0", "1", "0"},
       {"0", "0", "0", "1"},
       {"1", "0", 
        RowBox[{"-", "1"}], "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0"},
       {"1"},
       {"0"},
       {"0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{{3.7354247667329187`*^9, 3.735424785900683*^9}, 
   3.735424853779304*^9, 3.735439677350328*^9, 3.735571821682686*^9, 
   3.735571954428916*^9, 3.73557198735808*^9, 3.735572101057246*^9, 
   3.735573202708028*^9, {3.73682125045372*^9, 3.736821301642411*^9}, 
   3.793996925953519*^9, 3.8232285693397417`*^9},
 CellLabel->
  "Out[2413]=",ExpressionUUID->"4213ba0d-b365-4123-ad27-82bdd4e255cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Wc", "=", 
   RowBox[{"ControllabilityMatrix", "[", "sys", "]"}]}], ";", " ", 
  RowBox[{"MatrixForm", "[", "Wc", "]"}]}]], "Input",
 CellLabel->
  "In[2414]:=",ExpressionUUID->"c945567f-cbb5-4a45-9f7f-f6e50218f368"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "1", "0", 
      RowBox[{"-", "1"}]},
     {"1", "0", 
      RowBox[{"-", "1"}], "0"},
     {"0", "0", "0", "1"},
     {"0", "0", "1", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.735424815695963*^9, 3.735424853882861*^9, 3.735439677447648*^9, 
   3.73557182175572*^9, 3.7355719560078297`*^9, 3.735571987459711*^9, 
   3.7355721011430283`*^9, 3.735573202781323*^9, {3.7368212505537653`*^9, 
   3.7368213017446203`*^9}, 3.793996925961125*^9, 3.8232285693468447`*^9},
 CellLabel->
  "Out[2414]//MatrixForm=",ExpressionUUID->"21f4aae9-cc20-4e0d-ae66-\
886e3762180b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixRank", "[", "Wc", "]"}]], "Input",
 CellLabel->
  "In[2415]:=",ExpressionUUID->"e173ef23-e7a1-42b7-97fa-93455991bd7f"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.735424823865714*^9, 3.735424854004181*^9, 3.7354396775512*^9, 
   3.7355718218165483`*^9, {3.73557195881698*^9, 3.73557198757688*^9}, 
   3.735572101226016*^9, 3.7355732028593283`*^9, {3.736821250670978*^9, 
   3.73682130184311*^9}, 3.7939969259896173`*^9, 3.823228569368719*^9},
 CellLabel->
  "Out[2415]=",ExpressionUUID->"9253adad-afc7-42c2-8f5f-b4ad6793a4ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeightedAdjacencyGraph", "[", 
  RowBox[{
   RowBox[{"a", "/.", " ", 
    RowBox[{"0", "\[Rule]", "\[Infinity]"}]}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{"\"\<Name\>\"", ",", "Center"}], "]"}]}], ",", 
   RowBox[{"VertexStyle", "\[Rule]", "White"}], ",", 
   RowBox[{"VertexSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Scaled\>\"", ",", " ", "0.08"}], "}"}]}], ",", 
   RowBox[{"VertexLabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"FontFamily", "\[Rule]", "\"\<Gill Sans\>\""}], ",", "20"}], 
     "]"}]}], ",", 
   RowBox[{"EdgeStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", 
      RowBox[{"Thickness", "[", "0.005", "]"}], ",", 
      RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], ",", 
   RowBox[{"EdgeLabels", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{"\"\<EdgeWeight\>\"", ",", "0.4"}], "]"}]}], ",", 
   RowBox[{"EdgeLabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"FontFamily", "\[Rule]", "\"\<Gill Sans\>\""}], ",", "20"}], 
     "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQAWIQvcV1wduDV147LhW2egei5yzx+guiuxpy/oFoD/9J
IoeAtBfXX0kQve+WycrjQNoq9+taEH38U9FmEP3H9f0OEL0+e/Z+EC3EvP0w
iPb0vnkSRPcs1DkNolUjN18E0W08ry+B6EBvu/sguqYh7SXYnIiityD6aDLT
OxBtcafpJ9g8z8l/QXTOfiHuE0D6ettBML2t3VIQRO+ZrCkBotdc3uwKoj9/
2uMDom8flJkKouU+lc4A0fduCO7nvPrakYPV6gCIduPqvwOiX4ftANOzGZZ8
B9En/Dr+gGiNzmhOLpA6l3ABEP2ev00ERJeuXy8KogGi2byu
  "],
 CellLabel->
  "In[2416]:=",ExpressionUUID->"cbff56f6-7c3c-4391-939d-2fe8f0b17358"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4}, {
       SparseArray[
       Automatic, {4, 4}, 0, {
        1, {{0, 1, 3, 4, 6}, {{2}, {1}, {3}, {4}, {1}, {3}}}, Pattern}], 
       Null}, {EdgeLabels -> {
         Placed["EdgeWeight", 0.4]}, EdgeLabelStyle -> {
         Directive[FontFamily -> "Gill Sans", 20]}, EdgeStyle -> {
         Directive[
          GrayLevel[0], 
          Thickness[0.005], Background -> GrayLevel[1]]}, VertexLabels -> {
         Placed["Name", Center]}, VertexLabelStyle -> {
         Directive[FontFamily -> "Gill Sans", 20]}, 
       VertexSize -> {{"Scaled", 0.08}}, VertexStyle -> {
         GrayLevel[1]}, EdgeWeight -> {1, -1, 1, 1, 1, -1}}]]}, 
    TagBox[GraphicsGroupBox[{
       {GrayLevel[0], Thickness[0.005], Opacity[0.7], Arrowheads[Medium], 
        StyleBox[{{
           ArrowBox[BezierCurveBox[{{1.0286636775007163`, 
            0.026067351856662202`}, {
            0.5332554444959297, -0.1513066860396886}, {0.029274141858347813`, 
            0.}}], 0.058109544148274794`], InsetBox[
            StyleBox["1",
             StripOnInput->False,
             FontFamily->"Gill Sans",
             FontSize->20], 
            Offset[{0, 2}, {0.6327282313778424, -0.05426480320228276}], 
            ImageScaled[{0.5, 0}],
            BaseStyle->"Graphics"]}, {
           ArrowBox[BezierCurveBox[{{0.029274141858347813`, 0.}, {
            0.5246823748631362, 0.1773740378963512}, {1.0286636775007163`, 
            0.026067351856662202`}}], 0.058109544148274794`], InsetBox[
            StyleBox[
             RowBox[{"-", "1"}],
             StripOnInput->False,
             FontFamily->"Gill Sans",
             FontSize->20], 
            Offset[{0, 2}, {0.42520958798122166, 0.08033215505894495}], 
            ImageScaled[{0.5, 0}],
            BaseStyle->"Graphics"]}, {
           ArrowBox[{{0.029274141858347813`, 0.}, {0., 0.9993812388986762}}, 
            0.058109544148274794`], InsetBox[
            StyleBox["1",
             StripOnInput->False,
             FontFamily->"Gill Sans",
             FontSize->20], 
            Offset[{0, 2}, {0.017564485115008688, 0.3997524955594705}], 
            ImageScaled[{0.5, 0}],
            BaseStyle->"Graphics"]}, {
           ArrowBox[BezierCurveBox[{{0., 0.9993812388986762}, {
            0.4956203717559754, 1.177029166442884}, {0.9999349716074293, 
            1.0258169862557787`}}], 0.058109544148274794`], InsetBox[
            StyleBox["1",
             StripOnInput->False,
             FontFamily->"Gill Sans",
             FontSize->20], 
            Offset[{0, 2}, {0.39612674365777534, 1.079898197036499}], 
            ImageScaled[{0.5, 0}],
            BaseStyle->"Graphics"]}, {
           ArrowBox[{{0.9999349716074293, 1.0258169862557787`}, {
            1.0286636775007163`, 0.026067351856662202`}}, 
            0.058109544148274794`], InsetBox[
            StyleBox["1",
             StripOnInput->False,
             FontFamily->"Gill Sans",
             FontSize->20], 
            Offset[{0, 2}, {1.0114264539647442, 0.6259171324961321}], 
            ImageScaled[{0.5, 0}],
            BaseStyle->"Graphics"]}, {
           ArrowBox[BezierCurveBox[{{0.9999349716074293, 
            1.0258169862557787`}, {0.5043145998514572, 0.8481690587115733}, {
            0., 0.9993812388986762}}], 0.058109544148274794`], InsetBox[
            StyleBox[
             RowBox[{"-", "1"}],
             StripOnInput->False,
             FontFamily->"Gill Sans",
             FontSize->20], 
            Offset[{0, 2}, {0.603808227949654, 0.9453000281179562}], 
            ImageScaled[{0.5, 0}],
            BaseStyle->"Graphics"]}},
         Background->GrayLevel[1]]}, 
       {GrayLevel[1], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.0286636775007163, 0.026067351856662202}, 
          0.058109544148274794], InsetBox[
          StyleBox["1",
           StripOnInput->False,
           FontFamily->"Gill Sans",
           FontSize->20], {1.0286636775007163, 0.026067351856662202},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.029274141858347813, 0.}, 0.058109544148274794], InsetBox[
          StyleBox["2",
           StripOnInput->False,
           FontFamily->"Gill Sans",
           FontSize->20], {0.029274141858347813, 0.},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.9993812388986762}, 0.058109544148274794], InsetBox[
          StyleBox["3",
           StripOnInput->False,
           FontFamily->"Gill Sans",
           FontSize->20], {0., 0.9993812388986762},
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9999349716074293, 1.0258169862557787}, 
          0.058109544148274794], InsetBox[
          StyleBox["4",
           StripOnInput->False,
           FontFamily->"Gill Sans",
           FontSize->20], {0.9999349716074293, 1.0258169862557787},
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.7355725720037746`*^9, 3.735572611103097*^9}, {
   3.735572647727364*^9, 3.735572654018515*^9}, 3.735573202940263*^9, {
   3.7368212508970346`*^9, 3.736821301954154*^9}, 3.7939969260291843`*^9, 
   3.823228569398728*^9},
 CellLabel->
  "Out[2416]=",ExpressionUUID->"4c94d1d5-02b8-46db-b5e4-7a233db159f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigenvalues", "[", "a", "]"}], "//", "MatrixForm", "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "\"\<breather\>\"", " ", "mode", " ", "and", " ", "free", " ", 
    "translation"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.735438826113607*^9, 3.735438865452523*^9}},
 CellLabel->
  "In[2417]:=",ExpressionUUID->"187593ae-a5f5-4b2b-9455-1571faa07d2c"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["2"]}]},
      {
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SqrtBox["2"]}]},
      {"0"},
      {"0"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.7354388302296953`*^9, 3.735438838099299*^9}, 
   3.735439677750916*^9, 3.7355718220356617`*^9, {3.735571974881921*^9, 
   3.735571987771367*^9}, 3.7355721013692617`*^9, {3.735573203027742*^9, 
   3.735573208332087*^9}, {3.7368212510705423`*^9, 3.736821302039722*^9}, 
   3.793996926036195*^9, 3.823228569404591*^9},
 CellLabel->
  "Out[2417]//MatrixForm=",ExpressionUUID->"575a4b89-7774-4d87-be59-\
6d67d2fcddf6"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 755},
WindowMargins->{{Automatic, 302}, {Automatic, 19}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"2336695d-f1de-4f60-95a1-b33143568a40"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 271, 7, 105, "Section",ExpressionUUID->"c20c623c-b1f5-480e-9e93-ea1e94f1b325"],
Cell[854, 31, 175, 4, 30, "Input",ExpressionUUID->"63c88a6c-9ac3-49a9-a059-08faeb84012b"],
Cell[CellGroupData[{
Cell[1054, 39, 1638, 43, 52, "Input",ExpressionUUID->"57315401-07de-4777-91d3-a51f0819d0d0"],
Cell[2695, 84, 5032, 116, 124, "Output",ExpressionUUID->"e4fcc095-615f-469e-bda5-5e6e09d474db"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7764, 205, 457, 12, 30, "Input",ExpressionUUID->"b2e55f5d-28ee-48e6-9f75-e1e49f319ce8"],
Cell[8224, 219, 1597, 45, 83, "Output",ExpressionUUID->"4213ba0d-b365-4123-ad27-82bdd4e255cf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9858, 269, 251, 6, 30, "Input",ExpressionUUID->"c945567f-cbb5-4a45-9f7f-f6e50218f368"],
Cell[10112, 277, 1008, 27, 94, "Output",ExpressionUUID->"21f4aae9-cc20-4e0d-ae66-886e3762180b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11157, 309, 148, 3, 30, "Input",ExpressionUUID->"e173ef23-e7a1-42b7-97fa-93455991bd7f"],
Cell[11308, 314, 416, 7, 34, "Output",ExpressionUUID->"9253adad-afc7-42c2-8f5f-b4ad6793a4ee"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11761, 326, 1654, 39, 136, "Input",ExpressionUUID->"cbff56f6-7c3c-4391-939d-2fe8f0b17358"],
Cell[13418, 367, 5554, 123, 432, "Output",ExpressionUUID->"4c94d1d5-02b8-46db-b5e4-7a233db159f1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19009, 495, 389, 9, 30, "Input",ExpressionUUID->"187593ae-a5f5-4b2b-9455-1571faa07d2c"],
Cell[19401, 506, 1124, 32, 125, "Output",ExpressionUUID->"575a4b89-7774-4d87-be59-6d67d2fcddf6"]
}, Open  ]]
}, Open  ]]
}
]
*)

