(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    653490,      16590]
NotebookOptionsPosition[    649828,      16531]
NotebookOutlinePosition[    650245,      16548]
CellTagsIndexPosition[    650202,      16545]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Graph models:  Regular, Random, Scale free  (Figure 14.1)
\[Dash] and others that are interspersed through the Chapter\
\>", "Section",
 CellChangeTimes->{{3.734206057003047*^9, 3.734206067364386*^9}, {
  3.793997341407127*^9, 3.7939973446586523`*^9}, {3.793997786960458*^9, 
  3.793997817196122*^9}},ExpressionUUID->"b24abee5-c2c4-4677-8c83-\
866d54acc2e1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.73445676065604*^9, 3.734456763826931*^9}, 
   3.793997358655115*^9},
 CellLabel->
  "In[2388]:=",ExpressionUUID->"c20d3319-9871-498a-98b3-44e991d006fa"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nVert", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gReg", "=", 
   RowBox[{"CycleGraph", "[", 
    RowBox[{"nVert", ",", 
     RowBox[{"VertexStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"White", ",", 
        RowBox[{"EdgeForm", "[", 
         RowBox[{"Thickness", "[", "0.005", "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"VertexSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Scaled\>\"", ",", " ", "0.05"}], "}"}]}], ",", 
     RowBox[{"EdgeStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.008", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.73422188590875*^9, 3.734221904145253*^9}, {
   3.734222211090214*^9, 3.7342226066040382`*^9}, {3.73422348613265*^9, 
   3.7342234923755217`*^9}, {3.7342242724310427`*^9, 3.73422427943854*^9}, {
   3.734224319080385*^9, 3.734224329929285*^9}, {3.7342243680975723`*^9, 
   3.734224416216395*^9}, {3.734224525067691*^9, 3.734224570234474*^9}, {
   3.734224650311879*^9, 3.734224729753463*^9}, {3.734224778872864*^9, 
   3.734224931133329*^9}, {3.734225888520906*^9, 3.734225936396044*^9}, {
   3.734226004249063*^9, 3.734226004335189*^9}, {3.7347498059576597`*^9, 
   3.734749810381949*^9}, {3.7347521309060802`*^9, 3.7347521311590757`*^9}, 
   3.793997644468462*^9},
 CellLabel->
  "In[2389]:=",ExpressionUUID->"c9a21f3a-cee3-4ab1-abc2-2c8057244c60"],

Cell["Grid graph", "Text",
 CellChangeTimes->{{3.734224949751999*^9, 3.734224982178135*^9}, {
  3.7344508161680307`*^9, 3.7344508166286907`*^9}, {3.734455891191058*^9, 
  3.734455892021349*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"e03c51c6-5ebe-477f-ad94-b17a753ea37a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ggrid", "=", 
   RowBox[{"GridGraph", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}], ",", 
     RowBox[{"VertexStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"White", ",", 
        RowBox[{"EdgeForm", "[", 
         RowBox[{"Thickness", "[", "0.005", "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"VertexSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Scaled\>\"", ",", " ", "0.05"}], "}"}]}], ",", 
     RowBox[{"EdgeStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.008", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.734455893919176*^9, 3.734455924475655*^9}, {
   3.734456606020763*^9, 3.734456629686903*^9}, {3.7344566749051533`*^9, 
   3.734456725011508*^9}, {3.734456782076922*^9, 3.734456783377637*^9}, {
   3.734457167159442*^9, 3.734457175660798*^9}, {3.7344572212709713`*^9, 
   3.734457259762656*^9}, 3.7939977723587303`*^9},
 CellLabel->
  "In[2391]:=",ExpressionUUID->"f9b5cd8b-f2b1-49ba-917d-e8f3a4608b31"],

Cell["Star graph", "Text",
 CellChangeTimes->{{3.734224949751999*^9, 3.734224982178135*^9}, {
  3.7344508161680307`*^9, 3.7344508166286907`*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"7311873a-6430-4be4-8088-c95e78c5f25b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gstar", "=", 
   RowBox[{"StarGraph", "[", 
    RowBox[{"nVert", ",", 
     RowBox[{"VertexStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"White", ",", 
        RowBox[{"EdgeForm", "[", 
         RowBox[{"Thickness", "[", "0.005", "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"VertexSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Scaled\>\"", ",", " ", "0.05"}], "}"}]}], ",", 
     RowBox[{"EdgeStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.008", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.734450868487864*^9, 3.734450870063352*^9}, {
   3.734450904319895*^9, 3.734450952839801*^9}, {3.734454909964116*^9, 
   3.734454910742594*^9}, {3.7344553351533318`*^9, 3.73445534203124*^9}, {
   3.734749906643009*^9, 3.734749909030526*^9}, 3.793997649446528*^9},
 CellLabel->
  "In[2392]:=",ExpressionUUID->"1fed6702-9c64-4bd2-9ab1-e242ec6f12c5"],

Cell["Scale-free graph", "Text",
 CellChangeTimes->{{3.734224949751999*^9, 3.734224982178135*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"cbe864b6-9628-4cd1-9f68-26797ab3e519"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "123", "]"}], ";", 
  RowBox[{"gBA", "=", 
   RowBox[{"RandomGraph", "[", 
    RowBox[{
     RowBox[{"BarabasiAlbertGraphDistribution", "[", 
      RowBox[{"nVert", ",", "2"}], "]"}], ",", 
     RowBox[{"VertexStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"White", ",", 
        RowBox[{"EdgeForm", "[", 
         RowBox[{"Thickness", "[", "0.005", "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"VertexSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Scaled\>\"", ",", " ", "0.05"}], "}"}]}], ",", 
     RowBox[{"EdgeStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.008", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.734225058982128*^9, 3.734225064599496*^9}, {
   3.734750171829571*^9, 3.734750254466033*^9}, {3.734750321920417*^9, 
   3.734750323734466*^9}, {3.734750696109365*^9, 3.734750710343527*^9}, 
   3.79399765334632*^9},
 CellLabel->
  "In[2393]:=",ExpressionUUID->"50b32578-6858-4588-800c-f3de667baf62"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataSF", "=", 
   RowBox[{"Join", " ", "@@", 
    RowBox[{"(", " ", 
     RowBox[{"VertexDegree", " ", "/@", " ", 
      RowBox[{"RandomGraph", "[", 
       RowBox[{
        RowBox[{"BarabasiAlbertGraphDistribution", "[", 
         RowBox[{"nVert", ",", "2"}], "]"}], ",", "1000"}], "]"}]}], 
     ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pSF", "=", 
   RowBox[{"Histogram", "[", 
    RowBox[{"dataSF", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "nVert", ",", "1"}], "}"}], ",", "\"\<PDF\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.734225545742463*^9, 3.7342256213052197`*^9}, {
   3.734225712220449*^9, 3.734225726782894*^9}, {3.734225787734108*^9, 
   3.7342258151706047`*^9}, 3.734225856750431*^9, {3.734225952384516*^9, 
   3.734225955019322*^9}, {3.734791059068616*^9, 3.734791118022332*^9}, {
   3.73479125026328*^9, 3.73479125891336*^9}, {3.7939978609944677`*^9, 
   3.793997869350347*^9}},
 CellLabel->
  "In[2394]:=",ExpressionUUID->"6e0ffe8a-5c25-4893-9e39-757820cddd61"],

Cell["Repeat for large graph to show power-law behavior", "Text",
 CellChangeTimes->{{3.734224949751999*^9, 3.734224959043346*^9}, {
  3.734791213172261*^9, 3.7347912218183603`*^9}, {3.793998098907679*^9, 
  3.79399809916654*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"ace36d7d-b68b-42ba-9fa9-e82f47426eff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dataSF1", "=", 
   RowBox[{"Join", " ", "@@", 
    RowBox[{"(", " ", 
     RowBox[{"VertexDegree", " ", "/@", " ", 
      RowBox[{"RandomGraph", "[", 
       RowBox[{
        RowBox[{"BarabasiAlbertGraphDistribution", "[", 
         RowBox[{"10000", ",", "2"}], "]"}], ",", "100"}], "]"}]}], ")"}]}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.734791226618874*^9, 3.734791231324399*^9}, {
  3.734791442778564*^9, 3.7347914439593287`*^9}, {3.734791551488358*^9, 
  3.734791559236601*^9}, {3.7347915931196823`*^9, 3.734791600627359*^9}, {
  3.7347916306923447`*^9, 3.734791635027603*^9}, {3.734791672953546*^9, 
  3.7347917455879908`*^9}},
 CellLabel->
  "In[2396]:=",ExpressionUUID->"4a27ec38-3adc-4fde-aa26-68044fce5a11"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pSF1", "=", 
   RowBox[{"Histogram", "[", 
    RowBox[{"dataSF1", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3000", ",", "1"}], "}"}], ",", "\"\<PDF\>\"", ",", 
     RowBox[{"ScalingFunctions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\""}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"pSF1", ",", 
   RowBox[{"LogLogPlot", "[", 
    RowBox[{
     RowBox[{"100", 
      SuperscriptBox["k", 
       RowBox[{"-", "3"}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "2", ",", "600"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], "]"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.734791770050641*^9, 3.7347917978538227`*^9}, {
   3.793997865456596*^9, 3.793997915585512*^9}, {3.79399795853547*^9, 
   3.7939979613044252`*^9}, {3.7939980122280817`*^9, 3.793998012929727*^9}, 
   3.8232285375912733`*^9},
 CellLabel->
  "In[2397]:=",ExpressionUUID->"22c5fb62-467a-4c77-86dc-9317bcf7dc12"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
     Opacity[0.623], Thickness[Small]}], {}, 
     {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
      Opacity[0.623], Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{0.6931471805599453, -14.815510557964274`}, {
             1.0986122886681098`, -0.6924134498062021}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{58.89820694958197, 
            75.62499669270389}, {-65.834903123935, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.500367]& ,
         TagBoxNote->"0.500367"],
        StyleBox["0.500367`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.500367, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{1.0986122886681098`, -14.815510557964274`}, {
             1.3862943611198906`, -1.6102682570748148`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{75.12499669270389, 
            87.13808723783487}, {-55.68100999822421, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.19983399999999998`]& ,
         TagBoxNote->"0.19983399999999998"],
        StyleBox["0.19983399999999998`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.19983399999999998`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{1.3862943611198906`, -14.815510557964274`}, {
             1.6094379124341003`, -2.304587095664719}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{86.63808723783487, 
            96.06833405143561}, {-48.000013803205874`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.09979999999999997]& ,
         TagBoxNote->"0.09979999999999997"],
        StyleBox["0.09979999999999997`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.09979999999999997, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{1.6094379124341003`, -14.815510557964274`}, {
             1.791759469228055, -2.8624959244505277`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{95.56833405143561, 
            103.36487698095681`}, {-41.8280718179157, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.057126]& ,
         TagBoxNote->"0.057126"],
        StyleBox["0.057126`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.057126, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{1.791759469228055, -14.815510557964274`}, {
             1.9459101490553132`, -3.336055917331369}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{102.86487698095681`, 
            109.53401612584457`}, {-36.58925025458622, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.035577000000000004`]& ,
         TagBoxNote->"0.035577000000000004"],
        StyleBox["0.035577000000000004`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.035577000000000004`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{1.9459101490553132`, -14.815510557964274`}, {
             2.0794415416798357`, -3.7377756239017654`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{109.03401612584457`, 
            114.87796752608776`}, {-32.145171589087695`, 90.90377156037643}}],
          
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.023807]& ,
         TagBoxNote->"0.023807"],
        StyleBox["0.023807`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.023807, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{2.0794415416798357`, -14.815510557964274`}, {
             2.1972245773362196`, -4.090731098652265}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{114.37796752608776`, 
            119.59166672407872`}, {-28.24055384304559, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.01672700000000001]& ,
         TagBoxNote->"0.01672700000000001"],
        StyleBox["0.01672700000000001`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.01672700000000001, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{2.1972245773362196`, -14.815510557964274`}, {
             2.302585092994046, -4.420102403526111}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{119.09166672407872`, 
            123.80821433968853`}, {-24.596839170659294`, 90.90377156037643}}],
          
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.012033000000000004`]& ,
         TagBoxNote->"0.012033000000000004"],
        StyleBox["0.012033000000000004`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.012033000000000004`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{2.302585092994046, -14.815510557964274`}, {
             2.3978952727983707`, -4.721479308388474}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{123.30821433968853`, 
            127.62254562772466`}, {-21.26281634014599, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.008902000000000002]& ,
         TagBoxNote->"0.008902000000000002"],
        StyleBox["0.008902000000000002`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.008902000000000002, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{2.3978952727983707`, -14.815510557964274`}, {
             2.4849066497880004`, -4.94991655906155}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{127.12254562772466`, 
            131.1047572692097}, {-18.735698313528943`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.007084]& ,
         TagBoxNote->"0.007084"],
        StyleBox["0.007084`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.007084, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{2.4849066497880004`, -14.815510557964274`}, {
             2.5649493574615367`, -5.190719355950018}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{130.6047572692097, 
            134.3080814564593}, {-16.071784757033086`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.005568000000000001]& ,
         TagBoxNote->"0.005568000000000001"],
        StyleBox["0.005568000000000001`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.005568000000000001, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{2.5649493574615367`, -14.815510557964274`}, {
             2.6390573296152584`, -5.4117100539031275`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{133.8080814564593, 
            137.27389641409746`}, {-13.627045228490843`, 90.90377156037643}}],
          
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.004463999999999998]& ,
         TagBoxNote->"0.004463999999999998"],
        StyleBox["0.004463999999999998`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.004463999999999998, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{2.6390573296152584`, -14.815510557964274`}, {
             2.70805020110221, -5.637433094114667}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{136.77389641409746`, 
            140.03500408281045`}, {-11.129953522735107`, 90.90377156037643}}],
          
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.003562000000000001]& ,
         TagBoxNote->"0.003562000000000001"],
        StyleBox["0.003562000000000001`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.003562000000000001, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{2.70805020110221, -14.815510557964274`}, {
             2.772588722239781, -5.841321888678262}, "RoundingRadius" -> 0]},
           ImageSizeCache->{{139.53500408281045`, 
            142.61784781434068`}, {-8.87440611683381, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.0029050000000000005`]& ,
         TagBoxNote->"0.0029050000000000005"],
        StyleBox["0.0029050000000000005`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.0029050000000000005`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{2.772588722239781, -14.815510557964274`}, {
             2.833213344056216, -6.0372990834517815`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{142.11784781434068`, 
            145.04405656029556`}, {-6.706381855209429, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.002388]& ,
         TagBoxNote->"0.002388"],
        StyleBox["0.002388`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.002388, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{2.833213344056216, -14.815510557964274`}, {
             2.8903717578961645`, -6.1997194859284415`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{144.54405656029556`, 
            147.3315470123316}, {-4.9095841535220615`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.0020299999999999993`]& ,
         TagBoxNote->"0.0020299999999999993"],
        StyleBox["0.0020299999999999993`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.0020299999999999993`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{2.8903717578961645`, -14.815510557964274`}, {
             2.9444389791664403`, -6.354445043609991}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{146.8315470123316, 
            149.49532735742994`}, {-3.1979117146210854`, 90.90377156037643}}],
          
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.0017389999999999997`]& ,
         TagBoxNote->"0.0017389999999999997"],
        StyleBox["0.0017389999999999997`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.0017389999999999997`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{2.9444389791664403`, -14.815510557964274`}, {
             2.995732273553991, -6.520454141501644}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{148.99532735742994`, 
            151.54809462794142`}, {-1.3614135838288206`, 90.90377156037643}}],
          
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.0014729999999999995`]& ,
         TagBoxNote->"0.0014729999999999995"],
        StyleBox["0.0014729999999999995`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.0014729999999999995`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{2.995732273553991, -14.815510557964274`}, {
             3.044522437723423, -6.654664651299975}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{151.04809462794142`, 153.5006861572194}, {
            0.12330835917082084`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.001288]& ,
         TagBoxNote->"0.001288"],
        StyleBox["0.001288`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.001288, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.044522437723423, -14.815510557964274`}, {
             3.091042453358316, -6.762789508731951}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{153.0006861572194, 155.36242591597758`}, {
            1.3194542396550588`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.001156]& ,
         TagBoxNote->"0.001156"],
        StyleBox["0.001156`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.001156, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.091042453358316, -14.815510557964274`}, {
             3.1354942159291497`, -6.9361547535038355`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{154.86242591597758`, 157.14139379884574`}, {
            3.2373307416748673`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.0009719999999999996]& ,
         TagBoxNote->"0.0009719999999999996"],
        StyleBox["0.0009719999999999996`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.0009719999999999996, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.1354942159291497`, -14.815510557964274`}, {
             3.1780538303479458`, -7.034452932028095}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{156.64139379884574`, 158.84463755746262`}, {
            4.3247676557523675`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000881]& ,
         TagBoxNote->"0.000881"],
        StyleBox["0.000881`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000881, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.1780538303479458`, -14.815510557964274`}, {
             3.2188758248682006`, -7.078543599962418}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{158.34463755746262`, 160.47834144154217`}, {
            4.8125266417063415`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.0008430000000000003]& ,
         TagBoxNote->"0.0008430000000000003"],
        StyleBox["0.0008430000000000003`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.0008430000000000003, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.2188758248682006`, -14.815510557964274`}, {
             3.258096538021482, -7.291948251814762}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{159.97834144154217`, 162.04796174471218`}, {
            7.1733445077548055`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.0006810000000000001]& ,
         TagBoxNote->"0.0006810000000000001"],
        StyleBox["0.0006810000000000001`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.0006810000000000001, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.258096538021482, -14.815510557964274`}, {
             3.295836866004329, -7.402051600796917}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{161.54796174471218`, 163.55833675545355`}, {
            8.391377718992828, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00061]& ,
         TagBoxNote->"0.00061"],
        StyleBox["0.00061`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00061, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.295836866004329, -14.815510557964274`}, {
             3.332204510175204, -7.491151595582963}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{163.05833675545355`, 165.01377670235036`}, {
            9.377058479603733, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.0005580000000000002]& ,
         TagBoxNote->"0.0005580000000000002"],
        StyleBox["0.0005580000000000002`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.0005580000000000002, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.332204510175204, -14.815510557964274`}, {
             3.367295829986474, -7.635493904311701}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{164.51377670235036`, 166.41813790877563`}, {
            10.973864820588602`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00048300000000000003`]& ,
         TagBoxNote->"0.00048300000000000003"],
        StyleBox["0.00048300000000000003`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00048300000000000003`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.367295829986474, -14.815510557964274`}, {
             3.4011973816621555`, -7.660652463947856}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{165.91813790877563`, 167.77488437106337`}, {
            11.25218479420461, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.0004710000000000002]& ,
         TagBoxNote->"0.0004710000000000002"],
        StyleBox["0.0004710000000000002`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.0004710000000000002, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.4011973816621555`, -14.815510557964274`}, {
             3.4339872044851463`, -7.88592141457438}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{167.27488437106337`, 169.0871392359652}, {
            13.744253072421245`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00037599999999999987`]& ,
         TagBoxNote->"0.00037599999999999987"],
        StyleBox["0.00037599999999999987`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00037599999999999987`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.4339872044851463`, -14.815510557964274`}, {
             3.4657359027997265`, -7.8806163623446865`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{168.5871392359652, 170.35772810259357`}, {
            13.68556521357904, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00037799999999999997`]& ,
         TagBoxNote->"0.00037799999999999997"],
        StyleBox["0.00037799999999999997`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00037799999999999997`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.4657359027997265`, -14.815510557964274`}, {
             3.4965075614664802`, -8.001380026139207}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{169.85772810259357`, 171.5892156590995}, {
            15.02152960133212, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00033500000000000007`]& ,
         TagBoxNote->"0.00033500000000000007"],
        StyleBox["0.00033500000000000007`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00033500000000000007`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.4965075614664802`, -14.815510557964274`}, {
             3.5263605246161616`, -7.977780110798334}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{171.0892156590995, 172.78393684854848`}, {
            14.760452341345697`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000343]& ,
         TagBoxNote->"0.000343"],
        StyleBox["0.000343`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000343, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.5263605246161616`, -14.815510557964274`}, {
             3.5553480614894135`, -8.180720954795024}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{172.28393684854848`, 173.9440235159511}, {
            17.00551291570393, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00028000000000000003`]& ,
         TagBoxNote->"0.00028000000000000003"],
        StyleBox["0.00028000000000000003`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00028000000000000003`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.5553480614894135`, -14.815510557964274`}, {
             3.58351893845611, -8.298057661499566}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{173.4440235159511, 175.07142730058453`}, {
            18.30356612647948, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00024900000000000004`]& ,
         TagBoxNote->"0.00024900000000000004"],
        StyleBox["0.00024900000000000004`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00024900000000000004`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.58351893845611, -14.815510557964274`}, {
             3.6109179126442243`, -8.377431249041079}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{174.57142730058453`, 176.1679393911123}, {
            19.181647189539063`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00022999999999999995`]& ,
         TagBoxNote->"0.00022999999999999995"],
        StyleBox["0.00022999999999999995`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00022999999999999995`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.6109179126442243`, -14.815510557964274`}, {
             3.6375861597263857`, -8.377431249041079}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{175.6679393911123, 177.23520764568286`}, {
            19.181647189539063`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00022999999999999995`]& ,
         TagBoxNote->"0.00022999999999999995"],
        StyleBox["0.00022999999999999995`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00022999999999999995`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.6375861597263857`, -14.815510557964274`}, {
             3.6635616461296463`, -8.552820369059388}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{176.73520764568286`, 178.2747514878341}, {
            21.121913085599445`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.0001930000000000001]& ,
         TagBoxNote->"0.0001930000000000001"],
        StyleBox["0.0001930000000000001`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.0001930000000000001, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.6635616461296463`, -14.815510557964274`}, {
             3.6888794541139363`, -8.537395898733758}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{177.7747514878341, 179.28797491619434`}, {
            20.951277793430293`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00019599999999999983`]& ,
         TagBoxNote->"0.00019599999999999983"],
        StyleBox["0.00019599999999999983`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00019599999999999983`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.6888794541139363`, -14.815510557964274`}, {
             3.713572066704308, -8.622553707074063}, "RoundingRadius" -> 0]},
           ImageSizeCache->{{178.78797491619434`, 180.27617790752407`}, {
            21.893347582529486`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.0001800000000000001]& ,
         TagBoxNote->"0.0001800000000000001"],
        StyleBox["0.0001800000000000001`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.0001800000000000001, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.713572066704308, -14.815510557964274`}, {
             3.7376696182833684`, -8.804875263868018}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{179.77617790752407`, 181.2405664454723}, {
            23.910304499395366`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00015000000000000004`]& ,
         TagBoxNote->"0.00015000000000000004"],
        StyleBox["0.00015000000000000004`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00015000000000000004`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.7376696182833684`, -14.815510557964274`}, {
             3.7612001156935624`, -8.617013526698448}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{180.7405664454723, 182.18226136913125`}, {
            21.832058586725722`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00018099999999999998`]& ,
         TagBoxNote->"0.00018099999999999998"],
        StyleBox["0.00018099999999999998`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00018099999999999998`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.7612001156935624`, -14.815510557964274`}, {
             3.784189633918261, -8.785072636571838}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{181.68226136913125`, 183.10230620423047`}, {
            23.69123525273308, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00015300000000000003`]& ,
         TagBoxNote->"0.00015300000000000003"],
        StyleBox["0.00015300000000000003`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00015300000000000003`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.784189633918261, -14.815510557964274`}, {
             3.8066624897703196`, -8.910235779525845}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{182.60230620423047`, 184.00167411418528`}, {
            25.075869474582404`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00013499999999999997`]& ,
         TagBoxNote->"0.00013499999999999997"],
        StyleBox["0.00013499999999999997`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00013499999999999997`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.8066624897703196`, -14.815510557964274`}, {
             3.828641396489095, -8.940313234763122}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{183.50167411418528`, 184.88127408709866`}, {
            25.40860539703347, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000131]& ,
         TagBoxNote->"0.000131"],
        StyleBox["0.000131`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000131, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.828641396489095, -14.815510557964274`}, {
             3.8501476017100584`, -8.902855672228222}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{184.38127408709866`, 185.74195645733087`}, {
            24.994226037992107`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000136]& ,
         TagBoxNote->"0.000136"],
        StyleBox["0.000136`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000136, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{3.8501476017100584`, -14.815510557964274`}, {
             3.871201010907891, -9.190537744680004}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{185.24195645733087`, 186.5845178457155}, {
            28.17674793004504, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00010199999999999992`]& ,
         TagBoxNote->"0.00010199999999999992"],
        StyleBox["0.00010199999999999992`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00010199999999999992`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.871201010907891, -14.815510557964274`}, {
             3.8918202981106265`, -9.152071463852208}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{186.0845178457155, 187.40970559036006`}, {
            27.751209488261054`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00010599999999999993`]& ,
         TagBoxNote->"0.00010599999999999993"],
        StyleBox["0.00010599999999999993`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00010599999999999993`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.8918202981106265`, -14.815510557964274`}, {
             3.912023005428146, -9.171119658822901}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{186.90970559036006`, 188.2182217297951}, {
            27.96193272513736, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00010400000000000003`]& ,
         TagBoxNote->"0.00010400000000000003"],
        StyleBox["0.00010400000000000003`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00010400000000000003`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.912023005428146, -14.815510557964274`}, {
             3.9318256327243257`, -9.433483923290392}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{187.7182217297951, 189.0107265916704}, {
            30.864372937153377`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00008]& ,
         TagBoxNote->"0.00008"],
        StyleBox["0.00008`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00008, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.9318256327243257`, -14.815510557964274`}, {
             3.9512437185814275`, -9.293721980915233}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{188.5107265916704, 189.7878420329651}, {
            29.318237519349978`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00009200000000000005]& ,
         TagBoxNote->"0.00009200000000000005"],
        StyleBox["0.00009200000000000005`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00009200000000000005, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.9512437185814275`, -14.815510557964274`}, {
             3.970291913552122, -9.396669950167675}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{189.2878420329651, 190.55015437154736`}, {
            30.457113373156275`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00008300000000000007]& ,
         TagBoxNote->"0.00008300000000000007"],
        StyleBox["0.00008300000000000007`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00008300000000000007, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.970291913552122, -14.815510557964274`}, {
             3.9889840465642745`, -9.498022444427964}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{190.05015437154736`, 191.29821704370647`}, {
            31.57833906876023, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00007500000000000001]& ,
         TagBoxNote->"0.00007500000000000001"],
        StyleBox["0.00007500000000000001`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00007500000000000001, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{3.9889840465642745`, -14.815510557964274`}, {
             4.007333185232471, -9.484777217677943}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{190.79821704370647`, 192.03255301783122`}, {
            31.431811953817345`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00007600000000000003]& ,
         TagBoxNote->"0.00007600000000000003"],
        StyleBox["0.00007600000000000003`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00007600000000000003, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.007333185232471, -14.815510557964274`}, {
             4.02535169073515, -9.484777217677943}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{191.53255301783122`, 192.75365699060328`}, {
            31.431811953817345`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00007600000000000003]& ,
         TagBoxNote->"0.00007600000000000003"],
        StyleBox["0.00007600000000000003`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00007600000000000003, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{4.02535169073515, -14.815510557964274`}, {
             4.04305126783455, -9.433483923290392}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{192.25365699060328`, 193.46199738880478`}, {
            30.864372937153377`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00008]& ,
         TagBoxNote->"0.00008"],
        StyleBox["0.00008`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00008, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.04305126783455, -14.815510557964274`}, {
             4.060443010546419, -9.721165995742174}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{192.96199738880478`, 194.15801819702853`}, {
            34.046894829206295`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00005999999999999996]& ,
         TagBoxNote->"0.00005999999999999996"],
        StyleBox["0.00005999999999999996`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00005999999999999996, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.060443010546419, -14.815510557964274`}, {
             4.07753744390572, -9.737973114058555}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{193.65801819702853`, 194.84214062914955`}, {
            34.232825852048094`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00005899999999999999]& ,
         TagBoxNote->"0.00005899999999999999"],
        StyleBox["0.00005899999999999999`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00005899999999999999, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.07753744390572, -14.815510557964274`}, {
             4.0943445622221, -9.672375831572742}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{194.34214062914955`, 195.51476465931626`}, {
            33.5071470296207, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00006299999999999997]& ,
         TagBoxNote->"0.00006299999999999997"],
        StyleBox["0.00006299999999999997`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00006299999999999997, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.0943445622221, -14.815510557964274`}, {
             4.110873864173311, -9.864266839382847}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{195.01476465931626`, 196.1762704263953}, {
            35.62996729450222, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00005200000000000001]& ,
         TagBoxNote->"0.00005200000000000001"],
        StyleBox["0.00005200000000000001`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00005200000000000001, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.110873864173311, -14.815510557964274`}, {
             4.127134385045092, -9.883684925239947}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{195.6762704263953, 196.82701952421812`}, {
            35.844782499409874`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00005100000000000005]& ,
         TagBoxNote->"0.00005100000000000005"],
        StyleBox["0.00005100000000000005`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00005100000000000005, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.127134385045092, -14.815510557964274`}, {
             4.143134726391533, -10.101938491259967`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{196.32701952421812`, 197.4673561885942}, {
            38.25924213520713, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00004099999999999999]& ,
         TagBoxNote->"0.00004099999999999999"],
        StyleBox["0.00004099999999999999`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00004099999999999999, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.143134726391533, -14.815510557964274`}, {
             4.1588830833596715`, -9.826526511399999}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{196.9673561885942, 198.09760839084646`}, {
            35.21245980439332, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00005400000000000003]& ,
         TagBoxNote->"0.00005400000000000003"],
        StyleBox["0.00005400000000000003`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00005400000000000003, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.1588830833596715`, -14.815510557964274`}, {
             4.174387269895637, -9.923690259853647}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{197.59760839084646`, 198.71808884656582`}, {
            36.28734693215999, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00004900000000000004]& ,
         TagBoxNote->"0.00004900000000000004"],
        StyleBox["0.00004900000000000004`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00004900000000000004, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.174387269895637, -14.815510557964274`}, {
             4.189654742026425, -10.101938491259967`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{198.21808884656582`, 199.32909594735239`}, {
            38.25924213520713, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00004099999999999999]& ,
         TagBoxNote->"0.00004099999999999999"],
        StyleBox["0.00004099999999999999`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00004099999999999999, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.189654742026425, -14.815510557964274`}, {
             4.204692619390966, -10.20459264532005}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{198.82909594735239`, 199.93091462249262`}, {
            39.3948676186517, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000037]& ,
         TagBoxNote->"0.000037"],
        StyleBox["0.000037`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000037, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.204692619390966, -14.815510557964274`}, {
             4.219507705176107, -9.845218644412153}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{199.43091462249262`, 200.52381713680137`}, {
            35.41924405762592, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00005299999999999996]& ,
         TagBoxNote->"0.00005299999999999996"],
        StyleBox["0.00005299999999999996`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00005299999999999996, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.219507705176107, -14.815510557964274`}, {
             4.23410650459726, -10.077840939680906`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{200.02381713680137`, 201.10806383022057`}, {
            37.99265970693264, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000042000000000000004`]& ,
         TagBoxNote->"0.000042000000000000004"],
        StyleBox["0.000042000000000000004`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000042000000000000004`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.23410650459726, -14.815510557964274`}, {
             4.248495242049359, -10.557414019942792`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{200.60806383022057`, 201.68390380420405`}, {
            43.298001863867086`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000026000000000000002`]& ,
         TagBoxNote->"0.000026000000000000002"],
        StyleBox["0.000026000000000000002`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000026000000000000002`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.248495242049359, -14.815510557964274`}, {
             4.2626798770413155`, -10.319002996497794`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{201.18390380420405`, 202.25157555941706`}, {
            40.66054762504717, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000033]& ,
         TagBoxNote->"0.000033"],
        StyleBox["0.000033`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000033, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.2626798770413155`, -14.815510557964274`}, {
             4.276666119016055, -10.557414019942792`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{201.75157555941706`, 202.81130758883742`}, {
            43.298001863867086`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000026000000000000002`]& ,
         TagBoxNote->"0.000026000000000000002"],
        StyleBox["0.000026000000000000002`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000026000000000000002`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.276666119016055, -14.815510557964274`}, {
             4.290459441148391, -10.20459264532005}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{202.31130758883742`, 203.36331892994858`}, {
            39.3948676186517, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000037]& ,
         TagBoxNote->"0.000037"],
        StyleBox["0.000037`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000037, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.290459441148391, -14.815510557964274`}, {
             4.30406509320417, -10.4482147279778}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{202.86331892994858`, 203.90781967936525`}, {
            42.08996990583289, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00002899999999999998]& ,
         TagBoxNote->"0.00002899999999999998"],
        StyleBox["0.00002899999999999998`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00002899999999999998, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.30406509320417, -14.815510557964274`}, {
             4.31748811353631, -10.48330604778907}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{203.40781967936525`, 204.445011472917}, {
            42.47817238424457, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000028000000000000023`]& ,
         TagBoxNote->"0.000028000000000000023"],
        StyleBox["0.000028000000000000023`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000028000000000000023`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.31748811353631, -14.815510557964274`}, {
             4.330733340286331, -10.319002996497794`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{203.945011472917, 204.97508793393575`}, {
            40.66054762504717, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000033]& ,
         TagBoxNote->"0.000033"],
        StyleBox["0.000033`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000033, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.330733340286331, -14.815510557964274`}, {
             4.343805421853684, -10.381523353479128`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{204.47508793393575`, 205.49823509224018`}, {
            41.3521875423222, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00003099999999999999]& ,
         TagBoxNote->"0.00003099999999999999"],
        StyleBox["0.00003099999999999999`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00003099999999999999, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.343805421853684, -14.815510557964274`}, {
             4.356708826689592, -10.519673691959945`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{204.99823509224018`, 206.01463177608701`}, {
            42.88049437375818, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000027000000000000013`]& ,
         TagBoxNote->"0.000027000000000000013"],
        StyleBox["0.000027000000000000013`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000027000000000000013`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.356708826689592, -14.815510557964274`}, {
             4.3694478524670215`, -10.871071578797833`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{205.51463177608701`, 206.52444997915524`}, {
            46.76788109254707, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000019000000000000004`]& ,
         TagBoxNote->"0.000019000000000000004"],
        StyleBox["0.000019000000000000004`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000019000000000000004`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.3694478524670215`, -14.815510557964274`}, {
             4.382026634673881, -10.724468104605958`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{206.02444997915524`, 207.02785520444723`}, {
            45.1460603023591, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000022000000000000016`]& ,
         TagBoxNote->"0.000022000000000000016"],
        StyleBox["0.000022000000000000016`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000022000000000000016`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.382026634673881, -14.815510557964274`}, {
             4.394449154672439, -10.982297213908058`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{206.52785520444723`, 207.52500678682838`}, {
            47.998329746086696`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000016999999999999993`]& ,
         TagBoxNote->"0.000016999999999999993"],
        StyleBox["0.000016999999999999993`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000016999999999999993`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.394449154672439, -14.815510557964274`}, {
             4.406719247264253, -10.724468104605958`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{207.02500678682838`, 208.016058195777}, {
            45.1460603023591, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000022000000000000016`]& ,
         TagBoxNote->"0.000022000000000000016"],
        StyleBox["0.000022000000000000016`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000022000000000000016`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.406719247264253, -14.815510557964274`}, {
             4.418840607796598, -10.4482147279778}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{207.516058195777, 208.50115731978462`}, {
            42.08996990583289, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00002899999999999998]& ,
         TagBoxNote->"0.00002899999999999998"],
        StyleBox["0.00002899999999999998`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00002899999999999998, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.418840607796598, -14.815510557964274`}, {
             4.430816798843313, -11.176453228349015`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{208.00115731978462`, 208.9804467337252}, {
            50.146206953609436`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00001400000000000001]& ,
         TagBoxNote->"0.00001400000000000001"],
        StyleBox["0.00001400000000000001`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00001400000000000001, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.430816798843313, -14.815510557964274`}, {
             4.442651256490317, -10.92513880006811}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{208.4804467337252, 209.45406395040214`}, {
            47.36600705107014, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00001799999999999999]& ,
         TagBoxNote->"0.00001799999999999999"],
        StyleBox["0.00001799999999999999`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00001799999999999999, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.442651256490317, -14.815510557964274`}, {
             4.454347296253507, -10.819778284410283`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{208.95406395040214`, 209.92214165738415`}, {
            46.20044207588309, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000019999999999999998`]& ,
         TagBoxNote->"0.000019999999999999998"],
        StyleBox["0.000019999999999999998`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000019999999999999998`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.454347296253507, -14.815510557964274`}, {
             4.465908118654584, -10.724468104605958`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{209.42214165738415`, 210.38480794015047`}, {
            45.1460603023591, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000022000000000000016`]& ,
         TagBoxNote->"0.000022000000000000016"],
        StyleBox["0.000022000000000000016`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000022000000000000016`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.465908118654584, -14.815510557964274`}, {
             4.477336814478207, -10.724468104605958`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{209.88480794015047`, 210.8421864924834}, {
            45.1460603023591, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000022000000000000016`]& ,
         TagBoxNote->"0.000022000000000000016"],
        StyleBox["0.000022000000000000016`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000022000000000000016`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.477336814478207, -14.815510557964274`}, {
             4.48863636973214, -11.330603908176274`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{210.3421864924834, 211.2943968149742}, {
            51.85151972838207, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000012]& ,
         TagBoxNote->"0.000012"],
        StyleBox["0.000012`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000012, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.48863636973214, -14.815510557964274`}, {
             4.499809670330265, -11.042921835724492`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{210.7943968149742, 211.7415544024382}, {
            48.668997836329154`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000016000000000000013`]& ,
         TagBoxNote->"0.000016000000000000013"],
        StyleBox["0.000016000000000000013`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000016000000000000013`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.499809670330265, -14.815510557964274`}, {
             4.51085950651685, -11.107460356862065`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{211.2415544024382, 212.18377092097475`}, {
            49.38296396793602, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000014999999999999987`]& ,
         TagBoxNote->"0.000014999999999999987"],
        StyleBox["0.000014999999999999987`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000014999999999999987`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.51085950651685, -14.815510557964274`}, {
             4.5217885770490405`, -11.618285980628055`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{211.68377092097475`, 212.62115437535155`}, {
            55.03404162043499, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 8.999999999999993*^-6]& ,
         TagBoxNote->"8.999999999999993*^-6"],
        StyleBox["8.999999999999993`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[8.999999999999993*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.5217885770490405`, -14.815510557964274`}, {
             4.532599493153256, -10.724468104605958`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{212.12115437535155`, 213.05380926734006`}, {
            45.1460603023591, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000022000000000000016`]& ,
         TagBoxNote->"0.000022000000000000016"],
        StyleBox["0.000022000000000000016`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000022000000000000016`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.532599493153256, -14.815510557964274`}, {
             4.543294782270004, -11.330603908176274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{212.55380926734006`, 213.4818367455838}, {
            51.85151972838207, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000012]& ,
         TagBoxNote->"0.000012"],
        StyleBox["0.000012`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000012, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.543294782270004, -14.815510557964274`}, {
             4.553876891600541, -10.819778284410283`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{212.9818367455838, 213.9053347475365}, {
            46.20044207588309, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000019999999999999998`]& ,
         TagBoxNote->"0.000019999999999999998"],
        StyleBox["0.000019999999999999998`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000019999999999999998`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.553876891600541, -14.815510557964274`}, {
             4.564348191467836, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{213.4053347475365, 214.3243981339684}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.564348191467836, -14.815510557964274`}, {
             4.574710978503383, -11.107460356862065`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{213.8243981339684, 214.73911881650295`}, {
            49.38296396793602, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000014999999999999987`]& ,
         TagBoxNote->"0.000014999999999999987"],
        StyleBox["0.000014999999999999987`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000014999999999999987`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.574710978503383, -14.815510557964274`}, {
             4.584967478670572, -11.176453228349015`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{214.23911881650295`, 215.14958587861298`}, {
            50.146206953609436`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00001400000000000001]& ,
         TagBoxNote->"0.00001400000000000001"],
        StyleBox["0.00001400000000000001`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00001400000000000001, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.584967478670572, -14.815510557964274`}, {
             4.59511985013459, -11.042921835724492`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{214.64958587861298`, 215.55588569047433`}, {
            48.668997836329154`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000016000000000000013`]& ,
         TagBoxNote->"0.000016000000000000013"],
        StyleBox["0.000016000000000000013`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000016000000000000013`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.59511985013459, -14.815510557964274`}, {
             4.605170185988092, -11.618285980628055`}, "RoundingRadius" -> 0]},
           ImageSizeCache->{{215.05588569047433`, 215.958102018048}, {
            55.03404162043499, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 8.999999999999993*^-6]& ,
         TagBoxNote->"8.999999999999993*^-6"],
        StyleBox["8.999999999999993`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[8.999999999999993*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.605170185988092, -14.815510557964274`}, {
             4.61512051684126, -11.512925464970229`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{215.458102018048, 216.35631612673473`}, {
            53.86847664524795, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 9.999999999999997*^-6]& ,
         TagBoxNote->"9.999999999999997*^-6"],
        StyleBox["9.999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[9.999999999999997*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.61512051684126, -14.815510557964274`}, {
             4.624972813284271, -11.512925464970229`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{215.85631612673473`, 216.75060687992328`}, {
            53.86847664524795, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 9.999999999999997*^-6]& ,
         TagBoxNote->"9.999999999999997*^-6"],
        StyleBox["9.999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[9.999999999999997*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.624972813284271, -14.815510557964274`}, {
             4.634728988229636, -11.512925464970229`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{216.25060687992328`, 217.14105083273148`}, {
            53.86847664524795, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 9.999999999999997*^-6]& ,
         TagBoxNote->"9.999999999999997*^-6"],
        StyleBox["9.999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[9.999999999999997*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.634728988229636, -14.815510557964274`}, {
             4.6443908991413725`, -11.512925464970229`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{216.64105083273148`, 217.527722321218}, {
            53.86847664524795, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 9.999999999999997*^-6]& ,
         TagBoxNote->"9.999999999999997*^-6"],
        StyleBox["9.999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[9.999999999999997*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.6443908991413725`, -14.815510557964274`}, {
             4.653960350157523, -11.618285980628055`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{217.027722321218, 217.91069354732593`}, {
            55.03404162043499, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 8.999999999999993*^-6]& ,
         TagBoxNote->"8.999999999999993*^-6"],
        StyleBox["8.999999999999993`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[8.999999999999993*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.653960350157523, -14.815510557964274`}, {
             4.663439094112067, -11.330603908176274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{217.41069354732593`, 218.29003465980026`}, {
            51.85151972838207, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000012]& ,
         TagBoxNote->"0.000012"],
        StyleBox["0.000012`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000012, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.663439094112067, -14.815510557964274`}, {
             4.672828834461906, -11.618285980628055`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{217.79003465980026`, 218.66581383130594`}, {
            55.03404162043499, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 8.999999999999993*^-6]& ,
         TagBoxNote->"8.999999999999993*^-6"],
        StyleBox["8.999999999999993`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[8.999999999999993*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.672828834461906, -14.815510557964274`}, {
             4.68213122712422, -11.107460356862065`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{218.16581383130594`, 219.03809733195936`}, {
            49.38296396793602, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000014999999999999987`]& ,
         TagBoxNote->"0.000014999999999999987"],
        StyleBox["0.000014999999999999987`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000014999999999999987`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.68213122712422, -14.815510557964274`}, {
             4.6913478822291435`, -11.618285980628055`}, "RoundingRadius" -> 
             0]},
           ImageSizeCache->{{218.53809733195936`, 219.4069495994708}, {
            55.03404162043499, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 8.999999999999993*^-6]& ,
         TagBoxNote->"8.999999999999993*^-6"],
        StyleBox["8.999999999999993`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[8.999999999999993*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.6913478822291435`, -14.815510557964274`}, {
             4.700480365792417, -11.512925464970229`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{218.9069495994708, 219.77243330608414`}, {
            53.86847664524795, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 9.999999999999997*^-6]& ,
         TagBoxNote->"9.999999999999997*^-6"],
        StyleBox["9.999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[9.999999999999997*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.700480365792417, -14.815510557964274`}, {
             4.709530201312334, -12.02375108873622}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{219.27243330608414`, 220.13460942248713`}, {
            59.51955429774695, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 6.*^-6]& ,
         TagBoxNote->"6.*^-6"],
        StyleBox["6.`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[6.*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.709530201312334, -14.815510557964274`}, {
             4.718498871295094, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{219.63460942248713`, 220.49353727885617`}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.718498871295094, -14.815510557964274`}, {
             4.727387818712341, -11.618285980628055`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{219.99353727885617`, 220.84927462318728`}, {
            55.03404162043499, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 8.999999999999993*^-6]& ,
         TagBoxNote->"8.999999999999993*^-6"],
        StyleBox["8.999999999999993`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[8.999999999999993*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.727387818712341, -14.815510557964274`}, {
             4.736198448394496, -11.736069016284437`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{220.34927462318728`, 221.2018776770577}, {
            56.33703240569402, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 8.000000000000006*^-6]& ,
         TagBoxNote->"8.000000000000006*^-6"],
        StyleBox["8.000000000000006`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[8.000000000000006*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.736198448394496, -14.815510557964274`}, {
             4.74493212836325, -11.330603908176274`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{220.7018776770577, 221.5514011889523}, {
            51.85151972838207, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000012]& ,
         TagBoxNote->"0.000012"],
        StyleBox["0.000012`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000012, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.74493212836325, -14.815510557964274`}, {
             4.7535901911063645`, -11.86960040890896}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{221.0514011889523, 221.89789848528142`}, {
            57.814241522974285`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 7.000000000000004*^-6]& ,
         TagBoxNote->"7.000000000000004*^-6"],
        StyleBox["7.000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[7.000000000000004*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.7535901911063645`, -14.815510557964274`}, {
             4.762173934797756, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{221.39789848528142`, 222.24142151920896`}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.762173934797756, -14.815510557964274`}, {
             4.770684624465665, -12.02375108873622}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{221.74142151920896`, 222.58202091740247`}, {
            59.51955429774695, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 6.*^-6]& ,
         TagBoxNote->"6.*^-6"],
        StyleBox["6.`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[6.*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.770684624465665, -14.815510557964274`}, {
             4.77912349311153, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{222.08202091740247`, 222.91974602481108`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.77912349311153, -14.815510557964274`}, {
             4.787491742782046, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{222.41974602481108`, 223.25464494756915`}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.787491742782046, -14.815510557964274`}, {
             4.795790545596741, -12.02375108873622}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{222.75464494756915`, 223.58676459412027`}, {
            59.51955429774695, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 6.*^-6]& ,
         TagBoxNote->"6.*^-6"],
        StyleBox["6.`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[6.*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.795790545596741, -14.815510557964274`}, {
             4.804021044733257, -11.736069016284437`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{223.08676459412027`, 223.91615071464818`}, {
            56.33703240569402, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 8.000000000000006*^-6]& ,
         TagBoxNote->"8.000000000000006*^-6"],
        StyleBox["8.000000000000006`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[8.000000000000006*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.804021044733257, -14.815510557964274`}, {
             4.812184355372417, -11.86960040890896}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{223.41615071464818`, 224.24284793889888`}, {
            57.814241522974285`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 7.000000000000004*^-6]& ,
         TagBoxNote->"7.000000000000004*^-6"],
        StyleBox["7.000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[7.000000000000004*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.812184355372417, -14.815510557964274`}, {
             4.820281565605037, -12.02375108873622}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{223.74284793889888`, 224.56689981247104`}, {
            59.51955429774695, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 6.*^-6]& ,
         TagBoxNote->"6.*^-6"],
        StyleBox["6.`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[6.*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.820281565605037, -14.815510557964274`}, {
             4.8283137373023015`, -11.736069016284437`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{224.06689981247104`, 224.88834883164876`}, {
            56.33703240569402, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 8.000000000000006*^-6]& ,
         TagBoxNote->"8.000000000000006*^-6"],
        StyleBox["8.000000000000006`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[8.000000000000006*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.8283137373023015`, -14.815510557964274`}, {
             4.836281906951478, -11.176453228349015`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{224.38834883164876`, 225.20723647684713`}, {
            50.146206953609436`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.00001400000000000001]& ,
         TagBoxNote->"0.00001400000000000001"],
        StyleBox["0.00001400000000000001`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.00001400000000000001, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.836281906951478, -14.815510557964274`}, {
             4.844187086458591, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{224.70723647684713`, 225.52360324473517`}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.844187086458591, -14.815510557964274`}, {
             4.852030263919617, -12.429216196844383`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{225.02360324473517`, 225.83748867909938`}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.852030263919617, -14.815510557964274`}, {
             4.859812404361672, -11.250561200502737`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{225.33748867909938`, 226.1489314005061}, {
            50.96603643323195, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000013000000000000001`]& ,
         TagBoxNote->"0.000013000000000000001"],
        StyleBox["0.000013000000000000001`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000013000000000000001`, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.859812404361672, -14.815510557964274`}, {
             4.867534450455582, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{225.6489314005061, 226.45796913481874`}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.867534450455582, -14.815510557964274`}, {
             4.875197323201151, -11.618285980628055`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{225.95796913481874`, 226.76463874062233`}, {
            55.03404162043499, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 8.999999999999993*^-6]& ,
         TagBoxNote->"8.999999999999993*^-6"],
        StyleBox["8.999999999999993`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[8.999999999999993*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.875197323201151, -14.815510557964274`}, {
             4.882801922586371, -12.02375108873622}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{226.26463874062233`, 227.06897623560528`}, {
            59.51955429774695, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 6.*^-6]& ,
         TagBoxNote->"6.*^-6"],
        StyleBox["6.`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[6.*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.882801922586371, -14.815510557964274`}, {
             4.890349128221754, -11.330603908176274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{226.56897623560528`, 227.37101682194546`}, {
            51.85151972838207, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 0.000012]& ,
         TagBoxNote->"0.000012"],
        StyleBox["0.000012`", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[0.000012, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.890349128221754, -14.815510557964274`}, {
             4.897839799950911, -11.736069016284437`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{226.87101682194546`, 227.67079491074554`}, {
            56.33703240569402, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 8.000000000000006*^-6]& ,
         TagBoxNote->"8.000000000000006*^-6"],
        StyleBox["8.000000000000006`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[8.000000000000006*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.897839799950911, -14.815510557964274`}, {
             4.90527477843843, -11.736069016284437`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{227.17079491074554`, 227.9683441455601}, {
            56.33703240569402, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 8.000000000000006*^-6]& ,
         TagBoxNote->"8.000000000000006*^-6"],
        StyleBox["8.000000000000006`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[8.000000000000006*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.90527477843843, -14.815510557964274`}, {
             4.912654885736052, -12.02375108873622}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{227.4683441455601, 228.2636974250543}, {
            59.51955429774695, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 6.*^-6]& ,
         TagBoxNote->"6.*^-6"],
        StyleBox["6.`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[6.*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.912654885736052, -14.815510557964274`}, {
             4.919980925828125, -11.86960040890896}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{227.7636974250543, 228.5568869248325}, {
            57.814241522974285`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 7.000000000000004*^-6]& ,
         TagBoxNote->"7.000000000000004*^-6"],
        StyleBox["7.000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[7.000000000000004*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.919980925828125, -14.815510557964274`}, {
             4.927253685157205, -12.429216196844383`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{228.0568869248325, 228.8479441184735}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.927253685157205, -14.815510557964274`}, {
             4.9344739331306915`, -12.429216196844383`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{228.3479441184735, 229.13689979780585`}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.9344739331306915`, -14.815510557964274`}, {
             4.941642422609304, -12.429216196844383`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{228.63689979780585`, 229.4237840924569}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.941642422609304, -14.815510557964274`}, {
             4.948759890378168, -11.736069016284437`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{228.9237840924569, 229.70862648870573`}, {
            56.33703240569402, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 8.000000000000006*^-6]& ,
         TagBoxNote->"8.000000000000006*^-6"],
        StyleBox["8.000000000000006`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[8.000000000000006*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.948759890378168, -14.815510557964274`}, {
             4.955827057601261, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{229.20862648870573`, 229.99145584766998`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.955827057601261, -14.815510557964274`}, {
             4.962844630259907, -11.86960040890896}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{229.49145584766998`, 230.27230042285487`}, {
            57.814241522974285`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 7.000000000000004*^-6]& ,
         TagBoxNote->"7.000000000000004*^-6"],
        StyleBox["7.000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[7.000000000000004*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.962844630259907, -14.815510557964274`}, {
             4.969813299576001, -12.429216196844383`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{229.77230042285487`, 230.55118787709034`}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.969813299576001, -14.815510557964274`}, {
             4.976733742420574, -11.736069016284437`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{230.05118787709034`, 230.8281452988822}, {
            56.33703240569402, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 8.000000000000006*^-6]& ,
         TagBoxNote->"8.000000000000006*^-6"],
        StyleBox["8.000000000000006`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[8.000000000000006*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.976733742420574, -14.815510557964274`}, {
             4.983606621708336, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{230.3281452988822, 231.10319921820147`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.983606621708336, -14.815510557964274`}, {
             4.990432586778736, -11.512925464970229`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{230.60319921820147`, 231.37637562173487`}, {
            53.86847664524795, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 9.999999999999997*^-6]& ,
         TagBoxNote->"9.999999999999997*^-6"],
        StyleBox["9.999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[9.999999999999997*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.990432586778736, -14.815510557964274`}, {
             4.997212273764115, -12.716898269296165`}, "RoundingRadius" -> 0]},
           ImageSizeCache->{{230.87637562173487`, 231.6476999676181}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{4.997212273764115, -14.815510557964274`}, {
             5.003946305945459, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{231.1476999676181, 231.91719719967327`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.003946305945459, -14.815510557964274`}, {
             5.0106352940962555`, -13.815510557964274`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{231.41719719967327`, 232.18489176116992`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.0106352940962555`, -14.815510557964274`}, {
             5.017279836814924, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{231.68489176116992`, 232.45080760812922`}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.017279836814924, -14.815510557964274`}, {
             5.0238805208462765`, -12.206072645530174`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{231.95080760812922`, 232.71496822218867`}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.0238805208462765`, -14.815510557964274`}, {
             5.030437921392435, -12.02375108873622}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{232.21496822218867`, 232.97739662304522`}, {
            59.51955429774695, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 6.*^-6]& ,
         TagBoxNote->"6.*^-6"],
        StyleBox["6.`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[6.*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.0369526024136295`, -14.815510557964274`}, {
             5.043425116919247, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{232.73811538049307`, 233.49714662607178`}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.043425116919247, -14.815510557964274`}, {
             5.049856007249537, -12.02375108873622}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{232.99714662607178`, 233.7545120643399}, {
            59.51955429774695, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 6.*^-6]& ,
         TagBoxNote->"6.*^-6"],
        StyleBox["6.`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[6.*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.049856007249537, -14.815510557964274`}, {
             5.056245805348308, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{233.2545120643399, 234.01023298378854`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.056245805348308, -14.815510557964274`}, {
             5.062595033026967, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{233.51023298378854`, 234.26433026740813`}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.062595033026967, -14.815510557964274`}, {
             5.0689042022202315`, -12.429216196844383`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{233.76433026740813`, 234.5168244029222}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.0689042022202315`, -14.815510557964274`}, {
             5.075173815233827, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{234.0168244029222, 234.76773549270013`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.075173815233827, -14.815510557964274`}, {
             5.081404364984463, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{234.26773549270013`, 235.01708326336126`}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.081404364984463, -14.815510557964274`}, {
             5.087596335232384, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{234.51708326336126`, 235.26488707508128`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.087596335232384, -14.815510557964274`}, {
             5.093750200806762, -12.02375108873622}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{234.76488707508128`, 235.5111659306129}, {
            59.51955429774695, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 6.*^-6]& ,
         TagBoxNote->"6.*^-6"],
        StyleBox["6.`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[6.*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.093750200806762, -14.815510557964274`}, {
             5.099866427824199, -12.429216196844383`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{235.0111659306129, 235.75593848402988`}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.099866427824199, -14.815510557964274`}, {
             5.10594547390058, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{235.25593848402988`, 235.99922304920605`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.10594547390058, -14.815510557964274`}, {
             5.111987788356544, -12.429216196844383`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{235.49922304920605`, 236.24103760803754`}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.111987788356544, -14.815510557964274`}, {
             5.117993812416755, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{235.74103760803754`, 236.4813998184184}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.117993812416755, -14.815510557964274`}, {
             5.123963979403259, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{235.9813998184184, 236.7203270219781}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.123963979403259, -14.815510557964274`}, {
             5.1298987149230735`, -13.815510557964274`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{236.2203270219781, 236.9578362515895}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.1298987149230735`, -14.815510557964274`}, {
             5.135798437050262, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{236.4578362515895, 237.19394423865504`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.135798437050262, -14.815510557964274`}, {
             5.14166355650266, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{236.69394423865504`, 237.42866742017964`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.14166355650266, -14.815510557964274`}, {
             5.147494476813453, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{236.92866742017964`, 237.66202194563706`}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.147494476813453, -14.815510557964274`}, {
             5.153291594497779, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{237.16202194563706`, 237.89402368363767`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.153291594497779, -14.815510557964274`}, {
             5.159055299214529, -12.429216196844383`}, "RoundingRadius" -> 0]},
           ImageSizeCache->{{237.39402368363767`, 238.12468822840336`}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.159055299214529, -14.815510557964274`}, {
             5.1647859739235145`, -12.429216196844383`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{237.62468822840336`, 238.3540309060577}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.1647859739235145`, -14.815510557964274`}, {
             5.170483995038151, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{237.8540309060577, 238.58206678073626`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.170483995038151, -14.815510557964274`}, {
             5.176149732573829, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{238.08206678073626`, 238.8088106605244}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.176149732573829, -14.815510557964274`}, {
             5.181783550292085, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{238.3088106605244, 239.03427710322708`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.181783550292085, -14.815510557964274`}, {
             5.187385805840755, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{238.53427710322708`, 239.25848042197788`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.187385805840755, -14.815510557964274`}, {
             5.19295685089021, -12.429216196844383`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{238.75848042197788`, 239.4814346906911}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.19295685089021, -14.815510557964274`}, {
             5.198497031265826, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{238.9814346906911, 239.7031537493631}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.198497031265826, -14.815510557964274`}, {
             5.204006687076795, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{239.2031537493631, 239.92365120922767`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.204006687076795, -14.815510557964274`}, {
             5.209486152841421, -13.122363377404328`}, "RoundingRadius" -> 0]},
           ImageSizeCache->{{239.42365120922767`, 240.14294045777012`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.209486152841421, -14.815510557964274`}, {
             5.214935757608986, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{239.64294045777012`, 240.36103466360447`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.214935757608986, -14.815510557964274`}, {
             5.220355825078324, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{239.86103466360447`, 240.57794678121886`}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.220355825078324, -14.815510557964274`}, {
             5.225746673713202, -12.429216196844383`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{240.07794678121886`, 240.79368955559295`}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.225746673713202, -14.815510557964274`}, {
             5.231108616854587, -12.429216196844383`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{240.29368955559295`, 241.00827552669116`}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.231108616854587, -14.815510557964274`}, {
             5.236441962829949, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{240.50827552669116`, 241.2217170338367}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.236441962829949, -14.815510557964274`}, {
             5.241747015059643, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{240.7217170338367, 241.43402621996907`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.241747015059643, -14.815510557964274`}, {
             5.247024072160486, -12.429216196844383`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{240.93402621996907`, 241.64521503578942`}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.247024072160486, -14.815510557964274`}, {
             5.25227342804663, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{241.14521503578942`, 241.85529524379723`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.2574953720277815`, -14.815510557964274`}, {
             5.262690188904886, -12.716898269296165`}, "RoundingRadius" -> 0]},
           ImageSizeCache->{{241.56427842222132`, 242.27217596884893`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.262690188904886, -14.815510557964274`}, {
             5.267858159063328, -12.429216196844383`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{241.77217596884893`, 242.47899910475587`}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.267858159063328, -14.815510557964274`}, {
             5.272999558563747, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{241.97899910475587`, 242.68475887794068`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.272999558563747, -14.815510557964274`}, {
             5.278114659230517, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{242.18475887794068`, 242.88946616686584`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.278114659230517, -14.815510557964274`}, {
             5.2832037287379885`, -13.122363377404328`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{242.38946616686584`, 243.09313168390918`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.2832037287379885`, -14.815510557964274`}, {
             5.288267030694535, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{242.59313168390918`, 243.29576597872722`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.288267030694535, -14.815510557964274`}, {
             5.293304824724492, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{242.79576597872722`, 243.49737944153463`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.293304824724492, -14.815510557964274`}, {
             5.298317366548036, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{242.99737944153463`, 243.69798230630087`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.298317366548036, -14.815510557964274`}, {
             5.303304908059076, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{243.19798230630087`, 243.89758465386745`}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.303304908059076, -14.815510557964274`}, {
             5.308267697401205, -12.716898269296165`}, "RoundingRadius" -> 0]},
           ImageSizeCache->{{243.39758465386745`, 244.09619641498762`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.308267697401205, -14.815510557964274`}, {
             5.313205979041787, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{243.59619641498762`, 244.29382737329112`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.318119993844216, -14.815510557964274`}, {
             5.3230099791384085`, -13.122363377404328`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{243.99048716817617`, 244.68618529763066`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.3230099791384085`, -14.815510557964274`}, {
             5.327876168789581, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{244.18618529763066`, 244.88093112098437`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.327876168789581, -14.815510557964274`}, {
             5.332718793265369, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{244.38093112098437`, 245.07473386159538`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.332718793265369, -14.815510557964274`}, {
             5.337538079701318, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{244.57473386159538`, 245.26760260947088`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.337538079701318, -14.815510557964274`}, {
             5.342334251964811, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{244.76760260947088`, 245.45954632382555`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.342334251964811, -14.815510557964274`}, {
             5.3471075307174685`, -13.122363377404328`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{244.95954632382555`, 245.65057383557885`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.3471075307174685`, -14.815510557964274`}, {
             5.351858133476067, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{245.15057383557885`, 245.840693849793}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.3612921657094255`, -14.815510557964274`}, {
             5.365976015021851, -13.122363377404328`}, "RoundingRadius" -> 0]},
           ImageSizeCache->{{245.71824559079192`, 246.40569411955883`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.365976015021851, -14.815510557964274`}, {
             5.3706380281276624`, -13.815510557964274`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{245.90569411955883`, 246.5922687592378}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.3706380281276624`, -14.815510557964274`}, {
             5.375278407684165, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{246.0922687592378, 246.77797762021228`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.375278407684165, -14.815510557964274`}, {
             5.37989735354046, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{246.27797762021228`, 246.9628287004807}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.37989735354046, -14.815510557964274`}, {
             5.384495062789089, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{246.4628287004807, 247.1468298877237}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.384495062789089, -14.815510557964274`}, {
             5.389071729816501, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{246.6468298877237, 247.3299889613234}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.389071729816501, -14.815510557964274`}, {
             5.393627546352362, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{246.8299889613234, 247.51231359433706`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.3981627015177525`, -14.815510557964274`}, {
             5.402677381872279, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{247.19381135542577`, 247.87448971074005`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.402677381872279, -14.815510557964274`}, {
             5.407171771460119, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{247.37448971074005`, 248.0543560257624}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.407171771460119, -14.815510557964274`}, {
             5.4116460518550396`, -12.02375108873622}, "RoundingRadius" -> 0]},
           ImageSizeCache->{{247.5543560257624, 248.23341756710906`}, {
            59.51955429774695, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 6.*^-6]& ,
         TagBoxNote->"6.*^-6"],
        StyleBox["6.`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[6.*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.41610040220442, -14.815510557964274`}, {
             5.420534999272286, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{247.91168150429183`, 248.58915491144018`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.429345628954441, -14.815510557964274`}, {
             5.43372200355424, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{248.44175796531061`, 249.116901298357}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.43372200355424, -14.815510557964274`}, {
             5.438079308923196, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{248.616901298357, 249.29128147720522`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.438079308923196, -14.815510557964274`}, {
             5.442417710521793, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{248.79128147720522`, 249.46490512361498`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.442417710521793, -14.815510557964274`}, {
             5.44673737166631, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{248.96490512361498`, 249.63777877353434`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.44673737166631, -14.815510557964274`}, {
             5.4510384535657, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{249.13777877353434`, 249.80990887857592`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.4510384535657, -14.815510557964274`}, {
             5.455321115357702, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{249.30990887857592`, 249.98130180746185`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.455321115357702, -14.815510557964274`}, {
             5.459585514144159, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{249.48130180746185`, 250.15196384743746`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.459585514144159, -14.815510557964274`}, {
             5.4638318050256105`, -12.429216196844383`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{249.65196384743746`, 250.3219012056554}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.4638318050256105`, -14.815510557964274`}, {
             5.4680601411351315`, -13.122363377404328`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{249.8219012056554, 250.49112001053007`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.4680601411351315`, -14.815510557964274`}, {
             5.472270673671475, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{249.99112001053007`, 250.65962631306397`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.472270673671475, -14.815510557964274`}, {
             5.476463551931511, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{250.15962631306397`, 250.8274260881459}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.476463551931511, -14.815510557964274`}, {
             5.480638923341991, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{250.3274260881459, 250.99452523582207`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.480638923341991, -14.815510557964274`}, {
             5.484796933490655, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{250.49452523582207`, 251.16092958254117`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.497168225293202, -14.815510557964274`}, {
             5.501258210544727, -12.429216196844383`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{251.1560310029011, 251.81971298046665`}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.5134287461649825`, -14.815510557964274`}, {
             5.517452896464707, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{251.80678010072393`, 252.46782735115943`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.5254529391317835`, -14.815510557964274`}, {
             5.529429087511423, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{252.28799056051756`, 252.94711676510002`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.53338948872752, -14.815510557964274`}, {
             5.537334267018537, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{252.60561276524135`, 253.2634835329881}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.537334267018537, -14.815510557964274`}, {
             5.541263545158426, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{252.7634835329881, 253.42073398177695`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.541263545158426, -14.815510557964274`}, {
             5.545177444479562, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{252.92073398177695`, 253.5773689673523}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.54907608489522, -14.815510557964274`}, {
             5.552959584921617, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{253.23339328866587`, 253.888811688759}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.552959584921617, -14.815510557964274`}, {
             5.556828061699537, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{253.388811688759, 254.0436288556278}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.556828061699537, -14.815510557964274`}, {
             5.560681631015528, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{253.5436288556278, 254.19784942307163`}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.560681631015528, -14.815510557964274`}, {
             5.564520407322694, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{253.69784942307163`, 254.3514779715253}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.564520407322694, -14.815510557964274`}, {
             5.568344503761097, -12.429216196844383`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{253.8514779715253, 254.50451902887525`}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.568344503761097, -14.815510557964274`}, {
             5.572154032177765, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{254.00451902887525`, 254.65697707126057`}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.575949103146316, -14.815510557964274`}, {
             5.579729825986222, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{254.3088565238582, 254.96016176165392`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.579729825986222, -14.815510557964274`}, {
             5.583496308781699, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{254.46016176165392`, 255.11089711019835`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.583496308781699, -14.815510557964274`}, {
             5.58724865840025, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{254.61089711019835`, 255.26106684634902`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.5909869805108565`, -14.815510557964274`}, {
             5.594711379601839, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{254.91067519899843`, 255.55972634978878`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.602118820879701, -14.815510557964274`}, {
             5.605802066295998, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{255.35617354030344`, 256.0035777133072}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.605802066295998, -14.815510557964274`}, {
             5.60947179518496, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{255.5035777133072, 256.15044095234964`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.6131281063880705`, -14.815510557964274`}, {
             5.616771097666572, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{255.7967672130854, 256.44256040793783`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{5.616771097666572, -14.815510557964274`}, {
             5.62040086571715, -12.206072645530174`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{255.94256040793783`, 256.5878244067264}, {
            61.536511214612815`, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.999999999999999*^-6]& ,
         TagBoxNote->"4.999999999999999*^-6"],
        StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.6240175061873385`, -14.815510557964274`}, {
             5.627621113690637, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{256.2325630372834, 256.8767800860588}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.627621113690637, -14.815510557964274`}, {
             5.631211781821365, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{256.3767800860588, 257.02047929871486`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.631211781821365, -14.815510557964274`}, {
             5.634789603169249, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{256.52047929871486`, 257.16366438070986`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.634789603169249, -14.815510557964274`}, {
             5.638354669333745, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{256.66366438070986`, 257.30633899787114`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.641907070938114, -14.815510557964274`}, {
             5.645446897643238, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{256.94850677695865`, 257.59017130621777`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.645446897643238, -14.815510557964274`}, {
             5.648974238161206, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{257.09017130621777`, 257.7313361359229}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.648974238161206, -14.815510557964274`}, {
             5.652489180268651, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{257.2313361359229, 257.8720047789114}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.652489180268651, -14.815510557964274`}, {
             5.655991810819852, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{257.3720047789114, 258.01218071110776`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.66988092298052, -14.815510557964274`}, {
             5.673323267171493, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{258.0680255871351, 258.70578884787784`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.673323267171493, -14.815510557964274`}, {
             5.676753802268282, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{258.20578884787784`, 258.8430795064544}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.680172609017068, -14.815510557964274`}, {
             5.683579767338681, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{258.4799007943422, 259.1162559099878}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.683579767338681, -14.815510557964274`}, {
             5.68697535633982, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{258.6162559099878, 259.25214801925614`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.703782474656201, -14.815510557964274`}, {
             5.707110264748875, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{259.4247720494228, 260.05795083364677`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.707110264748875, -14.815510557964274`}, {
             5.71042701737487, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{259.55795083364677`, 260.19068789638214`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.717027701406222, -14.815510557964274`}, {
             5.720311776607412, -12.716898269296165`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{259.9548485104416, 260.5862778165019}, {
            67.18758886711178, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.9999999999999997`*^-6]& ,
         TagBoxNote->"2.9999999999999997*^-6"],
        StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.720311776607412, -14.815510557964274`}, {
             5.723585101952381, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{260.0862778165019, 260.71727691129814`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.723585101952381, -14.815510557964274`}, {
             5.726847747587197, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{260.21727691129814`, 260.84784860208924`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.730099782973574, -14.815510557964274`}, {
             5.733341276897746, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{260.47799566874596`, 261.10772086410634`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.739792912179234, -14.815510557964274`}, {
             5.7430031878094825`, -13.815510557964274`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{260.8659165192158, 261.49439235259285`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.762051382780177, -14.815510557964274`}, {
             5.765191102784844, -13.122363377404328`}, "RoundingRadius" -> 0]},
           ImageSizeCache->{{261.7567046911751, 262.38235687517124`}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.765191102784844, -14.815510557964274`}, {
             5.768320995793772, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{261.88235687517124`, 262.5076157809531}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.777652323222656, -14.815510557964274`}, {
             5.780743515792329, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{262.38105725639645`, 263.00476736333417`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.796057750765372, -14.815510557964274`}, {
             5.799092654460526, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{263.1176459218464, 263.73910333745897`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.808142489980444, -14.815510557964274`}, {
             5.811140992976701, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{263.601279453862, 264.2212801066713}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.814130531825066, -14.815510557964274`}, {
             5.817111159963204, -12.429216196844383`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{263.8409220125992, 264.460207310231}, {
            64.00506697505888, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 4.000000000000002*^-6]& ,
         TagBoxNote->"4.000000000000002*^-6"],
        StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.820082930352362, -14.815510557964274`}, {
             5.823045895483019, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{264.07913811908577`, 264.6977165398424}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.8289456176102075`, -14.815510557964274`}, {
             5.831882477283517, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{264.433824526908, 265.0513582023608}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.855071922202427, -14.815510557964274`}, {
             5.857933154483459, -13.122363377404328`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{265.47940414129397`, 266.0939111943106}, {
            71.67310154442374, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 2.000000000000001*^-6]& ,
         TagBoxNote->"2.000000000000001*^-6"],
        StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.863631175598097, -14.815510557964274`}, {
             5.8664680569332965`, -13.815510557964274`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{265.8219470689892, 266.4354795925823}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.8888779583328805`, -14.815510557964274`}, {
             5.8916442118257715`, -13.815510557964274`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{266.83232805353083`, 267.44303403761603`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.8971538676367405`, -14.815510557964274`}, {
             5.8998973535824915`, -13.815510557964274`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{267.1635314974806, 267.77332632005516`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.908082938168931, -14.815510557964274`}, {
             5.910796644040527, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{267.60091495185736`, 268.20951797027374`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.910796644040527, -14.815510557964274`}, {
             5.91350300563827, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           
           ImageSizeCache->{{267.70951797027374`, 268.3178270694718}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.924255797414532, -14.815510557964274`}, {
             5.926926025970411, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{268.2481558149441, 268.8550188630236}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.926926025970411, -14.815510557964274`}, {
             5.929589143389895, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{268.3550188630236, 268.96159732208963`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.945420608606575, -14.815510557964274`}, {
             5.948034989180646, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{269.0951755320502, 269.69980353341356`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.958424693029782, -14.815510557964274`}, {
             5.961005339623274, -13.815510557964274`}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{269.615601431881, 270.2188793930088}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.988961416889864, -14.815510557964274`}, {
             5.991464547107982, -13.815510557964274`}, "RoundingRadius" -> 0]},
           ImageSizeCache->{{270.8376868533203, 271.4378625945538}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{5.998936561946683, -14.815510557964274`}, {
             6.0014148779611505`, -13.815510557964274`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{271.2368940310954, 271.83607670324056`}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        TagBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            
            RectangleBox[{6.1070228877422545`, -14.815510557964274`}, {
             6.1092475827643655`, -13.815510557964274`}, "RoundingRadius" -> 
             0]},
           
           ImageSizeCache->{{275.5625290801252, 276.1515617925448}, {
            79.34113611378858, 90.90377156037643}}],
          "DelayedMouseEffectStyle"],
         StatusArea[#, 1.0000000000000004`*^-6]& ,
         TagBoxNote->"1.0000000000000004*^-6"],
        StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1.0000000000000004`*^-6, {}], 
        "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVkHk4lAkcgMcY42Y0DB8iE3aMGVnHoPD9qAdJF4pH11JNCTXjqrXYckS2
hDJpe1yh+4nclnZ+lahGNoq2VtpKgwqtrDNZ+8f7vH+/r1nYIf+9VAqFsn6R
//269Ijbahs52Wq7SfWWAw2W/KT86pyrnOzXrMj9x4oGXoGSxE++cnLqwwxh
Z0qDm/Ta5vx9cpJTUcatUaVBYsSYy1CJnMwmptbV9SuCoaNQcIo5SAZTi7Kb
MhVhy4OAFc+nB8mPTz8y7/ZRQTZqYxZxb5hkHs4weZqmAHHWu8SNFSOk5Zm2
NXaCefKGmNrPKPtM+i88Djx7f4qsMJHv5x4YJ4XT7Fpv0TiZdI9+rTdogrzN
THmTvmGYHLcIG8oxnyRnTzT3bqK9Ir2Ozva90p8mXZx3JPdE15MXry9v0KbO
kq6/bX1ZsqNLeuFsRvZG2Rw5253y40bhO2lMHMeY3TxP0g18ZO5KY9IhJu0y
NWuB3D0ooHuMTUhrPBrVBy5ToM8xMSgXZqVh/2qYMooUYNax5X0HlYKvlRds
76VSIToqz0heQ8V1Eu0iaaIi1Bu0hv1VpISup4aSbMQ0yJrfQOUkquDc253b
zbcoQdu3W4WqHHW8Wvslf7cfHZ7EiHzbNbXQ8r1Fp5W9MpSnpM5ohDIwLzc+
1IWvAl7piVvN/9TBlEun9zWzVeGm+cVd+3yY6GHoFdmqrAZ+3TXyiWJdHFM1
6mBR1KHLJSZepMvCyOBT3M+D6nCy0iRNINLHKO0Hc6tkGqB1d9KNc98Ad3ia
cbruaEJ8diJFxckQjZ/pB4xc1gK98FGwyzHCR294L/xLteHXec0sX/pS/Gat
FK63jgEDNiE/Z8eZYLLk7sCa2wzYczBv3LjDFCfdtbUIFx2Q27s2dBQvwx7J
tfqqGzpQ52ThYLveDCfZ1woUTJaA/IR5htWUGWqPOHOmCpaARlNC//lKNp4W
spyq1JngN9YWW7ltOSqbpH7RzGTCUeoBbVeWOcrT3Fes+MqETmPF4ahWc1Re
trNc9aAuHE2vLnA8ZIHLZjTaM4d1wULW6BfLscSSY2rhsu168F6/jgzusUR9
n3ON1S/0oMBDxakm5zvs8sz0CAhkQWWTmFbuw8HxT+1rG9pY8LdzF2PlBAfV
eiQLUk99oOVnmHnftMKsyFqHk/X6sGbaXjyzjYt+zoIyHY4BDF6dlHjQrVHJ
01u6qswAkpwZdyhSa7ScuxRixSLAptOUuzeChwmm9EyuAQE30mxGhQd52Ll6
b521IQHcVW7V+8U8jDu5nGFjQoDFlZCVkYd52Lq05L6dJQFGKfm+Mak8DIPz
tq4CAlQE6hHHLvCwOP0X+satBAwUTl4vlPFw/OoH+03BBPwQqCQq7uShV+fa
0M0hBPSr6TqUdvFwlKXSErCTgJeHv28pf85D9ytp4mAhAd2bIzuuv+Nh36Ok
vtB4AqRKbz81zfHQdqxPdfcRAtxaPlc1f+NhGtPVaU8CAc3RC7G3FfhovX02
V5hMQP1r43lU5mPCSLx3xPHFvqYgzQdMPnbq9MZGZi72iYRdD1l8ZAscL0Zl
EXDFMi5fRvDxYfKXr4eyCSg7k7f0D1M+Gpf5c8U5BJj6lr55wuajqP1WUHQe
AYWUqopuCz62fmSkx5xd/NHwe/gzDh8NGKLqWAkB56Me83ut+fgfSPMi1A==

        "]]},
      Annotation[#, "Charting`Private`Tag$1014114#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-0.16012735135300493`, -14.815510557964274`},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{0, 8.006367567650246}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledTicks[{Log, Exp}]}, {{{0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}}, {-2.3025850929940455`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.4011973816621555`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.6888794541139363`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.0943445622221, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.248495242049359, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.382026634673881, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.499809670330265, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.298317366548036, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.703782474656201, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.991464547107982, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.214608098422191, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.396929655216146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.551080335043404, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.684611727667927, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      6.802394763324311, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      7.600902459542082, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.006367567650246, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.294049640102028, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.517193191416238, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.699514748210191, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.85366542803745, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.987196820661973, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.104979856318357, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.210340371976184, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.615805480084347, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.903487552536127, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      10.126631103850338`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}, {{-13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.01\"", ShowStringCharacters -> False], 0.01, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {-11.512925464970229`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-6.907755278982137, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.302585092994046, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.605170185988092, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.298317366548036, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      5.703782474656201, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}}]]], "Output",
 CellChangeTimes->{{3.8232285394516487`*^9, 3.823228552169157*^9}},
 CellLabel->
  "Out[2398]=",ExpressionUUID->"6da840d6-d3c6-48cb-bfff-09b55e0b33a7"]
}, Open  ]],

Cell["Erdos - R\[EAcute]nyi graph", "Text",
 CellChangeTimes->{{3.734224949751999*^9, 3.734224959043346*^9}, {
  3.734825883504176*^9, 3.734825909272047*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"a86bea3d-d9e5-4805-8f18-6a0291b8e09e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";", " ", 
  RowBox[{"p", "=", 
   FractionBox["4", 
    RowBox[{"nVert", "-", "1"}]]}], ";", 
  RowBox[{"gER", "=", 
   RowBox[{"RandomGraph", "[", 
    RowBox[{
     RowBox[{"BernoulliGraphDistribution", "[", 
      RowBox[{"nVert", ",", "p"}], "]"}], ",", 
     RowBox[{"VertexStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"White", ",", 
        RowBox[{"EdgeForm", "[", 
         RowBox[{"Thickness", "[", "0.005", "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"VertexSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Scaled\>\"", ",", " ", "0.05"}], "}"}]}], ",", 
     RowBox[{"EdgeStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.008", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.734206467082712*^9, 3.73420650866136*^9}, {
   3.7342250011232843`*^9, 3.7342250059592037`*^9}, {3.734225040727858*^9, 
   3.734225044886138*^9}, {3.734225958846312*^9, 3.734225961217741*^9}, {
   3.7342278917321367`*^9, 3.7342279563717823`*^9}, 3.7347509605294456`*^9, 
   3.7939976608106623`*^9},
 CellLabel->
  "In[2399]:=",ExpressionUUID->"a388af58-a1f4-41f7-981b-4f09e0b99b3b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataER", "=", 
   RowBox[{"Join", " ", "@@", 
    RowBox[{"(", " ", 
     RowBox[{"VertexDegree", " ", "/@", " ", 
      RowBox[{"RandomGraph", "[", 
       RowBox[{
        RowBox[{"BernoulliGraphDistribution", "[", 
         RowBox[{"nVert", ",", "p"}], "]"}], ",", "1000"}], "]"}]}], 
     ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pER", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Histogram", "[", 
      RowBox[{"dataER", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "15", ",", "1"}], "}"}], ",", "\"\<PDF\>\""}], 
      "]"}], ",", 
     RowBox[{"DiscretePlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"PDF", "[", 
         RowBox[{
          RowBox[{"BinomialDistribution", "[", 
           RowBox[{"nVert", ",", "p"}], "]"}], ",", "k"}], "]"}], "//", 
        "Evaluate"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "15"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{"pSF", ",", "pSF1", ",", "pER"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.734206699990191*^9, {3.734206799884397*^9, 3.734206812319873*^9}, {
   3.734206882873321*^9, 3.7342069572287083`*^9}, {3.734206998904415*^9, 
   3.7342071255243263`*^9}, {3.734207165906102*^9, 3.734207335369875*^9}, {
   3.7342253522654247`*^9, 3.734225428840513*^9}, {3.7342255099741983`*^9, 
   3.7342255150937366`*^9}, {3.734225842074279*^9, 3.734225860870153*^9}, {
   3.7342259667972603`*^9, 3.7342260301138573`*^9}, {3.7342281878787813`*^9, 
   3.734228210779155*^9}, {3.734228263662814*^9, 3.7342282911542673`*^9}, {
   3.734229388227146*^9, 3.734229420098557*^9}, {3.734229536071389*^9, 
   3.7342295696165113`*^9}, {3.7342297180523977`*^9, 3.734229724979093*^9}, {
   3.793998001246427*^9, 3.793998025313589*^9}},
 CellLabel->
  "In[2400]:=",ExpressionUUID->"281fc40e-d7b7-4005-969f-785df896d3bc"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
        EdgeForm[{Opacity[0.5459999999999999], Thickness[Small]}], {}, 
        {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
         EdgeForm[{Opacity[0.5459999999999999], Thickness[Small]}], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{2., 0}, {3., 0.4595}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{35.304443774594965`, 
               43.41550573792398}, {-106.75056867004609`, \
-15.112603358556157`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.4595]& ,
            TagBoxNote->"0.4595"],
           StyleBox["0.4595`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.4595, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{3., 0}, {4., 0.19035}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{42.91550573792398, 
               51.026567701252986`}, {-53.366926964741374`, \
-15.112603358556157`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.19035]& ,
            TagBoxNote->"0.19035"],
           StyleBox["0.19035`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.19035, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{4., 0}, {5., 0.10205}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{50.526567701252986`, 
               58.637629664582}, {-35.85336366331687, -15.112603358556157`}}],
             
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.10205]& ,
            TagBoxNote->"0.10205"],
           StyleBox["0.10205`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.10205, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{5., 0}, {6., 0.06585}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{58.137629664582, 
               66.24869162791101}, {-28.673397734533552`, \
-15.112603358556157`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.06585]& ,
            TagBoxNote->"0.06585"],
           StyleBox["0.06585`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.06585, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{6., 0}, {7., 0.05005}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{65.74869162791101, 
               73.85975359124004}, {-25.539600450699943`, \
-15.112603358556157`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.05005]& ,
            TagBoxNote->"0.05005"],
           StyleBox["0.05005`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.05005, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{7., 0}, {8., 0.03785}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{73.35975359124004, 
               81.47081555456904}, {-23.11983292773982, \
-15.112603358556157`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.03785]& ,
            TagBoxNote->"0.03785"],
           StyleBox["0.03785`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.03785, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{8., 0}, {9., 0.0299}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{80.97081555456904, 
               89.08187751789805}, {-21.54301720581089, \
-15.112603358556157`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.0299]& ,
            TagBoxNote->"0.0299"],
           StyleBox["0.0299`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.0299, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{9., 0}, {10., 0.024}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{88.58187751789805, 
               96.69293948122706}, {-20.372801764379354`, \
-15.112603358556157`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.024]& ,
            TagBoxNote->"0.024"],
           StyleBox["0.024`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.024, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{10., 0}, {11., 0.01645}, "RoundingRadius" -> 0]},
              
              
              ImageSizeCache->{{96.19293948122706, 
               104.30400144455609`}, {-18.87532268254747, \
-15.112603358556157`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.01645]& ,
            TagBoxNote->"0.01645"],
           StyleBox["0.01645`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.01645, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{11., 0}, {12., 0.01035}, "RoundingRadius" -> 0]},
              
              
              ImageSizeCache->{{103.80400144455609`, 
               111.9150634078851}, {-17.665438921067413`, \
-15.112603358556157`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.01035]& ,
            TagBoxNote->"0.01035"],
           StyleBox["0.01035`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.01035, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{12., 0}, {13., 0.0074}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{111.4150634078851, 
               119.5261253712141}, {-17.080331200351644`, \
-15.112603358556157`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.0074]& ,
            TagBoxNote->"0.0074"],
           StyleBox["0.0074`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.0074, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{13., 0}, {14., 0.00365}, "RoundingRadius" -> 0]},
              
              
              ImageSizeCache->{{119.0261253712141, 
               127.13718733454311`}, {-16.336550199441767`, \
-15.112603358556157`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00365]& ,
            TagBoxNote->"0.00365"],
           StyleBox["0.00365`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00365, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{14., 0}, {15., 0.0018}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{126.63718733454311`, 
               134.74824929787215`}, {-15.969618238992894`, \
-15.112603358556157`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.0018]& ,
            TagBoxNote->"0.0018"],
           StyleBox["0.0018`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.0018, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{15., 0}, {16., 0.00055}, "RoundingRadius" -> 0]},
              
              
              ImageSizeCache->{{134.24824929787215`, 
               142.35931126120116`}, {-15.721691238689608`, \
-15.112603358556157`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00055]& ,
            TagBoxNote->"0.00055"],
           StyleBox["0.00055`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00055, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{16., 0}, {17., 0.00025}, "RoundingRadius" -> 0]},
              
              
              ImageSizeCache->{{141.85931126120116`, 
               149.97037322453016`}, {-15.662188758616814`, \
-15.112603358556157`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00025]& ,
            TagBoxNote->"0.00025"],
           StyleBox["0.00025`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00025, {}], 
           "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-0.4, 0},
      DisplayFunction->Identity,
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{16.726581265012012`, 1.4999999999999432`}, {
       12.911524554006377`, 5.5995407218092765`}},
      PlotRange->{{0., 20.}, {All, All}},
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {103.33528312544142, -66.06303208440134},
      ImageScaled[{0.5, 0.5}], {191.87929859970035, 125.83434682743112}], 
    InsetBox[
     GraphicsBox[{
       {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
        EdgeForm[{Opacity[0.623], Thickness[Small]}], {}, 
        {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
         EdgeForm[{Opacity[0.623], Thickness[Small]}], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{0.6931471805599453, -14.815510557964274`}, {
                1.0986122886681098`, -0.6924134498062021}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{43.86167653531004, 
               52.07059081061314}, {-106.7505686700461, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.500367]& ,
            TagBoxNote->"0.500367"],
           StyleBox["0.500367`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.500367, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{1.0986122886681098`, -14.815510557964274`}, {
                1.3862943611198906`, -1.6102682570748148`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{51.57059081061314, 
               57.540152533001105`}, {-100.8275463368278, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.19983399999999998`]& ,
            TagBoxNote->"0.19983399999999998"],
           StyleBox["0.19983399999999998`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.19983399999999998`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{1.3862943611198906`, -14.815510557964274`}, {
                1.6094379124341003`, -2.304587095664719}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{57.040152533001105`, 
               61.78267420445664}, {-96.34702724516424, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.09979999999999997]& ,
            TagBoxNote->"0.09979999999999997"],
           StyleBox["0.09979999999999997`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.09979999999999997, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{1.6094379124341003`, -14.815510557964274`}, {
                1.791759469228055, -2.8624959244505277`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{61.28267420445664, 
               65.2490668083042}, {-92.74677759061191, -15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.057126]& ,
            TagBoxNote->"0.057126"],
           StyleBox["0.057126`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.057126, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{1.791759469228055, -14.815510557964274`}, {
                1.9459101490553132`, -3.336055917331369}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{64.7490668083042, 
               68.17985999495497}, {-89.69084064749248, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.035577000000000004`]& ,
            TagBoxNote->"0.035577000000000004"],
           StyleBox["0.035577000000000004`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.035577000000000004`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{1.9459101490553132`, -14.815510557964274`}, {
                2.0794415416798357`, -3.7377756239017654`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{67.67985999495497, 
               70.7186285306922}, {-87.09849731076032, -15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.023807]& ,
            TagBoxNote->"0.023807"],
           StyleBox["0.023807`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.023807, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{2.0794415416798357`, -14.815510557964274`}, {
                2.1972245773362196`, -4.090731098652265}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{70.2186285306922, 
               72.95798108360728}, {-84.82083515436759, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.01672700000000001]& ,
            TagBoxNote->"0.01672700000000001"],
           StyleBox["0.01672700000000001`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.01672700000000001, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{2.1972245773362196`, -14.815510557964274`}, {
                2.302585092994046, -4.420102403526111}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{72.45798108360728, 
               74.9611502021477}, {-82.6953643508812, -15.112603358556171`}}],
             
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.012033000000000004`]& ,
            TagBoxNote->"0.012033000000000004"],
           StyleBox["0.012033000000000004`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.012033000000000004`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{2.302585092994046, -14.815510557964274`}, {
                2.3978952727983707`, -4.721479308388474}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{74.4611502021477, 
               76.77323708948418}, {-80.75054462113764, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.008902000000000002]& ,
            TagBoxNote->"0.008902000000000002"],
           StyleBox["0.008902000000000002`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.008902000000000002, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{2.3978952727983707`, -14.815510557964274`}, {
                2.4849066497880004`, -4.94991655906155}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{76.27323708948418, 
               78.42754280599527}, {-79.2764128447818, -15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.007084]& ,
            TagBoxNote->"0.007084"],
           StyleBox["0.007084`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.007084, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{2.4849066497880004`, -14.815510557964274`}, {
                2.5649493574615367`, -5.190719355950018}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{77.92754280599527, 
               79.94935654404404}, {-77.72248478058589, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.005568000000000001]& ,
            TagBoxNote->"0.005568000000000001"],
           StyleBox["0.005568000000000001`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.005568000000000001, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{2.5649493574615367`, -14.815510557964274`}, {
                2.6390573296152584`, -5.4117100539031275`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{79.44935654404404, 
               81.35833599264603}, {-76.29640646292154, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.004463999999999998]& ,
            TagBoxNote->"0.004463999999999998"],
           StyleBox["0.004463999999999998`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.004463999999999998, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{2.6390573296152584`, -14.815510557964274`}, {
                2.70805020110221, -5.637433094114667}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{80.85833599264603, 
               82.67006447745078}, {-74.83978979794654, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.003562000000000001]& ,
            TagBoxNote->"0.003562000000000001"],
           StyleBox["0.003562000000000001`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.003562000000000001, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{2.70805020110221, -14.815510557964274`}, {
                2.772588722239781, -5.841321888678262}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{82.17006447745078, 
               83.89710452838327}, {-73.5240720241443, -15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.0029050000000000005`]& ,
            TagBoxNote->"0.0029050000000000005"],
           StyleBox["0.0029050000000000005`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.0029050000000000005`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{2.772588722239781, -14.815510557964274`}, {
                2.833213344056216, -6.0372990834517815`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{83.39710452838327, 
               85.04973148249073}, {-72.25940871110973, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.002388]& ,
            TagBoxNote->"0.002388"],
           StyleBox["0.002388`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.002388, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{2.833213344056216, -14.815510557964274`}, {
                2.8903717578961645`, -6.1997194859284415`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{84.54973148249073, 
               86.13645708129835}, {-71.21129122714473, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.0020299999999999993`]& ,
            TagBoxNote->"0.0020299999999999993"],
           StyleBox["0.0020299999999999993`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.0020299999999999993`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{2.8903717578961645`, -14.815510557964274`}, {
                2.9444389791664403`, -6.354445043609991}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{85.63645708129835, 
               87.16441131346679}, {-70.21282945910686, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.0017389999999999997`]& ,
            TagBoxNote->"0.0017389999999999997"],
           StyleBox["0.0017389999999999997`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.0017389999999999997`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{2.9444389791664403`, -14.815510557964274`}, {
                2.995732273553991, -6.520454141501644}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{86.66441131346679, 
               88.13962619983877}, {-69.14155371206823, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.0014729999999999995`]& ,
            TagBoxNote->"0.0014729999999999995"],
           StyleBox["0.0014729999999999995`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.0014729999999999995`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{2.995732273553991, -14.815510557964274`}, {
                3.044522437723423, -6.654664651299975}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{87.63962619983877, 
               89.06725026794916}, {-68.27547790073842, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.001288]& ,
            TagBoxNote->"0.001288"],
           StyleBox["0.001288`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.001288, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.044522437723423, -14.815510557964274`}, {
                3.091042453358316, -6.762789508731951}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{88.56725026794916, 
               89.95171308717525}, {-67.57773579569738, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.001156]& ,
            TagBoxNote->"0.001156"],
           StyleBox["0.001156`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.001156, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.091042453358316, -14.815510557964274`}, {
                3.1354942159291497`, -6.9361547535038355`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{89.45171308717525, 
               90.79685319958477}, {-66.45898998921905, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.0009719999999999996]& ,
            TagBoxNote->"0.0009719999999999996"],
           StyleBox["0.0009719999999999996`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.0009719999999999996, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.1354942159291497`, -14.815510557964274`}, {
                3.1780538303479458`, -7.034452932028095}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{90.29685319958477, 
               91.60601880368634}, {-65.82466057011794, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000881]& ,
            TagBoxNote->"0.000881"],
           StyleBox["0.000881`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000881, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.1780538303479458`, -14.815510557964274`}, {
                3.2188758248682006`, -7.078543599962418}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{91.10601880368634, 
               92.38214787129428}, {-65.54013843350828, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.0008430000000000003]& ,
            TagBoxNote->"0.0008430000000000003"],
           StyleBox["0.0008430000000000003`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.0008430000000000003, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.2188758248682006`, -14.815510557964274`}, {
                3.258096538021482, -7.291948251814762}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{91.88214787129428, 
               93.1278325417351}, {-64.16301374131915, -15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.0006810000000000001]& ,
            TagBoxNote->"0.0006810000000000001"],
           StyleBox["0.0006810000000000001`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.0006810000000000001, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.258096538021482, -14.815510557964274`}, {
                3.295836866004329, -7.402051600796917}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{92.6278325417351, 
               93.84537135660148}, {-63.45250420340638, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00061]& ,
            TagBoxNote->"0.00061"],
           StyleBox["0.00061`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00061, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.295836866004329, -14.815510557964274`}, {
                3.332204510175204, -7.491151595582963}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{93.34537135660148, 
               94.5368119903371}, {-62.87753171883896, -15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.0005580000000000002]& ,
            TagBoxNote->"0.0005580000000000002"],
           StyleBox["0.0005580000000000002`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.0005580000000000002, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.332204510175204, -14.815510557964274`}, {
                3.367295829986474, -7.635493904311701}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{94.0368119903371, 
               95.20398647914706}, {-61.94607424707087, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00048300000000000003`]& ,
            TagBoxNote->"0.00048300000000000003"],
           StyleBox["0.00048300000000000003`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00048300000000000003`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.367295829986474, -14.815510557964274`}, {
                3.4011973816621555`, -7.660652463947856}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{94.70398647914706, 
               95.84854047514185}, {-61.78372317649143, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.0004710000000000002]& ,
            TagBoxNote->"0.0004710000000000002"],
           StyleBox["0.0004710000000000002`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.0004710000000000002, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.4011973816621555`, -14.815510557964274`}, {
                3.4339872044851463`, -7.88592141457438}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{95.34854047514185, 
               96.47195770190208}, {-60.33003680368467, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00037599999999999987`]& ,
            TagBoxNote->"0.00037599999999999987"],
           StyleBox["0.00037599999999999987`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00037599999999999987`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.4339872044851463`, -14.815510557964274`}, {
                3.4657359027997265`, -7.8806163623446865`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{95.97195770190208, 
               97.07558052607433}, {-60.36427091411971, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00037799999999999997`]& ,
            TagBoxNote->"0.00037799999999999997"],
           StyleBox["0.00037799999999999997`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00037799999999999997`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.4657359027997265`, -14.815510557964274`}, {
                3.4965075614664802`, -8.001380026139207}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{96.57558052607433, 
               97.66062736247832}, {-59.58496914217084, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00033500000000000007`]& ,
            TagBoxNote->"0.00033500000000000007"],
           StyleBox["0.00033500000000000007`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00033500000000000007`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.4965075614664802`, -14.815510557964274`}, {
                3.5263605246161616`, -7.977780110798334}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{97.16062736247832, 
               98.2282074801818}, {-59.73726210236356, -15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000343]& ,
            TagBoxNote->"0.000343"],
           StyleBox["0.000343`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000343, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{3.5263605246161616`, -14.815510557964274`}, {
                3.5553480614894135`, -8.180720954795024}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{97.7282074801818, 
               98.77933366179266}, {-58.42766156228294, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00028000000000000003`]& ,
            TagBoxNote->"0.00028000000000000003"],
           StyleBox["0.00028000000000000003`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00028000000000000003`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.5553480614894135`, -14.815510557964274`}, {
                3.58351893845611, -8.298057661499566}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{98.27933366179266, 
               99.31493307898941}, {-57.67047433744783, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00024900000000000004`]& ,
            TagBoxNote->"0.00024900000000000004"],
           StyleBox["0.00024900000000000004`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00024900000000000004`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.58351893845611, -14.815510557964274`}, {
                3.6109179126442243`, -8.377431249041079}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{98.81493307898941, 
               99.83585667765104}, {-57.158267474278404`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00022999999999999995`]& ,
            TagBoxNote->"0.00022999999999999995"],
           StyleBox["0.00022999999999999995`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00022999999999999995`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.6109179126442243`, -14.815510557964274`}, {
                3.6375861597263857`, -8.377431249041079}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{99.33585667765104, 
               100.34288731115785`}, {-57.158267474278404`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00022999999999999995`]& ,
            TagBoxNote->"0.00022999999999999995"],
           StyleBox["0.00022999999999999995`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00022999999999999995`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.6375861597263857`, -14.815510557964274`}, {
                3.6635616461296463`, -8.552820369059388}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{99.84288731115785, 
               
               100.83674681703823`}, {-56.02646136873176, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.0001930000000000001]& ,
            TagBoxNote->"0.0001930000000000001"],
           StyleBox["0.0001930000000000001`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.0001930000000000001, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.6635616461296463`, -14.815510557964274`}, {
                3.6888794541139363`, -8.537395898733758}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{100.33674681703823`, 
               101.31810219752984`}, {-56.125997244660375`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00019599999999999983`]& ,
            TagBoxNote->"0.00019599999999999983"],
           StyleBox["0.00019599999999999983`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00019599999999999983`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.6888794541139363`, -14.815510557964274`}, {
                3.713572066704308, -8.622553707074063}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{100.81810219752984`, 
               101.78757103686004`}, {-55.57646414132724, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.0001800000000000001]& ,
            TagBoxNote->"0.0001800000000000001"],
           StyleBox["0.0001800000000000001`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.0001800000000000001, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.713572066704308, -14.815510557964274`}, {
                3.7376696182833684`, -8.804875263868018}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{101.28757103686004`, 
               102.24572626564023`}, {-54.399922226237955`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00015000000000000004`]& ,
            TagBoxNote->"0.00015000000000000004"],
           StyleBox["0.00015000000000000004`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00015000000000000004`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.7376696182833684`, -14.815510557964274`}, {
                3.7612001156935624`, -8.617013526698448}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{101.74572626564023`, 
               102.69310036457759`}, {-55.612215560653006`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00018099999999999998`]& ,
            TagBoxNote->"0.00018099999999999998"],
           StyleBox["0.00018099999999999998`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00018099999999999998`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.7612001156935624`, -14.815510557964274`}, {
                3.784189633918261, -8.785072636571838}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{102.19310036457759`, 
               103.13018908486632`}, {-54.52771085119566, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00015300000000000003`]& ,
            TagBoxNote->"0.00015300000000000003"],
           StyleBox["0.00015300000000000003`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00015300000000000003`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.784189633918261, -14.815510557964274`}, {
                3.8066624897703196`, -8.910235779525845}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{102.63018908486632`, 
               103.55745475044498`}, {-53.72001873568722, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00013499999999999997`]& ,
            TagBoxNote->"0.00013499999999999997"],
           StyleBox["0.00013499999999999997`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00013499999999999997`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.8066624897703196`, -14.815510557964274`}, {
                3.828641396489095, -8.940313234763122}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{103.05745475044498`, 
               103.97532919727584`}, {-53.52592546768232, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000131]& ,
            TagBoxNote->"0.000131"],
           StyleBox["0.000131`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000131, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.828641396489095, -14.815510557964274`}, {
                3.8501476017100584`, -8.902855672228222}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{103.47532919727584`, 
               104.38421639649508`}, {-53.76764341444817, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000136]& ,
            TagBoxNote->"0.000136"],
           StyleBox["0.000136`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000136, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.8501476017100584`, -14.815510557964274`}, {
                3.871201010907891, -9.190537744680004}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{103.88421639649508`, 
               104.7844948013774}, {-51.91119800880814, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00010199999999999992`]& ,
            TagBoxNote->"0.00010199999999999992"],
           StyleBox["0.00010199999999999992`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00010199999999999992`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.871201010907891, -14.815510557964274`}, {
                3.8918202981106265`, -9.152071463852208}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{104.2844948013774, 
               105.17651945229099`}, {-52.159425330400424`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00010599999999999993`]& ,
            TagBoxNote->"0.00010599999999999993"],
           StyleBox["0.00010599999999999993`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00010599999999999993`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.8918202981106265`, -14.815510557964274`}, {
                3.912023005428146, -9.171119658822901}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{104.67651945229099`, 
               105.56062386898535`}, {-52.03650514375929, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00010400000000000003`]& ,
            TagBoxNote->"0.00010400000000000003"],
           StyleBox["0.00010400000000000003`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00010400000000000003`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.912023005428146, -14.815510557964274`}, {
                3.9318256327243257`, -9.433483923290392}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{105.06062386898535`, 
               105.93712175548487`}, {-50.343438456552235`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00008]& ,
            TagBoxNote->"0.00008"],
           StyleBox["0.00008`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00008, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.9318256327243257`, -14.815510557964274`}, {
                3.9512437185814275`, -9.293721980915233}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{105.43712175548487`, 
               106.30630853942617`}, {-51.24533829895267, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00009200000000000005]& ,
            TagBoxNote->"0.00009200000000000005"],
           StyleBox["0.00009200000000000005`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00009200000000000005, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.9512437185814275`, -14.815510557964274`}, {
                3.970291913552122, -9.396669950167675}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{105.80630853942617`, 
               106.6684627647638}, {-50.581003247032804`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00008300000000000007]& ,
            TagBoxNote->"0.00008300000000000007"],
           StyleBox["0.00008300000000000007`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00008300000000000007, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.970291913552122, -14.815510557964274`}, {
                3.9889840465642745`, -9.498022444427964}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{106.1684627647638, 
               107.02384735429254`}, {-49.92696397821043, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00007500000000000001]& ,
            TagBoxNote->"0.00007500000000000001"],
           StyleBox["0.00007500000000000001`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00007500000000000001, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{3.9889840465642745`, -14.815510557964274`}, {
                4.007333185232471, -9.484777217677943}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{106.52384735429254`, 
               107.37271075632182`}, {-50.01243694542446, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00007600000000000003]& ,
            TagBoxNote->"0.00007600000000000003"],
           StyleBox["0.00007600000000000003`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00007600000000000003, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.007333185232471, -14.815510557964274`}, {
                4.02535169073515, -9.484777217677943}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{106.87271075632182`, 
               107.71528798802822`}, {-50.01243694542446, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00007600000000000003]& ,
            TagBoxNote->"0.00007600000000000003"],
           StyleBox["0.00007600000000000003`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00007600000000000003, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.02535169073515, -14.815510557964274`}, {
                4.04305126783455, -9.433483923290392}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{107.21528798802822`, 
               108.05180158646093`}, {-50.343438456552235`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00008]& ,
            TagBoxNote->"0.00008"],
           StyleBox["0.00008`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00008, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.04305126783455, -14.815510557964274`}, {
                4.060443010546419, -9.721165995742174}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{107.55180158646093`, 
               108.38246247683813`}, {-48.48699305091221, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00005999999999999996]& ,
            TagBoxNote->"0.00005999999999999996"],
           StyleBox["0.00005999999999999996`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00005999999999999996, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.060443010546419, -14.815510557964274`}, {
                4.07753744390572, -9.737973114058555}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{107.88246247683813`, 
               108.70747076661817`}, {-48.378534788933706`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00005899999999999999]& ,
            TagBoxNote->"0.00005899999999999999"],
           StyleBox["0.00005899999999999999`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00005899999999999999, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.07753744390572, -14.815510557964274`}, {
                4.0943445622221, -9.672375831572742}, "RoundingRadius" -> 0]},
              
              
              ImageSizeCache->{{108.20747076661817`, 
               109.02701647283291`}, {-48.80184157567715, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00006299999999999997]& ,
            TagBoxNote->"0.00006299999999999997"],
           StyleBox["0.00006299999999999997`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00006299999999999997, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.0943445622221, -14.815510557964274`}, {
                4.110873864173311, -9.864266839382847}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{108.52701647283291`, 
               109.34128018930167`}, {-47.56354689573177, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00005200000000000001]& ,
            TagBoxNote->"0.00005200000000000001"],
           StyleBox["0.00005200000000000001`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00005200000000000001, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.110873864173311, -14.815510557964274`}, {
                4.127134385045092, -9.883684925239947}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{108.84128018930167`, 
               109.65043369959315`}, {-47.43823976078063, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00005100000000000005]& ,
            TagBoxNote->"0.00005100000000000005"],
           StyleBox["0.00005100000000000005`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00005100000000000005, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.127134385045092, -14.815510557964274`}, {
                4.143134726391533, -10.101938491259967`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{109.15043369959315`, 
               109.9546405409433}, {-46.02982446938172, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00004099999999999999]& ,
            TagBoxNote->"0.00004099999999999999"],
           StyleBox["0.00004099999999999999`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00004099999999999999, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.143134726391533, -14.815510557964274`}, {
                4.1588830833596715`, -9.826526511399999}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{109.4546405409433, 
               110.2540565237654}, {-47.80708956036148, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00005400000000000003]& ,
            TagBoxNote->"0.00005400000000000003"],
           StyleBox["0.00005400000000000003`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00005400000000000003, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.1588830833596715`, -14.815510557964274`}, {
                4.174387269895637, -9.923690259853647}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{109.7540565237654, 
               110.54883021088168`}, {-47.180080748605334`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00004900000000000004]& ,
            TagBoxNote->"0.00004900000000000004"],
           StyleBox["0.00004900000000000004`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00004900000000000004, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.174387269895637, -14.815510557964274`}, {
                4.189654742026425, -10.101938491259967`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{110.04883021088168`, 
               110.83910336016939`}, {-46.02982446938172, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00004099999999999999]& ,
            TagBoxNote->"0.00004099999999999999"],
           StyleBox["0.00004099999999999999`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00004099999999999999, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.189654742026425, -14.815510557964274`}, {
                4.204692619390966, -10.20459264532005}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{110.33910336016939`, 
               111.12501133391996`}, {-45.36738544059364, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000037]& ,
            TagBoxNote->"0.000037"],
           StyleBox["0.000037`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000037, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.204692619390966, -14.815510557964274`}, {
                4.219507705176107, -9.845218644412153}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{110.62501133391996`, 
               111.40668347787286`}, {-47.6864670823729, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00005299999999999996]& ,
            TagBoxNote->"0.00005299999999999996"],
           StyleBox["0.00005299999999999996`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00005299999999999996, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.219507705176107, -14.815510557964274`}, {
                4.23410650459726, -10.077840939680906`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{110.90668347787286`, 
               111.68424347257897`}, {-46.18532873328965, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000042000000000000004`]& ,
            TagBoxNote->"0.000042000000000000004"],
           StyleBox["0.000042000000000000004`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000042000000000000004`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.23410650459726, -14.815510557964274`}, {
                4.248495242049359, -10.557414019942792`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{111.18424347257897`, 
               111.95780965948373`}, {-43.09058864770424, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000026000000000000002`]& ,
            TagBoxNote->"0.000026000000000000002"],
           StyleBox["0.000026000000000000002`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000026000000000000002`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.248495242049359, -14.815510557964274`}, {
                4.2626798770413155`, -10.319002996497794`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{111.45780965948373`, 
               112.2274953438812}, {-44.629082323574806`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000033]& ,
            TagBoxNote->"0.000033"],
           StyleBox["0.000033`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000033, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.2626798770413155`, -14.815510557964274`}, {
                4.276666119016055, -10.557414019942792`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{111.7274953438812, 
               112.49340907668048`}, {-43.09058864770424, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000026000000000000002`]& ,
            TagBoxNote->"0.000026000000000000002"],
           StyleBox["0.000026000000000000002`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000026000000000000002`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{4.276666119016055, -14.815510557964274`}, {
                4.290459441148391, -10.20459264532005}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{111.99340907668048`, 
               112.755654916738}, {-45.36738544059364, -15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000037]& ,
            TagBoxNote->"0.000037"],
           StyleBox["0.000037`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000037, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.290459441148391, -14.815510557964274`}, {
                4.30406509320417, -10.4482147279778}, "RoundingRadius" -> 0]},
              
              
              ImageSizeCache->{{112.255654916738, 
               113.0143326753421}, {-43.7952642020057, -15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00002899999999999998]& ,
            TagBoxNote->"0.00002899999999999998"],
           StyleBox["0.00002899999999999998`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00002899999999999998, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.30406509320417, -14.815510557964274`}, {
                4.31748811353631, -10.48330604778907}, "RoundingRadius" -> 0]},
              ImageSizeCache->{{112.5143326753421, 
               113.26953814428842`}, {-43.56881589090216, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000028000000000000023`]& ,
            TagBoxNote->"0.000028000000000000023"],
           StyleBox["0.000028000000000000023`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000028000000000000023`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.31748811353631, -14.815510557964274`}, {
                4.330733340286331, -10.319002996497794`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{112.76953814428842`, 
               113.52136330884892`}, {-44.629082323574806`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000033]& ,
            TagBoxNote->"0.000033"],
           StyleBox["0.000033`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000033, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.330733340286331, -14.815510557964274`}, {
                4.343805421853684, -10.381523353479128`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{113.02136330884892`, 
               113.76989654682015`}, {-44.22563128998138, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00003099999999999999]& ,
            TagBoxNote->"0.00003099999999999999"],
           StyleBox["0.00003099999999999999`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00003099999999999999, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.343805421853684, -14.815510557964274`}, {
                4.356708826689592, -10.519673691959945`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{113.26989654682015`, 
               114.0152228147293}, {-43.33413131233395, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000027000000000000013`]& ,
            TagBoxNote->"0.000027000000000000013"],
           StyleBox["0.000027000000000000013`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000027000000000000013`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.356708826689592, -14.815510557964274`}, {
                4.3694478524670215`, -10.871071578797833`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{113.5152228147293, 
               114.25742382217797`}, {-41.066520449369406`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000019000000000000004`]& ,
            TagBoxNote->"0.000019000000000000004"],
           StyleBox["0.000019000000000000004`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000019000000000000004`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.3694478524670215`, -14.815510557964274`}, {
                4.382026634673881, -10.724468104605958`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{113.75742382217797`, 
               114.4965781952209}, {-42.01256948118731, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000022000000000000016`]& ,
            TagBoxNote->"0.000022000000000000016"],
           StyleBox["0.000022000000000000016`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000022000000000000016`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.382026634673881, -14.815510557964274`}, {
                4.394449154672439, -10.982297213908058`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{113.9965781952209, 
               114.73276162959567`}, {-40.3487686703656, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000016999999999999993`]& ,
            TagBoxNote->"0.000016999999999999993"],
           StyleBox["0.000016999999999999993`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000016999999999999993`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.394449154672439, -14.815510557964274`}, {
                4.406719247264253, -10.724468104605958`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{114.23276162959567`, 
               114.96604703455111`}, {-42.01256948118731, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000022000000000000016`]& ,
            TagBoxNote->"0.000022000000000000016"],
           StyleBox["0.000022000000000000016`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000022000000000000016`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.406719247264253, -14.815510557964274`}, {
                4.418840607796598, -10.4482147279778}, "RoundingRadius" -> 0]},
              
              ImageSizeCache->{{114.46604703455111`, 
               115.19650466795852`}, {-43.7952642020057, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00002899999999999998]& ,
            TagBoxNote->"0.00002899999999999998"],
           StyleBox["0.00002899999999999998`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00002899999999999998, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.418840607796598, -14.815510557964274`}, {
                4.430816798843313, -11.176453228349015`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{114.69650466795852`, 
               115.4242022633313}, {-39.095857642874634`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00001400000000000001]& ,
            TagBoxNote->"0.00001400000000000001"],
           StyleBox["0.00001400000000000001`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00001400000000000001, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.430816798843313, -14.815510557964274`}, {
                4.442651256490317, -10.92513880006811}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{114.9242022633313, 
               115.64920514932837`}, {-40.717618469946444`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00001799999999999999]& ,
            TagBoxNote->"0.00001799999999999999"],
           StyleBox["0.00001799999999999999`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00001799999999999999, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.442651256490317, -14.815510557964274`}, {
                4.454347296253507, -10.819778284410283`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{115.14920514932837`, 
               115.87157636226866`}, {-41.39752196049719, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000019999999999999998`]& ,
            TagBoxNote->"0.000019999999999999998"],
           StyleBox["0.000019999999999999998`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000019999999999999998`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.454347296253507, -14.815510557964274`}, {
                4.465908118654584, -10.724468104605958`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{115.37157636226866`, 
               116.0913767521412}, {-42.01256948118731, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000022000000000000016`]& ,
            TagBoxNote->"0.000022000000000000016"],
           StyleBox["0.000022000000000000016`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000022000000000000016`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.465908118654584, -14.815510557964274`}, {
                4.477336814478207, -10.724468104605958`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{115.5913767521412, 
               116.30866508255738`}, {-42.01256948118731, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000022000000000000016`]& ,
            TagBoxNote->"0.000022000000000000016"],
           StyleBox["0.000022000000000000016`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000022000000000000016`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.477336814478207, -14.815510557964274`}, {
                4.48863636973214, -11.330603908176274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{115.80866508255738`, 
               116.52349812505528`}, {-38.10110562755895, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000012]& ,
            TagBoxNote->"0.000012"],
           StyleBox["0.000012`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000012, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.48863636973214, -14.815510557964274`}, {
                4.499809670330265, -11.042921835724492`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{116.02349812505528`, 
               116.73593074813604`}, {-39.95755103319897, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000016000000000000013`]& ,
            TagBoxNote->"0.000016000000000000013"],
           StyleBox["0.000016000000000000013`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000016000000000000013`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.499809670330265, -14.815510557964274`}, {
                4.51085950651685, -11.107460356862065`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{116.23593074813604`, 
               116.94601600138006`}, {-39.541076554857156`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000014999999999999987`]& ,
            TagBoxNote->"0.000014999999999999987"],
           StyleBox["0.000014999999999999987`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000014999999999999987`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.51085950651685, -14.815510557964274`}, {
                4.5217885770490405`, -11.618285980628055`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{116.44601600138006`, 
               117.1538051949669}, {-36.24466022191892, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 8.999999999999993*^-6]& ,
            TagBoxNote->"8.999999999999993*^-6"],
           StyleBox["8.999999999999993`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[8.999999999999993*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.5217885770490405`, -14.815510557964274`}, {
                4.532599493153256, -10.724468104605958`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{116.6538051949669, 
               117.35934797489622`}, {-42.01256948118731, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000022000000000000016`]& ,
            TagBoxNote->"0.000022000000000000016"],
           StyleBox["0.000022000000000000016`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000022000000000000016`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.532599493153256, -14.815510557964274`}, {
                4.543294782270004, -11.330603908176274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{116.85934797489622`, 
               117.56269239418614`}, {-38.10110562755895, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000012]& ,
            TagBoxNote->"0.000012"],
           StyleBox["0.000012`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000012, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.543294782270004, -14.815510557964274`}, {
                4.553876891600541, -10.819778284410283`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{117.06269239418614`, 
               117.76388498030443`}, {-41.39752196049719, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000019999999999999998`]& ,
            TagBoxNote->"0.000019999999999999998"],
           StyleBox["0.000019999999999999998`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000019999999999999998`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.553876891600541, -14.815510557964274`}, {
                4.564348191467836, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{117.26388498030443`, 
               
               117.96297079906847`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.564348191467836, -14.815510557964274`}, {
                4.574710978503383, -11.107460356862065`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{117.46297079906847`, 
               118.15999351523507`}, {-39.541076554857156`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000014999999999999987`]& ,
            TagBoxNote->"0.000014999999999999987"],
           StyleBox["0.000014999999999999987`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000014999999999999987`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.574710978503383, -14.815510557964274`}, {
                4.584967478670572, -11.176453228349015`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{117.65999351523507`, 
               118.35499544998206`}, {-39.095857642874634`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00001400000000000001]& ,
            TagBoxNote->"0.00001400000000000001"],
           StyleBox["0.00001400000000000001`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00001400000000000001, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.584967478670572, -14.815510557964274`}, {
                4.59511985013459, -11.042921835724492`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{117.85499544998206`, 
               118.54801763547246`}, {-39.95755103319897, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000016000000000000013`]& ,
            TagBoxNote->"0.000016000000000000013"],
           StyleBox["0.000016000000000000013`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000016000000000000013`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.59511985013459, -14.815510557964274`}, {
                4.605170185988092, -11.618285980628055`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{118.04801763547246`, 
               118.73909986667641`}, {-36.24466022191892, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 8.999999999999993*^-6]& ,
            TagBoxNote->"8.999999999999993*^-6"],
           StyleBox["8.999999999999993`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[8.999999999999993*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.605170185988092, -14.815510557964274`}, {
                4.61512051684126, -11.512925464970229`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{118.23909986667641`, 
               118.92828075061456`}, {-36.92456371246966, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 9.999999999999997*^-6]& ,
            TagBoxNote->"9.999999999999997*^-6"],
           StyleBox["9.999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[9.999999999999997*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.61512051684126, -14.815510557964274`}, {
                4.624972813284271, -11.512925464970229`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{118.42828075061456`, 
               119.11559775317593`}, {-36.92456371246966, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 9.999999999999997*^-6]& ,
            TagBoxNote->"9.999999999999997*^-6"],
           StyleBox["9.999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[9.999999999999997*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.624972813284271, -14.815510557964274`}, {
                4.634728988229636, -11.512925464970229`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{118.61559775317593`, 
               119.30108724365166`}, {-36.92456371246966, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 9.999999999999997*^-6]& ,
            TagBoxNote->"9.999999999999997*^-6"],
           StyleBox["9.999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[9.999999999999997*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.634728988229636, -14.815510557964274`}, {
                4.6443908991413725`, -11.512925464970229`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{118.80108724365166`, 
               119.48478453711724`}, {-36.92456371246966, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 9.999999999999997*^-6]& ,
            TagBoxNote->"9.999999999999997*^-6"],
           StyleBox["9.999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[9.999999999999997*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.6443908991413725`, -14.815510557964274`}, {
                4.653960350157523, -11.618285980628055`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{118.98478453711724`, 
               119.6667239347868}, {-36.24466022191892, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 8.999999999999993*^-6]& ,
            TagBoxNote->"8.999999999999993*^-6"],
           StyleBox["8.999999999999993`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[8.999999999999993*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.653960350157523, -14.815510557964274`}, {
                4.663439094112067, -11.330603908176274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{119.1667239347868, 
               119.84693876245487`}, {-38.10110562755895, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000012]& ,
            TagBoxNote->"0.000012"],
           StyleBox["0.000012`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000012, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.663439094112067, -14.815510557964274`}, {
                4.672828834461906, -11.618285980628055`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{119.34693876245487`, 
               120.02546140713324`}, {-36.24466022191892, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 8.999999999999993*^-6]& ,
            TagBoxNote->"8.999999999999993*^-6"],
           StyleBox["8.999999999999993`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[8.999999999999993*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.672828834461906, -14.815510557964274`}, {
                4.68213122712422, -11.107460356862065`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{119.52546140713324`, 
               120.20232335198361`}, {-39.541076554857156`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000014999999999999987`]& ,
            TagBoxNote->"0.000014999999999999987"],
           StyleBox["0.000014999999999999987`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000014999999999999987`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.68213122712422, -14.815510557964274`}, {
                4.6913478822291435`, -11.618285980628055`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{119.70232335198361`, 
               120.37755520964063`}, {-36.24466022191892, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 8.999999999999993*^-6]& ,
            TagBoxNote->"8.999999999999993*^-6"],
           StyleBox["8.999999999999993`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[8.999999999999993*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.6913478822291435`, -14.815510557964274`}, {
                4.700480365792417, -11.512925464970229`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{119.87755520964063`, 
               120.55118675401289`}, {-36.92456371246966, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 9.999999999999997*^-6]& ,
            TagBoxNote->"9.999999999999997*^-6"],
           StyleBox["9.999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[9.999999999999997*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.700480365792417, -14.815510557964274`}, {
                4.709530201312334, -12.02375108873622}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{120.05118675401289`, 
               120.72324695064518`}, {-33.62814737953143, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 6.*^-6]& ,
            TagBoxNote->"6.*^-6"],
           StyleBox["6.`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[6.*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.709530201312334, -14.815510557964274`}, {
                4.718498871295094, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{120.22324695064518`, 
               120.89376398571923`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.718498871295094, -14.815510557964274`}, {
                4.727387818712341, -11.618285980628055`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{120.39376398571923`, 
               121.06276529376512`}, {-36.24466022191892, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 8.999999999999993*^-6]& ,
            TagBoxNote->"8.999999999999993*^-6"],
           StyleBox["8.999999999999993`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[8.999999999999993*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.727387818712341, -14.815510557964274`}, {
                4.736198448394496, -11.736069016284437`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{120.56276529376512`, 
               121.23027758415199`}, {-35.48459278517144, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 8.000000000000006*^-6]& ,
            TagBoxNote->"8.000000000000006*^-6"],
           StyleBox["8.000000000000006`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[8.000000000000006*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.736198448394496, -14.815510557964274`}, {
                4.74493212836325, -11.330603908176274`}, "RoundingRadius" -> 
                0]},
              ImageSizeCache->{{120.73027758415199`, 
               121.39632686642241`}, {-38.10110562755895, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000012]& ,
            TagBoxNote->"0.000012"],
           StyleBox["0.000012`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000012, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.74493212836325, -14.815510557964274`}, {
                4.7535901911063645`, -11.86960040890896}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{120.89632686642241`, 
               121.5609384745292}, {-34.622899394847096`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 7.000000000000004*^-6]& ,
            TagBoxNote->"7.000000000000004*^-6"],
           StyleBox["7.000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[7.000000000000004*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.7535901911063645`, -14.815510557964274`}, {
                4.762173934797756, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{121.0609384745292, 
               121.72413709003237`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.762173934797756, -14.815510557964274`}, {
                4.770684624465665, -12.02375108873622}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{121.22413709003237`, 
               121.88594676430924`}, {-33.62814737953143, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 6.*^-6]& ,
            TagBoxNote->"6.*^-6"],
           StyleBox["6.`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[6.*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.770684624465665, -14.815510557964274`}, {
                4.77912349311153, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{121.38594676430924`, 
               122.0463909398267}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.77912349311153, -14.815510557964274`}, {
                4.787491742782046, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{121.5463909398267, 
               122.20549247052398`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.787491742782046, -14.815510557964274`}, {
                4.795790545596741, -12.02375108873622}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{121.70549247052398`, 
               122.36327364134937`}, {-33.62814737953143, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 6.*^-6]& ,
            TagBoxNote->"6.*^-6"],
           StyleBox["6.`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[6.*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.795790545596741, -14.815510557964274`}, {
                4.804021044733257, -11.736069016284437`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{121.86327364134937`, 
               122.51975618699274`}, {-35.48459278517144, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 8.000000000000006*^-6]& ,
            TagBoxNote->"8.000000000000006*^-6"],
           StyleBox["8.000000000000006`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[8.000000000000006*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.804021044733257, -14.815510557964274`}, {
                4.812184355372417, -11.86960040890896}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{122.01975618699274`, 
               122.67496130985424`}, {-34.622899394847096`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 7.000000000000004*^-6]& ,
            TagBoxNote->"7.000000000000004*^-6"],
           StyleBox["7.000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[7.000000000000004*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.812184355372417, -14.815510557964274`}, {
                4.820281565605037, -12.02375108873622}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{122.17496130985424`, 
               122.82890969728422`}, {-33.62814737953143, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 6.*^-6]& ,
            TagBoxNote->"6.*^-6"],
           StyleBox["6.`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[6.*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.820281565605037, -14.815510557964274`}, {
                4.8283137373023015`, -11.736069016284437`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{122.32890969728422`, 
               122.98162153813192`}, {-35.48459278517144, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 8.000000000000006*^-6]& ,
            TagBoxNote->"8.000000000000006*^-6"],
           StyleBox["8.000000000000006`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[8.000000000000006*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.8283137373023015`, -14.815510557964274`}, {
                4.836281906951478, -11.176453228349015`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{122.48162153813192`, 
               123.13311653863437`}, {-39.095857642874634`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.00001400000000000001]& ,
            TagBoxNote->"0.00001400000000000001"],
           StyleBox["0.00001400000000000001`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.00001400000000000001, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.836281906951478, -14.815510557964274`}, {
                4.844187086458591, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{122.63311653863437`, 
               123.28341393767707`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{4.844187086458591, -14.815510557964274`}, {
                4.852030263919617, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{122.78341393767707`, 
               123.43253252145647`}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.852030263919617, -14.815510557964274`}, {
                4.859812404361672, -11.250561200502737`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{122.93253252145647`, 
               123.58049063757173`}, {-38.61763039967671, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000013000000000000001`]& ,
            TagBoxNote->"0.000013000000000000001"],
           StyleBox["0.000013000000000000001`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000013000000000000001`, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.859812404361672, -14.815510557964274`}, {
                4.867534450455582, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{123.08049063757173`, 
               123.72730620857274`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.867534450455582, -14.815510557964274`}, {
                4.875197323201151, -11.618285980628055`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{123.22730620857274`, 
               123.87299674498851`}, {-36.24466022191892, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 8.999999999999993*^-6]& ,
            TagBoxNote->"8.999999999999993*^-6"],
           StyleBox["8.999999999999993`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[8.999999999999993*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.875197323201151, -14.815510557964274`}, {
                4.882801922586371, -12.02375108873622}, "RoundingRadius" -> 
                0]},
              ImageSizeCache->{{123.37299674498851`, 
               124.01757935786046`}, {-33.62814737953143, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 6.*^-6]& ,
            TagBoxNote->"6.*^-6"],
           StyleBox["6.`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[6.*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.882801922586371, -14.815510557964274`}, {
                4.890349128221754, -11.330603908176274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{123.51757935786046`, 
               124.16107077080275`}, {-38.10110562755895, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 0.000012]& ,
            TagBoxNote->"0.000012"],
           StyleBox["0.000012`", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[0.000012, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.890349128221754, -14.815510557964274`}, {
                4.897839799950911, -11.736069016284437`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{123.66107077080275`, 
               124.30348733161102`}, {-35.48459278517144, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 8.000000000000006*^-6]& ,
            TagBoxNote->"8.000000000000006*^-6"],
           StyleBox["8.000000000000006`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[8.000000000000006*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.897839799950911, -14.815510557964274`}, {
                4.90527477843843, -11.736069016284437`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{123.80348733161102`, 
               124.44484502343911`}, {-35.48459278517144, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 8.000000000000006*^-6]& ,
            TagBoxNote->"8.000000000000006*^-6"],
           StyleBox["8.000000000000006`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[8.000000000000006*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.90527477843843, -14.815510557964274`}, {
                4.912654885736052, -12.02375108873622}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{123.94484502343911`, 
               124.58515947556393`}, {-33.62814737953143, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 6.*^-6]& ,
            TagBoxNote->"6.*^-6"],
           StyleBox["6.`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[6.*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.912654885736052, -14.815510557964274`}, {
                4.919980925828125, -11.86960040890896}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{124.08515947556393`, 
               124.72444597375542`}, {-34.622899394847096`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 7.000000000000004*^-6]& ,
            TagBoxNote->"7.000000000000004*^-6"],
           StyleBox["7.000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[7.000000000000004*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.919980925828125, -14.815510557964274`}, {
                4.927253685157205, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{124.22444597375542`, 
               124.86271947027004`}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.927253685157205, -14.815510557964274`}, {
                4.9344739331306915`, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{124.36271947027004`, 
               124.9999945934828}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.9344739331306915`, -14.815510557964274`}, {
                4.941642422609304, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{124.4999945934828, 
               125.1362856571748}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.941642422609304, -14.815510557964274`}, {
                4.948759890378168, -11.736069016284437`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{124.6362856571748, 
               125.27160666948927`}, {-35.48459278517144, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 8.000000000000006*^-6]& ,
            TagBoxNote->"8.000000000000006*^-6"],
           StyleBox["8.000000000000006`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[8.000000000000006*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.948759890378168, -14.815510557964274`}, {
                4.955827057601261, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{124.77160666948927`, 
               125.40597134157227`}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.955827057601261, -14.815510557964274`}, {
                4.962844630259907, -11.86960040890896}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{124.90597134157227`, 
               125.53939309590922`}, {-34.622899394847096`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 7.000000000000004*^-6]& ,
            TagBoxNote->"7.000000000000004*^-6"],
           StyleBox["7.000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[7.000000000000004*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.962844630259907, -14.815510557964274`}, {
                4.969813299576001, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{125.03939309590922`, 
               125.67188507437154`}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.969813299576001, -14.815510557964274`}, {
                4.976733742420574, -11.736069016284437`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{125.17188507437154`, 
               125.8034601459847}, {-35.48459278517144, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 8.000000000000006*^-6]& ,
            TagBoxNote->"8.000000000000006*^-6"],
           StyleBox["8.000000000000006`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[8.000000000000006*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.976733742420574, -14.815510557964274`}, {
                4.983606621708336, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{125.3034601459847, 
               125.93413091442906`}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.983606621708336, -14.815510557964274`}, {
                4.990432586778736, -11.512925464970229`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{125.43413091442906`, 
               126.06390972528519`}, {-36.92456371246966, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 9.999999999999997*^-6]& ,
            TagBoxNote->"9.999999999999997*^-6"],
           StyleBox["9.999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[9.999999999999997*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.990432586778736, -14.815510557964274`}, {
                4.997212273764115, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{125.56390972528519`, 
               126.19280867303317`}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{4.997212273764115, -14.815510557964274`}, {
                5.003946305945459, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{125.69280867303317`, 
               126.32083960781651`}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.003946305945459, -14.815510557964274`}, {
                5.0106352940962555`, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{125.82083960781651`, 
               126.44801414197948`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.0106352940962555`, -14.815510557964274`}, {
                5.017279836814924, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{125.94801414197948`, 
               
               126.57434365638781`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.017279836814924, -14.815510557964274`}, {
                5.0238805208462765`, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{126.07434365638781`, 
               126.69983930653999`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.0238805208462765`, -14.815510557964274`}, {
                5.030437921392435, -12.02375108873622}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{126.19983930653999`, 
               126.82451202847906`}, {-33.62814737953143, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 6.*^-6]& ,
            TagBoxNote->"6.*^-6"],
           StyleBox["6.`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[6.*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.0369526024136295`, -14.815510557964274`}, {
                5.043425116919247, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{126.44837254451127`, 
               127.07143136873972`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.043425116919247, -14.815510557964274`}, {
                5.049856007249537, -12.02375108873622}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{126.57143136873972`, 
               127.19369881242037`}, {-33.62814737953143, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 6.*^-6]& ,
            TagBoxNote->"6.*^-6"],
           StyleBox["6.`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[6.*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.049856007249537, -14.815510557964274`}, {
                5.056245805348308, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{126.69369881242037`, 
               127.3151849891465}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.056245805348308, -14.815510557964274`}, {
                5.062595033026967, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{126.8151849891465, 
               127.43589981986904`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.062595033026967, -14.815510557964274`}, {
                5.0689042022202315`, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{126.93589981986904`, 
               127.555853037758}, {-31.01163453714392, -15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.0689042022202315`, -14.815510557964274`}, {
                5.075173815233827, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{127.055853037758, 
               127.67505419291197`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.075173815233827, -14.815510557964274`}, {
                5.081404364984463, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{127.17505419291197`, 
               127.7935126569208}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.081404364984463, -14.815510557964274`}, {
                5.087596335232384, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{127.2935126569208, 
               127.91123762728668`}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.087596335232384, -14.815510557964274`}, {
                5.093750200806762, -12.02375108873622}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{127.41123762728668`, 
               128.0282381317098}, {-33.62814737953143, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 6.*^-6]& ,
            TagBoxNote->"6.*^-6"],
           StyleBox["6.`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[6.*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.093750200806762, -14.815510557964274`}, {
                5.099866427824199, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{127.5282381317098, 
               128.14452303224218`}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{5.099866427824199, -14.815510557964274`}, {
                5.10594547390058, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{127.64452303224218`, 
               128.26010102931596`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.10594547390058, -14.815510557964274`}, {
                5.111987788356544, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{127.76010102931596`, 
               128.3749806656496}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.111987788356544, -14.815510557964274`}, {
                5.117993812416755, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{127.87498066564959`, 
               128.48917033003679`}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.117993812416755, -14.815510557964274`}, {
                5.123963979403259, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{127.98917033003679`, 
               128.60267826102236`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.123963979403259, -14.815510557964274`}, {
                5.1298987149230735`, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{128.10267826102236`, 
               
               128.71551255046913`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.1298987149230735`, -14.815510557964274`}, {
                5.135798437050262, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{128.21551255046913`, 
               128.82768114701943`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.135798437050262, -14.815510557964274`}, {
                5.14166355650266, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{128.32768114701943`, 
               128.93919185945512`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.14166355650266, -14.815510557964274`}, {
                5.147494476813453, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{128.43919185945512`, 
               129.05005235995972`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.147494476813453, -14.815510557964274`}, {
                5.153291594497779, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{128.55005235995972`, 
               129.16027018728605`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.153291594497779, -14.815510557964274`}, {
                5.159055299214529, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{128.66027018728605`, 
               129.26985274983227`}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.159055299214529, -14.815510557964274`}, {
                5.1647859739235145`, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{128.76985274983227`, 
               129.3788073286303}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.1647859739235145`, -14.815510557964274`}, {
                5.170483995038151, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{128.8788073286303, 
               129.4871410802484}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.170483995038151, -14.815510557964274`}, {
                5.176149732573829, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{128.9871410802484, 
               129.5948610396123}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.176149732573829, -14.815510557964274`}, {
                5.181783550292085, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{129.0948610396123, 
               129.70197412274635`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.181783550292085, -14.815510557964274`}, {
                5.187385805840755, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{129.20197412274635`, 
               129.80848712943768`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.187385805840755, -14.815510557964274`}, {
                5.19295685089021, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{129.30848712943768`, 
               129.9144067458271}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.19295685089021, -14.815510557964274`}, {
                5.198497031265826, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{129.4144067458271, 
               130.01973954692707`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.198497031265826, -14.815510557964274`}, {
                5.204006687076795, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{129.51973954692707`, 
               130.12449199907113`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.204006687076795, -14.815510557964274`}, {
                5.209486152841421, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{129.62449199907113`, 
               130.22867046229587`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.209486152841421, -14.815510557964274`}, {
                5.214935757608986, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{129.72867046229587`, 
               130.33228119265797`}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.214935757608986, -14.815510557964274`}, {
                5.220355825078324, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{129.83228119265797`, 
               130.43533034448868`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.220355825078324, -14.815510557964274`}, {
                5.225746673713202, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{129.93533034448868`, 
               130.5378239725873}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.225746673713202, -14.815510557964274`}, {
                5.231108616854587, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{130.0378239725873, 
               130.63976803435585`}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{5.231108616854587, -14.815510557964274`}, {
                5.236441962829949, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{130.13976803435585`, 
               130.7411683918772}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.236441962829949, -14.815510557964274`}, {
                5.241747015059643, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{130.2411683918772, 
               130.8420308139375}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.241747015059643, -14.815510557964274`}, {
                5.247024072160486, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{130.3420308139375, 
               130.9423609779955}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.247024072160486, -14.815510557964274`}, {
                5.25227342804663, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{130.4423609779955, 
               131.04216447210044`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.2574953720277815`, -14.815510557964274`}, {
                5.262690188904886, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{130.64144679675954`, 
               131.240213366757}, {-29.15518913150389, -15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.262690188904886, -14.815510557964274`}, {
                5.267858159063328, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{130.740213366757, 
               131.33846951292614`}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.267858159063328, -14.815510557964274`}, {
                5.272999558563747, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{130.83846951292614`, 
               131.43622048387587`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.272999558563747, -14.815510557964274`}, {
                5.278114659230517, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{130.93622048387587`, 
               131.53347144767312`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.278114659230517, -14.815510557964274`}, {
                5.2832037287379885`, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{131.03347144767312`, 
               131.63022749348235`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.2832037287379885`, -14.815510557964274`}, {
                5.288267030694535, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{131.13022749348235`, 
               131.72649363316353`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.288267030694535, -14.815510557964274`}, {
                5.293304824724492, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{131.22649363316353`, 
               131.8222748028301}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.293304824724492, -14.815510557964274`}, {
                5.298317366548036, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{131.3222748028301, 
               131.91757586436748`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.298317366548036, -14.815510557964274`}, {
                5.303304908059076, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{131.41757586436748`, 
               132.0124016069141}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.303304908059076, -14.815510557964274`}, {
                5.308267697401205, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{131.5124016069141, 
               132.10675674830563`}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.308267697401205, -14.815510557964274`}, {
                5.313205979041787, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{131.60675674830563`, 
               132.20064593648308`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.318119993844216, -14.815510557964274`}, {
                5.3230099791384085`, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{131.794073750867, 
               132.38704470369774`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.3230099791384085`, -14.815510557964274`}, {
                5.327876168789581, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{131.88704470369774`, 
               132.47956324134273`}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.327876168789581, -14.815510557964274`}, {
                5.332718793265369, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{131.97956324134273`, 
               132.5716337455731}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.332718793265369, -14.815510557964274`}, {
                5.337538079701318, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{132.0716337455731, 
               132.6632605348083}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{5.337538079701318, -14.815510557964274`}, {
                5.342334251964811, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{132.1632605348083, 
               132.75444786533197`}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.342334251964811, -14.815510557964274`}, {
                5.3471075307174685`, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{132.25444786533197`, 
               132.84519993247787`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.3471075307174685`, -14.815510557964274`}, {
                5.351858133476067, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{132.34519993247787`, 
               132.93552087178855`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.3612921657094255`, -14.815510557964274`}, {
                5.365976015021851, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{132.6148856168754, 
               133.2039374048243}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.365976015021851, -14.815510557964274`}, {
                5.3706380281276624`, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{132.7039374048243, 
               133.29257403141523`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.3706380281276624`, -14.815510557964274`}, {
                5.375278407684165, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{132.79257403141523`, 
               133.38079934967467`}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.375278407684165, -14.815510557964274`}, {
                5.37989735354046, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{132.88079934967467`, 
               
               133.46861715923805`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.37989735354046, -14.815510557964274`}, {
                5.384495062789089, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{132.96861715923805`, 
               133.5560312073317}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.384495062789089, -14.815510557964274`}, {
                5.389071729816501, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{133.0560312073317, 
               133.64304518973213`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.389071729816501, -14.815510557964274`}, {
                5.393627546352362, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{133.14304518973213`, 
               133.72966275170396`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.3981627015177525`, -14.815510557964274`}, {
                5.402677381872279, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{133.31588748891576`, 
               133.90172294833624`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.402677381872279, -14.815510557964274`}, {
                5.407171771460119, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{133.40172294833624`, 
               133.98717262910932`}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.407171771460119, -14.815510557964274`}, {
                5.4116460518550396`, -12.02375108873622}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{133.48717262910932`, 
               134.0722399834103}, {-33.62814737953143, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 6.*^-6]& ,
            TagBoxNote->"6.*^-6"],
           StyleBox["6.`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[6.*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.41610040220442, -14.815510557964274`}, {
                5.420534999272286, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{133.65692841728261`, 
               134.2412412914562}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.429345628954441, -14.815510557964274`}, {
                5.43372200355424, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{133.90875358184306`, 
               134.49195950006347`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.43372200355424, -14.815510557964274`}, {
                5.438079308923196, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{133.99195950006347`, 
               134.57480286411348`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.438079308923196, -14.815510557964274`}, {
                5.442417710521793, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{134.07480286411348`, 
               134.65728681981435`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.442417710521793, -14.815510557964274`}, {
                5.44673737166631, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{134.15728681981435`, 
               134.73941447222026`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.44673737166631, -14.815510557964274`}, {
                5.4510384535657, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{134.23941447222026`, 
               134.82118888632002`}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.4510384535657, -14.815510557964274`}, {
                5.455321115357702, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{134.32118888632002`, 
               134.9026130877235}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.455321115357702, -14.815510557964274`}, {
                5.459585514144159, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{134.4026130877235, 
               134.98369006333277`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.459585514144159, -14.815510557964274`}, {
                5.4638318050256105`, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{134.48369006333277`, 
               135.0644227620003}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.4638318050256105`, -14.815510557964274`}, {
                5.4680601411351315`, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{134.5644227620003, 
               135.14481409517217`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.4680601411351315`, -14.815510557964274`}, {
                5.472270673671475, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{134.64481409517217`, 
               135.22486693751776`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.472270673671475, -14.815510557964274`}, {
                5.476463551931511, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{134.72486693751776`, 
               135.30458412754732`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.476463551931511, -14.815510557964274`}, {
                5.480638923341991, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{134.80458412754732`, 
               135.38396846821504`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.480638923341991, -14.815510557964274`}, {
                5.484796933490655, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{134.88396846821504`, 
               135.46302272751112`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.497168225293202, -14.815510557964274`}, {
                5.501258210544727, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{135.1982321846838, 
               135.77599311912869`}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.5134287461649825`, -14.815510557964274`}, {
                5.517452896464707, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{135.50738569497528`, 
               136.08389494095266`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.5254529391317835`, -14.815510557964274`}, {
                5.529429087511423, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{135.73599592790814`, 
               136.31159253632543`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.53338948872752, -14.815510557964274`}, {
                5.537334267018537, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{135.88688975144996`, 
               136.46188993536813`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.537334267018537, -14.815510557964274`}, {
                5.541263545158426, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{135.96188993536813`, 
               136.5365954223225}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.541263545158426, -14.815510557964274`}, {
                5.545177444479562, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{136.0365954223225, 
               136.61100851914753`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.54907608489522, -14.815510557964274`}, {
                5.552959584921617, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{136.1851315056969, 
               136.7589666352628}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.552959584921617, -14.815510557964274`}, {
                5.556828061699537, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{136.2589666352628, 
               136.83251613498706`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.556828061699537, -14.815510557964274`}, {
                5.560681631015528, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{136.33251613498706`, 
               136.9057822062638}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.560681631015528, -14.815510557964274`}, {
                5.564520407322694, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{136.4057822062638, 
               136.9787670251354}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.564520407322694, -14.815510557964274`}, {
                5.568344503761097, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{136.4787670251354, 
               137.05147274267958`}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.568344503761097, -14.815510557964274`}, {
                5.572154032177765, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{136.55147274267958`, 
               137.12390148539052`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.575949103146316, -14.815510557964274`}, {
                5.579729825986222, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{136.69605535555152`, 
               137.26793643160144`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.579729825986222, -14.815510557964274`}, {
                5.583496308781699, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{136.76793643160144`, 
               137.33954676849388`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.583496308781699, -14.815510557964274`}, {
                5.58724865840025, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{136.83954676849388`, 
               137.41088839804942`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.5909869805108565`, -14.815510557964274`}, {
                5.594711379601839, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{136.9819633293021, 
               137.55277354883825`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.602118820879701, -14.815510557964274`}, {
                5.605802066295998, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{137.19360768886284`, 
               137.763635473255}, {-22.06571804108887, -15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.605802066295998, -14.815510557964274`}, {
                5.60947179518496, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{137.263635473255, 
               137.8334062743742}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.6131281063880705`, -14.815510557964274`}, {
                5.616771097666572, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{137.4029219714465, 
               137.97218442315946`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.616771097666572, -14.815510557964274`}, {
                5.62040086571715, -12.206072645530174`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{137.47218442315946`, 
               138.04119546796105`}, {-32.451605464442125`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.999999999999999*^-6]& ,
            TagBoxNote->"4.999999999999999*^-6"],
           StyleBox["4.999999999999999`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.999999999999999*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.6240175061873385`, -14.815510557964274`}, {
                5.627621113690637, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{137.60995692435213`, 
               138.17847059117386`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.627621113690637, -14.815510557964274`}, {
                5.631211781821365, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{137.67847059117386`, 
               
               138.24673824789036`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.631211781821365, -14.815510557964274`}, {
                5.634789603169249, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{137.74673824789036`, 
               138.31476165486586`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.634789603169249, -14.815510557964274`}, {
                5.638354669333745, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{137.81476165486586`, 
               138.3825425536369}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.641907070938114, -14.815510557964274`}, {
                5.645446897643238, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{137.95008266718034`, 
               138.51738370017566`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.645446897643238, -14.815510557964274`}, {
                5.648974238161206, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{138.01738370017566`, 
               138.58444733926333`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.648974238161206, -14.815510557964274`}, {
                5.652489180268651, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{138.08444733926333`, 
               138.65127525329856`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.652489180268651, -14.815510557964274`}, {
                5.655991810819852, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{138.15127525329856`, 
               138.71786909360029`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.66988092298052, -14.815510557964274`}, {
                5.673323267171493, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{138.48193614367577`, 
               139.04738378822927`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.673323267171493, -14.815510557964274`}, {
                5.676753802268282, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{138.54738378822927`, 
               139.11260691212013`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.680172609017068, -14.815510557964274`}, {
                5.683579767338681, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{138.67760705053692`, 
               139.24238572297625`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.683579767338681, -14.815510557964274`}, {
                5.68697535633982, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{138.74238572297625`, 
               139.3069444334558}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.703782474656201, -14.815510557964274`}, {
                5.707110264748875, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{139.12649013967055`, 
               139.68975982191355`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.707110264748875, -14.815510557964274`}, {
                5.71042701737487, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{139.18975982191355`, 
               139.75281965407888`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.717027701406222, -14.815510557964274`}, {
                5.720311776607412, -12.716898269296165`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{139.37831530423105`, 
               139.94075385613937`}, {-29.15518913150389, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.9999999999999997`*^-6]& ,
            TagBoxNote->"2.9999999999999997*^-6"],
           StyleBox["2.9999999999999997`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.9999999999999997`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.720311776607412, -14.815510557964274`}, {
                5.723585101952381, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{139.44075385613937`, 
               140.00298802617013`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.723585101952381, -14.815510557964274`}, {
                5.726847747587197, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{139.50298802617013`, 
               140.06501914797698`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.730099782973574, -14.815510557964274`}, {
                5.733341276897746, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{139.62684854220228`, 
               140.18847751664586`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.739792912179234, -14.815510557964274`}, {
                5.7430031878094825`, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{139.81113937416686`, 
               140.37217481011143`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.762051382780177, -14.815510557964274`}, {
                5.765191102784844, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{140.23432903544906`, 
               140.79402303101224`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               RectangleBox[{5.765191102784844, -14.815510557964274`}, {
                5.768320995793772, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{140.29402303101224`, 
               140.85353019060304`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.777652323222656, -14.815510557964274`}, {
                5.780743515792329, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{140.53094225833846`, 
               141.0897136249778}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.796057750765372, -14.815510557964274`}, {
                5.799092654460526, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{140.8808758538311, 
               141.43857702700703`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.808142489980444, -14.815510557964274`}, {
                5.811140992976701, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{141.11063722363937`, 
               141.66764632772785`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.814130531825066, -14.815510557964274`}, {
                5.817111159963204, -12.429216196844383`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{141.2244850007576, 
               141.78115425871343`}, {-31.01163453714392, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 4.000000000000002*^-6]& ,
            TagBoxNote->"4.000000000000002*^-6"],
           StyleBox["4.000000000000002`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[4.000000000000002*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.820082930352362, -14.815510557964274`}, {
                5.823045895483019, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{141.3376551085221, 
               141.8939885481602}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.8289456176102075`, -14.815510557964274`}, {
                5.831882477283517, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{141.5061571447105, 
               142.06199425376727`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.855071922202427, -14.815510557964274`}, {
                5.857933154483459, -13.122363377404328`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{142.00288408472173`, 
               142.55728332632137`}, {-26.538676289116395`, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 2.000000000000001*^-6]& ,
            TagBoxNote->"2.000000000000001*^-6"],
           StyleBox["2.000000000000001`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[2.000000000000001*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.863631175598097, -14.815510557964274`}, {
                5.8664680569332965`, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{142.16561707793952`, 
               142.71955334664656`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.8888779583328805`, -14.815510557964274`}, {
                5.8916442118257715`, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{142.64562208931457`, 
               143.19821554461814`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.8971538676367405`, -14.815510557964274`}, {
                5.8998973535824915`, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{142.8029679967622, 
               143.35512858357563`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.908082938168931, -14.815510557964274`}, {
                5.910796644040527, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{143.01075719034904`, 
               143.56235158284838`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.910796644040527, -14.815510557964274`}, {
                5.91350300563827, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{143.06235158284838`, 
               143.61380634217974`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.924255797414532, -14.815510557964274`}, {
                5.926926025970411, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{143.31824403204692`, 
               143.86901181112606`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.926926025970411, -14.815510557964274`}, {
                5.929589143389895, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{143.36901181112606`, 
               143.91964438956828`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.945420608606575, -14.815510557964274`}, {
                5.948034989180646, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{143.7206404697915, 
               144.27034643788963`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.958424693029782, -14.815510557964274`}, {
                5.961005339623274, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{143.96788091056592`, 
               144.5169455106172}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.988961416889864, -14.815510557964274`}, {
                5.991464547107982, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{144.54846104379695`, 
               145.09605186205854`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{5.998936561946683, -14.815510557964274`}, {
                6.0014148779611505`, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{144.73811370832712`, 
               145.2852327459967}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], "Tooltip"]& ], 
         TagBox[
          TooltipBox[
           TagBox[
            TagBox[
             DynamicBox[{
               FEPrivate`If[
                CurrentValue["MouseOver"], 
                EdgeForm[{
                  GrayLevel[0.5], 
                  AbsoluteThickness[1.5], 
                  Opacity[0.66]}], {}, {}], 
               
               RectangleBox[{6.1070228877422545`, -14.815510557964274`}, {
                6.1092475827643655`, -13.815510557964274`}, "RoundingRadius" -> 
                0]},
              
              ImageSizeCache->{{146.79310735199292`, 
               147.33540441497368`}, {-22.06571804108887, \
-15.112603358556171`}}],
             "DelayedMouseEffectStyle"],
            StatusArea[#, 1.0000000000000004`*^-6]& ,
            TagBoxNote->"1.0000000000000004*^-6"],
           StyleBox["1.0000000000000004`*^-6", {}, StripOnInput -> False]],
          Annotation[#, 
           Style[1.0000000000000004`*^-6, {}], 
           "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-0.16012735135300493`, -14.815510557964274`},
      DisplayFunction->Identity,
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{
         Charting`ScaledTicks[{Log, Exp}], 
         Charting`ScaledFrameTicks[{Log, Exp}]}, {
         Charting`ScaledTicks[{Log, Exp}], 
         Charting`ScaledFrameTicks[{Log, Exp}]}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{27.735388310648524`, 1.4999999999998863`}, {
       12.911524554006377`, 5.5995407218092765`}},
      PlotRange->{{0, 8.006367567650246}, {All, All}},
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}},
      Ticks->FrontEndValueCache[{
         Charting`ScaledTicks[{Log, Exp}], 
         Charting`ScaledTicks[{Log, Exp}]}, {{{0., 
           FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
           FormBox["10", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
           FormBox["100", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
           FormBox["1000", TraditionalForm], {0.01, 
           0.}}, {-2.3025850929940455`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-1.6094379124341003`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-1.2039728043259361`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.916290731874155, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.6931471805599453, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.5108256237659907, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.35667494393873245`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.2231435513142097, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.10536051565782628`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {0.6931471805599453, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.0986122886681098`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.3862943611198906`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.6094379124341003`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.791759469228055, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.9459101490553132`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.0794415416798357`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.1972245773362196`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.995732273553991, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {3.4011973816621555`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {3.6888794541139363`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {3.912023005428146, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.0943445622221, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.248495242049359, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.382026634673881, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.499809670330265, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.298317366548036, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.703782474656201, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.991464547107982, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.214608098422191, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.396929655216146, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.551080335043404, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.684611727667927, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.802394763324311, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {7.600902459542082, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {8.006367567650246, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {8.294049640102028, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {8.517193191416238, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {8.699514748210191, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {8.85366542803745, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {8.987196820661973, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {9.104979856318357, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {9.210340371976184, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {9.615805480084347, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {9.903487552536127, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {10.126631103850338`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}}, {{-13.815510557964274`, 
           FormBox[
            TemplateBox[{"10", 
              RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> 
             SuperscriptBox], TraditionalForm], {0.01, 
           0.}}, {-11.512925464970229`, 
           FormBox[
            TemplateBox[{"10", 
              RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
             SuperscriptBox], TraditionalForm], {0.01, 
           0.}}, {-9.210340371976182, 
           FormBox[
            TemplateBox[{"10", 
              RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
             SuperscriptBox], TraditionalForm], {0.01, 
           0.}}, {-6.907755278982137, 
           FormBox["0.001`", TraditionalForm], {0.01, 
           0.}}, {-4.605170185988091, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"0.010\"", ShowStringCharacters -> False], 0.01, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
           0.}}, {-2.3025850929940455`, 
           FormBox[
            TagBox[
             InterpretationBox[
              StyleBox["\"0.100\"", ShowStringCharacters -> False], 0.1, 
              AutoDelete -> True], NumberForm[#, {
               DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {
          0., 
           FormBox["1", TraditionalForm], {0.01, 0.}}, {-16.11809565095832, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-15.424948470398375`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-15.01948336229021, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-14.73180128983843, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-14.508657738524219`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-14.326336181730264`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-14.172185501903007`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-14.038654109278484`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-13.9208710736221, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-13.122363377404328`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-12.716898269296165`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-12.429216196844383`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-12.206072645530174`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-12.02375108873622, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-11.86960040890896, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-11.736069016284437`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-11.618285980628055`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-10.819778284410283`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-10.41431317630212, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-10.126631103850338`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-9.903487552536127, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-9.721165995742174, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-9.567015315914915, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-9.433483923290392, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-9.315700887634009, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-8.517193191416238, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-8.111728083308073, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-7.824046010856292, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-7.600902459542082, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-7.418580902748128, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-7.264430222920869, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-7.1308988302963465`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-7.013115794639964, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-6.214608098422191, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-5.809142990314028, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-5.521460917862246, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-5.298317366548036, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-5.115995809754082, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-4.961845129926823, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-4.8283137373023015`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-4.710530701645918, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-3.912023005428146, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-3.506557897319982, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-3.2188758248682006`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-2.995732273553991, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-2.8134107167600364`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-2.659260036932778, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-2.5257286443082556`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-2.4079456086518722`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-1.6094379124341003`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-1.2039728043259361`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.916290731874155, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.6931471805599453, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.5108256237659907, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.35667494393873245`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.2231435513142097, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {-0.10536051565782628`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {0.6931471805599453, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.0986122886681098`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.3862943611198906`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.6094379124341003`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.791759469228055, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.9459101490553132`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.0794415416798357`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.1972245773362196`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.302585092994046, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}}}]], {315.5102528991425, -66.06303208440134}, 
     ImageScaled[{0.5, 0.5}], {202.8881056453368, 125.83434682743112}], 
    InsetBox[
     GraphicsBox[{{
        {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
         EdgeForm[{Opacity[0.581], Thickness[Small]}], {}, 
         {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
          EdgeForm[{Opacity[0.581], Thickness[Small]}], 
          TagBox[
           TooltipBox[
            TagBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{0., 0}, {1., 0.01065}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{24.90090197961058, 
                35.54898459738257}, {-20.091046490240316`, \
-15.112603358556157`}}],
              "DelayedMouseEffectStyle"],
             StatusArea[#, 0.01065]& ,
             TagBoxNote->"0.01065"],
            StyleBox["0.01065`", {}, StripOnInput -> False]],
           Annotation[#, 
            Style[0.01065, {}], "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            TagBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{1., 0}, {2., 0.0568}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{35.04898459738257, 
                45.69706721515462}, {-39.497633394204996`, \
-15.112603358556157`}}],
              "DelayedMouseEffectStyle"],
             StatusArea[#, 0.0568]& ,
             TagBoxNote->"0.0568"],
            StyleBox["0.0568`", {}, StripOnInput -> False]],
           Annotation[#, 
            Style[0.0568, {}], "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            TagBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{2., 0}, {3., 0.14485}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{45.19706721515462, 
                55.845149832926666`}, {-76.52363506038247, \
-15.112603358556157`}}],
              "DelayedMouseEffectStyle"],
             StatusArea[#, 0.14485]& ,
             TagBoxNote->"0.14485"],
            StyleBox["0.14485`", {}, StripOnInput -> False]],
           Annotation[#, 
            Style[0.14485, {}], "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            TagBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{3., 0}, {4., 0.20635}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{55.345149832926666`, 
                65.99323245069866}, {-102.38506722926282`, \
-15.112603358556157`}}],
              "DelayedMouseEffectStyle"],
             StatusArea[#, 0.20635]& ,
             TagBoxNote->"0.20635"],
            StyleBox["0.20635`", {}, StripOnInput -> False]],
           Annotation[#, 
            Style[0.20635, {}], "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            TagBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{4., 0}, {5., 0.21595}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{65.49323245069866, 
                76.14131506847065}, {-106.42197371416121`, \
-15.112603358556157`}}],
              "DelayedMouseEffectStyle"],
             StatusArea[#, 0.21595]& ,
             TagBoxNote->"0.21595"],
            StyleBox["0.21595`", {}, StripOnInput -> False]],
           Annotation[#, 
            Style[0.21595, {}], "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            TagBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{5., 0}, {6., 0.17335}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{75.64131506847065, 
                86.2893976862427}, {-88.50820118742458, \
-15.112603358556157`}}],
              "DelayedMouseEffectStyle"],
             StatusArea[#, 0.17335]& ,
             TagBoxNote->"0.17335"],
            StyleBox["0.17335`", {}, StripOnInput -> False]],
           Annotation[#, 
            Style[0.17335, {}], "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            TagBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{6., 0}, {7., 0.1076}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{85.7893976862427, 
                96.43748030401474}, {-60.85959687679234, \
-15.112603358556157`}}],
              "DelayedMouseEffectStyle"],
             StatusArea[#, 0.1076]& ,
             TagBoxNote->"0.1076"],
            StyleBox["0.1076`", {}, StripOnInput -> False]],
           Annotation[#, 
            Style[0.1076, {}], "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            TagBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{7., 0}, {8., 0.05485}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{95.93748030401474, 
                106.58556292178673`}, {-38.67763676446001, \
-15.112603358556157`}}],
              "DelayedMouseEffectStyle"],
             StatusArea[#, 0.05485]& ,
             TagBoxNote->"0.05485"],
            StyleBox["0.05485`", {}, StripOnInput -> False]],
           Annotation[#, 
            Style[0.05485, {}], "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            TagBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{8., 0}, {9., 0.0214}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{106.08556292178673`, 
                116.73364553955872`}, {-24.611540731142163`, \
-15.112603358556157`}}],
              "DelayedMouseEffectStyle"],
             StatusArea[#, 0.0214]& ,
             TagBoxNote->"0.0214"],
            StyleBox["0.0214`", {}, StripOnInput -> False]],
           Annotation[#, 
            Style[0.0214, {}], "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            TagBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{9., 0}, {10., 0.0063}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{116.23364553955872`, 
                126.88172815733077`}, {-18.261823239270733`, \
-15.112603358556157`}}],
              "DelayedMouseEffectStyle"],
             StatusArea[#, 0.0063]& ,
             TagBoxNote->"0.0063"],
            StyleBox["0.0063`", {}, StripOnInput -> False]],
           Annotation[#, 
            Style[0.0063, {}], "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            TagBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{10., 0}, {11., 0.0015}, "RoundingRadius" -> 0]},
               
               
               ImageSizeCache->{{126.38172815733077`, 
                137.02981077510282`}, {-16.243369996821535`, \
-15.112603358556157`}}],
              "DelayedMouseEffectStyle"],
             StatusArea[#, 0.0015]& ,
             TagBoxNote->"0.0015"],
            StyleBox["0.0015`", {}, StripOnInput -> False]],
           Annotation[#, 
            Style[0.0015, {}], "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            TagBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{11., 0}, {12., 0.00025}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{136.52981077510282`, 
                147.17789339287475`}, {-15.717731131600388`, \
-15.112603358556157`}}],
              "DelayedMouseEffectStyle"],
             StatusArea[#, 0.00025]& ,
             TagBoxNote->"0.00025"],
            StyleBox["0.00025`", {}, StripOnInput -> False]],
           Annotation[#, 
            Style[0.00025, {}], "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            TagBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{12., 0}, {13., 0.00015}, "RoundingRadius" -> 0]},
               ImageSizeCache->{{146.67789339287475`, 
                157.3259760106468}, {-15.675680022382693`, \
-15.112603358556157`}}],
              "DelayedMouseEffectStyle"],
             StatusArea[#, 0.00015]& ,
             TagBoxNote->"0.00015"],
            StyleBox["0.00015`", {}, StripOnInput -> False]],
           Annotation[#, 
            Style[0.00015, {}], 
            "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}}}, {{
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
          0.012833333333333334`], AbsoluteThickness[1.6], 
          TagBox[{
            {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
             0.012833333333333334`], AbsoluteThickness[1.6], Opacity[0.2], 
             LineBox[{{{15., 3.3630080419896356`*^-7}, {15., 
              3.3630080419896356`*^-7}}},
              VertexColors->None]}, 
            {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
             0.012833333333333334`], AbsoluteThickness[1.6], Opacity[0.2], 
             LineBox[CompressedData["
1:eJxTTMoPSmVmYGDgB2ImKIaBJPON3K9lm+xh/M/JclNmTZxmB+F9sG/+Mo3/
ifoKexgfVZ7BIfB8xNq3M/bB9DugynM43Fr6YG941Ql7GB9VXsBB6p7Ti1t7
T9vD+KjyIg7aevte2685bg/jo8pLOFi9CLIKnbDfHsZHlZdxMLh49GTT1Q32
MD6qvILDzh7GRRd159rD+KjySg5Pu2XZ7+9vsYfxUeVVHM75TS6dEZFhD+Oj
yqs58N3oW7Brtrs9jI8qr+GwtHLp5t+PlOxhfFR5LQe/ZCvh8tM/4HxUeR0H
hbmTVRcWnYLzYfIAo5+G2Q==
              "],
              VertexColors->None]}},
           Annotation[#, "Charting`Private`Tag$1014594#1"]& ]}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.012833333333333334`], AbsoluteThickness[1.6], {}, 
           GeometricTransformationBox[InsetBox[
             GraphicsBox[
              {EdgeForm[None], DiskBox[{0, 0}]},
              DefaultBaseStyle->{"Graphics", 
                Directive[
                 PointSize[0.012833333333333334`], 
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 AbsoluteThickness[1.6]]}], {0, 0}, Automatic, Offset[
             6.272]], {{{0., 0.00884612683708114}}, {{1., 
            0.047179343131099415`}}, {{2., 0.11952100259878519`}}, {{3., 
            0.1912336041580563}}, {{4., 0.21673141804579715`}}, {{5., 
            0.18494414339908025`}}, {{6., 0.12329609559938684`}}, {{7., 
            0.06575791765300631}}, {{8., 0.028495097649636068`}}, {{9., 
            0.010131590275426159`}}, {{10., 0.0029719331474583393`}}, {{11., 
            0.0007204686418080823}}, {{12., 0.00014409372836161647`}}, {{13., 
            0.000023646150295239623`}}, {{14., 3.152820039365283*^-6}}, {{15.,
             3.3630080419896356`*^-7}}}], {}},
          Annotation[#, "Charting`Private`Tag$1014594#1"]& ]}, {}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-0.3, 0},
      DisplayFunction->Identity,
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{21.730584467574054`, 1.5000000000000568`}, {
       12.911524554006377`, 5.5995407218092765`}},
      PlotRange->{{0., 15.}, {All, All}},
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {530.1872242741247, -66.06303208440134},
      ImageScaled[{0.5, 0.5}], {196.8833018022625, 125.83434682743112}]}, {}},
  
  ImageSize->{
    UpTo[600], 
    UpTo[223]},
  PlotRange->{{0, 636.0245090008472}, {-132.12606416880269`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.734207130603828*^9, {3.734207167206709*^9, 3.734207338221488*^9}, 
   3.734225013414318*^9, {3.734225350340661*^9, 3.7342253572447243`*^9}, {
   3.734225389562211*^9, 3.7342254149281273`*^9}, 3.73422551698155*^9, {
   3.7342258464576063`*^9, 3.734225866755705*^9}, {3.734225982154917*^9, 
   3.734226050532671*^9}, 3.734227931349167*^9, 3.734227966310762*^9, {
   3.7342281953875303`*^9, 3.73422829174055*^9}, 3.734228324929027*^9, {
   3.734229391664236*^9, 3.7342294275436487`*^9}, {3.7342295455901413`*^9, 
   3.734229575196608*^9}, {3.734229715414418*^9, 3.734229725685987*^9}, 
   3.734286321998559*^9, 3.734450805535384*^9, 3.734749548401902*^9, 
   3.734750204565013*^9, 3.734752110026453*^9, 3.734787311033811*^9, 
   3.734789928323194*^9, 3.734832651343802*^9, 3.7378279030277653`*^9, 
   3.7939973524627934`*^9, 3.793997482301177*^9, 3.793997777781986*^9, 
   3.793997833269971*^9, 3.793997886423313*^9, 3.793997928470237*^9, 
   3.793997971546633*^9, 3.79399803730623*^9, {3.793998084869809*^9, 
   3.7939980939023113`*^9}, 3.8232285181579313`*^9, 3.8232285531644287`*^9},
 CellLabel->
  "Out[2402]=",ExpressionUUID->"18244206-55c6-43ad-99e0-d28c297353a5"]
}, Open  ]],

Cell["\<\
Note that the Binomial distribution is approximately equal to the Poisson \
distribution for p << 1.\
\>", "Text",
 CellChangeTimes->{{3.734229621006357*^9, 3.734229680214725*^9}, {
  3.734286473460235*^9, 
  3.734286479909789*^9}},ExpressionUUID->"fbc472ba-882f-486e-b7b4-\
b22fcec84d71"],

Cell["Giant component in ER graph", "Text",
 CellChangeTimes->{{3.734224949751999*^9, 3.734224959043346*^9}, {
  3.734825883504176*^9, 3.734825909272047*^9}, {3.734832699974896*^9, 
  3.734832705596863*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"2dae21d9-f6de-4146-b882-21676335046d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nV1", "=", "100"}], ";", " ", 
  RowBox[{"p", "=", 
   FractionBox["3", 
    RowBox[{"nV1", "-", "1"}]]}], ";", 
  RowBox[{"gER1", "=", 
   RowBox[{"RandomGraph", "[", 
    RowBox[{
     RowBox[{"BernoulliGraphDistribution", "[", 
      RowBox[{"nV1", ",", "p"}], "]"}], ",", 
     RowBox[{"VertexStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"White", ",", 
        RowBox[{"EdgeForm", "[", 
         RowBox[{"Thickness", "[", "0.002", "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"VertexSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Scaled\>\"", ",", " ", "0.01"}], "}"}]}], ",", 
     RowBox[{"EdgeStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.001", "]"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Small"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"ConnectedGraphQ", "[", "gER1", "]"}]}], "Input",
 CellChangeTimes->{{3.734832734072084*^9, 3.734832827192325*^9}, {
   3.734832909322321*^9, 3.734832977433066*^9}, {3.734833299434186*^9, 
   3.7348333578929768`*^9}, 3.7349033982361393`*^9, {3.793998069616411*^9, 
   3.793998089867239*^9}},
 CellLabel->
  "In[2403]:=",ExpressionUUID->"47f97bd3-6ee8-4dea-9f9a-ede31525466d"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
       20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
       38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
       56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73,
       74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
       92, 93, 94, 95, 96, 97, 98, 99, 100}, {Null, 
       SparseArray[Automatic, {100, 100}, 0, {1, {CompressedData["
1:eJxF0L8rhHEAwOFXIqkrw/lR3it3wyVyw2WxmJQsBnWDQXJFLK5k0KWoK2WR
QRa6ukUpJSZlkHJJunQ2G4PBYLIYDB71LZ96/oFPuliaWW2Jomgx+q8t6CBB
F9300BfEpBggwyBDjAR5RhljnAkmgymmKTDLHPMsUGSJZVYoscZ6sEGZTbbY
psIOu+yxzwGHHHFMlRonnHLGORdccsU1N9xyR517HnikwRNNnnnhlTfe+Qg+
+eKbn7+hBrcG7XSSCJL00k9MmizD5PgFpOMsgw==
          "], CompressedData["
1:eJwNwvtzgQAAAODWSXONuFROD2RxYZE08lhinqvV9XJyaZXf9///tn33tdJf
JwUBABCfAOA/gHY0O6MFt8grZvJcm5fqb7dHfr6kB1GqQfwVvoCkMjMDw8X0
TYVpLm+qQ8juJcb5heOh7KvuX/MNCe61+wvzlkOYpqh5GC3tSC6IahpGe6yk
upRFQkVCDiPw/T6Mcuo8qZuUgYxtmJaMbvxQTmGN4cR0oOL8an3+htDRIe34
EbrZVjlhbOYLAkE5BexDDpfgC91wUtnwKuTWr8xmenJnHoatHA/JKJukRrkv
rvdfIYRSPdW6TNpmkoGDfVAlFlqujHPXiKBb6x9yqmcoa8cl3CySLj9aGTBG
ISzfnbr3zmeED4PMg4Tt0UIkRTuDJ8uP4eHuD3TJP6Q=
          "]}, Pattern}]}, {
      EdgeStyle -> {
         Directive[
          GrayLevel[0], 
          Thickness[0.001]]}, ImageSize -> Small, 
       VertexSize -> {{"Scaled", 0.01}}, VertexStyle -> {
         Directive[
          GrayLevel[1], 
          EdgeForm[
           Thickness[0.002]]]}}]]}, 
    TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJxFlHlU0wcSxxOQEEhIfjl+OQiECEXRWlYERIiYwXK0gFTLusATV42KAqGC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       "], {
        {GrayLevel[0], Thickness[0.001], Opacity[0.7], Arrowheads[0.], 
         ArrowBox[CompressedData["
1:eJwVxdtOgmAAAGDHRHKk6BBwclApdKipiKR4CNE8BsE4OXFI/Hjf4/S61cW3
rwm+HQBlMpmfP/9DGNSCNMiG0iyTFbMuXIAFWIFNOMk95Kq5GVJEasgLckXu
+Vl+gTJoD41Q8KgVhMKleMYoTMGmmIkFJaPklvGyXl7jLN7AF/i1olYcgiRk
wiXOREwK5Jx0SI/iqGdKp3zqUq1XpVqHfqK79Jw26SvDMg2mz2iMx0rsluO5
gIvqWtPjJV7l3SdLkIVQiFqvrVt70I5EVZyJScfsGr1Rz+5LfWMQD+5DZXgc
hhIYqfJSXo1P409lr4CJP4mm6+lGNefO4m0Zao4GVsbK0ze6v0neb9v7ztjZ
+8MhOaYn8GEYoWmZZyuxUjtwL27kfflpEEe3OP0FIB9ADQ==
          "], 
          0.05676570948305745]}, 
        {GrayLevel[1], EdgeForm[{GrayLevel[0], Opacity[0.7], Thickness[
         0.002]}], DiskBox[1, 0.05676570948305745], 
         DiskBox[2, 0.05676570948305745], DiskBox[3, 0.05676570948305745], 
         DiskBox[4, 0.05676570948305745], DiskBox[5, 0.05676570948305745], 
         DiskBox[6, 0.05676570948305745], DiskBox[7, 0.05676570948305745], 
         DiskBox[8, 0.05676570948305745], DiskBox[9, 0.05676570948305745], 
         DiskBox[10, 0.05676570948305745], DiskBox[11, 0.05676570948305745], 
         DiskBox[12, 0.05676570948305745], DiskBox[13, 0.05676570948305745], 
         DiskBox[14, 0.05676570948305745], DiskBox[15, 0.05676570948305745], 
         DiskBox[16, 0.05676570948305745], DiskBox[17, 0.05676570948305745], 
         DiskBox[18, 0.05676570948305745], DiskBox[19, 0.05676570948305745], 
         DiskBox[20, 0.05676570948305745], DiskBox[21, 0.05676570948305745], 
         DiskBox[22, 0.05676570948305745], DiskBox[23, 0.05676570948305745], 
         DiskBox[24, 0.05676570948305745], DiskBox[25, 0.05676570948305745], 
         DiskBox[26, 0.05676570948305745], DiskBox[27, 0.05676570948305745], 
         DiskBox[28, 0.05676570948305745], DiskBox[29, 0.05676570948305745], 
         DiskBox[30, 0.05676570948305745], DiskBox[31, 0.05676570948305745], 
         DiskBox[32, 0.05676570948305745], DiskBox[33, 0.05676570948305745], 
         DiskBox[34, 0.05676570948305745], DiskBox[35, 0.05676570948305745], 
         DiskBox[36, 0.05676570948305745], DiskBox[37, 0.05676570948305745], 
         DiskBox[38, 0.05676570948305745], DiskBox[39, 0.05676570948305745], 
         DiskBox[40, 0.05676570948305745], DiskBox[41, 0.05676570948305745], 
         DiskBox[42, 0.05676570948305745], DiskBox[43, 0.05676570948305745], 
         DiskBox[44, 0.05676570948305745], DiskBox[45, 0.05676570948305745], 
         DiskBox[46, 0.05676570948305745], DiskBox[47, 0.05676570948305745], 
         DiskBox[48, 0.05676570948305745], DiskBox[49, 0.05676570948305745], 
         DiskBox[50, 0.05676570948305745], DiskBox[51, 0.05676570948305745], 
         DiskBox[52, 0.05676570948305745], DiskBox[53, 0.05676570948305745], 
         DiskBox[54, 0.05676570948305745], DiskBox[55, 0.05676570948305745], 
         DiskBox[56, 0.05676570948305745], DiskBox[57, 0.05676570948305745], 
         DiskBox[58, 0.05676570948305745], DiskBox[59, 0.05676570948305745], 
         DiskBox[60, 0.05676570948305745], DiskBox[61, 0.05676570948305745], 
         DiskBox[62, 0.05676570948305745], DiskBox[63, 0.05676570948305745], 
         DiskBox[64, 0.05676570948305745], DiskBox[65, 0.05676570948305745], 
         DiskBox[66, 0.05676570948305745], DiskBox[67, 0.05676570948305745], 
         DiskBox[68, 0.05676570948305745], DiskBox[69, 0.05676570948305745], 
         DiskBox[70, 0.05676570948305745], DiskBox[71, 0.05676570948305745], 
         DiskBox[72, 0.05676570948305745], DiskBox[73, 0.05676570948305745], 
         DiskBox[74, 0.05676570948305745], DiskBox[75, 0.05676570948305745], 
         DiskBox[76, 0.05676570948305745], DiskBox[77, 0.05676570948305745], 
         DiskBox[78, 0.05676570948305745], DiskBox[79, 0.05676570948305745], 
         DiskBox[80, 0.05676570948305745], DiskBox[81, 0.05676570948305745], 
         DiskBox[82, 0.05676570948305745], DiskBox[83, 0.05676570948305745], 
         DiskBox[84, 0.05676570948305745], DiskBox[85, 0.05676570948305745], 
         DiskBox[86, 0.05676570948305745], DiskBox[87, 0.05676570948305745], 
         DiskBox[88, 0.05676570948305745], DiskBox[89, 0.05676570948305745], 
         DiskBox[90, 0.05676570948305745], DiskBox[91, 0.05676570948305745], 
         DiskBox[92, 0.05676570948305745], DiskBox[93, 0.05676570948305745], 
         DiskBox[94, 0.05676570948305745], DiskBox[95, 0.05676570948305745], 
         DiskBox[96, 0.05676570948305745], DiskBox[97, 0.05676570948305745], 
         DiskBox[98, 0.05676570948305745], DiskBox[99, 0.05676570948305745], 
         DiskBox[100, 0.05676570948305745]}}]],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->Small]], "Output",
 CellChangeTimes->{{3.734832736739822*^9, 3.734832827917818*^9}, {
   3.73483291017172*^9, 3.734832985733469*^9}, {3.734833306100827*^9, 
   3.7348333632260647`*^9}, 3.734834030432926*^9, {3.734903391824298*^9, 
   3.734903399007064*^9}, 3.737827903174662*^9, 3.793997352497319*^9, 
   3.7939974823555193`*^9, 3.793997777837234*^9, 3.793997833326908*^9, 
   3.793997886460519*^9, 3.793997928543133*^9, 3.7939979715837803`*^9, 
   3.793998037549588*^9, {3.793998074584937*^9, 3.793998094145228*^9}, 
   3.8232285185263023`*^9, 3.823228553480892*^9},
 CellLabel->
  "Out[2403]=",ExpressionUUID->"8a68f243-5303-42c6-a07b-7d9012e19f18"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.734832736739822*^9, 3.734832827917818*^9}, {
   3.73483291017172*^9, 3.734832985733469*^9}, {3.734833306100827*^9, 
   3.7348333632260647`*^9}, 3.734834030432926*^9, {3.734903391824298*^9, 
   3.734903399007064*^9}, 3.737827903174662*^9, 3.793997352497319*^9, 
   3.7939974823555193`*^9, 3.793997777837234*^9, 3.793997833326908*^9, 
   3.793997886460519*^9, 3.793997928543133*^9, 3.7939979715837803`*^9, 
   3.793998037549588*^9, {3.793998074584937*^9, 3.793998094145228*^9}, 
   3.8232285185263023`*^9, 3.8232285534883823`*^9},
 CellLabel->
  "Out[2404]=",ExpressionUUID->"ebd9a307-7076-431e-bb8f-f9f8eeba550d"]
}, Open  ]],

Cell["Complete graph", "Text",
 CellChangeTimes->{{3.734224949751999*^9, 3.734224959043346*^9}, {
  3.734825883504176*^9, 3.734825909272047*^9}, {3.734832699974896*^9, 
  3.734832705596863*^9}, {3.737827931003281*^9, 3.737827937189723*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"c8df6f6f-4a1c-48a8-89b0-4ce75cbc31b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"cg", "=", 
   RowBox[{"CompleteGraph", "[", 
    RowBox[{"8", ",", 
     RowBox[{"VertexStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"White", ",", 
        RowBox[{"EdgeForm", "[", 
         RowBox[{"Thickness", "[", "0.005", "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"VertexSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Scaled\>\"", ",", " ", "0.05"}], "}"}]}], ",", 
     RowBox[{"EdgeStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.008", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.7378279608869057`*^9, 3.7378280080972767`*^9}, 
   3.737829910250985*^9, {3.793997709796693*^9, 3.7939977143452682`*^9}},
 CellLabel->
  "In[2405]:=",ExpressionUUID->"043ecac3-f666-45d4-8e20-1f85073e743a"],

Cell["Tree graph", "Text",
 CellChangeTimes->{{3.734224949751999*^9, 3.734224959043346*^9}, {
  3.734825883504176*^9, 3.734825909272047*^9}, {3.734832699974896*^9, 
  3.734832705596863*^9}, {3.737827931003281*^9, 3.737827937189723*^9}, {
  3.737829088567534*^9, 3.737829089094125*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"6049f5bd-705e-4ac0-b057-7d72354739d5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tg", "=", 
   RowBox[{"TreeGraph", "[", 
    RowBox[{
     RowBox[{"Range", "[", "8", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "2", ",", "1", ",", "4", ",", "2", ",", "3", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"VertexStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"White", ",", 
        RowBox[{"EdgeForm", "[", 
         RowBox[{"Thickness", "[", "0.005", "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"VertexSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Scaled\>\"", ",", " ", "0.05"}], "}"}]}], ",", 
     RowBox[{"EdgeStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.008", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.737829139826572*^9, {3.793997724912343*^9, 3.7939977274642363`*^9}},
 CellLabel->
  "In[2406]:=",ExpressionUUID->"e330abbc-e894-46a4-8177-619a648a6c45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{"gReg", ",", "gER", ",", "gBA", ",", "gstar"}], "}"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.793997568207264*^9, 3.793997628961096*^9}},
 CellLabel->
  "In[2407]:=",ExpressionUUID->"bc47b6f7-ef7f-4742-ad45-5e7485eebf89"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     FormBox[
      GraphicsBox[
       NamespaceBox["NetworkGraphics",
        DynamicModuleBox[{Typeset`graph = HoldComplete[
          
          Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
           18, 19, 20}, {Null, 
            SparseArray[
            Automatic, {20, 20}, 0, {
             1, {{0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 
               32, 34, 36, 38, 40}, {{2}, {20}, {1}, {3}, {2}, {4}, {3}, {
               5}, {4}, {6}, {5}, {7}, {6}, {8}, {7}, {9}, {8}, {10}, {9}, {
               11}, {10}, {12}, {11}, {13}, {12}, {14}, {13}, {15}, {14}, {
               16}, {15}, {17}, {16}, {18}, {17}, {19}, {18}, {20}, {1}, {
               19}}}, Pattern}]}, {EdgeStyle -> {
              Directive[
               GrayLevel[0], 
               Thickness[0.008]]}, GraphLayout -> "CircularEmbedding", 
            VertexSize -> {{"Scaled", 0.05}}, VertexStyle -> {
              Directive[
               GrayLevel[1], 
               EdgeForm[
                Thickness[0.005]]]}}]]}, 
         TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQHfNS3/z9scv7GUNdhPny39nXxt5YszHx5B4GMPhg
7wyRt/8TApGPjCplUT7/yH7Rl+mzyx+/tF8CpcOg4n+h6myg+mDmMIkf7enM
vLKHCWpPEtTeNVD9aRD9+5Oh5qyDiO+PgpoD1be/vmSupfXpozZQc/e7Qs2B
um9/FNQcqPv2Q923H+q+/f+g6uyg+mDmNHYnHTticskGGg77E6D2Qt23PxXq
Lqj79q+FuhsAw96e1w==
            "], {
             {GrayLevel[0], Thickness[0.008], Opacity[0.7], Arrowheads[0.], 
              ArrowBox[{{1, 2}, {1, 20}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 
               7}, {7, 8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13,
                14}, {14, 15}, {15, 16}, {16, 17}, {17, 18}, {18, 19}, {19, 
               20}}, 0.07071067811865477]}, 
             {GrayLevel[1], EdgeForm[{GrayLevel[0], Opacity[0.7], Thickness[
              0.005]}], DiskBox[1, 0.07071067811865477], 
              DiskBox[2, 0.07071067811865477], 
              DiskBox[3, 0.07071067811865477], 
              DiskBox[4, 0.07071067811865477], 
              DiskBox[5, 0.07071067811865477], 
              DiskBox[6, 0.07071067811865477], 
              DiskBox[7, 0.07071067811865477], 
              DiskBox[8, 0.07071067811865477], 
              DiskBox[9, 0.07071067811865477], 
              DiskBox[10, 0.07071067811865477], 
              DiskBox[11, 0.07071067811865477], 
              DiskBox[12, 0.07071067811865477], 
              DiskBox[13, 0.07071067811865477], 
              DiskBox[14, 0.07071067811865477], 
              DiskBox[15, 0.07071067811865477], 
              DiskBox[16, 0.07071067811865477], 
              DiskBox[17, 0.07071067811865477], 
              DiskBox[18, 0.07071067811865477], 
              DiskBox[19, 0.07071067811865477], 
              DiskBox[20, 0.07071067811865477]}}]],
          MouseAppearanceTag["NetworkGraphics"]],
         AllowKernelInitialization->False]],
       DefaultBaseStyle->{
        "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
         Hue[0.8, 1., 0.6]},
       FormatType->TraditionalForm,
       FrameTicks->None],
      TraditionalForm], {194.4, -188.475}, {
     Center, Center}, {360.00000000000006, 358.99999999999994}], InsetBox[
     FormBox[
      GraphicsBox[
       NamespaceBox["NetworkGraphics",
        DynamicModuleBox[{Typeset`graph = HoldComplete[
          
          Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
           18, 19, 20}, {Null, 
            SparseArray[
            Automatic, {20, 20}, 0, {
             1, {{0, 3, 6, 11, 15, 22, 25, 28, 33, 37, 42, 44, 49, 54, 58, 60,
                61, 65, 67, 73, 74}, {{2}, {12}, {13}, {1}, {3}, {10}, {2}, {
               5}, {8}, {15}, {19}, {5}, {12}, {14}, {18}, {3}, {4}, {9}, {
               10}, {11}, {12}, {15}, {7}, {14}, {17}, {6}, {13}, {19}, {3}, {
               9}, {13}, {14}, {19}, {5}, {8}, {11}, {14}, {2}, {5}, {12}, {
               16}, {17}, {5}, {9}, {1}, {4}, {5}, {10}, {19}, {1}, {7}, {
               8}, {17}, {18}, {4}, {6}, {8}, {9}, {3}, {5}, {10}, {6}, {
               10}, {13}, {19}, {4}, {13}, {3}, {7}, {8}, {12}, {17}, {20}, {
               19}}}, Pattern}]}, {EdgeStyle -> {
              Directive[
               GrayLevel[0], 
               Thickness[0.008]]}, VertexSize -> {{"Scaled", 0.05}}, 
            VertexStyle -> {
              Directive[
               GrayLevel[1], 
               EdgeForm[
                Thickness[0.005]]]}}]]}, 
         TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQvYondem12wwODk1yLSfnszucnMjOsXXhF3u+nVEb
7vKwOSitPXXnZc5Pe5+CaPmmuT/tb529vbMgkNnh97EnE8z4v9s/kFk8Lbf9
q31I0Sf+vIKP9junqZRUL+ZymNUSzvhF4YM9ywvt/HcHeR3mrpJSYQv8ZR8+
z+26izWzw+mL68/0zPlgH3ArutT3yh/7Bt7Y9tiVZ+0DVm0IZW38aH/Cumep
eymjwxLBFw9tgz7YM0ABH2v1waPq/+wnVyh1WAczOGgU/19z04vd4azW4abN
WxkdNCti4+pSWB0EUtKKSztv23MtXSG9vu6R/YVQr66N1p/g5kjw7j2lrsHm
0F4kJXY6m9mhx+F9R+qDf/YFc9tSHi3ncijMsl3OvorZYXutAueJJnYHgbZ0
rXKB3/avZIr3TbUVdEjID7c06/xnDwBqP4oC
            "], {
             {GrayLevel[0], Thickness[0.008], Opacity[0.7], Arrowheads[0.], 
              ArrowBox[{{1, 2}, {1, 12}, {1, 13}, {2, 3}, {2, 10}, {3, 5}, {3,
                8}, {3, 15}, {3, 19}, {4, 5}, {4, 12}, {4, 14}, {4, 18}, {5, 
               9}, {5, 10}, {5, 11}, {5, 12}, {5, 15}, {6, 7}, {6, 14}, {6, 
               17}, {7, 13}, {7, 19}, {8, 9}, {8, 13}, {8, 14}, {8, 19}, {9, 
               11}, {9, 14}, {10, 12}, {10, 16}, {10, 17}, {12, 19}, {13, 
               17}, {13, 18}, {17, 19}, {19, 20}}, 0.1306178911883401]}, 
             {GrayLevel[1], EdgeForm[{GrayLevel[0], Opacity[0.7], Thickness[
              0.005]}], DiskBox[1, 0.1306178911883401], 
              DiskBox[2, 0.1306178911883401], DiskBox[3, 0.1306178911883401], 
              DiskBox[4, 0.1306178911883401], DiskBox[5, 0.1306178911883401], 
              DiskBox[6, 0.1306178911883401], DiskBox[7, 0.1306178911883401], 
              DiskBox[8, 0.1306178911883401], DiskBox[9, 0.1306178911883401], 
              DiskBox[10, 0.1306178911883401], 
              DiskBox[11, 0.1306178911883401], 
              DiskBox[12, 0.1306178911883401], 
              DiskBox[13, 0.1306178911883401], 
              DiskBox[14, 0.1306178911883401], 
              DiskBox[15, 0.1306178911883401], 
              DiskBox[16, 0.1306178911883401], 
              DiskBox[17, 0.1306178911883401], 
              DiskBox[18, 0.1306178911883401], 
              DiskBox[19, 0.1306178911883401], 
              DiskBox[20, 0.1306178911883401]}}]],
          MouseAppearanceTag["NetworkGraphics"]],
         AllowKernelInitialization->False]],
       DefaultBaseStyle->{
        "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
         Hue[0.8, 1., 0.6]},
       FormatType->TraditionalForm,
       FrameTicks->None],
      TraditionalForm], {583.2, -188.475}, {
     Center, Center}, {360.00000000000006, 358.99999999999994}], InsetBox[
     FormBox[
      GraphicsBox[
       NamespaceBox["NetworkGraphics",
        DynamicModuleBox[{Typeset`graph = HoldComplete[
          
          Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
           18, 19, 20}, {
           Null, SparseArray[
            Automatic, {20, 20}, 0, {
             1, {{0, 6, 17, 30, 30, 31, 31, 34, 34, 34, 35, 35, 36, 36, 36, 
               37, 37, 37, 37, 37, 37}, {{2}, {3}, {6}, {12}, {14}, {18}, {
               3}, {4}, {5}, {6}, {7}, {8}, {9}, {11}, {13}, {15}, {16}, {
               4}, {5}, {7}, {8}, {9}, {10}, {11}, {12}, {14}, {15}, {17}, {
               19}, {20}, {10}, {13}, {16}, {19}, {17}, {20}, {18}}}, {1, 1, 
              1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
              1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}]}, {EdgeStyle -> {
              Directive[
               GrayLevel[0], 
               Thickness[0.008]]}, VertexSize -> {{"Scaled", 0.05}}, 
            VertexStyle -> {
              Directive[
               GrayLevel[1], 
               EdgeForm[
                Thickness[0.005]]]}}]]}, 
         TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQfcfs0/W9Wz/bP1K8dfxoNIND1r9r2tpHGBxuG8+O
upH3yd5uKf+VqOlf7IMfihbYX/hgr5qTs1SO/Zf9lMcMPxNyftizF/pqyih/
ts9Je/v2yIMr9vtKFf4YdzM6vL6a6hZ8iMnhkafsRMkCVocFrefWrfnxwV7s
c/Z+L3UmBwUJj9BCk5v26l+UfXRzfttvSTlQIl5z315oUozFIecn9gxQcNJ/
18qva//aM7BPer9db6v9meAQz4diN+051n5zm+T7095X/2muFxOXg/XCOa3z
/j2x//KSIaB85UN7FxPGJUobGRxuTBP8+kLrl/0ThqdHd8YxOqTt2v7IZi6X
w6MlNt82nfpqn+H+9dLytSfsrTZscOrpuGhvdJonw97/i/23zKif76s5HNge
zHXSaWJ2uFD3+fOC0p9wd/UsM7120vKTPQA/r5cL
            "], {
             {GrayLevel[0], Thickness[0.008], Opacity[0.7], Arrowheads[0.], 
              ArrowBox[{{1, 2}, {1, 3}, {1, 6}, {1, 12}, {1, 14}, {1, 18}, {2,
                3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {2, 9}, {2, 11}, {
               2, 13}, {2, 15}, {2, 16}, {3, 4}, {3, 5}, {3, 7}, {3, 8}, {3, 
               9}, {3, 10}, {3, 11}, {3, 12}, {3, 14}, {3, 15}, {3, 17}, {3, 
               19}, {3, 20}, {5, 10}, {7, 13}, {7, 16}, {7, 19}, {10, 17}, {
               12, 20}, {15, 18}}, 0.11301050982738714`]}, 
             {GrayLevel[1], EdgeForm[{GrayLevel[0], Opacity[0.7], Thickness[
              0.005]}], DiskBox[1, 0.11301050982738714], 
              DiskBox[2, 0.11301050982738714], 
              DiskBox[3, 0.11301050982738714], 
              DiskBox[4, 0.11301050982738714], 
              DiskBox[5, 0.11301050982738714], 
              DiskBox[6, 0.11301050982738714], 
              DiskBox[7, 0.11301050982738714], 
              DiskBox[8, 0.11301050982738714], 
              DiskBox[9, 0.11301050982738714], 
              DiskBox[10, 0.11301050982738714], 
              DiskBox[11, 0.11301050982738714], 
              DiskBox[12, 0.11301050982738714], 
              DiskBox[13, 0.11301050982738714], 
              DiskBox[14, 0.11301050982738714], 
              DiskBox[15, 0.11301050982738714], 
              DiskBox[16, 0.11301050982738714], 
              DiskBox[17, 0.11301050982738714], 
              DiskBox[18, 0.11301050982738714], 
              DiskBox[19, 0.11301050982738714], 
              DiskBox[20, 0.11301050982738714]}}]],
          MouseAppearanceTag["NetworkGraphics"]],
         AllowKernelInitialization->False]],
       DefaultBaseStyle->{
        "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
         Hue[0.8, 1., 0.6]},
       FormatType->TraditionalForm,
       FrameTicks->None],
      TraditionalForm], {972., -188.475}, {
     Center, Center}, {360., 358.99999999999994}], InsetBox[
     FormBox[
      GraphicsBox[
       NamespaceBox["NetworkGraphics",
        DynamicModuleBox[{Typeset`graph = HoldComplete[
          
          Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
           18, 19, 20}, {Null, 
            SparseArray[
            Automatic, {20, 20}, 0, {
             1, {{0, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
               33, 34, 35, 36, 37, 38}, {{2}, {3}, {4}, {5}, {6}, {7}, {8}, {
               9}, {10}, {11}, {12}, {13}, {14}, {15}, {16}, {17}, {18}, {
               19}, {20}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {
               1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}}}, Pattern}]}, {
           EdgeStyle -> {
              Directive[
               GrayLevel[0], 
               Thickness[0.008]]}, GraphLayout -> "StarEmbedding", 
            VertexSize -> {{"Scaled", 0.05}}, VertexStyle -> {
              Directive[
               GrayLevel[1], 
               EdgeForm[
                Thickness[0.005]]]}}]]}, 
         TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQjQ40XSyzFy5/vF/j7M8Zix1e2r+wXRcleOrV/gsn
ynNmNjy0l9K7tyWY9f3+qBMlrYI55+1XOS3VZH3yfv/erwotr5W37mfjFrzL
7Pd2/71pX3cmbL25n8fu+T2e7uf7f8lwpXutebr/afVb3jel9/Z/e/lYaZnK
m/0bInTr8wWP7t/4qWWK64T3+29D+PabofyvEPX2v6HqhSDm2TPJQszjgthn
zzAdYh/UPfbh3yDuEYe4154f6t6HEP/YH4D6Rx7iX3sZqH/nnQ/weHD8iv09
aeVWJZd39rWxN9ZsTDy5BxI6H+y3QeT3P4XKAwAKLqEB
            "], {
             {GrayLevel[0], Thickness[0.008], Opacity[0.7], Arrowheads[0.], 
              ArrowBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 
               8}, {1, 9}, {1, 10}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 
               15}, {1, 16}, {1, 17}, {1, 18}, {1, 19}, {1, 20}}, 
               0.07034892427420802]}, 
             {GrayLevel[1], EdgeForm[{GrayLevel[0], Opacity[0.7], Thickness[
              0.005]}], DiskBox[1, 0.07034892427420802], 
              DiskBox[2, 0.07034892427420802], 
              DiskBox[3, 0.07034892427420802], 
              DiskBox[4, 0.07034892427420802], 
              DiskBox[5, 0.07034892427420802], 
              DiskBox[6, 0.07034892427420802], 
              DiskBox[7, 0.07034892427420802], 
              DiskBox[8, 0.07034892427420802], 
              DiskBox[9, 0.07034892427420802], 
              DiskBox[10, 0.07034892427420802], 
              DiskBox[11, 0.07034892427420802], 
              DiskBox[12, 0.07034892427420802], 
              DiskBox[13, 0.07034892427420802], 
              DiskBox[14, 0.07034892427420802], 
              DiskBox[15, 0.07034892427420802], 
              DiskBox[16, 0.07034892427420802], 
              DiskBox[17, 0.07034892427420802], 
              DiskBox[18, 0.07034892427420802], 
              DiskBox[19, 0.07034892427420802], 
              DiskBox[20, 0.07034892427420802]}}]],
          MouseAppearanceTag["NetworkGraphics"]],
         AllowKernelInitialization->False]],
       DefaultBaseStyle->{
        "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
         Hue[0.8, 1., 0.6]},
       FormatType->TraditionalForm,
       FrameTicks->None],
      TraditionalForm], {1360.8000000000002, -188.475}, {
     Center, Center}, {359.9999999999998, 358.99999999999994}]}, {}},
  ImageSize->{
    UpTo[600], Automatic},
  PlotRange->{{0, 1555.2}, {-376.95, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.793997778061017*^9, {3.793997825425672*^9, 3.793997833573762*^9}, 
   3.793997886677052*^9, 3.793997928755609*^9, 3.793997971810914*^9, 
   3.7939980377751503`*^9, {3.793998085355939*^9, 3.793998094369322*^9}, 
   3.823228518785231*^9, 3.8232285537201023`*^9},
 CellLabel->
  "Out[2407]=",ExpressionUUID->"2360f4e2-607d-4e17-9290-990983db551b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ggrid", ",", "cg", ",", "tg"}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7939976849205933`*^9, 3.793997766423739*^9}},
 CellLabel->
  "In[2408]:=",ExpressionUUID->"dcbe0d77-c6a4-4d18-b37e-26d33000de86"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     FormBox[
      GraphicsBox[
       NamespaceBox["NetworkGraphics",
        DynamicModuleBox[{Typeset`graph = HoldComplete[
          
          Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
           18, 19, 20, 21, 22, 23, 24, 25}, {Null, 
            SparseArray[
            Automatic, {25, 25}, 0, {
             1, {{0, 2, 5, 8, 11, 13, 16, 20, 24, 28, 31, 34, 38, 42, 46, 49, 
               52, 56, 60, 64, 67, 69, 72, 75, 78, 80}, {{2}, {6}, {1}, {3}, {
               7}, {2}, {4}, {8}, {3}, {5}, {9}, {4}, {10}, {1}, {7}, {11}, {
               2}, {6}, {8}, {12}, {3}, {7}, {9}, {13}, {4}, {8}, {10}, {
               14}, {5}, {9}, {15}, {6}, {12}, {16}, {7}, {11}, {13}, {17}, {
               8}, {12}, {14}, {18}, {9}, {13}, {15}, {19}, {10}, {14}, {
               20}, {11}, {17}, {21}, {12}, {16}, {18}, {22}, {13}, {17}, {
               19}, {23}, {14}, {18}, {20}, {24}, {15}, {19}, {25}, {16}, {
               22}, {17}, {21}, {23}, {18}, {22}, {24}, {19}, {23}, {25}, {
               20}, {24}}}, Pattern}]}, {EdgeStyle -> {
              Directive[
               GrayLevel[0], 
               Thickness[0.008]]}, 
            GraphLayout -> {"GridEmbedding", "Dimension" -> {5, 5}}, 
            VertexSize -> {{"Scaled", 0.05}}, VertexStyle -> {
              Directive[
               GrayLevel[1], 
               EdgeForm[
                Thickness[0.005]]]}}]]}, 
         TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQDQEf7LHTDA6ofA40vgAaX8QBuz4GB+w0BxpfAI0v
gqYO3R3o5qDTAmh8ETRxdH+guwPdHHRaBI3GFQ7o/kB3B8IcACReGVU=
            "], {
             {GrayLevel[0], Thickness[0.008], Opacity[0.7], Arrowheads[0.], 
              ArrowBox[{{1, 2}, {1, 6}, {2, 3}, {2, 7}, {3, 4}, {3, 8}, {4, 
               5}, {4, 9}, {5, 10}, {6, 7}, {6, 11}, {7, 8}, {7, 12}, {8, 
               9}, {8, 13}, {9, 10}, {9, 14}, {10, 15}, {11, 12}, {11, 16}, {
               12, 13}, {12, 17}, {13, 14}, {13, 18}, {14, 15}, {14, 19}, {15,
                20}, {16, 17}, {16, 21}, {17, 18}, {17, 22}, {18, 19}, {18, 
               23}, {19, 20}, {19, 24}, {20, 25}, {21, 22}, {22, 23}, {23, 
               24}, {24, 25}}, 0.14142135623730953`]}, 
             {GrayLevel[1], EdgeForm[{GrayLevel[0], Opacity[0.7], Thickness[
              0.005]}], DiskBox[1, 0.14142135623730953], 
              DiskBox[2, 0.14142135623730953], 
              DiskBox[3, 0.14142135623730953], 
              DiskBox[4, 0.14142135623730953], 
              DiskBox[5, 0.14142135623730953], 
              DiskBox[6, 0.14142135623730953], 
              DiskBox[7, 0.14142135623730953], 
              DiskBox[8, 0.14142135623730953], 
              DiskBox[9, 0.14142135623730953], 
              DiskBox[10, 0.14142135623730953], 
              DiskBox[11, 0.14142135623730953], 
              DiskBox[12, 0.14142135623730953], 
              DiskBox[13, 0.14142135623730953], 
              DiskBox[14, 0.14142135623730953], 
              DiskBox[15, 0.14142135623730953], 
              DiskBox[16, 0.14142135623730953], 
              DiskBox[17, 0.14142135623730953], 
              DiskBox[18, 0.14142135623730953], 
              DiskBox[19, 0.14142135623730953], 
              DiskBox[20, 0.14142135623730953], 
              DiskBox[21, 0.14142135623730953], 
              DiskBox[22, 0.14142135623730953], 
              DiskBox[23, 0.14142135623730953], 
              DiskBox[24, 0.14142135623730953], 
              DiskBox[25, 0.14142135623730953]}}]],
          MouseAppearanceTag["NetworkGraphics"]],
         AllowKernelInitialization->False]],
       DefaultBaseStyle->{
        "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
         Hue[0.8, 1., 0.6]},
       FormatType->TraditionalForm,
       FrameTicks->None],
      TraditionalForm], {193.5, -188.475}, {
     Center, Center}, {360., 358.99999999999994}], InsetBox[
     FormBox[
      GraphicsBox[
       NamespaceBox["NetworkGraphics",
        DynamicModuleBox[{Typeset`graph = HoldComplete[
          Graph[{1, 2, 3, 4, 5, 6, 7, 8}, {Null, 
            SparseArray[
            Automatic, {8, 8}, 0, {
             1, {{0, 7, 14, 21, 28, 35, 42, 49, 56}, {{2}, {3}, {4}, {5}, {
               6}, {7}, {8}, {1}, {3}, {4}, {5}, {6}, {7}, {8}, {1}, {2}, {
               4}, {5}, {6}, {7}, {8}, {1}, {2}, {3}, {5}, {6}, {7}, {8}, {
               1}, {2}, {3}, {4}, {6}, {7}, {8}, {1}, {2}, {3}, {4}, {5}, {
               7}, {8}, {1}, {2}, {3}, {4}, {5}, {6}, {8}, {1}, {2}, {3}, {
               4}, {5}, {6}, {7}}}, Pattern}]}, {EdgeStyle -> {
              Directive[
               GrayLevel[0], 
               Thickness[0.008]]}, 
            GraphLayout -> {"CircularEmbedding", "OptimalOrder" -> False}, 
            VertexSize -> {{"Scaled", 0.05}}, VertexStyle -> {
              Directive[
               GrayLevel[1], 
               EdgeForm[
                Thickness[0.005]]]}}]]}, 
         TagBox[
          GraphicsGroupBox[
           GraphicsComplexBox[{{-0.707106781186548, 0.7071067811865482}, {-1.,
             1.0106430996148606`*^-15}, {-0.7071067811865471, \
-0.7071067811865468}, {6.049014748177263*^-16, -1.}, {
            0.7071067811865481, -0.7071067811865483}, {
            1., -1.133107779529596*^-15}, {0.707106781186547, 
            0.7071067811865467}, {-7.044813998280222*^-16, 1.}}, {
             {GrayLevel[0], Thickness[0.008], Opacity[0.7], Arrowheads[0.], 
              ArrowBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 
               8}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {3, 4}, {3,
                5}, {3, 6}, {3, 7}, {3, 8}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {
               5, 6}, {5, 7}, {5, 8}, {6, 7}, {6, 8}, {7, 8}}, 
               0.07071067811865477]}, 
             {GrayLevel[1], EdgeForm[{GrayLevel[0], Opacity[0.7], Thickness[
              0.005]}], DiskBox[1, 0.07071067811865477], 
              DiskBox[2, 0.07071067811865477], 
              DiskBox[3, 0.07071067811865477], 
              DiskBox[4, 0.07071067811865477], 
              DiskBox[5, 0.07071067811865477], 
              DiskBox[6, 0.07071067811865477], 
              DiskBox[7, 0.07071067811865477], 
              DiskBox[8, 0.07071067811865477]}}]],
          MouseAppearanceTag["NetworkGraphics"]],
         AllowKernelInitialization->False]],
       DefaultBaseStyle->{
        "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
         Hue[0.8, 1., 0.6]},
       FormatType->TraditionalForm,
       FrameTicks->None],
      TraditionalForm], {580.5, -188.475}, {
     Center, Center}, {360., 358.99999999999994}], InsetBox[
     FormBox[
      GraphicsBox[
       NamespaceBox["NetworkGraphics",
        DynamicModuleBox[{Typeset`graph = HoldComplete[
          
          Graph[{1, 2, 3, 4, 5, 6, 7, 8}, {
           Null, {{1, 2}, {2, 3}, {1, 4}, {4, 5}, {2, 6}, {3, 7}, {1, 8}}}, {
           EdgeStyle -> {
              Directive[
               GrayLevel[0], 
               Thickness[0.008]]}, VertexSize -> {{"Scaled", 0.05}}, 
            VertexStyle -> {
              Directive[
               GrayLevel[1], 
               EdgeForm[
                Thickness[0.005]]]}}]]}, 
         TagBox[
          GraphicsGroupBox[
           GraphicsComplexBox[{{1.416279616889396, 2.427907914667536}, {
            0.404651319111256, 1.6186052764450243`}, {0., 
            0.8093026382225121}, {1.618605276445024, 1.6186052764450243`}, {
            1.618605276445024, 0.8093026382225121}, {0.809302638222512, 
            0.8093026382225121}, {0., 0.}, {2.427907914667536, 
            1.6186052764450243`}}, {
             {GrayLevel[0], Thickness[0.008], Opacity[0.7], Arrowheads[0.], 
              ArrowBox[{{1, 2}, {1, 4}, {1, 8}, {2, 3}, {2, 6}, {3, 7}, {4, 
               5}}, 0.08583950752789522]}, 
             {GrayLevel[1], EdgeForm[{GrayLevel[0], Opacity[0.7], Thickness[
              0.005]}], DiskBox[1, 0.08583950752789522], 
              DiskBox[2, 0.08583950752789522], 
              DiskBox[3, 0.08583950752789522], 
              DiskBox[4, 0.08583950752789522], 
              DiskBox[5, 0.08583950752789522], 
              DiskBox[6, 0.08583950752789522], 
              DiskBox[7, 0.08583950752789522], 
              DiskBox[8, 0.08583950752789522]}}]],
          MouseAppearanceTag["NetworkGraphics"]],
         AllowKernelInitialization->False]],
       DefaultBaseStyle->{
        "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
         Hue[0.8, 1., 0.6]},
       FormatType->TraditionalForm,
       FrameTicks->None],
      TraditionalForm], {967.5, -188.475}, {
     Center, Center}, {360., 358.99999999999994}]}, {}},
  ImageSize->Medium,
  PlotRange->{{0, 1161.}, {-376.95, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.7939977017676697`*^9, 3.7939977782515078`*^9}, 
   3.7939978337505083`*^9, 3.7939978868321257`*^9, 3.7939979289133244`*^9, 
   3.7939979719676113`*^9, 3.7939980379333487`*^9, {3.793998085509444*^9, 
   3.793998094526986*^9}, 3.823228518960827*^9, 3.82322855389545*^9},
 CellLabel->
  "Out[2408]=",ExpressionUUID->"6058707a-844a-4e9a-a7e9-a3c4723e0197"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.793997369968371*^9, 3.793997376678259*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"47625ae5-5b80-420a-8e47-2d5a431669d0"],

Cell[BoxData[
 RowBox[{"(*", " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<cyclegraph.pdf\>\"", ",", "gReg"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<gridgraph.pdf\>\"", ",", "ggrid"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<stargraph.pdf\>\"", ",", "gstar"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<SFvertexdegree.txt\>\"", ",", "dataSF"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<randomgraph.pdf\>\"", ",", "gER"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<scalefreegraph.pdf\>\"", ",", "gBA"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.734749936962826*^9, 3.734749942891457*^9}, {
  3.7347500164752293`*^9, 3.7347500187675457`*^9}, {3.7939973622941313`*^9, 
  3.793997367951599*^9}, {3.793997415063876*^9, 3.79399746195334*^9}, {
  3.79399750050637*^9, 3.793997537793432*^9}},
 CellLabel->
  "In[2409]:=",ExpressionUUID->"4aa95348-1a62-48cf-8a80-5c9e7d19c302"]
}, Open  ]]
},
WindowToolbars->{},
WindowSize->{808, 755},
WindowMargins->{{Automatic, 129}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"bed1f50e-ea06-4b14-a0f4-a092f5f874bc"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 368, 7, 105, "Section",ExpressionUUID->"b24abee5-c2c4-4677-8c83-866d54acc2e1"],
Cell[951, 31, 266, 6, 30, "Input",ExpressionUUID->"c20d3319-9871-498a-98b3-44e991d006fa"],
Cell[1220, 39, 1483, 31, 73, "Input",ExpressionUUID->"c9a21f3a-cee3-4ab1-abc2-2c8057244c60"],
Cell[2706, 72, 297, 6, 52, "Text",ExpressionUUID->"e03c51c6-5ebe-477f-ad94-b17a753ea37a"],
Cell[3006, 80, 1110, 26, 52, "Input",ExpressionUUID->"f9b5cd8b-f2b1-49ba-917d-e8f3a4608b31"],
Cell[4119, 108, 248, 5, 52, "Text",ExpressionUUID->"7311873a-6430-4be4-8088-c95e78c5f25b"],
Cell[4370, 115, 1006, 23, 52, "Input",ExpressionUUID->"1fed6702-9c64-4bd2-9ab1-e242ec6f12c5"],
Cell[5379, 140, 201, 4, 52, "Text",ExpressionUUID->"cbe864b6-9628-4cd1-9f68-26797ab3e519"],
Cell[5583, 146, 1095, 26, 94, "Input",ExpressionUUID->"50b32578-6858-4588-800c-f3de667baf62"],
Cell[6681, 174, 1086, 25, 94, "Input",ExpressionUUID->"6e0ffe8a-5c25-4893-9e39-757820cddd61"],
Cell[7770, 201, 333, 6, 52, "Text",ExpressionUUID->"ace36d7d-b68b-42ba-9fa9-e82f47426eff"],
Cell[8106, 209, 757, 17, 52, "Input",ExpressionUUID->"4a27ec38-3adc-4fde-aa26-68044fce5a11"],
Cell[CellGroupData[{
Cell[8888, 230, 1057, 27, 75, "Input",ExpressionUUID->"22c5fb62-467a-4c77-86dc-9317bcf7dc12"],
Cell[9948, 259, 266763, 6970, 237, "Output",ExpressionUUID->"6da840d6-d3c6-48cb-bfff-09b55e0b33a7"]
}, Open  ]],
Cell[276726, 7232, 261, 5, 52, "Text",ExpressionUUID->"a86bea3d-d9e5-4805-8f18-6a0291b8e09e"],
Cell[276990, 7239, 1261, 30, 113, "Input",ExpressionUUID->"a388af58-a1f4-41f7-981b-4f09e0b99b3b"],
Cell[CellGroupData[{
Cell[278276, 7273, 2068, 48, 136, "Input",ExpressionUUID->"281fc40e-d7b7-4005-969f-785df896d3bc"],
Cell[280347, 7323, 329126, 8387, 149, "Output",ExpressionUUID->"18244206-55c6-43ad-99e0-d28c297353a5"]
}, Open  ]],
Cell[609488, 15713, 299, 7, 35, "Text",ExpressionUUID->"fbc472ba-882f-486e-b7b4-b22fcec84d71"],
Cell[609790, 15722, 310, 6, 52, "Text",ExpressionUUID->"2dae21d9-f6de-4146-b882-21676335046d"],
Cell[CellGroupData[{
Cell[610125, 15732, 1294, 31, 153, "Input",ExpressionUUID->"47f97bd3-6ee8-4dea-9f9a-ede31525466d"],
Cell[611422, 15765, 9330, 150, 197, "Output",ExpressionUUID->"8a68f243-5303-42c6-a07b-7d9012e19f18"],
Cell[620755, 15917, 667, 10, 34, "Output",ExpressionUUID->"ebd9a307-7076-431e-bb8f-f9f8eeba550d"]
}, Open  ]],
Cell[621437, 15930, 343, 6, 52, "Text",ExpressionUUID->"c8df6f6f-4a1c-48a8-89b0-4ce75cbc31b5"],
Cell[621783, 15938, 862, 21, 52, "Input",ExpressionUUID->"043ecac3-f666-45d4-8e20-1f85073e743a"],
Cell[622648, 15961, 388, 7, 52, "Text",ExpressionUUID->"6049f5bd-705e-4ac0-b057-7d72354739d5"],
Cell[623039, 15970, 980, 26, 73, "Input",ExpressionUUID->"e330abbc-e894-46a4-8177-619a648a6c45"],
Cell[CellGroupData[{
Cell[624044, 16000, 295, 7, 30, "Input",ExpressionUUID->"bc47b6f7-ef7f-4742-ad45-5e7485eebf89"],
Cell[624342, 16009, 14397, 283, 165, "Output",ExpressionUUID->"2360f4e2-607d-4e17-9290-990983db551b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[638776, 16297, 347, 8, 30, "Input",ExpressionUUID->"dcbe0d77-c6a4-4d18-b37e-26d33000de86"],
Cell[639126, 16307, 9207, 184, 136, "Output",ExpressionUUID->"6058707a-844a-4e9a-a7e9-a3c4723e0197"]
}, Open  ]],
Cell[648348, 16494, 181, 3, 51, "Text",ExpressionUUID->"47625ae5-5b80-420a-8e47-2d5a431669d0"],
Cell[648532, 16499, 1280, 29, 229, "Input",ExpressionUUID->"4aa95348-1a62-48cf-8a80-5c9e7d19c302"]
}, Open  ]]
}
]
*)

