(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     95959,       2536]
NotebookOptionsPosition[     87830,       2388]
NotebookOutlinePosition[     88228,       2404]
CellTagsIndexPosition[     88185,       2401]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Calculations for confidence-bound   (Problem 12.5)", "Section",
 CellChangeTimes->{{3.6305236296473503`*^9, 3.630523654038866*^9}, {
  3.793992353653928*^9, 
  3.793992358468684*^9}},ExpressionUUID->"2f71bf18-8dd6-4768-a58c-\
b67fb82ff263"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[2210]:=",ExpressionUUID->"1b8af986-c0d9-4d0f-9eb0-42725db38e25"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{"p", "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "b"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "a"}], ")"}], "p"}], "+", 
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}]}]}], ")"}]}], 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "b"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "a"}], ")"}], "p"}], "+", 
         RowBox[{"a", 
          RowBox[{"(", 
           RowBox[{"1", "-", "p"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"b", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "a"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"1", "-", "p"}], ")"}]}], "+", 
         RowBox[{"a", " ", "p"}]}], ")"}]}]}]]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"eq", ",", "p"}], "]"}], "//", "FullSimplify"}]}]}], "Input",
 CellChangeTimes->{{3.630520408509886*^9, 3.630520477665118*^9}, {
  3.79399236976151*^9, 3.79399237016171*^9}},
 CellLabel->
  "In[2211]:=",ExpressionUUID->"a77b733e-0c27-4a3e-ad65-87067d5a6c6c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", "\[Rule]", 
     FractionBox[
      RowBox[{"1", "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "a", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]], "-", 
       RowBox[{"2", " ", "b"}], "+", 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"4", " ", "b"}]}], ")"}]}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "a"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "b"}]}], ")"}]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", "\[Rule]", 
     FractionBox[
      RowBox[{"1", "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "a", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]], "-", 
       RowBox[{"2", " ", "b"}], "+", 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"4", " ", "b"}]}], ")"}]}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "a"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "b"}]}], ")"}]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.793992384717279*^9, 3.793992529358939*^9, 
  3.793992641291333*^9, 3.823228153069079*^9},
 CellLabel->
  "Out[2212]=",ExpressionUUID->"373403bf-d8f3-4b95-92af-cccb1724902d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq1", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"p", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "b"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "a"}], ")"}], "p"}], "+", 
           RowBox[{"a", 
            RowBox[{"(", 
             RowBox[{"1", "-", "p"}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "a"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"1", "-", "p"}], ")"}]}], "+", 
           RowBox[{"a", " ", "p"}]}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "b"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "a"}], ")"}], "p"}], "+", 
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}]}]}], ")"}]}]}], ",", "p", ",", 
    "Simplify"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.636650057781608*^9, 3.636650127282783*^9}, {
  3.636650157873725*^9, 3.636650159560175*^9}, {3.636650190881248*^9, 
  3.6366501918304157`*^9}, {3.636656164186203*^9, 3.63665616429994*^9}},
 CellLabel->
  "In[2213]:=",ExpressionUUID->"e77cf390-15a3-4d1e-a212-e4c65ed5d9a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "b"}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", 
        RowBox[{"4", " ", "b"}]}], ")"}]}], "+", 
     RowBox[{"2", " ", "b"}]}], ")"}], " ", "p"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "a"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "b"}]}], ")"}], " ", 
   SuperscriptBox["p", "2"]}]}]], "Output",
 CellChangeTimes->{{3.636650111429655*^9, 3.636650127642363*^9}, 
   3.636650160170377*^9, 3.636650192974135*^9, 3.636654446325712*^9, 
   3.636655533211727*^9, 3.636656202491139*^9, 3.6366562590125847`*^9, 
   3.636656669316889*^9, 3.636667209809587*^9, 3.636810331372752*^9, 
   3.636901729446286*^9, 3.6369036935709333`*^9, 3.637375793610468*^9, 
   3.66664216516752*^9, 3.666644024175408*^9, 3.765769382615242*^9, 
   3.793992384723947*^9, 3.7939925293665447`*^9, 3.793992641319386*^9, 
   3.823228153090921*^9},
 CellLabel->
  "Out[2213]=",ExpressionUUID->"45f4a00a-2389-4a43-9b84-f53bfca13932"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq2", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"p", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "\[Minus]", "b"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"p", "\[Minus]", 
            RowBox[{"2", "a", " ", "p"}]}]}], ")"}]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"1", "\[Minus]", "a"}], "\[Minus]", "p"}], "+", 
           RowBox[{"2", "a", " ", "p"}]}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "\[Minus]", "b"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"p", "\[Minus]", 
         RowBox[{"2", "a", " ", "p"}]}]}], ")"}]}]}], ",", "p", ",", 
    "Simplify"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.636655998899394*^9, 3.636656076044434*^9}, {
  3.636656173322249*^9, 3.636656173379526*^9}},
 CellLabel->
  "In[2214]:=",ExpressionUUID->"33cb6666-20f6-4573-95f3-74ddada1e64f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "b"}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", 
        RowBox[{"4", " ", "b"}]}], ")"}]}], "+", 
     RowBox[{"2", " ", "b"}]}], ")"}], " ", "p"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "a"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "b"}]}], ")"}], " ", 
   SuperscriptBox["p", "2"]}]}]], "Output",
 CellChangeTimes->{3.636656076757739*^9, 3.636656202640432*^9, 
  3.6366562591635036`*^9, 3.636656669399117*^9, 3.6366672099104633`*^9, 
  3.636810331455676*^9, 3.636901729529891*^9, 3.636903693654913*^9, 
  3.637375793694922*^9, 3.666642165252603*^9, 3.666644024274383*^9, 
  3.765769382730001*^9, 3.793992384790897*^9, 3.7939925293945923`*^9, 
  3.793992641326126*^9, 3.823228153095752*^9},
 CellLabel->
  "Out[2214]=",ExpressionUUID->"5ae9a048-50f5-4285-a38d-b4dd3d8b38c6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"psol", "=", 
   RowBox[{"p", "/.", 
    RowBox[{"sol", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.630524129891514*^9, 3.630524158263196*^9}, 
   3.636654555400031*^9},
 CellLabel->
  "In[2215]:=",ExpressionUUID->"44158ebd-ef64-4a9c-b902-d12db7102f44"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eq", "/.", 
   RowBox[{"a", "\[Rule]", 
    FractionBox["1", "2"]}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.630523986231337*^9, 3.63052399256313*^9}, {
   3.630524022908311*^9, 3.630524043785812*^9}, 3.636656145234807*^9},
 CellLabel->
  "In[2216]:=",ExpressionUUID->"d1737c8e-f3e5-4d99-869d-20785a6e0358"],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "+", "p"}], "\[Equal]", "1"}]], "Output",
 CellChangeTimes->{
  3.630523993132971*^9, {3.6305240236688013`*^9, 3.630524044121388*^9}, 
   3.636135385008812*^9, 3.6361378616558933`*^9, 3.636230292834239*^9, 
   3.6366444224250526`*^9, 3.636649973879616*^9, 3.636654446493619*^9, 
   3.636655533401143*^9, 3.636656202738452*^9, 3.6366562592954473`*^9, 
   3.636656669533147*^9, 3.636667210007831*^9, 3.636810331554137*^9, 
   3.63690172961165*^9, 3.636903693755368*^9, 3.637375793777923*^9, 
   3.666642165350711*^9, 3.666644024372031*^9, 3.7657693828750067`*^9, 
   3.793992384858244*^9, 3.793992529426824*^9, 3.793992641345709*^9, 
   3.823228153123275*^9},
 CellLabel->
  "Out[2216]=",ExpressionUUID->"7a04a545-4d34-4540-9c70-b0c529bdfd84"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"b", "+", "p"}], "\[Equal]", "1"}], ",", "p"}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.630524000567339*^9, 3.630524008147588*^9}, 
   3.6305240492005243`*^9, 3.636656155255494*^9},
 CellLabel->
  "In[2217]:=",ExpressionUUID->"e2cb673d-80a0-4683-ba4c-cf3e20f82435"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"p", "\[Rule]", 
    RowBox[{"1", "-", "b"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.630524008815827*^9, 3.63052404952031*^9, 
  3.636135385060898*^9, 3.636137861700808*^9, 3.636230292901682*^9, 
  3.6366444224587603`*^9, 3.6366499739108677`*^9, 3.6366544465254297`*^9, 
  3.636655533451474*^9, 3.63665620277426*^9, 3.63665625934625*^9, 
  3.636656669566371*^9, 3.636667210057249*^9, 3.636810331602853*^9, 
  3.636901729646369*^9, 3.6369036937874804`*^9, 3.637375793810254*^9, 
  3.666642165400529*^9, 3.666644024422872*^9, 3.76576938288721*^9, 
  3.793992384863947*^9, 3.793992529431905*^9, 3.793992641357874*^9, 
  3.8232281531440773`*^9},
 CellLabel->
  "Out[2217]=",ExpressionUUID->"66d0bba7-dedf-4595-a071-dc5e1303e795"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["psol"], "Input",
 CellChangeTimes->{{3.6305242489414454`*^9, 3.630524249490425*^9}},
 CellLabel->
  "In[2218]:=",ExpressionUUID->"4b2e623d-2bd0-46fc-8519-d3c1803ad1ca"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]], "-", 
   RowBox[{"2", " ", "b"}], "+", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"4", " ", "b"}]}], ")"}]}]}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "a"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "b"}]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.6305242497772703`*^9, 3.636135385110346*^9, 
  3.6361378617371283`*^9, 3.636230292952126*^9, 3.636644422487836*^9, 
  3.636649973930977*^9, 3.6366544465441236`*^9, 3.636655533501178*^9, 
  3.6366562028238363`*^9, 3.636656259439129*^9, 3.636656669657963*^9, 
  3.6366672101094103`*^9, 3.6368103316551228`*^9, 3.6369017296794853`*^9, 
  3.6369036938228197`*^9, 3.637375793845377*^9, 3.666642165435401*^9, 
  3.6666440244745827`*^9, 3.7657693829615498`*^9, 3.793992384893408*^9, 
  3.793992529460534*^9, 3.793992641364759*^9, 3.82322815314924*^9},
 CellLabel->
  "Out[2218]=",ExpressionUUID->"2e501db8-099c-474f-8179-56ec1cf966bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"psol", "/.", 
      RowBox[{"a", "\[Rule]", "0.2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "0", ",", "0.5"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"psol", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "0.2"}], ",", 
    RowBox[{"b", "\[Rule]", "0.3"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.630524256337433*^9, 3.6305243046108713`*^9}, {
   3.636903079648365*^9, 3.636903080102652*^9}, {3.666643054538486*^9, 
   3.6666430568404512`*^9}, 3.666644066564487*^9, {3.793992567237711*^9, 
   3.793992567647875*^9}},
 CellLabel->
  "In[2219]:=",ExpressionUUID->"80a6e3e9-1013-4294-a85b-0cdd52d5821e"],

Cell[BoxData["0.8516287047744076`"], "Output",
 CellChangeTimes->{3.7939925686865273`*^9, 3.793992641389615*^9, 
  3.823228153175528*^9},
 CellLabel->
  "Out[2220]=",ExpressionUUID->"5b888bbf-9f86-41f8-820f-4dcde4a3643f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"psol00", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"psol", ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"psol00n", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"Normal", "[", "psol00", "]"}], ",", 
     RowBox[{"0", "<", "a", "<", 
      FractionBox["1", "2"]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6369029869924088`*^9, 3.6369030018601303`*^9}, {
  3.666642927095838*^9, 3.666642930605885*^9}, {3.6666436406919127`*^9, 
  3.666643648633988*^9}, {3.666643958907547*^9, 3.6666439599296513`*^9}},
 CellLabel->
  "In[2221]:=",ExpressionUUID->"a77079fa-bad8-4ad0-9a9c-f74a9a05a1c5"],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{"a", " ", "b"}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", "a"}]]}]], "Output",
 CellChangeTimes->{{3.6369029947713537`*^9, 3.636903002514153*^9}, 
   3.636903694673407*^9, 3.63737579467585*^9, 3.666642166205168*^9, 
   3.666642931891073*^9, {3.6666436427967854`*^9, 3.666643649177203*^9}, {
   3.666643961059648*^9, 3.666643968201406*^9}, 3.66664402462097*^9, 
   3.765769383135257*^9, 3.7939923849744577`*^9, 3.793992529545166*^9, 
   3.793992641417602*^9, 3.8232281532097816`*^9},
 CellLabel->
  "Out[2221]=",ExpressionUUID->"75b817b2-a147-4209-997a-71d2ef756b1f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"psol05", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"psol", ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       FractionBox["1", "2"], ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"psol05n", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"Normal", "[", "psol05", "]"}], ",", 
     RowBox[{"a", ">", "0"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.666642325149165*^9, 3.666642364005986*^9}, {
   3.666642934775628*^9, 3.6666429382391157`*^9}, {3.666643272513369*^9, 
   3.666643288648724*^9}, 3.666643386542797*^9, 3.666643574680707*^9, {
   3.666643931197546*^9, 3.666643945732255*^9}},
 CellLabel->
  "In[2222]:=",ExpressionUUID->"b8f5627a-97a4-447e-9d26-9a14f7c392f0"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "a"}], "-", 
   RowBox[{"2", " ", "b"}]}], 
  RowBox[{"4", " ", "a"}]]], "Output",
 CellChangeTimes->{{3.666642335734535*^9, 3.666642364645473*^9}, 
   3.666642938696805*^9, {3.666643264638254*^9, 3.6666432893127747`*^9}, 
   3.666643387453691*^9, 3.666643575790559*^9, {3.6666439316468077`*^9, 
   3.666643947839623*^9}, 3.6666440246723423`*^9, 3.765769383209667*^9, 
   3.7939923850271063`*^9, 3.7939925295888653`*^9, 3.793992641460202*^9, 
   3.823228153257777*^9},
 CellLabel->
  "Out[2222]=",ExpressionUUID->"93abf489-000c-4571-b7bb-a11430dc1f90"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.666643474112455*^9, 3.666643478359676*^9}},
 CellLabel->
  "In[2223]:=",ExpressionUUID->"6a487935-028c-467c-bf44-4168070490da"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"psol00n", "/.", 
      RowBox[{"a", "\[Rule]", "0.2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "0", ",", "0.22"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Dashed"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"psol05n", "/.", 
      RowBox[{"a", "\[Rule]", "0.2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "0.39", ",", "0.5"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Dashed"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p1", ",", "p2", ",", "p3"}], "]"}]}], "Input",
 CellChangeTimes->{{3.666642957095023*^9, 3.666642991309785*^9}, {
   3.6666430236520576`*^9, 3.666643130526251*^9}, {3.666643175726162*^9, 
   3.6666432178203373`*^9}, 3.666643561882924*^9, {3.66664361272507*^9, 
   3.666643621165107*^9}, {3.666643711306736*^9, 3.6666437361045113`*^9}},
 CellLabel->
  "In[2224]:=",ExpressionUUID->"d894dde8-1761-4b46-8cd6-7c2068519d76"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVx3k4lAkAx3HHtKPUuLZjKmlEmxStUCr9WG1ExzrKkiKkSJJsl9qa1iiE
2vW0lRxlluTJlHPJtZm0SW7GlJn3NY6Y62Ufk9iH2faP7/N9PqzgU15HtTQ0
NPZ86f+7Hx1prx/9fvs/IQ9n1WoKNJel0QTTDKccrH7jffHG7LsPSpi28J8x
MA78Yo93guJM5g5wNXv0a2cp+IZO1vzK9IGsbOH5uBkKIuvrLinMUBj1Z7tM
TFPIWbgvIYkZi87BVfUiFQW2Tsk3icx43HfdJUiTUfjR7yFvbDwd849w6Zld
FHTV7ADXFdmQrfRzOlZLwdxTOdKQzMU202D7D/kUzrU44O5EAbZX5MRfSqWw
uNRArKnJQ8C19YYjP1Eol7g0t24rRm4i13WLP4WXEZnL/OSl0M+D05gjBdVq
R72nJysgaRvr/9mUgtZUof4y8yq4p/BT4rUp2KuDyr2LqpHc/MQjeEiJ5njb
lsa1dYhUuBc/alTC5JZsqkBZj+Wv42J6cpWQTRLi7g0vQdvnW0OxleBKXzQx
UhvQ/SrkSMJBJRjG+dTgIB/pLed059gqcTO8LCzHrBH3rDZ/PrtAiU9OhYPH
r7zGgJ2wJa9fgVgbfumihr+xaei021/lChBF/OR2VhPexqw0ozgK/BvRlWFx
8S04UZcunvVWwNKZPhv2ohlNMZ7bxlkKuD5iHXu+uAX9Rt4lR0flOGccaNof
0IrWbvWGyudyrJPv1xXsaYNLV22V43k5jPTGdPjTbdh5e4YeYi8HrS6Dt+pB
Oww3TorCVDKcsH0hnOvRgaiqYbP2JzIU7grOqf3UgRMJggrGIRlUsqX6w3c6
URT2av8afRnKvF2103d04XrBEtOsCimuuHGyS4e7ML+D/a4hUAqWyL03l9ON
SK0q6zCaFFs2xaczbXrQrEOFT9wfRcCK1inNzh7cFodYOtqMQtWUIolmCzCe
EJW3v3IEd2mHY73MeuG4t75Jz3kERuKyR1r8XmRuiVskaPiIOZfZPg6nhUhd
Jr0ZvfEjNAoO8ySG75EvvMr15A4j5j4vxfDle4zVGOUMqYdQY3lDxyDqA6rm
0XZO+QzBwD1m3TVGH5yDrA5YPx1E3/q2zgvVfdCrqJlJUw7gWRbMBg+LEE23
8GfaDeAQz97AeFaEyjO5K1ZfkOAq5yG774kYdayKVF5+P56OGGcwdhOAxRsl
hyRxI5MTJN5L4HhfivorEYlQL4V5kSeBAyb7pNeFJJZXVz/b40vgrP+qHxI7
SCSlHWy8GUzg81T2ySQ+ieP298bnXSBQZiqITXhMwjT+azd6HgFO7LQkPJrE
7OZLCwSPCXgkFvp/jCQhVAx05BUSmFtyuS40nMQt35JDO58TcPEd9woMJqFe
63WGU03ATcAo9vYh0deelqXdSUDywVzosJnEnwmTIZ3dBKi5lSfKbUmkbw20
yO0lsDLDXGXzLQmPP6xKvxMTuDEwrbRcS6Lq/Ls37FECmRP5acbLSdxZb5fm
KSdQ3r1Yem8JidOSBz4sisBJubPTooUk1uyOJOonCNzJspMwGCRoml3cW5ME
kso3WSfPI0GWbY0ImiYgmgq9SKeTqI7Itd4wQ+B2kR//F20Sv5voqtRqAs/i
iAUaGiT+AwuVfRg=
        "]]},
      Annotation[#, "Charting`Private`Tag$818761#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwV0XtQjXkYB/BOLCrqaCVaSpdJe9aEkl2pvquLTiKkg7QVXcSUiLTIIrkU
NVHpwhGrRtktXnWKakudrqf36MKiFJEuon5vpYvBOe1v/3jmmc88M8/znXkM
/fa7B6qqqKhsoPV/73FLt7witLTbWho4OTnJob2QWeXDzMaNOIcbHdQ5budy
fmYM0edtiGJqrR+GfU2Y5fhd5dWJg9T2UbdL9Zg1SHPyUHYrOfy2Iqpfh9mM
tiZ7hUzBoT8+9NT3zC54dxt8TfrK4Z51j6s2Ewb/WS/HF09wWDrbpisq9DS4
qoUnLg9yiHwgcN7idxEuzx7mXu/mUDKZ/zF1TiJ4V82an7dzqPbXX2/3IgW/
VAVFb37CQW1Xh8pl4TXYOStfhcroPq3R3viZN1G1NKD+8SMOjnM3zEvZewvZ
bEa2ZxGH8b1Nh0avZ2G7dJl5TB7Nc/1IO+FlI3ZhouPnTA7f6bvug+0dxDxd
p6pxjUNd7ZDMfd/f6LFplaxL5HBpY5mF6uM8SNWtJtgYmjexrWuKKoMQy/43
3EkOFoNB+R5W95FSEbJDFMFBv8O3b5p/Pgx4NfV9IRw8w0KWBxwvwGFx+OsF
ARxSI+KiEvIkcBV/ik7awcHEqLI3sKEQ3LisOXczh0JbNXf1ySJoF+3Pmy6k
9wZLjPjmD5Fs9uFEgh3N4xA1o1JYjO6x0oliK/ovNa9RRJagYLG3iukS+q8I
l7G96aXYJBExK4w55Eb86TV2/x+4jhqJDuhxWN83s96tqwy1aY9iB/kcVivj
XLYoy6GZVhA4awbNZ3/pvfb8Crz4GtESqiT4qVmzcwlTAYW2loVilKCX0d25
wLYSI2eUq8wHCDJdBN0jzyqx26us5WYXwXmrupGMACly4p7yi9oIzn2cJ4kc
kkIYVu74uZnOPcOPIKYKe0qOzDheR3BPb0ddq041RD4XDt0qJ2hLcpnvea8a
0t3BoeqFBIKdVWN37WqgkGXydXIJUsaHz1ixNUh9w2SvzySY6iTQzfSvBeMV
31iTTpDeO2DZO1yLlOWV4reXCJb9WryFH1cHRXD1F7vzBF3+1qbBxvWQeoo3
yP4gKH3pFH2NqYfHLdZ5PJzuV/N6l+8iQ9DGhpaAYIK0i18e32iVYe22RVMi
/AgKX7gFlwU04Ky2648ST4J/23M1pN8a4GDh1Gm5iUDP8spK8QUWjbkpNlud
CZIvZIh14lls011525xasytbNSGBRWfUM63p1LzLJY1RySyGts5592AtwXvS
uTsog4U2LzF2PvWDvwSpFvksRKL45x2OBB5GFRP1bSzaFdEH/O0JGo/KvO07
WPjvMX65mlrY8qSq9DWLgSdShznUNqd6Eu6+Y/Etm6dbs4bA+LW6WfIgC333
k2Wm1CPpou2+PDl23T6m/gEEIcM+5a1T5Ojn64VLqXuFe0zcp8lxMLL41VXq
toljQ44acpze9Jlxpa4Q3YwR6MiR9eXwtjw7Auu8OyRTV44lgTqVZ6klUws8
FurJUdgkEfhQ5xTULOIbyFGb9UmhSW2k0XQu1lAON62koD5bArFf64CqiRzP
j1q0PKKeW/LW/bipHL7dLdZp1AmzPz4cM5Ojzy0s6wD1f8Iqe7o=
        "]]},
      Annotation[#, "Charting`Private`Tag$818989#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVyX881HcAx/HjworSlImUrqTf+ZF+t94PyoOKOq3SiKQsF0o/KOs8kpV+
XEdRDv0SumZZhUZlGUaYWCO639/P3bkfhClzrOvY7Y/34/14Pl6MiCPbI01p
NFqAcf//rbX112qHBEiKb2p6/VqL07oAG6ZOADVnZvd0o4NLOjOkRjPzj38R
3ayF/Txt5siwAIw/Z/iO/0OLLBvLrKWfBKiff6zOp0GLq93M3NxRAawkDr9V
1WhxjifJP2YhxE3vmKdPyrWIHhwsm20vxAtr67vX87RYa6/KYkOIhLx9Gwrj
tOhoPyXZsl+IFcNRi+UbtBiqfr71YKoQra086aidFl85vjzLLhZCdas99IBW
AxOr/XYWb4QYc6ubPVypQS+rOZajEyKnsqb8L44GYZ/IQIijCJYNahvuHg1y
nXI670GE5Ozqsng3DTpLpyTJI0WID38wh0/TQCJyS826JEJsv7eA/lYN1nJ9
Ja9YhK8NZju9f1RDZ7hQmtEmAte0M6/xlBoBIRWWdJ0IpCXYne2vRqFL0dxY
RzHK0nuvnnRUI8XZL2aOtxhhbfeffdOnwsKKS7bbIsWwEk+ZG1qjQlsF98wJ
jhhrRGnhj66psDHA09/6sRjRd6vI4kgVKpi3hQUdYjiG6F0HPVV4klqWeU4v
RiFvr2+umQrHA2OeiGZK4JZ7quCwsAsrL2u4C30kWJd5p/VyURfqgsxa/46S
YMv2xPVv2V0QBL1ZY3JFAo+M0wmjzC701YdGWZVKkN14OSmO0YXmRu7IlQ4J
TOu3NlkPKfHT6uRNFp8l6K1w6tLVKTFZ6tTQwpCieNG0hqobSsA24sF4HymO
Rdb3l7GUOFL5nR+ipSi/cUY1sFoJlm6if0+aFAZO/6yQiUp0749gy0ukmEE/
78yXK3AIibFt76T4NW7+8KpSBX557FGzSi9FWGHypH/PK0BLe9SRzZAhuVX1
D22XArYmLf6HfWTgV405rVigQAk/eyA9SoYCV68p/gY5Al647HyYJsMsXnpH
UYscZRFBjutKZciry5B43pPDPnFz4SuBDPe0+aUWR+Uwr+3ZfXtUhkSuiFnp
JcfLu0viuhkUdoy8WnbLVo4T7z38XP0oPP62WlWnIhhqFqX0RFOYdPawxOE5
gUHm2vMhjcLGBRtvBnIJzMJ9bQafUvjU4LLgTSjBu3iT2ywBhaeLq/Sn3QnK
m3/QWQgphHqJLcvdCK4zzJl8oy12jUwfcCVgtkygK0UU9pzxWHdgKUGj81TW
HikF8zY+238RwbN2l+XbFBSCT6YbHOcSZLv7t3j2UjCtDR97OY0g4UKrS7vR
P3cmWY/YEeyQMpOP9lEIep/r5GH05Es7lz3qp1A8tQN8W4KLJCxn3gcKuw5u
Sk6zIUhMPxrpoKNQZOVhsteKYLdqsOqZ0dsZ277MsSRYsTZhWtAwBcPyGEb7
BIKP6u+bM0eMfS/fy3c8waH159wn6il8LnFIcTUn8LtuznloNP/VygyWGYFL
z8WuTZ8pBIp35BeMI1Dc4PJSDcY+Lr3Wjk5Q/d76g/MoBaZ9cVugKcEdr4zN
vxutX9Kk4JgQsHlTC/eNUbjvrf5YTyMI7ssyjBnNDKLTaUb/B4N6hnI=
        "]]},
      Annotation[#, "Charting`Private`Tag$819035#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.5000000258404409},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.666642993057526*^9, 3.6666430369985447`*^9, {3.666643086415577*^9, 
   3.666643131096569*^9}, {3.666643178300947*^9, 3.666643218213893*^9}, {
   3.666643266786117*^9, 3.666643290820887*^9}, 3.6666434361822357`*^9, 
   3.666643562742111*^9, {3.666643607175511*^9, 3.6666436214783382`*^9}, {
   3.6666437133908653`*^9, 3.6666437365492496`*^9}, 3.666644024751549*^9, 
   3.765769383492814*^9, 3.7939923850792513`*^9, 3.793992529648061*^9, 
   3.793992641495659*^9, 3.8232281533078413`*^9},
 CellLabel->
  "Out[2226]=",ExpressionUUID->"a50956db-4cc8-4681-becd-8c54c39ae837"]
}, Open  ]],

Cell["\<\
Condition where filter inference first disagrees with observation:\
\>", "Text",
 CellChangeTimes->{{3.6361437698018217`*^9, 3.636143800835778*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"0cebc15a-e5b6-48f5-b80e-2119f5df39d8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"eq3", "=", 
    RowBox[{
     FractionBox[
      RowBox[{"b", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "a"}], ")"}], "psol"}], "+", 
         RowBox[{"a", 
          RowBox[{"(", 
           RowBox[{"1", "-", "psol"}], ")"}]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "a"}], ")"}], "psol"}], "+", 
          RowBox[{"a", 
           RowBox[{"(", 
            RowBox[{"1", "-", "psol"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "b"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "psol"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "a"}], ")"}], 
           RowBox[{"(", 
            RowBox[{"1", "-", "psol"}], ")"}]}]}], ")"}]}]}]], "//", 
     "FullSimplify"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"eq3", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"b", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"psol", "\[Minus]", 
         RowBox[{"2", "a", " ", "psol"}]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"b", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"psol", "\[Minus]", 
          RowBox[{"2", "a", " ", "psol"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "b"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "\[Minus]", "a"}], "\[Minus]", "psol"}], "+", 
         RowBox[{"2", "a", " ", "psol"}]}], ")"}]}]}]], "//", 
    "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.6361372254420424`*^9, 3.636137291819437*^9}, {
   3.636143704688223*^9, 3.636143710138467*^9}, 3.636656180868936*^9, {
   3.6366562807417297`*^9, 3.6366562897594213`*^9}, {3.636656345806992*^9, 
   3.636656408324382*^9}, {3.63665646267199*^9, 3.636656483520135*^9}},
 CellLabel->
  "In[2227]:=",ExpressionUUID->"7a812388-8a09-4dd2-adc4-a93722f0034d"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "a", "+", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]], "-", 
     RowBox[{"2", " ", "b"}]}], ")"}], " ", "b"}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "a", "+", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "b"}]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.63614370536679*^9, 3.636143710755465*^9}, 
   3.636230293680732*^9, 3.63664442303261*^9, 3.6366499743851023`*^9, 
   3.6366544469922447`*^9, 3.636655534038011*^9, 3.63665620335496*^9, 
   3.636656259898424*^9, {3.636656473325851*^9, 3.636656484458107*^9}, 
   3.636656670133691*^9, 3.636667210655623*^9, 3.6368103323258553`*^9, 
   3.636901730222805*^9, 3.636903695042224*^9, 3.6373757950276337`*^9, 
   3.666642166576976*^9, 3.666644025164187*^9, 3.7657693838770933`*^9, 
   3.793992385277327*^9, 3.7939925298672132`*^9, 3.79399264169631*^9, 
   3.82322815352736*^9},
 CellLabel->
  "Out[2227]=",ExpressionUUID->"a25a7af7-2bd5-42a9-8c04-a2ea582ae3be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t0", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "b", 
     RowBox[{"(", 
      RowBox[{"1", "-", "a", "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "a", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]], "-", 
       RowBox[{"2", " ", "b"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "a", "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "a", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", "b"}]}], ")"}]}]}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.636667246502284*^9, 3.636667301002266*^9}},
 CellLabel->
  "In[2228]:=",ExpressionUUID->"f334be57-f22f-45e2-867d-5b8f27dcfc10"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "-", "a", "+", 
  SqrtBox[
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]], "+", 
  RowBox[{"4", " ", "b"}], "-", 
  RowBox[{"4", " ", 
   SuperscriptBox["b", "2"]}]}]], "Output",
 CellChangeTimes->{{3.636667277651387*^9, 3.636667301349965*^9}, 
   3.6368103323684273`*^9, 3.636901730382181*^9, 3.636903695082447*^9, 
   3.637375795065765*^9, 3.6666421666205883`*^9, 3.666644025222583*^9, 
   3.765769383949761*^9, 3.7939923853096237`*^9, 3.7939925299019117`*^9, 
   3.793992641717598*^9, 3.823228153550075*^9},
 CellLabel->
  "Out[2228]=",ExpressionUUID->"ff532f45-c27a-4aa4-a52f-727005e3b22f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}], "==", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", "b"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["b", "2"]}], "-", "1", "-", "a"}], ")"}], "2"]}], "//",
    "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.636667338934496*^9, 3.6366673817280807`*^9}, {
  3.6366674140889053`*^9, 3.636667414271158*^9}},
 CellLabel->
  "In[2229]:=",ExpressionUUID->"b947e030-3bca-4850-946b-6ce2469790db"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "b"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "b"}], ")"}], " ", "b"}]}], ")"}]}], 
  "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{3.6366673822797937`*^9, 3.636667415669463*^9, 
  3.636810332389679*^9, 3.6369017304152527`*^9, 3.636903695127548*^9, 
  3.637375795198913*^9, 3.666642166653894*^9, 3.666644025272521*^9, 
  3.7657693840242357`*^9, 3.7939923853178663`*^9, 3.7939925299097767`*^9, 
  3.793992641730467*^9, 3.823228153572247*^9},
 CellLabel->
  "Out[2229]=",ExpressionUUID->"6c42d611-b1b1-48da-bf1c-5e9fb7ac618f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol3", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"eq3", "\[Equal]", 
     FractionBox["1", "2"]}], ",", "b"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.636137684349434*^9, 3.636137709489615*^9}, {
   3.636137753627964*^9, 3.636137758012521*^9}, 3.6361378979990473`*^9, {
   3.6366561826764297`*^9, 3.636656184796363*^9}},
 CellLabel->
  "In[2230]:=",ExpressionUUID->"8320549d-7d19-4d57-9b23-ea5c5d94d24a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox[
         RowBox[{"1", "-", 
          RowBox[{"4", " ", "a"}]}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox[
         RowBox[{"1", "-", 
          RowBox[{"4", " ", "a"}]}]]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6361377585199223`*^9, 3.6361378623313437`*^9, 
  3.636137898574918*^9, 3.636230293731883*^9, 3.636644423189993*^9, 
  3.63664997444219*^9, 3.6366544470936947`*^9, 3.6366555340850058`*^9, 
  3.636656203394642*^9, 3.6366562599491053`*^9, 3.636656486994068*^9, 
  3.636656670182558*^9, 3.636667210704935*^9, 3.636810332447667*^9, 
  3.636901730469994*^9, 3.6369036952658777`*^9, 3.637375795256867*^9, 
  3.6666421667908983`*^9, 3.666644025323657*^9, 3.765769384098311*^9, 
  3.79399238534851*^9, 3.793992529945812*^9, 3.793992641756331*^9, 
  3.823228153600025*^9},
 CellLabel->
  "Out[2230]=",ExpressionUUID->"4e6f3fce-78ff-4609-8c7d-ae975b7230a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"bsol3", "=", 
    RowBox[{"b", "/.", 
     RowBox[{"sol3", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}], ",", 
   RowBox[{"bsol3", "/.", 
    RowBox[{"a", "\[Rule]", "0.2"}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.636137722637827*^9, 3.636137735364562*^9}, {
  3.63613790686096*^9, 3.636137928193454*^9}, {3.63614373783994*^9, 
  3.6361437430077667`*^9}, {3.636656220392878*^9, 3.636656220521473*^9}, {
  3.636656659203333*^9, 3.636656664057293*^9}},
 CellLabel->
  "In[2231]:=",ExpressionUUID->"baf83936-f345-4425-a8c9-9662b57374ae"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "0.27639320225002106`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.63613773578961*^9, 3.6361378623549128`*^9, {3.636137923493247*^9, 
   3.636137928543482*^9}, 3.6361437434536133`*^9, 3.636230293773837*^9, 
   3.636644423227539*^9, 3.636649974476303*^9, 3.636654447113563*^9, 
   3.636655534120757*^9, {3.636656203439642*^9, 3.6366562211819677`*^9}, 
   3.636656259996049*^9, 3.63665667020446*^9, 3.636667210739246*^9, 
   3.636810332468781*^9, 3.636901730498961*^9, 3.636903695311235*^9, 
   3.637375795298637*^9, 3.666642166822845*^9, 3.666644025372306*^9, 
   3.765769384182403*^9, 3.793992385353896*^9, 3.7939925299522552`*^9, 
   3.793992641762288*^9, 3.823228153605596*^9},
 CellLabel->
  "Out[2231]=",ExpressionUUID->"9132104b-9999-41a7-827f-c3558b63b753"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"bsol3", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "0.25"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6361379308068657`*^9, 3.636137941040989*^9}, {
   3.6361389305953627`*^9, 3.636138944928976*^9}, 3.636656660826171*^9},
 CellLabel->
  "In[2232]:=",ExpressionUUID->"8fe75dad-0543-4d6c-91cd-d1a5af3b9895"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVkHs41PkCxselUFEiHSTHNZfakJVLeYmzNHQh5WjdtpBVHFmSs8QIIdKW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       "]]},
     Annotation[#, "Charting`Private`Tag$819782#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJxFxW0w03EcAPCNdZRrDOX+NG6aylOcUFKpuMhDndHJ5emEtJ6QO+nqtG6T
PLRdtxN5fohYDNvkbB5iKfKQxuGOrdbOkec7s6PLqhe+vxef+1Bi79HidXA4
XNA///ePnxvtnnc7szPB2zxJgZl67XysrKBYgFHhgKGJlhLMFQ6L03S8xHzg
Gadn3nlYKFy+73JmNhYHM/QFh59jqfDV8Ar+6hoTNtAyInwt2bBN8PJcbw4X
Thv28CpYL4TNhCQ5Hl8Gtyq9B0dOVcI99BKL8MVqWH3otGHDnVpYZ5NnZGFT
D7trY1pDGt/Bg0zX4T47PmzFWdisW26CFzQK+bhzC1z9SzxAfCGAieTaFZVK
COfeFCWUU1vhjbM8VWLGezjVRSrc39sGKxqlOaOUdvg3fazI9qEYtj+nt50g
lsC+lZQbzWadcBo52vpHRBfssHjFYCKoGzYxXNWXbqEJXUX8g8Uf4Fuu4qnd
AT0w72JseecGWr1gbjSb3wuLQnx1uT5SOMOPVSacRVNm/CerWB/hk8eZXMyl
D46wHNnEy9DqgTxlEuMTXECISqVRP8MmclGljhS96zEj1CO5H8bVRfGVxgNw
ymt+nnEPusM+S5909wtM8k9xeEochKcdv8rSJeimUi+qKmoIjuS7k8jb6Ces
CsZ0/TDcMEcuIgaOwFklrBj5JXQcbcmmMRh9QCJpCgpDZ7Ov9eXGohPdC9f2
pKOtmaZ+ejXo7ROP9k68RU8t/fxWw0NzwgSRF5rRWjvafZYEPT3KLtWVodsy
Nddl42iuZ7Rt1SQ64M1R4Xk5uv3BUD9jHp3v6MYOXkQnK4tDKSvoI4G3Fd3r
aAJ+rJqjQX8XedJjttASepWT8x/0KysDtVaL/gt1hmcD
       "]]},
     Annotation[#, "Charting`Private`Tag$819782#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.636137941644759*^9, {3.6361389351973763`*^9, 3.6361389455649652`*^9}, 
   3.636230293812386*^9, 3.636644423270114*^9, 3.636649974512863*^9, 
   3.636654447161181*^9, 3.6366555341721773`*^9, {3.6366562034905567`*^9, 
   3.636656260047369*^9}, 3.636656670249992*^9, 3.6366672107791147`*^9, 
   3.636810332511402*^9, 3.6369017305369043`*^9, 3.636903695359161*^9, 
   3.63737579534879*^9, 3.666642166865971*^9, 3.666644025423152*^9, 
   3.765769384305502*^9, 3.7939923853934793`*^9, 3.793992529998535*^9, 
   3.793992641787595*^9, 3.823228153658832*^9},
 CellLabel->
  "Out[2232]=",ExpressionUUID->"6ceb06da-40f8-40b3-ac09-b737d219589a"]
}, Open  ]],

Cell[TextData[{
 "Now repeat calculations using smoother estimate.  \nMax. confidence \
condition is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", " ", "=", 
    RowBox[{"P", "(", 
     RowBox[{
      SubscriptBox["x", "k"], "=", 
      RowBox[{"1", " ", "|", " ", 
       SuperscriptBox["y", "N"]}]}]}]}], TraditionalForm]],ExpressionUUID->
  "3ee10422-b39f-488c-b7b5-b484d2221636"],
 "=1) for N large enough to have a fixed point."
}], "Text",
 CellChangeTimes->{{3.6361437698018217`*^9, 3.636143800835778*^9}, {
  3.6366443303325644`*^9, 3.636644414445485*^9}, {3.636653259279551*^9, 
  3.636653320546273*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"221ad399-8e32-4861-b31e-a23f1eb89229"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq4", "=", 
   RowBox[{"q", "\[Equal]", 
    RowBox[{"p", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "a"}], ")"}], "q"}], 
        RowBox[{"a", "+", "p", "-", 
         RowBox[{"2", "a", " ", "p"}]}]], "+", 
       FractionBox[
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"1", "-", "q"}], ")"}]}], 
        RowBox[{"1", "-", "a", "-", "p", "+", 
         RowBox[{"2", "a", " ", "p"}]}]]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol4", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"eq4", ",", "q"}], "]"}], "//", "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.63665445023182*^9, 3.636654515388323*^9}, {
   3.63665458826703*^9, 3.636654593555397*^9}, 3.6366562464108686`*^9, {
   3.636656729898802*^9, 3.636656730114213*^9}},
 CellLabel->
  "In[2233]:=",ExpressionUUID->"e6b9ab0c-5b4e-4470-bec9-893530991606"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"q", "\[Rule]", 
    FractionBox[
     RowBox[{"p", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "p"}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "p"}]}], ")"}]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "p"}]}], ")"}], "2"]}], "+", 
      RowBox[{"2", " ", "p"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["p", "2"]}]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.6366545033135777`*^9, 3.636654515852291*^9}, 
   3.636654602185376*^9, 3.636655534218505*^9, 3.636656203518765*^9, {
   3.6366562475286407`*^9, 3.63665626009902*^9}, 3.636656670302125*^9, 
   3.636656732655541*^9, 3.636667210803772*^9, 3.636810332549624*^9, 
   3.6369017305847187`*^9, 3.636903695409878*^9, 3.637375795381503*^9, 
   3.666642166904957*^9, 3.666644025455303*^9, 3.765769384499483*^9, 
   3.793992385409416*^9, 3.7939925300152893`*^9, 3.793992641801962*^9, 
   3.8232281536774883`*^9},
 CellLabel->
  "Out[2234]=",ExpressionUUID->"1d55785d-5f72-4c50-8b93-70a66acb3c52"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"qsol", "=", 
  RowBox[{
   RowBox[{"q", "/.", 
    RowBox[{"sol4", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.636654540847826*^9, 3.6366545649637747`*^9}, {
  3.636654598477079*^9, 3.636654608353032*^9}, {3.636658510902465*^9, 
  3.636658514507856*^9}},
 CellLabel->
  "In[2235]:=",ExpressionUUID->"35b02119-eff3-4129-aa43-c6b52fae22e9"],

Cell[BoxData[
 FractionBox[
  RowBox[{"p", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "p"}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "p"}]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "p"}]}], ")"}], "2"]}], "-", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", "p"}]}]]], "Output",
 CellChangeTimes->{{3.636654604258456*^9, 3.636654608799664*^9}, 
   3.636655534268951*^9, 3.6366562035401793`*^9, {3.6366562514481363`*^9, 
   3.636656260148691*^9}, 3.6366566703521957`*^9, 3.6366567359231033`*^9, 
   3.636658515041472*^9, 3.636667210852767*^9, 3.636810332611958*^9, 
   3.636901730646627*^9, 3.6369036955448847`*^9, 3.637375795445087*^9, 
   3.6666421669671926`*^9, 3.666644025514368*^9, 3.765769384577733*^9, 
   3.793992385442429*^9, 3.7939925300496063`*^9, 3.793992641829174*^9, 
   3.823228153717616*^9},
 CellLabel->
  "Out[2235]=",ExpressionUUID->"10ba54d4-ef45-44b9-b255-0694de77cf7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"qsol1", "=", 
  RowBox[{
   RowBox[{"qsol", "/.", 
    RowBox[{"p", "\[Rule]", "psol"}]}], "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.636901739298957*^9, 3.636901779632184*^9}},
 CellLabel->
  "In[2236]:=",ExpressionUUID->"307ea5a0-b48f-4be1-9c0f-5337cc0e5145"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]], "-", 
   RowBox[{"2", " ", "b"}], "+", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "b"}]}], ")"}]}]}], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]]}]]], "Output",
 CellChangeTimes->{{3.6369017413407917`*^9, 3.6369017810160713`*^9}, 
   3.636903696153974*^9, 3.63737579600668*^9, 3.666642167536127*^9, 
   3.666644026112133*^9, 3.7657693851842546`*^9, 3.793992385739616*^9, 
   3.793992530348233*^9, 3.793992642136116*^9, 3.823228154085847*^9},
 CellLabel->
  "Out[2236]=",ExpressionUUID->"092bf568-ea47-43fa-8eea-7132b5391ebc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"qsol1a", "=", 
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "a"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", "b"}]}], ")"}]}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "a", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]]]}], ")"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.636902212958206*^9, 3.6369023007716*^9}},
 CellLabel->
  "In[2237]:=",ExpressionUUID->"197f1bad-7623-41dd-a2cb-dd4874cc8aaf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"psol", ",", "qsol1a"}], "}"}], "/.", 
    RowBox[{"a", "\[Rule]", "0.2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "0", ",", "0.5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.636654613628986*^9, 3.6366546748322477`*^9}, {
  3.636654705109714*^9, 3.636654721465015*^9}, {3.636654757172892*^9, 
  3.636654763430675*^9}, {3.6369017861565638`*^9, 3.636901787527009*^9}, {
  3.636902263100609*^9, 3.636902304571171*^9}},
 CellLabel->
  "In[2238]:=",ExpressionUUID->"7631ab30-4aff-43f2-aa03-cf4c8f1e3ed4"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVx3k4lAkAx3HHtKPUuLZjKmlEmxStUCr9WG1ExzrKkiKkSJJsl9qa1iiE
2vW0lRxlluTJlHPJtZm0SW7GlJn3NY6Y62Ufk9iH2faP7/N9PqzgU15HtTQ0
NPZ86f+7Hx1prx/9fvs/IQ9n1WoKNJel0QTTDKccrH7jffHG7LsPSpi28J8x
MA78Yo93guJM5g5wNXv0a2cp+IZO1vzK9IGsbOH5uBkKIuvrLinMUBj1Z7tM
TFPIWbgvIYkZi87BVfUiFQW2Tsk3icx43HfdJUiTUfjR7yFvbDwd849w6Zld
FHTV7ADXFdmQrfRzOlZLwdxTOdKQzMU202D7D/kUzrU44O5EAbZX5MRfSqWw
uNRArKnJQ8C19YYjP1Eol7g0t24rRm4i13WLP4WXEZnL/OSl0M+D05gjBdVq
R72nJysgaRvr/9mUgtZUof4y8yq4p/BT4rUp2KuDyr2LqpHc/MQjeEiJ5njb
lsa1dYhUuBc/alTC5JZsqkBZj+Wv42J6cpWQTRLi7g0vQdvnW0OxleBKXzQx
UhvQ/SrkSMJBJRjG+dTgIB/pLed059gqcTO8LCzHrBH3rDZ/PrtAiU9OhYPH
r7zGgJ2wJa9fgVgbfumihr+xaei021/lChBF/OR2VhPexqw0ozgK/BvRlWFx
8S04UZcunvVWwNKZPhv2ohlNMZ7bxlkKuD5iHXu+uAX9Rt4lR0flOGccaNof
0IrWbvWGyudyrJPv1xXsaYNLV22V43k5jPTGdPjTbdh5e4YeYi8HrS6Dt+pB
Oww3TorCVDKcsH0hnOvRgaiqYbP2JzIU7grOqf3UgRMJggrGIRlUsqX6w3c6
URT2av8afRnKvF2103d04XrBEtOsCimuuHGyS4e7ML+D/a4hUAqWyL03l9ON
SK0q6zCaFFs2xaczbXrQrEOFT9wfRcCK1inNzh7cFodYOtqMQtWUIolmCzCe
EJW3v3IEd2mHY73MeuG4t75Jz3kERuKyR1r8XmRuiVskaPiIOZfZPg6nhUhd
Jr0ZvfEjNAoO8ySG75EvvMr15A4j5j4vxfDle4zVGOUMqYdQY3lDxyDqA6rm
0XZO+QzBwD1m3TVGH5yDrA5YPx1E3/q2zgvVfdCrqJlJUw7gWRbMBg+LEE23
8GfaDeAQz97AeFaEyjO5K1ZfkOAq5yG774kYdayKVF5+P56OGGcwdhOAxRsl
hyRxI5MTJN5L4HhfivorEYlQL4V5kSeBAyb7pNeFJJZXVz/b40vgrP+qHxI7
SCSlHWy8GUzg81T2ySQ+ieP298bnXSBQZiqITXhMwjT+azd6HgFO7LQkPJrE
7OZLCwSPCXgkFvp/jCQhVAx05BUSmFtyuS40nMQt35JDO58TcPEd9woMJqFe
63WGU03ATcAo9vYh0deelqXdSUDywVzosJnEnwmTIZ3dBKi5lSfKbUmkbw20
yO0lsDLDXGXzLQmPP6xKvxMTuDEwrbRcS6Lq/Ls37FECmRP5acbLSdxZb5fm
KSdQ3r1Yem8JidOSBz4sisBJubPTooUk1uyOJOonCNzJspMwGCRoml3cW5ME
kso3WSfPI0GWbY0ImiYgmgq9SKeTqI7Itd4wQ+B2kR//F20Sv5voqtRqAs/i
iAUaGiT+AwuVfRg=
       "]], LineBox[CompressedData["
1:eJwVyn081AcAx/HzFEtd9KDXVdiJVLTMpEX1XcO00EYnKS55WulR9LjYNNKS
upWnFc5TUsZ5OPLKiXI9UJE7InG/3z1Mh7v7ZYWpuNkf39f39X69PszQw34R
ujQazWd6//+WCGVH06DHxk87SrRaLQV9t0VHCIY19Jcp5cPT/oqblV3NcMLx
qNrm7ml7Pe+uymG4I95x4hhv2gHh4w1XGCyQV98VsafdvzrZLZURDoN7WXaC
KQp5C344d4ERi+Mex0QxkxQSjKptf2ckQqp/wLXrA4Udgfm8tyNp092FUsV7
CsbahCBPCy6WXYy01KEo2PhqlM0pRRjZw3SRKSmcaFuHrPe3ENq0vkUkpbCQ
byrR0eEhWzIQ3NZLoVbm9qx9fRVoAl9OpYjCg6icxYEqPtwLGlh2rRRGl22Y
U3bwDpa39X/+130KuhOlJott7mL+wWRa+x0KztqQ2m3lAnC3axWaMgrPEp3a
Hq1sxObonXv+KKRgyRmeuKVpAvd1jv/PmRSGxwlJl8MDmPnHdm9PoVA0VN9K
v9QMvpX/mFUcBbr5TUqhEEI2aVlpeIjCxX01kXnWjzAlLLnZyqYw9k2pYu8v
j3FGVLeL8KYQ6yjkmzU/Ab3xtqDKhQJRLkzpYLaCfTckfKMNhY9RnddXnH6K
0tQlaxzoFOw2GU5F1j+DNI9jWzGmgWcB86fKhW0QjI/mPuzV4IT5bitpUDvC
YuNalt7TwF7lb9zt8wKJ6bXewVwN5s15ayT88AJxZqcmOac10G+8zlua3YH4
NZaOOSwN9jvVv/rMS4SXR8cs9Gw1KP0+NO/emAicDHH6olE1RocXmQxkiHGg
JVPNuq9GzTZPvTT3TtSNRIxWnVXjl81JXP5AJ+Ito6p9NqnB7N/SU5jUBdUT
3eL2CRVc1iamMRxf4tqGnR5dBSoEWbRP6IhfQvfwb+m3PVUYbU2VHUnoRrei
v2V/zzCy9NmxftY9cG2aZ8gOG8Y8SU2BrrAHY2/NAutlQzCIS2Cti36FCovi
FLnHEGi32DzZ3F54O1ztT88fxNFrvNS5D3qRwbWYhV4lGuzOG5keeo2lN7xW
JmvfwHTLUfuz9D50JOWWMyzeoG/VC/EpQR/20ntzV88dQEUurBXsflwSP5WJ
df9GMM/Z1HyqH7bZh3fUDcjxa1J+Qt9tCRJmFVdfyZehTGl+ne5NwMm35cvM
SCnO5ySFSLYSMCH4AzP2SBHup7Yp9yUgzK2wOr5LiiUCQYVPwHQf4L52249S
XLi869HFUAJH7kzMMHKRYq/znyMzTxFgbPhHHjxbCqvE+ZsNiwkY8fkdj6tJ
TH19ZnZ3CQHWlAHdvpzEK7VcVFxKYJbjTDqnhAQnoDr4u0oCecnykIAcEtqV
fjFJAgKh3H+T5edI9HVcztUTE3De3Zj6LpBE3bnxMHEXgbV+l9QsFok0190r
CnsINEcsdKjdSsLrxhf8byUEwhRWESfdSNw9+bwlYZDA/Ws1Dz/ak8hYteay
r4rAp+ih6CBbEtGybBaTImCwL8akgUliufcBouk9AaWer328GQl9nc4izjiB
8bjUMokJCbLGNSrkA4GYBvVyGJMQRBWudpgkUPk8Io9rQCLT0nhUqyUgahpc
QKOR+A/ixYPy
       "]]},
     Annotation[#, "Charting`Private`Tag$821082#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.5000000258404409},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.636654658965506*^9, 3.6366546757690763`*^9}, {
   3.6366547058430862`*^9, 3.636654726928646*^9}, 3.6366547644417343`*^9, 
   3.636655534318931*^9, 3.6366562035884647`*^9, {3.6366562532163267`*^9, 
   3.636656260224988*^9}, 3.636656670414234*^9, 3.636656738144123*^9, 
   3.636667210913232*^9, 3.6368103326744337`*^9, 3.636901730702174*^9, 
   3.6369017882749767`*^9, {3.6369022658948927`*^9, 3.636902305077441*^9}, 
   3.636903696312409*^9, 3.637375796081256*^9, 3.666642167605679*^9, 
   3.6666440262175417`*^9, 3.7657693852928658`*^9, 3.79399238584718*^9, 
   3.793992530447784*^9, 3.793992642197336*^9, 3.823228154225473*^9},
 CellLabel->
  "Out[2238]=",ExpressionUUID->"b9ed42d6-2bcd-4860-aa7f-51e8d70374b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"psol", ",", 
    RowBox[{"qsol", "/.", 
     RowBox[{"p", "\[Rule]", "psol"}]}]}], "}"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "0.2"}], ",", 
    RowBox[{"b", "\[Rule]", "0.3"}]}], "}"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "increase", " ", "in", " ", "confidence", " ", "in", " ", "particular", 
    " ", "case"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.636656788661875*^9, 3.636656862323244*^9}},
 CellLabel->
  "In[2239]:=",ExpressionUUID->"e1d55c3a-0e93-41f5-9e97-1d74514f234f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8516287047744076`", ",", "0.9338609156373124`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.6366568091334677`*^9, 3.6366568280391808`*^9}, 
   3.636656863780164*^9, 3.636667210952396*^9, 3.636810332702338*^9, 
   3.636901730750218*^9, 3.636903696345104*^9, 3.6373757962181273`*^9, 
   3.666642167640353*^9, 3.6666440262514153`*^9, 3.765769385309091*^9, 
   3.793992385854793*^9, 3.793992530455885*^9, 3.793992642205557*^9, 
   3.823228154232583*^9},
 CellLabel->
  "Out[2239]=",ExpressionUUID->"8d2c94d3-75e5-42c2-b61f-3e66bad386b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{"qsol1a", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "0", ",", "2"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.63690265919534*^9, 3.63690269792315*^9}, {
   3.636902880471282*^9, 3.6369029054600277`*^9}, 3.6369029689470377`*^9},
 CellLabel->
  "In[2240]:=",ExpressionUUID->"0ee86c2f-ad37-453b-b491-a1e516da05c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "b"}]}], 
       SqrtBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "b"}]}], ")"}], "2"]]]}], ")"}]}], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "b"}], ")"}], " ", "b", " ", 
     SqrtBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "b"}]}], ")"}], "2"]], " ", 
     SuperscriptBox["a", "2"]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", "b"}]}], ")"}], "3"]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "a", "]"}], "3"],
    SeriesData[$CellContext`a, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`a, 0, {
   Rational[1, 2] (
     1 + (1 - 2 $CellContext`b) ((1 - 2 $CellContext`b)^2)^Rational[-1, 2]), 
    0, -(-1 + $CellContext`b) $CellContext`b (-1 + 
      2 $CellContext`b)^(-3) ((-1 + 2 $CellContext`b)^2)^Rational[1, 2]}, 0, 
   3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.636902905831603*^9, 3.636902969675805*^9, 
  3.636903696730033*^9, 3.637375796618301*^9, 3.666642167995891*^9, 
  3.6666440265903807`*^9, 3.765769385673525*^9, 3.793992386033293*^9, 
  3.793992530647612*^9, 3.793992642396843*^9, 3.8232281544308443`*^9},
 CellLabel->
  "Out[2240]=",ExpressionUUID->"159c9e31-7d1e-4f6b-b541-2938f082bddf"]
}, Open  ]],

Cell["\<\
For the phase transition threshold using the smoother, we use time symmetry...\
\>", "Text",
 CellChangeTimes->{{3.6361437698018217`*^9, 3.636143800835778*^9}, {
  3.6366443303325644`*^9, 3.636644414445485*^9}, {3.636653259279551*^9, 
  3.636653320546273*^9}, {3.636668695852807*^9, 3.636668711162876*^9}, {
  3.6366868803890667`*^9, 3.636686884723672*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"0a357260-6f47-4fa0-882b-aadee81eca75"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq5", "=", 
  RowBox[{
   FractionBox[
    RowBox[{"b", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"psol", "\[Minus]", 
          RowBox[{"2", "a", " ", "psol"}]}]}], ")"}], "2"], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"psol", "\[Minus]", 
           RowBox[{"2", "a", " ", "psol"}]}]}], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "\[Minus]", "a"}], "\[Minus]", "psol"}], "+", 
          RowBox[{"2", "a", " ", "psol"}]}], ")"}], "2"]}]]}], 
    RowBox[{
     RowBox[{"b", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"psol", "\[Minus]", 
           RowBox[{"2", "a", " ", "psol"}]}]}], ")"}], "2"], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"psol", "\[Minus]", 
            RowBox[{"2", "a", " ", "psol"}]}]}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"1", "\[Minus]", "a"}], "\[Minus]", "psol"}], "+", 
           RowBox[{"2", "a", " ", "psol"}]}], ")"}], "2"]}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "b"}], ")"}], 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "\[Minus]", "a"}], "\[Minus]", "psol"}], "+", 
          RowBox[{"2", "a", " ", "psol"}]}], ")"}], "2"], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"psol", "\[Minus]", 
            RowBox[{"2", "a", " ", "psol"}]}]}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"1", "\[Minus]", "a"}], "\[Minus]", "psol"}], "+", 
           RowBox[{"2", "a", " ", "psol"}]}], ")"}], "2"]}]]}]}]], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.636686888754459*^9, 3.636686928246078*^9}, {
  3.636686975252734*^9, 3.636687032529379*^9}},
 CellLabel->
  "In[2241]:=",ExpressionUUID->"0bca4a58-d316-4ab7-bbc0-c23e709e2643"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "a", "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "a", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]], "-", 
       RowBox[{"2", " ", "b"}]}], ")"}], "2"], " ", "b"}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"a", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "a", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "a", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.63668703799175*^9, 3.636810333597385*^9, 
  3.6369017315883512`*^9, 3.63690369756921*^9, 3.637375797482877*^9, 
  3.6666421689620113`*^9, 3.666644027461001*^9, 3.765769386684927*^9, 
  3.793992386445689*^9, 3.793992531068241*^9, 3.793992642850295*^9, 
  3.8232281549252043`*^9},
 CellLabel->
  "Out[2241]=",ExpressionUUID->"d69b537c-69d2-46dd-bfa7-62e8e6a85dda"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol5", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"eq5", "\[Equal]", 
      FractionBox["1", "2"]}], ",", "b"}], "]"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.636687056512993*^9, 3.6366870778189487`*^9}},
 CellLabel->
  "In[2242]:=",ExpressionUUID->"0e2dd32b-a2c1-454c-8584-229ec24463db"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", "\[Rule]", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       SqrtBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "a"}], ")"}], "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "a"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"3", " ", "a"}]}], ")"}]}]], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "a"}], ")"}], "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox[
         SqrtBox[
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "a"}], ")"}], "2"]}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "a"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"3", " ", "a"}]}], ")"}]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "a"}], ")"}], "2"]]}], ")"}]}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.636687064233097*^9, 3.6366870804736843`*^9}, 
   3.636810336133287*^9, 3.636901734004054*^9, 3.6369037000483103`*^9, 
   3.637375799924111*^9, 3.666642171319779*^9, 3.666644029801799*^9, 
   3.765769388980154*^9, 3.7939923877397118`*^9, 3.79399253234647*^9, 
   3.793992644165658*^9, 3.8232281562914*^9},
 CellLabel->
  "Out[2242]=",ExpressionUUID->"52d76852-b1a5-4c77-a85a-a207b8df37e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"bsol5", "=", 
    RowBox[{"b", "/.", 
     RowBox[{"sol5", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}]}], ",", 
   RowBox[{"bsol5", "/.", 
    RowBox[{"a", "\[Rule]", "0.2"}]}]}], "}"}]], "Input",
 CellChangeTimes->{{3.636687111892376*^9, 3.636687125147784*^9}},
 CellLabel->
  "In[2243]:=",ExpressionUUID->"1ec311d9-2f47-4528-b0c3-bbdf9d83a8b1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], "-", 
    FractionBox[
     SqrtBox[
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "a"}], ")"}], "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "a"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", "a"}]}], ")"}]}]], 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "a"}], ")"}], "2"]}]]}], ",", 
   "0.06698729810778076`"}], "}"}]], "Output",
 CellChangeTimes->{3.6366871279289637`*^9, 3.6368103363986607`*^9, 
  3.636901734076437*^9, 3.6369037001268053`*^9, 3.637375800033738*^9, 
  3.666642171420115*^9, 3.6666440298569527`*^9, 3.7657693890542793`*^9, 
  3.79399238780803*^9, 3.793992532390544*^9, 3.7939926441968527`*^9, 
  3.823228156384973*^9},
 CellLabel->
  "Out[2243]=",ExpressionUUID->"56393fd7-0bd6-425d-8353-118325d8e6ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq5a", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "b", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"p", "\[Minus]", 
         RowBox[{"2", "a", " ", "p"}]}]}], ")"}], "2"]}], "==", 
    RowBox[{
     RowBox[{"b", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"p", "\[Minus]", 
          RowBox[{"2", "a", " ", "p"}]}]}], ")"}], "2"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "b"}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "\[Minus]", "a"}], "\[Minus]", "p"}], "+", 
         RowBox[{"2", "a", " ", "p"}]}], ")"}], "2"]}]}]}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.636903770668536*^9, 3.636903819400128*^9}, {
  3.6369038518645687`*^9, 3.636903864236946*^9}},
 CellLabel->
  "In[2244]:=",ExpressionUUID->"2a57fc15-406d-4911-bf2d-cdc24a8d05b4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "b"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "a", "+", "p", "-", 
       RowBox[{"2", " ", "a", " ", "p"}]}], ")"}], "2"]}], "+", 
   RowBox[{"b", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", "p", "-", 
       RowBox[{"2", " ", "a", " ", "p"}]}], ")"}], "2"]}]}], "\[Equal]", 
  "0"}]], "Output",
 CellChangeTimes->{{3.6369038595832357`*^9, 3.6369038647973824`*^9}, 
   3.637375800291809*^9, 3.666642171692102*^9, 3.666644030130804*^9, 
   3.7657693893046*^9, 3.7939923879357033`*^9, 3.793992532512425*^9, 
   3.793992644324107*^9, 3.823228156545912*^9},
 CellLabel->
  "Out[2244]=",ExpressionUUID->"d005558e-f0ea-4974-b66f-c45604e690ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq5b", "=", 
  RowBox[{
   RowBox[{"eq5a", "/.", 
    RowBox[{"p", "\[Rule]", "psol"}]}], "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.63690387314546*^9, 3.636903887519755*^9}, {
  3.636903931458499*^9, 3.6369039339296427`*^9}},
 CellLabel->
  "In[2245]:=",ExpressionUUID->"f7422039-ddd9-4aca-b86e-a6de27a0953f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "b"}]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     SuperscriptBox["a", "2"], "+", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]], "-", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "b"}], ")"}], " ", "b"}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "b"}]}], ")"}], "2"], "-", 
          RowBox[{"2", " ", "a", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", " ", "b"}]}], ")"}], "2"]}]}]], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "b"}], ")"}], " ", "b"}]}], ")"}]}]}], 
    ")"}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{{3.636903874408514*^9, 3.63690388860742*^9}, 
   3.636903934296329*^9, 3.637375800718964*^9, 3.666642172134959*^9, 
   3.66664403056689*^9, 3.765769389719391*^9, 3.793992388136128*^9, 
   3.793992532713996*^9, 3.7939926445334673`*^9, 3.823228156789505*^9},
 CellLabel->
  "Out[2245]=",ExpressionUUID->"4caee6e3-9dc5-48f9-a060-6c6278496851"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{"eq5b", ",", "b"}], "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.636903920310454*^9, 3.636903936927868*^9}},
 CellLabel->
  "In[2246]:=",ExpressionUUID->"b6a1df1e-8ea8-42bd-8965-1b0b7db7d8eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       SqrtBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "a"}], ")"}], "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "a"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"3", " ", "a"}]}], ")"}]}]], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "a"}], ")"}], "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox[
         SqrtBox[
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "a"}], ")"}], "2"]}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "a"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"3", " ", "a"}]}], ")"}]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "a"}], ")"}], "2"]]}], ")"}]}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.636903921824978*^9, 3.6369039379761143`*^9}, 
   3.637375800770649*^9, 3.666642172171455*^9, 3.6666440306257477`*^9, 
   3.765769389773892*^9, 3.793992388169598*^9, 3.7939925327428713`*^9, 
   3.793992644546658*^9, 3.823228156808977*^9},
 CellLabel->
  "Out[2246]=",ExpressionUUID->"7cf212d1-50af-41a5-a718-bb120c95a4b8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"bsol3", ",", "bsol5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "0.5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.636687963817801*^9, 3.636688004198998*^9}},
 CellLabel->
  "In[2247]:=",ExpressionUUID->"88618000-6967-40c8-bd7c-dc9ee97924c7"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVj3tUywsAx1dxIkJ6aQl1qLwq2g09fEdTKNkSyokeVkSKdKhOTmKVlArJ
bikhj0qUHkjYrTWs7fcTqz3a1hWXuYWet1Jy+eNzPp9/P5ah0b5h2hQKZdcv
fntzmKaV93nD2l/Z/tuT3KmHO80WgrK6IbWUuhCOV7lXqs1ooHg3dHma0+Al
lj4oNGOAsj7ioWAuAzvZw08vmPmB8t3o2cf5flDZp7mfM2Pj5FaBm5s1G8XG
W1PPmsXi5Dt9vp5jLJKnVNukm3FADwtj6m/hwD/g2v3evlwU53ha+bMvYdrP
5EDPeVcR/Ng333pWMRaxvmqaMkpgu2rFzcojN3GcWAPuYCl6R7+UlUSWw7TG
QK2ldR8btdmebhcrUdflLiJdHyAyoXBOeFM1Gg8Umgf01OBMcHkMf7wOQ9Zu
MysOPQSdntrtYFIP7dHyWeaL6lEy5+brxqyncPoZXLftXgM065jy5lgeRBwa
IVjyHOHRhrlDto2Yn9M9WvqVB2q8y6kAYz66hzvVbQ6NyGM2nDMZakbJv0+E
M7KaIHC6vY9j8hIzLG5/+/CBDz8d5Q6NlxCZEbXhxQsFUKexnN8kiPAfvfzD
/qQXyLXS1W3QJhG7kl9j0vQSBundfiMvXqPzHj+j1VKIDIs/Zup6v8HYAUnB
4oQWSIN/TKwZeQs/p93n7ZJa8DkxmdBMvMVdrY+pjpwWbJ+d4l8wWYI93OEj
blkt+LvWrnaaoQR/NVM3sq634NahAQbVToK0BSGDccIWPLvnXTDIlsCw/Yv3
S6oIHsaGrNY2CZau050IfyLCsSmnV5kJ2lBZVm4j44mwsnntmWKiDTQjJmuT
QARBoVjLXtoG10/ckqWtItApXo9CNG3wObfEq/ejCHdqdq1fMK0dMfIt3PjZ
YoSmHwgy9G3H4yO5KzMjxDg7ME8W87EdaztWB/6IEsM/vvrY1N52NDJUKVGx
YjCPLttQNtoOoam1nJkkxuLpsUN6+lIonz5MMr4khiS4le1Nk4Ki1yEq4olx
T2fUopcjhed1y31VpgS0rdae6LeXgcadYS2YS+BmQe/WEGcZFmSNfVBYEmAc
kzqpGTJ8j28LnbSMQOphl8U6u2SoYKXv2UkncGck0peSIoOhVt/2H/sJ7K8i
PXTUMlCGVUazowhU/zPhEvNZhp4e4VvrowROHUrjDQzKIJCVsJgnCIgjX2vs
p8sRX+m/5cZ5Asv2Ljtx2UWOziAeY1M9gT6LEFVKkRyi7RU6e54TGAosDGCW
y/HIK78xhk9AdDCni/ZIjgurYulXCAKvpjvc8Xkjx4aZtq7fuggIXWwjZboK
lD/Ldrw0jYSej8JvPE4Bbk1if+ksEl2npu5oTlOAUxZR9cyYRGPh7oa6PAX2
5Lnba+aTGLUpNZpTq4BB1PASFxqJ4IqD/RMDChy3CLJ6F0jiODVCODmxA6FM
hx3KEBLVxtke5LkO+JzWOisNJ6HuMJz57moHrD/f6BMfJvEqU0u/h98BSY2G
V88hUW/C584xVIL36fFgbTqJkSKrbwU2SpRTM2yrskh88hjXz3ZV4tTJ5Tm3
uSQKjWf4v9+nhIN3TFDuXRKTVid/92tWYm6S+8XsKhIPDkfdYKuV0H1g9OJs
HYluhTTWfUQJtelDu2QeiaWXr0a8tFNBuPlMaGIzCV703KxbXirUngjIOy4k
QR1yzhBEqJD5fuzHIQkJS86r2pwyFeJMxCsi5CTaBfnPeWIV9m4qCmOrSZi4
XkzzGlDBJzH6z6D3JPIPTLV9aq6G8326eJfm11+dk0uXpxrWXQZaO76QuMuw
sRqLU8PA+D2N1U/imvkLiWOVGuOeNfu9h0lEC5d3aw+poUlIueI5TmJgso4o
ktWJzHktdP5PEmW3ONs8JJ34H+AXzGg=
       "]]},
     Annotation[#, "Charting`Private`Tag$824368#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd1gk0Ff0bB/BpeXtvFFIUEUWSbmhXMV+v9ZYSkS07kVKWNhWhqJStshVK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       "]]},
     Annotation[#, "Charting`Private`Tag$824368#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.6366879868451023`*^9, 3.636688004813354*^9}, 
   3.63681033648323*^9, 3.636901734120426*^9, 3.636903700166769*^9, 
   3.637375800819113*^9, 3.666642172213238*^9, 3.666644030674304*^9, 
   3.7657693898551702`*^9, 3.793992388214117*^9, 3.793992532778125*^9, 
   3.793992644583106*^9, 3.823228156840891*^9},
 CellLabel->
  "Out[2247]=",ExpressionUUID->"49a9bf76-6982-4c1c-bfe1-621f489ba3bc"]
}, Open  ]],

Cell["Output Latex forms to copy/paste into book manuscript", "Text",
 CellChangeTimes->{{3.7939924143964787`*^9, 3.793992430807192*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"84ec4794-6c77-403f-8cac-f9a8ff8782ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "b"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{"3", "-", 
         RowBox[{"4", " ", "b"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", "b"}]}], ")"}], " ", "p"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "a"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "b"}]}], ")"}], " ", 
    SuperscriptBox["p", "2"]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.636650284787602*^9, 3.63665030200264*^9}},
 CellLabel->
  "In[2248]:=",ExpressionUUID->"c7555035-85b4-42ea-b9b0-6ecbdafeeda9"],

Cell["(2 a-1) (2 b-1) p^2+p (a (3-4 b)+2 b-1)+a (b-1)", "Output",
 CellChangeTimes->{{3.636650293422883*^9, 3.6366503027383947`*^9}, 
   3.6366544463611298`*^9, 3.6366555332540503`*^9, 3.636656202538826*^9, 
   3.6366562590628433`*^9, 3.6366566693651133`*^9, 3.636667209859864*^9, 
   3.6368103314323063`*^9, 3.636901729502102*^9, 3.636903693621243*^9, 
   3.637375793663643*^9, 3.66664216521507*^9, 3.66664402422515*^9, 
   3.765769382668624*^9, 3.793992384764175*^9, 3.793992532792178*^9, 
   3.793992644597492*^9, 3.8232281568635693`*^9},
 CellLabel->
  "Out[2248]//TeXForm=",ExpressionUUID->"9cfa177b-29b0-41b0-b98c-\
ec17e3521f32"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"sol", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.6305235158032503`*^9, 3.63052352678027*^9}, {
  3.630523606329677*^9, 3.63052360663482*^9}},
 CellLabel->
  "In[2249]:=",ExpressionUUID->"35b7c9d4-c0eb-4b93-92d0-6bbc49bfc32c"],

Cell["\<\
\\left\\{p\\to \\frac{\\sqrt{a^2-2 a (1-2 b)^2+(1-2 b)^2}+a (4 b-3)-2 b+1}{2 \
(2 a-1) (2
   b-1)}\\right\\}\
\>", "Output",
 CellChangeTimes->{3.630523527634763*^9, 3.630523607063555*^9, 
  3.636135384968163*^9, 3.636137861606984*^9, 3.6362302927683697`*^9, 
  3.63664442238301*^9, 3.636649973832238*^9, 3.636654446455721*^9, 
  3.636655533353096*^9, 3.636656202693503*^9, 3.636656259241926*^9, 
  3.636656669484057*^9, 3.636667209959206*^9, 3.636810331506812*^9, 
  3.6369017295819693`*^9, 3.636903693703635*^9, 3.637375793743412*^9, 
  3.666642165300983*^9, 3.666644024324991*^9, 3.76576938280089*^9, 
  3.7939923848229218`*^9, 3.793992532825124*^9, 3.793992644610731*^9, 
  3.823228156964879*^9},
 CellLabel->
  "Out[2249]//TeXForm=",ExpressionUUID->"7c67ca53-b719-4418-bc51-\
e844f87d28f6"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 580},
WindowMargins->{{Automatic, 199}, {Automatic, 65}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"dd07f420-2833-49d7-be7d-151657220107"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 246, 4, 67, "Section",ExpressionUUID->"2f71bf18-8dd6-4768-a58c-b67fb82ff263"],
Cell[829, 28, 175, 4, 30, "Input",ExpressionUUID->"1b8af986-c0d9-4d0f-9eb0-42725db38e25"],
Cell[CellGroupData[{
Cell[1029, 36, 1369, 45, 74, "Input",ExpressionUUID->"a77b733e-0c27-4a3e-ad65-87067d5a6c6c"],
Cell[2401, 83, 2156, 68, 105, "Output",ExpressionUUID->"373403bf-d8f3-4b95-92af-cccb1724902d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4594, 156, 1445, 44, 52, "Input",ExpressionUUID->"e77cf390-15a3-4d1e-a212-e4c65ed5d9a8"],
Cell[6042, 202, 1243, 34, 34, "Output",ExpressionUUID->"45f4a00a-2389-4a43-9b84-f53bfca13932"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7322, 241, 1071, 32, 30, "Input",ExpressionUUID->"33cb6666-20f6-4573-95f3-74ddada1e64f"],
Cell[8396, 275, 1119, 32, 34, "Output",ExpressionUUID->"5ae9a048-50f5-4285-a38d-b4dd3d8b38c6"]
}, Open  ]],
Cell[9530, 310, 329, 9, 30, "Input",ExpressionUUID->"44158ebd-ef64-4a9c-b902-d12db7102f44"],
Cell[CellGroupData[{
Cell[9884, 323, 360, 8, 47, "Input",ExpressionUUID->"d1737c8e-f3e5-4d99-869d-20785a6e0358"],
Cell[10247, 333, 780, 14, 34, "Output",ExpressionUUID->"7a04a545-4d34-4540-9c70-b0c529bdfd84"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11064, 352, 368, 10, 30, "Input",ExpressionUUID->"e2cb673d-80a0-4683-ba4c-cf3e20f82435"],
Cell[11435, 364, 790, 15, 34, "Output",ExpressionUUID->"66d0bba7-dedf-4595-a071-dc5e1303e795"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12262, 384, 182, 3, 30, "Input",ExpressionUUID->"4b2e623d-2bd0-46fc-8519-d3c1803ad1ca"],
Cell[12447, 389, 1451, 39, 58, "Output",ExpressionUUID->"2e501db8-099c-474f-8179-56ec1cf966bd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13935, 433, 753, 20, 52, "Input",ExpressionUUID->"80a6e3e9-1013-4294-a85b-0cdd52d5821e"],
Cell[14691, 455, 221, 4, 34, "Output",ExpressionUUID->"5b888bbf-9f86-41f8-820f-4dcde4a3643f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14949, 464, 700, 17, 68, "Input",ExpressionUUID->"a77079fa-bad8-4ad0-9a9c-f74a9a05a1c5"],
Cell[15652, 483, 627, 13, 52, "Output",ExpressionUUID->"75b817b2-a147-4209-997a-71d2ef756b1f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16316, 501, 735, 18, 69, "Input",ExpressionUUID->"b8f5627a-97a4-447e-9d26-9a14f7c392f0"],
Cell[17054, 521, 622, 13, 52, "Output",ExpressionUUID->"93abf489-000c-4571-b7bb-a11430dc1f90"]
}, Open  ]],
Cell[17691, 537, 176, 3, 30, "Input",ExpressionUUID->"6a487935-028c-467c-bf44-4168070490da"],
Cell[CellGroupData[{
Cell[17892, 544, 1220, 32, 73, "Input",ExpressionUUID->"d894dde8-1761-4b46-8cd6-7c2068519d76"],
Cell[19115, 578, 7634, 148, 239, "Output",ExpressionUUID->"a50956db-4cc8-4681-becd-8c54c39ae837"]
}, Open  ]],
Cell[26764, 729, 246, 5, 51, "Text",ExpressionUUID->"0cebc15a-e5b6-48f5-b80e-2119f5df39d8"],
Cell[CellGroupData[{
Cell[27035, 738, 2138, 65, 81, "Input",ExpressionUUID->"7a812388-8a09-4dd2-adc4-a93722f0034d"],
Cell[29176, 805, 1762, 48, 72, "Output",ExpressionUUID->"a25a7af7-2bd5-42a9-8c04-a2ea582ae3be"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30975, 858, 1366, 42, 91, "Input",ExpressionUUID->"f334be57-f22f-45e2-867d-5b8f27dcfc10"],
Cell[32344, 902, 910, 24, 37, "Output",ExpressionUUID->"ff532f45-c27a-4aa4-a52f-727005e3b22f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33291, 931, 822, 25, 34, "Input",ExpressionUUID->"b947e030-3bca-4850-946b-6ce2469790db"],
Cell[34116, 958, 745, 20, 34, "Output",ExpressionUUID->"6c42d611-b1b1-48da-bf1c-5e9fb7ac618f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34898, 983, 442, 10, 47, "Input",ExpressionUUID->"8320549d-7d19-4d57-9b23-ea5c5d94d24a"],
Cell[35343, 995, 1221, 31, 50, "Output",ExpressionUUID->"4e6f3fce-78ff-4609-8c7d-ae975b7230a2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36601, 1031, 592, 14, 30, "Input",ExpressionUUID->"baf83936-f345-4425-a8c9-9662b57374ae"],
Cell[37196, 1047, 987, 22, 50, "Output",ExpressionUUID->"9132104b-9999-41a7-827f-c3558b63b753"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38220, 1074, 421, 10, 30, "Input",ExpressionUUID->"8fe75dad-0543-4d6c-91cd-d1a5af3b9895"],
Cell[38644, 1086, 5681, 115, 238, "Output",ExpressionUUID->"6ceb06da-40f8-40b3-ac09-b737d219589a"]
}, Open  ]],
Cell[44340, 1204, 700, 18, 76, "Text",ExpressionUUID->"221ad399-8e32-4861-b31e-a23f1eb89229"],
Cell[CellGroupData[{
Cell[45065, 1226, 974, 28, 73, "Input",ExpressionUUID->"e6b9ab0c-5b4e-4470-bec9-893530991606"],
Cell[46042, 1256, 1284, 33, 54, "Output",ExpressionUUID->"1d55785d-5f72-4c50-8b93-70a66acb3c52"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47363, 1294, 421, 10, 30, "Input",ExpressionUUID->"35b02119-eff3-4129-aa43-c6b52fae22e9"],
Cell[47787, 1306, 1177, 31, 54, "Output",ExpressionUUID->"10ba54d4-ef45-44b9-b255-0694de77cf7f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49001, 1342, 300, 7, 30, "Input",ExpressionUUID->"307ea5a0-b48f-4be1-9c0f-5337cc0e5145"],
Cell[49304, 1351, 1301, 39, 63, "Output",ExpressionUUID->"092bf568-ea47-43fa-8eea-7132b5391ebc"]
}, Open  ]],
Cell[50620, 1393, 893, 29, 63, "Input",ExpressionUUID->"197f1bad-7623-41dd-a2cb-dd4874cc8aaf"],
Cell[CellGroupData[{
Cell[51538, 1426, 605, 14, 30, "Input",ExpressionUUID->"7631ab30-4aff-43f2-aa03-cf4c8f1e3ed4"],
Cell[52146, 1442, 5736, 114, 239, "Output",ExpressionUUID->"b9ed42d6-2bcd-4860-aa7f-51e8d70374b0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57919, 1561, 575, 16, 52, "Input",ExpressionUUID->"e1d55c3a-0e93-41f5-9e97-1d74514f234f"],
Cell[58497, 1579, 576, 11, 34, "Output",ExpressionUUID->"8d2c94d3-75e5-42c2-b61f-3e66bad386b2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59110, 1595, 411, 10, 30, "Input",ExpressionUUID->"0ee86c2f-ad37-453b-b491-a1e516da05c0"],
Cell[59524, 1607, 1656, 49, 63, "Output",ExpressionUUID->"159c9e31-7d1e-4f6b-b541-2938f082bddf"]
}, Open  ]],
Cell[61195, 1659, 455, 8, 51, "Text",ExpressionUUID->"0a357260-6f47-4fa0-882b-aadee81eca75"],
Cell[CellGroupData[{
Cell[61675, 1671, 2300, 69, 79, "Input",ExpressionUUID->"0bca4a58-d316-4ab7-bbc0-c23e709e2643"],
Cell[63978, 1742, 2171, 64, 73, "Output",ExpressionUUID->"d69b537c-69d2-46dd-bfa7-62e8e6a85dda"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66186, 1811, 361, 10, 47, "Input",ExpressionUUID->"0e2dd32b-a2c1-454c-8584-229ec24463db"],
Cell[66550, 1823, 1967, 60, 61, "Output",ExpressionUUID->"52d76852-b1a5-4c77-a85a-a207b8df37e4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68554, 1888, 399, 11, 30, "Input",ExpressionUUID->"1ec311d9-2f47-4528-b0c3-bbdf9d83a8b1"],
Cell[68956, 1901, 1055, 31, 60, "Output",ExpressionUUID->"56393fd7-0bd6-425d-8353-118325d8e6ea"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70048, 1937, 970, 30, 30, "Input",ExpressionUUID->"2a57fc15-406d-4911-bf2d-cdc24a8d05b4"],
Cell[71021, 1969, 833, 23, 34, "Output",ExpressionUUID->"d005558e-f0ea-4974-b66f-c45604e690ae"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71891, 1997, 349, 8, 30, "Input",ExpressionUUID->"f7422039-ddd9-4aca-b86e-a6de27a0953f"],
Cell[72243, 2007, 1742, 52, 79, "Output",ExpressionUUID->"4caee6e3-9dc5-48f9-a060-6c6278496851"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74022, 2064, 270, 6, 30, "Input",ExpressionUUID->"b6a1df1e-8ea8-42bd-8965-1b0b7db7d8eb"],
Cell[74295, 2072, 1811, 56, 61, "Output",ExpressionUUID->"7cf212d1-50af-41a5-a718-bb120c95a4b8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76143, 2133, 348, 9, 30, "Input",ExpressionUUID->"88618000-6967-40c8-bd7c-dc9ee97924c7"],
Cell[76494, 2144, 8399, 160, 239, "Output",ExpressionUUID->"49a9bf76-6982-4c1c-bfe1-621f489ba3bc"]
}, Open  ]],
Cell[84908, 2307, 225, 3, 51, "Text",ExpressionUUID->"84ec4794-6c77-403f-8cac-f9a8ff8782ad"],
Cell[CellGroupData[{
Cell[85158, 2314, 847, 28, 33, "Input",ExpressionUUID->"c7555035-85b4-42ea-b9b0-6ecbdafeeda9"],
Cell[86008, 2344, 636, 10, 45, "Output",ExpressionUUID->"9cfa177b-29b0-41b0-b98c-ec17e3521f32"]
}, Open  ]],
Cell[CellGroupData[{
Cell[86681, 2359, 313, 7, 30, "Input",ExpressionUUID->"35b7c9d4-c0eb-4b93-92d0-6bbc49bfc32c"],
Cell[86997, 2368, 805, 16, 63, "Output",ExpressionUUID->"7c67ca53-b719-4418-bc51-e844f87d28f6"]
}, Open  ]]
}, Open  ]]
}
]
*)

