(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     44266,        840]
NotebookOptionsPosition[     43153,        813]
NotebookOutlinePosition[     43550,        829]
CellTagsIndexPosition[     43507,        826]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Adler equation and phase locking (Sec. 11.3.3)", "Section",
 CellChangeTimes->{{3.644450207434885*^9, 3.644450247858924*^9}, {
  3.644451151868689*^9, 3.644451152522646*^9}, {3.64462794465035*^9, 
  3.6446279586484003`*^9}, {3.6474632329145393`*^9, 3.647463238632565*^9}, {
  3.793921531271817*^9, 3.793921541071848*^9}, {3.823229193389831*^9, 
  3.823229193594592*^9}},ExpressionUUID->"5e8b6747-892e-4ed2-8618-\
41ee63c43d2b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[2825]:=",ExpressionUUID->"abe16c87-dcd4-4693-b796-edba8bb4f99a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tend", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
    RowBox[{
     RowBox[{"-", "\[Nu]"}], "+", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"\[Psi]", "[", "t", "]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"init", "=", 
   RowBox[{
    RowBox[{"\[Psi]", "[", "0", "]"}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "[", "\[Nu]0_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"NDSolveValue", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eq", ",", "init"}], "}"}], "/.", 
       RowBox[{"{", 
        RowBox[{"\[Nu]", "\[Rule]", "\[Nu]0"}], "}"}]}], ",", "\[Psi]", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}]}], "]"}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.647463261096939*^9, 3.647463401507362*^9}, {
   3.647463442291398*^9, 3.6474635786254673`*^9}, {3.6474646664247303`*^9, 
   3.647464692142447*^9}, {3.647464738809022*^9, 3.647464744497655*^9}, {
   3.647464781947851*^9, 3.647464782344227*^9}, {3.647464947406376*^9, 
   3.64746495066886*^9}, {3.793912615473572*^9, 3.7939126507300673`*^9}, {
   3.793912681332303*^9, 3.793912709554335*^9}, {3.793913480202983*^9, 
   3.793913510340784*^9}, {3.793913556892725*^9, 3.793913616960569*^9}, {
   3.7939136909893923`*^9, 3.793913712648324*^9}, {3.793913750061945*^9, 
   3.7939137614292297`*^9}, {3.7939138013559227`*^9, 3.793913866510519*^9}, {
   3.793913961080556*^9, 3.7939139746599417`*^9}, 3.793914085891264*^9, {
   3.7939213014628067`*^9, 3.793921345284173*^9}, {3.793921384424181*^9, 
   3.793921385293426*^9}},
 CellLabel->
  "In[2826]:=",ExpressionUUID->"3007f117-e97c-4850-bb1f-f9833c519740"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]1", "=", 
   RowBox[{"sol", "[", 
    RowBox[{"-", "1.5"}], "]"}]}], ";", 
  RowBox[{"\[Psi]2", "=", 
   RowBox[{"sol", "[", 
    RowBox[{"-", "1.1"}], "]"}]}], ";", 
  RowBox[{"\[Psi]3", "=", 
   RowBox[{"sol", "[", 
    RowBox[{"-", "1.01"}], "]"}]}], ";", 
  RowBox[{"\[Psi]4", "=", 
   RowBox[{"sol", "[", "1.", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.793913880816661*^9, 3.7939138918908787`*^9}, {
  3.793913925572362*^9, 3.793913928032716*^9}, {3.7939139972404737`*^9, 
  3.7939140299063673`*^9}},
 CellLabel->
  "In[2830]:=",ExpressionUUID->"0c1097fe-ee38-4230-ae27-2f01a25eb15c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Psi]1", "[", "t", "]"}], ",", 
     RowBox[{"\[Psi]2", "[", "t", "]"}], ",", 
     RowBox[{"\[Psi]3", "[", "t", "]"}], ",", 
     RowBox[{"\[Psi]4", "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "5"}], ",", "25"}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "300"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.793913942760881*^9, {3.7939139858929768`*^9, 3.793913986242778*^9}, {
   3.7939140327391644`*^9, 3.79391407061759*^9}},
 CellLabel->
  "In[2831]:=",ExpressionUUID->"eccf8eac-77ae-43b9-b7a4-eb57edcc0370"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwdlnk81c/3xy8ha9n33XUX672XuxR6v0pFikJJtCKEUpItWdoIUUjaaFGW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       "]]},
     Annotation[#, "Charting`Private`Tag$1206439#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVV3k4lN8flWxZsu9ClrEzM5jBYE7MDBEqS5a0kTUlWyghhSJRKkmWFiSV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       "]]},
     Annotation[#, "Charting`Private`Tag$1206439#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVl3c8l9/7x5GZ9Z5WyHhTpFBaRveL9/xWKCQzpYyUQiiZUUaSVaEkJElC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       "]]},
     Annotation[#, "Charting`Private`Tag$1206439#3"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV0nk0ld/3B/BL5vE+T5J8zGTKRzRQkmcbrm6KIlGkhAwZU5KSqRSlRIWi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       "]]},
     Annotation[#, "Charting`Private`Tag$1206439#4"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->300,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 49.99999897959184}, {-5, 25}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7939139462239647`*^9, {3.7939139812668753`*^9, 3.7939139866551247`*^9}, {
   3.793914053498143*^9, 3.7939140945865307`*^9}, {3.793921325346128*^9, 
   3.7939213945134163`*^9}, 3.793921469812539*^9, 3.823229181769684*^9},
 CellLabel->
  "Out[2831]=",ExpressionUUID->"2a221a4e-beb8-4267-8761-1ed2edd7ec0a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gensol", "=", 
  RowBox[{
   RowBox[{"DSolveValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"eq", ",", "init"}], "}"}], ",", 
     RowBox[{"\[Psi]", "[", "t", "]"}], ",", "t"}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.647464259589608*^9, 3.647464287643593*^9}, {
  3.647464347890395*^9, 3.647464370179372*^9}, {3.647464798214114*^9, 
  3.6474648738177*^9}, {3.6474649085438747`*^9, 3.6474649160999727`*^9}, {
  3.793921489439694*^9, 3.793921490822299*^9}},
 CellLabel->
  "In[2832]:=",ExpressionUUID->"ee46f3ca-76a6-4aa1-aa8f-e340f125f8de"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"ArcTan", "[", 
   FractionBox[
    RowBox[{"1", "-", 
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[Nu]", "2"]}]], " ", 
      RowBox[{"Tan", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], " ", "t", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[Nu]", "2"]}]]}], "+", 
        RowBox[{"ArcTan", "[", 
         FractionBox["1", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[Nu]", "2"]}]]], "]"}]}], "]"}]}]}], "\[Nu]"], 
   "]"}]}]], "Output",
 CellChangeTimes->{{3.6474649091765747`*^9, 3.647464921704331*^9}, 
   3.793912482628261*^9, 3.793912546387589*^9, 3.793914095625111*^9, {
   3.793921352983474*^9, 3.793921394636503*^9}, 3.793921427338561*^9, {
   3.793921469928815*^9, 3.793921491444146*^9}, 3.823229181985217*^9},
 CellLabel->
  "Out[2832]=",ExpressionUUID->"d36ef790-8855-486f-a427-7da594a37e86"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 42}, {Automatic, 20}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"f24c211f-20e9-4f86-a684-04c4a0d99cd4"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 433, 6, 67, "Section",ExpressionUUID->"5e8b6747-892e-4ed2-8618-41ee63c43d2b"],
Cell[1016, 30, 175, 4, 30, "Input",ExpressionUUID->"abe16c87-dcd4-4693-b796-edba8bb4f99a"],
Cell[1194, 36, 1925, 46, 115, "Input",ExpressionUUID->"3007f117-e97c-4850-bb1f-f9833c519740"],
Cell[3122, 84, 636, 17, 30, "Input",ExpressionUUID->"0c1097fe-ee38-4230-ae27-2f01a25eb15c"],
Cell[CellGroupData[{
Cell[3783, 105, 759, 20, 52, "Input",ExpressionUUID->"eccf8eac-77ae-43b9-b7a4-eb57edcc0370"],
Cell[4545, 127, 36879, 631, 210, "Output",ExpressionUUID->"2a221a4e-beb8-4267-8761-1ed2edd7ec0a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41461, 763, 601, 14, 30, "Input",ExpressionUUID->"ee46f3ca-76a6-4aa1-aa8f-e340f125f8de"],
Cell[42065, 779, 1060, 30, 63, "Output",ExpressionUUID->"d36ef790-8855-486f-a427-7da594a37e86"]
}, Open  ]]
}, Open  ]]
}
]
*)

