(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    169430,       3017]
NotebookOptionsPosition[    168533,       2994]
NotebookOutlinePosition[    168930,       3010]
CellTagsIndexPosition[    168887,       3007]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Illustrate system of 1d ODEs as a flow in a vector field
based on van der Pol equation  (Sec. 11.1.5)\
\>", "Section",
 CellChangeTimes->{{3.641929108915062*^9, 3.641929142144568*^9}, {
   3.641931540090023*^9, 3.6419315526418*^9}, 3.671935583072706*^9, {
   3.7939259700239353`*^9, 
   3.793925973857265*^9}},ExpressionUUID->"848c9a71-0f06-44a2-917c-\
1bfa81eaeada"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.64288255562225*^9, 3.642882570038011*^9}, 
   3.7939216701566753`*^9},
 CellLabel->
  "In[2816]:=",ExpressionUUID->"6160fe2c-5dc3-4e21-b14d-0fe5ac63bff8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tend", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1sol", ",", "x2sol"}], "}"}], "=", 
   RowBox[{"NDSolveValue", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"x2", "[", "t", "]"}]}], ",", " ", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"x1", "[", "t", "]"}]}], "+", 
          RowBox[{"\[Epsilon]", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SuperscriptBox[
              RowBox[{"x1", "[", "t", "]"}], "2"]}], ")"}], 
           RowBox[{"x2", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"x1", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"x2", "[", "0", "]"}], "\[Equal]", "0.01"}]}], "}"}], "/.", 
      RowBox[{"\[Epsilon]", "\[Rule]", "0.5"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x1sol", "[", "t", "]"}], ",", 
       RowBox[{"x2sol", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Thick"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"arrowPositions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.06"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.575"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1a", "=", 
   RowBox[{"p1", "/.", 
    RowBox[{
     RowBox[{"Line", "[", "x_", "]"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "arrowPositions", "]"}], ",", 
       RowBox[{"Arrow", "[", "x", "]"}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"StreamPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x2", ",", 
        RowBox[{
         RowBox[{"-", "x1"}], "+", 
         RowBox[{"\[Epsilon]", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["x1", "2"]}], ")"}], "x2"}]}]}], "}"}], "/.", 
      RowBox[{"\[Epsilon]", "\[Rule]", "0.5"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", 
       RowBox[{"-", "2.2"}], ",", "2.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2", ",", 
       RowBox[{"-", "2.2"}], ",", "2.2"}], "}"}], ",", 
     RowBox[{"StreamStyle", "\[Rule]", 
      RowBox[{"GrayLevel", "[", "0.65", "]"}]}], ",", 
     RowBox[{"StreamScale", "\[Rule]", "0.1"}], ",", 
     RowBox[{"StreamPoints", "\[Rule]", "15"}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", "\[Rule]", "30"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<GillSans\>\""}], ",", "Gray"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "0", ",", "2"}], "}"}], ",", "None"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "0", ",", "2"}], "}"}], ",", "None"}], 
         "}"}]}], "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pall", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"p2", ",", "p1a", ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.641928794600506*^9, 3.6419289590233917`*^9}, {
   3.641928989031632*^9, 3.6419290827948217`*^9}, {3.641929153268614*^9, 
   3.641929154272945*^9}, {3.641929292716329*^9, 3.641929362030278*^9}, {
   3.641929398411049*^9, 3.641929404586484*^9}, {3.641929464708046*^9, 
   3.641929603715102*^9}, {3.64192964223374*^9, 3.6419296877352133`*^9}, {
   3.641931226546166*^9, 3.641931240570025*^9}, {3.64193127623385*^9, 
   3.6419312837964973`*^9}, 3.641931344638235*^9, {3.6419314020659723`*^9, 
   3.6419314137021112`*^9}, {3.64193145529808*^9, 3.6419315380116043`*^9}, {
   3.6419320916001062`*^9, 3.641932109983749*^9}, {3.641932178611087*^9, 
   3.641932179240861*^9}, {3.641932458604361*^9, 3.641932464386798*^9}, {
   3.6419328228190536`*^9, 3.641932835004521*^9}, {3.641932872589654*^9, 
   3.6419329049086313`*^9}, {3.6419329503304853`*^9, 3.641933025010056*^9}, {
   3.6419331083171387`*^9, 3.641933114474256*^9}, {3.6419333878369837`*^9, 
   3.641933433289476*^9}, {3.642015117967833*^9, 3.642015185639675*^9}, {
   3.793926283388242*^9, 3.7939262960527773`*^9}, {3.7939263359653587`*^9, 
   3.793926346499239*^9}, {3.7939263998478603`*^9, 3.793926418297161*^9}, 
   3.793926610511982*^9, 3.793926666663376*^9, {3.793926705146174*^9, 
   3.793926710616908*^9}, {3.7939269764879627`*^9, 3.7939269771781588`*^9}, {
   3.7939270591189823`*^9, 3.793927135110189*^9}, {3.793927233563512*^9, 
   3.793927253936215*^9}, {3.793927303981106*^9, 3.793927342938548*^9}, {
   3.793927441583125*^9, 3.793927507314752*^9}, {3.793928523256062*^9, 
   3.793928545886559*^9}, {3.793928692811252*^9, 3.7939287207913513`*^9}, {
   3.7939288771071377`*^9, 3.7939288923817663`*^9}, {3.793930533787655*^9, 
   3.793930552185795*^9}, {3.7939315432788486`*^9, 3.793931549859407*^9}, {
   3.793931585126608*^9, 3.793931589656958*^9}, {3.7939316493301477`*^9, 
   3.7939317125733023`*^9}, {3.793931901775927*^9, 3.7939319944337683`*^9}, {
   3.793932129884061*^9, 3.7939323314284782`*^9}, {3.793932513857716*^9, 
   3.793932718185446*^9}, {3.793933442888794*^9, 3.793933457051374*^9}, {
   3.793933577336815*^9, 3.793933615094265*^9}, {3.793933861370564*^9, 
   3.7939339140315437`*^9}},
 CellLabel->
  "In[2817]:=",ExpressionUUID->"662b1c21-6522-412a-8aa6-fbf5f4d08d61"],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {GrayLevel[0.65], 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.19847126463110362`, 0.5225785958227959, -0.8337803521079946], 
        ArrowBox[{{-0.046531396127662855`, 0.07767571650153574}, {
         0.0074763024064452175`, 0.11531256691820835`}, {0.074794702504833, 
         0.1256796006481298}, {0.13713343218268859`, 0.09731153914389915}, {
         0.16832605712006704`, 0.046594301417961434`}, {
         0.17316199059677848`, -0.024843052656330987`}, {
         0.14472524479869528`, -0.10749638003952894`}, {
         0.1341881095080069, -0.12332948690436984`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.20914816314228307`, 0.5225595312709892, -0.8082631467558303], 
        ArrowBox[{{0.1179364162324015, -0.14774929259811131`}, {
         0.11714387832793836`, -0.14894016060821372`}, {
         0.08100739677325408, -0.18789705493770567`}, {
         0.03530234096355999, -0.2233124526611132}, {-0.017368944402131933`, \
-0.2513966082992534}, {-0.07512794933518126, -0.269575427619586}, \
{-0.13551755743777064`, -0.2757845217265313}, {-0.19560509841042678`, \
-0.26792928488171674`}, {-0.25225179693863364`, -0.24499495570627533`}, \
{-0.2719619641442645, -0.22969819422351392`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.21339739231997026`, 0.5225519438944012, -0.7981077206831819], 
        ArrowBox[{{-0.29513529517386117`, -0.21171372388276782`}, \
{-0.3019586874896907, -0.2064181927150397}, {-0.3415349749371808, \
-0.15289250335445442`}, {-0.3649747412495038, -0.09627146862274896}, \
{-0.37693171281769317`, -0.031203743188247448`}, {-0.37590556503810385`, 
         0.04046585841144028}, {-0.36092428384710334`, 
         0.11669571922151592`}, {-0.3312508995054929, 
         0.19534391797871056`}, {-0.329315672644223, 
         0.1987665930109927}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.22890118662741585`, 0.522524260490886, -0.7610544975335407], 
        ArrowBox[{{-0.3148781970991675, 
         0.22430095700014208`}, {-0.28673497470523135`, 
         0.27407553720231975`}, {-0.25893162801040176`, 
         0.31275613639804517`}, {-0.22744232825366395`, 
         0.3505977990011927}, {-0.1924604409438213, 
         0.3871963598718738}, {-0.15417933158967737`, 
         0.4221476538702001}, {-0.0810711064516657, 
         0.47733242613393295`}, {-0.0015749653622040005`, 
         0.5234238941745993}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.23860251961691095`, 0.522506937898077, -0.737868840591736],
         ArrowBox[{{0.025016110268922906`, 0.5357848375955814}, {
         0.04369659257679478, 0.5443035707813032}, {0.08862772740403567, 
         0.5611030114066117}, {0.13478510934703875`, 0.574619367481636}, {
         0.18183840036846077`, 0.5845499144609361}, {0.22950909963695984`, 
         0.5904685057210077}, {0.27747723655639334`, 0.592047732300798}, {
         0.325350268442217, 0.5891329761485441}, {0.37273565260988656`, 
         0.5815696192124833}, {0.4193305851477088, 0.5688241153070459}, {
         0.4518584717868957, 0.5558229129622906}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.24017596266969232`, 0.5225041283755772, -0.7341083974775002], 
        ArrowBox[{{0.47839217015149893`, 0.5434178165654716}, {
         0.5085250813319253, 0.5273955512612741}, {0.5501241865543901, 
         0.49931268253855077`}, {0.6058626566206667, 0.44997404851050965`}, {
         0.6551956385574629, 0.39074044395135765`}, {0.6970877891739424, 
         0.3227419736339345}, {0.7305037652792699, 0.24710874233107946`}, {
         0.7423124226493573, 0.20721698994031376`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.2509591995503645, 0.5224848739471549, -0.7083370492196673],
         ArrowBox[{{0.750638471608835, 0.17909011039122721`}, {
         0.7547132021989292, 0.16532494313598373`}, {0.7689857352584052, 
         0.0788747691418378}, {0.7729309748176529, 0.012314449642577432`}, {
         0.7709075665538822, -0.05511703050928231}, {
         0.7629155104670928, -0.12341967131374211`}, {
         0.748954806557285, -0.19259347277080155`}, {
         0.7311032219855356, -0.2546236890963415}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.2598318046093899, 0.522469031121766, -0.6871320068505989], 
        ArrowBox[{{0.7213365112519706, -0.2822638327124193}, {
         0.7029376828517075, -0.331034073335674}, {
         0.6708338199517115, -0.3996707513667257}, {
         0.6326664230202438, -0.4679183478968544}, {
         0.5828027145896738, -0.5435781613364334}, {
         0.5255319593670298, -0.6180621941764926}, {
         0.49415562901117893`, -0.6547851399156888}, {
         0.493457842910238, -0.6555485482012686}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.2735560253134037, 0.5224445253051804, -0.6543318675932992],
         ArrowBox[{{0.47366750496010857`, -0.6772000370245369}, {
         0.461000916562307, -0.6910578345929785}, {
         0.42606782202041427`, -0.726880278208362}, {
         0.3893563453855008, -0.7622524707618387}, {
         0.3509264074232482, -0.7970215931983797}, {
         0.31083792889933815`, -0.8310348264629559}, {
         0.26909090981377065`, -0.8642921705555673}, {
         0.22568535016654603`, -0.8967936254762136}, {
         0.1802410090510519, -0.9284962737425624}, {
         0.13596148752538523`, -0.9572612116212085}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.28522966995820404`, 0.5224236809745098, -0.6264324933229841], 
        ArrowBox[{{0.11088674787374134`, -0.9724796954789421}, {
         0.07558412809748472, -0.9937234554806683}, {
         0.01592681851981709, -1.0262050653330255`}, {-0.04554840671937262, \
-1.0560635196309607`}, {-0.10869583933500077`, -1.0828777767038085`}, \
{-0.16722636507778987`, -1.1041829377840853`}, {-0.2269575270711801, \
-1.122324519962674}, {-0.28754331138224015`, -1.1368474227579597`}, \
{-0.29435360802247235`, -1.1380122043957834`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.2869759250432821, 0.5224205628807578, -0.6222590388730294],
         ArrowBox[{{-0.3232670994422553, -1.1429573493241534`}, \
{-0.34863770407803873`, -1.1472965456883282`}, {-0.44294300180174095`, \
-1.154188621005478}, {-0.53732708983381, -1.1494314362319715`}, \
{-0.5842920719157906, -1.1424455809361562`}, {-0.6307635349754803, \
-1.1320698298675451`}, {-0.6767414790128792, -1.118304183026138}, \
{-0.7222259040279869, -1.1011486404119346`}, {-0.7526538902548495, \
-1.0871436585881464`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.2917865585656575, 0.5224119730667858, -0.6107618870235548],
         ArrowBox[{{-0.7788593966879623, -1.074005559523859}, \
{-0.8105916376048087, -1.0565350758437322`}, {-0.8531923063198925, \
-1.0290438558843813`}, {-0.8947381763194249, -0.9980963441415304}, \
{-0.9232380686874778, -0.975393090922395}, {-0.9510898188702186, \
-0.951089846577761}, {-0.9908723628796348, -0.9080190205312181}, \
{-1.0286305109765477`, -0.8618366963843926}, {-1.0653178964010324`, \
-0.8142742503058689}, {-1.093341444677464, -0.7734525620417252}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3083470172736235, 0.5223824028950125, -0.5711832935645331],
         ArrowBox[{{-1.109160632031605, -0.7487617733826382}, \
{-1.1321593425726848`, -0.7111851152839576}, {-1.1620959060343576`, \
-0.6562914037912215}, {-1.1895953699729231`, -0.5996095517269882}, \
{-1.214579657495626, -0.5414786849325055}, {-1.2446953884913468`, \
-0.459870189688394}, {-1.2700084794700148`, -0.3767443745655394}, \
{-1.277868073870287, -0.34442398246995554`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.30941374984076064`, 0.5223804981491474, -0.568633860885841], 
        ArrowBox[{{-1.2847992862055686`, -0.3159213029466601}, \
{-1.2903541172435264`, -0.2930786080150622}, {-1.3055674886237763`, \
-0.20985025848808228`}, {-1.3157201456084968`, -0.1274990467979877}, \
{-1.3210187060158982`, -0.04615746653660496}, {-1.3215009553885935`, 
         0.03365795467728799}, {-1.3172046792691954`, 
         0.11143068922491287`}, {-1.3160669688450954`, 
         0.12105104785270147`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.2963024798773812, 0.522403909487675, -0.599969081290241], 
        ArrowBox[{{-1.3126219944365396`, 
         0.15018138591748953`}, {-1.3082570128305246`, 
         0.18709120722530473`}, {-1.29483614817695, 
         0.26082540607624904`}, {-1.2770564562484052`, 
         0.3324998990770934}, {-1.2550323079848242`, 
         0.40198129952718487`}, {-1.2288778013726616`, 
         0.46966924353672573`}, {-1.1987073794794545`, 
         0.5352894938177389}, {-1.181665993961793, 0.5674120922506682}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[
        0.29175514083599025`, 0.5224120291659361, -0.6108369736846089], 
        ArrowBox[{{-1.1679190481184405`, 
         0.5933247517904449}, {-1.1646350002792507`, 
         0.5995151023264089}, {-1.12677494985598, 
         0.6623783889354058}, {-1.0802322570260765`, 
         0.7309529578148024}, {-1.029140914389555, 
         0.7982888491230509}, {-0.9735763022032706, 
         0.864773656947517}, {-0.9135987619155086, 
         0.930906554622677}, {-0.9022321736575437, 0.9425613671799286}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.3058620855797799, 0.5223868399615411, -0.5771221448378233],
         ArrowBox[{{-0.8817516638471887, 
         0.9635612043781642}, {-0.8492377199545138, 
         0.9968996092685307}, {-0.7804926677415438, 
         1.0627023920042813`}, {-0.7444735817083372, 
         1.095590250204937}, {-0.7073529579545556, 
         1.128499104264632}, {-0.6691263807413146, 
         1.1614509559598063`}, {-0.6297882004002773, 
         1.1944673977057414`}, {-0.5893453939256007, 
         1.227505283679628}, {-0.5534490440473675, 1.2560120344258003`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.32546146174130963`, 0.5223518435323984, -0.530280704342308], 
        ArrowBox[{{-0.5302895855431472, 
         1.2740135210560084`}, {-0.5051848587334438, 
         1.2933908479484166`}, {-0.46147021422549367`, 
         1.3261720017363314`}, {-0.41666790312125995`, 
         1.35879146770255}, {-0.37077926033342345`, 
         1.3912016047145026`}, {-0.3238055378978327, 
         1.4233490200879866`}, {-0.2757479049735007, 
         1.4551745695871703`}, {-0.2266346467890959, 
         1.4865359673292389`}, {-0.1765071416566905, 
         1.517247685868157}, {-0.1675090621419237, 1.5225150391058138`}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[
        0.33959938887247754`, 0.5223265990061954, -0.4964918292788047], 
        ArrowBox[{{-0.14219419764048852`, 
         1.5373340161190363`}, {-0.12538776809718188`, 
         1.5471722711514695`}, {-0.07330108049067452, 
         1.576160090715961}, {-0.02027380907648141, 1.6040493336876542`}, {
         0.033665140046877415`, 1.6306660107818127`}, {0.08848468492167641, 
         1.655823954302939}, {0.14415156773098303`, 1.6793248181447762`}, {
         0.20058404296770566`, 1.7009237582261885`}, {0.2570910078731721, 
         1.7201481880012521`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3415556919947158, 0.5223231058529932, -0.4918163714715619],
         ArrowBox[{{0.28522164125748567`, 1.7284597067540841`}, {
         0.31535038016955136`, 1.737332966468088}, {0.3735255761823596, 
         1.751604292188571}, {0.43211297679420196`, 1.7628690898847912`}, {
         0.49101819446790285`, 1.7708203171408243`}, {0.5501408198418797, 
         1.7751359030623777`}, {0.609374421730142, 1.775478748276789}, {
         0.6669857267306071, 1.7718742419909441`}, {0.7198881761000312, 
         1.7649533911623567`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.34118816259438084`, 0.5223237621094226, -0.49269474670117425`], 
        ArrowBox[{{0.7486871369796798, 1.7594304454883576`}, {
         0.7815761330425403, 1.7527477407293848`}, {0.8382833501972877, 
         1.7368581697012746`}, {0.8944051940673654, 1.7165126249054252`}, {
         0.9497875328053491, 1.6915372541137565`}, {1.004268958656189, 
         1.6617621794174355`}, {1.0576807879572099`, 1.6270214972268757`}, {
         1.1099092189168913`, 1.5875407415689322`}, {1.137074672619831, 
         1.564187447749674}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.36701344496758465`, 0.5222776487710583, -0.4309737297874456], 
        ArrowBox[{{1.1593184130321674`, 1.5450651974398113`}, {
         1.1608632848707905`, 1.5437371192727767`}, {1.210401512404158, 
         1.4957623300932779`}, {1.2583803140862828`, 1.4438042249873633`}, {
         1.3046539884704917`, 1.38808680611402}, {1.3490747200941493`, 
         1.328870226834293}, {1.3914925794786577`, 1.2664507917112882`}, {
         1.4315729960923624`, 1.201456939841022}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.391440718445506, 0.5222340317019039, -0.3725938779159552], 
        ArrowBox[{{1.445942267444166, 1.1758844658913876`}, {
         1.4698227683372738`, 1.1333366308556463`}, {1.5057063404259075`, 
         1.0633340360314147`}, {1.5393372983327889`, 0.9915682855815036}, {
         1.5706540021877915`, 0.9184879289017629}, {1.5996021133132348`, 
         0.8445749512398577}, {1.6246445403964342`, 0.7745135116483871}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.3903459689617965, 0.522235986474465, -0.37521026949781205`], 
        ArrowBox[{{1.6338407722198816`, 0.7466606327852733}, {
         1.6502117086269508`, 0.6963462532192952}, {1.671801021422091, 
         0.6231616826150483}, {1.6858835275980948`, 0.5708600312650989}, {
         1.6987085200034544`, 0.5190532091336181}, {1.7102916745773593`, 
         0.46783668224641667`}, {1.7206528597469788`, 0.4172984619368354}, {
         1.729816136427464, 0.3675191048457419}, {1.7376390324241227`, 
         0.31961711801725656`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.3632683192956861, 0.522284336026006, -0.43992437596427647`], 
        ArrowBox[{{1.7418038398675515`, 0.2905811632277402}, {
         1.7446661704215347`, 0.2705219334201481}, {1.750422012005324, 
         0.22342795890503409`}, {1.7586703546511981`, 0.1322187978370945}, {
         1.762681426544505, 0.045097621626357484`}, {
         1.7626888073465667`, -0.03787548876595512}, {
         1.7589548916284468`, -0.11678465302496831`}, {
         1.7559027849554545`, -0.14816434739552586`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.3226905243425027, 0.5223567912875482, -0.5369030936578301],
         ArrowBox[{{1.75306311538087, -0.17735990735164975`}, {
         1.7516679090404212`, -0.19170447431405702`}, {
         1.7409482810916412`, -0.2627095279889228}, {
         1.726977028099311, -0.3300660336220137}, {
         1.709933472747996, -0.39413886560454114`}, {
         1.689966658733751, -0.45518059696075497`}, {
         1.6671971150453477`, -0.5133445213347154}, {
         1.6417524944450521`, -0.5689476971231123}, {
         1.6274236127400976`, -0.5962705302246697}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.29698408307897867`, 0.5224026924245424, -0.598340086798475], 
        ArrowBox[{{1.6138001179038022`, -0.6222483059741422}, {
         1.6137502835126052`, -0.6223433320048842}, {
         1.5832936118101333`, -0.6738094300581365}, {
         1.5504563000270826`, -0.7235598731754473}, {
         1.5153042467972822`, -0.7718787977191529}, {
         1.477903350754557, -0.8190503400515919}, {
         1.446385569528614, -0.8561073681564862}, {
         1.4134602730920038`, -0.892639169028354}, {
         1.3791441590344118`, -0.9287699857905286}, {
         1.343453924945523, -0.9646240615663437}, {
         1.341811918822721, -0.9662064075233202}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.3051009780452945, 0.5223881989867305, -0.5789411503507265],
         ArrowBox[{{1.320689949893173, -0.9865609370679609}, {
         1.3064062684150213`, -1.000325639479134}, {
         1.2680178870325898`, -1.0359989626522343`}, {
         1.2283054783879142`, -1.0717682742089785`}, {
         1.1872857400706798`, -1.1077578172726996`}, {
         1.1449245600533395`, -1.1439807615326154`}, {
         1.1011721925799678`, -1.1804161002366766`}, {
         1.056021884647682, -1.2171368118463162`}, {
         1.0094668832536002`, -1.2542158748229673`}, {
         0.9863431570938953, -1.272298932670445}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.327687338514061, 0.5223478690314696, -0.5249609802071167], 
        ArrowBox[{{0.9632363330063115, -1.2903687728753253`}, {
         0.9615004353948376, -1.2917262676280645`}, {
         0.9121157880685093, -1.3297409687230426`}, {
         0.8613061882717334, -1.3683329565693347`}, {
         0.8090648830016273, -1.4075752096283733`}, {
         0.7553658287185403, -1.4473323980072221`}, {
         0.7001770463330469, -1.487405096934676}, {
         0.6434828795176035, -1.5277701425547654`}, {
         0.6092731803271044, -1.5516485205645327`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.3512475632423538, 0.5223058001549657, -0.4686533275769548],
         ArrowBox[{{0.5852194904220785, -1.5684373351919374`}, {
         0.5255157672866909, -1.6092846184489766`}, {
         0.464211509216129, -1.650387721011163}, {
         0.40133924140543786`, -1.6916905148421115`}, {
         0.3368833075270741, -1.7331698360858527`}, {
         0.28627828871743277`, -1.7649790371078695`}, {
         0.2348126340866984, -1.7964937415746711`}, {
         0.21601103678164035`, -1.807640152119435}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.3679291623592376, 0.5222760136762192, -0.4287852151450248],
         ArrowBox[{{0.19077859895143978`, -1.8225990466504325`}, {
         0.18453382960044848`, -1.8263012194932038`}, {
         0.13343398592156733`, -1.8555716241348725`}, {
         0.08153311481937782, -1.8841516626557824`}, {
         0.028851228063199563`, -1.9118880422120408`}, \
{-0.024561204882865943`, -1.9384943308997191`}, {-0.07865371455471651, \
-1.963684096814888}, {-0.13342630095235208`, -1.9874573399575488`}, \
{-0.18887896407577076`, -2.0098140603276993`}, {-0.2041156394048247, \
-2.015383100862584}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.37124283711827727`, 0.5222700968152462, -0.4208657131278274], 
        ArrowBox[{{-0.23166636481933048`, -2.0254529555576104`}, \
{-0.2449070353202617, -2.0302924516508387`}, {-0.3014058460811141, \
-2.048430707652465}, {-0.3583753963583261, -2.0642288283325767`}, \
{-0.41581568615189757`, -2.077686813691175}, {-0.4735684093266326, \
-2.0883020138249195`}, {-0.5314752597473351, -2.0955717788304726`}, \
{-0.5895362374140052, -2.0994961087078345`}, {-0.6477513423266406, \
-2.100075003457004}, {-0.662671316498082, -2.099046278929}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[
        0.3672968587253962, 0.5222771427105892, -0.43029638635759737`], 
        ArrowBox[{{-0.6919351716654718, -2.0970285512004705`}, \
{-0.7420702343534039, -2.0935717644723257`}, {-0.8358705368118724, \
-2.0767977337669823`}, {-0.882410054966678, -2.064180850415406}, \
{-0.9286205313458283, -2.0485422838092786`}, {-0.9744355011547954, \
-2.0297307055071374`}, {-1.0197884995990518`, -2.007594787067521}, \
{-1.0646145396247395`, -1.9823141191744114`}, {-1.1034219917576142`, \
-1.9576230765205433`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.3913285250294379, 0.5222342320332258, -0.3728620140637299],
         ArrowBox[{{-1.1275087196734601`, -1.940893483397821}, \
{-1.1524263645667703`, -1.9231641743503494`}, {-1.1952805839623686`, \
-1.8892977043445751`}, {-1.2373459642938582`, -1.8525721072264245`}, \
{-1.2785567228008674`, -1.8129887864584868`}, {-1.318847076723023, \
-1.7705491455033509`}, {-1.3581512432999527`, -1.7252545878236063`}, \
{-1.3964294308126726`, -1.6774062942674}, {-1.4334773663471907`, \
-1.6276294234847235`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[
        0.4325267683956305, 0.5241823269262468, -0.21203973823224734`], 
        ArrowBox[{{-1.4502097141215413`, -1.6035366077203193`}, \
{-1.4697586983239268`, -1.5753685219126363`}, {-1.5047022045322287`, \
-1.5214585676259262`}, {-1.5384265765154916`, -1.465807584274229}, \
{-1.5708780273786, -1.4085553341134684`}, {-1.6020027702264366`, \
-1.3498415793995677`}, {-1.631747018163886, -1.289806082388451}, \
{-1.6601255395178702`, -1.2287280367968907`}, {-1.6640489057934797`, \
-1.2197642592362143`}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[
        0.44876796417274417`, 0.5252406317074554, -0.13968480609266676`], 
        ArrowBox[{{-1.6758105698974695`, -1.1928921975001032`}, \
{-1.6871741965297844`, -1.1669295383296128`}, {-1.7128708431762227`, \
-1.104614702224471}, {-1.7371933334337795`, -1.0419876437193196`}, \
{-1.7601195212790481`, -0.9792524780520125}, {-1.7816272606886228`, \
-0.9166133204604031}, {-1.8016944056390964`, -0.8542742861823457}, \
{-1.8202988101070643`, -0.7924394904556913}, {-1.8240777025428843`, \
-0.7789738185845941}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.4311629208627035, 0.5240934562307177, -0.21811571299715496`], 
        ArrowBox[{{-1.8320033855151596`, -0.7507315100056655}, \
{-1.837488819804328, -0.7311847619934057}, {-1.8533344702073706`, \
-0.6705464567315566}, {-1.867846149939806, -0.6106694807426624}, \
{-1.8810342476252473`, -0.5516987400992416}, {-1.892909151887308, \
-0.4937791408738128}, {-1.9034812513496018`, -0.4370555891388945}, \
{-1.9127609346357417`, -0.38167299096700513`}, {-1.9207585903693416`, \
-0.3277762524306633}, {-1.9216775024723043`, -0.32031303687666673`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.38703658781515066`, 0.5222418956688113, -0.38311951001547007`], 
        ArrowBox[{{-1.9252621146798816`, -0.2911995520325995}, \
{-1.9310405402591186`, -0.2442683651198071}, {-1.938364862615706, \
-0.16419802066811087`}, {-1.942864740659313, -0.08771123965224349}, \
{-1.9446733576101487`, -0.014954042648873919`}, {-1.9439187505021176`, 
         0.05418078052928454}, {-1.940726015691235, 
         0.11994514336320922`}, {-1.9382753226669072`, 
         0.14776773012153901`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3330732078402054, 0.522338252082813, -0.5120890461476848], 
        ArrowBox[{{-1.9357015239959663`, 
         0.1769879286979674}, {-1.9352239253808778`, 
         0.1824100802167617}, {-1.9275412517744228`, 
         0.24164662545380838`}, {-1.9177821194549118`, 
         0.2978418522482743}, {-1.9060365686509102`, 
         0.35124914166554744`}, {-1.8924122450340792`, 
         0.4020389899066868}, {-1.8770167942760807`, 
         0.4503818931727517}, {-1.8599264756881106`, 
         0.49647008164990153`}, {-1.8411996135182425`, 
         0.5405082049443533}, {-1.8209169508434535`, 
         0.5826853883872518}, {-1.813358099447819, 0.5967573620575084}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[0.2961129680452464, 0.5224042478779048, -0.6004220042371233],
         ArrowBox[{{-1.7994773231348862`, 
         0.6225985790063049}, {-1.7991592307407207`, 
         0.6231907573097426}, {-1.7513118391745575`, 
         0.6997531569950768}, {-1.6979423455452085`, 
         0.7714107844847962}, {-1.639499764710113, 
         0.8395143030654875}, {-1.5764331115267076`, 
         0.9054143760237374}, {-1.5194686515360236`, 
         0.9597723251964985}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[
        0.30090655519449155`, 0.5223956885017479, -0.5889655922900858], 
        ArrowBox[{{-1.4979380950633243`, 
         0.9796889069795255}, {-1.4731966357932258`, 
         1.0018656960458796`}, {-1.4364248582238275`, 
         1.03368974464877}, {-1.3984965507127622`, 
         1.065541474266524}, {-1.3594256809925018`, 
         1.0975354109294058`}, {-1.3192262167955167`, 
         1.129786080667681}, {-1.2779121258542787`, 
         1.1624080095116145`}, {-1.2354399080360885`, 
         1.1954128231268903`}, {-1.1917483807881932`, 
         1.2287804855285527`}, {-1.1556501210920995`, 
         1.2559385534584695`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.32361164925375696`, 0.5223551465371018, -0.5347016553383727], 
        ArrowBox[{{-1.1321429335599302`, 
         1.2734841812000888`}, {-1.1006571744128628`, 
         1.296872490908251}, {-1.053232383490213, 
         1.331730900994896}, {-1.0045380595474271`, 
         1.367220294085147}, {-0.9545616466868996, 
         1.4034077037333057`}, {-0.9032905890110259, 
         1.4403601634936758`}, {-0.8506938806717368, 
         1.4779838488185946`}, {-0.7967348389131294, 
         1.516135440359794}, {-0.7754132906420675, 1.53103454822566}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[
        0.34920318947268963`, 0.5223094505661411, -0.4735392694300572], 
        ArrowBox[{{-0.751368733705625, 
         1.547836444730954}, {-0.7413923924758483, 
         1.5548077294706681`}, {-0.6846454701005387, 
         1.593993507504611}, {-0.6264730005278399, 
         1.6336855658150202`}, {-0.5668539124983911, 
         1.6738766957552937`}, {-0.5057671347528373, 
         1.7145596886788252`}, {-0.4431915960318239, 
         1.755727335939009}, {-0.3920587978840363, 
         1.7888323300317488`}, {-0.3858693749001876, 1.7927620266456183`}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[0.3703680850903162, 0.5222716587627851, -0.4229563227843989],
         ArrowBox[{{-0.3611056256236016, 
         1.8084846589382986`}, {-0.33998351217965855`, 
         1.8218951978358713`}, {-0.28696469931789337`, 
         1.8547915705971751`}, {-0.2330013196979434, 
         1.8873970795614594`}, {-0.17810632848021699`, 
         1.9195527388201028`}, {-0.1222926808251224, 
         1.951099562464485}, {-0.06557822721889271, 
         1.9819202524329274`}, {-0.00799842137442475, 2.0117396341092895`}, {
         0.021117089669369805`, 2.0259843398389057`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.38021876990538933`, 0.5222540694890094, -0.39941372312191503`], 
        ArrowBox[{{0.047465962838239575`, 2.0388754735041523`}, {
         0.050420331868304774`, 2.0403208926618883`}, {0.10965162766931559`, 
         2.0674272132590366`}, {0.16964015752031386`, 2.092781807573718}, {
         0.23031409653111215`, 2.116085045281584}, {0.2916222652888898, 
         2.1370658485549496`}, {0.35351348438082614`, 2.155453139566131}, {
         0.4158973307107703, 2.170921440761038}, {0.4628334466670724, 
         2.1800394648047043`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3762737844481294, 0.5222611136113778, -0.4088420232896837],
         ArrowBox[{{0.49174974149103096`, 2.184899146019139}, {
         0.5417195440548447, 2.1917136782013125`}, {0.6049882773576243, 
         2.196402202117472}, {0.6683402945329213, 2.196889964049586}, {
         0.7316247084187011, 2.1929031155214584`}, {0.7947206638103649, 
         2.184147872743982}, {0.8575073055033139, 2.170330451928047}, {
         0.914023354056682, 2.1534221846679933`}, {0.9256173537977438, 
         2.149078408780291}}]}}, 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[
        0.38421998672266866`, 0.5222469249605471, -0.3898510330693549], 
        ArrowBox[{{0.9530861038807232, 2.1387870428202613`}, {
         0.9700186850171711, 2.132443128787163}, {1.0253878290535268`, 
         2.107284337575102}, {1.080025316834494, 2.0778368643213527`}, {
         1.1338256790288188`, 2.043991762315461}, {1.1866834463052465`, 
         2.0056400848469718`}, {1.2384931493325224`, 1.9626728852054283`}, {
         1.289149318779389, 1.914981216680379}, {1.3122187255875164`, 
         1.8909880659974907`}}]}}, 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[
        0.427472509382493, 0.5238529825508402, -0.23455658815697752`], 
        ArrowBox[{{1.3323135546433296`, 1.869624606026184}, {1.36311159857519,
          1.8351306190058407`}, {1.3989058705345048`, 1.7920875691996787`}, {
         1.43384855101461, 1.7470793723976155`}, {1.4678943803753894`, 
         1.7001910438371766`}, {1.5009980989767355`, 1.6515075987558727`}, {
         1.5331144471785318`, 1.601114052391229}, {1.5641981653406627`, 
         1.54909541998077}, {1.585584751629661, 1.511074618010145}}]}}, 
      {Arrowheads[{{0.024999999999999994`, 1.}}], 
       {LABColor[
        0.46135147866695975`, 0.5260605955658064, -0.08362493526779786], 
        ArrowBox[{{1.5997255296763953`, 1.4853769645776824`}, {
         1.6232626885117536`, 1.441134995029745}, {1.6512252663316267`, 
         1.3856146053270406`}, {1.6781061871960854`, 1.3292682183215518`}, {
         1.7038790502714, 1.2722464246497993`}, {1.7285174547238404`, 
         1.214699814948302}, {1.7519949997196833`, 1.156778979853564}, {
         1.7742852844251993`, 1.0986345100021047`}, {1.7795199809408377`, 
         1.0842063421265113`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.4617221419825233, 0.5260847486370741, -0.08197362095496712], 
        ArrowBox[{{1.78952433786668, 1.0566317653039234`}, {
         1.7954136605790447`, 1.0403992795210915`}, {1.8154214037883094`, 
         0.9822007113040285}, {1.8343059990219033`, 0.9241812191369653}, {
         1.8520649312487365`, 0.8664832168059505}, {1.868695685437726, 
         0.8092491180970187}, {1.8841957465577812`, 0.7526213367962183}, {
         1.8985625995778133`, 0.6967422866895987}, {1.9117937294667373`, 
         0.6417543815631935}, {1.913378133362655, 0.6346900055967842}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.42943742401712154`, 0.5239810198321483, -0.22580284446718346`], 
        ArrowBox[{{1.9197975630124307`, 0.606067717648124}, {
         1.9239264857268132`, 0.5876581047547188}, {1.9350104838705617`, 
         0.5344102686947101}, {1.945061607882289, 0.4820877808084327}, {
         1.954095741746298, 0.43076754852116594`}, {1.9621287694468925`, 
         0.3805264792581894}, {1.9691765749683772`, 0.33144148044476857`}, {
         1.9752550422950557`, 0.28358945950618286`}, {1.9803800554112316`, 
         0.23704732386771116`}, {1.9858966327467693`, 
         0.17145113387418756`}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[
        0.3755591388056064, 0.5222623896747272, -0.41054998741383414`], 
        ArrowBox[{{1.9881621423743077`, 0.14220825301307388`}, {
         1.9919840945047114`, 0.06271972873822584}, {
         1.9928092479608004`, -0.017468594740968714`}, {
         1.9905661321176267`, -0.09288526981407322}, {
         1.9854280025868225`, -0.16377368492778221`}, {
         1.9775601290033054`, -0.23056830721934918`}, {
         1.967137763472887, -0.29346475546281886`}, {
         1.966568704357029, -0.29609605235253034`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3188137767624744, 0.5223637135651181, -0.5461683090192488],
         ArrowBox[{{1.96036825529259, -0.3247665751214605}, {
         1.9543361581013756`, -0.352658648432245}, {
         1.9392814047761815`, -0.40843735215326876`}, {
         1.9220715038313436`, -0.4611406596524317}, {
         1.9028395700426144`, -0.5110428302051488}, {
         1.881718718185745, -0.5584181230868347}, {
         1.8481674289067451`, -0.6225777389293402}, {
         1.8110143194260795`, -0.6827047858569105}, {
         1.7821181073496186`, -0.7232813560221708}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.2929321767290712, 0.5224099274636732, -0.608023922070494], 
        ArrowBox[{{1.7646777642681466`, -0.7468540998217515}, {
         1.7269940057470192`, -0.7938659072460904}, {
         1.6804921660160232`, -0.8461771144309838}, {
         1.631016195888887, -0.8968813127668505}, {
         1.5786843781435134`, -0.9465366277524219}, {
         1.5236149955578024`, -0.9957011848864334}, {
         1.4658004602497217`, -1.0447332209469842`}, {
         1.4524815718732174`, -1.0555271820160792`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3059198769491792, 0.5223867367699115, -0.5769840266156636],
         ArrowBox[{{1.4296924367847352`, -1.0739960684568846`}, {
         1.4051612582458484`, -1.0938767505860982`}, {
         1.3417077831869952`, -1.1435185661133955`}, {
         1.2754504287139747`, -1.1940454598384969`}, {
         1.2062597595147326`, -1.245572182247154}, {
         1.1341831188497544`, -1.2985574123485568`}, {
         1.0784479169755954`, -1.3389099741505284`}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[
        0.33055002848225135`, 0.5223427574439473, -0.5181193072529899], 
        ArrowBox[{{1.0546768699893114`, -1.3560966001260122`}, {
         1.0202701272105585`, -1.380819235251836}, {
         0.980735363489528, -1.4091312324994916`}, {
         0.9216103470841798, -1.4512461669157337`}, {
         0.8607560779809451, -1.4942477697926513`}, {
         0.798137082678702, -1.5381323230346426`}, {
         0.7337124221471243, -1.58287735824866}, {
         0.6949857330065846, -1.6095013998272414`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[
        0.3560937392582504, 0.5222971468767106, -0.45707123110569153`], 
        ArrowBox[{{0.6708136742004546, -1.6261193424651685`}, {
         0.6674356918266724, -1.6284416567442155`}, {
         0.5992550216286106, -1.674765249533371}, {
         0.5291130759349979, -1.7217694173307418`}, {
         0.4569470535986801, -1.7693566905535043`}, {
         0.3828080867280995, -1.817135478119518}, {
         0.306799682144263, -1.8645620408351429`}, {
         0.3026820572973768, -1.8670318575949831`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.37559008459207566`, 0.5222623344182734, -0.4104760286712935], 
        ArrowBox[{{0.2775268883372515, -1.8821203273328986`}, {
         0.22893683907756632`, -1.9112654103566196`}, {
         0.1492390066992276, -1.9568329998460416`}, {
         0.0677300841212777, -2.0008106039713627`}, {-0.015561579603450393`, \
-2.0427023989064015`}, {-0.10060318548130066`, -2.0819709423308317`}, \
{-0.11169768702015552`, -2.0865832423620656`}}]}}, 
      {Arrowheads[{{0.019607174956013582`, 1.}}], 
       {LABColor[
        0.3819145461814409, 0.5222510415296603, -0.39536091027349957`], 
        ArrowBox[{{-0.1387836235312372, -2.0978436370159885`}, \
{-0.18735748457780435`, -2.118037173430186}, {-0.2572330578521371, \
-2.1438056221125485`}, {-0.32786556389283544`, -2.1664812526834916`}, \
{-0.39914436497946487`, -2.1856046964999116`}, {-0.4676726009258056, \
-2.2}}]}}}, 
     {GrayLevel[0.65], 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.19830280970068428`, 0.5225788966140551, -0.8341829502077699], 
        ArrowBox[{{0.07465311959633081, -0.05268529782351574}, {
         0.032150250714329476`, -0.10329080616862767`}, {
         0.003917433368371151, -0.12190161048750597`}, \
{-0.028279365101369355`, -0.13491958599271325`}, {-0.06284462124883967, \
-0.14073189223700963`}, {-0.08048227132690493, -0.14052438022158353`}, \
{-0.09795059571816657, -0.13800160390058291`}, {-0.13640005617584816`, \
-0.12228357201210306`}, {-0.16814625506510864`, -0.09274494054637192}, \
{-0.19132773492415633`, -0.042043345823575745`}, {-0.19264727397495462`, \
-0.03667474239477971}, {-0.19379833829810458`, -0.03118327956888282}, \
{-0.19497971460890226`, -0.011541883203497843`}, {-0.19402885443539195`, 
         0.009024824572742125}, {-0.1877394465930515, 
         0.05153712103513657}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.2083093022380671, 0.522561029131735, -0.8102679785833847], 
        ArrowBox[{{-0.1782375736170889, 
         0.07928749367100016}, {-0.1723936303202506, 
         0.09632817373338165}, {-0.14774787484444132`, 
         0.14148666285761502`}, {-0.11055551602132052`, 
         0.18927175553058392`}, {-0.06307380078385533, 
         0.232731652734162}, {-0.006533734232223001, 0.2689499205820476}, {
         0.056950273666663005`, 0.29514722425091394`}, {0.12493859837327138`, 
         0.30856950484611023`}, {0.16541589185043262`, 
         0.30739351403658205`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.21492332478300583`, 0.5225492192062846, -0.7944608252882278], 
        ArrowBox[{{0.1947170305289635, 0.3064146382789056}, {
         0.2612778784295539, 0.287231731884917}, {0.3218598313911007, 
         0.24954913061175388`}, {0.3715366679729022, 0.19433190676784845`}, {
         0.407115635100761, 0.12294127757541919`}, {0.4253120510829226, 
         0.037679466481629786`}, {
         0.42415879246921195`, -0.020472028776963205`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.22655414351604203`, 0.522528451345088, -0.7666638026122206], 
        ArrowBox[{{0.42357716909784404`, -0.04979959530912409}, {
         0.42341951070107825`, -0.05774930529004942}, {
         0.4142321626000317, -0.10820924058644872`}, {
         0.3994865301851118, -0.15975414059807325`}, {
         0.37900393171536134`, -0.2118984135068406}, {
         0.35260568544982285`, -0.2641564674946684}, {
         0.3203761838216784, -0.31599054751597855`}, {
         0.28255014736361794`, -0.36683309096662386`}, {
         0.23917438648394634`, -0.41615379469066854`}, {
         0.22300856860523413`, -0.43178709382624775`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.2409186091685373, 0.5225028023142088, -0.7323335128333079],
         ArrowBox[{{0.20192237702372204`, -0.4521786844712223}, {
         0.1902957115909685, -0.4634223555321766}, {
         0.13108547047986335`, -0.5117843834971805}, {
         0.06651209722144291, -0.5555828417706725}, {-0.003000814541074713, \
-0.5938629592278591}, {-0.07702967116447144, -0.625669964743947}, \
{-0.14049810863029652`, -0.6460187698106491}, {-0.18228678624352368`, \
-0.6551264231369877}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.24545494512281854`, 0.5224947022829382, -0.7214919172172591], 
        ArrowBox[{{-0.21104098274318822`, -0.6607999367263361}, \
{-0.27163123220419083`, -0.6674606504159598}, {-0.33820018425549647`, \
-0.667071226451677}, {-0.4044051484817116, -0.6585571847898699}, \
{-0.469224065721355, -0.6416025432466127}, {-0.5318504186916264, \
-0.6156980161981982}, {-0.591477690109726, -0.5803343180209193}, \
{-0.6240532948941977, -0.5544182813318381}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.2503597251371842, 0.522485944362032, -0.7097697603846629], 
        ArrowBox[{{-0.6470083483585515, -0.5361560261344891}, \
{-0.6472466905056325, -0.5359664092764391}, {-0.6982681320166269, \
-0.4836002483466324}, {-0.7436903497708626, -0.4235530463381097}, \
{-0.7826616788964921, -0.3561420143574818}, {-0.8146471772098535, \
-0.2824851853666555}, {-0.8392928869205315, -0.20415820481627847`}, \
{-0.8494886344424826, -0.15417623653522305`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.26061266682723083`, 0.5224676368228326, -0.6852657887214737], 
        ArrowBox[{{-0.8553515587987516, -0.12543479324444323`}, \
{-0.8560186197465514, -0.12216470254607345`}, {-0.8642441874059378, \
-0.03750830839576238}, {-0.8638399740115952, 
         0.048966775276148435`}, {-0.8549338336163586, 
         0.13650744752899022`}, {-0.8373317828481494, 
         0.22424673064979733`}, {-0.8118180193739882, 0.3081026651293317}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.2671429886942884, 0.5224559763523862, -0.6696586754832091],
         ArrowBox[{{-0.8009979916306071, 
         0.3353535832337202}, {-0.7755571857298565, 
         0.3974855802695565}, {-0.7547157789241631, 
         0.44029876296363324`}, {-0.7317505358436754, 
         0.48287726409544135`}, {-0.7066686195338862, 
         0.5251804644822294}, {-0.679477193040288, 
         0.5671677449412459}, {-0.6501834194083733, 
         0.6087984862897393}, {-0.6187944616836354, 
         0.6500320693449584}, {-0.5853442286890169, 
         0.6908460179870546}, {-0.5707135666771064, 0.7075011881814731}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.280859091399921, 0.5224314850312086, -0.6368779377994582], 
        ArrowBox[{{-0.5513544606264652, 
         0.729539097732165}, {-0.5498748587174459, 
         0.7312234385770728}, {-0.5124058590193927, 
         0.7711320856536006}, {-0.472956736845326, 
         0.8105397137552279}, {-0.4315469994457163, 
         0.8494140774205422}, {-0.388196154071034, 
         0.8877229311881316}, {-0.34292370797174765`, 
         0.9254340295965853}, {-0.29574916839832766`, 
         0.9625151271844914}, {-0.220491891605473, 
         1.0174425486987686`}, {-0.22006484442263968`, 1.017724031564219}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.294252315400283, 0.5224075702386735, -0.6048688626184093], 
        ArrowBox[{{-0.1955732628118631, 
         1.0338673544764052`}, {-0.1473034353362149, 
         1.065683813872071}, {-0.07082154699714932, 1.1110882950978318`}, {
         0.008638982084228978, 1.1527176053145314`}, {0.09087199851175215, 
         1.1899713773994414`}, {0.17549990511546085`, 1.2218631091868817`}, {
         0.19739152787868416`, 1.228316806187689}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[
        0.29802242853594724`, 0.5224008383663871, -0.5958584977654602], 
        ArrowBox[{{0.22552769699916292`, 1.2366114087500943`}, {
         0.26214510472540214`, 1.2474062985111756`}, {0.3502824574908038, 
         1.265492085687749}, {0.43938682356089787`, 1.2750116110320295`}, {
         0.5161081577796222, 1.2760934099566665`}, {0.5926785379839071, 
         1.2698338738893813`}, {0.6601562571255256, 
         1.2570150407647582`}}]}}, 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[
        0.29910257644429017`, 0.5223989096662373, -0.593277003152672], 
        ArrowBox[{{0.6883910362288387, 1.2492137526555662`}, {
         0.7433455337044894, 1.2320081896218258`}, {0.8164224694489987, 
         1.1996427671475483`}, {0.8873038182358158, 1.1588186207359632`}, {
         0.9554764443042462, 1.10943683800171}, {1.0204272118935946`, 
         1.051398506559428}, {1.0540700164053005`, 1.0152086900704433`}}]}}, 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[
        0.31764558786584335`, 0.5223657994702822, -0.5489602167941744], 
        ArrowBox[{{1.0740420178409131`, 0.9937246587192203}, {
         1.0817166102600706`, 0.9854690422416932}, {1.1389472000981136`, 
         0.9129077627199019}, {1.1916689528043738`, 0.834356608366928}, {
         1.216198381294539, 0.7930354344952686}, {1.2394318397755044`, 
         0.750457519555637}, {1.2613699973274584`, 0.7068204959042094}, {
         1.2820310376938533`, 0.6623581158385665}, {1.3006584724072043`, 
         0.6188997637162985}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.327401829156656, 0.522348378833818, -0.5256433320057443], 
        ArrowBox[{{1.3114652808678027`, 0.5916304900874024}, {
         1.319401840547882, 0.5714949762994873}, {1.3360516398744706`, 
         0.5253630617434822}, {1.351304395693411, 0.47894348060812475`}, {
         1.3651301264241815`, 0.43237065535212765`}, {1.3774988504862609`, 
         0.38577900843420404`}, {1.3980227424727993`, 0.29279765415707654`}, {
         1.413072117879706, 0.20063592056159388`}, {1.4167600194321819`, 
         0.16576851117317287`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3155733344411131, 0.5223694996630611, -0.553912789502925], 
        ArrowBox[{{1.4198453754595524`, 0.13659789200544156`}, {
         1.4226448870832706`, 0.1101297999257319}, {1.4267389604597824`, 
         0.022115284527466368`}, {
         1.4260792790262846`, -0.04895828401096288}, {
         1.4219100815139256`, -0.1182277871013056}, {
         1.4143241165893257`, -0.18553841732025328`}, {
         1.4034141329191057`, -0.25073536724450496`}, {
         1.3922849962328863`, -0.30046821161439957`}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[
        0.29707347315128546`, 0.5224025328106185, -0.5981264493990832], 
        ArrowBox[{{1.3850631136275966`, -0.3288876182244145}, {
         1.3720242150373891`, -0.3752397943224536}, {
         1.3517463058933437`, -0.4348065179643799}, {
         1.3285445392599446`, -0.49264420456221947`}, {
         1.3024911875264724`, -0.5489155708567394}, {
         1.273643489027752, -0.6038500476317378}, {
         1.2420774746666794`, -0.6575936731172205}, {
         1.2078691753461508`, -0.7102924855431935}, {
         1.197796875172895, -0.7244719257517328}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.29695456266751036`, 0.5224027451358624, -0.5984106389724726], 
        ArrowBox[{{1.180809674354964, -0.7483859269396506}, {
         1.1710561394038281`, -0.7621166203545219}, {
         1.131653925140099, -0.8132499828331311}, {
         1.0897055784019485`, -0.8638592659646152}, {
         1.0452541450363577`, -0.9141111627345742}, {
         1.0004516912142667`, -0.961841479964113}, {
         0.9533263537383059, -1.0093495257080587`}, {
         0.9038923555868175, -1.0567418134073443`}, {
         0.8855179598014581, -1.0735726874337606`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.3145422536381988, 0.5223713407495305, -0.5563770164088088],
         ArrowBox[{{0.8638875476760445, -1.0933860595780778`}, {
         0.8521639197381448, -1.1041248565029043`}, {
         0.7981552691706306, -1.1516051684356723`}, {
         0.7418806268626176, -1.1992892626465814`}, {
         0.6833542157924503, -1.2472836525765636`}, {
         0.6225902589384681, -1.2956948516665565`}, {
         0.5748286953551728, -1.3326889218463491`}, {
         0.5257487967034645, -1.3695656949748487`}, {
         0.5231249641895394, -1.3714770071950222`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3348844048197612, 0.5223350180295332, -0.5077603841104694],
         ArrowBox[{{0.49941524359409967`, -1.3887481853172763`}, {
         0.475349577967325, -1.4062786490778056`}, {
         0.4236300541307283, -1.442781262180974}, {
         0.37058924017765094`, -1.4790270123101068`}, {
         0.3162261510920696, -1.5149693774909576`}, {
         0.26053980185795805`, -1.550561835749281}, {
         0.2035292074592983, -1.5857578651108257`}, {
         0.15842687210898995`, -1.6126202999372141`}, {
         0.13074080015948844`, -1.628516217936423}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3483236249652715, 0.5223110211067904, -0.4756413806501613],
         ArrowBox[{{0.1052252517629967, -1.6429848082968026`}, {
         0.06751082779196663, -1.663714449974954}, {
         0.02173583902401243, -1.6877376698345208`}, {-0.024681732002707225`, \
-1.7108640005676876`}, {-0.0717164538972532, -1.7329662726777626`}, \
{-0.11931456431578184`, -1.7538205900242227`}, {-0.16742230091445306`, \
-1.7732030564665475`}, {-0.21603966369326744`, -1.7911136720047376`}, \
{-0.2651666526522221, -1.8075524366387912`}, {-0.29776673775037515`, \
-1.8171796392943977`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[
        0.34899577083158057`, 0.522309820930571, -0.4740349886741339], 
        ArrowBox[{{-0.3260274114548552, -1.8250166322136858`}, \
{-0.36455283917692893`, -1.834662807688424}, {-0.41471286925927175`, \
-1.844996512727485}, {-0.4651841905549361, -1.8531825641093742`}, \
{-0.5158305551390167, -1.8588798692719044`}, {-0.5665157150866076, \
-1.8617473356528866`}, {-0.6172396703977059, -1.8617849632523202`}, \
{-0.6680024210723077, -1.8589927520702059`}, {-0.7600419112462998, \
-1.8464787735066688`}, {-0.7617479235626968, -1.8460493334110644`}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[
        0.3494718906249331, 0.5223089707763378, -0.47289708832540583`], 
        ArrowBox[{{-0.790193876834203, -1.8388888734454105`}, \
{-0.8512205403882069, -1.823527145995285}, {-0.8962988850338328, \
-1.8078099869952624`}, {-0.94093623797548, -1.789090743491613}, \
{-0.9850573403978342, -1.7672385247287814`}, {-1.0285869334855804`, \
-1.7421224399512096`}, {-1.0714615468886506`, -1.7139598509162894`}, \
{-1.1136213374770576`, -1.6830752740007784`}, {-1.1549964872656004`, \
-1.6494985503781732`}, {-1.1733261083559543`, -1.6331057481661255`}}]}}, 
      {Arrowheads[{{0.024999999999999994`, 1.}}], 
       {LABColor[
        0.37796646132122486`, 0.5222580911862882, -0.4047966178453583], 
        ArrowBox[{{-1.1951908972724101`, -1.6135513253906182`}, \
{-1.1955171782690748`, -1.6132595212219718`}, {-1.235113592502283, \
-1.574388027705669}, {-1.2737159119800263`, -1.5329139110027579`}, \
{-1.3112543187171013`, -1.488867012286737}, {-1.3476589947283069`, \
-1.442277172731103}, {-1.3828990569358173`, -1.3934549037026713`}, \
{-1.416955602233304, -1.342797076627744}, {-1.4497767825928194`, \
-1.290463072769038}, {-1.463616828126649, -1.2668283202449875`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[
        0.40429996218632985`, 0.5223438049666088, -0.3377666122083592], 
        ArrowBox[{{-1.4784394608048734`, -1.241515596074506}, \
{-1.4813107499864147`, -1.2366122733892708`}, {-1.5115056563861364`, \
-1.181404059751166}, {-1.5403096537640333`, -1.1249978131174443`}, \
{-1.567670894092155, -1.0675529147508267`}, {-1.5935375293425487`, \
-1.0092287459140374`}, {-1.6179362242185493`, -0.9502609695469811}, \
{-1.6409178011869638`, -0.8909087198748505}, {-1.659009756845516, \
-0.8409184058466288}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.403305978231938, 0.5222912578420104, -0.3418178128493987], 
        ArrowBox[{{-1.6686002874198287`, -0.8131988300908828}, \
{-1.6825671558700588`, -0.771829153377993}, {-1.7012037108192535`, \
-0.7124910129345731}, {-1.7183607023298875`, -0.6535467519487013}, \
{-1.7340225190192198`, -0.5951909586110268}, {-1.7481735495045083`, \
-0.537618221112199}, {-1.7608682598812841`, -0.4808509040963107}, \
{-1.7721826785460866`, -0.42485838034696854`}, {-1.778891147790589, \
-0.3877104016247512}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.3757248965245657, 0.5222620936995789, -0.41015383550240003`], 
        ArrowBox[{{-1.783875194598551, -0.3588051245370897}, \
{-1.7907375690148448`, -0.315658114247651}, {-1.7980115049563385`, \
-0.26268057269753753`}, {-1.8039720774609334`, -0.2109382260136907}, \
{-1.8086360185973982`, -0.16054617459604545`}, {-1.8120200604345011`, \
-0.11161951884453283`}, {-1.8148552042019426`, -0.03846207656530851}, \
{-1.8149215050508114`, 0.03166793930205876}, {-1.813091683098948, 
         0.07939106908751387}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.33216460037789713`, 0.5223398744822411, -0.5142605684465952], 
        ArrowBox[{{-1.8115609753905106`, 
         0.10867892922021599`}, {-1.8072706384832022`, 
         0.16273082557331028`}, {-1.799792659706056, 
         0.223769009861165}, {-1.7900114486570842`, 
         0.282083393789638}, {-1.778038620511004, 
         0.3377847582285507}, {-1.763985790442533, 
         0.39098388404772433`}, {-1.747936701263157, 
         0.44185858770486547`}, {-1.7299591687196598`, 
         0.4906249917079045}, {-1.7113145336171067`, 
         0.5346783286049974}}]}}, 
      {Arrowheads[{{0.023652593167479977`, 1.}}], 
       {LABColor[0.2987903353224436, 0.5223994672005285, -0.5940232424109365],
         ArrowBox[{{-1.6987740142161563`, 
         0.5611926826454237}, {-1.688569671850945, 
         0.5825058605322996}, {-1.665302342095701, 
         0.6259606086447634}, {-1.6403782297817968`, 
         0.6679897970572279}, {-1.6138586469851646`, 
         0.7087649257726778}, {-1.5858049057817363`, 
         0.7484574947940981}, {-1.5562275265812724`, 
         0.7871938121290715}, {-1.5251214015885566`, 
         0.8250862805558274}, {-1.4925244005720564`, 
         0.8622855422333212}, {-1.4584743933002384`, 0.8989422393205072}}]}}}, 
     {GrayLevel[0.65], 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.37611721719681285`, 0.5222613931761289, -0.40921621048450313`], 
        ArrowBox[{{-2.2, 1.8083437024864542`}, {-2.1791878704084024`, 
         1.793598570277247}, {-2.1215367483568315`, 
         1.7585426826195507`}, {-2.0647111404543743`, 
         1.729572457908536}, {-2.008711046701032, 
         1.7066878961442034`}, {-1.9535364670968036`, 
         1.6898889973265523`}, {-1.89886809928959, 
         1.6780900686509583`}, {-1.8443866409272913`, 
         1.6702054173127974`}, {-1.790440770473045, 
         1.6662605409712679`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.330104892957936, 0.5223435522730128, -0.5191831568879381], 
        ArrowBox[{{-1.761108383751733, 
         1.6662049941482342`}, {-1.7359844525374395`, 
         1.666178946648773}, {-1.687972111103067, 
         1.6678687523593985`}, {-1.639910693677268, 
         1.672075651408328}, {-1.5631630663034712`, 
         1.6877418620712625`}, {-1.4854785327843811`, 
         1.7084010250681563`}, {-1.4072211978577553`, 
         1.7313611301403316`}, {-1.333233845053216, 
         1.7570432859725431`}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[0.3494395649911234, 0.5223090284966316, -0.4729743448278627],
         ArrowBox[{{-1.3058714538719778`, 
         1.7676026256045339`}, {-1.2470695065385193`, 
         1.7908575750133418`}, {-1.1647747241043713`, 
         1.8269350793681167`}, {-1.0807537279064774`, 
         1.866967902242046}, {-1.0380283303059494`, 
         1.888397159304188}, {-0.994826333037701, 
         1.910768313449781}, {-0.9330371571301885, 
         1.9438478159284203`}, {-0.9091376042396164, 1.9570523892345282`}}]}}, 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[
        0.3801749932662714, 0.5222541476560918, -0.39951834690276583`], 
        ArrowBox[{{-0.883462454464819, 
         1.97123798504458}, {-0.8702232702870291, 
         1.9785526732644443`}, {-0.8063189040806025, 
         2.0147801044745823`}, {-0.7412582900832888, 
         2.052427328575564}, {-0.674975659867468, 
         2.0913915645841183`}, {-0.60740524500552, 
         2.131570031516974}, {-0.5384812770698248, 
         2.1728599483908604`}, {-0.5038567618438177, 
         2.193680243274523}}]}}}, 
     {GrayLevel[0.65], 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3733846143348548, 0.5222662724815539, -0.4157469823469016],
         ArrowBox[{{2.2, -1.7932341114552641`}, {
         2.1495550090920554`, -1.7602751372127492`}, {
         2.0944258009827745`, -1.7296884170551743`}, {
         2.040149860125383, -1.7050919476196127`}, {
         1.9867271865198792`, -1.6864857289060642`}, {
         1.9338532089253397`, -1.6727966225189943`}, {
         1.8812233561008396`, -1.6629514900628681`}, {
         1.8288376280463798`, -1.6569503315376868`}, {
         1.7892226680637169`, -1.6553113949497609`}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[0.3291186600326297, 0.5223453132796082, -0.5215401998113823],
         ArrowBox[{{1.7599002222094897`, -1.6547172075394236`}, {
         1.7287889927300204`, -1.6545765433337223`}, {
         1.6808878002499448`, -1.6570010051387611`}, {
         1.6057660363461272`, -1.6699213577635628`}, {
         1.5298411509174217`, -1.6878328485227463`}, {
         1.4534120919856492`, -1.708036906163724}, {
         1.3759746860477426`, -1.7328260975682888`}, {
         1.3325313498485742`, -1.7489220743127563`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3488899171817991, 0.5223100099416763, -0.4742879731261188],
         ArrowBox[{{1.3050252598623602`, -1.7591132203775885`}, {
         1.297331669141089, -1.7619637348215829`}, {
         1.2172857773030743`, -1.7952131300087473`}, {
         1.1356597531058026`, -1.8323954548026693`}, {
         1.0522763391213767`, -1.8733318808762354`}, {
         0.996167239389808, -1.9024030117123392`}, {
         0.9392192360646772, -1.9329574754299306`}, {
         0.9088373215663488, -1.9497472755019423`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.37961916054774364`, 0.5222551401448419, -0.4008467567968257], 
        ArrowBox[{{0.8831634964134486, -1.963935268540521}, {
         0.8813771979307554, -1.964922421420403}, {
         0.8225859937728134, -1.9982249990751504`}, {
         0.7627904923756228, -2.0327923577855675`}, {
         0.7019355625239547, -2.068551646943048}, {
         0.63996607300258, -2.105430015938985}, {
         0.5768268925962701, -2.1433546141647732`}, {
         0.5125413832141907, -2.1820303301958757`}, {
         0.5039996214233977, -2.1871335364952866`}}]}}}, 
     {GrayLevel[0.65], 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.5504573324929128, 0.5318668891683109, 0.3133438652623571], 
        ArrowBox[{{-1.6209048383323523`, -2.2}, {-1.6509501553532406`, \
-2.1529173249367957`}, {-1.6910148634369273`, -2.0857508957805906`}, \
{-1.7298312350988838`, -2.016157865274555}, {-1.7731172571676108`, \
-1.9359078629925672`}, {-1.8146804567638546`, -1.8532928625087446`}, \
{-1.8318808841498218`, -1.814328037085658}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[
        0.5803343796781635, 0.5338137299255107, 0.44644685541694246`], 
        ArrowBox[{{-1.843609399268756, -1.7874422957011036`}, \
{-1.8654144314530492`, -1.7358410515661338`}, {-1.8894799852517483`, \
-1.6766296367266351`}, {-1.9126779166865158`, -1.617094548975008}, \
{-1.9424884867928198`, -1.54041107216528}, {-1.9708558359005146`, \
-1.4637809680403149`}, {-1.997779964009602, -1.3872042366001134`}, \
{-2.0012590809208333`, -1.3767558757785794`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.5716885135518884, 0.5332503501359498, 0.407929306251255], 
        ArrowBox[{{-2.010526296758178, -1.3489249010369626`}, \
{-2.0232608711200806`, -1.3106808778446752`}, {-2.0473152590310706`, \
-1.2346341931629645`}, {-2.069959829541692, -1.1594874839439457`}, \
{-2.091194582651945, -1.0852407501876187`}, {-2.1110195183618297`, \
-1.0118939918939833`}, {-2.129478991336575, -0.9397379399775618}, \
{-2.132722815563251, -0.9263611663819736}}]}}, 
      {Arrowheads[{{0.016565962721232383`, 1.}}], 
       {LABColor[
        0.5305192676218233, 0.5305676899177941, 0.22451928913261743`], 
        ArrowBox[{{-2.139635702091875, -0.8978540366722534}, \
{-2.1466173562414106`, -0.8690633253528762}, {-2.162434613076337, \
-0.7998701480199266}, {-2.176930761841354, -0.7321584079787129}, \
{-2.186482283907514, -0.6847353817974899}, {-2.1953954814160745`, \
-0.6380999348761577}, {-2.2, -0.6126564423269429}}]}}}, 
     {GrayLevel[0.65], 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.2912470902695724, 0.5224129363354042, -0.6120511868401421],
         ArrowBox[{{-2.2, 1.2017458857492378`}, {-2.149771720402455, 
         1.19714003128657}, {-2.093349155915064, 
         1.1981229259271164`}, {-2.0366269763522205`, 
         1.202536043428483}, {-1.9796051817139253`, 
         1.2103793837906702`}, {-1.9222837720001775`, 
         1.2216529470136774`}, {-1.8855656506860214`, 
         1.2299513571473526`}, {-1.8485979508805195`, 
         1.2393940806800585`}, {-1.7702783735054028`, 
         1.2653648147707026`}, {-1.7684568408144243`, 
         1.2660496893697837`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[
        0.30336814821380936`, 0.5223912931084982, -0.5830825191765203], 
        ArrowBox[{{-1.7410001146052865`, 
         1.2763730914408493`}, {-1.690096948996196, 
         1.2955120755014398`}, {-1.6088577692708483`, 
         1.3277206840642166`}, {-1.5255030791132196`, 
         1.3640519882910733`}, {-1.4397762820833195`, 
         1.404492701300318}, {-1.3959271198262713`, 
         1.4262491035177012`}, {-1.3514207817411579`, 
         1.4490295362102588`}, {-1.3394187698315718`, 
         1.4553488483097352`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[
        0.32981725004518037`, 0.522344065885014, -0.5198706077675355], 
        ArrowBox[{{-1.3134633649087692`, 
         1.4690149157666814`}, {-1.306193202782675, 
         1.4728428092760928`}, {-1.2601803179055189`, 
         1.4976977326133056`}, {-1.2133821271096894`, 
         1.5235943062218977`}, {-1.1657986303951864`, 
         1.5505325301018686`}, {-1.0994847678067705`, 
         1.5889459369668777`}, {-1.0315670238884742`, 
         1.6291442132384213`}, {-0.961952418204697, 
         1.6711044944501472`}, {-0.9325423131145556, 1.689103437404276}}]}}, 
      {Arrowheads[{{0.024999999999999994`, 1.}}], 
       {LABColor[
        0.35885543385064117`, 0.5222922156254136, -0.45047093159359913`], 
        ArrowBox[{{-0.9075225976639306, 
         1.7044154680734656`}, {-0.8905479703198388, 
         1.7148039161357038`}, {-0.8172606997982992, 
         1.760219613828739}, {-0.7419976262044784, 
         1.8073287230629005`}, {-0.6646657691027755, 
         1.8561083793718363`}, {-0.5851721480575907, 
         1.9065357182891942`}, {-0.5348747223761117, 1.938359137023356}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.3846698521056175, 0.5222461216858986, -0.3887758793301379],
         ArrowBox[{{-0.510030191200448, 
         1.9539536391224372`}, {-0.46765462473143077`, 
         1.9804524863541193`}, {-0.4072636098305995, 
         2.017656239771285}, {-0.34576800537798014`, 
         2.0548583900485022`}, {-0.28315549582860733`, 
         2.0919350501384555`}, {-0.2194137656375158, 
         2.128762332993832}, {-0.15453049925974013`, 
         2.165216351567318}, {-0.13133382411236838`, 2.177846820501481}}]}}, 
      {Arrowheads[{{0.0009654895930324914, 1.}}], 
       {LABColor[
        0.40023202388598134`, 0.522218334044214, -0.35158313720288004`], 
        ArrowBox[{{-0.1038566108218499, 
         2.1990660700486555`}, {-0.09236329647934798, 
         2.1990660700486555`}}]}}}, 
     {GrayLevel[0.65], 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.5780303375248163, 0.5336635945007269, 0.4361822901755648], 
        ArrowBox[{{1.693417588911083, 2.2}, {1.7135633302643969`, 
         2.1658536034169886`}, {1.7524603428275554`, 2.0956047634578}, {
         1.7900933455765706`, 2.023178750559454}, {1.8323785005853759`, 
         1.9391654425140419`}, {1.8729078052593235`, 1.853098828009281}, {
         1.8918235898484053`, 1.807627521477748}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.6019808547214992, 0.5352242521770161, 0.5428824414609666], 
        ArrowBox[{{1.9028951267305343`, 1.780464660061378}, {
         1.9211955763495068`, 1.7346247893059892`}, {1.9440953436330484`, 
         1.6751193762570056`}, {1.9661656987422238`, 1.6154350340764638`}, {
         1.99526253802101, 1.5365354667964415`}, {2.0229133921868585`, 
         1.457906979948948}, {2.0491182612397707`, 1.3795495735339842`}, {
         2.053102580103745, 1.36698354582512}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.5875524255414789, 0.5342840704443347, 0.4786034297103523], 
        ArrowBox[{{2.0619683365611827`, 1.3390220936653725`}, {
         2.0738771451797455`, 1.3014632475515493`}, {2.0972139142286412`, 
         1.2240560793052606`}, {2.119152438608315, 1.1477361460987352`}, {
         2.1396927183187673`, 1.0725034479319728`}, {2.1588347533599976`, 
         0.9983579848049737}, {2.1766279554016914`, 0.9255683209602136}, {
         2.1790762741586205`, 0.9150046216689436}}]}}, 
      {Arrowheads[{{0.00369871893401311, 1.}}], 
       {LABColor[
        0.5409314327469195, 0.5312461648457395, 0.27090574437836046`], 
        ArrowBox[{{2.185699225357741, 0.8864287408975918}, {2.193121736113534,
          0.8544030206401683}, {2.2, 0.8229228573660726}}]}}}, 
     {GrayLevel[0.65], 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[0.2972768788821762, 0.5224021696115969, -0.5976403207916501],
         ArrowBox[{{2.2, -1.2604517123197057`}, {
         2.1754541418827036`, -1.2559234855916859`}, {
         2.12557992209903, -1.2509035443071657`}, {
         2.0757078312486, -1.2490627656014355`}, {
         2.0258378693314136`, -1.2504011494744958`}, {
         1.9759700363474708`, -1.2549186959263463`}, {
         1.9381553214012843`, -1.2595498220558636`}, {
         1.9002008045276706`, -1.2656470952246184`}, {
         1.8258210201257055`, -1.284539074893859}, {
         1.766763019572328, -1.3026337340385041`}}]}}, 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[
        0.30531327338844544`, 0.5223878199145155, -0.5784337760546406], 
        ArrowBox[{{1.738794297152834, -1.311471090180837}, {
         1.6735965618346584`, -1.3329925241169265`}, {
         1.5955168807327238`, -1.3623563297611332`}, {
         1.5156281181707736`, -1.3957259801052742`}, {
         1.4336951542539222`, -1.4329976550231462`}, {
         1.3494924510732562`, -1.4741541370006024`}, {
         1.3338161482486635`, -1.4821780735089929`}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[
        0.33164827123410356`, 0.5223407964338453, -0.5154945669507199], 
        ArrowBox[{{1.3077045681623658`, -1.495543320601408}, {
         1.3064553705431503`, -1.4961827240688692`}, {
         1.2627944707198626`, -1.5191782085234955`}, {
         1.2102595456377607`, -1.5475804470073027`}, {
         1.1565985538663628`, -1.5772872029892455`}, {
         1.1018114954056686`, -1.6082984764693238`}, {
         1.045898370255678, -1.6406142674475372`}, {
         0.9888591784163914, -1.6742345759238872`}, {
         0.9306939198878088, -1.709159401898372}, {
         0.9250587380157664, -1.7126027207788774`}}]}}, 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[
        0.36082977701191987`, 0.5222886902601174, -0.44575235907656735`], 
        ArrowBox[{{0.9000283403844386, -1.727897283174123}, {
         0.87140259466993, -1.7453887453709926`}, {
         0.8109852027627549, -1.782922606341749}, {
         0.7619013207855778, -1.8136204606661195`}, {
         0.7119302923096864, -1.844796617943238}, {
         0.661072117335081, -1.876451078173105}, {
         0.6093267958617614, -1.9085838413557197`}, {
         0.5566943278897278, -1.9411949074910824`}, {
         0.5262416382514187, -1.9600227764346914`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.3865903126863638, 0.5222426925327418, -0.38418608324297554`], 
        ArrowBox[{{0.5012907196453862, -1.9754466557392858`}, {
         0.448767952449518, -2.007851948620053}, {
         0.393474044981342, -2.04189792361366}, {
         0.35210074541185105`, -2.067079856157495}, {
         0.31023660385514257`, -2.092028658723431}, {
         0.2678816203112164, -2.1167443313114678`}, {
         0.22503579478007207`, -2.141226873921605}, {
         0.18169912726171009`, -2.1654762865538433`}, {
         0.13787161775613074`, -2.189492569208182}, {
         0.12187107326390781`, -2.198079156473878}}]}}}, 
     {GrayLevel[0.65], 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.20633327313461486`, 0.5225645575074309, -0.8149905804102962], 
        ArrowBox[{{0.11191616762012817`, 0.208024054497737}, {
         0.16355799428907, 0.1979670347662342}, {0.23810447417006314`, 
         0.1471535454264029}, {0.26489965276090127`, 0.10599751763568933`}, {
         0.281955636709461, 0.05554734268337619}, {
         0.2873701624653733, -0.0026475280604818414`}, {
         0.2798415283861775, -0.06658088198418097}, {
         0.2582888832675324, -0.13394194679744595`}, {
         0.25770236817927855`, -0.1350557902192165}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.2191629470746552, 0.522541648983646, -0.7843283591494559], 
        ArrowBox[{{0.24403533263371963`, -0.16101068539991165`}, {
         0.22239079884467583`, -0.20211554708384832`}, {
         0.18724777754914598`, -0.2507353055876221}, {
         0.14474998806413564`, -0.2971693581550447}, {
         0.09528522770765765, -0.34017624460068074`}, {
         0.039533816319696366`, -0.3783902067105503}, \
{-0.021695904761845086`, -0.41034245391876945`}, {-0.08587645338344753, \
-0.4340090502240914}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.22713333316872178`, 0.5225274171504548, -0.7652795709189247], 
        ArrowBox[{{-0.11449928009664556`, -0.44036097017774695`}, \
{-0.15585817778414268`, -0.4492292557685841}, {-0.22585803885666786`, \
-0.4530561038652782}, {-0.3164837847456868, -0.4391165275960515}, \
{-0.4019310276219771, -0.4028093105711032}, {-0.4412096701063006, \
-0.3760873354402921}, {-0.47739003844858346`, -0.3435568485186212}, \
{-0.5079987268055439, -0.30801798709348355`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.23185269537576653`, 0.5225189903095331, -0.7540005525371062], 
        ArrowBox[{{-0.5246104602444317, -0.28386640998002344`}, \
{-0.5386603064782034, -0.2628685617599591}, {-0.5626873301103418, \
-0.2155262752474748}, {-0.5816223698426713, -0.1640733819164429}, \
{-0.5952145776469296, -0.10905975486612549`}, {-0.6032131054948539, \
-0.051035267195784446`}, {-0.6051787739388168, 
         0.009450531588897707}, {-0.6008230686666829, 
         0.07184783310737447}, {-0.590121139353427, 
         0.1356063759480883}, {-0.58913440568358, 0.13933816933026966`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[
        0.24462745958089396`, 0.5224961798319631, -0.723469562549106], 
        ArrowBox[{{-0.5816359932996938, 
         0.16769691147736826`}, {-0.5730481356740239, 
         0.20017589869948071`}, {-0.5456635523206605, 
         0.2740450586535052}, {-0.5097553298847757, 
         0.34780888409744737`}, {-0.46539958072243753`, 
         0.4209038580721286}, {-0.41267241718971426`, 
         0.49276646361837034`}, {-0.3832244136059031, 
         0.5280717312199424}, {-0.3664481108000519, 0.5465764383688798}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.25856274282526254`, 0.5224712971444414, -0.6901649953271921], 
        ArrowBox[{{-0.34652871511916716`, 
         0.568103231656811}, {-0.3183789970891609, 
         0.5967746080364539}, {-0.28298158415623, 
         0.630172217251393}, {-0.23929886811165696`, 
         0.6678125739705936}, {-0.19314758188768583`, 
         0.7040685124155734}, {-0.12515518450734003`, 
         0.7521218719681705}, {-0.05286198213174399, 0.7963274218504641}, {
         0.00642354537384595, 0.8271196340322944}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.26713413826224575`, 0.5224559921556198, -0.669679827533278], 
        ArrowBox[{{0.032786421654166335`, 0.8399371327728197}, {
         0.10331854963656892`, 0.8699125886734191}, {0.18672682260449874`, 
         0.896659753675671}, {0.27226341842854657`, 0.9150932661872171}, {
         0.3590320229895377, 0.9239757988564766}, {0.44613632216829757`, 
         0.9220700243318691}, {0.45988950763495406`, 0.919902109221938}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.2674308957260802, 0.5224554622687768, -0.6689705933735148],
         ArrowBox[{{0.4888650685605586, 0.9153346905317997}, {
         0.5324727345785483, 0.9084608126001434}, {0.6169376788340122, 
         0.8822330336480491}, {0.6428429235363652, 0.8721421855989089}, {
         0.6684519415785675, 0.8607810864961131}, {0.7087520896710661, 
         0.8366557835017212}, {0.7477296440316838, 0.8092175745660466}, {
         0.7859699502652775, 0.7801864271468739}, {0.822735760244823, 
         0.7479694027607048}, {0.857880127981784, 0.7127147341433109}, {
         0.8646506348068762, 0.7049769910548811}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[0.2785308414100496, 0.5224356423286208, -0.6424423283423221],
         ArrowBox[{{0.8839667402761444, 0.6829013820271657}, {
         0.8912561074876244, 0.6745706540304638}, {0.9227348849607787, 
         0.633744829643724}, {0.9521876465996824, 0.5904449282046522}, {
         0.9840449231218499, 0.5368159834921058}, {1.0128922524719535`, 
         0.4804992792293482}, {1.0385139338206064`, 0.4219509436563525}, {
         1.0606942663384233`, 0.36162710501309203`}, {1.0793780309114949`, 
         0.29991779502676386`}, {1.080958019459043, 0.29340606772287314`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.28568575790945483`, 0.5224228665889121, -0.6253424679847711], 
        ArrowBox[{{1.087874692293903, 0.264899856446382}, {
         1.0946017122633278`, 0.2371752759886931}, {1.106287165320659, 
         0.17379902198504488`}, {1.1143562450102258`, 0.11018850710198433`}, {
         1.118816496210417, 0.04659896938847201}, {
         1.1197244294862798`, -0.01679677369921989}, {
         1.1170753482945381`, -0.07972287896395872}, {
         1.1108645560919168`, -0.14190350320861184`}, {
         1.1061543107176546`, -0.17182126914526072`}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[
        0.28189153111562143`, 0.5224296415182796, -0.6344104631661018], 
        ArrowBox[{{1.1015922724123361`, -0.20079767766918327`}, {
         1.1011813720677162`, -0.2034075672517516}, {
         1.0879962561431096`, -0.2638681244516808}, {
         1.071446753194056, -0.3235309434899499}, {
         1.0515573943661636`, -0.3822273616924433}, {
         1.0210526593193476`, -0.45640400367782974`}, {
         0.9851566337055532, -0.5290430424798255}, {
         0.9440018694902549, -0.6003409163213473}, {
         0.9395867031030016, -0.6070534857349459}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.2869543349342964, 0.5224206014318175, -0.6223106380564426],
         ArrowBox[{{0.9234671613631666, -0.6315607258599001}, {
         0.8977521058399573, -0.670656442767065}, {
         0.8464800931544558, -0.7401280851767982}, {
         0.7901751347932395, -0.8086975782330855}, {
         0.7288954299488463, -0.8765871635980584}, {
         0.6626941647281062, -0.944068059743275}, {
         0.6395270752445231, -0.9663594417929535}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.30329223912590864`, 0.5223914286509254, -0.5832639377581458], 
        ArrowBox[{{0.6182157476775144, -0.9865136276788027}, {
         0.5916215948259309, -1.0111232589422243`}, {
         0.5542735700569132, -1.0443915817412472`}, {
         0.5157249169652031, -1.077468342270789}, {
         0.47598069078046656`, -1.1103355279170277`}, {
         0.4350456719825461, -1.1429719426165914`}, {
         0.39292436630146066`, -1.1753532068565589`}, {
         0.34962100471740554`, -1.2074517576744592`}, {
         0.3051606049825221, -1.2391576840843748`}, {
         0.2742950134505061, -1.2602585308142507`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3187136019049632, 0.5223638924362349, -0.5464077214673078],
         ArrowBox[{{0.24994728177607828`, -1.2766153242604397`}, {
         0.21289355124814607`, -1.3008377631046464`}, {
         0.16512841703449854`, -1.3306030212298199`}, {
         0.11630568162025383`, -1.3594962326578646`}, {
         0.06644979065805304, -1.3873885559706405`}, {
         0.01558666410442465, -1.4141413920797887`}, {-0.036256303780214785`, \
-1.4396063842267306`}, {-0.08900576528760712, -1.463565798663325}, \
{-0.13743762412772156`, -1.4836381054089873`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.32410463390415095`, 0.5223542662691666, -0.5335234489007638], 
        ArrowBox[{{-0.1648542964257803, -1.49405893922567}, \
{-0.19686815417914566`, -1.5059741110768812`}, {-0.2518420975204426, \
-1.5239589701382823`}, {-0.3074099373074791, -1.5394637572331207`}, \
{-0.36348926133476167`, -1.552219681014709}, {-0.41999248932316896`, \
-1.561943241380798}, {-0.4768268729199519, -1.568336229473575}, \
{-0.531702619430777, -1.5711820758116066`}, {-0.5866210022912797, \
-1.5706863318671769`}, {-0.5949990464097259, -1.5700692875797877`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3223424227440752, 0.5223574128539094, -0.53773503750006], 
        ArrowBox[{{-0.6242531448707261, -1.5679147185559348`}, \
{-0.6414599320057319, -1.566647435935329}, {-0.6960901615367799, \
-1.5588620257362982`}, {-0.7503752863054453, -1.5471249384155117`}, \
{-0.8041717441911238, -1.5312292105435896`}, {-0.8573288155315865, \
-1.5109660781163432`}, {-0.9096886231229788, -1.4861249765547768`}, \
{-0.9611279621601492, -1.4568479959752128`}, {-1.0115367339352357`, \
-1.4234471343545194`}, {-1.0285906467389203`, -1.410470621343878}}]}}, 
      {Arrowheads[{{0.024999999999999994`, 1.}}], 
       {LABColor[
        0.34067358282109306`, 0.5223246809373702, -0.4939245643051635], 
        ArrowBox[{{-1.0519344868955662`, -1.3927080322537309`}, \
{-1.0607685894028795`, -1.3859860648411426`}, {-1.1086734957427702`, \
-1.3445560957404936`}, {-1.1550977363596422`, -1.2992761705149518`}, \
{-1.1998839108832755`, -1.2502928677838638`}, {-1.2428709351684957`, \
-1.1977804013235438`}, {-1.2838940412951743`, -1.1419406200672726`}, \
{-1.3228939423343302`, -1.083091980187207}, {-1.3365988096718209`, \
-1.0603034411357517`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.36335623361392144`, 0.5222841790471724, -0.4397142655366594], 
        ArrowBox[{{-1.3517164244516462`, -1.0351657768088247`}, \
{-1.3598605501676824`, -1.021623673674988}, {-1.394704168618306, \
-0.9578906474423248}, {-1.4273404833204337`, -0.892282872242897}, \
{-1.4576905617194564`, -0.8252253426723545}, {-1.4856808530719223`, \
-0.757178077168317}, {-1.511243188445538, -0.6886361180103746}, \
{-1.5297375992203108`, -0.6337205777216404}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.36217105811170347`, 0.5222862952834313, -0.4425467703728518], 
        ArrowBox[{{-1.5387020738856634`, -0.6057936066486038}, \
{-1.5500145404195957`, -0.5688289767675627}, {-1.5643399043009854`, \
-0.5176738008480457}, {-1.5772979248300254`, -0.466786448562307}, \
{-1.5889002870432891`, -0.41628563194114837`}, {-1.5991633085472317`, \
-0.366286330045402}, {-1.6081079395181916`, -0.31689978896593096`}, \
{-1.6157597627023907`, -0.26823352182362814`}, {-1.6221489934159325`, \
-0.22039130876941965`}, {-1.6265066615922115`, -0.1754728288804916}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3377343117613888, 0.5223299292672418, -0.5009492618929148],
         ArrowBox[{{-1.6293390734412558`, -0.14627656392139388`}, \
{-1.631182215436854, -0.12727761005143445`}, {-1.6353452718659711`, \
-0.037736881674938494`}, {-1.6348812729792725`, 
         0.04802047346485504}, {-1.6300773802129396`, 
         0.12993204388192947`}, {-1.6211331594964529`, 
         0.20800708866485937`}, {-1.6081687075900541`, 
         0.2823312486394389}, {-1.6059945671568758`, 
         0.29150861810882145`}}]}}, 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[0.3064718062934994, 0.5223857512509832, -0.5756649455731532],
         ArrowBox[{{-1.599232591543886, 
         0.32005192083036677`}, {-1.5913888041014919`, 
         0.3531617118538107}, {-1.5710032733788877`, 
         0.4208810441846898}, {-1.5471708441084044`, 
         0.48574261376424743`}, {-1.5200026147711807`, 
         0.5478863055216598}, {-1.4896320558733984`, 
         0.6076559549224297}, {-1.4561810484683282`, 
         0.6654453454611899}, {-1.4210508678240223`, 
         0.7195539082604666}}]}}, 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[0.2974051396602854, 0.5224019405905712, -0.5973337845245669],
         ArrowBox[{{-1.4040081954807913`, 
         0.7434252991165292}, {-1.380413002447975, 
         0.7762031927363965}, {-1.3382203061028488`, 
         0.8297110406873274}, {-1.2932325903557922`, 
         0.8823937739820712}, {-1.256303667572838, 
         0.9229623895775874}, {-1.2176971843049027`, 
         0.9632212367701698}, {-1.177421958556874, 
         1.0032941353402707`}, {-1.1354868083336385`, 
         1.0433049050683456`}, {-1.1084107524215345`, 
         1.0681981688595041`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3133793583351308, 0.5223734172025124, -0.5591562727837177],
         ArrowBox[{{-1.0867422063934935`, 
         1.0879688137817218`}, {-1.0466720064810942`, 
         1.1236353371202346`}, {-0.9998099908615588, 
         1.164202639004957}, {-0.9513233227863638, 
         1.2052030911694702`}, {-0.9011764915435913, 
         1.246573872817262}, {-0.8493203468161528, 
         1.2881947352819831`}, {-0.7957432472011791, 
         1.330103356539334}, {-0.746981618574739, 1.3673373607970856`}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[0.3363015227109423, 0.5223324876395118, -0.5043735496098294],
         ArrowBox[{{-0.7235304740045402, 
         1.384957461217375}, {-0.6833796176971493, 
         1.4149345873347265`}, {-0.6245698050023548, 
         1.457932552824169}, {-0.5639924718085472, 
         1.5013689890090427`}, {-0.5016359767128598, 
         1.545281573865047}, {-0.4513430146007773, 
         1.5800080055739563`}, {-0.3999692077874667, 
         1.614709552213803}, {-0.36395598257933137`, 1.638424593991626}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.355888814310606, 0.522297512788429, -0.45756099055834054`],
         ArrowBox[{{-0.33938448802047055`, 
         1.6544450438136786`}, {-0.29569334395128366`, 
         1.6824372904325182`}, {-0.24196067326943277`, 
         1.715810620088212}, {-0.18718078146826217`, 
         1.74866993968849}, {-0.13139614990021817`, 
         1.7807213502716683`}, {-0.0746492599177509, 
         1.8116709528760624`}, {-0.016940111520858954`, 
         1.8415187475016723`}, {0.04173129529045763, 1.8702647341484984`}, {
         0.043275890891764195`, 1.870968266554307}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3645481937722461, 0.5222820506963065, -0.436865545742262], 
        ArrowBox[{{0.06997056822886794, 1.883127158210719}, {
         0.10126139649910908`, 1.8973795046981006`}, {0.16154662808800752`, 
         1.9223336510320392`}, {0.2225869900571515, 1.9451271731503141`}, {
         0.2843824824065395, 1.9657600710529244`}, {0.34675455017709766`, 
         1.9835824313250028`}, {0.40952463840975, 1.9979443405516808`}, {
         0.47269274710449655`, 2.0088457987329584`}, {0.4892810771481282, 
         2.0107876171803643`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.36060663001399934`, 0.5222890887089271, -0.44628566823593563`], 
        ArrowBox[{{0.518415477034797, 2.0141980698905066`}, {
         0.5362588762613387, 2.0162868058688357`}, {0.6258965633613806, 
         2.0204240807131137`}, {0.7155196050012664, 2.0160226102688106`}, {
         0.8046971515518121, 2.001909584220044}, {0.8929983533838382, 
         1.9769121922509292`}, {0.9489045496023604, 
         1.9537564680415145`}}]}}, 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[
        0.3714502107403424, 0.5222697265312017, -0.42037010147681114`], 
        ArrowBox[{{0.9760052524792882, 1.9425316585544485`}, {
         0.9799520547358629, 1.9408969369896847`}, {1.022767359651877, 
         1.9189478821922836`}, {1.0650640677707974`, 1.8943242141754428`}, {
         1.1067840043748005`, 1.8669906866079753`}, {1.1478689947460612`, 
         1.8369120531586924`}, {1.18826086416676, 1.804053067496403}, {
         1.2279014379190722`, 1.7683784832899199`}, {1.2667408755629461`, 
         1.7301097442850193`}, {1.3047319010514948`, 1.689547275789617}, {
         1.3193917767391175`, 1.6726404156191093`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.4089450585584402, 0.5226457013838751, -0.3170968435353899],
         ArrowBox[{{1.3386085092620483`, 1.650478248857112}, {
         1.3418201862566346`, 1.6467743038157394`}, {1.3779514030502826`, 
         1.6018740543754137`}, {1.41307122330436, 1.5549297534806625`}, {
         1.4471253188907833`, 1.506024627143512}, {1.4800593616814695`, 
         1.45524190137599}, {1.5118190235483389`, 1.402664802190118}, {
         1.5423995768236622`, 1.3485681128907865`}, {1.5718115555198187`, 
         1.2932855574883828`}, {1.5774254412638609`, 1.282083088030266}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.4335872396893932, 0.5242514290943338, -0.20731531217709825`], 
        ArrowBox[{{1.5905673939265235`, 1.255858414063622}, {
         1.6000235240288916`, 1.2369887730531721`}, {1.6270040467429612`, 
         1.1798493966554269`}, {1.6527216880541078`, 1.1220390653654195`}, {
         1.6771450123544145`, 1.0637294162534152`}, {1.7002425840359614`, 
         1.0050920863896862`}, {1.7219829674908294`, 0.9462987128445051}, {
         1.7423991310721911`, 0.8874876047903876}, {1.7551903659983157`, 
         0.8482676406708393}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.42511548849558917`, 0.5236993949389271, -0.24505717497730387`], 
        ArrowBox[{{1.764130044972503, 0.8203308394176457}, {
         1.7794154427813431`, 0.7703526034232235}, {1.7960121695035334`, 
         0.7123412200374073}, {1.8113323292003998`, 0.6549089214682576}, {
         1.8253742111691407`, 0.5982119626793931}, {1.8381361047069573`, 
         0.5424065986344254}, {1.8496162991110487`, 0.4876490842969734}, {
         1.8598613482957262`, 0.4339199971404041}, {1.8669181038925122`, 
         0.3928659214051009}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.3884901518123529, 0.5222393002010264, -0.37964557130843013`], 
        ArrowBox[{{1.8715709167989818`, 0.36390515967382175`}, {
         1.8768507899783617`, 0.32940184599788214`}, {1.8836363130249751`, 
         0.2787631281020113}, {1.889309791240891, 0.22930487938311578`}, {
         1.8938917899004366`, 0.18110227288623632`}, {1.8974028742779403`, 
         0.1342304816564137}, {1.8998636096477306`, 0.08876467873868304}, {
         1.9017295435290367`, 0.01652114609552223}, {
         1.9009988983173245`, -0.052428210671865164`}, {
         1.8999279721006286`, -0.07444711178916391}}]}}, 
      {Arrowheads[{{0.01718092036805365, 1.}}], 
       {LABColor[
        0.33856724246423087`, 0.5223284419953979, -0.4989586029233376], 
        ArrowBox[{{1.89850298062712, -0.10374581216554363`}, {
         1.8978045208888608`, -0.11810657359932038`}, {
         1.8922792581199126`, -0.18053712472268466`}, {
         1.884530502372158, -0.23988016260802694`}, {
         1.8746511005703648`, -0.29637433812440495`}, {
         1.8627520814354381`, -0.35016036176213844`}, {
         1.8489444736882819`, -0.40137894401155105`}}]}}}, 
     {GrayLevel[0.65], 
      {Arrowheads[{{0.024999999999999994`, 1.}}], 
       {LABColor[
        0.44412783567924546`, 0.5249382728025149, -0.16035669422661425`], 
        ArrowBox[{{2.184715759964494, -2.2}, {
         2.1595869811237565`, -2.176992696672724}, {
         2.108336533245663, -2.1355960445193958`}, {
         2.0581332541840287`, -2.100685175655028}, {
         2.008726064640225, -2.071144517115297}, {
         1.9598638853156234`, -2.0458584959358785`}, {
         1.9115467162102255`, -2.024827112116773}, {
         1.8637745573240296`, -2.00805036565798}, {
         1.8072830027913327`, -1.9906277344926668`}, {
         1.803504976292444, -1.989777615879093}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[0.3597764412835209, 0.5222905710847354, -0.4482697740410521],
         ArrowBox[{{1.7748871917504523`, -1.9833381397860723`}, {
         1.7512805747761027`, -1.9780262594963747`}, {
         1.6808066476284036`, -1.9737043885372625`}, {
         1.6102882775388356`, -1.975010056700703}, {
         1.5396587720582295`, -1.9788334352391685`}, {
         1.4688069957955476`, -1.9876922345276842`}, {
         1.3975638712113592`, -2.001231821742265}, {
         1.3393277663611223`, -2.0157217910589704`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.3673713741606263, 0.5222770096566529, -0.43011829852987443`], 
        ArrowBox[{{1.3110658316477348`, -2.0235430972848545`}, {
         1.2532506997873494`, -2.0410339462401437`}, {
         1.1798893636018835`, -2.0667854530483964`}, {
         1.0913578465756335`, -2.1023125970026837`}, {
         1.0465352322481205`, -2.1219346572315203`}, {
         1.0012961355797652`, -2.1427183304337545`}, {
         0.9556066227221293, -2.164605582213589}, {
         0.909432759826775, -2.1875383781752253`}, {
         0.9045178991474361, -2.190056252770004}}]}}}, 
     {GrayLevel[0.65], 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[
        0.44255080027776017`, 0.5248355104118367, -0.167382426261504], 
        ArrowBox[{{-2.178669280989235, 2.2}, {-2.169197510865918, 
         2.191110186752851}, {-2.1182973574183896`, 
         2.1488407841960804`}, {-2.0684512034408735`, 
         2.1130640067539854`}, {-2.0194109265100892`, 
         2.0826643371458173`}, {-1.9709284042027555`, 
         2.056526258090827}, {-1.9230036365188727`, 
         2.0346497695890142`}, {-1.87563662345844, 
         2.017034871640379}, {-1.8189105907996255`, 
         1.9983815166094137`}, {-1.795806810561965, 
         1.9927489589546306`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.35965777176741015`, 0.5222907829797099, -0.44855338771486103`], 
        ArrowBox[{{-1.7673081678306348`, 
         1.985801167441031}, {-1.762708092355499, 
         1.9846796977047572`}, {-1.6927244030012965`, 
         1.9792355619852477`}, {-1.6227358170137065`, 
         1.9794353835117235`}, {-1.5526566187433022`, 
         1.982157723950118}, {-1.4823961959072693`, 
         1.9899251022123505`}, {-1.411786889478632, 
         2.0023779868201403`}, {-1.3406610404304151`, 
         2.0191568462952065`}, {-1.33155378148008, 2.0218016188571823`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3681545688054465, 0.5222756111929636, -0.4282465060274294],
         ArrowBox[{{-1.3033842298517697`, 
         2.0299821326249363`}, {-1.268874504546601, 
         2.040003849928261}, {-1.1962831376111718`, 
         2.064661167010015}, {-1.1092425664818475`, 
         2.0986711187059988`}, {-1.0651976730088502`, 
         2.1175154908800744`}, {-1.0207589607454726`, 
         2.1375102639622674`}, {-0.9758933695530962, 
         2.1585985404706243`}, {-0.9305678392931034, 
         2.1807234229231915`}, {-0.8972606527649347, 
         2.1975190060250953`}}]}}}, 
     {GrayLevel[0.65], 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.28318458717049816`, 0.5224273326516999, -0.6313201296905515], 
        ArrowBox[{{-2.2, 0.6920306582845189}, {-2.1504743696500244`, 
         0.7505716456086895}, {-2.087669151733504, 
         0.8119041673607843}, {-2.0201225722515153`, 
         0.8689088152508744}, {-1.9940069615587752`, 
         0.8893930083113287}, {-1.967275812610158, 
         0.9095452786771422}, {-1.9210605297758798`, 
         0.9412368747208513}, {-1.873334883062482, 
         0.972730755078856}, {-1.8672361122169185`, 0.9766767699109319}}]}}, 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[0.2895341737102287, 0.5224159949002536, -0.6161449640311616],
         ArrowBox[{{-1.8426082629761595`, 
         0.9926114329515768}, {-1.8240377761422755`, 
         1.0046268731674826`}, {-1.7731895744578237`, 
         1.0367252445146224`}, {-1.723165871925447, 
         1.068528872025483}, {-1.6715739273450034`, 
         1.1010099593921892`}, {-1.6184137407164947`, 
         1.1341685066147413`}, {-1.5636853120399195`, 
         1.1680045136931392`}, {-1.5073016022060097`, 
         1.2028126006708602`}, {-1.4697066518590818`, 
         1.226145173370352}}]}}, 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[0.3126149039862013, 0.5223747822037366, -0.5609832770006788],
         ArrowBox[{{-1.4447893087661678`, 
         1.2416232170214618`}, {-1.3893072217383826`, 
         1.2762288744547057`}, {-1.3276965511046646`, 
         1.3148370612608296`}, {-1.2642038237093727`, 
         1.3549177197629076`}, {-1.198689303057535, 
         1.396676621714093}, {-1.1311529891491514`, 
         1.440113767114385}, {-1.0734089201485368`, 
         1.4775665707183163`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3399452669541705, 0.522325981410121, -0.4956651995203473], 
        ArrowBox[{{-1.0488171511963553`, 
         1.4935568272089692`}, {-1.0052616615791, 
         1.5219433853918956`}, {-0.947566843814164, 
         1.5595963593671125`}, {-0.8884622980305297, 
         1.5982073617483539`}, {-0.827899893569312, 
         1.6377956763945367`}, {-0.7658314997716261, 
         1.6783805871645783`}, {-0.7022089859785872, 
         1.719981377917396}, {-0.6804555375524027, 1.734201115577354}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.3665469262899428, 0.5222784817816456, -0.43208868399306477`], 
        ArrowBox[{{-0.6559025312616057, 
         1.7502508609500547`}, {-0.6369842215313104, 
         1.762617332511907}, {-0.5701090757709105, 
         1.80630773480703}, {-0.5161128071924339, 
         1.841347264856263}, {-0.46110803730170374`, 
         1.8765277051968146`}, {-0.4050860828146775, 
         1.9117508255808622`}, {-0.34803826044731273`, 
         1.9469183957605831`}, {-0.289955886915566, 
         1.9819321854881544`}, {-0.2840568729576359, 1.9854003987833997`}}]}}, 
      {Arrowheads[{{0.024698280701620466`, 1.}}], 
       {LABColor[
        0.3861969298543101, 0.5222433949527726, -0.38512624676490276`], 
        ArrowBox[{{-0.2587701074991003, 
         2.0002672726003614`}, {-0.23083027893539396`, 
         2.016693964515754}, {-0.17065275322275414`, 
         2.0511055025955596`}, {-0.10941462649360399`, 
         2.085068569479747}, {-0.04719696341436681, 2.118135928872215}, {
         0.015891556594544515`, 2.149752958000466}, {0.07981819468618785, 
         2.179660346902087}, {0.12694419160796105`, 2.2}}]}}}, 
     {GrayLevel[0.65], 
      {Arrowheads[{{0.024999999999999994`, 1.}}], 
       {LABColor[
        0.27702447753493925`, 0.5224383320752833, -0.6460424558789868], 
        ArrowBox[{{2.2, -0.7986896060766966}, {
         2.186447016283541, -0.8108266517375199}, {
         2.1493290642754417`, -0.8398154343137488}, {
         2.110961335605026, -0.8681021209360913}, {
         2.0713438302722933`, -0.8956867116045472}, {
         2.0304765482772438`, -0.9225692063191164}, {
         2.002617542179522, -0.9403831632809684}, {
         1.9742206888276945`, -0.9581114178014405}, {
         1.9232004787902874`, -0.9883633780616441}, {
         1.8706462636966563`, -1.018913677097253}, {
         1.8332635574836045`, -1.0405725751217296`}}]}}, 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[0.2921303586618053, 0.5224113591811392, -0.6099402235372614],
         ArrowBox[{{1.807864973524227, -1.0552475181344239`}, {
         1.7605995623330744`, -1.082408507418172}, {
         1.7041747633470403`, -1.1150439090290785`}, {
         1.6459768318158234`, -1.1488611294802862`}, {
         1.5860057677394246`, -1.1838601687717956`}, {
         1.5242615711178424`, -1.220041026903606}, {
         1.4605968385254415`, -1.257707054568536}, {
         1.4279979062070023`, -1.2772738255126268`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[
        0.31662918840155313`, 0.5223676143419158, -0.5513893561011526], 
        ArrowBox[{{1.4028473034431796`, -1.2923699053037794`}, {
         1.3948641665365848`, -1.2971616024594037`}, {
         1.327063555151273, -1.3384046705762094`}, {
         1.257195004369505, -1.3814362589189524`}, {
         1.1850551171764896`, -1.426445547932859}, {
         1.110440496557433, -1.4736217180631535`}, {
         1.0333511425123363`, -1.5229647693098374`}, {
         1.0296263621648682`, -1.5253761987607812`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.34441098658127184`, 0.5223180074705827, -0.4849923730763553], 
        ArrowBox[{{1.005002823333408, -1.541317521788059}, {
         0.9537870550411985, -1.5744747016729093`}, {
         0.89229578062614, -1.614507442505632}, {
         0.8292989349475792, -1.65549835156839}, {
         0.7647406576096754, -1.6974262029699156`}, {
         0.6985650882165874, -1.7402697708189412`}, {
         0.6358285326061487, -1.7807123179864255`}}]}}, 
      {Arrowheads[{{0.013103846825981525`, 1.}}], 
       {LABColor[0.3707281431931425, 0.5222710158470221, -0.4220958035485075],
         ArrowBox[{{0.6111431299564278, -1.7965576481736698`}, {
         0.5611386316814954, -1.8286191522944217`}, {
         0.4897760237478096, -1.8740825141383413`}, {
         0.41657268217557597`, -1.9203766888646905`}}]}}}, 
     {GrayLevel[0.65], 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[0.675571631276619, 0.4670392553116792, 0.7494695162651658], 
        ArrowBox[{{-1.94969654609393, -2.2}, {-1.967512412986799, \
-2.1600856471384295`}, {-1.9885641701423373`, -2.1114688595987596`}, \
{-2.009153703306634, -2.0623847701366844`}, {-2.0292677389895535`, \
-2.0130132873407414`}, {-2.052585264508157, -1.9499536735047838`}, \
{-2.0751327234043475`, -1.886735764361246}, {-2.0969159743824344`, \
-1.8236672881624996`}, {-2.108208984597424, -1.7898041898181893`}}]}}, 
      {Arrowheads[{{0.015449675110669771`, 1.}}], 
       {LABColor[0.6746035218984742, 0.4692468494152031, 0.7489294484738104], 
        ArrowBox[{{-2.11748892664757, -1.7619774559101222`}, \
{-2.117933064540981, -1.7606456688244214`}, {-2.1470690402066297`, \
-1.6729996486555003`}, {-2.174738586860377, -1.5860512621712595`}, {-2.2, \
-1.50290024442391}}]}}}, 
     {GrayLevel[0.65], 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.21488498349004215`, 0.522549287668073, -0.7945524588880974], 
        ArrowBox[{{-0.2712656629591647, 
         0.06607636358671883}, {-0.2519258036333293, 
         0.12719287433636}, {-0.22029806350259287`, 
         0.18916977042774547`}, {-0.1765392166761533, 
         0.24974044570233359`}, {-0.13484898603950723`, 
         0.2939592778020127}, {-0.08665793988464551, 
         0.3347523506361274}, {-0.03254595606097304, 0.37083800844745496`}, {
         0.005478520748724548, 0.3901334058486075}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.22576645713557378`, 0.5225298578291706, -0.7685463301179813], 
        ArrowBox[{{0.03192018303486363, 0.4027471889554573}, {
         0.08983597061001368, 0.42334999367103926`}, {0.15580137615299514`, 
         0.4369227622273857}, {0.22302995070083514`, 0.4400837009426959}, {
         0.28983050852763476`, 0.4317618080807341}, {0.36998269648497917`, 
         0.40355807682437544`}, {0.4427888289608902, 0.3555604330479802}, {
         0.44594876740822037`, 0.3525153749586185}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.22887019804360254`, 0.5225243158237582, -0.7611285585594002], 
        ArrowBox[{{0.4670709637403021, 0.3321610813930477}, {
         0.47521451888501537`, 0.32431358724627907`}, {0.5043365683288306, 
         0.28832789525238084`}, {0.5298245957323585, 0.2480222870825938}, {
         0.5513482195356217, 0.20381569275322634`}, {0.5684438365613657, 
         0.15610840111190688`}, {0.5807544209261573, 0.10531561394120743`}, {
         0.5881094570107516, 0.05187863065985214}, {
         0.5903384291959037, -0.0037612493134355864`}, {
         0.5871204913554335, -0.06117238824345955}, {
         0.5848114210130455, -0.07647246918441297}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.24168645970068064`, 0.5225014312487973, -0.7304983919236209], 
        ArrowBox[{{0.5804340386552265, -0.10547734753509562`}, {
         0.5782550617687086, -0.11991541904820156`}, {
         0.5637520214248063, -0.17953744828870508`}, {
         0.5436212513128036, -0.2395855825260137}, {
         0.5128123192776639, -0.30982706429534135`}, {
         0.4741458174729515, -0.37969038068954314`}, {
         0.4277226229301433, -0.44864702423851194`}, {
         0.38957268345543394`, -0.4962799177350055}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.25563665937197805`, 0.5224765219266689, -0.6971581752545699], 
        ArrowBox[{{0.37100536005932816`, -0.5189753920458358}, {
         0.3121446701923879, -0.5815987884025666}, {
         0.24346167893287687`, -0.6442819450419263}, {
         0.19997789536085686`, -0.6792545780713167}, {
         0.1542610361512684, -0.7127580599425445}, {
         0.08761859167223361, -0.756607084232768}, {
         0.02774422472703114, -0.7905247754828996}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.2650039704104501, 0.5224597957597585, -0.6747708125653012],
         ArrowBox[{{
         0.0016612101548634638`, -0.8039069372188951}, {-0.0568179809023849, \
-0.8317852655160718}, {-0.13374716127299494`, -0.8613281723811891}, \
{-0.217687702955263, -0.8847125314370695}, {-0.303443019007274, \
-0.8992068848065967}, {-0.39004889588718983`, -0.903605274380803}, \
{-0.4219302851012176, -0.9010606039981268}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[
        0.26546320153783304`, 0.5224589757617404, -0.6736732752074941], 
        ArrowBox[{{-0.4511706252810817, -0.8987267336910469}, \
{-0.4765411200531724, -0.8967017420507212}, {-0.5617586461415819, \
-0.877709129472273}, {-0.6445404287887792, -0.8458402783013806}, \
{-0.6694570690337625, -0.834138031668512}, {-0.6940290612719654, \
-0.8211988261009185}, {-0.7326079128102221, -0.7945493505890846}, \
{-0.7697377489314585, -0.764725998005544}, {-0.8060708273101813, \
-0.7333951758865195}, {-0.835048560106939, -0.704745929679526}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[0.2755903678940304, 0.522440892805585, -0.6494698997351097], 
        ArrowBox[{{-0.8549030628486526, -0.6831702179356746}, \
{-0.8738174826522865, -0.6618580224955406}, {-0.9049531496951505, \
-0.6219903073435303}, {-0.9340984950474307, -0.5796666349323446}, \
{-0.9611346224240893, -0.5351073709538312}, {-0.9907748504168399, \
-0.478845697013107}, {-1.0171558972374264`, -0.42009639826387124`}, \
{-1.0400679677725253`, -0.35935927042537263`}, {-1.05911654556005, \
-0.29773173501282313`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.28347662489966496`, 0.5224268111923631, -0.630622175439331], 
        ArrowBox[{{-1.0661313947884736`, -0.26925064192606946`}, \
{-1.0748140164570263`, -0.2338045124305614}, {-1.0866604478988067`, \
-0.16968767904326995`}, {-1.0947747806271697`, -0.10518380655107466`}, \
{-1.0990912340351333`, -0.04069309245006537}, {-1.0996289038376441`, 
         0.023560575323533724`}, {-1.0964553865050366`, 
         0.08745405715342161}, {-1.0895776525634098`, 
         0.15073827802339326`}, {-1.0867764373441209`, 
         0.16727432238814277`}}]}}, 
      {Arrowheads[{{0.025000000000000005`, 1.}}], 
       {LABColor[
        0.28061951326273676`, 0.5224319128192787, -0.6374505164858641], 
        ArrowBox[{{-1.081877153243996, 
         0.19619562007256053`}, {-1.0790026725388637`, 
         0.2131641629172437}, {-1.0648196149042308`, 
         0.2748424704827649}, {-1.0470137294846604`, 
         0.3354290401241464}, {-1.0257163484665943`, 
         0.3952192083790026}, {-1.0009599961419562`, 
         0.4540757656188994}, {-0.9601384003787317, 
         0.5356409495738879}, {-0.9203213407338207, 0.6025049347951844}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.2861200615637261, 0.5224220911011139, -0.6243045059286897],
         ArrowBox[{{-0.9045131821138419, 
         0.6271947655991756}, {-0.8584892325641835, 
         0.6939073287095757}, {-0.8290386597133887, 
         0.7327448944851629}, {-0.7980259770642006, 
         0.771443722365135}, {-0.7654480670998605, 
         0.8099649258368351}, {-0.7312877489927853, 
         0.8482158609995041}, {-0.6955533656282169, 
         0.8862147980786506}, {-0.6582526631340722, 
         0.9239822672010263}, {-0.6196829206421718, 0.9612606425700438}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.3024011068819807, 0.5223930198467968, -0.5853936952378517],
         ArrowBox[{{-0.5981537390070083, 
         0.9811838233339764}, {-0.5789803014820976, 
         0.99891622158869}, {-0.537021150793477, 
         1.0361350666137001`}, {-0.4935206979136996, 
         1.0732271632013823`}, {-0.44850132559265987`, 
         1.1100794102441642`}, {-0.40199335566100514`, 
         1.1465107578724778`}, {-0.3540142581673901, 
         1.1824432156987914`}, {-0.3045823696896721, 
         1.2177890174659753`}, {-0.25371689333491065`, 
         1.2524506210473039`}, {-0.2527876817668375, 1.253052631037481}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.31729645228579834`, 0.5223664228829096, -0.5497946317960991], 
        ArrowBox[{{-0.22816942312691535`, 
         1.269002107078478}, {-0.2014378987393675, 
         1.2863207084464534`}, {-0.14776632206850843`, 
         1.3192821857975028`}, {-0.09272396601700181, 
         1.3512081833649332`}, {-0.036392636165099246`, 
         1.3818249491054053`}, {0.021116348007871155`, 1.4107825367622053`}, {
         0.07973192993155276, 1.4378165819740154`}, {0.13937727552869586`, 
         1.462641558508131}, {0.16178263560605596`, 
         1.4708908652817576`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3219821785721569, 0.5223580561019154, -0.5385960014309373],
         ArrowBox[{{0.18930947852824598`, 1.4810258227647233`}, {
         0.19996977321515375`, 1.4849507782604587`}, {0.26142103389988425`, 
         1.504416391255518}, {0.3236368909849521, 1.5206893856464416`}, {
         0.3865174003655245, 1.5333995877149735`}, {0.4498815144879387, 
         1.5422790911521789`}, {0.5135059182159605, 1.5470986205088741`}, {
         0.5772139082293961, 1.5475218931862103`}, {0.6213314072591573, 
         1.544525243014344}}]}}, 
      {Arrowheads[{{0.02500000000000001, 1.}}], 
       {LABColor[
        0.32070226685517245`, 0.522360341498111, -0.5416549206555357], 
        ArrowBox[{{0.6505130144069092, 1.5417584274316363`}, {
         0.7041136690895352, 1.5337799796628744`}, {0.7668918685536527, 
         1.5188876698199711`}, {0.8289265115380101, 1.4981448560132458`}, {
         0.8899807299802153, 1.4711606971993159`}, {0.935470660085302, 
         1.4465871719904349`}, {0.9801857900841261, 1.418722797453464}, {
         1.0240231961169792`, 1.3876086050800684`}, {1.0482089635070597`, 
         1.3682489210663296`}}]}}, 
      {Arrowheads[{{0.024999999999999998`, 1.}}], 
       {LABColor[0.3402363802493965, 0.5223254616014432, -0.4949694546158462],
         ArrowBox[{{1.0709150485235954`, 1.349688761541535}, {
         1.1086406729262366`, 1.3158946534592533`}, {1.1492024280635214`, 
         1.2754767178637516`}, {1.1884498279565965`, 1.2321726117356615`}, {
         1.2262674808260507`, 1.1861231272352346`}, {1.2626013417750201`, 
         1.1375219354034238`}, {1.2974257985002362`, 1.0865986100881777`}, {
         1.3306683439595985`, 1.0335797766616692`}, {1.345192388900675, 
         1.0083553839344992`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3609736966123466, 0.5222884332788718, -0.4454083990778425],
         ArrowBox[{{1.3598293678327225`, 0.9829348549827398}, {
         1.3622592791575006`, 0.9787147470309217}, {1.3921317131448299`, 
         0.9222755196378093}, {1.4202215630189692`, 0.8645567794590572}, {
         1.4464675539237948`, 0.8058758980062414}, {1.470811219049678, 
         0.7465729333257886}, {1.493249604908091, 0.6868013371797156}, {
         1.5138080980239375`, 0.6266358603399893}, {1.5289679555225903`, 
         0.5776599311779119}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[
        0.357413866049472, 0.5222947896729236, -0.45391620004613586`], 
        ArrowBox[{{1.5371655962242805`, 0.5494983310519131}, {
         1.5492587428299385`, 0.5061005736947176}, {1.5641555253088777`, 
         0.446232682987484}, {1.577181676622819, 0.38697474978322005`}, {
         1.5883574745539357`, 0.3285909981718224}, {1.5977103818395124`, 
         0.27135095805948395`}, {1.6086070781433033`, 0.18688415111059892`}, {
         1.6145456061067531`, 0.11716363828812795`}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3320078041147352, 0.5223401544559131, -0.5146353029672396],
         ArrowBox[{{1.6160577070186182`, 0.08787250960047084}, {
         1.6182506875085418`, 0.03921821622135191}, {
         1.6184124050417703`, -0.031481291589332765`}, {
         1.6155803726811373`, -0.09968210849535244}, {
         1.6098294653481715`, -0.1653825623002519}, {
         1.6012660760777204`, -0.22864011655152863`}, {
         1.5899965979046313`, -0.28951223479668015`}, {
         1.5761199535336854`, -0.3481137648558576}, {
         1.5760022560693965`, -0.3485192315500349}}]}}, 
      {Arrowheads[{{0.025, 1.}}], 
       {LABColor[0.3030127621904639, 0.522391927681848, -0.5839318723971676], 
        ArrowBox[{{1.5678250201671307`, -0.37668973487253765`}, {
         1.559735065669663, -0.4045595545492159}, {
         1.5376471074266769`, -0.4679807796260494}, {
         1.5125021598227266`, -0.5291743144303931}, {
         1.4843002228578115`, -0.5881401589622476}, {
         1.4530412965319313`, -0.6448783132216142}, {
         1.4188989041483482`, -0.6999253190301594}, {
         1.3820465690103267`, -0.7538177182095507}, {
         1.371569920121131, -0.7677834291133041}}]}}, 
      {Arrowheads[{{0.02400895627634052, 1.}}], 
       {LABColor[
        0.29853489096064906`, 0.5223999233191536, -0.5946337405091564], 
        ArrowBox[{{1.3539673763553461`, -0.7912481877401911}, {
         1.342484291117865, -0.8065555107597883}, {
         1.300212070470963, -0.8581386966808737}, {
         1.2553007210991194`, -0.9090425169855455}, {
         1.2078210570318322`, -0.9597422126865436}, {
         1.1577730782691014`, -1.0102377837838683`}, {
         1.1051567848109276`, -1.0605292302775184`}, {
         1.0641779484687843`, -1.0979659918523603`}}]}}}}}, {{{}, {}, 
     TagBox[
      {GrayLevel[0], Thickness[Large], Opacity[1.], FaceForm[Opacity[0.3]], 
       {Arrowheads[{{0.05, 0.06}, {0.05, 0.11}, {0.05, 0.15}, {0.05, 0.575}}],
         ArrowBox[CompressedData["
1:eJw0V2VYFn/TRVTEQAUFMVBERVBAUSSUP0NKSigqXYKSUioh3Uh3d3eDUkN3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         "]]}},
      Annotation[#, "Charting`Private`Tag$1205916#1"]& ]}, {}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{{{-2, 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm]}, {0, 
       FormBox["0", TraditionalForm]}, {2, 
       FormBox["2", TraditionalForm]}}, None}, {{{-2, 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm]}, {0, 
       FormBox["0", TraditionalForm]}, {2, 
       FormBox["2", TraditionalForm]}}, None}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 30, FontFamily -> "GillSans", 
    GrayLevel[0.5]},
  Method->{
   "VectorLengthFunction" -> 
    Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
      System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
      System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
      System`VectorPlotsDump`imin = If[
         NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
         Min[System`VectorPlotsDump`m], 
         Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
         NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
         Max[System`VectorPlotsDump`m], 
         Max[System`VectorPlotsDump`m]]; Map[If[
         Or[# > System`VectorPlotsDump`imax, # < 
          System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
        System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
    "TransparentPolygonMesh" -> True},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.793932246436314*^9, 3.793932332129609*^9}, {
   3.7939325294638367`*^9, 3.7939326341204367`*^9}, 3.79393267026231*^9, 
   3.793932721020906*^9, {3.793933444135193*^9, 3.793933457999197*^9}, {
   3.793933587226247*^9, 3.793933616126677*^9}, {3.79393386257554*^9, 
   3.7939339146890717`*^9}, 3.8232291635334597`*^9},
 CellLabel->
  "Out[2823]=",ExpressionUUID->"a572239b-4a17-4b66-a45a-7000901346ca"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.793926011880187*^9, 3.793926015306142*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"c42d3c74-d339-4f94-990d-a8d1d4385f98"],

Cell[BoxData[
 RowBox[{"(*", " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<flowfield0.pdf\>\"", ",", "pall", ",", 
     RowBox[{"Background", "\[Rule]", "None"}]}], "]"}]}], " ", 
  "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.6419321822579203`*^9, 3.6419321835763474`*^9}, {
  3.6419323601697073`*^9, 3.641932365830881*^9}, {3.641932400162064*^9, 
  3.641932434218092*^9}, {3.6419324940337067`*^9, 3.641932516172907*^9}, {
  3.6419330679601583`*^9, 3.641933075438196*^9}, {3.6419344226681337`*^9, 
  3.641934425193945*^9}, {3.79392600047383*^9, 3.793926005411381*^9}},
 CellLabel->
  "In[2824]:=",ExpressionUUID->"404ee16a-8708-4fd1-b6b5-256343966c09"]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 190}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"aba6f640-ea5f-4080-9a03-4d2ee401d6bc"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 377, 8, 105, "Section",ExpressionUUID->"848c9a71-0f06-44a2-917c-1bfa81eaeada"],
Cell[960, 32, 268, 6, 30, "Input",ExpressionUUID->"6160fe2c-5dc3-4e21-b14d-0fe5ac63bff8"],
Cell[CellGroupData[{
Cell[1253, 42, 6487, 156, 314, "Input",ExpressionUUID->"662b1c21-6522-412a-8aa6-fbf5f4d08d61"],
Cell[7743, 200, 159775, 2768, 382, "Output",ExpressionUUID->"a572239b-4a17-4b66-a45a-7000901346ca"]
}, Open  ]],
Cell[167533, 2971, 181, 3, 51, "Text",ExpressionUUID->"c42d3c74-d339-4f94-990d-a8d1d4385f98"],
Cell[167717, 2976, 800, 15, 124, "Input",ExpressionUUID->"404ee16a-8708-4fd1-b6b5-256343966c09"]
}, Open  ]]
}
]
*)

