(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     22004,        541]
NotebookOptionsPosition[     20409,        504]
NotebookOutlinePosition[     20807,        520]
CellTagsIndexPosition[     20764,        517]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Stabilization in finite time (Sun et al., PRL 2017)", "Section",
 CellChangeTimes->{{3.733514824711623*^9, 
  3.733514839228281*^9}},ExpressionUUID->"1dc79fbc-9bc0-4e6a-92ff-\
6194512968cd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[2634]:=",ExpressionUUID->"a9feb711-9493-4d56-8516-b7ac1c08259d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmax", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"NDSolveValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], "-", 
          RowBox[{"k", " ", 
           RowBox[{"Sign", "[", 
            RowBox[{"x", "[", "t", "]"}], "]"}]}]}]}], "/.", 
        RowBox[{"{", 
         RowBox[{"k", "\[Rule]", "2"}], "}"}]}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "x", 
     ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"sol", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.733431355464891*^9, 3.7334313597661247`*^9}, {
  3.733431397729302*^9, 3.733431432740286*^9}, {3.733431712690823*^9, 
  3.733431743316825*^9}, {3.733431779304*^9, 3.7334319843048763`*^9}, {
  3.733433246231765*^9, 3.733433409525938*^9}, {3.7334522885830107`*^9, 
  3.7334523240591927`*^9}, {3.733484051821611*^9, 3.7334840519765244`*^9}, {
  3.7334840917076387`*^9, 3.733484098817679*^9}, {3.733516070682259*^9, 
  3.733516115907118*^9}, {3.793973398811887*^9, 3.7939733993437357`*^9}},
 CellLabel->
  "In[2635]:=",ExpressionUUID->"17e37cc5-b883-4285-8ac4-3e680aa48652"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1X0w1HkcB3CkkCKVzFZ0ikSkQSi6j6iE1HlKrjwkzymRQrlqsUhhjz25
kKdNeeYWU2c9SzjPm4cOy679/ayHtbk8DHm4bqbb72fmPe95zbz//yi6+lm7
iwgJCd34lv/a3J3bXTth9yN5n+T8+jofRE123x4h6ICXnmlO6CoftNOTU2mE
03C/yE91aZkPFu39f6QRbCG5hfV8dp4P9m6LVQkEN6ijmcuOTvFhWDPKJJYQ
CCU8xQRaPx8yZC9GxhAi4IXs4h2dYj4QxWkqTwgU6PDhiqY58uGyQ2bx51kq
vBDuXuflzoDkOvGqqUIxYNUhwXlrPFC2muE2PC2DXT0ZX3xteBDUcRyS594B
8Z6C+dBv0yBXJsMUFq6BKMvwtxasKahgm7R1GtbDY8xbNpYwBfU+aXscphuh
ictONLKahPmDJ6ULb36A9gLdvKSECRBZyt+2R7kVLhLprpQaLuiuu1TYFLWB
qH7rsbCFcWiL0OloUuuEFZVwfqjGOOwjTy3lznTBE/rX2skLOEwtjjB7j/bA
2qU60uJ9DKiTla1ScQzorDrTfY/MASn513wO5yPYkKHN7tUYPPMu98hQ6gPT
tzbDCe/ZsGCUz/F61A/SB/WqOe0sCNRqLNvVMADhXltS+axRGClqfNqt+Dc4
OWdIsd+NwFefjymq9wehWcsxzbtoGA6fElvzqBwC63hDC0n6IJhmKXqWyjHB
f9SqM5byCYLknfezro4Aq+Ok2nxkP6hP20n2W46Cu1xzaGBIL+yQ/izeuDwK
BSHpLYXaDBCtSSk+kMoCydUCM4pEN9zQqfwkYcGGQtbEnKpZO+SbuWZUL7DB
/UvlSteDZpif2r0NTxqDufHB1XcTDVBuY7qBcpoDzu6SL93Kq+DROVJ6Gc6B
YbHTJVEyZaA4bD6QTcJgjDkXWT9EhZh6g2K7aAy6MSz/TDQV/nmtHin29JuH
HWh12lSoD5DSuUHGIH0hyJMakw1u4j3xWikYsJXMbXfqZ8EbbQfTuhIM7Emu
oQYH0uFIjGcFcxCDzay6iFcPKZDkdzmWzMTAwt9Ck81IhHVbMzdjFgYRxiUh
21QToWvf4e05OAbvbT0mTjF+Bf/ymZs3ZzHw6ltV+WwZB2Wjd5VXNuEQ/eXW
gWvPw2Fvk8dKoQQOGEnNcatRGJDy7RnOW3CIWPIvTeU+hkv3jhMbZHCooNOM
WgJCofqK2uW7O3FYXsj1PdEQAgdP7dFUkcPBh7q/0n9HECxKrg7F7MUhWGxT
oRbNH1xmeTTDfTj0qp6PC954C5r7mDEzijiYS5gOy1G94Ci981qGEg51m7TU
TYyvQ3Jmrb61Cg5cv4cjczVXQCiqVFpUDYdp242GD5Z/Am/fLLxc/dv+QriX
e5c+9FglVnlq4iD0/U7oRVAIWsh9rgTdNB3kO3FF/T/oIRdgA7sPGSIrUDQy
dc8ii8z2Fdr8jPxXnuqH2DDkqwqdS8IM5PnWWPZt4rjAyaJOgdZKXIF3MMuz
RBqRN/5CtD3uPyGwUK5TMXv7pMABL4pjt9cjVx2OFpe5NSWwjHmAepjUtMBD
Gl2MEDpyyUtQ4jjxBHYs1pWRX0N+TMokDuXNCFzIlU+ROs8XODqN5MK8gOxm
zVMuskLeS6eXWNojx8RfaXrmiuyl+/vs5hDk/RE7z4nlIK/ph27tf4P8iTfW
k5OPTLanOZ4tRV5Xs75DoiMPdce/3MBAfhu5eJ3Ri0wxcFbNHkC2eHWkzJiJ
/GdwewtxAjlJ41i81TSyPzvVVpGPfOi870jtHLKo8EcqeRF5tNzAx2UZme6T
rXl0Ffn597/0v/8FAE3CqQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$1191852#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.733452293017425*^9, 3.733452324960277*^9}, 
   3.733484052697954*^9, {3.73348409278938*^9, 3.73348409946738*^9}, {
   3.733516077490204*^9, 3.733516116576686*^9}, 3.793936844068605*^9, 
   3.793973399797831*^9, 3.7939734424309597`*^9, {3.793973494803496*^9, 
   3.793973501802786*^9}, 3.79397432462609*^9, 3.793974555898389*^9, 
   3.823228887066326*^9},
 CellLabel->
  "Out[2637]=",ExpressionUUID->"31eb9e50-ed0e-47db-9a43-c74982d0fb60"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol1", "=", 
  RowBox[{
   RowBox[{"DSolveValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], "-", "k"}]}], " ", ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "x0"}]}], "}"}], ",", 
     RowBox[{"x", "[", "t", "]"}], ",", "t", ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"0", "<", "x0", "<", "1"}]}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.7334319986070766`*^9, 3.733432015964493*^9}, {
   3.733432108548764*^9, 3.7334321564733877`*^9}, {3.733432233000393*^9, 
   3.733432248667637*^9}, {3.73343238034665*^9, 3.7334323910563097`*^9}, {
   3.7334324430830317`*^9, 3.733432446480926*^9}, 3.7335098248600807`*^9, 
   3.7335099749279613`*^9, {3.7335103610471363`*^9, 3.733510370338934*^9}, {
   3.7939734484752417`*^9, 3.7939734499943542`*^9}, {3.793973939674999*^9, 
   3.793973944031007*^9}},
 CellLabel->
  "In[2638]:=",ExpressionUUID->"0071c804-c69a-4ab0-b27f-283feb12b01c"],

Cell[BoxData[
 RowBox[{"k", "-", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "t"], " ", "k"}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "t"], " ", "x0"}]}]], "Output",
 CellChangeTimes->{{3.7334321172002583`*^9, 3.73343215689006*^9}, {
   3.733432234555974*^9, 3.733432249219082*^9}, {3.7334323813100348`*^9, 
   3.73343239142841*^9}, 3.733432447120821*^9, 3.733484061062666*^9, 
   3.733509825436925*^9, 3.73350997620264*^9, 3.733510371312623*^9, 
   3.7335161325229073`*^9, 3.793936844202195*^9, {3.7939734444329844`*^9, 
   3.793973450737389*^9}, {3.793973498333956*^9, 3.793973501846044*^9}, {
   3.793973940428383*^9, 3.793973944461162*^9}, 3.793974324676304*^9, 
   3.7939745559366503`*^9, 3.823228887096078*^9},
 CellLabel->
  "Out[2638]=",ExpressionUUID->"879c714c-db1c-4449-85ed-44fca2b63327"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"sol1", "\[Equal]", "0"}], ",", 
     RowBox[{"k", ">", "1", ">", "x0", ">", "0"}], ",", 
     RowBox[{"t", ">", "0"}]}], "}"}], ",", "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.7335103822322483`*^9, 3.7335103863599443`*^9}, {
  3.733516161559058*^9, 3.733516220619334*^9}},
 CellLabel->
  "In[2639]:=",ExpressionUUID->"85e01a3d-8f21-4198-8478-e8ae1338430a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t", "\[Rule]", 
    TemplateBox[{
      RowBox[{"Log", "[", 
        FractionBox["k", 
         RowBox[{"k", "-", "x0"}]], "]"}], 
      RowBox[{
        RowBox[{"k", ">", "1"}], "&&", 
        RowBox[{"0", "<", "x0", "<", "1"}]}]},
     "ConditionalExpression"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7334841637891617`*^9, {3.7335103828144073`*^9, 3.733510387067737*^9}, {
   3.733516154852744*^9, 3.7335162216724653`*^9}, 3.793936844239492*^9, 
   3.7939735019517384`*^9, 3.79397432478468*^9, 3.7939745560274887`*^9, 
   3.823228887191642*^9},
 CellLabel->
  "Out[2639]=",ExpressionUUID->"316af494-e01b-4257-b5ab-478e6a34142b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"x_", ",", "k_"}], "]"}], ":=", 
  RowBox[{"k", " ", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", " ", 
        RowBox[{
         RowBox[{"Abs", "[", "x", "]"}], "\[GreaterEqual]", "1"}]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Sign", "[", "x", "]"}], ",", 
        RowBox[{
         RowBox[{"Abs", "[", "x", "]"}], "<", "1"}]}], "}"}]}], "}"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "1"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Thin", ",", "Dashed"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Blue"}], "}"}]}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7334334189556017`*^9, 3.7334335315909853`*^9}, {
  3.7334335631744947`*^9, 3.7334337598557377`*^9}, {3.7334338077971983`*^9, 
  3.733433810605796*^9}, {3.7334338587841997`*^9, 3.7334339016981792`*^9}, {
  3.733433938315205*^9, 3.733433975946213*^9}, {3.733435107032349*^9, 
  3.733435188688385*^9}, {3.73351468250228*^9, 3.7335147817328444`*^9}, {
  3.73351497670735*^9, 3.733514985040864*^9}},
 CellLabel->
  "In[2640]:=",ExpressionUUID->"fb8c3e9f-9dde-4c02-87fc-63d7bb5c949f"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Tiny], Opacity[1.], 
      Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxF1H0wE3AYB/BRcsT+aM1dc7fYmm50ejlvmQqnOMd5GeJatctIbjudk7eO
Tkes0M6hTFGXd46kVqohW25uaRS5dWFe2s0sb5ut20JvPL/n7nuf/7/3vcfx
UkpkgjkGgwn/k7/Gd/CWNjcNvdvuNRGcaL+Q4jP1jPSfSKfJ7kHNMlJtM/tE
Po28muwe2yVC5lK+9iUWIvnV5LIhLLJ2qiglwkoP2g3Tw6j4NVASTg+QUnRg
EJWSRiZpQe92RoPs8CpovJ2IO0ZdAdcMdRUXDi6DmH+HFJPK3Ho4iyDN4kaX
C0sDlvt6evrlqMH4B7Hf1bUqUNZItDLjK0GizdOjvYI50NpBKZtvmQHZUQX3
m5oUIFM0JSWWTYCkExsR7/PkYHNS1/QbwRiYrO1k3OGPgK65FnG7yFIQlzW6
u7JaBI6z2M4dswIwI9u5dLCiBvzfw4Hj27bc9fKtO/Lw1LalV/K+MG++BG11
IbS2CBGoSBtwS8+Xgovdof0ZkhGwofAxk8UdAyn6VlxmtRycfLZfSEuaAKPv
KYoWeAqwpr5YGFI5A+48x/lhkTUHfmQ2N0bmK8EXtoTzBrYKdOI7qixD1KAx
PX+9la4BF4z22CavRXBrF+Cjy4Wj9mQkz+9D8T7KCohNafUX4VfBnoBXQgFB
C65zLnrEYHWgmeWnKpd1pEdQan8wRg8av7Wp8KvIALaEF6pHlphmvQqMSAeC
PVdnbgADz3Kpn3HI8pGEZJ470nWAqLHOQmZGe5f75yDfzUX7ZOcho3aUFM9z
kdd9TYckfKTk9Tin4C1yT7AWL+xDMuTYHp0YuWQ4jWUNIe3cn7f7TyKZYllM
9gyymb6w0alE+qSSwhyXkLfMThpitchhXlwtz4AkOFwLlJiQW38O/A3m66qs

       "]]},
     Annotation[#, "Charting`Private`Tag$1192253#1"]& ], 
    TagBox[
     {RGBColor[0, 0, 1], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGBQA2IQnbx+wvv//7/vh9Eiv6XUrP8g6CNuS2PKfiBotXs7
T775gKBf8TxefPMhgi7IMo3YfBhB16neOpDWjqBnzVaedJYPQc+/35EfyPkN
TotdCPbXFP0Kp08EBLucVv0Cpz00VUuUlT7Daat1McvO63+C07+60oSNND/C
6XUt+Ue1VBF0Ul1FubIigj5V2HVbRBJBz4pYt/g7B4K2VPtmvPfFBzhdcbA1
xGMFgtbZ3cfmuARBP9gyfYflAgTtsWKljPYMBC3ef/YJbweC3hYjWno5HUFn
hcmpn0lG0HIB6jePxCPoNmdL223hCDpMK5Z1pjuC/vp9ydQ4dQQd1bF9+hxl
BH1A4tTMW/IIusfy/dwwCQT96STjgikiCDo8SmTRJQEErVRtucyPE0F3cPus
6GFF0Bcj5KVeMyNoAA6XVmk=
       "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAmIQHed38LTmj/f7GcDgw37O3YGprU8R/AV/ZufWXkPw
/zAd7YudheCHc75bbxuH4POJOXz6+/QdnH9EaZLJvlwEn2EKx5cvGW/hfGvW
+s3aKW/g/CkO5uaOta/g/OQ5EU9fzX8B559fLsfJOOsZnC/Hs8Fw/7YncD6X
wrPzL1c9gvNzQlpnrFjxAM5POHz/tNyku3C+ku2/wKONN+H8lRmbH+7edhXO
z/q8MaZ71kU4X6+ONZJN+TScL1x5hXva7MNw/vWUHK31j7fB+aXM33sVO9fB
+eVVWn0np86D8+/lK5vGePTD+dfaj/26EOEP5wMAUXSkKw==
       "]], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAmIQfa392K8LEf72DGDwwX5mxdyvl68mwPl3b2auX+iX
Aecb+zVOlFtQDOeXr/f1fiNRDeczWBbfd2ZthfNdZtnPFKzrgfPT9HLarm2f
Cuev6rdwWGIwF86v6O1/1nluHZzfl9l4LaFpO5zP+8XHek3gYTj/Qckxk7KW
03D+u52+h8pPXITzl7UvTEjpvArnq35bLVwx+yacf2+T/F7rjLtwfuj0Bx2v
JzyA8+ct7dnrM+0RnM8SnfuWtfIJnH8uYeXyoJZncP5WXqnY7zkv4Hy1WYov
2H1ewfm/ylr+rg5+A+e//iXNt8LiHSL8Ntz4wr0HwRdLnXo73/49nL9g/+dz
io0IvrZU0KHLhxD8cxs07R0uI/gF7ox71jxG8A8J5f569BrBF753w0LyC4If
53fwtOYPBB8AHta23g==
       "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAGIQfTFCXuo18wd7GM2iwPcrlg1Br2F1kazkQtD/LqwP
Xy+EoBekt1+RVkbQHNUZp5XVEXRBn+chbW0Ebb+Ve4O1MYK+xzShO9oZQcvM
m+E0OxlBz7iycoPUEgQ9wfFMj6TqRzjNl7/a6bDoJzi9z2XH3m1Sn+H039x4
szC+L3Cakf3STO2/CNrMo+iQF8M3OP3rzpoXop8QtEvOiQm+3xB07+/HFq2/
ELSClHTnF6bvcNo9vFPzsjCCnnIxNWuCKYLWOyb3hqsSQVeEWk1xqkXQB5+E
2lQ1IugQ5t6el50Iutrht86JWQj6xK7rua17ELSQ12fRvQcQdMxNvn1fjiDo
999d+VLOImgx0y3rnO4h6IQj58OqHiHolcGv/218hqBtipT8Fd8j6DZGu+8R
nxH0hQmR8yd8R9BSCqXuJ34j6OT1E97//4+gAQfQSj0=
       "]]},
     Annotation[#, "Charting`Private`Tag$1192253#2"]& ], {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.733433956068124*^9, 3.7334339763476467`*^9}, {
   3.73343512242701*^9, 3.7334351891798773`*^9}, 3.7334352595274277`*^9, {
   3.733514708113298*^9, 3.7335147823879337`*^9}, 3.7335149857728157`*^9, 
   3.7939368442786913`*^9, 3.793973502013578*^9, 3.7939743248563013`*^9, 
   3.793974556081761*^9, 3.823228887226441*^9},
 CellLabel->
  "Out[2641]=",ExpressionUUID->"fce1ca5f-c1ae-41b0-9dae-4c437fdf150c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["k", "2"], 
        RowBox[{"Log", "[", 
         FractionBox["k", 
          RowBox[{"k", "-", "x0"}]], "]"}]}], ",", 
       FractionBox[
        RowBox[{
         SuperscriptBox["k", "2"], 
         SuperscriptBox["x0", "2"]}], 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"k", "-", "1"}], ")"}]}]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], ",", 
     RowBox[{"PlotLabels", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(E\), \(NL\)]\)\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(E\), \(L\)]\)\>\""}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x0", ",", "0.5"}], "}"}], ",", "0.01", ",", "0.99"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.733516232761043*^9, 3.733516278801268*^9}, {
   3.733516384693143*^9, 3.7335165199126043`*^9}, {3.7335165868008633`*^9, 
   3.733516606983161*^9}, {3.733516643815563*^9, 3.73351665570114*^9}, 
   3.733516695591402*^9, {3.7939742074635887`*^9, 3.793974222652729*^9}, {
   3.793974291054393*^9, 3.793974292824119*^9}, {3.793974348106909*^9, 
   3.7939743646007843`*^9}, {3.793974403747304*^9, 3.793974431647998*^9}, {
   3.7939744699931726`*^9, 3.7939745271554127`*^9}},
 CellLabel->
  "In[2642]:=",ExpressionUUID->"f0b76af0-aaed-4dab-81d1-5bc4eda4a0ad"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x0$$ = 0.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`x0$$], 0.5}, 0.01, 0.99}}, Typeset`size$$ = {
    360., {98., 102.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x0$$ = 0.5}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[{$CellContext`k^2 
         Log[$CellContext`k/($CellContext`k - $CellContext`x0$$)], \
$CellContext`k^2 $CellContext`x0$$^2/(
         2 ($CellContext`k - 1))}, {$CellContext`k, 1, 3}, 
        PlotRange -> {0, 2}, 
        PlotLabels -> {
         "\!\(\*SubscriptBox[\(E\), \(NL\)]\)", 
          "\!\(\*SubscriptBox[\(E\), \(L\)]\)"}], 
      "Specifications" :> {{{$CellContext`x0$$, 0.5}, 0.01, 0.99}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{405., {143., 149.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.7335163900728416`*^9, 3.733516520489066*^9}, {
   3.733516608070423*^9, 3.733516609966486*^9}, 3.7335166561810627`*^9, 
   3.733516696090267*^9, 3.793936844319169*^9, {3.7939735020542192`*^9, 
   3.793973518768825*^9}, {3.793974143538146*^9, 3.793974144230732*^9}, {
   3.793974208316025*^9, 3.7939742234529867`*^9}, 3.793974294737328*^9, {
   3.7939743249189672`*^9, 3.7939743654132442`*^9}, {3.7939744048424377`*^9, 
   3.793974434624585*^9}, {3.793974480489685*^9, 3.793974491381597*^9}, {
   3.793974528483512*^9, 3.79397455611973*^9}, 3.8232288872616043`*^9},
 CellLabel->
  "Out[2642]=",ExpressionUUID->"acc45a45-1e19-46ce-920e-61751f64d1ef"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 755},
WindowMargins->{{Automatic, 169}, {Automatic, 25}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"bcc5659e-cc98-432d-9493-f40ee19d2003"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 196, 3, 67, "Section",ExpressionUUID->"1dc79fbc-9bc0-4e6a-92ff-6194512968cd"],
Cell[779, 27, 175, 4, 30, "Input",ExpressionUUID->"a9feb711-9493-4d56-8516-b7ac1c08259d"],
Cell[CellGroupData[{
Cell[979, 35, 1597, 40, 73, "Input",ExpressionUUID->"17e37cc5-b883-4285-8ac4-3e680aa48652"],
Cell[2579, 77, 3938, 85, 239, "Output",ExpressionUUID->"31eb9e50-ed0e-47db-9a43-c74982d0fb60"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6554, 167, 1125, 26, 52, "Input",ExpressionUUID->"0071c804-c69a-4ab0-b27f-283feb12b01c"],
Cell[7682, 195, 820, 15, 34, "Output",ExpressionUUID->"879c714c-db1c-4449-85ed-44fca2b63327"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8539, 215, 452, 11, 30, "Input",ExpressionUUID->"85e01a3d-8f21-4198-8478-e8ae1338430a"],
Cell[8994, 228, 699, 18, 61, "Output",ExpressionUUID->"316af494-e01b-4257-b5ab-478e6a34142b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9730, 251, 1524, 42, 52, "Input",ExpressionUUID->"fb8c3e9f-9dde-4c02-87fc-63d7bb5c949f"],
Cell[11257, 295, 5014, 108, 239, "Output",ExpressionUUID->"fce1ca5f-c1ae-41b0-9dae-4c437fdf150c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16308, 408, 1616, 42, 81, "Input",ExpressionUUID->"f0b76af0-aaed-4dab-81d1-5bc4eda4a0ad"],
Cell[17927, 452, 2454, 48, 334, "Output",ExpressionUUID->"acc45a45-1e19-46ce-920e-61751f64d1ef"]
}, Open  ]]
}, Open  ]]
}
]
*)

