(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     92785,       1798]
NotebookOptionsPosition[     90731,       1753]
NotebookOutlinePosition[     91127,       1769]
CellTagsIndexPosition[     91084,       1766]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["For \"Pound-Drever-Hall\"  (Problem 11.20)", "Section",
 CellChangeTimes->{{3.644343994865362*^9, 3.644344010982798*^9}, {
  3.793935619051238*^9, 
  3.793935623970242*^9}},ExpressionUUID->"35e0da6c-e546-43ba-adf5-\
2dfe164c2b3b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Omega]", "2"]}], ")"}], "2"], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["\[Zeta]", "2"], 
      SuperscriptBox["\[Omega]", "2"]}]}]]}], ";", 
  RowBox[{"f1", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", "\[Omega]"], "f"}], "//", "Simplify"}]}], 
  ";", 
  RowBox[{"f2", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", 
      RowBox[{"\[Omega]", ",", "\[Omega]"}]], "f"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"f1", ",", "f2"}], "}"}]}], "Input",
 CellChangeTimes->{{3.644342089729944*^9, 3.6443421300915194`*^9}, {
   3.644343212518442*^9, 3.6443432132017317`*^9}, 3.644343988341139*^9, 
   3.6443443529981823`*^9, 3.793935850772582*^9, {3.79393588683344*^9, 
   3.7939359249608173`*^9}},
 CellLabel->
  "In[2782]:=",ExpressionUUID->"b304b52d-3922-4f9e-9d39-0cf15d4265e1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"4", " ", "\[Omega]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[Zeta]", "2"]}], "+", 
        SuperscriptBox["\[Omega]", "2"]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["\[Zeta]", "2"]}]}], ")"}], " ", 
         SuperscriptBox["\[Omega]", "2"]}], "+", 
        SuperscriptBox["\[Omega]", "4"]}], ")"}], "2"]]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"96", " ", 
      SuperscriptBox["\[Zeta]", "4"], " ", 
      SuperscriptBox["\[Omega]", "2"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[Omega]", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["\[Zeta]", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"12", " ", 
         SuperscriptBox["\[Omega]", "2"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[Zeta]", "2"]}]}], ")"}], " ", 
        SuperscriptBox["\[Omega]", "2"]}], "+", 
       SuperscriptBox["\[Omega]", "4"]}], ")"}], "3"]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6443421307059937`*^9, 3.6443423272162113`*^9, {3.6443432015410967`*^9, 
   3.6443432158325243`*^9}, 3.644344044384474*^9, 3.7939356658357983`*^9, 
   3.793935723817041*^9, {3.793935853951024*^9, 3.793935861924756*^9}, {
   3.793935926300511*^9, 3.793935932394795*^9}, 3.7939359816297407`*^9, 
   3.823229089061193*^9},
 CellLabel->
  "Out[2784]=",ExpressionUUID->"356023a9-7770-409c-ac6b-30f4a511d2a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2res", "=", 
  RowBox[{
   RowBox[{"f2", "/.", 
    RowBox[{"\[Omega]", "\[Rule]", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"2", 
        SuperscriptBox["\[Zeta]", "2"]}]}]]}]}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.644441595916486*^9, 3.64444162601359*^9}, {
  3.644441674861508*^9, 3.64444167671574*^9}},
 CellLabel->
  "In[2785]:=",ExpressionUUID->"df79ccec-ae0f-4fa9-a378-8f6aa56a5265"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["\[Zeta]", "2"]}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["\[Zeta]", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[Zeta]", "2"]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{{3.644441622083333*^9, 3.644441626646904*^9}, 
   3.644441677382262*^9, 3.793935666003533*^9, 3.793935724007378*^9, 
   3.793935862084916*^9, 3.793935932557577*^9, 3.793935981806898*^9, 
   3.823229089207007*^9},
 CellLabel->
  "Out[2785]=",ExpressionUUID->"10ea3a8f-3ab9-4757-9296-23c930a4d255"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "/.", 
      RowBox[{"\[Zeta]", "\[Rule]", "0.1"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Omega]", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f1", " ", "/.", " ", 
      RowBox[{"\[Zeta]", " ", "->", " ", "0.1"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\[Omega]", ",", " ", "0", ",", " ", "2"}], "}"}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f2", "/.", 
      RowBox[{"\[Zeta]", "\[Rule]", "0.1"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Omega]", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.644342186433345*^9, 3.644342210484269*^9}, {
  3.644344119258835*^9, 3.644344124249989*^9}, {3.644344161145789*^9, 
  3.644344178215411*^9}, {3.793935654428528*^9, 3.7939356616879597`*^9}, {
  3.793935699523945*^9, 3.7939357151310053`*^9}},
 CellLabel->
  "In[2786]:=",ExpressionUUID->"ba69090d-b818-44c1-8931-cb9095f3ac08"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwV2HVYFU0XAHBSSuk2AIkXkVJplTMiXUoqIB0KKCCggqgoSEmpdEpZIBh0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           "]]},
         Annotation[#, "Charting`Private`Tag$1201253#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{6.9693877551020424`, 1.4999999999999432`}, {
       6.137106677329655, 0.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {104.43401632842185, -63.55589773577221},
      ImageScaled[{0.5, 0.5}], {193.6076620823036, 121.05885283004231}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVlnc8198Xx62QGdlUdiqiiEjOzcguZK/4oOSbES1KEhGJBioRJZQU2TTe
N1nJyi4je3/48LHnz++f9/txHvec13me+z7ve48YydvMjY6GhubG1uP/bwO3
0d94zE3DMkqhP9r/rgaDlpDPP0FtsOc1WZnPdQHF5GeJeYLmYBU0iBpy/cCw
rj03SdAVFM9t+1iTGwJWrotfHwtehuKVS1H0eU+gWz5c64FgKGinK6Wz5adC
Cu/psEjBWBDzlYvTLs6DYOa8vRGCb+DN4Y/pqj9/gLXNq2zKTD6MXLivQjfV
Aqybwfa6uwn4YT1sxt3+D6RMp0Z/3C+HEOm+MtuiIbhWrwrP5n5C1dcKKdaS
SeDP5+qhpW2AEUtXKq/ALNhHrZoP8jVA61rc0ev7ZuG169CvStkGUDQcqhlS
mwVZ3pKS+9YNcDx4F+eAwyxoXnWK481pAKO9Jqnn38yCcqJVeqx8I3hfeJiY
pkgFZ8d0h7c9jfAmrc7XwW4OCvu1ahvUm+BBv6YnNC9Am17wzAPdJqgJjDaJ
HlmAhY/f+IzMmuCu2zzT5OoCqNxQda4+3wTISvVYi+QiFO+UX8CPm6B5f8wn
m2uLUKItJJo72gSLVWKC+nuW4Es6xS82thnC79e/QjeWocwjSdhmsgVQ2ZXI
3e5rkDf233+OCy1wPMGliD9oDd64q312oWkFv6A8N/H4Nbh7rt3Wi6cVYqMC
nl4sXwM9EldCiHor5JYaR7WJrUODzV2Bj1GtgL6bLXD3rkOXnicvvVwbbGoX
Havw2IR56eOcHzzboXr+N8F7lhZp9GtWRV5vh/NHczwMvGhRWJJekHtIO6DR
//qiAmkRH4/5tMTzdsgN4A04lkiLlGn/a0gob4eVm7JnTvylRdc7n8XcE+4A
gb9lLZvWdGgtZo7T9WcHXJg579jgTI+0DVeqTrR0wEPeLvV+X3oUxUhze8+/
DvD2eWmzLZQe7Qpkpfyd64DHMvpvbqbTIw0P8UZT0T9Qf2F736FJehSkbfIQ
rv0B54cnAmsCGBDd8vsdwlJ/4XsDNdkqbRsSrtOkgvxfqHvqym9ZtA0pvfrT
6qr6F8J/M+i7/dyG3PSZXnw0/gsdB37LF5K3oernJCnNq3+hgtbFTVKFEcWo
CapdqPoLxvnlGTp1jEjkZphL0YVO6MvK3aXOxIyOmOw62eXXCWu6ET6Bwszo
lGS+DO2tTtg3IOTWJM+Mgmr7yAaPO8HJrOJ5kTUz6hc5fr2ntBN2ugkw+r5n
Ru++UqO2sXWBfuo1nm/m25HyplPhmY9dMP7SrOdyEQsyMsZ3dIq7oFx6h8NE
HQtyebHntEpZF4yxiwpcH2RBD1V6RoTaumDJfq2ohYsVjXnbCfavdwFH7OCf
JE9WlNhrcdPHuBt0VB35I/exIdoyA80Hk90gz3K6KyOPHQnsyOQIWugG6ru+
KbE6dnTQcXunD00PKK+HQeEwO7JdqfIz5+kBi6BGmYNCHCj/sE6asHoPSByV
ZD57hwOdSwXmzPs9UEdntmvIihPVhirVV+7/B0fKgzn1onYgNc5fdI+O/AN3
h2hllsQd6O1zZxU79A9kgv0+9bzfgUI+RqdMW/yDOhTMRfza8u8Y9RUI/gfX
26KinNi40NsDSfweW+fAsd2FqfCIC2mO3clh1OyFLzwaU5qZ3Mj/YH3Nf7q9
sM5Vsz3iCzfK8RMcajTqhUr/IPOhem60eyNb8IVVL6Tw09P1UbnRMnf3HXnP
XvBYLYgb1diJctRVLKyf9cLAvc+q1n92oj0PJ5bfTfXCbMuHq+WivOibc9C7
XGovaCb0kjKVeJGj4k6bz0u98IPNuTVDjxcltqkV19L1wYWPJzrHfHiRwK7I
q9N8fVDYKGgbXcaLuDNlqErQB3aHV674e/ChbeVuk0RMH3T6cxWM1vGjN3HL
L6pj+2D9VorQ9iF+pH3+geHv530gaQ1LOmv86A5LQWZ/ah+cuGJTx3tAAG2Y
MFzYVtwHL6iva7kjBdBS9+shg94+YH96NSXTWBBNLP7raVXohx0rx2syJoVQ
4fmYMgPlfqB13PdwZbswut2ukU4c64cQLUHhq3uFEV9Rkue7k/3AafQ+aZQk
jDSv2q3dtO8HB0cXnR+dwihhrk1Q8l4/xLxSe/iwVQTpzdSZ+/7rh4KIP8lF
E7vRTufAoyOD/ZD8dZJazLEH9TTKitiP98P7C72y5EN70OWc+wM68/2QPdNN
TF/fg5K99X0FWQeAW8ilM49BFC2Qy2Ow8gC8DWyfP5Ygit6Mf67hiB6ANXpn
+sW/Ysjr6WkJjycDICgT9+zNtBhS0R64UfFsAEJkLDkuMYijmiQWuZupA1Ag
13T7/EFxNGNiEzNWPAC+jDr9jSHiSKNo4Uz5wADg9PwTNUoS6E/IoW5/1UGI
MV+pFPgkiV4rVBxp1RiEXbkBp4VrJNHFbutoBe1B6DXWGNEekEQ0Krdh5NQg
hPhQL3HwSSHp8fpX5q6DsBLSbxkSKIUum1w8Jx8zCDfYy3JVzaURx66M6cHB
QTgvRvbYJyGDkGVI98DYIATrTu1PAhnkG3P2V//UILTuodVSt5dBbbQCGb1L
g2DFLkqsx8mgl8P3HLvYhqD7Q9dIPOs+dDDHo65ZaQjWzvSeuri5DxlrHXxf
FjoE1VqvZXexyaJbN1mef48YgkLhs1fTD8qinILhMBw9BB3Laa/OmcoiHplk
0rdnQzBxnl3nwVNZ1MW2Q6g0awj0cjWigqTl0MW2mXufWoYg8s/DJJvTB1HU
hYJzKZLDsNzgfpjbXQGNow/3WPcPw65naZo0QQpIVyAt86r8MOx27orij1dA
dFWxU0Zqw0DD5K30o1wB+Utevrp8ehi2XQ8uF5A8hM79OxxmdmMYTGZ3+HBO
HELlhfvffr09DNlp7rVfGA4j8WjxGpmwYfDfHe/4fPdh1K3OzbH5cEtf92B5
n9lhZJ4wE/c+fRhyMoP3f/56GJ2wyEljaBoGRafs65RERfRS9m2Vd/swMMdW
bi8vUURr9Cljf7uGYfK7SnVdmyIqzo2R+zQyDCyt9p/ucimhgzu8CxzWh2FO
71lebIQSEvklV1EoMwIbv666JIceQQvo/aB70AhEiMWR92WqoC9vJl5cCx2B
c873k81qVdAdZtkzYREjoL/vTnXJlAriaMz6nvpkBMiUvFgdpaNI+uzHlz0Z
IwCB18nOZUeRZeAna/PGEVCzOmYrM6GKRPpmOF1aR6Bg6esNfy411K99uOrS
3xHInDq1yHVUDXmx5R2JGRyBRuPtJOEwNRT2Ip+7ZmkE5NAO/ldSx1BBSVEt
iI3C+1Bu1m1+6ihg11LIKelR6BR6EMr3Uh2h4KPHHA6MQu6n3gf+P9VRrV7J
u4Ajo+DdlsypInYcDbaXhhXoj8L5yd1OqS3HEc/CV3TAdxSeB6yW9hsCuny4
PJ/vxyh0iwS+/YBOoHNKoimPqkehd5G809zxBLJWvnmfrX4U/lxk5Ve9eQId
U1Mi0f0ZheX0ir3fi08gOs03nFNTo8Cqmv7gj5ImijEN9agQGgPleW+xHFUt
dPtMrwUSHQMexiFSmJ0W8rVQP/FZagxybh5sfhOohSxt5vg/KYzBrlHzhi9l
WkjE2bUi8eQYvGCNcvrPRBtl+miLXvYdg/S/M0tWAToo0TeFdfraGKwmPTGg
eaWDHlxeW7gQOAbru4sjV6t0kM/1/Lqz97b0xI5lkflOIpXbkjcMX45BCYdU
SEvxSVQew9AmXjMGBskrq6fZ9dC/j+X3f4uNg4QjWeXEhgFqJDNMHt47DmGa
K0o18oYIy+oYxcqOg2t2kmmpsyFKyaxgs1IZB41bla1NlYaIlF75oMtoHNg/
HPdYjjNCw0nVMSPXxuGF0uOar3qnUFsXM0UvcBxq/jLocQafQlXC+iaZd8Yh
xpnQbS45tXU//tzh+WAc5nQVbxXInkYecTWPZl+PQ+IM/9MVVhNEjqp9sl43
DkyeHQlX6UxRzy+2OcfmcZCLKfGxETdF9SzG5rhjHL7mKdsFaJqij/fqeEIG
xmHjUMOFayGmyCe0Po55eRyC7jA3uTKbobkbjU93Sk7Ae3YTd5XdZ9CqR8uL
fQETIM8oeMchwAKZKzs8Ohg0ARcu5688SbZAWbTDYYqhE5AvL5FCW2GBHJ8t
XjoePQH2M5s3g3dYou8VQnqmrycgNjz7AWumJQoXdZ67XjMBMVazn+eGrdDO
NrJRtdAkPD+jdmIsxBZdfHVVs27PJCyonBZnybZF5Rc3VZokJ8Gh1Hbd8K8t
ukrPJdF1cBJ2F51TkDtkh/4oKC1Pa07CnKrhDfVeO5R8PyCN/79JODZgpcCn
6YAOnGDaOPd5Em4kzBp8p3NCOZnv93bgSQjTu/LolJATUuIxMdWvnAR0baGk
7JATUh959ubA70l4ViCraunkhE492G9IGZ6E0QunBwY+O6GmhfrLzpOTwGVt
m0JqckJWTn4vm2YmQfgpEZ436oScFL/M5K9NgvOlB6KYxxn5/jF+5s9Nhrl+
JfuDHs5oQXP2+zg/GcKDchpGbzmjG1nxE3a7yPDSkpnT/okzCg36p6EhQ4Zt
S7drHT87o3ipS0N0GmTY+arkjycTCQnF8HJe1iKDVRVjQ7ggCSUvlRwd0iPD
v4ZuVfUDJPT2F11U1RkyxDOUlLsYk1DJpdjDURfI8OxFb5JSFAlpdB61X/ci
Q7+K+dd3CSRUpt191+syGZqr/Bfj3pJQDb/0H5MgMkhRLZNxGQmdCq6hKwsl
w/kjYybz9STUPO4lqxhJhrSI1LQHf0mo62tREG8cGRi8KRst0yTktNf+XVgC
Gfy5Jb76L5PQ0EOa5sVkMkiyNz/2pHNBHitv1tzTyFC09OPIexYXNOWiL/03
kww+39SN5bhdkG8d+bRhDhmuX/jsOyXgghaVH/t/KSADU0DB4bHdLuhminKq
3GcybLK7sQtIuiAals7al5gMV8RTr12RcUGhfkELnJVkGFBt6Fw94IK2d0uI
Bv8iQ+Xb8oS0gy4o+mS1/mwjGaYru9k8FVwQd85FP5c2MtzX3BZidMgFxQty
JbV0kuH3z1ZdjS1bOKSgUqePDEZHq1PUt/xTJm0ohcNkqLnm03BiS0/SckNQ
ZpIMnIo/ufW28r0lXms9nyEDX0D0W/29Lkhun64nyyIZbC9m1CNxF5T7eCL+
xhoZhudelu8VcUHKazF4knYKipMP1C3xuKBSN6VxB6YpyA6qlP/I5oI0Gjp2
NrBNwR5hUzVNehdUdjTwOOKeglfaNZrZSySk+1rs/Cf+KdD9wvVuepKElJ5x
SFeKTMEPq36tgV4SEo1eHfwrNgWSL056VzWTEHvoaOq09BQw+S4WPq0goRX/
VhKD7BR8dqjIO11IQiPeZWKCh6YAK29nn0gjoRa37F455Sm493RXgFssCX0w
jXC0QlMwO3a8ctiThBJ0r+66qDMFYS3EpSFrEgo77tJ122AKHsbJ1OVqbvXD
vuO2meZT8Obn472Z3CRkvGe/IGEzBSGkyU+1S85IjZe/o9lxCr6mqTFmdzuj
nbQzFuvuU9CxVHg+LdUZ0Sx283B7bfEs9s3lhjqjycmaZmm/KZj4EHDaz9UZ
VXa8MTUJ3Mqf/mWdRtQZ5dU/2uF2Zwroh3vWq1edUEr5rQb/8CngezyxV7XN
CfnnWBunPpoCVzujQ9vDndC5dB224vit+O2i4m4OTsgs8fCv2hdTcIrVxsX5
sBOSvcemv5A2BZSiTgOPnLPo31msrV86BUL9Dal20o6o1uIDvSMxBb9zDoj3
fHFAxYYJZb7lU3BoVZEh3sQBPVa5jBLrt+qHSad33vZIh1NGfbp/CkqLhEue
RNmiw9t4V+lHt/Q1eUSobLZo9yptqQB5Cv57kv00MdIGLQ13qmgubvH3A+4P
tEbvv8UoxrFOQ6JOZe2UtiV6ln9z9t2OaWh7dXPSOMcChWZe+PSNdxpqc/lU
FAS3zuN4LfnRPdNgFF62J33gDOLyWtx/TGkaxk85mMXYm6Jru86K99lPg+fj
yHCaFl1EMlGw7HKehltxAYH8XifRqRDayPZz00B7PLKKf5sOkh5LnanzmYbG
T97nnPdropb8UVwaOg1PPndka2YdRQpGvmdjs6bheGXJgRyVIRAJ0noS82ka
xHfFqjEx0WOmXJ6qyMJp0LQvpnuby4t7+IsOBuNpkL4l86uYbS+OGlhd92zZ
Wicivj4pVsGjAXcTddemYXBo6W3QkC4etzzg/oqGArwbc/2BZ/WxE2Un3R56
CtgSTV+t2g2wocTQESFmCrwpkShcIYyxeER40g5uCsyV6vufKTbFjea1F9el
KFBytW3lLb8VPjmVz3hDhgJ/MqY535da4S/hSSlL+ykwW21aGmRnjTNKvVqo
8hRITwk77hFvg2+JcqmPq1LgeEBp8OC0HZ4rWW49r06BhBpFIYHb9tjjTL/3
kAYF0BB7EMHugC3C8lJ7tSigk5zFoiPmiGUnLVjbjSmQYxIaIsXjhIvNjYhI
EwoY6Ieo/7B0wlpfNf00zlBgcVtJyrenTtg2Wr4zzZoCWhkJ82U8znh4QSrG
xm6rnt5/4lUmztj3rIgWuyMFHgdq+e6574wjFLa/v+xCgVqdCd6qFWfM83zT
UeYcBfZ/103lUSDhFNoF7i53CnQ/Sf6e60LCxU39AVpeFGirlqLvqyDh4ctf
DLj9KfC+c9hb6KoL9u3O3ai4QQHMoNi5keSC13Xe5frfosAYeHSpl7tgHv54
ob4QCmgUf6hvYHXFKUFR9bFhW/mzbW7vl3PFsqN37uhFUOAni4j2uJEr1irx
Hs+OpoCF7H7ljHBXXC927qXLoy3+vZc5sl67YttIezP+WAqEXIzXlfriiodn
zRh/xVPAay1Njb/FFfva6Zfeek7ZmlfbfcLGXfHGD/A6nEiBzdfDKdc2XXGE
rLL48EsKsDcEZE1zu2GeONm2568o8MLweRJV0g2nrItHGr+hgNhu/jf3jrhh
2XOCGrQZFBhP5NmZr+2Gi+o5Z/PfUUDm+23HG2ZuWFOFMd09iwJXk9IEBh3d
cH3ymo1I9tZ6+7dp6gU3bMtMZW/8RIEdCwnvc/zc8LDP2PeQfAqMGukdEL3p
hn3//LuiUkSBfNl6kl6IG14/0bZvooQCctuo1vIRbvheZm33yy//t3dIdT7Y
4t3545EZQQHr0tlJ00dbvDdKdBjL/h9f1//8yRbvYPZySTkFwpuUtEpi3XCx
UfoHzyoKCH1VOFO4ZWsVJDqL1Wz9D9pWjk+3/Ot3PeFtrd36HhdX80lberZh
ET/vNVDgvrpH5u7oLd6poED1JgqYShx98nuL55LV1UOUFgqIx7z8ERzqhteI
i0Op7RS4VDj24MitLV4Zl+dWf7f8MxYQ9eoW7yMbY9ZuCsiHf5f+7uWGk5dP
0xL/KOBKxxCS5uaG95NOFvj2b/V/9cCjdDs3XFijfkF6iAI3VnLCaky29ldR
cdffEQq8cs2P5Ndxw3Uv9v1+ME6BwybsX54cdcODF/lU56cpcAaz9h3a5YZ9
WtnIb2cpwNhe1nCWY4vvOP0r+3kKcDTw97ZsuOKdnBTm8hUKUNddc993u+Km
r5Hh+usUyLLvjjWoc8WPL0oxNmxS4Nuxz5L2W/3FXWNL/5dhBk4vctuOPduy
71asT3PMAM0eq0N7t/q1SdHp5hWuGThow7DYprIV37+ysrJzBk7wa84LS7hi
LqSwtE1wBs6zG328suSCd6wmzApLzMAg5Vx3y0sX3PjuyKVXUjOwL3Ii/UW4
C35o3TgtLTMDNzve7uDzccGchdvIh+RmwP+G/EdF5II5LvmM6KrMQEfuhyTv
bhJmG9Hp8jOcgXbGsKwkDhKujeu1XTaegQauyQbhOWccpX3jzy2TGbgUmeQa
+McZs77OaYuwmIHSoNmouVRnzOIg/Dv57AyMtHEIUlWcMXMzpeKX3wyc+xhV
TevohBmIF9kSiTOg9773oKq9A/6rrq337+UMrPgLNQ6JO+Ds0snehFczUJTd
0lU1Zo9tC49zc2ds1XsleVrpuj3+9OHfZZrcGUgo7qobf2qHHRMl1LqrZuBR
ble++qANLvZ/Xx5PnYHVH9lLPsWWOHrxjIPZwgwEeNBZRdyzxC5X1ubZl2dA
+reL5bK15Vb9xnvvbsxA2tWw+d4VC+zmPh3ht30W1oRvr/zWtMDcVoqnTfbM
Qkmzx8ixgTP4P6XPf7YbzgIhwvBsztUU48bWrGLjWbiS0H02DJliXk9K0HmT
Wbg+LPTjnIgpJtKkpCssZmGs1CGdq9UE7+R/6HvbaRZs7tUH0xuY4M/LrqyL
V2YhwlNO+l/IKbwjPqgn7fosBBKnye7ap7Db4YRP5jdmoXDqz8jtbacw538N
Vrm3Z6F9vc/bKsIYu3SpvvG8Pwv5B1lJd54aYVaC4/hgyiwoWHaEjdcaYCe7
fTuepM6C/sfrR7vjDHDBotbAifRZKKDLxsZnDfBZBf+I5Pdb+WsX1d9Q9XHe
q4FW28JZ+JfZZcciro/tQou9fv/a4rlZb/YnVhe/1yelfFuYhZr2XPt3v7Sx
kqyYBizPgve9b+Lyadr4G0dvJ7E6C6yax+OYgrRxY7MD/3caKlg/oc/4oKiN
5xxson+wUOHDc7/W0hQtrOFrcrN6NxVSE0XFUYQmrjLnFNIXo8Ib4/7WpPOa
2ESlvuinBBVWGA+RtE5qYtKaIbVGhgoPY+hvuDBo4vAwXY+6w1Q4kW9zaDjk
BG5M0LBuOkmFAtaBQc8YhG0C1+fN9KnQ3M+asHkJ4f6zX540G1JBtInhcYM5
wnOSag0tJlQIc/zHKSOMsGD2kZPttlQY3yb9x8oCMOmHrFKXFxV48+6+3fHu
OJ6fENoxHE8FR69208Mpajg2aaQq8TkVZDZUfwl5q2HF0/lBZxKp8MmQodFH
Qw1fyjWexq+o8G/sg7JzjyomX79d/yKLCv3KIKssoYqHtg1HmZZRocmpgKaB
UMGhRbnazBVU8Dv3NJ43TgVLXAha+1ZFhUKhf80lHirYuVbgomwdFdY9jFL5
+VVw92NDQ6YOKlxN25XDeVkZt+75tP0rmQr6Wi+bD2kcwZd/B373o1BB54Ty
53GBI3hniIH/fioVXr1FtVSqEjYdHhh9ukSFWXKmJTVTCddl8VX70s/BoEzq
zGMRJVyhejNMRnAODq+w1X9iV8QFZ3TpY7XnIFtMtrlU/BC+Z1h8V0R3DvTt
3TUYmA9he619zGn6cxBtGyUVTFbAdIqs7IWn5qDtvuyLnSUK+BR3A1+H9RwI
ddXXRJsp4NFGy/0innPw37OcoXUReSx06pzpm7g56Jg6EUh7WhaTddqbZZ/N
wct6LrsuSVmMj+tZFiTMgYJaD9q2egCfk9tvV5k8B2erngdpvD2A89imXEff
zUGQ/e5X6owHsNGvK9dlv83BMJ3gic6GfThI725y/vAcsN3aFxIVtxc3Obrb
K4zNAWlwm1fa5b1Y8oqhYNbEHGjXDmYvntmLa15xPUmlzEG7uJTzyZ17Mc9q
UtjjlTlgPPSpMShWGr/9UOjpwzEP7BJ/N2heSeFG7tFjssrzENnqdNHpnwQW
3/drKePoPMgQXz83lUvgK/CxQOLYPBiudwdfypTAQhcvywujeUhSOMKleFUC
u1bQSLAYzMNHNRviC6cEXromyDLqMA8nSyfGUwzEsVi3QUfq3XmQPb2qH9Yt
iiPLjmVb3JuHv4vx6zyVong2QzaM6f48JNyxSa79KIrLfDmU/ns4D3/06GwK
botiV+ammMMv5qGGsfaOi7Qofqtoo/s9Zx4ox5uhY2Y3Phh5vrCncx7M7RZE
4JIIjve2fvCwZx6E02lOehiK4E1zfVfNvnmQ7P78o0VKBDfuOcCdPjwPbMlv
ytw6hfGlgilPz5l5ULZwUfTQF8b5vVek1hgXwLTX680TBSGsphIaK3h4YWte
4hexkBHAbSRB5SSlBfheHCH4jFUA+0V/bBdVWYCrr10PMk7z46yhDiEZ9QWg
8r1zJxXy492xcq+UTy4ATwpRw63Lj+lm2j6csV0A+Uj5l9w+fPhX5r6qB3cW
4JeNwpWMHh7s3vbNnevuAjTTQ0RZJQ9moDNniQtfgJNRlaI02TxYw+aWcWLU
AowEdoz3BfHgHKbm5sz4BWBl/M9fVYIHx7re7K3KXABPuW+XGH12YvvdDcu0
zQvQ5RWzliTKjTkEfQs+ty5AgOLzXxQWbvx9J++lKx0L4JD7ysx1ngtLb7cb
He1egGALxRdZNVx4mjrc1jC6AJ0KGnmfr3LhOz838pI2FuBZ1n6/1y078NvL
B71U9y8C7PS7p2bEiW29f++jyi6CkGmuj6oMJ2b3uDyUJb8IDa4v0i8ycG7N
46X2okcWoZYl6oHXVw58zOCkIRNaBK5JknfbIQ5cv8dRptViEezTpTjGJdjx
fM2Dfp/gRXjEFcnSu58Vd7G2uq+FLELNGavQ7xysuMxIZDo8bBEO5d/5XjXL
gh/WZ66+vL8IMjwqL098ZsH7m6p46uIWQcNT4vWgMQt2/EOruy9zEc4GpckX
+W/HlSNX3vc1LcLAi7nzu8aZcJbM10OerYsQHEd362ATE35ygaF4qX0RGK2i
Wx1KmbDTxONyzu5FuMn96CHffSa8MpXdfXxkERKOGKhPyDFh+YUxzoTVRThQ
WpSycp0RP2NwvGwmuQROUmojkRLb8IYL/5Hf0kugdLaU/RrnNuz6o3H+9L4l
8M1yMLixyoAV7mhdMz64BEzkewG/mhlw9aZMgN7RJYid+DQbdpcBL65QgzSM
lmBiurHXiEyPLWci7u+/vATrKsyjSnV0+IuJltG7q0uw9109afAzHRbPWWOT
8V8Cj2hvmreZdHjKyzta6tYSPI8RV/zvHh2+O2n+SPTeElhfT3Tv0abD+SN7
nvIlLsEb0d9qTt9p8c6egtd05UvQZV3yWLiaBkezBQYWVS7Bo7A9l9qLaDDL
MW3riz+XQCWxWTkjgwbTPWtib6tfgjwUSHcnnAbPmk5ff/dnCTYYLLzE9Ghw
Y4XMaZPpJZgur8/qfr5JRH14sZoktAxLdPw7OKvXCeYuUpvZrmUYc/et5M1a
J0JZ9n9iEl0GiTLLtOMP14kb54vPXZJaBs+vtbsp1uuEh1jrb22FZeArMer9
O7FG6MVxvJ3QWYbCP8MJyfxrxLbAYHPVS8tQQ0dmLLi7QuTPTC4Tfstb9+1j
cWnvFcL1nHXyyavLENOBfLOtV4jy0/LjZ24sQ9IlJQUW2RUiVLw7yOvuMrAn
7y3ral4mGKqPvk99vgzVl6PyO/cuE3Q7KbQcZctwh7ko60rvIpEbbpcRW74M
aYGxHXm1iwRprdJIuGoZWNojXjGWLBJlQ0lPZWqX4fXlH6/HHi0Sd4oN5bTa
lsFOnOnJa+1FgtYxw/r6+DKYqj7ZX/NhgaB555jdz70C0neEn+pGzxOVk+1e
ybwrkBloE3/1xjwRpWB60F5gBT5lPNIrdZ8n+Iu1PrTuWoGkoj6rIK154mCV
zPtqmRUY/0uVWV+eI+yHZtM/aqyAcE+ORY7HHFEiFv4ywGMFeowu8GvZUolb
bjSOKp4rwKxVeKBNn0pov/PfNee9pech0BCgSiUaFS4mel5ZAQcHF/clASox
CqYJTrdXYEQ89FJZxyzB5ygcfzJ+BWKarmffspslfBOyH3CXrcB9s6YNBs8Z
omgtIbysfAW+6LtdGXCcIdYcw4J9q1bgl1+udaPJDBEu4XClqXYFINh0d6vS
DJGYxeLwuH0FaPYKl9xbpxAV39xkuckrkL5bSjjiEYUQGBD+xSWwCt9Hhqfn
w6aJrwfuMXN5rcKRmceHk59OEsot/HWPfVah6otkJ1fIJJFzM+MRj98qtBj9
5XvqNUm8rqsUEri+CjO3Hi106EwS97y3ye25swoZ9rRSR+cnCLO8O6Zy8asw
xTm/aWY1QYyoBSbof1uFa43Xqq/IjBNcBr6ydzjWgOWnaPqTlREi5TsnqxrX
GohKfY8sGh0hFFQ/jM3sXINDrDMSk20jxCmZ0XRnwTUIKronE543QkQyOoqd
kFyD/3bXed/xHCEYfujz0aitgSv1NSVwcJhYOCZGc8ttDX54Tjiz9wwRXXKN
zf5f1kC1U1tjdXWASJ7gCqQn1iC7YDsqmhogSO/OSD/4vgYud42Nb/UNEGOS
7ddTKtdAr3bSQa5qgFgQ7tlV1bgGTk0pEhxPBggulsnzPENrsKZZ/KtRdoA4
Ocy09pF9HVIPbF7icu8ncl6C5KDjOlg62/s4rPYS1AAqk7PzOgSwnOgvo/QS
ylYZE90u6+BZ/S5ZYbiX+MzJmdfuvg4ta0Xdkr97icrbPSd++a6DKHPQA++M
XqKTFHg2N2wduNXd2MMtegnGvZ8Tbn9cB3ajtQRe73+EQ7Yy166NdUC3H0d/
F+8mCm2XOBppNqCthJWjgrOb4GAsZQuh34Arc1XMHWtdBLY/zjzGvAEFPAcU
Zdu7CHEW7c38nRuQL2BfcD+qixh2NSUb7dsAua6JK0IrnYSX0MWfN803YJYt
MZy79y9x++6r4K7MDQim0JgFtnQQ7NeYDJw/bIAqywO8WtFBJLh7cg9nb8DN
qKjK0KIOIs9QNXU6fwNYxlL8ChM6iGGu3+V0xAas77U8/dS5gzB8ScO8r3kD
XCU+8erOtBN8RWejr6xuAEO4P6OYQDvxYXTXCw6jTXh61EV1MriVuJd016nn
1CYYNj/2cL3cSriakaU+mm4C4TV8bORcKyHy5UuOsdUmqAX9imczaiUiY+wq
o0ibYMFfzNfK10q4Kz+fYfHfhGoWiyzzjy2EeCiPHlP6Jtx+fqji12AzsXH0
Jnv72034JtB7+m5HM/GHPNCU/n4ThGSCjfVqm4mHVnkOJz9tgjT16a3xvGZi
c7+Z390vm1Cny1fxMqSZ6Pod85K+eUs/YPwCIdlMFIctujS3bvHFNYiwCTYT
scfO7kvt2IQK9eZSZ/ZmwjDtYL5mzyY4frr1dO9CE1F6ve5n8Ngm3BA3pohU
NxHxckdiTCc3YUS9QSDnSxNxqT/RXGx6E25VDkwYfmoiZIwu/sNzm6BDiPkm
JTQRDLQtbx4ubkKLZAzvmZgmorfgmIfTyiZE/ObT5gptIr54pMorrG+C1Jfp
+fbrTcTTPazzm5ubcFfORiLDs4n4H4TBCAQ=
           "]]},
         Annotation[#, "Charting`Private`Tag$1201299#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{19.214285714285715`, 1.4999999999998863`}, {
       6.137106677329655, 0.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {319.4244979648573, -63.55589773577221},
      ImageScaled[{0.5, 0.5}], {205.8525600414872, 121.05885283004231}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
          1.], LineBox[CompressedData["
1:eJwVV3c81t8XRyqp7BQqI4kImU3nZI8I2XtGskckkrKSvaKssqJkU5Ke+iol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           "]]},
         Annotation[#, "Charting`Private`Tag$1201345#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      Background->GrayLevel[0.97],
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{24.316326530612244`, 1.5}, {6.137106677329655, 0.5}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {543.0884489890481, -63.55589773577221},
      ImageScaled[{0.5, 0.5}], {210.95460085781383, 121.05885283004231}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[223]},
  PlotRange->{{0, 656.195934705225}, {-127.11179547154443`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.7939357159465027`*^9, 3.7939357242200212`*^9}, 
   3.793935862272834*^9, 3.793935932773716*^9, 3.7939359820207167`*^9, 
   3.823229089411775*^9},
 CellLabel->
  "Out[2789]=",ExpressionUUID->"061d4a1c-cd70-4624-a6ab-e20177daa78b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"den", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["\[Omega]", "2"]}], ")"}], "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["\[Zeta]", "2"], 
          SuperscriptBox["\[Omega]", "2"]}]}], ")"}], "2"], "/.", 
      RowBox[{"\[Omega]", "\[Rule]", 
       RowBox[{"1", "+", 
        FractionBox["\[Zeta]", 
         SqrtBox["3"]]}]}]}], "//", "Simplify"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Zeta]", ",", "0", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6443443585598392`*^9, 3.644344422477264*^9}},
 CellLabel->
  "In[2790]:=",ExpressionUUID->"1655fbc7-3641-498f-b3f6-8e7ca77de008"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"256", " ", 
     SuperscriptBox["\[Zeta]", "4"]}], "9"], "+", 
   FractionBox[
    RowBox[{"896", " ", 
     SuperscriptBox["\[Zeta]", "5"]}], 
    RowBox[{"9", " ", 
     SqrtBox["3"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Zeta]", "]"}], "6"],
    SeriesData[$CellContext`\[Zeta], 0, {}, 4, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Zeta], 0, {
    Rational[256, 9], Rational[896, 9] 3^Rational[-1, 2]}, 4, 6, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.644344392798072*^9, 3.6443444231515017`*^9}, 
   3.793935666186982*^9, 3.7939357242337923`*^9, 3.79393586231065*^9, 
   3.793935932787195*^9, 3.7939359820344343`*^9, 3.8232290894465303`*^9},
 CellLabel->
  "Out[2790]=",ExpressionUUID->"9b8d88d7-5e6a-4813-8177-ec436cdcb59e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"num", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"4", " ", "\[Omega]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[Zeta]", "2"]}], "+", 
        SuperscriptBox["\[Omega]", "2"]}], ")"}]}], "/.", 
     RowBox[{"\[Omega]", "\[Rule]", 
      RowBox[{"1", "+", 
       FractionBox["\[Zeta]", 
        SqrtBox["3"]]}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Zeta]", ",", "0", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.644344436583552*^9, 3.644344474933777*^9}},
 CellLabel->
  "In[2791]:=",ExpressionUUID->"b4afa986-7c83-4854-b66a-376e993a0d87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"8", " ", "\[Zeta]"}], 
    SqrtBox["3"]], "+", 
   RowBox[{"12", " ", 
    SuperscriptBox["\[Zeta]", "2"]}], "+", 
   FractionBox[
    RowBox[{"28", " ", 
     SuperscriptBox["\[Zeta]", "3"]}], 
    RowBox[{"3", " ", 
     SqrtBox["3"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Zeta]", "]"}], "6"],
    SeriesData[$CellContext`\[Zeta], 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Zeta], 0, {
   8 3^Rational[-1, 2], 12, Rational[28, 3] 3^Rational[-1, 2]}, 1, 6, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.64434446344081*^9, 3.644344475478066*^9}, 
   3.793935666194109*^9, 3.793935724272574*^9, 3.7939358623166656`*^9, 
   3.793935932825611*^9, 3.7939359820734777`*^9, 3.823229089452157*^9},
 CellLabel->
  "Out[2791]=",ExpressionUUID->"f5892448-51bc-4d93-a327-b0878079f43b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   FractionBox["9", 
    RowBox[{"32", 
     SqrtBox["3"]}]], "1000"}], "]"}]], "Input",
 CellChangeTimes->{{3.644344544058199*^9, 3.6443445566507063`*^9}},
 CellLabel->
  "In[2792]:=",ExpressionUUID->"7b5e5947-bf4b-489a-923e-d436c8041617"],

Cell[BoxData["162.37976320958225`"], "Output",
 CellChangeTimes->{3.644344557255185*^9, 3.793935666224691*^9, 
  3.793935724278076*^9, 3.7939358623224783`*^9, 3.793935932831202*^9, 
  3.793935982079129*^9, 3.823229089478953*^9},
 CellLabel->
  "Out[2792]=",ExpressionUUID->"ec7555a2-067c-4f5f-9b03-27534e83f2cd"]
}, Open  ]],

Cell["\<\
error signal (compare Taylor expansion to no expansion and to 2nd derivative \
linearization)\
\>", "Text",
 CellChangeTimes->{{3.6443440155270557`*^9, 3.6443440302078876`*^9}, {
  3.6444385890803537`*^9, 3.644438601779296*^9}, {3.644439707434704*^9, 
  3.64443971560005*^9}, {3.64444563813619*^9, 3.644445642701408*^9}},
 FontSize->16,
 Background->GrayLevel[
  0.85],ExpressionUUID->"8dbcf172-d82d-4dc6-9bdf-cb493fc0af63"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ff", "[", "\[Omega]_", "]"}], "=", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Omega]", "2"]}], ")"}], "+", 
     RowBox[{"2", "\[ImaginaryI]", " ", "\[Zeta]", " ", "\[Omega]"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ff", "[", "\[Omega]", "]"}], " ", 
         RowBox[{
          RowBox[{"ff", "[", 
           RowBox[{"\[Omega]", "+", "\[CapitalOmega]"}], "]"}], 
          "\[Conjugate]"}]}], "-", 
        RowBox[{
         RowBox[{
          RowBox[{"ff", "[", "\[Omega]", "]"}], "\[Conjugate]"}], " ", 
         RowBox[{"ff", "[", 
          RowBox[{"\[Omega]", "-", "\[CapitalOmega]"}], "]"}]}]}], "]"}], ",", 
      RowBox[{"\[CapitalOmega]", " ", "f1"}], ",", 
      RowBox[{"\[CapitalOmega]", " ", "f2res", 
       RowBox[{"(", 
        RowBox[{"\[Omega]", "-", "1", "+", 
         RowBox[{"2", 
          SuperscriptBox["\[Zeta]", "2"]}]}], ")"}]}]}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Zeta]", "\[Rule]", "0.1"}], ",", 
      RowBox[{"\[CapitalOmega]", "\[Rule]", "0.01"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "2"}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.64443860575902*^9, 3.6444386551140347`*^9}, {
  3.644438721703541*^9, 3.644438755563964*^9}, {3.644438834527843*^9, 
  3.6444388510048447`*^9}, {3.644438899181076*^9, 3.64443895616171*^9}, {
  3.6444389997315493`*^9, 3.644439067106803*^9}, {3.6444391287600813`*^9, 
  3.6444391312090197`*^9}, {3.644439885642025*^9, 3.644439890636161*^9}, {
  3.6444399488699083`*^9, 3.644439959275857*^9}, {3.644440061838509*^9, 
  3.644440109851089*^9}, {3.6444416999447823`*^9, 3.644441830817515*^9}},
 CellLabel->
  "In[2793]:=",ExpressionUUID->"3420bc3b-7fe3-49e3-8728-7ce4f6ddff01"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVl3c81f8Xxy8aUpktSqGSZBXRdO5XKrJLpaVbKiN7lawbQmUlCUlXRiJ7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       "]], LineBox[CompressedData["
1:eJwVV3c81e8Xt6IkW6IUKiGrRUpOX1RkRGlJRraMiCJbdhlZ2SMlK5tU6kH2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       "]], 
      LineBox[{{0.939995918367347, 2.}, {0.9403922094616711, 
       1.9801874669708335`}, {0.9800878211325842, -0.004390608607923247}, {
       1.0190039103315582`, -1.9499965373394073`}, {1.020004081632653, -2.}}]},
     Annotation[#, "Charting`Private`Tag$1201494#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 1.9999999591836735`}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.644441766217146*^9, 3.644441831485897*^9}, 
   3.793935666381938*^9, 3.793935724456818*^9, 3.793935862404935*^9, 
   3.793935933010496*^9, 3.793935982259663*^9, 3.8232290896545057`*^9},
 CellLabel->
  "Out[2794]=",ExpressionUUID->"196235a9-afe7-4756-a2b7-8cd88153de69"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{Automatic, 17}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"102abe73-07ea-48f8-9862-d8041ac14b1a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 236, 4, 67, "Section",ExpressionUUID->"35e0da6c-e546-43ba-adf5-2dfe164c2b3b"],
Cell[CellGroupData[{
Cell[841, 30, 1128, 33, 100, "Input",ExpressionUUID->"b304b52d-3922-4f9e-9d39-0cf15d4265e1"],
Cell[1972, 65, 2241, 65, 63, "Output",ExpressionUUID->"356023a9-7770-409c-ac6b-30f4a511d2a1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4250, 135, 450, 13, 35, "Input",ExpressionUUID->"df79ccec-ae0f-4fa9-a378-8f6aa56a5265"],
Cell[4703, 150, 658, 18, 60, "Output",ExpressionUUID->"10ea3a8f-3ab9-4757-9296-23c930a4d255"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5398, 173, 1467, 39, 94, "Input",ExpressionUUID->"ba69090d-b818-44c1-8931-cb9095f3ac08"],
Cell[6868, 214, 48904, 855, 140, "Output",ExpressionUUID->"061d4a1c-cd70-4624-a6ab-e20177daa78b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55809, 1074, 839, 24, 53, "Input",ExpressionUUID->"1655fbc7-3641-498f-b3f6-8e7ca77de008"],
Cell[56651, 1100, 872, 23, 57, "Output",ExpressionUUID->"9b8d88d7-5e6a-4813-8177-ec436cdcb59e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57560, 1128, 702, 20, 53, "Input",ExpressionUUID->"b4afa986-7c83-4854-b66a-376e993a0d87"],
Cell[58265, 1150, 924, 25, 57, "Output",ExpressionUUID->"f5892448-51bc-4d93-a327-b0878079f43b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59226, 1180, 285, 8, 53, "Input",ExpressionUUID->"7b5e5947-bf4b-489a-923e-d436c8041617"],
Cell[59514, 1190, 312, 5, 34, "Output",ExpressionUUID->"ec7555a2-067c-4f5f-9b03-27534e83f2cd"]
}, Open  ]],
Cell[59841, 1198, 434, 9, 52, "Text",ExpressionUUID->"8dbcf172-d82d-4dc6-9bdf-cb493fc0af63"],
Cell[CellGroupData[{
Cell[60300, 1211, 2124, 54, 124, "Input",ExpressionUUID->"3420bc3b-7fe3-49e3-8728-7ce4f6ddff01"],
Cell[62427, 1267, 28276, 482, 271, "Output",ExpressionUUID->"196235a9-afe7-4756-a2b7-8cd88153de69"]
}, Open  ]]
}, Open  ]]
}
]
*)

