(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    107951,       2316]
NotebookOptionsPosition[    103835,       2238]
NotebookOutlinePosition[    104231,       2254]
CellTagsIndexPosition[    104188,       2251]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Single joint, flexible link (robotics), Problem 11.16", "Section",
 CellChangeTimes->{{3.642883049232572*^9, 3.642883068310667*^9}, {
  3.7939216610562572`*^9, 
  3.793921665970289*^9}},ExpressionUUID->"781a1477-e462-49e0-90f8-\
170c1e10832e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.64288255562225*^9, 3.642882570038011*^9}, 
   3.7939216701566753`*^9},
 CellLabel->
  "In[2726]:=",ExpressionUUID->"99869dda-cdf0-409e-8b3d-b5ed259abf62"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["\[Theta]", "1"], "''"}], "[", "t", "]"}], "+", 
     RowBox[{"Sin", "[", 
      RowBox[{
       SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "]"}], "+", 
     RowBox[{
      SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "-", 
     RowBox[{
      SubscriptBox["\[Theta]", "2"], "[", "t", "]"}]}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["\[Theta]", "2"], "''"}], "[", "t", "]"}], "-", 
     RowBox[{
      SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "+", 
     RowBox[{
      SubscriptBox["\[Theta]", "2"], "[", "t", "]"}]}], "\[Equal]", 
    RowBox[{"u", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"asys0", "=", 
   RowBox[{"AffineStateSpaceModel", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"eq1", ",", "eq2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], ",", 
       RowBox[{
        SubscriptBox["\[Theta]", "2"], "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"u", "[", "t", "]"}], ",", 
     RowBox[{
      SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"asys", "=", 
   RowBox[{"AffineStateSpaceModel", "[", 
    RowBox[{"asys0", ",", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         SubscriptBox["x", "1"]},
        {
         SubscriptBox["x", "2"]},
        {
         SubscriptBox["x", "3"]},
        {
         SubscriptBox["x", "4"]}
       }], "\[NoBreak]", ")"}]}], "]"}]}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"get", " ", "nice", " ", "labels"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"steady", "-", 
    RowBox[{"state", " ", "output"}]}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.6428825823328533`*^9, 3.642882743686378*^9}, {
   3.642882777874998*^9, 3.642882778065566*^9}, {3.642883164032366*^9, 
   3.642883279977054*^9}, {3.642883477577684*^9, 3.642883573527442*^9}, {
   3.642884036506177*^9, 3.642884080114455*^9}, {3.642884211568183*^9, 
   3.642884239600975*^9}, {3.642884786498206*^9, 3.642884812462278*^9}, {
   3.642884889431679*^9, 3.64288490004633*^9}, {3.642885353867793*^9, 
   3.642885363785411*^9}, {3.642885902805518*^9, 3.642885970235115*^9}, {
   3.642946298338839*^9, 3.642946299930791*^9}, {3.642946402674007*^9, 
   3.6429464974250917`*^9}, {3.642946628879944*^9, 3.64294669083549*^9}, {
   3.6429480743567*^9, 3.642948087221594*^9}, 3.642950399965979*^9, 
   3.6429505683298407`*^9, 3.642950881709132*^9, {3.642954303357924*^9, 
   3.642954314512445*^9}, 3.642954347689342*^9, {3.642954786764056*^9, 
   3.642954787106241*^9}, {3.6429548316782417`*^9, 3.6429548328321953`*^9}, {
   3.642955198314336*^9, 3.642955213791752*^9}, {3.6429553558167887`*^9, 
   3.642955362938587*^9}, 3.642958651858458*^9, {3.64299135924185*^9, 
   3.642991375525598*^9}, 3.64299149824076*^9},
 CellLabel->
  "In[2727]:=",ExpressionUUID->"4861b2d6-d4e1-495a-a803-e1f3ccae7b65"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{
     SubscriptBox["x", "2"], "[", "t", "]"}], 
   RowBox[{
     RowBox[{"-", 
       RowBox[{"Sin", "[", 
         RowBox[{
           SubscriptBox["x", "1"], "[", "t", "]"}], "]"}]}], "-", 
     RowBox[{
       SubscriptBox["x", "1"], "[", "t", "]"}], "+", 
     RowBox[{
       SubscriptBox["x", "3"], "[", "t", "]"}]}], 
   RowBox[{
     SubscriptBox["x", "4"], "[", "t", "]"}], 
   RowBox[{
     RowBox[{
       SubscriptBox["x", "1"], "[", "t", "]"}], "-", 
     RowBox[{
       SubscriptBox["x", "3"], "[", "t", "]"}]}], "0", "0", "0", "1", 
   RowBox[{
     SubscriptBox["x", "1"], "[", "t", "]"}], "0", 
   RowBox[{
     SubscriptBox["x", "1"], "[", "t", "]"}], 
   RowBox[{
     SubscriptBox["x", "2"], "[", "t", "]"}], 
   RowBox[{
     SubscriptBox["x", "3"], "[", "t", "]"}], 
   RowBox[{
     SubscriptBox["x", "4"], "[", "t", "]"}], 
   InterpretationBox["\[Null]", Automatic], 
   InterpretationBox["\[Null]", None], {
   4, 1, 1, 1, {1, 1}, None, False, False, False, False, 
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"u", "[", "t", "]"}], ",", "0"}], "}"}], "}"}], "t"}, {}},
  "AffineStateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    GridBox[{{
       SubsuperscriptBox[
        RowBox[{"(", 
          
          GridBox[{{#11, #, #5}, {#12, #2, #6}, {#13, #3, #7}, {#14, #4, #8}, \
{#15, #9, #10}}, GridBoxDividers -> {"Rows" -> {False, False, False, False, 
               Directive[
                GrayLevel[0], 
                GrayLevel[0.6]], False}, "ColumnsIndexed" -> {2 -> Directive[
                 GrayLevel[0], 
                 GrayLevel[0.6]], 3 -> Directive[
                 GrayLevel[0], 
                 GrayLevel[0.6]]}}, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
           DefaultBaseStyle -> "SystemsModelGrid01"], ")"}], #16, 
        ButtonBox[
         GraphicsBox[{
           
           RectangleBox[{0, 0}, DefaultBaseStyle -> 
            "SystemsModelSuperscript"], 
           InsetBox[
            StyleBox[
            "\[ScriptCapitalA]", DefaultBaseStyle -> 
             "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
         ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
           ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
         None]]}}], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"AffineStateSpaceModel", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               TemplateSlotSequence[{1, 4}, ","]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", #5, "}"}], ",", 
               RowBox[{"{", #6, "}"}], ",", 
               RowBox[{"{", #7, "}"}], ",", 
               RowBox[{"{", #8, "}"}]}], "}"}], ",", 
           RowBox[{"{", #9, "}"}], ",", 
           RowBox[{"{", 
             RowBox[{"{", #10, "}"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{
           TemplateSlotSequence[{11, 14}, ","]}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{"u", "[", "t", "]"}], ",", "0"}], "}"}], "}"}], ",", 
       RowBox[{"{", #15, "}"}], ",", "t", ",", 
       RowBox[{"SamplingPeriod", "->", #16}]}], "]"}]& ),
  Tooltip->AffineStateSpaceModel]], "Output",
 CellChangeTimes->{{3.6428859548068666`*^9, 3.642885990851182*^9}, 
   3.64294623094228*^9, 3.642946301646706*^9, 3.642946375168704*^9, {
   3.642946465806323*^9, 3.642946507975626*^9}, {3.642946631683002*^9, 
   3.642946693317431*^9}, {3.642948075231982*^9, 3.642948092080983*^9}, 
   3.642948649956461*^9, 3.642948790027275*^9, 3.6429494399518023`*^9, 
   3.642950334329783*^9, 3.6429504068316708`*^9, {3.6429505481105423`*^9, 
   3.642950569591804*^9}, 3.6429508071291847`*^9, 3.642950883517165*^9, 
   3.642950976001172*^9, 3.642951028724407*^9, {3.642954323725607*^9, 
   3.642954363254139*^9}, {3.642954789883439*^9, 3.642954852458846*^9}, 
   3.642954906595261*^9, {3.642955225996502*^9, 3.642955241465785*^9}, 
   3.6429553803683243`*^9, 3.642955756110828*^9, 3.64295726453759*^9, 
   3.642957389449728*^9, 3.642957500532469*^9, 3.642958616979577*^9, 
   3.642958659248446*^9, 3.642958694475985*^9, 3.642959035975668*^9, 
   3.64296215646154*^9, 3.642963185243105*^9, 3.64296324221027*^9, {
   3.64296783227789*^9, 3.642967850414757*^9}, 3.642986217742106*^9, 
   3.64298725534172*^9, 3.64299138159188*^9, 3.6429915015916367`*^9, 
   3.793921678863428*^9, 3.7939218780599613`*^9, 3.79392197574328*^9, 
   3.793992221805236*^9, 3.823229022592613*^9},
 CellLabel->
  "Out[2730]=",ExpressionUUID->"42ccb148-821c-422a-81d3-c99a134368e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SystemsModelVectorRelativeOrders", "[", "asys", "]"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"#", " ", "of", " ", "times", " ", "to", " ", 
    RowBox[{"diff", ".", " ", "before"}], " ", 
    RowBox[{"u", "[", "t", "]"}], " ", "appears"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.642884877237403*^9, 3.642884917021471*^9}},
 CellLabel->
  "In[2731]:=",ExpressionUUID->"2077cc72-a3da-4852-a8e5-c15fc0764269"],

Cell[BoxData[
 RowBox[{"{", "4", "}"}]], "Output",
 CellChangeTimes->{{3.642884878999227*^9, 3.642884903201345*^9}, 
   3.64288510684871*^9, {3.642885398868143*^9, 3.6428854068198233`*^9}, {
   3.642885980123229*^9, 3.642885990912574*^9}, 3.642946231013472*^9, 
   3.642946375231628*^9, {3.642946465876086*^9, 3.642946508048265*^9}, {
   3.642946631748641*^9, 3.642946693389616*^9}, 3.642948650010297*^9, 
   3.642948790078896*^9, 3.6429494400142927`*^9, 3.642950334452443*^9, 
   3.642950406988555*^9, 3.642950548324391*^9, 3.642950807289196*^9, {
   3.642950955444684*^9, 3.642950976164179*^9}, 3.642951028885689*^9, {
   3.64295432388426*^9, 3.642954363422307*^9}, {3.64295479005693*^9, 
   3.642954852916169*^9}, 3.642954906757484*^9, {3.6429552261646748`*^9, 
   3.6429552416200113`*^9}, 3.642955380522575*^9, 3.642955756284491*^9, 
   3.6429572647135153`*^9, 3.6429573896134653`*^9, 3.642957500747519*^9, 
   3.642958617174533*^9, 3.642958659316154*^9, 3.642958694532119*^9, 
   3.642959036046062*^9, 3.642962156521928*^9, 3.642963185306657*^9, 
   3.642963242302596*^9, {3.642967832343095*^9, 3.642967850479671*^9}, 
   3.6429862177938833`*^9, 3.6429872554144573`*^9, 3.6429913845846987`*^9, 
   3.642991501652647*^9, 3.79392167892983*^9, 3.7939218781472483`*^9, 
   3.793921975812209*^9, 3.793992221879355*^9, 3.823229022656818*^9},
 CellLabel->
  "Out[2731]=",ExpressionUUID->"7c70a4ad-c114-4b26-a11c-c502458acb65"]
}, Open  ]],

Cell["Feedback Linearization", "Text",
 CellChangeTimes->{{3.642884106832645*^9, 3.642884122357831*^9}, {
  3.642884288114716*^9, 3.642884291385352*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"5dc98170-8ca3-4c0a-838a-8c898cd95794"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[ScriptCapitalF]", "=", 
   RowBox[{"FeedbackLinearize", "[", 
    RowBox[{"asys", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["z", "1"], ",", 
         SubscriptBox["z", "2"], ",", 
         SubscriptBox["z", "3"], ",", 
         SubscriptBox["z", "4"]}], "}"}], ",", 
       RowBox[{"{", "v", "}"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"lsys", "=", 
  RowBox[{"\[ScriptCapitalF]", "[", "\"\<LinearSystem\>\"", "]"}]}]}], "Input",\

 CellChangeTimes->{{3.6428843232577877`*^9, 3.642884393201881*^9}, {
   3.642885016528625*^9, 3.642885060958679*^9}, {3.642950722070814*^9, 
   3.6429507309093847`*^9}, {3.64295077382073*^9, 3.6429507896160593`*^9}, 
   3.642954810390212*^9, 3.6429548486703367`*^9, {3.642959373815394*^9, 
   3.642959429115733*^9}},
 CellLabel->
  "In[2732]:=",ExpressionUUID->"c11839be-8f7e-4e9b-9b24-6937cc58014e"],

Cell[BoxData[
 TemplateBox[{
  "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", "0", "1", "0", 
   "0", "0", "0", "0", "1", "1", "0", "0", "0", "0", 
   InterpretationBox["\[InvisibleSpace]", None], {
   StateSpaceModel, {
    False, False, {
     False, False}}, {$CellContext`stname1, $CellContext`stname2, \
$CellContext`stname3, $CellContext`stname4}, {{Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$, 
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, Identity, 
    Automatic, 1, 1, 4, 1, {}, {False, False}, False, Automatic, None, {",", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{
           SubscriptBox["z", "1"], "[", "t", "]"}], ",", 
         RowBox[{
           SubscriptBox["z", "2"], "[", "t", "]"}], ",", 
         RowBox[{
           SubscriptBox["z", "3"], "[", "t", "]"}], ",", 
         RowBox[{
           SubscriptBox["z", "4"], "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
       RowBox[{"v", "[", "t", "]"}], "}"}], ",", "Automatic", ",", "t"}}, {}},
  
  "StateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{#, #2, #3, #4, #5}, {#6, #7, #8, #9, #10}, {#11, #12, #13, \
#14, #15}, {#16, #17, #18, #19, #20}, {#21, #22, #23, #24, #25}}, 
        AllowedDimensions -> {5, 5}, 
        GridBoxDividers -> {"Rows" -> {False, False, False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}, 
          "Columns" -> {False, False, False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
        "SystemsModelGrid00"], ")"}], #26, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalS]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None], MultilineFunction -> None], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{1, 4}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{6, 9}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{11, 14}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{16, 19}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{5, 5}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{10, 10}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{15, 15}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{20, 20}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{21, 24}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{25, 25}, ","], "}"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{
           SubscriptBox["z", "1"], "[", "t", "]"}], ",", 
         RowBox[{
           SubscriptBox["z", "2"], "[", "t", "]"}], ",", 
         RowBox[{
           SubscriptBox["z", "3"], "[", "t", "]"}], ",", 
         RowBox[{
           SubscriptBox["z", "4"], "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
       RowBox[{"v", "[", "t", "]"}], "}"}], ",", "Automatic", ",", "t", ",", 
     "SamplingPeriod", "->", 
     RowBox[{#26}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
  Tooltip->StateSpaceModel]], "Output",
 CellChangeTimes->{
  3.642884340654973*^9, {3.6428843820384283`*^9, 3.642884394277384*^9}, {
   3.642885016981799*^9, 3.642885022015045*^9}, {3.6428850538518744`*^9, 
   3.6428850618989267`*^9}, 3.642885107164016*^9, 3.642885407133054*^9, 
   3.642885991189274*^9, 3.6429462312906227`*^9, 3.642946375501848*^9, {
   3.642946466145299*^9, 3.642946508318578*^9}, {3.64294663203008*^9, 
   3.642946693667428*^9}, 3.642948650295233*^9, 3.642948790350998*^9, 
   3.6429494402966223`*^9, 3.6429503347300577`*^9, 3.642950407194312*^9, 
   3.642950548498377*^9, {3.642950722936593*^9, 3.642950731630578*^9}, {
   3.642950774772399*^9, 3.642950807446558*^9}, 3.642950976438299*^9, 
   3.6429510290628967`*^9, {3.642954324055068*^9, 3.642954363531704*^9}, {
   3.642954790156947*^9, 3.642954853021717*^9}, 3.642954906999218*^9, {
   3.642955226272243*^9, 3.6429552417262087`*^9}, 3.642955380771574*^9, 
   3.642955756391622*^9, 3.64295726481504*^9, 3.642957389722624*^9, 
   3.6429575008831882`*^9, 3.642958617281898*^9, 3.642958659601519*^9, 
   3.64295869479885*^9, 3.64295903632113*^9, {3.642959377905818*^9, 
   3.6429594297286263`*^9}, 3.642962156805634*^9, 3.642963185641425*^9, 
   3.642963242590032*^9, {3.642967832633505*^9, 3.642967850768383*^9}, 
   3.642986218102357*^9, 3.642987255695148*^9, 3.642991386728487*^9, 
   3.642991501848732*^9, 3.793921679048397*^9, 3.79392187825659*^9, 
   3.793921975916038*^9, 3.79399222198237*^9, 3.823229022774857*^9},
 CellLabel->
  "Out[2733]=",ExpressionUUID->"04fa0ed2-b1ae-451f-a21e-110864579f03"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Kappa]", "=", 
  RowBox[{"StateFeedbackGains", "[", 
   RowBox[{"lsys", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6428844086721153`*^9, 3.642884432144623*^9}, 
   3.642884736232729*^9, {3.642951022903075*^9, 3.642951086282529*^9}, {
   3.642951118211266*^9, 3.642951132868145*^9}},
 CellLabel->
  "In[2734]:=",ExpressionUUID->"811f38b2-5eb2-46bb-bb53-4a40a96f3320"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "4", ",", "6", ",", "4"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.6429511337146883`*^9, {3.6429543241146593`*^9, 3.6429543635886087`*^9}, {
   3.642954790228672*^9, 3.642954853082749*^9}, 3.642954907059763*^9, {
   3.6429552263349123`*^9, 3.642955241787594*^9}, 3.642955380835569*^9, 
   3.642955756452167*^9, 3.642957264880075*^9, 3.64295738978132*^9, 
   3.6429575009457607`*^9, 3.642958617340481*^9, 3.64295865966506*^9, 
   3.642958694872123*^9, 3.6429590363784313`*^9, 3.6429621568559923`*^9, 
   3.6429631856859283`*^9, 3.642963242661731*^9, {3.642967832692429*^9, 
   3.6429678508280277`*^9}, 3.642986218143764*^9, 3.6429872557631693`*^9, 
   3.6429913895408897`*^9, 3.642991501902973*^9, 3.7939216791145897`*^9, 
   3.7939218782953653`*^9, 3.793921975964491*^9, 3.793992222043441*^9, 
   3.8232290228362017`*^9},
 CellLabel->
  "Out[2734]=",ExpressionUUID->"a6f06279-8fe0-4e87-9f50-74de671847e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"csys", "=", 
  RowBox[{
   RowBox[{"\[ScriptCapitalF]", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ClosedLoopSystem\>\"", ",", "\[Kappa]"}], "}"}], "]"}], "//",
    "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.642884442729191*^9, 3.642884443631921*^9}, {
   3.64288447590489*^9, 3.642884477831017*^9}, 3.6428847391931868`*^9, {
   3.642951145274078*^9, 3.642951146736342*^9}},
 CellLabel->
  "In[2735]:=",ExpressionUUID->"a76a6c5f-a772-41d3-9960-90ba819f97d6"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{
     SubscriptBox["x", "2"], "[", "t", "]"}], 
   RowBox[{
     RowBox[{"-", 
       RowBox[{"Sin", "[", 
         RowBox[{
           SubscriptBox["x", "1"], "[", "t", "]"}], "]"}]}], "-", 
     RowBox[{
       SubscriptBox["x", "1"], "[", "t", "]"}], "+", 
     RowBox[{
       SubscriptBox["x", "3"], "[", "t", "]"}]}], 
   RowBox[{
     SubscriptBox["x", "4"], "[", "t", "]"}], 
   RowBox[{
     RowBox[{"5", " ", 
       RowBox[{"Sin", "[", 
         RowBox[{
           SubscriptBox["x", "1"], "[", "t", "]"}], "]"}]}], "-", 
     RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"Sin", "[", 
         RowBox[{"2", " ", 
           RowBox[{
             SubscriptBox["x", "1"], "[", "t", "]"}]}], "]"}]}], "-", 
     RowBox[{
       RowBox[{"(", 
         RowBox[{
           RowBox[{"-", "4"}], "+", 
           RowBox[{"Cos", "[", 
             RowBox[{
               SubscriptBox["x", "1"], "[", "t", "]"}], "]"}]}], ")"}], " ", 
       RowBox[{
         SubscriptBox["x", "1"], "[", "t", "]"}]}], "+", 
     RowBox[{"4", " ", 
       RowBox[{"Cos", "[", 
         RowBox[{
           SubscriptBox["x", "1"], "[", "t", "]"}], "]"}], " ", 
       RowBox[{
         SubscriptBox["x", "2"], "[", "t", "]"}]}], "-", 
     RowBox[{
       RowBox[{"Sin", "[", 
         RowBox[{
           SubscriptBox["x", "1"], "[", "t", "]"}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{
          SubscriptBox["x", "2"], "[", "t", "]"}], "2"]}], "-", 
     RowBox[{"5", " ", 
       RowBox[{
         SubscriptBox["x", "3"], "[", "t", "]"}]}], "+", 
     RowBox[{
       RowBox[{"Cos", "[", 
         RowBox[{
           SubscriptBox["x", "1"], "[", "t", "]"}], "]"}], " ", 
       RowBox[{
         SubscriptBox["x", "3"], "[", "t", "]"}]}], "-", 
     RowBox[{"4", " ", 
       RowBox[{
         SubscriptBox["x", "4"], "[", "t", "]"}]}]}], "0", "0", "0", "1", 
   RowBox[{
     SubscriptBox["x", "1"], "[", "t", "]"}], "0", 
   RowBox[{
     SubscriptBox["x", "1"], "[", "t", "]"}], 
   RowBox[{
     SubscriptBox["x", "2"], "[", "t", "]"}], 
   RowBox[{
     SubscriptBox["x", "3"], "[", "t", "]"}], 
   RowBox[{
     SubscriptBox["x", "4"], "[", "t", "]"}], 
   InterpretationBox["\[Null]", Automatic], 
   InterpretationBox["\[Null]", None], {
   4, 1, 1, 1, {1, 1}, None, False, False, False, False, "Automatic", 
    "t"}, {}},
  "AffineStateSpaceModelMinimal",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    GridBox[{{
       SubsuperscriptBox[
        RowBox[{"(", 
          GridBox[{{#11, 
             TooltipBox[
              StyleBox[
               StyleBox[
               "\[FilledSmallSquare]", 
                "SystemsModelMinimalElement"]], #], #5}, {#12, 
             TooltipBox[
              StyleBox[
               StyleBox[
               "\[FilledSmallSquare]", 
                "SystemsModelMinimalElement"]], #2], #6}, {#13, 
             TooltipBox[
              StyleBox[
               StyleBox[
               "\[FilledSmallSquare]", 
                "SystemsModelMinimalElement"]], #3], #7}, {#14, 
             TooltipBox[
              StyleBox[
               StyleBox[
               "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #4], 
             TooltipBox[
              StyleBox[
               StyleBox[
               "\[FilledSmallSquare]", 
                "SystemsModelMinimalElement"]], #8]}, {#15, 
             TooltipBox[
              StyleBox[
               StyleBox[
               "\[FilledSmallSquare]", 
                "SystemsModelMinimalElement"]], #9], #10}}, 
           GridBoxDividers -> {"Rows" -> {False, False, False, False, 
               Directive[
                GrayLevel[0], 
                GrayLevel[0.6]], False}, "ColumnsIndexed" -> {2 -> Directive[
                 GrayLevel[0], 
                 GrayLevel[0.6]], 3 -> Directive[
                 GrayLevel[0], 
                 GrayLevel[0.6]]}}, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
           DefaultBaseStyle -> "SystemsModelGrid01"], ")"}], #16, 
        ButtonBox[
         GraphicsBox[{
           
           RectangleBox[{0, 0}, DefaultBaseStyle -> 
            "SystemsModelSuperscript"], 
           InsetBox[
            StyleBox[
            "\[ScriptCapitalA]", DefaultBaseStyle -> 
             "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
         ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
           ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
         None]]}}], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"AffineStateSpaceModel", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               TemplateSlotSequence[{1, 4}, ","]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", #5, "}"}], ",", 
               RowBox[{"{", #6, "}"}], ",", 
               RowBox[{"{", #7, "}"}], ",", 
               RowBox[{"{", #8, "}"}]}], "}"}], ",", 
           RowBox[{"{", #9, "}"}], ",", 
           RowBox[{"{", 
             RowBox[{"{", #10, "}"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{
           TemplateSlotSequence[{11, 14}, ","]}], "}"}], ",", "Automatic", 
       ",", 
       RowBox[{"{", #15, "}"}], ",", "t", ",", 
       RowBox[{"SamplingPeriod", "->", #16}]}], "]"}]& ),
  Tooltip->AffineStateSpaceModel]], "Output",
 CellChangeTimes->{
  3.642884444611417*^9, 3.6428844793491297`*^9, 3.642884740217461*^9, 
   3.642885067529443*^9, 3.642885107761918*^9, 3.642885407802099*^9, 
   3.642885991418643*^9, 3.642946231499765*^9, 3.642946375714631*^9, {
   3.642946466359539*^9, 3.6429465085300283`*^9}, {3.6429466322679243`*^9, 
   3.642946693891374*^9}, 3.642948650513234*^9, 3.642948790565572*^9, 
   3.642949440515658*^9, 3.642950334953805*^9, 3.642950407414588*^9, 
   3.642950548667878*^9, {3.6429507275805607`*^9, 3.642950735667316*^9}, {
   3.6429507782992563`*^9, 3.642950807613263*^9}, 3.642950976789679*^9, 
   3.642951029222521*^9, {3.6429510722072372`*^9, 3.6429510890077133`*^9}, {
   3.642951135997445*^9, 3.642951147545402*^9}, {3.642954324321143*^9, 
   3.6429543636893873`*^9}, {3.642954790339437*^9, 3.6429548532684507`*^9}, 
   3.6429549075901012`*^9, {3.642955226465683*^9, 3.642955241898417*^9}, 
   3.642955380936554*^9, 3.642955756563013*^9, 3.642957264990122*^9, 
   3.6429573898912487`*^9, 3.642957501050144*^9, 3.642958617451227*^9, 
   3.642958660411014*^9, 3.642958695625854*^9, 3.642959037127002*^9, 
   3.642962157637746*^9, 3.642963186430593*^9, 3.642963243389254*^9, {
   3.6429678334380617`*^9, 3.642967851560841*^9}, 3.642986218894588*^9, 
   3.642987256464018*^9, 3.6429913916132507`*^9, 3.6429915022613*^9, 
   3.793921679226428*^9, 3.7939218783973427`*^9, 3.793921976067731*^9, 
   3.79399222215728*^9, 3.8232290229511023`*^9},
 CellLabel->
  "Out[2735]=",ExpressionUUID->"a5c4cf74-a982-475d-a09f-91361fc0a721"]
}, Open  ]],

Cell["Taylor-series Linearization", "Text",
 CellChangeTimes->{{3.642884106832645*^9, 3.642884122357831*^9}, {
  3.642884288114716*^9, 3.642884291385352*^9}, {3.642955563970954*^9, 
  3.642955569995049*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"66f34795-8d11-4782-8f62-1c56f9bf2f73"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sys", "=", 
  RowBox[{"StateSpaceModel", "[", "asys", "]"}]}]], "Input",
 CellChangeTimes->{{3.642955573903049*^9, 3.642955582643446*^9}},
 CellLabel->
  "In[2736]:=",ExpressionUUID->"7d7b34ab-52c9-4dea-92a7-f00c599118bb"],

Cell[BoxData[
 TemplateBox[{"0", "1", "0", "0", "0", 
   RowBox[{"-", "2"}], "0", "1", "0", "0", "0", "0", "0", "1", "0", "1", "0", 
   
   RowBox[{"-", "1"}], "0", "1", "1", "0", "0", "0", "0", 
   InterpretationBox["\[InvisibleSpace]", None], {
   StateSpaceModel, {
    False, False, {
     False, False}}, {$CellContext`stname1, $CellContext`stname2, \
$CellContext`stname3, $CellContext`stname4}, {{Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$}, {
     Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$, 
      Control`CommonDump`$DUMMY$, Control`CommonDump`$DUMMY$}}, Identity, 
    Automatic, 1, 1, 4, 1, {}, {False, False}, False, Automatic, None, {",", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               SubscriptBox["x", "1"], "[", "t", "]"}], ",", "0"}], "}"}], 
         ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               SubscriptBox["x", "2"], "[", "t", "]"}], ",", "0"}], "}"}], 
         ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               SubscriptBox["x", "3"], "[", "t", "]"}], ",", "0"}], "}"}], 
         ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               SubscriptBox["x", "4"], "[", "t", "]"}], ",", "0"}], "}"}]}], 
       "}"}], ",", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{
           RowBox[{"u", "[", "t", "]"}], ",", "0"}], "}"}], "}"}], ",", 
     "Automatic", ",", "t"}}, {}},
  "StateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{#, #2, #3, #4, #5}, {#6, #7, #8, #9, #10}, {#11, #12, #13, \
#14, #15}, {#16, #17, #18, #19, #20}, {#21, #22, #23, #24, #25}}, 
        AllowedDimensions -> {5, 5}, 
        GridBoxDividers -> {"Rows" -> {False, False, False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}, 
          "Columns" -> {False, False, False, False, 
            Directive[
             GrayLevel[0], 
             GrayLevel[0.6]], {False}, False}}, DefaultBaseStyle -> 
        "SystemsModelGrid00"], ")"}], #26, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalS]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None], MultilineFunction -> None], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"StateSpaceModel", "[", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{1, 4}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{6, 9}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{11, 14}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{16, 19}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{5, 5}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{10, 10}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{15, 15}, ","], "}"}], ",", 
         RowBox[{"{", 
           TemplateSlotSequence[{20, 20}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{21, 24}, ","], "}"}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           TemplateSlotSequence[{25, 25}, ","], "}"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               SubscriptBox["x", "1"], "[", "t", "]"}], ",", "0"}], "}"}], 
         ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               SubscriptBox["x", "2"], "[", "t", "]"}], ",", "0"}], "}"}], 
         ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               SubscriptBox["x", "3"], "[", "t", "]"}], ",", "0"}], "}"}], 
         ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               SubscriptBox["x", "4"], "[", "t", "]"}], ",", "0"}], "}"}]}], 
       "}"}], ",", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{
           RowBox[{"u", "[", "t", "]"}], ",", "0"}], "}"}], "}"}], ",", 
     "Automatic", ",", "t", ",", "SamplingPeriod", "->", 
     RowBox[{#26}], ",", "SystemsModelLabels", "->", "None", "]"}]& ),
  Tooltip->StateSpaceModel]], "Output",
 CellChangeTimes->{
  3.642955584068959*^9, 3.642955756674272*^9, 3.642957265097569*^9, 
   3.642957390000331*^9, 3.642957501241023*^9, 3.642958617553323*^9, 
   3.6429586606797028`*^9, 3.642958695844831*^9, 3.642959037382208*^9, 
   3.642962157910074*^9, 3.642963186707575*^9, 3.6429632436712933`*^9, {
   3.6429678337389107`*^9, 3.642967851856462*^9}, 3.642986219188673*^9, 
   3.642987256736519*^9, 3.642991411922374*^9, 3.642991502395935*^9, 
   3.7939216793175983`*^9, 3.7939218784839163`*^9, 3.793921976178194*^9, 
   3.793992222241413*^9, 3.823229023038423*^9},
 CellLabel->
  "Out[2736]=",ExpressionUUID->"2f88a138-7273-4cb1-b149-4574cd0f2cf6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Kappa]lin", "=", 
  RowBox[{
   RowBox[{"StateFeedbackGains", "[", 
    RowBox[{"sys", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.642955609139367*^9, 3.642955623665882*^9}},
 CellLabel->
  "In[2737]:=",ExpressionUUID->"f7eca19a-aad0-4c66-9e99-2a90f62daace"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "6"}], ",", 
    RowBox[{"-", "4"}], ",", "3", ",", "4"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.642955614579685*^9, 3.642955624188243*^9}, 
   3.642955756834427*^9, 3.6429572652626*^9, 3.642957390063525*^9, 
   3.642957501311928*^9, 3.642958617734334*^9, 3.642958660730206*^9, 
   3.6429586959027977`*^9, 3.642959037446212*^9, 3.6429621579705276`*^9, 
   3.642963186771332*^9, 3.642963243727803*^9, {3.642967833810028*^9, 
   3.642967851912265*^9}, 3.642986219237818*^9, 3.642987256797387*^9, 
   3.642991414771521*^9, 3.6429915024885817`*^9, 3.793921679391592*^9, 
   3.793921878526566*^9, 3.793921976188731*^9, 3.793992222310075*^9, 
   3.823229023101769*^9},
 CellLabel->
  "Out[2737]=",ExpressionUUID->"970a4424-6841-40fe-bff5-93f4db995148"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"csyslin", "=", 
  RowBox[{
   RowBox[{"SystemsModelStateFeedbackConnect", "[", 
    RowBox[{"asys", ",", "\[Kappa]lin"}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.642955635164398*^9, 3.6429556370968723`*^9}, {
   3.64295569211434*^9, 3.642955702447908*^9}, {3.642957219878461*^9, 
   3.6429572373145447`*^9}, {3.642958319429893*^9, 3.6429583208879967`*^9}, 
   3.642958691424478*^9},
 CellLabel->
  "In[2738]:=",ExpressionUUID->"5d88acae-9619-4e3a-b78e-51925a793101"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{
     SubscriptBox["x", "2"], "[", "t", "]"}], 
   RowBox[{
     RowBox[{"-", 
       RowBox[{"Sin", "[", 
         RowBox[{
           SubscriptBox["x", "1"], "[", "t", "]"}], "]"}]}], "-", 
     RowBox[{
       SubscriptBox["x", "1"], "[", "t", "]"}], "+", 
     RowBox[{
       SubscriptBox["x", "3"], "[", "t", "]"}]}], 
   RowBox[{
     SubscriptBox["x", "4"], "[", "t", "]"}], 
   RowBox[{
     RowBox[{"7", " ", 
       RowBox[{
         SubscriptBox["x", "1"], "[", "t", "]"}]}], "+", 
     RowBox[{"4", " ", 
       RowBox[{
         SubscriptBox["x", "2"], "[", "t", "]"}]}], "-", 
     RowBox[{"4", " ", 
       RowBox[{
         SubscriptBox["x", "3"], "[", "t", "]"}]}], "-", 
     RowBox[{"4", " ", 
       RowBox[{
         SubscriptBox["x", "4"], "[", "t", "]"}]}]}], "0", "0", "0", "1", 
   RowBox[{
     SubscriptBox["x", "1"], "[", "t", "]"}], "0", 
   RowBox[{
     SubscriptBox["x", "1"], "[", "t", "]"}], 
   RowBox[{
     SubscriptBox["x", "2"], "[", "t", "]"}], 
   RowBox[{
     SubscriptBox["x", "3"], "[", "t", "]"}], 
   RowBox[{
     SubscriptBox["x", "4"], "[", "t", "]"}], 
   InterpretationBox["\[Null]", Automatic], 
   InterpretationBox["\[Null]", None], {
   4, 1, 1, 1, {1, 1}, None, False, False, False, False, "Automatic", 
    "t"}, {}},
  "AffineStateSpaceModelFull",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    GridBox[{{
       SubsuperscriptBox[
        RowBox[{"(", 
          
          GridBox[{{#11, #, #5}, {#12, #2, #6}, {#13, #3, #7}, {#14, #4, #8}, \
{#15, #9, #10}}, GridBoxDividers -> {"Rows" -> {False, False, False, False, 
               Directive[
                GrayLevel[0], 
                GrayLevel[0.6]], False}, "ColumnsIndexed" -> {2 -> Directive[
                 GrayLevel[0], 
                 GrayLevel[0.6]], 3 -> Directive[
                 GrayLevel[0], 
                 GrayLevel[0.6]]}}, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
           DefaultBaseStyle -> "SystemsModelGrid01"], ")"}], #16, 
        ButtonBox[
         GraphicsBox[{
           
           RectangleBox[{0, 0}, DefaultBaseStyle -> 
            "SystemsModelSuperscript"], 
           InsetBox[
            StyleBox[
            "\[ScriptCapitalA]", DefaultBaseStyle -> 
             "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
         ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
           ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
         None]]}}], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"AffineStateSpaceModel", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               TemplateSlotSequence[{1, 4}, ","]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", #5, "}"}], ",", 
               RowBox[{"{", #6, "}"}], ",", 
               RowBox[{"{", #7, "}"}], ",", 
               RowBox[{"{", #8, "}"}]}], "}"}], ",", 
           RowBox[{"{", #9, "}"}], ",", 
           RowBox[{"{", 
             RowBox[{"{", #10, "}"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
         RowBox[{
           TemplateSlotSequence[{11, 14}, ","]}], "}"}], ",", "Automatic", 
       ",", 
       RowBox[{"{", #15, "}"}], ",", "t", ",", 
       RowBox[{"SamplingPeriod", "->", #16}]}], "]"}]& ),
  Tooltip->AffineStateSpaceModel]], "Output",
 CellChangeTimes->{
  3.64295570337171*^9, 3.642955756970841*^9, {3.642957220843093*^9, 
   3.642957265380899*^9}, 3.642957390281809*^9, 3.642957501476363*^9, 
   3.642958321445039*^9, 3.642958617865861*^9, 3.6429586607968893`*^9, 
   3.6429586960331173`*^9, 3.642959037578683*^9, 3.642962158106587*^9, 
   3.642963187003573*^9, 3.642963243949411*^9, {3.642967833946097*^9, 
   3.64296785205221*^9}, 3.642986219380518*^9, 3.642987256924778*^9, 
   3.642991418432652*^9, 3.642991502594823*^9, 3.793921679472761*^9, 
   3.7939218786013203`*^9, 3.7939219762647743`*^9, 3.793992222380499*^9, 
   3.823229023173147*^9},
 CellLabel->
  "Out[2738]=",ExpressionUUID->"27767ac4-a33d-434a-a579-1c16668d502f"]
}, Open  ]],

Cell["Output and graphics", "Text",
 CellChangeTimes->{{3.642884106832645*^9, 3.642884122357831*^9}, {
  3.642884288114716*^9, 3.642884291385352*^9}, {3.6429555561087017`*^9, 
  3.642955559107579*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"4c393e14-e7a3-4ea7-9d85-ec9d040e2de1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"uamp", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"tend", "=", "50"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yopen", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"asys", ",", 
     RowBox[{"uamp", " ", 
      RowBox[{"UnitStep", "[", "t", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"yclosed", "=", 
   RowBox[{"OutputResponse", "[", 
    RowBox[{"csys", ",", 
     RowBox[{"uamp", " ", 
      RowBox[{"UnitStep", "[", "t", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ylin", "=", " ", 
    RowBox[{"OutputResponse", "[", 
     RowBox[{"csyslin", ",", 
      RowBox[{"uamp", " ", 
       RowBox[{"UnitStep", "[", "t", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"uamp", " ", 
      RowBox[{"UnitStep", "[", "t", "]"}]}], ",", "yopen", ",", "yclosed", 
     ",", "ylin"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"LightGray", ",", "Dashed"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Thick"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Thick"}], "}"}], ",", 
      RowBox[{"{", "Green", "}"}]}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.642884487256102*^9, 3.642884555921762*^9}, 
   3.642947875864357*^9, {3.6429511995814257`*^9, 3.6429512018594*^9}, {
   3.642954014462565*^9, 3.642954017269767*^9}, {3.6429540523588467`*^9, 
   3.642954163601305*^9}, {3.642954195700091*^9, 3.642954280214479*^9}, {
   3.642954728449708*^9, 3.6429547531410646`*^9}, {3.642955203617359*^9, 
   3.642955217971002*^9}, {3.6429553965468197`*^9, 3.642955494938095*^9}, {
   3.642955724479303*^9, 3.6429557726078157`*^9}, {3.642956210708062*^9, 
   3.642956308607827*^9}, {3.642956985917588*^9, 3.642957064150482*^9}, {
   3.642957271569429*^9, 3.642957467028221*^9}, {3.642957527047207*^9, 
   3.642957654359288*^9}, {3.642957693332183*^9, 3.642957709944512*^9}, 
   3.642957954813209*^9, 3.6429632383004704`*^9, {3.642964933372781*^9, 
   3.642964940688919*^9}, {3.6429649711449738`*^9, 3.642965044660715*^9}, {
   3.642967829078129*^9, 3.642967866593289*^9}, {3.642967898416535*^9, 
   3.642967958454441*^9}, 3.642987249950612*^9, {3.642989107859644*^9, 
   3.6429891706208973`*^9}, {3.642991295474468*^9, 3.642991302001916*^9}, {
   3.642991431856949*^9, 3.642991444740376*^9}},
 CellLabel->
  "In[2739]:=",ExpressionUUID->"c91db637-9958-404d-9da9-7da2d0fcb503"],

Cell[BoxData["50"], "Output",
 CellChangeTimes->{{3.6428844957315187`*^9, 3.642884556452125*^9}, 
   3.642885107901978*^9, 3.6428854079942713`*^9, 3.64288599147884*^9, 
   3.6429462315587473`*^9, 3.642946375775712*^9, {3.64294646642127*^9, 
   3.6429465085946703`*^9}, {3.6429466323377438`*^9, 3.6429466939544563`*^9}, 
   3.6429478766733913`*^9, 3.6429486505715523`*^9, 3.642948790624981*^9, 
   3.642949440574255*^9, 3.642950335025199*^9, 3.6429504074840803`*^9, 
   3.642950548723147*^9, 3.6429508076720953`*^9, 3.642950977082683*^9, 
   3.6429510298013678`*^9, 3.642951202326791*^9, {3.642954015088945*^9, 
   3.642954017722823*^9}, 3.6429540737831593`*^9, {3.642954131352723*^9, 
   3.6429541532358522`*^9}, {3.642954192088112*^9, 3.642954280696253*^9}, {
   3.642954324392941*^9, 3.6429543637592163`*^9}, {3.6429547324998713`*^9, 
   3.6429547536816473`*^9}, {3.6429547904901114`*^9, 3.642954853340908*^9}, 
   3.642954907740782*^9, {3.6429552265345783`*^9, 3.642955241970757*^9}, 
   3.642955381012136*^9, {3.642955422767852*^9, 3.6429554960060253`*^9}, {
   3.642955751975677*^9, 3.6429557733824377`*^9}, {3.642956211582106*^9, 
   3.642956309237088*^9}, {3.642956994414907*^9, 3.642957065223928*^9}, {
   3.6429572654916267`*^9, 3.6429574675543957`*^9}, {3.642957501568544*^9, 
   3.642957654866517*^9}, {3.642957694068378*^9, 3.6429577104760017`*^9}, 
   3.642957955668985*^9, 3.6429586179535723`*^9, 3.6429586612627077`*^9, 
   3.642958696123199*^9, 3.642959037667644*^9, 3.64296215823248*^9, 
   3.642963187119412*^9, 3.642963244104889*^9, {3.642964974705103*^9, 
   3.642965044997439*^9}, {3.6429678340119143`*^9, 3.642967866991646*^9}, {
   3.642967899004367*^9, 3.64296795887706*^9}, 3.642986219430551*^9, 
   3.642987256998596*^9, {3.64298910839403*^9, 3.642989171234948*^9}, {
   3.6429912978434267`*^9, 3.642991303643764*^9}, 3.642991447229323*^9, 
   3.642991502650141*^9, 3.793921679530733*^9, 3.793921878647484*^9, 
   3.793921976322501*^9, 3.793992222432291*^9, 3.823229023219411*^9},
 CellLabel->
  "Out[2740]=",ExpressionUUID->"4fd5ec09-62df-4dfa-a105-9ff8ec44156e"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0.85], AbsoluteThickness[1.6], Opacity[1.], 
      Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQrdT/d/E8uY12DGDwwP7UxNuFL9Lv28P4XnvZ/Z6l
v4fzz/KacbLEMjjA+E79rgeW+3PA+an6v3gNeQXgfF/N1I9i7iJw/qYrtaUn
LSTgfGshrfUs9TJwfvrvSXOXRijA+fnHnhuv91WC87ui2FT/5qjA+cnHq9MM
M9Tg/IPskoHZkRpwvqFgw7SXJVpwfsJnWx2/HB04f+G8ozLfe/Xg/M19Vrcv
BRnA+SW7bAPm+hjC+ftPLf3UGW0E52e6W+7NjDCG8+esMNyanWUC50/8vLex
oNwUzn+2qrQso8gMzj/iNmlGU5M5nM/of+tRf4MFnM/guI1xQaUlnN8h/t33
UrsVnF8QlXzoe7M1nP+w0STFfqoNnC8yeeatzoW2cP4yAa3K47PtEOFVJO+q
vtoezp+nsEDGNsQBzt9b84sh4wKCr+jN/kc53BHO33Jes/vmFQS/59g/A4VY
Jzh/cvHLrIQ7CH6NqBy/UqQznL9Sk/VUyQMEn+0Lo+TBOBc4f7nBxrp5zxF8
zaRVfn9zXeH82547N4W+RvAvLa7StS92g/N/bA60UfqE4P/fUbS1Lc8dzvc2
cHOt+YrgH4/Vz8wu9oDzrdgDNmzdieCv21Dw/f9/BB8Abm7tSg==
       "]]},
     Annotation[#, "Charting`Private`Tag$1198773#1"]& ], 
    TagBox[
     {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwsV3c81e/7RkhRyS6SHRJHZtZ9cyhR6oOE0FLJKCSrjIaUhBAlq2Gm7D3e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       "]]},
     Annotation[#, "Charting`Private`Tag$1198773#2"]& ], 
    TagBox[
     {RGBColor[0, 0, 1], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwt1nc4V28bAHC7YeQnhLL39sUXWc8tM0JTIqUiWxFlJxRJskIIZYVsLUWR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       "]]},
     Annotation[#, "Charting`Private`Tag$1198773#3"]& ], 
    TagBox[
     {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwtlmc4Foz/xYmKRHaSJKkoIxFC9/eb3ONRRshj71V22StFUiSjBz1Jyijy
2CsKaSlRRrbsHe5hR379r+t/3pzrXNfnvDjvzgFbD32HLUxMTFzMTEz/5+L3
NjLSRIsITP+vCjap/W7O94Db2E9GiYWH8MY/P1PS+TEY8ThrWOsaEBKVRs05
Y59BvnT3I/nffoQPx72ctjkXQGRgYduHpgRCsMBm5WZ6CVRW95vFFmUTkhKI
hPW7FaDVeO6W65kKQsGumLcrgdUw3a1us0PrPaEhppWy6FQL8/5fqqqoLQRq
xM4J/9w38NshUemaXR8h5G2B1HL6W+jzv13JZjVG2LHFwNUn+T3UCPr3+0/P
EZJwKZ9x9yO8yda88T19kXDw2gOaV8QnYLk4MhLlvkEofK2uSA1sBAP58q5f
d1lAfX3A192rCQofXhFi9WGHT6rhL386fYVh4Xw8S+aGF+p8oScLvkEfF/vw
f6H8QOu1f+yd2wJlJVeFv13ZAypB5XUlWa1w/NubrzuU9kOoMNswPb0Nfssk
mGTPisO7lyYsJ1LbgZBVmNFXdRh2mLyQ8Er+DnVh4e3uO4+B3so6sTChA/j7
eq8r/ZSD5GQdp/m7nXDIjJohVHwCfiilR8ne7gL/cMozxdqTINFBy3GL6AY3
JYwNFT8Fl33ONuZd64GqvrQJ9iF1KOT/5+dMYC/0lH9uXLqGsFQyznnMtw+0
znXritZrwGkDFbnLXv0glB8/EnGKCJ/je70mnQYgRifd40SrFkSlJH1KlB+E
F+5+icEr2iDtDKYKBYNQU+QXsb1AD74qT063Sg+BxK8QrpIb+nBle3zQldwh
YBGjOQb6G4JA56mdvJLDsLV35WJsvBFUZg+nFmUNQ0rBUJnoV2P4TVSsoaaP
QIdl3ZrHKwt4ItCvEyc6CuG5kVdPK1uD5tjNAbnUUQhRadlozLSB6IhOJo/k
MXjv3xpbVWsPsoZh8VwC45D0rivvmLsjtB6UEs9PGAcN6fV6koIzCL0NPDt7
dwL+tuuJv87iCtUJB9tjOCbh08+Yyw93uYOl7Rd76duTsK9xW9MRYU/IZBaN
dImYAoWjLvQX9leA3PJBkGPLNPgeYHMnPboK0+kez3KvTcMnwkAex4g3yOOb
hqnAGVA3eUgbSvKD9l2XTW6vzMC72F9XjLYGgP8A77Sk70/gYuW6WHE9EGpC
7TmcvWaBh8/n3mRmCGi93q4z7jQPLbRd4q/O3wD5TdtFQeo8tA4QOAP1wyFG
zKr5oDoV2JVDfgnZRIC3bZWP4Tsq+LtPLeKDSNAc93xX1k6DzCZOyQnfaFC5
JSrULEQHnY4QLYf3MSAt+cVl3JwOfW1taQr7YoHv8hG+3WN02J/7y+SqdxwM
z/bb+C8yoGxLhVCGfyJ0xEaXxZ1agJAvZsbXiPfhs9wp9pyQBZC5EO4quPsf
KPa6X9i9dRHGIub+8m5IguuLWpuqgkuw7fzLgma7f0FsoyJ1Q2kFyjgP7hc/
/QT40xyoAkErYNGrPt3Z8ATYgE9TtnYFOpTWzJqMnsJ8mPuMJXkVbgpszjgH
ZEAN6yHVur/X4OtUcQu9KwssdiZ03vBfh9EqiQaVjVzQ+w+OPXy1DvqXi391
5b4ATZ3Z0BKmDbgnwnB1Mc0D6TjK4dGoDXA9WT6jU/sfrPNtehMf/AYugXPG
xbqF0MSpxM5qwYR3aqSU75iUQOs53pTmYCYMdLRMq6goga7bc4cfpDKhSXuK
W5xgKYxufaYp28eETSLGCSodpbC+sTvM2IwZs0202XgsyuHo3OpSnskWpIca
eGhFvoSo5tejF41Y8eN/+qfWhOpA4x6x7pkuGw7KmnNVHv4IYVqlOa3ubMgk
bnerxvIj1Gw9mLhxlw1dDIde1yd9BNVgJkeDL2x4imfcs25bAyhcqubYpLAj
0Smlwme8ASTOyv9tpLEDawqiHjEyPsO2ZZE51pM7sX9tPVubpxk0i6M75Qx3
os5UzQEDcjPccFurM726Ez/wBzKrhzTD75HOxMKinXj4U3xi2WQzLH9LOGUu
y4nAEfFVueYrTOay3Sw5woVnMmdkQou+gYPcGqc8Jzf2X3Y5Jk5phfO9t7KE
RLnR/87quSXbVlC8JXCaSY4ba7x4lYtCWoF14LjrVz1urD40U9VT3ApPY50+
u93nxvCeW83Le9tgYLY9MncvD1qpuTiqTbWBSV7B5sGjvOj04C9ZNY/vgMan
kznUePGW7x1KfuR3kGRtlGWc40VnsuXfW9O+w4rZuEW9Gy8KGAZesPryHZI4
9r2yLuLFyx9+5Ncf6YC2y3f8H6nwYd+nD2/+6u4AbSkHmiCZH0M3jv1IPdIF
a9E+1f1G/JjZqBZAUu2C53M3b2Y68iPnU93mrvNdwFqavedEJD/K9RyZr/Dq
girC5Bnt9/wo0LiHzbaqCw4buiSEnxXAFXXeIF9yNzBd81KggiC235+zUr7Q
A/lD1zfKdQUxT9F8Yr9ND5hpJnwMsRLE2gKbYYZnD5Szl5hxXBPEHayfkyzj
esD1/kL44RpB1KfMl55p7oHuHL92c/XduNoSq3qR1AvF7SE+n1SE0PjlZoyT
ZB88v2lvO/yXEJ7vxhwe5T5IUzqn+8tUCAePpXg/I/bBnRQhKZkQIXxg1fQo
ybYP7MxL+uLeCOHnIJa+yId9wD86edZYaw+2N8S9a2TvB1+GAe+EmTCqecuX
NXT1g2um6uamqzAaK5c+PTLWD7YXD/wUChXGs9dL1Hxp/aBTMfdeK10YH7/m
mRhm/wFHgm4H5I8K49onP7uNUz+ga0vtoI/bXqQw8+vpJf8ANd6jBazXRLCZ
+6PScfIANDObfmq6J4JWBsYX71wYAGva7ZGk9D95amNLl9kARHyb2i1VL4Iy
Ig2XdTz/8LE5Ydpb92HQQgMjJ+UPzyGlnxS9D/PDqcpyE394VsnFIymieCAx
z5eFMAhOvxIeZRmLYany7uc33w3CfZ2fbwOsxXD1kgwebxiEuifEaW1nMWTV
LvXqbBwEIcqK0pKfGEr776/Y2zYIDfctvpGSxXAjq8oheGgQpGQlWSa/i6H4
DIpnbAzCjPVr56MGB3BhSYuWozAEHh8mFAq0xbHeqq323+QhqMM8F2kjcVz+
ltXV8u8QcFd7ZuRYiuOaRNmZbWlDUFiwypvpIY5vv0QLOGUOAT2Fg54SL45p
oeJq7EVD4OsiV3jjuziKrOyVbPs0BMHcftJGFgeRi6JilrI6BHdMtx3acJXA
MjHvvGz9YbD7GOQo73wY6WT3mP6xYXizfc8FFxNJ9KwMu+BsNwLyPGFJU95H
saDnpcmL3hGwZpyW1nGVxn8KwkoBR+FJ2nuR5buymGeqaGKQMQolsaq9rfrH
MeqmyWbK+ih4V53We3ReHte2vRk7pDUGtZ+z6LfNTqBvpA+L5oMxuEQ+9fqS
sQLOeNSTjAfGIPW5fJnLZUUcT/vVxyY5DvGM19c9/U6id2PC4R7XcRjP9fF1
vqKEB9avpRm/GId3pISUGzeU8U5ydGLj7Dgw6/YM3wtTwVTdUne+YxPAdKac
OT3gFC7MO53vcZyAqN3L2q23VLG5q7X067MJ8DS1q18OV0MUlTnMGJ2AoeuK
9vCPOh6MMpLQkJwE/sQHPbefnEZlgU3BSZdJyOY+GvDxIQEL5PnEx/Im4c2V
/cQjLwAfng+f3bY0CWli6SKnDRFd8psdnU5PwevgNSbnb4j7f74KYkROwYFz
29cP/n0GRSL3WD3pnYLSr1LR3e1nUOWHb53M8WmI+fD7uJiFBh7Qtq06kTgN
iVenLlv3aaC+9r1f/CvTECwgukvc5CyuZXqczrKfgRyprZ+9B89ihscHluqJ
Gdi2wLznjaUm6ihs98nw+gnPjheFpk1o4vNGw5w0kVmQss3V2XAj4nadHpek
wVloeKRaSPcg4o9ZzVeFI7Pg2P2ZZ9KLiOEHe3c0jc9Cpt5Me6sPEQdtlnM5
ZmdBDKTNnocQcT1RS+HJ6iwIiuQ7Gdwl4p05NlM5vjnY0lEUlpNHxCUL7WOT
5Dno/etl8cUZIpLtw1qMK+dAQzfT2GeWiLUCdgcuvpqDXMN7v+/PE1GGvnnH
sG4OAq0ctNoZRDSxia82b5gDYR+eYf11Iu69p8CS2DUHxumXePQ4SdghpFr5
7+ocdCzt8dSSI2Hxq/R2RcKf35MRKANXSUh6LO6d1joPvEzlL1V9SPi90TpE
vnMeDMxpRCU/Ehr+u6zV0DsP7fzOljJBJEyUpZCYx+ah8+bFe3vDSeipZ0R5
sjwPfU7HacsJJEzLZmL/ykWFsWPjpYXFJDQ6o6BsrESFw1EHzuSVkjD8dYfY
iAoVHEfNm56Vk7Dqm5+mpxoVJlPbxtKqSFjmE0yMRypMc74RvFtPwls3m8Pn
tKgwN//Q/1IrCTutu9uErKmwUnJBXZxOQmZOho1mDBV2qig18y2QMCemKZnr
HhXEXglbb10i4ZyQhllvPBUo70bCJ1f/9CslHwQnU+FBu09jPjMZSWvmhj+e
UkF18YGpGg8Zj76vFROvokKw0rC/4XEyNmk9tfk4TYW4qg87SCfI+Ha/R9/0
LBUyCS9SlRXJSBiedOKhUeELybtOWIWM/1E13jotU2Hf39vYhoCMjAC5naqs
NKjxO5rspkvG5dM/tgeI0mCz8kpZpDsZpTqt6BEXadC3rTj6qScZmR7Wl9uY
0KDKkGZTc4WMtWXDvRoWNPCmenAt+ZJx9KWTI68DDSaPuDk5XCPjHXrWhQlv
GrQmOe3RjCNj/WO3eI9/aJDlbR7CXEzGsCTX0pM9NLhR/9BgXykZ1QxVX+T/
oIE1d6/UqXIylt6qFJYZoYFwnkmHZxUZ9YSzo1V/0iB2xEhusJ6MH3DXQMpv
GvjrXxiqaSOjV69XuasEHc4dJxGDF8n4m39Vud6bDkzfvzN7L5NR5wRDMDuA
DuUBDjUuq3/2XuVjiQulg/jbCGWzDTKG18rI+kbRYe3iWynVrRSUdRkQuJtK
h9wg5Frhp2Ay25H38+/pwP5RtfOqIgVbAuik4X0MqHH5nOiiREHWZtLM44MM
8OY21bNToeBKc52GgxQDBk0CPumrU1C3+DVl+0kGVP6sqJbXpODmCJd17nkG
OPOeTJ83oOCttyFsQSEM+Gghd8nlKgVxy3hH/RgDeO2cqx/5UFApSJDXfpYB
ls5POL/5UdDC0q6G589vX7rCV6wYTEF7af2hBNYFkIhaXtuIoOBz0+5nchIL
EFZcGxOXRMHHvN1v5x0WQHW7XmHZSwqGD97njFhYgMidt7dMVlPQ3Z7r5eLG
ArTw1BsK11AwQ0nCy3/7IjiLKK6G1lOQsHCyskh4EZLlhTQojRT0mY0sWTmz
CAtmg209fRQsYFA6WO4vAtrsOcw5QEGxUsGh1LRFiHbU94chClpCi6hWziKI
e70TyRyj4DpHkOBwzSJciHzu4DZHwQBTkjzXzCKkRg9VPKZS0I3jgpDu0iJM
xgnvaKVTMK7FlyObeQnCHsbkKy1T8BDv6p5koSX4kv6e6dIqBZnJlAp5iSXY
nf1b/+EvCnZsTbEfkVsC2xfKWU0bFPzxYsg2T20J8gs9lzc3KaifJMqIIS/B
/wChXRfq
       "]]},
     Annotation[#, "Charting`Private`Tag$1198773#4"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.6428844957315187`*^9, 3.642884556452125*^9}, 
   3.642885107901978*^9, 3.6428854079942713`*^9, 3.64288599147884*^9, 
   3.6429462315587473`*^9, 3.642946375775712*^9, {3.64294646642127*^9, 
   3.6429465085946703`*^9}, {3.6429466323377438`*^9, 3.6429466939544563`*^9}, 
   3.6429478766733913`*^9, 3.6429486505715523`*^9, 3.642948790624981*^9, 
   3.642949440574255*^9, 3.642950335025199*^9, 3.6429504074840803`*^9, 
   3.642950548723147*^9, 3.6429508076720953`*^9, 3.642950977082683*^9, 
   3.6429510298013678`*^9, 3.642951202326791*^9, {3.642954015088945*^9, 
   3.642954017722823*^9}, 3.6429540737831593`*^9, {3.642954131352723*^9, 
   3.6429541532358522`*^9}, {3.642954192088112*^9, 3.642954280696253*^9}, {
   3.642954324392941*^9, 3.6429543637592163`*^9}, {3.6429547324998713`*^9, 
   3.6429547536816473`*^9}, {3.6429547904901114`*^9, 3.642954853340908*^9}, 
   3.642954907740782*^9, {3.6429552265345783`*^9, 3.642955241970757*^9}, 
   3.642955381012136*^9, {3.642955422767852*^9, 3.6429554960060253`*^9}, {
   3.642955751975677*^9, 3.6429557733824377`*^9}, {3.642956211582106*^9, 
   3.642956309237088*^9}, {3.642956994414907*^9, 3.642957065223928*^9}, {
   3.6429572654916267`*^9, 3.6429574675543957`*^9}, {3.642957501568544*^9, 
   3.642957654866517*^9}, {3.642957694068378*^9, 3.6429577104760017`*^9}, 
   3.642957955668985*^9, 3.6429586179535723`*^9, 3.6429586612627077`*^9, 
   3.642958696123199*^9, 3.642959037667644*^9, 3.64296215823248*^9, 
   3.642963187119412*^9, 3.642963244104889*^9, {3.642964974705103*^9, 
   3.642965044997439*^9}, {3.6429678340119143`*^9, 3.642967866991646*^9}, {
   3.642967899004367*^9, 3.64296795887706*^9}, 3.642986219430551*^9, 
   3.642987256998596*^9, {3.64298910839403*^9, 3.642989171234948*^9}, {
   3.6429912978434267`*^9, 3.642991303643764*^9}, 3.642991447229323*^9, 
   3.642991502650141*^9, 3.793921679530733*^9, 3.793921878647484*^9, 
   3.793921976322501*^9, 3.793992222432291*^9, 3.8232290232647667`*^9},
 CellLabel->
  "Out[2743]=",ExpressionUUID->"7debeffa-e1e0-44cd-926a-564228e28563"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"controller", "=", 
  RowBox[{
   RowBox[{"\[ScriptCapitalF]", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<OriginalSystemFullController\>\"", ",", "\[Kappa]"}], "}"}],
     "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.6428854123199797`*^9, 3.642885424374075*^9}, {
  3.6429587267142487`*^9, 3.642958727168612*^9}},
 CellLabel->
  "In[2744]:=",ExpressionUUID->"bf74e6a6-8bf6-4c29-88a2-446299930cf9"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{
     RowBox[{"5", " ", 
       RowBox[{"Sin", "[", 
         RowBox[{
           SubscriptBox["x", "1"], "[", "t", "]"}], "]"}]}], "-", 
     RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"Sin", "[", 
         RowBox[{"2", " ", 
           RowBox[{
             SubscriptBox["x", "1"], "[", "t", "]"}]}], "]"}]}], "+", 
     SubscriptBox["\[FormalU]", "1"], "-", 
     RowBox[{
       RowBox[{"(", 
         RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"Cos", "[", 
             RowBox[{
               SubscriptBox["x", "1"], "[", "t", "]"}], "]"}]}], ")"}], " ", 
       RowBox[{
         SubscriptBox["x", "1"], "[", "t", "]"}]}], "+", 
     RowBox[{"4", " ", 
       RowBox[{"Cos", "[", 
         RowBox[{
           SubscriptBox["x", "1"], "[", "t", "]"}], "]"}], " ", 
       RowBox[{
         SubscriptBox["x", "2"], "[", "t", "]"}]}], "-", 
     RowBox[{
       RowBox[{"Sin", "[", 
         RowBox[{
           SubscriptBox["x", "1"], "[", "t", "]"}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{
          SubscriptBox["x", "2"], "[", "t", "]"}], "2"]}], "-", 
     RowBox[{"4", " ", 
       RowBox[{
         SubscriptBox["x", "3"], "[", "t", "]"}]}], "+", 
     RowBox[{
       RowBox[{"Cos", "[", 
         RowBox[{
           SubscriptBox["x", "1"], "[", "t", "]"}], "]"}], " ", 
       RowBox[{
         SubscriptBox["x", "3"], "[", "t", "]"}]}], "-", 
     RowBox[{"4", " ", 
       RowBox[{
         SubscriptBox["x", "4"], "[", "t", "]"}]}]}], 
   InterpretationBox["\[Null]", Automatic], 
   InterpretationBox["\[Null]", None], {
   0, 5, 1, 1, None, None, False, False, False, 
    RowBox[{"{", 
      RowBox[{
        SubscriptBox["\[FormalU]", "1"], ",", 
        RowBox[{
          SubscriptBox["x", "1"], "[", "t", "]"}], ",", 
        RowBox[{
          SubscriptBox["x", "2"], "[", "t", "]"}], ",", 
        RowBox[{
          SubscriptBox["x", "3"], "[", "t", "]"}], ",", 
        RowBox[{
          SubscriptBox["x", "4"], "[", "t", "]"}]}], "}"}], "Automatic"}, {}},
  
  "NonlinearStateSpaceModelMinimal",
  BaseStyle->{NumberMarks -> False},
  DisplayFunction->(TagBox[
    SubsuperscriptBox[
     RowBox[{"(", 
       GridBox[{{
          TooltipBox[
           StyleBox[
            StyleBox[
            "\[FilledSmallSquare]", "SystemsModelMinimalElement"]], #]}}, {}, 
        GridBoxDividers -> {"Rows" -> False, "Columns" -> False}, 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
        DefaultBaseStyle -> "SystemsModelGrid00"], ")"}], #3, 
     ButtonBox[
      GraphicsBox[{
        RectangleBox[{0, 0}, DefaultBaseStyle -> "SystemsModelSuperscript"], 
        InsetBox[
         StyleBox[
         "\[ScriptCapitalN]", DefaultBaseStyle -> 
          "SystemsModelSuperscript"], {0.5, 0.5}]}, ImageSize -> 20], 
      ButtonFunction :> Control`Typesetting`SystemsModelTypesetToggle[
        ButtonNotebook[], FE`CMObj], Evaluator -> Automatic, Appearance -> 
      None]], 
    EventHandlerTag[{"MouseEntered" :> {FE`CMObj = MathLink`CallFrontEnd[
          FrontEnd`Value[
           FEPrivate`Self[]]]}, PassEventsDown -> True, PassEventsUp -> 
      True}]]& ),
  InterpretationFunction->(RowBox[{"NonlinearStateSpaceModel", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{
           RowBox[{"{", "}"}], ",", 
           RowBox[{"{", #, "}"}]}], "}"}], ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", 
         RowBox[{
           SubscriptBox["\[FormalU]", "1"], ",", 
           RowBox[{
             SubscriptBox["x", "1"], "[", "t", "]"}], ",", 
           RowBox[{
             SubscriptBox["x", "2"], "[", "t", "]"}], ",", 
           RowBox[{
             SubscriptBox["x", "3"], "[", "t", "]"}], ",", 
           RowBox[{
             SubscriptBox["x", "4"], "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", #2, "}"}], ",", "Automatic", ",", 
       RowBox[{"SamplingPeriod", "->", #3}]}], "]"}]& ),
  Tooltip->NonlinearStateSpaceModel]], "Output",
 CellChangeTimes->{
  3.642885164114174*^9, {3.6428854082030563`*^9, 3.6428854253024883`*^9}, 
   3.642885991760543*^9, 3.642946231827722*^9, 3.642946376059284*^9, {
   3.6429464667192707`*^9, 3.6429465089099092`*^9}, {3.6429466326457663`*^9, 
   3.642946694224215*^9}, 3.642948650621518*^9, 3.642948790672333*^9, 
   3.642949440623782*^9, 3.642950335167575*^9, 3.642950407530786*^9, 
   3.642950548848516*^9, 3.642950807741157*^9, 3.64295097714182*^9, 
   3.642951029924347*^9, 3.642951206672024*^9, {3.642954324421392*^9, 
   3.642954363818821*^9}, {3.642954790522192*^9, 3.642954853403488*^9}, 
   3.6429549078608513`*^9, {3.6429552266019382`*^9, 3.642955242036708*^9}, 
   3.642955381143766*^9, 3.642955757096187*^9, 3.6429572655430326`*^9, 
   3.642957390395335*^9, 3.642957501589986*^9, 3.6429586180119877`*^9, 
   3.642958661420311*^9, 3.6429586962754803`*^9, 3.6429587284456472`*^9, 
   3.642959038268836*^9, 3.642962158853606*^9, 3.6429631877356787`*^9, 
   3.642963244721202*^9, {3.6429678347076674`*^9, 3.642967852794094*^9}, 
   3.642986220195459*^9, 3.642987257687846*^9, 3.642991463544505*^9, 
   3.6429915029100246`*^9, 3.793921679698841*^9, 3.79392187884868*^9, 
   3.793921976482533*^9, 3.793992222577259*^9, 3.823229023381687*^9},
 CellLabel->
  "Out[2744]=",ExpressionUUID->"d6f95ad2-1845-4896-9d3c-ce2498b7cfd0"]
}, Open  ]],

Cell["Calculations to check linearizability", "Text",
 CellChangeTimes->{{3.642884106832645*^9, 3.642884122357831*^9}, {
  3.642884288114716*^9, 3.642884291385352*^9}, {3.6429555561087017`*^9, 
  3.642955559107579*^9}, {3.642970389488428*^9, 3.642970394143093*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"6a9f9ab7-0b2f-4c71-8d3c-3cd25b57cd33"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", " ", 
  RowBox[{
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       SubscriptBox["x", "2"], 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Sin", "[", 
          SubscriptBox["x", "1"], "]"}]}], "-", 
        SubscriptBox["x", "1"], "+", 
        SubscriptBox["x", "3"]}], 
       SubscriptBox["x", "4"], 
       RowBox[{
        SubscriptBox["x", "1"], "-", 
        SubscriptBox["x", "3"]}]}
     }], "\[NoBreak]", ")"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.642970498951969*^9, 3.642970605159227*^9}, {
   3.642970764239678*^9, 3.642970765757168*^9}, {3.642970895348648*^9, 
   3.642970908105401*^9}, 3.642970999762225*^9, {3.6429711184645653`*^9, 
   3.642971191974379*^9}},
 CellLabel->
  "In[2745]:=",ExpressionUUID->"44fc2ec9-d78e-4c3a-a821-49ddce9908f7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "2"], ",", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Sin", "[", 
      SubscriptBox["x", "1"], "]"}]}], "-", 
    SubscriptBox["x", "1"], "+", 
    SubscriptBox["x", "3"]}], ",", 
   SubscriptBox["x", "4"], ",", 
   RowBox[{
    SubscriptBox["x", "1"], "-", 
    SubscriptBox["x", "3"]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6429706062258253`*^9, 3.6429707665618*^9, {3.64297089729023*^9, 
   3.642970909270307*^9}, 3.6429710008559933`*^9, {3.642971122188484*^9, 
   3.642971134395309*^9}, {3.642971188828932*^9, 3.642971192344225*^9}, 
   3.642986220837222*^9, 3.642987258283063*^9, 3.6429915029665127`*^9, 
   3.793921679884221*^9, 3.7939218788909883`*^9, 3.793921976521468*^9, 
   3.793992222624408*^9, 3.823229023425783*^9},
 CellLabel->
  "Out[2745]=",ExpressionUUID->"75d5fb4f-8756-4e9d-bbff-8e4da1875157"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vars", " ", "=", " ", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "#"], "&"}], ",", " ", "4"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.642970805216097*^9, 3.642970805277507*^9}, 
   3.6429709824748077`*^9},
 CellLabel->
  "In[2746]:=",ExpressionUUID->"36fffb08-5fcf-495e-9b30-cefbed2dac21"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "1"], ",", 
   SubscriptBox["x", "2"], ",", 
   SubscriptBox["x", "3"], ",", 
   SubscriptBox["x", "4"]}], "}"}]], "Output",
 CellChangeTimes->{3.6429709831208467`*^9, 3.6429711368777027`*^9, 
  3.642986220988339*^9, 3.642987258350464*^9, 3.642991503033792*^9, 
  3.7939216798913393`*^9, 3.793921879017872*^9, 3.793921976638041*^9, 
  3.793992222629693*^9, 3.8232290235502863`*^9},
 CellLabel->
  "Out[2746]=",ExpressionUUID->"1a3671b9-ac0d-4e93-9621-38abfc155bec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"df", "=", 
   RowBox[{"D", "[", 
    RowBox[{"f", ",", 
     RowBox[{"{", "vars", "}"}]}], "]"}]}], ";", 
  RowBox[{"MatrixForm", "[", "df", "]"}]}]], "Input",
 CellChangeTimes->{{3.642970813697855*^9, 3.64297087627466*^9}, {
   3.642970916743416*^9, 3.642970925626721*^9}, 3.642971008370886*^9, {
   3.642986234001904*^9, 3.642986250611384*^9}},
 CellLabel->
  "In[2747]:=",ExpressionUUID->"e1ca97d9-e90b-460f-8601-ed5e05d24abe"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "1", "0", "0"},
     {
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"Cos", "[", 
        SubscriptBox["x", "1"], "]"}]}], "0", "1", "0"},
     {"0", "0", "0", "1"},
     {"1", "0", 
      RowBox[{"-", "1"}], "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.6429708178477182`*^9, 3.642970876775033*^9}, {
   3.642970913300935*^9, 3.642970926079238*^9}, {3.642970991008026*^9, 
   3.6429710088932467`*^9}, 3.642971138799652*^9, 3.642971195000402*^9, {
   3.6429862210697117`*^9, 3.642986252250381*^9}, 3.642987258421686*^9, 
   3.642991503135252*^9, 3.7939216799253483`*^9, 3.793921879028431*^9, {
   3.7939219500371647`*^9, 3.793921976646069*^9}, 3.793992222662424*^9, 
   3.823229023557804*^9},
 CellLabel->
  "Out[2747]//MatrixForm=",ExpressionUUID->"c37103f5-692c-4fef-9fcf-\
2b1b62106143"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0"},
       {"0"},
       {"0"},
       {"1"}
      }], "\[NoBreak]", ")"}], "]"}]}], ";", 
  RowBox[{"adfg", "=", 
   RowBox[{"-", 
    RowBox[{"df", ".", "g"}]}]}], ";", " ", 
  RowBox[{"ad2fg", "=", 
   RowBox[{"-", 
    RowBox[{"df", ".", "adfg"}]}]}], ";", " ", 
  RowBox[{"ad3fg", "=", 
   RowBox[{"-", 
    RowBox[{"df", ".", "ad2fg"}]}]}], ";", "  ", 
  RowBox[{"Wc", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"g", ",", "adfg", ",", "ad2fg", ",", "ad3fg"}], "}"}], ",", 
     "2"}], "]"}]}], ";", " ", 
  RowBox[{"Through", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"MatrixForm", ",", "MatrixRank", ",", "Det"}], "}"}], " ", "[", 
    "Wc", "]"}], "]"}], 
  RowBox[{"(*", " ", 
   RowBox[{"check", " ", "whether", " ", "full", " ", "rank", " ", 
    RowBox[{"(", "linearizable", ")"}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.642986297991308*^9, 3.6429864933565407`*^9}, {
  3.793921823930299*^9, 3.7939218709900827`*^9}},
 CellLabel->
  "In[2748]:=",ExpressionUUID->"80e51de9-d298-475e-a7fd-48a6a8803db4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "1"},
       {"0", "0", 
        RowBox[{"-", "1"}], "0"},
       {"0", "1", "0", 
        RowBox[{"-", "1"}]},
       {
        RowBox[{"-", "1"}], "0", "1", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", "4", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.7939218744166203`*^9, 3.793921879064302*^9}, 
   3.793921976675818*^9, 3.79399222266833*^9, 3.823229023565428*^9},
 CellLabel->
  "Out[2748]=",ExpressionUUID->"c79c0a96-97fb-4c07-9424-fdba954f1c60"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{861, 729},
WindowMargins->{{Automatic, -6}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a22580fe-bb1b-4d57-b33e-8a5b76543732"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 249, 4, 67, "Section",ExpressionUUID->"781a1477-e462-49e0-90f8-170c1e10832e"],
Cell[832, 28, 268, 6, 30, "Input",ExpressionUUID->"99869dda-cdf0-409e-8b3d-b5ed259abf62"],
Cell[CellGroupData[{
Cell[1125, 38, 3210, 82, 178, "Input",ExpressionUUID->"4861b2d6-d4e1-495a-a803-e1f3ccae7b65"],
Cell[4338, 122, 4955, 117, 113, "Output",ExpressionUUID->"42ccb148-821c-422a-81d3-c99a134368e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9330, 244, 451, 9, 52, "Input",ExpressionUUID->"2077cc72-a3da-4852-a8e5-c15fc0764269"],
Cell[9784, 255, 1424, 21, 34, "Output",ExpressionUUID->"7c70a4ad-c114-4b26-a11c-c502458acb65"]
}, Open  ]],
Cell[11223, 279, 241, 4, 51, "Text",ExpressionUUID->"5dc98170-8ca3-4c0a-838a-8c898cd95794"],
Cell[CellGroupData[{
Cell[11489, 287, 954, 24, 52, "Input",ExpressionUUID->"c11839be-8f7e-4e9b-9b24-6937cc58014e"],
Cell[12446, 313, 5610, 120, 107, "Output",ExpressionUUID->"04fa0ed2-b1ae-451f-a21e-110864579f03"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18093, 438, 561, 14, 30, "Input",ExpressionUUID->"811f38b2-5eb2-46bb-bb53-4a40a96f3320"],
Cell[18657, 454, 980, 17, 34, "Output",ExpressionUUID->"a6f06279-8fe0-4e87-9f50-74de671847e4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19674, 476, 486, 11, 30, "Input",ExpressionUUID->"a76a6c5f-a772-41d3-9960-90ba819f97d6"],
Cell[20163, 489, 7221, 182, 111, "Output",ExpressionUUID->"a5c4cf74-a982-475d-a09f-91361fc0a721"]
}, Open  ]],
Cell[27399, 674, 295, 5, 51, "Text",ExpressionUUID->"66f34795-8d11-4782-8f62-1c56f9bf2f73"],
Cell[CellGroupData[{
Cell[27719, 683, 246, 5, 30, "Input",ExpressionUUID->"7d7b34ab-52c9-4dea-92a7-f00c599118bb"],
Cell[27968, 690, 5520, 137, 107, "Output",ExpressionUUID->"2f88a138-7273-4cb1-b149-4574cd0f2cf6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33525, 832, 478, 13, 30, "Input",ExpressionUUID->"f7eca19a-aad0-4c66-9e99-2a90f62daace"],
Cell[34006, 847, 829, 16, 34, "Output",ExpressionUUID->"970a4424-6841-40fe-bff5-93f4db995148"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34872, 868, 515, 11, 30, "Input",ExpressionUUID->"5d88acae-9619-4e3a-b78e-51925a793101"],
Cell[35390, 881, 4351, 111, 113, "Output",ExpressionUUID->"27767ac4-a33d-434a-a579-1c16668d502f"]
}, Open  ]],
Cell[39756, 995, 289, 5, 51, "Text",ExpressionUUID->"4c393e14-e7a3-4ea7-9d85-ec9d040e2de1"],
Cell[CellGroupData[{
Cell[40070, 1004, 2931, 67, 178, "Input",ExpressionUUID->"c91db637-9958-404d-9da9-7da2d0fcb503"],
Cell[43004, 1073, 2090, 29, 34, "Output",ExpressionUUID->"4fd5ec09-62df-4dfa-a105-9ff8ec44156e"],
Cell[45097, 1104, 45888, 776, 234, "Output",ExpressionUUID->"7debeffa-e1e0-44cd-926a-564228e28563"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91022, 1885, 435, 10, 30, "Input",ExpressionUUID->"bf74e6a6-8bf6-4c29-88a2-446299930cf9"],
Cell[91460, 1897, 5389, 131, 49, "Output",ExpressionUUID->"d6f95ad2-1845-4896-9d3c-ce2498b7cfd0"]
}, Open  ]],
Cell[96864, 2031, 353, 5, 51, "Text",ExpressionUUID->"6a9f9ab7-0b2f-4c71-8d3c-3cd25b57cd33"],
Cell[CellGroupData[{
Cell[97242, 2040, 846, 23, 31, "Input",ExpressionUUID->"44fc2ec9-d78e-4c3a-a821-49ddce9908f7"],
Cell[98091, 2065, 884, 22, 34, "Output",ExpressionUUID->"75d5fb4f-8756-4e9d-bbff-8e4da1875157"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99012, 2092, 346, 9, 30, "Input",ExpressionUUID->"36fffb08-5fcf-495e-9b30-cefbed2dac21"],
Cell[99361, 2103, 526, 12, 34, "Output",ExpressionUUID->"1a3671b9-ac0d-4e93-9621-38abfc155bec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99924, 2120, 465, 11, 30, "Input",ExpressionUUID->"e1ca97d9-e90b-460f-8601-ed5e05d24abe"],
Cell[100392, 2133, 1249, 32, 94, "Output",ExpressionUUID->"c37103f5-692c-4fef-9fcf-2b1b62106143"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101678, 2170, 1188, 36, 148, "Input",ExpressionUUID->"80e51de9-d298-475e-a7fd-48a6a8803db4"],
Cell[102869, 2208, 938, 26, 106, "Output",ExpressionUUID->"c79c0a96-97fb-4c07-9424-fdba954f1c60"]
}, Open  ]]
}, Open  ]]
}
]
*)

