(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    129900,       2248]
NotebookOptionsPosition[    129000,       2225]
NotebookOutlinePosition[    129398,       2241]
CellTagsIndexPosition[    129355,       2238]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
use Lorenz equations to demonstrate chaos 
    (sensitive dependence on initial conditions),  Fig. 11.5\
\>", "Section",
 CellChangeTimes->{{3.644450207434885*^9, 3.644450247858924*^9}, {
  3.644451151868689*^9, 3.644451152522646*^9}, {3.64462794465035*^9, 
  3.6446279586484003`*^9}, {3.6476269424548197`*^9, 3.647626961243258*^9}, {
  3.7939348103583307`*^9, 
  3.793934812326137*^9}},ExpressionUUID->"222bf219-ca00-441b-b622-\
39b4c84c6d52"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[2579]:=",ExpressionUUID->"2903ebae-645f-4ba1-860d-066fecbfe816"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tend", "=", "20"}], ";", 
   RowBox[{"\[Sigma]", "=", "16"}], ";", " ", 
   RowBox[{"b", "=", "4"}], ";", 
   RowBox[{"r", "=", "45.6"}], ";", 
   RowBox[{"a", "=", "0.4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"eq", "=", 
    RowBox[{"{", "   ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"\[Sigma]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "[", "t", "]"}], "-", 
          RowBox[{"x", "[", "t", "]"}]}], ")"}]}]}], ",", " ", 
      "\[IndentingNewLine]", "        ", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], 
         RowBox[{"(", 
          RowBox[{"r", "-", 
           RowBox[{"z", "[", "t", "]"}]}], ")"}]}], "-", 
        RowBox[{"y", "[", "t", "]"}]}]}], ",", "\[IndentingNewLine]", 
      "        ", 
      RowBox[{
       RowBox[{
        RowBox[{"z", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], 
         RowBox[{"y", "[", "t", "]"}]}], "-", 
        RowBox[{"b", " ", 
         RowBox[{"z", "[", "t", "]"}]}]}]}]}], "               ", "}"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"init1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"z", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"xs1", ",", "ys1", ",", "zs1"}], "}"}], "=", 
    RowBox[{"NDSolveValue", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eq", ",", "init1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"init2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1.0001"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"z", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"xs2", ",", "ys2", ",", "zs2"}], "}"}], "=", 
    RowBox[{"NDSolveValue", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eq", ",", "init2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"p", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"xs1", "[", "t", "]"}], ",", 
      RowBox[{"xs2", "[", "t", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "300"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.644627990362337*^9, 3.644628414078515*^9}, {
   3.644629492256151*^9, 3.644629604396728*^9}, {3.644629636939061*^9, 
   3.6446296587694397`*^9}, {3.644629703236938*^9, 3.644629738764566*^9}, {
   3.644630209510745*^9, 3.6446303425285254`*^9}, {3.644630401619246*^9, 
   3.644630430056242*^9}, {3.644630478194071*^9, 3.6446305000249863`*^9}, {
   3.644630566122716*^9, 3.644630569114313*^9}, {3.64463061768077*^9, 
   3.6446306458097677`*^9}, {3.644630693749926*^9, 3.644630715475584*^9}, {
   3.644631140707424*^9, 3.644631194996706*^9}, {3.6446312493149223`*^9, 
   3.644631272281418*^9}, {3.644631378431122*^9, 3.644631401189353*^9}, {
   3.6446314321344757`*^9, 3.644631436195965*^9}, 3.64463164532335*^9, {
   3.6446318753150787`*^9, 3.644631915136167*^9}, {3.644632110444737*^9, 
   3.644632110531562*^9}, 3.6446321770301037`*^9, {3.64463221500771*^9, 
   3.644632235510016*^9}, {3.64463493111215*^9, 3.644634931422842*^9}, {
   3.644635103735526*^9, 3.6446351286964893`*^9}, {3.644635175861456*^9, 
   3.644635176290958*^9}, {3.644635234194366*^9, 3.644635250336152*^9}, {
   3.64463564448977*^9, 3.644635646664832*^9}, {3.644635721760253*^9, 
   3.6446357218200502`*^9}, {3.644637281961344*^9, 3.6446373027128773`*^9}, {
   3.644637620077921*^9, 3.644637708450461*^9}, 3.6446948631003113`*^9, {
   3.644695304175568*^9, 3.644695304278761*^9}, {3.6476269707964153`*^9, 
   3.647627011684732*^9}, {3.647627053930069*^9, 3.647627095432085*^9}, {
   3.6476271469104548`*^9, 3.64762722039849*^9}, {3.647627614956448*^9, 
   3.647627667802301*^9}, {3.64762770980033*^9, 3.647627753918419*^9}, {
   3.647634929364441*^9, 3.64763500086764*^9}},
 CellLabel->
  "In[2580]:=",ExpressionUUID->"31379b8b-92c8-414d-9ca4-02677c36b044"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwUWnk4lG8Xtu/r2MfYmRnM2EVZ3pOlUqgkUSpJWRPapKJFoiJEFJVUkp8S
SWhxQpK9REKRJbJnF/LN95frXI/nOct77nPf57pGxfOw0wEONjY2IUE2tv//
vR3uyaPvlWbJbkpynFwZJyqble13KJ8kCrmD3C77jxIrVW8vKCvHELNXyBrL
bcOESGLRM4G2RCLQ+bDdcfVh4jbGKnEr3yQm3fp03QyHCca4V9yK913CwWn3
cvbkMPFd5M6/pa+ZBI155WXN9lFCPYt/1d/Fh4TTZNW9a9vHiQCLY4fmlB4T
HLveHiibmyCef+l+MG2dS9SelXuYmThJ/PW37/zjnUc09e1W0Q2fJjLYO2Pm
bPOJlMr95r/ezhI29Qkas18LiDX/XaYu71wgBlPXv5v2LST+mZPbduxcIq56
LbtPLb4guBzOLVyuWiH09J7P/4l9SWzpVT14vIUdmhd9kiaUSoiwuJtq2wS4
4PgHRb3x/FJC7Cyp3DuGB8jXv9SOWr8mfjXkJq/fxQ9v91z2Hml5Q4SdKXFJ
jxECTy3gHPYuI7KGFI6ki4oBx2JY4/RpJDKT5pJIkiT40r1dYdr2HTFlshLw
xVUSsqr0/KdEyokiqfUTGv3SEJorWDL5tZw48bo6tBflYGPiL57JjArCtWhv
TtA0BSih75z/+FYStz9xe260UYax3emZEwbvCaNgzk3K1qqA1icmxhffE0dP
oZncKXVI1HSyHK+sIopesO1ZNUEFL1Hm1bHYD8RXIbPKlw81YdUMb/uoSzXR
qG0peP02A3g7emijSh8Jz4km+quvutCGb46NDH4kskKGhm9m60NOVmrFcH4N
0bDAfzT0nCE4hjjuHbKuIy4/oA+E+5uAsqvmk99C9UTbSlH/ywOrYdKCa3Gw
pZ5oV5m23+dgBpVqXRsG7zQQrcfn2VeELOAGf+mNAe9GYnyTxVO1q5ZQeGJj
yBHZJqKaO3m1Qz4B6UMmclOnm4g987GJdgYAF3drYMjPJmIiUiDXyw4gsInk
PWn7ibir/DDBTBZghzWbSEjOJyJA/YpdhxkBUDRa+EfkM1E9lzRy6I0FaGp2
7Ao+8pmYe3Cd61mVGZDSqzn+fP1MjMnfm8w4vBoWRYoeB5k3E+8/jzRGN6+C
vnP3t0xkNBOqlhJRbcJGUOQdfmfc9wsRl7t/Jq2OAXfb/W0PN3whXMarj5Q7
0yDawW1kzKCF0F0eU5VXVoWdhkZrxhZbCL3f+RZKR8XBOkvl5yGPVoJpcuLW
3x0cwJATjR6tbCW+x21KlHduJ6SuLukc0vxKCNdd6u1Lni779+93y0jsVyI/
V6TvcBgPDgR/PR0w+ZW4tWy5TvOJGDb1VaqNuLQRNgaqpUnnpLB4R0GN/6s2
4pVcBlXugxzeq7kbPKz0jQgKC6VoXVbA6dQXWl1XvxH7li7s3XNVGdd51/Z+
XvhGVGb9V8uQUsWbxj/Tqw62E28/SjkqHlTDEc657aXN7URtLN187UV1JD4L
iT6FDqJPIydCJlQDEzNUq+896SBGWiQE71pTsT/Q9FwyuZP47ege6j5CRVML
xzUxlzqJ8mk4f/A4Da8Iek2dnu4kHJSbbwT30/DHt5O5Qfu+E5vup6a3m9NR
P/vaAa+G74Rb9+u7zyLoGHn8oaKr2Q9CuD7I4c0zOn61efV1UzbLbqtec/Uz
HbUkPsUTUl1EZNBa1eABOp75+cvO8HwXQa2cf3L1Dx2b8pY4aONdhAL5p/Kn
STqSCP49wjrdRMTarJfco3Q0oyatueTVTTSLj2Z+/ElHL2ElGfa0biIrc3fM
Ddb7cdOPp8I+dRNMOq2gHOlY3GHUNM37k0gxtxw//4SOP8vLcgMtfxJqlh1u
IzfpKJCzMWbwKMvm3UadjaKjUULLAc//fhL11HUmYcfouCfUw6rz509iKk2/
3OQgHS/tHVZ0ke0hSKUqv7+40fHZuuOLjY49hOn8UcsfW+jYzmRvs7vYQ9wP
Fz7xcRMdOaWuFla86iGqj/2gzG2kI2NJOsFisoeQpO6kFTjS0aX33qGX9F6i
n3PVc/0ddIyoYWzU39tL8JY7NN/yomN2/kvqf8m9hFxo3Xq2E3T8nGrFqVHX
SzzzD7DaH0fHxYj6rjscfUQbx2n1Fzl0VPd2fS27uo+Q3/vR5WstHR0de1MT
D/cRdAdtuzRWfU8YBx4TyuojFp+AQKW8JmZQFrZGdfYRLe9fneXZqIk1nJE6
bBL9BHdoMonvtCZOD4kIhtn1E5UOp5098zVR4fPNgamIfkK0ics947cmBmXk
ZQyM9BN/cl+tKvbQQmmLDlJj1S8i9oiNT4yrNoL6wfENy7+IuARNpbQkbfQV
/FNbbjhA5Fh7LEU0aGPi5Klsc78BwlFQaDKcm4Gvv/FcLMoYIFgDrv+nKQN/
YcI+va8DxGDG0Jk5bwaKZlMsc4QHiUsyUzdlEhloeu0RWd1mkMUT77oeFjHQ
87jB3O2wQeLMPotZiRYGXt39plkmf5BQOECfHhhh4AubDc8SBgaJiR+pFSXL
DPyh3XxVUPE3QTnX+tKcl4l8Ent8Lzr/JvjRrmoNPxMN/g7arlz+TTDJtxlp
nEzc9fOI6sl3vwm3t/au+2YZGFn979/k3G8iU1e96MlPBj7Ni+kI0BkiZCdS
Q968Z+AQaejqxn1DxNBHzzcBDxlIO77Rkp40REi4fTc4EcFAr28549wfhohj
Lo2m9s4MzDAXvNe7METsnR1L81dnYOddf6d3jGHC2omxb/+ENspx1nHe3TtM
eNIJj/piVv0+Xj248/0woePjZ3JlrTY2MEZlTOeHie7rSVmrOLVRMN7ho5T2
CMF+lnvzvwotjHQRYXyKHyGyx73PpNpqIZYEfn9aMULMhcdue82rhcuUxrir
syNE/ardXGm1mni899qf9e6jxPRivHz7Tk0sWDeRqXFtlMjlet5jR9PE8cdb
nDnLRwmrrb27EuZY/S2cz/1zepQYf7g1Qb6Ojj5B4i/f0saI3EtnfdY/pOOD
5mCf9J1jhOJAv5z3BRYeV32WC4sdY+kA6bPIwpfiLYPaHThGzFhWuMZupuPO
5cTTxlNjRFHk0OZFCzre8JhiSlDHiUcPyoe1DejYXLGta8J1nDicNK5tzKCj
GK0wvuHKOHGkLa5XhWXbX5a0yn07TlTbcvb90adj9OjRqZg/48TnUd6Um6z3
PLP9PhuSJojI5n1OnCx/bO3k/zK1JwjfGc1xEVY8dwVrL4jbThB7RhbWJJyn
o6XFKfezeyaIqKnHh7c/oGNnoLbx+IkJwk5kVI3CwltYRofwnoQJgudqv3Xa
LB1lP1/5VZczQTiZ9TIiqJpYxGleZlY5QUj7X9jgy6qns/FISs73CYJO3/By
IkETE1Lt7aLF/hAfDH5McghooV7Nksqc5h/iVnfW1xg7LWxYzP17wPoPcdCp
UDb7shYK7BXOtT7+h/j4pjiKENXG7Pg3kQXX/hDHG/1dgrdq47ryQ7tVHv8h
TvCLuD1J1MYLGg0iKx1/CHmV5J1nRRmouiN84NDMH2JcfkNAgR0DMVoHO0Um
iZefG65onmXgntIfqZvok0STvdv7NQUMXBqOCy5dO0k8jry9YtXFwFsKxEbN
XZPEmU6zzsc8TDTdPK6aenSSAB3h3X00JraevbvIEzdJdJg9jz5hxcRjBZu/
HHs0SbxgVh5d3M5Eyb6V3D6cJD7m70EFTyYWSD27uK19kjj8/pzx/YNM3LLe
Y0/51CSxgc9mm+9+Jo6FipnoC08Rx4a3j3q7MvFqDopmUKeIocPPOApsmajV
GTQoAlPEwkl6y1FtJlYLq7w74zZFmCks8c+z8OxNfLo5EjJF1DiE2KSz8MqW
OVvacWWKeNQeCs3PGZjKRemseTBFDNQ+/u7Nyl/Pe+1yyZspgi9Sad3EegZW
fzyo+LiVZdMFtcQFGejBuEqkjk8RRup1f8JqtHE+Lt/jEt80YVPn0/wrShvp
zkuZB9ZME61Ws/MVCyy8FalUOm+bJgRsStRK8rXQVW59v3XANHFx17rPBb5a
GP0jgaZ6Z5q4NvjcJqVTE5XXvtwg/nKaaGx1zuxO1cTi+52+bE3TRLDJE5/B
HZo46EPL/cE+Q8iJOtqd7qbj2Vr7+nryDOH3b2er8H+s/tMJGXttOEOk7AvL
8w5j8VV8imiu/QyxesPzXcMs/tkw9Vov7cAMcegEz85ROh27t/dsvRw+Q6R9
UKe94KNjaDHvkZMpM8SaDPx3eoyGYvLMJJ9nM4TeFOVZSDsNH59xerHj4wxx
TPQ6vbiOhlbdJ1rX9cwQLxZNw/e/p2G71e0548UZQlTJVSuikoYhD8tlNSRn
CeM7Md8EamgowDe4WpI5S5yof9yw2ELDTD/hXZzrZgntBN5ls0Earqk3OD25
Z5ZQV8n8+h8bi/90XW//PDFL8LU+9VNRoqNf4pm3TfGzRPa+w5Pe1nTkmMns
Kns8SyxGO75Ye4iOt3ZUs+WVzxJfS7vED6TT0aB0VOVOxyzhfVDOM6KJjjUU
CevY6VliWlAqyoBfEz0jTL1OC88R+wTuv5Zap4l/f+6+6E+dI5Y0I3WLojRR
+1H2BzvXOeL+dqUNmuJaWMnfMGgaPEc8rH22v8tNC90Dpvjpl+dY/TQRKvdA
C6/qW9rzvJ4jdunfLw5Zo43qSfsPzXyZIziMXxRrXtTG17PRcX2jc0Ta04ET
N1h8OPKqualcaZ745kHdH7mTxS+KC3/yTecJ2y6m2Kk0BlLOKUrc2zpPtBlu
C5JpY2Bhr7VRvN88wVvY05UuykT7db7bIy7ME05JlhIua5nYlx13PDB9nnA/
eqLnVgATTwsWpux+MU9I6l3L+xTPwl/gt2L7hnkiU21nfMgTJj5p+vfNbGCe
iDW9ThcuZ+I6Q/VFLbYForZ+a7ltAxN/JNtRyHILBH//qS1dn5h4fD7Qgt9g
gbBMSD/zoo6JIruS9sxvXCBuHnH3qXjLxKw3JRED+xeIl0dShFSzmWip3JXR
enqBeH9aKpcvhjUfznOVv09eIOaAe652HxMD+zV7C58uEA3HWpI6DZjYvecb
37uPC0RIcpte9xwDt7VF69T3LRADR78zNrxgYNVWU+dvKwvExS3n+dkCWHqg
duBkP/kvkebu+JFfgYH/2aTc/WP8l5gu7/cJ/aiNim/XvV/e8pc48MrH1C9E
GznzH4pJX/pLLFm08vq81cLjWttXqWb+JXxEAv2K92vh4H0ud503fwnTIxui
BVnzuOHG/kfrpv4ScyY2kV92ayKISdQ7iSwSQyftPjGFNfF5TPnkHs1FYrku
4or9OzpSOUNk/W0WiX1jHh4TLPylnlaxPLF3kejMurSrYg1Lf8427b8Qtkic
PG352I2dpYcPn425lrxIGJusLtVvpOHEoG5e2rNFolWfMlL4gIaenl1fHtUu
Enz7Es1Nz9PwS0fc3+e/FgmrpEbqsjcN12+3VEb2JcLfszbOwIWGpQ2jtnWU
JeLjz5icGXsaMjbc9m8zWSJk/zvc4cSy77yzT+hzWiK44n8HrnOmobjZUtHE
oSXiqWKjzRsvGkYW/te5FL1E8FkLcCWfoeEscxcH/4Ml4nfV3J70OzT0fSRA
lypbImauVHEnfaBhp3Kpg0r7EnGeslOVOU9Dx1u+R5gzS8SNjMQifj06vpOQ
u7labJmwvcNGehPI0tux1W9ttZeJdjHPrx+f0zGLJ7Rv67plgt2HXSTzHx2v
LrTq+p1eJjLl2y207muiS1dS1a3BZaLFwoU0Iq6N1a42I1mc/4g/Mn/uaQVp
o9nnKfHniv8IctrnmL312vh0032TstX/CHGOzDWH6AxUfu+0u9b5H7FeKTpS
hzXfEy05Lnw9zLINNMLCmhnIXZyf3Xv5H9EVueE1XYWJofr7GsYf/iMe6Oho
yvgwcShHbHoR/xHVV/of6T5iors6yvF1/iOWDXafP/SdiY23DxOSc/+IbTuo
5X38Omglo3RAmbRClBj7N3/Q1kGWOrnMYK4Qi348Zw9Z6SBNIPyZ6YYVwmAM
jFwcdPDWBWarzf4VQtQ311XPXgeFljsXt4SvEPiBSOyw1MGI41dVdt9cIdK5
RXL8NHRwctxsvW/hCqF4KoZTnU0HvXyHA441rhCaLgE3zzYy8WvPrcRzQytE
8t+MU5pJTNTQ0eis4mCDSpeo3ilHFp6HlsbsxdhgyV9UoZONiamPvrA3K7DB
7biCkys5DBRQiaR1mbKBdJGo/u8RVr3NE3TDbdlA4ZXynF6cNka53jFRcGID
fr1Udk2mNnLEF6/f5c8GPTJXFK74sPjuv/eb/55gg+hh+XJJlr4M//B5x81I
NviYcPRe1CPWfP034v31NhtEnLg9/Ym1nxST/x4+nsMGnJmBn11u0/H4Kt5Q
qZdsEGzvISbL4isjJ8mzhRUs+9uL0lIuOk4eUone1sQG5mdMpJve0fBZjE78
ZCcb9PMNPmm5SMPAh2apCb/ZoMkst8J4K6v/323I0Jtlg7txOsc2qNNwuHN7
diMHO3Ae2PrQeYWKOfOezwJF2UHXdHN7fA8VfSSDioUp7OB5Tn9RrYGKVL0z
mEtnB0OxgGRqORX7Nl2u3mTMDvE9+Un331Ix0zulaWgtO5jfcLh2s4KKHhce
tMU4skP72Hqhv01UVLyb303fxQ6n47yz//tFxc7St4MfvNnhDXFyTwwXDW+1
1k4cPMoOqWN9Wz21aOg62TbPfY4dziWKyCzuoKG0yC+2h7HswCfNpS0Uy8K/
5hSfzS12cMk2qlr7kYaJtmzivVnscGqQds5ciI5b9gnLnX/ODtqPeTmubadj
XSpLtNexw6rNv8+uXaDj5UIj/b3f2KFEqdQjwkkTNzStXf2vnx0q1T0dm/I0
sZLX3c58heUvtde++IgWnlfz3dohyAG5fi3ST9u0EIjjbmGyHBDKrix1xJLF
Z8fjfYv1OWC62fn1OT4GhiXeDt5hyQGJKV4SRX6s+fw05+TsRg7o+UKzS/7I
wNmPL88l7+CAyvfOT9nVmVjYXxlj5MUBCQUhDp2hTAxh/5zQHMQBqU2qFgIf
mKin0HUz5AwHJHORfEKFdXDMdOSe+GUOuDozUqy6SQefOC88fnaDA3hszorK
RuhgQBBPweb7HFDlE3T3XLYOal2VKB3L44D4ZwtFj6p0cPCRcnnsaw549ew9
Za5NB7MqmDWMjxyQ8vp7MncXC09daz7XtnAAm4B7TDLrXHVxfbtfDwfERqxc
S32vg93S23v4xzlgUTa0Wi9LB+8YeA5lL3KAJvVf+7MwHXR3PDy5no8TmucW
Mm9Z6yDZ7/TfX5Kc4GO8NjKdXQfbLsZwRKlwwgWpvPLYF0y8ce+GgIYOJzB2
DFv5ejDR+c19UuUaTrht72SygbV/kr49I+9fzwnaq90+7brLwDixWq17HpzA
H9M8ZVytjSUmCi8cAzlh3L2sQtpRG/v2HCaWTnECPdSqZNVnLTR7IuG8I4UT
7JT8Dz/s0MSDXw784HrICU+Dj/ot7tfExMWXPgUFnHA3s6s2aYKOg3buZ4Qb
OOHKQUU2b3k6SgY/5X3VwQkpArypL1/RkEhlS/T5zQmq6ae8w1h84VfmRJGe
44QhvkYLH2ka3vj1IKuCiwt+r9t5m/yZiu+E5/SCSVxQOc4dL5xKxREju1eK
ylxw1oD97T0fKsq6p9nWMbmgsHpfrKINFa0vjDaeNOOCf6aXDhVqUTEwh9hJ
s+OCgM8KGE6h4q1PCX1fXLjg+iOT/ItyVHw/3xt43osL2DcfelOmQsUJpVUL
uiFccNibq49kTEXK+ugL3yO4oHes8Pj2bVRcH9gufCWWC/6jy193PE3FkGRG
qmkaF8xHPex4kUfFO6/DVX9lc4Gx0lCu4SgVP/Y25V4v4oILVOu/e41oOC2g
ZrK2kgs01qVwvIukobLBsXdjn7igyfuwfc13Gm5y+7ApvYsLtnetMeqwZM2z
s3KtdqNcIBB8XcHiER0zH/l7zP3lAs9hRUMVaU2cnxE95iTNDbE5Tb6FnFqo
puC5sqLGDT5qWduszmqho01hzBN9biCu75oRXtHCh4mud/gcuKF97xrO38va
2FSSQy/ayQ0Pt8w/+BfG2te6lwr2+3DDc8eJK17TDHTSvffh7QVumMylCvq1
MDHcZWprQAI3pKfXhWeu1mHpedtOubvcUPXjq3ngdR388iDl4IdcbtixZ4+N
yU8dZKv7PXG0lBvmsgbHo1R0UXvK7JRqNTc4gpOR+DZddCHHcTe1cMOffPcX
ZUd18fza7mtnernhpU7p+KuLuvjEx4Cs/Ycbbsn7N59g2W3XIh+0/eMGz8Qk
58Ijusj1slUnSogHsnn/C7i4RRd1f9BLDMk8YO/nu34bRRd3cp+y/knjAdnU
S+FtX3UwilFfH2fMA/9sD7goROpg/jYlV3NrHnhh0LIzSJW1y4YF9/zewgPH
P+0pdC9kIl9mRUDKHh6oku+tvGPGRMOPUnM2ATyw5YT9fzKlrH13wvvc5Eke
kHg5uA31GfjCUuiGQzIPXNzl9DFPUhs9O5zLOOt4gPjrN8PZxdJvaT8PBX/j
Abv7csf699CxYGcgpesXD6zil1hb2U/DneTFGvtpVrzHfdeWHqUhZ/ulk6Xs
vBDX2VhaKkTD3JuSdLooLyQd23P2+lMqOrvda02m8IL/8KX+sZ1UXJLVucip
xQszHpJ6LiQqPmgrNQw24YUAOzdXoxYNtE9d3/PDhhdKvdsW2+5r4PSOL/H2
TrzA9uXFSli4BqbL7CNK9/JC/66VS2YHNND26+go7RAvdFpc8aC7auDYjbD0
5DBeSNnlp2C5QwNvuPBu4ozmhTeO7W2+nhpoKZ20EJTMCwmWyWGXT2rgrxbl
7B+ZvLDb/XB8cLoGxiU/cbF/xgunvge87q3RwFXb13CXvuGFG0UPHqVyUfGH
5IfntFpe0Ks6rrfGjoqXvmzzTG7jBe9r2tJeLPzrJXWLcf7ihfRNjIWMP1Rs
23aoLGiKF4pU5Fv8WHqU3hxFsRfhg7D8ej11Izo2JUrUlsjzwTOmk/PNPNZ+
6pRxkqbJB3ZFPwzu6Wvix08lrRw2fBB8UXUNYauFfk0j8SUn+SDxOLvzqSgG
kuJPErRLfLD07lcfU4KJpZt5xpKS+OC9bdernltM9BS9ns6RyQffOO078uR1
ULBRaVNQHh/Enk9+lsnCQ2Fc7sL313xQEuVtWcOmy5rvq7M31fBB3hqPNqt9
rP4VqXIp+coH/LzVm62f62JuvRM3rZ8Pdsk4fdOa0UXn2K7nSZN8MOp7UeMD
SQ+X7AM8Odj4oXPL+clMFT18ILQgFiTMDwWvWg+/puqhQ93Fsu9kfkjeeeha
M+t89gopcBOdH0LJH9nbWPfvbLpLKTHmB5ny/YMtU7q4TpBRS7Xmhzq2uuk3
T3VxrKb4ZNIWfphXjdgZsEMXb1y2pXPs4QeFdaeCzMd10HLj59bD/vywrYT6
rfWEDv7i33vxeyg/iP7ToqtPMfHax2HDTVGs98xt3Sz3M9E0JrSn+Do/+EZE
q+6rYWD3Bu4E6j1+qH1m79quxUC9asUx9tf80Kvl0cT/UwvbLv2XfvgjP5hK
X5MwMdPCs+tNN31v5Yc4HkvS9RRNbKraml38hx/0HiKbAws/oVE/XKgr/NCl
oRA0Wcuap+v8uZOEBMBwsph9qxUNq7nnn7OTBeBhXu58Akt/Bb+P9DxME4AM
pWqDPAeWvupbxzNrKABcObmmtGENrOXgzzkNAmD1s8xj03UNDFWpdeB0EIBS
7bINF9dpoAbE/olxE4Cnrr9n1bk18POezcliBwUgb1tA9/5GdYw4I746JUQA
3pweZno/VEdGenOnQoQACFaOOllfUsdvpclnH1wRgMcNDV+Wj6pj1Lcd6tqp
AvAxJFP1WqA6Gs7LVec/EIAoyra6viPqLL3Q6W+aLwC6zyJbeiLVMdb4jmjZ
GwGY70476nVPHdc4ezy3rREAC2u1a+Yf1XEgRHVHXSvrvMxJZdWSOiYl9P11
6hWAJ67mXJJrNHDts6w738YFYDn139K18yw8N/hYeSwJQHOVSqMbaz6kjWr9
+sUnCDF9O39JGVBxg9BozCEpQTCoNH+8i4W/Ga085rSKIFx+bOT+nJeGmXbB
n8J0BGE4qTX5egQNN/sYHmM3EwSYDZjds0LDxw9fvhZxFgSN3jPDDRKsfazy
pEeyhyB89XLiepuliZy9ZlyUQ4KwzqNRjW6phbuVcZNmlCCwhWiRnx/TRgHi
/HheoiCkhISHqUsw8OVum+ur7gpCcFBmbH4eA8XTqtutiwWhlLzppVcXE9+W
XA6vqRQEssC3/8YCddC/zV516ydBuP7mJpfPrA7KzolUff0uCMW0T94/Wfzx
XuqT754hQSg/oFge2K+LIUbXhftnBSFcinboproeKm3bnu/PKQQXnulwFznq
YV2wzPZJUSHIyyXeQZAenoz/Nh9KEQKFB2I20dF6SM1LS1+hC8GOtMvnlm7o
YXP9bogyFoKnPC1+Rml6eHZEqU/ISgj8djkITybpIVOw59J1RyE4JRYbRo3U
w3bNB9rkXUKwkpkzNOmjh5c2HGzM8BYCiZ2977Ot9dDIm36EdlQIPnof/vxB
Ug9/XhySfnqW5d/tZsRMiS7GPcgtNYoVgnN+JrvU1+iiWUXgnlc3hYDbazv7
8n86mMw29bC6QAj0JnpuyR5iopXSC7vNZax4Nj/f3I4MHLc4MdpSKwRHfLkm
NEQZaHdq0ai3Twjmr2p/2P9AC2dvvmnz/SME0bqnR++Oa+L94ojTE8tCUO1A
sRu00MTlGc7KZWlhuLJ1sSNmiIY5klXekWrCMBPu+bx3Ew13GEYLCuoJw40C
D3G7IipyOW3MSzAXhoE4PvYKll7LDxLaJmsnDFZftnxi5mhg3S2Jk09chMGU
/2/BsDaLTyrJd628hKHUbXmU/7U6so2rvP8aLAxyjRGJgrvUkSynORwQIQxh
WlTaJn51NLLWE+eIFYZvHWLK7B/UcPMhE5OUW8Lw2lvT3i5JDf1SLHczsoWh
6kENlR6shpHvbC+8eyEMH20eHbm2Ww3vDNs/dqkQhsPff2l7uqlhsZRz43CT
MHy5ciTzhJcafiZ2zZz9IQyPXkW33A5Xw1FfT3npEWEod1OduvVIDfmSfNf+
tyAMm0U/TDC71FD1bZA38IqAZdnyfRENdTQfPBHbIikCPM/DY0ZC1dGFFPHc
T1UETj7PFTrUro5B5lHfVnRFYP7pNlVNOw28fDB2JclCBLhPpenlVGrgg/gk
Da1NIvCnpb/ygD0Vy0rTNpW5ikC683RVcRcV2/syg50PioCS6ofynjMs/SmS
k/L7iAj07ljJZ6PSkb6/uFfimgh8UKJKl17TRKvYMv7H6SKwmZ0kkOuohe4v
q3Qtc0SgUj7eZhVJGxMEW075vBeBm+Gfrtmz9olc4857y59FQM+E4+5OLyZW
7e39kNgtAj1v5BpZiwn+ff5H4s2iCARXNSjwxumi5I/51U78oiAyQHvOkNVD
HT42jwFpUXDdO2tjuU8PNxjwRp1WF4XY9TIuJRl6uN9dJFfcQBRkMmzXG7Xo
YXiU1OcsQhQWT74N9lnWw9RnlHkzB1HgXtoxQsjqY0G7muKnnaLwyuzs/R51
fazj0rY56CMKxvVsE6iqj790DPwWj4nCI+fYznRxfWRzWx0ff0EULC9s7Yv7
o4fkC1CkkSAKJg/ZR3kq9ND4yfrO0juikHI2csPHKD3c8tWRY0uuKCz/KP49
YKGHfuwu9P4SUdi3+MIwqFkXI7V3O4Z9EIWT0iYBl2V08c52r6OiLaLgv7Fo
8gJr3yyO8L/1oEcU7vlsJSZDmNj8OARXT4hC9e6c06cTGMgVATwF3GKwT0Qu
26hcC8UlbW6eFhKDfyZ1e5VY+5fi4/WM9RJi0PWjWOH0PB1Nmx2dOpXFgD3V
dv3ARhra+jj1Z9HEwGzx/aqNkVR0Wt4eGqwjBkX89onVLL21N9FN0NxYDPJe
ntQoUdLAANruOzzmYnDO5kkijcUvJ1976H+yEoPzZQ1CnfNqGLXVqzLNTgxC
XX/X7Gf1d9Iv7x0Ht4jBg4k1L+Wk1PDeKf8hvR1ikHbLXlD3jSrqIf/8pd1i
wPfkx/2vYaqIXNncXfvFIEZX5dTj9aq4xW6dxCo/MVjIO/Lnqpoqdsf2KccG
iYGruYHIXhFVDPp8XqfvuBhoS2z+Nc2riivSKuZmZ8Sgs9X5qKKYKsbtKrNL
vCAGo0u/72RTVVExY/eO3zFikLzvfsqeTar4tG/RC+LFwPjY5tsC4apooXkr
JOWGGJQJfZU7/lYV6w6Znh1LZ92v5+P2FVJD94LWWNv7YpB68nVLtrcajswe
TUt/LAYT+a+rZhvV8JSZxOOpPDE4euMdj7CtOgqczS/aWCQGjUfj+NKr1PFW
5ebKe6/FwPRrs916Zw3U4h/7NF8uBr32v+fujmpgicPVrs0fxWC6L6pAOZGl
V1ur/y63iMHutDau+QUa+sh7823vFINTov67Ml/RcW4vt3Rujxh4OL6vI13U
ROnfa/V3jrPsf4eqBzS1MYvZbZk/w8r33VKTEAcDjUPC7fmWxKDAoSskuIOB
zoul3kV84vBl0eZyZbQO9hFux4RFxVnzc/Pbsyw9dyRy7ryXlDjI6ckdSRTR
Q46PyfGv5MXhHqdC/VZ/PUwUNrpDUhWHdzs5SYdYX1PV6fN/vnRx4KTGnnQS
0sf8G0ElqCMOqgmdZacc9BE6RD7IGIvDYz50PnVeH5uUnnwJNBOHq4bphgI5
+ujhtann/VrW/9cW3pOq0Mfx7N/jlA3iIBUm3Vxbp4/ho5eWjziyzq2m9zyq
0kcRA6pgrbM4VKmE3zr+TB/vHK+UVd0lDpKyFWSPy/rIfOVJPblPHByUbQx6
nfXx9QqbUZO3OFx/SVz6IqaP9jZ319ICxSHOwDnCpUwPO6MtNocfFQcDtYxt
Daz54l/f4d4SJg6WDorXnrD072UX2dALl8SBjSvV/JCaDpLTii62x7LeDzmY
F6fFxMddztf1k1j1cot3Pa3NwGqfhKddGeKQePP3zWq6Fro+0X296pE4aD3q
U0vQ1sSBP/UfY5+IwyM36/3drP2D55RAv1mpOHgRML/Di4o3yrInE1Ec7q5+
1W4dx9KTXOvZhqpY+VPXRFiz+qlwQ7/w2npxKHy0MO4nrI42sRfkU5vFYWzI
XDCaxTdfPqlojn8Th4Lg0V6tOlXcL42r1nWLQ+rT6ONPbVRxcucem9u/xGFq
8ZXP2gYVPH93aev0COv7zCTPjPqo4Ba94mDtKXEIPkadV5ZWQcV3RxI8F8QB
td5qxDYr48hW3fybK+KwMf5w1kqGMpb2DDU1cZNARMX2onm4MkYfyZrgFSLB
Rc36Hg5/ZXTh8hQjSCTAu2t8xbyVUT1ZQe+4LAn6y7lm1UKUcVLj2+YniiRw
bt8Yv3JFGbEo6XCfOgncTrwt9i1Uxrj1W67Ja5OALWxcQGdYGd3bBPOc9EmQ
4Ezdp6Cnglq+HxpiTEjQ8LFDRPiCCs4vnB9DCxKkHeDMb+lVwarLliLz1iRY
SrUP2uqkiknyf5m6G1n+LvcFuTWoomfuC4eDW0hgKsd1p3yHGupZBB+67UKC
wPgs3p1javivnhH7xZ0Ekf8krnYnsPA8fr/OypcEukfXbN77TwN9zu4dOXmY
BB83MlN8qqi4SlxeKP8YCWo/23Ifv0nDzwaJm5TOk2Bo3ZN/PLs1MaPCwd8l
mgS3dSI6DTdpYaAz/5XYOBKEt4eYPCZYevb42ZrFWyToDd1z75UhE9t4zIcM
7pGg75T3qkIdHcxKmeP3e0QCD6XymByqLq4tCbRre06Cshvclw6e1UORjVq+
oqUk+FHWMTA/yurv9v7odUiC9G6216Rt+pjjfy/7TBUJxKQj7Kuf6GPoknt1
YR0JTEzvbzZe0sd1sbKDw59JUL69fjDW3AAlFb/wqn0jwWjH7Xm9QwbY8/Qa
bWcXCXZ931BXetUAnxGb1if0k0DYTGxB6pYBhjfxeFcPk+ADJSjwSpIB2u8r
j1r5Q4J6yajlulMGSJ48k7VqngTezqPHlzYb4OD51VWH/pEg4IBmO4vIsUhi
pv8BlwR8fLvp5vd3+hj54Bl3p4AEOOYr1k3s00cn4wANCXEJqJhMkLg9pYfK
VTTbjTISsO5P98OOUD0cc+n1OqcgATqnx/qyB3Tx9cCdyGI1CWiTLFh1vV4H
XfmlK6l6EuDan2sScYqB1FufenevYvmrvf3K0l4bp7ViOZPNJeC+nby9maIW
xttzWXPaSQA1hDTZ3EzDPd/LPNdsloDxdM0TW95QkRF46nzwdglQtr3v8f65
Bv79tyoze5cEeJaf1hAoUcfqa5PvuvZJwMtjMnfiGtTwhvLTn9I+LH9ugze9
ZlTRK9+X3TFQAo7c4hfdqKOKBlYaKhePsvI133668KQKsjV3w+swCZZeFtnW
+VUZI3+/vRd2TgJIRh8KwyyUkZ/tNsfqaFY9LguY8YQoYZz0qf1zcRLgxshw
WpukiCSmW+WLZAnoGIpXfN+tgCnWJhpH0yVg2npmZ5yLAlJ2SkUZ3JcA3e/f
ai9PUzAjaOrXxGOWLcSVl11CQY1Ln9bnPZOAlQvZJr0PKJhzOy/70EsJ2LB5
qnjTCwrqFMbyM95KgNTmXfViQxR8XuPvN1QpAf0DxyrOWymg6U+72uxaCZB+
TGqUequAr+doDO/PEvDTOk7X010R14rwxGp8k4BbF0J3qiooYZV632hvlwR4
pwXflGFTxo1m5Y6ZvySgILFA5c15ZWzYmpHnMSoBUZXe4+dZ82mbT7iY0rQE
7Hpx/MyhVyrYFu4e/P2vBHzLFrIMD1ZF9+Q1n9PYJUEsuvPbf6Zq2P2frOFO
PklgWzjK901MHQ+Uz16XFZWEhrOf2z4uqGPgeMH2ZIokzKmYWKssUXGSO6Fo
m5okHNxwa3RZgo4nKIdlSFqScPlRN9V3tSaetdP+FmciCWGhDmv/e6iN1+/f
d492koR/iR3dEm56KFt67s06N0mYyZqf/s7q1/SmvYrcHqz3L+5rjIzSR5UB
i4iKg5Kw4UbZj5/CBpi1LN997pAkPHHMvpEXZYBakn8BjkrC8oOWjuxRA8zT
arv3L0wSLmpdnXtKGKLR2iKON+ck4Y250u+pk4ZYvCNp/6loSZj0O6eoccsQ
zQNDKldfkwRNoZXlxDuG+C5yi8Z8siT4PCzatzXKENel6UQVpUuC4+k9zx22
GmJNvtDA0fuSYNizyOfCZoiO1UPrDXMk4f4LLXPxZANs/lGd/eeZJPxXclzq
NwuvrjNZ/M9est63iiwcPKmPnYIX/QLfst5/d/BzQpMeeqjur2W8l4Q+sZm2
J3J62G+6ljFcKwlbGQMniQIdHDuwPOr9TRIStq6+pJukjUdOdzhSuyVh3l/z
nAi3Fs4nluT1/ZKEoC0DzT/P0JEdjwXvm5aEA6Xy+m63NDCqddtnpUVJCEkY
MFn3f/01qm/4g10KGlwZd+t41PAap1hSOp8UODZ6/JfarYKS5LHpnaJSMO3+
3e45i89S9eq2y0lLwY3j91xN3imhwvqcoq8UKQjQLat8J6KImbujZW6oSUGf
O0nsyDUKUo8eDHXWkoIyuhy7oZU8Mtd0bburJwU2SvJJFBMyGrG56g6tkoJD
lte55p3l0KyqScDYQgqu+H80dLwli1ZX7X5FWEuBMoeb+D1uWbRzKn9XYycF
H7Wd504my+AWWbPbUlukYN8u7fXHNsjgjh/PQz1cpCBZfiVxk4IM7nnAcP7P
XQq4Y67cbSPJ4AG/h7qznlLgPyR8XJkugwF6ioJrfVnx3IjR2+Yug0dmb/y6
clgKrllNvm94KoNhr0XLW49JwS9lI3FlJVk8dz76tsppKYiIPH2P44ksRm9g
PxlwXgo0Pv+XsNdVDq+JhDm/jJaCMZELJzapkPHGl0ldjmtS0GFrspWTTx5v
3/IXdEiWgnfrRdcOClHwgUffr5Q0KbBqGzYL01PA/6i7y3vusfzfeumz9Ygi
Foy03GZmS8GMceOUVKsSlhQ4ngx9KgVnM3t5X+Wy+D/0g3NFoRQcGdrSKxSh
gg1cJYJu76Tgn5/D9WwXNWyp0R+4/0EKsvgjr4O7OnbG55SP1UuBRPTgu5UQ
DRyipJ+MbJeC7efdEsI/0/BPj+T2xm4pcOXiPloqp4nz2bF65AFW/V+eyBsP
1EJu44iBvCkpOBq+LVjBjIlCi3PlfxdY/s9FHgrM1UHSu6A7tmzSQJK6qKAm
xuIbB8/tHULSwClWbs8Vro80iQ49qoQ0hITzFKgxDFDn2zahYDlpeCs+oz7S
aIDGd+sGXilJQ7q7r8vzAyw8HrCt4KFKw4xhvumz34Zorf32zlaGNPw1aqKq
uhrhxj+rwtINpOG7kphqxBMj3Poyb/uAqTR00xW1s34ZoesZur4BIQ19bMGx
4uzGuNf6ntAZW2nwmGrfzbVohAf5yYMfNkmDrOCagtxmIzzUmFhBcpKGoKP2
tWuuGOHRZMG7u12lwYscualH1QhP7YoMy94jDa8vOJLr0w3xvMry9ikvabjY
XVC/tGiAMQPH9C39peFarkyugo0Bxj8ZE4oJlgb/T/JZ21h4TzniPdh8QhrE
SyZiOFj7+J3V3RWK4dLAe/KDqcFJXcx9/yms8LI0MOYSQkubtPH5lY0uK/HS
QPcaubvhnyaWbq3Q35giDblthh/zjOn4TsZcOPm2NKiUB+QwT1Ox+nvhYNd9
aRDpWKe31KKOjfeZlVo50rD7rb/yznVq2OqbdffYM2mw7dr46m6jCn7XVTqF
RdJwIbro+I4jytg3k+Ii+IZ1buVqX+DFwvNawyPfK6RBSODebb5hedwb23At
r0YayOODi+fz5ZDyzTf33CdpeG+lez+mSAbb1bk/bmuThmmqydfqOSlMDcro
1+iSBquLp2MDQiTR5bUZx3y/NJSNWX7fpiaBknxfFWtGWN/bpMLejJeEn7aF
mKVPSUPBbPLVH2RxjLsr7Br4VxpOHqlQltglhvbD2UeBXQa2BzzPKIkRRQET
mwQSnwxc8JUxXsgRwerzXU/6RGRAK3Wr9ZykCEY1hNUUScmAhDfRv79CGK3J
0gPRFBn4XnUq7kaBMLIdzOfcpSYD6t+330nsEsa3+fbKTC0ZsGsR/cy3QQRP
Lw+Yr+jJwN8rqptchkRwtd0Ft08mMsCusXPo/HtRnE1SPH7fUgZiPLn33QkQ
w8LuksRjtjKg5n7yyBBJHEMY2/PW27PiiW8EhVZx1A2dqJXbJgOXuv+2/i0i
4UjFlcFhNxnYI5XYFl8kgTmiNO63HjJg9M2JbNgqiT67ylXivWVA0A8unpCR
Ro1Huy09A2XApF2wR++0DPZMzu80OiYDYq13/3jzyGGGZdIJntMykJS+4Z5T
MRn3XNZNajsvA8LbLXPXJ1GQ0lrzLCdGBlrum/s8TVfElEPsQ44pMlBC/TFL
uaOCziXpPCp3ZOBWXYVuw7AqkrhN1aYeyMBzeW2Xum3qGJce6J5SIAMe9mfC
eo/Q0H6Q/6RviQzE/ZIirWLta/xGD5PNUAb0hW16fv/VwsjajoauetZ9fC1z
/ev/f49zYjj/iwxw9OpkRB/SwxVPEl9khww0vJSTqw5m7Z9Pn6i79MjAYHSB
xuQRAwz7u2Et/bcMKIkfVw8NNETTdX27/47LAL+EflXvTiOcSYgIq5uVgbun
J0I4DYyx4Ds55c6yDASPv5cyHjHGIM2i50FcsqBqn//+07lVqHNsa5OVoCw0
8+8zKxxehcM4MiJJkoVb3/p969VMMFsomn9AVhbSn0ewFWmY4EFXNWqJkizE
r/RoaoyvQvUHb62uUGWBoOt5m59dhT3jbnt3M2Vhy5mvLdc7jDHDbOaUrpEs
qNg98xDiMcbdl+JT2c1kYZAIrfXiMUJys/aL5rWyICVPEn7SZ4Btih8+Pdwg
C+5tCtkPH+ujc9GywEYXWRAJ3ORJl2LNU46bNMpuWbgi/yxT5JA2NjoY2Yzt
l4UW44LMlSY6buz3O5MYLAvqEtjI3q+G686o5dqEyoIn1eTOjicqaCXV2T4b
Lgvt7Flf96xWQssnSfyPL8rCmnNXw7n95HGNrYPprquyUM5v49c+KoOrvnN7
C19n+c9bieyvkESDY2+Ty27Kwo0rmxrP/RZHHeETlcEZslC2V/lHxgsR1Hqo
O6X2SBZcrlbcNqYKINViUKX1iSycva69bT2ZB1VbMrZEF8qC32tjv09RHKh4
yC1izStZyHIavr/93b8yMjfp6cg71v20lF3ZqxfKpG/XdN6ploWIAPvavfum
y0jGFwS3NsqC08AJPmf1iTKRerM1nK2sfC+ZZNl2DZYJHpj2edEpC8+7brqk
7O8p41vOTfHulYUeuhL3sN+3Mq7kA1VyQ6z4n7e/NvrRUMbGVJypnZCFGtnf
fRZhpWVLla1q4XOyEBosKOTvf52Yd7/mpPdPFjINW9PbTiAxPb3+XA+XHIhW
+1pU69YTI+olP9aR5GB+0kSA1vmNGHwdLLwgKwetY29uG7N1EX3OWub/KcnB
u+8nbYsXfhKdkWk3RZly8Fm/corz8y+ijeJc/c5QDiS5WvO/2P4mvhQKzR1Z
IwdFPw+87q4dJur6zji3rZeDVDvBObZbE0T16VUXLjvKgWc920VCcpKolBzP
N98uB0paTq+0c6YIzH3UPbZLDn45ZnGkeMwQr208RO95ykHFRoeIK+ZzRHGn
rOU2Xzn4+T1ccq/1AlF49FMAd5AciLhqXK8KWySeCV1Oe3lcDt5yfF77e3CZ
yH1gVeN7Rg6K41eC12xkg2zzxXn5SDm4NPuU6VbODg++PKc1XJaDwoQDavUe
nJAREOByNkEO5rYKMOY0uSGdS+OiQaocTCXe8H6gygup6d+f992Rg8lt/1B+
Cz8kGd3oufFQDjhdlRS0igUhvs5R3C5XDqyMcge09olArBcvLBbIAXfK3dV8
j8Xg8lJZ4JMSOSA9VVpnbEeCqKTQ23tRDi7gX9IqKUk4z9CvE/8gB67xu9ce
EZeG8Mrffyvq5WDdjUdpd61kIcw9U/P4FznofrGL98kTMhyf3ulK75CD/oPu
B0t2KEDIVYlL7T/lQFBQyWJeVRkC1eteXB2UA813F/fmvVVh9W1kn+W4HDyP
0Pzjek4NDjpbSPyZkYPQi4/yxgM0wHNkZu39JTk47GOr2XqeBnsinwZt5yRD
bPSgd3SFJuykeN/lFSBDk/LfGlMdBrgUKjWUiJFBdsvXpy6oA4598dqKimRQ
4Pv+1EzVAOq0+764q5OBXjXH3RpqCJuOmISnaZGBPyNpo3CTEdSUXqa165Fh
bL/HrJLyKtjA8aNJ1oQM2z64KpfsNYEqO/2wHRZkmIjeb6ERaQq2CZFqN6zJ
MGmUbF5xbjVUtn2t+2JHBtcdI73P7deAlbL2cYktZNjSamlR9m0NoHe4kpML
GVS2M1PclcyAyPtUHe9OhnVbTDYXSpvB21n1kEZPMuSEe20Keb0GzC1D5UV8
yZB29MlBEF8DpRdrK+0Pk8Fqv8ZsjdxqMK1XDLxyjJWvw+/WzT9MoEgyRKbm
FBkyhywf1/muAmP398h3ngyGNqNC09VGUHhf1m99NBkY+bwRMvyGYDDsLxEV
R4awlTsVTBN90AkjHeRMI4P6bPnsjJQ25L47IGp1jwy+joEDyVE00OYvKT77
iGXr+ob2U9SBnrpX8N9zMtx9KHe3vVgesroKCs1LycAnvRw2oyANGjSePaeQ
DG++F3S/mxGDB4FuvKVVZGgLFFB/dYYPVItyn83XkWHHME+cUMsKkbG84mbS
TIapBsVJdfsJQsl2G+fxb2SolTj6cUWpnLhzNSu3sIsMw5lBm2Kq+sooXxa2
T/WTQaBLYJda7UzZLXmHFf0RMlTvjTV8J8CGcvszsoMmyeDSqb57OJ8LU3Om
tubNk2HnPokJq2E+lJ5ctzj6jwx+RSW7LaqEMGn1rQcMbnm4Gj3hW0wXQ4lz
ow7+gvIgE3enFurFUUwsKWNQRh7OXyv2mq2VxLgdA3Y0RXnYsosivVtfGoXv
rpk6oC4PjetT45hXZVBA56dtr548mC8m1NwzJCOnvc7wdzt5OHJIMqc7TwnP
Xz+XRNkiD7RGIblvScrI1vHFYpeLPDhfuNIT4qaCS76n4ts85SH8fLC55rIq
huU3rJbxlQctA9/AxO9quDCv0rv9MCs+xSeXLavVcfZStXHzKXmQLc5YV/Ga
ikcb5bvEz8vDmmOVVEYVDaekD0dviZYHRfY9Jwba6DjxUKqjPkke/hBv5Mel
tHGowvNs9RN5kM7dVa5RrItKCW1+cYXyYPgzt4oZqofOexy3O7+SB2YsNS1b
WB9jtCsJcrk8TK2aOHLnpj6+nV+t1V0tD/u+2p9eljXAqfd5klmN8iApcGvL
vWgDpF/XWPFvZfXJ2z9Xj/Yb4G6PtN/63+WhqE38UArDEBOZ4l/meuUhael3
c/QuQ/zwN+rtmyF5qLNe5+0YZIhLH5ayL/xh5feTZznF1xD1k0Ou283Lw7mG
fM6OdYZ40HPwjOiKPJQmfZLy5DPENN09Pi3cFODvVJNzyDPApqVmpzQhCmRG
RZVdtDBAnho7i30SFNgjMKT98IU+mqWU0WhkCqw+6OXfSNbHIC9j0qgyBdxe
yL6NCdLDLP3/lgpoFLi8MXMj+ZguitXd+GRpTAHmxMqGZ0cZaHtT6DWXOQX0
LSZato1pYdjB81k1VhTIdnH7ZhOgiX1sgadctlBAdO1v4wcxVJRr6D1A2UGB
+AcWNmv1NdAxzW1Lz24KxMp3rro2qoYXfBrXZHtR4MXzxWdZqIrFxrYagf4U
eGDUJDD9nwqOcrwSNQqhgJPYhVeOz5RRtUnv70IoBainRh6ppSvhjttZfWUR
FJi/y83jI6CIV/0ojRejKLD0OuD6qxwKvjNJLNkUS4Gmd271S6fkcZaL74F4
EgWSb/YrvzpNRu3PZ+K+3qJARZJqtct/cuhxdyr09j0KHP4mNU9m6eHkAN/9
+7NZ8ZC3N267Ios1q7scNPMoIHB7/8je1bK4wrPddPwFq767HVXfisii0Zca
1RevKfA0wGpERkAWfe+B8KkKCms+OLDbacnincCiOaihQGPwhq9egbLYbMbo
4flEgaq/f12KW2SRjz+zru4rBdCiJqN2rxxatMq8TPxBgTmvP3L7hMgYcj/2
nms/BSxPiC2EdJAxO4jzquIIBW72PJLWrZfH7xYnj/dNUuDQvIban58UJAmO
e+QsUGBs6QCXGVkRN7R5bQpiY/GW+0GZ/44r4ZmH7careBWgy/rj3NwpZSwI
2aK8JKwA3e0ale6bVXCAqBIol1QA8q3x6c/GqkgRNp+5JK8AWzVAO1lXDaMe
0WokNBUgqOj7Y/3dGvjq6O3Cb7oKYBakcDo5nooTayXu3l2lADwu0Q06rTTc
2fnviLaNApxS8177IVELdcRbFaz3KsC/pr1Huqz18Ffsr/PJBxTgvMTID8tZ
PbwtMDcw4K8AiY/GOmLvs/TtJV6HNSEKILq/IS1ngwEKcckWXA1VgB3/o8C6
46l83zANSnayHWdv4xx7xFWpJBWVBhJSqaTMBpUkymyQii8qlVJoKfO8REIo
KRINlZVESUPj9/7+8nk+73Pu577v67rHJefeZYMeMVETxdV4vV8PU52coqID
TIiIP5aRosN6KAvQmTrtvQkh3rvo7aEEPbzk+96ynG9KDI6vXfD8uB5KguYv
70g0Jc6HbM3nntbD3rTJrxj3TIm1I3uVI7L0MEVR0f9fjSmhvD0hrClXD4wU
92N6N02JhwMZnfr55HnU2lX7gClxYNM1++AbelifuNL7qNCUMH9Xnltzlzw7
qhV8KTMhhtc3TdeoJM8eR50qjUyIi13dgVtq9NCc/i1SJUFMeK4dflrWoAet
ecE/zj8REWrP/1oqPiH9CzeIi5MVEdEt+pNvdevBrPC5WVSuIWHtbOw/9b0e
FItOtV57JSRGH6Jp9aAebka/7f+iISC8q33Sf4/rYf7PZmLdOQ6haR/8e+kf
PZw5+8N9ZIJFtJRF+5ybTMFRtZPiwK1MItby5IOv0yk4+fX7nJuf6YTdnQuC
BcoU3C26WVudRCPGRbePnVanoK9rSGlgPpW4XlDzbVCXglKvBV1nRBTCT/DM
fTaDgtGo6Sx9BVIv5n2QpPAo0BzdGteop020MceZPUYUJNvss/b21SQSzsnE
m5pTMDmbtYX2Qp2YS9H4HGtLgcLoxv2/D8wifp3lrHwxl4Jg5ialKyvViJsa
liWCRRTsS08U1KycSWxJdaTsX0aB1eI47b59qgRVZe2hx24UXB6viikh51lH
0pZ+uicFFTvvdv2bo0Ick9u7JMyXAo+aecSlDmViYVz8zTp/Ck6zdS81pCgT
fydnaGjvoCDxkZVR5UZlojgqPzIgjIIZxXR1xbXKxPY/ZW8rIyi4OT3o5iF/
ZYK599EClWgKeD4Fi9knlYmu8a78DUco+DU486ANaf9kyCfl4mQKvEcuvFhg
oUI4jfwJm5ZGwSF1y7rpRSrEpO2KL90zKBh5dckyaq4qUTJAwfVzFATG5Nn0
DKsSOzcZXfx3mYIpxZzx7DszCe47e7nlBRTsr7NmrE9XI16vd9mRe5sCzHRf
8zN1FnGqy7ttvJSCqbUcYk+hOrF0bZDVoioKTlUtztbo1yBknh/MyqijQO1g
0xERtIiK5ScmDzdRMGyfruVYok3O0/P+aCN92KumPb5SlxA632o60UnBnttN
zh/UKMT7h/fFH95Q0LhL1qn6lz6RMb8t3aKPgujhOq76FBohZ//Np+srBYO8
vZbXljGI3XO404p/URBxSf1p+w0m0TvPoyBFWh9OO18+TjFgE9WOVb/mKunD
+PDius4dPMJ48ViOrro+jGa+kr9pIiCylnAWjuvq4/Tbg/csZxgQe5cnnbzC
14embG/u9SBjon8lYXVIpI8NgRYPEraJiFWrv772tNTH8BHJ+dm+ZD9Yy441
t9cHL0y2ytOFrH/PtULlBfrYGJD79I6RKZHjldg64KyPmz/zvob9NCUUfSS7
76/Qx22dKeLwS2ZE5IYvlP/c9XGoUObCOSNS729k1Yb76CNujbFbSLI54e6/
ZpuLvz5a2i767KswJx5uTVDh79CHQrfH5IF75oT59sq7k8P1IWe37cur/eZE
7o7Rdd2R+gjs2fi7RsmcUA1mTrl7SB/f5pW3zAs0I6JCV189Fq+PVIrnqlnZ
psRweLzL1uP6OPP3VM6FPBPCc0/F+LzT+ihWvD/78Akx0RAxkqmXTcZz9z5r
yE9EWO5nzPt+UR/b3t8QaHONCbVDR1Ou3tKHsO/jp247ARF9uNwsplQf6Sss
+45UkftR3OeX66r0MeN9S9ijtWziUaIbV6VFH8G7fk3u76MR1ilHmgef6eNU
zJ3NSs36RN7xstCaLn2sYmt9Pa6nS6inDmtnvdPHk5Vx2y9KNImYU7SqXYMk
HiXnLDbfmkV8Ob1ys+uoPnIcq50XjqsS3hlxCoIf+mjcdBL7YpSJ5v9Kb035
p49Wi4tzn9+UJyiPx4WfJ1FRVX9p++vX0wg3V2UpTxkqjpy9cdH18FQisZX3
9OF0Kn6e2vx6yelJxP0V8y6ZKVCRNumgBk9RivjV5rnnvDIVvRvW5C8qmZCI
VoU7K6lRoXT50CfDse8S//YU/UgNKqS3h/2WKxuTZK+58qVfm4qTpZf3eP0Z
lTx/UV3rRqHidXjy2XVrPksUPLpOV9OoEJtbnZAJ/Shx6Pq2zYhFxWHWKvFt
s35JxDol+0wuFXJVvdIGRz5Ibr7iqk4XUpFkX0k8W/NOMrB+7ocwIyo2LuJe
jEp/K6G+9bjXI6bCQ6XiP2vzN5LVvmEJy8yp2LPkeKBo+StJ8rtkr3IrKiYF
VW5VfNQlqfXLE/FmU6Fu53PJvP6l5PeHqimnQMW+Fv3rrTYvJSabX7ZPcqDi
x769AaWaLyVb+8eu7lhIhWpNoJlo9UvJuS2K+7ucyO+8+pYrIy8lHYMc10VL
qTgItu3JN10S5YA5zGJXKl4JBsYMmK8kCz+5f6e7kfn2aVy3pfS1JEvt0NMD
a6h4XrnSV6npjWTMJr+wy4OKD/L2Zp8/vJU4bXiaYLWeCq3ohFmhvHeSnPiJ
zad8qagwGzYYOPNeMn6D4fB1IxXT9Po751v3Spa8WEx12ULFVLtj7SLFfkmu
VOjvawFUsJdXWMzQHpT84mR2TN9JxQ7qgkkjvkMSl2U1tzeFUPHohs6jhuFh
yaXwoWP3w6kYUH/DEfWMSH7/p7adupcK7WiGw52wL5IVtbaL9u2jooP18Nly
8zHJ1SE/VmcUFQqxB9f+4I5LpNSSpC1iqNj2zkbPYMUPySqbO90n46hQBqfc
uOyX5Jpvd8lIPMmvq+l20v5/JJPip55akkzFTsXjNbeNpYg1NwyCrx6nos50
AVO9Q5oo6HBbKptGRdHS9jmyhZOJqVL7+X6nqXhfNa/na+lUwpNzSaYqg4q4
8nP7+6WnETeXNvfoZZN8eqPveTZejpgWPl659zwVq6K3zw3zVCC8/qNktF+k
wmVc/dRTe2Xids2CXaZXqLgR5N2Y+leFkBsKXHH8GhVCk4WffT/PJLxnphsN
F5L8nbg5HK+hTty1lsxYfIuKwi3ZRGmkJqHo29d3uZiKJ4q2E1+ZOoTfUaWa
KaWkv//9RIg6hSgtssjxqaBi8dwOh5p8KqHcsT6ykqDC+MgCGOyiE5v+xa3R
qaFiuv/Mmwt3MolydpHp7jqSH3cCV/qfYROqSzuUnzVQcdyheZnqGJfYEib1
SdRMxdeqNU9iowQEkcmtT35CRcj8gIeWsw0J9RqXix/bqEjPrg9XOWlMVKue
W3fxJRWmlY0XK66bEJrW9VaTXlPxaeOldWYLzIhAn9FZ63vI/E2/FJPbYU7U
HNH6UvaBCh9x9/Lk1ZaETtGcZs0BKixj/7yQv2VFBLdvuRo2RIXhEF90+oU1
8fDv8djWz1QE76n9sLLEhqCwS32NvlJR8BCybXNsidAlPXaJ41Rk9kYwZ2yy
JRpC5XQGflKhpuZoyKbYEtRM8ff5f6hwd353t97fhgi/7/70vBQNNxui9wYt
tiaaBqML/02mIebttczmJ5YEUzU/wVOWhi259cFL5S2IvVZPN5fI0dDh3rCT
rmhGsI8wqCEqNPAptBmBxcZEZOHi3y1qNMRFf61/ImVAtD4P6RBq0qAyxe3A
ietcgvs34/ZRHRo2un/snohjEgdYNcd6KTTcr3Q4+DCLSjx3HgqYR6chUgr9
R8a1CGGo2qIcFg0pucvSAx1mEtEZtqw/XBqK8l3sPFbIER3VftLuQhpOrzD9
4pz0VzIyp1N7nxEND3K5Z9q7+ySyVctMc8Q0DG27UOwR/dSegtol981oOPJg
od2mKWP25hLrzb2WNATf55w1eSKFpXZFUdNtaSjQZlyoHZHBxgrWWaE9DcKf
wtBFofKItM24tWwuDQvtFW453VVGaplyU/B8GuZF3mS0/VDFNevY3jRHGtLb
d6TYyM7C/ZKJf/cWk/kgVL03D6rjy91e8T9XGoxkb5VlLdbGdAtPZ7obDVt1
9swIJHU2tfjJxvlraFgcr/MsZZkelt0uP53gRcOt/lJTKXIObDIR3yzwocFF
Z9WJJgkV+29ebnziR8Nclle/+g4arhWd+KuxjYbtIm5u0xM65K77++XuoiFb
8k7q6H0WHlxUM644RsP+4gmTOfuFeMWMX/TmJA3WmW8twzwM8O3CP9/J6TQ8
6jLeu9XUEPKMsEj2WRrW0b6rVcgYgXl+MG3RfzTUubGntrYYwZbmXRiQQ0P7
Wp0dQQuMsSLn2cOUCzR8yF1xKvY/Y2zVX9xz8xINoTUram5+NEZ0FjHx7AoN
szI+/Io1EuGsnvmsn9dI//seel/eLMKNzHxD3SIa1Ea7fTtOiPBQh+Zof4u8
f7bz5YwiEd6cPeXjW0zGubkxcXulCD+05CMOl9CgX8rbsL1CBKUzB1Pzymlg
bXb7+PCaCGzN79cbJTREP1bMSEkUwS49oG64moxPUljEXCfCKvWeNyoPaKBY
TTebrS/C9rTVv0zrSX5FRTA7nxojRq1p5ppHJB+j3ljZRxoj8+Rcg4gWGl5/
6Nbq0zLGbdV7C7JayfqIZUUNeRqh8biBd9UzGlQp13LW7DLErxTNk7JdNExu
6I/ZlyyEqlLyNf5rGuoPqHo6nxCAlzz5wZIeGr6Gme7xT+NjTeLwj5P9NCzJ
PLoo7iIXO2b4qd79SMNT9xcJ9Xc5iI1/IegcpuGGMGFb01M27hyp8aJ+o4E2
ry1MypiFPKdGzbgfNCxwY8hlbmDirHxr66cJGiK4Mm3qVxhIau5IXPmPhq4j
U/wgzUDUsdcLyibRkSCxOpsVQEfI8l4pugwdJmFN5/aQ725S+1R6ZDodT0y6
6vv20bD2+dfQz/J0BD8rTupg0OB8+pfhKmU6uCsenKJ0U2HvLj1QPpOOnsCK
lN1knxfrTrvA0KDjVohj8ekjVDBfKa6L16Yjqp+nJSDnnEbOLI1RPTrcij0L
Osk5J+er+2Q1jY7eF4IZbiep+M1gJFQy6XhO6/rlTPb5zx9481lcOpoXHfoS
8YWKnsvG/xIEdHxPGQk4b0PDsy0WJV8M6ZDW3mUal0bDQ4FdyFoxHad0fTO+
kXGXfnIwIMzo8BE6XSndS8f1wsV9bCs60iexfuZMZSAnaPm5JFs6zrz78HVb
DgMnTNZ6jNnTkfFS8PaJExO7725qqVpAR/ndp4K2Ryxs27P9KNeJjjXqC01d
L7DhZRM6L2UJHet0C76rxXEwT3LwrudKOl5O1dvaFcSDYl1m9ncfOvwv854X
njOA9NELa702kvk/qbKBfcMQY05XZ9b60/E5VU8wUWqEXvkbTQISl+3Wn5JD
1hnjRfPduBM7yHw9OElnPTfGo2OVc34G0xH6bvkt+nwRKpfXTqwPp+NdM7w+
XybrSe3RnQd76HgktonV+C1C7vPWHQb7yHh/LJJfbC9G+ukXvNQoOuqGn2Xt
2SFGvPubd78O0aEdG27zOV6MSN2+/3zi6GjYIlYMPCbGjlefVj+Mp8NwAWOR
wwExfHPGVIyS6RidU/lh7WoxVvpONKYdpyPg7E47Cy0xFjInxf5OpcPLS4cq
/UAE695p2HCaDtn0gl3b1otgkKf0qz6Djly9C+W5fcagblW/bZxNR/7fenMb
H2NMHWZw/16kY+7FEd/SzYb4Ucjv8btCR79i3oozLAMMBokyG6/RyTrZHO7S
LcDjb3bKZ27RYa32nTt7GQ/3785v+FdMx3lZrfpsVS6K9zjHbCol/We8Wara
w0aezQq7pgo6Vq/+IXOeYCHjz9ofJlXke8uUciqLmEiWeN88W0PHVU8icf5t
sl4Obg6QfkjHoXe+USmPyHqZF8j2b6SD1lvwLeoXWS9Tw940N5P8ma1QmGFH
g7Z+ffsE2YdvtOouc79ARbOlXgv3GYn3scWJR3WoiF4e9MCtg46uWGf/z0v0
YR5QWxH9ko7pkWe8C+JJ3XlY607hKzouprs+Sh7SQ1b29mtdb+mIkET33wvW
w/KSqgvTP9AhfPXxymJdPcg8nZVh3k/aO6aWvLlfF6VDW05s+EgHy2TGbovn
ugiUqTx6bJgOx3W7Yr+/1wWdqnqwYpSMoz9d/ddMPTy32rR7cIwO5/dvtPN9
9RC/onSHxg86FtM8Phx/rAe77YqbHSbo2PRiS6jrOgq+xPp6Bf2lgzr8N+Xy
NH1czCl2yyL7yrWvCR1bWvWxplRuSeMUBrZmHt40Zx0V8m1eDj9kGVj5OLEz
7A0VxKebNqwZDKw6hN+tweSckJU1Wa7IwCOYJq1VI/sKzYN/QIWBGamc31Nq
ybisC2nX1Bh4TXvFrI1hwCFwtbKMDgNzpFlvXpH970dcvqwJhYGrq0LCz+iy
ce3cv7/raeT9jvC2WeocqD27/KmEw0Dm8YNRrwx5eG/zo2G7KQOtB/zqpJoM
cNrNufqsBQMb7pz4u+mPIZx35JTUWTOwO95DwX2WMaSOjhWNzWbA84mKZG0e
2f/PO+bR5jBgrT1utc5MBP/yzOylDgwUZKiIXpWIoPt85FTEQrKPrBocMzER
4/Fnh+Q8JwbEd0zl8rLEiJl+5vCzJQxM3+WhnvJTDEvGp8hJrmT8t6ZJNs4x
wZDtnFCjlQy46fOKP4eYIGdV2jbP1Qxop9LrVqWYYOXOAd+j7gysv17IW3jC
BNPiZ7sXr2Og7YJUmUykCcovHHd9582AXqVG4iFnE+ys+OCo7EfGa5N9de0U
EzDbrTB7MwPNTx8YtuSK0TGSZLF1KwNF7v2Pa4zESJTrMUzfzsCtl87xWWQ/
AdOcXbOTgcnGfaFsJRHGZsfrjYYwwLBaM2nbFmPkrX6lRtnFgKtic7lViBE8
g8Tyi/cy4KyeUtY11RA1uZ2/cqMYoC69QzHTFmB3peGXJ4cY+F71n9LYJR6E
HdEDf2MZeMx6595gw8Wb0edvBPEMCOr0tuR3sZE6Q9CxJokBM9POts5EFhxZ
B1oOH2Ng4iDz8uhSJn7bPX1w8ySJ79E2+QEmGccaTuXrUwxcuW1uzyPn1Ibg
iDvyZ0n/hVfOnSX3VnPxqzu8/xjwPnBqqqIhOX++oHgB2fd36DBk2gkKum9c
KN5wgQFdhVgrPVc9FAXJ3I26xMCe4KpzNvK6OCTacvc/cq42u9Y8Mx7VxqrR
xrul1xiIjI5wqf2rBd4Nw3vthQwU/7YwyDHRwu+dx++N3ST7iPFW/bXJmmgx
HrunUsyA8ar0/XEKmjg/sqrEsISBMbVZac2FGggvKilZXM4A80HFur4QDSza
qVvqL2HgXlrmhbw1GtA1PlB6uJqsp2mmy+XXaWDk89vS87UkH9fxh02iNHC/
0KFM8pABnyJpp21VGji143JZVyMDqRuG5PlUTWwxkiv/2czA4cJ4rlqmJmw/
B5Srt5J4bClf/NNUC8qFLeUmz8hzlrPL00EtvAsUV7h0kHy+fyn5foU2ig3T
Kra/ZGDamvwC5QIdxA9/r4h/xcDBXfr79ct1sa7AvfLyWwa+nr/xYGe/HowD
Kypr3pP4ZS+TOW2ij8mGVMnbPgaCWXMrtJaRuvxTtOTvIAOyb69ZBJE64sr1
DxKdYQZeSlvH6gySe9h2R8JylIEt+4J+rXxMxzKDfMJtjOTHrFOUeXUM0D8p
VAV/Z4D1xlNhoJmJ+oCnVdf+MHBuiaPdASUOMoXm1fVSTNDjPONXL+Ri59Dp
6t7JTGiHdZVkJPGgHuB1nyrHxLSkEy967YQYEFTdn63AxFO94nmuFw1Q/pFR
467MRIB6vHW9shF8tw3UpKozsUjWK4T+1RhmAufaG1pMHOmcQ1W9IMK0jwW1
zbpMRMs7/962WIyuqyoPPuozIfvYf7yjX4zCraEPpjHIObPk3cKWXSaI5rc/
YLGZePlib1PRmAlWDVrVzeWR723bvGHUwxS8q5l164VM9BRyu+deNcXvLf/q
Io2Y8PaqVK3pMkULz/fhGTETuv6F3w1HTXF+oOZhsRkTsx33Gkv3miL8Cqf+
qSUTj9qCLp8tNcWiLfH1IzZMDM/Jb1+6wxS6vE/1CvZM3O/Y8nLDVFOM9C9r
4M9l4vq8p7IyB0xwP+9mw8L5TPQ53TXnvBbjlP+sRj9HJqZseNTuxhNjC3d3
48HFTPhdtNRN9BHBtr+zMYusy7N66sd/JxijZ3POo46VTFx1Vf+Uc8wAdziT
m76tZsIO6kniGgGO9G1sUvUg7RfsD1oxwYPRZkGzsw8TA5JrD8UJbLzaor/j
uh8TQ682N7c3MJEYMFNZ0Z8JlrnOwlVkvVvvkL0RuI2Jk6cHn+8mdctA0IRr
SyATxa73ZKSNqDgd+vmLUTCZz027Hv5Xq4cFu96dPBbGROmGb39VAnQwtqfd
dHQ3E+PmD6pjXLRwIbLxmWskE7nffhnYBmlg+QFJ+M0DTFwpHvvS1TgLUtG3
NGYeYiKwnhWUs04NBTGX74XEMpExbSg5mjET6+Iy1rYdZeJW5dDEJm1VyMen
/DJNYsKmf81GC3sVlCYeykg7xsSb+R/VJ5KV4Z+yy3b8JBORb8qH+2WUoXFi
W/eqdCZinFoUBhyV8CB1/f67Z5nYcYATXtigiND0FfqaWUz8fVPYLUpRBP3s
QmL3OSbmj+ne1TupiCeZNj4vcplY8lA0tfapIqKyjSZZ55H4vm79TlmmBMPz
jAtn85mQWRCe915aGV25Gg4TBUxcM8/8E7VbGQmXZ3zwuMnEvA45oxUzVGB9
9d/h8jtMiCKLitNLVdB/7Stbr4QJXnrHkuexqjhV2Fe3r5wJuZNVf1/tnIn5
N1/6v5IwcbeRqVa3Rw1jt1um298n+ZR5OezD+Vk4f/f+1ewHTNTabhc3f1KH
S+ndxVIkrtz2Jz+dPTXxrzx/yLuJ5Fer2cZ1I1ookGQnVT1mwvRtZzX1mg48
q08a0tuYIGJUBx8f14NcbVxLdDsT5Z/yhgsu6KOkLmLnu04m9F5qzB8fpcK/
YYeKwyuyHh1b1Rby6VBv2nAz9y2Z387nlucjGAhpXTy2sZ+JXSU+5kHb2KA/
s0978JGJg+O9qS3TuXjcbmLO+czEk4J+xQqCB4Nund3935iY1dwfXrnDAH19
Hye2TmZBZeuIxuAlsj4GX2c2yrCQGtI9WXLaBA6fns4WyrHwRDVgjiDCFF8+
171KVGCBv1dqpvlCM5z7UnbgkzILL9ddmZ32zQwu3wqpS9VYqAnvqFc/YI6/
3y9UFWiQcy88YCat2xzXfqX7KumwULB+2w1bOQt4/EmYvJPCwkH1RZz0SRaQ
k4rKfUxjYcXjf7ytNea4Nyl0vojFgtsOUbqFizm5r/r3HueS959ern6UZ4ZZ
0zzjvghYUFgZ4an41BQ1ci7cFUYsdO0Tfzj+zATBCg71t8QslG3akq9xT4wW
VeGMMCsWbn1q1zxhZ0zuh9sHMmxZOOKZJmesaoiCuoK6anvS3k7taNElAZIj
RTHKC1jQ8igwUvrCxt/nwb4Wi1joiaHepJI82i66DS9nFi7X3Hpz5j9yD+01
/5O/nIVs37Kr1HQ9lGP3y1Y3FjzTveOTjbUhzCgp+bmGhajMl7ZRqhrI/PYr
nerJwuY/FZNzbNQww8U2fOF6FnynRFJ3XlHB3qv7Vgb6kjp57D914xuKGJwi
EadtZIHCWDVtebwc3NdLqZT7s3DMT9ni2jMZNJTM+dyzjQXtvbWn58VPJnXF
oabpO1hYmRvaNCVbClcDa/KNg1kQfh+y+zHrt712/dT41WEseDh5Lfkb/93+
KGOh//7dLMzzc5melvjV/se+IwsuRrAw2l75STBjxN6/o575aD8LDuem+R0a
GbDvEM+Y/PUgC7pCzfZXie/tHZOc32odZmF/4qrGixdf29/rS5LgCAsbnik0
fl7dbs+Z2/Lf5gQWbufNKPwm+9j+VKZyZHIyC4qZNKNp9Pv2Mt9d3e8cJ+Of
I8lIPVZgH+560rIrlYVquS7LE9w0SW9+m/rk0yw4GXYpX+u+K1klo/6Nl8HC
pq/H9vf410hqvVc/dcliQXrdPC8Nu0cS07LTN3adY0GsdKf/SMMTSe6szpSs
XBamlXF0vB2fSWIaPJ2HrrLws/vRko0/X0rGmFn8mQUsGG9x+V7k+Fqy4cDr
adY3WJjv6hl22PWtZK6pb23cXRbefduiu6HtveRm8oULBaUkno/3hGXd6ZXQ
B94ffFZB4jV88uqlW/2SE/PY3r9JnabnfeW+fdugRDprsx2jhsSbTbxz0/sk
2fkjT9epjgWLyADLmWmfJW+WD/7a2cDCcj2P0V/UUYnLdcGL9Cby+5lmhZC0
LxJCdvvdyscsvA92Mb8kGJMY+xakfXhK1qvbW35a3zdJTvnnEPl2Fo77RWSc
afouUdYQLTfpZEH/PasqqOen5EBQsLF7NwsCPc6aJYLfkuHGW4oH37BgO7Nm
tPv6X4kX+9vQ5XckXuy6tSb3pIjmKPPG5l6SD6tLFT/YTiLsXu668m2AxHdn
8q9H/ZOJArOSON1PLAzlJUjPIqYSesd+bZw3wsJbs9n3ltfJEomDNg5bv5L9
w8MqLXmyHPHbYR/9+DjJv/SKT4v3yhMB2ZVS936SeJYf1T0uUiK6fv579eo3
C1eE5+J+aKgQzivnVEyVYmN0+4cNCytVibKC6AzhZDb0KbmOSSlqhIyzm3a6
DBtFe2zP0SrUCdcBzhlpOTaKc35JZXK0iMzYXxoBCmyommg5dbbpEH2MplPP
ldkYmbl7Q18DhRBXZc+ao8aGnXdjTp8sjdjnFZyar8FG3O2AgII2OvFwwmGm
ug4bH5nD0V7NTGLmGY0TURQ2WWfT0/6Mswkv80HljzQ24u2W3clbxiOuPC1P
cWOxccJSMkrtEBD2ir5JfCEbgjCXLdnFxkR8vql8mhEbL2XnvY01FxPPHGUT
/onZqJ09272MMCG2Hbp2pM2KjeAPN+8GtpgTxdQDsvaz2XDJqIzl21gS0pWu
sVdA6oqHJkH0KCvC2YM5Vc2BtDfvjdOCJGsi/cf4of0L2cj+8GLueVcboiet
ftKAExs75dc0UyptCAOTzIMrlrLRJP1ukXedDbH7caBUpSsboqrPZzZvtiHu
b59zgOvGBmOvr3ValjWhOEPt74k1bLyuybKrDbEi1ub1Rv7xYONgp7r7/q8W
RO78konN69lwnibv6WdoTnzuSdjb6kv6N3La3snClLCO8vppu4nMXy09cxFN
TBzWE+2+vIUN7fCHql6/jQidNc/DIneyUanV7/vgFIfY9C1vrDeEjZx5eKNx
gUHcOBER4rqLjcRJ2kmBL/SJ30ZLv5TtZeNcwUlVze+axMImahB7P+nfYLtd
ziVV4sTWr5+PHWRjfK1mxOsn04lu2QeBEzFsPDnY+tqs/6+Ee/H0p41H2Iii
ner0Tu2XhMzdFvCY3NOGwly9r4U+sa98PfujdQobrtJxK4TWX+2n71PeevEE
GysOGEj3zpbCSu13/UqnSH5svWXZxJVB9t07m/eeYcNdp8udETYDgyuP9L7P
ZONYRfuRy7rKMPvivnFZDhsbrfcst5qviqgUg/clF9g4/aB7TM9ODY1CqQ3M
yyRep7WebVJWh3pD69vkq2z83nPV3bNGAz6bL3r/vM6G8iqrldE+Wvh+zsmr
+TYbxw+O+dQG6WKuvV635T02bGWXvvQc0UNS12ePC2VsTJpc88lwhz4YGmlr
d1ezkefaVtRtR0OENN/lUTcbGa+bTHT2cdHrMKOD/ZaNWWba/9Ue5sHlyND6
g+/J/EjfC3FM5YOpVLjD/CPp/8esRJcyIZKXH/t+bJiN+ltPP/Q1G+BHWtCB
j6NssAvmbd/9yhCPdE1Tcn6wUfEm95BzkDHMvWdpTEywcdMcqT59xsi5MJ7l
9o+NN7dk17FWiCDX184umsRB4cv+P/NuihDGLymQk+GgZIq/OHySGG+2nzXf
OJ2D+OC5uWfniOF0I6JSIs9BgWpX5uPtYtwe81ygrcwB7Uf4ghOHxaBY2jWH
zuQg9D7D61GcGEci9Fe1qHNAHV5AHQ0R40ul1CueNgcW73mHpziJ4TmpZ2OM
Hgf65bmBOXJi1M2//+kVlYNgkyMOI8UiiI/mhlkxOSj6eHlmrosImY8O/znJ
4cDRQXtT1wtjyChvPjzM50DaTuGDspsxdq5wVFhkyIGR9uO2vqNG6DzFS7sg
4qA+i5J/dY0hHDrl9P6acuCkviVRQdcAWj5Nwls2HOxueZMlPsVHTG7BbQV7
DhiFt/UrVvEw3Jdi6z+XA9UsuxEHfS6qA5c76y3i4Egpc8GrZ2QfvWnStsuZ
g7Vun5tRz8Spb2qercs4cDj8t3ZZCwNSVuPvhCs4WBngQHgP0LEtsn1b3CoO
4tqpdu6adDyX3Pv6di0Zn2vU2/ueNGDy2QjbdRzMv6Vf+ryYiqsLIiane5Pv
6+vnJ7KpUIv3TBjdwEFextAjr9X62N80e6bzZg46dHklDQkU9CvrZ1zaysG9
9Sv/7h3Qw/KVUgzpQA6WrvQ5H7xDDxXpb696BHGgEKpXclVXD9yX1eLiUA54
U1bMpo7o4gQlt1R5NwevH7nJvu7XxW+fw3O3RXBgGpmnKSejh00XNzXU7ufg
1Pi+kLcL9PC4f+FyajQH5QFdV2uv6sFayOvce5iDY1vHDliJKMjdIef77AgH
Ohdu/33zggKlWx8HjBI5MHmse+1Arj72jj8Kik/h4OF/h9/vcaTivVXBz/cn
OFhy+9z39BYqlu5LOWh/ioME5Tnrz2ym4R6xc/rZM6Q/WwqN9ivTQZ+y/PhY
JgdlvUZX0EBH4kITrWU5HHQ++SRoSmVgPF7t3JULHJjrn3j+YwcTPs3fuFMu
k/5KAq+He7DwSKW9yOsqB8eLla0aV7Fh7nbPsuQ6B2Pr/4XZ+XAg17XXMfA2
B2BSFZWzeTDfdUUh5S4Hk35ELNpTyoePakdrYSkHmWOzT8R0C3DP0WzdKMHB
tmMe8qPGhnj/bgNdtYYD4e4E+HoYQenAiT5xHQfh13zd6mCMTXc+B4U2ceB/
QuvnjDUinHChWKQ95mDxAXZwVLsIFR+df995ysGD0N51uxeL0R8bUfX8OQe5
b8NN198QQ41+Nfb7Cw5kFf+43pAxgX1Fx2LNbg6mr+w301hkgq1rZFWs3nDg
l71maXS4CU59NXu+9h0Ha/7Umy9KMkFVsl/G3l4OpsZq6s1JNMEQ76R3xgAH
xqkxPk+CTaBZW8UqHyLrpdtaU3qOCeZ5jwx2febg76ztAXu/ixE4QSn684WD
W6vvNMWki3H21JIwyjgHJz5Wnhmni1ErirS2/8nB9UlnN+lnijDy6Oq/9b85
uPTlcF/+VBF0/V/URP0j/ev5MhzrawzHydPiz03i4vXbwyah24wQkmW+rHoq
Fyted7dlTzFEQ9vJF5PluYjP3CO1gy3A+I7qLKYSF21ntiaeKeGBNmN0w3xV
LlzkRgXeK7nYPWfpcKwmF8/Gpe+4FLKQ2xV567IOF1KOczv5pI5v2ZW/+yGF
i5cr22lKSxn4pdo5e4DGBbtnQrDRhk721WmT5Vhc3Gw/GKJN9m/XRRYP+Vwu
jq943n5rFRWR7zcmLRZwYXym17VcTh95B1KXBxhyUYMI1b8n9fBU+75GkogL
szNK1COOuvh7Z7TruikXfyp61/tydMB3pZ5vtuDCRnxS091IG25DSzd/tubi
68sLLzXWayEqbp9Q2Y6LzormFeI7mrhGvzZqPIeLpy+Gu2cba6K9orPY1YGL
W0+lNr9o1sCktdMjgxdyQXFb1HEvRQOGYxZzTjpxkVzHt7wepAH3lE0yt5dw
8U+L3nQ1RAOH+WmNbS5cvCqsX9mUqoGi2vvHvq0g/R+a+d6jTQNd3l/c1Fdz
IR/fZF0v0sS031QdC3cuHLT+Dt6+pgmT9GVvVq/jIvImMT7ooAUv8f6Lu725
6NoVGOz7SwvxTde2ntlA+rdp+XXrJm0U+780Kt3Exd9QouxuhQ7eTpb71rmF
tM8xmG73SBfy2ZalEwGkbh6qqHf+qQdL680HdHdysc7jybfw+fqkjklzmB3C
hbBQkXt9DRXJO2ume4Vz8WYFzamBQsOHS7TU7EguqK1L5mV20TEU8/bn5Cgu
zmaWHNw8yMAX33Pr/Q9x8fzY9S2/ZrAgpU8TiOK5iPAQdigd5UDmz5tjaUlc
2La82tPfw4XCy5zxn8e4eFKXJZFewod2OrW6Op0Lrdttl9QcDUALe8PhZHCx
V6xdrNBqCO6KnKSELC7WChJ+TDcyhqHI++vnc1yU2W34qvX///cpUdeuvMjF
kbZnNqU3RLD99LryXh7Jp5Tx1G+bxJjbmM3Uu8bF+40WpaGKJlh0ZX38wUIu
eGyDbzkXTOASpz/y4SYXPWND3Oc0U6ze+NrNqZiL/8wyH2XHmMJrXnZZQQkX
+S0Lkv/WmcKPtp42s4ILlW/f5Ir6TbHtHyVuF0HyP/+fz873pgjufjX08j4X
EygZNCg1xe6yrOWo4+LUDkoLZ6spDpzxupfbwEV/ffW7L99MELuLQpnezMVd
0fvCDd4mSHJ7dWj7Ey7mLjO8sv66GKkmWQNP2rgI2Jr7POOtCGdVvJaZd5D+
hrEDXCeJcO6z3p2zL8n4zf7sHFEzRvlmPWfhAJnnz/skPSTO9+d33zg2xIXa
wm7fW+Re18D4T+PbZ5Ife6xCvTuYeCy9bt/ar1z8nlh2f9SYgfbXuu8qxrko
MJ1kaX+JhlcVXY70X1xomh23VbMm50lGZkHsHy6myTa3FnTq4eMeT7WPUjyI
bZcVb4zSwZfVunuXTeEhZLJMTLifFn6adb2+JcvD2pwcFc5hDUipZc7XnMHD
hR872dpvZkHmi0d+pCIP+07kHT0crAaFxzoqb1V40K421POxmgm1gpfh82fx
4HD8WXSiSBXaiRldVzR5ONfAevVptQpoWz3mKurysC7s8oWjV5TBddTJC9bn
4XGKR1UqQxlG7JcK7XQebpzlG0yJU4L5lIwQGzYPH/7I8jQVlWDb4/4im8dD
7vLCN2EdiphHaNtPMeDhoeKMg497FOGU1Znrb8yDLE/V+BBfCS6RZ+WaTHjo
Gaw+fuy6Ela7u+8UWfBQV52x0tVMGV6W2s/TrHk4LpmuHlOkjI3qnTa/ZvOQ
dWZ21BpHFQSMnTnnNYcHZYWlE2p/VBDculb2vgMPfl8WDC1uUcWeIq3tHEce
7tzZ+rZDMhNRyS9aExbzUJzYsqC7RQ2xAWcsR5bycL5FuKNcSh1JTmuzVi7n
QYM4e0F9pQZSuVpTStx4aJUkNVc3asLTi3353Roe3nte+SC1RBvMVBMnRU9y
7s7LvOo/qoOhenyyXM9DN+fwz8ZSPdz+t+TYBl8e1HJUpknl6yPSzMMkeSMP
E4dFl3rfUuGwzf/5PX8exubL9gdMpqPtebSu4g4e5CeO5oUfYSJT/pjEMpiH
gG6Oc8UQC35z//PdEMYD/dsxm33kXjV2/W7evQgeDuzvXbjhPz5mHh4y3XCE
hznTrvjv/2CMztKf7UkJPLgVV58qahXh/IhMxL1k8vd3HEf+lYmxla1GeXec
h0wbM35DpgnEnrQqhTQewsNzVJ7sMMWv44Z+lqfJ88JZ09YbmaG6zkZ2QwYP
77JmRex/Zob4P45Xk7J4SLMp3Tjf0xzLTVYtuXeOByXvsO1GlebQ3rJhpCeX
B88TVxkHx83Rk7XzpEIeD0+ifyzLk7bA1bZ95pb5PISxf9GTus0RLJfwwreA
5PfCadvrj5rDGqcjk27wMCM/yrBS1hyTwi/q37vNw56oZ0NR7mZoyL9Z3XOX
B57hTO2LsaY48VayUaGMB7O/A9v7j5vAXaNpmmUlDyyt+P1N0WLQl3Tm+1aR
OmZJ7hSxtwg3742N3q0j+Xxsxcj7cQPsHZZO62ngIXloO9cxQYC5TCVLhWYe
JPELcw1IXrem8Pb7tvFQ9Ovm9/RzTJytNacltfMwsLL36Ms4Onwn5tXc7eRh
k86saW4pVPBFrpt7unkwuvcvxDVUD182eckpvOXhiMmW4DxVbZRmbrtOag2U
fI54VvtTHdGtu118+3hQ+PTxtx1XDU7TYr8mDvKgW/TuS3SGClTsTp66+4mH
6R5dqctzFNERkmPVM8LDGQY9eluMHHKuXO+SH+OhQ+tqw7lOGfi/Lj1g8Z2H
7YNSzwbPTIbxrId03188JAq437glUvjh9Kw28Q/ZDzQ6nWu9ftsTUT3+d6X4
oM8yedre993+SPHnGT2T+ZhUY6M67c9Xe5eh3wXysnzMnS1X+jh5xF6TLrfc
Qo6PzpoQgxi9j/ZvVmt881Hgo+xGas2s1x/s85KYpxOV+fBYHdI/tuit/c77
Ipu7M/nILqmnDqR02lv+tHv1Vp2P41dGdk+Pf2ovZeR8UF6bD99VsllLyxvs
H/qtZVro8fFoaHHPskKJ/bGzm+p8qHw4Dy+/O6coz35XeHRIJIOP1n29gsq4
ExKv5Vn66Ww+ZL7F2Sz/c0sy37C08QaPj5KR2yLTKVUSodzzXY+EfCyviXl9
JaZOMrN3lNFnxEf4pvmOqdlNkl9VCo+lTfjYGJvIrL73RFK/Zz7XwoqP6+X9
KgKXdkmRm0+bqy0fa76XxaXN6pScFu2LCrDno2PnLIee912STQO3O87N54Oh
dFDZwO+tZEnt45hyRz6EZoYf7n3vkZieGzJuX8zHHx9RndOF95JJa5lH5Zfz
Sd37KO+YW79kwBRmHDcy3kY/pmjToOSxsufbOWv4aNnkM6ft/JDk3tCuJE8P
PgYeOumwVD5Lsh+etNrlxcc1s9avGS9HJLG5hR+O+5B7/5t/0c1LvkgCoxqP
X/Pj42xCQnhpz1eJm2ff7LrNfDhJJtLmZn2T2FpOHny7lY/Nzw6tuRzzXcJQ
0z/1ezsfGy6YFZ44+1MiN2I9VyOIj39DZbWMDxOS0cZVw6JQ0l6EzTKprX8l
HZeDzzrv4iPZ5+J/RelShORQ8oLNe/monvH83QzKJOLS+qtfDu7jo9fTo/RF
42Qi2eZBVmYUH8Y6y0znXJxKhGn0ON09xMf2ddIPWgpkCc+vf8afxPJx71ye
Tfyn6YRDi9aFoaN8LF0T8OLzJnlCkG+2TDaJD4UNa+9MoikRqnGuE7RjfLz0
3zKLo6JC/PTdftn2JB/vF/HHvt1TJd7YHV2xmtTN6eueut5PUCPqtC/+CzrD
xy25ReevJqkTBeNEfmImH66sbX9l7msSaa1dqy9nkzrbcnHjVmMdIrLgx+Tq
8yTeRjkVSZ16hF+8WlHXRT4yPm7epbWBSizeZOz5PY8Pg9hrq6V/0wjxXOdp
qtf4SK2q4vNLGYQ2xf+2sJA8b3AuC85mEf3PsuV97/Ahal10kPmeR7TcKLsX
eY+Pyh8RXtXzhERxUrtfehm5xyltlDdrMCRi5itVPKoi8Vhno6ekJya20QRb
+mr4GJ7r1SOINyGW/1kwa9JDsl59M/XHf5kStDv7t1s0k3hcWq3gWWtBTDt+
Vmv5Ez4kBkU2y6ZbESMBxbUBbWQ+97wssWJbE+2OrUFx7XzEq4dppSnaEJXM
Yb3znXwctB/pcL1jQ1yUkmso7+Zjy4zMDnklWyKxixXe/obk79MXPotn2hIh
9+bQv7zjwyzF4FtchQ3hnrquWb6PxNutL6RDwYbQvSWns22QD87E9LO8z1bE
6yd3N9d/4mNBbLn2lN2WxPkRv9ucUT5sfqafi7pnTvgpqUrHjvHR9a9w0Pq+
KcE2lCx5/52PbedbE/3yxcSAc8DZuRN88A/4O9IOGROB8Q9M/kkLoH5tD3Nh
JJcwvhIStW6qAFwT4s/bnUziax21qWyaAIK0lMScHCpR3NukpS0vwE6n4YJH
XG1i99SITbuVBFjZELXg0LmZhDWTe+u5qgBd/NCPTh4ziD9zn/0zVRfAP/vF
quRUKYLwiXY+qSVA/ZmkGpPYj5LoKKMzo7oC2AYuM+n698jeIbvrwzKqAAYF
VrXt/K/2spVHxQUMAcL65Y7cOiyFhi7zA/IcAfoaFAqX3pNB4sS7xq18AdSY
ih5BDvJYqn1cs95AACu69Hu7HGWoWNlt5IgEiG2Pp7S9UUXb6o83DpuS9lq/
X3n9SQ2nwk//fWchwN4Zz7piH6tjTdr8xXNtBHgpvHmUe1wTOre/pOfYkfFe
+5PiZaGNnFFn0br5ZD6UAw0tl+nhSoC03/PlAhwpVpFIcmgISCgoMl0lwOFF
5XVJfnQYXvX4c2KtALVzUlccNmDgZt+dU8u8BWhUdXpd1MpEue/W+ofbBVA8
Z+0QEcrF/oMa6pwgASRxlqUV28k9JKfG93CoAH725z27tvHxoJvye06EAOei
donbdghx5HejY85+AT4/9vhiEmSAxTp70v4eFKAl8PTWyEBDPF7z1LDsiADF
12wGCjnGOLErKkIrkbw/T0mpPM0YbqcMHu5KEaA7/JPrsl/G0LzTqfb8hADv
fu37t3qFCJ1P43xMTwlw+6vOy5YsETK/mBacOCOAzHq5y086RViv0vNrJFOA
3lMzPhROJfcD45SFy3IEuP/vj+MMihjvl9qmXr8ggO6ciwp9dDEubR94M+Oy
AHIvr+0umSnGlsRTBluvCuCQFPApfEQEYf68vQ+vC2D5s3DLqRIRhutHHrBv
kHjtnvJCcacIRf3/zTx8m+Rb2uwNS2aJECK72PvdXQHQ/eMIK98Y5uwf1+aU
CSCkB4SUmxjjh8PFn9mVAnTk/ZjX42uEyLLsQzVVArj0zdeK8zaElPiswkAN
aW9K044bKwwgq59CEzcKMH3vW14Gyav4tKP5q5rJv4JvQc9n8aEoH2MW8YS8
/3W5/JapPKj/3L2opl2AN3pOtm9+s3F2R8jT/k5y7yk8FBE0nQ293u3rFF4J
4M2varvNYCHH079P9FaASxY2YuUlTDCf+gatei9AtEQ2PzWWgbxF6yb29gkQ
8GPmDtkndAiJ1YezBwWQ+mkR/FFIR5H5cqWaT2S89RnLE87SYHLd+Uz/iAD5
VtWqk7VpKGYsZCiMCZBmfHvbonwqrM/OuS76LsCjI0bqlkupqFS2tVj1i3zf
07L35CQq5saZV+39IwCtfsNX9jF9PPhjvDhbSoiMY9ZGDbb6WBQqeHZ/shB/
3gwt3iynj0eDrPX9MkJsqqQfdftBgYsPdUBeToiD2+q0xqbqo61dO0SkIERt
2HBfgVgfa5bO+uOmLERCd1W99H59dNUoxe2dKcRTLW+nvX36WG8jp5KtLsST
RXtmeFpQ0XNjSsZ9LSEaxM8Ui49SsYn7j9mvK4SPSyg9f5CKwayfBfJUIXQq
vo5S3WkInDVmKWIIoR5RzpbqoOFLwnC1G1uI3uDykyKy/sImDTjv5QnxNTy9
98xfOn7sfvc8SyhEwLTi52qXGYj83O1930gItz+zbXeuY0JqU8dgn1iI48cY
fX40FmK6WkPlzYV44b37bvIXFhLq64642QqxbdG5GLNSDhRRrbrXXgiDtfbS
yqSOP1Fcnpk1l4x/m/Bn3XUezl64UdTnKMSsr41WadUC5O3L6NjjJkSBukFo
3xRjCMfSfLPWCMF8JpT5EmeMoq3Hhqo9hJi/+0/Y4ykimL6ND+/zEsK/XPaZ
2x4R7q4+LCXvKwTjnPd3vBPBuvlAvPFGIVbsl+9fAjEqHfaqufkLker7wtYp
WYy5ZaFZe7YJ8UVjZEDQKMYD0Q5uViCJx/JvhrxvYjjlbblZHUTmt8PrW4uc
CZoofrZ9oUKwzvvd0p5hApc0rwczdgvhOsE1OEjeb5ux1sU4QoiZl9nWkxvE
WBO9onPlfiFkPGx1hUfF6PqxxG/PQbIvzbh5TNFUDO8djsP/xQjR+GzDLatH
Irz7MHd3dZwQn2d/TL1M9pe52c3n+QlCzCVkFpQQxshZ4950IlmIlwqbVqhS
jeHVGETfkCZEsO6JOyGxBqiI+ePceFqIXU164Yd0hNC1O7rLJFMIh6Xs4WRy
T+gsynk0+YIQljI6b00HObDaKvy+7ZIQO0/uzHlyho3TjHu0titClG2lUde7
s/C9a56z7XUhqtZOv3bQkIlVp1rCc4tI/3cIDUWaDNxZ5nFO/rYQLjmzzzdo
0qE2va8x9K4QR8ebHzJFNIRUB493lQqxW5wse8mHitaIv9T5lUIstgn1u7VS
HyKz+MXXq4SIM3B4JKtOwbHhWeGzaoXw9JEa2Syjh8+Xz+XseyhEz2yrmitM
XSz1MWj80CjEj/KET+E7dHBdu+TbkhaSX9lLy/w+aEO+zYFa3CrE47VTlaYd
1sa2pMdOlOckf7P+ek0l9XTDAs+w2BdCmGyss9Oz1QZPqj97uIv8/ZMYwsxV
G0dKQhpWvRFieJ6/nE+CNvqC/41VvhPig8y37W8HtLFAmKDP6RPiV8j4XEGA
Di5+UHdKGRTCQ84/8b2KLqZknw/9/on0L/5X9LtOXWxYY5i9flSIaUEfd/Lq
9FCtUlpfNyaEXbPs3O7nFNAa548Z/RAidGVECW0qFVExTyinJ4QoKnVueFFE
xevZ6xZJ/SP5NjkwoDaQBrvv/SH+kwwwg6r3TcGejv+KQrMeTzVA1OjO+000
Bn5vkaq3nG4Am7CNBVM0mCjt0qBMVzaAS/NrvwkLNrROXXAMmmmAnTntW/N9
Odi9zCjkhboBjs8wc036jwvz6gUPr+gZgM3QkyyYLcDNy2HBTgKSV61J12dt
MYaKj/R/Nw0NsOToRECMhgg7tZPqtMUGaK0ikviVIrQ81fwSbWYAi4xDA+5r
xTBMytX9aGmA17yFJ40/iJG0wHjhClvye7d/xe11Jhj6VxZUZm+AMemlDQoS
EywuWZjJmGeAiMAzlXemmuJq8NMHCQsM0HTpQfdNQ1NMF64f/brIADdajyc3
WZjC/8OgjucSAyS3/3pQqW+KuqzwBTUuZH7a7SKX9pqAvWZSkHClAfJaHKet
TzTBYZXkjNTVpL0J85W9M03wvkHrwW93A9xe6TKl5YAY82Iujvh5GUDrya7K
R09FOD9bpNPkY4CP1qtK6GoiVC+VOzThZ4ApVv4x4SuM0bP+3SDP3wC1VN35
vapGYESnlcYGGmB/S9jJWY/JuX0ykH6H3DtS5jxef9WQD7/chfHvQkl8vky/
NJHKRe6Dn2sRYYBFQko6M4GFmvbWqsD9BghR+hk/g87E+/583n8HDXB/uuer
1810TPkVc7wxxgCTzl/qczhJA3OG18+fcQYIXlClhp1UOOha+HATDHB++6Bn
ziMK/AyU61clG4A/u1R9+kddxNgNGB8+boDd+oeG2TYkf5dVn76VaoC9XpvC
u8u08MA7Q6on3QAm1vvH8rdpojco1F85wwDNtVKjTY4akDm05LFdFomPA16t
clUHO5Vtuf2cARxf3Dq26NAsLLj4Lzsj1wBE/kf3/C41bCrukG24bIAibm35
SQ81xNbd2PHjqgHu3F+23/LvTFzqiG9nFxj8r6Lrjsfq/+Kysmf2euz9PHdY
STlkZVXKaJBQKRJSISurEpIiq3wTpWyRkjzXCKms7JAiUbJJQr/7+/Pzus+9
n3POe5xzXv4AaeIGob/rBaFpyt3QvkwTbqi9tnbOF4SJNYPHURWawH2RIVyt
SBBYuYR5y6s0IRYLX3ToEARlqdmLo9WaEJ4r1y3Ivw0sqC0jPLWaYP7kl+97
n23gafjAbGedJoyZOKgrTW2Da/uCi70aNaEkvifqX7gQ5B8/IJzRrAlCjDZP
fHBhaPHXCGtpJfkjmfCtlkkEJqNYJlY+aMLEgMSqz7wIsKWM2Ch2aoKeR5SJ
2oYoqDyqqjzQrQni9Q/ampTFwaIqSSqyTxPszf75GPpLgGfL6ZjSQU0ItfWm
PB2WhGsDxr9GhjWBPvRzCPGShic/JOy5v2jCpYPvvzLyUKD171LNjnFNyChv
XXqySvZzrjaFM981IW/YQEd0RRY4pB/Hp/3QhC/4hdsEqzyo0SKWmn5pQvdu
veZ5NQWwhENHl+c0YcPpQeJbN0U4sx9rlF/ShAD9d+ySxUrw9Pz47Yg1TThy
s/bMoxBVaI1+/bd4QxOYmgO0nTbU4EdKqvswAxWkr8jaGsVrgPoLC1x/KxXA
2P1mczMNrN/KZnpyUGFW4v7h1koEvAfXGO9yU4HevLIxFYNC4Xph16IgFVx3
tHEfEsDhPXesvpwIFa78NXps0kTqXfpYzj5xKqgnu//rPaUFXIgeR7gUFc7X
nCkwX9ACDSN+/yIKFbJDjinNuWqDtd2PgU/yVJjulVVPKtEGb/cGIw5lKtAE
WG6kDGpDfEDWEz01KlzYj+q6ftaGopgL/Kc0qRCc3mkbXKMN0wbOkTEIOcd2
2NxLOa9NzhMmiw9x8nxddzGaRRu8CjQ86nWoYLk9Se1eAOk3btt6RrdTIeXg
tUHjRhx+iK2b/jOgQveXKHi+ioFq59hzKaDCjumcrA5hDPINn6UdNqPC1rTK
3hoFBCZXMtiD9lBhuPpNd+VOKigXRwbftabCSLf96l1NDXgkaXe0244KDmMa
iXUUFZj4uP3Dgj1ZvwQ3XRNUCRRvyO7iP0QFjrKLyx2OCpD7Z07G9hh536lN
BZMlCoyX9id5u1GBq0Pp17khaZD3JLbcOEGF7amJ51W4JcFNJt//iScVWsWu
SHUHi0FO782xZi8qrNGnnCMUROBLwqWDE+TeQz0p5eLBJgQU02NvmP2pYDRe
+EBUQRBc18105C9QYTfDKNocwA/Zz6iPjQKpkBj7oz1/hhdGzgiLul6mwln7
84+27OcGabnNa2FhVNCSZBRk5+AE54Fvf7Ku/L+eH77tEWSHrKQPZ15Fk/jI
O7fEndwKQ+aVnwauUkHINDXj+wYLSPzLsl6No8Lb+lnrsY/McPh59GvhRCo8
XNXjDhhjgoyz3lTtW1TIvTT3kUOFCQYVDmYfuEOFGKHYvXfvMYLY0A4+/7tU
kAtxZr8OjOB0W/5KUgYVTJliKG3cjJBmyblQfI8K8htOe7oYGaFvy6Lbh/+o
8I3eZBEsxQjCLwc//nxIBalt7jspRxnBwbfehOMxFdaXnSpvvmaEFOWnlSpP
qXCA5eH0FiMm6B65pWReRAXWEqNP4hNMsC016O6JUiosGsYXfStkhgM2x9mi
n1HhVFhjVWcKCyQz7wnKeU4FzcmRs6UPWKHrFfKDeEkFs+9Plp51bgX+86JH
PtdQwfHwFk8fZXbYp8bwfoNOPm8tonXlckDSl+8Gkg1kfc6GH0CtuaAjrb1I
v4kKbfs4i3ZSeIB3X5X0obdUIFoKnjAL8IHt1uybl95TYUlO5mKUJj8k1sYy
pLZTweuQEneMhwC0XfDxq+gi4z1ZNSH3UhC4NR2+dvVQ4cQUk0uuphBYj+88
MN9PBQXPP6uXG4UhPlOxkXeICrIzJdy7I0ThvR23NvUzqVelZOozd3Hg5FjO
s/5KBUG5S0pZfpJgWTck7PWNCiVS1As9hdIQF9h49fokFZytlM4JxVPgLa1w
9fFPKpR+fWUm+0kW2L7fPt00QwWPb1tcX5vIw1V7dyumZfJ5t6UExUsJcvYO
HT2xSgUTjbKxwr0qULPH3qf5LxU+7krb2XxQDRZ2mt+6wUiDle6I/25WkbrQ
I3J+sdDAJDp8t2EsAsrY9oq97DQY2ZjrGq1C4aiSep8gHw1UkC9bB8S14BIl
d/KCIA1SJn0aWndqQ7K41FqfMOlzosm1hlY6ULgtlVNfnAYvGSLFZbfrQjMP
r1SWFA06tdo0ltd14SvbNeomhQaeM4GpWfF6sM64BVwVaKB86IiX1mc9ENkI
2l+vTIOuRq2ra7/0APu94KagTn4vekNHrFIPbOa9AmKpNOBz1P2iqqUHnj/H
YyZRGuDVFrsP++hC5Dfnu5baNGBbNhNVOaMD9z735hfq0SCqWMyIQLThxcDe
ah4DGtg7KSTLfMCh62PLO19DGnBve28kaYUBW0v1jJYZDb4F3li7qEXqoB5n
uLuHvP9LRPbyPzXYVVPI/8eaBqHbmBKDPyuD03NF+SP7aJBW9bbl1mcFOF96
X+v1ARpkyD63Oc0uB4lPRcxkHGlgyD6uvKtJGvJzkxyvHCbjsXesdhwVg4b7
7KfHnGkgIO/UUu4uBCNpkcGmx2kws5CU6L2XH/4k/73x2IMGryMuZDADJ2xL
CLjH7kkDrq0vI7f9xwzUq7+KvbxoQM39XAjuG4Z7rpwkPvjQ4K/NRMLedwuG
Hpc/d9L8yXraev85UfbVMOyC09itCzRgd9oX33KmyDD9XOfSYiANGsysNp/7
DdIrTluyOoTQQIcjQfNM9Q96u3uDyItwGohf+bqiFLBI/+FsoCoeRQPZ/QaL
L9dX6TJ2VOuR6zTQ7lzma3DfQuhbP3aGBBoQysL/PmQyEQfNKOdykmhwTKfK
OqOahYjTF0g+eZcGrtWcoRc62Yk8rRsPWzJocEiDf7/HICdBUJkr1e7TQF2N
8RPDNDexLLfSN5NLA83l3v2jcvwEn9S5qX35NPBgle4rthEg1EQm18oLaNDc
3x7qGidIuHIOSl0qJ+O98MFsxlSYCGY5QBuopIHen4KYuVYRIuXfO9jxkgZa
4+GZSj5iROkfE7t7NSReR88YJ2ISROvia/d/dBoER+GVQhJSxLdfOheON5B4
Bemr3lKTIRgmS2IbmmiwLJKxv6eMQmgPPXhy9QMNXqzpam9oyhN8VM/Vkg4a
+Hi9oXBeUiCmw6nm/R9pEBDGNyjXo0jkyr8aVxmkQe5Zt4y37SpExIUr+P5h
Ggybs42/PKNGHG02jwwapcFAXc9HbRENYptXt0zrBFlvn4pXrOk0Yq4mw2dh
igZMN0yvTpYjxHue46/Ff9Egx/id3Jl0lMh3VebaPUeDEyKxmFMIRkSX/zrs
tUiDIo53jK6OOOHKXPHk9gqZb9UIlqWoRRg4BK+++kMD483e4MovWoRoPpiP
r5N8vV/QLhirTayFMFmxMiDwUti1U5Zbh5jMO+mfsQWBCG7biPt+OkRv29t0
KhMCHkJLbL+LdYjG3xp19cwICLVN22bX6RDllKRJB1YEhGXvl7k+1iH+27PI
+3MrAieOFGgnHdMhEv0ddMPZEWD4OB6k8lObCMl86SLIiYB8UsgE3VqbONMo
GfuYCwHdm/1Gzte0CKdf4UU7eBDIkqLvQR7ihJnwWHc7LwKdvn3fdR9ihJzn
E/lVAQQyRWxDn3gjxACnTp2FGAIh8nDOPkOZaNJKnxwSRyDI1WQs/awiUeG8
zusniUCGZFHl9yPyRE7sMV0WaQRacv/zFzgtSySV1LukyyAQlfLyGUaTIcL6
FWM1Zcmzfe7Rgk4JwnvL9aI6OQTOCHK2OlSLEofVprvtybmmqyS00ndSiLA4
sHd9ShEh+1OP1b9DgoROSLl8mDIC+mo6/rJc/IRCnpCVgCoCal2MDrkr3IRA
W6D/IzUEpg4KjhibcxAMvz+l62sgkHxhYebNlq3EjIxhXZsmArHX+F4+lmIm
hixyJt1oCPQSSSvnkrcQrX4sfL8RBLT0L3+sK9mkv8jw1L2BIWB/56wi8n6N
/qjhnYuMFgJlAUPee7x+0+9MU2OfaZN4io11aIYv0SOFkovMdRH4Of15le/v
PN1313L3Jz0EHut7nrr8aJbucspp/Zw+iY/K9zsaaz/p1kmv5JkNEGgLnLkn
NjJJ138pbZW2E4FzgoauNKMJusrXK/4ahgisHwtlMt82Thfm/JZOAAIG8vsk
WC2/0pm1LOoOGiPAdZ25rKZ3lL5wtGBycjcCb2e4ZONcP9NHY3j4Qk1JfOST
+OiZw/S2Yj9dfnMEZgPKeFX3DdFr+rpd8iwQwDIXdDT8PtGfMujFbrdEYNCC
7mCxNEhPU80s+mBFzplXhkMnOgbpS4tmeVE2CFgk0RLKt36i761dyNq+F4ES
ByfBhTTy/Wv378zuQ6DZc6FtLXyIznrAMj7PDgHfASvtxZfDdDeplagjBxEI
VRDyKTL9TK/9/uAyvwP5foXngaZbo3TxcpvzzY4ILM5Ff3zx9Av9QsifM6GH
EHj26oep4+xXeodZnht+BAG5Y45lDG7jdNL2Dk8dJc+KTautLBP0a5/W92e7
kPc53aVdHflOH8/L32PvioCsJrNiy9wUHXwPGnG6kXrIdjk8YzRNz9Rn2F7n
TuaT3p6G98/QV5gLkUsnEJAeL7NxGZ6j27U7qmieIvNZVDbtC1ygF6czUcY8
ETCUDSlR2L1EZ/coEUk/g0BNC53vitEK3YN6hHevNwJWaDPaGbRKJ1ZZt7L4
IECcFFmtXFijSzaUb1afQyB+fyn9v2cb9MAElxVfPwTSeeo2LrgxEN2OHDNK
5xGArdmOf0QYCZrc829DAeTe7yO+cucfExE3fXw4+SICtv6Xd0nLsBITz7l7
LALJeK+hPwVD2QjjKy/fbwaRelI4ZlVM4STuW51orLiMQIKcve4MPw+xJsRf
cyaUrE9HumdXIR9hP1rzjBKOgI5KXzcRIUCUPvUs6I0g9XZY34wjbhvBdWHb
w/hIBOb35+d4tAkTnoZEhnE0Ar+4ZgR+HhAjGti9k1djyPqtjQ5wykoS0t0i
ccVXEdDwss/yNJAhgu83XPG4Turr0RmKnYMs0et5Lkj8Bqn/QvObnAbyBIZL
+HXEI/DGjGsNsVMkEjeaPGMTEYgr5v07RfrNVLO/q0ESAoU/+9dsRNQIk2Rp
p4VbCKhM1XsPN2kQ/x1t3Zt/G4HxMgvlT49ohNO8rOG2uwjcHY7ee3UGIype
fdBpTSP5VHvM7lqCFsEbG0SNyECAY2ZKt1ZdhzizT1FJJwuB0infGaxGl2gS
75SavkeeJS7fU6RtJ+S+hQjlZCPgN1J4+4m/PhFaosLt9IDUu+TE497zO4j+
oG5mnodkPU7+Tr5KMSC0TCLWG3LJfHw6pANOGxBJPBpLQY8Q+PeDa9rCxID4
2d/3k5ZP+nvEJ1eroh2E2cOosW9PSDxs5wWE8/WJnLO0T5kFCBy40aC903A7
san7qWt/Ealf3c/cM5G6xCHGq61bSxBgDjJd/UL2F767Iy/Pl5N8/FV6fU4O
JbyPx5WpViDwLeKt4ud6TaJFXefJZ3Jv1v72QAWxVyXCiYQ0q5cIrOTWet3h
lSV+DBN3/lST8djqWD5rEicc/i4mPa4h66ldCEcZtxF1osoJ9rWkH5StH818
yklo6By+zkQggLBcqzQLZiDuHkiIKasj65nf6N6ZOUVn9COuHGtAYEh/UewQ
V4/h2cTFUO43CIQtdNjFnl427C9QCn7VhIAS94Av248tsPvtoYunW8i5WaL6
gs0hNiieiPcXaUWAVn+0yVKcB8SZCZ837xCQ1LlTsvSAH2JkF8+c/0DGV/ly
dHZZEOZ2KZ2SbUeglqOE0BcUhqNHD7m3dyBwi/+IFsokCthd+hH1btJP+2jv
b4RIwL2KBceBHjLeF6N2T7dJAVuX4sGrfQiUX19pWMmShs9c8dZjgwjceDsl
UPuWAvGRTjszvyBwhZXiIfRGHibOzktzziLg5r+F1+ahGuy/oSDxcg6Bsblv
357dUoeafEeRUwsI+NfLSEyGa8Dtsde8DctkP5Er5dtJ7uGbDPOcfr8ReN/I
KtWC0OCMtAKbzB/Sj3i+hjIzItCzw5H5wxoCwWzTSns8SB84FMdweZ2cD1pn
Wr1fI1Bw8fW6yiYCfOU3Kp5woiB8Z2619x8CTSx5XJY2KESWyS9Hb0FBhlr9
6mUECr/aHOYxJhRmKLCYlouC0/T1X6PMKDhvCsV/IPeTRvbXU4msKAQ5Vtbf
fokCTXnumwEbCrWFn/qvP0Ehw0T+6w92FHKO2MW8uIoCi5vDSBp5r0OJ5mbK
QRR8w68PmnGjUFdf9oqRH4WhrJreJR4UNH0HVYxI3phXz3bl8KHwNbbw26Qz
Wec+ufZ9Aii0r2XXFozRQHrZ/t2mIAqVox09quTetUSraTgsgkLv/VC9gFUN
OGYzS2cTQ+E5vhT3d1odWs/I1TwXR4H9xf7mQ5/V4L+8axUC0igcb7r8Iv+9
CnA2vColZFBYOGjWq9mmDBdHZwp9ZFG4k6d3/8GgEthI2Oe1KpB16SvL7pJU
hLRxKnFECYVN3vbObDcFGC9i+zStjIKO161HSVXygFz6uhyqigKroEKKuaQ8
hEANH686CmaCR6bRW3LQwp6q/p8GCotP9zy/KSwH2z6eM0OpZL43pRMuF8qC
a9ae4/U0FKrFiKV5O1koPCEfcgBFgYIJXOpnl4VV6kbqOIaCD8dUGFMnBUxW
e8suaJHxPZbt3JFPgaS60vesOmQ+treVdt+kwKe4uO93dVEo4PTd7IuhgNJB
D0bV7ShsVXhf/OIGBfyldklV66PQjQ5V5P1HgdoJET0rAxQmbWX2uDdSgKN0
3m5oJwqx704frV6hgEPQu7NnDVE4K/q9NlBXlpyD865tAgoXuxwLfWNlYYYz
/OFNYxTME6kfL43JwvYep1qKCckjjd/ZJ2zlIPo+NlBmikKIV1EtX7McdJzi
WjI2R+Fac7OctY08SKITPN0WKFzaZhw8NioPnmt01ROWKDC4KfunXlGAioZ0
kxUrFNweMIYK0hSBIeH8saskj2OYDA0WJkl8ZJRTnuxD4XqFuV1GuDKMTzKU
6tuhcP6u446vh1UAKR9sfXcAhYqLqt1BhqrQbJLIMOOAQqEpV5GejDoI8HhK
hDuhkHVw3+CGsAa49Bnp8B0m9dHh3W7Mrwkrp5e9MGcUGEUvbuVjIud4vD22
wQWF+qw+8ydLNEhcz39w0BWFF45nCgPJPj74JrLm23Gy3g6qb2WHSB+7ebTv
ojsKLQyZu08boeDvpLOw9QQKbRa8JPakjmT5uNNPorD9Thxd+icKHD+nlNU8
UcB57T50q2NgX9Fg/Oo0CgcFI7cOH8Xgv9B7ztZeKNzq3R3ZHoLBtNmlwGFv
FCZqPTVvx2Ggx7f/to8PCkSF5t+zMRhED6gV/ztH8iFmx2vesxh05DC/TfIj
dXq9QyndCANJ75Ex2fPk7/X7z9xjwsBT+8VmeQD5XCE2XKoChWebt8RMLpL4
yF7mDCP1vNnspdVzCYWoLbETgRMIWN4y3XsyiPx9+zN9TnKu+Sr/J/paCAq2
KSISkZVUoP7qyhYLQ0HuWX/iTJImBD8vrH4aTupB4+Glayc0QGCP69z7SBRE
nf/bFONUAxcBfU6XaBSaH5d75IypwNNPgkqzMSioxfhfP9qoDEY+zUf4r6PA
dzUroj1fEdb6p8wa41BgE3J74ZdF8mU3F3YpntRz6n99UQ/l4WwxVUotkcTH
81j9ProcKIntZxu+iUL0qpB6+ZwsjEadX7x5C4VvKczNsnqykD6TMmJ8m+T7
RZ/g1hQK2B168Xb5DgpWrL8b09gpwNU4WJGfSsbzQHbjtpIMNFE3so+kkX7Z
ce/mooc0hKfL3ODJQCH+KbnyfpACPWbji3WZKFw+cjm/0UUKFnw8jgfcQyHV
0PeKhKgUFA7EWitno0CPKp5wWpWEEyZPdAf/I/XHdMry6qYkSJe8k0vIQWHX
licv3qlKQb/YDDeQPp0x+ZjmFSQFydF8fxbyUNCvls74MC0FVrPYeN5jFOwk
rt0Ki5IG5sP27U6kTx8TuvJbfacM1DZequYsQMH40VfDTi4KBNIy8moLSX7j
7vwe8RRAM2qS/IpJv40/iVhKycIP5s+XFUpJPR//LBJFl4Xcc1tO9ZWh8Cg8
+hnneTlwGZS3i3tG+pe1SWqvrjyImJrt3FmJguXmuFADtwLEid8QfPgChSQ3
H5eBn4pgElO0aV+Ngsb2K1HLC0qwMds+xVZD5qP9mHONTQV832wjfOhkPt4z
ftpH1UAN0S2QrSP5YbOrMzZFHcYyDqV216MgK6jyoKtHAxx873vrN6Gg6HG/
CnWmAd8nwvFXM8mfq/65b8g95K3pmPF/b0n85kX2vfiOQGQpC/XAOxRWR9ge
hZG8NZBQEWP9gMKDS/9iZ/+hsBJjyfyyjfRbt3zvhksYlMx5z3p1oFD8yiy5
YpjUx5Gbg9JdJJ8vtWvnUXGQayp70/n/v8uZvG99ewqHIaS7NLqH1IdqsXl3
LA4pmSuZun3kPWbxwZJxONiyil390Y/CvuCaNLovDmx+O/zvDZL9dZodqdTH
of6Ts/O+IRTCnM2V+iYxuGwWYcE0ggIWST3ST+pdqywHf/4ZhYZZzlrNP2Tf
lngjffoLCtZ9fwOmSR/Kj/3OLjmGwnCBfca9KgSOz7Mvt42T+e/UruTdgkB3
k+07rUkUXJL1u8791oBE1O/59ynSn6i23M881cE86/aDDNKHYnWeiOcPqUK1
X/8lhlkUtF1WxYe/KsH5oTW3Z3MoeOfVabOGKYKGuZTtyQUU7l6zb6vQVICJ
MsPtYksoPFZWumK4JAfZkm4K75dR4Ho/YmTyURb0cXWq228UXls8rPIbokD3
niXd1VWST9LZPKdWZcDH9bVR4hrp99tc4zRPSAPbpVgrhXWyX+Vyo29JPeQk
7LWv3kCh8wbrSY9GCTDIFT22j8TtX1ft5ZEKceit/uI5wYDBx4TbBeNtYuDb
+dQ/hBGDN6YJuVv5xYBj8nyIADMGYrpsDG1BopC7aRCbz0L65vfCEw1bRWGX
EGvSrq0YfLF41RL9UgT61dvTu9kwUHpL6LUmiIC/cdrDMxwYJDMU2PpEiQDX
oeNFDFwkLgKVxefTReDRObWqVG4M7vVhHWztIgCxi4QGLwbXXIrM4+RFYTCr
prWeD4PlQR4iKlUUAp7FdDsJYFDoE/ilRFkMeFptR2YEMcjfL/R+pVcM8kdF
JqOFMFgX8eH3zhUH49+j8+IiGHwWsNCzSpKAIe6nf0tFMaAfnaEtZkjCRYXz
LObi5Pub6rGjjVLAv8OAd1gCg8ZTbSqPeGSgcD+L2HkpDCqEgvX9DShg5tkm
xy6Dgc37FHkZRtIPw+5qZFMw4FotGcjrl4XgFFcdbTkMRrxoW0wJcn4pVIV3
8hhw3/AxVXgpD8X1C3uOK5L3/zq+aNGgAF9no50TVDDIMnPrC+JQhhBW21Py
ahhIPb0n6m6mAsJSIn4vyb52/X6VnfItVbC0fBL9jYrBFtV9F45Za8C4q3/i
ZYTsc98vcP2q0oSwSzvS+DEMMmK+Kbip0KA890PBTm0MzrvXYyrk3Gr9KrXy
ow4Ge7SYE8PIfjXReYx+Wg+D/rE4hlhnDCImVd7+247BC2wvrXINA/F/810p
OzDYVBKN338NJ+vwakh9JwYrgSnyyYxaYKsRPVG3C4NVLHDh7QktmDS2mXME
0gdma7+nFWtB1CHhtV9k33wd1H5eelALpH0/M0XvxoDNyOWN2oQWvIjN5xY3
xUDg+X4bz04tsLvnJ1JqhkF1yXpQYKYWTD/TlzWzIOP1zUIZTbUgtpVJfWgP
BvVVL8UL23GgfHmv5W+FgSlXNGXrLhyqf6fsYrPB4L1n3oTnbQwO8hyzuG+L
gVld9EI16TszCip2Wvsw8PX422ZC1uPajvkjrfsx2FG69DxACYEaz6hzKwcx
cu6rmKGVk34Zbh0U70C+b7+5wfNFDeZShKLknEhfuwDHXgirgkLD41TbIxgs
8WjsCyxUhDaN1dwhcu7gXe9S65FUgMBUi2dnXDBwOR22hT9XDuQY0utWj2Fw
xfAAE4uJLLw7PdUee5zEU9dxtOivDAR83D6yzR0DPnnLAuVcKZDeGTed40Hi
WVAdn3xFAloeDa4hJ8m8OKIf77wtBv586uz0U6T+Po5UDvSJgGTwZRGb0xgI
evZmPbARhjdj7xQ/ncEgVJ6RNXxhG/jYSGqd9ibvtxjWUW0UBNEqb+Pf5Jyj
K/Vf/S5CAOopr/fFnMOg0uIJ95FxfvCO4z4m6IfBMQWXc8pUfhBecj77wB+D
5zw73nhm8gHdufgyLQADmYMMY+xqfODZvHn99QUSz66bdLNSXhBA96ZZkX3B
63eDGyM5w9VkZD8aCMQgR81001qUF04yz1WcCsZAUz6e+z9pXuDzgYbly+Qc
Fx5W8MOJF172JXVGhWLQ6Tf6IvkNL7gZffnMH44BmpmnXo3yAVcBOpMdgYEq
R6zqXBofPN8Wua4ZiUHcvvtsNqL84BrWxVEThUHQuYzQHyX8pJ/JiVmSc96W
yle1oq4C8Gz/eeX+WAx+f6L2HFUVhKOvGrRPXiP5lYK1+HBtA1bFbSZL1zHo
Y8mm6XIIQWmih13kDQw0jE2vvZcXhsOrFa58CaRfiNEfnzssAsxuLOfuJ5L1
Q0cyr5aIQvE7+1CNJNIP9qjYZymIg5P2oxvVt0j/k2zv2PtKArZkr6RbkDyt
KY3ltr8gBU/ZzPN772Cg1ph50OOgDBz0v/vcIxUDhk9hO4SLKJBvqvcxIh2D
7oASy3+zcmBXcu0LTyYGKR5HNvRRBfgrOjCblYVBK19qqMw1RbCdDuJ6mU3q
l/d0gedFFVi1bxU3f4AB46+Lgl5capBDF1ftycHg7v3hWf5KdVhOfmU6n4cB
c1up/TOcBvfXOQ+GP8bgx3HBY/MRCFicPOrG/YSMt+N83zlyzl5oL/TNfErG
KwmxX/aSPrZ9I0y1kPQDtj1/aAgOZg9tEqqKSD7ma4oVsGjBLNf9TNMSDG5Y
H6mWe6cFaRdnnnwsxcB98+c832VtMB7d9eJ4OQZDL37P9vDqwPSem02zz0i/
/6suyxStA6nPPneHVmJQ3r0ntKxLB0AKGeOswkBaJ8J06LcOTMVGzKe/wMBR
vWlf+ZwOJM91/FOuxkD5xJbRvlc6YHBYluf5K9JP+x74JB7SgYkGP0mT1yQ/
2m4vVL3ThiTNerWuWvJ9wYuxNULakK93hD2SwOBEUvq+YypaQN+99B2tx+BQ
elJqgigOvbYJTV8aSL+7MWt0YIb0l0NKebfekH7gtzb1uwwBlhP0KKNmDHrk
fG4y9FFB0tfJbb4Fg7Fq1qg7JhpgFRsns/89qR8tG59yUAa3W/KbDG0YTI6d
Dgz7qgDBWTVDpe3k97YatVrlycGtx/avXDtJfdRVPgtIIPlQPpPO95HkL033
uNoOKSBeXw0kujHg4Pg3/6BIDPpaKI6+vRicrErN1fEXhpmPL7Up/Ric0vzt
tBArCKyf7bZ1DJD9oeRpXsgkH0j9+LkQ/onE7+LCOKMiN2gtR3fSyDnOVTwg
VZCBHawZpEs/j2DQfs04LNqRBdw5qxJvjpL+buR//xSFEYKF9501/IpBLyuz
aU32pmGy7JTV7BgGt6zFf5Y//2P4RCNSLfsbyWek3/+W37IhoSvBvvc7Bjv9
Gkt8Xs8b9htXfN8k57hxTh3lCP5fhrM2Nk3FPzBgKRe074n9bsh6aCLXZRqD
bwHtHfGvvxpKe4RH8cxgULDY7X5IZ9hQ+5yoW+0sBlimxMAYb6+hdXAZ+MyT
ep25/yOtut3QI8ZSRnqR7F9HFKpq5hsNLyeNbXxYwmD3P/b2WuYqw+TMkKHQ
FQxsB+qNHePTDZ8+EnqluUryL89lpvzjf/S6suL04T+kXgp9f4nXVtL7a8wD
E/6S+L2zGAldJuhzzaMOOzdIf5mV1T6Q1UTf+jFI+9cmuTeOCh+qX3xH15kq
WLBmxKH0d1JOi8BHus2SSec6Ew6064XGmuk9dI9/wyWFLDikAlWnU62fHsJx
KfHoVhx85QNDT3QN0m8L8Z3lYseB4Wjsx10Zw/SnlCdWNRw4PDDeXmdiNkqv
VzdW8+bCYfejUdHagS/0OaOA7+94cdBB8znrPb7R2Wy4my7zk3N15QNDv1Pf
6TJOj3LVBXGw3nrGZDpjiq7jbhj1aRsOzzrXt7xlmabb+vQfvyGMw/GtZTvQ
khn6iSA/2EHy/r547amw9jl6SDSHzE8xHD6EOHRM+CzQ79x8uJEhgYOCqprt
Hf0lekGGwZClFA6Gaazfe3VX6PV5PdVr0jhM28xVxXiv0gdLfdKfUnBYEJd/
o/Z5jT7/amvgYTkcXFMFRnjvbtDZmv9z4FDA4R5H8ldZWwaC0rVdu1oRh+vP
H1p9/7uF0B3uEjyjjIOWQti54QEmwnbSa0FMFQdUM4857RcLcXKRufOtGg5G
5vQQ851shMtTk7ajGjh87fghdPUBB+FwPPrdrCYOEkduXpEw4yZsRRtbImk4
cAfvZh8V5SPM2pmahFAccA27gW+V/MSu2N0N+RgOczbH74iHCRI6O6OIHVo4
cMW3uL29IERQl+pft2njkP3LYfz6AxFCqYDx1XFdHPyatWd1WcUJaTfjF0t6
OPSHHV8by5ckhMUiK6+Se0wxospZkyhD8HTUlYsb4DDRZXLjvIsswXp1S2nR
Thwe8rIeUJGUJzZ3GhWBIQ7LCP6qhFGRWFmKePoRcGgreLTRIqhMfHNjyPuz
G4ecnPMVLS/UiSExyIk3Jfek15/Gta2oRHdHeLaMOYmn+55t1EiEaNz1L93U
kjwXnbjD4okTNcu77vZb4ZBgLbTsP6FFVBSG3fGywUHDwHCex02HKHSvvbVp
S+L5VCrGuUOXyBXfTLy1Dwf1aXXGKYXtRFbnzngFOxxGnu9ZqtyvT9y5Fnq9
6gD5va3VU5wWO4h4w9exlvY4HJks9Lj7ZwcRvbIeNeyAg3Pyl7zmQwZESJHB
FV8nHEqiXzHoHzMgAjxCwpgO43Au/96hWWYDwlui5nLqERwOIsrdHFY7CI+u
v4GqzjjQJ/qRXzr6xNHrOy7WuOBQVX/6WG6XHnEQLp/f64rD27ScuA/quoT1
72rfr8dxGKg2MVey0yZMitfOXnDHIcLSIUPA4f//b1rfi+0Eia+6U+l+c5TQ
kgz2zDyJg+Pa7TpuTyqhEPfHre40Dkn3zKJ3HVYiJI22ux70wuGUtE+rxB05
YttqoPN3bxxU77z5x8krTXCVvDgc7IPDTdHpnvsBIgTzyVVHbnKPdR5OHzR2
4SfWJfXs//Mjvxfeo5ubtpVY+njJDj+PQ6MDn2LmrzX6dFzV3qYAHOoiDlwz
Vf9CHzP6bX3oIg4GGmLvzAc+Gw6u6lhOX8KBusM9LmJwxbCr5KJ5eBAOX3oV
7jZJM0LryecmApfJPuXHaOsvzwb1UitGeSFkvJqF75oSuaG6W9tQLwyHK7i6
Z/d2fii/ccHgXTgOLhq71jn8BeGpceV2lys4PJW/GBUcKAQ5f5Z05iNJPs6Z
LW0eFIGMUi2t6Ggcbpfc7e/hEYPkUwGoCLnHZ9cW1d8rFIfInkX1nddxkGz/
VXihQArcyhYo12/iIN8icijinix4Rx5Yt7yFgxSnxq5Edzm4cKCij+s2DmnW
3TZjGvJwbflCYlIqyZ+I2vWTbQpQvP3P37v3cBB1NFyWd1aBFxyH+w5l4+DB
VZI1ulcV6j5Vl0s8wMk18jw6ZKYG3aEhp7Nzcfh9+654gb4GDNsOmxx/hMP4
Xef9i5gmTMjsosjn44CcOLB4UokKf+r+9T4qwOENb8BR3XkaMN52LfcswkH4
GtuWK64IcHnUJaiV4FDzY8woshYBIW2509OlOAilCEqm8KEgzRplUlxO8leb
daTuIAoqfWMyvhUkvlyRLPrXUUDzTf6iz3FoikTunitEQT8or3exCgeriBp2
9dcomFiylle+xCGFZSY4uxoFW4lTCZdekX5w5vn1wFwUHKebPbe/xuFPxgDD
eDAKrq9VTP7WkvmslRQl70LhTOJ1mdcEidcT3Kt8DoGAYz/Wwupx+Pn00dqX
ZARCEateaCT5NxqYKaWMQOyWwjLGJhyUaUau+4/RIKmLK6GxGYeVLSJyU85U
yHh41jP2LQ5TxiJPePZqwsOAtt0W78h+VTmh1qKrAc+Fk9betZHxDO2fYGBS
A+L7XE9CB6mXoobdlBkVePtif9neLhwOeKeNTX1RhqHDgp4fe3AY/lQ5cHJW
ESbUA3an9JH4KvBMN3Erwux6t7TjANk//hwY1d2lAKsftNdEP5H6eewk8POK
PDBmp/YMDpF43kHmywfkgNP3d2nWCA4N3lbf+MzIfdvIKd5lFAf+DzSKSbMs
SAu8PEX5ioMS75EcB2dZUB4T2/11DIe++7NOamyygFQES+d+w6G1DhSjmymg
H/Ppz4nvJL9/rtQIZVJgt4NBj/IU6Tcv7k/FRFLAWvle6dQPEq+KzzsuhVLA
YXXjRsE06a/3mLYn3KDAsbcup87OkPrlEWD3LaSAZwbdmDZH9tfMkE9tnyng
70WRnp/HYd8O9+euirIQYnDlT/kiDuGpWvLjIbIQw/21O2AZh4u7RGKkJmQh
ccS4VOc3Dpo9BqrdrnKQVvLwxuoqDg6nr258mJaDnAjmU9VrZL1yrX+8vS4P
BftPGIesk/k5D7UH6ipAhVyT1K5NHLzG764FLCtA7aLSn3//cBicC5rSa1CE
/wHRd++l
       "]]},
     Annotation[#, "Charting`Private`Tag$1158732#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwUWnc81f8Xtvfe42ZzL649yvwcWYlUViVKKlIRGl9UlCKUkVGKpJIkEalQ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       "]]},
     Annotation[#, "Charting`Private`Tag$1158732#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->300,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.644628364225993*^9, {3.644628398695668*^9, 3.6446284146924963`*^9}, {
   3.644628485774969*^9, 3.644628499976039*^9}, {3.644629592049412*^9, 
   3.644629605128623*^9}, 3.644629666353833*^9, {3.644629708147983*^9, 
   3.644629740607139*^9}, {3.644630217022194*^9, 3.644630352911982*^9}, {
   3.6446304043395987`*^9, 3.64463043375661*^9}, {3.644630501574388*^9, 
   3.644630514453972*^9}, 3.644630575878381*^9, {3.644630620477693*^9, 
   3.644630648872224*^9}, {3.644630697143566*^9, 3.644630718104515*^9}, 
   3.644631199202242*^9, {3.644631264103078*^9, 3.6446312812085133`*^9}, {
   3.644631373491805*^9, 3.644631404328669*^9}, 3.644631449817308*^9, 
   3.644631648240658*^9, {3.644631879463113*^9, 3.64463191897008*^9}, 
   3.644632113797065*^9, 3.644632182422888*^9, {3.644632218136497*^9, 
   3.644632238579121*^9}, 3.64463493524683*^9, {3.644635109812669*^9, 
   3.64463513154605*^9}, 3.644635179387006*^9, {3.644635261759666*^9, 
   3.6446352858623037`*^9}, 3.6446357260090227`*^9, 3.6446364226007957`*^9, {
   3.644637285805642*^9, 3.644637305730702*^9}, 3.644637626642853*^9, {
   3.6446376576907997`*^9, 3.644637711180485*^9}, {3.644637918054577*^9, 
   3.6446379392352457`*^9}, 3.644637983372418*^9, 3.644694867299013*^9, 
   3.644695308000195*^9, 3.6470136416729507`*^9, 3.647627098139639*^9, 
   3.647627151022016*^9, {3.647627202463621*^9, 3.647627221592888*^9}, {
   3.6476276186450443`*^9, 3.6476276711128283`*^9}, {3.647627719926475*^9, 
   3.64762775638564*^9}, {3.647627844890911*^9, 3.647627874013536*^9}, 
   3.6476349186175957`*^9, {3.647634966742181*^9, 3.6476349900623283`*^9}, 
   3.793934864391157*^9, 3.8232288263031073`*^9},
 CellLabel->
  "Out[2586]=",ExpressionUUID->"2cf5a2a4-16c6-402f-a0eb-d6539afea130"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.793934845839533*^9, 3.7939348486423407`*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"3d3ee3d2-9d04-4d71-b900-c5b430a289df"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dt", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xs1t", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"xs1", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend", ",", "dt"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xs2t", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"xs2", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend", ",", "dt"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<lorenzChaos.dat\>\"", ",", 
      RowBox[{"Flatten", "/@", 
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{"xs1t", ",", "xs2t"}], "}"}], "]"}]}], ",", 
      "\"\<Table\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.6446377713828*^9, 3.644637827252647*^9}, {
   3.6446378812430058`*^9, 3.644637889430538*^9}, {3.644637922861539*^9, 
   3.644637992952765*^9}, {3.64463805079758*^9, 3.644638058330675*^9}, {
   3.6446380949749527`*^9, 3.644638100275029*^9}, {3.644695314301278*^9, 
   3.64469531682065*^9}, 3.647627140150578*^9, {3.647627819135109*^9, 
   3.647627870738265*^9}, {3.7939348188788424`*^9, 3.793934841837484*^9}},
 CellLabel->
  "In[2587]:=",ExpressionUUID->"c4a8b2c1-bf1e-432c-a157-92c0fd211734"]
}, Open  ]]
},
WindowSize->{808, 751},
WindowMargins->{{266, Automatic}, {Automatic, 48}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5af535d6-e474-440e-812c-580b772d1097"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 454, 9, 105, "Section",ExpressionUUID->"222bf219-ca00-441b-b622-39b4c84c6d52"],
Cell[1037, 33, 175, 4, 30, "Input",ExpressionUUID->"2903ebae-645f-4ba1-860d-066fecbfe816"],
Cell[CellGroupData[{
Cell[1237, 41, 5039, 128, 283, "Input",ExpressionUUID->"31379b8b-92c8-414d-9ca4-02677c36b044"],
Cell[6279, 171, 120919, 2003, 196, "Output",ExpressionUUID->"2cf5a2a4-16c6-402f-a0eb-d6539afea130"]
}, Open  ]],
Cell[127213, 2177, 183, 3, 51, "Text",ExpressionUUID->"3d3ee3d2-9d04-4d71-b900-c5b430a289df"],
Cell[127399, 2182, 1585, 40, 212, "Input",ExpressionUUID->"c4a8b2c1-bf1e-432c-a157-92c0fd211734"]
}, Open  ]]
}
]
*)

